!OCL SCALAR
SUBROUTINE RRTM_KGB3_A2

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 3:  500-630 cm-1 (low - H2O,CO2; high - H2O,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO3 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO  ,FORREFO    ,ABSN2OAO   ,ABSN2OBO
USE YOERRTA3 , ONLY : ABSN2OA ,ABSN2OB  ,ETAREF    ,H2OREF     ,&
           &N2OREF     ,CO2REF     ,STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE


!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different water vapor to CO2 ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = h2o/(h20 + (rat) * co2), where rat is the ratio of the integrated
!     line strength in the band of co2 to that of h2o.  For instance,
!     JS=1 refers to dry air (eta = 0), JS = 10 corresponds to eta = 1.0.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature
!     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 7) = (/&
&6.4013E-02_JPRB,7.3559E-02_JPRB,7.8016E-02_JPRB,7.8110E-02_JPRB,7.4963E-02_JPRB,6.8933E-02_JPRB,&
&6.0750E-02_JPRB,4.8875E-02_JPRB,3.9308E-02_JPRB,3.6560E-02_JPRB/)
KAO( :, 2, 1, 7) = (/&
&7.6363E-02_JPRB,8.7960E-02_JPRB,9.3559E-02_JPRB,9.3979E-02_JPRB,9.0734E-02_JPRB,8.3349E-02_JPRB,&
&7.3192E-02_JPRB,5.8774E-02_JPRB,4.7441E-02_JPRB,4.4036E-02_JPRB/)
KAO( :, 3, 1, 7) = (/&
&8.9758E-02_JPRB,1.0331E-01_JPRB,1.1051E-01_JPRB,1.1169E-01_JPRB,1.0769E-01_JPRB,9.8679E-02_JPRB,&
&8.6726E-02_JPRB,6.9819E-02_JPRB,5.6655E-02_JPRB,5.2675E-02_JPRB/)
KAO( :, 4, 1, 7) = (/&
&1.0433E-01_JPRB,1.2008E-01_JPRB,1.2928E-01_JPRB,1.3105E-01_JPRB,1.2576E-01_JPRB,1.1544E-01_JPRB,&
&1.0166E-01_JPRB,8.2241E-02_JPRB,6.7142E-02_JPRB,6.2520E-02_JPRB/)
KAO( :, 5, 1, 7) = (/&
&1.2001E-01_JPRB,1.3824E-01_JPRB,1.4932E-01_JPRB,1.5158E-01_JPRB,1.4526E-01_JPRB,1.3374E-01_JPRB,&
&1.1804E-01_JPRB,9.5951E-02_JPRB,7.9016E-02_JPRB,7.3734E-02_JPRB/)
KAO( :, 1, 2, 7) = (/&
&5.2968E-02_JPRB,6.2116E-02_JPRB,6.5835E-02_JPRB,6.6044E-02_JPRB,6.3294E-02_JPRB,5.8161E-02_JPRB,&
&5.1176E-02_JPRB,4.1393E-02_JPRB,3.1133E-02_JPRB,2.8255E-02_JPRB/)
KAO( :, 2, 2, 7) = (/&
&6.3728E-02_JPRB,7.4899E-02_JPRB,7.9536E-02_JPRB,8.0057E-02_JPRB,7.7101E-02_JPRB,7.0839E-02_JPRB,&
&6.2175E-02_JPRB,5.0108E-02_JPRB,3.7798E-02_JPRB,3.4182E-02_JPRB/)
KAO( :, 3, 2, 7) = (/&
&7.5532E-02_JPRB,8.8572E-02_JPRB,9.4648E-02_JPRB,9.5700E-02_JPRB,9.1973E-02_JPRB,8.4443E-02_JPRB,&
&7.4085E-02_JPRB,5.9918E-02_JPRB,4.5429E-02_JPRB,4.1069E-02_JPRB/)
KAO( :, 4, 2, 7) = (/&
&8.8404E-02_JPRB,1.0356E-01_JPRB,1.1124E-01_JPRB,1.1259E-01_JPRB,1.0798E-01_JPRB,9.9246E-02_JPRB,&
&8.7373E-02_JPRB,7.0993E-02_JPRB,5.4110E-02_JPRB,4.8926E-02_JPRB/)
KAO( :, 5, 2, 7) = (/&
&1.0235E-01_JPRB,1.2010E-01_JPRB,1.2926E-01_JPRB,1.3064E-01_JPRB,1.2537E-01_JPRB,1.1556E-01_JPRB,&
&1.0208E-01_JPRB,8.3206E-02_JPRB,6.4030E-02_JPRB,5.7947E-02_JPRB/)
KAO( :, 1, 3, 7) = (/&
&4.1735E-02_JPRB,4.9803E-02_JPRB,5.2741E-02_JPRB,5.2657E-02_JPRB,5.0249E-02_JPRB,4.6113E-02_JPRB,&
&4.0588E-02_JPRB,3.2986E-02_JPRB,2.3522E-02_JPRB,2.0886E-02_JPRB/)
KAO( :, 2, 3, 7) = (/&
&5.0841E-02_JPRB,6.0757E-02_JPRB,6.4389E-02_JPRB,6.4564E-02_JPRB,6.1844E-02_JPRB,5.6795E-02_JPRB,&
&4.9854E-02_JPRB,4.0407E-02_JPRB,2.8855E-02_JPRB,2.5442E-02_JPRB/)
KAO( :, 3, 3, 7) = (/&
&6.0889E-02_JPRB,7.2603E-02_JPRB,7.7334E-02_JPRB,7.7876E-02_JPRB,7.4574E-02_JPRB,6.8388E-02_JPRB,&
&6.0037E-02_JPRB,4.8827E-02_JPRB,3.5004E-02_JPRB,3.0751E-02_JPRB/)
KAO( :, 4, 3, 7) = (/&
&7.1992E-02_JPRB,8.5675E-02_JPRB,9.1634E-02_JPRB,9.2233E-02_JPRB,8.8356E-02_JPRB,8.1063E-02_JPRB,&
&7.1397E-02_JPRB,5.8371E-02_JPRB,4.1972E-02_JPRB,3.6821E-02_JPRB/)
KAO( :, 5, 3, 7) = (/&
&8.4144E-02_JPRB,1.0019E-01_JPRB,1.0713E-01_JPRB,1.0774E-01_JPRB,1.0345E-01_JPRB,9.5140E-02_JPRB,&
&8.4076E-02_JPRB,6.8896E-02_JPRB,4.9944E-02_JPRB,4.3832E-02_JPRB/)
KAO( :, 1, 4, 7) = (/&
&3.2154E-02_JPRB,3.8970E-02_JPRB,4.1150E-02_JPRB,4.0802E-02_JPRB,3.8734E-02_JPRB,3.5463E-02_JPRB,&
&3.1189E-02_JPRB,2.5441E-02_JPRB,1.7426E-02_JPRB,1.5348E-02_JPRB/)
KAO( :, 2, 4, 7) = (/&
&3.9739E-02_JPRB,4.8115E-02_JPRB,5.0846E-02_JPRB,5.0567E-02_JPRB,4.8188E-02_JPRB,4.4146E-02_JPRB,&
&3.8765E-02_JPRB,3.1629E-02_JPRB,2.1722E-02_JPRB,1.8824E-02_JPRB/)
KAO( :, 3, 4, 7) = (/&
&4.8232E-02_JPRB,5.8202E-02_JPRB,6.1786E-02_JPRB,6.1691E-02_JPRB,5.8769E-02_JPRB,5.3800E-02_JPRB,&
&4.7237E-02_JPRB,3.8627E-02_JPRB,2.6596E-02_JPRB,2.2906E-02_JPRB/)
KAO( :, 4, 4, 7) = (/&
&5.7693E-02_JPRB,6.9403E-02_JPRB,7.3912E-02_JPRB,7.3801E-02_JPRB,7.0370E-02_JPRB,6.4487E-02_JPRB,&
&5.6733E-02_JPRB,4.6604E-02_JPRB,3.2157E-02_JPRB,2.7582E-02_JPRB/)
KAO( :, 5, 4, 7) = (/&
&6.8162E-02_JPRB,8.1910E-02_JPRB,8.6943E-02_JPRB,8.6947E-02_JPRB,8.3116E-02_JPRB,7.6355E-02_JPRB,&
&6.7389E-02_JPRB,5.5474E-02_JPRB,3.8506E-02_JPRB,3.2984E-02_JPRB/)
KAO( :, 1, 5, 7) = (/&
&2.4543E-02_JPRB,3.0114E-02_JPRB,3.1564E-02_JPRB,3.1114E-02_JPRB,2.9453E-02_JPRB,2.6887E-02_JPRB,&
&2.3575E-02_JPRB,1.9323E-02_JPRB,1.2795E-02_JPRB,1.1691E-02_JPRB/)
KAO( :, 2, 5, 7) = (/&
&3.0843E-02_JPRB,3.7719E-02_JPRB,3.9540E-02_JPRB,3.9065E-02_JPRB,3.7079E-02_JPRB,3.3845E-02_JPRB,&
&2.9679E-02_JPRB,2.4367E-02_JPRB,1.6282E-02_JPRB,1.4283E-02_JPRB/)
KAO( :, 3, 5, 7) = (/&
&3.7989E-02_JPRB,4.6141E-02_JPRB,4.8601E-02_JPRB,4.8164E-02_JPRB,4.5691E-02_JPRB,4.1697E-02_JPRB,&
&3.6599E-02_JPRB,3.0110E-02_JPRB,2.0230E-02_JPRB,1.7316E-02_JPRB/)
KAO( :, 4, 5, 7) = (/&
&4.5997E-02_JPRB,5.5639E-02_JPRB,5.8738E-02_JPRB,5.8217E-02_JPRB,5.5293E-02_JPRB,5.0551E-02_JPRB,&
&4.4474E-02_JPRB,3.6675E-02_JPRB,2.4679E-02_JPRB,2.0824E-02_JPRB/)
KAO( :, 5, 5, 7) = (/&
&5.4980E-02_JPRB,6.6335E-02_JPRB,6.9689E-02_JPRB,6.9220E-02_JPRB,6.5934E-02_JPRB,6.0477E-02_JPRB,&
&5.3356E-02_JPRB,4.4023E-02_JPRB,2.9735E-02_JPRB,2.4925E-02_JPRB/)
KAO( :, 1, 6, 7) = (/&
&1.8426E-02_JPRB,2.2761E-02_JPRB,2.3641E-02_JPRB,2.3226E-02_JPRB,2.1929E-02_JPRB,1.9968E-02_JPRB,&
&1.7467E-02_JPRB,1.4347E-02_JPRB,9.1807E-03_JPRB,8.8441E-03_JPRB/)
KAO( :, 2, 6, 7) = (/&
&2.3578E-02_JPRB,2.9032E-02_JPRB,3.0133E-02_JPRB,2.9606E-02_JPRB,2.7996E-02_JPRB,2.5495E-02_JPRB,&
&2.2298E-02_JPRB,1.8363E-02_JPRB,1.2129E-02_JPRB,1.0950E-02_JPRB/)
KAO( :, 3, 6, 7) = (/&
&2.9507E-02_JPRB,3.6047E-02_JPRB,3.7508E-02_JPRB,3.6913E-02_JPRB,3.4886E-02_JPRB,3.1786E-02_JPRB,&
&2.7844E-02_JPRB,2.2965E-02_JPRB,1.5292E-02_JPRB,1.3409E-02_JPRB/)
KAO( :, 4, 6, 7) = (/&
&3.6266E-02_JPRB,4.4015E-02_JPRB,4.5865E-02_JPRB,4.5103E-02_JPRB,4.2675E-02_JPRB,3.8982E-02_JPRB,&
&3.4261E-02_JPRB,2.8279E-02_JPRB,1.8853E-02_JPRB,1.6214E-02_JPRB/)
KAO( :, 5, 6, 7) = (/&
&4.3984E-02_JPRB,5.3041E-02_JPRB,5.5017E-02_JPRB,5.4129E-02_JPRB,5.1429E-02_JPRB,4.7161E-02_JPRB,&
&4.1564E-02_JPRB,3.4270E-02_JPRB,2.2882E-02_JPRB,1.9446E-02_JPRB/)
KAO( :, 1, 7, 7) = (/&
&1.3764E-02_JPRB,1.6980E-02_JPRB,1.7488E-02_JPRB,1.7108E-02_JPRB,1.6106E-02_JPRB,1.4660E-02_JPRB,&
&1.2811E-02_JPRB,1.0508E-02_JPRB,6.5858E-03_JPRB,7.3979E-03_JPRB/)
KAO( :, 2, 7, 7) = (/&
&1.7905E-02_JPRB,2.2049E-02_JPRB,2.2708E-02_JPRB,2.2213E-02_JPRB,2.0912E-02_JPRB,1.9015E-02_JPRB,&
&1.6594E-02_JPRB,1.3616E-02_JPRB,8.9925E-03_JPRB,8.9127E-03_JPRB/)
KAO( :, 3, 7, 7) = (/&
&2.2781E-02_JPRB,2.7834E-02_JPRB,2.8707E-02_JPRB,2.8089E-02_JPRB,2.6436E-02_JPRB,2.4036E-02_JPRB,&
&2.1001E-02_JPRB,1.7243E-02_JPRB,1.1550E-02_JPRB,1.0727E-02_JPRB/)
KAO( :, 4, 7, 7) = (/&
&2.8466E-02_JPRB,3.4473E-02_JPRB,3.5499E-02_JPRB,3.4681E-02_JPRB,3.2695E-02_JPRB,2.9803E-02_JPRB,&
&2.6138E-02_JPRB,2.1504E-02_JPRB,1.4432E-02_JPRB,1.2888E-02_JPRB/)
KAO( :, 5, 7, 7) = (/&
&3.5087E-02_JPRB,4.2091E-02_JPRB,4.3096E-02_JPRB,4.2057E-02_JPRB,3.9781E-02_JPRB,3.6456E-02_JPRB,&
&3.2089E-02_JPRB,2.6356E-02_JPRB,1.7665E-02_JPRB,1.5419E-02_JPRB/)
KAO( :, 1, 8, 7) = (/&
&1.0353E-02_JPRB,1.2614E-02_JPRB,1.2882E-02_JPRB,1.2507E-02_JPRB,1.1737E-02_JPRB,1.0675E-02_JPRB,&
&9.3093E-03_JPRB,7.6257E-03_JPRB,4.6116E-03_JPRB,7.3615E-03_JPRB/)
KAO( :, 2, 8, 7) = (/&
&1.3587E-02_JPRB,1.6625E-02_JPRB,1.6988E-02_JPRB,1.6539E-02_JPRB,1.5521E-02_JPRB,1.4075E-02_JPRB,&
&1.2252E-02_JPRB,1.0008E-02_JPRB,6.5742E-03_JPRB,8.8183E-03_JPRB/)
KAO( :, 3, 8, 7) = (/&
&1.7551E-02_JPRB,2.1310E-02_JPRB,2.1821E-02_JPRB,2.1262E-02_JPRB,1.9937E-02_JPRB,1.8066E-02_JPRB,&
&1.5721E-02_JPRB,1.2839E-02_JPRB,8.6653E-03_JPRB,1.0458E-02_JPRB/)
KAO( :, 4, 8, 7) = (/&
&2.2265E-02_JPRB,2.6814E-02_JPRB,2.7357E-02_JPRB,2.6600E-02_JPRB,2.4976E-02_JPRB,2.2670E-02_JPRB,&
&1.9796E-02_JPRB,1.6193E-02_JPRB,1.0979E-02_JPRB,1.2332E-02_JPRB/)
KAO( :, 5, 8, 7) = (/&
&2.7862E-02_JPRB,3.3218E-02_JPRB,3.3662E-02_JPRB,3.2634E-02_JPRB,3.0703E-02_JPRB,2.8021E-02_JPRB,&
&2.4581E-02_JPRB,2.0102E-02_JPRB,1.3589E-02_JPRB,1.4413E-02_JPRB/)
KAO( :, 1, 9, 7) = (/&
&7.8781E-03_JPRB,9.4357E-03_JPRB,9.5082E-03_JPRB,9.1567E-03_JPRB,8.5455E-03_JPRB,7.7115E-03_JPRB,&
&6.6987E-03_JPRB,5.4668E-03_JPRB,3.2375E-03_JPRB,1.0690E-02_JPRB/)
KAO( :, 2, 9, 7) = (/&
&1.0378E-02_JPRB,1.2532E-02_JPRB,1.2692E-02_JPRB,1.2260E-02_JPRB,1.1450E-02_JPRB,1.0342E-02_JPRB,&
&8.9582E-03_JPRB,7.2956E-03_JPRB,4.7236E-03_JPRB,1.2330E-02_JPRB/)
KAO( :, 3, 9, 7) = (/&
&1.3495E-02_JPRB,1.6270E-02_JPRB,1.6516E-02_JPRB,1.6000E-02_JPRB,1.4955E-02_JPRB,1.3485E-02_JPRB,&
&1.1675E-02_JPRB,9.4744E-03_JPRB,6.3929E-03_JPRB,1.4160E-02_JPRB/)
KAO( :, 4, 9, 7) = (/&
&1.7315E-02_JPRB,2.0761E-02_JPRB,2.1026E-02_JPRB,2.0326E-02_JPRB,1.9009E-02_JPRB,1.7164E-02_JPRB,&
&1.4884E-02_JPRB,1.2091E-02_JPRB,8.2532E-03_JPRB,1.6229E-02_JPRB/)
KAO( :, 5, 9, 7) = (/&
&2.1950E-02_JPRB,2.6079E-02_JPRB,2.6242E-02_JPRB,2.5301E-02_JPRB,2.3645E-02_JPRB,2.1443E-02_JPRB,&
&1.8684E-02_JPRB,1.5203E-02_JPRB,1.0361E-02_JPRB,1.8623E-02_JPRB/)
KAO( :, 1,10, 7) = (/&
&6.0912E-03_JPRB,7.2618E-03_JPRB,7.2497E-03_JPRB,6.9368E-03_JPRB,6.4251E-03_JPRB,5.7381E-03_JPRB,&
&4.9224E-03_JPRB,3.9870E-03_JPRB,2.3279E-03_JPRB,2.4406E-02_JPRB/)
KAO( :, 2,10, 7) = (/&
&8.1237E-03_JPRB,9.7061E-03_JPRB,9.7375E-03_JPRB,9.3388E-03_JPRB,8.6591E-03_JPRB,7.7505E-03_JPRB,&
&6.6642E-03_JPRB,5.3997E-03_JPRB,3.3513E-03_JPRB,2.6559E-02_JPRB/)
KAO( :, 3,10, 7) = (/&
&1.0643E-02_JPRB,1.2680E-02_JPRB,1.2767E-02_JPRB,1.2292E-02_JPRB,1.1416E-02_JPRB,1.0235E-02_JPRB,&
&8.8042E-03_JPRB,7.1077E-03_JPRB,4.7423E-03_JPRB,2.9166E-02_JPRB/)
KAO( :, 4,10, 7) = (/&
&1.3745E-02_JPRB,1.6327E-02_JPRB,1.6432E-02_JPRB,1.5803E-02_JPRB,1.4680E-02_JPRB,1.3196E-02_JPRB,&
&1.1368E-02_JPRB,9.1591E-03_JPRB,6.2576E-03_JPRB,3.2140E-02_JPRB/)
KAO( :, 5,10, 7) = (/&
&1.7515E-02_JPRB,2.0726E-02_JPRB,2.0778E-02_JPRB,1.9936E-02_JPRB,1.8503E-02_JPRB,1.6679E-02_JPRB,&
&1.4419E-02_JPRB,1.1642E-02_JPRB,7.9656E-03_JPRB,3.5445E-02_JPRB/)
KAO( :, 1,11, 7) = (/&
&5.3549E-03_JPRB,6.3816E-03_JPRB,6.3660E-03_JPRB,6.0840E-03_JPRB,5.6156E-03_JPRB,4.9825E-03_JPRB,&
&4.2303E-03_JPRB,3.3795E-03_JPRB,1.9749E-03_JPRB,3.2367E-02_JPRB/)
KAO( :, 2,11, 7) = (/&
&7.2013E-03_JPRB,8.5604E-03_JPRB,8.5532E-03_JPRB,8.1763E-03_JPRB,7.5421E-03_JPRB,6.6997E-03_JPRB,&
&5.7065E-03_JPRB,4.5729E-03_JPRB,2.8632E-03_JPRB,3.5196E-02_JPRB/)
KAO( :, 3,11, 7) = (/&
&9.5022E-03_JPRB,1.1202E-02_JPRB,1.1204E-02_JPRB,1.0716E-02_JPRB,9.9000E-03_JPRB,8.8230E-03_JPRB,&
&7.5394E-03_JPRB,6.0331E-03_JPRB,4.0236E-03_JPRB,3.8638E-02_JPRB/)
KAO( :, 4,11, 7) = (/&
&1.2288E-02_JPRB,1.4432E-02_JPRB,1.4424E-02_JPRB,1.3791E-02_JPRB,1.2735E-02_JPRB,1.1387E-02_JPRB,&
&9.7608E-03_JPRB,7.8103E-03_JPRB,5.3234E-03_JPRB,4.2507E-02_JPRB/)
KAO( :, 5,11, 7) = (/&
&1.5567E-02_JPRB,1.8295E-02_JPRB,1.8261E-02_JPRB,1.7460E-02_JPRB,1.6145E-02_JPRB,1.4469E-02_JPRB,&
&1.2448E-02_JPRB,9.9477E-03_JPRB,6.7800E-03_JPRB,4.6703E-02_JPRB/)
KAO( :, 1,12, 7) = (/&
&4.6610E-03_JPRB,5.5454E-03_JPRB,5.5315E-03_JPRB,5.2838E-03_JPRB,4.8759E-03_JPRB,4.3254E-03_JPRB,&
&3.6583E-03_JPRB,2.8821E-03_JPRB,1.6681E-03_JPRB,3.4347E-02_JPRB/)
KAO( :, 2,12, 7) = (/&
&6.3285E-03_JPRB,7.4864E-03_JPRB,7.4682E-03_JPRB,7.1266E-03_JPRB,6.5590E-03_JPRB,5.8111E-03_JPRB,&
&4.9232E-03_JPRB,3.8901E-03_JPRB,2.4263E-03_JPRB,3.7723E-02_JPRB/)
KAO( :, 3,12, 7) = (/&
&8.4114E-03_JPRB,9.8725E-03_JPRB,9.8303E-03_JPRB,9.3562E-03_JPRB,8.6044E-03_JPRB,7.6370E-03_JPRB,&
&6.4946E-03_JPRB,5.1447E-03_JPRB,3.4144E-03_JPRB,4.1645E-02_JPRB/)
KAO( :, 4,12, 7) = (/&
&1.0877E-02_JPRB,1.2730E-02_JPRB,1.2662E-02_JPRB,1.2056E-02_JPRB,1.1093E-02_JPRB,9.8741E-03_JPRB,&
&8.4352E-03_JPRB,6.6865E-03_JPRB,4.5146E-03_JPRB,4.5836E-02_JPRB/)
KAO( :, 5,12, 7) = (/&
&1.3747E-02_JPRB,1.6074E-02_JPRB,1.5983E-02_JPRB,1.5257E-02_JPRB,1.4098E-02_JPRB,1.2612E-02_JPRB,&
&1.0799E-02_JPRB,8.5347E-03_JPRB,5.7461E-03_JPRB,5.0295E-02_JPRB/)
KAO( :, 1,13, 7) = (/&
&4.0079E-03_JPRB,4.7560E-03_JPRB,4.7417E-03_JPRB,4.5251E-03_JPRB,4.1763E-03_JPRB,3.7162E-03_JPRB,&
&3.1488E-03_JPRB,2.4610E-03_JPRB,1.3983E-03_JPRB,2.9797E-02_JPRB/)
KAO( :, 2,13, 7) = (/&
&5.4975E-03_JPRB,6.4791E-03_JPRB,6.4467E-03_JPRB,6.1399E-03_JPRB,5.6502E-03_JPRB,5.0140E-03_JPRB,&
&4.2451E-03_JPRB,3.3175E-03_JPRB,2.0465E-03_JPRB,3.3074E-02_JPRB/)
KAO( :, 3,13, 7) = (/&
&7.3173E-03_JPRB,8.5913E-03_JPRB,8.5377E-03_JPRB,8.1192E-03_JPRB,7.4539E-03_JPRB,6.6075E-03_JPRB,&
&5.6063E-03_JPRB,4.3940E-03_JPRB,2.8772E-03_JPRB,3.6709E-02_JPRB/)
KAO( :, 4,13, 7) = (/&
&9.4743E-03_JPRB,1.1090E-02_JPRB,1.1002E-02_JPRB,1.0468E-02_JPRB,9.6356E-03_JPRB,8.5792E-03_JPRB,&
&7.2993E-03_JPRB,5.7314E-03_JPRB,3.8025E-03_JPRB,4.0547E-02_JPRB/)
KAO( :, 5,13, 7) = (/&
&1.2013E-02_JPRB,1.3994E-02_JPRB,1.3879E-02_JPRB,1.3228E-02_JPRB,1.2234E-02_JPRB,1.0964E-02_JPRB,&
&9.3662E-03_JPRB,7.3363E-03_JPRB,4.8412E-03_JPRB,4.4593E-02_JPRB/)
KAO( :, 1, 1, 8) = (/&
&1.6043E-01_JPRB,1.5955E-01_JPRB,1.5744E-01_JPRB,1.5203E-01_JPRB,1.4391E-01_JPRB,1.3266E-01_JPRB,&
&1.1826E-01_JPRB,1.0647E-01_JPRB,1.0371E-01_JPRB,1.0144E-01_JPRB/)
KAO( :, 2, 1, 8) = (/&
&1.9219E-01_JPRB,1.9200E-01_JPRB,1.8944E-01_JPRB,1.8309E-01_JPRB,1.7324E-01_JPRB,1.6054E-01_JPRB,&
&1.4443E-01_JPRB,1.3095E-01_JPRB,1.2672E-01_JPRB,1.2410E-01_JPRB/)
KAO( :, 3, 1, 8) = (/&
&2.2629E-01_JPRB,2.2700E-01_JPRB,2.2424E-01_JPRB,2.1719E-01_JPRB,2.0625E-01_JPRB,1.9280E-01_JPRB,&
&1.7410E-01_JPRB,1.5851E-01_JPRB,1.5238E-01_JPRB,1.4924E-01_JPRB/)
KAO( :, 4, 1, 8) = (/&
&2.6302E-01_JPRB,2.6487E-01_JPRB,2.6214E-01_JPRB,2.5470E-01_JPRB,2.4371E-01_JPRB,2.2882E-01_JPRB,&
&2.0692E-01_JPRB,1.8914E-01_JPRB,1.8098E-01_JPRB,1.7748E-01_JPRB/)
KAO( :, 5, 1, 8) = (/&
&3.0195E-01_JPRB,3.0538E-01_JPRB,3.0299E-01_JPRB,2.9584E-01_JPRB,2.8471E-01_JPRB,2.6793E-01_JPRB,&
&2.4285E-01_JPRB,2.2301E-01_JPRB,2.1336E-01_JPRB,2.0952E-01_JPRB/)
KAO( :, 1, 2, 8) = (/&
&1.3846E-01_JPRB,1.4022E-01_JPRB,1.4003E-01_JPRB,1.3582E-01_JPRB,1.2900E-01_JPRB,1.1965E-01_JPRB,&
&1.0668E-01_JPRB,9.1059E-02_JPRB,8.5585E-02_JPRB,8.1636E-02_JPRB/)
KAO( :, 2, 2, 8) = (/&
&1.6715E-01_JPRB,1.6985E-01_JPRB,1.6971E-01_JPRB,1.6484E-01_JPRB,1.5668E-01_JPRB,1.4564E-01_JPRB,&
&1.3093E-01_JPRB,1.1285E-01_JPRB,1.0555E-01_JPRB,1.0079E-01_JPRB/)
KAO( :, 3, 2, 8) = (/&
&1.9803E-01_JPRB,2.0244E-01_JPRB,2.0211E-01_JPRB,1.9690E-01_JPRB,1.8801E-01_JPRB,1.7558E-01_JPRB,&
&1.5851E-01_JPRB,1.3719E-01_JPRB,1.2761E-01_JPRB,1.2193E-01_JPRB/)
KAO( :, 4, 2, 8) = (/&
&2.3133E-01_JPRB,2.3777E-01_JPRB,2.3782E-01_JPRB,2.3254E-01_JPRB,2.2351E-01_JPRB,2.0946E-01_JPRB,&
&1.8890E-01_JPRB,1.6397E-01_JPRB,1.5196E-01_JPRB,1.4557E-01_JPRB/)
KAO( :, 5, 2, 8) = (/&
&2.6711E-01_JPRB,2.7542E-01_JPRB,2.7668E-01_JPRB,2.7185E-01_JPRB,2.6232E-01_JPRB,2.4621E-01_JPRB,&
&2.2197E-01_JPRB,1.9371E-01_JPRB,1.7953E-01_JPRB,1.7231E-01_JPRB/)
KAO( :, 1, 3, 8) = (/&
&1.1272E-01_JPRB,1.1648E-01_JPRB,1.1742E-01_JPRB,1.1452E-01_JPRB,1.0929E-01_JPRB,1.0158E-01_JPRB,&
&9.0376E-02_JPRB,7.4637E-02_JPRB,6.6429E-02_JPRB,6.1506E-02_JPRB/)
KAO( :, 2, 3, 8) = (/&
&1.3749E-01_JPRB,1.4273E-01_JPRB,1.4386E-01_JPRB,1.4052E-01_JPRB,1.3417E-01_JPRB,1.2510E-01_JPRB,&
&1.1193E-01_JPRB,9.3361E-02_JPRB,8.2893E-02_JPRB,7.6819E-02_JPRB/)
KAO( :, 3, 3, 8) = (/&
&1.6469E-01_JPRB,1.7179E-01_JPRB,1.7314E-01_JPRB,1.6944E-01_JPRB,1.6261E-01_JPRB,1.5216E-01_JPRB,&
&1.3674E-01_JPRB,1.1431E-01_JPRB,1.0110E-01_JPRB,9.3702E-02_JPRB/)
KAO( :, 4, 3, 8) = (/&
&1.9422E-01_JPRB,2.0356E-01_JPRB,2.0555E-01_JPRB,2.0203E-01_JPRB,1.9491E-01_JPRB,1.8285E-01_JPRB,&
&1.6414E-01_JPRB,1.3754E-01_JPRB,1.2151E-01_JPRB,1.1286E-01_JPRB/)
KAO( :, 5, 3, 8) = (/&
&2.2623E-01_JPRB,2.3781E-01_JPRB,2.4116E-01_JPRB,2.3829E-01_JPRB,2.3049E-01_JPRB,2.1610E-01_JPRB,&
&1.9397E-01_JPRB,1.6347E-01_JPRB,1.4442E-01_JPRB,1.3449E-01_JPRB/)
KAO( :, 1, 4, 8) = (/&
&8.9051E-02_JPRB,9.4148E-02_JPRB,9.5376E-02_JPRB,9.3490E-02_JPRB,8.9564E-02_JPRB,8.3123E-02_JPRB,&
&7.3825E-02_JPRB,6.0440E-02_JPRB,5.0018E-02_JPRB,4.5241E-02_JPRB/)
KAO( :, 2, 4, 8) = (/&
&1.0984E-01_JPRB,1.1667E-01_JPRB,1.1837E-01_JPRB,1.1624E-01_JPRB,1.1142E-01_JPRB,1.0383E-01_JPRB,&
&9.2686E-02_JPRB,7.6384E-02_JPRB,6.3307E-02_JPRB,5.7158E-02_JPRB/)
KAO( :, 3, 4, 8) = (/&
&1.3321E-01_JPRB,1.4188E-01_JPRB,1.4403E-01_JPRB,1.4173E-01_JPRB,1.3641E-01_JPRB,1.2779E-01_JPRB,&
&1.1439E-01_JPRB,9.4375E-02_JPRB,7.8066E-02_JPRB,7.0497E-02_JPRB/)
KAO( :, 4, 4, 8) = (/&
&1.5891E-01_JPRB,1.6984E-01_JPRB,1.7265E-01_JPRB,1.7069E-01_JPRB,1.6497E-01_JPRB,1.5505E-01_JPRB,&
&1.3862E-01_JPRB,1.1439E-01_JPRB,9.4690E-02_JPRB,8.5635E-02_JPRB/)
KAO( :, 5, 4, 8) = (/&
&1.8690E-01_JPRB,2.0031E-01_JPRB,2.0459E-01_JPRB,2.0306E-01_JPRB,1.9673E-01_JPRB,1.8463E-01_JPRB,&
&1.6524E-01_JPRB,1.3669E-01_JPRB,1.1330E-01_JPRB,1.0289E-01_JPRB/)
KAO( :, 1, 5, 8) = (/&
&6.9203E-02_JPRB,7.4779E-02_JPRB,7.5983E-02_JPRB,7.4840E-02_JPRB,7.1567E-02_JPRB,6.6398E-02_JPRB,&
&5.8865E-02_JPRB,4.8193E-02_JPRB,3.7188E-02_JPRB,3.3169E-02_JPRB/)
KAO( :, 2, 5, 8) = (/&
&8.6430E-02_JPRB,9.3817E-02_JPRB,9.5587E-02_JPRB,9.4322E-02_JPRB,9.0456E-02_JPRB,8.4124E-02_JPRB,&
&7.5016E-02_JPRB,6.1615E-02_JPRB,4.7744E-02_JPRB,4.2317E-02_JPRB/)
KAO( :, 3, 5, 8) = (/&
&1.0608E-01_JPRB,1.1542E-01_JPRB,1.1772E-01_JPRB,1.1636E-01_JPRB,1.1218E-01_JPRB,1.0479E-01_JPRB,&
&9.3784E-02_JPRB,7.6996E-02_JPRB,5.9545E-02_JPRB,5.2656E-02_JPRB/)
KAO( :, 4, 5, 8) = (/&
&1.2808E-01_JPRB,1.3974E-01_JPRB,1.4262E-01_JPRB,1.4148E-01_JPRB,1.3703E-01_JPRB,1.2845E-01_JPRB,&
&1.1485E-01_JPRB,9.4184E-02_JPRB,7.2838E-02_JPRB,6.4516E-02_JPRB/)
KAO( :, 5, 5, 8) = (/&
&1.5224E-01_JPRB,1.6648E-01_JPRB,1.7081E-01_JPRB,1.6990E-01_JPRB,1.6471E-01_JPRB,1.5442E-01_JPRB,&
&1.3821E-01_JPRB,1.1347E-01_JPRB,8.7956E-02_JPRB,7.8195E-02_JPRB/)
KAO( :, 1, 6, 8) = (/&
&5.2711E-02_JPRB,5.7994E-02_JPRB,5.9096E-02_JPRB,5.8090E-02_JPRB,5.5430E-02_JPRB,5.1354E-02_JPRB,&
&4.5515E-02_JPRB,3.7271E-02_JPRB,2.7030E-02_JPRB,2.5040E-02_JPRB/)
KAO( :, 2, 6, 8) = (/&
&6.6719E-02_JPRB,7.3700E-02_JPRB,7.5367E-02_JPRB,7.4311E-02_JPRB,7.1156E-02_JPRB,6.6068E-02_JPRB,&
&5.8853E-02_JPRB,4.8369E-02_JPRB,3.5301E-02_JPRB,3.1744E-02_JPRB/)
KAO( :, 3, 6, 8) = (/&
&8.2863E-02_JPRB,9.1758E-02_JPRB,9.3947E-02_JPRB,9.2979E-02_JPRB,8.9500E-02_JPRB,8.3468E-02_JPRB,&
&7.4609E-02_JPRB,6.1328E-02_JPRB,4.4683E-02_JPRB,3.9440E-02_JPRB/)
KAO( :, 4, 6, 8) = (/&
&1.0132E-01_JPRB,1.1234E-01_JPRB,1.1520E-01_JPRB,1.1443E-01_JPRB,1.1059E-01_JPRB,1.0353E-01_JPRB,&
&9.2489E-02_JPRB,7.5833E-02_JPRB,5.5318E-02_JPRB,4.8406E-02_JPRB/)
KAO( :, 5, 6, 8) = (/&
&1.2185E-01_JPRB,1.3538E-01_JPRB,1.3945E-01_JPRB,1.3895E-01_JPRB,1.3433E-01_JPRB,1.2572E-01_JPRB,&
&1.1243E-01_JPRB,9.2112E-02_JPRB,6.7492E-02_JPRB,5.8870E-02_JPRB/)
KAO( :, 1, 7, 8) = (/&
&3.9562E-02_JPRB,4.4276E-02_JPRB,4.5109E-02_JPRB,4.4187E-02_JPRB,4.2082E-02_JPRB,3.8859E-02_JPRB,&
&3.4454E-02_JPRB,2.8224E-02_JPRB,1.9384E-02_JPRB,1.9321E-02_JPRB/)
KAO( :, 2, 7, 8) = (/&
&5.0879E-02_JPRB,5.7055E-02_JPRB,5.8399E-02_JPRB,5.7367E-02_JPRB,5.4802E-02_JPRB,5.0789E-02_JPRB,&
&4.5232E-02_JPRB,3.7273E-02_JPRB,2.5806E-02_JPRB,2.4869E-02_JPRB/)
KAO( :, 3, 7, 8) = (/&
&6.4003E-02_JPRB,7.1996E-02_JPRB,7.3764E-02_JPRB,7.2774E-02_JPRB,6.9847E-02_JPRB,6.5078E-02_JPRB,&
&5.8125E-02_JPRB,4.7947E-02_JPRB,3.3205E-02_JPRB,3.1173E-02_JPRB/)
KAO( :, 4, 7, 8) = (/&
&7.9173E-02_JPRB,8.9239E-02_JPRB,9.1617E-02_JPRB,9.0750E-02_JPRB,8.7396E-02_JPRB,8.1720E-02_JPRB,&
&7.3031E-02_JPRB,6.0013E-02_JPRB,4.1674E-02_JPRB,3.8297E-02_JPRB/)
KAO( :, 5, 7, 8) = (/&
&9.6350E-02_JPRB,1.0877E-01_JPRB,1.1214E-01_JPRB,1.1148E-01_JPRB,1.0740E-01_JPRB,1.0030E-01_JPRB,&
&8.9645E-02_JPRB,7.3703E-02_JPRB,5.1413E-02_JPRB,4.6217E-02_JPRB/)
KAO( :, 1, 8, 8) = (/&
&2.9374E-02_JPRB,3.3358E-02_JPRB,3.3910E-02_JPRB,3.3176E-02_JPRB,3.1488E-02_JPRB,2.9002E-02_JPRB,&
&2.5651E-02_JPRB,2.0998E-02_JPRB,1.3790E-02_JPRB,1.7931E-02_JPRB/)
KAO( :, 2, 8, 8) = (/&
&3.8453E-02_JPRB,4.3732E-02_JPRB,4.4619E-02_JPRB,4.3676E-02_JPRB,4.1586E-02_JPRB,3.8491E-02_JPRB,&
&3.4234E-02_JPRB,2.8236E-02_JPRB,1.8826E-02_JPRB,2.1882E-02_JPRB/)
KAO( :, 3, 8, 8) = (/&
&4.9075E-02_JPRB,5.5936E-02_JPRB,5.7139E-02_JPRB,5.6138E-02_JPRB,5.3708E-02_JPRB,4.9953E-02_JPRB,&
&4.4646E-02_JPRB,3.6887E-02_JPRB,2.4662E-02_JPRB,2.6591E-02_JPRB/)
KAO( :, 4, 8, 8) = (/&
&6.1437E-02_JPRB,7.0140E-02_JPRB,7.1902E-02_JPRB,7.0919E-02_JPRB,6.8027E-02_JPRB,6.3508E-02_JPRB,&
&5.6793E-02_JPRB,4.6822E-02_JPRB,3.1405E-02_JPRB,3.2120E-02_JPRB/)
KAO( :, 5, 8, 8) = (/&
&7.5648E-02_JPRB,8.6455E-02_JPRB,8.9059E-02_JPRB,8.8138E-02_JPRB,8.4612E-02_JPRB,7.8826E-02_JPRB,&
&7.0474E-02_JPRB,5.8121E-02_JPRB,3.9203E-02_JPRB,3.8693E-02_JPRB/)
KAO( :, 1, 9, 8) = (/&
&2.1631E-02_JPRB,2.4762E-02_JPRB,2.5091E-02_JPRB,2.4519E-02_JPRB,2.3245E-02_JPRB,2.1343E-02_JPRB,&
&1.8810E-02_JPRB,1.5373E-02_JPRB,9.7641E-03_JPRB,2.9273E-02_JPRB/)
KAO( :, 2, 9, 8) = (/&
&2.8813E-02_JPRB,3.3084E-02_JPRB,3.3621E-02_JPRB,3.2842E-02_JPRB,3.1201E-02_JPRB,2.8769E-02_JPRB,&
&2.5516E-02_JPRB,2.1018E-02_JPRB,1.3707E-02_JPRB,3.3813E-02_JPRB/)
KAO( :, 3, 9, 8) = (/&
&3.7408E-02_JPRB,4.2984E-02_JPRB,4.3696E-02_JPRB,4.2737E-02_JPRB,4.0787E-02_JPRB,3.7847E-02_JPRB,&
&3.3777E-02_JPRB,2.7905E-02_JPRB,1.8311E-02_JPRB,3.9010E-02_JPRB/)
KAO( :, 4, 9, 8) = (/&
&4.7502E-02_JPRB,5.4598E-02_JPRB,5.5650E-02_JPRB,5.4654E-02_JPRB,5.2292E-02_JPRB,4.8701E-02_JPRB,&
&4.3528E-02_JPRB,3.5956E-02_JPRB,2.3660E-02_JPRB,4.4684E-02_JPRB/)
KAO( :, 5, 9, 8) = (/&
&5.9184E-02_JPRB,6.8075E-02_JPRB,6.9737E-02_JPRB,6.8716E-02_JPRB,6.5788E-02_JPRB,6.1148E-02_JPRB,&
&5.4664E-02_JPRB,4.5216E-02_JPRB,2.9878E-02_JPRB,5.0829E-02_JPRB/)
KAO( :, 1,10, 8) = (/&
&1.6420E-02_JPRB,1.8693E-02_JPRB,1.8856E-02_JPRB,1.8334E-02_JPRB,1.7341E-02_JPRB,1.5930E-02_JPRB,&
&1.4013E-02_JPRB,1.1403E-02_JPRB,7.0640E-03_JPRB,7.0532E-02_JPRB/)
KAO( :, 2,10, 8) = (/&
&2.2040E-02_JPRB,2.5317E-02_JPRB,2.5632E-02_JPRB,2.5009E-02_JPRB,2.3702E-02_JPRB,2.1797E-02_JPRB,&
&1.9273E-02_JPRB,1.5810E-02_JPRB,1.0204E-02_JPRB,7.6827E-02_JPRB/)
KAO( :, 3,10, 8) = (/&
&2.8968E-02_JPRB,3.3418E-02_JPRB,3.3805E-02_JPRB,3.2963E-02_JPRB,3.1358E-02_JPRB,2.9007E-02_JPRB,&
&2.5810E-02_JPRB,2.1266E-02_JPRB,1.3886E-02_JPRB,8.3691E-02_JPRB/)
KAO( :, 4,10, 8) = (/&
&3.7285E-02_JPRB,4.3000E-02_JPRB,4.3529E-02_JPRB,4.2562E-02_JPRB,4.0635E-02_JPRB,3.7704E-02_JPRB,&
&3.3617E-02_JPRB,2.7781E-02_JPRB,1.8177E-02_JPRB,9.1457E-02_JPRB/)
KAO( :, 5,10, 8) = (/&
&4.7085E-02_JPRB,5.4248E-02_JPRB,5.5089E-02_JPRB,5.4027E-02_JPRB,5.1573E-02_JPRB,4.7828E-02_JPRB,&
&4.2671E-02_JPRB,3.5326E-02_JPRB,2.3198E-02_JPRB,9.9898E-02_JPRB/)
KAO( :, 1,11, 8) = (/&
&1.4563E-02_JPRB,1.6480E-02_JPRB,1.6520E-02_JPRB,1.5972E-02_JPRB,1.5054E-02_JPRB,1.3800E-02_JPRB,&
&1.2151E-02_JPRB,9.8498E-03_JPRB,6.1529E-03_JPRB,9.3025E-02_JPRB/)
KAO( :, 2,11, 8) = (/&
&1.9422E-02_JPRB,2.2230E-02_JPRB,2.2365E-02_JPRB,2.1742E-02_JPRB,2.0575E-02_JPRB,1.8920E-02_JPRB,&
&1.6702E-02_JPRB,1.3649E-02_JPRB,8.8593E-03_JPRB,9.9753E-02_JPRB/)
KAO( :, 3,11, 8) = (/&
&2.5471E-02_JPRB,2.9351E-02_JPRB,2.9545E-02_JPRB,2.8766E-02_JPRB,2.7276E-02_JPRB,2.5150E-02_JPRB,&
&2.2319E-02_JPRB,1.8330E-02_JPRB,1.2044E-02_JPRB,1.0708E-01_JPRB/)
KAO( :, 4,11, 8) = (/&
&3.2877E-02_JPRB,3.7913E-02_JPRB,3.8172E-02_JPRB,3.7200E-02_JPRB,3.5345E-02_JPRB,3.2640E-02_JPRB,&
&2.9010E-02_JPRB,2.3912E-02_JPRB,1.5750E-02_JPRB,1.1551E-01_JPRB/)
KAO( :, 5,11, 8) = (/&
&4.1783E-02_JPRB,4.8070E-02_JPRB,4.8478E-02_JPRB,4.7211E-02_JPRB,4.4842E-02_JPRB,4.1431E-02_JPRB,&
&3.6822E-02_JPRB,3.0426E-02_JPRB,2.0117E-02_JPRB,1.2493E-01_JPRB/)
KAO( :, 1,12, 8) = (/&
&1.2968E-02_JPRB,1.4613E-02_JPRB,1.4518E-02_JPRB,1.3965E-02_JPRB,1.3108E-02_JPRB,1.1965E-02_JPRB,&
&1.0480E-02_JPRB,8.4661E-03_JPRB,5.3281E-03_JPRB,9.6224E-02_JPRB/)
KAO( :, 2,12, 8) = (/&
&1.7226E-02_JPRB,1.9607E-02_JPRB,1.9589E-02_JPRB,1.8955E-02_JPRB,1.7877E-02_JPRB,1.6390E-02_JPRB,&
&1.4401E-02_JPRB,1.1714E-02_JPRB,7.6423E-03_JPRB,1.0281E-01_JPRB/)
KAO( :, 3,12, 8) = (/&
&2.2561E-02_JPRB,2.5832E-02_JPRB,2.5887E-02_JPRB,2.5130E-02_JPRB,2.3746E-02_JPRB,2.1760E-02_JPRB,&
&1.9184E-02_JPRB,1.5701E-02_JPRB,1.0359E-02_JPRB,1.1042E-01_JPRB/)
KAO( :, 4,12, 8) = (/&
&2.9208E-02_JPRB,3.3517E-02_JPRB,3.3592E-02_JPRB,3.2561E-02_JPRB,3.0751E-02_JPRB,2.8221E-02_JPRB,&
&2.4906E-02_JPRB,2.0465E-02_JPRB,1.3564E-02_JPRB,1.1943E-01_JPRB/)
KAO( :, 5,12, 8) = (/&
&3.7315E-02_JPRB,4.2782E-02_JPRB,4.2863E-02_JPRB,4.1414E-02_JPRB,3.9083E-02_JPRB,3.5863E-02_JPRB,&
&3.1661E-02_JPRB,2.6087E-02_JPRB,1.7348E-02_JPRB,1.2941E-01_JPRB/)
KAO( :, 1,13, 8) = (/&
&1.1431E-02_JPRB,1.2896E-02_JPRB,1.2736E-02_JPRB,1.2199E-02_JPRB,1.1402E-02_JPRB,1.0345E-02_JPRB,&
&9.0003E-03_JPRB,7.2287E-03_JPRB,4.5824E-03_JPRB,8.0519E-02_JPRB/)
KAO( :, 2,13, 8) = (/&
&1.5206E-02_JPRB,1.7258E-02_JPRB,1.7158E-02_JPRB,1.6539E-02_JPRB,1.5531E-02_JPRB,1.4140E-02_JPRB,&
&1.2338E-02_JPRB,9.9830E-03_JPRB,6.5464E-03_JPRB,8.6863E-02_JPRB/)
KAO( :, 3,13, 8) = (/&
&1.9972E-02_JPRB,2.2777E-02_JPRB,2.2713E-02_JPRB,2.1940E-02_JPRB,2.0631E-02_JPRB,1.8770E-02_JPRB,&
&1.6415E-02_JPRB,1.3364E-02_JPRB,8.8693E-03_JPRB,9.4420E-02_JPRB/)
KAO( :, 4,13, 8) = (/&
&2.5947E-02_JPRB,2.9698E-02_JPRB,2.9634E-02_JPRB,2.8542E-02_JPRB,2.6762E-02_JPRB,2.4361E-02_JPRB,&
&2.1338E-02_JPRB,1.7424E-02_JPRB,1.1633E-02_JPRB,1.0329E-01_JPRB/)
KAO( :, 5,13, 8) = (/&
&3.3342E-02_JPRB,3.8082E-02_JPRB,3.7942E-02_JPRB,3.6482E-02_JPRB,3.4168E-02_JPRB,3.1080E-02_JPRB,&
&2.7224E-02_JPRB,2.2266E-02_JPRB,1.4896E-02_JPRB,1.1299E-01_JPRB/)
KAO( :, 1, 1, 9) = (/&
&3.5399E-01_JPRB,3.3121E-01_JPRB,3.2486E-01_JPRB,3.1880E-01_JPRB,3.1822E-01_JPRB,3.2442E-01_JPRB,&
&3.3586E-01_JPRB,3.4269E-01_JPRB,3.3501E-01_JPRB,3.3685E-01_JPRB/)
KAO( :, 2, 1, 9) = (/&
&4.2651E-01_JPRB,4.0055E-01_JPRB,3.9461E-01_JPRB,3.8890E-01_JPRB,3.8920E-01_JPRB,3.9613E-01_JPRB,&
&4.0802E-01_JPRB,4.1445E-01_JPRB,4.0640E-01_JPRB,4.0867E-01_JPRB/)
KAO( :, 3, 1, 9) = (/&
&5.0539E-01_JPRB,4.7639E-01_JPRB,4.7090E-01_JPRB,4.6538E-01_JPRB,4.6724E-01_JPRB,4.7472E-01_JPRB,&
&4.8830E-01_JPRB,4.9479E-01_JPRB,4.8770E-01_JPRB,4.9083E-01_JPRB/)
KAO( :, 4, 1, 9) = (/&
&5.9058E-01_JPRB,5.5850E-01_JPRB,5.5373E-01_JPRB,5.4899E-01_JPRB,5.5264E-01_JPRB,5.6233E-01_JPRB,&
&5.7911E-01_JPRB,5.8486E-01_JPRB,5.8020E-01_JPRB,5.8417E-01_JPRB/)
KAO( :, 5, 1, 9) = (/&
&6.8144E-01_JPRB,6.4618E-01_JPRB,6.4280E-01_JPRB,6.4028E-01_JPRB,6.4693E-01_JPRB,6.6026E-01_JPRB,&
&6.7993E-01_JPRB,6.8608E-01_JPRB,6.8519E-01_JPRB,6.9037E-01_JPRB/)
KAO( :, 1, 2, 9) = (/&
&3.4190E-01_JPRB,3.2327E-01_JPRB,3.1819E-01_JPRB,3.0936E-01_JPRB,3.0384E-01_JPRB,3.0263E-01_JPRB,&
&3.0472E-01_JPRB,3.0754E-01_JPRB,2.9901E-01_JPRB,2.9844E-01_JPRB/)
KAO( :, 2, 2, 9) = (/&
&4.1493E-01_JPRB,3.9389E-01_JPRB,3.8895E-01_JPRB,3.7913E-01_JPRB,3.7292E-01_JPRB,3.7132E-01_JPRB,&
&3.7292E-01_JPRB,3.7436E-01_JPRB,3.6462E-01_JPRB,3.6374E-01_JPRB/)
KAO( :, 3, 2, 9) = (/&
&4.9524E-01_JPRB,4.7144E-01_JPRB,4.6681E-01_JPRB,4.5556E-01_JPRB,4.4901E-01_JPRB,4.4730E-01_JPRB,&
&4.4941E-01_JPRB,4.4980E-01_JPRB,4.3975E-01_JPRB,4.3888E-01_JPRB/)
KAO( :, 4, 2, 9) = (/&
&5.8258E-01_JPRB,5.5620E-01_JPRB,5.5130E-01_JPRB,5.3974E-01_JPRB,5.3286E-01_JPRB,5.3221E-01_JPRB,&
&5.3561E-01_JPRB,5.3530E-01_JPRB,5.2641E-01_JPRB,5.2532E-01_JPRB/)
KAO( :, 5, 2, 9) = (/&
&6.7549E-01_JPRB,6.4700E-01_JPRB,6.4191E-01_JPRB,6.3134E-01_JPRB,6.2562E-01_JPRB,6.2644E-01_JPRB,&
&6.3141E-01_JPRB,6.3148E-01_JPRB,6.2520E-01_JPRB,6.2423E-01_JPRB/)
KAO( :, 1, 3, 9) = (/&
&3.1322E-01_JPRB,2.9905E-01_JPRB,2.9475E-01_JPRB,2.8714E-01_JPRB,2.7777E-01_JPRB,2.7056E-01_JPRB,&
&2.6471E-01_JPRB,2.6169E-01_JPRB,2.5251E-01_JPRB,2.4874E-01_JPRB/)
KAO( :, 2, 3, 9) = (/&
&3.8433E-01_JPRB,3.6852E-01_JPRB,3.6478E-01_JPRB,3.5517E-01_JPRB,3.4410E-01_JPRB,3.3552E-01_JPRB,&
&3.2763E-01_JPRB,3.2198E-01_JPRB,3.1065E-01_JPRB,3.0619E-01_JPRB/)
KAO( :, 3, 3, 9) = (/&
&4.6279E-01_JPRB,4.4538E-01_JPRB,4.4243E-01_JPRB,4.3036E-01_JPRB,4.1731E-01_JPRB,4.0795E-01_JPRB,&
&3.9813E-01_JPRB,3.9008E-01_JPRB,3.7721E-01_JPRB,3.7260E-01_JPRB/)
KAO( :, 4, 3, 9) = (/&
&5.4926E-01_JPRB,5.2996E-01_JPRB,5.2724E-01_JPRB,5.1320E-01_JPRB,4.9840E-01_JPRB,4.8894E-01_JPRB,&
&4.7837E-01_JPRB,4.6780E-01_JPRB,4.5401E-01_JPRB,4.4835E-01_JPRB/)
KAO( :, 5, 3, 9) = (/&
&6.4194E-01_JPRB,6.2152E-01_JPRB,6.1862E-01_JPRB,6.0327E-01_JPRB,5.8767E-01_JPRB,5.7864E-01_JPRB,&
&5.6818E-01_JPRB,5.5487E-01_JPRB,5.4176E-01_JPRB,5.3533E-01_JPRB/)
KAO( :, 1, 4, 9) = (/&
&2.7768E-01_JPRB,2.6760E-01_JPRB,2.6572E-01_JPRB,2.5980E-01_JPRB,2.4896E-01_JPRB,2.3795E-01_JPRB,&
&2.2584E-01_JPRB,2.1553E-01_JPRB,2.0567E-01_JPRB,1.9994E-01_JPRB/)
KAO( :, 2, 4, 9) = (/&
&3.4628E-01_JPRB,3.3518E-01_JPRB,3.3312E-01_JPRB,3.2573E-01_JPRB,3.1238E-01_JPRB,2.9848E-01_JPRB,&
&2.8332E-01_JPRB,2.6934E-01_JPRB,2.5641E-01_JPRB,2.4969E-01_JPRB/)
KAO( :, 3, 4, 9) = (/&
&4.2166E-01_JPRB,4.1018E-01_JPRB,4.0846E-01_JPRB,3.9896E-01_JPRB,3.8288E-01_JPRB,3.6617E-01_JPRB,&
&3.4804E-01_JPRB,3.3049E-01_JPRB,3.1485E-01_JPRB,3.0688E-01_JPRB/)
KAO( :, 4, 4, 9) = (/&
&5.0480E-01_JPRB,4.9294E-01_JPRB,4.9184E-01_JPRB,4.7995E-01_JPRB,4.6126E-01_JPRB,4.4207E-01_JPRB,&
&4.2165E-01_JPRB,4.0000E-01_JPRB,3.8208E-01_JPRB,3.7264E-01_JPRB/)
KAO( :, 5, 4, 9) = (/&
&5.9516E-01_JPRB,5.8326E-01_JPRB,5.8244E-01_JPRB,5.6852E-01_JPRB,5.4774E-01_JPRB,5.2760E-01_JPRB,&
&5.0410E-01_JPRB,4.7792E-01_JPRB,4.5860E-01_JPRB,4.4782E-01_JPRB/)
KAO( :, 1, 5, 9) = (/&
&2.4131E-01_JPRB,2.3501E-01_JPRB,2.3520E-01_JPRB,2.3089E-01_JPRB,2.2183E-01_JPRB,2.0721E-01_JPRB,&
&1.9087E-01_JPRB,1.7544E-01_JPRB,1.6409E-01_JPRB,1.5817E-01_JPRB/)
KAO( :, 2, 5, 9) = (/&
&3.0553E-01_JPRB,2.9936E-01_JPRB,2.9956E-01_JPRB,2.9368E-01_JPRB,2.8148E-01_JPRB,2.6374E-01_JPRB,&
&2.4318E-01_JPRB,2.2281E-01_JPRB,2.0743E-01_JPRB,2.0014E-01_JPRB/)
KAO( :, 3, 5, 9) = (/&
&3.7703E-01_JPRB,3.7157E-01_JPRB,3.7167E-01_JPRB,3.6419E-01_JPRB,3.4859E-01_JPRB,3.2739E-01_JPRB,&
&3.0264E-01_JPRB,2.7688E-01_JPRB,2.5755E-01_JPRB,2.4828E-01_JPRB/)
KAO( :, 4, 5, 9) = (/&
&4.5610E-01_JPRB,4.5131E-01_JPRB,4.5213E-01_JPRB,4.4247E-01_JPRB,4.2387E-01_JPRB,3.9882E-01_JPRB,&
&3.7008E-01_JPRB,3.3849E-01_JPRB,3.1536E-01_JPRB,3.0426E-01_JPRB/)
KAO( :, 5, 5, 9) = (/&
&5.4247E-01_JPRB,5.3886E-01_JPRB,5.4021E-01_JPRB,5.2840E-01_JPRB,5.0753E-01_JPRB,4.7901E-01_JPRB,&
&4.4567E-01_JPRB,4.0809E-01_JPRB,3.8163E-01_JPRB,3.6881E-01_JPRB/)
KAO( :, 1, 6, 9) = (/&
&2.0298E-01_JPRB,2.0025E-01_JPRB,2.0213E-01_JPRB,1.9982E-01_JPRB,1.9212E-01_JPRB,1.7691E-01_JPRB,&
&1.5886E-01_JPRB,1.4069E-01_JPRB,1.2763E-01_JPRB,1.2147E-01_JPRB/)
KAO( :, 2, 6, 9) = (/&
&2.6157E-01_JPRB,2.5976E-01_JPRB,2.6209E-01_JPRB,2.5832E-01_JPRB,2.4798E-01_JPRB,2.2871E-01_JPRB,&
&2.0577E-01_JPRB,1.8197E-01_JPRB,1.6416E-01_JPRB,1.5634E-01_JPRB/)
KAO( :, 3, 6, 9) = (/&
&3.2801E-01_JPRB,3.2761E-01_JPRB,3.3023E-01_JPRB,3.2484E-01_JPRB,3.1114E-01_JPRB,2.8803E-01_JPRB,&
&2.5966E-01_JPRB,2.2885E-01_JPRB,2.0587E-01_JPRB,1.9644E-01_JPRB/)
KAO( :, 4, 6, 9) = (/&
&4.0207E-01_JPRB,4.0351E-01_JPRB,4.0622E-01_JPRB,3.9903E-01_JPRB,3.8234E-01_JPRB,3.5465E-01_JPRB,&
&3.2062E-01_JPRB,2.8289E-01_JPRB,2.5440E-01_JPRB,2.4312E-01_JPRB/)
KAO( :, 5, 6, 9) = (/&
&4.8336E-01_JPRB,4.8697E-01_JPRB,4.9003E-01_JPRB,4.8114E-01_JPRB,4.6185E-01_JPRB,4.2928E-01_JPRB,&
&3.8966E-01_JPRB,3.4463E-01_JPRB,3.1043E-01_JPRB,2.9706E-01_JPRB/)
KAO( :, 1, 7, 9) = (/&
&1.6688E-01_JPRB,1.6702E-01_JPRB,1.7031E-01_JPRB,1.6921E-01_JPRB,1.6199E-01_JPRB,1.4897E-01_JPRB,&
&1.3092E-01_JPRB,1.1133E-01_JPRB,9.6760E-02_JPRB,9.3718E-02_JPRB/)
KAO( :, 2, 7, 9) = (/&
&2.1882E-01_JPRB,2.2087E-01_JPRB,2.2486E-01_JPRB,2.2286E-01_JPRB,2.1335E-01_JPRB,1.9615E-01_JPRB,&
&1.7285E-01_JPRB,1.4695E-01_JPRB,1.2690E-01_JPRB,1.2096E-01_JPRB/)
KAO( :, 3, 7, 9) = (/&
&2.7888E-01_JPRB,2.8306E-01_JPRB,2.8777E-01_JPRB,2.8469E-01_JPRB,2.7204E-01_JPRB,2.5033E-01_JPRB,&
&2.2122E-01_JPRB,1.8786E-01_JPRB,1.6161E-01_JPRB,1.5296E-01_JPRB/)
KAO( :, 4, 7, 9) = (/&
&3.4680E-01_JPRB,3.5385E-01_JPRB,3.5881E-01_JPRB,3.5420E-01_JPRB,3.3854E-01_JPRB,3.1188E-01_JPRB,&
&2.7612E-01_JPRB,2.3528E-01_JPRB,2.0215E-01_JPRB,1.9095E-01_JPRB/)
KAO( :, 5, 7, 9) = (/&
&4.2205E-01_JPRB,4.3215E-01_JPRB,4.3759E-01_JPRB,4.3127E-01_JPRB,4.1273E-01_JPRB,3.8116E-01_JPRB,&
&3.3879E-01_JPRB,2.8948E-01_JPRB,2.4886E-01_JPRB,2.3560E-01_JPRB/)
KAO( :, 1, 8, 9) = (/&
&1.3459E-01_JPRB,1.3692E-01_JPRB,1.4080E-01_JPRB,1.3971E-01_JPRB,1.3347E-01_JPRB,1.2262E-01_JPRB,&
&1.0666E-01_JPRB,8.7305E-02_JPRB,7.1915E-02_JPRB,8.0038E-02_JPRB/)
KAO( :, 2, 8, 9) = (/&
&1.7963E-01_JPRB,1.8442E-01_JPRB,1.8954E-01_JPRB,1.8806E-01_JPRB,1.7951E-01_JPRB,1.6497E-01_JPRB,&
&1.4377E-01_JPRB,1.1758E-01_JPRB,9.6206E-02_JPRB,1.0094E-01_JPRB/)
KAO( :, 3, 8, 9) = (/&
&2.3266E-01_JPRB,2.4033E-01_JPRB,2.4672E-01_JPRB,2.4454E-01_JPRB,2.3290E-01_JPRB,2.1424E-01_JPRB,&
&1.8695E-01_JPRB,1.5303E-01_JPRB,1.2456E-01_JPRB,1.2568E-01_JPRB/)
KAO( :, 4, 8, 9) = (/&
&2.9355E-01_JPRB,3.0495E-01_JPRB,3.1213E-01_JPRB,3.0852E-01_JPRB,2.9407E-01_JPRB,2.7020E-01_JPRB,&
&2.3654E-01_JPRB,1.9451E-01_JPRB,1.5796E-01_JPRB,1.5516E-01_JPRB/)
KAO( :, 5, 8, 9) = (/&
&3.6186E-01_JPRB,3.7725E-01_JPRB,3.8522E-01_JPRB,3.7996E-01_JPRB,3.6242E-01_JPRB,3.3355E-01_JPRB,&
&2.9318E-01_JPRB,2.4229E-01_JPRB,1.9677E-01_JPRB,1.8992E-01_JPRB/)
KAO( :, 1, 9, 9) = (/&
&1.0631E-01_JPRB,1.0993E-01_JPRB,1.1355E-01_JPRB,1.1237E-01_JPRB,1.0701E-01_JPRB,9.8207E-02_JPRB,&
&8.5182E-02_JPRB,6.7755E-02_JPRB,5.2331E-02_JPRB,1.0492E-01_JPRB/)
KAO( :, 2, 9, 9) = (/&
&1.4454E-01_JPRB,1.5090E-01_JPRB,1.5590E-01_JPRB,1.5444E-01_JPRB,1.4727E-01_JPRB,1.3526E-01_JPRB,&
&1.1750E-01_JPRB,9.3259E-02_JPRB,7.1622E-02_JPRB,1.2467E-01_JPRB/)
KAO( :, 3, 9, 9) = (/&
&1.9019E-01_JPRB,2.0011E-01_JPRB,2.0653E-01_JPRB,2.0466E-01_JPRB,1.9486E-01_JPRB,1.7904E-01_JPRB,&
&1.5563E-01_JPRB,1.2364E-01_JPRB,9.4415E-02_JPRB,1.4740E-01_JPRB/)
KAO( :, 4, 9, 9) = (/&
&2.4347E-01_JPRB,2.5775E-01_JPRB,2.6549E-01_JPRB,2.6241E-01_JPRB,2.4987E-01_JPRB,2.2949E-01_JPRB,&
&1.9969E-01_JPRB,1.5939E-01_JPRB,1.2136E-01_JPRB,1.7369E-01_JPRB/)
KAO( :, 5, 9, 9) = (/&
&3.0422E-01_JPRB,3.2317E-01_JPRB,3.3203E-01_JPRB,3.2777E-01_JPRB,3.1197E-01_JPRB,2.8664E-01_JPRB,&
&2.5051E-01_JPRB,2.0084E-01_JPRB,1.5296E-01_JPRB,2.0398E-01_JPRB/)
KAO( :, 1,10, 9) = (/&
&8.4350E-02_JPRB,8.8815E-02_JPRB,9.2007E-02_JPRB,9.0712E-02_JPRB,8.6235E-02_JPRB,7.8834E-02_JPRB,&
&6.8251E-02_JPRB,5.3494E-02_JPRB,3.8569E-02_JPRB,2.8448E-01_JPRB/)
KAO( :, 2,10, 9) = (/&
&1.1655E-01_JPRB,1.2396E-01_JPRB,1.2864E-01_JPRB,1.2700E-01_JPRB,1.2091E-01_JPRB,1.1076E-01_JPRB,&
&9.6175E-02_JPRB,7.5206E-02_JPRB,5.3741E-02_JPRB,3.1183E-01_JPRB/)
KAO( :, 3,10, 9) = (/&
&1.5575E-01_JPRB,1.6688E-01_JPRB,1.7302E-01_JPRB,1.7096E-01_JPRB,1.6280E-01_JPRB,1.4927E-01_JPRB,&
&1.2964E-01_JPRB,1.0128E-01_JPRB,7.1998E-02_JPRB,3.4035E-01_JPRB/)
KAO( :, 4,10, 9) = (/&
&2.0199E-01_JPRB,2.1771E-01_JPRB,2.2539E-01_JPRB,2.2239E-01_JPRB,2.1182E-01_JPRB,1.9426E-01_JPRB,&
&1.6870E-01_JPRB,1.3220E-01_JPRB,9.3820E-02_JPRB,3.7022E-01_JPRB/)
KAO( :, 5,10, 9) = (/&
&2.5543E-01_JPRB,2.7602E-01_JPRB,2.8512E-01_JPRB,2.8125E-01_JPRB,2.6776E-01_JPRB,2.4558E-01_JPRB,&
&2.1379E-01_JPRB,1.6843E-01_JPRB,1.1967E-01_JPRB,4.0133E-01_JPRB/)
KAO( :, 1,11, 9) = (/&
&7.7305E-02_JPRB,8.3512E-02_JPRB,8.6558E-02_JPRB,8.5115E-02_JPRB,8.0759E-02_JPRB,7.3668E-02_JPRB,&
&6.3729E-02_JPRB,4.9798E-02_JPRB,3.3279E-02_JPRB,4.2331E-01_JPRB/)
KAO( :, 2,11, 9) = (/&
&1.0674E-01_JPRB,1.1631E-01_JPRB,1.2074E-01_JPRB,1.1897E-01_JPRB,1.1306E-01_JPRB,1.0338E-01_JPRB,&
&8.9693E-02_JPRB,6.9947E-02_JPRB,4.6392E-02_JPRB,4.5759E-01_JPRB/)
KAO( :, 3,11, 9) = (/&
&1.4252E-01_JPRB,1.5630E-01_JPRB,1.6230E-01_JPRB,1.5989E-01_JPRB,1.5215E-01_JPRB,1.3931E-01_JPRB,&
&1.2082E-01_JPRB,9.4229E-02_JPRB,6.2207E-02_JPRB,4.9301E-01_JPRB/)
KAO( :, 4,11, 9) = (/&
&1.8495E-01_JPRB,2.0344E-01_JPRB,2.1113E-01_JPRB,2.0801E-01_JPRB,1.9807E-01_JPRB,1.8125E-01_JPRB,&
&1.5734E-01_JPRB,1.2303E-01_JPRB,8.1307E-02_JPRB,5.3012E-01_JPRB/)
KAO( :, 5,11, 9) = (/&
&2.3411E-01_JPRB,2.5783E-01_JPRB,2.6690E-01_JPRB,2.6303E-01_JPRB,2.5035E-01_JPRB,2.2944E-01_JPRB,&
&1.9943E-01_JPRB,1.5658E-01_JPRB,1.0397E-01_JPRB,5.6789E-01_JPRB/)
KAO( :, 1,12, 9) = (/&
&7.0108E-02_JPRB,7.7427E-02_JPRB,8.0063E-02_JPRB,7.8695E-02_JPRB,7.4412E-02_JPRB,6.7798E-02_JPRB,&
&5.8710E-02_JPRB,4.5826E-02_JPRB,2.8701E-02_JPRB,4.8793E-01_JPRB/)
KAO( :, 2,12, 9) = (/&
&9.6572E-02_JPRB,1.0765E-01_JPRB,1.1154E-01_JPRB,1.0976E-01_JPRB,1.0403E-01_JPRB,9.5053E-02_JPRB,&
&8.2414E-02_JPRB,6.4355E-02_JPRB,4.0085E-02_JPRB,5.2480E-01_JPRB/)
KAO( :, 3,12, 9) = (/&
&1.2890E-01_JPRB,1.4436E-01_JPRB,1.4960E-01_JPRB,1.4739E-01_JPRB,1.3992E-01_JPRB,1.2801E-01_JPRB,&
&1.1096E-01_JPRB,8.6644E-02_JPRB,5.3975E-02_JPRB,5.6251E-01_JPRB/)
KAO( :, 4,12, 9) = (/&
&1.6737E-01_JPRB,1.8778E-01_JPRB,1.9430E-01_JPRB,1.9165E-01_JPRB,1.8208E-01_JPRB,1.6659E-01_JPRB,&
&1.4450E-01_JPRB,1.1307E-01_JPRB,7.0696E-02_JPRB,6.0183E-01_JPRB/)
KAO( :, 5,12, 9) = (/&
&2.1186E-01_JPRB,2.3792E-01_JPRB,2.4587E-01_JPRB,2.4233E-01_JPRB,2.3021E-01_JPRB,2.1086E-01_JPRB,&
&1.8327E-01_JPRB,1.4386E-01_JPRB,9.0292E-02_JPRB,6.4163E-01_JPRB/)
KAO( :, 1,13, 9) = (/&
&6.2750E-02_JPRB,7.0678E-02_JPRB,7.2850E-02_JPRB,7.1358E-02_JPRB,6.7441E-02_JPRB,6.1433E-02_JPRB,&
&5.3185E-02_JPRB,4.1505E-02_JPRB,2.4806E-02_JPRB,4.4700E-01_JPRB/)
KAO( :, 2,13, 9) = (/&
&8.6316E-02_JPRB,9.8143E-02_JPRB,1.0134E-01_JPRB,9.9447E-02_JPRB,9.4210E-02_JPRB,8.6014E-02_JPRB,&
&7.4526E-02_JPRB,5.8273E-02_JPRB,3.4743E-02_JPRB,4.8103E-01_JPRB/)
KAO( :, 3,13, 9) = (/&
&1.1529E-01_JPRB,1.3156E-01_JPRB,1.3579E-01_JPRB,1.3346E-01_JPRB,1.2666E-01_JPRB,1.1573E-01_JPRB,&
&1.0031E-01_JPRB,7.8511E-02_JPRB,4.6928E-02_JPRB,5.1606E-01_JPRB/)
KAO( :, 4,13, 9) = (/&
&1.4976E-01_JPRB,1.7104E-01_JPRB,1.7643E-01_JPRB,1.7358E-01_JPRB,1.6473E-01_JPRB,1.5058E-01_JPRB,&
&1.3067E-01_JPRB,1.0249E-01_JPRB,6.1551E-02_JPRB,5.5224E-01_JPRB/)
KAO( :, 5,13, 9) = (/&
&1.8964E-01_JPRB,2.1656E-01_JPRB,2.2339E-01_JPRB,2.1970E-01_JPRB,2.0856E-01_JPRB,1.9074E-01_JPRB,&
&1.6575E-01_JPRB,1.3031E-01_JPRB,7.8382E-02_JPRB,5.8913E-01_JPRB/)
KAO( :, 1, 1,10) = (/&
&6.1867E-01_JPRB,5.7630E-01_JPRB,6.0305E-01_JPRB,6.9456E-01_JPRB,7.7261E-01_JPRB,8.1005E-01_JPRB,&
&8.2424E-01_JPRB,7.8487E-01_JPRB,7.9716E-01_JPRB,8.1097E-01_JPRB/)
KAO( :, 2, 1,10) = (/&
&7.5538E-01_JPRB,7.0706E-01_JPRB,7.4825E-01_JPRB,8.6573E-01_JPRB,9.5133E-01_JPRB,9.9496E-01_JPRB,&
&1.0144E+00_JPRB,9.4349E-01_JPRB,9.7510E-01_JPRB,9.8557E-01_JPRB/)
KAO( :, 3, 1,10) = (/&
&9.0753E-01_JPRB,8.5431E-01_JPRB,9.0954E-01_JPRB,1.0504E+00_JPRB,1.1439E+00_JPRB,1.1961E+00_JPRB,&
&1.2138E+00_JPRB,1.1038E+00_JPRB,1.1635E+00_JPRB,1.1729E+00_JPRB/)
KAO( :, 4, 1,10) = (/&
&1.0717E+00_JPRB,1.0134E+00_JPRB,1.0876E+00_JPRB,1.2471E+00_JPRB,1.3505E+00_JPRB,1.4049E+00_JPRB,&
&1.4219E+00_JPRB,1.2915E+00_JPRB,1.3878E+00_JPRB,1.3991E+00_JPRB/)
KAO( :, 5, 1,10) = (/&
&1.2427E+00_JPRB,1.1827E+00_JPRB,1.2833E+00_JPRB,1.4504E+00_JPRB,1.5635E+00_JPRB,1.6298E+00_JPRB,&
&1.6597E+00_JPRB,1.4857E+00_JPRB,1.6414E+00_JPRB,1.6460E+00_JPRB/)
KAO( :, 1, 2,10) = (/&
&6.4321E-01_JPRB,5.8696E-01_JPRB,5.8230E-01_JPRB,6.5619E-01_JPRB,7.1556E-01_JPRB,7.4170E-01_JPRB,&
&7.6071E-01_JPRB,7.3912E-01_JPRB,7.4532E-01_JPRB,7.5850E-01_JPRB/)
KAO( :, 2, 2,10) = (/&
&7.8984E-01_JPRB,7.2453E-01_JPRB,7.3316E-01_JPRB,8.2574E-01_JPRB,8.9339E-01_JPRB,9.2578E-01_JPRB,&
&9.3666E-01_JPRB,8.9172E-01_JPRB,9.0627E-01_JPRB,9.2412E-01_JPRB/)
KAO( :, 3, 2,10) = (/&
&9.4869E-01_JPRB,8.7312E-01_JPRB,8.9992E-01_JPRB,1.0108E+00_JPRB,1.0906E+00_JPRB,1.1228E+00_JPRB,&
&1.1184E+00_JPRB,1.0532E+00_JPRB,1.0816E+00_JPRB,1.1050E+00_JPRB/)
KAO( :, 4, 2,10) = (/&
&1.1182E+00_JPRB,1.0333E+00_JPRB,1.0816E+00_JPRB,1.2099E+00_JPRB,1.2991E+00_JPRB,1.3295E+00_JPRB,&
&1.3183E+00_JPRB,1.2305E+00_JPRB,1.2865E+00_JPRB,1.3109E+00_JPRB/)
KAO( :, 5, 2,10) = (/&
&1.2953E+00_JPRB,1.2046E+00_JPRB,1.2743E+00_JPRB,1.4197E+00_JPRB,1.5179E+00_JPRB,1.5565E+00_JPRB,&
&1.5463E+00_JPRB,1.4061E+00_JPRB,1.5050E+00_JPRB,1.5282E+00_JPRB/)
KAO( :, 1, 3,10) = (/&
&6.2757E-01_JPRB,5.7473E-01_JPRB,5.5914E-01_JPRB,5.8172E-01_JPRB,6.2887E-01_JPRB,6.5014E-01_JPRB,&
&6.7802E-01_JPRB,6.5904E-01_JPRB,6.5934E-01_JPRB,6.7295E-01_JPRB/)
KAO( :, 2, 3,10) = (/&
&7.8418E-01_JPRB,7.1588E-01_JPRB,7.0607E-01_JPRB,7.4238E-01_JPRB,8.0014E-01_JPRB,8.1822E-01_JPRB,&
&8.4016E-01_JPRB,8.0936E-01_JPRB,8.1484E-01_JPRB,8.2805E-01_JPRB/)
KAO( :, 3, 3,10) = (/&
&9.6014E-01_JPRB,8.7612E-01_JPRB,8.6845E-01_JPRB,9.2232E-01_JPRB,9.9214E-01_JPRB,9.9810E-01_JPRB,&
&1.0104E+00_JPRB,9.7306E-01_JPRB,9.8869E-01_JPRB,1.0030E+00_JPRB/)
KAO( :, 4, 3,10) = (/&
&1.1436E+00_JPRB,1.0500E+00_JPRB,1.0473E+00_JPRB,1.1216E+00_JPRB,1.1992E+00_JPRB,1.1909E+00_JPRB,&
&1.1979E+00_JPRB,1.1493E+00_JPRB,1.1843E+00_JPRB,1.2028E+00_JPRB/)
KAO( :, 5, 3,10) = (/&
&1.3363E+00_JPRB,1.2288E+00_JPRB,1.2400E+00_JPRB,1.3328E+00_JPRB,1.4189E+00_JPRB,1.4085E+00_JPRB,&
&1.4054E+00_JPRB,1.3326E+00_JPRB,1.3952E+00_JPRB,1.4190E+00_JPRB/)
KAO( :, 1, 4,10) = (/&
&6.0902E-01_JPRB,5.5865E-01_JPRB,5.2875E-01_JPRB,5.1792E-01_JPRB,5.4518E-01_JPRB,5.6325E-01_JPRB,&
&5.8877E-01_JPRB,5.8387E-01_JPRB,5.8206E-01_JPRB,5.9308E-01_JPRB/)
KAO( :, 2, 4,10) = (/&
&7.6140E-01_JPRB,6.9912E-01_JPRB,6.7757E-01_JPRB,6.6690E-01_JPRB,7.0327E-01_JPRB,7.2305E-01_JPRB,&
&7.4172E-01_JPRB,7.2030E-01_JPRB,7.2068E-01_JPRB,7.3161E-01_JPRB/)
KAO( :, 3, 4,10) = (/&
&9.4002E-01_JPRB,8.6365E-01_JPRB,8.4366E-01_JPRB,8.3795E-01_JPRB,8.8109E-01_JPRB,8.9279E-01_JPRB,&
&9.0652E-01_JPRB,8.7018E-01_JPRB,8.7595E-01_JPRB,8.8773E-01_JPRB/)
KAO( :, 4, 4,10) = (/&
&1.1361E+00_JPRB,1.0471E+00_JPRB,1.0239E+00_JPRB,1.0291E+00_JPRB,1.0729E+00_JPRB,1.0769E+00_JPRB,&
&1.0898E+00_JPRB,1.0370E+00_JPRB,1.0554E+00_JPRB,1.0680E+00_JPRB/)
KAO( :, 5, 4,10) = (/&
&1.3459E+00_JPRB,1.2415E+00_JPRB,1.2200E+00_JPRB,1.2343E+00_JPRB,1.2811E+00_JPRB,1.2812E+00_JPRB,&
&1.2941E+00_JPRB,1.2225E+00_JPRB,1.2598E+00_JPRB,1.2702E+00_JPRB/)
KAO( :, 1, 5,10) = (/&
&5.7515E-01_JPRB,5.3232E-01_JPRB,5.0391E-01_JPRB,4.7978E-01_JPRB,4.6984E-01_JPRB,4.8839E-01_JPRB,&
&5.1587E-01_JPRB,5.0590E-01_JPRB,5.0049E-01_JPRB,4.9518E-01_JPRB/)
KAO( :, 2, 5,10) = (/&
&7.3128E-01_JPRB,6.7406E-01_JPRB,6.4811E-01_JPRB,6.2049E-01_JPRB,6.1868E-01_JPRB,6.3401E-01_JPRB,&
&6.5439E-01_JPRB,6.3488E-01_JPRB,6.3015E-01_JPRB,6.2410E-01_JPRB/)
KAO( :, 3, 5,10) = (/&
&9.0920E-01_JPRB,8.3759E-01_JPRB,8.1835E-01_JPRB,7.8435E-01_JPRB,7.8487E-01_JPRB,7.9695E-01_JPRB,&
&8.0516E-01_JPRB,7.7727E-01_JPRB,7.7504E-01_JPRB,7.7636E-01_JPRB/)
KAO( :, 4, 5,10) = (/&
&1.1099E+00_JPRB,1.0245E+00_JPRB,1.0070E+00_JPRB,9.7052E-01_JPRB,9.6348E-01_JPRB,9.7780E-01_JPRB,&
&9.7649E-01_JPRB,9.3660E-01_JPRB,9.3973E-01_JPRB,9.4451E-01_JPRB/)
KAO( :, 5, 5,10) = (/&
&1.3305E+00_JPRB,1.2272E+00_JPRB,1.2112E+00_JPRB,1.1732E+00_JPRB,1.1594E+00_JPRB,1.1784E+00_JPRB,&
&1.1704E+00_JPRB,1.1112E+00_JPRB,1.1263E+00_JPRB,1.1272E+00_JPRB/)
KAO( :, 1, 6,10) = (/&
&5.3624E-01_JPRB,4.9966E-01_JPRB,4.7124E-01_JPRB,4.4396E-01_JPRB,4.1309E-01_JPRB,4.1799E-01_JPRB,&
&4.3204E-01_JPRB,4.1689E-01_JPRB,4.0796E-01_JPRB,4.0296E-01_JPRB/)
KAO( :, 2, 6,10) = (/&
&6.9086E-01_JPRB,6.4214E-01_JPRB,6.1471E-01_JPRB,5.8168E-01_JPRB,5.4576E-01_JPRB,5.5331E-01_JPRB,&
&5.6106E-01_JPRB,5.3207E-01_JPRB,5.1983E-01_JPRB,5.1381E-01_JPRB/)
KAO( :, 3, 6,10) = (/&
&8.6785E-01_JPRB,8.0700E-01_JPRB,7.8156E-01_JPRB,7.4169E-01_JPRB,7.0281E-01_JPRB,7.0090E-01_JPRB,&
&7.0317E-01_JPRB,6.6880E-01_JPRB,6.5685E-01_JPRB,6.4884E-01_JPRB/)
KAO( :, 4, 6,10) = (/&
&1.0625E+00_JPRB,9.9150E-01_JPRB,9.7284E-01_JPRB,9.2583E-01_JPRB,8.7592E-01_JPRB,8.6864E-01_JPRB,&
&8.6733E-01_JPRB,8.2238E-01_JPRB,8.1245E-01_JPRB,8.0011E-01_JPRB/)
KAO( :, 5, 6,10) = (/&
&1.2823E+00_JPRB,1.1975E+00_JPRB,1.1856E+00_JPRB,1.1255E+00_JPRB,1.0659E+00_JPRB,1.0612E+00_JPRB,&
&1.0498E+00_JPRB,9.8546E-01_JPRB,9.8371E-01_JPRB,9.6751E-01_JPRB/)
KAO( :, 1, 7,10) = (/&
&4.8822E-01_JPRB,4.5431E-01_JPRB,4.2346E-01_JPRB,3.9680E-01_JPRB,3.7415E-01_JPRB,3.5071E-01_JPRB,&
&3.5118E-01_JPRB,3.4152E-01_JPRB,3.3119E-01_JPRB,3.2558E-01_JPRB/)
KAO( :, 2, 7,10) = (/&
&6.4341E-01_JPRB,5.9836E-01_JPRB,5.6565E-01_JPRB,5.3167E-01_JPRB,5.0027E-01_JPRB,4.7116E-01_JPRB,&
&4.6350E-01_JPRB,4.4353E-01_JPRB,4.2884E-01_JPRB,4.2493E-01_JPRB/)
KAO( :, 3, 7,10) = (/&
&8.2158E-01_JPRB,7.6606E-01_JPRB,7.3098E-01_JPRB,6.8632E-01_JPRB,6.4732E-01_JPRB,6.1167E-01_JPRB,&
&5.9535E-01_JPRB,5.6548E-01_JPRB,5.4739E-01_JPRB,5.4288E-01_JPRB/)
KAO( :, 4, 7,10) = (/&
&1.0179E+00_JPRB,9.5156E-01_JPRB,9.1785E-01_JPRB,8.6567E-01_JPRB,8.1404E-01_JPRB,7.7261E-01_JPRB,&
&7.5332E-01_JPRB,7.0277E-01_JPRB,6.8164E-01_JPRB,6.6834E-01_JPRB/)
KAO( :, 5, 7,10) = (/&
&1.2332E+00_JPRB,1.1568E+00_JPRB,1.1270E+00_JPRB,1.0643E+00_JPRB,1.0019E+00_JPRB,9.5490E-01_JPRB,&
&9.2760E-01_JPRB,8.5293E-01_JPRB,8.3234E-01_JPRB,8.1269E-01_JPRB/)
KAO( :, 1, 8,10) = (/&
&4.2698E-01_JPRB,3.9591E-01_JPRB,3.6905E-01_JPRB,3.5247E-01_JPRB,3.3247E-01_JPRB,3.0233E-01_JPRB,&
&2.8539E-01_JPRB,2.7613E-01_JPRB,2.6380E-01_JPRB,2.5566E-01_JPRB/)
KAO( :, 2, 8,10) = (/&
&5.7792E-01_JPRB,5.3599E-01_JPRB,5.0504E-01_JPRB,4.7965E-01_JPRB,4.5454E-01_JPRB,4.1047E-01_JPRB,&
&3.8401E-01_JPRB,3.6795E-01_JPRB,3.5022E-01_JPRB,3.4085E-01_JPRB/)
KAO( :, 3, 8,10) = (/&
&7.5312E-01_JPRB,7.0208E-01_JPRB,6.6433E-01_JPRB,6.2807E-01_JPRB,5.9800E-01_JPRB,5.3750E-01_JPRB,&
&5.0237E-01_JPRB,4.7916E-01_JPRB,4.5629E-01_JPRB,4.4355E-01_JPRB/)
KAO( :, 4, 8,10) = (/&
&9.4927E-01_JPRB,8.8669E-01_JPRB,8.4547E-01_JPRB,8.0194E-01_JPRB,7.5725E-01_JPRB,6.9205E-01_JPRB,&
&6.4511E-01_JPRB,6.0026E-01_JPRB,5.7127E-01_JPRB,5.5530E-01_JPRB/)
KAO( :, 5, 8,10) = (/&
&1.1639E+00_JPRB,1.0911E+00_JPRB,1.0454E+00_JPRB,9.9552E-01_JPRB,9.4083E-01_JPRB,8.6800E-01_JPRB,&
&8.0258E-01_JPRB,7.3309E-01_JPRB,6.9987E-01_JPRB,6.8251E-01_JPRB/)
KAO( :, 1, 9,10) = (/&
&3.5900E-01_JPRB,3.3445E-01_JPRB,3.1730E-01_JPRB,3.0609E-01_JPRB,2.8916E-01_JPRB,2.6120E-01_JPRB,&
&2.3361E-01_JPRB,2.1576E-01_JPRB,2.0240E-01_JPRB,3.1625E-01_JPRB/)
KAO( :, 2, 9,10) = (/&
&4.9875E-01_JPRB,4.6530E-01_JPRB,4.4401E-01_JPRB,4.2786E-01_JPRB,4.0336E-01_JPRB,3.6326E-01_JPRB,&
&3.2063E-01_JPRB,2.9583E-01_JPRB,2.7549E-01_JPRB,3.9596E-01_JPRB/)
KAO( :, 3, 9,10) = (/&
&6.6489E-01_JPRB,6.2199E-01_JPRB,5.9558E-01_JPRB,5.7021E-01_JPRB,5.3875E-01_JPRB,4.8355E-01_JPRB,&
&4.2692E-01_JPRB,3.9415E-01_JPRB,3.6637E-01_JPRB,4.8553E-01_JPRB/)
KAO( :, 4, 9,10) = (/&
&8.5340E-01_JPRB,8.0059E-01_JPRB,7.6830E-01_JPRB,7.3710E-01_JPRB,6.9306E-01_JPRB,6.2454E-01_JPRB,&
&5.5697E-01_JPRB,5.0419E-01_JPRB,4.6742E-01_JPRB,5.7732E-01_JPRB/)
KAO( :, 5, 9,10) = (/&
&1.0646E+00_JPRB,1.0028E+00_JPRB,9.6218E-01_JPRB,9.2180E-01_JPRB,8.7012E-01_JPRB,7.9202E-01_JPRB,&
&6.9796E-01_JPRB,6.2710E-01_JPRB,5.8174E-01_JPRB,6.5582E-01_JPRB/)
KAO( :, 1,10,10) = (/&
&3.0304E-01_JPRB,2.8397E-01_JPRB,2.7440E-01_JPRB,2.6814E-01_JPRB,2.5119E-01_JPRB,2.2864E-01_JPRB,&
&1.9712E-01_JPRB,1.7067E-01_JPRB,1.5439E-01_JPRB,6.7616E-01_JPRB/)
KAO( :, 2,10,10) = (/&
&4.3039E-01_JPRB,4.0463E-01_JPRB,3.9135E-01_JPRB,3.8116E-01_JPRB,3.5873E-01_JPRB,3.2509E-01_JPRB,&
&2.7758E-01_JPRB,2.3881E-01_JPRB,2.1708E-01_JPRB,7.4040E-01_JPRB/)
KAO( :, 3,10,10) = (/&
&5.8308E-01_JPRB,5.5089E-01_JPRB,5.3392E-01_JPRB,5.1881E-01_JPRB,4.8588E-01_JPRB,4.3969E-01_JPRB,&
&3.7659E-01_JPRB,3.2471E-01_JPRB,2.9357E-01_JPRB,8.1103E-01_JPRB/)
KAO( :, 4,10,10) = (/&
&7.6072E-01_JPRB,7.2098E-01_JPRB,6.9990E-01_JPRB,6.8047E-01_JPRB,6.3309E-01_JPRB,5.7383E-01_JPRB,&
&4.9589E-01_JPRB,4.2336E-01_JPRB,3.8001E-01_JPRB,8.9328E-01_JPRB/)
KAO( :, 5,10,10) = (/&
&9.6027E-01_JPRB,9.1775E-01_JPRB,8.8924E-01_JPRB,8.5893E-01_JPRB,8.0372E-01_JPRB,7.2911E-01_JPRB,&
&6.3058E-01_JPRB,5.3610E-01_JPRB,4.7858E-01_JPRB,1.0024E+00_JPRB/)
KAO( :, 1,11,10) = (/&
&2.9953E-01_JPRB,2.8331E-01_JPRB,2.7926E-01_JPRB,2.7321E-01_JPRB,2.5698E-01_JPRB,2.3318E-01_JPRB,&
&1.9872E-01_JPRB,1.5868E-01_JPRB,1.3779E-01_JPRB,1.1107E+00_JPRB/)
KAO( :, 2,11,10) = (/&
&4.2474E-01_JPRB,4.0404E-01_JPRB,3.9781E-01_JPRB,3.8780E-01_JPRB,3.6438E-01_JPRB,3.3087E-01_JPRB,&
&2.8103E-01_JPRB,2.2386E-01_JPRB,1.9434E-01_JPRB,1.2029E+00_JPRB/)
KAO( :, 3,11,10) = (/&
&5.7442E-01_JPRB,5.4924E-01_JPRB,5.3961E-01_JPRB,5.2667E-01_JPRB,4.9259E-01_JPRB,4.4653E-01_JPRB,&
&3.8245E-01_JPRB,3.0341E-01_JPRB,2.6142E-01_JPRB,1.2915E+00_JPRB/)
KAO( :, 4,11,10) = (/&
&7.4813E-01_JPRB,7.2159E-01_JPRB,7.0602E-01_JPRB,6.8759E-01_JPRB,6.4029E-01_JPRB,5.8462E-01_JPRB,&
&4.9983E-01_JPRB,3.9642E-01_JPRB,3.3795E-01_JPRB,1.3704E+00_JPRB/)
KAO( :, 5,11,10) = (/&
&9.4256E-01_JPRB,9.1581E-01_JPRB,8.9684E-01_JPRB,8.6915E-01_JPRB,8.1278E-01_JPRB,7.3805E-01_JPRB,&
&6.3353E-01_JPRB,5.0310E-01_JPRB,4.2644E-01_JPRB,1.4638E+00_JPRB/)
KAO( :, 1,12,10) = (/&
&2.9002E-01_JPRB,2.7890E-01_JPRB,2.8045E-01_JPRB,2.7244E-01_JPRB,2.5769E-01_JPRB,2.3303E-01_JPRB,&
&1.9729E-01_JPRB,1.5119E-01_JPRB,1.2251E-01_JPRB,1.4129E+00_JPRB/)
KAO( :, 2,12,10) = (/&
&4.1026E-01_JPRB,3.9679E-01_JPRB,3.9830E-01_JPRB,3.8652E-01_JPRB,3.6420E-01_JPRB,3.2847E-01_JPRB,&
&2.8036E-01_JPRB,2.1376E-01_JPRB,1.7058E-01_JPRB,1.5197E+00_JPRB/)
KAO( :, 3,12,10) = (/&
&5.5455E-01_JPRB,5.4038E-01_JPRB,5.4011E-01_JPRB,5.2208E-01_JPRB,4.9107E-01_JPRB,4.4447E-01_JPRB,&
&3.8090E-01_JPRB,2.8868E-01_JPRB,2.2751E-01_JPRB,1.6225E+00_JPRB/)
KAO( :, 4,12,10) = (/&
&7.2014E-01_JPRB,7.0695E-01_JPRB,7.0633E-01_JPRB,6.7903E-01_JPRB,6.3973E-01_JPRB,5.8007E-01_JPRB,&
&4.9576E-01_JPRB,3.7656E-01_JPRB,2.9460E-01_JPRB,1.7134E+00_JPRB/)
KAO( :, 5,12,10) = (/&
&9.0944E-01_JPRB,8.9423E-01_JPRB,8.9075E-01_JPRB,8.5941E-01_JPRB,8.0946E-01_JPRB,7.3161E-01_JPRB,&
&6.2652E-01_JPRB,4.7880E-01_JPRB,3.7532E-01_JPRB,1.8224E+00_JPRB/)
KAO( :, 1,13,10) = (/&
&2.7340E-01_JPRB,2.7076E-01_JPRB,2.7526E-01_JPRB,2.6770E-01_JPRB,2.5179E-01_JPRB,2.2675E-01_JPRB,&
&1.9245E-01_JPRB,1.4682E-01_JPRB,1.0619E-01_JPRB,1.4210E+00_JPRB/)
KAO( :, 2,13,10) = (/&
&3.8641E-01_JPRB,3.8425E-01_JPRB,3.8930E-01_JPRB,3.7816E-01_JPRB,3.5501E-01_JPRB,3.1994E-01_JPRB,&
&2.7350E-01_JPRB,2.0671E-01_JPRB,1.4761E-01_JPRB,1.5251E+00_JPRB/)
KAO( :, 3,13,10) = (/&
&5.2089E-01_JPRB,5.2113E-01_JPRB,5.2738E-01_JPRB,5.0973E-01_JPRB,4.7827E-01_JPRB,4.3346E-01_JPRB,&
&3.6991E-01_JPRB,2.7849E-01_JPRB,1.9608E-01_JPRB,1.6238E+00_JPRB/)
KAO( :, 4,13,10) = (/&
&6.7786E-01_JPRB,6.7938E-01_JPRB,6.8608E-01_JPRB,6.6233E-01_JPRB,6.2421E-01_JPRB,5.6410E-01_JPRB,&
&4.8140E-01_JPRB,3.6259E-01_JPRB,2.5473E-01_JPRB,1.7230E+00_JPRB/)
KAO( :, 5,13,10) = (/&
&8.5711E-01_JPRB,8.6068E-01_JPRB,8.6472E-01_JPRB,8.3617E-01_JPRB,7.8602E-01_JPRB,7.1217E-01_JPRB,&
&6.0760E-01_JPRB,4.5966E-01_JPRB,3.2905E-01_JPRB,1.8345E+00_JPRB/)
KAO( :, 1, 1,11) = (/&
&9.4159E-01_JPRB,8.6910E-01_JPRB,9.4939E-01_JPRB,1.0309E+00_JPRB,1.0971E+00_JPRB,1.1597E+00_JPRB,&
&1.1573E+00_JPRB,1.0198E+00_JPRB,1.1259E+00_JPRB,1.1444E+00_JPRB/)
KAO( :, 2, 1,11) = (/&
&1.1816E+00_JPRB,1.0903E+00_JPRB,1.1681E+00_JPRB,1.2491E+00_JPRB,1.3524E+00_JPRB,1.4252E+00_JPRB,&
&1.4017E+00_JPRB,1.2548E+00_JPRB,1.3885E+00_JPRB,1.4161E+00_JPRB/)
KAO( :, 3, 1,11) = (/&
&1.4457E+00_JPRB,1.3338E+00_JPRB,1.4098E+00_JPRB,1.4943E+00_JPRB,1.6257E+00_JPRB,1.6966E+00_JPRB,&
&1.6615E+00_JPRB,1.5145E+00_JPRB,1.6823E+00_JPRB,1.7160E+00_JPRB/)
KAO( :, 4, 1,11) = (/&
&1.7261E+00_JPRB,1.5936E+00_JPRB,1.6676E+00_JPRB,1.7640E+00_JPRB,1.9034E+00_JPRB,1.9816E+00_JPRB,&
&1.9375E+00_JPRB,1.7904E+00_JPRB,1.9915E+00_JPRB,2.0290E+00_JPRB/)
KAO( :, 5, 1,11) = (/&
&2.0222E+00_JPRB,1.8664E+00_JPRB,1.9402E+00_JPRB,2.0588E+00_JPRB,2.1886E+00_JPRB,2.2719E+00_JPRB,&
&2.2171E+00_JPRB,2.1130E+00_JPRB,2.3320E+00_JPRB,2.3861E+00_JPRB/)
KAO( :, 1, 2,11) = (/&
&8.8414E-01_JPRB,8.3470E-01_JPRB,9.0122E-01_JPRB,9.8198E-01_JPRB,1.0450E+00_JPRB,1.0902E+00_JPRB,&
&1.0770E+00_JPRB,9.4855E-01_JPRB,1.0386E+00_JPRB,1.0581E+00_JPRB/)
KAO( :, 2, 2,11) = (/&
&1.1143E+00_JPRB,1.0550E+00_JPRB,1.1151E+00_JPRB,1.2176E+00_JPRB,1.3030E+00_JPRB,1.3437E+00_JPRB,&
&1.3207E+00_JPRB,1.1746E+00_JPRB,1.3022E+00_JPRB,1.3229E+00_JPRB/)
KAO( :, 3, 2,11) = (/&
&1.3705E+00_JPRB,1.3001E+00_JPRB,1.3557E+00_JPRB,1.4797E+00_JPRB,1.5774E+00_JPRB,1.6133E+00_JPRB,&
&1.5892E+00_JPRB,1.4167E+00_JPRB,1.5912E+00_JPRB,1.6096E+00_JPRB/)
KAO( :, 4, 2,11) = (/&
&1.6529E+00_JPRB,1.5667E+00_JPRB,1.6252E+00_JPRB,1.7602E+00_JPRB,1.8638E+00_JPRB,1.8995E+00_JPRB,&
&1.8687E+00_JPRB,1.6782E+00_JPRB,1.8967E+00_JPRB,1.9189E+00_JPRB/)
KAO( :, 5, 2,11) = (/&
&1.9543E+00_JPRB,1.8492E+00_JPRB,1.9198E+00_JPRB,2.0574E+00_JPRB,2.1583E+00_JPRB,2.1944E+00_JPRB,&
&2.1594E+00_JPRB,1.9939E+00_JPRB,2.2472E+00_JPRB,2.2791E+00_JPRB/)
KAO( :, 1, 3,11) = (/&
&8.1869E-01_JPRB,7.7023E-01_JPRB,8.2109E-01_JPRB,8.8336E-01_JPRB,9.2805E-01_JPRB,9.6128E-01_JPRB,&
&9.4856E-01_JPRB,8.5843E-01_JPRB,9.1983E-01_JPRB,9.4743E-01_JPRB/)
KAO( :, 2, 3,11) = (/&
&1.0389E+00_JPRB,9.8615E-01_JPRB,1.0345E+00_JPRB,1.1256E+00_JPRB,1.1752E+00_JPRB,1.2020E+00_JPRB,&
&1.1857E+00_JPRB,1.0608E+00_JPRB,1.1599E+00_JPRB,1.1854E+00_JPRB/)
KAO( :, 3, 3,11) = (/&
&1.2826E+00_JPRB,1.2250E+00_JPRB,1.2747E+00_JPRB,1.3968E+00_JPRB,1.4383E+00_JPRB,1.4671E+00_JPRB,&
&1.4487E+00_JPRB,1.2721E+00_JPRB,1.4175E+00_JPRB,1.4350E+00_JPRB/)
KAO( :, 4, 3,11) = (/&
&1.5564E+00_JPRB,1.4865E+00_JPRB,1.5447E+00_JPRB,1.6881E+00_JPRB,1.7201E+00_JPRB,1.7557E+00_JPRB,&
&1.7225E+00_JPRB,1.5035E+00_JPRB,1.6929E+00_JPRB,1.7100E+00_JPRB/)
KAO( :, 5, 3,11) = (/&
&1.8539E+00_JPRB,1.7704E+00_JPRB,1.8370E+00_JPRB,1.9889E+00_JPRB,2.0183E+00_JPRB,2.0511E+00_JPRB,&
&2.0075E+00_JPRB,1.7816E+00_JPRB,2.0126E+00_JPRB,2.0331E+00_JPRB/)
KAO( :, 1, 4,11) = (/&
&7.6497E-01_JPRB,7.1076E-01_JPRB,7.3295E-01_JPRB,7.7006E-01_JPRB,7.9642E-01_JPRB,8.2481E-01_JPRB,&
&8.2608E-01_JPRB,7.5993E-01_JPRB,8.0777E-01_JPRB,8.2848E-01_JPRB/)
KAO( :, 2, 4,11) = (/&
&9.8352E-01_JPRB,9.1857E-01_JPRB,9.4611E-01_JPRB,1.0073E+00_JPRB,1.0282E+00_JPRB,1.0497E+00_JPRB,&
&1.0467E+00_JPRB,9.5389E-01_JPRB,1.0316E+00_JPRB,1.0517E+00_JPRB/)
KAO( :, 3, 4,11) = (/&
&1.2292E+00_JPRB,1.1512E+00_JPRB,1.1846E+00_JPRB,1.2709E+00_JPRB,1.2824E+00_JPRB,1.3065E+00_JPRB,&
&1.2899E+00_JPRB,1.1574E+00_JPRB,1.2650E+00_JPRB,1.2904E+00_JPRB/)
KAO( :, 4, 4,11) = (/&
&1.5012E+00_JPRB,1.4093E+00_JPRB,1.4510E+00_JPRB,1.5565E+00_JPRB,1.5637E+00_JPRB,1.5870E+00_JPRB,&
&1.5399E+00_JPRB,1.3774E+00_JPRB,1.5183E+00_JPRB,1.5518E+00_JPRB/)
KAO( :, 5, 4,11) = (/&
&1.7934E+00_JPRB,1.6886E+00_JPRB,1.7434E+00_JPRB,1.8620E+00_JPRB,1.8667E+00_JPRB,1.8779E+00_JPRB,&
&1.8058E+00_JPRB,1.6243E+00_JPRB,1.8061E+00_JPRB,1.8476E+00_JPRB/)
KAO( :, 1, 5,11) = (/&
&7.4548E-01_JPRB,6.7814E-01_JPRB,6.5476E-01_JPRB,6.5948E-01_JPRB,6.7934E-01_JPRB,7.0788E-01_JPRB,&
&7.1745E-01_JPRB,6.7353E-01_JPRB,7.0461E-01_JPRB,7.3099E-01_JPRB/)
KAO( :, 2, 5,11) = (/&
&9.5969E-01_JPRB,8.7825E-01_JPRB,8.6017E-01_JPRB,8.8155E-01_JPRB,8.9239E-01_JPRB,9.1670E-01_JPRB,&
&9.2708E-01_JPRB,8.5000E-01_JPRB,9.0728E-01_JPRB,9.3032E-01_JPRB/)
KAO( :, 3, 5,11) = (/&
&1.2058E+00_JPRB,1.1099E+00_JPRB,1.0960E+00_JPRB,1.1330E+00_JPRB,1.1377E+00_JPRB,1.1558E+00_JPRB,&
&1.1565E+00_JPRB,1.0416E+00_JPRB,1.1278E+00_JPRB,1.1476E+00_JPRB/)
KAO( :, 4, 5,11) = (/&
&1.4810E+00_JPRB,1.3671E+00_JPRB,1.3639E+00_JPRB,1.4095E+00_JPRB,1.4162E+00_JPRB,1.4159E+00_JPRB,&
&1.3960E+00_JPRB,1.2531E+00_JPRB,1.3726E+00_JPRB,1.3940E+00_JPRB/)
KAO( :, 5, 5,11) = (/&
&1.7798E+00_JPRB,1.6471E+00_JPRB,1.6584E+00_JPRB,1.7100E+00_JPRB,1.7173E+00_JPRB,1.6890E+00_JPRB,&
&1.6525E+00_JPRB,1.4879E+00_JPRB,1.6471E+00_JPRB,1.6748E+00_JPRB/)
KAO( :, 1, 6,11) = (/&
&7.0565E-01_JPRB,6.4191E-01_JPRB,5.9174E-01_JPRB,5.6344E-01_JPRB,5.7413E-01_JPRB,6.0216E-01_JPRB,&
&6.1735E-01_JPRB,5.8882E-01_JPRB,6.1391E-01_JPRB,6.2532E-01_JPRB/)
KAO( :, 2, 6,11) = (/&
&9.2376E-01_JPRB,8.4064E-01_JPRB,7.8353E-01_JPRB,7.6203E-01_JPRB,7.6995E-01_JPRB,7.9470E-01_JPRB,&
&8.0774E-01_JPRB,7.5710E-01_JPRB,7.9836E-01_JPRB,8.1211E-01_JPRB/)
KAO( :, 3, 6,11) = (/&
&1.1735E+00_JPRB,1.0693E+00_JPRB,1.0163E+00_JPRB,9.9460E-01_JPRB,1.0005E+00_JPRB,1.0222E+00_JPRB,&
&1.0221E+00_JPRB,9.3247E-01_JPRB,9.9633E-01_JPRB,1.0096E+00_JPRB/)
KAO( :, 4, 6,11) = (/&
&1.4611E+00_JPRB,1.3294E+00_JPRB,1.2780E+00_JPRB,1.2558E+00_JPRB,1.2632E+00_JPRB,1.2674E+00_JPRB,&
&1.2528E+00_JPRB,1.1244E+00_JPRB,1.2175E+00_JPRB,1.2339E+00_JPRB/)
KAO( :, 5, 6,11) = (/&
&1.7762E+00_JPRB,1.6171E+00_JPRB,1.5645E+00_JPRB,1.5462E+00_JPRB,1.5483E+00_JPRB,1.5299E+00_JPRB,&
&1.5045E+00_JPRB,1.3389E+00_JPRB,1.4702E+00_JPRB,1.4860E+00_JPRB/)
KAO( :, 1, 7,11) = (/&
&6.4397E-01_JPRB,5.8848E-01_JPRB,5.4164E-01_JPRB,5.0438E-01_JPRB,4.8904E-01_JPRB,5.1205E-01_JPRB,&
&5.2888E-01_JPRB,4.9547E-01_JPRB,5.1219E-01_JPRB,5.1357E-01_JPRB/)
KAO( :, 2, 7,11) = (/&
&8.6014E-01_JPRB,7.8541E-01_JPRB,7.2738E-01_JPRB,6.8109E-01_JPRB,6.6447E-01_JPRB,6.8735E-01_JPRB,&
&7.0610E-01_JPRB,6.4880E-01_JPRB,6.8044E-01_JPRB,6.7457E-01_JPRB/)
KAO( :, 3, 7,11) = (/&
&1.1052E+00_JPRB,1.0089E+00_JPRB,9.5053E-01_JPRB,8.9433E-01_JPRB,8.7834E-01_JPRB,8.9637E-01_JPRB,&
&9.0307E-01_JPRB,8.1519E-01_JPRB,8.6489E-01_JPRB,8.5495E-01_JPRB/)
KAO( :, 4, 7,11) = (/&
&1.3894E+00_JPRB,1.2661E+00_JPRB,1.2117E+00_JPRB,1.1436E+00_JPRB,1.1239E+00_JPRB,1.1302E+00_JPRB,&
&1.1159E+00_JPRB,1.0009E+00_JPRB,1.0705E+00_JPRB,1.0686E+00_JPRB/)
KAO( :, 5, 7,11) = (/&
&1.7112E+00_JPRB,1.5598E+00_JPRB,1.4999E+00_JPRB,1.4251E+00_JPRB,1.3915E+00_JPRB,1.3874E+00_JPRB,&
&1.3517E+00_JPRB,1.2058E+00_JPRB,1.3049E+00_JPRB,1.3059E+00_JPRB/)
KAO( :, 1, 8,11) = (/&
&5.7879E-01_JPRB,5.3274E-01_JPRB,4.8973E-01_JPRB,4.5630E-01_JPRB,4.3269E-01_JPRB,4.3284E-01_JPRB,&
&4.3930E-01_JPRB,4.0946E-01_JPRB,4.1860E-01_JPRB,4.1655E-01_JPRB/)
KAO( :, 2, 8,11) = (/&
&7.8913E-01_JPRB,7.2614E-01_JPRB,6.7155E-01_JPRB,6.2927E-01_JPRB,5.8919E-01_JPRB,5.9377E-01_JPRB,&
&5.9849E-01_JPRB,5.4629E-01_JPRB,5.6116E-01_JPRB,5.5524E-01_JPRB/)
KAO( :, 3, 8,11) = (/&
&1.0315E+00_JPRB,9.4848E-01_JPRB,8.8923E-01_JPRB,8.3184E-01_JPRB,7.8312E-01_JPRB,7.8922E-01_JPRB,&
&7.8217E-01_JPRB,6.9528E-01_JPRB,7.2027E-01_JPRB,7.1126E-01_JPRB/)
KAO( :, 4, 8,11) = (/&
&1.3089E+00_JPRB,1.2030E+00_JPRB,1.1421E+00_JPRB,1.0710E+00_JPRB,1.0184E+00_JPRB,1.0078E+00_JPRB,&
&9.8494E-01_JPRB,8.6981E-01_JPRB,9.1055E-01_JPRB,9.0117E-01_JPRB/)
KAO( :, 5, 8,11) = (/&
&1.6233E+00_JPRB,1.4930E+00_JPRB,1.4334E+00_JPRB,1.3459E+00_JPRB,1.2797E+00_JPRB,1.2512E+00_JPRB,&
&1.2155E+00_JPRB,1.0647E+00_JPRB,1.1303E+00_JPRB,1.1143E+00_JPRB/)
KAO( :, 1, 9,11) = (/&
&5.0872E-01_JPRB,4.7000E-01_JPRB,4.3189E-01_JPRB,4.0703E-01_JPRB,3.8347E-01_JPRB,3.6637E-01_JPRB,&
&3.5722E-01_JPRB,3.3322E-01_JPRB,3.3519E-01_JPRB,4.9629E-01_JPRB/)
KAO( :, 2, 9,11) = (/&
&7.1032E-01_JPRB,6.5670E-01_JPRB,6.0796E-01_JPRB,5.7264E-01_JPRB,5.3661E-01_JPRB,5.0689E-01_JPRB,&
&4.9599E-01_JPRB,4.5581E-01_JPRB,4.5901E-01_JPRB,6.1504E-01_JPRB/)
KAO( :, 3, 9,11) = (/&
&9.4725E-01_JPRB,8.7492E-01_JPRB,8.2052E-01_JPRB,7.7219E-01_JPRB,7.2220E-01_JPRB,6.8379E-01_JPRB,&
&6.5839E-01_JPRB,5.9352E-01_JPRB,5.9853E-01_JPRB,7.1363E-01_JPRB/)
KAO( :, 4, 9,11) = (/&
&1.2212E+00_JPRB,1.1285E+00_JPRB,1.0680E+00_JPRB,1.0029E+00_JPRB,9.4208E-01_JPRB,8.9072E-01_JPRB,&
&8.4577E-01_JPRB,7.5557E-01_JPRB,7.6527E-01_JPRB,8.0522E-01_JPRB/)
KAO( :, 5, 9,11) = (/&
&1.5263E+00_JPRB,1.4126E+00_JPRB,1.3499E+00_JPRB,1.2718E+00_JPRB,1.1921E+00_JPRB,1.1220E+00_JPRB,&
&1.0685E+00_JPRB,9.3213E-01_JPRB,9.5775E-01_JPRB,9.4303E-01_JPRB/)
KAO( :, 1,10,11) = (/&
&4.4834E-01_JPRB,4.1596E-01_JPRB,3.8519E-01_JPRB,3.6738E-01_JPRB,3.4707E-01_JPRB,3.1667E-01_JPRB,&
&2.9935E-01_JPRB,2.7308E-01_JPRB,2.6993E-01_JPRB,8.6202E-01_JPRB/)
KAO( :, 2,10,11) = (/&
&6.4018E-01_JPRB,5.9476E-01_JPRB,5.5452E-01_JPRB,5.2742E-01_JPRB,4.9444E-01_JPRB,4.5039E-01_JPRB,&
&4.1885E-01_JPRB,3.8235E-01_JPRB,3.7606E-01_JPRB,1.0050E+00_JPRB/)
KAO( :, 3,10,11) = (/&
&8.6941E-01_JPRB,8.0719E-01_JPRB,7.6128E-01_JPRB,7.2083E-01_JPRB,6.7778E-01_JPRB,6.1132E-01_JPRB,&
&5.6485E-01_JPRB,5.0977E-01_JPRB,5.0052E-01_JPRB,1.1879E+00_JPRB/)
KAO( :, 4,10,11) = (/&
&1.1374E+00_JPRB,1.0578E+00_JPRB,1.0048E+00_JPRB,9.4669E-01_JPRB,8.9485E-01_JPRB,8.0262E-01_JPRB,&
&7.3730E-01_JPRB,6.6231E-01_JPRB,6.5210E-01_JPRB,1.3926E+00_JPRB/)
KAO( :, 5,10,11) = (/&
&1.4379E+00_JPRB,1.3398E+00_JPRB,1.2800E+00_JPRB,1.2099E+00_JPRB,1.1369E+00_JPRB,1.0290E+00_JPRB,&
&9.4239E-01_JPRB,8.2621E-01_JPRB,8.2033E-01_JPRB,1.5987E+00_JPRB/)
KAO( :, 1,11,11) = (/&
&4.6437E-01_JPRB,4.3195E-01_JPRB,4.0640E-01_JPRB,3.9083E-01_JPRB,3.6759E-01_JPRB,3.3095E-01_JPRB,&
&2.9621E-01_JPRB,2.6059E-01_JPRB,2.4898E-01_JPRB,1.4424E+00_JPRB/)
KAO( :, 2,11,11) = (/&
&6.5995E-01_JPRB,6.1504E-01_JPRB,5.8354E-01_JPRB,5.6109E-01_JPRB,5.2448E-01_JPRB,4.7076E-01_JPRB,&
&4.1510E-01_JPRB,3.6345E-01_JPRB,3.4571E-01_JPRB,1.5679E+00_JPRB/)
KAO( :, 3,11,11) = (/&
&8.9627E-01_JPRB,8.3726E-01_JPRB,7.9810E-01_JPRB,7.6313E-01_JPRB,7.1561E-01_JPRB,6.3926E-01_JPRB,&
&5.5804E-01_JPRB,4.8959E-01_JPRB,4.6565E-01_JPRB,1.7093E+00_JPRB/)
KAO( :, 4,11,11) = (/&
&1.1695E+00_JPRB,1.0949E+00_JPRB,1.0494E+00_JPRB,9.9979E-01_JPRB,9.3792E-01_JPRB,8.3384E-01_JPRB,&
&7.3304E-01_JPRB,6.3611E-01_JPRB,6.0648E-01_JPRB,1.8687E+00_JPRB/)
KAO( :, 5,11,11) = (/&
&1.4756E+00_JPRB,1.3865E+00_JPRB,1.3306E+00_JPRB,1.2700E+00_JPRB,1.1860E+00_JPRB,1.0648E+00_JPRB,&
&9.3310E-01_JPRB,7.9796E-01_JPRB,7.6114E-01_JPRB,2.0433E+00_JPRB/)
KAO( :, 1,12,11) = (/&
&4.6883E-01_JPRB,4.3992E-01_JPRB,4.2363E-01_JPRB,4.0991E-01_JPRB,3.8267E-01_JPRB,3.4548E-01_JPRB,&
&2.9549E-01_JPRB,2.4606E-01_JPRB,2.2406E-01_JPRB,1.9161E+00_JPRB/)
KAO( :, 2,12,11) = (/&
&6.6619E-01_JPRB,6.2643E-01_JPRB,6.0394E-01_JPRB,5.8416E-01_JPRB,5.4621E-01_JPRB,4.9020E-01_JPRB,&
&4.1568E-01_JPRB,3.4416E-01_JPRB,3.1499E-01_JPRB,2.0541E+00_JPRB/)
KAO( :, 3,12,11) = (/&
&9.0247E-01_JPRB,8.5182E-01_JPRB,8.2328E-01_JPRB,7.9362E-01_JPRB,7.4057E-01_JPRB,6.6249E-01_JPRB,&
&5.6167E-01_JPRB,4.6621E-01_JPRB,4.2576E-01_JPRB,2.2005E+00_JPRB/)
KAO( :, 4,12,11) = (/&
&1.1754E+00_JPRB,1.1141E+00_JPRB,1.0763E+00_JPRB,1.0393E+00_JPRB,9.6314E-01_JPRB,8.6349E-01_JPRB,&
&7.3733E-01_JPRB,6.0555E-01_JPRB,5.5108E-01_JPRB,2.3506E+00_JPRB/)
KAO( :, 5,12,11) = (/&
&1.4816E+00_JPRB,1.4118E+00_JPRB,1.3630E+00_JPRB,1.3109E+00_JPRB,1.2174E+00_JPRB,1.0945E+00_JPRB,&
&9.3470E-01_JPRB,7.6327E-01_JPRB,6.9458E-01_JPRB,2.4817E+00_JPRB/)
KAO( :, 1,13,11) = (/&
&4.6581E-01_JPRB,4.3907E-01_JPRB,4.3125E-01_JPRB,4.2012E-01_JPRB,3.9142E-01_JPRB,3.5288E-01_JPRB,&
&2.9764E-01_JPRB,2.3165E-01_JPRB,2.0022E-01_JPRB,2.0038E+00_JPRB/)
KAO( :, 2,13,11) = (/&
&6.6014E-01_JPRB,6.2525E-01_JPRB,6.1363E-01_JPRB,5.9556E-01_JPRB,5.5565E-01_JPRB,4.9958E-01_JPRB,&
&4.1989E-01_JPRB,3.2603E-01_JPRB,2.8204E-01_JPRB,2.1506E+00_JPRB/)
KAO( :, 3,13,11) = (/&
&8.9162E-01_JPRB,8.4866E-01_JPRB,8.3231E-01_JPRB,8.0747E-01_JPRB,7.5010E-01_JPRB,6.7287E-01_JPRB,&
&5.6952E-01_JPRB,4.4032E-01_JPRB,3.7944E-01_JPRB,2.2963E+00_JPRB/)
KAO( :, 4,13,11) = (/&
&1.1582E+00_JPRB,1.1105E+00_JPRB,1.0865E+00_JPRB,1.0526E+00_JPRB,9.7320E-01_JPRB,8.7688E-01_JPRB,&
&7.4169E-01_JPRB,5.7254E-01_JPRB,4.9090E-01_JPRB,2.4264E+00_JPRB/)
KAO( :, 5,13,11) = (/&
&1.4557E+00_JPRB,1.4054E+00_JPRB,1.3756E+00_JPRB,1.3241E+00_JPRB,1.2283E+00_JPRB,1.1037E+00_JPRB,&
&9.3580E-01_JPRB,7.2342E-01_JPRB,6.1924E-01_JPRB,2.5526E+00_JPRB/)
KAO( :, 1, 1,12) = (/&
&1.9899E+00_JPRB,1.7416E+00_JPRB,1.6557E+00_JPRB,1.6626E+00_JPRB,1.6292E+00_JPRB,1.6186E+00_JPRB,&
&1.5516E+00_JPRB,1.5111E+00_JPRB,1.6515E+00_JPRB,1.6999E+00_JPRB/)
KAO( :, 2, 1,12) = (/&
&2.4167E+00_JPRB,2.1150E+00_JPRB,2.0285E+00_JPRB,2.0154E+00_JPRB,1.9446E+00_JPRB,1.9378E+00_JPRB,&
&1.8912E+00_JPRB,1.8727E+00_JPRB,2.0572E+00_JPRB,2.1137E+00_JPRB/)
KAO( :, 3, 1,12) = (/&
&2.8678E+00_JPRB,2.5098E+00_JPRB,2.4251E+00_JPRB,2.3840E+00_JPRB,2.2898E+00_JPRB,2.2925E+00_JPRB,&
&2.2262E+00_JPRB,2.2528E+00_JPRB,2.4748E+00_JPRB,2.5402E+00_JPRB/)
KAO( :, 4, 1,12) = (/&
&3.3334E+00_JPRB,2.9172E+00_JPRB,2.8340E+00_JPRB,2.7633E+00_JPRB,2.6747E+00_JPRB,2.6799E+00_JPRB,&
&2.5511E+00_JPRB,2.6575E+00_JPRB,2.9171E+00_JPRB,2.9951E+00_JPRB/)
KAO( :, 5, 1,12) = (/&
&3.8070E+00_JPRB,3.3317E+00_JPRB,3.2431E+00_JPRB,3.1434E+00_JPRB,3.0844E+00_JPRB,3.0767E+00_JPRB,&
&2.8871E+00_JPRB,3.0851E+00_JPRB,3.3768E+00_JPRB,3.4700E+00_JPRB/)
KAO( :, 1, 2,12) = (/&
&1.8020E+00_JPRB,1.5771E+00_JPRB,1.5658E+00_JPRB,1.5529E+00_JPRB,1.5678E+00_JPRB,1.5609E+00_JPRB,&
&1.5068E+00_JPRB,1.4322E+00_JPRB,1.5794E+00_JPRB,1.6265E+00_JPRB/)
KAO( :, 2, 2,12) = (/&
&2.2244E+00_JPRB,1.9467E+00_JPRB,1.9376E+00_JPRB,1.8878E+00_JPRB,1.8907E+00_JPRB,1.9156E+00_JPRB,&
&1.8451E+00_JPRB,1.7806E+00_JPRB,1.9775E+00_JPRB,2.0248E+00_JPRB/)
KAO( :, 3, 2,12) = (/&
&2.6777E+00_JPRB,2.3433E+00_JPRB,2.3279E+00_JPRB,2.2466E+00_JPRB,2.2434E+00_JPRB,2.3061E+00_JPRB,&
&2.1731E+00_JPRB,2.1601E+00_JPRB,2.3971E+00_JPRB,2.4544E+00_JPRB/)
KAO( :, 4, 2,12) = (/&
&3.1544E+00_JPRB,2.7605E+00_JPRB,2.7326E+00_JPRB,2.6320E+00_JPRB,2.6342E+00_JPRB,2.7059E+00_JPRB,&
&2.5082E+00_JPRB,2.5770E+00_JPRB,2.8498E+00_JPRB,2.9233E+00_JPRB/)
KAO( :, 5, 2,12) = (/&
&3.6408E+00_JPRB,3.1864E+00_JPRB,3.1392E+00_JPRB,3.0321E+00_JPRB,3.0540E+00_JPRB,3.0950E+00_JPRB,&
&2.8509E+00_JPRB,3.0202E+00_JPRB,3.3350E+00_JPRB,3.4273E+00_JPRB/)
KAO( :, 1, 3,12) = (/&
&1.5649E+00_JPRB,1.3732E+00_JPRB,1.3826E+00_JPRB,1.4020E+00_JPRB,1.4318E+00_JPRB,1.4266E+00_JPRB,&
&1.3676E+00_JPRB,1.2621E+00_JPRB,1.4113E+00_JPRB,1.4411E+00_JPRB/)
KAO( :, 2, 3,12) = (/&
&1.9750E+00_JPRB,1.7323E+00_JPRB,1.7348E+00_JPRB,1.7212E+00_JPRB,1.7704E+00_JPRB,1.7925E+00_JPRB,&
&1.6949E+00_JPRB,1.5960E+00_JPRB,1.7832E+00_JPRB,1.8209E+00_JPRB/)
KAO( :, 3, 3,12) = (/&
&2.4222E+00_JPRB,2.1256E+00_JPRB,2.1157E+00_JPRB,2.0688E+00_JPRB,2.1464E+00_JPRB,2.1852E+00_JPRB,&
&2.0239E+00_JPRB,1.9726E+00_JPRB,2.1958E+00_JPRB,2.2498E+00_JPRB/)
KAO( :, 4, 3,12) = (/&
&2.9000E+00_JPRB,2.5481E+00_JPRB,2.5206E+00_JPRB,2.4500E+00_JPRB,2.5548E+00_JPRB,2.5853E+00_JPRB,&
&2.3675E+00_JPRB,2.3891E+00_JPRB,2.6536E+00_JPRB,2.7238E+00_JPRB/)
KAO( :, 5, 3,12) = (/&
&3.3931E+00_JPRB,2.9865E+00_JPRB,2.9396E+00_JPRB,2.8624E+00_JPRB,2.9741E+00_JPRB,2.9949E+00_JPRB,&
&2.7166E+00_JPRB,2.8252E+00_JPRB,3.1477E+00_JPRB,3.2225E+00_JPRB/)
KAO( :, 1, 4,12) = (/&
&1.3280E+00_JPRB,1.1786E+00_JPRB,1.2003E+00_JPRB,1.2384E+00_JPRB,1.2621E+00_JPRB,1.2623E+00_JPRB,&
&1.2074E+00_JPRB,1.0954E+00_JPRB,1.2178E+00_JPRB,1.2519E+00_JPRB/)
KAO( :, 2, 4,12) = (/&
&1.7214E+00_JPRB,1.5303E+00_JPRB,1.5296E+00_JPRB,1.5581E+00_JPRB,1.6045E+00_JPRB,1.6160E+00_JPRB,&
&1.5191E+00_JPRB,1.4004E+00_JPRB,1.5599E+00_JPRB,1.5995E+00_JPRB/)
KAO( :, 3, 4,12) = (/&
&2.1531E+00_JPRB,1.9184E+00_JPRB,1.8960E+00_JPRB,1.9073E+00_JPRB,1.9909E+00_JPRB,1.9956E+00_JPRB,&
&1.8466E+00_JPRB,1.7529E+00_JPRB,1.9597E+00_JPRB,2.0020E+00_JPRB/)
KAO( :, 4, 4,12) = (/&
&2.6259E+00_JPRB,2.3421E+00_JPRB,2.3006E+00_JPRB,2.2911E+00_JPRB,2.4098E+00_JPRB,2.3862E+00_JPRB,&
&2.2059E+00_JPRB,2.1477E+00_JPRB,2.4083E+00_JPRB,2.4533E+00_JPRB/)
KAO( :, 5, 4,12) = (/&
&3.1312E+00_JPRB,2.7951E+00_JPRB,2.7289E+00_JPRB,2.7098E+00_JPRB,2.8440E+00_JPRB,2.7955E+00_JPRB,&
&2.5674E+00_JPRB,2.5718E+00_JPRB,2.8862E+00_JPRB,2.9375E+00_JPRB/)
KAO( :, 1, 5,12) = (/&
&1.1161E+00_JPRB,1.0073E+00_JPRB,1.0475E+00_JPRB,1.0704E+00_JPRB,1.0924E+00_JPRB,1.0965E+00_JPRB,&
&1.0516E+00_JPRB,9.4881E-01_JPRB,1.0568E+00_JPRB,1.0851E+00_JPRB/)
KAO( :, 2, 5,12) = (/&
&1.4852E+00_JPRB,1.3439E+00_JPRB,1.3607E+00_JPRB,1.3892E+00_JPRB,1.4288E+00_JPRB,1.4308E+00_JPRB,&
&1.3421E+00_JPRB,1.2297E+00_JPRB,1.3696E+00_JPRB,1.4061E+00_JPRB/)
KAO( :, 3, 5,12) = (/&
&1.9072E+00_JPRB,1.7266E+00_JPRB,1.7136E+00_JPRB,1.7495E+00_JPRB,1.8113E+00_JPRB,1.7903E+00_JPRB,&
&1.6625E+00_JPRB,1.5561E+00_JPRB,1.7354E+00_JPRB,1.7786E+00_JPRB/)
KAO( :, 4, 5,12) = (/&
&2.3754E+00_JPRB,2.1543E+00_JPRB,2.1024E+00_JPRB,2.1512E+00_JPRB,2.2237E+00_JPRB,2.1735E+00_JPRB,&
&2.0175E+00_JPRB,1.9176E+00_JPRB,2.1504E+00_JPRB,2.1913E+00_JPRB/)
KAO( :, 5, 5,12) = (/&
&2.8766E+00_JPRB,2.6154E+00_JPRB,2.5264E+00_JPRB,2.5896E+00_JPRB,2.6493E+00_JPRB,2.5886E+00_JPRB,&
&2.3776E+00_JPRB,2.3037E+00_JPRB,2.5969E+00_JPRB,2.6316E+00_JPRB/)
KAO( :, 1, 6,12) = (/&
&9.4985E-01_JPRB,8.5933E-01_JPRB,8.8898E-01_JPRB,9.0232E-01_JPRB,9.2354E-01_JPRB,9.3066E-01_JPRB,&
&9.0486E-01_JPRB,8.1739E-01_JPRB,9.0706E-01_JPRB,9.3532E-01_JPRB/)
KAO( :, 2, 6,12) = (/&
&1.2834E+00_JPRB,1.1690E+00_JPRB,1.1908E+00_JPRB,1.2086E+00_JPRB,1.2415E+00_JPRB,1.2368E+00_JPRB,&
&1.1756E+00_JPRB,1.0742E+00_JPRB,1.1928E+00_JPRB,1.2288E+00_JPRB/)
KAO( :, 3, 6,12) = (/&
&1.6799E+00_JPRB,1.5378E+00_JPRB,1.5358E+00_JPRB,1.5673E+00_JPRB,1.6035E+00_JPRB,1.5726E+00_JPRB,&
&1.4795E+00_JPRB,1.3798E+00_JPRB,1.5315E+00_JPRB,1.5776E+00_JPRB/)
KAO( :, 4, 6,12) = (/&
&2.1238E+00_JPRB,1.9529E+00_JPRB,1.9235E+00_JPRB,1.9758E+00_JPRB,1.9970E+00_JPRB,1.9496E+00_JPRB,&
&1.8190E+00_JPRB,1.7092E+00_JPRB,1.9137E+00_JPRB,1.9536E+00_JPRB/)
KAO( :, 5, 6,12) = (/&
&2.6095E+00_JPRB,2.4084E+00_JPRB,2.3509E+00_JPRB,2.4228E+00_JPRB,2.4180E+00_JPRB,2.3618E+00_JPRB,&
&2.1597E+00_JPRB,2.0675E+00_JPRB,2.3214E+00_JPRB,2.3618E+00_JPRB/)
KAO( :, 1, 7,12) = (/&
&8.4812E-01_JPRB,7.6841E-01_JPRB,7.5326E-01_JPRB,7.5035E-01_JPRB,7.7118E-01_JPRB,7.8872E-01_JPRB,&
&7.7183E-01_JPRB,7.0585E-01_JPRB,7.7946E-01_JPRB,8.0795E-01_JPRB/)
KAO( :, 2, 7,12) = (/&
&1.1465E+00_JPRB,1.0445E+00_JPRB,1.0290E+00_JPRB,1.0370E+00_JPRB,1.0598E+00_JPRB,1.0683E+00_JPRB,&
&1.0242E+00_JPRB,9.3963E-01_JPRB,1.0386E+00_JPRB,1.0754E+00_JPRB/)
KAO( :, 3, 7,12) = (/&
&1.5193E+00_JPRB,1.3894E+00_JPRB,1.3649E+00_JPRB,1.3853E+00_JPRB,1.3982E+00_JPRB,1.3813E+00_JPRB,&
&1.3178E+00_JPRB,1.2173E+00_JPRB,1.3509E+00_JPRB,1.3914E+00_JPRB/)
KAO( :, 4, 7,12) = (/&
&1.9518E+00_JPRB,1.7884E+00_JPRB,1.7513E+00_JPRB,1.7865E+00_JPRB,1.7771E+00_JPRB,1.7370E+00_JPRB,&
&1.6446E+00_JPRB,1.5222E+00_JPRB,1.7063E+00_JPRB,1.7391E+00_JPRB/)
KAO( :, 5, 7,12) = (/&
&2.4259E+00_JPRB,2.2279E+00_JPRB,2.1794E+00_JPRB,2.2290E+00_JPRB,2.1962E+00_JPRB,2.1299E+00_JPRB,&
&1.9788E+00_JPRB,1.8585E+00_JPRB,2.0857E+00_JPRB,2.1225E+00_JPRB/)
KAO( :, 1, 8,12) = (/&
&7.7841E-01_JPRB,7.0711E-01_JPRB,6.6522E-01_JPRB,6.3606E-01_JPRB,6.4760E-01_JPRB,6.6713E-01_JPRB,&
&6.6148E-01_JPRB,6.0390E-01_JPRB,6.6973E-01_JPRB,6.8843E-01_JPRB/)
KAO( :, 2, 8,12) = (/&
&1.0658E+00_JPRB,9.6636E-01_JPRB,9.1583E-01_JPRB,8.8699E-01_JPRB,9.0848E-01_JPRB,9.1965E-01_JPRB,&
&8.9372E-01_JPRB,8.1955E-01_JPRB,9.1141E-01_JPRB,9.3497E-01_JPRB/)
KAO( :, 3, 8,12) = (/&
&1.4137E+00_JPRB,1.2836E+00_JPRB,1.2307E+00_JPRB,1.2115E+00_JPRB,1.2232E+00_JPRB,1.2116E+00_JPRB,&
&1.1659E+00_JPRB,1.0732E+00_JPRB,1.1969E+00_JPRB,1.2259E+00_JPRB/)
KAO( :, 4, 8,12) = (/&
&1.8330E+00_JPRB,1.6670E+00_JPRB,1.6047E+00_JPRB,1.5956E+00_JPRB,1.5811E+00_JPRB,1.5515E+00_JPRB,&
&1.4752E+00_JPRB,1.3507E+00_JPRB,1.5186E+00_JPRB,1.5425E+00_JPRB/)
KAO( :, 5, 8,12) = (/&
&2.3049E+00_JPRB,2.1036E+00_JPRB,2.0278E+00_JPRB,2.0220E+00_JPRB,1.9855E+00_JPRB,1.9308E+00_JPRB,&
&1.8019E+00_JPRB,1.6605E+00_JPRB,1.8705E+00_JPRB,1.8963E+00_JPRB/)
KAO( :, 1, 9,12) = (/&
&7.0912E-01_JPRB,6.4469E-01_JPRB,5.9363E-01_JPRB,5.5627E-01_JPRB,5.5384E-01_JPRB,5.6186E-01_JPRB,&
&5.5927E-01_JPRB,5.0354E-01_JPRB,5.6125E-01_JPRB,7.4969E-01_JPRB/)
KAO( :, 2, 9,12) = (/&
&9.9527E-01_JPRB,9.0550E-01_JPRB,8.3442E-01_JPRB,7.8264E-01_JPRB,7.7752E-01_JPRB,7.8969E-01_JPRB,&
&7.7692E-01_JPRB,6.9354E-01_JPRB,7.7793E-01_JPRB,8.7043E-01_JPRB/)
KAO( :, 3, 9,12) = (/&
&1.3412E+00_JPRB,1.2190E+00_JPRB,1.1268E+00_JPRB,1.0743E+00_JPRB,1.0606E+00_JPRB,1.0614E+00_JPRB,&
&1.0350E+00_JPRB,9.2237E-01_JPRB,1.0409E+00_JPRB,1.0573E+00_JPRB/)
KAO( :, 4, 9,12) = (/&
&1.7493E+00_JPRB,1.5874E+00_JPRB,1.4863E+00_JPRB,1.4310E+00_JPRB,1.3986E+00_JPRB,1.3843E+00_JPRB,&
&1.3254E+00_JPRB,1.1771E+00_JPRB,1.3374E+00_JPRB,1.3371E+00_JPRB/)
KAO( :, 5, 9,12) = (/&
&2.2176E+00_JPRB,2.0127E+00_JPRB,1.9126E+00_JPRB,1.8371E+00_JPRB,1.7903E+00_JPRB,1.7504E+00_JPRB,&
&1.6358E+00_JPRB,1.4630E+00_JPRB,1.6600E+00_JPRB,1.6679E+00_JPRB/)
KAO( :, 1,10,12) = (/&
&6.5376E-01_JPRB,5.9649E-01_JPRB,5.4382E-01_JPRB,5.0392E-01_JPRB,4.9222E-01_JPRB,4.9094E-01_JPRB,&
&4.7672E-01_JPRB,4.1966E-01_JPRB,4.6921E-01_JPRB,1.3769E+00_JPRB/)
KAO( :, 2,10,12) = (/&
&9.3800E-01_JPRB,8.5670E-01_JPRB,7.8367E-01_JPRB,7.2595E-01_JPRB,6.9805E-01_JPRB,6.9533E-01_JPRB,&
&6.7619E-01_JPRB,5.9132E-01_JPRB,6.6160E-01_JPRB,1.6706E+00_JPRB/)
KAO( :, 3,10,12) = (/&
&1.2854E+00_JPRB,1.1741E+00_JPRB,1.0774E+00_JPRB,1.0008E+00_JPRB,9.5668E-01_JPRB,9.5165E-01_JPRB,&
&9.1656E-01_JPRB,7.9224E-01_JPRB,8.9510E-01_JPRB,1.9785E+00_JPRB/)
KAO( :, 4,10,12) = (/&
&1.6921E+00_JPRB,1.5448E+00_JPRB,1.4301E+00_JPRB,1.3361E+00_JPRB,1.2735E+00_JPRB,1.2587E+00_JPRB,&
&1.1957E+00_JPRB,1.0181E+00_JPRB,1.1609E+00_JPRB,2.2894E+00_JPRB/)
KAO( :, 5,10,12) = (/&
&2.1576E+00_JPRB,1.9664E+00_JPRB,1.8494E+00_JPRB,1.7300E+00_JPRB,1.6509E+00_JPRB,1.6070E+00_JPRB,&
&1.4973E+00_JPRB,1.2816E+00_JPRB,1.4648E+00_JPRB,2.6067E+00_JPRB/)
KAO( :, 1,11,12) = (/&
&7.0952E-01_JPRB,6.5053E-01_JPRB,5.9316E-01_JPRB,5.5146E-01_JPRB,5.2180E-01_JPRB,5.0652E-01_JPRB,&
&4.7718E-01_JPRB,4.1246E-01_JPRB,4.5783E-01_JPRB,2.0241E+00_JPRB/)
KAO( :, 2,11,12) = (/&
&1.0167E+00_JPRB,9.3262E-01_JPRB,8.5333E-01_JPRB,7.9232E-01_JPRB,7.4499E-01_JPRB,7.1140E-01_JPRB,&
&6.7465E-01_JPRB,5.7859E-01_JPRB,6.4613E-01_JPRB,2.2912E+00_JPRB/)
KAO( :, 3,11,12) = (/&
&1.3886E+00_JPRB,1.2732E+00_JPRB,1.1736E+00_JPRB,1.0906E+00_JPRB,1.0139E+00_JPRB,9.7034E-01_JPRB,&
&9.1240E-01_JPRB,7.7049E-01_JPRB,8.6376E-01_JPRB,2.6463E+00_JPRB/)
KAO( :, 4,11,12) = (/&
&1.8181E+00_JPRB,1.6680E+00_JPRB,1.5549E+00_JPRB,1.4417E+00_JPRB,1.3425E+00_JPRB,1.2830E+00_JPRB,&
&1.1836E+00_JPRB,9.8857E-01_JPRB,1.1129E+00_JPRB,3.0263E+00_JPRB/)
KAO( :, 5,11,12) = (/&
&2.3057E+00_JPRB,2.1146E+00_JPRB,1.9950E+00_JPRB,1.8508E+00_JPRB,1.7289E+00_JPRB,1.6307E+00_JPRB,&
&1.4919E+00_JPRB,1.2455E+00_JPRB,1.4085E+00_JPRB,3.4186E+00_JPRB/)
KAO( :, 1,12,12) = (/&
&7.5886E-01_JPRB,6.9796E-01_JPRB,6.3852E-01_JPRB,5.9929E-01_JPRB,5.5990E-01_JPRB,5.1924E-01_JPRB,&
&4.7840E-01_JPRB,4.0341E-01_JPRB,4.4154E-01_JPRB,2.6087E+00_JPRB/)
KAO( :, 2,12,12) = (/&
&1.0851E+00_JPRB,9.9770E-01_JPRB,9.1673E-01_JPRB,8.5899E-01_JPRB,7.9809E-01_JPRB,7.3287E-01_JPRB,&
&6.7148E-01_JPRB,5.6350E-01_JPRB,6.1612E-01_JPRB,2.8310E+00_JPRB/)
KAO( :, 3,12,12) = (/&
&1.4755E+00_JPRB,1.3573E+00_JPRB,1.2579E+00_JPRB,1.1774E+00_JPRB,1.0886E+00_JPRB,9.9484E-01_JPRB,&
&9.0354E-01_JPRB,7.5007E-01_JPRB,8.2214E-01_JPRB,3.1388E+00_JPRB/)
KAO( :, 4,12,12) = (/&
&1.9253E+00_JPRB,1.7711E+00_JPRB,1.6604E+00_JPRB,1.5471E+00_JPRB,1.4336E+00_JPRB,1.3051E+00_JPRB,&
&1.1698E+00_JPRB,9.7140E-01_JPRB,1.0651E+00_JPRB,3.4850E+00_JPRB/)
KAO( :, 5,12,12) = (/&
&2.4308E+00_JPRB,2.2396E+00_JPRB,2.1167E+00_JPRB,1.9729E+00_JPRB,1.8272E+00_JPRB,1.6585E+00_JPRB,&
&1.4809E+00_JPRB,1.2177E+00_JPRB,1.3448E+00_JPRB,3.8825E+00_JPRB/)
KAO( :, 1,13,12) = (/&
&7.9229E-01_JPRB,7.3221E-01_JPRB,6.7737E-01_JPRB,6.4130E-01_JPRB,5.9847E-01_JPRB,5.3580E-01_JPRB,&
&4.7728E-01_JPRB,3.9003E-01_JPRB,4.1400E-01_JPRB,2.7638E+00_JPRB/)
KAO( :, 2,13,12) = (/&
&1.1297E+00_JPRB,1.0450E+00_JPRB,9.7140E-01_JPRB,9.1618E-01_JPRB,8.5138E-01_JPRB,7.6006E-01_JPRB,&
&6.6619E-01_JPRB,5.4383E-01_JPRB,5.7638E-01_JPRB,2.9703E+00_JPRB/)
KAO( :, 3,13,12) = (/&
&1.5310E+00_JPRB,1.4169E+00_JPRB,1.3280E+00_JPRB,1.2470E+00_JPRB,1.1584E+00_JPRB,1.0272E+00_JPRB,&
&8.9295E-01_JPRB,7.3007E-01_JPRB,7.7208E-01_JPRB,3.2180E+00_JPRB/)
KAO( :, 4,13,12) = (/&
&1.9939E+00_JPRB,1.8457E+00_JPRB,1.7416E+00_JPRB,1.6315E+00_JPRB,1.5169E+00_JPRB,1.3360E+00_JPRB,&
&1.1634E+00_JPRB,9.4900E-01_JPRB,1.0058E+00_JPRB,3.5288E+00_JPRB/)
KAO( :, 5,13,12) = (/&
&2.5079E+00_JPRB,2.3287E+00_JPRB,2.2043E+00_JPRB,2.0691E+00_JPRB,1.9162E+00_JPRB,1.6967E+00_JPRB,&
&1.4732E+00_JPRB,1.1903E+00_JPRB,1.2641E+00_JPRB,3.8603E+00_JPRB/)
KAO( :, 1, 1,13) = (/&
&3.9649E+00_JPRB,3.4696E+00_JPRB,2.9742E+00_JPRB,2.6893E+00_JPRB,2.5814E+00_JPRB,2.2539E+00_JPRB,&
&1.9591E+00_JPRB,2.1953E+00_JPRB,2.3585E+00_JPRB,2.4435E+00_JPRB/)
KAO( :, 2, 1,13) = (/&
&4.6934E+00_JPRB,4.1070E+00_JPRB,3.5206E+00_JPRB,3.2425E+00_JPRB,3.0762E+00_JPRB,2.6670E+00_JPRB,&
&2.3213E+00_JPRB,2.6577E+00_JPRB,2.8281E+00_JPRB,2.9391E+00_JPRB/)
KAO( :, 3, 1,13) = (/&
&5.4309E+00_JPRB,4.7524E+00_JPRB,4.0738E+00_JPRB,3.8211E+00_JPRB,3.5699E+00_JPRB,3.1013E+00_JPRB,&
&2.7446E+00_JPRB,3.1848E+00_JPRB,3.3841E+00_JPRB,3.5205E+00_JPRB/)
KAO( :, 4, 1,13) = (/&
&6.1708E+00_JPRB,5.3997E+00_JPRB,4.6331E+00_JPRB,4.4110E+00_JPRB,4.0650E+00_JPRB,3.5506E+00_JPRB,&
&3.2653E+00_JPRB,3.7939E+00_JPRB,4.0349E+00_JPRB,4.1946E+00_JPRB/)
KAO( :, 5, 1,13) = (/&
&6.8879E+00_JPRB,6.0273E+00_JPRB,5.1873E+00_JPRB,4.9821E+00_JPRB,4.5559E+00_JPRB,4.0078E+00_JPRB,&
&3.8433E+00_JPRB,4.4688E+00_JPRB,4.7724E+00_JPRB,4.9544E+00_JPRB/)
KAO( :, 1, 2,13) = (/&
&3.6698E+00_JPRB,3.2113E+00_JPRB,2.7634E+00_JPRB,2.6220E+00_JPRB,2.4498E+00_JPRB,2.2177E+00_JPRB,&
&1.9317E+00_JPRB,2.1759E+00_JPRB,2.3566E+00_JPRB,2.4539E+00_JPRB/)
KAO( :, 2, 2,13) = (/&
&4.3922E+00_JPRB,3.8433E+00_JPRB,3.3174E+00_JPRB,3.1962E+00_JPRB,2.9402E+00_JPRB,2.6303E+00_JPRB,&
&2.3496E+00_JPRB,2.7064E+00_JPRB,2.8995E+00_JPRB,3.0421E+00_JPRB/)
KAO( :, 3, 2,13) = (/&
&5.1315E+00_JPRB,4.4903E+00_JPRB,3.8960E+00_JPRB,3.7804E+00_JPRB,3.4475E+00_JPRB,3.0575E+00_JPRB,&
&2.8478E+00_JPRB,3.3075E+00_JPRB,3.5154E+00_JPRB,3.7101E+00_JPRB/)
KAO( :, 4, 2,13) = (/&
&5.8800E+00_JPRB,5.1453E+00_JPRB,4.4924E+00_JPRB,4.3646E+00_JPRB,3.9642E+00_JPRB,3.5208E+00_JPRB,&
&3.3891E+00_JPRB,3.9399E+00_JPRB,4.1954E+00_JPRB,4.4214E+00_JPRB/)
KAO( :, 5, 2,13) = (/&
&6.6101E+00_JPRB,5.7841E+00_JPRB,5.0872E+00_JPRB,4.9348E+00_JPRB,4.4777E+00_JPRB,4.0458E+00_JPRB,&
&3.9713E+00_JPRB,4.6160E+00_JPRB,4.9393E+00_JPRB,5.1870E+00_JPRB/)
KAO( :, 1, 3,13) = (/&
&3.2411E+00_JPRB,2.8361E+00_JPRB,2.4831E+00_JPRB,2.4070E+00_JPRB,2.2480E+00_JPRB,2.0870E+00_JPRB,&
&1.8051E+00_JPRB,2.0202E+00_JPRB,2.1994E+00_JPRB,2.3002E+00_JPRB/)
KAO( :, 2, 3,13) = (/&
&3.9470E+00_JPRB,3.4538E+00_JPRB,3.0483E+00_JPRB,2.9667E+00_JPRB,2.7181E+00_JPRB,2.5148E+00_JPRB,&
&2.2501E+00_JPRB,2.5765E+00_JPRB,2.7837E+00_JPRB,2.9313E+00_JPRB/)
KAO( :, 3, 3,13) = (/&
&4.6804E+00_JPRB,4.0955E+00_JPRB,3.6459E+00_JPRB,3.5399E+00_JPRB,3.2163E+00_JPRB,2.9639E+00_JPRB,&
&2.7715E+00_JPRB,3.2088E+00_JPRB,3.4557E+00_JPRB,3.6507E+00_JPRB/)
KAO( :, 4, 3,13) = (/&
&5.4312E+00_JPRB,4.7525E+00_JPRB,4.2675E+00_JPRB,4.1206E+00_JPRB,3.7364E+00_JPRB,3.4562E+00_JPRB,&
&3.3399E+00_JPRB,3.8844E+00_JPRB,4.1920E+00_JPRB,4.4202E+00_JPRB/)
KAO( :, 5, 3,13) = (/&
&6.1796E+00_JPRB,5.4074E+00_JPRB,4.8990E+00_JPRB,4.7013E+00_JPRB,4.2915E+00_JPRB,3.9757E+00_JPRB,&
&3.9407E+00_JPRB,4.5828E+00_JPRB,4.9410E+00_JPRB,5.2123E+00_JPRB/)
KAO( :, 1, 4,13) = (/&
&2.7929E+00_JPRB,2.4439E+00_JPRB,2.1939E+00_JPRB,2.1454E+00_JPRB,2.0515E+00_JPRB,1.8877E+00_JPRB,&
&1.6383E+00_JPRB,1.8045E+00_JPRB,1.9740E+00_JPRB,2.0628E+00_JPRB/)
KAO( :, 2, 4,13) = (/&
&3.4793E+00_JPRB,3.0445E+00_JPRB,2.7598E+00_JPRB,2.6705E+00_JPRB,2.5121E+00_JPRB,2.3266E+00_JPRB,&
&2.0901E+00_JPRB,2.3620E+00_JPRB,2.5689E+00_JPRB,2.6998E+00_JPRB/)
KAO( :, 3, 4,13) = (/&
&4.2010E+00_JPRB,3.6761E+00_JPRB,3.3660E+00_JPRB,3.2278E+00_JPRB,3.0027E+00_JPRB,2.8086E+00_JPRB,&
&2.6028E+00_JPRB,2.9855E+00_JPRB,3.2574E+00_JPRB,3.4124E+00_JPRB/)
KAO( :, 4, 4,13) = (/&
&4.9519E+00_JPRB,4.3331E+00_JPRB,4.0066E+00_JPRB,3.8137E+00_JPRB,3.5269E+00_JPRB,3.3453E+00_JPRB,&
&3.1635E+00_JPRB,3.6670E+00_JPRB,4.0070E+00_JPRB,4.1903E+00_JPRB/)
KAO( :, 5, 4,13) = (/&
&5.7128E+00_JPRB,4.9989E+00_JPRB,4.6672E+00_JPRB,4.4092E+00_JPRB,4.0817E+00_JPRB,3.8791E+00_JPRB,&
&3.7698E+00_JPRB,4.3882E+00_JPRB,4.8065E+00_JPRB,5.0150E+00_JPRB/)
KAO( :, 1, 5,13) = (/&
&2.3832E+00_JPRB,2.0854E+00_JPRB,1.9206E+00_JPRB,1.9102E+00_JPRB,1.8377E+00_JPRB,1.6804E+00_JPRB,&
&1.4581E+00_JPRB,1.5820E+00_JPRB,1.7385E+00_JPRB,1.8104E+00_JPRB/)
KAO( :, 2, 5,13) = (/&
&3.0408E+00_JPRB,2.6608E+00_JPRB,2.4785E+00_JPRB,2.4054E+00_JPRB,2.3025E+00_JPRB,2.1234E+00_JPRB,&
&1.8947E+00_JPRB,2.1142E+00_JPRB,2.3213E+00_JPRB,2.4192E+00_JPRB/)
KAO( :, 3, 5,13) = (/&
&3.7472E+00_JPRB,3.2789E+00_JPRB,3.0888E+00_JPRB,2.9395E+00_JPRB,2.8036E+00_JPRB,2.6282E+00_JPRB,&
&2.3906E+00_JPRB,2.7153E+00_JPRB,2.9926E+00_JPRB,3.1059E+00_JPRB/)
KAO( :, 4, 5,13) = (/&
&4.4915E+00_JPRB,3.9302E+00_JPRB,3.7393E+00_JPRB,3.5090E+00_JPRB,3.3375E+00_JPRB,3.1759E+00_JPRB,&
&2.9354E+00_JPRB,3.3827E+00_JPRB,3.7352E+00_JPRB,3.8690E+00_JPRB/)
KAO( :, 5, 5,13) = (/&
&5.2663E+00_JPRB,4.6081E+00_JPRB,4.4077E+00_JPRB,4.1006E+00_JPRB,3.9180E+00_JPRB,3.7090E+00_JPRB,&
&3.5307E+00_JPRB,4.1076E+00_JPRB,4.5338E+00_JPRB,4.6986E+00_JPRB/)
KAO( :, 1, 6,13) = (/&
&1.9932E+00_JPRB,1.7450E+00_JPRB,1.6663E+00_JPRB,1.6747E+00_JPRB,1.5875E+00_JPRB,1.4577E+00_JPRB,&
&1.2653E+00_JPRB,1.3499E+00_JPRB,1.4817E+00_JPRB,1.5465E+00_JPRB/)
KAO( :, 2, 6,13) = (/&
&2.6126E+00_JPRB,2.2877E+00_JPRB,2.1906E+00_JPRB,2.1465E+00_JPRB,2.0440E+00_JPRB,1.8948E+00_JPRB,&
&1.6751E+00_JPRB,1.8295E+00_JPRB,2.0253E+00_JPRB,2.0939E+00_JPRB/)
KAO( :, 3, 6,13) = (/&
&3.3035E+00_JPRB,2.8922E+00_JPRB,2.7796E+00_JPRB,2.6671E+00_JPRB,2.5564E+00_JPRB,2.3982E+00_JPRB,&
&2.1433E+00_JPRB,2.3876E+00_JPRB,2.6563E+00_JPRB,2.7311E+00_JPRB/)
KAO( :, 4, 6,13) = (/&
&4.0480E+00_JPRB,3.5441E+00_JPRB,3.4094E+00_JPRB,3.2253E+00_JPRB,3.1196E+00_JPRB,2.9346E+00_JPRB,&
&2.6536E+00_JPRB,3.0266E+00_JPRB,3.3710E+00_JPRB,3.4616E+00_JPRB/)
KAO( :, 5, 6,13) = (/&
&4.8342E+00_JPRB,4.2338E+00_JPRB,4.0696E+00_JPRB,3.8230E+00_JPRB,3.7396E+00_JPRB,3.4594E+00_JPRB,&
&3.2309E+00_JPRB,3.7339E+00_JPRB,4.1600E+00_JPRB,4.2696E+00_JPRB/)
KAO( :, 1, 7,13) = (/&
&1.6468E+00_JPRB,1.4469E+00_JPRB,1.4375E+00_JPRB,1.4321E+00_JPRB,1.3474E+00_JPRB,1.2424E+00_JPRB,&
&1.0892E+00_JPRB,1.1510E+00_JPRB,1.2626E+00_JPRB,1.3183E+00_JPRB/)
KAO( :, 2, 7,13) = (/&
&2.2291E+00_JPRB,1.9582E+00_JPRB,1.9270E+00_JPRB,1.8946E+00_JPRB,1.7899E+00_JPRB,1.6613E+00_JPRB,&
&1.4638E+00_JPRB,1.5844E+00_JPRB,1.7486E+00_JPRB,1.8143E+00_JPRB/)
KAO( :, 3, 7,13) = (/&
&2.8937E+00_JPRB,2.5452E+00_JPRB,2.4760E+00_JPRB,2.4095E+00_JPRB,2.2977E+00_JPRB,2.1475E+00_JPRB,&
&1.8921E+00_JPRB,2.0920E+00_JPRB,2.3240E+00_JPRB,2.3941E+00_JPRB/)
KAO( :, 4, 7,13) = (/&
&3.6319E+00_JPRB,3.2018E+00_JPRB,3.0807E+00_JPRB,2.9736E+00_JPRB,2.8721E+00_JPRB,2.6699E+00_JPRB,&
&2.3689E+00_JPRB,2.6767E+00_JPRB,2.9818E+00_JPRB,3.0621E+00_JPRB/)
KAO( :, 5, 7,13) = (/&
&4.4294E+00_JPRB,3.9124E+00_JPRB,3.7363E+00_JPRB,3.5826E+00_JPRB,3.5031E+00_JPRB,3.1936E+00_JPRB,&
&2.9162E+00_JPRB,3.3346E+00_JPRB,3.7295E+00_JPRB,3.8139E+00_JPRB/)
KAO( :, 1, 8,13) = (/&
&1.3645E+00_JPRB,1.2030E+00_JPRB,1.2251E+00_JPRB,1.1980E+00_JPRB,1.1267E+00_JPRB,1.0496E+00_JPRB,&
&9.4007E-01_JPRB,9.8738E-01_JPRB,1.0795E+00_JPRB,1.1321E+00_JPRB/)
KAO( :, 2, 8,13) = (/&
&1.8875E+00_JPRB,1.6716E+00_JPRB,1.6787E+00_JPRB,1.6357E+00_JPRB,1.5491E+00_JPRB,1.4420E+00_JPRB,&
&1.2844E+00_JPRB,1.3709E+00_JPRB,1.5112E+00_JPRB,1.5708E+00_JPRB/)
KAO( :, 3, 8,13) = (/&
&2.5235E+00_JPRB,2.2405E+00_JPRB,2.2018E+00_JPRB,2.1383E+00_JPRB,2.0418E+00_JPRB,1.9034E+00_JPRB,&
&1.6797E+00_JPRB,1.8309E+00_JPRB,2.0369E+00_JPRB,2.0956E+00_JPRB/)
KAO( :, 4, 8,13) = (/&
&3.2460E+00_JPRB,2.8890E+00_JPRB,2.7989E+00_JPRB,2.7089E+00_JPRB,2.6113E+00_JPRB,2.4070E+00_JPRB,&
&2.1243E+00_JPRB,2.3727E+00_JPRB,2.6443E+00_JPRB,2.7141E+00_JPRB/)
KAO( :, 5, 8,13) = (/&
&4.0415E+00_JPRB,3.6015E+00_JPRB,3.4549E+00_JPRB,3.3427E+00_JPRB,3.2300E+00_JPRB,2.9321E+00_JPRB,&
&2.6354E+00_JPRB,2.9888E+00_JPRB,3.3390E+00_JPRB,3.4186E+00_JPRB/)
KAO( :, 1, 9,13) = (/&
&1.1543E+00_JPRB,1.0251E+00_JPRB,1.0349E+00_JPRB,9.8794E-01_JPRB,9.3205E-01_JPRB,8.8440E-01_JPRB,&
&8.0320E-01_JPRB,8.4519E-01_JPRB,9.2711E-01_JPRB,1.0206E+00_JPRB/)
KAO( :, 2, 9,13) = (/&
&1.6108E+00_JPRB,1.4310E+00_JPRB,1.4476E+00_JPRB,1.3885E+00_JPRB,1.3235E+00_JPRB,1.2492E+00_JPRB,&
&1.1169E+00_JPRB,1.1958E+00_JPRB,1.3141E+00_JPRB,1.3705E+00_JPRB/)
KAO( :, 3, 9,13) = (/&
&2.1885E+00_JPRB,1.9532E+00_JPRB,1.9550E+00_JPRB,1.8741E+00_JPRB,1.7932E+00_JPRB,1.6819E+00_JPRB,&
&1.4843E+00_JPRB,1.6106E+00_JPRB,1.7801E+00_JPRB,1.8447E+00_JPRB/)
KAO( :, 4, 9,13) = (/&
&2.8811E+00_JPRB,2.5830E+00_JPRB,2.5357E+00_JPRB,2.4436E+00_JPRB,2.3447E+00_JPRB,2.1613E+00_JPRB,&
&1.9043E+00_JPRB,2.1005E+00_JPRB,2.3339E+00_JPRB,2.4057E+00_JPRB/)
KAO( :, 5, 9,13) = (/&
&3.6764E+00_JPRB,3.3079E+00_JPRB,3.1796E+00_JPRB,3.0911E+00_JPRB,2.9539E+00_JPRB,2.6757E+00_JPRB,&
&2.3874E+00_JPRB,2.6741E+00_JPRB,2.9820E+00_JPRB,3.0611E+00_JPRB/)
KAO( :, 1,10,13) = (/&
&1.0302E+00_JPRB,9.2176E-01_JPRB,9.0574E-01_JPRB,8.4615E-01_JPRB,7.9970E-01_JPRB,7.6976E-01_JPRB,&
&7.0274E-01_JPRB,7.4283E-01_JPRB,8.1565E-01_JPRB,2.7017E+00_JPRB/)
KAO( :, 2,10,13) = (/&
&1.4458E+00_JPRB,1.2918E+00_JPRB,1.2726E+00_JPRB,1.2041E+00_JPRB,1.1546E+00_JPRB,1.1052E+00_JPRB,&
&9.9535E-01_JPRB,1.0584E+00_JPRB,1.1691E+00_JPRB,2.9336E+00_JPRB/)
KAO( :, 3,10,13) = (/&
&1.9856E+00_JPRB,1.7787E+00_JPRB,1.7427E+00_JPRB,1.6691E+00_JPRB,1.6016E+00_JPRB,1.5137E+00_JPRB,&
&1.3407E+00_JPRB,1.4471E+00_JPRB,1.6060E+00_JPRB,3.2154E+00_JPRB/)
KAO( :, 4,10,13) = (/&
&2.6493E+00_JPRB,2.3820E+00_JPRB,2.3103E+00_JPRB,2.2284E+00_JPRB,2.1316E+00_JPRB,1.9769E+00_JPRB,&
&1.7435E+00_JPRB,1.9143E+00_JPRB,2.1248E+00_JPRB,3.4633E+00_JPRB/)
KAO( :, 5,10,13) = (/&
&3.4281E+00_JPRB,3.0946E+00_JPRB,2.9645E+00_JPRB,2.8748E+00_JPRB,2.7245E+00_JPRB,2.4879E+00_JPRB,&
&2.2103E+00_JPRB,2.4551E+00_JPRB,2.7307E+00_JPRB,3.6000E+00_JPRB/)
KAO( :, 1,11,13) = (/&
&1.0987E+00_JPRB,9.8883E-01_JPRB,9.4457E-01_JPRB,8.7599E-01_JPRB,8.3570E-01_JPRB,8.0174E-01_JPRB,&
&7.2908E-01_JPRB,7.6400E-01_JPRB,8.5040E-01_JPRB,4.1644E+00_JPRB/)
KAO( :, 2,11,13) = (/&
&1.5519E+00_JPRB,1.3960E+00_JPRB,1.3272E+00_JPRB,1.2419E+00_JPRB,1.1936E+00_JPRB,1.1475E+00_JPRB,&
&1.0323E+00_JPRB,1.0904E+00_JPRB,1.2118E+00_JPRB,4.4377E+00_JPRB/)
KAO( :, 3,11,13) = (/&
&2.1168E+00_JPRB,1.9062E+00_JPRB,1.8156E+00_JPRB,1.7151E+00_JPRB,1.6554E+00_JPRB,1.5612E+00_JPRB,&
&1.3900E+00_JPRB,1.4823E+00_JPRB,1.6504E+00_JPRB,4.7648E+00_JPRB/)
KAO( :, 4,11,13) = (/&
&2.8109E+00_JPRB,2.5372E+00_JPRB,2.4065E+00_JPRB,2.2977E+00_JPRB,2.1984E+00_JPRB,2.0338E+00_JPRB,&
&1.8057E+00_JPRB,1.9491E+00_JPRB,2.1792E+00_JPRB,5.1367E+00_JPRB/)
KAO( :, 5,11,13) = (/&
&3.6200E+00_JPRB,3.2757E+00_JPRB,3.0973E+00_JPRB,2.9725E+00_JPRB,2.8049E+00_JPRB,2.5726E+00_JPRB,&
&2.2731E+00_JPRB,2.4759E+00_JPRB,2.7857E+00_JPRB,5.3931E+00_JPRB/)
KAO( :, 1,12,13) = (/&
&1.1834E+00_JPRB,1.0718E+00_JPRB,9.9832E-01_JPRB,9.1951E-01_JPRB,8.8066E-01_JPRB,8.3984E-01_JPRB,&
&7.5516E-01_JPRB,7.7629E-01_JPRB,8.6924E-01_JPRB,5.0196E+00_JPRB/)
KAO( :, 2,12,13) = (/&
&1.6817E+00_JPRB,1.5210E+00_JPRB,1.4125E+00_JPRB,1.3041E+00_JPRB,1.2468E+00_JPRB,1.1910E+00_JPRB,&
&1.0644E+00_JPRB,1.0991E+00_JPRB,1.2384E+00_JPRB,5.3253E+00_JPRB/)
KAO( :, 3,12,13) = (/&
&2.2884E+00_JPRB,2.0697E+00_JPRB,1.9237E+00_JPRB,1.7926E+00_JPRB,1.7105E+00_JPRB,1.6141E+00_JPRB,&
&1.4356E+00_JPRB,1.4903E+00_JPRB,1.6827E+00_JPRB,5.6934E+00_JPRB/)
KAO( :, 4,12,13) = (/&
&3.0153E+00_JPRB,2.7275E+00_JPRB,2.5449E+00_JPRB,2.3911E+00_JPRB,2.2578E+00_JPRB,2.1058E+00_JPRB,&
&1.8686E+00_JPRB,1.9453E+00_JPRB,2.2026E+00_JPRB,6.1123E+00_JPRB/)
KAO( :, 5,12,13) = (/&
&3.8521E+00_JPRB,3.4852E+00_JPRB,3.2646E+00_JPRB,3.0814E+00_JPRB,2.8800E+00_JPRB,2.6613E+00_JPRB,&
&2.3377E+00_JPRB,2.4576E+00_JPRB,2.7866E+00_JPRB,6.4282E+00_JPRB/)
KAO( :, 1,13,13) = (/&
&1.2852E+00_JPRB,1.1646E+00_JPRB,1.0642E+00_JPRB,9.7556E-01_JPRB,9.2420E-01_JPRB,8.7620E-01_JPRB,&
&7.7196E-01_JPRB,7.7146E-01_JPRB,8.7630E-01_JPRB,4.8556E+00_JPRB/)
KAO( :, 2,13,13) = (/&
&1.8301E+00_JPRB,1.6589E+00_JPRB,1.5152E+00_JPRB,1.3893E+00_JPRB,1.3055E+00_JPRB,1.2323E+00_JPRB,&
&1.0895E+00_JPRB,1.0875E+00_JPRB,1.2372E+00_JPRB,5.1762E+00_JPRB/)
KAO( :, 3,13,13) = (/&
&2.4889E+00_JPRB,2.2558E+00_JPRB,2.0613E+00_JPRB,1.9034E+00_JPRB,1.7774E+00_JPRB,1.6692E+00_JPRB,&
&1.4717E+00_JPRB,1.4657E+00_JPRB,1.6743E+00_JPRB,5.5984E+00_JPRB/)
KAO( :, 4,13,13) = (/&
&3.2570E+00_JPRB,2.9493E+00_JPRB,2.7127E+00_JPRB,2.5175E+00_JPRB,2.3371E+00_JPRB,2.1800E+00_JPRB,&
&1.9099E+00_JPRB,1.9041E+00_JPRB,2.1795E+00_JPRB,5.9989E+00_JPRB/)
KAO( :, 5,13,13) = (/&
&4.1326E+00_JPRB,3.7382E+00_JPRB,3.4726E+00_JPRB,3.2172E+00_JPRB,2.9811E+00_JPRB,2.7433E+00_JPRB,&
&2.3977E+00_JPRB,2.4060E+00_JPRB,2.7519E+00_JPRB,6.3218E+00_JPRB/)
KAO( :, 1, 1,14) = (/&
&6.3467E+00_JPRB,5.5536E+00_JPRB,4.7605E+00_JPRB,3.9673E+00_JPRB,3.4386E+00_JPRB,3.0089E+00_JPRB,&
&3.2295E+00_JPRB,3.7567E+00_JPRB,4.0531E+00_JPRB,4.1923E+00_JPRB/)
KAO( :, 2, 1,14) = (/&
&7.3964E+00_JPRB,6.4721E+00_JPRB,5.5478E+00_JPRB,4.6234E+00_JPRB,4.0808E+00_JPRB,3.6137E+00_JPRB,&
&3.9782E+00_JPRB,4.6298E+00_JPRB,5.0268E+00_JPRB,5.1845E+00_JPRB/)
KAO( :, 3, 1,14) = (/&
&8.4250E+00_JPRB,7.3721E+00_JPRB,6.3192E+00_JPRB,5.2663E+00_JPRB,4.6836E+00_JPRB,4.2376E+00_JPRB,&
&4.8035E+00_JPRB,5.5919E+00_JPRB,6.0740E+00_JPRB,6.2648E+00_JPRB/)
KAO( :, 4, 1,14) = (/&
&9.4499E+00_JPRB,8.2689E+00_JPRB,7.0879E+00_JPRB,5.9239E+00_JPRB,5.2786E+00_JPRB,4.8999E+00_JPRB,&
&5.6760E+00_JPRB,6.6052E+00_JPRB,7.1802E+00_JPRB,7.4022E+00_JPRB/)
KAO( :, 5, 1,14) = (/&
&1.0423E+01_JPRB,9.1200E+00_JPRB,7.8174E+00_JPRB,6.5882E+00_JPRB,5.8558E+00_JPRB,5.6014E+00_JPRB,&
&6.5884E+00_JPRB,7.6675E+00_JPRB,8.3255E+00_JPRB,8.5803E+00_JPRB/)
KAO( :, 1, 2,14) = (/&
&6.0960E+00_JPRB,5.3341E+00_JPRB,4.5723E+00_JPRB,3.8126E+00_JPRB,3.4069E+00_JPRB,2.9396E+00_JPRB,&
&3.2197E+00_JPRB,3.7455E+00_JPRB,4.0286E+00_JPRB,4.2155E+00_JPRB/)
KAO( :, 2, 2,14) = (/&
&7.1676E+00_JPRB,6.2719E+00_JPRB,5.3761E+00_JPRB,4.4966E+00_JPRB,4.0412E+00_JPRB,3.5493E+00_JPRB,&
&3.9472E+00_JPRB,4.5920E+00_JPRB,4.9699E+00_JPRB,5.1775E+00_JPRB/)
KAO( :, 3, 2,14) = (/&
&8.2275E+00_JPRB,7.1993E+00_JPRB,6.1710E+00_JPRB,5.2089E+00_JPRB,4.6568E+00_JPRB,4.1985E+00_JPRB,&
&4.7440E+00_JPRB,5.5211E+00_JPRB,6.0149E+00_JPRB,6.2370E+00_JPRB/)
KAO( :, 4, 2,14) = (/&
&9.2799E+00_JPRB,8.1202E+00_JPRB,6.9604E+00_JPRB,5.9586E+00_JPRB,5.2716E+00_JPRB,4.8960E+00_JPRB,&
&5.6599E+00_JPRB,6.5872E+00_JPRB,7.1735E+00_JPRB,7.4414E+00_JPRB/)
KAO( :, 5, 2,14) = (/&
&1.0290E+01_JPRB,9.0044E+00_JPRB,7.7181E+00_JPRB,6.7211E+00_JPRB,5.8757E+00_JPRB,5.6245E+00_JPRB,&
&6.6558E+00_JPRB,7.7452E+00_JPRB,8.4069E+00_JPRB,8.7373E+00_JPRB/)
KAO( :, 1, 3,14) = (/&
&5.6039E+00_JPRB,4.9036E+00_JPRB,4.2032E+00_JPRB,3.5445E+00_JPRB,3.1902E+00_JPRB,2.7537E+00_JPRB,&
&3.0813E+00_JPRB,3.5840E+00_JPRB,3.8576E+00_JPRB,4.0764E+00_JPRB/)
KAO( :, 2, 3,14) = (/&
&6.6863E+00_JPRB,5.8506E+00_JPRB,5.0150E+00_JPRB,4.2815E+00_JPRB,3.8270E+00_JPRB,3.3352E+00_JPRB,&
&3.7857E+00_JPRB,4.4048E+00_JPRB,4.7637E+00_JPRB,5.0131E+00_JPRB/)
KAO( :, 3, 3,14) = (/&
&7.7737E+00_JPRB,6.8021E+00_JPRB,5.8305E+00_JPRB,5.0665E+00_JPRB,4.4594E+00_JPRB,3.9827E+00_JPRB,&
&4.5659E+00_JPRB,5.3124E+00_JPRB,5.7659E+00_JPRB,6.0477E+00_JPRB/)
KAO( :, 4, 3,14) = (/&
&8.8508E+00_JPRB,7.7446E+00_JPRB,6.6384E+00_JPRB,5.8813E+00_JPRB,5.0859E+00_JPRB,4.6840E+00_JPRB,&
&5.4591E+00_JPRB,6.3527E+00_JPRB,6.8914E+00_JPRB,7.2291E+00_JPRB/)
KAO( :, 5, 3,14) = (/&
&9.9079E+00_JPRB,8.6696E+00_JPRB,7.4314E+00_JPRB,6.6539E+00_JPRB,5.7107E+00_JPRB,5.4618E+00_JPRB,&
&6.4933E+00_JPRB,7.5556E+00_JPRB,8.1916E+00_JPRB,8.5967E+00_JPRB/)
KAO( :, 1, 4,14) = (/&
&5.0429E+00_JPRB,4.4127E+00_JPRB,3.7824E+00_JPRB,3.2565E+00_JPRB,2.9117E+00_JPRB,2.5898E+00_JPRB,&
&2.8958E+00_JPRB,3.3702E+00_JPRB,3.6408E+00_JPRB,3.8526E+00_JPRB/)
KAO( :, 2, 4,14) = (/&
&6.1165E+00_JPRB,5.3520E+00_JPRB,4.5876E+00_JPRB,4.0300E+00_JPRB,3.5416E+00_JPRB,3.1532E+00_JPRB,&
&3.5780E+00_JPRB,4.1633E+00_JPRB,4.5155E+00_JPRB,4.7595E+00_JPRB/)
KAO( :, 3, 4,14) = (/&
&7.2202E+00_JPRB,6.3178E+00_JPRB,5.4153E+00_JPRB,4.8492E+00_JPRB,4.1829E+00_JPRB,3.7790E+00_JPRB,&
&4.3631E+00_JPRB,5.0766E+00_JPRB,5.4928E+00_JPRB,5.8029E+00_JPRB/)
KAO( :, 4, 4,14) = (/&
&8.3276E+00_JPRB,7.2868E+00_JPRB,6.2460E+00_JPRB,5.6534E+00_JPRB,4.8225E+00_JPRB,4.4640E+00_JPRB,&
&5.2625E+00_JPRB,6.1221E+00_JPRB,6.6156E+00_JPRB,6.9984E+00_JPRB/)
KAO( :, 5, 4,14) = (/&
&9.4148E+00_JPRB,8.2381E+00_JPRB,7.0618E+00_JPRB,6.4221E+00_JPRB,5.4760E+00_JPRB,5.2668E+00_JPRB,&
&6.3012E+00_JPRB,7.3279E+00_JPRB,7.8962E+00_JPRB,8.3774E+00_JPRB/)
KAO( :, 1, 5,14) = (/&
&4.4802E+00_JPRB,3.9202E+00_JPRB,3.3603E+00_JPRB,2.9662E+00_JPRB,2.6611E+00_JPRB,2.4288E+00_JPRB,&
&2.7026E+00_JPRB,3.1455E+00_JPRB,3.4114E+00_JPRB,3.6024E+00_JPRB/)
KAO( :, 2, 5,14) = (/&
&5.5401E+00_JPRB,4.8477E+00_JPRB,4.1552E+00_JPRB,3.7384E+00_JPRB,3.2633E+00_JPRB,2.9928E+00_JPRB,&
&3.3900E+00_JPRB,3.9443E+00_JPRB,4.2636E+00_JPRB,4.5188E+00_JPRB/)
KAO( :, 3, 5,14) = (/&
&6.6438E+00_JPRB,5.8134E+00_JPRB,4.9831E+00_JPRB,4.5446E+00_JPRB,3.8884E+00_JPRB,3.6053E+00_JPRB,&
&4.1835E+00_JPRB,4.8658E+00_JPRB,5.2435E+00_JPRB,5.5754E+00_JPRB/)
KAO( :, 4, 5,14) = (/&
&7.7709E+00_JPRB,6.7996E+00_JPRB,5.8338E+00_JPRB,5.3460E+00_JPRB,4.5461E+00_JPRB,4.3055E+00_JPRB,&
&5.1051E+00_JPRB,5.9359E+00_JPRB,6.3763E+00_JPRB,6.8031E+00_JPRB/)
KAO( :, 5, 5,14) = (/&
&8.8898E+00_JPRB,7.7787E+00_JPRB,6.6983E+00_JPRB,6.1260E+00_JPRB,5.2267E+00_JPRB,5.1517E+00_JPRB,&
&6.1712E+00_JPRB,7.1748E+00_JPRB,7.6888E+00_JPRB,8.2242E+00_JPRB/)
KAO( :, 1, 6,14) = (/&
&3.8956E+00_JPRB,3.4087E+00_JPRB,2.9221E+00_JPRB,2.6281E+00_JPRB,2.4050E+00_JPRB,2.1916E+00_JPRB,&
&2.4174E+00_JPRB,2.8161E+00_JPRB,3.0927E+00_JPRB,3.2244E+00_JPRB/)
KAO( :, 2, 6,14) = (/&
&4.9303E+00_JPRB,4.3141E+00_JPRB,3.7046E+00_JPRB,3.3844E+00_JPRB,3.0105E+00_JPRB,2.7770E+00_JPRB,&
&3.1412E+00_JPRB,3.6575E+00_JPRB,3.9814E+00_JPRB,4.1910E+00_JPRB/)
KAO( :, 3, 6,14) = (/&
&6.0218E+00_JPRB,5.2691E+00_JPRB,4.5387E+00_JPRB,4.1657E+00_JPRB,3.6350E+00_JPRB,3.4172E+00_JPRB,&
&3.9726E+00_JPRB,4.6214E+00_JPRB,4.9897E+00_JPRB,5.2991E+00_JPRB/)
KAO( :, 4, 6,14) = (/&
&7.1568E+00_JPRB,6.2623E+00_JPRB,5.4345E+00_JPRB,4.9658E+00_JPRB,4.2966E+00_JPRB,4.1563E+00_JPRB,&
&4.9351E+00_JPRB,5.7383E+00_JPRB,6.1434E+00_JPRB,6.5857E+00_JPRB/)
KAO( :, 5, 6,14) = (/&
&8.3003E+00_JPRB,7.2628E+00_JPRB,6.3671E+00_JPRB,5.7590E+00_JPRB,4.9644E+00_JPRB,5.0298E+00_JPRB,&
&6.0229E+00_JPRB,7.0046E+00_JPRB,7.4957E+00_JPRB,8.0375E+00_JPRB/)
KAO( :, 1, 7,14) = (/&
&3.3388E+00_JPRB,2.9215E+00_JPRB,2.5187E+00_JPRB,2.3253E+00_JPRB,2.1119E+00_JPRB,1.9164E+00_JPRB,&
&2.0859E+00_JPRB,2.4315E+00_JPRB,2.6982E+00_JPRB,2.7836E+00_JPRB/)
KAO( :, 2, 7,14) = (/&
&4.3359E+00_JPRB,3.7940E+00_JPRB,3.2869E+00_JPRB,3.0293E+00_JPRB,2.7102E+00_JPRB,2.5026E+00_JPRB,&
&2.8032E+00_JPRB,3.2661E+00_JPRB,3.5953E+00_JPRB,3.7400E+00_JPRB/)
KAO( :, 3, 7,14) = (/&
&5.4120E+00_JPRB,4.7356E+00_JPRB,4.1395E+00_JPRB,3.7778E+00_JPRB,3.3513E+00_JPRB,3.1688E+00_JPRB,&
&3.6572E+00_JPRB,4.2574E+00_JPRB,4.6459E+00_JPRB,4.8805E+00_JPRB/)
KAO( :, 4, 7,14) = (/&
&6.5428E+00_JPRB,5.7250E+00_JPRB,5.0639E+00_JPRB,4.5620E+00_JPRB,4.0362E+00_JPRB,3.9521E+00_JPRB,&
&4.6701E+00_JPRB,5.4350E+00_JPRB,5.8814E+00_JPRB,6.2344E+00_JPRB/)
KAO( :, 5, 7,14) = (/&
&7.7011E+00_JPRB,6.7385E+00_JPRB,6.0359E+00_JPRB,5.3689E+00_JPRB,4.7398E+00_JPRB,4.8671E+00_JPRB,&
&5.8104E+00_JPRB,6.7609E+00_JPRB,7.2855E+00_JPRB,7.7564E+00_JPRB/)
KAO( :, 1, 8,14) = (/&
&2.8332E+00_JPRB,2.4790E+00_JPRB,2.1588E+00_JPRB,2.0517E+00_JPRB,1.8212E+00_JPRB,1.6427E+00_JPRB,&
&1.7555E+00_JPRB,2.0463E+00_JPRB,2.2808E+00_JPRB,2.3417E+00_JPRB/)
KAO( :, 2, 8,14) = (/&
&3.7845E+00_JPRB,3.3115E+00_JPRB,2.9062E+00_JPRB,2.7307E+00_JPRB,2.4002E+00_JPRB,2.2076E+00_JPRB,&
&2.4394E+00_JPRB,2.8424E+00_JPRB,3.1489E+00_JPRB,3.2550E+00_JPRB/)
KAO( :, 3, 8,14) = (/&
&4.8341E+00_JPRB,4.2299E+00_JPRB,3.7584E+00_JPRB,3.4582E+00_JPRB,3.0437E+00_JPRB,2.8748E+00_JPRB,&
&3.2834E+00_JPRB,3.8242E+00_JPRB,4.1983E+00_JPRB,4.3823E+00_JPRB/)
KAO( :, 4, 8,14) = (/&
&5.9611E+00_JPRB,5.2160E+00_JPRB,4.6841E+00_JPRB,4.2257E+00_JPRB,3.7381E+00_JPRB,3.6695E+00_JPRB,&
&4.3008E+00_JPRB,5.0080E+00_JPRB,5.4653E+00_JPRB,5.7413E+00_JPRB/)
KAO( :, 5, 8,14) = (/&
&7.1388E+00_JPRB,6.2465E+00_JPRB,5.6516E+00_JPRB,5.0317E+00_JPRB,4.4851E+00_JPRB,4.5966E+00_JPRB,&
&5.4606E+00_JPRB,6.3571E+00_JPRB,6.9303E+00_JPRB,7.2901E+00_JPRB/)
KAO( :, 1, 9,14) = (/&
&2.3712E+00_JPRB,2.0748E+00_JPRB,1.8514E+00_JPRB,1.7610E+00_JPRB,1.5410E+00_JPRB,1.3776E+00_JPRB,&
&1.4602E+00_JPRB,1.7019E+00_JPRB,1.8917E+00_JPRB,1.9491E+00_JPRB/)
KAO( :, 2, 9,14) = (/&
&3.2706E+00_JPRB,2.8618E+00_JPRB,2.5535E+00_JPRB,2.4121E+00_JPRB,2.0953E+00_JPRB,1.9091E+00_JPRB,&
&2.0867E+00_JPRB,2.4315E+00_JPRB,2.6961E+00_JPRB,2.7855E+00_JPRB/)
KAO( :, 3, 9,14) = (/&
&4.2928E+00_JPRB,3.7562E+00_JPRB,3.3707E+00_JPRB,3.1325E+00_JPRB,2.7323E+00_JPRB,2.5568E+00_JPRB,&
&2.8897E+00_JPRB,3.3658E+00_JPRB,3.7112E+00_JPRB,3.8566E+00_JPRB/)
KAO( :, 4, 9,14) = (/&
&5.4084E+00_JPRB,4.7324E+00_JPRB,4.2872E+00_JPRB,3.9074E+00_JPRB,3.4333E+00_JPRB,3.3403E+00_JPRB,&
&3.8759E+00_JPRB,4.5148E+00_JPRB,4.9657E+00_JPRB,5.1730E+00_JPRB/)
KAO( :, 5, 9,14) = (/&
&6.5945E+00_JPRB,5.7702E+00_JPRB,5.2612E+00_JPRB,4.7341E+00_JPRB,4.2027E+00_JPRB,4.2619E+00_JPRB,&
&5.0203E+00_JPRB,5.8475E+00_JPRB,6.4247E+00_JPRB,6.7007E+00_JPRB/)
KAO( :, 1,10,14) = (/&
&2.0238E+00_JPRB,1.7709E+00_JPRB,1.6271E+00_JPRB,1.5213E+00_JPRB,1.3211E+00_JPRB,1.1708E+00_JPRB,&
&1.2470E+00_JPRB,1.4529E+00_JPRB,1.6100E+00_JPRB,4.3675E+00_JPRB/)
KAO( :, 2,10,14) = (/&
&2.8739E+00_JPRB,2.5147E+00_JPRB,2.3020E+00_JPRB,2.1393E+00_JPRB,1.8575E+00_JPRB,1.6735E+00_JPRB,&
&1.8305E+00_JPRB,2.1324E+00_JPRB,2.3565E+00_JPRB,4.3227E+00_JPRB/)
KAO( :, 3,10,14) = (/&
&3.8650E+00_JPRB,3.3819E+00_JPRB,3.1009E+00_JPRB,2.8438E+00_JPRB,2.4832E+00_JPRB,2.3021E+00_JPRB,&
&2.5924E+00_JPRB,3.0194E+00_JPRB,3.3202E+00_JPRB,4.3938E+00_JPRB/)
KAO( :, 4,10,14) = (/&
&4.9777E+00_JPRB,4.3555E+00_JPRB,3.9964E+00_JPRB,3.6309E+00_JPRB,3.1871E+00_JPRB,3.0700E+00_JPRB,&
&3.5258E+00_JPRB,4.1073E+00_JPRB,4.5249E+00_JPRB,4.9612E+00_JPRB/)
KAO( :, 5,10,14) = (/&
&6.1825E+00_JPRB,5.4114E+00_JPRB,4.9528E+00_JPRB,4.4825E+00_JPRB,3.9869E+00_JPRB,3.9806E+00_JPRB,&
&4.6382E+00_JPRB,5.4027E+00_JPRB,5.9521E+00_JPRB,6.1940E+00_JPRB/)
KAO( :, 1,11,14) = (/&
&2.0804E+00_JPRB,1.8204E+00_JPRB,1.7005E+00_JPRB,1.5536E+00_JPRB,1.3500E+00_JPRB,1.2044E+00_JPRB,&
&1.3053E+00_JPRB,1.5201E+00_JPRB,1.6683E+00_JPRB,7.0995E+00_JPRB/)
KAO( :, 2,11,14) = (/&
&2.9372E+00_JPRB,2.5710E+00_JPRB,2.4123E+00_JPRB,2.1876E+00_JPRB,1.9103E+00_JPRB,1.7356E+00_JPRB,&
&1.9131E+00_JPRB,2.2284E+00_JPRB,2.4493E+00_JPRB,7.0950E+00_JPRB/)
KAO( :, 3,11,14) = (/&
&3.9628E+00_JPRB,3.4731E+00_JPRB,3.2411E+00_JPRB,2.9265E+00_JPRB,2.5614E+00_JPRB,2.3947E+00_JPRB,&
&2.6976E+00_JPRB,3.1434E+00_JPRB,3.4700E+00_JPRB,6.9637E+00_JPRB/)
KAO( :, 4,11,14) = (/&
&5.1248E+00_JPRB,4.4937E+00_JPRB,4.1603E+00_JPRB,3.7597E+00_JPRB,3.3177E+00_JPRB,3.2015E+00_JPRB,&
&3.6687E+00_JPRB,4.2746E+00_JPRB,4.7220E+00_JPRB,6.9069E+00_JPRB/)
KAO( :, 5,11,14) = (/&
&6.4048E+00_JPRB,5.6238E+00_JPRB,5.1596E+00_JPRB,4.6653E+00_JPRB,4.1869E+00_JPRB,4.1503E+00_JPRB,&
&4.8291E+00_JPRB,5.6278E+00_JPRB,6.2131E+00_JPRB,7.3735E+00_JPRB/)
KAO( :, 1,12,14) = (/&
&2.1606E+00_JPRB,1.8919E+00_JPRB,1.7776E+00_JPRB,1.5988E+00_JPRB,1.3931E+00_JPRB,1.2607E+00_JPRB,&
&1.3765E+00_JPRB,1.6030E+00_JPRB,1.7584E+00_JPRB,8.8539E+00_JPRB/)
KAO( :, 2,12,14) = (/&
&3.0241E+00_JPRB,2.6538E+00_JPRB,2.5108E+00_JPRB,2.2558E+00_JPRB,1.9760E+00_JPRB,1.8135E+00_JPRB,&
&2.0048E+00_JPRB,2.3354E+00_JPRB,2.5682E+00_JPRB,8.8299E+00_JPRB/)
KAO( :, 3,12,14) = (/&
&4.0854E+00_JPRB,3.5917E+00_JPRB,3.3758E+00_JPRB,3.0347E+00_JPRB,2.6732E+00_JPRB,2.5117E+00_JPRB,&
&2.8106E+00_JPRB,3.2743E+00_JPRB,3.6095E+00_JPRB,8.6670E+00_JPRB/)
KAO( :, 4,12,14) = (/&
&5.3044E+00_JPRB,4.6786E+00_JPRB,4.3443E+00_JPRB,3.9213E+00_JPRB,3.4969E+00_JPRB,3.3585E+00_JPRB,&
&3.8040E+00_JPRB,4.4330E+00_JPRB,4.9075E+00_JPRB,8.5700E+00_JPRB/)
KAO( :, 5,12,14) = (/&
&6.6440E+00_JPRB,5.8812E+00_JPRB,5.4120E+00_JPRB,4.9125E+00_JPRB,4.4282E+00_JPRB,4.3429E+00_JPRB,&
&4.9855E+00_JPRB,5.8102E+00_JPRB,6.4492E+00_JPRB,8.6830E+00_JPRB/)
KAO( :, 1,13,14) = (/&
&2.2525E+00_JPRB,1.9864E+00_JPRB,1.8643E+00_JPRB,1.6602E+00_JPRB,1.4614E+00_JPRB,1.3350E+00_JPRB,&
&1.4569E+00_JPRB,1.6960E+00_JPRB,1.8539E+00_JPRB,8.7601E+00_JPRB/)
KAO( :, 2,13,14) = (/&
&3.1332E+00_JPRB,2.7632E+00_JPRB,2.6018E+00_JPRB,2.3367E+00_JPRB,2.0765E+00_JPRB,1.9171E+00_JPRB,&
&2.1105E+00_JPRB,2.4578E+00_JPRB,2.6945E+00_JPRB,8.6837E+00_JPRB/)
KAO( :, 3,13,14) = (/&
&4.2146E+00_JPRB,3.7269E+00_JPRB,3.4963E+00_JPRB,3.1609E+00_JPRB,2.8326E+00_JPRB,2.6522E+00_JPRB,&
&2.9390E+00_JPRB,3.4234E+00_JPRB,3.7715E+00_JPRB,8.5952E+00_JPRB/)
KAO( :, 4,13,14) = (/&
&5.4718E+00_JPRB,4.8645E+00_JPRB,4.5313E+00_JPRB,4.1221E+00_JPRB,3.7163E+00_JPRB,3.5387E+00_JPRB,&
&3.9442E+00_JPRB,4.5945E+00_JPRB,5.0796E+00_JPRB,8.5494E+00_JPRB/)
KAO( :, 5,13,14) = (/&
&6.8761E+00_JPRB,6.1372E+00_JPRB,5.6718E+00_JPRB,5.2229E+00_JPRB,4.7155E+00_JPRB,4.5637E+00_JPRB,&
&5.1163E+00_JPRB,5.9645E+00_JPRB,6.6388E+00_JPRB,8.7275E+00_JPRB/)
KAO( :, 1, 1,15) = (/&
&7.4038E+00_JPRB,6.4785E+00_JPRB,5.5532E+00_JPRB,4.6280E+00_JPRB,3.7389E+00_JPRB,4.3853E+00_JPRB,&
&5.2514E+00_JPRB,6.0902E+00_JPRB,6.2346E+00_JPRB,6.5981E+00_JPRB/)
KAO( :, 2, 1,15) = (/&
&8.5770E+00_JPRB,7.5051E+00_JPRB,6.4332E+00_JPRB,5.3613E+00_JPRB,4.4922E+00_JPRB,5.5332E+00_JPRB,&
&6.6248E+00_JPRB,7.6856E+00_JPRB,7.8788E+00_JPRB,8.3358E+00_JPRB/)
KAO( :, 3, 1,15) = (/&
&9.7196E+00_JPRB,8.4924E+00_JPRB,7.2901E+00_JPRB,6.0754E+00_JPRB,5.4287E+00_JPRB,6.7758E+00_JPRB,&
&8.1174E+00_JPRB,9.4295E+00_JPRB,9.6454E+00_JPRB,1.0231E+01_JPRB/)
KAO( :, 4, 1,15) = (/&
&1.0823E+01_JPRB,9.4701E+00_JPRB,8.1175E+00_JPRB,6.7650E+00_JPRB,6.4845E+00_JPRB,8.0968E+00_JPRB,&
&9.6971E+00_JPRB,1.1247E+01_JPRB,1.1535E+01_JPRB,1.2232E+01_JPRB/)
KAO( :, 5, 1,15) = (/&
&1.1862E+01_JPRB,1.0380E+01_JPRB,8.8975E+00_JPRB,7.4149E+00_JPRB,7.5987E+00_JPRB,9.4854E+00_JPRB,&
&1.1367E+01_JPRB,1.3183E+01_JPRB,1.3535E+01_JPRB,1.4322E+01_JPRB/)
KAO( :, 1, 2,15) = (/&
&7.2487E+00_JPRB,6.3428E+00_JPRB,5.4369E+00_JPRB,4.5309E+00_JPRB,3.8305E+00_JPRB,4.6866E+00_JPRB,&
&5.6122E+00_JPRB,6.5109E+00_JPRB,6.6944E+00_JPRB,7.2237E+00_JPRB/)
KAO( :, 2, 2,15) = (/&
&8.4632E+00_JPRB,7.4054E+00_JPRB,6.3477E+00_JPRB,5.2900E+00_JPRB,4.7972E+00_JPRB,5.9774E+00_JPRB,&
&7.1612E+00_JPRB,8.3091E+00_JPRB,8.5448E+00_JPRB,9.2203E+00_JPRB/)
KAO( :, 3, 2,15) = (/&
&9.6376E+00_JPRB,8.4331E+00_JPRB,7.2286E+00_JPRB,6.0241E+00_JPRB,5.9277E+00_JPRB,7.4032E+00_JPRB,&
&8.8670E+00_JPRB,1.0288E+01_JPRB,1.0591E+01_JPRB,1.1420E+01_JPRB/)
KAO( :, 4, 2,15) = (/&
&1.0787E+01_JPRB,9.4386E+00_JPRB,8.0905E+00_JPRB,6.7423E+00_JPRB,7.1365E+00_JPRB,8.9120E+00_JPRB,&
&1.0675E+01_JPRB,1.2387E+01_JPRB,1.2766E+01_JPRB,1.3751E+01_JPRB/)
KAO( :, 5, 2,15) = (/&
&1.1876E+01_JPRB,1.0392E+01_JPRB,8.9076E+00_JPRB,7.4263E+00_JPRB,8.4093E+00_JPRB,1.0502E+01_JPRB,&
&1.2577E+01_JPRB,1.4600E+01_JPRB,1.5061E+01_JPRB,1.6216E+01_JPRB/)
KAO( :, 1, 3,15) = (/&
&6.8060E+00_JPRB,5.9554E+00_JPRB,5.1048E+00_JPRB,4.2541E+00_JPRB,3.7945E+00_JPRB,4.6793E+00_JPRB,&
&5.6066E+00_JPRB,6.5069E+00_JPRB,6.7262E+00_JPRB,7.3705E+00_JPRB/)
KAO( :, 2, 3,15) = (/&
&8.0512E+00_JPRB,7.0449E+00_JPRB,6.0387E+00_JPRB,5.0324E+00_JPRB,4.8723E+00_JPRB,6.0807E+00_JPRB,&
&7.2845E+00_JPRB,8.4534E+00_JPRB,8.7471E+00_JPRB,9.5785E+00_JPRB/)
KAO( :, 3, 3,15) = (/&
&9.2771E+00_JPRB,8.1176E+00_JPRB,6.9581E+00_JPRB,5.7986E+00_JPRB,6.1227E+00_JPRB,7.6490E+00_JPRB,&
&9.1620E+00_JPRB,1.0634E+01_JPRB,1.1013E+01_JPRB,1.2049E+01_JPRB/)
KAO( :, 4, 3,15) = (/&
&1.0461E+01_JPRB,9.1535E+00_JPRB,7.8460E+00_JPRB,6.5548E+00_JPRB,7.4810E+00_JPRB,9.3445E+00_JPRB,&
&1.1193E+01_JPRB,1.2995E+01_JPRB,1.3474E+01_JPRB,1.4726E+01_JPRB/)
KAO( :, 5, 3,15) = (/&
&1.1612E+01_JPRB,1.0161E+01_JPRB,8.7094E+00_JPRB,7.3963E+00_JPRB,8.9014E+00_JPRB,1.1119E+01_JPRB,&
&1.3323E+01_JPRB,1.5462E+01_JPRB,1.6055E+01_JPRB,1.7525E+01_JPRB/)
KAO( :, 1, 4,15) = (/&
&6.2727E+00_JPRB,5.4887E+00_JPRB,4.7047E+00_JPRB,3.9207E+00_JPRB,3.6525E+00_JPRB,4.5000E+00_JPRB,&
&5.3898E+00_JPRB,6.2588E+00_JPRB,6.5149E+00_JPRB,7.1567E+00_JPRB/)
KAO( :, 2, 4,15) = (/&
&7.5169E+00_JPRB,6.5774E+00_JPRB,5.6379E+00_JPRB,4.6985E+00_JPRB,4.7911E+00_JPRB,5.9751E+00_JPRB,&
&7.1596E+00_JPRB,8.3141E+00_JPRB,8.6620E+00_JPRB,9.5044E+00_JPRB/)
KAO( :, 3, 4,15) = (/&
&8.7861E+00_JPRB,7.6880E+00_JPRB,6.5898E+00_JPRB,5.5305E+00_JPRB,6.1247E+00_JPRB,7.6488E+00_JPRB,&
&9.1669E+00_JPRB,1.0645E+01_JPRB,1.1106E+01_JPRB,1.2173E+01_JPRB/)
KAO( :, 4, 4,15) = (/&
&1.0026E+01_JPRB,8.7728E+00_JPRB,7.5197E+00_JPRB,6.4473E+00_JPRB,7.6081E+00_JPRB,9.5022E+00_JPRB,&
&1.1386E+01_JPRB,1.3225E+01_JPRB,1.3819E+01_JPRB,1.5121E+01_JPRB/)
KAO( :, 5, 4,15) = (/&
&1.1215E+01_JPRB,9.8132E+00_JPRB,8.4117E+00_JPRB,7.4634E+00_JPRB,9.1763E+00_JPRB,1.1465E+01_JPRB,&
&1.3734E+01_JPRB,1.5956E+01_JPRB,1.6697E+01_JPRB,1.8243E+01_JPRB/)
KAO( :, 1, 5,15) = (/&
&5.7094E+00_JPRB,4.9958E+00_JPRB,4.2822E+00_JPRB,3.5751E+00_JPRB,3.4456E+00_JPRB,4.2408E+00_JPRB,&
&5.0808E+00_JPRB,5.9001E+00_JPRB,6.1640E+00_JPRB,6.7724E+00_JPRB/)
KAO( :, 2, 5,15) = (/&
&6.9610E+00_JPRB,6.0909E+00_JPRB,5.2209E+00_JPRB,4.3950E+00_JPRB,4.6160E+00_JPRB,5.7378E+00_JPRB,&
&6.8746E+00_JPRB,7.9877E+00_JPRB,8.3933E+00_JPRB,9.1641E+00_JPRB/)
KAO( :, 3, 5,15) = (/&
&8.2452E+00_JPRB,7.2146E+00_JPRB,6.1840E+00_JPRB,5.2978E+00_JPRB,5.9973E+00_JPRB,7.4900E+00_JPRB,&
&8.9757E+00_JPRB,1.0429E+01_JPRB,1.0974E+01_JPRB,1.1967E+01_JPRB/)
KAO( :, 4, 5,15) = (/&
&9.5317E+00_JPRB,8.3403E+00_JPRB,7.1489E+00_JPRB,6.3594E+00_JPRB,7.5690E+00_JPRB,9.4570E+00_JPRB,&
&1.1330E+01_JPRB,1.3166E+01_JPRB,1.3879E+01_JPRB,1.5102E+01_JPRB/)
KAO( :, 5, 5,15) = (/&
&1.0774E+01_JPRB,9.4271E+00_JPRB,8.0808E+00_JPRB,7.5165E+00_JPRB,9.2600E+00_JPRB,1.1570E+01_JPRB,&
&1.3864E+01_JPRB,1.6116E+01_JPRB,1.7021E+01_JPRB,1.8481E+01_JPRB/)
KAO( :, 1, 6,15) = (/&
&5.0892E+00_JPRB,4.4531E+00_JPRB,3.8170E+00_JPRB,3.2199E+00_JPRB,3.2113E+00_JPRB,4.0113E+00_JPRB,&
&4.8052E+00_JPRB,5.5784E+00_JPRB,5.7946E+00_JPRB,6.4168E+00_JPRB/)
KAO( :, 2, 6,15) = (/&
&6.3415E+00_JPRB,5.5489E+00_JPRB,4.7563E+00_JPRB,4.0482E+00_JPRB,4.3407E+00_JPRB,5.4212E+00_JPRB,&
&6.4943E+00_JPRB,7.5434E+00_JPRB,7.9031E+00_JPRB,8.6734E+00_JPRB/)
KAO( :, 3, 6,15) = (/&
&7.6230E+00_JPRB,6.6701E+00_JPRB,5.7173E+00_JPRB,5.0372E+00_JPRB,5.7049E+00_JPRB,7.1268E+00_JPRB,&
&8.5427E+00_JPRB,9.9277E+00_JPRB,1.0503E+01_JPRB,1.1401E+01_JPRB/)
KAO( :, 4, 6,15) = (/&
&8.9427E+00_JPRB,7.8250E+00_JPRB,6.7072E+00_JPRB,6.1864E+00_JPRB,7.3054E+00_JPRB,9.1262E+00_JPRB,&
&1.0936E+01_JPRB,1.2717E+01_JPRB,1.3530E+01_JPRB,1.4596E+01_JPRB/)
KAO( :, 5, 6,15) = (/&
&1.0234E+01_JPRB,8.9552E+00_JPRB,7.6757E+00_JPRB,7.4408E+00_JPRB,9.0975E+00_JPRB,1.1364E+01_JPRB,&
&1.3619E+01_JPRB,1.5837E+01_JPRB,1.6857E+01_JPRB,1.8182E+01_JPRB/)
KAO( :, 1, 7,15) = (/&
&4.4701E+00_JPRB,3.9114E+00_JPRB,3.3527E+00_JPRB,2.8491E+00_JPRB,3.0525E+00_JPRB,3.8120E+00_JPRB,&
&4.5671E+00_JPRB,5.3029E+00_JPRB,5.5170E+00_JPRB,6.1054E+00_JPRB/)
KAO( :, 2, 7,15) = (/&
&5.7025E+00_JPRB,4.9897E+00_JPRB,4.2769E+00_JPRB,3.7076E+00_JPRB,4.1441E+00_JPRB,5.1768E+00_JPRB,&
&6.2022E+00_JPRB,7.2045E+00_JPRB,7.5353E+00_JPRB,8.2888E+00_JPRB/)
KAO( :, 3, 7,15) = (/&
&6.9903E+00_JPRB,6.1166E+00_JPRB,5.2429E+00_JPRB,4.7421E+00_JPRB,5.4711E+00_JPRB,6.8345E+00_JPRB,&
&8.1908E+00_JPRB,9.5158E+00_JPRB,1.0021E+01_JPRB,1.0944E+01_JPRB/)
KAO( :, 4, 7,15) = (/&
&8.3116E+00_JPRB,7.2727E+00_JPRB,6.2339E+00_JPRB,5.9347E+00_JPRB,7.0277E+00_JPRB,8.7788E+00_JPRB,&
&1.0523E+01_JPRB,1.2229E+01_JPRB,1.2970E+01_JPRB,1.4056E+01_JPRB/)
KAO( :, 5, 7,15) = (/&
&9.6433E+00_JPRB,8.4379E+00_JPRB,7.2404E+00_JPRB,7.2539E+00_JPRB,8.8191E+00_JPRB,1.1015E+01_JPRB,&
&1.3202E+01_JPRB,1.5351E+01_JPRB,1.6381E+01_JPRB,1.7636E+01_JPRB/)
KAO( :, 1, 8,15) = (/&
&3.8815E+00_JPRB,3.3963E+00_JPRB,2.9112E+00_JPRB,2.5144E+00_JPRB,2.8901E+00_JPRB,3.6107E+00_JPRB,&
&4.3267E+00_JPRB,5.0237E+00_JPRB,5.2562E+00_JPRB,5.7843E+00_JPRB/)
KAO( :, 2, 8,15) = (/&
&5.0803E+00_JPRB,4.4453E+00_JPRB,3.8103E+00_JPRB,3.3588E+00_JPRB,3.9581E+00_JPRB,4.9433E+00_JPRB,&
&5.9245E+00_JPRB,6.8831E+00_JPRB,7.2246E+00_JPRB,7.9205E+00_JPRB/)
KAO( :, 3, 8,15) = (/&
&6.3642E+00_JPRB,5.5687E+00_JPRB,4.7732E+00_JPRB,4.4061E+00_JPRB,5.2635E+00_JPRB,6.5746E+00_JPRB,&
&7.8793E+00_JPRB,9.1591E+00_JPRB,9.6612E+00_JPRB,1.0533E+01_JPRB/)
KAO( :, 4, 8,15) = (/&
&7.6962E+00_JPRB,6.7342E+00_JPRB,5.8016E+00_JPRB,5.6218E+00_JPRB,6.8073E+00_JPRB,8.5035E+00_JPRB,&
&1.0191E+01_JPRB,1.1842E+01_JPRB,1.2564E+01_JPRB,1.3618E+01_JPRB/)
KAO( :, 5, 8,15) = (/&
&9.0600E+00_JPRB,7.9276E+00_JPRB,6.8887E+00_JPRB,6.9782E+00_JPRB,8.5965E+00_JPRB,1.0738E+01_JPRB,&
&1.2872E+01_JPRB,1.4959E+01_JPRB,1.5916E+01_JPRB,1.7201E+01_JPRB/)
KAO( :, 1, 9,15) = (/&
&3.3248E+00_JPRB,2.9093E+00_JPRB,2.4937E+00_JPRB,2.2724E+00_JPRB,2.6961E+00_JPRB,3.3684E+00_JPRB,&
&4.0359E+00_JPRB,4.6900E+00_JPRB,4.9499E+00_JPRB,5.3973E+00_JPRB/)
KAO( :, 2, 9,15) = (/&
&4.4808E+00_JPRB,3.9207E+00_JPRB,3.3615E+00_JPRB,3.0920E+00_JPRB,3.7395E+00_JPRB,4.6706E+00_JPRB,&
&5.5971E+00_JPRB,6.5044E+00_JPRB,6.8727E+00_JPRB,7.4836E+00_JPRB/)
KAO( :, 3, 9,15) = (/&
&5.7505E+00_JPRB,5.0317E+00_JPRB,4.3435E+00_JPRB,4.1016E+00_JPRB,5.0205E+00_JPRB,6.2714E+00_JPRB,&
&7.5160E+00_JPRB,8.7397E+00_JPRB,9.2709E+00_JPRB,1.0047E+01_JPRB/)
KAO( :, 4, 9,15) = (/&
&7.0908E+00_JPRB,6.2044E+00_JPRB,5.3782E+00_JPRB,5.2882E+00_JPRB,6.5597E+00_JPRB,8.1944E+00_JPRB,&
&9.8217E+00_JPRB,1.1416E+01_JPRB,1.2142E+01_JPRB,1.3130E+01_JPRB/)
KAO( :, 5, 9,15) = (/&
&8.4732E+00_JPRB,7.4141E+00_JPRB,6.4913E+00_JPRB,6.6287E+00_JPRB,8.3565E+00_JPRB,1.0438E+01_JPRB,&
&1.2512E+01_JPRB,1.4551E+01_JPRB,1.5514E+01_JPRB,1.6723E+01_JPRB/)
KAO( :, 1,10,15) = (/&
&2.8920E+00_JPRB,2.5306E+00_JPRB,2.1693E+00_JPRB,2.0986E+00_JPRB,2.5124E+00_JPRB,3.1388E+00_JPRB,&
&3.7625E+00_JPRB,4.3752E+00_JPRB,4.6672E+00_JPRB,5.6157E+00_JPRB/)
KAO( :, 2,10,15) = (/&
&4.0040E+00_JPRB,3.5035E+00_JPRB,3.0238E+00_JPRB,2.9376E+00_JPRB,3.5667E+00_JPRB,4.4559E+00_JPRB,&
&5.3416E+00_JPRB,6.2115E+00_JPRB,6.6210E+00_JPRB,7.1691E+00_JPRB/)
KAO( :, 3,10,15) = (/&
&5.2529E+00_JPRB,4.5963E+00_JPRB,3.9804E+00_JPRB,3.9436E+00_JPRB,4.8397E+00_JPRB,6.0465E+00_JPRB,&
&7.2474E+00_JPRB,8.4282E+00_JPRB,9.0023E+00_JPRB,9.6885E+00_JPRB/)
KAO( :, 4,10,15) = (/&
&6.6009E+00_JPRB,5.7758E+00_JPRB,5.0451E+00_JPRB,5.1236E+00_JPRB,6.3901E+00_JPRB,7.9831E+00_JPRB,&
&9.5690E+00_JPRB,1.1128E+01_JPRB,1.1898E+01_JPRB,1.2790E+01_JPRB/)
KAO( :, 5,10,15) = (/&
&8.0358E+00_JPRB,7.0314E+00_JPRB,6.2146E+00_JPRB,6.4650E+00_JPRB,8.1964E+00_JPRB,1.0240E+01_JPRB,&
&1.2274E+01_JPRB,1.4283E+01_JPRB,1.5317E+01_JPRB,1.6405E+01_JPRB/)
KAO( :, 1,11,15) = (/&
&2.9597E+00_JPRB,2.5897E+00_JPRB,2.2655E+00_JPRB,2.2769E+00_JPRB,2.7359E+00_JPRB,3.4131E+00_JPRB,&
&4.0924E+00_JPRB,4.7622E+00_JPRB,5.1369E+00_JPRB,8.7664E+00_JPRB/)
KAO( :, 2,11,15) = (/&
&4.1090E+00_JPRB,3.5954E+00_JPRB,3.1274E+00_JPRB,3.2086E+00_JPRB,3.8891E+00_JPRB,4.8589E+00_JPRB,&
&5.8255E+00_JPRB,6.7761E+00_JPRB,7.2974E+00_JPRB,9.1429E+00_JPRB/)
KAO( :, 3,11,15) = (/&
&5.4257E+00_JPRB,4.7475E+00_JPRB,4.1432E+00_JPRB,4.3071E+00_JPRB,5.2960E+00_JPRB,6.6178E+00_JPRB,&
&7.9327E+00_JPRB,9.2300E+00_JPRB,9.9139E+00_JPRB,1.0877E+01_JPRB/)
KAO( :, 4,11,15) = (/&
&6.8635E+00_JPRB,6.0056E+00_JPRB,5.3031E+00_JPRB,5.5726E+00_JPRB,6.9728E+00_JPRB,8.7117E+00_JPRB,&
&1.0444E+01_JPRB,1.2152E+01_JPRB,1.3068E+01_JPRB,1.3956E+01_JPRB/)
KAO( :, 5,11,15) = (/&
&8.4007E+00_JPRB,7.3506E+00_JPRB,6.6010E+00_JPRB,7.0376E+00_JPRB,8.9249E+00_JPRB,1.1150E+01_JPRB,&
&1.3367E+01_JPRB,1.5547E+01_JPRB,1.6736E+01_JPRB,1.7861E+01_JPRB/)
KAO( :, 1,12,15) = (/&
&3.0706E+00_JPRB,2.6868E+00_JPRB,2.3786E+00_JPRB,2.4650E+00_JPRB,2.9376E+00_JPRB,3.6606E+00_JPRB,&
&4.3900E+00_JPRB,5.1097E+00_JPRB,5.5523E+00_JPRB,1.1122E+01_JPRB/)
KAO( :, 2,12,15) = (/&
&4.2894E+00_JPRB,3.7532E+00_JPRB,3.3135E+00_JPRB,3.4942E+00_JPRB,4.2139E+00_JPRB,5.2646E+00_JPRB,&
&6.3121E+00_JPRB,7.3466E+00_JPRB,7.9376E+00_JPRB,1.1136E+01_JPRB/)
KAO( :, 3,12,15) = (/&
&5.6884E+00_JPRB,4.9773E+00_JPRB,4.4260E+00_JPRB,4.7039E+00_JPRB,5.7519E+00_JPRB,7.1866E+00_JPRB,&
&8.6165E+00_JPRB,1.0029E+01_JPRB,1.0827E+01_JPRB,1.2499E+01_JPRB/)
KAO( :, 4,12,15) = (/&
&7.2505E+00_JPRB,6.3448E+00_JPRB,5.7066E+00_JPRB,6.0941E+00_JPRB,7.5592E+00_JPRB,9.4443E+00_JPRB,&
&1.1323E+01_JPRB,1.3172E+01_JPRB,1.4230E+01_JPRB,1.5157E+01_JPRB/)
KAO( :, 5,12,15) = (/&
&8.9729E+00_JPRB,7.8513E+00_JPRB,7.1677E+00_JPRB,7.7018E+00_JPRB,9.6945E+00_JPRB,1.2112E+01_JPRB,&
&1.4519E+01_JPRB,1.6896E+01_JPRB,1.8235E+01_JPRB,1.9402E+01_JPRB/)
KAO( :, 1,13,15) = (/&
&3.2246E+00_JPRB,2.8216E+00_JPRB,2.5410E+00_JPRB,2.6672E+00_JPRB,3.1335E+00_JPRB,3.8953E+00_JPRB,&
&4.6718E+00_JPRB,5.4398E+00_JPRB,5.9398E+00_JPRB,1.1048E+01_JPRB/)
KAO( :, 2,13,15) = (/&
&4.5396E+00_JPRB,3.9722E+00_JPRB,3.6057E+00_JPRB,3.8124E+00_JPRB,4.5235E+00_JPRB,5.6334E+00_JPRB,&
&6.7551E+00_JPRB,7.8654E+00_JPRB,8.5655E+00_JPRB,1.1523E+01_JPRB/)
KAO( :, 3,13,15) = (/&
&6.0822E+00_JPRB,5.3219E+00_JPRB,4.8716E+00_JPRB,5.1514E+00_JPRB,6.1861E+00_JPRB,7.7214E+00_JPRB,&
&9.2581E+00_JPRB,1.0776E+01_JPRB,1.1699E+01_JPRB,1.3150E+01_JPRB/)
KAO( :, 4,13,15) = (/&
&7.8600E+00_JPRB,6.8777E+00_JPRB,6.3193E+00_JPRB,6.6903E+00_JPRB,8.1367E+00_JPRB,1.0164E+01_JPRB,&
&1.2187E+01_JPRB,1.4188E+01_JPRB,1.5392E+01_JPRB,1.6289E+01_JPRB/)
KAO( :, 5,13,15) = (/&
&9.8483E+00_JPRB,8.6182E+00_JPRB,7.9619E+00_JPRB,8.4555E+00_JPRB,1.0467E+01_JPRB,1.3077E+01_JPRB,&
&1.5680E+01_JPRB,1.8246E+01_JPRB,1.9749E+01_JPRB,2.0946E+01_JPRB/)
KAO( :, 1, 1,16) = (/&
&7.5127E+00_JPRB,6.5737E+00_JPRB,5.6349E+00_JPRB,4.6958E+00_JPRB,3.8779E+00_JPRB,4.8416E+00_JPRB,&
&5.7981E+00_JPRB,6.7189E+00_JPRB,6.8002E+00_JPRB,7.2408E+00_JPRB/)
KAO( :, 2, 1,16) = (/&
&8.6979E+00_JPRB,7.6109E+00_JPRB,6.5239E+00_JPRB,5.4368E+00_JPRB,4.7903E+00_JPRB,5.9807E+00_JPRB,&
&7.1609E+00_JPRB,8.2994E+00_JPRB,8.3109E+00_JPRB,8.9455E+00_JPRB/)
KAO( :, 3, 1,16) = (/&
&9.7317E+00_JPRB,8.6042E+00_JPRB,7.2993E+00_JPRB,6.0830E+00_JPRB,5.8526E+00_JPRB,7.3076E+00_JPRB,&
&8.7490E+00_JPRB,1.0034E+01_JPRB,1.0263E+01_JPRB,1.0816E+01_JPRB/)
KAO( :, 4, 1,16) = (/&
&1.0961E+01_JPRB,9.5913E+00_JPRB,8.2214E+00_JPRB,6.8514E+00_JPRB,7.1532E+00_JPRB,8.9336E+00_JPRB,&
&1.0696E+01_JPRB,1.2395E+01_JPRB,1.2541E+01_JPRB,1.3218E+01_JPRB/)
KAO( :, 5, 1,16) = (/&
&1.2007E+01_JPRB,1.0506E+01_JPRB,9.0063E+00_JPRB,7.5055E+00_JPRB,8.5533E+00_JPRB,1.0682E+01_JPRB,&
&1.2789E+01_JPRB,1.4823E+01_JPRB,1.5003E+01_JPRB,1.5975E+01_JPRB/)
KAO( :, 1, 2,16) = (/&
&7.3731E+00_JPRB,6.4516E+00_JPRB,5.5301E+00_JPRB,4.6086E+00_JPRB,4.2937E+00_JPRB,5.3609E+00_JPRB,&
&6.4198E+00_JPRB,7.4408E+00_JPRB,7.5329E+00_JPRB,8.2124E+00_JPRB/)
KAO( :, 2, 2,16) = (/&
&8.6021E+00_JPRB,7.5271E+00_JPRB,6.4520E+00_JPRB,5.3768E+00_JPRB,5.3675E+00_JPRB,6.7018E+00_JPRB,&
&8.0237E+00_JPRB,9.2997E+00_JPRB,9.4140E+00_JPRB,1.0264E+01_JPRB/)
KAO( :, 3, 2,16) = (/&
&9.7888E+00_JPRB,8.5654E+00_JPRB,7.3420E+00_JPRB,6.1186E+00_JPRB,6.5496E+00_JPRB,8.1782E+00_JPRB,&
&9.7904E+00_JPRB,1.1344E+01_JPRB,1.1474E+01_JPRB,1.2519E+01_JPRB/)
KAO( :, 4, 2,16) = (/&
&1.0945E+01_JPRB,9.5769E+00_JPRB,8.2090E+00_JPRB,6.8412E+00_JPRB,8.0474E+00_JPRB,1.0048E+01_JPRB,&
&1.2030E+01_JPRB,1.3944E+01_JPRB,1.4114E+01_JPRB,1.5388E+01_JPRB/)
KAO( :, 5, 2,16) = (/&
&1.2042E+01_JPRB,1.0537E+01_JPRB,9.0333E+00_JPRB,7.5280E+00_JPRB,9.7062E+00_JPRB,1.2117E+01_JPRB,&
&1.4511E+01_JPRB,1.6819E+01_JPRB,1.7024E+01_JPRB,1.8558E+01_JPRB/)
KAO( :, 1, 3,16) = (/&
&6.9437E+00_JPRB,6.0759E+00_JPRB,5.2080E+00_JPRB,4.3402E+00_JPRB,4.5023E+00_JPRB,5.6214E+00_JPRB,&
&6.7297E+00_JPRB,7.8026E+00_JPRB,7.9012E+00_JPRB,8.8155E+00_JPRB/)
KAO( :, 2, 3,16) = (/&
&8.2070E+00_JPRB,7.1813E+00_JPRB,6.1554E+00_JPRB,5.1298E+00_JPRB,5.7329E+00_JPRB,7.1578E+00_JPRB,&
&8.5699E+00_JPRB,9.9336E+00_JPRB,1.0060E+01_JPRB,1.1228E+01_JPRB/)
KAO( :, 3, 3,16) = (/&
&9.4491E+00_JPRB,8.2681E+00_JPRB,7.0872E+00_JPRB,5.9062E+00_JPRB,7.0707E+00_JPRB,8.8297E+00_JPRB,&
&1.0581E+01_JPRB,1.2262E+01_JPRB,1.2422E+01_JPRB,1.3860E+01_JPRB/)
KAO( :, 4, 3,16) = (/&
&1.0642E+01_JPRB,9.3115E+00_JPRB,7.9815E+00_JPRB,6.6515E+00_JPRB,8.6654E+00_JPRB,1.0819E+01_JPRB,&
&1.2954E+01_JPRB,1.5013E+01_JPRB,1.5194E+01_JPRB,1.6966E+01_JPRB/)
KAO( :, 5, 3,16) = (/&
&1.1807E+01_JPRB,1.0331E+01_JPRB,8.8554E+00_JPRB,7.9416E+00_JPRB,1.0582E+01_JPRB,1.3212E+01_JPRB,&
&1.5820E+01_JPRB,1.8322E+01_JPRB,1.8571E+01_JPRB,2.0721E+01_JPRB/)
KAO( :, 1, 4,16) = (/&
&6.4258E+00_JPRB,5.6226E+00_JPRB,4.8196E+00_JPRB,4.0164E+00_JPRB,4.5983E+00_JPRB,5.7339E+00_JPRB,&
&6.8740E+00_JPRB,7.9661E+00_JPRB,8.0728E+00_JPRB,9.1132E+00_JPRB/)
KAO( :, 2, 4,16) = (/&
&7.6917E+00_JPRB,6.7303E+00_JPRB,5.7690E+00_JPRB,4.8076E+00_JPRB,5.9866E+00_JPRB,7.4749E+00_JPRB,&
&8.9518E+00_JPRB,1.0377E+01_JPRB,1.0515E+01_JPRB,1.1857E+01_JPRB/)
KAO( :, 3, 4,16) = (/&
&8.9813E+00_JPRB,7.8586E+00_JPRB,6.7361E+00_JPRB,5.6678E+00_JPRB,7.5316E+00_JPRB,9.4038E+00_JPRB,&
&1.1247E+01_JPRB,1.3049E+01_JPRB,1.3228E+01_JPRB,1.4925E+01_JPRB/)
KAO( :, 4, 4,16) = (/&
&1.0239E+01_JPRB,8.9593E+00_JPRB,7.6796E+00_JPRB,6.9509E+00_JPRB,9.2615E+00_JPRB,1.1564E+01_JPRB,&
&1.3845E+01_JPRB,1.6028E+01_JPRB,1.6220E+01_JPRB,1.8333E+01_JPRB/)
KAO( :, 5, 4,16) = (/&
&1.1440E+01_JPRB,1.0010E+01_JPRB,8.5838E+00_JPRB,8.5098E+00_JPRB,1.1339E+01_JPRB,1.4159E+01_JPRB,&
&1.6953E+01_JPRB,1.9656E+01_JPRB,1.9906E+01_JPRB,2.2476E+01_JPRB/)
KAO( :, 1, 5,16) = (/&
&5.8770E+00_JPRB,5.1424E+00_JPRB,4.4079E+00_JPRB,3.6733E+00_JPRB,4.6297E+00_JPRB,5.7866E+00_JPRB,&
&6.9277E+00_JPRB,8.0308E+00_JPRB,8.1369E+00_JPRB,9.2272E+00_JPRB/)
KAO( :, 2, 5,16) = (/&
&7.1523E+00_JPRB,6.2582E+00_JPRB,5.3644E+00_JPRB,4.6413E+00_JPRB,6.1841E+00_JPRB,7.7213E+00_JPRB,&
&9.2461E+00_JPRB,1.0718E+01_JPRB,1.0873E+01_JPRB,1.2325E+01_JPRB/)
KAO( :, 3, 5,16) = (/&
&8.4613E+00_JPRB,7.4038E+00_JPRB,6.3462E+00_JPRB,5.9572E+00_JPRB,7.9337E+00_JPRB,9.9057E+00_JPRB,&
&1.1872E+01_JPRB,1.3758E+01_JPRB,1.3965E+01_JPRB,1.5800E+01_JPRB/)
KAO( :, 4, 5,16) = (/&
&9.7676E+00_JPRB,8.5468E+00_JPRB,7.3259E+00_JPRB,7.4238E+00_JPRB,9.8916E+00_JPRB,1.2352E+01_JPRB,&
&1.4791E+01_JPRB,1.7147E+01_JPRB,1.7384E+01_JPRB,1.9719E+01_JPRB/)
KAO( :, 5, 5,16) = (/&
&1.1025E+01_JPRB,9.6472E+00_JPRB,8.2716E+00_JPRB,9.1406E+00_JPRB,1.2179E+01_JPRB,1.5208E+01_JPRB,&
&1.8211E+01_JPRB,2.1097E+01_JPRB,2.1364E+01_JPRB,2.4267E+01_JPRB/)
KAO( :, 1, 6,16) = (/&
&5.2650E+00_JPRB,4.6069E+00_JPRB,3.9488E+00_JPRB,3.4184E+00_JPRB,4.5538E+00_JPRB,5.6834E+00_JPRB,&
&6.8059E+00_JPRB,7.8914E+00_JPRB,8.0145E+00_JPRB,9.0940E+00_JPRB/)
KAO( :, 2, 6,16) = (/&
&6.5470E+00_JPRB,5.7287E+00_JPRB,4.9104E+00_JPRB,4.6912E+00_JPRB,6.2505E+00_JPRB,7.8043E+00_JPRB,&
&9.3463E+00_JPRB,1.0825E+01_JPRB,1.1010E+01_JPRB,1.2479E+01_JPRB/)
KAO( :, 3, 6,16) = (/&
&7.8534E+00_JPRB,6.8718E+00_JPRB,5.8902E+00_JPRB,6.1640E+00_JPRB,8.2139E+00_JPRB,1.0257E+01_JPRB,&
&1.2274E+01_JPRB,1.4245E+01_JPRB,1.4468E+01_JPRB,1.6406E+01_JPRB/)
KAO( :, 4, 6,16) = (/&
&9.2007E+00_JPRB,8.0507E+00_JPRB,6.9007E+00_JPRB,7.8216E+00_JPRB,1.0421E+01_JPRB,1.3014E+01_JPRB,&
&1.5581E+01_JPRB,1.8055E+01_JPRB,1.8344E+01_JPRB,2.0809E+01_JPRB/)
KAO( :, 5, 6,16) = (/&
&1.0512E+01_JPRB,9.1984E+00_JPRB,7.8842E+00_JPRB,9.7429E+00_JPRB,1.2982E+01_JPRB,1.6206E+01_JPRB,&
&1.9407E+01_JPRB,2.2502E+01_JPRB,2.2789E+01_JPRB,2.5928E+01_JPRB/)
KAO( :, 1, 7,16) = (/&
&4.6565E+00_JPRB,4.0745E+00_JPRB,3.4925E+00_JPRB,3.2956E+00_JPRB,4.3911E+00_JPRB,5.4864E+00_JPRB,&
&6.5695E+00_JPRB,7.6115E+00_JPRB,7.7439E+00_JPRB,8.7837E+00_JPRB/)
KAO( :, 2, 7,16) = (/&
&5.9292E+00_JPRB,5.1881E+00_JPRB,4.4470E+00_JPRB,4.6697E+00_JPRB,6.2219E+00_JPRB,7.7686E+00_JPRB,&
&9.3043E+00_JPRB,1.0790E+01_JPRB,1.0982E+01_JPRB,1.2451E+01_JPRB/)
KAO( :, 3, 7,16) = (/&
&7.2576E+00_JPRB,6.3505E+00_JPRB,5.4433E+00_JPRB,6.2922E+00_JPRB,8.3823E+00_JPRB,1.0468E+01_JPRB,&
&1.2543E+01_JPRB,1.4536E+01_JPRB,1.4805E+01_JPRB,1.6765E+01_JPRB/)
KAO( :, 4, 7,16) = (/&
&8.6179E+00_JPRB,7.5406E+00_JPRB,6.4633E+00_JPRB,8.1550E+00_JPRB,1.0866E+01_JPRB,1.3567E+01_JPRB,&
&1.6244E+01_JPRB,1.8842E+01_JPRB,1.9186E+01_JPRB,2.1742E+01_JPRB/)
KAO( :, 5, 7,16) = (/&
&9.9851E+00_JPRB,8.7370E+00_JPRB,7.4898E+00_JPRB,1.0321E+01_JPRB,1.3752E+01_JPRB,1.7171E+01_JPRB,&
&2.0561E+01_JPRB,2.3825E+01_JPRB,2.4177E+01_JPRB,2.7508E+01_JPRB/)
KAO( :, 1, 8,16) = (/&
&4.0754E+00_JPRB,3.5660E+00_JPRB,3.0566E+00_JPRB,3.1333E+00_JPRB,4.1749E+00_JPRB,5.2109E+00_JPRB,&
&6.2379E+00_JPRB,7.2391E+00_JPRB,7.3822E+00_JPRB,8.3583E+00_JPRB/)
KAO( :, 2, 8,16) = (/&
&5.3273E+00_JPRB,4.6614E+00_JPRB,3.9956E+00_JPRB,4.5880E+00_JPRB,6.1132E+00_JPRB,7.6329E+00_JPRB,&
&9.1372E+00_JPRB,1.0600E+01_JPRB,1.0819E+01_JPRB,1.2238E+01_JPRB/)
KAO( :, 3, 8,16) = (/&
&6.6607E+00_JPRB,5.8281E+00_JPRB,4.9956E+00_JPRB,6.3489E+00_JPRB,8.4692E+00_JPRB,1.0575E+01_JPRB,&
&1.2658E+01_JPRB,1.4678E+01_JPRB,1.4991E+01_JPRB,1.6951E+01_JPRB/)
KAO( :, 4, 8,16) = (/&
&8.0394E+00_JPRB,7.0344E+00_JPRB,6.0296E+00_JPRB,8.4237E+00_JPRB,1.1224E+01_JPRB,1.4014E+01_JPRB,&
&1.6789E+01_JPRB,1.9460E+01_JPRB,1.9854E+01_JPRB,2.2470E+01_JPRB/)
KAO( :, 5, 8,16) = (/&
&9.4437E+00_JPRB,8.2633E+00_JPRB,7.2895E+00_JPRB,1.0868E+01_JPRB,1.4480E+01_JPRB,1.8081E+01_JPRB,&
&2.1653E+01_JPRB,2.5111E+01_JPRB,2.5514E+01_JPRB,2.8990E+01_JPRB/)
KAO( :, 1, 9,16) = (/&
&3.5121E+00_JPRB,3.0731E+00_JPRB,2.6341E+00_JPRB,2.9279E+00_JPRB,3.9013E+00_JPRB,4.8754E+00_JPRB,&
&5.8368E+00_JPRB,6.7644E+00_JPRB,6.8920E+00_JPRB,7.8150E+00_JPRB/)
KAO( :, 2, 9,16) = (/&
&4.7223E+00_JPRB,4.1321E+00_JPRB,3.5416E+00_JPRB,4.4240E+00_JPRB,5.8947E+00_JPRB,7.3602E+00_JPRB,&
&8.8237E+00_JPRB,1.0234E+01_JPRB,1.0473E+01_JPRB,1.1818E+01_JPRB/)
KAO( :, 3, 9,16) = (/&
&6.0478E+00_JPRB,5.2918E+00_JPRB,4.5359E+00_JPRB,6.3118E+00_JPRB,8.4105E+00_JPRB,1.0504E+01_JPRB,&
&1.2585E+01_JPRB,1.4594E+01_JPRB,1.4948E+01_JPRB,1.6837E+01_JPRB/)
KAO( :, 4, 9,16) = (/&
&7.4404E+00_JPRB,6.5104E+00_JPRB,5.8282E+00_JPRB,8.5908E+00_JPRB,1.1447E+01_JPRB,1.4294E+01_JPRB,&
&1.7119E+01_JPRB,1.9856E+01_JPRB,2.0299E+01_JPRB,2.2935E+01_JPRB/)
KAO( :, 5, 9,16) = (/&
&8.8732E+00_JPRB,7.7641E+00_JPRB,7.5539E+00_JPRB,1.1327E+01_JPRB,1.5093E+01_JPRB,1.8849E+01_JPRB,&
&2.2573E+01_JPRB,2.6165E+01_JPRB,2.6652E+01_JPRB,3.0230E+01_JPRB/)
KAO( :, 1,10,16) = (/&
&3.0618E+00_JPRB,2.6791E+00_JPRB,2.2964E+00_JPRB,2.9364E+00_JPRB,3.9126E+00_JPRB,4.8847E+00_JPRB,&
&5.8475E+00_JPRB,6.7808E+00_JPRB,6.8756E+00_JPRB,7.8358E+00_JPRB/)
KAO( :, 2,10,16) = (/&
&4.2316E+00_JPRB,3.7027E+00_JPRB,3.1743E+00_JPRB,4.3350E+00_JPRB,5.7762E+00_JPRB,7.2138E+00_JPRB,&
&8.6367E+00_JPRB,1.0019E+01_JPRB,1.0284E+01_JPRB,1.1570E+01_JPRB/)
KAO( :, 3,10,16) = (/&
&5.5457E+00_JPRB,4.8525E+00_JPRB,4.3615E+00_JPRB,6.3373E+00_JPRB,8.4492E+00_JPRB,1.0550E+01_JPRB,&
&1.2638E+01_JPRB,1.4656E+01_JPRB,1.5082E+01_JPRB,1.6923E+01_JPRB/)
KAO( :, 4,10,16) = (/&
&6.9593E+00_JPRB,6.0894E+00_JPRB,5.9134E+00_JPRB,8.8661E+00_JPRB,1.1814E+01_JPRB,1.4751E+01_JPRB,&
&1.7669E+01_JPRB,2.0491E+01_JPRB,2.0978E+01_JPRB,2.3664E+01_JPRB/)
KAO( :, 5,10,16) = (/&
&8.4396E+00_JPRB,7.3847E+00_JPRB,7.9651E+00_JPRB,1.1942E+01_JPRB,1.5915E+01_JPRB,1.9872E+01_JPRB,&
&2.3793E+01_JPRB,2.7593E+01_JPRB,2.8161E+01_JPRB,3.1872E+01_JPRB/)
KAO( :, 1,11,16) = (/&
&3.1579E+00_JPRB,2.7632E+00_JPRB,2.3896E+00_JPRB,3.5545E+00_JPRB,4.7362E+00_JPRB,5.9136E+00_JPRB,&
&7.0823E+00_JPRB,8.2069E+00_JPRB,8.3323E+00_JPRB,9.4873E+00_JPRB/)
KAO( :, 2,11,16) = (/&
&4.3744E+00_JPRB,3.8276E+00_JPRB,3.5100E+00_JPRB,5.1538E+00_JPRB,6.8671E+00_JPRB,8.5743E+00_JPRB,&
&1.0274E+01_JPRB,1.1914E+01_JPRB,1.2209E+01_JPRB,1.3757E+01_JPRB/)
KAO( :, 3,11,16) = (/&
&5.7471E+00_JPRB,5.0288E+00_JPRB,5.0034E+00_JPRB,7.4970E+00_JPRB,9.9888E+00_JPRB,1.2472E+01_JPRB,&
&1.4942E+01_JPRB,1.7333E+01_JPRB,1.7821E+01_JPRB,2.0007E+01_JPRB/)
KAO( :, 4,11,16) = (/&
&7.2629E+00_JPRB,6.3550E+00_JPRB,7.0474E+00_JPRB,1.0566E+01_JPRB,1.4079E+01_JPRB,1.7584E+01_JPRB,&
&2.1057E+01_JPRB,2.4419E+01_JPRB,2.5019E+01_JPRB,2.8211E+01_JPRB/)
KAO( :, 5,11,16) = (/&
&8.9069E+00_JPRB,7.7936E+00_JPRB,9.5284E+00_JPRB,1.4286E+01_JPRB,1.9037E+01_JPRB,2.3771E+01_JPRB,&
&2.8468E+01_JPRB,3.3010E+01_JPRB,3.3751E+01_JPRB,3.8130E+01_JPRB/)
KAO( :, 1,12,16) = (/&
&3.3006E+00_JPRB,2.8881E+00_JPRB,2.8666E+00_JPRB,4.2985E+00_JPRB,5.7274E+00_JPRB,7.1506E+00_JPRB,&
&8.5607E+00_JPRB,9.9299E+00_JPRB,1.0097E+01_JPRB,1.1570E+01_JPRB/)
KAO( :, 2,12,16) = (/&
&4.5952E+00_JPRB,4.0208E+00_JPRB,4.1024E+00_JPRB,6.1511E+00_JPRB,8.1959E+00_JPRB,1.0235E+01_JPRB,&
&1.2254E+01_JPRB,1.4215E+01_JPRB,1.4558E+01_JPRB,1.6415E+01_JPRB/)
KAO( :, 3,12,16) = (/&
&6.1172E+00_JPRB,5.3526E+00_JPRB,5.9205E+00_JPRB,8.8783E+00_JPRB,1.1835E+01_JPRB,1.4781E+01_JPRB,&
&1.7706E+01_JPRB,2.0531E+01_JPRB,2.1114E+01_JPRB,2.3705E+01_JPRB/)
KAO( :, 4,12,16) = (/&
&7.9063E+00_JPRB,6.9180E+00_JPRB,8.3812E+00_JPRB,1.2566E+01_JPRB,1.6747E+01_JPRB,2.0915E+01_JPRB,&
&2.5049E+01_JPRB,2.9064E+01_JPRB,2.9820E+01_JPRB,3.3552E+01_JPRB/)
KAO( :, 5,12,16) = (/&
&9.9405E+00_JPRB,8.6980E+00_JPRB,1.1361E+01_JPRB,1.7034E+01_JPRB,2.2697E+01_JPRB,2.8347E+01_JPRB,&
&3.3936E+01_JPRB,3.9357E+01_JPRB,4.0377E+01_JPRB,4.5471E+01_JPRB/)
KAO( :, 1,13,16) = (/&
&3.5240E+00_JPRB,3.0835E+00_JPRB,3.4502E+00_JPRB,5.1734E+00_JPRB,6.8947E+00_JPRB,8.6091E+00_JPRB,&
&1.0310E+01_JPRB,1.1954E+01_JPRB,1.2187E+01_JPRB,1.3806E+01_JPRB/)
KAO( :, 2,13,16) = (/&
&5.0191E+00_JPRB,4.3917E+00_JPRB,4.8873E+00_JPRB,7.3276E+00_JPRB,9.7654E+00_JPRB,1.2194E+01_JPRB,&
&1.4608E+01_JPRB,1.6943E+01_JPRB,1.7366E+01_JPRB,1.9559E+01_JPRB/)
KAO( :, 3,13,16) = (/&
&6.8612E+00_JPRB,6.0035E+00_JPRB,6.9941E+00_JPRB,1.0486E+01_JPRB,1.3971E+01_JPRB,1.7446E+01_JPRB,&
&2.0896E+01_JPRB,2.4256E+01_JPRB,2.4993E+01_JPRB,2.7979E+01_JPRB/)
KAO( :, 4,13,16) = (/&
&8.9937E+00_JPRB,7.8713E+00_JPRB,9.9172E+00_JPRB,1.4874E+01_JPRB,1.9818E+01_JPRB,2.4754E+01_JPRB,&
&2.9642E+01_JPRB,3.4374E+01_JPRB,3.5407E+01_JPRB,3.9689E+01_JPRB/)
KAO( :, 5,13,16) = (/&
&1.1386E+01_JPRB,9.9632E+00_JPRB,1.3441E+01_JPRB,2.0157E+01_JPRB,2.6861E+01_JPRB,3.3545E+01_JPRB,&
&4.0165E+01_JPRB,4.6616E+01_JPRB,4.7981E+01_JPRB,5.3793E+01_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB3_A2
