!OCL SCALAR
SUBROUTINE RRTM_KGB3_A1

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 3:  500-630 cm-1 (low - H2O,CO2; high - H2O,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO3 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO  ,FORREFO    ,ABSN2OAO   ,ABSN2OBO
USE YOERRTA3 , ONLY : ABSN2OA ,ABSN2OB  ,ETAREF    ,H2OREF     ,&
           &N2OREF     ,CO2REF     ,STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE


!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different water vapor to CO2 ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = h2o/(h20 + (rat) * co2), where rat is the ratio of the integrated
!     line strength in the band of co2 to that of h2o.  For instance,
!     JS=1 refers to dry air (eta = 0), JS = 10 corresponds to eta = 1.0.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature
!     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 1) = (/&
&1.3905E-05_JPRB,5.5491E-04_JPRB,9.4069E-04_JPRB,1.2683E-03_JPRB,1.5758E-03_JPRB,1.8657E-03_JPRB,&
&2.1271E-03_JPRB,2.3310E-03_JPRB,2.2238E-03_JPRB,1.2098E-03_JPRB/)
KAO( :, 2, 1, 1) = (/&
&1.8718E-05_JPRB,6.2254E-04_JPRB,1.0419E-03_JPRB,1.3944E-03_JPRB,1.7096E-03_JPRB,2.0070E-03_JPRB,&
&2.2783E-03_JPRB,2.4921E-03_JPRB,2.4893E-03_JPRB,1.3329E-03_JPRB/)
KAO( :, 3, 1, 1) = (/&
&2.5277E-05_JPRB,7.0791E-04_JPRB,1.1679E-03_JPRB,1.5540E-03_JPRB,1.8826E-03_JPRB,2.1855E-03_JPRB,&
&2.4637E-03_JPRB,2.6836E-03_JPRB,2.4870E-03_JPRB,1.4683E-03_JPRB/)
KAO( :, 4, 1, 1) = (/&
&3.3974E-05_JPRB,8.1479E-04_JPRB,1.3277E-03_JPRB,1.7495E-03_JPRB,2.1019E-03_JPRB,2.4115E-03_JPRB,&
&2.6955E-03_JPRB,2.9144E-03_JPRB,2.6786E-03_JPRB,1.5835E-03_JPRB/)
KAO( :, 5, 1, 1) = (/&
&4.5018E-05_JPRB,9.4621E-04_JPRB,1.5225E-03_JPRB,1.9888E-03_JPRB,2.3735E-03_JPRB,2.6924E-03_JPRB,&
&2.9767E-03_JPRB,3.1904E-03_JPRB,2.9199E-03_JPRB,1.7196E-03_JPRB/)
KAO( :, 1, 2, 1) = (/&
&1.0592E-05_JPRB,4.4499E-04_JPRB,7.6480E-04_JPRB,1.0361E-03_JPRB,1.2851E-03_JPRB,1.5183E-03_JPRB,&
&1.7260E-03_JPRB,1.8861E-03_JPRB,1.7869E-03_JPRB,9.5189E-04_JPRB/)
KAO( :, 2, 2, 1) = (/&
&1.4233E-05_JPRB,4.9754E-04_JPRB,8.4386E-04_JPRB,1.1364E-03_JPRB,1.3930E-03_JPRB,1.6308E-03_JPRB,&
&1.8450E-03_JPRB,2.0088E-03_JPRB,1.9843E-03_JPRB,1.0406E-03_JPRB/)
KAO( :, 3, 2, 1) = (/&
&1.9306E-05_JPRB,5.6436E-04_JPRB,9.4285E-04_JPRB,1.2611E-03_JPRB,1.5318E-03_JPRB,1.7753E-03_JPRB,&
&1.9931E-03_JPRB,2.1588E-03_JPRB,2.0128E-03_JPRB,1.1498E-03_JPRB/)
KAO( :, 4, 2, 1) = (/&
&2.6119E-05_JPRB,6.4842E-04_JPRB,1.0680E-03_JPRB,1.4147E-03_JPRB,1.7071E-03_JPRB,1.9567E-03_JPRB,&
&2.1789E-03_JPRB,2.3401E-03_JPRB,2.1538E-03_JPRB,1.2358E-03_JPRB/)
KAO( :, 5, 2, 1) = (/&
&3.4871E-05_JPRB,7.5256E-04_JPRB,1.2221E-03_JPRB,1.6045E-03_JPRB,1.9204E-03_JPRB,2.1824E-03_JPRB,&
&2.4047E-03_JPRB,2.5599E-03_JPRB,2.3558E-03_JPRB,1.3458E-03_JPRB/)
KAO( :, 1, 3, 1) = (/&
&7.6650E-06_JPRB,3.4947E-04_JPRB,6.0867E-04_JPRB,8.3119E-04_JPRB,1.0323E-03_JPRB,1.2185E-03_JPRB,&
&1.3830E-03_JPRB,1.5087E-03_JPRB,1.4187E-03_JPRB,7.5325E-04_JPRB/)
KAO( :, 2, 3, 1) = (/&
&1.0208E-05_JPRB,3.8799E-04_JPRB,6.6727E-04_JPRB,9.0569E-04_JPRB,1.1140E-03_JPRB,1.3039E-03_JPRB,&
&1.4728E-03_JPRB,1.5994E-03_JPRB,1.5541E-03_JPRB,8.1826E-04_JPRB/)
KAO( :, 3, 3, 1) = (/&
&1.3852E-05_JPRB,4.3745E-04_JPRB,7.4132E-04_JPRB,9.9801E-04_JPRB,1.2192E-03_JPRB,1.4137E-03_JPRB,&
&1.5849E-03_JPRB,1.7123E-03_JPRB,1.6593E-03_JPRB,8.9528E-04_JPRB/)
KAO( :, 4, 3, 1) = (/&
&1.8873E-05_JPRB,5.0084E-04_JPRB,8.3488E-04_JPRB,1.1136E-03_JPRB,1.3505E-03_JPRB,1.5529E-03_JPRB,&
&1.7249E-03_JPRB,1.8487E-03_JPRB,1.7141E-03_JPRB,9.6472E-04_JPRB/)
KAO( :, 5, 3, 1) = (/&
&2.5412E-05_JPRB,5.7989E-04_JPRB,9.5083E-04_JPRB,1.2577E-03_JPRB,1.5110E-03_JPRB,1.7265E-03_JPRB,&
&1.9001E-03_JPRB,2.0154E-03_JPRB,1.8592E-03_JPRB,1.0514E-03_JPRB/)
KAO( :, 1, 4, 1) = (/&
&5.5327E-06_JPRB,2.7370E-04_JPRB,4.8202E-04_JPRB,6.6293E-04_JPRB,8.2705E-04_JPRB,9.7621E-04_JPRB,&
&1.1071E-03_JPRB,1.2149E-03_JPRB,1.1365E-03_JPRB,6.2235E-04_JPRB/)
KAO( :, 2, 4, 1) = (/&
&7.2381E-06_JPRB,3.0138E-04_JPRB,5.2416E-04_JPRB,7.1697E-04_JPRB,8.8620E-04_JPRB,1.0391E-03_JPRB,&
&1.1730E-03_JPRB,1.2726E-03_JPRB,1.2113E-03_JPRB,6.7320E-04_JPRB/)
KAO( :, 3, 4, 1) = (/&
&9.7698E-06_JPRB,3.3721E-04_JPRB,5.7856E-04_JPRB,7.8512E-04_JPRB,9.6459E-04_JPRB,1.1210E-03_JPRB,&
&1.2565E-03_JPRB,1.3549E-03_JPRB,1.3452E-03_JPRB,7.2416E-04_JPRB/)
KAO( :, 4, 4, 1) = (/&
&1.3344E-05_JPRB,3.8381E-04_JPRB,6.4739E-04_JPRB,8.7038E-04_JPRB,1.0615E-03_JPRB,1.2252E-03_JPRB,&
&1.3612E-03_JPRB,1.4576E-03_JPRB,1.3655E-03_JPRB,7.8325E-04_JPRB/)
KAO( :, 5, 4, 1) = (/&
&1.8090E-05_JPRB,4.4258E-04_JPRB,7.3288E-04_JPRB,9.7754E-04_JPRB,1.1813E-03_JPRB,1.3549E-03_JPRB,&
&1.4926E-03_JPRB,1.5822E-03_JPRB,1.4607E-03_JPRB,8.5221E-04_JPRB/)
KAO( :, 1, 5, 1) = (/&
&4.0810E-06_JPRB,2.1551E-04_JPRB,3.8283E-04_JPRB,5.2940E-04_JPRB,6.6368E-04_JPRB,7.8503E-04_JPRB,&
&8.8897E-04_JPRB,9.7870E-04_JPRB,9.2885E-04_JPRB,5.3112E-04_JPRB/)
KAO( :, 2, 5, 1) = (/&
&5.1916E-06_JPRB,2.3507E-04_JPRB,4.1271E-04_JPRB,5.6826E-04_JPRB,7.0568E-04_JPRB,8.2971E-04_JPRB,&
&9.3695E-04_JPRB,1.0168E-03_JPRB,9.5220E-04_JPRB,5.6840E-04_JPRB/)
KAO( :, 3, 5, 1) = (/&
&6.9159E-06_JPRB,2.6088E-04_JPRB,4.5208E-04_JPRB,6.1797E-04_JPRB,7.6301E-04_JPRB,8.8979E-04_JPRB,&
&9.9853E-04_JPRB,1.0759E-03_JPRB,1.0389E-03_JPRB,6.0777E-04_JPRB/)
KAO( :, 4, 5, 1) = (/&
&9.4196E-06_JPRB,2.9480E-04_JPRB,5.0274E-04_JPRB,6.8088E-04_JPRB,8.3550E-04_JPRB,9.6746E-04_JPRB,&
&1.0764E-03_JPRB,1.1522E-03_JPRB,1.1313E-03_JPRB,6.5577E-04_JPRB/)
KAO( :, 5, 5, 1) = (/&
&1.2823E-05_JPRB,3.3834E-04_JPRB,5.6555E-04_JPRB,7.6000E-04_JPRB,9.2459E-04_JPRB,1.0640E-03_JPRB,&
&1.1745E-03_JPRB,1.2456E-03_JPRB,1.1599E-03_JPRB,7.1205E-04_JPRB/)
KAO( :, 1, 6, 1) = (/&
&3.0745E-06_JPRB,1.7028E-04_JPRB,3.0467E-04_JPRB,4.2351E-04_JPRB,5.3324E-04_JPRB,6.3166E-04_JPRB,&
&7.1362E-04_JPRB,7.7595E-04_JPRB,7.2555E-04_JPRB,4.6766E-04_JPRB/)
KAO( :, 2, 6, 1) = (/&
&3.7467E-06_JPRB,1.8364E-04_JPRB,3.2533E-04_JPRB,4.4992E-04_JPRB,5.6174E-04_JPRB,6.6289E-04_JPRB,&
&7.4918E-04_JPRB,8.1992E-04_JPRB,7.7217E-04_JPRB,4.9540E-04_JPRB/)
KAO( :, 3, 6, 1) = (/&
&4.8844E-06_JPRB,2.0189E-04_JPRB,3.5318E-04_JPRB,4.8611E-04_JPRB,6.0248E-04_JPRB,7.0548E-04_JPRB,&
&7.9343E-04_JPRB,8.5556E-04_JPRB,8.1719E-04_JPRB,5.2871E-04_JPRB/)
KAO( :, 4, 6, 1) = (/&
&6.5875E-06_JPRB,2.2623E-04_JPRB,3.8987E-04_JPRB,5.3174E-04_JPRB,6.5615E-04_JPRB,7.6255E-04_JPRB,&
&8.5105E-04_JPRB,9.1164E-04_JPRB,9.0776E-04_JPRB,5.6738E-04_JPRB/)
KAO( :, 5, 6, 1) = (/&
&8.9782E-06_JPRB,2.5797E-04_JPRB,4.3574E-04_JPRB,5.8945E-04_JPRB,7.2180E-04_JPRB,8.3401E-04_JPRB,&
&9.2288E-04_JPRB,9.8059E-04_JPRB,9.2715E-04_JPRB,6.1340E-04_JPRB/)
KAO( :, 1, 7, 1) = (/&
&2.3852E-06_JPRB,1.3537E-04_JPRB,2.4376E-04_JPRB,3.4046E-04_JPRB,4.2953E-04_JPRB,5.0877E-04_JPRB,&
&5.7353E-04_JPRB,6.1192E-04_JPRB,5.7270E-04_JPRB,4.3319E-04_JPRB/)
KAO( :, 2, 7, 1) = (/&
&2.7620E-06_JPRB,1.4429E-04_JPRB,2.5761E-04_JPRB,3.5752E-04_JPRB,4.4861E-04_JPRB,5.3102E-04_JPRB,&
&5.9966E-04_JPRB,6.5817E-04_JPRB,6.2541E-04_JPRB,4.5750E-04_JPRB/)
KAO( :, 3, 7, 1) = (/&
&3.4880E-06_JPRB,1.5701E-04_JPRB,2.7701E-04_JPRB,3.8344E-04_JPRB,4.7691E-04_JPRB,5.6092E-04_JPRB,&
&6.3220E-04_JPRB,6.8391E-04_JPRB,6.4333E-04_JPRB,4.8664E-04_JPRB/)
KAO( :, 4, 7, 1) = (/&
&4.6192E-06_JPRB,1.7428E-04_JPRB,3.0330E-04_JPRB,4.1640E-04_JPRB,5.1608E-04_JPRB,6.0192E-04_JPRB,&
&6.7387E-04_JPRB,7.2302E-04_JPRB,7.0029E-04_JPRB,5.2115E-04_JPRB/)
KAO( :, 5, 7, 1) = (/&
&6.2659E-06_JPRB,1.9723E-04_JPRB,3.3668E-04_JPRB,4.5828E-04_JPRB,5.6442E-04_JPRB,6.5465E-04_JPRB,&
&7.2699E-04_JPRB,7.7405E-04_JPRB,7.7413E-04_JPRB,5.6002E-04_JPRB/)
KAO( :, 1, 8, 1) = (/&
&1.9015E-06_JPRB,1.0820E-04_JPRB,1.9592E-04_JPRB,2.7484E-04_JPRB,3.4688E-04_JPRB,4.0988E-04_JPRB,&
&4.6037E-04_JPRB,4.8747E-04_JPRB,4.5723E-04_JPRB,4.3074E-04_JPRB/)
KAO( :, 2, 8, 1) = (/&
&2.0897E-06_JPRB,1.1410E-04_JPRB,2.0489E-04_JPRB,2.8543E-04_JPRB,3.5954E-04_JPRB,4.2599E-04_JPRB,&
&4.8075E-04_JPRB,5.2102E-04_JPRB,4.8940E-04_JPRB,4.6091E-04_JPRB/)
KAO( :, 3, 8, 1) = (/&
&2.5320E-06_JPRB,1.2277E-04_JPRB,2.1834E-04_JPRB,3.0321E-04_JPRB,3.7874E-04_JPRB,4.4717E-04_JPRB,&
&5.0489E-04_JPRB,5.5180E-04_JPRB,5.2338E-04_JPRB,4.9080E-04_JPRB/)
KAO( :, 4, 8, 1) = (/&
&3.2727E-06_JPRB,1.3498E-04_JPRB,2.3690E-04_JPRB,3.2720E-04_JPRB,4.0672E-04_JPRB,4.7636E-04_JPRB,&
&5.3491E-04_JPRB,5.7561E-04_JPRB,5.5051E-04_JPRB,5.1978E-04_JPRB/)
KAO( :, 5, 8, 1) = (/&
&4.3856E-06_JPRB,1.5147E-04_JPRB,2.6111E-04_JPRB,3.5765E-04_JPRB,4.4264E-04_JPRB,5.1502E-04_JPRB,&
&5.7382E-04_JPRB,6.1302E-04_JPRB,6.1438E-04_JPRB,5.4976E-04_JPRB/)
KAO( :, 1, 9, 1) = (/&
&1.5482E-06_JPRB,8.7052E-05_JPRB,1.5839E-04_JPRB,2.2300E-04_JPRB,2.8105E-04_JPRB,3.3090E-04_JPRB,&
&3.6936E-04_JPRB,3.8992E-04_JPRB,3.6561E-04_JPRB,5.0307E-04_JPRB/)
KAO( :, 2, 9, 1) = (/&
&1.6233E-06_JPRB,9.0800E-05_JPRB,1.6386E-04_JPRB,2.2916E-04_JPRB,2.8933E-04_JPRB,3.4270E-04_JPRB,&
&3.8603E-04_JPRB,4.1137E-04_JPRB,3.8679E-04_JPRB,5.3034E-04_JPRB/)
KAO( :, 3, 9, 1) = (/&
&1.8727E-06_JPRB,9.6605E-05_JPRB,1.7299E-04_JPRB,2.4068E-04_JPRB,3.0216E-04_JPRB,3.5768E-04_JPRB,&
&4.0386E-04_JPRB,4.4306E-04_JPRB,4.2523E-04_JPRB,5.5823E-04_JPRB/)
KAO( :, 4, 9, 1) = (/&
&2.3460E-06_JPRB,1.0514E-04_JPRB,1.8594E-04_JPRB,2.5798E-04_JPRB,3.2158E-04_JPRB,3.7830E-04_JPRB,&
&4.2604E-04_JPRB,4.6061E-04_JPRB,4.3830E-04_JPRB,5.8904E-04_JPRB/)
KAO( :, 5, 9, 1) = (/&
&3.0835E-06_JPRB,1.1691E-04_JPRB,2.0336E-04_JPRB,2.8015E-04_JPRB,3.4814E-04_JPRB,4.0638E-04_JPRB,&
&4.5421E-04_JPRB,4.8658E-04_JPRB,4.7615E-04_JPRB,6.2435E-04_JPRB/)
KAO( :, 1,10, 1) = (/&
&1.2799E-06_JPRB,7.0646E-05_JPRB,1.2898E-04_JPRB,1.8180E-04_JPRB,2.2870E-04_JPRB,2.6728E-04_JPRB,&
&2.9678E-04_JPRB,3.1565E-04_JPRB,2.9877E-04_JPRB,5.6519E-04_JPRB/)
KAO( :, 2,10, 1) = (/&
&1.2987E-06_JPRB,7.2906E-05_JPRB,1.3215E-04_JPRB,1.8535E-04_JPRB,2.3421E-04_JPRB,2.7695E-04_JPRB,&
&3.1130E-04_JPRB,3.2886E-04_JPRB,3.1021E-04_JPRB,5.8706E-04_JPRB/)
KAO( :, 3,10, 1) = (/&
&1.4353E-06_JPRB,7.6915E-05_JPRB,1.3835E-04_JPRB,1.9290E-04_JPRB,2.4295E-04_JPRB,2.8803E-04_JPRB,&
&3.2514E-04_JPRB,3.5354E-04_JPRB,3.3578E-04_JPRB,6.1412E-04_JPRB/)
KAO( :, 4,10, 1) = (/&
&1.7387E-06_JPRB,8.2894E-05_JPRB,1.4759E-04_JPRB,2.0528E-04_JPRB,2.5663E-04_JPRB,3.0293E-04_JPRB,&
&3.4175E-04_JPRB,3.7216E-04_JPRB,3.5751E-04_JPRB,6.4985E-04_JPRB/)
KAO( :, 5,10, 1) = (/&
&2.2343E-06_JPRB,9.1469E-05_JPRB,1.6022E-04_JPRB,2.2168E-04_JPRB,2.7630E-04_JPRB,3.2346E-04_JPRB,&
&3.6268E-04_JPRB,3.8938E-04_JPRB,3.7492E-04_JPRB,6.9583E-04_JPRB/)
KAO( :, 1,11, 1) = (/&
&1.0543E-06_JPRB,5.7983E-05_JPRB,1.0582E-04_JPRB,1.4919E-04_JPRB,1.8791E-04_JPRB,2.2000E-04_JPRB,&
&2.4433E-04_JPRB,2.5995E-04_JPRB,2.4592E-04_JPRB,5.0307E-04_JPRB/)
KAO( :, 2,11, 1) = (/&
&1.0726E-06_JPRB,5.9907E-05_JPRB,1.0858E-04_JPRB,1.5223E-04_JPRB,1.9244E-04_JPRB,2.2775E-04_JPRB,&
&2.5610E-04_JPRB,2.7046E-04_JPRB,2.5615E-04_JPRB,5.1588E-04_JPRB/)
KAO( :, 3,11, 1) = (/&
&1.1894E-06_JPRB,6.3212E-05_JPRB,1.1383E-04_JPRB,1.5870E-04_JPRB,1.9979E-04_JPRB,2.3693E-04_JPRB,&
&2.6747E-04_JPRB,2.9154E-04_JPRB,2.7919E-04_JPRB,5.3855E-04_JPRB/)
KAO( :, 4,11, 1) = (/&
&1.4390E-06_JPRB,6.8258E-05_JPRB,1.2145E-04_JPRB,1.6906E-04_JPRB,2.1138E-04_JPRB,2.4948E-04_JPRB,&
&2.8136E-04_JPRB,3.0581E-04_JPRB,2.9553E-04_JPRB,5.7296E-04_JPRB/)
KAO( :, 5,11, 1) = (/&
&1.8470E-06_JPRB,7.5489E-05_JPRB,1.3202E-04_JPRB,1.8257E-04_JPRB,2.2782E-04_JPRB,2.6681E-04_JPRB,&
&2.9892E-04_JPRB,3.2058E-04_JPRB,3.1052E-04_JPRB,6.1818E-04_JPRB/)
KAO( :, 1,12, 1) = (/&
&8.6798E-07_JPRB,4.7553E-05_JPRB,8.6730E-05_JPRB,1.2226E-04_JPRB,1.5413E-04_JPRB,1.8085E-04_JPRB,&
&2.0088E-04_JPRB,2.1368E-04_JPRB,2.0252E-04_JPRB,4.1925E-04_JPRB/)
KAO( :, 2,12, 1) = (/&
&8.8495E-07_JPRB,4.9183E-05_JPRB,8.9118E-05_JPRB,1.2490E-04_JPRB,1.5790E-04_JPRB,1.8699E-04_JPRB,&
&2.1049E-04_JPRB,2.2231E-04_JPRB,2.1170E-04_JPRB,4.2911E-04_JPRB/)
KAO( :, 3,12, 1) = (/&
&9.8325E-07_JPRB,5.1925E-05_JPRB,9.3547E-05_JPRB,1.3044E-04_JPRB,1.6413E-04_JPRB,1.9471E-04_JPRB,&
&2.1986E-04_JPRB,2.4001E-04_JPRB,2.3209E-04_JPRB,4.4871E-04_JPRB/)
KAO( :, 4,12, 1) = (/&
&1.1889E-06_JPRB,5.6183E-05_JPRB,9.9863E-05_JPRB,1.3905E-04_JPRB,1.7391E-04_JPRB,2.0522E-04_JPRB,&
&2.3142E-04_JPRB,2.5135E-04_JPRB,2.4267E-04_JPRB,4.7818E-04_JPRB/)
KAO( :, 5,12, 1) = (/&
&1.5235E-06_JPRB,6.2281E-05_JPRB,1.0874E-04_JPRB,1.5023E-04_JPRB,1.8755E-04_JPRB,2.1980E-04_JPRB,&
&2.4617E-04_JPRB,2.6379E-04_JPRB,2.5784E-04_JPRB,5.1708E-04_JPRB/)
KAO( :, 1,13, 1) = (/&
&7.1418E-07_JPRB,3.8921E-05_JPRB,7.0891E-05_JPRB,9.9889E-05_JPRB,1.2597E-04_JPRB,1.4799E-04_JPRB,&
&1.6453E-04_JPRB,1.7513E-04_JPRB,1.6667E-04_JPRB,3.4309E-04_JPRB/)
KAO( :, 2,13, 1) = (/&
&7.2895E-07_JPRB,4.0284E-05_JPRB,7.2945E-05_JPRB,1.0221E-04_JPRB,1.2923E-04_JPRB,1.5309E-04_JPRB,&
&1.7258E-04_JPRB,1.8229E-04_JPRB,1.7386E-04_JPRB,3.5109E-04_JPRB/)
KAO( :, 3,13, 1) = (/&
&8.1079E-07_JPRB,4.2576E-05_JPRB,7.6659E-05_JPRB,1.0692E-04_JPRB,1.3449E-04_JPRB,1.5961E-04_JPRB,&
&1.8026E-04_JPRB,1.9704E-04_JPRB,1.9240E-04_JPRB,3.6700E-04_JPRB/)
KAO( :, 4,13, 1) = (/&
&9.8001E-07_JPRB,4.6149E-05_JPRB,8.1932E-05_JPRB,1.1406E-04_JPRB,1.4271E-04_JPRB,1.6841E-04_JPRB,&
&1.8992E-04_JPRB,2.0617E-04_JPRB,1.9928E-04_JPRB,3.9092E-04_JPRB/)
KAO( :, 5,13, 1) = (/&
&1.2528E-06_JPRB,5.1280E-05_JPRB,8.9359E-05_JPRB,1.2338E-04_JPRB,1.5401E-04_JPRB,1.8056E-04_JPRB,&
&2.0225E-04_JPRB,2.1672E-04_JPRB,2.1360E-04_JPRB,4.2252E-04_JPRB/)
KAO( :, 1, 1, 2) = (/&
&6.1207E-05_JPRB,1.0978E-03_JPRB,1.7611E-03_JPRB,2.3638E-03_JPRB,2.9057E-03_JPRB,3.3651E-03_JPRB,&
&3.7137E-03_JPRB,3.8383E-03_JPRB,3.2297E-03_JPRB,2.4264E-03_JPRB/)
KAO( :, 2, 1, 2) = (/&
&8.5058E-05_JPRB,1.3292E-03_JPRB,2.0750E-03_JPRB,2.7338E-03_JPRB,3.3403E-03_JPRB,3.8629E-03_JPRB,&
&4.2579E-03_JPRB,4.3337E-03_JPRB,3.4101E-03_JPRB,2.6736E-03_JPRB/)
KAO( :, 3, 1, 2) = (/&
&1.1682E-04_JPRB,1.6162E-03_JPRB,2.4689E-03_JPRB,3.1946E-03_JPRB,3.8719E-03_JPRB,4.4552E-03_JPRB,&
&4.9076E-03_JPRB,4.9335E-03_JPRB,3.9022E-03_JPRB,2.9247E-03_JPRB/)
KAO( :, 4, 1, 2) = (/&
&1.5789E-04_JPRB,1.9668E-03_JPRB,2.9480E-03_JPRB,3.7669E-03_JPRB,4.5171E-03_JPRB,5.1682E-03_JPRB,&
&5.6653E-03_JPRB,5.6499E-03_JPRB,4.0652E-03_JPRB,3.1515E-03_JPRB/)
KAO( :, 5, 1, 2) = (/&
&2.0990E-04_JPRB,2.3887E-03_JPRB,3.5299E-03_JPRB,4.4565E-03_JPRB,5.2844E-03_JPRB,6.0076E-03_JPRB,&
&6.5551E-03_JPRB,6.4764E-03_JPRB,4.4385E-03_JPRB,3.4538E-03_JPRB/)
KAO( :, 1, 2, 2) = (/&
&4.6541E-05_JPRB,8.8674E-04_JPRB,1.4099E-03_JPRB,1.8864E-03_JPRB,2.3180E-03_JPRB,2.6798E-03_JPRB,&
&2.9613E-03_JPRB,3.0615E-03_JPRB,2.6597E-03_JPRB,1.8872E-03_JPRB/)
KAO( :, 2, 2, 2) = (/&
&6.5339E-05_JPRB,1.0747E-03_JPRB,1.6670E-03_JPRB,2.1855E-03_JPRB,2.6622E-03_JPRB,3.0710E-03_JPRB,&
&3.3862E-03_JPRB,3.4584E-03_JPRB,2.7852E-03_JPRB,2.0782E-03_JPRB/)
KAO( :, 3, 2, 2) = (/&
&9.0589E-05_JPRB,1.3082E-03_JPRB,1.9947E-03_JPRB,2.5634E-03_JPRB,3.0860E-03_JPRB,3.5379E-03_JPRB,&
&3.8975E-03_JPRB,3.9366E-03_JPRB,3.1668E-03_JPRB,2.2590E-03_JPRB/)
KAO( :, 4, 2, 2) = (/&
&1.2385E-04_JPRB,1.5968E-03_JPRB,2.3941E-03_JPRB,3.0350E-03_JPRB,3.6067E-03_JPRB,4.1057E-03_JPRB,&
&4.4942E-03_JPRB,4.5107E-03_JPRB,3.2782E-03_JPRB,2.4504E-03_JPRB/)
KAO( :, 5, 2, 2) = (/&
&1.6667E-04_JPRB,1.9480E-03_JPRB,2.8786E-03_JPRB,3.6064E-03_JPRB,4.2370E-03_JPRB,4.7805E-03_JPRB,&
&5.2024E-03_JPRB,5.1677E-03_JPRB,3.5425E-03_JPRB,2.6975E-03_JPRB/)
KAO( :, 1, 3, 2) = (/&
&3.2922E-05_JPRB,6.8654E-04_JPRB,1.0970E-03_JPRB,1.4654E-03_JPRB,1.8051E-03_JPRB,2.0847E-03_JPRB,&
&2.3088E-03_JPRB,2.3837E-03_JPRB,2.1265E-03_JPRB,1.4540E-03_JPRB/)
KAO( :, 2, 3, 2) = (/&
&4.6583E-05_JPRB,8.3015E-04_JPRB,1.2948E-03_JPRB,1.6958E-03_JPRB,2.0663E-03_JPRB,2.3792E-03_JPRB,&
&2.6229E-03_JPRB,2.6951E-03_JPRB,2.2518E-03_JPRB,1.5969E-03_JPRB/)
KAO( :, 3, 3, 2) = (/&
&6.5410E-05_JPRB,1.0114E-03_JPRB,1.5518E-03_JPRB,1.9919E-03_JPRB,2.3944E-03_JPRB,2.7366E-03_JPRB,&
&3.0098E-03_JPRB,3.0595E-03_JPRB,2.4530E-03_JPRB,1.7299E-03_JPRB/)
KAO( :, 4, 3, 2) = (/&
&9.0734E-05_JPRB,1.2366E-03_JPRB,1.8688E-03_JPRB,2.3652E-03_JPRB,2.8005E-03_JPRB,3.1725E-03_JPRB,&
&3.4706E-03_JPRB,3.5000E-03_JPRB,2.6641E-03_JPRB,1.8912E-03_JPRB/)
KAO( :, 5, 3, 2) = (/&
&1.2407E-04_JPRB,1.5126E-03_JPRB,2.2510E-03_JPRB,2.8211E-03_JPRB,3.2989E-03_JPRB,3.7001E-03_JPRB,&
&4.0161E-03_JPRB,4.0075E-03_JPRB,2.7798E-03_JPRB,2.0796E-03_JPRB/)
KAO( :, 1, 4, 2) = (/&
&2.2778E-05_JPRB,5.2510E-04_JPRB,8.4888E-04_JPRB,1.1352E-03_JPRB,1.3979E-03_JPRB,1.6168E-03_JPRB,&
&1.7964E-03_JPRB,1.8331E-03_JPRB,1.7837E-03_JPRB,1.1723E-03_JPRB/)
KAO( :, 2, 4, 2) = (/&
&3.2363E-05_JPRB,6.3086E-04_JPRB,9.9709E-04_JPRB,1.3073E-03_JPRB,1.5943E-03_JPRB,1.8366E-03_JPRB,&
&2.0244E-03_JPRB,2.0875E-03_JPRB,1.8124E-03_JPRB,1.2732E-03_JPRB/)
KAO( :, 3, 4, 2) = (/&
&4.5962E-05_JPRB,7.6788E-04_JPRB,1.1912E-03_JPRB,1.5347E-03_JPRB,1.8433E-03_JPRB,2.1077E-03_JPRB,&
&2.3135E-03_JPRB,2.3586E-03_JPRB,1.8966E-03_JPRB,1.3806E-03_JPRB/)
KAO( :, 4, 4, 2) = (/&
&6.4739E-05_JPRB,9.3992E-04_JPRB,1.4352E-03_JPRB,1.8248E-03_JPRB,2.1580E-03_JPRB,2.4403E-03_JPRB,&
&2.6639E-03_JPRB,2.6893E-03_JPRB,2.1413E-03_JPRB,1.4999E-03_JPRB/)
KAO( :, 5, 4, 2) = (/&
&9.0009E-05_JPRB,1.1535E-03_JPRB,1.7330E-03_JPRB,2.1811E-03_JPRB,2.5487E-03_JPRB,2.8464E-03_JPRB,&
&3.0813E-03_JPRB,3.0811E-03_JPRB,2.2013E-03_JPRB,1.6370E-03_JPRB/)
KAO( :, 1, 5, 2) = (/&
&1.5792E-05_JPRB,4.0148E-04_JPRB,6.5831E-04_JPRB,8.8434E-04_JPRB,1.0869E-03_JPRB,1.2568E-03_JPRB,&
&1.4030E-03_JPRB,1.4157E-03_JPRB,1.3790E-03_JPRB,9.9471E-04_JPRB/)
KAO( :, 2, 5, 2) = (/&
&2.2397E-05_JPRB,4.7887E-04_JPRB,7.6705E-04_JPRB,1.0113E-03_JPRB,1.2329E-03_JPRB,1.4202E-03_JPRB,&
&1.5687E-03_JPRB,1.6184E-03_JPRB,1.4582E-03_JPRB,1.0698E-03_JPRB/)
KAO( :, 3, 5, 2) = (/&
&3.2096E-05_JPRB,5.8078E-04_JPRB,9.1183E-04_JPRB,1.1823E-03_JPRB,1.4221E-03_JPRB,1.6260E-03_JPRB,&
&1.7823E-03_JPRB,1.8208E-03_JPRB,1.5493E-03_JPRB,1.1486E-03_JPRB/)
KAO( :, 4, 5, 2) = (/&
&4.5840E-05_JPRB,7.1160E-04_JPRB,1.0969E-03_JPRB,1.4034E-03_JPRB,1.6628E-03_JPRB,1.8804E-03_JPRB,&
&2.0470E-03_JPRB,2.0686E-03_JPRB,1.6540E-03_JPRB,1.2365E-03_JPRB/)
KAO( :, 5, 5, 2) = (/&
&6.4822E-05_JPRB,8.7496E-04_JPRB,1.3269E-03_JPRB,1.6793E-03_JPRB,1.9658E-03_JPRB,2.1946E-03_JPRB,&
&2.3671E-03_JPRB,2.3677E-03_JPRB,1.7812E-03_JPRB,1.3376E-03_JPRB/)
KAO( :, 1, 6, 2) = (/&
&1.0902E-05_JPRB,3.0605E-04_JPRB,5.1028E-04_JPRB,6.8853E-04_JPRB,8.4488E-04_JPRB,9.7840E-04_JPRB,&
&1.0974E-03_JPRB,1.1101E-03_JPRB,1.0645E-03_JPRB,8.6648E-04_JPRB/)
KAO( :, 2, 6, 2) = (/&
&1.5301E-05_JPRB,3.6130E-04_JPRB,5.8719E-04_JPRB,7.8079E-04_JPRB,9.5252E-04_JPRB,1.0959E-03_JPRB,&
&1.2152E-03_JPRB,1.2397E-03_JPRB,1.2046E-03_JPRB,9.1885E-04_JPRB/)
KAO( :, 3, 6, 2) = (/&
&2.2016E-05_JPRB,4.3548E-04_JPRB,6.9267E-04_JPRB,9.0511E-04_JPRB,1.0924E-03_JPRB,1.2498E-03_JPRB,&
&1.3720E-03_JPRB,1.4053E-03_JPRB,1.2319E-03_JPRB,9.7396E-04_JPRB/)
KAO( :, 4, 6, 2) = (/&
&3.1830E-05_JPRB,5.3317E-04_JPRB,8.3063E-04_JPRB,1.0698E-03_JPRB,1.2734E-03_JPRB,1.4418E-03_JPRB,&
&1.5687E-03_JPRB,1.5881E-03_JPRB,1.2775E-03_JPRB,1.0399E-03_JPRB/)
KAO( :, 5, 6, 2) = (/&
&4.5738E-05_JPRB,6.5696E-04_JPRB,1.0039E-03_JPRB,1.2790E-03_JPRB,1.5021E-03_JPRB,1.6812E-03_JPRB,&
&1.8119E-03_JPRB,1.8117E-03_JPRB,1.4274E-03_JPRB,1.1156E-03_JPRB/)
KAO( :, 1, 7, 2) = (/&
&7.6369E-06_JPRB,2.3409E-04_JPRB,3.9662E-04_JPRB,5.3736E-04_JPRB,6.5954E-04_JPRB,7.6628E-04_JPRB,&
&8.6324E-04_JPRB,8.8119E-04_JPRB,8.6194E-04_JPRB,7.9079E-04_JPRB/)
KAO( :, 2, 7, 2) = (/&
&1.0494E-05_JPRB,2.7293E-04_JPRB,4.5033E-04_JPRB,6.0419E-04_JPRB,7.3771E-04_JPRB,8.4846E-04_JPRB,&
&9.4512E-04_JPRB,9.5497E-04_JPRB,9.2999E-04_JPRB,8.2387E-04_JPRB/)
KAO( :, 3, 7, 2) = (/&
&1.5059E-05_JPRB,3.2612E-04_JPRB,5.2570E-04_JPRB,6.9285E-04_JPRB,8.4056E-04_JPRB,9.6214E-04_JPRB,&
&1.0579E-03_JPRB,1.0868E-03_JPRB,9.8600E-04_JPRB,8.6421E-04_JPRB/)
KAO( :, 4, 7, 2) = (/&
&2.1973E-05_JPRB,3.9766E-04_JPRB,6.2716E-04_JPRB,8.1307E-04_JPRB,9.7314E-04_JPRB,1.1062E-03_JPRB,&
&1.2052E-03_JPRB,1.2224E-03_JPRB,1.0473E-03_JPRB,9.1386E-04_JPRB/)
KAO( :, 5, 7, 2) = (/&
&3.2024E-05_JPRB,4.9023E-04_JPRB,7.5693E-04_JPRB,9.6942E-04_JPRB,1.1441E-03_JPRB,1.2861E-03_JPRB,&
&1.3873E-03_JPRB,1.3904E-03_JPRB,1.0995E-03_JPRB,9.7409E-04_JPRB/)
KAO( :, 1, 8, 2) = (/&
&5.4819E-06_JPRB,1.8022E-04_JPRB,3.0951E-04_JPRB,4.2109E-04_JPRB,5.1765E-04_JPRB,6.0434E-04_JPRB,&
&6.7966E-04_JPRB,7.0414E-04_JPRB,7.0729E-04_JPRB,7.6543E-04_JPRB/)
KAO( :, 2, 8, 2) = (/&
&7.2946E-06_JPRB,2.0689E-04_JPRB,3.4673E-04_JPRB,4.6841E-04_JPRB,5.7263E-04_JPRB,6.6046E-04_JPRB,&
&7.3949E-04_JPRB,7.4887E-04_JPRB,7.2137E-04_JPRB,7.8512E-04_JPRB/)
KAO( :, 3, 8, 2) = (/&
&1.0351E-05_JPRB,2.4457E-04_JPRB,3.9988E-04_JPRB,5.3188E-04_JPRB,6.4791E-04_JPRB,7.4247E-04_JPRB,&
&8.1941E-04_JPRB,8.3495E-04_JPRB,8.1545E-04_JPRB,8.2107E-04_JPRB/)
KAO( :, 4, 8, 2) = (/&
&1.5156E-05_JPRB,2.9629E-04_JPRB,4.7365E-04_JPRB,6.1873E-04_JPRB,7.4454E-04_JPRB,8.4958E-04_JPRB,&
&9.2854E-04_JPRB,9.4393E-04_JPRB,8.3940E-04_JPRB,8.7281E-04_JPRB/)
KAO( :, 5, 8, 2) = (/&
&2.2361E-05_JPRB,3.6482E-04_JPRB,5.6983E-04_JPRB,7.3407E-04_JPRB,8.7045E-04_JPRB,9.8366E-04_JPRB,&
&1.0651E-03_JPRB,1.0698E-03_JPRB,8.6698E-04_JPRB,9.3613E-04_JPRB/)
KAO( :, 1, 9, 2) = (/&
&4.0452E-06_JPRB,1.4017E-04_JPRB,2.4329E-04_JPRB,3.3218E-04_JPRB,4.0925E-04_JPRB,4.8103E-04_JPRB,&
&5.3918E-04_JPRB,5.6100E-04_JPRB,5.6501E-04_JPRB,8.0970E-04_JPRB/)
KAO( :, 2, 9, 2) = (/&
&5.1567E-06_JPRB,1.5795E-04_JPRB,2.6863E-04_JPRB,3.6500E-04_JPRB,4.4688E-04_JPRB,5.1756E-04_JPRB,&
&5.8306E-04_JPRB,5.9423E-04_JPRB,5.8894E-04_JPRB,8.6646E-04_JPRB/)
KAO( :, 3, 9, 2) = (/&
&7.1657E-06_JPRB,1.8427E-04_JPRB,3.0563E-04_JPRB,4.1026E-04_JPRB,5.0076E-04_JPRB,5.7510E-04_JPRB,&
&6.3796E-04_JPRB,6.4416E-04_JPRB,6.2814E-04_JPRB,9.4589E-04_JPRB/)
KAO( :, 4, 9, 2) = (/&
&1.0454E-05_JPRB,2.2117E-04_JPRB,3.5855E-04_JPRB,4.7222E-04_JPRB,5.7137E-04_JPRB,6.5350E-04_JPRB,&
&7.1676E-04_JPRB,7.3182E-04_JPRB,6.7180E-04_JPRB,1.0445E-03_JPRB/)
KAO( :, 5, 9, 2) = (/&
&1.5554E-05_JPRB,2.7129E-04_JPRB,4.2902E-04_JPRB,5.5622E-04_JPRB,6.6296E-04_JPRB,7.5220E-04_JPRB,&
&8.1926E-04_JPRB,8.2534E-04_JPRB,7.1317E-04_JPRB,1.1567E-03_JPRB/)
KAO( :, 1,10, 2) = (/&
&3.1057E-06_JPRB,1.1083E-04_JPRB,1.9379E-04_JPRB,2.6511E-04_JPRB,3.2793E-04_JPRB,3.8622E-04_JPRB,&
&4.3071E-04_JPRB,4.4441E-04_JPRB,4.5952E-04_JPRB,8.8174E-04_JPRB/)
KAO( :, 2,10, 2) = (/&
&3.7991E-06_JPRB,1.2283E-04_JPRB,2.1113E-04_JPRB,2.8821E-04_JPRB,3.5348E-04_JPRB,4.1112E-04_JPRB,&
&4.6174E-04_JPRB,4.7717E-04_JPRB,4.8657E-04_JPRB,9.8685E-04_JPRB/)
KAO( :, 3,10, 2) = (/&
&5.1499E-06_JPRB,1.4143E-04_JPRB,2.3734E-04_JPRB,3.2100E-04_JPRB,3.9236E-04_JPRB,4.5145E-04_JPRB,&
&5.0315E-04_JPRB,5.0792E-04_JPRB,4.9406E-04_JPRB,1.1242E-03_JPRB/)
KAO( :, 4,10, 2) = (/&
&7.4528E-06_JPRB,1.6827E-04_JPRB,2.7574E-04_JPRB,3.6613E-04_JPRB,4.4442E-04_JPRB,5.0912E-04_JPRB,&
&5.6026E-04_JPRB,5.7140E-04_JPRB,5.5681E-04_JPRB,1.2935E-03_JPRB/)
KAO( :, 5,10, 2) = (/&
&1.1134E-05_JPRB,2.0532E-04_JPRB,3.2832E-04_JPRB,4.2825E-04_JPRB,5.1275E-04_JPRB,5.8331E-04_JPRB,&
&6.3709E-04_JPRB,6.4447E-04_JPRB,5.7554E-04_JPRB,1.4892E-03_JPRB/)
KAO( :, 1,11, 2) = (/&
&2.5793E-06_JPRB,9.1386E-05_JPRB,1.5991E-04_JPRB,2.1914E-04_JPRB,2.7076E-04_JPRB,3.1821E-04_JPRB,&
&3.5500E-04_JPRB,3.6871E-04_JPRB,3.7899E-04_JPRB,8.3339E-04_JPRB/)
KAO( :, 2,11, 2) = (/&
&3.1932E-06_JPRB,1.0152E-04_JPRB,1.7439E-04_JPRB,2.3840E-04_JPRB,2.9253E-04_JPRB,3.3975E-04_JPRB,&
&3.8122E-04_JPRB,3.9384E-04_JPRB,4.0567E-04_JPRB,9.5074E-04_JPRB/)
KAO( :, 3,11, 2) = (/&
&4.3709E-06_JPRB,1.1728E-04_JPRB,1.9656E-04_JPRB,2.6595E-04_JPRB,3.2495E-04_JPRB,3.7366E-04_JPRB,&
&4.1570E-04_JPRB,4.1965E-04_JPRB,4.1122E-04_JPRB,1.0992E-03_JPRB/)
KAO( :, 4,11, 2) = (/&
&6.3954E-06_JPRB,1.4000E-04_JPRB,2.2922E-04_JPRB,3.0419E-04_JPRB,3.6879E-04_JPRB,4.2168E-04_JPRB,&
&4.6345E-04_JPRB,4.7319E-04_JPRB,4.5954E-04_JPRB,1.2804E-03_JPRB/)
KAO( :, 5,11, 2) = (/&
&9.6174E-06_JPRB,1.7120E-04_JPRB,2.7357E-04_JPRB,3.5711E-04_JPRB,4.2654E-04_JPRB,4.8415E-04_JPRB,&
&5.2775E-04_JPRB,5.3321E-04_JPRB,4.7537E-04_JPRB,1.4946E-03_JPRB/)
KAO( :, 1,12, 2) = (/&
&2.1449E-06_JPRB,7.5185E-05_JPRB,1.3159E-04_JPRB,1.8068E-04_JPRB,2.2335E-04_JPRB,2.6198E-04_JPRB,&
&2.9235E-04_JPRB,3.0350E-04_JPRB,3.1256E-04_JPRB,7.2986E-04_JPRB/)
KAO( :, 2,12, 2) = (/&
&2.6849E-06_JPRB,8.3739E-05_JPRB,1.4370E-04_JPRB,1.9666E-04_JPRB,2.4153E-04_JPRB,2.8046E-04_JPRB,&
&3.1445E-04_JPRB,3.2440E-04_JPRB,3.3814E-04_JPRB,8.3896E-04_JPRB/)
KAO( :, 3,12, 2) = (/&
&3.7120E-06_JPRB,9.7072E-05_JPRB,1.6242E-04_JPRB,2.1974E-04_JPRB,2.6866E-04_JPRB,3.0880E-04_JPRB,&
&3.4296E-04_JPRB,3.4655E-04_JPRB,3.4183E-04_JPRB,9.7914E-04_JPRB/)
KAO( :, 4,12, 2) = (/&
&5.4750E-06_JPRB,1.1621E-04_JPRB,1.9012E-04_JPRB,2.5210E-04_JPRB,3.0547E-04_JPRB,3.4901E-04_JPRB,&
&3.8299E-04_JPRB,3.9098E-04_JPRB,3.8045E-04_JPRB,1.1499E-03_JPRB/)
KAO( :, 5,12, 2) = (/&
&8.2703E-06_JPRB,1.4241E-04_JPRB,2.2731E-04_JPRB,2.9701E-04_JPRB,3.5442E-04_JPRB,4.0147E-04_JPRB,&
&4.3679E-04_JPRB,4.4039E-04_JPRB,3.9154E-04_JPRB,1.3496E-03_JPRB/)
KAO( :, 1,13, 2) = (/&
&1.7830E-06_JPRB,6.1545E-05_JPRB,1.0776E-04_JPRB,1.4816E-04_JPRB,1.8346E-04_JPRB,2.1518E-04_JPRB,&
&2.4003E-04_JPRB,2.4920E-04_JPRB,2.5855E-04_JPRB,6.0483E-04_JPRB/)
KAO( :, 2,13, 2) = (/&
&2.2523E-06_JPRB,6.8708E-05_JPRB,1.1787E-04_JPRB,1.6139E-04_JPRB,1.9846E-04_JPRB,2.3065E-04_JPRB,&
&2.5831E-04_JPRB,2.6663E-04_JPRB,2.8115E-04_JPRB,6.9533E-04_JPRB/)
KAO( :, 3,13, 2) = (/&
&3.1394E-06_JPRB,7.9894E-05_JPRB,1.3357E-04_JPRB,1.8071E-04_JPRB,2.2106E-04_JPRB,2.5423E-04_JPRB,&
&2.8211E-04_JPRB,2.8541E-04_JPRB,2.8437E-04_JPRB,8.1181E-04_JPRB/)
KAO( :, 4,13, 2) = (/&
&4.6431E-06_JPRB,9.5872E-05_JPRB,1.5677E-04_JPRB,2.0791E-04_JPRB,2.5190E-04_JPRB,2.8785E-04_JPRB,&
&3.1567E-04_JPRB,3.2214E-04_JPRB,3.1077E-04_JPRB,9.5374E-04_JPRB/)
KAO( :, 5,13, 2) = (/&
&7.0293E-06_JPRB,1.1782E-04_JPRB,1.8782E-04_JPRB,2.4556E-04_JPRB,2.9310E-04_JPRB,3.3172E-04_JPRB,&
&3.6069E-04_JPRB,3.6276E-04_JPRB,3.2321E-04_JPRB,1.1190E-03_JPRB/)
KAO( :, 1, 1, 3) = (/&
&3.1395E-04_JPRB,2.3358E-03_JPRB,3.6695E-03_JPRB,4.7583E-03_JPRB,5.6300E-03_JPRB,6.3084E-03_JPRB,&
&6.4459E-03_JPRB,5.6476E-03_JPRB,4.3114E-03_JPRB,3.5359E-03_JPRB/)
KAO( :, 2, 1, 3) = (/&
&4.4041E-04_JPRB,2.8550E-03_JPRB,4.4288E-03_JPRB,5.7337E-03_JPRB,6.7703E-03_JPRB,7.4874E-03_JPRB,&
&7.5852E-03_JPRB,6.6048E-03_JPRB,4.4609E-03_JPRB,3.7307E-03_JPRB/)
KAO( :, 3, 1, 3) = (/&
&6.0889E-04_JPRB,3.4990E-03_JPRB,5.3318E-03_JPRB,6.8783E-03_JPRB,8.0899E-03_JPRB,8.8562E-03_JPRB,&
&8.8659E-03_JPRB,7.6998E-03_JPRB,5.0834E-03_JPRB,4.1606E-03_JPRB/)
KAO( :, 4, 1, 3) = (/&
&8.2945E-04_JPRB,4.2967E-03_JPRB,6.4106E-03_JPRB,8.2013E-03_JPRB,9.6038E-03_JPRB,1.0382E-02_JPRB,&
&1.0298E-02_JPRB,8.9419E-03_JPRB,6.1506E-03_JPRB,4.8030E-03_JPRB/)
KAO( :, 5, 1, 3) = (/&
&1.1111E-03_JPRB,5.2640E-03_JPRB,7.6785E-03_JPRB,9.7243E-03_JPRB,1.1313E-02_JPRB,1.2073E-02_JPRB,&
&1.1918E-02_JPRB,1.0340E-02_JPRB,7.2231E-03_JPRB,5.5559E-03_JPRB/)
KAO( :, 1, 2, 3) = (/&
&2.5786E-04_JPRB,1.8689E-03_JPRB,2.9171E-03_JPRB,3.7655E-03_JPRB,4.4557E-03_JPRB,4.9851E-03_JPRB,&
&5.0877E-03_JPRB,4.4987E-03_JPRB,3.5624E-03_JPRB,2.7823E-03_JPRB/)
KAO( :, 2, 2, 3) = (/&
&3.6518E-04_JPRB,2.2982E-03_JPRB,3.5229E-03_JPRB,4.5348E-03_JPRB,5.3627E-03_JPRB,5.9413E-03_JPRB,&
&6.0131E-03_JPRB,5.2796E-03_JPRB,3.6528E-03_JPRB,2.9862E-03_JPRB/)
KAO( :, 3, 2, 3) = (/&
&5.0963E-04_JPRB,2.8326E-03_JPRB,4.2490E-03_JPRB,5.4478E-03_JPRB,6.4291E-03_JPRB,7.0522E-03_JPRB,&
&7.0637E-03_JPRB,6.1794E-03_JPRB,4.0832E-03_JPRB,3.3326E-03_JPRB/)
KAO( :, 4, 2, 3) = (/&
&7.0041E-04_JPRB,3.4946E-03_JPRB,5.1315E-03_JPRB,6.5181E-03_JPRB,7.6574E-03_JPRB,8.3039E-03_JPRB,&
&8.2501E-03_JPRB,7.2013E-03_JPRB,4.9579E-03_JPRB,3.8182E-03_JPRB/)
KAO( :, 5, 2, 3) = (/&
&9.4509E-04_JPRB,4.3042E-03_JPRB,6.1780E-03_JPRB,7.7645E-03_JPRB,9.0552E-03_JPRB,9.6970E-03_JPRB,&
&9.5937E-03_JPRB,8.3644E-03_JPRB,5.8475E-03_JPRB,4.3744E-03_JPRB/)
KAO( :, 1, 3, 3) = (/&
&1.9379E-04_JPRB,1.4316E-03_JPRB,2.2324E-03_JPRB,2.8735E-03_JPRB,3.3970E-03_JPRB,3.8041E-03_JPRB,&
&3.8802E-03_JPRB,3.4669E-03_JPRB,2.9119E-03_JPRB,2.1744E-03_JPRB/)
KAO( :, 2, 3, 3) = (/&
&2.7770E-04_JPRB,1.7674E-03_JPRB,2.7001E-03_JPRB,3.4577E-03_JPRB,4.0882E-03_JPRB,4.5451E-03_JPRB,&
&4.6130E-03_JPRB,4.0692E-03_JPRB,2.9379E-03_JPRB,2.3588E-03_JPRB/)
KAO( :, 3, 3, 3) = (/&
&3.9251E-04_JPRB,2.1938E-03_JPRB,3.2645E-03_JPRB,4.1604E-03_JPRB,4.9099E-03_JPRB,5.4125E-03_JPRB,&
&5.4492E-03_JPRB,4.7846E-03_JPRB,3.2003E-03_JPRB,2.6346E-03_JPRB/)
KAO( :, 4, 3, 3) = (/&
&5.4605E-04_JPRB,2.7278E-03_JPRB,3.9609E-03_JPRB,4.9977E-03_JPRB,5.8740E-03_JPRB,6.4067E-03_JPRB,&
&6.4003E-03_JPRB,5.6054E-03_JPRB,3.7732E-03_JPRB,2.9860E-03_JPRB/)
KAO( :, 5, 3, 3) = (/&
&7.4466E-04_JPRB,3.3848E-03_JPRB,4.8045E-03_JPRB,5.9823E-03_JPRB,6.9787E-03_JPRB,7.5209E-03_JPRB,&
&7.4708E-03_JPRB,6.5433E-03_JPRB,4.5620E-03_JPRB,3.3966E-03_JPRB/)
KAO( :, 1, 4, 3) = (/&
&1.4015E-04_JPRB,1.0813E-03_JPRB,1.6854E-03_JPRB,2.1729E-03_JPRB,2.5709E-03_JPRB,2.8772E-03_JPRB,&
&2.9317E-03_JPRB,2.6451E-03_JPRB,2.2657E-03_JPRB,1.7383E-03_JPRB/)
KAO( :, 2, 4, 3) = (/&
&2.0311E-04_JPRB,1.3407E-03_JPRB,2.0417E-03_JPRB,2.6162E-03_JPRB,3.0900E-03_JPRB,3.4371E-03_JPRB,&
&3.4970E-03_JPRB,3.1030E-03_JPRB,2.4331E-03_JPRB,1.8807E-03_JPRB/)
KAO( :, 3, 4, 3) = (/&
&2.9086E-04_JPRB,1.6740E-03_JPRB,2.4810E-03_JPRB,3.1478E-03_JPRB,3.7091E-03_JPRB,4.1012E-03_JPRB,&
&4.1503E-03_JPRB,3.6669E-03_JPRB,2.5193E-03_JPRB,2.0853E-03_JPRB/)
KAO( :, 4, 4, 3) = (/&
&4.1019E-04_JPRB,2.0975E-03_JPRB,3.0276E-03_JPRB,3.7932E-03_JPRB,4.4503E-03_JPRB,4.8736E-03_JPRB,&
&4.8948E-03_JPRB,4.3129E-03_JPRB,2.8422E-03_JPRB,2.3481E-03_JPRB/)
KAO( :, 5, 4, 3) = (/&
&5.6658E-04_JPRB,2.6213E-03_JPRB,3.6972E-03_JPRB,4.5663E-03_JPRB,5.3124E-03_JPRB,5.7564E-03_JPRB,&
&5.7449E-03_JPRB,5.0602E-03_JPRB,3.4831E-03_JPRB,2.6607E-03_JPRB/)
KAO( :, 1, 5, 3) = (/&
&1.0005E-04_JPRB,8.1751E-04_JPRB,1.2728E-03_JPRB,1.6409E-03_JPRB,1.9492E-03_JPRB,2.1828E-03_JPRB,&
&2.2210E-03_JPRB,2.0236E-03_JPRB,1.7728E-03_JPRB,1.4477E-03_JPRB/)
KAO( :, 2, 5, 3) = (/&
&1.4628E-04_JPRB,1.0154E-03_JPRB,1.5439E-03_JPRB,1.9778E-03_JPRB,2.3404E-03_JPRB,2.6065E-03_JPRB,&
&2.6499E-03_JPRB,2.3648E-03_JPRB,1.9853E-03_JPRB,1.5598E-03_JPRB/)
KAO( :, 3, 5, 3) = (/&
&2.1213E-04_JPRB,1.2737E-03_JPRB,1.8830E-03_JPRB,2.3878E-03_JPRB,2.8089E-03_JPRB,3.1116E-03_JPRB,&
&3.1584E-03_JPRB,2.8055E-03_JPRB,1.9979E-03_JPRB,1.7165E-03_JPRB/)
KAO( :, 4, 5, 3) = (/&
&3.0316E-04_JPRB,1.6037E-03_JPRB,2.3102E-03_JPRB,2.8890E-03_JPRB,3.3732E-03_JPRB,3.7052E-03_JPRB,&
&3.7386E-03_JPRB,3.3128E-03_JPRB,2.1889E-03_JPRB,1.9135E-03_JPRB/)
KAO( :, 5, 5, 3) = (/&
&4.2437E-04_JPRB,2.0170E-03_JPRB,2.8415E-03_JPRB,3.4970E-03_JPRB,4.0448E-03_JPRB,4.3946E-03_JPRB,&
&4.4054E-03_JPRB,3.8956E-03_JPRB,2.6089E-03_JPRB,2.1456E-03_JPRB/)
KAO( :, 1, 6, 3) = (/&
&6.9848E-05_JPRB,6.1344E-04_JPRB,9.5427E-04_JPRB,1.2333E-03_JPRB,1.4696E-03_JPRB,1.6459E-03_JPRB,&
&1.6778E-03_JPRB,1.5491E-03_JPRB,1.4340E-03_JPRB,1.2155E-03_JPRB/)
KAO( :, 2, 6, 3) = (/&
&1.0287E-04_JPRB,7.6231E-04_JPRB,1.1596E-03_JPRB,1.4875E-03_JPRB,1.7602E-03_JPRB,1.9644E-03_JPRB,&
&1.9987E-03_JPRB,1.8015E-03_JPRB,1.5475E-03_JPRB,1.3106E-03_JPRB/)
KAO( :, 3, 6, 3) = (/&
&1.5064E-04_JPRB,9.5897E-04_JPRB,1.4184E-03_JPRB,1.7997E-03_JPRB,2.1174E-03_JPRB,2.3481E-03_JPRB,&
&2.3855E-03_JPRB,2.1239E-03_JPRB,1.6664E-03_JPRB,1.4397E-03_JPRB/)
KAO( :, 4, 6, 3) = (/&
&2.1812E-04_JPRB,1.2102E-03_JPRB,1.7485E-03_JPRB,2.1875E-03_JPRB,2.5486E-03_JPRB,2.8028E-03_JPRB,&
&2.8356E-03_JPRB,2.5206E-03_JPRB,1.7195E-03_JPRB,1.5934E-03_JPRB/)
KAO( :, 5, 6, 3) = (/&
&3.0969E-04_JPRB,1.5273E-03_JPRB,2.1634E-03_JPRB,2.6620E-03_JPRB,3.0695E-03_JPRB,3.3380E-03_JPRB,&
&3.3515E-03_JPRB,2.9746E-03_JPRB,1.9515E-03_JPRB,1.7778E-03_JPRB/)
KAO( :, 1, 7, 3) = (/&
&4.8221E-05_JPRB,4.6010E-04_JPRB,7.1481E-04_JPRB,9.2859E-04_JPRB,1.1100E-03_JPRB,1.2408E-03_JPRB,&
&1.2683E-03_JPRB,1.1941E-03_JPRB,1.1654E-03_JPRB,1.0618E-03_JPRB/)
KAO( :, 2, 7, 3) = (/&
&7.1316E-05_JPRB,5.6993E-04_JPRB,8.6994E-04_JPRB,1.1165E-03_JPRB,1.3220E-03_JPRB,1.4781E-03_JPRB,&
&1.5050E-03_JPRB,1.3757E-03_JPRB,1.2140E-03_JPRB,1.1427E-03_JPRB/)
KAO( :, 3, 7, 3) = (/&
&1.0540E-04_JPRB,7.1740E-04_JPRB,1.0671E-03_JPRB,1.3546E-03_JPRB,1.5921E-03_JPRB,1.7675E-03_JPRB,&
&1.7993E-03_JPRB,1.6085E-03_JPRB,1.3409E-03_JPRB,1.2460E-03_JPRB/)
KAO( :, 4, 7, 3) = (/&
&1.5421E-04_JPRB,9.0675E-04_JPRB,1.3194E-03_JPRB,1.6531E-03_JPRB,1.9239E-03_JPRB,2.1163E-03_JPRB,&
&2.1446E-03_JPRB,1.9118E-03_JPRB,1.3549E-03_JPRB,1.3702E-03_JPRB/)
KAO( :, 5, 7, 3) = (/&
&2.2207E-04_JPRB,1.1485E-03_JPRB,1.6379E-03_JPRB,2.0236E-03_JPRB,2.3292E-03_JPRB,2.5319E-03_JPRB,&
&2.5452E-03_JPRB,2.2618E-03_JPRB,1.4884E-03_JPRB,1.5202E-03_JPRB/)
KAO( :, 1, 8, 3) = (/&
&3.3024E-05_JPRB,3.4530E-04_JPRB,5.3688E-04_JPRB,7.0115E-04_JPRB,8.4229E-04_JPRB,9.3889E-04_JPRB,&
&9.6725E-04_JPRB,9.1694E-04_JPRB,9.1670E-04_JPRB,1.0135E-03_JPRB/)
KAO( :, 2, 8, 3) = (/&
&4.8867E-05_JPRB,4.2560E-04_JPRB,6.5145E-04_JPRB,8.3778E-04_JPRB,9.9544E-04_JPRB,1.1134E-03_JPRB,&
&1.1345E-03_JPRB,1.0538E-03_JPRB,9.7113E-04_JPRB,1.0857E-03_JPRB/)
KAO( :, 3, 8, 3) = (/&
&7.2825E-05_JPRB,5.3471E-04_JPRB,8.0022E-04_JPRB,1.0181E-03_JPRB,1.1967E-03_JPRB,1.3302E-03_JPRB,&
&1.3547E-03_JPRB,1.2266E-03_JPRB,1.0446E-03_JPRB,1.1774E-03_JPRB/)
KAO( :, 4, 8, 3) = (/&
&1.0774E-04_JPRB,6.7652E-04_JPRB,9.9081E-04_JPRB,1.2458E-03_JPRB,1.4508E-03_JPRB,1.5976E-03_JPRB,&
&1.6199E-03_JPRB,1.4510E-03_JPRB,1.1389E-03_JPRB,1.2913E-03_JPRB/)
KAO( :, 5, 8, 3) = (/&
&1.5712E-04_JPRB,8.5893E-04_JPRB,1.2330E-03_JPRB,1.5318E-03_JPRB,1.7648E-03_JPRB,1.9188E-03_JPRB,&
&1.9298E-03_JPRB,1.7197E-03_JPRB,1.1585E-03_JPRB,1.4301E-03_JPRB/)
KAO( :, 1, 9, 3) = (/&
&2.2694E-05_JPRB,2.5964E-04_JPRB,4.0587E-04_JPRB,5.3244E-04_JPRB,6.4307E-04_JPRB,7.1486E-04_JPRB,&
&7.4240E-04_JPRB,7.1164E-04_JPRB,7.2273E-04_JPRB,1.2493E-03_JPRB/)
KAO( :, 2, 9, 3) = (/&
&3.3403E-05_JPRB,3.1851E-04_JPRB,4.8826E-04_JPRB,6.2982E-04_JPRB,7.5282E-04_JPRB,8.4067E-04_JPRB,&
&8.5777E-04_JPRB,8.1055E-04_JPRB,7.8048E-04_JPRB,1.3812E-03_JPRB/)
KAO( :, 3, 9, 3) = (/&
&5.0028E-05_JPRB,3.9826E-04_JPRB,5.9931E-04_JPRB,7.6424E-04_JPRB,9.0031E-04_JPRB,1.0018E-03_JPRB,&
&1.0201E-03_JPRB,9.3771E-04_JPRB,8.2897E-04_JPRB,1.5248E-03_JPRB/)
KAO( :, 4, 9, 3) = (/&
&7.4767E-05_JPRB,5.0392E-04_JPRB,7.4141E-04_JPRB,9.3676E-04_JPRB,1.0930E-03_JPRB,1.2050E-03_JPRB,&
&1.2228E-03_JPRB,1.0983E-03_JPRB,9.0134E-04_JPRB,1.6871E-03_JPRB/)
KAO( :, 5, 9, 3) = (/&
&1.1035E-04_JPRB,6.4097E-04_JPRB,9.2434E-04_JPRB,1.1532E-03_JPRB,1.3334E-03_JPRB,1.4526E-03_JPRB,&
&1.4614E-03_JPRB,1.3054E-03_JPRB,9.1810E-04_JPRB,1.8727E-03_JPRB/)
KAO( :, 1,10, 3) = (/&
&1.6131E-05_JPRB,1.9889E-04_JPRB,3.1275E-04_JPRB,4.1228E-04_JPRB,4.9839E-04_JPRB,5.5623E-04_JPRB,&
&5.8253E-04_JPRB,5.6343E-04_JPRB,5.6050E-04_JPRB,1.5889E-03_JPRB/)
KAO( :, 2,10, 3) = (/&
&2.3548E-05_JPRB,2.4279E-04_JPRB,3.7289E-04_JPRB,4.8222E-04_JPRB,5.7912E-04_JPRB,6.4486E-04_JPRB,&
&6.6265E-04_JPRB,6.3391E-04_JPRB,6.2287E-04_JPRB,1.8970E-03_JPRB/)
KAO( :, 3,10, 3) = (/&
&3.5345E-05_JPRB,3.0213E-04_JPRB,4.5662E-04_JPRB,5.8302E-04_JPRB,6.8872E-04_JPRB,7.6652E-04_JPRB,&
&7.8037E-04_JPRB,7.2531E-04_JPRB,6.6020E-04_JPRB,2.2611E-03_JPRB/)
KAO( :, 4,10, 3) = (/&
&5.3207E-05_JPRB,3.8181E-04_JPRB,5.6403E-04_JPRB,7.1428E-04_JPRB,8.3596E-04_JPRB,9.2165E-04_JPRB,&
&9.3562E-04_JPRB,8.4502E-04_JPRB,7.1249E-04_JPRB,2.6676E-03_JPRB/)
KAO( :, 5,10, 3) = (/&
&7.9349E-05_JPRB,4.8668E-04_JPRB,7.0365E-04_JPRB,8.7954E-04_JPRB,1.0204E-03_JPRB,1.1145E-03_JPRB,&
&1.1232E-03_JPRB,1.0045E-03_JPRB,7.7476E-04_JPRB,3.1110E-03_JPRB/)
KAO( :, 1,11, 3) = (/&
&1.3601E-05_JPRB,1.6644E-04_JPRB,2.6059E-04_JPRB,3.4190E-04_JPRB,4.1323E-04_JPRB,4.6098E-04_JPRB,&
&4.8236E-04_JPRB,4.6602E-04_JPRB,4.6408E-04_JPRB,1.7060E-03_JPRB/)
KAO( :, 2,11, 3) = (/&
&2.0015E-05_JPRB,2.0390E-04_JPRB,3.1274E-04_JPRB,4.0248E-04_JPRB,4.8157E-04_JPRB,5.3553E-04_JPRB,&
&5.5000E-04_JPRB,5.2592E-04_JPRB,5.1327E-04_JPRB,2.0930E-03_JPRB/)
KAO( :, 3,11, 3) = (/&
&3.0229E-05_JPRB,2.5493E-04_JPRB,3.8325E-04_JPRB,4.8838E-04_JPRB,5.7590E-04_JPRB,6.3868E-04_JPRB,&
&6.4952E-04_JPRB,6.0329E-04_JPRB,5.4354E-04_JPRB,2.5341E-03_JPRB/)
KAO( :, 4,11, 3) = (/&
&4.5728E-05_JPRB,3.2357E-04_JPRB,4.7513E-04_JPRB,5.9900E-04_JPRB,7.0032E-04_JPRB,7.7052E-04_JPRB,&
&7.8160E-04_JPRB,7.0364E-04_JPRB,5.8867E-04_JPRB,3.0110E-03_JPRB/)
KAO( :, 5,11, 3) = (/&
&6.8471E-05_JPRB,4.1453E-04_JPRB,5.9518E-04_JPRB,7.3943E-04_JPRB,8.5586E-04_JPRB,9.3243E-04_JPRB,&
&9.3985E-04_JPRB,8.3888E-04_JPRB,6.4004E-04_JPRB,3.5144E-03_JPRB/)
KAO( :, 1,12, 3) = (/&
&1.1390E-05_JPRB,1.3855E-04_JPRB,2.1705E-04_JPRB,2.8356E-04_JPRB,3.4198E-04_JPRB,3.8125E-04_JPRB,&
&3.9897E-04_JPRB,3.8701E-04_JPRB,3.8428E-04_JPRB,1.6202E-03_JPRB/)
KAO( :, 2,12, 3) = (/&
&1.6895E-05_JPRB,1.7033E-04_JPRB,2.6132E-04_JPRB,3.3574E-04_JPRB,4.0033E-04_JPRB,4.4440E-04_JPRB,&
&4.5547E-04_JPRB,4.3453E-04_JPRB,4.1795E-04_JPRB,2.0056E-03_JPRB/)
KAO( :, 3,12, 3) = (/&
&2.5697E-05_JPRB,2.1399E-04_JPRB,3.2079E-04_JPRB,4.0794E-04_JPRB,4.8080E-04_JPRB,5.3172E-04_JPRB,&
&5.4015E-04_JPRB,5.0131E-04_JPRB,4.5062E-04_JPRB,2.4356E-03_JPRB/)
KAO( :, 4,12, 3) = (/&
&3.9098E-05_JPRB,2.7301E-04_JPRB,3.9923E-04_JPRB,5.0137E-04_JPRB,5.8487E-04_JPRB,6.4185E-04_JPRB,&
&6.5190E-04_JPRB,5.8598E-04_JPRB,4.9100E-04_JPRB,2.8992E-03_JPRB/)
KAO( :, 5,12, 3) = (/&
&5.8880E-05_JPRB,3.5135E-04_JPRB,5.0233E-04_JPRB,6.2054E-04_JPRB,7.1596E-04_JPRB,7.7742E-04_JPRB,&
&7.8406E-04_JPRB,7.0089E-04_JPRB,5.2975E-04_JPRB,3.3853E-03_JPRB/)
KAO( :, 1,13, 3) = (/&
&9.3589E-06_JPRB,1.1404E-04_JPRB,1.7929E-04_JPRB,2.3424E-04_JPRB,2.8177E-04_JPRB,3.1382E-04_JPRB,&
&3.2887E-04_JPRB,3.1939E-04_JPRB,3.1782E-04_JPRB,1.3712E-03_JPRB/)
KAO( :, 2,13, 3) = (/&
&1.3997E-05_JPRB,1.4070E-04_JPRB,2.1638E-04_JPRB,2.7822E-04_JPRB,3.3131E-04_JPRB,3.6740E-04_JPRB,&
&3.7618E-04_JPRB,3.5875E-04_JPRB,3.4257E-04_JPRB,1.6948E-03_JPRB/)
KAO( :, 3,13, 3) = (/&
&2.1467E-05_JPRB,1.7760E-04_JPRB,2.6657E-04_JPRB,3.3860E-04_JPRB,3.9863E-04_JPRB,4.4020E-04_JPRB,&
&4.4774E-04_JPRB,4.1503E-04_JPRB,3.7387E-04_JPRB,2.0555E-03_JPRB/)
KAO( :, 4,13, 3) = (/&
&3.2939E-05_JPRB,2.2791E-04_JPRB,3.3320E-04_JPRB,4.1728E-04_JPRB,4.8576E-04_JPRB,5.3169E-04_JPRB,&
&5.4072E-04_JPRB,4.8718E-04_JPRB,4.1358E-04_JPRB,2.4418E-03_JPRB/)
KAO( :, 5,13, 3) = (/&
&5.0038E-05_JPRB,2.9443E-04_JPRB,4.2080E-04_JPRB,5.1807E-04_JPRB,5.9619E-04_JPRB,6.4532E-04_JPRB,&
&6.5035E-04_JPRB,5.8360E-04_JPRB,4.3228E-04_JPRB,2.8426E-03_JPRB/)
KAO( :, 1, 1, 4) = (/&
&1.3959E-03_JPRB,5.9922E-03_JPRB,8.2316E-03_JPRB,9.8059E-03_JPRB,1.0613E-02_JPRB,1.0620E-02_JPRB,&
&1.0007E-02_JPRB,8.7254E-03_JPRB,5.9465E-03_JPRB,5.3438E-03_JPRB/)
KAO( :, 2, 1, 4) = (/&
&1.8497E-03_JPRB,7.5460E-03_JPRB,1.0203E-02_JPRB,1.1955E-02_JPRB,1.2786E-02_JPRB,1.2712E-02_JPRB,&
&1.1856E-02_JPRB,1.0291E-02_JPRB,7.1447E-03_JPRB,6.1713E-03_JPRB/)
KAO( :, 3, 1, 4) = (/&
&2.4455E-03_JPRB,9.3977E-03_JPRB,1.2548E-02_JPRB,1.4434E-02_JPRB,1.5252E-02_JPRB,1.5095E-02_JPRB,&
&1.3989E-02_JPRB,1.2066E-02_JPRB,8.3510E-03_JPRB,7.1167E-03_JPRB/)
KAO( :, 4, 1, 4) = (/&
&3.2093E-03_JPRB,1.1523E-02_JPRB,1.5232E-02_JPRB,1.7235E-02_JPRB,1.8051E-02_JPRB,1.7818E-02_JPRB,&
&1.6407E-02_JPRB,1.4008E-02_JPRB,9.7059E-03_JPRB,8.2637E-03_JPRB/)
KAO( :, 5, 1, 4) = (/&
&4.1640E-03_JPRB,1.3947E-02_JPRB,1.8138E-02_JPRB,2.0353E-02_JPRB,2.1133E-02_JPRB,2.0847E-02_JPRB,&
&1.9064E-02_JPRB,1.6182E-02_JPRB,1.1218E-02_JPRB,9.5219E-03_JPRB/)
KAO( :, 1, 2, 4) = (/&
&1.1784E-03_JPRB,4.8259E-03_JPRB,6.5824E-03_JPRB,7.8076E-03_JPRB,8.3997E-03_JPRB,8.4013E-03_JPRB,&
&7.9589E-03_JPRB,6.9035E-03_JPRB,4.7972E-03_JPRB,4.1536E-03_JPRB/)
KAO( :, 2, 2, 4) = (/&
&1.5660E-03_JPRB,6.0867E-03_JPRB,8.2146E-03_JPRB,9.5892E-03_JPRB,1.0197E-02_JPRB,1.0118E-02_JPRB,&
&9.4816E-03_JPRB,8.1710E-03_JPRB,5.7311E-03_JPRB,4.7856E-03_JPRB/)
KAO( :, 3, 2, 4) = (/&
&2.0771E-03_JPRB,7.6156E-03_JPRB,1.0151E-02_JPRB,1.1655E-02_JPRB,1.2244E-02_JPRB,1.2103E-02_JPRB,&
&1.1249E-02_JPRB,9.6217E-03_JPRB,6.7053E-03_JPRB,5.5268E-03_JPRB/)
KAO( :, 4, 2, 4) = (/&
&2.7371E-03_JPRB,9.3986E-03_JPRB,1.2362E-02_JPRB,1.3996E-02_JPRB,1.4573E-02_JPRB,1.4394E-02_JPRB,&
&1.3273E-02_JPRB,1.1249E-02_JPRB,7.8082E-03_JPRB,6.4145E-03_JPRB/)
KAO( :, 5, 2, 4) = (/&
&3.5707E-03_JPRB,1.1441E-02_JPRB,1.4782E-02_JPRB,1.6569E-02_JPRB,1.7185E-02_JPRB,1.6953E-02_JPRB,&
&1.5517E-02_JPRB,1.3078E-02_JPRB,9.0555E-03_JPRB,7.4094E-03_JPRB/)
KAO( :, 1, 3, 4) = (/&
&9.3612E-04_JPRB,3.7181E-03_JPRB,5.0390E-03_JPRB,5.9502E-03_JPRB,6.3679E-03_JPRB,6.3786E-03_JPRB,&
&6.0698E-03_JPRB,5.2727E-03_JPRB,3.7120E-03_JPRB,3.2201E-03_JPRB/)
KAO( :, 2, 3, 4) = (/&
&1.2490E-03_JPRB,4.6957E-03_JPRB,6.3176E-03_JPRB,7.3745E-03_JPRB,7.7966E-03_JPRB,7.7361E-03_JPRB,&
&7.2751E-03_JPRB,6.2746E-03_JPRB,4.4490E-03_JPRB,3.6844E-03_JPRB/)
KAO( :, 3, 3, 4) = (/&
&1.6672E-03_JPRB,5.9017E-03_JPRB,7.8487E-03_JPRB,9.0223E-03_JPRB,9.4573E-03_JPRB,9.3283E-03_JPRB,&
&8.6995E-03_JPRB,7.4301E-03_JPRB,5.1895E-03_JPRB,4.2405E-03_JPRB/)
KAO( :, 4, 3, 4) = (/&
&2.2134E-03_JPRB,7.3371E-03_JPRB,9.6281E-03_JPRB,1.0911E-02_JPRB,1.1346E-02_JPRB,1.1187E-02_JPRB,&
&1.0343E-02_JPRB,8.7520E-03_JPRB,6.1061E-03_JPRB,4.8883E-03_JPRB/)
KAO( :, 5, 3, 4) = (/&
&2.9080E-03_JPRB,9.0078E-03_JPRB,1.1596E-02_JPRB,1.2990E-02_JPRB,1.3474E-02_JPRB,1.3306E-02_JPRB,&
&1.2200E-02_JPRB,1.0250E-02_JPRB,7.0746E-03_JPRB,5.6394E-03_JPRB/)
KAO( :, 1, 4, 4) = (/&
&7.2899E-04_JPRB,2.8358E-03_JPRB,3.8166E-03_JPRB,4.4649E-03_JPRB,4.7605E-03_JPRB,4.7776E-03_JPRB,&
&4.5645E-03_JPRB,3.9905E-03_JPRB,2.8172E-03_JPRB,2.5259E-03_JPRB/)
KAO( :, 2, 4, 4) = (/&
&9.7562E-04_JPRB,3.5858E-03_JPRB,4.8000E-03_JPRB,5.5643E-03_JPRB,5.8729E-03_JPRB,5.8345E-03_JPRB,&
&5.5106E-03_JPRB,4.7660E-03_JPRB,3.3369E-03_JPRB,2.8747E-03_JPRB/)
KAO( :, 3, 4, 4) = (/&
&1.3110E-03_JPRB,4.5252E-03_JPRB,5.9861E-03_JPRB,6.8654E-03_JPRB,7.1912E-03_JPRB,7.0898E-03_JPRB,&
&6.6257E-03_JPRB,5.6788E-03_JPRB,3.9467E-03_JPRB,3.3017E-03_JPRB/)
KAO( :, 4, 4, 4) = (/&
&1.7535E-03_JPRB,5.6592E-03_JPRB,7.3895E-03_JPRB,8.3600E-03_JPRB,8.7028E-03_JPRB,8.5726E-03_JPRB,&
&7.9544E-03_JPRB,6.7413E-03_JPRB,4.7023E-03_JPRB,3.7920E-03_JPRB/)
KAO( :, 5, 4, 4) = (/&
&2.3234E-03_JPRB,7.0001E-03_JPRB,8.9795E-03_JPRB,1.0033E-02_JPRB,1.0407E-02_JPRB,1.0269E-02_JPRB,&
&9.4690E-03_JPRB,7.9455E-03_JPRB,5.4450E-03_JPRB,4.3729E-03_JPRB/)
KAO( :, 1, 5, 4) = (/&
&5.6650E-04_JPRB,2.1549E-03_JPRB,2.8964E-03_JPRB,3.3619E-03_JPRB,3.5664E-03_JPRB,3.5841E-03_JPRB,&
&3.4323E-03_JPRB,3.0201E-03_JPRB,2.2575E-03_JPRB,2.0547E-03_JPRB/)
KAO( :, 2, 5, 4) = (/&
&7.5923E-04_JPRB,2.7449E-03_JPRB,3.6494E-03_JPRB,4.2010E-03_JPRB,4.4180E-03_JPRB,4.3953E-03_JPRB,&
&4.1675E-03_JPRB,3.6219E-03_JPRB,2.5473E-03_JPRB,2.3046E-03_JPRB/)
KAO( :, 3, 5, 4) = (/&
&1.0253E-03_JPRB,3.4834E-03_JPRB,4.5686E-03_JPRB,5.2069E-03_JPRB,5.4481E-03_JPRB,5.3758E-03_JPRB,&
&5.0408E-03_JPRB,4.3359E-03_JPRB,3.0162E-03_JPRB,2.6195E-03_JPRB/)
KAO( :, 4, 5, 4) = (/&
&1.3801E-03_JPRB,4.3804E-03_JPRB,5.6725E-03_JPRB,6.3841E-03_JPRB,6.6485E-03_JPRB,6.5457E-03_JPRB,&
&6.0914E-03_JPRB,5.1828E-03_JPRB,3.5636E-03_JPRB,2.9971E-03_JPRB/)
KAO( :, 5, 5, 4) = (/&
&1.8434E-03_JPRB,5.4391E-03_JPRB,6.9434E-03_JPRB,7.7307E-03_JPRB,8.0143E-03_JPRB,7.8901E-03_JPRB,&
&7.3072E-03_JPRB,6.1548E-03_JPRB,4.1784E-03_JPRB,3.4508E-03_JPRB/)
KAO( :, 1, 6, 4) = (/&
&4.3479E-04_JPRB,1.6105E-03_JPRB,2.1624E-03_JPRB,2.5048E-03_JPRB,2.6629E-03_JPRB,2.6833E-03_JPRB,&
&2.5738E-03_JPRB,2.2737E-03_JPRB,1.8606E-03_JPRB,1.7234E-03_JPRB/)
KAO( :, 2, 6, 4) = (/&
&5.8233E-04_JPRB,2.0650E-03_JPRB,2.7444E-03_JPRB,3.1464E-03_JPRB,3.3112E-03_JPRB,3.2967E-03_JPRB,&
&3.1292E-03_JPRB,2.7330E-03_JPRB,1.9142E-03_JPRB,1.9183E-03_JPRB/)
KAO( :, 3, 6, 4) = (/&
&7.8843E-04_JPRB,2.6457E-03_JPRB,3.4646E-03_JPRB,3.9221E-03_JPRB,4.0954E-03_JPRB,4.0443E-03_JPRB,&
&3.8065E-03_JPRB,3.2872E-03_JPRB,2.2472E-03_JPRB,2.1603E-03_JPRB/)
KAO( :, 4, 6, 4) = (/&
&1.0676E-03_JPRB,3.3599E-03_JPRB,4.3294E-03_JPRB,4.8406E-03_JPRB,5.0306E-03_JPRB,4.9525E-03_JPRB,&
&4.6235E-03_JPRB,3.9530E-03_JPRB,2.6778E-03_JPRB,2.4636E-03_JPRB/)
KAO( :, 5, 6, 4) = (/&
&1.4360E-03_JPRB,4.2028E-03_JPRB,5.3355E-03_JPRB,5.9075E-03_JPRB,6.1148E-03_JPRB,6.0070E-03_JPRB,&
&5.5779E-03_JPRB,4.7305E-03_JPRB,3.1938E-03_JPRB,2.8201E-03_JPRB/)
KAO( :, 1, 7, 4) = (/&
&3.3066E-04_JPRB,1.1921E-03_JPRB,1.5997E-03_JPRB,1.8508E-03_JPRB,1.9750E-03_JPRB,2.0065E-03_JPRB,&
&1.9362E-03_JPRB,1.7121E-03_JPRB,1.5102E-03_JPRB,1.4755E-03_JPRB/)
KAO( :, 2, 7, 4) = (/&
&4.4251E-04_JPRB,1.5399E-03_JPRB,2.0431E-03_JPRB,2.3386E-03_JPRB,2.4693E-03_JPRB,2.4731E-03_JPRB,&
&2.3559E-03_JPRB,2.0619E-03_JPRB,1.5167E-03_JPRB,1.6278E-03_JPRB/)
KAO( :, 3, 7, 4) = (/&
&5.9954E-04_JPRB,1.9895E-03_JPRB,2.5996E-03_JPRB,2.9389E-03_JPRB,3.0769E-03_JPRB,3.0449E-03_JPRB,&
&2.8696E-03_JPRB,2.4854E-03_JPRB,1.7100E-03_JPRB,1.8261E-03_JPRB/)
KAO( :, 4, 7, 4) = (/&
&8.1539E-04_JPRB,2.5548E-03_JPRB,3.2831E-03_JPRB,3.6604E-03_JPRB,3.8004E-03_JPRB,3.7406E-03_JPRB,&
&3.5004E-03_JPRB,3.0009E-03_JPRB,2.0185E-03_JPRB,2.0723E-03_JPRB/)
KAO( :, 5, 7, 4) = (/&
&1.1035E-03_JPRB,3.2299E-03_JPRB,4.0851E-03_JPRB,4.5054E-03_JPRB,4.6506E-03_JPRB,4.5636E-03_JPRB,&
&4.2458E-03_JPRB,3.6170E-03_JPRB,2.4150E-03_JPRB,2.3689E-03_JPRB/)
KAO( :, 1, 8, 4) = (/&
&2.4824E-04_JPRB,8.7576E-04_JPRB,1.1750E-03_JPRB,1.3620E-03_JPRB,1.4591E-03_JPRB,1.4944E-03_JPRB,&
&1.4530E-03_JPRB,1.3016E-03_JPRB,1.2362E-03_JPRB,1.3815E-03_JPRB/)
KAO( :, 2, 8, 4) = (/&
&3.3230E-04_JPRB,1.1390E-03_JPRB,1.5103E-03_JPRB,1.7306E-03_JPRB,1.8323E-03_JPRB,1.8454E-03_JPRB,&
&1.7715E-03_JPRB,1.5588E-03_JPRB,1.2567E-03_JPRB,1.5241E-03_JPRB/)
KAO( :, 3, 8, 4) = (/&
&4.5036E-04_JPRB,1.4833E-03_JPRB,1.9397E-03_JPRB,2.1911E-03_JPRB,2.2984E-03_JPRB,2.2843E-03_JPRB,&
&2.1644E-03_JPRB,1.8786E-03_JPRB,1.3010E-03_JPRB,1.7047E-03_JPRB/)
KAO( :, 4, 8, 4) = (/&
&6.1425E-04_JPRB,1.9258E-03_JPRB,2.4736E-03_JPRB,2.7526E-03_JPRB,2.8618E-03_JPRB,2.8208E-03_JPRB,&
&2.6474E-03_JPRB,2.2738E-03_JPRB,1.4977E-03_JPRB,1.9231E-03_JPRB/)
KAO( :, 5, 8, 4) = (/&
&8.3579E-04_JPRB,2.4677E-03_JPRB,3.1100E-03_JPRB,3.4209E-03_JPRB,3.5321E-03_JPRB,3.4664E-03_JPRB,&
&3.2302E-03_JPRB,2.7529E-03_JPRB,1.8211E-03_JPRB,2.1802E-03_JPRB/)
KAO( :, 1, 9, 4) = (/&
&1.8648E-04_JPRB,6.4213E-04_JPRB,8.6248E-04_JPRB,1.0018E-03_JPRB,1.0759E-03_JPRB,1.1114E-03_JPRB,&
&1.0893E-03_JPRB,9.9064E-04_JPRB,9.8753E-04_JPRB,1.8775E-03_JPRB/)
KAO( :, 2, 9, 4) = (/&
&2.4931E-04_JPRB,8.3843E-04_JPRB,1.1135E-03_JPRB,1.2777E-03_JPRB,1.3549E-03_JPRB,1.3735E-03_JPRB,&
&1.3267E-03_JPRB,1.1784E-03_JPRB,1.0225E-03_JPRB,2.0725E-03_JPRB/)
KAO( :, 3, 9, 4) = (/&
&3.3739E-04_JPRB,1.0997E-03_JPRB,1.4388E-03_JPRB,1.6275E-03_JPRB,1.7095E-03_JPRB,1.7064E-03_JPRB,&
&1.6276E-03_JPRB,1.4244E-03_JPRB,1.0196E-03_JPRB,2.3196E-03_JPRB/)
KAO( :, 4, 9, 4) = (/&
&4.6000E-04_JPRB,1.4414E-03_JPRB,1.8531E-03_JPRB,2.0634E-03_JPRB,2.1453E-03_JPRB,2.1162E-03_JPRB,&
&1.9970E-03_JPRB,1.7248E-03_JPRB,1.1677E-03_JPRB,2.6078E-03_JPRB/)
KAO( :, 5, 9, 4) = (/&
&6.2819E-04_JPRB,1.8702E-03_JPRB,2.3574E-03_JPRB,2.5903E-03_JPRB,2.6704E-03_JPRB,2.6214E-03_JPRB,&
&2.4477E-03_JPRB,2.0914E-03_JPRB,1.3608E-03_JPRB,2.9294E-03_JPRB/)
KAO( :, 1,10, 4) = (/&
&1.4307E-04_JPRB,4.7989E-04_JPRB,6.4527E-04_JPRB,7.5154E-04_JPRB,8.0960E-04_JPRB,8.4090E-04_JPRB,&
&8.3086E-04_JPRB,7.6874E-04_JPRB,8.2863E-04_JPRB,3.6347E-03_JPRB/)
KAO( :, 2,10, 4) = (/&
&1.9105E-04_JPRB,6.2858E-04_JPRB,8.3500E-04_JPRB,9.5991E-04_JPRB,1.0185E-03_JPRB,1.0393E-03_JPRB,&
&1.0095E-03_JPRB,9.0118E-04_JPRB,8.3114E-04_JPRB,4.2294E-03_JPRB/)
KAO( :, 3,10, 4) = (/&
&2.5819E-04_JPRB,8.2975E-04_JPRB,1.0848E-03_JPRB,1.2290E-03_JPRB,1.2908E-03_JPRB,1.2943E-03_JPRB,&
&1.2407E-03_JPRB,1.0947E-03_JPRB,8.4507E-04_JPRB,4.7942E-03_JPRB/)
KAO( :, 4,10, 4) = (/&
&3.5175E-04_JPRB,1.0966E-03_JPRB,1.4090E-03_JPRB,1.5695E-03_JPRB,1.6301E-03_JPRB,1.6125E-03_JPRB,&
&1.5271E-03_JPRB,1.3244E-03_JPRB,8.9574E-04_JPRB,5.3326E-03_JPRB/)
KAO( :, 5,10, 4) = (/&
&4.8140E-04_JPRB,1.4355E-03_JPRB,1.8096E-03_JPRB,1.9894E-03_JPRB,2.0475E-03_JPRB,2.0080E-03_JPRB,&
&1.8768E-03_JPRB,1.6118E-03_JPRB,1.0323E-03_JPRB,5.8712E-03_JPRB/)
KAO( :, 1,11, 4) = (/&
&1.2480E-04_JPRB,4.0651E-04_JPRB,5.4317E-04_JPRB,6.3057E-04_JPRB,6.7711E-04_JPRB,7.0124E-04_JPRB,&
&6.9230E-04_JPRB,6.3637E-04_JPRB,6.7480E-04_JPRB,4.4748E-03_JPRB/)
KAO( :, 2,11, 4) = (/&
&1.6789E-04_JPRB,5.3657E-04_JPRB,7.0675E-04_JPRB,8.0798E-04_JPRB,8.5575E-04_JPRB,8.7116E-04_JPRB,&
&8.4422E-04_JPRB,7.5306E-04_JPRB,6.8219E-04_JPRB,5.2484E-03_JPRB/)
KAO( :, 3,11, 4) = (/&
&2.2748E-04_JPRB,7.1324E-04_JPRB,9.2430E-04_JPRB,1.0391E-03_JPRB,1.0880E-03_JPRB,1.0885E-03_JPRB,&
&1.0414E-03_JPRB,9.1761E-04_JPRB,6.9310E-04_JPRB,5.9997E-03_JPRB/)
KAO( :, 4,11, 4) = (/&
&3.1100E-04_JPRB,9.4662E-04_JPRB,1.2062E-03_JPRB,1.3345E-03_JPRB,1.3806E-03_JPRB,1.3616E-03_JPRB,&
&1.2842E-03_JPRB,1.1132E-03_JPRB,7.5183E-04_JPRB,6.7275E-03_JPRB/)
KAO( :, 5,11, 4) = (/&
&4.2632E-04_JPRB,1.2375E-03_JPRB,1.5507E-03_JPRB,1.6996E-03_JPRB,1.7428E-03_JPRB,1.7046E-03_JPRB,&
&1.5835E-03_JPRB,1.3580E-03_JPRB,8.6852E-04_JPRB,7.4572E-03_JPRB/)
KAO( :, 1,12, 4) = (/&
&1.0738E-04_JPRB,3.4370E-04_JPRB,4.5561E-04_JPRB,5.2712E-04_JPRB,5.6512E-04_JPRB,5.8418E-04_JPRB,&
&5.7608E-04_JPRB,5.2824E-04_JPRB,5.5584E-04_JPRB,4.5229E-03_JPRB/)
KAO( :, 2,12, 4) = (/&
&1.4509E-04_JPRB,4.5719E-04_JPRB,5.9628E-04_JPRB,6.7809E-04_JPRB,7.1697E-04_JPRB,7.2848E-04_JPRB,&
&7.0565E-04_JPRB,6.2997E-04_JPRB,5.6436E-04_JPRB,5.3156E-03_JPRB/)
KAO( :, 3,12, 4) = (/&
&1.9783E-04_JPRB,6.1167E-04_JPRB,7.8481E-04_JPRB,8.7764E-04_JPRB,9.1476E-04_JPRB,9.1298E-04_JPRB,&
&8.7252E-04_JPRB,7.6652E-04_JPRB,5.7011E-04_JPRB,6.0757E-03_JPRB/)
KAO( :, 4,12, 4) = (/&
&2.7192E-04_JPRB,8.1173E-04_JPRB,1.0265E-03_JPRB,1.1333E-03_JPRB,1.1680E-03_JPRB,1.1490E-03_JPRB,&
&1.0784E-03_JPRB,9.3361E-04_JPRB,6.2718E-04_JPRB,6.8113E-03_JPRB/)
KAO( :, 5,12, 4) = (/&
&3.7397E-04_JPRB,1.0598E-03_JPRB,1.3197E-03_JPRB,1.4449E-03_JPRB,1.4799E-03_JPRB,1.4465E-03_JPRB,&
&1.3362E-03_JPRB,1.1407E-03_JPRB,7.2415E-04_JPRB,7.5425E-03_JPRB/)
KAO( :, 1,13, 4) = (/&
&8.9292E-05_JPRB,2.8719E-04_JPRB,3.7864E-04_JPRB,4.3694E-04_JPRB,4.6878E-04_JPRB,4.8461E-04_JPRB,&
&4.7788E-04_JPRB,4.3842E-04_JPRB,4.5719E-04_JPRB,3.8416E-03_JPRB/)
KAO( :, 2,13, 4) = (/&
&1.2149E-04_JPRB,3.8537E-04_JPRB,4.9918E-04_JPRB,5.6557E-04_JPRB,5.9698E-04_JPRB,6.0549E-04_JPRB,&
&5.8708E-04_JPRB,5.2472E-04_JPRB,4.6787E-04_JPRB,4.4931E-03_JPRB/)
KAO( :, 3,13, 4) = (/&
&1.6719E-04_JPRB,5.1756E-04_JPRB,6.6044E-04_JPRB,7.3666E-04_JPRB,7.6591E-04_JPRB,7.6260E-04_JPRB,&
&7.2753E-04_JPRB,6.3867E-04_JPRB,4.6954E-04_JPRB,5.0961E-03_JPRB/)
KAO( :, 4,13, 4) = (/&
&2.3161E-04_JPRB,6.8759E-04_JPRB,8.6435E-04_JPRB,9.5388E-04_JPRB,9.8295E-04_JPRB,9.6568E-04_JPRB,&
&9.0300E-04_JPRB,7.7979E-04_JPRB,5.2227E-04_JPRB,5.6855E-03_JPRB/)
KAO( :, 5,13, 4) = (/&
&3.2057E-04_JPRB,8.9923E-04_JPRB,1.1130E-03_JPRB,1.2171E-03_JPRB,1.2465E-03_JPRB,1.2193E-03_JPRB,&
&1.1245E-03_JPRB,9.5521E-04_JPRB,6.0646E-04_JPRB,6.2875E-03_JPRB/)
KAO( :, 1, 1, 5) = (/&
&7.8581E-03_JPRB,1.6359E-02_JPRB,1.8747E-02_JPRB,1.9104E-02_JPRB,1.8493E-02_JPRB,1.7453E-02_JPRB,&
&1.6124E-02_JPRB,1.4436E-02_JPRB,9.9634E-03_JPRB,9.0266E-03_JPRB/)
KAO( :, 2, 1, 5) = (/&
&1.0248E-02_JPRB,1.9930E-02_JPRB,2.2543E-02_JPRB,2.2901E-02_JPRB,2.2187E-02_JPRB,2.0954E-02_JPRB,&
&1.9379E-02_JPRB,1.7194E-02_JPRB,1.1961E-02_JPRB,1.0706E-02_JPRB/)
KAO( :, 3, 1, 5) = (/&
&1.3096E-02_JPRB,2.3888E-02_JPRB,2.6739E-02_JPRB,2.7195E-02_JPRB,2.6433E-02_JPRB,2.4936E-02_JPRB,&
&2.3046E-02_JPRB,2.0295E-02_JPRB,1.4106E-02_JPRB,1.2544E-02_JPRB/)
KAO( :, 4, 1, 5) = (/&
&1.6338E-02_JPRB,2.8329E-02_JPRB,3.1500E-02_JPRB,3.2047E-02_JPRB,3.1151E-02_JPRB,2.9395E-02_JPRB,&
&2.7258E-02_JPRB,2.3909E-02_JPRB,1.6479E-02_JPRB,1.4541E-02_JPRB/)
KAO( :, 5, 1, 5) = (/&
&1.9905E-02_JPRB,3.3267E-02_JPRB,3.6925E-02_JPRB,3.7523E-02_JPRB,3.6460E-02_JPRB,3.4480E-02_JPRB,&
&3.1939E-02_JPRB,2.7924E-02_JPRB,1.9096E-02_JPRB,1.6820E-02_JPRB/)
KAO( :, 1, 2, 5) = (/&
&6.5000E-03_JPRB,1.3210E-02_JPRB,1.5017E-02_JPRB,1.5338E-02_JPRB,1.4894E-02_JPRB,1.4046E-02_JPRB,&
&1.2886E-02_JPRB,1.1485E-02_JPRB,7.8396E-03_JPRB,6.9835E-03_JPRB/)
KAO( :, 2, 2, 5) = (/&
&8.5060E-03_JPRB,1.6246E-02_JPRB,1.8196E-02_JPRB,1.8546E-02_JPRB,1.7999E-02_JPRB,1.6962E-02_JPRB,&
&1.5570E-02_JPRB,1.3759E-02_JPRB,9.5004E-03_JPRB,8.2524E-03_JPRB/)
KAO( :, 3, 2, 5) = (/&
&1.0895E-02_JPRB,1.9629E-02_JPRB,2.1801E-02_JPRB,2.2202E-02_JPRB,2.1571E-02_JPRB,2.0287E-02_JPRB,&
&1.8619E-02_JPRB,1.6336E-02_JPRB,1.1311E-02_JPRB,9.6763E-03_JPRB/)
KAO( :, 4, 2, 5) = (/&
&1.3634E-02_JPRB,2.3467E-02_JPRB,2.5938E-02_JPRB,2.6385E-02_JPRB,2.5626E-02_JPRB,2.4039E-02_JPRB,&
&2.2108E-02_JPRB,1.9320E-02_JPRB,1.3277E-02_JPRB,1.1254E-02_JPRB/)
KAO( :, 5, 2, 5) = (/&
&1.6643E-02_JPRB,2.7789E-02_JPRB,3.0666E-02_JPRB,3.1149E-02_JPRB,3.0178E-02_JPRB,2.8317E-02_JPRB,&
&2.6023E-02_JPRB,2.2644E-02_JPRB,1.5438E-02_JPRB,1.3058E-02_JPRB/)
KAO( :, 1, 3, 5) = (/&
&5.1068E-03_JPRB,1.0155E-02_JPRB,1.1485E-02_JPRB,1.1770E-02_JPRB,1.1484E-02_JPRB,1.0823E-02_JPRB,&
&9.8623E-03_JPRB,8.7594E-03_JPRB,5.9958E-03_JPRB,5.2611E-03_JPRB/)
KAO( :, 2, 3, 5) = (/&
&6.6835E-03_JPRB,1.2640E-02_JPRB,1.4084E-02_JPRB,1.4382E-02_JPRB,1.4023E-02_JPRB,1.3192E-02_JPRB,&
&1.2012E-02_JPRB,1.0560E-02_JPRB,7.2917E-03_JPRB,6.1864E-03_JPRB/)
KAO( :, 3, 3, 5) = (/&
&8.6033E-03_JPRB,1.5444E-02_JPRB,1.7069E-02_JPRB,1.7437E-02_JPRB,1.6940E-02_JPRB,1.5900E-02_JPRB,&
&1.4464E-02_JPRB,1.2619E-02_JPRB,8.8116E-03_JPRB,7.2531E-03_JPRB/)
KAO( :, 4, 3, 5) = (/&
&1.0832E-02_JPRB,1.8665E-02_JPRB,2.0521E-02_JPRB,2.0939E-02_JPRB,2.0314E-02_JPRB,1.9000E-02_JPRB,&
&1.7289E-02_JPRB,1.5015E-02_JPRB,1.0355E-02_JPRB,8.4725E-03_JPRB/)
KAO( :, 5, 3, 5) = (/&
&1.3328E-02_JPRB,2.2307E-02_JPRB,2.4508E-02_JPRB,2.4967E-02_JPRB,2.4135E-02_JPRB,2.2494E-02_JPRB,&
&2.0482E-02_JPRB,1.7714E-02_JPRB,1.2161E-02_JPRB,9.8543E-03_JPRB/)
KAO( :, 1, 4, 5) = (/&
&3.9695E-03_JPRB,7.6818E-03_JPRB,8.6331E-03_JPRB,8.8728E-03_JPRB,8.6847E-03_JPRB,8.1743E-03_JPRB,&
&7.4171E-03_JPRB,6.5733E-03_JPRB,4.6756E-03_JPRB,4.0395E-03_JPRB/)
KAO( :, 2, 4, 5) = (/&
&5.1871E-03_JPRB,9.6669E-03_JPRB,1.0730E-02_JPRB,1.0984E-02_JPRB,1.0727E-02_JPRB,1.0079E-02_JPRB,&
&9.1130E-03_JPRB,7.9640E-03_JPRB,5.5230E-03_JPRB,4.7457E-03_JPRB/)
KAO( :, 3, 4, 5) = (/&
&6.6872E-03_JPRB,1.1936E-02_JPRB,1.3150E-02_JPRB,1.3447E-02_JPRB,1.3090E-02_JPRB,1.2266E-02_JPRB,&
&1.1082E-02_JPRB,9.5819E-03_JPRB,6.7239E-03_JPRB,5.5582E-03_JPRB/)
KAO( :, 4, 4, 5) = (/&
&8.4686E-03_JPRB,1.4558E-02_JPRB,1.5982E-02_JPRB,1.6346E-02_JPRB,1.5841E-02_JPRB,1.4783E-02_JPRB,&
&1.3331E-02_JPRB,1.1473E-02_JPRB,7.9455E-03_JPRB,6.5009E-03_JPRB/)
KAO( :, 5, 4, 5) = (/&
&1.0530E-02_JPRB,1.7532E-02_JPRB,1.9245E-02_JPRB,1.9697E-02_JPRB,1.9021E-02_JPRB,1.7663E-02_JPRB,&
&1.5910E-02_JPRB,1.3642E-02_JPRB,9.4173E-03_JPRB,7.5638E-03_JPRB/)
KAO( :, 1, 5, 5) = (/&
&3.1180E-03_JPRB,5.8209E-03_JPRB,6.4854E-03_JPRB,6.6644E-03_JPRB,6.5380E-03_JPRB,6.1410E-03_JPRB,&
&5.5609E-03_JPRB,4.9182E-03_JPRB,3.5969E-03_JPRB,3.1582E-03_JPRB/)
KAO( :, 2, 5, 5) = (/&
&4.0549E-03_JPRB,7.3757E-03_JPRB,8.1520E-03_JPRB,8.3497E-03_JPRB,8.1550E-03_JPRB,7.6434E-03_JPRB,&
&6.8934E-03_JPRB,5.9840E-03_JPRB,4.1290E-03_JPRB,3.6940E-03_JPRB/)
KAO( :, 3, 5, 5) = (/&
&5.2180E-03_JPRB,9.1787E-03_JPRB,1.0116E-02_JPRB,1.0335E-02_JPRB,1.0048E-02_JPRB,9.4058E-03_JPRB,&
&8.4592E-03_JPRB,7.2447E-03_JPRB,5.0478E-03_JPRB,4.3308E-03_JPRB/)
KAO( :, 4, 5, 5) = (/&
&6.6347E-03_JPRB,1.1285E-02_JPRB,1.2392E-02_JPRB,1.2680E-02_JPRB,1.2274E-02_JPRB,1.1447E-02_JPRB,&
&1.0271E-02_JPRB,8.7310E-03_JPRB,6.0849E-03_JPRB,5.0691E-03_JPRB/)
KAO( :, 5, 5, 5) = (/&
&8.3131E-03_JPRB,1.3706E-02_JPRB,1.5023E-02_JPRB,1.5394E-02_JPRB,1.4880E-02_JPRB,1.3810E-02_JPRB,&
&1.2359E-02_JPRB,1.0459E-02_JPRB,7.2538E-03_JPRB,5.9083E-03_JPRB/)
KAO( :, 1, 6, 5) = (/&
&2.4113E-03_JPRB,4.4035E-03_JPRB,4.8584E-03_JPRB,4.9702E-03_JPRB,4.8652E-03_JPRB,4.5631E-03_JPRB,&
&4.1282E-03_JPRB,3.6475E-03_JPRB,2.6495E-03_JPRB,2.6380E-03_JPRB/)
KAO( :, 2, 6, 5) = (/&
&3.1417E-03_JPRB,5.6041E-03_JPRB,6.1552E-03_JPRB,6.2788E-03_JPRB,6.1209E-03_JPRB,5.7279E-03_JPRB,&
&5.1621E-03_JPRB,4.4647E-03_JPRB,3.1333E-03_JPRB,3.0490E-03_JPRB/)
KAO( :, 3, 6, 5) = (/&
&4.0523E-03_JPRB,7.0107E-03_JPRB,7.6974E-03_JPRB,7.8556E-03_JPRB,7.6249E-03_JPRB,7.1228E-03_JPRB,&
&6.3982E-03_JPRB,5.4412E-03_JPRB,3.7354E-03_JPRB,3.5351E-03_JPRB/)
KAO( :, 4, 6, 5) = (/&
&5.1735E-03_JPRB,8.6714E-03_JPRB,9.5046E-03_JPRB,9.7062E-03_JPRB,9.3937E-03_JPRB,8.7514E-03_JPRB,&
&7.8427E-03_JPRB,6.5998E-03_JPRB,4.6231E-03_JPRB,4.0931E-03_JPRB/)
KAO( :, 5, 6, 5) = (/&
&6.5266E-03_JPRB,1.0615E-02_JPRB,1.1603E-02_JPRB,1.1862E-02_JPRB,1.1470E-02_JPRB,1.0665E-02_JPRB,&
&9.5307E-03_JPRB,7.9589E-03_JPRB,5.4908E-03_JPRB,4.7354E-03_JPRB/)
KAO( :, 1, 7, 5) = (/&
&1.8313E-03_JPRB,3.2981E-03_JPRB,3.6334E-03_JPRB,3.7067E-03_JPRB,3.6201E-03_JPRB,3.3912E-03_JPRB,&
&3.0679E-03_JPRB,2.7066E-03_JPRB,2.0241E-03_JPRB,2.2554E-03_JPRB/)
KAO( :, 2, 7, 5) = (/&
&2.3976E-03_JPRB,4.2444E-03_JPRB,4.6442E-03_JPRB,4.7217E-03_JPRB,4.5915E-03_JPRB,4.2847E-03_JPRB,&
&3.8546E-03_JPRB,3.3328E-03_JPRB,2.4081E-03_JPRB,2.5954E-03_JPRB/)
KAO( :, 3, 7, 5) = (/&
&3.1184E-03_JPRB,5.3559E-03_JPRB,5.8460E-03_JPRB,5.9451E-03_JPRB,5.7583E-03_JPRB,5.3717E-03_JPRB,&
&4.8180E-03_JPRB,4.0888E-03_JPRB,2.7879E-03_JPRB,3.0032E-03_JPRB/)
KAO( :, 4, 7, 5) = (/&
&4.0216E-03_JPRB,6.6605E-03_JPRB,7.2700E-03_JPRB,7.4007E-03_JPRB,7.1549E-03_JPRB,6.6561E-03_JPRB,&
&5.9599E-03_JPRB,4.9929E-03_JPRB,3.4384E-03_JPRB,3.4860E-03_JPRB/)
KAO( :, 5, 7, 5) = (/&
&5.1206E-03_JPRB,8.2127E-03_JPRB,8.9364E-03_JPRB,9.0944E-03_JPRB,8.7960E-03_JPRB,8.1717E-03_JPRB,&
&7.3059E-03_JPRB,6.0651E-03_JPRB,4.1362E-03_JPRB,4.0383E-03_JPRB/)
KAO( :, 1, 8, 5) = (/&
&1.3678E-03_JPRB,2.4344E-03_JPRB,2.6771E-03_JPRB,2.7314E-03_JPRB,2.6764E-03_JPRB,2.5199E-03_JPRB,&
&2.2892E-03_JPRB,2.0146E-03_JPRB,1.5158E-03_JPRB,2.0717E-03_JPRB/)
KAO( :, 2, 8, 5) = (/&
&1.7986E-03_JPRB,3.1721E-03_JPRB,3.4698E-03_JPRB,3.5325E-03_JPRB,3.4383E-03_JPRB,3.2125E-03_JPRB,&
&2.8853E-03_JPRB,2.4940E-03_JPRB,1.7790E-03_JPRB,2.3653E-03_JPRB/)
KAO( :, 3, 8, 5) = (/&
&2.3644E-03_JPRB,4.0587E-03_JPRB,4.4194E-03_JPRB,4.4912E-03_JPRB,4.3505E-03_JPRB,4.0574E-03_JPRB,&
&3.6294E-03_JPRB,3.0753E-03_JPRB,2.0908E-03_JPRB,2.7075E-03_JPRB/)
KAO( :, 4, 8, 5) = (/&
&3.0885E-03_JPRB,5.1052E-03_JPRB,5.5511E-03_JPRB,5.6359E-03_JPRB,5.4460E-03_JPRB,5.0617E-03_JPRB,&
&4.5202E-03_JPRB,3.7834E-03_JPRB,2.5293E-03_JPRB,3.1178E-03_JPRB/)
KAO( :, 5, 8, 5) = (/&
&3.9843E-03_JPRB,6.3521E-03_JPRB,6.8780E-03_JPRB,6.9729E-03_JPRB,6.7374E-03_JPRB,6.2484E-03_JPRB,&
&5.5746E-03_JPRB,4.6304E-03_JPRB,3.1216E-03_JPRB,3.5944E-03_JPRB/)
KAO( :, 1, 9, 5) = (/&
&1.0180E-03_JPRB,1.7808E-03_JPRB,1.9513E-03_JPRB,1.9917E-03_JPRB,1.9571E-03_JPRB,1.8568E-03_JPRB,&
&1.7034E-03_JPRB,1.5143E-03_JPRB,1.2324E-03_JPRB,2.9566E-03_JPRB/)
KAO( :, 2, 9, 5) = (/&
&1.3409E-03_JPRB,2.3491E-03_JPRB,2.5644E-03_JPRB,2.6103E-03_JPRB,2.5515E-03_JPRB,2.3969E-03_JPRB,&
&2.1596E-03_JPRB,1.8679E-03_JPRB,1.3632E-03_JPRB,3.3317E-03_JPRB/)
KAO( :, 3, 9, 5) = (/&
&1.7770E-03_JPRB,3.0450E-03_JPRB,3.3094E-03_JPRB,3.3641E-03_JPRB,3.2693E-03_JPRB,3.0590E-03_JPRB,&
&2.7358E-03_JPRB,2.3083E-03_JPRB,1.6204E-03_JPRB,3.7464E-03_JPRB/)
KAO( :, 4, 9, 5) = (/&
&2.3520E-03_JPRB,3.8805E-03_JPRB,4.2090E-03_JPRB,4.2722E-03_JPRB,4.1362E-03_JPRB,3.8521E-03_JPRB,&
&3.4256E-03_JPRB,2.8568E-03_JPRB,1.8732E-03_JPRB,4.2061E-03_JPRB/)
KAO( :, 5, 9, 5) = (/&
&3.0729E-03_JPRB,4.8855E-03_JPRB,5.2770E-03_JPRB,5.3379E-03_JPRB,5.1589E-03_JPRB,4.7790E-03_JPRB,&
&4.2478E-03_JPRB,3.5241E-03_JPRB,2.3400E-03_JPRB,4.7374E-03_JPRB/)
KAO( :, 1,10, 5) = (/&
&7.7253E-04_JPRB,1.3219E-03_JPRB,1.4421E-03_JPRB,1.4740E-03_JPRB,1.4539E-03_JPRB,1.3876E-03_JPRB,&
&1.2853E-03_JPRB,1.1567E-03_JPRB,1.0022E-03_JPRB,6.8847E-03_JPRB/)
KAO( :, 2,10, 5) = (/&
&1.0173E-03_JPRB,1.7625E-03_JPRB,1.9200E-03_JPRB,1.9559E-03_JPRB,1.9175E-03_JPRB,1.8087E-03_JPRB,&
&1.6367E-03_JPRB,1.4242E-03_JPRB,1.0394E-03_JPRB,7.5328E-03_JPRB/)
KAO( :, 3,10, 5) = (/&
&1.3564E-03_JPRB,2.3122E-03_JPRB,2.5093E-03_JPRB,2.5497E-03_JPRB,2.4848E-03_JPRB,2.3312E-03_JPRB,&
&2.0902E-03_JPRB,1.7668E-03_JPRB,1.2230E-03_JPRB,8.3126E-03_JPRB/)
KAO( :, 4,10, 5) = (/&
&1.8134E-03_JPRB,2.9832E-03_JPRB,3.2264E-03_JPRB,3.2755E-03_JPRB,3.1788E-03_JPRB,2.9672E-03_JPRB,&
&2.6373E-03_JPRB,2.1956E-03_JPRB,1.4206E-03_JPRB,9.1949E-03_JPRB/)
KAO( :, 5,10, 5) = (/&
&2.3982E-03_JPRB,3.8024E-03_JPRB,4.0921E-03_JPRB,4.1370E-03_JPRB,4.0025E-03_JPRB,3.7132E-03_JPRB,&
&3.2913E-03_JPRB,2.7187E-03_JPRB,1.7437E-03_JPRB,1.0174E-02_JPRB/)
KAO( :, 1,11, 5) = (/&
&6.6311E-04_JPRB,1.1233E-03_JPRB,1.2219E-03_JPRB,1.2485E-03_JPRB,1.2298E-03_JPRB,1.1731E-03_JPRB,&
&1.0818E-03_JPRB,9.6812E-04_JPRB,8.2277E-04_JPRB,9.1151E-03_JPRB/)
KAO( :, 2,11, 5) = (/&
&8.7961E-04_JPRB,1.5044E-03_JPRB,1.6329E-03_JPRB,1.6631E-03_JPRB,1.6279E-03_JPRB,1.5346E-03_JPRB,&
&1.3878E-03_JPRB,1.1990E-03_JPRB,8.6844E-04_JPRB,9.9636E-03_JPRB/)
KAO( :, 3,11, 5) = (/&
&1.1836E-03_JPRB,1.9811E-03_JPRB,2.1444E-03_JPRB,2.1783E-03_JPRB,2.1211E-03_JPRB,1.9859E-03_JPRB,&
&1.7780E-03_JPRB,1.4952E-03_JPRB,1.0190E-03_JPRB,1.0941E-02_JPRB/)
KAO( :, 4,11, 5) = (/&
&1.5905E-03_JPRB,2.5713E-03_JPRB,2.7694E-03_JPRB,2.8087E-03_JPRB,2.7235E-03_JPRB,2.5357E-03_JPRB,&
&2.2512E-03_JPRB,1.8676E-03_JPRB,1.1718E-03_JPRB,1.2060E-02_JPRB/)
KAO( :, 5,11, 5) = (/&
&2.1118E-03_JPRB,3.3009E-03_JPRB,3.5298E-03_JPRB,3.5548E-03_JPRB,3.4369E-03_JPRB,3.1821E-03_JPRB,&
&2.8194E-03_JPRB,2.3141E-03_JPRB,1.4442E-03_JPRB,1.3285E-02_JPRB/)
KAO( :, 1,12, 5) = (/&
&5.6477E-04_JPRB,9.5054E-04_JPRB,1.0327E-03_JPRB,1.0546E-03_JPRB,1.0374E-03_JPRB,9.8870E-04_JPRB,&
&9.0992E-04_JPRB,8.0701E-04_JPRB,6.7076E-04_JPRB,9.4607E-03_JPRB/)
KAO( :, 2,12, 5) = (/&
&7.5728E-04_JPRB,1.2785E-03_JPRB,1.3875E-03_JPRB,1.4113E-03_JPRB,1.3782E-03_JPRB,1.2986E-03_JPRB,&
&1.1731E-03_JPRB,1.0074E-03_JPRB,7.2589E-04_JPRB,1.0331E-02_JPRB/)
KAO( :, 3,12, 5) = (/&
&1.0261E-03_JPRB,1.6921E-03_JPRB,1.8295E-03_JPRB,1.8570E-03_JPRB,1.8051E-03_JPRB,1.6888E-03_JPRB,&
&1.5086E-03_JPRB,1.2626E-03_JPRB,8.4339E-04_JPRB,1.1368E-02_JPRB/)
KAO( :, 4,12, 5) = (/&
&1.3869E-03_JPRB,2.2095E-03_JPRB,2.3736E-03_JPRB,2.4008E-03_JPRB,2.3247E-03_JPRB,2.1615E-03_JPRB,&
&1.9167E-03_JPRB,1.5821E-03_JPRB,9.6809E-04_JPRB,1.2545E-02_JPRB/)
KAO( :, 5,12, 5) = (/&
&1.8434E-03_JPRB,2.8588E-03_JPRB,3.0424E-03_JPRB,3.0524E-03_JPRB,2.9442E-03_JPRB,2.7194E-03_JPRB,&
&2.4068E-03_JPRB,1.9656E-03_JPRB,1.2057E-03_JPRB,1.3846E-02_JPRB/)
KAO( :, 1,13, 5) = (/&
&4.7278E-04_JPRB,7.9552E-04_JPRB,8.6502E-04_JPRB,8.8337E-04_JPRB,8.6881E-04_JPRB,8.2802E-04_JPRB,&
&7.6164E-04_JPRB,6.7146E-04_JPRB,5.4706E-04_JPRB,7.8912E-03_JPRB/)
KAO( :, 2,13, 5) = (/&
&6.4178E-04_JPRB,1.0759E-03_JPRB,1.1686E-03_JPRB,1.1883E-03_JPRB,1.1601E-03_JPRB,1.0935E-03_JPRB,&
&9.8725E-04_JPRB,8.4294E-04_JPRB,6.0294E-04_JPRB,8.6805E-03_JPRB/)
KAO( :, 3,13, 5) = (/&
&8.7757E-04_JPRB,1.4325E-03_JPRB,1.5486E-03_JPRB,1.5698E-03_JPRB,1.5267E-03_JPRB,1.4283E-03_JPRB,&
&1.2744E-03_JPRB,1.0604E-03_JPRB,6.9497E-04_JPRB,9.6337E-03_JPRB/)
KAO( :, 4,13, 5) = (/&
&1.1912E-03_JPRB,1.8857E-03_JPRB,2.0225E-03_JPRB,2.0388E-03_JPRB,1.9725E-03_JPRB,1.8334E-03_JPRB,&
&1.6247E-03_JPRB,1.3326E-03_JPRB,8.0026E-04_JPRB,1.0694E-02_JPRB/)
KAO( :, 5,13, 5) = (/&
&1.5846E-03_JPRB,2.4545E-03_JPRB,2.6070E-03_JPRB,2.6093E-03_JPRB,2.5111E-03_JPRB,2.3151E-03_JPRB,&
&2.0441E-03_JPRB,1.6606E-03_JPRB,1.0091E-03_JPRB,1.1828E-02_JPRB/)
KAO( :, 1, 1, 6) = (/&
&2.7778E-02_JPRB,3.3405E-02_JPRB,3.5267E-02_JPRB,3.6006E-02_JPRB,3.5898E-02_JPRB,3.4553E-02_JPRB,&
&3.1100E-02_JPRB,2.5014E-02_JPRB,1.8094E-02_JPRB,1.6794E-02_JPRB/)
KAO( :, 2, 1, 6) = (/&
&3.3366E-02_JPRB,4.0235E-02_JPRB,4.2608E-02_JPRB,4.3370E-02_JPRB,4.2914E-02_JPRB,4.1247E-02_JPRB,&
&3.7064E-02_JPRB,2.9946E-02_JPRB,2.1940E-02_JPRB,2.0091E-02_JPRB/)
KAO( :, 3, 1, 6) = (/&
&3.9476E-02_JPRB,4.7919E-02_JPRB,5.0670E-02_JPRB,5.1321E-02_JPRB,5.0664E-02_JPRB,4.8610E-02_JPRB,&
&4.3793E-02_JPRB,3.5486E-02_JPRB,2.6228E-02_JPRB,2.3816E-02_JPRB/)
KAO( :, 4, 1, 6) = (/&
&4.6165E-02_JPRB,5.6406E-02_JPRB,5.9353E-02_JPRB,6.0117E-02_JPRB,5.9468E-02_JPRB,5.6918E-02_JPRB,&
&5.1329E-02_JPRB,4.1643E-02_JPRB,3.1155E-02_JPRB,2.8224E-02_JPRB/)
KAO( :, 5, 1, 6) = (/&
&5.3590E-02_JPRB,6.5676E-02_JPRB,6.8956E-02_JPRB,6.9882E-02_JPRB,6.9299E-02_JPRB,6.6139E-02_JPRB,&
&5.9733E-02_JPRB,4.8638E-02_JPRB,3.6701E-02_JPRB,3.3219E-02_JPRB/)
KAO( :, 1, 2, 6) = (/&
&2.2559E-02_JPRB,2.7654E-02_JPRB,2.9015E-02_JPRB,2.9337E-02_JPRB,2.9078E-02_JPRB,2.7937E-02_JPRB,&
&2.5189E-02_JPRB,2.0404E-02_JPRB,1.4144E-02_JPRB,1.2909E-02_JPRB/)
KAO( :, 2, 2, 6) = (/&
&2.7361E-02_JPRB,3.3523E-02_JPRB,3.5340E-02_JPRB,3.5540E-02_JPRB,3.5037E-02_JPRB,3.3575E-02_JPRB,&
&3.0234E-02_JPRB,2.4558E-02_JPRB,1.7358E-02_JPRB,1.5458E-02_JPRB/)
KAO( :, 3, 2, 6) = (/&
&3.2702E-02_JPRB,4.0222E-02_JPRB,4.2266E-02_JPRB,4.2370E-02_JPRB,4.1690E-02_JPRB,3.9887E-02_JPRB,&
&3.5945E-02_JPRB,2.9242E-02_JPRB,2.0872E-02_JPRB,1.8389E-02_JPRB/)
KAO( :, 4, 2, 6) = (/&
&3.8698E-02_JPRB,4.7703E-02_JPRB,4.9874E-02_JPRB,5.0037E-02_JPRB,4.9234E-02_JPRB,4.7000E-02_JPRB,&
&4.2355E-02_JPRB,3.4462E-02_JPRB,2.4936E-02_JPRB,2.1874E-02_JPRB/)
KAO( :, 5, 2, 6) = (/&
&4.5406E-02_JPRB,5.5864E-02_JPRB,5.8250E-02_JPRB,5.8611E-02_JPRB,5.7701E-02_JPRB,5.4940E-02_JPRB,&
&4.9541E-02_JPRB,4.0425E-02_JPRB,2.9498E-02_JPRB,2.5824E-02_JPRB/)
KAO( :, 1, 3, 6) = (/&
&1.7492E-02_JPRB,2.1787E-02_JPRB,2.2652E-02_JPRB,2.2750E-02_JPRB,2.2453E-02_JPRB,2.1534E-02_JPRB,&
&1.9495E-02_JPRB,1.5819E-02_JPRB,1.0602E-02_JPRB,9.5365E-03_JPRB/)
KAO( :, 2, 3, 6) = (/&
&2.1519E-02_JPRB,2.6731E-02_JPRB,2.7902E-02_JPRB,2.7864E-02_JPRB,2.7355E-02_JPRB,2.6151E-02_JPRB,&
&2.3624E-02_JPRB,1.9184E-02_JPRB,1.3144E-02_JPRB,1.1427E-02_JPRB/)
KAO( :, 3, 3, 6) = (/&
&2.6104E-02_JPRB,3.2391E-02_JPRB,3.3736E-02_JPRB,3.3545E-02_JPRB,3.2846E-02_JPRB,3.1374E-02_JPRB,&
&2.8297E-02_JPRB,2.2996E-02_JPRB,1.5964E-02_JPRB,1.3632E-02_JPRB/)
KAO( :, 4, 3, 6) = (/&
&3.1327E-02_JPRB,3.8767E-02_JPRB,4.0227E-02_JPRB,3.9993E-02_JPRB,3.9114E-02_JPRB,3.7263E-02_JPRB,&
&3.3562E-02_JPRB,2.7293E-02_JPRB,1.9234E-02_JPRB,1.6283E-02_JPRB/)
KAO( :, 5, 3, 6) = (/&
&3.7182E-02_JPRB,4.5791E-02_JPRB,4.7452E-02_JPRB,4.7270E-02_JPRB,4.6211E-02_JPRB,4.3900E-02_JPRB,&
&3.9502E-02_JPRB,3.2188E-02_JPRB,2.2900E-02_JPRB,1.9326E-02_JPRB/)
KAO( :, 1, 4, 6) = (/&
&1.3291E-02_JPRB,1.6678E-02_JPRB,1.7275E-02_JPRB,1.7278E-02_JPRB,1.6993E-02_JPRB,1.6286E-02_JPRB,&
&1.4822E-02_JPRB,1.1990E-02_JPRB,7.7579E-03_JPRB,7.1488E-03_JPRB/)
KAO( :, 2, 4, 6) = (/&
&1.6630E-02_JPRB,2.0815E-02_JPRB,2.1568E-02_JPRB,2.1440E-02_JPRB,2.0973E-02_JPRB,2.0006E-02_JPRB,&
&1.8126E-02_JPRB,1.4654E-02_JPRB,9.8329E-03_JPRB,8.5205E-03_JPRB/)
KAO( :, 3, 4, 6) = (/&
&2.0444E-02_JPRB,2.5553E-02_JPRB,2.6397E-02_JPRB,2.6132E-02_JPRB,2.5471E-02_JPRB,2.4223E-02_JPRB,&
&2.1910E-02_JPRB,1.7722E-02_JPRB,1.2155E-02_JPRB,1.0148E-02_JPRB/)
KAO( :, 4, 4, 6) = (/&
&2.4887E-02_JPRB,3.0959E-02_JPRB,3.1847E-02_JPRB,3.1469E-02_JPRB,3.0641E-02_JPRB,2.9051E-02_JPRB,&
&2.6190E-02_JPRB,2.1212E-02_JPRB,1.4767E-02_JPRB,1.2110E-02_JPRB/)
KAO( :, 5, 4, 6) = (/&
&2.9912E-02_JPRB,3.7010E-02_JPRB,3.8031E-02_JPRB,3.7546E-02_JPRB,3.6509E-02_JPRB,3.4523E-02_JPRB,&
&3.1009E-02_JPRB,2.5164E-02_JPRB,1.7705E-02_JPRB,1.4427E-02_JPRB/)
KAO( :, 1, 5, 6) = (/&
&1.0066E-02_JPRB,1.2668E-02_JPRB,1.3071E-02_JPRB,1.3029E-02_JPRB,1.2765E-02_JPRB,1.2217E-02_JPRB,&
&1.1148E-02_JPRB,9.0021E-03_JPRB,5.7587E-03_JPRB,5.4209E-03_JPRB/)
KAO( :, 2, 5, 6) = (/&
&1.2757E-02_JPRB,1.6015E-02_JPRB,1.6544E-02_JPRB,1.6397E-02_JPRB,1.5990E-02_JPRB,1.5234E-02_JPRB,&
&1.3789E-02_JPRB,1.1105E-02_JPRB,7.3967E-03_JPRB,6.5046E-03_JPRB/)
KAO( :, 3, 5, 6) = (/&
&1.5901E-02_JPRB,1.9963E-02_JPRB,2.0508E-02_JPRB,2.0254E-02_JPRB,1.9682E-02_JPRB,1.8644E-02_JPRB,&
&1.6821E-02_JPRB,1.3552E-02_JPRB,9.2356E-03_JPRB,7.7811E-03_JPRB/)
KAO( :, 4, 5, 6) = (/&
&1.9596E-02_JPRB,2.4499E-02_JPRB,2.5082E-02_JPRB,2.4696E-02_JPRB,2.3936E-02_JPRB,2.2580E-02_JPRB,&
&2.0269E-02_JPRB,1.6344E-02_JPRB,1.1321E-02_JPRB,9.3163E-03_JPRB/)
KAO( :, 5, 5, 6) = (/&
&2.3830E-02_JPRB,2.9650E-02_JPRB,3.0334E-02_JPRB,2.9811E-02_JPRB,2.8792E-02_JPRB,2.7070E-02_JPRB,&
&2.4166E-02_JPRB,1.9536E-02_JPRB,1.3665E-02_JPRB,1.1111E-02_JPRB/)
KAO( :, 1, 6, 6) = (/&
&7.6087E-03_JPRB,9.4951E-03_JPRB,9.7649E-03_JPRB,9.6943E-03_JPRB,9.4691E-03_JPRB,9.0311E-03_JPRB,&
&8.2249E-03_JPRB,6.6528E-03_JPRB,4.3378E-03_JPRB,4.2627E-03_JPRB/)
KAO( :, 2, 6, 6) = (/&
&9.7029E-03_JPRB,1.2146E-02_JPRB,1.2495E-02_JPRB,1.2394E-02_JPRB,1.2047E-02_JPRB,1.1438E-02_JPRB,&
&1.0329E-02_JPRB,8.2946E-03_JPRB,5.4267E-03_JPRB,5.0549E-03_JPRB/)
KAO( :, 3, 6, 6) = (/&
&1.2241E-02_JPRB,1.5353E-02_JPRB,1.5729E-02_JPRB,1.5534E-02_JPRB,1.5039E-02_JPRB,1.4188E-02_JPRB,&
&1.2727E-02_JPRB,1.0218E-02_JPRB,6.8803E-03_JPRB,6.0223E-03_JPRB/)
KAO( :, 4, 6, 6) = (/&
&1.5222E-02_JPRB,1.9088E-02_JPRB,1.9504E-02_JPRB,1.9213E-02_JPRB,1.8550E-02_JPRB,1.7379E-02_JPRB,&
&1.5483E-02_JPRB,1.2434E-02_JPRB,8.5170E-03_JPRB,7.2084E-03_JPRB/)
KAO( :, 5, 6, 6) = (/&
&1.8677E-02_JPRB,2.3384E-02_JPRB,2.3892E-02_JPRB,2.3510E-02_JPRB,2.2581E-02_JPRB,2.1034E-02_JPRB,&
&1.8630E-02_JPRB,1.4980E-02_JPRB,1.0415E-02_JPRB,8.6059E-03_JPRB/)
KAO( :, 1, 7, 6) = (/&
&5.7827E-03_JPRB,7.1313E-03_JPRB,7.2802E-03_JPRB,7.2045E-03_JPRB,6.9954E-03_JPRB,6.6269E-03_JPRB,&
&6.0097E-03_JPRB,4.8731E-03_JPRB,3.1264E-03_JPRB,3.7137E-03_JPRB/)
KAO( :, 2, 7, 6) = (/&
&7.4084E-03_JPRB,9.1887E-03_JPRB,9.4000E-03_JPRB,9.3096E-03_JPRB,9.0304E-03_JPRB,8.5190E-03_JPRB,&
&7.6733E-03_JPRB,6.1525E-03_JPRB,3.9263E-03_JPRB,4.3944E-03_JPRB/)
KAO( :, 3, 7, 6) = (/&
&9.4040E-03_JPRB,1.1717E-02_JPRB,1.1976E-02_JPRB,1.1835E-02_JPRB,1.1434E-02_JPRB,1.0726E-02_JPRB,&
&9.5804E-03_JPRB,7.6627E-03_JPRB,5.0656E-03_JPRB,5.1961E-03_JPRB/)
KAO( :, 4, 7, 6) = (/&
&1.1772E-02_JPRB,1.4730E-02_JPRB,1.5048E-02_JPRB,1.4854E-02_JPRB,1.4302E-02_JPRB,1.3320E-02_JPRB,&
&1.1779E-02_JPRB,9.4074E-03_JPRB,6.3725E-03_JPRB,6.1249E-03_JPRB/)
KAO( :, 5, 7, 6) = (/&
&1.4533E-02_JPRB,1.8234E-02_JPRB,1.8652E-02_JPRB,1.8417E-02_JPRB,1.7654E-02_JPRB,1.6319E-02_JPRB,&
&1.4317E-02_JPRB,1.1422E-02_JPRB,7.8881E-03_JPRB,7.1931E-03_JPRB/)
KAO( :, 1, 8, 6) = (/&
&4.3473E-03_JPRB,5.3530E-03_JPRB,5.4453E-03_JPRB,5.3772E-03_JPRB,5.1866E-03_JPRB,4.8647E-03_JPRB,&
&4.3808E-03_JPRB,3.5559E-03_JPRB,2.4173E-03_JPRB,3.5108E-03_JPRB/)
KAO( :, 2, 8, 6) = (/&
&5.6534E-03_JPRB,6.9608E-03_JPRB,7.0942E-03_JPRB,6.9933E-03_JPRB,6.7489E-03_JPRB,6.3330E-03_JPRB,&
&5.6745E-03_JPRB,4.5520E-03_JPRB,2.9081E-03_JPRB,4.1180E-03_JPRB/)
KAO( :, 3, 8, 6) = (/&
&7.2231E-03_JPRB,8.9492E-03_JPRB,9.1155E-03_JPRB,8.9772E-03_JPRB,8.6519E-03_JPRB,8.0865E-03_JPRB,&
&7.1842E-03_JPRB,5.7298E-03_JPRB,3.7126E-03_JPRB,4.8510E-03_JPRB/)
KAO( :, 4, 8, 6) = (/&
&9.0980E-03_JPRB,1.1325E-02_JPRB,1.1554E-02_JPRB,1.1402E-02_JPRB,1.0960E-02_JPRB,1.0182E-02_JPRB,&
&8.9521E-03_JPRB,7.1103E-03_JPRB,4.7399E-03_JPRB,5.6880E-03_JPRB/)
KAO( :, 5, 8, 6) = (/&
&1.1302E-02_JPRB,1.4121E-02_JPRB,1.4457E-02_JPRB,1.4302E-02_JPRB,1.3709E-02_JPRB,1.2644E-02_JPRB,&
&1.1007E-02_JPRB,8.6993E-03_JPRB,5.9281E-03_JPRB,6.6436E-03_JPRB/)
KAO( :, 1, 9, 6) = (/&
&3.2166E-03_JPRB,3.9635E-03_JPRB,4.0421E-03_JPRB,3.9936E-03_JPRB,3.8441E-03_JPRB,3.5923E-03_JPRB,&
&3.2097E-03_JPRB,2.5886E-03_JPRB,1.7693E-03_JPRB,5.0615E-03_JPRB/)
KAO( :, 2, 9, 6) = (/&
&4.2551E-03_JPRB,5.2496E-03_JPRB,5.3431E-03_JPRB,5.2633E-03_JPRB,5.0543E-03_JPRB,4.7090E-03_JPRB,&
&4.1979E-03_JPRB,3.3556E-03_JPRB,2.0811E-03_JPRB,5.7517E-03_JPRB/)
KAO( :, 3, 9, 6) = (/&
&5.5178E-03_JPRB,6.8310E-03_JPRB,6.9481E-03_JPRB,6.8181E-03_JPRB,6.5340E-03_JPRB,6.0733E-03_JPRB,&
&5.3775E-03_JPRB,4.2779E-03_JPRB,2.6744E-03_JPRB,6.5436E-03_JPRB/)
KAO( :, 4, 9, 6) = (/&
&7.0233E-03_JPRB,8.7120E-03_JPRB,8.8693E-03_JPRB,8.7209E-03_JPRB,8.3514E-03_JPRB,7.7376E-03_JPRB,&
&6.7992E-03_JPRB,5.3653E-03_JPRB,3.4836E-03_JPRB,7.4458E-03_JPRB/)
KAO( :, 5, 9, 6) = (/&
&8.7908E-03_JPRB,1.0935E-02_JPRB,1.1156E-02_JPRB,1.1011E-02_JPRB,1.0551E-02_JPRB,9.7377E-03_JPRB,&
&8.4643E-03_JPRB,6.6157E-03_JPRB,4.4105E-03_JPRB,8.4131E-03_JPRB/)
KAO( :, 1,10, 6) = (/&
&2.4036E-03_JPRB,2.9626E-03_JPRB,3.0270E-03_JPRB,2.9891E-03_JPRB,2.8783E-03_JPRB,2.6966E-03_JPRB,&
&2.4167E-03_JPRB,1.9384E-03_JPRB,1.2950E-03_JPRB,1.2580E-02_JPRB/)
KAO( :, 2,10, 6) = (/&
&3.2304E-03_JPRB,3.9936E-03_JPRB,4.0696E-03_JPRB,4.0063E-03_JPRB,3.8441E-03_JPRB,3.5817E-03_JPRB,&
&3.1841E-03_JPRB,2.5258E-03_JPRB,1.6318E-03_JPRB,1.3867E-02_JPRB/)
KAO( :, 3,10, 6) = (/&
&4.2450E-03_JPRB,5.2713E-03_JPRB,5.3717E-03_JPRB,5.2683E-03_JPRB,5.0339E-03_JPRB,4.6625E-03_JPRB,&
&4.1091E-03_JPRB,3.2509E-03_JPRB,2.0065E-03_JPRB,1.5204E-02_JPRB/)
KAO( :, 4,10, 6) = (/&
&5.4744E-03_JPRB,6.8064E-03_JPRB,6.9238E-03_JPRB,6.7912E-03_JPRB,6.4905E-03_JPRB,5.9838E-03_JPRB,&
&5.2439E-03_JPRB,4.1188E-03_JPRB,2.6002E-03_JPRB,1.6652E-02_JPRB/)
KAO( :, 5,10, 6) = (/&
&6.9353E-03_JPRB,8.6079E-03_JPRB,8.7635E-03_JPRB,8.6181E-03_JPRB,8.2349E-03_JPRB,7.5886E-03_JPRB,&
&6.5994E-03_JPRB,5.1192E-03_JPRB,3.3239E-03_JPRB,1.8251E-02_JPRB/)
KAO( :, 1,11, 6) = (/&
&2.0648E-03_JPRB,2.5481E-03_JPRB,2.6000E-03_JPRB,2.5607E-03_JPRB,2.4630E-03_JPRB,2.3069E-03_JPRB,&
&2.0692E-03_JPRB,1.6562E-03_JPRB,1.0860E-03_JPRB,1.7049E-02_JPRB/)
KAO( :, 2,11, 6) = (/&
&2.7859E-03_JPRB,3.4547E-03_JPRB,3.5237E-03_JPRB,3.4594E-03_JPRB,3.3142E-03_JPRB,3.0841E-03_JPRB,&
&2.7345E-03_JPRB,2.1584E-03_JPRB,1.3341E-03_JPRB,1.8747E-02_JPRB/)
KAO( :, 3,11, 6) = (/&
&3.6773E-03_JPRB,4.5764E-03_JPRB,4.6633E-03_JPRB,4.5751E-03_JPRB,4.3721E-03_JPRB,4.0405E-03_JPRB,&
&3.5419E-03_JPRB,2.7771E-03_JPRB,1.6730E-03_JPRB,2.0460E-02_JPRB/)
KAO( :, 4,11, 6) = (/&
&4.7645E-03_JPRB,5.9262E-03_JPRB,6.0301E-03_JPRB,5.9104E-03_JPRB,5.6462E-03_JPRB,5.2017E-03_JPRB,&
&4.5306E-03_JPRB,3.5163E-03_JPRB,2.1775E-03_JPRB,2.2225E-02_JPRB/)
KAO( :, 5,11, 6) = (/&
&6.0673E-03_JPRB,7.5194E-03_JPRB,7.6592E-03_JPRB,7.5146E-03_JPRB,7.1608E-03_JPRB,6.5750E-03_JPRB,&
&5.6954E-03_JPRB,4.3877E-03_JPRB,2.7878E-03_JPRB,2.4112E-02_JPRB/)
KAO( :, 1,12, 6) = (/&
&1.7649E-03_JPRB,2.1840E-03_JPRB,2.2273E-03_JPRB,2.1894E-03_JPRB,2.1029E-03_JPRB,1.9647E-03_JPRB,&
&1.7570E-03_JPRB,1.4092E-03_JPRB,9.0612E-04_JPRB,1.8116E-02_JPRB/)
KAO( :, 2,12, 6) = (/&
&2.3911E-03_JPRB,2.9721E-03_JPRB,3.0306E-03_JPRB,2.9776E-03_JPRB,2.8514E-03_JPRB,2.6450E-03_JPRB,&
&2.3351E-03_JPRB,1.8424E-03_JPRB,1.0968E-03_JPRB,1.9929E-02_JPRB/)
KAO( :, 3,12, 6) = (/&
&3.1732E-03_JPRB,3.9503E-03_JPRB,4.0215E-03_JPRB,3.9440E-03_JPRB,3.7721E-03_JPRB,3.4863E-03_JPRB,&
&3.0465E-03_JPRB,2.3738E-03_JPRB,1.3931E-03_JPRB,2.1707E-02_JPRB/)
KAO( :, 4,12, 6) = (/&
&4.1329E-03_JPRB,5.1374E-03_JPRB,5.2226E-03_JPRB,5.1161E-03_JPRB,4.8827E-03_JPRB,4.4950E-03_JPRB,&
&3.9019E-03_JPRB,3.0106E-03_JPRB,1.8199E-03_JPRB,2.3542E-02_JPRB/)
KAO( :, 5,12, 6) = (/&
&5.2972E-03_JPRB,6.5406E-03_JPRB,6.6636E-03_JPRB,6.5319E-03_JPRB,6.2060E-03_JPRB,5.6779E-03_JPRB,&
&4.9006E-03_JPRB,3.7653E-03_JPRB,2.3340E-03_JPRB,2.5478E-02_JPRB/)
KAO( :, 1,13, 6) = (/&
&1.4917E-03_JPRB,1.8531E-03_JPRB,1.8920E-03_JPRB,1.8620E-03_JPRB,1.7861E-03_JPRB,1.6617E-03_JPRB,&
&1.4788E-03_JPRB,1.1873E-03_JPRB,7.5550E-04_JPRB,1.5444E-02_JPRB/)
KAO( :, 2,13, 6) = (/&
&2.0333E-03_JPRB,2.5348E-03_JPRB,2.5838E-03_JPRB,2.5408E-03_JPRB,2.4328E-03_JPRB,2.2514E-03_JPRB,&
&1.9783E-03_JPRB,1.5611E-03_JPRB,9.0187E-04_JPRB,1.7015E-02_JPRB/)
KAO( :, 3,13, 6) = (/&
&2.7153E-03_JPRB,3.3873E-03_JPRB,3.4439E-03_JPRB,3.3763E-03_JPRB,3.2264E-03_JPRB,2.9750E-03_JPRB,&
&2.5932E-03_JPRB,2.0239E-03_JPRB,1.1597E-03_JPRB,1.8564E-02_JPRB/)
KAO( :, 4,13, 6) = (/&
&3.5625E-03_JPRB,4.4244E-03_JPRB,4.4971E-03_JPRB,4.4025E-03_JPRB,4.1909E-03_JPRB,3.8436E-03_JPRB,&
&3.3277E-03_JPRB,2.5719E-03_JPRB,1.5159E-03_JPRB,2.0176E-02_JPRB/)
KAO( :, 5,13, 6) = (/&
&4.5915E-03_JPRB,5.6599E-03_JPRB,5.7629E-03_JPRB,5.6406E-03_JPRB,5.3423E-03_JPRB,4.8700E-03_JPRB,&
&4.1907E-03_JPRB,3.2171E-03_JPRB,1.9497E-03_JPRB,2.1913E-02_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB3_A1
