!OCL SCALAR
SUBROUTINE RRTM_KGB3_00

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 3:  500-630 cm-1 (low - H2O,CO2; high - H2O,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO3 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO  ,FORREFO    ,ABSN2OAO   ,ABSN2OBO
USE YOERRTA3 , ONLY : ABSN2OA ,ABSN2OB  ,ETAREF    ,H2OREF     ,&
           &N2OREF     ,CO2REF     ,STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE
FORREFO( :) = (/&
      &1.76842E-04_JPRB, 1.77913E-04_JPRB, 1.25186E-04_JPRB, 1.07912E-04_JPRB,&
      &1.05217E-04_JPRB, 7.48726E-05_JPRB, 1.11701E-04_JPRB, 7.68921E-05_JPRB,&
      &9.87242E-05_JPRB, 9.85711E-05_JPRB, 6.16557E-05_JPRB,-1.61291E-05_JPRB,&
     &-1.26794E-04_JPRB,-1.19011E-04_JPRB,-2.67814E-04_JPRB, 6.95005E-05_JPRB/)

ABSN2OAO( :) = (/&
     &1.50387E-01_JPRB,2.91407E-01_JPRB,6.28803E-01_JPRB,9.65619E-01_JPRB,&
     &1.15054E-00_JPRB,2.23424E-00_JPRB,1.83392E-00_JPRB,1.39033E-00_JPRB,&
     &4.28457E-01_JPRB,2.73502E-01_JPRB,1.84307E-01_JPRB,1.61325E-01_JPRB,&
     &7.66314E-02_JPRB,1.33862E-01_JPRB,6.71196E-07_JPRB,1.59293E-06_JPRB/)

ABSN2OBO( :) = (/&
     &9.37044E-05_JPRB,1.23318E-03_JPRB,7.91720E-03_JPRB,5.33005E-02_JPRB,&
     &1.72343E-01_JPRB,4.29571E-01_JPRB,1.01288E+00_JPRB,3.83863E+00_JPRB,&
     &1.15312E+01_JPRB,1.08383E+00_JPRB,2.24847E+00_JPRB,1.51268E+00_JPRB,&
     &3.33177E-01_JPRB,7.82102E-01_JPRB,3.44631E-01_JPRB,1.61039E-03_JPRB/)

ETAREF( :) = (/&
     &_ZERO_,0.125_JPRB,0.25_JPRB,0.375_JPRB,_HALF_,0.625_JPRB,0.75_JPRB,0.875_JPRB,0.9875_JPRB,_ONE_/)

H2OREF( :) = (/&
     &1.87599E-02_JPRB,1.22233E-02_JPRB,5.89086E-03_JPRB,2.76753E-03_JPRB,1.40651E-03_JPRB, &
     &7.59698E-04_JPRB,3.88758E-04_JPRB,1.65422E-04_JPRB,3.71895E-05_JPRB,7.47648E-06_JPRB, &
     &4.30818E-06_JPRB,3.33194E-06_JPRB,3.20393E-06_JPRB,3.16186E-06_JPRB,3.25235E-06_JPRB, &
     &3.42258E-06_JPRB,3.62884E-06_JPRB,3.91482E-06_JPRB,4.14875E-06_JPRB,4.30810E-06_JPRB,&
     &4.44204E-06_JPRB,4.57783E-06_JPRB,4.70865E-06_JPRB,4.79432E-06_JPRB,4.86971E-06_JPRB, &
     &4.92603E-06_JPRB,4.96688E-06_JPRB,4.99628E-06_JPRB,5.05266E-06_JPRB,5.12658E-06_JPRB, &
     &5.25028E-06_JPRB,5.35708E-06_JPRB,5.45085E-06_JPRB,5.48304E-06_JPRB,5.50000E-06_JPRB, &
     &5.50000E-06_JPRB,5.45359E-06_JPRB,5.40468E-06_JPRB,5.35576E-06_JPRB,5.25327E-06_JPRB,&
     &5.14362E-06_JPRB,5.03396E-06_JPRB,4.87662E-06_JPRB,4.69787E-06_JPRB,4.51911E-06_JPRB, &
     &4.33600E-06_JPRB,4.14416E-06_JPRB,3.95232E-06_JPRB,3.76048E-06_JPRB,3.57217E-06_JPRB, &
     &3.38549E-06_JPRB,3.19881E-06_JPRB,3.01212E-06_JPRB,2.82621E-06_JPRB,2.64068E-06_JPRB, &
     &2.45515E-06_JPRB,2.26962E-06_JPRB,2.08659E-06_JPRB,1.93029E-06_JPRB/)

N2OREF( :) = (/&
     &3.20000E-07_JPRB,3.20000E-07_JPRB,3.20000E-07_JPRB,3.20000E-07_JPRB,3.20000E-07_JPRB,&
     &3.19652E-07_JPRB,3.15324E-07_JPRB,3.03830E-07_JPRB,2.94221E-07_JPRB,2.84953E-07_JPRB,&
     &2.76714E-07_JPRB,2.64709E-07_JPRB,2.42847E-07_JPRB,2.09547E-07_JPRB,1.71945E-07_JPRB,&
     &1.37491E-07_JPRB,1.13319E-07_JPRB,1.00354E-07_JPRB,9.12812E-08_JPRB,8.54633E-08_JPRB,&
     &8.03631E-08_JPRB,7.33718E-08_JPRB,6.59754E-08_JPRB,5.60386E-08_JPRB,4.70901E-08_JPRB,&
     &3.99774E-08_JPRB,3.29786E-08_JPRB,2.60642E-08_JPRB,2.10663E-08_JPRB,1.65918E-08_JPRB,&
     &1.30167E-08_JPRB,1.00900E-08_JPRB,7.62490E-09_JPRB,6.11592E-09_JPRB,4.66725E-09_JPRB,&
     &3.28574E-09_JPRB,2.84838E-09_JPRB,2.46198E-09_JPRB,2.07557E-09_JPRB,1.85507E-09_JPRB,&
     &1.65675E-09_JPRB,1.45843E-09_JPRB,1.31948E-09_JPRB,1.20716E-09_JPRB,1.09485E-09_JPRB,&
     &9.97803E-10_JPRB,9.31260E-10_JPRB,8.64721E-10_JPRB,7.98181E-10_JPRB,7.51380E-10_JPRB,&
     &7.13670E-10_JPRB,6.75960E-10_JPRB,6.38250E-10_JPRB,6.09811E-10_JPRB,5.85998E-10_JPRB,&
     &5.62185E-10_JPRB,5.38371E-10_JPRB,5.15183E-10_JPRB,4.98660E-10_JPRB/)

CO2REF( :) = (/&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.5470873E-04_JPRB, 3.5427220E-04_JPRB, 3.5383567E-04_JPRB,&
     &3.5339911E-04_JPRB, 3.5282588E-04_JPRB, 3.5079606E-04_JPRB/) 

STRRAT = 1.19268_JPRB

!     ------------------------------------------------------------------

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
&5.10286E-01_JPRB, 4.30424E-01_JPRB, 3.63061E-01_JPRB, 3.06241E-01_JPRB, 2.58313E-01_JPRB,&
&2.17886E-01_JPRB, 1.83786E-01_JPRB, 1.55023E-01_JPRB, 1.30761E-01_JPRB, 1.10297E-01_JPRB/)
SELFREFO( :, 2) = (/&
&4.96777E-01_JPRB, 4.30758E-01_JPRB, 3.73512E-01_JPRB, 3.23874E-01_JPRB, 2.80833E-01_JPRB,&
&2.43512E-01_JPRB, 2.11150E-01_JPRB, 1.83089E-01_JPRB, 1.58758E-01_JPRB, 1.37659E-01_JPRB/)
SELFREFO( :, 3) = (/&
&4.65595E-01_JPRB, 4.04778E-01_JPRB, 3.51905E-01_JPRB, 3.05939E-01_JPRB, 2.65976E-01_JPRB,&
&2.31234E-01_JPRB, 2.01030E-01_JPRB, 1.74771E-01_JPRB, 1.51942E-01_JPRB, 1.32095E-01_JPRB/)
SELFREFO( :, 4) = (/&
&4.34629E-01_JPRB, 3.86709E-01_JPRB, 3.44073E-01_JPRB, 3.06137E-01_JPRB, 2.72384E-01_JPRB,&
&2.42353E-01_JPRB, 2.15633E-01_JPRB, 1.91858E-01_JPRB, 1.70705E-01_JPRB, 1.51884E-01_JPRB/)
SELFREFO( :, 5) = (/&
&4.17625E-01_JPRB, 3.75442E-01_JPRB, 3.37519E-01_JPRB, 3.03427E-01_JPRB, 2.72778E-01_JPRB,&
&2.45225E-01_JPRB, 2.20456E-01_JPRB, 1.98188E-01_JPRB, 1.78169E-01_JPRB, 1.60173E-01_JPRB/)
SELFREFO( :, 6) = (/&
&3.97412E-01_JPRB, 3.61249E-01_JPRB, 3.28376E-01_JPRB, 2.98494E-01_JPRB, 2.71332E-01_JPRB,&
&2.46641E-01_JPRB, 2.24198E-01_JPRB, 2.03796E-01_JPRB, 1.85251E-01_JPRB, 1.68394E-01_JPRB/)
SELFREFO( :, 7) = (/&
&3.89795E-01_JPRB, 3.56178E-01_JPRB, 3.25460E-01_JPRB, 2.97391E-01_JPRB, 2.71743E-01_JPRB,&
&2.48307E-01_JPRB, 2.26892E-01_JPRB, 2.07324E-01_JPRB, 1.89444E-01_JPRB, 1.73105E-01_JPRB/)
SELFREFO( :, 8) = (/&
&3.79095E-01_JPRB, 3.46828E-01_JPRB, 3.17308E-01_JPRB, 2.90301E-01_JPRB, 2.65592E-01_JPRB,&
&2.42986E-01_JPRB, 2.22305E-01_JPRB, 2.03384E-01_JPRB, 1.86073E-01_JPRB, 1.70235E-01_JPRB/)
SELFREFO( :, 9) = (/&
&3.87086E-01_JPRB, 3.53988E-01_JPRB, 3.23720E-01_JPRB, 2.96040E-01_JPRB, 2.70727E-01_JPRB,&
&2.47578E-01_JPRB, 2.26409E-01_JPRB, 2.07050E-01_JPRB, 1.89346E-01_JPRB, 1.73156E-01_JPRB/)
SELFREFO( :,10) = (/&
&4.07529E-01_JPRB, 3.71284E-01_JPRB, 3.38263E-01_JPRB, 3.08179E-01_JPRB, 2.80770E-01_JPRB,&
&2.55799E-01_JPRB, 2.33049E-01_JPRB, 2.12322E-01_JPRB, 1.93438E-01_JPRB, 1.76234E-01_JPRB/)
SELFREFO( :,11) = (/&
&4.09315E-01_JPRB, 3.74420E-01_JPRB, 3.42500E-01_JPRB, 3.13302E-01_JPRB, 2.86592E-01_JPRB,&
&2.62160E-01_JPRB, 2.39811E-01_JPRB, 2.19367E-01_JPRB, 2.00665E-01_JPRB, 1.83558E-01_JPRB/)
SELFREFO( :,12) = (/&
&3.73996E-01_JPRB, 3.51462E-01_JPRB, 3.30286E-01_JPRB, 3.10385E-01_JPRB, 2.91684E-01_JPRB,&
&2.74109E-01_JPRB, 2.57593E-01_JPRB, 2.42072E-01_JPRB, 2.27487E-01_JPRB, 2.13780E-01_JPRB/)
SELFREFO( :,13) = (/&
&4.87965E-01_JPRB, 4.44525E-01_JPRB, 4.04952E-01_JPRB, 3.68902E-01_JPRB, 3.36061E-01_JPRB,&
&3.06144E-01_JPRB, 2.78891E-01_JPRB, 2.54063E-01_JPRB, 2.31446E-01_JPRB, 2.10842E-01_JPRB/)
SELFREFO( :,14) = (/&
&5.67999E-01_JPRB, 5.03336E-01_JPRB, 4.46034E-01_JPRB, 3.95256E-01_JPRB, 3.50259E-01_JPRB,&
&3.10384E-01_JPRB, 2.75048E-01_JPRB, 2.43736E-01_JPRB, 2.15988E-01_JPRB, 1.91399E-01_JPRB/)
SELFREFO( :,15) = (/&
&5.92492E-01_JPRB, 5.27072E-01_JPRB, 4.68874E-01_JPRB, 4.17103E-01_JPRB, 3.71048E-01_JPRB,&
&3.30079E-01_JPRB, 2.93633E-01_JPRB, 2.61211E-01_JPRB, 2.32369E-01_JPRB, 2.06712E-01_JPRB/)
SELFREFO( :,16) = (/&
&5.04176E-01_JPRB, 4.64845E-01_JPRB, 4.28582E-01_JPRB, 3.95148E-01_JPRB, 3.64322E-01_JPRB,&
&3.35901E-01_JPRB, 3.09697E-01_JPRB, 2.85538E-01_JPRB, 2.63263E-01_JPRB, 2.42725E-01_JPRB/)

FRACREFAO( :, 1) = (/&
!     From P = 1053.6 mb.
    &0.15116400_JPRB,0.14875700_JPRB,0.14232300_JPRB,0.13234501_JPRB,&
    &0.11881600_JPRB,0.10224100_JPRB,0.08345580_JPRB,0.06267490_JPRB,&
    &0.04250650_JPRB,0.00462650_JPRB,0.00382259_JPRB,0.00302600_JPRB,&
    &0.00222004_JPRB,0.00141397_JPRB,0.00053379_JPRB,0.00007421_JPRB/)
FRACREFAO( :, 2) = (/&
    &0.15266000_JPRB,0.14888400_JPRB,0.14195900_JPRB,0.13179500_JPRB,&
    &0.11842700_JPRB,0.10209000_JPRB,0.08336130_JPRB,0.06264370_JPRB,&
    &0.04247660_JPRB,0.00461946_JPRB,0.00381536_JPRB,0.00302601_JPRB,&
    &0.00222004_JPRB,0.00141397_JPRB,0.00053302_JPRB,0.00007498_JPRB/)
FRACREFAO( :, 3) = (/&
    &0.15282799_JPRB,0.14903000_JPRB,0.14192399_JPRB,0.13174300_JPRB,&
    &0.11835300_JPRB,0.10202700_JPRB,0.08329830_JPRB,0.06264830_JPRB,&
    &0.04246910_JPRB,0.00460242_JPRB,0.00381904_JPRB,0.00301573_JPRB,&
    &0.00222004_JPRB,0.00141397_JPRB,0.00053379_JPRB,0.00007421_JPRB/)
FRACREFAO( :, 4) = (/&
    &0.15298399_JPRB,0.14902800_JPRB,0.14193401_JPRB,0.13173500_JPRB,&
    &0.11833300_JPRB,0.10195800_JPRB,0.08324730_JPRB,0.06264770_JPRB,&
    &0.04246490_JPRB,0.00460489_JPRB,0.00381123_JPRB,0.00301893_JPRB,&
    &0.00221093_JPRB,0.00141397_JPRB,0.00053379_JPRB,0.00007421_JPRB/)
FRACREFAO( :, 5) = (/&
    &0.15307599_JPRB,0.14907201_JPRB,0.14198899_JPRB,0.13169800_JPRB,&
    &0.11827300_JPRB,0.10192300_JPRB,0.08321600_JPRB,0.06263490_JPRB,&
    &0.04245600_JPRB,0.00460846_JPRB,0.00380836_JPRB,0.00301663_JPRB,&
    &0.00221402_JPRB,0.00141167_JPRB,0.00052807_JPRB,0.00007376_JPRB/)
FRACREFAO( :, 6) = (/&
    &0.15311401_JPRB,0.14915401_JPRB,0.14207301_JPRB,0.13167299_JPRB,&
    &0.11819300_JPRB,0.10188900_JPRB,0.08318760_JPRB,0.06261960_JPRB,&
    &0.04243890_JPRB,0.00461584_JPRB,0.00380929_JPRB,0.00300815_JPRB,&
    &0.00221736_JPRB,0.00140588_JPRB,0.00052776_JPRB,0.00007376_JPRB/)
FRACREFAO( :, 7) = (/&
    &0.15316001_JPRB,0.14925499_JPRB,0.14213000_JPRB,0.13170999_JPRB,&
    &0.11807700_JPRB,0.10181400_JPRB,0.08317400_JPRB,0.06260300_JPRB,&
    &0.04242720_JPRB,0.00461520_JPRB,0.00381381_JPRB,0.00301285_JPRB,&
    &0.00220275_JPRB,0.00140371_JPRB,0.00052776_JPRB,0.00007376_JPRB/)
FRACREFAO( :, 8) = (/&
    &0.15321200_JPRB,0.14940999_JPRB,0.14222500_JPRB,0.13164200_JPRB,&
    &0.11798200_JPRB,0.10174500_JPRB,0.08317500_JPRB,0.06253640_JPRB,&
    &0.04243130_JPRB,0.00461724_JPRB,0.00381534_JPRB,0.00300320_JPRB,&
    &0.00220091_JPRB,0.00140364_JPRB,0.00052852_JPRB,0.00007300_JPRB/)
FRACREFAO( :, 9) = (/&
    &0.15312800_JPRB,0.14973100_JPRB,0.14234400_JPRB,0.13168900_JPRB,&
    &0.11795200_JPRB,0.10156100_JPRB,0.08302990_JPRB,0.06252240_JPRB,&
    &0.04240980_JPRB,0.00461035_JPRB,0.00381381_JPRB,0.00300176_JPRB,&
    &0.00220160_JPRB,0.00140284_JPRB,0.00052774_JPRB,0.00007376_JPRB/)
FRACREFAO( :,10) = (/&
    &0.15292500_JPRB,0.14978001_JPRB,0.14242400_JPRB,0.13172600_JPRB,&
    &0.11798800_JPRB,0.10156400_JPRB,0.08303050_JPRB,0.06251670_JPRB,&
    &0.04240970_JPRB,0.00461302_JPRB,0.00381452_JPRB,0.00300250_JPRB,&
    &0.00220126_JPRB,0.00140324_JPRB,0.00052850_JPRB,0.00007300_JPRB/)

FRACREFBO( :, 1) = (/&
!     From P = 64.1 mb.
    &0.16340201_JPRB,0.15607700_JPRB,0.14601400_JPRB,0.13182700_JPRB,&
    &0.11524700_JPRB,0.09666570_JPRB,0.07825360_JPRB,0.05849780_JPRB,&
    &0.03949650_JPRB,0.00427980_JPRB,0.00353719_JPRB,0.00279303_JPRB,&
    &0.00204788_JPRB,0.00130139_JPRB,0.00049055_JPRB,0.00006904_JPRB/)
FRACREFBO( :, 2) = (/&
    &0.15762900_JPRB,0.15494700_JPRB,0.14659800_JPRB,0.13267800_JPRB,&
    &0.11562700_JPRB,0.09838360_JPRB,0.07930420_JPRB,0.05962700_JPRB,&
    &0.04036360_JPRB,0.00438053_JPRB,0.00361463_JPRB,0.00285723_JPRB,&
    &0.00208345_JPRB,0.00132135_JPRB,0.00050528_JPRB,0.00008003_JPRB/)
FRACREFBO( :, 3) = (/&
    &0.15641500_JPRB,0.15394500_JPRB,0.14633600_JPRB,0.13180400_JPRB,&
    &0.11617100_JPRB,0.09924170_JPRB,0.08000510_JPRB,0.06021420_JPRB,&
    &0.04082730_JPRB,0.00441694_JPRB,0.00365364_JPRB,0.00287723_JPRB,&
    &0.00210914_JPRB,0.00135784_JPRB,0.00054651_JPRB,0.00008003_JPRB/)
FRACREFBO( :, 4) = (/&
    &0.15482700_JPRB,0.15286300_JPRB,0.14392500_JPRB,0.13244100_JPRB,&
    &0.11712000_JPRB,0.09994920_JPRB,0.08119200_JPRB,0.06104360_JPRB,&
    &0.04135600_JPRB,0.00446685_JPRB,0.00368377_JPRB,0.00290767_JPRB,&
    &0.00215445_JPRB,0.00142865_JPRB,0.00056142_JPRB,0.00008003_JPRB/)
FRACREFBO( :, 5) = (/&
    &0.15975100_JPRB,0.15653500_JPRB,0.14214399_JPRB,0.12892200_JPRB,&
    &0.11508400_JPRB,0.09906020_JPRB,0.08087940_JPRB,0.06078190_JPRB,&
    &0.04140530_JPRB,0.00452724_JPRB,0.00374558_JPRB,0.00295328_JPRB,&
    &0.00218509_JPRB,0.00138644_JPRB,0.00056018_JPRB,0.00008003_JPRB/)

!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB3_00
