!OCL SCALAR
SUBROUTINE RRTM_KGB1_01

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 1:  10-250 cm-1 (low - H2O; high - H2O)
!     Reformatted for F90 by JJMorcrette, ECMWF

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO1 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO ,&
           &FRACREFBO  ,FORREFO

!     ------------------------------------------------------------------


IMPLICIT NONE
FRACREFAO( :) = (/&
    &0.08452097_JPRB,0.17952873_JPRB,0.16214369_JPRB,0.13602182_JPRB,&
    &0.12760490_JPRB,0.10302561_JPRB,0.08392423_JPRB,0.06337652_JPRB,&
    &0.04206551_JPRB,0.00487497_JPRB,0.00410743_JPRB,0.00344421_JPRB,&
    &0.00285731_JPRB,0.00157327_JPRB,0.00080648_JPRB,0.00012406_JPRB/)

FRACREFBO( :) = (/&
    &0.15492001_JPRB,0.17384727_JPRB,0.15165100_JPRB,0.12675308_JPRB,&
    &0.10986247_JPRB,0.09006091_JPRB,0.07584465_JPRB,0.05990077_JPRB,&
    &0.04113461_JPRB,0.00438638_JPRB,0.00374754_JPRB,0.00313924_JPRB,&
    &0.00234381_JPRB,0.00167167_JPRB,0.00062744_JPRB,0.00010889_JPRB/)

FORREFO( :) = (/&
     &-4.50470E-02_JPRB,-1.18908E-01_JPRB,-7.21730E-02_JPRB,-2.83862E-02_JPRB,&
     &-3.01961E-02_JPRB,-1.56877E-02_JPRB,-1.53684E-02_JPRB,-1.29135E-02_JPRB,&
     &-1.27963E-02_JPRB,-1.81742E-03_JPRB, 4.40008E-05_JPRB, 1.05260E-02_JPRB,&
      &2.17290E-02_JPRB, 1.65571E-02_JPRB, 7.60751E-02_JPRB, 1.47405E-01_JPRB/)

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels > ~100mb and temperatures.  The first
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the corresponding TREF for this  pressure level, 
!     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
!     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
!     index, JP, runs from 1 to 13 and refers to the corresponding 
!     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
!     The third index, IG, goes from 1 to 16, and tells us which 
!     g-interval the absorption coefficients are for.

KAO( :, 1, 1) = (/&
&2.9728E-01_JPRB,2.7117E-01_JPRB,2.4824E-01_JPRB,2.2823E-01_JPRB,2.1073E-01_JPRB/)
KAO( :, 2, 1) = (/&
&2.5383E-01_JPRB,2.3094E-01_JPRB,2.1122E-01_JPRB,1.9387E-01_JPRB,1.7870E-01_JPRB/)
KAO( :, 3, 1) = (/&
&2.2079E-01_JPRB,2.0034E-01_JPRB,1.8264E-01_JPRB,1.6726E-01_JPRB,1.5378E-01_JPRB/)
KAO( :, 4, 1) = (/&
&1.9385E-01_JPRB,1.7531E-01_JPRB,1.5932E-01_JPRB,1.4544E-01_JPRB,1.3338E-01_JPRB/)
KAO( :, 5, 1) = (/&
&1.7059E-01_JPRB,1.5374E-01_JPRB,1.3930E-01_JPRB,1.2682E-01_JPRB,1.1600E-01_JPRB/)
KAO( :, 6, 1) = (/&
&1.5085E-01_JPRB,1.3549E-01_JPRB,1.2235E-01_JPRB,1.1112E-01_JPRB,1.0142E-01_JPRB/)
KAO( :, 7, 1) = (/&
&1.3366E-01_JPRB,1.1960E-01_JPRB,1.0771E-01_JPRB,9.7560E-02_JPRB,8.8804E-02_JPRB/)
KAO( :, 8, 1) = (/&
&1.1833E-01_JPRB,1.0551E-01_JPRB,9.4748E-02_JPRB,8.5642E-02_JPRB,7.7808E-02_JPRB/)
KAO( :, 9, 1) = (/&
&1.0407E-01_JPRB,9.2585E-02_JPRB,8.3046E-02_JPRB,7.5077E-02_JPRB,6.8338E-02_JPRB/)
KAO( :,10, 1) = (/&
&9.6249E-02_JPRB,8.6268E-02_JPRB,7.7918E-02_JPRB,7.0909E-02_JPRB,6.5026E-02_JPRB/)
KAO( :,11, 1) = (/&
&8.5798E-02_JPRB,7.7607E-02_JPRB,7.0781E-02_JPRB,6.5084E-02_JPRB,6.0324E-02_JPRB/)
KAO( :,12, 1) = (/&
&7.5259E-02_JPRB,6.8525E-02_JPRB,6.2945E-02_JPRB,5.8330E-02_JPRB,5.4507E-02_JPRB/)
KAO( :,13, 1) = (/&
&6.6022E-02_JPRB,6.0316E-02_JPRB,5.5584E-02_JPRB,5.1665E-02_JPRB,4.8461E-02_JPRB/)
KAO( :, 1, 2) = (/&
&1.0868E+00_JPRB,1.0180E+00_JPRB,9.5619E-01_JPRB,9.0008E-01_JPRB,8.4968E-01_JPRB/)
KAO( :, 2, 2) = (/&
&9.1280E-01_JPRB,8.5427E-01_JPRB,8.0215E-01_JPRB,7.5470E-01_JPRB,7.1212E-01_JPRB/)
KAO( :, 3, 2) = (/&
&7.7699E-01_JPRB,7.2607E-01_JPRB,6.8084E-01_JPRB,6.3997E-01_JPRB,6.0293E-01_JPRB/)
KAO( :, 4, 2) = (/&
&6.6708E-01_JPRB,6.2264E-01_JPRB,5.8280E-01_JPRB,5.4723E-01_JPRB,5.1498E-01_JPRB/)
KAO( :, 5, 2) = (/&
&5.7399E-01_JPRB,5.3509E-01_JPRB,5.0018E-01_JPRB,4.6892E-01_JPRB,4.4080E-01_JPRB/)
KAO( :, 6, 2) = (/&
&4.9530E-01_JPRB,4.6110E-01_JPRB,4.3040E-01_JPRB,4.0285E-01_JPRB,3.7815E-01_JPRB/)
KAO( :, 7, 2) = (/&
&4.2745E-01_JPRB,3.9732E-01_JPRB,3.7040E-01_JPRB,3.4614E-01_JPRB,3.2442E-01_JPRB/)
KAO( :, 8, 2) = (/&
&3.6869E-01_JPRB,3.4268E-01_JPRB,3.1900E-01_JPRB,2.9776E-01_JPRB,2.7880E-01_JPRB/)
KAO( :, 9, 2) = (/&
&3.1986E-01_JPRB,2.9734E-01_JPRB,2.7688E-01_JPRB,2.5843E-01_JPRB,2.4196E-01_JPRB/)
KAO( :,10, 2) = (/&
&2.8291E-01_JPRB,2.6327E-01_JPRB,2.4583E-01_JPRB,2.3014E-01_JPRB,2.1607E-01_JPRB/)
KAO( :,11, 2) = (/&
&2.4260E-01_JPRB,2.2644E-01_JPRB,2.1226E-01_JPRB,1.9956E-01_JPRB,1.8806E-01_JPRB/)
KAO( :,12, 2) = (/&
&2.0558E-01_JPRB,1.9256E-01_JPRB,1.8115E-01_JPRB,1.7097E-01_JPRB,1.6176E-01_JPRB/)
KAO( :,13, 2) = (/&
&1.7296E-01_JPRB,1.6235E-01_JPRB,1.5298E-01_JPRB,1.4476E-01_JPRB,1.3735E-01_JPRB/)
KAO( :, 1, 3) = (/&
&1.9978E+00_JPRB,1.9059E+00_JPRB,1.8189E+00_JPRB,1.7366E+00_JPRB,1.6586E+00_JPRB/)
KAO( :, 2, 3) = (/&
&1.6606E+00_JPRB,1.5839E+00_JPRB,1.5107E+00_JPRB,1.4431E+00_JPRB,1.3779E+00_JPRB/)
KAO( :, 3, 3) = (/&
&1.3892E+00_JPRB,1.3254E+00_JPRB,1.2641E+00_JPRB,1.2074E+00_JPRB,1.1536E+00_JPRB/)
KAO( :, 4, 3) = (/&
&1.1729E+00_JPRB,1.1192E+00_JPRB,1.0684E+00_JPRB,1.0206E+00_JPRB,9.7581E-01_JPRB/)
KAO( :, 5, 3) = (/&
&9.9394E-01_JPRB,9.4858E-01_JPRB,9.0600E-01_JPRB,8.6583E-01_JPRB,8.2779E-01_JPRB/)
KAO( :, 6, 3) = (/&
&8.4450E-01_JPRB,8.0530E-01_JPRB,7.6915E-01_JPRB,7.3568E-01_JPRB,7.0371E-01_JPRB/)
KAO( :, 7, 3) = (/&
&7.1829E-01_JPRB,6.8411E-01_JPRB,6.5331E-01_JPRB,6.2452E-01_JPRB,5.9760E-01_JPRB/)
KAO( :, 8, 3) = (/&
&6.1224E-01_JPRB,5.8194E-01_JPRB,5.5498E-01_JPRB,5.3049E-01_JPRB,5.0749E-01_JPRB/)
KAO( :, 9, 3) = (/&
&5.2649E-01_JPRB,4.9920E-01_JPRB,4.7516E-01_JPRB,4.5390E-01_JPRB,4.3400E-01_JPRB/)
KAO( :,10, 3) = (/&
&4.6036E-01_JPRB,4.3661E-01_JPRB,4.1510E-01_JPRB,3.9653E-01_JPRB,3.7973E-01_JPRB/)
KAO( :,11, 3) = (/&
&3.9552E-01_JPRB,3.7556E-01_JPRB,3.5783E-01_JPRB,3.4242E-01_JPRB,3.2854E-01_JPRB/)
KAO( :,12, 3) = (/&
&3.3619E-01_JPRB,3.1976E-01_JPRB,3.0528E-01_JPRB,2.9270E-01_JPRB,2.8130E-01_JPRB/)
KAO( :,13, 3) = (/&
&2.8224E-01_JPRB,2.6905E-01_JPRB,2.5767E-01_JPRB,2.4740E-01_JPRB,2.3812E-01_JPRB/)
KAO( :, 1, 4) = (/&
&3.1134E+00_JPRB,2.9768E+00_JPRB,2.8528E+00_JPRB,2.7371E+00_JPRB,2.6298E+00_JPRB/)
KAO( :, 2, 4) = (/&
&2.5980E+00_JPRB,2.4825E+00_JPRB,2.3758E+00_JPRB,2.2768E+00_JPRB,2.1885E+00_JPRB/)
KAO( :, 3, 4) = (/&
&2.1823E+00_JPRB,2.0815E+00_JPRB,1.9888E+00_JPRB,1.9036E+00_JPRB,1.8278E+00_JPRB/)
KAO( :, 4, 4) = (/&
&1.8482E+00_JPRB,1.7602E+00_JPRB,1.6798E+00_JPRB,1.6064E+00_JPRB,1.5402E+00_JPRB/)
KAO( :, 5, 4) = (/&
&1.5691E+00_JPRB,1.4937E+00_JPRB,1.4240E+00_JPRB,1.3603E+00_JPRB,1.3038E+00_JPRB/)
KAO( :, 6, 4) = (/&
&1.3353E+00_JPRB,1.2714E+00_JPRB,1.2114E+00_JPRB,1.1566E+00_JPRB,1.1076E+00_JPRB/)
KAO( :, 7, 4) = (/&
&1.1365E+00_JPRB,1.0823E+00_JPRB,1.0312E+00_JPRB,9.8386E-01_JPRB,9.4149E-01_JPRB/)
KAO( :, 8, 4) = (/&
&9.6785E-01_JPRB,9.2216E-01_JPRB,8.7848E-01_JPRB,8.3819E-01_JPRB,8.0171E-01_JPRB/)
KAO( :, 9, 4) = (/&
&8.2906E-01_JPRB,7.9098E-01_JPRB,7.5375E-01_JPRB,7.1927E-01_JPRB,6.8769E-01_JPRB/)
KAO( :,10, 4) = (/&
&7.2091E-01_JPRB,6.8867E-01_JPRB,6.5764E-01_JPRB,6.2852E-01_JPRB,6.0157E-01_JPRB/)
KAO( :,11, 4) = (/&
&6.1639E-01_JPRB,5.8956E-01_JPRB,5.6471E-01_JPRB,5.4117E-01_JPRB,5.1965E-01_JPRB/)
KAO( :,12, 4) = (/&
&5.2694E-01_JPRB,5.0446E-01_JPRB,4.8409E-01_JPRB,4.6534E-01_JPRB,4.4808E-01_JPRB/)
KAO( :,13, 4) = (/&
&4.4495E-01_JPRB,4.2623E-01_JPRB,4.0962E-01_JPRB,3.9458E-01_JPRB,3.8091E-01_JPRB/)
KAO( :, 1, 5) = (/&
&5.1530E+00_JPRB,4.9766E+00_JPRB,4.8081E+00_JPRB,4.6516E+00_JPRB,4.5093E+00_JPRB/)
KAO( :, 2, 5) = (/&
&4.3491E+00_JPRB,4.2045E+00_JPRB,4.0708E+00_JPRB,3.9418E+00_JPRB,3.8163E+00_JPRB/)
KAO( :, 3, 5) = (/&
&3.6708E+00_JPRB,3.5507E+00_JPRB,3.4414E+00_JPRB,3.3312E+00_JPRB,3.2173E+00_JPRB/)
KAO( :, 4, 5) = (/&
&3.1175E+00_JPRB,3.0159E+00_JPRB,2.9223E+00_JPRB,2.8267E+00_JPRB,2.7279E+00_JPRB/)
KAO( :, 5, 5) = (/&
&2.6518E+00_JPRB,2.5625E+00_JPRB,2.4801E+00_JPRB,2.3975E+00_JPRB,2.3146E+00_JPRB/)
KAO( :, 6, 5) = (/&
&2.2564E+00_JPRB,2.1773E+00_JPRB,2.1039E+00_JPRB,2.0333E+00_JPRB,1.9631E+00_JPRB/)
KAO( :, 7, 5) = (/&
&1.9182E+00_JPRB,1.8476E+00_JPRB,1.7832E+00_JPRB,1.7230E+00_JPRB,1.6643E+00_JPRB/)
KAO( :, 8, 5) = (/&
&1.6337E+00_JPRB,1.5705E+00_JPRB,1.5139E+00_JPRB,1.4617E+00_JPRB,1.4128E+00_JPRB/)
KAO( :, 9, 5) = (/&
&1.4083E+00_JPRB,1.3508E+00_JPRB,1.3006E+00_JPRB,1.2545E+00_JPRB,1.2118E+00_JPRB/)
KAO( :,10, 5) = (/&
&1.2328E+00_JPRB,1.1811E+00_JPRB,1.1365E+00_JPRB,1.0948E+00_JPRB,1.0570E+00_JPRB/)
KAO( :,11, 5) = (/&
&1.0545E+00_JPRB,1.0121E+00_JPRB,9.7473E-01_JPRB,9.3945E-01_JPRB,9.0734E-01_JPRB/)
KAO( :,12, 5) = (/&
&9.0496E-01_JPRB,8.7115E-01_JPRB,8.4024E-01_JPRB,8.1130E-01_JPRB,7.8449E-01_JPRB/)
KAO( :,13, 5) = (/&
&7.7164E-01_JPRB,7.4436E-01_JPRB,7.1910E-01_JPRB,6.9522E-01_JPRB,6.7297E-01_JPRB/)
KAO( :, 1, 6) = (/&
&9.6973E+00_JPRB,9.3787E+00_JPRB,9.0588E+00_JPRB,8.7497E+00_JPRB,8.4590E+00_JPRB/)
KAO( :, 2, 6) = (/&
&8.3422E+00_JPRB,8.0414E+00_JPRB,7.7516E+00_JPRB,7.4834E+00_JPRB,7.2408E+00_JPRB/)
KAO( :, 3, 6) = (/&
&7.1314E+00_JPRB,6.8664E+00_JPRB,6.6149E+00_JPRB,6.3897E+00_JPRB,6.1962E+00_JPRB/)
KAO( :, 4, 6) = (/&
&6.1234E+00_JPRB,5.8927E+00_JPRB,5.6767E+00_JPRB,5.4877E+00_JPRB,5.3211E+00_JPRB/)
KAO( :, 5, 6) = (/&
&5.2539E+00_JPRB,5.0548E+00_JPRB,4.8732E+00_JPRB,4.7110E+00_JPRB,4.5668E+00_JPRB/)
KAO( :, 6, 6) = (/&
&4.5026E+00_JPRB,4.3343E+00_JPRB,4.1792E+00_JPRB,4.0419E+00_JPRB,3.9124E+00_JPRB/)
KAO( :, 7, 6) = (/&
&3.8524E+00_JPRB,3.7093E+00_JPRB,3.5777E+00_JPRB,3.4570E+00_JPRB,3.3411E+00_JPRB/)
KAO( :, 8, 6) = (/&
&3.2864E+00_JPRB,3.1665E+00_JPRB,3.0553E+00_JPRB,2.9496E+00_JPRB,2.8463E+00_JPRB/)
KAO( :, 9, 6) = (/&
&2.8265E+00_JPRB,2.7253E+00_JPRB,2.6293E+00_JPRB,2.5362E+00_JPRB,2.4454E+00_JPRB/)
KAO( :,10, 6) = (/&
&2.4703E+00_JPRB,2.3851E+00_JPRB,2.3012E+00_JPRB,2.2197E+00_JPRB,2.1390E+00_JPRB/)
KAO( :,11, 6) = (/&
&2.1039E+00_JPRB,2.0324E+00_JPRB,1.9625E+00_JPRB,1.8926E+00_JPRB,1.8236E+00_JPRB/)
KAO( :,12, 6) = (/&
&1.7889E+00_JPRB,1.7295E+00_JPRB,1.6689E+00_JPRB,1.6099E+00_JPRB,1.5530E+00_JPRB/)
KAO( :,13, 6) = (/&
&1.5191E+00_JPRB,1.4695E+00_JPRB,1.4192E+00_JPRB,1.3697E+00_JPRB,1.3233E+00_JPRB/)
KAO( :, 1, 7) = (/&
&1.9309E+01_JPRB,1.8684E+01_JPRB,1.8099E+01_JPRB,1.7538E+01_JPRB,1.7003E+01_JPRB/)
KAO( :, 2, 7) = (/&
&1.7226E+01_JPRB,1.6672E+01_JPRB,1.6118E+01_JPRB,1.5594E+01_JPRB,1.5067E+01_JPRB/)
KAO( :, 3, 7) = (/&
&1.5276E+01_JPRB,1.4769E+01_JPRB,1.4264E+01_JPRB,1.3763E+01_JPRB,1.3263E+01_JPRB/)
KAO( :, 4, 7) = (/&
&1.3460E+01_JPRB,1.3002E+01_JPRB,1.2544E+01_JPRB,1.2084E+01_JPRB,1.1633E+01_JPRB/)
KAO( :, 5, 7) = (/&
&1.1768E+01_JPRB,1.1365E+01_JPRB,1.0948E+01_JPRB,1.0535E+01_JPRB,1.0140E+01_JPRB/)
KAO( :, 6, 7) = (/&
&1.0233E+01_JPRB,9.8691E+00_JPRB,9.5008E+00_JPRB,9.1399E+00_JPRB,8.8037E+00_JPRB/)
KAO( :, 7, 7) = (/&
&8.8418E+00_JPRB,8.5251E+00_JPRB,8.2044E+00_JPRB,7.8974E+00_JPRB,7.6097E+00_JPRB/)
KAO( :, 8, 7) = (/&
&7.5932E+00_JPRB,7.3228E+00_JPRB,7.0494E+00_JPRB,6.7890E+00_JPRB,6.5466E+00_JPRB/)
KAO( :, 9, 7) = (/&
&6.5438E+00_JPRB,6.3102E+00_JPRB,6.0785E+00_JPRB,5.8572E+00_JPRB,5.6536E+00_JPRB/)
KAO( :,10, 7) = (/&
&5.7701E+00_JPRB,5.5632E+00_JPRB,5.3602E+00_JPRB,5.1657E+00_JPRB,4.9886E+00_JPRB/)
KAO( :,11, 7) = (/&
&4.9229E+00_JPRB,4.7468E+00_JPRB,4.5754E+00_JPRB,4.4156E+00_JPRB,4.2640E+00_JPRB/)
KAO( :,12, 7) = (/&
&4.1712E+00_JPRB,4.0245E+00_JPRB,3.8835E+00_JPRB,3.7490E+00_JPRB,3.6186E+00_JPRB/)
KAO( :,13, 7) = (/&
&3.5142E+00_JPRB,3.3938E+00_JPRB,3.2767E+00_JPRB,3.1632E+00_JPRB,3.0535E+00_JPRB/)
KAO( :, 1, 8) = (/&
&4.3792E+01_JPRB,4.2562E+01_JPRB,4.1326E+01_JPRB,4.0173E+01_JPRB,3.9029E+01_JPRB/)
KAO( :, 2, 8) = (/&
&4.1083E+01_JPRB,3.9961E+01_JPRB,3.8875E+01_JPRB,3.7761E+01_JPRB,3.6732E+01_JPRB/)
KAO( :, 3, 8) = (/&
&3.8232E+01_JPRB,3.7158E+01_JPRB,3.6113E+01_JPRB,3.5094E+01_JPRB,3.4130E+01_JPRB/)
KAO( :, 4, 8) = (/&
&3.5298E+01_JPRB,3.4286E+01_JPRB,3.3318E+01_JPRB,3.2377E+01_JPRB,3.1455E+01_JPRB/)
KAO( :, 5, 8) = (/&
&3.2307E+01_JPRB,3.1366E+01_JPRB,3.0496E+01_JPRB,2.9612E+01_JPRB,2.8733E+01_JPRB/)
KAO( :, 6, 8) = (/&
&2.9245E+01_JPRB,2.8430E+01_JPRB,2.7640E+01_JPRB,2.6836E+01_JPRB,2.6022E+01_JPRB/)
KAO( :, 7, 8) = (/&
&2.6088E+01_JPRB,2.5397E+01_JPRB,2.4695E+01_JPRB,2.3991E+01_JPRB,2.3257E+01_JPRB/)
KAO( :, 8, 8) = (/&
&2.2981E+01_JPRB,2.2412E+01_JPRB,2.1823E+01_JPRB,2.1203E+01_JPRB,2.0533E+01_JPRB/)
KAO( :, 9, 8) = (/&
&2.0055E+01_JPRB,1.9585E+01_JPRB,1.9088E+01_JPRB,1.8539E+01_JPRB,1.7936E+01_JPRB/)
KAO( :,10, 8) = (/&
&1.7813E+01_JPRB,1.7392E+01_JPRB,1.6941E+01_JPRB,1.6433E+01_JPRB,1.5881E+01_JPRB/)
KAO( :,11, 8) = (/&
&1.5517E+01_JPRB,1.5141E+01_JPRB,1.4721E+01_JPRB,1.4250E+01_JPRB,1.3762E+01_JPRB/)
KAO( :,12, 8) = (/&
&1.3307E+01_JPRB,1.2968E+01_JPRB,1.2587E+01_JPRB,1.2173E+01_JPRB,1.1765E+01_JPRB/)
KAO( :,13, 8) = (/&
&1.1246E+01_JPRB,1.0950E+01_JPRB,1.0619E+01_JPRB,1.0276E+01_JPRB,9.9339E+00_JPRB/)
KAO( :, 1, 9) = (/&
&1.1805E+02_JPRB,1.1497E+02_JPRB,1.1183E+02_JPRB,1.0901E+02_JPRB,1.0608E+02_JPRB/)
KAO( :, 2, 9) = (/&
&1.2044E+02_JPRB,1.1710E+02_JPRB,1.1402E+02_JPRB,1.1089E+02_JPRB,1.0784E+02_JPRB/)
KAO( :, 3, 9) = (/&
&1.2224E+02_JPRB,1.1882E+02_JPRB,1.1548E+02_JPRB,1.1225E+02_JPRB,1.0912E+02_JPRB/)
KAO( :, 4, 9) = (/&
&1.2253E+02_JPRB,1.1914E+02_JPRB,1.1570E+02_JPRB,1.1248E+02_JPRB,1.0936E+02_JPRB/)
KAO( :, 5, 9) = (/&
&1.2110E+02_JPRB,1.1772E+02_JPRB,1.1430E+02_JPRB,1.1120E+02_JPRB,1.0822E+02_JPRB/)
KAO( :, 6, 9) = (/&
&1.1824E+02_JPRB,1.1487E+02_JPRB,1.1155E+02_JPRB,1.0851E+02_JPRB,1.0564E+02_JPRB/)
KAO( :, 7, 9) = (/&
&1.1353E+02_JPRB,1.1029E+02_JPRB,1.0721E+02_JPRB,1.0431E+02_JPRB,1.0150E+02_JPRB/)
KAO( :, 8, 9) = (/&
&1.0728E+02_JPRB,1.0430E+02_JPRB,1.0145E+02_JPRB,9.8717E+01_JPRB,9.6110E+01_JPRB/)
KAO( :, 9, 9) = (/&
&9.9961E+01_JPRB,9.7260E+01_JPRB,9.4661E+01_JPRB,9.2129E+01_JPRB,8.9711E+01_JPRB/)
KAO( :,10, 9) = (/&
&9.2244E+01_JPRB,8.9827E+01_JPRB,8.7426E+01_JPRB,8.5062E+01_JPRB,8.2760E+01_JPRB/)
KAO( :,11, 9) = (/&
&8.3999E+01_JPRB,8.1726E+01_JPRB,7.9419E+01_JPRB,7.7163E+01_JPRB,7.4981E+01_JPRB/)
KAO( :,12, 9) = (/&
&7.5642E+01_JPRB,7.3608E+01_JPRB,7.1481E+01_JPRB,6.9416E+01_JPRB,6.7422E+01_JPRB/)
KAO( :,13, 9) = (/&
&6.6934E+01_JPRB,6.5046E+01_JPRB,6.3162E+01_JPRB,6.1319E+01_JPRB,5.9545E+01_JPRB/)
KAO( :, 1,10) = (/&
&2.5219E+02_JPRB,2.4571E+02_JPRB,2.3918E+02_JPRB,2.3279E+02_JPRB,2.2858E+02_JPRB/)
KAO( :, 2,10) = (/&
&2.6944E+02_JPRB,2.6208E+02_JPRB,2.5593E+02_JPRB,2.5059E+02_JPRB,2.4739E+02_JPRB/)
KAO( :, 3,10) = (/&
&2.8444E+02_JPRB,2.7711E+02_JPRB,2.7148E+02_JPRB,2.6629E+02_JPRB,2.6255E+02_JPRB/)
KAO( :, 4,10) = (/&
&3.0272E+02_JPRB,2.9452E+02_JPRB,2.8714E+02_JPRB,2.7941E+02_JPRB,2.7276E+02_JPRB/)
KAO( :, 5,10) = (/&
&3.1679E+02_JPRB,3.0877E+02_JPRB,3.0015E+02_JPRB,2.9068E+02_JPRB,2.8102E+02_JPRB/)
KAO( :, 6,10) = (/&
&3.2322E+02_JPRB,3.1468E+02_JPRB,3.0521E+02_JPRB,2.9571E+02_JPRB,2.8597E+02_JPRB/)
KAO( :, 7,10) = (/&
&3.2856E+02_JPRB,3.1908E+02_JPRB,3.0869E+02_JPRB,2.9873E+02_JPRB,2.8901E+02_JPRB/)
KAO( :, 8,10) = (/&
&3.2929E+02_JPRB,3.1918E+02_JPRB,3.0900E+02_JPRB,2.9900E+02_JPRB,2.8972E+02_JPRB/)
KAO( :, 9,10) = (/&
&3.2403E+02_JPRB,3.1482E+02_JPRB,3.0502E+02_JPRB,2.9579E+02_JPRB,2.8721E+02_JPRB/)
KAO( :,10,10) = (/&
&3.1039E+02_JPRB,3.0245E+02_JPRB,2.9340E+02_JPRB,2.8545E+02_JPRB,2.7823E+02_JPRB/)
KAO( :,11,10) = (/&
&2.8971E+02_JPRB,2.8193E+02_JPRB,2.7523E+02_JPRB,2.6877E+02_JPRB,2.6210E+02_JPRB/)
KAO( :,12,10) = (/&
&2.7119E+02_JPRB,2.6399E+02_JPRB,2.5760E+02_JPRB,2.5064E+02_JPRB,2.4326E+02_JPRB/)
KAO( :,13,10) = (/&
&2.5228E+02_JPRB,2.4612E+02_JPRB,2.3937E+02_JPRB,2.3200E+02_JPRB,2.2456E+02_JPRB/)
KAO( :, 1,11) = (/&
&3.2436E+02_JPRB,3.1705E+02_JPRB,3.0936E+02_JPRB,3.0225E+02_JPRB,2.9528E+02_JPRB/)
KAO( :, 2,11) = (/&
&3.6387E+02_JPRB,3.5499E+02_JPRB,3.4471E+02_JPRB,3.3477E+02_JPRB,3.2544E+02_JPRB/)
KAO( :, 3,11) = (/&
&3.9089E+02_JPRB,3.8297E+02_JPRB,3.7268E+02_JPRB,3.6169E+02_JPRB,3.5104E+02_JPRB/)
KAO( :, 4,11) = (/&
&4.0614E+02_JPRB,3.9591E+02_JPRB,3.8584E+02_JPRB,3.7702E+02_JPRB,3.6787E+02_JPRB/)
KAO( :, 5,11) = (/&
&4.2111E+02_JPRB,4.0953E+02_JPRB,3.9791E+02_JPRB,3.8868E+02_JPRB,3.8088E+02_JPRB/)
KAO( :, 6,11) = (/&
&4.4478E+02_JPRB,4.3170E+02_JPRB,4.1878E+02_JPRB,4.0704E+02_JPRB,3.9607E+02_JPRB/)
KAO( :, 7,11) = (/&
&4.6528E+02_JPRB,4.5296E+02_JPRB,4.4095E+02_JPRB,4.2830E+02_JPRB,4.1414E+02_JPRB/)
KAO( :, 8,11) = (/&
&4.8103E+02_JPRB,4.6875E+02_JPRB,4.5586E+02_JPRB,4.4138E+02_JPRB,4.2642E+02_JPRB/)
KAO( :, 9,11) = (/&
&4.9211E+02_JPRB,4.7875E+02_JPRB,4.6419E+02_JPRB,4.4833E+02_JPRB,4.3292E+02_JPRB/)
KAO( :,10,11) = (/&
&4.9428E+02_JPRB,4.7899E+02_JPRB,4.6351E+02_JPRB,4.4779E+02_JPRB,4.3245E+02_JPRB/)
KAO( :,11,11) = (/&
&4.7778E+02_JPRB,4.6338E+02_JPRB,4.4778E+02_JPRB,4.3344E+02_JPRB,4.2003E+02_JPRB/)
KAO( :,12,11) = (/&
&4.5095E+02_JPRB,4.3803E+02_JPRB,4.2442E+02_JPRB,4.1242E+02_JPRB,4.0150E+02_JPRB/)
KAO( :,13,11) = (/&
&4.2162E+02_JPRB,4.0890E+02_JPRB,3.9818E+02_JPRB,3.8811E+02_JPRB,3.7807E+02_JPRB/)
KAO( :, 1,12) = (/&
&4.0765E+02_JPRB,4.0438E+02_JPRB,4.0112E+02_JPRB,3.9703E+02_JPRB,3.9278E+02_JPRB/)
KAO( :, 2,12) = (/&
&4.5408E+02_JPRB,4.4591E+02_JPRB,4.3895E+02_JPRB,4.3184E+02_JPRB,4.2260E+02_JPRB/)
KAO( :, 3,12) = (/&
&5.0754E+02_JPRB,4.9609E+02_JPRB,4.8458E+02_JPRB,4.7355E+02_JPRB,4.6248E+02_JPRB/)
KAO( :, 4,12) = (/&
&5.5729E+02_JPRB,5.4777E+02_JPRB,5.3611E+02_JPRB,5.2186E+02_JPRB,5.0830E+02_JPRB/)
KAO( :, 5,12) = (/&
&5.9884E+02_JPRB,5.9059E+02_JPRB,5.8025E+02_JPRB,5.6682E+02_JPRB,5.5220E+02_JPRB/)
KAO( :, 6,12) = (/&
&6.3069E+02_JPRB,6.2342E+02_JPRB,6.1247E+02_JPRB,5.9971E+02_JPRB,5.8566E+02_JPRB/)
KAO( :, 7,12) = (/&
&6.6576E+02_JPRB,6.5415E+02_JPRB,6.3907E+02_JPRB,6.2535E+02_JPRB,6.1174E+02_JPRB/)
KAO( :, 8,12) = (/&
&7.0612E+02_JPRB,6.9050E+02_JPRB,6.7253E+02_JPRB,6.5500E+02_JPRB,6.3767E+02_JPRB/)
KAO( :, 9,12) = (/&
&7.4151E+02_JPRB,7.2711E+02_JPRB,7.0818E+02_JPRB,6.8887E+02_JPRB,6.6982E+02_JPRB/)
KAO( :,10,12) = (/&
&7.6876E+02_JPRB,7.5445E+02_JPRB,7.3627E+02_JPRB,7.1768E+02_JPRB,6.9714E+02_JPRB/)
KAO( :,11,12) = (/&
&7.8345E+02_JPRB,7.6652E+02_JPRB,7.4553E+02_JPRB,7.2384E+02_JPRB,7.0114E+02_JPRB/)
KAO( :,12,12) = (/&
&7.8623E+02_JPRB,7.6501E+02_JPRB,7.4277E+02_JPRB,7.1917E+02_JPRB,6.9536E+02_JPRB/)
KAO( :,13,12) = (/&
&7.6967E+02_JPRB,7.4813E+02_JPRB,7.2429E+02_JPRB,7.0066E+02_JPRB,6.7901E+02_JPRB/)
KAO( :, 1,13) = (/&
&5.1329E+02_JPRB,5.0716E+02_JPRB,5.0382E+02_JPRB,4.9878E+02_JPRB,4.9356E+02_JPRB/)
KAO( :, 2,13) = (/&
&5.7148E+02_JPRB,5.6846E+02_JPRB,5.6431E+02_JPRB,5.6063E+02_JPRB,5.5653E+02_JPRB/)
KAO( :, 3,13) = (/&
&6.5145E+02_JPRB,6.4483E+02_JPRB,6.3790E+02_JPRB,6.3094E+02_JPRB,6.2717E+02_JPRB/)
KAO( :, 4,13) = (/&
&7.5002E+02_JPRB,7.3461E+02_JPRB,7.2296E+02_JPRB,7.1138E+02_JPRB,7.0213E+02_JPRB/)
KAO( :, 5,13) = (/&
&8.5963E+02_JPRB,8.3647E+02_JPRB,8.1752E+02_JPRB,7.9952E+02_JPRB,7.8427E+02_JPRB/)
KAO( :, 6,13) = (/&
&9.6412E+02_JPRB,9.4095E+02_JPRB,9.1679E+02_JPRB,8.9731E+02_JPRB,8.7656E+02_JPRB/)
KAO( :, 7,13) = (/&
&1.0550E+03_JPRB,1.0327E+03_JPRB,1.0118E+03_JPRB,9.9247E+02_JPRB,9.6895E+02_JPRB/)
KAO( :, 8,13) = (/&
&1.1351E+03_JPRB,1.1102E+03_JPRB,1.0930E+03_JPRB,1.0757E+03_JPRB,1.0518E+03_JPRB/)
KAO( :, 9,13) = (/&
&1.2061E+03_JPRB,1.1763E+03_JPRB,1.1581E+03_JPRB,1.1387E+03_JPRB,1.1187E+03_JPRB/)
KAO( :,10,13) = (/&
&1.2746E+03_JPRB,1.2431E+03_JPRB,1.2211E+03_JPRB,1.1969E+03_JPRB,1.1743E+03_JPRB/)
KAO( :,11,13) = (/&
&1.3270E+03_JPRB,1.3002E+03_JPRB,1.2748E+03_JPRB,1.2457E+03_JPRB,1.2158E+03_JPRB/)
KAO( :,12,13) = (/&
&1.3778E+03_JPRB,1.3525E+03_JPRB,1.3230E+03_JPRB,1.2880E+03_JPRB,1.2527E+03_JPRB/)
KAO( :,13,13) = (/&
&1.4203E+03_JPRB,1.3956E+03_JPRB,1.3627E+03_JPRB,1.3265E+03_JPRB,1.2880E+03_JPRB/)
KAO( :, 1,14) = (/&
&7.0659E+02_JPRB,6.8649E+02_JPRB,6.7585E+02_JPRB,6.6280E+02_JPRB,6.4777E+02_JPRB/)
KAO( :, 2,14) = (/&
&8.1314E+02_JPRB,7.9545E+02_JPRB,7.8563E+02_JPRB,7.7042E+02_JPRB,7.6159E+02_JPRB/)
KAO( :, 3,14) = (/&
&9.2212E+02_JPRB,9.1802E+02_JPRB,9.0672E+02_JPRB,8.9703E+02_JPRB,8.8878E+02_JPRB/)
KAO( :, 4,14) = (/&
&1.0533E+03_JPRB,1.0471E+03_JPRB,1.0407E+03_JPRB,1.0252E+03_JPRB,1.0216E+03_JPRB/)
KAO( :, 5,14) = (/&
&1.1902E+03_JPRB,1.1874E+03_JPRB,1.1827E+03_JPRB,1.1705E+03_JPRB,1.1629E+03_JPRB/)
KAO( :, 6,14) = (/&
&1.3538E+03_JPRB,1.3468E+03_JPRB,1.3305E+03_JPRB,1.3230E+03_JPRB,1.3152E+03_JPRB/)
KAO( :, 7,14) = (/&
&1.5575E+03_JPRB,1.5374E+03_JPRB,1.5135E+03_JPRB,1.4950E+03_JPRB,1.4827E+03_JPRB/)
KAO( :, 8,14) = (/&
&1.7978E+03_JPRB,1.7650E+03_JPRB,1.7335E+03_JPRB,1.7038E+03_JPRB,1.6772E+03_JPRB/)
KAO( :, 9,14) = (/&
&2.0608E+03_JPRB,2.0242E+03_JPRB,1.9804E+03_JPRB,1.9383E+03_JPRB,1.9020E+03_JPRB/)
KAO( :,10,14) = (/&
&2.3189E+03_JPRB,2.2831E+03_JPRB,2.2391E+03_JPRB,2.1847E+03_JPRB,2.1380E+03_JPRB/)
KAO( :,11,14) = (/&
&2.5479E+03_JPRB,2.4992E+03_JPRB,2.4561E+03_JPRB,2.4037E+03_JPRB,2.3531E+03_JPRB/)
KAO( :,12,14) = (/&
&2.7503E+03_JPRB,2.6955E+03_JPRB,2.6487E+03_JPRB,2.6000E+03_JPRB,2.5509E+03_JPRB/)
KAO( :,13,14) = (/&
&2.9348E+03_JPRB,2.8771E+03_JPRB,2.8224E+03_JPRB,2.7731E+03_JPRB,2.7137E+03_JPRB/)
KAO( :, 1,15) = (/&
&1.0087E+03_JPRB,9.8320E+02_JPRB,9.7093E+02_JPRB,9.5615E+02_JPRB,9.3254E+02_JPRB/)
KAO( :, 2,15) = (/&
&1.2013E+03_JPRB,1.1684E+03_JPRB,1.1519E+03_JPRB,1.1213E+03_JPRB,1.1065E+03_JPRB/)
KAO( :, 3,15) = (/&
&1.4276E+03_JPRB,1.4001E+03_JPRB,1.3700E+03_JPRB,1.3257E+03_JPRB,1.3068E+03_JPRB/)
KAO( :, 4,15) = (/&
&1.6836E+03_JPRB,1.6523E+03_JPRB,1.6210E+03_JPRB,1.5698E+03_JPRB,1.5625E+03_JPRB/)
KAO( :, 5,15) = (/&
&1.9769E+03_JPRB,1.9333E+03_JPRB,1.9035E+03_JPRB,1.8613E+03_JPRB,1.8254E+03_JPRB/)
KAO( :, 6,15) = (/&
&2.3172E+03_JPRB,2.2683E+03_JPRB,2.2153E+03_JPRB,2.1871E+03_JPRB,2.1654E+03_JPRB/)
KAO( :, 7,15) = (/&
&2.6839E+03_JPRB,2.6608E+03_JPRB,2.5827E+03_JPRB,2.5461E+03_JPRB,2.5090E+03_JPRB/)
KAO( :, 8,15) = (/&
&3.0767E+03_JPRB,3.0634E+03_JPRB,3.0007E+03_JPRB,2.9429E+03_JPRB,2.9079E+03_JPRB/)
KAO( :, 9,15) = (/&
&3.4941E+03_JPRB,3.4634E+03_JPRB,3.4221E+03_JPRB,3.3814E+03_JPRB,3.3456E+03_JPRB/)
KAO( :,10,15) = (/&
&3.9537E+03_JPRB,3.9378E+03_JPRB,3.9008E+03_JPRB,3.8414E+03_JPRB,3.8169E+03_JPRB/)
KAO( :,11,15) = (/&
&4.5046E+03_JPRB,4.4637E+03_JPRB,4.4210E+03_JPRB,4.3583E+03_JPRB,4.3332E+03_JPRB/)
KAO( :,12,15) = (/&
&5.1528E+03_JPRB,5.0823E+03_JPRB,5.0105E+03_JPRB,4.9465E+03_JPRB,4.9071E+03_JPRB/)
KAO( :,13,15) = (/&
&5.8749E+03_JPRB,5.7913E+03_JPRB,5.6995E+03_JPRB,5.6331E+03_JPRB,5.5557E+03_JPRB/)
KAO( :, 1,16) = (/&
&1.2189E+03_JPRB,1.2224E+03_JPRB,1.2164E+03_JPRB,1.2064E+03_JPRB,1.1935E+03_JPRB/)
KAO( :, 2,16) = (/&
&1.4789E+03_JPRB,1.4888E+03_JPRB,1.4867E+03_JPRB,1.4809E+03_JPRB,1.4687E+03_JPRB/)
KAO( :, 3,16) = (/&
&1.8114E+03_JPRB,1.8246E+03_JPRB,1.8350E+03_JPRB,1.8138E+03_JPRB,1.8019E+03_JPRB/)
KAO( :, 4,16) = (/&
&2.1704E+03_JPRB,2.2074E+03_JPRB,2.2239E+03_JPRB,2.2048E+03_JPRB,2.2173E+03_JPRB/)
KAO( :, 5,16) = (/&
&2.5886E+03_JPRB,2.6353E+03_JPRB,2.6810E+03_JPRB,2.6789E+03_JPRB,2.6704E+03_JPRB/)
KAO( :, 6,16) = (/&
&3.0777E+03_JPRB,3.1359E+03_JPRB,3.1850E+03_JPRB,3.2159E+03_JPRB,3.2625E+03_JPRB/)
KAO( :, 7,16) = (/&
&3.6815E+03_JPRB,3.7549E+03_JPRB,3.7825E+03_JPRB,3.8441E+03_JPRB,3.9118E+03_JPRB/)
KAO( :, 8,16) = (/&
&4.4826E+03_JPRB,4.4982E+03_JPRB,4.5205E+03_JPRB,4.5598E+03_JPRB,4.6673E+03_JPRB/)
KAO( :, 9,16) = (/&
&5.4808E+03_JPRB,5.4311E+03_JPRB,5.4325E+03_JPRB,5.4480E+03_JPRB,5.4909E+03_JPRB/)
KAO( :,10,16) = (/&
&6.6128E+03_JPRB,6.5719E+03_JPRB,6.5761E+03_JPRB,6.5449E+03_JPRB,6.5647E+03_JPRB/)
KAO( :,11,16) = (/&
&7.9375E+03_JPRB,7.9476E+03_JPRB,7.9279E+03_JPRB,7.8912E+03_JPRB,7.8532E+03_JPRB/)
KAO( :,12,16) = (/&
&9.5403E+03_JPRB,9.5531E+03_JPRB,9.5122E+03_JPRB,9.4385E+03_JPRB,9.3648E+03_JPRB/)
KAO( :,13,16) = (/&
&1.1398E+04_JPRB,1.1400E+04_JPRB,1.1334E+04_JPRB,1.1241E+04_JPRB,1.1075E+04_JPRB/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
 &1.84925E+00_JPRB,1.65087E+00_JPRB,1.47377E+00_JPRB,1.31567E+00_JPRB,1.17453E+00_JPRB,&
 &1.04853E+00_JPRB,9.36042E-01_JPRB,8.35626E-01_JPRB,7.45982E-01_JPRB,6.65955E-01_JPRB/)
SELFREFO( :, 2) = (/&
 &5.91460E+00_JPRB,5.37056E+00_JPRB,4.87657E+00_JPRB,4.42802E+00_JPRB,4.02073E+00_JPRB,&
 &3.65090E+00_JPRB,3.31508E+00_JPRB,3.01016E+00_JPRB,2.73328E+00_JPRB,2.48187E+00_JPRB/)
SELFREFO( :, 3) = (/&
 &6.37319E+00_JPRB,5.76807E+00_JPRB,5.22041E+00_JPRB,4.72475E+00_JPRB,4.27614E+00_JPRB,&
 &3.87014E+00_JPRB,3.50268E+00_JPRB,3.17011E+00_JPRB,2.86911E+00_JPRB,2.59670E+00_JPRB/)
SELFREFO( :, 4) = (/&
 &6.24391E+00_JPRB,5.67335E+00_JPRB,5.15493E+00_JPRB,4.68388E+00_JPRB,4.25588E+00_JPRB,&
 &3.86699E+00_JPRB,3.51363E+00_JPRB,3.19256E+00_JPRB,2.90083E+00_JPRB,2.63576E+00_JPRB/)
SELFREFO( :, 5) = (/&
 &6.28855E+00_JPRB,5.70697E+00_JPRB,5.17918E+00_JPRB,4.70019E+00_JPRB,4.26551E+00_JPRB,&
 &3.87103E+00_JPRB,3.51303E+00_JPRB,3.18813E+00_JPRB,2.89329E+00_JPRB,2.62571E+00_JPRB/)
SELFREFO( :, 6) = (/&
 &6.15500E+00_JPRB,5.58229E+00_JPRB,5.06287E+00_JPRB,4.59178E+00_JPRB,4.16453E+00_JPRB,&
 &3.77703E+00_JPRB,3.42558E+00_JPRB,3.10684E+00_JPRB,2.81776E+00_JPRB,2.55557E+00_JPRB/)
SELFREFO( :, 7) = (/&
 &6.25544E+00_JPRB,5.67036E+00_JPRB,5.14000E+00_JPRB,4.65925E+00_JPRB,4.22346E+00_JPRB,&
 &3.82844E+00_JPRB,3.47036E+00_JPRB,3.14577E+00_JPRB,2.85154E+00_JPRB,2.58483E+00_JPRB/)
SELFREFO( :, 8) = (/&
 &6.08431E+00_JPRB,5.55653E+00_JPRB,5.07454E+00_JPRB,4.63436E+00_JPRB,4.23236E+00_JPRB,&
 &3.86523E+00_JPRB,3.52994E+00_JPRB,3.22374E+00_JPRB,2.94410E+00_JPRB,2.68872E+00_JPRB/)
SELFREFO( :, 9) = (/&
 &6.22772E+00_JPRB,5.71381E+00_JPRB,5.24231E+00_JPRB,4.80972E+00_JPRB,4.41282E+00_JPRB,&
 &4.04868E+00_JPRB,3.71458E+00_JPRB,3.40806E+00_JPRB,3.12683E+00_JPRB,2.86880E+00_JPRB/)
SELFREFO( :,10) = (/&
 &6.63397E+00_JPRB,6.10398E+00_JPRB,5.61633E+00_JPRB,5.16764E+00_JPRB,4.75480E+00_JPRB,&
 &4.37494E+00_JPRB,4.02543E+00_JPRB,3.70384E+00_JPRB,3.40794E+00_JPRB,3.13568E+00_JPRB/)
SELFREFO( :,11) = (/&
 &7.05802E+00_JPRB,6.40896E+00_JPRB,5.81959E+00_JPRB,5.28442E+00_JPRB,4.79846E+00_JPRB,&
 &4.35719E+00_JPRB,3.95651E+00_JPRB,3.59266E+00_JPRB,3.26228E+00_JPRB,2.96228E+00_JPRB/)
SELFREFO( :,12) = (/&
 &7.26302E+00_JPRB,6.57623E+00_JPRB,5.95438E+00_JPRB,5.39134E+00_JPRB,4.88153E+00_JPRB,&
 &4.41994E+00_JPRB,4.00199E+00_JPRB,3.62356E+00_JPRB,3.28092E+00_JPRB,2.97067E+00_JPRB/)
SELFREFO( :,13) = (/&
 &6.76462E+00_JPRB,6.23813E+00_JPRB,5.75262E+00_JPRB,5.30490E+00_JPRB,4.89202E+00_JPRB,&
 &4.51128E+00_JPRB,4.16017E+00_JPRB,3.83638E+00_JPRB,3.53780E+00_JPRB,3.26245E+00_JPRB/)
SELFREFO( :,14) = (/&
 &7.35977E+00_JPRB,6.71848E+00_JPRB,6.13306E+00_JPRB,5.59866E+00_JPRB,5.11082E+00_JPRB,&
 &4.66549E+00_JPRB,4.25896E+00_JPRB,3.88786E+00_JPRB,3.54909E+00_JPRB,3.23984E+00_JPRB/)
SELFREFO( :,15) = (/&
 &7.51978E+00_JPRB,6.83155E+00_JPRB,6.20632E+00_JPRB,5.63830E+00_JPRB,5.12227E+00_JPRB,&
 &4.65347E+00_JPRB,4.22758E+00_JPRB,3.84066E+00_JPRB,3.48915E+00_JPRB,3.16982E+00_JPRB/)
SELFREFO( :,16) = (/&
 &6.95561E+00_JPRB,6.36239E+00_JPRB,5.81977E+00_JPRB,5.32342E+00_JPRB,4.86941E+00_JPRB,&
 &4.45411E+00_JPRB,4.07424E+00_JPRB,3.72676E+00_JPRB,3.40892E+00_JPRB,3.11819E+00_JPRB/)

!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB1_01
