!OCL SCALAR
SUBROUTINE RRTM_KGB16_A1

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 16:  2600-3000 cm-1 (low - H2O,CH4; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO16, ONLY : KAO     ,SELFREFO   ,FRACREFAO
USE YOERRTA16, ONLY : STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 9) = (/&
&4.2634E-03_JPRB,4.4619E-03_JPRB,4.8277E-03_JPRB,5.0574E-03_JPRB,5.1432E-03_JPRB,5.0824E-03_JPRB,&
&4.7995E-03_JPRB,4.2519E-03_JPRB,3.6751E-03_JPRB/)
KAO( :, 2, 1, 9) = (/&
&4.3896E-03_JPRB,4.7056E-03_JPRB,5.1713E-03_JPRB,5.4539E-03_JPRB,5.5796E-03_JPRB,5.5445E-03_JPRB,&
&5.2467E-03_JPRB,4.6622E-03_JPRB,4.1226E-03_JPRB/)
KAO( :, 3, 1, 9) = (/&
&4.5152E-03_JPRB,4.9543E-03_JPRB,5.5160E-03_JPRB,5.8544E-03_JPRB,6.0168E-03_JPRB,5.9967E-03_JPRB,&
&5.6895E-03_JPRB,5.0855E-03_JPRB,4.6113E-03_JPRB/)
KAO( :, 4, 1, 9) = (/&
&4.6230E-03_JPRB,5.1933E-03_JPRB,5.8501E-03_JPRB,6.2450E-03_JPRB,6.4433E-03_JPRB,6.4316E-03_JPRB,&
&6.1283E-03_JPRB,5.5148E-03_JPRB,5.1307E-03_JPRB/)
KAO( :, 5, 1, 9) = (/&
&4.7302E-03_JPRB,5.4309E-03_JPRB,6.1815E-03_JPRB,6.6303E-03_JPRB,6.8597E-03_JPRB,6.8605E-03_JPRB,&
&6.5693E-03_JPRB,5.9487E-03_JPRB,5.6753E-03_JPRB/)
KAO( :, 1, 2, 9) = (/&
&3.9323E-03_JPRB,4.1568E-03_JPRB,4.4806E-03_JPRB,4.6618E-03_JPRB,4.7304E-03_JPRB,4.6715E-03_JPRB,&
&4.4161E-03_JPRB,3.9503E-03_JPRB,3.3395E-03_JPRB/)
KAO( :, 2, 2, 9) = (/&
&4.0500E-03_JPRB,4.3934E-03_JPRB,4.8123E-03_JPRB,5.0480E-03_JPRB,5.1574E-03_JPRB,5.1013E-03_JPRB,&
&4.8274E-03_JPRB,4.3142E-03_JPRB,3.7073E-03_JPRB/)
KAO( :, 3, 2, 9) = (/&
&4.1698E-03_JPRB,4.6359E-03_JPRB,5.1475E-03_JPRB,5.4370E-03_JPRB,5.5831E-03_JPRB,5.5288E-03_JPRB,&
&5.2416E-03_JPRB,4.6953E-03_JPRB,4.1146E-03_JPRB/)
KAO( :, 4, 2, 9) = (/&
&4.2783E-03_JPRB,4.8739E-03_JPRB,5.4745E-03_JPRB,5.8228E-03_JPRB,5.9955E-03_JPRB,5.9514E-03_JPRB,&
&5.6672E-03_JPRB,5.0790E-03_JPRB,4.5488E-03_JPRB/)
KAO( :, 5, 2, 9) = (/&
&4.3743E-03_JPRB,5.1081E-03_JPRB,5.7929E-03_JPRB,6.1965E-03_JPRB,6.3958E-03_JPRB,6.3715E-03_JPRB,&
&6.0950E-03_JPRB,5.4684E-03_JPRB,5.0068E-03_JPRB/)
KAO( :, 1, 3, 9) = (/&
&3.6113E-03_JPRB,3.8183E-03_JPRB,4.0778E-03_JPRB,4.1984E-03_JPRB,4.2534E-03_JPRB,4.2158E-03_JPRB,&
&4.0193E-03_JPRB,3.6415E-03_JPRB,3.0570E-03_JPRB/)
KAO( :, 2, 3, 9) = (/&
&3.7209E-03_JPRB,4.0412E-03_JPRB,4.3896E-03_JPRB,4.5667E-03_JPRB,4.6475E-03_JPRB,4.5983E-03_JPRB,&
&4.3872E-03_JPRB,3.9635E-03_JPRB,3.3466E-03_JPRB/)
KAO( :, 3, 3, 9) = (/&
&3.8298E-03_JPRB,4.2704E-03_JPRB,4.6995E-03_JPRB,4.9388E-03_JPRB,5.0426E-03_JPRB,4.9845E-03_JPRB,&
&4.7617E-03_JPRB,4.3009E-03_JPRB,3.6653E-03_JPRB/)
KAO( :, 4, 3, 9) = (/&
&3.9362E-03_JPRB,4.5071E-03_JPRB,5.0123E-03_JPRB,5.3097E-03_JPRB,5.4362E-03_JPRB,5.3784E-03_JPRB,&
&5.1527E-03_JPRB,4.6419E-03_JPRB,4.0116E-03_JPRB/)
KAO( :, 5, 3, 9) = (/&
&4.0246E-03_JPRB,4.7366E-03_JPRB,5.3187E-03_JPRB,5.6677E-03_JPRB,5.8209E-03_JPRB,5.7784E-03_JPRB,&
&5.5482E-03_JPRB,4.9812E-03_JPRB,4.3840E-03_JPRB/)
KAO( :, 1, 4, 9) = (/&
&3.3284E-03_JPRB,3.4973E-03_JPRB,3.6827E-03_JPRB,3.7696E-03_JPRB,3.8145E-03_JPRB,3.7973E-03_JPRB,&
&3.6757E-03_JPRB,3.3953E-03_JPRB,2.8711E-03_JPRB/)
KAO( :, 2, 4, 9) = (/&
&3.4305E-03_JPRB,3.7049E-03_JPRB,3.9652E-03_JPRB,4.1049E-03_JPRB,4.1671E-03_JPRB,4.1383E-03_JPRB,&
&3.9965E-03_JPRB,3.6722E-03_JPRB,3.0945E-03_JPRB/)
KAO( :, 3, 4, 9) = (/&
&3.5295E-03_JPRB,3.9206E-03_JPRB,4.2522E-03_JPRB,4.4452E-03_JPRB,4.5189E-03_JPRB,4.4874E-03_JPRB,&
&4.3285E-03_JPRB,3.9676E-03_JPRB,3.3441E-03_JPRB/)
KAO( :, 4, 4, 9) = (/&
&3.6215E-03_JPRB,4.1396E-03_JPRB,4.5422E-03_JPRB,4.7812E-03_JPRB,4.8736E-03_JPRB,4.8440E-03_JPRB,&
&4.6768E-03_JPRB,4.2674E-03_JPRB,3.6212E-03_JPRB/)
KAO( :, 5, 4, 9) = (/&
&3.7121E-03_JPRB,4.3594E-03_JPRB,4.8380E-03_JPRB,5.1176E-03_JPRB,5.2295E-03_JPRB,5.2140E-03_JPRB,&
&5.0347E-03_JPRB,4.5696E-03_JPRB,3.9241E-03_JPRB/)
KAO( :, 1, 5, 9) = (/&
&3.0937E-03_JPRB,3.2190E-03_JPRB,3.3382E-03_JPRB,3.4069E-03_JPRB,3.4508E-03_JPRB,3.4576E-03_JPRB,&
&3.4038E-03_JPRB,3.2121E-03_JPRB,2.7159E-03_JPRB/)
KAO( :, 2, 5, 9) = (/&
&3.1841E-03_JPRB,3.4102E-03_JPRB,3.5885E-03_JPRB,3.6988E-03_JPRB,3.7561E-03_JPRB,3.7570E-03_JPRB,&
&3.6806E-03_JPRB,3.4524E-03_JPRB,2.9248E-03_JPRB/)
KAO( :, 3, 5, 9) = (/&
&3.2704E-03_JPRB,3.6051E-03_JPRB,3.8485E-03_JPRB,3.9980E-03_JPRB,4.0672E-03_JPRB,4.0649E-03_JPRB,&
&3.9688E-03_JPRB,3.7070E-03_JPRB,3.1394E-03_JPRB/)
KAO( :, 4, 5, 9) = (/&
&3.3530E-03_JPRB,3.8023E-03_JPRB,4.1127E-03_JPRB,4.2944E-03_JPRB,4.3822E-03_JPRB,4.3830E-03_JPRB,&
&4.2728E-03_JPRB,3.9665E-03_JPRB,3.3644E-03_JPRB/)
KAO( :, 5, 5, 9) = (/&
&3.4386E-03_JPRB,4.0026E-03_JPRB,4.3842E-03_JPRB,4.5975E-03_JPRB,4.7014E-03_JPRB,4.7133E-03_JPRB,&
&4.5874E-03_JPRB,4.2339E-03_JPRB,3.6103E-03_JPRB/)
KAO( :, 1, 6, 9) = (/&
&2.9009E-03_JPRB,2.9757E-03_JPRB,3.0499E-03_JPRB,3.1038E-03_JPRB,3.1541E-03_JPRB,3.1847E-03_JPRB,&
&3.1836E-03_JPRB,3.0557E-03_JPRB,2.5583E-03_JPRB/)
KAO( :, 2, 6, 9) = (/&
&2.9774E-03_JPRB,3.1460E-03_JPRB,3.2679E-03_JPRB,3.3537E-03_JPRB,3.4147E-03_JPRB,3.4421E-03_JPRB,&
&3.4203E-03_JPRB,3.2723E-03_JPRB,2.7519E-03_JPRB/)
KAO( :, 3, 6, 9) = (/&
&3.0522E-03_JPRB,3.3185E-03_JPRB,3.4964E-03_JPRB,3.6100E-03_JPRB,3.6827E-03_JPRB,3.7087E-03_JPRB,&
&3.6668E-03_JPRB,3.4927E-03_JPRB,2.9536E-03_JPRB/)
KAO( :, 4, 6, 9) = (/&
&3.1282E-03_JPRB,3.4957E-03_JPRB,3.7291E-03_JPRB,3.8695E-03_JPRB,3.9556E-03_JPRB,3.9847E-03_JPRB,&
&3.9266E-03_JPRB,3.7176E-03_JPRB,3.1650E-03_JPRB/)
KAO( :, 5, 6, 9) = (/&
&3.1999E-03_JPRB,3.6746E-03_JPRB,3.9646E-03_JPRB,4.1331E-03_JPRB,4.2341E-03_JPRB,4.2712E-03_JPRB,&
&4.1979E-03_JPRB,3.9512E-03_JPRB,3.3876E-03_JPRB/)
KAO( :, 1, 7, 9) = (/&
&2.7415E-03_JPRB,2.7746E-03_JPRB,2.8210E-03_JPRB,2.8741E-03_JPRB,2.9327E-03_JPRB,2.9829E-03_JPRB,&
&2.9928E-03_JPRB,2.8802E-03_JPRB,2.4517E-03_JPRB/)
KAO( :, 2, 7, 9) = (/&
&2.8079E-03_JPRB,2.9223E-03_JPRB,3.0084E-03_JPRB,3.0853E-03_JPRB,3.1485E-03_JPRB,3.1999E-03_JPRB,&
&3.2078E-03_JPRB,3.0910E-03_JPRB,2.6310E-03_JPRB/)
KAO( :, 3, 7, 9) = (/&
&2.8746E-03_JPRB,3.0732E-03_JPRB,3.2043E-03_JPRB,3.3040E-03_JPRB,3.3751E-03_JPRB,3.4239E-03_JPRB,&
&3.4236E-03_JPRB,3.2999E-03_JPRB,2.8151E-03_JPRB/)
KAO( :, 4, 7, 9) = (/&
&2.9412E-03_JPRB,3.2304E-03_JPRB,3.4053E-03_JPRB,3.5266E-03_JPRB,3.6086E-03_JPRB,3.6573E-03_JPRB,&
&3.6460E-03_JPRB,3.5085E-03_JPRB,3.0037E-03_JPRB/)
KAO( :, 5, 7, 9) = (/&
&3.0012E-03_JPRB,3.3903E-03_JPRB,3.6088E-03_JPRB,3.7519E-03_JPRB,3.8465E-03_JPRB,3.9004E-03_JPRB,&
&3.8789E-03_JPRB,3.7197E-03_JPRB,3.2035E-03_JPRB/)
KAO( :, 1, 8, 9) = (/&
&2.6011E-03_JPRB,2.6087E-03_JPRB,2.6505E-03_JPRB,2.7115E-03_JPRB,2.7795E-03_JPRB,2.8145E-03_JPRB,&
&2.7964E-03_JPRB,2.6829E-03_JPRB,2.5124E-03_JPRB/)
KAO( :, 2, 8, 9) = (/&
&2.6605E-03_JPRB,2.7384E-03_JPRB,2.8102E-03_JPRB,2.8876E-03_JPRB,2.9588E-03_JPRB,3.0106E-03_JPRB,&
&2.9995E-03_JPRB,2.8886E-03_JPRB,2.6866E-03_JPRB/)
KAO( :, 3, 8, 9) = (/&
&2.7221E-03_JPRB,2.8708E-03_JPRB,2.9770E-03_JPRB,3.0697E-03_JPRB,3.1469E-03_JPRB,3.2045E-03_JPRB,&
&3.2054E-03_JPRB,3.0872E-03_JPRB,2.8608E-03_JPRB/)
KAO( :, 4, 8, 9) = (/&
&2.7814E-03_JPRB,3.0087E-03_JPRB,3.1469E-03_JPRB,3.2564E-03_JPRB,3.3407E-03_JPRB,3.4007E-03_JPRB,&
&3.4134E-03_JPRB,3.2854E-03_JPRB,3.0367E-03_JPRB/)
KAO( :, 5, 8, 9) = (/&
&2.8334E-03_JPRB,3.1463E-03_JPRB,3.3224E-03_JPRB,3.4471E-03_JPRB,3.5390E-03_JPRB,3.6049E-03_JPRB,&
&3.6218E-03_JPRB,3.4862E-03_JPRB,3.2148E-03_JPRB/)
KAO( :, 1, 9, 9) = (/&
&2.4681E-03_JPRB,2.4670E-03_JPRB,2.5193E-03_JPRB,2.5927E-03_JPRB,2.6437E-03_JPRB,2.6462E-03_JPRB,&
&2.5937E-03_JPRB,2.4688E-03_JPRB,4.0106E-03_JPRB/)
KAO( :, 2, 9, 9) = (/&
&2.5243E-03_JPRB,2.5823E-03_JPRB,2.6553E-03_JPRB,2.7401E-03_JPRB,2.8086E-03_JPRB,2.8274E-03_JPRB,&
&2.7863E-03_JPRB,2.6637E-03_JPRB,4.1870E-03_JPRB/)
KAO( :, 3, 9, 9) = (/&
&2.5817E-03_JPRB,2.6985E-03_JPRB,2.7975E-03_JPRB,2.8934E-03_JPRB,2.9743E-03_JPRB,3.0076E-03_JPRB,&
&2.9804E-03_JPRB,2.8541E-03_JPRB,4.3637E-03_JPRB/)
KAO( :, 4, 9, 9) = (/&
&2.6357E-03_JPRB,2.8178E-03_JPRB,2.9439E-03_JPRB,3.0496E-03_JPRB,3.1384E-03_JPRB,3.1881E-03_JPRB,&
&3.1729E-03_JPRB,3.0435E-03_JPRB,4.5427E-03_JPRB/)
KAO( :, 5, 9, 9) = (/&
&2.6826E-03_JPRB,2.9379E-03_JPRB,3.0923E-03_JPRB,3.2096E-03_JPRB,3.3016E-03_JPRB,3.3682E-03_JPRB,&
&3.3659E-03_JPRB,3.2338E-03_JPRB,4.7326E-03_JPRB/)
KAO( :, 1,10, 9) = (/&
&2.3365E-03_JPRB,2.3445E-03_JPRB,2.4180E-03_JPRB,2.4933E-03_JPRB,2.5143E-03_JPRB,2.4864E-03_JPRB,&
&2.4076E-03_JPRB,2.2631E-03_JPRB,1.0002E-02_JPRB/)
KAO( :, 2,10, 9) = (/&
&2.3916E-03_JPRB,2.4482E-03_JPRB,2.5366E-03_JPRB,2.6275E-03_JPRB,2.6688E-03_JPRB,2.6554E-03_JPRB,&
&2.5866E-03_JPRB,2.4438E-03_JPRB,1.0188E-02_JPRB/)
KAO( :, 3,10, 9) = (/&
&2.4458E-03_JPRB,2.5525E-03_JPRB,2.6602E-03_JPRB,2.7640E-03_JPRB,2.8222E-03_JPRB,2.8241E-03_JPRB,&
&2.7676E-03_JPRB,2.6219E-03_JPRB,1.0447E-02_JPRB/)
KAO( :, 4,10, 9) = (/&
&2.4945E-03_JPRB,2.6579E-03_JPRB,2.7873E-03_JPRB,2.8998E-03_JPRB,2.9729E-03_JPRB,2.9898E-03_JPRB,&
&2.9465E-03_JPRB,2.7998E-03_JPRB,1.0769E-02_JPRB/)
KAO( :, 5,10, 9) = (/&
&2.5382E-03_JPRB,2.7637E-03_JPRB,2.9128E-03_JPRB,3.0348E-03_JPRB,3.1210E-03_JPRB,3.1536E-03_JPRB,&
&3.1245E-03_JPRB,2.9806E-03_JPRB,1.1144E-02_JPRB/)
KAO( :, 1,11, 9) = (/&
&2.2189E-03_JPRB,2.2637E-03_JPRB,2.3663E-03_JPRB,2.4375E-03_JPRB,2.4436E-03_JPRB,2.3971E-03_JPRB,&
&2.2998E-03_JPRB,2.1349E-03_JPRB,1.4165E-02_JPRB/)
KAO( :, 2,11, 9) = (/&
&2.2725E-03_JPRB,2.3594E-03_JPRB,2.4775E-03_JPRB,2.5648E-03_JPRB,2.5873E-03_JPRB,2.5525E-03_JPRB,&
&2.4655E-03_JPRB,2.2999E-03_JPRB,1.4362E-02_JPRB/)
KAO( :, 3,11, 9) = (/&
&2.3225E-03_JPRB,2.4563E-03_JPRB,2.5905E-03_JPRB,2.6905E-03_JPRB,2.7282E-03_JPRB,2.7081E-03_JPRB,&
&2.6314E-03_JPRB,2.4622E-03_JPRB,1.4689E-02_JPRB/)
KAO( :, 4,11, 9) = (/&
&2.3671E-03_JPRB,2.5537E-03_JPRB,2.7011E-03_JPRB,2.8153E-03_JPRB,2.8667E-03_JPRB,2.8616E-03_JPRB,&
&2.7947E-03_JPRB,2.6271E-03_JPRB,1.5129E-02_JPRB/)
KAO( :, 5,11, 9) = (/&
&2.4082E-03_JPRB,2.6482E-03_JPRB,2.8083E-03_JPRB,2.9363E-03_JPRB,3.0040E-03_JPRB,3.0155E-03_JPRB,&
&2.9597E-03_JPRB,2.7977E-03_JPRB,1.5652E-02_JPRB/)
KAO( :, 1,12, 9) = (/&
&2.0910E-03_JPRB,2.1698E-03_JPRB,2.2939E-03_JPRB,2.3579E-03_JPRB,2.3558E-03_JPRB,2.2934E-03_JPRB,&
&2.1816E-03_JPRB,2.0022E-03_JPRB,1.5828E-02_JPRB/)
KAO( :, 2,12, 9) = (/&
&2.1414E-03_JPRB,2.2595E-03_JPRB,2.4019E-03_JPRB,2.4797E-03_JPRB,2.4872E-03_JPRB,2.4364E-03_JPRB,&
&2.3325E-03_JPRB,2.1497E-03_JPRB,1.6052E-02_JPRB/)
KAO( :, 3,12, 9) = (/&
&2.1876E-03_JPRB,2.3512E-03_JPRB,2.5089E-03_JPRB,2.5983E-03_JPRB,2.6170E-03_JPRB,2.5791E-03_JPRB,&
&2.4816E-03_JPRB,2.2977E-03_JPRB,1.6424E-02_JPRB/)
KAO( :, 4,12, 9) = (/&
&2.2305E-03_JPRB,2.4411E-03_JPRB,2.6103E-03_JPRB,2.7123E-03_JPRB,2.7468E-03_JPRB,2.7221E-03_JPRB,&
&2.6302E-03_JPRB,2.4491E-03_JPRB,1.6928E-02_JPRB/)
KAO( :, 5,12, 9) = (/&
&2.2685E-03_JPRB,2.5264E-03_JPRB,2.7071E-03_JPRB,2.8237E-03_JPRB,2.8760E-03_JPRB,2.8651E-03_JPRB,&
&2.7812E-03_JPRB,2.6061E-03_JPRB,1.7523E-02_JPRB/)
KAO( :, 1,13, 9) = (/&
&1.9577E-03_JPRB,2.0704E-03_JPRB,2.2038E-03_JPRB,2.2584E-03_JPRB,2.2491E-03_JPRB,2.1789E-03_JPRB,&
&2.0585E-03_JPRB,1.8702E-03_JPRB,1.4483E-02_JPRB/)
KAO( :, 2,13, 9) = (/&
&2.0058E-03_JPRB,2.1546E-03_JPRB,2.3069E-03_JPRB,2.3735E-03_JPRB,2.3721E-03_JPRB,2.3101E-03_JPRB,&
&2.1933E-03_JPRB,2.0001E-03_JPRB,1.4716E-02_JPRB/)
KAO( :, 3,13, 9) = (/&
&2.0506E-03_JPRB,2.2392E-03_JPRB,2.4060E-03_JPRB,2.4864E-03_JPRB,2.4932E-03_JPRB,2.4402E-03_JPRB,&
&2.3277E-03_JPRB,2.1324E-03_JPRB,1.5081E-02_JPRB/)
KAO( :, 4,13, 9) = (/&
&2.0915E-03_JPRB,2.3209E-03_JPRB,2.5015E-03_JPRB,2.5952E-03_JPRB,2.6152E-03_JPRB,2.5711E-03_JPRB,&
&2.4622E-03_JPRB,2.2684E-03_JPRB,1.5556E-02_JPRB/)
KAO( :, 5,13, 9) = (/&
&2.1275E-03_JPRB,2.3984E-03_JPRB,2.5936E-03_JPRB,2.7019E-03_JPRB,2.7369E-03_JPRB,2.7034E-03_JPRB,&
&2.5998E-03_JPRB,2.4103E-03_JPRB,1.6100E-02_JPRB/)
KAO( :, 1, 1,10) = (/&
&1.7685E-02_JPRB,1.5886E-02_JPRB,1.5286E-02_JPRB,1.4910E-02_JPRB,1.4213E-02_JPRB,1.2872E-02_JPRB,&
&1.1554E-02_JPRB,9.7299E-03_JPRB,9.7670E-03_JPRB/)
KAO( :, 2, 1,10) = (/&
&1.7924E-02_JPRB,1.6198E-02_JPRB,1.5800E-02_JPRB,1.5762E-02_JPRB,1.5013E-02_JPRB,1.3648E-02_JPRB,&
&1.2502E-02_JPRB,1.0682E-02_JPRB,1.1264E-02_JPRB/)
KAO( :, 3, 1,10) = (/&
&1.8162E-02_JPRB,1.6493E-02_JPRB,1.6320E-02_JPRB,1.6501E-02_JPRB,1.5785E-02_JPRB,1.4461E-02_JPRB,&
&1.3394E-02_JPRB,1.1688E-02_JPRB,1.2766E-02_JPRB/)
KAO( :, 4, 1,10) = (/&
&1.8373E-02_JPRB,1.6799E-02_JPRB,1.6869E-02_JPRB,1.7132E-02_JPRB,1.6537E-02_JPRB,1.5302E-02_JPRB,&
&1.4231E-02_JPRB,1.2873E-02_JPRB,1.4298E-02_JPRB/)
KAO( :, 5, 1,10) = (/&
&1.8575E-02_JPRB,1.7109E-02_JPRB,1.7449E-02_JPRB,1.7721E-02_JPRB,1.7274E-02_JPRB,1.6125E-02_JPRB,&
&1.4995E-02_JPRB,1.4230E-02_JPRB,1.5931E-02_JPRB/)
KAO( :, 1, 2,10) = (/&
&1.6873E-02_JPRB,1.5273E-02_JPRB,1.4928E-02_JPRB,1.4779E-02_JPRB,1.3931E-02_JPRB,1.2662E-02_JPRB,&
&1.1382E-02_JPRB,9.2864E-03_JPRB,8.6917E-03_JPRB/)
KAO( :, 2, 2,10) = (/&
&1.7158E-02_JPRB,1.5636E-02_JPRB,1.5517E-02_JPRB,1.5568E-02_JPRB,1.4735E-02_JPRB,1.3617E-02_JPRB,&
&1.2343E-02_JPRB,1.0165E-02_JPRB,1.0091E-02_JPRB/)
KAO( :, 3, 2,10) = (/&
&1.7424E-02_JPRB,1.6018E-02_JPRB,1.6130E-02_JPRB,1.6288E-02_JPRB,1.5522E-02_JPRB,1.4562E-02_JPRB,&
&1.3276E-02_JPRB,1.1047E-02_JPRB,1.1539E-02_JPRB/)
KAO( :, 4, 2,10) = (/&
&1.7705E-02_JPRB,1.6391E-02_JPRB,1.6775E-02_JPRB,1.6913E-02_JPRB,1.6383E-02_JPRB,1.5440E-02_JPRB,&
&1.4111E-02_JPRB,1.2115E-02_JPRB,1.3109E-02_JPRB/)
KAO( :, 5, 2,10) = (/&
&1.7946E-02_JPRB,1.6730E-02_JPRB,1.7389E-02_JPRB,1.7560E-02_JPRB,1.7230E-02_JPRB,1.6260E-02_JPRB,&
&1.4862E-02_JPRB,1.3377E-02_JPRB,1.4792E-02_JPRB/)
KAO( :, 1, 3,10) = (/&
&1.5798E-02_JPRB,1.4431E-02_JPRB,1.4230E-02_JPRB,1.4159E-02_JPRB,1.3349E-02_JPRB,1.2204E-02_JPRB,&
&1.0867E-02_JPRB,8.8000E-03_JPRB,7.4513E-03_JPRB/)
KAO( :, 2, 3,10) = (/&
&1.6121E-02_JPRB,1.4897E-02_JPRB,1.4916E-02_JPRB,1.4922E-02_JPRB,1.4162E-02_JPRB,1.3251E-02_JPRB,&
&1.1847E-02_JPRB,9.5823E-03_JPRB,8.7330E-03_JPRB/)
KAO( :, 3, 3,10) = (/&
&1.6462E-02_JPRB,1.5342E-02_JPRB,1.5618E-02_JPRB,1.5620E-02_JPRB,1.5015E-02_JPRB,1.4282E-02_JPRB,&
&1.2797E-02_JPRB,1.0384E-02_JPRB,1.0179E-02_JPRB/)
KAO( :, 4, 3,10) = (/&
&1.6798E-02_JPRB,1.5765E-02_JPRB,1.6290E-02_JPRB,1.6289E-02_JPRB,1.5973E-02_JPRB,1.5269E-02_JPRB,&
&1.3672E-02_JPRB,1.1383E-02_JPRB,1.1725E-02_JPRB/)
KAO( :, 5, 3,10) = (/&
&1.7062E-02_JPRB,1.6131E-02_JPRB,1.6868E-02_JPRB,1.7006E-02_JPRB,1.6890E-02_JPRB,1.6143E-02_JPRB,&
&1.4482E-02_JPRB,1.2538E-02_JPRB,1.3312E-02_JPRB/)
KAO( :, 1, 4,10) = (/&
&1.4564E-02_JPRB,1.3497E-02_JPRB,1.3366E-02_JPRB,1.3251E-02_JPRB,1.2600E-02_JPRB,1.1517E-02_JPRB,&
&1.0115E-02_JPRB,8.2572E-03_JPRB,6.3788E-03_JPRB/)
KAO( :, 2, 4,10) = (/&
&1.4956E-02_JPRB,1.4021E-02_JPRB,1.4143E-02_JPRB,1.3989E-02_JPRB,1.3446E-02_JPRB,1.2579E-02_JPRB,&
&1.1185E-02_JPRB,9.0656E-03_JPRB,7.4847E-03_JPRB/)
KAO( :, 3, 4,10) = (/&
&1.5366E-02_JPRB,1.4523E-02_JPRB,1.4865E-02_JPRB,1.4686E-02_JPRB,1.4396E-02_JPRB,1.3630E-02_JPRB,&
&1.2209E-02_JPRB,9.8300E-03_JPRB,8.7484E-03_JPRB/)
KAO( :, 4, 4,10) = (/&
&1.5673E-02_JPRB,1.4963E-02_JPRB,1.5538E-02_JPRB,1.5419E-02_JPRB,1.5384E-02_JPRB,1.4661E-02_JPRB,&
&1.3123E-02_JPRB,1.0681E-02_JPRB,1.0095E-02_JPRB/)
KAO( :, 5, 4,10) = (/&
&1.5927E-02_JPRB,1.5374E-02_JPRB,1.6106E-02_JPRB,1.6246E-02_JPRB,1.6331E-02_JPRB,1.5570E-02_JPRB,&
&1.3997E-02_JPRB,1.1612E-02_JPRB,1.1475E-02_JPRB/)
KAO( :, 1, 5,10) = (/&
&1.3266E-02_JPRB,1.2466E-02_JPRB,1.2400E-02_JPRB,1.2242E-02_JPRB,1.1629E-02_JPRB,1.0628E-02_JPRB,&
&9.2898E-03_JPRB,7.6240E-03_JPRB,5.9670E-03_JPRB/)
KAO( :, 2, 5,10) = (/&
&1.3732E-02_JPRB,1.3052E-02_JPRB,1.3208E-02_JPRB,1.3005E-02_JPRB,1.2522E-02_JPRB,1.1685E-02_JPRB,&
&1.0389E-02_JPRB,8.4463E-03_JPRB,6.6100E-03_JPRB/)
KAO( :, 3, 5,10) = (/&
&1.4084E-02_JPRB,1.3547E-02_JPRB,1.3938E-02_JPRB,1.3750E-02_JPRB,1.3484E-02_JPRB,1.2725E-02_JPRB,&
&1.1484E-02_JPRB,9.2095E-03_JPRB,7.5100E-03_JPRB/)
KAO( :, 4, 5,10) = (/&
&1.4380E-02_JPRB,1.4005E-02_JPRB,1.4577E-02_JPRB,1.4581E-02_JPRB,1.4467E-02_JPRB,1.3764E-02_JPRB,&
&1.2436E-02_JPRB,1.0053E-02_JPRB,8.5649E-03_JPRB/)
KAO( :, 5, 5,10) = (/&
&1.4640E-02_JPRB,1.4480E-02_JPRB,1.5153E-02_JPRB,1.5470E-02_JPRB,1.5438E-02_JPRB,1.4721E-02_JPRB,&
&1.3356E-02_JPRB,1.0839E-02_JPRB,9.6988E-03_JPRB/)
KAO( :, 1, 6,10) = (/&
&1.1942E-02_JPRB,1.1353E-02_JPRB,1.1339E-02_JPRB,1.1150E-02_JPRB,1.0468E-02_JPRB,9.5854E-03_JPRB,&
&8.3811E-03_JPRB,7.0885E-03_JPRB,5.8798E-03_JPRB/)
KAO( :, 2, 6,10) = (/&
&1.2358E-02_JPRB,1.1922E-02_JPRB,1.2141E-02_JPRB,1.1920E-02_JPRB,1.1378E-02_JPRB,1.0610E-02_JPRB,&
&9.4501E-03_JPRB,7.7713E-03_JPRB,6.4066E-03_JPRB/)
KAO( :, 3, 6,10) = (/&
&1.2698E-02_JPRB,1.2427E-02_JPRB,1.2838E-02_JPRB,1.2735E-02_JPRB,1.2366E-02_JPRB,1.1633E-02_JPRB,&
&1.0517E-02_JPRB,8.4962E-03_JPRB,6.9615E-03_JPRB/)
KAO( :, 4, 6,10) = (/&
&1.2998E-02_JPRB,1.2956E-02_JPRB,1.3432E-02_JPRB,1.3603E-02_JPRB,1.3351E-02_JPRB,1.2693E-02_JPRB,&
&1.1517E-02_JPRB,9.2932E-03_JPRB,7.5694E-03_JPRB/)
KAO( :, 5, 6,10) = (/&
&1.3245E-02_JPRB,1.3459E-02_JPRB,1.4045E-02_JPRB,1.4501E-02_JPRB,1.4340E-02_JPRB,1.3672E-02_JPRB,&
&1.2434E-02_JPRB,1.0037E-02_JPRB,8.3088E-03_JPRB/)
KAO( :, 1, 7,10) = (/&
&1.0635E-02_JPRB,1.0181E-02_JPRB,1.0247E-02_JPRB,9.9535E-03_JPRB,9.2688E-03_JPRB,8.4744E-03_JPRB,&
&7.6731E-03_JPRB,6.9595E-03_JPRB,5.7767E-03_JPRB/)
KAO( :, 2, 7,10) = (/&
&1.1001E-02_JPRB,1.0731E-02_JPRB,1.1001E-02_JPRB,1.0727E-02_JPRB,1.0196E-02_JPRB,9.4273E-03_JPRB,&
&8.5283E-03_JPRB,7.4633E-03_JPRB,6.2551E-03_JPRB/)
KAO( :, 3, 7,10) = (/&
&1.1326E-02_JPRB,1.1289E-02_JPRB,1.1647E-02_JPRB,1.1559E-02_JPRB,1.1156E-02_JPRB,1.0455E-02_JPRB,&
&9.4847E-03_JPRB,7.9997E-03_JPRB,6.7556E-03_JPRB/)
KAO( :, 4, 7,10) = (/&
&1.1605E-02_JPRB,1.1840E-02_JPRB,1.2266E-02_JPRB,1.2419E-02_JPRB,1.2130E-02_JPRB,1.1514E-02_JPRB,&
&1.0422E-02_JPRB,8.6046E-03_JPRB,7.2812E-03_JPRB/)
KAO( :, 5, 7,10) = (/&
&1.1846E-02_JPRB,1.2301E-02_JPRB,1.2939E-02_JPRB,1.3278E-02_JPRB,1.3141E-02_JPRB,1.2520E-02_JPRB,&
&1.1309E-02_JPRB,9.2291E-03_JPRB,7.8135E-03_JPRB/)
KAO( :, 1, 8,10) = (/&
&9.5318E-03_JPRB,9.1400E-03_JPRB,9.1541E-03_JPRB,8.7469E-03_JPRB,8.1107E-03_JPRB,7.6844E-03_JPRB,&
&7.4790E-03_JPRB,6.8560E-03_JPRB,6.1100E-03_JPRB/)
KAO( :, 2, 8,10) = (/&
&9.8513E-03_JPRB,9.6543E-03_JPRB,9.8221E-03_JPRB,9.4930E-03_JPRB,8.9990E-03_JPRB,8.4087E-03_JPRB,&
&8.1002E-03_JPRB,7.3297E-03_JPRB,6.5036E-03_JPRB/)
KAO( :, 3, 8,10) = (/&
&1.0121E-02_JPRB,1.0183E-02_JPRB,1.0429E-02_JPRB,1.0295E-02_JPRB,9.9219E-03_JPRB,9.3052E-03_JPRB,&
&8.7495E-03_JPRB,7.8409E-03_JPRB,6.8133E-03_JPRB/)
KAO( :, 4, 8,10) = (/&
&1.0342E-02_JPRB,1.0668E-02_JPRB,1.1072E-02_JPRB,1.1128E-02_JPRB,1.0881E-02_JPRB,1.0314E-02_JPRB,&
&9.4319E-03_JPRB,8.3379E-03_JPRB,7.1719E-03_JPRB/)
KAO( :, 5, 8,10) = (/&
&1.0574E-02_JPRB,1.1111E-02_JPRB,1.1730E-02_JPRB,1.1969E-02_JPRB,1.1864E-02_JPRB,1.1283E-02_JPRB,&
&1.0148E-02_JPRB,8.8068E-03_JPRB,7.6246E-03_JPRB/)
KAO( :, 1, 9,10) = (/&
&8.6979E-03_JPRB,8.3079E-03_JPRB,8.1722E-03_JPRB,7.6777E-03_JPRB,7.3529E-03_JPRB,7.3690E-03_JPRB,&
&7.3422E-03_JPRB,6.6830E-03_JPRB,8.5832E-03_JPRB/)
KAO( :, 2, 9,10) = (/&
&8.9724E-03_JPRB,8.7731E-03_JPRB,8.7419E-03_JPRB,8.3348E-03_JPRB,7.9939E-03_JPRB,7.9020E-03_JPRB,&
&7.8887E-03_JPRB,7.1655E-03_JPRB,9.0283E-03_JPRB/)
KAO( :, 3, 9,10) = (/&
&9.1636E-03_JPRB,9.2350E-03_JPRB,9.2903E-03_JPRB,9.0718E-03_JPRB,8.7389E-03_JPRB,8.5612E-03_JPRB,&
&8.4201E-03_JPRB,7.6462E-03_JPRB,9.4969E-03_JPRB/)
KAO( :, 4, 9,10) = (/&
&9.3430E-03_JPRB,9.6411E-03_JPRB,9.8735E-03_JPRB,9.8458E-03_JPRB,9.5925E-03_JPRB,9.3082E-03_JPRB,&
&8.9479E-03_JPRB,8.0999E-03_JPRB,9.9701E-03_JPRB/)
KAO( :, 5, 9,10) = (/&
&9.5543E-03_JPRB,1.0034E-02_JPRB,1.0504E-02_JPRB,1.0652E-02_JPRB,1.0546E-02_JPRB,1.0105E-02_JPRB,&
&9.4548E-03_JPRB,8.5503E-03_JPRB,1.0439E-02_JPRB/)
KAO( :, 1,10,10) = (/&
&8.1157E-03_JPRB,7.6953E-03_JPRB,7.3856E-03_JPRB,7.0143E-03_JPRB,7.0934E-03_JPRB,7.1592E-03_JPRB,&
&7.1366E-03_JPRB,6.4736E-03_JPRB,2.5288E-02_JPRB/)
KAO( :, 2,10,10) = (/&
&8.3228E-03_JPRB,8.1050E-03_JPRB,7.8899E-03_JPRB,7.5150E-03_JPRB,7.5383E-03_JPRB,7.6577E-03_JPRB,&
&7.6569E-03_JPRB,6.9536E-03_JPRB,2.5969E-02_JPRB/)
KAO( :, 3,10,10) = (/&
&8.4638E-03_JPRB,8.4927E-03_JPRB,8.3732E-03_JPRB,8.1065E-03_JPRB,8.0674E-03_JPRB,8.2304E-03_JPRB,&
&8.1217E-03_JPRB,7.4527E-03_JPRB,2.6813E-02_JPRB/)
KAO( :, 4,10,10) = (/&
&8.6251E-03_JPRB,8.8393E-03_JPRB,8.8777E-03_JPRB,8.7542E-03_JPRB,8.7078E-03_JPRB,8.8286E-03_JPRB,&
&8.6165E-03_JPRB,7.9058E-03_JPRB,2.7708E-02_JPRB/)
KAO( :, 5,10,10) = (/&
&8.7883E-03_JPRB,9.2004E-03_JPRB,9.4445E-03_JPRB,9.4717E-03_JPRB,9.4479E-03_JPRB,9.4125E-03_JPRB,&
&9.0956E-03_JPRB,8.3203E-03_JPRB,2.8653E-02_JPRB/)
KAO( :, 1,11,10) = (/&
&7.8501E-03_JPRB,7.4452E-03_JPRB,7.0342E-03_JPRB,6.9004E-03_JPRB,7.0570E-03_JPRB,7.1201E-03_JPRB,&
&7.0476E-03_JPRB,6.4243E-03_JPRB,4.0572E-02_JPRB/)
KAO( :, 2,11,10) = (/&
&7.9753E-03_JPRB,7.7749E-03_JPRB,7.4240E-03_JPRB,7.3009E-03_JPRB,7.4854E-03_JPRB,7.6408E-03_JPRB,&
&7.5205E-03_JPRB,6.9049E-03_JPRB,4.1441E-02_JPRB/)
KAO( :, 3,11,10) = (/&
&8.0806E-03_JPRB,8.0563E-03_JPRB,7.8316E-03_JPRB,7.7518E-03_JPRB,7.9930E-03_JPRB,8.1574E-03_JPRB,&
&7.9957E-03_JPRB,7.3976E-03_JPRB,4.2222E-02_JPRB/)
KAO( :, 4,11,10) = (/&
&8.1992E-03_JPRB,8.3401E-03_JPRB,8.2986E-03_JPRB,8.2629E-03_JPRB,8.5167E-03_JPRB,8.6635E-03_JPRB,&
&8.4735E-03_JPRB,7.8541E-03_JPRB,4.3187E-02_JPRB/)
KAO( :, 5,11,10) = (/&
&8.2878E-03_JPRB,8.6780E-03_JPRB,8.8506E-03_JPRB,8.8633E-03_JPRB,9.0484E-03_JPRB,9.1413E-03_JPRB,&
&8.9084E-03_JPRB,8.2746E-03_JPRB,4.4361E-02_JPRB/)
KAO( :, 1,12,10) = (/&
&7.6139E-03_JPRB,7.2726E-03_JPRB,6.8850E-03_JPRB,6.9089E-03_JPRB,6.9663E-03_JPRB,7.0443E-03_JPRB,&
&6.8750E-03_JPRB,6.2469E-03_JPRB,4.8797E-02_JPRB/)
KAO( :, 2,12,10) = (/&
&7.7194E-03_JPRB,7.5180E-03_JPRB,7.1615E-03_JPRB,7.2509E-03_JPRB,7.4345E-03_JPRB,7.5251E-03_JPRB,&
&7.3302E-03_JPRB,6.7269E-03_JPRB,4.9597E-02_JPRB/)
KAO( :, 3,12,10) = (/&
&7.8184E-03_JPRB,7.7399E-03_JPRB,7.4810E-03_JPRB,7.6258E-03_JPRB,7.9008E-03_JPRB,7.9967E-03_JPRB,&
&7.8018E-03_JPRB,7.1947E-03_JPRB,5.0339E-02_JPRB/)
KAO( :, 4,12,10) = (/&
&7.8914E-03_JPRB,7.9922E-03_JPRB,7.8923E-03_JPRB,8.0511E-03_JPRB,8.3449E-03_JPRB,8.4240E-03_JPRB,&
&8.2687E-03_JPRB,7.6521E-03_JPRB,5.1350E-02_JPRB/)
KAO( :, 5,12,10) = (/&
&7.9507E-03_JPRB,8.2886E-03_JPRB,8.3628E-03_JPRB,8.5321E-03_JPRB,8.7647E-03_JPRB,8.8141E-03_JPRB,&
&8.7116E-03_JPRB,8.0986E-03_JPRB,5.2764E-02_JPRB/)
KAO( :, 1,13,10) = (/&
&7.3158E-03_JPRB,7.0328E-03_JPRB,6.8235E-03_JPRB,6.9230E-03_JPRB,6.9064E-03_JPRB,6.8869E-03_JPRB,&
&6.6102E-03_JPRB,5.9534E-03_JPRB,4.6027E-02_JPRB/)
KAO( :, 2,13,10) = (/&
&7.4278E-03_JPRB,7.2607E-03_JPRB,7.0591E-03_JPRB,7.2420E-03_JPRB,7.3482E-03_JPRB,7.3254E-03_JPRB,&
&7.0547E-03_JPRB,6.4187E-03_JPRB,4.6671E-02_JPRB/)
KAO( :, 3,13,10) = (/&
&7.5295E-03_JPRB,7.4924E-03_JPRB,7.3494E-03_JPRB,7.5754E-03_JPRB,7.7630E-03_JPRB,7.7638E-03_JPRB,&
&7.4975E-03_JPRB,6.8755E-03_JPRB,4.7440E-02_JPRB/)
KAO( :, 4,13,10) = (/&
&7.6080E-03_JPRB,7.7470E-03_JPRB,7.6819E-03_JPRB,7.9565E-03_JPRB,8.1173E-03_JPRB,8.1428E-03_JPRB,&
&7.9589E-03_JPRB,7.3493E-03_JPRB,4.8497E-02_JPRB/)
KAO( :, 5,13,10) = (/&
&7.6817E-03_JPRB,8.0217E-03_JPRB,8.0425E-03_JPRB,8.3061E-03_JPRB,8.4701E-03_JPRB,8.5085E-03_JPRB,&
&8.3860E-03_JPRB,7.8301E-03_JPRB,4.9971E-02_JPRB/)
KAO( :, 1, 1,11) = (/&
&2.7764E-02_JPRB,2.4426E-02_JPRB,2.1973E-02_JPRB,2.0093E-02_JPRB,1.8666E-02_JPRB,1.7278E-02_JPRB,&
&1.5087E-02_JPRB,1.3103E-02_JPRB,1.4300E-02_JPRB/)
KAO( :, 2, 1,11) = (/&
&2.7963E-02_JPRB,2.4667E-02_JPRB,2.2450E-02_JPRB,2.0789E-02_JPRB,1.9549E-02_JPRB,1.8247E-02_JPRB,&
&1.6059E-02_JPRB,1.4781E-02_JPRB,1.6422E-02_JPRB/)
KAO( :, 3, 1,11) = (/&
&2.8032E-02_JPRB,2.4854E-02_JPRB,2.2829E-02_JPRB,2.1504E-02_JPRB,2.0423E-02_JPRB,1.9213E-02_JPRB,&
&1.7147E-02_JPRB,1.6580E-02_JPRB,1.8603E-02_JPRB/)
KAO( :, 4, 1,11) = (/&
&2.7908E-02_JPRB,2.4878E-02_JPRB,2.3088E-02_JPRB,2.2255E-02_JPRB,2.1236E-02_JPRB,2.0204E-02_JPRB,&
&1.8256E-02_JPRB,1.8454E-02_JPRB,2.0859E-02_JPRB/)
KAO( :, 5, 1,11) = (/&
&2.7693E-02_JPRB,2.4833E-02_JPRB,2.3283E-02_JPRB,2.2953E-02_JPRB,2.2107E-02_JPRB,2.1010E-02_JPRB,&
&1.9343E-02_JPRB,2.0385E-02_JPRB,2.3144E-02_JPRB/)
KAO( :, 1, 2,11) = (/&
&2.7646E-02_JPRB,2.4332E-02_JPRB,2.2092E-02_JPRB,2.0298E-02_JPRB,1.9042E-02_JPRB,1.7440E-02_JPRB,&
&1.5349E-02_JPRB,1.2664E-02_JPRB,1.3386E-02_JPRB/)
KAO( :, 2, 2,11) = (/&
&2.7909E-02_JPRB,2.4672E-02_JPRB,2.2646E-02_JPRB,2.1214E-02_JPRB,2.0006E-02_JPRB,1.8412E-02_JPRB,&
&1.6391E-02_JPRB,1.4178E-02_JPRB,1.5546E-02_JPRB/)
KAO( :, 3, 2,11) = (/&
&2.7965E-02_JPRB,2.4859E-02_JPRB,2.3085E-02_JPRB,2.2119E-02_JPRB,2.0910E-02_JPRB,1.9436E-02_JPRB,&
&1.7350E-02_JPRB,1.5867E-02_JPRB,1.7743E-02_JPRB/)
KAO( :, 4, 2,11) = (/&
&2.7851E-02_JPRB,2.4932E-02_JPRB,2.3473E-02_JPRB,2.2951E-02_JPRB,2.1773E-02_JPRB,2.0509E-02_JPRB,&
&1.8306E-02_JPRB,1.7658E-02_JPRB,1.9938E-02_JPRB/)
KAO( :, 5, 2,11) = (/&
&2.7716E-02_JPRB,2.4986E-02_JPRB,2.3872E-02_JPRB,2.3624E-02_JPRB,2.2685E-02_JPRB,2.1385E-02_JPRB,&
&1.9339E-02_JPRB,1.9475E-02_JPRB,2.2096E-02_JPRB/)
KAO( :, 1, 3,11) = (/&
&2.7136E-02_JPRB,2.3913E-02_JPRB,2.1898E-02_JPRB,2.0239E-02_JPRB,1.8943E-02_JPRB,1.7255E-02_JPRB,&
&1.5286E-02_JPRB,1.1962E-02_JPRB,1.1731E-02_JPRB/)
KAO( :, 2, 3,11) = (/&
&2.7384E-02_JPRB,2.4261E-02_JPRB,2.2497E-02_JPRB,2.1296E-02_JPRB,2.0064E-02_JPRB,1.8265E-02_JPRB,&
&1.6402E-02_JPRB,1.3201E-02_JPRB,1.3756E-02_JPRB/)
KAO( :, 3, 3,11) = (/&
&2.7424E-02_JPRB,2.4494E-02_JPRB,2.3027E-02_JPRB,2.2286E-02_JPRB,2.1084E-02_JPRB,1.9295E-02_JPRB,&
&1.7402E-02_JPRB,1.4625E-02_JPRB,1.5844E-02_JPRB/)
KAO( :, 4, 3,11) = (/&
&2.7396E-02_JPRB,2.4666E-02_JPRB,2.3610E-02_JPRB,2.3218E-02_JPRB,2.1991E-02_JPRB,2.0436E-02_JPRB,&
&1.8232E-02_JPRB,1.6186E-02_JPRB,1.7976E-02_JPRB/)
KAO( :, 5, 3,11) = (/&
&2.7396E-02_JPRB,2.4863E-02_JPRB,2.4263E-02_JPRB,2.4003E-02_JPRB,2.2894E-02_JPRB,2.1428E-02_JPRB,&
&1.9099E-02_JPRB,1.7923E-02_JPRB,2.0191E-02_JPRB/)
KAO( :, 1, 4,11) = (/&
&2.6120E-02_JPRB,2.3055E-02_JPRB,2.1334E-02_JPRB,1.9874E-02_JPRB,1.8554E-02_JPRB,1.6913E-02_JPRB,&
&1.4849E-02_JPRB,1.1247E-02_JPRB,9.9817E-03_JPRB/)
KAO( :, 2, 4,11) = (/&
&2.6346E-02_JPRB,2.3452E-02_JPRB,2.1987E-02_JPRB,2.1036E-02_JPRB,1.9768E-02_JPRB,1.8034E-02_JPRB,&
&1.5969E-02_JPRB,1.2323E-02_JPRB,1.1891E-02_JPRB/)
KAO( :, 3, 4,11) = (/&
&2.6444E-02_JPRB,2.3743E-02_JPRB,2.2663E-02_JPRB,2.2134E-02_JPRB,2.0858E-02_JPRB,1.9164E-02_JPRB,&
&1.7004E-02_JPRB,1.3536E-02_JPRB,1.3883E-02_JPRB/)
KAO( :, 4, 4,11) = (/&
&2.6615E-02_JPRB,2.4091E-02_JPRB,2.3417E-02_JPRB,2.3175E-02_JPRB,2.1815E-02_JPRB,2.0352E-02_JPRB,&
&1.7938E-02_JPRB,1.4897E-02_JPRB,1.5955E-02_JPRB/)
KAO( :, 5, 4,11) = (/&
&2.6757E-02_JPRB,2.4467E-02_JPRB,2.4289E-02_JPRB,2.4064E-02_JPRB,2.2838E-02_JPRB,2.1378E-02_JPRB,&
&1.8780E-02_JPRB,1.6458E-02_JPRB,1.8170E-02_JPRB/)
KAO( :, 1, 5,11) = (/&
&2.4649E-02_JPRB,2.1845E-02_JPRB,2.0397E-02_JPRB,1.9200E-02_JPRB,1.7986E-02_JPRB,1.6354E-02_JPRB,&
&1.4106E-02_JPRB,1.0659E-02_JPRB,8.5296E-03_JPRB/)
KAO( :, 2, 5,11) = (/&
&2.4915E-02_JPRB,2.2302E-02_JPRB,2.1150E-02_JPRB,2.0451E-02_JPRB,1.9259E-02_JPRB,1.7581E-02_JPRB,&
&1.5270E-02_JPRB,1.1646E-02_JPRB,1.0194E-02_JPRB/)
KAO( :, 3, 5,11) = (/&
&2.5218E-02_JPRB,2.2788E-02_JPRB,2.1977E-02_JPRB,2.1628E-02_JPRB,2.0422E-02_JPRB,1.8826E-02_JPRB,&
&1.6327E-02_JPRB,1.2719E-02_JPRB,1.2019E-02_JPRB/)
KAO( :, 4, 5,11) = (/&
&2.5482E-02_JPRB,2.3305E-02_JPRB,2.2941E-02_JPRB,2.2718E-02_JPRB,2.1512E-02_JPRB,2.0034E-02_JPRB,&
&1.7375E-02_JPRB,1.3885E-02_JPRB,1.4041E-02_JPRB/)
KAO( :, 5, 5,11) = (/&
&2.5726E-02_JPRB,2.3793E-02_JPRB,2.3951E-02_JPRB,2.3636E-02_JPRB,2.2618E-02_JPRB,2.1077E-02_JPRB,&
&1.8363E-02_JPRB,1.5350E-02_JPRB,1.6202E-02_JPRB/)
KAO( :, 1, 6,11) = (/&
&2.2851E-02_JPRB,2.0373E-02_JPRB,1.9153E-02_JPRB,1.8191E-02_JPRB,1.7169E-02_JPRB,1.5447E-02_JPRB,&
&1.3127E-02_JPRB,9.9268E-03_JPRB,7.8128E-03_JPRB/)
KAO( :, 2, 6,11) = (/&
&2.3274E-02_JPRB,2.0974E-02_JPRB,2.0039E-02_JPRB,1.9515E-02_JPRB,1.8501E-02_JPRB,1.6740E-02_JPRB,&
&1.4344E-02_JPRB,1.0951E-02_JPRB,8.8752E-03_JPRB/)
KAO( :, 3, 6,11) = (/&
&2.3672E-02_JPRB,2.1617E-02_JPRB,2.1050E-02_JPRB,2.0731E-02_JPRB,1.9672E-02_JPRB,1.8067E-02_JPRB,&
&1.5465E-02_JPRB,1.2013E-02_JPRB,1.0301E-02_JPRB/)
KAO( :, 4, 6,11) = (/&
&2.4031E-02_JPRB,2.2215E-02_JPRB,2.2188E-02_JPRB,2.1796E-02_JPRB,2.0865E-02_JPRB,1.9256E-02_JPRB,&
&1.6602E-02_JPRB,1.3087E-02_JPRB,1.2045E-02_JPRB/)
KAO( :, 5, 6,11) = (/&
&2.4424E-02_JPRB,2.2835E-02_JPRB,2.3262E-02_JPRB,2.2762E-02_JPRB,2.2024E-02_JPRB,2.0317E-02_JPRB,&
&1.7726E-02_JPRB,1.4330E-02_JPRB,1.3970E-02_JPRB/)
KAO( :, 1, 7,11) = (/&
&2.0897E-02_JPRB,1.8755E-02_JPRB,1.7733E-02_JPRB,1.7022E-02_JPRB,1.6054E-02_JPRB,1.4311E-02_JPRB,&
&1.2008E-02_JPRB,9.2731E-03_JPRB,7.7437E-03_JPRB/)
KAO( :, 2, 7,11) = (/&
&2.1410E-02_JPRB,1.9491E-02_JPRB,1.8752E-02_JPRB,1.8362E-02_JPRB,1.7373E-02_JPRB,1.5636E-02_JPRB,&
&1.3285E-02_JPRB,1.0177E-02_JPRB,8.5051E-03_JPRB/)
KAO( :, 3, 7,11) = (/&
&2.1887E-02_JPRB,2.0202E-02_JPRB,1.9920E-02_JPRB,1.9593E-02_JPRB,1.8568E-02_JPRB,1.6958E-02_JPRB,&
&1.4466E-02_JPRB,1.1212E-02_JPRB,9.3670E-03_JPRB/)
KAO( :, 4, 7,11) = (/&
&2.2392E-02_JPRB,2.0930E-02_JPRB,2.1140E-02_JPRB,2.0643E-02_JPRB,1.9778E-02_JPRB,1.8147E-02_JPRB,&
&1.5692E-02_JPRB,1.2278E-02_JPRB,1.0489E-02_JPRB/)
KAO( :, 5, 7,11) = (/&
&2.2888E-02_JPRB,2.1742E-02_JPRB,2.2178E-02_JPRB,2.1714E-02_JPRB,2.0936E-02_JPRB,1.9278E-02_JPRB,&
&1.6882E-02_JPRB,1.3452E-02_JPRB,1.1897E-02_JPRB/)
KAO( :, 1, 8,11) = (/&
&1.8841E-02_JPRB,1.7056E-02_JPRB,1.6222E-02_JPRB,1.5693E-02_JPRB,1.4689E-02_JPRB,1.2994E-02_JPRB,&
&1.0918E-02_JPRB,9.1547E-03_JPRB,7.9124E-03_JPRB/)
KAO( :, 2, 8,11) = (/&
&1.9409E-02_JPRB,1.7855E-02_JPRB,1.7363E-02_JPRB,1.7024E-02_JPRB,1.5955E-02_JPRB,1.4305E-02_JPRB,&
&1.2087E-02_JPRB,9.7905E-03_JPRB,8.4826E-03_JPRB/)
KAO( :, 3, 8,11) = (/&
&1.9993E-02_JPRB,1.8663E-02_JPRB,1.8622E-02_JPRB,1.8244E-02_JPRB,1.7158E-02_JPRB,1.5610E-02_JPRB,&
&1.3302E-02_JPRB,1.0551E-02_JPRB,9.2336E-03_JPRB/)
KAO( :, 4, 8,11) = (/&
&2.0602E-02_JPRB,1.9539E-02_JPRB,1.9827E-02_JPRB,1.9347E-02_JPRB,1.8357E-02_JPRB,1.6779E-02_JPRB,&
&1.4567E-02_JPRB,1.1467E-02_JPRB,9.9909E-03_JPRB/)
KAO( :, 5, 8,11) = (/&
&2.1064E-02_JPRB,2.0402E-02_JPRB,2.0838E-02_JPRB,2.0466E-02_JPRB,1.9507E-02_JPRB,1.7959E-02_JPRB,&
&1.5824E-02_JPRB,1.2520E-02_JPRB,1.0807E-02_JPRB/)
KAO( :, 1, 9,11) = (/&
&1.6824E-02_JPRB,1.5334E-02_JPRB,1.4694E-02_JPRB,1.4181E-02_JPRB,1.3143E-02_JPRB,1.1680E-02_JPRB,&
&1.0334E-02_JPRB,9.1831E-03_JPRB,1.1053E-02_JPRB/)
KAO( :, 2, 9,11) = (/&
&1.7417E-02_JPRB,1.6144E-02_JPRB,1.5897E-02_JPRB,1.5487E-02_JPRB,1.4380E-02_JPRB,1.2867E-02_JPRB,&
&1.1184E-02_JPRB,9.7551E-03_JPRB,1.1728E-02_JPRB/)
KAO( :, 3, 9,11) = (/&
&1.8068E-02_JPRB,1.7042E-02_JPRB,1.7161E-02_JPRB,1.6678E-02_JPRB,1.5557E-02_JPRB,1.4093E-02_JPRB,&
&1.2184E-02_JPRB,1.0404E-02_JPRB,1.2483E-02_JPRB/)
KAO( :, 4, 9,11) = (/&
&1.8632E-02_JPRB,1.7983E-02_JPRB,1.8323E-02_JPRB,1.7788E-02_JPRB,1.6784E-02_JPRB,1.5260E-02_JPRB,&
&1.3324E-02_JPRB,1.1123E-02_JPRB,1.3280E-02_JPRB/)
KAO( :, 5, 9,11) = (/&
&1.9073E-02_JPRB,1.8843E-02_JPRB,1.9281E-02_JPRB,1.8905E-02_JPRB,1.7900E-02_JPRB,1.6447E-02_JPRB,&
&1.4515E-02_JPRB,1.1877E-02_JPRB,1.4077E-02_JPRB/)
KAO( :, 1,10,11) = (/&
&1.5121E-02_JPRB,1.3838E-02_JPRB,1.3365E-02_JPRB,1.2721E-02_JPRB,1.1737E-02_JPRB,1.0953E-02_JPRB,&
&1.0213E-02_JPRB,9.1916E-03_JPRB,3.5198E-02_JPRB/)
KAO( :, 2,10,11) = (/&
&1.5710E-02_JPRB,1.4640E-02_JPRB,1.4492E-02_JPRB,1.3911E-02_JPRB,1.2838E-02_JPRB,1.1818E-02_JPRB,&
&1.0924E-02_JPRB,9.7376E-03_JPRB,3.6361E-02_JPRB/)
KAO( :, 3,10,11) = (/&
&1.6286E-02_JPRB,1.5525E-02_JPRB,1.5683E-02_JPRB,1.5045E-02_JPRB,1.3992E-02_JPRB,1.2769E-02_JPRB,&
&1.1723E-02_JPRB,1.0342E-02_JPRB,3.7359E-02_JPRB/)
KAO( :, 4,10,11) = (/&
&1.6782E-02_JPRB,1.6440E-02_JPRB,1.6745E-02_JPRB,1.6156E-02_JPRB,1.5181E-02_JPRB,1.3811E-02_JPRB,&
&1.2551E-02_JPRB,1.1044E-02_JPRB,3.8551E-02_JPRB/)
KAO( :, 5,10,11) = (/&
&1.7221E-02_JPRB,1.7284E-02_JPRB,1.7650E-02_JPRB,1.7276E-02_JPRB,1.6297E-02_JPRB,1.4958E-02_JPRB,&
&1.3449E-02_JPRB,1.1753E-02_JPRB,3.9714E-02_JPRB/)
KAO( :, 1,11,11) = (/&
&1.4019E-02_JPRB,1.2957E-02_JPRB,1.2611E-02_JPRB,1.1869E-02_JPRB,1.1221E-02_JPRB,1.0951E-02_JPRB,&
&1.0419E-02_JPRB,9.2574E-03_JPRB,5.9295E-02_JPRB/)
KAO( :, 2,11,11) = (/&
&1.4514E-02_JPRB,1.3729E-02_JPRB,1.3655E-02_JPRB,1.2913E-02_JPRB,1.2091E-02_JPRB,1.1604E-02_JPRB,&
&1.1118E-02_JPRB,9.8828E-03_JPRB,6.0862E-02_JPRB/)
KAO( :, 3,11,11) = (/&
&1.4986E-02_JPRB,1.4596E-02_JPRB,1.4648E-02_JPRB,1.3931E-02_JPRB,1.3062E-02_JPRB,1.2353E-02_JPRB,&
&1.1821E-02_JPRB,1.0518E-02_JPRB,6.2214E-02_JPRB/)
KAO( :, 4,11,11) = (/&
&1.5398E-02_JPRB,1.5423E-02_JPRB,1.5511E-02_JPRB,1.4991E-02_JPRB,1.4093E-02_JPRB,1.3225E-02_JPRB,&
&1.2498E-02_JPRB,1.1195E-02_JPRB,6.3269E-02_JPRB/)
KAO( :, 5,11,11) = (/&
&1.5718E-02_JPRB,1.6102E-02_JPRB,1.6332E-02_JPRB,1.5968E-02_JPRB,1.5171E-02_JPRB,1.4160E-02_JPRB,&
&1.3209E-02_JPRB,1.1891E-02_JPRB,6.4542E-02_JPRB/)
KAO( :, 1,12,11) = (/&
&1.3164E-02_JPRB,1.2292E-02_JPRB,1.1927E-02_JPRB,1.1265E-02_JPRB,1.1057E-02_JPRB,1.0913E-02_JPRB,&
&1.0445E-02_JPRB,9.2736E-03_JPRB,7.4756E-02_JPRB/)
KAO( :, 2,12,11) = (/&
&1.3602E-02_JPRB,1.3075E-02_JPRB,1.2792E-02_JPRB,1.2052E-02_JPRB,1.1692E-02_JPRB,1.1536E-02_JPRB,&
&1.1126E-02_JPRB,9.9170E-03_JPRB,7.6306E-02_JPRB/)
KAO( :, 3,12,11) = (/&
&1.3977E-02_JPRB,1.3830E-02_JPRB,1.3590E-02_JPRB,1.2927E-02_JPRB,1.2424E-02_JPRB,1.2227E-02_JPRB,&
&1.1745E-02_JPRB,1.0613E-02_JPRB,7.7655E-02_JPRB/)
KAO( :, 4,12,11) = (/&
&1.4251E-02_JPRB,1.4432E-02_JPRB,1.4329E-02_JPRB,1.3821E-02_JPRB,1.3256E-02_JPRB,1.2933E-02_JPRB,&
&1.2386E-02_JPRB,1.1303E-02_JPRB,7.8663E-02_JPRB/)
KAO( :, 5,12,11) = (/&
&1.4497E-02_JPRB,1.4939E-02_JPRB,1.5040E-02_JPRB,1.4676E-02_JPRB,1.4122E-02_JPRB,1.3675E-02_JPRB,&
&1.3045E-02_JPRB,1.1981E-02_JPRB,7.9879E-02_JPRB/)
KAO( :, 1,13,11) = (/&
&1.2616E-02_JPRB,1.1893E-02_JPRB,1.1313E-02_JPRB,1.0907E-02_JPRB,1.0966E-02_JPRB,1.0790E-02_JPRB,&
&1.0280E-02_JPRB,9.1949E-03_JPRB,7.3725E-02_JPRB/)
KAO( :, 2,13,11) = (/&
&1.2957E-02_JPRB,1.2555E-02_JPRB,1.2016E-02_JPRB,1.1533E-02_JPRB,1.1499E-02_JPRB,1.1400E-02_JPRB,&
&1.0924E-02_JPRB,9.8797E-03_JPRB,7.4996E-02_JPRB/)
KAO( :, 3,13,11) = (/&
&1.3172E-02_JPRB,1.3071E-02_JPRB,1.2663E-02_JPRB,1.2207E-02_JPRB,1.2117E-02_JPRB,1.2009E-02_JPRB,&
&1.1575E-02_JPRB,1.0610E-02_JPRB,7.6038E-02_JPRB/)
KAO( :, 4,13,11) = (/&
&1.3348E-02_JPRB,1.3517E-02_JPRB,1.3285E-02_JPRB,1.2851E-02_JPRB,1.2762E-02_JPRB,1.2671E-02_JPRB,&
&1.2190E-02_JPRB,1.1315E-02_JPRB,7.7063E-02_JPRB/)
KAO( :, 5,13,11) = (/&
&1.3524E-02_JPRB,1.3946E-02_JPRB,1.3887E-02_JPRB,1.3540E-02_JPRB,1.3388E-02_JPRB,1.3305E-02_JPRB,&
&1.2841E-02_JPRB,1.2009E-02_JPRB,7.8468E-02_JPRB/)
KAO( :, 1, 1,12) = (/&
&3.9522E-02_JPRB,3.4695E-02_JPRB,3.0393E-02_JPRB,2.7444E-02_JPRB,2.4701E-02_JPRB,2.2430E-02_JPRB,&
&1.9690E-02_JPRB,1.9007E-02_JPRB,2.1357E-02_JPRB/)
KAO( :, 2, 1,12) = (/&
&3.9055E-02_JPRB,3.4293E-02_JPRB,3.0365E-02_JPRB,2.7692E-02_JPRB,2.5619E-02_JPRB,2.3505E-02_JPRB,&
&2.1002E-02_JPRB,2.1723E-02_JPRB,2.4548E-02_JPRB/)
KAO( :, 3, 1,12) = (/&
&3.8771E-02_JPRB,3.4045E-02_JPRB,3.0558E-02_JPRB,2.8122E-02_JPRB,2.6598E-02_JPRB,2.4455E-02_JPRB,&
&2.2524E-02_JPRB,2.4725E-02_JPRB,2.7978E-02_JPRB/)
KAO( :, 4, 1,12) = (/&
&3.8655E-02_JPRB,3.3972E-02_JPRB,3.0813E-02_JPRB,2.8575E-02_JPRB,2.7403E-02_JPRB,2.5405E-02_JPRB,&
&2.4525E-02_JPRB,2.7903E-02_JPRB,3.1582E-02_JPRB/)
KAO( :, 5, 1,12) = (/&
&3.8581E-02_JPRB,3.4020E-02_JPRB,3.1105E-02_JPRB,2.9186E-02_JPRB,2.7932E-02_JPRB,2.6686E-02_JPRB,&
&2.7056E-02_JPRB,3.1213E-02_JPRB,3.5341E-02_JPRB/)
KAO( :, 1, 2,12) = (/&
&4.0900E-02_JPRB,3.5882E-02_JPRB,3.1540E-02_JPRB,2.8648E-02_JPRB,2.5916E-02_JPRB,2.3479E-02_JPRB,&
&1.9842E-02_JPRB,1.8172E-02_JPRB,2.0462E-02_JPRB/)
KAO( :, 2, 2,12) = (/&
&4.0629E-02_JPRB,3.5647E-02_JPRB,3.1749E-02_JPRB,2.9079E-02_JPRB,2.7038E-02_JPRB,2.4448E-02_JPRB,&
&2.0997E-02_JPRB,2.0801E-02_JPRB,2.3586E-02_JPRB/)
KAO( :, 3, 2,12) = (/&
&4.0634E-02_JPRB,3.5666E-02_JPRB,3.2165E-02_JPRB,2.9630E-02_JPRB,2.8090E-02_JPRB,2.5205E-02_JPRB,&
&2.2483E-02_JPRB,2.3756E-02_JPRB,2.6981E-02_JPRB/)
KAO( :, 4, 2,12) = (/&
&4.0680E-02_JPRB,3.5804E-02_JPRB,3.2512E-02_JPRB,3.0271E-02_JPRB,2.8844E-02_JPRB,2.6048E-02_JPRB,&
&2.4362E-02_JPRB,2.6965E-02_JPRB,3.0664E-02_JPRB/)
KAO( :, 5, 2,12) = (/&
&4.0551E-02_JPRB,3.5850E-02_JPRB,3.2760E-02_JPRB,3.1085E-02_JPRB,2.9377E-02_JPRB,2.7302E-02_JPRB,&
&2.6614E-02_JPRB,3.0323E-02_JPRB,3.4512E-02_JPRB/)
KAO( :, 1, 3,12) = (/&
&4.2297E-02_JPRB,3.7083E-02_JPRB,3.2675E-02_JPRB,2.9696E-02_JPRB,2.6819E-02_JPRB,2.4251E-02_JPRB,&
&1.9800E-02_JPRB,1.7013E-02_JPRB,1.8998E-02_JPRB/)
KAO( :, 2, 3,12) = (/&
&4.2345E-02_JPRB,3.7129E-02_JPRB,3.3126E-02_JPRB,3.0221E-02_JPRB,2.7989E-02_JPRB,2.5268E-02_JPRB,&
&2.0870E-02_JPRB,1.9534E-02_JPRB,2.2175E-02_JPRB/)
KAO( :, 3, 3,12) = (/&
&4.2503E-02_JPRB,3.7329E-02_JPRB,3.3705E-02_JPRB,3.0884E-02_JPRB,2.9095E-02_JPRB,2.6012E-02_JPRB,&
&2.2274E-02_JPRB,2.2409E-02_JPRB,2.5549E-02_JPRB/)
KAO( :, 4, 3,12) = (/&
&4.2563E-02_JPRB,3.7513E-02_JPRB,3.4118E-02_JPRB,3.1719E-02_JPRB,2.9991E-02_JPRB,2.6648E-02_JPRB,&
&2.4107E-02_JPRB,2.5501E-02_JPRB,2.9091E-02_JPRB/)
KAO( :, 5, 3,12) = (/&
&4.2352E-02_JPRB,3.7494E-02_JPRB,3.4375E-02_JPRB,3.2625E-02_JPRB,3.0646E-02_JPRB,2.7653E-02_JPRB,&
&2.6034E-02_JPRB,2.8674E-02_JPRB,3.2704E-02_JPRB/)
KAO( :, 1, 4,12) = (/&
&4.3449E-02_JPRB,3.8071E-02_JPRB,3.3569E-02_JPRB,3.0433E-02_JPRB,2.7408E-02_JPRB,2.4611E-02_JPRB,&
&2.0108E-02_JPRB,1.5832E-02_JPRB,1.6869E-02_JPRB/)
KAO( :, 2, 4,12) = (/&
&4.3754E-02_JPRB,3.8357E-02_JPRB,3.4350E-02_JPRB,3.1115E-02_JPRB,2.8679E-02_JPRB,2.5625E-02_JPRB,&
&2.1066E-02_JPRB,1.8077E-02_JPRB,2.0082E-02_JPRB/)
KAO( :, 3, 4,12) = (/&
&4.3973E-02_JPRB,3.8656E-02_JPRB,3.5023E-02_JPRB,3.2006E-02_JPRB,2.9792E-02_JPRB,2.6458E-02_JPRB,&
&2.2328E-02_JPRB,2.0812E-02_JPRB,2.3540E-02_JPRB/)
KAO( :, 4, 4,12) = (/&
&4.3938E-02_JPRB,3.8773E-02_JPRB,3.5454E-02_JPRB,3.2980E-02_JPRB,3.0747E-02_JPRB,2.7193E-02_JPRB,&
&2.3978E-02_JPRB,2.3783E-02_JPRB,2.7070E-02_JPRB/)
KAO( :, 5, 4,12) = (/&
&4.3814E-02_JPRB,3.8836E-02_JPRB,3.5796E-02_JPRB,3.3909E-02_JPRB,3.1572E-02_JPRB,2.8214E-02_JPRB,&
&2.5779E-02_JPRB,2.6823E-02_JPRB,3.0560E-02_JPRB/)
KAO( :, 1, 5,12) = (/&
&4.3987E-02_JPRB,3.8530E-02_JPRB,3.4139E-02_JPRB,3.0809E-02_JPRB,2.7641E-02_JPRB,2.4664E-02_JPRB,&
&2.0281E-02_JPRB,1.4828E-02_JPRB,1.4596E-02_JPRB/)
KAO( :, 2, 5,12) = (/&
&4.4423E-02_JPRB,3.8965E-02_JPRB,3.5098E-02_JPRB,3.1717E-02_JPRB,2.9032E-02_JPRB,2.5717E-02_JPRB,&
&2.1306E-02_JPRB,1.6792E-02_JPRB,1.7692E-02_JPRB/)
KAO( :, 3, 5,12) = (/&
&4.4740E-02_JPRB,3.9368E-02_JPRB,3.5854E-02_JPRB,3.2800E-02_JPRB,3.0202E-02_JPRB,2.6633E-02_JPRB,&
&2.2521E-02_JPRB,1.9130E-02_JPRB,2.0967E-02_JPRB/)
KAO( :, 4, 5,12) = (/&
&4.4784E-02_JPRB,3.9578E-02_JPRB,3.6349E-02_JPRB,3.3852E-02_JPRB,3.1212E-02_JPRB,2.7594E-02_JPRB,&
&2.3985E-02_JPRB,2.1768E-02_JPRB,2.4335E-02_JPRB/)
KAO( :, 5, 5,12) = (/&
&4.4634E-02_JPRB,3.9684E-02_JPRB,3.6716E-02_JPRB,3.4783E-02_JPRB,3.2166E-02_JPRB,2.8840E-02_JPRB,&
&2.5566E-02_JPRB,2.4589E-02_JPRB,2.7780E-02_JPRB/)
KAO( :, 1, 6,12) = (/&
&4.3652E-02_JPRB,3.8230E-02_JPRB,3.4067E-02_JPRB,3.0633E-02_JPRB,2.7394E-02_JPRB,2.4357E-02_JPRB,&
&2.0018E-02_JPRB,1.4129E-02_JPRB,1.2309E-02_JPRB/)
KAO( :, 2, 6,12) = (/&
&4.4319E-02_JPRB,3.8893E-02_JPRB,3.5172E-02_JPRB,3.1745E-02_JPRB,2.8902E-02_JPRB,2.5570E-02_JPRB,&
&2.1093E-02_JPRB,1.5716E-02_JPRB,1.5104E-02_JPRB/)
KAO( :, 3, 6,12) = (/&
&4.4786E-02_JPRB,3.9451E-02_JPRB,3.6064E-02_JPRB,3.2991E-02_JPRB,3.0223E-02_JPRB,2.6609E-02_JPRB,&
&2.2435E-02_JPRB,1.7637E-02_JPRB,1.8165E-02_JPRB/)
KAO( :, 4, 6,12) = (/&
&4.4788E-02_JPRB,3.9699E-02_JPRB,3.6561E-02_JPRB,3.4163E-02_JPRB,3.1314E-02_JPRB,2.7788E-02_JPRB,&
&2.3906E-02_JPRB,1.9877E-02_JPRB,2.1395E-02_JPRB/)
KAO( :, 5, 6,12) = (/&
&4.4447E-02_JPRB,3.9668E-02_JPRB,3.6988E-02_JPRB,3.5173E-02_JPRB,3.2361E-02_JPRB,2.9209E-02_JPRB,&
&2.5326E-02_JPRB,2.2392E-02_JPRB,2.4740E-02_JPRB/)
KAO( :, 1, 7,12) = (/&
&4.2520E-02_JPRB,3.7241E-02_JPRB,3.3313E-02_JPRB,2.9817E-02_JPRB,2.6724E-02_JPRB,2.3713E-02_JPRB,&
&1.9392E-02_JPRB,1.3514E-02_JPRB,1.0779E-02_JPRB/)
KAO( :, 2, 7,12) = (/&
&4.3342E-02_JPRB,3.8062E-02_JPRB,3.4549E-02_JPRB,3.1204E-02_JPRB,2.8393E-02_JPRB,2.5083E-02_JPRB,&
&2.0539E-02_JPRB,1.4970E-02_JPRB,1.2835E-02_JPRB/)
KAO( :, 3, 7,12) = (/&
&4.3790E-02_JPRB,3.8673E-02_JPRB,3.5497E-02_JPRB,3.2592E-02_JPRB,2.9885E-02_JPRB,2.6278E-02_JPRB,&
&2.1950E-02_JPRB,1.6561E-02_JPRB,1.5528E-02_JPRB/)
KAO( :, 4, 7,12) = (/&
&4.3699E-02_JPRB,3.8889E-02_JPRB,3.6038E-02_JPRB,3.3992E-02_JPRB,3.1096E-02_JPRB,2.7610E-02_JPRB,&
&2.3462E-02_JPRB,1.8494E-02_JPRB,1.8561E-02_JPRB/)
KAO( :, 5, 7,12) = (/&
&4.3391E-02_JPRB,3.8899E-02_JPRB,3.6695E-02_JPRB,3.5094E-02_JPRB,3.2242E-02_JPRB,2.9127E-02_JPRB,&
&2.4986E-02_JPRB,2.0683E-02_JPRB,2.1759E-02_JPRB/)
KAO( :, 1, 8,12) = (/&
&4.0705E-02_JPRB,3.5661E-02_JPRB,3.2044E-02_JPRB,2.8588E-02_JPRB,2.5730E-02_JPRB,2.2651E-02_JPRB,&
&1.8403E-02_JPRB,1.2786E-02_JPRB,1.0617E-02_JPRB/)
KAO( :, 2, 8,12) = (/&
&4.1513E-02_JPRB,3.6523E-02_JPRB,3.3287E-02_JPRB,3.0168E-02_JPRB,2.7518E-02_JPRB,2.4185E-02_JPRB,&
&1.9645E-02_JPRB,1.4186E-02_JPRB,1.1770E-02_JPRB/)
KAO( :, 3, 8,12) = (/&
&4.1918E-02_JPRB,3.7171E-02_JPRB,3.4241E-02_JPRB,3.1699E-02_JPRB,2.9124E-02_JPRB,2.5489E-02_JPRB,&
&2.1120E-02_JPRB,1.5769E-02_JPRB,1.3550E-02_JPRB/)
KAO( :, 4, 8,12) = (/&
&4.1853E-02_JPRB,3.7439E-02_JPRB,3.4958E-02_JPRB,3.3201E-02_JPRB,3.0465E-02_JPRB,2.6939E-02_JPRB,&
&2.2712E-02_JPRB,1.7517E-02_JPRB,1.5986E-02_JPRB/)
KAO( :, 5, 8,12) = (/&
&4.1733E-02_JPRB,3.7668E-02_JPRB,3.5839E-02_JPRB,3.4355E-02_JPRB,3.1760E-02_JPRB,2.8542E-02_JPRB,&
&2.4348E-02_JPRB,1.9402E-02_JPRB,1.8887E-02_JPRB/)
KAO( :, 1, 9,12) = (/&
&3.8179E-02_JPRB,3.3470E-02_JPRB,3.0206E-02_JPRB,2.7054E-02_JPRB,2.4424E-02_JPRB,2.1213E-02_JPRB,&
&1.7112E-02_JPRB,1.2467E-02_JPRB,1.5003E-02_JPRB/)
KAO( :, 2, 9,12) = (/&
&3.9010E-02_JPRB,3.4434E-02_JPRB,3.1441E-02_JPRB,2.8741E-02_JPRB,2.6231E-02_JPRB,2.2823E-02_JPRB,&
&1.8428E-02_JPRB,1.3530E-02_JPRB,1.6372E-02_JPRB/)
KAO( :, 3, 9,12) = (/&
&3.9453E-02_JPRB,3.5166E-02_JPRB,3.2518E-02_JPRB,3.0394E-02_JPRB,2.7907E-02_JPRB,2.4225E-02_JPRB,&
&1.9954E-02_JPRB,1.4900E-02_JPRB,1.8039E-02_JPRB/)
KAO( :, 4, 9,12) = (/&
&3.9552E-02_JPRB,3.5595E-02_JPRB,3.3460E-02_JPRB,3.1929E-02_JPRB,2.9264E-02_JPRB,2.5769E-02_JPRB,&
&2.1600E-02_JPRB,1.6537E-02_JPRB,1.9903E-02_JPRB/)
KAO( :, 5, 9,12) = (/&
&3.9456E-02_JPRB,3.5940E-02_JPRB,3.4560E-02_JPRB,3.3060E-02_JPRB,3.0675E-02_JPRB,2.7481E-02_JPRB,&
&2.3382E-02_JPRB,1.8398E-02_JPRB,2.1739E-02_JPRB/)
KAO( :, 1,10,12) = (/&
&3.5238E-02_JPRB,3.0971E-02_JPRB,2.8042E-02_JPRB,2.5331E-02_JPRB,2.2876E-02_JPRB,1.9632E-02_JPRB,&
&1.5965E-02_JPRB,1.2700E-02_JPRB,4.7338E-02_JPRB/)
KAO( :, 2,10,12) = (/&
&3.6134E-02_JPRB,3.2062E-02_JPRB,2.9356E-02_JPRB,2.7135E-02_JPRB,2.4639E-02_JPRB,2.1263E-02_JPRB,&
&1.7126E-02_JPRB,1.3564E-02_JPRB,4.9352E-02_JPRB/)
KAO( :, 3,10,12) = (/&
&3.6647E-02_JPRB,3.2881E-02_JPRB,3.0571E-02_JPRB,2.8822E-02_JPRB,2.6275E-02_JPRB,2.2691E-02_JPRB,&
&1.8634E-02_JPRB,1.4609E-02_JPRB,5.1163E-02_JPRB/)
KAO( :, 4,10,12) = (/&
&3.6732E-02_JPRB,3.3352E-02_JPRB,3.1697E-02_JPRB,3.0299E-02_JPRB,2.7653E-02_JPRB,2.4298E-02_JPRB,&
&2.0355E-02_JPRB,1.5925E-02_JPRB,5.2665E-02_JPRB/)
KAO( :, 5,10,12) = (/&
&3.6735E-02_JPRB,3.3801E-02_JPRB,3.2857E-02_JPRB,3.1401E-02_JPRB,2.9116E-02_JPRB,2.6070E-02_JPRB,&
&2.2245E-02_JPRB,1.7479E-02_JPRB,5.4548E-02_JPRB/)
KAO( :, 1,11,12) = (/&
&3.2545E-02_JPRB,2.8854E-02_JPRB,2.6358E-02_JPRB,2.4300E-02_JPRB,2.1804E-02_JPRB,1.8684E-02_JPRB,&
&1.5775E-02_JPRB,1.3392E-02_JPRB,8.3440E-02_JPRB/)
KAO( :, 2,11,12) = (/&
&3.3300E-02_JPRB,2.9905E-02_JPRB,2.7758E-02_JPRB,2.6019E-02_JPRB,2.3465E-02_JPRB,2.0097E-02_JPRB,&
&1.6793E-02_JPRB,1.4249E-02_JPRB,8.5867E-02_JPRB/)
KAO( :, 3,11,12) = (/&
&3.3558E-02_JPRB,3.0525E-02_JPRB,2.8985E-02_JPRB,2.7554E-02_JPRB,2.4920E-02_JPRB,2.1636E-02_JPRB,&
&1.8144E-02_JPRB,1.5281E-02_JPRB,8.8098E-02_JPRB/)
KAO( :, 4,11,12) = (/&
&3.3710E-02_JPRB,3.1080E-02_JPRB,3.0218E-02_JPRB,2.8753E-02_JPRB,2.6347E-02_JPRB,2.3365E-02_JPRB,&
&1.9836E-02_JPRB,1.6406E-02_JPRB,9.0071E-02_JPRB/)
KAO( :, 5,11,12) = (/&
&3.3928E-02_JPRB,3.1726E-02_JPRB,3.1326E-02_JPRB,2.9966E-02_JPRB,2.7916E-02_JPRB,2.5204E-02_JPRB,&
&2.1753E-02_JPRB,1.7712E-02_JPRB,9.1519E-02_JPRB/)
KAO( :, 1,12,12) = (/&
&2.9830E-02_JPRB,2.6721E-02_JPRB,2.4676E-02_JPRB,2.2938E-02_JPRB,2.0448E-02_JPRB,1.7882E-02_JPRB,&
&1.5923E-02_JPRB,1.3970E-02_JPRB,1.1086E-01_JPRB/)
KAO( :, 2,12,12) = (/&
&3.0231E-02_JPRB,2.7476E-02_JPRB,2.6007E-02_JPRB,2.4462E-02_JPRB,2.1935E-02_JPRB,1.9103E-02_JPRB,&
&1.6840E-02_JPRB,1.4875E-02_JPRB,1.1330E-01_JPRB/)
KAO( :, 3,12,12) = (/&
&3.0491E-02_JPRB,2.8099E-02_JPRB,2.7260E-02_JPRB,2.5711E-02_JPRB,2.3307E-02_JPRB,2.0562E-02_JPRB,&
&1.8077E-02_JPRB,1.5918E-02_JPRB,1.1557E-01_JPRB/)
KAO( :, 4,12,12) = (/&
&3.0757E-02_JPRB,2.8842E-02_JPRB,2.8411E-02_JPRB,2.6924E-02_JPRB,2.4803E-02_JPRB,2.2253E-02_JPRB,&
&1.9581E-02_JPRB,1.7012E-02_JPRB,1.1765E-01_JPRB/)
KAO( :, 5,12,12) = (/&
&3.0918E-02_JPRB,2.9599E-02_JPRB,2.9489E-02_JPRB,2.8288E-02_JPRB,2.6494E-02_JPRB,2.4129E-02_JPRB,&
&2.1275E-02_JPRB,1.8143E-02_JPRB,1.1909E-01_JPRB/)
KAO( :, 1,13,12) = (/&
&2.7094E-02_JPRB,2.4532E-02_JPRB,2.3049E-02_JPRB,2.1309E-02_JPRB,1.9154E-02_JPRB,1.7486E-02_JPRB,&
&1.6144E-02_JPRB,1.4353E-02_JPRB,1.1524E-01_JPRB/)
KAO( :, 2,13,12) = (/&
&2.7412E-02_JPRB,2.5168E-02_JPRB,2.4223E-02_JPRB,2.2514E-02_JPRB,2.0316E-02_JPRB,1.8507E-02_JPRB,&
&1.7150E-02_JPRB,1.5366E-02_JPRB,1.1754E-01_JPRB/)
KAO( :, 3,13,12) = (/&
&2.7677E-02_JPRB,2.5904E-02_JPRB,2.5334E-02_JPRB,2.3685E-02_JPRB,2.1617E-02_JPRB,1.9773E-02_JPRB,&
&1.8343E-02_JPRB,1.6413E-02_JPRB,1.1954E-01_JPRB/)
KAO( :, 4,13,12) = (/&
&2.7872E-02_JPRB,2.6672E-02_JPRB,2.6384E-02_JPRB,2.5015E-02_JPRB,2.3188E-02_JPRB,2.1278E-02_JPRB,&
&1.9644E-02_JPRB,1.7533E-02_JPRB,1.2118E-01_JPRB/)
KAO( :, 5,13,12) = (/&
&2.7954E-02_JPRB,2.7488E-02_JPRB,2.7495E-02_JPRB,2.6532E-02_JPRB,2.4977E-02_JPRB,2.3012E-02_JPRB,&
&2.1088E-02_JPRB,1.8595E-02_JPRB,1.2230E-01_JPRB/)
KAO( :, 1, 1,13) = (/&
&5.6053E-02_JPRB,4.9173E-02_JPRB,4.2351E-02_JPRB,3.6619E-02_JPRB,3.1919E-02_JPRB,2.7549E-02_JPRB,&
&2.5709E-02_JPRB,2.8817E-02_JPRB,3.2228E-02_JPRB/)
KAO( :, 2, 1,13) = (/&
&5.5104E-02_JPRB,4.8363E-02_JPRB,4.1989E-02_JPRB,3.6731E-02_JPRB,3.2283E-02_JPRB,2.9042E-02_JPRB,&
&2.9013E-02_JPRB,3.3235E-02_JPRB,3.7260E-02_JPRB/)
KAO( :, 3, 1,13) = (/&
&5.3995E-02_JPRB,4.7411E-02_JPRB,4.1385E-02_JPRB,3.6532E-02_JPRB,3.2764E-02_JPRB,3.0737E-02_JPRB,&
&3.2896E-02_JPRB,3.7808E-02_JPRB,4.2479E-02_JPRB/)
KAO( :, 4, 1,13) = (/&
&5.2736E-02_JPRB,4.6336E-02_JPRB,4.0785E-02_JPRB,3.6489E-02_JPRB,3.3723E-02_JPRB,3.2658E-02_JPRB,&
&3.6921E-02_JPRB,4.2523E-02_JPRB,4.7856E-02_JPRB/)
KAO( :, 5, 1,13) = (/&
&5.1501E-02_JPRB,4.5267E-02_JPRB,4.0254E-02_JPRB,3.6460E-02_JPRB,3.5114E-02_JPRB,3.5037E-02_JPRB,&
&4.0972E-02_JPRB,4.7260E-02_JPRB,5.3261E-02_JPRB/)
KAO( :, 1, 2,13) = (/&
&6.0681E-02_JPRB,5.3202E-02_JPRB,4.5845E-02_JPRB,3.9636E-02_JPRB,3.4042E-02_JPRB,2.9064E-02_JPRB,&
&2.6532E-02_JPRB,2.9036E-02_JPRB,3.2832E-02_JPRB/)
KAO( :, 2, 2,13) = (/&
&5.9591E-02_JPRB,5.2263E-02_JPRB,4.5381E-02_JPRB,3.9598E-02_JPRB,3.4216E-02_JPRB,3.0746E-02_JPRB,&
&2.9570E-02_JPRB,3.3591E-02_JPRB,3.8065E-02_JPRB/)
KAO( :, 3, 2,13) = (/&
&5.8268E-02_JPRB,5.1123E-02_JPRB,4.4655E-02_JPRB,3.9364E-02_JPRB,3.4820E-02_JPRB,3.2584E-02_JPRB,&
&3.3306E-02_JPRB,3.8344E-02_JPRB,4.3514E-02_JPRB/)
KAO( :, 4, 2,13) = (/&
&5.6859E-02_JPRB,4.9908E-02_JPRB,4.4073E-02_JPRB,3.9320E-02_JPRB,3.5951E-02_JPRB,3.4443E-02_JPRB,&
&3.7381E-02_JPRB,4.3145E-02_JPRB,4.9018E-02_JPRB/)
KAO( :, 5, 2,13) = (/&
&5.5606E-02_JPRB,4.8809E-02_JPRB,4.3641E-02_JPRB,3.9295E-02_JPRB,3.7457E-02_JPRB,3.6510E-02_JPRB,&
&4.1577E-02_JPRB,4.8053E-02_JPRB,5.4636E-02_JPRB/)
KAO( :, 1, 3,13) = (/&
&6.5281E-02_JPRB,5.7202E-02_JPRB,4.9259E-02_JPRB,4.2481E-02_JPRB,3.6242E-02_JPRB,3.0257E-02_JPRB,&
&2.6947E-02_JPRB,2.7850E-02_JPRB,3.1754E-02_JPRB/)
KAO( :, 2, 3,13) = (/&
&6.4026E-02_JPRB,5.6115E-02_JPRB,4.8709E-02_JPRB,4.2529E-02_JPRB,3.6413E-02_JPRB,3.1975E-02_JPRB,&
&2.9537E-02_JPRB,3.2421E-02_JPRB,3.6975E-02_JPRB/)
KAO( :, 3, 3,13) = (/&
&6.2582E-02_JPRB,5.4864E-02_JPRB,4.7944E-02_JPRB,4.2387E-02_JPRB,3.6942E-02_JPRB,3.3882E-02_JPRB,&
&3.2746E-02_JPRB,3.7152E-02_JPRB,4.2391E-02_JPRB/)
KAO( :, 4, 3,13) = (/&
&6.1252E-02_JPRB,5.3699E-02_JPRB,4.7471E-02_JPRB,4.2276E-02_JPRB,3.8007E-02_JPRB,3.5845E-02_JPRB,&
&3.6492E-02_JPRB,4.2063E-02_JPRB,4.8049E-02_JPRB/)
KAO( :, 5, 3,13) = (/&
&6.0092E-02_JPRB,5.2697E-02_JPRB,4.7050E-02_JPRB,4.2178E-02_JPRB,3.9419E-02_JPRB,3.7791E-02_JPRB,&
&4.0791E-02_JPRB,4.7197E-02_JPRB,5.3978E-02_JPRB/)
KAO( :, 1, 4,13) = (/&
&6.9156E-02_JPRB,6.0580E-02_JPRB,5.2151E-02_JPRB,4.4993E-02_JPRB,3.8321E-02_JPRB,3.1681E-02_JPRB,&
&2.7066E-02_JPRB,2.6200E-02_JPRB,2.9938E-02_JPRB/)
KAO( :, 2, 4,13) = (/&
&6.7721E-02_JPRB,5.9333E-02_JPRB,5.1460E-02_JPRB,4.5174E-02_JPRB,3.8672E-02_JPRB,3.3341E-02_JPRB,&
&2.9463E-02_JPRB,3.0601E-02_JPRB,3.4960E-02_JPRB/)
KAO( :, 3, 4,13) = (/&
&6.6317E-02_JPRB,5.8105E-02_JPRB,5.0834E-02_JPRB,4.5138E-02_JPRB,3.9401E-02_JPRB,3.5131E-02_JPRB,&
&3.2153E-02_JPRB,3.5157E-02_JPRB,4.0204E-02_JPRB/)
KAO( :, 4, 4,13) = (/&
&6.5137E-02_JPRB,5.7074E-02_JPRB,5.0526E-02_JPRB,4.5041E-02_JPRB,4.0452E-02_JPRB,3.6956E-02_JPRB,&
&3.5433E-02_JPRB,4.0097E-02_JPRB,4.5914E-02_JPRB/)
KAO( :, 5, 4,13) = (/&
&6.4115E-02_JPRB,5.6230E-02_JPRB,5.0276E-02_JPRB,4.5144E-02_JPRB,4.1609E-02_JPRB,3.8932E-02_JPRB,&
&3.9448E-02_JPRB,4.5417E-02_JPRB,5.2017E-02_JPRB/)
KAO( :, 1, 5,13) = (/&
&7.2400E-02_JPRB,6.3404E-02_JPRB,5.4540E-02_JPRB,4.7112E-02_JPRB,4.0185E-02_JPRB,3.3245E-02_JPRB,&
&2.7454E-02_JPRB,2.4538E-02_JPRB,2.7637E-02_JPRB/)
KAO( :, 2, 5,13) = (/&
&7.1034E-02_JPRB,6.2212E-02_JPRB,5.3950E-02_JPRB,4.7421E-02_JPRB,4.0716E-02_JPRB,3.5033E-02_JPRB,&
&2.9541E-02_JPRB,2.8475E-02_JPRB,3.2456E-02_JPRB/)
KAO( :, 3, 5,13) = (/&
&6.9683E-02_JPRB,6.1033E-02_JPRB,5.3449E-02_JPRB,4.7487E-02_JPRB,4.1776E-02_JPRB,3.6647E-02_JPRB,&
&3.1941E-02_JPRB,3.2964E-02_JPRB,3.7708E-02_JPRB/)
KAO( :, 4, 5,13) = (/&
&6.8593E-02_JPRB,6.0082E-02_JPRB,5.3255E-02_JPRB,4.7581E-02_JPRB,4.2936E-02_JPRB,3.8247E-02_JPRB,&
&3.4793E-02_JPRB,3.7940E-02_JPRB,4.3452E-02_JPRB/)
KAO( :, 5, 5,13) = (/&
&6.7660E-02_JPRB,5.9367E-02_JPRB,5.3230E-02_JPRB,4.8095E-02_JPRB,4.3998E-02_JPRB,4.0012E-02_JPRB,&
&3.8369E-02_JPRB,4.3216E-02_JPRB,4.9502E-02_JPRB/)
KAO( :, 1, 6,13) = (/&
&7.5282E-02_JPRB,6.5913E-02_JPRB,5.6672E-02_JPRB,4.9038E-02_JPRB,4.1667E-02_JPRB,3.4580E-02_JPRB,&
&2.8084E-02_JPRB,2.2885E-02_JPRB,2.4729E-02_JPRB/)
KAO( :, 2, 6,13) = (/&
&7.3954E-02_JPRB,6.4757E-02_JPRB,5.6182E-02_JPRB,4.9451E-02_JPRB,4.2376E-02_JPRB,3.6480E-02_JPRB,&
&3.0034E-02_JPRB,2.6432E-02_JPRB,2.9602E-02_JPRB/)
KAO( :, 3, 6,13) = (/&
&7.2618E-02_JPRB,6.3591E-02_JPRB,5.5752E-02_JPRB,4.9591E-02_JPRB,4.3630E-02_JPRB,3.8182E-02_JPRB,&
&3.2101E-02_JPRB,3.0615E-02_JPRB,3.4863E-02_JPRB/)
KAO( :, 4, 6,13) = (/&
&7.1650E-02_JPRB,6.2766E-02_JPRB,5.5838E-02_JPRB,4.9867E-02_JPRB,4.5071E-02_JPRB,3.9626E-02_JPRB,&
&3.4633E-02_JPRB,3.5415E-02_JPRB,4.0513E-02_JPRB/)
KAO( :, 5, 6,13) = (/&
&7.0928E-02_JPRB,6.2275E-02_JPRB,5.5944E-02_JPRB,5.0656E-02_JPRB,4.6360E-02_JPRB,4.1240E-02_JPRB,&
&3.7820E-02_JPRB,4.0601E-02_JPRB,4.6473E-02_JPRB/)
KAO( :, 1, 7,13) = (/&
&7.7231E-02_JPRB,6.7608E-02_JPRB,5.8137E-02_JPRB,5.0496E-02_JPRB,4.2780E-02_JPRB,3.5440E-02_JPRB,&
&2.8711E-02_JPRB,2.1532E-02_JPRB,2.1358E-02_JPRB/)
KAO( :, 2, 7,13) = (/&
&7.6126E-02_JPRB,6.6645E-02_JPRB,5.7867E-02_JPRB,5.0956E-02_JPRB,4.3638E-02_JPRB,3.7441E-02_JPRB,&
&3.0756E-02_JPRB,2.4515E-02_JPRB,2.6150E-02_JPRB/)
KAO( :, 3, 7,13) = (/&
&7.4977E-02_JPRB,6.5643E-02_JPRB,5.7692E-02_JPRB,5.1264E-02_JPRB,4.5058E-02_JPRB,3.9385E-02_JPRB,&
&3.2638E-02_JPRB,2.8375E-02_JPRB,3.1403E-02_JPRB/)
KAO( :, 4, 7,13) = (/&
&7.4190E-02_JPRB,6.5005E-02_JPRB,5.7989E-02_JPRB,5.1738E-02_JPRB,4.6795E-02_JPRB,4.1075E-02_JPRB,&
&3.4915E-02_JPRB,3.2892E-02_JPRB,3.7110E-02_JPRB/)
KAO( :, 5, 7,13) = (/&
&7.3624E-02_JPRB,6.4678E-02_JPRB,5.8242E-02_JPRB,5.2839E-02_JPRB,4.8405E-02_JPRB,4.2696E-02_JPRB,&
&3.7814E-02_JPRB,3.7869E-02_JPRB,4.3186E-02_JPRB/)
KAO( :, 1, 8,13) = (/&
&7.8000E-02_JPRB,6.8274E-02_JPRB,5.8718E-02_JPRB,5.1101E-02_JPRB,4.3121E-02_JPRB,3.5929E-02_JPRB,&
&2.8945E-02_JPRB,2.0591E-02_JPRB,1.8045E-02_JPRB/)
KAO( :, 2, 8,13) = (/&
&7.7193E-02_JPRB,6.7571E-02_JPRB,5.8739E-02_JPRB,5.1625E-02_JPRB,4.4291E-02_JPRB,3.8058E-02_JPRB,&
&3.1224E-02_JPRB,2.3099E-02_JPRB,2.2474E-02_JPRB/)
KAO( :, 3, 8,13) = (/&
&7.6273E-02_JPRB,6.6769E-02_JPRB,5.8915E-02_JPRB,5.2274E-02_JPRB,4.5989E-02_JPRB,4.0273E-02_JPRB,&
&3.3241E-02_JPRB,2.6350E-02_JPRB,2.7546E-02_JPRB/)
KAO( :, 4, 8,13) = (/&
&7.5688E-02_JPRB,6.6346E-02_JPRB,5.9396E-02_JPRB,5.3087E-02_JPRB,4.8066E-02_JPRB,4.2222E-02_JPRB,&
&3.5406E-02_JPRB,3.0325E-02_JPRB,3.3143E-02_JPRB/)
KAO( :, 5, 8,13) = (/&
&7.5270E-02_JPRB,6.6169E-02_JPRB,5.9886E-02_JPRB,5.4558E-02_JPRB,5.0013E-02_JPRB,4.4073E-02_JPRB,&
&3.8032E-02_JPRB,3.5067E-02_JPRB,3.9209E-02_JPRB/)
KAO( :, 1, 9,13) = (/&
&7.7473E-02_JPRB,6.7808E-02_JPRB,5.8332E-02_JPRB,5.0781E-02_JPRB,4.2784E-02_JPRB,3.5895E-02_JPRB,&
&2.8746E-02_JPRB,1.9977E-02_JPRB,2.5516E-02_JPRB/)
KAO( :, 2, 9,13) = (/&
&7.6914E-02_JPRB,6.7321E-02_JPRB,5.8710E-02_JPRB,5.1554E-02_JPRB,4.4348E-02_JPRB,3.8188E-02_JPRB,&
&3.1209E-02_JPRB,2.2143E-02_JPRB,2.7211E-02_JPRB/)
KAO( :, 3, 9,13) = (/&
&7.6348E-02_JPRB,6.6831E-02_JPRB,5.9238E-02_JPRB,5.2455E-02_JPRB,4.6359E-02_JPRB,4.0690E-02_JPRB,&
&3.3365E-02_JPRB,2.4927E-02_JPRB,2.8892E-02_JPRB/)
KAO( :, 4, 9,13) = (/&
&7.6078E-02_JPRB,6.6718E-02_JPRB,5.9965E-02_JPRB,5.3687E-02_JPRB,4.8782E-02_JPRB,4.2963E-02_JPRB,&
&3.5682E-02_JPRB,2.8422E-02_JPRB,3.1640E-02_JPRB/)
KAO( :, 5, 9,13) = (/&
&7.5933E-02_JPRB,6.6835E-02_JPRB,6.0758E-02_JPRB,5.5666E-02_JPRB,5.1075E-02_JPRB,4.5007E-02_JPRB,&
&3.8345E-02_JPRB,3.2458E-02_JPRB,3.5657E-02_JPRB/)
KAO( :, 1,10,13) = (/&
&7.5495E-02_JPRB,6.6073E-02_JPRB,5.6962E-02_JPRB,4.9669E-02_JPRB,4.1944E-02_JPRB,3.5433E-02_JPRB,&
&2.8273E-02_JPRB,1.9547E-02_JPRB,6.8270E-02_JPRB/)
KAO( :, 2,10,13) = (/&
&7.5127E-02_JPRB,6.5753E-02_JPRB,5.7655E-02_JPRB,5.0612E-02_JPRB,4.3966E-02_JPRB,3.7985E-02_JPRB,&
&3.0798E-02_JPRB,2.1586E-02_JPRB,7.2556E-02_JPRB/)
KAO( :, 3,10,13) = (/&
&7.4986E-02_JPRB,6.5658E-02_JPRB,5.8530E-02_JPRB,5.1941E-02_JPRB,4.6351E-02_JPRB,4.0729E-02_JPRB,&
&3.3154E-02_JPRB,2.4145E-02_JPRB,7.6901E-02_JPRB/)
KAO( :, 4,10,13) = (/&
&7.5261E-02_JPRB,6.6078E-02_JPRB,5.9658E-02_JPRB,5.3761E-02_JPRB,4.9061E-02_JPRB,4.3256E-02_JPRB,&
&3.5593E-02_JPRB,2.7205E-02_JPRB,8.0949E-02_JPRB/)
KAO( :, 5,10,13) = (/&
&7.5310E-02_JPRB,6.6484E-02_JPRB,6.0891E-02_JPRB,5.6203E-02_JPRB,5.1608E-02_JPRB,4.5631E-02_JPRB,&
&3.8393E-02_JPRB,3.0810E-02_JPRB,8.3946E-02_JPRB/)
KAO( :, 1,11,13) = (/&
&7.2145E-02_JPRB,6.3140E-02_JPRB,5.5079E-02_JPRB,4.8199E-02_JPRB,4.1552E-02_JPRB,3.5607E-02_JPRB,&
&2.8410E-02_JPRB,2.0333E-02_JPRB,1.1722E-01_JPRB/)
KAO( :, 2,11,13) = (/&
&7.2308E-02_JPRB,6.3289E-02_JPRB,5.6229E-02_JPRB,4.9646E-02_JPRB,4.4153E-02_JPRB,3.8471E-02_JPRB,&
&3.1024E-02_JPRB,2.2227E-02_JPRB,1.2017E-01_JPRB/)
KAO( :, 3,11,13) = (/&
&7.2843E-02_JPRB,6.3926E-02_JPRB,5.7644E-02_JPRB,5.1784E-02_JPRB,4.7031E-02_JPRB,4.1323E-02_JPRB,&
&3.3588E-02_JPRB,2.4733E-02_JPRB,1.2387E-01_JPRB/)
KAO( :, 4,11,13) = (/&
&7.3135E-02_JPRB,6.4581E-02_JPRB,5.9101E-02_JPRB,5.4448E-02_JPRB,4.9988E-02_JPRB,4.3915E-02_JPRB,&
&3.6387E-02_JPRB,2.7718E-02_JPRB,1.2773E-01_JPRB/)
KAO( :, 5,11,13) = (/&
&7.3317E-02_JPRB,6.5357E-02_JPRB,6.0772E-02_JPRB,5.7257E-02_JPRB,5.2643E-02_JPRB,4.6647E-02_JPRB,&
&3.9495E-02_JPRB,3.1088E-02_JPRB,1.3117E-01_JPRB/)
KAO( :, 1,12,13) = (/&
&6.8339E-02_JPRB,5.9807E-02_JPRB,5.2868E-02_JPRB,4.6514E-02_JPRB,4.1030E-02_JPRB,3.5325E-02_JPRB,&
&2.8259E-02_JPRB,2.1368E-02_JPRB,1.5845E-01_JPRB/)
KAO( :, 2,12,13) = (/&
&6.9028E-02_JPRB,6.0544E-02_JPRB,5.4494E-02_JPRB,4.8800E-02_JPRB,4.4025E-02_JPRB,3.8260E-02_JPRB,&
&3.0917E-02_JPRB,2.3169E-02_JPRB,1.6072E-01_JPRB/)
KAO( :, 3,12,13) = (/&
&6.9564E-02_JPRB,6.1451E-02_JPRB,5.6107E-02_JPRB,5.1605E-02_JPRB,4.7233E-02_JPRB,4.1139E-02_JPRB,&
&3.3727E-02_JPRB,2.5462E-02_JPRB,1.6379E-01_JPRB/)
KAO( :, 4,12,13) = (/&
&7.0110E-02_JPRB,6.2544E-02_JPRB,5.8080E-02_JPRB,5.4612E-02_JPRB,5.0269E-02_JPRB,4.4060E-02_JPRB,&
&3.6850E-02_JPRB,2.8277E-02_JPRB,1.6703E-01_JPRB/)
KAO( :, 5,12,13) = (/&
&7.0812E-02_JPRB,6.3874E-02_JPRB,6.0361E-02_JPRB,5.7551E-02_JPRB,5.3132E-02_JPRB,4.7188E-02_JPRB,&
&4.0179E-02_JPRB,3.1468E-02_JPRB,1.7022E-01_JPRB/)
KAO( :, 1,13,13) = (/&
&6.4142E-02_JPRB,5.6225E-02_JPRB,5.0394E-02_JPRB,4.4947E-02_JPRB,4.0201E-02_JPRB,3.4418E-02_JPRB,&
&2.8158E-02_JPRB,2.2746E-02_JPRB,1.7050E-01_JPRB/)
KAO( :, 2,13,13) = (/&
&6.4886E-02_JPRB,5.7309E-02_JPRB,5.2171E-02_JPRB,4.7818E-02_JPRB,4.3432E-02_JPRB,3.7455E-02_JPRB,&
&3.0630E-02_JPRB,2.4364E-02_JPRB,1.7276E-01_JPRB/)
KAO( :, 3,13,13) = (/&
&6.5727E-02_JPRB,5.8652E-02_JPRB,5.4299E-02_JPRB,5.0937E-02_JPRB,4.6609E-02_JPRB,4.0612E-02_JPRB,&
&3.3484E-02_JPRB,2.6453E-02_JPRB,1.7566E-01_JPRB/)
KAO( :, 4,13,13) = (/&
&6.6753E-02_JPRB,6.0302E-02_JPRB,5.6875E-02_JPRB,5.4053E-02_JPRB,4.9735E-02_JPRB,4.3858E-02_JPRB,&
&3.6837E-02_JPRB,2.8969E-02_JPRB,1.7832E-01_JPRB/)
KAO( :, 5,13,13) = (/&
&6.7695E-02_JPRB,6.1869E-02_JPRB,5.9620E-02_JPRB,5.7064E-02_JPRB,5.2850E-02_JPRB,4.7362E-02_JPRB,&
&4.0382E-02_JPRB,3.1936E-02_JPRB,1.8057E-01_JPRB/)
KAO( :, 1, 1,14) = (/&
&7.1125E-02_JPRB,6.2447E-02_JPRB,5.3777E-02_JPRB,4.6002E-02_JPRB,3.9919E-02_JPRB,3.6099E-02_JPRB,&
&4.0006E-02_JPRB,4.6122E-02_JPRB,5.1833E-02_JPRB/)
KAO( :, 2, 1,14) = (/&
&6.9870E-02_JPRB,6.1342E-02_JPRB,5.2827E-02_JPRB,4.5922E-02_JPRB,4.0565E-02_JPRB,3.9007E-02_JPRB,&
&4.5679E-02_JPRB,5.2643E-02_JPRB,5.9148E-02_JPRB/)
KAO( :, 3, 1,14) = (/&
&6.8757E-02_JPRB,6.0364E-02_JPRB,5.2393E-02_JPRB,4.6480E-02_JPRB,4.1375E-02_JPRB,4.3228E-02_JPRB,&
&5.1554E-02_JPRB,5.9415E-02_JPRB,6.6727E-02_JPRB/)
KAO( :, 4, 1,14) = (/&
&6.7713E-02_JPRB,5.9439E-02_JPRB,5.2158E-02_JPRB,4.6803E-02_JPRB,4.2633E-02_JPRB,4.8201E-02_JPRB,&
&5.7539E-02_JPRB,6.6348E-02_JPRB,7.4536E-02_JPRB/)
KAO( :, 5, 1,14) = (/&
&6.6600E-02_JPRB,5.8466E-02_JPRB,5.1820E-02_JPRB,4.7055E-02_JPRB,4.4661E-02_JPRB,5.3325E-02_JPRB,&
&6.3678E-02_JPRB,7.3404E-02_JPRB,8.2448E-02_JPRB/)
KAO( :, 1, 2,14) = (/&
&7.7042E-02_JPRB,6.7550E-02_JPRB,5.8058E-02_JPRB,4.9570E-02_JPRB,4.3264E-02_JPRB,3.8479E-02_JPRB,&
&4.1328E-02_JPRB,4.7688E-02_JPRB,5.4228E-02_JPRB/)
KAO( :, 2, 2,14) = (/&
&7.5776E-02_JPRB,6.6451E-02_JPRB,5.7187E-02_JPRB,4.9780E-02_JPRB,4.4125E-02_JPRB,4.1352E-02_JPRB,&
&4.7706E-02_JPRB,5.5037E-02_JPRB,6.2579E-02_JPRB/)
KAO( :, 3, 2,14) = (/&
&7.4669E-02_JPRB,6.5491E-02_JPRB,5.6847E-02_JPRB,5.0512E-02_JPRB,4.5218E-02_JPRB,4.5782E-02_JPRB,&
&5.4332E-02_JPRB,6.2645E-02_JPRB,7.1228E-02_JPRB/)
KAO( :, 4, 2,14) = (/&
&7.3494E-02_JPRB,6.4459E-02_JPRB,5.6471E-02_JPRB,5.0688E-02_JPRB,4.6511E-02_JPRB,5.1170E-02_JPRB,&
&6.1095E-02_JPRB,7.0411E-02_JPRB,8.0040E-02_JPRB/)
KAO( :, 5, 2,14) = (/&
&7.2133E-02_JPRB,6.3274E-02_JPRB,5.5909E-02_JPRB,5.0987E-02_JPRB,4.8402E-02_JPRB,5.6911E-02_JPRB,&
&6.7954E-02_JPRB,7.8300E-02_JPRB,8.9007E-02_JPRB/)
KAO( :, 1, 3,14) = (/&
&8.3277E-02_JPRB,7.2971E-02_JPRB,6.2667E-02_JPRB,5.3474E-02_JPRB,4.6645E-02_JPRB,4.0581E-02_JPRB,&
&4.0951E-02_JPRB,4.7132E-02_JPRB,5.4097E-02_JPRB/)
KAO( :, 2, 3,14) = (/&
&8.2055E-02_JPRB,7.1904E-02_JPRB,6.1829E-02_JPRB,5.3750E-02_JPRB,4.7688E-02_JPRB,4.3144E-02_JPRB,&
&4.7845E-02_JPRB,5.5169E-02_JPRB,6.3384E-02_JPRB/)
KAO( :, 3, 3,14) = (/&
&8.0862E-02_JPRB,7.0861E-02_JPRB,6.1457E-02_JPRB,5.4455E-02_JPRB,4.8823E-02_JPRB,4.7333E-02_JPRB,&
&5.5190E-02_JPRB,6.3675E-02_JPRB,7.3215E-02_JPRB/)
KAO( :, 4, 3,14) = (/&
&7.9537E-02_JPRB,6.9705E-02_JPRB,6.0972E-02_JPRB,5.4811E-02_JPRB,5.0281E-02_JPRB,5.2809E-02_JPRB,&
&6.2782E-02_JPRB,7.2454E-02_JPRB,8.3349E-02_JPRB/)
KAO( :, 5, 3,14) = (/&
&7.8064E-02_JPRB,6.8419E-02_JPRB,6.0465E-02_JPRB,5.5324E-02_JPRB,5.2307E-02_JPRB,5.9034E-02_JPRB,&
&7.0524E-02_JPRB,8.1382E-02_JPRB,9.3638E-02_JPRB/)
KAO( :, 1, 4,14) = (/&
&9.0845E-02_JPRB,7.9564E-02_JPRB,6.8284E-02_JPRB,5.7995E-02_JPRB,5.0071E-02_JPRB,4.2766E-02_JPRB,&
&4.0354E-02_JPRB,4.5834E-02_JPRB,5.2848E-02_JPRB/)
KAO( :, 2, 4,14) = (/&
&8.9552E-02_JPRB,7.8435E-02_JPRB,6.7367E-02_JPRB,5.8123E-02_JPRB,5.1123E-02_JPRB,4.5183E-02_JPRB,&
&4.7218E-02_JPRB,5.4390E-02_JPRB,6.2802E-02_JPRB/)
KAO( :, 3, 4,14) = (/&
&8.8242E-02_JPRB,7.7291E-02_JPRB,6.6872E-02_JPRB,5.8721E-02_JPRB,5.2277E-02_JPRB,4.9062E-02_JPRB,&
&5.5104E-02_JPRB,6.3535E-02_JPRB,7.3415E-02_JPRB/)
KAO( :, 4, 4,14) = (/&
&8.6759E-02_JPRB,7.5998E-02_JPRB,6.6249E-02_JPRB,5.9144E-02_JPRB,5.4005E-02_JPRB,5.4305E-02_JPRB,&
&6.3297E-02_JPRB,7.3031E-02_JPRB,8.4384E-02_JPRB/)
KAO( :, 5, 4,14) = (/&
&8.5264E-02_JPRB,7.4691E-02_JPRB,6.5716E-02_JPRB,5.9851E-02_JPRB,5.6460E-02_JPRB,6.0471E-02_JPRB,&
&7.1720E-02_JPRB,8.2783E-02_JPRB,9.5664E-02_JPRB/)
KAO( :, 1, 5,14) = (/&
&9.9315E-02_JPRB,8.6956E-02_JPRB,7.4597E-02_JPRB,6.3098E-02_JPRB,5.3822E-02_JPRB,4.5087E-02_JPRB,&
&4.0285E-02_JPRB,4.4268E-02_JPRB,5.1127E-02_JPRB/)
KAO( :, 2, 5,14) = (/&
&9.7906E-02_JPRB,8.5725E-02_JPRB,7.3576E-02_JPRB,6.3138E-02_JPRB,5.4941E-02_JPRB,4.7422E-02_JPRB,&
&4.6902E-02_JPRB,5.3385E-02_JPRB,6.1752E-02_JPRB/)
KAO( :, 3, 5,14) = (/&
&9.6528E-02_JPRB,8.4522E-02_JPRB,7.2985E-02_JPRB,6.3691E-02_JPRB,5.5941E-02_JPRB,5.1390E-02_JPRB,&
&5.4800E-02_JPRB,6.3141E-02_JPRB,7.3064E-02_JPRB/)
KAO( :, 4, 5,14) = (/&
&9.5030E-02_JPRB,8.3215E-02_JPRB,7.2382E-02_JPRB,6.4248E-02_JPRB,5.7876E-02_JPRB,5.6367E-02_JPRB,&
&6.3403E-02_JPRB,7.3204E-02_JPRB,8.4675E-02_JPRB/)
KAO( :, 5, 5,14) = (/&
&9.3519E-02_JPRB,8.1896E-02_JPRB,7.1942E-02_JPRB,6.4913E-02_JPRB,6.0750E-02_JPRB,6.2288E-02_JPRB,&
&7.2363E-02_JPRB,8.3574E-02_JPRB,9.6711E-02_JPRB/)
KAO( :, 1, 6,14) = (/&
&1.0848E-01_JPRB,9.4964E-02_JPRB,8.1446E-02_JPRB,6.8624E-02_JPRB,5.8073E-02_JPRB,4.7733E-02_JPRB,&
&4.0794E-02_JPRB,4.2233E-02_JPRB,4.8838E-02_JPRB/)
KAO( :, 2, 6,14) = (/&
&1.0700E-01_JPRB,9.3665E-02_JPRB,8.0341E-02_JPRB,6.8687E-02_JPRB,5.9287E-02_JPRB,4.9965E-02_JPRB,&
&4.6801E-02_JPRB,5.1522E-02_JPRB,5.9571E-02_JPRB/)
KAO( :, 3, 6,14) = (/&
&1.0569E-01_JPRB,9.2526E-02_JPRB,7.9786E-02_JPRB,6.9323E-02_JPRB,6.0296E-02_JPRB,5.3850E-02_JPRB,&
&5.4326E-02_JPRB,6.1617E-02_JPRB,7.1174E-02_JPRB/)
KAO( :, 4, 6,14) = (/&
&1.0422E-01_JPRB,9.1243E-02_JPRB,7.9257E-02_JPRB,7.0200E-02_JPRB,6.2110E-02_JPRB,5.8890E-02_JPRB,&
&6.2697E-02_JPRB,7.2186E-02_JPRB,8.3411E-02_JPRB/)
KAO( :, 5, 6,14) = (/&
&1.0274E-01_JPRB,8.9945E-02_JPRB,7.8955E-02_JPRB,7.0870E-02_JPRB,6.5007E-02_JPRB,6.4538E-02_JPRB,&
&7.1962E-02_JPRB,8.3225E-02_JPRB,9.6184E-02_JPRB/)
KAO( :, 1, 7,14) = (/&
&1.1805E-01_JPRB,1.0333E-01_JPRB,8.8604E-02_JPRB,7.4383E-02_JPRB,6.2795E-02_JPRB,5.0938E-02_JPRB,&
&4.1734E-02_JPRB,4.0173E-02_JPRB,4.6320E-02_JPRB/)
KAO( :, 2, 7,14) = (/&
&1.1659E-01_JPRB,1.0206E-01_JPRB,8.7517E-02_JPRB,7.4746E-02_JPRB,6.4050E-02_JPRB,5.3141E-02_JPRB,&
&4.7155E-02_JPRB,4.9297E-02_JPRB,5.6966E-02_JPRB/)
KAO( :, 3, 7,14) = (/&
&1.1548E-01_JPRB,1.0108E-01_JPRB,8.7065E-02_JPRB,7.5639E-02_JPRB,6.5270E-02_JPRB,5.6793E-02_JPRB,&
&5.4049E-02_JPRB,5.9341E-02_JPRB,6.8535E-02_JPRB/)
KAO( :, 4, 7,14) = (/&
&1.1421E-01_JPRB,9.9974E-02_JPRB,8.6788E-02_JPRB,7.6683E-02_JPRB,6.6954E-02_JPRB,6.1718E-02_JPRB,&
&6.2059E-02_JPRB,7.0009E-02_JPRB,8.0835E-02_JPRB/)
KAO( :, 5, 7,14) = (/&
&1.1283E-01_JPRB,9.8769E-02_JPRB,8.6621E-02_JPRB,7.7418E-02_JPRB,6.9776E-02_JPRB,6.7214E-02_JPRB,&
&7.0897E-02_JPRB,8.1280E-02_JPRB,9.3717E-02_JPRB/)
KAO( :, 1, 8,14) = (/&
&1.2760E-01_JPRB,1.1168E-01_JPRB,9.5756E-02_JPRB,8.0242E-02_JPRB,6.7771E-02_JPRB,5.4512E-02_JPRB,&
&4.3297E-02_JPRB,3.8468E-02_JPRB,4.3412E-02_JPRB/)
KAO( :, 2, 8,14) = (/&
&1.2647E-01_JPRB,1.1069E-01_JPRB,9.4911E-02_JPRB,8.1080E-02_JPRB,6.9303E-02_JPRB,5.6801E-02_JPRB,&
&4.8262E-02_JPRB,4.7089E-02_JPRB,5.4046E-02_JPRB/)
KAO( :, 3, 8,14) = (/&
&1.2554E-01_JPRB,1.0988E-01_JPRB,9.4556E-02_JPRB,8.2231E-02_JPRB,7.0704E-02_JPRB,6.0253E-02_JPRB,&
&5.4589E-02_JPRB,5.6872E-02_JPRB,6.5560E-02_JPRB/)
KAO( :, 4, 8,14) = (/&
&1.2457E-01_JPRB,1.0903E-01_JPRB,9.4616E-02_JPRB,8.3457E-02_JPRB,7.2396E-02_JPRB,6.4980E-02_JPRB,&
&6.1867E-02_JPRB,6.7548E-02_JPRB,7.7808E-02_JPRB/)
KAO( :, 5, 8,14) = (/&
&1.2330E-01_JPRB,1.0792E-01_JPRB,9.4626E-02_JPRB,8.4389E-02_JPRB,7.5157E-02_JPRB,7.0416E-02_JPRB,&
&7.0105E-02_JPRB,7.8665E-02_JPRB,9.0560E-02_JPRB/)
KAO( :, 1, 9,14) = (/&
&1.3720E-01_JPRB,1.2007E-01_JPRB,1.0294E-01_JPRB,8.6103E-02_JPRB,7.2470E-02_JPRB,5.8097E-02_JPRB,&
&4.5389E-02_JPRB,3.6904E-02_JPRB,4.1799E-02_JPRB/)
KAO( :, 2, 9,14) = (/&
&1.3628E-01_JPRB,1.1927E-01_JPRB,1.0226E-01_JPRB,8.7181E-02_JPRB,7.4343E-02_JPRB,6.0740E-02_JPRB,&
&4.9959E-02_JPRB,4.4876E-02_JPRB,5.0393E-02_JPRB/)
KAO( :, 3, 9,14) = (/&
&1.3535E-01_JPRB,1.1846E-01_JPRB,1.0188E-01_JPRB,8.8693E-02_JPRB,7.6184E-02_JPRB,6.4206E-02_JPRB,&
&5.5907E-02_JPRB,5.4085E-02_JPRB,6.1556E-02_JPRB/)
KAO( :, 4, 9,14) = (/&
&1.3444E-01_JPRB,1.1766E-01_JPRB,1.0208E-01_JPRB,9.0218E-02_JPRB,7.8130E-02_JPRB,6.8528E-02_JPRB,&
&6.2619E-02_JPRB,6.4323E-02_JPRB,7.3797E-02_JPRB/)
KAO( :, 5, 9,14) = (/&
&1.3348E-01_JPRB,1.1683E-01_JPRB,1.0242E-01_JPRB,9.1503E-02_JPRB,8.0977E-02_JPRB,7.3855E-02_JPRB,&
&6.9865E-02_JPRB,7.5417E-02_JPRB,8.6747E-02_JPRB/)
KAO( :, 1,10,14) = (/&
&1.4622E-01_JPRB,1.2796E-01_JPRB,1.0970E-01_JPRB,9.1694E-02_JPRB,7.6915E-02_JPRB,6.1594E-02_JPRB,&
&4.7802E-02_JPRB,3.6372E-02_JPRB,1.2782E-01_JPRB/)
KAO( :, 2,10,14) = (/&
&1.4558E-01_JPRB,1.2740E-01_JPRB,1.0923E-01_JPRB,9.3107E-02_JPRB,7.9235E-02_JPRB,6.4561E-02_JPRB,&
&5.2530E-02_JPRB,4.3432E-02_JPRB,1.2805E-01_JPRB/)
KAO( :, 3,10,14) = (/&
&1.4478E-01_JPRB,1.2670E-01_JPRB,1.0897E-01_JPRB,9.4925E-02_JPRB,8.1357E-02_JPRB,6.8532E-02_JPRB,&
&5.8051E-02_JPRB,5.1858E-02_JPRB,1.2910E-01_JPRB/)
KAO( :, 4,10,14) = (/&
&1.4390E-01_JPRB,1.2594E-01_JPRB,1.0930E-01_JPRB,9.6640E-02_JPRB,8.3903E-02_JPRB,7.3006E-02_JPRB,&
&6.4450E-02_JPRB,6.1593E-02_JPRB,1.3078E-01_JPRB/)
KAO( :, 5,10,14) = (/&
&1.4315E-01_JPRB,1.2528E-01_JPRB,1.1004E-01_JPRB,9.8357E-02_JPRB,8.7154E-02_JPRB,7.8009E-02_JPRB,&
&7.1120E-02_JPRB,7.2455E-02_JPRB,1.3316E-01_JPRB/)
KAO( :, 1,11,14) = (/&
&1.5395E-01_JPRB,1.3473E-01_JPRB,1.1550E-01_JPRB,9.7315E-02_JPRB,8.2228E-02_JPRB,6.6162E-02_JPRB,&
&5.2338E-02_JPRB,3.8889E-02_JPRB,2.0928E-01_JPRB/)
KAO( :, 2,11,14) = (/&
&1.5355E-01_JPRB,1.3437E-01_JPRB,1.1530E-01_JPRB,9.9444E-02_JPRB,8.4668E-02_JPRB,7.0074E-02_JPRB,&
&5.7545E-02_JPRB,4.5714E-02_JPRB,2.1031E-01_JPRB/)
KAO( :, 3,11,14) = (/&
&1.5306E-01_JPRB,1.3395E-01_JPRB,1.1569E-01_JPRB,1.0160E-01_JPRB,8.7341E-02_JPRB,7.4791E-02_JPRB,&
&6.3171E-02_JPRB,5.3818E-02_JPRB,2.0902E-01_JPRB/)
KAO( :, 4,11,14) = (/&
&1.5264E-01_JPRB,1.3359E-01_JPRB,1.1675E-01_JPRB,1.0361E-01_JPRB,9.0695E-02_JPRB,7.9958E-02_JPRB,&
&6.9362E-02_JPRB,6.3424E-02_JPRB,2.0832E-01_JPRB/)
KAO( :, 5,11,14) = (/&
&1.5211E-01_JPRB,1.3312E-01_JPRB,1.1800E-01_JPRB,1.0575E-01_JPRB,9.4915E-02_JPRB,8.5107E-02_JPRB,&
&7.5798E-02_JPRB,7.4229E-02_JPRB,2.0949E-01_JPRB/)
KAO( :, 1,12,14) = (/&
&1.6007E-01_JPRB,1.4008E-01_JPRB,1.2008E-01_JPRB,1.0232E-01_JPRB,8.6761E-02_JPRB,7.0740E-02_JPRB,&
&5.6718E-02_JPRB,4.1250E-02_JPRB,2.6518E-01_JPRB/)
KAO( :, 2,12,14) = (/&
&1.6020E-01_JPRB,1.4019E-01_JPRB,1.2063E-01_JPRB,1.0501E-01_JPRB,8.9744E-02_JPRB,7.5616E-02_JPRB,&
&6.2355E-02_JPRB,4.7922E-02_JPRB,2.6549E-01_JPRB/)
KAO( :, 3,12,14) = (/&
&1.6044E-01_JPRB,1.4040E-01_JPRB,1.2209E-01_JPRB,1.0775E-01_JPRB,9.3316E-02_JPRB,8.1050E-02_JPRB,&
&6.8087E-02_JPRB,5.5672E-02_JPRB,2.6354E-01_JPRB/)
KAO( :, 4,12,14) = (/&
&1.6037E-01_JPRB,1.4035E-01_JPRB,1.2384E-01_JPRB,1.1034E-01_JPRB,9.7597E-02_JPRB,8.6743E-02_JPRB,&
&7.4072E-02_JPRB,6.4868E-02_JPRB,2.6219E-01_JPRB/)
KAO( :, 5,12,14) = (/&
&1.6003E-01_JPRB,1.4017E-01_JPRB,1.2549E-01_JPRB,1.1310E-01_JPRB,1.0250E-01_JPRB,9.1994E-02_JPRB,&
&8.0439E-02_JPRB,7.5469E-02_JPRB,2.6239E-01_JPRB/)
KAO( :, 1,13,14) = (/&
&1.6469E-01_JPRB,1.4412E-01_JPRB,1.2368E-01_JPRB,1.0640E-01_JPRB,9.0617E-02_JPRB,7.5149E-02_JPRB,&
&6.0781E-02_JPRB,4.3348E-02_JPRB,2.6721E-01_JPRB/)
KAO( :, 2,13,14) = (/&
&1.6562E-01_JPRB,1.4493E-01_JPRB,1.2548E-01_JPRB,1.0990E-01_JPRB,9.4570E-02_JPRB,8.0925E-02_JPRB,&
&6.6783E-02_JPRB,4.9779E-02_JPRB,2.6700E-01_JPRB/)
KAO( :, 3,13,14) = (/&
&1.6629E-01_JPRB,1.4552E-01_JPRB,1.2768E-01_JPRB,1.1332E-01_JPRB,9.9317E-02_JPRB,8.6925E-02_JPRB,&
&7.2626E-02_JPRB,5.7255E-02_JPRB,2.6579E-01_JPRB/)
KAO( :, 4,13,14) = (/&
&1.6653E-01_JPRB,1.4581E-01_JPRB,1.2999E-01_JPRB,1.1666E-01_JPRB,1.0451E-01_JPRB,9.2915E-02_JPRB,&
&7.8534E-02_JPRB,6.6130E-02_JPRB,2.6675E-01_JPRB/)
KAO( :, 5,13,14) = (/&
&1.6684E-01_JPRB,1.4632E-01_JPRB,1.3221E-01_JPRB,1.2027E-01_JPRB,1.0991E-01_JPRB,9.8357E-02_JPRB,&
&8.4972E-02_JPRB,7.6473E-02_JPRB,2.6996E-01_JPRB/)
KAO( :, 1, 1,15) = (/&
&8.6335E-02_JPRB,7.5626E-02_JPRB,6.4917E-02_JPRB,5.5295E-02_JPRB,5.0812E-02_JPRB,5.9948E-02_JPRB,&
&7.1505E-02_JPRB,8.2180E-02_JPRB,9.1859E-02_JPRB/)
KAO( :, 2, 1,15) = (/&
&8.4567E-02_JPRB,7.4086E-02_JPRB,6.3604E-02_JPRB,5.5283E-02_JPRB,5.6490E-02_JPRB,6.9672E-02_JPRB,&
&8.3123E-02_JPRB,9.5602E-02_JPRB,1.0689E-01_JPRB/)
KAO( :, 3, 1,15) = (/&
&8.2946E-02_JPRB,7.2675E-02_JPRB,6.2405E-02_JPRB,5.5773E-02_JPRB,6.3940E-02_JPRB,7.9639E-02_JPRB,&
&9.5049E-02_JPRB,1.0933E-01_JPRB,1.2237E-01_JPRB/)
KAO( :, 4, 1,15) = (/&
&8.1353E-02_JPRB,7.1286E-02_JPRB,6.1452E-02_JPRB,5.8032E-02_JPRB,7.2168E-02_JPRB,8.9901E-02_JPRB,&
&1.0730E-01_JPRB,1.2343E-01_JPRB,1.3810E-01_JPRB/)
KAO( :, 5, 1,15) = (/&
&8.0306E-02_JPRB,7.0375E-02_JPRB,6.1401E-02_JPRB,6.2088E-02_JPRB,8.0744E-02_JPRB,1.0061E-01_JPRB,&
&1.2011E-01_JPRB,1.3812E-01_JPRB,1.5455E-01_JPRB/)
KAO( :, 1, 2,15) = (/&
&9.5589E-02_JPRB,8.3777E-02_JPRB,7.1976E-02_JPRB,6.1258E-02_JPRB,5.5368E-02_JPRB,6.4085E-02_JPRB,&
&7.6446E-02_JPRB,8.7825E-02_JPRB,9.9724E-02_JPRB/)
KAO( :, 2, 2,15) = (/&
&9.3570E-02_JPRB,8.1988E-02_JPRB,7.0421E-02_JPRB,6.1059E-02_JPRB,6.1189E-02_JPRB,7.4507E-02_JPRB,&
&8.8919E-02_JPRB,1.0224E-01_JPRB,1.1610E-01_JPRB/)
KAO( :, 3, 2,15) = (/&
&9.1829E-02_JPRB,8.0436E-02_JPRB,6.9070E-02_JPRB,6.1314E-02_JPRB,6.8582E-02_JPRB,8.5238E-02_JPRB,&
&1.0175E-01_JPRB,1.1706E-01_JPRB,1.3301E-01_JPRB/)
KAO( :, 4, 2,15) = (/&
&9.0487E-02_JPRB,7.9254E-02_JPRB,6.8526E-02_JPRB,6.4228E-02_JPRB,7.7434E-02_JPRB,9.6498E-02_JPRB,&
&1.1522E-01_JPRB,1.3267E-01_JPRB,1.5077E-01_JPRB/)
KAO( :, 5, 2,15) = (/&
&8.9669E-02_JPRB,7.8542E-02_JPRB,6.8954E-02_JPRB,6.8451E-02_JPRB,8.6910E-02_JPRB,1.0835E-01_JPRB,&
&1.2939E-01_JPRB,1.4902E-01_JPRB,1.6935E-01_JPRB/)
KAO( :, 1, 3,15) = (/&
&1.0676E-01_JPRB,9.3553E-02_JPRB,8.0347E-02_JPRB,6.7838E-02_JPRB,5.9827E-02_JPRB,6.6522E-02_JPRB,&
&7.9363E-02_JPRB,9.1189E-02_JPRB,1.0525E-01_JPRB/)
KAO( :, 2, 3,15) = (/&
&1.0446E-01_JPRB,9.1534E-02_JPRB,7.8612E-02_JPRB,6.7925E-02_JPRB,6.5040E-02_JPRB,7.7741E-02_JPRB,&
&9.2778E-02_JPRB,1.0667E-01_JPRB,1.2309E-01_JPRB/)
KAO( :, 3, 3,15) = (/&
&1.0249E-01_JPRB,8.9809E-02_JPRB,7.7136E-02_JPRB,6.8091E-02_JPRB,7.2454E-02_JPRB,8.9300E-02_JPRB,&
&1.0660E-01_JPRB,1.2265E-01_JPRB,1.4148E-01_JPRB/)
KAO( :, 4, 3,15) = (/&
&1.0145E-01_JPRB,8.8891E-02_JPRB,7.6929E-02_JPRB,7.0768E-02_JPRB,8.1305E-02_JPRB,1.0131E-01_JPRB,&
&1.2096E-01_JPRB,1.3918E-01_JPRB,1.6053E-01_JPRB/)
KAO( :, 5, 3,15) = (/&
&1.0070E-01_JPRB,8.8241E-02_JPRB,7.7594E-02_JPRB,7.4852E-02_JPRB,9.1339E-02_JPRB,1.1386E-01_JPRB,&
&1.3595E-01_JPRB,1.5652E-01_JPRB,1.8047E-01_JPRB/)
KAO( :, 1, 4,15) = (/&
&1.1948E-01_JPRB,1.0466E-01_JPRB,8.9846E-02_JPRB,7.5435E-02_JPRB,6.5653E-02_JPRB,6.8395E-02_JPRB,&
&8.1117E-02_JPRB,9.3286E-02_JPRB,1.0845E-01_JPRB/)
KAO( :, 2, 4,15) = (/&
&1.1744E-01_JPRB,1.0288E-01_JPRB,8.8326E-02_JPRB,7.6088E-02_JPRB,7.0000E-02_JPRB,8.0045E-02_JPRB,&
&9.5565E-02_JPRB,1.0996E-01_JPRB,1.2777E-01_JPRB/)
KAO( :, 3, 4,15) = (/&
&1.1572E-01_JPRB,1.0138E-01_JPRB,8.7035E-02_JPRB,7.6536E-02_JPRB,7.6949E-02_JPRB,9.2508E-02_JPRB,&
&1.1046E-01_JPRB,1.2718E-01_JPRB,1.4769E-01_JPRB/)
KAO( :, 4, 4,15) = (/&
&1.1457E-01_JPRB,1.0037E-01_JPRB,8.6743E-02_JPRB,7.8791E-02_JPRB,8.5479E-02_JPRB,1.0549E-01_JPRB,&
&1.2598E-01_JPRB,1.4506E-01_JPRB,1.6844E-01_JPRB/)
KAO( :, 5, 4,15) = (/&
&1.1371E-01_JPRB,9.9614E-02_JPRB,8.7543E-02_JPRB,8.2406E-02_JPRB,9.5523E-02_JPRB,1.1901E-01_JPRB,&
&1.4214E-01_JPRB,1.6372E-01_JPRB,1.9001E-01_JPRB/)
KAO( :, 1, 5,15) = (/&
&1.3435E-01_JPRB,1.1765E-01_JPRB,1.0095E-01_JPRB,8.4469E-02_JPRB,7.2853E-02_JPRB,7.1272E-02_JPRB,&
&8.1960E-02_JPRB,9.4385E-02_JPRB,1.0990E-01_JPRB/)
KAO( :, 2, 5,15) = (/&
&1.3249E-01_JPRB,1.1603E-01_JPRB,9.9565E-02_JPRB,8.5291E-02_JPRB,7.6670E-02_JPRB,8.2310E-02_JPRB,&
&9.7448E-02_JPRB,1.1228E-01_JPRB,1.3064E-01_JPRB/)
KAO( :, 3, 5,15) = (/&
&1.3078E-01_JPRB,1.1453E-01_JPRB,9.8289E-02_JPRB,8.6209E-02_JPRB,8.3093E-02_JPRB,9.5057E-02_JPRB,&
&1.1357E-01_JPRB,1.3082E-01_JPRB,1.5225E-01_JPRB/)
KAO( :, 4, 5,15) = (/&
&1.2949E-01_JPRB,1.1340E-01_JPRB,9.7892E-02_JPRB,8.8436E-02_JPRB,9.1112E-02_JPRB,1.0924E-01_JPRB,&
&1.3047E-01_JPRB,1.5034E-01_JPRB,1.7498E-01_JPRB/)
KAO( :, 5, 5,15) = (/&
&1.2852E-01_JPRB,1.1256E-01_JPRB,9.8533E-02_JPRB,9.1755E-02_JPRB,1.0068E-01_JPRB,1.2400E-01_JPRB,&
&1.4814E-01_JPRB,1.7069E-01_JPRB,1.9863E-01_JPRB/)
KAO( :, 1, 6,15) = (/&
&1.5076E-01_JPRB,1.3198E-01_JPRB,1.1320E-01_JPRB,9.4463E-02_JPRB,8.0666E-02_JPRB,7.5054E-02_JPRB,&
&8.0871E-02_JPRB,9.3264E-02_JPRB,1.0849E-01_JPRB/)
KAO( :, 2, 6,15) = (/&
&1.4906E-01_JPRB,1.3049E-01_JPRB,1.1193E-01_JPRB,9.5115E-02_JPRB,8.4634E-02_JPRB,8.5281E-02_JPRB,&
&9.7599E-02_JPRB,1.1257E-01_JPRB,1.3098E-01_JPRB/)
KAO( :, 3, 6,15) = (/&
&1.4751E-01_JPRB,1.2914E-01_JPRB,1.1077E-01_JPRB,9.6775E-02_JPRB,9.0721E-02_JPRB,9.7408E-02_JPRB,&
&1.1514E-01_JPRB,1.3281E-01_JPRB,1.5454E-01_JPRB/)
KAO( :, 4, 6,15) = (/&
&1.4640E-01_JPRB,1.2818E-01_JPRB,1.1040E-01_JPRB,9.8990E-02_JPRB,9.8328E-02_JPRB,1.1180E-01_JPRB,&
&1.3358E-01_JPRB,1.5404E-01_JPRB,1.7929E-01_JPRB/)
KAO( :, 5, 6,15) = (/&
&1.4534E-01_JPRB,1.2726E-01_JPRB,1.1100E-01_JPRB,1.0247E-01_JPRB,1.0712E-01_JPRB,1.2780E-01_JPRB,&
&1.5274E-01_JPRB,1.7614E-01_JPRB,2.0503E-01_JPRB/)
KAO( :, 1, 7,15) = (/&
&1.7017E-01_JPRB,1.4895E-01_JPRB,1.2773E-01_JPRB,1.0651E-01_JPRB,8.8726E-02_JPRB,8.0014E-02_JPRB,&
&7.9958E-02_JPRB,9.0777E-02_JPRB,1.0558E-01_JPRB/)
KAO( :, 2, 7,15) = (/&
&1.6840E-01_JPRB,1.4740E-01_JPRB,1.2641E-01_JPRB,1.0633E-01_JPRB,9.3561E-02_JPRB,8.9399E-02_JPRB,&
&9.6654E-02_JPRB,1.1154E-01_JPRB,1.2974E-01_JPRB/)
KAO( :, 3, 7,15) = (/&
&1.6683E-01_JPRB,1.4603E-01_JPRB,1.2523E-01_JPRB,1.0816E-01_JPRB,9.9523E-02_JPRB,1.0085E-01_JPRB,&
&1.1565E-01_JPRB,1.3349E-01_JPRB,1.5523E-01_JPRB/)
KAO( :, 4, 7,15) = (/&
&1.6579E-01_JPRB,1.4512E-01_JPRB,1.2467E-01_JPRB,1.1069E-01_JPRB,1.0674E-01_JPRB,1.1452E-01_JPRB,&
&1.3558E-01_JPRB,1.5645E-01_JPRB,1.8200E-01_JPRB/)
KAO( :, 5, 7,15) = (/&
&1.6467E-01_JPRB,1.4415E-01_JPRB,1.2512E-01_JPRB,1.1428E-01_JPRB,1.1515E-01_JPRB,1.3096E-01_JPRB,&
&1.5653E-01_JPRB,1.8061E-01_JPRB,2.1020E-01_JPRB/)
KAO( :, 1, 8,15) = (/&
&1.9300E-01_JPRB,1.6891E-01_JPRB,1.4482E-01_JPRB,1.2074E-01_JPRB,9.8428E-02_JPRB,8.6453E-02_JPRB,&
&8.0104E-02_JPRB,8.7414E-02_JPRB,1.0158E-01_JPRB/)
KAO( :, 2, 8,15) = (/&
&1.9118E-01_JPRB,1.6732E-01_JPRB,1.4346E-01_JPRB,1.1993E-01_JPRB,1.0330E-01_JPRB,9.4785E-02_JPRB,&
&9.5939E-02_JPRB,1.0927E-01_JPRB,1.2693E-01_JPRB/)
KAO( :, 3, 8,15) = (/&
&1.8966E-01_JPRB,1.6599E-01_JPRB,1.4233E-01_JPRB,1.2111E-01_JPRB,1.0944E-01_JPRB,1.0556E-01_JPRB,&
&1.1490E-01_JPRB,1.3272E-01_JPRB,1.5419E-01_JPRB/)
KAO( :, 4, 8,15) = (/&
&1.8827E-01_JPRB,1.6478E-01_JPRB,1.4129E-01_JPRB,1.2410E-01_JPRB,1.1628E-01_JPRB,1.1877E-01_JPRB,&
&1.3648E-01_JPRB,1.5764E-01_JPRB,1.8319E-01_JPRB/)
KAO( :, 5, 8,15) = (/&
&1.8700E-01_JPRB,1.6367E-01_JPRB,1.4137E-01_JPRB,1.2760E-01_JPRB,1.2425E-01_JPRB,1.3451E-01_JPRB,&
&1.5950E-01_JPRB,1.8417E-01_JPRB,2.1419E-01_JPRB/)
KAO( :, 1, 9,15) = (/&
&2.1903E-01_JPRB,1.9168E-01_JPRB,1.6432E-01_JPRB,1.3697E-01_JPRB,1.1022E-01_JPRB,9.3381E-02_JPRB,&
&8.1173E-02_JPRB,8.3378E-02_JPRB,9.6854E-02_JPRB/)
KAO( :, 2, 9,15) = (/&
&2.1750E-01_JPRB,1.9034E-01_JPRB,1.6318E-01_JPRB,1.3602E-01_JPRB,1.1431E-01_JPRB,1.0171E-01_JPRB,&
&9.6008E-02_JPRB,1.0601E-01_JPRB,1.2308E-01_JPRB/)
KAO( :, 3, 9,15) = (/&
&2.1621E-01_JPRB,1.8921E-01_JPRB,1.6222E-01_JPRB,1.3665E-01_JPRB,1.2052E-01_JPRB,1.1120E-01_JPRB,&
&1.1434E-01_JPRB,1.3077E-01_JPRB,1.5182E-01_JPRB/)
KAO( :, 4, 9,15) = (/&
&2.1461E-01_JPRB,1.8782E-01_JPRB,1.6103E-01_JPRB,1.3944E-01_JPRB,1.2758E-01_JPRB,1.2410E-01_JPRB,&
&1.3607E-01_JPRB,1.5728E-01_JPRB,1.8262E-01_JPRB/)
KAO( :, 5, 9,15) = (/&
&2.1295E-01_JPRB,1.8637E-01_JPRB,1.6039E-01_JPRB,1.4274E-01_JPRB,1.3480E-01_JPRB,1.3933E-01_JPRB,&
&1.6084E-01_JPRB,1.8591E-01_JPRB,2.1587E-01_JPRB/)
KAO( :, 1,10,15) = (/&
&2.4831E-01_JPRB,2.1729E-01_JPRB,1.8627E-01_JPRB,1.5526E-01_JPRB,1.2434E-01_JPRB,1.0185E-01_JPRB,&
&8.4815E-02_JPRB,8.0841E-02_JPRB,1.7532E-01_JPRB/)
KAO( :, 2,10,15) = (/&
&2.4704E-01_JPRB,2.1618E-01_JPRB,1.8532E-01_JPRB,1.5447E-01_JPRB,1.2750E-01_JPRB,1.1098E-01_JPRB,&
&9.8299E-02_JPRB,1.0410E-01_JPRB,1.7367E-01_JPRB/)
KAO( :, 3,10,15) = (/&
&2.4585E-01_JPRB,2.1514E-01_JPRB,1.8444E-01_JPRB,1.5466E-01_JPRB,1.3408E-01_JPRB,1.1953E-01_JPRB,&
&1.1633E-01_JPRB,1.3023E-01_JPRB,1.7996E-01_JPRB/)
KAO( :, 4,10,15) = (/&
&2.4402E-01_JPRB,2.1354E-01_JPRB,1.8307E-01_JPRB,1.5695E-01_JPRB,1.4115E-01_JPRB,1.3126E-01_JPRB,&
&1.3793E-01_JPRB,1.5846E-01_JPRB,1.9548E-01_JPRB/)
KAO( :, 5,10,15) = (/&
&2.4208E-01_JPRB,2.1185E-01_JPRB,1.8198E-01_JPRB,1.6040E-01_JPRB,1.4820E-01_JPRB,1.4650E-01_JPRB,&
&1.6334E-01_JPRB,1.8884E-01_JPRB,2.2082E-01_JPRB/)
KAO( :, 1,11,15) = (/&
&2.8046E-01_JPRB,2.4542E-01_JPRB,2.1039E-01_JPRB,1.7535E-01_JPRB,1.4072E-01_JPRB,1.1602E-01_JPRB,&
&9.4756E-02_JPRB,8.8842E-02_JPRB,3.0507E-01_JPRB/)
KAO( :, 2,11,15) = (/&
&2.7918E-01_JPRB,2.4430E-01_JPRB,2.0943E-01_JPRB,1.7456E-01_JPRB,1.4537E-01_JPRB,1.2533E-01_JPRB,&
&1.0891E-01_JPRB,1.1392E-01_JPRB,2.9566E-01_JPRB/)
KAO( :, 3,11,15) = (/&
&2.7735E-01_JPRB,2.4270E-01_JPRB,2.0805E-01_JPRB,1.7500E-01_JPRB,1.5257E-01_JPRB,1.3417E-01_JPRB,&
&1.2847E-01_JPRB,1.4223E-01_JPRB,2.9322E-01_JPRB/)
KAO( :, 4,11,15) = (/&
&2.7527E-01_JPRB,2.4088E-01_JPRB,2.0649E-01_JPRB,1.7781E-01_JPRB,1.5979E-01_JPRB,1.4614E-01_JPRB,&
&1.5179E-01_JPRB,1.7334E-01_JPRB,2.9538E-01_JPRB/)
KAO( :, 5,11,15) = (/&
&2.7287E-01_JPRB,2.3878E-01_JPRB,2.0537E-01_JPRB,1.8183E-01_JPRB,1.6671E-01_JPRB,1.6236E-01_JPRB,&
&1.7904E-01_JPRB,2.0699E-01_JPRB,3.0432E-01_JPRB/)
KAO( :, 1,12,15) = (/&
&3.1597E-01_JPRB,2.7649E-01_JPRB,2.3701E-01_JPRB,1.9754E-01_JPRB,1.5924E-01_JPRB,1.3168E-01_JPRB,&
&1.0585E-01_JPRB,9.7375E-02_JPRB,4.0358E-01_JPRB/)
KAO( :, 2,12,15) = (/&
&3.1432E-01_JPRB,2.7505E-01_JPRB,2.3578E-01_JPRB,1.9654E-01_JPRB,1.6498E-01_JPRB,1.4094E-01_JPRB,&
&1.2051E-01_JPRB,1.2392E-01_JPRB,3.9336E-01_JPRB/)
KAO( :, 3,12,15) = (/&
&3.1171E-01_JPRB,2.7277E-01_JPRB,2.3383E-01_JPRB,1.9721E-01_JPRB,1.7246E-01_JPRB,1.5023E-01_JPRB,&
&1.4122E-01_JPRB,1.5462E-01_JPRB,3.9393E-01_JPRB/)
KAO( :, 4,12,15) = (/&
&3.0880E-01_JPRB,2.7022E-01_JPRB,2.3164E-01_JPRB,2.0058E-01_JPRB,1.7964E-01_JPRB,1.6232E-01_JPRB,&
&1.6619E-01_JPRB,1.8839E-01_JPRB,3.9596E-01_JPRB/)
KAO( :, 5,12,15) = (/&
&3.0525E-01_JPRB,2.6711E-01_JPRB,2.3006E-01_JPRB,2.0488E-01_JPRB,1.8690E-01_JPRB,1.7940E-01_JPRB,&
&1.9528E-01_JPRB,2.2516E-01_JPRB,4.0079E-01_JPRB/)
KAO( :, 1,13,15) = (/&
&3.5411E-01_JPRB,3.0986E-01_JPRB,2.6562E-01_JPRB,2.2137E-01_JPRB,1.7962E-01_JPRB,1.4841E-01_JPRB,&
&1.1804E-01_JPRB,1.0632E-01_JPRB,4.1876E-01_JPRB/)
KAO( :, 2,13,15) = (/&
&3.5164E-01_JPRB,3.0771E-01_JPRB,2.6377E-01_JPRB,2.2010E-01_JPRB,1.8598E-01_JPRB,1.5750E-01_JPRB,&
&1.3321E-01_JPRB,1.3429E-01_JPRB,4.1787E-01_JPRB/)
KAO( :, 3,13,15) = (/&
&3.4820E-01_JPRB,3.0469E-01_JPRB,2.6119E-01_JPRB,2.2112E-01_JPRB,1.9338E-01_JPRB,1.6728E-01_JPRB,&
&1.5455E-01_JPRB,1.6711E-01_JPRB,4.2377E-01_JPRB/)
KAO( :, 4,13,15) = (/&
&3.4395E-01_JPRB,3.0097E-01_JPRB,2.5812E-01_JPRB,2.2469E-01_JPRB,2.0035E-01_JPRB,1.7975E-01_JPRB,&
&1.8098E-01_JPRB,2.0337E-01_JPRB,4.2831E-01_JPRB/)
KAO( :, 5,13,15) = (/&
&3.3896E-01_JPRB,2.9661E-01_JPRB,2.5572E-01_JPRB,2.2897E-01_JPRB,2.0809E-01_JPRB,1.9725E-01_JPRB,&
&2.1144E-01_JPRB,2.4250E-01_JPRB,4.3491E-01_JPRB/)
KAO( :, 1, 1,16) = (/&
&9.7171E-02_JPRB,8.5148E-02_JPRB,7.3125E-02_JPRB,6.1102E-02_JPRB,7.6485E-02_JPRB,9.5172E-02_JPRB,&
&1.1335E-01_JPRB,1.2955E-01_JPRB,1.4355E-01_JPRB/)
KAO( :, 2, 1,16) = (/&
&9.4236E-02_JPRB,8.2602E-02_JPRB,7.0968E-02_JPRB,6.8035E-02_JPRB,9.0374E-02_JPRB,1.1244E-01_JPRB,&
&1.3393E-01_JPRB,1.5311E-01_JPRB,1.6974E-01_JPRB/)
KAO( :, 3, 1,16) = (/&
&9.1543E-02_JPRB,8.0273E-02_JPRB,6.9003E-02_JPRB,7.8791E-02_JPRB,1.0469E-01_JPRB,1.3025E-01_JPRB,&
&1.5519E-01_JPRB,1.7738E-01_JPRB,1.9670E-01_JPRB/)
KAO( :, 4, 1,16) = (/&
&8.8644E-02_JPRB,7.7768E-02_JPRB,6.6893E-02_JPRB,8.9756E-02_JPRB,1.1926E-01_JPRB,1.4844E-01_JPRB,&
&1.7683E-01_JPRB,2.0215E-01_JPRB,2.2416E-01_JPRB/)
KAO( :, 5, 1,16) = (/&
&8.6144E-02_JPRB,7.5584E-02_JPRB,6.7875E-02_JPRB,1.0078E-01_JPRB,1.3394E-01_JPRB,1.6670E-01_JPRB,&
&1.9859E-01_JPRB,2.2714E-01_JPRB,2.5185E-01_JPRB/)
KAO( :, 1, 2,16) = (/&
&1.1053E-01_JPRB,9.6812E-02_JPRB,8.3097E-02_JPRB,6.9381E-02_JPRB,8.5062E-02_JPRB,1.0587E-01_JPRB,&
&1.2610E-01_JPRB,1.4420E-01_JPRB,1.6344E-01_JPRB/)
KAO( :, 2, 2,16) = (/&
&1.0742E-01_JPRB,9.4110E-02_JPRB,8.0803E-02_JPRB,7.6274E-02_JPRB,1.0134E-01_JPRB,1.2610E-01_JPRB,&
&1.5024E-01_JPRB,1.7183E-01_JPRB,1.9478E-01_JPRB/)
KAO( :, 3, 2,16) = (/&
&1.0452E-01_JPRB,9.1604E-02_JPRB,7.8683E-02_JPRB,8.8937E-02_JPRB,1.1819E-01_JPRB,1.4709E-01_JPRB,&
&1.7526E-01_JPRB,2.0044E-01_JPRB,2.2725E-01_JPRB/)
KAO( :, 4, 2,16) = (/&
&1.0156E-01_JPRB,8.9034E-02_JPRB,7.6513E-02_JPRB,1.0188E-01_JPRB,1.3537E-01_JPRB,1.6848E-01_JPRB,&
&2.0078E-01_JPRB,2.2973E-01_JPRB,2.6038E-01_JPRB/)
KAO( :, 5, 2,16) = (/&
&9.9221E-02_JPRB,8.6974E-02_JPRB,7.8015E-02_JPRB,1.1491E-01_JPRB,1.5271E-01_JPRB,1.9010E-01_JPRB,&
&2.2653E-01_JPRB,2.5922E-01_JPRB,2.9391E-01_JPRB/)
KAO( :, 1, 3,16) = (/&
&1.2741E-01_JPRB,1.1157E-01_JPRB,9.5716E-02_JPRB,7.9867E-02_JPRB,9.0261E-02_JPRB,1.1233E-01_JPRB,&
&1.3379E-01_JPRB,1.5315E-01_JPRB,1.7733E-01_JPRB/)
KAO( :, 2, 3,16) = (/&
&1.2407E-01_JPRB,1.0865E-01_JPRB,9.3240E-02_JPRB,8.3066E-02_JPRB,1.0895E-01_JPRB,1.3559E-01_JPRB,&
&1.6159E-01_JPRB,1.8497E-01_JPRB,2.1412E-01_JPRB/)
KAO( :, 3, 3,16) = (/&
&1.2077E-01_JPRB,1.0579E-01_JPRB,9.0806E-02_JPRB,9.6664E-02_JPRB,1.2848E-01_JPRB,1.5988E-01_JPRB,&
&1.9057E-01_JPRB,2.1812E-01_JPRB,2.5248E-01_JPRB/)
KAO( :, 4, 3,16) = (/&
&1.1796E-01_JPRB,1.0334E-01_JPRB,8.8711E-02_JPRB,1.1167E-01_JPRB,1.4847E-01_JPRB,1.8483E-01_JPRB,&
&2.2029E-01_JPRB,2.5232E-01_JPRB,2.9201E-01_JPRB/)
KAO( :, 5, 3,16) = (/&
&1.1579E-01_JPRB,1.0144E-01_JPRB,8.8938E-02_JPRB,1.2695E-01_JPRB,1.6868E-01_JPRB,2.1009E-01_JPRB,&
&2.5050E-01_JPRB,2.8682E-01_JPRB,3.3195E-01_JPRB/)
KAO( :, 1, 4,16) = (/&
&1.4795E-01_JPRB,1.2951E-01_JPRB,1.1108E-01_JPRB,9.2642E-02_JPRB,9.3362E-02_JPRB,1.1620E-01_JPRB,&
&1.3849E-01_JPRB,1.5859E-01_JPRB,1.8531E-01_JPRB/)
KAO( :, 2, 4,16) = (/&
&1.4437E-01_JPRB,1.2639E-01_JPRB,1.0842E-01_JPRB,9.2423E-02_JPRB,1.1442E-01_JPRB,1.4252E-01_JPRB,&
&1.6987E-01_JPRB,1.9459E-01_JPRB,2.2738E-01_JPRB/)
KAO( :, 3, 4,16) = (/&
&1.4082E-01_JPRB,1.2330E-01_JPRB,1.0578E-01_JPRB,1.0327E-01_JPRB,1.3669E-01_JPRB,1.7021E-01_JPRB,&
&2.0291E-01_JPRB,2.3254E-01_JPRB,2.7168E-01_JPRB/)
KAO( :, 4, 4,16) = (/&
&1.3812E-01_JPRB,1.2094E-01_JPRB,1.0376E-01_JPRB,1.2016E-01_JPRB,1.5971E-01_JPRB,1.9884E-01_JPRB,&
&2.3712E-01_JPRB,2.7173E-01_JPRB,3.1737E-01_JPRB/)
KAO( :, 5, 4,16) = (/&
&1.3617E-01_JPRB,1.1924E-01_JPRB,1.0266E-01_JPRB,1.3775E-01_JPRB,1.8312E-01_JPRB,2.2801E-01_JPRB,&
&2.7185E-01_JPRB,3.1180E-01_JPRB,3.6388E-01_JPRB/)
KAO( :, 1, 5,16) = (/&
&1.7254E-01_JPRB,1.5104E-01_JPRB,1.2954E-01_JPRB,1.0804E-01_JPRB,9.7033E-02_JPRB,1.1821E-01_JPRB,&
&1.4096E-01_JPRB,1.6165E-01_JPRB,1.8940E-01_JPRB/)
KAO( :, 2, 5,16) = (/&
&1.6864E-01_JPRB,1.4763E-01_JPRB,1.2663E-01_JPRB,1.0583E-01_JPRB,1.1845E-01_JPRB,1.4755E-01_JPRB,&
&1.7593E-01_JPRB,2.0174E-01_JPRB,2.3625E-01_JPRB/)
KAO( :, 3, 5,16) = (/&
&1.6515E-01_JPRB,1.4456E-01_JPRB,1.2397E-01_JPRB,1.1290E-01_JPRB,1.4346E-01_JPRB,1.7861E-01_JPRB,&
&2.1302E-01_JPRB,2.4445E-01_JPRB,2.8621E-01_JPRB/)
KAO( :, 4, 5,16) = (/&
&1.6266E-01_JPRB,1.4239E-01_JPRB,1.2212E-01_JPRB,1.2793E-01_JPRB,1.6939E-01_JPRB,2.1102E-01_JPRB,&
&2.5177E-01_JPRB,2.8892E-01_JPRB,3.3809E-01_JPRB/)
KAO( :, 5, 5,16) = (/&
&1.6070E-01_JPRB,1.4068E-01_JPRB,1.2066E-01_JPRB,1.4743E-01_JPRB,1.9603E-01_JPRB,2.4421E-01_JPRB,&
&2.9142E-01_JPRB,3.3457E-01_JPRB,3.9133E-01_JPRB/)
KAO( :, 1, 6,16) = (/&
&2.0388E-01_JPRB,1.7849E-01_JPRB,1.5310E-01_JPRB,1.2771E-01_JPRB,1.0526E-01_JPRB,1.1860E-01_JPRB,&
&1.4142E-01_JPRB,1.6203E-01_JPRB,1.9043E-01_JPRB/)
KAO( :, 2, 6,16) = (/&
&1.9953E-01_JPRB,1.7470E-01_JPRB,1.4986E-01_JPRB,1.2501E-01_JPRB,1.2166E-01_JPRB,1.5016E-01_JPRB,&
&1.7907E-01_JPRB,2.0547E-01_JPRB,2.4111E-01_JPRB/)
KAO( :, 3, 6,16) = (/&
&1.9494E-01_JPRB,1.7068E-01_JPRB,1.4642E-01_JPRB,1.2626E-01_JPRB,1.4789E-01_JPRB,1.8422E-01_JPRB,&
&2.1980E-01_JPRB,2.5220E-01_JPRB,2.9578E-01_JPRB/)
KAO( :, 4, 6,16) = (/&
&1.9206E-01_JPRB,1.6810E-01_JPRB,1.4414E-01_JPRB,1.3841E-01_JPRB,1.7663E-01_JPRB,2.1999E-01_JPRB,&
&2.6255E-01_JPRB,3.0157E-01_JPRB,3.5331E-01_JPRB/)
KAO( :, 5, 6,16) = (/&
&1.9005E-01_JPRB,1.6635E-01_JPRB,1.4264E-01_JPRB,1.5606E-01_JPRB,2.0643E-01_JPRB,2.5713E-01_JPRB,&
&3.0687E-01_JPRB,3.5252E-01_JPRB,4.1278E-01_JPRB/)
KAO( :, 1, 7,16) = (/&
&2.4312E-01_JPRB,2.1282E-01_JPRB,1.8252E-01_JPRB,1.5222E-01_JPRB,1.2192E-01_JPRB,1.1888E-01_JPRB,&
&1.4174E-01_JPRB,1.6248E-01_JPRB,1.9115E-01_JPRB/)
KAO( :, 2, 7,16) = (/&
&2.3797E-01_JPRB,2.0832E-01_JPRB,1.7867E-01_JPRB,1.4904E-01_JPRB,1.2994E-01_JPRB,1.5302E-01_JPRB,&
&1.8249E-01_JPRB,2.0929E-01_JPRB,2.4599E-01_JPRB/)
KAO( :, 3, 7,16) = (/&
&2.3255E-01_JPRB,2.0359E-01_JPRB,1.7463E-01_JPRB,1.4575E-01_JPRB,1.5275E-01_JPRB,1.9023E-01_JPRB,&
&2.2691E-01_JPRB,2.6041E-01_JPRB,3.0584E-01_JPRB/)
KAO( :, 4, 7,16) = (/&
&2.2807E-01_JPRB,1.9965E-01_JPRB,1.7122E-01_JPRB,1.5317E-01_JPRB,1.8432E-01_JPRB,2.2969E-01_JPRB,&
&2.7402E-01_JPRB,3.1471E-01_JPRB,3.6920E-01_JPRB/)
KAO( :, 5, 7,16) = (/&
&2.2498E-01_JPRB,1.9692E-01_JPRB,1.6887E-01_JPRB,1.6865E-01_JPRB,2.1725E-01_JPRB,2.7068E-01_JPRB,&
&3.2308E-01_JPRB,3.7116E-01_JPRB,4.3516E-01_JPRB/)
KAO( :, 1, 8,16) = (/&
&2.9068E-01_JPRB,2.5442E-01_JPRB,2.1816E-01_JPRB,1.8190E-01_JPRB,1.4564E-01_JPRB,1.2041E-01_JPRB,&
&1.4177E-01_JPRB,1.6257E-01_JPRB,1.9124E-01_JPRB/)
KAO( :, 2, 8,16) = (/&
&2.8457E-01_JPRB,2.4908E-01_JPRB,2.1359E-01_JPRB,1.7807E-01_JPRB,1.4515E-01_JPRB,1.5579E-01_JPRB,&
&1.8584E-01_JPRB,2.1331E-01_JPRB,2.5071E-01_JPRB/)
KAO( :, 3, 8,16) = (/&
&2.7790E-01_JPRB,2.4325E-01_JPRB,2.0861E-01_JPRB,1.7396E-01_JPRB,1.6105E-01_JPRB,1.9656E-01_JPRB,&
&2.3447E-01_JPRB,2.6926E-01_JPRB,3.1620E-01_JPRB/)
KAO( :, 4, 8,16) = (/&
&2.7204E-01_JPRB,2.3812E-01_JPRB,2.0420E-01_JPRB,1.7391E-01_JPRB,1.9266E-01_JPRB,2.4008E-01_JPRB,&
&2.8658E-01_JPRB,3.2922E-01_JPRB,3.8634E-01_JPRB/)
KAO( :, 5, 8,16) = (/&
&2.6773E-01_JPRB,2.3434E-01_JPRB,2.0095E-01_JPRB,1.8582E-01_JPRB,2.2918E-01_JPRB,2.8567E-01_JPRB,&
&3.4098E-01_JPRB,3.9189E-01_JPRB,4.5943E-01_JPRB/)
KAO( :, 1, 9,16) = (/&
&3.4732E-01_JPRB,3.0397E-01_JPRB,2.6061E-01_JPRB,2.1726E-01_JPRB,1.7390E-01_JPRB,1.3271E-01_JPRB,&
&1.4035E-01_JPRB,1.6109E-01_JPRB,1.8937E-01_JPRB/)
KAO( :, 2, 9,16) = (/&
&3.3981E-01_JPRB,2.9740E-01_JPRB,2.5499E-01_JPRB,2.1257E-01_JPRB,1.7017E-01_JPRB,1.5746E-01_JPRB,&
&1.8783E-01_JPRB,2.1574E-01_JPRB,2.5330E-01_JPRB/)
KAO( :, 3, 9,16) = (/&
&3.3164E-01_JPRB,2.9026E-01_JPRB,2.4888E-01_JPRB,2.0750E-01_JPRB,1.7718E-01_JPRB,2.0179E-01_JPRB,&
&2.4086E-01_JPRB,2.7675E-01_JPRB,3.2472E-01_JPRB/)
KAO( :, 4, 9,16) = (/&
&3.2434E-01_JPRB,2.8387E-01_JPRB,2.4340E-01_JPRB,2.0299E-01_JPRB,2.0166E-01_JPRB,2.4979E-01_JPRB,&
&2.9816E-01_JPRB,3.4279E-01_JPRB,4.0187E-01_JPRB/)
KAO( :, 5, 9,16) = (/&
&3.1856E-01_JPRB,2.7881E-01_JPRB,2.3907E-01_JPRB,2.0909E-01_JPRB,2.4079E-01_JPRB,3.0025E-01_JPRB,&
&3.5852E-01_JPRB,4.1238E-01_JPRB,4.8294E-01_JPRB/)
KAO( :, 1,10,16) = (/&
&4.1296E-01_JPRB,3.6138E-01_JPRB,3.0981E-01_JPRB,2.5823E-01_JPRB,2.0667E-01_JPRB,1.5510E-01_JPRB,&
&1.4272E-01_JPRB,1.6382E-01_JPRB,1.9375E-01_JPRB/)
KAO( :, 2,10,16) = (/&
&4.0355E-01_JPRB,3.5316E-01_JPRB,3.0277E-01_JPRB,2.5237E-01_JPRB,2.0198E-01_JPRB,1.6688E-01_JPRB,&
&1.9258E-01_JPRB,2.2130E-01_JPRB,2.5965E-01_JPRB/)
KAO( :, 3,10,16) = (/&
&3.9334E-01_JPRB,3.4423E-01_JPRB,2.9512E-01_JPRB,2.4601E-01_JPRB,2.0198E-01_JPRB,2.0922E-01_JPRB,&
&2.4978E-01_JPRB,2.8734E-01_JPRB,3.3649E-01_JPRB/)
KAO( :, 4,10,16) = (/&
&3.8468E-01_JPRB,3.3665E-01_JPRB,2.8862E-01_JPRB,2.4064E-01_JPRB,2.1892E-01_JPRB,2.6187E-01_JPRB,&
&3.1276E-01_JPRB,3.6003E-01_JPRB,4.2127E-01_JPRB/)
KAO( :, 5,10,16) = (/&
&3.7732E-01_JPRB,3.3021E-01_JPRB,2.8310E-01_JPRB,2.4052E-01_JPRB,2.5525E-01_JPRB,3.1772E-01_JPRB,&
&3.7953E-01_JPRB,4.3694E-01_JPRB,5.1089E-01_JPRB/)
KAO( :, 1,11,16) = (/&
&4.8302E-01_JPRB,4.2268E-01_JPRB,3.6234E-01_JPRB,3.0200E-01_JPRB,2.4165E-01_JPRB,1.8151E-01_JPRB,&
&1.6877E-01_JPRB,1.9388E-01_JPRB,3.3421E-01_JPRB/)
KAO( :, 2,11,16) = (/&
&4.7050E-01_JPRB,4.1173E-01_JPRB,3.5296E-01_JPRB,2.9420E-01_JPRB,2.3543E-01_JPRB,1.9660E-01_JPRB,&
&2.2543E-01_JPRB,2.5921E-01_JPRB,3.3179E-01_JPRB/)
KAO( :, 3,11,16) = (/&
&4.5896E-01_JPRB,4.0163E-01_JPRB,3.4431E-01_JPRB,2.8698E-01_JPRB,2.3627E-01_JPRB,2.4234E-01_JPRB,&
&2.8945E-01_JPRB,3.3305E-01_JPRB,3.8992E-01_JPRB/)
KAO( :, 4,11,16) = (/&
&4.4916E-01_JPRB,3.9306E-01_JPRB,3.3696E-01_JPRB,2.8088E-01_JPRB,2.5515E-01_JPRB,3.0073E-01_JPRB,&
&3.5922E-01_JPRB,4.1373E-01_JPRB,4.8361E-01_JPRB/)
KAO( :, 5,11,16) = (/&
&4.3990E-01_JPRB,3.8496E-01_JPRB,3.3001E-01_JPRB,2.8070E-01_JPRB,2.9324E-01_JPRB,3.6251E-01_JPRB,&
&4.3320E-01_JPRB,4.9939E-01_JPRB,5.8288E-01_JPRB/)
KAO( :, 1,12,16) = (/&
&5.5949E-01_JPRB,4.8959E-01_JPRB,4.1968E-01_JPRB,3.4978E-01_JPRB,2.7990E-01_JPRB,2.1117E-01_JPRB,&
&1.9846E-01_JPRB,2.2823E-01_JPRB,4.6485E-01_JPRB/)
KAO( :, 2,12,16) = (/&
&5.4466E-01_JPRB,4.7661E-01_JPRB,4.0856E-01_JPRB,3.4053E-01_JPRB,2.7248E-01_JPRB,2.3023E-01_JPRB,&
&2.6289E-01_JPRB,3.0262E-01_JPRB,4.5843E-01_JPRB/)
KAO( :, 3,12,16) = (/&
&5.3198E-01_JPRB,4.6551E-01_JPRB,3.9905E-01_JPRB,3.3259E-01_JPRB,2.7378E-01_JPRB,2.8016E-01_JPRB,&
&3.3471E-01_JPRB,3.8547E-01_JPRB,4.7894E-01_JPRB/)
KAO( :, 4,12,16) = (/&
&5.2001E-01_JPRB,4.5505E-01_JPRB,3.9008E-01_JPRB,3.2510E-01_JPRB,2.9551E-01_JPRB,3.4473E-01_JPRB,&
&4.1193E-01_JPRB,4.7482E-01_JPRB,5.5483E-01_JPRB/)
KAO( :, 5,12,16) = (/&
&5.0915E-01_JPRB,4.4554E-01_JPRB,3.8193E-01_JPRB,3.2460E-01_JPRB,3.3469E-01_JPRB,4.1244E-01_JPRB,&
&4.9294E-01_JPRB,5.6854E-01_JPRB,6.6308E-01_JPRB/)
KAO( :, 1,13,16) = (/&
&6.4209E-01_JPRB,5.6185E-01_JPRB,4.8161E-01_JPRB,4.0138E-01_JPRB,3.2111E-01_JPRB,2.4405E-01_JPRB,&
&2.3126E-01_JPRB,2.6629E-01_JPRB,5.1031E-01_JPRB/)
KAO( :, 2,13,16) = (/&
&6.2605E-01_JPRB,5.4782E-01_JPRB,4.6959E-01_JPRB,3.9135E-01_JPRB,3.1312E-01_JPRB,2.6752E-01_JPRB,&
&3.0417E-01_JPRB,3.5056E-01_JPRB,5.0701E-01_JPRB/)
KAO( :, 3,13,16) = (/&
&6.1094E-01_JPRB,5.3460E-01_JPRB,4.5826E-01_JPRB,3.8192E-01_JPRB,3.1501E-01_JPRB,3.2162E-01_JPRB,&
&3.8441E-01_JPRB,4.4331E-01_JPRB,5.4185E-01_JPRB/)
KAO( :, 4,13,16) = (/&
&5.9718E-01_JPRB,5.2256E-01_JPRB,4.4794E-01_JPRB,3.7327E-01_JPRB,3.3928E-01_JPRB,3.9296E-01_JPRB,&
&4.6976E-01_JPRB,5.4198E-01_JPRB,6.3180E-01_JPRB/)
KAO( :, 5,13,16) = (/&
&5.8381E-01_JPRB,5.1086E-01_JPRB,4.3791E-01_JPRB,3.7153E-01_JPRB,3.7939E-01_JPRB,4.6700E-01_JPRB,&
&5.5841E-01_JPRB,6.4458E-01_JPRB,7.5053E-01_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB16_A1
