!OCL SCALAR
SUBROUTINE RRTM_KGB16_00

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 16:  2600-3000 cm-1 (low - H2O,CH4; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO16, ONLY : KAO     ,SELFREFO   ,FRACREFAO
USE YOERRTA16, ONLY : STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE
STRRAT = 830.411_JPRB

!     ------------------------------------------------------------------

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
&1.26476E-03_JPRB, 1.04962E-03_JPRB, 8.71080E-04_JPRB, 7.22907E-04_JPRB, 5.99939E-04_JPRB,&
&4.97888E-04_JPRB, 4.13197E-04_JPRB, 3.42911E-04_JPRB, 2.84581E-04_JPRB, 2.36173E-04_JPRB/)
SELFREFO( :, 2) = (/&
&1.27380E-03_JPRB, 1.05867E-03_JPRB, 8.79870E-04_JPRB, 7.31270E-04_JPRB, 6.07767E-04_JPRB,&
&5.05121E-04_JPRB, 4.19812E-04_JPRB, 3.48911E-04_JPRB, 2.89983E-04_JPRB, 2.41008E-04_JPRB/)
SELFREFO( :, 3) = (/&
&1.26332E-03_JPRB, 1.05867E-03_JPRB, 8.87172E-04_JPRB, 7.43454E-04_JPRB, 6.23018E-04_JPRB,&
&5.22092E-04_JPRB, 4.37515E-04_JPRB, 3.66640E-04_JPRB, 3.07246E-04_JPRB, 2.57474E-04_JPRB/)
SELFREFO( :, 4) = (/&
&1.28078E-03_JPRB, 1.07802E-03_JPRB, 9.07363E-04_JPRB, 7.63722E-04_JPRB, 6.42820E-04_JPRB,&
&5.41057E-04_JPRB, 4.55404E-04_JPRB, 3.83311E-04_JPRB, 3.22630E-04_JPRB, 2.71556E-04_JPRB/)
SELFREFO( :, 5) = (/&
&1.61188E-03_JPRB, 1.32375E-03_JPRB, 1.08712E-03_JPRB, 8.92794E-04_JPRB, 7.33203E-04_JPRB,&
&6.02140E-04_JPRB, 4.94505E-04_JPRB, 4.06110E-04_JPRB, 3.33516E-04_JPRB, 2.73898E-04_JPRB/)
SELFREFO( :, 6) = (/&
&1.42549E-03_JPRB, 1.25964E-03_JPRB, 1.11309E-03_JPRB, 9.83595E-04_JPRB, 8.69162E-04_JPRB,&
&7.68043E-04_JPRB, 6.78688E-04_JPRB, 5.99728E-04_JPRB, 5.29955E-04_JPRB, 4.68299E-04_JPRB/)
SELFREFO( :, 7) = (/&
&1.43253E-03_JPRB, 1.28535E-03_JPRB, 1.15330E-03_JPRB, 1.03480E-03_JPRB, 9.28488E-04_JPRB,&
&8.33094E-04_JPRB, 7.47501E-04_JPRB, 6.70702E-04_JPRB, 6.01794E-04_JPRB, 5.39965E-04_JPRB/)
SELFREFO( :, 8) = (/&
&1.48973E-03_JPRB, 1.33348E-03_JPRB, 1.19363E-03_JPRB, 1.06844E-03_JPRB, 9.56378E-04_JPRB,&
&8.56072E-04_JPRB, 7.66286E-04_JPRB, 6.85918E-04_JPRB, 6.13978E-04_JPRB, 5.49583E-04_JPRB/)
SELFREFO( :, 9) = (/&
&1.53002E-03_JPRB, 1.44607E-03_JPRB, 1.36674E-03_JPRB, 1.29175E-03_JPRB, 1.22088E-03_JPRB,&
&1.15390E-03_JPRB, 1.09059E-03_JPRB, 1.03076E-03_JPRB, 9.74209E-04_JPRB, 9.20760E-04_JPRB/)
SELFREFO( :,10) = (/&
&1.78480E-03_JPRB, 1.68865E-03_JPRB, 1.59768E-03_JPRB, 1.51161E-03_JPRB, 1.43018E-03_JPRB,&
&1.35313E-03_JPRB, 1.28023E-03_JPRB, 1.21126E-03_JPRB, 1.14601E-03_JPRB, 1.08427E-03_JPRB/)
SELFREFO( :,11) = (/&
&1.85121E-03_JPRB, 1.73903E-03_JPRB, 1.63364E-03_JPRB, 1.53464E-03_JPRB, 1.44164E-03_JPRB,&
&1.35427E-03_JPRB, 1.27220E-03_JPRB, 1.19510E-03_JPRB, 1.12268E-03_JPRB, 1.05464E-03_JPRB/)
SELFREFO( :,12) = (/&
&2.10772E-03_JPRB, 1.96994E-03_JPRB, 1.84118E-03_JPRB, 1.72082E-03_JPRB, 1.60834E-03_JPRB,&
&1.50321E-03_JPRB, 1.40495E-03_JPRB, 1.31311E-03_JPRB, 1.22728E-03_JPRB, 1.14705E-03_JPRB/)
SELFREFO( :,13) = (/&
&1.99323E-03_JPRB, 1.89279E-03_JPRB, 1.79741E-03_JPRB, 1.70684E-03_JPRB, 1.62083E-03_JPRB,&
&1.53915E-03_JPRB, 1.46159E-03_JPRB, 1.38794E-03_JPRB, 1.31800E-03_JPRB, 1.25159E-03_JPRB/)
SELFREFO( :,14) = (/&
&2.05835E-03_JPRB, 1.93301E-03_JPRB, 1.81529E-03_JPRB, 1.70475E-03_JPRB, 1.60093E-03_JPRB,&
&1.50344E-03_JPRB, 1.41189E-03_JPRB, 1.32591E-03_JPRB, 1.24516E-03_JPRB, 1.16934E-03_JPRB/)
SELFREFO( :,15) = (/&
&2.34120E-03_JPRB, 2.20012E-03_JPRB, 2.06754E-03_JPRB, 1.94295E-03_JPRB, 1.82587E-03_JPRB,&
&1.71585E-03_JPRB, 1.61245E-03_JPRB, 1.51529E-03_JPRB, 1.42398E-03_JPRB, 1.33817E-03_JPRB/)
SELFREFO( :,16) = (/&
&3.03559E-03_JPRB, 2.80023E-03_JPRB, 2.58312E-03_JPRB, 2.38284E-03_JPRB, 2.19809E-03_JPRB,&
&2.02767E-03_JPRB, 1.87045E-03_JPRB, 1.72543E-03_JPRB, 1.59165E-03_JPRB, 1.46825E-03_JPRB/)

FRACREFAO( :, 1) = (/&
!     From P = 862.6 mb.
    &0.17356300_JPRB,0.18880001_JPRB,0.17704099_JPRB,0.13661300_JPRB,&
    &0.10691600_JPRB,0.08222480_JPRB,0.05939860_JPRB,0.04230810_JPRB,&
    &0.02526330_JPRB,0.00244532_JPRB,0.00193541_JPRB,0.00150415_JPRB,&
    &0.00103528_JPRB,0.00067068_JPRB,0.00024951_JPRB,0.00003348_JPRB/)
FRACREFAO( :, 2) = (/&
    &0.17779499_JPRB,0.19837400_JPRB,0.16557600_JPRB,0.13470000_JPRB,&
    &0.11013600_JPRB,0.08342720_JPRB,0.05987030_JPRB,0.03938700_JPRB,&
    &0.02293650_JPRB,0.00238849_JPRB,0.00192400_JPRB,0.00149921_JPRB,&
    &0.00103539_JPRB,0.00067150_JPRB,0.00024822_JPRB,0.00003348_JPRB/)
FRACREFAO( :, 3) = (/&
    &0.18535601_JPRB,0.19407199_JPRB,0.16053200_JPRB,0.13300700_JPRB,&
    &0.10779000_JPRB,0.08408500_JPRB,0.06480450_JPRB,0.04070160_JPRB,&
    &0.02203590_JPRB,0.00227779_JPRB,0.00189074_JPRB,0.00146888_JPRB,&
    &0.00103147_JPRB,0.00066770_JPRB,0.00024751_JPRB,0.00003348_JPRB/)
FRACREFAO( :, 4) = (/&
    &0.19139200_JPRB,0.18917400_JPRB,0.15748601_JPRB,0.13240699_JPRB,&
    &0.10557300_JPRB,0.08383260_JPRB,0.06724060_JPRB,0.04364450_JPRB,&
    &0.02175820_JPRB,0.00225436_JPRB,0.00184421_JPRB,0.00143153_JPRB,&
    &0.00103027_JPRB,0.00066066_JPRB,0.00024222_JPRB,0.00003148_JPRB/)
FRACREFAO( :, 5) = (/&
    &0.19547801_JPRB,0.18539500_JPRB,0.15442000_JPRB,0.13114899_JPRB,&
    &0.10515600_JPRB,0.08350350_JPRB,0.06909780_JPRB,0.04671630_JPRB,&
    &0.02168820_JPRB,0.00224400_JPRB,0.00182009_JPRB,0.00139098_JPRB,&
    &0.00102582_JPRB,0.00065367_JPRB,0.00023202_JPRB,0.00003148_JPRB/)
FRACREFAO( :, 6) = (/&
    &0.19757500_JPRB,0.18266800_JPRB,0.15208900_JPRB,0.12897800_JPRB,&
    &0.10637200_JPRB,0.08391220_JPRB,0.06989830_JPRB,0.04964120_JPRB,&
    &0.02155800_JPRB,0.00224310_JPRB,0.00177358_JPRB,0.00138184_JPRB,&
    &0.00101538_JPRB,0.00063370_JPRB,0.00023227_JPRB,0.00003148_JPRB/)
FRACREFAO( :, 7) = (/&
    &0.20145500_JPRB,0.17692900_JPRB,0.14940600_JPRB,0.12690400_JPRB,&
    &0.10828800_JPRB,0.08553720_JPRB,0.07004940_JPRB,0.05153430_JPRB,&
    &0.02268740_JPRB,0.00216943_JPRB,0.00178603_JPRB,0.00137754_JPRB,&
    &0.00098344_JPRB,0.00063165_JPRB,0.00023218_JPRB,0.00003148_JPRB/)
FRACREFAO( :, 8) = (/&
    &0.20383500_JPRB,0.17047501_JPRB,0.14570600_JPRB,0.12679300_JPRB,&
    &0.11043100_JPRB,0.08719150_JPRB,0.07045440_JPRB,0.05345420_JPRB,&
    &0.02448340_JPRB,0.00215839_JPRB,0.00175893_JPRB,0.00138296_JPRB,&
    &0.00098318_JPRB,0.00063188_JPRB,0.00023199_JPRB,0.00003148_JPRB/)
FRACREFAO( :, 9) = (/&
    &0.18680701_JPRB,0.15961801_JPRB,0.15092900_JPRB,0.13049100_JPRB,&
    &0.11418400_JPRB,0.09380540_JPRB,0.07093450_JPRB,0.05664280_JPRB,&
    &0.02938410_JPRB,0.00217751_JPRB,0.00176766_JPRB,0.00138275_JPRB,&
    &0.00098377_JPRB,0.00063181_JPRB,0.00023193_JPRB,0.00003148_JPRB/)

!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB16_00
