!OCL SCALAR
SUBROUTINE RRTM_KGB15_A2

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 15:  2380-2600 cm-1 (low - N2O,CO2; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO15, ONLY : KAO     ,SELFREFO   ,FRACREFAO
USE YOERRTA15, ONLY : STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 9) = (/&
&1.4008E+00_JPRB,1.6014E+00_JPRB,2.0178E+00_JPRB,2.5290E+00_JPRB,3.0648E+00_JPRB,3.4883E+00_JPRB,&
&3.8106E+00_JPRB,4.1078E+00_JPRB,1.3510E+01_JPRB/)
KAO( :, 2, 1, 9) = (/&
&1.8642E+00_JPRB,1.9682E+00_JPRB,2.2869E+00_JPRB,2.7055E+00_JPRB,3.2045E+00_JPRB,3.6259E+00_JPRB,&
&3.9148E+00_JPRB,4.1490E+00_JPRB,1.3219E+01_JPRB/)
KAO( :, 3, 1, 9) = (/&
&2.4188E+00_JPRB,2.4150E+00_JPRB,2.6255E+00_JPRB,2.9382E+00_JPRB,3.3460E+00_JPRB,3.7645E+00_JPRB,&
&4.0194E+00_JPRB,4.1942E+00_JPRB,1.3301E+01_JPRB/)
KAO( :, 4, 1, 9) = (/&
&3.0606E+00_JPRB,2.9381E+00_JPRB,3.0294E+00_JPRB,3.2272E+00_JPRB,3.5230E+00_JPRB,3.8956E+00_JPRB,&
&4.1275E+00_JPRB,4.2397E+00_JPRB,1.3766E+01_JPRB/)
KAO( :, 5, 1, 9) = (/&
&3.7794E+00_JPRB,3.5290E+00_JPRB,3.4922E+00_JPRB,3.5653E+00_JPRB,3.7393E+00_JPRB,4.0279E+00_JPRB,&
&4.2356E+00_JPRB,4.2849E+00_JPRB,1.4541E+01_JPRB/)
KAO( :, 1, 2, 9) = (/&
&1.0743E+00_JPRB,1.4254E+00_JPRB,1.9959E+00_JPRB,2.6242E+00_JPRB,3.1478E+00_JPRB,3.5640E+00_JPRB,&
&3.9315E+00_JPRB,4.2780E+00_JPRB,1.1246E+01_JPRB/)
KAO( :, 2, 2, 9) = (/&
&1.4450E+00_JPRB,1.7077E+00_JPRB,2.1920E+00_JPRB,2.7731E+00_JPRB,3.3077E+00_JPRB,3.7068E+00_JPRB,&
&4.0280E+00_JPRB,4.3205E+00_JPRB,1.0854E+01_JPRB/)
KAO( :, 3, 2, 9) = (/&
&1.8935E+00_JPRB,2.0578E+00_JPRB,2.4461E+00_JPRB,2.9377E+00_JPRB,3.4636E+00_JPRB,3.8524E+00_JPRB,&
&4.1310E+00_JPRB,4.3656E+00_JPRB,1.0696E+01_JPRB/)
KAO( :, 4, 2, 9) = (/&
&2.4131E+00_JPRB,2.4697E+00_JPRB,2.7529E+00_JPRB,3.1439E+00_JPRB,3.6214E+00_JPRB,3.9997E+00_JPRB,&
&4.2395E+00_JPRB,4.4100E+00_JPRB,1.0792E+01_JPRB/)
KAO( :, 5, 2, 9) = (/&
&3.0060E+00_JPRB,2.9455E+00_JPRB,3.1147E+00_JPRB,3.3967E+00_JPRB,3.7810E+00_JPRB,4.1480E+00_JPRB,&
&4.3467E+00_JPRB,4.4539E+00_JPRB,1.1120E+01_JPRB/)
KAO( :, 1, 3, 9) = (/&
&7.6472E-01_JPRB,1.2830E+00_JPRB,2.0011E+00_JPRB,2.6221E+00_JPRB,3.1251E+00_JPRB,3.5689E+00_JPRB,&
&3.9960E+00_JPRB,4.3904E+00_JPRB,9.5265E+00_JPRB/)
KAO( :, 2, 3, 9) = (/&
&1.0454E+00_JPRB,1.4850E+00_JPRB,2.1444E+00_JPRB,2.7873E+00_JPRB,3.2876E+00_JPRB,3.7049E+00_JPRB,&
&4.0848E+00_JPRB,4.4319E+00_JPRB,9.1222E+00_JPRB/)
KAO( :, 3, 3, 9) = (/&
&1.3885E+00_JPRB,1.7405E+00_JPRB,2.3171E+00_JPRB,2.9536E+00_JPRB,3.4575E+00_JPRB,3.8474E+00_JPRB,&
&4.1795E+00_JPRB,4.4739E+00_JPRB,8.8598E+00_JPRB/)
KAO( :, 4, 3, 9) = (/&
&1.7962E+00_JPRB,2.0514E+00_JPRB,2.5375E+00_JPRB,3.1222E+00_JPRB,3.6306E+00_JPRB,3.9962E+00_JPRB,&
&4.2785E+00_JPRB,4.5165E+00_JPRB,8.7328E+00_JPRB/)
KAO( :, 5, 3, 9) = (/&
&2.2640E+00_JPRB,2.4140E+00_JPRB,2.8016E+00_JPRB,3.3001E+00_JPRB,3.8026E+00_JPRB,4.1450E+00_JPRB,&
&4.3795E+00_JPRB,4.5585E+00_JPRB,8.7266E+00_JPRB/)
KAO( :, 1, 4, 9) = (/&
&5.2796E-01_JPRB,1.2120E+00_JPRB,1.9543E+00_JPRB,2.5382E+00_JPRB,3.0533E+00_JPRB,3.5474E+00_JPRB,&
&4.0298E+00_JPRB,4.4716E+00_JPRB,8.2598E+00_JPRB/)
KAO( :, 2, 4, 9) = (/&
&7.3237E-01_JPRB,1.3475E+00_JPRB,2.1063E+00_JPRB,2.7052E+00_JPRB,3.2055E+00_JPRB,3.6631E+00_JPRB,&
&4.1092E+00_JPRB,4.5092E+00_JPRB,7.9321E+00_JPRB/)
KAO( :, 3, 4, 9) = (/&
&9.9035E-01_JPRB,1.5277E+00_JPRB,2.2632E+00_JPRB,2.8812E+00_JPRB,3.3695E+00_JPRB,3.7914E+00_JPRB,&
&4.1936E+00_JPRB,4.5489E+00_JPRB,7.6815E+00_JPRB/)
KAO( :, 4, 4, 9) = (/&
&1.3002E+00_JPRB,1.7521E+00_JPRB,2.4291E+00_JPRB,3.0611E+00_JPRB,3.5379E+00_JPRB,3.9283E+00_JPRB,&
&4.2814E+00_JPRB,4.5884E+00_JPRB,7.5173E+00_JPRB/)
KAO( :, 5, 4, 9) = (/&
&1.6645E+00_JPRB,2.0223E+00_JPRB,2.6149E+00_JPRB,3.2452E+00_JPRB,3.7109E+00_JPRB,4.0687E+00_JPRB,&
&4.3710E+00_JPRB,4.6264E+00_JPRB,7.4184E+00_JPRB/)
KAO( :, 1, 5, 9) = (/&
&3.6057E-01_JPRB,1.1636E+00_JPRB,1.8513E+00_JPRB,2.4342E+00_JPRB,2.9866E+00_JPRB,3.5323E+00_JPRB,&
&4.0567E+00_JPRB,4.5370E+00_JPRB,7.4568E+00_JPRB/)
KAO( :, 2, 5, 9) = (/&
&5.0709E-01_JPRB,1.2813E+00_JPRB,2.0048E+00_JPRB,2.5857E+00_JPRB,3.1141E+00_JPRB,3.6303E+00_JPRB,&
&4.1258E+00_JPRB,4.5699E+00_JPRB,7.1852E+00_JPRB/)
KAO( :, 3, 5, 9) = (/&
&6.9711E-01_JPRB,1.4088E+00_JPRB,2.1674E+00_JPRB,2.7491E+00_JPRB,3.2569E+00_JPRB,3.7377E+00_JPRB,&
&4.1985E+00_JPRB,4.6043E+00_JPRB,6.9783E+00_JPRB/)
KAO( :, 4, 5, 9) = (/&
&9.3089E-01_JPRB,1.5674E+00_JPRB,2.3376E+00_JPRB,2.9224E+00_JPRB,3.4095E+00_JPRB,3.8525E+00_JPRB,&
&4.2748E+00_JPRB,4.6380E+00_JPRB,6.8324E+00_JPRB/)
KAO( :, 5, 5, 9) = (/&
&1.2095E+00_JPRB,1.7631E+00_JPRB,2.5127E+00_JPRB,3.1011E+00_JPRB,3.5697E+00_JPRB,3.9735E+00_JPRB,&
&4.3536E+00_JPRB,4.6710E+00_JPRB,6.7237E+00_JPRB/)
KAO( :, 1, 6, 9) = (/&
&2.4200E-01_JPRB,1.0838E+00_JPRB,1.7394E+00_JPRB,2.3387E+00_JPRB,2.9299E+00_JPRB,3.5073E+00_JPRB,&
&4.0603E+00_JPRB,4.5751E+00_JPRB,6.9990E+00_JPRB/)
KAO( :, 2, 6, 9) = (/&
&3.4394E-01_JPRB,1.1999E+00_JPRB,1.8760E+00_JPRB,2.4663E+00_JPRB,3.0343E+00_JPRB,3.5897E+00_JPRB,&
&4.1192E+00_JPRB,4.6007E+00_JPRB,6.7915E+00_JPRB/)
KAO( :, 3, 6, 9) = (/&
&4.8030E-01_JPRB,1.3232E+00_JPRB,2.0255E+00_JPRB,2.6081E+00_JPRB,3.1512E+00_JPRB,3.6810E+00_JPRB,&
&4.1825E+00_JPRB,4.6279E+00_JPRB,6.6211E+00_JPRB/)
KAO( :, 4, 6, 9) = (/&
&6.5272E-01_JPRB,1.4558E+00_JPRB,2.1847E+00_JPRB,2.7631E+00_JPRB,3.2807E+00_JPRB,3.7792E+00_JPRB,&
&4.2485E+00_JPRB,4.6560E+00_JPRB,6.4814E+00_JPRB/)
KAO( :, 5, 6, 9) = (/&
&8.6213E-01_JPRB,1.5990E+00_JPRB,2.3528E+00_JPRB,2.9249E+00_JPRB,3.4200E+00_JPRB,3.8827E+00_JPRB,&
&4.3177E+00_JPRB,4.6844E+00_JPRB,6.3643E+00_JPRB/)
KAO( :, 1, 7, 9) = (/&
&1.6234E-01_JPRB,9.9163E-01_JPRB,1.6372E+00_JPRB,2.2588E+00_JPRB,2.8704E+00_JPRB,3.4657E+00_JPRB,&
&4.0381E+00_JPRB,4.5791E+00_JPRB,6.7312E+00_JPRB/)
KAO( :, 2, 7, 9) = (/&
&2.3147E-01_JPRB,1.0981E+00_JPRB,1.7520E+00_JPRB,2.3595E+00_JPRB,2.9563E+00_JPRB,3.5352E+00_JPRB,&
&4.0869E+00_JPRB,4.5966E+00_JPRB,6.5680E+00_JPRB/)
KAO( :, 3, 7, 9) = (/&
&3.2772E-01_JPRB,1.2156E+00_JPRB,1.8829E+00_JPRB,2.4770E+00_JPRB,3.0534E+00_JPRB,3.6116E+00_JPRB,&
&4.1400E+00_JPRB,4.6166E+00_JPRB,6.4257E+00_JPRB/)
KAO( :, 4, 7, 9) = (/&
&4.5268E-01_JPRB,1.3423E+00_JPRB,2.0240E+00_JPRB,2.6084E+00_JPRB,3.1603E+00_JPRB,3.6950E+00_JPRB,&
&4.1975E+00_JPRB,4.6391E+00_JPRB,6.2960E+00_JPRB/)
KAO( :, 5, 7, 9) = (/&
&6.0838E-01_JPRB,1.4784E+00_JPRB,2.1759E+00_JPRB,2.7497E+00_JPRB,3.2763E+00_JPRB,3.7840E+00_JPRB,&
&4.2569E+00_JPRB,4.6620E+00_JPRB,6.1756E+00_JPRB/)
KAO( :, 1, 8, 9) = (/&
&1.1004E-01_JPRB,9.0528E-01_JPRB,1.5488E+00_JPRB,2.1828E+00_JPRB,2.8043E+00_JPRB,3.4087E+00_JPRB,&
&3.9936E+00_JPRB,4.5522E+00_JPRB,6.5679E+00_JPRB/)
KAO( :, 2, 8, 9) = (/&
&1.5599E-01_JPRB,9.9632E-01_JPRB,1.6406E+00_JPRB,2.2628E+00_JPRB,2.8729E+00_JPRB,3.4645E+00_JPRB,&
&4.0312E+00_JPRB,4.5616E+00_JPRB,6.4237E+00_JPRB/)
KAO( :, 3, 8, 9) = (/&
&2.2275E-01_JPRB,1.1002E+00_JPRB,1.7485E+00_JPRB,2.3565E+00_JPRB,2.9517E+00_JPRB,3.5270E+00_JPRB,&
&4.0737E+00_JPRB,4.5749E+00_JPRB,6.2919E+00_JPRB/)
KAO( :, 4, 8, 9) = (/&
&3.1235E-01_JPRB,1.2144E+00_JPRB,1.8706E+00_JPRB,2.4635E+00_JPRB,3.0405E+00_JPRB,3.5959E+00_JPRB,&
&4.1201E+00_JPRB,4.5903E+00_JPRB,6.1693E+00_JPRB/)
KAO( :, 5, 8, 9) = (/&
&4.2664E-01_JPRB,1.3386E+00_JPRB,2.0030E+00_JPRB,2.5834E+00_JPRB,3.1377E+00_JPRB,3.6706E+00_JPRB,&
&4.1692E+00_JPRB,4.6062E+00_JPRB,6.0528E+00_JPRB/)
KAO( :, 1, 9, 9) = (/&
&7.5621E-02_JPRB,8.2912E-01_JPRB,1.4726E+00_JPRB,2.1058E+00_JPRB,2.7258E+00_JPRB,3.3321E+00_JPRB,&
&3.9225E+00_JPRB,4.4919E+00_JPRB,6.3820E+00_JPRB/)
KAO( :, 2, 9, 9) = (/&
&1.0543E-01_JPRB,9.0364E-01_JPRB,1.5428E+00_JPRB,2.1689E+00_JPRB,2.7807E+00_JPRB,3.3755E+00_JPRB,&
&3.9494E+00_JPRB,4.4934E+00_JPRB,6.2476E+00_JPRB/)
KAO( :, 3, 9, 9) = (/&
&1.5066E-01_JPRB,9.9073E-01_JPRB,1.6283E+00_JPRB,2.2439E+00_JPRB,2.8447E+00_JPRB,3.4264E+00_JPRB,&
&3.9821E+00_JPRB,4.4994E+00_JPRB,6.1231E+00_JPRB/)
KAO( :, 4, 9, 9) = (/&
&2.1408E-01_JPRB,1.0896E+00_JPRB,1.7277E+00_JPRB,2.3302E+00_JPRB,2.9173E+00_JPRB,3.4831E+00_JPRB,&
&4.0188E+00_JPRB,4.5079E+00_JPRB,6.0062E+00_JPRB/)
KAO( :, 5, 9, 9) = (/&
&2.9679E-01_JPRB,1.1980E+00_JPRB,1.8391E+00_JPRB,2.4267E+00_JPRB,2.9974E+00_JPRB,3.5447E+00_JPRB,&
&4.0590E+00_JPRB,4.5182E+00_JPRB,5.8937E+00_JPRB/)
KAO( :, 1,10, 9) = (/&
&5.4240E-02_JPRB,7.6886E-01_JPRB,1.4043E+00_JPRB,2.0272E+00_JPRB,2.6366E+00_JPRB,3.2336E+00_JPRB,&
&3.8172E+00_JPRB,4.3834E+00_JPRB,6.1517E+00_JPRB/)
KAO( :, 2,10, 9) = (/&
&7.3880E-02_JPRB,8.2766E-01_JPRB,1.4592E+00_JPRB,2.0774E+00_JPRB,2.6804E+00_JPRB,3.2668E+00_JPRB,&
&3.8346E+00_JPRB,4.3761E+00_JPRB,6.0252E+00_JPRB/)
KAO( :, 3,10, 9) = (/&
&1.0494E-01_JPRB,8.9945E-01_JPRB,1.5264E+00_JPRB,2.1379E+00_JPRB,2.7325E+00_JPRB,3.3074E+00_JPRB,&
&3.8583E+00_JPRB,4.3744E+00_JPRB,5.9074E+00_JPRB/)
KAO( :, 4,10, 9) = (/&
&1.5013E-01_JPRB,9.8203E-01_JPRB,1.6069E+00_JPRB,2.2084E+00_JPRB,2.7922E+00_JPRB,3.3540E+00_JPRB,&
&3.8866E+00_JPRB,4.3763E+00_JPRB,5.7958E+00_JPRB/)
KAO( :, 5,10, 9) = (/&
&2.1071E-01_JPRB,1.0751E+00_JPRB,1.6988E+00_JPRB,2.2877E+00_JPRB,2.8591E+00_JPRB,3.4064E+00_JPRB,&
&3.9198E+00_JPRB,4.3819E+00_JPRB,5.6875E+00_JPRB/)
KAO( :, 1,11, 9) = (/&
&4.4683E-02_JPRB,7.3372E-01_JPRB,1.3451E+00_JPRB,1.9417E+00_JPRB,2.5248E+00_JPRB,3.0962E+00_JPRB,&
&3.6538E+00_JPRB,4.1928E+00_JPRB,5.8131E+00_JPRB/)
KAO( :, 2,11, 9) = (/&
&6.0954E-02_JPRB,7.8585E-01_JPRB,1.3950E+00_JPRB,1.9873E+00_JPRB,2.5636E+00_JPRB,3.1235E+00_JPRB,&
&3.6649E+00_JPRB,4.1802E+00_JPRB,5.6980E+00_JPRB/)
KAO( :, 3,11, 9) = (/&
&8.6688E-02_JPRB,8.4834E-01_JPRB,1.4554E+00_JPRB,2.0422E+00_JPRB,2.6105E+00_JPRB,3.1582E+00_JPRB,&
&3.6827E+00_JPRB,4.1732E+00_JPRB,5.5896E+00_JPRB/)
KAO( :, 4,11, 9) = (/&
&1.2398E-01_JPRB,9.2090E-01_JPRB,1.5262E+00_JPRB,2.1063E+00_JPRB,2.6652E+00_JPRB,3.2007E+00_JPRB,&
&3.7079E+00_JPRB,4.1732E+00_JPRB,5.4857E+00_JPRB/)
KAO( :, 5,11, 9) = (/&
&1.7398E-01_JPRB,1.0025E+00_JPRB,1.6073E+00_JPRB,2.1784E+00_JPRB,2.7274E+00_JPRB,3.2503E+00_JPRB,&
&3.7400E+00_JPRB,4.1797E+00_JPRB,5.3881E+00_JPRB/)
KAO( :, 1,12, 9) = (/&
&3.6885E-02_JPRB,6.8826E-01_JPRB,1.2637E+00_JPRB,1.8240E+00_JPRB,2.3716E+00_JPRB,2.9070E+00_JPRB,&
&3.4294E+00_JPRB,3.9342E+00_JPRB,5.4594E+00_JPRB/)
KAO( :, 2,12, 9) = (/&
&5.0362E-02_JPRB,7.3520E-01_JPRB,1.3086E+00_JPRB,1.8646E+00_JPRB,2.4044E+00_JPRB,2.9285E+00_JPRB,&
&3.4352E+00_JPRB,3.9171E+00_JPRB,5.3534E+00_JPRB/)
KAO( :, 3,12, 9) = (/&
&7.1651E-02_JPRB,7.9173E-01_JPRB,1.3635E+00_JPRB,1.9144E+00_JPRB,2.4467E+00_JPRB,2.9595E+00_JPRB,&
&3.4502E+00_JPRB,3.9090E+00_JPRB,5.2531E+00_JPRB/)
KAO( :, 4,12, 9) = (/&
&1.0249E-01_JPRB,8.5728E-01_JPRB,1.4282E+00_JPRB,1.9738E+00_JPRB,2.4980E+00_JPRB,2.9998E+00_JPRB,&
&3.4748E+00_JPRB,3.9108E+00_JPRB,5.1595E+00_JPRB/)
KAO( :, 5,12, 9) = (/&
&1.4372E-01_JPRB,9.2980E-01_JPRB,1.5022E+00_JPRB,2.0418E+00_JPRB,2.5591E+00_JPRB,3.0515E+00_JPRB,&
&3.5127E+00_JPRB,3.9276E+00_JPRB,5.0750E+00_JPRB/)
KAO( :, 1,13, 9) = (/&
&3.0491E-02_JPRB,6.3441E-01_JPRB,1.1660E+00_JPRB,1.6828E+00_JPRB,2.1872E+00_JPRB,2.6805E+00_JPRB,&
&3.1616E+00_JPRB,3.6254E+00_JPRB,5.1279E+00_JPRB/)
KAO( :, 2,13, 9) = (/&
&4.1640E-02_JPRB,6.7602E-01_JPRB,1.2060E+00_JPRB,1.7186E+00_JPRB,2.2159E+00_JPRB,2.6988E+00_JPRB,&
&3.1653E+00_JPRB,3.6082E+00_JPRB,5.0296E+00_JPRB/)
KAO( :, 3,13, 9) = (/&
&5.9248E-02_JPRB,7.2677E-01_JPRB,1.2558E+00_JPRB,1.7643E+00_JPRB,2.2553E+00_JPRB,2.7282E+00_JPRB,&
&3.1808E+00_JPRB,3.6035E+00_JPRB,4.9390E+00_JPRB/)
KAO( :, 4,13, 9) = (/&
&8.4663E-02_JPRB,7.8595E-01_JPRB,1.3152E+00_JPRB,1.8213E+00_JPRB,2.3074E+00_JPRB,2.7724E+00_JPRB,&
&3.2128E+00_JPRB,3.6169E+00_JPRB,4.8589E+00_JPRB/)
KAO( :, 5,13, 9) = (/&
&1.1865E-01_JPRB,8.5205E-01_JPRB,1.3845E+00_JPRB,1.8890E+00_JPRB,2.3711E+00_JPRB,2.8293E+00_JPRB,&
&3.2586E+00_JPRB,3.6454E+00_JPRB,4.7958E+00_JPRB/)
KAO( :, 1, 1,10) = (/&
&8.3046E+00_JPRB,7.2666E+00_JPRB,6.2285E+00_JPRB,5.1904E+00_JPRB,4.7329E+00_JPRB,5.2261E+00_JPRB,&
&5.7808E+00_JPRB,6.3145E+00_JPRB,1.5403E+01_JPRB/)
KAO( :, 2, 1,10) = (/&
&1.0500E+01_JPRB,9.1879E+00_JPRB,7.8753E+00_JPRB,6.5628E+00_JPRB,5.3429E+00_JPRB,5.4501E+00_JPRB,&
&5.9313E+00_JPRB,6.4007E+00_JPRB,1.7452E+01_JPRB/)
KAO( :, 3, 1,10) = (/&
&1.2866E+01_JPRB,1.1258E+01_JPRB,9.6496E+00_JPRB,8.0413E+00_JPRB,6.4330E+00_JPRB,5.7014E+00_JPRB,&
&6.0980E+00_JPRB,6.4718E+00_JPRB,1.9513E+01_JPRB/)
KAO( :, 4, 1,10) = (/&
&1.5392E+01_JPRB,1.3468E+01_JPRB,1.1544E+01_JPRB,9.6199E+00_JPRB,7.6959E+00_JPRB,6.1009E+00_JPRB,&
&6.2722E+00_JPRB,6.5575E+00_JPRB,2.1715E+01_JPRB/)
KAO( :, 5, 1,10) = (/&
&1.8056E+01_JPRB,1.5799E+01_JPRB,1.3542E+01_JPRB,1.1285E+01_JPRB,9.0279E+00_JPRB,6.8103E+00_JPRB,&
&6.4441E+00_JPRB,6.6397E+00_JPRB,2.3850E+01_JPRB/)
KAO( :, 1, 2,10) = (/&
&6.4947E+00_JPRB,5.6829E+00_JPRB,4.8711E+00_JPRB,4.3890E+00_JPRB,5.0074E+00_JPRB,5.7366E+00_JPRB,&
&6.4315E+00_JPRB,7.0725E+00_JPRB,1.2054E+01_JPRB/)
KAO( :, 2, 2,10) = (/&
&8.3011E+00_JPRB,7.2634E+00_JPRB,6.2258E+00_JPRB,5.2050E+00_JPRB,5.2909E+00_JPRB,5.9522E+00_JPRB,&
&6.5881E+00_JPRB,7.1588E+00_JPRB,1.2666E+01_JPRB/)
KAO( :, 3, 2,10) = (/&
&1.0256E+01_JPRB,8.9740E+00_JPRB,7.6920E+00_JPRB,6.4100E+00_JPRB,5.6644E+00_JPRB,6.1894E+00_JPRB,&
&6.7625E+00_JPRB,7.2404E+00_JPRB,1.3682E+01_JPRB/)
KAO( :, 4, 2,10) = (/&
&1.2397E+01_JPRB,1.0847E+01_JPRB,9.2971E+00_JPRB,7.7479E+00_JPRB,6.3118E+00_JPRB,6.4388E+00_JPRB,&
&6.9414E+00_JPRB,7.3378E+00_JPRB,1.5028E+01_JPRB/)
KAO( :, 5, 2,10) = (/&
&1.4660E+01_JPRB,1.2828E+01_JPRB,1.0995E+01_JPRB,9.1626E+00_JPRB,7.3301E+00_JPRB,6.6905E+00_JPRB,&
&7.1124E+00_JPRB,7.4264E+00_JPRB,1.6436E+01_JPRB/)
KAO( :, 1, 3,10) = (/&
&4.7461E+00_JPRB,4.1529E+00_JPRB,3.7000E+00_JPRB,4.4615E+00_JPRB,5.3639E+00_JPRB,6.2356E+00_JPRB,&
&7.0823E+00_JPRB,7.8222E+00_JPRB,1.0768E+01_JPRB/)
KAO( :, 2, 3,10) = (/&
&6.1674E+00_JPRB,5.3965E+00_JPRB,4.6255E+00_JPRB,4.7868E+00_JPRB,5.6404E+00_JPRB,6.4644E+00_JPRB,&
&7.2578E+00_JPRB,7.9155E+00_JPRB,1.1012E+01_JPRB/)
KAO( :, 3, 3,10) = (/&
&7.7651E+00_JPRB,6.7945E+00_JPRB,5.8238E+00_JPRB,5.2211E+00_JPRB,5.9299E+00_JPRB,6.7104E+00_JPRB,&
&7.4369E+00_JPRB,8.0208E+00_JPRB,1.1349E+01_JPRB/)
KAO( :, 4, 3,10) = (/&
&9.5128E+00_JPRB,8.3237E+00_JPRB,7.1346E+00_JPRB,5.9977E+00_JPRB,6.2294E+00_JPRB,6.9597E+00_JPRB,&
&7.6063E+00_JPRB,8.1225E+00_JPRB,1.1679E+01_JPRB/)
KAO( :, 5, 3,10) = (/&
&1.1390E+01_JPRB,9.9664E+00_JPRB,8.5426E+00_JPRB,7.1189E+00_JPRB,6.5507E+00_JPRB,7.2016E+00_JPRB,&
&7.7732E+00_JPRB,8.2118E+00_JPRB,1.2040E+01_JPRB/)
KAO( :, 1, 4,10) = (/&
&3.3503E+00_JPRB,2.9315E+00_JPRB,3.5683E+00_JPRB,4.6667E+00_JPRB,5.7273E+00_JPRB,6.7580E+00_JPRB,&
&7.7198E+00_JPRB,8.5710E+00_JPRB,1.0440E+01_JPRB/)
KAO( :, 2, 4,10) = (/&
&4.4561E+00_JPRB,3.8991E+00_JPRB,3.9300E+00_JPRB,4.9622E+00_JPRB,5.9939E+00_JPRB,6.9871E+00_JPRB,&
&7.8925E+00_JPRB,8.6774E+00_JPRB,1.0521E+01_JPRB/)
KAO( :, 3, 4,10) = (/&
&5.7189E+00_JPRB,5.0041E+00_JPRB,4.4573E+00_JPRB,5.2834E+00_JPRB,6.2798E+00_JPRB,7.2167E+00_JPRB,&
&8.0686E+00_JPRB,8.7808E+00_JPRB,1.0645E+01_JPRB/)
KAO( :, 4, 4,10) = (/&
&7.1243E+00_JPRB,6.2338E+00_JPRB,5.3456E+00_JPRB,5.6334E+00_JPRB,6.5793E+00_JPRB,7.4542E+00_JPRB,&
&8.2512E+00_JPRB,8.8783E+00_JPRB,1.0735E+01_JPRB/)
KAO( :, 5, 4,10) = (/&
&8.6595E+00_JPRB,7.5770E+00_JPRB,6.4946E+00_JPRB,6.0192E+00_JPRB,6.8955E+00_JPRB,7.7038E+00_JPRB,&
&8.4443E+00_JPRB,8.9879E+00_JPRB,1.0819E+01_JPRB/)
KAO( :, 1, 5,10) = (/&
&2.3228E+00_JPRB,2.3763E+00_JPRB,3.6372E+00_JPRB,4.8666E+00_JPRB,6.0758E+00_JPRB,7.2202E+00_JPRB,&
&8.2887E+00_JPRB,9.2790E+00_JPRB,1.1044E+01_JPRB/)
KAO( :, 2, 5,10) = (/&
&3.1750E+00_JPRB,2.8335E+00_JPRB,3.9429E+00_JPRB,5.1625E+00_JPRB,6.3325E+00_JPRB,7.4495E+00_JPRB,&
&8.4649E+00_JPRB,9.3795E+00_JPRB,1.0992E+01_JPRB/)
KAO( :, 3, 5,10) = (/&
&4.1502E+00_JPRB,3.6314E+00_JPRB,4.2777E+00_JPRB,5.4822E+00_JPRB,6.6129E+00_JPRB,7.6864E+00_JPRB,&
&8.6584E+00_JPRB,9.4768E+00_JPRB,1.0934E+01_JPRB/)
KAO( :, 4, 5,10) = (/&
&5.2710E+00_JPRB,4.6121E+00_JPRB,4.6433E+00_JPRB,5.8225E+00_JPRB,6.9099E+00_JPRB,7.9434E+00_JPRB,&
&8.8623E+00_JPRB,9.5919E+00_JPRB,1.0860E+01_JPRB/)
KAO( :, 5, 5,10) = (/&
&6.4981E+00_JPRB,5.6859E+00_JPRB,5.1116E+00_JPRB,6.1710E+00_JPRB,7.2254E+00_JPRB,8.2046E+00_JPRB,&
&9.0650E+00_JPRB,9.7138E+00_JPRB,1.0789E+01_JPRB/)
KAO( :, 1, 6,10) = (/&
&1.5637E+00_JPRB,2.2731E+00_JPRB,3.6873E+00_JPRB,5.0614E+00_JPRB,6.3700E+00_JPRB,7.6047E+00_JPRB,&
&8.7790E+00_JPRB,9.8692E+00_JPRB,1.1665E+01_JPRB/)
KAO( :, 2, 6,10) = (/&
&2.2000E+00_JPRB,2.5584E+00_JPRB,3.9755E+00_JPRB,5.3314E+00_JPRB,6.6268E+00_JPRB,7.8407E+00_JPRB,&
&8.9633E+00_JPRB,9.9641E+00_JPRB,1.1590E+01_JPRB/)
KAO( :, 3, 6,10) = (/&
&2.9496E+00_JPRB,2.8996E+00_JPRB,4.2934E+00_JPRB,5.6265E+00_JPRB,6.9043E+00_JPRB,8.0863E+00_JPRB,&
&9.1639E+00_JPRB,1.0078E+01_JPRB,1.1504E+01_JPRB/)
KAO( :, 4, 6,10) = (/&
&3.8153E+00_JPRB,3.4040E+00_JPRB,4.6361E+00_JPRB,5.9468E+00_JPRB,7.1994E+00_JPRB,8.3443E+00_JPRB,&
&9.3743E+00_JPRB,1.0202E+01_JPRB,1.1405E+01_JPRB/)
KAO( :, 5, 6,10) = (/&
&4.7923E+00_JPRB,4.1932E+00_JPRB,5.0029E+00_JPRB,6.2942E+00_JPRB,7.4973E+00_JPRB,8.6152E+00_JPRB,&
&9.5722E+00_JPRB,1.0324E+01_JPRB,1.1282E+01_JPRB/)
KAO( :, 1, 7,10) = (/&
&1.0319E+00_JPRB,2.2030E+00_JPRB,3.7189E+00_JPRB,5.1722E+00_JPRB,6.5639E+00_JPRB,7.8914E+00_JPRB,&
&9.1498E+00_JPRB,1.0323E+01_JPRB,1.2175E+01_JPRB/)
KAO( :, 2, 7,10) = (/&
&1.5011E+00_JPRB,2.4558E+00_JPRB,3.9785E+00_JPRB,5.4357E+00_JPRB,6.8145E+00_JPRB,8.1167E+00_JPRB,&
&9.3258E+00_JPRB,1.0416E+01_JPRB,1.2083E+01_JPRB/)
KAO( :, 3, 7,10) = (/&
&2.0652E+00_JPRB,2.7433E+00_JPRB,4.2735E+00_JPRB,5.7267E+00_JPRB,7.0874E+00_JPRB,8.3608E+00_JPRB,&
&9.5223E+00_JPRB,1.0531E+01_JPRB,1.1978E+01_JPRB/)
KAO( :, 4, 7,10) = (/&
&2.7290E+00_JPRB,3.0650E+00_JPRB,4.6079E+00_JPRB,6.0349E+00_JPRB,7.3838E+00_JPRB,8.6181E+00_JPRB,&
&9.7231E+00_JPRB,1.0649E+01_JPRB,1.1858E+01_JPRB/)
KAO( :, 5, 7,10) = (/&
&3.4888E+00_JPRB,3.4187E+00_JPRB,4.9649E+00_JPRB,6.3686E+00_JPRB,7.6906E+00_JPRB,8.8849E+00_JPRB,&
&9.9240E+00_JPRB,1.0751E+01_JPRB,1.1715E+01_JPRB/)
KAO( :, 1, 8,10) = (/&
&6.7247E-01_JPRB,2.1299E+00_JPRB,3.7166E+00_JPRB,5.2113E+00_JPRB,6.6383E+00_JPRB,8.0164E+00_JPRB,&
&9.3365E+00_JPRB,1.0603E+01_JPRB,1.2480E+01_JPRB/)
KAO( :, 2, 8,10) = (/&
&1.0116E+00_JPRB,2.3605E+00_JPRB,3.9609E+00_JPRB,5.4626E+00_JPRB,6.8806E+00_JPRB,8.2311E+00_JPRB,&
&9.5015E+00_JPRB,1.0678E+01_JPRB,1.2368E+01_JPRB/)
KAO( :, 3, 8,10) = (/&
&1.4308E+00_JPRB,2.6245E+00_JPRB,4.2324E+00_JPRB,5.7459E+00_JPRB,7.1525E+00_JPRB,8.4713E+00_JPRB,&
&9.6847E+00_JPRB,1.0770E+01_JPRB,1.2245E+01_JPRB/)
KAO( :, 4, 8,10) = (/&
&1.9350E+00_JPRB,2.9206E+00_JPRB,4.5353E+00_JPRB,6.0493E+00_JPRB,7.4438E+00_JPRB,8.7255E+00_JPRB,&
&9.8811E+00_JPRB,1.0861E+01_JPRB,1.2099E+01_JPRB/)
KAO( :, 5, 8,10) = (/&
&2.5213E+00_JPRB,3.2436E+00_JPRB,4.8666E+00_JPRB,6.3763E+00_JPRB,7.7488E+00_JPRB,8.9884E+00_JPRB,&
&1.0076E+01_JPRB,1.0954E+01_JPRB,1.1942E+01_JPRB/)
KAO( :, 1, 9,10) = (/&
&4.3208E-01_JPRB,2.0475E+00_JPRB,3.6377E+00_JPRB,5.1514E+00_JPRB,6.6073E+00_JPRB,8.0088E+00_JPRB,&
&9.3664E+00_JPRB,1.0689E+01_JPRB,1.2722E+01_JPRB/)
KAO( :, 2, 9,10) = (/&
&6.7092E-01_JPRB,2.2446E+00_JPRB,3.8634E+00_JPRB,5.3834E+00_JPRB,6.8242E+00_JPRB,8.1962E+00_JPRB,&
&9.5019E+00_JPRB,1.0731E+01_JPRB,1.2602E+01_JPRB/)
KAO( :, 3, 9,10) = (/&
&9.7959E-01_JPRB,2.4790E+00_JPRB,4.1220E+00_JPRB,5.6464E+00_JPRB,7.0720E+00_JPRB,8.4107E+00_JPRB,&
&9.6598E+00_JPRB,1.0791E+01_JPRB,1.2470E+01_JPRB/)
KAO( :, 4, 9,10) = (/&
&1.3555E+00_JPRB,2.7516E+00_JPRB,4.4105E+00_JPRB,5.9355E+00_JPRB,7.3438E+00_JPRB,8.6425E+00_JPRB,&
&9.8283E+00_JPRB,1.0860E+01_JPRB,1.2324E+01_JPRB/)
KAO( :, 5, 9,10) = (/&
&1.8036E+00_JPRB,3.0512E+00_JPRB,4.7212E+00_JPRB,6.2493E+00_JPRB,7.6308E+00_JPRB,8.8891E+00_JPRB,&
&1.0011E+01_JPRB,1.0943E+01_JPRB,1.2174E+01_JPRB/)
KAO( :, 1,10,10) = (/&
&2.8562E-01_JPRB,1.9513E+00_JPRB,3.5205E+00_JPRB,5.0276E+00_JPRB,6.5019E+00_JPRB,7.9388E+00_JPRB,&
&9.3417E+00_JPRB,1.0714E+01_JPRB,1.3024E+01_JPRB/)
KAO( :, 2,10,10) = (/&
&4.5369E-01_JPRB,2.1274E+00_JPRB,3.7193E+00_JPRB,5.2300E+00_JPRB,6.6874E+00_JPRB,8.0937E+00_JPRB,&
&9.4530E+00_JPRB,1.0753E+01_JPRB,1.2922E+01_JPRB/)
KAO( :, 3,10,10) = (/&
&6.8195E-01_JPRB,2.3352E+00_JPRB,3.9538E+00_JPRB,5.4609E+00_JPRB,6.8984E+00_JPRB,8.2697E+00_JPRB,&
&9.5779E+00_JPRB,1.0802E+01_JPRB,1.2803E+01_JPRB/)
KAO( :, 4,10,10) = (/&
&9.6434E-01_JPRB,2.5767E+00_JPRB,4.2212E+00_JPRB,5.7204E+00_JPRB,7.1311E+00_JPRB,8.4647E+00_JPRB,&
&9.7207E+00_JPRB,1.0863E+01_JPRB,1.2673E+01_JPRB/)
KAO( :, 5,10,10) = (/&
&1.3075E+00_JPRB,2.8520E+00_JPRB,4.5133E+00_JPRB,6.0099E+00_JPRB,7.3901E+00_JPRB,8.6775E+00_JPRB,&
&9.8779E+00_JPRB,1.0938E+01_JPRB,1.2543E+01_JPRB/)
KAO( :, 1,11,10) = (/&
&2.3625E-01_JPRB,1.9181E+00_JPRB,3.5155E+00_JPRB,5.0744E+00_JPRB,6.6008E+00_JPRB,8.0955E+00_JPRB,&
&9.5644E+00_JPRB,1.1013E+01_JPRB,1.3397E+01_JPRB/)
KAO( :, 2,11,10) = (/&
&3.7530E-01_JPRB,2.0748E+00_JPRB,3.6829E+00_JPRB,5.2358E+00_JPRB,6.7464E+00_JPRB,8.2221E+00_JPRB,&
&9.6585E+00_JPRB,1.1047E+01_JPRB,1.3278E+01_JPRB/)
KAO( :, 3,11,10) = (/&
&5.6319E-01_JPRB,2.2660E+00_JPRB,3.8799E+00_JPRB,5.4224E+00_JPRB,6.9139E+00_JPRB,8.3641E+00_JPRB,&
&9.7629E+00_JPRB,1.1090E+01_JPRB,1.3144E+01_JPRB/)
KAO( :, 4,11,10) = (/&
&7.9630E-01_JPRB,2.4928E+00_JPRB,4.1097E+00_JPRB,5.6369E+00_JPRB,7.1043E+00_JPRB,8.5217E+00_JPRB,&
&9.8785E+00_JPRB,1.1143E+01_JPRB,1.3008E+01_JPRB/)
KAO( :, 5,11,10) = (/&
&1.0789E+00_JPRB,2.7503E+00_JPRB,4.3718E+00_JPRB,5.8827E+00_JPRB,7.3180E+00_JPRB,8.6936E+00_JPRB,&
&9.9992E+00_JPRB,1.1196E+01_JPRB,1.2862E+01_JPRB/)
KAO( :, 1,12,10) = (/&
&1.9532E-01_JPRB,1.9250E+00_JPRB,3.5848E+00_JPRB,5.1929E+00_JPRB,6.7611E+00_JPRB,8.3016E+00_JPRB,&
&9.8096E+00_JPRB,1.1276E+01_JPRB,1.3592E+01_JPRB/)
KAO( :, 2,12,10) = (/&
&3.1059E-01_JPRB,2.0481E+00_JPRB,3.7225E+00_JPRB,5.3350E+00_JPRB,6.8984E+00_JPRB,8.4223E+00_JPRB,&
&9.8976E+00_JPRB,1.1304E+01_JPRB,1.3454E+01_JPRB/)
KAO( :, 3,12,10) = (/&
&4.6509E-01_JPRB,2.2010E+00_JPRB,3.8811E+00_JPRB,5.4933E+00_JPRB,7.0507E+00_JPRB,8.5551E+00_JPRB,&
&9.9951E+00_JPRB,1.1342E+01_JPRB,1.3311E+01_JPRB/)
KAO( :, 4,12,10) = (/&
&6.5689E-01_JPRB,2.3881E+00_JPRB,4.0636E+00_JPRB,5.6724E+00_JPRB,7.2165E+00_JPRB,8.6961E+00_JPRB,&
&1.0098E+01_JPRB,1.1383E+01_JPRB,1.3165E+01_JPRB/)
KAO( :, 5,12,10) = (/&
&8.9052E-01_JPRB,2.6097E+00_JPRB,4.2735E+00_JPRB,5.8670E+00_JPRB,7.3919E+00_JPRB,8.8391E+00_JPRB,&
&1.0193E+01_JPRB,1.1412E+01_JPRB,1.2995E+01_JPRB/)
KAO( :, 1,13,10) = (/&
&1.6125E-01_JPRB,1.9342E+00_JPRB,3.5999E+00_JPRB,5.2092E+00_JPRB,6.7843E+00_JPRB,8.3295E+00_JPRB,&
&9.8358E+00_JPRB,1.1294E+01_JPRB,1.3567E+01_JPRB/)
KAO( :, 2,13,10) = (/&
&2.5632E-01_JPRB,2.0509E+00_JPRB,3.7362E+00_JPRB,5.3503E+00_JPRB,6.9167E+00_JPRB,8.4371E+00_JPRB,&
&9.9071E+00_JPRB,1.1309E+01_JPRB,1.3421E+01_JPRB/)
KAO( :, 3,13,10) = (/&
&3.8326E-01_JPRB,2.1844E+00_JPRB,3.8935E+00_JPRB,5.5111E+00_JPRB,7.0668E+00_JPRB,8.5618E+00_JPRB,&
&9.9929E+00_JPRB,1.1334E+01_JPRB,1.3271E+01_JPRB/)
KAO( :, 4,13,10) = (/&
&5.4156E-01_JPRB,2.3369E+00_JPRB,4.0660E+00_JPRB,5.6864E+00_JPRB,7.2274E+00_JPRB,8.6942E+00_JPRB,&
&1.0083E+01_JPRB,1.1355E+01_JPRB,1.3103E+01_JPRB/)
KAO( :, 5,13,10) = (/&
&7.3401E-01_JPRB,2.5129E+00_JPRB,4.2495E+00_JPRB,5.8694E+00_JPRB,7.3940E+00_JPRB,8.8302E+00_JPRB,&
&1.0173E+01_JPRB,1.1375E+01_JPRB,1.2923E+01_JPRB/)
KAO( :, 1, 1,11) = (/&
&1.2249E+01_JPRB,1.0718E+01_JPRB,9.1868E+00_JPRB,7.6557E+00_JPRB,6.1245E+00_JPRB,5.7627E+00_JPRB,&
&6.3444E+00_JPRB,6.9424E+00_JPRB,1.9044E+01_JPRB/)
KAO( :, 2, 1,11) = (/&
&1.5357E+01_JPRB,1.3437E+01_JPRB,1.1518E+01_JPRB,9.5981E+00_JPRB,7.6785E+00_JPRB,6.1637E+00_JPRB,&
&6.5230E+00_JPRB,7.0281E+00_JPRB,2.1345E+01_JPRB/)
KAO( :, 3, 1,11) = (/&
&1.8886E+01_JPRB,1.6526E+01_JPRB,1.4165E+01_JPRB,1.1804E+01_JPRB,9.4432E+00_JPRB,7.1211E+00_JPRB,&
&6.7255E+00_JPRB,7.1348E+00_JPRB,2.3750E+01_JPRB/)
KAO( :, 4, 1,11) = (/&
&2.2784E+01_JPRB,1.9936E+01_JPRB,1.7088E+01_JPRB,1.4240E+01_JPRB,1.1392E+01_JPRB,8.5439E+00_JPRB,&
&6.9461E+00_JPRB,7.2435E+00_JPRB,2.6291E+01_JPRB/)
KAO( :, 5, 1,11) = (/&
&2.6987E+01_JPRB,2.3613E+01_JPRB,2.0240E+01_JPRB,1.6867E+01_JPRB,1.3493E+01_JPRB,1.0120E+01_JPRB,&
&7.2891E+00_JPRB,7.3404E+00_JPRB,2.9031E+01_JPRB/)
KAO( :, 1, 2,11) = (/&
&9.7136E+00_JPRB,8.4994E+00_JPRB,7.2852E+00_JPRB,6.0710E+00_JPRB,5.6278E+00_JPRB,6.3983E+00_JPRB,&
&7.1952E+00_JPRB,7.9135E+00_JPRB,1.3515E+01_JPRB/)
KAO( :, 2, 2,11) = (/&
&1.2396E+01_JPRB,1.0847E+01_JPRB,9.2971E+00_JPRB,7.7476E+00_JPRB,6.3714E+00_JPRB,6.6654E+00_JPRB,&
&7.3884E+00_JPRB,8.0262E+00_JPRB,1.4990E+01_JPRB/)
KAO( :, 3, 2,11) = (/&
&1.5432E+01_JPRB,1.3503E+01_JPRB,1.1574E+01_JPRB,9.6447E+00_JPRB,7.7158E+00_JPRB,6.9761E+00_JPRB,&
&7.5844E+00_JPRB,8.1568E+00_JPRB,1.6717E+01_JPRB/)
KAO( :, 4, 2,11) = (/&
&1.8816E+01_JPRB,1.6464E+01_JPRB,1.4112E+01_JPRB,1.1760E+01_JPRB,9.4077E+00_JPRB,7.5034E+00_JPRB,&
&7.7791E+00_JPRB,8.2755E+00_JPRB,1.8558E+01_JPRB/)
KAO( :, 5, 2,11) = (/&
&2.2537E+01_JPRB,1.9720E+01_JPRB,1.6903E+01_JPRB,1.4086E+01_JPRB,1.1268E+01_JPRB,8.5223E+00_JPRB,&
&7.9761E+00_JPRB,8.3719E+00_JPRB,2.0482E+01_JPRB/)
KAO( :, 1, 3,11) = (/&
&7.2299E+00_JPRB,6.3262E+00_JPRB,5.4224E+00_JPRB,5.1159E+00_JPRB,6.1132E+00_JPRB,7.1369E+00_JPRB,&
&8.1089E+00_JPRB,8.9636E+00_JPRB,1.1955E+01_JPRB/)
KAO( :, 2, 3,11) = (/&
&9.3918E+00_JPRB,8.2178E+00_JPRB,7.0438E+00_JPRB,5.9613E+00_JPRB,6.4360E+00_JPRB,7.3941E+00_JPRB,&
&8.3154E+00_JPRB,9.1046E+00_JPRB,1.2271E+01_JPRB/)
KAO( :, 3, 3,11) = (/&
&1.1905E+01_JPRB,1.0417E+01_JPRB,8.9285E+00_JPRB,7.4405E+00_JPRB,6.8201E+00_JPRB,7.6628E+00_JPRB,&
&8.5181E+00_JPRB,9.2389E+00_JPRB,1.2625E+01_JPRB/)
KAO( :, 4, 3,11) = (/&
&1.4757E+01_JPRB,1.2912E+01_JPRB,1.1068E+01_JPRB,9.2230E+00_JPRB,7.6302E+00_JPRB,7.9463E+00_JPRB,&
&8.7305E+00_JPRB,9.3535E+00_JPRB,1.3024E+01_JPRB/)
KAO( :, 5, 3,11) = (/&
&1.7893E+01_JPRB,1.5656E+01_JPRB,1.3420E+01_JPRB,1.1183E+01_JPRB,8.9555E+00_JPRB,8.2708E+00_JPRB,&
&8.9555E+00_JPRB,9.4787E+00_JPRB,1.3397E+01_JPRB/)
KAO( :, 1, 4,11) = (/&
&5.1773E+00_JPRB,4.5301E+00_JPRB,4.2164E+00_JPRB,5.4189E+00_JPRB,6.6862E+00_JPRB,7.9110E+00_JPRB,&
&9.0375E+00_JPRB,1.0082E+01_JPRB,1.2163E+01_JPRB/)
KAO( :, 2, 4,11) = (/&
&6.8907E+00_JPRB,6.0294E+00_JPRB,5.1859E+00_JPRB,5.7789E+00_JPRB,6.9881E+00_JPRB,8.1777E+00_JPRB,&
&9.2600E+00_JPRB,1.0217E+01_JPRB,1.2164E+01_JPRB/)
KAO( :, 3, 4,11) = (/&
&8.9163E+00_JPRB,7.8018E+00_JPRB,6.6872E+00_JPRB,6.2510E+00_JPRB,7.3281E+00_JPRB,8.4646E+00_JPRB,&
&9.5034E+00_JPRB,1.0348E+01_JPRB,1.2247E+01_JPRB/)
KAO( :, 4, 4,11) = (/&
&1.1229E+01_JPRB,9.8256E+00_JPRB,8.4220E+00_JPRB,7.1712E+00_JPRB,7.6975E+00_JPRB,8.7686E+00_JPRB,&
&9.7453E+00_JPRB,1.0493E+01_JPRB,1.2364E+01_JPRB/)
KAO( :, 5, 4,11) = (/&
&1.3839E+01_JPRB,1.2109E+01_JPRB,1.0379E+01_JPRB,8.6495E+00_JPRB,8.1169E+00_JPRB,9.0750E+00_JPRB,&
&9.9810E+00_JPRB,1.0635E+01_JPRB,1.2462E+01_JPRB/)
KAO( :, 1, 5,11) = (/&
&3.6436E+00_JPRB,3.1897E+00_JPRB,4.3289E+00_JPRB,5.8481E+00_JPRB,7.3102E+00_JPRB,8.6929E+00_JPRB,&
&9.9995E+00_JPRB,1.1197E+01_JPRB,1.3283E+01_JPRB/)
KAO( :, 2, 5,11) = (/&
&4.9664E+00_JPRB,4.3456E+00_JPRB,4.6924E+00_JPRB,6.1837E+00_JPRB,7.6374E+00_JPRB,8.9934E+00_JPRB,&
&1.0249E+01_JPRB,1.1339E+01_JPRB,1.3236E+01_JPRB/)
KAO( :, 3, 5,11) = (/&
&6.5513E+00_JPRB,5.7324E+00_JPRB,5.2481E+00_JPRB,6.5577E+00_JPRB,7.9818E+00_JPRB,9.3087E+00_JPRB,&
&1.0503E+01_JPRB,1.1501E+01_JPRB,1.3169E+01_JPRB/)
KAO( :, 4, 5,11) = (/&
&8.4164E+00_JPRB,7.3644E+00_JPRB,6.3448E+00_JPRB,6.9578E+00_JPRB,8.3373E+00_JPRB,9.6258E+00_JPRB,&
&1.0752E+01_JPRB,1.1656E+01_JPRB,1.3106E+01_JPRB/)
KAO( :, 5, 5,11) = (/&
&1.0527E+01_JPRB,9.2115E+00_JPRB,7.8956E+00_JPRB,7.4639E+00_JPRB,8.6974E+00_JPRB,9.9429E+00_JPRB,&
&1.0997E+01_JPRB,1.1797E+01_JPRB,1.3036E+01_JPRB/)
KAO( :, 1, 6,11) = (/&
&2.4932E+00_JPRB,2.7486E+00_JPRB,4.5320E+00_JPRB,6.2546E+00_JPRB,7.8988E+00_JPRB,9.4652E+00_JPRB,&
&1.0939E+01_JPRB,1.2316E+01_JPRB,1.4467E+01_JPRB/)
KAO( :, 2, 6,11) = (/&
&3.4773E+00_JPRB,3.1985E+00_JPRB,4.8742E+00_JPRB,6.5999E+00_JPRB,8.2329E+00_JPRB,9.7664E+00_JPRB,&
&1.1186E+01_JPRB,1.2469E+01_JPRB,1.4417E+01_JPRB/)
KAO( :, 3, 6,11) = (/&
&4.6971E+00_JPRB,4.1115E+00_JPRB,5.2651E+00_JPRB,6.9733E+00_JPRB,8.5867E+00_JPRB,1.0084E+01_JPRB,&
&1.1436E+01_JPRB,1.2624E+01_JPRB,1.4351E+01_JPRB/)
KAO( :, 4, 6,11) = (/&
&6.1495E+00_JPRB,5.3808E+00_JPRB,5.6975E+00_JPRB,7.3726E+00_JPRB,8.9642E+00_JPRB,1.0415E+01_JPRB,&
&1.1698E+01_JPRB,1.2772E+01_JPRB,1.4267E+01_JPRB/)
KAO( :, 5, 6,11) = (/&
&7.8284E+00_JPRB,6.8498E+00_JPRB,6.3225E+00_JPRB,7.7926E+00_JPRB,9.3619E+00_JPRB,1.0759E+01_JPRB,&
&1.1977E+01_JPRB,1.2918E+01_JPRB,1.4175E+01_JPRB/)
KAO( :, 1, 7,11) = (/&
&1.6743E+00_JPRB,2.7740E+00_JPRB,4.7631E+00_JPRB,6.6392E+00_JPRB,8.4234E+00_JPRB,1.0141E+01_JPRB,&
&1.1784E+01_JPRB,1.3373E+01_JPRB,1.5635E+01_JPRB/)
KAO( :, 2, 7,11) = (/&
&2.3935E+00_JPRB,3.0856E+00_JPRB,5.0953E+00_JPRB,6.9911E+00_JPRB,8.7690E+00_JPRB,1.0447E+01_JPRB,&
&1.2034E+01_JPRB,1.3500E+01_JPRB,1.5579E+01_JPRB/)
KAO( :, 3, 7,11) = (/&
&3.3116E+00_JPRB,3.4457E+00_JPRB,5.4635E+00_JPRB,7.3709E+00_JPRB,9.1406E+00_JPRB,1.0784E+01_JPRB,&
&1.2298E+01_JPRB,1.3644E+01_JPRB,1.5506E+01_JPRB/)
KAO( :, 4, 7,11) = (/&
&4.4248E+00_JPRB,4.0263E+00_JPRB,5.8643E+00_JPRB,7.7821E+00_JPRB,9.5339E+00_JPRB,1.1137E+01_JPRB,&
&1.2583E+01_JPRB,1.3796E+01_JPRB,1.5411E+01_JPRB/)
KAO( :, 5, 7,11) = (/&
&5.7412E+00_JPRB,5.0279E+00_JPRB,6.2969E+00_JPRB,8.2091E+00_JPRB,9.9459E+00_JPRB,1.1502E+01_JPRB,&
&1.2876E+01_JPRB,1.3971E+01_JPRB,1.5296E+01_JPRB/)
KAO( :, 1, 8,11) = (/&
&1.1086E+00_JPRB,2.8048E+00_JPRB,4.9324E+00_JPRB,6.9454E+00_JPRB,8.8812E+00_JPRB,1.0739E+01_JPRB,&
&1.2537E+01_JPRB,1.4271E+01_JPRB,1.6686E+01_JPRB/)
KAO( :, 2, 8,11) = (/&
&1.6296E+00_JPRB,3.0851E+00_JPRB,5.2594E+00_JPRB,7.2944E+00_JPRB,9.2229E+00_JPRB,1.1045E+01_JPRB,&
&1.2773E+01_JPRB,1.4378E+01_JPRB,1.6616E+01_JPRB/)
KAO( :, 3, 8,11) = (/&
&2.3055E+00_JPRB,3.4160E+00_JPRB,5.6286E+00_JPRB,7.6727E+00_JPRB,9.5919E+00_JPRB,1.1383E+01_JPRB,&
&1.3041E+01_JPRB,1.4518E+01_JPRB,1.6520E+01_JPRB/)
KAO( :, 4, 8,11) = (/&
&3.1507E+00_JPRB,3.7895E+00_JPRB,6.0300E+00_JPRB,8.0860E+00_JPRB,9.9827E+00_JPRB,1.1736E+01_JPRB,&
&1.3326E+01_JPRB,1.4687E+01_JPRB,1.6411E+01_JPRB/)
KAO( :, 5, 8,11) = (/&
&4.1629E+00_JPRB,4.2135E+00_JPRB,6.4636E+00_JPRB,8.5234E+00_JPRB,1.0396E+01_JPRB,1.2103E+01_JPRB,&
&1.3619E+01_JPRB,1.4867E+01_JPRB,1.6271E+01_JPRB/)
KAO( :, 1, 9,11) = (/&
&7.2274E-01_JPRB,2.8188E+00_JPRB,5.0463E+00_JPRB,7.1564E+00_JPRB,9.1934E+00_JPRB,1.1175E+01_JPRB,&
&1.3093E+01_JPRB,1.4982E+01_JPRB,1.7490E+01_JPRB/)
KAO( :, 2, 9,11) = (/&
&1.0936E+00_JPRB,3.0846E+00_JPRB,5.3597E+00_JPRB,7.4879E+00_JPRB,9.5212E+00_JPRB,1.1468E+01_JPRB,&
&1.3317E+01_JPRB,1.5061E+01_JPRB,1.7405E+01_JPRB/)
KAO( :, 3, 9,11) = (/&
&1.5844E+00_JPRB,3.3914E+00_JPRB,5.7218E+00_JPRB,7.8597E+00_JPRB,9.8794E+00_JPRB,1.1792E+01_JPRB,&
&1.3571E+01_JPRB,1.5196E+01_JPRB,1.7299E+01_JPRB/)
KAO( :, 4, 9,11) = (/&
&2.2133E+00_JPRB,3.7382E+00_JPRB,6.1198E+00_JPRB,8.2738E+00_JPRB,1.0272E+01_JPRB,1.2140E+01_JPRB,&
&1.3853E+01_JPRB,1.5355E+01_JPRB,1.7167E+01_JPRB/)
KAO( :, 5, 9,11) = (/&
&2.9830E+00_JPRB,4.1284E+00_JPRB,6.5526E+00_JPRB,8.7144E+00_JPRB,1.0697E+01_JPRB,1.2510E+01_JPRB,&
&1.4140E+01_JPRB,1.5515E+01_JPRB,1.7007E+01_JPRB/)
KAO( :, 1,10,11) = (/&
&4.8237E-01_JPRB,2.8147E+00_JPRB,5.0928E+00_JPRB,7.2773E+00_JPRB,9.3839E+00_JPRB,1.1437E+01_JPRB,&
&1.3443E+01_JPRB,1.5464E+01_JPRB,1.8003E+01_JPRB/)
KAO( :, 2,10,11) = (/&
&7.4855E-01_JPRB,3.0669E+00_JPRB,5.3977E+00_JPRB,7.5863E+00_JPRB,9.6799E+00_JPRB,1.1699E+01_JPRB,&
&1.3634E+01_JPRB,1.5493E+01_JPRB,1.7884E+01_JPRB/)
KAO( :, 3,10,11) = (/&
&1.1085E+00_JPRB,3.3611E+00_JPRB,5.7474E+00_JPRB,7.9493E+00_JPRB,1.0026E+01_JPRB,1.2005E+01_JPRB,&
&1.3869E+01_JPRB,1.5596E+01_JPRB,1.7749E+01_JPRB/)
KAO( :, 4,10,11) = (/&
&1.5772E+00_JPRB,3.6970E+00_JPRB,6.1332E+00_JPRB,8.3566E+00_JPRB,1.0418E+01_JPRB,1.2345E+01_JPRB,&
&1.4128E+01_JPRB,1.5721E+01_JPRB,1.7584E+01_JPRB/)
KAO( :, 5,10,11) = (/&
&2.1652E+00_JPRB,4.0698E+00_JPRB,6.5606E+00_JPRB,8.7912E+00_JPRB,1.0837E+01_JPRB,1.2714E+01_JPRB,&
&1.4407E+01_JPRB,1.5850E+01_JPRB,1.7388E+01_JPRB/)
KAO( :, 1,11,11) = (/&
&3.9938E-01_JPRB,2.8599E+00_JPRB,5.1737E+00_JPRB,7.3744E+00_JPRB,9.5072E+00_JPRB,1.1586E+01_JPRB,&
&1.3611E+01_JPRB,1.5598E+01_JPRB,1.8201E+01_JPRB/)
KAO( :, 2,11,11) = (/&
&6.1944E-01_JPRB,3.1115E+00_JPRB,5.4721E+00_JPRB,7.6865E+00_JPRB,9.8054E+00_JPRB,1.1843E+01_JPRB,&
&1.3793E+01_JPRB,1.5638E+01_JPRB,1.8068E+01_JPRB/)
KAO( :, 3,11,11) = (/&
&9.1846E-01_JPRB,3.4110E+00_JPRB,5.8171E+00_JPRB,8.0466E+00_JPRB,1.0149E+01_JPRB,1.2140E+01_JPRB,&
&1.4010E+01_JPRB,1.5725E+01_JPRB,1.7913E+01_JPRB/)
KAO( :, 4,11,11) = (/&
&1.3105E+00_JPRB,3.7482E+00_JPRB,6.2097E+00_JPRB,8.4443E+00_JPRB,1.0527E+01_JPRB,1.2468E+01_JPRB,&
&1.4250E+01_JPRB,1.5828E+01_JPRB,1.7729E+01_JPRB/)
KAO( :, 5,11,11) = (/&
&1.7999E+00_JPRB,4.1235E+00_JPRB,6.6430E+00_JPRB,8.8791E+00_JPRB,1.0932E+01_JPRB,1.2815E+01_JPRB,&
&1.4506E+01_JPRB,1.5945E+01_JPRB,1.7528E+01_JPRB/)
KAO( :, 1,12,11) = (/&
&3.3001E-01_JPRB,2.8413E+00_JPRB,5.1496E+00_JPRB,7.3701E+00_JPRB,9.5381E+00_JPRB,1.1655E+01_JPRB,&
&1.3720E+01_JPRB,1.5739E+01_JPRB,1.8506E+01_JPRB/)
KAO( :, 2,12,11) = (/&
&5.1236E-01_JPRB,3.0945E+00_JPRB,5.4327E+00_JPRB,7.6537E+00_JPRB,9.8045E+00_JPRB,1.1878E+01_JPRB,&
&1.3880E+01_JPRB,1.5791E+01_JPRB,1.8378E+01_JPRB/)
KAO( :, 3,12,11) = (/&
&7.6165E-01_JPRB,3.3895E+00_JPRB,5.7691E+00_JPRB,7.9857E+00_JPRB,1.0106E+01_JPRB,1.2132E+01_JPRB,&
&1.4063E+01_JPRB,1.5865E+01_JPRB,1.8221E+01_JPRB/)
KAO( :, 4,12,11) = (/&
&1.0868E+00_JPRB,3.7244E+00_JPRB,6.1541E+00_JPRB,8.3616E+00_JPRB,1.0442E+01_JPRB,1.2411E+01_JPRB,&
&1.4266E+01_JPRB,1.5951E+01_JPRB,1.8046E+01_JPRB/)
KAO( :, 5,12,11) = (/&
&1.4941E+00_JPRB,4.0983E+00_JPRB,6.5760E+00_JPRB,8.7801E+00_JPRB,1.0819E+01_JPRB,1.2722E+01_JPRB,&
&1.4491E+01_JPRB,1.6054E+01_JPRB,1.7865E+01_JPRB/)
KAO( :, 1,13,11) = (/&
&2.7270E-01_JPRB,2.8097E+00_JPRB,5.1608E+00_JPRB,7.4465E+00_JPRB,9.6830E+00_JPRB,1.1871E+01_JPRB,&
&1.4022E+01_JPRB,1.6138E+01_JPRB,1.9047E+01_JPRB/)
KAO( :, 2,13,11) = (/&
&4.2335E-01_JPRB,3.0310E+00_JPRB,5.4040E+00_JPRB,7.6870E+00_JPRB,9.9007E+00_JPRB,1.2059E+01_JPRB,&
&1.4159E+01_JPRB,1.6185E+01_JPRB,1.8912E+01_JPRB/)
KAO( :, 3,13,11) = (/&
&6.2933E-01_JPRB,3.3002E+00_JPRB,5.6896E+00_JPRB,7.9624E+00_JPRB,1.0150E+01_JPRB,1.2270E+01_JPRB,&
&1.4311E+01_JPRB,1.6247E+01_JPRB,1.8754E+01_JPRB/)
KAO( :, 4,13,11) = (/&
&8.9928E-01_JPRB,3.6212E+00_JPRB,6.0182E+00_JPRB,8.2763E+00_JPRB,1.0433E+01_JPRB,1.2504E+01_JPRB,&
&1.4478E+01_JPRB,1.6320E+01_JPRB,1.8583E+01_JPRB/)
KAO( :, 5,13,11) = (/&
&1.2370E+00_JPRB,3.9832E+00_JPRB,6.3965E+00_JPRB,8.6284E+00_JPRB,1.0744E+01_JPRB,1.2756E+01_JPRB,&
&1.4653E+01_JPRB,1.6388E+01_JPRB,1.8390E+01_JPRB/)
KAO( :, 1, 1,12) = (/&
&1.9306E+01_JPRB,1.6893E+01_JPRB,1.4480E+01_JPRB,1.2067E+01_JPRB,9.6532E+00_JPRB,7.2945E+00_JPRB,&
&6.9148E+00_JPRB,7.5278E+00_JPRB,2.3433E+01_JPRB/)
KAO( :, 2, 1,12) = (/&
&2.4650E+01_JPRB,2.1569E+01_JPRB,1.8488E+01_JPRB,1.5406E+01_JPRB,1.2325E+01_JPRB,9.2438E+00_JPRB,&
&7.2171E+00_JPRB,7.6406E+00_JPRB,2.6606E+01_JPRB/)
KAO( :, 3, 1,12) = (/&
&3.0678E+01_JPRB,2.6843E+01_JPRB,2.3008E+01_JPRB,1.9174E+01_JPRB,1.5339E+01_JPRB,1.1504E+01_JPRB,&
&7.9763E+00_JPRB,7.7730E+00_JPRB,2.9832E+01_JPRB/)
KAO( :, 4, 1,12) = (/&
&3.7441E+01_JPRB,3.2761E+01_JPRB,2.8081E+01_JPRB,2.3400E+01_JPRB,1.8720E+01_JPRB,1.4040E+01_JPRB,&
&9.3666E+00_JPRB,7.8947E+00_JPRB,3.2935E+01_JPRB/)
KAO( :, 5, 1,12) = (/&
&4.5012E+01_JPRB,3.9386E+01_JPRB,3.3759E+01_JPRB,2.8133E+01_JPRB,2.2506E+01_JPRB,1.6880E+01_JPRB,&
&1.1253E+01_JPRB,8.0012E+00_JPRB,3.6133E+01_JPRB/)
KAO( :, 1, 2,12) = (/&
&1.5936E+01_JPRB,1.3944E+01_JPRB,1.1952E+01_JPRB,9.9601E+00_JPRB,7.9681E+00_JPRB,7.1477E+00_JPRB,&
&7.9439E+00_JPRB,8.7252E+00_JPRB,1.6736E+01_JPRB/)
KAO( :, 2, 2,12) = (/&
&2.0659E+01_JPRB,1.8076E+01_JPRB,1.5494E+01_JPRB,1.2912E+01_JPRB,1.0329E+01_JPRB,8.0751E+00_JPRB,&
&8.1865E+00_JPRB,8.8715E+00_JPRB,1.8751E+01_JPRB/)
KAO( :, 3, 2,12) = (/&
&2.6211E+01_JPRB,2.2935E+01_JPRB,1.9658E+01_JPRB,1.6382E+01_JPRB,1.3106E+01_JPRB,9.8303E+00_JPRB,&
&8.4476E+00_JPRB,9.0112E+00_JPRB,2.0857E+01_JPRB/)
KAO( :, 4, 2,12) = (/&
&3.2434E+01_JPRB,2.8380E+01_JPRB,2.4326E+01_JPRB,2.0271E+01_JPRB,1.6217E+01_JPRB,1.2163E+01_JPRB,&
&8.9851E+00_JPRB,9.1339E+00_JPRB,2.2883E+01_JPRB/)
KAO( :, 5, 2,12) = (/&
&3.9217E+01_JPRB,3.4315E+01_JPRB,2.9413E+01_JPRB,2.4511E+01_JPRB,1.9608E+01_JPRB,1.4706E+01_JPRB,&
&1.0077E+01_JPRB,9.2744E+00_JPRB,2.5016E+01_JPRB/)
KAO( :, 1, 3,12) = (/&
&1.2204E+01_JPRB,1.0678E+01_JPRB,9.1529E+00_JPRB,7.6274E+00_JPRB,7.0064E+00_JPRB,8.0165E+00_JPRB,&
&9.1087E+00_JPRB,1.0091E+01_JPRB,1.3158E+01_JPRB/)
KAO( :, 2, 3,12) = (/&
&1.6264E+01_JPRB,1.4231E+01_JPRB,1.2198E+01_JPRB,1.0165E+01_JPRB,8.2928E+00_JPRB,8.3522E+00_JPRB,&
&9.3382E+00_JPRB,1.0239E+01_JPRB,1.3470E+01_JPRB/)
KAO( :, 3, 3,12) = (/&
&2.0966E+01_JPRB,1.8346E+01_JPRB,1.5725E+01_JPRB,1.3104E+01_JPRB,1.0483E+01_JPRB,8.9163E+00_JPRB,&
&9.5941E+00_JPRB,1.0378E+01_JPRB,1.3791E+01_JPRB/)
KAO( :, 4, 3,12) = (/&
&2.6346E+01_JPRB,2.3053E+01_JPRB,1.9760E+01_JPRB,1.6466E+01_JPRB,1.3173E+01_JPRB,1.0186E+01_JPRB,&
&9.8769E+00_JPRB,1.0543E+01_JPRB,1.4208E+01_JPRB/)
KAO( :, 5, 3,12) = (/&
&3.2499E+01_JPRB,2.8437E+01_JPRB,2.4374E+01_JPRB,2.0312E+01_JPRB,1.6250E+01_JPRB,1.2192E+01_JPRB,&
&1.0198E+01_JPRB,1.0709E+01_JPRB,1.4690E+01_JPRB/)
KAO( :, 1, 4,12) = (/&
&9.0048E+00_JPRB,7.8792E+00_JPRB,6.7536E+00_JPRB,6.3903E+00_JPRB,7.6603E+00_JPRB,9.0569E+00_JPRB,&
&1.0373E+01_JPRB,1.1571E+01_JPRB,1.3828E+01_JPRB/)
KAO( :, 2, 4,12) = (/&
&1.2261E+01_JPRB,1.0728E+01_JPRB,9.1954E+00_JPRB,7.7773E+00_JPRB,8.0813E+00_JPRB,9.3965E+00_JPRB,&
&1.0654E+01_JPRB,1.1734E+01_JPRB,1.3859E+01_JPRB/)
KAO( :, 3, 4,12) = (/&
&1.6168E+01_JPRB,1.4147E+01_JPRB,1.2126E+01_JPRB,1.0105E+01_JPRB,8.8961E+00_JPRB,9.7573E+00_JPRB,&
&1.0940E+01_JPRB,1.1931E+01_JPRB,1.3916E+01_JPRB/)
KAO( :, 4, 4,12) = (/&
&2.0801E+01_JPRB,1.8201E+01_JPRB,1.5600E+01_JPRB,1.3000E+01_JPRB,1.0554E+01_JPRB,1.0169E+01_JPRB,&
&1.1223E+01_JPRB,1.2118E+01_JPRB,1.4034E+01_JPRB/)
KAO( :, 5, 4,12) = (/&
&2.5988E+01_JPRB,2.2740E+01_JPRB,1.9491E+01_JPRB,1.6243E+01_JPRB,1.2994E+01_JPRB,1.0946E+01_JPRB,&
&1.1496E+01_JPRB,1.2284E+01_JPRB,1.4164E+01_JPRB/)
KAO( :, 1, 5,12) = (/&
&6.4609E+00_JPRB,5.6532E+00_JPRB,5.2932E+00_JPRB,6.8539E+00_JPRB,8.5960E+00_JPRB,1.0239E+01_JPRB,&
&1.1787E+01_JPRB,1.3220E+01_JPRB,1.5562E+01_JPRB/)
KAO( :, 2, 5,12) = (/&
&9.0364E+00_JPRB,7.9068E+00_JPRB,6.8055E+00_JPRB,7.2952E+00_JPRB,8.9859E+00_JPRB,1.0601E+01_JPRB,&
&1.2085E+01_JPRB,1.3419E+01_JPRB,1.5565E+01_JPRB/)
KAO( :, 3, 5,12) = (/&
&1.2240E+01_JPRB,1.0710E+01_JPRB,9.1797E+00_JPRB,8.2618E+00_JPRB,9.3995E+00_JPRB,1.0970E+01_JPRB,&
&1.2380E+01_JPRB,1.3618E+01_JPRB,1.5546E+01_JPRB/)
KAO( :, 4, 5,12) = (/&
&1.6001E+01_JPRB,1.4001E+01_JPRB,1.2001E+01_JPRB,1.0093E+01_JPRB,9.9460E+00_JPRB,1.1348E+01_JPRB,&
&1.2695E+01_JPRB,1.3806E+01_JPRB,1.5493E+01_JPRB/)
KAO( :, 5, 5,12) = (/&
&2.0392E+01_JPRB,1.7843E+01_JPRB,1.5294E+01_JPRB,1.2745E+01_JPRB,1.1072E+01_JPRB,1.1762E+01_JPRB,&
&1.3031E+01_JPRB,1.4007E+01_JPRB,1.5413E+01_JPRB/)
KAO( :, 1, 6,12) = (/&
&4.4633E+00_JPRB,3.9388E+00_JPRB,5.4668E+00_JPRB,7.5584E+00_JPRB,9.5392E+00_JPRB,1.1432E+01_JPRB,&
&1.3234E+01_JPRB,1.4983E+01_JPRB,1.7552E+01_JPRB/)
KAO( :, 2, 6,12) = (/&
&6.4534E+00_JPRB,5.6467E+00_JPRB,5.9493E+00_JPRB,7.9882E+00_JPRB,9.9652E+00_JPRB,1.1825E+01_JPRB,&
&1.3565E+01_JPRB,1.5163E+01_JPRB,1.7552E+01_JPRB/)
KAO( :, 3, 6,12) = (/&
&8.9369E+00_JPRB,7.8198E+00_JPRB,7.0306E+00_JPRB,8.4620E+00_JPRB,1.0422E+01_JPRB,1.2244E+01_JPRB,&
&1.3924E+01_JPRB,1.5375E+01_JPRB,1.7522E+01_JPRB/)
KAO( :, 4, 6,12) = (/&
&1.1971E+01_JPRB,1.0475E+01_JPRB,8.9883E+00_JPRB,9.0910E+00_JPRB,1.0899E+01_JPRB,1.2682E+01_JPRB,&
&1.4284E+01_JPRB,1.5608E+01_JPRB,1.7458E+01_JPRB/)
KAO( :, 5, 6,12) = (/&
&1.5570E+01_JPRB,1.3624E+01_JPRB,1.1678E+01_JPRB,1.0383E+01_JPRB,1.1407E+01_JPRB,1.3124E+01_JPRB,&
&1.4643E+01_JPRB,1.5845E+01_JPRB,1.7360E+01_JPRB/)
KAO( :, 1, 7,12) = (/&
&3.0144E+00_JPRB,3.4301E+00_JPRB,5.9195E+00_JPRB,8.2854E+00_JPRB,1.0547E+01_JPRB,1.2704E+01_JPRB,&
&1.4784E+01_JPRB,1.6795E+01_JPRB,1.9646E+01_JPRB/)
KAO( :, 2, 7,12) = (/&
&4.4866E+00_JPRB,4.1345E+00_JPRB,6.3401E+00_JPRB,8.7329E+00_JPRB,1.0993E+01_JPRB,1.3127E+01_JPRB,&
&1.5133E+01_JPRB,1.6992E+01_JPRB,1.9648E+01_JPRB/)
KAO( :, 3, 7,12) = (/&
&6.3891E+00_JPRB,5.5915E+00_JPRB,6.8167E+00_JPRB,9.2170E+00_JPRB,1.1473E+01_JPRB,1.3569E+01_JPRB,&
&1.5507E+01_JPRB,1.7228E+01_JPRB,1.9616E+01_JPRB/)
KAO( :, 4, 7,12) = (/&
&8.7782E+00_JPRB,7.6809E+00_JPRB,7.5739E+00_JPRB,9.7331E+00_JPRB,1.1970E+01_JPRB,1.4031E+01_JPRB,&
&1.5873E+01_JPRB,1.7477E+01_JPRB,1.9541E+01_JPRB/)
KAO( :, 5, 7,12) = (/&
&1.1625E+01_JPRB,1.0171E+01_JPRB,9.0298E+00_JPRB,1.0306E+01_JPRB,1.2492E+01_JPRB,1.4497E+01_JPRB,&
&1.6257E+01_JPRB,1.7701E+01_JPRB,1.9439E+01_JPRB/)
KAO( :, 1, 8,12) = (/&
&1.9926E+00_JPRB,3.6034E+00_JPRB,6.3775E+00_JPRB,8.9929E+00_JPRB,1.1503E+01_JPRB,1.3945E+01_JPRB,&
&1.6299E+01_JPRB,1.8684E+01_JPRB,2.1745E+01_JPRB/)
KAO( :, 2, 8,12) = (/&
&3.0617E+00_JPRB,3.9634E+00_JPRB,6.8142E+00_JPRB,9.4600E+00_JPRB,1.1969E+01_JPRB,1.4375E+01_JPRB,&
&1.6657E+01_JPRB,1.8850E+01_JPRB,2.1761E+01_JPRB/)
KAO( :, 3, 8,12) = (/&
&4.4985E+00_JPRB,4.5132E+00_JPRB,7.2998E+00_JPRB,9.9757E+00_JPRB,1.2478E+01_JPRB,1.4838E+01_JPRB,&
&1.7040E+01_JPRB,1.9071E+01_JPRB,2.1736E+01_JPRB/)
KAO( :, 4, 8,12) = (/&
&6.3130E+00_JPRB,5.6506E+00_JPRB,7.8250E+00_JPRB,1.0530E+01_JPRB,1.3024E+01_JPRB,1.5335E+01_JPRB,&
&1.7448E+01_JPRB,1.9301E+01_JPRB,2.1660E+01_JPRB/)
KAO( :, 5, 8,12) = (/&
&8.5677E+00_JPRB,7.4967E+00_JPRB,8.4271E+00_JPRB,1.1119E+01_JPRB,1.3598E+01_JPRB,1.5852E+01_JPRB,&
&1.7874E+01_JPRB,1.9541E+01_JPRB,2.1548E+01_JPRB/)
KAO( :, 1, 9,12) = (/&
&1.2882E+00_JPRB,3.7811E+00_JPRB,6.7889E+00_JPRB,9.6675E+00_JPRB,1.2448E+01_JPRB,1.5144E+01_JPRB,&
&1.7789E+01_JPRB,2.0526E+01_JPRB,2.3798E+01_JPRB/)
KAO( :, 2, 9,12) = (/&
&2.0503E+00_JPRB,4.1428E+00_JPRB,7.2351E+00_JPRB,1.0146E+01_JPRB,1.2918E+01_JPRB,1.5574E+01_JPRB,&
&1.8133E+01_JPRB,2.0600E+01_JPRB,2.3807E+01_JPRB/)
KAO( :, 3, 9,12) = (/&
&3.0980E+00_JPRB,4.5533E+00_JPRB,7.7296E+00_JPRB,1.0674E+01_JPRB,1.3445E+01_JPRB,1.6056E+01_JPRB,&
&1.8526E+01_JPRB,2.0799E+01_JPRB,2.3759E+01_JPRB/)
KAO( :, 4, 9,12) = (/&
&4.4694E+00_JPRB,5.0345E+00_JPRB,8.2724E+00_JPRB,1.1243E+01_JPRB,1.4010E+01_JPRB,1.6578E+01_JPRB,&
&1.8947E+01_JPRB,2.1039E+01_JPRB,2.3671E+01_JPRB/)
KAO( :, 5, 9,12) = (/&
&6.1961E+00_JPRB,5.9006E+00_JPRB,8.8587E+00_JPRB,1.1853E+01_JPRB,1.4601E+01_JPRB,1.7119E+01_JPRB,&
&1.9383E+01_JPRB,2.1299E+01_JPRB,2.3541E+01_JPRB/)
KAO( :, 1,10,12) = (/&
&8.5127E-01_JPRB,3.9419E+00_JPRB,7.1781E+00_JPRB,1.0273E+01_JPRB,1.3291E+01_JPRB,1.6253E+01_JPRB,&
&1.9160E+01_JPRB,2.2190E+01_JPRB,2.5668E+01_JPRB/)
KAO( :, 2,10,12) = (/&
&1.3967E+00_JPRB,4.3019E+00_JPRB,7.6193E+00_JPRB,1.0754E+01_JPRB,1.3770E+01_JPRB,1.6679E+01_JPRB,&
&1.9482E+01_JPRB,2.2205E+01_JPRB,2.5653E+01_JPRB/)
KAO( :, 3,10,12) = (/&
&2.1663E+00_JPRB,4.7169E+00_JPRB,8.1215E+00_JPRB,1.1290E+01_JPRB,1.4299E+01_JPRB,1.7163E+01_JPRB,&
&1.9866E+01_JPRB,2.2382E+01_JPRB,2.5585E+01_JPRB/)
KAO( :, 4,10,12) = (/&
&3.2052E+00_JPRB,5.1856E+00_JPRB,8.6831E+00_JPRB,1.1877E+01_JPRB,1.4873E+01_JPRB,1.7685E+01_JPRB,&
&2.0283E+01_JPRB,2.2619E+01_JPRB,2.5476E+01_JPRB/)
KAO( :, 5,10,12) = (/&
&4.5284E+00_JPRB,5.7035E+00_JPRB,9.2918E+00_JPRB,1.2513E+01_JPRB,1.5482E+01_JPRB,1.8231E+01_JPRB,&
&2.0720E+01_JPRB,2.2887E+01_JPRB,2.5332E+01_JPRB/)
KAO( :, 1,11,12) = (/&
&7.1408E-01_JPRB,4.2187E+00_JPRB,7.6724E+00_JPRB,1.0987E+01_JPRB,1.4213E+01_JPRB,1.7344E+01_JPRB,&
&2.0412E+01_JPRB,2.3581E+01_JPRB,2.7221E+01_JPRB/)
KAO( :, 2,11,12) = (/&
&1.1737E+00_JPRB,4.6015E+00_JPRB,8.1394E+00_JPRB,1.1481E+01_JPRB,1.4695E+01_JPRB,1.7776E+01_JPRB,&
&2.0744E+01_JPRB,2.3608E+01_JPRB,2.7158E+01_JPRB/)
KAO( :, 3,11,12) = (/&
&1.8278E+00_JPRB,5.0397E+00_JPRB,8.6695E+00_JPRB,1.2042E+01_JPRB,1.5239E+01_JPRB,1.8262E+01_JPRB,&
&2.1130E+01_JPRB,2.3787E+01_JPRB,2.7045E+01_JPRB/)
KAO( :, 4,11,12) = (/&
&2.7031E+00_JPRB,5.5344E+00_JPRB,9.2593E+00_JPRB,1.2658E+01_JPRB,1.5837E+01_JPRB,1.8803E+01_JPRB,&
&2.1557E+01_JPRB,2.4018E+01_JPRB,2.6895E+01_JPRB/)
KAO( :, 5,11,12) = (/&
&3.8301E+00_JPRB,6.0785E+00_JPRB,9.8968E+00_JPRB,1.3323E+01_JPRB,1.6474E+01_JPRB,1.9384E+01_JPRB,&
&2.2018E+01_JPRB,2.4269E+01_JPRB,2.6697E+01_JPRB/)
KAO( :, 1,12,12) = (/&
&5.9719E-01_JPRB,4.4357E+00_JPRB,8.0495E+00_JPRB,1.1513E+01_JPRB,1.4864E+01_JPRB,1.8123E+01_JPRB,&
&2.1317E+01_JPRB,2.4560E+01_JPRB,2.8304E+01_JPRB/)
KAO( :, 2,12,12) = (/&
&9.8514E-01_JPRB,4.8310E+00_JPRB,8.5352E+00_JPRB,1.2024E+01_JPRB,1.5349E+01_JPRB,1.8551E+01_JPRB,&
&2.1630E+01_JPRB,2.4592E+01_JPRB,2.8167E+01_JPRB/)
KAO( :, 3,12,12) = (/&
&1.5344E+00_JPRB,5.2869E+00_JPRB,9.0837E+00_JPRB,1.2602E+01_JPRB,1.5914E+01_JPRB,1.9055E+01_JPRB,&
&2.2019E+01_JPRB,2.4762E+01_JPRB,2.7998E+01_JPRB/)
KAO( :, 4,12,12) = (/&
&2.2758E+00_JPRB,5.8021E+00_JPRB,9.6908E+00_JPRB,1.3238E+01_JPRB,1.6534E+01_JPRB,1.9617E+01_JPRB,&
&2.2454E+01_JPRB,2.4978E+01_JPRB,2.7783E+01_JPRB/)
KAO( :, 5,12,12) = (/&
&3.2239E+00_JPRB,6.3684E+00_JPRB,1.0355E+01_JPRB,1.3925E+01_JPRB,1.7197E+01_JPRB,2.0204E+01_JPRB,&
&2.2925E+01_JPRB,2.5222E+01_JPRB,2.7528E+01_JPRB/)
KAO( :, 1,13,12) = (/&
&4.9832E-01_JPRB,4.5623E+00_JPRB,8.2781E+00_JPRB,1.1820E+01_JPRB,1.5240E+01_JPRB,1.8570E+01_JPRB,&
&2.1811E+01_JPRB,2.5026E+01_JPRB,2.8851E+01_JPRB/)
KAO( :, 2,13,12) = (/&
&8.2244E-01_JPRB,4.9642E+00_JPRB,8.7578E+00_JPRB,1.2321E+01_JPRB,1.5731E+01_JPRB,1.9002E+01_JPRB,&
&2.2129E+01_JPRB,2.5100E+01_JPRB,2.8676E+01_JPRB/)
KAO( :, 3,13,12) = (/&
&1.2846E+00_JPRB,5.4326E+00_JPRB,9.3155E+00_JPRB,1.2900E+01_JPRB,1.6287E+01_JPRB,1.9496E+01_JPRB,&
&2.2507E+01_JPRB,2.5267E+01_JPRB,2.8460E+01_JPRB/)
KAO( :, 4,13,12) = (/&
&1.9049E+00_JPRB,5.9589E+00_JPRB,9.9399E+00_JPRB,1.3548E+01_JPRB,1.6904E+01_JPRB,2.0038E+01_JPRB,&
&2.2926E+01_JPRB,2.5474E+01_JPRB,2.8207E+01_JPRB/)
KAO( :, 5,13,12) = (/&
&2.7022E+00_JPRB,6.5411E+00_JPRB,1.0623E+01_JPRB,1.4250E+01_JPRB,1.7574E+01_JPRB,2.0623E+01_JPRB,&
&2.3373E+01_JPRB,2.5690E+01_JPRB,2.7914E+01_JPRB/)
KAO( :, 1, 1,13) = (/&
&3.4080E+01_JPRB,2.9820E+01_JPRB,2.5560E+01_JPRB,2.1300E+01_JPRB,1.7040E+01_JPRB,1.2780E+01_JPRB,&
&8.7310E+00_JPRB,8.0673E+00_JPRB,2.9577E+01_JPRB/)
KAO( :, 2, 1,13) = (/&
&4.4290E+01_JPRB,3.8754E+01_JPRB,3.3217E+01_JPRB,2.7681E+01_JPRB,2.2145E+01_JPRB,1.6609E+01_JPRB,&
&1.1073E+01_JPRB,8.2554E+00_JPRB,3.3128E+01_JPRB/)
KAO( :, 3, 1,13) = (/&
&5.6045E+01_JPRB,4.9040E+01_JPRB,4.2034E+01_JPRB,3.5028E+01_JPRB,2.8023E+01_JPRB,2.1017E+01_JPRB,&
&1.4011E+01_JPRB,8.4999E+00_JPRB,3.6715E+01_JPRB/)
KAO( :, 4, 1,13) = (/&
&6.9030E+01_JPRB,6.0401E+01_JPRB,5.1772E+01_JPRB,4.3144E+01_JPRB,3.4515E+01_JPRB,2.5886E+01_JPRB,&
&1.7257E+01_JPRB,9.2154E+00_JPRB,4.0421E+01_JPRB/)
KAO( :, 5, 1,13) = (/&
&8.3025E+01_JPRB,7.2647E+01_JPRB,6.2269E+01_JPRB,5.1890E+01_JPRB,4.1512E+01_JPRB,3.1134E+01_JPRB,&
&2.0756E+01_JPRB,1.0504E+01_JPRB,4.4180E+01_JPRB/)
KAO( :, 1, 2,13) = (/&
&3.0233E+01_JPRB,2.6454E+01_JPRB,2.2675E+01_JPRB,1.8895E+01_JPRB,1.5116E+01_JPRB,1.1337E+01_JPRB,&
&8.9456E+00_JPRB,9.4618E+00_JPRB,2.0893E+01_JPRB/)
KAO( :, 2, 2,13) = (/&
&3.9883E+01_JPRB,3.4897E+01_JPRB,2.9912E+01_JPRB,2.4927E+01_JPRB,1.9941E+01_JPRB,1.4956E+01_JPRB,&
&1.0322E+01_JPRB,9.6468E+00_JPRB,2.3460E+01_JPRB/)
KAO( :, 3, 2,13) = (/&
&5.0858E+01_JPRB,4.4501E+01_JPRB,3.8144E+01_JPRB,3.1786E+01_JPRB,2.5429E+01_JPRB,1.9072E+01_JPRB,&
&1.2717E+01_JPRB,9.8260E+00_JPRB,2.6105E+01_JPRB/)
KAO( :, 4, 2,13) = (/&
&6.3293E+01_JPRB,5.5381E+01_JPRB,4.7469E+01_JPRB,3.9558E+01_JPRB,3.1646E+01_JPRB,2.3735E+01_JPRB,&
&1.5823E+01_JPRB,1.0061E+01_JPRB,2.8871E+01_JPRB/)
KAO( :, 5, 2,13) = (/&
&7.7095E+01_JPRB,6.7458E+01_JPRB,5.7821E+01_JPRB,4.8184E+01_JPRB,3.8547E+01_JPRB,2.8911E+01_JPRB,&
&1.9274E+01_JPRB,1.0716E+01_JPRB,3.1684E+01_JPRB/)
KAO( :, 1, 3,13) = (/&
&2.4631E+01_JPRB,2.1553E+01_JPRB,1.8474E+01_JPRB,1.5395E+01_JPRB,1.2316E+01_JPRB,9.8916E+00_JPRB,&
&1.0038E+01_JPRB,1.1089E+01_JPRB,1.4306E+01_JPRB/)
KAO( :, 2, 3,13) = (/&
&3.3118E+01_JPRB,2.8978E+01_JPRB,2.4838E+01_JPRB,2.0699E+01_JPRB,1.6559E+01_JPRB,1.2452E+01_JPRB,&
&1.0491E+01_JPRB,1.1254E+01_JPRB,1.4773E+01_JPRB/)
KAO( :, 3, 3,13) = (/&
&4.3194E+01_JPRB,3.7795E+01_JPRB,3.2396E+01_JPRB,2.6996E+01_JPRB,2.1597E+01_JPRB,1.6198E+01_JPRB,&
&1.1695E+01_JPRB,1.1459E+01_JPRB,1.5413E+01_JPRB/)
KAO( :, 4, 3,13) = (/&
&5.4783E+01_JPRB,4.7935E+01_JPRB,4.1087E+01_JPRB,3.4239E+01_JPRB,2.7391E+01_JPRB,2.0543E+01_JPRB,&
&1.3845E+01_JPRB,1.1681E+01_JPRB,1.6296E+01_JPRB/)
KAO( :, 5, 3,13) = (/&
&6.7780E+01_JPRB,5.9307E+01_JPRB,5.0835E+01_JPRB,4.2362E+01_JPRB,3.3890E+01_JPRB,2.5417E+01_JPRB,&
&1.6945E+01_JPRB,1.1890E+01_JPRB,1.7557E+01_JPRB/)
KAO( :, 1, 4,13) = (/&
&1.9088E+01_JPRB,1.6702E+01_JPRB,1.4316E+01_JPRB,1.1930E+01_JPRB,1.0048E+01_JPRB,1.0234E+01_JPRB,&
&1.1609E+01_JPRB,1.2948E+01_JPRB,1.5443E+01_JPRB/)
KAO( :, 2, 4,13) = (/&
&2.6468E+01_JPRB,2.3159E+01_JPRB,1.9851E+01_JPRB,1.6542E+01_JPRB,1.3234E+01_JPRB,1.1284E+01_JPRB,&
&1.1975E+01_JPRB,1.3181E+01_JPRB,1.5496E+01_JPRB/)
KAO( :, 3, 4,13) = (/&
&3.5386E+01_JPRB,3.0963E+01_JPRB,2.6539E+01_JPRB,2.2116E+01_JPRB,1.7693E+01_JPRB,1.3581E+01_JPRB,&
&1.2366E+01_JPRB,1.3400E+01_JPRB,1.5533E+01_JPRB/)
KAO( :, 4, 4,13) = (/&
&4.5721E+01_JPRB,4.0006E+01_JPRB,3.4291E+01_JPRB,2.8576E+01_JPRB,2.2861E+01_JPRB,1.7146E+01_JPRB,&
&1.3293E+01_JPRB,1.3609E+01_JPRB,1.5601E+01_JPRB/)
KAO( :, 5, 4,13) = (/&
&5.7463E+01_JPRB,5.0280E+01_JPRB,4.3097E+01_JPRB,3.5914E+01_JPRB,2.8732E+01_JPRB,2.1549E+01_JPRB,&
&1.5088E+01_JPRB,1.3821E+01_JPRB,1.5706E+01_JPRB/)
KAO( :, 1, 5,13) = (/&
&1.4426E+01_JPRB,1.2622E+01_JPRB,1.0819E+01_JPRB,9.3955E+00_JPRB,9.8959E+00_JPRB,1.1682E+01_JPRB,&
&1.3442E+01_JPRB,1.5150E+01_JPRB,1.7787E+01_JPRB/)
KAO( :, 2, 5,13) = (/&
&2.0633E+01_JPRB,1.8054E+01_JPRB,1.5474E+01_JPRB,1.2895E+01_JPRB,1.1371E+01_JPRB,1.2152E+01_JPRB,&
&1.3795E+01_JPRB,1.5372E+01_JPRB,1.7817E+01_JPRB/)
KAO( :, 3, 5,13) = (/&
&2.8181E+01_JPRB,2.4658E+01_JPRB,2.1135E+01_JPRB,1.7613E+01_JPRB,1.4271E+01_JPRB,1.3007E+01_JPRB,&
&1.4200E+01_JPRB,1.5591E+01_JPRB,1.7815E+01_JPRB/)
KAO( :, 4, 5,13) = (/&
&3.7172E+01_JPRB,3.2526E+01_JPRB,2.7879E+01_JPRB,2.3233E+01_JPRB,1.8586E+01_JPRB,1.4927E+01_JPRB,&
&1.4654E+01_JPRB,1.5856E+01_JPRB,1.7795E+01_JPRB/)
KAO( :, 5, 5,13) = (/&
&4.7583E+01_JPRB,4.1635E+01_JPRB,3.5687E+01_JPRB,2.9739E+01_JPRB,2.3791E+01_JPRB,1.8024E+01_JPRB,&
&1.5280E+01_JPRB,1.6121E+01_JPRB,1.7748E+01_JPRB/)
KAO( :, 1, 6,13) = (/&
&1.0461E+01_JPRB,9.1530E+00_JPRB,8.0649E+00_JPRB,8.9595E+00_JPRB,1.1163E+01_JPRB,1.3388E+01_JPRB,&
&1.5529E+01_JPRB,1.7569E+01_JPRB,2.0564E+01_JPRB/)
KAO( :, 2, 6,13) = (/&
&1.5391E+01_JPRB,1.3467E+01_JPRB,1.1543E+01_JPRB,1.0534E+01_JPRB,1.1753E+01_JPRB,1.3875E+01_JPRB,&
&1.5945E+01_JPRB,1.7834E+01_JPRB,2.0625E+01_JPRB/)
KAO( :, 3, 6,13) = (/&
&2.1628E+01_JPRB,1.8924E+01_JPRB,1.6221E+01_JPRB,1.3622E+01_JPRB,1.2887E+01_JPRB,1.4422E+01_JPRB,&
&1.6374E+01_JPRB,1.8123E+01_JPRB,2.0643E+01_JPRB/)
KAO( :, 4, 6,13) = (/&
&2.9247E+01_JPRB,2.5591E+01_JPRB,2.1935E+01_JPRB,1.8279E+01_JPRB,1.5333E+01_JPRB,1.5076E+01_JPRB,&
&1.6798E+01_JPRB,1.8415E+01_JPRB,2.0622E+01_JPRB/)
KAO( :, 5, 6,13) = (/&
&3.8260E+01_JPRB,3.3478E+01_JPRB,2.8695E+01_JPRB,2.3913E+01_JPRB,1.9193E+01_JPRB,1.6572E+01_JPRB,&
&1.7244E+01_JPRB,1.8672E+01_JPRB,2.0568E+01_JPRB/)
KAO( :, 1, 7,13) = (/&
&7.3043E+00_JPRB,6.3921E+00_JPRB,7.2574E+00_JPRB,9.9309E+00_JPRB,1.2660E+01_JPRB,1.5305E+01_JPRB,&
&1.7830E+01_JPRB,2.0388E+01_JPRB,2.3721E+01_JPRB/)
KAO( :, 2, 7,13) = (/&
&1.1153E+01_JPRB,9.7589E+00_JPRB,8.9368E+00_JPRB,1.0556E+01_JPRB,1.3220E+01_JPRB,1.5825E+01_JPRB,&
&1.8263E+01_JPRB,2.0631E+01_JPRB,2.3818E+01_JPRB/)
KAO( :, 3, 7,13) = (/&
&1.6186E+01_JPRB,1.4162E+01_JPRB,1.2167E+01_JPRB,1.1878E+01_JPRB,1.3854E+01_JPRB,1.6375E+01_JPRB,&
&1.8737E+01_JPRB,2.0904E+01_JPRB,2.3851E+01_JPRB/)
KAO( :, 4, 7,13) = (/&
&2.2456E+01_JPRB,1.9649E+01_JPRB,1.6842E+01_JPRB,1.4587E+01_JPRB,1.4796E+01_JPRB,1.6968E+01_JPRB,&
&1.9249E+01_JPRB,2.1203E+01_JPRB,2.3842E+01_JPRB/)
KAO( :, 5, 7,13) = (/&
&2.9970E+01_JPRB,2.6223E+01_JPRB,2.2477E+01_JPRB,1.8752E+01_JPRB,1.6763E+01_JPRB,1.7653E+01_JPRB,&
&1.9767E+01_JPRB,2.1542E+01_JPRB,2.3797E+01_JPRB/)
KAO( :, 1, 8,13) = (/&
&4.9692E+00_JPRB,4.9125E+00_JPRB,7.9064E+00_JPRB,1.1184E+01_JPRB,1.4336E+01_JPRB,1.7379E+01_JPRB,&
&2.0369E+01_JPRB,2.3491E+01_JPRB,2.7234E+01_JPRB/)
KAO( :, 2, 8,13) = (/&
&7.9016E+00_JPRB,6.9643E+00_JPRB,8.5289E+00_JPRB,1.1787E+01_JPRB,1.4948E+01_JPRB,1.7963E+01_JPRB,&
&2.0857E+01_JPRB,2.3626E+01_JPRB,2.7349E+01_JPRB/)
KAO( :, 3, 8,13) = (/&
&1.1829E+01_JPRB,1.0351E+01_JPRB,1.0018E+01_JPRB,1.2473E+01_JPRB,1.5611E+01_JPRB,1.8590E+01_JPRB,&
&2.1391E+01_JPRB,2.3947E+01_JPRB,2.7404E+01_JPRB/)
KAO( :, 4, 8,13) = (/&
&1.6837E+01_JPRB,1.4732E+01_JPRB,1.2874E+01_JPRB,1.3529E+01_JPRB,1.6319E+01_JPRB,1.9246E+01_JPRB,&
&2.1937E+01_JPRB,2.4318E+01_JPRB,2.7406E+01_JPRB/)
KAO( :, 5, 8,13) = (/&
&2.2996E+01_JPRB,2.0122E+01_JPRB,1.7247E+01_JPRB,1.5765E+01_JPRB,1.7114E+01_JPRB,1.9918E+01_JPRB,&
&2.2479E+01_JPRB,2.4688E+01_JPRB,2.7359E+01_JPRB/)
KAO( :, 1, 9,13) = (/&
&3.2797E+00_JPRB,4.8490E+00_JPRB,8.7424E+00_JPRB,1.2456E+01_JPRB,1.6073E+01_JPRB,1.9620E+01_JPRB,&
&2.3097E+01_JPRB,2.6808E+01_JPRB,3.0988E+01_JPRB/)
KAO( :, 2, 9,13) = (/&
&5.4392E+00_JPRB,5.6637E+00_JPRB,9.3267E+00_JPRB,1.3100E+01_JPRB,1.6727E+01_JPRB,2.0234E+01_JPRB,&
&2.3592E+01_JPRB,2.6965E+01_JPRB,3.1144E+01_JPRB/)
KAO( :, 3, 9,13) = (/&
&8.4169E+00_JPRB,7.5619E+00_JPRB,1.0020E+01_JPRB,1.3811E+01_JPRB,1.7436E+01_JPRB,2.0893E+01_JPRB,&
&2.4142E+01_JPRB,2.7260E+01_JPRB,3.1227E+01_JPRB/)
KAO( :, 4, 9,13) = (/&
&1.2342E+01_JPRB,1.0800E+01_JPRB,1.1274E+01_JPRB,1.4589E+01_JPRB,1.8199E+01_JPRB,2.1593E+01_JPRB,&
&2.4734E+01_JPRB,2.7614E+01_JPRB,3.1244E+01_JPRB/)
KAO( :, 5, 9,13) = (/&
&1.7292E+01_JPRB,1.5131E+01_JPRB,1.3759E+01_JPRB,1.5542E+01_JPRB,1.9006E+01_JPRB,2.2332E+01_JPRB,&
&2.5355E+01_JPRB,2.7981E+01_JPRB,3.1197E+01_JPRB/)
KAO( :, 1,10,13) = (/&
&2.2032E+00_JPRB,5.2890E+00_JPRB,9.6706E+00_JPRB,1.3878E+01_JPRB,1.7966E+01_JPRB,2.1973E+01_JPRB,&
&2.5989E+01_JPRB,3.0314E+01_JPRB,3.4958E+01_JPRB/)
KAO( :, 2,10,13) = (/&
&3.7831E+00_JPRB,5.7837E+00_JPRB,1.0292E+01_JPRB,1.4556E+01_JPRB,1.8648E+01_JPRB,2.2606E+01_JPRB,&
&2.6478E+01_JPRB,3.0484E+01_JPRB,3.5130E+01_JPRB/)
KAO( :, 3,10,13) = (/&
&6.0546E+00_JPRB,6.6064E+00_JPRB,1.0987E+01_JPRB,1.5317E+01_JPRB,1.9415E+01_JPRB,2.3325E+01_JPRB,&
&2.7070E+01_JPRB,3.0679E+01_JPRB,3.5221E+01_JPRB/)
KAO( :, 4,10,13) = (/&
&9.1249E+00_JPRB,8.4338E+00_JPRB,1.1767E+01_JPRB,1.6143E+01_JPRB,2.0247E+01_JPRB,2.4103E+01_JPRB,&
&2.7726E+01_JPRB,3.1040E+01_JPRB,3.5231E+01_JPRB/)
KAO( :, 5,10,13) = (/&
&1.3052E+01_JPRB,1.1454E+01_JPRB,1.2877E+01_JPRB,1.7024E+01_JPRB,2.1124E+01_JPRB,2.4923E+01_JPRB,&
&2.8417E+01_JPRB,3.1455E+01_JPRB,3.5171E+01_JPRB/)
KAO( :, 1,11,13) = (/&
&1.9086E+00_JPRB,5.9459E+00_JPRB,1.0873E+01_JPRB,1.5591E+01_JPRB,2.0164E+01_JPRB,2.4670E+01_JPRB,&
&2.9154E+01_JPRB,3.3957E+01_JPRB,3.9072E+01_JPRB/)
KAO( :, 2,11,13) = (/&
&3.2952E+00_JPRB,6.4851E+00_JPRB,1.1554E+01_JPRB,1.6337E+01_JPRB,2.0921E+01_JPRB,2.5369E+01_JPRB,&
&2.9685E+01_JPRB,3.4092E+01_JPRB,3.9214E+01_JPRB/)
KAO( :, 3,11,13) = (/&
&5.2771E+00_JPRB,7.1279E+00_JPRB,1.2325E+01_JPRB,1.7170E+01_JPRB,2.1762E+01_JPRB,2.6155E+01_JPRB,&
&3.0331E+01_JPRB,3.4338E+01_JPRB,3.9267E+01_JPRB/)
KAO( :, 4,11,13) = (/&
&7.9532E+00_JPRB,8.2986E+00_JPRB,1.3169E+01_JPRB,1.8082E+01_JPRB,2.2666E+01_JPRB,2.6993E+01_JPRB,&
&3.1034E+01_JPRB,3.4728E+01_JPRB,3.9232E+01_JPRB/)
KAO( :, 5,11,13) = (/&
&1.1408E+01_JPRB,1.0479E+01_JPRB,1.4101E+01_JPRB,1.9050E+01_JPRB,2.3632E+01_JPRB,2.7870E+01_JPRB,&
&3.1762E+01_JPRB,3.5164E+01_JPRB,3.9117E+01_JPRB/)
KAO( :, 1,12,13) = (/&
&1.6495E+00_JPRB,6.5961E+00_JPRB,1.2057E+01_JPRB,1.7278E+01_JPRB,2.2356E+01_JPRB,2.7342E+01_JPRB,&
&3.2267E+01_JPRB,3.7500E+01_JPRB,4.3085E+01_JPRB/)
KAO( :, 2,12,13) = (/&
&2.8452E+00_JPRB,7.1855E+00_JPRB,1.2796E+01_JPRB,1.8080E+01_JPRB,2.3168E+01_JPRB,2.8094E+01_JPRB,&
&3.2847E+01_JPRB,3.7597E+01_JPRB,4.3183E+01_JPRB/)
KAO( :, 3,12,13) = (/&
&4.5627E+00_JPRB,7.8617E+00_JPRB,1.3635E+01_JPRB,1.8987E+01_JPRB,2.4069E+01_JPRB,2.8923E+01_JPRB,&
&3.3529E+01_JPRB,3.7904E+01_JPRB,4.3185E+01_JPRB/)
KAO( :, 4,12,13) = (/&
&6.8882E+00_JPRB,8.6791E+00_JPRB,1.4557E+01_JPRB,1.9976E+01_JPRB,2.5052E+01_JPRB,2.9817E+01_JPRB,&
&3.4260E+01_JPRB,3.8316E+01_JPRB,4.3097E+01_JPRB/)
KAO( :, 5,12,13) = (/&
&9.8701E+00_JPRB,1.0128E+01_JPRB,1.5550E+01_JPRB,2.1028E+01_JPRB,2.6084E+01_JPRB,3.0768E+01_JPRB,&
&3.5030E+01_JPRB,3.8758E+01_JPRB,4.2923E+01_JPRB/)
KAO( :, 1,13,13) = (/&
&1.4102E+00_JPRB,7.2101E+00_JPRB,1.3161E+01_JPRB,1.8856E+01_JPRB,2.4405E+01_JPRB,2.9839E+01_JPRB,&
&3.5177E+01_JPRB,4.0784E+01_JPRB,4.6821E+01_JPRB/)
KAO( :, 2,13,13) = (/&
&2.4382E+00_JPRB,7.8482E+00_JPRB,1.3963E+01_JPRB,1.9729E+01_JPRB,2.5265E+01_JPRB,3.0620E+01_JPRB,&
&3.5779E+01_JPRB,4.0841E+01_JPRB,4.6845E+01_JPRB/)
KAO( :, 3,13,13) = (/&
&3.9130E+00_JPRB,8.5783E+00_JPRB,1.4859E+01_JPRB,2.0699E+01_JPRB,2.6235E+01_JPRB,3.1498E+01_JPRB,&
&3.6480E+01_JPRB,4.1163E+01_JPRB,4.6764E+01_JPRB/)
KAO( :, 4,13,13) = (/&
&5.9062E+00_JPRB,9.3898E+00_JPRB,1.5851E+01_JPRB,2.1749E+01_JPRB,2.7273E+01_JPRB,3.2456E+01_JPRB,&
&3.7253E+01_JPRB,4.1590E+01_JPRB,4.6596E+01_JPRB/)
KAO( :, 5,13,13) = (/&
&8.4798E+00_JPRB,1.0367E+01_JPRB,1.6908E+01_JPRB,2.2869E+01_JPRB,2.8363E+01_JPRB,3.3450E+01_JPRB,&
&3.8074E+01_JPRB,4.2068E+01_JPRB,4.6355E+01_JPRB/)
KAO( :, 1, 1,14) = (/&
&6.5174E+01_JPRB,5.7027E+01_JPRB,4.8880E+01_JPRB,4.0734E+01_JPRB,3.2587E+01_JPRB,2.4440E+01_JPRB,&
&1.6293E+01_JPRB,9.0902E+00_JPRB,3.6845E+01_JPRB/)
KAO( :, 2, 1,14) = (/&
&8.4423E+01_JPRB,7.3870E+01_JPRB,6.3317E+01_JPRB,5.2765E+01_JPRB,4.2212E+01_JPRB,3.1659E+01_JPRB,&
&2.1106E+01_JPRB,1.0672E+01_JPRB,4.1742E+01_JPRB/)
KAO( :, 3, 1,14) = (/&
&1.0604E+02_JPRB,9.2788E+01_JPRB,7.9533E+01_JPRB,6.6277E+01_JPRB,5.3022E+01_JPRB,3.9766E+01_JPRB,&
&2.6511E+01_JPRB,1.3255E+01_JPRB,4.6647E+01_JPRB/)
KAO( :, 4, 1,14) = (/&
&1.3020E+02_JPRB,1.1393E+02_JPRB,9.7651E+01_JPRB,8.1376E+01_JPRB,6.5100E+01_JPRB,4.8825E+01_JPRB,&
&3.2550E+01_JPRB,1.6275E+01_JPRB,5.1511E+01_JPRB/)
KAO( :, 5, 1,14) = (/&
&1.5659E+02_JPRB,1.3701E+02_JPRB,1.1744E+02_JPRB,9.7867E+01_JPRB,7.8294E+01_JPRB,5.8720E+01_JPRB,&
&3.9147E+01_JPRB,1.9573E+01_JPRB,5.6274E+01_JPRB/)
KAO( :, 1, 2,14) = (/&
&6.1823E+01_JPRB,5.4095E+01_JPRB,4.6367E+01_JPRB,3.8639E+01_JPRB,3.0911E+01_JPRB,2.3183E+01_JPRB,&
&1.5456E+01_JPRB,1.0277E+01_JPRB,2.7318E+01_JPRB/)
KAO( :, 2, 2,14) = (/&
&8.1223E+01_JPRB,7.1070E+01_JPRB,6.0917E+01_JPRB,5.0764E+01_JPRB,4.0612E+01_JPRB,3.0459E+01_JPRB,&
&2.0306E+01_JPRB,1.1162E+01_JPRB,3.1010E+01_JPRB/)
KAO( :, 3, 2,14) = (/&
&1.0367E+02_JPRB,9.0711E+01_JPRB,7.7752E+01_JPRB,6.4794E+01_JPRB,5.1835E+01_JPRB,3.8876E+01_JPRB,&
&2.5917E+01_JPRB,1.3111E+01_JPRB,3.4709E+01_JPRB/)
KAO( :, 4, 2,14) = (/&
&1.2892E+02_JPRB,1.1280E+02_JPRB,9.6686E+01_JPRB,8.0572E+01_JPRB,6.4458E+01_JPRB,4.8343E+01_JPRB,&
&3.2229E+01_JPRB,1.6114E+01_JPRB,3.8368E+01_JPRB/)
KAO( :, 5, 2,14) = (/&
&1.5667E+02_JPRB,1.3708E+02_JPRB,1.1750E+02_JPRB,9.7916E+01_JPRB,7.8333E+01_JPRB,5.8750E+01_JPRB,&
&3.9167E+01_JPRB,1.9583E+01_JPRB,4.1940E+01_JPRB/)
KAO( :, 1, 3,14) = (/&
&5.4340E+01_JPRB,4.7547E+01_JPRB,4.0755E+01_JPRB,3.3962E+01_JPRB,2.7170E+01_JPRB,2.0377E+01_JPRB,&
&1.3826E+01_JPRB,1.1988E+01_JPRB,1.6208E+01_JPRB/)
KAO( :, 2, 3,14) = (/&
&7.3213E+01_JPRB,6.4061E+01_JPRB,5.4910E+01_JPRB,4.5758E+01_JPRB,3.6606E+01_JPRB,2.7455E+01_JPRB,&
&1.8303E+01_JPRB,1.2321E+01_JPRB,1.7853E+01_JPRB/)
KAO( :, 3, 3,14) = (/&
&9.5330E+01_JPRB,8.3414E+01_JPRB,7.1498E+01_JPRB,5.9581E+01_JPRB,4.7665E+01_JPRB,3.5749E+01_JPRB,&
&2.3833E+01_JPRB,1.3383E+01_JPRB,1.9735E+01_JPRB/)
KAO( :, 4, 3,14) = (/&
&1.2051E+02_JPRB,1.0545E+02_JPRB,9.0386E+01_JPRB,7.5322E+01_JPRB,6.0257E+01_JPRB,4.5193E+01_JPRB,&
&3.0129E+01_JPRB,1.5439E+01_JPRB,2.1688E+01_JPRB/)
KAO( :, 5, 3,14) = (/&
&1.4852E+02_JPRB,1.2996E+02_JPRB,1.1139E+02_JPRB,9.2828E+01_JPRB,7.4262E+01_JPRB,5.5697E+01_JPRB,&
&3.7131E+01_JPRB,1.8572E+01_JPRB,2.3613E+01_JPRB/)
KAO( :, 1, 4,14) = (/&
&4.5833E+01_JPRB,4.0104E+01_JPRB,3.4375E+01_JPRB,2.8646E+01_JPRB,2.2917E+01_JPRB,1.7188E+01_JPRB,&
&1.3524E+01_JPRB,1.4143E+01_JPRB,1.6776E+01_JPRB/)
KAO( :, 2, 4,14) = (/&
&6.3459E+01_JPRB,5.5527E+01_JPRB,4.7594E+01_JPRB,3.9662E+01_JPRB,3.1730E+01_JPRB,2.3797E+01_JPRB,&
&1.6331E+01_JPRB,1.4451E+01_JPRB,1.6850E+01_JPRB/)
KAO( :, 3, 4,14) = (/&
&8.4502E+01_JPRB,7.3939E+01_JPRB,6.3376E+01_JPRB,5.2814E+01_JPRB,4.2251E+01_JPRB,3.1688E+01_JPRB,&
&2.1126E+01_JPRB,1.4779E+01_JPRB,1.6907E+01_JPRB/)
KAO( :, 4, 4,14) = (/&
&1.0912E+02_JPRB,9.5484E+01_JPRB,8.1843E+01_JPRB,6.8203E+01_JPRB,5.4562E+01_JPRB,4.0922E+01_JPRB,&
&2.7281E+01_JPRB,1.5904E+01_JPRB,1.6987E+01_JPRB/)
KAO( :, 5, 4,14) = (/&
&1.3712E+02_JPRB,1.1998E+02_JPRB,1.0284E+02_JPRB,8.5701E+01_JPRB,6.8561E+01_JPRB,5.1421E+01_JPRB,&
&3.4281E+01_JPRB,1.8042E+01_JPRB,1.7134E+01_JPRB/)
KAO( :, 1, 5,14) = (/&
&3.7621E+01_JPRB,3.2918E+01_JPRB,2.8216E+01_JPRB,2.3513E+01_JPRB,1.8810E+01_JPRB,1.5213E+01_JPRB,&
&1.4972E+01_JPRB,1.6713E+01_JPRB,1.9607E+01_JPRB/)
KAO( :, 2, 5,14) = (/&
&5.3640E+01_JPRB,4.6935E+01_JPRB,4.0230E+01_JPRB,3.3525E+01_JPRB,2.6820E+01_JPRB,2.0195E+01_JPRB,&
&1.6296E+01_JPRB,1.6983E+01_JPRB,1.9709E+01_JPRB/)
KAO( :, 3, 5,14) = (/&
&7.3434E+01_JPRB,6.4254E+01_JPRB,5.5075E+01_JPRB,4.5896E+01_JPRB,3.6717E+01_JPRB,2.7538E+01_JPRB,&
&1.9356E+01_JPRB,1.7364E+01_JPRB,1.9752E+01_JPRB/)
KAO( :, 4, 5,14) = (/&
&9.6831E+01_JPRB,8.4727E+01_JPRB,7.2623E+01_JPRB,6.0519E+01_JPRB,4.8415E+01_JPRB,3.6311E+01_JPRB,&
&2.4262E+01_JPRB,1.7815E+01_JPRB,1.9747E+01_JPRB/)
KAO( :, 5, 5,14) = (/&
&1.2364E+02_JPRB,1.0818E+02_JPRB,9.2728E+01_JPRB,7.7274E+01_JPRB,6.1819E+01_JPRB,4.6364E+01_JPRB,&
&3.0909E+01_JPRB,1.8880E+01_JPRB,1.9719E+01_JPRB/)
KAO( :, 1, 6,14) = (/&
&2.9612E+01_JPRB,2.5911E+01_JPRB,2.2209E+01_JPRB,1.8508E+01_JPRB,1.5714E+01_JPRB,1.5485E+01_JPRB,&
&1.7513E+01_JPRB,1.9803E+01_JPRB,2.3106E+01_JPRB/)
KAO( :, 2, 6,14) = (/&
&4.3748E+01_JPRB,3.8279E+01_JPRB,3.2811E+01_JPRB,2.7342E+01_JPRB,2.1877E+01_JPRB,1.8205E+01_JPRB,&
&1.8101E+01_JPRB,2.0115E+01_JPRB,2.3246E+01_JPRB/)
KAO( :, 3, 6,14) = (/&
&6.1468E+01_JPRB,5.3784E+01_JPRB,4.6101E+01_JPRB,3.8417E+01_JPRB,3.0734E+01_JPRB,2.3328E+01_JPRB,&
&1.9453E+01_JPRB,2.0483E+01_JPRB,2.3324E+01_JPRB/)
KAO( :, 4, 6,14) = (/&
&8.2819E+01_JPRB,7.2467E+01_JPRB,6.2114E+01_JPRB,5.1762E+01_JPRB,4.1410E+01_JPRB,3.1057E+01_JPRB,&
&2.2516E+01_JPRB,2.0832E+01_JPRB,2.3358E+01_JPRB/)
KAO( :, 5, 6,14) = (/&
&1.0782E+02_JPRB,9.4345E+01_JPRB,8.0867E+01_JPRB,6.7389E+01_JPRB,5.3911E+01_JPRB,4.0434E+01_JPRB,&
&2.7416E+01_JPRB,2.1303E+01_JPRB,2.3341E+01_JPRB/)
KAO( :, 1, 7,14) = (/&
&2.2563E+01_JPRB,1.9743E+01_JPRB,1.6922E+01_JPRB,1.4880E+01_JPRB,1.5210E+01_JPRB,1.7595E+01_JPRB,&
&2.0450E+01_JPRB,2.3517E+01_JPRB,2.7272E+01_JPRB/)
KAO( :, 2, 7,14) = (/&
&3.4511E+01_JPRB,3.0197E+01_JPRB,2.5883E+01_JPRB,2.1569E+01_JPRB,1.8701E+01_JPRB,1.8664E+01_JPRB,&
&2.1070E+01_JPRB,2.3724E+01_JPRB,2.7469E+01_JPRB/)
KAO( :, 3, 7,14) = (/&
&4.9903E+01_JPRB,4.3665E+01_JPRB,3.7427E+01_JPRB,3.1189E+01_JPRB,2.5108E+01_JPRB,2.1510E+01_JPRB,&
&2.1786E+01_JPRB,2.4110E+01_JPRB,2.7600E+01_JPRB/)
KAO( :, 4, 7,14) = (/&
&6.8998E+01_JPRB,6.0373E+01_JPRB,5.1749E+01_JPRB,4.3124E+01_JPRB,3.4499E+01_JPRB,2.6735E+01_JPRB,&
&2.3147E+01_JPRB,2.4558E+01_JPRB,2.7662E+01_JPRB/)
KAO( :, 5, 7,14) = (/&
&9.2035E+01_JPRB,8.0530E+01_JPRB,6.9026E+01_JPRB,5.7522E+01_JPRB,4.6017E+01_JPRB,3.4527E+01_JPRB,&
&2.6142E+01_JPRB,2.5028E+01_JPRB,2.7662E+01_JPRB/)
KAO( :, 1, 8,14) = (/&
&1.6646E+01_JPRB,1.4565E+01_JPRB,1.2937E+01_JPRB,1.3876E+01_JPRB,1.6955E+01_JPRB,2.0502E+01_JPRB,&
&2.4054E+01_JPRB,2.7834E+01_JPRB,3.2161E+01_JPRB/)
KAO( :, 2, 8,14) = (/&
&2.6448E+01_JPRB,2.3142E+01_JPRB,1.9836E+01_JPRB,1.7715E+01_JPRB,1.8335E+01_JPRB,2.1296E+01_JPRB,&
&2.4653E+01_JPRB,2.8077E+01_JPRB,3.2424E+01_JPRB/)
KAO( :, 3, 8,14) = (/&
&3.9552E+01_JPRB,3.4608E+01_JPRB,2.9664E+01_JPRB,2.4793E+01_JPRB,2.2053E+01_JPRB,2.2399E+01_JPRB,&
&2.5322E+01_JPRB,2.8464E+01_JPRB,3.2607E+01_JPRB/)
KAO( :, 4, 8,14) = (/&
&5.6374E+01_JPRB,4.9327E+01_JPRB,4.2280E+01_JPRB,3.5233E+01_JPRB,2.8686E+01_JPRB,2.5344E+01_JPRB,&
&2.6090E+01_JPRB,2.8900E+01_JPRB,3.2702E+01_JPRB/)
KAO( :, 5, 8,14) = (/&
&7.7053E+01_JPRB,6.7421E+01_JPRB,5.7790E+01_JPRB,4.8158E+01_JPRB,3.8527E+01_JPRB,3.0635E+01_JPRB,&
&2.7529E+01_JPRB,2.9328E+01_JPRB,3.2729E+01_JPRB/)
KAO( :, 1, 9,14) = (/&
&1.1833E+01_JPRB,1.0384E+01_JPRB,1.1459E+01_JPRB,1.5199E+01_JPRB,1.9504E+01_JPRB,2.3789E+01_JPRB,&
&2.8102E+01_JPRB,3.2786E+01_JPRB,3.7785E+01_JPRB/)
KAO( :, 2, 9,14) = (/&
&1.9655E+01_JPRB,1.7198E+01_JPRB,1.5507E+01_JPRB,1.6804E+01_JPRB,2.0431E+01_JPRB,2.4589E+01_JPRB,&
&2.8753E+01_JPRB,3.3108E+01_JPRB,3.8143E+01_JPRB/)
KAO( :, 3, 9,14) = (/&
&3.0574E+01_JPRB,2.6753E+01_JPRB,2.2935E+01_JPRB,2.1004E+01_JPRB,2.2051E+01_JPRB,2.5542E+01_JPRB,&
&2.9510E+01_JPRB,3.3363E+01_JPRB,3.8391E+01_JPRB/)
KAO( :, 4, 9,14) = (/&
&4.4893E+01_JPRB,3.9281E+01_JPRB,3.3669E+01_JPRB,2.8405E+01_JPRB,2.5980E+01_JPRB,2.6856E+01_JPRB,&
&3.0337E+01_JPRB,3.3859E+01_JPRB,3.8531E+01_JPRB/)
KAO( :, 5, 9,14) = (/&
&6.2714E+01_JPRB,5.4875E+01_JPRB,4.7035E+01_JPRB,3.9196E+01_JPRB,3.2630E+01_JPRB,2.9798E+01_JPRB,&
&3.1253E+01_JPRB,3.4423E+01_JPRB,3.8580E+01_JPRB/)
KAO( :, 1,10,14) = (/&
&8.5124E+00_JPRB,8.2727E+00_JPRB,1.2161E+01_JPRB,1.7400E+01_JPRB,2.2620E+01_JPRB,2.7747E+01_JPRB,&
&3.2952E+01_JPRB,3.8443E+01_JPRB,4.4221E+01_JPRB/)
KAO( :, 2,10,14) = (/&
&1.4801E+01_JPRB,1.2999E+01_JPRB,1.4181E+01_JPRB,1.8385E+01_JPRB,2.3543E+01_JPRB,2.8614E+01_JPRB,&
&3.3590E+01_JPRB,3.8847E+01_JPRB,4.4675E+01_JPRB/)
KAO( :, 3,10,14) = (/&
&2.3770E+01_JPRB,2.0799E+01_JPRB,1.8887E+01_JPRB,2.0455E+01_JPRB,2.4642E+01_JPRB,2.9573E+01_JPRB,&
&3.4392E+01_JPRB,3.9131E+01_JPRB,4.4994E+01_JPRB/)
KAO( :, 4,10,14) = (/&
&3.5762E+01_JPRB,3.1292E+01_JPRB,2.6896E+01_JPRB,2.5061E+01_JPRB,2.6502E+01_JPRB,3.0662E+01_JPRB,&
&3.5247E+01_JPRB,3.9648E+01_JPRB,4.5184E+01_JPRB/)
KAO( :, 5,10,14) = (/&
&5.1160E+01_JPRB,4.4765E+01_JPRB,3.8370E+01_JPRB,3.2741E+01_JPRB,3.0611E+01_JPRB,3.2021E+01_JPRB,&
&3.6131E+01_JPRB,4.0213E+01_JPRB,4.5252E+01_JPRB/)
KAO( :, 1,11,14) = (/&
&7.9777E+00_JPRB,8.7265E+00_JPRB,1.4218E+01_JPRB,2.0419E+01_JPRB,2.6536E+01_JPRB,3.2537E+01_JPRB,&
&3.8615E+01_JPRB,4.5051E+01_JPRB,5.1748E+01_JPRB/)
KAO( :, 2,11,14) = (/&
&1.3839E+01_JPRB,1.2575E+01_JPRB,1.5679E+01_JPRB,2.1487E+01_JPRB,2.7590E+01_JPRB,3.3521E+01_JPRB,&
&3.9346E+01_JPRB,4.5471E+01_JPRB,5.2220E+01_JPRB/)
KAO( :, 3,11,14) = (/&
&2.2213E+01_JPRB,1.9436E+01_JPRB,1.9340E+01_JPRB,2.2978E+01_JPRB,2.8775E+01_JPRB,3.4623E+01_JPRB,&
&4.0260E+01_JPRB,4.5752E+01_JPRB,5.2534E+01_JPRB/)
KAO( :, 4,11,14) = (/&
&3.3533E+01_JPRB,2.9341E+01_JPRB,2.5981E+01_JPRB,2.6492E+01_JPRB,3.0190E+01_JPRB,3.5801E+01_JPRB,&
&4.1239E+01_JPRB,4.6338E+01_JPRB,5.2703E+01_JPRB/)
KAO( :, 5,11,14) = (/&
&4.8125E+01_JPRB,4.2109E+01_JPRB,3.6128E+01_JPRB,3.2789E+01_JPRB,3.3249E+01_JPRB,3.7092E+01_JPRB,&
&4.2227E+01_JPRB,4.6984E+01_JPRB,5.2733E+01_JPRB/)
KAO( :, 1,12,14) = (/&
&7.3404E+00_JPRB,9.4591E+00_JPRB,1.6537E+01_JPRB,2.3797E+01_JPRB,3.0901E+01_JPRB,3.7866E+01_JPRB,&
&4.4903E+01_JPRB,5.2386E+01_JPRB,6.0116E+01_JPRB/)
KAO( :, 2,12,14) = (/&
&1.2760E+01_JPRB,1.2502E+01_JPRB,1.7728E+01_JPRB,2.4979E+01_JPRB,3.2095E+01_JPRB,3.8976E+01_JPRB,&
&4.5735E+01_JPRB,5.2811E+01_JPRB,6.0596E+01_JPRB/)
KAO( :, 3,12,14) = (/&
&2.0574E+01_JPRB,1.8262E+01_JPRB,2.0491E+01_JPRB,2.6348E+01_JPRB,3.3404E+01_JPRB,4.0219E+01_JPRB,&
&4.6757E+01_JPRB,5.3073E+01_JPRB,6.0869E+01_JPRB/)
KAO( :, 4,12,14) = (/&
&3.1115E+01_JPRB,2.7226E+01_JPRB,2.5855E+01_JPRB,2.8871E+01_JPRB,3.4864E+01_JPRB,4.1538E+01_JPRB,&
&4.7864E+01_JPRB,5.3711E+01_JPRB,6.0982E+01_JPRB/)
KAO( :, 5,12,14) = (/&
&4.4619E+01_JPRB,3.9042E+01_JPRB,3.4233E+01_JPRB,3.3732E+01_JPRB,3.6915E+01_JPRB,4.2904E+01_JPRB,&
&4.8966E+01_JPRB,5.4437E+01_JPRB,6.0955E+01_JPRB/)
KAO( :, 1,13,14) = (/&
&6.6733E+00_JPRB,1.0528E+01_JPRB,1.9102E+01_JPRB,2.7491E+01_JPRB,3.5658E+01_JPRB,4.3660E+01_JPRB,&
&5.1735E+01_JPRB,6.0358E+01_JPRB,6.9219E+01_JPRB/)
KAO( :, 2,13,14) = (/&
&1.1655E+01_JPRB,1.2870E+01_JPRB,2.0329E+01_JPRB,2.8808E+01_JPRB,3.6997E+01_JPRB,4.4910E+01_JPRB,&
&5.2656E+01_JPRB,6.0744E+01_JPRB,6.9651E+01_JPRB/)
KAO( :, 3,13,14) = (/&
&1.8767E+01_JPRB,1.7501E+01_JPRB,2.2287E+01_JPRB,3.0262E+01_JPRB,3.8454E+01_JPRB,4.6291E+01_JPRB,&
&5.3806E+01_JPRB,6.1028E+01_JPRB,6.9886E+01_JPRB/)
KAO( :, 4,13,14) = (/&
&2.8382E+01_JPRB,2.4995E+01_JPRB,2.6394E+01_JPRB,3.2078E+01_JPRB,4.0012E+01_JPRB,4.7748E+01_JPRB,&
&5.5029E+01_JPRB,6.1702E+01_JPRB,6.9938E+01_JPRB/)
KAO( :, 5,13,14) = (/&
&4.0772E+01_JPRB,3.5676E+01_JPRB,3.3182E+01_JPRB,3.5686E+01_JPRB,4.1712E+01_JPRB,4.9244E+01_JPRB,&
&5.6238E+01_JPRB,6.2475E+01_JPRB,6.9819E+01_JPRB/)
KAO( :, 1, 1,15) = (/&
&1.1094E+02_JPRB,9.7072E+01_JPRB,8.3204E+01_JPRB,6.9337E+01_JPRB,5.5470E+01_JPRB,4.1602E+01_JPRB,&
&2.7735E+01_JPRB,1.3867E+01_JPRB,4.4845E+01_JPRB/)
KAO( :, 2, 1,15) = (/&
&1.4352E+02_JPRB,1.2558E+02_JPRB,1.0764E+02_JPRB,8.9703E+01_JPRB,7.1762E+01_JPRB,5.3822E+01_JPRB,&
&3.5881E+01_JPRB,1.7941E+01_JPRB,5.0973E+01_JPRB/)
KAO( :, 3, 1,15) = (/&
&1.8038E+02_JPRB,1.5783E+02_JPRB,1.3528E+02_JPRB,1.1274E+02_JPRB,9.0189E+01_JPRB,6.7642E+01_JPRB,&
&4.5094E+01_JPRB,2.2547E+01_JPRB,5.7040E+01_JPRB/)
KAO( :, 4, 1,15) = (/&
&2.2134E+02_JPRB,1.9367E+02_JPRB,1.6600E+02_JPRB,1.3834E+02_JPRB,1.1067E+02_JPRB,8.3002E+01_JPRB,&
&5.5334E+01_JPRB,2.7667E+01_JPRB,6.3000E+01_JPRB/)
KAO( :, 5, 1,15) = (/&
&2.6568E+02_JPRB,2.3247E+02_JPRB,1.9926E+02_JPRB,1.6605E+02_JPRB,1.3284E+02_JPRB,9.9630E+01_JPRB,&
&6.6420E+01_JPRB,3.3210E+01_JPRB,6.8855E+01_JPRB/)
KAO( :, 1, 2,15) = (/&
&1.1363E+02_JPRB,9.9422E+01_JPRB,8.5219E+01_JPRB,7.1016E+01_JPRB,5.6813E+01_JPRB,4.2609E+01_JPRB,&
&2.8406E+01_JPRB,1.4203E+01_JPRB,3.3096E+01_JPRB/)
KAO( :, 2, 2,15) = (/&
&1.4930E+02_JPRB,1.3064E+02_JPRB,1.1197E+02_JPRB,9.3312E+01_JPRB,7.4650E+01_JPRB,5.5987E+01_JPRB,&
&3.7325E+01_JPRB,1.8662E+01_JPRB,3.7888E+01_JPRB/)
KAO( :, 3, 2,15) = (/&
&1.9010E+02_JPRB,1.6634E+02_JPRB,1.4258E+02_JPRB,1.1881E+02_JPRB,9.5050E+01_JPRB,7.1288E+01_JPRB,&
&4.7525E+01_JPRB,2.3763E+01_JPRB,4.2686E+01_JPRB/)
KAO( :, 4, 2,15) = (/&
&2.3571E+02_JPRB,2.0625E+02_JPRB,1.7678E+02_JPRB,1.4732E+02_JPRB,1.1785E+02_JPRB,8.8391E+01_JPRB,&
&5.8927E+01_JPRB,2.9464E+01_JPRB,4.7440E+01_JPRB/)
KAO( :, 5, 2,15) = (/&
&2.8549E+02_JPRB,2.4980E+02_JPRB,2.1412E+02_JPRB,1.7843E+02_JPRB,1.4274E+02_JPRB,1.0706E+02_JPRB,&
&7.1372E+01_JPRB,3.5686E+01_JPRB,5.2117E+01_JPRB/)
KAO( :, 1, 3,15) = (/&
&1.0870E+02_JPRB,9.5115E+01_JPRB,8.1527E+01_JPRB,6.7939E+01_JPRB,5.4352E+01_JPRB,4.0764E+01_JPRB,&
&2.7176E+01_JPRB,1.4092E+01_JPRB,1.9358E+01_JPRB/)
KAO( :, 2, 3,15) = (/&
&1.4594E+02_JPRB,1.2770E+02_JPRB,1.0946E+02_JPRB,9.1215E+01_JPRB,7.2972E+01_JPRB,5.4729E+01_JPRB,&
&3.6486E+01_JPRB,1.8243E+01_JPRB,2.1671E+01_JPRB/)
KAO( :, 3, 3,15) = (/&
&1.8927E+02_JPRB,1.6561E+02_JPRB,1.4196E+02_JPRB,1.1830E+02_JPRB,9.4637E+01_JPRB,7.0978E+01_JPRB,&
&4.7319E+01_JPRB,2.3659E+01_JPRB,2.4176E+01_JPRB/)
KAO( :, 4, 3,15) = (/&
&2.3825E+02_JPRB,2.0847E+02_JPRB,1.7869E+02_JPRB,1.4891E+02_JPRB,1.1913E+02_JPRB,8.9345E+01_JPRB,&
&5.9563E+01_JPRB,2.9782E+01_JPRB,2.6798E+01_JPRB/)
KAO( :, 5, 3,15) = (/&
&2.9226E+02_JPRB,2.5573E+02_JPRB,2.1920E+02_JPRB,1.8266E+02_JPRB,1.4613E+02_JPRB,1.0960E+02_JPRB,&
&7.3065E+01_JPRB,3.6533E+01_JPRB,2.9446E+01_JPRB/)
KAO( :, 1, 4,15) = (/&
&1.0014E+02_JPRB,8.7619E+01_JPRB,7.5102E+01_JPRB,6.2585E+01_JPRB,5.0068E+01_JPRB,3.7551E+01_JPRB,&
&2.5034E+01_JPRB,1.5422E+01_JPRB,1.8003E+01_JPRB/)
KAO( :, 2, 4,15) = (/&
&1.3789E+02_JPRB,1.2065E+02_JPRB,1.0342E+02_JPRB,8.6180E+01_JPRB,6.8944E+01_JPRB,5.1708E+01_JPRB,&
&3.4472E+01_JPRB,1.7683E+01_JPRB,1.8158E+01_JPRB/)
KAO( :, 3, 4,15) = (/&
&1.8258E+02_JPRB,1.5976E+02_JPRB,1.3693E+02_JPRB,1.1411E+02_JPRB,9.1289E+01_JPRB,6.8467E+01_JPRB,&
&4.5645E+01_JPRB,2.2822E+01_JPRB,1.8280E+01_JPRB/)
KAO( :, 4, 4,15) = (/&
&2.3380E+02_JPRB,2.0458E+02_JPRB,1.7535E+02_JPRB,1.4613E+02_JPRB,1.1690E+02_JPRB,8.7677E+01_JPRB,&
&5.8451E+01_JPRB,2.9226E+01_JPRB,1.8394E+01_JPRB/)
KAO( :, 5, 4,15) = (/&
&2.9132E+02_JPRB,2.5490E+02_JPRB,2.1849E+02_JPRB,1.8207E+02_JPRB,1.4566E+02_JPRB,1.0924E+02_JPRB,&
&7.2830E+01_JPRB,3.6415E+01_JPRB,1.8697E+01_JPRB/)
KAO( :, 1, 5,15) = (/&
&9.0165E+01_JPRB,7.8895E+01_JPRB,6.7624E+01_JPRB,5.6353E+01_JPRB,4.5083E+01_JPRB,3.3812E+01_JPRB,&
&2.2547E+01_JPRB,1.8028E+01_JPRB,2.1110E+01_JPRB/)
KAO( :, 2, 5,15) = (/&
&1.2751E+02_JPRB,1.1157E+02_JPRB,9.5631E+01_JPRB,7.9692E+01_JPRB,6.3754E+01_JPRB,4.7815E+01_JPRB,&
&3.1877E+01_JPRB,1.9044E+01_JPRB,2.1192E+01_JPRB/)
KAO( :, 3, 5,15) = (/&
&1.7270E+02_JPRB,1.5111E+02_JPRB,1.2952E+02_JPRB,1.0794E+02_JPRB,8.6350E+01_JPRB,6.4762E+01_JPRB,&
&4.3175E+01_JPRB,2.2254E+01_JPRB,2.1273E+01_JPRB/)
KAO( :, 4, 5,15) = (/&
&2.2614E+02_JPRB,1.9787E+02_JPRB,1.6960E+02_JPRB,1.4133E+02_JPRB,1.1307E+02_JPRB,8.4801E+01_JPRB,&
&5.6534E+01_JPRB,2.8267E+01_JPRB,2.1307E+01_JPRB/)
KAO( :, 5, 5,15) = (/&
&2.8741E+02_JPRB,2.5148E+02_JPRB,2.1556E+02_JPRB,1.7963E+02_JPRB,1.4370E+02_JPRB,1.0778E+02_JPRB,&
&7.1852E+01_JPRB,3.5926E+01_JPRB,2.1269E+01_JPRB/)
KAO( :, 1, 6,15) = (/&
&7.8026E+01_JPRB,6.8273E+01_JPRB,5.8519E+01_JPRB,4.8766E+01_JPRB,3.9013E+01_JPRB,2.9260E+01_JPRB,&
&2.1248E+01_JPRB,2.1634E+01_JPRB,2.5118E+01_JPRB/)
KAO( :, 2, 6,15) = (/&
&1.1411E+02_JPRB,9.9849E+01_JPRB,8.5585E+01_JPRB,7.1321E+01_JPRB,5.7057E+01_JPRB,4.2792E+01_JPRB,&
&2.8533E+01_JPRB,2.2027E+01_JPRB,2.5242E+01_JPRB/)
KAO( :, 3, 6,15) = (/&
&1.5933E+02_JPRB,1.3941E+02_JPRB,1.1950E+02_JPRB,9.9580E+01_JPRB,7.9664E+01_JPRB,5.9748E+01_JPRB,&
&3.9832E+01_JPRB,2.3409E+01_JPRB,2.5326E+01_JPRB/)
KAO( :, 4, 6,15) = (/&
&2.1384E+02_JPRB,1.8711E+02_JPRB,1.6038E+02_JPRB,1.3365E+02_JPRB,1.0692E+02_JPRB,8.0189E+01_JPRB,&
&5.3459E+01_JPRB,2.7570E+01_JPRB,2.5371E+01_JPRB/)
KAO( :, 5, 6,15) = (/&
&2.7735E+02_JPRB,2.4268E+02_JPRB,2.0801E+02_JPRB,1.7334E+02_JPRB,1.3868E+02_JPRB,1.0401E+02_JPRB,&
&6.9338E+01_JPRB,3.4669E+01_JPRB,2.5359E+01_JPRB/)
KAO( :, 1, 7,15) = (/&
&6.5827E+01_JPRB,5.7598E+01_JPRB,4.9370E+01_JPRB,4.1142E+01_JPRB,3.2913E+01_JPRB,2.5331E+01_JPRB,&
&2.3025E+01_JPRB,2.5936E+01_JPRB,2.9970E+01_JPRB/)
KAO( :, 2, 7,15) = (/&
&1.0010E+02_JPRB,8.7584E+01_JPRB,7.5072E+01_JPRB,6.2560E+01_JPRB,5.0048E+01_JPRB,3.7536E+01_JPRB,&
&2.7016E+01_JPRB,2.6117E+01_JPRB,3.0165E+01_JPRB/)
KAO( :, 3, 7,15) = (/&
&1.4417E+02_JPRB,1.2615E+02_JPRB,1.0813E+02_JPRB,9.0105E+01_JPRB,7.2084E+01_JPRB,5.4063E+01_JPRB,&
&3.6043E+01_JPRB,2.6827E+01_JPRB,3.0311E+01_JPRB/)
KAO( :, 4, 7,15) = (/&
&1.9838E+02_JPRB,1.7359E+02_JPRB,1.4879E+02_JPRB,1.2399E+02_JPRB,9.9192E+01_JPRB,7.4394E+01_JPRB,&
&4.9596E+01_JPRB,2.8984E+01_JPRB,3.0397E+01_JPRB/)
KAO( :, 5, 7,15) = (/&
&2.6264E+02_JPRB,2.2981E+02_JPRB,1.9698E+02_JPRB,1.6415E+02_JPRB,1.3132E+02_JPRB,9.8492E+01_JPRB,&
&6.5661E+01_JPRB,3.3916E+01_JPRB,3.0409E+01_JPRB/)
KAO( :, 1, 8,15) = (/&
&5.4379E+01_JPRB,4.7581E+01_JPRB,4.0784E+01_JPRB,3.3987E+01_JPRB,2.7376E+01_JPRB,2.4616E+01_JPRB,&
&2.6821E+01_JPRB,3.1053E+01_JPRB,3.5784E+01_JPRB/)
KAO( :, 2, 8,15) = (/&
&8.6031E+01_JPRB,7.5277E+01_JPRB,6.4523E+01_JPRB,5.3770E+01_JPRB,4.3016E+01_JPRB,3.2712E+01_JPRB,&
&2.8406E+01_JPRB,3.1344E+01_JPRB,3.6100E+01_JPRB/)
KAO( :, 3, 8,15) = (/&
&1.2793E+02_JPRB,1.1194E+02_JPRB,9.5951E+01_JPRB,7.9959E+01_JPRB,6.3967E+01_JPRB,4.7975E+01_JPRB,&
&3.4121E+01_JPRB,3.1758E+01_JPRB,3.6313E+01_JPRB/)
KAO( :, 4, 8,15) = (/&
&1.8066E+02_JPRB,1.5808E+02_JPRB,1.3550E+02_JPRB,1.1291E+02_JPRB,9.0332E+01_JPRB,6.7749E+01_JPRB,&
&4.5233E+01_JPRB,3.2608E+01_JPRB,3.6463E+01_JPRB/)
KAO( :, 5, 8,15) = (/&
&2.4439E+02_JPRB,2.1384E+02_JPRB,1.8329E+02_JPRB,1.5274E+02_JPRB,1.2219E+02_JPRB,9.1646E+01_JPRB,&
&6.1097E+01_JPRB,3.5772E+01_JPRB,3.6527E+01_JPRB/)
KAO( :, 1, 9,15) = (/&
&4.3573E+01_JPRB,3.8127E+01_JPRB,3.2680E+01_JPRB,2.7311E+01_JPRB,2.5199E+01_JPRB,2.7215E+01_JPRB,&
&3.1843E+01_JPRB,3.7151E+01_JPRB,4.2720E+01_JPRB/)
KAO( :, 2, 9,15) = (/&
&7.1953E+01_JPRB,6.2959E+01_JPRB,5.3964E+01_JPRB,4.4970E+01_JPRB,3.6145E+01_JPRB,3.1469E+01_JPRB,&
&3.2757E+01_JPRB,3.7549E+01_JPRB,4.3159E+01_JPRB/)
KAO( :, 3, 9,15) = (/&
&1.1068E+02_JPRB,9.6849E+01_JPRB,8.3014E+01_JPRB,6.9178E+01_JPRB,5.5342E+01_JPRB,4.2149E+01_JPRB,&
&3.5486E+01_JPRB,3.7854E+01_JPRB,4.3494E+01_JPRB/)
KAO( :, 4, 9,15) = (/&
&1.6091E+02_JPRB,1.4079E+02_JPRB,1.2068E+02_JPRB,1.0057E+02_JPRB,8.0454E+01_JPRB,6.0340E+01_JPRB,&
&4.2919E+01_JPRB,3.8576E+01_JPRB,4.3720E+01_JPRB/)
KAO( :, 5, 9,15) = (/&
&2.2364E+02_JPRB,1.9568E+02_JPRB,1.6773E+02_JPRB,1.3977E+02_JPRB,1.1182E+02_JPRB,8.3864E+01_JPRB,&
&5.6032E+01_JPRB,3.9906E+01_JPRB,4.3837E+01_JPRB/)
KAO( :, 1,10,15) = (/&
&3.5400E+01_JPRB,3.0975E+01_JPRB,2.6550E+01_JPRB,2.4562E+01_JPRB,2.6642E+01_JPRB,3.2016E+01_JPRB,&
&3.8070E+01_JPRB,4.4415E+01_JPRB,5.0995E+01_JPRB/)
KAO( :, 2,10,15) = (/&
&6.0807E+01_JPRB,5.3206E+01_JPRB,4.5605E+01_JPRB,3.8054E+01_JPRB,3.3439E+01_JPRB,3.3829E+01_JPRB,&
&3.8722E+01_JPRB,4.4959E+01_JPRB,5.1600E+01_JPRB/)
KAO( :, 3,10,15) = (/&
&9.6798E+01_JPRB,8.4698E+01_JPRB,7.2598E+01_JPRB,6.0498E+01_JPRB,4.8510E+01_JPRB,4.0770E+01_JPRB,&
&4.0001E+01_JPRB,4.5358E+01_JPRB,5.2042E+01_JPRB/)
KAO( :, 4,10,15) = (/&
&1.4501E+02_JPRB,1.2688E+02_JPRB,1.0876E+02_JPRB,9.0630E+01_JPRB,7.2504E+01_JPRB,5.4950E+01_JPRB,&
&4.4708E+01_JPRB,4.5865E+01_JPRB,5.2368E+01_JPRB/)
KAO( :, 5,10,15) = (/&
&2.0627E+02_JPRB,1.8049E+02_JPRB,1.5470E+02_JPRB,1.2892E+02_JPRB,1.0314E+02_JPRB,7.7351E+01_JPRB,&
&5.4677E+01_JPRB,4.6645E+01_JPRB,5.2546E+01_JPRB/)
KAO( :, 1,11,15) = (/&
&3.7164E+01_JPRB,3.2519E+01_JPRB,2.8213E+01_JPRB,2.7852E+01_JPRB,3.1623E+01_JPRB,3.8446E+01_JPRB,&
&4.5726E+01_JPRB,5.3347E+01_JPRB,6.1167E+01_JPRB/)
KAO( :, 2,11,15) = (/&
&6.4161E+01_JPRB,5.6141E+01_JPRB,4.8121E+01_JPRB,4.0753E+01_JPRB,3.7907E+01_JPRB,4.0136E+01_JPRB,&
&4.6490E+01_JPRB,5.3971E+01_JPRB,6.1868E+01_JPRB/)
KAO( :, 3,11,15) = (/&
&1.0256E+02_JPRB,8.9738E+01_JPRB,7.6919E+01_JPRB,6.4099E+01_JPRB,5.2370E+01_JPRB,4.6558E+01_JPRB,&
&4.7795E+01_JPRB,5.4418E+01_JPRB,6.2373E+01_JPRB/)
KAO( :, 4,11,15) = (/&
&1.5386E+02_JPRB,1.3463E+02_JPRB,1.1539E+02_JPRB,9.6161E+01_JPRB,7.6929E+01_JPRB,6.0144E+01_JPRB,&
&5.2042E+01_JPRB,5.4998E+01_JPRB,6.2715E+01_JPRB/)
KAO( :, 5,11,15) = (/&
&2.1904E+02_JPRB,1.9166E+02_JPRB,1.6428E+02_JPRB,1.3690E+02_JPRB,1.0952E+02_JPRB,8.2243E+01_JPRB,&
&6.1497E+01_JPRB,5.5854E+01_JPRB,6.2906E+01_JPRB/)
KAO( :, 1,12,15) = (/&
&3.8871E+01_JPRB,3.4012E+01_JPRB,3.0393E+01_JPRB,3.1931E+01_JPRB,3.7660E+01_JPRB,4.6060E+01_JPRB,&
&5.4792E+01_JPRB,6.3924E+01_JPRB,7.3229E+01_JPRB/)
KAO( :, 2,12,15) = (/&
&6.7284E+01_JPRB,5.8873E+01_JPRB,5.0463E+01_JPRB,4.4214E+01_JPRB,4.3443E+01_JPRB,4.7760E+01_JPRB,&
&5.5669E+01_JPRB,6.4596E+01_JPRB,7.3985E+01_JPRB/)
KAO( :, 3,12,15) = (/&
&1.0766E+02_JPRB,9.4199E+01_JPRB,8.0742E+01_JPRB,6.7302E+01_JPRB,5.7248E+01_JPRB,5.3670E+01_JPRB,&
&5.7112E+01_JPRB,6.5078E+01_JPRB,7.4551E+01_JPRB/)
KAO( :, 4,12,15) = (/&
&1.6163E+02_JPRB,1.4143E+02_JPRB,1.2122E+02_JPRB,1.0102E+02_JPRB,8.1042E+01_JPRB,6.6522E+01_JPRB,&
&6.0901E+01_JPRB,6.5731E+01_JPRB,7.4885E+01_JPRB/)
KAO( :, 5,12,15) = (/&
&2.3044E+02_JPRB,2.0164E+02_JPRB,1.7283E+02_JPRB,1.4403E+02_JPRB,1.1522E+02_JPRB,8.7709E+01_JPRB,&
&6.9646E+01_JPRB,6.6631E+01_JPRB,7.5001E+01_JPRB/)
KAO( :, 1,13,15) = (/&
&4.0246E+01_JPRB,3.5215E+01_JPRB,3.3104E+01_JPRB,3.6905E+01_JPRB,4.4893E+01_JPRB,5.4993E+01_JPRB,&
&6.5407E+01_JPRB,7.6308E+01_JPRB,8.7364E+01_JPRB/)
KAO( :, 2,13,15) = (/&
&6.9680E+01_JPRB,6.0970E+01_JPRB,5.2454E+01_JPRB,4.8453E+01_JPRB,5.0138E+01_JPRB,5.6837E+01_JPRB,&
&6.6412E+01_JPRB,7.7026E+01_JPRB,8.8187E+01_JPRB/)
KAO( :, 3,13,15) = (/&
&1.1160E+02_JPRB,9.7650E+01_JPRB,8.3700E+01_JPRB,7.0502E+01_JPRB,6.3014E+01_JPRB,6.2089E+01_JPRB,&
&6.7983E+01_JPRB,7.7487E+01_JPRB,8.8731E+01_JPRB/)
KAO( :, 4,13,15) = (/&
&1.6767E+02_JPRB,1.4671E+02_JPRB,1.2575E+02_JPRB,1.0479E+02_JPRB,8.5648E+01_JPRB,7.3989E+01_JPRB,&
&7.1252E+01_JPRB,7.8174E+01_JPRB,8.8985E+01_JPRB/)
KAO( :, 5,13,15) = (/&
&2.3895E+02_JPRB,2.0908E+02_JPRB,1.7922E+02_JPRB,1.4935E+02_JPRB,1.1948E+02_JPRB,9.3985E+01_JPRB,&
&7.9182E+01_JPRB,7.9098E+01_JPRB,8.9007E+01_JPRB/)
KAO( :, 1, 1,16) = (/&
&1.3674E+02_JPRB,1.1964E+02_JPRB,1.0255E+02_JPRB,8.5460E+01_JPRB,6.8368E+01_JPRB,5.1276E+01_JPRB,&
&3.4184E+01_JPRB,1.7092E+01_JPRB,4.7777E+01_JPRB/)
KAO( :, 2, 1,16) = (/&
&1.7779E+02_JPRB,1.5556E+02_JPRB,1.3334E+02_JPRB,1.1112E+02_JPRB,8.8894E+01_JPRB,6.6670E+01_JPRB,&
&4.4447E+01_JPRB,2.2223E+01_JPRB,5.4515E+01_JPRB/)
KAO( :, 3, 1,16) = (/&
&2.2447E+02_JPRB,1.9641E+02_JPRB,1.6835E+02_JPRB,1.4030E+02_JPRB,1.1224E+02_JPRB,8.4177E+01_JPRB,&
&5.6118E+01_JPRB,2.8059E+01_JPRB,6.1237E+01_JPRB/)
KAO( :, 4, 1,16) = (/&
&2.7629E+02_JPRB,2.4176E+02_JPRB,2.0722E+02_JPRB,1.7268E+02_JPRB,1.3815E+02_JPRB,1.0361E+02_JPRB,&
&6.9073E+01_JPRB,3.4537E+01_JPRB,6.7881E+01_JPRB/)
KAO( :, 5, 1,16) = (/&
&3.3259E+02_JPRB,2.9102E+02_JPRB,2.4944E+02_JPRB,2.0787E+02_JPRB,1.6630E+02_JPRB,1.2472E+02_JPRB,&
&8.3148E+01_JPRB,4.1574E+01_JPRB,7.4387E+01_JPRB/)
KAO( :, 1, 2,16) = (/&
&1.4678E+02_JPRB,1.2843E+02_JPRB,1.1009E+02_JPRB,9.1739E+01_JPRB,7.3391E+01_JPRB,5.5044E+01_JPRB,&
&3.6696E+01_JPRB,1.8348E+01_JPRB,3.6081E+01_JPRB/)
KAO( :, 2, 2,16) = (/&
&1.9364E+02_JPRB,1.6943E+02_JPRB,1.4523E+02_JPRB,1.2102E+02_JPRB,9.6819E+01_JPRB,7.2614E+01_JPRB,&
&4.8409E+01_JPRB,2.4205E+01_JPRB,4.1498E+01_JPRB/)
KAO( :, 3, 2,16) = (/&
&2.4749E+02_JPRB,2.1655E+02_JPRB,1.8562E+02_JPRB,1.5468E+02_JPRB,1.2374E+02_JPRB,9.2808E+01_JPRB,&
&6.1872E+01_JPRB,3.0936E+01_JPRB,4.6929E+01_JPRB/)
KAO( :, 4, 2,16) = (/&
&3.0786E+02_JPRB,2.6938E+02_JPRB,2.3089E+02_JPRB,1.9241E+02_JPRB,1.5393E+02_JPRB,1.1545E+02_JPRB,&
&7.6965E+01_JPRB,3.8482E+01_JPRB,5.2308E+01_JPRB/)
KAO( :, 5, 2,16) = (/&
&3.7405E+02_JPRB,3.2730E+02_JPRB,2.8054E+02_JPRB,2.3378E+02_JPRB,1.8703E+02_JPRB,1.4027E+02_JPRB,&
&9.3513E+01_JPRB,4.6757E+01_JPRB,5.7603E+01_JPRB/)
KAO( :, 1, 3,16) = (/&
&1.4770E+02_JPRB,1.2924E+02_JPRB,1.1078E+02_JPRB,9.2315E+01_JPRB,7.3852E+01_JPRB,5.5389E+01_JPRB,&
&3.6926E+01_JPRB,1.8463E+01_JPRB,2.0017E+01_JPRB/)
KAO( :, 2, 3,16) = (/&
&1.9922E+02_JPRB,1.7432E+02_JPRB,1.4941E+02_JPRB,1.2451E+02_JPRB,9.9609E+01_JPRB,7.4707E+01_JPRB,&
&4.9805E+01_JPRB,2.4902E+01_JPRB,2.3072E+01_JPRB/)
KAO( :, 3, 3,16) = (/&
&2.5951E+02_JPRB,2.2707E+02_JPRB,1.9463E+02_JPRB,1.6219E+02_JPRB,1.2975E+02_JPRB,9.7315E+01_JPRB,&
&6.4877E+01_JPRB,3.2438E+01_JPRB,2.6326E+01_JPRB/)
KAO( :, 4, 3,16) = (/&
&3.2798E+02_JPRB,2.8698E+02_JPRB,2.4598E+02_JPRB,2.0498E+02_JPRB,1.6399E+02_JPRB,1.2299E+02_JPRB,&
&8.1994E+01_JPRB,4.0997E+01_JPRB,2.9574E+01_JPRB/)
KAO( :, 5, 3,16) = (/&
&4.0406E+02_JPRB,3.5355E+02_JPRB,3.0305E+02_JPRB,2.5254E+02_JPRB,2.0203E+02_JPRB,1.5152E+02_JPRB,&
&1.0102E+02_JPRB,5.0508E+01_JPRB,3.2777E+01_JPRB/)
KAO( :, 1, 4,16) = (/&
&1.4422E+02_JPRB,1.2619E+02_JPRB,1.0816E+02_JPRB,9.0137E+01_JPRB,7.2109E+01_JPRB,5.4082E+01_JPRB,&
&3.6055E+01_JPRB,1.8027E+01_JPRB,1.8526E+01_JPRB/)
KAO( :, 2, 4,16) = (/&
&1.9978E+02_JPRB,1.7481E+02_JPRB,1.4983E+02_JPRB,1.2486E+02_JPRB,9.9890E+01_JPRB,7.4917E+01_JPRB,&
&4.9945E+01_JPRB,2.4972E+01_JPRB,1.9155E+01_JPRB/)
KAO( :, 3, 4,16) = (/&
&2.6597E+02_JPRB,2.3273E+02_JPRB,1.9948E+02_JPRB,1.6623E+02_JPRB,1.3299E+02_JPRB,9.9740E+01_JPRB,&
&6.6493E+01_JPRB,3.3247E+01_JPRB,1.9814E+01_JPRB/)
KAO( :, 4, 4,16) = (/&
&3.4257E+02_JPRB,2.9975E+02_JPRB,2.5693E+02_JPRB,2.1411E+02_JPRB,1.7128E+02_JPRB,1.2846E+02_JPRB,&
&8.5642E+01_JPRB,4.2821E+01_JPRB,2.0371E+01_JPRB/)
KAO( :, 5, 4,16) = (/&
&4.2875E+02_JPRB,3.7515E+02_JPRB,3.2156E+02_JPRB,2.6797E+02_JPRB,2.1437E+02_JPRB,1.6078E+02_JPRB,&
&1.0719E+02_JPRB,5.3593E+01_JPRB,2.0835E+01_JPRB/)
KAO( :, 1, 5,16) = (/&
&1.3899E+02_JPRB,1.2162E+02_JPRB,1.0425E+02_JPRB,8.6871E+01_JPRB,6.9497E+01_JPRB,5.2123E+01_JPRB,&
&3.4748E+01_JPRB,1.8596E+01_JPRB,2.1711E+01_JPRB/)
KAO( :, 2, 5,16) = (/&
&1.9805E+02_JPRB,1.7329E+02_JPRB,1.4854E+02_JPRB,1.2378E+02_JPRB,9.9025E+01_JPRB,7.4269E+01_JPRB,&
&4.9513E+01_JPRB,2.4756E+01_JPRB,2.1848E+01_JPRB/)
KAO( :, 3, 5,16) = (/&
&2.7005E+02_JPRB,2.3630E+02_JPRB,2.0254E+02_JPRB,1.6878E+02_JPRB,1.3503E+02_JPRB,1.0127E+02_JPRB,&
&6.7514E+01_JPRB,3.3757E+01_JPRB,2.1967E+01_JPRB/)
KAO( :, 4, 5,16) = (/&
&3.5478E+02_JPRB,3.1044E+02_JPRB,2.6609E+02_JPRB,2.2174E+02_JPRB,1.7739E+02_JPRB,1.3304E+02_JPRB,&
&8.8696E+01_JPRB,4.4348E+01_JPRB,2.2139E+01_JPRB/)
KAO( :, 5, 5,16) = (/&
&4.5175E+02_JPRB,3.9528E+02_JPRB,3.3881E+02_JPRB,2.8234E+02_JPRB,2.2588E+02_JPRB,1.6941E+02_JPRB,&
&1.1294E+02_JPRB,5.6469E+01_JPRB,2.2377E+01_JPRB/)
KAO( :, 1, 6,16) = (/&
&1.3013E+02_JPRB,1.1386E+02_JPRB,9.7595E+01_JPRB,8.1329E+01_JPRB,6.5064E+01_JPRB,4.8798E+01_JPRB,&
&3.2532E+01_JPRB,2.2484E+01_JPRB,2.6076E+01_JPRB/)
KAO( :, 2, 6,16) = (/&
&1.9160E+02_JPRB,1.6765E+02_JPRB,1.4370E+02_JPRB,1.1975E+02_JPRB,9.5800E+01_JPRB,7.1850E+01_JPRB,&
&4.7900E+01_JPRB,2.3950E+01_JPRB,2.6232E+01_JPRB/)
KAO( :, 3, 6,16) = (/&
&2.6831E+02_JPRB,2.3477E+02_JPRB,2.0123E+02_JPRB,1.6769E+02_JPRB,1.3415E+02_JPRB,1.0061E+02_JPRB,&
&6.7076E+01_JPRB,3.3538E+01_JPRB,2.6352E+01_JPRB/)
KAO( :, 4, 6,16) = (/&
&3.6064E+02_JPRB,3.1556E+02_JPRB,2.7048E+02_JPRB,2.2540E+02_JPRB,1.8032E+02_JPRB,1.3524E+02_JPRB,&
&9.0160E+01_JPRB,4.5080E+01_JPRB,2.6414E+01_JPRB/)
KAO( :, 5, 6,16) = (/&
&4.6794E+02_JPRB,4.0944E+02_JPRB,3.5095E+02_JPRB,2.9246E+02_JPRB,2.3397E+02_JPRB,1.7548E+02_JPRB,&
&1.1698E+02_JPRB,5.8492E+01_JPRB,2.6392E+01_JPRB/)
KAO( :, 1, 7,16) = (/&
&1.1956E+02_JPRB,1.0461E+02_JPRB,8.9667E+01_JPRB,7.4722E+01_JPRB,5.9778E+01_JPRB,4.4833E+01_JPRB,&
&2.9889E+01_JPRB,2.7199E+01_JPRB,3.1421E+01_JPRB/)
KAO( :, 2, 7,16) = (/&
&1.8238E+02_JPRB,1.5958E+02_JPRB,1.3678E+02_JPRB,1.1398E+02_JPRB,9.1188E+01_JPRB,6.8391E+01_JPRB,&
&4.5594E+01_JPRB,2.7417E+01_JPRB,3.1636E+01_JPRB/)
KAO( :, 3, 7,16) = (/&
&2.6306E+02_JPRB,2.3018E+02_JPRB,1.9730E+02_JPRB,1.6441E+02_JPRB,1.3153E+02_JPRB,9.8648E+01_JPRB,&
&6.5766E+01_JPRB,3.2883E+01_JPRB,3.1799E+01_JPRB/)
KAO( :, 4, 7,16) = (/&
&3.6216E+02_JPRB,3.1689E+02_JPRB,2.7162E+02_JPRB,2.2635E+02_JPRB,1.8108E+02_JPRB,1.3581E+02_JPRB,&
&9.0539E+01_JPRB,4.5269E+01_JPRB,3.1905E+01_JPRB/)
KAO( :, 5, 7,16) = (/&
&4.7940E+02_JPRB,4.1947E+02_JPRB,3.5955E+02_JPRB,2.9962E+02_JPRB,2.3970E+02_JPRB,1.7977E+02_JPRB,&
&1.1985E+02_JPRB,5.9925E+01_JPRB,3.1925E+01_JPRB/)
KAO( :, 1, 8,16) = (/&
&1.0811E+02_JPRB,9.4599E+01_JPRB,8.1085E+01_JPRB,6.7571E+01_JPRB,5.4057E+01_JPRB,4.0543E+01_JPRB,&
&2.8198E+01_JPRB,3.2881E+01_JPRB,3.7875E+01_JPRB/)
KAO( :, 2, 8,16) = (/&
&1.7137E+02_JPRB,1.4995E+02_JPRB,1.2853E+02_JPRB,1.0711E+02_JPRB,8.5687E+01_JPRB,6.4265E+01_JPRB,&
&4.2843E+01_JPRB,3.3181E+01_JPRB,3.8195E+01_JPRB/)
KAO( :, 3, 8,16) = (/&
&2.5494E+02_JPRB,2.2307E+02_JPRB,1.9121E+02_JPRB,1.5934E+02_JPRB,1.2747E+02_JPRB,9.5603E+01_JPRB,&
&6.3736E+01_JPRB,3.3454E+01_JPRB,3.8440E+01_JPRB/)
KAO( :, 4, 8,16) = (/&
&3.5993E+02_JPRB,3.1494E+02_JPRB,2.6995E+02_JPRB,2.2496E+02_JPRB,1.7997E+02_JPRB,1.3498E+02_JPRB,&
&8.9984E+01_JPRB,4.4992E+01_JPRB,3.8593E+01_JPRB/)
KAO( :, 5, 8,16) = (/&
&4.8664E+02_JPRB,4.2581E+02_JPRB,3.6498E+02_JPRB,3.0415E+02_JPRB,2.4332E+02_JPRB,1.8249E+02_JPRB,&
&1.2166E+02_JPRB,6.0830E+01_JPRB,3.8660E+01_JPRB/)
KAO( :, 1, 9,16) = (/&
&9.5566E+01_JPRB,8.3620E+01_JPRB,7.1674E+01_JPRB,5.9728E+01_JPRB,4.7783E+01_JPRB,3.5837E+01_JPRB,&
&3.4022E+01_JPRB,3.9693E+01_JPRB,4.5621E+01_JPRB/)
KAO( :, 2, 9,16) = (/&
&1.5795E+02_JPRB,1.3820E+02_JPRB,1.1846E+02_JPRB,9.8717E+01_JPRB,7.8974E+01_JPRB,5.9230E+01_JPRB,&
&3.9487E+01_JPRB,4.0126E+01_JPRB,4.6102E+01_JPRB/)
KAO( :, 3, 9,16) = (/&
&2.4293E+02_JPRB,2.1257E+02_JPRB,1.8220E+02_JPRB,1.5183E+02_JPRB,1.2147E+02_JPRB,9.1099E+01_JPRB,&
&6.0733E+01_JPRB,4.0455E+01_JPRB,4.6460E+01_JPRB/)
KAO( :, 4, 9,16) = (/&
&3.5246E+02_JPRB,3.0840E+02_JPRB,2.6435E+02_JPRB,2.2029E+02_JPRB,1.7623E+02_JPRB,1.3217E+02_JPRB,&
&8.8115E+01_JPRB,4.4330E+01_JPRB,4.6688E+01_JPRB/)
KAO( :, 5, 9,16) = (/&
&4.8730E+02_JPRB,4.2639E+02_JPRB,3.6548E+02_JPRB,3.0456E+02_JPRB,2.4365E+02_JPRB,1.8274E+02_JPRB,&
&1.2183E+02_JPRB,6.0913E+01_JPRB,4.6814E+01_JPRB/)
KAO( :, 1,10,16) = (/&
&8.6364E+01_JPRB,7.5568E+01_JPRB,6.4773E+01_JPRB,5.3977E+01_JPRB,4.3182E+01_JPRB,3.4440E+01_JPRB,&
&4.1088E+01_JPRB,4.7936E+01_JPRB,5.5004E+01_JPRB/)
KAO( :, 2,10,16) = (/&
&1.4833E+02_JPRB,1.2979E+02_JPRB,1.1125E+02_JPRB,9.2705E+01_JPRB,7.4164E+01_JPRB,5.5623E+01_JPRB,&
&4.1568E+01_JPRB,4.8496E+01_JPRB,5.5636E+01_JPRB/)
KAO( :, 3,10,16) = (/&
&2.3518E+02_JPRB,2.0578E+02_JPRB,1.7638E+02_JPRB,1.4699E+02_JPRB,1.1759E+02_JPRB,8.8191E+01_JPRB,&
&5.8794E+01_JPRB,4.8955E+01_JPRB,5.6147E+01_JPRB/)
KAO( :, 4,10,16) = (/&
&3.4963E+02_JPRB,3.0592E+02_JPRB,2.6222E+02_JPRB,2.1852E+02_JPRB,1.7481E+02_JPRB,1.3111E+02_JPRB,&
&8.7406E+01_JPRB,4.9235E+01_JPRB,5.6450E+01_JPRB/)
KAO( :, 5,10,16) = (/&
&4.9302E+02_JPRB,4.3139E+02_JPRB,3.6977E+02_JPRB,3.0814E+02_JPRB,2.4651E+02_JPRB,1.8488E+02_JPRB,&
&1.2326E+02_JPRB,6.1628E+01_JPRB,5.6644E+01_JPRB/)
KAO( :, 1,11,16) = (/&
&1.0149E+02_JPRB,8.8804E+01_JPRB,7.6118E+01_JPRB,6.3431E+01_JPRB,5.0745E+01_JPRB,4.1772E+01_JPRB,&
&4.9883E+01_JPRB,5.8197E+01_JPRB,6.6698E+01_JPRB/)
KAO( :, 2,11,16) = (/&
&1.7380E+02_JPRB,1.5208E+02_JPRB,1.3035E+02_JPRB,1.0863E+02_JPRB,8.6902E+01_JPRB,6.5176E+01_JPRB,&
&5.0425E+01_JPRB,5.8829E+01_JPRB,6.7412E+01_JPRB/)
KAO( :, 3,11,16) = (/&
&2.7485E+02_JPRB,2.4050E+02_JPRB,2.0614E+02_JPRB,1.7178E+02_JPRB,1.3743E+02_JPRB,1.0307E+02_JPRB,&
&6.8713E+01_JPRB,5.9345E+01_JPRB,6.7990E+01_JPRB/)
KAO( :, 4,11,16) = (/&
&4.0747E+02_JPRB,3.5653E+02_JPRB,3.0560E+02_JPRB,2.5467E+02_JPRB,2.0373E+02_JPRB,1.5280E+02_JPRB,&
&1.0187E+02_JPRB,5.9645E+01_JPRB,6.8320E+01_JPRB/)
KAO( :, 5,11,16) = (/&
&5.7295E+02_JPRB,5.0133E+02_JPRB,4.2971E+02_JPRB,3.5809E+02_JPRB,2.8648E+02_JPRB,2.1486E+02_JPRB,&
&1.4324E+02_JPRB,7.2192E+01_JPRB,6.8483E+01_JPRB/)
KAO( :, 1,12,16) = (/&
&1.1827E+02_JPRB,1.0349E+02_JPRB,8.8705E+01_JPRB,7.3921E+01_JPRB,5.9137E+01_JPRB,5.0630E+01_JPRB,&
&6.0438E+01_JPRB,7.0510E+01_JPRB,8.0746E+01_JPRB/)
KAO( :, 2,12,16) = (/&
&2.0179E+02_JPRB,1.7656E+02_JPRB,1.5134E+02_JPRB,1.2612E+02_JPRB,1.0089E+02_JPRB,7.5670E+01_JPRB,&
&6.1072E+01_JPRB,7.1251E+01_JPRB,8.1581E+01_JPRB/)
KAO( :, 3,12,16) = (/&
&3.1798E+02_JPRB,2.7824E+02_JPRB,2.3849E+02_JPRB,1.9874E+02_JPRB,1.5899E+02_JPRB,1.1924E+02_JPRB,&
&7.9796E+01_JPRB,7.1750E+01_JPRB,8.2143E+01_JPRB/)
KAO( :, 4,12,16) = (/&
&4.7106E+02_JPRB,4.1218E+02_JPRB,3.5330E+02_JPRB,2.9441E+02_JPRB,2.3553E+02_JPRB,1.7665E+02_JPRB,&
&1.1777E+02_JPRB,7.2076E+01_JPRB,8.2504E+01_JPRB/)
KAO( :, 5,12,16) = (/&
&6.6390E+02_JPRB,5.8091E+02_JPRB,4.9792E+02_JPRB,4.1494E+02_JPRB,3.3195E+02_JPRB,2.4896E+02_JPRB,&
&1.6597E+02_JPRB,8.4840E+01_JPRB,8.2551E+01_JPRB/)
KAO( :, 1,13,16) = (/&
&1.3595E+02_JPRB,1.1896E+02_JPRB,1.0196E+02_JPRB,8.4968E+01_JPRB,6.8087E+01_JPRB,6.1225E+01_JPRB,&
&7.3041E+01_JPRB,8.5214E+01_JPRB,9.7532E+01_JPRB/)
KAO( :, 2,13,16) = (/&
&2.3178E+02_JPRB,2.0280E+02_JPRB,1.7383E+02_JPRB,1.4486E+02_JPRB,1.1589E+02_JPRB,8.6916E+01_JPRB,&
&7.3742E+01_JPRB,8.6032E+01_JPRB,9.8456E+01_JPRB/)
KAO( :, 3,13,16) = (/&
&3.6636E+02_JPRB,3.2056E+02_JPRB,2.7477E+02_JPRB,2.2897E+02_JPRB,1.8318E+02_JPRB,1.3738E+02_JPRB,&
&9.2837E+01_JPRB,8.6498E+01_JPRB,9.8980E+01_JPRB/)
KAO( :, 4,13,16) = (/&
&5.4438E+02_JPRB,4.7633E+02_JPRB,4.0829E+02_JPRB,3.4024E+02_JPRB,2.7219E+02_JPRB,2.0414E+02_JPRB,&
&1.3610E+02_JPRB,8.6750E+01_JPRB,9.9251E+01_JPRB/)
KAO( :, 5,13,16) = (/&
&7.6815E+02_JPRB,6.7213E+02_JPRB,5.7611E+02_JPRB,4.8009E+02_JPRB,3.8407E+02_JPRB,2.8805E+02_JPRB,&
&1.9204E+02_JPRB,9.9763E+01_JPRB,9.9159E+01_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB15_A2
