!OCL SCALAR
SUBROUTINE RRTM_KGB15_00

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 15:  2380-2600 cm-1 (low - N2O,CO2; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO15, ONLY : KAO     ,SELFREFO   ,FRACREFAO
USE YOERRTA15, ONLY : STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE
STRRAT = 0.2883201_JPRB

!     ------------------------------------------------------------------

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
&1.72146E-03_JPRB, 1.41213E-03_JPRB, 1.15839E-03_JPRB, 9.50236E-04_JPRB, 7.79489E-04_JPRB,&
&6.39423E-04_JPRB, 5.24525E-04_JPRB, 4.30274E-04_JPRB, 3.52958E-04_JPRB, 2.89535E-04_JPRB/)
SELFREFO( :, 2) = (/&
&1.83092E-03_JPRB, 1.50082E-03_JPRB, 1.23023E-03_JPRB, 1.00843E-03_JPRB, 8.26611E-04_JPRB,&
&6.77578E-04_JPRB, 5.55414E-04_JPRB, 4.55276E-04_JPRB, 3.73192E-04_JPRB, 3.05908E-04_JPRB/)
SELFREFO( :, 3) = (/&
&1.92620E-03_JPRB, 1.57871E-03_JPRB, 1.29391E-03_JPRB, 1.06048E-03_JPRB, 8.69169E-04_JPRB,&
&7.12370E-04_JPRB, 5.83857E-04_JPRB, 4.78528E-04_JPRB, 3.92201E-04_JPRB, 3.21447E-04_JPRB/)
SELFREFO( :, 4) = (/&
&2.11224E-03_JPRB, 1.72966E-03_JPRB, 1.41638E-03_JPRB, 1.15984E-03_JPRB, 9.49760E-04_JPRB,&
&7.77734E-04_JPRB, 6.36867E-04_JPRB, 5.21514E-04_JPRB, 4.27055E-04_JPRB, 3.49704E-04_JPRB/)
SELFREFO( :, 5) = (/&
&2.31367E-03_JPRB, 1.88988E-03_JPRB, 1.54371E-03_JPRB, 1.26095E-03_JPRB, 1.02999E-03_JPRB,&
&8.41325E-04_JPRB, 6.87221E-04_JPRB, 5.61344E-04_JPRB, 4.58523E-04_JPRB, 3.74536E-04_JPRB/)
SELFREFO( :, 6) = (/&
&2.47614E-03_JPRB, 2.03107E-03_JPRB, 1.66599E-03_JPRB, 1.36654E-03_JPRB, 1.12091E-03_JPRB,&
&9.19433E-04_JPRB, 7.54170E-04_JPRB, 6.18612E-04_JPRB, 5.07419E-04_JPRB, 4.16213E-04_JPRB/)
SELFREFO( :, 7) = (/&
&2.55137E-03_JPRB, 2.10353E-03_JPRB, 1.73430E-03_JPRB, 1.42987E-03_JPRB, 1.17889E-03_JPRB,&
&9.71958E-04_JPRB, 8.01350E-04_JPRB, 6.60688E-04_JPRB, 5.44717E-04_JPRB, 4.49103E-04_JPRB/)
SELFREFO( :, 8) = (/&
&2.59317E-03_JPRB, 2.13957E-03_JPRB, 1.76532E-03_JPRB, 1.45653E-03_JPRB, 1.20175E-03_JPRB,&
&9.91539E-04_JPRB, 8.18098E-04_JPRB, 6.74996E-04_JPRB, 5.56926E-04_JPRB, 4.59508E-04_JPRB/)
SELFREFO( :, 9) = (/&
&2.83495E-03_JPRB, 2.34704E-03_JPRB, 1.94309E-03_JPRB, 1.60867E-03_JPRB, 1.33181E-03_JPRB,&
&1.10259E-03_JPRB, 9.12826E-04_JPRB, 7.55721E-04_JPRB, 6.25656E-04_JPRB, 5.17975E-04_JPRB/)
SELFREFO( :,10) = (/&
&2.98196E-03_JPRB, 2.46746E-03_JPRB, 2.04173E-03_JPRB, 1.68946E-03_JPRB, 1.39796E-03_JPRB,&
&1.15676E-03_JPRB, 9.57177E-04_JPRB, 7.92028E-04_JPRB, 6.55373E-04_JPRB, 5.42297E-04_JPRB/)
SELFREFO( :,11) = (/&
&2.98241E-03_JPRB, 2.46776E-03_JPRB, 2.04191E-03_JPRB, 1.68955E-03_JPRB, 1.39800E-03_JPRB,&
&1.15675E-03_JPRB, 9.57141E-04_JPRB, 7.91974E-04_JPRB, 6.55308E-04_JPRB, 5.42226E-04_JPRB/)
SELFREFO( :,12) = (/&
&2.97837E-03_JPRB, 2.46464E-03_JPRB, 2.03952E-03_JPRB, 1.68773E-03_JPRB, 1.39662E-03_JPRB,&
&1.15572E-03_JPRB, 9.56375E-04_JPRB, 7.91413E-04_JPRB, 6.54904E-04_JPRB, 5.41942E-04_JPRB/)
SELFREFO( :,13) = (/&
&2.97777E-03_JPRB, 2.46461E-03_JPRB, 2.03989E-03_JPRB, 1.68835E-03_JPRB, 1.39740E-03_JPRB,&
&1.15659E-03_JPRB, 9.57271E-04_JPRB, 7.92305E-04_JPRB, 6.55767E-04_JPRB, 5.42759E-04_JPRB/)
SELFREFO( :,14) = (/&
&2.98331E-03_JPRB, 2.46947E-03_JPRB, 2.04413E-03_JPRB, 1.69205E-03_JPRB, 1.40061E-03_JPRB,&
&1.15937E-03_JPRB, 9.59683E-04_JPRB, 7.94388E-04_JPRB, 6.57564E-04_JPRB, 5.44306E-04_JPRB/)
SELFREFO( :,15) = (/&
&2.99414E-03_JPRB, 2.47830E-03_JPRB, 2.05133E-03_JPRB, 1.69792E-03_JPRB, 1.40540E-03_JPRB,&
&1.16328E-03_JPRB, 9.62863E-04_JPRB, 7.96978E-04_JPRB, 6.59673E-04_JPRB, 5.46023E-04_JPRB/)
SELFREFO( :,16) = (/&
&3.00006E-03_JPRB, 2.48297E-03_JPRB, 2.05501E-03_JPRB, 1.70081E-03_JPRB, 1.40766E-03_JPRB,&
&1.16503E-03_JPRB, 9.64227E-04_JPRB, 7.98033E-04_JPRB, 6.60484E-04_JPRB, 5.46643E-04_JPRB/)

FRACREFAO( :, 1) = (/&
!     From P = 1053.6 mb.
    &0.11287100_JPRB,0.12070200_JPRB,0.12729000_JPRB,0.12858100_JPRB,&
    &0.12743001_JPRB,0.11961800_JPRB,0.10290400_JPRB,0.07888980_JPRB,&
    &0.05900120_JPRB,0.00667979_JPRB,0.00552926_JPRB,0.00436993_JPRB,&
    &0.00320611_JPRB,0.00204765_JPRB,0.00077371_JPRB,0.00010894_JPRB/)
FRACREFAO( :, 2) = (/&
    &0.13918801_JPRB,0.16353001_JPRB,0.16155800_JPRB,0.14090499_JPRB,&
    &0.11322300_JPRB,0.08757720_JPRB,0.07225720_JPRB,0.05173390_JPRB,&
    &0.04731360_JPRB,0.00667979_JPRB,0.00552926_JPRB,0.00436993_JPRB,&
    &0.00320611_JPRB,0.00204765_JPRB,0.00077371_JPRB,0.00010894_JPRB/)
FRACREFAO( :, 3) = (/&
    &0.14687300_JPRB,0.17853101_JPRB,0.15664500_JPRB,0.13351700_JPRB,&
    &0.10791200_JPRB,0.08684320_JPRB,0.07158090_JPRB,0.05198410_JPRB,&
    &0.04340110_JPRB,0.00667979_JPRB,0.00552926_JPRB,0.00436993_JPRB,&
    &0.00320611_JPRB,0.00204765_JPRB,0.00077371_JPRB,0.00010894_JPRB/)
FRACREFAO( :, 4) = (/&
    &0.15760700_JPRB,0.17759100_JPRB,0.15158001_JPRB,0.13193300_JPRB,&
    &0.10742800_JPRB,0.08693760_JPRB,0.07159490_JPRB,0.05196250_JPRB,&
    &0.04065270_JPRB,0.00667979_JPRB,0.00552926_JPRB,0.00436993_JPRB,&
    &0.00320611_JPRB,0.00204765_JPRB,0.00077371_JPRB,0.00010894_JPRB/)
FRACREFAO( :, 5) = (/&
    &0.16646700_JPRB,0.17299300_JPRB,0.15018500_JPRB,0.13138700_JPRB,&
    &0.10735900_JPRB,0.08713110_JPRB,0.07130330_JPRB,0.05279420_JPRB,&
    &0.03766730_JPRB,0.00667979_JPRB,0.00552926_JPRB,0.00436993_JPRB,&
    &0.00320611_JPRB,0.00204765_JPRB,0.00077371_JPRB,0.00010894_JPRB/)
FRACREFAO( :, 6) = (/&
    &0.17546000_JPRB,0.16666500_JPRB,0.14969499_JPRB,0.13105400_JPRB,&
    &0.10782500_JPRB,0.08718610_JPRB,0.07156770_JPRB,0.05308320_JPRB,&
    &0.03753960_JPRB,0.00432465_JPRB,0.00509623_JPRB,0.00436993_JPRB,&
    &0.00320611_JPRB,0.00204765_JPRB,0.00077371_JPRB,0.00010894_JPRB/)
FRACREFAO( :, 7) = (/&
    &0.18378501_JPRB,0.16064601_JPRB,0.14940400_JPRB,0.13146400_JPRB,&
    &0.10810300_JPRB,0.08775740_JPRB,0.07115360_JPRB,0.05400040_JPRB,&
    &0.03689970_JPRB,0.00388333_JPRB,0.00323610_JPRB,0.00353414_JPRB,&
    &0.00320611_JPRB,0.00204765_JPRB,0.00077371_JPRB,0.00010894_JPRB/)
FRACREFAO( :, 8) = (/&
    &0.18966800_JPRB,0.15744300_JPRB,0.14993000_JPRB,0.13152599_JPRB,&
    &0.10899200_JPRB,0.08858690_JPRB,0.07142920_JPRB,0.05399600_JPRB,&
    &0.03433460_JPRB,0.00374886_JPRB,0.00302066_JPRB,0.00240653_JPRB,&
    &0.00199205_JPRB,0.00204765_JPRB,0.00077371_JPRB,0.00010894_JPRB/)
FRACREFAO( :, 9) = (/&
    &0.11887100_JPRB,0.12479600_JPRB,0.12569501_JPRB,0.12839900_JPRB,&
    &0.12473500_JPRB,0.12012800_JPRB,0.11086700_JPRB,0.08493590_JPRB,&
    &0.05063770_JPRB,0.00328723_JPRB,0.00266849_JPRB,0.00210232_JPRB,&
    &0.00152114_JPRB,0.00095635_JPRB,0.00035374_JPRB,0.00004980_JPRB/)

!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB15_00
