!OCL SCALAR
SUBROUTINE RRTM_KGB13_A2

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 13:  2080-2250 cm-1 (low - H2O,N2O; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO13, ONLY : KAO     ,SELFREFO   ,FRACREFAO
USE YOERRTA13, ONLY : STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 9) = (/&
&1.9029E-02_JPRB,1.6853E-02_JPRB,1.4735E-02_JPRB,1.2587E-02_JPRB,1.0467E-02_JPRB,8.5540E-03_JPRB,&
&6.8482E-03_JPRB,5.4691E-03_JPRB,7.2696E-03_JPRB/)
KAO( :, 2, 1, 9) = (/&
&2.0092E-02_JPRB,1.7878E-02_JPRB,1.5728E-02_JPRB,1.3580E-02_JPRB,1.1524E-02_JPRB,9.7463E-03_JPRB,&
&8.1292E-03_JPRB,6.9002E-03_JPRB,9.2265E-03_JPRB/)
KAO( :, 3, 1, 9) = (/&
&2.1289E-02_JPRB,1.9078E-02_JPRB,1.6951E-02_JPRB,1.4803E-02_JPRB,1.2902E-02_JPRB,1.1235E-02_JPRB,&
&9.7244E-03_JPRB,8.5896E-03_JPRB,1.1472E-02_JPRB/)
KAO( :, 4, 1, 9) = (/&
&2.2660E-02_JPRB,2.0471E-02_JPRB,1.8401E-02_JPRB,1.6346E-02_JPRB,1.4609E-02_JPRB,1.3016E-02_JPRB,&
&1.1621E-02_JPRB,1.0516E-02_JPRB,1.4012E-02_JPRB/)
KAO( :, 5, 1, 9) = (/&
&2.4197E-02_JPRB,2.2063E-02_JPRB,2.0065E-02_JPRB,1.8209E-02_JPRB,1.6609E-02_JPRB,1.5079E-02_JPRB,&
&1.3788E-02_JPRB,1.2665E-02_JPRB,1.6825E-02_JPRB/)
KAO( :, 1, 2, 9) = (/&
&1.9742E-02_JPRB,1.7478E-02_JPRB,1.5268E-02_JPRB,1.3020E-02_JPRB,1.0794E-02_JPRB,8.7264E-03_JPRB,&
&6.7494E-03_JPRB,5.0072E-03_JPRB,7.5472E-03_JPRB/)
KAO( :, 2, 2, 9) = (/&
&2.0752E-02_JPRB,1.8451E-02_JPRB,1.6203E-02_JPRB,1.3921E-02_JPRB,1.1711E-02_JPRB,9.7269E-03_JPRB,&
&7.8214E-03_JPRB,6.2435E-03_JPRB,9.6127E-03_JPRB/)
KAO( :, 3, 2, 9) = (/&
&2.1850E-02_JPRB,1.9539E-02_JPRB,1.7284E-02_JPRB,1.4968E-02_JPRB,1.2893E-02_JPRB,1.0990E-02_JPRB,&
&9.1753E-03_JPRB,7.7563E-03_JPRB,1.2009E-02_JPRB/)
KAO( :, 4, 2, 9) = (/&
&2.3047E-02_JPRB,2.0746E-02_JPRB,1.8528E-02_JPRB,1.6289E-02_JPRB,1.4365E-02_JPRB,1.2522E-02_JPRB,&
&1.0820E-02_JPRB,9.5216E-03_JPRB,1.4733E-02_JPRB/)
KAO( :, 5, 2, 9) = (/&
&2.4378E-02_JPRB,2.2145E-02_JPRB,1.9963E-02_JPRB,1.7904E-02_JPRB,1.6106E-02_JPRB,1.4326E-02_JPRB,&
&1.2781E-02_JPRB,1.1538E-02_JPRB,1.7764E-02_JPRB/)
KAO( :, 1, 3, 9) = (/&
&2.0246E-02_JPRB,1.7907E-02_JPRB,1.5619E-02_JPRB,1.3303E-02_JPRB,1.1014E-02_JPRB,8.8212E-03_JPRB,&
&6.6585E-03_JPRB,4.5305E-03_JPRB,9.1026E-03_JPRB/)
KAO( :, 2, 3, 9) = (/&
&2.1216E-02_JPRB,1.8847E-02_JPRB,1.6535E-02_JPRB,1.4182E-02_JPRB,1.1869E-02_JPRB,9.7020E-03_JPRB,&
&7.5117E-03_JPRB,5.5113E-03_JPRB,1.1552E-02_JPRB/)
KAO( :, 3, 3, 9) = (/&
&2.2286E-02_JPRB,1.9902E-02_JPRB,1.7571E-02_JPRB,1.5169E-02_JPRB,1.2921E-02_JPRB,1.0740E-02_JPRB,&
&8.6112E-03_JPRB,6.7529E-03_JPRB,1.4497E-02_JPRB/)
KAO( :, 4, 3, 9) = (/&
&2.3424E-02_JPRB,2.1046E-02_JPRB,1.8711E-02_JPRB,1.6326E-02_JPRB,1.4157E-02_JPRB,1.2014E-02_JPRB,&
&9.9676E-03_JPRB,8.2723E-03_JPRB,1.7885E-02_JPRB/)
KAO( :, 5, 3, 9) = (/&
&2.4644E-02_JPRB,2.2304E-02_JPRB,1.9954E-02_JPRB,1.7680E-02_JPRB,1.5613E-02_JPRB,1.3543E-02_JPRB,&
&1.1603E-02_JPRB,1.0079E-02_JPRB,2.1675E-02_JPRB/)
KAO( :, 1, 4, 9) = (/&
&2.0516E-02_JPRB,1.8121E-02_JPRB,1.5769E-02_JPRB,1.3411E-02_JPRB,1.1085E-02_JPRB,8.8389E-03_JPRB,&
&6.5833E-03_JPRB,4.2076E-03_JPRB,1.2881E-02_JPRB/)
KAO( :, 2, 4, 9) = (/&
&2.1468E-02_JPRB,1.9043E-02_JPRB,1.6678E-02_JPRB,1.4283E-02_JPRB,1.1934E-02_JPRB,9.6739E-03_JPRB,&
&7.3557E-03_JPRB,4.9709E-03_JPRB,1.5909E-02_JPRB/)
KAO( :, 3, 4, 9) = (/&
&2.2532E-02_JPRB,2.0092E-02_JPRB,1.7713E-02_JPRB,1.5283E-02_JPRB,1.2949E-02_JPRB,1.0652E-02_JPRB,&
&8.2469E-03_JPRB,5.9560E-03_JPRB,1.9619E-02_JPRB/)
KAO( :, 4, 4, 9) = (/&
&2.3665E-02_JPRB,2.1230E-02_JPRB,1.8849E-02_JPRB,1.6407E-02_JPRB,1.4104E-02_JPRB,1.1750E-02_JPRB,&
&9.3432E-03_JPRB,7.1888E-03_JPRB,2.4018E-02_JPRB/)
KAO( :, 5, 4, 9) = (/&
&2.4860E-02_JPRB,2.2477E-02_JPRB,2.0057E-02_JPRB,1.7676E-02_JPRB,1.5382E-02_JPRB,1.3031E-02_JPRB,&
&1.0691E-02_JPRB,8.7092E-03_JPRB,2.9097E-02_JPRB/)
KAO( :, 1, 5, 9) = (/&
&2.0504E-02_JPRB,1.8088E-02_JPRB,1.5703E-02_JPRB,1.3326E-02_JPRB,1.0997E-02_JPRB,8.7375E-03_JPRB,&
&6.4349E-03_JPRB,4.0325E-03_JPRB,1.9706E-02_JPRB/)
KAO( :, 2, 5, 9) = (/&
&2.1455E-02_JPRB,1.9003E-02_JPRB,1.6600E-02_JPRB,1.4207E-02_JPRB,1.1857E-02_JPRB,9.5485E-03_JPRB,&
&7.1823E-03_JPRB,4.6356E-03_JPRB,2.3733E-02_JPRB/)
KAO( :, 3, 5, 9) = (/&
&2.2502E-02_JPRB,2.0037E-02_JPRB,1.7638E-02_JPRB,1.5221E-02_JPRB,1.2854E-02_JPRB,1.0499E-02_JPRB,&
&8.0330E-03_JPRB,5.4121E-03_JPRB,2.8573E-02_JPRB/)
KAO( :, 4, 5, 9) = (/&
&2.3616E-02_JPRB,2.1161E-02_JPRB,1.8779E-02_JPRB,1.6343E-02_JPRB,1.3995E-02_JPRB,1.1576E-02_JPRB,&
&8.9770E-03_JPRB,6.4039E-03_JPRB,3.4371E-02_JPRB/)
KAO( :, 5, 5, 9) = (/&
&2.4795E-02_JPRB,2.2401E-02_JPRB,2.0008E-02_JPRB,1.7611E-02_JPRB,1.5244E-02_JPRB,1.2739E-02_JPRB,&
&1.0086E-02_JPRB,7.6459E-03_JPRB,4.1145E-02_JPRB/)
KAO( :, 1, 6, 9) = (/&
&2.0133E-02_JPRB,1.7738E-02_JPRB,1.5364E-02_JPRB,1.2999E-02_JPRB,1.0725E-02_JPRB,8.4927E-03_JPRB,&
&6.2104E-03_JPRB,3.8293E-03_JPRB,2.9307E-02_JPRB/)
KAO( :, 2, 6, 9) = (/&
&2.1045E-02_JPRB,1.8610E-02_JPRB,1.6208E-02_JPRB,1.3856E-02_JPRB,1.1560E-02_JPRB,9.2671E-03_JPRB,&
&6.8969E-03_JPRB,4.3962E-03_JPRB,3.5253E-02_JPRB/)
KAO( :, 3, 6, 9) = (/&
&2.2058E-02_JPRB,1.9606E-02_JPRB,1.7213E-02_JPRB,1.4861E-02_JPRB,1.2529E-02_JPRB,1.0178E-02_JPRB,&
&7.7198E-03_JPRB,5.0397E-03_JPRB,4.2153E-02_JPRB/)
KAO( :, 4, 6, 9) = (/&
&2.3150E-02_JPRB,2.0703E-02_JPRB,1.8349E-02_JPRB,1.5982E-02_JPRB,1.3648E-02_JPRB,1.1231E-02_JPRB,&
&8.6302E-03_JPRB,5.8174E-03_JPRB,5.0140E-02_JPRB/)
KAO( :, 5, 6, 9) = (/&
&2.4302E-02_JPRB,2.1916E-02_JPRB,1.9594E-02_JPRB,1.7235E-02_JPRB,1.4884E-02_JPRB,1.2368E-02_JPRB,&
&9.6429E-03_JPRB,6.8104E-03_JPRB,5.9434E-02_JPRB/)
KAO( :, 1, 7, 9) = (/&
&1.9536E-02_JPRB,1.7189E-02_JPRB,1.4859E-02_JPRB,1.2545E-02_JPRB,1.0327E-02_JPRB,8.1473E-03_JPRB,&
&5.9285E-03_JPRB,3.5890E-03_JPRB,4.5929E-02_JPRB/)
KAO( :, 2, 7, 9) = (/&
&2.0386E-02_JPRB,1.8001E-02_JPRB,1.5633E-02_JPRB,1.3342E-02_JPRB,1.1116E-02_JPRB,8.8902E-03_JPRB,&
&6.5600E-03_JPRB,4.1234E-03_JPRB,5.5119E-02_JPRB/)
KAO( :, 3, 7, 9) = (/&
&2.1349E-02_JPRB,1.8942E-02_JPRB,1.6585E-02_JPRB,1.4307E-02_JPRB,1.2057E-02_JPRB,9.7494E-03_JPRB,&
&7.3377E-03_JPRB,4.7340E-03_JPRB,6.5943E-02_JPRB/)
KAO( :, 4, 7, 9) = (/&
&2.2403E-02_JPRB,1.9996E-02_JPRB,1.7685E-02_JPRB,1.5416E-02_JPRB,1.3126E-02_JPRB,1.0758E-02_JPRB,&
&8.2128E-03_JPRB,5.4226E-03_JPRB,7.8488E-02_JPRB/)
KAO( :, 5, 7, 9) = (/&
&2.3510E-02_JPRB,2.1150E-02_JPRB,1.8904E-02_JPRB,1.6637E-02_JPRB,1.4327E-02_JPRB,1.1873E-02_JPRB,&
&9.1897E-03_JPRB,6.2247E-03_JPRB,9.2665E-02_JPRB/)
KAO( :, 1, 8, 9) = (/&
&1.8746E-02_JPRB,1.6470E-02_JPRB,1.4220E-02_JPRB,1.1987E-02_JPRB,9.8350E-03_JPRB,7.7336E-03_JPRB,&
&5.6041E-03_JPRB,3.3408E-03_JPRB,8.6619E-02_JPRB/)
KAO( :, 2, 8, 9) = (/&
&1.9538E-02_JPRB,1.7231E-02_JPRB,1.4934E-02_JPRB,1.2719E-02_JPRB,1.0574E-02_JPRB,8.4413E-03_JPRB,&
&6.1857E-03_JPRB,3.8236E-03_JPRB,1.0386E-01_JPRB/)
KAO( :, 3, 8, 9) = (/&
&2.0463E-02_JPRB,1.8125E-02_JPRB,1.5828E-02_JPRB,1.3641E-02_JPRB,1.1488E-02_JPRB,9.2568E-03_JPRB,&
&6.9051E-03_JPRB,4.3974E-03_JPRB,1.2423E-01_JPRB/)
KAO( :, 4, 8, 9) = (/&
&2.1475E-02_JPRB,1.9130E-02_JPRB,1.6884E-02_JPRB,1.4717E-02_JPRB,1.2518E-02_JPRB,1.0208E-02_JPRB,&
&7.7414E-03_JPRB,5.0487E-03_JPRB,1.4791E-01_JPRB/)
KAO( :, 5, 8, 9) = (/&
&2.2552E-02_JPRB,2.0240E-02_JPRB,1.8077E-02_JPRB,1.5918E-02_JPRB,1.3670E-02_JPRB,1.1281E-02_JPRB,&
&8.6774E-03_JPRB,5.7934E-03_JPRB,1.7479E-01_JPRB/)
KAO( :, 1, 9, 9) = (/&
&1.7677E-02_JPRB,1.5514E-02_JPRB,1.3384E-02_JPRB,1.1273E-02_JPRB,9.2209E-03_JPRB,7.2255E-03_JPRB,&
&5.2054E-03_JPRB,3.0724E-03_JPRB,3.0542E-01_JPRB/)
KAO( :, 2, 9, 9) = (/&
&1.8381E-02_JPRB,1.6193E-02_JPRB,1.4015E-02_JPRB,1.1915E-02_JPRB,9.8821E-03_JPRB,7.8714E-03_JPRB,&
&5.7484E-03_JPRB,3.4992E-03_JPRB,3.6713E-01_JPRB/)
KAO( :, 3, 9, 9) = (/&
&1.9248E-02_JPRB,1.7024E-02_JPRB,1.4840E-02_JPRB,1.2769E-02_JPRB,1.0738E-02_JPRB,8.6406E-03_JPRB,&
&6.3997E-03_JPRB,4.0183E-03_JPRB,4.4040E-01_JPRB/)
KAO( :, 4, 9, 9) = (/&
&2.0207E-02_JPRB,1.7971E-02_JPRB,1.5835E-02_JPRB,1.3795E-02_JPRB,1.1724E-02_JPRB,9.5294E-03_JPRB,&
&7.1782E-03_JPRB,4.6229E-03_JPRB,5.2636E-01_JPRB/)
KAO( :, 5, 9, 9) = (/&
&2.1234E-02_JPRB,1.9021E-02_JPRB,1.6969E-02_JPRB,1.4942E-02_JPRB,1.2829E-02_JPRB,1.0542E-02_JPRB,&
&8.0575E-03_JPRB,5.3170E-03_JPRB,6.2525E-01_JPRB/)
KAO( :, 1,10, 9) = (/&
&1.6394E-02_JPRB,1.4380E-02_JPRB,1.2403E-02_JPRB,1.0449E-02_JPRB,8.5433E-03_JPRB,6.6777E-03_JPRB,&
&4.7921E-03_JPRB,2.8109E-03_JPRB,1.2050E+00_JPRB/)
KAO( :, 2,10, 9) = (/&
&1.7024E-02_JPRB,1.4988E-02_JPRB,1.2970E-02_JPRB,1.1025E-02_JPRB,9.1364E-03_JPRB,7.2561E-03_JPRB,&
&5.2885E-03_JPRB,3.1895E-03_JPRB,1.4500E+00_JPRB/)
KAO( :, 3,10, 9) = (/&
&1.7826E-02_JPRB,1.5753E-02_JPRB,1.3734E-02_JPRB,1.1808E-02_JPRB,9.9253E-03_JPRB,7.9700E-03_JPRB,&
&5.8931E-03_JPRB,3.6564E-03_JPRB,1.7463E+00_JPRB/)
KAO( :, 4,10, 9) = (/&
&1.8735E-02_JPRB,1.6645E-02_JPRB,1.4665E-02_JPRB,1.2773E-02_JPRB,1.0857E-02_JPRB,8.8090E-03_JPRB,&
&6.6108E-03_JPRB,4.2090E-03_JPRB,2.0981E+00_JPRB/)
KAO( :, 5,10, 9) = (/&
&1.9712E-02_JPRB,1.7647E-02_JPRB,1.5744E-02_JPRB,1.3877E-02_JPRB,1.1904E-02_JPRB,9.7573E-03_JPRB,&
&7.4286E-03_JPRB,4.8520E-03_JPRB,2.5126E+00_JPRB/)
KAO( :, 1,11, 9) = (/&
&1.5188E-02_JPRB,1.3334E-02_JPRB,1.1520E-02_JPRB,9.7424E-03_JPRB,8.0090E-03_JPRB,6.2916E-03_JPRB,&
&4.5326E-03_JPRB,2.6753E-03_JPRB,1.9077E+00_JPRB/)
KAO( :, 2,11, 9) = (/&
&1.5822E-02_JPRB,1.3943E-02_JPRB,1.2110E-02_JPRB,1.0341E-02_JPRB,8.6186E-03_JPRB,6.8684E-03_JPRB,&
&5.0259E-03_JPRB,3.0456E-03_JPRB,2.2451E+00_JPRB/)
KAO( :, 3,11, 9) = (/&
&1.6607E-02_JPRB,1.4701E-02_JPRB,1.2884E-02_JPRB,1.1139E-02_JPRB,9.4122E-03_JPRB,7.5743E-03_JPRB,&
&5.6288E-03_JPRB,3.4987E-03_JPRB,2.6727E+00_JPRB/)
KAO( :, 4,11, 9) = (/&
&1.7478E-02_JPRB,1.5574E-02_JPRB,1.3803E-02_JPRB,1.2100E-02_JPRB,1.0320E-02_JPRB,8.3983E-03_JPRB,&
&6.3281E-03_JPRB,4.0305E-03_JPRB,3.1969E+00_JPRB/)
KAO( :, 5,11, 9) = (/&
&1.8411E-02_JPRB,1.6558E-02_JPRB,1.4871E-02_JPRB,1.3181E-02_JPRB,1.1341E-02_JPRB,9.3258E-03_JPRB,&
&7.1170E-03_JPRB,4.6613E-03_JPRB,3.8404E+00_JPRB/)
KAO( :, 1,12, 9) = (/&
&1.3941E-02_JPRB,1.2255E-02_JPRB,1.0613E-02_JPRB,9.0147E-03_JPRB,7.4482E-03_JPRB,5.8708E-03_JPRB,&
&4.2432E-03_JPRB,2.5105E-03_JPRB,2.4052E+00_JPRB/)
KAO( :, 2,12, 9) = (/&
&1.4580E-02_JPRB,1.2868E-02_JPRB,1.1223E-02_JPRB,9.6378E-03_JPRB,8.0671E-03_JPRB,6.4400E-03_JPRB,&
&4.7289E-03_JPRB,2.8707E-03_JPRB,2.7400E+00_JPRB/)
KAO( :, 3,12, 9) = (/&
&1.5332E-02_JPRB,1.3609E-02_JPRB,1.1989E-02_JPRB,1.0428E-02_JPRB,8.8315E-03_JPRB,7.1273E-03_JPRB,&
&5.3125E-03_JPRB,3.3035E-03_JPRB,3.1791E+00_JPRB/)
KAO( :, 4,12, 9) = (/&
&1.6161E-02_JPRB,1.4458E-02_JPRB,1.2893E-02_JPRB,1.1362E-02_JPRB,9.7096E-03_JPRB,7.9231E-03_JPRB,&
&5.9850E-03_JPRB,3.8141E-03_JPRB,3.7447E+00_JPRB/)
KAO( :, 5,12, 9) = (/&
&1.7070E-02_JPRB,1.5426E-02_JPRB,1.3937E-02_JPRB,1.2403E-02_JPRB,1.0694E-02_JPRB,8.8139E-03_JPRB,&
&6.7376E-03_JPRB,4.4323E-03_JPRB,4.4627E+00_JPRB/)
KAO( :, 1,13, 9) = (/&
&1.2794E-02_JPRB,1.1266E-02_JPRB,9.7854E-03_JPRB,8.3492E-03_JPRB,6.9236E-03_JPRB,5.4666E-03_JPRB,&
&3.9567E-03_JPRB,2.3393E-03_JPRB,2.6597E+00_JPRB/)
KAO( :, 2,13, 9) = (/&
&1.3432E-02_JPRB,1.1882E-02_JPRB,1.0408E-02_JPRB,8.9833E-03_JPRB,7.5382E-03_JPRB,6.0260E-03_JPRB,&
&4.4305E-03_JPRB,2.6861E-03_JPRB,2.9232E+00_JPRB/)
KAO( :, 3,13, 9) = (/&
&1.4173E-02_JPRB,1.2623E-02_JPRB,1.1177E-02_JPRB,9.7661E-03_JPRB,8.2766E-03_JPRB,6.6966E-03_JPRB,&
&4.9881E-03_JPRB,3.0967E-03_JPRB,3.2802E+00_JPRB/)
KAO( :, 4,13, 9) = (/&
&1.5004E-02_JPRB,1.3479E-02_JPRB,1.2087E-02_JPRB,1.0672E-02_JPRB,9.1287E-03_JPRB,7.4565E-03_JPRB,&
&5.6287E-03_JPRB,3.5870E-03_JPRB,3.7540E+00_JPRB/)
KAO( :, 5,13, 9) = (/&
&1.5937E-02_JPRB,1.4472E-02_JPRB,1.3138E-02_JPRB,1.1698E-02_JPRB,1.0080E-02_JPRB,8.3092E-03_JPRB,&
&6.3550E-03_JPRB,4.1944E-03_JPRB,4.3785E+00_JPRB/)
KAO( :, 1, 1,10) = (/&
&2.6762E-02_JPRB,2.3836E-02_JPRB,2.1231E-02_JPRB,1.8931E-02_JPRB,1.6906E-02_JPRB,1.4777E-02_JPRB,&
&1.3342E-02_JPRB,1.2105E-02_JPRB,1.6563E-02_JPRB/)
KAO( :, 2, 1,10) = (/&
&2.9265E-02_JPRB,2.6518E-02_JPRB,2.4370E-02_JPRB,2.2173E-02_JPRB,2.0444E-02_JPRB,1.8164E-02_JPRB,&
&1.7054E-02_JPRB,1.5689E-02_JPRB,2.1225E-02_JPRB/)
KAO( :, 3, 1,10) = (/&
&3.2760E-02_JPRB,2.9967E-02_JPRB,2.8038E-02_JPRB,2.6333E-02_JPRB,2.4279E-02_JPRB,2.2399E-02_JPRB,&
&2.1466E-02_JPRB,1.9893E-02_JPRB,2.6794E-02_JPRB/)
KAO( :, 4, 1,10) = (/&
&3.6728E-02_JPRB,3.3924E-02_JPRB,3.2080E-02_JPRB,3.0665E-02_JPRB,2.8563E-02_JPRB,2.7253E-02_JPRB,&
&2.6630E-02_JPRB,2.4967E-02_JPRB,3.3311E-02_JPRB/)
KAO( :, 5, 1,10) = (/&
&4.1067E-02_JPRB,3.8420E-02_JPRB,3.6876E-02_JPRB,3.5143E-02_JPRB,3.3523E-02_JPRB,3.2742E-02_JPRB,&
&3.2418E-02_JPRB,3.0721E-02_JPRB,4.0819E-02_JPRB/)
KAO( :, 1, 2,10) = (/&
&2.8605E-02_JPRB,2.5321E-02_JPRB,2.2167E-02_JPRB,1.9077E-02_JPRB,1.6173E-02_JPRB,1.3425E-02_JPRB,&
&1.2233E-02_JPRB,1.1219E-02_JPRB,1.7512E-02_JPRB/)
KAO( :, 2, 2,10) = (/&
&3.0223E-02_JPRB,2.6983E-02_JPRB,2.4080E-02_JPRB,2.1317E-02_JPRB,1.8746E-02_JPRB,1.6523E-02_JPRB,&
&1.5770E-02_JPRB,1.4686E-02_JPRB,2.2528E-02_JPRB/)
KAO( :, 3, 2,10) = (/&
&3.2701E-02_JPRB,2.9579E-02_JPRB,2.6971E-02_JPRB,2.4770E-02_JPRB,2.2162E-02_JPRB,2.0505E-02_JPRB,&
&1.9969E-02_JPRB,1.8858E-02_JPRB,2.8417E-02_JPRB/)
KAO( :, 4, 2,10) = (/&
&3.6116E-02_JPRB,3.3194E-02_JPRB,3.0876E-02_JPRB,2.8651E-02_JPRB,2.6284E-02_JPRB,2.5161E-02_JPRB,&
&2.4787E-02_JPRB,2.3679E-02_JPRB,3.5174E-02_JPRB/)
KAO( :, 5, 2,10) = (/&
&4.0224E-02_JPRB,3.7508E-02_JPRB,3.5629E-02_JPRB,3.3002E-02_JPRB,3.1044E-02_JPRB,3.0447E-02_JPRB,&
&3.0074E-02_JPRB,2.9018E-02_JPRB,4.2802E-02_JPRB/)
KAO( :, 1, 3,10) = (/&
&3.1173E-02_JPRB,2.7478E-02_JPRB,2.3852E-02_JPRB,2.0280E-02_JPRB,1.6676E-02_JPRB,1.3128E-02_JPRB,&
&1.0535E-02_JPRB,9.7264E-03_JPRB,2.0918E-02_JPRB/)
KAO( :, 2, 3,10) = (/&
&3.2510E-02_JPRB,2.8808E-02_JPRB,2.5249E-02_JPRB,2.1598E-02_JPRB,1.8067E-02_JPRB,1.5028E-02_JPRB,&
&1.3592E-02_JPRB,1.2783E-02_JPRB,2.6767E-02_JPRB/)
KAO( :, 3, 3,10) = (/&
&3.4191E-02_JPRB,3.0498E-02_JPRB,2.6966E-02_JPRB,2.3575E-02_JPRB,2.0182E-02_JPRB,1.8352E-02_JPRB,&
&1.7404E-02_JPRB,1.6536E-02_JPRB,3.3672E-02_JPRB/)
KAO( :, 4, 3,10) = (/&
&3.6367E-02_JPRB,3.2714E-02_JPRB,2.9565E-02_JPRB,2.6531E-02_JPRB,2.3647E-02_JPRB,2.2602E-02_JPRB,&
&2.1804E-02_JPRB,2.0933E-02_JPRB,4.1820E-02_JPRB/)
KAO( :, 5, 3,10) = (/&
&3.9166E-02_JPRB,3.5919E-02_JPRB,3.3501E-02_JPRB,3.0557E-02_JPRB,2.8090E-02_JPRB,2.7339E-02_JPRB,&
&2.6717E-02_JPRB,2.5907E-02_JPRB,5.1316E-02_JPRB/)
KAO( :, 1, 4,10) = (/&
&3.4066E-02_JPRB,2.9987E-02_JPRB,2.5967E-02_JPRB,2.1961E-02_JPRB,1.7860E-02_JPRB,1.3888E-02_JPRB,&
&1.0186E-02_JPRB,8.1254E-03_JPRB,2.9250E-02_JPRB/)
KAO( :, 2, 4,10) = (/&
&3.5460E-02_JPRB,3.1308E-02_JPRB,2.7262E-02_JPRB,2.3213E-02_JPRB,1.9156E-02_JPRB,1.5144E-02_JPRB,&
&1.1782E-02_JPRB,1.0834E-02_JPRB,3.8098E-02_JPRB/)
KAO( :, 3, 4,10) = (/&
&3.6874E-02_JPRB,3.2726E-02_JPRB,2.8680E-02_JPRB,2.4650E-02_JPRB,2.0393E-02_JPRB,1.6831E-02_JPRB,&
&1.4883E-02_JPRB,1.4098E-02_JPRB,4.8024E-02_JPRB/)
KAO( :, 4, 4,10) = (/&
&3.8521E-02_JPRB,3.4326E-02_JPRB,3.0378E-02_JPRB,2.6392E-02_JPRB,2.2432E-02_JPRB,1.9980E-02_JPRB,&
&1.8770E-02_JPRB,1.7981E-02_JPRB,5.9374E-02_JPRB/)
KAO( :, 5, 4,10) = (/&
&4.0371E-02_JPRB,3.6305E-02_JPRB,3.2708E-02_JPRB,2.8856E-02_JPRB,2.5853E-02_JPRB,2.4145E-02_JPRB,&
&2.3195E-02_JPRB,2.2463E-02_JPRB,7.2233E-02_JPRB/)
KAO( :, 1, 5,10) = (/&
&3.6434E-02_JPRB,3.2049E-02_JPRB,2.7755E-02_JPRB,2.3391E-02_JPRB,1.9132E-02_JPRB,1.4843E-02_JPRB,&
&1.0790E-02_JPRB,6.8244E-03_JPRB,4.2858E-02_JPRB/)
KAO( :, 2, 5,10) = (/&
&3.8052E-02_JPRB,3.3555E-02_JPRB,2.9121E-02_JPRB,2.4755E-02_JPRB,2.0357E-02_JPRB,1.6002E-02_JPRB,&
&1.1813E-02_JPRB,9.0432E-03_JPRB,5.4802E-02_JPRB/)
KAO( :, 3, 5,10) = (/&
&3.9720E-02_JPRB,3.5157E-02_JPRB,3.0682E-02_JPRB,2.6285E-02_JPRB,2.1672E-02_JPRB,1.7348E-02_JPRB,&
&1.3380E-02_JPRB,1.1960E-02_JPRB,7.0286E-02_JPRB/)
KAO( :, 4, 5,10) = (/&
&4.1616E-02_JPRB,3.6963E-02_JPRB,3.2456E-02_JPRB,2.8024E-02_JPRB,2.3329E-02_JPRB,1.9031E-02_JPRB,&
&1.6245E-02_JPRB,1.5312E-02_JPRB,8.8323E-02_JPRB/)
KAO( :, 5, 5,10) = (/&
&4.3467E-02_JPRB,3.8778E-02_JPRB,3.4533E-02_JPRB,2.9811E-02_JPRB,2.5445E-02_JPRB,2.1728E-02_JPRB,&
&2.0136E-02_JPRB,1.9200E-02_JPRB,1.0804E-01_JPRB/)
KAO( :, 1, 6,10) = (/&
&3.9016E-02_JPRB,3.4252E-02_JPRB,2.9584E-02_JPRB,2.4915E-02_JPRB,2.0266E-02_JPRB,1.5607E-02_JPRB,&
&1.1369E-02_JPRB,6.7556E-03_JPRB,6.7432E-02_JPRB/)
KAO( :, 2, 6,10) = (/&
&4.0452E-02_JPRB,3.5642E-02_JPRB,3.0903E-02_JPRB,2.6184E-02_JPRB,2.1443E-02_JPRB,1.6916E-02_JPRB,&
&1.2438E-02_JPRB,7.7587E-03_JPRB,8.0666E-02_JPRB/)
KAO( :, 3, 6,10) = (/&
&4.2155E-02_JPRB,3.7272E-02_JPRB,3.2474E-02_JPRB,2.7702E-02_JPRB,2.2975E-02_JPRB,1.8296E-02_JPRB,&
&1.3696E-02_JPRB,9.8129E-03_JPRB,9.9349E-02_JPRB/)
KAO( :, 4, 6,10) = (/&
&4.4121E-02_JPRB,3.9182E-02_JPRB,3.4311E-02_JPRB,2.9590E-02_JPRB,2.4570E-02_JPRB,1.9828E-02_JPRB,&
&1.5267E-02_JPRB,1.2859E-02_JPRB,1.2445E-01_JPRB/)
KAO( :, 5, 6,10) = (/&
&4.6213E-02_JPRB,4.1161E-02_JPRB,3.6458E-02_JPRB,3.1468E-02_JPRB,2.6559E-02_JPRB,2.1785E-02_JPRB,&
&1.7650E-02_JPRB,1.6392E-02_JPRB,1.5469E-01_JPRB/)
KAO( :, 1, 7,10) = (/&
&4.1359E-02_JPRB,3.6208E-02_JPRB,3.1312E-02_JPRB,2.6328E-02_JPRB,2.1267E-02_JPRB,1.6329E-02_JPRB,&
&1.1827E-02_JPRB,6.9169E-03_JPRB,1.1368E-01_JPRB/)
KAO( :, 2, 7,10) = (/&
&4.2810E-02_JPRB,3.7687E-02_JPRB,3.2642E-02_JPRB,2.7514E-02_JPRB,2.2469E-02_JPRB,1.7642E-02_JPRB,&
&1.2961E-02_JPRB,7.8247E-03_JPRB,1.3536E-01_JPRB/)
KAO( :, 3, 7,10) = (/&
&4.4524E-02_JPRB,3.9305E-02_JPRB,3.4135E-02_JPRB,2.9034E-02_JPRB,2.4045E-02_JPRB,1.9110E-02_JPRB,&
&1.4148E-02_JPRB,8.9564E-03_JPRB,1.6103E-01_JPRB/)
KAO( :, 4, 7,10) = (/&
&4.6334E-02_JPRB,4.1093E-02_JPRB,3.5887E-02_JPRB,3.0860E-02_JPRB,2.5799E-02_JPRB,2.0761E-02_JPRB,&
&1.5735E-02_JPRB,1.0795E-02_JPRB,1.9350E-01_JPRB/)
KAO( :, 5, 7,10) = (/&
&4.8572E-02_JPRB,4.3224E-02_JPRB,3.8076E-02_JPRB,3.3049E-02_JPRB,2.7908E-02_JPRB,2.2762E-02_JPRB,&
&1.7415E-02_JPRB,1.3780E-02_JPRB,2.3787E-01_JPRB/)
KAO( :, 1, 8,10) = (/&
&4.3378E-02_JPRB,3.7958E-02_JPRB,3.2795E-02_JPRB,2.7505E-02_JPRB,2.2211E-02_JPRB,1.6954E-02_JPRB,&
&1.2107E-02_JPRB,7.0694E-03_JPRB,2.2556E-01_JPRB/)
KAO( :, 2, 8,10) = (/&
&4.4773E-02_JPRB,3.9362E-02_JPRB,3.4029E-02_JPRB,2.8646E-02_JPRB,2.3299E-02_JPRB,1.8142E-02_JPRB,&
&1.3413E-02_JPRB,7.9253E-03_JPRB,2.7089E-01_JPRB/)
KAO( :, 3, 8,10) = (/&
&4.6409E-02_JPRB,4.0922E-02_JPRB,3.5484E-02_JPRB,3.0037E-02_JPRB,2.4685E-02_JPRB,1.9797E-02_JPRB,&
&1.4575E-02_JPRB,9.0349E-03_JPRB,3.2354E-01_JPRB/)
KAO( :, 4, 8,10) = (/&
&4.8517E-02_JPRB,4.2960E-02_JPRB,3.7415E-02_JPRB,3.1998E-02_JPRB,2.6730E-02_JPRB,2.1507E-02_JPRB,&
&1.6141E-02_JPRB,1.0325E-02_JPRB,3.8344E-01_JPRB/)
KAO( :, 5, 8,10) = (/&
&5.0774E-02_JPRB,4.5143E-02_JPRB,3.9523E-02_JPRB,3.4165E-02_JPRB,2.9055E-02_JPRB,2.3639E-02_JPRB,&
&1.7862E-02_JPRB,1.1998E-02_JPRB,4.5852E-01_JPRB/)
KAO( :, 1, 9,10) = (/&
&4.4741E-02_JPRB,3.9148E-02_JPRB,3.3761E-02_JPRB,2.8274E-02_JPRB,2.2811E-02_JPRB,1.7318E-02_JPRB,&
&1.2244E-02_JPRB,7.1252E-03_JPRB,8.3568E-01_JPRB/)
KAO( :, 2, 9,10) = (/&
&4.6123E-02_JPRB,4.0465E-02_JPRB,3.4958E-02_JPRB,2.9415E-02_JPRB,2.3808E-02_JPRB,1.8402E-02_JPRB,&
&1.3524E-02_JPRB,7.9651E-03_JPRB,1.0063E+00_JPRB/)
KAO( :, 3, 9,10) = (/&
&4.7534E-02_JPRB,4.1886E-02_JPRB,3.6283E-02_JPRB,3.0629E-02_JPRB,2.4989E-02_JPRB,2.0028E-02_JPRB,&
&1.4812E-02_JPRB,9.0475E-03_JPRB,1.2094E+00_JPRB/)
KAO( :, 4, 9,10) = (/&
&4.9654E-02_JPRB,4.3880E-02_JPRB,3.8124E-02_JPRB,3.2363E-02_JPRB,2.7020E-02_JPRB,2.1905E-02_JPRB,&
&1.6314E-02_JPRB,1.0326E-02_JPRB,1.4400E+00_JPRB/)
KAO( :, 5, 9,10) = (/&
&5.2092E-02_JPRB,4.6279E-02_JPRB,4.0415E-02_JPRB,3.4883E-02_JPRB,2.9494E-02_JPRB,2.4010E-02_JPRB,&
&1.8108E-02_JPRB,1.1750E-02_JPRB,1.7026E+00_JPRB/)
KAO( :, 1,10,10) = (/&
&4.5400E-02_JPRB,3.9727E-02_JPRB,3.4202E-02_JPRB,2.8645E-02_JPRB,2.3051E-02_JPRB,1.7520E-02_JPRB,&
&1.2293E-02_JPRB,7.0668E-03_JPRB,3.4266E+00_JPRB/)
KAO( :, 2,10,10) = (/&
&4.6758E-02_JPRB,4.0959E-02_JPRB,3.5395E-02_JPRB,2.9735E-02_JPRB,2.3996E-02_JPRB,1.8576E-02_JPRB,&
&1.3516E-02_JPRB,7.9973E-03_JPRB,4.1099E+00_JPRB/)
KAO( :, 3,10,10) = (/&
&4.8048E-02_JPRB,4.2318E-02_JPRB,3.6627E-02_JPRB,3.0846E-02_JPRB,2.5140E-02_JPRB,2.0176E-02_JPRB,&
&1.4829E-02_JPRB,9.0540E-03_JPRB,4.9855E+00_JPRB/)
KAO( :, 4,10,10) = (/&
&4.9997E-02_JPRB,4.4155E-02_JPRB,3.8326E-02_JPRB,3.2491E-02_JPRB,2.7179E-02_JPRB,2.1979E-02_JPRB,&
&1.6362E-02_JPRB,1.0317E-02_JPRB,6.0098E+00_JPRB/)
KAO( :, 5,10,10) = (/&
&5.2444E-02_JPRB,4.6561E-02_JPRB,4.0609E-02_JPRB,3.4910E-02_JPRB,2.9562E-02_JPRB,2.4235E-02_JPRB,&
&1.8223E-02_JPRB,1.1743E-02_JPRB,7.1315E+00_JPRB/)
KAO( :, 1,11,10) = (/&
&4.5658E-02_JPRB,3.9952E-02_JPRB,3.4443E-02_JPRB,2.8833E-02_JPRB,2.3231E-02_JPRB,1.7803E-02_JPRB,&
&1.2587E-02_JPRB,7.2875E-03_JPRB,5.3649E+00_JPRB/)
KAO( :, 2,11,10) = (/&
&4.6850E-02_JPRB,4.1124E-02_JPRB,3.5510E-02_JPRB,2.9860E-02_JPRB,2.4205E-02_JPRB,1.8972E-02_JPRB,&
&1.3852E-02_JPRB,8.2974E-03_JPRB,6.4734E+00_JPRB/)
KAO( :, 3,11,10) = (/&
&4.8321E-02_JPRB,4.2589E-02_JPRB,3.6878E-02_JPRB,3.1119E-02_JPRB,2.5570E-02_JPRB,2.0721E-02_JPRB,&
&1.5183E-02_JPRB,9.4279E-03_JPRB,7.8016E+00_JPRB/)
KAO( :, 4,11,10) = (/&
&5.0607E-02_JPRB,4.4776E-02_JPRB,3.8924E-02_JPRB,3.3081E-02_JPRB,2.7944E-02_JPRB,2.2646E-02_JPRB,&
&1.6967E-02_JPRB,1.0786E-02_JPRB,9.3814E+00_JPRB/)
KAO( :, 5,11,10) = (/&
&5.3189E-02_JPRB,4.7267E-02_JPRB,4.1301E-02_JPRB,3.5698E-02_JPRB,3.0480E-02_JPRB,2.5061E-02_JPRB,&
&1.9030E-02_JPRB,1.2260E-02_JPRB,1.1143E+01_JPRB/)
KAO( :, 1,12,10) = (/&
&4.4854E-02_JPRB,3.9248E-02_JPRB,3.3879E-02_JPRB,2.8362E-02_JPRB,2.2914E-02_JPRB,1.7730E-02_JPRB,&
&1.2612E-02_JPRB,7.3730E-03_JPRB,6.1785E+00_JPRB/)
KAO( :, 2,12,10) = (/&
&4.6033E-02_JPRB,4.0478E-02_JPRB,3.4947E-02_JPRB,2.9376E-02_JPRB,2.4012E-02_JPRB,1.9043E-02_JPRB,&
&1.3870E-02_JPRB,8.4065E-03_JPRB,7.5551E+00_JPRB/)
KAO( :, 3,12,10) = (/&
&4.7929E-02_JPRB,4.2284E-02_JPRB,3.6631E-02_JPRB,3.0973E-02_JPRB,2.5841E-02_JPRB,2.0835E-02_JPRB,&
&1.5374E-02_JPRB,9.6454E-03_JPRB,9.2004E+00_JPRB/)
KAO( :, 4,12,10) = (/&
&5.0374E-02_JPRB,4.4657E-02_JPRB,3.8857E-02_JPRB,3.3248E-02_JPRB,2.8288E-02_JPRB,2.3006E-02_JPRB,&
&1.7300E-02_JPRB,1.1060E-02_JPRB,1.0995E+01_JPRB/)
KAO( :, 5,12,10) = (/&
&5.3127E-02_JPRB,4.7293E-02_JPRB,4.1498E-02_JPRB,3.6136E-02_JPRB,3.1085E-02_JPRB,2.5531E-02_JPRB,&
&1.9582E-02_JPRB,1.2642E-02_JPRB,1.3019E+01_JPRB/)
KAO( :, 1,13,10) = (/&
&4.3325E-02_JPRB,3.7930E-02_JPRB,3.2755E-02_JPRB,2.7447E-02_JPRB,2.2319E-02_JPRB,1.7411E-02_JPRB,&
&1.2453E-02_JPRB,7.3368E-03_JPRB,5.8866E+00_JPRB/)
KAO( :, 2,13,10) = (/&
&4.4885E-02_JPRB,3.9512E-02_JPRB,3.4133E-02_JPRB,2.8720E-02_JPRB,2.3711E-02_JPRB,1.8875E-02_JPRB,&
&1.3756E-02_JPRB,8.3802E-03_JPRB,7.1313E+00_JPRB/)
KAO( :, 3,13,10) = (/&
&4.7105E-02_JPRB,4.1602E-02_JPRB,3.6075E-02_JPRB,3.0646E-02_JPRB,2.5891E-02_JPRB,2.0741E-02_JPRB,&
&1.5481E-02_JPRB,9.7027E-03_JPRB,8.6483E+00_JPRB/)
KAO( :, 4,13,10) = (/&
&4.9710E-02_JPRB,4.4134E-02_JPRB,3.8464E-02_JPRB,3.3281E-02_JPRB,2.8408E-02_JPRB,2.3139E-02_JPRB,&
&1.7501E-02_JPRB,1.1201E-02_JPRB,1.0384E+01_JPRB/)
KAO( :, 5,13,10) = (/&
&5.2678E-02_JPRB,4.7001E-02_JPRB,4.1355E-02_JPRB,3.6354E-02_JPRB,3.1421E-02_JPRB,2.5818E-02_JPRB,&
&1.9874E-02_JPRB,1.2850E-02_JPRB,1.2332E+01_JPRB/)
KAO( :, 1, 1,11) = (/&
&3.4006E-02_JPRB,3.0838E-02_JPRB,2.8315E-02_JPRB,2.6031E-02_JPRB,2.3204E-02_JPRB,2.0875E-02_JPRB,&
&1.7987E-02_JPRB,1.5519E-02_JPRB,2.1659E-02_JPRB/)
KAO( :, 2, 1,11) = (/&
&3.8880E-02_JPRB,3.5625E-02_JPRB,3.3192E-02_JPRB,3.0992E-02_JPRB,2.8389E-02_JPRB,2.5986E-02_JPRB,&
&2.2691E-02_JPRB,2.0442E-02_JPRB,2.7838E-02_JPRB/)
KAO( :, 3, 1,11) = (/&
&4.3962E-02_JPRB,4.0825E-02_JPRB,3.8703E-02_JPRB,3.6297E-02_JPRB,3.4511E-02_JPRB,3.1450E-02_JPRB,&
&2.8328E-02_JPRB,2.6446E-02_JPRB,3.5353E-02_JPRB/)
KAO( :, 4, 1,11) = (/&
&4.9311E-02_JPRB,4.6293E-02_JPRB,4.4623E-02_JPRB,4.2521E-02_JPRB,4.0745E-02_JPRB,3.7590E-02_JPRB,&
&3.5066E-02_JPRB,3.3577E-02_JPRB,4.4098E-02_JPRB/)
KAO( :, 5, 1,11) = (/&
&5.4902E-02_JPRB,5.1787E-02_JPRB,5.0538E-02_JPRB,4.9462E-02_JPRB,4.7171E-02_JPRB,4.4663E-02_JPRB,&
&4.2782E-02_JPRB,4.2346E-02_JPRB,5.4138E-02_JPRB/)
KAO( :, 1, 2,11) = (/&
&3.3012E-02_JPRB,2.9524E-02_JPRB,2.6537E-02_JPRB,2.4015E-02_JPRB,2.1124E-02_JPRB,1.8957E-02_JPRB,&
&1.6213E-02_JPRB,1.4498E-02_JPRB,2.4045E-02_JPRB/)
KAO( :, 2, 2,11) = (/&
&3.6932E-02_JPRB,3.3550E-02_JPRB,3.1000E-02_JPRB,2.8534E-02_JPRB,2.6293E-02_JPRB,2.3594E-02_JPRB,&
&2.0668E-02_JPRB,1.9041E-02_JPRB,3.0483E-02_JPRB/)
KAO( :, 3, 2,11) = (/&
&4.1673E-02_JPRB,3.8445E-02_JPRB,3.6326E-02_JPRB,3.3911E-02_JPRB,3.1922E-02_JPRB,2.8763E-02_JPRB,&
&2.6126E-02_JPRB,2.4581E-02_JPRB,3.8179E-02_JPRB/)
KAO( :, 4, 2,11) = (/&
&4.6918E-02_JPRB,4.3776E-02_JPRB,4.1906E-02_JPRB,4.0246E-02_JPRB,3.7729E-02_JPRB,3.4837E-02_JPRB,&
&3.2578E-02_JPRB,3.1324E-02_JPRB,4.7309E-02_JPRB/)
KAO( :, 5, 2,11) = (/&
&5.2471E-02_JPRB,4.9278E-02_JPRB,4.7809E-02_JPRB,4.6827E-02_JPRB,4.4067E-02_JPRB,4.1837E-02_JPRB,&
&4.0124E-02_JPRB,3.9172E-02_JPRB,5.7813E-02_JPRB/)
KAO( :, 1, 3,11) = (/&
&3.4501E-02_JPRB,3.0473E-02_JPRB,2.6575E-02_JPRB,2.2929E-02_JPRB,1.9181E-02_JPRB,1.6191E-02_JPRB,&
&1.4206E-02_JPRB,1.2625E-02_JPRB,3.1974E-02_JPRB/)
KAO( :, 2, 3,11) = (/&
&3.6715E-02_JPRB,3.2658E-02_JPRB,2.9031E-02_JPRB,2.5829E-02_JPRB,2.3118E-02_JPRB,2.0224E-02_JPRB,&
&1.8346E-02_JPRB,1.6857E-02_JPRB,4.0926E-02_JPRB/)
KAO( :, 3, 3,11) = (/&
&3.9788E-02_JPRB,3.6029E-02_JPRB,3.3165E-02_JPRB,3.0553E-02_JPRB,2.7991E-02_JPRB,2.5038E-02_JPRB,&
&2.3354E-02_JPRB,2.2060E-02_JPRB,5.0503E-02_JPRB/)
KAO( :, 4, 3,11) = (/&
&4.4214E-02_JPRB,4.0649E-02_JPRB,3.8329E-02_JPRB,3.6284E-02_JPRB,3.3473E-02_JPRB,3.0774E-02_JPRB,&
&2.9336E-02_JPRB,2.8146E-02_JPRB,6.1109E-02_JPRB/)
KAO( :, 5, 3,11) = (/&
&4.9685E-02_JPRB,4.6100E-02_JPRB,4.4117E-02_JPRB,4.2257E-02_JPRB,3.9617E-02_JPRB,3.7525E-02_JPRB,&
&3.6458E-02_JPRB,3.5132E-02_JPRB,7.3052E-02_JPRB/)
KAO( :, 1, 4,11) = (/&
&3.7701E-02_JPRB,3.3183E-02_JPRB,2.8775E-02_JPRB,2.4369E-02_JPRB,1.9949E-02_JPRB,1.5608E-02_JPRB,&
&1.2337E-02_JPRB,1.0909E-02_JPRB,4.5234E-02_JPRB/)
KAO( :, 2, 4,11) = (/&
&3.9570E-02_JPRB,3.4927E-02_JPRB,3.0377E-02_JPRB,2.5987E-02_JPRB,2.1638E-02_JPRB,1.7716E-02_JPRB,&
&1.5957E-02_JPRB,1.4485E-02_JPRB,5.8101E-02_JPRB/)
KAO( :, 3, 4,11) = (/&
&4.1487E-02_JPRB,3.6886E-02_JPRB,3.2552E-02_JPRB,2.8478E-02_JPRB,2.4613E-02_JPRB,2.1797E-02_JPRB,&
&2.0639E-02_JPRB,1.9138E-02_JPRB,7.3443E-02_JPRB/)
KAO( :, 4, 4,11) = (/&
&4.4074E-02_JPRB,3.9637E-02_JPRB,3.5709E-02_JPRB,3.2584E-02_JPRB,2.9098E-02_JPRB,2.7106E-02_JPRB,&
&2.6271E-02_JPRB,2.4880E-02_JPRB,9.0496E-02_JPRB/)
KAO( :, 5, 4,11) = (/&
&4.7920E-02_JPRB,4.3761E-02_JPRB,4.0716E-02_JPRB,3.7902E-02_JPRB,3.4829E-02_JPRB,3.3417E-02_JPRB,&
&3.2862E-02_JPRB,3.1333E-02_JPRB,1.0813E-01_JPRB/)
KAO( :, 1, 5,11) = (/&
&4.1870E-02_JPRB,3.6784E-02_JPRB,3.1817E-02_JPRB,2.6817E-02_JPRB,2.1907E-02_JPRB,1.6884E-02_JPRB,&
&1.2273E-02_JPRB,9.3968E-03_JPRB,6.4840E-02_JPRB/)
KAO( :, 2, 5,11) = (/&
&4.3297E-02_JPRB,3.8168E-02_JPRB,3.3137E-02_JPRB,2.8168E-02_JPRB,2.3151E-02_JPRB,1.8216E-02_JPRB,&
&1.4106E-02_JPRB,1.2594E-02_JPRB,8.4416E-02_JPRB/)
KAO( :, 3, 5,11) = (/&
&4.5197E-02_JPRB,3.9955E-02_JPRB,3.4866E-02_JPRB,2.9774E-02_JPRB,2.4780E-02_JPRB,2.0210E-02_JPRB,&
&1.7877E-02_JPRB,1.6653E-02_JPRB,1.0767E-01_JPRB/)
KAO( :, 4, 5,11) = (/&
&4.7208E-02_JPRB,4.1906E-02_JPRB,3.6778E-02_JPRB,3.1900E-02_JPRB,2.6959E-02_JPRB,2.4148E-02_JPRB,&
&2.3054E-02_JPRB,2.1659E-02_JPRB,1.3362E-01_JPRB/)
KAO( :, 5, 5,11) = (/&
&4.9723E-02_JPRB,4.4415E-02_JPRB,3.9606E-02_JPRB,3.5130E-02_JPRB,3.1176E-02_JPRB,2.9987E-02_JPRB,&
&2.9188E-02_JPRB,2.7574E-02_JPRB,1.6267E-01_JPRB/)
KAO( :, 1, 6,11) = (/&
&4.6177E-02_JPRB,4.0428E-02_JPRB,3.5000E-02_JPRB,2.9479E-02_JPRB,2.3910E-02_JPRB,1.8380E-02_JPRB,&
&1.3182E-02_JPRB,8.0681E-03_JPRB,9.4271E-02_JPRB/)
KAO( :, 2, 6,11) = (/&
&4.7848E-02_JPRB,4.2133E-02_JPRB,3.6528E-02_JPRB,3.0847E-02_JPRB,2.5231E-02_JPRB,1.9720E-02_JPRB,&
&1.4391E-02_JPRB,1.0657E-02_JPRB,1.2169E-01_JPRB/)
KAO( :, 3, 6,11) = (/&
&4.9573E-02_JPRB,4.3747E-02_JPRB,3.7998E-02_JPRB,3.2369E-02_JPRB,2.6844E-02_JPRB,2.1245E-02_JPRB,&
&1.6159E-02_JPRB,1.4369E-02_JPRB,1.5614E-01_JPRB/)
KAO( :, 4, 6,11) = (/&
&5.1449E-02_JPRB,4.5620E-02_JPRB,3.9881E-02_JPRB,3.4359E-02_JPRB,2.8492E-02_JPRB,2.3216E-02_JPRB,&
&1.9980E-02_JPRB,1.8809E-02_JPRB,1.9622E-01_JPRB/)
KAO( :, 5, 6,11) = (/&
&5.3758E-02_JPRB,4.7819E-02_JPRB,4.2046E-02_JPRB,3.6553E-02_JPRB,3.0747E-02_JPRB,2.6899E-02_JPRB,&
&2.5355E-02_JPRB,2.3973E-02_JPRB,2.4061E-01_JPRB/)
KAO( :, 1, 7,11) = (/&
&5.0539E-02_JPRB,4.4226E-02_JPRB,3.8237E-02_JPRB,3.2119E-02_JPRB,2.5955E-02_JPRB,1.9850E-02_JPRB,&
&1.4014E-02_JPRB,8.2656E-03_JPRB,1.5715E-01_JPRB/)
KAO( :, 2, 7,11) = (/&
&5.2213E-02_JPRB,4.5893E-02_JPRB,3.9703E-02_JPRB,3.3446E-02_JPRB,2.7259E-02_JPRB,2.1129E-02_JPRB,&
&1.5451E-02_JPRB,9.4123E-03_JPRB,1.9172E-01_JPRB/)
KAO( :, 3, 7,11) = (/&
&5.3964E-02_JPRB,4.7586E-02_JPRB,4.1300E-02_JPRB,3.5018E-02_JPRB,2.8812E-02_JPRB,2.2874E-02_JPRB,&
&1.6862E-02_JPRB,1.2078E-02_JPRB,2.4474E-01_JPRB/)
KAO( :, 4, 7,11) = (/&
&5.6281E-02_JPRB,4.9820E-02_JPRB,4.3435E-02_JPRB,3.7102E-02_JPRB,3.0863E-02_JPRB,2.4675E-02_JPRB,&
&1.8760E-02_JPRB,1.6116E-02_JPRB,3.1097E-01_JPRB/)
KAO( :, 5, 7,11) = (/&
&5.8608E-02_JPRB,5.2097E-02_JPRB,4.5621E-02_JPRB,3.9415E-02_JPRB,3.3038E-02_JPRB,2.6921E-02_JPRB,&
&2.2270E-02_JPRB,2.0802E-02_JPRB,3.8459E-01_JPRB/)
KAO( :, 1, 8,11) = (/&
&5.4836E-02_JPRB,4.7985E-02_JPRB,4.1396E-02_JPRB,3.4685E-02_JPRB,2.8011E-02_JPRB,2.1239E-02_JPRB,&
&1.4808E-02_JPRB,8.7162E-03_JPRB,3.2201E-01_JPRB/)
KAO( :, 2, 8,11) = (/&
&5.6598E-02_JPRB,4.9598E-02_JPRB,4.2901E-02_JPRB,3.6120E-02_JPRB,2.9254E-02_JPRB,2.2462E-02_JPRB,&
&1.6430E-02_JPRB,9.7013E-03_JPRB,3.8537E-01_JPRB/)
KAO( :, 3, 8,11) = (/&
&5.8383E-02_JPRB,5.1431E-02_JPRB,4.4592E-02_JPRB,3.7658E-02_JPRB,3.0762E-02_JPRB,2.4304E-02_JPRB,&
&1.8006E-02_JPRB,1.1047E-02_JPRB,4.7230E-01_JPRB/)
KAO( :, 4, 8,11) = (/&
&6.0542E-02_JPRB,5.3465E-02_JPRB,4.6470E-02_JPRB,3.9515E-02_JPRB,3.2802E-02_JPRB,2.6370E-02_JPRB,&
&1.9678E-02_JPRB,1.3674E-02_JPRB,5.9222E-01_JPRB/)
KAO( :, 5, 8,11) = (/&
&6.3504E-02_JPRB,5.6367E-02_JPRB,4.9211E-02_JPRB,4.2376E-02_JPRB,3.5393E-02_JPRB,2.8477E-02_JPRB,&
&2.1872E-02_JPRB,1.7879E-02_JPRB,7.4060E-01_JPRB/)
KAO( :, 1, 9,11) = (/&
&5.8530E-02_JPRB,5.1215E-02_JPRB,4.4050E-02_JPRB,3.6938E-02_JPRB,2.9723E-02_JPRB,2.2521E-02_JPRB,&
&1.5575E-02_JPRB,8.9613E-03_JPRB,1.2250E+00_JPRB/)
KAO( :, 2, 9,11) = (/&
&6.0508E-02_JPRB,5.2947E-02_JPRB,4.5790E-02_JPRB,3.8466E-02_JPRB,3.1050E-02_JPRB,2.3735E-02_JPRB,&
&1.7082E-02_JPRB,1.0081E-02_JPRB,1.4743E+00_JPRB/)
KAO( :, 3, 9,11) = (/&
&6.2412E-02_JPRB,5.4914E-02_JPRB,4.7544E-02_JPRB,4.0031E-02_JPRB,3.2611E-02_JPRB,2.5512E-02_JPRB,&
&1.8968E-02_JPRB,1.1343E-02_JPRB,1.7744E+00_JPRB/)
KAO( :, 4, 9,11) = (/&
&6.4422E-02_JPRB,5.6870E-02_JPRB,4.9390E-02_JPRB,4.1890E-02_JPRB,3.4611E-02_JPRB,2.7684E-02_JPRB,&
&2.0680E-02_JPRB,1.2948E-02_JPRB,2.1658E+00_JPRB/)
KAO( :, 5, 9,11) = (/&
&6.7272E-02_JPRB,5.9620E-02_JPRB,5.1959E-02_JPRB,4.4449E-02_JPRB,3.7070E-02_JPRB,3.0178E-02_JPRB,&
&2.2884E-02_JPRB,1.5505E-02_JPRB,2.6879E+00_JPRB/)
KAO( :, 1,10,11) = (/&
&6.1580E-02_JPRB,5.3887E-02_JPRB,4.6212E-02_JPRB,3.8787E-02_JPRB,3.1170E-02_JPRB,2.3588E-02_JPRB,&
&1.6242E-02_JPRB,9.1562E-03_JPRB,5.0131E+00_JPRB/)
KAO( :, 2,10,11) = (/&
&6.3734E-02_JPRB,5.5768E-02_JPRB,4.8169E-02_JPRB,4.0370E-02_JPRB,3.2604E-02_JPRB,2.4832E-02_JPRB,&
&1.7635E-02_JPRB,1.0375E-02_JPRB,6.1201E+00_JPRB/)
KAO( :, 3,10,11) = (/&
&6.5820E-02_JPRB,5.7831E-02_JPRB,4.9999E-02_JPRB,4.2115E-02_JPRB,3.4203E-02_JPRB,2.6490E-02_JPRB,&
&1.9622E-02_JPRB,1.1697E-02_JPRB,7.4107E+00_JPRB/)
KAO( :, 4,10,11) = (/&
&6.7912E-02_JPRB,5.9913E-02_JPRB,5.1985E-02_JPRB,4.3986E-02_JPRB,3.6001E-02_JPRB,2.8914E-02_JPRB,&
&2.1590E-02_JPRB,1.3339E-02_JPRB,9.0185E+00_JPRB/)
KAO( :, 5,10,11) = (/&
&7.0732E-02_JPRB,6.2601E-02_JPRB,5.4503E-02_JPRB,4.6414E-02_JPRB,3.8865E-02_JPRB,3.1467E-02_JPRB,&
&2.3923E-02_JPRB,1.5241E-02_JPRB,1.1156E+01_JPRB/)
KAO( :, 1,11,11) = (/&
&6.4605E-02_JPRB,5.6532E-02_JPRB,4.8552E-02_JPRB,4.0738E-02_JPRB,3.2744E-02_JPRB,2.4819E-02_JPRB,&
&1.7263E-02_JPRB,9.7908E-03_JPRB,7.8274E+00_JPRB/)
KAO( :, 2,11,11) = (/&
&6.6894E-02_JPRB,5.8534E-02_JPRB,5.0603E-02_JPRB,4.2448E-02_JPRB,3.4262E-02_JPRB,2.6260E-02_JPRB,&
&1.8818E-02_JPRB,1.1087E-02_JPRB,9.5674E+00_JPRB/)
KAO( :, 3,11,11) = (/&
&6.9134E-02_JPRB,6.0821E-02_JPRB,5.2610E-02_JPRB,4.4286E-02_JPRB,3.6011E-02_JPRB,2.8243E-02_JPRB,&
&2.0923E-02_JPRB,1.2641E-02_JPRB,1.1695E+01_JPRB/)
KAO( :, 4,11,11) = (/&
&7.1444E-02_JPRB,6.3062E-02_JPRB,5.4727E-02_JPRB,4.6341E-02_JPRB,3.8163E-02_JPRB,3.0937E-02_JPRB,&
&2.3046E-02_JPRB,1.4407E-02_JPRB,1.4290E+01_JPRB/)
KAO( :, 5,11,11) = (/&
&7.4689E-02_JPRB,6.6247E-02_JPRB,5.7761E-02_JPRB,4.9331E-02_JPRB,4.1557E-02_JPRB,3.3813E-02_JPRB,&
&2.5726E-02_JPRB,1.6474E-02_JPRB,1.7723E+01_JPRB/)
KAO( :, 1,12,11) = (/&
&6.6565E-02_JPRB,5.8241E-02_JPRB,5.0116E-02_JPRB,4.2016E-02_JPRB,3.3802E-02_JPRB,2.5721E-02_JPRB,&
&1.8057E-02_JPRB,1.0339E-02_JPRB,9.3068E+00_JPRB/)
KAO( :, 2,12,11) = (/&
&6.8895E-02_JPRB,6.0321E-02_JPRB,5.2166E-02_JPRB,4.3813E-02_JPRB,3.5352E-02_JPRB,2.7349E-02_JPRB,&
&1.9762E-02_JPRB,1.1726E-02_JPRB,1.1320E+01_JPRB/)
KAO( :, 3,12,11) = (/&
&7.1293E-02_JPRB,6.2788E-02_JPRB,5.4349E-02_JPRB,4.5762E-02_JPRB,3.7291E-02_JPRB,2.9714E-02_JPRB,&
&2.1861E-02_JPRB,1.3399E-02_JPRB,1.3746E+01_JPRB/)
KAO( :, 4,12,11) = (/&
&7.4182E-02_JPRB,6.5550E-02_JPRB,5.6943E-02_JPRB,4.8285E-02_JPRB,4.0149E-02_JPRB,3.2582E-02_JPRB,&
&2.4300E-02_JPRB,1.5394E-02_JPRB,1.6888E+01_JPRB/)
KAO( :, 5,12,11) = (/&
&7.7769E-02_JPRB,6.9096E-02_JPRB,6.0288E-02_JPRB,5.1657E-02_JPRB,4.3787E-02_JPRB,3.5953E-02_JPRB,&
&2.7241E-02_JPRB,1.7571E-02_JPRB,2.0864E+01_JPRB/)
KAO( :, 1,13,11) = (/&
&6.7288E-02_JPRB,5.8877E-02_JPRB,5.0755E-02_JPRB,4.2517E-02_JPRB,3.4247E-02_JPRB,2.6263E-02_JPRB,&
&1.8588E-02_JPRB,1.0728E-02_JPRB,8.9064E+00_JPRB/)
KAO( :, 2,13,11) = (/&
&6.9672E-02_JPRB,6.1086E-02_JPRB,5.2816E-02_JPRB,4.4401E-02_JPRB,3.5953E-02_JPRB,2.8119E-02_JPRB,&
&2.0390E-02_JPRB,1.2229E-02_JPRB,1.0911E+01_JPRB/)
KAO( :, 3,13,11) = (/&
&7.2646E-02_JPRB,6.4043E-02_JPRB,5.5467E-02_JPRB,4.6763E-02_JPRB,3.8350E-02_JPRB,3.0852E-02_JPRB,&
&2.2586E-02_JPRB,1.3987E-02_JPRB,1.3268E+01_JPRB/)
KAO( :, 4,13,11) = (/&
&7.6364E-02_JPRB,6.7563E-02_JPRB,5.8748E-02_JPRB,4.9899E-02_JPRB,4.1863E-02_JPRB,3.3973E-02_JPRB,&
&2.5440E-02_JPRB,1.6181E-02_JPRB,1.6175E+01_JPRB/)
KAO( :, 5,13,11) = (/&
&8.0410E-02_JPRB,7.1534E-02_JPRB,6.2509E-02_JPRB,5.3806E-02_JPRB,4.5873E-02_JPRB,3.7854E-02_JPRB,&
&2.8649E-02_JPRB,1.8582E-02_JPRB,1.9867E+01_JPRB/)
KAO( :, 1, 1,12) = (/&
&4.9841E-02_JPRB,4.4490E-02_JPRB,4.1303E-02_JPRB,3.7661E-02_JPRB,3.4374E-02_JPRB,3.0218E-02_JPRB,&
&2.6408E-02_JPRB,2.2425E-02_JPRB,3.2278E-02_JPRB/)
KAO( :, 2, 1,12) = (/&
&5.7650E-02_JPRB,5.2260E-02_JPRB,4.8821E-02_JPRB,4.5102E-02_JPRB,4.1618E-02_JPRB,3.7433E-02_JPRB,&
&3.4112E-02_JPRB,2.9968E-02_JPRB,4.1893E-02_JPRB/)
KAO( :, 3, 1,12) = (/&
&6.5474E-02_JPRB,6.0019E-02_JPRB,5.6468E-02_JPRB,5.3494E-02_JPRB,4.9266E-02_JPRB,4.6229E-02_JPRB,&
&4.2427E-02_JPRB,3.9480E-02_JPRB,5.2169E-02_JPRB/)
KAO( :, 4, 1,12) = (/&
&7.3266E-02_JPRB,6.7747E-02_JPRB,6.4431E-02_JPRB,6.2152E-02_JPRB,5.8324E-02_JPRB,5.6278E-02_JPRB,&
&5.1411E-02_JPRB,5.1078E-02_JPRB,6.3958E-02_JPRB/)
KAO( :, 5, 1,12) = (/&
&8.0950E-02_JPRB,7.5647E-02_JPRB,7.3090E-02_JPRB,7.0878E-02_JPRB,6.8730E-02_JPRB,6.6425E-02_JPRB,&
&6.1537E-02_JPRB,6.4721E-02_JPRB,7.7752E-02_JPRB/)
KAO( :, 1, 2,12) = (/&
&4.6529E-02_JPRB,4.1918E-02_JPRB,3.8638E-02_JPRB,3.5085E-02_JPRB,3.2117E-02_JPRB,2.7976E-02_JPRB,&
&2.4660E-02_JPRB,2.0193E-02_JPRB,3.6378E-02_JPRB/)
KAO( :, 2, 2,12) = (/&
&5.4059E-02_JPRB,4.9350E-02_JPRB,4.6045E-02_JPRB,4.2538E-02_JPRB,3.9123E-02_JPRB,3.5351E-02_JPRB,&
&3.1963E-02_JPRB,2.6590E-02_JPRB,4.7334E-02_JPRB/)
KAO( :, 3, 2,12) = (/&
&6.1738E-02_JPRB,5.6865E-02_JPRB,5.3592E-02_JPRB,5.0849E-02_JPRB,4.7212E-02_JPRB,4.4241E-02_JPRB,&
&3.9834E-02_JPRB,3.4654E-02_JPRB,5.9199E-02_JPRB/)
KAO( :, 4, 2,12) = (/&
&6.9699E-02_JPRB,6.4653E-02_JPRB,6.1768E-02_JPRB,5.9341E-02_JPRB,5.6731E-02_JPRB,5.3710E-02_JPRB,&
&4.8897E-02_JPRB,4.4731E-02_JPRB,7.2042E-02_JPRB/)
KAO( :, 5, 2,12) = (/&
&7.7745E-02_JPRB,7.2901E-02_JPRB,7.0552E-02_JPRB,6.8743E-02_JPRB,6.7472E-02_JPRB,6.3767E-02_JPRB,&
&5.9291E-02_JPRB,5.7415E-02_JPRB,8.6627E-02_JPRB/)
KAO( :, 1, 3,12) = (/&
&4.2062E-02_JPRB,3.7711E-02_JPRB,3.4334E-02_JPRB,3.0926E-02_JPRB,2.8025E-02_JPRB,2.4558E-02_JPRB,&
&2.1311E-02_JPRB,1.7634E-02_JPRB,4.9902E-02_JPRB/)
KAO( :, 2, 3,12) = (/&
&4.8678E-02_JPRB,4.4324E-02_JPRB,4.1100E-02_JPRB,3.8070E-02_JPRB,3.4742E-02_JPRB,3.1650E-02_JPRB,&
&2.7890E-02_JPRB,2.3218E-02_JPRB,6.2894E-02_JPRB/)
KAO( :, 3, 3,12) = (/&
&5.6167E-02_JPRB,5.1670E-02_JPRB,4.8444E-02_JPRB,4.5977E-02_JPRB,4.2837E-02_JPRB,4.0019E-02_JPRB,&
&3.5364E-02_JPRB,3.0176E-02_JPRB,7.8591E-02_JPRB/)
KAO( :, 4, 3,12) = (/&
&6.3921E-02_JPRB,5.9620E-02_JPRB,5.6596E-02_JPRB,5.4403E-02_JPRB,5.2332E-02_JPRB,4.8849E-02_JPRB,&
&4.4022E-02_JPRB,3.8881E-02_JPRB,9.6792E-02_JPRB/)
KAO( :, 5, 3,12) = (/&
&7.1755E-02_JPRB,6.7802E-02_JPRB,6.5648E-02_JPRB,6.4060E-02_JPRB,6.2628E-02_JPRB,5.8608E-02_JPRB,&
&5.3986E-02_JPRB,4.9725E-02_JPRB,1.1574E-01_JPRB/)
KAO( :, 1, 4,12) = (/&
&4.2323E-02_JPRB,3.7345E-02_JPRB,3.2720E-02_JPRB,2.8218E-02_JPRB,2.4532E-02_JPRB,2.0757E-02_JPRB,&
&1.8047E-02_JPRB,1.5414E-02_JPRB,7.5075E-02_JPRB/)
KAO( :, 2, 4,12) = (/&
&4.5621E-02_JPRB,4.0856E-02_JPRB,3.6741E-02_JPRB,3.3228E-02_JPRB,3.0105E-02_JPRB,2.7246E-02_JPRB,&
&2.3891E-02_JPRB,2.0542E-02_JPRB,9.4476E-02_JPRB/)
KAO( :, 3, 4,12) = (/&
&5.0938E-02_JPRB,4.6389E-02_JPRB,4.2972E-02_JPRB,4.0292E-02_JPRB,3.7820E-02_JPRB,3.4834E-02_JPRB,&
&3.0651E-02_JPRB,2.6871E-02_JPRB,1.1638E-01_JPRB/)
KAO( :, 4, 4,12) = (/&
&5.7835E-02_JPRB,5.3600E-02_JPRB,5.0835E-02_JPRB,4.8668E-02_JPRB,4.6908E-02_JPRB,4.3138E-02_JPRB,&
&3.8678E-02_JPRB,3.4608E-02_JPRB,1.4036E-01_JPRB/)
KAO( :, 5, 4,12) = (/&
&6.5625E-02_JPRB,6.1550E-02_JPRB,5.9598E-02_JPRB,5.8329E-02_JPRB,5.6532E-02_JPRB,5.2486E-02_JPRB,&
&4.8246E-02_JPRB,4.4046E-02_JPRB,1.6774E-01_JPRB/)
KAO( :, 1, 5,12) = (/&
&4.7313E-02_JPRB,4.1507E-02_JPRB,3.5955E-02_JPRB,3.0395E-02_JPRB,2.4915E-02_JPRB,1.9463E-02_JPRB,&
&1.5471E-02_JPRB,1.3526E-02_JPRB,1.1349E-01_JPRB/)
KAO( :, 2, 5,12) = (/&
&4.9244E-02_JPRB,4.3467E-02_JPRB,3.7885E-02_JPRB,3.2452E-02_JPRB,2.7414E-02_JPRB,2.3444E-02_JPRB,&
&2.0705E-02_JPRB,1.8174E-02_JPRB,1.4301E-01_JPRB/)
KAO( :, 3, 5,12) = (/&
&5.1407E-02_JPRB,4.5739E-02_JPRB,4.0584E-02_JPRB,3.6389E-02_JPRB,3.2936E-02_JPRB,2.9965E-02_JPRB,&
&2.6974E-02_JPRB,2.4069E-02_JPRB,1.7509E-01_JPRB/)
KAO( :, 4, 5,12) = (/&
&5.5244E-02_JPRB,5.0142E-02_JPRB,4.5994E-02_JPRB,4.3212E-02_JPRB,4.1091E-02_JPRB,3.7645E-02_JPRB,&
&3.4454E-02_JPRB,3.1352E-02_JPRB,2.1139E-01_JPRB/)
KAO( :, 5, 5,12) = (/&
&6.0988E-02_JPRB,5.6526E-02_JPRB,5.3622E-02_JPRB,5.2392E-02_JPRB,5.0078E-02_JPRB,4.6505E-02_JPRB,&
&4.3357E-02_JPRB,4.0176E-02_JPRB,2.5233E-01_JPRB/)
KAO( :, 1, 6,12) = (/&
&5.3543E-02_JPRB,4.6854E-02_JPRB,4.0556E-02_JPRB,3.4124E-02_JPRB,2.7581E-02_JPRB,2.1205E-02_JPRB,&
&1.5012E-02_JPRB,1.1854E-02_JPRB,1.6344E-01_JPRB/)
KAO( :, 2, 6,12) = (/&
&5.5268E-02_JPRB,4.8609E-02_JPRB,4.2123E-02_JPRB,3.5498E-02_JPRB,2.9110E-02_JPRB,2.2794E-02_JPRB,&
&1.8116E-02_JPRB,1.5898E-02_JPRB,2.0983E-01_JPRB/)
KAO( :, 3, 6,12) = (/&
&5.7133E-02_JPRB,5.0456E-02_JPRB,4.3928E-02_JPRB,3.7527E-02_JPRB,3.1445E-02_JPRB,2.6337E-02_JPRB,&
&2.3556E-02_JPRB,2.1068E-02_JPRB,2.6329E-01_JPRB/)
KAO( :, 4, 6,12) = (/&
&5.9454E-02_JPRB,5.2789E-02_JPRB,4.6413E-02_JPRB,4.0569E-02_JPRB,3.6370E-02_JPRB,3.2588E-02_JPRB,&
&3.0510E-02_JPRB,2.7765E-02_JPRB,3.2205E-01_JPRB/)
KAO( :, 5, 6,12) = (/&
&6.2205E-02_JPRB,5.6007E-02_JPRB,5.0615E-02_JPRB,4.6993E-02_JPRB,4.3715E-02_JPRB,4.0774E-02_JPRB,&
&3.8896E-02_JPRB,3.6103E-02_JPRB,3.8619E-01_JPRB/)
KAO( :, 1, 7,12) = (/&
&6.0265E-02_JPRB,5.2736E-02_JPRB,4.5532E-02_JPRB,3.8162E-02_JPRB,3.0863E-02_JPRB,2.3507E-02_JPRB,&
&1.6295E-02_JPRB,1.0412E-02_JPRB,2.4973E-01_JPRB/)
KAO( :, 2, 7,12) = (/&
&6.2205E-02_JPRB,5.4530E-02_JPRB,4.7203E-02_JPRB,3.9805E-02_JPRB,3.2362E-02_JPRB,2.4886E-02_JPRB,&
&1.8121E-02_JPRB,1.3884E-02_JPRB,3.2971E-01_JPRB/)
KAO( :, 3, 7,12) = (/&
&6.4226E-02_JPRB,5.6598E-02_JPRB,4.9127E-02_JPRB,4.1578E-02_JPRB,3.4062E-02_JPRB,2.6961E-02_JPRB,&
&2.1190E-02_JPRB,1.8496E-02_JPRB,4.1960E-01_JPRB/)
KAO( :, 4, 7,12) = (/&
&6.6268E-02_JPRB,5.8530E-02_JPRB,5.0921E-02_JPRB,4.3485E-02_JPRB,3.6432E-02_JPRB,3.0158E-02_JPRB,&
&2.6927E-02_JPRB,2.4386E-02_JPRB,5.2305E-01_JPRB/)
KAO( :, 5, 7,12) = (/&
&6.9017E-02_JPRB,6.1350E-02_JPRB,5.3776E-02_JPRB,4.6719E-02_JPRB,4.0414E-02_JPRB,3.6297E-02_JPRB,&
&3.4763E-02_JPRB,3.1958E-02_JPRB,6.4099E-01_JPRB/)
KAO( :, 1, 8,12) = (/&
&6.7351E-02_JPRB,5.8939E-02_JPRB,5.0741E-02_JPRB,4.2559E-02_JPRB,3.4322E-02_JPRB,2.6023E-02_JPRB,&
&1.7903E-02_JPRB,1.0436E-02_JPRB,4.7669E-01_JPRB/)
KAO( :, 2, 8,12) = (/&
&6.9803E-02_JPRB,6.1083E-02_JPRB,5.2877E-02_JPRB,4.4484E-02_JPRB,3.5947E-02_JPRB,2.7535E-02_JPRB,&
&1.9536E-02_JPRB,1.2383E-02_JPRB,6.1756E-01_JPRB/)
KAO( :, 3, 8,12) = (/&
&7.2114E-02_JPRB,6.3433E-02_JPRB,5.4955E-02_JPRB,4.6298E-02_JPRB,3.7783E-02_JPRB,2.9395E-02_JPRB,&
&2.1671E-02_JPRB,1.6236E-02_JPRB,8.0333E-01_JPRB/)
KAO( :, 4, 8,12) = (/&
&7.4179E-02_JPRB,6.5484E-02_JPRB,5.6918E-02_JPRB,4.8333E-02_JPRB,3.9986E-02_JPRB,3.1892E-02_JPRB,&
&2.4841E-02_JPRB,2.1727E-02_JPRB,1.0238E+00_JPRB/)
KAO( :, 5, 8,12) = (/&
&7.6619E-02_JPRB,6.7894E-02_JPRB,5.9259E-02_JPRB,5.0828E-02_JPRB,4.2369E-02_JPRB,3.5339E-02_JPRB,&
&3.0974E-02_JPRB,2.8579E-02_JPRB,1.2721E+00_JPRB/)
KAO( :, 1, 9,12) = (/&
&7.4478E-02_JPRB,6.5171E-02_JPRB,5.5864E-02_JPRB,4.6941E-02_JPRB,3.7748E-02_JPRB,2.8605E-02_JPRB,&
&1.9435E-02_JPRB,1.1004E-02_JPRB,1.7884E+00_JPRB/)
KAO( :, 2, 9,12) = (/&
&7.7257E-02_JPRB,6.7603E-02_JPRB,5.8386E-02_JPRB,4.8944E-02_JPRB,3.9580E-02_JPRB,3.0097E-02_JPRB,&
&2.0950E-02_JPRB,1.2526E-02_JPRB,2.2521E+00_JPRB/)
KAO( :, 3, 9,12) = (/&
&7.9904E-02_JPRB,7.0069E-02_JPRB,6.0638E-02_JPRB,5.1114E-02_JPRB,4.1495E-02_JPRB,3.1843E-02_JPRB,&
&2.3233E-02_JPRB,1.4537E-02_JPRB,2.9339E+00_JPRB/)
KAO( :, 4, 9,12) = (/&
&8.2346E-02_JPRB,7.2597E-02_JPRB,6.3019E-02_JPRB,5.3300E-02_JPRB,4.3544E-02_JPRB,3.4492E-02_JPRB,&
&2.5780E-02_JPRB,1.8842E-02_JPRB,3.7982E+00_JPRB/)
KAO( :, 5, 9,12) = (/&
&8.4921E-02_JPRB,7.5081E-02_JPRB,6.5371E-02_JPRB,5.5672E-02_JPRB,4.6484E-02_JPRB,3.7440E-02_JPRB,&
&2.9153E-02_JPRB,2.5208E-02_JPRB,4.8104E+00_JPRB/)
KAO( :, 1,10,12) = (/&
&8.1560E-02_JPRB,7.1369E-02_JPRB,6.1175E-02_JPRB,5.1264E-02_JPRB,4.1241E-02_JPRB,3.1126E-02_JPRB,&
&2.1112E-02_JPRB,1.1696E-02_JPRB,7.4468E+00_JPRB/)
KAO( :, 2,10,12) = (/&
&8.4440E-02_JPRB,7.3887E-02_JPRB,6.3687E-02_JPRB,5.3392E-02_JPRB,4.3082E-02_JPRB,3.2635E-02_JPRB,&
&2.2609E-02_JPRB,1.3248E-02_JPRB,9.2981E+00_JPRB/)
KAO( :, 3,10,12) = (/&
&8.7510E-02_JPRB,7.6590E-02_JPRB,6.6316E-02_JPRB,5.5795E-02_JPRB,4.5078E-02_JPRB,3.4503E-02_JPRB,&
&2.4942E-02_JPRB,1.4958E-02_JPRB,1.2082E+01_JPRB/)
KAO( :, 4,10,12) = (/&
&9.0511E-02_JPRB,7.9705E-02_JPRB,6.9107E-02_JPRB,5.8258E-02_JPRB,4.7506E-02_JPRB,3.7279E-02_JPRB,&
&2.7590E-02_JPRB,1.7415E-02_JPRB,1.5900E+01_JPRB/)
KAO( :, 5,10,12) = (/&
&9.3419E-02_JPRB,8.2537E-02_JPRB,7.1769E-02_JPRB,6.0958E-02_JPRB,5.0392E-02_JPRB,4.0420E-02_JPRB,&
&3.0465E-02_JPRB,2.2350E-02_JPRB,2.0480E+01_JPRB/)
KAO( :, 1,11,12) = (/&
&8.9464E-02_JPRB,7.8283E-02_JPRB,6.7101E-02_JPRB,5.6285E-02_JPRB,4.5266E-02_JPRB,3.4192E-02_JPRB,&
&2.3302E-02_JPRB,1.2995E-02_JPRB,1.1790E+01_JPRB/)
KAO( :, 2,11,12) = (/&
&9.2590E-02_JPRB,8.1019E-02_JPRB,6.9897E-02_JPRB,5.8591E-02_JPRB,4.7313E-02_JPRB,3.5860E-02_JPRB,&
&2.5050E-02_JPRB,1.4711E-02_JPRB,1.4906E+01_JPRB/)
KAO( :, 3,11,12) = (/&
&9.5857E-02_JPRB,8.3955E-02_JPRB,7.2681E-02_JPRB,6.1172E-02_JPRB,4.9475E-02_JPRB,3.7915E-02_JPRB,&
&2.7663E-02_JPRB,1.6572E-02_JPRB,1.9642E+01_JPRB/)
KAO( :, 4,11,12) = (/&
&9.9442E-02_JPRB,8.7628E-02_JPRB,7.5988E-02_JPRB,6.4098E-02_JPRB,5.2240E-02_JPRB,4.1108E-02_JPRB,&
&3.0576E-02_JPRB,1.8973E-02_JPRB,2.5991E+01_JPRB/)
KAO( :, 5,11,12) = (/&
&1.0289E-01_JPRB,9.0944E-02_JPRB,7.9112E-02_JPRB,6.7235E-02_JPRB,5.5656E-02_JPRB,4.4964E-02_JPRB,&
&3.3825E-02_JPRB,2.2911E-02_JPRB,3.3545E+01_JPRB/)
KAO( :, 1,12,12) = (/&
&9.6584E-02_JPRB,8.4508E-02_JPRB,7.2437E-02_JPRB,6.0815E-02_JPRB,4.8901E-02_JPRB,3.6973E-02_JPRB,&
&2.5367E-02_JPRB,1.4216E-02_JPRB,1.4049E+01_JPRB/)
KAO( :, 2,12,12) = (/&
&9.9962E-02_JPRB,8.7468E-02_JPRB,7.5539E-02_JPRB,6.3320E-02_JPRB,5.1161E-02_JPRB,3.8859E-02_JPRB,&
&2.7427E-02_JPRB,1.6079E-02_JPRB,1.7978E+01_JPRB/)
KAO( :, 3,12,12) = (/&
&1.0340E-01_JPRB,9.0660E-02_JPRB,7.8491E-02_JPRB,6.6122E-02_JPRB,5.3580E-02_JPRB,4.1278E-02_JPRB,&
&3.0377E-02_JPRB,1.8202E-02_JPRB,2.3758E+01_JPRB/)
KAO( :, 4,12,12) = (/&
&1.0749E-01_JPRB,9.4783E-02_JPRB,8.2213E-02_JPRB,6.9419E-02_JPRB,5.6626E-02_JPRB,4.4917E-02_JPRB,&
&3.3518E-02_JPRB,2.0812E-02_JPRB,3.1380E+01_JPRB/)
KAO( :, 5,12,12) = (/&
&1.1220E-01_JPRB,9.9222E-02_JPRB,8.6341E-02_JPRB,7.3393E-02_JPRB,6.0808E-02_JPRB,4.9200E-02_JPRB,&
&3.7236E-02_JPRB,2.4135E-02_JPRB,4.0595E+01_JPRB/)
KAO( :, 1,13,12) = (/&
&1.0300E-01_JPRB,9.0135E-02_JPRB,7.7297E-02_JPRB,6.4939E-02_JPRB,5.2208E-02_JPRB,3.9524E-02_JPRB,&
&2.7327E-02_JPRB,1.5400E-02_JPRB,1.3848E+01_JPRB/)
KAO( :, 2,13,12) = (/&
&1.0667E-01_JPRB,9.3334E-02_JPRB,8.0681E-02_JPRB,6.7642E-02_JPRB,5.4655E-02_JPRB,4.1706E-02_JPRB,&
&2.9739E-02_JPRB,1.7385E-02_JPRB,1.7658E+01_JPRB/)
KAO( :, 3,13,12) = (/&
&1.1046E-01_JPRB,9.6956E-02_JPRB,8.3948E-02_JPRB,7.0727E-02_JPRB,5.7403E-02_JPRB,4.4569E-02_JPRB,&
&3.2904E-02_JPRB,1.9868E-02_JPRB,2.3136E+01_JPRB/)
KAO( :, 4,13,12) = (/&
&1.1527E-01_JPRB,1.0171E-01_JPRB,8.8265E-02_JPRB,7.4632E-02_JPRB,6.1070E-02_JPRB,4.8844E-02_JPRB,&
&3.6366E-02_JPRB,2.2679E-02_JPRB,3.0331E+01_JPRB/)
KAO( :, 5,13,12) = (/&
&1.2126E-01_JPRB,1.0736E-01_JPRB,9.3522E-02_JPRB,7.9617E-02_JPRB,6.6218E-02_JPRB,5.3664E-02_JPRB,&
&4.0795E-02_JPRB,2.6028E-02_JPRB,3.9050E+01_JPRB/)
KAO( :, 1, 1,13) = (/&
&7.7575E-02_JPRB,6.7876E-02_JPRB,6.3410E-02_JPRB,5.7807E-02_JPRB,5.1861E-02_JPRB,4.6380E-02_JPRB,&
&3.9791E-02_JPRB,3.9685E-02_JPRB,4.9236E-02_JPRB/)
KAO( :, 2, 1,13) = (/&
&8.9138E-02_JPRB,7.8170E-02_JPRB,7.4208E-02_JPRB,6.9230E-02_JPRB,6.2955E-02_JPRB,5.7605E-02_JPRB,&
&5.0411E-02_JPRB,5.4657E-02_JPRB,6.4256E-02_JPRB/)
KAO( :, 3, 1,13) = (/&
&1.0111E-01_JPRB,8.9496E-02_JPRB,8.5836E-02_JPRB,8.0803E-02_JPRB,7.5668E-02_JPRB,6.9307E-02_JPRB,&
&6.4355E-02_JPRB,7.2863E-02_JPRB,8.3997E-02_JPRB/)
KAO( :, 4, 1,13) = (/&
&1.1325E-01_JPRB,1.0162E-01_JPRB,9.8222E-02_JPRB,9.3360E-02_JPRB,8.9664E-02_JPRB,8.2030E-02_JPRB,&
&8.1890E-02_JPRB,9.4421E-02_JPRB,1.0835E-01_JPRB/)
KAO( :, 5, 1,13) = (/&
&1.2539E-01_JPRB,1.1433E-01_JPRB,1.1116E-01_JPRB,1.0717E-01_JPRB,1.0371E-01_JPRB,9.7171E-02_JPRB,&
&1.0295E-01_JPRB,1.1937E-01_JPRB,1.3710E-01_JPRB/)
KAO( :, 1, 2,13) = (/&
&7.5084E-02_JPRB,6.5711E-02_JPRB,6.1443E-02_JPRB,5.6215E-02_JPRB,5.0525E-02_JPRB,4.5190E-02_JPRB,&
&3.8256E-02_JPRB,3.4359E-02_JPRB,5.8705E-02_JPRB/)
KAO( :, 2, 2,13) = (/&
&8.7481E-02_JPRB,7.7103E-02_JPRB,7.2673E-02_JPRB,6.7753E-02_JPRB,6.2029E-02_JPRB,5.6624E-02_JPRB,&
&4.8617E-02_JPRB,4.8264E-02_JPRB,7.3515E-02_JPRB/)
KAO( :, 3, 2,13) = (/&
&1.0027E-01_JPRB,8.9526E-02_JPRB,8.4990E-02_JPRB,7.9770E-02_JPRB,7.5196E-02_JPRB,6.8702E-02_JPRB,&
&6.1742E-02_JPRB,6.5561E-02_JPRB,9.1679E-02_JPRB/)
KAO( :, 4, 2,13) = (/&
&1.1299E-01_JPRB,1.0255E-01_JPRB,9.8199E-02_JPRB,9.3168E-02_JPRB,8.9322E-02_JPRB,8.2695E-02_JPRB,&
&7.7970E-02_JPRB,8.6300E-02_JPRB,1.1329E-01_JPRB/)
KAO( :, 5, 2,13) = (/&
&1.2555E-01_JPRB,1.1568E-01_JPRB,1.1171E-01_JPRB,1.0774E-01_JPRB,1.0377E-01_JPRB,9.8889E-02_JPRB,&
&9.7493E-02_JPRB,1.1062E-01_JPRB,1.3853E-01_JPRB/)
KAO( :, 1, 3,13) = (/&
&6.9691E-02_JPRB,6.1107E-02_JPRB,5.6756E-02_JPRB,5.1486E-02_JPRB,4.6192E-02_JPRB,4.1148E-02_JPRB,&
&3.4753E-02_JPRB,2.8332E-02_JPRB,8.2983E-02_JPRB/)
KAO( :, 2, 3,13) = (/&
&8.2227E-02_JPRB,7.2883E-02_JPRB,6.8298E-02_JPRB,6.2912E-02_JPRB,5.7544E-02_JPRB,5.2210E-02_JPRB,&
&4.4957E-02_JPRB,4.0005E-02_JPRB,1.0478E-01_JPRB/)
KAO( :, 3, 3,13) = (/&
&9.4982E-02_JPRB,8.5432E-02_JPRB,8.0995E-02_JPRB,7.5178E-02_JPRB,7.0646E-02_JPRB,6.4384E-02_JPRB,&
&5.7678E-02_JPRB,5.5116E-02_JPRB,1.2972E-01_JPRB/)
KAO( :, 4, 3,13) = (/&
&1.0814E-01_JPRB,9.8743E-02_JPRB,9.4541E-02_JPRB,8.8889E-02_JPRB,8.4938E-02_JPRB,7.8960E-02_JPRB,&
&7.3010E-02_JPRB,7.4136E-02_JPRB,1.5589E-01_JPRB/)
KAO( :, 5, 3,13) = (/&
&1.2147E-01_JPRB,1.1222E-01_JPRB,1.0815E-01_JPRB,1.0392E-01_JPRB,1.0025E-01_JPRB,9.5831E-02_JPRB,&
&9.0492E-02_JPRB,9.6998E-02_JPRB,1.8572E-01_JPRB/)
KAO( :, 1, 4,13) = (/&
&6.2565E-02_JPRB,5.4985E-02_JPRB,5.1005E-02_JPRB,4.5945E-02_JPRB,4.0688E-02_JPRB,3.6000E-02_JPRB,&
&3.0283E-02_JPRB,2.3725E-02_JPRB,1.3254E-01_JPRB/)
KAO( :, 2, 4,13) = (/&
&7.4730E-02_JPRB,6.6495E-02_JPRB,6.2334E-02_JPRB,5.7038E-02_JPRB,5.1581E-02_JPRB,4.6682E-02_JPRB,&
&4.0217E-02_JPRB,3.3423E-02_JPRB,1.6553E-01_JPRB/)
KAO( :, 3, 4,13) = (/&
&8.7721E-02_JPRB,7.9227E-02_JPRB,7.4754E-02_JPRB,6.9285E-02_JPRB,6.4310E-02_JPRB,5.8891E-02_JPRB,&
&5.2591E-02_JPRB,4.6205E-02_JPRB,2.0091E-01_JPRB/)
KAO( :, 4, 4,13) = (/&
&1.0117E-01_JPRB,9.2830E-02_JPRB,8.8248E-02_JPRB,8.2981E-02_JPRB,7.8335E-02_JPRB,7.3405E-02_JPRB,&
&6.7339E-02_JPRB,6.2337E-02_JPRB,2.4019E-01_JPRB/)
KAO( :, 5, 4,13) = (/&
&1.1481E-01_JPRB,1.0652E-01_JPRB,1.0206E-01_JPRB,9.8001E-02_JPRB,9.4065E-02_JPRB,9.0188E-02_JPRB,&
&8.3658E-02_JPRB,8.2259E-02_JPRB,2.8323E-01_JPRB/)
KAO( :, 1, 5,13) = (/&
&5.8407E-02_JPRB,5.1108E-02_JPRB,4.6239E-02_JPRB,4.0778E-02_JPRB,3.5382E-02_JPRB,3.0729E-02_JPRB,&
&2.5929E-02_JPRB,2.0262E-02_JPRB,2.0976E-01_JPRB/)
KAO( :, 2, 5,13) = (/&
&6.7590E-02_JPRB,6.0046E-02_JPRB,5.5590E-02_JPRB,5.0588E-02_JPRB,4.5609E-02_JPRB,4.0658E-02_JPRB,&
&3.5218E-02_JPRB,2.8718E-02_JPRB,2.6203E-01_JPRB/)
KAO( :, 3, 5,13) = (/&
&7.9667E-02_JPRB,7.2301E-02_JPRB,6.7704E-02_JPRB,6.2413E-02_JPRB,5.7716E-02_JPRB,5.2470E-02_JPRB,&
&4.6833E-02_JPRB,3.9205E-02_JPRB,3.2020E-01_JPRB/)
KAO( :, 4, 5,13) = (/&
&9.2812E-02_JPRB,8.5546E-02_JPRB,8.0951E-02_JPRB,7.5755E-02_JPRB,7.1407E-02_JPRB,6.6676E-02_JPRB,&
&6.0889E-02_JPRB,5.2582E-02_JPRB,3.8339E-01_JPRB/)
KAO( :, 5, 5,13) = (/&
&1.0648E-01_JPRB,9.9221E-02_JPRB,9.4821E-02_JPRB,9.0576E-02_JPRB,8.7197E-02_JPRB,8.3294E-02_JPRB,&
&7.6479E-02_JPRB,6.9420E-02_JPRB,4.4984E-01_JPRB/)
KAO( :, 1, 6,13) = (/&
&6.1074E-02_JPRB,5.3442E-02_JPRB,4.6642E-02_JPRB,3.9682E-02_JPRB,3.3065E-02_JPRB,2.6709E-02_JPRB,&
&2.1402E-02_JPRB,1.7316E-02_JPRB,3.1217E-01_JPRB/)
KAO( :, 2, 6,13) = (/&
&6.6102E-02_JPRB,5.8128E-02_JPRB,5.1965E-02_JPRB,4.5770E-02_JPRB,3.9615E-02_JPRB,3.4605E-02_JPRB,&
&2.9773E-02_JPRB,2.4794E-02_JPRB,3.9753E-01_JPRB/)
KAO( :, 3, 6,13) = (/&
&7.3850E-02_JPRB,6.6350E-02_JPRB,6.0820E-02_JPRB,5.4981E-02_JPRB,5.0172E-02_JPRB,4.5675E-02_JPRB,&
&4.0524E-02_JPRB,3.4061E-02_JPRB,4.9206E-01_JPRB/)
KAO( :, 4, 6,13) = (/&
&8.4087E-02_JPRB,7.7167E-02_JPRB,7.2506E-02_JPRB,6.7577E-02_JPRB,6.3361E-02_JPRB,5.9142E-02_JPRB,&
&5.3549E-02_JPRB,4.5331E-02_JPRB,5.9295E-01_JPRB/)
KAO( :, 5, 6,13) = (/&
&9.7016E-02_JPRB,9.0406E-02_JPRB,8.6048E-02_JPRB,8.1976E-02_JPRB,7.8673E-02_JPRB,7.5050E-02_JPRB,&
&6.8277E-02_JPRB,5.9321E-02_JPRB,7.0097E-01_JPRB/)
KAO( :, 1, 7,13) = (/&
&6.9484E-02_JPRB,6.0801E-02_JPRB,5.2496E-02_JPRB,4.4095E-02_JPRB,3.5736E-02_JPRB,2.7213E-02_JPRB,&
&1.9462E-02_JPRB,1.5131E-02_JPRB,4.9666E-01_JPRB/)
KAO( :, 2, 7,13) = (/&
&7.2482E-02_JPRB,6.3426E-02_JPRB,5.5184E-02_JPRB,4.6899E-02_JPRB,3.8506E-02_JPRB,3.1147E-02_JPRB,&
&2.5118E-02_JPRB,2.1656E-02_JPRB,6.3678E-01_JPRB/)
KAO( :, 3, 7,13) = (/&
&7.6126E-02_JPRB,6.7402E-02_JPRB,5.9699E-02_JPRB,5.1994E-02_JPRB,4.4998E-02_JPRB,3.9088E-02_JPRB,&
&3.4888E-02_JPRB,3.0019E-02_JPRB,7.9664E-01_JPRB/)
KAO( :, 4, 7,13) = (/&
&8.2337E-02_JPRB,7.4163E-02_JPRB,6.7469E-02_JPRB,6.0768E-02_JPRB,5.5760E-02_JPRB,5.1620E-02_JPRB,&
&4.6705E-02_JPRB,4.0344E-02_JPRB,9.7480E-01_JPRB/)
KAO( :, 5, 7,13) = (/&
&9.1160E-02_JPRB,8.3680E-02_JPRB,7.7975E-02_JPRB,7.3495E-02_JPRB,7.0289E-02_JPRB,6.6562E-02_JPRB,&
&6.0431E-02_JPRB,5.2966E-02_JPRB,1.1667E+00_JPRB/)
KAO( :, 1, 8,13) = (/&
&7.9875E-02_JPRB,6.9892E-02_JPRB,5.9964E-02_JPRB,5.0404E-02_JPRB,4.0546E-02_JPRB,3.0791E-02_JPRB,&
&2.0999E-02_JPRB,1.3352E-02_JPRB,9.4134E-01_JPRB/)
KAO( :, 2, 8,13) = (/&
&8.2831E-02_JPRB,7.2481E-02_JPRB,6.2676E-02_JPRB,5.2633E-02_JPRB,4.2647E-02_JPRB,3.2676E-02_JPRB,&
&2.3318E-02_JPRB,1.9244E-02_JPRB,1.2413E+00_JPRB/)
KAO( :, 3, 8,13) = (/&
&8.5814E-02_JPRB,7.5310E-02_JPRB,6.5363E-02_JPRB,5.5397E-02_JPRB,4.5622E-02_JPRB,3.6515E-02_JPRB,&
&3.0395E-02_JPRB,2.6861E-02_JPRB,1.5851E+00_JPRB/)
KAO( :, 4, 8,13) = (/&
&8.9328E-02_JPRB,7.9178E-02_JPRB,6.9765E-02_JPRB,6.0251E-02_JPRB,5.1815E-02_JPRB,4.5308E-02_JPRB,&
&4.1250E-02_JPRB,3.6343E-02_JPRB,1.9653E+00_JPRB/)
KAO( :, 5, 8,13) = (/&
&9.4353E-02_JPRB,8.4864E-02_JPRB,7.6567E-02_JPRB,6.8745E-02_JPRB,6.3044E-02_JPRB,5.8949E-02_JPRB,&
&5.4004E-02_JPRB,4.8133E-02_JPRB,2.3851E+00_JPRB/)
KAO( :, 1, 9,13) = (/&
&9.1060E-02_JPRB,7.9678E-02_JPRB,6.8298E-02_JPRB,5.7272E-02_JPRB,4.6070E-02_JPRB,3.4830E-02_JPRB,&
&2.3532E-02_JPRB,1.3075E-02_JPRB,3.3036E+00_JPRB/)
KAO( :, 2, 9,13) = (/&
&9.4393E-02_JPRB,8.2597E-02_JPRB,7.1203E-02_JPRB,5.9719E-02_JPRB,4.8226E-02_JPRB,3.6550E-02_JPRB,&
&2.5153E-02_JPRB,1.6919E-02_JPRB,4.4974E+00_JPRB/)
KAO( :, 3, 9,13) = (/&
&9.7943E-02_JPRB,8.5705E-02_JPRB,7.4242E-02_JPRB,6.2533E-02_JPRB,5.0588E-02_JPRB,3.8901E-02_JPRB,&
&2.8455E-02_JPRB,2.3917E-02_JPRB,5.8908E+00_JPRB/)
KAO( :, 4, 9,13) = (/&
&1.0146E-01_JPRB,8.9335E-02_JPRB,7.7594E-02_JPRB,6.5536E-02_JPRB,5.3840E-02_JPRB,4.3166E-02_JPRB,&
&3.6140E-02_JPRB,3.2576E-02_JPRB,7.5007E+00_JPRB/)
KAO( :, 5, 9,13) = (/&
&1.0475E-01_JPRB,9.2703E-02_JPRB,8.1242E-02_JPRB,7.0200E-02_JPRB,6.0029E-02_JPRB,5.2409E-02_JPRB,&
&4.7785E-02_JPRB,4.3561E-02_JPRB,9.3123E+00_JPRB/)
KAO( :, 1,10,13) = (/&
&1.0323E-01_JPRB,9.0321E-02_JPRB,7.7420E-02_JPRB,6.4606E-02_JPRB,5.2109E-02_JPRB,3.9304E-02_JPRB,&
&2.6545E-02_JPRB,1.4340E-02_JPRB,1.3176E+01_JPRB/)
KAO( :, 2,10,13) = (/&
&1.0726E-01_JPRB,9.3851E-02_JPRB,8.0568E-02_JPRB,6.7728E-02_JPRB,5.4502E-02_JPRB,4.1373E-02_JPRB,&
&2.8209E-02_JPRB,1.6426E-02_JPRB,1.8337E+01_JPRB/)
KAO( :, 3,10,13) = (/&
&1.1119E-01_JPRB,9.7297E-02_JPRB,8.4158E-02_JPRB,7.0666E-02_JPRB,5.7175E-02_JPRB,4.3645E-02_JPRB,&
&3.0420E-02_JPRB,2.1518E-02_JPRB,2.4733E+01_JPRB/)
KAO( :, 4,10,13) = (/&
&1.1524E-01_JPRB,1.0114E-01_JPRB,8.7553E-02_JPRB,7.3838E-02_JPRB,6.0042E-02_JPRB,4.6213E-02_JPRB,&
&3.5024E-02_JPRB,2.9502E-02_JPRB,3.2293E+01_JPRB/)
KAO( :, 5,10,13) = (/&
&1.1918E-01_JPRB,1.0517E-01_JPRB,9.1457E-02_JPRB,7.7569E-02_JPRB,6.3670E-02_JPRB,5.1602E-02_JPRB,&
&4.3593E-02_JPRB,3.9624E-02_JPRB,4.0987E+01_JPRB/)
KAO( :, 1,11,13) = (/&
&1.1809E-01_JPRB,1.0333E-01_JPRB,8.8567E-02_JPRB,7.3956E-02_JPRB,5.9648E-02_JPRB,4.4991E-02_JPRB,&
&3.0394E-02_JPRB,1.6520E-02_JPRB,2.1329E+01_JPRB/)
KAO( :, 2,11,13) = (/&
&1.2259E-01_JPRB,1.0727E-01_JPRB,9.2136E-02_JPRB,7.7442E-02_JPRB,6.2348E-02_JPRB,4.7316E-02_JPRB,&
&3.2372E-02_JPRB,1.8681E-02_JPRB,3.0195E+01_JPRB/)
KAO( :, 3,11,13) = (/&
&1.2699E-01_JPRB,1.1113E-01_JPRB,9.6180E-02_JPRB,8.0804E-02_JPRB,6.5376E-02_JPRB,4.9936E-02_JPRB,&
&3.5020E-02_JPRB,2.2950E-02_JPRB,4.1235E+01_JPRB/)
KAO( :, 4,11,13) = (/&
&1.3128E-01_JPRB,1.1530E-01_JPRB,9.9899E-02_JPRB,8.4291E-02_JPRB,6.8622E-02_JPRB,5.2932E-02_JPRB,&
&3.9181E-02_JPRB,3.0475E-02_JPRB,5.4497E+01_JPRB/)
KAO( :, 5,11,13) = (/&
&1.3614E-01_JPRB,1.2013E-01_JPRB,1.0437E-01_JPRB,8.8367E-02_JPRB,7.2398E-02_JPRB,5.7416E-02_JPRB,&
&4.6256E-02_JPRB,4.1156E-02_JPRB,6.9986E+01_JPRB/)
KAO( :, 1,12,13) = (/&
&1.3386E-01_JPRB,1.1712E-01_JPRB,1.0039E-01_JPRB,8.3885E-02_JPRB,6.7654E-02_JPRB,5.1023E-02_JPRB,&
&3.4519E-02_JPRB,1.8911E-02_JPRB,2.6006E+01_JPRB/)
KAO( :, 2,12,13) = (/&
&1.3877E-01_JPRB,1.2143E-01_JPRB,1.0437E-01_JPRB,8.7721E-02_JPRB,7.0645E-02_JPRB,5.3609E-02_JPRB,&
&3.6836E-02_JPRB,2.1259E-02_JPRB,3.7252E+01_JPRB/)
KAO( :, 3,12,13) = (/&
&1.4375E-01_JPRB,1.2579E-01_JPRB,1.0893E-01_JPRB,9.1548E-02_JPRB,7.4049E-02_JPRB,5.6582E-02_JPRB,&
&3.9974E-02_JPRB,2.4775E-02_JPRB,5.1456E+01_JPRB/)
KAO( :, 4,12,13) = (/&
&1.4854E-01_JPRB,1.3051E-01_JPRB,1.1314E-01_JPRB,9.5475E-02_JPRB,7.7776E-02_JPRB,6.0170E-02_JPRB,&
&4.4338E-02_JPRB,3.1553E-02_JPRB,6.8626E+01_JPRB/)
KAO( :, 5,12,13) = (/&
&1.5381E-01_JPRB,1.3581E-01_JPRB,1.1807E-01_JPRB,1.0009E-01_JPRB,8.2154E-02_JPRB,6.5109E-02_JPRB,&
&5.0201E-02_JPRB,4.2427E-02_JPRB,8.8644E+01_JPRB/)
KAO( :, 1,13,13) = (/&
&1.5013E-01_JPRB,1.3136E-01_JPRB,1.1260E-01_JPRB,9.4157E-02_JPRB,7.5949E-02_JPRB,5.7300E-02_JPRB,&
&3.8872E-02_JPRB,2.1485E-02_JPRB,2.5822E+01_JPRB/)
KAO( :, 2,13,13) = (/&
&1.5573E-01_JPRB,1.3627E-01_JPRB,1.1719E-01_JPRB,9.8539E-02_JPRB,7.9406E-02_JPRB,6.0263E-02_JPRB,&
&4.1620E-02_JPRB,2.4096E-02_JPRB,3.6956E+01_JPRB/)
KAO( :, 3,13,13) = (/&
&1.6146E-01_JPRB,1.4129E-01_JPRB,1.2242E-01_JPRB,1.0291E-01_JPRB,8.3225E-02_JPRB,6.3641E-02_JPRB,&
&4.5364E-02_JPRB,2.7291E-02_JPRB,5.1399E+01_JPRB/)
KAO( :, 4,13,13) = (/&
&1.6709E-01_JPRB,1.4686E-01_JPRB,1.2738E-01_JPRB,1.0746E-01_JPRB,8.7536E-02_JPRB,6.7870E-02_JPRB,&
&5.0138E-02_JPRB,3.3350E-02_JPRB,6.8906E+01_JPRB/)
KAO( :, 5,13,13) = (/&
&1.7380E-01_JPRB,1.5350E-01_JPRB,1.3346E-01_JPRB,1.1314E-01_JPRB,9.2912E-02_JPRB,7.3777E-02_JPRB,&
&5.5622E-02_JPRB,4.3609E-02_JPRB,8.9452E+01_JPRB/)
KAO( :, 1, 1,14) = (/&
&1.2272E-01_JPRB,1.0738E-01_JPRB,9.4283E-02_JPRB,8.6737E-02_JPRB,7.7664E-02_JPRB,7.2045E-02_JPRB,&
&7.8412E-02_JPRB,9.0417E-02_JPRB,1.0437E-01_JPRB/)
KAO( :, 2, 1,14) = (/&
&1.4194E-01_JPRB,1.2421E-01_JPRB,1.1268E-01_JPRB,1.0273E-01_JPRB,9.4698E-02_JPRB,9.3256E-02_JPRB,&
&1.0748E-01_JPRB,1.2382E-01_JPRB,1.4306E-01_JPRB/)
KAO( :, 3, 1,14) = (/&
&1.6121E-01_JPRB,1.4107E-01_JPRB,1.3136E-01_JPRB,1.2076E-01_JPRB,1.1385E-01_JPRB,1.2008E-01_JPRB,&
&1.4204E-01_JPRB,1.6386E-01_JPRB,1.8913E-01_JPRB/)
KAO( :, 4, 1,14) = (/&
&1.8022E-01_JPRB,1.5771E-01_JPRB,1.4978E-01_JPRB,1.4054E-01_JPRB,1.3566E-01_JPRB,1.5231E-01_JPRB,&
&1.8204E-01_JPRB,2.1017E-01_JPRB,2.4241E-01_JPRB/)
KAO( :, 5, 1,14) = (/&
&1.9876E-01_JPRB,1.7399E-01_JPRB,1.6813E-01_JPRB,1.6037E-01_JPRB,1.6177E-01_JPRB,1.8999E-01_JPRB,&
&2.2725E-01_JPRB,2.6257E-01_JPRB,3.0267E-01_JPRB/)
KAO( :, 1, 2,14) = (/&
&1.2729E-01_JPRB,1.1140E-01_JPRB,9.8262E-02_JPRB,9.0117E-02_JPRB,7.9778E-02_JPRB,7.1136E-02_JPRB,&
&7.1341E-02_JPRB,8.1863E-02_JPRB,9.9580E-02_JPRB/)
KAO( :, 2, 2,14) = (/&
&1.4798E-01_JPRB,1.2949E-01_JPRB,1.1804E-01_JPRB,1.0763E-01_JPRB,9.8062E-02_JPRB,9.0609E-02_JPRB,&
&9.8103E-02_JPRB,1.1375E-01_JPRB,1.3363E-01_JPRB/)
KAO( :, 3, 2,14) = (/&
&1.6873E-01_JPRB,1.4766E-01_JPRB,1.3850E-01_JPRB,1.2733E-01_JPRB,1.1689E-01_JPRB,1.1520E-01_JPRB,&
&1.3107E-01_JPRB,1.5211E-01_JPRB,1.7565E-01_JPRB/)
KAO( :, 4, 2,14) = (/&
&1.8958E-01_JPRB,1.6590E-01_JPRB,1.5866E-01_JPRB,1.4880E-01_JPRB,1.3847E-01_JPRB,1.4498E-01_JPRB,&
&1.6951E-01_JPRB,1.9684E-01_JPRB,2.2617E-01_JPRB/)
KAO( :, 5, 2,14) = (/&
&2.1038E-01_JPRB,1.8454E-01_JPRB,1.7933E-01_JPRB,1.7078E-01_JPRB,1.6390E-01_JPRB,1.7978E-01_JPRB,&
&2.1333E-01_JPRB,2.4781E-01_JPRB,2.8462E-01_JPRB/)
KAO( :, 1, 3,14) = (/&
&1.2550E-01_JPRB,1.0981E-01_JPRB,9.6955E-02_JPRB,8.9024E-02_JPRB,7.7880E-02_JPRB,6.7645E-02_JPRB,&
&6.1403E-02_JPRB,6.7382E-02_JPRB,1.4225E-01_JPRB/)
KAO( :, 2, 3,14) = (/&
&1.4763E-01_JPRB,1.2918E-01_JPRB,1.1753E-01_JPRB,1.0765E-01_JPRB,9.6693E-02_JPRB,8.5332E-02_JPRB,&
&8.4254E-02_JPRB,9.5793E-02_JPRB,1.7778E-01_JPRB/)
KAO( :, 3, 3,14) = (/&
&1.7047E-01_JPRB,1.4918E-01_JPRB,1.3933E-01_JPRB,1.2852E-01_JPRB,1.1691E-01_JPRB,1.0756E-01_JPRB,&
&1.1280E-01_JPRB,1.3060E-01_JPRB,2.1534E-01_JPRB/)
KAO( :, 4, 3,14) = (/&
&1.9358E-01_JPRB,1.6939E-01_JPRB,1.6102E-01_JPRB,1.5122E-01_JPRB,1.3831E-01_JPRB,1.3427E-01_JPRB,&
&1.4739E-01_JPRB,1.7189E-01_JPRB,2.5797E-01_JPRB/)
KAO( :, 5, 3,14) = (/&
&2.1660E-01_JPRB,1.9053E-01_JPRB,1.8371E-01_JPRB,1.7470E-01_JPRB,1.6255E-01_JPRB,1.6554E-01_JPRB,&
&1.8894E-01_JPRB,2.1979E-01_JPRB,3.0718E-01_JPRB/)
KAO( :, 1, 4,14) = (/&
&1.2051E-01_JPRB,1.0544E-01_JPRB,9.2670E-02_JPRB,8.4885E-02_JPRB,7.4104E-02_JPRB,6.3445E-02_JPRB,&
&5.3222E-02_JPRB,5.2652E-02_JPRB,2.4708E-01_JPRB/)
KAO( :, 2, 4,14) = (/&
&1.4414E-01_JPRB,1.2613E-01_JPRB,1.1387E-01_JPRB,1.0420E-01_JPRB,9.2996E-02_JPRB,8.0617E-02_JPRB,&
&7.2382E-02_JPRB,7.7038E-02_JPRB,3.0415E-01_JPRB/)
KAO( :, 3, 4,14) = (/&
&1.6863E-01_JPRB,1.4759E-01_JPRB,1.3702E-01_JPRB,1.2578E-01_JPRB,1.1376E-01_JPRB,1.0097E-01_JPRB,&
&9.6748E-02_JPRB,1.0777E-01_JPRB,3.6725E-01_JPRB/)
KAO( :, 4, 4,14) = (/&
&1.9357E-01_JPRB,1.6961E-01_JPRB,1.6032E-01_JPRB,1.4935E-01_JPRB,1.3627E-01_JPRB,1.2523E-01_JPRB,&
&1.2694E-01_JPRB,1.4559E-01_JPRB,4.3596E-01_JPRB/)
KAO( :, 5, 4,14) = (/&
&2.1857E-01_JPRB,1.9291E-01_JPRB,1.8484E-01_JPRB,1.7444E-01_JPRB,1.6154E-01_JPRB,1.5384E-01_JPRB,&
&1.6473E-01_JPRB,1.9089E-01_JPRB,5.0957E-01_JPRB/)
KAO( :, 1, 5,14) = (/&
&1.1387E-01_JPRB,9.9639E-02_JPRB,8.7347E-02_JPRB,7.9247E-02_JPRB,6.8932E-02_JPRB,5.8370E-02_JPRB,&
&4.7289E-02_JPRB,4.1078E-02_JPRB,4.1374E-01_JPRB/)
KAO( :, 2, 5,14) = (/&
&1.3841E-01_JPRB,1.2111E-01_JPRB,1.0901E-01_JPRB,9.8972E-02_JPRB,8.7653E-02_JPRB,7.5350E-02_JPRB,&
&6.3780E-02_JPRB,6.0994E-02_JPRB,5.1453E-01_JPRB/)
KAO( :, 3, 5,14) = (/&
&1.6401E-01_JPRB,1.4350E-01_JPRB,1.3292E-01_JPRB,1.2113E-01_JPRB,1.0884E-01_JPRB,9.5638E-02_JPRB,&
&8.4952E-02_JPRB,8.8128E-02_JPRB,6.2691E-01_JPRB/)
KAO( :, 4, 5,14) = (/&
&1.9052E-01_JPRB,1.6716E-01_JPRB,1.5743E-01_JPRB,1.4548E-01_JPRB,1.3189E-01_JPRB,1.1925E-01_JPRB,&
&1.1148E-01_JPRB,1.2277E-01_JPRB,7.4875E-01_JPRB/)
KAO( :, 5, 5,14) = (/&
&2.1750E-01_JPRB,1.9225E-01_JPRB,1.8333E-01_JPRB,1.7169E-01_JPRB,1.5768E-01_JPRB,1.4619E-01_JPRB,&
&1.4557E-01_JPRB,1.6521E-01_JPRB,8.7275E-01_JPRB/)
KAO( :, 1, 6,14) = (/&
&1.0474E-01_JPRB,9.1641E-02_JPRB,8.0224E-02_JPRB,7.2183E-02_JPRB,6.2228E-02_JPRB,5.2131E-02_JPRB,&
&4.1492E-02_JPRB,3.2184E-02_JPRB,6.9511E-01_JPRB/)
KAO( :, 2, 6,14) = (/&
&1.2944E-01_JPRB,1.1326E-01_JPRB,1.0170E-01_JPRB,9.1896E-02_JPRB,8.0557E-02_JPRB,6.8664E-02_JPRB,&
&5.6745E-02_JPRB,4.8206E-02_JPRB,8.6732E-01_JPRB/)
KAO( :, 3, 6,14) = (/&
&1.5591E-01_JPRB,1.3642E-01_JPRB,1.2581E-01_JPRB,1.1418E-01_JPRB,1.0169E-01_JPRB,8.8193E-02_JPRB,&
&7.5718E-02_JPRB,7.0944E-02_JPRB,1.0534E+00_JPRB/)
KAO( :, 4, 6,14) = (/&
&1.8354E-01_JPRB,1.6133E-01_JPRB,1.5134E-01_JPRB,1.3874E-01_JPRB,1.2518E-01_JPRB,1.1115E-01_JPRB,&
&9.9229E-02_JPRB,1.0154E-01_JPRB,1.2543E+00_JPRB/)
KAO( :, 5, 6,14) = (/&
&2.1175E-01_JPRB,1.8777E-01_JPRB,1.7853E-01_JPRB,1.6545E-01_JPRB,1.5132E-01_JPRB,1.3778E-01_JPRB,&
&1.2959E-01_JPRB,1.4035E-01_JPRB,1.4668E+00_JPRB/)
KAO( :, 1, 7,14) = (/&
&9.8037E-02_JPRB,8.5785E-02_JPRB,7.4031E-02_JPRB,6.5638E-02_JPRB,5.5734E-02_JPRB,4.5971E-02_JPRB,&
&3.6011E-02_JPRB,2.6144E-02_JPRB,1.2159E+00_JPRB/)
KAO( :, 2, 7,14) = (/&
&1.1998E-01_JPRB,1.0498E-01_JPRB,9.3637E-02_JPRB,8.4452E-02_JPRB,7.3349E-02_JPRB,6.1893E-02_JPRB,&
&4.9919E-02_JPRB,3.9040E-02_JPRB,1.5511E+00_JPRB/)
KAO( :, 3, 7,14) = (/&
&1.4686E-01_JPRB,1.2856E-01_JPRB,1.1785E-01_JPRB,1.0669E-01_JPRB,9.3946E-02_JPRB,8.0872E-02_JPRB,&
&6.7552E-02_JPRB,5.7747E-02_JPRB,1.9129E+00_JPRB/)
KAO( :, 4, 7,14) = (/&
&1.7522E-01_JPRB,1.5432E-01_JPRB,1.4422E-01_JPRB,1.3156E-01_JPRB,1.1748E-01_JPRB,1.0312E-01_JPRB,&
&9.0045E-02_JPRB,8.3407E-02_JPRB,2.2944E+00_JPRB/)
KAO( :, 5, 7,14) = (/&
&2.0470E-01_JPRB,1.8180E-01_JPRB,1.7230E-01_JPRB,1.5882E-01_JPRB,1.4368E-01_JPRB,1.2923E-01_JPRB,&
&1.1721E-01_JPRB,1.1674E-01_JPRB,2.6936E+00_JPRB/)
KAO( :, 1, 8,14) = (/&
&9.9268E-02_JPRB,8.6861E-02_JPRB,7.4453E-02_JPRB,6.4036E-02_JPRB,5.3505E-02_JPRB,4.2319E-02_JPRB,&
&3.1550E-02_JPRB,2.2217E-02_JPRB,2.4996E+00_JPRB/)
KAO( :, 2, 8,14) = (/&
&1.1614E-01_JPRB,1.0162E-01_JPRB,8.8779E-02_JPRB,7.8855E-02_JPRB,6.7312E-02_JPRB,5.5689E-02_JPRB,&
&4.4126E-02_JPRB,3.3034E-02_JPRB,3.2562E+00_JPRB/)
KAO( :, 3, 8,14) = (/&
&1.3955E-01_JPRB,1.2210E-01_JPRB,1.1063E-01_JPRB,9.9801E-02_JPRB,8.7158E-02_JPRB,7.3984E-02_JPRB,&
&6.0483E-02_JPRB,4.8160E-02_JPRB,4.0870E+00_JPRB/)
KAO( :, 4, 8,14) = (/&
&1.6821E-01_JPRB,1.4816E-01_JPRB,1.3755E-01_JPRB,1.2480E-01_JPRB,1.1087E-01_JPRB,9.5535E-02_JPRB,&
&8.1708E-02_JPRB,6.9310E-02_JPRB,4.9903E+00_JPRB/)
KAO( :, 5, 8,14) = (/&
&1.9964E-01_JPRB,1.7735E-01_JPRB,1.6653E-01_JPRB,1.5239E-01_JPRB,1.3733E-01_JPRB,1.2121E-01_JPRB,&
&1.0795E-01_JPRB,9.7500E-02_JPRB,5.9489E+00_JPRB/)
KAO( :, 1, 9,14) = (/&
&1.0767E-01_JPRB,9.4219E-02_JPRB,8.0760E-02_JPRB,6.7681E-02_JPRB,5.5573E-02_JPRB,4.2663E-02_JPRB,&
&3.0129E-02_JPRB,1.9372E-02_JPRB,9.4494E+00_JPRB/)
KAO( :, 2, 9,14) = (/&
&1.1878E-01_JPRB,1.0394E-01_JPRB,8.9411E-02_JPRB,7.7688E-02_JPRB,6.4557E-02_JPRB,5.1682E-02_JPRB,&
&3.8689E-02_JPRB,2.8319E-02_JPRB,1.2605E+01_JPRB/)
KAO( :, 3, 9,14) = (/&
&1.3639E-01_JPRB,1.1934E-01_JPRB,1.0569E-01_JPRB,9.3279E-02_JPRB,7.9895E-02_JPRB,6.6582E-02_JPRB,&
&5.3130E-02_JPRB,4.1437E-02_JPRB,1.6195E+01_JPRB/)
KAO( :, 4, 9,14) = (/&
&1.6051E-01_JPRB,1.4083E-01_JPRB,1.2883E-01_JPRB,1.1557E-01_JPRB,1.0198E-01_JPRB,8.7219E-02_JPRB,&
&7.3054E-02_JPRB,5.9439E-02_JPRB,2.0162E+01_JPRB/)
KAO( :, 5, 9,14) = (/&
&1.9047E-01_JPRB,1.6928E-01_JPRB,1.5797E-01_JPRB,1.4317E-01_JPRB,1.2816E-01_JPRB,1.1220E-01_JPRB,&
&9.8138E-02_JPRB,8.3143E-02_JPRB,2.4370E+01_JPRB/)
KAO( :, 1,10,14) = (/&
&1.2399E-01_JPRB,1.0850E-01_JPRB,9.2999E-02_JPRB,7.7504E-02_JPRB,6.2608E-02_JPRB,4.7376E-02_JPRB,&
&3.2192E-02_JPRB,1.8471E-02_JPRB,3.9887E+01_JPRB/)
KAO( :, 2,10,14) = (/&
&1.3044E-01_JPRB,1.1413E-01_JPRB,9.7827E-02_JPRB,8.3086E-02_JPRB,6.7807E-02_JPRB,5.2528E-02_JPRB,&
&3.7452E-02_JPRB,2.5677E-02_JPRB,5.4647E+01_JPRB/)
KAO( :, 3,10,14) = (/&
&1.4288E-01_JPRB,1.2502E-01_JPRB,1.0881E-01_JPRB,9.4032E-02_JPRB,7.8460E-02_JPRB,6.3126E-02_JPRB,&
&4.8115E-02_JPRB,3.7197E-02_JPRB,7.1742E+01_JPRB/)
KAO( :, 4,10,14) = (/&
&1.6124E-01_JPRB,1.4108E-01_JPRB,1.2689E-01_JPRB,1.1135E-01_JPRB,9.5742E-02_JPRB,8.0119E-02_JPRB,&
&6.6079E-02_JPRB,5.3593E-02_JPRB,9.0502E+01_JPRB/)
KAO( :, 5,10,14) = (/&
&1.8553E-01_JPRB,1.6386E-01_JPRB,1.5092E-01_JPRB,1.3528E-01_JPRB,1.1973E-01_JPRB,1.0415E-01_JPRB,&
&8.9746E-02_JPRB,7.5568E-02_JPRB,1.1085E+02_JPRB/)
KAO( :, 1,11,14) = (/&
&1.4634E-01_JPRB,1.2805E-01_JPRB,1.0976E-01_JPRB,9.1467E-02_JPRB,7.3855E-02_JPRB,5.5821E-02_JPRB,&
&3.7725E-02_JPRB,2.1087E-02_JPRB,6.7956E+01_JPRB/)
KAO( :, 2,11,14) = (/&
&1.5280E-01_JPRB,1.3370E-01_JPRB,1.1460E-01_JPRB,9.6711E-02_JPRB,7.8221E-02_JPRB,6.0001E-02_JPRB,&
&4.1942E-02_JPRB,2.7978E-02_JPRB,9.3212E+01_JPRB/)
KAO( :, 3,11,14) = (/&
&1.6241E-01_JPRB,1.4212E-01_JPRB,1.2352E-01_JPRB,1.0575E-01_JPRB,8.7369E-02_JPRB,6.9001E-02_JPRB,&
&5.1438E-02_JPRB,4.0090E-02_JPRB,1.2204E+02_JPRB/)
KAO( :, 4,11,14) = (/&
&1.7773E-01_JPRB,1.5551E-01_JPRB,1.3890E-01_JPRB,1.2079E-01_JPRB,1.0263E-01_JPRB,8.4231E-02_JPRB,&
&6.9240E-02_JPRB,5.7401E-02_JPRB,1.5432E+02_JPRB/)
KAO( :, 5,11,14) = (/&
&1.9855E-01_JPRB,1.7536E-01_JPRB,1.5997E-01_JPRB,1.4235E-01_JPRB,1.2466E-01_JPRB,1.0802E-01_JPRB,&
&9.3905E-02_JPRB,8.0223E-02_JPRB,1.8971E+02_JPRB/)
KAO( :, 1,12,14) = (/&
&1.7212E-01_JPRB,1.5061E-01_JPRB,1.2910E-01_JPRB,1.0758E-01_JPRB,8.6852E-02_JPRB,6.5625E-02_JPRB,&
&4.4312E-02_JPRB,2.4340E-02_JPRB,8.4903E+01_JPRB/)
KAO( :, 2,12,14) = (/&
&1.7934E-01_JPRB,1.5692E-01_JPRB,1.3450E-01_JPRB,1.1330E-01_JPRB,9.1337E-02_JPRB,6.9634E-02_JPRB,&
&4.7833E-02_JPRB,3.1026E-02_JPRB,1.1639E+02_JPRB/)
KAO( :, 3,12,14) = (/&
&1.8728E-01_JPRB,1.6386E-01_JPRB,1.4213E-01_JPRB,1.2054E-01_JPRB,9.8954E-02_JPRB,7.7262E-02_JPRB,&
&5.6412E-02_JPRB,4.3794E-02_JPRB,1.5321E+02_JPRB/)
KAO( :, 4,12,14) = (/&
&2.0028E-01_JPRB,1.7525E-01_JPRB,1.5522E-01_JPRB,1.3365E-01_JPRB,1.1228E-01_JPRB,9.0973E-02_JPRB,&
&7.3137E-02_JPRB,6.1836E-02_JPRB,1.9487E+02_JPRB/)
KAO( :, 5,12,14) = (/&
&2.1815E-01_JPRB,1.9249E-01_JPRB,1.7398E-01_JPRB,1.5323E-01_JPRB,1.3224E-01_JPRB,1.1343E-01_JPRB,&
&9.8759E-02_JPRB,8.5478E-02_JPRB,2.4055E+02_JPRB/)
KAO( :, 1,13,14) = (/&
&2.0214E-01_JPRB,1.7687E-01_JPRB,1.5160E-01_JPRB,1.2634E-01_JPRB,1.0196E-01_JPRB,7.7014E-02_JPRB,&
&5.1962E-02_JPRB,2.8242E-02_JPRB,8.4112E+01_JPRB/)
KAO( :, 2,13,14) = (/&
&2.1011E-01_JPRB,1.8385E-01_JPRB,1.5760E-01_JPRB,1.3272E-01_JPRB,1.0696E-01_JPRB,8.1283E-02_JPRB,&
&5.5458E-02_JPRB,3.4895E-02_JPRB,1.1624E+02_JPRB/)
KAO( :, 3,13,14) = (/&
&2.1853E-01_JPRB,1.9120E-01_JPRB,1.6551E-01_JPRB,1.3968E-01_JPRB,1.1398E-01_JPRB,8.8112E-02_JPRB,&
&6.3575E-02_JPRB,4.8146E-02_JPRB,1.5368E+02_JPRB/)
KAO( :, 4,13,14) = (/&
&2.2961E-01_JPRB,2.0092E-01_JPRB,1.7711E-01_JPRB,1.5169E-01_JPRB,1.2625E-01_JPRB,1.0098E-01_JPRB,&
&7.9581E-02_JPRB,6.7244E-02_JPRB,1.9645E+02_JPRB/)
KAO( :, 5,13,14) = (/&
&2.4584E-01_JPRB,2.1666E-01_JPRB,1.9421E-01_JPRB,1.6994E-01_JPRB,1.4516E-01_JPRB,1.2228E-01_JPRB,&
&1.0565E-01_JPRB,9.1741E-02_JPRB,2.4440E+02_JPRB/)
KAO( :, 1, 1,15) = (/&
&1.6714E-01_JPRB,1.4623E-01_JPRB,1.2535E-01_JPRB,1.1978E-01_JPRB,1.3700E-01_JPRB,1.6925E-01_JPRB,&
&2.0052E-01_JPRB,2.2511E-01_JPRB,2.6590E-01_JPRB/)
KAO( :, 2, 1,15) = (/&
&1.9315E-01_JPRB,1.6902E-01_JPRB,1.4490E-01_JPRB,1.5051E-01_JPRB,1.8304E-01_JPRB,2.2712E-01_JPRB,&
&2.6888E-01_JPRB,3.0220E-01_JPRB,3.5680E-01_JPRB/)
KAO( :, 3, 1,15) = (/&
&2.1967E-01_JPRB,1.9223E-01_JPRB,1.6933E-01_JPRB,1.8733E-01_JPRB,2.3841E-01_JPRB,2.9577E-01_JPRB,&
&3.5003E-01_JPRB,3.9291E-01_JPRB,4.6433E-01_JPRB/)
KAO( :, 4, 1,15) = (/&
&2.4620E-01_JPRB,2.1544E-01_JPRB,1.9690E-01_JPRB,2.3005E-01_JPRB,3.0239E-01_JPRB,3.7520E-01_JPRB,&
&4.4404E-01_JPRB,4.9769E-01_JPRB,5.8881E-01_JPRB/)
KAO( :, 5, 1,15) = (/&
&2.7258E-01_JPRB,2.3851E-01_JPRB,2.2655E-01_JPRB,2.8238E-01_JPRB,3.7464E-01_JPRB,4.6513E-01_JPRB,&
&5.5029E-01_JPRB,6.1683E-01_JPRB,7.3011E-01_JPRB/)
KAO( :, 1, 2,15) = (/&
&1.8366E-01_JPRB,1.6071E-01_JPRB,1.3776E-01_JPRB,1.2787E-01_JPRB,1.3633E-01_JPRB,1.6291E-01_JPRB,&
&1.9304E-01_JPRB,2.1749E-01_JPRB,2.5915E-01_JPRB/)
KAO( :, 2, 2,15) = (/&
&2.1410E-01_JPRB,1.8735E-01_JPRB,1.6059E-01_JPRB,1.5940E-01_JPRB,1.8012E-01_JPRB,2.2284E-01_JPRB,&
&2.6404E-01_JPRB,2.9719E-01_JPRB,3.5437E-01_JPRB/)
KAO( :, 3, 2,15) = (/&
&2.4518E-01_JPRB,2.1455E-01_JPRB,1.8756E-01_JPRB,1.9671E-01_JPRB,2.3732E-01_JPRB,2.9467E-01_JPRB,&
&3.4914E-01_JPRB,3.9288E-01_JPRB,4.6863E-01_JPRB/)
KAO( :, 4, 2,15) = (/&
&2.7631E-01_JPRB,2.4179E-01_JPRB,2.1947E-01_JPRB,2.3962E-01_JPRB,3.0475E-01_JPRB,3.7844E-01_JPRB,&
&4.4844E-01_JPRB,5.0450E-01_JPRB,6.0205E-01_JPRB/)
KAO( :, 5, 2,15) = (/&
&3.0712E-01_JPRB,2.6878E-01_JPRB,2.5148E-01_JPRB,2.9094E-01_JPRB,3.8157E-01_JPRB,4.7390E-01_JPRB,&
&5.6159E-01_JPRB,6.3185E-01_JPRB,7.5391E-01_JPRB/)
KAO( :, 1, 3,15) = (/&
&1.9381E-01_JPRB,1.6957E-01_JPRB,1.4535E-01_JPRB,1.3089E-01_JPRB,1.3034E-01_JPRB,1.4478E-01_JPRB,&
&1.7182E-01_JPRB,1.9411E-01_JPRB,2.5084E-01_JPRB/)
KAO( :, 2, 3,15) = (/&
&2.2879E-01_JPRB,2.0020E-01_JPRB,1.7161E-01_JPRB,1.6253E-01_JPRB,1.7117E-01_JPRB,2.0325E-01_JPRB,&
&2.4118E-01_JPRB,2.7244E-01_JPRB,3.3342E-01_JPRB/)
KAO( :, 3, 3,15) = (/&
&2.6449E-01_JPRB,2.3152E-01_JPRB,2.0076E-01_JPRB,1.9976E-01_JPRB,2.2310E-01_JPRB,2.7442E-01_JPRB,&
&3.2567E-01_JPRB,3.6802E-01_JPRB,4.4181E-01_JPRB/)
KAO( :, 4, 3,15) = (/&
&3.0062E-01_JPRB,2.6305E-01_JPRB,2.3583E-01_JPRB,2.4242E-01_JPRB,2.8858E-01_JPRB,3.5854E-01_JPRB,&
&4.2563E-01_JPRB,4.8116E-01_JPRB,5.7642E-01_JPRB/)
KAO( :, 5, 3,15) = (/&
&3.3647E-01_JPRB,2.9433E-01_JPRB,2.7280E-01_JPRB,2.9278E-01_JPRB,3.6645E-01_JPRB,4.5559E-01_JPRB,&
&5.4090E-01_JPRB,6.1169E-01_JPRB,7.3212E-01_JPRB/)
KAO( :, 1, 4,15) = (/&
&1.9999E-01_JPRB,1.7501E-01_JPRB,1.5001E-01_JPRB,1.3105E-01_JPRB,1.2399E-01_JPRB,1.2689E-01_JPRB,&
&1.4635E-01_JPRB,1.6609E-01_JPRB,3.8961E-01_JPRB/)
KAO( :, 2, 4,15) = (/&
&2.3934E-01_JPRB,2.0943E-01_JPRB,1.7951E-01_JPRB,1.6550E-01_JPRB,1.6246E-01_JPRB,1.7858E-01_JPRB,&
&2.1156E-01_JPRB,2.4017E-01_JPRB,4.8945E-01_JPRB/)
KAO( :, 3, 4,15) = (/&
&2.7991E-01_JPRB,2.4495E-01_JPRB,2.1142E-01_JPRB,2.0298E-01_JPRB,2.1064E-01_JPRB,2.4602E-01_JPRB,&
&2.9261E-01_JPRB,3.3237E-01_JPRB,5.9861E-01_JPRB/)
KAO( :, 4, 4,15) = (/&
&3.2106E-01_JPRB,2.8093E-01_JPRB,2.4927E-01_JPRB,2.4578E-01_JPRB,2.7114E-01_JPRB,3.2797E-01_JPRB,&
&3.9010E-01_JPRB,4.4342E-01_JPRB,7.1678E-01_JPRB/)
KAO( :, 5, 4,15) = (/&
&3.6208E-01_JPRB,3.1681E-01_JPRB,2.9211E-01_JPRB,2.9449E-01_JPRB,3.4380E-01_JPRB,4.2351E-01_JPRB,&
&5.0405E-01_JPRB,5.7325E-01_JPRB,8.4831E-01_JPRB/)
KAO( :, 1, 5,15) = (/&
&2.0321E-01_JPRB,1.7781E-01_JPRB,1.5241E-01_JPRB,1.3060E-01_JPRB,1.1953E-01_JPRB,1.1366E-01_JPRB,&
&1.2139E-01_JPRB,1.3841E-01_JPRB,7.6737E-01_JPRB/)
KAO( :, 2, 5,15) = (/&
&2.4681E-01_JPRB,2.1596E-01_JPRB,1.8512E-01_JPRB,1.6773E-01_JPRB,1.5630E-01_JPRB,1.5939E-01_JPRB,&
&1.8094E-01_JPRB,2.0654E-01_JPRB,9.3237E-01_JPRB/)
KAO( :, 3, 5,15) = (/&
&2.9225E-01_JPRB,2.5571E-01_JPRB,2.2020E-01_JPRB,2.0776E-01_JPRB,2.0115E-01_JPRB,2.1929E-01_JPRB,&
&2.5668E-01_JPRB,2.9327E-01_JPRB,1.1037E+00_JPRB/)
KAO( :, 4, 5,15) = (/&
&3.3924E-01_JPRB,2.9689E-01_JPRB,2.6138E-01_JPRB,2.5151E-01_JPRB,2.5830E-01_JPRB,2.9435E-01_JPRB,&
&3.4948E-01_JPRB,3.9959E-01_JPRB,1.2806E+00_JPRB/)
KAO( :, 5, 5,15) = (/&
&3.8698E-01_JPRB,3.3860E-01_JPRB,3.0762E-01_JPRB,3.0044E-01_JPRB,3.2724E-01_JPRB,3.8517E-01_JPRB,&
&4.5934E-01_JPRB,5.2570E-01_JPRB,1.4803E+00_JPRB/)
KAO( :, 1, 6,15) = (/&
&2.0167E-01_JPRB,1.7647E-01_JPRB,1.5126E-01_JPRB,1.2807E-01_JPRB,1.1544E-01_JPRB,1.0229E-01_JPRB,&
&9.9864E-02_JPRB,1.1026E-01_JPRB,1.4089E+00_JPRB/)
KAO( :, 2, 6,15) = (/&
&2.4970E-01_JPRB,2.1848E-01_JPRB,1.8731E-01_JPRB,1.6569E-01_JPRB,1.5115E-01_JPRB,1.4241E-01_JPRB,&
&1.4999E-01_JPRB,1.7053E-01_JPRB,1.7402E+00_JPRB/)
KAO( :, 3, 6,15) = (/&
&3.0094E-01_JPRB,2.6336E-01_JPRB,2.2581E-01_JPRB,2.1051E-01_JPRB,1.9387E-01_JPRB,1.9632E-01_JPRB,&
&2.1699E-01_JPRB,2.4938E-01_JPRB,2.0912E+00_JPRB/)
KAO( :, 4, 6,15) = (/&
&3.5441E-01_JPRB,3.1006E-01_JPRB,2.6999E-01_JPRB,2.5637E-01_JPRB,2.4732E-01_JPRB,2.6431E-01_JPRB,&
&3.0280E-01_JPRB,3.4805E-01_JPRB,2.4589E+00_JPRB/)
KAO( :, 5, 6,15) = (/&
&4.0878E-01_JPRB,3.5772E-01_JPRB,3.1991E-01_JPRB,3.0644E-01_JPRB,3.1239E-01_JPRB,3.4703E-01_JPRB,&
&4.0741E-01_JPRB,4.6767E-01_JPRB,2.8357E+00_JPRB/)
KAO( :, 1, 7,15) = (/&
&1.9961E-01_JPRB,1.7465E-01_JPRB,1.4970E-01_JPRB,1.2517E-01_JPRB,1.1019E-01_JPRB,9.4432E-02_JPRB,&
&8.3552E-02_JPRB,8.4867E-02_JPRB,2.6743E+00_JPRB/)
KAO( :, 2, 7,15) = (/&
&2.5271E-01_JPRB,2.2112E-01_JPRB,1.8951E-01_JPRB,1.6349E-01_JPRB,1.4808E-01_JPRB,1.3037E-01_JPRB,&
&1.2620E-01_JPRB,1.3661E-01_JPRB,3.3775E+00_JPRB/)
KAO( :, 3, 7,15) = (/&
&3.0993E-01_JPRB,2.7118E-01_JPRB,2.3244E-01_JPRB,2.1005E-01_JPRB,1.9021E-01_JPRB,1.7858E-01_JPRB,&
&1.8396E-01_JPRB,2.0656E-01_JPRB,4.1391E+00_JPRB/)
KAO( :, 4, 7,15) = (/&
&3.7010E-01_JPRB,3.2384E-01_JPRB,2.8021E-01_JPRB,2.6259E-01_JPRB,2.4156E-01_JPRB,2.4022E-01_JPRB,&
&2.5897E-01_JPRB,2.9714E-01_JPRB,4.9411E+00_JPRB/)
KAO( :, 5, 7,15) = (/&
&4.3194E-01_JPRB,3.7799E-01_JPRB,3.3448E-01_JPRB,3.1568E-01_JPRB,3.0414E-01_JPRB,3.1604E-01_JPRB,&
&3.5629E-01_JPRB,4.0998E-01_JPRB,5.7688E+00_JPRB/)
KAO( :, 1, 8,15) = (/&
&1.9933E-01_JPRB,1.7442E-01_JPRB,1.4950E-01_JPRB,1.2458E-01_JPRB,1.0537E-01_JPRB,8.9910E-02_JPRB,&
&7.2635E-02_JPRB,6.5335E-02_JPRB,6.0216E+00_JPRB/)
KAO( :, 2, 8,15) = (/&
&2.5812E-01_JPRB,2.2586E-01_JPRB,1.9358E-01_JPRB,1.6410E-01_JPRB,1.4589E-01_JPRB,1.2373E-01_JPRB,&
&1.0885E-01_JPRB,1.0727E-01_JPRB,7.7945E+00_JPRB/)
KAO( :, 3, 8,15) = (/&
&3.2225E-01_JPRB,2.8198E-01_JPRB,2.4170E-01_JPRB,2.1259E-01_JPRB,1.9127E-01_JPRB,1.6827E-01_JPRB,&
&1.5878E-01_JPRB,1.6851E-01_JPRB,9.7347E+00_JPRB/)
KAO( :, 4, 8,15) = (/&
&3.9033E-01_JPRB,3.4151E-01_JPRB,2.9429E-01_JPRB,2.7000E-01_JPRB,2.4193E-01_JPRB,2.2526E-01_JPRB,&
&2.2474E-01_JPRB,2.5040E-01_JPRB,1.1796E+01_JPRB/)
KAO( :, 5, 8,15) = (/&
&4.6081E-01_JPRB,4.0323E-01_JPRB,3.5398E-01_JPRB,3.3209E-01_JPRB,3.0343E-01_JPRB,2.9566E-01_JPRB,&
&3.1093E-01_JPRB,3.5490E-01_JPRB,1.3934E+01_JPRB/)
KAO( :, 1, 9,15) = (/&
&1.9412E-01_JPRB,1.6985E-01_JPRB,1.4559E-01_JPRB,1.2132E-01_JPRB,1.0003E-01_JPRB,8.3920E-02_JPRB,&
&6.4680E-02_JPRB,5.0884E-02_JPRB,2.5202E+01_JPRB/)
KAO( :, 2, 9,15) = (/&
&2.5742E-01_JPRB,2.2525E-01_JPRB,1.9306E-01_JPRB,1.6223E-01_JPRB,1.4019E-01_JPRB,1.1848E-01_JPRB,&
&9.6308E-02_JPRB,8.4787E-02_JPRB,3.3443E+01_JPRB/)
KAO( :, 3, 9,15) = (/&
&3.2748E-01_JPRB,2.8656E-01_JPRB,2.4562E-01_JPRB,2.1272E-01_JPRB,1.9002E-01_JPRB,1.6032E-01_JPRB,&
&1.4014E-01_JPRB,1.3516E-01_JPRB,4.2589E+01_JPRB/)
KAO( :, 4, 9,15) = (/&
&4.0257E-01_JPRB,3.5230E-01_JPRB,3.0305E-01_JPRB,2.7255E-01_JPRB,2.4419E-01_JPRB,2.1398E-01_JPRB,&
&1.9809E-01_JPRB,2.0651E-01_JPRB,5.2403E+01_JPRB/)
KAO( :, 5, 9,15) = (/&
&4.8160E-01_JPRB,4.2145E-01_JPRB,3.6810E-01_JPRB,3.4131E-01_JPRB,3.0598E-01_JPRB,2.8022E-01_JPRB,&
&2.7440E-01_JPRB,3.0100E-01_JPRB,6.2821E+01_JPRB/)
KAO( :, 1,10,15) = (/&
&1.9076E-01_JPRB,1.6691E-01_JPRB,1.4306E-01_JPRB,1.1922E-01_JPRB,9.6624E-02_JPRB,7.8836E-02_JPRB,&
&6.0420E-02_JPRB,4.2402E-02_JPRB,1.1849E+02_JPRB/)
KAO( :, 2,10,15) = (/&
&2.5693E-01_JPRB,2.2481E-01_JPRB,1.9273E-01_JPRB,1.6146E-01_JPRB,1.3713E-01_JPRB,1.1570E-01_JPRB,&
&8.9288E-02_JPRB,7.0550E-02_JPRB,1.6078E+02_JPRB/)
KAO( :, 3,10,15) = (/&
&3.3240E-01_JPRB,2.9084E-01_JPRB,2.4929E-01_JPRB,2.1443E-01_JPRB,1.8866E-01_JPRB,1.5859E-01_JPRB,&
&1.2931E-01_JPRB,1.1318E-01_JPRB,2.0842E+02_JPRB/)
KAO( :, 4,10,15) = (/&
&4.1554E-01_JPRB,3.6358E-01_JPRB,3.1223E-01_JPRB,2.7723E-01_JPRB,2.4827E-01_JPRB,2.1112E-01_JPRB,&
&1.8236E-01_JPRB,1.7494E-01_JPRB,2.6109E+02_JPRB/)
KAO( :, 5,10,15) = (/&
&5.0485E-01_JPRB,4.4183E-01_JPRB,3.8382E-01_JPRB,3.4997E-01_JPRB,3.1509E-01_JPRB,2.7563E-01_JPRB,&
&2.5258E-01_JPRB,2.5852E-01_JPRB,3.1766E+02_JPRB/)
KAO( :, 1,11,15) = (/&
&2.1844E-01_JPRB,1.9116E-01_JPRB,1.6385E-01_JPRB,1.3654E-01_JPRB,1.1043E-01_JPRB,8.9314E-02_JPRB,&
&6.8138E-02_JPRB,4.5935E-02_JPRB,2.2340E+02_JPRB/)
KAO( :, 2,11,15) = (/&
&2.8726E-01_JPRB,2.5136E-01_JPRB,2.1545E-01_JPRB,1.8158E-01_JPRB,1.5471E-01_JPRB,1.3017E-01_JPRB,&
&9.9967E-02_JPRB,7.4771E-02_JPRB,3.0363E+02_JPRB/)
KAO( :, 3,11,15) = (/&
&3.7321E-01_JPRB,3.2655E-01_JPRB,2.7990E-01_JPRB,2.4162E-01_JPRB,2.1196E-01_JPRB,1.7932E-01_JPRB,&
&1.4260E-01_JPRB,1.1849E-01_JPRB,3.9534E+02_JPRB/)
KAO( :, 4,11,15) = (/&
&4.6764E-01_JPRB,4.0919E-01_JPRB,3.5259E-01_JPRB,3.1283E-01_JPRB,2.7919E-01_JPRB,2.3760E-01_JPRB,&
&1.9841E-01_JPRB,1.8073E-01_JPRB,4.9612E+02_JPRB/)
KAO( :, 5,11,15) = (/&
&5.6847E-01_JPRB,4.9745E-01_JPRB,4.3470E-01_JPRB,3.9501E-01_JPRB,3.5535E-01_JPRB,3.0691E-01_JPRB,&
&2.7182E-01_JPRB,2.6544E-01_JPRB,6.0376E+02_JPRB/)
KAO( :, 1,12,15) = (/&
&2.5386E-01_JPRB,2.2213E-01_JPRB,1.9039E-01_JPRB,1.5866E-01_JPRB,1.2803E-01_JPRB,1.0260E-01_JPRB,&
&7.7411E-02_JPRB,5.0505E-02_JPRB,3.1181E+02_JPRB/)
KAO( :, 2,12,15) = (/&
&3.2584E-01_JPRB,2.8511E-01_JPRB,2.4435E-01_JPRB,2.0586E-01_JPRB,1.7487E-01_JPRB,1.4640E-01_JPRB,&
&1.1295E-01_JPRB,8.0206E-02_JPRB,4.2527E+02_JPRB/)
KAO( :, 3,12,15) = (/&
&4.2185E-01_JPRB,3.6913E-01_JPRB,3.1659E-01_JPRB,2.7453E-01_JPRB,2.3949E-01_JPRB,2.0235E-01_JPRB,&
&1.5885E-01_JPRB,1.2527E-01_JPRB,5.5386E+02_JPRB/)
KAO( :, 4,12,15) = (/&
&5.2872E-01_JPRB,4.6263E-01_JPRB,4.0035E-01_JPRB,3.5526E-01_JPRB,3.1589E-01_JPRB,2.6854E-01_JPRB,&
&2.1892E-01_JPRB,1.8866E-01_JPRB,6.9524E+02_JPRB/)
KAO( :, 5,12,15) = (/&
&6.4364E-01_JPRB,5.6320E-01_JPRB,4.9357E-01_JPRB,4.4708E-01_JPRB,4.0237E-01_JPRB,3.4474E-01_JPRB,&
&2.9649E-01_JPRB,2.7537E-01_JPRB,8.4735E+02_JPRB/)
KAO( :, 1,13,15) = (/&
&3.0271E-01_JPRB,2.6486E-01_JPRB,2.2703E-01_JPRB,1.8919E-01_JPRB,1.5231E-01_JPRB,1.2084E-01_JPRB,&
&9.0270E-02_JPRB,5.7320E-02_JPRB,3.4698E+02_JPRB/)
KAO( :, 2,13,15) = (/&
&3.8384E-01_JPRB,3.3586E-01_JPRB,2.8793E-01_JPRB,2.4185E-01_JPRB,2.0369E-01_JPRB,1.6894E-01_JPRB,&
&1.3012E-01_JPRB,8.8518E-02_JPRB,4.7325E+02_JPRB/)
KAO( :, 3,13,15) = (/&
&4.9165E-01_JPRB,4.3019E-01_JPRB,3.6920E-01_JPRB,3.1973E-01_JPRB,2.7695E-01_JPRB,2.3380E-01_JPRB,&
&1.8192E-01_JPRB,1.3513E-01_JPRB,6.1726E+02_JPRB/)
KAO( :, 4,13,15) = (/&
&6.1738E-01_JPRB,5.4020E-01_JPRB,4.6750E-01_JPRB,4.1230E-01_JPRB,3.6547E-01_JPRB,3.1024E-01_JPRB,&
&2.4776E-01_JPRB,2.0059E-01_JPRB,7.7596E+02_JPRB/)
KAO( :, 5,13,15) = (/&
&7.5168E-01_JPRB,6.5770E-01_JPRB,5.7644E-01_JPRB,5.1768E-01_JPRB,4.6514E-01_JPRB,3.9851E-01_JPRB,&
&3.3091E-01_JPRB,2.9046E-01_JPRB,9.4535E+02_JPRB/)
KAO( :, 1, 1,16) = (/&
&1.8794E-01_JPRB,1.6446E-01_JPRB,1.4098E-01_JPRB,1.4453E-01_JPRB,1.9112E-01_JPRB,2.3568E-01_JPRB,&
&2.7559E-01_JPRB,2.9928E-01_JPRB,3.6389E-01_JPRB/)
KAO( :, 2, 1,16) = (/&
&2.1699E-01_JPRB,1.8988E-01_JPRB,1.6277E-01_JPRB,1.9700E-01_JPRB,2.6048E-01_JPRB,3.2128E-01_JPRB,&
&3.7575E-01_JPRB,4.0820E-01_JPRB,4.9613E-01_JPRB/)
KAO( :, 3, 1,16) = (/&
&2.4618E-01_JPRB,2.1543E-01_JPRB,1.8468E-01_JPRB,2.5950E-01_JPRB,3.4314E-01_JPRB,4.2321E-01_JPRB,&
&4.9501E-01_JPRB,5.3795E-01_JPRB,6.5375E-01_JPRB/)
KAO( :, 4, 1,16) = (/&
&2.7517E-01_JPRB,2.4080E-01_JPRB,2.2265E-01_JPRB,3.3206E-01_JPRB,4.3916E-01_JPRB,5.4174E-01_JPRB,&
&6.3374E-01_JPRB,6.8883E-01_JPRB,8.3685E-01_JPRB/)
KAO( :, 5, 1,16) = (/&
&3.0356E-01_JPRB,2.6563E-01_JPRB,2.7796E-01_JPRB,4.1454E-01_JPRB,5.4825E-01_JPRB,6.7630E-01_JPRB,&
&7.9114E-01_JPRB,8.6022E-01_JPRB,1.0450E+00_JPRB/)
KAO( :, 1, 2,16) = (/&
&2.1263E-01_JPRB,1.8604E-01_JPRB,1.5947E-01_JPRB,1.5196E-01_JPRB,2.0093E-01_JPRB,2.4784E-01_JPRB,&
&2.8986E-01_JPRB,3.1499E-01_JPRB,3.9172E-01_JPRB/)
KAO( :, 2, 2,16) = (/&
&2.4750E-01_JPRB,2.1657E-01_JPRB,1.8564E-01_JPRB,2.1030E-01_JPRB,2.7808E-01_JPRB,3.4296E-01_JPRB,&
&4.0127E-01_JPRB,4.3611E-01_JPRB,5.4225E-01_JPRB/)
KAO( :, 3, 2,16) = (/&
&2.8278E-01_JPRB,2.4744E-01_JPRB,2.1211E-01_JPRB,2.8057E-01_JPRB,3.7097E-01_JPRB,4.5769E-01_JPRB,&
&5.3545E-01_JPRB,5.8223E-01_JPRB,7.2368E-01_JPRB/)
KAO( :, 4, 2,16) = (/&
&3.1792E-01_JPRB,2.7821E-01_JPRB,2.4340E-01_JPRB,3.6301E-01_JPRB,4.8000E-01_JPRB,5.9222E-01_JPRB,&
&6.9274E-01_JPRB,7.5351E-01_JPRB,9.3616E-01_JPRB/)
KAO( :, 5, 2,16) = (/&
&3.5252E-01_JPRB,3.0850E-01_JPRB,3.0650E-01_JPRB,4.5727E-01_JPRB,6.0467E-01_JPRB,7.4622E-01_JPRB,&
&8.7306E-01_JPRB,9.4984E-01_JPRB,1.1794E+00_JPRB/)
KAO( :, 1, 3,16) = (/&
&2.3237E-01_JPRB,2.0331E-01_JPRB,1.7427E-01_JPRB,1.4795E-01_JPRB,1.9535E-01_JPRB,2.4099E-01_JPRB,&
&2.8188E-01_JPRB,3.0650E-01_JPRB,3.8991E-01_JPRB/)
KAO( :, 2, 3,16) = (/&
&2.7395E-01_JPRB,2.3972E-01_JPRB,2.0548E-01_JPRB,2.0945E-01_JPRB,2.7700E-01_JPRB,3.4180E-01_JPRB,&
&3.9994E-01_JPRB,4.3491E-01_JPRB,5.5290E-01_JPRB/)
KAO( :, 3, 3,16) = (/&
&3.1641E-01_JPRB,2.7688E-01_JPRB,2.3734E-01_JPRB,2.8529E-01_JPRB,3.7722E-01_JPRB,4.6547E-01_JPRB,&
&5.4473E-01_JPRB,5.9265E-01_JPRB,7.5290E-01_JPRB/)
KAO( :, 4, 3,16) = (/&
&3.5913E-01_JPRB,3.1425E-01_JPRB,2.6936E-01_JPRB,3.7538E-01_JPRB,4.9654E-01_JPRB,6.1283E-01_JPRB,&
&7.1724E-01_JPRB,7.8067E-01_JPRB,9.9115E-01_JPRB/)
KAO( :, 5, 3,16) = (/&
&4.0136E-01_JPRB,3.5124E-01_JPRB,3.2170E-01_JPRB,4.7982E-01_JPRB,6.3476E-01_JPRB,7.8330E-01_JPRB,&
&9.1698E-01_JPRB,9.9858E-01_JPRB,1.2670E+00_JPRB/)
KAO( :, 1, 4,16) = (/&
&2.4989E-01_JPRB,2.1869E-01_JPRB,1.8745E-01_JPRB,1.5621E-01_JPRB,1.8314E-01_JPRB,2.2578E-01_JPRB,&
&2.6437E-01_JPRB,2.8743E-01_JPRB,4.8014E-01_JPRB/)
KAO( :, 2, 4,16) = (/&
&2.9922E-01_JPRB,2.6183E-01_JPRB,2.2443E-01_JPRB,2.0216E-01_JPRB,2.6741E-01_JPRB,3.2989E-01_JPRB,&
&3.8624E-01_JPRB,4.2053E-01_JPRB,5.7494E-01_JPRB/)
KAO( :, 3, 4,16) = (/&
&3.5007E-01_JPRB,3.0634E-01_JPRB,2.6259E-01_JPRB,2.8203E-01_JPRB,3.7315E-01_JPRB,4.6045E-01_JPRB,&
&5.3900E-01_JPRB,5.8709E-01_JPRB,7.5343E-01_JPRB/)
KAO( :, 4, 4,16) = (/&
&4.0160E-01_JPRB,3.5141E-01_JPRB,3.0118E-01_JPRB,3.7881E-01_JPRB,5.0127E-01_JPRB,6.1841E-01_JPRB,&
&7.2420E-01_JPRB,7.8857E-01_JPRB,1.0118E+00_JPRB/)
KAO( :, 5, 4,16) = (/&
&4.5313E-01_JPRB,3.9646E-01_JPRB,3.4036E-01_JPRB,4.9269E-01_JPRB,6.5192E-01_JPRB,8.0453E-01_JPRB,&
&9.4219E-01_JPRB,1.0271E+00_JPRB,1.3148E+00_JPRB/)
KAO( :, 1, 5,16) = (/&
&2.6693E-01_JPRB,2.3353E-01_JPRB,2.0017E-01_JPRB,1.6678E-01_JPRB,1.6870E-01_JPRB,2.0825E-01_JPRB,&
&2.4377E-01_JPRB,2.6562E-01_JPRB,1.0097E+00_JPRB/)
KAO( :, 2, 5,16) = (/&
&3.2490E-01_JPRB,2.8429E-01_JPRB,2.4362E-01_JPRB,2.0306E-01_JPRB,2.5435E-01_JPRB,3.1387E-01_JPRB,&
&3.6729E-01_JPRB,4.0072E-01_JPRB,1.2293E+00_JPRB/)
KAO( :, 3, 5,16) = (/&
&3.8533E-01_JPRB,3.3720E-01_JPRB,2.8903E-01_JPRB,2.7540E-01_JPRB,3.6433E-01_JPRB,4.4941E-01_JPRB,&
&5.2674E-01_JPRB,5.7460E-01_JPRB,1.4580E+00_JPRB/)
KAO( :, 4, 5,16) = (/&
&4.4720E-01_JPRB,3.9129E-01_JPRB,3.3549E-01_JPRB,3.7808E-01_JPRB,5.0020E-01_JPRB,6.1752E-01_JPRB,&
&7.2292E-01_JPRB,7.8975E-01_JPRB,1.6925E+00_JPRB/)
KAO( :, 5, 5,16) = (/&
&5.0948E-01_JPRB,4.4592E-01_JPRB,3.8223E-01_JPRB,5.0057E-01_JPRB,6.6242E-01_JPRB,8.1818E-01_JPRB,&
&9.5865E-01_JPRB,1.0467E+00_JPRB,1.9289E+00_JPRB/)
KAO( :, 1, 6,16) = (/&
&2.8083E-01_JPRB,2.4573E-01_JPRB,2.1063E-01_JPRB,1.7555E-01_JPRB,1.5015E-01_JPRB,1.8516E-01_JPRB,&
&2.1690E-01_JPRB,2.3675E-01_JPRB,1.9657E+00_JPRB/)
KAO( :, 2, 6,16) = (/&
&3.4835E-01_JPRB,3.0480E-01_JPRB,2.6132E-01_JPRB,2.1777E-01_JPRB,2.3453E-01_JPRB,2.8980E-01_JPRB,&
&3.3958E-01_JPRB,3.7078E-01_JPRB,2.4391E+00_JPRB/)
KAO( :, 3, 6,16) = (/&
&4.1976E-01_JPRB,3.6729E-01_JPRB,3.1483E-01_JPRB,2.6738E-01_JPRB,3.4635E-01_JPRB,4.2784E-01_JPRB,&
&5.0150E-01_JPRB,5.4802E-01_JPRB,2.9392E+00_JPRB/)
KAO( :, 4, 6,16) = (/&
&4.9356E-01_JPRB,4.3188E-01_JPRB,3.7019E-01_JPRB,3.6832E-01_JPRB,4.8722E-01_JPRB,6.0225E-01_JPRB,&
&7.0615E-01_JPRB,7.7190E-01_JPRB,3.4563E+00_JPRB/)
KAO( :, 5, 6,16) = (/&
&5.6851E-01_JPRB,4.9738E-01_JPRB,4.2634E-01_JPRB,4.9804E-01_JPRB,6.5918E-01_JPRB,8.1420E-01_JPRB,&
&9.5511E-01_JPRB,1.0452E+00_JPRB,3.9808E+00_JPRB/)
KAO( :, 1, 7,16) = (/&
&2.9602E-01_JPRB,2.5901E-01_JPRB,2.2201E-01_JPRB,1.8497E-01_JPRB,1.4799E-01_JPRB,1.6095E-01_JPRB,&
&1.8877E-01_JPRB,2.0662E-01_JPRB,3.9956E+00_JPRB/)
KAO( :, 2, 7,16) = (/&
&3.7489E-01_JPRB,3.2803E-01_JPRB,2.8110E-01_JPRB,2.3429E-01_JPRB,2.1216E-01_JPRB,2.6198E-01_JPRB,&
&3.0739E-01_JPRB,3.3690E-01_JPRB,5.0612E+00_JPRB/)
KAO( :, 3, 7,16) = (/&
&4.5934E-01_JPRB,4.0186E-01_JPRB,3.4446E-01_JPRB,2.8709E-01_JPRB,3.2355E-01_JPRB,3.9962E-01_JPRB,&
&4.6900E-01_JPRB,5.1413E-01_JPRB,6.2014E+00_JPRB/)
KAO( :, 4, 7,16) = (/&
&5.4772E-01_JPRB,4.7919E-01_JPRB,4.1082E-01_JPRB,3.5907E-01_JPRB,4.6765E-01_JPRB,5.7781E-01_JPRB,&
&6.7844E-01_JPRB,7.4475E-01_JPRB,7.3945E+00_JPRB/)
KAO( :, 5, 7,16) = (/&
&6.3818E-01_JPRB,5.5843E-01_JPRB,4.7875E-01_JPRB,4.8820E-01_JPRB,6.4638E-01_JPRB,7.9944E-01_JPRB,&
&9.3819E-01_JPRB,1.0310E+00_JPRB,8.6187E+00_JPRB/)
KAO( :, 1, 8,16) = (/&
&3.1643E-01_JPRB,2.7689E-01_JPRB,2.3733E-01_JPRB,1.9778E-01_JPRB,1.5822E-01_JPRB,1.3698E-01_JPRB,&
&1.6092E-01_JPRB,1.7692E-01_JPRB,9.6744E+00_JPRB/)
KAO( :, 2, 8,16) = (/&
&4.0971E-01_JPRB,3.5849E-01_JPRB,3.0728E-01_JPRB,2.5607E-01_JPRB,2.0550E-01_JPRB,2.3311E-01_JPRB,&
&2.7394E-01_JPRB,3.0140E-01_JPRB,1.2526E+01_JPRB/)
KAO( :, 3, 8,16) = (/&
&5.1114E-01_JPRB,4.4727E-01_JPRB,3.8338E-01_JPRB,3.1946E-01_JPRB,2.9762E-01_JPRB,3.6825E-01_JPRB,&
&4.3294E-01_JPRB,4.7698E-01_JPRB,1.5632E+01_JPRB/)
KAO( :, 4, 8,16) = (/&
&6.1845E-01_JPRB,5.4119E-01_JPRB,4.6383E-01_JPRB,3.8657E-01_JPRB,4.4256E-01_JPRB,5.4777E-01_JPRB,&
&6.4434E-01_JPRB,7.1023E-01_JPRB,1.8915E+01_JPRB/)
KAO( :, 5, 8,16) = (/&
&7.2956E-01_JPRB,6.3833E-01_JPRB,5.4715E-01_JPRB,4.8521E-01_JPRB,6.2642E-01_JPRB,7.7483E-01_JPRB,&
&9.1223E-01_JPRB,1.0061E+00_JPRB,2.2311E+01_JPRB/)
KAO( :, 1, 9,16) = (/&
&3.3206E-01_JPRB,2.9059E-01_JPRB,2.4908E-01_JPRB,2.0756E-01_JPRB,1.6605E-01_JPRB,1.2520E-01_JPRB,&
&1.3332E-01_JPRB,1.4726E-01_JPRB,4.3754E+01_JPRB/)
KAO( :, 2, 9,16) = (/&
&4.4050E-01_JPRB,3.8544E-01_JPRB,3.3040E-01_JPRB,2.7529E-01_JPRB,2.2025E-01_JPRB,2.0212E-01_JPRB,&
&2.3801E-01_JPRB,2.6323E-01_JPRB,5.8016E+01_JPRB/)
KAO( :, 3, 9,16) = (/&
&5.6026E-01_JPRB,4.9023E-01_JPRB,4.2020E-01_JPRB,3.5022E-01_JPRB,2.8778E-01_JPRB,3.3184E-01_JPRB,&
&3.9083E-01_JPRB,4.3264E-01_JPRB,7.3805E+01_JPRB/)
KAO( :, 4, 9,16) = (/&
&6.8858E-01_JPRB,6.0253E-01_JPRB,5.1637E-01_JPRB,4.3040E-01_JPRB,4.1206E-01_JPRB,5.0884E-01_JPRB,&
&5.9967E-01_JPRB,6.6456E-01_JPRB,9.0709E+01_JPRB/)
KAO( :, 5, 9,16) = (/&
&8.2259E-01_JPRB,7.1975E-01_JPRB,6.1688E-01_JPRB,5.1707E-01_JPRB,5.9606E-01_JPRB,7.3858E-01_JPRB,&
&8.7057E-01_JPRB,9.6569E-01_JPRB,1.0838E+02_JPRB/)
KAO( :, 1,10,16) = (/&
&3.5261E-01_JPRB,3.0855E-01_JPRB,2.6447E-01_JPRB,2.2042E-01_JPRB,1.7636E-01_JPRB,1.3225E-01_JPRB,&
&1.1302E-01_JPRB,1.2540E-01_JPRB,2.2383E+02_JPRB/)
KAO( :, 2,10,16) = (/&
&4.7821E-01_JPRB,4.1843E-01_JPRB,3.5857E-01_JPRB,2.9886E-01_JPRB,2.3906E-01_JPRB,1.8964E-01_JPRB,&
&2.1098E-01_JPRB,2.3441E-01_JPRB,3.0350E+02_JPRB/)
KAO( :, 3,10,16) = (/&
&6.1881E-01_JPRB,5.4145E-01_JPRB,4.6410E-01_JPRB,3.8673E-01_JPRB,3.0946E-01_JPRB,3.0407E-01_JPRB,&
&3.5878E-01_JPRB,3.9920E-01_JPRB,3.9277E+02_JPRB/)
KAO( :, 4,10,16) = (/&
&7.7105E-01_JPRB,6.7484E-01_JPRB,5.7823E-01_JPRB,4.8190E-01_JPRB,4.1230E-01_JPRB,4.7947E-01_JPRB,&
&5.6602E-01_JPRB,6.3051E-01_JPRB,4.8953E+02_JPRB/)
KAO( :, 5,10,16) = (/&
&9.3145E-01_JPRB,8.1502E-01_JPRB,6.9859E-01_JPRB,5.8205E-01_JPRB,5.7779E-01_JPRB,7.1138E-01_JPRB,&
&8.4040E-01_JPRB,9.3669E-01_JPRB,5.9127E+02_JPRB/)
KAO( :, 1,11,16) = (/&
&4.3261E-01_JPRB,3.7853E-01_JPRB,3.2446E-01_JPRB,2.7039E-01_JPRB,2.1632E-01_JPRB,1.6222E-01_JPRB,&
&1.3099E-01_JPRB,1.4452E-01_JPRB,4.6285E+02_JPRB/)
KAO( :, 2,11,16) = (/&
&5.8535E-01_JPRB,5.1218E-01_JPRB,4.3901E-01_JPRB,3.6590E-01_JPRB,2.9265E-01_JPRB,2.2872E-01_JPRB,&
&2.4101E-01_JPRB,2.6929E-01_JPRB,6.2611E+02_JPRB/)
KAO( :, 3,11,16) = (/&
&7.5565E-01_JPRB,6.6141E-01_JPRB,5.6693E-01_JPRB,4.7237E-01_JPRB,3.7786E-01_JPRB,3.5050E-01_JPRB,&
&4.0844E-01_JPRB,4.5697E-01_JPRB,8.0847E+02_JPRB/)
KAO( :, 4,11,16) = (/&
&9.3953E-01_JPRB,8.2209E-01_JPRB,7.0458E-01_JPRB,5.8709E-01_JPRB,4.9467E-01_JPRB,5.4296E-01_JPRB,&
&6.4241E-01_JPRB,7.1951E-01_JPRB,1.0051E+03_JPRB/)
KAO( :, 5,11,16) = (/&
&1.1321E+00_JPRB,9.9048E-01_JPRB,8.4898E-01_JPRB,7.0764E-01_JPRB,6.7182E-01_JPRB,8.0337E-01_JPRB,&
&9.5077E-01_JPRB,1.0665E+00_JPRB,1.2110E+03_JPRB/)
KAO( :, 1,12,16) = (/&
&5.3519E-01_JPRB,4.6832E-01_JPRB,4.0142E-01_JPRB,3.3452E-01_JPRB,2.6763E-01_JPRB,2.0072E-01_JPRB,&
&1.5467E-01_JPRB,1.6502E-01_JPRB,7.0824E+02_JPRB/)
KAO( :, 2,12,16) = (/&
&7.2183E-01_JPRB,6.3160E-01_JPRB,5.4131E-01_JPRB,4.5112E-01_JPRB,3.6090E-01_JPRB,2.7900E-01_JPRB,&
&2.7245E-01_JPRB,3.0622E-01_JPRB,9.5519E+02_JPRB/)
KAO( :, 3,12,16) = (/&
&9.2882E-01_JPRB,8.1286E-01_JPRB,6.9674E-01_JPRB,5.8057E-01_JPRB,4.6450E-01_JPRB,4.1101E-01_JPRB,&
&4.5999E-01_JPRB,5.1778E-01_JPRB,1.2292E+03_JPRB/)
KAO( :, 4,12,16) = (/&
&1.1518E+00_JPRB,1.0078E+00_JPRB,8.6369E-01_JPRB,7.1969E-01_JPRB,5.9900E-01_JPRB,6.1266E-01_JPRB,&
&7.2069E-01_JPRB,8.1237E-01_JPRB,1.5237E+03_JPRB/)
KAO( :, 5,12,16) = (/&
&1.3877E+00_JPRB,1.2141E+00_JPRB,1.0407E+00_JPRB,8.6727E-01_JPRB,7.9163E-01_JPRB,8.9653E-01_JPRB,&
&1.0630E+00_JPRB,1.1997E+00_JPRB,1.8362E+03_JPRB/)
KAO( :, 1,13,16) = (/&
&6.8305E-01_JPRB,5.9769E-01_JPRB,5.1231E-01_JPRB,4.2692E-01_JPRB,3.4152E-01_JPRB,2.5608E-01_JPRB,&
&1.8801E-01_JPRB,1.8615E-01_JPRB,8.6247E+02_JPRB/)
KAO( :, 2,13,16) = (/&
&9.1792E-01_JPRB,8.0318E-01_JPRB,6.8841E-01_JPRB,5.7362E-01_JPRB,4.5889E-01_JPRB,3.5002E-01_JPRB,&
&3.1177E-01_JPRB,3.4406E-01_JPRB,1.1588E+03_JPRB/)
KAO( :, 3,13,16) = (/&
&1.1812E+00_JPRB,1.0334E+00_JPRB,8.8578E-01_JPRB,7.3808E-01_JPRB,5.9053E-01_JPRB,4.9511E-01_JPRB,&
&5.1116E-01_JPRB,5.7929E-01_JPRB,1.4913E+03_JPRB/)
KAO( :, 4,13,16) = (/&
&1.4677E+00_JPRB,1.2842E+00_JPRB,1.1009E+00_JPRB,9.1748E-01_JPRB,7.4504E-01_JPRB,7.0766E-01_JPRB,&
&7.9819E-01_JPRB,9.0553E-01_JPRB,1.8526E+03_JPRB/)
KAO( :, 5,13,16) = (/&
&1.7710E+00_JPRB,1.5496E+00_JPRB,1.3282E+00_JPRB,1.1069E+00_JPRB,9.5682E-01_JPRB,1.0004E+00_JPRB,&
&1.1734E+00_JPRB,1.3329E+00_JPRB,2.2362E+03_JPRB/)


!     ------------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB13_A2
