!OCL SCALAR
SUBROUTINE RRTM_KGB13_A1

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 13:  2080-2250 cm-1 (low - H2O,N2O; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO13, ONLY : KAO     ,SELFREFO   ,FRACREFAO
USE YOERRTA13, ONLY : STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 1) = (/&
&6.0224E-05_JPRB,8.4190E-05_JPRB,9.2945E-05_JPRB,9.8340E-05_JPRB,1.0097E-04_JPRB,1.0123E-04_JPRB,&
&9.8980E-05_JPRB,9.5101E-05_JPRB,1.0057E-04_JPRB/)
KAO( :, 2, 1, 1) = (/&
&6.0879E-05_JPRB,8.9195E-05_JPRB,9.9910E-05_JPRB,1.0710E-04_JPRB,1.1122E-04_JPRB,1.1263E-04_JPRB,&
&1.1044E-04_JPRB,1.0763E-04_JPRB,1.0542E-04_JPRB/)
KAO( :, 3, 1, 1) = (/&
&6.1791E-05_JPRB,9.5106E-05_JPRB,1.0827E-04_JPRB,1.1785E-04_JPRB,1.2380E-04_JPRB,1.2668E-04_JPRB,&
&1.2512E-04_JPRB,1.2107E-04_JPRB,1.1351E-04_JPRB/)
KAO( :, 4, 1, 1) = (/&
&6.3010E-05_JPRB,1.0201E-04_JPRB,1.1821E-04_JPRB,1.3067E-04_JPRB,1.3868E-04_JPRB,1.4333E-04_JPRB,&
&1.4292E-04_JPRB,1.3776E-04_JPRB,1.2486E-04_JPRB/)
KAO( :, 5, 1, 1) = (/&
&6.4569E-05_JPRB,1.0987E-04_JPRB,1.2980E-04_JPRB,1.4543E-04_JPRB,1.5604E-04_JPRB,1.6272E-04_JPRB,&
&1.6360E-04_JPRB,1.5809E-04_JPRB,1.3899E-04_JPRB/)
KAO( :, 1, 2, 1) = (/&
&5.2287E-05_JPRB,7.1405E-05_JPRB,7.7712E-05_JPRB,8.1186E-05_JPRB,8.2505E-05_JPRB,8.2006E-05_JPRB,&
&7.9565E-05_JPRB,7.6455E-05_JPRB,9.9524E-05_JPRB/)
KAO( :, 2, 2, 1) = (/&
&5.2781E-05_JPRB,7.5455E-05_JPRB,8.3243E-05_JPRB,8.8119E-05_JPRB,9.0567E-05_JPRB,9.0970E-05_JPRB,&
&8.8663E-05_JPRB,8.6015E-05_JPRB,1.0412E-04_JPRB/)
KAO( :, 3, 2, 1) = (/&
&5.3548E-05_JPRB,8.0317E-05_JPRB,9.0003E-05_JPRB,9.6753E-05_JPRB,1.0065E-04_JPRB,1.0210E-04_JPRB,&
&1.0019E-04_JPRB,9.6846E-05_JPRB,1.1058E-04_JPRB/)
KAO( :, 4, 2, 1) = (/&
&5.4581E-05_JPRB,8.6067E-05_JPRB,9.8148E-05_JPRB,1.0717E-04_JPRB,1.1272E-04_JPRB,1.1541E-04_JPRB,&
&1.1436E-04_JPRB,1.1002E-04_JPRB,1.1929E-04_JPRB/)
KAO( :, 5, 2, 1) = (/&
&5.5952E-05_JPRB,9.2760E-05_JPRB,1.0776E-04_JPRB,1.1931E-04_JPRB,1.2684E-04_JPRB,1.3110E-04_JPRB,&
&1.3118E-04_JPRB,1.2615E-04_JPRB,1.3023E-04_JPRB/)
KAO( :, 1, 3, 1) = (/&
&4.5915E-05_JPRB,6.0577E-05_JPRB,6.4826E-05_JPRB,6.6685E-05_JPRB,6.6750E-05_JPRB,6.5539E-05_JPRB,&
&6.2942E-05_JPRB,6.0959E-05_JPRB,1.1753E-04_JPRB/)
KAO( :, 2, 3, 1) = (/&
&4.6227E-05_JPRB,6.3783E-05_JPRB,6.9133E-05_JPRB,7.1876E-05_JPRB,7.2797E-05_JPRB,7.2195E-05_JPRB,&
&6.9765E-05_JPRB,6.7154E-05_JPRB,1.2464E-04_JPRB/)
KAO( :, 3, 3, 1) = (/&
&4.6851E-05_JPRB,6.7690E-05_JPRB,7.4367E-05_JPRB,7.8503E-05_JPRB,8.0513E-05_JPRB,8.0733E-05_JPRB,&
&7.8338E-05_JPRB,7.5667E-05_JPRB,1.3207E-04_JPRB/)
KAO( :, 4, 3, 1) = (/&
&4.7751E-05_JPRB,7.2324E-05_JPRB,8.0776E-05_JPRB,8.6619E-05_JPRB,8.9966E-05_JPRB,9.1016E-05_JPRB,&
&8.9192E-05_JPRB,8.5836E-05_JPRB,1.3971E-04_JPRB/)
KAO( :, 5, 3, 1) = (/&
&4.8912E-05_JPRB,7.7822E-05_JPRB,8.8433E-05_JPRB,9.6277E-05_JPRB,1.0117E-04_JPRB,1.0326E-04_JPRB,&
&1.0232E-04_JPRB,9.7968E-05_JPRB,1.4868E-04_JPRB/)
KAO( :, 1, 4, 1) = (/&
&4.0950E-05_JPRB,5.2139E-05_JPRB,5.4765E-05_JPRB,5.5573E-05_JPRB,5.4704E-05_JPRB,5.2865E-05_JPRB,&
&5.0161E-05_JPRB,4.9155E-05_JPRB,1.5352E-04_JPRB/)
KAO( :, 2, 4, 1) = (/&
&4.1070E-05_JPRB,5.4592E-05_JPRB,5.8140E-05_JPRB,5.9442E-05_JPRB,5.9104E-05_JPRB,5.7678E-05_JPRB,&
&5.5011E-05_JPRB,5.2621E-05_JPRB,1.6066E-04_JPRB/)
KAO( :, 3, 4, 1) = (/&
&4.1547E-05_JPRB,5.7742E-05_JPRB,6.2323E-05_JPRB,6.4435E-05_JPRB,6.4943E-05_JPRB,6.4068E-05_JPRB,&
&6.1387E-05_JPRB,5.9195E-05_JPRB,1.6903E-04_JPRB/)
KAO( :, 4, 4, 1) = (/&
&4.2287E-05_JPRB,6.1604E-05_JPRB,6.7380E-05_JPRB,7.0692E-05_JPRB,7.2200E-05_JPRB,7.1920E-05_JPRB,&
&6.9467E-05_JPRB,6.6532E-05_JPRB,1.7839E-04_JPRB/)
KAO( :, 5, 4, 1) = (/&
&4.3274E-05_JPRB,6.6127E-05_JPRB,7.3452E-05_JPRB,7.8267E-05_JPRB,8.0937E-05_JPRB,8.1435E-05_JPRB,&
&7.9548E-05_JPRB,7.5644E-05_JPRB,1.8879E-04_JPRB/)
KAO( :, 1, 5, 1) = (/&
&3.6899E-05_JPRB,4.5432E-05_JPRB,4.6910E-05_JPRB,4.6828E-05_JPRB,4.5505E-05_JPRB,4.3257E-05_JPRB,&
&4.0494E-05_JPRB,4.0683E-05_JPRB,2.1040E-04_JPRB/)
KAO( :, 2, 5, 1) = (/&
&3.6791E-05_JPRB,4.7257E-05_JPRB,4.9430E-05_JPRB,4.9831E-05_JPRB,4.8726E-05_JPRB,4.6653E-05_JPRB,&
&4.3906E-05_JPRB,4.1943E-05_JPRB,2.1714E-04_JPRB/)
KAO( :, 3, 5, 1) = (/&
&3.7067E-05_JPRB,4.9759E-05_JPRB,5.2813E-05_JPRB,5.3675E-05_JPRB,5.3108E-05_JPRB,5.1487E-05_JPRB,&
&4.8518E-05_JPRB,4.6186E-05_JPRB,2.2577E-04_JPRB/)
KAO( :, 4, 5, 1) = (/&
&3.7713E-05_JPRB,5.2955E-05_JPRB,5.6991E-05_JPRB,5.8578E-05_JPRB,5.8728E-05_JPRB,5.7522E-05_JPRB,&
&5.4651E-05_JPRB,5.2154E-05_JPRB,2.3593E-04_JPRB/)
KAO( :, 5, 5, 1) = (/&
&3.8601E-05_JPRB,5.6859E-05_JPRB,6.2047E-05_JPRB,6.4624E-05_JPRB,6.5592E-05_JPRB,6.4919E-05_JPRB,&
&6.2327E-05_JPRB,5.8914E-05_JPRB,2.4626E-04_JPRB/)
KAO( :, 1, 6, 1) = (/&
&3.3082E-05_JPRB,3.9382E-05_JPRB,4.0055E-05_JPRB,3.9341E-05_JPRB,3.7713E-05_JPRB,3.5318E-05_JPRB,&
&3.2652E-05_JPRB,3.2896E-05_JPRB,2.9458E-04_JPRB/)
KAO( :, 2, 6, 1) = (/&
&3.2847E-05_JPRB,4.0822E-05_JPRB,4.1992E-05_JPRB,4.1637E-05_JPRB,4.0248E-05_JPRB,3.7895E-05_JPRB,&
&3.4950E-05_JPRB,3.3596E-05_JPRB,2.9908E-04_JPRB/)
KAO( :, 3, 6, 1) = (/&
&3.2992E-05_JPRB,4.2782E-05_JPRB,4.4664E-05_JPRB,4.4799E-05_JPRB,4.3587E-05_JPRB,4.1448E-05_JPRB,&
&3.8538E-05_JPRB,3.6195E-05_JPRB,3.0643E-04_JPRB/)
KAO( :, 4, 6, 1) = (/&
&3.3529E-05_JPRB,4.5435E-05_JPRB,4.8125E-05_JPRB,4.8714E-05_JPRB,4.7939E-05_JPRB,4.6103E-05_JPRB,&
&4.3124E-05_JPRB,4.0777E-05_JPRB,3.1650E-04_JPRB/)
KAO( :, 5, 6, 1) = (/&
&3.4353E-05_JPRB,4.8744E-05_JPRB,5.2397E-05_JPRB,5.3568E-05_JPRB,5.3408E-05_JPRB,5.1940E-05_JPRB,&
&4.9013E-05_JPRB,4.5970E-05_JPRB,3.2817E-04_JPRB/)
KAO( :, 1, 7, 1) = (/&
&2.9702E-05_JPRB,3.4031E-05_JPRB,3.4045E-05_JPRB,3.2966E-05_JPRB,3.1191E-05_JPRB,2.8774E-05_JPRB,&
&2.6215E-05_JPRB,2.6660E-05_JPRB,4.4900E-04_JPRB/)
KAO( :, 2, 7, 1) = (/&
&2.9362E-05_JPRB,3.5097E-05_JPRB,3.5527E-05_JPRB,3.4696E-05_JPRB,3.3156E-05_JPRB,3.0815E-05_JPRB,&
&2.7832E-05_JPRB,2.7318E-05_JPRB,4.4931E-04_JPRB/)
KAO( :, 3, 7, 1) = (/&
&2.9381E-05_JPRB,3.6764E-05_JPRB,3.7674E-05_JPRB,3.7240E-05_JPRB,3.5897E-05_JPRB,3.3579E-05_JPRB,&
&3.0718E-05_JPRB,2.8716E-05_JPRB,4.5416E-04_JPRB/)
KAO( :, 4, 7, 1) = (/&
&2.9804E-05_JPRB,3.8980E-05_JPRB,4.0580E-05_JPRB,4.0617E-05_JPRB,3.9435E-05_JPRB,3.7220E-05_JPRB,&
&3.4325E-05_JPRB,3.1670E-05_JPRB,4.6259E-04_JPRB/)
KAO( :, 5, 7, 1) = (/&
&3.0562E-05_JPRB,4.1836E-05_JPRB,4.4230E-05_JPRB,4.4708E-05_JPRB,4.3841E-05_JPRB,4.1868E-05_JPRB,&
&3.8884E-05_JPRB,3.5908E-05_JPRB,4.7345E-04_JPRB/)
KAO( :, 1, 8, 1) = (/&
&2.7321E-05_JPRB,3.0014E-05_JPRB,2.9442E-05_JPRB,2.8040E-05_JPRB,2.6171E-05_JPRB,2.3688E-05_JPRB,&
&2.1169E-05_JPRB,2.1771E-05_JPRB,8.4757E-04_JPRB/)
KAO( :, 2, 8, 1) = (/&
&2.6852E-05_JPRB,3.0756E-05_JPRB,3.0519E-05_JPRB,2.9342E-05_JPRB,2.7606E-05_JPRB,2.5285E-05_JPRB,&
&2.2516E-05_JPRB,2.2054E-05_JPRB,8.3254E-04_JPRB/)
KAO( :, 3, 8, 1) = (/&
&2.6744E-05_JPRB,3.2077E-05_JPRB,3.2249E-05_JPRB,3.1375E-05_JPRB,2.9814E-05_JPRB,2.7516E-05_JPRB,&
&2.4584E-05_JPRB,2.2691E-05_JPRB,8.2738E-04_JPRB/)
KAO( :, 4, 8, 1) = (/&
&2.7044E-05_JPRB,3.3995E-05_JPRB,3.4700E-05_JPRB,3.4193E-05_JPRB,3.2808E-05_JPRB,3.0482E-05_JPRB,&
&2.7565E-05_JPRB,2.5008E-05_JPRB,8.3006E-04_JPRB/)
KAO( :, 5, 8, 1) = (/&
&2.7742E-05_JPRB,3.6507E-05_JPRB,3.7912E-05_JPRB,3.7803E-05_JPRB,3.6547E-05_JPRB,3.4307E-05_JPRB,&
&3.1271E-05_JPRB,2.8258E-05_JPRB,8.3842E-04_JPRB/)
KAO( :, 1, 9, 1) = (/&
&2.4687E-05_JPRB,2.6227E-05_JPRB,2.5301E-05_JPRB,2.3694E-05_JPRB,2.1797E-05_JPRB,1.9441E-05_JPRB,&
&1.7144E-05_JPRB,1.8070E-05_JPRB,3.0692E-03_JPRB/)
KAO( :, 2, 9, 1) = (/&
&2.4149E-05_JPRB,2.6661E-05_JPRB,2.5983E-05_JPRB,2.4666E-05_JPRB,2.2860E-05_JPRB,2.0564E-05_JPRB,&
&1.8143E-05_JPRB,1.7595E-05_JPRB,2.9547E-03_JPRB/)
KAO( :, 3, 9, 1) = (/&
&2.3961E-05_JPRB,2.7611E-05_JPRB,2.7357E-05_JPRB,2.6251E-05_JPRB,2.4586E-05_JPRB,2.2361E-05_JPRB,&
&1.9658E-05_JPRB,1.8317E-05_JPRB,2.8730E-03_JPRB/)
KAO( :, 4, 9, 1) = (/&
&2.4159E-05_JPRB,2.9205E-05_JPRB,2.9375E-05_JPRB,2.8560E-05_JPRB,2.7008E-05_JPRB,2.4819E-05_JPRB,&
&2.2013E-05_JPRB,1.9707E-05_JPRB,2.8257E-03_JPRB/)
KAO( :, 5, 9, 1) = (/&
&2.4768E-05_JPRB,3.1434E-05_JPRB,3.2114E-05_JPRB,3.1586E-05_JPRB,3.0168E-05_JPRB,2.7970E-05_JPRB,&
&2.5064E-05_JPRB,2.2198E-05_JPRB,2.8077E-03_JPRB/)
KAO( :, 1,10, 1) = (/&
&2.1797E-05_JPRB,2.2612E-05_JPRB,2.1570E-05_JPRB,1.9956E-05_JPRB,1.8112E-05_JPRB,1.6002E-05_JPRB,&
&1.3941E-05_JPRB,1.4620E-05_JPRB,1.2580E-02_JPRB/)
KAO( :, 2,10, 1) = (/&
&2.1252E-05_JPRB,2.2866E-05_JPRB,2.2054E-05_JPRB,2.0662E-05_JPRB,1.8925E-05_JPRB,1.6823E-05_JPRB,&
&1.4740E-05_JPRB,1.4291E-05_JPRB,1.1973E-02_JPRB/)
KAO( :, 3,10, 1) = (/&
&2.1032E-05_JPRB,2.3616E-05_JPRB,2.3143E-05_JPRB,2.1982E-05_JPRB,2.0293E-05_JPRB,1.8202E-05_JPRB,&
&1.5821E-05_JPRB,1.4749E-05_JPRB,1.1500E-02_JPRB/)
KAO( :, 4,10, 1) = (/&
&2.1171E-05_JPRB,2.4967E-05_JPRB,2.4887E-05_JPRB,2.3890E-05_JPRB,2.2324E-05_JPRB,2.0262E-05_JPRB,&
&1.7708E-05_JPRB,1.5622E-05_JPRB,1.1158E-02_JPRB/)
KAO( :, 5,10, 1) = (/&
&2.1717E-05_JPRB,2.6968E-05_JPRB,2.7236E-05_JPRB,2.6488E-05_JPRB,2.5038E-05_JPRB,2.2971E-05_JPRB,&
&2.0251E-05_JPRB,1.7568E-05_JPRB,1.0927E-02_JPRB/)
KAO( :, 1,11, 1) = (/&
&1.8470E-05_JPRB,1.9129E-05_JPRB,1.8217E-05_JPRB,1.6833E-05_JPRB,1.5198E-05_JPRB,1.3363E-05_JPRB,&
&1.1543E-05_JPRB,1.1814E-05_JPRB,1.7618E-02_JPRB/)
KAO( :, 2,11, 1) = (/&
&1.8063E-05_JPRB,1.9445E-05_JPRB,1.8772E-05_JPRB,1.7526E-05_JPRB,1.5974E-05_JPRB,1.4135E-05_JPRB,&
&1.2268E-05_JPRB,1.1501E-05_JPRB,1.6744E-02_JPRB/)
KAO( :, 3,11, 1) = (/&
&1.7957E-05_JPRB,2.0240E-05_JPRB,1.9844E-05_JPRB,1.8765E-05_JPRB,1.7266E-05_JPRB,1.5419E-05_JPRB,&
&1.3308E-05_JPRB,1.2031E-05_JPRB,1.6060E-02_JPRB/)
KAO( :, 4,11, 1) = (/&
&1.8203E-05_JPRB,2.1589E-05_JPRB,2.1496E-05_JPRB,2.0575E-05_JPRB,1.9161E-05_JPRB,1.7309E-05_JPRB,&
&1.5025E-05_JPRB,1.2988E-05_JPRB,1.5567E-02_JPRB/)
KAO( :, 5,11, 1) = (/&
&1.8839E-05_JPRB,2.3539E-05_JPRB,2.3752E-05_JPRB,2.3027E-05_JPRB,2.1716E-05_JPRB,1.9862E-05_JPRB,&
&1.7378E-05_JPRB,1.4830E-05_JPRB,1.5199E-02_JPRB/)
KAO( :, 1,12, 1) = (/&
&1.5612E-05_JPRB,1.6179E-05_JPRB,1.5392E-05_JPRB,1.4206E-05_JPRB,1.2794E-05_JPRB,1.1200E-05_JPRB,&
&9.6111E-06_JPRB,9.5638E-06_JPRB,1.8266E-02_JPRB/)
KAO( :, 2,12, 1) = (/&
&1.5307E-05_JPRB,1.6515E-05_JPRB,1.5933E-05_JPRB,1.4844E-05_JPRB,1.3479E-05_JPRB,1.1890E-05_JPRB,&
&1.0208E-05_JPRB,9.3516E-06_JPRB,1.7358E-02_JPRB/)
KAO( :, 3,12, 1) = (/&
&1.5280E-05_JPRB,1.7278E-05_JPRB,1.6918E-05_JPRB,1.5945E-05_JPRB,1.4639E-05_JPRB,1.3025E-05_JPRB,&
&1.1176E-05_JPRB,9.8024E-06_JPRB,1.6665E-02_JPRB/)
KAO( :, 4,12, 1) = (/&
&1.5592E-05_JPRB,1.8520E-05_JPRB,1.8406E-05_JPRB,1.7580E-05_JPRB,1.6331E-05_JPRB,1.4710E-05_JPRB,&
&1.2711E-05_JPRB,1.0774E-05_JPRB,1.6133E-02_JPRB/)
KAO( :, 5,12, 1) = (/&
&1.6237E-05_JPRB,2.0286E-05_JPRB,2.0469E-05_JPRB,1.9802E-05_JPRB,1.8638E-05_JPRB,1.6992E-05_JPRB,&
&1.4787E-05_JPRB,1.2409E-05_JPRB,1.5729E-02_JPRB/)
KAO( :, 1,13, 1) = (/&
&1.3792E-05_JPRB,1.4238E-05_JPRB,1.3502E-05_JPRB,1.2414E-05_JPRB,1.1117E-05_JPRB,9.6608E-06_JPRB,&
&8.1806E-06_JPRB,7.6738E-06_JPRB,1.5338E-02_JPRB/)
KAO( :, 2,13, 1) = (/&
&1.3542E-05_JPRB,1.4555E-05_JPRB,1.3995E-05_JPRB,1.2981E-05_JPRB,1.1719E-05_JPRB,1.0269E-05_JPRB,&
&8.6775E-06_JPRB,7.6029E-06_JPRB,1.4590E-02_JPRB/)
KAO( :, 3,13, 1) = (/&
&1.3558E-05_JPRB,1.5256E-05_JPRB,1.4880E-05_JPRB,1.3955E-05_JPRB,1.2744E-05_JPRB,1.1268E-05_JPRB,&
&9.5734E-06_JPRB,8.0878E-06_JPRB,1.4000E-02_JPRB/)
KAO( :, 4,13, 1) = (/&
&1.3858E-05_JPRB,1.6375E-05_JPRB,1.6230E-05_JPRB,1.5419E-05_JPRB,1.4252E-05_JPRB,1.2754E-05_JPRB,&
&1.0921E-05_JPRB,9.0320E-06_JPRB,1.3543E-02_JPRB/)
KAO( :, 5,13, 1) = (/&
&1.4462E-05_JPRB,1.7948E-05_JPRB,1.8079E-05_JPRB,1.7409E-05_JPRB,1.6310E-05_JPRB,1.4770E-05_JPRB,&
&1.2761E-05_JPRB,1.0416E-05_JPRB,1.3196E-02_JPRB/)
KAO( :, 1, 1, 2) = (/&
&1.0631E-04_JPRB,1.5549E-04_JPRB,1.7340E-04_JPRB,1.8106E-04_JPRB,1.8266E-04_JPRB,1.7952E-04_JPRB,&
&1.7173E-04_JPRB,1.6014E-04_JPRB,1.4099E-04_JPRB/)
KAO( :, 2, 1, 2) = (/&
&1.0836E-04_JPRB,1.6879E-04_JPRB,1.9237E-04_JPRB,2.0382E-04_JPRB,2.0859E-04_JPRB,2.0748E-04_JPRB,&
&2.0039E-04_JPRB,1.8243E-04_JPRB,1.5914E-04_JPRB/)
KAO( :, 3, 1, 2) = (/&
&1.1141E-04_JPRB,1.8503E-04_JPRB,2.1527E-04_JPRB,2.3112E-04_JPRB,2.3976E-04_JPRB,2.4062E-04_JPRB,&
&2.3400E-04_JPRB,2.1520E-04_JPRB,1.8165E-04_JPRB/)
KAO( :, 4, 1, 2) = (/&
&1.1542E-04_JPRB,2.0406E-04_JPRB,2.4207E-04_JPRB,2.6306E-04_JPRB,2.7542E-04_JPRB,2.7832E-04_JPRB,&
&2.7291E-04_JPRB,2.5096E-04_JPRB,2.0989E-04_JPRB/)
KAO( :, 5, 1, 2) = (/&
&1.2040E-04_JPRB,2.2620E-04_JPRB,2.7276E-04_JPRB,2.9953E-04_JPRB,3.1543E-04_JPRB,3.2079E-04_JPRB,&
&3.1620E-04_JPRB,2.8905E-04_JPRB,2.4408E-04_JPRB/)
KAO( :, 1, 2, 2) = (/&
&9.2736E-05_JPRB,1.3080E-04_JPRB,1.4408E-04_JPRB,1.4918E-04_JPRB,1.4919E-04_JPRB,1.4563E-04_JPRB,&
&1.3832E-04_JPRB,1.2913E-04_JPRB,1.3821E-04_JPRB/)
KAO( :, 2, 2, 2) = (/&
&9.4585E-05_JPRB,1.4205E-04_JPRB,1.5994E-04_JPRB,1.6797E-04_JPRB,1.7060E-04_JPRB,1.6851E-04_JPRB,&
&1.6121E-04_JPRB,1.4625E-04_JPRB,1.5045E-04_JPRB/)
KAO( :, 3, 2, 2) = (/&
&9.7336E-05_JPRB,1.5584E-04_JPRB,1.7917E-04_JPRB,1.9059E-04_JPRB,1.9617E-04_JPRB,1.9585E-04_JPRB,&
&1.8879E-04_JPRB,1.7257E-04_JPRB,1.6847E-04_JPRB/)
KAO( :, 4, 2, 2) = (/&
&1.0100E-04_JPRB,1.7222E-04_JPRB,2.0175E-04_JPRB,2.1726E-04_JPRB,2.2590E-04_JPRB,2.2731E-04_JPRB,&
&2.2070E-04_JPRB,2.0218E-04_JPRB,1.9129E-04_JPRB/)
KAO( :, 5, 2, 2) = (/&
&1.0558E-04_JPRB,1.9122E-04_JPRB,2.2772E-04_JPRB,2.4801E-04_JPRB,2.5982E-04_JPRB,2.6260E-04_JPRB,&
&2.5652E-04_JPRB,2.3358E-04_JPRB,2.1889E-04_JPRB/)
KAO( :, 1, 3, 2) = (/&
&8.2078E-05_JPRB,1.0954E-04_JPRB,1.1829E-04_JPRB,1.2081E-04_JPRB,1.1948E-04_JPRB,1.1532E-04_JPRB,&
&1.0856E-04_JPRB,1.0266E-04_JPRB,1.7007E-04_JPRB/)
KAO( :, 2, 3, 2) = (/&
&8.3515E-05_JPRB,1.1841E-04_JPRB,1.3075E-04_JPRB,1.3555E-04_JPRB,1.3601E-04_JPRB,1.3281E-04_JPRB,&
&1.2585E-04_JPRB,1.1400E-04_JPRB,1.7692E-04_JPRB/)
KAO( :, 3, 3, 2) = (/&
&8.5702E-05_JPRB,1.2951E-04_JPRB,1.4617E-04_JPRB,1.5357E-04_JPRB,1.5612E-04_JPRB,1.5431E-04_JPRB,&
&1.4752E-04_JPRB,1.3319E-04_JPRB,1.8883E-04_JPRB/)
KAO( :, 4, 3, 2) = (/&
&8.8714E-05_JPRB,1.4294E-04_JPRB,1.6445E-04_JPRB,1.7481E-04_JPRB,1.7986E-04_JPRB,1.7967E-04_JPRB,&
&1.7282E-04_JPRB,1.5669E-04_JPRB,2.0641E-04_JPRB/)
KAO( :, 5, 3, 2) = (/&
&9.2653E-05_JPRB,1.5873E-04_JPRB,1.8560E-04_JPRB,1.9973E-04_JPRB,2.0749E-04_JPRB,2.0832E-04_JPRB,&
&2.0174E-04_JPRB,1.8232E-04_JPRB,2.2828E-04_JPRB/)
KAO( :, 1, 4, 2) = (/&
&7.5057E-05_JPRB,9.3742E-05_JPRB,9.8708E-05_JPRB,9.9032E-05_JPRB,9.6534E-05_JPRB,9.1631E-05_JPRB,&
&8.5330E-05_JPRB,8.0637E-05_JPRB,2.4302E-04_JPRB/)
KAO( :, 2, 4, 2) = (/&
&7.6019E-05_JPRB,1.0050E-04_JPRB,1.0818E-04_JPRB,1.1027E-04_JPRB,1.0900E-04_JPRB,1.0488E-04_JPRB,&
&9.8357E-05_JPRB,8.9315E-05_JPRB,2.5003E-04_JPRB/)
KAO( :, 3, 4, 2) = (/&
&7.7597E-05_JPRB,1.0920E-04_JPRB,1.2007E-04_JPRB,1.2426E-04_JPRB,1.2440E-04_JPRB,1.2138E-04_JPRB,&
&1.1480E-04_JPRB,1.0183E-04_JPRB,2.5796E-04_JPRB/)
KAO( :, 4, 4, 2) = (/&
&7.9952E-05_JPRB,1.1979E-04_JPRB,1.3449E-04_JPRB,1.4091E-04_JPRB,1.4297E-04_JPRB,1.4131E-04_JPRB,&
&1.3468E-04_JPRB,1.2088E-04_JPRB,2.6766E-04_JPRB/)
KAO( :, 5, 4, 2) = (/&
&8.3148E-05_JPRB,1.3259E-04_JPRB,1.5143E-04_JPRB,1.6061E-04_JPRB,1.6491E-04_JPRB,1.6427E-04_JPRB,&
&1.5762E-04_JPRB,1.4129E-04_JPRB,2.8200E-04_JPRB/)
KAO( :, 1, 5, 2) = (/&
&7.0507E-05_JPRB,8.2851E-05_JPRB,8.4727E-05_JPRB,8.3356E-05_JPRB,7.9669E-05_JPRB,7.4240E-05_JPRB,&
&6.8168E-05_JPRB,6.4269E-05_JPRB,3.5533E-04_JPRB/)
KAO( :, 2, 5, 2) = (/&
&7.1163E-05_JPRB,8.7993E-05_JPRB,9.1940E-05_JPRB,9.1728E-05_JPRB,8.9016E-05_JPRB,8.4180E-05_JPRB,&
&7.7602E-05_JPRB,7.0901E-05_JPRB,3.6205E-04_JPRB/)
KAO( :, 3, 5, 2) = (/&
&7.2353E-05_JPRB,9.4696E-05_JPRB,1.0096E-04_JPRB,1.0241E-04_JPRB,1.0073E-04_JPRB,9.6618E-05_JPRB,&
&9.0257E-05_JPRB,7.9342E-05_JPRB,3.6910E-04_JPRB/)
KAO( :, 4, 5, 2) = (/&
&7.4211E-05_JPRB,1.0309E-04_JPRB,1.1198E-04_JPRB,1.1540E-04_JPRB,1.1506E-04_JPRB,1.1201E-04_JPRB,&
&1.0538E-04_JPRB,9.2743E-05_JPRB,3.7730E-04_JPRB/)
KAO( :, 5, 5, 2) = (/&
&7.6842E-05_JPRB,1.1301E-04_JPRB,1.2533E-04_JPRB,1.3080E-04_JPRB,1.3221E-04_JPRB,1.3010E-04_JPRB,&
&1.2341E-04_JPRB,1.0902E-04_JPRB,3.8882E-04_JPRB/)
KAO( :, 1, 6, 2) = (/&
&6.7057E-05_JPRB,7.4992E-05_JPRB,7.4494E-05_JPRB,7.1808E-05_JPRB,6.7401E-05_JPRB,6.1558E-05_JPRB,&
&5.5600E-05_JPRB,5.3582E-05_JPRB,5.2728E-04_JPRB/)
KAO( :, 2, 6, 2) = (/&
&6.7342E-05_JPRB,7.8865E-05_JPRB,7.9962E-05_JPRB,7.8191E-05_JPRB,7.4156E-05_JPRB,6.8577E-05_JPRB,&
&6.2398E-05_JPRB,5.6569E-05_JPRB,5.3013E-04_JPRB/)
KAO( :, 3, 6, 2) = (/&
&6.8218E-05_JPRB,8.4114E-05_JPRB,8.7034E-05_JPRB,8.6152E-05_JPRB,8.2978E-05_JPRB,7.8073E-05_JPRB,&
&7.1379E-05_JPRB,6.2472E-05_JPRB,5.3405E-04_JPRB/)
KAO( :, 4, 6, 2) = (/&
&6.9765E-05_JPRB,9.0741E-05_JPRB,9.5513E-05_JPRB,9.6075E-05_JPRB,9.4001E-05_JPRB,8.9757E-05_JPRB,&
&8.2727E-05_JPRB,7.1298E-05_JPRB,5.3812E-04_JPRB/)
KAO( :, 5, 6, 2) = (/&
&7.2087E-05_JPRB,9.8694E-05_JPRB,1.0570E-04_JPRB,1.0811E-04_JPRB,1.0716E-04_JPRB,1.0356E-04_JPRB,&
&9.6610E-05_JPRB,8.3845E-05_JPRB,5.4521E-04_JPRB/)
KAO( :, 1, 7, 2) = (/&
&6.3981E-05_JPRB,6.8796E-05_JPRB,6.6960E-05_JPRB,6.3245E-05_JPRB,5.8395E-05_JPRB,5.2642E-05_JPRB,&
&4.7017E-05_JPRB,4.3597E-05_JPRB,8.5561E-04_JPRB/)
KAO( :, 2, 7, 2) = (/&
&6.4065E-05_JPRB,7.1972E-05_JPRB,7.1316E-05_JPRB,6.8334E-05_JPRB,6.3687E-05_JPRB,5.7772E-05_JPRB,&
&5.1662E-05_JPRB,4.6088E-05_JPRB,8.4325E-04_JPRB/)
KAO( :, 3, 7, 2) = (/&
&6.4710E-05_JPRB,7.6213E-05_JPRB,7.7049E-05_JPRB,7.4782E-05_JPRB,7.0451E-05_JPRB,6.4812E-05_JPRB,&
&5.7879E-05_JPRB,5.0007E-05_JPRB,8.3547E-04_JPRB/)
KAO( :, 4, 7, 2) = (/&
&6.6047E-05_JPRB,8.1740E-05_JPRB,8.4011E-05_JPRB,8.2492E-05_JPRB,7.9038E-05_JPRB,7.3729E-05_JPRB,&
&6.6297E-05_JPRB,5.5934E-05_JPRB,8.3289E-04_JPRB/)
KAO( :, 5, 7, 2) = (/&
&6.8167E-05_JPRB,8.8466E-05_JPRB,9.2188E-05_JPRB,9.2019E-05_JPRB,8.9278E-05_JPRB,8.4398E-05_JPRB,&
&7.6796E-05_JPRB,6.5449E-05_JPRB,8.3519E-04_JPRB/)
KAO( :, 1, 8, 2) = (/&
&6.2510E-05_JPRB,6.4632E-05_JPRB,6.1651E-05_JPRB,5.7339E-05_JPRB,5.1955E-05_JPRB,4.6202E-05_JPRB,&
&4.0544E-05_JPRB,3.4871E-05_JPRB,1.7109E-03_JPRB/)
KAO( :, 2, 8, 2) = (/&
&6.2657E-05_JPRB,6.7414E-05_JPRB,6.5438E-05_JPRB,6.1572E-05_JPRB,5.6549E-05_JPRB,5.0497E-05_JPRB,&
&4.4065E-05_JPRB,3.7625E-05_JPRB,1.6570E-03_JPRB/)
KAO( :, 3, 8, 2) = (/&
&6.3371E-05_JPRB,7.1203E-05_JPRB,7.0449E-05_JPRB,6.7168E-05_JPRB,6.2333E-05_JPRB,5.6127E-05_JPRB,&
&4.8965E-05_JPRB,4.1883E-05_JPRB,1.6155E-03_JPRB/)
KAO( :, 4, 8, 2) = (/&
&6.4738E-05_JPRB,7.6021E-05_JPRB,7.6569E-05_JPRB,7.3931E-05_JPRB,6.9329E-05_JPRB,6.3277E-05_JPRB,&
&5.5409E-05_JPRB,4.5618E-05_JPRB,1.5874E-03_JPRB/)
KAO( :, 5, 8, 2) = (/&
&6.6770E-05_JPRB,8.2019E-05_JPRB,8.3827E-05_JPRB,8.1865E-05_JPRB,7.7838E-05_JPRB,7.1738E-05_JPRB,&
&6.3577E-05_JPRB,5.2190E-05_JPRB,1.5711E-03_JPRB/)
KAO( :, 1, 9, 2) = (/&
&5.9728E-05_JPRB,5.9777E-05_JPRB,5.6068E-05_JPRB,5.1537E-05_JPRB,4.6074E-05_JPRB,4.0294E-05_JPRB,&
&3.4429E-05_JPRB,2.7470E-05_JPRB,6.4927E-03_JPRB/)
KAO( :, 2, 9, 2) = (/&
&6.0003E-05_JPRB,6.2162E-05_JPRB,5.9412E-05_JPRB,5.5191E-05_JPRB,4.9924E-05_JPRB,4.3949E-05_JPRB,&
&3.7436E-05_JPRB,3.0651E-05_JPRB,6.2135E-03_JPRB/)
KAO( :, 3, 9, 2) = (/&
&6.0913E-05_JPRB,6.5739E-05_JPRB,6.3824E-05_JPRB,6.0113E-05_JPRB,5.5046E-05_JPRB,4.8801E-05_JPRB,&
&4.1506E-05_JPRB,3.4176E-05_JPRB,5.9805E-03_JPRB/)
KAO( :, 4, 9, 2) = (/&
&6.2491E-05_JPRB,7.0239E-05_JPRB,6.9462E-05_JPRB,6.6167E-05_JPRB,6.1198E-05_JPRB,5.4677E-05_JPRB,&
&4.6786E-05_JPRB,3.7966E-05_JPRB,5.7915E-03_JPRB/)
KAO( :, 5, 9, 2) = (/&
&6.4708E-05_JPRB,7.5807E-05_JPRB,7.6215E-05_JPRB,7.3304E-05_JPRB,6.8390E-05_JPRB,6.1872E-05_JPRB,&
&5.3436E-05_JPRB,4.2944E-05_JPRB,5.6478E-03_JPRB/)
KAO( :, 1,10, 2) = (/&
&5.7126E-05_JPRB,5.5833E-05_JPRB,5.1557E-05_JPRB,4.6740E-05_JPRB,4.1349E-05_JPRB,3.5460E-05_JPRB,&
&2.9383E-05_JPRB,2.2254E-05_JPRB,2.8102E-02_JPRB/)
KAO( :, 2,10, 2) = (/&
&5.7625E-05_JPRB,5.8090E-05_JPRB,5.4514E-05_JPRB,5.0007E-05_JPRB,4.4659E-05_JPRB,3.8611E-05_JPRB,&
&3.1928E-05_JPRB,2.5019E-05_JPRB,2.6630E-02_JPRB/)
KAO( :, 3,10, 2) = (/&
&5.8840E-05_JPRB,6.1513E-05_JPRB,5.8714E-05_JPRB,5.4556E-05_JPRB,4.9297E-05_JPRB,4.2998E-05_JPRB,&
&3.5795E-05_JPRB,2.7821E-05_JPRB,2.5370E-02_JPRB/)
KAO( :, 4,10, 2) = (/&
&6.0763E-05_JPRB,6.6038E-05_JPRB,6.4072E-05_JPRB,6.0305E-05_JPRB,5.4952E-05_JPRB,4.8371E-05_JPRB,&
&4.0375E-05_JPRB,3.1951E-05_JPRB,2.4311E-02_JPRB/)
KAO( :, 5,10, 2) = (/&
&6.3372E-05_JPRB,7.1487E-05_JPRB,7.0499E-05_JPRB,6.7017E-05_JPRB,6.1584E-05_JPRB,5.4655E-05_JPRB,&
&4.6116E-05_JPRB,3.6268E-05_JPRB,2.3439E-02_JPRB/)
KAO( :, 1,11, 2) = (/&
&5.3603E-05_JPRB,5.2084E-05_JPRB,4.7825E-05_JPRB,4.2996E-05_JPRB,3.7707E-05_JPRB,3.1871E-05_JPRB,&
&2.5749E-05_JPRB,1.8962E-05_JPRB,4.0768E-02_JPRB/)
KAO( :, 2,11, 2) = (/&
&5.4665E-05_JPRB,5.4805E-05_JPRB,5.1049E-05_JPRB,4.6457E-05_JPRB,4.1159E-05_JPRB,3.5139E-05_JPRB,&
&2.8405E-05_JPRB,2.1377E-05_JPRB,3.8491E-02_JPRB/)
KAO( :, 3,11, 2) = (/&
&5.6497E-05_JPRB,5.8583E-05_JPRB,5.5394E-05_JPRB,5.1053E-05_JPRB,4.5792E-05_JPRB,3.9489E-05_JPRB,&
&3.2243E-05_JPRB,2.4328E-05_JPRB,3.6513E-02_JPRB/)
KAO( :, 4,11, 2) = (/&
&5.8985E-05_JPRB,6.3339E-05_JPRB,6.0862E-05_JPRB,5.6796E-05_JPRB,5.1415E-05_JPRB,4.4728E-05_JPRB,&
&3.6818E-05_JPRB,2.8272E-05_JPRB,3.4835E-02_JPRB/)
KAO( :, 5,11, 2) = (/&
&6.2109E-05_JPRB,6.9025E-05_JPRB,6.7331E-05_JPRB,6.3560E-05_JPRB,5.7958E-05_JPRB,5.0821E-05_JPRB,&
&4.2238E-05_JPRB,3.2283E-05_JPRB,3.3538E-02_JPRB/)
KAO( :, 1,12, 2) = (/&
&4.8218E-05_JPRB,4.6772E-05_JPRB,4.2783E-05_JPRB,3.8266E-05_JPRB,3.3329E-05_JPRB,2.7973E-05_JPRB,&
&2.2210E-05_JPRB,1.6103E-05_JPRB,4.2855E-02_JPRB/)
KAO( :, 2,12, 2) = (/&
&4.9589E-05_JPRB,4.9591E-05_JPRB,4.5984E-05_JPRB,4.1620E-05_JPRB,3.6685E-05_JPRB,3.1116E-05_JPRB,&
&2.4857E-05_JPRB,1.8118E-05_JPRB,4.0385E-02_JPRB/)
KAO( :, 3,12, 2) = (/&
&5.1684E-05_JPRB,5.3446E-05_JPRB,5.0256E-05_JPRB,4.6072E-05_JPRB,4.1058E-05_JPRB,3.5154E-05_JPRB,&
&2.8460E-05_JPRB,2.1061E-05_JPRB,3.8259E-02_JPRB/)
KAO( :, 4,12, 2) = (/&
&5.4404E-05_JPRB,5.8179E-05_JPRB,5.5538E-05_JPRB,5.1508E-05_JPRB,4.6383E-05_JPRB,4.0102E-05_JPRB,&
&3.2710E-05_JPRB,2.4512E-05_JPRB,3.6555E-02_JPRB/)
KAO( :, 5,12, 2) = (/&
&5.7705E-05_JPRB,6.3751E-05_JPRB,6.1743E-05_JPRB,5.7901E-05_JPRB,5.2567E-05_JPRB,4.5798E-05_JPRB,&
&3.7620E-05_JPRB,2.8071E-05_JPRB,3.5258E-02_JPRB/)
KAO( :, 1,13, 2) = (/&
&4.4847E-05_JPRB,4.3227E-05_JPRB,3.9370E-05_JPRB,3.5016E-05_JPRB,3.0292E-05_JPRB,2.5212E-05_JPRB,&
&1.9650E-05_JPRB,1.3504E-05_JPRB,3.6293E-02_JPRB/)
KAO( :, 2,13, 2) = (/&
&4.6428E-05_JPRB,4.6148E-05_JPRB,4.2554E-05_JPRB,3.8305E-05_JPRB,3.3519E-05_JPRB,2.8187E-05_JPRB,&
&2.2241E-05_JPRB,1.5699E-05_JPRB,3.4162E-02_JPRB/)
KAO( :, 3,13, 2) = (/&
&4.8652E-05_JPRB,5.0010E-05_JPRB,4.6740E-05_JPRB,4.2580E-05_JPRB,3.7668E-05_JPRB,3.2017E-05_JPRB,&
&2.5602E-05_JPRB,1.8433E-05_JPRB,3.2408E-02_JPRB/)
KAO( :, 4,13, 2) = (/&
&5.1540E-05_JPRB,5.4741E-05_JPRB,5.1862E-05_JPRB,4.7783E-05_JPRB,4.2732E-05_JPRB,3.6679E-05_JPRB,&
&2.9552E-05_JPRB,2.1520E-05_JPRB,3.1021E-02_JPRB/)
KAO( :, 5,13, 2) = (/&
&5.5009E-05_JPRB,6.0274E-05_JPRB,5.7902E-05_JPRB,5.3924E-05_JPRB,4.8654E-05_JPRB,4.2058E-05_JPRB,&
&3.4024E-05_JPRB,2.4705E-05_JPRB,2.9920E-02_JPRB/)
KAO( :, 1, 1, 3) = (/&
&2.1996E-04_JPRB,2.9526E-04_JPRB,3.2298E-04_JPRB,3.3886E-04_JPRB,3.4278E-04_JPRB,3.3270E-04_JPRB,&
&3.0580E-04_JPRB,2.6421E-04_JPRB,1.9405E-04_JPRB/)
KAO( :, 2, 1, 3) = (/&
&2.2777E-04_JPRB,3.2546E-04_JPRB,3.6631E-04_JPRB,3.9178E-04_JPRB,3.9976E-04_JPRB,3.8992E-04_JPRB,&
&3.6015E-04_JPRB,3.0390E-04_JPRB,2.3244E-04_JPRB/)
KAO( :, 3, 1, 3) = (/&
&2.3798E-04_JPRB,3.6240E-04_JPRB,4.1819E-04_JPRB,4.5171E-04_JPRB,4.6388E-04_JPRB,4.5403E-04_JPRB,&
&4.2005E-04_JPRB,3.4862E-04_JPRB,2.7996E-04_JPRB/)
KAO( :, 4, 1, 3) = (/&
&2.5036E-04_JPRB,4.0578E-04_JPRB,4.7739E-04_JPRB,5.1796E-04_JPRB,5.3466E-04_JPRB,5.2428E-04_JPRB,&
&4.8540E-04_JPRB,4.0265E-04_JPRB,3.3613E-04_JPRB/)
KAO( :, 5, 1, 3) = (/&
&2.6491E-04_JPRB,4.5514E-04_JPRB,5.4139E-04_JPRB,5.9019E-04_JPRB,6.1021E-04_JPRB,6.0113E-04_JPRB,&
&5.5511E-04_JPRB,4.6549E-04_JPRB,4.0231E-04_JPRB/)
KAO( :, 1, 2, 3) = (/&
&1.9023E-04_JPRB,2.4938E-04_JPRB,2.6928E-04_JPRB,2.7999E-04_JPRB,2.8164E-04_JPRB,2.7165E-04_JPRB,&
&2.4816E-04_JPRB,2.1405E-04_JPRB,1.8605E-04_JPRB/)
KAO( :, 2, 2, 3) = (/&
&1.9755E-04_JPRB,2.7578E-04_JPRB,3.0701E-04_JPRB,3.2514E-04_JPRB,3.2961E-04_JPRB,3.1950E-04_JPRB,&
&2.9350E-04_JPRB,2.4834E-04_JPRB,2.1661E-04_JPRB/)
KAO( :, 3, 2, 3) = (/&
&2.0698E-04_JPRB,3.0835E-04_JPRB,3.5213E-04_JPRB,3.7659E-04_JPRB,3.8400E-04_JPRB,3.7352E-04_JPRB,&
&3.4485E-04_JPRB,2.8635E-04_JPRB,2.5484E-04_JPRB/)
KAO( :, 4, 2, 3) = (/&
&2.1845E-04_JPRB,3.4704E-04_JPRB,4.0375E-04_JPRB,4.3389E-04_JPRB,4.4469E-04_JPRB,4.3366E-04_JPRB,&
&4.0044E-04_JPRB,3.3118E-04_JPRB,3.0181E-04_JPRB/)
KAO( :, 5, 2, 3) = (/&
&2.3191E-04_JPRB,3.9121E-04_JPRB,4.5961E-04_JPRB,4.9694E-04_JPRB,5.1051E-04_JPRB,5.0008E-04_JPRB,&
&4.5954E-04_JPRB,3.8446E-04_JPRB,3.5821E-04_JPRB/)
KAO( :, 1, 3, 3) = (/&
&1.6337E-04_JPRB,2.0696E-04_JPRB,2.1920E-04_JPRB,2.2438E-04_JPRB,2.2325E-04_JPRB,2.1342E-04_JPRB,&
&1.9346E-04_JPRB,1.6754E-04_JPRB,2.2851E-04_JPRB/)
KAO( :, 2, 3, 3) = (/&
&1.6969E-04_JPRB,2.2863E-04_JPRB,2.5003E-04_JPRB,2.6113E-04_JPRB,2.6214E-04_JPRB,2.5210E-04_JPRB,&
&2.2996E-04_JPRB,1.9528E-04_JPRB,2.5004E-04_JPRB/)
KAO( :, 3, 3, 3) = (/&
&1.7794E-04_JPRB,2.5581E-04_JPRB,2.8765E-04_JPRB,3.0386E-04_JPRB,3.0684E-04_JPRB,2.9654E-04_JPRB,&
&2.7213E-04_JPRB,2.2576E-04_JPRB,2.7938E-04_JPRB/)
KAO( :, 4, 3, 3) = (/&
&1.8809E-04_JPRB,2.8851E-04_JPRB,3.3100E-04_JPRB,3.5226E-04_JPRB,3.5780E-04_JPRB,3.4669E-04_JPRB,&
&3.1871E-04_JPRB,2.6155E-04_JPRB,3.1781E-04_JPRB/)
KAO( :, 5, 3, 3) = (/&
&2.0000E-04_JPRB,3.2610E-04_JPRB,3.7882E-04_JPRB,4.0593E-04_JPRB,4.1389E-04_JPRB,4.0266E-04_JPRB,&
&3.6759E-04_JPRB,3.0486E-04_JPRB,3.6667E-04_JPRB/)
KAO( :, 1, 4, 3) = (/&
&1.4241E-04_JPRB,1.7332E-04_JPRB,1.7952E-04_JPRB,1.8020E-04_JPRB,1.7647E-04_JPRB,1.6735E-04_JPRB,&
&1.4973E-04_JPRB,1.3184E-04_JPRB,3.2106E-04_JPRB/)
KAO( :, 2, 4, 3) = (/&
&1.4769E-04_JPRB,1.9050E-04_JPRB,2.0392E-04_JPRB,2.0940E-04_JPRB,2.0737E-04_JPRB,1.9737E-04_JPRB,&
&1.7818E-04_JPRB,1.5166E-04_JPRB,3.3469E-04_JPRB/)
KAO( :, 3, 4, 3) = (/&
&1.5465E-04_JPRB,2.1252E-04_JPRB,2.3439E-04_JPRB,2.4418E-04_JPRB,2.4355E-04_JPRB,2.3330E-04_JPRB,&
&2.1176E-04_JPRB,1.7565E-04_JPRB,3.5614E-04_JPRB/)
KAO( :, 4, 4, 3) = (/&
&1.6328E-04_JPRB,2.3941E-04_JPRB,2.6997E-04_JPRB,2.8414E-04_JPRB,2.8560E-04_JPRB,2.7432E-04_JPRB,&
&2.4968E-04_JPRB,2.0300E-04_JPRB,3.8786E-04_JPRB/)
KAO( :, 5, 4, 3) = (/&
&1.7360E-04_JPRB,2.7074E-04_JPRB,3.1000E-04_JPRB,3.2898E-04_JPRB,3.3251E-04_JPRB,3.2018E-04_JPRB,&
&2.9030E-04_JPRB,2.3792E-04_JPRB,4.3003E-04_JPRB/)
KAO( :, 1, 5, 3) = (/&
&1.2728E-04_JPRB,1.4778E-04_JPRB,1.4974E-04_JPRB,1.4737E-04_JPRB,1.4151E-04_JPRB,1.3231E-04_JPRB,&
&1.1681E-04_JPRB,1.0270E-04_JPRB,4.7573E-04_JPRB/)
KAO( :, 2, 5, 3) = (/&
&1.3157E-04_JPRB,1.6147E-04_JPRB,1.6852E-04_JPRB,1.6982E-04_JPRB,1.6546E-04_JPRB,1.5568E-04_JPRB,&
&1.3883E-04_JPRB,1.1790E-04_JPRB,4.8146E-04_JPRB/)
KAO( :, 3, 5, 3) = (/&
&1.3726E-04_JPRB,1.7914E-04_JPRB,1.9255E-04_JPRB,1.9744E-04_JPRB,1.9449E-04_JPRB,1.8411E-04_JPRB,&
&1.6473E-04_JPRB,1.3672E-04_JPRB,4.9353E-04_JPRB/)
KAO( :, 4, 5, 3) = (/&
&1.4435E-04_JPRB,2.0063E-04_JPRB,2.2141E-04_JPRB,2.2988E-04_JPRB,2.2840E-04_JPRB,2.1697E-04_JPRB,&
&1.9533E-04_JPRB,1.5780E-04_JPRB,5.1440E-04_JPRB/)
KAO( :, 5, 5, 3) = (/&
&1.5296E-04_JPRB,2.2635E-04_JPRB,2.5441E-04_JPRB,2.6691E-04_JPRB,2.6692E-04_JPRB,2.5417E-04_JPRB,&
&2.2886E-04_JPRB,1.8463E-04_JPRB,5.4687E-04_JPRB/)
KAO( :, 1, 6, 3) = (/&
&1.1763E-04_JPRB,1.2927E-04_JPRB,1.2797E-04_JPRB,1.2303E-04_JPRB,1.1545E-04_JPRB,1.0562E-04_JPRB,&
&9.1765E-05_JPRB,7.9707E-05_JPRB,7.1798E-04_JPRB/)
KAO( :, 2, 6, 3) = (/&
&1.2108E-04_JPRB,1.3972E-04_JPRB,1.4189E-04_JPRB,1.3941E-04_JPRB,1.3314E-04_JPRB,1.2332E-04_JPRB,&
&1.0817E-04_JPRB,9.2633E-05_JPRB,7.1177E-04_JPRB/)
KAO( :, 3, 6, 3) = (/&
&1.2566E-04_JPRB,1.5364E-04_JPRB,1.6005E-04_JPRB,1.6046E-04_JPRB,1.5545E-04_JPRB,1.4506E-04_JPRB,&
&1.2802E-04_JPRB,1.0643E-04_JPRB,7.1286E-04_JPRB/)
KAO( :, 4, 6, 3) = (/&
&1.3128E-04_JPRB,1.7051E-04_JPRB,1.8240E-04_JPRB,1.8616E-04_JPRB,1.8213E-04_JPRB,1.7092E-04_JPRB,&
&1.5182E-04_JPRB,1.2232E-04_JPRB,7.2407E-04_JPRB/)
KAO( :, 5, 6, 3) = (/&
&1.3815E-04_JPRB,1.9078E-04_JPRB,2.0902E-04_JPRB,2.1580E-04_JPRB,2.1291E-04_JPRB,2.0039E-04_JPRB,&
&1.7876E-04_JPRB,1.4231E-04_JPRB,7.4599E-04_JPRB/)
KAO( :, 1, 7, 3) = (/&
&1.1390E-04_JPRB,1.1947E-04_JPRB,1.1509E-04_JPRB,1.0795E-04_JPRB,9.8745E-05_JPRB,8.7676E-05_JPRB,&
&7.3630E-05_JPRB,6.4348E-05_JPRB,1.1861E-03_JPRB/)
KAO( :, 2, 7, 3) = (/&
&1.1683E-04_JPRB,1.2744E-04_JPRB,1.2545E-04_JPRB,1.1972E-04_JPRB,1.1135E-04_JPRB,1.0038E-04_JPRB,&
&8.6144E-05_JPRB,7.3622E-05_JPRB,1.1591E-03_JPRB/)
KAO( :, 3, 7, 3) = (/&
&1.2074E-04_JPRB,1.3815E-04_JPRB,1.3900E-04_JPRB,1.3526E-04_JPRB,1.2779E-04_JPRB,1.1675E-04_JPRB,&
&1.0110E-04_JPRB,8.3354E-05_JPRB,1.1418E-03_JPRB/)
KAO( :, 4, 7, 3) = (/&
&1.2564E-04_JPRB,1.5125E-04_JPRB,1.5566E-04_JPRB,1.5486E-04_JPRB,1.4804E-04_JPRB,1.3653E-04_JPRB,&
&1.1897E-04_JPRB,9.5580E-05_JPRB,1.1345E-03_JPRB/)
KAO( :, 5, 7, 3) = (/&
&1.3130E-04_JPRB,1.6685E-04_JPRB,1.7626E-04_JPRB,1.7784E-04_JPRB,1.7201E-04_JPRB,1.5950E-04_JPRB,&
&1.4031E-04_JPRB,1.0987E-04_JPRB,1.1432E-03_JPRB/)
KAO( :, 1, 8, 3) = (/&
&1.1676E-04_JPRB,1.1853E-04_JPRB,1.1141E-04_JPRB,1.0211E-04_JPRB,9.1156E-05_JPRB,7.8301E-05_JPRB,&
&6.3522E-05_JPRB,5.5937E-05_JPRB,2.4094E-03_JPRB/)
KAO( :, 2, 8, 3) = (/&
&1.1985E-04_JPRB,1.2513E-04_JPRB,1.1980E-04_JPRB,1.1130E-04_JPRB,1.0061E-04_JPRB,8.7533E-05_JPRB,&
&7.2505E-05_JPRB,6.1035E-05_JPRB,2.3252E-03_JPRB/)
KAO( :, 3, 8, 3) = (/&
&1.2377E-04_JPRB,1.3400E-04_JPRB,1.3053E-04_JPRB,1.2319E-04_JPRB,1.1282E-04_JPRB,9.9725E-05_JPRB,&
&8.3671E-05_JPRB,6.6418E-05_JPRB,2.2547E-03_JPRB/)
KAO( :, 4, 8, 3) = (/&
&1.2843E-04_JPRB,1.4498E-04_JPRB,1.4372E-04_JPRB,1.3796E-04_JPRB,1.2812E-04_JPRB,1.1463E-04_JPRB,&
&9.6976E-05_JPRB,7.5638E-05_JPRB,2.2063E-03_JPRB/)
KAO( :, 5, 8, 3) = (/&
&1.3377E-04_JPRB,1.5770E-04_JPRB,1.5943E-04_JPRB,1.5571E-04_JPRB,1.4617E-04_JPRB,1.3202E-04_JPRB,&
&1.1296E-04_JPRB,8.6665E-05_JPRB,2.1851E-03_JPRB/)
KAO( :, 1, 9, 3) = (/&
&1.1900E-04_JPRB,1.1760E-04_JPRB,1.0852E-04_JPRB,9.7634E-05_JPRB,8.5611E-05_JPRB,7.2038E-05_JPRB,&
&5.7121E-05_JPRB,5.0882E-05_JPRB,9.3039E-03_JPRB/)
KAO( :, 2, 9, 3) = (/&
&1.2244E-04_JPRB,1.2389E-04_JPRB,1.1590E-04_JPRB,1.0554E-04_JPRB,9.3325E-05_JPRB,7.9548E-05_JPRB,&
&6.3970E-05_JPRB,5.3089E-05_JPRB,8.8588E-03_JPRB/)
KAO( :, 3, 9, 3) = (/&
&1.2665E-04_JPRB,1.3180E-04_JPRB,1.2538E-04_JPRB,1.1542E-04_JPRB,1.0335E-04_JPRB,8.9270E-05_JPRB,&
&7.2786E-05_JPRB,5.6389E-05_JPRB,8.4831E-03_JPRB/)
KAO( :, 4, 9, 3) = (/&
&1.3137E-04_JPRB,1.4182E-04_JPRB,1.3671E-04_JPRB,1.2766E-04_JPRB,1.1600E-04_JPRB,1.0124E-04_JPRB,&
&8.3094E-05_JPRB,6.1858E-05_JPRB,8.1874E-03_JPRB/)
KAO( :, 5, 9, 3) = (/&
&1.3659E-04_JPRB,1.5316E-04_JPRB,1.4996E-04_JPRB,1.4235E-04_JPRB,1.3080E-04_JPRB,1.1485E-04_JPRB,&
&9.5226E-05_JPRB,6.9785E-05_JPRB,7.9858E-03_JPRB/)
KAO( :, 1,10, 3) = (/&
&1.2241E-04_JPRB,1.1830E-04_JPRB,1.0781E-04_JPRB,9.5617E-05_JPRB,8.2345E-05_JPRB,6.8338E-05_JPRB,&
&5.2826E-05_JPRB,4.6160E-05_JPRB,4.0381E-02_JPRB/)
KAO( :, 2,10, 3) = (/&
&1.2664E-04_JPRB,1.2454E-04_JPRB,1.1474E-04_JPRB,1.0301E-04_JPRB,8.9686E-05_JPRB,7.5133E-05_JPRB,&
&5.8776E-05_JPRB,4.7480E-05_JPRB,3.8200E-02_JPRB/)
KAO( :, 3,10, 3) = (/&
&1.3156E-04_JPRB,1.3237E-04_JPRB,1.2366E-04_JPRB,1.1203E-04_JPRB,9.8559E-05_JPRB,8.3570E-05_JPRB,&
&6.6092E-05_JPRB,4.9993E-05_JPRB,3.6380E-02_JPRB/)
KAO( :, 4,10, 3) = (/&
&1.3697E-04_JPRB,1.4182E-04_JPRB,1.3416E-04_JPRB,1.2285E-04_JPRB,1.0946E-04_JPRB,9.3555E-05_JPRB,&
&7.4960E-05_JPRB,5.3295E-05_JPRB,3.4905E-02_JPRB/)
KAO( :, 5,10, 3) = (/&
&1.4259E-04_JPRB,1.5277E-04_JPRB,1.4630E-04_JPRB,1.3560E-04_JPRB,1.2209E-04_JPRB,1.0520E-04_JPRB,&
&8.5036E-05_JPRB,5.9404E-05_JPRB,3.3870E-02_JPRB/)
KAO( :, 1,11, 3) = (/&
&1.2464E-04_JPRB,1.1924E-04_JPRB,1.0798E-04_JPRB,9.5208E-05_JPRB,8.1370E-05_JPRB,6.6802E-05_JPRB,&
&5.0925E-05_JPRB,4.1000E-05_JPRB,5.9272E-02_JPRB/)
KAO( :, 2,11, 3) = (/&
&1.2962E-04_JPRB,1.2601E-04_JPRB,1.1550E-04_JPRB,1.0297E-04_JPRB,8.8796E-05_JPRB,7.3413E-05_JPRB,&
&5.6677E-05_JPRB,4.3091E-05_JPRB,5.5988E-02_JPRB/)
KAO( :, 3,11, 3) = (/&
&1.3526E-04_JPRB,1.3432E-04_JPRB,1.2476E-04_JPRB,1.1207E-04_JPRB,9.7433E-05_JPRB,8.1433E-05_JPRB,&
&6.3587E-05_JPRB,4.4893E-05_JPRB,5.3301E-02_JPRB/)
KAO( :, 4,11, 3) = (/&
&1.4143E-04_JPRB,1.4433E-04_JPRB,1.3524E-04_JPRB,1.2250E-04_JPRB,1.0762E-04_JPRB,9.0841E-05_JPRB,&
&7.1572E-05_JPRB,4.8589E-05_JPRB,5.1249E-02_JPRB/)
KAO( :, 5,11, 3) = (/&
&1.4794E-04_JPRB,1.5535E-04_JPRB,1.4694E-04_JPRB,1.3429E-04_JPRB,1.1923E-04_JPRB,1.0163E-04_JPRB,&
&8.0508E-05_JPRB,5.4223E-05_JPRB,4.9838E-02_JPRB/)
KAO( :, 1,12, 3) = (/&
&1.1910E-04_JPRB,1.1316E-04_JPRB,1.0208E-04_JPRB,8.9709E-05_JPRB,7.6333E-05_JPRB,6.2180E-05_JPRB,&
&4.7000E-05_JPRB,3.5676E-05_JPRB,6.3357E-02_JPRB/)
KAO( :, 2,12, 3) = (/&
&1.2455E-04_JPRB,1.2008E-04_JPRB,1.0962E-04_JPRB,9.7228E-05_JPRB,8.3393E-05_JPRB,6.8465E-05_JPRB,&
&5.2437E-05_JPRB,3.7619E-05_JPRB,5.9804E-02_JPRB/)
KAO( :, 3,12, 3) = (/&
&1.3047E-04_JPRB,1.2832E-04_JPRB,1.1854E-04_JPRB,1.0591E-04_JPRB,9.1615E-05_JPRB,7.5950E-05_JPRB,&
&5.8544E-05_JPRB,3.9665E-05_JPRB,5.6934E-02_JPRB/)
KAO( :, 4,12, 3) = (/&
&1.3670E-04_JPRB,1.3799E-04_JPRB,1.2856E-04_JPRB,1.1584E-04_JPRB,1.0096E-04_JPRB,8.4392E-05_JPRB,&
&6.5619E-05_JPRB,4.3295E-05_JPRB,5.4726E-02_JPRB/)
KAO( :, 5,12, 3) = (/&
&1.4329E-04_JPRB,1.4852E-04_JPRB,1.3961E-04_JPRB,1.2668E-04_JPRB,1.1132E-04_JPRB,9.3911E-05_JPRB,&
&7.3404E-05_JPRB,4.8588E-05_JPRB,5.3331E-02_JPRB/)
KAO( :, 1,13, 3) = (/&
&1.1744E-04_JPRB,1.1063E-04_JPRB,9.9314E-05_JPRB,8.6900E-05_JPRB,7.3501E-05_JPRB,5.9317E-05_JPRB,&
&4.4384E-05_JPRB,3.1424E-05_JPRB,5.4422E-02_JPRB/)
KAO( :, 2,13, 3) = (/&
&1.2299E-04_JPRB,1.1743E-04_JPRB,1.0678E-04_JPRB,9.4184E-05_JPRB,8.0294E-05_JPRB,6.5353E-05_JPRB,&
&4.9396E-05_JPRB,3.3221E-05_JPRB,5.1307E-02_JPRB/)
KAO( :, 3,13, 3) = (/&
&1.2905E-04_JPRB,1.2561E-04_JPRB,1.1534E-04_JPRB,1.0249E-04_JPRB,8.8036E-05_JPRB,7.2203E-05_JPRB,&
&5.4868E-05_JPRB,3.5562E-05_JPRB,4.8781E-02_JPRB/)
KAO( :, 4,13, 3) = (/&
&1.3536E-04_JPRB,1.3482E-04_JPRB,1.2477E-04_JPRB,1.1168E-04_JPRB,9.6529E-05_JPRB,7.9711E-05_JPRB,&
&6.1059E-05_JPRB,3.9213E-05_JPRB,4.6937E-02_JPRB/)
KAO( :, 5,13, 3) = (/&
&1.4199E-04_JPRB,1.4483E-04_JPRB,1.3499E-04_JPRB,1.2149E-04_JPRB,1.0563E-04_JPRB,8.7931E-05_JPRB,&
&6.7855E-05_JPRB,4.4192E-05_JPRB,4.5940E-02_JPRB/)
KAO( :, 1, 1, 4) = (/&
&5.9013E-04_JPRB,7.0245E-04_JPRB,7.3164E-04_JPRB,7.2179E-04_JPRB,6.8573E-04_JPRB,6.2586E-04_JPRB,&
&5.3565E-04_JPRB,3.8435E-04_JPRB,2.9201E-04_JPRB/)
KAO( :, 2, 1, 4) = (/&
&6.1984E-04_JPRB,7.6785E-04_JPRB,8.0887E-04_JPRB,8.0653E-04_JPRB,7.7581E-04_JPRB,7.1523E-04_JPRB,&
&6.1584E-04_JPRB,4.5439E-04_JPRB,3.5568E-04_JPRB/)
KAO( :, 3, 1, 4) = (/&
&6.5388E-04_JPRB,8.3863E-04_JPRB,8.9298E-04_JPRB,9.0379E-04_JPRB,8.7674E-04_JPRB,8.1428E-04_JPRB,&
&7.0393E-04_JPRB,5.3376E-04_JPRB,4.3604E-04_JPRB/)
KAO( :, 4, 1, 4) = (/&
&6.9104E-04_JPRB,9.1397E-04_JPRB,9.8676E-04_JPRB,1.0109E-03_JPRB,9.8675E-04_JPRB,9.2127E-04_JPRB,&
&8.0143E-04_JPRB,6.2432E-04_JPRB,5.3306E-04_JPRB/)
KAO( :, 5, 1, 4) = (/&
&7.3106E-04_JPRB,9.9279E-04_JPRB,1.0893E-03_JPRB,1.1247E-03_JPRB,1.1052E-03_JPRB,1.0359E-03_JPRB,&
&9.1211E-04_JPRB,7.2751E-04_JPRB,6.4803E-04_JPRB/)
KAO( :, 1, 2, 4) = (/&
&5.1187E-04_JPRB,6.0705E-04_JPRB,6.2677E-04_JPRB,6.1236E-04_JPRB,5.7704E-04_JPRB,5.2457E-04_JPRB,&
&4.4788E-04_JPRB,3.2136E-04_JPRB,2.7655E-04_JPRB/)
KAO( :, 2, 2, 4) = (/&
&5.4076E-04_JPRB,6.6478E-04_JPRB,6.9333E-04_JPRB,6.8548E-04_JPRB,6.5547E-04_JPRB,6.0224E-04_JPRB,&
&5.1801E-04_JPRB,3.7991E-04_JPRB,3.3492E-04_JPRB/)
KAO( :, 3, 2, 4) = (/&
&5.7303E-04_JPRB,7.2753E-04_JPRB,7.6688E-04_JPRB,7.7045E-04_JPRB,7.4435E-04_JPRB,6.8770E-04_JPRB,&
&5.9408E-04_JPRB,4.4774E-04_JPRB,4.0831E-04_JPRB/)
KAO( :, 4, 2, 4) = (/&
&6.0856E-04_JPRB,7.9562E-04_JPRB,8.4981E-04_JPRB,8.6454E-04_JPRB,8.3973E-04_JPRB,7.7971E-04_JPRB,&
&6.7967E-04_JPRB,5.2619E-04_JPRB,4.9767E-04_JPRB/)
KAO( :, 5, 2, 4) = (/&
&6.4744E-04_JPRB,8.6751E-04_JPRB,9.4144E-04_JPRB,9.6462E-04_JPRB,9.4185E-04_JPRB,8.7987E-04_JPRB,&
&7.7686E-04_JPRB,6.1504E-04_JPRB,6.0360E-04_JPRB/)
KAO( :, 1, 3, 4) = (/&
&4.3480E-04_JPRB,5.0939E-04_JPRB,5.1971E-04_JPRB,5.0362E-04_JPRB,4.7059E-04_JPRB,4.2466E-04_JPRB,&
&3.6011E-04_JPRB,2.5628E-04_JPRB,3.1317E-04_JPRB/)
KAO( :, 2, 3, 4) = (/&
&4.6125E-04_JPRB,5.5965E-04_JPRB,5.7749E-04_JPRB,5.6507E-04_JPRB,5.3629E-04_JPRB,4.9048E-04_JPRB,&
&4.1883E-04_JPRB,3.0535E-04_JPRB,3.6323E-04_JPRB/)
KAO( :, 3, 3, 4) = (/&
&4.9122E-04_JPRB,6.1523E-04_JPRB,6.4073E-04_JPRB,6.3706E-04_JPRB,6.1179E-04_JPRB,5.6184E-04_JPRB,&
&4.8250E-04_JPRB,3.6188E-04_JPRB,4.3066E-04_JPRB/)
KAO( :, 4, 3, 4) = (/&
&5.2513E-04_JPRB,6.7573E-04_JPRB,7.1288E-04_JPRB,7.1737E-04_JPRB,6.9265E-04_JPRB,6.3867E-04_JPRB,&
&5.5339E-04_JPRB,4.2777E-04_JPRB,5.1587E-04_JPRB/)
KAO( :, 5, 3, 4) = (/&
&5.6222E-04_JPRB,7.4076E-04_JPRB,7.9225E-04_JPRB,8.0338E-04_JPRB,7.7867E-04_JPRB,7.2219E-04_JPRB,&
&6.3593E-04_JPRB,5.0139E-04_JPRB,6.1836E-04_JPRB/)
KAO( :, 1, 4, 4) = (/&
&3.6976E-04_JPRB,4.2501E-04_JPRB,4.2710E-04_JPRB,4.1037E-04_JPRB,3.7995E-04_JPRB,3.3967E-04_JPRB,&
&2.8574E-04_JPRB,1.9979E-04_JPRB,4.2399E-04_JPRB/)
KAO( :, 2, 4, 4) = (/&
&3.9327E-04_JPRB,4.6788E-04_JPRB,4.7574E-04_JPRB,4.6106E-04_JPRB,4.3415E-04_JPRB,3.9414E-04_JPRB,&
&3.3408E-04_JPRB,2.4080E-04_JPRB,4.6262E-04_JPRB/)
KAO( :, 3, 4, 4) = (/&
&4.2065E-04_JPRB,5.1570E-04_JPRB,5.3050E-04_JPRB,5.2117E-04_JPRB,4.9670E-04_JPRB,4.5372E-04_JPRB,&
&3.8660E-04_JPRB,2.8761E-04_JPRB,5.2104E-04_JPRB/)
KAO( :, 4, 4, 4) = (/&
&4.5210E-04_JPRB,5.6870E-04_JPRB,5.9248E-04_JPRB,5.8890E-04_JPRB,5.6466E-04_JPRB,5.1691E-04_JPRB,&
&4.4461E-04_JPRB,3.4096E-04_JPRB,6.0030E-04_JPRB/)
KAO( :, 5, 4, 4) = (/&
&4.8655E-04_JPRB,6.2705E-04_JPRB,6.6097E-04_JPRB,6.6244E-04_JPRB,6.3703E-04_JPRB,5.8594E-04_JPRB,&
&5.1212E-04_JPRB,4.0060E-04_JPRB,6.9904E-04_JPRB/)
KAO( :, 1, 5, 4) = (/&
&3.1593E-04_JPRB,3.5529E-04_JPRB,3.5086E-04_JPRB,3.3304E-04_JPRB,3.0635E-04_JPRB,2.7113E-04_JPRB,&
&2.2537E-04_JPRB,1.5625E-04_JPRB,6.0940E-04_JPRB/)
KAO( :, 2, 5, 4) = (/&
&3.3652E-04_JPRB,3.9074E-04_JPRB,3.9127E-04_JPRB,3.7581E-04_JPRB,3.5016E-04_JPRB,3.1504E-04_JPRB,&
&2.6515E-04_JPRB,1.8777E-04_JPRB,6.3592E-04_JPRB/)
KAO( :, 3, 5, 4) = (/&
&3.6116E-04_JPRB,4.3121E-04_JPRB,4.3815E-04_JPRB,4.2535E-04_JPRB,4.0138E-04_JPRB,3.6428E-04_JPRB,&
&3.0823E-04_JPRB,2.2541E-04_JPRB,6.8312E-04_JPRB/)
KAO( :, 4, 5, 4) = (/&
&3.8955E-04_JPRB,4.7734E-04_JPRB,4.9105E-04_JPRB,4.8184E-04_JPRB,4.5822E-04_JPRB,4.1678E-04_JPRB,&
&3.5536E-04_JPRB,2.6865E-04_JPRB,7.5327E-04_JPRB/)
KAO( :, 5, 5, 4) = (/&
&4.2054E-04_JPRB,5.2915E-04_JPRB,5.4965E-04_JPRB,5.4417E-04_JPRB,5.1930E-04_JPRB,4.7415E-04_JPRB,&
&4.0964E-04_JPRB,3.1712E-04_JPRB,8.4523E-04_JPRB/)
KAO( :, 1, 6, 4) = (/&
&2.6945E-04_JPRB,2.9554E-04_JPRB,2.8676E-04_JPRB,2.6850E-04_JPRB,2.4490E-04_JPRB,2.1445E-04_JPRB,&
&1.7595E-04_JPRB,1.2228E-04_JPRB,9.0714E-04_JPRB/)
KAO( :, 2, 6, 4) = (/&
&2.8703E-04_JPRB,3.2438E-04_JPRB,3.1923E-04_JPRB,3.0362E-04_JPRB,2.8005E-04_JPRB,2.4944E-04_JPRB,&
&2.0785E-04_JPRB,1.4399E-04_JPRB,9.1574E-04_JPRB/)
KAO( :, 3, 6, 4) = (/&
&3.0826E-04_JPRB,3.5756E-04_JPRB,3.5816E-04_JPRB,3.4447E-04_JPRB,3.2155E-04_JPRB,2.8951E-04_JPRB,&
&2.4288E-04_JPRB,1.7387E-04_JPRB,9.4950E-04_JPRB/)
KAO( :, 4, 6, 4) = (/&
&3.3280E-04_JPRB,3.9668E-04_JPRB,4.0334E-04_JPRB,3.9114E-04_JPRB,3.6863E-04_JPRB,3.3278E-04_JPRB,&
&2.8109E-04_JPRB,2.0888E-04_JPRB,1.0075E-03_JPRB/)
KAO( :, 5, 6, 4) = (/&
&3.5966E-04_JPRB,4.4146E-04_JPRB,4.5343E-04_JPRB,4.4331E-04_JPRB,4.1953E-04_JPRB,3.7997E-04_JPRB,&
&3.2403E-04_JPRB,2.4762E-04_JPRB,1.0914E-03_JPRB/)
KAO( :, 1, 7, 4) = (/&
&2.3611E-04_JPRB,2.5013E-04_JPRB,2.3826E-04_JPRB,2.1972E-04_JPRB,1.9747E-04_JPRB,1.7091E-04_JPRB,&
&1.3828E-04_JPRB,9.7674E-05_JPRB,1.5029E-03_JPRB/)
KAO( :, 2, 7, 4) = (/&
&2.5027E-04_JPRB,2.7295E-04_JPRB,2.6351E-04_JPRB,2.4730E-04_JPRB,2.2544E-04_JPRB,1.9811E-04_JPRB,&
&1.6292E-04_JPRB,1.1091E-04_JPRB,1.4865E-03_JPRB/)
KAO( :, 3, 7, 4) = (/&
&2.6744E-04_JPRB,2.9951E-04_JPRB,2.9483E-04_JPRB,2.8048E-04_JPRB,2.5858E-04_JPRB,2.3043E-04_JPRB,&
&1.9141E-04_JPRB,1.3387E-04_JPRB,1.5029E-03_JPRB/)
KAO( :, 4, 7, 4) = (/&
&2.8737E-04_JPRB,3.3140E-04_JPRB,3.3216E-04_JPRB,3.1861E-04_JPRB,2.9712E-04_JPRB,2.6612E-04_JPRB,&
&2.2227E-04_JPRB,1.6157E-04_JPRB,1.5533E-03_JPRB/)
KAO( :, 5, 7, 4) = (/&
&3.0980E-04_JPRB,3.6893E-04_JPRB,3.7432E-04_JPRB,3.6173E-04_JPRB,3.3923E-04_JPRB,3.0465E-04_JPRB,&
&2.5628E-04_JPRB,1.9217E-04_JPRB,1.6348E-03_JPRB/)
KAO( :, 1, 8, 4) = (/&
&2.2652E-04_JPRB,2.2848E-04_JPRB,2.1284E-04_JPRB,1.9191E-04_JPRB,1.6879E-04_JPRB,1.4336E-04_JPRB,&
&1.1285E-04_JPRB,7.9764E-05_JPRB,3.0781E-03_JPRB/)
KAO( :, 2, 8, 4) = (/&
&2.3707E-04_JPRB,2.4545E-04_JPRB,2.3111E-04_JPRB,2.1207E-04_JPRB,1.8962E-04_JPRB,1.6330E-04_JPRB,&
&1.3129E-04_JPRB,8.8046E-05_JPRB,3.0098E-03_JPRB/)
KAO( :, 3, 8, 4) = (/&
&2.4991E-04_JPRB,2.6528E-04_JPRB,2.5454E-04_JPRB,2.3750E-04_JPRB,2.1491E-04_JPRB,1.8797E-04_JPRB,&
&1.5356E-04_JPRB,1.0513E-04_JPRB,2.9995E-03_JPRB/)
KAO( :, 4, 8, 4) = (/&
&2.6517E-04_JPRB,2.8955E-04_JPRB,2.8339E-04_JPRB,2.6733E-04_JPRB,2.4488E-04_JPRB,2.1619E-04_JPRB,&
&1.7792E-04_JPRB,1.2592E-04_JPRB,3.0451E-03_JPRB/)
KAO( :, 5, 8, 4) = (/&
&2.8248E-04_JPRB,3.1914E-04_JPRB,3.1724E-04_JPRB,3.0164E-04_JPRB,2.7867E-04_JPRB,2.4743E-04_JPRB,&
&2.0485E-04_JPRB,1.4978E-04_JPRB,3.1535E-03_JPRB/)
KAO( :, 1, 9, 4) = (/&
&2.3338E-04_JPRB,2.2637E-04_JPRB,2.0631E-04_JPRB,1.8248E-04_JPRB,1.5663E-04_JPRB,1.2940E-04_JPRB,&
&9.8919E-05_JPRB,6.6772E-05_JPRB,1.1981E-02_JPRB/)
KAO( :, 2, 9, 4) = (/&
&2.4198E-04_JPRB,2.3910E-04_JPRB,2.1989E-04_JPRB,1.9677E-04_JPRB,1.7190E-04_JPRB,1.4401E-04_JPRB,&
&1.1186E-04_JPRB,7.2859E-05_JPRB,1.1621E-02_JPRB/)
KAO( :, 3, 9, 4) = (/&
&2.5171E-04_JPRB,2.5396E-04_JPRB,2.3686E-04_JPRB,2.1562E-04_JPRB,1.9038E-04_JPRB,1.6141E-04_JPRB,&
&1.2789E-04_JPRB,8.4203E-05_JPRB,1.1443E-02_JPRB/)
KAO( :, 4, 9, 4) = (/&
&2.6331E-04_JPRB,2.7176E-04_JPRB,2.5835E-04_JPRB,2.3792E-04_JPRB,2.1195E-04_JPRB,1.8205E-04_JPRB,&
&1.4597E-04_JPRB,9.9793E-05_JPRB,1.1469E-02_JPRB/)
KAO( :, 5, 9, 4) = (/&
&2.7657E-04_JPRB,2.9387E-04_JPRB,2.8372E-04_JPRB,2.6346E-04_JPRB,2.3692E-04_JPRB,2.0548E-04_JPRB,&
&1.6638E-04_JPRB,1.1782E-04_JPRB,1.1707E-02_JPRB/)
KAO( :, 1,10, 4) = (/&
&2.4954E-04_JPRB,2.3620E-04_JPRB,2.1260E-04_JPRB,1.8570E-04_JPRB,1.5704E-04_JPRB,1.2663E-04_JPRB,&
&9.4550E-05_JPRB,5.8858E-05_JPRB,5.2756E-02_JPRB/)
KAO( :, 2,10, 4) = (/&
&2.5766E-04_JPRB,2.4800E-04_JPRB,2.2452E-04_JPRB,1.9756E-04_JPRB,1.6882E-04_JPRB,1.3823E-04_JPRB,&
&1.0447E-04_JPRB,6.4244E-05_JPRB,5.0947E-02_JPRB/)
KAO( :, 3,10, 4) = (/&
&2.6638E-04_JPRB,2.6038E-04_JPRB,2.3824E-04_JPRB,2.1240E-04_JPRB,1.8367E-04_JPRB,1.5156E-04_JPRB,&
&1.1609E-04_JPRB,7.2825E-05_JPRB,5.0037E-02_JPRB/)
KAO( :, 4,10, 4) = (/&
&2.7598E-04_JPRB,2.7501E-04_JPRB,2.5538E-04_JPRB,2.3010E-04_JPRB,2.0028E-04_JPRB,1.6662E-04_JPRB,&
&1.2905E-04_JPRB,8.4471E-05_JPRB,5.0181E-02_JPRB/)
KAO( :, 5,10, 4) = (/&
&2.8718E-04_JPRB,2.9275E-04_JPRB,2.7541E-04_JPRB,2.4987E-04_JPRB,2.1867E-04_JPRB,1.8373E-04_JPRB,&
&1.4422E-04_JPRB,9.7498E-05_JPRB,5.1335E-02_JPRB/)
KAO( :, 1,11, 4) = (/&
&2.6411E-04_JPRB,2.4710E-04_JPRB,2.2075E-04_JPRB,1.9143E-04_JPRB,1.6059E-04_JPRB,1.2809E-04_JPRB,&
&9.4145E-05_JPRB,5.5264E-05_JPRB,7.9299E-02_JPRB/)
KAO( :, 2,11, 4) = (/&
&2.7210E-04_JPRB,2.5809E-04_JPRB,2.3159E-04_JPRB,2.0221E-04_JPRB,1.7108E-04_JPRB,1.3827E-04_JPRB,&
&1.0265E-04_JPRB,6.0771E-05_JPRB,7.7122E-02_JPRB/)
KAO( :, 3,11, 4) = (/&
&2.8014E-04_JPRB,2.6895E-04_JPRB,2.4355E-04_JPRB,2.1491E-04_JPRB,1.8365E-04_JPRB,1.4942E-04_JPRB,&
&1.1181E-04_JPRB,6.9122E-05_JPRB,7.6765E-02_JPRB/)
KAO( :, 4,11, 4) = (/&
&2.8881E-04_JPRB,2.8113E-04_JPRB,2.5786E-04_JPRB,2.2946E-04_JPRB,1.9727E-04_JPRB,1.6160E-04_JPRB,&
&1.2257E-04_JPRB,7.8465E-05_JPRB,7.8124E-02_JPRB/)
KAO( :, 5,11, 4) = (/&
&2.9828E-04_JPRB,2.9581E-04_JPRB,2.7411E-04_JPRB,2.4589E-04_JPRB,2.1291E-04_JPRB,1.7587E-04_JPRB,&
&1.3594E-04_JPRB,8.9600E-05_JPRB,8.1170E-02_JPRB/)
KAO( :, 1,12, 4) = (/&
&2.5900E-04_JPRB,2.4054E-04_JPRB,2.1383E-04_JPRB,1.8455E-04_JPRB,1.5406E-04_JPRB,1.2218E-04_JPRB,&
&8.8914E-05_JPRB,5.0392E-05_JPRB,8.6490E-02_JPRB/)
KAO( :, 2,12, 4) = (/&
&2.6587E-04_JPRB,2.4971E-04_JPRB,2.2287E-04_JPRB,1.9390E-04_JPRB,1.6307E-04_JPRB,1.3059E-04_JPRB,&
&9.5693E-05_JPRB,5.6200E-05_JPRB,8.4739E-02_JPRB/)
KAO( :, 3,12, 4) = (/&
&2.7262E-04_JPRB,2.5871E-04_JPRB,2.3314E-04_JPRB,2.0445E-04_JPRB,1.7328E-04_JPRB,1.3985E-04_JPRB,&
&1.0369E-04_JPRB,6.3281E-05_JPRB,8.5196E-02_JPRB/)
KAO( :, 4,12, 4) = (/&
&2.7987E-04_JPRB,2.6889E-04_JPRB,2.4524E-04_JPRB,2.1669E-04_JPRB,1.8519E-04_JPRB,1.5064E-04_JPRB,&
&1.1324E-04_JPRB,7.1445E-05_JPRB,8.7799E-02_JPRB/)
KAO( :, 5,12, 4) = (/&
&2.8782E-04_JPRB,2.8193E-04_JPRB,2.5958E-04_JPRB,2.3156E-04_JPRB,1.9937E-04_JPRB,1.6355E-04_JPRB,&
&1.2524E-04_JPRB,8.1256E-05_JPRB,9.2236E-02_JPRB/)
KAO( :, 1,13, 4) = (/&
&2.5778E-04_JPRB,2.3735E-04_JPRB,2.0980E-04_JPRB,1.8003E-04_JPRB,1.4941E-04_JPRB,1.1772E-04_JPRB,&
&8.4515E-05_JPRB,4.7447E-05_JPRB,7.6105E-02_JPRB/)
KAO( :, 2,13, 4) = (/&
&2.6333E-04_JPRB,2.4457E-04_JPRB,2.1672E-04_JPRB,1.8743E-04_JPRB,1.5665E-04_JPRB,1.2434E-04_JPRB,&
&9.0194E-05_JPRB,5.2576E-05_JPRB,7.5229E-02_JPRB/)
KAO( :, 3,13, 4) = (/&
&2.6832E-04_JPRB,2.5148E-04_JPRB,2.2532E-04_JPRB,1.9639E-04_JPRB,1.6531E-04_JPRB,1.3247E-04_JPRB,&
&9.7365E-05_JPRB,5.8706E-05_JPRB,7.6481E-02_JPRB/)
KAO( :, 4,13, 4) = (/&
&2.7426E-04_JPRB,2.6072E-04_JPRB,2.3633E-04_JPRB,2.0753E-04_JPRB,1.7633E-04_JPRB,1.4258E-04_JPRB,&
&1.0613E-04_JPRB,6.5878E-05_JPRB,7.9777E-02_JPRB/)
KAO( :, 5,13, 4) = (/&
&2.8141E-04_JPRB,2.7288E-04_JPRB,2.4996E-04_JPRB,2.2169E-04_JPRB,1.8986E-04_JPRB,1.5488E-04_JPRB,&
&1.1727E-04_JPRB,7.4750E-05_JPRB,8.4864E-02_JPRB/)
KAO( :, 1, 1, 5) = (/&
&1.7137E-03_JPRB,1.6965E-03_JPRB,1.6056E-03_JPRB,1.4623E-03_JPRB,1.2864E-03_JPRB,1.0870E-03_JPRB,&
&8.6301E-04_JPRB,6.0966E-04_JPRB,4.4058E-04_JPRB/)
KAO( :, 2, 1, 5) = (/&
&1.7704E-03_JPRB,1.7874E-03_JPRB,1.7001E-03_JPRB,1.5551E-03_JPRB,1.3819E-03_JPRB,1.1838E-03_JPRB,&
&9.5980E-04_JPRB,7.0743E-04_JPRB,5.5098E-04_JPRB/)
KAO( :, 3, 1, 5) = (/&
&1.8247E-03_JPRB,1.8784E-03_JPRB,1.8001E-03_JPRB,1.6592E-03_JPRB,1.4952E-03_JPRB,1.3012E-03_JPRB,&
&1.0846E-03_JPRB,8.2466E-04_JPRB,6.8654E-04_JPRB/)
KAO( :, 4, 1, 5) = (/&
&1.8807E-03_JPRB,1.9750E-03_JPRB,1.9078E-03_JPRB,1.7834E-03_JPRB,1.6310E-03_JPRB,1.4483E-03_JPRB,&
&1.2338E-03_JPRB,9.6045E-04_JPRB,8.5044E-04_JPRB/)
KAO( :, 5, 1, 5) = (/&
&1.9386E-03_JPRB,2.0802E-03_JPRB,2.0314E-03_JPRB,1.9311E-03_JPRB,1.7973E-03_JPRB,1.6224E-03_JPRB,&
&1.4041E-03_JPRB,1.1149E-03_JPRB,1.0435E-03_JPRB/)
KAO( :, 1, 2, 5) = (/&
&1.5019E-03_JPRB,1.4891E-03_JPRB,1.4050E-03_JPRB,1.2791E-03_JPRB,1.1249E-03_JPRB,9.4471E-04_JPRB,&
&7.4490E-04_JPRB,5.1735E-04_JPRB,4.2795E-04_JPRB/)
KAO( :, 2, 2, 5) = (/&
&1.5481E-03_JPRB,1.5670E-03_JPRB,1.4869E-03_JPRB,1.3627E-03_JPRB,1.2086E-03_JPRB,1.0310E-03_JPRB,&
&8.2991E-04_JPRB,6.0449E-04_JPRB,5.2985E-04_JPRB/)
KAO( :, 3, 2, 5) = (/&
&1.5955E-03_JPRB,1.6464E-03_JPRB,1.5764E-03_JPRB,1.4549E-03_JPRB,1.3083E-03_JPRB,1.1370E-03_JPRB,&
&9.3949E-04_JPRB,7.0586E-04_JPRB,6.5574E-04_JPRB/)
KAO( :, 4, 2, 5) = (/&
&1.6449E-03_JPRB,1.7318E-03_JPRB,1.6759E-03_JPRB,1.5663E-03_JPRB,1.4318E-03_JPRB,1.2693E-03_JPRB,&
&1.0703E-03_JPRB,8.2289E-04_JPRB,8.0944E-04_JPRB/)
KAO( :, 5, 2, 5) = (/&
&1.6963E-03_JPRB,1.8275E-03_JPRB,1.7899E-03_JPRB,1.7018E-03_JPRB,1.5826E-03_JPRB,1.4255E-03_JPRB,&
&1.2208E-03_JPRB,9.5732E-04_JPRB,9.9376E-04_JPRB/)
KAO( :, 1, 3, 5) = (/&
&1.2946E-03_JPRB,1.2789E-03_JPRB,1.2021E-03_JPRB,1.0905E-03_JPRB,9.5582E-04_JPRB,7.9856E-04_JPRB,&
&6.2419E-04_JPRB,4.2060E-04_JPRB,4.8597E-04_JPRB/)
KAO( :, 2, 3, 5) = (/&
&1.3334E-03_JPRB,1.3450E-03_JPRB,1.2700E-03_JPRB,1.1621E-03_JPRB,1.0260E-03_JPRB,8.6938E-04_JPRB,&
&6.9581E-04_JPRB,4.9333E-04_JPRB,5.8939E-04_JPRB/)
KAO( :, 3, 3, 5) = (/&
&1.3735E-03_JPRB,1.4122E-03_JPRB,1.3468E-03_JPRB,1.2420E-03_JPRB,1.1098E-03_JPRB,9.5952E-04_JPRB,&
&7.8793E-04_JPRB,5.7747E-04_JPRB,7.1825E-04_JPRB/)
KAO( :, 4, 3, 5) = (/&
&1.4149E-03_JPRB,1.4860E-03_JPRB,1.4348E-03_JPRB,1.3382E-03_JPRB,1.2156E-03_JPRB,1.0728E-03_JPRB,&
&8.9873E-04_JPRB,6.7617E-04_JPRB,8.7351E-04_JPRB/)
KAO( :, 5, 3, 5) = (/&
&1.4592E-03_JPRB,1.5699E-03_JPRB,1.5381E-03_JPRB,1.4563E-03_JPRB,1.3459E-03_JPRB,1.2082E-03_JPRB,&
&1.0276E-03_JPRB,7.9087E-04_JPRB,1.0595E-03_JPRB/)
KAO( :, 1, 4, 5) = (/&
&1.1144E-03_JPRB,1.0934E-03_JPRB,1.0240E-03_JPRB,9.2287E-04_JPRB,8.0421E-04_JPRB,6.6808E-04_JPRB,&
&5.1730E-04_JPRB,3.3813E-04_JPRB,6.1462E-04_JPRB/)
KAO( :, 2, 4, 5) = (/&
&1.1469E-03_JPRB,1.1488E-03_JPRB,1.0800E-03_JPRB,9.8253E-04_JPRB,8.6268E-04_JPRB,7.2497E-04_JPRB,&
&5.7476E-04_JPRB,3.9764E-04_JPRB,7.1472E-04_JPRB/)
KAO( :, 3, 4, 5) = (/&
&1.1797E-03_JPRB,1.2067E-03_JPRB,1.1428E-03_JPRB,1.0501E-03_JPRB,9.3226E-04_JPRB,7.9746E-04_JPRB,&
&6.5011E-04_JPRB,4.6691E-04_JPRB,8.5032E-04_JPRB/)
KAO( :, 4, 4, 5) = (/&
&1.2139E-03_JPRB,1.2682E-03_JPRB,1.2174E-03_JPRB,1.1319E-03_JPRB,1.0196E-03_JPRB,8.9229E-04_JPRB,&
&7.4246E-04_JPRB,5.4839E-04_JPRB,1.0185E-03_JPRB/)
KAO( :, 5, 4, 5) = (/&
&1.2525E-03_JPRB,1.3386E-03_JPRB,1.3069E-03_JPRB,1.2320E-03_JPRB,1.1286E-03_JPRB,1.0072E-03_JPRB,&
&8.5027E-04_JPRB,6.4344E-04_JPRB,1.2190E-03_JPRB/)
KAO( :, 1, 5, 5) = (/&
&9.5403E-04_JPRB,9.3019E-04_JPRB,8.6917E-04_JPRB,7.7882E-04_JPRB,6.7397E-04_JPRB,5.5681E-04_JPRB,&
&4.2732E-04_JPRB,2.7040E-04_JPRB,8.4167E-04_JPRB/)
KAO( :, 2, 5, 5) = (/&
&9.8163E-04_JPRB,9.7748E-04_JPRB,9.1548E-04_JPRB,8.2676E-04_JPRB,7.2236E-04_JPRB,6.0295E-04_JPRB,&
&4.7188E-04_JPRB,3.1812E-04_JPRB,9.2459E-04_JPRB/)
KAO( :, 3, 5, 5) = (/&
&1.0087E-03_JPRB,1.0268E-03_JPRB,9.6743E-04_JPRB,8.8361E-04_JPRB,7.8023E-04_JPRB,6.6112E-04_JPRB,&
&5.3219E-04_JPRB,3.7543E-04_JPRB,1.0523E-03_JPRB/)
KAO( :, 4, 5, 5) = (/&
&1.0377E-03_JPRB,1.0786E-03_JPRB,1.0288E-03_JPRB,9.5341E-04_JPRB,8.5203E-04_JPRB,7.3754E-04_JPRB,&
&6.0792E-04_JPRB,4.4270E-04_JPRB,1.2261E-03_JPRB/)
KAO( :, 5, 5, 5) = (/&
&1.0724E-03_JPRB,1.1380E-03_JPRB,1.1047E-03_JPRB,1.0358E-03_JPRB,9.4134E-04_JPRB,8.3220E-04_JPRB,&
&6.9728E-04_JPRB,5.2081E-04_JPRB,1.4470E-03_JPRB/)
KAO( :, 1, 6, 5) = (/&
&8.0588E-04_JPRB,7.8134E-04_JPRB,7.2703E-04_JPRB,6.4891E-04_JPRB,5.5742E-04_JPRB,4.5781E-04_JPRB,&
&3.4857E-04_JPRB,2.1150E-04_JPRB,1.1955E-03_JPRB/)
KAO( :, 2, 6, 5) = (/&
&8.2987E-04_JPRB,8.2145E-04_JPRB,7.6654E-04_JPRB,6.8713E-04_JPRB,5.9710E-04_JPRB,4.9603E-04_JPRB,&
&3.8344E-04_JPRB,2.5028E-04_JPRB,1.2644E-03_JPRB/)
KAO( :, 3, 6, 5) = (/&
&8.5260E-04_JPRB,8.6248E-04_JPRB,8.0901E-04_JPRB,7.3393E-04_JPRB,6.4549E-04_JPRB,5.4230E-04_JPRB,&
&4.3028E-04_JPRB,2.9597E-04_JPRB,1.3809E-03_JPRB/)
KAO( :, 4, 6, 5) = (/&
&8.7789E-04_JPRB,9.0633E-04_JPRB,8.5910E-04_JPRB,7.9201E-04_JPRB,7.0399E-04_JPRB,6.0291E-04_JPRB,&
&4.9056E-04_JPRB,3.5045E-04_JPRB,1.5502E-03_JPRB/)
KAO( :, 5, 6, 5) = (/&
&9.0920E-04_JPRB,9.5736E-04_JPRB,9.2249E-04_JPRB,8.6100E-04_JPRB,7.7647E-04_JPRB,6.7926E-04_JPRB,&
&5.6406E-04_JPRB,4.1413E-04_JPRB,1.7775E-03_JPRB/)
KAO( :, 1, 7, 5) = (/&
&6.7718E-04_JPRB,6.5283E-04_JPRB,6.0385E-04_JPRB,5.3746E-04_JPRB,4.5928E-04_JPRB,3.7434E-04_JPRB,&
&2.8222E-04_JPRB,1.6381E-04_JPRB,1.9446E-03_JPRB/)
KAO( :, 2, 7, 5) = (/&
&6.9831E-04_JPRB,6.8657E-04_JPRB,6.3767E-04_JPRB,5.6836E-04_JPRB,4.9039E-04_JPRB,4.0548E-04_JPRB,&
&3.1038E-04_JPRB,1.9535E-04_JPRB,2.0007E-03_JPRB/)
KAO( :, 3, 7, 5) = (/&
&7.1868E-04_JPRB,7.2062E-04_JPRB,6.7244E-04_JPRB,6.0563E-04_JPRB,5.3050E-04_JPRB,4.4299E-04_JPRB,&
&3.4588E-04_JPRB,2.3206E-04_JPRB,2.1166E-03_JPRB/)
KAO( :, 4, 7, 5) = (/&
&7.4125E-04_JPRB,7.5799E-04_JPRB,7.1378E-04_JPRB,6.5339E-04_JPRB,5.7827E-04_JPRB,4.9033E-04_JPRB,&
&3.9327E-04_JPRB,2.7533E-04_JPRB,2.2963E-03_JPRB/)
KAO( :, 5, 7, 5) = (/&
&7.6923E-04_JPRB,8.0202E-04_JPRB,7.6642E-04_JPRB,7.1096E-04_JPRB,6.3687E-04_JPRB,5.5087E-04_JPRB,&
&4.5258E-04_JPRB,3.2683E-04_JPRB,2.5393E-03_JPRB/)
KAO( :, 1, 8, 5) = (/&
&5.7599E-04_JPRB,5.5064E-04_JPRB,5.0518E-04_JPRB,4.4746E-04_JPRB,3.8078E-04_JPRB,3.0749E-04_JPRB,&
&2.2925E-04_JPRB,1.2727E-04_JPRB,4.0446E-03_JPRB/)
KAO( :, 2, 8, 5) = (/&
&5.9400E-04_JPRB,5.7851E-04_JPRB,5.3320E-04_JPRB,4.7317E-04_JPRB,4.0494E-04_JPRB,3.3229E-04_JPRB,&
&2.5224E-04_JPRB,1.5307E-04_JPRB,4.1120E-03_JPRB/)
KAO( :, 3, 8, 5) = (/&
&6.1213E-04_JPRB,6.0695E-04_JPRB,5.6225E-04_JPRB,5.0253E-04_JPRB,4.3721E-04_JPRB,3.6322E-04_JPRB,&
&2.7965E-04_JPRB,1.8169E-04_JPRB,4.2811E-03_JPRB/)
KAO( :, 4, 8, 5) = (/&
&6.3202E-04_JPRB,6.3848E-04_JPRB,5.9649E-04_JPRB,5.4156E-04_JPRB,4.7672E-04_JPRB,4.0069E-04_JPRB,&
&3.1617E-04_JPRB,2.1644E-04_JPRB,4.5447E-03_JPRB/)
KAO( :, 5, 8, 5) = (/&
&6.5665E-04_JPRB,6.7566E-04_JPRB,6.4050E-04_JPRB,5.8944E-04_JPRB,5.2476E-04_JPRB,4.4890E-04_JPRB,&
&3.6328E-04_JPRB,2.5754E-04_JPRB,4.8900E-03_JPRB/)
KAO( :, 1, 9, 5) = (/&
&5.0775E-04_JPRB,4.7779E-04_JPRB,4.3345E-04_JPRB,3.8064E-04_JPRB,3.2167E-04_JPRB,2.5711E-04_JPRB,&
&1.8824E-04_JPRB,1.0074E-04_JPRB,1.6194E-02_JPRB/)
KAO( :, 2, 9, 5) = (/&
&5.2113E-04_JPRB,4.9905E-04_JPRB,4.5480E-04_JPRB,4.0079E-04_JPRB,3.3970E-04_JPRB,2.7482E-04_JPRB,&
&2.0609E-04_JPRB,1.2012E-04_JPRB,1.6408E-02_JPRB/)
KAO( :, 3, 9, 5) = (/&
&5.3522E-04_JPRB,5.2108E-04_JPRB,4.7732E-04_JPRB,4.2276E-04_JPRB,3.6348E-04_JPRB,2.9937E-04_JPRB,&
&2.2764E-04_JPRB,1.4255E-04_JPRB,1.6992E-02_JPRB/)
KAO( :, 4, 9, 5) = (/&
&5.5077E-04_JPRB,5.4517E-04_JPRB,5.0402E-04_JPRB,4.5270E-04_JPRB,3.9497E-04_JPRB,3.2945E-04_JPRB,&
&2.5566E-04_JPRB,1.6981E-04_JPRB,1.7864E-02_JPRB/)
KAO( :, 5, 9, 5) = (/&
&5.6949E-04_JPRB,5.7445E-04_JPRB,5.3893E-04_JPRB,4.9094E-04_JPRB,4.3412E-04_JPRB,3.6760E-04_JPRB,&
&2.9217E-04_JPRB,2.0252E-04_JPRB,1.8952E-02_JPRB/)
KAO( :, 1,10, 5) = (/&
&4.9717E-04_JPRB,4.5696E-04_JPRB,4.0763E-04_JPRB,3.5309E-04_JPRB,2.9433E-04_JPRB,2.3192E-04_JPRB,&
&1.6609E-04_JPRB,8.8589E-05_JPRB,7.4795E-02_JPRB/)
KAO( :, 2,10, 5) = (/&
&5.0423E-04_JPRB,4.7002E-04_JPRB,4.2162E-04_JPRB,3.6653E-04_JPRB,3.0673E-04_JPRB,2.4316E-04_JPRB,&
&1.7817E-04_JPRB,1.0118E-04_JPRB,7.6452E-02_JPRB/)
KAO( :, 3,10, 5) = (/&
&5.1212E-04_JPRB,4.8431E-04_JPRB,4.3650E-04_JPRB,3.8161E-04_JPRB,3.2242E-04_JPRB,2.6059E-04_JPRB,&
&1.9440E-04_JPRB,1.1733E-04_JPRB,7.9783E-02_JPRB/)
KAO( :, 4,10, 5) = (/&
&5.2160E-04_JPRB,5.0030E-04_JPRB,4.5482E-04_JPRB,4.0224E-04_JPRB,3.4538E-04_JPRB,2.8370E-04_JPRB,&
&2.1573E-04_JPRB,1.3763E-04_JPRB,8.4425E-02_JPRB/)
KAO( :, 5,10, 5) = (/&
&5.3403E-04_JPRB,5.2047E-04_JPRB,4.8022E-04_JPRB,4.3074E-04_JPRB,3.7548E-04_JPRB,3.1365E-04_JPRB,&
&2.4302E-04_JPRB,1.6290E-04_JPRB,8.9982E-02_JPRB/)
KAO( :, 1,11, 5) = (/&
&5.0375E-04_JPRB,4.5815E-04_JPRB,4.0474E-04_JPRB,3.4759E-04_JPRB,2.8717E-04_JPRB,2.2431E-04_JPRB,&
&1.5880E-04_JPRB,8.5670E-05_JPRB,1.2034E-01_JPRB/)
KAO( :, 2,11, 5) = (/&
&5.0787E-04_JPRB,4.6747E-04_JPRB,4.1520E-04_JPRB,3.5802E-04_JPRB,2.9753E-04_JPRB,2.3416E-04_JPRB,&
&1.6914E-04_JPRB,9.5910E-05_JPRB,1.2557E-01_JPRB/)
KAO( :, 3,11, 5) = (/&
&5.1316E-04_JPRB,4.7918E-04_JPRB,4.2800E-04_JPRB,3.7201E-04_JPRB,3.1196E-04_JPRB,2.4926E-04_JPRB,&
&1.8340E-04_JPRB,1.0921E-04_JPRB,1.3355E-01_JPRB/)
KAO( :, 4,11, 5) = (/&
&5.2086E-04_JPRB,4.9333E-04_JPRB,4.4531E-04_JPRB,3.9163E-04_JPRB,3.3267E-04_JPRB,2.6993E-04_JPRB,&
&2.0215E-04_JPRB,1.2601E-04_JPRB,1.4382E-01_JPRB/)
KAO( :, 5,11, 5) = (/&
&5.3248E-04_JPRB,5.1252E-04_JPRB,4.7016E-04_JPRB,4.1783E-04_JPRB,3.5976E-04_JPRB,2.9627E-04_JPRB,&
&2.2508E-04_JPRB,1.4674E-04_JPRB,1.5553E-01_JPRB/)
KAO( :, 1,12, 5) = (/&
&4.8240E-04_JPRB,4.3715E-04_JPRB,3.8420E-04_JPRB,3.2860E-04_JPRB,2.7039E-04_JPRB,2.1019E-04_JPRB,&
&1.4796E-04_JPRB,8.0464E-05_JPRB,1.3884E-01_JPRB/)
KAO( :, 2,12, 5) = (/&
&4.8661E-04_JPRB,4.4595E-04_JPRB,3.9410E-04_JPRB,3.3838E-04_JPRB,2.8030E-04_JPRB,2.1996E-04_JPRB,&
&1.5763E-04_JPRB,8.9327E-05_JPRB,1.4656E-01_JPRB/)
KAO( :, 3,12, 5) = (/&
&4.9262E-04_JPRB,4.5710E-04_JPRB,4.0631E-04_JPRB,3.5229E-04_JPRB,2.9463E-04_JPRB,2.3404E-04_JPRB,&
&1.7076E-04_JPRB,1.0107E-04_JPRB,1.5747E-01_JPRB/)
KAO( :, 4,12, 5) = (/&
&5.0100E-04_JPRB,4.7173E-04_JPRB,4.2405E-04_JPRB,3.7163E-04_JPRB,3.1400E-04_JPRB,2.5322E-04_JPRB,&
&1.8793E-04_JPRB,1.1578E-04_JPRB,1.7108E-01_JPRB/)
KAO( :, 5,12, 5) = (/&
&5.1336E-04_JPRB,4.9148E-04_JPRB,4.4858E-04_JPRB,3.9659E-04_JPRB,3.3958E-04_JPRB,2.7759E-04_JPRB,&
&2.0885E-04_JPRB,1.3367E-04_JPRB,1.8676E-01_JPRB/)
KAO( :, 1,13, 5) = (/&
&4.6582E-04_JPRB,4.2090E-04_JPRB,3.6844E-04_JPRB,3.1420E-04_JPRB,2.5774E-04_JPRB,1.9961E-04_JPRB,&
&1.4017E-04_JPRB,7.6735E-05_JPRB,1.3087E-01_JPRB/)
KAO( :, 2,13, 5) = (/&
&4.7086E-04_JPRB,4.2959E-04_JPRB,3.7847E-04_JPRB,3.2415E-04_JPRB,2.6787E-04_JPRB,2.0968E-04_JPRB,&
&1.4924E-04_JPRB,8.4911E-05_JPRB,1.3959E-01_JPRB/)
KAO( :, 3,13, 5) = (/&
&4.7837E-04_JPRB,4.4165E-04_JPRB,3.9141E-04_JPRB,3.3849E-04_JPRB,2.8244E-04_JPRB,2.2337E-04_JPRB,&
&1.6172E-04_JPRB,9.5329E-05_JPRB,1.5133E-01_JPRB/)
KAO( :, 4,13, 5) = (/&
&4.8890E-04_JPRB,4.5706E-04_JPRB,4.0967E-04_JPRB,3.5806E-04_JPRB,3.0129E-04_JPRB,2.4154E-04_JPRB,&
&1.7785E-04_JPRB,1.0830E-04_JPRB,1.6573E-01_JPRB/)
KAO( :, 5,13, 5) = (/&
&5.0378E-04_JPRB,4.7838E-04_JPRB,4.3426E-04_JPRB,3.8267E-04_JPRB,3.2585E-04_JPRB,2.6428E-04_JPRB,&
&1.9742E-04_JPRB,1.2409E-04_JPRB,1.8212E-01_JPRB/)
KAO( :, 1, 1, 6) = (/&
&3.2508E-03_JPRB,2.9778E-03_JPRB,2.7444E-03_JPRB,2.4732E-03_JPRB,2.1617E-03_JPRB,1.8050E-03_JPRB,&
&1.4116E-03_JPRB,9.5646E-04_JPRB,7.5194E-04_JPRB/)
KAO( :, 2, 1, 6) = (/&
&3.2951E-03_JPRB,3.0775E-03_JPRB,2.8725E-03_JPRB,2.6161E-03_JPRB,2.3021E-03_JPRB,1.9458E-03_JPRB,&
&1.5643E-03_JPRB,1.1089E-03_JPRB,9.5011E-04_JPRB/)
KAO( :, 3, 1, 6) = (/&
&3.3739E-03_JPRB,3.2201E-03_JPRB,3.0329E-03_JPRB,2.7889E-03_JPRB,2.4684E-03_JPRB,2.1285E-03_JPRB,&
&1.7492E-03_JPRB,1.2948E-03_JPRB,1.1897E-03_JPRB/)
KAO( :, 4, 1, 6) = (/&
&3.4775E-03_JPRB,3.3896E-03_JPRB,3.2288E-03_JPRB,2.9832E-03_JPRB,2.6770E-03_JPRB,2.3508E-03_JPRB,&
&1.9685E-03_JPRB,1.5165E-03_JPRB,1.4693E-03_JPRB/)
KAO( :, 5, 1, 6) = (/&
&3.6048E-03_JPRB,3.5835E-03_JPRB,3.4508E-03_JPRB,3.2113E-03_JPRB,2.9250E-03_JPRB,2.6127E-03_JPRB,&
&2.2307E-03_JPRB,1.7682E-03_JPRB,1.7887E-03_JPRB/)
KAO( :, 1, 2, 6) = (/&
&2.9479E-03_JPRB,2.7010E-03_JPRB,2.4920E-03_JPRB,2.2328E-03_JPRB,1.9390E-03_JPRB,1.6094E-03_JPRB,&
&1.2398E-03_JPRB,8.2486E-04_JPRB,7.2631E-04_JPRB/)
KAO( :, 2, 2, 6) = (/&
&2.9968E-03_JPRB,2.8020E-03_JPRB,2.6127E-03_JPRB,2.3636E-03_JPRB,2.0690E-03_JPRB,1.7351E-03_JPRB,&
&1.3731E-03_JPRB,9.5550E-04_JPRB,9.1418E-04_JPRB/)
KAO( :, 3, 2, 6) = (/&
&3.0736E-03_JPRB,2.9425E-03_JPRB,2.7649E-03_JPRB,2.5241E-03_JPRB,2.2257E-03_JPRB,1.8987E-03_JPRB,&
&1.5376E-03_JPRB,1.1187E-03_JPRB,1.1471E-03_JPRB/)
KAO( :, 4, 2, 6) = (/&
&3.1728E-03_JPRB,3.1058E-03_JPRB,2.9466E-03_JPRB,2.7114E-03_JPRB,2.4176E-03_JPRB,2.0996E-03_JPRB,&
&1.7359E-03_JPRB,1.3160E-03_JPRB,1.4227E-03_JPRB/)
KAO( :, 5, 2, 6) = (/&
&3.2938E-03_JPRB,3.2890E-03_JPRB,3.1552E-03_JPRB,2.9263E-03_JPRB,2.6481E-03_JPRB,2.3331E-03_JPRB,&
&1.9715E-03_JPRB,1.5406E-03_JPRB,1.7422E-03_JPRB/)
KAO( :, 1, 3, 6) = (/&
&2.6363E-03_JPRB,2.4111E-03_JPRB,2.2160E-03_JPRB,1.9706E-03_JPRB,1.6942E-03_JPRB,1.3925E-03_JPRB,&
&1.0560E-03_JPRB,6.8807E-04_JPRB,8.1595E-04_JPRB/)
KAO( :, 2, 3, 6) = (/&
&2.6810E-03_JPRB,2.5033E-03_JPRB,2.3265E-03_JPRB,2.0848E-03_JPRB,1.8107E-03_JPRB,1.5037E-03_JPRB,&
&1.1662E-03_JPRB,7.9613E-04_JPRB,9.9881E-04_JPRB/)
KAO( :, 3, 3, 6) = (/&
&2.7498E-03_JPRB,2.6291E-03_JPRB,2.4618E-03_JPRB,2.2271E-03_JPRB,1.9564E-03_JPRB,1.6455E-03_JPRB,&
&1.3062E-03_JPRB,9.3309E-04_JPRB,1.2299E-03_JPRB/)
KAO( :, 4, 3, 6) = (/&
&2.8378E-03_JPRB,2.7765E-03_JPRB,2.6213E-03_JPRB,2.3981E-03_JPRB,2.1275E-03_JPRB,1.8208E-03_JPRB,&
&1.4785E-03_JPRB,1.0978E-03_JPRB,1.5182E-03_JPRB/)
KAO( :, 5, 3, 6) = (/&
&2.9436E-03_JPRB,2.9446E-03_JPRB,2.8064E-03_JPRB,2.5984E-03_JPRB,2.3329E-03_JPRB,2.0260E-03_JPRB,&
&1.6822E-03_JPRB,1.2888E-03_JPRB,1.8654E-03_JPRB/)
KAO( :, 1, 4, 6) = (/&
&2.3305E-03_JPRB,2.1270E-03_JPRB,1.9394E-03_JPRB,1.7178E-03_JPRB,1.4629E-03_JPRB,1.1886E-03_JPRB,&
&8.9024E-04_JPRB,5.6452E-04_JPRB,1.0437E-03_JPRB/)
KAO( :, 2, 4, 6) = (/&
&2.3711E-03_JPRB,2.2090E-03_JPRB,2.0410E-03_JPRB,1.8166E-03_JPRB,1.5629E-03_JPRB,1.2867E-03_JPRB,&
&9.8103E-04_JPRB,6.5250E-04_JPRB,1.2371E-03_JPRB/)
KAO( :, 3, 4, 6) = (/&
&2.4284E-03_JPRB,2.3161E-03_JPRB,2.1600E-03_JPRB,1.9393E-03_JPRB,1.6907E-03_JPRB,1.4107E-03_JPRB,&
&1.0981E-03_JPRB,7.6618E-04_JPRB,1.4857E-03_JPRB/)
KAO( :, 4, 4, 6) = (/&
&2.5037E-03_JPRB,2.4445E-03_JPRB,2.2974E-03_JPRB,2.0880E-03_JPRB,1.8467E-03_JPRB,1.5615E-03_JPRB,&
&1.2436E-03_JPRB,9.0463E-04_JPRB,1.7998E-03_JPRB/)
KAO( :, 5, 4, 6) = (/&
&2.5974E-03_JPRB,2.5927E-03_JPRB,2.4566E-03_JPRB,2.2651E-03_JPRB,2.0287E-03_JPRB,1.7391E-03_JPRB,&
&1.4181E-03_JPRB,1.0646E-03_JPRB,2.1898E-03_JPRB/)
KAO( :, 1, 5, 6) = (/&
&2.0361E-03_JPRB,1.8547E-03_JPRB,1.6766E-03_JPRB,1.4795E-03_JPRB,1.2501E-03_JPRB,1.0047E-03_JPRB,&
&7.4302E-04_JPRB,4.6057E-04_JPRB,1.3928E-03_JPRB/)
KAO( :, 2, 5, 6) = (/&
&2.0694E-03_JPRB,1.9228E-03_JPRB,1.7645E-03_JPRB,1.5634E-03_JPRB,1.3341E-03_JPRB,1.0877E-03_JPRB,&
&8.2111E-04_JPRB,5.3228E-04_JPRB,1.6120E-03_JPRB/)
KAO( :, 3, 5, 6) = (/&
&2.1184E-03_JPRB,2.0120E-03_JPRB,1.8652E-03_JPRB,1.6659E-03_JPRB,1.4419E-03_JPRB,1.1971E-03_JPRB,&
&9.1972E-04_JPRB,6.2395E-04_JPRB,1.9022E-03_JPRB/)
KAO( :, 4, 5, 6) = (/&
&2.1844E-03_JPRB,2.1219E-03_JPRB,1.9833E-03_JPRB,1.7902E-03_JPRB,1.5765E-03_JPRB,1.3280E-03_JPRB,&
&1.0415E-03_JPRB,7.3888E-04_JPRB,2.2685E-03_JPRB/)
KAO( :, 5, 5, 6) = (/&
&2.2663E-03_JPRB,2.2517E-03_JPRB,2.1217E-03_JPRB,1.9449E-03_JPRB,1.7373E-03_JPRB,1.4799E-03_JPRB,&
&1.1890E-03_JPRB,8.7483E-04_JPRB,2.7203E-03_JPRB/)
KAO( :, 1, 6, 6) = (/&
&1.7550E-03_JPRB,1.5950E-03_JPRB,1.4324E-03_JPRB,1.2563E-03_JPRB,1.0568E-03_JPRB,8.4088E-04_JPRB,&
&6.1343E-04_JPRB,3.7218E-04_JPRB,1.8822E-03_JPRB/)
KAO( :, 2, 6, 6) = (/&
&1.7806E-03_JPRB,1.6483E-03_JPRB,1.5014E-03_JPRB,1.3260E-03_JPRB,1.1237E-03_JPRB,9.0650E-04_JPRB,&
&6.7793E-04_JPRB,4.3012E-04_JPRB,2.1151E-03_JPRB/)
KAO( :, 3, 6, 6) = (/&
&1.8227E-03_JPRB,1.7227E-03_JPRB,1.5844E-03_JPRB,1.4081E-03_JPRB,1.2080E-03_JPRB,9.9575E-04_JPRB,&
&7.6012E-04_JPRB,5.0351E-04_JPRB,2.4397E-03_JPRB/)
KAO( :, 4, 6, 6) = (/&
&1.8792E-03_JPRB,1.8150E-03_JPRB,1.6849E-03_JPRB,1.5100E-03_JPRB,1.3192E-03_JPRB,1.1065E-03_JPRB,&
&8.6119E-04_JPRB,5.9588E-04_JPRB,2.8694E-03_JPRB/)
KAO( :, 5, 6, 6) = (/&
&1.9487E-03_JPRB,1.9242E-03_JPRB,1.8033E-03_JPRB,1.6413E-03_JPRB,1.4558E-03_JPRB,1.2357E-03_JPRB,&
&9.8340E-04_JPRB,7.0882E-04_JPRB,3.4091E-03_JPRB/)
KAO( :, 1, 7, 6) = (/&
&1.4965E-03_JPRB,1.3571E-03_JPRB,1.2126E-03_JPRB,1.0566E-03_JPRB,8.8614E-04_JPRB,7.0122E-04_JPRB,&
&5.0618E-04_JPRB,3.0014E-04_JPRB,2.8627E-03_JPRB/)
KAO( :, 2, 7, 6) = (/&
&1.5173E-03_JPRB,1.3996E-03_JPRB,1.2672E-03_JPRB,1.1141E-03_JPRB,9.3989E-04_JPRB,7.5155E-04_JPRB,&
&5.5619E-04_JPRB,3.4628E-04_JPRB,3.1242E-03_JPRB/)
KAO( :, 3, 7, 6) = (/&
&1.5535E-03_JPRB,1.4627E-03_JPRB,1.3365E-03_JPRB,1.1831E-03_JPRB,1.0064E-03_JPRB,8.2131E-04_JPRB,&
&6.2417E-04_JPRB,4.0465E-04_JPRB,3.4941E-03_JPRB/)
KAO( :, 4, 7, 6) = (/&
&1.6022E-03_JPRB,1.5406E-03_JPRB,1.4217E-03_JPRB,1.2670E-03_JPRB,1.0965E-03_JPRB,9.1271E-04_JPRB,&
&7.0644E-04_JPRB,4.7877E-04_JPRB,3.9901E-03_JPRB/)
KAO( :, 5, 7, 6) = (/&
&1.6619E-03_JPRB,1.6316E-03_JPRB,1.5215E-03_JPRB,1.3760E-03_JPRB,1.2105E-03_JPRB,1.0220E-03_JPRB,&
&8.0646E-04_JPRB,5.7116E-04_JPRB,4.6499E-03_JPRB/)
KAO( :, 1, 8, 6) = (/&
&1.2713E-03_JPRB,1.1506E-03_JPRB,1.0229E-03_JPRB,8.8637E-04_JPRB,7.3985E-04_JPRB,5.8404E-04_JPRB,&
&4.1869E-04_JPRB,2.4146E-04_JPRB,5.8577E-03_JPRB/)
KAO( :, 2, 8, 6) = (/&
&1.2886E-03_JPRB,1.1855E-03_JPRB,1.0667E-03_JPRB,9.3200E-04_JPRB,7.8398E-04_JPRB,6.2296E-04_JPRB,&
&4.5565E-04_JPRB,2.7881E-04_JPRB,6.2369E-03_JPRB/)
KAO( :, 3, 8, 6) = (/&
&1.3186E-03_JPRB,1.2381E-03_JPRB,1.1243E-03_JPRB,9.9079E-04_JPRB,8.3814E-04_JPRB,6.7723E-04_JPRB,&
&5.1049E-04_JPRB,3.2546E-04_JPRB,6.7543E-03_JPRB/)
KAO( :, 4, 8, 6) = (/&
&1.3600E-03_JPRB,1.3028E-03_JPRB,1.1954E-03_JPRB,1.0612E-03_JPRB,9.1150E-04_JPRB,7.5260E-04_JPRB,&
&5.7914E-04_JPRB,3.8472E-04_JPRB,7.4388E-03_JPRB/)
KAO( :, 5, 8, 6) = (/&
&1.4121E-03_JPRB,1.3805E-03_JPRB,1.2804E-03_JPRB,1.1524E-03_JPRB,1.0064E-03_JPRB,8.4434E-04_JPRB,&
&6.6144E-04_JPRB,4.5882E-04_JPRB,8.3420E-03_JPRB/)
KAO( :, 1, 9, 6) = (/&
&1.0717E-03_JPRB,9.6880E-04_JPRB,8.5692E-04_JPRB,7.3841E-04_JPRB,6.1349E-04_JPRB,4.8265E-04_JPRB,&
&3.4488E-04_JPRB,1.9332E-04_JPRB,2.4273E-02_JPRB/)
KAO( :, 2, 9, 6) = (/&
&1.0856E-03_JPRB,9.9623E-04_JPRB,8.9079E-04_JPRB,7.7337E-04_JPRB,6.4809E-04_JPRB,5.1388E-04_JPRB,&
&3.7203E-04_JPRB,2.2290E-04_JPRB,2.5642E-02_JPRB/)
KAO( :, 3, 9, 6) = (/&
&1.1096E-03_JPRB,1.0377E-03_JPRB,9.3686E-04_JPRB,8.2124E-04_JPRB,6.9314E-04_JPRB,5.5575E-04_JPRB,&
&4.1434E-04_JPRB,2.5972E-04_JPRB,2.7416E-02_JPRB/)
KAO( :, 4, 9, 6) = (/&
&1.1443E-03_JPRB,1.0913E-03_JPRB,9.9449E-04_JPRB,8.7964E-04_JPRB,7.5151E-04_JPRB,6.1540E-04_JPRB,&
&4.6972E-04_JPRB,3.0675E-04_JPRB,2.9667E-02_JPRB/)
KAO( :, 5, 9, 6) = (/&
&1.1902E-03_JPRB,1.1571E-03_JPRB,1.0659E-03_JPRB,9.5531E-04_JPRB,8.2901E-04_JPRB,6.9019E-04_JPRB,&
&5.3796E-04_JPRB,3.6567E-04_JPRB,3.2492E-02_JPRB/)
KAO( :, 1,10, 6) = (/&
&9.1682E-04_JPRB,8.2727E-04_JPRB,7.2786E-04_JPRB,6.2407E-04_JPRB,5.1616E-04_JPRB,4.0448E-04_JPRB,&
&2.8759E-04_JPRB,1.5707E-04_JPRB,1.2096E-01_JPRB/)
KAO( :, 2,10, 6) = (/&
&9.2807E-04_JPRB,8.4772E-04_JPRB,7.5273E-04_JPRB,6.4976E-04_JPRB,5.4191E-04_JPRB,4.2868E-04_JPRB,&
&3.0799E-04_JPRB,1.8018E-04_JPRB,1.2769E-01_JPRB/)
KAO( :, 3,10, 6) = (/&
&9.4733E-04_JPRB,8.8010E-04_JPRB,7.8844E-04_JPRB,6.8649E-04_JPRB,5.7756E-04_JPRB,4.6108E-04_JPRB,&
&3.3990E-04_JPRB,2.0965E-04_JPRB,1.3587E-01_JPRB/)
KAO( :, 4,10, 6) = (/&
&9.7616E-04_JPRB,9.2298E-04_JPRB,8.3457E-04_JPRB,7.3405E-04_JPRB,6.2454E-04_JPRB,5.0775E-04_JPRB,&
&3.8366E-04_JPRB,2.4715E-04_JPRB,1.4598E-01_JPRB/)
KAO( :, 5,10, 6) = (/&
&1.0147E-03_JPRB,9.7749E-04_JPRB,8.9296E-04_JPRB,7.9678E-04_JPRB,6.8754E-04_JPRB,5.6799E-04_JPRB,&
&4.3982E-04_JPRB,2.9475E-04_JPRB,1.5853E-01_JPRB/)
KAO( :, 1,11, 6) = (/&
&8.5061E-04_JPRB,7.6545E-04_JPRB,6.7209E-04_JPRB,5.7435E-04_JPRB,4.7342E-04_JPRB,3.6961E-04_JPRB,&
&2.6119E-04_JPRB,1.4392E-04_JPRB,2.1829E-01_JPRB/)
KAO( :, 2,11, 6) = (/&
&8.6223E-04_JPRB,7.8453E-04_JPRB,6.9368E-04_JPRB,5.9640E-04_JPRB,4.9523E-04_JPRB,3.8977E-04_JPRB,&
&2.7888E-04_JPRB,1.6251E-04_JPRB,2.3198E-01_JPRB/)
KAO( :, 3,11, 6) = (/&
&8.8180E-04_JPRB,8.1321E-04_JPRB,7.2410E-04_JPRB,6.2697E-04_JPRB,5.2544E-04_JPRB,4.1867E-04_JPRB,&
&3.0656E-04_JPRB,1.8726E-04_JPRB,2.4754E-01_JPRB/)
KAO( :, 4,11, 6) = (/&
&9.0901E-04_JPRB,8.5074E-04_JPRB,7.6319E-04_JPRB,6.6771E-04_JPRB,5.6719E-04_JPRB,4.5846E-04_JPRB,&
&3.4374E-04_JPRB,2.1942E-04_JPRB,2.6580E-01_JPRB/)
KAO( :, 5,11, 6) = (/&
&9.4336E-04_JPRB,8.9780E-04_JPRB,8.1395E-04_JPRB,7.2298E-04_JPRB,6.2010E-04_JPRB,5.0948E-04_JPRB,&
&3.9195E-04_JPRB,2.5983E-04_JPRB,2.8833E-01_JPRB/)
KAO( :, 1,12, 6) = (/&
&8.0200E-04_JPRB,7.2122E-04_JPRB,6.3265E-04_JPRB,5.3924E-04_JPRB,4.4340E-04_JPRB,3.4532E-04_JPRB,&
&2.4304E-04_JPRB,1.3437E-04_JPRB,2.6966E-01_JPRB/)
KAO( :, 2,12, 6) = (/&
&8.1599E-04_JPRB,7.4215E-04_JPRB,6.5450E-04_JPRB,5.6136E-04_JPRB,4.6493E-04_JPRB,3.6523E-04_JPRB,&
&2.6103E-04_JPRB,1.5096E-04_JPRB,2.8948E-01_JPRB/)
KAO( :, 3,12, 6) = (/&
&8.3783E-04_JPRB,7.7160E-04_JPRB,6.8467E-04_JPRB,5.9130E-04_JPRB,4.9479E-04_JPRB,3.9390E-04_JPRB,&
&2.8643E-04_JPRB,1.7267E-04_JPRB,3.1014E-01_JPRB/)
KAO( :, 4,12, 6) = (/&
&8.6812E-04_JPRB,8.0949E-04_JPRB,7.2339E-04_JPRB,6.3152E-04_JPRB,5.3506E-04_JPRB,4.2989E-04_JPRB,&
&3.1937E-04_JPRB,2.0004E-04_JPRB,3.3406E-01_JPRB/)
KAO( :, 5,12, 6) = (/&
&9.0435E-04_JPRB,8.5462E-04_JPRB,7.7208E-04_JPRB,6.8293E-04_JPRB,5.8297E-04_JPRB,4.7540E-04_JPRB,&
&3.6088E-04_JPRB,2.3381E-04_JPRB,3.6313E-01_JPRB/)
KAO( :, 1,13, 6) = (/&
&7.8053E-04_JPRB,7.0155E-04_JPRB,6.1461E-04_JPRB,5.2266E-04_JPRB,4.2870E-04_JPRB,3.3288E-04_JPRB,&
&2.3333E-04_JPRB,1.2902E-04_JPRB,2.6881E-01_JPRB/)
KAO( :, 2,13, 6) = (/&
&7.9882E-04_JPRB,7.2653E-04_JPRB,6.3912E-04_JPRB,5.4681E-04_JPRB,4.5162E-04_JPRB,3.5376E-04_JPRB,&
&2.5204E-04_JPRB,1.4416E-04_JPRB,2.9113E-01_JPRB/)
KAO( :, 3,13, 6) = (/&
&8.2403E-04_JPRB,7.5779E-04_JPRB,6.7018E-04_JPRB,5.7745E-04_JPRB,4.8198E-04_JPRB,3.8252E-04_JPRB,&
&2.7644E-04_JPRB,1.6449E-04_JPRB,3.1399E-01_JPRB/)
KAO( :, 4,13, 6) = (/&
&8.5594E-04_JPRB,7.9631E-04_JPRB,7.0954E-04_JPRB,6.1806E-04_JPRB,5.2193E-04_JPRB,4.1790E-04_JPRB,&
&3.0801E-04_JPRB,1.8991E-04_JPRB,3.3908E-01_JPRB/)
KAO( :, 5,13, 6) = (/&
&8.9284E-04_JPRB,8.4070E-04_JPRB,7.5811E-04_JPRB,6.6820E-04_JPRB,5.6955E-04_JPRB,4.6197E-04_JPRB,&
&3.4688E-04_JPRB,2.2019E-04_JPRB,3.6894E-01_JPRB/)
KAO( :, 1, 1, 7) = (/&
&6.0831E-03_JPRB,5.4716E-03_JPRB,4.8761E-03_JPRB,4.3169E-03_JPRB,3.7156E-03_JPRB,3.0689E-03_JPRB,&
&2.3667E-03_JPRB,1.5757E-03_JPRB,1.3430E-03_JPRB/)
KAO( :, 2, 1, 7) = (/&
&6.2160E-03_JPRB,5.6592E-03_JPRB,5.1333E-03_JPRB,4.5937E-03_JPRB,3.9991E-03_JPRB,3.3587E-03_JPRB,&
&2.6257E-03_JPRB,1.8103E-03_JPRB,1.6552E-03_JPRB/)
KAO( :, 3, 1, 7) = (/&
&6.3763E-03_JPRB,5.8806E-03_JPRB,5.4307E-03_JPRB,4.8990E-03_JPRB,4.3331E-03_JPRB,3.6723E-03_JPRB,&
&2.9252E-03_JPRB,2.0812E-03_JPRB,2.0370E-03_JPRB/)
KAO( :, 4, 1, 7) = (/&
&6.5762E-03_JPRB,6.1595E-03_JPRB,5.7556E-03_JPRB,5.2564E-03_JPRB,4.6989E-03_JPRB,4.0150E-03_JPRB,&
&3.2758E-03_JPRB,2.3980E-03_JPRB,2.4986E-03_JPRB/)
KAO( :, 5, 1, 7) = (/&
&6.8177E-03_JPRB,6.4963E-03_JPRB,6.1231E-03_JPRB,5.6619E-03_JPRB,5.0935E-03_JPRB,4.4057E-03_JPRB,&
&3.6750E-03_JPRB,2.7782E-03_JPRB,3.0517E-03_JPRB/)
KAO( :, 1, 2, 7) = (/&
&5.5406E-03_JPRB,4.9770E-03_JPRB,4.4333E-03_JPRB,3.9291E-03_JPRB,3.3714E-03_JPRB,2.7757E-03_JPRB,&
&2.1410E-03_JPRB,1.4066E-03_JPRB,1.3940E-03_JPRB/)
KAO( :, 2, 2, 7) = (/&
&5.6795E-03_JPRB,5.1605E-03_JPRB,4.6810E-03_JPRB,4.1841E-03_JPRB,3.6317E-03_JPRB,3.0411E-03_JPRB,&
&2.3785E-03_JPRB,1.6219E-03_JPRB,1.7125E-03_JPRB/)
KAO( :, 3, 2, 7) = (/&
&5.8479E-03_JPRB,5.3775E-03_JPRB,4.9639E-03_JPRB,4.4697E-03_JPRB,3.9362E-03_JPRB,3.3371E-03_JPRB,&
&2.6519E-03_JPRB,1.8755E-03_JPRB,2.0935E-03_JPRB/)
KAO( :, 4, 2, 7) = (/&
&6.0553E-03_JPRB,5.6506E-03_JPRB,5.2744E-03_JPRB,4.7999E-03_JPRB,4.2764E-03_JPRB,3.6617E-03_JPRB,&
&2.9719E-03_JPRB,2.1746E-03_JPRB,2.5431E-03_JPRB/)
KAO( :, 5, 2, 7) = (/&
&6.2994E-03_JPRB,5.9802E-03_JPRB,5.6290E-03_JPRB,5.1787E-03_JPRB,4.6510E-03_JPRB,4.0342E-03_JPRB,&
&3.3435E-03_JPRB,2.5279E-03_JPRB,3.0760E-03_JPRB/)
KAO( :, 1, 3, 7) = (/&
&4.9647E-03_JPRB,4.4497E-03_JPRB,3.9602E-03_JPRB,3.5016E-03_JPRB,2.9975E-03_JPRB,2.4522E-03_JPRB,&
&1.8688E-03_JPRB,1.2052E-03_JPRB,1.6686E-03_JPRB/)
KAO( :, 2, 3, 7) = (/&
&5.0999E-03_JPRB,4.6210E-03_JPRB,4.1813E-03_JPRB,3.7355E-03_JPRB,3.2261E-03_JPRB,2.6792E-03_JPRB,&
&2.0838E-03_JPRB,1.3908E-03_JPRB,2.0388E-03_JPRB/)
KAO( :, 3, 3, 7) = (/&
&5.2679E-03_JPRB,4.8293E-03_JPRB,4.4423E-03_JPRB,3.9951E-03_JPRB,3.4860E-03_JPRB,2.9419E-03_JPRB,&
&2.3248E-03_JPRB,1.6141E-03_JPRB,2.4914E-03_JPRB/)
KAO( :, 4, 3, 7) = (/&
&5.4762E-03_JPRB,5.0914E-03_JPRB,4.7365E-03_JPRB,4.2903E-03_JPRB,3.7907E-03_JPRB,3.2409E-03_JPRB,&
&2.6074E-03_JPRB,1.8823E-03_JPRB,3.0282E-03_JPRB/)
KAO( :, 5, 3, 7) = (/&
&5.7173E-03_JPRB,5.4006E-03_JPRB,5.0668E-03_JPRB,4.6277E-03_JPRB,4.1360E-03_JPRB,3.5816E-03_JPRB,&
&2.9410E-03_JPRB,2.2019E-03_JPRB,3.6468E-03_JPRB/)
KAO( :, 1, 4, 7) = (/&
&4.4058E-03_JPRB,3.9416E-03_JPRB,3.5104E-03_JPRB,3.0879E-03_JPRB,2.6418E-03_JPRB,2.1472E-03_JPRB,&
&1.6100E-03_JPRB,1.0192E-03_JPRB,2.1860E-03_JPRB/)
KAO( :, 2, 4, 7) = (/&
&4.5309E-03_JPRB,4.0974E-03_JPRB,3.7008E-03_JPRB,3.2995E-03_JPRB,2.8437E-03_JPRB,2.3378E-03_JPRB,&
&1.7928E-03_JPRB,1.1728E-03_JPRB,2.6265E-03_JPRB/)
KAO( :, 3, 4, 7) = (/&
&4.6961E-03_JPRB,4.2954E-03_JPRB,3.9392E-03_JPRB,3.5397E-03_JPRB,3.0713E-03_JPRB,2.5630E-03_JPRB,&
&2.0061E-03_JPRB,1.3611E-03_JPRB,3.1721E-03_JPRB/)
KAO( :, 4, 4, 7) = (/&
&4.8988E-03_JPRB,4.5465E-03_JPRB,4.2146E-03_JPRB,3.8097E-03_JPRB,3.3355E-03_JPRB,2.8256E-03_JPRB,&
&2.2535E-03_JPRB,1.5915E-03_JPRB,3.8341E-03_JPRB/)
KAO( :, 5, 4, 7) = (/&
&5.1310E-03_JPRB,4.8388E-03_JPRB,4.5280E-03_JPRB,4.1140E-03_JPRB,3.6446E-03_JPRB,3.1343E-03_JPRB,&
&2.5481E-03_JPRB,1.8697E-03_JPRB,4.6238E-03_JPRB/)
KAO( :, 1, 5, 7) = (/&
&3.8779E-03_JPRB,3.4634E-03_JPRB,3.0842E-03_JPRB,2.6949E-03_JPRB,2.2979E-03_JPRB,1.8588E-03_JPRB,&
&1.3777E-03_JPRB,8.5534E-04_JPRB,2.9342E-03_JPRB/)
KAO( :, 2, 5, 7) = (/&
&3.9975E-03_JPRB,3.6104E-03_JPRB,3.2535E-03_JPRB,2.8827E-03_JPRB,2.4794E-03_JPRB,2.0228E-03_JPRB,&
&1.5286E-03_JPRB,9.8435E-04_JPRB,3.4742E-03_JPRB/)
KAO( :, 3, 5, 7) = (/&
&4.1529E-03_JPRB,3.7986E-03_JPRB,3.4711E-03_JPRB,3.1033E-03_JPRB,2.6811E-03_JPRB,2.2132E-03_JPRB,&
&1.7129E-03_JPRB,1.1425E-03_JPRB,4.1273E-03_JPRB/)
KAO( :, 4, 5, 7) = (/&
&4.3432E-03_JPRB,4.0329E-03_JPRB,3.7255E-03_JPRB,3.3556E-03_JPRB,2.9159E-03_JPRB,2.4433E-03_JPRB,&
&1.9336E-03_JPRB,1.3357E-03_JPRB,4.9170E-03_JPRB/)
KAO( :, 5, 5, 7) = (/&
&4.5622E-03_JPRB,4.3036E-03_JPRB,4.0154E-03_JPRB,3.6360E-03_JPRB,3.1929E-03_JPRB,2.7222E-03_JPRB,&
&2.1936E-03_JPRB,1.5699E-03_JPRB,5.8667E-03_JPRB/)
KAO( :, 1, 6, 7) = (/&
&3.3589E-03_JPRB,2.9956E-03_JPRB,2.6626E-03_JPRB,2.3138E-03_JPRB,1.9609E-03_JPRB,1.5811E-03_JPRB,&
&1.1611E-03_JPRB,7.0395E-04_JPRB,3.8423E-03_JPRB/)
KAO( :, 2, 6, 7) = (/&
&3.4759E-03_JPRB,3.1375E-03_JPRB,2.8167E-03_JPRB,2.4801E-03_JPRB,2.1214E-03_JPRB,1.7215E-03_JPRB,&
&1.2829E-03_JPRB,8.1184E-04_JPRB,4.5185E-03_JPRB/)
KAO( :, 3, 6, 7) = (/&
&3.6242E-03_JPRB,3.3148E-03_JPRB,3.0137E-03_JPRB,2.6792E-03_JPRB,2.3068E-03_JPRB,1.8847E-03_JPRB,&
&1.4366E-03_JPRB,9.4529E-04_JPRB,5.3431E-03_JPRB/)
KAO( :, 4, 6, 7) = (/&
&3.8024E-03_JPRB,3.5303E-03_JPRB,3.2447E-03_JPRB,2.9079E-03_JPRB,2.5158E-03_JPRB,2.0837E-03_JPRB,&
&1.6281E-03_JPRB,1.1078E-03_JPRB,6.3321E-03_JPRB/)
KAO( :, 5, 6, 7) = (/&
&4.0032E-03_JPRB,3.7796E-03_JPRB,3.5066E-03_JPRB,3.1648E-03_JPRB,2.7620E-03_JPRB,2.3300E-03_JPRB,&
&1.8584E-03_JPRB,1.3026E-03_JPRB,7.5117E-03_JPRB/)
KAO( :, 1, 7, 7) = (/&
&2.8830E-03_JPRB,2.5691E-03_JPRB,2.2767E-03_JPRB,1.9708E-03_JPRB,1.6569E-03_JPRB,1.3271E-03_JPRB,&
&9.6810E-04_JPRB,5.7391E-04_JPRB,5.4404E-03_JPRB/)
KAO( :, 2, 7, 7) = (/&
&2.9931E-03_JPRB,2.7018E-03_JPRB,2.4141E-03_JPRB,2.1144E-03_JPRB,1.7953E-03_JPRB,1.4497E-03_JPRB,&
&1.0681E-03_JPRB,6.6067E-04_JPRB,6.3234E-03_JPRB/)
KAO( :, 3, 7, 7) = (/&
&3.1305E-03_JPRB,2.8628E-03_JPRB,2.5899E-03_JPRB,2.2886E-03_JPRB,1.9605E-03_JPRB,1.5922E-03_JPRB,&
&1.1949E-03_JPRB,7.7319E-04_JPRB,7.4384E-03_JPRB/)
KAO( :, 4, 7, 7) = (/&
&3.2919E-03_JPRB,3.0575E-03_JPRB,2.7962E-03_JPRB,2.4931E-03_JPRB,2.1505E-03_JPRB,1.7657E-03_JPRB,&
&1.3594E-03_JPRB,9.0965E-04_JPRB,8.7978E-03_JPRB/)
KAO( :, 5, 7, 7) = (/&
&3.4715E-03_JPRB,3.2809E-03_JPRB,3.0291E-03_JPRB,2.7241E-03_JPRB,2.3709E-03_JPRB,1.9816E-03_JPRB,&
&1.5601E-03_JPRB,1.0736E-03_JPRB,1.0416E-02_JPRB/)
KAO( :, 1, 8, 7) = (/&
&2.4760E-03_JPRB,2.2062E-03_JPRB,1.9505E-03_JPRB,1.6811E-03_JPRB,1.4033E-03_JPRB,1.1135E-03_JPRB,&
&8.0567E-04_JPRB,4.6971E-04_JPRB,1.0033E-02_JPRB/)
KAO( :, 2, 8, 7) = (/&
&2.5766E-03_JPRB,2.3254E-03_JPRB,2.0701E-03_JPRB,1.8033E-03_JPRB,1.5196E-03_JPRB,1.2179E-03_JPRB,&
&8.9015E-04_JPRB,5.3726E-04_JPRB,1.1309E-02_JPRB/)
KAO( :, 3, 8, 7) = (/&
&2.7010E-03_JPRB,2.4689E-03_JPRB,2.2239E-03_JPRB,1.9529E-03_JPRB,1.6624E-03_JPRB,1.3434E-03_JPRB,&
&9.9513E-04_JPRB,6.2989E-04_JPRB,1.3008E-02_JPRB/)
KAO( :, 4, 8, 7) = (/&
&2.8429E-03_JPRB,2.6411E-03_JPRB,2.4042E-03_JPRB,2.1312E-03_JPRB,1.8298E-03_JPRB,1.4940E-03_JPRB,&
&1.1345E-03_JPRB,7.4505E-04_JPRB,1.5177E-02_JPRB/)
KAO( :, 5, 8, 7) = (/&
&2.9996E-03_JPRB,2.8348E-03_JPRB,2.6056E-03_JPRB,2.3332E-03_JPRB,2.0258E-03_JPRB,1.6825E-03_JPRB,&
&1.3078E-03_JPRB,8.8471E-04_JPRB,1.7852E-02_JPRB/)
KAO( :, 1, 9, 7) = (/&
&2.1045E-03_JPRB,1.8749E-03_JPRB,1.6563E-03_JPRB,1.4213E-03_JPRB,1.1793E-03_JPRB,9.2862E-04_JPRB,&
&6.6550E-04_JPRB,3.8300E-04_JPRB,4.0779E-02_JPRB/)
KAO( :, 2, 9, 7) = (/&
&2.1941E-03_JPRB,1.9801E-03_JPRB,1.7595E-03_JPRB,1.5250E-03_JPRB,1.2768E-03_JPRB,1.0150E-03_JPRB,&
&7.3680E-04_JPRB,4.3556E-04_JPRB,4.4180E-02_JPRB/)
KAO( :, 3, 9, 7) = (/&
&2.3035E-03_JPRB,2.1066E-03_JPRB,1.8914E-03_JPRB,1.6530E-03_JPRB,1.3964E-03_JPRB,1.1220E-03_JPRB,&
&8.2430E-04_JPRB,5.1028E-04_JPRB,4.8665E-02_JPRB/)
KAO( :, 4, 9, 7) = (/&
&2.4266E-03_JPRB,2.2548E-03_JPRB,2.0445E-03_JPRB,1.8037E-03_JPRB,1.5398E-03_JPRB,1.2522E-03_JPRB,&
&9.4060E-04_JPRB,6.0474E-04_JPRB,5.4418E-02_JPRB/)
KAO( :, 5, 9, 7) = (/&
&2.5648E-03_JPRB,2.4232E-03_JPRB,2.2170E-03_JPRB,1.9746E-03_JPRB,1.7066E-03_JPRB,1.4131E-03_JPRB,&
&1.0872E-03_JPRB,7.2231E-04_JPRB,6.1744E-02_JPRB/)
KAO( :, 1,10, 7) = (/&
&1.7736E-03_JPRB,1.5819E-03_JPRB,1.3957E-03_JPRB,1.1944E-03_JPRB,9.8623E-04_JPRB,7.7163E-04_JPRB,&
&5.4898E-04_JPRB,3.1298E-04_JPRB,2.1288E-01_JPRB/)
KAO( :, 2,10, 7) = (/&
&1.8520E-03_JPRB,1.6738E-03_JPRB,1.4851E-03_JPRB,1.2823E-03_JPRB,1.0679E-03_JPRB,8.4345E-04_JPRB,&
&6.0874E-04_JPRB,3.5579E-04_JPRB,2.2960E-01_JPRB/)
KAO( :, 3,10, 7) = (/&
&1.9439E-03_JPRB,1.7818E-03_JPRB,1.5963E-03_JPRB,1.3903E-03_JPRB,1.1685E-03_JPRB,9.3435E-04_JPRB,&
&6.8422E-04_JPRB,4.1671E-04_JPRB,2.4868E-01_JPRB/)
KAO( :, 4,10, 7) = (/&
&2.0519E-03_JPRB,1.9108E-03_JPRB,1.7263E-03_JPRB,1.5165E-03_JPRB,1.2885E-03_JPRB,1.0455E-03_JPRB,&
&7.8283E-04_JPRB,4.9584E-04_JPRB,2.7032E-01_JPRB/)
KAO( :, 5,10, 7) = (/&
&2.1743E-03_JPRB,2.0588E-03_JPRB,1.8772E-03_JPRB,1.6640E-03_JPRB,1.4326E-03_JPRB,1.1843E-03_JPRB,&
&9.0587E-04_JPRB,5.9427E-04_JPRB,2.9596E-01_JPRB/)
KAO( :, 1,11, 7) = (/&
&1.5501E-03_JPRB,1.3901E-03_JPRB,1.2238E-03_JPRB,1.0457E-03_JPRB,8.6223E-04_JPRB,6.7257E-04_JPRB,&
&4.7782E-04_JPRB,2.7194E-04_JPRB,4.0190E-01_JPRB/)
KAO( :, 2,11, 7) = (/&
&1.6161E-03_JPRB,1.4686E-03_JPRB,1.3022E-03_JPRB,1.1228E-03_JPRB,9.3349E-04_JPRB,7.3693E-04_JPRB,&
&5.3209E-04_JPRB,3.1210E-04_JPRB,4.3586E-01_JPRB/)
KAO( :, 3,11, 7) = (/&
&1.6959E-03_JPRB,1.5640E-03_JPRB,1.3990E-03_JPRB,1.2156E-03_JPRB,1.0204E-03_JPRB,8.1637E-04_JPRB,&
&6.0174E-04_JPRB,3.6844E-04_JPRB,4.7353E-01_JPRB/)
KAO( :, 4,11, 7) = (/&
&1.7905E-03_JPRB,1.6788E-03_JPRB,1.5149E-03_JPRB,1.3282E-03_JPRB,1.1282E-03_JPRB,9.1912E-04_JPRB,&
&6.9230E-04_JPRB,4.4075E-04_JPRB,5.1437E-01_JPRB/)
KAO( :, 5,11, 7) = (/&
&1.8993E-03_JPRB,1.8110E-03_JPRB,1.6496E-03_JPRB,1.4619E-03_JPRB,1.2633E-03_JPRB,1.0482E-03_JPRB,&
&8.0399E-04_JPRB,5.3153E-04_JPRB,5.6007E-01_JPRB/)
KAO( :, 1,12, 7) = (/&
&1.4337E-03_JPRB,1.2858E-03_JPRB,1.1285E-03_JPRB,9.6281E-04_JPRB,7.9113E-04_JPRB,6.1463E-04_JPRB,&
&4.3486E-04_JPRB,2.4590E-04_JPRB,5.1560E-01_JPRB/)
KAO( :, 2,12, 7) = (/&
&1.4907E-03_JPRB,1.3522E-03_JPRB,1.1952E-03_JPRB,1.0259E-03_JPRB,8.4928E-04_JPRB,6.6742E-04_JPRB,&
&4.8034E-04_JPRB,2.8126E-04_JPRB,5.6136E-01_JPRB/)
KAO( :, 3,12, 7) = (/&
&1.5589E-03_JPRB,1.4349E-03_JPRB,1.2778E-03_JPRB,1.1050E-03_JPRB,9.2336E-04_JPRB,7.3586E-04_JPRB,&
&5.4130E-04_JPRB,3.2994E-04_JPRB,6.1298E-01_JPRB/)
KAO( :, 4,12, 7) = (/&
&1.6374E-03_JPRB,1.5317E-03_JPRB,1.3749E-03_JPRB,1.1997E-03_JPRB,1.0160E-03_JPRB,8.2656E-04_JPRB,&
&6.2085E-04_JPRB,3.9394E-04_JPRB,6.6802E-01_JPRB/)
KAO( :, 5,12, 7) = (/&
&1.7281E-03_JPRB,1.6427E-03_JPRB,1.4888E-03_JPRB,1.3162E-03_JPRB,1.1355E-03_JPRB,9.3878E-04_JPRB,&
&7.1928E-04_JPRB,4.7571E-04_JPRB,7.2750E-01_JPRB/)
KAO( :, 1,13, 7) = (/&
&1.4127E-03_JPRB,1.2657E-03_JPRB,1.1099E-03_JPRB,9.4602E-04_JPRB,7.7557E-04_JPRB,6.0086E-04_JPRB,&
&4.2330E-04_JPRB,2.3798E-04_JPRB,5.3307E-01_JPRB/)
KAO( :, 2,13, 7) = (/&
&1.4751E-03_JPRB,1.3349E-03_JPRB,1.1777E-03_JPRB,1.0078E-03_JPRB,8.3162E-04_JPRB,6.5054E-04_JPRB,&
&4.6516E-04_JPRB,2.6968E-04_JPRB,5.8063E-01_JPRB/)
KAO( :, 3,13, 7) = (/&
&1.5459E-03_JPRB,1.4170E-03_JPRB,1.2569E-03_JPRB,1.0823E-03_JPRB,9.0010E-04_JPRB,7.1353E-04_JPRB,&
&5.2060E-04_JPRB,3.1113E-04_JPRB,6.3437E-01_JPRB/)
KAO( :, 4,13, 7) = (/&
&1.6229E-03_JPRB,1.5083E-03_JPRB,1.3464E-03_JPRB,1.1679E-03_JPRB,9.8357E-04_JPRB,7.9315E-04_JPRB,&
&5.8870E-04_JPRB,3.6533E-04_JPRB,6.9306E-01_JPRB/)
KAO( :, 5,13, 7) = (/&
&1.7093E-03_JPRB,1.6104E-03_JPRB,1.4477E-03_JPRB,1.2713E-03_JPRB,1.0860E-03_JPRB,8.8862E-04_JPRB,&
&6.7236E-04_JPRB,4.3506E-04_JPRB,7.5652E-01_JPRB/)
KAO( :, 1, 1, 8) = (/&
&1.1271E-02_JPRB,1.0036E-02_JPRB,8.8055E-03_JPRB,7.5864E-03_JPRB,6.4304E-03_JPRB,5.2105E-03_JPRB,&
&3.8976E-03_JPRB,2.4887E-03_JPRB,2.5781E-03_JPRB/)
KAO( :, 2, 1, 8) = (/&
&1.1795E-02_JPRB,1.0572E-02_JPRB,9.3466E-03_JPRB,8.1711E-03_JPRB,6.9948E-03_JPRB,5.7121E-03_JPRB,&
&4.3485E-03_JPRB,2.8557E-03_JPRB,3.2233E-03_JPRB/)
KAO( :, 3, 1, 8) = (/&
&1.2322E-02_JPRB,1.1132E-02_JPRB,9.9358E-03_JPRB,8.8252E-03_JPRB,7.5937E-03_JPRB,6.2705E-03_JPRB,&
&4.8434E-03_JPRB,3.3250E-03_JPRB,3.9875E-03_JPRB/)
KAO( :, 4, 1, 8) = (/&
&1.2851E-02_JPRB,1.1725E-02_JPRB,1.0603E-02_JPRB,9.4992E-03_JPRB,8.2313E-03_JPRB,6.8944E-03_JPRB,&
&5.3932E-03_JPRB,3.9133E-03_JPRB,4.8783E-03_JPRB/)
KAO( :, 5, 1, 8) = (/&
&1.3382E-02_JPRB,1.2340E-02_JPRB,1.1321E-02_JPRB,1.0197E-02_JPRB,8.9293E-03_JPRB,7.5819E-03_JPRB,&
&6.0303E-03_JPRB,4.6405E-03_JPRB,5.9012E-03_JPRB/)
KAO( :, 1, 2, 8) = (/&
&1.0672E-02_JPRB,9.5056E-03_JPRB,8.3387E-03_JPRB,7.1916E-03_JPRB,6.1140E-03_JPRB,4.9607E-03_JPRB,&
&3.7058E-03_JPRB,2.3880E-03_JPRB,2.7395E-03_JPRB/)
KAO( :, 2, 2, 8) = (/&
&1.1169E-02_JPRB,1.0020E-02_JPRB,8.8610E-03_JPRB,7.7691E-03_JPRB,6.6689E-03_JPRB,5.4487E-03_JPRB,&
&4.1407E-03_JPRB,2.7243E-03_JPRB,3.3802E-03_JPRB/)
KAO( :, 3, 2, 8) = (/&
&1.1679E-02_JPRB,1.0568E-02_JPRB,9.4396E-03_JPRB,8.4156E-03_JPRB,7.2560E-03_JPRB,5.9872E-03_JPRB,&
&4.6292E-03_JPRB,3.1276E-03_JPRB,4.1522E-03_JPRB/)
KAO( :, 4, 2, 8) = (/&
&1.2189E-02_JPRB,1.1143E-02_JPRB,1.0088E-02_JPRB,9.0819E-03_JPRB,7.8824E-03_JPRB,6.5917E-03_JPRB,&
&5.1714E-03_JPRB,3.6254E-03_JPRB,5.0691E-03_JPRB/)
KAO( :, 5, 2, 8) = (/&
&1.2702E-02_JPRB,1.1729E-02_JPRB,1.0782E-02_JPRB,9.7685E-03_JPRB,8.5622E-03_JPRB,7.2579E-03_JPRB,&
&5.7650E-03_JPRB,4.2498E-03_JPRB,6.1336E-03_JPRB/)
KAO( :, 1, 3, 8) = (/&
&9.8797E-03_JPRB,8.7861E-03_JPRB,7.6933E-03_JPRB,6.6349E-03_JPRB,5.6262E-03_JPRB,4.5704E-03_JPRB,&
&3.4179E-03_JPRB,2.1903E-03_JPRB,3.6361E-03_JPRB/)
KAO( :, 2, 3, 8) = (/&
&1.0349E-02_JPRB,9.2701E-03_JPRB,8.1866E-03_JPRB,7.1655E-03_JPRB,6.1521E-03_JPRB,5.0318E-03_JPRB,&
&3.8109E-03_JPRB,2.5138E-03_JPRB,4.3860E-03_JPRB/)
KAO( :, 3, 3, 8) = (/&
&1.0830E-02_JPRB,9.7857E-03_JPRB,8.7308E-03_JPRB,7.7641E-03_JPRB,6.7179E-03_JPRB,5.5402E-03_JPRB,&
&4.2653E-03_JPRB,2.8863E-03_JPRB,5.2476E-03_JPRB/)
KAO( :, 4, 3, 8) = (/&
&1.1311E-02_JPRB,1.0326E-02_JPRB,9.3387E-03_JPRB,8.4020E-03_JPRB,7.3182E-03_JPRB,6.0959E-03_JPRB,&
&4.7833E-03_JPRB,3.3218E-03_JPRB,6.2518E-03_JPRB/)
KAO( :, 5, 3, 8) = (/&
&1.1804E-02_JPRB,1.0884E-02_JPRB,9.9988E-03_JPRB,9.0694E-03_JPRB,7.9619E-03_JPRB,6.7205E-03_JPRB,&
&5.3622E-03_JPRB,3.8455E-03_JPRB,7.4421E-03_JPRB/)
KAO( :, 1, 4, 8) = (/&
&9.0341E-03_JPRB,8.0181E-03_JPRB,7.0097E-03_JPRB,6.0433E-03_JPRB,5.0961E-03_JPRB,4.1279E-03_JPRB,&
&3.0949E-03_JPRB,1.9591E-03_JPRB,5.2205E-03_JPRB/)
KAO( :, 2, 4, 8) = (/&
&9.4663E-03_JPRB,8.4620E-03_JPRB,7.4631E-03_JPRB,6.5118E-03_JPRB,5.5670E-03_JPRB,4.5574E-03_JPRB,&
&3.4524E-03_JPRB,2.2551E-03_JPRB,6.2821E-03_JPRB/)
KAO( :, 3, 4, 8) = (/&
&9.9093E-03_JPRB,8.9346E-03_JPRB,7.9590E-03_JPRB,7.0438E-03_JPRB,6.0869E-03_JPRB,5.0245E-03_JPRB,&
&3.8570E-03_JPRB,2.6046E-03_JPRB,7.4874E-03_JPRB/)
KAO( :, 4, 4, 8) = (/&
&1.0364E-02_JPRB,9.4379E-03_JPRB,8.5216E-03_JPRB,7.6276E-03_JPRB,6.6482E-03_JPRB,5.5372E-03_JPRB,&
&4.3314E-03_JPRB,3.0117E-03_JPRB,8.8492E-03_JPRB/)
KAO( :, 5, 4, 8) = (/&
&1.0832E-02_JPRB,9.9630E-03_JPRB,9.1301E-03_JPRB,8.2526E-03_JPRB,7.2502E-03_JPRB,6.1063E-03_JPRB,&
&4.8699E-03_JPRB,3.4864E-03_JPRB,1.0381E-02_JPRB/)
KAO( :, 1, 5, 8) = (/&
&8.2066E-03_JPRB,7.2704E-03_JPRB,6.3520E-03_JPRB,5.4803E-03_JPRB,4.5989E-03_JPRB,3.7047E-03_JPRB,&
&2.7766E-03_JPRB,1.7333E-03_JPRB,7.2922E-03_JPRB/)
KAO( :, 2, 5, 8) = (/&
&8.5864E-03_JPRB,7.6589E-03_JPRB,6.7541E-03_JPRB,5.8852E-03_JPRB,5.0024E-03_JPRB,4.0864E-03_JPRB,&
&3.0959E-03_JPRB,1.9895E-03_JPRB,8.7707E-03_JPRB/)
KAO( :, 3, 5, 8) = (/&
&8.9852E-03_JPRB,8.0815E-03_JPRB,7.1976E-03_JPRB,6.3516E-03_JPRB,5.4653E-03_JPRB,4.5110E-03_JPRB,&
&3.4542E-03_JPRB,2.3009E-03_JPRB,1.0486E-02_JPRB/)
KAO( :, 4, 5, 8) = (/&
&9.4036E-03_JPRB,8.5424E-03_JPRB,7.7055E-03_JPRB,6.8683E-03_JPRB,5.9736E-03_JPRB,4.9773E-03_JPRB,&
&3.8692E-03_JPRB,2.6768E-03_JPRB,1.2445E-02_JPRB/)
KAO( :, 5, 5, 8) = (/&
&9.8437E-03_JPRB,9.0342E-03_JPRB,8.2571E-03_JPRB,7.4313E-03_JPRB,6.5257E-03_JPRB,5.4908E-03_JPRB,&
&4.3579E-03_JPRB,3.1244E-03_JPRB,1.4671E-02_JPRB/)
KAO( :, 1, 6, 8) = (/&
&7.3775E-03_JPRB,6.5258E-03_JPRB,5.7033E-03_JPRB,4.9243E-03_JPRB,4.1126E-03_JPRB,3.2909E-03_JPRB,&
&2.4468E-03_JPRB,1.5110E-03_JPRB,9.9543E-03_JPRB/)
KAO( :, 2, 6, 8) = (/&
&7.6997E-03_JPRB,6.8542E-03_JPRB,6.0539E-03_JPRB,5.2649E-03_JPRB,4.4522E-03_JPRB,3.6170E-03_JPRB,&
&2.7307E-03_JPRB,1.7266E-03_JPRB,1.1860E-02_JPRB/)
KAO( :, 3, 6, 8) = (/&
&8.0489E-03_JPRB,7.2263E-03_JPRB,6.4458E-03_JPRB,5.6660E-03_JPRB,4.8447E-03_JPRB,3.9877E-03_JPRB,&
&3.0489E-03_JPRB,1.9907E-03_JPRB,1.4111E-02_JPRB/)
KAO( :, 4, 6, 8) = (/&
&8.4274E-03_JPRB,7.6434E-03_JPRB,6.8896E-03_JPRB,6.1185E-03_JPRB,5.2908E-03_JPRB,4.4013E-03_JPRB,&
&3.4126E-03_JPRB,2.3197E-03_JPRB,1.6745E-02_JPRB/)
KAO( :, 5, 6, 8) = (/&
&8.8394E-03_JPRB,8.0956E-03_JPRB,7.3855E-03_JPRB,6.6147E-03_JPRB,5.7835E-03_JPRB,4.8630E-03_JPRB,&
&3.8408E-03_JPRB,2.7242E-03_JPRB,1.9764E-02_JPRB/)
KAO( :, 1, 7, 8) = (/&
&6.5565E-03_JPRB,5.7913E-03_JPRB,5.0650E-03_JPRB,4.3717E-03_JPRB,3.6417E-03_JPRB,2.9003E-03_JPRB,&
&2.1352E-03_JPRB,1.3029E-03_JPRB,1.4373E-02_JPRB/)
KAO( :, 2, 7, 8) = (/&
&6.8314E-03_JPRB,6.0702E-03_JPRB,5.3740E-03_JPRB,4.6650E-03_JPRB,3.9304E-03_JPRB,3.1756E-03_JPRB,&
&2.3780E-03_JPRB,1.4833E-03_JPRB,1.7113E-02_JPRB/)
KAO( :, 3, 7, 8) = (/&
&7.1400E-03_JPRB,6.4022E-03_JPRB,5.7201E-03_JPRB,5.0134E-03_JPRB,4.2702E-03_JPRB,3.4939E-03_JPRB,&
&2.6530E-03_JPRB,1.7044E-03_JPRB,2.0310E-02_JPRB/)
KAO( :, 4, 7, 8) = (/&
&7.4900E-03_JPRB,6.7869E-03_JPRB,6.1184E-03_JPRB,5.4134E-03_JPRB,4.6538E-03_JPRB,3.8497E-03_JPRB,&
&2.9716E-03_JPRB,1.9853E-03_JPRB,2.4047E-02_JPRB/)
KAO( :, 5, 7, 8) = (/&
&7.8853E-03_JPRB,7.2198E-03_JPRB,6.5744E-03_JPRB,5.8583E-03_JPRB,5.0855E-03_JPRB,4.2547E-03_JPRB,&
&3.3480E-03_JPRB,2.3372E-03_JPRB,2.8402E-02_JPRB/)
KAO( :, 1, 8, 8) = (/&
&5.7906E-03_JPRB,5.1087E-03_JPRB,4.4702E-03_JPRB,3.8543E-03_JPRB,3.2058E-03_JPRB,2.5413E-03_JPRB,&
&1.8524E-03_JPRB,1.1137E-03_JPRB,2.4973E-02_JPRB/)
KAO( :, 2, 8, 8) = (/&
&6.0296E-03_JPRB,5.3498E-03_JPRB,4.7428E-03_JPRB,4.1103E-03_JPRB,3.4527E-03_JPRB,2.7740E-03_JPRB,&
&2.0568E-03_JPRB,1.2678E-03_JPRB,2.9683E-02_JPRB/)
KAO( :, 3, 8, 8) = (/&
&6.3087E-03_JPRB,5.6506E-03_JPRB,5.0549E-03_JPRB,4.4167E-03_JPRB,3.7489E-03_JPRB,3.0452E-03_JPRB,&
&2.2930E-03_JPRB,1.4507E-03_JPRB,3.5325E-02_JPRB/)
KAO( :, 4, 8, 8) = (/&
&6.6419E-03_JPRB,6.0135E-03_JPRB,5.4190E-03_JPRB,4.7745E-03_JPRB,4.0857E-03_JPRB,3.3552E-03_JPRB,&
&2.5672E-03_JPRB,1.6862E-03_JPRB,4.1942E-02_JPRB/)
KAO( :, 5, 8, 8) = (/&
&7.0283E-03_JPRB,6.4363E-03_JPRB,5.8469E-03_JPRB,5.1836E-03_JPRB,4.4693E-03_JPRB,3.7129E-03_JPRB,&
&2.8969E-03_JPRB,1.9865E-03_JPRB,4.9701E-02_JPRB/)
KAO( :, 1, 9, 8) = (/&
&5.0360E-03_JPRB,4.4397E-03_JPRB,3.8840E-03_JPRB,3.3435E-03_JPRB,2.7807E-03_JPRB,2.1932E-03_JPRB,&
&1.5839E-03_JPRB,9.3584E-04_JPRB,8.5840E-02_JPRB/)
KAO( :, 2, 9, 8) = (/&
&5.2453E-03_JPRB,4.6508E-03_JPRB,4.1231E-03_JPRB,3.5696E-03_JPRB,2.9904E-03_JPRB,2.3871E-03_JPRB,&
&1.7527E-03_JPRB,1.0640E-03_JPRB,1.0011E-01_JPRB/)
KAO( :, 3, 9, 8) = (/&
&5.5017E-03_JPRB,4.9250E-03_JPRB,4.4061E-03_JPRB,3.8385E-03_JPRB,3.2464E-03_JPRB,2.6177E-03_JPRB,&
&1.9509E-03_JPRB,1.2177E-03_JPRB,1.1783E-01_JPRB/)
KAO( :, 4, 9, 8) = (/&
&5.8157E-03_JPRB,5.2667E-03_JPRB,4.7409E-03_JPRB,4.1617E-03_JPRB,3.5430E-03_JPRB,2.8840E-03_JPRB,&
&2.1850E-03_JPRB,1.4137E-03_JPRB,1.3938E-01_JPRB/)
KAO( :, 5, 9, 8) = (/&
&6.1830E-03_JPRB,5.6669E-03_JPRB,5.1359E-03_JPRB,4.5353E-03_JPRB,3.8872E-03_JPRB,3.1987E-03_JPRB,&
&2.4695E-03_JPRB,1.6659E-03_JPRB,1.6517E-01_JPRB/)
KAO( :, 1,10, 8) = (/&
&4.3296E-03_JPRB,3.8182E-03_JPRB,3.3429E-03_JPRB,2.8727E-03_JPRB,2.3861E-03_JPRB,1.8763E-03_JPRB,&
&1.3438E-03_JPRB,7.8161E-04_JPRB,3.9143E-01_JPRB/)
KAO( :, 2,10, 8) = (/&
&4.5130E-03_JPRB,4.0050E-03_JPRB,3.5504E-03_JPRB,3.0710E-03_JPRB,2.5674E-03_JPRB,2.0397E-03_JPRB,&
&1.4837E-03_JPRB,8.8733E-04_JPRB,4.3656E-01_JPRB/)
KAO( :, 3,10, 8) = (/&
&4.7537E-03_JPRB,4.2601E-03_JPRB,3.8073E-03_JPRB,3.3140E-03_JPRB,2.7911E-03_JPRB,2.2372E-03_JPRB,&
&1.6497E-03_JPRB,1.0161E-03_JPRB,4.9451E-01_JPRB/)
KAO( :, 4,10, 8) = (/&
&5.0463E-03_JPRB,4.5800E-03_JPRB,4.1210E-03_JPRB,3.6090E-03_JPRB,3.0570E-03_JPRB,2.4709E-03_JPRB,&
&1.8508E-03_JPRB,1.1821E-03_JPRB,5.6882E-01_JPRB/)
KAO( :, 5,10, 8) = (/&
&5.3939E-03_JPRB,4.9543E-03_JPRB,4.4851E-03_JPRB,3.9500E-03_JPRB,3.3687E-03_JPRB,2.7497E-03_JPRB,&
&2.1004E-03_JPRB,1.3979E-03_JPRB,6.6139E-01_JPRB/)
KAO( :, 1,11, 8) = (/&
&3.7600E-03_JPRB,3.3296E-03_JPRB,2.9316E-03_JPRB,2.5257E-03_JPRB,2.0989E-03_JPRB,1.6511E-03_JPRB,&
&1.1820E-03_JPRB,6.8533E-04_JPRB,7.4408E-01_JPRB/)
KAO( :, 2,11, 8) = (/&
&3.9507E-03_JPRB,3.5282E-03_JPRB,3.1373E-03_JPRB,2.7184E-03_JPRB,2.2731E-03_JPRB,1.8035E-03_JPRB,&
&1.3072E-03_JPRB,7.7991E-04_JPRB,8.1308E-01_JPRB/)
KAO( :, 3,11, 8) = (/&
&4.1947E-03_JPRB,3.7893E-03_JPRB,3.3928E-03_JPRB,2.9586E-03_JPRB,2.4893E-03_JPRB,1.9891E-03_JPRB,&
&1.4610E-03_JPRB,8.9963E-04_JPRB,8.9527E-01_JPRB/)
KAO( :, 4,11, 8) = (/&
&4.4908E-03_JPRB,4.1076E-03_JPRB,3.7028E-03_JPRB,3.2435E-03_JPRB,2.7433E-03_JPRB,2.2120E-03_JPRB,&
&1.6527E-03_JPRB,1.0595E-03_JPRB,9.9684E-01_JPRB/)
KAO( :, 5,11, 8) = (/&
&4.8478E-03_JPRB,4.4859E-03_JPRB,4.0645E-03_JPRB,3.5748E-03_JPRB,3.0447E-03_JPRB,2.4822E-03_JPRB,&
&1.8975E-03_JPRB,1.2673E-03_JPRB,1.1166E+00_JPRB/)
KAO( :, 1,12, 8) = (/&
&3.2909E-03_JPRB,2.9295E-03_JPRB,2.5867E-03_JPRB,2.2286E-03_JPRB,1.8515E-03_JPRB,1.4556E-03_JPRB,&
&1.0393E-03_JPRB,6.0072E-04_JPRB,1.0077E+00_JPRB/)
KAO( :, 2,12, 8) = (/&
&3.4843E-03_JPRB,3.1331E-03_JPRB,2.7896E-03_JPRB,2.4180E-03_JPRB,2.0217E-03_JPRB,1.5999E-03_JPRB,&
&1.1545E-03_JPRB,6.8643E-04_JPRB,1.0948E+00_JPRB/)
KAO( :, 3,12, 8) = (/&
&3.7310E-03_JPRB,3.3942E-03_JPRB,3.0433E-03_JPRB,2.6518E-03_JPRB,2.2272E-03_JPRB,1.7748E-03_JPRB,&
&1.3002E-03_JPRB,8.0128E-04_JPRB,1.1979E+00_JPRB/)
KAO( :, 4,12, 8) = (/&
&4.0332E-03_JPRB,3.7134E-03_JPRB,3.3499E-03_JPRB,2.9292E-03_JPRB,2.4733E-03_JPRB,1.9891E-03_JPRB,&
&1.4867E-03_JPRB,9.5533E-04_JPRB,1.3214E+00_JPRB/)
KAO( :, 5,12, 8) = (/&
&4.3825E-03_JPRB,4.0886E-03_JPRB,3.7068E-03_JPRB,3.2581E-03_JPRB,2.7706E-03_JPRB,2.2595E-03_JPRB,&
&1.7283E-03_JPRB,1.1510E-03_JPRB,1.4622E+00_JPRB/)
KAO( :, 1,13, 8) = (/&
&3.0478E-03_JPRB,2.7205E-03_JPRB,2.3969E-03_JPRB,2.0570E-03_JPRB,1.7018E-03_JPRB,1.3312E-03_JPRB,&
&9.4239E-04_JPRB,5.3797E-04_JPRB,1.1139E+00_JPRB/)
KAO( :, 2,13, 8) = (/&
&3.2266E-03_JPRB,2.9089E-03_JPRB,2.5816E-03_JPRB,2.2296E-03_JPRB,1.8550E-03_JPRB,1.4585E-03_JPRB,&
&1.0452E-03_JPRB,6.1598E-04_JPRB,1.2073E+00_JPRB/)
KAO( :, 3,13, 8) = (/&
&3.4554E-03_JPRB,3.1502E-03_JPRB,2.8168E-03_JPRB,2.4455E-03_JPRB,2.0432E-03_JPRB,1.6195E-03_JPRB,&
&1.1807E-03_JPRB,7.2584E-04_JPRB,1.3161E+00_JPRB/)
KAO( :, 4,13, 8) = (/&
&3.7354E-03_JPRB,3.4492E-03_JPRB,3.1036E-03_JPRB,2.7077E-03_JPRB,2.2785E-03_JPRB,1.8279E-03_JPRB,&
&1.3627E-03_JPRB,8.7250E-04_JPRB,1.4441E+00_JPRB/)
KAO( :, 5,13, 8) = (/&
&4.0484E-03_JPRB,3.7921E-03_JPRB,3.4369E-03_JPRB,3.0193E-03_JPRB,2.5680E-03_JPRB,2.0959E-03_JPRB,&
&1.6011E-03_JPRB,1.0569E-03_JPRB,1.5851E+00_JPRB/)


!     ------------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB13_A1
