!OCL SCALAR
SUBROUTINE RRTM_KGB12_A2

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 12:  1800-2080 cm-1 (low - H2O,CO2; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO12, ONLY : KAO     ,SELFREFO   ,FRACREFAO
USE YOERRTA12, ONLY : STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 9) = (/&
&1.3428E+00_JPRB,1.2969E+00_JPRB,1.3205E+00_JPRB,1.3175E+00_JPRB,1.2990E+00_JPRB,1.2468E+00_JPRB,&
&1.1628E+00_JPRB,1.0614E+00_JPRB,1.0372E+00_JPRB/)
KAO( :, 2, 1, 9) = (/&
&1.3746E+00_JPRB,1.3335E+00_JPRB,1.3668E+00_JPRB,1.3722E+00_JPRB,1.3567E+00_JPRB,1.3085E+00_JPRB,&
&1.2270E+00_JPRB,1.1261E+00_JPRB,1.1147E+00_JPRB/)
KAO( :, 3, 1, 9) = (/&
&1.4073E+00_JPRB,1.3698E+00_JPRB,1.4124E+00_JPRB,1.4260E+00_JPRB,1.4123E+00_JPRB,1.3693E+00_JPRB,&
&1.2904E+00_JPRB,1.1888E+00_JPRB,1.1913E+00_JPRB/)
KAO( :, 4, 1, 9) = (/&
&1.4400E+00_JPRB,1.4058E+00_JPRB,1.4573E+00_JPRB,1.4759E+00_JPRB,1.4676E+00_JPRB,1.4301E+00_JPRB,&
&1.3531E+00_JPRB,1.2469E+00_JPRB,1.2654E+00_JPRB/)
KAO( :, 5, 1, 9) = (/&
&1.4734E+00_JPRB,1.4423E+00_JPRB,1.5023E+00_JPRB,1.5245E+00_JPRB,1.5225E+00_JPRB,1.4892E+00_JPRB,&
&1.4132E+00_JPRB,1.3011E+00_JPRB,1.3376E+00_JPRB/)
KAO( :, 1, 2, 9) = (/&
&1.2829E+00_JPRB,1.2633E+00_JPRB,1.2907E+00_JPRB,1.2907E+00_JPRB,1.2660E+00_JPRB,1.2110E+00_JPRB,&
&1.1297E+00_JPRB,1.0058E+00_JPRB,9.3684E-01_JPRB/)
KAO( :, 2, 2, 9) = (/&
&1.3149E+00_JPRB,1.3008E+00_JPRB,1.3384E+00_JPRB,1.3472E+00_JPRB,1.3248E+00_JPRB,1.2742E+00_JPRB,&
&1.1952E+00_JPRB,1.0698E+00_JPRB,1.0113E+00_JPRB/)
KAO( :, 3, 2, 9) = (/&
&1.3475E+00_JPRB,1.3378E+00_JPRB,1.3854E+00_JPRB,1.4016E+00_JPRB,1.3821E+00_JPRB,1.3377E+00_JPRB,&
&1.2602E+00_JPRB,1.1308E+00_JPRB,1.0840E+00_JPRB/)
KAO( :, 4, 2, 9) = (/&
&1.3810E+00_JPRB,1.3744E+00_JPRB,1.4322E+00_JPRB,1.4528E+00_JPRB,1.4388E+00_JPRB,1.4001E+00_JPRB,&
&1.3236E+00_JPRB,1.1887E+00_JPRB,1.1546E+00_JPRB/)
KAO( :, 5, 2, 9) = (/&
&1.4157E+00_JPRB,1.4118E+00_JPRB,1.4780E+00_JPRB,1.5023E+00_JPRB,1.4957E+00_JPRB,1.4603E+00_JPRB,&
&1.3839E+00_JPRB,1.2445E+00_JPRB,1.2243E+00_JPRB/)
KAO( :, 1, 3, 9) = (/&
&1.2127E+00_JPRB,1.2149E+00_JPRB,1.2414E+00_JPRB,1.2413E+00_JPRB,1.2096E+00_JPRB,1.1509E+00_JPRB,&
&1.0693E+00_JPRB,9.3505E-01_JPRB,8.1904E-01_JPRB/)
KAO( :, 2, 3, 9) = (/&
&1.2443E+00_JPRB,1.2526E+00_JPRB,1.2906E+00_JPRB,1.2980E+00_JPRB,1.2698E+00_JPRB,1.2150E+00_JPRB,&
&1.1356E+00_JPRB,9.9732E-01_JPRB,8.8821E-01_JPRB/)
KAO( :, 3, 3, 9) = (/&
&1.2769E+00_JPRB,1.2896E+00_JPRB,1.3389E+00_JPRB,1.3532E+00_JPRB,1.3282E+00_JPRB,1.2784E+00_JPRB,&
&1.2012E+00_JPRB,1.0574E+00_JPRB,9.5592E-01_JPRB/)
KAO( :, 4, 3, 9) = (/&
&1.3109E+00_JPRB,1.3271E+00_JPRB,1.3868E+00_JPRB,1.4049E+00_JPRB,1.3857E+00_JPRB,1.3410E+00_JPRB,&
&1.2646E+00_JPRB,1.1151E+00_JPRB,1.0226E+00_JPRB/)
KAO( :, 5, 3, 9) = (/&
&1.3463E+00_JPRB,1.3657E+00_JPRB,1.4329E+00_JPRB,1.4555E+00_JPRB,1.4430E+00_JPRB,1.4020E+00_JPRB,&
&1.3252E+00_JPRB,1.1714E+00_JPRB,1.0884E+00_JPRB/)
KAO( :, 1, 4, 9) = (/&
&1.1396E+00_JPRB,1.1562E+00_JPRB,1.1826E+00_JPRB,1.1757E+00_JPRB,1.1396E+00_JPRB,1.0800E+00_JPRB,&
&9.9549E-01_JPRB,8.6118E-01_JPRB,7.0458E-01_JPRB/)
KAO( :, 2, 4, 9) = (/&
&1.1708E+00_JPRB,1.1941E+00_JPRB,1.2324E+00_JPRB,1.2326E+00_JPRB,1.2012E+00_JPRB,1.1447E+00_JPRB,&
&1.0603E+00_JPRB,9.2111E-01_JPRB,7.6931E-01_JPRB/)
KAO( :, 3, 4, 9) = (/&
&1.2031E+00_JPRB,1.2324E+00_JPRB,1.2815E+00_JPRB,1.2882E+00_JPRB,1.2607E+00_JPRB,1.2072E+00_JPRB,&
&1.1246E+00_JPRB,9.8015E-01_JPRB,8.3245E-01_JPRB/)
KAO( :, 4, 4, 9) = (/&
&1.2376E+00_JPRB,1.2714E+00_JPRB,1.3295E+00_JPRB,1.3421E+00_JPRB,1.3190E+00_JPRB,1.2690E+00_JPRB,&
&1.1874E+00_JPRB,1.0376E+00_JPRB,8.9457E-01_JPRB/)
KAO( :, 5, 4, 9) = (/&
&1.2740E+00_JPRB,1.3119E+00_JPRB,1.3762E+00_JPRB,1.3940E+00_JPRB,1.3758E+00_JPRB,1.3293E+00_JPRB,&
&1.2473E+00_JPRB,1.0924E+00_JPRB,9.5512E-01_JPRB/)
KAO( :, 1, 5, 9) = (/&
&1.0676E+00_JPRB,1.0934E+00_JPRB,1.1164E+00_JPRB,1.1017E+00_JPRB,1.0618E+00_JPRB,1.0031E+00_JPRB,&
&9.1670E-01_JPRB,7.8582E-01_JPRB,6.0004E-01_JPRB/)
KAO( :, 2, 5, 9) = (/&
&1.0980E+00_JPRB,1.1317E+00_JPRB,1.1657E+00_JPRB,1.1576E+00_JPRB,1.1232E+00_JPRB,1.0675E+00_JPRB,&
&9.7913E-01_JPRB,8.4460E-01_JPRB,6.6026E-01_JPRB/)
KAO( :, 3, 5, 9) = (/&
&1.1299E+00_JPRB,1.1708E+00_JPRB,1.2140E+00_JPRB,1.2133E+00_JPRB,1.1840E+00_JPRB,1.1288E+00_JPRB,&
&1.0409E+00_JPRB,9.0310E-01_JPRB,7.1874E-01_JPRB/)
KAO( :, 4, 5, 9) = (/&
&1.1642E+00_JPRB,1.2107E+00_JPRB,1.2614E+00_JPRB,1.2677E+00_JPRB,1.2424E+00_JPRB,1.1890E+00_JPRB,&
&1.1017E+00_JPRB,9.5891E-01_JPRB,7.7564E-01_JPRB/)
KAO( :, 5, 5, 9) = (/&
&1.2000E+00_JPRB,1.2526E+00_JPRB,1.3091E+00_JPRB,1.3207E+00_JPRB,1.2994E+00_JPRB,1.2483E+00_JPRB,&
&1.1609E+00_JPRB,1.0119E+00_JPRB,8.3130E-01_JPRB/)
KAO( :, 1, 6, 9) = (/&
&9.9003E-01_JPRB,1.0258E+00_JPRB,1.0412E+00_JPRB,1.0201E+00_JPRB,9.7779E-01_JPRB,9.1873E-01_JPRB,&
&8.3216E-01_JPRB,7.0459E-01_JPRB,5.0433E-01_JPRB/)
KAO( :, 2, 6, 9) = (/&
&1.0190E+00_JPRB,1.0642E+00_JPRB,1.0886E+00_JPRB,1.0744E+00_JPRB,1.0384E+00_JPRB,9.8045E-01_JPRB,&
&8.9228E-01_JPRB,7.6180E-01_JPRB,5.5916E-01_JPRB/)
KAO( :, 3, 6, 9) = (/&
&1.0499E+00_JPRB,1.1031E+00_JPRB,1.1353E+00_JPRB,1.1293E+00_JPRB,1.0979E+00_JPRB,1.0403E+00_JPRB,&
&9.5155E-01_JPRB,8.1856E-01_JPRB,6.1244E-01_JPRB/)
KAO( :, 4, 6, 9) = (/&
&1.0828E+00_JPRB,1.1437E+00_JPRB,1.1824E+00_JPRB,1.1833E+00_JPRB,1.1555E+00_JPRB,1.0993E+00_JPRB,&
&1.0102E+00_JPRB,8.7279E-01_JPRB,6.6433E-01_JPRB/)
KAO( :, 5, 6, 9) = (/&
&1.1175E+00_JPRB,1.1857E+00_JPRB,1.2305E+00_JPRB,1.2360E+00_JPRB,1.2119E+00_JPRB,1.1569E+00_JPRB,&
&1.0670E+00_JPRB,9.2416E-01_JPRB,7.1591E-01_JPRB/)
KAO( :, 1, 7, 9) = (/&
&9.0622E-01_JPRB,9.5046E-01_JPRB,9.6089E-01_JPRB,9.3711E-01_JPRB,8.9284E-01_JPRB,8.3176E-01_JPRB,&
&7.4643E-01_JPRB,6.2447E-01_JPRB,4.1858E-01_JPRB/)
KAO( :, 2, 7, 9) = (/&
&9.3396E-01_JPRB,9.8759E-01_JPRB,1.0065E+00_JPRB,9.8973E-01_JPRB,9.5076E-01_JPRB,8.9008E-01_JPRB,&
&8.0412E-01_JPRB,6.7884E-01_JPRB,4.6801E-01_JPRB/)
KAO( :, 3, 7, 9) = (/&
&9.6319E-01_JPRB,1.0255E+00_JPRB,1.0520E+00_JPRB,1.0425E+00_JPRB,1.0071E+00_JPRB,9.4738E-01_JPRB,&
&8.6097E-01_JPRB,7.3289E-01_JPRB,5.1587E-01_JPRB/)
KAO( :, 4, 7, 9) = (/&
&9.9431E-01_JPRB,1.0653E+00_JPRB,1.0986E+00_JPRB,1.0946E+00_JPRB,1.0623E+00_JPRB,1.0043E+00_JPRB,&
&9.1723E-01_JPRB,7.8478E-01_JPRB,5.6306E-01_JPRB/)
KAO( :, 5, 7, 9) = (/&
&1.0274E+00_JPRB,1.1069E+00_JPRB,1.1469E+00_JPRB,1.1464E+00_JPRB,1.1172E+00_JPRB,1.0599E+00_JPRB,&
&9.7098E-01_JPRB,8.3391E-01_JPRB,6.1058E-01_JPRB/)
KAO( :, 1, 8, 9) = (/&
&8.1868E-01_JPRB,8.7029E-01_JPRB,8.7676E-01_JPRB,8.5425E-01_JPRB,8.0979E-01_JPRB,7.4690E-01_JPRB,&
&6.6276E-01_JPRB,5.4807E-01_JPRB,3.4321E-01_JPRB/)
KAO( :, 2, 8, 9) = (/&
&8.4618E-01_JPRB,9.0631E-01_JPRB,9.1992E-01_JPRB,9.0408E-01_JPRB,8.6387E-01_JPRB,8.0135E-01_JPRB,&
&7.1759E-01_JPRB,5.9903E-01_JPRB,3.8705E-01_JPRB/)
KAO( :, 3, 8, 9) = (/&
&8.7480E-01_JPRB,9.4290E-01_JPRB,9.6372E-01_JPRB,9.5463E-01_JPRB,9.1665E-01_JPRB,8.5535E-01_JPRB,&
&7.7165E-01_JPRB,6.4994E-01_JPRB,4.2964E-01_JPRB/)
KAO( :, 4, 8, 9) = (/&
&9.0487E-01_JPRB,9.8122E-01_JPRB,1.0094E+00_JPRB,1.0045E+00_JPRB,9.6889E-01_JPRB,9.0941E-01_JPRB,&
&8.2521E-01_JPRB,6.9828E-01_JPRB,4.7251E-01_JPRB/)
KAO( :, 5, 8, 9) = (/&
&9.3640E-01_JPRB,1.0212E+00_JPRB,1.0569E+00_JPRB,1.0548E+00_JPRB,1.0212E+00_JPRB,9.6279E-01_JPRB,&
&8.7575E-01_JPRB,7.4474E-01_JPRB,5.1556E-01_JPRB/)
KAO( :, 1, 9, 9) = (/&
&7.3248E-01_JPRB,7.8661E-01_JPRB,7.9076E-01_JPRB,7.6949E-01_JPRB,7.2749E-01_JPRB,6.6515E-01_JPRB,&
&5.8393E-01_JPRB,4.7588E-01_JPRB,2.7793E-01_JPRB/)
KAO( :, 2, 9, 9) = (/&
&7.5864E-01_JPRB,8.2147E-01_JPRB,8.3210E-01_JPRB,8.1596E-01_JPRB,7.7766E-01_JPRB,7.1604E-01_JPRB,&
&6.3458E-01_JPRB,5.2262E-01_JPRB,3.1673E-01_JPRB/)
KAO( :, 3, 9, 9) = (/&
&7.8652E-01_JPRB,8.5723E-01_JPRB,8.7381E-01_JPRB,8.6296E-01_JPRB,8.2677E-01_JPRB,7.6708E-01_JPRB,&
&6.8470E-01_JPRB,5.6962E-01_JPRB,3.5494E-01_JPRB/)
KAO( :, 4, 9, 9) = (/&
&8.1572E-01_JPRB,8.9416E-01_JPRB,9.1752E-01_JPRB,9.1007E-01_JPRB,8.7613E-01_JPRB,8.1762E-01_JPRB,&
&7.3487E-01_JPRB,6.1457E-01_JPRB,3.9372E-01_JPRB/)
KAO( :, 5, 9, 9) = (/&
&8.4624E-01_JPRB,9.3262E-01_JPRB,9.6268E-01_JPRB,9.5791E-01_JPRB,9.2621E-01_JPRB,8.6785E-01_JPRB,&
&7.8234E-01_JPRB,6.5797E-01_JPRB,4.3237E-01_JPRB/)
KAO( :, 1,10, 9) = (/&
&6.5285E-01_JPRB,7.0556E-01_JPRB,7.0877E-01_JPRB,6.8957E-01_JPRB,6.5004E-01_JPRB,5.9094E-01_JPRB,&
&5.1435E-01_JPRB,4.1208E-01_JPRB,2.3031E-01_JPRB/)
KAO( :, 2,10, 9) = (/&
&6.7792E-01_JPRB,7.3916E-01_JPRB,7.4857E-01_JPRB,7.3319E-01_JPRB,6.9544E-01_JPRB,6.3833E-01_JPRB,&
&5.6078E-01_JPRB,4.5470E-01_JPRB,2.6518E-01_JPRB/)
KAO( :, 3,10, 9) = (/&
&7.0469E-01_JPRB,7.7387E-01_JPRB,7.8906E-01_JPRB,7.7634E-01_JPRB,7.4114E-01_JPRB,6.8557E-01_JPRB,&
&6.0667E-01_JPRB,4.9747E-01_JPRB,3.0039E-01_JPRB/)
KAO( :, 4,10, 9) = (/&
&7.3310E-01_JPRB,8.1001E-01_JPRB,8.3104E-01_JPRB,8.2017E-01_JPRB,7.8729E-01_JPRB,7.3297E-01_JPRB,&
&6.5240E-01_JPRB,5.3892E-01_JPRB,3.3590E-01_JPRB/)
KAO( :, 5,10, 9) = (/&
&7.6290E-01_JPRB,8.4760E-01_JPRB,8.7394E-01_JPRB,8.6505E-01_JPRB,8.3426E-01_JPRB,7.8012E-01_JPRB,&
&6.9636E-01_JPRB,5.7926E-01_JPRB,3.7143E-01_JPRB/)
KAO( :, 1,11, 9) = (/&
&5.9090E-01_JPRB,6.4305E-01_JPRB,6.4751E-01_JPRB,6.3053E-01_JPRB,5.9455E-01_JPRB,5.4070E-01_JPRB,&
&4.6893E-01_JPRB,3.7172E-01_JPRB,2.1405E-01_JPRB/)
KAO( :, 2,11, 9) = (/&
&6.1610E-01_JPRB,6.7624E-01_JPRB,6.8614E-01_JPRB,6.7105E-01_JPRB,6.3688E-01_JPRB,5.8397E-01_JPRB,&
&5.1072E-01_JPRB,4.1032E-01_JPRB,2.4686E-01_JPRB/)
KAO( :, 3,11, 9) = (/&
&6.4345E-01_JPRB,7.1119E-01_JPRB,7.2537E-01_JPRB,7.1231E-01_JPRB,6.7967E-01_JPRB,6.2716E-01_JPRB,&
&5.5288E-01_JPRB,4.4844E-01_JPRB,2.7991E-01_JPRB/)
KAO( :, 4,11, 9) = (/&
&6.7245E-01_JPRB,7.4763E-01_JPRB,7.6564E-01_JPRB,7.5469E-01_JPRB,7.2271E-01_JPRB,6.7051E-01_JPRB,&
&5.9423E-01_JPRB,4.8613E-01_JPRB,3.1288E-01_JPRB/)
KAO( :, 5,11, 9) = (/&
&7.0307E-01_JPRB,7.8557E-01_JPRB,8.0692E-01_JPRB,7.9786E-01_JPRB,7.6651E-01_JPRB,7.1310E-01_JPRB,&
&6.3521E-01_JPRB,5.2316E-01_JPRB,3.4596E-01_JPRB/)
KAO( :, 1,12, 9) = (/&
&5.3439E-01_JPRB,5.8391E-01_JPRB,5.8774E-01_JPRB,5.7122E-01_JPRB,5.3863E-01_JPRB,4.9053E-01_JPRB,&
&4.2331E-01_JPRB,3.3386E-01_JPRB,2.0991E-01_JPRB/)
KAO( :, 2,12, 9) = (/&
&5.5981E-01_JPRB,6.1691E-01_JPRB,6.2491E-01_JPRB,6.0974E-01_JPRB,5.7829E-01_JPRB,5.2963E-01_JPRB,&
&4.6106E-01_JPRB,3.6833E-01_JPRB,2.4202E-01_JPRB/)
KAO( :, 3,12, 9) = (/&
&5.8729E-01_JPRB,6.5190E-01_JPRB,6.6281E-01_JPRB,6.4965E-01_JPRB,6.1814E-01_JPRB,5.6902E-01_JPRB,&
&4.9887E-01_JPRB,4.0268E-01_JPRB,2.7433E-01_JPRB/)
KAO( :, 4,12, 9) = (/&
&6.1659E-01_JPRB,6.8828E-01_JPRB,7.0203E-01_JPRB,6.9007E-01_JPRB,6.5880E-01_JPRB,6.0818E-01_JPRB,&
&5.3678E-01_JPRB,4.3667E-01_JPRB,3.0656E-01_JPRB/)
KAO( :, 5,12, 9) = (/&
&6.4762E-01_JPRB,7.2645E-01_JPRB,7.4237E-01_JPRB,7.3145E-01_JPRB,6.9915E-01_JPRB,6.4741E-01_JPRB,&
&5.7484E-01_JPRB,4.6985E-01_JPRB,3.3881E-01_JPRB/)
KAO( :, 1,13, 9) = (/&
&4.8753E-01_JPRB,5.3273E-01_JPRB,5.3419E-01_JPRB,5.1662E-01_JPRB,4.8575E-01_JPRB,4.4090E-01_JPRB,&
&3.7978E-01_JPRB,2.9794E-01_JPRB,2.0545E-01_JPRB/)
KAO( :, 2,13, 9) = (/&
&5.1376E-01_JPRB,5.6597E-01_JPRB,5.6993E-01_JPRB,5.5397E-01_JPRB,5.2292E-01_JPRB,4.7698E-01_JPRB,&
&4.1398E-01_JPRB,3.2894E-01_JPRB,2.3666E-01_JPRB/)
KAO( :, 3,13, 9) = (/&
&5.4228E-01_JPRB,6.0098E-01_JPRB,6.0712E-01_JPRB,5.9219E-01_JPRB,5.6068E-01_JPRB,5.1331E-01_JPRB,&
&4.4847E-01_JPRB,3.5992E-01_JPRB,2.6838E-01_JPRB/)
KAO( :, 4,13, 9) = (/&
&5.7239E-01_JPRB,6.3765E-01_JPRB,6.4572E-01_JPRB,6.3133E-01_JPRB,5.9865E-01_JPRB,5.5003E-01_JPRB,&
&4.8326E-01_JPRB,3.9056E-01_JPRB,3.0014E-01_JPRB/)
KAO( :, 5,13, 9) = (/&
&6.0266E-01_JPRB,6.7556E-01_JPRB,6.8531E-01_JPRB,6.7067E-01_JPRB,6.3710E-01_JPRB,5.8691E-01_JPRB,&
&5.1750E-01_JPRB,4.2055E-01_JPRB,3.3173E-01_JPRB/)
KAO( :, 1, 1,10) = (/&
&3.6294E+00_JPRB,3.2562E+00_JPRB,3.2368E+00_JPRB,3.0996E+00_JPRB,2.9830E+00_JPRB,2.8753E+00_JPRB,&
&2.7749E+00_JPRB,2.5993E+00_JPRB,2.8111E+00_JPRB/)
KAO( :, 2, 1,10) = (/&
&3.7112E+00_JPRB,3.3258E+00_JPRB,3.3100E+00_JPRB,3.2079E+00_JPRB,3.1384E+00_JPRB,3.0034E+00_JPRB,&
&2.8949E+00_JPRB,2.7070E+00_JPRB,3.0039E+00_JPRB/)
KAO( :, 3, 1,10) = (/&
&3.7891E+00_JPRB,3.3949E+00_JPRB,3.3824E+00_JPRB,3.3195E+00_JPRB,3.2833E+00_JPRB,3.1133E+00_JPRB,&
&3.0142E+00_JPRB,2.8340E+00_JPRB,3.1933E+00_JPRB/)
KAO( :, 4, 1,10) = (/&
&3.8594E+00_JPRB,3.4595E+00_JPRB,3.4534E+00_JPRB,3.4596E+00_JPRB,3.3989E+00_JPRB,3.2137E+00_JPRB,&
&3.1290E+00_JPRB,2.9765E+00_JPRB,3.3923E+00_JPRB/)
KAO( :, 5, 1,10) = (/&
&3.9199E+00_JPRB,3.5165E+00_JPRB,3.5128E+00_JPRB,3.5924E+00_JPRB,3.4985E+00_JPRB,3.3169E+00_JPRB,&
&3.2426E+00_JPRB,3.1423E+00_JPRB,3.5829E+00_JPRB/)
KAO( :, 1, 2,10) = (/&
&3.6408E+00_JPRB,3.2851E+00_JPRB,3.3076E+00_JPRB,3.2113E+00_JPRB,3.1456E+00_JPRB,3.0206E+00_JPRB,&
&2.7332E+00_JPRB,2.5617E+00_JPRB,2.6956E+00_JPRB/)
KAO( :, 2, 2,10) = (/&
&3.7247E+00_JPRB,3.3643E+00_JPRB,3.3883E+00_JPRB,3.3308E+00_JPRB,3.3119E+00_JPRB,3.1672E+00_JPRB,&
&2.8664E+00_JPRB,2.6839E+00_JPRB,2.9052E+00_JPRB/)
KAO( :, 3, 2,10) = (/&
&3.8049E+00_JPRB,3.4403E+00_JPRB,3.4728E+00_JPRB,3.4603E+00_JPRB,3.4644E+00_JPRB,3.2894E+00_JPRB,&
&2.9956E+00_JPRB,2.7983E+00_JPRB,3.1071E+00_JPRB/)
KAO( :, 4, 2,10) = (/&
&3.8732E+00_JPRB,3.5109E+00_JPRB,3.5452E+00_JPRB,3.6076E+00_JPRB,3.5864E+00_JPRB,3.4101E+00_JPRB,&
&3.1230E+00_JPRB,2.9350E+00_JPRB,3.3150E+00_JPRB/)
KAO( :, 5, 2,10) = (/&
&3.9409E+00_JPRB,3.5762E+00_JPRB,3.6198E+00_JPRB,3.7407E+00_JPRB,3.6919E+00_JPRB,3.5308E+00_JPRB,&
&3.2386E+00_JPRB,3.0801E+00_JPRB,3.5151E+00_JPRB/)
KAO( :, 1, 3,10) = (/&
&3.5736E+00_JPRB,3.2584E+00_JPRB,3.3139E+00_JPRB,3.2719E+00_JPRB,3.2271E+00_JPRB,3.0778E+00_JPRB,&
&2.7397E+00_JPRB,2.4788E+00_JPRB,2.5395E+00_JPRB/)
KAO( :, 2, 3,10) = (/&
&3.6594E+00_JPRB,3.3492E+00_JPRB,3.4059E+00_JPRB,3.4088E+00_JPRB,3.3945E+00_JPRB,3.2416E+00_JPRB,&
&2.8874E+00_JPRB,2.6220E+00_JPRB,2.7498E+00_JPRB/)
KAO( :, 3, 3,10) = (/&
&3.7370E+00_JPRB,3.4383E+00_JPRB,3.4999E+00_JPRB,3.5416E+00_JPRB,3.5599E+00_JPRB,3.3810E+00_JPRB,&
&3.0257E+00_JPRB,2.7502E+00_JPRB,2.9649E+00_JPRB/)
KAO( :, 4, 3,10) = (/&
&3.8104E+00_JPRB,3.5143E+00_JPRB,3.5877E+00_JPRB,3.6896E+00_JPRB,3.6976E+00_JPRB,3.5128E+00_JPRB,&
&3.1541E+00_JPRB,2.8734E+00_JPRB,3.1792E+00_JPRB/)
KAO( :, 5, 3,10) = (/&
&3.8817E+00_JPRB,3.5850E+00_JPRB,3.6770E+00_JPRB,3.8155E+00_JPRB,3.8142E+00_JPRB,3.6439E+00_JPRB,&
&3.2832E+00_JPRB,2.9977E+00_JPRB,3.3829E+00_JPRB/)
KAO( :, 1, 4,10) = (/&
&3.4322E+00_JPRB,3.2007E+00_JPRB,3.2659E+00_JPRB,3.2997E+00_JPRB,3.2447E+00_JPRB,3.0584E+00_JPRB,&
&2.7371E+00_JPRB,2.3518E+00_JPRB,2.3300E+00_JPRB/)
KAO( :, 2, 4,10) = (/&
&3.5196E+00_JPRB,3.3050E+00_JPRB,3.3731E+00_JPRB,3.4388E+00_JPRB,3.4095E+00_JPRB,3.2370E+00_JPRB,&
&2.9126E+00_JPRB,2.5092E+00_JPRB,2.5309E+00_JPRB/)
KAO( :, 3, 4,10) = (/&
&3.5985E+00_JPRB,3.3943E+00_JPRB,3.4756E+00_JPRB,3.5772E+00_JPRB,3.5742E+00_JPRB,3.4032E+00_JPRB,&
&3.0669E+00_JPRB,2.6516E+00_JPRB,2.7458E+00_JPRB/)
KAO( :, 4, 4,10) = (/&
&3.6770E+00_JPRB,3.4750E+00_JPRB,3.5775E+00_JPRB,3.7106E+00_JPRB,3.7325E+00_JPRB,3.5499E+00_JPRB,&
&3.2119E+00_JPRB,2.7759E+00_JPRB,2.9618E+00_JPRB/)
KAO( :, 5, 4,10) = (/&
&3.7553E+00_JPRB,3.5545E+00_JPRB,3.6854E+00_JPRB,3.8420E+00_JPRB,3.8679E+00_JPRB,3.6893E+00_JPRB,&
&3.3628E+00_JPRB,2.8870E+00_JPRB,3.1717E+00_JPRB/)
KAO( :, 1, 5,10) = (/&
&3.2373E+00_JPRB,3.1117E+00_JPRB,3.1778E+00_JPRB,3.2611E+00_JPRB,3.1950E+00_JPRB,2.9886E+00_JPRB,&
&2.6929E+00_JPRB,2.2194E+00_JPRB,2.0888E+00_JPRB/)
KAO( :, 2, 5,10) = (/&
&3.3227E+00_JPRB,3.2184E+00_JPRB,3.2899E+00_JPRB,3.4098E+00_JPRB,3.3633E+00_JPRB,3.1652E+00_JPRB,&
&2.8940E+00_JPRB,2.3720E+00_JPRB,2.2795E+00_JPRB/)
KAO( :, 3, 5,10) = (/&
&3.4108E+00_JPRB,3.3097E+00_JPRB,3.4099E+00_JPRB,3.5509E+00_JPRB,3.5204E+00_JPRB,3.3546E+00_JPRB,&
&3.0628E+00_JPRB,2.5129E+00_JPRB,2.4816E+00_JPRB/)
KAO( :, 4, 5,10) = (/&
&3.5003E+00_JPRB,3.3952E+00_JPRB,3.5314E+00_JPRB,3.6804E+00_JPRB,3.6822E+00_JPRB,3.5261E+00_JPRB,&
&3.2230E+00_JPRB,2.6514E+00_JPRB,2.6958E+00_JPRB/)
KAO( :, 5, 5,10) = (/&
&3.5863E+00_JPRB,3.4801E+00_JPRB,3.6493E+00_JPRB,3.8038E+00_JPRB,3.8198E+00_JPRB,3.6739E+00_JPRB,&
&3.3792E+00_JPRB,2.7781E+00_JPRB,2.9109E+00_JPRB/)
KAO( :, 1, 6,10) = (/&
&3.0445E+00_JPRB,2.9620E+00_JPRB,3.0571E+00_JPRB,3.1457E+00_JPRB,3.0759E+00_JPRB,2.8664E+00_JPRB,&
&2.5916E+00_JPRB,2.1266E+00_JPRB,1.8296E+00_JPRB/)
KAO( :, 2, 6,10) = (/&
&3.1336E+00_JPRB,3.0624E+00_JPRB,3.1925E+00_JPRB,3.2966E+00_JPRB,3.2392E+00_JPRB,3.0536E+00_JPRB,&
&2.7999E+00_JPRB,2.2755E+00_JPRB,2.0164E+00_JPRB/)
KAO( :, 3, 6,10) = (/&
&3.2251E+00_JPRB,3.1623E+00_JPRB,3.3255E+00_JPRB,3.4339E+00_JPRB,3.3902E+00_JPRB,3.2529E+00_JPRB,&
&2.9818E+00_JPRB,2.4175E+00_JPRB,2.2137E+00_JPRB/)
KAO( :, 4, 6,10) = (/&
&3.3171E+00_JPRB,3.2585E+00_JPRB,3.4579E+00_JPRB,3.5597E+00_JPRB,3.5496E+00_JPRB,3.4294E+00_JPRB,&
&3.1517E+00_JPRB,2.5627E+00_JPRB,2.4250E+00_JPRB/)
KAO( :, 5, 6,10) = (/&
&3.4116E+00_JPRB,3.3553E+00_JPRB,3.5847E+00_JPRB,3.6942E+00_JPRB,3.6982E+00_JPRB,3.5971E+00_JPRB,&
&3.3128E+00_JPRB,2.7040E+00_JPRB,2.6238E+00_JPRB/)
KAO( :, 1, 7,10) = (/&
&2.9086E+00_JPRB,2.8374E+00_JPRB,2.9280E+00_JPRB,2.9562E+00_JPRB,2.8965E+00_JPRB,2.7121E+00_JPRB,&
&2.4469E+00_JPRB,2.0175E+00_JPRB,1.5788E+00_JPRB/)
KAO( :, 2, 7,10) = (/&
&2.9988E+00_JPRB,2.9438E+00_JPRB,3.0639E+00_JPRB,3.1077E+00_JPRB,3.0554E+00_JPRB,2.9073E+00_JPRB,&
&2.6439E+00_JPRB,2.1750E+00_JPRB,1.7618E+00_JPRB/)
KAO( :, 3, 7,10) = (/&
&3.0933E+00_JPRB,3.0485E+00_JPRB,3.1991E+00_JPRB,3.2496E+00_JPRB,3.2138E+00_JPRB,3.1110E+00_JPRB,&
&2.8275E+00_JPRB,2.3269E+00_JPRB,1.9611E+00_JPRB/)
KAO( :, 4, 7,10) = (/&
&3.1882E+00_JPRB,3.1521E+00_JPRB,3.3306E+00_JPRB,3.3838E+00_JPRB,3.3832E+00_JPRB,3.2822E+00_JPRB,&
&2.9996E+00_JPRB,2.4824E+00_JPRB,2.1592E+00_JPRB/)
KAO( :, 5, 7,10) = (/&
&3.2780E+00_JPRB,3.2584E+00_JPRB,3.4493E+00_JPRB,3.5229E+00_JPRB,3.5250E+00_JPRB,3.4373E+00_JPRB,&
&3.1721E+00_JPRB,2.6319E+00_JPRB,2.3379E+00_JPRB/)
KAO( :, 1, 8,10) = (/&
&2.8154E+00_JPRB,2.7401E+00_JPRB,2.8041E+00_JPRB,2.7499E+00_JPRB,2.6697E+00_JPRB,2.5266E+00_JPRB,&
&2.2797E+00_JPRB,1.8696E+00_JPRB,1.3559E+00_JPRB/)
KAO( :, 2, 8,10) = (/&
&2.8912E+00_JPRB,2.8557E+00_JPRB,2.9355E+00_JPRB,2.8974E+00_JPRB,2.8365E+00_JPRB,2.7206E+00_JPRB,&
&2.4626E+00_JPRB,2.0339E+00_JPRB,1.5286E+00_JPRB/)
KAO( :, 3, 8,10) = (/&
&2.9739E+00_JPRB,2.9692E+00_JPRB,3.0667E+00_JPRB,3.0335E+00_JPRB,3.0033E+00_JPRB,2.9063E+00_JPRB,&
&2.6365E+00_JPRB,2.1906E+00_JPRB,1.7207E+00_JPRB/)
KAO( :, 4, 8,10) = (/&
&3.0589E+00_JPRB,3.0798E+00_JPRB,3.1911E+00_JPRB,3.1726E+00_JPRB,3.1737E+00_JPRB,3.0654E+00_JPRB,&
&2.8021E+00_JPRB,2.3587E+00_JPRB,1.9007E+00_JPRB/)
KAO( :, 5, 8,10) = (/&
&3.1452E+00_JPRB,3.1888E+00_JPRB,3.3008E+00_JPRB,3.3242E+00_JPRB,3.3225E+00_JPRB,3.2145E+00_JPRB,&
&2.9803E+00_JPRB,2.5138E+00_JPRB,2.0640E+00_JPRB/)
KAO( :, 1, 9,10) = (/&
&2.7071E+00_JPRB,2.6491E+00_JPRB,2.6723E+00_JPRB,2.5686E+00_JPRB,2.4536E+00_JPRB,2.3106E+00_JPRB,&
&2.0811E+00_JPRB,1.6991E+00_JPRB,1.1509E+00_JPRB/)
KAO( :, 2, 9,10) = (/&
&2.7701E+00_JPRB,2.7593E+00_JPRB,2.7975E+00_JPRB,2.7179E+00_JPRB,2.6123E+00_JPRB,2.4920E+00_JPRB,&
&2.2565E+00_JPRB,1.8667E+00_JPRB,1.3080E+00_JPRB/)
KAO( :, 3, 9,10) = (/&
&2.8376E+00_JPRB,2.8669E+00_JPRB,2.9292E+00_JPRB,2.8584E+00_JPRB,2.7770E+00_JPRB,2.6567E+00_JPRB,&
&2.4289E+00_JPRB,2.0233E+00_JPRB,1.4827E+00_JPRB/)
KAO( :, 4, 9,10) = (/&
&2.9092E+00_JPRB,2.9736E+00_JPRB,3.0528E+00_JPRB,3.0034E+00_JPRB,2.9332E+00_JPRB,2.8084E+00_JPRB,&
&2.5864E+00_JPRB,2.1897E+00_JPRB,1.6436E+00_JPRB/)
KAO( :, 5, 9,10) = (/&
&2.9831E+00_JPRB,3.0790E+00_JPRB,3.1648E+00_JPRB,3.1509E+00_JPRB,3.0739E+00_JPRB,2.9530E+00_JPRB,&
&2.7530E+00_JPRB,2.3477E+00_JPRB,1.7965E+00_JPRB/)
KAO( :, 1,10,10) = (/&
&2.5846E+00_JPRB,2.5566E+00_JPRB,2.5335E+00_JPRB,2.4083E+00_JPRB,2.2712E+00_JPRB,2.1147E+00_JPRB,&
&1.8770E+00_JPRB,1.5356E+00_JPRB,9.6607E-01_JPRB/)
KAO( :, 2,10,10) = (/&
&2.6440E+00_JPRB,2.6579E+00_JPRB,2.6475E+00_JPRB,2.5522E+00_JPRB,2.4355E+00_JPRB,2.2753E+00_JPRB,&
&2.0432E+00_JPRB,1.6979E+00_JPRB,1.1107E+00_JPRB/)
KAO( :, 3,10,10) = (/&
&2.7001E+00_JPRB,2.7579E+00_JPRB,2.7665E+00_JPRB,2.7021E+00_JPRB,2.5868E+00_JPRB,2.4222E+00_JPRB,&
&2.2111E+00_JPRB,1.8498E+00_JPRB,1.2644E+00_JPRB/)
KAO( :, 4,10,10) = (/&
&2.7579E+00_JPRB,2.8520E+00_JPRB,2.8806E+00_JPRB,2.8506E+00_JPRB,2.7323E+00_JPRB,2.5633E+00_JPRB,&
&2.3644E+00_JPRB,2.0104E+00_JPRB,1.4137E+00_JPRB/)
KAO( :, 5,10,10) = (/&
&2.8173E+00_JPRB,2.9491E+00_JPRB,2.9936E+00_JPRB,2.9898E+00_JPRB,2.8664E+00_JPRB,2.7018E+00_JPRB,&
&2.5230E+00_JPRB,2.1562E+00_JPRB,1.5648E+00_JPRB/)
KAO( :, 1,11,10) = (/&
&2.4512E+00_JPRB,2.4863E+00_JPRB,2.4335E+00_JPRB,2.3107E+00_JPRB,2.1733E+00_JPRB,1.9977E+00_JPRB,&
&1.7582E+00_JPRB,1.4416E+00_JPRB,8.5970E-01_JPRB/)
KAO( :, 2,11,10) = (/&
&2.5092E+00_JPRB,2.5823E+00_JPRB,2.5374E+00_JPRB,2.4481E+00_JPRB,2.3213E+00_JPRB,2.1404E+00_JPRB,&
&1.9153E+00_JPRB,1.5898E+00_JPRB,9.9211E-01_JPRB/)
KAO( :, 3,11,10) = (/&
&2.5638E+00_JPRB,2.6670E+00_JPRB,2.6481E+00_JPRB,2.5840E+00_JPRB,2.4592E+00_JPRB,2.2850E+00_JPRB,&
&2.0595E+00_JPRB,1.7358E+00_JPRB,1.1287E+00_JPRB/)
KAO( :, 4,11,10) = (/&
&2.6180E+00_JPRB,2.7488E+00_JPRB,2.7545E+00_JPRB,2.7101E+00_JPRB,2.5960E+00_JPRB,2.4226E+00_JPRB,&
&2.2050E+00_JPRB,1.8751E+00_JPRB,1.2713E+00_JPRB/)
KAO( :, 5,11,10) = (/&
&2.6708E+00_JPRB,2.8308E+00_JPRB,2.8655E+00_JPRB,2.8311E+00_JPRB,2.7233E+00_JPRB,2.5640E+00_JPRB,&
&2.3410E+00_JPRB,2.0028E+00_JPRB,1.4162E+00_JPRB/)
KAO( :, 1,12,10) = (/&
&2.2798E+00_JPRB,2.3643E+00_JPRB,2.3131E+00_JPRB,2.2090E+00_JPRB,2.0595E+00_JPRB,1.8678E+00_JPRB,&
&1.6491E+00_JPRB,1.3284E+00_JPRB,7.5824E-01_JPRB/)
KAO( :, 2,12,10) = (/&
&2.3366E+00_JPRB,2.4475E+00_JPRB,2.4167E+00_JPRB,2.3329E+00_JPRB,2.1840E+00_JPRB,2.0081E+00_JPRB,&
&1.7907E+00_JPRB,1.4613E+00_JPRB,8.7475E-01_JPRB/)
KAO( :, 3,12,10) = (/&
&2.3890E+00_JPRB,2.5244E+00_JPRB,2.5206E+00_JPRB,2.4421E+00_JPRB,2.3136E+00_JPRB,2.1465E+00_JPRB,&
&1.9227E+00_JPRB,1.5932E+00_JPRB,9.9953E-01_JPRB/)
KAO( :, 4,12,10) = (/&
&2.4374E+00_JPRB,2.6016E+00_JPRB,2.6217E+00_JPRB,2.5543E+00_JPRB,2.4367E+00_JPRB,2.2813E+00_JPRB,&
&2.0490E+00_JPRB,1.7139E+00_JPRB,1.1310E+00_JPRB/)
KAO( :, 5,12,10) = (/&
&2.4838E+00_JPRB,2.6702E+00_JPRB,2.7195E+00_JPRB,2.6584E+00_JPRB,2.5615E+00_JPRB,2.4117E+00_JPRB,&
&2.1613E+00_JPRB,1.8334E+00_JPRB,1.2595E+00_JPRB/)
KAO( :, 1,13,10) = (/&
&2.0791E+00_JPRB,2.1960E+00_JPRB,2.1642E+00_JPRB,2.0798E+00_JPRB,1.9340E+00_JPRB,1.7492E+00_JPRB,&
&1.5316E+00_JPRB,1.2117E+00_JPRB,6.7239E-01_JPRB/)
KAO( :, 2,13,10) = (/&
&2.1335E+00_JPRB,2.2729E+00_JPRB,2.2653E+00_JPRB,2.1865E+00_JPRB,2.0515E+00_JPRB,1.8780E+00_JPRB,&
&1.6557E+00_JPRB,1.3290E+00_JPRB,7.8385E-01_JPRB/)
KAO( :, 3,13,10) = (/&
&2.1832E+00_JPRB,2.3472E+00_JPRB,2.3626E+00_JPRB,2.2909E+00_JPRB,2.1703E+00_JPRB,1.9998E+00_JPRB,&
&1.7751E+00_JPRB,1.4395E+00_JPRB,8.9988E-01_JPRB/)
KAO( :, 4,13,10) = (/&
&2.2317E+00_JPRB,2.4190E+00_JPRB,2.4536E+00_JPRB,2.3945E+00_JPRB,2.2843E+00_JPRB,2.1191E+00_JPRB,&
&1.8849E+00_JPRB,1.5486E+00_JPRB,1.0181E+00_JPRB/)
KAO( :, 5,13,10) = (/&
&2.2928E+00_JPRB,2.4912E+00_JPRB,2.5411E+00_JPRB,2.4970E+00_JPRB,2.3950E+00_JPRB,2.2262E+00_JPRB,&
&1.9945E+00_JPRB,1.6570E+00_JPRB,1.1340E+00_JPRB/)
KAO( :, 1, 1,11) = (/&
&5.1188E+00_JPRB,4.4962E+00_JPRB,4.1898E+00_JPRB,4.1232E+00_JPRB,3.8282E+00_JPRB,3.7520E+00_JPRB,&
&3.8632E+00_JPRB,3.7314E+00_JPRB,4.2299E+00_JPRB/)
KAO( :, 2, 1,11) = (/&
&5.2357E+00_JPRB,4.6021E+00_JPRB,4.3195E+00_JPRB,4.2578E+00_JPRB,3.9916E+00_JPRB,3.9872E+00_JPRB,&
&4.0538E+00_JPRB,3.9583E+00_JPRB,4.4896E+00_JPRB/)
KAO( :, 3, 1,11) = (/&
&5.3431E+00_JPRB,4.6995E+00_JPRB,4.4290E+00_JPRB,4.3921E+00_JPRB,4.1757E+00_JPRB,4.2052E+00_JPRB,&
&4.1799E+00_JPRB,4.1518E+00_JPRB,4.7182E+00_JPRB/)
KAO( :, 4, 1,11) = (/&
&5.4410E+00_JPRB,4.7855E+00_JPRB,4.5302E+00_JPRB,4.5043E+00_JPRB,4.3792E+00_JPRB,4.3589E+00_JPRB,&
&4.2659E+00_JPRB,4.3498E+00_JPRB,4.9265E+00_JPRB/)
KAO( :, 5, 1,11) = (/&
&5.5309E+00_JPRB,4.8636E+00_JPRB,4.6308E+00_JPRB,4.6226E+00_JPRB,4.5553E+00_JPRB,4.4731E+00_JPRB,&
&4.3313E+00_JPRB,4.5563E+00_JPRB,5.1476E+00_JPRB/)
KAO( :, 1, 2,11) = (/&
&5.3830E+00_JPRB,4.7598E+00_JPRB,4.5038E+00_JPRB,4.4124E+00_JPRB,4.1256E+00_JPRB,3.9352E+00_JPRB,&
&3.9288E+00_JPRB,3.6529E+00_JPRB,4.1533E+00_JPRB/)
KAO( :, 2, 2,11) = (/&
&5.5093E+00_JPRB,4.8746E+00_JPRB,4.6320E+00_JPRB,4.5446E+00_JPRB,4.3075E+00_JPRB,4.1643E+00_JPRB,&
&4.1158E+00_JPRB,3.8793E+00_JPRB,4.4270E+00_JPRB/)
KAO( :, 3, 2,11) = (/&
&5.6175E+00_JPRB,4.9740E+00_JPRB,4.7438E+00_JPRB,4.6765E+00_JPRB,4.5041E+00_JPRB,4.3624E+00_JPRB,&
&4.2461E+00_JPRB,4.1118E+00_JPRB,4.6851E+00_JPRB/)
KAO( :, 4, 2,11) = (/&
&5.7157E+00_JPRB,5.0593E+00_JPRB,4.8530E+00_JPRB,4.7924E+00_JPRB,4.7291E+00_JPRB,4.5102E+00_JPRB,&
&4.3461E+00_JPRB,4.3454E+00_JPRB,4.9401E+00_JPRB/)
KAO( :, 5, 2,11) = (/&
&5.8004E+00_JPRB,5.1349E+00_JPRB,4.9550E+00_JPRB,4.9255E+00_JPRB,4.9201E+00_JPRB,4.6238E+00_JPRB,&
&4.4516E+00_JPRB,4.5890E+00_JPRB,5.2057E+00_JPRB/)
KAO( :, 1, 3,11) = (/&
&5.5164E+00_JPRB,4.9212E+00_JPRB,4.7297E+00_JPRB,4.6037E+00_JPRB,4.3740E+00_JPRB,4.1348E+00_JPRB,&
&3.8407E+00_JPRB,3.5074E+00_JPRB,3.9068E+00_JPRB/)
KAO( :, 2, 3,11) = (/&
&5.6457E+00_JPRB,5.0403E+00_JPRB,4.8708E+00_JPRB,4.7481E+00_JPRB,4.5713E+00_JPRB,4.3408E+00_JPRB,&
&4.0590E+00_JPRB,3.7279E+00_JPRB,4.2270E+00_JPRB/)
KAO( :, 3, 3,11) = (/&
&5.7648E+00_JPRB,5.1472E+00_JPRB,4.9917E+00_JPRB,4.8917E+00_JPRB,4.7668E+00_JPRB,4.5432E+00_JPRB,&
&4.2248E+00_JPRB,3.9671E+00_JPRB,4.5272E+00_JPRB/)
KAO( :, 4, 3,11) = (/&
&5.8726E+00_JPRB,5.2450E+00_JPRB,5.1073E+00_JPRB,5.0262E+00_JPRB,4.9765E+00_JPRB,4.7078E+00_JPRB,&
&4.3673E+00_JPRB,4.2265E+00_JPRB,4.8206E+00_JPRB/)
KAO( :, 5, 3,11) = (/&
&5.9741E+00_JPRB,5.3354E+00_JPRB,5.2185E+00_JPRB,5.1809E+00_JPRB,5.1510E+00_JPRB,4.8375E+00_JPRB,&
&4.4951E+00_JPRB,4.4978E+00_JPRB,5.1274E+00_JPRB/)
KAO( :, 1, 4,11) = (/&
&5.5586E+00_JPRB,4.9938E+00_JPRB,4.8775E+00_JPRB,4.7228E+00_JPRB,4.5678E+00_JPRB,4.2888E+00_JPRB,&
&3.7572E+00_JPRB,3.3686E+00_JPRB,3.6371E+00_JPRB/)
KAO( :, 2, 4,11) = (/&
&5.7048E+00_JPRB,5.1254E+00_JPRB,5.0246E+00_JPRB,4.8865E+00_JPRB,4.7638E+00_JPRB,4.4945E+00_JPRB,&
&3.9733E+00_JPRB,3.5886E+00_JPRB,3.9962E+00_JPRB/)
KAO( :, 3, 4,11) = (/&
&5.8381E+00_JPRB,5.2468E+00_JPRB,5.1587E+00_JPRB,5.0517E+00_JPRB,4.9564E+00_JPRB,4.6974E+00_JPRB,&
&4.1859E+00_JPRB,3.8140E+00_JPRB,4.3209E+00_JPRB/)
KAO( :, 4, 4,11) = (/&
&5.9605E+00_JPRB,5.3609E+00_JPRB,5.2847E+00_JPRB,5.2114E+00_JPRB,5.1284E+00_JPRB,4.8993E+00_JPRB,&
&4.3580E+00_JPRB,4.0704E+00_JPRB,4.6439E+00_JPRB/)
KAO( :, 5, 4,11) = (/&
&6.0637E+00_JPRB,5.4599E+00_JPRB,5.4065E+00_JPRB,5.3711E+00_JPRB,5.2958E+00_JPRB,5.0595E+00_JPRB,&
&4.5112E+00_JPRB,4.3517E+00_JPRB,4.9660E+00_JPRB/)
KAO( :, 1, 5,11) = (/&
&5.5140E+00_JPRB,4.9813E+00_JPRB,4.9335E+00_JPRB,4.7913E+00_JPRB,4.6774E+00_JPRB,4.3710E+00_JPRB,&
&3.7530E+00_JPRB,3.2477E+00_JPRB,3.3634E+00_JPRB/)
KAO( :, 2, 5,11) = (/&
&5.6664E+00_JPRB,5.1255E+00_JPRB,5.1035E+00_JPRB,4.9717E+00_JPRB,4.8774E+00_JPRB,4.5859E+00_JPRB,&
&3.9668E+00_JPRB,3.4677E+00_JPRB,3.7405E+00_JPRB/)
KAO( :, 3, 5,11) = (/&
&5.8011E+00_JPRB,5.2612E+00_JPRB,5.2545E+00_JPRB,5.1514E+00_JPRB,5.0632E+00_JPRB,4.7735E+00_JPRB,&
&4.2022E+00_JPRB,3.6795E+00_JPRB,4.0879E+00_JPRB/)
KAO( :, 4, 5,11) = (/&
&5.9195E+00_JPRB,5.3879E+00_JPRB,5.3990E+00_JPRB,5.3253E+00_JPRB,5.2340E+00_JPRB,4.9702E+00_JPRB,&
&4.4129E+00_JPRB,3.9016E+00_JPRB,4.4176E+00_JPRB/)
KAO( :, 5, 5,11) = (/&
&6.0324E+00_JPRB,5.5030E+00_JPRB,5.5351E+00_JPRB,5.4951E+00_JPRB,5.4012E+00_JPRB,5.1456E+00_JPRB,&
&4.5860E+00_JPRB,4.1610E+00_JPRB,4.7497E+00_JPRB/)
KAO( :, 1, 6,11) = (/&
&5.3460E+00_JPRB,4.8907E+00_JPRB,4.9037E+00_JPRB,4.7959E+00_JPRB,4.6720E+00_JPRB,4.3428E+00_JPRB,&
&3.7532E+00_JPRB,3.0728E+00_JPRB,3.0483E+00_JPRB/)
KAO( :, 2, 6,11) = (/&
&5.5016E+00_JPRB,5.0576E+00_JPRB,5.0845E+00_JPRB,4.9968E+00_JPRB,4.8768E+00_JPRB,4.5629E+00_JPRB,&
&3.9805E+00_JPRB,3.3257E+00_JPRB,3.4138E+00_JPRB/)
KAO( :, 3, 6,11) = (/&
&5.6458E+00_JPRB,5.2128E+00_JPRB,5.2471E+00_JPRB,5.1892E+00_JPRB,5.0839E+00_JPRB,4.7513E+00_JPRB,&
&4.2341E+00_JPRB,3.5158E+00_JPRB,3.7567E+00_JPRB/)
KAO( :, 4, 6,11) = (/&
&5.7776E+00_JPRB,5.3547E+00_JPRB,5.4002E+00_JPRB,5.3806E+00_JPRB,5.2566E+00_JPRB,4.9480E+00_JPRB,&
&4.4656E+00_JPRB,3.7111E+00_JPRB,4.0913E+00_JPRB/)
KAO( :, 5, 6,11) = (/&
&5.8886E+00_JPRB,5.4776E+00_JPRB,5.5415E+00_JPRB,5.5583E+00_JPRB,5.4285E+00_JPRB,5.1330E+00_JPRB,&
&4.6590E+00_JPRB,3.9360E+00_JPRB,4.4349E+00_JPRB/)
KAO( :, 1, 7,11) = (/&
&5.0900E+00_JPRB,4.7460E+00_JPRB,4.7704E+00_JPRB,4.7424E+00_JPRB,4.5661E+00_JPRB,4.2208E+00_JPRB,&
&3.7025E+00_JPRB,2.9233E+00_JPRB,2.7128E+00_JPRB/)
KAO( :, 2, 7,11) = (/&
&5.2495E+00_JPRB,4.9306E+00_JPRB,4.9678E+00_JPRB,4.9514E+00_JPRB,4.7835E+00_JPRB,4.4516E+00_JPRB,&
&3.9503E+00_JPRB,3.1699E+00_JPRB,3.0368E+00_JPRB/)
KAO( :, 3, 7,11) = (/&
&5.3908E+00_JPRB,5.0938E+00_JPRB,5.1429E+00_JPRB,5.1559E+00_JPRB,4.9966E+00_JPRB,4.6413E+00_JPRB,&
&4.2020E+00_JPRB,3.3718E+00_JPRB,3.3561E+00_JPRB/)
KAO( :, 4, 7,11) = (/&
&5.5155E+00_JPRB,5.2363E+00_JPRB,5.3032E+00_JPRB,5.3596E+00_JPRB,5.1777E+00_JPRB,4.8555E+00_JPRB,&
&4.4333E+00_JPRB,3.5353E+00_JPRB,3.6838E+00_JPRB/)
KAO( :, 5, 7,11) = (/&
&5.6325E+00_JPRB,5.3617E+00_JPRB,5.4630E+00_JPRB,5.5298E+00_JPRB,5.3705E+00_JPRB,5.0766E+00_JPRB,&
&4.6290E+00_JPRB,3.7252E+00_JPRB,4.0295E+00_JPRB/)
KAO( :, 1, 8,11) = (/&
&4.7924E+00_JPRB,4.5440E+00_JPRB,4.5871E+00_JPRB,4.5972E+00_JPRB,4.3821E+00_JPRB,4.0282E+00_JPRB,&
&3.5782E+00_JPRB,2.8267E+00_JPRB,2.3643E+00_JPRB/)
KAO( :, 2, 8,11) = (/&
&4.9458E+00_JPRB,4.7238E+00_JPRB,4.7983E+00_JPRB,4.8145E+00_JPRB,4.6002E+00_JPRB,4.2694E+00_JPRB,&
&3.8266E+00_JPRB,3.0607E+00_JPRB,2.6625E+00_JPRB/)
KAO( :, 3, 8,11) = (/&
&5.0872E+00_JPRB,4.8848E+00_JPRB,4.9881E+00_JPRB,5.0206E+00_JPRB,4.8258E+00_JPRB,4.4891E+00_JPRB,&
&4.0830E+00_JPRB,3.2647E+00_JPRB,2.9566E+00_JPRB/)
KAO( :, 4, 8,11) = (/&
&5.2177E+00_JPRB,5.0262E+00_JPRB,5.1648E+00_JPRB,5.2193E+00_JPRB,5.0190E+00_JPRB,4.7309E+00_JPRB,&
&4.3124E+00_JPRB,3.4443E+00_JPRB,3.2673E+00_JPRB/)
KAO( :, 5, 8,11) = (/&
&5.3303E+00_JPRB,5.1466E+00_JPRB,5.3381E+00_JPRB,5.3870E+00_JPRB,5.2200E+00_JPRB,4.9620E+00_JPRB,&
&4.5031E+00_JPRB,3.6204E+00_JPRB,3.6052E+00_JPRB/)
KAO( :, 1, 9,11) = (/&
&4.5347E+00_JPRB,4.3328E+00_JPRB,4.3689E+00_JPRB,4.3513E+00_JPRB,4.1174E+00_JPRB,3.7868E+00_JPRB,&
&3.3737E+00_JPRB,2.7015E+00_JPRB,2.0218E+00_JPRB/)
KAO( :, 2, 9,11) = (/&
&4.6866E+00_JPRB,4.5049E+00_JPRB,4.5898E+00_JPRB,4.5628E+00_JPRB,4.3507E+00_JPRB,4.0425E+00_JPRB,&
&3.6252E+00_JPRB,2.9347E+00_JPRB,2.3048E+00_JPRB/)
KAO( :, 3, 9,11) = (/&
&4.8251E+00_JPRB,4.6663E+00_JPRB,4.7848E+00_JPRB,4.7704E+00_JPRB,4.5826E+00_JPRB,4.2849E+00_JPRB,&
&3.8759E+00_JPRB,3.1451E+00_JPRB,2.5879E+00_JPRB/)
KAO( :, 4, 9,11) = (/&
&4.9503E+00_JPRB,4.8087E+00_JPRB,4.9642E+00_JPRB,4.9727E+00_JPRB,4.7915E+00_JPRB,4.5387E+00_JPRB,&
&4.1015E+00_JPRB,3.3321E+00_JPRB,2.8859E+00_JPRB/)
KAO( :, 5, 9,11) = (/&
&5.0642E+00_JPRB,4.9400E+00_JPRB,5.1410E+00_JPRB,5.1452E+00_JPRB,5.0116E+00_JPRB,4.7755E+00_JPRB,&
&4.3020E+00_JPRB,3.5123E+00_JPRB,3.1955E+00_JPRB/)
KAO( :, 1,10,11) = (/&
&4.3141E+00_JPRB,4.1481E+00_JPRB,4.1872E+00_JPRB,4.0732E+00_JPRB,3.8258E+00_JPRB,3.5260E+00_JPRB,&
&3.1443E+00_JPRB,2.5485E+00_JPRB,1.7391E+00_JPRB/)
KAO( :, 2,10,11) = (/&
&4.4657E+00_JPRB,4.3291E+00_JPRB,4.4068E+00_JPRB,4.2778E+00_JPRB,4.0645E+00_JPRB,3.7865E+00_JPRB,&
&3.3989E+00_JPRB,2.7666E+00_JPRB,2.0042E+00_JPRB/)
KAO( :, 3,10,11) = (/&
&4.6073E+00_JPRB,4.4901E+00_JPRB,4.5937E+00_JPRB,4.4815E+00_JPRB,4.3022E+00_JPRB,4.0396E+00_JPRB,&
&3.6341E+00_JPRB,2.9783E+00_JPRB,2.2696E+00_JPRB/)
KAO( :, 4,10,11) = (/&
&4.7332E+00_JPRB,4.6441E+00_JPRB,4.7670E+00_JPRB,4.6811E+00_JPRB,4.5263E+00_JPRB,4.2880E+00_JPRB,&
&3.8564E+00_JPRB,3.1687E+00_JPRB,2.5448E+00_JPRB/)
KAO( :, 5,10,11) = (/&
&4.8482E+00_JPRB,4.7816E+00_JPRB,4.9366E+00_JPRB,4.8606E+00_JPRB,4.7563E+00_JPRB,4.5121E+00_JPRB,&
&4.0582E+00_JPRB,3.3600E+00_JPRB,2.8205E+00_JPRB/)
KAO( :, 1,11,11) = (/&
&4.1814E+00_JPRB,4.0541E+00_JPRB,4.0844E+00_JPRB,3.9070E+00_JPRB,3.6510E+00_JPRB,3.3593E+00_JPRB,&
&3.0020E+00_JPRB,2.4435E+00_JPRB,1.5974E+00_JPRB/)
KAO( :, 2,11,11) = (/&
&4.3118E+00_JPRB,4.2274E+00_JPRB,4.2869E+00_JPRB,4.1141E+00_JPRB,3.8852E+00_JPRB,3.6134E+00_JPRB,&
&3.2400E+00_JPRB,2.6533E+00_JPRB,1.8419E+00_JPRB/)
KAO( :, 3,11,11) = (/&
&4.4319E+00_JPRB,4.3935E+00_JPRB,4.4651E+00_JPRB,4.3182E+00_JPRB,4.1137E+00_JPRB,3.8517E+00_JPRB,&
&3.4603E+00_JPRB,2.8608E+00_JPRB,2.0902E+00_JPRB/)
KAO( :, 4,11,11) = (/&
&4.5390E+00_JPRB,4.5400E+00_JPRB,4.6448E+00_JPRB,4.5087E+00_JPRB,4.3372E+00_JPRB,4.0750E+00_JPRB,&
&3.6707E+00_JPRB,3.0507E+00_JPRB,2.3393E+00_JPRB/)
KAO( :, 5,11,11) = (/&
&4.6299E+00_JPRB,4.6729E+00_JPRB,4.7998E+00_JPRB,4.6995E+00_JPRB,4.5508E+00_JPRB,4.2784E+00_JPRB,&
&3.8764E+00_JPRB,3.2454E+00_JPRB,2.5677E+00_JPRB/)
KAO( :, 1,12,11) = (/&
&4.0099E+00_JPRB,3.9422E+00_JPRB,3.9403E+00_JPRB,3.7407E+00_JPRB,3.4918E+00_JPRB,3.1976E+00_JPRB,&
&2.8203E+00_JPRB,2.3020E+00_JPRB,1.4455E+00_JPRB/)
KAO( :, 2,12,11) = (/&
&4.1176E+00_JPRB,4.1055E+00_JPRB,4.1224E+00_JPRB,3.9486E+00_JPRB,3.7245E+00_JPRB,3.4270E+00_JPRB,&
&3.0337E+00_JPRB,2.5124E+00_JPRB,1.6679E+00_JPRB/)
KAO( :, 3,12,11) = (/&
&4.2129E+00_JPRB,4.2545E+00_JPRB,4.2966E+00_JPRB,4.1603E+00_JPRB,3.9419E+00_JPRB,3.6332E+00_JPRB,&
&3.2538E+00_JPRB,2.7031E+00_JPRB,1.8904E+00_JPRB/)
KAO( :, 4,12,11) = (/&
&4.2979E+00_JPRB,4.3881E+00_JPRB,4.4616E+00_JPRB,4.3568E+00_JPRB,4.1443E+00_JPRB,3.8364E+00_JPRB,&
&3.4615E+00_JPRB,2.8971E+00_JPRB,2.1003E+00_JPRB/)
KAO( :, 5,12,11) = (/&
&4.3757E+00_JPRB,4.5140E+00_JPRB,4.6083E+00_JPRB,4.5481E+00_JPRB,4.3321E+00_JPRB,4.0278E+00_JPRB,&
&3.6672E+00_JPRB,3.0746E+00_JPRB,2.3111E+00_JPRB/)
KAO( :, 1,13,11) = (/&
&3.8115E+00_JPRB,3.8123E+00_JPRB,3.7564E+00_JPRB,3.5672E+00_JPRB,3.3321E+00_JPRB,3.0260E+00_JPRB,&
&2.6276E+00_JPRB,2.1465E+00_JPRB,1.2822E+00_JPRB/)
KAO( :, 2,13,11) = (/&
&3.9006E+00_JPRB,3.9563E+00_JPRB,3.9216E+00_JPRB,3.7726E+00_JPRB,3.5504E+00_JPRB,3.2297E+00_JPRB,&
&2.8365E+00_JPRB,2.3385E+00_JPRB,1.4776E+00_JPRB/)
KAO( :, 3,13,11) = (/&
&3.9788E+00_JPRB,4.0838E+00_JPRB,4.0868E+00_JPRB,3.9664E+00_JPRB,3.7467E+00_JPRB,3.4326E+00_JPRB,&
&3.0397E+00_JPRB,2.5221E+00_JPRB,1.6670E+00_JPRB/)
KAO( :, 4,13,11) = (/&
&4.0518E+00_JPRB,4.2003E+00_JPRB,4.2397E+00_JPRB,4.1476E+00_JPRB,3.9371E+00_JPRB,3.6284E+00_JPRB,&
&3.2340E+00_JPRB,2.6989E+00_JPRB,1.8578E+00_JPRB/)
KAO( :, 5,13,11) = (/&
&4.1173E+00_JPRB,4.3105E+00_JPRB,4.3846E+00_JPRB,4.3176E+00_JPRB,4.1129E+00_JPRB,3.8156E+00_JPRB,&
&3.4246E+00_JPRB,2.8636E+00_JPRB,2.0525E+00_JPRB/)
KAO( :, 1, 1,12) = (/&
&7.0750E+00_JPRB,6.1912E+00_JPRB,5.5399E+00_JPRB,5.3350E+00_JPRB,5.4706E+00_JPRB,5.3762E+00_JPRB,&
&5.1145E+00_JPRB,5.3782E+00_JPRB,6.0148E+00_JPRB/)
KAO( :, 2, 1,12) = (/&
&7.2687E+00_JPRB,6.3607E+00_JPRB,5.6891E+00_JPRB,5.4701E+00_JPRB,5.6126E+00_JPRB,5.5473E+00_JPRB,&
&5.2734E+00_JPRB,5.8115E+00_JPRB,6.4886E+00_JPRB/)
KAO( :, 3, 1,12) = (/&
&7.4429E+00_JPRB,6.5131E+00_JPRB,5.8367E+00_JPRB,5.5928E+00_JPRB,5.7515E+00_JPRB,5.7097E+00_JPRB,&
&5.5260E+00_JPRB,6.2806E+00_JPRB,6.9951E+00_JPRB/)
KAO( :, 4, 1,12) = (/&
&7.6028E+00_JPRB,6.6530E+00_JPRB,5.9756E+00_JPRB,5.7243E+00_JPRB,5.8730E+00_JPRB,5.9264E+00_JPRB,&
&5.8242E+00_JPRB,6.7348E+00_JPRB,7.5240E+00_JPRB/)
KAO( :, 5, 1,12) = (/&
&7.7448E+00_JPRB,6.7771E+00_JPRB,6.1045E+00_JPRB,5.8318E+00_JPRB,6.0223E+00_JPRB,6.1431E+00_JPRB,&
&6.1145E+00_JPRB,7.1272E+00_JPRB,7.9899E+00_JPRB/)
KAO( :, 1, 2,12) = (/&
&7.7545E+00_JPRB,6.7857E+00_JPRB,6.1014E+00_JPRB,5.8641E+00_JPRB,5.6627E+00_JPRB,5.4924E+00_JPRB,&
&5.3064E+00_JPRB,5.5478E+00_JPRB,6.2448E+00_JPRB/)
KAO( :, 2, 2,12) = (/&
&7.9626E+00_JPRB,6.9679E+00_JPRB,6.2884E+00_JPRB,6.0331E+00_JPRB,5.8184E+00_JPRB,5.6805E+00_JPRB,&
&5.5037E+00_JPRB,5.9946E+00_JPRB,6.7468E+00_JPRB/)
KAO( :, 3, 2,12) = (/&
&8.1571E+00_JPRB,7.1382E+00_JPRB,6.4613E+00_JPRB,6.1841E+00_JPRB,5.9708E+00_JPRB,5.8941E+00_JPRB,&
&5.7532E+00_JPRB,6.4635E+00_JPRB,7.2816E+00_JPRB/)
KAO( :, 4, 2,12) = (/&
&8.3326E+00_JPRB,7.2918E+00_JPRB,6.6225E+00_JPRB,6.3365E+00_JPRB,6.0835E+00_JPRB,6.1383E+00_JPRB,&
&6.0067E+00_JPRB,6.8804E+00_JPRB,7.7820E+00_JPRB/)
KAO( :, 5, 2,12) = (/&
&8.4888E+00_JPRB,7.4285E+00_JPRB,6.7684E+00_JPRB,6.4625E+00_JPRB,6.2260E+00_JPRB,6.3461E+00_JPRB,&
&6.2452E+00_JPRB,7.2451E+00_JPRB,8.2111E+00_JPRB/)
KAO( :, 1, 3,12) = (/&
&8.3602E+00_JPRB,7.3163E+00_JPRB,6.6388E+00_JPRB,6.3825E+00_JPRB,5.9192E+00_JPRB,5.5791E+00_JPRB,&
&5.5047E+00_JPRB,5.5786E+00_JPRB,6.3479E+00_JPRB/)
KAO( :, 2, 3,12) = (/&
&8.5890E+00_JPRB,7.5183E+00_JPRB,6.8453E+00_JPRB,6.5628E+00_JPRB,6.0922E+00_JPRB,5.8078E+00_JPRB,&
&5.7041E+00_JPRB,6.0248E+00_JPRB,6.8536E+00_JPRB/)
KAO( :, 3, 3,12) = (/&
&8.7942E+00_JPRB,7.6989E+00_JPRB,7.0385E+00_JPRB,6.7230E+00_JPRB,6.2576E+00_JPRB,6.0242E+00_JPRB,&
&5.9018E+00_JPRB,6.4818E+00_JPRB,7.3747E+00_JPRB/)
KAO( :, 4, 3,12) = (/&
&8.9740E+00_JPRB,7.8579E+00_JPRB,7.2067E+00_JPRB,6.8812E+00_JPRB,6.4038E+00_JPRB,6.2630E+00_JPRB,&
&6.1272E+00_JPRB,6.9158E+00_JPRB,7.8669E+00_JPRB/)
KAO( :, 5, 3,12) = (/&
&9.1236E+00_JPRB,7.9895E+00_JPRB,7.3566E+00_JPRB,7.0154E+00_JPRB,6.5927E+00_JPRB,6.4547E+00_JPRB,&
&6.3294E+00_JPRB,7.2767E+00_JPRB,8.2820E+00_JPRB/)
KAO( :, 1, 4,12) = (/&
&8.8847E+00_JPRB,7.7960E+00_JPRB,7.1075E+00_JPRB,6.8009E+00_JPRB,6.2444E+00_JPRB,5.7477E+00_JPRB,&
&5.6301E+00_JPRB,5.4141E+00_JPRB,6.1834E+00_JPRB/)
KAO( :, 2, 4,12) = (/&
&9.1116E+00_JPRB,7.9999E+00_JPRB,7.3356E+00_JPRB,7.0007E+00_JPRB,6.4482E+00_JPRB,5.9737E+00_JPRB,&
&5.8408E+00_JPRB,5.8678E+00_JPRB,6.6961E+00_JPRB/)
KAO( :, 3, 4,12) = (/&
&9.3094E+00_JPRB,8.1759E+00_JPRB,7.5373E+00_JPRB,7.1726E+00_JPRB,6.6509E+00_JPRB,6.2012E+00_JPRB,&
&5.9911E+00_JPRB,6.3277E+00_JPRB,7.2196E+00_JPRB/)
KAO( :, 4, 4,12) = (/&
&9.4683E+00_JPRB,8.3188E+00_JPRB,7.7174E+00_JPRB,7.3409E+00_JPRB,6.8481E+00_JPRB,6.3961E+00_JPRB,&
&6.1664E+00_JPRB,6.7597E+00_JPRB,7.7146E+00_JPRB/)
KAO( :, 5, 4,12) = (/&
&9.6042E+00_JPRB,8.4435E+00_JPRB,7.8581E+00_JPRB,7.4916E+00_JPRB,7.0560E+00_JPRB,6.5810E+00_JPRB,&
&6.3225E+00_JPRB,7.1406E+00_JPRB,8.1513E+00_JPRB/)
KAO( :, 1, 5,12) = (/&
&9.2292E+00_JPRB,8.1377E+00_JPRB,7.4945E+00_JPRB,7.1495E+00_JPRB,6.5484E+00_JPRB,5.9913E+00_JPRB,&
&5.6165E+00_JPRB,5.1149E+00_JPRB,5.8309E+00_JPRB/)
KAO( :, 2, 5,12) = (/&
&9.4577E+00_JPRB,8.3475E+00_JPRB,7.7472E+00_JPRB,7.3686E+00_JPRB,6.7878E+00_JPRB,6.2469E+00_JPRB,&
&5.8285E+00_JPRB,5.5605E+00_JPRB,6.3475E+00_JPRB/)
KAO( :, 3, 5,12) = (/&
&9.6601E+00_JPRB,8.5348E+00_JPRB,7.9661E+00_JPRB,7.5611E+00_JPRB,7.0335E+00_JPRB,6.4923E+00_JPRB,&
&5.9827E+00_JPRB,5.9978E+00_JPRB,6.8470E+00_JPRB/)
KAO( :, 4, 5,12) = (/&
&9.8370E+00_JPRB,8.6956E+00_JPRB,8.1396E+00_JPRB,7.7502E+00_JPRB,7.2566E+00_JPRB,6.6903E+00_JPRB,&
&6.1155E+00_JPRB,6.4492E+00_JPRB,7.3614E+00_JPRB/)
KAO( :, 5, 5,12) = (/&
&9.9720E+00_JPRB,8.8165E+00_JPRB,8.2799E+00_JPRB,7.9327E+00_JPRB,7.4895E+00_JPRB,6.8872E+00_JPRB,&
&6.2655E+00_JPRB,6.8604E+00_JPRB,7.8326E+00_JPRB/)
KAO( :, 1, 6,12) = (/&
&9.4228E+00_JPRB,8.3583E+00_JPRB,7.7791E+00_JPRB,7.3895E+00_JPRB,6.8260E+00_JPRB,6.2621E+00_JPRB,&
&5.5219E+00_JPRB,4.8043E+00_JPRB,5.3717E+00_JPRB/)
KAO( :, 2, 6,12) = (/&
&9.6680E+00_JPRB,8.5862E+00_JPRB,8.0441E+00_JPRB,7.6459E+00_JPRB,7.1022E+00_JPRB,6.5301E+00_JPRB,&
&5.7540E+00_JPRB,5.1597E+00_JPRB,5.8750E+00_JPRB/)
KAO( :, 3, 6,12) = (/&
&9.8647E+00_JPRB,8.7696E+00_JPRB,8.2709E+00_JPRB,7.8751E+00_JPRB,7.3582E+00_JPRB,6.7963E+00_JPRB,&
&5.9278E+00_JPRB,5.6000E+00_JPRB,6.3870E+00_JPRB/)
KAO( :, 4, 6,12) = (/&
&1.0026E+01_JPRB,8.9182E+00_JPRB,8.4588E+00_JPRB,8.0791E+00_JPRB,7.6205E+00_JPRB,7.0216E+00_JPRB,&
&6.0965E+00_JPRB,6.0596E+00_JPRB,6.9174E+00_JPRB/)
KAO( :, 5, 6,12) = (/&
&1.0167E+01_JPRB,9.0497E+00_JPRB,8.6148E+00_JPRB,8.2660E+00_JPRB,7.8544E+00_JPRB,7.2260E+00_JPRB,&
&6.2428E+00_JPRB,6.4815E+00_JPRB,7.4016E+00_JPRB/)
KAO( :, 1, 7,12) = (/&
&9.4277E+00_JPRB,8.4150E+00_JPRB,7.9357E+00_JPRB,7.5305E+00_JPRB,7.0405E+00_JPRB,6.4321E+00_JPRB,&
&5.4684E+00_JPRB,4.5169E+00_JPRB,4.8723E+00_JPRB/)
KAO( :, 2, 7,12) = (/&
&9.6610E+00_JPRB,8.6378E+00_JPRB,8.2182E+00_JPRB,7.8169E+00_JPRB,7.3595E+00_JPRB,6.7122E+00_JPRB,&
&5.7318E+00_JPRB,4.8302E+00_JPRB,5.4033E+00_JPRB/)
KAO( :, 3, 7,12) = (/&
&9.8776E+00_JPRB,8.8386E+00_JPRB,8.4643E+00_JPRB,8.0697E+00_JPRB,7.6404E+00_JPRB,7.0024E+00_JPRB,&
&5.9545E+00_JPRB,5.2084E+00_JPRB,5.9332E+00_JPRB/)
KAO( :, 4, 7,12) = (/&
&1.0065E+01_JPRB,9.0111E+00_JPRB,8.6669E+00_JPRB,8.2878E+00_JPRB,7.9176E+00_JPRB,7.2460E+00_JPRB,&
&6.1780E+00_JPRB,5.6640E+00_JPRB,6.4647E+00_JPRB/)
KAO( :, 5, 7,12) = (/&
&1.0201E+01_JPRB,9.1389E+00_JPRB,8.8345E+00_JPRB,8.5103E+00_JPRB,8.1626E+00_JPRB,7.4581E+00_JPRB,&
&6.4020E+00_JPRB,6.0910E+00_JPRB,6.9537E+00_JPRB/)
KAO( :, 1, 8,12) = (/&
&9.2811E+00_JPRB,8.3345E+00_JPRB,7.9563E+00_JPRB,7.5592E+00_JPRB,7.1819E+00_JPRB,6.4953E+00_JPRB,&
&5.4582E+00_JPRB,4.2950E+00_JPRB,4.3920E+00_JPRB/)
KAO( :, 2, 8,12) = (/&
&9.5392E+00_JPRB,8.5773E+00_JPRB,8.2536E+00_JPRB,7.8937E+00_JPRB,7.5195E+00_JPRB,6.7954E+00_JPRB,&
&5.7637E+00_JPRB,4.5610E+00_JPRB,4.9202E+00_JPRB/)
KAO( :, 3, 8,12) = (/&
&9.7485E+00_JPRB,8.7863E+00_JPRB,8.5113E+00_JPRB,8.1791E+00_JPRB,7.8003E+00_JPRB,7.1017E+00_JPRB,&
&6.0337E+00_JPRB,4.8844E+00_JPRB,5.4469E+00_JPRB/)
KAO( :, 4, 8,12) = (/&
&9.9204E+00_JPRB,8.9649E+00_JPRB,8.7333E+00_JPRB,8.4326E+00_JPRB,8.0879E+00_JPRB,7.3644E+00_JPRB,&
&6.2970E+00_JPRB,5.2617E+00_JPRB,5.9740E+00_JPRB/)
KAO( :, 5, 8,12) = (/&
&1.0071E+01_JPRB,9.1243E+00_JPRB,8.9157E+00_JPRB,8.6785E+00_JPRB,8.3414E+00_JPRB,7.5947E+00_JPRB,&
&6.5710E+00_JPRB,5.6445E+00_JPRB,6.4414E+00_JPRB/)
KAO( :, 1, 9,12) = (/&
&8.9609E+00_JPRB,8.1123E+00_JPRB,7.8302E+00_JPRB,7.5091E+00_JPRB,7.1654E+00_JPRB,6.4417E+00_JPRB,&
&5.3958E+00_JPRB,4.1476E+00_JPRB,3.9139E+00_JPRB/)
KAO( :, 2, 9,12) = (/&
&9.2116E+00_JPRB,8.3782E+00_JPRB,8.1493E+00_JPRB,7.8784E+00_JPRB,7.5112E+00_JPRB,6.7501E+00_JPRB,&
&5.7326E+00_JPRB,4.3938E+00_JPRB,4.4110E+00_JPRB/)
KAO( :, 3, 9,12) = (/&
&9.4264E+00_JPRB,8.6064E+00_JPRB,8.4239E+00_JPRB,8.1936E+00_JPRB,7.8020E+00_JPRB,7.0726E+00_JPRB,&
&6.0450E+00_JPRB,4.6670E+00_JPRB,4.9111E+00_JPRB/)
KAO( :, 4, 9,12) = (/&
&9.6121E+00_JPRB,8.8121E+00_JPRB,8.6565E+00_JPRB,8.4692E+00_JPRB,8.1000E+00_JPRB,7.3553E+00_JPRB,&
&6.3481E+00_JPRB,4.9681E+00_JPRB,5.3926E+00_JPRB/)
KAO( :, 5, 9,12) = (/&
&9.7546E+00_JPRB,8.9755E+00_JPRB,8.8628E+00_JPRB,8.7297E+00_JPRB,8.3623E+00_JPRB,7.6149E+00_JPRB,&
&6.6558E+00_JPRB,5.2826E+00_JPRB,5.8453E+00_JPRB/)
KAO( :, 1,10,12) = (/&
&8.5361E+00_JPRB,7.8147E+00_JPRB,7.5979E+00_JPRB,7.3794E+00_JPRB,7.0310E+00_JPRB,6.2793E+00_JPRB,&
&5.2791E+00_JPRB,4.0318E+00_JPRB,3.4661E+00_JPRB/)
KAO( :, 2,10,12) = (/&
&8.7722E+00_JPRB,8.0890E+00_JPRB,7.9244E+00_JPRB,7.7654E+00_JPRB,7.3651E+00_JPRB,6.6087E+00_JPRB,&
&5.6393E+00_JPRB,4.3325E+00_JPRB,3.9297E+00_JPRB/)
KAO( :, 3,10,12) = (/&
&8.9854E+00_JPRB,8.3416E+00_JPRB,8.2149E+00_JPRB,8.1092E+00_JPRB,7.6681E+00_JPRB,6.9412E+00_JPRB,&
&5.9891E+00_JPRB,4.5941E+00_JPRB,4.3794E+00_JPRB/)
KAO( :, 4,10,12) = (/&
&9.1549E+00_JPRB,8.5424E+00_JPRB,8.4801E+00_JPRB,8.3931E+00_JPRB,7.9670E+00_JPRB,7.2576E+00_JPRB,&
&6.3219E+00_JPRB,4.8394E+00_JPRB,4.8247E+00_JPRB/)
KAO( :, 5,10,12) = (/&
&9.2930E+00_JPRB,8.7150E+00_JPRB,8.6983E+00_JPRB,8.6747E+00_JPRB,8.2356E+00_JPRB,7.5515E+00_JPRB,&
&6.6530E+00_JPRB,5.0978E+00_JPRB,5.2580E+00_JPRB/)
KAO( :, 1,11,12) = (/&
&8.1665E+00_JPRB,7.5900E+00_JPRB,7.4402E+00_JPRB,7.3130E+00_JPRB,6.8936E+00_JPRB,6.1750E+00_JPRB,&
&5.2487E+00_JPRB,4.0527E+00_JPRB,3.2183E+00_JPRB/)
KAO( :, 2,11,12) = (/&
&8.3894E+00_JPRB,7.8591E+00_JPRB,7.7685E+00_JPRB,7.6781E+00_JPRB,7.2197E+00_JPRB,6.5157E+00_JPRB,&
&5.6333E+00_JPRB,4.3626E+00_JPRB,3.6379E+00_JPRB/)
KAO( :, 3,11,12) = (/&
&8.5776E+00_JPRB,8.0897E+00_JPRB,8.0638E+00_JPRB,7.9845E+00_JPRB,7.5334E+00_JPRB,6.8745E+00_JPRB,&
&5.9959E+00_JPRB,4.6206E+00_JPRB,4.0541E+00_JPRB/)
KAO( :, 4,11,12) = (/&
&8.7343E+00_JPRB,8.2889E+00_JPRB,8.3048E+00_JPRB,8.2761E+00_JPRB,7.8416E+00_JPRB,7.2002E+00_JPRB,&
&6.3426E+00_JPRB,4.8817E+00_JPRB,4.4717E+00_JPRB/)
KAO( :, 5,11,12) = (/&
&8.8713E+00_JPRB,8.4483E+00_JPRB,8.5341E+00_JPRB,8.5312E+00_JPRB,8.1167E+00_JPRB,7.5296E+00_JPRB,&
&6.6477E+00_JPRB,5.1325E+00_JPRB,4.9081E+00_JPRB/)
KAO( :, 1,12,12) = (/&
&7.8094E+00_JPRB,7.3653E+00_JPRB,7.2542E+00_JPRB,7.0902E+00_JPRB,6.6433E+00_JPRB,5.9686E+00_JPRB,&
&5.1635E+00_JPRB,4.0194E+00_JPRB,2.9475E+00_JPRB/)
KAO( :, 2,12,12) = (/&
&8.0117E+00_JPRB,7.6155E+00_JPRB,7.5651E+00_JPRB,7.4151E+00_JPRB,6.9696E+00_JPRB,6.3450E+00_JPRB,&
&5.5476E+00_JPRB,4.3129E+00_JPRB,3.3366E+00_JPRB/)
KAO( :, 3,12,12) = (/&
&8.1910E+00_JPRB,7.8328E+00_JPRB,7.8418E+00_JPRB,7.7049E+00_JPRB,7.2969E+00_JPRB,6.7155E+00_JPRB,&
&5.8961E+00_JPRB,4.5906E+00_JPRB,3.7405E+00_JPRB/)
KAO( :, 4,12,12) = (/&
&8.3426E+00_JPRB,8.0165E+00_JPRB,8.0839E+00_JPRB,7.9767E+00_JPRB,7.6138E+00_JPRB,7.0590E+00_JPRB,&
&6.2190E+00_JPRB,4.8660E+00_JPRB,4.1525E+00_JPRB/)
KAO( :, 5,12,12) = (/&
&8.4617E+00_JPRB,8.1705E+00_JPRB,8.3144E+00_JPRB,8.2344E+00_JPRB,7.9033E+00_JPRB,7.3931E+00_JPRB,&
&6.5112E+00_JPRB,5.1463E+00_JPRB,4.5704E+00_JPRB/)
KAO( :, 1,13,12) = (/&
&7.4570E+00_JPRB,7.1219E+00_JPRB,7.0631E+00_JPRB,6.7931E+00_JPRB,6.3176E+00_JPRB,5.7305E+00_JPRB,&
&4.9924E+00_JPRB,3.9078E+00_JPRB,2.6864E+00_JPRB/)
KAO( :, 2,13,12) = (/&
&7.6593E+00_JPRB,7.3680E+00_JPRB,7.3595E+00_JPRB,7.0913E+00_JPRB,6.6544E+00_JPRB,6.1127E+00_JPRB,&
&5.3577E+00_JPRB,4.1969E+00_JPRB,3.0587E+00_JPRB/)
KAO( :, 3,13,12) = (/&
&7.8270E+00_JPRB,7.5824E+00_JPRB,7.6095E+00_JPRB,7.3732E+00_JPRB,7.0009E+00_JPRB,6.4671E+00_JPRB,&
&5.6889E+00_JPRB,4.4965E+00_JPRB,3.4369E+00_JPRB/)
KAO( :, 4,13,12) = (/&
&7.9650E+00_JPRB,7.7709E+00_JPRB,7.8397E+00_JPRB,7.6582E+00_JPRB,7.3100E+00_JPRB,6.7945E+00_JPRB,&
&6.0051E+00_JPRB,4.7890E+00_JPRB,3.8174E+00_JPRB/)
KAO( :, 5,13,12) = (/&
&8.0792E+00_JPRB,7.9275E+00_JPRB,8.0591E+00_JPRB,7.9074E+00_JPRB,7.6140E+00_JPRB,7.1099E+00_JPRB,&
&6.2973E+00_JPRB,5.0841E+00_JPRB,4.2048E+00_JPRB/)
KAO( :, 1, 1,13) = (/&
&1.0577E+01_JPRB,9.2549E+00_JPRB,8.1600E+00_JPRB,7.7278E+00_JPRB,7.7653E+00_JPRB,7.7716E+00_JPRB,&
&7.5669E+00_JPRB,8.8236E+00_JPRB,9.8756E+00_JPRB/)
KAO( :, 2, 1,13) = (/&
&1.0671E+01_JPRB,9.3375E+00_JPRB,8.2378E+00_JPRB,7.8122E+00_JPRB,7.8593E+00_JPRB,7.7059E+00_JPRB,&
&7.9393E+00_JPRB,9.2604E+00_JPRB,1.0358E+01_JPRB/)
KAO( :, 3, 1,13) = (/&
&1.0744E+01_JPRB,9.4010E+00_JPRB,8.2968E+00_JPRB,7.8823E+00_JPRB,7.9000E+00_JPRB,7.7087E+00_JPRB,&
&8.3139E+00_JPRB,9.6974E+00_JPRB,1.0851E+01_JPRB/)
KAO( :, 4, 1,13) = (/&
&1.0801E+01_JPRB,9.4514E+00_JPRB,8.3377E+00_JPRB,7.9397E+00_JPRB,7.9429E+00_JPRB,7.7123E+00_JPRB,&
&8.6663E+00_JPRB,1.0108E+01_JPRB,1.1303E+01_JPRB/)
KAO( :, 5, 1,13) = (/&
&1.0828E+01_JPRB,9.4745E+00_JPRB,8.3567E+00_JPRB,8.0119E+00_JPRB,7.9284E+00_JPRB,7.7671E+00_JPRB,&
&9.0671E+00_JPRB,1.0577E+01_JPRB,1.1784E+01_JPRB/)
KAO( :, 1, 2,13) = (/&
&1.1163E+01_JPRB,9.7674E+00_JPRB,8.6478E+00_JPRB,8.0225E+00_JPRB,8.2244E+00_JPRB,8.0837E+00_JPRB,&
&7.7758E+00_JPRB,9.0278E+00_JPRB,1.0229E+01_JPRB/)
KAO( :, 2, 2,13) = (/&
&1.1323E+01_JPRB,9.9081E+00_JPRB,8.7792E+00_JPRB,8.1586E+00_JPRB,8.2869E+00_JPRB,8.0551E+00_JPRB,&
&8.1451E+00_JPRB,9.5005E+00_JPRB,1.0748E+01_JPRB/)
KAO( :, 3, 2,13) = (/&
&1.1461E+01_JPRB,1.0028E+01_JPRB,8.8854E+00_JPRB,8.2743E+00_JPRB,8.3048E+00_JPRB,8.0402E+00_JPRB,&
&8.5556E+00_JPRB,9.9796E+00_JPRB,1.1282E+01_JPRB/)
KAO( :, 4, 2,13) = (/&
&1.1566E+01_JPRB,1.0120E+01_JPRB,8.9543E+00_JPRB,8.3710E+00_JPRB,8.3468E+00_JPRB,8.0313E+00_JPRB,&
&8.9856E+00_JPRB,1.0481E+01_JPRB,1.1824E+01_JPRB/)
KAO( :, 5, 2,13) = (/&
&1.1629E+01_JPRB,1.0176E+01_JPRB,8.9870E+00_JPRB,8.4547E+00_JPRB,8.3497E+00_JPRB,8.1172E+00_JPRB,&
&9.4516E+00_JPRB,1.1026E+01_JPRB,1.2419E+01_JPRB/)
KAO( :, 1, 3,13) = (/&
&1.1962E+01_JPRB,1.0467E+01_JPRB,9.2709E+00_JPRB,8.4291E+00_JPRB,8.5436E+00_JPRB,8.3200E+00_JPRB,&
&7.8658E+00_JPRB,9.0562E+00_JPRB,1.0308E+01_JPRB/)
KAO( :, 2, 3,13) = (/&
&1.2205E+01_JPRB,1.0680E+01_JPRB,9.4411E+00_JPRB,8.6517E+00_JPRB,8.6197E+00_JPRB,8.3368E+00_JPRB,&
&8.2049E+00_JPRB,9.5685E+00_JPRB,1.0891E+01_JPRB/)
KAO( :, 3, 3,13) = (/&
&1.2410E+01_JPRB,1.0859E+01_JPRB,9.5853E+00_JPRB,8.8479E+00_JPRB,8.6747E+00_JPRB,8.3471E+00_JPRB,&
&8.6431E+00_JPRB,1.0082E+01_JPRB,1.1474E+01_JPRB/)
KAO( :, 4, 3,13) = (/&
&1.2574E+01_JPRB,1.1002E+01_JPRB,9.6989E+00_JPRB,8.9698E+00_JPRB,8.7471E+00_JPRB,8.3398E+00_JPRB,&
&9.0831E+00_JPRB,1.0595E+01_JPRB,1.2056E+01_JPRB/)
KAO( :, 5, 3,13) = (/&
&1.2712E+01_JPRB,1.1123E+01_JPRB,9.7902E+00_JPRB,9.0790E+00_JPRB,8.7667E+00_JPRB,8.4500E+00_JPRB,&
&9.6002E+00_JPRB,1.1199E+01_JPRB,1.2724E+01_JPRB/)
KAO( :, 1, 4,13) = (/&
&1.2978E+01_JPRB,1.1356E+01_JPRB,1.0016E+01_JPRB,9.0951E+00_JPRB,8.8183E+00_JPRB,8.5105E+00_JPRB,&
&7.9105E+00_JPRB,9.0384E+00_JPRB,1.0315E+01_JPRB/)
KAO( :, 2, 4,13) = (/&
&1.3298E+01_JPRB,1.1636E+01_JPRB,1.0263E+01_JPRB,9.3919E+00_JPRB,8.9613E+00_JPRB,8.5969E+00_JPRB,&
&8.2211E+00_JPRB,9.5613E+00_JPRB,1.0907E+01_JPRB/)
KAO( :, 3, 4,13) = (/&
&1.3575E+01_JPRB,1.1878E+01_JPRB,1.0487E+01_JPRB,9.6114E+00_JPRB,9.0632E+00_JPRB,8.6395E+00_JPRB,&
&8.6771E+00_JPRB,1.0122E+01_JPRB,1.1544E+01_JPRB/)
KAO( :, 4, 4,13) = (/&
&1.3811E+01_JPRB,1.2085E+01_JPRB,1.0662E+01_JPRB,9.7774E+00_JPRB,9.1650E+00_JPRB,8.6661E+00_JPRB,&
&9.1672E+00_JPRB,1.0693E+01_JPRB,1.2193E+01_JPRB/)
KAO( :, 5, 4,13) = (/&
&1.3981E+01_JPRB,1.2233E+01_JPRB,1.0802E+01_JPRB,9.9141E+00_JPRB,9.2432E+00_JPRB,8.7675E+00_JPRB,&
&9.7195E+00_JPRB,1.1338E+01_JPRB,1.2921E+01_JPRB/)
KAO( :, 1, 5,13) = (/&
&1.4114E+01_JPRB,1.2350E+01_JPRB,1.0930E+01_JPRB,9.8909E+00_JPRB,9.2442E+00_JPRB,8.6849E+00_JPRB,&
&8.0205E+00_JPRB,9.0018E+00_JPRB,1.0281E+01_JPRB/)
KAO( :, 2, 5,13) = (/&
&1.4481E+01_JPRB,1.2671E+01_JPRB,1.1207E+01_JPRB,1.0236E+01_JPRB,9.4445E+00_JPRB,8.8064E+00_JPRB,&
&8.3341E+00_JPRB,9.5712E+00_JPRB,1.0927E+01_JPRB/)
KAO( :, 3, 5,13) = (/&
&1.4780E+01_JPRB,1.2933E+01_JPRB,1.1441E+01_JPRB,1.0504E+01_JPRB,9.5949E+00_JPRB,8.9267E+00_JPRB,&
&8.7559E+00_JPRB,1.0193E+01_JPRB,1.1635E+01_JPRB/)
KAO( :, 4, 5,13) = (/&
&1.5014E+01_JPRB,1.3137E+01_JPRB,1.1651E+01_JPRB,1.0704E+01_JPRB,9.7669E+00_JPRB,9.0159E+00_JPRB,&
&9.2560E+00_JPRB,1.0797E+01_JPRB,1.2325E+01_JPRB/)
KAO( :, 5, 5,13) = (/&
&1.5187E+01_JPRB,1.3289E+01_JPRB,1.1815E+01_JPRB,1.0866E+01_JPRB,9.8919E+00_JPRB,9.1157E+00_JPRB,&
&9.8156E+00_JPRB,1.1450E+01_JPRB,1.3070E+01_JPRB/)
KAO( :, 1, 6,13) = (/&
&1.5160E+01_JPRB,1.3265E+01_JPRB,1.1763E+01_JPRB,1.0744E+01_JPRB,9.7606E+00_JPRB,8.8908E+00_JPRB,&
&8.2258E+00_JPRB,8.8849E+00_JPRB,1.0152E+01_JPRB/)
KAO( :, 2, 6,13) = (/&
&1.5549E+01_JPRB,1.3605E+01_JPRB,1.2084E+01_JPRB,1.1112E+01_JPRB,1.0034E+01_JPRB,9.1009E+00_JPRB,&
&8.4931E+00_JPRB,9.5055E+00_JPRB,1.0858E+01_JPRB/)
KAO( :, 3, 6,13) = (/&
&1.5873E+01_JPRB,1.3889E+01_JPRB,1.2356E+01_JPRB,1.1403E+01_JPRB,1.0281E+01_JPRB,9.2837E+00_JPRB,&
&8.8721E+00_JPRB,1.0170E+01_JPRB,1.1619E+01_JPRB/)
KAO( :, 4, 6,13) = (/&
&1.6112E+01_JPRB,1.4098E+01_JPRB,1.2586E+01_JPRB,1.1634E+01_JPRB,1.0494E+01_JPRB,9.4499E+00_JPRB,&
&9.3030E+00_JPRB,1.0807E+01_JPRB,1.2339E+01_JPRB/)
KAO( :, 5, 6,13) = (/&
&1.6286E+01_JPRB,1.4252E+01_JPRB,1.2775E+01_JPRB,1.1818E+01_JPRB,1.0693E+01_JPRB,9.5647E+00_JPRB,&
&9.8402E+00_JPRB,1.1469E+01_JPRB,1.3094E+01_JPRB/)
KAO( :, 1, 7,13) = (/&
&1.6122E+01_JPRB,1.4109E+01_JPRB,1.2562E+01_JPRB,1.1505E+01_JPRB,1.0368E+01_JPRB,9.2585E+00_JPRB,&
&8.3696E+00_JPRB,8.5768E+00_JPRB,9.8029E+00_JPRB/)
KAO( :, 2, 7,13) = (/&
&1.6526E+01_JPRB,1.4471E+01_JPRB,1.2919E+01_JPRB,1.1924E+01_JPRB,1.0722E+01_JPRB,9.5715E+00_JPRB,&
&8.6023E+00_JPRB,9.2393E+00_JPRB,1.0560E+01_JPRB/)
KAO( :, 3, 7,13) = (/&
&1.6858E+01_JPRB,1.4770E+01_JPRB,1.3234E+01_JPRB,1.2238E+01_JPRB,1.1035E+01_JPRB,9.8187E+00_JPRB,&
&8.9328E+00_JPRB,9.9387E+00_JPRB,1.1350E+01_JPRB/)
KAO( :, 4, 7,13) = (/&
&1.7093E+01_JPRB,1.4987E+01_JPRB,1.3501E+01_JPRB,1.2504E+01_JPRB,1.1279E+01_JPRB,1.0055E+01_JPRB,&
&9.3088E+00_JPRB,1.0608E+01_JPRB,1.2111E+01_JPRB/)
KAO( :, 5, 7,13) = (/&
&1.7259E+01_JPRB,1.5142E+01_JPRB,1.3707E+01_JPRB,1.2711E+01_JPRB,1.1518E+01_JPRB,1.0206E+01_JPRB,&
&9.7355E+00_JPRB,1.1291E+01_JPRB,1.2889E+01_JPRB/)
KAO( :, 1, 8,13) = (/&
&1.6916E+01_JPRB,1.4832E+01_JPRB,1.3277E+01_JPRB,1.2204E+01_JPRB,1.0940E+01_JPRB,9.7472E+00_JPRB,&
&8.4449E+00_JPRB,8.0133E+00_JPRB,9.1571E+00_JPRB/)
KAO( :, 2, 8,13) = (/&
&1.7329E+01_JPRB,1.5217E+01_JPRB,1.3686E+01_JPRB,1.2639E+01_JPRB,1.1376E+01_JPRB,1.0148E+01_JPRB,&
&8.6472E+00_JPRB,8.7212E+00_JPRB,9.9586E+00_JPRB/)
KAO( :, 3, 8,13) = (/&
&1.7658E+01_JPRB,1.5525E+01_JPRB,1.4035E+01_JPRB,1.3005E+01_JPRB,1.1745E+01_JPRB,1.0456E+01_JPRB,&
&8.9277E+00_JPRB,9.4462E+00_JPRB,1.0783E+01_JPRB/)
KAO( :, 4, 8,13) = (/&
&1.7910E+01_JPRB,1.5764E+01_JPRB,1.4326E+01_JPRB,1.3292E+01_JPRB,1.2039E+01_JPRB,1.0730E+01_JPRB,&
&9.2875E+00_JPRB,1.0174E+01_JPRB,1.1613E+01_JPRB/)
KAO( :, 5, 8,13) = (/&
&1.8061E+01_JPRB,1.5911E+01_JPRB,1.4552E+01_JPRB,1.3522E+01_JPRB,1.2313E+01_JPRB,1.0922E+01_JPRB,&
&9.6669E+00_JPRB,1.0913E+01_JPRB,1.2458E+01_JPRB/)
KAO( :, 1, 9,13) = (/&
&1.7489E+01_JPRB,1.5390E+01_JPRB,1.3855E+01_JPRB,1.2753E+01_JPRB,1.1443E+01_JPRB,1.0269E+01_JPRB,&
&8.6020E+00_JPRB,7.3519E+00_JPRB,8.3472E+00_JPRB/)
KAO( :, 2, 9,13) = (/&
&1.7914E+01_JPRB,1.5791E+01_JPRB,1.4307E+01_JPRB,1.3235E+01_JPRB,1.1959E+01_JPRB,1.0725E+01_JPRB,&
&8.8103E+00_JPRB,8.0533E+00_JPRB,9.1895E+00_JPRB/)
KAO( :, 3, 9,13) = (/&
&1.8257E+01_JPRB,1.6119E+01_JPRB,1.4693E+01_JPRB,1.3625E+01_JPRB,1.2389E+01_JPRB,1.1058E+01_JPRB,&
&9.0504E+00_JPRB,8.8002E+00_JPRB,1.0042E+01_JPRB/)
KAO( :, 4, 9,13) = (/&
&1.8479E+01_JPRB,1.6338E+01_JPRB,1.5015E+01_JPRB,1.3939E+01_JPRB,1.2757E+01_JPRB,1.1337E+01_JPRB,&
&9.3866E+00_JPRB,9.5953E+00_JPRB,1.0949E+01_JPRB/)
KAO( :, 5, 9,13) = (/&
&1.8635E+01_JPRB,1.6495E+01_JPRB,1.5249E+01_JPRB,1.4201E+01_JPRB,1.3054E+01_JPRB,1.1574E+01_JPRB,&
&9.7301E+00_JPRB,1.0376E+01_JPRB,1.1842E+01_JPRB/)
KAO( :, 1,10,13) = (/&
&1.7834E+01_JPRB,1.5755E+01_JPRB,1.4296E+01_JPRB,1.3173E+01_JPRB,1.1876E+01_JPRB,1.0672E+01_JPRB,&
&8.8079E+00_JPRB,6.8283E+00_JPRB,7.5346E+00_JPRB/)
KAO( :, 2,10,13) = (/&
&1.8252E+01_JPRB,1.6162E+01_JPRB,1.4783E+01_JPRB,1.3694E+01_JPRB,1.2464E+01_JPRB,1.1197E+01_JPRB,&
&9.0829E+00_JPRB,7.4323E+00_JPRB,8.3917E+00_JPRB/)
KAO( :, 3,10,13) = (/&
&1.8558E+01_JPRB,1.6468E+01_JPRB,1.5228E+01_JPRB,1.4086E+01_JPRB,1.2957E+01_JPRB,1.1559E+01_JPRB,&
&9.3588E+00_JPRB,8.1767E+00_JPRB,9.3163E+00_JPRB/)
KAO( :, 4,10,13) = (/&
&1.8778E+01_JPRB,1.6694E+01_JPRB,1.5535E+01_JPRB,1.4435E+01_JPRB,1.3366E+01_JPRB,1.1847E+01_JPRB,&
&9.6760E+00_JPRB,9.0005E+00_JPRB,1.0268E+01_JPRB/)
KAO( :, 5,10,13) = (/&
&1.8909E+01_JPRB,1.6834E+01_JPRB,1.5762E+01_JPRB,1.4717E+01_JPRB,1.3710E+01_JPRB,1.2145E+01_JPRB,&
&1.0011E+01_JPRB,9.8258E+00_JPRB,1.1210E+01_JPRB/)
KAO( :, 1,11,13) = (/&
&1.8087E+01_JPRB,1.6075E+01_JPRB,1.4790E+01_JPRB,1.3655E+01_JPRB,1.2497E+01_JPRB,1.1191E+01_JPRB,&
&9.1399E+00_JPRB,6.6933E+00_JPRB,7.1162E+00_JPRB/)
KAO( :, 2,11,13) = (/&
&1.8432E+01_JPRB,1.6428E+01_JPRB,1.5277E+01_JPRB,1.4152E+01_JPRB,1.3089E+01_JPRB,1.1695E+01_JPRB,&
&9.4501E+00_JPRB,7.3057E+00_JPRB,8.0369E+00_JPRB/)
KAO( :, 3,11,13) = (/&
&1.8659E+01_JPRB,1.6669E+01_JPRB,1.5627E+01_JPRB,1.4589E+01_JPRB,1.3582E+01_JPRB,1.2037E+01_JPRB,&
&9.8265E+00_JPRB,8.0558E+00_JPRB,9.0157E+00_JPRB/)
KAO( :, 4,11,13) = (/&
&1.8822E+01_JPRB,1.6850E+01_JPRB,1.5905E+01_JPRB,1.4936E+01_JPRB,1.3964E+01_JPRB,1.2377E+01_JPRB,&
&1.0203E+01_JPRB,8.8302E+00_JPRB,9.9768E+00_JPRB/)
KAO( :, 5,11,13) = (/&
&1.8912E+01_JPRB,1.6973E+01_JPRB,1.6104E+01_JPRB,1.5218E+01_JPRB,1.4312E+01_JPRB,1.2701E+01_JPRB,&
&1.0619E+01_JPRB,9.6452E+00_JPRB,1.0951E+01_JPRB/)
KAO( :, 1,12,13) = (/&
&1.7920E+01_JPRB,1.6053E+01_JPRB,1.5019E+01_JPRB,1.3982E+01_JPRB,1.2926E+01_JPRB,1.1508E+01_JPRB,&
&9.3716E+00_JPRB,6.7503E+00_JPRB,6.7740E+00_JPRB/)
KAO( :, 2,12,13) = (/&
&1.8186E+01_JPRB,1.6353E+01_JPRB,1.5440E+01_JPRB,1.4490E+01_JPRB,1.3495E+01_JPRB,1.1962E+01_JPRB,&
&9.7745E+00_JPRB,7.3828E+00_JPRB,7.7336E+00_JPRB/)
KAO( :, 3,12,13) = (/&
&1.8384E+01_JPRB,1.6588E+01_JPRB,1.5763E+01_JPRB,1.4906E+01_JPRB,1.3939E+01_JPRB,1.2345E+01_JPRB,&
&1.0238E+01_JPRB,8.0656E+00_JPRB,8.6667E+00_JPRB/)
KAO( :, 4,12,13) = (/&
&1.8509E+01_JPRB,1.6759E+01_JPRB,1.6033E+01_JPRB,1.5245E+01_JPRB,1.4313E+01_JPRB,1.2752E+01_JPRB,&
&1.0707E+01_JPRB,8.7818E+00_JPRB,9.6176E+00_JPRB/)
KAO( :, 5,12,13) = (/&
&1.8577E+01_JPRB,1.6881E+01_JPRB,1.6239E+01_JPRB,1.5529E+01_JPRB,1.4670E+01_JPRB,1.3127E+01_JPRB,&
&1.1210E+01_JPRB,9.5549E+00_JPRB,1.0594E+01_JPRB/)
KAO( :, 1,13,13) = (/&
&1.7404E+01_JPRB,1.5741E+01_JPRB,1.4917E+01_JPRB,1.4087E+01_JPRB,1.3107E+01_JPRB,1.1569E+01_JPRB,&
&9.5101E+00_JPRB,6.9448E+00_JPRB,6.4373E+00_JPRB/)
KAO( :, 2,13,13) = (/&
&1.7616E+01_JPRB,1.6021E+01_JPRB,1.5315E+01_JPRB,1.4593E+01_JPRB,1.3608E+01_JPRB,1.2031E+01_JPRB,&
&1.0008E+01_JPRB,7.5382E+00_JPRB,7.3336E+00_JPRB/)
KAO( :, 3,13,13) = (/&
&1.7758E+01_JPRB,1.6239E+01_JPRB,1.5665E+01_JPRB,1.5009E+01_JPRB,1.4000E+01_JPRB,1.2479E+01_JPRB,&
&1.0559E+01_JPRB,8.1609E+00_JPRB,8.2503E+00_JPRB/)
KAO( :, 4,13,13) = (/&
&1.7857E+01_JPRB,1.6408E+01_JPRB,1.5937E+01_JPRB,1.5347E+01_JPRB,1.4396E+01_JPRB,1.2961E+01_JPRB,&
&1.1094E+01_JPRB,8.8199E+00_JPRB,9.1733E+00_JPRB/)
KAO( :, 5,13,13) = (/&
&1.7901E+01_JPRB,1.6530E+01_JPRB,1.6155E+01_JPRB,1.5663E+01_JPRB,1.4778E+01_JPRB,1.3417E+01_JPRB,&
&1.1660E+01_JPRB,9.5134E+00_JPRB,1.0096E+01_JPRB/)
KAO( :, 1, 1,14) = (/&
&1.8068E+01_JPRB,1.5810E+01_JPRB,1.3551E+01_JPRB,1.1831E+01_JPRB,1.0304E+01_JPRB,9.7990E+00_JPRB,&
&1.1739E+01_JPRB,1.3692E+01_JPRB,1.5004E+01_JPRB/)
KAO( :, 2, 1,14) = (/&
&1.7600E+01_JPRB,1.5400E+01_JPRB,1.3200E+01_JPRB,1.1647E+01_JPRB,1.0167E+01_JPRB,1.0174E+01_JPRB,&
&1.2204E+01_JPRB,1.4235E+01_JPRB,1.5608E+01_JPRB/)
KAO( :, 3, 1,14) = (/&
&1.7123E+01_JPRB,1.4983E+01_JPRB,1.2843E+01_JPRB,1.1396E+01_JPRB,1.0063E+01_JPRB,1.0510E+01_JPRB,&
&1.2607E+01_JPRB,1.4704E+01_JPRB,1.6115E+01_JPRB/)
KAO( :, 4, 1,14) = (/&
&1.6641E+01_JPRB,1.4561E+01_JPRB,1.2481E+01_JPRB,1.1106E+01_JPRB,9.9075E+00_JPRB,1.0883E+01_JPRB,&
&1.3055E+01_JPRB,1.5227E+01_JPRB,1.6651E+01_JPRB/)
KAO( :, 5, 1,14) = (/&
&1.6173E+01_JPRB,1.4152E+01_JPRB,1.2130E+01_JPRB,1.0803E+01_JPRB,9.8573E+00_JPRB,1.1271E+01_JPRB,&
&1.3520E+01_JPRB,1.5769E+01_JPRB,1.7251E+01_JPRB/)
KAO( :, 1, 2,14) = (/&
&1.8801E+01_JPRB,1.6451E+01_JPRB,1.4101E+01_JPRB,1.2604E+01_JPRB,1.1011E+01_JPRB,1.0737E+01_JPRB,&
&1.2792E+01_JPRB,1.4921E+01_JPRB,1.6625E+01_JPRB/)
KAO( :, 2, 2,14) = (/&
&1.8304E+01_JPRB,1.6016E+01_JPRB,1.3728E+01_JPRB,1.2330E+01_JPRB,1.0982E+01_JPRB,1.1096E+01_JPRB,&
&1.3301E+01_JPRB,1.5514E+01_JPRB,1.7306E+01_JPRB/)
KAO( :, 3, 2,14) = (/&
&1.7801E+01_JPRB,1.5576E+01_JPRB,1.3356E+01_JPRB,1.2016E+01_JPRB,1.0871E+01_JPRB,1.1458E+01_JPRB,&
&1.3745E+01_JPRB,1.6031E+01_JPRB,1.7874E+01_JPRB/)
KAO( :, 4, 2,14) = (/&
&1.7309E+01_JPRB,1.5145E+01_JPRB,1.3007E+01_JPRB,1.1693E+01_JPRB,1.0730E+01_JPRB,1.1860E+01_JPRB,&
&1.4227E+01_JPRB,1.6594E+01_JPRB,1.8476E+01_JPRB/)
KAO( :, 5, 2,14) = (/&
&1.6850E+01_JPRB,1.4744E+01_JPRB,1.2687E+01_JPRB,1.1410E+01_JPRB,1.0694E+01_JPRB,1.2279E+01_JPRB,&
&1.4731E+01_JPRB,1.7182E+01_JPRB,1.9118E+01_JPRB/)
KAO( :, 1, 3,14) = (/&
&1.9584E+01_JPRB,1.7136E+01_JPRB,1.4732E+01_JPRB,1.3313E+01_JPRB,1.1884E+01_JPRB,1.1593E+01_JPRB,&
&1.3636E+01_JPRB,1.5905E+01_JPRB,1.7983E+01_JPRB/)
KAO( :, 2, 3,14) = (/&
&1.9076E+01_JPRB,1.6691E+01_JPRB,1.4400E+01_JPRB,1.2989E+01_JPRB,1.1901E+01_JPRB,1.1927E+01_JPRB,&
&1.4231E+01_JPRB,1.6600E+01_JPRB,1.8761E+01_JPRB/)
KAO( :, 3, 3,14) = (/&
&1.8574E+01_JPRB,1.6253E+01_JPRB,1.4065E+01_JPRB,1.2664E+01_JPRB,1.1748E+01_JPRB,1.2312E+01_JPRB,&
&1.4771E+01_JPRB,1.7229E+01_JPRB,1.9465E+01_JPRB/)
KAO( :, 4, 3,14) = (/&
&1.8102E+01_JPRB,1.5839E+01_JPRB,1.3744E+01_JPRB,1.2408E+01_JPRB,1.1592E+01_JPRB,1.2780E+01_JPRB,&
&1.5332E+01_JPRB,1.7885E+01_JPRB,2.0196E+01_JPRB/)
KAO( :, 5, 3,14) = (/&
&1.7642E+01_JPRB,1.5437E+01_JPRB,1.3436E+01_JPRB,1.2180E+01_JPRB,1.1540E+01_JPRB,1.3243E+01_JPRB,&
&1.5887E+01_JPRB,1.8532E+01_JPRB,2.0924E+01_JPRB/)
KAO( :, 1, 4,14) = (/&
&2.0389E+01_JPRB,1.7840E+01_JPRB,1.5486E+01_JPRB,1.3966E+01_JPRB,1.2815E+01_JPRB,1.2346E+01_JPRB,&
&1.4297E+01_JPRB,1.6677E+01_JPRB,1.8970E+01_JPRB/)
KAO( :, 2, 4,14) = (/&
&1.9917E+01_JPRB,1.7427E+01_JPRB,1.5179E+01_JPRB,1.3667E+01_JPRB,1.2793E+01_JPRB,1.2684E+01_JPRB,&
&1.5037E+01_JPRB,1.7540E+01_JPRB,1.9955E+01_JPRB/)
KAO( :, 3, 4,14) = (/&
&1.9473E+01_JPRB,1.7039E+01_JPRB,1.4867E+01_JPRB,1.3426E+01_JPRB,1.2614E+01_JPRB,1.3089E+01_JPRB,&
&1.5675E+01_JPRB,1.8284E+01_JPRB,2.0800E+01_JPRB/)
KAO( :, 4, 4,14) = (/&
&1.9059E+01_JPRB,1.6676E+01_JPRB,1.4584E+01_JPRB,1.3222E+01_JPRB,1.2465E+01_JPRB,1.3596E+01_JPRB,&
&1.6312E+01_JPRB,1.9027E+01_JPRB,2.1639E+01_JPRB/)
KAO( :, 5, 4,14) = (/&
&1.8705E+01_JPRB,1.6367E+01_JPRB,1.4344E+01_JPRB,1.3059E+01_JPRB,1.2388E+01_JPRB,1.4128E+01_JPRB,&
&1.6951E+01_JPRB,1.9772E+01_JPRB,2.2482E+01_JPRB/)
KAO( :, 1, 5,14) = (/&
&2.1405E+01_JPRB,1.8730E+01_JPRB,1.6310E+01_JPRB,1.4662E+01_JPRB,1.3708E+01_JPRB,1.2986E+01_JPRB,&
&1.4754E+01_JPRB,1.7211E+01_JPRB,1.9632E+01_JPRB/)
KAO( :, 2, 5,14) = (/&
&2.1056E+01_JPRB,1.8424E+01_JPRB,1.6104E+01_JPRB,1.4452E+01_JPRB,1.3630E+01_JPRB,1.3357E+01_JPRB,&
&1.5611E+01_JPRB,1.8209E+01_JPRB,2.0772E+01_JPRB/)
KAO( :, 3, 5,14) = (/&
&2.0747E+01_JPRB,1.8154E+01_JPRB,1.5912E+01_JPRB,1.4296E+01_JPRB,1.3454E+01_JPRB,1.3757E+01_JPRB,&
&1.6382E+01_JPRB,1.9110E+01_JPRB,2.1795E+01_JPRB/)
KAO( :, 4, 5,14) = (/&
&2.0481E+01_JPRB,1.7921E+01_JPRB,1.5733E+01_JPRB,1.4190E+01_JPRB,1.3288E+01_JPRB,1.4283E+01_JPRB,&
&1.7134E+01_JPRB,1.9987E+01_JPRB,2.2797E+01_JPRB/)
KAO( :, 5, 5,14) = (/&
&2.0280E+01_JPRB,1.7745E+01_JPRB,1.5569E+01_JPRB,1.4068E+01_JPRB,1.3222E+01_JPRB,1.4895E+01_JPRB,&
&1.7870E+01_JPRB,2.0845E+01_JPRB,2.3770E+01_JPRB/)
KAO( :, 1, 6,14) = (/&
&2.2830E+01_JPRB,1.9976E+01_JPRB,1.7445E+01_JPRB,1.5500E+01_JPRB,1.4530E+01_JPRB,1.3547E+01_JPRB,&
&1.4948E+01_JPRB,1.7437E+01_JPRB,1.9911E+01_JPRB/)
KAO( :, 2, 6,14) = (/&
&2.2630E+01_JPRB,1.9801E+01_JPRB,1.7366E+01_JPRB,1.5418E+01_JPRB,1.4459E+01_JPRB,1.3928E+01_JPRB,&
&1.5968E+01_JPRB,1.8628E+01_JPRB,2.1268E+01_JPRB/)
KAO( :, 3, 6,14) = (/&
&2.2482E+01_JPRB,1.9672E+01_JPRB,1.7308E+01_JPRB,1.5393E+01_JPRB,1.4260E+01_JPRB,1.4337E+01_JPRB,&
&1.6867E+01_JPRB,1.9676E+01_JPRB,2.2466E+01_JPRB/)
KAO( :, 4, 6,14) = (/&
&2.2407E+01_JPRB,1.9606E+01_JPRB,1.7216E+01_JPRB,1.5390E+01_JPRB,1.4119E+01_JPRB,1.4843E+01_JPRB,&
&1.7739E+01_JPRB,2.0693E+01_JPRB,2.3625E+01_JPRB/)
KAO( :, 5, 6,14) = (/&
&2.2367E+01_JPRB,1.9571E+01_JPRB,1.7137E+01_JPRB,1.5329E+01_JPRB,1.4055E+01_JPRB,1.5517E+01_JPRB,&
&1.8617E+01_JPRB,2.1718E+01_JPRB,2.4792E+01_JPRB/)
KAO( :, 1, 7,14) = (/&
&2.4592E+01_JPRB,2.1518E+01_JPRB,1.8856E+01_JPRB,1.6609E+01_JPRB,1.5320E+01_JPRB,1.4052E+01_JPRB,&
&1.5041E+01_JPRB,1.7546E+01_JPRB,2.0045E+01_JPRB/)
KAO( :, 2, 7,14) = (/&
&2.4606E+01_JPRB,2.1531E+01_JPRB,1.8929E+01_JPRB,1.6667E+01_JPRB,1.5279E+01_JPRB,1.4417E+01_JPRB,&
&1.6211E+01_JPRB,1.8911E+01_JPRB,2.1602E+01_JPRB/)
KAO( :, 3, 7,14) = (/&
&2.4628E+01_JPRB,2.1549E+01_JPRB,1.8928E+01_JPRB,1.6801E+01_JPRB,1.5124E+01_JPRB,1.4851E+01_JPRB,&
&1.7257E+01_JPRB,2.0131E+01_JPRB,2.2994E+01_JPRB/)
KAO( :, 4, 7,14) = (/&
&2.4701E+01_JPRB,2.1614E+01_JPRB,1.8944E+01_JPRB,1.6872E+01_JPRB,1.5057E+01_JPRB,1.5367E+01_JPRB,&
&1.8273E+01_JPRB,2.1316E+01_JPRB,2.4350E+01_JPRB/)
KAO( :, 5, 7,14) = (/&
&2.4745E+01_JPRB,2.1652E+01_JPRB,1.8953E+01_JPRB,1.6836E+01_JPRB,1.5058E+01_JPRB,1.6097E+01_JPRB,&
&1.9310E+01_JPRB,2.2526E+01_JPRB,2.5728E+01_JPRB/)
KAO( :, 1, 8,14) = (/&
&2.6722E+01_JPRB,2.3382E+01_JPRB,2.0515E+01_JPRB,1.7956E+01_JPRB,1.6236E+01_JPRB,1.4458E+01_JPRB,&
&1.5041E+01_JPRB,1.7547E+01_JPRB,2.0050E+01_JPRB/)
KAO( :, 2, 8,14) = (/&
&2.6899E+01_JPRB,2.3537E+01_JPRB,2.0679E+01_JPRB,1.8189E+01_JPRB,1.6278E+01_JPRB,1.4827E+01_JPRB,&
&1.6369E+01_JPRB,1.9095E+01_JPRB,2.1820E+01_JPRB/)
KAO( :, 3, 8,14) = (/&
&2.7094E+01_JPRB,2.3707E+01_JPRB,2.0816E+01_JPRB,1.8418E+01_JPRB,1.6222E+01_JPRB,1.5309E+01_JPRB,&
&1.7578E+01_JPRB,2.0506E+01_JPRB,2.3432E+01_JPRB/)
KAO( :, 4, 8,14) = (/&
&2.7179E+01_JPRB,2.3782E+01_JPRB,2.0862E+01_JPRB,1.8540E+01_JPRB,1.6231E+01_JPRB,1.5886E+01_JPRB,&
&1.8721E+01_JPRB,2.1839E+01_JPRB,2.4952E+01_JPRB/)
KAO( :, 5, 8,14) = (/&
&2.7158E+01_JPRB,2.3764E+01_JPRB,2.0818E+01_JPRB,1.8502E+01_JPRB,1.6332E+01_JPRB,1.6675E+01_JPRB,&
&1.9896E+01_JPRB,2.3208E+01_JPRB,2.6519E+01_JPRB/)
KAO( :, 1, 9,14) = (/&
&2.9121E+01_JPRB,2.5481E+01_JPRB,2.2378E+01_JPRB,1.9520E+01_JPRB,1.7350E+01_JPRB,1.4884E+01_JPRB,&
&1.4926E+01_JPRB,1.7361E+01_JPRB,1.9841E+01_JPRB/)
KAO( :, 2, 9,14) = (/&
&2.9461E+01_JPRB,2.5779E+01_JPRB,2.2643E+01_JPRB,1.9924E+01_JPRB,1.7494E+01_JPRB,1.5326E+01_JPRB,&
&1.6362E+01_JPRB,1.9088E+01_JPRB,2.1811E+01_JPRB/)
KAO( :, 3, 9,14) = (/&
&2.9610E+01_JPRB,2.5909E+01_JPRB,2.2771E+01_JPRB,2.0181E+01_JPRB,1.7582E+01_JPRB,1.5909E+01_JPRB,&
&1.7732E+01_JPRB,2.0686E+01_JPRB,2.3639E+01_JPRB/)
KAO( :, 4, 9,14) = (/&
&2.9659E+01_JPRB,2.5951E+01_JPRB,2.2782E+01_JPRB,2.0281E+01_JPRB,1.7675E+01_JPRB,1.6616E+01_JPRB,&
&1.9018E+01_JPRB,2.2187E+01_JPRB,2.5355E+01_JPRB/)
KAO( :, 5, 9,14) = (/&
&2.9568E+01_JPRB,2.5872E+01_JPRB,2.2719E+01_JPRB,2.0302E+01_JPRB,1.7861E+01_JPRB,1.7429E+01_JPRB,&
&2.0313E+01_JPRB,2.3697E+01_JPRB,2.7083E+01_JPRB/)
KAO( :, 1,10,14) = (/&
&3.1663E+01_JPRB,2.7706E+01_JPRB,2.4344E+01_JPRB,2.1280E+01_JPRB,1.8643E+01_JPRB,1.5678E+01_JPRB,&
&1.4935E+01_JPRB,1.7101E+01_JPRB,1.9544E+01_JPRB/)
KAO( :, 2,10,14) = (/&
&3.1965E+01_JPRB,2.7969E+01_JPRB,2.4607E+01_JPRB,2.1722E+01_JPRB,1.8925E+01_JPRB,1.6156E+01_JPRB,&
&1.6364E+01_JPRB,1.9004E+01_JPRB,2.1720E+01_JPRB/)
KAO( :, 3,10,14) = (/&
&3.2079E+01_JPRB,2.8070E+01_JPRB,2.4675E+01_JPRB,2.1979E+01_JPRB,1.9142E+01_JPRB,1.6843E+01_JPRB,&
&1.7782E+01_JPRB,2.0734E+01_JPRB,2.3694E+01_JPRB/)
KAO( :, 4,10,14) = (/&
&3.2076E+01_JPRB,2.8066E+01_JPRB,2.4720E+01_JPRB,2.2134E+01_JPRB,1.9355E+01_JPRB,1.7612E+01_JPRB,&
&1.9151E+01_JPRB,2.2342E+01_JPRB,2.5534E+01_JPRB/)
KAO( :, 5,10,14) = (/&
&3.2013E+01_JPRB,2.8013E+01_JPRB,2.4760E+01_JPRB,2.2247E+01_JPRB,1.9618E+01_JPRB,1.8439E+01_JPRB,&
&2.0533E+01_JPRB,2.3954E+01_JPRB,2.7375E+01_JPRB/)
KAO( :, 1,11,14) = (/&
&3.4213E+01_JPRB,2.9936E+01_JPRB,2.6354E+01_JPRB,2.3259E+01_JPRB,2.0227E+01_JPRB,1.7029E+01_JPRB,&
&1.5715E+01_JPRB,1.7610E+01_JPRB,2.0126E+01_JPRB/)
KAO( :, 2,11,14) = (/&
&3.4370E+01_JPRB,3.0074E+01_JPRB,2.6508E+01_JPRB,2.3642E+01_JPRB,2.0586E+01_JPRB,1.7628E+01_JPRB,&
&1.7120E+01_JPRB,1.9500E+01_JPRB,2.2284E+01_JPRB/)
KAO( :, 3,11,14) = (/&
&3.4467E+01_JPRB,3.0174E+01_JPRB,2.6677E+01_JPRB,2.3905E+01_JPRB,2.0930E+01_JPRB,1.8395E+01_JPRB,&
&1.8472E+01_JPRB,2.1240E+01_JPRB,2.4275E+01_JPRB/)
KAO( :, 4,11,14) = (/&
&3.4474E+01_JPRB,3.0204E+01_JPRB,2.6823E+01_JPRB,2.4177E+01_JPRB,2.1309E+01_JPRB,1.9245E+01_JPRB,&
&1.9858E+01_JPRB,2.2983E+01_JPRB,2.6259E+01_JPRB/)
KAO( :, 5,11,14) = (/&
&3.4438E+01_JPRB,3.0209E+01_JPRB,2.6964E+01_JPRB,2.4440E+01_JPRB,2.1741E+01_JPRB,2.0132E+01_JPRB,&
&2.1286E+01_JPRB,2.4694E+01_JPRB,2.8209E+01_JPRB/)
KAO( :, 1,12,14) = (/&
&3.6462E+01_JPRB,3.1921E+01_JPRB,2.8185E+01_JPRB,2.5122E+01_JPRB,2.1872E+01_JPRB,1.8703E+01_JPRB,&
&1.6650E+01_JPRB,1.7829E+01_JPRB,2.0376E+01_JPRB/)
KAO( :, 2,12,14) = (/&
&3.6640E+01_JPRB,3.2114E+01_JPRB,2.8470E+01_JPRB,2.5545E+01_JPRB,2.2388E+01_JPRB,1.9455E+01_JPRB,&
&1.8025E+01_JPRB,1.9728E+01_JPRB,2.2541E+01_JPRB/)
KAO( :, 3,12,14) = (/&
&3.6727E+01_JPRB,3.2238E+01_JPRB,2.8745E+01_JPRB,2.5954E+01_JPRB,2.2942E+01_JPRB,2.0299E+01_JPRB,&
&1.9338E+01_JPRB,2.1588E+01_JPRB,2.4664E+01_JPRB/)
KAO( :, 4,12,14) = (/&
&3.6769E+01_JPRB,3.2319E+01_JPRB,2.8973E+01_JPRB,2.6373E+01_JPRB,2.3500E+01_JPRB,2.1128E+01_JPRB,&
&2.0696E+01_JPRB,2.3398E+01_JPRB,2.6730E+01_JPRB/)
KAO( :, 5,12,14) = (/&
&3.6803E+01_JPRB,3.2384E+01_JPRB,2.9220E+01_JPRB,2.6759E+01_JPRB,2.4088E+01_JPRB,2.2049E+01_JPRB,&
&2.2111E+01_JPRB,2.5193E+01_JPRB,2.8777E+01_JPRB/)
KAO( :, 1,13,14) = (/&
&3.8467E+01_JPRB,3.3764E+01_JPRB,3.0006E+01_JPRB,2.6925E+01_JPRB,2.3614E+01_JPRB,2.0501E+01_JPRB,&
&1.7640E+01_JPRB,1.7695E+01_JPRB,2.0215E+01_JPRB/)
KAO( :, 2,13,14) = (/&
&3.8636E+01_JPRB,3.3983E+01_JPRB,3.0407E+01_JPRB,2.7476E+01_JPRB,2.4350E+01_JPRB,2.1406E+01_JPRB,&
&1.8958E+01_JPRB,1.9690E+01_JPRB,2.2491E+01_JPRB/)
KAO( :, 3,13,14) = (/&
&3.8793E+01_JPRB,3.4176E+01_JPRB,3.0759E+01_JPRB,2.8040E+01_JPRB,2.5106E+01_JPRB,2.2301E+01_JPRB,&
&2.0233E+01_JPRB,2.1614E+01_JPRB,2.4689E+01_JPRB/)
KAO( :, 4,13,14) = (/&
&3.8901E+01_JPRB,3.4320E+01_JPRB,3.1137E+01_JPRB,2.8555E+01_JPRB,2.5821E+01_JPRB,2.3168E+01_JPRB,&
&2.1608E+01_JPRB,2.3543E+01_JPRB,2.6893E+01_JPRB/)
KAO( :, 5,13,14) = (/&
&3.8995E+01_JPRB,3.4448E+01_JPRB,3.1494E+01_JPRB,2.9062E+01_JPRB,2.6523E+01_JPRB,2.4144E+01_JPRB,&
&2.3025E+01_JPRB,2.5501E+01_JPRB,2.9129E+01_JPRB/)
KAO( :, 1, 1,15) = (/&
&2.2665E+01_JPRB,1.9832E+01_JPRB,1.6999E+01_JPRB,1.4166E+01_JPRB,1.3383E+01_JPRB,1.5987E+01_JPRB,&
&1.9182E+01_JPRB,2.2378E+01_JPRB,2.4474E+01_JPRB/)
KAO( :, 2, 1,15) = (/&
&2.1844E+01_JPRB,1.9113E+01_JPRB,1.6383E+01_JPRB,1.3666E+01_JPRB,1.3442E+01_JPRB,1.6440E+01_JPRB,&
&1.9723E+01_JPRB,2.3008E+01_JPRB,2.5060E+01_JPRB/)
KAO( :, 3, 1,15) = (/&
&2.1030E+01_JPRB,1.8401E+01_JPRB,1.5773E+01_JPRB,1.3277E+01_JPRB,1.3532E+01_JPRB,1.6873E+01_JPRB,&
&2.0241E+01_JPRB,2.3609E+01_JPRB,2.5652E+01_JPRB/)
KAO( :, 4, 1,15) = (/&
&2.0230E+01_JPRB,1.7702E+01_JPRB,1.5173E+01_JPRB,1.2884E+01_JPRB,1.3829E+01_JPRB,1.7277E+01_JPRB,&
&2.0725E+01_JPRB,2.4172E+01_JPRB,2.6214E+01_JPRB/)
KAO( :, 5, 1,15) = (/&
&1.9446E+01_JPRB,1.7016E+01_JPRB,1.4585E+01_JPRB,1.2542E+01_JPRB,1.4133E+01_JPRB,1.7655E+01_JPRB,&
&2.1178E+01_JPRB,2.4699E+01_JPRB,2.6742E+01_JPRB/)
KAO( :, 1, 2,15) = (/&
&2.4301E+01_JPRB,2.1263E+01_JPRB,1.8226E+01_JPRB,1.5270E+01_JPRB,1.4740E+01_JPRB,1.7631E+01_JPRB,&
&2.1154E+01_JPRB,2.4675E+01_JPRB,2.7320E+01_JPRB/)
KAO( :, 2, 2,15) = (/&
&2.3371E+01_JPRB,2.0449E+01_JPRB,1.7528E+01_JPRB,1.4826E+01_JPRB,1.4773E+01_JPRB,1.8276E+01_JPRB,&
&2.1927E+01_JPRB,2.5577E+01_JPRB,2.8254E+01_JPRB/)
KAO( :, 3, 2,15) = (/&
&2.2456E+01_JPRB,1.9650E+01_JPRB,1.6843E+01_JPRB,1.4407E+01_JPRB,1.5106E+01_JPRB,1.8875E+01_JPRB,&
&2.2644E+01_JPRB,2.6416E+01_JPRB,2.9163E+01_JPRB/)
KAO( :, 4, 2,15) = (/&
&2.1563E+01_JPRB,1.8868E+01_JPRB,1.6173E+01_JPRB,1.4036E+01_JPRB,1.5558E+01_JPRB,1.9438E+01_JPRB,&
&2.3319E+01_JPRB,2.7202E+01_JPRB,2.9991E+01_JPRB/)
KAO( :, 5, 2,15) = (/&
&2.0691E+01_JPRB,1.8105E+01_JPRB,1.5519E+01_JPRB,1.3694E+01_JPRB,1.5968E+01_JPRB,1.9949E+01_JPRB,&
&2.3930E+01_JPRB,2.7910E+01_JPRB,3.0755E+01_JPRB/)
KAO( :, 1, 3,15) = (/&
&2.6150E+01_JPRB,2.2881E+01_JPRB,1.9612E+01_JPRB,1.6625E+01_JPRB,1.6080E+01_JPRB,1.9323E+01_JPRB,&
&2.3184E+01_JPRB,2.7047E+01_JPRB,3.0423E+01_JPRB/)
KAO( :, 2, 3,15) = (/&
&2.5095E+01_JPRB,2.1958E+01_JPRB,1.8821E+01_JPRB,1.6149E+01_JPRB,1.6204E+01_JPRB,2.0181E+01_JPRB,&
&2.4213E+01_JPRB,2.8246E+01_JPRB,3.1757E+01_JPRB/)
KAO( :, 3, 3,15) = (/&
&2.4070E+01_JPRB,2.1061E+01_JPRB,1.8052E+01_JPRB,1.5726E+01_JPRB,1.6789E+01_JPRB,2.0979E+01_JPRB,&
&2.5169E+01_JPRB,2.9357E+01_JPRB,3.2991E+01_JPRB/)
KAO( :, 4, 3,15) = (/&
&2.3070E+01_JPRB,2.0187E+01_JPRB,1.7303E+01_JPRB,1.5335E+01_JPRB,1.7368E+01_JPRB,2.1701E+01_JPRB,&
&2.6034E+01_JPRB,3.0366E+01_JPRB,3.4124E+01_JPRB/)
KAO( :, 5, 3,15) = (/&
&2.2104E+01_JPRB,1.9341E+01_JPRB,1.6579E+01_JPRB,1.4961E+01_JPRB,1.7892E+01_JPRB,2.2355E+01_JPRB,&
&2.6817E+01_JPRB,3.1278E+01_JPRB,3.5133E+01_JPRB/)
KAO( :, 1, 4,15) = (/&
&2.8084E+01_JPRB,2.4574E+01_JPRB,2.1063E+01_JPRB,1.8074E+01_JPRB,1.7393E+01_JPRB,2.1136E+01_JPRB,&
&2.5360E+01_JPRB,2.9584E+01_JPRB,3.3561E+01_JPRB/)
KAO( :, 2, 4,15) = (/&
&2.6902E+01_JPRB,2.3539E+01_JPRB,2.0176E+01_JPRB,1.7575E+01_JPRB,1.7767E+01_JPRB,2.2202E+01_JPRB,&
&2.6641E+01_JPRB,3.1076E+01_JPRB,3.5240E+01_JPRB/)
KAO( :, 3, 4,15) = (/&
&2.5761E+01_JPRB,2.2541E+01_JPRB,1.9321E+01_JPRB,1.7116E+01_JPRB,1.8559E+01_JPRB,2.3193E+01_JPRB,&
&2.7826E+01_JPRB,3.2458E+01_JPRB,3.6803E+01_JPRB/)
KAO( :, 4, 4,15) = (/&
&2.4660E+01_JPRB,2.1578E+01_JPRB,1.8496E+01_JPRB,1.6679E+01_JPRB,1.9285E+01_JPRB,2.4099E+01_JPRB,&
&2.8913E+01_JPRB,3.3725E+01_JPRB,3.8229E+01_JPRB/)
KAO( :, 5, 4,15) = (/&
&2.3603E+01_JPRB,2.0653E+01_JPRB,1.7702E+01_JPRB,1.6251E+01_JPRB,1.9930E+01_JPRB,2.4904E+01_JPRB,&
&2.9878E+01_JPRB,3.4850E+01_JPRB,3.9510E+01_JPRB/)
KAO( :, 1, 5,15) = (/&
&3.0121E+01_JPRB,2.6356E+01_JPRB,2.2591E+01_JPRB,1.9572E+01_JPRB,1.8803E+01_JPRB,2.3068E+01_JPRB,&
&2.7679E+01_JPRB,3.2291E+01_JPRB,3.6764E+01_JPRB/)
KAO( :, 2, 5,15) = (/&
&2.8817E+01_JPRB,2.5215E+01_JPRB,2.1613E+01_JPRB,1.9016E+01_JPRB,1.9519E+01_JPRB,2.4395E+01_JPRB,&
&2.9271E+01_JPRB,3.4145E+01_JPRB,3.8882E+01_JPRB/)
KAO( :, 3, 5,15) = (/&
&2.7566E+01_JPRB,2.4120E+01_JPRB,2.0674E+01_JPRB,1.8500E+01_JPRB,2.0501E+01_JPRB,2.5621E+01_JPRB,&
&3.0741E+01_JPRB,3.5860E+01_JPRB,4.0822E+01_JPRB/)
KAO( :, 4, 5,15) = (/&
&2.6363E+01_JPRB,2.3068E+01_JPRB,1.9789E+01_JPRB,1.8007E+01_JPRB,2.1387E+01_JPRB,2.6727E+01_JPRB,&
&3.2067E+01_JPRB,3.7405E+01_JPRB,4.2586E+01_JPRB/)
KAO( :, 5, 5,15) = (/&
&2.5212E+01_JPRB,2.2061E+01_JPRB,1.9051E+01_JPRB,1.7643E+01_JPRB,2.2182E+01_JPRB,2.7719E+01_JPRB,&
&3.3256E+01_JPRB,3.8795E+01_JPRB,4.4162E+01_JPRB/)
KAO( :, 1, 6,15) = (/&
&3.2321E+01_JPRB,2.8281E+01_JPRB,2.4241E+01_JPRB,2.1098E+01_JPRB,2.0339E+01_JPRB,2.4932E+01_JPRB,&
&2.9917E+01_JPRB,3.4901E+01_JPRB,3.9811E+01_JPRB/)
KAO( :, 2, 6,15) = (/&
&3.0886E+01_JPRB,2.7025E+01_JPRB,2.3164E+01_JPRB,2.0488E+01_JPRB,2.1264E+01_JPRB,2.6574E+01_JPRB,&
&3.1885E+01_JPRB,3.7195E+01_JPRB,4.2430E+01_JPRB/)
KAO( :, 3, 6,15) = (/&
&2.9511E+01_JPRB,2.5822E+01_JPRB,2.2177E+01_JPRB,1.9914E+01_JPRB,2.2458E+01_JPRB,2.8068E+01_JPRB,&
&3.3678E+01_JPRB,3.9285E+01_JPRB,4.4801E+01_JPRB/)
KAO( :, 4, 6,15) = (/&
&2.8199E+01_JPRB,2.4674E+01_JPRB,2.1349E+01_JPRB,1.9431E+01_JPRB,2.3532E+01_JPRB,2.9409E+01_JPRB,&
&3.5286E+01_JPRB,4.1160E+01_JPRB,4.6949E+01_JPRB/)
KAO( :, 5, 6,15) = (/&
&2.6942E+01_JPRB,2.3574E+01_JPRB,2.0489E+01_JPRB,1.9227E+01_JPRB,2.4487E+01_JPRB,3.0601E+01_JPRB,&
&3.6715E+01_JPRB,4.2828E+01_JPRB,4.8844E+01_JPRB/)
KAO( :, 1, 7,15) = (/&
&3.4610E+01_JPRB,3.0284E+01_JPRB,2.5957E+01_JPRB,2.2686E+01_JPRB,2.1900E+01_JPRB,2.6660E+01_JPRB,&
&3.1990E+01_JPRB,3.7320E+01_JPRB,4.2613E+01_JPRB/)
KAO( :, 2, 7,15) = (/&
&3.3032E+01_JPRB,2.8903E+01_JPRB,2.4823E+01_JPRB,2.1999E+01_JPRB,2.2959E+01_JPRB,2.8635E+01_JPRB,&
&3.4359E+01_JPRB,4.0081E+01_JPRB,4.5761E+01_JPRB/)
KAO( :, 3, 7,15) = (/&
&3.1543E+01_JPRB,2.7600E+01_JPRB,2.3940E+01_JPRB,2.1366E+01_JPRB,2.4341E+01_JPRB,3.0423E+01_JPRB,&
&3.6504E+01_JPRB,4.2582E+01_JPRB,4.8628E+01_JPRB/)
KAO( :, 4, 7,15) = (/&
&3.0190E+01_JPRB,2.6416E+01_JPRB,2.3001E+01_JPRB,2.1013E+01_JPRB,2.5623E+01_JPRB,3.2024E+01_JPRB,&
&3.8424E+01_JPRB,4.4822E+01_JPRB,5.1169E+01_JPRB/)
KAO( :, 5, 7,15) = (/&
&2.9167E+01_JPRB,2.5521E+01_JPRB,2.2165E+01_JPRB,2.1088E+01_JPRB,2.6745E+01_JPRB,3.3425E+01_JPRB,&
&4.0104E+01_JPRB,4.6781E+01_JPRB,5.3415E+01_JPRB/)
KAO( :, 1, 8,15) = (/&
&3.7034E+01_JPRB,3.2405E+01_JPRB,2.7803E+01_JPRB,2.4330E+01_JPRB,2.3433E+01_JPRB,2.8325E+01_JPRB,&
&3.3988E+01_JPRB,3.9652E+01_JPRB,4.5298E+01_JPRB/)
KAO( :, 2, 8,15) = (/&
&3.5387E+01_JPRB,3.0964E+01_JPRB,2.6815E+01_JPRB,2.3568E+01_JPRB,2.4642E+01_JPRB,3.0668E+01_JPRB,&
&3.6800E+01_JPRB,4.2932E+01_JPRB,4.9043E+01_JPRB/)
KAO( :, 3, 8,15) = (/&
&3.3957E+01_JPRB,2.9713E+01_JPRB,2.5844E+01_JPRB,2.3027E+01_JPRB,2.6228E+01_JPRB,3.2782E+01_JPRB,&
&3.9335E+01_JPRB,4.5888E+01_JPRB,5.2425E+01_JPRB/)
KAO( :, 4, 8,15) = (/&
&3.2996E+01_JPRB,2.8872E+01_JPRB,2.5090E+01_JPRB,2.2964E+01_JPRB,2.7731E+01_JPRB,3.4659E+01_JPRB,&
&4.1586E+01_JPRB,4.8516E+01_JPRB,5.5417E+01_JPRB/)
KAO( :, 5, 8,15) = (/&
&3.2468E+01_JPRB,2.8410E+01_JPRB,2.4743E+01_JPRB,2.3402E+01_JPRB,2.9047E+01_JPRB,3.6303E+01_JPRB,&
&4.3558E+01_JPRB,5.0811E+01_JPRB,5.8046E+01_JPRB/)
KAO( :, 1, 9,15) = (/&
&3.9783E+01_JPRB,3.4811E+01_JPRB,2.9994E+01_JPRB,2.6093E+01_JPRB,2.4971E+01_JPRB,2.9758E+01_JPRB,&
&3.5708E+01_JPRB,4.1658E+01_JPRB,4.7610E+01_JPRB/)
KAO( :, 2, 9,15) = (/&
&3.8247E+01_JPRB,3.3466E+01_JPRB,2.9067E+01_JPRB,2.5305E+01_JPRB,2.6362E+01_JPRB,3.2520E+01_JPRB,&
&3.9021E+01_JPRB,4.5520E+01_JPRB,5.2017E+01_JPRB/)
KAO( :, 3, 9,15) = (/&
&3.7366E+01_JPRB,3.2696E+01_JPRB,2.8422E+01_JPRB,2.5157E+01_JPRB,2.8053E+01_JPRB,3.4990E+01_JPRB,&
&4.1984E+01_JPRB,4.8979E+01_JPRB,5.5970E+01_JPRB/)
KAO( :, 4, 9,15) = (/&
&3.6951E+01_JPRB,3.2332E+01_JPRB,2.8166E+01_JPRB,2.5574E+01_JPRB,2.9746E+01_JPRB,3.7179E+01_JPRB,&
&4.4610E+01_JPRB,5.2042E+01_JPRB,5.9480E+01_JPRB/)
KAO( :, 5, 9,15) = (/&
&3.6807E+01_JPRB,3.2206E+01_JPRB,2.8238E+01_JPRB,2.6320E+01_JPRB,3.1345E+01_JPRB,3.9177E+01_JPRB,&
&4.7007E+01_JPRB,5.4838E+01_JPRB,6.2666E+01_JPRB/)
KAO( :, 1,10,15) = (/&
&4.3060E+01_JPRB,3.7677E+01_JPRB,3.2562E+01_JPRB,2.8079E+01_JPRB,2.6750E+01_JPRB,3.1106E+01_JPRB,&
&3.7325E+01_JPRB,4.3543E+01_JPRB,4.9762E+01_JPRB/)
KAO( :, 2,10,15) = (/&
&4.2169E+01_JPRB,3.6897E+01_JPRB,3.2071E+01_JPRB,2.7706E+01_JPRB,2.8300E+01_JPRB,3.4266E+01_JPRB,&
&4.1118E+01_JPRB,4.7968E+01_JPRB,5.4829E+01_JPRB/)
KAO( :, 3,10,15) = (/&
&4.1907E+01_JPRB,3.6669E+01_JPRB,3.1957E+01_JPRB,2.8123E+01_JPRB,3.0151E+01_JPRB,3.7151E+01_JPRB,&
&4.4578E+01_JPRB,5.2003E+01_JPRB,5.9438E+01_JPRB/)
KAO( :, 4,10,15) = (/&
&4.1908E+01_JPRB,3.6670E+01_JPRB,3.2098E+01_JPRB,2.8899E+01_JPRB,3.2061E+01_JPRB,3.9810E+01_JPRB,&
&4.7769E+01_JPRB,5.5728E+01_JPRB,6.3685E+01_JPRB/)
KAO( :, 5,10,15) = (/&
&4.2172E+01_JPRB,3.6900E+01_JPRB,3.2471E+01_JPRB,2.9889E+01_JPRB,3.3921E+01_JPRB,4.2203E+01_JPRB,&
&5.0640E+01_JPRB,5.9081E+01_JPRB,6.7523E+01_JPRB/)
KAO( :, 1,11,15) = (/&
&4.7323E+01_JPRB,4.1408E+01_JPRB,3.5997E+01_JPRB,3.0832E+01_JPRB,2.9578E+01_JPRB,3.3795E+01_JPRB,&
&4.0553E+01_JPRB,4.7310E+01_JPRB,5.4070E+01_JPRB/)
KAO( :, 2,11,15) = (/&
&4.7418E+01_JPRB,4.1491E+01_JPRB,3.6200E+01_JPRB,3.1353E+01_JPRB,3.1571E+01_JPRB,3.7371E+01_JPRB,&
&4.4844E+01_JPRB,5.2315E+01_JPRB,5.9798E+01_JPRB/)
KAO( :, 3,11,15) = (/&
&4.7687E+01_JPRB,4.1726E+01_JPRB,3.6545E+01_JPRB,3.2311E+01_JPRB,3.3701E+01_JPRB,4.0657E+01_JPRB,&
&4.8786E+01_JPRB,5.6913E+01_JPRB,6.5046E+01_JPRB/)
KAO( :, 4,11,15) = (/&
&4.8161E+01_JPRB,4.2141E+01_JPRB,3.7083E+01_JPRB,3.3405E+01_JPRB,3.5837E+01_JPRB,4.3612E+01_JPRB,&
&5.2330E+01_JPRB,6.1049E+01_JPRB,6.9766E+01_JPRB/)
KAO( :, 5,11,15) = (/&
&4.8813E+01_JPRB,4.2712E+01_JPRB,3.7729E+01_JPRB,3.4639E+01_JPRB,3.7893E+01_JPRB,4.6304E+01_JPRB,&
&5.5561E+01_JPRB,6.4817E+01_JPRB,7.4079E+01_JPRB/)
KAO( :, 1,12,15) = (/&
&5.3537E+01_JPRB,4.6845E+01_JPRB,4.0868E+01_JPRB,3.5074E+01_JPRB,3.3315E+01_JPRB,3.6716E+01_JPRB,&
&4.3952E+01_JPRB,5.1273E+01_JPRB,5.8607E+01_JPRB/)
KAO( :, 2,12,15) = (/&
&5.4108E+01_JPRB,4.7344E+01_JPRB,4.1453E+01_JPRB,3.6183E+01_JPRB,3.5626E+01_JPRB,4.0597E+01_JPRB,&
&4.8705E+01_JPRB,5.6822E+01_JPRB,6.4945E+01_JPRB/)
KAO( :, 3,12,15) = (/&
&5.4788E+01_JPRB,4.7940E+01_JPRB,4.2158E+01_JPRB,3.7480E+01_JPRB,3.7956E+01_JPRB,4.4233E+01_JPRB,&
&5.3076E+01_JPRB,6.1921E+01_JPRB,7.0769E+01_JPRB/)
KAO( :, 4,12,15) = (/&
&5.5656E+01_JPRB,4.8699E+01_JPRB,4.2978E+01_JPRB,3.8824E+01_JPRB,4.0296E+01_JPRB,4.7573E+01_JPRB,&
&5.7085E+01_JPRB,6.6598E+01_JPRB,7.6119E+01_JPRB/)
KAO( :, 5,12,15) = (/&
&5.6545E+01_JPRB,4.9477E+01_JPRB,4.3802E+01_JPRB,4.0209E+01_JPRB,4.2495E+01_JPRB,5.0548E+01_JPRB,&
&6.0654E+01_JPRB,7.0757E+01_JPRB,8.0864E+01_JPRB/)
KAO( :, 1,13,15) = (/&
&6.1085E+01_JPRB,5.3449E+01_JPRB,4.6803E+01_JPRB,4.0529E+01_JPRB,3.7896E+01_JPRB,4.0194E+01_JPRB,&
&4.7752E+01_JPRB,5.5708E+01_JPRB,6.3666E+01_JPRB/)
KAO( :, 2,13,15) = (/&
&6.2117E+01_JPRB,5.4352E+01_JPRB,4.7746E+01_JPRB,4.2003E+01_JPRB,4.0420E+01_JPRB,4.4278E+01_JPRB,&
&5.2905E+01_JPRB,6.1722E+01_JPRB,7.0545E+01_JPRB/)
KAO( :, 3,13,15) = (/&
&6.3149E+01_JPRB,5.5256E+01_JPRB,4.8730E+01_JPRB,4.3496E+01_JPRB,4.2927E+01_JPRB,4.8152E+01_JPRB,&
&5.7673E+01_JPRB,6.7281E+01_JPRB,7.6896E+01_JPRB/)
KAO( :, 4,13,15) = (/&
&6.4233E+01_JPRB,5.6204E+01_JPRB,4.9701E+01_JPRB,4.5014E+01_JPRB,4.5352E+01_JPRB,5.1670E+01_JPRB,&
&6.1941E+01_JPRB,7.2260E+01_JPRB,8.2578E+01_JPRB/)
KAO( :, 5,13,15) = (/&
&6.5315E+01_JPRB,5.7151E+01_JPRB,5.0642E+01_JPRB,4.6520E+01_JPRB,4.7583E+01_JPRB,5.4805E+01_JPRB,&
&6.5738E+01_JPRB,7.6689E+01_JPRB,8.7640E+01_JPRB/)
KAO( :, 1, 1,16) = (/&
&2.3217E+01_JPRB,2.0315E+01_JPRB,1.7413E+01_JPRB,1.4511E+01_JPRB,1.7128E+01_JPRB,2.1409E+01_JPRB,&
&2.5690E+01_JPRB,2.9970E+01_JPRB,3.1682E+01_JPRB/)
KAO( :, 2, 1,16) = (/&
&2.2360E+01_JPRB,1.9565E+01_JPRB,1.6770E+01_JPRB,1.3975E+01_JPRB,1.7727E+01_JPRB,2.2158E+01_JPRB,&
&2.6589E+01_JPRB,3.1019E+01_JPRB,3.2781E+01_JPRB/)
KAO( :, 3, 1,16) = (/&
&2.1511E+01_JPRB,1.8822E+01_JPRB,1.6134E+01_JPRB,1.3677E+01_JPRB,1.8236E+01_JPRB,2.2795E+01_JPRB,&
&2.7353E+01_JPRB,3.1910E+01_JPRB,3.3717E+01_JPRB/)
KAO( :, 4, 1,16) = (/&
&2.0675E+01_JPRB,1.8091E+01_JPRB,1.5507E+01_JPRB,1.4001E+01_JPRB,1.8668E+01_JPRB,2.3334E+01_JPRB,&
&2.8002E+01_JPRB,3.2666E+01_JPRB,3.4515E+01_JPRB/)
KAO( :, 5, 1,16) = (/&
&1.9862E+01_JPRB,1.7379E+01_JPRB,1.4897E+01_JPRB,1.4274E+01_JPRB,1.9032E+01_JPRB,2.3789E+01_JPRB,&
&2.8546E+01_JPRB,3.3301E+01_JPRB,3.5180E+01_JPRB/)
KAO( :, 1, 2,16) = (/&
&2.4993E+01_JPRB,2.1869E+01_JPRB,1.8745E+01_JPRB,1.5621E+01_JPRB,2.0288E+01_JPRB,2.5360E+01_JPRB,&
&3.0431E+01_JPRB,3.5501E+01_JPRB,3.8500E+01_JPRB/)
KAO( :, 2, 2,16) = (/&
&2.4003E+01_JPRB,2.1003E+01_JPRB,1.8003E+01_JPRB,1.5799E+01_JPRB,2.1064E+01_JPRB,2.6330E+01_JPRB,&
&3.1595E+01_JPRB,3.6859E+01_JPRB,3.9965E+01_JPRB/)
KAO( :, 3, 2,16) = (/&
&2.3031E+01_JPRB,2.0153E+01_JPRB,1.7274E+01_JPRB,1.6296E+01_JPRB,2.1728E+01_JPRB,2.7159E+01_JPRB,&
&3.2591E+01_JPRB,3.8020E+01_JPRB,4.1220E+01_JPRB/)
KAO( :, 4, 2,16) = (/&
&2.2084E+01_JPRB,1.9324E+01_JPRB,1.6564E+01_JPRB,1.6718E+01_JPRB,2.2290E+01_JPRB,2.7862E+01_JPRB,&
&3.3433E+01_JPRB,3.9003E+01_JPRB,4.2289E+01_JPRB/)
KAO( :, 5, 2,16) = (/&
&2.1176E+01_JPRB,1.8529E+01_JPRB,1.5883E+01_JPRB,1.7075E+01_JPRB,2.2766E+01_JPRB,2.8457E+01_JPRB,&
&3.4148E+01_JPRB,3.9837E+01_JPRB,4.3190E+01_JPRB/)
KAO( :, 1, 3,16) = (/&
&2.7048E+01_JPRB,2.3667E+01_JPRB,2.0286E+01_JPRB,1.7873E+01_JPRB,2.3831E+01_JPRB,2.9788E+01_JPRB,&
&3.5745E+01_JPRB,4.1700E+01_JPRB,4.6434E+01_JPRB/)
KAO( :, 2, 3,16) = (/&
&2.5923E+01_JPRB,2.2683E+01_JPRB,1.9443E+01_JPRB,1.8645E+01_JPRB,2.4860E+01_JPRB,3.1075E+01_JPRB,&
&3.7289E+01_JPRB,4.3501E+01_JPRB,4.8433E+01_JPRB/)
KAO( :, 3, 3,16) = (/&
&2.4829E+01_JPRB,2.1725E+01_JPRB,1.8622E+01_JPRB,1.9301E+01_JPRB,2.5734E+01_JPRB,3.2168E+01_JPRB,&
&3.8600E+01_JPRB,4.5030E+01_JPRB,5.0155E+01_JPRB/)
KAO( :, 4, 3,16) = (/&
&2.3775E+01_JPRB,2.0804E+01_JPRB,1.7832E+01_JPRB,1.9866E+01_JPRB,2.6487E+01_JPRB,3.3108E+01_JPRB,&
&3.9729E+01_JPRB,4.6348E+01_JPRB,5.1627E+01_JPRB/)
KAO( :, 5, 3,16) = (/&
&2.2759E+01_JPRB,1.9914E+01_JPRB,1.7070E+01_JPRB,2.0344E+01_JPRB,2.7124E+01_JPRB,3.3905E+01_JPRB,&
&4.0685E+01_JPRB,4.7463E+01_JPRB,5.2855E+01_JPRB/)
KAO( :, 1, 4,16) = (/&
&2.9281E+01_JPRB,2.5621E+01_JPRB,2.1961E+01_JPRB,2.0878E+01_JPRB,2.7836E+01_JPRB,3.4801E+01_JPRB,&
&4.1761E+01_JPRB,4.8718E+01_JPRB,5.5008E+01_JPRB/)
KAO( :, 2, 4,16) = (/&
&2.8016E+01_JPRB,2.4514E+01_JPRB,2.1012E+01_JPRB,2.1904E+01_JPRB,2.9205E+01_JPRB,3.6506E+01_JPRB,&
&4.3806E+01_JPRB,5.1103E+01_JPRB,5.7673E+01_JPRB/)
KAO( :, 3, 4,16) = (/&
&2.6800E+01_JPRB,2.3450E+01_JPRB,2.0100E+01_JPRB,2.2779E+01_JPRB,3.0372E+01_JPRB,3.7964E+01_JPRB,&
&4.5556E+01_JPRB,5.3145E+01_JPRB,6.0000E+01_JPRB/)
KAO( :, 4, 4,16) = (/&
&2.5622E+01_JPRB,2.2420E+01_JPRB,1.9217E+01_JPRB,2.3531E+01_JPRB,3.1375E+01_JPRB,3.9218E+01_JPRB,&
&4.7060E+01_JPRB,5.4900E+01_JPRB,6.1967E+01_JPRB/)
KAO( :, 5, 4,16) = (/&
&2.4489E+01_JPRB,2.1428E+01_JPRB,1.8368E+01_JPRB,2.4165E+01_JPRB,3.2219E+01_JPRB,4.0274E+01_JPRB,&
&4.8327E+01_JPRB,5.6378E+01_JPRB,6.3637E+01_JPRB/)
KAO( :, 1, 5,16) = (/&
&3.1572E+01_JPRB,2.7626E+01_JPRB,2.3679E+01_JPRB,2.4302E+01_JPRB,3.2402E+01_JPRB,4.0502E+01_JPRB,&
&4.8601E+01_JPRB,5.6697E+01_JPRB,6.4411E+01_JPRB/)
KAO( :, 2, 5,16) = (/&
&3.0155E+01_JPRB,2.6386E+01_JPRB,2.2616E+01_JPRB,2.5641E+01_JPRB,3.4188E+01_JPRB,4.2734E+01_JPRB,&
&5.1280E+01_JPRB,5.9822E+01_JPRB,6.7939E+01_JPRB/)
KAO( :, 3, 5,16) = (/&
&2.8800E+01_JPRB,2.5200E+01_JPRB,2.1600E+01_JPRB,2.6788E+01_JPRB,3.5717E+01_JPRB,4.4645E+01_JPRB,&
&5.3573E+01_JPRB,6.2498E+01_JPRB,7.0987E+01_JPRB/)
KAO( :, 4, 5,16) = (/&
&2.7508E+01_JPRB,2.4070E+01_JPRB,2.0631E+01_JPRB,2.7770E+01_JPRB,3.7026E+01_JPRB,4.6282E+01_JPRB,&
&5.5538E+01_JPRB,6.4790E+01_JPRB,7.3602E+01_JPRB/)
KAO( :, 5, 5,16) = (/&
&2.6277E+01_JPRB,2.2993E+01_JPRB,1.9723E+01_JPRB,2.8602E+01_JPRB,3.8136E+01_JPRB,4.7669E+01_JPRB,&
&5.7201E+01_JPRB,6.6735E+01_JPRB,7.5802E+01_JPRB/)
KAO( :, 1, 6,16) = (/&
&3.4063E+01_JPRB,2.9805E+01_JPRB,2.5548E+01_JPRB,2.8070E+01_JPRB,3.7426E+01_JPRB,4.6782E+01_JPRB,&
&5.6138E+01_JPRB,6.5490E+01_JPRB,7.4618E+01_JPRB/)
KAO( :, 2, 6,16) = (/&
&3.2500E+01_JPRB,2.8438E+01_JPRB,2.4375E+01_JPRB,2.9810E+01_JPRB,3.9747E+01_JPRB,4.9683E+01_JPRB,&
&5.9618E+01_JPRB,6.9550E+01_JPRB,7.9236E+01_JPRB/)
KAO( :, 3, 6,16) = (/&
&3.1024E+01_JPRB,2.7146E+01_JPRB,2.3268E+01_JPRB,3.1309E+01_JPRB,4.1745E+01_JPRB,5.2181E+01_JPRB,&
&6.2616E+01_JPRB,7.3047E+01_JPRB,8.3222E+01_JPRB/)
KAO( :, 4, 6,16) = (/&
&2.9629E+01_JPRB,2.5925E+01_JPRB,2.2365E+01_JPRB,3.2588E+01_JPRB,4.3451E+01_JPRB,5.4313E+01_JPRB,&
&6.5174E+01_JPRB,7.6032E+01_JPRB,8.6614E+01_JPRB/)
KAO( :, 5, 6,16) = (/&
&2.8309E+01_JPRB,2.4770E+01_JPRB,2.2515E+01_JPRB,3.3663E+01_JPRB,4.4883E+01_JPRB,5.6104E+01_JPRB,&
&6.7323E+01_JPRB,7.8538E+01_JPRB,8.9494E+01_JPRB/)
KAO( :, 1, 7,16) = (/&
&3.6910E+01_JPRB,3.2297E+01_JPRB,2.7683E+01_JPRB,3.2196E+01_JPRB,4.2928E+01_JPRB,5.3659E+01_JPRB,&
&6.4389E+01_JPRB,7.5116E+01_JPRB,8.5705E+01_JPRB/)
KAO( :, 2, 7,16) = (/&
&3.5197E+01_JPRB,3.0797E+01_JPRB,2.6398E+01_JPRB,3.4425E+01_JPRB,4.5900E+01_JPRB,5.7374E+01_JPRB,&
&6.8848E+01_JPRB,8.0317E+01_JPRB,9.1670E+01_JPRB/)
KAO( :, 3, 7,16) = (/&
&3.3605E+01_JPRB,2.9404E+01_JPRB,2.5310E+01_JPRB,3.6355E+01_JPRB,4.8473E+01_JPRB,6.0591E+01_JPRB,&
&7.2708E+01_JPRB,8.4820E+01_JPRB,9.6786E+01_JPRB/)
KAO( :, 4, 7,16) = (/&
&3.2106E+01_JPRB,2.8093E+01_JPRB,2.5533E+01_JPRB,3.7999E+01_JPRB,5.0665E+01_JPRB,6.3330E+01_JPRB,&
&7.5995E+01_JPRB,8.8655E+01_JPRB,1.0117E+02_JPRB/)
KAO( :, 5, 7,16) = (/&
&3.0744E+01_JPRB,2.6901E+01_JPRB,2.6250E+01_JPRB,3.9375E+01_JPRB,5.2499E+01_JPRB,6.5623E+01_JPRB,&
&7.8746E+01_JPRB,9.1865E+01_JPRB,1.0485E+02_JPRB/)
KAO( :, 1, 8,16) = (/&
&4.0073E+01_JPRB,3.5064E+01_JPRB,3.0055E+01_JPRB,3.6634E+01_JPRB,4.8845E+01_JPRB,6.1056E+01_JPRB,&
&7.3265E+01_JPRB,8.5470E+01_JPRB,9.7620E+01_JPRB/)
KAO( :, 2, 8,16) = (/&
&3.8256E+01_JPRB,3.3474E+01_JPRB,2.8692E+01_JPRB,3.9468E+01_JPRB,5.2623E+01_JPRB,6.5778E+01_JPRB,&
&7.8932E+01_JPRB,9.2081E+01_JPRB,1.0517E+02_JPRB/)
KAO( :, 3, 8,16) = (/&
&3.6587E+01_JPRB,3.2013E+01_JPRB,2.8588E+01_JPRB,4.1890E+01_JPRB,5.5854E+01_JPRB,6.9816E+01_JPRB,&
&8.3778E+01_JPRB,9.7751E+01_JPRB,1.1165E+02_JPRB/)
KAO( :, 4, 8,16) = (/&
&3.5145E+01_JPRB,3.0752E+01_JPRB,2.9433E+01_JPRB,4.3973E+01_JPRB,5.8630E+01_JPRB,7.3286E+01_JPRB,&
&8.7942E+01_JPRB,1.0259E+02_JPRB,1.1716E+02_JPRB/)
KAO( :, 5, 8,16) = (/&
&3.4615E+01_JPRB,3.0288E+01_JPRB,3.0495E+01_JPRB,4.5712E+01_JPRB,6.0949E+01_JPRB,7.6185E+01_JPRB,&
&9.1420E+01_JPRB,1.0665E+02_JPRB,1.2183E+02_JPRB/)
KAO( :, 1, 9,16) = (/&
&4.3755E+01_JPRB,3.8286E+01_JPRB,3.2816E+01_JPRB,4.1247E+01_JPRB,5.4995E+01_JPRB,6.8743E+01_JPRB,&
&8.2490E+01_JPRB,9.6233E+01_JPRB,1.0997E+02_JPRB/)
KAO( :, 2, 9,16) = (/&
&4.1945E+01_JPRB,3.6702E+01_JPRB,3.1862E+01_JPRB,4.4780E+01_JPRB,5.9706E+01_JPRB,7.4631E+01_JPRB,&
&8.9556E+01_JPRB,1.0447E+02_JPRB,1.1940E+02_JPRB/)
KAO( :, 3, 9,16) = (/&
&4.0428E+01_JPRB,3.5374E+01_JPRB,3.2607E+01_JPRB,4.7818E+01_JPRB,6.3757E+01_JPRB,7.9695E+01_JPRB,&
&9.5632E+01_JPRB,1.1156E+02_JPRB,1.2752E+02_JPRB/)
KAO( :, 4, 9,16) = (/&
&3.9770E+01_JPRB,3.4798E+01_JPRB,3.3900E+01_JPRB,5.0397E+01_JPRB,6.7196E+01_JPRB,8.3994E+01_JPRB,&
&1.0079E+02_JPRB,1.1758E+02_JPRB,1.3434E+02_JPRB/)
KAO( :, 5, 9,16) = (/&
&4.1051E+01_JPRB,3.5919E+01_JPRB,3.5387E+01_JPRB,5.2540E+01_JPRB,7.0054E+01_JPRB,8.7567E+01_JPRB,&
&1.0508E+02_JPRB,1.2258E+02_JPRB,1.4009E+02_JPRB/)
KAO( :, 1,10,16) = (/&
&4.8191E+01_JPRB,4.2167E+01_JPRB,3.6143E+01_JPRB,4.6233E+01_JPRB,6.1643E+01_JPRB,7.7053E+01_JPRB,&
&9.2462E+01_JPRB,1.0788E+02_JPRB,1.2329E+02_JPRB/)
KAO( :, 2,10,16) = (/&
&4.6632E+01_JPRB,4.0803E+01_JPRB,3.6096E+01_JPRB,5.0540E+01_JPRB,6.7392E+01_JPRB,8.4239E+01_JPRB,&
&1.0109E+02_JPRB,1.1792E+02_JPRB,1.3475E+02_JPRB/)
KAO( :, 3,10,16) = (/&
&4.5798E+01_JPRB,4.0073E+01_JPRB,3.7372E+01_JPRB,5.4219E+01_JPRB,7.2291E+01_JPRB,9.0363E+01_JPRB,&
&1.0843E+02_JPRB,1.2650E+02_JPRB,1.4462E+02_JPRB/)
KAO( :, 4,10,16) = (/&
&4.7009E+01_JPRB,4.1133E+01_JPRB,3.9401E+01_JPRB,5.7318E+01_JPRB,7.6424E+01_JPRB,9.5528E+01_JPRB,&
&1.1463E+02_JPRB,1.3373E+02_JPRB,1.5287E+02_JPRB/)
KAO( :, 5,10,16) = (/&
&4.8862E+01_JPRB,4.2754E+01_JPRB,4.1265E+01_JPRB,5.9899E+01_JPRB,7.9865E+01_JPRB,9.9835E+01_JPRB,&
&1.1980E+02_JPRB,1.3976E+02_JPRB,1.5971E+02_JPRB/)
KAO( :, 1,11,16) = (/&
&5.3373E+01_JPRB,4.6702E+01_JPRB,4.0606E+01_JPRB,5.3674E+01_JPRB,7.1565E+01_JPRB,8.9455E+01_JPRB,&
&1.0734E+02_JPRB,1.2523E+02_JPRB,1.4312E+02_JPRB/)
KAO( :, 2,11,16) = (/&
&5.3017E+01_JPRB,4.6390E+01_JPRB,4.2053E+01_JPRB,5.8474E+01_JPRB,7.7965E+01_JPRB,9.7455E+01_JPRB,&
&1.1694E+02_JPRB,1.3643E+02_JPRB,1.5595E+02_JPRB/)
KAO( :, 3,11,16) = (/&
&5.4550E+01_JPRB,4.7731E+01_JPRB,4.4590E+01_JPRB,6.2526E+01_JPRB,8.3367E+01_JPRB,1.0421E+02_JPRB,&
&1.2505E+02_JPRB,1.4588E+02_JPRB,1.6674E+02_JPRB/)
KAO( :, 4,11,16) = (/&
&5.6780E+01_JPRB,4.9683E+01_JPRB,4.6971E+01_JPRB,6.5903E+01_JPRB,8.7870E+01_JPRB,1.0984E+02_JPRB,&
&1.3180E+02_JPRB,1.5376E+02_JPRB,1.7563E+02_JPRB/)
KAO( :, 5,11,16) = (/&
&5.9041E+01_JPRB,5.1661E+01_JPRB,4.9066E+01_JPRB,6.8642E+01_JPRB,9.1523E+01_JPRB,1.1440E+02_JPRB,&
&1.3728E+02_JPRB,1.6015E+02_JPRB,1.8306E+02_JPRB/)
KAO( :, 1,12,16) = (/&
&6.1525E+01_JPRB,5.3834E+01_JPRB,4.7398E+01_JPRB,6.1480E+01_JPRB,8.1973E+01_JPRB,1.0246E+02_JPRB,&
&1.2296E+02_JPRB,1.4346E+02_JPRB,1.6393E+02_JPRB/)
KAO( :, 2,12,16) = (/&
&6.3155E+01_JPRB,5.5261E+01_JPRB,5.0248E+01_JPRB,6.6709E+01_JPRB,8.8945E+01_JPRB,1.1118E+02_JPRB,&
&1.3341E+02_JPRB,1.5564E+02_JPRB,1.7789E+02_JPRB/)
KAO( :, 3,12,16) = (/&
&6.5829E+01_JPRB,5.7600E+01_JPRB,5.3241E+01_JPRB,7.1073E+01_JPRB,9.4764E+01_JPRB,1.1845E+02_JPRB,&
&1.4214E+02_JPRB,1.6583E+02_JPRB,1.8954E+02_JPRB/)
KAO( :, 4,12,16) = (/&
&6.8453E+01_JPRB,5.9896E+01_JPRB,5.5974E+01_JPRB,7.4756E+01_JPRB,9.9674E+01_JPRB,1.2459E+02_JPRB,&
&1.4950E+02_JPRB,1.7441E+02_JPRB,1.9932E+02_JPRB/)
KAO( :, 5,12,16) = (/&
&7.1079E+01_JPRB,6.2194E+01_JPRB,5.8308E+01_JPRB,7.7950E+01_JPRB,1.0393E+02_JPRB,1.2991E+02_JPRB,&
&1.5589E+02_JPRB,1.8186E+02_JPRB,2.0786E+02_JPRB/)
KAO( :, 1,13,16) = (/&
&7.3106E+01_JPRB,6.3968E+01_JPRB,5.6524E+01_JPRB,6.9787E+01_JPRB,9.2588E+01_JPRB,1.1573E+02_JPRB,&
&1.3888E+02_JPRB,1.6201E+02_JPRB,1.8517E+02_JPRB/)
KAO( :, 2,13,16) = (/&
&7.5846E+01_JPRB,6.6365E+01_JPRB,6.0094E+01_JPRB,7.5398E+01_JPRB,1.0038E+02_JPRB,1.2548E+02_JPRB,&
&1.5057E+02_JPRB,1.7566E+02_JPRB,2.0075E+02_JPRB/)
KAO( :, 3,13,16) = (/&
&7.9121E+01_JPRB,6.9231E+01_JPRB,6.3478E+01_JPRB,8.0291E+01_JPRB,1.0705E+02_JPRB,1.3382E+02_JPRB,&
&1.6058E+02_JPRB,1.8733E+02_JPRB,2.1409E+02_JPRB/)
KAO( :, 4,13,16) = (/&
&8.2254E+01_JPRB,7.1972E+01_JPRB,6.6518E+01_JPRB,8.4693E+01_JPRB,1.1292E+02_JPRB,1.4115E+02_JPRB,&
&1.6938E+02_JPRB,1.9759E+02_JPRB,2.2586E+02_JPRB/)
KAO( :, 5,13,16) = (/&
&8.5142E+01_JPRB,7.4499E+01_JPRB,6.9191E+01_JPRB,8.8493E+01_JPRB,1.1799E+02_JPRB,1.4748E+02_JPRB,&
&1.7697E+02_JPRB,2.0646E+02_JPRB,2.3600E+02_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB12_A2
