!OCL SCALAR
SUBROUTINE RRTM_KGB12_A1

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 12:  1800-2080 cm-1 (low - H2O,CO2; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     Reformatted for NEC by H.Galle   , LGGE  (splitting)

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO12, ONLY : KAO     ,SELFREFO   ,FRACREFAO
USE YOERRTA12, ONLY : STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 1) = (/&
&1.1071E-04_JPRB,1.7190E-03_JPRB,2.1297E-03_JPRB,2.2974E-03_JPRB,2.3638E-03_JPRB,2.3377E-03_JPRB,&
&2.2182E-03_JPRB,1.9598E-03_JPRB,6.0644E-04_JPRB/)
KAO( :, 2, 1, 1) = (/&
&1.1961E-04_JPRB,1.8523E-03_JPRB,2.3139E-03_JPRB,2.5087E-03_JPRB,2.5832E-03_JPRB,2.5507E-03_JPRB,&
&2.4226E-03_JPRB,2.1400E-03_JPRB,6.6787E-04_JPRB/)
KAO( :, 3, 1, 1) = (/&
&1.2897E-04_JPRB,1.9814E-03_JPRB,2.4904E-03_JPRB,2.7224E-03_JPRB,2.7992E-03_JPRB,2.7616E-03_JPRB,&
&2.6285E-03_JPRB,2.3297E-03_JPRB,7.4226E-04_JPRB/)
KAO( :, 4, 1, 1) = (/&
&1.3900E-04_JPRB,2.1069E-03_JPRB,2.6619E-03_JPRB,2.9256E-03_JPRB,3.0085E-03_JPRB,2.9760E-03_JPRB,&
&2.8383E-03_JPRB,2.5269E-03_JPRB,8.2019E-04_JPRB/)
KAO( :, 5, 1, 1) = (/&
&1.4980E-04_JPRB,2.2307E-03_JPRB,2.8258E-03_JPRB,3.1153E-03_JPRB,3.2140E-03_JPRB,3.1919E-03_JPRB,&
&3.0529E-03_JPRB,2.7312E-03_JPRB,9.0306E-04_JPRB/)
KAO( :, 1, 2, 1) = (/&
&9.5033E-05_JPRB,1.3952E-03_JPRB,1.7345E-03_JPRB,1.8757E-03_JPRB,1.9301E-03_JPRB,1.9088E-03_JPRB,&
&1.8109E-03_JPRB,1.6003E-03_JPRB,4.8147E-04_JPRB/)
KAO( :, 2, 2, 1) = (/&
&1.0264E-04_JPRB,1.5043E-03_JPRB,1.8862E-03_JPRB,2.0524E-03_JPRB,2.1155E-03_JPRB,2.0891E-03_JPRB,&
&1.9828E-03_JPRB,1.7518E-03_JPRB,5.3179E-04_JPRB/)
KAO( :, 3, 2, 1) = (/&
&1.1088E-04_JPRB,1.6110E-03_JPRB,2.0326E-03_JPRB,2.2296E-03_JPRB,2.2969E-03_JPRB,2.2672E-03_JPRB,&
&2.1565E-03_JPRB,1.9107E-03_JPRB,5.9063E-04_JPRB/)
KAO( :, 4, 2, 1) = (/&
&1.1978E-04_JPRB,1.7142E-03_JPRB,2.1747E-03_JPRB,2.4004E-03_JPRB,2.4722E-03_JPRB,2.4486E-03_JPRB,&
&2.3338E-03_JPRB,2.0762E-03_JPRB,6.5252E-04_JPRB/)
KAO( :, 5, 2, 1) = (/&
&1.2917E-04_JPRB,1.8168E-03_JPRB,2.3124E-03_JPRB,2.5589E-03_JPRB,2.6465E-03_JPRB,2.6314E-03_JPRB,&
&2.5162E-03_JPRB,2.2491E-03_JPRB,7.1928E-04_JPRB/)
KAO( :, 1, 3, 1) = (/&
&7.9672E-05_JPRB,1.1113E-03_JPRB,1.3811E-03_JPRB,1.4950E-03_JPRB,1.5396E-03_JPRB,1.5237E-03_JPRB,&
&1.4450E-03_JPRB,1.2772E-03_JPRB,3.7750E-04_JPRB/)
KAO( :, 2, 3, 1) = (/&
&8.5835E-05_JPRB,1.2012E-03_JPRB,1.5072E-03_JPRB,1.6412E-03_JPRB,1.6938E-03_JPRB,1.6765E-03_JPRB,&
&1.5878E-03_JPRB,1.4020E-03_JPRB,4.1693E-04_JPRB/)
KAO( :, 3, 3, 1) = (/&
&9.2724E-05_JPRB,1.2894E-03_JPRB,1.6284E-03_JPRB,1.7887E-03_JPRB,1.8470E-03_JPRB,1.8261E-03_JPRB,&
&1.7328E-03_JPRB,1.5335E-03_JPRB,4.6226E-04_JPRB/)
KAO( :, 4, 3, 1) = (/&
&1.0021E-04_JPRB,1.3753E-03_JPRB,1.7467E-03_JPRB,1.9334E-03_JPRB,1.9945E-03_JPRB,1.9763E-03_JPRB,&
&1.8807E-03_JPRB,1.6701E-03_JPRB,5.1131E-04_JPRB/)
KAO( :, 5, 3, 1) = (/&
&1.0826E-04_JPRB,1.4602E-03_JPRB,1.8628E-03_JPRB,2.0684E-03_JPRB,2.1410E-03_JPRB,2.1291E-03_JPRB,&
&2.0333E-03_JPRB,1.8146E-03_JPRB,5.6359E-04_JPRB/)
KAO( :, 1, 4, 1) = (/&
&6.6541E-05_JPRB,8.7720E-04_JPRB,1.0880E-03_JPRB,1.1789E-03_JPRB,1.2150E-03_JPRB,1.2040E-03_JPRB,&
&1.1429E-03_JPRB,1.0102E-03_JPRB,3.0065E-04_JPRB/)
KAO( :, 2, 4, 1) = (/&
&7.1240E-05_JPRB,9.5116E-04_JPRB,1.1928E-03_JPRB,1.2997E-03_JPRB,1.3427E-03_JPRB,1.3311E-03_JPRB,&
&1.2602E-03_JPRB,1.1118E-03_JPRB,3.3112E-04_JPRB/)
KAO( :, 3, 4, 1) = (/&
&7.6627E-05_JPRB,1.0246E-03_JPRB,1.2929E-03_JPRB,1.4214E-03_JPRB,1.4711E-03_JPRB,1.4559E-03_JPRB,&
&1.3800E-03_JPRB,1.2193E-03_JPRB,3.6623E-04_JPRB/)
KAO( :, 4, 4, 1) = (/&
&8.2697E-05_JPRB,1.0967E-03_JPRB,1.3910E-03_JPRB,1.5434E-03_JPRB,1.5957E-03_JPRB,1.5801E-03_JPRB,&
&1.5019E-03_JPRB,1.3318E-03_JPRB,4.0479E-04_JPRB/)
KAO( :, 5, 4, 1) = (/&
&8.9353E-05_JPRB,1.1675E-03_JPRB,1.4884E-03_JPRB,1.6584E-03_JPRB,1.7180E-03_JPRB,1.7064E-03_JPRB,&
&1.6273E-03_JPRB,1.4511E-03_JPRB,4.4590E-04_JPRB/)
KAO( :, 1, 5, 1) = (/&
&5.5998E-05_JPRB,6.8983E-04_JPRB,8.5274E-04_JPRB,9.2493E-04_JPRB,9.5405E-04_JPRB,9.4771E-04_JPRB,&
&9.0156E-04_JPRB,7.9782E-04_JPRB,2.4473E-04_JPRB/)
KAO( :, 2, 5, 1) = (/&
&5.9569E-05_JPRB,7.5053E-04_JPRB,9.3935E-04_JPRB,1.0247E-03_JPRB,1.0592E-03_JPRB,1.0509E-03_JPRB,&
&9.9609E-04_JPRB,8.7904E-04_JPRB,2.6874E-04_JPRB/)
KAO( :, 3, 5, 1) = (/&
&6.3728E-05_JPRB,8.1164E-04_JPRB,1.0227E-03_JPRB,1.1245E-03_JPRB,1.1656E-03_JPRB,1.1550E-03_JPRB,&
&1.0939E-03_JPRB,9.6668E-04_JPRB,2.9631E-04_JPRB/)
KAO( :, 4, 5, 1) = (/&
&6.8493E-05_JPRB,8.7191E-04_JPRB,1.1043E-03_JPRB,1.2254E-03_JPRB,1.2701E-03_JPRB,1.2575E-03_JPRB,&
&1.1938E-03_JPRB,1.0585E-03_JPRB,3.2693E-04_JPRB/)
KAO( :, 5, 5, 1) = (/&
&7.3804E-05_JPRB,9.3124E-04_JPRB,1.1858E-03_JPRB,1.3231E-03_JPRB,1.3713E-03_JPRB,1.3618E-03_JPRB,&
&1.2967E-03_JPRB,1.1556E-03_JPRB,3.5959E-04_JPRB/)
KAO( :, 1, 6, 1) = (/&
&4.7433E-05_JPRB,5.3952E-04_JPRB,6.6302E-04_JPRB,7.1941E-04_JPRB,7.4278E-04_JPRB,7.3993E-04_JPRB,&
&7.0682E-04_JPRB,6.2737E-04_JPRB,2.0502E-04_JPRB/)
KAO( :, 2, 6, 1) = (/&
&5.0194E-05_JPRB,5.8914E-04_JPRB,7.3430E-04_JPRB,8.0093E-04_JPRB,8.2839E-04_JPRB,8.2234E-04_JPRB,&
&7.8161E-04_JPRB,6.9096E-04_JPRB,2.2413E-04_JPRB/)
KAO( :, 3, 6, 1) = (/&
&5.3412E-05_JPRB,6.3967E-04_JPRB,8.0393E-04_JPRB,8.8246E-04_JPRB,9.1533E-04_JPRB,9.0872E-04_JPRB,&
&8.6111E-04_JPRB,7.6158E-04_JPRB,2.4611E-04_JPRB/)
KAO( :, 4, 6, 1) = (/&
&5.7167E-05_JPRB,6.9003E-04_JPRB,8.7186E-04_JPRB,9.6499E-04_JPRB,1.0025E-03_JPRB,9.9324E-04_JPRB,&
&9.4228E-04_JPRB,8.3524E-04_JPRB,2.7084E-04_JPRB/)
KAO( :, 5, 6, 1) = (/&
&6.1369E-05_JPRB,7.3991E-04_JPRB,9.3979E-04_JPRB,1.0473E-03_JPRB,1.0862E-03_JPRB,1.0788E-03_JPRB,&
&1.0266E-03_JPRB,9.1379E-04_JPRB,2.9720E-04_JPRB/)
KAO( :, 1, 7, 1) = (/&
&4.0204E-05_JPRB,4.2071E-04_JPRB,5.1329E-04_JPRB,5.5704E-04_JPRB,5.7598E-04_JPRB,5.7560E-04_JPRB,&
&5.5294E-04_JPRB,4.9311E-04_JPRB,1.8038E-04_JPRB/)
KAO( :, 2, 7, 1) = (/&
&4.2409E-05_JPRB,4.6139E-04_JPRB,5.7116E-04_JPRB,6.2323E-04_JPRB,6.4451E-04_JPRB,6.4096E-04_JPRB,&
&6.1142E-04_JPRB,5.4196E-04_JPRB,1.9582E-04_JPRB/)
KAO( :, 3, 7, 1) = (/&
&4.4969E-05_JPRB,5.0267E-04_JPRB,6.2911E-04_JPRB,6.8938E-04_JPRB,7.1511E-04_JPRB,7.1073E-04_JPRB,&
&6.7548E-04_JPRB,5.9790E-04_JPRB,2.1379E-04_JPRB/)
KAO( :, 4, 7, 1) = (/&
&4.7926E-05_JPRB,5.4471E-04_JPRB,6.8586E-04_JPRB,7.5653E-04_JPRB,7.8682E-04_JPRB,7.8099E-04_JPRB,&
&7.4115E-04_JPRB,6.5723E-04_JPRB,2.3382E-04_JPRB/)
KAO( :, 5, 7, 1) = (/&
&5.1304E-05_JPRB,5.8645E-04_JPRB,7.4180E-04_JPRB,8.2446E-04_JPRB,8.5674E-04_JPRB,8.5104E-04_JPRB,&
&8.0968E-04_JPRB,7.2033E-04_JPRB,2.5569E-04_JPRB/)
KAO( :, 1, 8, 1) = (/&
&3.4404E-05_JPRB,3.2742E-04_JPRB,3.9628E-04_JPRB,4.3044E-04_JPRB,4.4582E-04_JPRB,4.4750E-04_JPRB,&
&4.3255E-04_JPRB,3.8824E-04_JPRB,1.6140E-04_JPRB/)
KAO( :, 2, 8, 1) = (/&
&3.6102E-05_JPRB,3.6078E-04_JPRB,4.4317E-04_JPRB,4.8349E-04_JPRB,5.0006E-04_JPRB,4.9874E-04_JPRB,&
&4.7786E-04_JPRB,4.2529E-04_JPRB,1.7382E-04_JPRB/)
KAO( :, 3, 8, 1) = (/&
&3.8232E-05_JPRB,3.9477E-04_JPRB,4.9069E-04_JPRB,5.3712E-04_JPRB,5.5703E-04_JPRB,5.5425E-04_JPRB,&
&5.2840E-04_JPRB,4.6878E-04_JPRB,1.8872E-04_JPRB/)
KAO( :, 4, 8, 1) = (/&
&4.0723E-05_JPRB,4.2935E-04_JPRB,5.3782E-04_JPRB,5.9167E-04_JPRB,6.1513E-04_JPRB,6.1219E-04_JPRB,&
&5.8195E-04_JPRB,5.1637E-04_JPRB,2.0568E-04_JPRB/)
KAO( :, 5, 8, 1) = (/&
&4.3533E-05_JPRB,4.6405E-04_JPRB,5.8430E-04_JPRB,6.4724E-04_JPRB,6.7394E-04_JPRB,6.6968E-04_JPRB,&
&6.3735E-04_JPRB,5.6685E-04_JPRB,2.2475E-04_JPRB/)
KAO( :, 1, 9, 1) = (/&
&2.9435E-05_JPRB,2.5407E-04_JPRB,3.0513E-04_JPRB,3.3154E-04_JPRB,3.4450E-04_JPRB,3.4770E-04_JPRB,&
&3.3823E-04_JPRB,3.0612E-04_JPRB,1.4904E-04_JPRB/)
KAO( :, 2, 9, 1) = (/&
&3.0832E-05_JPRB,2.8156E-04_JPRB,3.4307E-04_JPRB,3.7395E-04_JPRB,3.8707E-04_JPRB,3.8740E-04_JPRB,&
&3.7308E-04_JPRB,3.3384E-04_JPRB,1.6021E-04_JPRB/)
KAO( :, 3, 9, 1) = (/&
&3.2541E-05_JPRB,3.0967E-04_JPRB,3.8142E-04_JPRB,4.1751E-04_JPRB,4.3262E-04_JPRB,4.3109E-04_JPRB,&
&4.1241E-04_JPRB,3.6699E-04_JPRB,1.7304E-04_JPRB/)
KAO( :, 4, 9, 1) = (/&
&3.4598E-05_JPRB,3.3815E-04_JPRB,4.2037E-04_JPRB,4.6162E-04_JPRB,4.7971E-04_JPRB,4.7802E-04_JPRB,&
&4.5577E-04_JPRB,4.0458E-04_JPRB,1.8804E-04_JPRB/)
KAO( :, 5, 9, 1) = (/&
&3.7007E-05_JPRB,3.6690E-04_JPRB,4.5921E-04_JPRB,5.0690E-04_JPRB,5.2823E-04_JPRB,5.2576E-04_JPRB,&
&5.0057E-04_JPRB,4.4491E-04_JPRB,2.0554E-04_JPRB/)
KAO( :, 1,10, 1) = (/&
&2.4927E-05_JPRB,1.9806E-04_JPRB,2.3689E-04_JPRB,2.5751E-04_JPRB,2.6867E-04_JPRB,2.7252E-04_JPRB,&
&2.6649E-04_JPRB,2.4340E-04_JPRB,1.3926E-04_JPRB/)
KAO( :, 2,10, 1) = (/&
&2.6291E-05_JPRB,2.2099E-04_JPRB,2.6740E-04_JPRB,2.9137E-04_JPRB,3.0194E-04_JPRB,3.0327E-04_JPRB,&
&2.9342E-04_JPRB,2.6414E-04_JPRB,1.4846E-04_JPRB/)
KAO( :, 3,10, 1) = (/&
&2.7951E-05_JPRB,2.4437E-04_JPRB,2.9848E-04_JPRB,3.2658E-04_JPRB,3.3827E-04_JPRB,3.3778E-04_JPRB,&
&3.2415E-04_JPRB,2.8946E-04_JPRB,1.5998E-04_JPRB/)
KAO( :, 4,10, 1) = (/&
&2.9907E-05_JPRB,2.6821E-04_JPRB,3.3026E-04_JPRB,3.6237E-04_JPRB,3.7643E-04_JPRB,3.7538E-04_JPRB,&
&3.5861E-04_JPRB,3.1891E-04_JPRB,1.7396E-04_JPRB/)
KAO( :, 5,10, 1) = (/&
&3.2074E-05_JPRB,2.9213E-04_JPRB,3.6237E-04_JPRB,3.9914E-04_JPRB,4.1580E-04_JPRB,4.1475E-04_JPRB,&
&3.9509E-04_JPRB,3.5105E-04_JPRB,1.9000E-04_JPRB/)
KAO( :, 1,11, 1) = (/&
&2.1030E-05_JPRB,1.6262E-04_JPRB,1.9497E-04_JPRB,2.1213E-04_JPRB,2.2124E-04_JPRB,2.2434E-04_JPRB,&
&2.1945E-04_JPRB,2.0056E-04_JPRB,1.1989E-04_JPRB/)
KAO( :, 2,11, 1) = (/&
&2.2215E-05_JPRB,1.8182E-04_JPRB,2.1979E-04_JPRB,2.3981E-04_JPRB,2.4860E-04_JPRB,2.4965E-04_JPRB,&
&2.4153E-04_JPRB,2.1771E-04_JPRB,1.2772E-04_JPRB/)
KAO( :, 3,11, 1) = (/&
&2.3854E-05_JPRB,2.0140E-04_JPRB,2.4523E-04_JPRB,2.6860E-04_JPRB,2.7834E-04_JPRB,2.7805E-04_JPRB,&
&2.6683E-04_JPRB,2.3853E-04_JPRB,1.3777E-04_JPRB/)
KAO( :, 4,11, 1) = (/&
&2.5937E-05_JPRB,2.2145E-04_JPRB,2.7132E-04_JPRB,2.9797E-04_JPRB,3.0980E-04_JPRB,3.0914E-04_JPRB,&
&2.9535E-04_JPRB,2.6276E-04_JPRB,1.4975E-04_JPRB/)
KAO( :, 5,11, 1) = (/&
&2.8200E-05_JPRB,2.4157E-04_JPRB,2.9784E-04_JPRB,3.2825E-04_JPRB,3.4224E-04_JPRB,3.4158E-04_JPRB,&
&3.2548E-04_JPRB,2.8921E-04_JPRB,1.6349E-04_JPRB/)
KAO( :, 1,12, 1) = (/&
&1.7436E-05_JPRB,1.3336E-04_JPRB,1.6029E-04_JPRB,1.7464E-04_JPRB,1.8206E-04_JPRB,1.8451E-04_JPRB,&
&1.8046E-04_JPRB,1.6506E-04_JPRB,9.9378E-05_JPRB/)
KAO( :, 2,12, 1) = (/&
&1.8421E-05_JPRB,1.4922E-04_JPRB,1.8056E-04_JPRB,1.9727E-04_JPRB,2.0452E-04_JPRB,2.0534E-04_JPRB,&
&1.9861E-04_JPRB,1.7923E-04_JPRB,1.0594E-04_JPRB/)
KAO( :, 3,12, 1) = (/&
&1.9770E-05_JPRB,1.6546E-04_JPRB,2.0137E-04_JPRB,2.2080E-04_JPRB,2.2895E-04_JPRB,2.2873E-04_JPRB,&
&2.1950E-04_JPRB,1.9634E-04_JPRB,1.1437E-04_JPRB/)
KAO( :, 4,12, 1) = (/&
&2.1532E-05_JPRB,1.8214E-04_JPRB,2.2278E-04_JPRB,2.4485E-04_JPRB,2.5477E-04_JPRB,2.5442E-04_JPRB,&
&2.4312E-04_JPRB,2.1633E-04_JPRB,1.2430E-04_JPRB/)
KAO( :, 5,12, 1) = (/&
&2.3665E-05_JPRB,1.9894E-04_JPRB,2.4466E-04_JPRB,2.6980E-04_JPRB,2.8155E-04_JPRB,2.8120E-04_JPRB,&
&2.6804E-04_JPRB,2.3807E-04_JPRB,1.3565E-04_JPRB/)
KAO( :, 1,13, 1) = (/&
&1.4387E-05_JPRB,1.0908E-04_JPRB,1.3157E-04_JPRB,1.4361E-04_JPRB,1.4965E-04_JPRB,1.5162E-04_JPRB,&
&1.4826E-04_JPRB,1.3570E-04_JPRB,8.1068E-05_JPRB/)
KAO( :, 2,13, 1) = (/&
&1.5222E-05_JPRB,1.2208E-04_JPRB,1.4808E-04_JPRB,1.6206E-04_JPRB,1.6806E-04_JPRB,1.6873E-04_JPRB,&
&1.6320E-04_JPRB,1.4737E-04_JPRB,8.6440E-05_JPRB/)
KAO( :, 3,13, 1) = (/&
&1.6337E-05_JPRB,1.3561E-04_JPRB,1.6504E-04_JPRB,1.8124E-04_JPRB,1.8815E-04_JPRB,1.8808E-04_JPRB,&
&1.8048E-04_JPRB,1.6146E-04_JPRB,9.3311E-05_JPRB/)
KAO( :, 4,13, 1) = (/&
&1.7783E-05_JPRB,1.4947E-04_JPRB,1.8257E-04_JPRB,2.0095E-04_JPRB,2.0933E-04_JPRB,2.0927E-04_JPRB,&
&2.0001E-04_JPRB,1.7792E-04_JPRB,1.0131E-04_JPRB/)
KAO( :, 5,13, 1) = (/&
&1.9570E-05_JPRB,1.6345E-04_JPRB,2.0062E-04_JPRB,2.2151E-04_JPRB,2.3144E-04_JPRB,2.3129E-04_JPRB,&
&2.2049E-04_JPRB,1.9577E-04_JPRB,1.1046E-04_JPRB/)
KAO( :, 1, 1, 2) = (/&
&9.2497E-04_JPRB,4.3144E-03_JPRB,5.6991E-03_JPRB,6.4942E-03_JPRB,6.8938E-03_JPRB,6.9128E-03_JPRB,&
&6.4921E-03_JPRB,5.6369E-03_JPRB,1.8483E-03_JPRB/)
KAO( :, 2, 1, 2) = (/&
&1.0409E-03_JPRB,4.6383E-03_JPRB,6.0633E-03_JPRB,6.9063E-03_JPRB,7.3169E-03_JPRB,7.3608E-03_JPRB,&
&6.9192E-03_JPRB,6.0028E-03_JPRB,2.0300E-03_JPRB/)
KAO( :, 3, 1, 2) = (/&
&1.1556E-03_JPRB,4.9764E-03_JPRB,6.4488E-03_JPRB,7.3288E-03_JPRB,7.7717E-03_JPRB,7.8279E-03_JPRB,&
&7.3748E-03_JPRB,6.3833E-03_JPRB,2.2072E-03_JPRB/)
KAO( :, 4, 1, 2) = (/&
&1.2675E-03_JPRB,5.3121E-03_JPRB,6.8537E-03_JPRB,7.7796E-03_JPRB,8.2492E-03_JPRB,8.3162E-03_JPRB,&
&7.8626E-03_JPRB,6.7865E-03_JPRB,2.3969E-03_JPRB/)
KAO( :, 5, 1, 2) = (/&
&1.3758E-03_JPRB,5.6410E-03_JPRB,7.2804E-03_JPRB,8.2553E-03_JPRB,8.7528E-03_JPRB,8.8226E-03_JPRB,&
&8.3750E-03_JPRB,7.2191E-03_JPRB,2.6089E-03_JPRB/)
KAO( :, 1, 2, 2) = (/&
&7.5186E-04_JPRB,3.6103E-03_JPRB,4.7635E-03_JPRB,5.4240E-03_JPRB,5.7535E-03_JPRB,5.7797E-03_JPRB,&
&5.4198E-03_JPRB,4.6836E-03_JPRB,1.4556E-03_JPRB/)
KAO( :, 2, 2, 2) = (/&
&8.4398E-04_JPRB,3.8877E-03_JPRB,5.0819E-03_JPRB,5.7839E-03_JPRB,6.1171E-03_JPRB,6.1580E-03_JPRB,&
&5.7873E-03_JPRB,4.9984E-03_JPRB,1.6006E-03_JPRB/)
KAO( :, 3, 2, 2) = (/&
&9.3483E-04_JPRB,4.1713E-03_JPRB,5.4170E-03_JPRB,6.1567E-03_JPRB,6.5115E-03_JPRB,6.5572E-03_JPRB,&
&6.1783E-03_JPRB,5.3232E-03_JPRB,1.7489E-03_JPRB/)
KAO( :, 4, 2, 2) = (/&
&1.0238E-03_JPRB,4.4548E-03_JPRB,5.7647E-03_JPRB,6.5444E-03_JPRB,6.9273E-03_JPRB,6.9708E-03_JPRB,&
&6.5984E-03_JPRB,5.6708E-03_JPRB,1.9109E-03_JPRB/)
KAO( :, 5, 2, 2) = (/&
&1.1107E-03_JPRB,4.7357E-03_JPRB,6.1219E-03_JPRB,6.9538E-03_JPRB,7.3658E-03_JPRB,7.4046E-03_JPRB,&
&7.0322E-03_JPRB,6.0412E-03_JPRB,2.0904E-03_JPRB/)
KAO( :, 1, 3, 2) = (/&
&6.0142E-04_JPRB,2.9523E-03_JPRB,3.9104E-03_JPRB,4.4517E-03_JPRB,4.7174E-03_JPRB,4.7372E-03_JPRB,&
&4.4492E-03_JPRB,3.8243E-03_JPRB,1.1263E-03_JPRB/)
KAO( :, 2, 3, 2) = (/&
&6.7406E-04_JPRB,3.1823E-03_JPRB,4.1811E-03_JPRB,4.7592E-03_JPRB,5.0290E-03_JPRB,5.0575E-03_JPRB,&
&4.7588E-03_JPRB,4.0940E-03_JPRB,1.2428E-03_JPRB/)
KAO( :, 3, 3, 2) = (/&
&7.4620E-04_JPRB,3.4210E-03_JPRB,4.4618E-03_JPRB,5.0793E-03_JPRB,5.3629E-03_JPRB,5.3950E-03_JPRB,&
&5.0905E-03_JPRB,4.3739E-03_JPRB,1.3657E-03_JPRB/)
KAO( :, 4, 3, 2) = (/&
&8.1752E-04_JPRB,3.6598E-03_JPRB,4.7515E-03_JPRB,5.4067E-03_JPRB,5.7176E-03_JPRB,5.7460E-03_JPRB,&
&5.4447E-03_JPRB,4.6676E-03_JPRB,1.5007E-03_JPRB/)
KAO( :, 5, 3, 2) = (/&
&8.8750E-04_JPRB,3.8967E-03_JPRB,5.0479E-03_JPRB,5.7482E-03_JPRB,6.0925E-03_JPRB,6.1154E-03_JPRB,&
&5.8092E-03_JPRB,4.9824E-03_JPRB,1.6471E-03_JPRB/)
KAO( :, 1, 4, 2) = (/&
&4.8101E-04_JPRB,2.3906E-03_JPRB,3.1853E-03_JPRB,3.6231E-03_JPRB,3.8360E-03_JPRB,3.8452E-03_JPRB,&
&3.6186E-03_JPRB,3.1019E-03_JPRB,8.7573E-04_JPRB/)
KAO( :, 2, 4, 2) = (/&
&5.3961E-04_JPRB,2.5785E-03_JPRB,3.4085E-03_JPRB,3.8820E-03_JPRB,4.0987E-03_JPRB,4.1183E-03_JPRB,&
&3.8800E-03_JPRB,3.3305E-03_JPRB,9.6932E-04_JPRB/)
KAO( :, 3, 4, 2) = (/&
&5.9799E-04_JPRB,2.7768E-03_JPRB,3.6406E-03_JPRB,4.1517E-03_JPRB,4.3797E-03_JPRB,4.4028E-03_JPRB,&
&4.1601E-03_JPRB,3.5700E-03_JPRB,1.0703E-03_JPRB/)
KAO( :, 4, 4, 2) = (/&
&6.5579E-04_JPRB,2.9752E-03_JPRB,3.8795E-03_JPRB,4.4220E-03_JPRB,4.6790E-03_JPRB,4.7001E-03_JPRB,&
&4.4581E-03_JPRB,3.8199E-03_JPRB,1.1808E-03_JPRB/)
KAO( :, 5, 4, 2) = (/&
&7.1241E-04_JPRB,3.1724E-03_JPRB,4.1257E-03_JPRB,4.7025E-03_JPRB,4.9913E-03_JPRB,5.0113E-03_JPRB,&
&4.7649E-03_JPRB,4.0844E-03_JPRB,1.3011E-03_JPRB/)
KAO( :, 1, 5, 2) = (/&
&3.7985E-04_JPRB,1.9296E-03_JPRB,2.5823E-03_JPRB,2.9367E-03_JPRB,3.1053E-03_JPRB,3.1068E-03_JPRB,&
&2.9256E-03_JPRB,2.5075E-03_JPRB,6.8590E-04_JPRB/)
KAO( :, 2, 5, 2) = (/&
&4.2774E-04_JPRB,2.0822E-03_JPRB,2.7665E-03_JPRB,3.1512E-03_JPRB,3.3261E-03_JPRB,3.3384E-03_JPRB,&
&3.1468E-03_JPRB,2.7004E-03_JPRB,7.6134E-04_JPRB/)
KAO( :, 3, 5, 2) = (/&
&4.7586E-04_JPRB,2.2442E-03_JPRB,2.9575E-03_JPRB,3.3747E-03_JPRB,3.5611E-03_JPRB,3.5804E-03_JPRB,&
&3.3851E-03_JPRB,2.9033E-03_JPRB,8.4414E-04_JPRB/)
KAO( :, 4, 5, 2) = (/&
&5.2378E-04_JPRB,2.4068E-03_JPRB,3.1534E-03_JPRB,3.5994E-03_JPRB,3.8099E-03_JPRB,3.8326E-03_JPRB,&
&3.6365E-03_JPRB,3.1178E-03_JPRB,9.3392E-04_JPRB/)
KAO( :, 5, 5, 2) = (/&
&5.7107E-04_JPRB,2.5676E-03_JPRB,3.3559E-03_JPRB,3.8294E-03_JPRB,4.0688E-03_JPRB,4.0931E-03_JPRB,&
&3.8958E-03_JPRB,3.3418E-03_JPRB,1.0329E-03_JPRB/)
KAO( :, 1, 6, 2) = (/&
&2.9735E-04_JPRB,1.5488E-03_JPRB,2.0781E-03_JPRB,2.3635E-03_JPRB,2.4968E-03_JPRB,2.4931E-03_JPRB,&
&2.3467E-03_JPRB,2.0085E-03_JPRB,5.4223E-04_JPRB/)
KAO( :, 2, 6, 2) = (/&
&3.3587E-04_JPRB,1.6709E-03_JPRB,2.2308E-03_JPRB,2.5409E-03_JPRB,2.6808E-03_JPRB,2.6895E-03_JPRB,&
&2.5340E-03_JPRB,2.1715E-03_JPRB,6.0215E-04_JPRB/)
KAO( :, 3, 6, 2) = (/&
&3.7473E-04_JPRB,1.8004E-03_JPRB,2.3875E-03_JPRB,2.7253E-03_JPRB,2.8757E-03_JPRB,2.8921E-03_JPRB,&
&2.7340E-03_JPRB,2.3415E-03_JPRB,6.6920E-04_JPRB/)
KAO( :, 4, 6, 2) = (/&
&4.1385E-04_JPRB,1.9336E-03_JPRB,2.5474E-03_JPRB,2.9106E-03_JPRB,3.0795E-03_JPRB,3.1041E-03_JPRB,&
&2.9464E-03_JPRB,2.5236E-03_JPRB,7.4227E-04_JPRB/)
KAO( :, 5, 6, 2) = (/&
&4.5282E-04_JPRB,2.0641E-03_JPRB,2.7125E-03_JPRB,3.0998E-03_JPRB,3.2937E-03_JPRB,3.3201E-03_JPRB,&
&3.1630E-03_JPRB,2.7121E-03_JPRB,8.2264E-04_JPRB/)
KAO( :, 1, 7, 2) = (/&
&2.3216E-04_JPRB,1.2362E-03_JPRB,1.6616E-03_JPRB,1.8908E-03_JPRB,1.9971E-03_JPRB,1.9905E-03_JPRB,&
&1.8720E-03_JPRB,1.5991E-03_JPRB,4.4178E-04_JPRB/)
KAO( :, 2, 7, 2) = (/&
&2.6289E-04_JPRB,1.3329E-03_JPRB,1.7891E-03_JPRB,2.0369E-03_JPRB,2.1504E-03_JPRB,2.1555E-03_JPRB,&
&2.0290E-03_JPRB,1.7365E-03_JPRB,4.9123E-04_JPRB/)
KAO( :, 3, 7, 2) = (/&
&2.9417E-04_JPRB,1.4359E-03_JPRB,1.9156E-03_JPRB,2.1896E-03_JPRB,2.3102E-03_JPRB,2.3250E-03_JPRB,&
&2.1958E-03_JPRB,1.8783E-03_JPRB,5.4688E-04_JPRB/)
KAO( :, 4, 7, 2) = (/&
&3.2585E-04_JPRB,1.5437E-03_JPRB,2.0463E-03_JPRB,2.3419E-03_JPRB,2.4777E-03_JPRB,2.4981E-03_JPRB,&
&2.3744E-03_JPRB,2.0299E-03_JPRB,6.0742E-04_JPRB/)
KAO( :, 5, 7, 2) = (/&
&3.5762E-04_JPRB,1.6504E-03_JPRB,2.1798E-03_JPRB,2.4967E-03_JPRB,2.6528E-03_JPRB,2.6762E-03_JPRB,&
&2.5533E-03_JPRB,2.1888E-03_JPRB,6.7380E-04_JPRB/)
KAO( :, 1, 8, 2) = (/&
&1.8254E-04_JPRB,9.8374E-04_JPRB,1.3243E-03_JPRB,1.5057E-03_JPRB,1.5902E-03_JPRB,1.5824E-03_JPRB,&
&1.4869E-03_JPRB,1.2665E-03_JPRB,3.9850E-04_JPRB/)
KAO( :, 2, 8, 2) = (/&
&2.0666E-04_JPRB,1.0603E-03_JPRB,1.4275E-03_JPRB,1.6259E-03_JPRB,1.7181E-03_JPRB,1.7201E-03_JPRB,&
&1.6174E-03_JPRB,1.3826E-03_JPRB,4.4169E-04_JPRB/)
KAO( :, 3, 8, 2) = (/&
&2.3157E-04_JPRB,1.1419E-03_JPRB,1.5319E-03_JPRB,1.7520E-03_JPRB,1.8487E-03_JPRB,1.8612E-03_JPRB,&
&1.7566E-03_JPRB,1.5015E-03_JPRB,4.8905E-04_JPRB/)
KAO( :, 4, 8, 2) = (/&
&2.5700E-04_JPRB,1.2278E-03_JPRB,1.6373E-03_JPRB,1.8765E-03_JPRB,1.9849E-03_JPRB,2.0014E-03_JPRB,&
&1.9031E-03_JPRB,1.6270E-03_JPRB,5.4213E-04_JPRB/)
KAO( :, 5, 8, 2) = (/&
&2.8283E-04_JPRB,1.3158E-03_JPRB,1.7450E-03_JPRB,2.0017E-03_JPRB,2.1255E-03_JPRB,2.1468E-03_JPRB,&
&2.0518E-03_JPRB,1.7597E-03_JPRB,6.0087E-04_JPRB/)
KAO( :, 1, 9, 2) = (/&
&1.4492E-04_JPRB,7.8220E-04_JPRB,1.0529E-03_JPRB,1.1948E-03_JPRB,1.2616E-03_JPRB,1.2532E-03_JPRB,&
&1.1763E-03_JPRB,9.9787E-04_JPRB,3.8271E-04_JPRB/)
KAO( :, 2, 9, 2) = (/&
&1.6385E-04_JPRB,8.4332E-04_JPRB,1.1362E-03_JPRB,1.2935E-03_JPRB,1.3677E-03_JPRB,1.3665E-03_JPRB,&
&1.2847E-03_JPRB,1.0960E-03_JPRB,4.2068E-04_JPRB/)
KAO( :, 3, 9, 2) = (/&
&1.8366E-04_JPRB,9.0787E-04_JPRB,1.2223E-03_JPRB,1.3959E-03_JPRB,1.4750E-03_JPRB,1.4839E-03_JPRB,&
&1.3993E-03_JPRB,1.1955E-03_JPRB,4.6660E-04_JPRB/)
KAO( :, 4, 9, 2) = (/&
&2.0401E-04_JPRB,9.7621E-04_JPRB,1.3079E-03_JPRB,1.4991E-03_JPRB,1.5844E-03_JPRB,1.5989E-03_JPRB,&
&1.5186E-03_JPRB,1.3000E-03_JPRB,5.2016E-04_JPRB/)
KAO( :, 5, 9, 2) = (/&
&2.2477E-04_JPRB,1.0479E-03_JPRB,1.3948E-03_JPRB,1.6006E-03_JPRB,1.6979E-03_JPRB,1.7159E-03_JPRB,&
&1.6415E-03_JPRB,1.4093E-03_JPRB,5.7816E-04_JPRB/)
KAO( :, 1,10, 2) = (/&
&1.1869E-04_JPRB,6.2671E-04_JPRB,8.4082E-04_JPRB,9.5190E-04_JPRB,1.0039E-03_JPRB,9.9693E-04_JPRB,&
&9.3504E-04_JPRB,7.8902E-04_JPRB,3.5140E-04_JPRB/)
KAO( :, 2,10, 2) = (/&
&1.3381E-04_JPRB,6.7599E-04_JPRB,9.0913E-04_JPRB,1.0332E-03_JPRB,1.0921E-03_JPRB,1.0891E-03_JPRB,&
&1.0243E-03_JPRB,8.7218E-04_JPRB,3.8763E-04_JPRB/)
KAO( :, 3,10, 2) = (/&
&1.4959E-04_JPRB,7.2765E-04_JPRB,9.7958E-04_JPRB,1.1159E-03_JPRB,1.1802E-03_JPRB,1.1859E-03_JPRB,&
&1.1183E-03_JPRB,9.5533E-04_JPRB,4.3010E-04_JPRB/)
KAO( :, 4,10, 2) = (/&
&1.6589E-04_JPRB,7.8204E-04_JPRB,1.0498E-03_JPRB,1.2013E-03_JPRB,1.2689E-03_JPRB,1.2810E-03_JPRB,&
&1.2156E-03_JPRB,1.0417E-03_JPRB,4.7716E-04_JPRB/)
KAO( :, 5,10, 2) = (/&
&1.8260E-04_JPRB,8.3938E-04_JPRB,1.1206E-03_JPRB,1.2847E-03_JPRB,1.3612E-03_JPRB,1.3753E-03_JPRB,&
&1.3161E-03_JPRB,1.1315E-03_JPRB,5.2947E-04_JPRB/)
KAO( :, 1,11, 2) = (/&
&1.0311E-04_JPRB,5.2056E-04_JPRB,6.9637E-04_JPRB,7.8750E-04_JPRB,8.3059E-04_JPRB,8.2575E-04_JPRB,&
&7.7490E-04_JPRB,6.5424E-04_JPRB,3.0281E-04_JPRB/)
KAO( :, 2,11, 2) = (/&
&1.1590E-04_JPRB,5.6136E-04_JPRB,7.5296E-04_JPRB,8.5480E-04_JPRB,9.0353E-04_JPRB,9.0216E-04_JPRB,&
&8.4999E-04_JPRB,7.2420E-04_JPRB,3.3507E-04_JPRB/)
KAO( :, 3,11, 2) = (/&
&1.2889E-04_JPRB,6.0382E-04_JPRB,8.1101E-04_JPRB,9.2302E-04_JPRB,9.7570E-04_JPRB,9.8182E-04_JPRB,&
&9.2806E-04_JPRB,7.9438E-04_JPRB,3.7284E-04_JPRB/)
KAO( :, 4,11, 2) = (/&
&1.4211E-04_JPRB,6.4818E-04_JPRB,8.6860E-04_JPRB,9.9311E-04_JPRB,1.0487E-03_JPRB,1.0592E-03_JPRB,&
&1.0081E-03_JPRB,8.6646E-04_JPRB,4.1455E-04_JPRB/)
KAO( :, 5,11, 2) = (/&
&1.5566E-04_JPRB,6.9514E-04_JPRB,9.2716E-04_JPRB,1.0621E-03_JPRB,1.1251E-03_JPRB,1.1363E-03_JPRB,&
&1.0898E-03_JPRB,9.4096E-04_JPRB,4.6093E-04_JPRB/)
KAO( :, 1,12, 2) = (/&
&8.6906E-05_JPRB,4.2943E-04_JPRB,5.7386E-04_JPRB,6.4907E-04_JPRB,6.8516E-04_JPRB,6.8236E-04_JPRB,&
&6.4150E-04_JPRB,5.4221E-04_JPRB,2.5343E-04_JPRB/)
KAO( :, 2,12, 2) = (/&
&9.7363E-05_JPRB,4.6320E-04_JPRB,6.2055E-04_JPRB,7.0430E-04_JPRB,7.4506E-04_JPRB,7.4512E-04_JPRB,&
&7.0369E-04_JPRB,6.0080E-04_JPRB,2.8076E-04_JPRB/)
KAO( :, 3,12, 2) = (/&
&1.0822E-04_JPRB,4.9810E-04_JPRB,6.6816E-04_JPRB,7.6045E-04_JPRB,8.0385E-04_JPRB,8.1033E-04_JPRB,&
&7.6791E-04_JPRB,6.5916E-04_JPRB,3.1267E-04_JPRB/)
KAO( :, 4,12, 2) = (/&
&1.1919E-04_JPRB,5.3431E-04_JPRB,7.1547E-04_JPRB,8.1798E-04_JPRB,8.6412E-04_JPRB,8.7316E-04_JPRB,&
&8.3318E-04_JPRB,7.1884E-04_JPRB,3.4804E-04_JPRB/)
KAO( :, 5,12, 2) = (/&
&1.3020E-04_JPRB,5.7282E-04_JPRB,7.6401E-04_JPRB,8.7493E-04_JPRB,9.2683E-04_JPRB,9.3624E-04_JPRB,&
&8.9962E-04_JPRB,7.8030E-04_JPRB,3.8737E-04_JPRB/)
KAO( :, 1,13, 2) = (/&
&7.2736E-05_JPRB,3.5287E-04_JPRB,4.7103E-04_JPRB,5.3285E-04_JPRB,5.6294E-04_JPRB,5.6189E-04_JPRB,&
&5.2952E-04_JPRB,4.4876E-04_JPRB,2.0844E-04_JPRB/)
KAO( :, 2,13, 2) = (/&
&8.1220E-05_JPRB,3.8092E-04_JPRB,5.0957E-04_JPRB,5.7824E-04_JPRB,6.1199E-04_JPRB,6.1315E-04_JPRB,&
&5.8053E-04_JPRB,4.9725E-04_JPRB,2.3115E-04_JPRB/)
KAO( :, 3,13, 2) = (/&
&9.0164E-05_JPRB,4.0966E-04_JPRB,5.4894E-04_JPRB,6.2460E-04_JPRB,6.6024E-04_JPRB,6.6621E-04_JPRB,&
&6.3308E-04_JPRB,5.4537E-04_JPRB,2.5750E-04_JPRB/)
KAO( :, 4,13, 2) = (/&
&9.9376E-05_JPRB,4.3939E-04_JPRB,5.8810E-04_JPRB,6.7200E-04_JPRB,7.1008E-04_JPRB,7.1773E-04_JPRB,&
&6.8617E-04_JPRB,5.9441E-04_JPRB,2.8680E-04_JPRB/)
KAO( :, 5,13, 2) = (/&
&1.0854E-04_JPRB,4.7117E-04_JPRB,6.2833E-04_JPRB,7.1918E-04_JPRB,7.6187E-04_JPRB,7.6982E-04_JPRB,&
&7.4086E-04_JPRB,6.4493E-04_JPRB,3.1932E-04_JPRB/)
KAO( :, 1, 1, 3) = (/&
&2.8268E-03_JPRB,8.0007E-03_JPRB,1.0129E-02_JPRB,1.1600E-02_JPRB,1.2484E-02_JPRB,1.2903E-02_JPRB,&
&1.2756E-02_JPRB,1.1762E-02_JPRB,4.6746E-03_JPRB/)
KAO( :, 2, 1, 3) = (/&
&3.1283E-03_JPRB,8.6463E-03_JPRB,1.0922E-02_JPRB,1.2433E-02_JPRB,1.3339E-02_JPRB,1.3730E-02_JPRB,&
&1.3558E-02_JPRB,1.2454E-02_JPRB,5.0133E-03_JPRB/)
KAO( :, 3, 1, 3) = (/&
&3.4558E-03_JPRB,9.3189E-03_JPRB,1.1784E-02_JPRB,1.3331E-02_JPRB,1.4258E-02_JPRB,1.4611E-02_JPRB,&
&1.4389E-02_JPRB,1.3149E-02_JPRB,5.3761E-03_JPRB/)
KAO( :, 4, 1, 3) = (/&
&3.8003E-03_JPRB,1.0040E-02_JPRB,1.2672E-02_JPRB,1.4281E-02_JPRB,1.5240E-02_JPRB,1.5546E-02_JPRB,&
&1.5245E-02_JPRB,1.3873E-02_JPRB,5.7489E-03_JPRB/)
KAO( :, 5, 1, 3) = (/&
&4.1364E-03_JPRB,1.0810E-02_JPRB,1.3574E-02_JPRB,1.5264E-02_JPRB,1.6259E-02_JPRB,1.6515E-02_JPRB,&
&1.6129E-02_JPRB,1.4624E-02_JPRB,6.1285E-03_JPRB/)
KAO( :, 1, 2, 3) = (/&
&2.3785E-03_JPRB,6.8111E-03_JPRB,8.5917E-03_JPRB,9.8069E-03_JPRB,1.0520E-02_JPRB,1.0823E-02_JPRB,&
&1.0667E-02_JPRB,9.8152E-03_JPRB,3.7184E-03_JPRB/)
KAO( :, 2, 2, 3) = (/&
&2.6403E-03_JPRB,7.3805E-03_JPRB,9.2734E-03_JPRB,1.0506E-02_JPRB,1.1253E-02_JPRB,1.1531E-02_JPRB,&
&1.1349E-02_JPRB,1.0403E-02_JPRB,4.0032E-03_JPRB/)
KAO( :, 3, 2, 3) = (/&
&2.9257E-03_JPRB,7.9766E-03_JPRB,1.0007E-02_JPRB,1.1267E-02_JPRB,1.2040E-02_JPRB,1.2292E-02_JPRB,&
&1.2064E-02_JPRB,1.1014E-02_JPRB,4.2975E-03_JPRB/)
KAO( :, 4, 2, 3) = (/&
&3.2219E-03_JPRB,8.6148E-03_JPRB,1.0770E-02_JPRB,1.2085E-02_JPRB,1.2878E-02_JPRB,1.3098E-02_JPRB,&
&1.2794E-02_JPRB,1.1649E-02_JPRB,4.6021E-03_JPRB/)
KAO( :, 5, 2, 3) = (/&
&3.5088E-03_JPRB,9.2842E-03_JPRB,1.1557E-02_JPRB,1.2935E-02_JPRB,1.3737E-02_JPRB,1.3940E-02_JPRB,&
&1.3572E-02_JPRB,1.2310E-02_JPRB,4.9140E-03_JPRB/)
KAO( :, 1, 3, 3) = (/&
&1.9386E-03_JPRB,5.6660E-03_JPRB,7.1297E-03_JPRB,8.1429E-03_JPRB,8.7357E-03_JPRB,8.9496E-03_JPRB,&
&8.7747E-03_JPRB,8.0582E-03_JPRB,2.9088E-03_JPRB/)
KAO( :, 2, 3, 3) = (/&
&2.1579E-03_JPRB,6.1637E-03_JPRB,7.7083E-03_JPRB,8.7254E-03_JPRB,9.3435E-03_JPRB,9.5443E-03_JPRB,&
&9.3488E-03_JPRB,8.5545E-03_JPRB,3.1389E-03_JPRB/)
KAO( :, 3, 3, 3) = (/&
&2.3960E-03_JPRB,6.6842E-03_JPRB,8.3410E-03_JPRB,9.3621E-03_JPRB,1.0004E-02_JPRB,1.0182E-02_JPRB,&
&9.9526E-03_JPRB,9.0715E-03_JPRB,3.3810E-03_JPRB/)
KAO( :, 4, 3, 3) = (/&
&2.6451E-03_JPRB,7.2345E-03_JPRB,9.0005E-03_JPRB,1.0055E-02_JPRB,1.0704E-02_JPRB,1.0864E-02_JPRB,&
&1.0573E-02_JPRB,9.6158E-03_JPRB,3.6280E-03_JPRB/)
KAO( :, 5, 3, 3) = (/&
&2.8859E-03_JPRB,7.8078E-03_JPRB,9.6814E-03_JPRB,1.0782E-02_JPRB,1.1421E-02_JPRB,1.1580E-02_JPRB,&
&1.1241E-02_JPRB,1.0187E-02_JPRB,3.8829E-03_JPRB/)
KAO( :, 1, 4, 3) = (/&
&1.5600E-03_JPRB,4.6546E-03_JPRB,5.8495E-03_JPRB,6.6996E-03_JPRB,7.2044E-03_JPRB,7.3765E-03_JPRB,&
&7.1865E-03_JPRB,6.5682E-03_JPRB,2.2826E-03_JPRB/)
KAO( :, 2, 4, 3) = (/&
&1.7367E-03_JPRB,5.0823E-03_JPRB,6.3406E-03_JPRB,7.1867E-03_JPRB,7.7058E-03_JPRB,7.8650E-03_JPRB,&
&7.6617E-03_JPRB,6.9802E-03_JPRB,2.4709E-03_JPRB/)
KAO( :, 3, 4, 3) = (/&
&1.9306E-03_JPRB,5.5299E-03_JPRB,6.8812E-03_JPRB,7.7221E-03_JPRB,8.2549E-03_JPRB,8.3977E-03_JPRB,&
&8.1626E-03_JPRB,7.4067E-03_JPRB,2.6716E-03_JPRB/)
KAO( :, 4, 4, 3) = (/&
&2.1349E-03_JPRB,5.9971E-03_JPRB,7.4507E-03_JPRB,8.3116E-03_JPRB,8.8413E-03_JPRB,8.9674E-03_JPRB,&
&8.6864E-03_JPRB,7.8658E-03_JPRB,2.8745E-03_JPRB/)
KAO( :, 5, 4, 3) = (/&
&2.3336E-03_JPRB,6.4807E-03_JPRB,8.0336E-03_JPRB,8.9354E-03_JPRB,9.4416E-03_JPRB,9.5691E-03_JPRB,&
&9.2483E-03_JPRB,8.3517E-03_JPRB,3.0875E-03_JPRB/)
KAO( :, 1, 5, 3) = (/&
&1.2643E-03_JPRB,3.7992E-03_JPRB,4.7706E-03_JPRB,5.4821E-03_JPRB,5.9156E-03_JPRB,6.0631E-03_JPRB,&
&5.8873E-03_JPRB,5.3374E-03_JPRB,1.7987E-03_JPRB/)
KAO( :, 2, 5, 3) = (/&
&1.4029E-03_JPRB,4.1601E-03_JPRB,5.1876E-03_JPRB,5.8930E-03_JPRB,6.3304E-03_JPRB,6.4641E-03_JPRB,&
&6.2801E-03_JPRB,5.6828E-03_JPRB,1.9541E-03_JPRB/)
KAO( :, 3, 5, 3) = (/&
&1.5562E-03_JPRB,4.5381E-03_JPRB,5.6449E-03_JPRB,6.3470E-03_JPRB,6.7903E-03_JPRB,6.9025E-03_JPRB,&
&6.6934E-03_JPRB,6.0371E-03_JPRB,2.1188E-03_JPRB/)
KAO( :, 4, 5, 3) = (/&
&1.7190E-03_JPRB,4.9285E-03_JPRB,6.1272E-03_JPRB,6.8449E-03_JPRB,7.2797E-03_JPRB,7.3760E-03_JPRB,&
&7.1291E-03_JPRB,6.4167E-03_JPRB,2.2886E-03_JPRB/)
KAO( :, 5, 5, 3) = (/&
&1.8807E-03_JPRB,5.3341E-03_JPRB,6.6172E-03_JPRB,7.3735E-03_JPRB,7.7846E-03_JPRB,7.8779E-03_JPRB,&
&7.5974E-03_JPRB,6.8236E-03_JPRB,2.4671E-03_JPRB/)
KAO( :, 1, 6, 3) = (/&
&1.0213E-03_JPRB,3.0721E-03_JPRB,3.8660E-03_JPRB,4.4559E-03_JPRB,4.8197E-03_JPRB,4.9478E-03_JPRB,&
&4.7982E-03_JPRB,4.3290E-03_JPRB,1.4118E-03_JPRB/)
KAO( :, 2, 6, 3) = (/&
&1.1324E-03_JPRB,3.3728E-03_JPRB,4.2119E-03_JPRB,4.7959E-03_JPRB,5.1628E-03_JPRB,5.2793E-03_JPRB,&
&5.1225E-03_JPRB,4.6162E-03_JPRB,1.5418E-03_JPRB/)
KAO( :, 3, 6, 3) = (/&
&1.2545E-03_JPRB,3.6892E-03_JPRB,4.5936E-03_JPRB,5.1743E-03_JPRB,5.5467E-03_JPRB,5.6393E-03_JPRB,&
&5.4667E-03_JPRB,4.9091E-03_JPRB,1.6767E-03_JPRB/)
KAO( :, 4, 6, 3) = (/&
&1.3844E-03_JPRB,4.0151E-03_JPRB,4.9945E-03_JPRB,5.5888E-03_JPRB,5.9562E-03_JPRB,6.0318E-03_JPRB,&
&5.8253E-03_JPRB,5.2198E-03_JPRB,1.8201E-03_JPRB/)
KAO( :, 5, 6, 3) = (/&
&1.5162E-03_JPRB,4.3530E-03_JPRB,5.4044E-03_JPRB,6.0308E-03_JPRB,6.3808E-03_JPRB,6.4545E-03_JPRB,&
&6.2163E-03_JPRB,5.5575E-03_JPRB,1.9706E-03_JPRB/)
KAO( :, 1, 7, 3) = (/&
&8.1383E-04_JPRB,2.4690E-03_JPRB,3.1190E-03_JPRB,3.6045E-03_JPRB,3.9078E-03_JPRB,4.0152E-03_JPRB,&
&3.8892E-03_JPRB,3.5066E-03_JPRB,1.1162E-03_JPRB/)
KAO( :, 2, 7, 3) = (/&
&9.0133E-04_JPRB,2.7200E-03_JPRB,3.4007E-03_JPRB,3.8875E-03_JPRB,4.1896E-03_JPRB,4.2887E-03_JPRB,&
&4.1574E-03_JPRB,3.7464E-03_JPRB,1.2253E-03_JPRB/)
KAO( :, 3, 7, 3) = (/&
&9.9758E-04_JPRB,2.9822E-03_JPRB,3.7154E-03_JPRB,4.1988E-03_JPRB,4.5072E-03_JPRB,4.5864E-03_JPRB,&
&4.4444E-03_JPRB,3.9910E-03_JPRB,1.3374E-03_JPRB/)
KAO( :, 4, 7, 3) = (/&
&1.1009E-03_JPRB,3.2536E-03_JPRB,4.0499E-03_JPRB,4.5399E-03_JPRB,4.8474E-03_JPRB,4.9140E-03_JPRB,&
&4.7441E-03_JPRB,4.2483E-03_JPRB,1.4572E-03_JPRB/)
KAO( :, 5, 7, 3) = (/&
&1.2079E-03_JPRB,3.5321E-03_JPRB,4.3905E-03_JPRB,4.9045E-03_JPRB,5.2002E-03_JPRB,5.2665E-03_JPRB,&
&5.0703E-03_JPRB,4.5267E-03_JPRB,1.5834E-03_JPRB/)
KAO( :, 1, 8, 3) = (/&
&6.4403E-04_JPRB,1.9711E-03_JPRB,2.5061E-03_JPRB,2.9046E-03_JPRB,3.1552E-03_JPRB,3.2467E-03_JPRB,&
&3.1397E-03_JPRB,2.8272E-03_JPRB,9.2879E-04_JPRB/)
KAO( :, 2, 8, 3) = (/&
&7.1238E-04_JPRB,2.1771E-03_JPRB,2.7335E-03_JPRB,3.1363E-03_JPRB,3.3882E-03_JPRB,3.4702E-03_JPRB,&
&3.3609E-03_JPRB,3.0275E-03_JPRB,1.0282E-03_JPRB/)
KAO( :, 3, 8, 3) = (/&
&7.8775E-04_JPRB,2.3928E-03_JPRB,2.9888E-03_JPRB,3.3912E-03_JPRB,3.6502E-03_JPRB,3.7161E-03_JPRB,&
&3.5992E-03_JPRB,3.2322E-03_JPRB,1.1312E-03_JPRB/)
KAO( :, 4, 8, 3) = (/&
&8.6902E-04_JPRB,2.6176E-03_JPRB,3.2653E-03_JPRB,3.6711E-03_JPRB,3.9303E-03_JPRB,3.9873E-03_JPRB,&
&3.8512E-03_JPRB,3.4474E-03_JPRB,1.2372E-03_JPRB/)
KAO( :, 5, 8, 3) = (/&
&9.5395E-04_JPRB,2.8439E-03_JPRB,3.5472E-03_JPRB,3.9717E-03_JPRB,4.2227E-03_JPRB,4.2804E-03_JPRB,&
&4.1230E-03_JPRB,3.6794E-03_JPRB,1.3472E-03_JPRB/)
KAO( :, 1, 9, 3) = (/&
&5.1007E-04_JPRB,1.5656E-03_JPRB,2.0060E-03_JPRB,2.3330E-03_JPRB,2.5370E-03_JPRB,2.6132E-03_JPRB,&
&2.5254E-03_JPRB,2.2694E-03_JPRB,9.3729E-04_JPRB/)
KAO( :, 2, 9, 3) = (/&
&5.6353E-04_JPRB,1.7326E-03_JPRB,2.1869E-03_JPRB,2.5189E-03_JPRB,2.7285E-03_JPRB,2.7995E-03_JPRB,&
&2.7056E-03_JPRB,2.4351E-03_JPRB,1.0493E-03_JPRB/)
KAO( :, 3, 9, 3) = (/&
&6.2213E-04_JPRB,1.9088E-03_JPRB,2.3915E-03_JPRB,2.7258E-03_JPRB,2.9423E-03_JPRB,2.9995E-03_JPRB,&
&2.9041E-03_JPRB,2.6067E-03_JPRB,1.1607E-03_JPRB/)
KAO( :, 4, 9, 3) = (/&
&6.8571E-04_JPRB,2.0922E-03_JPRB,2.6149E-03_JPRB,2.9528E-03_JPRB,3.1723E-03_JPRB,3.2231E-03_JPRB,&
&3.1163E-03_JPRB,2.7863E-03_JPRB,1.2669E-03_JPRB/)
KAO( :, 5, 9, 3) = (/&
&7.5285E-04_JPRB,2.2758E-03_JPRB,2.8459E-03_JPRB,3.1985E-03_JPRB,3.4132E-03_JPRB,3.4638E-03_JPRB,&
&3.3423E-03_JPRB,2.9799E-03_JPRB,1.3708E-03_JPRB/)
KAO( :, 1,10, 3) = (/&
&4.0986E-04_JPRB,1.2514E-03_JPRB,1.6149E-03_JPRB,1.8827E-03_JPRB,2.0477E-03_JPRB,2.1068E-03_JPRB,&
&2.0342E-03_JPRB,1.8264E-03_JPRB,9.4172E-04_JPRB/)
KAO( :, 2,10, 3) = (/&
&4.5195E-04_JPRB,1.3870E-03_JPRB,1.7594E-03_JPRB,2.0313E-03_JPRB,2.2041E-03_JPRB,2.2637E-03_JPRB,&
&2.1836E-03_JPRB,1.9630E-03_JPRB,1.0592E-03_JPRB/)
KAO( :, 3,10, 3) = (/&
&4.9807E-04_JPRB,1.5305E-03_JPRB,1.9232E-03_JPRB,2.1993E-03_JPRB,2.3783E-03_JPRB,2.4282E-03_JPRB,&
&2.3477E-03_JPRB,2.1050E-03_JPRB,1.1691E-03_JPRB/)
KAO( :, 4,10, 3) = (/&
&5.4808E-04_JPRB,1.6789E-03_JPRB,2.1022E-03_JPRB,2.3829E-03_JPRB,2.5654E-03_JPRB,2.6091E-03_JPRB,&
&2.5255E-03_JPRB,2.2562E-03_JPRB,1.2759E-03_JPRB/)
KAO( :, 5,10, 3) = (/&
&6.0117E-04_JPRB,1.8287E-03_JPRB,2.2888E-03_JPRB,2.5807E-03_JPRB,2.7622E-03_JPRB,2.8066E-03_JPRB,&
&2.7118E-03_JPRB,2.4197E-03_JPRB,1.3798E-03_JPRB/)
KAO( :, 1,11, 3) = (/&
&3.4587E-04_JPRB,1.0486E-03_JPRB,1.3498E-03_JPRB,1.5706E-03_JPRB,1.7067E-03_JPRB,1.7541E-03_JPRB,&
&1.6904E-03_JPRB,1.5189E-03_JPRB,8.4922E-04_JPRB/)
KAO( :, 2,11, 3) = (/&
&3.8030E-04_JPRB,1.1612E-03_JPRB,1.4720E-03_JPRB,1.6962E-03_JPRB,1.8396E-03_JPRB,1.8877E-03_JPRB,&
&1.8189E-03_JPRB,1.6321E-03_JPRB,9.4886E-04_JPRB/)
KAO( :, 3,11, 3) = (/&
&4.1775E-04_JPRB,1.2794E-03_JPRB,1.6083E-03_JPRB,1.8372E-03_JPRB,1.9863E-03_JPRB,2.0269E-03_JPRB,&
&1.9602E-03_JPRB,1.7534E-03_JPRB,1.0435E-03_JPRB/)
KAO( :, 4,11, 3) = (/&
&4.5831E-04_JPRB,1.4012E-03_JPRB,1.7558E-03_JPRB,1.9899E-03_JPRB,2.1423E-03_JPRB,2.1791E-03_JPRB,&
&2.1105E-03_JPRB,1.8847E-03_JPRB,1.1342E-03_JPRB/)
KAO( :, 5,11, 3) = (/&
&5.0160E-04_JPRB,1.5235E-03_JPRB,1.9068E-03_JPRB,2.1518E-03_JPRB,2.3031E-03_JPRB,2.3452E-03_JPRB,&
&2.2691E-03_JPRB,2.0271E-03_JPRB,1.2246E-03_JPRB/)
KAO( :, 1,12, 3) = (/&
&2.8728E-04_JPRB,8.7138E-04_JPRB,1.1212E-03_JPRB,1.3035E-03_JPRB,1.4166E-03_JPRB,1.4556E-03_JPRB,&
&1.4016E-03_JPRB,1.2592E-03_JPRB,7.2447E-04_JPRB/)
KAO( :, 2,12, 3) = (/&
&3.1564E-04_JPRB,9.6434E-04_JPRB,1.2235E-03_JPRB,1.4085E-03_JPRB,1.5279E-03_JPRB,1.5679E-03_JPRB,&
&1.5112E-03_JPRB,1.3542E-03_JPRB,8.0728E-04_JPRB/)
KAO( :, 3,12, 3) = (/&
&3.4588E-04_JPRB,1.0616E-03_JPRB,1.3357E-03_JPRB,1.5255E-03_JPRB,1.6505E-03_JPRB,1.6842E-03_JPRB,&
&1.6309E-03_JPRB,1.4584E-03_JPRB,8.8538E-04_JPRB/)
KAO( :, 4,12, 3) = (/&
&3.7862E-04_JPRB,1.1614E-03_JPRB,1.4559E-03_JPRB,1.6504E-03_JPRB,1.7780E-03_JPRB,1.8118E-03_JPRB,&
&1.7570E-03_JPRB,1.5710E-03_JPRB,9.6174E-04_JPRB/)
KAO( :, 5,12, 3) = (/&
&4.1375E-04_JPRB,1.2608E-03_JPRB,1.5783E-03_JPRB,1.7829E-03_JPRB,1.9097E-03_JPRB,1.9490E-03_JPRB,&
&1.8902E-03_JPRB,1.6924E-03_JPRB,1.0383E-03_JPRB/)
KAO( :, 1,13, 3) = (/&
&2.3648E-04_JPRB,7.2058E-04_JPRB,9.2721E-04_JPRB,1.0773E-03_JPRB,1.1715E-03_JPRB,1.2041E-03_JPRB,&
&1.1590E-03_JPRB,1.0409E-03_JPRB,5.9750E-04_JPRB/)
KAO( :, 2,13, 3) = (/&
&2.5991E-04_JPRB,7.9700E-04_JPRB,1.0119E-03_JPRB,1.1647E-03_JPRB,1.2640E-03_JPRB,1.2977E-03_JPRB,&
&1.2520E-03_JPRB,1.1213E-03_JPRB,6.6442E-04_JPRB/)
KAO( :, 3,13, 3) = (/&
&2.8463E-04_JPRB,8.7643E-04_JPRB,1.1035E-03_JPRB,1.2606E-03_JPRB,1.3651E-03_JPRB,1.3947E-03_JPRB,&
&1.3520E-03_JPRB,1.2099E-03_JPRB,7.2829E-04_JPRB/)
KAO( :, 4,13, 3) = (/&
&3.1116E-04_JPRB,9.5840E-04_JPRB,1.2015E-03_JPRB,1.3629E-03_JPRB,1.4693E-03_JPRB,1.4997E-03_JPRB,&
&1.4571E-03_JPRB,1.3050E-03_JPRB,7.9195E-04_JPRB/)
KAO( :, 5,13, 3) = (/&
&3.3973E-04_JPRB,1.0393E-03_JPRB,1.3011E-03_JPRB,1.4709E-03_JPRB,1.5771E-03_JPRB,1.6125E-03_JPRB,&
&1.5669E-03_JPRB,1.4078E-03_JPRB,8.5580E-04_JPRB/)
KAO( :, 1, 1, 4) = (/&
&6.8556E-03_JPRB,1.5209E-02_JPRB,1.8964E-02_JPRB,2.1311E-02_JPRB,2.2775E-02_JPRB,2.3573E-02_JPRB,&
&2.3412E-02_JPRB,2.1611E-02_JPRB,1.0754E-02_JPRB/)
KAO( :, 2, 1, 4) = (/&
&7.5360E-03_JPRB,1.6539E-02_JPRB,2.0389E-02_JPRB,2.2809E-02_JPRB,2.4368E-02_JPRB,2.5124E-02_JPRB,&
&2.4893E-02_JPRB,2.2807E-02_JPRB,1.1409E-02_JPRB/)
KAO( :, 3, 1, 4) = (/&
&8.2731E-03_JPRB,1.7967E-02_JPRB,2.1859E-02_JPRB,2.4354E-02_JPRB,2.6001E-02_JPRB,2.6738E-02_JPRB,&
&2.6424E-02_JPRB,2.3981E-02_JPRB,1.2028E-02_JPRB/)
KAO( :, 4, 1, 4) = (/&
&9.0669E-03_JPRB,1.9440E-02_JPRB,2.3386E-02_JPRB,2.5951E-02_JPRB,2.7638E-02_JPRB,2.8404E-02_JPRB,&
&2.7993E-02_JPRB,2.5105E-02_JPRB,1.2622E-02_JPRB/)
KAO( :, 5, 1, 4) = (/&
&9.9297E-03_JPRB,2.0867E-02_JPRB,2.4992E-02_JPRB,2.7620E-02_JPRB,2.9333E-02_JPRB,3.0144E-02_JPRB,&
&2.9561E-02_JPRB,2.6196E-02_JPRB,1.3246E-02_JPRB/)
KAO( :, 1, 2, 4) = (/&
&6.0458E-03_JPRB,1.3057E-02_JPRB,1.6177E-02_JPRB,1.8072E-02_JPRB,1.9267E-02_JPRB,1.9866E-02_JPRB,&
&1.9708E-02_JPRB,1.7998E-02_JPRB,8.6186E-03_JPRB/)
KAO( :, 2, 2, 4) = (/&
&6.6625E-03_JPRB,1.4207E-02_JPRB,1.7424E-02_JPRB,1.9390E-02_JPRB,2.0646E-02_JPRB,2.1226E-02_JPRB,&
&2.0989E-02_JPRB,1.9040E-02_JPRB,9.1596E-03_JPRB/)
KAO( :, 3, 2, 4) = (/&
&7.3258E-03_JPRB,1.5446E-02_JPRB,1.8730E-02_JPRB,2.0756E-02_JPRB,2.2068E-02_JPRB,2.2641E-02_JPRB,&
&2.2320E-02_JPRB,2.0040E-02_JPRB,9.6719E-03_JPRB/)
KAO( :, 4, 2, 4) = (/&
&8.0389E-03_JPRB,1.6697E-02_JPRB,2.0086E-02_JPRB,2.2176E-02_JPRB,2.3509E-02_JPRB,2.4128E-02_JPRB,&
&2.3691E-02_JPRB,2.0995E-02_JPRB,1.0163E-02_JPRB/)
KAO( :, 5, 2, 4) = (/&
&8.8116E-03_JPRB,1.7924E-02_JPRB,2.1495E-02_JPRB,2.3659E-02_JPRB,2.5007E-02_JPRB,2.5649E-02_JPRB,&
&2.5070E-02_JPRB,2.1939E-02_JPRB,1.0681E-02_JPRB/)
KAO( :, 1, 3, 4) = (/&
&5.1529E-03_JPRB,1.1010E-02_JPRB,1.3576E-02_JPRB,1.5057E-02_JPRB,1.5941E-02_JPRB,1.6391E-02_JPRB,&
&1.6252E-02_JPRB,1.4825E-02_JPRB,6.7965E-03_JPRB/)
KAO( :, 2, 3, 4) = (/&
&5.7021E-03_JPRB,1.1982E-02_JPRB,1.4643E-02_JPRB,1.6192E-02_JPRB,1.7140E-02_JPRB,1.7565E-02_JPRB,&
&1.7355E-02_JPRB,1.5736E-02_JPRB,7.2498E-03_JPRB/)
KAO( :, 3, 3, 4) = (/&
&6.2951E-03_JPRB,1.3030E-02_JPRB,1.5759E-02_JPRB,1.7371E-02_JPRB,1.8379E-02_JPRB,1.8797E-02_JPRB,&
&1.8506E-02_JPRB,1.6604E-02_JPRB,7.6744E-03_JPRB/)
KAO( :, 4, 3, 4) = (/&
&6.9329E-03_JPRB,1.4099E-02_JPRB,1.6924E-02_JPRB,1.8614E-02_JPRB,1.9640E-02_JPRB,2.0080E-02_JPRB,&
&1.9697E-02_JPRB,1.7427E-02_JPRB,8.0855E-03_JPRB/)
KAO( :, 5, 3, 4) = (/&
&7.6208E-03_JPRB,1.5154E-02_JPRB,1.8132E-02_JPRB,1.9899E-02_JPRB,2.0953E-02_JPRB,2.1403E-02_JPRB,&
&2.0907E-02_JPRB,1.8236E-02_JPRB,8.5123E-03_JPRB/)
KAO( :, 1, 4, 4) = (/&
&4.3117E-03_JPRB,9.2399E-03_JPRB,1.1333E-02_JPRB,1.2460E-02_JPRB,1.3088E-02_JPRB,1.3384E-02_JPRB,&
&1.3264E-02_JPRB,1.2129E-02_JPRB,5.3638E-03_JPRB/)
KAO( :, 2, 4, 4) = (/&
&4.7919E-03_JPRB,1.0057E-02_JPRB,1.2236E-02_JPRB,1.3425E-02_JPRB,1.4108E-02_JPRB,1.4384E-02_JPRB,&
&1.4215E-02_JPRB,1.2919E-02_JPRB,5.7448E-03_JPRB/)
KAO( :, 3, 4, 4) = (/&
&5.3141E-03_JPRB,1.0939E-02_JPRB,1.3172E-02_JPRB,1.4430E-02_JPRB,1.5160E-02_JPRB,1.5438E-02_JPRB,&
&1.5198E-02_JPRB,1.3684E-02_JPRB,6.1060E-03_JPRB/)
KAO( :, 4, 4, 4) = (/&
&5.8726E-03_JPRB,1.1850E-02_JPRB,1.4160E-02_JPRB,1.5498E-02_JPRB,1.6255E-02_JPRB,1.6542E-02_JPRB,&
&1.6226E-02_JPRB,1.4411E-02_JPRB,6.4545E-03_JPRB/)
KAO( :, 5, 4, 4) = (/&
&6.4675E-03_JPRB,1.2764E-02_JPRB,1.5190E-02_JPRB,1.6608E-02_JPRB,1.7400E-02_JPRB,1.7692E-02_JPRB,&
&1.7269E-02_JPRB,1.5120E-02_JPRB,6.8073E-03_JPRB/)
KAO( :, 1, 5, 4) = (/&
&3.5690E-03_JPRB,7.7051E-03_JPRB,9.4368E-03_JPRB,1.0305E-02_JPRB,1.0745E-02_JPRB,1.0912E-02_JPRB,&
&1.0785E-02_JPRB,9.8773E-03_JPRB,4.2532E-03_JPRB/)
KAO( :, 2, 5, 4) = (/&
&3.9820E-03_JPRB,8.3977E-03_JPRB,1.0194E-02_JPRB,1.1112E-02_JPRB,1.1609E-02_JPRB,1.1756E-02_JPRB,&
&1.1595E-02_JPRB,1.0560E-02_JPRB,4.5731E-03_JPRB/)
KAO( :, 3, 5, 4) = (/&
&4.4305E-03_JPRB,9.1511E-03_JPRB,1.0990E-02_JPRB,1.1967E-02_JPRB,1.2498E-02_JPRB,1.2650E-02_JPRB,&
&1.2430E-02_JPRB,1.1229E-02_JPRB,4.8830E-03_JPRB/)
KAO( :, 4, 5, 4) = (/&
&4.9079E-03_JPRB,9.9363E-03_JPRB,1.1832E-02_JPRB,1.2872E-02_JPRB,1.3434E-02_JPRB,1.3592E-02_JPRB,&
&1.3307E-02_JPRB,1.1872E-02_JPRB,5.1810E-03_JPRB/)
KAO( :, 5, 5, 4) = (/&
&5.4148E-03_JPRB,1.0727E-02_JPRB,1.2716E-02_JPRB,1.3820E-02_JPRB,1.4419E-02_JPRB,1.4584E-02_JPRB,&
&1.4197E-02_JPRB,1.2492E-02_JPRB,5.4782E-03_JPRB/)
KAO( :, 1, 6, 4) = (/&
&2.9249E-03_JPRB,6.3510E-03_JPRB,7.7849E-03_JPRB,8.4721E-03_JPRB,8.7941E-03_JPRB,8.8837E-03_JPRB,&
&8.7388E-03_JPRB,7.9841E-03_JPRB,3.3710E-03_JPRB/)
KAO( :, 2, 6, 4) = (/&
&3.2672E-03_JPRB,6.9385E-03_JPRB,8.4203E-03_JPRB,9.1541E-03_JPRB,9.5165E-03_JPRB,9.5904E-03_JPRB,&
&9.4152E-03_JPRB,8.5713E-03_JPRB,3.6377E-03_JPRB/)
KAO( :, 3, 6, 4) = (/&
&3.6418E-03_JPRB,7.5787E-03_JPRB,9.0887E-03_JPRB,9.8765E-03_JPRB,1.0268E-02_JPRB,1.0342E-02_JPRB,&
&1.0116E-02_JPRB,9.1545E-03_JPRB,3.8990E-03_JPRB/)
KAO( :, 4, 6, 4) = (/&
&4.0414E-03_JPRB,8.2510E-03_JPRB,9.8093E-03_JPRB,1.0646E-02_JPRB,1.1060E-02_JPRB,1.1134E-02_JPRB,&
&1.0854E-02_JPRB,9.7190E-03_JPRB,4.1544E-03_JPRB/)
KAO( :, 5, 6, 4) = (/&
&4.4633E-03_JPRB,8.9345E-03_JPRB,1.0570E-02_JPRB,1.1457E-02_JPRB,1.1902E-02_JPRB,1.1976E-02_JPRB,&
&1.1614E-02_JPRB,1.0272E-02_JPRB,4.4061E-03_JPRB/)
KAO( :, 1, 7, 4) = (/&
&2.3975E-03_JPRB,5.1959E-03_JPRB,6.3675E-03_JPRB,6.9242E-03_JPRB,7.1717E-03_JPRB,7.2208E-03_JPRB,&
&7.0819E-03_JPRB,6.4278E-03_JPRB,2.6775E-03_JPRB/)
KAO( :, 2, 7, 4) = (/&
&2.6794E-03_JPRB,5.6899E-03_JPRB,6.9066E-03_JPRB,7.4942E-03_JPRB,7.7787E-03_JPRB,7.8098E-03_JPRB,&
&7.6464E-03_JPRB,6.9290E-03_JPRB,2.9001E-03_JPRB/)
KAO( :, 3, 7, 4) = (/&
&2.9849E-03_JPRB,6.2316E-03_JPRB,7.4741E-03_JPRB,8.1056E-03_JPRB,8.4139E-03_JPRB,8.4374E-03_JPRB,&
&8.2281E-03_JPRB,7.4302E-03_JPRB,3.1195E-03_JPRB/)
KAO( :, 4, 7, 4) = (/&
&3.3129E-03_JPRB,6.7984E-03_JPRB,8.0790E-03_JPRB,8.7600E-03_JPRB,9.0837E-03_JPRB,9.1052E-03_JPRB,&
&8.8458E-03_JPRB,7.9231E-03_JPRB,3.3376E-03_JPRB/)
KAO( :, 5, 7, 4) = (/&
&3.6598E-03_JPRB,7.3757E-03_JPRB,8.7298E-03_JPRB,9.4547E-03_JPRB,9.7958E-03_JPRB,9.8221E-03_JPRB,&
&9.4863E-03_JPRB,8.4060E-03_JPRB,3.5509E-03_JPRB/)
KAO( :, 1, 8, 4) = (/&
&1.9434E-03_JPRB,4.2318E-03_JPRB,5.1740E-03_JPRB,5.6370E-03_JPRB,5.8246E-03_JPRB,5.8488E-03_JPRB,&
&5.7327E-03_JPRB,5.1810E-03_JPRB,2.1537E-03_JPRB/)
KAO( :, 2, 8, 4) = (/&
&2.1750E-03_JPRB,4.6511E-03_JPRB,5.6344E-03_JPRB,6.1150E-03_JPRB,6.3286E-03_JPRB,6.3404E-03_JPRB,&
&6.2037E-03_JPRB,5.6029E-03_JPRB,2.3441E-03_JPRB/)
KAO( :, 3, 8, 4) = (/&
&2.4260E-03_JPRB,5.1070E-03_JPRB,6.1176E-03_JPRB,6.6292E-03_JPRB,6.8641E-03_JPRB,6.8681E-03_JPRB,&
&6.6887E-03_JPRB,6.0329E-03_JPRB,2.5317E-03_JPRB/)
KAO( :, 4, 8, 4) = (/&
&2.6978E-03_JPRB,5.5812E-03_JPRB,6.6317E-03_JPRB,7.1849E-03_JPRB,7.4298E-03_JPRB,7.4337E-03_JPRB,&
&7.2011E-03_JPRB,6.4503E-03_JPRB,2.7201E-03_JPRB/)
KAO( :, 5, 8, 4) = (/&
&2.9851E-03_JPRB,6.0671E-03_JPRB,7.1793E-03_JPRB,7.7747E-03_JPRB,8.0358E-03_JPRB,8.0369E-03_JPRB,&
&7.7421E-03_JPRB,6.8660E-03_JPRB,2.9050E-03_JPRB/)
KAO( :, 1, 9, 4) = (/&
&1.5624E-03_JPRB,3.4224E-03_JPRB,4.1803E-03_JPRB,4.5613E-03_JPRB,4.7117E-03_JPRB,4.7269E-03_JPRB,&
&4.6315E-03_JPRB,4.1802E-03_JPRB,2.0354E-03_JPRB/)
KAO( :, 2, 9, 4) = (/&
&1.7467E-03_JPRB,3.7749E-03_JPRB,4.5748E-03_JPRB,4.9706E-03_JPRB,5.1343E-03_JPRB,5.1344E-03_JPRB,&
&5.0243E-03_JPRB,4.5350E-03_JPRB,2.2250E-03_JPRB/)
KAO( :, 3, 9, 4) = (/&
&1.9492E-03_JPRB,4.1547E-03_JPRB,4.9867E-03_JPRB,5.4054E-03_JPRB,5.5868E-03_JPRB,5.5764E-03_JPRB,&
&5.4288E-03_JPRB,4.8977E-03_JPRB,2.4149E-03_JPRB/)
KAO( :, 4, 9, 4) = (/&
&2.1701E-03_JPRB,4.5508E-03_JPRB,5.4194E-03_JPRB,5.8744E-03_JPRB,6.0659E-03_JPRB,6.0518E-03_JPRB,&
&5.8540E-03_JPRB,5.2537E-03_JPRB,2.5971E-03_JPRB/)
KAO( :, 5, 9, 4) = (/&
&2.4022E-03_JPRB,4.9613E-03_JPRB,5.8787E-03_JPRB,6.3727E-03_JPRB,6.5778E-03_JPRB,6.5618E-03_JPRB,&
&6.3067E-03_JPRB,5.6053E-03_JPRB,2.7830E-03_JPRB/)
KAO( :, 1,10, 4) = (/&
&1.2651E-03_JPRB,2.7744E-03_JPRB,3.3801E-03_JPRB,3.6900E-03_JPRB,3.8178E-03_JPRB,3.8360E-03_JPRB,&
&3.7605E-03_JPRB,3.3907E-03_JPRB,2.1692E-03_JPRB/)
KAO( :, 2,10, 4) = (/&
&1.4111E-03_JPRB,3.0657E-03_JPRB,3.7136E-03_JPRB,4.0421E-03_JPRB,4.1735E-03_JPRB,4.1745E-03_JPRB,&
&4.0861E-03_JPRB,3.6872E-03_JPRB,2.3639E-03_JPRB/)
KAO( :, 3,10, 4) = (/&
&1.5740E-03_JPRB,3.3806E-03_JPRB,4.0618E-03_JPRB,4.4105E-03_JPRB,4.5571E-03_JPRB,4.5460E-03_JPRB,&
&4.4247E-03_JPRB,3.9923E-03_JPRB,2.5630E-03_JPRB/)
KAO( :, 4,10, 4) = (/&
&1.7522E-03_JPRB,3.7084E-03_JPRB,4.4249E-03_JPRB,4.8035E-03_JPRB,4.9639E-03_JPRB,4.9498E-03_JPRB,&
&4.7806E-03_JPRB,4.2956E-03_JPRB,2.7623E-03_JPRB/)
KAO( :, 5,10, 4) = (/&
&1.9383E-03_JPRB,4.0495E-03_JPRB,4.8094E-03_JPRB,5.2222E-03_JPRB,5.3934E-03_JPRB,5.3817E-03_JPRB,&
&5.1614E-03_JPRB,4.5951E-03_JPRB,2.9665E-03_JPRB/)
KAO( :, 1,11, 4) = (/&
&1.0742E-03_JPRB,2.3468E-03_JPRB,2.8469E-03_JPRB,3.1039E-03_JPRB,3.2098E-03_JPRB,3.2233E-03_JPRB,&
&3.1623E-03_JPRB,2.8537E-03_JPRB,1.9822E-03_JPRB/)
KAO( :, 2,11, 4) = (/&
&1.1960E-03_JPRB,2.5965E-03_JPRB,3.1323E-03_JPRB,3.4077E-03_JPRB,3.5194E-03_JPRB,3.5164E-03_JPRB,&
&3.4380E-03_JPRB,3.1056E-03_JPRB,2.1578E-03_JPRB/)
KAO( :, 3,11, 4) = (/&
&1.3316E-03_JPRB,2.8599E-03_JPRB,3.4277E-03_JPRB,3.7260E-03_JPRB,3.8497E-03_JPRB,3.8405E-03_JPRB,&
&3.7265E-03_JPRB,3.3630E-03_JPRB,2.3306E-03_JPRB/)
KAO( :, 4,11, 4) = (/&
&1.4781E-03_JPRB,3.1344E-03_JPRB,3.7357E-03_JPRB,4.0610E-03_JPRB,4.1987E-03_JPRB,4.1913E-03_JPRB,&
&4.0345E-03_JPRB,3.6192E-03_JPRB,2.5097E-03_JPRB/)
KAO( :, 5,11, 4) = (/&
&1.6288E-03_JPRB,3.4177E-03_JPRB,4.0619E-03_JPRB,4.4185E-03_JPRB,4.5672E-03_JPRB,4.5600E-03_JPRB,&
&4.3663E-03_JPRB,3.8756E-03_JPRB,2.6889E-03_JPRB/)
KAO( :, 1,12, 4) = (/&
&8.9874E-04_JPRB,1.9689E-03_JPRB,2.3835E-03_JPRB,2.5973E-03_JPRB,2.6864E-03_JPRB,2.6939E-03_JPRB,&
&2.6425E-03_JPRB,2.3895E-03_JPRB,1.7049E-03_JPRB/)
KAO( :, 2,12, 4) = (/&
&1.0002E-03_JPRB,2.1778E-03_JPRB,2.6233E-03_JPRB,2.8564E-03_JPRB,2.9517E-03_JPRB,2.9476E-03_JPRB,&
&2.8766E-03_JPRB,2.6019E-03_JPRB,1.8543E-03_JPRB/)
KAO( :, 3,12, 4) = (/&
&1.1122E-03_JPRB,2.3973E-03_JPRB,2.8713E-03_JPRB,3.1266E-03_JPRB,3.2310E-03_JPRB,3.2276E-03_JPRB,&
&3.1237E-03_JPRB,2.8177E-03_JPRB,2.0046E-03_JPRB/)
KAO( :, 4,12, 4) = (/&
&1.2310E-03_JPRB,2.6254E-03_JPRB,3.1305E-03_JPRB,3.4112E-03_JPRB,3.5275E-03_JPRB,3.5259E-03_JPRB,&
&3.3898E-03_JPRB,3.0349E-03_JPRB,2.1565E-03_JPRB/)
KAO( :, 5,12, 4) = (/&
&1.3518E-03_JPRB,2.8575E-03_JPRB,3.4006E-03_JPRB,3.7092E-03_JPRB,3.8403E-03_JPRB,3.8370E-03_JPRB,&
&3.6750E-03_JPRB,3.2557E-03_JPRB,2.3061E-03_JPRB/)
KAO( :, 1,13, 4) = (/&
&7.4537E-04_JPRB,1.6409E-03_JPRB,1.9863E-03_JPRB,2.1648E-03_JPRB,2.2399E-03_JPRB,2.2444E-03_JPRB,&
&2.1988E-03_JPRB,1.9916E-03_JPRB,1.4115E-03_JPRB/)
KAO( :, 2,13, 4) = (/&
&8.2943E-04_JPRB,1.8143E-03_JPRB,2.1850E-03_JPRB,2.3828E-03_JPRB,2.4639E-03_JPRB,2.4609E-03_JPRB,&
&2.3970E-03_JPRB,2.1692E-03_JPRB,1.5369E-03_JPRB/)
KAO( :, 3,13, 4) = (/&
&9.2142E-04_JPRB,1.9970E-03_JPRB,2.3927E-03_JPRB,2.6093E-03_JPRB,2.6971E-03_JPRB,2.6969E-03_JPRB,&
&2.6076E-03_JPRB,2.3521E-03_JPRB,1.6626E-03_JPRB/)
KAO( :, 4,13, 4) = (/&
&1.0167E-03_JPRB,2.1837E-03_JPRB,2.6078E-03_JPRB,2.8478E-03_JPRB,2.9467E-03_JPRB,2.9488E-03_JPRB,&
&2.8346E-03_JPRB,2.5383E-03_JPRB,1.7879E-03_JPRB/)
KAO( :, 5,13, 4) = (/&
&1.1138E-03_JPRB,2.3733E-03_JPRB,2.8290E-03_JPRB,3.0924E-03_JPRB,3.2079E-03_JPRB,3.2103E-03_JPRB,&
&3.0778E-03_JPRB,2.7284E-03_JPRB,1.9133E-03_JPRB/)
KAO( :, 1, 1, 5) = (/&
&1.7181E-02_JPRB,3.2302E-02_JPRB,3.8595E-02_JPRB,4.2778E-02_JPRB,4.5051E-02_JPRB,4.5779E-02_JPRB,&
&4.4076E-02_JPRB,3.6499E-02_JPRB,2.1167E-02_JPRB/)
KAO( :, 2, 1, 5) = (/&
&1.8715E-02_JPRB,3.4583E-02_JPRB,4.1400E-02_JPRB,4.5830E-02_JPRB,4.8256E-02_JPRB,4.8951E-02_JPRB,&
&4.6576E-02_JPRB,3.8480E-02_JPRB,2.2565E-02_JPRB/)
KAO( :, 3, 1, 5) = (/&
&2.0319E-02_JPRB,3.6940E-02_JPRB,4.4260E-02_JPRB,4.8908E-02_JPRB,5.1471E-02_JPRB,5.2022E-02_JPRB,&
&4.8965E-02_JPRB,4.0507E-02_JPRB,2.4057E-02_JPRB/)
KAO( :, 4, 1, 5) = (/&
&2.1938E-02_JPRB,3.9364E-02_JPRB,4.7234E-02_JPRB,5.2022E-02_JPRB,5.4697E-02_JPRB,5.4911E-02_JPRB,&
&5.1216E-02_JPRB,4.2565E-02_JPRB,2.5590E-02_JPRB/)
KAO( :, 5, 1, 5) = (/&
&2.3550E-02_JPRB,4.1966E-02_JPRB,5.0230E-02_JPRB,5.5149E-02_JPRB,5.7839E-02_JPRB,5.7598E-02_JPRB,&
&5.3448E-02_JPRB,4.4689E-02_JPRB,2.7100E-02_JPRB/)
KAO( :, 1, 2, 5) = (/&
&1.5052E-02_JPRB,2.7803E-02_JPRB,3.3102E-02_JPRB,3.6670E-02_JPRB,3.8668E-02_JPRB,3.9030E-02_JPRB,&
&3.7189E-02_JPRB,3.0668E-02_JPRB,1.6985E-02_JPRB/)
KAO( :, 2, 2, 5) = (/&
&1.6394E-02_JPRB,2.9857E-02_JPRB,3.5621E-02_JPRB,3.9412E-02_JPRB,4.1539E-02_JPRB,4.1835E-02_JPRB,&
&3.9351E-02_JPRB,3.2356E-02_JPRB,1.8150E-02_JPRB/)
KAO( :, 3, 2, 5) = (/&
&1.7773E-02_JPRB,3.1981E-02_JPRB,3.8209E-02_JPRB,4.2190E-02_JPRB,4.4385E-02_JPRB,4.4554E-02_JPRB,&
&4.1400E-02_JPRB,3.4106E-02_JPRB,1.9354E-02_JPRB/)
KAO( :, 4, 2, 5) = (/&
&1.9186E-02_JPRB,3.4227E-02_JPRB,4.0894E-02_JPRB,4.4998E-02_JPRB,4.7235E-02_JPRB,4.7050E-02_JPRB,&
&4.3366E-02_JPRB,3.5935E-02_JPRB,2.0592E-02_JPRB/)
KAO( :, 5, 2, 5) = (/&
&2.0602E-02_JPRB,3.6657E-02_JPRB,4.3639E-02_JPRB,4.7854E-02_JPRB,5.0031E-02_JPRB,4.9403E-02_JPRB,&
&4.5298E-02_JPRB,3.7775E-02_JPRB,2.1830E-02_JPRB/)
KAO( :, 1, 3, 5) = (/&
&1.3014E-02_JPRB,2.3440E-02_JPRB,2.7739E-02_JPRB,3.0683E-02_JPRB,3.2476E-02_JPRB,3.2815E-02_JPRB,&
&3.1052E-02_JPRB,2.5347E-02_JPRB,1.3409E-02_JPRB/)
KAO( :, 2, 3, 5) = (/&
&1.4134E-02_JPRB,2.5267E-02_JPRB,2.9956E-02_JPRB,3.3121E-02_JPRB,3.5013E-02_JPRB,3.5276E-02_JPRB,&
&3.2969E-02_JPRB,2.6772E-02_JPRB,1.4346E-02_JPRB/)
KAO( :, 3, 3, 5) = (/&
&1.5286E-02_JPRB,2.7161E-02_JPRB,3.2264E-02_JPRB,3.5614E-02_JPRB,3.7525E-02_JPRB,3.7651E-02_JPRB,&
&3.4766E-02_JPRB,2.8284E-02_JPRB,1.5307E-02_JPRB/)
KAO( :, 4, 3, 5) = (/&
&1.6478E-02_JPRB,2.9176E-02_JPRB,3.4663E-02_JPRB,3.8132E-02_JPRB,4.0060E-02_JPRB,3.9857E-02_JPRB,&
&3.6493E-02_JPRB,2.9862E-02_JPRB,1.6309E-02_JPRB/)
KAO( :, 5, 3, 5) = (/&
&1.7703E-02_JPRB,3.1371E-02_JPRB,3.7140E-02_JPRB,4.0703E-02_JPRB,4.2572E-02_JPRB,4.1936E-02_JPRB,&
&3.8184E-02_JPRB,3.1459E-02_JPRB,1.7321E-02_JPRB/)
KAO( :, 1, 4, 5) = (/&
&1.1231E-02_JPRB,1.9592E-02_JPRB,2.3001E-02_JPRB,2.5417E-02_JPRB,2.6918E-02_JPRB,2.7254E-02_JPRB,&
&2.5764E-02_JPRB,2.0867E-02_JPRB,1.0611E-02_JPRB/)
KAO( :, 2, 4, 5) = (/&
&1.2152E-02_JPRB,2.1190E-02_JPRB,2.4941E-02_JPRB,2.7556E-02_JPRB,2.9134E-02_JPRB,2.9416E-02_JPRB,&
&2.7448E-02_JPRB,2.2085E-02_JPRB,1.1371E-02_JPRB/)
KAO( :, 3, 4, 5) = (/&
&1.3112E-02_JPRB,2.2852E-02_JPRB,2.6983E-02_JPRB,2.9739E-02_JPRB,3.1347E-02_JPRB,3.1506E-02_JPRB,&
&2.9043E-02_JPRB,2.3373E-02_JPRB,1.2148E-02_JPRB/)
KAO( :, 4, 4, 5) = (/&
&1.4124E-02_JPRB,2.4635E-02_JPRB,2.9094E-02_JPRB,3.1959E-02_JPRB,3.3566E-02_JPRB,3.3485E-02_JPRB,&
&3.0596E-02_JPRB,2.4717E-02_JPRB,1.2964E-02_JPRB/)
KAO( :, 5, 4, 5) = (/&
&1.5184E-02_JPRB,2.6570E-02_JPRB,3.1299E-02_JPRB,3.4230E-02_JPRB,3.5790E-02_JPRB,3.5353E-02_JPRB,&
&3.2102E-02_JPRB,2.6103E-02_JPRB,1.3794E-02_JPRB/)
KAO( :, 1, 5, 5) = (/&
&9.6625E-03_JPRB,1.6401E-02_JPRB,1.9034E-02_JPRB,2.0952E-02_JPRB,2.2133E-02_JPRB,2.2396E-02_JPRB,&
&2.1200E-02_JPRB,1.7173E-02_JPRB,8.4178E-03_JPRB/)
KAO( :, 2, 5, 5) = (/&
&1.0438E-02_JPRB,1.7777E-02_JPRB,2.0706E-02_JPRB,2.2811E-02_JPRB,2.4067E-02_JPRB,2.4293E-02_JPRB,&
&2.2690E-02_JPRB,1.8230E-02_JPRB,9.0426E-03_JPRB/)
KAO( :, 3, 5, 5) = (/&
&1.1254E-02_JPRB,1.9209E-02_JPRB,2.2469E-02_JPRB,2.4701E-02_JPRB,2.6015E-02_JPRB,2.6148E-02_JPRB,&
&2.4123E-02_JPRB,1.9342E-02_JPRB,9.6801E-03_JPRB/)
KAO( :, 4, 5, 5) = (/&
&1.2133E-02_JPRB,2.0762E-02_JPRB,2.4308E-02_JPRB,2.6645E-02_JPRB,2.7949E-02_JPRB,2.7917E-02_JPRB,&
&2.5517E-02_JPRB,2.0494E-02_JPRB,1.0342E-02_JPRB/)
KAO( :, 5, 5, 5) = (/&
&1.3065E-02_JPRB,2.2455E-02_JPRB,2.6254E-02_JPRB,2.8630E-02_JPRB,2.9901E-02_JPRB,2.9590E-02_JPRB,&
&2.6871E-02_JPRB,2.1687E-02_JPRB,1.1028E-02_JPRB/)
KAO( :, 1, 6, 5) = (/&
&8.2007E-03_JPRB,1.3715E-02_JPRB,1.5729E-02_JPRB,1.7180E-02_JPRB,1.8048E-02_JPRB,1.8207E-02_JPRB,&
&1.7264E-02_JPRB,1.4054E-02_JPRB,6.6647E-03_JPRB/)
KAO( :, 2, 6, 5) = (/&
&8.8577E-03_JPRB,1.4875E-02_JPRB,1.7145E-02_JPRB,1.8767E-02_JPRB,1.9710E-02_JPRB,1.9852E-02_JPRB,&
&1.8586E-02_JPRB,1.4966E-02_JPRB,7.1861E-03_JPRB/)
KAO( :, 3, 6, 5) = (/&
&9.5621E-03_JPRB,1.6088E-02_JPRB,1.8646E-02_JPRB,2.0384E-02_JPRB,2.1390E-02_JPRB,2.1481E-02_JPRB,&
&1.9863E-02_JPRB,1.5925E-02_JPRB,7.7141E-03_JPRB/)
KAO( :, 4, 6, 5) = (/&
&1.0328E-02_JPRB,1.7422E-02_JPRB,2.0223E-02_JPRB,2.2061E-02_JPRB,2.3072E-02_JPRB,2.3059E-02_JPRB,&
&2.1135E-02_JPRB,1.6924E-02_JPRB,8.2553E-03_JPRB/)
KAO( :, 5, 6, 5) = (/&
&1.1150E-02_JPRB,1.8880E-02_JPRB,2.1894E-02_JPRB,2.3787E-02_JPRB,2.4780E-02_JPRB,2.4546E-02_JPRB,&
&2.2361E-02_JPRB,1.7956E-02_JPRB,8.8222E-03_JPRB/)
KAO( :, 1, 7, 5) = (/&
&6.8716E-03_JPRB,1.1438E-02_JPRB,1.2980E-02_JPRB,1.4066E-02_JPRB,1.4694E-02_JPRB,1.4738E-02_JPRB,&
&1.3970E-02_JPRB,1.1459E-02_JPRB,5.2799E-03_JPRB/)
KAO( :, 2, 7, 5) = (/&
&7.4237E-03_JPRB,1.2422E-02_JPRB,1.4174E-02_JPRB,1.5413E-02_JPRB,1.6105E-02_JPRB,1.6152E-02_JPRB,&
&1.5139E-02_JPRB,1.2254E-02_JPRB,5.7135E-03_JPRB/)
KAO( :, 3, 7, 5) = (/&
&8.0288E-03_JPRB,1.3449E-02_JPRB,1.5440E-02_JPRB,1.6795E-02_JPRB,1.7529E-02_JPRB,1.7565E-02_JPRB,&
&1.6277E-02_JPRB,1.3083E-02_JPRB,6.1506E-03_JPRB/)
KAO( :, 4, 7, 5) = (/&
&8.6956E-03_JPRB,1.4582E-02_JPRB,1.6791E-02_JPRB,1.8226E-02_JPRB,1.8968E-02_JPRB,1.8943E-02_JPRB,&
&1.7401E-02_JPRB,1.3948E-02_JPRB,6.5933E-03_JPRB/)
KAO( :, 5, 7, 5) = (/&
&9.4131E-03_JPRB,1.5832E-02_JPRB,1.8226E-02_JPRB,1.9705E-02_JPRB,2.0439E-02_JPRB,2.0248E-02_JPRB,&
&1.8508E-02_JPRB,1.4839E-02_JPRB,7.0585E-03_JPRB/)
KAO( :, 1, 8, 5) = (/&
&5.7435E-03_JPRB,9.4740E-03_JPRB,1.0676E-02_JPRB,1.1493E-02_JPRB,1.1955E-02_JPRB,1.1929E-02_JPRB,&
&1.1279E-02_JPRB,9.3230E-03_JPRB,4.2354E-03_JPRB/)
KAO( :, 2, 8, 5) = (/&
&6.2010E-03_JPRB,1.0304E-02_JPRB,1.1685E-02_JPRB,1.2627E-02_JPRB,1.3147E-02_JPRB,1.3135E-02_JPRB,&
&1.2304E-02_JPRB,1.0014E-02_JPRB,4.5941E-03_JPRB/)
KAO( :, 3, 8, 5) = (/&
&6.7137E-03_JPRB,1.1183E-02_JPRB,1.2753E-02_JPRB,1.3801E-02_JPRB,1.4354E-02_JPRB,1.4340E-02_JPRB,&
&1.3315E-02_JPRB,1.0741E-02_JPRB,4.9555E-03_JPRB/)
KAO( :, 4, 8, 5) = (/&
&7.2796E-03_JPRB,1.2147E-02_JPRB,1.3897E-02_JPRB,1.5019E-02_JPRB,1.5585E-02_JPRB,1.5528E-02_JPRB,&
&1.4315E-02_JPRB,1.1502E-02_JPRB,5.3165E-03_JPRB/)
KAO( :, 5, 8, 5) = (/&
&7.8871E-03_JPRB,1.3218E-02_JPRB,1.5130E-02_JPRB,1.6296E-02_JPRB,1.6839E-02_JPRB,1.6669E-02_JPRB,&
&1.5291E-02_JPRB,1.2282E-02_JPRB,5.6971E-03_JPRB/)
KAO( :, 1, 9, 5) = (/&
&4.7912E-03_JPRB,7.8358E-03_JPRB,8.7667E-03_JPRB,9.3820E-03_JPRB,9.7143E-03_JPRB,9.6500E-03_JPRB,&
&9.0841E-03_JPRB,7.5626E-03_JPRB,3.7702E-03_JPRB/)
KAO( :, 2, 9, 5) = (/&
&5.1805E-03_JPRB,8.5367E-03_JPRB,9.6133E-03_JPRB,1.0334E-02_JPRB,1.0715E-02_JPRB,1.0676E-02_JPRB,&
&9.9859E-03_JPRB,8.1627E-03_JPRB,4.1139E-03_JPRB/)
KAO( :, 3, 9, 5) = (/&
&5.6138E-03_JPRB,9.2835E-03_JPRB,1.0517E-02_JPRB,1.1325E-02_JPRB,1.1739E-02_JPRB,1.1698E-02_JPRB,&
&1.0873E-02_JPRB,8.7929E-03_JPRB,4.4462E-03_JPRB/)
KAO( :, 4, 9, 5) = (/&
&6.0888E-03_JPRB,1.0103E-02_JPRB,1.1488E-02_JPRB,1.2361E-02_JPRB,1.2785E-02_JPRB,1.2718E-02_JPRB,&
&1.1751E-02_JPRB,9.4626E-03_JPRB,4.7957E-03_JPRB/)
KAO( :, 5, 9, 5) = (/&
&6.6048E-03_JPRB,1.1011E-02_JPRB,1.2538E-02_JPRB,1.3462E-02_JPRB,1.3863E-02_JPRB,1.3713E-02_JPRB,&
&1.2615E-02_JPRB,1.0155E-02_JPRB,5.1561E-03_JPRB/)
KAO( :, 1,10, 5) = (/&
&3.9863E-03_JPRB,6.4924E-03_JPRB,7.2470E-03_JPRB,7.7132E-03_JPRB,7.9522E-03_JPRB,7.8682E-03_JPRB,&
&7.3679E-03_JPRB,6.1741E-03_JPRB,4.1464E-03_JPRB/)
KAO( :, 2,10, 5) = (/&
&4.3124E-03_JPRB,7.0973E-03_JPRB,7.9675E-03_JPRB,8.5161E-03_JPRB,8.8014E-03_JPRB,8.7362E-03_JPRB,&
&8.1504E-03_JPRB,6.7002E-03_JPRB,4.5619E-03_JPRB/)
KAO( :, 3,10, 5) = (/&
&4.6741E-03_JPRB,7.7383E-03_JPRB,8.7399E-03_JPRB,9.3597E-03_JPRB,9.6733E-03_JPRB,9.6088E-03_JPRB,&
&8.9286E-03_JPRB,7.2584E-03_JPRB,4.9900E-03_JPRB/)
KAO( :, 4,10, 5) = (/&
&5.0713E-03_JPRB,8.4456E-03_JPRB,9.5735E-03_JPRB,1.0251E-02_JPRB,1.0572E-02_JPRB,1.0481E-02_JPRB,&
&9.6979E-03_JPRB,7.8488E-03_JPRB,5.4214E-03_JPRB/)
KAO( :, 5,10, 5) = (/&
&5.5035E-03_JPRB,9.2235E-03_JPRB,1.0475E-02_JPRB,1.1200E-02_JPRB,1.1508E-02_JPRB,1.1347E-02_JPRB,&
&1.0465E-02_JPRB,8.4573E-03_JPRB,5.8532E-03_JPRB/)
KAO( :, 1,11, 5) = (/&
&3.4140E-03_JPRB,5.5663E-03_JPRB,6.2176E-03_JPRB,6.6132E-03_JPRB,6.8087E-03_JPRB,6.7328E-03_JPRB,&
&6.2855E-03_JPRB,5.2486E-03_JPRB,3.9285E-03_JPRB/)
KAO( :, 2,11, 5) = (/&
&3.6967E-03_JPRB,6.0927E-03_JPRB,6.8505E-03_JPRB,7.3111E-03_JPRB,7.5377E-03_JPRB,7.4746E-03_JPRB,&
&6.9609E-03_JPRB,5.7240E-03_JPRB,4.3138E-03_JPRB/)
KAO( :, 3,11, 5) = (/&
&4.0076E-03_JPRB,6.6620E-03_JPRB,7.5356E-03_JPRB,8.0510E-03_JPRB,8.2975E-03_JPRB,8.2276E-03_JPRB,&
&7.6355E-03_JPRB,6.2275E-03_JPRB,4.7141E-03_JPRB/)
KAO( :, 4,11, 5) = (/&
&4.3451E-03_JPRB,7.2880E-03_JPRB,8.2782E-03_JPRB,8.8424E-03_JPRB,9.0928E-03_JPRB,8.9832E-03_JPRB,&
&8.3078E-03_JPRB,6.7453E-03_JPRB,5.1152E-03_JPRB/)
KAO( :, 5,11, 5) = (/&
&4.7137E-03_JPRB,7.9681E-03_JPRB,9.0805E-03_JPRB,9.6843E-03_JPRB,9.9239E-03_JPRB,9.7470E-03_JPRB,&
&8.9796E-03_JPRB,7.2798E-03_JPRB,5.5223E-03_JPRB/)
KAO( :, 1,12, 5) = (/&
&2.8904E-03_JPRB,4.7236E-03_JPRB,5.2777E-03_JPRB,5.6093E-03_JPRB,5.7722E-03_JPRB,5.7159E-03_JPRB,&
&5.3358E-03_JPRB,4.4458E-03_JPRB,3.4411E-03_JPRB/)
KAO( :, 2,12, 5) = (/&
&3.1305E-03_JPRB,5.1808E-03_JPRB,5.8340E-03_JPRB,6.2167E-03_JPRB,6.4011E-03_JPRB,6.3506E-03_JPRB,&
&5.9136E-03_JPRB,4.8660E-03_JPRB,3.7674E-03_JPRB/)
KAO( :, 3,12, 5) = (/&
&3.3899E-03_JPRB,5.6784E-03_JPRB,6.4390E-03_JPRB,6.8698E-03_JPRB,7.0684E-03_JPRB,6.9989E-03_JPRB,&
&6.4975E-03_JPRB,5.3037E-03_JPRB,4.1043E-03_JPRB/)
KAO( :, 4,12, 5) = (/&
&3.6744E-03_JPRB,6.2189E-03_JPRB,7.0905E-03_JPRB,7.5674E-03_JPRB,7.7704E-03_JPRB,7.6566E-03_JPRB,&
&7.0778E-03_JPRB,5.7507E-03_JPRB,4.4508E-03_JPRB/)
KAO( :, 5,12, 5) = (/&
&3.9835E-03_JPRB,6.8035E-03_JPRB,7.7845E-03_JPRB,8.3062E-03_JPRB,8.4996E-03_JPRB,8.3274E-03_JPRB,&
&7.6592E-03_JPRB,6.2151E-03_JPRB,4.8132E-03_JPRB/)
KAO( :, 1,13, 5) = (/&
&2.4250E-03_JPRB,3.9803E-03_JPRB,4.4491E-03_JPRB,4.7254E-03_JPRB,4.8599E-03_JPRB,4.8181E-03_JPRB,&
&4.5058E-03_JPRB,3.7586E-03_JPRB,2.8856E-03_JPRB/)
KAO( :, 2,13, 5) = (/&
&2.6244E-03_JPRB,4.3727E-03_JPRB,4.9354E-03_JPRB,5.2533E-03_JPRB,5.4054E-03_JPRB,5.3645E-03_JPRB,&
&5.0027E-03_JPRB,4.1245E-03_JPRB,3.1558E-03_JPRB/)
KAO( :, 3,13, 5) = (/&
&2.8394E-03_JPRB,4.7986E-03_JPRB,5.4578E-03_JPRB,5.8227E-03_JPRB,5.9899E-03_JPRB,5.9263E-03_JPRB,&
&5.5030E-03_JPRB,4.4990E-03_JPRB,3.4378E-03_JPRB/)
KAO( :, 4,13, 5) = (/&
&3.0777E-03_JPRB,5.2577E-03_JPRB,6.0171E-03_JPRB,6.4265E-03_JPRB,6.6019E-03_JPRB,6.4996E-03_JPRB,&
&6.0065E-03_JPRB,4.8862E-03_JPRB,3.7311E-03_JPRB/)
KAO( :, 5,13, 5) = (/&
&3.3322E-03_JPRB,5.7564E-03_JPRB,6.6107E-03_JPRB,7.0607E-03_JPRB,7.2295E-03_JPRB,7.0815E-03_JPRB,&
&6.5094E-03_JPRB,5.2886E-03_JPRB,4.0375E-03_JPRB/)
KAO( :, 1, 1, 6) = (/&
&4.8059E-02_JPRB,7.5661E-02_JPRB,8.9697E-02_JPRB,9.6448E-02_JPRB,9.6739E-02_JPRB,9.1321E-02_JPRB,&
&8.0664E-02_JPRB,6.5698E-02_JPRB,4.2723E-02_JPRB/)
KAO( :, 2, 1, 6) = (/&
&5.1263E-02_JPRB,8.1256E-02_JPRB,9.5858E-02_JPRB,1.0217E-01_JPRB,1.0171E-01_JPRB,9.5631E-02_JPRB,&
&8.5046E-02_JPRB,6.9688E-02_JPRB,4.5844E-02_JPRB/)
KAO( :, 3, 1, 6) = (/&
&5.4622E-02_JPRB,8.6828E-02_JPRB,1.0177E-01_JPRB,1.0751E-01_JPRB,1.0632E-01_JPRB,9.9795E-02_JPRB,&
&8.9370E-02_JPRB,7.3806E-02_JPRB,4.9014E-02_JPRB/)
KAO( :, 4, 1, 6) = (/&
&5.8181E-02_JPRB,9.2294E-02_JPRB,1.0720E-01_JPRB,1.1246E-01_JPRB,1.1070E-01_JPRB,1.0392E-01_JPRB,&
&9.3642E-02_JPRB,7.8008E-02_JPRB,5.2233E-02_JPRB/)
KAO( :, 5, 1, 6) = (/&
&6.1920E-02_JPRB,9.7606E-02_JPRB,1.1219E-01_JPRB,1.1714E-01_JPRB,1.1501E-01_JPRB,1.0812E-01_JPRB,&
&9.7841E-02_JPRB,8.2254E-02_JPRB,5.5493E-02_JPRB/)
KAO( :, 1, 2, 6) = (/&
&4.2387E-02_JPRB,6.7507E-02_JPRB,7.8624E-02_JPRB,8.3202E-02_JPRB,8.2483E-02_JPRB,7.7642E-02_JPRB,&
&6.8845E-02_JPRB,5.6151E-02_JPRB,3.4701E-02_JPRB/)
KAO( :, 2, 2, 6) = (/&
&4.5358E-02_JPRB,7.2621E-02_JPRB,8.4105E-02_JPRB,8.8143E-02_JPRB,8.6828E-02_JPRB,8.1423E-02_JPRB,&
&7.2754E-02_JPRB,5.9777E-02_JPRB,3.7226E-02_JPRB/)
KAO( :, 3, 2, 6) = (/&
&4.8530E-02_JPRB,7.7675E-02_JPRB,8.9237E-02_JPRB,9.2816E-02_JPRB,9.0945E-02_JPRB,8.5108E-02_JPRB,&
&7.6583E-02_JPRB,6.3482E-02_JPRB,3.9865E-02_JPRB/)
KAO( :, 4, 2, 6) = (/&
&5.1885E-02_JPRB,8.2602E-02_JPRB,9.3935E-02_JPRB,9.7188E-02_JPRB,9.4884E-02_JPRB,8.8874E-02_JPRB,&
&8.0329E-02_JPRB,6.7178E-02_JPRB,4.2571E-02_JPRB/)
KAO( :, 5, 2, 6) = (/&
&5.5413E-02_JPRB,8.7298E-02_JPRB,9.8304E-02_JPRB,1.0128E-01_JPRB,9.8763E-02_JPRB,9.2748E-02_JPRB,&
&8.4077E-02_JPRB,7.0956E-02_JPRB,4.5317E-02_JPRB/)
KAO( :, 1, 3, 6) = (/&
&3.6455E-02_JPRB,5.8761E-02_JPRB,6.7738E-02_JPRB,7.0855E-02_JPRB,6.9598E-02_JPRB,6.5071E-02_JPRB,&
&5.7664E-02_JPRB,4.7187E-02_JPRB,2.7522E-02_JPRB/)
KAO( :, 2, 3, 6) = (/&
&3.9177E-02_JPRB,6.3373E-02_JPRB,7.2623E-02_JPRB,7.5288E-02_JPRB,7.3424E-02_JPRB,6.8383E-02_JPRB,&
&6.1089E-02_JPRB,5.0369E-02_JPRB,2.9594E-02_JPRB/)
KAO( :, 3, 3, 6) = (/&
&4.2098E-02_JPRB,6.7937E-02_JPRB,7.7177E-02_JPRB,7.9459E-02_JPRB,7.7094E-02_JPRB,7.1679E-02_JPRB,&
&6.4440E-02_JPRB,5.3598E-02_JPRB,3.1800E-02_JPRB/)
KAO( :, 4, 3, 6) = (/&
&4.5184E-02_JPRB,7.2373E-02_JPRB,8.1328E-02_JPRB,8.3304E-02_JPRB,8.0619E-02_JPRB,7.5059E-02_JPRB,&
&6.7785E-02_JPRB,5.6837E-02_JPRB,3.4061E-02_JPRB/)
KAO( :, 5, 3, 6) = (/&
&4.8428E-02_JPRB,7.6612E-02_JPRB,8.5198E-02_JPRB,8.6971E-02_JPRB,8.4087E-02_JPRB,7.8597E-02_JPRB,&
&7.1152E-02_JPRB,6.0069E-02_JPRB,3.6300E-02_JPRB/)
KAO( :, 1, 4, 6) = (/&
&3.0996E-02_JPRB,5.0246E-02_JPRB,5.7596E-02_JPRB,5.9940E-02_JPRB,5.8577E-02_JPRB,5.4443E-02_JPRB,&
&4.7987E-02_JPRB,3.9247E-02_JPRB,2.1796E-02_JPRB/)
KAO( :, 2, 4, 6) = (/&
&3.3466E-02_JPRB,5.4388E-02_JPRB,6.1941E-02_JPRB,6.3890E-02_JPRB,6.2051E-02_JPRB,5.7420E-02_JPRB,&
&5.0954E-02_JPRB,4.2026E-02_JPRB,2.3521E-02_JPRB/)
KAO( :, 3, 4, 6) = (/&
&3.6103E-02_JPRB,5.8512E-02_JPRB,6.5986E-02_JPRB,6.7619E-02_JPRB,6.5381E-02_JPRB,6.0341E-02_JPRB,&
&5.3887E-02_JPRB,4.4806E-02_JPRB,2.5354E-02_JPRB/)
KAO( :, 4, 4, 6) = (/&
&3.8902E-02_JPRB,6.2522E-02_JPRB,6.9761E-02_JPRB,7.1083E-02_JPRB,6.8563E-02_JPRB,6.3337E-02_JPRB,&
&5.6817E-02_JPRB,4.7569E-02_JPRB,2.7230E-02_JPRB/)
KAO( :, 5, 4, 6) = (/&
&4.1856E-02_JPRB,6.6293E-02_JPRB,7.3260E-02_JPRB,7.4402E-02_JPRB,7.1665E-02_JPRB,6.6453E-02_JPRB,&
&5.9783E-02_JPRB,5.0307E-02_JPRB,2.9093E-02_JPRB/)
KAO( :, 1, 5, 6) = (/&
&2.6300E-02_JPRB,4.2494E-02_JPRB,4.8463E-02_JPRB,5.0296E-02_JPRB,4.9139E-02_JPRB,4.5597E-02_JPRB,&
&3.9984E-02_JPRB,3.2427E-02_JPRB,1.7285E-02_JPRB/)
KAO( :, 2, 5, 6) = (/&
&2.8485E-02_JPRB,4.6204E-02_JPRB,5.2338E-02_JPRB,5.3863E-02_JPRB,5.2270E-02_JPRB,4.8312E-02_JPRB,&
&4.2548E-02_JPRB,3.4804E-02_JPRB,1.8719E-02_JPRB/)
KAO( :, 3, 5, 6) = (/&
&3.0827E-02_JPRB,4.9910E-02_JPRB,5.5974E-02_JPRB,5.7207E-02_JPRB,5.5255E-02_JPRB,5.0912E-02_JPRB,&
&4.5100E-02_JPRB,3.7174E-02_JPRB,2.0228E-02_JPRB/)
KAO( :, 4, 5, 6) = (/&
&3.3317E-02_JPRB,5.3494E-02_JPRB,5.9405E-02_JPRB,6.0361E-02_JPRB,5.8140E-02_JPRB,5.3556E-02_JPRB,&
&4.7658E-02_JPRB,3.9537E-02_JPRB,2.1785E-02_JPRB/)
KAO( :, 5, 5, 6) = (/&
&3.5980E-02_JPRB,5.6835E-02_JPRB,6.2631E-02_JPRB,6.3411E-02_JPRB,6.1001E-02_JPRB,5.6317E-02_JPRB,&
&5.0255E-02_JPRB,4.1909E-02_JPRB,2.3351E-02_JPRB/)
KAO( :, 1, 6, 6) = (/&
&2.2346E-02_JPRB,3.5586E-02_JPRB,4.0310E-02_JPRB,4.1785E-02_JPRB,4.0899E-02_JPRB,3.7930E-02_JPRB,&
&3.3177E-02_JPRB,2.6660E-02_JPRB,1.3671E-02_JPRB/)
KAO( :, 2, 6, 6) = (/&
&2.4236E-02_JPRB,3.8875E-02_JPRB,4.3767E-02_JPRB,4.4998E-02_JPRB,4.3719E-02_JPRB,4.0355E-02_JPRB,&
&3.5414E-02_JPRB,2.8669E-02_JPRB,1.4853E-02_JPRB/)
KAO( :, 3, 6, 6) = (/&
&2.6259E-02_JPRB,4.2194E-02_JPRB,4.7065E-02_JPRB,4.8039E-02_JPRB,4.6410E-02_JPRB,4.2692E-02_JPRB,&
&3.7647E-02_JPRB,3.0658E-02_JPRB,1.6097E-02_JPRB/)
KAO( :, 4, 6, 6) = (/&
&2.8435E-02_JPRB,4.5379E-02_JPRB,5.0168E-02_JPRB,5.0950E-02_JPRB,4.9017E-02_JPRB,4.5071E-02_JPRB,&
&3.9870E-02_JPRB,3.2675E-02_JPRB,1.7389E-02_JPRB/)
KAO( :, 5, 6, 6) = (/&
&3.0784E-02_JPRB,4.8355E-02_JPRB,5.3115E-02_JPRB,5.3744E-02_JPRB,5.1611E-02_JPRB,4.7542E-02_JPRB,&
&4.2135E-02_JPRB,3.4713E-02_JPRB,1.8719E-02_JPRB/)
KAO( :, 1, 7, 6) = (/&
&1.9038E-02_JPRB,2.9659E-02_JPRB,3.3335E-02_JPRB,3.4533E-02_JPRB,3.3796E-02_JPRB,3.1353E-02_JPRB,&
&2.7369E-02_JPRB,2.1858E-02_JPRB,1.0821E-02_JPRB/)
KAO( :, 2, 7, 6) = (/&
&2.0661E-02_JPRB,3.2535E-02_JPRB,3.6409E-02_JPRB,3.7416E-02_JPRB,3.6337E-02_JPRB,3.3530E-02_JPRB,&
&2.9317E-02_JPRB,2.3570E-02_JPRB,1.1782E-02_JPRB/)
KAO( :, 3, 7, 6) = (/&
&2.2409E-02_JPRB,3.5475E-02_JPRB,3.9394E-02_JPRB,4.0148E-02_JPRB,3.8791E-02_JPRB,3.5637E-02_JPRB,&
&3.1269E-02_JPRB,2.5254E-02_JPRB,1.2818E-02_JPRB/)
KAO( :, 4, 7, 6) = (/&
&2.4302E-02_JPRB,3.8296E-02_JPRB,4.2195E-02_JPRB,4.2786E-02_JPRB,4.1191E-02_JPRB,3.7785E-02_JPRB,&
&3.3232E-02_JPRB,2.6957E-02_JPRB,1.3893E-02_JPRB/)
KAO( :, 5, 7, 6) = (/&
&2.6331E-02_JPRB,4.0952E-02_JPRB,4.4849E-02_JPRB,4.5357E-02_JPRB,4.3572E-02_JPRB,4.0019E-02_JPRB,&
&3.5226E-02_JPRB,2.8694E-02_JPRB,1.5017E-02_JPRB/)
KAO( :, 1, 8, 6) = (/&
&1.6199E-02_JPRB,2.4730E-02_JPRB,2.7533E-02_JPRB,2.8457E-02_JPRB,2.7828E-02_JPRB,2.5812E-02_JPRB,&
&2.2538E-02_JPRB,1.7879E-02_JPRB,8.5690E-03_JPRB/)
KAO( :, 2, 8, 6) = (/&
&1.7586E-02_JPRB,2.7225E-02_JPRB,3.0249E-02_JPRB,3.1021E-02_JPRB,3.0098E-02_JPRB,2.7767E-02_JPRB,&
&2.4248E-02_JPRB,1.9357E-02_JPRB,9.3582E-03_JPRB/)
KAO( :, 3, 8, 6) = (/&
&1.9094E-02_JPRB,2.9782E-02_JPRB,3.2913E-02_JPRB,3.3499E-02_JPRB,3.2325E-02_JPRB,2.9706E-02_JPRB,&
&2.5968E-02_JPRB,2.0796E-02_JPRB,1.0214E-02_JPRB/)
KAO( :, 4, 8, 6) = (/&
&2.0716E-02_JPRB,3.2253E-02_JPRB,3.5436E-02_JPRB,3.5895E-02_JPRB,3.4530E-02_JPRB,3.1664E-02_JPRB,&
&2.7699E-02_JPRB,2.2256E-02_JPRB,1.1116E-02_JPRB/)
KAO( :, 5, 8, 6) = (/&
&2.2480E-02_JPRB,3.4617E-02_JPRB,3.7818E-02_JPRB,3.8224E-02_JPRB,3.6738E-02_JPRB,3.3713E-02_JPRB,&
&2.9501E-02_JPRB,2.3740E-02_JPRB,1.2059E-02_JPRB/)
KAO( :, 1, 9, 6) = (/&
&1.3777E-02_JPRB,2.0619E-02_JPRB,2.2737E-02_JPRB,2.3415E-02_JPRB,2.2850E-02_JPRB,2.1193E-02_JPRB,&
&1.8507E-02_JPRB,1.4598E-02_JPRB,7.1490E-03_JPRB/)
KAO( :, 2, 9, 6) = (/&
&1.4973E-02_JPRB,2.2774E-02_JPRB,2.5113E-02_JPRB,2.5666E-02_JPRB,2.4873E-02_JPRB,2.2943E-02_JPRB,&
&2.0009E-02_JPRB,1.5897E-02_JPRB,7.8590E-03_JPRB/)
KAO( :, 3, 9, 6) = (/&
&1.6264E-02_JPRB,2.4964E-02_JPRB,2.7466E-02_JPRB,2.7896E-02_JPRB,2.6883E-02_JPRB,2.4711E-02_JPRB,&
&2.1541E-02_JPRB,1.7155E-02_JPRB,8.6415E-03_JPRB/)
KAO( :, 4, 9, 6) = (/&
&1.7663E-02_JPRB,2.7143E-02_JPRB,2.9704E-02_JPRB,3.0059E-02_JPRB,2.8911E-02_JPRB,2.6494E-02_JPRB,&
&2.3105E-02_JPRB,1.8422E-02_JPRB,9.4633E-03_JPRB/)
KAO( :, 5, 9, 6) = (/&
&1.9189E-02_JPRB,2.9225E-02_JPRB,3.1858E-02_JPRB,3.2145E-02_JPRB,3.0918E-02_JPRB,2.8362E-02_JPRB,&
&2.4736E-02_JPRB,1.9714E-02_JPRB,1.0309E-02_JPRB/)
KAO( :, 1,10, 6) = (/&
&1.1829E-02_JPRB,1.7391E-02_JPRB,1.8971E-02_JPRB,1.9425E-02_JPRB,1.8925E-02_JPRB,1.7526E-02_JPRB,&
&1.5318E-02_JPRB,1.2046E-02_JPRB,7.9104E-03_JPRB/)
KAO( :, 2,10, 6) = (/&
&1.2882E-02_JPRB,1.9237E-02_JPRB,2.1011E-02_JPRB,2.1409E-02_JPRB,2.0725E-02_JPRB,1.9099E-02_JPRB,&
&1.6657E-02_JPRB,1.3189E-02_JPRB,8.8513E-03_JPRB/)
KAO( :, 3,10, 6) = (/&
&1.4005E-02_JPRB,2.1109E-02_JPRB,2.3070E-02_JPRB,2.3396E-02_JPRB,2.2541E-02_JPRB,2.0715E-02_JPRB,&
&1.8034E-02_JPRB,1.4319E-02_JPRB,9.8121E-03_JPRB/)
KAO( :, 4,10, 6) = (/&
&1.5220E-02_JPRB,2.2998E-02_JPRB,2.5049E-02_JPRB,2.5317E-02_JPRB,2.4368E-02_JPRB,2.2361E-02_JPRB,&
&1.9453E-02_JPRB,1.5444E-02_JPRB,1.0807E-02_JPRB/)
KAO( :, 5,10, 6) = (/&
&1.6552E-02_JPRB,2.4838E-02_JPRB,2.6967E-02_JPRB,2.7211E-02_JPRB,2.6179E-02_JPRB,2.4058E-02_JPRB,&
&2.0933E-02_JPRB,1.6593E-02_JPRB,1.1823E-02_JPRB/)
KAO( :, 1,11, 6) = (/&
&1.0495E-02_JPRB,1.5432E-02_JPRB,1.6714E-02_JPRB,1.6992E-02_JPRB,1.6455E-02_JPRB,1.5168E-02_JPRB,&
&1.3224E-02_JPRB,1.0391E-02_JPRB,8.1978E-03_JPRB/)
KAO( :, 2,11, 6) = (/&
&1.1451E-02_JPRB,1.7054E-02_JPRB,1.8505E-02_JPRB,1.8735E-02_JPRB,1.8057E-02_JPRB,1.6595E-02_JPRB,&
&1.4441E-02_JPRB,1.1397E-02_JPRB,9.2592E-03_JPRB/)
KAO( :, 3,11, 6) = (/&
&1.2482E-02_JPRB,1.8697E-02_JPRB,2.0258E-02_JPRB,2.0450E-02_JPRB,1.9674E-02_JPRB,1.8068E-02_JPRB,&
&1.5698E-02_JPRB,1.2409E-02_JPRB,1.0347E-02_JPRB/)
KAO( :, 4,11, 6) = (/&
&1.3612E-02_JPRB,2.0341E-02_JPRB,2.1972E-02_JPRB,2.2138E-02_JPRB,2.1292E-02_JPRB,1.9560E-02_JPRB,&
&1.7011E-02_JPRB,1.3437E-02_JPRB,1.1444E-02_JPRB/)
KAO( :, 5,11, 6) = (/&
&1.4838E-02_JPRB,2.1977E-02_JPRB,2.3658E-02_JPRB,2.3819E-02_JPRB,2.2926E-02_JPRB,2.1098E-02_JPRB,&
&1.8364E-02_JPRB,1.4494E-02_JPRB,1.2537E-02_JPRB/)
KAO( :, 1,12, 6) = (/&
&9.1433E-03_JPRB,1.3500E-02_JPRB,1.4586E-02_JPRB,1.4769E-02_JPRB,1.4241E-02_JPRB,1.3083E-02_JPRB,&
&1.1367E-02_JPRB,8.9090E-03_JPRB,7.5780E-03_JPRB/)
KAO( :, 2,12, 6) = (/&
&1.0001E-02_JPRB,1.4910E-02_JPRB,1.6125E-02_JPRB,1.6273E-02_JPRB,1.5652E-02_JPRB,1.4357E-02_JPRB,&
&1.2453E-02_JPRB,9.7929E-03_JPRB,8.5785E-03_JPRB/)
KAO( :, 3,12, 6) = (/&
&1.0949E-02_JPRB,1.6356E-02_JPRB,1.7635E-02_JPRB,1.7750E-02_JPRB,1.7058E-02_JPRB,1.5652E-02_JPRB,&
&1.3578E-02_JPRB,1.0697E-02_JPRB,9.5948E-03_JPRB/)
KAO( :, 4,12, 6) = (/&
&1.1985E-02_JPRB,1.7801E-02_JPRB,1.9128E-02_JPRB,1.9222E-02_JPRB,1.8476E-02_JPRB,1.6972E-02_JPRB,&
&1.4745E-02_JPRB,1.1628E-02_JPRB,1.0600E-02_JPRB/)
KAO( :, 5,12, 6) = (/&
&1.3096E-02_JPRB,1.9267E-02_JPRB,2.0626E-02_JPRB,2.0713E-02_JPRB,1.9923E-02_JPRB,1.8336E-02_JPRB,&
&1.5960E-02_JPRB,1.2572E-02_JPRB,1.1582E-02_JPRB/)
KAO( :, 1,13, 6) = (/&
&7.8612E-03_JPRB,1.1670E-02_JPRB,1.2609E-02_JPRB,1.2723E-02_JPRB,1.2259E-02_JPRB,1.1258E-02_JPRB,&
&9.7650E-03_JPRB,7.6525E-03_JPRB,6.5421E-03_JPRB/)
KAO( :, 2,13, 6) = (/&
&8.6369E-03_JPRB,1.2899E-02_JPRB,1.3916E-02_JPRB,1.4009E-02_JPRB,1.3482E-02_JPRB,1.2381E-02_JPRB,&
&1.0732E-02_JPRB,8.4378E-03_JPRB,7.4103E-03_JPRB/)
KAO( :, 3,13, 6) = (/&
&9.4942E-03_JPRB,1.4163E-02_JPRB,1.5223E-02_JPRB,1.5298E-02_JPRB,1.4708E-02_JPRB,1.3515E-02_JPRB,&
&1.1735E-02_JPRB,9.2523E-03_JPRB,8.2790E-03_JPRB/)
KAO( :, 4,13, 6) = (/&
&1.0421E-02_JPRB,1.5442E-02_JPRB,1.6542E-02_JPRB,1.6603E-02_JPRB,1.5959E-02_JPRB,1.4684E-02_JPRB,&
&1.2779E-02_JPRB,1.0090E-02_JPRB,9.1372E-03_JPRB/)
KAO( :, 5,13, 6) = (/&
&1.1403E-02_JPRB,1.6752E-02_JPRB,1.7882E-02_JPRB,1.7947E-02_JPRB,1.7255E-02_JPRB,1.5898E-02_JPRB,&
&1.3874E-02_JPRB,1.0931E-02_JPRB,9.9832E-03_JPRB/)
KAO( :, 1, 1, 7) = (/&
&1.6154E-01_JPRB,1.9464E-01_JPRB,1.9968E-01_JPRB,1.9566E-01_JPRB,1.8810E-01_JPRB,1.7612E-01_JPRB,&
&1.6037E-01_JPRB,1.3871E-01_JPRB,9.9439E-02_JPRB/)
KAO( :, 2, 1, 7) = (/&
&1.6718E-01_JPRB,2.0083E-01_JPRB,2.0683E-01_JPRB,2.0477E-01_JPRB,1.9764E-01_JPRB,1.8624E-01_JPRB,&
&1.6994E-01_JPRB,1.4688E-01_JPRB,1.0691E-01_JPRB/)
KAO( :, 3, 1, 7) = (/&
&1.7242E-01_JPRB,2.0656E-01_JPRB,2.1371E-01_JPRB,2.1366E-01_JPRB,2.0783E-01_JPRB,1.9677E-01_JPRB,&
&1.7978E-01_JPRB,1.5487E-01_JPRB,1.1430E-01_JPRB/)
KAO( :, 4, 1, 7) = (/&
&1.7742E-01_JPRB,2.1213E-01_JPRB,2.2064E-01_JPRB,2.2231E-01_JPRB,2.1832E-01_JPRB,2.0746E-01_JPRB,&
&1.8983E-01_JPRB,1.6294E-01_JPRB,1.2155E-01_JPRB/)
KAO( :, 5, 1, 7) = (/&
&1.8214E-01_JPRB,2.1767E-01_JPRB,2.2778E-01_JPRB,2.3090E-01_JPRB,2.2852E-01_JPRB,2.1832E-01_JPRB,&
&2.0005E-01_JPRB,1.7084E-01_JPRB,1.2867E-01_JPRB/)
KAO( :, 1, 2, 7) = (/&
&1.4145E-01_JPRB,1.6994E-01_JPRB,1.7429E-01_JPRB,1.7183E-01_JPRB,1.6506E-01_JPRB,1.5419E-01_JPRB,&
&1.3930E-01_JPRB,1.2012E-01_JPRB,8.1602E-02_JPRB/)
KAO( :, 2, 2, 7) = (/&
&1.4643E-01_JPRB,1.7555E-01_JPRB,1.8089E-01_JPRB,1.8028E-01_JPRB,1.7424E-01_JPRB,1.6361E-01_JPRB,&
&1.4828E-01_JPRB,1.2787E-01_JPRB,8.7984E-02_JPRB/)
KAO( :, 3, 2, 7) = (/&
&1.5117E-01_JPRB,1.8085E-01_JPRB,1.8746E-01_JPRB,1.8838E-01_JPRB,1.8361E-01_JPRB,1.7334E-01_JPRB,&
&1.5765E-01_JPRB,1.3543E-01_JPRB,9.4264E-02_JPRB/)
KAO( :, 4, 2, 7) = (/&
&1.5573E-01_JPRB,1.8623E-01_JPRB,1.9419E-01_JPRB,1.9646E-01_JPRB,1.9291E-01_JPRB,1.8328E-01_JPRB,&
&1.6725E-01_JPRB,1.4294E-01_JPRB,1.0040E-01_JPRB/)
KAO( :, 5, 2, 7) = (/&
&1.6013E-01_JPRB,1.9161E-01_JPRB,2.0111E-01_JPRB,2.0451E-01_JPRB,2.0197E-01_JPRB,1.9329E-01_JPRB,&
&1.7696E-01_JPRB,1.5031E-01_JPRB,1.0647E-01_JPRB/)
KAO( :, 1, 3, 7) = (/&
&1.2309E-01_JPRB,1.4704E-01_JPRB,1.5024E-01_JPRB,1.4812E-01_JPRB,1.4219E-01_JPRB,1.3226E-01_JPRB,&
&1.1881E-01_JPRB,1.0141E-01_JPRB,6.5459E-02_JPRB/)
KAO( :, 2, 3, 7) = (/&
&1.2767E-01_JPRB,1.5222E-01_JPRB,1.5637E-01_JPRB,1.5568E-01_JPRB,1.5055E-01_JPRB,1.4090E-01_JPRB,&
&1.2701E-01_JPRB,1.0859E-01_JPRB,7.0881E-02_JPRB/)
KAO( :, 3, 3, 7) = (/&
&1.3203E-01_JPRB,1.5727E-01_JPRB,1.6255E-01_JPRB,1.6317E-01_JPRB,1.5886E-01_JPRB,1.4989E-01_JPRB,&
&1.3559E-01_JPRB,1.1576E-01_JPRB,7.6083E-02_JPRB/)
KAO( :, 4, 3, 7) = (/&
&1.3635E-01_JPRB,1.6234E-01_JPRB,1.6898E-01_JPRB,1.7060E-01_JPRB,1.6716E-01_JPRB,1.5892E-01_JPRB,&
&1.4437E-01_JPRB,1.2295E-01_JPRB,8.1201E-02_JPRB/)
KAO( :, 5, 3, 7) = (/&
&1.4056E-01_JPRB,1.6755E-01_JPRB,1.7569E-01_JPRB,1.7797E-01_JPRB,1.7536E-01_JPRB,1.6774E-01_JPRB,&
&1.5329E-01_JPRB,1.3002E-01_JPRB,8.6370E-02_JPRB/)
KAO( :, 1, 4, 7) = (/&
&1.0694E-01_JPRB,1.2727E-01_JPRB,1.2915E-01_JPRB,1.2666E-01_JPRB,1.2117E-01_JPRB,1.1228E-01_JPRB,&
&1.0026E-01_JPRB,8.4627E-02_JPRB,5.2347E-02_JPRB/)
KAO( :, 2, 4, 7) = (/&
&1.1128E-01_JPRB,1.3208E-01_JPRB,1.3481E-01_JPRB,1.3351E-01_JPRB,1.2855E-01_JPRB,1.2006E-01_JPRB,&
&1.0771E-01_JPRB,9.1021E-02_JPRB,5.6953E-02_JPRB/)
KAO( :, 3, 4, 7) = (/&
&1.1540E-01_JPRB,1.3680E-01_JPRB,1.4057E-01_JPRB,1.4029E-01_JPRB,1.3591E-01_JPRB,1.2809E-01_JPRB,&
&1.1544E-01_JPRB,9.7575E-02_JPRB,6.1322E-02_JPRB/)
KAO( :, 4, 4, 7) = (/&
&1.1945E-01_JPRB,1.4164E-01_JPRB,1.4662E-01_JPRB,1.4706E-01_JPRB,1.4340E-01_JPRB,1.3603E-01_JPRB,&
&1.2336E-01_JPRB,1.0424E-01_JPRB,6.5662E-02_JPRB/)
KAO( :, 5, 4, 7) = (/&
&1.2340E-01_JPRB,1.4675E-01_JPRB,1.5288E-01_JPRB,1.5380E-01_JPRB,1.5079E-01_JPRB,1.4378E-01_JPRB,&
&1.3119E-01_JPRB,1.1079E-01_JPRB,7.0042E-02_JPRB/)
KAO( :, 1, 5, 7) = (/&
&9.2366E-02_JPRB,1.1024E-01_JPRB,1.1122E-01_JPRB,1.0839E-01_JPRB,1.0297E-01_JPRB,9.4813E-02_JPRB,&
&8.4116E-02_JPRB,7.0267E-02_JPRB,4.1776E-02_JPRB/)
KAO( :, 2, 5, 7) = (/&
&9.6355E-02_JPRB,1.1479E-01_JPRB,1.1644E-01_JPRB,1.1449E-01_JPRB,1.0946E-01_JPRB,1.0165E-01_JPRB,&
&9.0750E-02_JPRB,7.5967E-02_JPRB,4.5678E-02_JPRB/)
KAO( :, 3, 5, 7) = (/&
&1.0024E-01_JPRB,1.1923E-01_JPRB,1.2179E-01_JPRB,1.2053E-01_JPRB,1.1597E-01_JPRB,1.0868E-01_JPRB,&
&9.7605E-02_JPRB,8.1879E-02_JPRB,4.9420E-02_JPRB/)
KAO( :, 4, 5, 7) = (/&
&1.0406E-01_JPRB,1.2386E-01_JPRB,1.2729E-01_JPRB,1.2663E-01_JPRB,1.2262E-01_JPRB,1.1560E-01_JPRB,&
&1.0455E-01_JPRB,8.7805E-02_JPRB,5.3104E-02_JPRB/)
KAO( :, 5, 5, 7) = (/&
&1.0784E-01_JPRB,1.2877E-01_JPRB,1.3298E-01_JPRB,1.3282E-01_JPRB,1.2921E-01_JPRB,1.2238E-01_JPRB,&
&1.1132E-01_JPRB,9.3754E-02_JPRB,5.6821E-02_JPRB/)
KAO( :, 1, 6, 7) = (/&
&7.9024E-02_JPRB,9.4822E-02_JPRB,9.5344E-02_JPRB,9.2551E-02_JPRB,8.7276E-02_JPRB,7.9771E-02_JPRB,&
&7.0098E-02_JPRB,5.7834E-02_JPRB,3.3015E-02_JPRB/)
KAO( :, 2, 6, 7) = (/&
&8.2738E-02_JPRB,9.8989E-02_JPRB,1.0012E-01_JPRB,9.7961E-02_JPRB,9.2877E-02_JPRB,8.5652E-02_JPRB,&
&7.5923E-02_JPRB,6.2877E-02_JPRB,3.6314E-02_JPRB/)
KAO( :, 3, 6, 7) = (/&
&8.6408E-02_JPRB,1.0314E-01_JPRB,1.0499E-01_JPRB,1.0331E-01_JPRB,9.8576E-02_JPRB,9.1675E-02_JPRB,&
&8.1907E-02_JPRB,6.8103E-02_JPRB,3.9534E-02_JPRB/)
KAO( :, 4, 6, 7) = (/&
&9.0076E-02_JPRB,1.0755E-01_JPRB,1.1005E-01_JPRB,1.0872E-01_JPRB,1.0446E-01_JPRB,9.7640E-02_JPRB,&
&8.7824E-02_JPRB,7.3333E-02_JPRB,4.2688E-02_JPRB/)
KAO( :, 5, 6, 7) = (/&
&9.3695E-02_JPRB,1.1225E-01_JPRB,1.1524E-01_JPRB,1.1429E-01_JPRB,1.1026E-01_JPRB,1.0360E-01_JPRB,&
&9.3605E-02_JPRB,7.8587E-02_JPRB,4.5859E-02_JPRB/)
KAO( :, 1, 7, 7) = (/&
&6.7188E-02_JPRB,8.0973E-02_JPRB,8.1282E-02_JPRB,7.8604E-02_JPRB,7.3758E-02_JPRB,6.7095E-02_JPRB,&
&5.8393E-02_JPRB,4.7360E-02_JPRB,2.5942E-02_JPRB/)
KAO( :, 2, 7, 7) = (/&
&7.0634E-02_JPRB,8.4835E-02_JPRB,8.5597E-02_JPRB,8.3380E-02_JPRB,7.8711E-02_JPRB,7.2137E-02_JPRB,&
&6.3418E-02_JPRB,5.1732E-02_JPRB,2.8746E-02_JPRB/)
KAO( :, 3, 7, 7) = (/&
&7.4125E-02_JPRB,8.8733E-02_JPRB,9.0006E-02_JPRB,8.8141E-02_JPRB,8.3708E-02_JPRB,7.7276E-02_JPRB,&
&6.8516E-02_JPRB,5.6288E-02_JPRB,3.1491E-02_JPRB/)
KAO( :, 4, 7, 7) = (/&
&7.7619E-02_JPRB,9.2938E-02_JPRB,9.4622E-02_JPRB,9.3008E-02_JPRB,8.8787E-02_JPRB,8.2441E-02_JPRB,&
&7.3541E-02_JPRB,6.0853E-02_JPRB,3.4197E-02_JPRB/)
KAO( :, 5, 7, 7) = (/&
&8.1130E-02_JPRB,9.7412E-02_JPRB,9.9437E-02_JPRB,9.7963E-02_JPRB,9.3908E-02_JPRB,8.7589E-02_JPRB,&
&7.8507E-02_JPRB,6.5406E-02_JPRB,3.6876E-02_JPRB/)
KAO( :, 1, 8, 7) = (/&
&5.7087E-02_JPRB,6.8982E-02_JPRB,6.9219E-02_JPRB,6.6662E-02_JPRB,6.2257E-02_JPRB,5.6449E-02_JPRB,&
&4.8696E-02_JPRB,3.8705E-02_JPRB,2.0368E-02_JPRB/)
KAO( :, 2, 8, 7) = (/&
&6.0267E-02_JPRB,7.2661E-02_JPRB,7.3164E-02_JPRB,7.0903E-02_JPRB,6.6680E-02_JPRB,6.0863E-02_JPRB,&
&5.2991E-02_JPRB,4.2493E-02_JPRB,2.2764E-02_JPRB/)
KAO( :, 3, 8, 7) = (/&
&6.3568E-02_JPRB,7.6402E-02_JPRB,7.7191E-02_JPRB,7.5170E-02_JPRB,7.1124E-02_JPRB,6.5262E-02_JPRB,&
&5.7325E-02_JPRB,4.6424E-02_JPRB,2.5106E-02_JPRB/)
KAO( :, 4, 8, 7) = (/&
&6.6952E-02_JPRB,8.0431E-02_JPRB,8.1433E-02_JPRB,7.9580E-02_JPRB,7.5603E-02_JPRB,6.9713E-02_JPRB,&
&6.1612E-02_JPRB,5.0326E-02_JPRB,2.7428E-02_JPRB/)
KAO( :, 5, 8, 7) = (/&
&7.0374E-02_JPRB,8.4700E-02_JPRB,8.5936E-02_JPRB,8.4079E-02_JPRB,8.0117E-02_JPRB,7.4154E-02_JPRB,&
&6.5876E-02_JPRB,5.4195E-02_JPRB,2.9716E-02_JPRB/)
KAO( :, 1, 9, 7) = (/&
&4.8541E-02_JPRB,5.8698E-02_JPRB,5.8862E-02_JPRB,5.6589E-02_JPRB,5.2616E-02_JPRB,4.7478E-02_JPRB,&
&4.0621E-02_JPRB,3.1660E-02_JPRB,1.6311E-02_JPRB/)
KAO( :, 2, 9, 7) = (/&
&5.1470E-02_JPRB,6.2152E-02_JPRB,6.2537E-02_JPRB,6.0429E-02_JPRB,5.6605E-02_JPRB,5.1332E-02_JPRB,&
&4.4320E-02_JPRB,3.4891E-02_JPRB,1.8357E-02_JPRB/)
KAO( :, 3, 9, 7) = (/&
&5.4592E-02_JPRB,6.5779E-02_JPRB,6.6299E-02_JPRB,6.4328E-02_JPRB,6.0595E-02_JPRB,5.5195E-02_JPRB,&
&4.8026E-02_JPRB,3.8250E-02_JPRB,2.0370E-02_JPRB/)
KAO( :, 4, 9, 7) = (/&
&5.7857E-02_JPRB,6.9626E-02_JPRB,7.0279E-02_JPRB,6.8395E-02_JPRB,6.4585E-02_JPRB,5.9114E-02_JPRB,&
&5.1701E-02_JPRB,4.1583E-02_JPRB,2.2355E-02_JPRB/)
KAO( :, 5, 9, 7) = (/&
&6.1151E-02_JPRB,7.3773E-02_JPRB,7.4523E-02_JPRB,7.2563E-02_JPRB,6.8640E-02_JPRB,6.3021E-02_JPRB,&
&5.5368E-02_JPRB,4.4866E-02_JPRB,2.4319E-02_JPRB/)
KAO( :, 1,10, 7) = (/&
&4.1703E-02_JPRB,5.0397E-02_JPRB,5.0498E-02_JPRB,4.8532E-02_JPRB,4.5038E-02_JPRB,4.0454E-02_JPRB,&
&3.4353E-02_JPRB,2.6239E-02_JPRB,1.6946E-02_JPRB/)
KAO( :, 2,10, 7) = (/&
&4.4435E-02_JPRB,5.3723E-02_JPRB,5.3968E-02_JPRB,5.2070E-02_JPRB,4.8666E-02_JPRB,4.3928E-02_JPRB,&
&3.7574E-02_JPRB,2.9025E-02_JPRB,1.9214E-02_JPRB/)
KAO( :, 3,10, 7) = (/&
&4.7412E-02_JPRB,5.7277E-02_JPRB,5.7540E-02_JPRB,5.5713E-02_JPRB,5.2331E-02_JPRB,4.7382E-02_JPRB,&
&4.0823E-02_JPRB,3.1871E-02_JPRB,2.1538E-02_JPRB/)
KAO( :, 4,10, 7) = (/&
&5.0574E-02_JPRB,6.1042E-02_JPRB,6.1373E-02_JPRB,5.9574E-02_JPRB,5.6031E-02_JPRB,5.0898E-02_JPRB,&
&4.4058E-02_JPRB,3.4717E-02_JPRB,2.3877E-02_JPRB/)
KAO( :, 5,10, 7) = (/&
&5.3746E-02_JPRB,6.5044E-02_JPRB,6.5451E-02_JPRB,6.3520E-02_JPRB,5.9778E-02_JPRB,5.4461E-02_JPRB,&
&4.7278E-02_JPRB,3.7547E-02_JPRB,2.6231E-02_JPRB/)
KAO( :, 1,11, 7) = (/&
&3.7231E-02_JPRB,4.4782E-02_JPRB,4.4834E-02_JPRB,4.3110E-02_JPRB,4.0069E-02_JPRB,3.5931E-02_JPRB,&
&3.0502E-02_JPRB,2.3057E-02_JPRB,1.8284E-02_JPRB/)
KAO( :, 2,11, 7) = (/&
&3.9875E-02_JPRB,4.8062E-02_JPRB,4.8155E-02_JPRB,4.6465E-02_JPRB,4.3416E-02_JPRB,3.9078E-02_JPRB,&
&3.3371E-02_JPRB,2.5491E-02_JPRB,2.0825E-02_JPRB/)
KAO( :, 3,11, 7) = (/&
&4.2772E-02_JPRB,5.1583E-02_JPRB,5.1719E-02_JPRB,5.0024E-02_JPRB,4.6821E-02_JPRB,4.2262E-02_JPRB,&
&3.6260E-02_JPRB,2.7962E-02_JPRB,2.3421E-02_JPRB/)
KAO( :, 4,11, 7) = (/&
&4.5744E-02_JPRB,5.5320E-02_JPRB,5.5524E-02_JPRB,5.3716E-02_JPRB,5.0328E-02_JPRB,4.5568E-02_JPRB,&
&3.9152E-02_JPRB,3.0434E-02_JPRB,2.6081E-02_JPRB/)
KAO( :, 5,11, 7) = (/&
&4.8771E-02_JPRB,5.9196E-02_JPRB,5.9515E-02_JPRB,5.7526E-02_JPRB,5.3932E-02_JPRB,4.8905E-02_JPRB,&
&4.2062E-02_JPRB,3.2920E-02_JPRB,2.8799E-02_JPRB/)
KAO( :, 1,12, 7) = (/&
&3.3165E-02_JPRB,3.9692E-02_JPRB,3.9599E-02_JPRB,3.8024E-02_JPRB,3.5310E-02_JPRB,3.1588E-02_JPRB,&
&2.6724E-02_JPRB,2.0140E-02_JPRB,1.7962E-02_JPRB/)
KAO( :, 2,12, 7) = (/&
&3.5669E-02_JPRB,4.2809E-02_JPRB,4.2746E-02_JPRB,4.1180E-02_JPRB,3.8355E-02_JPRB,3.4405E-02_JPRB,&
&2.9261E-02_JPRB,2.2261E-02_JPRB,2.0601E-02_JPRB/)
KAO( :, 3,12, 7) = (/&
&3.8321E-02_JPRB,4.6119E-02_JPRB,4.6151E-02_JPRB,4.4514E-02_JPRB,4.1510E-02_JPRB,3.7321E-02_JPRB,&
&3.1841E-02_JPRB,2.4389E-02_JPRB,2.3308E-02_JPRB/)
KAO( :, 4,12, 7) = (/&
&4.1022E-02_JPRB,4.9612E-02_JPRB,4.9764E-02_JPRB,4.7979E-02_JPRB,4.4755E-02_JPRB,4.0343E-02_JPRB,&
&3.4469E-02_JPRB,2.6528E-02_JPRB,2.6037E-02_JPRB/)
KAO( :, 5,12, 7) = (/&
&4.3787E-02_JPRB,5.3202E-02_JPRB,5.3413E-02_JPRB,5.1511E-02_JPRB,4.8094E-02_JPRB,4.3379E-02_JPRB,&
&3.7123E-02_JPRB,2.8712E-02_JPRB,2.8765E-02_JPRB/)
KAO( :, 1,13, 7) = (/&
&2.9468E-02_JPRB,3.5299E-02_JPRB,3.5147E-02_JPRB,3.3716E-02_JPRB,3.1258E-02_JPRB,2.7857E-02_JPRB,&
&2.3479E-02_JPRB,1.7565E-02_JPRB,1.6401E-02_JPRB/)
KAO( :, 2,13, 7) = (/&
&3.1822E-02_JPRB,3.8242E-02_JPRB,3.8151E-02_JPRB,3.6698E-02_JPRB,3.4080E-02_JPRB,3.0460E-02_JPRB,&
&2.5743E-02_JPRB,1.9422E-02_JPRB,1.8869E-02_JPRB/)
KAO( :, 3,13, 7) = (/&
&3.4255E-02_JPRB,4.1360E-02_JPRB,4.1371E-02_JPRB,3.9795E-02_JPRB,3.7027E-02_JPRB,3.3168E-02_JPRB,&
&2.8068E-02_JPRB,2.1290E-02_JPRB,2.1356E-02_JPRB/)
KAO( :, 4,13, 7) = (/&
&3.6724E-02_JPRB,4.4593E-02_JPRB,4.4667E-02_JPRB,4.2990E-02_JPRB,4.0057E-02_JPRB,3.5909E-02_JPRB,&
&3.0433E-02_JPRB,2.3190E-02_JPRB,2.3849E-02_JPRB/)
KAO( :, 5,13, 7) = (/&
&3.9283E-02_JPRB,4.7884E-02_JPRB,4.8024E-02_JPRB,4.6223E-02_JPRB,4.3087E-02_JPRB,3.8671E-02_JPRB,&
&3.2860E-02_JPRB,2.5142E-02_JPRB,2.6303E-02_JPRB/)
KAO( :, 1, 1, 8) = (/&
&4.0322E-01_JPRB,4.2884E-01_JPRB,4.4287E-01_JPRB,4.4611E-01_JPRB,4.3402E-01_JPRB,4.1077E-01_JPRB,&
&3.7521E-01_JPRB,3.2697E-01_JPRB,2.6830E-01_JPRB/)
KAO( :, 2, 1, 8) = (/&
&4.1659E-01_JPRB,4.4635E-01_JPRB,4.6251E-01_JPRB,4.6551E-01_JPRB,4.5392E-01_JPRB,4.3080E-01_JPRB,&
&3.9654E-01_JPRB,3.4859E-01_JPRB,2.8992E-01_JPRB/)
KAO( :, 3, 1, 8) = (/&
&4.3066E-01_JPRB,4.6487E-01_JPRB,4.8341E-01_JPRB,4.8533E-01_JPRB,4.7318E-01_JPRB,4.5018E-01_JPRB,&
&4.1684E-01_JPRB,3.6978E-01_JPRB,3.1151E-01_JPRB/)
KAO( :, 4, 1, 8) = (/&
&4.4540E-01_JPRB,4.8420E-01_JPRB,5.0502E-01_JPRB,5.0600E-01_JPRB,4.9161E-01_JPRB,4.6895E-01_JPRB,&
&4.3612E-01_JPRB,3.9090E-01_JPRB,3.3327E-01_JPRB/)
KAO( :, 5, 1, 8) = (/&
&4.6087E-01_JPRB,5.0391E-01_JPRB,5.2680E-01_JPRB,5.2675E-01_JPRB,5.1014E-01_JPRB,4.8707E-01_JPRB,&
&4.5479E-01_JPRB,4.1126E-01_JPRB,3.5494E-01_JPRB/)
KAO( :, 1, 2, 8) = (/&
&3.6116E-01_JPRB,3.9180E-01_JPRB,4.0630E-01_JPRB,4.0741E-01_JPRB,3.9710E-01_JPRB,3.7545E-01_JPRB,&
&3.4074E-01_JPRB,2.9225E-01_JPRB,2.2503E-01_JPRB/)
KAO( :, 2, 2, 8) = (/&
&3.7429E-01_JPRB,4.0933E-01_JPRB,4.2583E-01_JPRB,4.2659E-01_JPRB,4.1646E-01_JPRB,3.9447E-01_JPRB,&
&3.6022E-01_JPRB,3.1183E-01_JPRB,2.4425E-01_JPRB/)
KAO( :, 3, 2, 8) = (/&
&3.8833E-01_JPRB,4.2821E-01_JPRB,4.4642E-01_JPRB,4.4678E-01_JPRB,4.3567E-01_JPRB,4.1270E-01_JPRB,&
&3.7849E-01_JPRB,3.3160E-01_JPRB,2.6352E-01_JPRB/)
KAO( :, 4, 2, 8) = (/&
&4.0301E-01_JPRB,4.4802E-01_JPRB,4.6770E-01_JPRB,4.6760E-01_JPRB,4.5474E-01_JPRB,4.3035E-01_JPRB,&
&3.9631E-01_JPRB,3.5077E-01_JPRB,2.8292E-01_JPRB/)
KAO( :, 5, 2, 8) = (/&
&4.1749E-01_JPRB,4.6796E-01_JPRB,4.8938E-01_JPRB,4.8856E-01_JPRB,4.7348E-01_JPRB,4.4790E-01_JPRB,&
&4.1404E-01_JPRB,3.6908E-01_JPRB,3.0219E-01_JPRB/)
KAO( :, 1, 3, 8) = (/&
&3.1836E-01_JPRB,3.5137E-01_JPRB,3.6460E-01_JPRB,3.6422E-01_JPRB,3.5477E-01_JPRB,3.3593E-01_JPRB,&
&3.0362E-01_JPRB,2.5584E-01_JPRB,1.8328E-01_JPRB/)
KAO( :, 2, 3, 8) = (/&
&3.3096E-01_JPRB,3.6850E-01_JPRB,3.8310E-01_JPRB,3.8300E-01_JPRB,3.7372E-01_JPRB,3.5449E-01_JPRB,&
&3.2124E-01_JPRB,2.7389E-01_JPRB,2.0014E-01_JPRB/)
KAO( :, 3, 3, 8) = (/&
&3.4458E-01_JPRB,3.8711E-01_JPRB,4.0276E-01_JPRB,4.0262E-01_JPRB,3.9285E-01_JPRB,3.7244E-01_JPRB,&
&3.3829E-01_JPRB,2.9150E-01_JPRB,2.1726E-01_JPRB/)
KAO( :, 4, 3, 8) = (/&
&3.5799E-01_JPRB,4.0642E-01_JPRB,4.2324E-01_JPRB,4.2311E-01_JPRB,4.1204E-01_JPRB,3.8967E-01_JPRB,&
&3.5509E-01_JPRB,3.0840E-01_JPRB,2.3441E-01_JPRB/)
KAO( :, 5, 3, 8) = (/&
&3.7101E-01_JPRB,4.2557E-01_JPRB,4.4433E-01_JPRB,4.4402E-01_JPRB,4.3131E-01_JPRB,4.0719E-01_JPRB,&
&3.7164E-01_JPRB,3.2487E-01_JPRB,2.5132E-01_JPRB/)
KAO( :, 1, 4, 8) = (/&
&2.7843E-01_JPRB,3.1174E-01_JPRB,3.2299E-01_JPRB,3.2159E-01_JPRB,3.1254E-01_JPRB,2.9513E-01_JPRB,&
&2.6711E-01_JPRB,2.2161E-01_JPRB,1.4841E-01_JPRB/)
KAO( :, 2, 4, 8) = (/&
&2.9013E-01_JPRB,3.2832E-01_JPRB,3.4033E-01_JPRB,3.3944E-01_JPRB,3.3063E-01_JPRB,3.1287E-01_JPRB,&
&2.8384E-01_JPRB,2.3810E-01_JPRB,1.6312E-01_JPRB/)
KAO( :, 3, 4, 8) = (/&
&3.0268E-01_JPRB,3.4605E-01_JPRB,3.5891E-01_JPRB,3.5819E-01_JPRB,3.4915E-01_JPRB,3.3041E-01_JPRB,&
&2.9986E-01_JPRB,2.5399E-01_JPRB,1.7819E-01_JPRB/)
KAO( :, 4, 4, 8) = (/&
&3.1479E-01_JPRB,3.6429E-01_JPRB,3.7832E-01_JPRB,3.7789E-01_JPRB,3.6791E-01_JPRB,3.4794E-01_JPRB,&
&3.1552E-01_JPRB,2.6914E-01_JPRB,1.9313E-01_JPRB/)
KAO( :, 5, 4, 8) = (/&
&3.2665E-01_JPRB,3.8187E-01_JPRB,3.9828E-01_JPRB,3.9805E-01_JPRB,3.8707E-01_JPRB,3.6554E-01_JPRB,&
&3.3111E-01_JPRB,2.8418E-01_JPRB,2.0797E-01_JPRB/)
KAO( :, 1, 5, 8) = (/&
&2.4307E-01_JPRB,2.7459E-01_JPRB,2.8334E-01_JPRB,2.8148E-01_JPRB,2.7250E-01_JPRB,2.5608E-01_JPRB,&
&2.3119E-01_JPRB,1.9095E-01_JPRB,1.1978E-01_JPRB/)
KAO( :, 2, 5, 8) = (/&
&2.5412E-01_JPRB,2.9006E-01_JPRB,2.9964E-01_JPRB,2.9834E-01_JPRB,2.8946E-01_JPRB,2.7270E-01_JPRB,&
&2.4720E-01_JPRB,2.0586E-01_JPRB,1.3250E-01_JPRB/)
KAO( :, 3, 5, 8) = (/&
&2.6544E-01_JPRB,3.0651E-01_JPRB,3.1718E-01_JPRB,3.1602E-01_JPRB,3.0707E-01_JPRB,2.8950E-01_JPRB,&
&2.6270E-01_JPRB,2.1996E-01_JPRB,1.4559E-01_JPRB/)
KAO( :, 4, 5, 8) = (/&
&2.7620E-01_JPRB,3.2315E-01_JPRB,3.3545E-01_JPRB,3.3465E-01_JPRB,3.2491E-01_JPRB,3.0648E-01_JPRB,&
&2.7754E-01_JPRB,2.3379E-01_JPRB,1.5847E-01_JPRB/)
KAO( :, 5, 5, 8) = (/&
&2.8682E-01_JPRB,3.3927E-01_JPRB,3.5367E-01_JPRB,3.5367E-01_JPRB,3.4331E-01_JPRB,3.2364E-01_JPRB,&
&2.9241E-01_JPRB,2.4747E-01_JPRB,1.7133E-01_JPRB/)
KAO( :, 1, 6, 8) = (/&
&2.1177E-01_JPRB,2.4018E-01_JPRB,2.4637E-01_JPRB,2.4351E-01_JPRB,2.3439E-01_JPRB,2.1931E-01_JPRB,&
&1.9713E-01_JPRB,1.6297E-01_JPRB,9.5914E-02_JPRB/)
KAO( :, 2, 6, 8) = (/&
&2.2169E-01_JPRB,2.5443E-01_JPRB,2.6139E-01_JPRB,2.5908E-01_JPRB,2.5022E-01_JPRB,2.3482E-01_JPRB,&
&2.1183E-01_JPRB,1.7638E-01_JPRB,1.0688E-01_JPRB/)
KAO( :, 3, 6, 8) = (/&
&2.3172E-01_JPRB,2.6938E-01_JPRB,2.7763E-01_JPRB,2.7552E-01_JPRB,2.6672E-01_JPRB,2.5051E-01_JPRB,&
&2.2626E-01_JPRB,1.8899E-01_JPRB,1.1795E-01_JPRB/)
KAO( :, 4, 6, 8) = (/&
&2.4156E-01_JPRB,2.8413E-01_JPRB,2.9429E-01_JPRB,2.9295E-01_JPRB,2.8356E-01_JPRB,2.6650E-01_JPRB,&
&2.4057E-01_JPRB,2.0157E-01_JPRB,1.2896E-01_JPRB/)
KAO( :, 5, 6, 8) = (/&
&2.5124E-01_JPRB,2.9850E-01_JPRB,3.1067E-01_JPRB,3.1041E-01_JPRB,3.0075E-01_JPRB,2.8246E-01_JPRB,&
&2.5505E-01_JPRB,2.1388E-01_JPRB,1.3998E-01_JPRB/)
KAO( :, 1, 7, 8) = (/&
&1.8473E-01_JPRB,2.0924E-01_JPRB,2.1335E-01_JPRB,2.0936E-01_JPRB,1.9988E-01_JPRB,1.8587E-01_JPRB,&
&1.6639E-01_JPRB,1.3717E-01_JPRB,7.6364E-02_JPRB/)
KAO( :, 2, 7, 8) = (/&
&1.9350E-01_JPRB,2.2219E-01_JPRB,2.2721E-01_JPRB,2.2345E-01_JPRB,2.1426E-01_JPRB,2.0011E-01_JPRB,&
&1.7972E-01_JPRB,1.4932E-01_JPRB,8.5682E-02_JPRB/)
KAO( :, 3, 7, 8) = (/&
&2.0222E-01_JPRB,2.3570E-01_JPRB,2.4195E-01_JPRB,2.3854E-01_JPRB,2.2951E-01_JPRB,2.1468E-01_JPRB,&
&1.9301E-01_JPRB,1.6077E-01_JPRB,9.5001E-02_JPRB/)
KAO( :, 4, 7, 8) = (/&
&2.1095E-01_JPRB,2.4886E-01_JPRB,2.5670E-01_JPRB,2.5432E-01_JPRB,2.4507E-01_JPRB,2.2935E-01_JPRB,&
&2.0620E-01_JPRB,1.7210E-01_JPRB,1.0440E-01_JPRB/)
KAO( :, 5, 7, 8) = (/&
&2.1973E-01_JPRB,2.6165E-01_JPRB,2.7115E-01_JPRB,2.6994E-01_JPRB,2.6086E-01_JPRB,2.4410E-01_JPRB,&
&2.1974E-01_JPRB,1.8329E-01_JPRB,1.1378E-01_JPRB/)
KAO( :, 1, 8, 8) = (/&
&1.6185E-01_JPRB,1.8253E-01_JPRB,1.8444E-01_JPRB,1.7949E-01_JPRB,1.7015E-01_JPRB,1.5690E-01_JPRB,&
&1.3935E-01_JPRB,1.1432E-01_JPRB,6.0540E-02_JPRB/)
KAO( :, 2, 8, 8) = (/&
&1.6964E-01_JPRB,1.9418E-01_JPRB,1.9717E-01_JPRB,1.9247E-01_JPRB,1.8312E-01_JPRB,1.6970E-01_JPRB,&
&1.5135E-01_JPRB,1.2506E-01_JPRB,6.8356E-02_JPRB/)
KAO( :, 3, 8, 8) = (/&
&1.7743E-01_JPRB,2.0616E-01_JPRB,2.1045E-01_JPRB,2.0623E-01_JPRB,1.9689E-01_JPRB,1.8297E-01_JPRB,&
&1.6334E-01_JPRB,1.3545E-01_JPRB,7.6236E-02_JPRB/)
KAO( :, 4, 8, 8) = (/&
&1.8525E-01_JPRB,2.1798E-01_JPRB,2.2355E-01_JPRB,2.2023E-01_JPRB,2.1094E-01_JPRB,1.9625E-01_JPRB,&
&1.7545E-01_JPRB,1.4584E-01_JPRB,8.4195E-02_JPRB/)
KAO( :, 5, 8, 8) = (/&
&1.9322E-01_JPRB,2.2966E-01_JPRB,2.3631E-01_JPRB,2.3389E-01_JPRB,2.2488E-01_JPRB,2.0966E-01_JPRB,&
&1.8787E-01_JPRB,1.5609E-01_JPRB,9.2157E-02_JPRB/)
KAO( :, 1, 9, 8) = (/&
&1.4213E-01_JPRB,1.5963E-01_JPRB,1.5968E-01_JPRB,1.5380E-01_JPRB,1.4472E-01_JPRB,1.3224E-01_JPRB,&
&1.1621E-01_JPRB,9.4456E-02_JPRB,4.8155E-02_JPRB/)
KAO( :, 2, 9, 8) = (/&
&1.4924E-01_JPRB,1.7020E-01_JPRB,1.7123E-01_JPRB,1.6570E-01_JPRB,1.5648E-01_JPRB,1.4372E-01_JPRB,&
&1.2686E-01_JPRB,1.0389E-01_JPRB,5.4797E-02_JPRB/)
KAO( :, 3, 9, 8) = (/&
&1.5626E-01_JPRB,1.8093E-01_JPRB,1.8312E-01_JPRB,1.7819E-01_JPRB,1.6892E-01_JPRB,1.5552E-01_JPRB,&
&1.3756E-01_JPRB,1.1314E-01_JPRB,6.1551E-02_JPRB/)
KAO( :, 4, 9, 8) = (/&
&1.6335E-01_JPRB,1.9168E-01_JPRB,1.9486E-01_JPRB,1.9059E-01_JPRB,1.8138E-01_JPRB,1.6740E-01_JPRB,&
&1.4849E-01_JPRB,1.2245E-01_JPRB,6.8420E-02_JPRB/)
KAO( :, 5, 9, 8) = (/&
&1.7076E-01_JPRB,2.0225E-01_JPRB,2.0643E-01_JPRB,2.0268E-01_JPRB,1.9350E-01_JPRB,1.7935E-01_JPRB,&
&1.5962E-01_JPRB,1.3184E-01_JPRB,7.5344E-02_JPRB/)
KAO( :, 1,10, 8) = (/&
&1.2689E-01_JPRB,1.4153E-01_JPRB,1.4002E-01_JPRB,1.3364E-01_JPRB,1.2448E-01_JPRB,1.1260E-01_JPRB,&
&9.7712E-02_JPRB,7.8252E-02_JPRB,4.4638E-02_JPRB/)
KAO( :, 2,10, 8) = (/&
&1.3357E-01_JPRB,1.5129E-01_JPRB,1.5077E-01_JPRB,1.4472E-01_JPRB,1.3525E-01_JPRB,1.2292E-01_JPRB,&
&1.0714E-01_JPRB,8.6493E-02_JPRB,5.1139E-02_JPRB/)
KAO( :, 3,10, 8) = (/&
&1.4033E-01_JPRB,1.6116E-01_JPRB,1.6169E-01_JPRB,1.5606E-01_JPRB,1.4653E-01_JPRB,1.3358E-01_JPRB,&
&1.1667E-01_JPRB,9.4648E-02_JPRB,5.7687E-02_JPRB/)
KAO( :, 4,10, 8) = (/&
&1.4713E-01_JPRB,1.7114E-01_JPRB,1.7244E-01_JPRB,1.6723E-01_JPRB,1.5766E-01_JPRB,1.4412E-01_JPRB,&
&1.2643E-01_JPRB,1.0289E-01_JPRB,6.4268E-02_JPRB/)
KAO( :, 5,10, 8) = (/&
&1.5435E-01_JPRB,1.8097E-01_JPRB,1.8303E-01_JPRB,1.7815E-01_JPRB,1.6844E-01_JPRB,1.5450E-01_JPRB,&
&1.3627E-01_JPRB,1.1126E-01_JPRB,7.0752E-02_JPRB/)
KAO( :, 1,11, 8) = (/&
&1.1735E-01_JPRB,1.3093E-01_JPRB,1.2881E-01_JPRB,1.2210E-01_JPRB,1.1270E-01_JPRB,1.0103E-01_JPRB,&
&8.6539E-02_JPRB,6.8130E-02_JPRB,4.9846E-02_JPRB/)
KAO( :, 2,11, 8) = (/&
&1.2384E-01_JPRB,1.4024E-01_JPRB,1.3893E-01_JPRB,1.3259E-01_JPRB,1.2292E-01_JPRB,1.1061E-01_JPRB,&
&9.5115E-02_JPRB,7.5252E-02_JPRB,5.6964E-02_JPRB/)
KAO( :, 3,11, 8) = (/&
&1.3035E-01_JPRB,1.4957E-01_JPRB,1.4914E-01_JPRB,1.4306E-01_JPRB,1.3321E-01_JPRB,1.2022E-01_JPRB,&
&1.0374E-01_JPRB,8.2465E-02_JPRB,6.4200E-02_JPRB/)
KAO( :, 4,11, 8) = (/&
&1.3725E-01_JPRB,1.5898E-01_JPRB,1.5927E-01_JPRB,1.5334E-01_JPRB,1.4326E-01_JPRB,1.2961E-01_JPRB,&
&1.1238E-01_JPRB,8.9805E-02_JPRB,7.1457E-02_JPRB/)
KAO( :, 5,11, 8) = (/&
&1.4463E-01_JPRB,1.6851E-01_JPRB,1.6933E-01_JPRB,1.6346E-01_JPRB,1.5308E-01_JPRB,1.3883E-01_JPRB,&
&1.2096E-01_JPRB,9.7193E-02_JPRB,7.8536E-02_JPRB/)
KAO( :, 1,12, 8) = (/&
&1.0640E-01_JPRB,1.1932E-01_JPRB,1.1727E-01_JPRB,1.1093E-01_JPRB,1.0195E-01_JPRB,9.0676E-02_JPRB,&
&7.6870E-02_JPRB,5.9379E-02_JPRB,5.1106E-02_JPRB/)
KAO( :, 2,12, 8) = (/&
&1.1251E-01_JPRB,1.2789E-01_JPRB,1.2658E-01_JPRB,1.2048E-01_JPRB,1.1127E-01_JPRB,9.9404E-02_JPRB,&
&8.4625E-02_JPRB,6.5652E-02_JPRB,5.8364E-02_JPRB/)
KAO( :, 3,12, 8) = (/&
&1.1894E-01_JPRB,1.3655E-01_JPRB,1.3586E-01_JPRB,1.2993E-01_JPRB,1.2048E-01_JPRB,1.0801E-01_JPRB,&
&9.2363E-02_JPRB,7.2052E-02_JPRB,6.5735E-02_JPRB/)
KAO( :, 4,12, 8) = (/&
&1.2590E-01_JPRB,1.4545E-01_JPRB,1.4519E-01_JPRB,1.3926E-01_JPRB,1.2958E-01_JPRB,1.1647E-01_JPRB,&
&9.9973E-02_JPRB,7.8534E-02_JPRB,7.3095E-02_JPRB/)
KAO( :, 5,12, 8) = (/&
&1.3337E-01_JPRB,1.5470E-01_JPRB,1.5466E-01_JPRB,1.4861E-01_JPRB,1.3857E-01_JPRB,1.2488E-01_JPRB,&
&1.0746E-01_JPRB,8.4929E-02_JPRB,8.0418E-02_JPRB/)
KAO( :, 1,13, 8) = (/&
&9.6972E-02_JPRB,1.0868E-01_JPRB,1.0670E-01_JPRB,1.0090E-01_JPRB,9.2463E-02_JPRB,8.1893E-02_JPRB,&
&6.8722E-02_JPRB,5.2187E-02_JPRB,4.8936E-02_JPRB/)
KAO( :, 2,13, 8) = (/&
&1.0286E-01_JPRB,1.1675E-01_JPRB,1.1538E-01_JPRB,1.0956E-01_JPRB,1.0086E-01_JPRB,8.9655E-02_JPRB,&
&7.5733E-02_JPRB,5.7797E-02_JPRB,5.5923E-02_JPRB/)
KAO( :, 3,13, 8) = (/&
&1.0928E-01_JPRB,1.2507E-01_JPRB,1.2410E-01_JPRB,1.1821E-01_JPRB,1.0914E-01_JPRB,9.7343E-02_JPRB,&
&8.2660E-02_JPRB,6.3457E-02_JPRB,6.3021E-02_JPRB/)
KAO( :, 4,13, 8) = (/&
&1.1629E-01_JPRB,1.3382E-01_JPRB,1.3304E-01_JPRB,1.2689E-01_JPRB,1.1743E-01_JPRB,1.0500E-01_JPRB,&
&8.9516E-02_JPRB,6.9087E-02_JPRB,7.0154E-02_JPRB/)
KAO( :, 5,13, 8) = (/&
&1.2379E-01_JPRB,1.4288E-01_JPRB,1.4218E-01_JPRB,1.3575E-01_JPRB,1.2584E-01_JPRB,1.1273E-01_JPRB,&
&9.6241E-02_JPRB,7.4622E-02_JPRB,7.7264E-02_JPRB/)


!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB12_A1
