!OCL SCALAR
SUBROUTINE RRTM_KGB9

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 9:  1180-1390 cm-1 (low - H2O,CH4; high - CH4)
!     Reformatted for F90 by JJMorcrette, ECMWF

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO9 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO, ABSN2OO
USE YOERRTA9 , ONLY : N2OREF  ,H2OREF  ,CH4REF     ,ETAREF     ,STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE
FRACREFBO( :) = (/&
!     From P = 0.071 mb.
    &0.20148601_JPRB,0.15252700_JPRB,0.13376500_JPRB,0.12184600_JPRB,&
    &0.10767800_JPRB,0.09307410_JPRB,0.07674570_JPRB,0.05876940_JPRB,&
    &0.04001480_JPRB,0.00424612_JPRB,0.00346896_JPRB,0.00269954_JPRB,&
    &0.00196864_JPRB,0.00122562_JPRB,0.00043628_JPRB,0.00004892_JPRB/)

N2OREF( :) = (/&
     &3.20000E-07_JPRB,3.20000E-07_JPRB,3.20000E-07_JPRB,3.20000E-07_JPRB,3.20000E-07_JPRB,&
     &3.19652E-07_JPRB,3.15324E-07_JPRB,3.03830E-07_JPRB,2.94221E-07_JPRB,2.84953E-07_JPRB,&
     &2.76714E-07_JPRB,2.64709E-07_JPRB,2.42847E-07_JPRB/)

H2OREF( :) = (/&
     &1.8759999E-02_JPRB, 1.2223309E-02_JPRB, 5.8908667E-03_JPRB, 2.7675382E-03_JPRB,  &
     &1.4065107E-03_JPRB, 7.5969833E-04_JPRB, 3.8875898E-04_JPRB, 1.6542293E-04_JPRB,  &
     &3.7189537E-05_JPRB, 7.4764857E-06_JPRB, 4.3081886E-06_JPRB, 3.3319423E-06_JPRB,  &
     &3.2039343E-06_JPRB/)

CH4REF( :) = (/&
     &1.7000001E-06_JPRB, 1.7000001E-06_JPRB, 1.6998713E-06_JPRB, 1.6904165E-06_JPRB,  &
     &1.6671424E-06_JPRB, 1.6350652E-06_JPRB, 1.6097551E-06_JPRB, 1.5590465E-06_JPRB,  &
     &1.5119849E-06_JPRB, 1.4741138E-06_JPRB, 1.4384609E-06_JPRB, 1.4002215E-06_JPRB,  &
     &1.3573376E-06_JPRB/)

ETAREF( :) = (/&
     &_ZERO_,0.125_JPRB,0.25_JPRB,0.375_JPRB,_HALF_,0.625_JPRB,0.75_JPRB,0.875_JPRB,0.96_JPRB,0.99_JPRB,_ONE_/)

ABSN2OO( :) = (/&
!     From P = 952.
     &3.26267E-01_JPRB,2.42869E-00_JPRB,1.15455E+01_JPRB,7.39478E-00_JPRB,&
     &5.16550E-00_JPRB,2.54474E-00_JPRB,3.53082E-00_JPRB,3.82278E-00_JPRB,&
     &1.81297E-00_JPRB,6.65313E-01_JPRB,1.23652E-01_JPRB,1.83895E-03_JPRB,&
     &1.70592E-03_JPRB,2.68434E-09_JPRB,_ZERO_,_ZERO_,&
!     From P = 620.
     &2.08632E-01_JPRB,1.11865E+00_JPRB,4.95975E+00_JPRB,8.10907E+00_JPRB,&
     &1.10408E+01_JPRB,5.45460E+00_JPRB,4.18611E+00_JPRB,3.53422E+00_JPRB,&
     &2.54164E+00_JPRB,3.65093E-01_JPRB,5.84480E-01_JPRB,2.26918E-01_JPRB,&
     &1.36230E-03_JPRB,5.54400E-10_JPRB,6.83703E-10_JPRB,_ZERO_,&
!     From P=313.
     &6.20022E-02_JPRB,2.69521E-01_JPRB,9.81928E-01_JPRB,1.65004E-00_JPRB,&
     &3.08089E-00_JPRB,5.38696E-00_JPRB,1.14600E+01_JPRB,2.41211E+01_JPRB,&
     &1.69655E+01_JPRB,1.37556E-00_JPRB,5.43254E-01_JPRB,3.52079E-01_JPRB,&
     &4.31888E-01_JPRB,4.82523E-06_JPRB,5.74747E-11_JPRB,_ZERO_/)

STRRAT = 21.6282_JPRB

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 11, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 1) = (/&
&1.8511E-03_JPRB,2.1684E-03_JPRB,1.9806E-03_JPRB,1.7402E-03_JPRB,1.4775E-03_JPRB,1.1966E-03_JPRB,&
&8.9433E-04_JPRB,5.6221E-04_JPRB,3.0428E-04_JPRB,1.8439E-04_JPRB,1.3102E-04_JPRB/)
KAO( :, 2, 1, 1) = (/&
&2.0894E-03_JPRB,2.4523E-03_JPRB,2.2500E-03_JPRB,1.9818E-03_JPRB,1.6875E-03_JPRB,1.3729E-03_JPRB,&
&1.0298E-03_JPRB,6.5344E-04_JPRB,3.5857E-04_JPRB,2.2082E-04_JPRB,1.5794E-04_JPRB/)
KAO( :, 3, 1, 1) = (/&
&2.3330E-03_JPRB,2.7449E-03_JPRB,2.5294E-03_JPRB,2.2345E-03_JPRB,1.9095E-03_JPRB,1.5602E-03_JPRB,&
&1.1757E-03_JPRB,7.5512E-04_JPRB,4.2015E-04_JPRB,2.6222E-04_JPRB,1.8993E-04_JPRB/)
KAO( :, 4, 1, 1) = (/&
&2.5835E-03_JPRB,3.0490E-03_JPRB,2.8221E-03_JPRB,2.5018E-03_JPRB,2.1465E-03_JPRB,1.7595E-03_JPRB,&
&1.3344E-03_JPRB,8.6724E-04_JPRB,4.8897E-04_JPRB,3.0971E-04_JPRB,2.2746E-04_JPRB/)
KAO( :, 5, 1, 1) = (/&
&2.8404E-03_JPRB,3.3655E-03_JPRB,3.1292E-03_JPRB,2.7851E-03_JPRB,2.3984E-03_JPRB,1.9730E-03_JPRB,&
&1.5065E-03_JPRB,9.9023E-04_JPRB,5.6589E-04_JPRB,3.6410E-04_JPRB,2.7116E-04_JPRB/)
KAO( :, 1, 2, 1) = (/&
&1.5469E-03_JPRB,1.8260E-03_JPRB,1.6779E-03_JPRB,1.4743E-03_JPRB,1.2523E-03_JPRB,1.0146E-03_JPRB,&
&7.5802E-04_JPRB,4.7362E-04_JPRB,2.5248E-04_JPRB,1.4960E-04_JPRB,1.0313E-04_JPRB/)
KAO( :, 2, 2, 1) = (/&
&1.7573E-03_JPRB,2.0750E-03_JPRB,1.9149E-03_JPRB,1.6867E-03_JPRB,1.4365E-03_JPRB,1.1680E-03_JPRB,&
&8.7632E-04_JPRB,5.5250E-04_JPRB,2.9879E-04_JPRB,1.7951E-04_JPRB,1.2466E-04_JPRB/)
KAO( :, 3, 2, 1) = (/&
&1.9736E-03_JPRB,2.3350E-03_JPRB,2.1627E-03_JPRB,1.9104E-03_JPRB,1.6322E-03_JPRB,1.3324E-03_JPRB,&
&1.0035E-03_JPRB,6.4000E-04_JPRB,3.5119E-04_JPRB,2.1343E-04_JPRB,1.4991E-04_JPRB/)
KAO( :, 4, 2, 1) = (/&
&2.1961E-03_JPRB,2.6057E-03_JPRB,2.4227E-03_JPRB,2.1470E-03_JPRB,1.8412E-03_JPRB,1.5084E-03_JPRB,&
&1.1417E-03_JPRB,7.3666E-04_JPRB,4.0980E-04_JPRB,2.5228E-04_JPRB,1.7955E-04_JPRB/)
KAO( :, 5, 2, 1) = (/&
&2.4226E-03_JPRB,2.8887E-03_JPRB,2.6975E-03_JPRB,2.3995E-03_JPRB,2.0641E-03_JPRB,1.6967E-03_JPRB,&
&1.2922E-03_JPRB,8.4309E-04_JPRB,4.7525E-04_JPRB,2.9676E-04_JPRB,2.1402E-04_JPRB/)
KAO( :, 1, 3, 1) = (/&
&1.2487E-03_JPRB,1.4859E-03_JPRB,1.3703E-03_JPRB,1.2034E-03_JPRB,1.0233E-03_JPRB,8.2934E-04_JPRB,&
&6.1870E-04_JPRB,3.8491E-04_JPRB,2.0061E-04_JPRB,1.1644E-04_JPRB,8.3034E-05_JPRB/)
KAO( :, 2, 3, 1) = (/&
&1.4306E-03_JPRB,1.7008E-03_JPRB,1.5762E-03_JPRB,1.3877E-03_JPRB,1.1829E-03_JPRB,9.6138E-04_JPRB,&
&7.2009E-04_JPRB,4.5115E-04_JPRB,2.3871E-04_JPRB,1.4060E-04_JPRB,1.0024E-04_JPRB/)
KAO( :, 3, 3, 1) = (/&
&1.6189E-03_JPRB,1.9278E-03_JPRB,1.7928E-03_JPRB,1.5827E-03_JPRB,1.3525E-03_JPRB,1.1028E-03_JPRB,&
&8.2939E-04_JPRB,5.2453E-04_JPRB,2.8190E-04_JPRB,1.6789E-04_JPRB,1.2022E-04_JPRB/)
KAO( :, 4, 3, 1) = (/&
&1.8135E-03_JPRB,2.1671E-03_JPRB,2.0211E-03_JPRB,1.7891E-03_JPRB,1.5341E-03_JPRB,1.2544E-03_JPRB,&
&9.4745E-04_JPRB,6.0589E-04_JPRB,3.3035E-04_JPRB,1.9886E-04_JPRB,1.4335E-04_JPRB/)
KAO( :, 5, 3, 1) = (/&
&2.0119E-03_JPRB,2.4174E-03_JPRB,2.2628E-03_JPRB,2.0104E-03_JPRB,1.7281E-03_JPRB,1.4171E-03_JPRB,&
&1.0763E-03_JPRB,6.9556E-04_JPRB,3.8485E-04_JPRB,2.3413E-04_JPRB,1.7025E-04_JPRB/)
KAO( :, 1, 4, 1) = (/&
&9.9332E-04_JPRB,1.1937E-03_JPRB,1.1041E-03_JPRB,9.6868E-04_JPRB,8.2360E-04_JPRB,6.6725E-04_JPRB,&
&4.9729E-04_JPRB,3.0812E-04_JPRB,1.5709E-04_JPRB,8.9177E-05_JPRB,7.0382E-05_JPRB/)
KAO( :, 2, 4, 1) = (/&
&1.1489E-03_JPRB,1.3782E-03_JPRB,1.2812E-03_JPRB,1.1272E-03_JPRB,9.6052E-04_JPRB,7.8016E-04_JPRB,&
&5.8305E-04_JPRB,3.6333E-04_JPRB,1.8801E-04_JPRB,1.0835E-04_JPRB,8.4949E-05_JPRB/)
KAO( :, 3, 4, 1) = (/&
&1.3111E-03_JPRB,1.5738E-03_JPRB,1.4685E-03_JPRB,1.2957E-03_JPRB,1.1067E-03_JPRB,9.0126E-04_JPRB,&
&6.7612E-04_JPRB,4.2453E-04_JPRB,2.2322E-04_JPRB,1.3010E-04_JPRB,1.0182E-04_JPRB/)
KAO( :, 4, 4, 1) = (/&
&1.4784E-03_JPRB,1.7816E-03_JPRB,1.6672E-03_JPRB,1.4760E-03_JPRB,1.2640E-03_JPRB,1.0311E-03_JPRB,&
&7.7663E-04_JPRB,4.9254E-04_JPRB,2.6274E-04_JPRB,1.5479E-04_JPRB,1.2151E-04_JPRB/)
KAO( :, 5, 4, 1) = (/&
&1.6498E-03_JPRB,2.0005E-03_JPRB,1.8776E-03_JPRB,1.6682E-03_JPRB,1.4321E-03_JPRB,1.1713E-03_JPRB,&
&8.8632E-04_JPRB,5.6750E-04_JPRB,3.0711E-04_JPRB,1.8305E-04_JPRB,1.4406E-04_JPRB/)
KAO( :, 1, 5, 1) = (/&
&7.8562E-04_JPRB,9.5485E-04_JPRB,8.8731E-04_JPRB,7.7760E-04_JPRB,6.6042E-04_JPRB,5.3465E-04_JPRB,&
&3.9818E-04_JPRB,2.4507E-04_JPRB,1.2280E-04_JPRB,6.8024E-05_JPRB,6.2892E-05_JPRB/)
KAO( :, 2, 5, 1) = (/&
&9.1788E-04_JPRB,1.1130E-03_JPRB,1.0387E-03_JPRB,9.1348E-04_JPRB,7.7739E-04_JPRB,6.3079E-04_JPRB,&
&4.7083E-04_JPRB,2.9144E-04_JPRB,1.4786E-04_JPRB,8.3150E-05_JPRB,7.5836E-05_JPRB/)
KAO( :, 3, 5, 1) = (/&
&1.0564E-03_JPRB,1.2815E-03_JPRB,1.1993E-03_JPRB,1.0584E-03_JPRB,9.0286E-04_JPRB,7.3472E-04_JPRB,&
&5.4988E-04_JPRB,3.4257E-04_JPRB,1.7646E-04_JPRB,1.0042E-04_JPRB,9.0784E-05_JPRB/)
KAO( :, 4, 5, 1) = (/&
&1.2000E-03_JPRB,1.4607E-03_JPRB,1.3706E-03_JPRB,1.2143E-03_JPRB,1.0385E-03_JPRB,8.4626E-04_JPRB,&
&6.3535E-04_JPRB,3.9924E-04_JPRB,2.0859E-04_JPRB,1.2014E-04_JPRB,1.0789E-04_JPRB/)
KAO( :, 5, 5, 1) = (/&
&1.3470E-03_JPRB,1.6493E-03_JPRB,1.5534E-03_JPRB,1.3815E-03_JPRB,1.1841E-03_JPRB,9.6670E-04_JPRB,&
&7.2902E-04_JPRB,4.6176E-04_JPRB,2.4472E-04_JPRB,1.4262E-04_JPRB,1.2760E-04_JPRB/)
KAO( :, 1, 6, 1) = (/&
&6.1309E-04_JPRB,7.5529E-04_JPRB,7.0573E-04_JPRB,6.1814E-04_JPRB,5.2423E-04_JPRB,4.2388E-04_JPRB,&
&3.1493E-04_JPRB,1.9253E-04_JPRB,9.5104E-05_JPRB,5.1400E-05_JPRB,5.8511E-05_JPRB/)
KAO( :, 2, 6, 1) = (/&
&7.2529E-04_JPRB,8.9038E-04_JPRB,8.3470E-04_JPRB,7.3394E-04_JPRB,6.2382E-04_JPRB,5.0540E-04_JPRB,&
&3.7640E-04_JPRB,2.3131E-04_JPRB,1.1537E-04_JPRB,6.3305E-05_JPRB,7.0591E-05_JPRB/)
KAO( :, 3, 6, 1) = (/&
&8.4334E-04_JPRB,1.0336E-03_JPRB,9.7184E-04_JPRB,8.5812E-04_JPRB,7.3092E-04_JPRB,5.9381E-04_JPRB,&
&4.4329E-04_JPRB,2.7409E-04_JPRB,1.3848E-04_JPRB,7.6884E-05_JPRB,8.4368E-05_JPRB/)
KAO( :, 4, 6, 1) = (/&
&9.6591E-04_JPRB,1.1861E-03_JPRB,1.1181E-03_JPRB,9.9183E-04_JPRB,8.4677E-04_JPRB,6.8969E-04_JPRB,&
&5.1579E-04_JPRB,3.2112E-04_JPRB,1.6446E-04_JPRB,9.2420E-05_JPRB,9.9996E-05_JPRB/)
KAO( :, 5, 6, 1) = (/&
&1.0919E-03_JPRB,1.3468E-03_JPRB,1.2743E-03_JPRB,1.1355E-03_JPRB,9.7181E-04_JPRB,7.9286E-04_JPRB,&
&5.9519E-04_JPRB,3.7314E-04_JPRB,1.9367E-04_JPRB,1.1025E-04_JPRB,1.1781E-04_JPRB/)
KAO( :, 1, 7, 1) = (/&
&4.7156E-04_JPRB,5.8937E-04_JPRB,5.5332E-04_JPRB,4.8469E-04_JPRB,4.1048E-04_JPRB,3.3155E-04_JPRB,&
&2.4554E-04_JPRB,1.4938E-04_JPRB,7.2895E-05_JPRB,3.8595E-05_JPRB,5.7264E-05_JPRB/)
KAO( :, 2, 7, 1) = (/&
&5.6495E-04_JPRB,7.0294E-04_JPRB,6.6167E-04_JPRB,5.8245E-04_JPRB,4.9439E-04_JPRB,4.0002E-04_JPRB,&
&2.9682E-04_JPRB,1.8140E-04_JPRB,8.9227E-05_JPRB,4.7916E-05_JPRB,6.9677E-05_JPRB/)
KAO( :, 3, 7, 1) = (/&
&6.6439E-04_JPRB,8.2373E-04_JPRB,7.7721E-04_JPRB,6.8744E-04_JPRB,5.8490E-04_JPRB,4.7448E-04_JPRB,&
&3.5318E-04_JPRB,2.1689E-04_JPRB,1.0783E-04_JPRB,5.8667E-05_JPRB,8.3618E-05_JPRB/)
KAO( :, 4, 7, 1) = (/&
&7.6901E-04_JPRB,9.5239E-04_JPRB,9.0133E-04_JPRB,8.0079E-04_JPRB,6.8276E-04_JPRB,5.5536E-04_JPRB,&
&4.1449E-04_JPRB,2.5602E-04_JPRB,1.2881E-04_JPRB,7.0934E-05_JPRB,9.9245E-05_JPRB/)
KAO( :, 5, 7, 1) = (/&
&8.7687E-04_JPRB,1.0882E-03_JPRB,1.0337E-03_JPRB,9.2277E-04_JPRB,7.8860E-04_JPRB,6.4298E-04_JPRB,&
&4.8152E-04_JPRB,2.9917E-04_JPRB,1.5235E-04_JPRB,8.4990E-05_JPRB,1.1668E-04_JPRB/)
KAO( :, 1, 8, 1) = (/&
&3.6149E-04_JPRB,4.5739E-04_JPRB,4.3172E-04_JPRB,3.7856E-04_JPRB,3.2005E-04_JPRB,2.5782E-04_JPRB,&
&1.9045E-04_JPRB,1.1541E-04_JPRB,5.5760E-05_JPRB,2.8968E-05_JPRB,6.3348E-05_JPRB/)
KAO( :, 2, 8, 1) = (/&
&4.3856E-04_JPRB,5.5284E-04_JPRB,5.2317E-04_JPRB,4.6128E-04_JPRB,3.9080E-04_JPRB,3.1525E-04_JPRB,&
&2.3332E-04_JPRB,1.4196E-04_JPRB,6.8893E-05_JPRB,3.6257E-05_JPRB,7.8227E-05_JPRB/)
KAO( :, 3, 8, 1) = (/&
&5.2180E-04_JPRB,6.5495E-04_JPRB,6.2122E-04_JPRB,5.5050E-04_JPRB,4.6739E-04_JPRB,3.7783E-04_JPRB,&
&2.8052E-04_JPRB,1.7141E-04_JPRB,8.3884E-05_JPRB,4.4746E-05_JPRB,9.4849E-05_JPRB/)
KAO( :, 4, 8, 1) = (/&
&6.1041E-04_JPRB,7.6428E-04_JPRB,7.2626E-04_JPRB,6.4667E-04_JPRB,5.5039E-04_JPRB,4.4616E-04_JPRB,&
&3.3220E-04_JPRB,2.0388E-04_JPRB,1.0087E-04_JPRB,5.4479E-05_JPRB,1.1299E-04_JPRB/)
KAO( :, 5, 8, 1) = (/&
&7.0263E-04_JPRB,8.7961E-04_JPRB,8.3866E-04_JPRB,7.5024E-04_JPRB,6.4012E-04_JPRB,5.2015E-04_JPRB,&
&3.8858E-04_JPRB,2.3987E-04_JPRB,1.1991E-04_JPRB,6.5600E-05_JPRB,1.3300E-04_JPRB/)
KAO( :, 1, 9, 1) = (/&
&2.7588E-04_JPRB,3.5363E-04_JPRB,3.3564E-04_JPRB,2.9442E-04_JPRB,2.4845E-04_JPRB,1.9944E-04_JPRB,&
&1.4687E-04_JPRB,8.8846E-05_JPRB,4.2564E-05_JPRB,2.1694E-05_JPRB,1.1635E-04_JPRB/)
KAO( :, 2, 9, 1) = (/&
&3.3926E-04_JPRB,4.3331E-04_JPRB,4.1256E-04_JPRB,3.6456E-04_JPRB,3.0818E-04_JPRB,2.4781E-04_JPRB,&
&1.8292E-04_JPRB,1.1098E-04_JPRB,5.3248E-05_JPRB,2.7395E-05_JPRB,1.4478E-04_JPRB/)
KAO( :, 3, 9, 1) = (/&
&4.0867E-04_JPRB,5.1901E-04_JPRB,4.9554E-04_JPRB,4.4073E-04_JPRB,3.7338E-04_JPRB,3.0096E-04_JPRB,&
&2.2284E-04_JPRB,1.3558E-04_JPRB,6.5394E-05_JPRB,3.4106E-05_JPRB,1.7665E-04_JPRB/)
KAO( :, 4, 9, 1) = (/&
&4.8311E-04_JPRB,6.1155E-04_JPRB,5.8496E-04_JPRB,5.2319E-04_JPRB,4.4421E-04_JPRB,3.5901E-04_JPRB,&
&2.6668E-04_JPRB,1.6266E-04_JPRB,7.9185E-05_JPRB,4.1808E-05_JPRB,2.1187E-04_JPRB/)
KAO( :, 5, 9, 1) = (/&
&5.6145E-04_JPRB,7.0981E-04_JPRB,6.8093E-04_JPRB,6.1164E-04_JPRB,5.2090E-04_JPRB,4.2218E-04_JPRB,&
&3.1451E-04_JPRB,1.9257E-04_JPRB,9.4690E-05_JPRB,5.0644E-05_JPRB,2.5097E-04_JPRB/)
KAO( :, 1,10, 1) = (/&
&2.1325E-04_JPRB,2.7761E-04_JPRB,2.6556E-04_JPRB,2.3335E-04_JPRB,1.9651E-04_JPRB,1.5718E-04_JPRB,&
&1.1525E-04_JPRB,6.9475E-05_JPRB,3.3064E-05_JPRB,1.6594E-05_JPRB,2.6093E-04_JPRB/)
KAO( :, 2,10, 1) = (/&
&2.6523E-04_JPRB,3.4415E-04_JPRB,3.3059E-04_JPRB,2.9327E-04_JPRB,2.4721E-04_JPRB,1.9814E-04_JPRB,&
&1.4562E-04_JPRB,8.8015E-05_JPRB,4.1956E-05_JPRB,2.1115E-05_JPRB,3.2387E-04_JPRB/)
KAO( :, 3,10, 1) = (/&
&3.2298E-04_JPRB,4.1660E-04_JPRB,4.0088E-04_JPRB,3.5836E-04_JPRB,3.0264E-04_JPRB,2.4324E-04_JPRB,&
&1.7951E-04_JPRB,1.0893E-04_JPRB,5.2077E-05_JPRB,2.6475E-05_JPRB,3.9665E-04_JPRB/)
KAO( :, 4,10, 1) = (/&
&3.8555E-04_JPRB,4.9515E-04_JPRB,4.7688E-04_JPRB,4.2876E-04_JPRB,3.6342E-04_JPRB,2.9294E-04_JPRB,&
&2.1704E-04_JPRB,1.3203E-04_JPRB,6.3508E-05_JPRB,3.2669E-05_JPRB,4.7888E-04_JPRB/)
KAO( :, 5,10, 1) = (/&
&4.5214E-04_JPRB,5.7861E-04_JPRB,5.5869E-04_JPRB,5.0469E-04_JPRB,4.2960E-04_JPRB,3.4738E-04_JPRB,&
&2.5818E-04_JPRB,1.5755E-04_JPRB,7.6353E-05_JPRB,3.9767E-05_JPRB,5.6953E-04_JPRB/)
KAO( :, 1,11, 1) = (/&
&1.8263E-04_JPRB,2.4132E-04_JPRB,2.3375E-04_JPRB,2.0689E-04_JPRB,1.7392E-04_JPRB,1.3885E-04_JPRB,&
&1.0153E-04_JPRB,6.1012E-05_JPRB,2.8844E-05_JPRB,1.4318E-05_JPRB,3.1500E-04_JPRB/)
KAO( :, 2,11, 1) = (/&
&2.2729E-04_JPRB,2.9882E-04_JPRB,2.9035E-04_JPRB,2.5993E-04_JPRB,2.1873E-04_JPRB,1.7499E-04_JPRB,&
&1.2837E-04_JPRB,7.7411E-05_JPRB,3.6724E-05_JPRB,1.8248E-05_JPRB,3.9075E-04_JPRB/)
KAO( :, 3,11, 1) = (/&
&2.7702E-04_JPRB,3.6186E-04_JPRB,3.5142E-04_JPRB,3.1724E-04_JPRB,2.6804E-04_JPRB,2.1505E-04_JPRB,&
&1.5840E-04_JPRB,9.5897E-05_JPRB,4.5698E-05_JPRB,2.2869E-05_JPRB,4.7807E-04_JPRB/)
KAO( :, 4,11, 1) = (/&
&3.3090E-04_JPRB,4.2990E-04_JPRB,4.1786E-04_JPRB,3.7887E-04_JPRB,3.2210E-04_JPRB,2.5914E-04_JPRB,&
&1.9166E-04_JPRB,1.1648E-04_JPRB,5.5756E-05_JPRB,2.8227E-05_JPRB,5.7397E-04_JPRB/)
KAO( :, 5,11, 1) = (/&
&3.8797E-04_JPRB,5.0222E-04_JPRB,4.8941E-04_JPRB,4.4563E-04_JPRB,3.8069E-04_JPRB,3.0738E-04_JPRB,&
&2.2816E-04_JPRB,1.3917E-04_JPRB,6.7021E-05_JPRB,3.4339E-05_JPRB,6.7669E-04_JPRB/)
KAO( :, 1,12, 1) = (/&
&1.5441E-04_JPRB,2.0564E-04_JPRB,2.0096E-04_JPRB,1.7923E-04_JPRB,1.5061E-04_JPRB,1.2020E-04_JPRB,&
&8.7841E-05_JPRB,5.2718E-05_JPRB,2.4841E-05_JPRB,1.2247E-05_JPRB,3.0779E-04_JPRB/)
KAO( :, 2,12, 1) = (/&
&1.9212E-04_JPRB,2.5449E-04_JPRB,2.4895E-04_JPRB,2.2471E-04_JPRB,1.8931E-04_JPRB,1.5143E-04_JPRB,&
&1.1103E-04_JPRB,6.6933E-05_JPRB,3.1660E-05_JPRB,1.5617E-05_JPRB,3.8209E-04_JPRB/)
KAO( :, 3,12, 1) = (/&
&2.3412E-04_JPRB,3.0815E-04_JPRB,3.0111E-04_JPRB,2.7354E-04_JPRB,2.3196E-04_JPRB,1.8605E-04_JPRB,&
&1.3699E-04_JPRB,8.2969E-05_JPRB,3.9466E-05_JPRB,1.9595E-05_JPRB,4.6727E-04_JPRB/)
KAO( :, 4,12, 1) = (/&
&2.7956E-04_JPRB,3.6583E-04_JPRB,3.5793E-04_JPRB,3.2668E-04_JPRB,2.7866E-04_JPRB,2.2413E-04_JPRB,&
&1.6571E-04_JPRB,1.0083E-04_JPRB,4.8187E-05_JPRB,2.4182E-05_JPRB,5.5911E-04_JPRB/)
KAO( :, 5,12, 1) = (/&
&3.2770E-04_JPRB,4.2716E-04_JPRB,4.1907E-04_JPRB,3.8390E-04_JPRB,3.2941E-04_JPRB,2.6578E-04_JPRB,&
&1.9722E-04_JPRB,1.2047E-04_JPRB,5.7910E-05_JPRB,2.9402E-05_JPRB,6.5729E-04_JPRB/)
KAO( :, 1,13, 1) = (/&
&1.2926E-04_JPRB,1.7285E-04_JPRB,1.6977E-04_JPRB,1.5243E-04_JPRB,1.2815E-04_JPRB,1.0230E-04_JPRB,&
&7.4794E-05_JPRB,4.4876E-05_JPRB,2.1143E-05_JPRB,1.0395E-05_JPRB,2.5481E-04_JPRB/)
KAO( :, 2,13, 1) = (/&
&1.6076E-04_JPRB,2.1391E-04_JPRB,2.1001E-04_JPRB,1.9062E-04_JPRB,1.6104E-04_JPRB,1.2883E-04_JPRB,&
&9.4499E-05_JPRB,5.6968E-05_JPRB,2.6983E-05_JPRB,1.3259E-05_JPRB,3.1628E-04_JPRB/)
KAO( :, 3,13, 1) = (/&
&1.9591E-04_JPRB,2.5905E-04_JPRB,2.5408E-04_JPRB,2.3203E-04_JPRB,1.9732E-04_JPRB,1.5826E-04_JPRB,&
&1.1655E-04_JPRB,7.0656E-05_JPRB,3.3658E-05_JPRB,1.6638E-05_JPRB,3.8652E-04_JPRB/)
KAO( :, 4,13, 1) = (/&
&2.3390E-04_JPRB,3.0751E-04_JPRB,3.0205E-04_JPRB,2.7698E-04_JPRB,2.3712E-04_JPRB,1.9078E-04_JPRB,&
&1.4104E-04_JPRB,8.5929E-05_JPRB,4.1109E-05_JPRB,2.0532E-05_JPRB,4.6199E-04_JPRB/)
KAO( :, 5,13, 1) = (/&
&2.7408E-04_JPRB,3.5916E-04_JPRB,3.5371E-04_JPRB,3.2549E-04_JPRB,2.8046E-04_JPRB,2.2630E-04_JPRB,&
&1.6790E-04_JPRB,1.0268E-04_JPRB,4.9402E-05_JPRB,2.4960E-05_JPRB,5.4289E-04_JPRB/)
KAO( :, 1, 1, 2) = (/&
&6.0407E-03_JPRB,7.8065E-03_JPRB,8.1846E-03_JPRB,7.8906E-03_JPRB,7.1910E-03_JPRB,6.1108E-03_JPRB,&
&4.6908E-03_JPRB,3.0070E-03_JPRB,1.6029E-03_JPRB,8.9663E-04_JPRB,5.4161E-04_JPRB/)
KAO( :, 2, 1, 2) = (/&
&6.8195E-03_JPRB,8.6717E-03_JPRB,9.0298E-03_JPRB,8.7022E-03_JPRB,7.9330E-03_JPRB,6.7597E-03_JPRB,&
&5.2275E-03_JPRB,3.3989E-03_JPRB,1.8520E-03_JPRB,1.0477E-03_JPRB,6.3833E-04_JPRB/)
KAO( :, 3, 1, 2) = (/&
&7.5788E-03_JPRB,9.5388E-03_JPRB,9.9036E-03_JPRB,9.5604E-03_JPRB,8.7254E-03_JPRB,7.4504E-03_JPRB,&
&5.8064E-03_JPRB,3.8251E-03_JPRB,2.1238E-03_JPRB,1.2161E-03_JPRB,7.5231E-04_JPRB/)
KAO( :, 4, 1, 2) = (/&
&8.3303E-03_JPRB,1.0419E-02_JPRB,1.0813E-02_JPRB,1.0461E-02_JPRB,9.5556E-03_JPRB,8.1956E-03_JPRB,&
&6.4324E-03_JPRB,4.2921E-03_JPRB,2.4115E-03_JPRB,1.4052E-03_JPRB,8.8294E-04_JPRB/)
KAO( :, 5, 1, 2) = (/&
&9.0559E-03_JPRB,1.1320E-02_JPRB,1.1753E-02_JPRB,1.1384E-02_JPRB,1.0421E-02_JPRB,8.9932E-03_JPRB,&
&7.1094E-03_JPRB,4.8020E-03_JPRB,2.7233E-03_JPRB,1.6150E-03_JPRB,1.0321E-03_JPRB/)
KAO( :, 1, 2, 2) = (/&
&5.2124E-03_JPRB,6.6819E-03_JPRB,6.9789E-03_JPRB,6.7465E-03_JPRB,6.1674E-03_JPRB,5.2549E-03_JPRB,&
&4.0193E-03_JPRB,2.5539E-03_JPRB,1.3468E-03_JPRB,7.4621E-04_JPRB,4.4731E-04_JPRB/)
KAO( :, 2, 2, 2) = (/&
&5.8769E-03_JPRB,7.4300E-03_JPRB,7.7105E-03_JPRB,7.4546E-03_JPRB,6.8169E-03_JPRB,5.8241E-03_JPRB,&
&4.4832E-03_JPRB,2.8884E-03_JPRB,1.5578E-03_JPRB,8.7448E-04_JPRB,5.2849E-04_JPRB/)
KAO( :, 3, 2, 2) = (/&
&6.5337E-03_JPRB,8.1860E-03_JPRB,8.4759E-03_JPRB,8.2057E-03_JPRB,7.5067E-03_JPRB,6.4273E-03_JPRB,&
&4.9857E-03_JPRB,3.2553E-03_JPRB,1.7880E-03_JPRB,1.0185E-03_JPRB,6.2321E-04_JPRB/)
KAO( :, 4, 2, 2) = (/&
&7.1816E-03_JPRB,8.9552E-03_JPRB,9.2749E-03_JPRB,8.9993E-03_JPRB,8.2303E-03_JPRB,7.0662E-03_JPRB,&
&5.5323E-03_JPRB,3.6583E-03_JPRB,2.0367E-03_JPRB,1.1804E-03_JPRB,7.3231E-04_JPRB/)
KAO( :, 5, 2, 2) = (/&
&7.8051E-03_JPRB,9.7506E-03_JPRB,1.0101E-02_JPRB,9.8071E-03_JPRB,8.9873E-03_JPRB,7.7508E-03_JPRB,&
&6.1243E-03_JPRB,4.1022E-03_JPRB,2.3063E-03_JPRB,1.3585E-03_JPRB,8.5647E-04_JPRB/)
KAO( :, 1, 3, 2) = (/&
&4.3523E-03_JPRB,5.5520E-03_JPRB,5.7775E-03_JPRB,5.5913E-03_JPRB,5.1223E-03_JPRB,4.3826E-03_JPRB,&
&3.3610E-03_JPRB,2.1161E-03_JPRB,1.0951E-03_JPRB,5.9556E-04_JPRB,3.7857E-04_JPRB/)
KAO( :, 2, 3, 2) = (/&
&4.9209E-03_JPRB,6.2002E-03_JPRB,6.4082E-03_JPRB,6.1965E-03_JPRB,5.6752E-03_JPRB,4.8744E-03_JPRB,&
&3.7636E-03_JPRB,2.3985E-03_JPRB,1.2700E-03_JPRB,7.0291E-04_JPRB,4.5096E-04_JPRB/)
KAO( :, 3, 3, 2) = (/&
&5.4868E-03_JPRB,6.8502E-03_JPRB,7.0667E-03_JPRB,6.8427E-03_JPRB,6.2712E-03_JPRB,5.3957E-03_JPRB,&
&4.1940E-03_JPRB,2.7077E-03_JPRB,1.4615E-03_JPRB,8.2150E-04_JPRB,5.3286E-04_JPRB/)
KAO( :, 4, 3, 2) = (/&
&6.0417E-03_JPRB,7.5160E-03_JPRB,7.7553E-03_JPRB,7.5242E-03_JPRB,6.9056E-03_JPRB,5.9509E-03_JPRB,&
&4.6578E-03_JPRB,3.0477E-03_JPRB,1.6703E-03_JPRB,9.5611E-04_JPRB,6.2579E-04_JPRB/)
KAO( :, 5, 3, 2) = (/&
&6.5818E-03_JPRB,8.2045E-03_JPRB,8.4687E-03_JPRB,8.2290E-03_JPRB,7.5712E-03_JPRB,6.5448E-03_JPRB,&
&5.1618E-03_JPRB,3.4239E-03_JPRB,1.8984E-03_JPRB,1.1049E-03_JPRB,7.3100E-04_JPRB/)
KAO( :, 1, 4, 2) = (/&
&3.6037E-03_JPRB,4.5619E-03_JPRB,4.7284E-03_JPRB,4.5758E-03_JPRB,4.1942E-03_JPRB,3.5992E-03_JPRB,&
&2.7695E-03_JPRB,1.7380E-03_JPRB,8.8220E-04_JPRB,4.6885E-04_JPRB,3.3625E-04_JPRB/)
KAO( :, 2, 4, 2) = (/&
&4.0887E-03_JPRB,5.1148E-03_JPRB,5.2710E-03_JPRB,5.0898E-03_JPRB,4.6632E-03_JPRB,4.0157E-03_JPRB,&
&3.1155E-03_JPRB,1.9801E-03_JPRB,1.0256E-03_JPRB,5.5681E-04_JPRB,4.0363E-04_JPRB/)
KAO( :, 3, 4, 2) = (/&
&4.5729E-03_JPRB,5.6722E-03_JPRB,5.8309E-03_JPRB,5.6384E-03_JPRB,5.1725E-03_JPRB,4.4617E-03_JPRB,&
&3.4837E-03_JPRB,2.2420E-03_JPRB,1.1837E-03_JPRB,6.5451E-04_JPRB,4.7814E-04_JPRB/)
KAO( :, 4, 4, 2) = (/&
&5.0500E-03_JPRB,6.2435E-03_JPRB,6.4200E-03_JPRB,6.2178E-03_JPRB,5.7168E-03_JPRB,4.9415E-03_JPRB,&
&3.8793E-03_JPRB,2.5280E-03_JPRB,1.3568E-03_JPRB,7.6386E-04_JPRB,5.6139E-04_JPRB/)
KAO( :, 5, 4, 2) = (/&
&5.5166E-03_JPRB,6.8327E-03_JPRB,7.0292E-03_JPRB,6.8237E-03_JPRB,6.2950E-03_JPRB,5.4568E-03_JPRB,&
&4.3128E-03_JPRB,2.8421E-03_JPRB,1.5485E-03_JPRB,8.8605E-04_JPRB,6.5402E-04_JPRB/)
KAO( :, 1, 5, 2) = (/&
&2.9853E-03_JPRB,3.7407E-03_JPRB,3.8556E-03_JPRB,3.7312E-03_JPRB,3.4190E-03_JPRB,2.9428E-03_JPRB,&
&2.2723E-03_JPRB,1.4198E-03_JPRB,7.1091E-04_JPRB,3.6855E-04_JPRB,3.1611E-04_JPRB/)
KAO( :, 2, 5, 2) = (/&
&3.4022E-03_JPRB,4.2141E-03_JPRB,4.3188E-03_JPRB,4.1657E-03_JPRB,3.8152E-03_JPRB,3.2922E-03_JPRB,&
&2.5629E-03_JPRB,1.6244E-03_JPRB,8.2914E-04_JPRB,4.3956E-04_JPRB,3.7920E-04_JPRB/)
KAO( :, 3, 5, 2) = (/&
&3.8163E-03_JPRB,4.6908E-03_JPRB,4.7976E-03_JPRB,4.6281E-03_JPRB,4.2450E-03_JPRB,3.6719E-03_JPRB,&
&2.8734E-03_JPRB,1.8464E-03_JPRB,9.6023E-04_JPRB,5.1918E-04_JPRB,4.5044E-04_JPRB/)
KAO( :, 4, 5, 2) = (/&
&4.2238E-03_JPRB,5.1812E-03_JPRB,5.2987E-03_JPRB,5.1187E-03_JPRB,4.7071E-03_JPRB,4.0810E-03_JPRB,&
&3.2111E-03_JPRB,2.0883E-03_JPRB,1.1042E-03_JPRB,6.0901E-04_JPRB,5.3057E-04_JPRB/)
KAO( :, 5, 5, 2) = (/&
&4.6242E-03_JPRB,5.6849E-03_JPRB,5.8163E-03_JPRB,5.6316E-03_JPRB,5.2005E-03_JPRB,4.5233E-03_JPRB,&
&3.5780E-03_JPRB,2.3536E-03_JPRB,1.2639E-03_JPRB,7.0822E-04_JPRB,6.1748E-04_JPRB/)
KAO( :, 1, 6, 2) = (/&
&2.4498E-03_JPRB,3.0475E-03_JPRB,3.1220E-03_JPRB,3.0196E-03_JPRB,2.7652E-03_JPRB,2.3889E-03_JPRB,&
&1.8491E-03_JPRB,1.1489E-03_JPRB,5.6714E-04_JPRB,2.8783E-04_JPRB,3.1080E-04_JPRB/)
KAO( :, 2, 6, 2) = (/&
&2.8080E-03_JPRB,3.4520E-03_JPRB,3.5157E-03_JPRB,3.3870E-03_JPRB,3.0980E-03_JPRB,2.6793E-03_JPRB,&
&2.0903E-03_JPRB,1.3197E-03_JPRB,6.6501E-04_JPRB,3.4472E-04_JPRB,3.7051E-04_JPRB/)
KAO( :, 3, 6, 2) = (/&
&3.1640E-03_JPRB,3.8601E-03_JPRB,3.9229E-03_JPRB,3.7774E-03_JPRB,3.4589E-03_JPRB,2.9977E-03_JPRB,&
&2.3510E-03_JPRB,1.5040E-03_JPRB,7.7398E-04_JPRB,4.0896E-04_JPRB,4.3796E-04_JPRB/)
KAO( :, 4, 6, 2) = (/&
&3.5132E-03_JPRB,4.2794E-03_JPRB,4.3478E-03_JPRB,4.1882E-03_JPRB,3.8474E-03_JPRB,3.3403E-03_JPRB,&
&2.6340E-03_JPRB,1.7060E-03_JPRB,8.9431E-04_JPRB,4.8188E-04_JPRB,5.1446E-04_JPRB/)
KAO( :, 5, 6, 2) = (/&
&3.8604E-03_JPRB,4.7099E-03_JPRB,4.7886E-03_JPRB,4.6205E-03_JPRB,4.2616E-03_JPRB,3.7139E-03_JPRB,&
&2.9438E-03_JPRB,1.9283E-03_JPRB,1.0272E-03_JPRB,5.6324E-04_JPRB,5.9978E-04_JPRB/)
KAO( :, 1, 7, 2) = (/&
&1.9828E-03_JPRB,2.4555E-03_JPRB,2.5089E-03_JPRB,2.4265E-03_JPRB,2.2222E-03_JPRB,1.9219E-03_JPRB,&
&1.4917E-03_JPRB,9.2169E-04_JPRB,4.4935E-04_JPRB,2.2355E-04_JPRB,3.2905E-04_JPRB/)
KAO( :, 2, 7, 2) = (/&
&2.2898E-03_JPRB,2.8015E-03_JPRB,2.8404E-03_JPRB,2.7343E-03_JPRB,2.4995E-03_JPRB,2.1638E-03_JPRB,&
&1.6905E-03_JPRB,1.0629E-03_JPRB,5.2977E-04_JPRB,2.6953E-04_JPRB,3.8642E-04_JPRB/)
KAO( :, 3, 7, 2) = (/&
&2.5950E-03_JPRB,3.1495E-03_JPRB,3.1847E-03_JPRB,3.0608E-03_JPRB,2.7988E-03_JPRB,2.4271E-03_JPRB,&
&1.9063E-03_JPRB,1.2157E-03_JPRB,6.1889E-04_JPRB,3.2121E-04_JPRB,4.5238E-04_JPRB/)
KAO( :, 4, 7, 2) = (/&
&2.8946E-03_JPRB,3.5066E-03_JPRB,3.5426E-03_JPRB,3.4040E-03_JPRB,3.1227E-03_JPRB,2.7135E-03_JPRB,&
&2.1417E-03_JPRB,1.3825E-03_JPRB,7.1739E-04_JPRB,3.7957E-04_JPRB,5.2784E-04_JPRB/)
KAO( :, 5, 7, 2) = (/&
&3.1931E-03_JPRB,3.8740E-03_JPRB,3.9151E-03_JPRB,3.7654E-03_JPRB,3.4684E-03_JPRB,3.0255E-03_JPRB,&
&2.3992E-03_JPRB,1.5660E-03_JPRB,8.2652E-04_JPRB,4.4537E-04_JPRB,6.1466E-04_JPRB/)
KAO( :, 1, 8, 2) = (/&
&1.5989E-03_JPRB,1.9702E-03_JPRB,2.0115E-03_JPRB,1.9470E-03_JPRB,1.7844E-03_JPRB,1.5432E-03_JPRB,&
&1.1995E-03_JPRB,7.3709E-04_JPRB,3.5460E-04_JPRB,1.7239E-04_JPRB,4.0077E-04_JPRB/)
KAO( :, 2, 8, 2) = (/&
&1.8612E-03_JPRB,2.2667E-03_JPRB,2.2904E-03_JPRB,2.2044E-03_JPRB,2.0147E-03_JPRB,1.7439E-03_JPRB,&
&1.3635E-03_JPRB,8.5344E-04_JPRB,4.2074E-04_JPRB,2.0967E-04_JPRB,4.6582E-04_JPRB/)
KAO( :, 3, 8, 2) = (/&
&2.1244E-03_JPRB,2.5624E-03_JPRB,2.5789E-03_JPRB,2.4755E-03_JPRB,2.2630E-03_JPRB,1.9622E-03_JPRB,&
&1.5425E-03_JPRB,9.7987E-04_JPRB,4.9319E-04_JPRB,2.5142E-04_JPRB,5.4055E-04_JPRB/)
KAO( :, 4, 8, 2) = (/&
&2.3819E-03_JPRB,2.8649E-03_JPRB,2.8813E-03_JPRB,2.7618E-03_JPRB,2.5306E-03_JPRB,2.2005E-03_JPRB,&
&1.7382E-03_JPRB,1.1179E-03_JPRB,5.7326E-04_JPRB,2.9833E-04_JPRB,6.2468E-04_JPRB/)
KAO( :, 5, 8, 2) = (/&
&2.6384E-03_JPRB,3.1771E-03_JPRB,3.1953E-03_JPRB,3.0634E-03_JPRB,2.8174E-03_JPRB,2.4583E-03_JPRB,&
&1.9520E-03_JPRB,1.2696E-03_JPRB,6.6233E-04_JPRB,3.5121E-04_JPRB,7.1932E-04_JPRB/)
KAO( :, 1, 9, 2) = (/&
&1.2874E-03_JPRB,1.5807E-03_JPRB,1.6105E-03_JPRB,1.5596E-03_JPRB,1.4331E-03_JPRB,1.2409E-03_JPRB,&
&9.6467E-04_JPRB,5.8855E-04_JPRB,2.7878E-04_JPRB,1.3223E-04_JPRB,7.1624E-04_JPRB/)
KAO( :, 2, 9, 2) = (/&
&1.5123E-03_JPRB,1.8336E-03_JPRB,1.8477E-03_JPRB,1.7758E-03_JPRB,1.6249E-03_JPRB,1.4066E-03_JPRB,&
&1.0996E-03_JPRB,6.8448E-04_JPRB,3.3322E-04_JPRB,1.6247E-04_JPRB,8.2651E-04_JPRB/)
KAO( :, 3, 9, 2) = (/&
&1.7405E-03_JPRB,2.0860E-03_JPRB,2.0902E-03_JPRB,2.0023E-03_JPRB,1.8310E-03_JPRB,1.5864E-03_JPRB,&
&1.2475E-03_JPRB,7.8935E-04_JPRB,3.9239E-04_JPRB,1.9609E-04_JPRB,9.5177E-04_JPRB/)
KAO( :, 4, 9, 2) = (/&
&1.9645E-03_JPRB,2.3442E-03_JPRB,2.3456E-03_JPRB,2.2427E-03_JPRB,2.0525E-03_JPRB,1.7831E-03_JPRB,&
&1.4096E-03_JPRB,9.0343E-04_JPRB,4.5751E-04_JPRB,2.3374E-04_JPRB,1.0933E-03_JPRB/)
KAO( :, 5, 9, 2) = (/&
&2.1858E-03_JPRB,2.6097E-03_JPRB,2.6113E-03_JPRB,2.4953E-03_JPRB,2.2897E-03_JPRB,1.9950E-03_JPRB,&
&1.5860E-03_JPRB,1.0288E-03_JPRB,5.2969E-04_JPRB,2.7603E-04_JPRB,1.2508E-03_JPRB/)
KAO( :, 1,10, 2) = (/&
&1.0529E-03_JPRB,1.2869E-03_JPRB,1.3057E-03_JPRB,1.2641E-03_JPRB,1.1629E-03_JPRB,1.0080E-03_JPRB,&
&7.8495E-04_JPRB,4.7620E-04_JPRB,2.2170E-04_JPRB,1.0270E-04_JPRB,1.3580E-03_JPRB/)
KAO( :, 2,10, 2) = (/&
&1.2490E-03_JPRB,1.5074E-03_JPRB,1.5131E-03_JPRB,1.4495E-03_JPRB,1.3257E-03_JPRB,1.1471E-03_JPRB,&
&8.9825E-04_JPRB,5.5593E-04_JPRB,2.6681E-04_JPRB,1.2750E-04_JPRB,1.5971E-03_JPRB/)
KAO( :, 3,10, 2) = (/&
&1.4492E-03_JPRB,1.7260E-03_JPRB,1.7215E-03_JPRB,1.6426E-03_JPRB,1.5005E-03_JPRB,1.2985E-03_JPRB,&
&1.0216E-03_JPRB,6.4239E-04_JPRB,3.1568E-04_JPRB,1.5479E-04_JPRB,1.8667E-03_JPRB/)
KAO( :, 4,10, 2) = (/&
&1.6458E-03_JPRB,1.9481E-03_JPRB,1.9385E-03_JPRB,1.8468E-03_JPRB,1.6872E-03_JPRB,1.4625E-03_JPRB,&
&1.1568E-03_JPRB,7.3723E-04_JPRB,3.6917E-04_JPRB,1.8512E-04_JPRB,2.1592E-03_JPRB/)
KAO( :, 5,10, 2) = (/&
&1.8388E-03_JPRB,2.1768E-03_JPRB,2.1658E-03_JPRB,2.0613E-03_JPRB,1.8866E-03_JPRB,1.6398E-03_JPRB,&
&1.3041E-03_JPRB,8.4131E-04_JPRB,4.2827E-04_JPRB,2.1913E-04_JPRB,2.4697E-03_JPRB/)
KAO( :, 1,11, 2) = (/&
&9.3652E-04_JPRB,1.1385E-03_JPRB,1.1471E-03_JPRB,1.1044E-03_JPRB,1.0133E-03_JPRB,8.7645E-04_JPRB,&
&6.8412E-04_JPRB,4.1724E-04_JPRB,1.9356E-04_JPRB,8.8827E-05_JPRB,1.5807E-03_JPRB/)
KAO( :, 2,11, 2) = (/&
&1.1100E-03_JPRB,1.3322E-03_JPRB,1.3282E-03_JPRB,1.2667E-03_JPRB,1.1577E-03_JPRB,1.0002E-03_JPRB,&
&7.8407E-04_JPRB,4.8629E-04_JPRB,2.3224E-04_JPRB,1.1007E-04_JPRB,1.8547E-03_JPRB/)
KAO( :, 3,11, 2) = (/&
&1.2856E-03_JPRB,1.5232E-03_JPRB,1.5121E-03_JPRB,1.4368E-03_JPRB,1.3117E-03_JPRB,1.1334E-03_JPRB,&
&8.9329E-04_JPRB,5.6169E-04_JPRB,2.7435E-04_JPRB,1.3331E-04_JPRB,2.1559E-03_JPRB/)
KAO( :, 4,11, 2) = (/&
&1.4549E-03_JPRB,1.7175E-03_JPRB,1.7035E-03_JPRB,1.6171E-03_JPRB,1.4759E-03_JPRB,1.2781E-03_JPRB,&
&1.0119E-03_JPRB,6.4442E-04_JPRB,3.2046E-04_JPRB,1.5895E-04_JPRB,2.4834E-03_JPRB/)
KAO( :, 5,11, 2) = (/&
&1.6224E-03_JPRB,1.9187E-03_JPRB,1.9023E-03_JPRB,1.8058E-03_JPRB,1.6504E-03_JPRB,1.4334E-03_JPRB,&
&1.1403E-03_JPRB,7.3509E-04_JPRB,3.7157E-04_JPRB,1.8783E-04_JPRB,2.8350E-03_JPRB/)
KAO( :, 1,12, 2) = (/&
&8.1827E-04_JPRB,9.9361E-04_JPRB,9.9598E-04_JPRB,9.5548E-04_JPRB,8.7645E-04_JPRB,7.5891E-04_JPRB,&
&5.9398E-04_JPRB,3.6310E-04_JPRB,1.6830E-04_JPRB,7.6627E-05_JPRB,1.5346E-03_JPRB/)
KAO( :, 2,12, 2) = (/&
&9.6798E-04_JPRB,1.1604E-03_JPRB,1.1525E-03_JPRB,1.0960E-03_JPRB,1.0027E-03_JPRB,8.6748E-04_JPRB,&
&6.8181E-04_JPRB,4.2341E-04_JPRB,2.0151E-04_JPRB,9.4708E-05_JPRB,1.7971E-03_JPRB/)
KAO( :, 3,12, 2) = (/&
&1.1161E-03_JPRB,1.3239E-03_JPRB,1.3118E-03_JPRB,1.2444E-03_JPRB,1.1369E-03_JPRB,9.8346E-04_JPRB,&
&7.7783E-04_JPRB,4.8954E-04_JPRB,2.3774E-04_JPRB,1.1437E-04_JPRB,2.0823E-03_JPRB/)
KAO( :, 4,12, 2) = (/&
&1.2595E-03_JPRB,1.4901E-03_JPRB,1.4761E-03_JPRB,1.3996E-03_JPRB,1.2792E-03_JPRB,1.1092E-03_JPRB,&
&8.8159E-04_JPRB,5.6210E-04_JPRB,2.7747E-04_JPRB,1.3609E-04_JPRB,2.3913E-03_JPRB/)
KAO( :, 5,12, 2) = (/&
&1.4015E-03_JPRB,1.6631E-03_JPRB,1.6469E-03_JPRB,1.5633E-03_JPRB,1.4309E-03_JPRB,1.2447E-03_JPRB,&
&9.9327E-04_JPRB,6.4127E-04_JPRB,3.2131E-04_JPRB,1.6049E-04_JPRB,2.7230E-03_JPRB/)
KAO( :, 1,13, 2) = (/&
&7.0404E-04_JPRB,8.5653E-04_JPRB,8.5583E-04_JPRB,8.1887E-04_JPRB,7.5123E-04_JPRB,6.5123E-04_JPRB,&
&5.1170E-04_JPRB,3.1408E-04_JPRB,1.4547E-04_JPRB,6.5608E-05_JPRB,1.2897E-03_JPRB/)
KAO( :, 2,13, 2) = (/&
&8.3008E-04_JPRB,9.9639E-04_JPRB,9.8845E-04_JPRB,9.3911E-04_JPRB,8.5990E-04_JPRB,7.4464E-04_JPRB,&
&5.8802E-04_JPRB,3.6685E-04_JPRB,1.7398E-04_JPRB,8.0807E-05_JPRB,1.5096E-03_JPRB/)
KAO( :, 3,13, 2) = (/&
&9.5290E-04_JPRB,1.1338E-03_JPRB,1.1232E-03_JPRB,1.0653E-03_JPRB,9.7462E-04_JPRB,8.4434E-04_JPRB,&
&6.7107E-04_JPRB,4.2462E-04_JPRB,2.0511E-04_JPRB,9.7336E-05_JPRB,1.7467E-03_JPRB/)
KAO( :, 4,13, 2) = (/&
&1.0727E-03_JPRB,1.2739E-03_JPRB,1.2624E-03_JPRB,1.1971E-03_JPRB,1.0958E-03_JPRB,9.5214E-04_JPRB,&
&7.5999E-04_JPRB,4.8760E-04_JPRB,2.3902E-04_JPRB,1.1564E-04_JPRB,2.0029E-03_JPRB/)
KAO( :, 5,13, 2) = (/&
&1.1912E-03_JPRB,1.4186E-03_JPRB,1.4067E-03_JPRB,1.3365E-03_JPRB,1.2243E-03_JPRB,1.0674E-03_JPRB,&
&8.5545E-04_JPRB,5.5580E-04_JPRB,2.7627E-04_JPRB,1.3629E-04_JPRB,2.2773E-03_JPRB/)
KAO( :, 1, 1, 3) = (/&
&1.5976E-02_JPRB,1.8568E-02_JPRB,1.8677E-02_JPRB,1.8308E-02_JPRB,1.7430E-02_JPRB,1.5980E-02_JPRB,&
&1.3794E-02_JPRB,1.0032E-02_JPRB,5.6593E-03_JPRB,3.1315E-03_JPRB,1.4725E-03_JPRB/)
KAO( :, 2, 1, 3) = (/&
&1.7009E-02_JPRB,1.9983E-02_JPRB,2.0158E-02_JPRB,1.9765E-02_JPRB,1.8846E-02_JPRB,1.7308E-02_JPRB,&
&1.4965E-02_JPRB,1.0920E-02_JPRB,6.2447E-03_JPRB,3.5291E-03_JPRB,1.7476E-03_JPRB/)
KAO( :, 3, 1, 3) = (/&
&1.8075E-02_JPRB,2.1456E-02_JPRB,2.1662E-02_JPRB,2.1259E-02_JPRB,2.0298E-02_JPRB,1.8677E-02_JPRB,&
&1.6168E-02_JPRB,1.1845E-02_JPRB,6.8970E-03_JPRB,3.9734E-03_JPRB,2.0647E-03_JPRB/)
KAO( :, 4, 1, 3) = (/&
&1.9173E-02_JPRB,2.2980E-02_JPRB,2.3194E-02_JPRB,2.2786E-02_JPRB,2.1822E-02_JPRB,2.0115E-02_JPRB,&
&1.7401E-02_JPRB,1.2827E-02_JPRB,7.6128E-03_JPRB,4.4580E-03_JPRB,2.4335E-03_JPRB/)
KAO( :, 5, 1, 3) = (/&
&2.0338E-02_JPRB,2.4533E-02_JPRB,2.4778E-02_JPRB,2.4397E-02_JPRB,2.3401E-02_JPRB,2.1590E-02_JPRB,&
&1.8677E-02_JPRB,1.3858E-02_JPRB,8.3792E-03_JPRB,4.9858E-03_JPRB,2.8649E-03_JPRB/)
KAO( :, 1, 2, 3) = (/&
&1.3803E-02_JPRB,1.6030E-02_JPRB,1.6037E-02_JPRB,1.5594E-02_JPRB,1.4756E-02_JPRB,1.3459E-02_JPRB,&
&1.1617E-02_JPRB,8.5122E-03_JPRB,4.8022E-03_JPRB,2.6569E-03_JPRB,1.3182E-03_JPRB/)
KAO( :, 2, 2, 3) = (/&
&1.4747E-02_JPRB,1.7312E-02_JPRB,1.7346E-02_JPRB,1.6863E-02_JPRB,1.5968E-02_JPRB,1.4592E-02_JPRB,&
&1.2613E-02_JPRB,9.2706E-03_JPRB,5.3102E-03_JPRB,3.0023E-03_JPRB,1.5460E-03_JPRB/)
KAO( :, 3, 2, 3) = (/&
&1.5720E-02_JPRB,1.8638E-02_JPRB,1.8676E-02_JPRB,1.8166E-02_JPRB,1.7228E-02_JPRB,1.5775E-02_JPRB,&
&1.3646E-02_JPRB,1.0060E-02_JPRB,5.8750E-03_JPRB,3.3882E-03_JPRB,1.8045E-03_JPRB/)
KAO( :, 4, 2, 3) = (/&
&1.6750E-02_JPRB,1.9993E-02_JPRB,2.0028E-02_JPRB,1.9499E-02_JPRB,1.8542E-02_JPRB,1.7020E-02_JPRB,&
&1.4712E-02_JPRB,1.0896E-02_JPRB,6.4908E-03_JPRB,3.8125E-03_JPRB,2.0990E-03_JPRB/)
KAO( :, 5, 2, 3) = (/&
&1.7833E-02_JPRB,2.1360E-02_JPRB,2.1424E-02_JPRB,2.0911E-02_JPRB,1.9906E-02_JPRB,1.8307E-02_JPRB,&
&1.5816E-02_JPRB,1.1769E-02_JPRB,7.1573E-03_JPRB,4.2773E-03_JPRB,2.4433E-03_JPRB/)
KAO( :, 1, 3, 3) = (/&
&1.1661E-02_JPRB,1.3546E-02_JPRB,1.3524E-02_JPRB,1.3093E-02_JPRB,1.2307E-02_JPRB,1.1159E-02_JPRB,&
&9.5780E-03_JPRB,7.0484E-03_JPRB,3.9675E-03_JPRB,2.1846E-03_JPRB,1.2406E-03_JPRB/)
KAO( :, 2, 3, 3) = (/&
&1.2503E-02_JPRB,1.4707E-02_JPRB,1.4691E-02_JPRB,1.4206E-02_JPRB,1.3360E-02_JPRB,1.2110E-02_JPRB,&
&1.0409E-02_JPRB,7.6788E-03_JPRB,4.3933E-03_JPRB,2.4719E-03_JPRB,1.4298E-03_JPRB/)
KAO( :, 3, 3, 3) = (/&
&1.3391E-02_JPRB,1.5887E-02_JPRB,1.5874E-02_JPRB,1.5334E-02_JPRB,1.4440E-02_JPRB,1.3111E-02_JPRB,&
&1.1280E-02_JPRB,8.3388E-03_JPRB,4.8688E-03_JPRB,2.7958E-03_JPRB,1.6523E-03_JPRB/)
KAO( :, 4, 3, 3) = (/&
&1.4336E-02_JPRB,1.7085E-02_JPRB,1.7069E-02_JPRB,1.6495E-02_JPRB,1.5553E-02_JPRB,1.4166E-02_JPRB,&
&1.2195E-02_JPRB,9.0457E-03_JPRB,5.3867E-03_JPRB,3.1533E-03_JPRB,1.9090E-03_JPRB/)
KAO( :, 5, 3, 3) = (/&
&1.5320E-02_JPRB,1.8321E-02_JPRB,1.8292E-02_JPRB,1.7706E-02_JPRB,1.6704E-02_JPRB,1.5265E-02_JPRB,&
&1.3148E-02_JPRB,9.7836E-03_JPRB,5.9483E-03_JPRB,3.5492E-03_JPRB,2.2059E-03_JPRB/)
KAO( :, 1, 4, 3) = (/&
&9.7449E-03_JPRB,1.1294E-02_JPRB,1.1258E-02_JPRB,1.0884E-02_JPRB,1.0199E-02_JPRB,9.2227E-03_JPRB,&
&7.8658E-03_JPRB,5.7767E-03_JPRB,3.2406E-03_JPRB,1.7708E-03_JPRB,1.2728E-03_JPRB/)
KAO( :, 2, 4, 3) = (/&
&1.0487E-02_JPRB,1.2330E-02_JPRB,1.2286E-02_JPRB,1.1862E-02_JPRB,1.1122E-02_JPRB,1.0046E-02_JPRB,&
&8.5629E-03_JPRB,6.2952E-03_JPRB,3.5929E-03_JPRB,2.0093E-03_JPRB,1.4326E-03_JPRB/)
KAO( :, 3, 4, 3) = (/&
&1.1282E-02_JPRB,1.3369E-02_JPRB,1.3332E-02_JPRB,1.2857E-02_JPRB,1.2064E-02_JPRB,1.0901E-02_JPRB,&
&9.2930E-03_JPRB,6.8463E-03_JPRB,3.9872E-03_JPRB,2.2770E-03_JPRB,1.6227E-03_JPRB/)
KAO( :, 4, 4, 3) = (/&
&1.2130E-02_JPRB,1.4435E-02_JPRB,1.4396E-02_JPRB,1.3883E-02_JPRB,1.3026E-02_JPRB,1.1786E-02_JPRB,&
&1.0067E-02_JPRB,7.4371E-03_JPRB,4.4153E-03_JPRB,2.5725E-03_JPRB,1.8437E-03_JPRB/)
KAO( :, 5, 4, 3) = (/&
&1.3022E-02_JPRB,1.5544E-02_JPRB,1.5501E-02_JPRB,1.4941E-02_JPRB,1.4007E-02_JPRB,1.2708E-02_JPRB,&
&1.0876E-02_JPRB,8.0666E-03_JPRB,4.8767E-03_JPRB,2.9035E-03_JPRB,2.1000E-03_JPRB/)
KAO( :, 1, 5, 3) = (/&
&8.1183E-03_JPRB,9.3706E-03_JPRB,9.3339E-03_JPRB,9.0036E-03_JPRB,8.4209E-03_JPRB,7.5832E-03_JPRB,&
&6.4445E-03_JPRB,4.7331E-03_JPRB,2.6371E-03_JPRB,1.4269E-03_JPRB,1.3512E-03_JPRB/)
KAO( :, 2, 5, 3) = (/&
&8.7619E-03_JPRB,1.0271E-02_JPRB,1.0226E-02_JPRB,9.8533E-03_JPRB,9.2177E-03_JPRB,8.3034E-03_JPRB,&
&7.0466E-03_JPRB,5.1625E-03_JPRB,2.9261E-03_JPRB,1.6222E-03_JPRB,1.4975E-03_JPRB/)
KAO( :, 3, 5, 3) = (/&
&9.4590E-03_JPRB,1.1191E-02_JPRB,1.1132E-02_JPRB,1.0717E-02_JPRB,1.0035E-02_JPRB,9.0438E-03_JPRB,&
&7.6825E-03_JPRB,5.6186E-03_JPRB,3.2487E-03_JPRB,1.8419E-03_JPRB,1.6628E-03_JPRB/)
KAO( :, 4, 5, 3) = (/&
&1.0214E-02_JPRB,1.2129E-02_JPRB,1.2065E-02_JPRB,1.1613E-02_JPRB,1.0874E-02_JPRB,9.8104E-03_JPRB,&
&8.3376E-03_JPRB,6.1127E-03_JPRB,3.6040E-03_JPRB,2.0844E-03_JPRB,1.8526E-03_JPRB/)
KAO( :, 5, 5, 3) = (/&
&1.1012E-02_JPRB,1.3112E-02_JPRB,1.3045E-02_JPRB,1.2543E-02_JPRB,1.1733E-02_JPRB,1.0605E-02_JPRB,&
&9.0222E-03_JPRB,6.6408E-03_JPRB,3.9796E-03_JPRB,2.3572E-03_JPRB,2.0770E-03_JPRB/)
KAO( :, 1, 6, 3) = (/&
&6.7387E-03_JPRB,7.7194E-03_JPRB,7.6902E-03_JPRB,7.3986E-03_JPRB,6.9016E-03_JPRB,6.1800E-03_JPRB,&
&5.2304E-03_JPRB,3.8605E-03_JPRB,2.1393E-03_JPRB,1.1384E-03_JPRB,1.3809E-03_JPRB/)
KAO( :, 2, 6, 3) = (/&
&7.2904E-03_JPRB,8.4901E-03_JPRB,8.4559E-03_JPRB,8.1341E-03_JPRB,7.5897E-03_JPRB,6.8043E-03_JPRB,&
&5.7497E-03_JPRB,4.2219E-03_JPRB,2.3703E-03_JPRB,1.2951E-03_JPRB,1.5336E-03_JPRB/)
KAO( :, 3, 6, 3) = (/&
&7.8883E-03_JPRB,9.2955E-03_JPRB,9.2345E-03_JPRB,8.8797E-03_JPRB,8.2936E-03_JPRB,7.4421E-03_JPRB,&
&6.2952E-03_JPRB,4.6028E-03_JPRB,2.6285E-03_JPRB,1.4716E-03_JPRB,1.6931E-03_JPRB/)
KAO( :, 4, 6, 3) = (/&
&8.5494E-03_JPRB,1.0121E-02_JPRB,1.0046E-02_JPRB,9.6522E-03_JPRB,9.0176E-03_JPRB,8.1042E-03_JPRB,&
&6.8613E-03_JPRB,5.0179E-03_JPRB,2.9165E-03_JPRB,1.6693E-03_JPRB,1.8690E-03_JPRB/)
KAO( :, 5, 6, 3) = (/&
&9.2455E-03_JPRB,1.0989E-02_JPRB,1.0902E-02_JPRB,1.0465E-02_JPRB,9.7689E-03_JPRB,8.7913E-03_JPRB,&
&7.4494E-03_JPRB,5.4572E-03_JPRB,3.2276E-03_JPRB,1.8909E-03_JPRB,2.0643E-03_JPRB/)
KAO( :, 1, 7, 3) = (/&
&5.5708E-03_JPRB,6.3303E-03_JPRB,6.2934E-03_JPRB,6.0276E-03_JPRB,5.6127E-03_JPRB,5.0058E-03_JPRB,&
&4.2172E-03_JPRB,3.1142E-03_JPRB,1.7288E-03_JPRB,9.0214E-04_JPRB,1.3580E-03_JPRB/)
KAO( :, 2, 7, 3) = (/&
&6.0396E-03_JPRB,6.9771E-03_JPRB,6.9412E-03_JPRB,6.6559E-03_JPRB,6.1993E-03_JPRB,5.5301E-03_JPRB,&
&4.6524E-03_JPRB,3.4207E-03_JPRB,1.9119E-03_JPRB,1.0257E-03_JPRB,1.5329E-03_JPRB/)
KAO( :, 3, 7, 3) = (/&
&6.5450E-03_JPRB,7.6646E-03_JPRB,7.6059E-03_JPRB,7.3014E-03_JPRB,6.8031E-03_JPRB,6.0741E-03_JPRB,&
&5.1130E-03_JPRB,3.7412E-03_JPRB,2.1172E-03_JPRB,1.1666E-03_JPRB,1.7255E-03_JPRB/)
KAO( :, 4, 7, 3) = (/&
&7.1105E-03_JPRB,8.3764E-03_JPRB,8.3038E-03_JPRB,7.9705E-03_JPRB,7.4282E-03_JPRB,6.6393E-03_JPRB,&
&5.5928E-03_JPRB,4.0886E-03_JPRB,2.3470E-03_JPRB,1.3258E-03_JPRB,1.9241E-03_JPRB/)
KAO( :, 5, 7, 3) = (/&
&7.7089E-03_JPRB,9.1270E-03_JPRB,9.0467E-03_JPRB,8.6734E-03_JPRB,8.0760E-03_JPRB,7.2286E-03_JPRB,&
&6.0941E-03_JPRB,4.4574E-03_JPRB,2.6042E-03_JPRB,1.5049E-03_JPRB,2.1289E-03_JPRB/)
KAO( :, 1, 8, 3) = (/&
&4.5931E-03_JPRB,5.1838E-03_JPRB,5.1398E-03_JPRB,4.8986E-03_JPRB,4.5439E-03_JPRB,4.0450E-03_JPRB,&
&3.3970E-03_JPRB,2.5021E-03_JPRB,1.3915E-03_JPRB,7.1461E-04_JPRB,1.4342E-03_JPRB/)
KAO( :, 2, 8, 3) = (/&
&4.9923E-03_JPRB,5.7205E-03_JPRB,5.6835E-03_JPRB,5.4255E-03_JPRB,5.0420E-03_JPRB,4.4815E-03_JPRB,&
&3.7569E-03_JPRB,2.7595E-03_JPRB,1.5378E-03_JPRB,8.1223E-04_JPRB,1.6265E-03_JPRB/)
KAO( :, 3, 8, 3) = (/&
&5.4187E-03_JPRB,6.3059E-03_JPRB,6.2512E-03_JPRB,5.9779E-03_JPRB,5.5552E-03_JPRB,4.9397E-03_JPRB,&
&4.1407E-03_JPRB,3.0283E-03_JPRB,1.7020E-03_JPRB,9.2374E-04_JPRB,1.8395E-03_JPRB/)
KAO( :, 4, 8, 3) = (/&
&5.8951E-03_JPRB,6.9159E-03_JPRB,6.8456E-03_JPRB,6.5555E-03_JPRB,6.0927E-03_JPRB,5.4203E-03_JPRB,&
&4.5434E-03_JPRB,3.3140E-03_JPRB,1.8874E-03_JPRB,1.0500E-03_JPRB,2.0723E-03_JPRB/)
KAO( :, 5, 8, 3) = (/&
&6.4067E-03_JPRB,7.5583E-03_JPRB,7.4822E-03_JPRB,7.1624E-03_JPRB,6.6529E-03_JPRB,5.9218E-03_JPRB,&
&4.9680E-03_JPRB,3.6203E-03_JPRB,2.0980E-03_JPRB,1.1933E-03_JPRB,2.3247E-03_JPRB/)
KAO( :, 1, 9, 3) = (/&
&3.7723E-03_JPRB,4.2334E-03_JPRB,4.1819E-03_JPRB,3.9649E-03_JPRB,3.6588E-03_JPRB,3.2575E-03_JPRB,&
&2.7305E-03_JPRB,2.0072E-03_JPRB,1.1193E-03_JPRB,5.6741E-04_JPRB,1.9860E-03_JPRB/)
KAO( :, 2, 9, 3) = (/&
&4.1112E-03_JPRB,4.6764E-03_JPRB,4.6357E-03_JPRB,4.4068E-03_JPRB,4.0793E-03_JPRB,3.6198E-03_JPRB,&
&3.0290E-03_JPRB,2.2191E-03_JPRB,1.2358E-03_JPRB,6.4340E-04_JPRB,2.2587E-03_JPRB/)
KAO( :, 3, 9, 3) = (/&
&4.4681E-03_JPRB,5.1657E-03_JPRB,5.1169E-03_JPRB,4.8742E-03_JPRB,4.5148E-03_JPRB,4.0038E-03_JPRB,&
&3.3466E-03_JPRB,2.4441E-03_JPRB,1.3675E-03_JPRB,7.3070E-04_JPRB,2.5668E-03_JPRB/)
KAO( :, 4, 9, 3) = (/&
&4.8668E-03_JPRB,5.6866E-03_JPRB,5.6264E-03_JPRB,5.3677E-03_JPRB,4.9748E-03_JPRB,4.4113E-03_JPRB,&
&3.6848E-03_JPRB,2.6780E-03_JPRB,1.5165E-03_JPRB,8.3094E-04_JPRB,2.9044E-03_JPRB/)
KAO( :, 5, 9, 3) = (/&
&5.3024E-03_JPRB,6.2338E-03_JPRB,6.1683E-03_JPRB,5.8906E-03_JPRB,5.4560E-03_JPRB,4.8416E-03_JPRB,&
&4.0418E-03_JPRB,2.9316E-03_JPRB,1.6868E-03_JPRB,9.4494E-04_JPRB,3.2758E-03_JPRB/)
KAO( :, 1,10, 3) = (/&
&3.1048E-03_JPRB,3.4713E-03_JPRB,3.4149E-03_JPRB,3.2215E-03_JPRB,2.9606E-03_JPRB,2.6323E-03_JPRB,&
&2.2040E-03_JPRB,1.6183E-03_JPRB,9.0511E-04_JPRB,4.5442E-04_JPRB,3.4066E-03_JPRB/)
KAO( :, 2,10, 3) = (/&
&3.3920E-03_JPRB,3.8387E-03_JPRB,3.7924E-03_JPRB,3.5898E-03_JPRB,3.3084E-03_JPRB,2.9358E-03_JPRB,&
&2.4507E-03_JPRB,1.7915E-03_JPRB,9.9919E-04_JPRB,5.1342E-04_JPRB,3.8889E-03_JPRB/)
KAO( :, 3,10, 3) = (/&
&3.6957E-03_JPRB,4.2459E-03_JPRB,4.1994E-03_JPRB,3.9831E-03_JPRB,3.6769E-03_JPRB,3.2571E-03_JPRB,&
&2.7157E-03_JPRB,1.9778E-03_JPRB,1.1048E-03_JPRB,5.8256E-04_JPRB,4.4355E-03_JPRB/)
KAO( :, 4,10, 3) = (/&
&4.0318E-03_JPRB,4.6867E-03_JPRB,4.6340E-03_JPRB,4.4000E-03_JPRB,4.0676E-03_JPRB,3.6005E-03_JPRB,&
&2.9971E-03_JPRB,2.1730E-03_JPRB,1.2259E-03_JPRB,6.6297E-04_JPRB,5.0564E-03_JPRB/)
KAO( :, 5,10, 3) = (/&
&4.4033E-03_JPRB,5.1538E-03_JPRB,5.0961E-03_JPRB,4.8470E-03_JPRB,4.4796E-03_JPRB,3.9660E-03_JPRB,&
&3.2977E-03_JPRB,2.3839E-03_JPRB,1.3631E-03_JPRB,7.5476E-04_JPRB,5.7516E-03_JPRB/)
KAO( :, 1,11, 3) = (/&
&2.6765E-03_JPRB,2.9827E-03_JPRB,2.9227E-03_JPRB,2.7508E-03_JPRB,2.5220E-03_JPRB,2.2363E-03_JPRB,&
&1.8676E-03_JPRB,1.3675E-03_JPRB,7.6612E-04_JPRB,3.8447E-04_JPRB,4.0480E-03_JPRB/)
KAO( :, 2,11, 3) = (/&
&2.9286E-03_JPRB,3.3040E-03_JPRB,3.2538E-03_JPRB,3.0703E-03_JPRB,2.8192E-03_JPRB,2.4962E-03_JPRB,&
&2.0772E-03_JPRB,1.5146E-03_JPRB,8.4625E-04_JPRB,4.3409E-04_JPRB,4.6666E-03_JPRB/)
KAO( :, 3,11, 3) = (/&
&3.2003E-03_JPRB,3.6648E-03_JPRB,3.6125E-03_JPRB,3.4113E-03_JPRB,3.1362E-03_JPRB,2.7724E-03_JPRB,&
&2.3029E-03_JPRB,1.6722E-03_JPRB,9.3679E-04_JPRB,4.9229E-04_JPRB,5.3654E-03_JPRB/)
KAO( :, 4,11, 3) = (/&
&3.5051E-03_JPRB,4.0531E-03_JPRB,3.9947E-03_JPRB,3.7750E-03_JPRB,3.4761E-03_JPRB,3.0693E-03_JPRB,&
&2.5452E-03_JPRB,1.8406E-03_JPRB,1.0404E-03_JPRB,5.6079E-04_JPRB,6.1512E-03_JPRB/)
KAO( :, 5,11, 3) = (/&
&3.8321E-03_JPRB,4.4649E-03_JPRB,4.4022E-03_JPRB,4.1654E-03_JPRB,3.8377E-03_JPRB,3.3874E-03_JPRB,&
&2.8053E-03_JPRB,2.0226E-03_JPRB,1.1574E-03_JPRB,6.3974E-04_JPRB,7.0160E-03_JPRB/)
KAO( :, 1,12, 3) = (/&
&2.3036E-03_JPRB,2.5583E-03_JPRB,2.4978E-03_JPRB,2.3445E-03_JPRB,2.1430E-03_JPRB,1.8944E-03_JPRB,&
&1.5761E-03_JPRB,1.1517E-03_JPRB,6.4556E-04_JPRB,3.2349E-04_JPRB,4.0392E-03_JPRB/)
KAO( :, 2,12, 3) = (/&
&2.5244E-03_JPRB,2.8452E-03_JPRB,2.7899E-03_JPRB,2.6237E-03_JPRB,2.3996E-03_JPRB,2.1171E-03_JPRB,&
&1.7537E-03_JPRB,1.2751E-03_JPRB,7.1384E-04_JPRB,3.6513E-04_JPRB,4.6690E-03_JPRB/)
KAO( :, 3,12, 3) = (/&
&2.7664E-03_JPRB,3.1661E-03_JPRB,3.1080E-03_JPRB,2.9230E-03_JPRB,2.6751E-03_JPRB,2.3552E-03_JPRB,&
&1.9462E-03_JPRB,1.4075E-03_JPRB,7.9075E-04_JPRB,4.1435E-04_JPRB,5.3798E-03_JPRB/)
KAO( :, 4,12, 3) = (/&
&3.0371E-03_JPRB,3.5090E-03_JPRB,3.4460E-03_JPRB,3.2437E-03_JPRB,2.9706E-03_JPRB,2.6114E-03_JPRB,&
&2.1543E-03_JPRB,1.5507E-03_JPRB,8.7926E-04_JPRB,4.7250E-04_JPRB,6.1711E-03_JPRB/)
KAO( :, 5,12, 3) = (/&
&3.3239E-03_JPRB,3.8709E-03_JPRB,3.8063E-03_JPRB,3.5842E-03_JPRB,3.2855E-03_JPRB,2.8872E-03_JPRB,&
&2.3774E-03_JPRB,1.7073E-03_JPRB,9.7951E-04_JPRB,5.3974E-04_JPRB,7.0329E-03_JPRB/)
KAO( :, 1,13, 3) = (/&
&1.9693E-03_JPRB,2.1819E-03_JPRB,2.1260E-03_JPRB,1.9917E-03_JPRB,1.8142E-03_JPRB,1.5977E-03_JPRB,&
&1.3230E-03_JPRB,9.6163E-04_JPRB,5.3722E-04_JPRB,2.6914E-04_JPRB,3.4457E-03_JPRB/)
KAO( :, 2,13, 3) = (/&
&2.1605E-03_JPRB,2.4363E-03_JPRB,2.3825E-03_JPRB,2.2341E-03_JPRB,2.0358E-03_JPRB,1.7890E-03_JPRB,&
&1.4743E-03_JPRB,1.0637E-03_JPRB,5.9461E-04_JPRB,3.0420E-04_JPRB,3.9859E-03_JPRB/)
KAO( :, 3,13, 3) = (/&
&2.3729E-03_JPRB,2.7175E-03_JPRB,2.6607E-03_JPRB,2.4950E-03_JPRB,2.2744E-03_JPRB,1.9956E-03_JPRB,&
&1.6383E-03_JPRB,1.1739E-03_JPRB,6.5958E-04_JPRB,3.4564E-04_JPRB,4.5954E-03_JPRB/)
KAO( :, 4,13, 3) = (/&
&2.6042E-03_JPRB,3.0147E-03_JPRB,2.9558E-03_JPRB,2.7741E-03_JPRB,2.5310E-03_JPRB,2.2169E-03_JPRB,&
&1.8165E-03_JPRB,1.2954E-03_JPRB,7.3516E-04_JPRB,3.9462E-04_JPRB,5.2719E-03_JPRB/)
KAO( :, 5,13, 3) = (/&
&2.8484E-03_JPRB,3.3273E-03_JPRB,3.2687E-03_JPRB,3.0678E-03_JPRB,2.8024E-03_JPRB,2.4543E-03_JPRB,&
&2.0064E-03_JPRB,1.4291E-03_JPRB,8.2095E-04_JPRB,4.5105E-04_JPRB,5.9980E-03_JPRB/)
KAO( :, 1, 1, 4) = (/&
&3.2206E-02_JPRB,3.7616E-02_JPRB,3.7442E-02_JPRB,3.5602E-02_JPRB,3.2848E-02_JPRB,2.9212E-02_JPRB,&
&2.4411E-02_JPRB,1.8093E-02_JPRB,1.1087E-02_JPRB,6.4396E-03_JPRB,4.1579E-03_JPRB/)
KAO( :, 2, 1, 4) = (/&
&3.3985E-02_JPRB,4.0141E-02_JPRB,4.0066E-02_JPRB,3.8220E-02_JPRB,3.5310E-02_JPRB,3.1363E-02_JPRB,&
&2.6274E-02_JPRB,1.9563E-02_JPRB,1.2137E-02_JPRB,7.2344E-03_JPRB,4.9421E-03_JPRB/)
KAO( :, 3, 1, 4) = (/&
&3.5840E-02_JPRB,4.2657E-02_JPRB,4.2657E-02_JPRB,4.0828E-02_JPRB,3.7715E-02_JPRB,3.3592E-02_JPRB,&
&2.8238E-02_JPRB,2.1146E-02_JPRB,1.3263E-02_JPRB,8.1243E-03_JPRB,5.8370E-03_JPRB/)
KAO( :, 4, 1, 4) = (/&
&3.7710E-02_JPRB,4.5086E-02_JPRB,4.5284E-02_JPRB,4.3358E-02_JPRB,4.0123E-02_JPRB,3.5805E-02_JPRB,&
&3.0308E-02_JPRB,2.2810E-02_JPRB,1.4502E-02_JPRB,9.1329E-03_JPRB,6.8906E-03_JPRB/)
KAO( :, 5, 1, 4) = (/&
&3.9546E-02_JPRB,4.7465E-02_JPRB,4.7884E-02_JPRB,4.5873E-02_JPRB,4.2558E-02_JPRB,3.8078E-02_JPRB,&
&3.2453E-02_JPRB,2.4580E-02_JPRB,1.5839E-02_JPRB,1.0280E-02_JPRB,8.0935E-03_JPRB/)
KAO( :, 1, 2, 4) = (/&
&2.8104E-02_JPRB,3.2464E-02_JPRB,3.2358E-02_JPRB,3.0703E-02_JPRB,2.8262E-02_JPRB,2.5049E-02_JPRB,&
&2.0887E-02_JPRB,1.5371E-02_JPRB,9.5321E-03_JPRB,5.5766E-03_JPRB,3.4128E-03_JPRB/)
KAO( :, 2, 2, 4) = (/&
&2.9709E-02_JPRB,3.4733E-02_JPRB,3.4706E-02_JPRB,3.3029E-02_JPRB,3.0407E-02_JPRB,2.6975E-02_JPRB,&
&2.2525E-02_JPRB,1.6668E-02_JPRB,1.0444E-02_JPRB,6.2493E-03_JPRB,4.0210E-03_JPRB/)
KAO( :, 3, 2, 4) = (/&
&3.1368E-02_JPRB,3.6997E-02_JPRB,3.7038E-02_JPRB,3.5309E-02_JPRB,3.2541E-02_JPRB,2.8948E-02_JPRB,&
&2.4248E-02_JPRB,1.8078E-02_JPRB,1.1429E-02_JPRB,7.0025E-03_JPRB,4.7234E-03_JPRB/)
KAO( :, 4, 2, 4) = (/&
&3.3025E-02_JPRB,3.9194E-02_JPRB,3.9406E-02_JPRB,3.7566E-02_JPRB,3.4724E-02_JPRB,3.0907E-02_JPRB,&
&2.6047E-02_JPRB,1.9552E-02_JPRB,1.2511E-02_JPRB,7.8460E-03_JPRB,5.5531E-03_JPRB/)
KAO( :, 5, 2, 4) = (/&
&3.4658E-02_JPRB,4.1417E-02_JPRB,4.1750E-02_JPRB,3.9870E-02_JPRB,3.6925E-02_JPRB,3.2920E-02_JPRB,&
&2.7922E-02_JPRB,2.1122E-02_JPRB,1.3687E-02_JPRB,8.7925E-03_JPRB,6.5017E-03_JPRB/)
KAO( :, 1, 3, 4) = (/&
&2.4251E-02_JPRB,2.7585E-02_JPRB,2.7414E-02_JPRB,2.5896E-02_JPRB,2.3769E-02_JPRB,2.1015E-02_JPRB,&
&1.7490E-02_JPRB,1.2799E-02_JPRB,7.9859E-03_JPRB,4.6822E-03_JPRB,3.0167E-03_JPRB/)
KAO( :, 2, 3, 4) = (/&
&2.5692E-02_JPRB,2.9548E-02_JPRB,2.9492E-02_JPRB,2.7935E-02_JPRB,2.5630E-02_JPRB,2.2680E-02_JPRB,&
&1.8918E-02_JPRB,1.3904E-02_JPRB,8.7584E-03_JPRB,5.2529E-03_JPRB,3.4804E-03_JPRB/)
KAO( :, 3, 3, 4) = (/&
&2.7159E-02_JPRB,3.1559E-02_JPRB,3.1551E-02_JPRB,2.9932E-02_JPRB,2.7503E-02_JPRB,2.4395E-02_JPRB,&
&2.0399E-02_JPRB,1.5119E-02_JPRB,9.5888E-03_JPRB,5.8905E-03_JPRB,4.0103E-03_JPRB/)
KAO( :, 4, 3, 4) = (/&
&2.8607E-02_JPRB,3.3560E-02_JPRB,3.3603E-02_JPRB,3.1948E-02_JPRB,2.9447E-02_JPRB,2.6126E-02_JPRB,&
&2.1928E-02_JPRB,1.6399E-02_JPRB,1.0499E-02_JPRB,6.6008E-03_JPRB,4.6200E-03_JPRB/)
KAO( :, 5, 3, 4) = (/&
&3.0051E-02_JPRB,3.5562E-02_JPRB,3.5683E-02_JPRB,3.4039E-02_JPRB,3.1430E-02_JPRB,2.7908E-02_JPRB,&
&2.3518E-02_JPRB,1.7750E-02_JPRB,1.1493E-02_JPRB,7.3863E-03_JPRB,5.3130E-03_JPRB/)
KAO( :, 1, 4, 4) = (/&
&2.0821E-02_JPRB,2.3399E-02_JPRB,2.3111E-02_JPRB,2.1751E-02_JPRB,1.9864E-02_JPRB,1.7485E-02_JPRB,&
&1.4530E-02_JPRB,1.0587E-02_JPRB,6.6174E-03_JPRB,3.8560E-03_JPRB,2.7540E-03_JPRB/)
KAO( :, 2, 4, 4) = (/&
&2.2145E-02_JPRB,2.5108E-02_JPRB,2.4937E-02_JPRB,2.3519E-02_JPRB,2.1458E-02_JPRB,1.8898E-02_JPRB,&
&1.5727E-02_JPRB,1.1528E-02_JPRB,7.2647E-03_JPRB,4.3306E-03_JPRB,3.1427E-03_JPRB/)
KAO( :, 3, 4, 4) = (/&
&2.3458E-02_JPRB,2.6892E-02_JPRB,2.6767E-02_JPRB,2.5244E-02_JPRB,2.3063E-02_JPRB,2.0374E-02_JPRB,&
&1.6989E-02_JPRB,1.2556E-02_JPRB,7.9663E-03_JPRB,4.8678E-03_JPRB,3.5922E-03_JPRB/)
KAO( :, 4, 4, 4) = (/&
&2.4742E-02_JPRB,2.8684E-02_JPRB,2.8567E-02_JPRB,2.7002E-02_JPRB,2.4744E-02_JPRB,2.1891E-02_JPRB,&
&1.8302E-02_JPRB,1.3637E-02_JPRB,8.7323E-03_JPRB,5.4756E-03_JPRB,4.1087E-03_JPRB/)
KAO( :, 5, 4, 4) = (/&
&2.6031E-02_JPRB,3.0478E-02_JPRB,3.0373E-02_JPRB,2.8831E-02_JPRB,2.6502E-02_JPRB,2.3472E-02_JPRB,&
&1.9656E-02_JPRB,1.4775E-02_JPRB,9.5721E-03_JPRB,6.1469E-03_JPRB,4.6820E-03_JPRB/)
KAO( :, 1, 5, 4) = (/&
&1.7749E-02_JPRB,1.9809E-02_JPRB,1.9474E-02_JPRB,1.8308E-02_JPRB,1.6656E-02_JPRB,1.4612E-02_JPRB,&
&1.2090E-02_JPRB,8.7523E-03_JPRB,5.4506E-03_JPRB,3.1594E-03_JPRB,2.6009E-03_JPRB/)
KAO( :, 2, 5, 4) = (/&
&1.8962E-02_JPRB,2.1368E-02_JPRB,2.1111E-02_JPRB,1.9856E-02_JPRB,1.8026E-02_JPRB,1.5797E-02_JPRB,&
&1.3087E-02_JPRB,9.5480E-03_JPRB,5.9920E-03_JPRB,3.5465E-03_JPRB,2.9383E-03_JPRB/)
KAO( :, 3, 5, 4) = (/&
&2.0156E-02_JPRB,2.2955E-02_JPRB,2.2766E-02_JPRB,2.1370E-02_JPRB,1.9402E-02_JPRB,1.7036E-02_JPRB,&
&1.4132E-02_JPRB,1.0409E-02_JPRB,6.5849E-03_JPRB,3.9909E-03_JPRB,3.3267E-03_JPRB/)
KAO( :, 4, 5, 4) = (/&
&2.1323E-02_JPRB,2.4554E-02_JPRB,2.4380E-02_JPRB,2.2909E-02_JPRB,2.0850E-02_JPRB,1.8325E-02_JPRB,&
&1.5252E-02_JPRB,1.1317E-02_JPRB,7.2332E-03_JPRB,4.4966E-03_JPRB,3.7667E-03_JPRB/)
KAO( :, 5, 5, 4) = (/&
&2.2499E-02_JPRB,2.6158E-02_JPRB,2.5975E-02_JPRB,2.4497E-02_JPRB,2.2360E-02_JPRB,1.9686E-02_JPRB,&
&1.6421E-02_JPRB,1.2278E-02_JPRB,7.9387E-03_JPRB,5.0610E-03_JPRB,4.2588E-03_JPRB/)
KAO( :, 1, 6, 4) = (/&
&1.5007E-02_JPRB,1.6598E-02_JPRB,1.6252E-02_JPRB,1.5296E-02_JPRB,1.3918E-02_JPRB,1.2197E-02_JPRB,&
&1.0070E-02_JPRB,7.1973E-03_JPRB,4.4418E-03_JPRB,2.5632E-03_JPRB,2.6270E-03_JPRB/)
KAO( :, 2, 6, 4) = (/&
&1.6096E-02_JPRB,1.8008E-02_JPRB,1.7715E-02_JPRB,1.6668E-02_JPRB,1.5117E-02_JPRB,1.3217E-02_JPRB,&
&1.0902E-02_JPRB,7.8574E-03_JPRB,4.8940E-03_JPRB,2.8829E-03_JPRB,2.9097E-03_JPRB/)
KAO( :, 3, 6, 4) = (/&
&1.7175E-02_JPRB,1.9434E-02_JPRB,1.9209E-02_JPRB,1.8020E-02_JPRB,1.6319E-02_JPRB,1.4272E-02_JPRB,&
&1.1772E-02_JPRB,8.5712E-03_JPRB,5.3927E-03_JPRB,3.2482E-03_JPRB,3.2462E-03_JPRB/)
KAO( :, 4, 6, 4) = (/&
&1.8239E-02_JPRB,2.0847E-02_JPRB,2.0666E-02_JPRB,1.9382E-02_JPRB,1.7575E-02_JPRB,1.5371E-02_JPRB,&
&1.2710E-02_JPRB,9.3314E-03_JPRB,5.9328E-03_JPRB,3.6614E-03_JPRB,3.6324E-03_JPRB/)
KAO( :, 5, 6, 4) = (/&
&1.9314E-02_JPRB,2.2274E-02_JPRB,2.2099E-02_JPRB,2.0773E-02_JPRB,1.8871E-02_JPRB,1.6523E-02_JPRB,&
&1.3707E-02_JPRB,1.0147E-02_JPRB,6.5230E-03_JPRB,4.1212E-03_JPRB,4.0664E-03_JPRB/)
KAO( :, 1, 7, 4) = (/&
&1.2562E-02_JPRB,1.3749E-02_JPRB,1.3412E-02_JPRB,1.2652E-02_JPRB,1.1501E-02_JPRB,1.0078E-02_JPRB,&
&8.3008E-03_JPRB,5.8951E-03_JPRB,3.5839E-03_JPRB,2.0640E-03_JPRB,2.8990E-03_JPRB/)
KAO( :, 2, 7, 4) = (/&
&1.3513E-02_JPRB,1.4992E-02_JPRB,1.4706E-02_JPRB,1.3842E-02_JPRB,1.2549E-02_JPRB,1.0956E-02_JPRB,&
&9.0265E-03_JPRB,6.4348E-03_JPRB,3.9618E-03_JPRB,2.3233E-03_JPRB,3.1544E-03_JPRB/)
KAO( :, 3, 7, 4) = (/&
&1.4463E-02_JPRB,1.6248E-02_JPRB,1.6003E-02_JPRB,1.5021E-02_JPRB,1.3588E-02_JPRB,1.1865E-02_JPRB,&
&9.7704E-03_JPRB,7.0232E-03_JPRB,4.3758E-03_JPRB,2.6208E-03_JPRB,3.4308E-03_JPRB/)
KAO( :, 4, 7, 4) = (/&
&1.5412E-02_JPRB,1.7497E-02_JPRB,1.7276E-02_JPRB,1.6194E-02_JPRB,1.4663E-02_JPRB,1.2815E-02_JPRB,&
&1.0574E-02_JPRB,7.6491E-03_JPRB,4.8284E-03_JPRB,2.9535E-03_JPRB,3.7526E-03_JPRB/)
KAO( :, 5, 7, 4) = (/&
&1.6381E-02_JPRB,1.8748E-02_JPRB,1.8546E-02_JPRB,1.7402E-02_JPRB,1.5774E-02_JPRB,1.3800E-02_JPRB,&
&1.1415E-02_JPRB,8.3305E-03_JPRB,5.3183E-03_JPRB,3.3227E-03_JPRB,4.1190E-03_JPRB/)
KAO( :, 1, 8, 4) = (/&
&1.0489E-02_JPRB,1.1350E-02_JPRB,1.1041E-02_JPRB,1.0421E-02_JPRB,9.4682E-03_JPRB,8.2685E-03_JPRB,&
&6.7870E-03_JPRB,4.8019E-03_JPRB,2.8904E-03_JPRB,1.6552E-03_JPRB,3.2034E-03_JPRB/)
KAO( :, 2, 8, 4) = (/&
&1.1308E-02_JPRB,1.2427E-02_JPRB,1.2159E-02_JPRB,1.1459E-02_JPRB,1.0373E-02_JPRB,9.0374E-03_JPRB,&
&7.4076E-03_JPRB,5.2450E-03_JPRB,3.1947E-03_JPRB,1.8626E-03_JPRB,3.5949E-03_JPRB/)
KAO( :, 3, 8, 4) = (/&
&1.2133E-02_JPRB,1.3516E-02_JPRB,1.3273E-02_JPRB,1.2475E-02_JPRB,1.1268E-02_JPRB,9.8130E-03_JPRB,&
&8.0528E-03_JPRB,5.7311E-03_JPRB,3.5370E-03_JPRB,2.1011E-03_JPRB,3.9889E-03_JPRB/)
KAO( :, 4, 8, 4) = (/&
&1.2965E-02_JPRB,1.4611E-02_JPRB,1.4368E-02_JPRB,1.3473E-02_JPRB,1.2174E-02_JPRB,1.0625E-02_JPRB,&
&8.7372E-03_JPRB,6.2577E-03_JPRB,3.9075E-03_JPRB,2.3709E-03_JPRB,4.3703E-03_JPRB/)
KAO( :, 5, 8, 4) = (/&
&1.3816E-02_JPRB,1.5699E-02_JPRB,1.5470E-02_JPRB,1.4502E-02_JPRB,1.3123E-02_JPRB,1.1467E-02_JPRB,&
&9.4537E-03_JPRB,6.8298E-03_JPRB,4.3093E-03_JPRB,2.6663E-03_JPRB,4.7512E-03_JPRB/)
KAO( :, 1, 9, 4) = (/&
&8.7568E-03_JPRB,9.3693E-03_JPRB,9.0975E-03_JPRB,8.5800E-03_JPRB,7.7896E-03_JPRB,6.7645E-03_JPRB,&
&5.5285E-03_JPRB,3.9033E-03_JPRB,2.3310E-03_JPRB,1.3217E-03_JPRB,4.5731E-03_JPRB/)
KAO( :, 2, 9, 4) = (/&
&9.4553E-03_JPRB,1.0293E-02_JPRB,1.0054E-02_JPRB,9.4845E-03_JPRB,8.5715E-03_JPRB,7.4310E-03_JPRB,&
&6.0526E-03_JPRB,4.2651E-03_JPRB,2.5747E-03_JPRB,1.4878E-03_JPRB,5.2597E-03_JPRB/)
KAO( :, 3, 9, 4) = (/&
&1.0173E-02_JPRB,1.1238E-02_JPRB,1.1012E-02_JPRB,1.0364E-02_JPRB,9.3410E-03_JPRB,8.0964E-03_JPRB,&
&6.6049E-03_JPRB,4.6620E-03_JPRB,2.8506E-03_JPRB,1.6770E-03_JPRB,5.9814E-03_JPRB/)
KAO( :, 4, 9, 4) = (/&
&1.0901E-02_JPRB,1.2188E-02_JPRB,1.1952E-02_JPRB,1.1222E-02_JPRB,1.0108E-02_JPRB,8.7846E-03_JPRB,&
&7.1864E-03_JPRB,5.1051E-03_JPRB,3.1528E-03_JPRB,1.8913E-03_JPRB,6.7372E-03_JPRB/)
KAO( :, 5, 9, 4) = (/&
&1.1643E-02_JPRB,1.3136E-02_JPRB,1.2896E-02_JPRB,1.2091E-02_JPRB,1.0918E-02_JPRB,9.5045E-03_JPRB,&
&7.7923E-03_JPRB,5.5824E-03_JPRB,3.4794E-03_JPRB,2.1303E-03_JPRB,7.5084E-03_JPRB/)
KAO( :, 1,10, 4) = (/&
&7.3210E-03_JPRB,7.7682E-03_JPRB,7.5348E-03_JPRB,7.0910E-03_JPRB,6.4276E-03_JPRB,5.5555E-03_JPRB,&
&4.5190E-03_JPRB,3.1874E-03_JPRB,1.8869E-03_JPRB,1.0615E-03_JPRB,8.5089E-03_JPRB/)
KAO( :, 2,10, 4) = (/&
&7.9160E-03_JPRB,8.5578E-03_JPRB,8.3513E-03_JPRB,7.8702E-03_JPRB,7.1056E-03_JPRB,6.1307E-03_JPRB,&
&4.9642E-03_JPRB,3.4828E-03_JPRB,2.0800E-03_JPRB,1.1948E-03_JPRB,9.8844E-03_JPRB/)
KAO( :, 3,10, 4) = (/&
&8.5286E-03_JPRB,9.3757E-03_JPRB,9.1726E-03_JPRB,8.6301E-03_JPRB,7.7707E-03_JPRB,6.7003E-03_JPRB,&
&5.4292E-03_JPRB,3.8086E-03_JPRB,2.3039E-03_JPRB,1.3482E-03_JPRB,1.1359E-02_JPRB/)
KAO( :, 4,10, 4) = (/&
&9.1631E-03_JPRB,1.0191E-02_JPRB,9.9769E-03_JPRB,9.3788E-03_JPRB,8.4243E-03_JPRB,7.2793E-03_JPRB,&
&5.9222E-03_JPRB,4.1756E-03_JPRB,2.5509E-03_JPRB,1.5190E-03_JPRB,1.2931E-02_JPRB/)
KAO( :, 5,10, 4) = (/&
&9.8113E-03_JPRB,1.1015E-02_JPRB,1.0788E-02_JPRB,1.0124E-02_JPRB,9.1153E-03_JPRB,7.8926E-03_JPRB,&
&6.4363E-03_JPRB,4.5749E-03_JPRB,2.8219E-03_JPRB,1.7121E-03_JPRB,1.4601E-02_JPRB/)
KAO( :, 1,11, 4) = (/&
&6.3238E-03_JPRB,6.7320E-03_JPRB,6.5341E-03_JPRB,6.1432E-03_JPRB,5.5500E-03_JPRB,4.7770E-03_JPRB,&
&3.8625E-03_JPRB,2.7098E-03_JPRB,1.5930E-03_JPRB,8.9971E-04_JPRB,1.0691E-02_JPRB/)
KAO( :, 2,11, 4) = (/&
&6.8377E-03_JPRB,7.4132E-03_JPRB,7.2351E-03_JPRB,6.8044E-03_JPRB,6.1328E-03_JPRB,5.2698E-03_JPRB,&
&4.2482E-03_JPRB,2.9626E-03_JPRB,1.7579E-03_JPRB,1.0147E-03_JPRB,1.2446E-02_JPRB/)
KAO( :, 3,11, 4) = (/&
&7.3680E-03_JPRB,8.1117E-03_JPRB,7.9281E-03_JPRB,7.4556E-03_JPRB,6.7022E-03_JPRB,5.7552E-03_JPRB,&
&4.6507E-03_JPRB,3.2459E-03_JPRB,1.9476E-03_JPRB,1.1453E-03_JPRB,1.4323E-02_JPRB/)
KAO( :, 4,11, 4) = (/&
&7.9250E-03_JPRB,8.8100E-03_JPRB,8.6199E-03_JPRB,8.1042E-03_JPRB,7.2716E-03_JPRB,6.2615E-03_JPRB,&
&5.0763E-03_JPRB,3.5597E-03_JPRB,2.1591E-03_JPRB,1.2891E-03_JPRB,1.6318E-02_JPRB/)
KAO( :, 5,11, 4) = (/&
&8.4995E-03_JPRB,9.5310E-03_JPRB,9.3303E-03_JPRB,8.7684E-03_JPRB,7.8755E-03_JPRB,6.7950E-03_JPRB,&
&5.5255E-03_JPRB,3.9023E-03_JPRB,2.3918E-03_JPRB,1.4517E-03_JPRB,1.8430E-02_JPRB/)
KAO( :, 1,12, 4) = (/&
&5.4239E-03_JPRB,5.7942E-03_JPRB,5.6254E-03_JPRB,5.2775E-03_JPRB,4.7538E-03_JPRB,4.0783E-03_JPRB,&
&3.2815E-03_JPRB,2.2911E-03_JPRB,1.3390E-03_JPRB,7.5901E-04_JPRB,1.1069E-02_JPRB/)
KAO( :, 2,12, 4) = (/&
&5.8650E-03_JPRB,6.3756E-03_JPRB,6.2146E-03_JPRB,5.8301E-03_JPRB,5.2465E-03_JPRB,4.4949E-03_JPRB,&
&3.6123E-03_JPRB,2.5101E-03_JPRB,1.4788E-03_JPRB,8.5773E-04_JPRB,1.2922E-02_JPRB/)
KAO( :, 3,12, 4) = (/&
&6.3326E-03_JPRB,6.9605E-03_JPRB,6.7926E-03_JPRB,6.3822E-03_JPRB,5.7295E-03_JPRB,4.9116E-03_JPRB,&
&3.9590E-03_JPRB,2.7527E-03_JPRB,1.6402E-03_JPRB,9.6785E-04_JPRB,1.4890E-02_JPRB/)
KAO( :, 4,12, 4) = (/&
&6.8197E-03_JPRB,7.5612E-03_JPRB,7.3901E-03_JPRB,6.9407E-03_JPRB,6.2248E-03_JPRB,5.3513E-03_JPRB,&
&4.3255E-03_JPRB,3.0215E-03_JPRB,1.8202E-03_JPRB,1.0893E-03_JPRB,1.6968E-02_JPRB/)
KAO( :, 5,12, 4) = (/&
&7.3239E-03_JPRB,8.1869E-03_JPRB,8.0102E-03_JPRB,7.5305E-03_JPRB,6.7534E-03_JPRB,5.8184E-03_JPRB,&
&4.7200E-03_JPRB,3.3172E-03_JPRB,2.0173E-03_JPRB,1.2265E-03_JPRB,1.9174E-02_JPRB/)
KAO( :, 1,13, 4) = (/&
&4.6050E-03_JPRB,4.9342E-03_JPRB,4.7817E-03_JPRB,4.4662E-03_JPRB,4.0147E-03_JPRB,3.4350E-03_JPRB,&
&2.7500E-03_JPRB,1.9135E-03_JPRB,1.1150E-03_JPRB,6.3435E-04_JPRB,9.6482E-03_JPRB/)
KAO( :, 2,13, 4) = (/&
&4.9867E-03_JPRB,5.4199E-03_JPRB,5.2643E-03_JPRB,4.9240E-03_JPRB,4.4219E-03_JPRB,3.7782E-03_JPRB,&
&3.0269E-03_JPRB,2.1006E-03_JPRB,1.2335E-03_JPRB,7.1745E-04_JPRB,1.1271E-02_JPRB/)
KAO( :, 3,13, 4) = (/&
&5.3971E-03_JPRB,5.9114E-03_JPRB,5.7510E-03_JPRB,5.3855E-03_JPRB,4.8287E-03_JPRB,4.1310E-03_JPRB,&
&3.3205E-03_JPRB,2.3075E-03_JPRB,1.3695E-03_JPRB,8.0946E-04_JPRB,1.2985E-02_JPRB/)
KAO( :, 4,13, 4) = (/&
&5.8203E-03_JPRB,6.4262E-03_JPRB,6.2609E-03_JPRB,5.8661E-03_JPRB,5.2552E-03_JPRB,4.5068E-03_JPRB,&
&3.6338E-03_JPRB,2.5380E-03_JPRB,1.5209E-03_JPRB,9.1160E-04_JPRB,1.4785E-02_JPRB/)
KAO( :, 5,13, 4) = (/&
&6.2608E-03_JPRB,6.9642E-03_JPRB,6.7991E-03_JPRB,6.3791E-03_JPRB,5.7139E-03_JPRB,4.9101E-03_JPRB,&
&3.9752E-03_JPRB,2.7918E-03_JPRB,1.6870E-03_JPRB,1.0277E-03_JPRB,1.6692E-02_JPRB/)
KAO( :, 1, 1, 5) = (/&
&6.9423E-02_JPRB,7.4960E-02_JPRB,7.2881E-02_JPRB,6.7852E-02_JPRB,6.0804E-02_JPRB,5.2531E-02_JPRB,&
&4.2824E-02_JPRB,3.0610E-02_JPRB,1.9045E-02_JPRB,1.1972E-02_JPRB,9.0656E-03_JPRB/)
KAO( :, 2, 1, 5) = (/&
&7.1301E-02_JPRB,7.7925E-02_JPRB,7.6064E-02_JPRB,7.1198E-02_JPRB,6.4170E-02_JPRB,5.6008E-02_JPRB,&
&4.6002E-02_JPRB,3.3219E-02_JPRB,2.0898E-02_JPRB,1.3541E-02_JPRB,1.0844E-02_JPRB/)
KAO( :, 3, 1, 5) = (/&
&7.2960E-02_JPRB,8.0744E-02_JPRB,7.9397E-02_JPRB,7.4686E-02_JPRB,6.7915E-02_JPRB,5.9615E-02_JPRB,&
&4.9205E-02_JPRB,3.5928E-02_JPRB,2.2906E-02_JPRB,1.5284E-02_JPRB,1.2853E-02_JPRB/)
KAO( :, 4, 1, 5) = (/&
&7.4482E-02_JPRB,8.3568E-02_JPRB,8.2751E-02_JPRB,7.8370E-02_JPRB,7.1840E-02_JPRB,6.3241E-02_JPRB,&
&5.2611E-02_JPRB,3.8800E-02_JPRB,2.5071E-02_JPRB,1.7190E-02_JPRB,1.5078E-02_JPRB/)
KAO( :, 5, 1, 5) = (/&
&7.5977E-02_JPRB,8.6416E-02_JPRB,8.6132E-02_JPRB,8.2229E-02_JPRB,7.5721E-02_JPRB,6.7015E-02_JPRB,&
&5.6188E-02_JPRB,4.1791E-02_JPRB,2.7379E-02_JPRB,1.9319E-02_JPRB,1.7544E-02_JPRB/)
KAO( :, 1, 2, 5) = (/&
&6.1428E-02_JPRB,6.6243E-02_JPRB,6.4016E-02_JPRB,5.9686E-02_JPRB,5.3408E-02_JPRB,4.5905E-02_JPRB,&
&3.7325E-02_JPRB,2.6638E-02_JPRB,1.6539E-02_JPRB,1.0261E-02_JPRB,7.2943E-03_JPRB/)
KAO( :, 2, 2, 5) = (/&
&6.3157E-02_JPRB,6.8963E-02_JPRB,6.7035E-02_JPRB,6.2877E-02_JPRB,5.6628E-02_JPRB,4.9107E-02_JPRB,&
&4.0147E-02_JPRB,2.8970E-02_JPRB,1.8198E-02_JPRB,1.1562E-02_JPRB,8.6747E-03_JPRB/)
KAO( :, 3, 2, 5) = (/&
&6.4729E-02_JPRB,7.1653E-02_JPRB,7.0183E-02_JPRB,6.6237E-02_JPRB,6.0087E-02_JPRB,5.2347E-02_JPRB,&
&4.3083E-02_JPRB,3.1429E-02_JPRB,1.9978E-02_JPRB,1.2998E-02_JPRB,1.0260E-02_JPRB/)
KAO( :, 4, 2, 5) = (/&
&6.6252E-02_JPRB,7.4355E-02_JPRB,7.3321E-02_JPRB,6.9741E-02_JPRB,6.3553E-02_JPRB,5.5697E-02_JPRB,&
&4.6228E-02_JPRB,3.4024E-02_JPRB,2.1871E-02_JPRB,1.4556E-02_JPRB,1.2034E-02_JPRB/)
KAO( :, 5, 2, 5) = (/&
&6.7782E-02_JPRB,7.7009E-02_JPRB,7.6503E-02_JPRB,7.3173E-02_JPRB,6.7016E-02_JPRB,5.9180E-02_JPRB,&
&4.9505E-02_JPRB,3.6707E-02_JPRB,2.3887E-02_JPRB,1.6290E-02_JPRB,1.4004E-02_JPRB/)
KAO( :, 1, 3, 5) = (/&
&5.3533E-02_JPRB,5.7434E-02_JPRB,5.5277E-02_JPRB,5.1527E-02_JPRB,4.6035E-02_JPRB,3.9352E-02_JPRB,&
&3.1746E-02_JPRB,2.2523E-02_JPRB,1.3908E-02_JPRB,8.6490E-03_JPRB,5.9287E-03_JPRB/)
KAO( :, 2, 3, 5) = (/&
&5.5137E-02_JPRB,5.9969E-02_JPRB,5.8097E-02_JPRB,5.4502E-02_JPRB,4.8980E-02_JPRB,4.2173E-02_JPRB,&
&3.4244E-02_JPRB,2.4566E-02_JPRB,1.5350E-02_JPRB,9.6962E-03_JPRB,6.9493E-03_JPRB/)
KAO( :, 3, 3, 5) = (/&
&5.6675E-02_JPRB,6.2431E-02_JPRB,6.0975E-02_JPRB,5.7589E-02_JPRB,5.2056E-02_JPRB,4.5047E-02_JPRB,&
&3.6855E-02_JPRB,2.6729E-02_JPRB,1.6909E-02_JPRB,1.0855E-02_JPRB,8.1206E-03_JPRB/)
KAO( :, 4, 3, 5) = (/&
&5.8200E-02_JPRB,6.4923E-02_JPRB,6.3882E-02_JPRB,6.0753E-02_JPRB,5.5077E-02_JPRB,4.8037E-02_JPRB,&
&3.9643E-02_JPRB,2.9018E-02_JPRB,1.8575E-02_JPRB,1.2121E-02_JPRB,9.4750E-03_JPRB/)
KAO( :, 5, 3, 5) = (/&
&5.9733E-02_JPRB,6.7416E-02_JPRB,6.6842E-02_JPRB,6.3776E-02_JPRB,5.8159E-02_JPRB,5.1164E-02_JPRB,&
&4.2585E-02_JPRB,3.1380E-02_JPRB,2.0348E-02_JPRB,1.3514E-02_JPRB,1.0998E-02_JPRB/)
KAO( :, 1, 4, 5) = (/&
&4.6353E-02_JPRB,4.9264E-02_JPRB,4.7316E-02_JPRB,4.4016E-02_JPRB,3.9303E-02_JPRB,3.3446E-02_JPRB,&
&2.6720E-02_JPRB,1.8817E-02_JPRB,1.1541E-02_JPRB,7.2722E-03_JPRB,5.4712E-03_JPRB/)
KAO( :, 2, 4, 5) = (/&
&4.7832E-02_JPRB,5.1575E-02_JPRB,4.9905E-02_JPRB,4.6721E-02_JPRB,4.1940E-02_JPRB,3.5924E-02_JPRB,&
&2.8909E-02_JPRB,2.0563E-02_JPRB,1.2756E-02_JPRB,8.1360E-03_JPRB,6.2894E-03_JPRB/)
KAO( :, 3, 4, 5) = (/&
&4.9292E-02_JPRB,5.3845E-02_JPRB,5.2477E-02_JPRB,4.9511E-02_JPRB,4.4682E-02_JPRB,3.8438E-02_JPRB,&
&3.1206E-02_JPRB,2.2430E-02_JPRB,1.4083E-02_JPRB,9.0822E-03_JPRB,7.2079E-03_JPRB/)
KAO( :, 4, 4, 5) = (/&
&5.0753E-02_JPRB,5.6167E-02_JPRB,5.5096E-02_JPRB,5.2291E-02_JPRB,4.7354E-02_JPRB,4.1051E-02_JPRB,&
&3.3627E-02_JPRB,2.4418E-02_JPRB,1.5508E-02_JPRB,1.0111E-02_JPRB,8.2258E-03_JPRB/)
KAO( :, 5, 4, 5) = (/&
&5.2237E-02_JPRB,5.8453E-02_JPRB,5.7807E-02_JPRB,5.4969E-02_JPRB,5.0043E-02_JPRB,4.3750E-02_JPRB,&
&3.6221E-02_JPRB,2.6492E-02_JPRB,1.7044E-02_JPRB,1.1243E-02_JPRB,9.3585E-03_JPRB/)
KAO( :, 1, 5, 5) = (/&
&4.0215E-02_JPRB,4.2178E-02_JPRB,4.0345E-02_JPRB,3.7366E-02_JPRB,3.3354E-02_JPRB,2.8283E-02_JPRB,&
&2.2446E-02_JPRB,1.5692E-02_JPRB,9.5378E-03_JPRB,6.0574E-03_JPRB,5.0927E-03_JPRB/)
KAO( :, 2, 5, 5) = (/&
&4.1564E-02_JPRB,4.4223E-02_JPRB,4.2656E-02_JPRB,3.9744E-02_JPRB,3.5712E-02_JPRB,3.0486E-02_JPRB,&
&2.4325E-02_JPRB,1.7173E-02_JPRB,1.0563E-02_JPRB,6.7992E-03_JPRB,5.7848E-03_JPRB/)
KAO( :, 3, 5, 5) = (/&
&4.2880E-02_JPRB,4.6295E-02_JPRB,4.4929E-02_JPRB,4.2198E-02_JPRB,3.8104E-02_JPRB,3.2711E-02_JPRB,&
&2.6325E-02_JPRB,1.8758E-02_JPRB,1.1674E-02_JPRB,7.6073E-03_JPRB,6.5722E-03_JPRB/)
KAO( :, 4, 5, 5) = (/&
&4.4250E-02_JPRB,4.8374E-02_JPRB,4.7253E-02_JPRB,4.4669E-02_JPRB,4.0477E-02_JPRB,3.4961E-02_JPRB,&
&2.8432E-02_JPRB,2.0449E-02_JPRB,1.2880E-02_JPRB,8.4762E-03_JPRB,7.4570E-03_JPRB/)
KAO( :, 5, 5, 5) = (/&
&4.5632E-02_JPRB,5.0457E-02_JPRB,4.9661E-02_JPRB,4.7073E-02_JPRB,4.2857E-02_JPRB,3.7281E-02_JPRB,&
&3.0645E-02_JPRB,2.2241E-02_JPRB,1.4179E-02_JPRB,9.4224E-03_JPRB,8.4289E-03_JPRB/)
KAO( :, 1, 6, 5) = (/&
&3.4853E-02_JPRB,3.6094E-02_JPRB,3.4340E-02_JPRB,3.1567E-02_JPRB,2.8074E-02_JPRB,2.3747E-02_JPRB,&
&1.8747E-02_JPRB,1.3033E-02_JPRB,7.8344E-03_JPRB,4.9564E-03_JPRB,4.7664E-03_JPRB/)
KAO( :, 2, 6, 5) = (/&
&3.6095E-02_JPRB,3.7902E-02_JPRB,3.6360E-02_JPRB,3.3627E-02_JPRB,3.0131E-02_JPRB,2.5638E-02_JPRB,&
&2.0371E-02_JPRB,1.4275E-02_JPRB,8.6972E-03_JPRB,5.5735E-03_JPRB,5.3896E-03_JPRB/)
KAO( :, 3, 6, 5) = (/&
&3.7297E-02_JPRB,3.9745E-02_JPRB,3.8353E-02_JPRB,3.5764E-02_JPRB,3.2219E-02_JPRB,2.7550E-02_JPRB,&
&2.2085E-02_JPRB,1.5615E-02_JPRB,9.6284E-03_JPRB,6.2556E-03_JPRB,6.0790E-03_JPRB/)
KAO( :, 4, 6, 5) = (/&
&3.8557E-02_JPRB,4.1597E-02_JPRB,4.0389E-02_JPRB,3.7908E-02_JPRB,3.4281E-02_JPRB,2.9507E-02_JPRB,&
&2.3870E-02_JPRB,1.7046E-02_JPRB,1.0643E-02_JPRB,7.0034E-03_JPRB,6.8484E-03_JPRB/)
KAO( :, 5, 6, 5) = (/&
&3.9824E-02_JPRB,4.3464E-02_JPRB,4.2478E-02_JPRB,4.0047E-02_JPRB,3.6382E-02_JPRB,3.1522E-02_JPRB,&
&2.5736E-02_JPRB,1.8573E-02_JPRB,1.1739E-02_JPRB,7.8250E-03_JPRB,7.7029E-03_JPRB/)
KAO( :, 1, 7, 5) = (/&
&2.9815E-02_JPRB,3.0608E-02_JPRB,2.8988E-02_JPRB,2.6483E-02_JPRB,2.3444E-02_JPRB,1.9806E-02_JPRB,&
&1.5587E-02_JPRB,1.0729E-02_JPRB,6.3834E-03_JPRB,3.9988E-03_JPRB,4.7710E-03_JPRB/)
KAO( :, 2, 7, 5) = (/&
&3.0946E-02_JPRB,3.2211E-02_JPRB,3.0727E-02_JPRB,2.8262E-02_JPRB,2.5215E-02_JPRB,2.1406E-02_JPRB,&
&1.6940E-02_JPRB,1.1789E-02_JPRB,7.0925E-03_JPRB,4.5059E-03_JPRB,5.3365E-03_JPRB/)
KAO( :, 3, 7, 5) = (/&
&3.2060E-02_JPRB,3.3823E-02_JPRB,3.2464E-02_JPRB,3.0099E-02_JPRB,2.7004E-02_JPRB,2.3026E-02_JPRB,&
&1.8369E-02_JPRB,1.2921E-02_JPRB,7.8758E-03_JPRB,5.0685E-03_JPRB,5.9857E-03_JPRB/)
KAO( :, 4, 7, 5) = (/&
&3.3198E-02_JPRB,3.5483E-02_JPRB,3.4283E-02_JPRB,3.1964E-02_JPRB,2.8781E-02_JPRB,2.4689E-02_JPRB,&
&1.9856E-02_JPRB,1.4137E-02_JPRB,8.7260E-03_JPRB,5.6932E-03_JPRB,6.6962E-03_JPRB/)
KAO( :, 5, 7, 5) = (/&
&3.4342E-02_JPRB,3.7144E-02_JPRB,3.6117E-02_JPRB,3.3825E-02_JPRB,3.0620E-02_JPRB,2.6411E-02_JPRB,&
&2.1416E-02_JPRB,1.5421E-02_JPRB,9.6443E-03_JPRB,6.3905E-03_JPRB,7.4882E-03_JPRB/)
KAO( :, 1, 8, 5) = (/&
&2.5283E-02_JPRB,2.5751E-02_JPRB,2.4270E-02_JPRB,2.2079E-02_JPRB,1.9496E-02_JPRB,1.6496E-02_JPRB,&
&1.2947E-02_JPRB,8.8078E-03_JPRB,5.1661E-03_JPRB,3.1956E-03_JPRB,5.6775E-03_JPRB/)
KAO( :, 2, 8, 5) = (/&
&2.6302E-02_JPRB,2.7180E-02_JPRB,2.5781E-02_JPRB,2.3615E-02_JPRB,2.1015E-02_JPRB,1.7843E-02_JPRB,&
&1.4097E-02_JPRB,9.7060E-03_JPRB,5.7494E-03_JPRB,3.6083E-03_JPRB,6.1622E-03_JPRB/)
KAO( :, 3, 8, 5) = (/&
&2.7320E-02_JPRB,2.8593E-02_JPRB,2.7305E-02_JPRB,2.5195E-02_JPRB,2.2546E-02_JPRB,1.9223E-02_JPRB,&
&1.5282E-02_JPRB,1.0665E-02_JPRB,6.3913E-03_JPRB,4.0728E-03_JPRB,6.7057E-03_JPRB/)
KAO( :, 4, 8, 5) = (/&
&2.8333E-02_JPRB,3.0041E-02_JPRB,2.8915E-02_JPRB,2.6829E-02_JPRB,2.4088E-02_JPRB,2.0635E-02_JPRB,&
&1.6522E-02_JPRB,1.1685E-02_JPRB,7.1066E-03_JPRB,4.5896E-03_JPRB,7.3455E-03_JPRB/)
KAO( :, 5, 8, 5) = (/&
&2.9349E-02_JPRB,3.1526E-02_JPRB,3.0540E-02_JPRB,2.8464E-02_JPRB,2.5707E-02_JPRB,2.2109E-02_JPRB,&
&1.7816E-02_JPRB,1.2753E-02_JPRB,7.8746E-03_JPRB,5.1734E-03_JPRB,8.0746E-03_JPRB/)
KAO( :, 1, 9, 5) = (/&
&2.1393E-02_JPRB,2.1598E-02_JPRB,2.0242E-02_JPRB,1.8370E-02_JPRB,1.6186E-02_JPRB,1.3706E-02_JPRB,&
&1.0722E-02_JPRB,7.2195E-03_JPRB,4.1746E-03_JPRB,2.5439E-03_JPRB,1.0113E-02_JPRB/)
KAO( :, 2, 9, 5) = (/&
&2.2301E-02_JPRB,2.2863E-02_JPRB,2.1562E-02_JPRB,1.9670E-02_JPRB,1.7466E-02_JPRB,1.4848E-02_JPRB,&
&1.1705E-02_JPRB,7.9781E-03_JPRB,4.6436E-03_JPRB,2.8718E-03_JPRB,1.1342E-02_JPRB/)
KAO( :, 3, 9, 5) = (/&
&2.3221E-02_JPRB,2.4089E-02_JPRB,2.2883E-02_JPRB,2.1022E-02_JPRB,1.8774E-02_JPRB,1.6030E-02_JPRB,&
&1.2717E-02_JPRB,8.7854E-03_JPRB,5.1730E-03_JPRB,3.2515E-03_JPRB,1.2507E-02_JPRB/)
KAO( :, 4, 9, 5) = (/&
&2.4120E-02_JPRB,2.5343E-02_JPRB,2.4280E-02_JPRB,2.2425E-02_JPRB,2.0119E-02_JPRB,1.7244E-02_JPRB,&
&1.3767E-02_JPRB,9.6361E-03_JPRB,5.7611E-03_JPRB,3.6765E-03_JPRB,1.3554E-02_JPRB/)
KAO( :, 5, 9, 5) = (/&
&2.5016E-02_JPRB,2.6638E-02_JPRB,2.5702E-02_JPRB,2.3865E-02_JPRB,2.1516E-02_JPRB,1.8508E-02_JPRB,&
&1.4864E-02_JPRB,1.0529E-02_JPRB,6.4045E-03_JPRB,4.1546E-03_JPRB,1.4572E-02_JPRB/)
KAO( :, 1,10, 5) = (/&
&1.8113E-02_JPRB,1.8138E-02_JPRB,1.6915E-02_JPRB,1.5326E-02_JPRB,1.3493E-02_JPRB,1.1404E-02_JPRB,&
&8.8894E-03_JPRB,5.9161E-03_JPRB,3.3974E-03_JPRB,2.0400E-03_JPRB,2.3155E-02_JPRB/)
KAO( :, 2,10, 5) = (/&
&1.8911E-02_JPRB,1.9233E-02_JPRB,1.8049E-02_JPRB,1.6433E-02_JPRB,1.4556E-02_JPRB,1.2371E-02_JPRB,&
&9.7152E-03_JPRB,6.5645E-03_JPRB,3.7859E-03_JPRB,2.2984E-03_JPRB,2.6502E-02_JPRB/)
KAO( :, 3,10, 5) = (/&
&1.9728E-02_JPRB,2.0295E-02_JPRB,1.9188E-02_JPRB,1.7578E-02_JPRB,1.5660E-02_JPRB,1.3378E-02_JPRB,&
&1.0586E-02_JPRB,7.2492E-03_JPRB,4.2176E-03_JPRB,2.6036E-03_JPRB,2.9732E-02_JPRB/)
KAO( :, 4,10, 5) = (/&
&2.0511E-02_JPRB,2.1373E-02_JPRB,2.0386E-02_JPRB,1.8762E-02_JPRB,1.6821E-02_JPRB,1.4424E-02_JPRB,&
&1.1488E-02_JPRB,7.9631E-03_JPRB,4.7001E-03_JPRB,2.9535E-03_JPRB,3.2827E-02_JPRB/)
KAO( :, 5,10, 5) = (/&
&2.1304E-02_JPRB,2.2491E-02_JPRB,2.1602E-02_JPRB,2.0004E-02_JPRB,1.8011E-02_JPRB,1.5518E-02_JPRB,&
&1.2440E-02_JPRB,8.7186E-03_JPRB,5.2306E-03_JPRB,3.3445E-03_JPRB,3.5819E-02_JPRB/)
KAO( :, 1,11, 5) = (/&
&1.5695E-02_JPRB,1.5702E-02_JPRB,1.4638E-02_JPRB,1.3267E-02_JPRB,1.1679E-02_JPRB,9.8503E-03_JPRB,&
&7.6677E-03_JPRB,5.0761E-03_JPRB,2.9053E-03_JPRB,1.7228E-03_JPRB,2.9993E-02_JPRB/)
KAO( :, 2,11, 5) = (/&
&1.6401E-02_JPRB,1.6637E-02_JPRB,1.5599E-02_JPRB,1.4214E-02_JPRB,1.2583E-02_JPRB,1.0686E-02_JPRB,&
&8.3766E-03_JPRB,5.6416E-03_JPRB,3.2428E-03_JPRB,1.9419E-03_JPRB,3.4197E-02_JPRB/)
KAO( :, 3,11, 5) = (/&
&1.7106E-02_JPRB,1.7559E-02_JPRB,1.6602E-02_JPRB,1.5204E-02_JPRB,1.3537E-02_JPRB,1.1563E-02_JPRB,&
&9.1295E-03_JPRB,6.2308E-03_JPRB,3.6142E-03_JPRB,2.2018E-03_JPRB,3.8237E-02_JPRB/)
KAO( :, 4,11, 5) = (/&
&1.7783E-02_JPRB,1.8504E-02_JPRB,1.7628E-02_JPRB,1.6229E-02_JPRB,1.4542E-02_JPRB,1.2483E-02_JPRB,&
&9.9207E-03_JPRB,6.8466E-03_JPRB,4.0263E-03_JPRB,2.5043E-03_JPRB,4.2149E-02_JPRB/)
KAO( :, 5,11, 5) = (/&
&1.8493E-02_JPRB,1.9485E-02_JPRB,1.8676E-02_JPRB,1.7295E-02_JPRB,1.5575E-02_JPRB,1.3438E-02_JPRB,&
&1.0754E-02_JPRB,7.5058E-03_JPRB,4.4801E-03_JPRB,2.8413E-03_JPRB,4.5923E-02_JPRB/)
KAO( :, 1,12, 5) = (/&
&1.3506E-02_JPRB,1.3529E-02_JPRB,1.2628E-02_JPRB,1.1452E-02_JPRB,1.0063E-02_JPRB,8.4685E-03_JPRB,&
&6.5828E-03_JPRB,4.3370E-03_JPRB,2.4676E-03_JPRB,1.4501E-03_JPRB,3.1379E-02_JPRB/)
KAO( :, 2,12, 5) = (/&
&1.4125E-02_JPRB,1.4325E-02_JPRB,1.3451E-02_JPRB,1.2271E-02_JPRB,1.0846E-02_JPRB,9.1944E-03_JPRB,&
&7.1930E-03_JPRB,4.8218E-03_JPRB,2.7588E-03_JPRB,1.6351E-03_JPRB,3.5598E-02_JPRB/)
KAO( :, 3,12, 5) = (/&
&1.4721E-02_JPRB,1.5127E-02_JPRB,1.4318E-02_JPRB,1.3125E-02_JPRB,1.1678E-02_JPRB,9.9571E-03_JPRB,&
&7.8415E-03_JPRB,5.3248E-03_JPRB,3.0763E-03_JPRB,1.8570E-03_JPRB,3.9752E-02_JPRB/)
KAO( :, 4,12, 5) = (/&
&1.5317E-02_JPRB,1.5950E-02_JPRB,1.5202E-02_JPRB,1.4009E-02_JPRB,1.2540E-02_JPRB,1.0752E-02_JPRB,&
&8.5246E-03_JPRB,5.8565E-03_JPRB,3.4251E-03_JPRB,2.1158E-03_JPRB,4.3744E-02_JPRB/)
KAO( :, 5,12, 5) = (/&
&1.5969E-02_JPRB,1.6812E-02_JPRB,1.6124E-02_JPRB,1.4932E-02_JPRB,1.3442E-02_JPRB,1.1579E-02_JPRB,&
&9.2378E-03_JPRB,6.4203E-03_JPRB,3.8147E-03_JPRB,2.4036E-03_JPRB,4.7604E-02_JPRB/)
KAO( :, 1,13, 5) = (/&
&1.1399E-02_JPRB,1.1449E-02_JPRB,1.0710E-02_JPRB,9.7174E-03_JPRB,8.5323E-03_JPRB,7.1730E-03_JPRB,&
&5.5827E-03_JPRB,3.6682E-03_JPRB,2.0730E-03_JPRB,1.2124E-03_JPRB,2.7163E-02_JPRB/)
KAO( :, 2,13, 5) = (/&
&1.1916E-02_JPRB,1.2118E-02_JPRB,1.1410E-02_JPRB,1.0424E-02_JPRB,9.2099E-03_JPRB,7.8054E-03_JPRB,&
&6.1073E-03_JPRB,4.0757E-03_JPRB,2.3191E-03_JPRB,1.3693E-03_JPRB,3.0692E-02_JPRB/)
KAO( :, 3,13, 5) = (/&
&1.2413E-02_JPRB,1.2810E-02_JPRB,1.2156E-02_JPRB,1.1166E-02_JPRB,9.9300E-03_JPRB,8.4666E-03_JPRB,&
&6.6637E-03_JPRB,4.5036E-03_JPRB,2.5869E-03_JPRB,1.5580E-03_JPRB,3.4158E-02_JPRB/)
KAO( :, 4,13, 5) = (/&
&1.2945E-02_JPRB,1.3524E-02_JPRB,1.2930E-02_JPRB,1.1934E-02_JPRB,1.0680E-02_JPRB,9.1538E-03_JPRB,&
&7.2492E-03_JPRB,4.9532E-03_JPRB,2.8844E-03_JPRB,1.7769E-03_JPRB,3.7486E-02_JPRB/)
KAO( :, 5,13, 5) = (/&
&1.3534E-02_JPRB,1.4296E-02_JPRB,1.3748E-02_JPRB,1.2750E-02_JPRB,1.1472E-02_JPRB,9.8678E-03_JPRB,&
&7.8555E-03_JPRB,5.4258E-03_JPRB,3.2161E-03_JPRB,2.0203E-03_JPRB,4.0660E-02_JPRB/)
KAO( :, 1, 1, 6) = (/&
&1.3812E-01_JPRB,1.3826E-01_JPRB,1.3412E-01_JPRB,1.2512E-01_JPRB,1.1224E-01_JPRB,9.5217E-02_JPRB,&
&7.4976E-02_JPRB,5.1336E-02_JPRB,3.0614E-02_JPRB,2.1696E-02_JPRB,2.0374E-02_JPRB/)
KAO( :, 2, 1, 6) = (/&
&1.3941E-01_JPRB,1.4212E-01_JPRB,1.3899E-01_JPRB,1.3015E-01_JPRB,1.1723E-01_JPRB,9.9705E-02_JPRB,&
&7.9423E-02_JPRB,5.5251E-02_JPRB,3.3932E-02_JPRB,2.4851E-02_JPRB,2.3928E-02_JPRB/)
KAO( :, 3, 1, 6) = (/&
&1.4069E-01_JPRB,1.4606E-01_JPRB,1.4349E-01_JPRB,1.3492E-01_JPRB,1.2182E-01_JPRB,1.0431E-01_JPRB,&
&8.4373E-02_JPRB,5.9330E-02_JPRB,3.7520E-02_JPRB,2.8503E-02_JPRB,2.7981E-02_JPRB/)
KAO( :, 4, 1, 6) = (/&
&1.4204E-01_JPRB,1.4980E-01_JPRB,1.4773E-01_JPRB,1.3955E-01_JPRB,1.2635E-01_JPRB,1.0953E-01_JPRB,&
&8.9320E-02_JPRB,6.3663E-02_JPRB,4.1464E-02_JPRB,3.2709E-02_JPRB,3.2519E-02_JPRB/)
KAO( :, 5, 1, 6) = (/&
&1.4335E-01_JPRB,1.5332E-01_JPRB,1.5190E-01_JPRB,1.4393E-01_JPRB,1.3131E-01_JPRB,1.1498E-01_JPRB,&
&9.4231E-02_JPRB,6.8373E-02_JPRB,4.5718E-02_JPRB,3.7379E-02_JPRB,3.7561E-02_JPRB/)
KAO( :, 1, 2, 6) = (/&
&1.2540E-01_JPRB,1.2569E-01_JPRB,1.2163E-01_JPRB,1.1284E-01_JPRB,1.0119E-01_JPRB,8.6267E-02_JPRB,&
&6.7814E-02_JPRB,4.6281E-02_JPRB,2.7026E-02_JPRB,1.8209E-02_JPRB,1.6155E-02_JPRB/)
KAO( :, 2, 2, 6) = (/&
&1.2690E-01_JPRB,1.2947E-01_JPRB,1.2609E-01_JPRB,1.1758E-01_JPRB,1.0596E-01_JPRB,9.0648E-02_JPRB,&
&7.2085E-02_JPRB,4.9891E-02_JPRB,2.9876E-02_JPRB,2.0766E-02_JPRB,1.9045E-02_JPRB/)
KAO( :, 3, 2, 6) = (/&
&1.2845E-01_JPRB,1.3318E-01_JPRB,1.3033E-01_JPRB,1.2211E-01_JPRB,1.1052E-01_JPRB,9.5256E-02_JPRB,&
&7.6664E-02_JPRB,5.3627E-02_JPRB,3.2984E-02_JPRB,2.3750E-02_JPRB,2.2338E-02_JPRB/)
KAO( :, 4, 2, 6) = (/&
&1.2994E-01_JPRB,1.3679E-01_JPRB,1.3454E-01_JPRB,1.2649E-01_JPRB,1.1513E-01_JPRB,1.0018E-01_JPRB,&
&8.1132E-02_JPRB,5.7623E-02_JPRB,3.6417E-02_JPRB,2.7177E-02_JPRB,2.6047E-02_JPRB/)
KAO( :, 5, 2, 6) = (/&
&1.3135E-01_JPRB,1.4032E-01_JPRB,1.3874E-01_JPRB,1.3096E-01_JPRB,1.2020E-01_JPRB,1.0521E-01_JPRB,&
&8.5803E-02_JPRB,6.1991E-02_JPRB,4.0111E-02_JPRB,3.0993E-02_JPRB,3.0183E-02_JPRB/)
KAO( :, 1, 3, 6) = (/&
&1.1249E-01_JPRB,1.1241E-01_JPRB,1.0797E-01_JPRB,9.9582E-02_JPRB,8.8991E-02_JPRB,7.6122E-02_JPRB,&
&5.9776E-02_JPRB,4.0423E-02_JPRB,2.3381E-02_JPRB,1.4989E-02_JPRB,1.2392E-02_JPRB/)
KAO( :, 2, 3, 6) = (/&
&1.1410E-01_JPRB,1.1606E-01_JPRB,1.1205E-01_JPRB,1.0392E-01_JPRB,9.3538E-02_JPRB,8.0374E-02_JPRB,&
&6.3755E-02_JPRB,4.3750E-02_JPRB,2.5848E-02_JPRB,1.7065E-02_JPRB,1.4647E-02_JPRB/)
KAO( :, 3, 3, 6) = (/&
&1.1569E-01_JPRB,1.1965E-01_JPRB,1.1613E-01_JPRB,1.0831E-01_JPRB,9.7905E-02_JPRB,8.4765E-02_JPRB,&
&6.7839E-02_JPRB,4.7191E-02_JPRB,2.8514E-02_JPRB,1.9425E-02_JPRB,1.7233E-02_JPRB/)
KAO( :, 4, 3, 6) = (/&
&1.1726E-01_JPRB,1.2309E-01_JPRB,1.2032E-01_JPRB,1.1259E-01_JPRB,1.0247E-01_JPRB,8.9387E-02_JPRB,&
&7.1928E-02_JPRB,5.0787E-02_JPRB,3.1455E-02_JPRB,2.2128E-02_JPRB,2.0137E-02_JPRB/)
KAO( :, 5, 3, 6) = (/&
&1.1874E-01_JPRB,1.2658E-01_JPRB,1.2440E-01_JPRB,1.1705E-01_JPRB,1.0739E-01_JPRB,9.3857E-02_JPRB,&
&7.6244E-02_JPRB,5.4771E-02_JPRB,3.4624E-02_JPRB,2.5158E-02_JPRB,2.3398E-02_JPRB/)
KAO( :, 1, 4, 6) = (/&
&1.0010E-01_JPRB,9.9685E-02_JPRB,9.4787E-02_JPRB,8.6882E-02_JPRB,7.7198E-02_JPRB,6.5934E-02_JPRB,&
&5.1807E-02_JPRB,3.4736E-02_JPRB,1.9980E-02_JPRB,1.2335E-02_JPRB,1.0141E-02_JPRB/)
KAO( :, 2, 4, 6) = (/&
&1.0170E-01_JPRB,1.0312E-01_JPRB,9.8622E-02_JPRB,9.0905E-02_JPRB,8.1426E-02_JPRB,6.9900E-02_JPRB,&
&5.5494E-02_JPRB,3.7661E-02_JPRB,2.2134E-02_JPRB,1.4013E-02_JPRB,1.1758E-02_JPRB/)
KAO( :, 3, 4, 6) = (/&
&1.0335E-01_JPRB,1.0651E-01_JPRB,1.0245E-01_JPRB,9.5068E-02_JPRB,8.5570E-02_JPRB,7.4056E-02_JPRB,&
&5.9162E-02_JPRB,4.0698E-02_JPRB,2.4492E-02_JPRB,1.5920E-02_JPRB,1.3637E-02_JPRB/)
KAO( :, 4, 4, 6) = (/&
&1.0499E-01_JPRB,1.0979E-01_JPRB,1.0642E-01_JPRB,9.9223E-02_JPRB,8.9977E-02_JPRB,7.8273E-02_JPRB,&
&6.2815E-02_JPRB,4.3991E-02_JPRB,2.7037E-02_JPRB,1.8072E-02_JPRB,1.5828E-02_JPRB/)
KAO( :, 5, 4, 6) = (/&
&1.0648E-01_JPRB,1.1320E-01_JPRB,1.1032E-01_JPRB,1.0355E-01_JPRB,9.4621E-02_JPRB,8.2442E-02_JPRB,&
&6.6678E-02_JPRB,4.7586E-02_JPRB,2.9766E-02_JPRB,2.0476E-02_JPRB,1.8322E-02_JPRB/)
KAO( :, 1, 5, 6) = (/&
&8.8646E-02_JPRB,8.7933E-02_JPRB,8.2832E-02_JPRB,7.5476E-02_JPRB,6.6640E-02_JPRB,5.6566E-02_JPRB,&
&4.4409E-02_JPRB,2.9574E-02_JPRB,1.6904E-02_JPRB,1.0272E-02_JPRB,9.1351E-03_JPRB/)
KAO( :, 2, 5, 6) = (/&
&9.0277E-02_JPRB,9.1081E-02_JPRB,8.6318E-02_JPRB,7.9229E-02_JPRB,7.0495E-02_JPRB,6.0192E-02_JPRB,&
&4.7724E-02_JPRB,3.2103E-02_JPRB,1.8750E-02_JPRB,1.1641E-02_JPRB,1.0542E-02_JPRB/)
KAO( :, 3, 5, 6) = (/&
&9.1984E-02_JPRB,9.4263E-02_JPRB,8.9928E-02_JPRB,8.3093E-02_JPRB,7.4368E-02_JPRB,6.3999E-02_JPRB,&
&5.1030E-02_JPRB,3.4755E-02_JPRB,2.0780E-02_JPRB,1.3171E-02_JPRB,1.2136E-02_JPRB/)
KAO( :, 4, 5, 6) = (/&
&9.3576E-02_JPRB,9.7447E-02_JPRB,9.3654E-02_JPRB,8.7006E-02_JPRB,7.8424E-02_JPRB,6.7877E-02_JPRB,&
&5.4374E-02_JPRB,3.7638E-02_JPRB,2.3002E-02_JPRB,1.4893E-02_JPRB,1.3923E-02_JPRB/)
KAO( :, 5, 5, 6) = (/&
&9.5080E-02_JPRB,1.0065E-01_JPRB,9.7383E-02_JPRB,9.1136E-02_JPRB,8.2601E-02_JPRB,7.1701E-02_JPRB,&
&5.7863E-02_JPRB,4.0796E-02_JPRB,2.5412E-02_JPRB,1.6809E-02_JPRB,1.5908E-02_JPRB/)
KAO( :, 1, 6, 6) = (/&
&7.7960E-02_JPRB,7.6934E-02_JPRB,7.1843E-02_JPRB,6.5156E-02_JPRB,5.7207E-02_JPRB,4.8156E-02_JPRB,&
&3.7659E-02_JPRB,2.4879E-02_JPRB,1.4127E-02_JPRB,8.5541E-03_JPRB,8.3666E-03_JPRB/)
KAO( :, 2, 6, 6) = (/&
&7.9609E-02_JPRB,7.9866E-02_JPRB,7.5063E-02_JPRB,6.8592E-02_JPRB,6.0623E-02_JPRB,5.1416E-02_JPRB,&
&4.0604E-02_JPRB,2.7099E-02_JPRB,1.5685E-02_JPRB,9.6918E-03_JPRB,9.5572E-03_JPRB/)
KAO( :, 3, 6, 6) = (/&
&8.1302E-02_JPRB,8.2836E-02_JPRB,7.8445E-02_JPRB,7.2127E-02_JPRB,6.4136E-02_JPRB,5.4857E-02_JPRB,&
&4.3565E-02_JPRB,2.9366E-02_JPRB,1.7400E-02_JPRB,1.0963E-02_JPRB,1.0922E-02_JPRB/)
KAO( :, 4, 6, 6) = (/&
&8.2802E-02_JPRB,8.5864E-02_JPRB,8.1904E-02_JPRB,7.5770E-02_JPRB,6.7852E-02_JPRB,5.8330E-02_JPRB,&
&4.6522E-02_JPRB,3.1837E-02_JPRB,1.9277E-02_JPRB,1.2364E-02_JPRB,1.2452E-02_JPRB/)
KAO( :, 5, 6, 6) = (/&
&8.4221E-02_JPRB,8.8823E-02_JPRB,8.5384E-02_JPRB,7.9630E-02_JPRB,7.1590E-02_JPRB,6.1823E-02_JPRB,&
&4.9653E-02_JPRB,3.4554E-02_JPRB,2.1337E-02_JPRB,1.3901E-02_JPRB,1.4136E-02_JPRB/)
KAO( :, 1, 7, 6) = (/&
&6.7828E-02_JPRB,6.6421E-02_JPRB,6.1520E-02_JPRB,5.5497E-02_JPRB,4.8477E-02_JPRB,4.0523E-02_JPRB,&
&3.1519E-02_JPRB,2.0723E-02_JPRB,1.1684E-02_JPRB,7.0442E-03_JPRB,8.2153E-03_JPRB/)
KAO( :, 2, 7, 6) = (/&
&6.9386E-02_JPRB,6.9084E-02_JPRB,6.4466E-02_JPRB,5.8621E-02_JPRB,5.1513E-02_JPRB,4.3404E-02_JPRB,&
&3.4117E-02_JPRB,2.2620E-02_JPRB,1.3002E-02_JPRB,8.0096E-03_JPRB,9.3023E-03_JPRB/)
KAO( :, 3, 7, 6) = (/&
&7.0902E-02_JPRB,7.1781E-02_JPRB,6.7571E-02_JPRB,6.1798E-02_JPRB,5.4668E-02_JPRB,4.6485E-02_JPRB,&
&3.6722E-02_JPRB,2.4596E-02_JPRB,1.4441E-02_JPRB,9.0791E-03_JPRB,1.0528E-02_JPRB/)
KAO( :, 4, 7, 6) = (/&
&7.2282E-02_JPRB,7.4474E-02_JPRB,7.0674E-02_JPRB,6.5102E-02_JPRB,5.8020E-02_JPRB,4.9583E-02_JPRB,&
&3.9334E-02_JPRB,2.6694E-02_JPRB,1.6007E-02_JPRB,1.0271E-02_JPRB,1.1922E-02_JPRB/)
KAO( :, 5, 7, 6) = (/&
&7.3586E-02_JPRB,7.7141E-02_JPRB,7.3787E-02_JPRB,6.8567E-02_JPRB,6.1369E-02_JPRB,5.2671E-02_JPRB,&
&4.2103E-02_JPRB,2.8979E-02_JPRB,1.7736E-02_JPRB,1.1572E-02_JPRB,1.3447E-02_JPRB/)
KAO( :, 1, 8, 6) = (/&
&5.8712E-02_JPRB,5.7043E-02_JPRB,5.2438E-02_JPRB,4.7021E-02_JPRB,4.0853E-02_JPRB,3.3895E-02_JPRB,&
&2.6198E-02_JPRB,1.7219E-02_JPRB,9.5944E-03_JPRB,5.7565E-03_JPRB,9.7903E-03_JPRB/)
KAO( :, 2, 8, 6) = (/&
&6.0111E-02_JPRB,5.9403E-02_JPRB,5.5109E-02_JPRB,4.9792E-02_JPRB,4.3500E-02_JPRB,3.6406E-02_JPRB,&
&2.8441E-02_JPRB,1.8832E-02_JPRB,1.0715E-02_JPRB,6.5565E-03_JPRB,1.0886E-02_JPRB/)
KAO( :, 3, 8, 6) = (/&
&6.1464E-02_JPRB,6.1765E-02_JPRB,5.7839E-02_JPRB,5.2591E-02_JPRB,4.6276E-02_JPRB,3.9078E-02_JPRB,&
&3.0733E-02_JPRB,2.0508E-02_JPRB,1.1934E-02_JPRB,7.4566E-03_JPRB,1.2121E-02_JPRB/)
KAO( :, 4, 8, 6) = (/&
&6.2712E-02_JPRB,6.4146E-02_JPRB,6.0527E-02_JPRB,5.5457E-02_JPRB,4.9226E-02_JPRB,4.1797E-02_JPRB,&
&3.3031E-02_JPRB,2.2300E-02_JPRB,1.3252E-02_JPRB,8.4625E-03_JPRB,1.3482E-02_JPRB/)
KAO( :, 5, 8, 6) = (/&
&6.3914E-02_JPRB,6.6490E-02_JPRB,6.3234E-02_JPRB,5.8457E-02_JPRB,5.2124E-02_JPRB,4.4504E-02_JPRB,&
&3.5484E-02_JPRB,2.4239E-02_JPRB,1.4708E-02_JPRB,9.5766E-03_JPRB,1.4975E-02_JPRB/)
KAO( :, 1, 9, 6) = (/&
&5.0689E-02_JPRB,4.8919E-02_JPRB,4.4694E-02_JPRB,3.9834E-02_JPRB,3.4426E-02_JPRB,2.8389E-02_JPRB,&
&2.1819E-02_JPRB,1.4302E-02_JPRB,7.8127E-03_JPRB,4.6620E-03_JPRB,2.0696E-02_JPRB/)
KAO( :, 2, 9, 6) = (/&
&5.1946E-02_JPRB,5.0973E-02_JPRB,4.7056E-02_JPRB,4.2253E-02_JPRB,3.6737E-02_JPRB,3.0544E-02_JPRB,&
&2.3724E-02_JPRB,1.5668E-02_JPRB,8.7780E-03_JPRB,5.3214E-03_JPRB,2.1910E-02_JPRB/)
KAO( :, 3, 9, 6) = (/&
&5.3143E-02_JPRB,5.3077E-02_JPRB,4.9431E-02_JPRB,4.4665E-02_JPRB,3.9122E-02_JPRB,3.2816E-02_JPRB,&
&2.5692E-02_JPRB,1.7096E-02_JPRB,9.8039E-03_JPRB,6.0656E-03_JPRB,2.3234E-02_JPRB/)
KAO( :, 4, 9, 6) = (/&
&5.4267E-02_JPRB,5.5157E-02_JPRB,5.1739E-02_JPRB,4.7167E-02_JPRB,4.1644E-02_JPRB,3.5136E-02_JPRB,&
&2.7685E-02_JPRB,1.8626E-02_JPRB,1.0916E-02_JPRB,6.9060E-03_JPRB,2.4826E-02_JPRB/)
KAO( :, 5, 9, 6) = (/&
&5.5411E-02_JPRB,5.7220E-02_JPRB,5.4074E-02_JPRB,4.9699E-02_JPRB,4.4127E-02_JPRB,3.7477E-02_JPRB,&
&2.9785E-02_JPRB,2.0273E-02_JPRB,1.2148E-02_JPRB,7.8411E-03_JPRB,2.6607E-02_JPRB/)
KAO( :, 1,10, 6) = (/&
&4.3441E-02_JPRB,4.1752E-02_JPRB,3.7992E-02_JPRB,3.3732E-02_JPRB,2.9033E-02_JPRB,2.3892E-02_JPRB,&
&1.8315E-02_JPRB,1.1925E-02_JPRB,6.3650E-03_JPRB,3.7730E-03_JPRB,5.8980E-02_JPRB/)
KAO( :, 2,10, 6) = (/&
&4.4578E-02_JPRB,4.3534E-02_JPRB,4.0036E-02_JPRB,3.5800E-02_JPRB,3.1038E-02_JPRB,2.5745E-02_JPRB,&
&1.9928E-02_JPRB,1.3095E-02_JPRB,7.1901E-03_JPRB,4.3268E-03_JPRB,6.2127E-02_JPRB/)
KAO( :, 3,10, 6) = (/&
&4.5637E-02_JPRB,4.5360E-02_JPRB,4.2074E-02_JPRB,3.7890E-02_JPRB,3.3109E-02_JPRB,2.7662E-02_JPRB,&
&2.1605E-02_JPRB,1.4318E-02_JPRB,8.0717E-03_JPRB,4.9441E-03_JPRB,6.4930E-02_JPRB/)
KAO( :, 4,10, 6) = (/&
&4.6665E-02_JPRB,4.7201E-02_JPRB,4.4073E-02_JPRB,4.0041E-02_JPRB,3.5227E-02_JPRB,2.9634E-02_JPRB,&
&2.3310E-02_JPRB,1.5630E-02_JPRB,9.0074E-03_JPRB,5.6431E-03_JPRB,6.7490E-02_JPRB/)
KAO( :, 5,10, 6) = (/&
&4.7723E-02_JPRB,4.9037E-02_JPRB,4.6142E-02_JPRB,4.2228E-02_JPRB,3.7348E-02_JPRB,3.1608E-02_JPRB,&
&2.5075E-02_JPRB,1.7036E-02_JPRB,1.0045E-02_JPRB,6.4268E-03_JPRB,6.9977E-02_JPRB/)
KAO( :, 1,11, 6) = (/&
&3.7516E-02_JPRB,3.6158E-02_JPRB,3.2933E-02_JPRB,2.9252E-02_JPRB,2.5204E-02_JPRB,2.0803E-02_JPRB,&
&1.5990E-02_JPRB,1.0375E-02_JPRB,5.4827E-03_JPRB,3.2361E-03_JPRB,8.1016E-02_JPRB/)
KAO( :, 2,11, 6) = (/&
&3.8506E-02_JPRB,3.7721E-02_JPRB,3.4706E-02_JPRB,3.1031E-02_JPRB,2.6946E-02_JPRB,2.2411E-02_JPRB,&
&1.7386E-02_JPRB,1.1409E-02_JPRB,6.2003E-03_JPRB,3.7210E-03_JPRB,8.4685E-02_JPRB/)
KAO( :, 3,11, 6) = (/&
&3.9439E-02_JPRB,3.9310E-02_JPRB,3.6436E-02_JPRB,3.2830E-02_JPRB,2.8736E-02_JPRB,2.4071E-02_JPRB,&
&1.8831E-02_JPRB,1.2487E-02_JPRB,6.9722E-03_JPRB,4.2623E-03_JPRB,8.7980E-02_JPRB/)
KAO( :, 4,11, 6) = (/&
&4.0392E-02_JPRB,4.0944E-02_JPRB,3.8217E-02_JPRB,3.4707E-02_JPRB,3.0543E-02_JPRB,2.5731E-02_JPRB,&
&2.0303E-02_JPRB,1.3646E-02_JPRB,7.7970E-03_JPRB,4.8703E-03_JPRB,9.0981E-02_JPRB/)
KAO( :, 5,11, 6) = (/&
&4.1332E-02_JPRB,4.2552E-02_JPRB,4.0059E-02_JPRB,3.6603E-02_JPRB,3.2383E-02_JPRB,2.7450E-02_JPRB,&
&2.1833E-02_JPRB,1.4887E-02_JPRB,8.7084E-03_JPRB,5.5527E-03_JPRB,9.3973E-02_JPRB/)
KAO( :, 1,12, 6) = (/&
&3.2190E-02_JPRB,3.1071E-02_JPRB,2.8321E-02_JPRB,2.5152E-02_JPRB,2.1728E-02_JPRB,1.7981E-02_JPRB,&
&1.3822E-02_JPRB,8.9602E-03_JPRB,4.7106E-03_JPRB,2.7564E-03_JPRB,8.5402E-02_JPRB/)
KAO( :, 2,12, 6) = (/&
&3.3033E-02_JPRB,3.2405E-02_JPRB,2.9806E-02_JPRB,2.6661E-02_JPRB,2.3211E-02_JPRB,1.9361E-02_JPRB,&
&1.5025E-02_JPRB,9.8641E-03_JPRB,5.3297E-03_JPRB,3.1770E-03_JPRB,8.8737E-02_JPRB/)
KAO( :, 3,12, 6) = (/&
&3.3864E-02_JPRB,3.3793E-02_JPRB,3.1297E-02_JPRB,2.8211E-02_JPRB,2.4733E-02_JPRB,2.0771E-02_JPRB,&
&1.6265E-02_JPRB,1.0821E-02_JPRB,6.0022E-03_JPRB,3.6467E-03_JPRB,9.1670E-02_JPRB/)
KAO( :, 4,12, 6) = (/&
&3.4696E-02_JPRB,3.5203E-02_JPRB,3.2853E-02_JPRB,2.9817E-02_JPRB,2.6296E-02_JPRB,2.2203E-02_JPRB,&
&1.7545E-02_JPRB,1.1834E-02_JPRB,6.7302E-03_JPRB,4.1679E-03_JPRB,9.4574E-02_JPRB/)
KAO( :, 5,12, 6) = (/&
&3.5522E-02_JPRB,3.6626E-02_JPRB,3.4423E-02_JPRB,3.1438E-02_JPRB,2.7875E-02_JPRB,2.3697E-02_JPRB,&
&1.8905E-02_JPRB,1.2927E-02_JPRB,7.5191E-03_JPRB,4.7590E-03_JPRB,9.7614E-02_JPRB/)
KAO( :, 1,13, 6) = (/&
&2.7210E-02_JPRB,2.6304E-02_JPRB,2.3996E-02_JPRB,2.1359E-02_JPRB,1.8491E-02_JPRB,1.5314E-02_JPRB,&
&1.1755E-02_JPRB,7.6170E-03_JPRB,4.0095E-03_JPRB,2.3275E-03_JPRB,7.1211E-02_JPRB/)
KAO( :, 2,13, 6) = (/&
&2.7941E-02_JPRB,2.7441E-02_JPRB,2.5246E-02_JPRB,2.2622E-02_JPRB,1.9729E-02_JPRB,1.6472E-02_JPRB,&
&1.2765E-02_JPRB,8.4034E-03_JPRB,4.5447E-03_JPRB,2.6861E-03_JPRB,7.3769E-02_JPRB/)
KAO( :, 3,13, 6) = (/&
&2.8664E-02_JPRB,2.8630E-02_JPRB,2.6520E-02_JPRB,2.3935E-02_JPRB,2.1025E-02_JPRB,1.7662E-02_JPRB,&
&1.3821E-02_JPRB,9.2359E-03_JPRB,5.1273E-03_JPRB,3.0871E-03_JPRB,7.6136E-02_JPRB/)
KAO( :, 4,13, 6) = (/&
&2.9387E-02_JPRB,2.9844E-02_JPRB,2.7832E-02_JPRB,2.5287E-02_JPRB,2.2341E-02_JPRB,1.8888E-02_JPRB,&
&1.4940E-02_JPRB,1.0117E-02_JPRB,5.7529E-03_JPRB,3.5334E-03_JPRB,7.8673E-02_JPRB/)
KAO( :, 5,13, 6) = (/&
&3.0121E-02_JPRB,3.1064E-02_JPRB,2.9140E-02_JPRB,2.6651E-02_JPRB,2.3680E-02_JPRB,2.0177E-02_JPRB,&
&1.6134E-02_JPRB,1.1077E-02_JPRB,6.4283E-03_JPRB,4.0402E-03_JPRB,8.1505E-02_JPRB/)
KAO( :, 1, 1, 7) = (/&
&2.6926E-01_JPRB,2.5612E-01_JPRB,2.3950E-01_JPRB,2.1903E-01_JPRB,1.9378E-01_JPRB,1.6501E-01_JPRB,&
&1.2973E-01_JPRB,8.7439E-02_JPRB,5.3950E-02_JPRB,4.2811E-02_JPRB,4.3233E-02_JPRB/)
KAO( :, 2, 1, 7) = (/&
&2.6861E-01_JPRB,2.5930E-01_JPRB,2.4513E-01_JPRB,2.2568E-01_JPRB,2.0133E-01_JPRB,1.7294E-01_JPRB,&
&1.3711E-01_JPRB,9.4464E-02_JPRB,6.0595E-02_JPRB,5.0710E-02_JPRB,5.1677E-02_JPRB/)
KAO( :, 3, 1, 7) = (/&
&2.6820E-01_JPRB,2.6238E-01_JPRB,2.5102E-01_JPRB,2.3240E-01_JPRB,2.0913E-01_JPRB,1.8091E-01_JPRB,&
&1.4446E-01_JPRB,1.0226E-01_JPRB,6.8084E-02_JPRB,5.9495E-02_JPRB,6.1037E-02_JPRB/)
KAO( :, 4, 1, 7) = (/&
&2.6771E-01_JPRB,2.6572E-01_JPRB,2.5658E-01_JPRB,2.3935E-01_JPRB,2.1685E-01_JPRB,1.8839E-01_JPRB,&
&1.5222E-01_JPRB,1.1069E-01_JPRB,7.6279E-02_JPRB,6.9108E-02_JPRB,7.1213E-02_JPRB/)
KAO( :, 5, 1, 7) = (/&
&2.6714E-01_JPRB,2.6936E-01_JPRB,2.6194E-01_JPRB,2.4642E-01_JPRB,2.2450E-01_JPRB,1.9571E-01_JPRB,&
&1.6083E-01_JPRB,1.1918E-01_JPRB,8.5421E-02_JPRB,7.9682E-02_JPRB,8.2280E-02_JPRB/)
KAO( :, 1, 2, 7) = (/&
&2.5685E-01_JPRB,2.4492E-01_JPRB,2.2865E-01_JPRB,2.0884E-01_JPRB,1.8444E-01_JPRB,1.5601E-01_JPRB,&
&1.2319E-01_JPRB,8.1747E-02_JPRB,4.8230E-02_JPRB,3.5409E-02_JPRB,3.4615E-02_JPRB/)
KAO( :, 2, 2, 7) = (/&
&2.5657E-01_JPRB,2.4834E-01_JPRB,2.3445E-01_JPRB,2.1551E-01_JPRB,1.9182E-01_JPRB,1.6377E-01_JPRB,&
&1.3042E-01_JPRB,8.8197E-02_JPRB,5.3891E-02_JPRB,4.1822E-02_JPRB,4.1515E-02_JPRB/)
KAO( :, 3, 2, 7) = (/&
&2.5627E-01_JPRB,2.5163E-01_JPRB,2.4011E-01_JPRB,2.2230E-01_JPRB,1.9937E-01_JPRB,1.7150E-01_JPRB,&
&1.3758E-01_JPRB,9.5254E-02_JPRB,6.0018E-02_JPRB,4.9025E-02_JPRB,4.9189E-02_JPRB/)
KAO( :, 4, 2, 7) = (/&
&2.5591E-01_JPRB,2.5517E-01_JPRB,2.4558E-01_JPRB,2.2928E-01_JPRB,2.0702E-01_JPRB,1.7899E-01_JPRB,&
&1.4524E-01_JPRB,1.0258E-01_JPRB,6.6782E-02_JPRB,5.7123E-02_JPRB,5.7631E-02_JPRB/)
KAO( :, 5, 2, 7) = (/&
&2.5562E-01_JPRB,2.5902E-01_JPRB,2.5095E-01_JPRB,2.3638E-01_JPRB,2.1422E-01_JPRB,1.8662E-01_JPRB,&
&1.5329E-01_JPRB,1.0996E-01_JPRB,7.4405E-02_JPRB,6.6142E-02_JPRB,6.6949E-02_JPRB/)
KAO( :, 1, 3, 7) = (/&
&2.4108E-01_JPRB,2.2965E-01_JPRB,2.1361E-01_JPRB,1.9446E-01_JPRB,1.7133E-01_JPRB,1.4401E-01_JPRB,&
&1.1345E-01_JPRB,7.5185E-02_JPRB,4.2160E-02_JPRB,2.8583E-02_JPRB,2.6584E-02_JPRB/)
KAO( :, 2, 3, 7) = (/&
&2.4113E-01_JPRB,2.3314E-01_JPRB,2.1942E-01_JPRB,2.0119E-01_JPRB,1.7846E-01_JPRB,1.5146E-01_JPRB,&
&1.2063E-01_JPRB,8.1173E-02_JPRB,4.7044E-02_JPRB,3.3533E-02_JPRB,3.2019E-02_JPRB/)
KAO( :, 3, 3, 7) = (/&
&2.4094E-01_JPRB,2.3663E-01_JPRB,2.2501E-01_JPRB,2.0773E-01_JPRB,1.8580E-01_JPRB,1.5907E-01_JPRB,&
&1.2798E-01_JPRB,8.7501E-02_JPRB,5.2313E-02_JPRB,3.9244E-02_JPRB,3.8141E-02_JPRB/)
KAO( :, 4, 3, 7) = (/&
&2.4074E-01_JPRB,2.4043E-01_JPRB,2.3041E-01_JPRB,2.1449E-01_JPRB,1.9317E-01_JPRB,1.6647E-01_JPRB,&
&1.3556E-01_JPRB,9.3949E-02_JPRB,5.7980E-02_JPRB,4.5777E-02_JPRB,4.5020E-02_JPRB/)
KAO( :, 5, 3, 7) = (/&
&2.4071E-01_JPRB,2.4430E-01_JPRB,2.3591E-01_JPRB,2.2137E-01_JPRB,2.0017E-01_JPRB,1.7425E-01_JPRB,&
&1.4332E-01_JPRB,1.0047E-01_JPRB,6.4245E-02_JPRB,5.3237E-02_JPRB,5.2730E-02_JPRB/)
KAO( :, 1, 4, 7) = (/&
&2.2311E-01_JPRB,2.1202E-01_JPRB,1.9660E-01_JPRB,1.7804E-01_JPRB,1.5619E-01_JPRB,1.3066E-01_JPRB,&
&1.0239E-01_JPRB,6.7996E-02_JPRB,3.6908E-02_JPRB,2.3235E-02_JPRB,2.0397E-02_JPRB/)
KAO( :, 2, 4, 7) = (/&
&2.2321E-01_JPRB,2.1552E-01_JPRB,2.0209E-01_JPRB,1.8449E-01_JPRB,1.6284E-01_JPRB,1.3774E-01_JPRB,&
&1.0930E-01_JPRB,7.3775E-02_JPRB,4.1078E-02_JPRB,2.7004E-02_JPRB,2.4614E-02_JPRB/)
KAO( :, 3, 4, 7) = (/&
&2.2314E-01_JPRB,2.1901E-01_JPRB,2.0753E-01_JPRB,1.9073E-01_JPRB,1.6981E-01_JPRB,1.4494E-01_JPRB,&
&1.1634E-01_JPRB,7.9807E-02_JPRB,4.5483E-02_JPRB,3.1405E-02_JPRB,2.9481E-02_JPRB/)
KAO( :, 4, 4, 7) = (/&
&2.2327E-01_JPRB,2.2287E-01_JPRB,2.1284E-01_JPRB,1.9716E-01_JPRB,1.7693E-01_JPRB,1.5226E-01_JPRB,&
&1.2381E-01_JPRB,8.5751E-02_JPRB,5.0279E-02_JPRB,3.6528E-02_JPRB,3.5030E-02_JPRB/)
KAO( :, 5, 4, 7) = (/&
&2.2365E-01_JPRB,2.2673E-01_JPRB,2.1820E-01_JPRB,2.0372E-01_JPRB,1.8385E-01_JPRB,1.5984E-01_JPRB,&
&1.3133E-01_JPRB,9.1593E-02_JPRB,5.5615E-02_JPRB,4.2459E-02_JPRB,4.1306E-02_JPRB/)
KAO( :, 1, 5, 7) = (/&
&2.0367E-01_JPRB,1.9330E-01_JPRB,1.7867E-01_JPRB,1.6084E-01_JPRB,1.4027E-01_JPRB,1.1693E-01_JPRB,&
&9.0945E-02_JPRB,6.0466E-02_JPRB,3.2455E-02_JPRB,1.9165E-02_JPRB,1.7920E-02_JPRB/)
KAO( :, 2, 5, 7) = (/&
&2.0387E-01_JPRB,1.9668E-01_JPRB,1.8380E-01_JPRB,1.6682E-01_JPRB,1.4653E-01_JPRB,1.2346E-01_JPRB,&
&9.7443E-02_JPRB,6.5962E-02_JPRB,3.6138E-02_JPRB,2.2169E-02_JPRB,2.0934E-02_JPRB/)
KAO( :, 3, 5, 7) = (/&
&2.0408E-01_JPRB,2.0015E-01_JPRB,1.8885E-01_JPRB,1.7264E-01_JPRB,1.5303E-01_JPRB,1.3023E-01_JPRB,&
&1.0413E-01_JPRB,7.1676E-02_JPRB,3.9916E-02_JPRB,2.5581E-02_JPRB,2.4393E-02_JPRB/)
KAO( :, 4, 5, 7) = (/&
&2.0467E-01_JPRB,2.0395E-01_JPRB,1.9389E-01_JPRB,1.7862E-01_JPRB,1.5966E-01_JPRB,1.3725E-01_JPRB,&
&1.1106E-01_JPRB,7.7287E-02_JPRB,4.3976E-02_JPRB,2.9567E-02_JPRB,2.8440E-02_JPRB/)
KAO( :, 5, 5, 7) = (/&
&2.0538E-01_JPRB,2.0784E-01_JPRB,1.9895E-01_JPRB,1.8474E-01_JPRB,1.6635E-01_JPRB,1.4459E-01_JPRB,&
&1.1807E-01_JPRB,8.2795E-02_JPRB,4.8485E-02_JPRB,3.4195E-02_JPRB,3.3174E-02_JPRB/)
KAO( :, 1, 6, 7) = (/&
&1.8377E-01_JPRB,1.7398E-01_JPRB,1.6006E-01_JPRB,1.4318E-01_JPRB,1.2397E-01_JPRB,1.0298E-01_JPRB,&
&7.9521E-02_JPRB,5.2397E-02_JPRB,2.8050E-02_JPRB,1.5934E-02_JPRB,1.6791E-02_JPRB/)
KAO( :, 2, 6, 7) = (/&
&1.8406E-01_JPRB,1.7717E-01_JPRB,1.6474E-01_JPRB,1.4853E-01_JPRB,1.2984E-01_JPRB,1.0898E-01_JPRB,&
&8.5328E-02_JPRB,5.7490E-02_JPRB,3.1447E-02_JPRB,1.8349E-02_JPRB,1.9516E-02_JPRB/)
KAO( :, 3, 6, 7) = (/&
&1.8458E-01_JPRB,1.8054E-01_JPRB,1.6936E-01_JPRB,1.5392E-01_JPRB,1.3584E-01_JPRB,1.1517E-01_JPRB,&
&9.1409E-02_JPRB,6.2836E-02_JPRB,3.4889E-02_JPRB,2.1106E-02_JPRB,2.2611E-02_JPRB/)
KAO( :, 4, 6, 7) = (/&
&1.8542E-01_JPRB,1.8421E-01_JPRB,1.7403E-01_JPRB,1.5942E-01_JPRB,1.4196E-01_JPRB,1.2162E-01_JPRB,&
&9.7928E-02_JPRB,6.8139E-02_JPRB,3.8483E-02_JPRB,2.4244E-02_JPRB,2.6124E-02_JPRB/)
KAO( :, 5, 6, 7) = (/&
&1.8648E-01_JPRB,1.8801E-01_JPRB,1.7890E-01_JPRB,1.6506E-01_JPRB,1.4823E-01_JPRB,1.2840E-01_JPRB,&
&1.0438E-01_JPRB,7.3304E-02_JPRB,4.2378E-02_JPRB,2.7839E-02_JPRB,3.0053E-02_JPRB/)
KAO( :, 1, 7, 7) = (/&
&1.6272E-01_JPRB,1.5372E-01_JPRB,1.4080E-01_JPRB,1.2519E-01_JPRB,1.0771E-01_JPRB,8.8984E-02_JPRB,&
&6.8276E-02_JPRB,4.4541E-02_JPRB,2.3807E-02_JPRB,1.3453E-02_JPRB,1.6655E-02_JPRB/)
KAO( :, 2, 7, 7) = (/&
&1.6325E-01_JPRB,1.5679E-01_JPRB,1.4498E-01_JPRB,1.2986E-01_JPRB,1.1297E-01_JPRB,9.4402E-02_JPRB,&
&7.3383E-02_JPRB,4.9046E-02_JPRB,2.6845E-02_JPRB,1.5405E-02_JPRB,1.9132E-02_JPRB/)
KAO( :, 3, 7, 7) = (/&
&1.6400E-01_JPRB,1.6007E-01_JPRB,1.4916E-01_JPRB,1.3473E-01_JPRB,1.1836E-01_JPRB,9.9949E-02_JPRB,&
&7.8806E-02_JPRB,5.3833E-02_JPRB,2.9954E-02_JPRB,1.7645E-02_JPRB,2.1895E-02_JPRB/)
KAO( :, 4, 7, 7) = (/&
&1.6505E-01_JPRB,1.6353E-01_JPRB,1.5347E-01_JPRB,1.3982E-01_JPRB,1.2392E-01_JPRB,1.0565E-01_JPRB,&
&8.4634E-02_JPRB,5.8597E-02_JPRB,3.3207E-02_JPRB,2.0171E-02_JPRB,2.4986E-02_JPRB/)
KAO( :, 5, 7, 7) = (/&
&1.6641E-01_JPRB,1.6726E-01_JPRB,1.5808E-01_JPRB,1.4506E-01_JPRB,1.2973E-01_JPRB,1.1182E-01_JPRB,&
&9.0461E-02_JPRB,6.3334E-02_JPRB,3.6689E-02_JPRB,2.3031E-02_JPRB,2.8476E-02_JPRB/)
KAO( :, 1, 8, 7) = (/&
&1.4230E-01_JPRB,1.3413E-01_JPRB,1.2233E-01_JPRB,1.0813E-01_JPRB,9.2496E-02_JPRB,7.5904E-02_JPRB,&
&5.7906E-02_JPRB,3.7394E-02_JPRB,2.0019E-02_JPRB,1.1310E-02_JPRB,1.9019E-02_JPRB/)
KAO( :, 2, 8, 7) = (/&
&1.4305E-01_JPRB,1.3708E-01_JPRB,1.2596E-01_JPRB,1.1218E-01_JPRB,9.7109E-02_JPRB,8.0704E-02_JPRB,&
&6.2330E-02_JPRB,4.1218E-02_JPRB,2.2623E-02_JPRB,1.3029E-02_JPRB,2.1546E-02_JPRB/)
KAO( :, 3, 8, 7) = (/&
&1.4394E-01_JPRB,1.4013E-01_JPRB,1.2970E-01_JPRB,1.1658E-01_JPRB,1.0194E-01_JPRB,8.5591E-02_JPRB,&
&6.7043E-02_JPRB,4.5347E-02_JPRB,2.5359E-02_JPRB,1.4903E-02_JPRB,2.4327E-02_JPRB/)
KAO( :, 4, 8, 7) = (/&
&1.4525E-01_JPRB,1.4339E-01_JPRB,1.3373E-01_JPRB,1.2126E-01_JPRB,1.0690E-01_JPRB,9.0683E-02_JPRB,&
&7.2129E-02_JPRB,4.9569E-02_JPRB,2.8222E-02_JPRB,1.6964E-02_JPRB,2.7427E-02_JPRB/)
KAO( :, 5, 8, 7) = (/&
&1.4678E-01_JPRB,1.4702E-01_JPRB,1.3814E-01_JPRB,1.2616E-01_JPRB,1.1217E-01_JPRB,9.6136E-02_JPRB,&
&7.7253E-02_JPRB,5.3800E-02_JPRB,3.1285E-02_JPRB,1.9274E-02_JPRB,3.0890E-02_JPRB/)
KAO( :, 1, 9, 7) = (/&
&1.2368E-01_JPRB,1.1615E-01_JPRB,1.0547E-01_JPRB,9.2730E-02_JPRB,7.8890E-02_JPRB,6.4288E-02_JPRB,&
&4.8706E-02_JPRB,3.1194E-02_JPRB,1.6735E-02_JPRB,9.3621E-03_JPRB,3.9474E-02_JPRB/)
KAO( :, 2, 9, 7) = (/&
&1.2453E-01_JPRB,1.1886E-01_JPRB,1.0862E-01_JPRB,9.6299E-02_JPRB,8.2892E-02_JPRB,6.8444E-02_JPRB,&
&5.2534E-02_JPRB,3.4360E-02_JPRB,1.8949E-02_JPRB,1.0875E-02_JPRB,4.3185E-02_JPRB/)
KAO( :, 3, 9, 7) = (/&
&1.2562E-01_JPRB,1.2177E-01_JPRB,1.1199E-01_JPRB,1.0025E-01_JPRB,8.7157E-02_JPRB,7.2734E-02_JPRB,&
&5.6567E-02_JPRB,3.7837E-02_JPRB,2.1307E-02_JPRB,1.2524E-02_JPRB,4.7262E-02_JPRB/)
KAO( :, 4, 9, 7) = (/&
&1.2711E-01_JPRB,1.2497E-01_JPRB,1.1585E-01_JPRB,1.0453E-01_JPRB,9.1592E-02_JPRB,7.7237E-02_JPRB,&
&6.0927E-02_JPRB,4.1474E-02_JPRB,2.3783E-02_JPRB,1.4321E-02_JPRB,5.1601E-02_JPRB/)
KAO( :, 5, 9, 7) = (/&
&1.2877E-01_JPRB,1.2842E-01_JPRB,1.2005E-01_JPRB,1.0911E-01_JPRB,9.6384E-02_JPRB,8.2052E-02_JPRB,&
&6.5390E-02_JPRB,4.5200E-02_JPRB,2.6423E-02_JPRB,1.6264E-02_JPRB,5.6231E-02_JPRB/)
KAO( :, 1,10, 7) = (/&
&1.0692E-01_JPRB,1.0005E-01_JPRB,9.0502E-02_JPRB,7.9216E-02_JPRB,6.7057E-02_JPRB,5.4323E-02_JPRB,&
&4.0890E-02_JPRB,2.6119E-02_JPRB,1.4019E-02_JPRB,7.7525E-03_JPRB,1.2082E-01_JPRB/)
KAO( :, 2,10, 7) = (/&
&1.0785E-01_JPRB,1.0257E-01_JPRB,9.3251E-02_JPRB,8.2316E-02_JPRB,7.0515E-02_JPRB,5.7848E-02_JPRB,&
&4.4197E-02_JPRB,2.8769E-02_JPRB,1.5892E-02_JPRB,9.0528E-03_JPRB,1.2557E-01_JPRB/)
KAO( :, 3,10, 7) = (/&
&1.0912E-01_JPRB,1.0534E-01_JPRB,9.6345E-02_JPRB,8.5888E-02_JPRB,7.4218E-02_JPRB,6.1590E-02_JPRB,&
&4.7639E-02_JPRB,3.1645E-02_JPRB,1.7926E-02_JPRB,1.0497E-02_JPRB,1.3124E-01_JPRB/)
KAO( :, 4,10, 7) = (/&
&1.1068E-01_JPRB,1.0836E-01_JPRB,9.9964E-02_JPRB,8.9810E-02_JPRB,7.8244E-02_JPRB,6.5593E-02_JPRB,&
&5.1337E-02_JPRB,3.4711E-02_JPRB,2.0071E-02_JPRB,1.2083E-02_JPRB,1.3784E-01_JPRB/)
KAO( :, 5,10, 7) = (/&
&1.1237E-01_JPRB,1.1161E-01_JPRB,1.0388E-01_JPRB,9.3947E-02_JPRB,8.2580E-02_JPRB,6.9883E-02_JPRB,&
&5.5203E-02_JPRB,3.7928E-02_JPRB,2.2348E-02_JPRB,1.3792E-02_JPRB,1.4518E-01_JPRB/)
KAO( :, 1,11, 7) = (/&
&9.2754E-02_JPRB,8.7072E-02_JPRB,7.8639E-02_JPRB,6.8755E-02_JPRB,5.8275E-02_JPRB,4.7245E-02_JPRB,&
&3.5602E-02_JPRB,2.2866E-02_JPRB,1.2334E-02_JPRB,6.8505E-03_JPRB,1.6609E-01_JPRB/)
KAO( :, 2,11, 7) = (/&
&9.3939E-02_JPRB,8.9571E-02_JPRB,8.1238E-02_JPRB,7.1711E-02_JPRB,6.1381E-02_JPRB,5.0306E-02_JPRB,&
&3.8442E-02_JPRB,2.5156E-02_JPRB,1.3991E-02_JPRB,8.0122E-03_JPRB,1.7138E-01_JPRB/)
KAO( :, 3,11, 7) = (/&
&9.5412E-02_JPRB,9.2282E-02_JPRB,8.4324E-02_JPRB,7.5102E-02_JPRB,6.4785E-02_JPRB,5.3640E-02_JPRB,&
&4.1470E-02_JPRB,2.7635E-02_JPRB,1.5787E-02_JPRB,9.3174E-03_JPRB,1.7778E-01_JPRB/)
KAO( :, 4,11, 7) = (/&
&9.6996E-02_JPRB,9.5142E-02_JPRB,8.7745E-02_JPRB,7.8708E-02_JPRB,6.8483E-02_JPRB,5.7282E-02_JPRB,&
&4.4714E-02_JPRB,3.0277E-02_JPRB,1.7707E-02_JPRB,1.0749E-02_JPRB,1.8499E-01_JPRB/)
KAO( :, 5,11, 7) = (/&
&9.8658E-02_JPRB,9.8284E-02_JPRB,9.1388E-02_JPRB,8.2534E-02_JPRB,7.2404E-02_JPRB,6.1041E-02_JPRB,&
&4.8110E-02_JPRB,3.3083E-02_JPRB,1.9725E-02_JPRB,1.2309E-02_JPRB,1.9294E-01_JPRB/)
KAO( :, 1,12, 7) = (/&
&8.0002E-02_JPRB,7.5395E-02_JPRB,6.7953E-02_JPRB,5.9467E-02_JPRB,5.0458E-02_JPRB,4.0919E-02_JPRB,&
&3.0920E-02_JPRB,1.9925E-02_JPRB,1.0727E-02_JPRB,5.9901E-03_JPRB,1.7505E-01_JPRB/)
KAO( :, 2,12, 7) = (/&
&8.1332E-02_JPRB,7.7813E-02_JPRB,7.0567E-02_JPRB,6.2307E-02_JPRB,5.3303E-02_JPRB,4.3618E-02_JPRB,&
&3.3391E-02_JPRB,2.1911E-02_JPRB,1.2184E-02_JPRB,7.0189E-03_JPRB,1.8048E-01_JPRB/)
KAO( :, 3,12, 7) = (/&
&8.2791E-02_JPRB,8.0324E-02_JPRB,7.3485E-02_JPRB,6.5420E-02_JPRB,5.6352E-02_JPRB,4.6610E-02_JPRB,&
&3.6047E-02_JPRB,2.4056E-02_JPRB,1.3765E-02_JPRB,8.1809E-03_JPRB,1.8704E-01_JPRB/)
KAO( :, 4,12, 7) = (/&
&8.4300E-02_JPRB,8.3063E-02_JPRB,7.6637E-02_JPRB,6.8671E-02_JPRB,5.9646E-02_JPRB,4.9774E-02_JPRB,&
&3.8886E-02_JPRB,2.6351E-02_JPRB,1.5463E-02_JPRB,9.4646E-03_JPRB,1.9416E-01_JPRB/)
KAO( :, 5,12, 7) = (/&
&8.5799E-02_JPRB,8.5928E-02_JPRB,7.9923E-02_JPRB,7.2138E-02_JPRB,6.3097E-02_JPRB,5.3071E-02_JPRB,&
&4.1851E-02_JPRB,2.8800E-02_JPRB,1.7260E-02_JPRB,1.0869E-02_JPRB,2.0180E-01_JPRB/)
KAO( :, 1,13, 7) = (/&
&6.7746E-02_JPRB,6.4117E-02_JPRB,5.7794E-02_JPRB,5.0687E-02_JPRB,4.3091E-02_JPRB,3.5063E-02_JPRB,&
&2.6600E-02_JPRB,1.7143E-02_JPRB,9.2085E-03_JPRB,5.1738E-03_JPRB,1.4684E-01_JPRB/)
KAO( :, 2,13, 7) = (/&
&6.9040E-02_JPRB,6.6326E-02_JPRB,6.0272E-02_JPRB,5.3267E-02_JPRB,4.5640E-02_JPRB,3.7446E-02_JPRB,&
&2.8771E-02_JPRB,1.8875E-02_JPRB,1.0472E-02_JPRB,6.0786E-03_JPRB,1.5190E-01_JPRB/)
KAO( :, 3,13, 7) = (/&
&7.0402E-02_JPRB,6.8674E-02_JPRB,6.2930E-02_JPRB,5.6044E-02_JPRB,4.8322E-02_JPRB,4.0046E-02_JPRB,&
&3.1093E-02_JPRB,2.0746E-02_JPRB,1.1854E-02_JPRB,7.0992E-03_JPRB,1.5783E-01_JPRB/)
KAO( :, 4,13, 7) = (/&
&7.1727E-02_JPRB,7.1116E-02_JPRB,6.5698E-02_JPRB,5.8955E-02_JPRB,5.1188E-02_JPRB,4.2780E-02_JPRB,&
&3.3535E-02_JPRB,2.2751E-02_JPRB,1.3343E-02_JPRB,8.2333E-03_JPRB,1.6414E-01_JPRB/)
KAO( :, 5,13, 7) = (/&
&7.3153E-02_JPRB,7.3694E-02_JPRB,6.8621E-02_JPRB,6.1933E-02_JPRB,5.4168E-02_JPRB,4.5648E-02_JPRB,&
&3.6089E-02_JPRB,2.4874E-02_JPRB,1.4932E-02_JPRB,9.4816E-03_JPRB,1.7071E-01_JPRB/)
KAO( :, 1, 1, 8) = (/&
&4.9299E-01_JPRB,4.5097E-01_JPRB,4.1423E-01_JPRB,3.7425E-01_JPRB,3.3288E-01_JPRB,2.8439E-01_JPRB,&
&2.3129E-01_JPRB,1.6724E-01_JPRB,1.2209E-01_JPRB,1.1839E-01_JPRB,1.2231E-01_JPRB/)
KAO( :, 2, 1, 8) = (/&
&4.9158E-01_JPRB,4.5413E-01_JPRB,4.2130E-01_JPRB,3.8574E-01_JPRB,3.4556E-01_JPRB,2.9862E-01_JPRB,&
&2.4672E-01_JPRB,1.8285E-01_JPRB,1.4316E-01_JPRB,1.4173E-01_JPRB,1.4653E-01_JPRB/)
KAO( :, 3, 1, 8) = (/&
&4.8921E-01_JPRB,4.5835E-01_JPRB,4.2895E-01_JPRB,3.9755E-01_JPRB,3.5824E-01_JPRB,3.1313E-01_JPRB,&
&2.6208E-01_JPRB,1.9974E-01_JPRB,1.6634E-01_JPRB,1.6696E-01_JPRB,1.7273E-01_JPRB/)
KAO( :, 4, 1, 8) = (/&
&4.8664E-01_JPRB,4.6279E-01_JPRB,4.3774E-01_JPRB,4.0881E-01_JPRB,3.7103E-01_JPRB,3.2868E-01_JPRB,&
&2.7711E-01_JPRB,2.1740E-01_JPRB,1.9172E-01_JPRB,1.9403E-01_JPRB,2.0091E-01_JPRB/)
KAO( :, 5, 1, 8) = (/&
&4.8428E-01_JPRB,4.6664E-01_JPRB,4.4704E-01_JPRB,4.1926E-01_JPRB,3.8405E-01_JPRB,3.4407E-01_JPRB,&
&2.9186E-01_JPRB,2.3664E-01_JPRB,2.1906E-01_JPRB,2.2276E-01_JPRB,2.3078E-01_JPRB/)
KAO( :, 1, 2, 8) = (/&
&5.0098E-01_JPRB,4.5838E-01_JPRB,4.1902E-01_JPRB,3.7538E-01_JPRB,3.3034E-01_JPRB,2.7973E-01_JPRB,&
&2.2195E-01_JPRB,1.5668E-01_JPRB,1.0587E-01_JPRB,9.8490E-02_JPRB,1.0033E-01_JPRB/)
KAO( :, 2, 2, 8) = (/&
&4.9983E-01_JPRB,4.6235E-01_JPRB,4.2661E-01_JPRB,3.8655E-01_JPRB,3.4282E-01_JPRB,2.9301E-01_JPRB,&
&2.3610E-01_JPRB,1.7056E-01_JPRB,1.2318E-01_JPRB,1.1876E-01_JPRB,1.2114E-01_JPRB/)
KAO( :, 3, 2, 8) = (/&
&4.9812E-01_JPRB,4.6732E-01_JPRB,4.3492E-01_JPRB,3.9791E-01_JPRB,3.5518E-01_JPRB,3.0663E-01_JPRB,&
&2.5073E-01_JPRB,1.8486E-01_JPRB,1.4281E-01_JPRB,1.4075E-01_JPRB,1.4376E-01_JPRB/)
KAO( :, 4, 2, 8) = (/&
&4.9623E-01_JPRB,4.7200E-01_JPRB,4.4361E-01_JPRB,4.0869E-01_JPRB,3.6716E-01_JPRB,3.2094E-01_JPRB,&
&2.6503E-01_JPRB,2.0038E-01_JPRB,1.6450E-01_JPRB,1.6447E-01_JPRB,1.6812E-01_JPRB/)
KAO( :, 5, 2, 8) = (/&
&4.9443E-01_JPRB,4.7565E-01_JPRB,4.5245E-01_JPRB,4.1884E-01_JPRB,3.7991E-01_JPRB,3.3502E-01_JPRB,&
&2.7893E-01_JPRB,2.1726E-01_JPRB,1.8823E-01_JPRB,1.8992E-01_JPRB,1.9426E-01_JPRB/)
KAO( :, 1, 3, 8) = (/&
&5.0316E-01_JPRB,4.6054E-01_JPRB,4.1948E-01_JPRB,3.7358E-01_JPRB,3.2537E-01_JPRB,2.7199E-01_JPRB,&
&2.1201E-01_JPRB,1.4405E-01_JPRB,9.1061E-02_JPRB,7.8216E-02_JPRB,7.8431E-02_JPRB/)
KAO( :, 2, 3, 8) = (/&
&5.0250E-01_JPRB,4.6508E-01_JPRB,4.2753E-01_JPRB,3.8448E-01_JPRB,3.3743E-01_JPRB,2.8477E-01_JPRB,&
&2.2471E-01_JPRB,1.5690E-01_JPRB,1.0463E-01_JPRB,9.5297E-02_JPRB,9.5775E-02_JPRB/)
KAO( :, 3, 3, 8) = (/&
&5.0156E-01_JPRB,4.7034E-01_JPRB,4.3587E-01_JPRB,3.9592E-01_JPRB,3.4938E-01_JPRB,2.9738E-01_JPRB,&
&2.3781E-01_JPRB,1.6990E-01_JPRB,1.2021E-01_JPRB,1.1406E-01_JPRB,1.1481E-01_JPRB/)
KAO( :, 4, 3, 8) = (/&
&5.0040E-01_JPRB,4.7526E-01_JPRB,4.4463E-01_JPRB,4.0641E-01_JPRB,3.6112E-01_JPRB,3.1063E-01_JPRB,&
&2.5089E-01_JPRB,1.8361E-01_JPRB,1.3795E-01_JPRB,1.3453E-01_JPRB,1.3558E-01_JPRB/)
KAO( :, 5, 3, 8) = (/&
&4.9904E-01_JPRB,4.7934E-01_JPRB,4.5345E-01_JPRB,4.1619E-01_JPRB,3.7327E-01_JPRB,3.2376E-01_JPRB,&
&2.6376E-01_JPRB,1.9847E-01_JPRB,1.5778E-01_JPRB,1.5659E-01_JPRB,1.5798E-01_JPRB/)
KAO( :, 1, 4, 8) = (/&
&4.9806E-01_JPRB,4.5577E-01_JPRB,4.1390E-01_JPRB,3.6716E-01_JPRB,3.1756E-01_JPRB,2.6347E-01_JPRB,&
&2.0234E-01_JPRB,1.3271E-01_JPRB,7.8950E-02_JPRB,6.0980E-02_JPRB,6.0379E-02_JPRB/)
KAO( :, 2, 4, 8) = (/&
&4.9826E-01_JPRB,4.6101E-01_JPRB,4.2242E-01_JPRB,3.7800E-01_JPRB,3.3007E-01_JPRB,2.7585E-01_JPRB,&
&2.1397E-01_JPRB,1.4413E-01_JPRB,8.9794E-02_JPRB,7.4947E-02_JPRB,7.4639E-02_JPRB/)
KAO( :, 3, 4, 8) = (/&
&4.9811E-01_JPRB,4.6681E-01_JPRB,4.3096E-01_JPRB,3.8962E-01_JPRB,3.4219E-01_JPRB,2.8784E-01_JPRB,&
&2.2620E-01_JPRB,1.5584E-01_JPRB,1.0227E-01_JPRB,9.0609E-02_JPRB,9.0488E-02_JPRB/)
KAO( :, 4, 4, 8) = (/&
&4.9746E-01_JPRB,4.7213E-01_JPRB,4.3992E-01_JPRB,4.0060E-01_JPRB,3.5359E-01_JPRB,3.0001E-01_JPRB,&
&2.3826E-01_JPRB,1.6835E-01_JPRB,1.1655E-01_JPRB,1.0791E-01_JPRB,1.0795E-01_JPRB/)
KAO( :, 5, 4, 8) = (/&
&4.9635E-01_JPRB,4.7672E-01_JPRB,4.4914E-01_JPRB,4.1061E-01_JPRB,3.6511E-01_JPRB,3.1218E-01_JPRB,&
&2.5028E-01_JPRB,1.8187E-01_JPRB,1.3226E-01_JPRB,1.2654E-01_JPRB,1.2673E-01_JPRB/)
KAO( :, 1, 5, 8) = (/&
&4.8638E-01_JPRB,4.4445E-01_JPRB,4.0240E-01_JPRB,3.5595E-01_JPRB,3.0624E-01_JPRB,2.5236E-01_JPRB,&
&1.9246E-01_JPRB,1.2312E-01_JPRB,6.9001E-02_JPRB,4.7715E-02_JPRB,4.6683E-02_JPRB/)
KAO( :, 2, 5, 8) = (/&
&4.8710E-01_JPRB,4.5014E-01_JPRB,4.1145E-01_JPRB,3.6700E-01_JPRB,3.1862E-01_JPRB,2.6463E-01_JPRB,&
&2.0376E-01_JPRB,1.3331E-01_JPRB,7.8352E-02_JPRB,5.8722E-02_JPRB,5.8068E-02_JPRB/)
KAO( :, 3, 5, 8) = (/&
&4.8733E-01_JPRB,4.5646E-01_JPRB,4.2038E-01_JPRB,3.7871E-01_JPRB,3.3086E-01_JPRB,2.7657E-01_JPRB,&
&2.1509E-01_JPRB,1.4382E-01_JPRB,8.8703E-02_JPRB,7.1451E-02_JPRB,7.1075E-02_JPRB/)
KAO( :, 4, 5, 8) = (/&
&4.8688E-01_JPRB,4.6221E-01_JPRB,4.2956E-01_JPRB,3.8977E-01_JPRB,3.4249E-01_JPRB,2.8843E-01_JPRB,&
&2.2638E-01_JPRB,1.5517E-01_JPRB,1.0010E-01_JPRB,8.5586E-02_JPRB,8.5398E-02_JPRB/)
KAO( :, 5, 5, 8) = (/&
&4.8605E-01_JPRB,4.6725E-01_JPRB,4.3887E-01_JPRB,4.0002E-01_JPRB,3.5369E-01_JPRB,3.0008E-01_JPRB,&
&2.3780E-01_JPRB,1.6738E-01_JPRB,1.1249E-01_JPRB,1.0093E-01_JPRB,1.0091E-01_JPRB/)
KAO( :, 1, 6, 8) = (/&
&4.6671E-01_JPRB,4.2600E-01_JPRB,3.8466E-01_JPRB,3.3926E-01_JPRB,2.9061E-01_JPRB,2.3768E-01_JPRB,&
&1.7963E-01_JPRB,1.1420E-01_JPRB,6.0552E-02_JPRB,3.7850E-02_JPRB,4.1921E-02_JPRB/)
KAO( :, 2, 6, 8) = (/&
&4.6803E-01_JPRB,4.3203E-01_JPRB,3.9392E-01_JPRB,3.5053E-01_JPRB,3.0269E-01_JPRB,2.4962E-01_JPRB,&
&1.9077E-01_JPRB,1.2351E-01_JPRB,6.8512E-02_JPRB,4.6284E-02_JPRB,5.0049E-02_JPRB/)
KAO( :, 3, 6, 8) = (/&
&4.6842E-01_JPRB,4.3840E-01_JPRB,4.0304E-01_JPRB,3.6198E-01_JPRB,3.1472E-01_JPRB,2.6142E-01_JPRB,&
&2.0201E-01_JPRB,1.3304E-01_JPRB,7.7462E-02_JPRB,5.6089E-02_JPRB,5.9440E-02_JPRB/)
KAO( :, 4, 6, 8) = (/&
&4.6834E-01_JPRB,4.4438E-01_JPRB,4.1233E-01_JPRB,3.7291E-01_JPRB,3.2609E-01_JPRB,2.7299E-01_JPRB,&
&2.1298E-01_JPRB,1.4322E-01_JPRB,8.7054E-02_JPRB,6.7233E-02_JPRB,7.0024E-02_JPRB/)
KAO( :, 5, 6, 8) = (/&
&4.6792E-01_JPRB,4.4990E-01_JPRB,4.2136E-01_JPRB,3.8305E-01_JPRB,3.3708E-01_JPRB,2.8431E-01_JPRB,&
&2.2411E-01_JPRB,1.5430E-01_JPRB,9.7088E-02_JPRB,7.9618E-02_JPRB,8.1792E-02_JPRB/)
KAO( :, 1, 7, 8) = (/&
&4.3699E-01_JPRB,3.9837E-01_JPRB,3.5896E-01_JPRB,3.1590E-01_JPRB,2.6958E-01_JPRB,2.1919E-01_JPRB,&
&1.6418E-01_JPRB,1.0344E-01_JPRB,5.3382E-02_JPRB,3.0831E-02_JPRB,4.2953E-02_JPRB/)
KAO( :, 2, 7, 8) = (/&
&4.3843E-01_JPRB,4.0448E-01_JPRB,3.6812E-01_JPRB,3.2701E-01_JPRB,2.8124E-01_JPRB,2.3050E-01_JPRB,&
&1.7482E-01_JPRB,1.1234E-01_JPRB,6.0200E-02_JPRB,3.7229E-02_JPRB,5.0680E-02_JPRB/)
KAO( :, 3, 7, 8) = (/&
&4.3919E-01_JPRB,4.1086E-01_JPRB,3.7731E-01_JPRB,3.3799E-01_JPRB,2.9265E-01_JPRB,2.4169E-01_JPRB,&
&1.8565E-01_JPRB,1.2131E-01_JPRB,6.7916E-02_JPRB,4.4736E-02_JPRB,5.9303E-02_JPRB/)
KAO( :, 4, 7, 8) = (/&
&4.3964E-01_JPRB,4.1709E-01_JPRB,3.8642E-01_JPRB,3.4844E-01_JPRB,3.0343E-01_JPRB,2.5289E-01_JPRB,&
&1.9633E-01_JPRB,1.3094E-01_JPRB,7.6222E-02_JPRB,5.3326E-02_JPRB,6.8509E-02_JPRB/)
KAO( :, 5, 7, 8) = (/&
&4.3947E-01_JPRB,4.2288E-01_JPRB,3.9537E-01_JPRB,3.5832E-01_JPRB,3.1399E-01_JPRB,2.6369E-01_JPRB,&
&2.0720E-01_JPRB,1.4134E-01_JPRB,8.4840E-02_JPRB,6.3000E-02_JPRB,7.8182E-02_JPRB/)
KAO( :, 1, 8, 8) = (/&
&4.0095E-01_JPRB,3.6508E-01_JPRB,3.2839E-01_JPRB,2.8828E-01_JPRB,2.4526E-01_JPRB,1.9846E-01_JPRB,&
&1.4746E-01_JPRB,9.1777E-02_JPRB,4.6862E-02_JPRB,2.5767E-02_JPRB,4.9298E-02_JPRB/)
KAO( :, 2, 8, 8) = (/&
&4.0247E-01_JPRB,3.7108E-01_JPRB,3.3718E-01_JPRB,2.9895E-01_JPRB,2.5608E-01_JPRB,2.0883E-01_JPRB,&
&1.5736E-01_JPRB,1.0019E-01_JPRB,5.2944E-02_JPRB,3.0729E-02_JPRB,5.6721E-02_JPRB/)
KAO( :, 3, 8, 8) = (/&
&4.0379E-01_JPRB,3.7769E-01_JPRB,3.4624E-01_JPRB,3.0913E-01_JPRB,2.6652E-01_JPRB,2.1917E-01_JPRB,&
&1.6744E-01_JPRB,1.0879E-01_JPRB,5.9618E-02_JPRB,3.6479E-02_JPRB,6.5019E-02_JPRB/)
KAO( :, 4, 8, 8) = (/&
&4.0440E-01_JPRB,3.8393E-01_JPRB,3.5518E-01_JPRB,3.1911E-01_JPRB,2.7671E-01_JPRB,2.2954E-01_JPRB,&
&1.7755E-01_JPRB,1.1776E-01_JPRB,6.6811E-02_JPRB,4.3078E-02_JPRB,7.4113E-02_JPRB/)
KAO( :, 5, 8, 8) = (/&
&4.0446E-01_JPRB,3.8965E-01_JPRB,3.6366E-01_JPRB,3.2844E-01_JPRB,2.8667E-01_JPRB,2.3995E-01_JPRB,&
&1.8784E-01_JPRB,1.2743E-01_JPRB,7.4347E-02_JPRB,5.0583E-02_JPRB,8.3692E-02_JPRB/)
KAO( :, 1, 9, 8) = (/&
&3.6220E-01_JPRB,3.2943E-01_JPRB,2.9565E-01_JPRB,2.5888E-01_JPRB,2.1956E-01_JPRB,1.7688E-01_JPRB,&
&1.3053E-01_JPRB,8.0073E-02_JPRB,4.0469E-02_JPRB,2.1839E-02_JPRB,9.4199E-02_JPRB/)
KAO( :, 2, 9, 8) = (/&
&3.6411E-01_JPRB,3.3547E-01_JPRB,3.0414E-01_JPRB,2.6872E-01_JPRB,2.2935E-01_JPRB,1.8612E-01_JPRB,&
&1.3939E-01_JPRB,8.7821E-02_JPRB,4.5931E-02_JPRB,2.5820E-02_JPRB,1.0332E-01_JPRB/)
KAO( :, 3, 9, 8) = (/&
&3.6566E-01_JPRB,3.4191E-01_JPRB,3.1284E-01_JPRB,2.7831E-01_JPRB,2.3893E-01_JPRB,1.9553E-01_JPRB,&
&1.4849E-01_JPRB,9.5850E-02_JPRB,5.1870E-02_JPRB,3.0419E-02_JPRB,1.1365E-01_JPRB/)
KAO( :, 4, 9, 8) = (/&
&3.6634E-01_JPRB,3.4783E-01_JPRB,3.2112E-01_JPRB,2.8747E-01_JPRB,2.4838E-01_JPRB,2.0518E-01_JPRB,&
&1.5786E-01_JPRB,1.0419E-01_JPRB,5.8269E-02_JPRB,3.5620E-02_JPRB,1.2479E-01_JPRB/)
KAO( :, 5, 9, 8) = (/&
&3.6687E-01_JPRB,3.5352E-01_JPRB,3.2900E-01_JPRB,2.9611E-01_JPRB,2.5769E-01_JPRB,2.1498E-01_JPRB,&
&1.6749E-01_JPRB,1.1307E-01_JPRB,6.4929E-02_JPRB,4.1475E-02_JPRB,1.3690E-01_JPRB/)
KAO( :, 1,10, 8) = (/&
&3.2199E-01_JPRB,2.9278E-01_JPRB,2.6222E-01_JPRB,2.2905E-01_JPRB,1.9373E-01_JPRB,1.5558E-01_JPRB,&
&1.1424E-01_JPRB,6.9413E-02_JPRB,3.4798E-02_JPRB,1.8896E-02_JPRB,2.8335E-01_JPRB/)
KAO( :, 2,10, 8) = (/&
&3.2419E-01_JPRB,2.9882E-01_JPRB,2.7031E-01_JPRB,2.3822E-01_JPRB,2.0265E-01_JPRB,1.6381E-01_JPRB,&
&1.2203E-01_JPRB,7.6200E-02_JPRB,3.9653E-02_JPRB,2.2203E-02_JPRB,3.0010E-01_JPRB/)
KAO( :, 3,10, 8) = (/&
&3.2557E-01_JPRB,3.0468E-01_JPRB,2.7841E-01_JPRB,2.4694E-01_JPRB,2.1134E-01_JPRB,1.7240E-01_JPRB,&
&1.3024E-01_JPRB,8.3423E-02_JPRB,4.4862E-02_JPRB,2.6006E-02_JPRB,3.2041E-01_JPRB/)
KAO( :, 4,10, 8) = (/&
&3.2676E-01_JPRB,3.1040E-01_JPRB,2.8596E-01_JPRB,2.5507E-01_JPRB,2.1988E-01_JPRB,1.8121E-01_JPRB,&
&1.3879E-01_JPRB,9.0984E-02_JPRB,5.0519E-02_JPRB,3.0296E-02_JPRB,3.4283E-01_JPRB/)
KAO( :, 5,10, 8) = (/&
&3.2756E-01_JPRB,3.1604E-01_JPRB,2.9325E-01_JPRB,2.6321E-01_JPRB,2.2857E-01_JPRB,1.9016E-01_JPRB,&
&1.4762E-01_JPRB,9.9000E-02_JPRB,5.6488E-02_JPRB,3.5105E-02_JPRB,3.6677E-01_JPRB/)
KAO( :, 1,11, 8) = (/&
&2.8411E-01_JPRB,2.5988E-01_JPRB,2.3321E-01_JPRB,2.0412E-01_JPRB,1.7249E-01_JPRB,1.3838E-01_JPRB,&
&1.0172E-01_JPRB,6.2178E-02_JPRB,3.1646E-02_JPRB,1.7506E-02_JPRB,3.9917E-01_JPRB/)
KAO( :, 2,11, 8) = (/&
&2.8582E-01_JPRB,2.6534E-01_JPRB,2.4057E-01_JPRB,2.1213E-01_JPRB,1.8034E-01_JPRB,1.4593E-01_JPRB,&
&1.0888E-01_JPRB,6.8210E-02_JPRB,3.6011E-02_JPRB,2.0567E-02_JPRB,4.2270E-01_JPRB/)
KAO( :, 3,11, 8) = (/&
&2.8739E-01_JPRB,2.7084E-01_JPRB,2.4780E-01_JPRB,2.1959E-01_JPRB,1.8803E-01_JPRB,1.5372E-01_JPRB,&
&1.1636E-01_JPRB,7.4695E-02_JPRB,4.0724E-02_JPRB,2.3986E-02_JPRB,4.4934E-01_JPRB/)
KAO( :, 4,11, 8) = (/&
&2.8878E-01_JPRB,2.7644E-01_JPRB,2.5472E-01_JPRB,2.2709E-01_JPRB,1.9597E-01_JPRB,1.6177E-01_JPRB,&
&1.2408E-01_JPRB,8.1642E-02_JPRB,4.5765E-02_JPRB,2.7772E-02_JPRB,4.7717E-01_JPRB/)
KAO( :, 5,11, 8) = (/&
&2.8955E-01_JPRB,2.8144E-01_JPRB,2.6102E-01_JPRB,2.3454E-01_JPRB,2.0411E-01_JPRB,1.7002E-01_JPRB,&
&1.3228E-01_JPRB,8.8823E-02_JPRB,5.1141E-02_JPRB,3.2010E-02_JPRB,5.0557E-01_JPRB/)
KAO( :, 1,12, 8) = (/&
&2.4710E-01_JPRB,2.2747E-01_JPRB,2.0446E-01_JPRB,1.7910E-01_JPRB,1.5126E-01_JPRB,1.2141E-01_JPRB,&
&8.9466E-02_JPRB,5.4973E-02_JPRB,2.8499E-02_JPRB,1.5999E-02_JPRB,4.2800E-01_JPRB/)
KAO( :, 2,12, 8) = (/&
&2.4901E-01_JPRB,2.3258E-01_JPRB,2.1111E-01_JPRB,1.8597E-01_JPRB,1.5805E-01_JPRB,1.2818E-01_JPRB,&
&9.5808E-02_JPRB,6.0321E-02_JPRB,3.2343E-02_JPRB,1.8809E-02_JPRB,4.5340E-01_JPRB/)
KAO( :, 3,12, 8) = (/&
&2.5080E-01_JPRB,2.3792E-01_JPRB,2.1766E-01_JPRB,1.9271E-01_JPRB,1.6525E-01_JPRB,1.3521E-01_JPRB,&
&1.0253E-01_JPRB,6.6046E-02_JPRB,3.6536E-02_JPRB,2.1931E-02_JPRB,4.7921E-01_JPRB/)
KAO( :, 4,12, 8) = (/&
&2.5204E-01_JPRB,2.4277E-01_JPRB,2.2355E-01_JPRB,1.9948E-01_JPRB,1.7252E-01_JPRB,1.4258E-01_JPRB,&
&1.0952E-01_JPRB,7.2180E-02_JPRB,4.1025E-02_JPRB,2.5368E-02_JPRB,5.0641E-01_JPRB/)
KAO( :, 5,12, 8) = (/&
&2.5346E-01_JPRB,2.4761E-01_JPRB,2.2936E-01_JPRB,2.0632E-01_JPRB,1.7985E-01_JPRB,1.5006E-01_JPRB,&
&1.1690E-01_JPRB,7.8517E-02_JPRB,4.5825E-02_JPRB,2.9158E-02_JPRB,5.3542E-01_JPRB/)
KAO( :, 1,13, 8) = (/&
&2.1104E-01_JPRB,1.9539E-01_JPRB,1.7591E-01_JPRB,1.5396E-01_JPRB,1.2999E-01_JPRB,1.0448E-01_JPRB,&
&7.7298E-02_JPRB,4.7962E-02_JPRB,2.5275E-02_JPRB,1.4360E-02_JPRB,3.6245E-01_JPRB/)
KAO( :, 2,13, 8) = (/&
&2.1306E-01_JPRB,2.0027E-01_JPRB,1.8186E-01_JPRB,1.6010E-01_JPRB,1.3622E-01_JPRB,1.1063E-01_JPRB,&
&8.2888E-02_JPRB,5.2545E-02_JPRB,2.8685E-02_JPRB,1.6930E-02_JPRB,3.8275E-01_JPRB/)
KAO( :, 3,13, 8) = (/&
&2.1469E-01_JPRB,2.0496E-01_JPRB,1.8742E-01_JPRB,1.6612E-01_JPRB,1.4267E-01_JPRB,1.1693E-01_JPRB,&
&8.8832E-02_JPRB,5.7525E-02_JPRB,3.2378E-02_JPRB,1.9762E-02_JPRB,4.0424E-01_JPRB/)
KAO( :, 4,13, 8) = (/&
&2.1644E-01_JPRB,2.0961E-01_JPRB,1.9285E-01_JPRB,1.7222E-01_JPRB,1.4919E-01_JPRB,1.2339E-01_JPRB,&
&9.4996E-02_JPRB,6.2832E-02_JPRB,3.6346E-02_JPRB,2.2885E-02_JPRB,4.2761E-01_JPRB/)
KAO( :, 5,13, 8) = (/&
&2.1812E-01_JPRB,2.1428E-01_JPRB,1.9853E-01_JPRB,1.7877E-01_JPRB,1.5586E-01_JPRB,1.3014E-01_JPRB,&
&1.0138E-01_JPRB,6.8371E-02_JPRB,4.0590E-02_JPRB,2.6305E-02_JPRB,4.5224E-01_JPRB/)
KAO( :, 1, 1, 9) = (/&
&9.5159E-01_JPRB,8.6193E-01_JPRB,7.8445E-01_JPRB,7.0786E-01_JPRB,6.2475E-01_JPRB,5.4735E-01_JPRB,&
&4.7357E-01_JPRB,4.3191E-01_JPRB,4.5105E-01_JPRB,4.6500E-01_JPRB,4.7768E-01_JPRB/)
KAO( :, 2, 1, 9) = (/&
&9.4610E-01_JPRB,8.6636E-01_JPRB,7.9453E-01_JPRB,7.2334E-01_JPRB,6.4819E-01_JPRB,5.8098E-01_JPRB,&
&5.1867E-01_JPRB,5.0225E-01_JPRB,5.3434E-01_JPRB,5.5100E-01_JPRB,5.6593E-01_JPRB/)
KAO( :, 3, 1, 9) = (/&
&9.4063E-01_JPRB,8.6755E-01_JPRB,8.0500E-01_JPRB,7.3756E-01_JPRB,6.7496E-01_JPRB,6.1686E-01_JPRB,&
&5.7144E-01_JPRB,5.7997E-01_JPRB,6.2451E-01_JPRB,6.4411E-01_JPRB,6.6119E-01_JPRB/)
KAO( :, 4, 1, 9) = (/&
&9.3410E-01_JPRB,8.6712E-01_JPRB,8.1423E-01_JPRB,7.5391E-01_JPRB,7.0437E-01_JPRB,6.5593E-01_JPRB,&
&6.3263E-01_JPRB,6.6511E-01_JPRB,7.2065E-01_JPRB,7.4338E-01_JPRB,7.6295E-01_JPRB/)
KAO( :, 5, 1, 9) = (/&
&9.2639E-01_JPRB,8.6753E-01_JPRB,8.2122E-01_JPRB,7.7366E-01_JPRB,7.3498E-01_JPRB,7.0006E-01_JPRB,&
&7.0131E-01_JPRB,7.5726E-01_JPRB,8.2266E-01_JPRB,8.4882E-01_JPRB,8.7078E-01_JPRB/)
KAO( :, 1, 2, 9) = (/&
&9.9571E-01_JPRB,8.9920E-01_JPRB,8.1614E-01_JPRB,7.3263E-01_JPRB,6.4026E-01_JPRB,5.4806E-01_JPRB,&
&4.6027E-01_JPRB,3.9041E-01_JPRB,3.9261E-01_JPRB,4.0467E-01_JPRB,4.1298E-01_JPRB/)
KAO( :, 2, 2, 9) = (/&
&9.8996E-01_JPRB,9.0283E-01_JPRB,8.2671E-01_JPRB,7.4790E-01_JPRB,6.6191E-01_JPRB,5.7890E-01_JPRB,&
&4.9929E-01_JPRB,4.5184E-01_JPRB,4.6916E-01_JPRB,4.8383E-01_JPRB,4.9391E-01_JPRB/)
KAO( :, 3, 2, 9) = (/&
&9.8376E-01_JPRB,9.0392E-01_JPRB,8.3729E-01_JPRB,7.6239E-01_JPRB,6.8599E-01_JPRB,6.1186E-01_JPRB,&
&5.4354E-01_JPRB,5.2118E-01_JPRB,5.5194E-01_JPRB,5.6942E-01_JPRB,5.8138E-01_JPRB/)
KAO( :, 4, 2, 9) = (/&
&9.7691E-01_JPRB,9.0424E-01_JPRB,8.4680E-01_JPRB,7.7835E-01_JPRB,7.1309E-01_JPRB,6.4690E-01_JPRB,&
&5.9506E-01_JPRB,5.9772E-01_JPRB,6.4088E-01_JPRB,6.6141E-01_JPRB,6.7534E-01_JPRB/)
KAO( :, 5, 2, 9) = (/&
&9.6899E-01_JPRB,9.0591E-01_JPRB,8.5458E-01_JPRB,7.9701E-01_JPRB,7.4146E-01_JPRB,6.8466E-01_JPRB,&
&6.5376E-01_JPRB,6.8054E-01_JPRB,7.3475E-01_JPRB,7.5849E-01_JPRB,7.7486E-01_JPRB/)
KAO( :, 1, 3, 9) = (/&
&1.0405E+00_JPRB,9.3488E-01_JPRB,8.4463E-01_JPRB,7.5330E-01_JPRB,6.5244E-01_JPRB,5.4916E-01_JPRB,&
&4.4520E-01_JPRB,3.4870E-01_JPRB,3.2584E-01_JPRB,3.3543E-01_JPRB,3.3962E-01_JPRB/)
KAO( :, 2, 3, 9) = (/&
&1.0349E+00_JPRB,9.3892E-01_JPRB,8.5534E-01_JPRB,7.6913E-01_JPRB,6.7395E-01_JPRB,5.7625E-01_JPRB,&
&4.7914E-01_JPRB,3.9837E-01_JPRB,3.9325E-01_JPRB,4.0529E-01_JPRB,4.1035E-01_JPRB/)
KAO( :, 3, 3, 9) = (/&
&1.0286E+00_JPRB,9.4087E-01_JPRB,8.6735E-01_JPRB,7.8384E-01_JPRB,6.9647E-01_JPRB,6.0649E-01_JPRB,&
&5.1617E-01_JPRB,4.5626E-01_JPRB,4.6701E-01_JPRB,4.8157E-01_JPRB,4.8769E-01_JPRB/)
KAO( :, 4, 3, 9) = (/&
&1.0216E+00_JPRB,9.4194E-01_JPRB,8.7769E-01_JPRB,8.0047E-01_JPRB,7.2103E-01_JPRB,6.3769E-01_JPRB,&
&5.5844E-01_JPRB,5.2182E-01_JPRB,5.4652E-01_JPRB,5.6383E-01_JPRB,5.7106E-01_JPRB/)
KAO( :, 5, 3, 9) = (/&
&1.0137E+00_JPRB,9.4403E-01_JPRB,8.8589E-01_JPRB,8.1893E-01_JPRB,7.4713E-01_JPRB,6.7001E-01_JPRB,&
&6.0589E-01_JPRB,5.9289E-01_JPRB,6.3020E-01_JPRB,6.5037E-01_JPRB,6.5878E-01_JPRB/)
KAO( :, 1, 4, 9) = (/&
&1.0880E+00_JPRB,9.7313E-01_JPRB,8.7384E-01_JPRB,7.7222E-01_JPRB,6.6520E-01_JPRB,5.5149E-01_JPRB,&
&4.3468E-01_JPRB,3.1551E-01_JPRB,2.6473E-01_JPRB,2.7010E-01_JPRB,2.7211E-01_JPRB/)
KAO( :, 2, 4, 9) = (/&
&1.0823E+00_JPRB,9.7690E-01_JPRB,8.8415E-01_JPRB,7.9011E-01_JPRB,6.8589E-01_JPRB,5.7725E-01_JPRB,&
&4.6480E-01_JPRB,3.5528E-01_JPRB,3.2290E-01_JPRB,3.3154E-01_JPRB,3.3402E-01_JPRB/)
KAO( :, 3, 4, 9) = (/&
&1.0759E+00_JPRB,9.7896E-01_JPRB,8.9677E-01_JPRB,8.0590E-01_JPRB,7.0747E-01_JPRB,6.0512E-01_JPRB,&
&4.9649E-01_JPRB,4.0248E-01_JPRB,3.8741E-01_JPRB,3.9884E-01_JPRB,4.0190E-01_JPRB/)
KAO( :, 4, 4, 9) = (/&
&1.0687E+00_JPRB,9.8058E-01_JPRB,9.0886E-01_JPRB,8.2235E-01_JPRB,7.3113E-01_JPRB,6.3357E-01_JPRB,&
&5.3180E-01_JPRB,4.5630E-01_JPRB,4.5720E-01_JPRB,4.7127E-01_JPRB,4.7487E-01_JPRB/)
KAO( :, 5, 4, 9) = (/&
&1.0611E+00_JPRB,9.8340E-01_JPRB,9.1796E-01_JPRB,8.4063E-01_JPRB,7.5604E-01_JPRB,6.6259E-01_JPRB,&
&5.7101E-01_JPRB,5.1566E-01_JPRB,5.3169E-01_JPRB,5.4837E-01_JPRB,5.5265E-01_JPRB/)
KAO( :, 1, 5, 9) = (/&
&1.1353E+00_JPRB,1.0122E+00_JPRB,9.0436E-01_JPRB,7.9314E-01_JPRB,6.7788E-01_JPRB,5.5661E-01_JPRB,&
&4.2870E-01_JPRB,2.9193E-01_JPRB,2.1579E-01_JPRB,2.1412E-01_JPRB,2.1527E-01_JPRB/)
KAO( :, 2, 5, 9) = (/&
&1.1302E+00_JPRB,1.0164E+00_JPRB,9.1463E-01_JPRB,8.1125E-01_JPRB,6.9965E-01_JPRB,5.8117E-01_JPRB,&
&4.5601E-01_JPRB,3.2431E-01_JPRB,2.6337E-01_JPRB,2.6679E-01_JPRB,2.6824E-01_JPRB/)
KAO( :, 3, 5, 9) = (/&
&1.1241E+00_JPRB,1.0191E+00_JPRB,9.2734E-01_JPRB,8.2845E-01_JPRB,7.2101E-01_JPRB,6.0737E-01_JPRB,&
&4.8451E-01_JPRB,3.6228E-01_JPRB,3.1806E-01_JPRB,3.2529E-01_JPRB,3.2713E-01_JPRB/)
KAO( :, 4, 5, 9) = (/&
&1.1173E+00_JPRB,1.0209E+00_JPRB,9.4019E-01_JPRB,8.4617E-01_JPRB,7.4384E-01_JPRB,6.3435E-01_JPRB,&
&5.1515E-01_JPRB,4.0564E-01_JPRB,3.7849E-01_JPRB,3.8902E-01_JPRB,3.9122E-01_JPRB/)
KAO( :, 5, 5, 9) = (/&
&1.1101E+00_JPRB,1.0243E+00_JPRB,9.5096E-01_JPRB,8.6410E-01_JPRB,7.6849E-01_JPRB,6.6158E-01_JPRB,&
&5.4858E-01_JPRB,4.5511E-01_JPRB,4.4484E-01_JPRB,4.5817E-01_JPRB,4.6081E-01_JPRB/)
KAO( :, 1, 6, 9) = (/&
&1.1806E+00_JPRB,1.0498E+00_JPRB,9.3337E-01_JPRB,8.1273E-01_JPRB,6.8998E-01_JPRB,5.6047E-01_JPRB,&
&4.2456E-01_JPRB,2.7532E-01_JPRB,1.7725E-01_JPRB,1.6538E-01_JPRB,1.6672E-01_JPRB/)
KAO( :, 2, 6, 9) = (/&
&1.1761E+00_JPRB,1.0541E+00_JPRB,9.4371E-01_JPRB,8.3128E-01_JPRB,7.1158E-01_JPRB,5.8532E-01_JPRB,&
&4.4996E-01_JPRB,3.0144E-01_JPRB,2.1482E-01_JPRB,2.0943E-01_JPRB,2.1089E-01_JPRB/)
KAO( :, 3, 6, 9) = (/&
&1.1706E+00_JPRB,1.0579E+00_JPRB,9.5635E-01_JPRB,8.4936E-01_JPRB,7.3343E-01_JPRB,6.1037E-01_JPRB,&
&4.7682E-01_JPRB,3.3219E-01_JPRB,2.5890E-01_JPRB,2.5930E-01_JPRB,2.6088E-01_JPRB/)
KAO( :, 4, 6, 9) = (/&
&1.1647E+00_JPRB,1.0607E+00_JPRB,9.7013E-01_JPRB,8.6759E-01_JPRB,7.5661E-01_JPRB,6.3681E-01_JPRB,&
&5.0490E-01_JPRB,3.6744E-01_JPRB,3.0939E-01_JPRB,3.1452E-01_JPRB,3.1634E-01_JPRB/)
KAO( :, 5, 6, 9) = (/&
&1.1580E+00_JPRB,1.0646E+00_JPRB,9.8251E-01_JPRB,8.8607E-01_JPRB,7.8101E-01_JPRB,6.6342E-01_JPRB,&
&5.3428E-01_JPRB,4.0750E-01_JPRB,3.6653E-01_JPRB,3.7539E-01_JPRB,3.7760E-01_JPRB/)
KAO( :, 1, 7, 9) = (/&
&1.2136E+00_JPRB,1.0774E+00_JPRB,9.5377E-01_JPRB,8.2536E-01_JPRB,6.9593E-01_JPRB,5.6078E-01_JPRB,&
&4.1863E-01_JPRB,2.6313E-01_JPRB,1.4935E-01_JPRB,1.2578E-01_JPRB,1.4257E-01_JPRB/)
KAO( :, 2, 7, 9) = (/&
&1.2100E+00_JPRB,1.0820E+00_JPRB,9.6432E-01_JPRB,8.4363E-01_JPRB,7.1756E-01_JPRB,5.8508E-01_JPRB,&
&4.4339E-01_JPRB,2.8645E-01_JPRB,1.7844E-01_JPRB,1.6196E-01_JPRB,1.7527E-01_JPRB/)
KAO( :, 3, 7, 9) = (/&
&1.2053E+00_JPRB,1.0866E+00_JPRB,9.7664E-01_JPRB,8.6237E-01_JPRB,7.3986E-01_JPRB,6.1018E-01_JPRB,&
&4.6912E-01_JPRB,3.1223E-01_JPRB,2.1332E-01_JPRB,2.0363E-01_JPRB,2.1371E-01_JPRB/)
KAO( :, 4, 7, 9) = (/&
&1.1998E+00_JPRB,1.0903E+00_JPRB,9.9072E-01_JPRB,8.8131E-01_JPRB,7.6315E-01_JPRB,6.3674E-01_JPRB,&
&4.9590E-01_JPRB,3.4090E-01_JPRB,2.5438E-01_JPRB,2.5086E-01_JPRB,2.5825E-01_JPRB/)
KAO( :, 5, 7, 9) = (/&
&1.1932E+00_JPRB,1.0942E+00_JPRB,1.0040E+00_JPRB,9.0033E-01_JPRB,7.8781E-01_JPRB,6.6359E-01_JPRB,&
&5.2347E-01_JPRB,3.7392E-01_JPRB,3.0186E-01_JPRB,3.0359E-01_JPRB,3.0908E-01_JPRB/)
KAO( :, 1, 8, 9) = (/&
&1.2316E+00_JPRB,1.0924E+00_JPRB,9.6349E-01_JPRB,8.3019E-01_JPRB,6.9548E-01_JPRB,5.5575E-01_JPRB,&
&4.1003E-01_JPRB,2.5191E-01_JPRB,1.3039E-01_JPRB,9.5856E-02_JPRB,1.7533E-01_JPRB/)
KAO( :, 2, 8, 9) = (/&
&1.2282E+00_JPRB,1.0969E+00_JPRB,9.7419E-01_JPRB,8.4770E-01_JPRB,7.1665E-01_JPRB,5.7977E-01_JPRB,&
&4.3430E-01_JPRB,2.7347E-01_JPRB,1.5278E-01_JPRB,1.2456E-01_JPRB,2.0121E-01_JPRB/)
KAO( :, 3, 8, 9) = (/&
&1.2234E+00_JPRB,1.1017E+00_JPRB,9.8619E-01_JPRB,8.6635E-01_JPRB,7.3926E-01_JPRB,6.0504E-01_JPRB,&
&4.5959E-01_JPRB,2.9702E-01_JPRB,1.8008E-01_JPRB,1.5872E-01_JPRB,2.2963E-01_JPRB/)
KAO( :, 4, 8, 9) = (/&
&1.2179E+00_JPRB,1.1058E+00_JPRB,1.0001E+00_JPRB,8.8559E-01_JPRB,7.6296E-01_JPRB,6.3135E-01_JPRB,&
&4.8567E-01_JPRB,3.2261E-01_JPRB,2.1292E-01_JPRB,1.9834E-01_JPRB,2.6180E-01_JPRB/)
KAO( :, 5, 8, 9) = (/&
&1.2113E+00_JPRB,1.1100E+00_JPRB,1.0138E+00_JPRB,9.0571E-01_JPRB,7.8768E-01_JPRB,6.5815E-01_JPRB,&
&5.1266E-01_JPRB,3.5055E-01_JPRB,2.5143E-01_JPRB,2.4311E-01_JPRB,2.9921E-01_JPRB/)
KAO( :, 1, 9, 9) = (/&
&1.2312E+00_JPRB,1.0915E+00_JPRB,9.6019E-01_JPRB,8.2497E-01_JPRB,6.8804E-01_JPRB,5.4659E-01_JPRB,&
&3.9889E-01_JPRB,2.4010E-01_JPRB,1.1745E-01_JPRB,7.4115E-02_JPRB,3.8570E-01_JPRB/)
KAO( :, 2, 9, 9) = (/&
&1.2271E+00_JPRB,1.0952E+00_JPRB,9.7062E-01_JPRB,8.4182E-01_JPRB,7.0896E-01_JPRB,5.7001E-01_JPRB,&
&4.2261E-01_JPRB,2.6038E-01_JPRB,1.3539E-01_JPRB,9.6435E-02_JPRB,4.2073E-01_JPRB/)
KAO( :, 3, 9, 9) = (/&
&1.2221E+00_JPRB,1.0999E+00_JPRB,9.8223E-01_JPRB,8.6047E-01_JPRB,7.3167E-01_JPRB,5.9531E-01_JPRB,&
&4.4692E-01_JPRB,2.8236E-01_JPRB,1.5682E-01_JPRB,1.2365E-01_JPRB,4.5798E-01_JPRB/)
KAO( :, 4, 9, 9) = (/&
&1.2168E+00_JPRB,1.1048E+00_JPRB,9.9655E-01_JPRB,8.8042E-01_JPRB,7.5597E-01_JPRB,6.2078E-01_JPRB,&
&4.7224E-01_JPRB,3.0619E-01_JPRB,1.8270E-01_JPRB,1.5583E-01_JPRB,4.9794E-01_JPRB/)
KAO( :, 5, 9, 9) = (/&
&1.2103E+00_JPRB,1.1097E+00_JPRB,1.0110E+00_JPRB,9.0113E-01_JPRB,7.8074E-01_JPRB,6.4684E-01_JPRB,&
&4.9870E-01_JPRB,3.3189E-01_JPRB,2.1333E-01_JPRB,1.9294E-01_JPRB,5.3980E-01_JPRB/)
KAO( :, 1,10, 9) = (/&
&1.2065E+00_JPRB,1.0698E+00_JPRB,9.3983E-01_JPRB,8.0628E-01_JPRB,6.7075E-01_JPRB,5.3108E-01_JPRB,&
&3.8524E-01_JPRB,2.2846E-01_JPRB,1.0759E-01_JPRB,6.0114E-02_JPRB,1.2134E+00_JPRB/)
KAO( :, 2,10, 9) = (/&
&1.2021E+00_JPRB,1.0732E+00_JPRB,9.5006E-01_JPRB,8.2241E-01_JPRB,6.9118E-01_JPRB,5.5381E-01_JPRB,&
&4.0835E-01_JPRB,2.4753E-01_JPRB,1.2339E-01_JPRB,7.7390E-02_JPRB,1.2525E+00_JPRB/)
KAO( :, 3,10, 9) = (/&
&1.1979E+00_JPRB,1.0788E+00_JPRB,9.6194E-01_JPRB,8.4108E-01_JPRB,7.1368E-01_JPRB,5.7871E-01_JPRB,&
&4.3197E-01_JPRB,2.6832E-01_JPRB,1.4165E-01_JPRB,9.8913E-02_JPRB,1.2959E+00_JPRB/)
KAO( :, 4,10, 9) = (/&
&1.1924E+00_JPRB,1.0841E+00_JPRB,9.7645E-01_JPRB,8.6142E-01_JPRB,7.3813E-01_JPRB,6.0416E-01_JPRB,&
&4.5629E-01_JPRB,2.9111E-01_JPRB,1.6279E-01_JPRB,1.2496E-01_JPRB,1.3457E+00_JPRB/)
KAO( :, 5,10, 9) = (/&
&1.1868E+00_JPRB,1.0895E+00_JPRB,9.9148E-01_JPRB,8.8237E-01_JPRB,7.6307E-01_JPRB,6.3026E-01_JPRB,&
&4.8193E-01_JPRB,3.1564E-01_JPRB,1.8743E-01_JPRB,1.5518E-01_JPRB,1.4010E+00_JPRB/)
KAO( :, 1,11, 9) = (/&
&1.1602E+00_JPRB,1.0321E+00_JPRB,9.0888E-01_JPRB,7.8134E-01_JPRB,6.5183E-01_JPRB,5.1709E-01_JPRB,&
&3.7632E-01_JPRB,2.2357E-01_JPRB,1.0454E-01_JPRB,5.6265E-02_JPRB,1.7556E+00_JPRB/)
KAO( :, 2,11, 9) = (/&
&1.1566E+00_JPRB,1.0373E+00_JPRB,9.1992E-01_JPRB,7.9870E-01_JPRB,6.7250E-01_JPRB,5.3982E-01_JPRB,&
&3.9883E-01_JPRB,2.4238E-01_JPRB,1.1972E-01_JPRB,7.0995E-02_JPRB,1.7896E+00_JPRB/)
KAO( :, 3,11, 9) = (/&
&1.1521E+00_JPRB,1.0433E+00_JPRB,9.3315E-01_JPRB,8.1800E-01_JPRB,6.9552E-01_JPRB,5.6467E-01_JPRB,&
&4.2241E-01_JPRB,2.6285E-01_JPRB,1.3701E-01_JPRB,8.9495E-02_JPRB,1.8345E+00_JPRB/)
KAO( :, 4,11, 9) = (/&
&1.1472E+00_JPRB,1.0489E+00_JPRB,9.4806E-01_JPRB,8.3843E-01_JPRB,7.1973E-01_JPRB,5.9025E-01_JPRB,&
&4.4701E-01_JPRB,2.8499E-01_JPRB,1.5648E-01_JPRB,1.1176E-01_JPRB,1.8895E+00_JPRB/)
KAO( :, 5,11, 9) = (/&
&1.1436E+00_JPRB,1.0565E+00_JPRB,9.6473E-01_JPRB,8.6013E-01_JPRB,7.4475E-01_JPRB,6.1626E-01_JPRB,&
&4.7243E-01_JPRB,3.0896E-01_JPRB,1.7805E-01_JPRB,1.3759E-01_JPRB,1.9545E+00_JPRB/)
KAO( :, 1,12, 9) = (/&
&1.0927E+00_JPRB,9.7589E-01_JPRB,8.6130E-01_JPRB,7.4238E-01_JPRB,6.2051E-01_JPRB,4.9305E-01_JPRB,&
&3.5975E-01_JPRB,2.1463E-01_JPRB,1.0064E-01_JPRB,5.3171E-02_JPRB,1.9140E+00_JPRB/)
KAO( :, 2,12, 9) = (/&
&1.0892E+00_JPRB,9.8224E-01_JPRB,8.7322E-01_JPRB,7.6047E-01_JPRB,6.4152E-01_JPRB,5.1615E-01_JPRB,&
&3.8192E-01_JPRB,2.3322E-01_JPRB,1.1514E-01_JPRB,6.5840E-02_JPRB,1.9498E+00_JPRB/)
KAO( :, 3,12, 9) = (/&
&1.0852E+00_JPRB,9.8827E-01_JPRB,8.8733E-01_JPRB,7.7978E-01_JPRB,6.6433E-01_JPRB,5.4034E-01_JPRB,&
&4.0501E-01_JPRB,2.5357E-01_JPRB,1.3154E-01_JPRB,8.1554E-02_JPRB,2.0010E+00_JPRB/)
KAO( :, 4,12, 9) = (/&
&1.0828E+00_JPRB,9.9622E-01_JPRB,9.0368E-01_JPRB,8.0090E-01_JPRB,6.8832E-01_JPRB,5.6535E-01_JPRB,&
&4.2922E-01_JPRB,2.7541E-01_JPRB,1.4957E-01_JPRB,1.0036E-01_JPRB,2.0646E+00_JPRB/)
KAO( :, 5,12, 9) = (/&
&1.0799E+00_JPRB,1.0059E+00_JPRB,9.2157E-01_JPRB,8.2344E-01_JPRB,7.1363E-01_JPRB,5.9111E-01_JPRB,&
&4.5461E-01_JPRB,2.9875E-01_JPRB,1.6950E-01_JPRB,1.2252E-01_JPRB,2.1387E+00_JPRB/)
KAO( :, 1,13, 9) = (/&
&1.0003E+00_JPRB,8.9827E-01_JPRB,7.9453E-01_JPRB,6.8742E-01_JPRB,5.7557E-01_JPRB,4.5851E-01_JPRB,&
&3.3514E-01_JPRB,2.0061E-01_JPRB,9.5403E-02_JPRB,5.0265E-02_JPRB,1.6361E+00_JPRB/)
KAO( :, 2,13, 9) = (/&
&9.9751E-01_JPRB,9.0481E-01_JPRB,8.0727E-01_JPRB,7.0499E-01_JPRB,5.9591E-01_JPRB,4.8058E-01_JPRB,&
&3.5629E-01_JPRB,2.1887E-01_JPRB,1.0898E-01_JPRB,6.1395E-02_JPRB,1.6789E+00_JPRB/)
KAO( :, 3,13, 9) = (/&
&9.9614E-01_JPRB,9.1298E-01_JPRB,8.2308E-01_JPRB,7.2470E-01_JPRB,6.1846E-01_JPRB,5.0385E-01_JPRB,&
&3.7856E-01_JPRB,2.3882E-01_JPRB,1.2434E-01_JPRB,7.4760E-02_JPRB,1.7343E+00_JPRB/)
KAO( :, 4,13, 9) = (/&
&9.9388E-01_JPRB,9.2211E-01_JPRB,8.4003E-01_JPRB,7.4638E-01_JPRB,6.4247E-01_JPRB,5.2829E-01_JPRB,&
&4.0218E-01_JPRB,2.6010E-01_JPRB,1.4124E-01_JPRB,9.0738E-02_JPRB,1.8018E+00_JPRB/)
KAO( :, 5,13, 9) = (/&
&9.9133E-01_JPRB,9.3236E-01_JPRB,8.5728E-01_JPRB,7.6831E-01_JPRB,6.6718E-01_JPRB,5.5353E-01_JPRB,&
&4.2726E-01_JPRB,2.8267E-01_JPRB,1.5974E-01_JPRB,1.0946E-01_JPRB,1.8787E+00_JPRB/)
KAO( :, 1, 1,10) = (/&
&1.4571E+00_JPRB,1.2985E+00_JPRB,1.1908E+00_JPRB,1.0846E+00_JPRB,1.0480E+00_JPRB,9.7569E-01_JPRB,&
&9.5294E-01_JPRB,1.0946E+00_JPRB,1.1970E+00_JPRB,1.2341E+00_JPRB,1.2515E+00_JPRB/)
KAO( :, 2, 1,10) = (/&
&1.4234E+00_JPRB,1.2781E+00_JPRB,1.1865E+00_JPRB,1.1317E+00_JPRB,1.1150E+00_JPRB,1.0495E+00_JPRB,&
&1.1148E+00_JPRB,1.2924E+00_JPRB,1.4136E+00_JPRB,1.4576E+00_JPRB,1.4767E+00_JPRB/)
KAO( :, 3, 1,10) = (/&
&1.3920E+00_JPRB,1.2691E+00_JPRB,1.1852E+00_JPRB,1.1966E+00_JPRB,1.1609E+00_JPRB,1.1524E+00_JPRB,&
&1.2953E+00_JPRB,1.5017E+00_JPRB,1.6423E+00_JPRB,1.6923E+00_JPRB,1.7109E+00_JPRB/)
KAO( :, 4, 1,10) = (/&
&1.3678E+00_JPRB,1.2658E+00_JPRB,1.2088E+00_JPRB,1.2463E+00_JPRB,1.2126E+00_JPRB,1.2713E+00_JPRB,&
&1.4845E+00_JPRB,1.7225E+00_JPRB,1.8842E+00_JPRB,1.9406E+00_JPRB,1.9546E+00_JPRB/)
KAO( :, 5, 1,10) = (/&
&1.3506E+00_JPRB,1.2582E+00_JPRB,1.2509E+00_JPRB,1.2864E+00_JPRB,1.2835E+00_JPRB,1.4126E+00_JPRB,&
&1.6783E+00_JPRB,1.9484E+00_JPRB,2.1328E+00_JPRB,2.1974E+00_JPRB,2.2094E+00_JPRB/)
KAO( :, 1, 2,10) = (/&
&1.5647E+00_JPRB,1.3899E+00_JPRB,1.2609E+00_JPRB,1.1489E+00_JPRB,1.0577E+00_JPRB,9.7853E-01_JPRB,&
&8.8718E-01_JPRB,9.8958E-01_JPRB,1.0824E+00_JPRB,1.1177E+00_JPRB,1.1363E+00_JPRB/)
KAO( :, 2, 2,10) = (/&
&1.5359E+00_JPRB,1.3755E+00_JPRB,1.2594E+00_JPRB,1.1862E+00_JPRB,1.1175E+00_JPRB,1.0395E+00_JPRB,&
&1.0286E+00_JPRB,1.1844E+00_JPRB,1.2956E+00_JPRB,1.3363E+00_JPRB,1.3552E+00_JPRB/)
KAO( :, 3, 2,10) = (/&
&1.5095E+00_JPRB,1.3719E+00_JPRB,1.2702E+00_JPRB,1.2294E+00_JPRB,1.1716E+00_JPRB,1.1207E+00_JPRB,&
&1.2069E+00_JPRB,1.4002E+00_JPRB,1.5313E+00_JPRB,1.5789E+00_JPRB,1.5968E+00_JPRB/)
KAO( :, 4, 2,10) = (/&
&1.4881E+00_JPRB,1.3707E+00_JPRB,1.2904E+00_JPRB,1.2704E+00_JPRB,1.2297E+00_JPRB,1.2284E+00_JPRB,&
&1.3999E+00_JPRB,1.6237E+00_JPRB,1.7765E+00_JPRB,1.8314E+00_JPRB,1.8527E+00_JPRB/)
KAO( :, 5, 2,10) = (/&
&1.4712E+00_JPRB,1.3632E+00_JPRB,1.3184E+00_JPRB,1.3082E+00_JPRB,1.2921E+00_JPRB,1.3673E+00_JPRB,&
&1.6066E+00_JPRB,1.8637E+00_JPRB,2.0388E+00_JPRB,2.1005E+00_JPRB,2.1202E+00_JPRB/)
KAO( :, 1, 3,10) = (/&
&1.6996E+00_JPRB,1.5099E+00_JPRB,1.3576E+00_JPRB,1.2090E+00_JPRB,1.0921E+00_JPRB,9.6189E-01_JPRB,&
&8.2495E-01_JPRB,8.5120E-01_JPRB,9.3114E-01_JPRB,9.6079E-01_JPRB,9.7144E-01_JPRB/)
KAO( :, 2, 3,10) = (/&
&1.6714E+00_JPRB,1.4913E+00_JPRB,1.3572E+00_JPRB,1.2562E+00_JPRB,1.1313E+00_JPRB,1.0225E+00_JPRB,&
&9.3378E-01_JPRB,1.0377E+00_JPRB,1.1351E+00_JPRB,1.1715E+00_JPRB,1.1847E+00_JPRB/)
KAO( :, 3, 3,10) = (/&
&1.6464E+00_JPRB,1.4878E+00_JPRB,1.3648E+00_JPRB,1.2864E+00_JPRB,1.1805E+00_JPRB,1.0851E+00_JPRB,&
&1.0848E+00_JPRB,1.2467E+00_JPRB,1.3633E+00_JPRB,1.4058E+00_JPRB,1.4211E+00_JPRB/)
KAO( :, 4, 3,10) = (/&
&1.6254E+00_JPRB,1.4868E+00_JPRB,1.3919E+00_JPRB,1.3095E+00_JPRB,1.2349E+00_JPRB,1.1776E+00_JPRB,&
&1.2699E+00_JPRB,1.4722E+00_JPRB,1.6102E+00_JPRB,1.6602E+00_JPRB,1.6774E+00_JPRB/)
KAO( :, 5, 3,10) = (/&
&1.6074E+00_JPRB,1.4842E+00_JPRB,1.4163E+00_JPRB,1.3403E+00_JPRB,1.2931E+00_JPRB,1.3071E+00_JPRB,&
&1.4856E+00_JPRB,1.7228E+00_JPRB,1.8845E+00_JPRB,1.9421E+00_JPRB,1.9615E+00_JPRB/)
KAO( :, 1, 4,10) = (/&
&1.8323E+00_JPRB,1.6281E+00_JPRB,1.4618E+00_JPRB,1.2952E+00_JPRB,1.1419E+00_JPRB,9.7127E-01_JPRB,&
&7.8485E-01_JPRB,7.2735E-01_JPRB,7.9434E-01_JPRB,8.1908E-01_JPRB,8.2678E-01_JPRB/)
KAO( :, 2, 4,10) = (/&
&1.8090E+00_JPRB,1.6115E+00_JPRB,1.4679E+00_JPRB,1.3303E+00_JPRB,1.1865E+00_JPRB,1.0111E+00_JPRB,&
&8.6551E-01_JPRB,8.9427E-01_JPRB,9.7752E-01_JPRB,1.0078E+00_JPRB,1.0171E+00_JPRB/)
KAO( :, 3, 4,10) = (/&
&1.7889E+00_JPRB,1.6155E+00_JPRB,1.4723E+00_JPRB,1.3642E+00_JPRB,1.2203E+00_JPRB,1.0626E+00_JPRB,&
&9.8912E-01_JPRB,1.0844E+00_JPRB,1.1852E+00_JPRB,1.2230E+00_JPRB,1.2342E+00_JPRB/)
KAO( :, 4, 4,10) = (/&
&1.7702E+00_JPRB,1.6167E+00_JPRB,1.4947E+00_JPRB,1.3909E+00_JPRB,1.2565E+00_JPRB,1.1410E+00_JPRB,&
&1.1388E+00_JPRB,1.2955E+00_JPRB,1.4168E+00_JPRB,1.4624E+00_JPRB,1.4761E+00_JPRB/)
KAO( :, 5, 4,10) = (/&
&1.7501E+00_JPRB,1.6097E+00_JPRB,1.5232E+00_JPRB,1.4123E+00_JPRB,1.3009E+00_JPRB,1.2498E+00_JPRB,&
&1.3238E+00_JPRB,1.5313E+00_JPRB,1.6751E+00_JPRB,1.7296E+00_JPRB,1.7455E+00_JPRB/)
KAO( :, 1, 5,10) = (/&
&1.9828E+00_JPRB,1.7589E+00_JPRB,1.5692E+00_JPRB,1.3787E+00_JPRB,1.1995E+00_JPRB,9.9912E-01_JPRB,&
&7.7673E-01_JPRB,6.3208E-01_JPRB,6.6656E-01_JPRB,6.8788E-01_JPRB,6.9344E-01_JPRB/)
KAO( :, 2, 5,10) = (/&
&1.9634E+00_JPRB,1.7445E+00_JPRB,1.5796E+00_JPRB,1.4090E+00_JPRB,1.2375E+00_JPRB,1.0422E+00_JPRB,&
&8.3265E-01_JPRB,7.6892E-01_JPRB,8.3508E-01_JPRB,8.6158E-01_JPRB,8.6855E-01_JPRB/)
KAO( :, 3, 5,10) = (/&
&1.9451E+00_JPRB,1.7488E+00_JPRB,1.5830E+00_JPRB,1.4394E+00_JPRB,1.2778E+00_JPRB,1.0801E+00_JPRB,&
&9.2394E-01_JPRB,9.3676E-01_JPRB,1.0236E+00_JPRB,1.0564E+00_JPRB,1.0650E+00_JPRB/)
KAO( :, 4, 5,10) = (/&
&1.9265E+00_JPRB,1.7517E+00_JPRB,1.6023E+00_JPRB,1.4639E+00_JPRB,1.3153E+00_JPRB,1.1360E+00_JPRB,&
&1.0450E+00_JPRB,1.1261E+00_JPRB,1.2312E+00_JPRB,1.2708E+00_JPRB,1.2815E+00_JPRB/)
KAO( :, 5, 5,10) = (/&
&1.9040E+00_JPRB,1.7416E+00_JPRB,1.6301E+00_JPRB,1.4960E+00_JPRB,1.3496E+00_JPRB,1.2128E+00_JPRB,&
&1.1890E+00_JPRB,1.3318E+00_JPRB,1.4563E+00_JPRB,1.5043E+00_JPRB,1.5161E+00_JPRB/)
KAO( :, 1, 6,10) = (/&
&2.1467E+00_JPRB,1.9004E+00_JPRB,1.6825E+00_JPRB,1.4649E+00_JPRB,1.2465E+00_JPRB,1.0269E+00_JPRB,&
&7.8605E-01_JPRB,5.5785E-01_JPRB,5.4603E-01_JPRB,5.6364E-01_JPRB,5.6772E-01_JPRB/)
KAO( :, 2, 6,10) = (/&
&2.1281E+00_JPRB,1.8881E+00_JPRB,1.6957E+00_JPRB,1.4846E+00_JPRB,1.2828E+00_JPRB,1.0659E+00_JPRB,&
&8.3980E-01_JPRB,6.6949E-01_JPRB,6.9629E-01_JPRB,7.1873E-01_JPRB,7.2407E-01_JPRB/)
KAO( :, 3, 6,10) = (/&
&2.1101E+00_JPRB,1.8868E+00_JPRB,1.6967E+00_JPRB,1.5129E+00_JPRB,1.3220E+00_JPRB,1.1137E+00_JPRB,&
&9.0037E-01_JPRB,8.0396E-01_JPRB,8.6638E-01_JPRB,8.9449E-01_JPRB,9.0065E-01_JPRB/)
KAO( :, 4, 6,10) = (/&
&2.0853E+00_JPRB,1.8860E+00_JPRB,1.7059E+00_JPRB,1.5431E+00_JPRB,1.3571E+00_JPRB,1.1686E+00_JPRB,&
&9.8228E-01_JPRB,9.6588E-01_JPRB,1.0545E+00_JPRB,1.0886E+00_JPRB,1.0960E+00_JPRB/)
KAO( :, 5, 6,10) = (/&
&2.0580E+00_JPRB,1.8736E+00_JPRB,1.7305E+00_JPRB,1.5756E+00_JPRB,1.3997E+00_JPRB,1.2303E+00_JPRB,&
&1.0965E+00_JPRB,1.1472E+00_JPRB,1.2529E+00_JPRB,1.2937E+00_JPRB,1.3014E+00_JPRB/)
KAO( :, 1, 7,10) = (/&
&2.2844E+00_JPRB,2.0203E+00_JPRB,1.7798E+00_JPRB,1.5404E+00_JPRB,1.2929E+00_JPRB,1.0469E+00_JPRB,&
&7.9236E-01_JPRB,5.2961E-01_JPRB,4.3906E-01_JPRB,4.5269E-01_JPRB,4.5518E-01_JPRB/)
KAO( :, 2, 7,10) = (/&
&2.2660E+00_JPRB,2.0078E+00_JPRB,1.7931E+00_JPRB,1.5555E+00_JPRB,1.3285E+00_JPRB,1.0902E+00_JPRB,&
&8.4669E-01_JPRB,5.9963E-01_JPRB,5.6851E-01_JPRB,5.8633E-01_JPRB,5.8943E-01_JPRB/)
KAO( :, 3, 7,10) = (/&
&2.2458E+00_JPRB,2.0016E+00_JPRB,1.7952E+00_JPRB,1.5839E+00_JPRB,1.3724E+00_JPRB,1.1382E+00_JPRB,&
&9.0788E-01_JPRB,7.0219E-01_JPRB,7.1570E-01_JPRB,7.3889E-01_JPRB,7.4245E-01_JPRB/)
KAO( :, 4, 7,10) = (/&
&2.2171E+00_JPRB,2.0004E+00_JPRB,1.8020E+00_JPRB,1.6192E+00_JPRB,1.4137E+00_JPRB,1.1896E+00_JPRB,&
&9.7833E-01_JPRB,8.3274E-01_JPRB,8.7925E-01_JPRB,9.0812E-01_JPRB,9.1193E-01_JPRB/)
KAO( :, 5, 7,10) = (/&
&2.1959E+00_JPRB,1.9929E+00_JPRB,1.8261E+00_JPRB,1.6565E+00_JPRB,1.4548E+00_JPRB,1.2529E+00_JPRB,&
&1.0566E+00_JPRB,9.7505E-01_JPRB,1.0516E+00_JPRB,1.0862E+00_JPRB,1.0907E+00_JPRB/)
KAO( :, 1, 8,10) = (/&
&2.3885E+00_JPRB,2.1081E+00_JPRB,1.8478E+00_JPRB,1.5947E+00_JPRB,1.3299E+00_JPRB,1.0742E+00_JPRB,&
&7.9832E-01_JPRB,5.1485E-01_JPRB,3.4910E-01_JPRB,3.5166E-01_JPRB,4.0882E-01_JPRB/)
KAO( :, 2, 8,10) = (/&
&2.3816E+00_JPRB,2.1064E+00_JPRB,1.8710E+00_JPRB,1.6145E+00_JPRB,1.3755E+00_JPRB,1.1190E+00_JPRB,&
&8.5217E-01_JPRB,5.7569E-01_JPRB,4.5136E-01_JPRB,4.6418E-01_JPRB,4.8409E-01_JPRB/)
KAO( :, 3, 8,10) = (/&
&2.3652E+00_JPRB,2.1007E+00_JPRB,1.8806E+00_JPRB,1.6533E+00_JPRB,1.4207E+00_JPRB,1.1711E+00_JPRB,&
&9.0846E-01_JPRB,6.4219E-01_JPRB,5.7508E-01_JPRB,5.9368E-01_JPRB,5.9892E-01_JPRB/)
KAO( :, 4, 8,10) = (/&
&2.3476E+00_JPRB,2.1091E+00_JPRB,1.8906E+00_JPRB,1.6908E+00_JPRB,1.4662E+00_JPRB,1.2230E+00_JPRB,&
&9.7637E-01_JPRB,7.3139E-01_JPRB,7.1362E-01_JPRB,7.3716E-01_JPRB,7.4183E-01_JPRB/)
KAO( :, 5, 8,10) = (/&
&2.3384E+00_JPRB,2.1117E+00_JPRB,1.9201E+00_JPRB,1.7277E+00_JPRB,1.5122E+00_JPRB,1.2845E+00_JPRB,&
&1.0504E+00_JPRB,8.4237E-01_JPRB,8.6471E-01_JPRB,8.9254E-01_JPRB,8.9924E-01_JPRB/)
KAO( :, 1, 9,10) = (/&
&2.5386E+00_JPRB,2.2349E+00_JPRB,1.9481E+00_JPRB,1.6673E+00_JPRB,1.3731E+00_JPRB,1.0924E+00_JPRB,&
&8.0108E-01_JPRB,5.0383E-01_JPRB,2.8431E-01_JPRB,2.6546E-01_JPRB,1.0078E+00_JPRB/)
KAO( :, 2, 9,10) = (/&
&2.5451E+00_JPRB,2.2468E+00_JPRB,1.9792E+00_JPRB,1.6927E+00_JPRB,1.4190E+00_JPRB,1.1389E+00_JPRB,&
&8.5564E-01_JPRB,5.6069E-01_JPRB,3.5715E-01_JPRB,3.5572E-01_JPRB,1.1000E+00_JPRB/)
KAO( :, 3, 9,10) = (/&
&2.5371E+00_JPRB,2.2464E+00_JPRB,1.9929E+00_JPRB,1.7275E+00_JPRB,1.4622E+00_JPRB,1.1905E+00_JPRB,&
&9.1694E-01_JPRB,6.2032E-01_JPRB,4.5328E-01_JPRB,4.6281E-01_JPRB,1.1964E+00_JPRB/)
KAO( :, 4, 9,10) = (/&
&2.5272E+00_JPRB,2.2578E+00_JPRB,2.0033E+00_JPRB,1.7607E+00_JPRB,1.5050E+00_JPRB,1.2522E+00_JPRB,&
&9.8282E-01_JPRB,6.8556E-01_JPRB,5.6762E-01_JPRB,5.8509E-01_JPRB,1.3014E+00_JPRB/)
KAO( :, 5, 9,10) = (/&
&2.5219E+00_JPRB,2.2665E+00_JPRB,2.0326E+00_JPRB,1.7988E+00_JPRB,1.5562E+00_JPRB,1.3171E+00_JPRB,&
&1.0492E+00_JPRB,7.6013E-01_JPRB,7.0072E-01_JPRB,7.2284E-01_JPRB,1.4121E+00_JPRB/)
KAO( :, 1,10,10) = (/&
&2.7032E+00_JPRB,2.3752E+00_JPRB,2.0666E+00_JPRB,1.7582E+00_JPRB,1.4376E+00_JPRB,1.1282E+00_JPRB,&
&8.0844E-01_JPRB,4.9374E-01_JPRB,2.5722E-01_JPRB,2.0186E-01_JPRB,3.6688E+00_JPRB/)
KAO( :, 2,10,10) = (/&
&2.7107E+00_JPRB,2.3914E+00_JPRB,2.0994E+00_JPRB,1.7884E+00_JPRB,1.4847E+00_JPRB,1.1756E+00_JPRB,&
&8.5930E-01_JPRB,5.5140E-01_JPRB,3.0504E-01_JPRB,2.7555E-01_JPRB,3.7597E+00_JPRB/)
KAO( :, 3,10,10) = (/&
&2.7016E+00_JPRB,2.3907E+00_JPRB,2.1143E+00_JPRB,1.8225E+00_JPRB,1.5274E+00_JPRB,1.2237E+00_JPRB,&
&9.2233E-01_JPRB,6.0585E-01_JPRB,3.7278E-01_JPRB,3.6425E-01_JPRB,3.8938E+00_JPRB/)
KAO( :, 4,10,10) = (/&
&2.6956E+00_JPRB,2.4067E+00_JPRB,2.1300E+00_JPRB,1.8578E+00_JPRB,1.5689E+00_JPRB,1.2815E+00_JPRB,&
&9.8969E-01_JPRB,6.6341E-01_JPRB,4.6317E-01_JPRB,4.6656E-01_JPRB,4.0246E+00_JPRB/)
KAO( :, 5,10,10) = (/&
&2.6869E+00_JPRB,2.4172E+00_JPRB,2.1621E+00_JPRB,1.8987E+00_JPRB,1.6181E+00_JPRB,1.3422E+00_JPRB,&
&1.0558E+00_JPRB,7.2592E-01_JPRB,5.7500E-01_JPRB,5.8744E-01_JPRB,4.1547E+00_JPRB/)
KAO( :, 1,11,10) = (/&
&2.8365E+00_JPRB,2.4939E+00_JPRB,2.1806E+00_JPRB,1.8562E+00_JPRB,1.5246E+00_JPRB,1.1987E+00_JPRB,&
&8.5286E-01_JPRB,5.0756E-01_JPRB,2.5720E-01_JPRB,1.7786E-01_JPRB,5.8233E+00_JPRB/)
KAO( :, 2,11,10) = (/&
&2.8311E+00_JPRB,2.5017E+00_JPRB,2.2072E+00_JPRB,1.8857E+00_JPRB,1.5735E+00_JPRB,1.2464E+00_JPRB,&
&9.0789E-01_JPRB,5.6161E-01_JPRB,3.0021E-01_JPRB,2.4395E-01_JPRB,5.8712E+00_JPRB/)
KAO( :, 3,11,10) = (/&
&2.8249E+00_JPRB,2.5109E+00_JPRB,2.2225E+00_JPRB,1.9282E+00_JPRB,1.6185E+00_JPRB,1.2983E+00_JPRB,&
&9.6627E-01_JPRB,6.1528E-01_JPRB,3.5612E-01_JPRB,3.2409E-01_JPRB,5.9730E+00_JPRB/)
KAO( :, 4,11,10) = (/&
&2.8199E+00_JPRB,2.5320E+00_JPRB,2.2523E+00_JPRB,1.9711E+00_JPRB,1.6696E+00_JPRB,1.3539E+00_JPRB,&
&1.0246E+00_JPRB,6.7092E-01_JPRB,4.3024E-01_JPRB,4.1910E-01_JPRB,6.1100E+00_JPRB/)
KAO( :, 5,11,10) = (/&
&2.8024E+00_JPRB,2.5388E+00_JPRB,2.2830E+00_JPRB,2.0130E+00_JPRB,1.7222E+00_JPRB,1.4150E+00_JPRB,&
&1.0853E+00_JPRB,7.3326E-01_JPRB,5.2958E-01_JPRB,5.3082E-01_JPRB,6.2451E+00_JPRB/)
KAO( :, 1,12,10) = (/&
&2.9007E+00_JPRB,2.5522E+00_JPRB,2.2455E+00_JPRB,1.9136E+00_JPRB,1.5844E+00_JPRB,1.2502E+00_JPRB,&
&8.9520E-01_JPRB,5.2570E-01_JPRB,2.5575E-01_JPRB,1.5969E-01_JPRB,6.7808E+00_JPRB/)
KAO( :, 2,12,10) = (/&
&2.8957E+00_JPRB,2.5649E+00_JPRB,2.2681E+00_JPRB,1.9492E+00_JPRB,1.6332E+00_JPRB,1.2959E+00_JPRB,&
&9.5066E-01_JPRB,5.7358E-01_JPRB,2.9740E-01_JPRB,2.1707E-01_JPRB,6.8136E+00_JPRB/)
KAO( :, 3,12,10) = (/&
&2.8959E+00_JPRB,2.5923E+00_JPRB,2.2942E+00_JPRB,1.9975E+00_JPRB,1.6818E+00_JPRB,1.3548E+00_JPRB,&
&1.0083E+00_JPRB,6.2153E-01_JPRB,3.4695E-01_JPRB,2.8857E-01_JPRB,6.9134E+00_JPRB/)
KAO( :, 4,12,10) = (/&
&2.8817E+00_JPRB,2.6059E+00_JPRB,2.3289E+00_JPRB,2.0414E+00_JPRB,1.7379E+00_JPRB,1.4164E+00_JPRB,&
&1.0650E+00_JPRB,6.7585E-01_JPRB,4.1101E-01_JPRB,3.7695E-01_JPRB,7.0381E+00_JPRB/)
KAO( :, 5,12,10) = (/&
&2.8680E+00_JPRB,2.6070E+00_JPRB,2.3572E+00_JPRB,2.0817E+00_JPRB,1.7934E+00_JPRB,1.4807E+00_JPRB,&
&1.1194E+00_JPRB,7.3817E-01_JPRB,4.8817E-01_JPRB,4.7434E-01_JPRB,7.1520E+00_JPRB/)
KAO( :, 1,13,10) = (/&
&2.8740E+00_JPRB,2.5320E+00_JPRB,2.2375E+00_JPRB,1.9099E+00_JPRB,1.5916E+00_JPRB,1.2554E+00_JPRB,&
&9.0824E-01_JPRB,5.3705E-01_JPRB,2.5121E-01_JPRB,1.4664E-01_JPRB,6.0411E+00_JPRB/)
KAO( :, 2,13,10) = (/&
&2.8792E+00_JPRB,2.5659E+00_JPRB,2.2680E+00_JPRB,1.9609E+00_JPRB,1.6438E+00_JPRB,1.3095E+00_JPRB,&
&9.6448E-01_JPRB,5.8102E-01_JPRB,2.9305E-01_JPRB,1.9412E-01_JPRB,6.1051E+00_JPRB/)
KAO( :, 3,13,10) = (/&
&2.8707E+00_JPRB,2.5893E+00_JPRB,2.2982E+00_JPRB,2.0064E+00_JPRB,1.6967E+00_JPRB,1.3719E+00_JPRB,&
&1.0233E+00_JPRB,6.2659E-01_JPRB,3.3990E-01_JPRB,2.5773E-01_JPRB,6.2169E+00_JPRB/)
KAO( :, 4,13,10) = (/&
&2.8643E+00_JPRB,2.5995E+00_JPRB,2.3326E+00_JPRB,2.0484E+00_JPRB,1.7508E+00_JPRB,1.4355E+00_JPRB,&
&1.0824E+00_JPRB,6.7916E-01_JPRB,3.9630E-01_JPRB,3.3349E-01_JPRB,6.3137E+00_JPRB/)
KAO( :, 5,13,10) = (/&
&2.8671E+00_JPRB,2.6159E+00_JPRB,2.3730E+00_JPRB,2.0970E+00_JPRB,1.8103E+00_JPRB,1.4979E+00_JPRB,&
&1.1399E+00_JPRB,7.4021E-01_JPRB,4.5873E-01_JPRB,4.1936E-01_JPRB,6.4289E+00_JPRB/)
KAO( :, 1, 1,11) = (/&
&1.6613E+00_JPRB,1.4866E+00_JPRB,1.3853E+00_JPRB,1.3300E+00_JPRB,1.2682E+00_JPRB,1.2323E+00_JPRB,&
&1.3863E+00_JPRB,1.6088E+00_JPRB,1.7596E+00_JPRB,1.8112E+00_JPRB,1.8168E+00_JPRB/)
KAO( :, 2, 1,11) = (/&
&1.6169E+00_JPRB,1.4555E+00_JPRB,1.4059E+00_JPRB,1.3808E+00_JPRB,1.3576E+00_JPRB,1.4059E+00_JPRB,&
&1.6502E+00_JPRB,1.9162E+00_JPRB,2.0970E+00_JPRB,2.1595E+00_JPRB,2.1711E+00_JPRB/)
KAO( :, 3, 1,11) = (/&
&1.5778E+00_JPRB,1.4552E+00_JPRB,1.4351E+00_JPRB,1.4445E+00_JPRB,1.4667E+00_JPRB,1.6093E+00_JPRB,&
&1.9164E+00_JPRB,2.2262E+00_JPRB,2.4366E+00_JPRB,2.5118E+00_JPRB,2.5357E+00_JPRB/)
KAO( :, 4, 1,11) = (/&
&1.5458E+00_JPRB,1.4600E+00_JPRB,1.4693E+00_JPRB,1.5080E+00_JPRB,1.5810E+00_JPRB,1.8320E+00_JPRB,&
&2.1847E+00_JPRB,2.5375E+00_JPRB,2.7777E+00_JPRB,2.8639E+00_JPRB,2.8977E+00_JPRB/)
KAO( :, 5, 1,11) = (/&
&1.5169E+00_JPRB,1.4756E+00_JPRB,1.5189E+00_JPRB,1.5745E+00_JPRB,1.7149E+00_JPRB,2.0625E+00_JPRB,&
&2.4598E+00_JPRB,2.8572E+00_JPRB,3.1271E+00_JPRB,3.2233E+00_JPRB,3.2607E+00_JPRB/)
KAO( :, 1, 2,11) = (/&
&1.7931E+00_JPRB,1.6027E+00_JPRB,1.4692E+00_JPRB,1.3591E+00_JPRB,1.3119E+00_JPRB,1.2053E+00_JPRB,&
&1.2920E+00_JPRB,1.4995E+00_JPRB,1.6403E+00_JPRB,1.6893E+00_JPRB,1.7029E+00_JPRB/)
KAO( :, 2, 2,11) = (/&
&1.7517E+00_JPRB,1.5695E+00_JPRB,1.4741E+00_JPRB,1.4214E+00_JPRB,1.3827E+00_JPRB,1.3473E+00_JPRB,&
&1.5430E+00_JPRB,1.7916E+00_JPRB,1.9609E+00_JPRB,2.0211E+00_JPRB,2.0410E+00_JPRB/)
KAO( :, 3, 2,11) = (/&
&1.7144E+00_JPRB,1.5578E+00_JPRB,1.4838E+00_JPRB,1.5024E+00_JPRB,1.4587E+00_JPRB,1.5235E+00_JPRB,&
&1.7953E+00_JPRB,2.0852E+00_JPRB,2.2826E+00_JPRB,2.3530E+00_JPRB,2.3802E+00_JPRB/)
KAO( :, 4, 2,11) = (/&
&1.6782E+00_JPRB,1.5545E+00_JPRB,1.5253E+00_JPRB,1.5641E+00_JPRB,1.5463E+00_JPRB,1.7285E+00_JPRB,&
&2.0611E+00_JPRB,2.3939E+00_JPRB,2.6193E+00_JPRB,2.6996E+00_JPRB,2.7281E+00_JPRB/)
KAO( :, 5, 2,11) = (/&
&1.6444E+00_JPRB,1.5616E+00_JPRB,1.5898E+00_JPRB,1.6106E+00_JPRB,1.6616E+00_JPRB,1.9596E+00_JPRB,&
&2.3378E+00_JPRB,2.7154E+00_JPRB,2.9704E+00_JPRB,3.0605E+00_JPRB,3.0919E+00_JPRB/)
KAO( :, 1, 3,11) = (/&
&1.9627E+00_JPRB,1.7504E+00_JPRB,1.5854E+00_JPRB,1.4217E+00_JPRB,1.3102E+00_JPRB,1.1839E+00_JPRB,&
&1.1622E+00_JPRB,1.3310E+00_JPRB,1.4543E+00_JPRB,1.4985E+00_JPRB,1.5140E+00_JPRB/)
KAO( :, 2, 3,11) = (/&
&1.9279E+00_JPRB,1.7219E+00_JPRB,1.5816E+00_JPRB,1.4501E+00_JPRB,1.3900E+00_JPRB,1.2949E+00_JPRB,&
&1.3876E+00_JPRB,1.6085E+00_JPRB,1.7572E+00_JPRB,1.8110E+00_JPRB,1.8300E+00_JPRB/)
KAO( :, 3, 3,11) = (/&
&1.8924E+00_JPRB,1.7068E+00_JPRB,1.5754E+00_JPRB,1.5312E+00_JPRB,1.4545E+00_JPRB,1.4364E+00_JPRB,&
&1.6346E+00_JPRB,1.8944E+00_JPRB,2.0697E+00_JPRB,2.1336E+00_JPRB,2.1557E+00_JPRB/)
KAO( :, 4, 3,11) = (/&
&1.8571E+00_JPRB,1.6996E+00_JPRB,1.5918E+00_JPRB,1.6013E+00_JPRB,1.5297E+00_JPRB,1.6118E+00_JPRB,&
&1.8962E+00_JPRB,2.1972E+00_JPRB,2.4008E+00_JPRB,2.4733E+00_JPRB,2.4988E+00_JPRB/)
KAO( :, 5, 3,11) = (/&
&1.8235E+00_JPRB,1.6901E+00_JPRB,1.6505E+00_JPRB,1.6453E+00_JPRB,1.6300E+00_JPRB,1.8256E+00_JPRB,&
&2.1737E+00_JPRB,2.5187E+00_JPRB,2.7529E+00_JPRB,2.8347E+00_JPRB,2.8622E+00_JPRB/)
KAO( :, 1, 4,11) = (/&
&2.1765E+00_JPRB,1.9348E+00_JPRB,1.7298E+00_JPRB,1.5261E+00_JPRB,1.3305E+00_JPRB,1.1605E+00_JPRB,&
&1.0551E+00_JPRB,1.1346E+00_JPRB,1.2370E+00_JPRB,1.2757E+00_JPRB,1.2869E+00_JPRB/)
KAO( :, 2, 4,11) = (/&
&2.1414E+00_JPRB,1.9083E+00_JPRB,1.7248E+00_JPRB,1.5356E+00_JPRB,1.3817E+00_JPRB,1.2586E+00_JPRB,&
&1.2309E+00_JPRB,1.3912E+00_JPRB,1.5177E+00_JPRB,1.5661E+00_JPRB,1.5799E+00_JPRB/)
KAO( :, 3, 4,11) = (/&
&2.1021E+00_JPRB,1.8834E+00_JPRB,1.7158E+00_JPRB,1.5815E+00_JPRB,1.4532E+00_JPRB,1.3786E+00_JPRB,&
&1.4439E+00_JPRB,1.6656E+00_JPRB,1.8177E+00_JPRB,1.8749E+00_JPRB,1.8912E+00_JPRB/)
KAO( :, 4, 4,11) = (/&
&2.0644E+00_JPRB,1.8749E+00_JPRB,1.7166E+00_JPRB,1.6274E+00_JPRB,1.5294E+00_JPRB,1.5218E+00_JPRB,&
&1.7000E+00_JPRB,1.9644E+00_JPRB,2.1444E+00_JPRB,2.2100E+00_JPRB,2.2304E+00_JPRB/)
KAO( :, 5, 4,11) = (/&
&2.0315E+00_JPRB,1.8634E+00_JPRB,1.7507E+00_JPRB,1.6723E+00_JPRB,1.6226E+00_JPRB,1.7027E+00_JPRB,&
&1.9800E+00_JPRB,2.2880E+00_JPRB,2.4977E+00_JPRB,2.5739E+00_JPRB,2.5981E+00_JPRB/)
KAO( :, 1, 5,11) = (/&
&2.3978E+00_JPRB,2.1273E+00_JPRB,1.8817E+00_JPRB,1.6476E+00_JPRB,1.4011E+00_JPRB,1.1672E+00_JPRB,&
&9.7083E-01_JPRB,9.5214E-01_JPRB,1.0369E+00_JPRB,1.0689E+00_JPRB,1.0768E+00_JPRB/)
KAO( :, 2, 5,11) = (/&
&2.3540E+00_JPRB,2.0936E+00_JPRB,1.8768E+00_JPRB,1.6491E+00_JPRB,1.4389E+00_JPRB,1.2340E+00_JPRB,&
&1.1149E+00_JPRB,1.1831E+00_JPRB,1.2889E+00_JPRB,1.3291E+00_JPRB,1.3391E+00_JPRB/)
KAO( :, 3, 5,11) = (/&
&2.3123E+00_JPRB,2.0603E+00_JPRB,1.8683E+00_JPRB,1.6861E+00_JPRB,1.4856E+00_JPRB,1.3243E+00_JPRB,&
&1.2879E+00_JPRB,1.4387E+00_JPRB,1.5683E+00_JPRB,1.6173E+00_JPRB,1.6292E+00_JPRB/)
KAO( :, 4, 5,11) = (/&
&2.2731E+00_JPRB,2.0535E+00_JPRB,1.8606E+00_JPRB,1.7201E+00_JPRB,1.5405E+00_JPRB,1.4489E+00_JPRB,&
&1.5047E+00_JPRB,1.7253E+00_JPRB,1.8810E+00_JPRB,1.9395E+00_JPRB,1.9546E+00_JPRB/)
KAO( :, 5, 5,11) = (/&
&2.2409E+00_JPRB,2.0441E+00_JPRB,1.8877E+00_JPRB,1.7429E+00_JPRB,1.6151E+00_JPRB,1.6124E+00_JPRB,&
&1.7700E+00_JPRB,2.0422E+00_JPRB,2.2271E+00_JPRB,2.2953E+00_JPRB,2.3139E+00_JPRB/)
KAO( :, 1, 6,11) = (/&
&2.5958E+00_JPRB,2.2974E+00_JPRB,2.0142E+00_JPRB,1.7617E+00_JPRB,1.4801E+00_JPRB,1.2138E+00_JPRB,&
&9.4381E-01_JPRB,8.0769E-01_JPRB,8.5699E-01_JPRB,8.8288E-01_JPRB,8.8884E-01_JPRB/)
KAO( :, 2, 6,11) = (/&
&2.5524E+00_JPRB,2.2633E+00_JPRB,2.0140E+00_JPRB,1.7595E+00_JPRB,1.5235E+00_JPRB,1.2699E+00_JPRB,&
&1.0358E+00_JPRB,9.9995E-01_JPRB,1.0855E+00_JPRB,1.1188E+00_JPRB,1.1263E+00_JPRB/)
KAO( :, 3, 6,11) = (/&
&2.5133E+00_JPRB,2.2324E+00_JPRB,2.0130E+00_JPRB,1.7928E+00_JPRB,1.5724E+00_JPRB,1.3298E+00_JPRB,&
&1.1740E+00_JPRB,1.2292E+00_JPRB,1.3373E+00_JPRB,1.3782E+00_JPRB,1.3885E+00_JPRB/)
KAO( :, 4, 6,11) = (/&
&2.4807E+00_JPRB,2.2302E+00_JPRB,2.0078E+00_JPRB,1.8271E+00_JPRB,1.6226E+00_JPRB,1.4050E+00_JPRB,&
&1.3553E+00_JPRB,1.4899E+00_JPRB,1.6221E+00_JPRB,1.6724E+00_JPRB,1.6846E+00_JPRB/)
KAO( :, 5, 6,11) = (/&
&2.4531E+00_JPRB,2.2259E+00_JPRB,2.0295E+00_JPRB,1.8622E+00_JPRB,1.6727E+00_JPRB,1.5327E+00_JPRB,&
&1.5693E+00_JPRB,1.7819E+00_JPRB,1.9432E+00_JPRB,2.0038E+00_JPRB,2.0198E+00_JPRB/)
KAO( :, 1, 7,11) = (/&
&2.7829E+00_JPRB,2.4576E+00_JPRB,2.1410E+00_JPRB,1.8711E+00_JPRB,1.5626E+00_JPRB,1.2726E+00_JPRB,&
&9.6771E-01_JPRB,6.9895E-01_JPRB,6.9406E-01_JPRB,7.1533E-01_JPRB,7.2033E-01_JPRB/)
KAO( :, 2, 7,11) = (/&
&2.7493E+00_JPRB,2.4354E+00_JPRB,2.1596E+00_JPRB,1.8755E+00_JPRB,1.6074E+00_JPRB,1.3276E+00_JPRB,&
&1.0391E+00_JPRB,8.5593E-01_JPRB,8.9783E-01_JPRB,9.2606E-01_JPRB,9.3225E-01_JPRB/)
KAO( :, 3, 7,11) = (/&
&2.7215E+00_JPRB,2.4153E+00_JPRB,2.1690E+00_JPRB,1.9070E+00_JPRB,1.6545E+00_JPRB,1.3898E+00_JPRB,&
&1.1226E+00_JPRB,1.0453E+00_JPRB,1.1294E+00_JPRB,1.1648E+00_JPRB,1.1728E+00_JPRB/)
KAO( :, 4, 7,11) = (/&
&2.6975E+00_JPRB,2.4170E+00_JPRB,2.1702E+00_JPRB,1.9430E+00_JPRB,1.7107E+00_JPRB,1.4568E+00_JPRB,&
&1.2495E+00_JPRB,1.2760E+00_JPRB,1.3906E+00_JPRB,1.4345E+00_JPRB,1.4450E+00_JPRB/)
KAO( :, 5, 7,11) = (/&
&2.6700E+00_JPRB,2.4191E+00_JPRB,2.1904E+00_JPRB,1.9836E+00_JPRB,1.7642E+00_JPRB,1.5351E+00_JPRB,&
&1.4268E+00_JPRB,1.5390E+00_JPRB,1.6803E+00_JPRB,1.7334E+00_JPRB,1.7463E+00_JPRB/)
KAO( :, 1, 8,11) = (/&
&2.9847E+00_JPRB,2.6313E+00_JPRB,2.2865E+00_JPRB,1.9879E+00_JPRB,1.6488E+00_JPRB,1.3255E+00_JPRB,&
&9.9877E-01_JPRB,6.5722E-01_JPRB,5.5701E-01_JPRB,5.7433E-01_JPRB,5.7952E-01_JPRB/)
KAO( :, 2, 8,11) = (/&
&2.9589E+00_JPRB,2.6183E+00_JPRB,2.3133E+00_JPRB,2.0003E+00_JPRB,1.6901E+00_JPRB,1.3820E+00_JPRB,&
&1.0665E+00_JPRB,7.5791E-01_JPRB,7.3569E-01_JPRB,7.5906E-01_JPRB,7.6418E-01_JPRB/)
KAO( :, 3, 8,11) = (/&
&2.9382E+00_JPRB,2.6052E+00_JPRB,2.3281E+00_JPRB,2.0270E+00_JPRB,1.7422E+00_JPRB,1.4465E+00_JPRB,&
&1.1457E+00_JPRB,9.0969E-01_JPRB,9.4197E-01_JPRB,9.7232E-01_JPRB,9.7875E-01_JPRB/)
KAO( :, 4, 8,11) = (/&
&2.9170E+00_JPRB,2.6060E+00_JPRB,2.3361E+00_JPRB,2.0694E+00_JPRB,1.8026E+00_JPRB,1.5183E+00_JPRB,&
&1.2312E+00_JPRB,1.0984E+00_JPRB,1.1773E+00_JPRB,1.2154E+00_JPRB,1.2236E+00_JPRB/)
KAO( :, 5, 8,11) = (/&
&2.8898E+00_JPRB,2.6134E+00_JPRB,2.3563E+00_JPRB,2.1177E+00_JPRB,1.8614E+00_JPRB,1.5931E+00_JPRB,&
&1.3477E+00_JPRB,1.3211E+00_JPRB,1.4373E+00_JPRB,1.4847E+00_JPRB,1.4939E+00_JPRB/)
KAO( :, 1, 9,11) = (/&
&3.1562E+00_JPRB,2.7768E+00_JPRB,2.4133E+00_JPRB,2.0911E+00_JPRB,1.7326E+00_JPRB,1.3839E+00_JPRB,&
&1.0276E+00_JPRB,6.4719E-01_JPRB,4.4660E-01_JPRB,4.5187E-01_JPRB,1.3511E+00_JPRB/)
KAO( :, 2, 9,11) = (/&
&3.1384E+00_JPRB,2.7738E+00_JPRB,2.4447E+00_JPRB,2.1155E+00_JPRB,1.7788E+00_JPRB,1.4436E+00_JPRB,&
&1.0888E+00_JPRB,7.2585E-01_JPRB,5.9330E-01_JPRB,6.1102E-01_JPRB,1.4527E+00_JPRB/)
KAO( :, 3, 9,11) = (/&
&3.1307E+00_JPRB,2.7744E+00_JPRB,2.4761E+00_JPRB,2.1489E+00_JPRB,1.8392E+00_JPRB,1.5081E+00_JPRB,&
&1.1726E+00_JPRB,8.2343E-01_JPRB,7.7078E-01_JPRB,7.9585E-01_JPRB,1.5858E+00_JPRB/)
KAO( :, 4, 9,11) = (/&
&3.1198E+00_JPRB,2.7814E+00_JPRB,2.4948E+00_JPRB,2.2031E+00_JPRB,1.9038E+00_JPRB,1.5809E+00_JPRB,&
&1.2536E+00_JPRB,9.6368E-01_JPRB,9.7557E-01_JPRB,1.0082E+00_JPRB,1.7168E+00_JPRB/)
KAO( :, 5, 9,11) = (/&
&3.0996E+00_JPRB,2.7968E+00_JPRB,2.5179E+00_JPRB,2.2589E+00_JPRB,1.9623E+00_JPRB,1.6560E+00_JPRB,&
&1.3493E+00_JPRB,1.1417E+00_JPRB,1.2025E+00_JPRB,1.2431E+00_JPRB,1.8589E+00_JPRB/)
KAO( :, 1,10,11) = (/&
&3.3334E+00_JPRB,2.9275E+00_JPRB,2.5435E+00_JPRB,2.1899E+00_JPRB,1.8099E+00_JPRB,1.4340E+00_JPRB,&
&1.0600E+00_JPRB,6.4816E-01_JPRB,3.7397E-01_JPRB,3.5551E-01_JPRB,5.2534E+00_JPRB/)
KAO( :, 2,10,11) = (/&
&3.3403E+00_JPRB,2.9437E+00_JPRB,2.5854E+00_JPRB,2.2265E+00_JPRB,1.8583E+00_JPRB,1.5038E+00_JPRB,&
&1.1221E+00_JPRB,7.2216E-01_JPRB,4.8652E-01_JPRB,4.8944E-01_JPRB,5.3617E+00_JPRB/)
KAO( :, 3,10,11) = (/&
&3.3507E+00_JPRB,2.9656E+00_JPRB,2.6315E+00_JPRB,2.2679E+00_JPRB,1.9297E+00_JPRB,1.5737E+00_JPRB,&
&1.2011E+00_JPRB,8.0616E-01_JPRB,6.2998E-01_JPRB,6.4742E-01_JPRB,5.5025E+00_JPRB/)
KAO( :, 4,10,11) = (/&
&3.3473E+00_JPRB,2.9767E+00_JPRB,2.6569E+00_JPRB,2.3310E+00_JPRB,1.9983E+00_JPRB,1.6498E+00_JPRB,&
&1.2844E+00_JPRB,9.0267E-01_JPRB,8.0194E-01_JPRB,8.2874E-01_JPRB,5.7004E+00_JPRB/)
KAO( :, 5,10,11) = (/&
&3.3392E+00_JPRB,3.0005E+00_JPRB,2.6833E+00_JPRB,2.3869E+00_JPRB,2.0631E+00_JPRB,1.7311E+00_JPRB,&
&1.3746E+00_JPRB,1.0270E+00_JPRB,9.9701E-01_JPRB,1.0314E+00_JPRB,5.9087E+00_JPRB/)
KAO( :, 1,11,11) = (/&
&3.5791E+00_JPRB,3.1435E+00_JPRB,2.7380E+00_JPRB,2.3402E+00_JPRB,1.9223E+00_JPRB,1.5197E+00_JPRB,&
&1.1123E+00_JPRB,6.8009E-01_JPRB,3.6796E-01_JPRB,3.2253E-01_JPRB,8.7180E+00_JPRB/)
KAO( :, 2,11,11) = (/&
&3.6087E+00_JPRB,3.1771E+00_JPRB,2.7948E+00_JPRB,2.3883E+00_JPRB,1.9888E+00_JPRB,1.5919E+00_JPRB,&
&1.1796E+00_JPRB,7.5512E-01_JPRB,4.5552E-01_JPRB,4.4047E-01_JPRB,8.8675E+00_JPRB/)
KAO( :, 3,11,11) = (/&
&3.6204E+00_JPRB,3.2046E+00_JPRB,2.8376E+00_JPRB,2.4402E+00_JPRB,2.0562E+00_JPRB,1.6610E+00_JPRB,&
&1.2640E+00_JPRB,8.3788E-01_JPRB,5.7436E-01_JPRB,5.8089E-01_JPRB,8.9648E+00_JPRB/)
KAO( :, 4,11,11) = (/&
&3.6182E+00_JPRB,3.2254E+00_JPRB,2.8581E+00_JPRB,2.4960E+00_JPRB,2.1196E+00_JPRB,1.7427E+00_JPRB,&
&1.3559E+00_JPRB,9.2621E-01_JPRB,7.2423E-01_JPRB,7.4487E-01_JPRB,9.1149E+00_JPRB/)
KAO( :, 5,11,11) = (/&
&3.6174E+00_JPRB,3.2471E+00_JPRB,2.8980E+00_JPRB,2.5529E+00_JPRB,2.1857E+00_JPRB,1.8304E+00_JPRB,&
&1.4477E+00_JPRB,1.0248E+00_JPRB,8.9846E-01_JPRB,9.2879E-01_JPRB,9.3291E+00_JPRB/)
KAO( :, 1,12,11) = (/&
&3.8356E+00_JPRB,3.3697E+00_JPRB,2.9444E+00_JPRB,2.5088E+00_JPRB,2.0569E+00_JPRB,1.6203E+00_JPRB,&
&1.1634E+00_JPRB,7.0598E-01_JPRB,3.6756E-01_JPRB,2.8729E-01_JPRB,1.0641E+01_JPRB/)
KAO( :, 2,12,11) = (/&
&3.8609E+00_JPRB,3.3997E+00_JPRB,3.0019E+00_JPRB,2.5600E+00_JPRB,2.1300E+00_JPRB,1.6898E+00_JPRB,&
&1.2364E+00_JPRB,7.8348E-01_JPRB,4.3743E-01_JPRB,3.9283E-01_JPRB,1.0771E+01_JPRB/)
KAO( :, 3,12,11) = (/&
&3.8613E+00_JPRB,3.4230E+00_JPRB,3.0314E+00_JPRB,2.6152E+00_JPRB,2.1935E+00_JPRB,1.7589E+00_JPRB,&
&1.3202E+00_JPRB,8.6394E-01_JPRB,5.3376E-01_JPRB,5.1970E-01_JPRB,1.0841E+01_JPRB/)
KAO( :, 4,12,11) = (/&
&3.8625E+00_JPRB,3.4569E+00_JPRB,3.0618E+00_JPRB,2.6703E+00_JPRB,2.2548E+00_JPRB,1.8353E+00_JPRB,&
&1.4152E+00_JPRB,9.4767E-01_JPRB,6.5928E-01_JPRB,6.6542E-01_JPRB,1.0973E+01_JPRB/)
KAO( :, 5,12,11) = (/&
&3.8581E+00_JPRB,3.4796E+00_JPRB,3.1105E+00_JPRB,2.7293E+00_JPRB,2.3221E+00_JPRB,1.9216E+00_JPRB,&
&1.5109E+00_JPRB,1.0379E+00_JPRB,8.1824E-01_JPRB,8.3851E-01_JPRB,1.1187E+01_JPRB/)
KAO( :, 1,13,11) = (/&
&3.9871E+00_JPRB,3.5054E+00_JPRB,3.0792E+00_JPRB,2.6225E+00_JPRB,2.1590E+00_JPRB,1.6999E+00_JPRB,&
&1.2116E+00_JPRB,7.2436E-01_JPRB,3.6726E-01_JPRB,2.5477E-01_JPRB,9.9516E+00_JPRB/)
KAO( :, 2,13,11) = (/&
&3.9908E+00_JPRB,3.5178E+00_JPRB,3.1201E+00_JPRB,2.6682E+00_JPRB,2.2282E+00_JPRB,1.7642E+00_JPRB,&
&1.2901E+00_JPRB,8.0058E-01_JPRB,4.3056E-01_JPRB,3.4969E-01_JPRB,1.0028E+01_JPRB/)
KAO( :, 3,13,11) = (/&
&3.9925E+00_JPRB,3.5529E+00_JPRB,3.1500E+00_JPRB,2.7322E+00_JPRB,2.2922E+00_JPRB,1.8395E+00_JPRB,&
&1.3733E+00_JPRB,8.8117E-01_JPRB,5.1140E-01_JPRB,4.6457E-01_JPRB,1.0124E+01_JPRB/)
KAO( :, 4,13,11) = (/&
&3.9936E+00_JPRB,3.5963E+00_JPRB,3.1980E+00_JPRB,2.7942E+00_JPRB,2.3651E+00_JPRB,1.9195E+00_JPRB,&
&1.4609E+00_JPRB,9.6392E-01_JPRB,6.1546E-01_JPRB,5.9986E-01_JPRB,1.0319E+01_JPRB/)
KAO( :, 5,13,11) = (/&
&3.9766E+00_JPRB,3.6110E+00_JPRB,3.2440E+00_JPRB,2.8558E+00_JPRB,2.4407E+00_JPRB,2.0092E+00_JPRB,&
&1.5546E+00_JPRB,1.0530E+00_JPRB,7.5480E-01_JPRB,7.6043E-01_JPRB,1.0517E+01_JPRB/)
KAO( :, 1, 1,12) = (/&
&2.0024E+00_JPRB,1.8234E+00_JPRB,1.7233E+00_JPRB,1.6000E+00_JPRB,1.5390E+00_JPRB,1.6921E+00_JPRB,&
&2.0059E+00_JPRB,2.3183E+00_JPRB,2.5294E+00_JPRB,2.5972E+00_JPRB,2.5881E+00_JPRB/)
KAO( :, 2, 1,12) = (/&
&1.9590E+00_JPRB,1.7950E+00_JPRB,1.7523E+00_JPRB,1.6313E+00_JPRB,1.6912E+00_JPRB,2.0086E+00_JPRB,&
&2.3854E+00_JPRB,2.7609E+00_JPRB,3.0136E+00_JPRB,3.0926E+00_JPRB,3.0692E+00_JPRB/)
KAO( :, 3, 1,12) = (/&
&1.9218E+00_JPRB,1.7695E+00_JPRB,1.7573E+00_JPRB,1.7104E+00_JPRB,1.9221E+00_JPRB,2.3617E+00_JPRB,&
&2.8084E+00_JPRB,3.2536E+00_JPRB,3.5528E+00_JPRB,3.6452E+00_JPRB,3.6033E+00_JPRB/)
KAO( :, 4, 1,12) = (/&
&1.8869E+00_JPRB,1.7776E+00_JPRB,1.7584E+00_JPRB,1.8482E+00_JPRB,2.2062E+00_JPRB,2.7254E+00_JPRB,&
&3.2420E+00_JPRB,3.7568E+00_JPRB,4.1037E+00_JPRB,4.2125E+00_JPRB,4.1721E+00_JPRB/)
KAO( :, 5, 1,12) = (/&
&1.8556E+00_JPRB,1.7835E+00_JPRB,1.7826E+00_JPRB,2.0106E+00_JPRB,2.5078E+00_JPRB,3.0956E+00_JPRB,&
&3.6815E+00_JPRB,4.2658E+00_JPRB,4.6607E+00_JPRB,4.7891E+00_JPRB,4.7658E+00_JPRB/)
KAO( :, 1, 2,12) = (/&
&2.1298E+00_JPRB,1.9238E+00_JPRB,1.7993E+00_JPRB,1.6635E+00_JPRB,1.5382E+00_JPRB,1.6444E+00_JPRB,&
&1.9357E+00_JPRB,2.2355E+00_JPRB,2.4380E+00_JPRB,2.5040E+00_JPRB,2.5099E+00_JPRB/)
KAO( :, 2, 2,12) = (/&
&2.0858E+00_JPRB,1.8949E+00_JPRB,1.8227E+00_JPRB,1.6898E+00_JPRB,1.7064E+00_JPRB,1.9739E+00_JPRB,&
&2.3396E+00_JPRB,2.7042E+00_JPRB,2.9505E+00_JPRB,3.0304E+00_JPRB,3.0347E+00_JPRB/)
KAO( :, 3, 2,12) = (/&
&2.0506E+00_JPRB,1.8767E+00_JPRB,1.8261E+00_JPRB,1.7610E+00_JPRB,1.9334E+00_JPRB,2.3331E+00_JPRB,&
&2.7675E+00_JPRB,3.2005E+00_JPRB,3.4937E+00_JPRB,3.5905E+00_JPRB,3.6006E+00_JPRB/)
KAO( :, 4, 2,12) = (/&
&2.0203E+00_JPRB,1.8859E+00_JPRB,1.8248E+00_JPRB,1.8919E+00_JPRB,2.2034E+00_JPRB,2.7037E+00_JPRB,&
&3.2087E+00_JPRB,3.7127E+00_JPRB,4.0556E+00_JPRB,4.1705E+00_JPRB,4.1872E+00_JPRB/)
KAO( :, 5, 2,12) = (/&
&1.9908E+00_JPRB,1.8904E+00_JPRB,1.8512E+00_JPRB,2.0461E+00_JPRB,2.4857E+00_JPRB,3.0612E+00_JPRB,&
&3.6347E+00_JPRB,4.2084E+00_JPRB,4.6000E+00_JPRB,4.7320E+00_JPRB,4.7545E+00_JPRB/)
KAO( :, 1, 3,12) = (/&
&2.3152E+00_JPRB,2.0670E+00_JPRB,1.8762E+00_JPRB,1.7274E+00_JPRB,1.5513E+00_JPRB,1.5459E+00_JPRB,&
&1.7613E+00_JPRB,2.0324E+00_JPRB,2.2184E+00_JPRB,2.2809E+00_JPRB,2.3001E+00_JPRB/)
KAO( :, 2, 3,12) = (/&
&2.2611E+00_JPRB,2.0302E+00_JPRB,1.8953E+00_JPRB,1.7501E+00_JPRB,1.6877E+00_JPRB,1.8252E+00_JPRB,&
&2.1469E+00_JPRB,2.4814E+00_JPRB,2.7105E+00_JPRB,2.7886E+00_JPRB,2.8127E+00_JPRB/)
KAO( :, 3, 3,12) = (/&
&2.2196E+00_JPRB,2.0024E+00_JPRB,1.9041E+00_JPRB,1.8045E+00_JPRB,1.8785E+00_JPRB,2.1610E+00_JPRB,&
&2.5580E+00_JPRB,2.9591E+00_JPRB,3.2348E+00_JPRB,3.3294E+00_JPRB,3.3602E+00_JPRB/)
KAO( :, 4, 3,12) = (/&
&2.1813E+00_JPRB,2.0049E+00_JPRB,1.9086E+00_JPRB,1.9162E+00_JPRB,2.1012E+00_JPRB,2.5182E+00_JPRB,&
&2.9831E+00_JPRB,3.4549E+00_JPRB,3.7770E+00_JPRB,3.8911E+00_JPRB,3.9291E+00_JPRB/)
KAO( :, 5, 3,12) = (/&
&2.1479E+00_JPRB,2.0113E+00_JPRB,1.9331E+00_JPRB,2.0520E+00_JPRB,2.3502E+00_JPRB,2.8679E+00_JPRB,&
&3.4008E+00_JPRB,3.9406E+00_JPRB,4.3094E+00_JPRB,4.4428E+00_JPRB,4.4869E+00_JPRB/)
KAO( :, 1, 4,12) = (/&
&2.5457E+00_JPRB,2.2591E+00_JPRB,2.0008E+00_JPRB,1.7948E+00_JPRB,1.5715E+00_JPRB,1.4721E+00_JPRB,&
&1.5451E+00_JPRB,1.7860E+00_JPRB,1.9513E+00_JPRB,2.0089E+00_JPRB,2.0285E+00_JPRB/)
KAO( :, 2, 4,12) = (/&
&2.4902E+00_JPRB,2.2151E+00_JPRB,2.0050E+00_JPRB,1.8035E+00_JPRB,1.6846E+00_JPRB,1.6830E+00_JPRB,&
&1.9079E+00_JPRB,2.2087E+00_JPRB,2.4143E+00_JPRB,2.4852E+00_JPRB,2.5099E+00_JPRB/)
KAO( :, 3, 4,12) = (/&
&2.4431E+00_JPRB,2.1812E+00_JPRB,2.0033E+00_JPRB,1.8558E+00_JPRB,1.8346E+00_JPRB,1.9529E+00_JPRB,&
&2.2983E+00_JPRB,2.6628E+00_JPRB,2.9108E+00_JPRB,2.9983E+00_JPRB,3.0280E+00_JPRB/)
KAO( :, 4, 4,12) = (/&
&2.3979E+00_JPRB,2.1681E+00_JPRB,1.9996E+00_JPRB,1.9562E+00_JPRB,2.0099E+00_JPRB,2.2734E+00_JPRB,&
&2.7005E+00_JPRB,3.1310E+00_JPRB,3.4248E+00_JPRB,3.5296E+00_JPRB,3.5651E+00_JPRB/)
KAO( :, 5, 4,12) = (/&
&2.3549E+00_JPRB,2.1677E+00_JPRB,2.0250E+00_JPRB,2.0706E+00_JPRB,2.2012E+00_JPRB,2.6084E+00_JPRB,&
&3.1023E+00_JPRB,3.5987E+00_JPRB,3.9377E+00_JPRB,4.0590E+00_JPRB,4.0984E+00_JPRB/)
KAO( :, 1, 5,12) = (/&
&2.7985E+00_JPRB,2.4747E+00_JPRB,2.1629E+00_JPRB,1.9120E+00_JPRB,1.6257E+00_JPRB,1.4332E+00_JPRB,&
&1.3851E+00_JPRB,1.5480E+00_JPRB,1.6917E+00_JPRB,1.7423E+00_JPRB,1.7595E+00_JPRB/)
KAO( :, 2, 5,12) = (/&
&2.7492E+00_JPRB,2.4385E+00_JPRB,2.1709E+00_JPRB,1.9088E+00_JPRB,1.7063E+00_JPRB,1.6093E+00_JPRB,&
&1.6827E+00_JPRB,1.9416E+00_JPRB,2.1228E+00_JPRB,2.1868E+00_JPRB,2.2077E+00_JPRB/)
KAO( :, 3, 5,12) = (/&
&2.7030E+00_JPRB,2.4052E+00_JPRB,2.1654E+00_JPRB,1.9357E+00_JPRB,1.8221E+00_JPRB,1.8325E+00_JPRB,&
&2.0441E+00_JPRB,2.3696E+00_JPRB,2.5914E+00_JPRB,2.6707E+00_JPRB,2.6969E+00_JPRB/)
KAO( :, 4, 5,12) = (/&
&2.6567E+00_JPRB,2.3812E+00_JPRB,2.1576E+00_JPRB,2.0192E+00_JPRB,1.9790E+00_JPRB,2.0835E+00_JPRB,&
&2.4268E+00_JPRB,2.8144E+00_JPRB,3.0796E+00_JPRB,3.1741E+00_JPRB,3.2046E+00_JPRB/)
KAO( :, 5, 5,12) = (/&
&2.6110E+00_JPRB,2.3730E+00_JPRB,2.1635E+00_JPRB,2.1182E+00_JPRB,2.1485E+00_JPRB,2.3741E+00_JPRB,&
&2.8181E+00_JPRB,3.2699E+00_JPRB,3.5786E+00_JPRB,3.6897E+00_JPRB,3.7249E+00_JPRB/)
KAO( :, 1, 6,12) = (/&
&3.0669E+00_JPRB,2.7085E+00_JPRB,2.3540E+00_JPRB,2.0714E+00_JPRB,1.7429E+00_JPRB,1.4581E+00_JPRB,&
&1.2708E+00_JPRB,1.2992E+00_JPRB,1.4199E+00_JPRB,1.4638E+00_JPRB,1.4769E+00_JPRB/)
KAO( :, 2, 6,12) = (/&
&3.0273E+00_JPRB,2.6834E+00_JPRB,2.3740E+00_JPRB,2.0802E+00_JPRB,1.7965E+00_JPRB,1.5717E+00_JPRB,&
&1.5052E+00_JPRB,1.6583E+00_JPRB,1.8132E+00_JPRB,1.8699E+00_JPRB,1.8859E+00_JPRB/)
KAO( :, 3, 6,12) = (/&
&2.9774E+00_JPRB,2.6481E+00_JPRB,2.3757E+00_JPRB,2.0942E+00_JPRB,1.8671E+00_JPRB,1.7544E+00_JPRB,&
&1.8026E+00_JPRB,2.0622E+00_JPRB,2.2566E+00_JPRB,2.3275E+00_JPRB,2.3474E+00_JPRB/)
KAO( :, 4, 6,12) = (/&
&2.9289E+00_JPRB,2.6161E+00_JPRB,2.3748E+00_JPRB,2.1584E+00_JPRB,1.9838E+00_JPRB,1.9738E+00_JPRB,&
&2.1469E+00_JPRB,2.4888E+00_JPRB,2.7236E+00_JPRB,2.8101E+00_JPRB,2.8355E+00_JPRB/)
KAO( :, 5, 6,12) = (/&
&2.8845E+00_JPRB,2.6155E+00_JPRB,2.3754E+00_JPRB,2.2196E+00_JPRB,2.1301E+00_JPRB,2.2099E+00_JPRB,&
&2.5314E+00_JPRB,2.9385E+00_JPRB,3.2168E+00_JPRB,3.3176E+00_JPRB,3.3483E+00_JPRB/)
KAO( :, 1, 7,12) = (/&
&3.3664E+00_JPRB,2.9675E+00_JPRB,2.5762E+00_JPRB,2.2561E+00_JPRB,1.8881E+00_JPRB,1.5413E+00_JPRB,&
&1.2170E+00_JPRB,1.0953E+00_JPRB,1.1799E+00_JPRB,1.2170E+00_JPRB,1.2273E+00_JPRB/)
KAO( :, 2, 7,12) = (/&
&3.3233E+00_JPRB,2.9434E+00_JPRB,2.5928E+00_JPRB,2.2752E+00_JPRB,1.9335E+00_JPRB,1.6227E+00_JPRB,&
&1.3832E+00_JPRB,1.3998E+00_JPRB,1.5310E+00_JPRB,1.5791E+00_JPRB,1.5922E+00_JPRB/)
KAO( :, 3, 7,12) = (/&
&3.2746E+00_JPRB,2.9093E+00_JPRB,2.6019E+00_JPRB,2.2869E+00_JPRB,2.0053E+00_JPRB,1.7360E+00_JPRB,&
&1.6231E+00_JPRB,1.7636E+00_JPRB,1.9299E+00_JPRB,1.9918E+00_JPRB,2.0082E+00_JPRB/)
KAO( :, 4, 7,12) = (/&
&3.2312E+00_JPRB,2.8766E+00_JPRB,2.6067E+00_JPRB,2.3470E+00_JPRB,2.0847E+00_JPRB,1.8980E+00_JPRB,&
&1.9031E+00_JPRB,2.1576E+00_JPRB,2.3620E+00_JPRB,2.4387E+00_JPRB,2.4578E+00_JPRB/)
KAO( :, 5, 7,12) = (/&
&3.1925E+00_JPRB,2.8793E+00_JPRB,2.6061E+00_JPRB,2.4035E+00_JPRB,2.1834E+00_JPRB,2.1023E+00_JPRB,&
&2.2418E+00_JPRB,2.5923E+00_JPRB,2.8385E+00_JPRB,2.9297E+00_JPRB,2.9542E+00_JPRB/)
KAO( :, 1, 8,12) = (/&
&3.6796E+00_JPRB,3.2357E+00_JPRB,2.8155E+00_JPRB,2.4508E+00_JPRB,2.0518E+00_JPRB,1.6449E+00_JPRB,&
&1.2564E+00_JPRB,9.4794E-01_JPRB,9.6423E-01_JPRB,9.9527E-01_JPRB,1.0031E+00_JPRB/)
KAO( :, 2, 8,12) = (/&
&3.6371E+00_JPRB,3.2182E+00_JPRB,2.8214E+00_JPRB,2.4857E+00_JPRB,2.0950E+00_JPRB,1.7292E+00_JPRB,&
&1.3545E+00_JPRB,1.1961E+00_JPRB,1.2815E+00_JPRB,1.3224E+00_JPRB,1.3335E+00_JPRB/)
KAO( :, 3, 8,12) = (/&
&3.5989E+00_JPRB,3.1965E+00_JPRB,2.8529E+00_JPRB,2.5009E+00_JPRB,2.1656E+00_JPRB,1.8143E+00_JPRB,&
&1.5162E+00_JPRB,1.5048E+00_JPRB,1.6425E+00_JPRB,1.6953E+00_JPRB,1.7094E+00_JPRB/)
KAO( :, 4, 8,12) = (/&
&3.5657E+00_JPRB,3.1726E+00_JPRB,2.8689E+00_JPRB,2.5490E+00_JPRB,2.2397E+00_JPRB,1.9179E+00_JPRB,&
&1.7462E+00_JPRB,1.8651E+00_JPRB,2.0421E+00_JPRB,2.1078E+00_JPRB,2.1252E+00_JPRB/)
KAO( :, 5, 8,12) = (/&
&3.5352E+00_JPRB,3.1791E+00_JPRB,2.8690E+00_JPRB,2.6021E+00_JPRB,2.3244E+00_JPRB,2.0668E+00_JPRB,&
&2.0251E+00_JPRB,2.2682E+00_JPRB,2.4843E+00_JPRB,2.5643E+00_JPRB,2.5857E+00_JPRB/)
KAO( :, 1, 9,12) = (/&
&4.0318E+00_JPRB,3.5333E+00_JPRB,3.0785E+00_JPRB,2.6542E+00_JPRB,2.2190E+00_JPRB,1.7557E+00_JPRB,&
&1.3174E+00_JPRB,8.6677E-01_JPRB,7.7038E-01_JPRB,7.9546E-01_JPRB,1.7542E+00_JPRB/)
KAO( :, 2, 9,12) = (/&
&4.0030E+00_JPRB,3.5307E+00_JPRB,3.0824E+00_JPRB,2.7001E+00_JPRB,2.2575E+00_JPRB,1.8461E+00_JPRB,&
&1.4064E+00_JPRB,1.0445E+00_JPRB,1.0532E+00_JPRB,1.0871E+00_JPRB,1.8981E+00_JPRB/)
KAO( :, 3, 9,12) = (/&
&3.9727E+00_JPRB,3.5227E+00_JPRB,3.1268E+00_JPRB,2.7209E+00_JPRB,2.3294E+00_JPRB,1.9265E+00_JPRB,&
&1.5119E+00_JPRB,1.3023E+00_JPRB,1.3838E+00_JPRB,1.4291E+00_JPRB,2.0473E+00_JPRB/)
KAO( :, 4, 9,12) = (/&
&3.9416E+00_JPRB,3.5045E+00_JPRB,3.1488E+00_JPRB,2.7628E+00_JPRB,2.4024E+00_JPRB,2.0175E+00_JPRB,&
&1.6727E+00_JPRB,1.6129E+00_JPRB,1.7549E+00_JPRB,1.8115E+00_JPRB,2.2264E+00_JPRB/)
KAO( :, 5, 9,12) = (/&
&3.9107E+00_JPRB,3.5025E+00_JPRB,3.1553E+00_JPRB,2.8210E+00_JPRB,2.4858E+00_JPRB,2.1278E+00_JPRB,&
&1.8886E+00_JPRB,1.9733E+00_JPRB,2.1611E+00_JPRB,2.2311E+00_JPRB,2.4535E+00_JPRB/)
KAO( :, 1,10,12) = (/&
&4.3955E+00_JPRB,3.8477E+00_JPRB,3.3521E+00_JPRB,2.8767E+00_JPRB,2.3926E+00_JPRB,1.8785E+00_JPRB,&
&1.3866E+00_JPRB,8.6336E-01_JPRB,6.3346E-01_JPRB,6.4780E-01_JPRB,7.3111E+00_JPRB/)
KAO( :, 2,10,12) = (/&
&4.3744E+00_JPRB,3.8521E+00_JPRB,3.3628E+00_JPRB,2.9299E+00_JPRB,2.4350E+00_JPRB,1.9605E+00_JPRB,&
&1.4761E+00_JPRB,9.8354E-01_JPRB,8.7753E-01_JPRB,9.0596E-01_JPRB,7.5369E+00_JPRB/)
KAO( :, 3,10,12) = (/&
&4.3454E+00_JPRB,3.8426E+00_JPRB,3.4089E+00_JPRB,2.9580E+00_JPRB,2.5003E+00_JPRB,2.0431E+00_JPRB,&
&1.5702E+00_JPRB,1.1751E+00_JPRB,1.1717E+00_JPRB,1.2103E+00_JPRB,7.6962E+00_JPRB/)
KAO( :, 4,10,12) = (/&
&4.3187E+00_JPRB,3.8382E+00_JPRB,3.4396E+00_JPRB,2.9970E+00_JPRB,2.5770E+00_JPRB,2.1340E+00_JPRB,&
&1.7005E+00_JPRB,1.4326E+00_JPRB,1.5105E+00_JPRB,1.5607E+00_JPRB,7.8986E+00_JPRB/)
KAO( :, 5,10,12) = (/&
&4.2903E+00_JPRB,3.8382E+00_JPRB,3.4516E+00_JPRB,3.0612E+00_JPRB,2.6632E+00_JPRB,2.2380E+00_JPRB,&
&1.8630E+00_JPRB,1.7458E+00_JPRB,1.8899E+00_JPRB,1.9522E+00_JPRB,8.1725E+00_JPRB/)
KAO( :, 1,11,12) = (/&
&4.7308E+00_JPRB,4.1459E+00_JPRB,3.6107E+00_JPRB,3.1115E+00_JPRB,2.5799E+00_JPRB,2.0280E+00_JPRB,&
&1.4948E+00_JPRB,9.2025E-01_JPRB,6.1405E-01_JPRB,6.1696E-01_JPRB,1.2757E+01_JPRB/)
KAO( :, 2,11,12) = (/&
&4.7091E+00_JPRB,4.1481E+00_JPRB,3.6443E+00_JPRB,3.1635E+00_JPRB,2.6293E+00_JPRB,2.1180E+00_JPRB,&
&1.5850E+00_JPRB,1.0412E+00_JPRB,8.3722E-01_JPRB,8.6133E-01_JPRB,1.3027E+01_JPRB/)
KAO( :, 3,11,12) = (/&
&4.6897E+00_JPRB,4.1435E+00_JPRB,3.6990E+00_JPRB,3.1970E+00_JPRB,2.7141E+00_JPRB,2.2094E+00_JPRB,&
&1.6909E+00_JPRB,1.1958E+00_JPRB,1.1123E+00_JPRB,1.1498E+00_JPRB,1.3314E+01_JPRB/)
KAO( :, 4,11,12) = (/&
&4.6692E+00_JPRB,4.1531E+00_JPRB,3.7297E+00_JPRB,3.2622E+00_JPRB,2.7974E+00_JPRB,2.3063E+00_JPRB,&
&1.8183E+00_JPRB,1.4163E+00_JPRB,1.4330E+00_JPRB,1.4813E+00_JPRB,1.3489E+01_JPRB/)
KAO( :, 5,11,12) = (/&
&4.6420E+00_JPRB,4.1769E+00_JPRB,3.7456E+00_JPRB,3.3296E+00_JPRB,2.8874E+00_JPRB,2.4151E+00_JPRB,&
&1.9751E+00_JPRB,1.6959E+00_JPRB,1.7942E+00_JPRB,1.8551E+00_JPRB,1.3680E+01_JPRB/)
KAO( :, 1,12,12) = (/&
&5.0416E+00_JPRB,4.4234E+00_JPRB,3.8522E+00_JPRB,3.3241E+00_JPRB,2.7470E+00_JPRB,2.1693E+00_JPRB,&
&1.6007E+00_JPRB,9.8107E-01_JPRB,5.9628E-01_JPRB,5.7876E-01_JPRB,1.6383E+01_JPRB/)
KAO( :, 2,12,12) = (/&
&5.0347E+00_JPRB,4.4335E+00_JPRB,3.9118E+00_JPRB,3.3765E+00_JPRB,2.8152E+00_JPRB,2.2721E+00_JPRB,&
&1.6921E+00_JPRB,1.0981E+00_JPRB,7.9216E-01_JPRB,8.0484E-01_JPRB,1.6695E+01_JPRB/)
KAO( :, 3,12,12) = (/&
&5.0354E+00_JPRB,4.4439E+00_JPRB,3.9725E+00_JPRB,3.4283E+00_JPRB,2.9170E+00_JPRB,2.3708E+00_JPRB,&
&1.8115E+00_JPRB,1.2441E+00_JPRB,1.0402E+00_JPRB,1.0726E+00_JPRB,1.7028E+01_JPRB/)
KAO( :, 4,12,12) = (/&
&5.0236E+00_JPRB,4.4684E+00_JPRB,4.0052E+00_JPRB,3.5139E+00_JPRB,3.0129E+00_JPRB,2.4842E+00_JPRB,&
&1.9405E+00_JPRB,1.4225E+00_JPRB,1.3339E+00_JPRB,1.3805E+00_JPRB,1.7215E+01_JPRB/)
KAO( :, 5,12,12) = (/&
&5.0049E+00_JPRB,4.5094E+00_JPRB,4.0368E+00_JPRB,3.5937E+00_JPRB,3.1097E+00_JPRB,2.6019E+00_JPRB,&
&2.0929E+00_JPRB,1.6533E+00_JPRB,1.6680E+00_JPRB,1.7268E+00_JPRB,1.7382E+01_JPRB/)
KAO( :, 1,13,12) = (/&
&5.3304E+00_JPRB,4.6811E+00_JPRB,4.0819E+00_JPRB,3.5134E+00_JPRB,2.8970E+00_JPRB,2.2995E+00_JPRB,&
&1.6906E+00_JPRB,1.0389E+00_JPRB,5.8422E-01_JPRB,5.3149E-01_JPRB,1.6186E+01_JPRB/)
KAO( :, 2,13,12) = (/&
&5.3554E+00_JPRB,4.7152E+00_JPRB,4.1740E+00_JPRB,3.5813E+00_JPRB,2.9917E+00_JPRB,2.4106E+00_JPRB,&
&1.7931E+00_JPRB,1.1573E+00_JPRB,7.4488E-01_JPRB,7.3540E-01_JPRB,1.6553E+01_JPRB/)
KAO( :, 3,13,12) = (/&
&5.3653E+00_JPRB,4.7361E+00_JPRB,4.2367E+00_JPRB,3.6559E+00_JPRB,3.0996E+00_JPRB,2.5206E+00_JPRB,&
&1.9222E+00_JPRB,1.2910E+00_JPRB,9.5651E-01_JPRB,9.7652E-01_JPRB,1.6790E+01_JPRB/)
KAO( :, 4,13,12) = (/&
&5.3597E+00_JPRB,4.7768E+00_JPRB,4.2708E+00_JPRB,3.7474E+00_JPRB,3.2027E+00_JPRB,2.6474E+00_JPRB,&
&2.0605E+00_JPRB,1.4452E+00_JPRB,1.2190E+00_JPRB,1.2583E+00_JPRB,1.6940E+01_JPRB/)
KAO( :, 5,13,12) = (/&
&5.3540E+00_JPRB,4.8243E+00_JPRB,4.3295E+00_JPRB,3.8360E+00_JPRB,3.3105E+00_JPRB,2.7756E+00_JPRB,&
&2.2095E+00_JPRB,1.6297E+00_JPRB,1.5189E+00_JPRB,1.5724E+00_JPRB,1.7194E+01_JPRB/)
KAO( :, 1, 1,13) = (/&
&2.4839E+00_JPRB,2.2228E+00_JPRB,1.9877E+00_JPRB,1.9817E+00_JPRB,2.1295E+00_JPRB,2.6064E+00_JPRB,&
&3.1026E+00_JPRB,3.6009E+00_JPRB,3.9384E+00_JPRB,4.0531E+00_JPRB,4.0630E+00_JPRB/)
KAO( :, 2, 1,13) = (/&
&2.4167E+00_JPRB,2.1788E+00_JPRB,2.0545E+00_JPRB,2.1075E+00_JPRB,2.4600E+00_JPRB,3.0319E+00_JPRB,&
&3.6075E+00_JPRB,4.1850E+00_JPRB,4.5773E+00_JPRB,4.7124E+00_JPRB,4.7383E+00_JPRB/)
KAO( :, 3, 1,13) = (/&
&2.3519E+00_JPRB,2.1341E+00_JPRB,2.1343E+00_JPRB,2.2717E+00_JPRB,2.8227E+00_JPRB,3.4785E+00_JPRB,&
&4.1394E+00_JPRB,4.8027E+00_JPRB,5.2528E+00_JPRB,5.4080E+00_JPRB,5.4468E+00_JPRB/)
KAO( :, 4, 1,13) = (/&
&2.2895E+00_JPRB,2.0936E+00_JPRB,2.2122E+00_JPRB,2.4949E+00_JPRB,3.2196E+00_JPRB,3.9764E+00_JPRB,&
&4.7367E+00_JPRB,5.4979E+00_JPRB,6.0151E+00_JPRB,6.1897E+00_JPRB,6.2191E+00_JPRB/)
KAO( :, 5, 1,13) = (/&
&2.2294E+00_JPRB,2.0855E+00_JPRB,2.2831E+00_JPRB,2.7897E+00_JPRB,3.6518E+00_JPRB,4.5202E+00_JPRB,&
&5.3909E+00_JPRB,6.2623E+00_JPRB,6.8525E+00_JPRB,7.0478E+00_JPRB,7.0466E+00_JPRB/)
KAO( :, 1, 2,13) = (/&
&2.6401E+00_JPRB,2.3655E+00_JPRB,2.1111E+00_JPRB,2.0137E+00_JPRB,2.0825E+00_JPRB,2.5044E+00_JPRB,&
&2.9828E+00_JPRB,3.4624E+00_JPRB,3.7882E+00_JPRB,3.8997E+00_JPRB,3.9250E+00_JPRB/)
KAO( :, 2, 2,13) = (/&
&2.5670E+00_JPRB,2.3197E+00_JPRB,2.1659E+00_JPRB,2.1086E+00_JPRB,2.3636E+00_JPRB,2.9098E+00_JPRB,&
&3.4676E+00_JPRB,4.0262E+00_JPRB,4.4056E+00_JPRB,4.5331E+00_JPRB,4.5625E+00_JPRB/)
KAO( :, 3, 2,13) = (/&
&2.4971E+00_JPRB,2.2719E+00_JPRB,2.2158E+00_JPRB,2.2307E+00_JPRB,2.7197E+00_JPRB,3.3654E+00_JPRB,&
&4.0138E+00_JPRB,4.6621E+00_JPRB,5.1023E+00_JPRB,5.2462E+00_JPRB,5.2684E+00_JPRB/)
KAO( :, 4, 2,13) = (/&
&2.4323E+00_JPRB,2.2338E+00_JPRB,2.2635E+00_JPRB,2.4358E+00_JPRB,3.1246E+00_JPRB,3.8712E+00_JPRB,&
&4.6205E+00_JPRB,5.3694E+00_JPRB,5.8768E+00_JPRB,6.0401E+00_JPRB,6.0554E+00_JPRB/)
KAO( :, 5, 2,13) = (/&
&2.3760E+00_JPRB,2.2281E+00_JPRB,2.3133E+00_JPRB,2.7376E+00_JPRB,3.5897E+00_JPRB,4.4519E+00_JPRB,&
&5.3157E+00_JPRB,6.1803E+00_JPRB,6.7635E+00_JPRB,6.9497E+00_JPRB,6.9610E+00_JPRB/)
KAO( :, 1, 3,13) = (/&
&2.8086E+00_JPRB,2.5114E+00_JPRB,2.2208E+00_JPRB,2.0677E+00_JPRB,2.0427E+00_JPRB,2.3373E+00_JPRB,&
&2.7874E+00_JPRB,3.2384E+00_JPRB,3.5440E+00_JPRB,3.6445E+00_JPRB,3.6749E+00_JPRB/)
KAO( :, 2, 3,13) = (/&
&2.7404E+00_JPRB,2.4643E+00_JPRB,2.2716E+00_JPRB,2.1464E+00_JPRB,2.2628E+00_JPRB,2.7529E+00_JPRB,&
&3.2849E+00_JPRB,3.8172E+00_JPRB,4.1782E+00_JPRB,4.2940E+00_JPRB,4.3270E+00_JPRB/)
KAO( :, 3, 3,13) = (/&
&2.6764E+00_JPRB,2.4178E+00_JPRB,2.3087E+00_JPRB,2.2456E+00_JPRB,2.5986E+00_JPRB,3.2215E+00_JPRB,&
&3.8463E+00_JPRB,4.4711E+00_JPRB,4.8938E+00_JPRB,5.0274E+00_JPRB,5.0645E+00_JPRB/)
KAO( :, 4, 3,13) = (/&
&2.6211E+00_JPRB,2.3803E+00_JPRB,2.3402E+00_JPRB,2.4064E+00_JPRB,3.0169E+00_JPRB,3.7447E+00_JPRB,&
&4.4738E+00_JPRB,5.2031E+00_JPRB,5.6949E+00_JPRB,5.8469E+00_JPRB,5.8866E+00_JPRB/)
KAO( :, 5, 3,13) = (/&
&2.5706E+00_JPRB,2.3763E+00_JPRB,2.3730E+00_JPRB,2.6809E+00_JPRB,3.4926E+00_JPRB,4.3391E+00_JPRB,&
&5.1873E+00_JPRB,6.0352E+00_JPRB,6.6054E+00_JPRB,6.7799E+00_JPRB,6.8242E+00_JPRB/)
KAO( :, 1, 4,13) = (/&
&2.9705E+00_JPRB,2.6437E+00_JPRB,2.3228E+00_JPRB,2.1502E+00_JPRB,2.0620E+00_JPRB,2.1581E+00_JPRB,&
&2.5548E+00_JPRB,2.9693E+00_JPRB,3.2504E+00_JPRB,3.3452E+00_JPRB,3.3799E+00_JPRB/)
KAO( :, 2, 4,13) = (/&
&2.9060E+00_JPRB,2.6045E+00_JPRB,2.3805E+00_JPRB,2.2339E+00_JPRB,2.2319E+00_JPRB,2.5887E+00_JPRB,&
&3.0909E+00_JPRB,3.5931E+00_JPRB,3.9330E+00_JPRB,4.0437E+00_JPRB,4.0869E+00_JPRB/)
KAO( :, 3, 4,13) = (/&
&2.8503E+00_JPRB,2.5669E+00_JPRB,2.4183E+00_JPRB,2.3219E+00_JPRB,2.5237E+00_JPRB,3.0875E+00_JPRB,&
&3.6882E+00_JPRB,4.2895E+00_JPRB,4.6950E+00_JPRB,4.8250E+00_JPRB,4.8772E+00_JPRB/)
KAO( :, 4, 4,13) = (/&
&2.8040E+00_JPRB,2.5355E+00_JPRB,2.4511E+00_JPRB,2.4730E+00_JPRB,2.9343E+00_JPRB,3.6460E+00_JPRB,&
&4.3587E+00_JPRB,5.0710E+00_JPRB,5.5512E+00_JPRB,5.6975E+00_JPRB,5.7609E+00_JPRB/)
KAO( :, 5, 4,13) = (/&
&2.7640E+00_JPRB,2.5346E+00_JPRB,2.4816E+00_JPRB,2.7138E+00_JPRB,3.4317E+00_JPRB,4.2678E+00_JPRB,&
&5.1048E+00_JPRB,5.9414E+00_JPRB,6.5038E+00_JPRB,6.6733E+00_JPRB,6.7499E+00_JPRB/)
KAO( :, 1, 5,13) = (/&
&3.2157E+00_JPRB,2.8490E+00_JPRB,2.4890E+00_JPRB,2.2607E+00_JPRB,2.1003E+00_JPRB,2.0316E+00_JPRB,&
&2.2821E+00_JPRB,2.6531E+00_JPRB,2.9050E+00_JPRB,2.9914E+00_JPRB,3.0227E+00_JPRB/)
KAO( :, 2, 5,13) = (/&
&3.1462E+00_JPRB,2.8052E+00_JPRB,2.5301E+00_JPRB,2.3469E+00_JPRB,2.2490E+00_JPRB,2.3958E+00_JPRB,&
&2.8314E+00_JPRB,3.2925E+00_JPRB,3.6050E+00_JPRB,3.7092E+00_JPRB,3.7515E+00_JPRB/)
KAO( :, 3, 5,13) = (/&
&3.0906E+00_JPRB,2.7658E+00_JPRB,2.5622E+00_JPRB,2.4318E+00_JPRB,2.4969E+00_JPRB,2.8886E+00_JPRB,&
&3.4523E+00_JPRB,4.0155E+00_JPRB,4.3974E+00_JPRB,4.5211E+00_JPRB,4.5746E+00_JPRB/)
KAO( :, 4, 5,13) = (/&
&3.0486E+00_JPRB,2.7373E+00_JPRB,2.5958E+00_JPRB,2.5683E+00_JPRB,2.8557E+00_JPRB,3.4815E+00_JPRB,&
&4.1633E+00_JPRB,4.8446E+00_JPRB,5.3051E+00_JPRB,5.4504E+00_JPRB,5.5199E+00_JPRB/)
KAO( :, 5, 5,13) = (/&
&3.0130E+00_JPRB,2.7440E+00_JPRB,2.6274E+00_JPRB,2.8078E+00_JPRB,3.3228E+00_JPRB,4.1277E+00_JPRB,&
&4.9382E+00_JPRB,5.7481E+00_JPRB,6.2955E+00_JPRB,6.4701E+00_JPRB,6.5508E+00_JPRB/)
KAO( :, 1, 6,13) = (/&
&3.5873E+00_JPRB,3.1674E+00_JPRB,2.7646E+00_JPRB,2.4502E+00_JPRB,2.1689E+00_JPRB,1.9718E+00_JPRB,&
&2.0147E+00_JPRB,2.3234E+00_JPRB,2.5447E+00_JPRB,2.6195E+00_JPRB,2.6494E+00_JPRB/)
KAO( :, 2, 6,13) = (/&
&3.5157E+00_JPRB,3.1229E+00_JPRB,2.7666E+00_JPRB,2.5046E+00_JPRB,2.2807E+00_JPRB,2.2712E+00_JPRB,&
&2.5407E+00_JPRB,2.9561E+00_JPRB,3.2371E+00_JPRB,3.3302E+00_JPRB,3.3702E+00_JPRB/)
KAO( :, 3, 6,13) = (/&
&3.4666E+00_JPRB,3.0873E+00_JPRB,2.7933E+00_JPRB,2.5658E+00_JPRB,2.5099E+00_JPRB,2.6904E+00_JPRB,&
&3.1624E+00_JPRB,3.6822E+00_JPRB,4.0323E+00_JPRB,4.1466E+00_JPRB,4.1994E+00_JPRB/)
KAO( :, 4, 6,13) = (/&
&3.4223E+00_JPRB,3.0572E+00_JPRB,2.8088E+00_JPRB,2.6700E+00_JPRB,2.8225E+00_JPRB,3.2304E+00_JPRB,&
&3.8614E+00_JPRB,4.4961E+00_JPRB,4.9248E+00_JPRB,5.0662E+00_JPRB,5.1277E+00_JPRB/)
KAO( :, 5, 6,13) = (/&
&3.3760E+00_JPRB,3.0424E+00_JPRB,2.8322E+00_JPRB,2.8911E+00_JPRB,3.2026E+00_JPRB,3.8541E+00_JPRB,&
&4.6128E+00_JPRB,5.3710E+00_JPRB,5.8848E+00_JPRB,6.0557E+00_JPRB,6.1288E+00_JPRB/)
KAO( :, 1, 7,13) = (/&
&4.0318E+00_JPRB,3.5414E+00_JPRB,3.1020E+00_JPRB,2.7107E+00_JPRB,2.3308E+00_JPRB,1.9686E+00_JPRB,&
&1.8437E+00_JPRB,2.0053E+00_JPRB,2.1966E+00_JPRB,2.2625E+00_JPRB,2.2876E+00_JPRB/)
KAO( :, 2, 7,13) = (/&
&3.9753E+00_JPRB,3.5219E+00_JPRB,3.0843E+00_JPRB,2.7586E+00_JPRB,2.3913E+00_JPRB,2.2135E+00_JPRB,&
&2.2792E+00_JPRB,2.6148E+00_JPRB,2.8647E+00_JPRB,2.9486E+00_JPRB,2.9838E+00_JPRB/)
KAO( :, 3, 7,13) = (/&
&3.9273E+00_JPRB,3.4958E+00_JPRB,3.1284E+00_JPRB,2.7893E+00_JPRB,2.5460E+00_JPRB,2.5637E+00_JPRB,&
&2.8433E+00_JPRB,3.3088E+00_JPRB,3.6254E+00_JPRB,3.7327E+00_JPRB,3.7756E+00_JPRB/)
KAO( :, 4, 7,13) = (/&
&3.8768E+00_JPRB,3.4612E+00_JPRB,3.1354E+00_JPRB,2.8419E+00_JPRB,2.8178E+00_JPRB,3.0023E+00_JPRB,&
&3.5065E+00_JPRB,4.0831E+00_JPRB,4.4749E+00_JPRB,4.6081E+00_JPRB,4.6607E+00_JPRB/)
KAO( :, 5, 7,13) = (/&
&3.8207E+00_JPRB,3.4295E+00_JPRB,3.1455E+00_JPRB,3.0110E+00_JPRB,3.1435E+00_JPRB,3.5518E+00_JPRB,&
&4.2303E+00_JPRB,4.9268E+00_JPRB,5.4004E+00_JPRB,5.5634E+00_JPRB,5.6245E+00_JPRB/)
KAO( :, 1, 8,13) = (/&
&4.5607E+00_JPRB,3.9914E+00_JPRB,3.4954E+00_JPRB,3.0029E+00_JPRB,2.5709E+00_JPRB,2.0712E+00_JPRB,&
&1.7381E+00_JPRB,1.7156E+00_JPRB,1.8751E+00_JPRB,1.9316E+00_JPRB,1.9534E+00_JPRB/)
KAO( :, 2, 8,13) = (/&
&4.5049E+00_JPRB,3.9749E+00_JPRB,3.4687E+00_JPRB,3.0674E+00_JPRB,2.6040E+00_JPRB,2.2247E+00_JPRB,&
&2.0925E+00_JPRB,2.2663E+00_JPRB,2.4833E+00_JPRB,2.5592E+00_JPRB,2.5867E+00_JPRB/)
KAO( :, 3, 8,13) = (/&
&4.4464E+00_JPRB,3.9470E+00_JPRB,3.5041E+00_JPRB,3.0976E+00_JPRB,2.6943E+00_JPRB,2.4990E+00_JPRB,&
&2.5535E+00_JPRB,2.9086E+00_JPRB,3.1877E+00_JPRB,3.2861E+00_JPRB,3.3201E+00_JPRB/)
KAO( :, 4, 8,13) = (/&
&4.3818E+00_JPRB,3.9082E+00_JPRB,3.5223E+00_JPRB,3.1240E+00_JPRB,2.8867E+00_JPRB,2.8624E+00_JPRB,&
&3.1305E+00_JPRB,3.6344E+00_JPRB,3.9841E+00_JPRB,4.1071E+00_JPRB,4.1503E+00_JPRB/)
KAO( :, 5, 8,13) = (/&
&4.3157E+00_JPRB,3.8635E+00_JPRB,3.5342E+00_JPRB,3.2389E+00_JPRB,3.1422E+00_JPRB,3.3087E+00_JPRB,&
&3.8133E+00_JPRB,4.4423E+00_JPRB,4.8694E+00_JPRB,5.0203E+00_JPRB,5.0730E+00_JPRB/)
KAO( :, 1, 9,13) = (/&
&5.1388E+00_JPRB,4.4967E+00_JPRB,3.9252E+00_JPRB,3.3415E+00_JPRB,2.8260E+00_JPRB,2.2549E+00_JPRB,&
&1.7301E+00_JPRB,1.4899E+00_JPRB,1.5781E+00_JPRB,1.6272E+00_JPRB,2.1902E+00_JPRB/)
KAO( :, 2, 9,13) = (/&
&5.0816E+00_JPRB,4.4676E+00_JPRB,3.8997E+00_JPRB,3.4081E+00_JPRB,2.8754E+00_JPRB,2.3488E+00_JPRB,&
&1.9883E+00_JPRB,1.9458E+00_JPRB,2.1210E+00_JPRB,2.1876E+00_JPRB,2.4675E+00_JPRB/)
KAO( :, 3, 9,13) = (/&
&5.0129E+00_JPRB,4.4339E+00_JPRB,3.9077E+00_JPRB,3.4536E+00_JPRB,2.9357E+00_JPRB,2.5363E+00_JPRB,&
&2.3438E+00_JPRB,2.5133E+00_JPRB,2.7551E+00_JPRB,2.8417E+00_JPRB,2.9456E+00_JPRB/)
KAO( :, 4, 9,13) = (/&
&4.9367E+00_JPRB,4.3927E+00_JPRB,3.9413E+00_JPRB,3.4799E+00_JPRB,3.0724E+00_JPRB,2.8062E+00_JPRB,&
&2.8193E+00_JPRB,3.1848E+00_JPRB,3.4916E+00_JPRB,3.6009E+00_JPRB,3.6428E+00_JPRB/)
KAO( :, 5, 9,13) = (/&
&4.8646E+00_JPRB,4.3466E+00_JPRB,3.9578E+00_JPRB,3.5604E+00_JPRB,3.2602E+00_JPRB,3.1715E+00_JPRB,&
&3.4132E+00_JPRB,3.9460E+00_JPRB,4.3263E+00_JPRB,4.4628E+00_JPRB,4.5130E+00_JPRB/)
KAO( :, 1,10,13) = (/&
&5.7351E+00_JPRB,5.0184E+00_JPRB,4.3590E+00_JPRB,3.7061E+00_JPRB,3.1107E+00_JPRB,2.4665E+00_JPRB,&
&1.8265E+00_JPRB,1.3589E+00_JPRB,1.3281E+00_JPRB,1.3706E+00_JPRB,9.6850E+00_JPRB/)
KAO( :, 2,10,13) = (/&
&5.6702E+00_JPRB,4.9713E+00_JPRB,4.3505E+00_JPRB,3.7771E+00_JPRB,3.1762E+00_JPRB,2.5499E+00_JPRB,&
&2.0068E+00_JPRB,1.7165E+00_JPRB,1.8132E+00_JPRB,1.8713E+00_JPRB,1.0044E+01_JPRB/)
KAO( :, 3,10,13) = (/&
&5.6012E+00_JPRB,4.9439E+00_JPRB,4.3471E+00_JPRB,3.8363E+00_JPRB,3.2324E+00_JPRB,2.7093E+00_JPRB,&
&2.2713E+00_JPRB,2.1992E+00_JPRB,2.3944E+00_JPRB,2.4708E+00_JPRB,1.0371E+01_JPRB/)
KAO( :, 4,10,13) = (/&
&5.5289E+00_JPRB,4.9007E+00_JPRB,4.3908E+00_JPRB,3.8627E+00_JPRB,3.3600E+00_JPRB,2.8996E+00_JPRB,&
&2.6404E+00_JPRB,2.8075E+00_JPRB,3.0779E+00_JPRB,3.1762E+00_JPRB,1.0595E+01_JPRB/)
KAO( :, 5,10,13) = (/&
&5.4567E+00_JPRB,4.8683E+00_JPRB,4.4123E+00_JPRB,3.9290E+00_JPRB,3.4997E+00_JPRB,3.1758E+00_JPRB,&
&3.1346E+00_JPRB,3.5190E+00_JPRB,3.8593E+00_JPRB,3.9826E+00_JPRB,1.0862E+01_JPRB/)
KAO( :, 1,11,13) = (/&
&6.3333E+00_JPRB,5.5418E+00_JPRB,4.8105E+00_JPRB,4.1265E+00_JPRB,3.4538E+00_JPRB,2.7288E+00_JPRB,&
&2.0255E+00_JPRB,1.4130E+00_JPRB,1.2863E+00_JPRB,1.3280E+00_JPRB,1.7958E+01_JPRB/)
KAO( :, 2,11,13) = (/&
&6.2689E+00_JPRB,5.5023E+00_JPRB,4.8148E+00_JPRB,4.2028E+00_JPRB,3.5226E+00_JPRB,2.8349E+00_JPRB,&
&2.1999E+00_JPRB,1.7269E+00_JPRB,1.7697E+00_JPRB,1.8270E+00_JPRB,1.8277E+01_JPRB/)
KAO( :, 3,11,13) = (/&
&6.2039E+00_JPRB,5.4744E+00_JPRB,4.8374E+00_JPRB,4.2598E+00_JPRB,3.5999E+00_JPRB,3.0009E+00_JPRB,&
&2.4146E+00_JPRB,2.1815E+00_JPRB,2.3423E+00_JPRB,2.4181E+00_JPRB,1.8696E+01_JPRB/)
KAO( :, 4,11,13) = (/&
&6.1388E+00_JPRB,5.4345E+00_JPRB,4.8963E+00_JPRB,4.2927E+00_JPRB,3.7367E+00_JPRB,3.1778E+00_JPRB,&
&2.7380E+00_JPRB,2.7546E+00_JPRB,3.0088E+00_JPRB,3.1059E+00_JPRB,1.9174E+01_JPRB/)
KAO( :, 5,11,13) = (/&
&6.0780E+00_JPRB,5.4134E+00_JPRB,4.9226E+00_JPRB,4.3897E+00_JPRB,3.8870E+00_JPRB,3.4157E+00_JPRB,&
&3.1673E+00_JPRB,3.4320E+00_JPRB,3.7647E+00_JPRB,3.8872E+00_JPRB,1.9497E+01_JPRB/)
KAO( :, 1,12,13) = (/&
&6.9733E+00_JPRB,6.1019E+00_JPRB,5.2948E+00_JPRB,4.5762E+00_JPRB,3.8194E+00_JPRB,3.0108E+00_JPRB,&
&2.2358E+00_JPRB,1.4812E+00_JPRB,1.2391E+00_JPRB,1.2773E+00_JPRB,2.4501E+01_JPRB/)
KAO( :, 2,12,13) = (/&
&6.9181E+00_JPRB,6.0812E+00_JPRB,5.3188E+00_JPRB,4.6589E+00_JPRB,3.8924E+00_JPRB,3.1398E+00_JPRB,&
&2.4112E+00_JPRB,1.7577E+00_JPRB,1.7083E+00_JPRB,1.7645E+00_JPRB,2.4773E+01_JPRB/)
KAO( :, 3,12,13) = (/&
&6.8566E+00_JPRB,6.0530E+00_JPRB,5.3874E+00_JPRB,4.7146E+00_JPRB,3.9882E+00_JPRB,3.3020E+00_JPRB,&
&2.6071E+00_JPRB,2.1662E+00_JPRB,2.2758E+00_JPRB,2.3503E+00_JPRB,2.5275E+01_JPRB/)
KAO( :, 4,12,13) = (/&
&6.7979E+00_JPRB,6.0149E+00_JPRB,5.4468E+00_JPRB,4.7610E+00_JPRB,4.1335E+00_JPRB,3.4795E+00_JPRB,&
&2.8840E+00_JPRB,2.7114E+00_JPRB,2.9349E+00_JPRB,3.0298E+00_JPRB,2.5870E+01_JPRB/)
KAO( :, 5,12,13) = (/&
&6.7411E+00_JPRB,6.0058E+00_JPRB,5.4709E+00_JPRB,4.8727E+00_JPRB,4.2890E+00_JPRB,3.6876E+00_JPRB,&
&3.2559E+00_JPRB,3.3514E+00_JPRB,3.6668E+00_JPRB,3.7859E+00_JPRB,2.6254E+01_JPRB/)
KAO( :, 1,13,13) = (/&
&7.6256E+00_JPRB,6.6753E+00_JPRB,5.7900E+00_JPRB,5.0347E+00_JPRB,4.1913E+00_JPRB,3.3018E+00_JPRB,&
&2.4527E+00_JPRB,1.5669E+00_JPRB,1.1934E+00_JPRB,1.2215E+00_JPRB,2.5519E+01_JPRB/)
KAO( :, 2,13,13) = (/&
&7.5682E+00_JPRB,6.6598E+00_JPRB,5.8333E+00_JPRB,5.1240E+00_JPRB,4.2715E+00_JPRB,3.4570E+00_JPRB,&
&2.6249E+00_JPRB,1.8136E+00_JPRB,1.6447E+00_JPRB,1.6979E+00_JPRB,2.5832E+01_JPRB/)
KAO( :, 3,13,13) = (/&
&7.5147E+00_JPRB,6.6337E+00_JPRB,5.9406E+00_JPRB,5.1772E+00_JPRB,4.3985E+00_JPRB,3.6181E+00_JPRB,&
&2.8202E+00_JPRB,2.1840E+00_JPRB,2.2018E+00_JPRB,2.2745E+00_JPRB,2.6512E+01_JPRB/)
KAO( :, 4,13,13) = (/&
&7.4664E+00_JPRB,6.6067E+00_JPRB,6.0077E+00_JPRB,5.2519E+00_JPRB,4.5469E+00_JPRB,3.7922E+00_JPRB,&
&3.0751E+00_JPRB,2.6716E+00_JPRB,2.8374E+00_JPRB,2.9314E+00_JPRB,2.7153E+01_JPRB/)
KAO( :, 5,13,13) = (/&
&7.4088E+00_JPRB,6.6207E+00_JPRB,6.0282E+00_JPRB,5.3739E+00_JPRB,4.7039E+00_JPRB,4.0017E+00_JPRB,&
&3.3998E+00_JPRB,3.2768E+00_JPRB,3.5575E+00_JPRB,3.6746E+00_JPRB,2.7529E+01_JPRB/)
KAO( :, 1, 1,14) = (/&
&2.8887E+00_JPRB,2.5952E+00_JPRB,2.4344E+00_JPRB,2.7140E+00_JPRB,3.5782E+00_JPRB,4.4490E+00_JPRB,&
&5.3193E+00_JPRB,6.1891E+00_JPRB,6.7728E+00_JPRB,6.9450E+00_JPRB,6.8281E+00_JPRB/)
KAO( :, 2, 1,14) = (/&
&2.8442E+00_JPRB,2.6117E+00_JPRB,2.5016E+00_JPRB,3.2440E+00_JPRB,4.2873E+00_JPRB,5.3316E+00_JPRB,&
&6.3758E+00_JPRB,7.4184E+00_JPRB,8.1189E+00_JPRB,8.3231E+00_JPRB,8.1685E+00_JPRB/)
KAO( :, 3, 1,14) = (/&
&2.8000E+00_JPRB,2.6157E+00_JPRB,2.7106E+00_JPRB,3.8144E+00_JPRB,5.0435E+00_JPRB,6.2737E+00_JPRB,&
&7.5035E+00_JPRB,8.7311E+00_JPRB,9.5570E+00_JPRB,9.7945E+00_JPRB,9.6021E+00_JPRB/)
KAO( :, 4, 1,14) = (/&
&2.7537E+00_JPRB,2.6124E+00_JPRB,3.0214E+00_JPRB,4.4121E+00_JPRB,5.8371E+00_JPRB,7.2628E+00_JPRB,&
&8.6899E+00_JPRB,1.0113E+01_JPRB,1.1069E+01_JPRB,1.1344E+01_JPRB,1.1112E+01_JPRB/)
KAO( :, 5, 1,14) = (/&
&2.7061E+00_JPRB,2.6132E+00_JPRB,3.3957E+00_JPRB,5.0168E+00_JPRB,6.6412E+00_JPRB,8.2665E+00_JPRB,&
&9.8911E+00_JPRB,1.1513E+01_JPRB,1.2604E+01_JPRB,1.2922E+01_JPRB,1.2679E+01_JPRB/)
KAO( :, 1, 2,14) = (/&
&3.0576E+00_JPRB,2.7352E+00_JPRB,2.5260E+00_JPRB,2.7828E+00_JPRB,3.6218E+00_JPRB,4.5046E+00_JPRB,&
&5.3876E+00_JPRB,6.2699E+00_JPRB,6.8610E+00_JPRB,7.0352E+00_JPRB,6.9906E+00_JPRB/)
KAO( :, 2, 2,14) = (/&
&3.0061E+00_JPRB,2.7324E+00_JPRB,2.6141E+00_JPRB,3.3196E+00_JPRB,4.3910E+00_JPRB,5.4630E+00_JPRB,&
&6.5356E+00_JPRB,7.6067E+00_JPRB,8.3258E+00_JPRB,8.5350E+00_JPRB,8.4749E+00_JPRB/)
KAO( :, 3, 2,14) = (/&
&2.9525E+00_JPRB,2.7255E+00_JPRB,2.8471E+00_JPRB,3.9327E+00_JPRB,5.2058E+00_JPRB,6.4796E+00_JPRB,&
&7.7532E+00_JPRB,9.0260E+00_JPRB,9.8805E+00_JPRB,1.0131E+01_JPRB,1.0067E+01_JPRB/)
KAO( :, 4, 2,14) = (/&
&2.8984E+00_JPRB,2.7145E+00_JPRB,3.1607E+00_JPRB,4.5565E+00_JPRB,6.0350E+00_JPRB,7.5142E+00_JPRB,&
&8.9933E+00_JPRB,1.0470E+01_JPRB,1.1465E+01_JPRB,1.1763E+01_JPRB,1.1703E+01_JPRB/)
KAO( :, 5, 2,14) = (/&
&2.8438E+00_JPRB,2.7189E+00_JPRB,3.5222E+00_JPRB,5.1840E+00_JPRB,6.8691E+00_JPRB,8.5548E+00_JPRB,&
&1.0241E+01_JPRB,1.1924E+01_JPRB,1.3058E+01_JPRB,1.3402E+01_JPRB,1.3350E+01_JPRB/)
KAO( :, 1, 3,14) = (/&
&3.2627E+00_JPRB,2.9257E+00_JPRB,2.6844E+00_JPRB,2.7974E+00_JPRB,3.4992E+00_JPRB,4.3540E+00_JPRB,&
&5.2086E+00_JPRB,6.0626E+00_JPRB,6.6362E+00_JPRB,6.8051E+00_JPRB,6.8438E+00_JPRB/)
KAO( :, 2, 3,14) = (/&
&3.2141E+00_JPRB,2.9285E+00_JPRB,2.7611E+00_JPRB,3.2879E+00_JPRB,4.2959E+00_JPRB,5.3479E+00_JPRB,&
&6.3996E+00_JPRB,7.4507E+00_JPRB,8.1567E+00_JPRB,8.3690E+00_JPRB,8.4216E+00_JPRB/)
KAO( :, 3, 3,14) = (/&
&3.1592E+00_JPRB,2.9193E+00_JPRB,2.9657E+00_JPRB,3.8707E+00_JPRB,5.1268E+00_JPRB,6.3848E+00_JPRB,&
&7.6422E+00_JPRB,8.8991E+00_JPRB,9.7445E+00_JPRB,1.0003E+01_JPRB,1.0068E+01_JPRB/)
KAO( :, 4, 3,14) = (/&
&3.1015E+00_JPRB,2.9015E+00_JPRB,3.2432E+00_JPRB,4.5116E+00_JPRB,5.9798E+00_JPRB,7.4486E+00_JPRB,&
&8.9182E+00_JPRB,1.0386E+01_JPRB,1.1375E+01_JPRB,1.1682E+01_JPRB,1.1760E+01_JPRB/)
KAO( :, 5, 3,14) = (/&
&3.0445E+00_JPRB,2.9022E+00_JPRB,3.5824E+00_JPRB,5.1608E+00_JPRB,6.8436E+00_JPRB,8.5264E+00_JPRB,&
&1.0210E+01_JPRB,1.1891E+01_JPRB,1.3025E+01_JPRB,1.3379E+01_JPRB,1.3473E+01_JPRB/)
KAO( :, 1, 4,14) = (/&
&3.5400E+00_JPRB,3.1664E+00_JPRB,2.9101E+00_JPRB,2.8758E+00_JPRB,3.3348E+00_JPRB,4.1525E+00_JPRB,&
&4.9718E+00_JPRB,5.7899E+00_JPRB,6.3397E+00_JPRB,6.5008E+00_JPRB,6.5768E+00_JPRB/)
KAO( :, 2, 4,14) = (/&
&3.4855E+00_JPRB,3.1790E+00_JPRB,2.9576E+00_JPRB,3.2747E+00_JPRB,4.1109E+00_JPRB,5.1228E+00_JPRB,&
&6.1348E+00_JPRB,7.1442E+00_JPRB,7.8249E+00_JPRB,8.0301E+00_JPRB,8.1227E+00_JPRB/)
KAO( :, 3, 4,14) = (/&
&3.4320E+00_JPRB,3.1719E+00_JPRB,3.1607E+00_JPRB,3.7785E+00_JPRB,4.9272E+00_JPRB,6.1416E+00_JPRB,&
&7.3563E+00_JPRB,8.5691E+00_JPRB,9.3880E+00_JPRB,9.6426E+00_JPRB,9.7500E+00_JPRB/)
KAO( :, 4, 4,14) = (/&
&3.3791E+00_JPRB,3.1599E+00_JPRB,3.3859E+00_JPRB,4.3631E+00_JPRB,5.7749E+00_JPRB,7.1988E+00_JPRB,&
&8.6228E+00_JPRB,1.0046E+01_JPRB,1.1007E+01_JPRB,1.1312E+01_JPRB,1.1439E+01_JPRB/)
KAO( :, 5, 4,14) = (/&
&3.3258E+00_JPRB,3.1591E+00_JPRB,3.6665E+00_JPRB,5.0052E+00_JPRB,6.6441E+00_JPRB,8.2840E+00_JPRB,&
&9.9242E+00_JPRB,1.1564E+01_JPRB,1.2671E+01_JPRB,1.3030E+01_JPRB,1.3170E+01_JPRB/)
KAO( :, 1, 5,14) = (/&
&3.8712E+00_JPRB,3.4337E+00_JPRB,3.1666E+00_JPRB,3.0128E+00_JPRB,3.2471E+00_JPRB,3.9337E+00_JPRB,&
&4.7121E+00_JPRB,5.4892E+00_JPRB,6.0120E+00_JPRB,6.1700E+00_JPRB,6.2549E+00_JPRB/)
KAO( :, 2, 5,14) = (/&
&3.8269E+00_JPRB,3.4694E+00_JPRB,3.1866E+00_JPRB,3.3432E+00_JPRB,3.9282E+00_JPRB,4.8845E+00_JPRB,&
&5.8524E+00_JPRB,6.8187E+00_JPRB,7.4706E+00_JPRB,7.6730E+00_JPRB,7.7736E+00_JPRB/)
KAO( :, 3, 5,14) = (/&
&3.7755E+00_JPRB,3.4748E+00_JPRB,3.3901E+00_JPRB,3.7632E+00_JPRB,4.7202E+00_JPRB,5.8870E+00_JPRB,&
&7.0546E+00_JPRB,8.2214E+00_JPRB,9.0082E+00_JPRB,9.2591E+00_JPRB,9.3759E+00_JPRB/)
KAO( :, 4, 5,14) = (/&
&3.7208E+00_JPRB,3.4667E+00_JPRB,3.6066E+00_JPRB,4.2692E+00_JPRB,5.5501E+00_JPRB,6.9232E+00_JPRB,&
&8.2967E+00_JPRB,9.6704E+00_JPRB,1.0598E+01_JPRB,1.0900E+01_JPRB,1.1032E+01_JPRB/)
KAO( :, 5, 5,14) = (/&
&3.6685E+00_JPRB,3.4626E+00_JPRB,3.8317E+00_JPRB,4.8383E+00_JPRB,6.4165E+00_JPRB,8.0063E+00_JPRB,&
&9.5964E+00_JPRB,1.1185E+01_JPRB,1.2259E+01_JPRB,1.2606E+01_JPRB,1.2759E+01_JPRB/)
KAO( :, 1, 6,14) = (/&
&4.2985E+00_JPRB,3.7747E+00_JPRB,3.4577E+00_JPRB,3.1550E+00_JPRB,3.2497E+00_JPRB,3.6558E+00_JPRB,&
&4.3601E+00_JPRB,5.0812E+00_JPRB,5.5670E+00_JPRB,5.7208E+00_JPRB,5.7987E+00_JPRB/)
KAO( :, 2, 6,14) = (/&
&4.2427E+00_JPRB,3.8123E+00_JPRB,3.4653E+00_JPRB,3.4897E+00_JPRB,3.8064E+00_JPRB,4.5507E+00_JPRB,&
&5.4535E+00_JPRB,6.3569E+00_JPRB,6.9669E+00_JPRB,7.1637E+00_JPRB,7.2558E+00_JPRB/)
KAO( :, 3, 6,14) = (/&
&4.1875E+00_JPRB,3.8273E+00_JPRB,3.6255E+00_JPRB,3.8306E+00_JPRB,4.4762E+00_JPRB,5.5205E+00_JPRB,&
&6.6168E+00_JPRB,7.7121E+00_JPRB,8.4537E+00_JPRB,8.6967E+00_JPRB,8.8046E+00_JPRB/)
KAO( :, 4, 6,14) = (/&
&4.1387E+00_JPRB,3.8237E+00_JPRB,3.8813E+00_JPRB,4.2503E+00_JPRB,5.2544E+00_JPRB,6.5579E+00_JPRB,&
&7.8608E+00_JPRB,9.1631E+00_JPRB,1.0044E+01_JPRB,1.0331E+01_JPRB,1.0461E+01_JPRB/)
KAO( :, 5, 6,14) = (/&
&4.0993E+00_JPRB,3.8210E+00_JPRB,4.0697E+00_JPRB,4.7381E+00_JPRB,6.1433E+00_JPRB,7.6683E+00_JPRB,&
&9.1923E+00_JPRB,1.0715E+01_JPRB,1.1746E+01_JPRB,1.2082E+01_JPRB,1.2233E+01_JPRB/)
KAO( :, 1, 7,14) = (/&
&4.8729E+00_JPRB,4.2640E+00_JPRB,3.8474E+00_JPRB,3.3679E+00_JPRB,3.3344E+00_JPRB,3.4772E+00_JPRB,&
&3.9641E+00_JPRB,4.6207E+00_JPRB,5.0642E+00_JPRB,5.2074E+00_JPRB,5.2771E+00_JPRB/)
KAO( :, 2, 7,14) = (/&
&4.7919E+00_JPRB,4.2473E+00_JPRB,3.8324E+00_JPRB,3.6623E+00_JPRB,3.7914E+00_JPRB,4.2248E+00_JPRB,&
&5.0116E+00_JPRB,5.8421E+00_JPRB,6.4042E+00_JPRB,6.5890E+00_JPRB,6.6727E+00_JPRB/)
KAO( :, 3, 7,14) = (/&
&4.7214E+00_JPRB,4.2557E+00_JPRB,3.9089E+00_JPRB,4.0054E+00_JPRB,4.3393E+00_JPRB,5.1382E+00_JPRB,&
&6.1595E+00_JPRB,7.1803E+00_JPRB,7.8713E+00_JPRB,8.0973E+00_JPRB,8.2014E+00_JPRB/)
KAO( :, 4, 7,14) = (/&
&4.6651E+00_JPRB,4.2593E+00_JPRB,4.1634E+00_JPRB,4.3388E+00_JPRB,5.0089E+00_JPRB,6.1843E+00_JPRB,&
&7.4141E+00_JPRB,8.6442E+00_JPRB,9.4748E+00_JPRB,9.7461E+00_JPRB,9.8717E+00_JPRB/)
KAO( :, 5, 7,14) = (/&
&4.6229E+00_JPRB,4.2611E+00_JPRB,4.3711E+00_JPRB,4.7337E+00_JPRB,5.8551E+00_JPRB,7.3079E+00_JPRB,&
&8.7620E+00_JPRB,1.0215E+01_JPRB,1.1197E+01_JPRB,1.1518E+01_JPRB,1.1668E+01_JPRB/)
KAO( :, 1, 8,14) = (/&
&5.5925E+00_JPRB,4.8936E+00_JPRB,4.3354E+00_JPRB,3.7383E+00_JPRB,3.4607E+00_JPRB,3.3817E+00_JPRB,&
&3.5604E+00_JPRB,4.1011E+00_JPRB,4.4961E+00_JPRB,4.6277E+00_JPRB,4.6848E+00_JPRB/)
KAO( :, 2, 8,14) = (/&
&5.4938E+00_JPRB,4.8247E+00_JPRB,4.3191E+00_JPRB,3.9163E+00_JPRB,3.8835E+00_JPRB,4.0306E+00_JPRB,&
&4.5806E+00_JPRB,5.3399E+00_JPRB,5.8538E+00_JPRB,6.0240E+00_JPRB,6.1006E+00_JPRB/)
KAO( :, 3, 8,14) = (/&
&5.4085E+00_JPRB,4.8212E+00_JPRB,4.3278E+00_JPRB,4.2425E+00_JPRB,4.3274E+00_JPRB,4.8175E+00_JPRB,&
&5.7136E+00_JPRB,6.6616E+00_JPRB,7.3038E+00_JPRB,7.5143E+00_JPRB,7.6111E+00_JPRB/)
KAO( :, 4, 8,14) = (/&
&5.3368E+00_JPRB,4.8168E+00_JPRB,4.5230E+00_JPRB,4.5538E+00_JPRB,4.8873E+00_JPRB,5.8090E+00_JPRB,&
&6.9627E+00_JPRB,8.1174E+00_JPRB,8.9008E+00_JPRB,9.1580E+00_JPRB,9.2752E+00_JPRB/)
KAO( :, 5, 8,14) = (/&
&5.2815E+00_JPRB,4.8169E+00_JPRB,4.7320E+00_JPRB,4.8661E+00_JPRB,5.6370E+00_JPRB,6.9370E+00_JPRB,&
&8.3184E+00_JPRB,9.6982E+00_JPRB,1.0633E+01_JPRB,1.0941E+01_JPRB,1.1084E+01_JPRB/)
KAO( :, 1, 9,14) = (/&
&6.4577E+00_JPRB,5.6507E+00_JPRB,4.9407E+00_JPRB,4.2286E+00_JPRB,3.7253E+00_JPRB,3.3779E+00_JPRB,&
&3.2319E+00_JPRB,3.5421E+00_JPRB,3.8831E+00_JPRB,3.9990E+00_JPRB,4.0498E+00_JPRB/)
KAO( :, 2, 9,14) = (/&
&6.3422E+00_JPRB,5.5498E+00_JPRB,4.9222E+00_JPRB,4.3098E+00_JPRB,4.0685E+00_JPRB,3.8931E+00_JPRB,&
&4.1244E+00_JPRB,4.7547E+00_JPRB,5.2133E+00_JPRB,5.3678E+00_JPRB,5.4322E+00_JPRB/)
KAO( :, 3, 9,14) = (/&
&6.2329E+00_JPRB,5.5111E+00_JPRB,4.9049E+00_JPRB,4.5899E+00_JPRB,4.4547E+00_JPRB,4.5979E+00_JPRB,&
&5.2352E+00_JPRB,6.1039E+00_JPRB,6.6924E+00_JPRB,6.8898E+00_JPRB,6.9747E+00_JPRB/)
KAO( :, 4, 9,14) = (/&
&6.1515E+00_JPRB,5.4910E+00_JPRB,5.0222E+00_JPRB,4.8653E+00_JPRB,4.9067E+00_JPRB,5.4882E+00_JPRB,&
&6.4831E+00_JPRB,7.5599E+00_JPRB,8.2895E+00_JPRB,8.5312E+00_JPRB,8.6396E+00_JPRB/)
KAO( :, 5, 9,14) = (/&
&6.0869E+00_JPRB,5.4865E+00_JPRB,5.2250E+00_JPRB,5.1325E+00_JPRB,5.5425E+00_JPRB,6.5444E+00_JPRB,&
&7.8337E+00_JPRB,9.1350E+00_JPRB,1.0015E+01_JPRB,1.0307E+01_JPRB,1.0438E+01_JPRB/)
KAO( :, 1,10,14) = (/&
&7.4443E+00_JPRB,6.5140E+00_JPRB,5.6562E+00_JPRB,4.8450E+00_JPRB,4.1266E+00_JPRB,3.5478E+00_JPRB,&
&3.0700E+00_JPRB,3.0881E+00_JPRB,3.3779E+00_JPRB,3.4799E+00_JPRB,1.2058E+01_JPRB/)
KAO( :, 2,10,14) = (/&
&7.3221E+00_JPRB,6.4071E+00_JPRB,5.6365E+00_JPRB,4.8644E+00_JPRB,4.3967E+00_JPRB,3.9545E+00_JPRB,&
&3.8217E+00_JPRB,4.2441E+00_JPRB,4.6539E+00_JPRB,4.7937E+00_JPRB,1.2410E+01_JPRB/)
KAO( :, 3,10,14) = (/&
&7.2124E+00_JPRB,6.3403E+00_JPRB,5.6271E+00_JPRB,5.0725E+00_JPRB,4.7313E+00_JPRB,4.4923E+00_JPRB,&
&4.8301E+00_JPRB,5.5719E+00_JPRB,6.1108E+00_JPRB,6.2952E+00_JPRB,1.2954E+01_JPRB/)
KAO( :, 4,10,14) = (/&
&7.1175E+00_JPRB,6.3123E+00_JPRB,5.6779E+00_JPRB,5.3374E+00_JPRB,5.0908E+00_JPRB,5.2975E+00_JPRB,&
&6.0440E+00_JPRB,7.0430E+00_JPRB,7.7247E+00_JPRB,7.9559E+00_JPRB,1.3387E+01_JPRB/)
KAO( :, 5,10,14) = (/&
&7.0366E+00_JPRB,6.2756E+00_JPRB,5.8648E+00_JPRB,5.5670E+00_JPRB,5.6360E+00_JPRB,6.2965E+00_JPRB,&
&7.4267E+00_JPRB,8.6602E+00_JPRB,9.4961E+00_JPRB,9.7792E+00_JPRB,1.3845E+01_JPRB/)
KAO( :, 1,11,14) = (/&
&8.4957E+00_JPRB,7.4339E+00_JPRB,6.4512E+00_JPRB,5.5185E+00_JPRB,4.7207E+00_JPRB,3.9718E+00_JPRB,&
&3.2916E+00_JPRB,3.1500E+00_JPRB,3.4253E+00_JPRB,3.5296E+00_JPRB,2.3513E+01_JPRB/)
KAO( :, 2,11,14) = (/&
&8.3816E+00_JPRB,7.3341E+00_JPRB,6.4276E+00_JPRB,5.6044E+00_JPRB,4.9602E+00_JPRB,4.3313E+00_JPRB,&
&3.9798E+00_JPRB,4.2912E+00_JPRB,4.7066E+00_JPRB,4.8505E+00_JPRB,2.3943E+01_JPRB/)
KAO( :, 3,11,14) = (/&
&8.2705E+00_JPRB,7.2767E+00_JPRB,6.4537E+00_JPRB,5.8081E+00_JPRB,5.2448E+00_JPRB,4.8172E+00_JPRB,&
&4.9716E+00_JPRB,5.6457E+00_JPRB,6.1916E+00_JPRB,6.3804E+00_JPRB,2.4436E+01_JPRB/)
KAO( :, 4,11,14) = (/&
&8.1691E+00_JPRB,7.2418E+00_JPRB,6.5336E+00_JPRB,6.0302E+00_JPRB,5.5871E+00_JPRB,5.5776E+00_JPRB,&
&6.1920E+00_JPRB,7.1803E+00_JPRB,7.8743E+00_JPRB,8.1125E+00_JPRB,2.5073E+01_JPRB/)
KAO( :, 5,11,14) = (/&
&8.0687E+00_JPRB,7.1847E+00_JPRB,6.6868E+00_JPRB,6.2347E+00_JPRB,6.0989E+00_JPRB,6.5755E+00_JPRB,&
&7.6314E+00_JPRB,8.8985E+00_JPRB,9.7576E+00_JPRB,1.0049E+01_JPRB,2.5623E+01_JPRB/)
KAO( :, 1,12,14) = (/&
&9.6896E+00_JPRB,8.4786E+00_JPRB,7.3560E+00_JPRB,6.2642E+00_JPRB,5.3896E+00_JPRB,4.4442E+00_JPRB,&
&3.5654E+00_JPRB,3.2232E+00_JPRB,3.4640E+00_JPRB,3.5704E+00_JPRB,3.3781E+01_JPRB/)
KAO( :, 2,12,14) = (/&
&9.5610E+00_JPRB,8.3661E+00_JPRB,7.3175E+00_JPRB,6.4413E+00_JPRB,5.6023E+00_JPRB,4.7562E+00_JPRB,&
&4.1907E+00_JPRB,4.3435E+00_JPRB,4.7515E+00_JPRB,4.8976E+00_JPRB,3.4305E+01_JPRB/)
KAO( :, 3,12,14) = (/&
&9.4357E+00_JPRB,8.3098E+00_JPRB,7.3390E+00_JPRB,6.6507E+00_JPRB,5.8481E+00_JPRB,5.2296E+00_JPRB,&
&5.1297E+00_JPRB,5.7060E+00_JPRB,6.2577E+00_JPRB,6.4493E+00_JPRB,3.4708E+01_JPRB/)
KAO( :, 4,12,14) = (/&
&9.3148E+00_JPRB,8.2568E+00_JPRB,7.4893E+00_JPRB,6.8212E+00_JPRB,6.1645E+00_JPRB,5.9310E+00_JPRB,&
&6.3510E+00_JPRB,7.2870E+00_JPRB,7.9920E+00_JPRB,8.2360E+00_JPRB,3.5460E+01_JPRB/)
KAO( :, 5,12,14) = (/&
&9.1990E+00_JPRB,8.1836E+00_JPRB,7.6152E+00_JPRB,6.9928E+00_JPRB,6.6719E+00_JPRB,6.9180E+00_JPRB,&
&7.8262E+00_JPRB,9.0973E+00_JPRB,9.9751E+00_JPRB,1.0276E+01_JPRB,3.6457E+01_JPRB/)
KAO( :, 1,13,14) = (/&
&1.0978E+01_JPRB,9.6060E+00_JPRB,8.3365E+00_JPRB,7.0935E+00_JPRB,6.1273E+00_JPRB,4.9756E+00_JPRB,&
&3.8881E+00_JPRB,3.3072E+00_JPRB,3.4820E+00_JPRB,3.5899E+00_JPRB,3.7314E+01_JPRB/)
KAO( :, 2,13,14) = (/&
&1.0837E+01_JPRB,9.4874E+00_JPRB,8.2842E+00_JPRB,7.3253E+00_JPRB,6.3404E+00_JPRB,5.2568E+00_JPRB,&
&4.4758E+00_JPRB,4.4007E+00_JPRB,4.7797E+00_JPRB,4.9274E+00_JPRB,3.7831E+01_JPRB/)
KAO( :, 3,13,14) = (/&
&1.0694E+01_JPRB,9.4274E+00_JPRB,8.2977E+00_JPRB,7.5668E+00_JPRB,6.5337E+00_JPRB,5.7124E+00_JPRB,&
&5.3511E+00_JPRB,5.7626E+00_JPRB,6.3147E+00_JPRB,6.5078E+00_JPRB,3.8270E+01_JPRB/)
KAO( :, 4,13,14) = (/&
&1.0553E+01_JPRB,9.3501E+00_JPRB,8.4789E+00_JPRB,7.6951E+00_JPRB,6.8488E+00_JPRB,6.3996E+00_JPRB,&
&6.5438E+00_JPRB,7.3994E+00_JPRB,8.1156E+00_JPRB,8.3624E+00_JPRB,3.9180E+01_JPRB/)
KAO( :, 5,13,14) = (/&
&1.0418E+01_JPRB,9.2624E+00_JPRB,8.6238E+00_JPRB,7.8509E+00_JPRB,7.3367E+00_JPRB,7.3271E+00_JPRB,&
&8.0317E+00_JPRB,9.2713E+00_JPRB,1.0168E+01_JPRB,1.0477E+01_JPRB,4.0242E+01_JPRB/)
KAO( :, 1, 1,15) = (/&
&3.4517E+00_JPRB,3.0397E+00_JPRB,4.3495E+00_JPRB,6.5195E+00_JPRB,8.6891E+00_JPRB,1.0859E+01_JPRB,&
&1.3028E+01_JPRB,1.5192E+01_JPRB,1.6642E+01_JPRB,1.7045E+01_JPRB,1.6592E+01_JPRB/)
KAO( :, 2, 1,15) = (/&
&3.3993E+00_JPRB,3.1455E+00_JPRB,5.0715E+00_JPRB,7.6013E+00_JPRB,1.0131E+01_JPRB,1.2660E+01_JPRB,&
&1.5190E+01_JPRB,1.7713E+01_JPRB,1.9405E+01_JPRB,1.9876E+01_JPRB,1.9373E+01_JPRB/)
KAO( :, 3, 1,15) = (/&
&3.3459E+00_JPRB,3.3075E+00_JPRB,5.7978E+00_JPRB,8.6893E+00_JPRB,1.1582E+01_JPRB,1.4472E+01_JPRB,&
&1.7361E+01_JPRB,2.0250E+01_JPRB,2.2182E+01_JPRB,2.2727E+01_JPRB,2.2178E+01_JPRB/)
KAO( :, 4, 1,15) = (/&
&3.2986E+00_JPRB,3.5290E+00_JPRB,6.5252E+00_JPRB,9.7768E+00_JPRB,1.3028E+01_JPRB,1.6279E+01_JPRB,&
&1.9527E+01_JPRB,2.2769E+01_JPRB,2.4943E+01_JPRB,2.5561E+01_JPRB,2.4969E+01_JPRB/)
KAO( :, 5, 1,15) = (/&
&3.2551E+00_JPRB,3.7853E+00_JPRB,7.2659E+00_JPRB,1.0883E+01_JPRB,1.4501E+01_JPRB,1.8116E+01_JPRB,&
&2.1727E+01_JPRB,2.5337E+01_JPRB,2.7748E+01_JPRB,2.8418E+01_JPRB,2.7723E+01_JPRB/)
KAO( :, 1, 2,15) = (/&
&3.6522E+00_JPRB,3.2711E+00_JPRB,4.5099E+00_JPRB,6.6968E+00_JPRB,8.9267E+00_JPRB,1.1156E+01_JPRB,&
&1.3385E+01_JPRB,1.5605E+01_JPRB,1.7100E+01_JPRB,1.7534E+01_JPRB,1.7404E+01_JPRB/)
KAO( :, 2, 2,15) = (/&
&3.6012E+00_JPRB,3.4064E+00_JPRB,5.2386E+00_JPRB,7.8494E+00_JPRB,1.0463E+01_JPRB,1.3076E+01_JPRB,&
&1.5688E+01_JPRB,1.8292E+01_JPRB,2.0045E+01_JPRB,2.0557E+01_JPRB,2.0412E+01_JPRB/)
KAO( :, 3, 2,15) = (/&
&3.5578E+00_JPRB,3.5847E+00_JPRB,6.0307E+00_JPRB,9.0357E+00_JPRB,1.2041E+01_JPRB,1.5045E+01_JPRB,&
&1.8047E+01_JPRB,2.1044E+01_JPRB,2.3057E+01_JPRB,2.3640E+01_JPRB,2.3465E+01_JPRB/)
KAO( :, 4, 2,15) = (/&
&3.5171E+00_JPRB,3.8136E+00_JPRB,6.8582E+00_JPRB,1.0272E+01_JPRB,1.3685E+01_JPRB,1.7098E+01_JPRB,&
&2.0508E+01_JPRB,2.3916E+01_JPRB,2.6198E+01_JPRB,2.6851E+01_JPRB,2.6618E+01_JPRB/)
KAO( :, 5, 2,15) = (/&
&3.4777E+00_JPRB,4.0744E+00_JPRB,7.7115E+00_JPRB,1.1547E+01_JPRB,1.5382E+01_JPRB,1.9216E+01_JPRB,&
&2.3048E+01_JPRB,2.6876E+01_JPRB,2.9437E+01_JPRB,3.0161E+01_JPRB,2.9874E+01_JPRB/)
KAO( :, 1, 3,15) = (/&
&4.0012E+00_JPRB,3.5438E+00_JPRB,4.5445E+00_JPRB,6.5121E+00_JPRB,8.6806E+00_JPRB,1.0848E+01_JPRB,&
&1.3016E+01_JPRB,1.5179E+01_JPRB,1.6635E+01_JPRB,1.7074E+01_JPRB,1.7180E+01_JPRB/)
KAO( :, 2, 3,15) = (/&
&3.9193E+00_JPRB,3.6637E+00_JPRB,5.2345E+00_JPRB,7.7505E+00_JPRB,1.0328E+01_JPRB,1.2905E+01_JPRB,&
&1.5480E+01_JPRB,1.8051E+01_JPRB,1.9781E+01_JPRB,2.0289E+01_JPRB,2.0415E+01_JPRB/)
KAO( :, 3, 3,15) = (/&
&3.8577E+00_JPRB,3.8234E+00_JPRB,6.0517E+00_JPRB,9.0644E+00_JPRB,1.2077E+01_JPRB,1.5089E+01_JPRB,&
&1.8099E+01_JPRB,2.1106E+01_JPRB,2.3127E+01_JPRB,2.3709E+01_JPRB,2.3850E+01_JPRB/)
KAO( :, 4, 3,15) = (/&
&3.8049E+00_JPRB,4.0468E+00_JPRB,6.9689E+00_JPRB,1.0436E+01_JPRB,1.3903E+01_JPRB,1.7370E+01_JPRB,&
&2.0836E+01_JPRB,2.4295E+01_JPRB,2.6620E+01_JPRB,2.7290E+01_JPRB,2.7443E+01_JPRB/)
KAO( :, 5, 3,15) = (/&
&3.7571E+00_JPRB,4.3042E+00_JPRB,7.9142E+00_JPRB,1.1851E+01_JPRB,1.5788E+01_JPRB,1.9723E+01_JPRB,&
&2.3657E+01_JPRB,2.7583E+01_JPRB,3.0223E+01_JPRB,3.0982E+01_JPRB,3.1151E+01_JPRB/)
KAO( :, 1, 4,15) = (/&
&4.5413E+00_JPRB,3.9760E+00_JPRB,4.5956E+00_JPRB,6.1749E+00_JPRB,8.2304E+00_JPRB,1.0286E+01_JPRB,&
&1.2342E+01_JPRB,1.4394E+01_JPRB,1.5775E+01_JPRB,1.6197E+01_JPRB,1.6378E+01_JPRB/)
KAO( :, 2, 4,15) = (/&
&4.4358E+00_JPRB,4.0500E+00_JPRB,5.2197E+00_JPRB,7.4879E+00_JPRB,9.9757E+00_JPRB,1.2463E+01_JPRB,&
&1.4950E+01_JPRB,1.7428E+01_JPRB,1.9103E+01_JPRB,1.9604E+01_JPRB,1.9831E+01_JPRB/)
KAO( :, 3, 4,15) = (/&
&4.3496E+00_JPRB,4.1500E+00_JPRB,5.9601E+00_JPRB,8.9065E+00_JPRB,1.1863E+01_JPRB,1.4820E+01_JPRB,&
&1.7774E+01_JPRB,2.0728E+01_JPRB,2.2708E+01_JPRB,2.3295E+01_JPRB,2.3568E+01_JPRB/)
KAO( :, 4, 4,15) = (/&
&4.2783E+00_JPRB,4.3259E+00_JPRB,6.9520E+00_JPRB,1.0406E+01_JPRB,1.3860E+01_JPRB,1.7313E+01_JPRB,&
&2.0763E+01_JPRB,2.4211E+01_JPRB,2.6527E+01_JPRB,2.7194E+01_JPRB,2.7525E+01_JPRB/)
KAO( :, 5, 4,15) = (/&
&4.2147E+00_JPRB,4.5565E+00_JPRB,7.9967E+00_JPRB,1.1967E+01_JPRB,1.5938E+01_JPRB,1.9911E+01_JPRB,&
&2.3877E+01_JPRB,2.7842E+01_JPRB,3.0498E+01_JPRB,3.1272E+01_JPRB,3.1647E+01_JPRB/)
KAO( :, 1, 5,15) = (/&
&5.1884E+00_JPRB,4.5403E+00_JPRB,4.7931E+00_JPRB,5.8956E+00_JPRB,7.7629E+00_JPRB,9.7012E+00_JPRB,&
&1.1639E+01_JPRB,1.3574E+01_JPRB,1.4878E+01_JPRB,1.5273E+01_JPRB,1.5485E+01_JPRB/)
KAO( :, 2, 5,15) = (/&
&5.0662E+00_JPRB,4.5450E+00_JPRB,5.3264E+00_JPRB,7.1969E+00_JPRB,9.5885E+00_JPRB,1.1980E+01_JPRB,&
&1.4371E+01_JPRB,1.6762E+01_JPRB,1.8366E+01_JPRB,1.8844E+01_JPRB,1.9112E+01_JPRB/)
KAO( :, 3, 5,15) = (/&
&4.9667E+00_JPRB,4.6362E+00_JPRB,5.9568E+00_JPRB,8.7016E+00_JPRB,1.1592E+01_JPRB,1.4482E+01_JPRB,&
&1.7370E+01_JPRB,2.0252E+01_JPRB,2.2194E+01_JPRB,2.2764E+01_JPRB,2.3092E+01_JPRB/)
KAO( :, 4, 5,15) = (/&
&4.8811E+00_JPRB,4.7581E+00_JPRB,6.8907E+00_JPRB,1.0315E+01_JPRB,1.3738E+01_JPRB,1.7164E+01_JPRB,&
&2.0588E+01_JPRB,2.4000E+01_JPRB,2.6296E+01_JPRB,2.6966E+01_JPRB,2.7352E+01_JPRB/)
KAO( :, 5, 5,15) = (/&
&4.8022E+00_JPRB,4.9436E+00_JPRB,8.0245E+00_JPRB,1.2011E+01_JPRB,1.5998E+01_JPRB,1.9984E+01_JPRB,&
&2.3970E+01_JPRB,2.7945E+01_JPRB,3.0615E+01_JPRB,3.1395E+01_JPRB,3.1854E+01_JPRB/)
KAO( :, 1, 6,15) = (/&
&5.9540E+00_JPRB,5.2101E+00_JPRB,5.1559E+00_JPRB,5.7766E+00_JPRB,7.2000E+00_JPRB,8.9966E+00_JPRB,&
&1.0790E+01_JPRB,1.2585E+01_JPRB,1.3788E+01_JPRB,1.4160E+01_JPRB,1.4369E+01_JPRB/)
KAO( :, 2, 6,15) = (/&
&5.8116E+00_JPRB,5.1177E+00_JPRB,5.5815E+00_JPRB,6.8585E+00_JPRB,9.1046E+00_JPRB,1.1376E+01_JPRB,&
&1.3646E+01_JPRB,1.5913E+01_JPRB,1.7437E+01_JPRB,1.7895E+01_JPRB,1.8166E+01_JPRB/)
KAO( :, 3, 6,15) = (/&
&5.6919E+00_JPRB,5.2252E+00_JPRB,6.1200E+00_JPRB,8.4234E+00_JPRB,1.1222E+01_JPRB,1.4022E+01_JPRB,&
&1.6819E+01_JPRB,1.9613E+01_JPRB,2.1489E+01_JPRB,2.2041E+01_JPRB,2.2387E+01_JPRB/)
KAO( :, 4, 6,15) = (/&
&5.5882E+00_JPRB,5.3197E+00_JPRB,6.8459E+00_JPRB,1.0145E+01_JPRB,1.3515E+01_JPRB,1.6884E+01_JPRB,&
&2.0253E+01_JPRB,2.3617E+01_JPRB,2.5877E+01_JPRB,2.6539E+01_JPRB,2.6957E+01_JPRB/)
KAO( :, 5, 6,15) = (/&
&5.4924E+00_JPRB,5.4609E+00_JPRB,7.9964E+00_JPRB,1.1974E+01_JPRB,1.5951E+01_JPRB,1.9927E+01_JPRB,&
&2.3903E+01_JPRB,2.7873E+01_JPRB,3.0539E+01_JPRB,3.1317E+01_JPRB,3.1808E+01_JPRB/)
KAO( :, 1, 7,15) = (/&
&6.8609E+00_JPRB,6.0036E+00_JPRB,5.6856E+00_JPRB,5.8569E+00_JPRB,6.6558E+00_JPRB,8.2325E+00_JPRB,&
&9.8779E+00_JPRB,1.1519E+01_JPRB,1.2625E+01_JPRB,1.2957E+01_JPRB,1.3161E+01_JPRB/)
KAO( :, 2, 7,15) = (/&
&6.6929E+00_JPRB,5.8566E+00_JPRB,5.9907E+00_JPRB,6.7106E+00_JPRB,8.5545E+00_JPRB,1.0689E+01_JPRB,&
&1.2823E+01_JPRB,1.4953E+01_JPRB,1.6388E+01_JPRB,1.6819E+01_JPRB,1.7084E+01_JPRB/)
KAO( :, 3, 7,15) = (/&
&6.5525E+00_JPRB,5.8774E+00_JPRB,6.4316E+00_JPRB,8.0973E+00_JPRB,1.0774E+01_JPRB,1.3461E+01_JPRB,&
&1.6147E+01_JPRB,1.8828E+01_JPRB,2.0635E+01_JPRB,2.1172E+01_JPRB,2.1511E+01_JPRB/)
KAO( :, 4, 7,15) = (/&
&6.4308E+00_JPRB,6.0200E+00_JPRB,7.0014E+00_JPRB,9.9118E+00_JPRB,1.3206E+01_JPRB,1.6500E+01_JPRB,&
&1.9791E+01_JPRB,2.3078E+01_JPRB,2.5291E+01_JPRB,2.5943E+01_JPRB,2.6365E+01_JPRB/)
KAO( :, 5, 7,15) = (/&
&6.3315E+00_JPRB,6.1156E+00_JPRB,7.9980E+00_JPRB,1.1868E+01_JPRB,1.5812E+01_JPRB,1.9756E+01_JPRB,&
&2.3696E+01_JPRB,2.7636E+01_JPRB,3.0283E+01_JPRB,3.1063E+01_JPRB,3.1573E+01_JPRB/)
KAO( :, 1, 8,15) = (/&
&7.8865E+00_JPRB,6.9009E+00_JPRB,6.2843E+00_JPRB,6.1316E+00_JPRB,6.3613E+00_JPRB,7.5584E+00_JPRB,&
&9.0686E+00_JPRB,1.0577E+01_JPRB,1.1592E+01_JPRB,1.1900E+01_JPRB,1.2089E+01_JPRB/)
KAO( :, 2, 8,15) = (/&
&7.6965E+00_JPRB,6.7347E+00_JPRB,6.5927E+00_JPRB,6.8053E+00_JPRB,7.9909E+00_JPRB,9.9438E+00_JPRB,&
&1.1929E+01_JPRB,1.3913E+01_JPRB,1.5248E+01_JPRB,1.5655E+01_JPRB,1.5901E+01_JPRB/)
KAO( :, 3, 8,15) = (/&
&7.5504E+00_JPRB,6.6675E+00_JPRB,6.9179E+00_JPRB,7.9162E+00_JPRB,1.0245E+01_JPRB,1.2802E+01_JPRB,&
&1.5357E+01_JPRB,1.7910E+01_JPRB,1.9627E+01_JPRB,2.0148E+01_JPRB,2.0469E+01_JPRB/)
KAO( :, 4, 8,15) = (/&
&7.4360E+00_JPRB,6.7883E+00_JPRB,7.3531E+00_JPRB,9.6152E+00_JPRB,1.2792E+01_JPRB,1.5983E+01_JPRB,&
&1.9172E+01_JPRB,2.2359E+01_JPRB,2.4505E+01_JPRB,2.5152E+01_JPRB,2.5554E+01_JPRB/)
KAO( :, 5, 8,15) = (/&
&7.3370E+00_JPRB,6.9240E+00_JPRB,8.1752E+00_JPRB,1.1669E+01_JPRB,1.5550E+01_JPRB,1.9429E+01_JPRB,&
&2.3306E+01_JPRB,2.7182E+01_JPRB,2.9790E+01_JPRB,3.0576E+01_JPRB,3.1067E+01_JPRB/)
KAO( :, 1, 9,15) = (/&
&9.0967E+00_JPRB,7.9598E+00_JPRB,6.9734E+00_JPRB,6.6246E+00_JPRB,6.3273E+00_JPRB,6.9836E+00_JPRB,&
&8.3234E+00_JPRB,9.7073E+00_JPRB,1.0640E+01_JPRB,1.0924E+01_JPRB,1.1099E+01_JPRB/)
KAO( :, 2, 9,15) = (/&
&8.8543E+00_JPRB,7.7477E+00_JPRB,7.2824E+00_JPRB,7.1264E+00_JPRB,7.6457E+00_JPRB,9.2650E+00_JPRB,&
&1.1116E+01_JPRB,1.2965E+01_JPRB,1.4208E+01_JPRB,1.4588E+01_JPRB,1.4820E+01_JPRB/)
KAO( :, 3, 9,15) = (/&
&8.7111E+00_JPRB,7.6297E+00_JPRB,7.5745E+00_JPRB,7.9608E+00_JPRB,9.6557E+00_JPRB,1.2050E+01_JPRB,&
&1.4456E+01_JPRB,1.6860E+01_JPRB,1.8477E+01_JPRB,1.8971E+01_JPRB,1.9271E+01_JPRB/)
KAO( :, 4, 9,15) = (/&
&8.5917E+00_JPRB,7.6924E+00_JPRB,7.9085E+00_JPRB,9.4305E+00_JPRB,1.2224E+01_JPRB,1.5276E+01_JPRB,&
&1.8326E+01_JPRB,2.1371E+01_JPRB,2.3421E+01_JPRB,2.4055E+01_JPRB,2.4428E+01_JPRB/)
KAO( :, 5, 9,15) = (/&
&8.4819E+00_JPRB,7.8606E+00_JPRB,8.5251E+00_JPRB,1.1371E+01_JPRB,1.5099E+01_JPRB,1.8867E+01_JPRB,&
&2.2635E+01_JPRB,2.6398E+01_JPRB,2.8934E+01_JPRB,2.9714E+01_JPRB,3.0176E+01_JPRB/)
KAO( :, 1,10,15) = (/&
&1.0579E+01_JPRB,9.2563E+00_JPRB,7.9515E+00_JPRB,7.2414E+00_JPRB,6.6262E+00_JPRB,6.7533E+00_JPRB,&
&7.7880E+00_JPRB,9.0842E+00_JPRB,9.9553E+00_JPRB,1.0226E+01_JPRB,1.4443E+01_JPRB/)
KAO( :, 2,10,15) = (/&
&1.0272E+01_JPRB,8.9883E+00_JPRB,8.0814E+00_JPRB,7.6749E+00_JPRB,7.6815E+00_JPRB,8.8308E+00_JPRB,&
&1.0573E+01_JPRB,1.2332E+01_JPRB,1.3516E+01_JPRB,1.3883E+01_JPRB,1.6088E+01_JPRB/)
KAO( :, 3,10,15) = (/&
&1.0064E+01_JPRB,8.8059E+00_JPRB,8.3682E+00_JPRB,8.3372E+00_JPRB,9.4460E+00_JPRB,1.1603E+01_JPRB,&
&1.3923E+01_JPRB,1.6236E+01_JPRB,1.7795E+01_JPRB,1.8275E+01_JPRB,1.8972E+01_JPRB/)
KAO( :, 4,10,15) = (/&
&9.9156E+00_JPRB,8.7771E+00_JPRB,8.6891E+00_JPRB,9.5568E+00_JPRB,1.1876E+01_JPRB,1.4833E+01_JPRB,&
&1.7796E+01_JPRB,2.0756E+01_JPRB,2.2749E+01_JPRB,2.3365E+01_JPRB,2.3730E+01_JPRB/)
KAO( :, 5,10,15) = (/&
&9.7815E+00_JPRB,8.9122E+00_JPRB,9.1420E+00_JPRB,1.1360E+01_JPRB,1.4761E+01_JPRB,1.8450E+01_JPRB,&
&2.2139E+01_JPRB,2.5815E+01_JPRB,2.8297E+01_JPRB,2.9069E+01_JPRB,2.9515E+01_JPRB/)
KAO( :, 1,11,15) = (/&
&1.2192E+01_JPRB,1.0668E+01_JPRB,9.1719E+00_JPRB,8.2095E+00_JPRB,7.4257E+00_JPRB,7.4696E+00_JPRB,&
&8.4517E+00_JPRB,9.8563E+00_JPRB,1.0806E+01_JPRB,1.1102E+01_JPRB,2.7700E+01_JPRB/)
KAO( :, 2,11,15) = (/&
&1.1855E+01_JPRB,1.0373E+01_JPRB,9.2641E+00_JPRB,8.5808E+00_JPRB,8.5516E+00_JPRB,9.6496E+00_JPRB,&
&1.1490E+01_JPRB,1.3402E+01_JPRB,1.4690E+01_JPRB,1.5091E+01_JPRB,2.8329E+01_JPRB/)
KAO( :, 3,11,15) = (/&
&1.1617E+01_JPRB,1.0165E+01_JPRB,9.4549E+00_JPRB,9.2771E+00_JPRB,1.0404E+01_JPRB,1.2597E+01_JPRB,&
&1.5113E+01_JPRB,1.7627E+01_JPRB,1.9321E+01_JPRB,1.9850E+01_JPRB,2.9277E+01_JPRB/)
KAO( :, 4,11,15) = (/&
&1.1419E+01_JPRB,1.0101E+01_JPRB,9.7647E+00_JPRB,1.0584E+01_JPRB,1.2914E+01_JPRB,1.6054E+01_JPRB,&
&1.9262E+01_JPRB,2.2467E+01_JPRB,2.4628E+01_JPRB,2.5304E+01_JPRB,3.1159E+01_JPRB/)
KAO( :, 5,11,15) = (/&
&1.1246E+01_JPRB,1.0208E+01_JPRB,1.0298E+01_JPRB,1.2412E+01_JPRB,1.5920E+01_JPRB,1.9895E+01_JPRB,&
&2.3870E+01_JPRB,2.7842E+01_JPRB,3.0521E+01_JPRB,3.1359E+01_JPRB,3.4867E+01_JPRB/)
KAO( :, 1,12,15) = (/&
&1.4055E+01_JPRB,1.2298E+01_JPRB,1.0584E+01_JPRB,9.3863E+00_JPRB,8.3528E+00_JPRB,8.2912E+00_JPRB,&
&9.1651E+00_JPRB,1.0659E+01_JPRB,1.1686E+01_JPRB,1.2009E+01_JPRB,4.0755E+01_JPRB/)
KAO( :, 2,12,15) = (/&
&1.3708E+01_JPRB,1.1994E+01_JPRB,1.0673E+01_JPRB,9.6215E+00_JPRB,9.5535E+00_JPRB,1.0572E+01_JPRB,&
&1.2442E+01_JPRB,1.4512E+01_JPRB,1.5909E+01_JPRB,1.6350E+01_JPRB,4.1783E+01_JPRB/)
KAO( :, 3,12,15) = (/&
&1.3432E+01_JPRB,1.1753E+01_JPRB,1.0809E+01_JPRB,1.0365E+01_JPRB,1.1475E+01_JPRB,1.3634E+01_JPRB,&
&1.6334E+01_JPRB,1.9052E+01_JPRB,2.0884E+01_JPRB,2.1465E+01_JPRB,4.2453E+01_JPRB/)
KAO( :, 4,12,15) = (/&
&1.3187E+01_JPRB,1.1665E+01_JPRB,1.0969E+01_JPRB,1.1758E+01_JPRB,1.4080E+01_JPRB,1.7299E+01_JPRB,&
&2.0755E+01_JPRB,2.4210E+01_JPRB,2.6541E+01_JPRB,2.7279E+01_JPRB,4.2992E+01_JPRB/)
KAO( :, 5,12,15) = (/&
&1.2971E+01_JPRB,1.1732E+01_JPRB,1.1607E+01_JPRB,1.3640E+01_JPRB,1.7148E+01_JPRB,2.1366E+01_JPRB,&
&2.5637E+01_JPRB,2.9905E+01_JPRB,3.2783E+01_JPRB,3.3705E+01_JPRB,4.4626E+01_JPRB/)
KAO( :, 1,13,15) = (/&
&1.6228E+01_JPRB,1.4199E+01_JPRB,1.2230E+01_JPRB,1.0748E+01_JPRB,9.4009E+00_JPRB,9.2214E+00_JPRB,&
&9.9389E+00_JPRB,1.1470E+01_JPRB,1.2574E+01_JPRB,1.2929E+01_JPRB,4.6698E+01_JPRB/)
KAO( :, 2,13,15) = (/&
&1.5839E+01_JPRB,1.3859E+01_JPRB,1.2304E+01_JPRB,1.0893E+01_JPRB,1.0661E+01_JPRB,1.1572E+01_JPRB,&
&1.3374E+01_JPRB,1.5600E+01_JPRB,1.7103E+01_JPRB,1.7585E+01_JPRB,4.7783E+01_JPRB/)
KAO( :, 3,13,15) = (/&
&1.5511E+01_JPRB,1.3574E+01_JPRB,1.2374E+01_JPRB,1.1617E+01_JPRB,1.2687E+01_JPRB,1.4735E+01_JPRB,&
&1.7515E+01_JPRB,2.0432E+01_JPRB,2.2399E+01_JPRB,2.3033E+01_JPRB,4.8488E+01_JPRB/)
KAO( :, 4,13,15) = (/&
&1.5222E+01_JPRB,1.3473E+01_JPRB,1.2471E+01_JPRB,1.3097E+01_JPRB,1.5327E+01_JPRB,1.8511E+01_JPRB,&
&2.2200E+01_JPRB,2.5897E+01_JPRB,2.8394E+01_JPRB,2.9197E+01_JPRB,4.9013E+01_JPRB/)
KAO( :, 5,13,15) = (/&
&1.4970E+01_JPRB,1.3493E+01_JPRB,1.3069E+01_JPRB,1.5022E+01_JPRB,1.8478E+01_JPRB,2.2815E+01_JPRB,&
&2.7375E+01_JPRB,3.1933E+01_JPRB,3.5007E+01_JPRB,3.5995E+01_JPRB,5.0755E+01_JPRB/)
KAO( :, 1, 1,16) = (/&
&3.6978E+00_JPRB,3.2359E+00_JPRB,5.8520E+00_JPRB,8.7722E+00_JPRB,1.1692E+01_JPRB,1.4611E+01_JPRB,&
&1.7529E+01_JPRB,2.0434E+01_JPRB,2.2353E+01_JPRB,2.2771E+01_JPRB,2.1591E+01_JPRB/)
KAO( :, 2, 1,16) = (/&
&3.6499E+00_JPRB,3.4722E+00_JPRB,6.9301E+00_JPRB,1.0388E+01_JPRB,1.3844E+01_JPRB,1.7300E+01_JPRB,&
&2.0752E+01_JPRB,2.4192E+01_JPRB,2.6475E+01_JPRB,2.6965E+01_JPRB,2.5577E+01_JPRB/)
KAO( :, 3, 1,16) = (/&
&3.5975E+00_JPRB,4.0332E+00_JPRB,8.0476E+00_JPRB,1.2062E+01_JPRB,1.6074E+01_JPRB,2.0086E+01_JPRB,&
&2.4094E+01_JPRB,2.8087E+01_JPRB,3.0726E+01_JPRB,3.1309E+01_JPRB,2.9700E+01_JPRB/)
KAO( :, 4, 1,16) = (/&
&3.5405E+00_JPRB,4.6049E+00_JPRB,9.1863E+00_JPRB,1.3767E+01_JPRB,1.8347E+01_JPRB,2.2925E+01_JPRB,&
&2.7499E+01_JPRB,3.2055E+01_JPRB,3.5076E+01_JPRB,3.5737E+01_JPRB,3.3906E+01_JPRB/)
KAO( :, 5, 1,16) = (/&
&3.4814E+00_JPRB,5.1822E+00_JPRB,1.0334E+01_JPRB,1.5485E+01_JPRB,2.0637E+01_JPRB,2.5785E+01_JPRB,&
&3.0929E+01_JPRB,3.6054E+01_JPRB,3.9459E+01_JPRB,4.0196E+01_JPRB,3.8155E+01_JPRB/)
KAO( :, 1, 2,16) = (/&
&4.0520E+00_JPRB,3.5458E+00_JPRB,6.5231E+00_JPRB,9.7790E+00_JPRB,1.3034E+01_JPRB,1.6288E+01_JPRB,&
&1.9539E+01_JPRB,2.2778E+01_JPRB,2.4923E+01_JPRB,2.5395E+01_JPRB,2.4752E+01_JPRB/)
KAO( :, 2, 2,16) = (/&
&3.9931E+00_JPRB,3.9027E+00_JPRB,7.7909E+00_JPRB,1.1679E+01_JPRB,1.5566E+01_JPRB,1.9451E+01_JPRB,&
&2.3333E+01_JPRB,2.7200E+01_JPRB,2.9762E+01_JPRB,3.0330E+01_JPRB,2.9565E+01_JPRB/)
KAO( :, 3, 2,16) = (/&
&3.9308E+00_JPRB,4.5630E+00_JPRB,9.1069E+00_JPRB,1.3651E+01_JPRB,1.8193E+01_JPRB,2.2734E+01_JPRB,&
&2.7271E+01_JPRB,3.1793E+01_JPRB,3.4788E+01_JPRB,3.5457E+01_JPRB,3.4565E+01_JPRB/)
KAO( :, 4, 2,16) = (/&
&3.8638E+00_JPRB,5.2409E+00_JPRB,1.0457E+01_JPRB,1.5672E+01_JPRB,2.0886E+01_JPRB,2.6099E+01_JPRB,&
&3.1306E+01_JPRB,3.6497E+01_JPRB,3.9942E+01_JPRB,4.0702E+01_JPRB,3.9688E+01_JPRB/)
KAO( :, 5, 2,16) = (/&
&3.7925E+00_JPRB,5.9258E+00_JPRB,1.1820E+01_JPRB,1.7713E+01_JPRB,2.3607E+01_JPRB,2.9498E+01_JPRB,&
&3.5387E+01_JPRB,4.1252E+01_JPRB,4.5136E+01_JPRB,4.6007E+01_JPRB,4.4885E+01_JPRB/)
KAO( :, 1, 3,16) = (/&
&4.4902E+00_JPRB,3.9291E+00_JPRB,6.9369E+00_JPRB,1.0400E+01_JPRB,1.3863E+01_JPRB,1.7324E+01_JPRB,&
&2.0784E+01_JPRB,2.4230E+01_JPRB,2.6510E+01_JPRB,2.7027E+01_JPRB,2.7042E+01_JPRB/)
KAO( :, 2, 3,16) = (/&
&4.4190E+00_JPRB,4.2063E+00_JPRB,8.3989E+00_JPRB,1.2591E+01_JPRB,1.6783E+01_JPRB,2.0972E+01_JPRB,&
&2.5161E+01_JPRB,2.9338E+01_JPRB,3.2094E+01_JPRB,3.2723E+01_JPRB,3.2745E+01_JPRB/)
KAO( :, 3, 3,16) = (/&
&4.3422E+00_JPRB,4.9746E+00_JPRB,9.9306E+00_JPRB,1.4886E+01_JPRB,1.9841E+01_JPRB,2.4793E+01_JPRB,&
&2.9742E+01_JPRB,3.4667E+01_JPRB,3.7936E+01_JPRB,3.8674E+01_JPRB,3.8715E+01_JPRB/)
KAO( :, 4, 3,16) = (/&
&4.2611E+00_JPRB,5.7667E+00_JPRB,1.1509E+01_JPRB,1.7250E+01_JPRB,2.2991E+01_JPRB,2.8729E+01_JPRB,&
&3.4468E+01_JPRB,4.0180E+01_JPRB,4.3962E+01_JPRB,4.4836E+01_JPRB,4.4863E+01_JPRB/)
KAO( :, 5, 3,16) = (/&
&4.1760E+00_JPRB,6.5736E+00_JPRB,1.3115E+01_JPRB,1.9656E+01_JPRB,2.6196E+01_JPRB,3.2733E+01_JPRB,&
&3.9264E+01_JPRB,4.5777E+01_JPRB,5.0083E+01_JPRB,5.1074E+01_JPRB,5.1136E+01_JPRB/)
KAO( :, 1, 4,16) = (/&
&5.0258E+00_JPRB,4.3977E+00_JPRB,7.1969E+00_JPRB,1.0791E+01_JPRB,1.4383E+01_JPRB,1.7975E+01_JPRB,&
&2.1569E+01_JPRB,2.5144E+01_JPRB,2.7520E+01_JPRB,2.8065E+01_JPRB,2.8444E+01_JPRB/)
KAO( :, 2, 4,16) = (/&
&4.9390E+00_JPRB,4.4372E+00_JPRB,8.8585E+00_JPRB,1.3281E+01_JPRB,1.7703E+01_JPRB,2.2123E+01_JPRB,&
&2.6539E+01_JPRB,3.0949E+01_JPRB,3.3856E+01_JPRB,3.4541E+01_JPRB,3.4994E+01_JPRB/)
KAO( :, 3, 4,16) = (/&
&4.8457E+00_JPRB,5.3158E+00_JPRB,1.0614E+01_JPRB,1.5912E+01_JPRB,2.1209E+01_JPRB,2.6503E+01_JPRB,&
&3.1793E+01_JPRB,3.7075E+01_JPRB,4.0567E+01_JPRB,4.1384E+01_JPRB,4.1940E+01_JPRB/)
KAO( :, 4, 4,16) = (/&
&4.7474E+00_JPRB,6.2334E+00_JPRB,1.2443E+01_JPRB,1.8652E+01_JPRB,2.4860E+01_JPRB,3.1065E+01_JPRB,&
&3.7265E+01_JPRB,4.3443E+01_JPRB,4.7539E+01_JPRB,4.8495E+01_JPRB,4.9142E+01_JPRB/)
KAO( :, 5, 4,16) = (/&
&4.6434E+00_JPRB,7.1705E+00_JPRB,1.4309E+01_JPRB,2.1448E+01_JPRB,2.8585E+01_JPRB,3.5719E+01_JPRB,&
&4.2858E+01_JPRB,4.9961E+01_JPRB,5.4666E+01_JPRB,5.5776E+01_JPRB,5.6532E+01_JPRB/)
KAO( :, 1, 5,16) = (/&
&5.9530E+00_JPRB,5.2090E+00_JPRB,7.3637E+00_JPRB,1.1041E+01_JPRB,1.4718E+01_JPRB,1.8396E+01_JPRB,&
&2.2069E+01_JPRB,2.5729E+01_JPRB,2.8163E+01_JPRB,2.8740E+01_JPRB,2.9269E+01_JPRB/)
KAO( :, 2, 5,16) = (/&
&5.7866E+00_JPRB,5.0634E+00_JPRB,9.2276E+00_JPRB,1.3835E+01_JPRB,1.8442E+01_JPRB,2.3049E+01_JPRB,&
&2.7650E+01_JPRB,3.2234E+01_JPRB,3.5276E+01_JPRB,3.5999E+01_JPRB,3.6669E+01_JPRB/)
KAO( :, 3, 5,16) = (/&
&5.6302E+00_JPRB,5.6178E+00_JPRB,1.1219E+01_JPRB,1.6821E+01_JPRB,2.2421E+01_JPRB,2.8019E+01_JPRB,&
&3.3616E+01_JPRB,3.9189E+01_JPRB,4.2893E+01_JPRB,4.3778E+01_JPRB,4.4575E+01_JPRB/)
KAO( :, 4, 5,16) = (/&
&5.4798E+00_JPRB,6.6656E+00_JPRB,1.3308E+01_JPRB,1.9950E+01_JPRB,2.6591E+01_JPRB,3.3229E+01_JPRB,&
&3.9862E+01_JPRB,4.6471E+01_JPRB,5.0866E+01_JPRB,5.1930E+01_JPRB,5.2869E+01_JPRB/)
KAO( :, 5, 5,16) = (/&
&5.3354E+00_JPRB,7.7467E+00_JPRB,1.5462E+01_JPRB,2.3177E+01_JPRB,3.0891E+01_JPRB,3.8601E+01_JPRB,&
&4.6304E+01_JPRB,5.3986E+01_JPRB,5.9081E+01_JPRB,6.0310E+01_JPRB,6.1426E+01_JPRB/)
KAO( :, 1, 6,16) = (/&
&7.2738E+00_JPRB,6.3646E+00_JPRB,7.3570E+00_JPRB,1.1032E+01_JPRB,1.4706E+01_JPRB,1.8378E+01_JPRB,&
&2.2046E+01_JPRB,2.5711E+01_JPRB,2.8141E+01_JPRB,2.8729E+01_JPRB,2.9318E+01_JPRB/)
KAO( :, 2, 6,16) = (/&
&7.0648E+00_JPRB,6.1818E+00_JPRB,9.4107E+00_JPRB,1.4112E+01_JPRB,1.8811E+01_JPRB,2.3508E+01_JPRB,&
&2.8203E+01_JPRB,3.2879E+01_JPRB,3.5997E+01_JPRB,3.6754E+01_JPRB,3.7506E+01_JPRB/)
KAO( :, 3, 6,16) = (/&
&6.8590E+00_JPRB,6.0610E+00_JPRB,1.1637E+01_JPRB,1.7447E+01_JPRB,2.3256E+01_JPRB,2.9066E+01_JPRB,&
&3.4869E+01_JPRB,4.0663E+01_JPRB,4.4507E+01_JPRB,4.5454E+01_JPRB,4.6382E+01_JPRB/)
KAO( :, 4, 6,16) = (/&
&6.6613E+00_JPRB,7.0109E+00_JPRB,1.4000E+01_JPRB,2.0989E+01_JPRB,2.7977E+01_JPRB,3.4961E+01_JPRB,&
&4.1942E+01_JPRB,4.8903E+01_JPRB,5.3535E+01_JPRB,5.4670E+01_JPRB,5.5779E+01_JPRB/)
KAO( :, 5, 6,16) = (/&
&6.4832E+00_JPRB,8.2415E+00_JPRB,1.6453E+01_JPRB,2.4664E+01_JPRB,3.2878E+01_JPRB,4.1086E+01_JPRB,&
&4.9286E+01_JPRB,5.7462E+01_JPRB,6.2904E+01_JPRB,6.4241E+01_JPRB,6.5559E+01_JPRB/)
KAO( :, 1, 7,16) = (/&
&8.8732E+00_JPRB,7.7641E+00_JPRB,7.2311E+00_JPRB,1.0833E+01_JPRB,1.4441E+01_JPRB,1.8048E+01_JPRB,&
&2.1653E+01_JPRB,2.5247E+01_JPRB,2.7641E+01_JPRB,2.8229E+01_JPRB,2.8832E+01_JPRB/)
KAO( :, 2, 7,16) = (/&
&8.6143E+00_JPRB,7.5376E+00_JPRB,9.4585E+00_JPRB,1.4183E+01_JPRB,1.8907E+01_JPRB,2.3629E+01_JPRB,&
&2.8346E+01_JPRB,3.3048E+01_JPRB,3.6188E+01_JPRB,3.6968E+01_JPRB,3.7763E+01_JPRB/)
KAO( :, 3, 7,16) = (/&
&8.3664E+00_JPRB,7.3209E+00_JPRB,1.1919E+01_JPRB,1.7872E+01_JPRB,2.3823E+01_JPRB,2.9773E+01_JPRB,&
&3.5718E+01_JPRB,4.1638E+01_JPRB,4.5593E+01_JPRB,4.6590E+01_JPRB,4.7567E+01_JPRB/)
KAO( :, 4, 7,16) = (/&
&8.1390E+00_JPRB,7.4468E+00_JPRB,1.4558E+01_JPRB,2.1826E+01_JPRB,2.9093E+01_JPRB,3.6357E+01_JPRB,&
&4.3619E+01_JPRB,5.0854E+01_JPRB,5.5680E+01_JPRB,5.6904E+01_JPRB,5.8098E+01_JPRB/)
KAO( :, 5, 7,16) = (/&
&7.9265E+00_JPRB,8.6774E+00_JPRB,1.7326E+01_JPRB,2.5975E+01_JPRB,3.4621E+01_JPRB,4.3265E+01_JPRB,&
&5.1911E+01_JPRB,6.0538E+01_JPRB,6.6258E+01_JPRB,6.7733E+01_JPRB,6.9141E+01_JPRB/)
KAO( :, 1, 8,16) = (/&
&1.0788E+01_JPRB,9.4395E+00_JPRB,8.0910E+00_JPRB,1.0487E+01_JPRB,1.3981E+01_JPRB,1.7474E+01_JPRB,&
&2.0958E+01_JPRB,2.4442E+01_JPRB,2.6758E+01_JPRB,2.7356E+01_JPRB,2.7940E+01_JPRB/)
KAO( :, 2, 8,16) = (/&
&1.0475E+01_JPRB,9.1659E+00_JPRB,9.3873E+00_JPRB,1.4077E+01_JPRB,1.8765E+01_JPRB,2.3452E+01_JPRB,&
&2.8149E+01_JPRB,3.2822E+01_JPRB,3.5937E+01_JPRB,3.6740E+01_JPRB,3.7513E+01_JPRB/)
KAO( :, 3, 8,16) = (/&
&1.0193E+01_JPRB,8.9191E+00_JPRB,1.2075E+01_JPRB,1.8106E+01_JPRB,2.4136E+01_JPRB,3.0164E+01_JPRB,&
&3.6189E+01_JPRB,4.2205E+01_JPRB,4.6208E+01_JPRB,4.7253E+01_JPRB,4.8244E+01_JPRB/)
KAO( :, 4, 8,16) = (/&
&9.9289E+00_JPRB,8.6882E+00_JPRB,1.4994E+01_JPRB,2.2482E+01_JPRB,2.9968E+01_JPRB,3.7453E+01_JPRB,&
&4.4932E+01_JPRB,5.2391E+01_JPRB,5.7371E+01_JPRB,5.8661E+01_JPRB,5.9909E+01_JPRB/)
KAO( :, 5, 8,16) = (/&
&9.6775E+00_JPRB,9.2158E+00_JPRB,1.8085E+01_JPRB,2.7113E+01_JPRB,3.6140E+01_JPRB,4.5163E+01_JPRB,&
&5.4184E+01_JPRB,6.3203E+01_JPRB,6.9206E+01_JPRB,7.0757E+01_JPRB,7.2247E+01_JPRB/)
KAO( :, 1, 9,16) = (/&
&1.3069E+01_JPRB,1.1436E+01_JPRB,9.8022E+00_JPRB,9.9694E+00_JPRB,1.3291E+01_JPRB,1.6611E+01_JPRB,&
&1.9930E+01_JPRB,2.3243E+01_JPRB,2.5447E+01_JPRB,2.6029E+01_JPRB,2.6580E+01_JPRB/)
KAO( :, 2, 9,16) = (/&
&1.2725E+01_JPRB,1.1134E+01_JPRB,9.8753E+00_JPRB,1.3769E+01_JPRB,1.8356E+01_JPRB,2.2942E+01_JPRB,&
&2.7527E+01_JPRB,3.2095E+01_JPRB,3.5151E+01_JPRB,3.5948E+01_JPRB,3.6707E+01_JPRB/)
KAO( :, 3, 9,16) = (/&
&1.2400E+01_JPRB,1.0851E+01_JPRB,1.2076E+01_JPRB,1.8109E+01_JPRB,2.4141E+01_JPRB,3.0170E+01_JPRB,&
&3.6196E+01_JPRB,4.2203E+01_JPRB,4.6216E+01_JPRB,4.7284E+01_JPRB,4.8252E+01_JPRB/)
KAO( :, 4, 9,16) = (/&
&1.2089E+01_JPRB,1.0578E+01_JPRB,1.5258E+01_JPRB,2.2878E+01_JPRB,3.0500E+01_JPRB,3.8117E+01_JPRB,&
&4.5731E+01_JPRB,5.3326E+01_JPRB,5.8402E+01_JPRB,5.9748E+01_JPRB,6.0995E+01_JPRB/)
KAO( :, 5, 9,16) = (/&
&1.1789E+01_JPRB,1.0434E+01_JPRB,1.8677E+01_JPRB,2.8005E+01_JPRB,3.7330E+01_JPRB,4.6652E+01_JPRB,&
&5.5969E+01_JPRB,6.5258E+01_JPRB,7.1468E+01_JPRB,7.3124E+01_JPRB,7.4629E+01_JPRB/)
KAO( :, 1,10,16) = (/&
&1.5771E+01_JPRB,1.3799E+01_JPRB,1.1828E+01_JPRB,1.0379E+01_JPRB,1.2776E+01_JPRB,1.5968E+01_JPRB,&
&1.9158E+01_JPRB,2.2340E+01_JPRB,2.4469E+01_JPRB,2.5039E+01_JPRB,2.5553E+01_JPRB/)
KAO( :, 2,10,16) = (/&
&1.5386E+01_JPRB,1.3463E+01_JPRB,1.1540E+01_JPRB,1.3590E+01_JPRB,1.8117E+01_JPRB,2.2643E+01_JPRB,&
&2.7166E+01_JPRB,3.1679E+01_JPRB,3.4682E+01_JPRB,3.5507E+01_JPRB,3.6231E+01_JPRB/)
KAO( :, 3,10,16) = (/&
&1.5014E+01_JPRB,1.3138E+01_JPRB,1.2638E+01_JPRB,1.8229E+01_JPRB,2.4305E+01_JPRB,3.0376E+01_JPRB,&
&3.6447E+01_JPRB,4.2507E+01_JPRB,4.6554E+01_JPRB,4.7660E+01_JPRB,4.8617E+01_JPRB/)
KAO( :, 4,10,16) = (/&
&1.4647E+01_JPRB,1.2816E+01_JPRB,1.5618E+01_JPRB,2.3419E+01_JPRB,3.1218E+01_JPRB,3.9016E+01_JPRB,&
&4.6807E+01_JPRB,5.4591E+01_JPRB,5.9795E+01_JPRB,6.1215E+01_JPRB,6.2420E+01_JPRB/)
KAO( :, 5,10,16) = (/&
&1.4280E+01_JPRB,1.2495E+01_JPRB,1.9355E+01_JPRB,2.9020E+01_JPRB,3.8692E+01_JPRB,4.8365E+01_JPRB,&
&5.8042E+01_JPRB,6.7684E+01_JPRB,7.4123E+01_JPRB,7.5902E+01_JPRB,7.7369E+01_JPRB/)
KAO( :, 1,11,16) = (/&
&1.8786E+01_JPRB,1.6438E+01_JPRB,1.4090E+01_JPRB,1.2331E+01_JPRB,1.4530E+01_JPRB,1.8160E+01_JPRB,&
&2.1788E+01_JPRB,2.5406E+01_JPRB,2.7840E+01_JPRB,2.8505E+01_JPRB,3.1090E+01_JPRB/)
KAO( :, 2,11,16) = (/&
&1.8352E+01_JPRB,1.6058E+01_JPRB,1.3764E+01_JPRB,1.5493E+01_JPRB,2.0554E+01_JPRB,2.5688E+01_JPRB,&
&3.0819E+01_JPRB,3.5940E+01_JPRB,3.9370E+01_JPRB,4.0314E+01_JPRB,4.1103E+01_JPRB/)
KAO( :, 3,11,16) = (/&
&1.7913E+01_JPRB,1.5674E+01_JPRB,1.4890E+01_JPRB,2.0637E+01_JPRB,2.7511E+01_JPRB,3.4389E+01_JPRB,&
&4.1261E+01_JPRB,4.8114E+01_JPRB,5.2700E+01_JPRB,5.3986E+01_JPRB,5.5030E+01_JPRB/)
KAO( :, 4,11,16) = (/&
&1.7463E+01_JPRB,1.5280E+01_JPRB,1.7784E+01_JPRB,2.6445E+01_JPRB,3.5253E+01_JPRB,4.4066E+01_JPRB,&
&5.2867E+01_JPRB,6.1654E+01_JPRB,6.7542E+01_JPRB,6.9213E+01_JPRB,7.0519E+01_JPRB/)
KAO( :, 5,11,16) = (/&
&1.7011E+01_JPRB,1.4885E+01_JPRB,2.1813E+01_JPRB,3.2706E+01_JPRB,4.3599E+01_JPRB,5.4495E+01_JPRB,&
&6.5377E+01_JPRB,7.6235E+01_JPRB,8.3536E+01_JPRB,8.5586E+01_JPRB,8.7197E+01_JPRB/)
KAO( :, 1,12,16) = (/&
&2.2316E+01_JPRB,1.9527E+01_JPRB,1.6737E+01_JPRB,1.4596E+01_JPRB,1.6461E+01_JPRB,2.0474E+01_JPRB,&
&2.4566E+01_JPRB,2.8661E+01_JPRB,3.1410E+01_JPRB,3.2180E+01_JPRB,4.4855E+01_JPRB/)
KAO( :, 2,12,16) = (/&
&2.1794E+01_JPRB,1.9070E+01_JPRB,1.6346E+01_JPRB,1.7861E+01_JPRB,2.3106E+01_JPRB,2.8879E+01_JPRB,&
&3.4647E+01_JPRB,4.0407E+01_JPRB,4.4277E+01_JPRB,4.5382E+01_JPRB,4.9760E+01_JPRB/)
KAO( :, 3,12,16) = (/&
&2.1250E+01_JPRB,1.8594E+01_JPRB,1.7508E+01_JPRB,2.3135E+01_JPRB,3.0842E+01_JPRB,3.8557E+01_JPRB,&
&4.6258E+01_JPRB,5.3944E+01_JPRB,5.9113E+01_JPRB,6.0595E+01_JPRB,6.2174E+01_JPRB/)
KAO( :, 4,12,16) = (/&
&2.0691E+01_JPRB,1.8105E+01_JPRB,2.0448E+01_JPRB,2.9564E+01_JPRB,3.9416E+01_JPRB,4.9267E+01_JPRB,&
&5.9115E+01_JPRB,6.8938E+01_JPRB,7.5537E+01_JPRB,7.7449E+01_JPRB,7.8830E+01_JPRB/)
KAO( :, 5,12,16) = (/&
&2.0116E+01_JPRB,1.7618E+01_JPRB,2.4414E+01_JPRB,3.6468E+01_JPRB,4.8613E+01_JPRB,6.0754E+01_JPRB,&
&7.2909E+01_JPRB,8.5015E+01_JPRB,9.3174E+01_JPRB,9.5539E+01_JPRB,9.7222E+01_JPRB/)
KAO( :, 1,13,16) = (/&
&2.6369E+01_JPRB,2.3073E+01_JPRB,1.9777E+01_JPRB,1.7264E+01_JPRB,1.8821E+01_JPRB,2.2830E+01_JPRB,&
&2.7390E+01_JPRB,3.1940E+01_JPRB,3.5002E+01_JPRB,3.5903E+01_JPRB,5.1967E+01_JPRB/)
KAO( :, 2,13,16) = (/&
&2.5711E+01_JPRB,2.2497E+01_JPRB,1.9315E+01_JPRB,2.0637E+01_JPRB,2.5666E+01_JPRB,3.2078E+01_JPRB,&
&3.8490E+01_JPRB,4.4893E+01_JPRB,4.9192E+01_JPRB,5.0468E+01_JPRB,5.7721E+01_JPRB/)
KAO( :, 3,13,16) = (/&
&2.5020E+01_JPRB,2.1893E+01_JPRB,2.0597E+01_JPRB,2.5898E+01_JPRB,3.4157E+01_JPRB,4.2689E+01_JPRB,&
&5.1216E+01_JPRB,5.9737E+01_JPRB,6.5448E+01_JPRB,6.7176E+01_JPRB,7.0449E+01_JPRB/)
KAO( :, 4,13,16) = (/&
&2.4297E+01_JPRB,2.1260E+01_JPRB,2.3512E+01_JPRB,3.2642E+01_JPRB,4.3514E+01_JPRB,5.4385E+01_JPRB,&
&6.5247E+01_JPRB,7.6086E+01_JPRB,8.3406E+01_JPRB,8.5607E+01_JPRB,8.7331E+01_JPRB/)
KAO( :, 5,13,16) = (/&
&2.3576E+01_JPRB,2.0739E+01_JPRB,2.7492E+01_JPRB,4.0149E+01_JPRB,5.3519E+01_JPRB,6.6886E+01_JPRB,&
&8.0252E+01_JPRB,9.3599E+01_JPRB,1.0259E+02_JPRB,1.0529E+02_JPRB,1.0701E+02_JPRB/)


!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

KBO( :,13, 1) = (/&
&4.0994E-03_JPRB,5.0728E-03_JPRB,6.1420E-03_JPRB,7.2969E-03_JPRB,8.5215E-03_JPRB/)
KBO( :,14, 1) = (/&
&3.5608E-03_JPRB,4.4025E-03_JPRB,5.3259E-03_JPRB,6.3236E-03_JPRB,7.3838E-03_JPRB/)
KBO( :,15, 1) = (/&
&3.1441E-03_JPRB,3.8833E-03_JPRB,4.6911E-03_JPRB,5.5651E-03_JPRB,6.4864E-03_JPRB/)
KBO( :,16, 1) = (/&
&2.7804E-03_JPRB,3.4263E-03_JPRB,4.1318E-03_JPRB,4.8903E-03_JPRB,5.6839E-03_JPRB/)
KBO( :,17, 1) = (/&
&2.5177E-03_JPRB,3.0931E-03_JPRB,3.7229E-03_JPRB,4.3958E-03_JPRB,5.0932E-03_JPRB/)
KBO( :,18, 1) = (/&
&2.3397E-03_JPRB,2.8662E-03_JPRB,3.4383E-03_JPRB,4.0476E-03_JPRB,4.6762E-03_JPRB/)
KBO( :,19, 1) = (/&
&2.2067E-03_JPRB,2.6944E-03_JPRB,3.2196E-03_JPRB,3.7730E-03_JPRB,4.3369E-03_JPRB/)
KBO( :,20, 1) = (/&
&1.9900E-03_JPRB,2.4229E-03_JPRB,2.8861E-03_JPRB,3.3669E-03_JPRB,3.8498E-03_JPRB/)
KBO( :,21, 1) = (/&
&1.7699E-03_JPRB,2.1476E-03_JPRB,2.5489E-03_JPRB,2.9591E-03_JPRB,3.3696E-03_JPRB/)
KBO( :,22, 1) = (/&
&1.5791E-03_JPRB,1.9073E-03_JPRB,2.2490E-03_JPRB,2.5953E-03_JPRB,2.9423E-03_JPRB/)
KBO( :,23, 1) = (/&
&1.4083E-03_JPRB,1.6913E-03_JPRB,1.9813E-03_JPRB,2.2728E-03_JPRB,2.5656E-03_JPRB/)
KBO( :,24, 1) = (/&
&1.2531E-03_JPRB,1.4945E-03_JPRB,1.7386E-03_JPRB,1.9824E-03_JPRB,2.2278E-03_JPRB/)
KBO( :,25, 1) = (/&
&1.1116E-03_JPRB,1.3151E-03_JPRB,1.5192E-03_JPRB,1.7227E-03_JPRB,1.9286E-03_JPRB/)
KBO( :,26, 1) = (/&
&9.8108E-04_JPRB,1.1510E-03_JPRB,1.3208E-03_JPRB,1.4915E-03_JPRB,1.6636E-03_JPRB/)
KBO( :,27, 1) = (/&
&8.5741E-04_JPRB,9.9814E-04_JPRB,1.1394E-03_JPRB,1.2818E-03_JPRB,1.4244E-03_JPRB/)
KBO( :,28, 1) = (/&
&7.4362E-04_JPRB,8.5993E-04_JPRB,9.7672E-04_JPRB,1.0942E-03_JPRB,1.2112E-03_JPRB/)
KBO( :,29, 1) = (/&
&6.4173E-04_JPRB,7.3787E-04_JPRB,8.3430E-04_JPRB,9.3077E-04_JPRB,1.0275E-03_JPRB/)
KBO( :,30, 1) = (/&
&5.5206E-04_JPRB,6.3117E-04_JPRB,7.1043E-04_JPRB,7.8981E-04_JPRB,8.6914E-04_JPRB/)
KBO( :,31, 1) = (/&
&4.7282E-04_JPRB,5.3772E-04_JPRB,6.0295E-04_JPRB,6.6810E-04_JPRB,7.3341E-04_JPRB/)
KBO( :,32, 1) = (/&
&4.0428E-04_JPRB,4.5779E-04_JPRB,5.1149E-04_JPRB,5.6525E-04_JPRB,6.1880E-04_JPRB/)
KBO( :,33, 1) = (/&
&3.4491E-04_JPRB,3.8913E-04_JPRB,4.3344E-04_JPRB,4.7736E-04_JPRB,5.2088E-04_JPRB/)
KBO( :,34, 1) = (/&
&2.9576E-04_JPRB,3.3268E-04_JPRB,3.6928E-04_JPRB,4.0567E-04_JPRB,4.4172E-04_JPRB/)
KBO( :,35, 1) = (/&
&2.5077E-04_JPRB,2.8136E-04_JPRB,3.1174E-04_JPRB,3.4190E-04_JPRB,3.7190E-04_JPRB/)
KBO( :,36, 1) = (/&
&2.0965E-04_JPRB,2.3515E-04_JPRB,2.6041E-04_JPRB,2.8542E-04_JPRB,3.1056E-04_JPRB/)
KBO( :,37, 1) = (/&
&1.6881E-04_JPRB,1.8974E-04_JPRB,2.1051E-04_JPRB,2.3106E-04_JPRB,2.5174E-04_JPRB/)
KBO( :,38, 1) = (/&
&1.3519E-04_JPRB,1.5238E-04_JPRB,1.6942E-04_JPRB,1.8630E-04_JPRB,2.0323E-04_JPRB/)
KBO( :,39, 1) = (/&
&1.0769E-04_JPRB,1.2175E-04_JPRB,1.3571E-04_JPRB,1.4957E-04_JPRB,1.6341E-04_JPRB/)
KBO( :,40, 1) = (/&
&8.3659E-05_JPRB,9.4997E-05_JPRB,1.0624E-04_JPRB,1.1742E-04_JPRB,1.2854E-04_JPRB/)
KBO( :,41, 1) = (/&
&6.4553E-05_JPRB,7.3658E-05_JPRB,8.2687E-05_JPRB,9.1644E-05_JPRB,1.0055E-04_JPRB/)
KBO( :,42, 1) = (/&
&4.9559E-05_JPRB,5.6844E-05_JPRB,6.4074E-05_JPRB,7.1250E-05_JPRB,7.8380E-05_JPRB/)
KBO( :,43, 1) = (/&
&3.7325E-05_JPRB,4.3138E-05_JPRB,4.8889E-05_JPRB,5.4599E-05_JPRB,6.0264E-05_JPRB/)
KBO( :,44, 1) = (/&
&2.7719E-05_JPRB,3.2330E-05_JPRB,3.6894E-05_JPRB,4.1410E-05_JPRB,4.5899E-05_JPRB/)
KBO( :,45, 1) = (/&
&2.0321E-05_JPRB,2.3995E-05_JPRB,2.7586E-05_JPRB,3.1159E-05_JPRB,3.4704E-05_JPRB/)
KBO( :,46, 1) = (/&
&1.4684E-05_JPRB,1.7602E-05_JPRB,2.0438E-05_JPRB,2.3255E-05_JPRB,2.6055E-05_JPRB/)
KBO( :,47, 1) = (/&
&1.0495E-05_JPRB,1.2761E-05_JPRB,1.5036E-05_JPRB,1.7255E-05_JPRB,1.9472E-05_JPRB/)
KBO( :,48, 1) = (/&
&7.3772E-06_JPRB,9.1061E-06_JPRB,1.0897E-05_JPRB,1.2655E-05_JPRB,1.4395E-05_JPRB/)
KBO( :,49, 1) = (/&
&5.0673E-06_JPRB,6.3724E-06_JPRB,7.7347E-06_JPRB,9.1249E-06_JPRB,1.0486E-05_JPRB/)
KBO( :,50, 1) = (/&
&3.5302E-06_JPRB,4.5180E-06_JPRB,5.5663E-06_JPRB,6.6492E-06_JPRB,7.7336E-06_JPRB/)
KBO( :,51, 1) = (/&
&2.4650E-06_JPRB,3.2117E-06_JPRB,4.0196E-06_JPRB,4.8590E-06_JPRB,5.7209E-06_JPRB/)
KBO( :,52, 1) = (/&
&1.6959E-06_JPRB,2.2491E-06_JPRB,2.8606E-06_JPRB,3.5081E-06_JPRB,4.1772E-06_JPRB/)
KBO( :,53, 1) = (/&
&1.1461E-06_JPRB,1.5466E-06_JPRB,1.9999E-06_JPRB,2.4909E-06_JPRB,3.0024E-06_JPRB/)
KBO( :,54, 1) = (/&
&8.1277E-07_JPRB,1.1151E-06_JPRB,1.4623E-06_JPRB,1.8438E-06_JPRB,2.2473E-06_JPRB/)
KBO( :,55, 1) = (/&
&5.9132E-07_JPRB,8.2491E-07_JPRB,1.0964E-06_JPRB,1.3990E-06_JPRB,1.7223E-06_JPRB/)
KBO( :,56, 1) = (/&
&4.2770E-07_JPRB,6.0720E-07_JPRB,8.1863E-07_JPRB,1.0577E-06_JPRB,1.3158E-06_JPRB/)
KBO( :,57, 1) = (/&
&3.0731E-07_JPRB,4.4442E-07_JPRB,6.0841E-07_JPRB,7.9635E-07_JPRB,1.0017E-06_JPRB/)
KBO( :,58, 1) = (/&
&2.2286E-07_JPRB,3.2839E-07_JPRB,4.5650E-07_JPRB,6.0508E-07_JPRB,7.6969E-07_JPRB/)
KBO( :,59, 1) = (/&
&1.8935E-07_JPRB,2.8208E-07_JPRB,3.9434E-07_JPRB,5.2454E-07_JPRB,6.6793E-07_JPRB/)
KBO( :,13, 2) = (/&
&2.0350E-02_JPRB,2.3737E-02_JPRB,2.7056E-02_JPRB,3.0424E-02_JPRB,3.3880E-02_JPRB/)
KBO( :,14, 2) = (/&
&1.7887E-02_JPRB,2.0698E-02_JPRB,2.3474E-02_JPRB,2.6314E-02_JPRB,2.9218E-02_JPRB/)
KBO( :,15, 2) = (/&
&1.5699E-02_JPRB,1.8063E-02_JPRB,2.0419E-02_JPRB,2.2807E-02_JPRB,2.5263E-02_JPRB/)
KBO( :,16, 2) = (/&
&1.3704E-02_JPRB,1.5696E-02_JPRB,1.7682E-02_JPRB,1.9683E-02_JPRB,2.1758E-02_JPRB/)
KBO( :,17, 2) = (/&
&1.2174E-02_JPRB,1.3873E-02_JPRB,1.5565E-02_JPRB,1.7279E-02_JPRB,1.9055E-02_JPRB/)
KBO( :,18, 2) = (/&
&1.1051E-02_JPRB,1.2529E-02_JPRB,1.4014E-02_JPRB,1.5532E-02_JPRB,1.7091E-02_JPRB/)
KBO( :,19, 2) = (/&
&1.0133E-02_JPRB,1.1442E-02_JPRB,1.2772E-02_JPRB,1.4145E-02_JPRB,1.5532E-02_JPRB/)
KBO( :,20, 2) = (/&
&8.9501E-03_JPRB,1.0074E-02_JPRB,1.1232E-02_JPRB,1.2420E-02_JPRB,1.3612E-02_JPRB/)
KBO( :,21, 2) = (/&
&7.8061E-03_JPRB,8.7666E-03_JPRB,9.7638E-03_JPRB,1.0776E-02_JPRB,1.1786E-02_JPRB/)
KBO( :,22, 2) = (/&
&6.7985E-03_JPRB,7.6154E-03_JPRB,8.4665E-03_JPRB,9.3161E-03_JPRB,1.0161E-02_JPRB/)
KBO( :,23, 2) = (/&
&5.9115E-03_JPRB,6.6091E-03_JPRB,7.3264E-03_JPRB,8.0410E-03_JPRB,8.7466E-03_JPRB/)
KBO( :,24, 2) = (/&
&5.1182E-03_JPRB,5.7070E-03_JPRB,6.3037E-03_JPRB,6.8969E-03_JPRB,7.4832E-03_JPRB/)
KBO( :,25, 2) = (/&
&4.4185E-03_JPRB,4.9117E-03_JPRB,5.4043E-03_JPRB,5.8933E-03_JPRB,6.3802E-03_JPRB/)
KBO( :,26, 2) = (/&
&3.8039E-03_JPRB,4.2126E-03_JPRB,4.6157E-03_JPRB,5.0191E-03_JPRB,5.4221E-03_JPRB/)
KBO( :,27, 2) = (/&
&3.2526E-03_JPRB,3.5834E-03_JPRB,3.9131E-03_JPRB,4.2430E-03_JPRB,4.5744E-03_JPRB/)
KBO( :,28, 2) = (/&
&2.7589E-03_JPRB,3.0253E-03_JPRB,3.2916E-03_JPRB,3.5602E-03_JPRB,3.8315E-03_JPRB/)
KBO( :,29, 2) = (/&
&2.3366E-03_JPRB,2.5520E-03_JPRB,2.7694E-03_JPRB,2.9896E-03_JPRB,3.2113E-03_JPRB/)
KBO( :,30, 2) = (/&
&1.9721E-03_JPRB,2.1482E-03_JPRB,2.3261E-03_JPRB,2.5062E-03_JPRB,2.6880E-03_JPRB/)
KBO( :,31, 2) = (/&
&1.6646E-03_JPRB,1.8093E-03_JPRB,1.9562E-03_JPRB,2.1055E-03_JPRB,2.2560E-03_JPRB/)
KBO( :,32, 2) = (/&
&1.4084E-03_JPRB,1.5283E-03_JPRB,1.6508E-03_JPRB,1.7751E-03_JPRB,1.9009E-03_JPRB/)
KBO( :,33, 2) = (/&
&1.1942E-03_JPRB,1.2940E-03_JPRB,1.3964E-03_JPRB,1.5007E-03_JPRB,1.6067E-03_JPRB/)
KBO( :,34, 2) = (/&
&1.0227E-03_JPRB,1.1075E-03_JPRB,1.1945E-03_JPRB,1.2830E-03_JPRB,1.3735E-03_JPRB/)
KBO( :,35, 2) = (/&
&8.7018E-04_JPRB,9.4216E-04_JPRB,1.0160E-03_JPRB,1.0916E-03_JPRB,1.1695E-03_JPRB/)
KBO( :,36, 2) = (/&
&7.3515E-04_JPRB,7.9615E-04_JPRB,8.5904E-04_JPRB,9.2392E-04_JPRB,9.9055E-04_JPRB/)
KBO( :,37, 2) = (/&
&6.0212E-04_JPRB,6.5252E-04_JPRB,7.0452E-04_JPRB,7.5835E-04_JPRB,8.1370E-04_JPRB/)
KBO( :,38, 2) = (/&
&4.9188E-04_JPRB,5.3334E-04_JPRB,5.7632E-04_JPRB,6.2087E-04_JPRB,6.6682E-04_JPRB/)
KBO( :,39, 2) = (/&
&4.0118E-04_JPRB,4.3525E-04_JPRB,4.7078E-04_JPRB,5.0765E-04_JPRB,5.4579E-04_JPRB/)
KBO( :,40, 2) = (/&
&3.1804E-04_JPRB,3.4535E-04_JPRB,3.7372E-04_JPRB,4.0332E-04_JPRB,4.3403E-04_JPRB/)
KBO( :,41, 2) = (/&
&2.5079E-04_JPRB,2.7257E-04_JPRB,2.9509E-04_JPRB,3.1873E-04_JPRB,3.4326E-04_JPRB/)
KBO( :,42, 2) = (/&
&1.9734E-04_JPRB,2.1467E-04_JPRB,2.3255E-04_JPRB,2.5134E-04_JPRB,2.7095E-04_JPRB/)
KBO( :,43, 2) = (/&
&1.5339E-04_JPRB,1.6697E-04_JPRB,1.8107E-04_JPRB,1.9578E-04_JPRB,2.1125E-04_JPRB/)
KBO( :,44, 2) = (/&
&1.1845E-04_JPRB,1.2903E-04_JPRB,1.4006E-04_JPRB,1.5150E-04_JPRB,1.6358E-04_JPRB/)
KBO( :,45, 2) = (/&
&9.1280E-05_JPRB,9.9479E-05_JPRB,1.0807E-04_JPRB,1.1698E-04_JPRB,1.2633E-04_JPRB/)
KBO( :,46, 2) = (/&
&7.0194E-05_JPRB,7.6516E-05_JPRB,8.3188E-05_JPRB,9.0126E-05_JPRB,9.7367E-05_JPRB/)
KBO( :,47, 2) = (/&
&5.3867E-05_JPRB,5.8795E-05_JPRB,6.3952E-05_JPRB,6.9343E-05_JPRB,7.4969E-05_JPRB/)
KBO( :,48, 2) = (/&
&4.1189E-05_JPRB,4.5058E-05_JPRB,4.9041E-05_JPRB,5.3206E-05_JPRB,5.7575E-05_JPRB/)
KBO( :,49, 2) = (/&
&3.1341E-05_JPRB,3.4382E-05_JPRB,3.7483E-05_JPRB,4.0694E-05_JPRB,4.4051E-05_JPRB/)
KBO( :,50, 2) = (/&
&2.4027E-05_JPRB,2.6443E-05_JPRB,2.8884E-05_JPRB,3.1394E-05_JPRB,3.3991E-05_JPRB/)
KBO( :,51, 2) = (/&
&1.8468E-05_JPRB,2.0396E-05_JPRB,2.2328E-05_JPRB,2.4296E-05_JPRB,2.6326E-05_JPRB/)
KBO( :,52, 2) = (/&
&1.4146E-05_JPRB,1.5676E-05_JPRB,1.7214E-05_JPRB,1.8760E-05_JPRB,2.0350E-05_JPRB/)
KBO( :,53, 2) = (/&
&1.0781E-05_JPRB,1.1992E-05_JPRB,1.3217E-05_JPRB,1.4439E-05_JPRB,1.5682E-05_JPRB/)
KBO( :,54, 2) = (/&
&8.3350E-06_JPRB,9.3049E-06_JPRB,1.0280E-05_JPRB,1.1258E-05_JPRB,1.2239E-05_JPRB/)
KBO( :,55, 2) = (/&
&6.4823E-06_JPRB,7.2753E-06_JPRB,8.0542E-06_JPRB,8.8375E-06_JPRB,9.6163E-06_JPRB/)
KBO( :,56, 2) = (/&
&5.0178E-06_JPRB,5.6802E-06_JPRB,6.3041E-06_JPRB,6.9292E-06_JPRB,7.5496E-06_JPRB/)
KBO( :,57, 2) = (/&
&3.8663E-06_JPRB,4.4221E-06_JPRB,4.9273E-06_JPRB,5.4254E-06_JPRB,5.9221E-06_JPRB/)
KBO( :,58, 2) = (/&
&2.9804E-06_JPRB,3.4457E-06_JPRB,3.8617E-06_JPRB,4.2609E-06_JPRB,4.6580E-06_JPRB/)
KBO( :,59, 2) = (/&
&2.4280E-06_JPRB,2.8160E-06_JPRB,3.1595E-06_JPRB,3.4836E-06_JPRB,3.8045E-06_JPRB/)
KBO( :,13, 3) = (/&
&5.2207E-02_JPRB,5.8218E-02_JPRB,6.4867E-02_JPRB,7.1854E-02_JPRB,7.9269E-02_JPRB/)
KBO( :,14, 3) = (/&
&4.5186E-02_JPRB,5.0511E-02_JPRB,5.6225E-02_JPRB,6.2140E-02_JPRB,6.8380E-02_JPRB/)
KBO( :,15, 3) = (/&
&3.9072E-02_JPRB,4.3588E-02_JPRB,4.8378E-02_JPRB,5.3369E-02_JPRB,5.8579E-02_JPRB/)
KBO( :,16, 3) = (/&
&3.3600E-02_JPRB,3.7414E-02_JPRB,4.1420E-02_JPRB,4.5603E-02_JPRB,4.9920E-02_JPRB/)
KBO( :,17, 3) = (/&
&2.9352E-02_JPRB,3.2637E-02_JPRB,3.6077E-02_JPRB,3.9644E-02_JPRB,4.3315E-02_JPRB/)
KBO( :,18, 3) = (/&
&2.6239E-02_JPRB,2.9170E-02_JPRB,3.2236E-02_JPRB,3.5401E-02_JPRB,3.8652E-02_JPRB/)
KBO( :,19, 3) = (/&
&2.3733E-02_JPRB,2.6395E-02_JPRB,2.9161E-02_JPRB,3.2005E-02_JPRB,3.4969E-02_JPRB/)
KBO( :,20, 3) = (/&
&2.0795E-02_JPRB,2.3131E-02_JPRB,2.5535E-02_JPRB,2.8011E-02_JPRB,3.0599E-02_JPRB/)
KBO( :,21, 3) = (/&
&1.8040E-02_JPRB,2.0057E-02_JPRB,2.2116E-02_JPRB,2.4262E-02_JPRB,2.6478E-02_JPRB/)
KBO( :,22, 3) = (/&
&1.5612E-02_JPRB,1.7322E-02_JPRB,1.9070E-02_JPRB,2.0895E-02_JPRB,2.2752E-02_JPRB/)
KBO( :,23, 3) = (/&
&1.3484E-02_JPRB,1.4923E-02_JPRB,1.6411E-02_JPRB,1.7947E-02_JPRB,1.9492E-02_JPRB/)
KBO( :,24, 3) = (/&
&1.1550E-02_JPRB,1.2744E-02_JPRB,1.3987E-02_JPRB,1.5260E-02_JPRB,1.6517E-02_JPRB/)
KBO( :,25, 3) = (/&
&9.8605E-03_JPRB,1.0848E-02_JPRB,1.1882E-02_JPRB,1.2919E-02_JPRB,1.3956E-02_JPRB/)
KBO( :,26, 3) = (/&
&8.3958E-03_JPRB,9.2176E-03_JPRB,1.0068E-02_JPRB,1.0918E-02_JPRB,1.1783E-02_JPRB/)
KBO( :,27, 3) = (/&
&7.0886E-03_JPRB,7.7689E-03_JPRB,8.4604E-03_JPRB,9.1621E-03_JPRB,9.8810E-03_JPRB/)
KBO( :,28, 3) = (/&
&5.9371E-03_JPRB,6.4915E-03_JPRB,7.0594E-03_JPRB,7.6411E-03_JPRB,8.2339E-03_JPRB/)
KBO( :,29, 3) = (/&
&4.9851E-03_JPRB,5.4425E-03_JPRB,5.9143E-03_JPRB,6.3959E-03_JPRB,6.8922E-03_JPRB/)
KBO( :,30, 3) = (/&
&4.1812E-03_JPRB,4.5627E-03_JPRB,4.9527E-03_JPRB,5.3553E-03_JPRB,5.7728E-03_JPRB/)
KBO( :,31, 3) = (/&
&3.5208E-03_JPRB,3.8377E-03_JPRB,4.1624E-03_JPRB,4.5005E-03_JPRB,4.8529E-03_JPRB/)
KBO( :,32, 3) = (/&
&2.9794E-03_JPRB,3.2434E-03_JPRB,3.5171E-03_JPRB,3.8033E-03_JPRB,4.1013E-03_JPRB/)
KBO( :,33, 3) = (/&
&2.5298E-03_JPRB,2.7525E-03_JPRB,2.9853E-03_JPRB,3.2295E-03_JPRB,3.4800E-03_JPRB/)
KBO( :,34, 3) = (/&
&2.1748E-03_JPRB,2.3658E-03_JPRB,2.5669E-03_JPRB,2.7771E-03_JPRB,2.9911E-03_JPRB/)
KBO( :,35, 3) = (/&
&1.8567E-03_JPRB,2.0216E-03_JPRB,2.1956E-03_JPRB,2.3760E-03_JPRB,2.5595E-03_JPRB/)
KBO( :,36, 3) = (/&
&1.5731E-03_JPRB,1.7153E-03_JPRB,1.8654E-03_JPRB,2.0205E-03_JPRB,2.1791E-03_JPRB/)
KBO( :,37, 3) = (/&
&1.2933E-03_JPRB,1.4114E-03_JPRB,1.5364E-03_JPRB,1.6658E-03_JPRB,1.7984E-03_JPRB/)
KBO( :,38, 3) = (/&
&1.0616E-03_JPRB,1.1594E-03_JPRB,1.2634E-03_JPRB,1.3712E-03_JPRB,1.4820E-03_JPRB/)
KBO( :,39, 3) = (/&
&8.7125E-04_JPRB,9.5245E-04_JPRB,1.0387E-03_JPRB,1.1287E-03_JPRB,1.2213E-03_JPRB/)
KBO( :,40, 3) = (/&
&6.9327E-04_JPRB,7.5826E-04_JPRB,8.2752E-04_JPRB,8.9995E-04_JPRB,9.7479E-04_JPRB/)
KBO( :,41, 3) = (/&
&5.4868E-04_JPRB,6.0043E-04_JPRB,6.5570E-04_JPRB,7.1362E-04_JPRB,7.7402E-04_JPRB/)
KBO( :,42, 3) = (/&
&4.3350E-04_JPRB,4.7475E-04_JPRB,5.1866E-04_JPRB,5.6496E-04_JPRB,6.1339E-04_JPRB/)
KBO( :,43, 3) = (/&
&3.3831E-04_JPRB,3.7074E-04_JPRB,4.0518E-04_JPRB,4.4169E-04_JPRB,4.7994E-04_JPRB/)
KBO( :,44, 3) = (/&
&2.6244E-04_JPRB,2.8770E-04_JPRB,3.1459E-04_JPRB,3.4301E-04_JPRB,3.7299E-04_JPRB/)
KBO( :,45, 3) = (/&
&2.0330E-04_JPRB,2.2282E-04_JPRB,2.4376E-04_JPRB,2.6587E-04_JPRB,2.8931E-04_JPRB/)
KBO( :,46, 3) = (/&
&1.5718E-04_JPRB,1.7223E-04_JPRB,1.8847E-04_JPRB,2.0565E-04_JPRB,2.2386E-04_JPRB/)
KBO( :,47, 3) = (/&
&1.2137E-04_JPRB,1.3292E-04_JPRB,1.4544E-04_JPRB,1.5881E-04_JPRB,1.7290E-04_JPRB/)
KBO( :,48, 3) = (/&
&9.3602E-05_JPRB,1.0245E-04_JPRB,1.1206E-04_JPRB,1.2242E-04_JPRB,1.3333E-04_JPRB/)
KBO( :,49, 3) = (/&
&7.2096E-05_JPRB,7.8857E-05_JPRB,8.6198E-05_JPRB,9.4146E-05_JPRB,1.0259E-04_JPRB/)
KBO( :,50, 3) = (/&
&5.5913E-05_JPRB,6.1131E-05_JPRB,6.6766E-05_JPRB,7.2901E-05_JPRB,7.9460E-05_JPRB/)
KBO( :,51, 3) = (/&
&4.3511E-05_JPRB,4.7559E-05_JPRB,5.1896E-05_JPRB,5.6624E-05_JPRB,6.1713E-05_JPRB/)
KBO( :,52, 3) = (/&
&3.3817E-05_JPRB,3.6967E-05_JPRB,4.0308E-05_JPRB,4.3936E-05_JPRB,4.7870E-05_JPRB/)
KBO( :,53, 3) = (/&
&2.6251E-05_JPRB,2.8701E-05_JPRB,3.1278E-05_JPRB,3.4055E-05_JPRB,3.7076E-05_JPRB/)
KBO( :,54, 3) = (/&
&2.0565E-05_JPRB,2.2472E-05_JPRB,2.4493E-05_JPRB,2.6647E-05_JPRB,2.8987E-05_JPRB/)
KBO( :,55, 3) = (/&
&1.6201E-05_JPRB,1.7665E-05_JPRB,1.9265E-05_JPRB,2.0950E-05_JPRB,2.2778E-05_JPRB/)
KBO( :,56, 3) = (/&
&1.2781E-05_JPRB,1.3883E-05_JPRB,1.5142E-05_JPRB,1.6468E-05_JPRB,1.7890E-05_JPRB/)
KBO( :,57, 3) = (/&
&1.0089E-05_JPRB,1.0916E-05_JPRB,1.1894E-05_JPRB,1.2940E-05_JPRB,1.4042E-05_JPRB/)
KBO( :,58, 3) = (/&
&7.9784E-06_JPRB,8.6088E-06_JPRB,9.3610E-06_JPRB,1.0185E-05_JPRB,1.1049E-05_JPRB/)
KBO( :,59, 3) = (/&
&6.4510E-06_JPRB,6.9647E-06_JPRB,7.5759E-06_JPRB,8.2439E-06_JPRB,8.9478E-06_JPRB/)
KBO( :,13, 4) = (/&
&1.1841E-01_JPRB,1.2983E-01_JPRB,1.4154E-01_JPRB,1.5381E-01_JPRB,1.6654E-01_JPRB/)
KBO( :,14, 4) = (/&
&1.0163E-01_JPRB,1.1119E-01_JPRB,1.2120E-01_JPRB,1.3164E-01_JPRB,1.4262E-01_JPRB/)
KBO( :,15, 4) = (/&
&8.7533E-02_JPRB,9.5453E-02_JPRB,1.0360E-01_JPRB,1.1225E-01_JPRB,1.2143E-01_JPRB/)
KBO( :,16, 4) = (/&
&7.4718E-02_JPRB,8.1074E-02_JPRB,8.7917E-02_JPRB,9.5269E-02_JPRB,1.0309E-01_JPRB/)
KBO( :,17, 4) = (/&
&6.4598E-02_JPRB,7.0161E-02_JPRB,7.6195E-02_JPRB,8.2691E-02_JPRB,8.9645E-02_JPRB/)
KBO( :,18, 4) = (/&
&5.7466E-02_JPRB,6.2589E-02_JPRB,6.8109E-02_JPRB,7.4052E-02_JPRB,8.0449E-02_JPRB/)
KBO( :,19, 4) = (/&
&5.1818E-02_JPRB,5.6571E-02_JPRB,6.1696E-02_JPRB,6.7232E-02_JPRB,7.3092E-02_JPRB/)
KBO( :,20, 4) = (/&
&4.5333E-02_JPRB,4.9583E-02_JPRB,5.4175E-02_JPRB,5.9119E-02_JPRB,6.4307E-02_JPRB/)
KBO( :,21, 4) = (/&
&3.9244E-02_JPRB,4.2988E-02_JPRB,4.7056E-02_JPRB,5.1390E-02_JPRB,5.5921E-02_JPRB/)
KBO( :,22, 4) = (/&
&3.3762E-02_JPRB,3.7028E-02_JPRB,4.0590E-02_JPRB,4.4367E-02_JPRB,4.8278E-02_JPRB/)
KBO( :,23, 4) = (/&
&2.8964E-02_JPRB,3.1825E-02_JPRB,3.4924E-02_JPRB,3.8192E-02_JPRB,4.1570E-02_JPRB/)
KBO( :,24, 4) = (/&
&2.4605E-02_JPRB,2.7087E-02_JPRB,2.9744E-02_JPRB,3.2528E-02_JPRB,3.5398E-02_JPRB/)
KBO( :,25, 4) = (/&
&2.0888E-02_JPRB,2.3028E-02_JPRB,2.5293E-02_JPRB,2.7664E-02_JPRB,3.0056E-02_JPRB/)
KBO( :,26, 4) = (/&
&1.7768E-02_JPRB,1.9595E-02_JPRB,2.1528E-02_JPRB,2.3523E-02_JPRB,2.5480E-02_JPRB/)
KBO( :,27, 4) = (/&
&1.5025E-02_JPRB,1.6582E-02_JPRB,1.8208E-02_JPRB,1.9851E-02_JPRB,2.1449E-02_JPRB/)
KBO( :,28, 4) = (/&
&1.2630E-02_JPRB,1.3940E-02_JPRB,1.5283E-02_JPRB,1.6619E-02_JPRB,1.7935E-02_JPRB/)
KBO( :,29, 4) = (/&
&1.0679E-02_JPRB,1.1777E-02_JPRB,1.2882E-02_JPRB,1.3981E-02_JPRB,1.5077E-02_JPRB/)
KBO( :,30, 4) = (/&
&9.0255E-03_JPRB,9.9336E-03_JPRB,1.0847E-02_JPRB,1.1760E-02_JPRB,1.2675E-02_JPRB/)
KBO( :,31, 4) = (/&
&7.6536E-03_JPRB,8.4086E-03_JPRB,9.1742E-03_JPRB,9.9429E-03_JPRB,1.0712E-02_JPRB/)
KBO( :,32, 4) = (/&
&6.5182E-03_JPRB,7.1536E-03_JPRB,7.8014E-03_JPRB,8.4515E-03_JPRB,9.1065E-03_JPRB/)
KBO( :,33, 4) = (/&
&5.5704E-03_JPRB,6.1113E-03_JPRB,6.6630E-03_JPRB,7.2151E-03_JPRB,7.7820E-03_JPRB/)
KBO( :,34, 4) = (/&
&4.8181E-03_JPRB,5.2845E-03_JPRB,5.7551E-03_JPRB,6.2347E-03_JPRB,6.7271E-03_JPRB/)
KBO( :,35, 4) = (/&
&4.1344E-03_JPRB,4.5342E-03_JPRB,4.9410E-03_JPRB,5.3600E-03_JPRB,5.7876E-03_JPRB/)
KBO( :,36, 4) = (/&
&3.5137E-03_JPRB,3.8568E-03_JPRB,4.2105E-03_JPRB,4.5744E-03_JPRB,4.9478E-03_JPRB/)
KBO( :,37, 4) = (/&
&2.9015E-03_JPRB,3.1894E-03_JPRB,3.4867E-03_JPRB,3.7928E-03_JPRB,4.1062E-03_JPRB/)
KBO( :,38, 4) = (/&
&2.3922E-03_JPRB,2.6336E-03_JPRB,2.8833E-03_JPRB,3.1403E-03_JPRB,3.4033E-03_JPRB/)
KBO( :,39, 4) = (/&
&1.9717E-03_JPRB,2.1746E-03_JPRB,2.3846E-03_JPRB,2.6005E-03_JPRB,2.8213E-03_JPRB/)
KBO( :,40, 4) = (/&
&1.5744E-03_JPRB,1.7398E-03_JPRB,1.9111E-03_JPRB,2.0874E-03_JPRB,2.2673E-03_JPRB/)
KBO( :,41, 4) = (/&
&1.2499E-03_JPRB,1.3841E-03_JPRB,1.5231E-03_JPRB,1.6664E-03_JPRB,1.8122E-03_JPRB/)
KBO( :,42, 4) = (/&
&9.9026E-04_JPRB,1.0991E-03_JPRB,1.2117E-03_JPRB,1.3281E-03_JPRB,1.4464E-03_JPRB/)
KBO( :,43, 4) = (/&
&7.7424E-04_JPRB,8.6142E-04_JPRB,9.5183E-04_JPRB,1.0452E-03_JPRB,1.1404E-03_JPRB/)
KBO( :,44, 4) = (/&
&6.0102E-04_JPRB,6.7034E-04_JPRB,7.4252E-04_JPRB,8.1707E-04_JPRB,8.9311E-04_JPRB/)
KBO( :,45, 4) = (/&
&4.6542E-04_JPRB,5.2035E-04_JPRB,5.7783E-04_JPRB,6.3732E-04_JPRB,6.9797E-04_JPRB/)
KBO( :,46, 4) = (/&
&3.5929E-04_JPRB,4.0259E-04_JPRB,4.4817E-04_JPRB,4.9561E-04_JPRB,5.4403E-04_JPRB/)
KBO( :,47, 4) = (/&
&2.7639E-04_JPRB,3.1035E-04_JPRB,3.4642E-04_JPRB,3.8415E-04_JPRB,4.2283E-04_JPRB/)
KBO( :,48, 4) = (/&
&2.1223E-04_JPRB,2.3861E-04_JPRB,2.6709E-04_JPRB,2.9688E-04_JPRB,3.2776E-04_JPRB/)
KBO( :,49, 4) = (/&
&1.6266E-04_JPRB,1.8298E-04_JPRB,2.0524E-04_JPRB,2.2871E-04_JPRB,2.5327E-04_JPRB/)
KBO( :,50, 4) = (/&
&1.2558E-04_JPRB,1.4128E-04_JPRB,1.5863E-04_JPRB,1.7722E-04_JPRB,1.9672E-04_JPRB/)
KBO( :,51, 4) = (/&
&9.7209E-05_JPRB,1.0936E-04_JPRB,1.2288E-04_JPRB,1.3753E-04_JPRB,1.5302E-04_JPRB/)
KBO( :,52, 4) = (/&
&7.5228E-05_JPRB,8.4554E-05_JPRB,9.5027E-05_JPRB,1.0648E-04_JPRB,1.1875E-04_JPRB/)
KBO( :,53, 4) = (/&
&5.8185E-05_JPRB,6.5291E-05_JPRB,7.3346E-05_JPRB,8.2261E-05_JPRB,9.1865E-05_JPRB/)
KBO( :,54, 4) = (/&
&4.5374E-05_JPRB,5.0847E-05_JPRB,5.7097E-05_JPRB,6.4058E-05_JPRB,7.1601E-05_JPRB/)
KBO( :,55, 4) = (/&
&3.5491E-05_JPRB,3.9770E-05_JPRB,4.4634E-05_JPRB,5.0070E-05_JPRB,5.6003E-05_JPRB/)
KBO( :,56, 4) = (/&
&2.7730E-05_JPRB,3.1107E-05_JPRB,3.4873E-05_JPRB,3.9105E-05_JPRB,4.3754E-05_JPRB/)
KBO( :,57, 4) = (/&
&2.1648E-05_JPRB,2.4314E-05_JPRB,2.7229E-05_JPRB,3.0516E-05_JPRB,3.4148E-05_JPRB/)
KBO( :,58, 4) = (/&
&1.6951E-05_JPRB,1.9038E-05_JPRB,2.1314E-05_JPRB,2.3872E-05_JPRB,2.6710E-05_JPRB/)
KBO( :,59, 4) = (/&
&1.3663E-05_JPRB,1.5351E-05_JPRB,1.7200E-05_JPRB,1.9273E-05_JPRB,2.1558E-05_JPRB/)
KBO( :,13, 5) = (/&
&2.7737E-01_JPRB,2.9322E-01_JPRB,3.0941E-01_JPRB,3.2627E-01_JPRB,3.4434E-01_JPRB/)
KBO( :,14, 5) = (/&
&2.3065E-01_JPRB,2.4437E-01_JPRB,2.5863E-01_JPRB,2.7404E-01_JPRB,2.9080E-01_JPRB/)
KBO( :,15, 5) = (/&
&1.9306E-01_JPRB,2.0550E-01_JPRB,2.1890E-01_JPRB,2.3329E-01_JPRB,2.4884E-01_JPRB/)
KBO( :,16, 5) = (/&
&1.6288E-01_JPRB,1.7408E-01_JPRB,1.8590E-01_JPRB,1.9857E-01_JPRB,2.1238E-01_JPRB/)
KBO( :,17, 5) = (/&
&1.4081E-01_JPRB,1.5068E-01_JPRB,1.6123E-01_JPRB,1.7280E-01_JPRB,1.8532E-01_JPRB/)
KBO( :,18, 5) = (/&
&1.2553E-01_JPRB,1.3466E-01_JPRB,1.4467E-01_JPRB,1.5557E-01_JPRB,1.6709E-01_JPRB/)
KBO( :,19, 5) = (/&
&1.1351E-01_JPRB,1.2221E-01_JPRB,1.3178E-01_JPRB,1.4202E-01_JPRB,1.5283E-01_JPRB/)
KBO( :,20, 5) = (/&
&9.9675E-02_JPRB,1.0772E-01_JPRB,1.1652E-01_JPRB,1.2577E-01_JPRB,1.3562E-01_JPRB/)
KBO( :,21, 5) = (/&
&8.6695E-02_JPRB,9.4022E-02_JPRB,1.0192E-01_JPRB,1.1025E-01_JPRB,1.1913E-01_JPRB/)
KBO( :,22, 5) = (/&
&7.4874E-02_JPRB,8.1502E-02_JPRB,8.8514E-02_JPRB,9.5955E-02_JPRB,1.0385E-01_JPRB/)
KBO( :,23, 5) = (/&
&6.4540E-02_JPRB,7.0395E-02_JPRB,7.6612E-02_JPRB,8.3224E-02_JPRB,9.0095E-02_JPRB/)
KBO( :,24, 5) = (/&
&5.4946E-02_JPRB,6.0047E-02_JPRB,6.5517E-02_JPRB,7.1296E-02_JPRB,7.7220E-02_JPRB/)
KBO( :,25, 5) = (/&
&4.6677E-02_JPRB,5.1141E-02_JPRB,5.5940E-02_JPRB,6.0917E-02_JPRB,6.6053E-02_JPRB/)
KBO( :,26, 5) = (/&
&3.9709E-02_JPRB,4.3642E-02_JPRB,4.7787E-02_JPRB,5.2078E-02_JPRB,5.6505E-02_JPRB/)
KBO( :,27, 5) = (/&
&3.3623E-02_JPRB,3.7042E-02_JPRB,4.0591E-02_JPRB,4.4263E-02_JPRB,4.8022E-02_JPRB/)
KBO( :,28, 5) = (/&
&2.8328E-02_JPRB,3.1245E-02_JPRB,3.4254E-02_JPRB,3.7363E-02_JPRB,4.0510E-02_JPRB/)
KBO( :,29, 5) = (/&
&2.4050E-02_JPRB,2.6527E-02_JPRB,2.9098E-02_JPRB,3.1727E-02_JPRB,3.4395E-02_JPRB/)
KBO( :,30, 5) = (/&
&2.0420E-02_JPRB,2.2529E-02_JPRB,2.4722E-02_JPRB,2.6950E-02_JPRB,2.9231E-02_JPRB/)
KBO( :,31, 5) = (/&
&1.7429E-02_JPRB,1.9242E-02_JPRB,2.1110E-02_JPRB,2.3032E-02_JPRB,2.5014E-02_JPRB/)
KBO( :,32, 5) = (/&
&1.4961E-02_JPRB,1.6521E-02_JPRB,1.8130E-02_JPRB,1.9805E-02_JPRB,2.1542E-02_JPRB/)
KBO( :,33, 5) = (/&
&1.2897E-02_JPRB,1.4245E-02_JPRB,1.5653E-02_JPRB,1.7131E-02_JPRB,1.8661E-02_JPRB/)
KBO( :,34, 5) = (/&
&1.1253E-02_JPRB,1.2438E-02_JPRB,1.3692E-02_JPRB,1.5008E-02_JPRB,1.6374E-02_JPRB/)
KBO( :,35, 5) = (/&
&9.7397E-03_JPRB,1.0786E-02_JPRB,1.1902E-02_JPRB,1.3073E-02_JPRB,1.4295E-02_JPRB/)
KBO( :,36, 5) = (/&
&8.3444E-03_JPRB,9.2674E-03_JPRB,1.0255E-02_JPRB,1.1299E-02_JPRB,1.2388E-02_JPRB/)
KBO( :,37, 5) = (/&
&6.9467E-03_JPRB,7.7344E-03_JPRB,8.5805E-03_JPRB,9.4769E-03_JPRB,1.0414E-02_JPRB/)
KBO( :,38, 5) = (/&
&5.7736E-03_JPRB,6.4450E-03_JPRB,7.1687E-03_JPRB,7.9368E-03_JPRB,8.7424E-03_JPRB/)
KBO( :,39, 5) = (/&
&4.7981E-03_JPRB,5.3703E-03_JPRB,5.9884E-03_JPRB,6.6480E-03_JPRB,7.3403E-03_JPRB/)
KBO( :,40, 5) = (/&
&3.8576E-03_JPRB,4.3274E-03_JPRB,4.8368E-03_JPRB,5.3827E-03_JPRB,5.9574E-03_JPRB/)
KBO( :,41, 5) = (/&
&3.0825E-03_JPRB,3.4658E-03_JPRB,3.8827E-03_JPRB,4.3318E-03_JPRB,4.8066E-03_JPRB/)
KBO( :,42, 5) = (/&
&2.4580E-03_JPRB,2.7697E-03_JPRB,3.1105E-03_JPRB,3.4793E-03_JPRB,3.8701E-03_JPRB/)
KBO( :,43, 5) = (/&
&1.9332E-03_JPRB,2.1836E-03_JPRB,2.4577E-03_JPRB,2.7557E-03_JPRB,3.0732E-03_JPRB/)
KBO( :,44, 5) = (/&
&1.5097E-03_JPRB,1.7091E-03_JPRB,1.9276E-03_JPRB,2.1661E-03_JPRB,2.4221E-03_JPRB/)
KBO( :,45, 5) = (/&
&1.1763E-03_JPRB,1.3345E-03_JPRB,1.5083E-03_JPRB,1.6985E-03_JPRB,1.9040E-03_JPRB/)
KBO( :,46, 5) = (/&
&9.1296E-04_JPRB,1.0380E-03_JPRB,1.1758E-03_JPRB,1.3270E-03_JPRB,1.4913E-03_JPRB/)
KBO( :,47, 5) = (/&
&7.0476E-04_JPRB,8.0366E-04_JPRB,9.1252E-04_JPRB,1.0324E-03_JPRB,1.1627E-03_JPRB/)
KBO( :,48, 5) = (/&
&5.4241E-04_JPRB,6.2078E-04_JPRB,7.0617E-04_JPRB,8.0101E-04_JPRB,9.0392E-04_JPRB/)
KBO( :,49, 5) = (/&
&4.1608E-04_JPRB,4.7812E-04_JPRB,5.4515E-04_JPRB,6.1960E-04_JPRB,7.0075E-04_JPRB/)
KBO( :,50, 5) = (/&
&3.2092E-04_JPRB,3.7020E-04_JPRB,4.2343E-04_JPRB,4.8196E-04_JPRB,5.4630E-04_JPRB/)
KBO( :,51, 5) = (/&
&2.4810E-04_JPRB,2.8709E-04_JPRB,3.2948E-04_JPRB,3.7570E-04_JPRB,4.2676E-04_JPRB/)
KBO( :,52, 5) = (/&
&1.9141E-04_JPRB,2.2213E-04_JPRB,2.5579E-04_JPRB,2.9244E-04_JPRB,3.3280E-04_JPRB/)
KBO( :,53, 5) = (/&
&1.4731E-04_JPRB,1.7148E-04_JPRB,1.9808E-04_JPRB,2.2719E-04_JPRB,2.5899E-04_JPRB/)
KBO( :,54, 5) = (/&
&1.1424E-04_JPRB,1.3342E-04_JPRB,1.5446E-04_JPRB,1.7772E-04_JPRB,2.0300E-04_JPRB/)
KBO( :,55, 5) = (/&
&8.8904E-05_JPRB,1.0414E-04_JPRB,1.2079E-04_JPRB,1.3937E-04_JPRB,1.5956E-04_JPRB/)
KBO( :,56, 5) = (/&
&6.9133E-05_JPRB,8.1185E-05_JPRB,9.4325E-05_JPRB,1.0911E-04_JPRB,1.2522E-04_JPRB/)
KBO( :,57, 5) = (/&
&5.3742E-05_JPRB,6.3143E-05_JPRB,7.3567E-05_JPRB,8.5265E-05_JPRB,9.8102E-05_JPRB/)
KBO( :,58, 5) = (/&
&4.1907E-05_JPRB,4.9238E-05_JPRB,5.7492E-05_JPRB,6.6736E-05_JPRB,7.6984E-05_JPRB/)
KBO( :,59, 5) = (/&
&3.3859E-05_JPRB,3.9819E-05_JPRB,4.6565E-05_JPRB,5.4107E-05_JPRB,6.2503E-05_JPRB/)
KBO( :,13, 6) = (/&
&6.4121E-01_JPRB,6.6739E-01_JPRB,6.9468E-01_JPRB,7.2265E-01_JPRB,7.5107E-01_JPRB/)
KBO( :,14, 6) = (/&
&5.3428E-01_JPRB,5.5697E-01_JPRB,5.8044E-01_JPRB,6.0466E-01_JPRB,6.2906E-01_JPRB/)
KBO( :,15, 6) = (/&
&4.4250E-01_JPRB,4.6307E-01_JPRB,4.8477E-01_JPRB,5.0676E-01_JPRB,5.2972E-01_JPRB/)
KBO( :,16, 6) = (/&
&3.7115E-01_JPRB,3.9071E-01_JPRB,4.1071E-01_JPRB,4.3131E-01_JPRB,4.5290E-01_JPRB/)
KBO( :,17, 6) = (/&
&3.2201E-01_JPRB,3.3982E-01_JPRB,3.5775E-01_JPRB,3.7619E-01_JPRB,3.9590E-01_JPRB/)
KBO( :,18, 6) = (/&
&2.8860E-01_JPRB,3.0433E-01_JPRB,3.2058E-01_JPRB,3.3778E-01_JPRB,3.5711E-01_JPRB/)
KBO( :,19, 6) = (/&
&2.6093E-01_JPRB,2.7547E-01_JPRB,2.9092E-01_JPRB,3.0787E-01_JPRB,3.2715E-01_JPRB/)
KBO( :,20, 6) = (/&
&2.2906E-01_JPRB,2.4252E-01_JPRB,2.5706E-01_JPRB,2.7353E-01_JPRB,2.9188E-01_JPRB/)
KBO( :,21, 6) = (/&
&1.9921E-01_JPRB,2.1163E-01_JPRB,2.2547E-01_JPRB,2.4100E-01_JPRB,2.5826E-01_JPRB/)
KBO( :,22, 6) = (/&
&1.7190E-01_JPRB,1.8347E-01_JPRB,1.9652E-01_JPRB,2.1104E-01_JPRB,2.2725E-01_JPRB/)
KBO( :,23, 6) = (/&
&1.4807E-01_JPRB,1.5892E-01_JPRB,1.7107E-01_JPRB,1.8464E-01_JPRB,1.9976E-01_JPRB/)
KBO( :,24, 6) = (/&
&1.2630E-01_JPRB,1.3639E-01_JPRB,1.4760E-01_JPRB,1.6015E-01_JPRB,1.7395E-01_JPRB/)
KBO( :,25, 6) = (/&
&1.0785E-01_JPRB,1.1709E-01_JPRB,1.2743E-01_JPRB,1.3890E-01_JPRB,1.5149E-01_JPRB/)
KBO( :,26, 6) = (/&
&9.2383E-02_JPRB,1.0082E-01_JPRB,1.1033E-01_JPRB,1.2082E-01_JPRB,1.3229E-01_JPRB/)
KBO( :,27, 6) = (/&
&7.8812E-02_JPRB,8.6542E-02_JPRB,9.5218E-02_JPRB,1.0477E-01_JPRB,1.1508E-01_JPRB/)
KBO( :,28, 6) = (/&
&6.6953E-02_JPRB,7.4005E-02_JPRB,8.1900E-02_JPRB,9.0499E-02_JPRB,9.9667E-02_JPRB/)
KBO( :,29, 6) = (/&
&5.7472E-02_JPRB,6.3923E-02_JPRB,7.1088E-02_JPRB,7.8810E-02_JPRB,8.6979E-02_JPRB/)
KBO( :,30, 6) = (/&
&4.9506E-02_JPRB,5.5394E-02_JPRB,6.1825E-02_JPRB,6.8714E-02_JPRB,7.5948E-02_JPRB/)
KBO( :,31, 6) = (/&
&4.3026E-02_JPRB,4.8351E-02_JPRB,5.4145E-02_JPRB,6.0281E-02_JPRB,6.6645E-02_JPRB/)
KBO( :,32, 6) = (/&
&3.7695E-02_JPRB,4.2520E-02_JPRB,4.7714E-02_JPRB,5.3158E-02_JPRB,5.8754E-02_JPRB/)
KBO( :,33, 6) = (/&
&3.3253E-02_JPRB,3.7612E-02_JPRB,4.2238E-02_JPRB,4.7058E-02_JPRB,5.2057E-02_JPRB/)
KBO( :,34, 6) = (/&
&2.9687E-02_JPRB,3.3639E-02_JPRB,3.7802E-02_JPRB,4.2143E-02_JPRB,4.6713E-02_JPRB/)
KBO( :,35, 6) = (/&
&2.6238E-02_JPRB,2.9780E-02_JPRB,3.3512E-02_JPRB,3.7433E-02_JPRB,4.1618E-02_JPRB/)
KBO( :,36, 6) = (/&
&2.2870E-02_JPRB,2.6020E-02_JPRB,2.9343E-02_JPRB,3.2882E-02_JPRB,3.6681E-02_JPRB/)
KBO( :,37, 6) = (/&
&1.9322E-02_JPRB,2.2060E-02_JPRB,2.4965E-02_JPRB,2.8086E-02_JPRB,3.1456E-02_JPRB/)
KBO( :,38, 6) = (/&
&1.6289E-02_JPRB,1.8667E-02_JPRB,2.1206E-02_JPRB,2.3953E-02_JPRB,2.6938E-02_JPRB/)
KBO( :,39, 6) = (/&
&1.3724E-02_JPRB,1.5787E-02_JPRB,1.8005E-02_JPRB,2.0421E-02_JPRB,2.3064E-02_JPRB/)
KBO( :,40, 6) = (/&
&1.1170E-02_JPRB,1.2903E-02_JPRB,1.4777E-02_JPRB,1.6832E-02_JPRB,1.9094E-02_JPRB/)
KBO( :,41, 6) = (/&
&9.0289E-03_JPRB,1.0474E-02_JPRB,1.2048E-02_JPRB,1.3783E-02_JPRB,1.5707E-02_JPRB/)
KBO( :,42, 6) = (/&
&7.2786E-03_JPRB,8.4784E-03_JPRB,9.7962E-03_JPRB,1.1257E-02_JPRB,1.2889E-02_JPRB/)
KBO( :,43, 6) = (/&
&5.7746E-03_JPRB,6.7579E-03_JPRB,7.8468E-03_JPRB,9.0602E-03_JPRB,1.0425E-02_JPRB/)
KBO( :,44, 6) = (/&
&4.5415E-03_JPRB,5.3414E-03_JPRB,6.2337E-03_JPRB,7.2326E-03_JPRB,8.3633E-03_JPRB/)
KBO( :,45, 6) = (/&
&3.5601E-03_JPRB,4.2081E-03_JPRB,4.9346E-03_JPRB,5.7558E-03_JPRB,6.6891E-03_JPRB/)
KBO( :,46, 6) = (/&
&2.7754E-03_JPRB,3.2977E-03_JPRB,3.8855E-03_JPRB,4.5569E-03_JPRB,5.3238E-03_JPRB/)
KBO( :,47, 6) = (/&
&2.1475E-03_JPRB,2.5657E-03_JPRB,3.0384E-03_JPRB,3.5836E-03_JPRB,4.2109E-03_JPRB/)
KBO( :,48, 6) = (/&
&1.6563E-03_JPRB,1.9892E-03_JPRB,2.3684E-03_JPRB,2.8081E-03_JPRB,3.3184E-03_JPRB/)
KBO( :,49, 6) = (/&
&1.2736E-03_JPRB,1.5366E-03_JPRB,1.8396E-03_JPRB,2.1918E-03_JPRB,2.6053E-03_JPRB/)
KBO( :,50, 6) = (/&
&9.8514E-04_JPRB,1.1938E-03_JPRB,1.4366E-03_JPRB,1.7199E-03_JPRB,2.0561E-03_JPRB/)
KBO( :,51, 6) = (/&
&7.6305E-04_JPRB,9.2853E-04_JPRB,1.1230E-03_JPRB,1.3507E-03_JPRB,1.6237E-03_JPRB/)
KBO( :,52, 6) = (/&
&5.8964E-04_JPRB,7.2048E-04_JPRB,8.7539E-04_JPRB,1.0577E-03_JPRB,1.2781E-03_JPRB/)
KBO( :,53, 6) = (/&
&4.5442E-04_JPRB,5.5764E-04_JPRB,6.8041E-04_JPRB,8.2614E-04_JPRB,1.0025E-03_JPRB/)
KBO( :,54, 6) = (/&
&3.5277E-04_JPRB,4.3435E-04_JPRB,5.3231E-04_JPRB,6.4901E-04_JPRB,7.9056E-04_JPRB/)
KBO( :,55, 6) = (/&
&2.7456E-04_JPRB,3.3899E-04_JPRB,4.1714E-04_JPRB,5.1074E-04_JPRB,6.2435E-04_JPRB/)
KBO( :,56, 6) = (/&
&2.1331E-04_JPRB,2.6410E-04_JPRB,3.2619E-04_JPRB,4.0097E-04_JPRB,4.9192E-04_JPRB/)
KBO( :,57, 6) = (/&
&1.6544E-04_JPRB,2.0526E-04_JPRB,2.5453E-04_JPRB,3.1404E-04_JPRB,3.8660E-04_JPRB/)
KBO( :,58, 6) = (/&
&1.2858E-04_JPRB,1.5986E-04_JPRB,1.9897E-04_JPRB,2.4635E-04_JPRB,3.0450E-04_JPRB/)
KBO( :,59, 6) = (/&
&1.0424E-04_JPRB,1.3005E-04_JPRB,1.6246E-04_JPRB,2.0168E-04_JPRB,2.5022E-04_JPRB/)
KBO( :,13, 7) = (/&
&1.5651E+00_JPRB,1.6169E+00_JPRB,1.6708E+00_JPRB,1.7263E+00_JPRB,1.7852E+00_JPRB/)
KBO( :,14, 7) = (/&
&1.3034E+00_JPRB,1.3495E+00_JPRB,1.3970E+00_JPRB,1.4470E+00_JPRB,1.4990E+00_JPRB/)
KBO( :,15, 7) = (/&
&1.0798E+00_JPRB,1.1205E+00_JPRB,1.1627E+00_JPRB,1.2066E+00_JPRB,1.2529E+00_JPRB/)
KBO( :,16, 7) = (/&
&9.0502E-01_JPRB,9.4264E-01_JPRB,9.8168E-01_JPRB,1.0232E+00_JPRB,1.0668E+00_JPRB/)
KBO( :,17, 7) = (/&
&7.8533E-01_JPRB,8.2264E-01_JPRB,8.6170E-01_JPRB,9.0297E-01_JPRB,9.4574E-01_JPRB/)
KBO( :,18, 7) = (/&
&7.0905E-01_JPRB,7.4606E-01_JPRB,7.8445E-01_JPRB,8.2385E-01_JPRB,8.6498E-01_JPRB/)
KBO( :,19, 7) = (/&
&6.5117E-01_JPRB,6.8581E-01_JPRB,7.2084E-01_JPRB,7.5738E-01_JPRB,7.9689E-01_JPRB/)
KBO( :,20, 7) = (/&
&5.8055E-01_JPRB,6.1130E-01_JPRB,6.4302E-01_JPRB,6.7746E-01_JPRB,7.1553E-01_JPRB/)
KBO( :,21, 7) = (/&
&5.1109E-01_JPRB,5.3883E-01_JPRB,5.6867E-01_JPRB,6.0178E-01_JPRB,6.3866E-01_JPRB/)
KBO( :,22, 7) = (/&
&4.4535E-01_JPRB,4.7107E-01_JPRB,4.9963E-01_JPRB,5.3173E-01_JPRB,5.6752E-01_JPRB/)
KBO( :,23, 7) = (/&
&3.8693E-01_JPRB,4.1147E-01_JPRB,4.3911E-01_JPRB,4.7015E-01_JPRB,5.0472E-01_JPRB/)
KBO( :,24, 7) = (/&
&3.3299E-01_JPRB,3.5628E-01_JPRB,3.8277E-01_JPRB,4.1248E-01_JPRB,4.4550E-01_JPRB/)
KBO( :,25, 7) = (/&
&2.8674E-01_JPRB,3.0903E-01_JPRB,3.3447E-01_JPRB,3.6286E-01_JPRB,3.9391E-01_JPRB/)
KBO( :,26, 7) = (/&
&2.4799E-01_JPRB,2.6945E-01_JPRB,2.9359E-01_JPRB,3.2034E-01_JPRB,3.4997E-01_JPRB/)
KBO( :,27, 7) = (/&
&2.1431E-01_JPRB,2.3461E-01_JPRB,2.5723E-01_JPRB,2.8249E-01_JPRB,3.1067E-01_JPRB/)
KBO( :,28, 7) = (/&
&1.8505E-01_JPRB,2.0390E-01_JPRB,2.2502E-01_JPRB,2.4887E-01_JPRB,2.7537E-01_JPRB/)
KBO( :,29, 7) = (/&
&1.6146E-01_JPRB,1.7908E-01_JPRB,1.9912E-01_JPRB,2.2167E-01_JPRB,2.4667E-01_JPRB/)
KBO( :,30, 7) = (/&
&1.4137E-01_JPRB,1.5806E-01_JPRB,1.7706E-01_JPRB,1.9835E-01_JPRB,2.2209E-01_JPRB/)
KBO( :,31, 7) = (/&
&1.2498E-01_JPRB,1.4092E-01_JPRB,1.5896E-01_JPRB,1.7927E-01_JPRB,2.0199E-01_JPRB/)
KBO( :,32, 7) = (/&
&1.1162E-01_JPRB,1.2686E-01_JPRB,1.4411E-01_JPRB,1.6362E-01_JPRB,1.8544E-01_JPRB/)
KBO( :,33, 7) = (/&
&1.0058E-01_JPRB,1.1519E-01_JPRB,1.3185E-01_JPRB,1.5062E-01_JPRB,1.7164E-01_JPRB/)
KBO( :,34, 7) = (/&
&9.1872E-02_JPRB,1.0605E-01_JPRB,1.2221E-01_JPRB,1.4049E-01_JPRB,1.6092E-01_JPRB/)
KBO( :,35, 7) = (/&
&8.3134E-02_JPRB,9.6731E-02_JPRB,1.1227E-01_JPRB,1.2986E-01_JPRB,1.4952E-01_JPRB/)
KBO( :,36, 7) = (/&
&7.4081E-02_JPRB,8.6894E-02_JPRB,1.0163E-01_JPRB,1.1830E-01_JPRB,1.3703E-01_JPRB/)
KBO( :,37, 7) = (/&
&6.4153E-02_JPRB,7.5901E-02_JPRB,8.9515E-02_JPRB,1.0499E-01_JPRB,1.2245E-01_JPRB/)
KBO( :,38, 7) = (/&
&5.5459E-02_JPRB,6.6199E-02_JPRB,7.8762E-02_JPRB,9.3144E-02_JPRB,1.0945E-01_JPRB/)
KBO( :,39, 7) = (/&
&4.7923E-02_JPRB,5.7730E-02_JPRB,6.9328E-02_JPRB,8.2715E-02_JPRB,9.7968E-02_JPRB/)
KBO( :,40, 7) = (/&
&3.9991E-02_JPRB,4.8626E-02_JPRB,5.8962E-02_JPRB,7.1033E-02_JPRB,8.4866E-02_JPRB/)
KBO( :,41, 7) = (/&
&3.3132E-02_JPRB,4.0668E-02_JPRB,4.9786E-02_JPRB,6.0601E-02_JPRB,7.3110E-02_JPRB/)
KBO( :,42, 7) = (/&
&2.7362E-02_JPRB,3.3907E-02_JPRB,4.1915E-02_JPRB,5.1544E-02_JPRB,6.2838E-02_JPRB/)
KBO( :,43, 7) = (/&
&2.2196E-02_JPRB,2.7768E-02_JPRB,3.4671E-02_JPRB,4.3090E-02_JPRB,5.3119E-02_JPRB/)
KBO( :,44, 7) = (/&
&1.7818E-02_JPRB,2.2501E-02_JPRB,2.8380E-02_JPRB,3.5655E-02_JPRB,4.4455E-02_JPRB/)
KBO( :,45, 7) = (/&
&1.4243E-02_JPRB,1.8150E-02_JPRB,2.3128E-02_JPRB,2.9377E-02_JPRB,3.7045E-02_JPRB/)
KBO( :,46, 7) = (/&
&1.1286E-02_JPRB,1.4511E-02_JPRB,1.8685E-02_JPRB,2.4000E-02_JPRB,3.0616E-02_JPRB/)
KBO( :,47, 7) = (/&
&8.8305E-03_JPRB,1.1453E-02_JPRB,1.4902E-02_JPRB,1.9356E-02_JPRB,2.5001E-02_JPRB/)
KBO( :,48, 7) = (/&
&6.8710E-03_JPRB,8.9888E-03_JPRB,1.1814E-02_JPRB,1.5517E-02_JPRB,2.0294E-02_JPRB/)
KBO( :,49, 7) = (/&
&5.3150E-03_JPRB,7.0121E-03_JPRB,9.3059E-03_JPRB,1.2357E-02_JPRB,1.6365E-02_JPRB/)
KBO( :,50, 7) = (/&
&4.1309E-03_JPRB,5.4944E-03_JPRB,7.3653E-03_JPRB,9.8877E-03_JPRB,1.3254E-02_JPRB/)
KBO( :,51, 7) = (/&
&3.2122E-03_JPRB,4.3028E-03_JPRB,5.8246E-03_JPRB,7.9072E-03_JPRB,1.0730E-02_JPRB/)
KBO( :,52, 7) = (/&
&2.4855E-03_JPRB,3.3518E-03_JPRB,4.5791E-03_JPRB,6.2870E-03_JPRB,8.6345E-03_JPRB/)
KBO( :,53, 7) = (/&
&1.9144E-03_JPRB,2.5958E-03_JPRB,3.5772E-03_JPRB,4.9679E-03_JPRB,6.9029E-03_JPRB/)
KBO( :,54, 7) = (/&
&1.4846E-03_JPRB,2.0243E-03_JPRB,2.8131E-03_JPRB,3.9506E-03_JPRB,5.5585E-03_JPRB/)
KBO( :,55, 7) = (/&
&1.1531E-03_JPRB,1.5804E-03_JPRB,2.2143E-03_JPRB,3.1436E-03_JPRB,4.4799E-03_JPRB/)
KBO( :,56, 7) = (/&
&8.9241E-04_JPRB,1.2296E-03_JPRB,1.7344E-03_JPRB,2.4879E-03_JPRB,3.5892E-03_JPRB/)
KBO( :,57, 7) = (/&
&6.8839E-04_JPRB,9.5206E-04_JPRB,1.3509E-03_JPRB,1.9572E-03_JPRB,2.8575E-03_JPRB/)
KBO( :,58, 7) = (/&
&5.3236E-04_JPRB,7.3837E-04_JPRB,1.0535E-03_JPRB,1.5406E-03_JPRB,2.2793E-03_JPRB/)
KBO( :,59, 7) = (/&
&4.3598E-04_JPRB,6.1022E-04_JPRB,8.8068E-04_JPRB,1.3033E-03_JPRB,1.9553E-03_JPRB/)
KBO( :,13, 8) = (/&
&4.7769E+00_JPRB,4.8848E+00_JPRB,4.9874E+00_JPRB,5.0917E+00_JPRB,5.1968E+00_JPRB/)
KBO( :,14, 8) = (/&
&4.0252E+00_JPRB,4.1225E+00_JPRB,4.2203E+00_JPRB,4.3172E+00_JPRB,4.4173E+00_JPRB/)
KBO( :,15, 8) = (/&
&3.3636E+00_JPRB,3.4557E+00_JPRB,3.5447E+00_JPRB,3.6379E+00_JPRB,3.7313E+00_JPRB/)
KBO( :,16, 8) = (/&
&2.8215E+00_JPRB,2.9045E+00_JPRB,2.9912E+00_JPRB,3.0777E+00_JPRB,3.1703E+00_JPRB/)
KBO( :,17, 8) = (/&
&2.4207E+00_JPRB,2.5043E+00_JPRB,2.5895E+00_JPRB,2.6793E+00_JPRB,2.7738E+00_JPRB/)
KBO( :,18, 8) = (/&
&2.1596E+00_JPRB,2.2496E+00_JPRB,2.3425E+00_JPRB,2.4404E+00_JPRB,2.5399E+00_JPRB/)
KBO( :,19, 8) = (/&
&1.9873E+00_JPRB,2.0853E+00_JPRB,2.1866E+00_JPRB,2.2891E+00_JPRB,2.3905E+00_JPRB/)
KBO( :,20, 8) = (/&
&1.8046E+00_JPRB,1.9022E+00_JPRB,2.0007E+00_JPRB,2.0973E+00_JPRB,2.1932E+00_JPRB/)
KBO( :,21, 8) = (/&
&1.6245E+00_JPRB,1.7151E+00_JPRB,1.8038E+00_JPRB,1.8907E+00_JPRB,1.9795E+00_JPRB/)
KBO( :,22, 8) = (/&
&1.4461E+00_JPRB,1.5258E+00_JPRB,1.6036E+00_JPRB,1.6835E+00_JPRB,1.7677E+00_JPRB/)
KBO( :,23, 8) = (/&
&1.2784E+00_JPRB,1.3484E+00_JPRB,1.4202E+00_JPRB,1.4958E+00_JPRB,1.5781E+00_JPRB/)
KBO( :,24, 8) = (/&
&1.1162E+00_JPRB,1.1799E+00_JPRB,1.2469E+00_JPRB,1.3197E+00_JPRB,1.4014E+00_JPRB/)
KBO( :,25, 8) = (/&
&9.7290E-01_JPRB,1.0323E+00_JPRB,1.0964E+00_JPRB,1.1683E+00_JPRB,1.2507E+00_JPRB/)
KBO( :,26, 8) = (/&
&8.5083E-01_JPRB,9.0746E-01_JPRB,9.7028E-01_JPRB,1.0426E+00_JPRB,1.1250E+00_JPRB/)
KBO( :,27, 8) = (/&
&7.4331E-01_JPRB,7.9805E-01_JPRB,8.6066E-01_JPRB,9.3282E-01_JPRB,1.0150E+00_JPRB/)
KBO( :,28, 8) = (/&
&6.4875E-01_JPRB,7.0258E-01_JPRB,7.6476E-01_JPRB,8.3624E-01_JPRB,9.1880E-01_JPRB/)
KBO( :,29, 8) = (/&
&5.7353E-01_JPRB,6.2704E-01_JPRB,6.8898E-01_JPRB,7.6115E-01_JPRB,8.4456E-01_JPRB/)
KBO( :,30, 8) = (/&
&5.1081E-01_JPRB,5.6430E-01_JPRB,6.2672E-01_JPRB,6.9960E-01_JPRB,7.8366E-01_JPRB/)
KBO( :,31, 8) = (/&
&4.6060E-01_JPRB,5.1474E-01_JPRB,5.7850E-01_JPRB,6.5276E-01_JPRB,7.3784E-01_JPRB/)
KBO( :,32, 8) = (/&
&4.2054E-01_JPRB,4.7584E-01_JPRB,5.4138E-01_JPRB,6.1744E-01_JPRB,7.0416E-01_JPRB/)
KBO( :,33, 8) = (/&
&3.8881E-01_JPRB,4.4574E-01_JPRB,5.1326E-01_JPRB,5.9158E-01_JPRB,6.8101E-01_JPRB/)
KBO( :,34, 8) = (/&
&3.6582E-01_JPRB,4.2446E-01_JPRB,4.9413E-01_JPRB,5.7504E-01_JPRB,6.6797E-01_JPRB/)
KBO( :,35, 8) = (/&
&3.4211E-01_JPRB,4.0158E-01_JPRB,4.7243E-01_JPRB,5.5519E-01_JPRB,6.5095E-01_JPRB/)
KBO( :,36, 8) = (/&
&3.1584E-01_JPRB,3.7515E-01_JPRB,4.4596E-01_JPRB,5.2948E-01_JPRB,6.2662E-01_JPRB/)
KBO( :,37, 8) = (/&
&2.8335E-01_JPRB,3.4000E-01_JPRB,4.0808E-01_JPRB,4.8925E-01_JPRB,5.8433E-01_JPRB/)
KBO( :,38, 8) = (/&
&2.5439E-01_JPRB,3.0837E-01_JPRB,3.7382E-01_JPRB,4.5256E-01_JPRB,5.4554E-01_JPRB/)
KBO( :,39, 8) = (/&
&2.2884E-01_JPRB,2.8037E-01_JPRB,3.4336E-01_JPRB,4.1988E-01_JPRB,5.1084E-01_JPRB/)
KBO( :,40, 8) = (/&
&1.9894E-01_JPRB,2.4621E-01_JPRB,3.0460E-01_JPRB,3.7622E-01_JPRB,4.6217E-01_JPRB/)
KBO( :,41, 8) = (/&
&1.7202E-01_JPRB,2.1505E-01_JPRB,2.6889E-01_JPRB,3.3546E-01_JPRB,4.1631E-01_JPRB/)
KBO( :,42, 8) = (/&
&1.4851E-01_JPRB,1.8770E-01_JPRB,2.3715E-01_JPRB,2.9895E-01_JPRB,3.7473E-01_JPRB/)
KBO( :,43, 8) = (/&
&1.2600E-01_JPRB,1.6095E-01_JPRB,2.0554E-01_JPRB,2.6188E-01_JPRB,3.3169E-01_JPRB/)
KBO( :,44, 8) = (/&
&1.0584E-01_JPRB,1.3667E-01_JPRB,1.7652E-01_JPRB,2.2729E-01_JPRB,2.9097E-01_JPRB/)
KBO( :,45, 8) = (/&
&8.8493E-02_JPRB,1.1567E-01_JPRB,1.5110E-01_JPRB,1.9672E-01_JPRB,2.5462E-01_JPRB/)
KBO( :,46, 8) = (/&
&7.3233E-02_JPRB,9.7022E-02_JPRB,1.2827E-01_JPRB,1.6892E-01_JPRB,2.2114E-01_JPRB/)
KBO( :,47, 8) = (/&
&5.9636E-02_JPRB,8.0163E-02_JPRB,1.0738E-01_JPRB,1.4314E-01_JPRB,1.8961E-01_JPRB/)
KBO( :,48, 8) = (/&
&4.8167E-02_JPRB,6.5765E-02_JPRB,8.9346E-02_JPRB,1.2067E-01_JPRB,1.6184E-01_JPRB/)
KBO( :,49, 8) = (/&
&3.8566E-02_JPRB,5.3500E-02_JPRB,7.3805E-02_JPRB,1.0114E-01_JPRB,1.3740E-01_JPRB/)
KBO( :,50, 8) = (/&
&3.0986E-02_JPRB,4.3657E-02_JPRB,6.1235E-02_JPRB,8.5187E-02_JPRB,1.1732E-01_JPRB/)
KBO( :,51, 8) = (/&
&2.4855E-02_JPRB,3.5538E-02_JPRB,5.0728E-02_JPRB,7.1690E-02_JPRB,1.0021E-01_JPRB/)
KBO( :,52, 8) = (/&
&1.9770E-02_JPRB,2.8704E-02_JPRB,4.1703E-02_JPRB,5.9943E-02_JPRB,8.5157E-02_JPRB/)
KBO( :,53, 8) = (/&
&1.5594E-02_JPRB,2.2973E-02_JPRB,3.3967E-02_JPRB,4.9762E-02_JPRB,7.1853E-02_JPRB/)
KBO( :,54, 8) = (/&
&1.2395E-02_JPRB,1.8523E-02_JPRB,2.7877E-02_JPRB,4.1630E-02_JPRB,6.1144E-02_JPRB/)
KBO( :,55, 8) = (/&
&9.8575E-03_JPRB,1.4938E-02_JPRB,2.2890E-02_JPRB,3.4846E-02_JPRB,5.2121E-02_JPRB/)
KBO( :,56, 8) = (/&
&7.7929E-03_JPRB,1.1970E-02_JPRB,1.8661E-02_JPRB,2.8954E-02_JPRB,4.4168E-02_JPRB/)
KBO( :,57, 8) = (/&
&6.1195E-03_JPRB,9.5111E-03_JPRB,1.5088E-02_JPRB,2.3882E-02_JPRB,3.7179E-02_JPRB/)
KBO( :,58, 8) = (/&
&4.8102E-03_JPRB,7.5604E-03_JPRB,1.2200E-02_JPRB,1.9713E-02_JPRB,3.1334E-02_JPRB/)
KBO( :,59, 8) = (/&
&4.0994E-03_JPRB,6.5648E-03_JPRB,1.0813E-02_JPRB,1.7794E-02_JPRB,2.8755E-02_JPRB/)
KBO( :,13, 9) = (/&
&2.2033E+01_JPRB,2.2174E+01_JPRB,2.2343E+01_JPRB,2.2507E+01_JPRB,2.2688E+01_JPRB/)
KBO( :,14, 9) = (/&
&1.9641E+01_JPRB,1.9826E+01_JPRB,1.9998E+01_JPRB,2.0195E+01_JPRB,2.0429E+01_JPRB/)
KBO( :,15, 9) = (/&
&1.7181E+01_JPRB,1.7367E+01_JPRB,1.7589E+01_JPRB,1.7835E+01_JPRB,1.8095E+01_JPRB/)
KBO( :,16, 9) = (/&
&1.4894E+01_JPRB,1.5133E+01_JPRB,1.5386E+01_JPRB,1.5657E+01_JPRB,1.5957E+01_JPRB/)
KBO( :,17, 9) = (/&
&1.3089E+01_JPRB,1.3342E+01_JPRB,1.3618E+01_JPRB,1.3934E+01_JPRB,1.4266E+01_JPRB/)
KBO( :,18, 9) = (/&
&1.1731E+01_JPRB,1.2006E+01_JPRB,1.2330E+01_JPRB,1.2671E+01_JPRB,1.3025E+01_JPRB/)
KBO( :,19, 9) = (/&
&1.0583E+01_JPRB,1.0906E+01_JPRB,1.1254E+01_JPRB,1.1621E+01_JPRB,1.2024E+01_JPRB/)
KBO( :,20, 9) = (/&
&9.4570E+00_JPRB,9.7937E+00_JPRB,1.0152E+01_JPRB,1.0555E+01_JPRB,1.0995E+01_JPRB/)
KBO( :,21, 9) = (/&
&8.4559E+00_JPRB,8.8026E+00_JPRB,9.1952E+00_JPRB,9.6304E+00_JPRB,1.0095E+01_JPRB/)
KBO( :,22, 9) = (/&
&7.5782E+00_JPRB,7.9554E+00_JPRB,8.3755E+00_JPRB,8.8282E+00_JPRB,9.3139E+00_JPRB/)
KBO( :,23, 9) = (/&
&6.8684E+00_JPRB,7.2684E+00_JPRB,7.7047E+00_JPRB,8.1736E+00_JPRB,8.6781E+00_JPRB/)
KBO( :,24, 9) = (/&
&6.2497E+00_JPRB,6.6572E+00_JPRB,7.0979E+00_JPRB,7.5746E+00_JPRB,8.0821E+00_JPRB/)
KBO( :,25, 9) = (/&
&5.7300E+00_JPRB,6.1337E+00_JPRB,6.5736E+00_JPRB,7.0462E+00_JPRB,7.5518E+00_JPRB/)
KBO( :,26, 9) = (/&
&5.2905E+00_JPRB,5.6892E+00_JPRB,6.1183E+00_JPRB,6.5857E+00_JPRB,7.0904E+00_JPRB/)
KBO( :,27, 9) = (/&
&4.8852E+00_JPRB,5.2716E+00_JPRB,5.6895E+00_JPRB,6.1477E+00_JPRB,6.6506E+00_JPRB/)
KBO( :,28, 9) = (/&
&4.4993E+00_JPRB,4.8815E+00_JPRB,5.2912E+00_JPRB,5.7427E+00_JPRB,6.2498E+00_JPRB/)
KBO( :,29, 9) = (/&
&4.1817E+00_JPRB,4.5681E+00_JPRB,4.9858E+00_JPRB,5.4440E+00_JPRB,5.9661E+00_JPRB/)
KBO( :,30, 9) = (/&
&3.9159E+00_JPRB,4.3103E+00_JPRB,4.7415E+00_JPRB,5.2227E+00_JPRB,5.7617E+00_JPRB/)
KBO( :,31, 9) = (/&
&3.7169E+00_JPRB,4.1255E+00_JPRB,4.5793E+00_JPRB,5.0892E+00_JPRB,5.6531E+00_JPRB/)
KBO( :,32, 9) = (/&
&3.5834E+00_JPRB,4.0122E+00_JPRB,4.4950E+00_JPRB,5.0349E+00_JPRB,5.6294E+00_JPRB/)
KBO( :,33, 9) = (/&
&3.5101E+00_JPRB,3.9652E+00_JPRB,4.4790E+00_JPRB,5.0498E+00_JPRB,5.6789E+00_JPRB/)
KBO( :,34, 9) = (/&
&3.5050E+00_JPRB,3.9930E+00_JPRB,4.5402E+00_JPRB,5.1475E+00_JPRB,5.8191E+00_JPRB/)
KBO( :,35, 9) = (/&
&3.4979E+00_JPRB,4.0137E+00_JPRB,4.5890E+00_JPRB,5.2289E+00_JPRB,5.9375E+00_JPRB/)
KBO( :,36, 9) = (/&
&3.4706E+00_JPRB,4.0059E+00_JPRB,4.6026E+00_JPRB,5.2687E+00_JPRB,6.0062E+00_JPRB/)
KBO( :,37, 9) = (/&
&3.3275E+00_JPRB,3.8631E+00_JPRB,4.4602E+00_JPRB,5.1262E+00_JPRB,5.8660E+00_JPRB/)
KBO( :,38, 9) = (/&
&3.1941E+00_JPRB,3.7291E+00_JPRB,4.3242E+00_JPRB,4.9885E+00_JPRB,5.7266E+00_JPRB/)
KBO( :,39, 9) = (/&
&3.0740E+00_JPRB,3.6084E+00_JPRB,4.2006E+00_JPRB,4.8620E+00_JPRB,5.5962E+00_JPRB/)
KBO( :,40, 9) = (/&
&2.8552E+00_JPRB,3.3739E+00_JPRB,3.9447E+00_JPRB,4.5808E+00_JPRB,5.2902E+00_JPRB/)
KBO( :,41, 9) = (/&
&2.6380E+00_JPRB,3.1381E+00_JPRB,3.6872E+00_JPRB,4.2961E+00_JPRB,4.9750E+00_JPRB/)
KBO( :,42, 9) = (/&
&2.4342E+00_JPRB,2.9148E+00_JPRB,3.4437E+00_JPRB,4.0255E+00_JPRB,4.6737E+00_JPRB/)
KBO( :,43, 9) = (/&
&2.2073E+00_JPRB,2.6629E+00_JPRB,3.1662E+00_JPRB,3.7162E+00_JPRB,4.3269E+00_JPRB/)
KBO( :,44, 9) = (/&
&1.9815E+00_JPRB,2.4093E+00_JPRB,2.8849E+00_JPRB,3.4033E+00_JPRB,3.9755E+00_JPRB/)
KBO( :,45, 9) = (/&
&1.7719E+00_JPRB,2.1718E+00_JPRB,2.6189E+00_JPRB,3.1075E+00_JPRB,3.6437E+00_JPRB/)
KBO( :,46, 9) = (/&
&1.5723E+00_JPRB,1.9443E+00_JPRB,2.3619E+00_JPRB,2.8217E+00_JPRB,3.3236E+00_JPRB/)
KBO( :,47, 9) = (/&
&1.3802E+00_JPRB,1.7245E+00_JPRB,2.1129E+00_JPRB,2.5440E+00_JPRB,3.0139E+00_JPRB/)
KBO( :,48, 9) = (/&
&1.2042E+00_JPRB,1.5204E+00_JPRB,1.8800E+00_JPRB,2.2805E+00_JPRB,2.7207E+00_JPRB/)
KBO( :,49, 9) = (/&
&1.0431E+00_JPRB,1.3311E+00_JPRB,1.6618E+00_JPRB,2.0323E+00_JPRB,2.4425E+00_JPRB/)
KBO( :,50, 9) = (/&
&9.1020E-01_JPRB,1.1754E+00_JPRB,1.4811E+00_JPRB,1.8261E+00_JPRB,2.2093E+00_JPRB/)
KBO( :,51, 9) = (/&
&7.9478E-01_JPRB,1.0402E+00_JPRB,1.3230E+00_JPRB,1.6448E+00_JPRB,2.0037E+00_JPRB/)
KBO( :,52, 9) = (/&
&6.8856E-01_JPRB,9.1521E-01_JPRB,1.1763E+00_JPRB,1.4752E+00_JPRB,1.8102E+00_JPRB/)
KBO( :,53, 9) = (/&
&5.9135E-01_JPRB,7.9906E-01_JPRB,1.0400E+00_JPRB,1.3162E+00_JPRB,1.6282E+00_JPRB/)
KBO( :,54, 9) = (/&
&5.1488E-01_JPRB,7.0709E-01_JPRB,9.3257E-01_JPRB,1.1913E+00_JPRB,1.4845E+00_JPRB/)
KBO( :,55, 9) = (/&
&4.5023E-01_JPRB,6.2878E-01_JPRB,8.4073E-01_JPRB,1.0847E+00_JPRB,1.3619E+00_JPRB/)
KBO( :,56, 9) = (/&
&3.9100E-01_JPRB,5.5634E-01_JPRB,7.5480E-01_JPRB,9.8459E-01_JPRB,1.2461E+00_JPRB/)
KBO( :,57, 9) = (/&
&3.3683E-01_JPRB,4.8921E-01_JPRB,6.7380E-01_JPRB,8.9005E-01_JPRB,1.1368E+00_JPRB/)
KBO( :,58, 9) = (/&
&2.9052E-01_JPRB,4.3080E-01_JPRB,6.0283E-01_JPRB,8.0653E-01_JPRB,1.0401E+00_JPRB/)
KBO( :,59, 9) = (/&
&2.7497E-01_JPRB,4.1213E-01_JPRB,5.8166E-01_JPRB,7.8275E-01_JPRB,1.0139E+00_JPRB/)
KBO( :,13,10) = (/&
&6.2443E+01_JPRB,6.2764E+01_JPRB,6.3247E+01_JPRB,6.3715E+01_JPRB,6.4108E+01_JPRB/)
KBO( :,14,10) = (/&
&5.9985E+01_JPRB,6.0474E+01_JPRB,6.1209E+01_JPRB,6.1839E+01_JPRB,6.2132E+01_JPRB/)
KBO( :,15,10) = (/&
&5.6302E+01_JPRB,5.7213E+01_JPRB,5.7905E+01_JPRB,5.8328E+01_JPRB,5.8930E+01_JPRB/)
KBO( :,16,10) = (/&
&5.2360E+01_JPRB,5.3074E+01_JPRB,5.3755E+01_JPRB,5.4642E+01_JPRB,5.5349E+01_JPRB/)
KBO( :,17,10) = (/&
&4.8557E+01_JPRB,4.9472E+01_JPRB,5.0546E+01_JPRB,5.1358E+01_JPRB,5.2195E+01_JPRB/)
KBO( :,18,10) = (/&
&4.5817E+01_JPRB,4.7034E+01_JPRB,4.8009E+01_JPRB,4.9111E+01_JPRB,5.0457E+01_JPRB/)
KBO( :,19,10) = (/&
&4.3325E+01_JPRB,4.4456E+01_JPRB,4.5754E+01_JPRB,4.7330E+01_JPRB,4.8976E+01_JPRB/)
KBO( :,20,10) = (/&
&3.9745E+01_JPRB,4.1127E+01_JPRB,4.2837E+01_JPRB,4.4567E+01_JPRB,4.6284E+01_JPRB/)
KBO( :,21,10) = (/&
&3.6127E+01_JPRB,3.7823E+01_JPRB,3.9580E+01_JPRB,4.1335E+01_JPRB,4.3236E+01_JPRB/)
KBO( :,22,10) = (/&
&3.2661E+01_JPRB,3.4362E+01_JPRB,3.6109E+01_JPRB,3.8022E+01_JPRB,4.0162E+01_JPRB/)
KBO( :,23,10) = (/&
&2.9316E+01_JPRB,3.1011E+01_JPRB,3.2886E+01_JPRB,3.5036E+01_JPRB,3.7336E+01_JPRB/)
KBO( :,24,10) = (/&
&2.6133E+01_JPRB,2.7977E+01_JPRB,3.0126E+01_JPRB,3.2424E+01_JPRB,3.4907E+01_JPRB/)
KBO( :,25,10) = (/&
&2.3786E+01_JPRB,2.5903E+01_JPRB,2.8212E+01_JPRB,3.0718E+01_JPRB,3.3428E+01_JPRB/)
KBO( :,26,10) = (/&
&2.2187E+01_JPRB,2.4436E+01_JPRB,2.6979E+01_JPRB,2.9726E+01_JPRB,3.2775E+01_JPRB/)
KBO( :,27,10) = (/&
&2.0867E+01_JPRB,2.3290E+01_JPRB,2.6025E+01_JPRB,2.9060E+01_JPRB,3.2420E+01_JPRB/)
KBO( :,28,10) = (/&
&1.9963E+01_JPRB,2.2440E+01_JPRB,2.5348E+01_JPRB,2.8653E+01_JPRB,3.2222E+01_JPRB/)
KBO( :,29,10) = (/&
&1.9439E+01_JPRB,2.1951E+01_JPRB,2.4945E+01_JPRB,2.8411E+01_JPRB,3.2065E+01_JPRB/)
KBO( :,30,10) = (/&
&1.9217E+01_JPRB,2.1773E+01_JPRB,2.4822E+01_JPRB,2.8258E+01_JPRB,3.1954E+01_JPRB/)
KBO( :,31,10) = (/&
&1.9236E+01_JPRB,2.1821E+01_JPRB,2.4835E+01_JPRB,2.8172E+01_JPRB,3.1859E+01_JPRB/)
KBO( :,32,10) = (/&
&1.9497E+01_JPRB,2.2156E+01_JPRB,2.5072E+01_JPRB,2.8334E+01_JPRB,3.2036E+01_JPRB/)
KBO( :,33,10) = (/&
&1.9927E+01_JPRB,2.2649E+01_JPRB,2.5483E+01_JPRB,2.8731E+01_JPRB,3.2414E+01_JPRB/)
KBO( :,34,10) = (/&
&2.0616E+01_JPRB,2.3435E+01_JPRB,2.6339E+01_JPRB,2.9629E+01_JPRB,3.3264E+01_JPRB/)
KBO( :,35,10) = (/&
&2.1144E+01_JPRB,2.4078E+01_JPRB,2.7155E+01_JPRB,3.0411E+01_JPRB,3.3926E+01_JPRB/)
KBO( :,36,10) = (/&
&2.1438E+01_JPRB,2.4511E+01_JPRB,2.7776E+01_JPRB,3.1069E+01_JPRB,3.4391E+01_JPRB/)
KBO( :,37,10) = (/&
&2.0912E+01_JPRB,2.3999E+01_JPRB,2.7304E+01_JPRB,3.0662E+01_JPRB,3.3903E+01_JPRB/)
KBO( :,38,10) = (/&
&2.0345E+01_JPRB,2.3428E+01_JPRB,2.6766E+01_JPRB,3.0163E+01_JPRB,3.3445E+01_JPRB/)
KBO( :,39,10) = (/&
&1.9778E+01_JPRB,2.2831E+01_JPRB,2.6185E+01_JPRB,2.9606E+01_JPRB,3.2946E+01_JPRB/)
KBO( :,40,10) = (/&
&1.8680E+01_JPRB,2.1589E+01_JPRB,2.4845E+01_JPRB,2.8243E+01_JPRB,3.1561E+01_JPRB/)
KBO( :,41,10) = (/&
&1.7550E+01_JPRB,2.0318E+01_JPRB,2.3431E+01_JPRB,2.6770E+01_JPRB,3.0077E+01_JPRB/)
KBO( :,42,10) = (/&
&1.6473E+01_JPRB,1.9098E+01_JPRB,2.2042E+01_JPRB,2.5289E+01_JPRB,2.8560E+01_JPRB/)
KBO( :,43,10) = (/&
&1.5257E+01_JPRB,1.7707E+01_JPRB,2.0444E+01_JPRB,2.3540E+01_JPRB,2.6749E+01_JPRB/)
KBO( :,44,10) = (/&
&1.4023E+01_JPRB,1.6313E+01_JPRB,1.8839E+01_JPRB,2.1729E+01_JPRB,2.4856E+01_JPRB/)
KBO( :,45,10) = (/&
&1.2858E+01_JPRB,1.5005E+01_JPRB,1.7331E+01_JPRB,2.0013E+01_JPRB,2.3009E+01_JPRB/)
KBO( :,46,10) = (/&
&1.1732E+01_JPRB,1.3762E+01_JPRB,1.5932E+01_JPRB,1.8398E+01_JPRB,2.1229E+01_JPRB/)
KBO( :,47,10) = (/&
&1.0637E+01_JPRB,1.2563E+01_JPRB,1.4611E+01_JPRB,1.6882E+01_JPRB,1.9522E+01_JPRB/)
KBO( :,48,10) = (/&
&9.5989E+00_JPRB,1.1430E+01_JPRB,1.3382E+01_JPRB,1.5508E+01_JPRB,1.7946E+01_JPRB/)
KBO( :,49,10) = (/&
&8.6105E+00_JPRB,1.0367E+01_JPRB,1.2235E+01_JPRB,1.4247E+01_JPRB,1.6502E+01_JPRB/)
KBO( :,50,10) = (/&
&7.7795E+00_JPRB,9.4717E+00_JPRB,1.1267E+01_JPRB,1.3203E+01_JPRB,1.5335E+01_JPRB/)
KBO( :,51,10) = (/&
&7.0327E+00_JPRB,8.6531E+00_JPRB,1.0392E+01_JPRB,1.2262E+01_JPRB,1.4298E+01_JPRB/)
KBO( :,52,10) = (/&
&6.3294E+00_JPRB,7.8785E+00_JPRB,9.5601E+00_JPRB,1.1364E+01_JPRB,1.3321E+01_JPRB/)
KBO( :,53,10) = (/&
&5.6735E+00_JPRB,7.1473E+00_JPRB,8.7577E+00_JPRB,1.0501E+01_JPRB,1.2384E+01_JPRB/)
KBO( :,54,10) = (/&
&5.1171E+00_JPRB,6.5109E+00_JPRB,8.0578E+00_JPRB,9.7452E+00_JPRB,1.1565E+01_JPRB/)
KBO( :,55,10) = (/&
&4.6203E+00_JPRB,5.9356E+00_JPRB,7.4153E+00_JPRB,9.0377E+00_JPRB,1.0796E+01_JPRB/)
KBO( :,56,10) = (/&
&4.1502E+00_JPRB,5.3934E+00_JPRB,6.7922E+00_JPRB,8.3512E+00_JPRB,1.0055E+01_JPRB/)
KBO( :,57,10) = (/&
&3.7055E+00_JPRB,4.8827E+00_JPRB,6.2007E+00_JPRB,7.6928E+00_JPRB,9.3383E+00_JPRB/)
KBO( :,58,10) = (/&
&3.3017E+00_JPRB,4.4251E+00_JPRB,5.6661E+00_JPRB,7.0836E+00_JPRB,8.6693E+00_JPRB/)
KBO( :,59,10) = (/&
&3.1387E+00_JPRB,4.2362E+00_JPRB,5.4398E+00_JPRB,6.8151E+00_JPRB,8.3756E+00_JPRB/)
KBO( :,13,11) = (/&
&8.6501E+01_JPRB,8.6756E+01_JPRB,8.7009E+01_JPRB,8.7807E+01_JPRB,8.8321E+01_JPRB/)
KBO( :,14,11) = (/&
&8.6001E+01_JPRB,8.6390E+01_JPRB,8.7153E+01_JPRB,8.7884E+01_JPRB,8.8485E+01_JPRB/)
KBO( :,15,11) = (/&
&8.3396E+01_JPRB,8.4271E+01_JPRB,8.5263E+01_JPRB,8.6231E+01_JPRB,8.7169E+01_JPRB/)
KBO( :,16,11) = (/&
&8.0216E+01_JPRB,8.1367E+01_JPRB,8.2641E+01_JPRB,8.3850E+01_JPRB,8.5113E+01_JPRB/)
KBO( :,17,11) = (/&
&7.7559E+01_JPRB,7.9123E+01_JPRB,8.0637E+01_JPRB,8.2229E+01_JPRB,8.3780E+01_JPRB/)
KBO( :,18,11) = (/&
&7.6113E+01_JPRB,7.8038E+01_JPRB,8.0039E+01_JPRB,8.1955E+01_JPRB,8.3906E+01_JPRB/)
KBO( :,19,11) = (/&
&7.4701E+01_JPRB,7.7061E+01_JPRB,7.9341E+01_JPRB,8.1777E+01_JPRB,8.4316E+01_JPRB/)
KBO( :,20,11) = (/&
&7.1644E+01_JPRB,7.4182E+01_JPRB,7.6892E+01_JPRB,7.9840E+01_JPRB,8.2902E+01_JPRB/)
KBO( :,21,11) = (/&
&6.7620E+01_JPRB,7.0516E+01_JPRB,7.3720E+01_JPRB,7.7152E+01_JPRB,8.0637E+01_JPRB/)
KBO( :,22,11) = (/&
&6.3004E+01_JPRB,6.6364E+01_JPRB,7.0039E+01_JPRB,7.3871E+01_JPRB,7.7820E+01_JPRB/)
KBO( :,23,11) = (/&
&5.8500E+01_JPRB,6.2279E+01_JPRB,6.6312E+01_JPRB,7.0504E+01_JPRB,7.4998E+01_JPRB/)
KBO( :,24,11) = (/&
&5.3727E+01_JPRB,5.7825E+01_JPRB,6.2144E+01_JPRB,6.6890E+01_JPRB,7.2071E+01_JPRB/)
KBO( :,25,11) = (/&
&4.9481E+01_JPRB,5.3871E+01_JPRB,5.8717E+01_JPRB,6.4044E+01_JPRB,6.9704E+01_JPRB/)
KBO( :,26,11) = (/&
&4.6254E+01_JPRB,5.1111E+01_JPRB,5.6460E+01_JPRB,6.2228E+01_JPRB,6.8093E+01_JPRB/)
KBO( :,27,11) = (/&
&4.3953E+01_JPRB,4.9258E+01_JPRB,5.5047E+01_JPRB,6.1083E+01_JPRB,6.7149E+01_JPRB/)
KBO( :,28,11) = (/&
&4.2333E+01_JPRB,4.8051E+01_JPRB,5.4161E+01_JPRB,6.0348E+01_JPRB,6.6482E+01_JPRB/)
KBO( :,29,11) = (/&
&4.1519E+01_JPRB,4.7571E+01_JPRB,5.3856E+01_JPRB,6.0162E+01_JPRB,6.6490E+01_JPRB/)
KBO( :,30,11) = (/&
&4.1079E+01_JPRB,4.7326E+01_JPRB,5.3742E+01_JPRB,6.0205E+01_JPRB,6.6744E+01_JPRB/)
KBO( :,31,11) = (/&
&4.0957E+01_JPRB,4.7315E+01_JPRB,5.3845E+01_JPRB,6.0494E+01_JPRB,6.7153E+01_JPRB/)
KBO( :,32,11) = (/&
&4.1227E+01_JPRB,4.7602E+01_JPRB,5.4282E+01_JPRB,6.1081E+01_JPRB,6.7763E+01_JPRB/)
KBO( :,33,11) = (/&
&4.1826E+01_JPRB,4.8137E+01_JPRB,5.4944E+01_JPRB,6.1784E+01_JPRB,6.8374E+01_JPRB/)
KBO( :,34,11) = (/&
&4.3072E+01_JPRB,4.9391E+01_JPRB,5.6254E+01_JPRB,6.3099E+01_JPRB,6.9725E+01_JPRB/)
KBO( :,35,11) = (/&
&4.3986E+01_JPRB,5.0200E+01_JPRB,5.6858E+01_JPRB,6.3640E+01_JPRB,7.0415E+01_JPRB/)
KBO( :,36,11) = (/&
&4.4502E+01_JPRB,5.0408E+01_JPRB,5.6628E+01_JPRB,6.3171E+01_JPRB,7.0200E+01_JPRB/)
KBO( :,37,11) = (/&
&4.3850E+01_JPRB,4.9526E+01_JPRB,5.5508E+01_JPRB,6.1846E+01_JPRB,6.8955E+01_JPRB/)
KBO( :,38,11) = (/&
&4.3288E+01_JPRB,4.8717E+01_JPRB,5.4460E+01_JPRB,6.0601E+01_JPRB,6.7672E+01_JPRB/)
KBO( :,39,11) = (/&
&4.2793E+01_JPRB,4.8055E+01_JPRB,5.3543E+01_JPRB,5.9508E+01_JPRB,6.6570E+01_JPRB/)
KBO( :,40,11) = (/&
&4.0982E+01_JPRB,4.6218E+01_JPRB,5.1475E+01_JPRB,5.7189E+01_JPRB,6.4026E+01_JPRB/)
KBO( :,41,11) = (/&
&3.9015E+01_JPRB,4.4241E+01_JPRB,4.9337E+01_JPRB,5.4818E+01_JPRB,6.1396E+01_JPRB/)
KBO( :,42,11) = (/&
&3.7029E+01_JPRB,4.2233E+01_JPRB,4.7279E+01_JPRB,5.2574E+01_JPRB,5.8917E+01_JPRB/)
KBO( :,43,11) = (/&
&3.4672E+01_JPRB,3.9813E+01_JPRB,4.4910E+01_JPRB,5.0015E+01_JPRB,5.6019E+01_JPRB/)
KBO( :,44,11) = (/&
&3.2216E+01_JPRB,3.7254E+01_JPRB,4.2367E+01_JPRB,4.7396E+01_JPRB,5.3071E+01_JPRB/)
KBO( :,45,11) = (/&
&2.9847E+01_JPRB,3.4776E+01_JPRB,3.9855E+01_JPRB,4.4920E+01_JPRB,5.0317E+01_JPRB/)
KBO( :,46,11) = (/&
&2.7555E+01_JPRB,3.2329E+01_JPRB,3.7304E+01_JPRB,4.2424E+01_JPRB,4.7633E+01_JPRB/)
KBO( :,47,11) = (/&
&2.5262E+01_JPRB,2.9854E+01_JPRB,3.4721E+01_JPRB,3.9795E+01_JPRB,4.4945E+01_JPRB/)
KBO( :,48,11) = (/&
&2.3081E+01_JPRB,2.7503E+01_JPRB,3.2213E+01_JPRB,3.7177E+01_JPRB,4.2342E+01_JPRB/)
KBO( :,49,11) = (/&
&2.1057E+01_JPRB,2.5246E+01_JPRB,2.9758E+01_JPRB,3.4602E+01_JPRB,3.9727E+01_JPRB/)
KBO( :,50,11) = (/&
&1.9318E+01_JPRB,2.3248E+01_JPRB,2.7618E+01_JPRB,3.2289E+01_JPRB,3.7300E+01_JPRB/)
KBO( :,51,11) = (/&
&1.7764E+01_JPRB,2.1445E+01_JPRB,2.5630E+01_JPRB,3.0117E+01_JPRB,3.5003E+01_JPRB/)
KBO( :,52,11) = (/&
&1.6284E+01_JPRB,1.9745E+01_JPRB,2.3706E+01_JPRB,2.8037E+01_JPRB,3.2754E+01_JPRB/)
KBO( :,53,11) = (/&
&1.4870E+01_JPRB,1.8170E+01_JPRB,2.1878E+01_JPRB,2.6032E+01_JPRB,3.0559E+01_JPRB/)
KBO( :,54,11) = (/&
&1.3618E+01_JPRB,1.6796E+01_JPRB,2.0287E+01_JPRB,2.4249E+01_JPRB,2.8597E+01_JPRB/)
KBO( :,55,11) = (/&
&1.2457E+01_JPRB,1.5534E+01_JPRB,1.8860E+01_JPRB,2.2616E+01_JPRB,2.6796E+01_JPRB/)
KBO( :,56,11) = (/&
&1.1356E+01_JPRB,1.4314E+01_JPRB,1.7512E+01_JPRB,2.1058E+01_JPRB,2.5045E+01_JPRB/)
KBO( :,57,11) = (/&
&1.0320E+01_JPRB,1.3127E+01_JPRB,1.6224E+01_JPRB,1.9585E+01_JPRB,2.3359E+01_JPRB/)
KBO( :,58,11) = (/&
&9.3830E+00_JPRB,1.2046E+01_JPRB,1.5046E+01_JPRB,1.8261E+01_JPRB,2.1817E+01_JPRB/)
KBO( :,59,11) = (/&
&8.9391E+00_JPRB,1.1539E+01_JPRB,1.4477E+01_JPRB,1.7622E+01_JPRB,2.1055E+01_JPRB/)
KBO( :,13,12) = (/&
&1.1536E+02_JPRB,1.1632E+02_JPRB,1.1676E+02_JPRB,1.1687E+02_JPRB,1.1771E+02_JPRB/)
KBO( :,14,12) = (/&
&1.1996E+02_JPRB,1.2089E+02_JPRB,1.2132E+02_JPRB,1.2216E+02_JPRB,1.2355E+02_JPRB/)
KBO( :,15,12) = (/&
&1.2190E+02_JPRB,1.2270E+02_JPRB,1.2390E+02_JPRB,1.2571E+02_JPRB,1.2681E+02_JPRB/)
KBO( :,16,12) = (/&
&1.2181E+02_JPRB,1.2365E+02_JPRB,1.2585E+02_JPRB,1.2744E+02_JPRB,1.2865E+02_JPRB/)
KBO( :,17,12) = (/&
&1.2361E+02_JPRB,1.2611E+02_JPRB,1.2809E+02_JPRB,1.2991E+02_JPRB,1.3207E+02_JPRB/)
KBO( :,18,12) = (/&
&1.2791E+02_JPRB,1.3042E+02_JPRB,1.3285E+02_JPRB,1.3575E+02_JPRB,1.3866E+02_JPRB/)
KBO( :,19,12) = (/&
&1.3167E+02_JPRB,1.3492E+02_JPRB,1.3862E+02_JPRB,1.4230E+02_JPRB,1.4589E+02_JPRB/)
KBO( :,20,12) = (/&
&1.3240E+02_JPRB,1.3677E+02_JPRB,1.4130E+02_JPRB,1.4568E+02_JPRB,1.5011E+02_JPRB/)
KBO( :,21,12) = (/&
&1.3167E+02_JPRB,1.3705E+02_JPRB,1.4232E+02_JPRB,1.4765E+02_JPRB,1.5295E+02_JPRB/)
KBO( :,22,12) = (/&
&1.2941E+02_JPRB,1.3568E+02_JPRB,1.4188E+02_JPRB,1.4812E+02_JPRB,1.5420E+02_JPRB/)
KBO( :,23,12) = (/&
&1.2650E+02_JPRB,1.3362E+02_JPRB,1.4090E+02_JPRB,1.4804E+02_JPRB,1.5493E+02_JPRB/)
KBO( :,24,12) = (/&
&1.2203E+02_JPRB,1.3010E+02_JPRB,1.3824E+02_JPRB,1.4621E+02_JPRB,1.5349E+02_JPRB/)
KBO( :,25,12) = (/&
&1.1780E+02_JPRB,1.2675E+02_JPRB,1.3578E+02_JPRB,1.4425E+02_JPRB,1.5220E+02_JPRB/)
KBO( :,26,12) = (/&
&1.1452E+02_JPRB,1.2433E+02_JPRB,1.3394E+02_JPRB,1.4292E+02_JPRB,1.5154E+02_JPRB/)
KBO( :,27,12) = (/&
&1.1158E+02_JPRB,1.2202E+02_JPRB,1.3200E+02_JPRB,1.4156E+02_JPRB,1.5071E+02_JPRB/)
KBO( :,28,12) = (/&
&1.0877E+02_JPRB,1.1953E+02_JPRB,1.2986E+02_JPRB,1.3983E+02_JPRB,1.4949E+02_JPRB/)
KBO( :,29,12) = (/&
&1.0758E+02_JPRB,1.1863E+02_JPRB,1.2937E+02_JPRB,1.3977E+02_JPRB,1.4973E+02_JPRB/)
KBO( :,30,12) = (/&
&1.0679E+02_JPRB,1.1811E+02_JPRB,1.2916E+02_JPRB,1.3989E+02_JPRB,1.4980E+02_JPRB/)
KBO( :,31,12) = (/&
&1.0688E+02_JPRB,1.1849E+02_JPRB,1.2989E+02_JPRB,1.4068E+02_JPRB,1.5077E+02_JPRB/)
KBO( :,32,12) = (/&
&1.0761E+02_JPRB,1.1953E+02_JPRB,1.3110E+02_JPRB,1.4225E+02_JPRB,1.5305E+02_JPRB/)
KBO( :,33,12) = (/&
&1.0869E+02_JPRB,1.2092E+02_JPRB,1.3311E+02_JPRB,1.4513E+02_JPRB,1.5706E+02_JPRB/)
KBO( :,34,12) = (/&
&1.1112E+02_JPRB,1.2403E+02_JPRB,1.3695E+02_JPRB,1.4972E+02_JPRB,1.6276E+02_JPRB/)
KBO( :,35,12) = (/&
&1.1246E+02_JPRB,1.2623E+02_JPRB,1.4002E+02_JPRB,1.5398E+02_JPRB,1.6809E+02_JPRB/)
KBO( :,36,12) = (/&
&1.1250E+02_JPRB,1.2737E+02_JPRB,1.4246E+02_JPRB,1.5783E+02_JPRB,1.7316E+02_JPRB/)
KBO( :,37,12) = (/&
&1.1061E+02_JPRB,1.2593E+02_JPRB,1.4155E+02_JPRB,1.5744E+02_JPRB,1.7321E+02_JPRB/)
KBO( :,38,12) = (/&
&1.0863E+02_JPRB,1.2441E+02_JPRB,1.4054E+02_JPRB,1.5693E+02_JPRB,1.7309E+02_JPRB/)
KBO( :,39,12) = (/&
&1.0682E+02_JPRB,1.2301E+02_JPRB,1.3972E+02_JPRB,1.5664E+02_JPRB,1.7318E+02_JPRB/)
KBO( :,40,12) = (/&
&1.0231E+02_JPRB,1.1830E+02_JPRB,1.3525E+02_JPRB,1.5235E+02_JPRB,1.6904E+02_JPRB/)
KBO( :,41,12) = (/&
&9.7591E+01_JPRB,1.1325E+02_JPRB,1.3028E+02_JPRB,1.4750E+02_JPRB,1.6434E+02_JPRB/)
KBO( :,42,12) = (/&
&9.3027E+01_JPRB,1.0842E+02_JPRB,1.2533E+02_JPRB,1.4267E+02_JPRB,1.5965E+02_JPRB/)
KBO( :,43,12) = (/&
&8.7538E+01_JPRB,1.0245E+02_JPRB,1.1885E+02_JPRB,1.3623E+02_JPRB,1.5326E+02_JPRB/)
KBO( :,44,12) = (/&
&8.1886E+01_JPRB,9.6138E+01_JPRB,1.1198E+02_JPRB,1.2909E+02_JPRB,1.4608E+02_JPRB/)
KBO( :,45,12) = (/&
&7.6645E+01_JPRB,9.0087E+01_JPRB,1.0542E+02_JPRB,1.2199E+02_JPRB,1.3900E+02_JPRB/)
KBO( :,46,12) = (/&
&7.1474E+01_JPRB,8.4055E+01_JPRB,9.8742E+01_JPRB,1.1474E+02_JPRB,1.3156E+02_JPRB/)
KBO( :,47,12) = (/&
&6.6310E+01_JPRB,7.7963E+01_JPRB,9.1690E+01_JPRB,1.0705E+02_JPRB,1.2340E+02_JPRB/)
KBO( :,48,12) = (/&
&6.1600E+01_JPRB,7.2276E+01_JPRB,8.5037E+01_JPRB,9.9673E+01_JPRB,1.1542E+02_JPRB/)
KBO( :,49,12) = (/&
&5.7283E+01_JPRB,6.7050E+01_JPRB,7.8923E+01_JPRB,9.2652E+01_JPRB,1.0778E+02_JPRB/)
KBO( :,50,12) = (/&
&5.3478E+01_JPRB,6.2571E+01_JPRB,7.3516E+01_JPRB,8.6380E+01_JPRB,1.0082E+02_JPRB/)
KBO( :,51,12) = (/&
&4.9875E+01_JPRB,5.8576E+01_JPRB,6.8672E+01_JPRB,8.0731E+01_JPRB,9.4376E+01_JPRB/)
KBO( :,52,12) = (/&
&4.6408E+01_JPRB,5.4871E+01_JPRB,6.4185E+01_JPRB,7.5407E+01_JPRB,8.8241E+01_JPRB/)
KBO( :,53,12) = (/&
&4.3049E+01_JPRB,5.1245E+01_JPRB,6.0053E+01_JPRB,7.0436E+01_JPRB,8.2512E+01_JPRB/)
KBO( :,54,12) = (/&
&4.0074E+01_JPRB,4.8005E+01_JPRB,5.6523E+01_JPRB,6.6130E+01_JPRB,7.7483E+01_JPRB/)
KBO( :,55,12) = (/&
&3.7334E+01_JPRB,4.4988E+01_JPRB,5.3284E+01_JPRB,6.2287E+01_JPRB,7.2912E+01_JPRB/)
KBO( :,56,12) = (/&
&3.4721E+01_JPRB,4.2060E+01_JPRB,5.0133E+01_JPRB,5.8707E+01_JPRB,6.8606E+01_JPRB/)
KBO( :,57,12) = (/&
&3.2171E+01_JPRB,3.9229E+01_JPRB,4.7079E+01_JPRB,5.5373E+01_JPRB,6.4605E+01_JPRB/)
KBO( :,58,12) = (/&
&2.9794E+01_JPRB,3.6617E+01_JPRB,4.4198E+01_JPRB,5.2314E+01_JPRB,6.1016E+01_JPRB/)
KBO( :,59,12) = (/&
&2.8699E+01_JPRB,3.5397E+01_JPRB,4.2806E+01_JPRB,5.0814E+01_JPRB,5.9273E+01_JPRB/)
KBO( :,13,13) = (/&
&1.6492E+02_JPRB,1.6388E+02_JPRB,1.6346E+02_JPRB,1.6281E+02_JPRB,1.6185E+02_JPRB/)
KBO( :,14,13) = (/&
&1.7807E+02_JPRB,1.7770E+02_JPRB,1.7743E+02_JPRB,1.7669E+02_JPRB,1.7598E+02_JPRB/)
KBO( :,15,13) = (/&
&1.8993E+02_JPRB,1.9024E+02_JPRB,1.8997E+02_JPRB,1.8962E+02_JPRB,1.9043E+02_JPRB/)
KBO( :,16,13) = (/&
&2.0050E+02_JPRB,2.0095E+02_JPRB,2.0135E+02_JPRB,2.0291E+02_JPRB,2.0501E+02_JPRB/)
KBO( :,17,13) = (/&
&2.0905E+02_JPRB,2.1062E+02_JPRB,2.1338E+02_JPRB,2.1661E+02_JPRB,2.1875E+02_JPRB/)
KBO( :,18,13) = (/&
&2.1804E+02_JPRB,2.2224E+02_JPRB,2.2674E+02_JPRB,2.3000E+02_JPRB,2.3246E+02_JPRB/)
KBO( :,19,13) = (/&
&2.3115E+02_JPRB,2.3655E+02_JPRB,2.4106E+02_JPRB,2.4477E+02_JPRB,2.4852E+02_JPRB/)
KBO( :,20,13) = (/&
&2.4329E+02_JPRB,2.4898E+02_JPRB,2.5395E+02_JPRB,2.5885E+02_JPRB,2.6364E+02_JPRB/)
KBO( :,21,13) = (/&
&2.5437E+02_JPRB,2.6055E+02_JPRB,2.6661E+02_JPRB,2.7260E+02_JPRB,2.7787E+02_JPRB/)
KBO( :,22,13) = (/&
&2.6250E+02_JPRB,2.7007E+02_JPRB,2.7766E+02_JPRB,2.8448E+02_JPRB,2.9027E+02_JPRB/)
KBO( :,23,13) = (/&
&2.6919E+02_JPRB,2.7869E+02_JPRB,2.8736E+02_JPRB,2.9473E+02_JPRB,3.0099E+02_JPRB/)
KBO( :,24,13) = (/&
&2.7228E+02_JPRB,2.8325E+02_JPRB,2.9264E+02_JPRB,3.0066E+02_JPRB,3.0797E+02_JPRB/)
KBO( :,25,13) = (/&
&2.7478E+02_JPRB,2.8650E+02_JPRB,2.9632E+02_JPRB,3.0547E+02_JPRB,3.1366E+02_JPRB/)
KBO( :,26,13) = (/&
&2.7718E+02_JPRB,2.8924E+02_JPRB,3.0014E+02_JPRB,3.1019E+02_JPRB,3.1917E+02_JPRB/)
KBO( :,27,13) = (/&
&2.7773E+02_JPRB,2.9063E+02_JPRB,3.0281E+02_JPRB,3.1393E+02_JPRB,3.2342E+02_JPRB/)
KBO( :,28,13) = (/&
&2.7669E+02_JPRB,2.9127E+02_JPRB,3.0469E+02_JPRB,3.1685E+02_JPRB,3.2697E+02_JPRB/)
KBO( :,29,13) = (/&
&2.7898E+02_JPRB,2.9479E+02_JPRB,3.0937E+02_JPRB,3.2216E+02_JPRB,3.3294E+02_JPRB/)
KBO( :,30,13) = (/&
&2.8228E+02_JPRB,2.9938E+02_JPRB,3.1508E+02_JPRB,3.2858E+02_JPRB,3.4068E+02_JPRB/)
KBO( :,31,13) = (/&
&2.8807E+02_JPRB,3.0670E+02_JPRB,3.2315E+02_JPRB,3.3792E+02_JPRB,3.5112E+02_JPRB/)
KBO( :,32,13) = (/&
&2.9599E+02_JPRB,3.1568E+02_JPRB,3.3326E+02_JPRB,3.4888E+02_JPRB,3.6266E+02_JPRB/)
KBO( :,33,13) = (/&
&3.0608E+02_JPRB,3.2668E+02_JPRB,3.4478E+02_JPRB,3.6084E+02_JPRB,3.7554E+02_JPRB/)
KBO( :,34,13) = (/&
&3.1667E+02_JPRB,3.3765E+02_JPRB,3.5613E+02_JPRB,3.7316E+02_JPRB,3.8829E+02_JPRB/)
KBO( :,35,13) = (/&
&3.2596E+02_JPRB,3.4758E+02_JPRB,3.6720E+02_JPRB,3.8537E+02_JPRB,4.0075E+02_JPRB/)
KBO( :,36,13) = (/&
&3.3359E+02_JPRB,3.5628E+02_JPRB,3.7747E+02_JPRB,3.9672E+02_JPRB,4.1282E+02_JPRB/)
KBO( :,37,13) = (/&
&3.3360E+02_JPRB,3.5721E+02_JPRB,3.7933E+02_JPRB,3.9940E+02_JPRB,4.1630E+02_JPRB/)
KBO( :,38,13) = (/&
&3.3326E+02_JPRB,3.5780E+02_JPRB,3.8082E+02_JPRB,4.0174E+02_JPRB,4.1947E+02_JPRB/)
KBO( :,39,13) = (/&
&3.3309E+02_JPRB,3.5850E+02_JPRB,3.8253E+02_JPRB,4.0436E+02_JPRB,4.2297E+02_JPRB/)
KBO( :,40,13) = (/&
&3.2648E+02_JPRB,3.5268E+02_JPRB,3.7698E+02_JPRB,3.9960E+02_JPRB,4.1913E+02_JPRB/)
KBO( :,41,13) = (/&
&3.1896E+02_JPRB,3.4578E+02_JPRB,3.7035E+02_JPRB,3.9368E+02_JPRB,4.1397E+02_JPRB/)
KBO( :,42,13) = (/&
&3.1112E+02_JPRB,3.3866E+02_JPRB,3.6362E+02_JPRB,3.8746E+02_JPRB,4.0853E+02_JPRB/)
KBO( :,43,13) = (/&
&3.0052E+02_JPRB,3.2869E+02_JPRB,3.5427E+02_JPRB,3.7807E+02_JPRB,3.9999E+02_JPRB/)
KBO( :,44,13) = (/&
&2.8853E+02_JPRB,3.1745E+02_JPRB,3.4358E+02_JPRB,3.6752E+02_JPRB,3.9013E+02_JPRB/)
KBO( :,45,13) = (/&
&2.7601E+02_JPRB,3.0588E+02_JPRB,3.3279E+02_JPRB,3.5705E+02_JPRB,3.7967E+02_JPRB/)
KBO( :,46,13) = (/&
&2.6267E+02_JPRB,2.9363E+02_JPRB,3.2123E+02_JPRB,3.4597E+02_JPRB,3.6877E+02_JPRB/)
KBO( :,47,13) = (/&
&2.4757E+02_JPRB,2.7937E+02_JPRB,3.0805E+02_JPRB,3.3376E+02_JPRB,3.5676E+02_JPRB/)
KBO( :,48,13) = (/&
&2.3214E+02_JPRB,2.6483E+02_JPRB,2.9482E+02_JPRB,3.2128E+02_JPRB,3.4490E+02_JPRB/)
KBO( :,49,13) = (/&
&2.1667E+02_JPRB,2.4994E+02_JPRB,2.8075E+02_JPRB,3.0839E+02_JPRB,3.3291E+02_JPRB/)
KBO( :,50,13) = (/&
&2.0214E+02_JPRB,2.3567E+02_JPRB,2.6727E+02_JPRB,2.9615E+02_JPRB,3.2136E+02_JPRB/)
KBO( :,51,13) = (/&
&1.8827E+02_JPRB,2.2174E+02_JPRB,2.5386E+02_JPRB,2.8344E+02_JPRB,3.0975E+02_JPRB/)
KBO( :,52,13) = (/&
&1.7469E+02_JPRB,2.0766E+02_JPRB,2.4021E+02_JPRB,2.7051E+02_JPRB,2.9806E+02_JPRB/)
KBO( :,53,13) = (/&
&1.6154E+02_JPRB,1.9380E+02_JPRB,2.2644E+02_JPRB,2.5730E+02_JPRB,2.8551E+02_JPRB/)
KBO( :,54,13) = (/&
&1.4971E+02_JPRB,1.8121E+02_JPRB,2.1351E+02_JPRB,2.4474E+02_JPRB,2.7363E+02_JPRB/)
KBO( :,55,13) = (/&
&1.3871E+02_JPRB,1.6943E+02_JPRB,2.0115E+02_JPRB,2.3248E+02_JPRB,2.6185E+02_JPRB/)
KBO( :,56,13) = (/&
&1.2829E+02_JPRB,1.5787E+02_JPRB,1.8899E+02_JPRB,2.2029E+02_JPRB,2.4989E+02_JPRB/)
KBO( :,57,13) = (/&
&1.1862E+02_JPRB,1.4668E+02_JPRB,1.7707E+02_JPRB,2.0801E+02_JPRB,2.3778E+02_JPRB/)
KBO( :,58,13) = (/&
&1.1001E+02_JPRB,1.3648E+02_JPRB,1.6587E+02_JPRB,1.9633E+02_JPRB,2.2625E+02_JPRB/)
KBO( :,59,13) = (/&
&1.0617E+02_JPRB,1.3192E+02_JPRB,1.6056E+02_JPRB,1.9063E+02_JPRB,2.2036E+02_JPRB/)
KBO( :,13,14) = (/&
&2.3740E+02_JPRB,2.3433E+02_JPRB,2.3150E+02_JPRB,2.2987E+02_JPRB,2.2791E+02_JPRB/)
KBO( :,14,14) = (/&
&2.6697E+02_JPRB,2.6354E+02_JPRB,2.6091E+02_JPRB,2.5890E+02_JPRB,2.5611E+02_JPRB/)
KBO( :,15,14) = (/&
&2.9866E+02_JPRB,2.9528E+02_JPRB,2.9285E+02_JPRB,2.8971E+02_JPRB,2.8602E+02_JPRB/)
KBO( :,16,14) = (/&
&3.3180E+02_JPRB,3.2877E+02_JPRB,3.2564E+02_JPRB,3.2149E+02_JPRB,3.1785E+02_JPRB/)
KBO( :,17,14) = (/&
&3.6593E+02_JPRB,3.6291E+02_JPRB,3.5866E+02_JPRB,3.5483E+02_JPRB,3.5327E+02_JPRB/)
KBO( :,18,14) = (/&
&4.0089E+02_JPRB,3.9701E+02_JPRB,3.9353E+02_JPRB,3.9249E+02_JPRB,3.9242E+02_JPRB/)
KBO( :,19,14) = (/&
&4.3492E+02_JPRB,4.3255E+02_JPRB,4.3249E+02_JPRB,4.3314E+02_JPRB,4.3203E+02_JPRB/)
KBO( :,20,14) = (/&
&4.6851E+02_JPRB,4.6867E+02_JPRB,4.6996E+02_JPRB,4.7008E+02_JPRB,4.6768E+02_JPRB/)
KBO( :,21,14) = (/&
&5.0160E+02_JPRB,5.0368E+02_JPRB,5.0510E+02_JPRB,5.0393E+02_JPRB,5.0142E+02_JPRB/)
KBO( :,22,14) = (/&
&5.3436E+02_JPRB,5.3662E+02_JPRB,5.3668E+02_JPRB,5.3522E+02_JPRB,5.3316E+02_JPRB/)
KBO( :,23,14) = (/&
&5.6475E+02_JPRB,5.6646E+02_JPRB,5.6617E+02_JPRB,5.6492E+02_JPRB,5.6377E+02_JPRB/)
KBO( :,24,14) = (/&
&5.9117E+02_JPRB,5.9235E+02_JPRB,5.9305E+02_JPRB,5.9284E+02_JPRB,5.9155E+02_JPRB/)
KBO( :,25,14) = (/&
&6.1433E+02_JPRB,6.1663E+02_JPRB,6.1844E+02_JPRB,6.1841E+02_JPRB,6.1657E+02_JPRB/)
KBO( :,26,14) = (/&
&6.3532E+02_JPRB,6.3942E+02_JPRB,6.4146E+02_JPRB,6.4105E+02_JPRB,6.3887E+02_JPRB/)
KBO( :,27,14) = (/&
&6.5539E+02_JPRB,6.6044E+02_JPRB,6.6224E+02_JPRB,6.6141E+02_JPRB,6.5941E+02_JPRB/)
KBO( :,28,14) = (/&
&6.7497E+02_JPRB,6.7980E+02_JPRB,6.8130E+02_JPRB,6.7994E+02_JPRB,6.7811E+02_JPRB/)
KBO( :,29,14) = (/&
&6.9431E+02_JPRB,6.9884E+02_JPRB,6.9950E+02_JPRB,6.9835E+02_JPRB,6.9642E+02_JPRB/)
KBO( :,30,14) = (/&
&7.1327E+02_JPRB,7.1751E+02_JPRB,7.1742E+02_JPRB,7.1698E+02_JPRB,7.1542E+02_JPRB/)
KBO( :,31,14) = (/&
&7.3356E+02_JPRB,7.3622E+02_JPRB,7.3751E+02_JPRB,7.3724E+02_JPRB,7.3663E+02_JPRB/)
KBO( :,32,14) = (/&
&7.5311E+02_JPRB,7.5602E+02_JPRB,7.5787E+02_JPRB,7.5927E+02_JPRB,7.5912E+02_JPRB/)
KBO( :,33,14) = (/&
&7.7307E+02_JPRB,7.7793E+02_JPRB,7.8149E+02_JPRB,7.8317E+02_JPRB,7.8351E+02_JPRB/)
KBO( :,34,14) = (/&
&7.9467E+02_JPRB,8.0056E+02_JPRB,8.0525E+02_JPRB,8.0749E+02_JPRB,8.0900E+02_JPRB/)
KBO( :,35,14) = (/&
&8.1769E+02_JPRB,8.2551E+02_JPRB,8.3062E+02_JPRB,8.3402E+02_JPRB,8.3937E+02_JPRB/)
KBO( :,36,14) = (/&
&8.4220E+02_JPRB,8.5215E+02_JPRB,8.5810E+02_JPRB,8.6400E+02_JPRB,8.7476E+02_JPRB/)
KBO( :,37,14) = (/&
&8.5305E+02_JPRB,8.6405E+02_JPRB,8.7082E+02_JPRB,8.7797E+02_JPRB,8.9053E+02_JPRB/)
KBO( :,38,14) = (/&
&8.6322E+02_JPRB,8.7544E+02_JPRB,8.8314E+02_JPRB,8.9164E+02_JPRB,9.0590E+02_JPRB/)
KBO( :,39,14) = (/&
&8.7378E+02_JPRB,8.8745E+02_JPRB,8.9629E+02_JPRB,9.0629E+02_JPRB,9.2255E+02_JPRB/)
KBO( :,40,14) = (/&
&8.7238E+02_JPRB,8.8620E+02_JPRB,8.9614E+02_JPRB,9.0579E+02_JPRB,9.1970E+02_JPRB/)
KBO( :,41,14) = (/&
&8.6852E+02_JPRB,8.8300E+02_JPRB,8.9419E+02_JPRB,9.0301E+02_JPRB,9.1475E+02_JPRB/)
KBO( :,42,14) = (/&
&8.6436E+02_JPRB,8.7945E+02_JPRB,8.9208E+02_JPRB,9.0006E+02_JPRB,9.1044E+02_JPRB/)
KBO( :,43,14) = (/&
&8.5621E+02_JPRB,8.7164E+02_JPRB,8.8447E+02_JPRB,8.9300E+02_JPRB,9.0169E+02_JPRB/)
KBO( :,44,14) = (/&
&8.4579E+02_JPRB,8.6160E+02_JPRB,8.7458E+02_JPRB,8.8449E+02_JPRB,8.9117E+02_JPRB/)
KBO( :,45,14) = (/&
&8.3552E+02_JPRB,8.5159E+02_JPRB,8.6481E+02_JPRB,8.7553E+02_JPRB,8.8180E+02_JPRB/)
KBO( :,46,14) = (/&
&8.2373E+02_JPRB,8.4082E+02_JPRB,8.5433E+02_JPRB,8.6532E+02_JPRB,8.7296E+02_JPRB/)
KBO( :,47,14) = (/&
&8.0885E+02_JPRB,8.2944E+02_JPRB,8.4330E+02_JPRB,8.5448E+02_JPRB,8.6308E+02_JPRB/)
KBO( :,48,14) = (/&
&7.9282E+02_JPRB,8.1701E+02_JPRB,8.3172E+02_JPRB,8.4330E+02_JPRB,8.5233E+02_JPRB/)
KBO( :,49,14) = (/&
&7.7474E+02_JPRB,8.0258E+02_JPRB,8.2078E+02_JPRB,8.3236E+02_JPRB,8.4158E+02_JPRB/)
KBO( :,50,14) = (/&
&7.5683E+02_JPRB,7.8804E+02_JPRB,8.0940E+02_JPRB,8.2148E+02_JPRB,8.3083E+02_JPRB/)
KBO( :,51,14) = (/&
&7.3938E+02_JPRB,7.7206E+02_JPRB,7.9641E+02_JPRB,8.1162E+02_JPRB,8.2058E+02_JPRB/)
KBO( :,52,14) = (/&
&7.2202E+02_JPRB,7.5535E+02_JPRB,7.8294E+02_JPRB,8.0108E+02_JPRB,8.1024E+02_JPRB/)
KBO( :,53,14) = (/&
&7.0324E+02_JPRB,7.3897E+02_JPRB,7.6789E+02_JPRB,7.8856E+02_JPRB,8.0094E+02_JPRB/)
KBO( :,54,14) = (/&
&6.8557E+02_JPRB,7.2372E+02_JPRB,7.5272E+02_JPRB,7.7628E+02_JPRB,7.9095E+02_JPRB/)
KBO( :,55,14) = (/&
&6.6859E+02_JPRB,7.0784E+02_JPRB,7.3838E+02_JPRB,7.6303E+02_JPRB,7.7977E+02_JPRB/)
KBO( :,56,14) = (/&
&6.5053E+02_JPRB,6.9180E+02_JPRB,7.2460E+02_JPRB,7.4881E+02_JPRB,7.6818E+02_JPRB/)
KBO( :,57,14) = (/&
&6.3162E+02_JPRB,6.7617E+02_JPRB,7.0983E+02_JPRB,7.3529E+02_JPRB,7.5540E+02_JPRB/)
KBO( :,58,14) = (/&
&6.1260E+02_JPRB,6.6039E+02_JPRB,6.9564E+02_JPRB,7.2278E+02_JPRB,7.4208E+02_JPRB/)
KBO( :,59,14) = (/&
&6.0339E+02_JPRB,6.5209E+02_JPRB,6.8806E+02_JPRB,7.1492E+02_JPRB,7.3375E+02_JPRB/)
KBO( :,13,15) = (/&
&3.5098E+02_JPRB,3.4253E+02_JPRB,3.3549E+02_JPRB,3.2928E+02_JPRB,3.2668E+02_JPRB/)
KBO( :,14,15) = (/&
&4.0377E+02_JPRB,3.9399E+02_JPRB,3.8548E+02_JPRB,3.7889E+02_JPRB,3.7631E+02_JPRB/)
KBO( :,15,15) = (/&
&4.6249E+02_JPRB,4.5101E+02_JPRB,4.4105E+02_JPRB,4.3505E+02_JPRB,4.3250E+02_JPRB/)
KBO( :,16,15) = (/&
&5.2722E+02_JPRB,5.1397E+02_JPRB,5.0360E+02_JPRB,4.9808E+02_JPRB,4.9380E+02_JPRB/)
KBO( :,17,15) = (/&
&5.9816E+02_JPRB,5.8291E+02_JPRB,5.7380E+02_JPRB,5.6753E+02_JPRB,5.5862E+02_JPRB/)
KBO( :,18,15) = (/&
&6.7401E+02_JPRB,6.5981E+02_JPRB,6.5045E+02_JPRB,6.3876E+02_JPRB,6.2938E+02_JPRB/)
KBO( :,19,15) = (/&
&7.5603E+02_JPRB,7.4243E+02_JPRB,7.2713E+02_JPRB,7.1493E+02_JPRB,7.1147E+02_JPRB/)
KBO( :,20,15) = (/&
&8.4018E+02_JPRB,8.2182E+02_JPRB,8.0329E+02_JPRB,7.9254E+02_JPRB,7.9403E+02_JPRB/)
KBO( :,21,15) = (/&
&9.2407E+02_JPRB,8.9903E+02_JPRB,8.7966E+02_JPRB,8.7268E+02_JPRB,8.7487E+02_JPRB/)
KBO( :,22,15) = (/&
&1.0011E+03_JPRB,9.7360E+02_JPRB,9.5759E+02_JPRB,9.5258E+02_JPRB,9.5318E+02_JPRB/)
KBO( :,23,15) = (/&
&1.0752E+03_JPRB,1.0483E+03_JPRB,1.0346E+03_JPRB,1.0305E+03_JPRB,1.0291E+03_JPRB/)
KBO( :,24,15) = (/&
&1.1456E+03_JPRB,1.1222E+03_JPRB,1.1083E+03_JPRB,1.1031E+03_JPRB,1.1046E+03_JPRB/)
KBO( :,25,15) = (/&
&1.2128E+03_JPRB,1.1904E+03_JPRB,1.1781E+03_JPRB,1.1730E+03_JPRB,1.1805E+03_JPRB/)
KBO( :,26,15) = (/&
&1.2750E+03_JPRB,1.2517E+03_JPRB,1.2401E+03_JPRB,1.2396E+03_JPRB,1.2511E+03_JPRB/)
KBO( :,27,15) = (/&
&1.3306E+03_JPRB,1.3092E+03_JPRB,1.2993E+03_JPRB,1.3047E+03_JPRB,1.3242E+03_JPRB/)
KBO( :,28,15) = (/&
&1.3803E+03_JPRB,1.3622E+03_JPRB,1.3582E+03_JPRB,1.3721E+03_JPRB,1.4060E+03_JPRB/)
KBO( :,29,15) = (/&
&1.4288E+03_JPRB,1.4164E+03_JPRB,1.4235E+03_JPRB,1.4518E+03_JPRB,1.5063E+03_JPRB/)
KBO( :,30,15) = (/&
&1.4796E+03_JPRB,1.4775E+03_JPRB,1.4997E+03_JPRB,1.5506E+03_JPRB,1.6294E+03_JPRB/)
KBO( :,31,15) = (/&
&1.5388E+03_JPRB,1.5544E+03_JPRB,1.6015E+03_JPRB,1.6845E+03_JPRB,1.7959E+03_JPRB/)
KBO( :,32,15) = (/&
&1.6108E+03_JPRB,1.6524E+03_JPRB,1.7357E+03_JPRB,1.8549E+03_JPRB,2.0073E+03_JPRB/)
KBO( :,33,15) = (/&
&1.7049E+03_JPRB,1.7848E+03_JPRB,1.9109E+03_JPRB,2.0795E+03_JPRB,2.2809E+03_JPRB/)
KBO( :,34,15) = (/&
&1.8222E+03_JPRB,1.9474E+03_JPRB,2.1232E+03_JPRB,2.3448E+03_JPRB,2.6010E+03_JPRB/)
KBO( :,35,15) = (/&
&1.9666E+03_JPRB,2.1410E+03_JPRB,2.3742E+03_JPRB,2.6548E+03_JPRB,2.9712E+03_JPRB/)
KBO( :,36,15) = (/&
&2.1340E+03_JPRB,2.3637E+03_JPRB,2.6606E+03_JPRB,3.0085E+03_JPRB,3.3914E+03_JPRB/)
KBO( :,37,15) = (/&
&2.1914E+03_JPRB,2.4375E+03_JPRB,2.7564E+03_JPRB,3.1300E+03_JPRB,3.5406E+03_JPRB/)
KBO( :,38,15) = (/&
&2.2462E+03_JPRB,2.5086E+03_JPRB,2.8496E+03_JPRB,3.2486E+03_JPRB,3.6885E+03_JPRB/)
KBO( :,39,15) = (/&
&2.3075E+03_JPRB,2.5896E+03_JPRB,2.9560E+03_JPRB,3.3853E+03_JPRB,3.8593E+03_JPRB/)
KBO( :,40,15) = (/&
&2.2597E+03_JPRB,2.5238E+03_JPRB,2.8725E+03_JPRB,3.2888E+03_JPRB,3.7565E+03_JPRB/)
KBO( :,41,15) = (/&
&2.2030E+03_JPRB,2.4431E+03_JPRB,2.7663E+03_JPRB,3.1637E+03_JPRB,3.6169E+03_JPRB/)
KBO( :,42,15) = (/&
&2.1527E+03_JPRB,2.3676E+03_JPRB,2.6649E+03_JPRB,3.0437E+03_JPRB,3.4807E+03_JPRB/)
KBO( :,43,15) = (/&
&2.0801E+03_JPRB,2.2578E+03_JPRB,2.5168E+03_JPRB,2.8580E+03_JPRB,3.2606E+03_JPRB/)
KBO( :,44,15) = (/&
&2.0120E+03_JPRB,2.1487E+03_JPRB,2.3643E+03_JPRB,2.6580E+03_JPRB,3.0218E+03_JPRB/)
KBO( :,45,15) = (/&
&1.9613E+03_JPRB,2.0594E+03_JPRB,2.2322E+03_JPRB,2.4807E+03_JPRB,2.8037E+03_JPRB/)
KBO( :,46,15) = (/&
&1.9248E+03_JPRB,1.9849E+03_JPRB,2.1161E+03_JPRB,2.3204E+03_JPRB,2.5965E+03_JPRB/)
KBO( :,47,15) = (/&
&1.9027E+03_JPRB,1.9263E+03_JPRB,2.0143E+03_JPRB,2.1716E+03_JPRB,2.3989E+03_JPRB/)
KBO( :,48,15) = (/&
&1.8901E+03_JPRB,1.8881E+03_JPRB,1.9372E+03_JPRB,2.0507E+03_JPRB,2.2312E+03_JPRB/)
KBO( :,49,15) = (/&
&1.8889E+03_JPRB,1.8669E+03_JPRB,1.8827E+03_JPRB,1.9550E+03_JPRB,2.0905E+03_JPRB/)
KBO( :,50,15) = (/&
&1.8989E+03_JPRB,1.8542E+03_JPRB,1.8471E+03_JPRB,1.8860E+03_JPRB,1.9820E+03_JPRB/)
KBO( :,51,15) = (/&
&1.9169E+03_JPRB,1.8516E+03_JPRB,1.8269E+03_JPRB,1.8368E+03_JPRB,1.8967E+03_JPRB/)
KBO( :,52,15) = (/&
&1.9362E+03_JPRB,1.8607E+03_JPRB,1.8138E+03_JPRB,1.8022E+03_JPRB,1.8318E+03_JPRB/)
KBO( :,53,15) = (/&
&1.9614E+03_JPRB,1.8769E+03_JPRB,1.8109E+03_JPRB,1.7819E+03_JPRB,1.7849E+03_JPRB/)
KBO( :,54,15) = (/&
&1.9844E+03_JPRB,1.8925E+03_JPRB,1.8175E+03_JPRB,1.7685E+03_JPRB,1.7516E+03_JPRB/)
KBO( :,55,15) = (/&
&2.0020E+03_JPRB,1.9117E+03_JPRB,1.8292E+03_JPRB,1.7630E+03_JPRB,1.7309E+03_JPRB/)
KBO( :,56,15) = (/&
&2.0278E+03_JPRB,1.9328E+03_JPRB,1.8420E+03_JPRB,1.7676E+03_JPRB,1.7165E+03_JPRB/)
KBO( :,57,15) = (/&
&2.0604E+03_JPRB,1.9486E+03_JPRB,1.8586E+03_JPRB,1.7772E+03_JPRB,1.7105E+03_JPRB/)
KBO( :,58,15) = (/&
&2.0975E+03_JPRB,1.9708E+03_JPRB,1.8754E+03_JPRB,1.7869E+03_JPRB,1.7130E+03_JPRB/)
KBO( :,59,15) = (/&
&2.1134E+03_JPRB,1.9790E+03_JPRB,1.8747E+03_JPRB,1.7853E+03_JPRB,1.7084E+03_JPRB/)
KBO( :,13,16) = (/&
&5.7032E+02_JPRB,5.5610E+02_JPRB,5.4108E+02_JPRB,5.2545E+02_JPRB,5.0988E+02_JPRB/)
KBO( :,14,16) = (/&
&6.6729E+02_JPRB,6.4906E+02_JPRB,6.2994E+02_JPRB,6.1106E+02_JPRB,5.9252E+02_JPRB/)
KBO( :,15,16) = (/&
&7.7710E+02_JPRB,7.5381E+02_JPRB,7.3065E+02_JPRB,7.0752E+02_JPRB,6.8404E+02_JPRB/)
KBO( :,16,16) = (/&
&8.9983E+02_JPRB,8.7150E+02_JPRB,8.4258E+02_JPRB,8.1329E+02_JPRB,7.9266E+02_JPRB/)
KBO( :,17,16) = (/&
&1.0356E+03_JPRB,9.9960E+02_JPRB,9.6297E+02_JPRB,9.3112E+02_JPRB,9.3376E+02_JPRB/)
KBO( :,18,16) = (/&
&1.1805E+03_JPRB,1.1349E+03_JPRB,1.0927E+03_JPRB,1.0913E+03_JPRB,1.1178E+03_JPRB/)
KBO( :,19,16) = (/&
&1.3301E+03_JPRB,1.2743E+03_JPRB,1.2636E+03_JPRB,1.2905E+03_JPRB,1.3412E+03_JPRB/)
KBO( :,20,16) = (/&
&1.4790E+03_JPRB,1.4325E+03_JPRB,1.4416E+03_JPRB,1.4834E+03_JPRB,1.5509E+03_JPRB/)
KBO( :,21,16) = (/&
&1.6248E+03_JPRB,1.6005E+03_JPRB,1.6227E+03_JPRB,1.6765E+03_JPRB,1.7801E+03_JPRB/)
KBO( :,22,16) = (/&
&1.7789E+03_JPRB,1.7751E+03_JPRB,1.8121E+03_JPRB,1.8963E+03_JPRB,2.0533E+03_JPRB/)
KBO( :,23,16) = (/&
&1.9420E+03_JPRB,1.9550E+03_JPRB,2.0171E+03_JPRB,2.1515E+03_JPRB,2.3736E+03_JPRB/)
KBO( :,24,16) = (/&
&2.1057E+03_JPRB,2.1395E+03_JPRB,2.2516E+03_JPRB,2.4478E+03_JPRB,2.7312E+03_JPRB/)
KBO( :,25,16) = (/&
&2.2727E+03_JPRB,2.3487E+03_JPRB,2.5135E+03_JPRB,2.7876E+03_JPRB,3.1353E+03_JPRB/)
KBO( :,26,16) = (/&
&2.4430E+03_JPRB,2.5769E+03_JPRB,2.8118E+03_JPRB,3.1571E+03_JPRB,3.5871E+03_JPRB/)
KBO( :,27,16) = (/&
&2.6427E+03_JPRB,2.8396E+03_JPRB,3.1669E+03_JPRB,3.5883E+03_JPRB,4.0930E+03_JPRB/)
KBO( :,28,16) = (/&
&2.8823E+03_JPRB,3.1635E+03_JPRB,3.5805E+03_JPRB,4.0928E+03_JPRB,4.6511E+03_JPRB/)
KBO( :,29,16) = (/&
&3.1912E+03_JPRB,3.5861E+03_JPRB,4.1049E+03_JPRB,4.7016E+03_JPRB,5.3176E+03_JPRB/)
KBO( :,30,16) = (/&
&3.5968E+03_JPRB,4.1208E+03_JPRB,4.7628E+03_JPRB,5.4277E+03_JPRB,6.1129E+03_JPRB/)
KBO( :,31,16) = (/&
&4.1669E+03_JPRB,4.8568E+03_JPRB,5.5986E+03_JPRB,6.3508E+03_JPRB,7.1245E+03_JPRB/)
KBO( :,32,16) = (/&
&4.9181E+03_JPRB,5.7548E+03_JPRB,6.5943E+03_JPRB,7.4480E+03_JPRB,8.3250E+03_JPRB/)
KBO( :,33,16) = (/&
&5.8885E+03_JPRB,6.8470E+03_JPRB,7.8053E+03_JPRB,8.7780E+03_JPRB,9.7768E+03_JPRB/)
KBO( :,34,16) = (/&
&6.9635E+03_JPRB,8.0514E+03_JPRB,9.1398E+03_JPRB,1.0245E+04_JPRB,1.1380E+04_JPRB/)
KBO( :,35,16) = (/&
&8.1473E+03_JPRB,9.3881E+03_JPRB,1.0630E+04_JPRB,1.1894E+04_JPRB,1.3185E+04_JPRB/)
KBO( :,36,16) = (/&
&9.4364E+03_JPRB,1.0865E+04_JPRB,1.2293E+04_JPRB,1.3743E+04_JPRB,1.5227E+04_JPRB/)
KBO( :,37,16) = (/&
&9.8676E+03_JPRB,1.1389E+04_JPRB,1.2910E+04_JPRB,1.4442E+04_JPRB,1.6011E+04_JPRB/)
KBO( :,38,16) = (/&
&1.0288E+04_JPRB,1.1907E+04_JPRB,1.3518E+04_JPRB,1.5146E+04_JPRB,1.6802E+04_JPRB/)
KBO( :,39,16) = (/&
&1.0771E+04_JPRB,1.2499E+04_JPRB,1.4216E+04_JPRB,1.5954E+04_JPRB,1.7707E+04_JPRB/)
KBO( :,40,16) = (/&
&1.0414E+04_JPRB,1.2148E+04_JPRB,1.3875E+04_JPRB,1.5613E+04_JPRB,1.7368E+04_JPRB/)
KBO( :,41,16) = (/&
&9.9384E+03_JPRB,1.1661E+04_JPRB,1.3383E+04_JPRB,1.5104E+04_JPRB,1.6844E+04_JPRB/)
KBO( :,42,16) = (/&
&9.4612E+03_JPRB,1.1170E+04_JPRB,1.2888E+04_JPRB,1.4596E+04_JPRB,1.6317E+04_JPRB/)
KBO( :,43,16) = (/&
&8.7147E+03_JPRB,1.0370E+04_JPRB,1.2042E+04_JPRB,1.3705E+04_JPRB,1.5380E+04_JPRB/)
KBO( :,44,16) = (/&
&7.8820E+03_JPRB,9.4600E+03_JPRB,1.1070E+04_JPRB,1.2678E+04_JPRB,1.4284E+04_JPRB/)
KBO( :,45,16) = (/&
&7.0926E+03_JPRB,8.5904E+03_JPRB,1.0135E+04_JPRB,1.1689E+04_JPRB,1.3230E+04_JPRB/)
KBO( :,46,16) = (/&
&6.3333E+03_JPRB,7.7267E+03_JPRB,9.1993E+03_JPRB,1.0689E+04_JPRB,1.2169E+04_JPRB/)
KBO( :,47,16) = (/&
&5.6159E+03_JPRB,6.8398E+03_JPRB,8.2286E+03_JPRB,9.6499E+03_JPRB,1.1071E+04_JPRB/)
KBO( :,48,16) = (/&
&5.0469E+03_JPRB,6.0380E+03_JPRB,7.3127E+03_JPRB,8.6620E+03_JPRB,1.0021E+04_JPRB/)
KBO( :,49,16) = (/&
&4.6114E+03_JPRB,5.3556E+03_JPRB,6.4573E+03_JPRB,7.7273E+03_JPRB,9.0204E+03_JPRB/)
KBO( :,50,16) = (/&
&4.2827E+03_JPRB,4.8418E+03_JPRB,5.7290E+03_JPRB,6.8837E+03_JPRB,8.1065E+03_JPRB/)
KBO( :,51,16) = (/&
&4.0377E+03_JPRB,4.4505E+03_JPRB,5.1216E+03_JPRB,6.1118E+03_JPRB,7.2612E+03_JPRB/)
KBO( :,52,16) = (/&
&3.9027E+03_JPRB,4.1388E+03_JPRB,4.6373E+03_JPRB,5.4292E+03_JPRB,6.4624E+03_JPRB/)
KBO( :,53,16) = (/&
&3.8594E+03_JPRB,3.9014E+03_JPRB,4.2603E+03_JPRB,4.8496E+03_JPRB,5.7176E+03_JPRB/)
KBO( :,54,16) = (/&
&3.9053E+03_JPRB,3.7705E+03_JPRB,3.9739E+03_JPRB,4.4065E+03_JPRB,5.0959E+03_JPRB/)
KBO( :,55,16) = (/&
&4.0460E+03_JPRB,3.7217E+03_JPRB,3.7544E+03_JPRB,4.0660E+03_JPRB,4.5765E+03_JPRB/)
KBO( :,56,16) = (/&
&4.2054E+03_JPRB,3.7493E+03_JPRB,3.6207E+03_JPRB,3.7906E+03_JPRB,4.1568E+03_JPRB/)
KBO( :,57,16) = (/&
&4.3770E+03_JPRB,3.8799E+03_JPRB,3.5717E+03_JPRB,3.5790E+03_JPRB,3.8293E+03_JPRB/)
KBO( :,58,16) = (/&
&4.5510E+03_JPRB,4.0210E+03_JPRB,3.5972E+03_JPRB,3.4529E+03_JPRB,3.5736E+03_JPRB/)
KBO( :,59,16) = (/&
&4.6237E+03_JPRB,4.0799E+03_JPRB,3.6344E+03_JPRB,3.3958E+03_JPRB,3.4194E+03_JPRB/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
&2.83413E-02_JPRB, 2.51443E-02_JPRB, 2.23078E-02_JPRB, 1.97914E-02_JPRB, 1.75588E-02_JPRB,&
&1.55780E-02_JPRB, 1.38207E-02_JPRB, 1.22617E-02_JPRB, 1.08785E-02_JPRB, 9.65132E-03_JPRB/)
SELFREFO( :, 2) = (/&
&3.01506E-02_JPRB, 2.69506E-02_JPRB, 2.40901E-02_JPRB, 2.15333E-02_JPRB, 1.92478E-02_JPRB,&
&1.72049E-02_JPRB, 1.53789E-02_JPRB, 1.37466E-02_JPRB, 1.22876E-02_JPRB, 1.09834E-02_JPRB/)
SELFREFO( :, 3) = (/&
&4.24899E-02_JPRB, 3.77138E-02_JPRB, 3.34745E-02_JPRB, 2.97118E-02_JPRB, 2.63720E-02_JPRB,&
&2.34077E-02_JPRB, 2.07765E-02_JPRB, 1.84411E-02_JPRB, 1.63682E-02_JPRB, 1.45283E-02_JPRB/)
SELFREFO( :, 4) = (/&
&5.78648E-02_JPRB, 5.16988E-02_JPRB, 4.61899E-02_JPRB, 4.12679E-02_JPRB, 3.68705E-02_JPRB,&
&3.29416E-02_JPRB, 2.94314E-02_JPRB, 2.62952E-02_JPRB, 2.34932E-02_JPRB, 2.09898E-02_JPRB/)
SELFREFO( :, 5) = (/&
&6.96367E-02_JPRB, 6.36716E-02_JPRB, 5.82175E-02_JPRB, 5.32306E-02_JPRB, 4.86709E-02_JPRB,&
&4.45018E-02_JPRB, 4.06898E-02_JPRB, 3.72043E-02_JPRB, 3.40174E-02_JPRB, 3.11034E-02_JPRB/)
SELFREFO( :, 6) = (/&
&6.04073E-02_JPRB, 5.90856E-02_JPRB, 5.77929E-02_JPRB, 5.65284E-02_JPRB, 5.52916E-02_JPRB,&
&5.40819E-02_JPRB, 5.28986E-02_JPRB, 5.17413E-02_JPRB, 5.06092E-02_JPRB, 4.95020E-02_JPRB/)
SELFREFO( :, 7) = (/&
&6.19460E-02_JPRB, 6.02812E-02_JPRB, 5.86612E-02_JPRB, 5.70847E-02_JPRB, 5.55506E-02_JPRB,&
&5.40577E-02_JPRB, 5.26049E-02_JPRB, 5.11912E-02_JPRB, 4.98155E-02_JPRB, 4.84767E-02_JPRB/)
SELFREFO( :, 8) = (/&
&6.86939E-02_JPRB, 6.58429E-02_JPRB, 6.31102E-02_JPRB, 6.04909E-02_JPRB, 5.79804E-02_JPRB,&
&5.55740E-02_JPRB, 5.32675E-02_JPRB, 5.10567E-02_JPRB, 4.89377E-02_JPRB, 4.69067E-02_JPRB/)
SELFREFO( :, 9) = (/&
&8.18828E-02_JPRB, 7.77172E-02_JPRB, 7.37635E-02_JPRB, 7.00110E-02_JPRB, 6.64494E-02_JPRB,&
&6.30689E-02_JPRB, 5.98604E-02_JPRB, 5.68152E-02_JPRB, 5.39248E-02_JPRB, 5.11815E-02_JPRB/)
SELFREFO( :,10) = (/&
&8.41953E-02_JPRB, 8.10610E-02_JPRB, 7.80434E-02_JPRB, 7.51381E-02_JPRB, 7.23409E-02_JPRB,&
&6.96479E-02_JPRB, 6.70551E-02_JPRB, 6.45589E-02_JPRB, 6.21556E-02_JPRB, 5.98417E-02_JPRB/)
SELFREFO( :,11) = (/&
&9.41304E-02_JPRB, 8.97275E-02_JPRB, 8.55305E-02_JPRB, 8.15299E-02_JPRB, 7.77164E-02_JPRB,&
&7.40812E-02_JPRB, 7.06161E-02_JPRB, 6.73131E-02_JPRB, 6.41646E-02_JPRB, 6.11633E-02_JPRB/)
SELFREFO( :,12) = (/&
&9.55404E-02_JPRB, 9.02311E-02_JPRB, 8.52169E-02_JPRB, 8.04813E-02_JPRB, 7.60089E-02_JPRB,&
&7.17850E-02_JPRB, 6.77958E-02_JPRB, 6.40284E-02_JPRB, 6.04703E-02_JPRB, 5.71099E-02_JPRB/)
SELFREFO( :,13) = (/&
&9.32377E-02_JPRB, 8.99082E-02_JPRB, 8.66977E-02_JPRB, 8.36018E-02_JPRB, 8.06164E-02_JPRB,&
&7.77376E-02_JPRB, 7.49617E-02_JPRB, 7.22848E-02_JPRB, 6.97036E-02_JPRB, 6.72145E-02_JPRB/)
SELFREFO( :,14) = (/&
&1.14746E-01_JPRB, 1.08112E-01_JPRB, 1.01861E-01_JPRB, 9.59719E-02_JPRB, 9.04232E-02_JPRB,&
&8.51952E-02_JPRB, 8.02695E-02_JPRB, 7.56285E-02_JPRB, 7.12559E-02_JPRB, 6.71361E-02_JPRB/)
SELFREFO( :,15) = (/&
&1.23517E-01_JPRB, 1.19527E-01_JPRB, 1.15666E-01_JPRB, 1.11929E-01_JPRB, 1.08313E-01_JPRB,&
&1.04814E-01_JPRB, 1.01428E-01_JPRB, 9.81512E-02_JPRB, 9.49803E-02_JPRB, 9.19119E-02_JPRB/)
SELFREFO( :,16) = (/&
&1.44086E-01_JPRB, 1.36396E-01_JPRB, 1.29117E-01_JPRB, 1.22226E-01_JPRB, 1.15703E-01_JPRB,&
&1.09528E-01_JPRB, 1.03683E-01_JPRB, 9.81497E-02_JPRB, 9.29116E-02_JPRB, 8.79530E-02_JPRB/)

FRACREFAO( :, 1) = (/&
!     From P = 1053.6 mb.
    &0.16898900_JPRB,0.15898301_JPRB,0.13575301_JPRB,0.12600900_JPRB,&
    &0.11545800_JPRB,0.09879170_JPRB,0.08106830_JPRB,0.06063440_JPRB,&
    &0.03988780_JPRB,0.00421760_JPRB,0.00346635_JPRB,0.00278779_JPRB,&
    &0.00206225_JPRB,0.00132324_JPRB,0.00050033_JPRB,0.00007038_JPRB/)
FRACREFAO( :, 2) = (/&
    &0.18209399_JPRB,0.15315101_JPRB,0.13571000_JPRB,0.12504999_JPRB,&
    &0.11379100_JPRB,0.09680810_JPRB,0.08008570_JPRB,0.05970280_JPRB,&
    &0.03942860_JPRB,0.00413383_JPRB,0.00343186_JPRB,0.00275558_JPRB,&
    &0.00204657_JPRB,0.00130219_JPRB,0.00045454_JPRB,0.00005664_JPRB/)
FRACREFAO( :, 3) = (/&
    &0.18459500_JPRB,0.15512000_JPRB,0.13395500_JPRB,0.12576801_JPRB,&
    &0.11276800_JPRB,0.09645190_JPRB,0.07956650_JPRB,0.05903340_JPRB,&
    &0.03887050_JPRB,0.00412226_JPRB,0.00339453_JPRB,0.00273518_JPRB,&
    &0.00196922_JPRB,0.00119411_JPRB,0.00040263_JPRB,0.00005664_JPRB/)
FRACREFAO( :, 4) = (/&
    &0.18458800_JPRB,0.15859900_JPRB,0.13278100_JPRB,0.12589300_JPRB,&
    &0.11272700_JPRB,0.09599660_JPRB,0.07903030_JPRB,0.05843600_JPRB,&
    &0.03843400_JPRB,0.00405181_JPRB,0.00337980_JPRB,0.00263818_JPRB,&
    &0.00186869_JPRB,0.00111807_JPRB,0.00040263_JPRB,0.00005664_JPRB/)
FRACREFAO( :, 5) = (/&
    &0.18459301_JPRB,0.16176100_JPRB,0.13235000_JPRB,0.12528200_JPRB,&
    &0.11237100_JPRB,0.09618840_JPRB,0.07833760_JPRB,0.05800770_JPRB,&
    &0.03787610_JPRB,0.00408253_JPRB,0.00330363_JPRB,0.00250445_JPRB,&
    &0.00176725_JPRB,0.00111753_JPRB,0.00040263_JPRB,0.00005664_JPRB/)
FRACREFAO( :, 6) = (/&
    &0.18454400_JPRB,0.16505300_JPRB,0.13221300_JPRB,0.12476600_JPRB,&
    &0.11158300_JPRB,0.09618120_JPRB,0.07797340_JPRB,0.05740380_JPRB,&
    &0.03742820_JPRB,0.00392691_JPRB,0.00312208_JPRB,0.00246306_JPRB,&
    &0.00176735_JPRB,0.00111721_JPRB,0.00040263_JPRB,0.00005664_JPRB/)
FRACREFAO( :, 7) = (/&
    &0.18452001_JPRB,0.16697501_JPRB,0.13445500_JPRB,0.12391300_JPRB,&
    &0.11059100_JPRB,0.09596890_JPRB,0.07761050_JPRB,0.05643200_JPRB,&
    &0.03686520_JPRB,0.00377086_JPRB,0.00309351_JPRB,0.00246297_JPRB,&
    &0.00176765_JPRB,0.00111700_JPRB,0.00040263_JPRB,0.00005664_JPRB/)
FRACREFAO( :, 8) = (/&
    &0.18460999_JPRB,0.16854499_JPRB,0.13922299_JPRB,0.12266400_JPRB,&
    &0.10962200_JPRB,0.09452030_JPRB,0.07653800_JPRB,0.05551340_JPRB,&
    &0.03609660_JPRB,0.00377043_JPRB,0.00309367_JPRB,0.00246304_JPRB,&
    &0.00176749_JPRB,0.00111689_JPRB,0.00040263_JPRB,0.00005664_JPRB/)
FRACREFAO( :, 9) = (/&
    &0.18312500_JPRB,0.16787501_JPRB,0.14720701_JPRB,0.12766500_JPRB,&
    &0.10890900_JPRB,0.08935530_JPRB,0.07310870_JPRB,0.05443140_JPRB,&
    &0.03566380_JPRB,0.00376446_JPRB,0.00309521_JPRB,0.00246510_JPRB,&
    &0.00176139_JPRB,0.00111543_JPRB,0.00040263_JPRB,0.00005664_JPRB/)

!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB9
