!OCL SCALAR
SUBROUTINE RRTM_KGB7

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 7:  980-1080 cm-1 (low - H2O,O3; high - O3)
!     Reformatted for F90 by JJMorcrette, ECMWF

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO7 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO  ,ABSCO2O
USE YOERRTA7 , ONLY : STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE
FRACREFBO( :) = (/&
    &0.15355594_JPRB,0.15310939_JPRB,0.14274909_JPRB,0.13129812_JPRB,&
    &0.11736792_JPRB,0.10118213_JPRB,0.08215259_JPRB,0.06165591_JPRB,&
    &0.04164486_JPRB,0.00451141_JPRB,0.00372837_JPRB,0.00294095_JPRB,&
    &0.00215259_JPRB,0.00136792_JPRB,0.00051233_JPRB,0.00007075_JPRB/)

ABSCO2O( :) = (/&
     &9.30038E-05_JPRB, 1.74061E-04_JPRB, 2.09293E-04_JPRB, 2.52360E-04_JPRB,&
     &3.13404E-04_JPRB, 4.16619E-04_JPRB, 6.27394E-04_JPRB, 1.29386E-03_JPRB,&
     &4.05192E-03_JPRB, 3.97050E-03_JPRB, 7.00634E-04_JPRB, 6.06617E-04_JPRB,&
     &7.66978E-04_JPRB, 6.70661E-04_JPRB, 7.89971E-04_JPRB, 7.55709E-04_JPRB/)

STRRAT = 8.21104E+04_JPRB

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 1) = (/&
&2.2177E-05_JPRB,2.0513E-05_JPRB,1.8414E-05_JPRB,1.6282E-05_JPRB,1.4597E-05_JPRB,1.7000E-05_JPRB,&
&3.1783E-05_JPRB,2.9548E-05_JPRB,2.0326E-05_JPRB/)
KAO( :, 2, 1, 1) = (/&
&2.9476E-05_JPRB,2.7495E-05_JPRB,2.4720E-05_JPRB,2.1727E-05_JPRB,1.8690E-05_JPRB,1.6642E-05_JPRB,&
&2.2418E-05_JPRB,3.4177E-05_JPRB,1.9700E-05_JPRB/)
KAO( :, 3, 1, 1) = (/&
&3.7965E-05_JPRB,3.5737E-05_JPRB,3.2254E-05_JPRB,2.8364E-05_JPRB,2.4321E-05_JPRB,2.0140E-05_JPRB,&
&1.9338E-05_JPRB,3.5856E-05_JPRB,1.9799E-05_JPRB/)
KAO( :, 4, 1, 1) = (/&
&4.7589E-05_JPRB,4.5238E-05_JPRB,4.1024E-05_JPRB,3.6253E-05_JPRB,3.0918E-05_JPRB,2.5365E-05_JPRB,&
&2.0061E-05_JPRB,3.1406E-05_JPRB,1.8985E-05_JPRB/)
KAO( :, 5, 1, 1) = (/&
&5.8133E-05_JPRB,5.5835E-05_JPRB,5.0877E-05_JPRB,4.5058E-05_JPRB,3.8486E-05_JPRB,3.1429E-05_JPRB,&
&2.4355E-05_JPRB,2.3465E-05_JPRB,1.9414E-05_JPRB/)
KAO( :, 1, 2, 1) = (/&
&1.7361E-05_JPRB,1.6018E-05_JPRB,1.4350E-05_JPRB,1.2700E-05_JPRB,1.2303E-05_JPRB,1.7164E-05_JPRB,&
&3.1474E-05_JPRB,2.4947E-05_JPRB,1.4706E-05_JPRB/)
KAO( :, 2, 2, 1) = (/&
&2.3361E-05_JPRB,2.1726E-05_JPRB,1.9465E-05_JPRB,1.7053E-05_JPRB,1.4815E-05_JPRB,1.4858E-05_JPRB,&
&2.3603E-05_JPRB,2.7767E-05_JPRB,1.5833E-05_JPRB/)
KAO( :, 3, 2, 1) = (/&
&3.0408E-05_JPRB,2.8494E-05_JPRB,2.5606E-05_JPRB,2.2430E-05_JPRB,1.9084E-05_JPRB,1.6104E-05_JPRB,&
&1.8012E-05_JPRB,3.1460E-05_JPRB,1.6197E-05_JPRB/)
KAO( :, 4, 2, 1) = (/&
&3.8408E-05_JPRB,3.6296E-05_JPRB,3.2790E-05_JPRB,2.8865E-05_JPRB,2.4498E-05_JPRB,1.9967E-05_JPRB,&
&1.6925E-05_JPRB,3.2098E-05_JPRB,1.4117E-05_JPRB/)
KAO( :, 5, 2, 1) = (/&
&4.7278E-05_JPRB,4.5107E-05_JPRB,4.0996E-05_JPRB,3.6211E-05_JPRB,3.0776E-05_JPRB,2.4989E-05_JPRB,&
&1.9312E-05_JPRB,2.3551E-05_JPRB,1.4164E-05_JPRB/)
KAO( :, 1, 3, 1) = (/&
&1.2199E-05_JPRB,1.1359E-05_JPRB,1.0200E-05_JPRB,9.6275E-06_JPRB,1.2031E-05_JPRB,1.8466E-05_JPRB,&
&2.2967E-05_JPRB,2.1740E-05_JPRB,1.1424E-05_JPRB/)
KAO( :, 2, 3, 1) = (/&
&1.6733E-05_JPRB,1.5628E-05_JPRB,1.3980E-05_JPRB,1.2308E-05_JPRB,1.1642E-05_JPRB,1.5244E-05_JPRB,&
&2.7219E-05_JPRB,2.2185E-05_JPRB,1.1890E-05_JPRB/)
KAO( :, 3, 3, 1) = (/&
&2.2207E-05_JPRB,2.0825E-05_JPRB,1.8647E-05_JPRB,1.6328E-05_JPRB,1.4051E-05_JPRB,1.3615E-05_JPRB,&
&2.0537E-05_JPRB,2.5366E-05_JPRB,1.0328E-05_JPRB/)
KAO( :, 4, 3, 1) = (/&
&2.8575E-05_JPRB,2.6953E-05_JPRB,2.4203E-05_JPRB,2.1170E-05_JPRB,1.7963E-05_JPRB,1.5129E-05_JPRB,&
&1.6245E-05_JPRB,2.7906E-05_JPRB,8.9114E-06_JPRB/)
KAO( :, 5, 3, 1) = (/&
&3.5718E-05_JPRB,3.3927E-05_JPRB,3.0634E-05_JPRB,2.6847E-05_JPRB,2.2736E-05_JPRB,1.8593E-05_JPRB,&
&1.5444E-05_JPRB,2.7715E-05_JPRB,7.5424E-06_JPRB/)
KAO( :, 1, 4, 1) = (/&
&8.2740E-06_JPRB,7.8120E-06_JPRB,7.3229E-06_JPRB,7.9409E-06_JPRB,1.1817E-05_JPRB,2.0000E-05_JPRB,&
&1.7036E-05_JPRB,1.6859E-05_JPRB,8.3202E-06_JPRB/)
KAO( :, 2, 4, 1) = (/&
&1.1549E-05_JPRB,1.0930E-05_JPRB,9.8917E-06_JPRB,9.2790E-06_JPRB,1.0972E-05_JPRB,1.6368E-05_JPRB,&
&2.0889E-05_JPRB,1.9211E-05_JPRB,7.1922E-06_JPRB/)
KAO( :, 3, 4, 1) = (/&
&1.5581E-05_JPRB,1.4791E-05_JPRB,1.3288E-05_JPRB,1.1769E-05_JPRB,1.1067E-05_JPRB,1.3703E-05_JPRB,&
&2.3763E-05_JPRB,1.9912E-05_JPRB,5.4002E-06_JPRB/)
KAO( :, 4, 4, 1) = (/&
&2.0367E-05_JPRB,1.9416E-05_JPRB,1.7464E-05_JPRB,1.5301E-05_JPRB,1.3238E-05_JPRB,1.2747E-05_JPRB,&
&1.8197E-05_JPRB,2.2927E-05_JPRB,4.7781E-06_JPRB/)
KAO( :, 5, 4, 1) = (/&
&2.5890E-05_JPRB,2.4787E-05_JPRB,2.2347E-05_JPRB,1.9553E-05_JPRB,1.6603E-05_JPRB,1.3957E-05_JPRB,&
&1.4873E-05_JPRB,2.4745E-05_JPRB,6.3734E-06_JPRB/)
KAO( :, 1, 5, 1) = (/&
&5.5869E-06_JPRB,5.3398E-06_JPRB,5.3975E-06_JPRB,7.5444E-06_JPRB,1.2793E-05_JPRB,1.5045E-05_JPRB,&
&1.3730E-05_JPRB,1.2376E-05_JPRB,4.7266E-06_JPRB/)
KAO( :, 2, 5, 1) = (/&
&7.8874E-06_JPRB,7.5569E-06_JPRB,7.0693E-06_JPRB,7.4130E-06_JPRB,1.0864E-05_JPRB,1.7853E-05_JPRB,&
&1.5643E-05_JPRB,1.6221E-05_JPRB,3.5143E-06_JPRB/)
KAO( :, 3, 5, 1) = (/&
&1.0780E-05_JPRB,1.0380E-05_JPRB,9.4898E-06_JPRB,8.8724E-06_JPRB,9.9994E-06_JPRB,1.4704E-05_JPRB,&
&1.8972E-05_JPRB,1.7347E-05_JPRB,2.8694E-06_JPRB/)
KAO( :, 4, 5, 1) = (/&
&1.4284E-05_JPRB,1.3812E-05_JPRB,1.2569E-05_JPRB,1.1246E-05_JPRB,1.0513E-05_JPRB,1.2455E-05_JPRB,&
&2.1138E-05_JPRB,1.8036E-05_JPRB,3.9174E-06_JPRB/)
KAO( :, 5, 5, 1) = (/&
&1.8381E-05_JPRB,1.7863E-05_JPRB,1.6238E-05_JPRB,1.4332E-05_JPRB,1.2479E-05_JPRB,1.1807E-05_JPRB,&
&1.6766E-05_JPRB,2.0636E-05_JPRB,5.6357E-06_JPRB/)
KAO( :, 1, 6, 1) = (/&
&3.7614E-06_JPRB,3.6612E-06_JPRB,4.2770E-06_JPRB,7.9260E-06_JPRB,1.2929E-05_JPRB,1.1264E-05_JPRB,&
&1.2098E-05_JPRB,9.0224E-06_JPRB,2.4844E-06_JPRB/)
KAO( :, 2, 6, 1) = (/&
&5.3574E-06_JPRB,5.1717E-06_JPRB,5.1909E-06_JPRB,6.9736E-06_JPRB,1.1707E-05_JPRB,1.3896E-05_JPRB,&
&1.2589E-05_JPRB,1.2103E-05_JPRB,1.8407E-06_JPRB/)
KAO( :, 3, 6, 1) = (/&
&7.3957E-06_JPRB,7.1617E-06_JPRB,6.7263E-06_JPRB,7.0062E-06_JPRB,1.0148E-05_JPRB,1.6269E-05_JPRB,&
&1.4268E-05_JPRB,1.5386E-05_JPRB,2.1237E-06_JPRB/)
KAO( :, 4, 6, 1) = (/&
&9.9154E-06_JPRB,9.6620E-06_JPRB,8.9048E-06_JPRB,8.3244E-06_JPRB,9.2342E-06_JPRB,1.3655E-05_JPRB,&
&1.7166E-05_JPRB,1.5743E-05_JPRB,3.1741E-06_JPRB/)
KAO( :, 5, 6, 1) = (/&
&1.2917E-05_JPRB,1.2663E-05_JPRB,1.1620E-05_JPRB,1.0475E-05_JPRB,9.8347E-06_JPRB,1.1480E-05_JPRB,&
&1.8999E-05_JPRB,1.6296E-05_JPRB,4.8288E-06_JPRB/)
KAO( :, 1, 7, 1) = (/&
&2.5698E-06_JPRB,2.6225E-06_JPRB,4.3229E-06_JPRB,9.1260E-06_JPRB,9.6331E-06_JPRB,9.4890E-06_JPRB,&
&8.7898E-06_JPRB,6.9652E-06_JPRB,1.3336E-06_JPRB/)
KAO( :, 2, 7, 1) = (/&
&3.6949E-06_JPRB,3.6079E-06_JPRB,4.1418E-06_JPRB,7.5616E-06_JPRB,1.2142E-05_JPRB,1.0521E-05_JPRB,&
&1.1728E-05_JPRB,8.9866E-06_JPRB,1.2052E-06_JPRB/)
KAO( :, 3, 7, 1) = (/&
&5.1506E-06_JPRB,5.0082E-06_JPRB,4.9832E-06_JPRB,6.5372E-06_JPRB,1.0639E-05_JPRB,1.2818E-05_JPRB,&
&1.1491E-05_JPRB,1.1845E-05_JPRB,1.7476E-06_JPRB/)
KAO( :, 4, 7, 1) = (/&
&6.9721E-06_JPRB,6.8111E-06_JPRB,6.4221E-06_JPRB,6.6314E-06_JPRB,9.5364E-06_JPRB,1.4735E-05_JPRB,&
&1.3056E-05_JPRB,1.4613E-05_JPRB,2.7527E-06_JPRB/)
KAO( :, 5, 7, 1) = (/&
&9.1741E-06_JPRB,9.0313E-06_JPRB,8.3715E-06_JPRB,7.8432E-06_JPRB,8.4495E-06_JPRB,1.2715E-05_JPRB,&
&1.5629E-05_JPRB,1.4305E-05_JPRB,4.3096E-06_JPRB/)
KAO( :, 1, 8, 1) = (/&
&1.7756E-06_JPRB,2.0634E-06_JPRB,5.0880E-06_JPRB,8.2373E-06_JPRB,7.8177E-06_JPRB,7.9286E-06_JPRB,&
&6.3775E-06_JPRB,5.4113E-06_JPRB,9.3762E-07_JPRB/)
KAO( :, 2, 8, 1) = (/&
&2.5589E-06_JPRB,2.6026E-06_JPRB,4.1994E-06_JPRB,8.7611E-06_JPRB,9.1501E-06_JPRB,8.9485E-06_JPRB,&
&8.8743E-06_JPRB,7.1784E-06_JPRB,1.1824E-06_JPRB/)
KAO( :, 3, 8, 1) = (/&
&3.5966E-06_JPRB,3.5351E-06_JPRB,4.0408E-06_JPRB,7.3057E-06_JPRB,1.1311E-05_JPRB,9.8836E-06_JPRB,&
&1.0943E-05_JPRB,9.1050E-06_JPRB,1.7854E-06_JPRB/)
KAO( :, 4, 8, 1) = (/&
&4.9051E-06_JPRB,4.8155E-06_JPRB,4.7641E-06_JPRB,6.2802E-06_JPRB,1.0233E-05_JPRB,1.1811E-05_JPRB,&
&1.0660E-05_JPRB,1.1545E-05_JPRB,2.8335E-06_JPRB/)
KAO( :, 5, 8, 1) = (/&
&6.5079E-06_JPRB,6.4275E-06_JPRB,6.0806E-06_JPRB,6.2850E-06_JPRB,8.9855E-06_JPRB,1.3690E-05_JPRB,&
&1.2091E-05_JPRB,1.3991E-05_JPRB,4.4905E-06_JPRB/)
KAO( :, 1, 9, 1) = (/&
&1.2486E-06_JPRB,2.0772E-06_JPRB,6.3261E-06_JPRB,6.5239E-06_JPRB,6.7379E-06_JPRB,5.7685E-06_JPRB,&
&4.7923E-06_JPRB,4.4775E-06_JPRB,2.0431E-06_JPRB/)
KAO( :, 2, 9, 1) = (/&
&1.8028E-06_JPRB,2.0516E-06_JPRB,4.9892E-06_JPRB,7.9160E-06_JPRB,7.4534E-06_JPRB,8.0589E-06_JPRB,&
&6.6119E-06_JPRB,5.7051E-06_JPRB,2.4856E-06_JPRB/)
KAO( :, 3, 9, 1) = (/&
&2.5445E-06_JPRB,2.5819E-06_JPRB,4.1305E-06_JPRB,8.3727E-06_JPRB,8.7276E-06_JPRB,8.5620E-06_JPRB,&
&8.8118E-06_JPRB,7.4196E-06_JPRB,3.4314E-06_JPRB/)
KAO( :, 4, 9, 1) = (/&
&3.4959E-06_JPRB,3.4634E-06_JPRB,3.9749E-06_JPRB,7.0571E-06_JPRB,1.0574E-05_JPRB,9.2822E-06_JPRB,&
&1.0319E-05_JPRB,9.2300E-06_JPRB,5.1599E-06_JPRB/)
KAO( :, 5, 9, 1) = (/&
&4.6733E-06_JPRB,4.6321E-06_JPRB,4.5821E-06_JPRB,6.0749E-06_JPRB,9.9333E-06_JPRB,1.0979E-05_JPRB,&
&1.0111E-05_JPRB,1.1271E-05_JPRB,8.0274E-06_JPRB/)
KAO( :, 1,10, 1) = (/&
&9.1025E-07_JPRB,2.4528E-06_JPRB,5.5726E-06_JPRB,5.5107E-06_JPRB,5.1975E-06_JPRB,4.4519E-06_JPRB,&
&3.8745E-06_JPRB,3.7574E-06_JPRB,7.2814E-06_JPRB/)
KAO( :, 2,10, 1) = (/&
&1.3156E-06_JPRB,2.0527E-06_JPRB,6.2782E-06_JPRB,6.4430E-06_JPRB,6.8843E-06_JPRB,6.1546E-06_JPRB,&
&5.1800E-06_JPRB,4.8780E-06_JPRB,8.0238E-06_JPRB/)
KAO( :, 3,10, 1) = (/&
&1.8603E-06_JPRB,2.0830E-06_JPRB,5.0693E-06_JPRB,7.7258E-06_JPRB,7.2719E-06_JPRB,8.2740E-06_JPRB,&
&6.9520E-06_JPRB,6.2927E-06_JPRB,9.9400E-06_JPRB/)
KAO( :, 4,10, 1) = (/&
&2.5643E-06_JPRB,2.6119E-06_JPRB,4.1284E-06_JPRB,8.2194E-06_JPRB,8.3768E-06_JPRB,8.2923E-06_JPRB,&
&8.9244E-06_JPRB,7.7919E-06_JPRB,1.3755E-05_JPRB/)
KAO( :, 5,10, 1) = (/&
&3.4396E-06_JPRB,3.4402E-06_JPRB,3.9520E-06_JPRB,6.9781E-06_JPRB,9.9688E-06_JPRB,8.9208E-06_JPRB,&
&1.0073E-05_JPRB,9.4585E-06_JPRB,2.0482E-05_JPRB/)
KAO( :, 1,11, 1) = (/&
&7.9990E-07_JPRB,2.6784E-06_JPRB,5.0182E-06_JPRB,5.2703E-06_JPRB,4.7427E-06_JPRB,4.1219E-06_JPRB,&
&3.7030E-06_JPRB,3.7980E-06_JPRB,1.0212E-05_JPRB/)
KAO( :, 2,11, 1) = (/&
&1.1506E-06_JPRB,2.1675E-06_JPRB,6.1676E-06_JPRB,5.9511E-06_JPRB,6.4671E-06_JPRB,5.5707E-06_JPRB,&
&4.8102E-06_JPRB,4.7946E-06_JPRB,1.1170E-05_JPRB/)
KAO( :, 3,11, 1) = (/&
&1.6161E-06_JPRB,1.9795E-06_JPRB,5.4689E-06_JPRB,6.8567E-06_JPRB,6.9277E-06_JPRB,7.3643E-06_JPRB,&
&6.3255E-06_JPRB,6.0154E-06_JPRB,1.3679E-05_JPRB/)
KAO( :, 4,11, 1) = (/&
&2.2097E-06_JPRB,2.3135E-06_JPRB,4.4934E-06_JPRB,8.2433E-06_JPRB,7.5005E-06_JPRB,8.0757E-06_JPRB,&
&8.0043E-06_JPRB,7.4062E-06_JPRB,1.8725E-05_JPRB/)
KAO( :, 5,11, 1) = (/&
&2.9383E-06_JPRB,2.9710E-06_JPRB,3.8010E-06_JPRB,7.4323E-06_JPRB,8.7355E-06_JPRB,8.0970E-06_JPRB,&
&9.6640E-06_JPRB,8.8290E-06_JPRB,2.7664E-05_JPRB/)
KAO( :, 1,12, 1) = (/&
&7.0941E-07_JPRB,2.6297E-06_JPRB,4.5700E-06_JPRB,4.9667E-06_JPRB,4.3747E-06_JPRB,3.8263E-06_JPRB,&
&3.4506E-06_JPRB,3.6352E-06_JPRB,1.0764E-05_JPRB/)
KAO( :, 2,12, 1) = (/&
&1.0191E-06_JPRB,2.0344E-06_JPRB,5.5461E-06_JPRB,5.4627E-06_JPRB,5.8842E-06_JPRB,5.0801E-06_JPRB,&
&4.4391E-06_JPRB,4.4109E-06_JPRB,1.1741E-05_JPRB/)
KAO( :, 3,12, 1) = (/&
&1.4279E-06_JPRB,1.8013E-06_JPRB,5.3154E-06_JPRB,6.1728E-06_JPRB,6.3556E-06_JPRB,6.6152E-06_JPRB,&
&5.7465E-06_JPRB,5.5323E-06_JPRB,1.4320E-05_JPRB/)
KAO( :, 4,12, 1) = (/&
&1.9430E-06_JPRB,2.0642E-06_JPRB,4.3928E-06_JPRB,7.3526E-06_JPRB,6.7817E-06_JPRB,7.5948E-06_JPRB,&
&7.1609E-06_JPRB,6.7682E-06_JPRB,1.9523E-05_JPRB/)
KAO( :, 5,12, 1) = (/&
&2.5711E-06_JPRB,2.6172E-06_JPRB,3.5411E-06_JPRB,7.1217E-06_JPRB,7.7996E-06_JPRB,7.3436E-06_JPRB,&
&8.5622E-06_JPRB,7.9225E-06_JPRB,2.8755E-05_JPRB/)
KAO( :, 1,13, 1) = (/&
&6.2420E-07_JPRB,2.5595E-06_JPRB,4.1789E-06_JPRB,4.5948E-06_JPRB,4.0362E-06_JPRB,3.5472E-06_JPRB,&
&3.2436E-06_JPRB,3.4107E-06_JPRB,9.1608E-06_JPRB/)
KAO( :, 2,13, 1) = (/&
&8.9615E-07_JPRB,1.9079E-06_JPRB,4.9940E-06_JPRB,5.0423E-06_JPRB,5.3353E-06_JPRB,4.6287E-06_JPRB,&
&4.1017E-06_JPRB,4.1244E-06_JPRB,9.9901E-06_JPRB/)
KAO( :, 3,13, 1) = (/&
&1.2529E-06_JPRB,1.6490E-06_JPRB,5.1498E-06_JPRB,5.5689E-06_JPRB,5.8865E-06_JPRB,5.9318E-06_JPRB,&
&5.1860E-06_JPRB,5.1003E-06_JPRB,1.2178E-05_JPRB/)
KAO( :, 4,13, 1) = (/&
&1.6987E-06_JPRB,1.8380E-06_JPRB,4.2684E-06_JPRB,6.5744E-06_JPRB,6.1601E-06_JPRB,7.0815E-06_JPRB,&
&6.4247E-06_JPRB,6.1421E-06_JPRB,1.6600E-05_JPRB/)
KAO( :, 5,13, 1) = (/&
&2.2352E-06_JPRB,2.2950E-06_JPRB,3.3070E-06_JPRB,6.8297E-06_JPRB,6.9887E-06_JPRB,6.7633E-06_JPRB,&
&7.6284E-06_JPRB,7.1420E-06_JPRB,2.4442E-05_JPRB/)
KAO( :, 1, 1, 2) = (/&
&5.4151E-05_JPRB,5.1620E-05_JPRB,4.7151E-05_JPRB,4.1642E-05_JPRB,3.5398E-05_JPRB,2.6235E-05_JPRB,&
&2.1071E-05_JPRB,5.8698E-05_JPRB,2.4321E-05_JPRB/)
KAO( :, 2, 1, 2) = (/&
&6.7514E-05_JPRB,6.4760E-05_JPRB,5.9233E-05_JPRB,5.2524E-05_JPRB,4.5074E-05_JPRB,3.6408E-05_JPRB,&
&2.4335E-05_JPRB,5.6829E-05_JPRB,2.7514E-05_JPRB/)
KAO( :, 3, 1, 2) = (/&
&8.2149E-05_JPRB,7.9291E-05_JPRB,7.2593E-05_JPRB,6.4606E-05_JPRB,5.5728E-05_JPRB,4.6152E-05_JPRB,&
&3.4241E-05_JPRB,4.5420E-05_JPRB,2.4336E-05_JPRB/)
KAO( :, 4, 1, 2) = (/&
&9.7723E-05_JPRB,9.4880E-05_JPRB,8.7232E-05_JPRB,7.7947E-05_JPRB,6.7833E-05_JPRB,5.6842E-05_JPRB,&
&4.4766E-05_JPRB,2.6532E-05_JPRB,2.9870E-05_JPRB/)
KAO( :, 5, 1, 2) = (/&
&1.1394E-04_JPRB,1.1139E-04_JPRB,1.0299E-04_JPRB,9.2684E-05_JPRB,8.1155E-05_JPRB,6.8389E-05_JPRB,&
&5.3823E-05_JPRB,3.3217E-05_JPRB,2.3434E-05_JPRB/)
KAO( :, 1, 2, 2) = (/&
&4.2753E-05_JPRB,4.0882E-05_JPRB,3.7362E-05_JPRB,3.3159E-05_JPRB,2.7615E-05_JPRB,1.8637E-05_JPRB,&
&2.2134E-05_JPRB,5.3399E-05_JPRB,1.8302E-05_JPRB/)
KAO( :, 2, 2, 2) = (/&
&5.3879E-05_JPRB,5.1846E-05_JPRB,4.7574E-05_JPRB,4.2472E-05_JPRB,3.6451E-05_JPRB,2.8399E-05_JPRB,&
&1.9335E-05_JPRB,5.2953E-05_JPRB,1.7179E-05_JPRB/)
KAO( :, 3, 2, 2) = (/&
&6.6088E-05_JPRB,6.4132E-05_JPRB,5.9087E-05_JPRB,5.2832E-05_JPRB,4.5668E-05_JPRB,3.7676E-05_JPRB,&
&2.6673E-05_JPRB,4.9047E-05_JPRB,2.0200E-05_JPRB/)
KAO( :, 4, 2, 2) = (/&
&7.9313E-05_JPRB,7.7493E-05_JPRB,7.1541E-05_JPRB,6.4098E-05_JPRB,5.5769E-05_JPRB,4.6664E-05_JPRB,&
&3.6034E-05_JPRB,2.7239E-05_JPRB,1.9971E-05_JPRB/)
KAO( :, 5, 2, 2) = (/&
&9.3172E-05_JPRB,9.1802E-05_JPRB,8.4933E-05_JPRB,7.6462E-05_JPRB,6.6920E-05_JPRB,5.6293E-05_JPRB,&
&4.4283E-05_JPRB,2.5633E-05_JPRB,1.6128E-05_JPRB/)
KAO( :, 1, 3, 2) = (/&
&3.1637E-05_JPRB,3.0177E-05_JPRB,2.7541E-05_JPRB,2.3988E-05_JPRB,1.7787E-05_JPRB,1.3073E-05_JPRB,&
&4.0575E-05_JPRB,4.8194E-05_JPRB,1.2505E-05_JPRB/)
KAO( :, 2, 3, 2) = (/&
&4.0410E-05_JPRB,3.8878E-05_JPRB,3.5667E-05_JPRB,3.1901E-05_JPRB,2.6742E-05_JPRB,1.8595E-05_JPRB,&
&1.9446E-05_JPRB,5.0395E-05_JPRB,1.3203E-05_JPRB/)
KAO( :, 3, 3, 2) = (/&
&5.0197E-05_JPRB,4.8688E-05_JPRB,4.4913E-05_JPRB,4.0333E-05_JPRB,3.4912E-05_JPRB,2.7673E-05_JPRB,&
&1.8085E-05_JPRB,4.8586E-05_JPRB,1.3602E-05_JPRB/)
KAO( :, 4, 3, 2) = (/&
&6.0782E-05_JPRB,5.9537E-05_JPRB,5.5167E-05_JPRB,4.9672E-05_JPRB,4.3304E-05_JPRB,3.6088E-05_JPRB,&
&2.5607E-05_JPRB,4.2696E-05_JPRB,1.2094E-05_JPRB/)
KAO( :, 5, 3, 2) = (/&
&7.2122E-05_JPRB,7.1291E-05_JPRB,6.6301E-05_JPRB,5.9947E-05_JPRB,5.2623E-05_JPRB,4.4244E-05_JPRB,&
&3.4126E-05_JPRB,2.2584E-05_JPRB,1.6766E-05_JPRB/)
KAO( :, 1, 4, 2) = (/&
&2.3214E-05_JPRB,2.2012E-05_JPRB,1.9759E-05_JPRB,1.6356E-05_JPRB,1.1177E-05_JPRB,1.3102E-05_JPRB,&
&5.4531E-05_JPRB,4.5521E-05_JPRB,8.5704E-06_JPRB/)
KAO( :, 2, 4, 2) = (/&
&2.9987E-05_JPRB,2.8729E-05_JPRB,2.6188E-05_JPRB,2.2885E-05_JPRB,1.7414E-05_JPRB,1.2331E-05_JPRB,&
&3.4914E-05_JPRB,4.5109E-05_JPRB,8.5816E-06_JPRB/)
KAO( :, 3, 4, 2) = (/&
&3.7737E-05_JPRB,3.6418E-05_JPRB,3.3481E-05_JPRB,2.9943E-05_JPRB,2.5212E-05_JPRB,1.8076E-05_JPRB,&
&1.7776E-05_JPRB,4.6705E-05_JPRB,7.7341E-06_JPRB/)
KAO( :, 4, 4, 2) = (/&
&4.6237E-05_JPRB,4.5035E-05_JPRB,4.1706E-05_JPRB,3.7594E-05_JPRB,3.2675E-05_JPRB,2.6052E-05_JPRB,&
&1.7191E-05_JPRB,4.4501E-05_JPRB,1.1430E-05_JPRB/)
KAO( :, 5, 4, 2) = (/&
&5.5394E-05_JPRB,5.4566E-05_JPRB,5.0800E-05_JPRB,4.6060E-05_JPRB,4.0396E-05_JPRB,3.3727E-05_JPRB,&
&2.3835E-05_JPRB,3.7336E-05_JPRB,1.6242E-05_JPRB/)
KAO( :, 1, 5, 2) = (/&
&1.7110E-05_JPRB,1.6145E-05_JPRB,1.4165E-05_JPRB,1.0426E-05_JPRB,7.9870E-06_JPRB,2.4744E-05_JPRB,&
&5.4612E-05_JPRB,4.2211E-05_JPRB,5.8558E-06_JPRB/)
KAO( :, 2, 5, 2) = (/&
&2.2350E-05_JPRB,2.1312E-05_JPRB,1.9197E-05_JPRB,1.6194E-05_JPRB,1.1081E-05_JPRB,1.1593E-05_JPRB,&
&4.7643E-05_JPRB,4.2913E-05_JPRB,4.4739E-06_JPRB/)
KAO( :, 3, 5, 2) = (/&
&2.8416E-05_JPRB,2.7289E-05_JPRB,2.4884E-05_JPRB,2.1811E-05_JPRB,1.7120E-05_JPRB,1.1847E-05_JPRB,&
&3.1141E-05_JPRB,4.2424E-05_JPRB,6.9636E-06_JPRB/)
KAO( :, 4, 5, 2) = (/&
&3.5202E-05_JPRB,3.4084E-05_JPRB,3.1336E-05_JPRB,2.8012E-05_JPRB,2.3757E-05_JPRB,1.7453E-05_JPRB,&
&1.5962E-05_JPRB,4.2655E-05_JPRB,1.0597E-05_JPRB/)
KAO( :, 5, 5, 2) = (/&
&4.2592E-05_JPRB,4.1680E-05_JPRB,3.8616E-05_JPRB,3.4875E-05_JPRB,3.0427E-05_JPRB,2.4423E-05_JPRB,&
&1.5902E-05_JPRB,4.0629E-05_JPRB,1.5906E-05_JPRB/)
KAO( :, 1, 6, 2) = (/&
&1.2522E-05_JPRB,1.1758E-05_JPRB,9.8897E-06_JPRB,6.3513E-06_JPRB,1.0585E-05_JPRB,4.0712E-05_JPRB,&
&5.0160E-05_JPRB,4.0760E-05_JPRB,3.1679E-06_JPRB/)
KAO( :, 2, 6, 2) = (/&
&1.6573E-05_JPRB,1.5756E-05_JPRB,1.3865E-05_JPRB,1.0569E-05_JPRB,7.4971E-06_JPRB,2.3617E-05_JPRB,&
&5.0226E-05_JPRB,4.0741E-05_JPRB,3.5969E-06_JPRB/)
KAO( :, 3, 6, 2) = (/&
&2.1308E-05_JPRB,2.0432E-05_JPRB,1.8454E-05_JPRB,1.5643E-05_JPRB,1.0753E-05_JPRB,1.1262E-05_JPRB,&
&4.2958E-05_JPRB,3.9589E-05_JPRB,5.9975E-06_JPRB/)
KAO( :, 4, 6, 2) = (/&
&2.6653E-05_JPRB,2.5731E-05_JPRB,2.3505E-05_JPRB,2.0714E-05_JPRB,1.6401E-05_JPRB,1.1347E-05_JPRB,&
&2.9347E-05_JPRB,3.9364E-05_JPRB,9.7407E-06_JPRB/)
KAO( :, 5, 6, 2) = (/&
&3.2562E-05_JPRB,3.1730E-05_JPRB,2.9223E-05_JPRB,2.6148E-05_JPRB,2.2224E-05_JPRB,1.6477E-05_JPRB,&
&1.5448E-05_JPRB,3.9356E-05_JPRB,1.5151E-05_JPRB/)
KAO( :, 1, 7, 2) = (/&
&9.2632E-06_JPRB,8.5835E-06_JPRB,6.2688E-06_JPRB,5.7491E-06_JPRB,2.0750E-05_JPRB,4.7549E-05_JPRB,&
&4.9746E-05_JPRB,4.3221E-05_JPRB,1.9173E-06_JPRB/)
KAO( :, 2, 7, 2) = (/&
&1.2411E-05_JPRB,1.1741E-05_JPRB,9.9384E-06_JPRB,6.3308E-06_JPRB,9.8932E-06_JPRB,3.7604E-05_JPRB,&
&4.5915E-05_JPRB,3.8224E-05_JPRB,3.1404E-06_JPRB/)
KAO( :, 3, 7, 2) = (/&
&1.6131E-05_JPRB,1.5426E-05_JPRB,1.3668E-05_JPRB,1.0538E-05_JPRB,7.5655E-06_JPRB,2.2395E-05_JPRB,&
&4.5385E-05_JPRB,3.8777E-05_JPRB,5.5259E-06_JPRB/)
KAO( :, 4, 7, 2) = (/&
&2.0394E-05_JPRB,1.9668E-05_JPRB,1.7772E-05_JPRB,1.5135E-05_JPRB,1.0480E-05_JPRB,1.1695E-05_JPRB,&
&3.8455E-05_JPRB,3.6049E-05_JPRB,9.3488E-06_JPRB/)
KAO( :, 5, 7, 2) = (/&
&2.5104E-05_JPRB,2.4438E-05_JPRB,2.2345E-05_JPRB,1.9724E-05_JPRB,1.5920E-05_JPRB,1.0909E-05_JPRB,&
&2.7780E-05_JPRB,3.6976E-05_JPRB,1.5076E-05_JPRB/)
KAO( :, 1, 8, 2) = (/&
&6.9226E-06_JPRB,6.1974E-06_JPRB,3.6925E-06_JPRB,9.7107E-06_JPRB,3.1400E-05_JPRB,5.1217E-05_JPRB,&
&5.1133E-05_JPRB,4.7405E-05_JPRB,1.8023E-06_JPRB/)
KAO( :, 2, 8, 2) = (/&
&9.3730E-06_JPRB,8.7696E-06_JPRB,6.5222E-06_JPRB,5.5338E-06_JPRB,2.0725E-05_JPRB,4.5311E-05_JPRB,&
&4.6330E-05_JPRB,3.9950E-05_JPRB,3.2574E-06_JPRB/)
KAO( :, 3, 8, 2) = (/&
&1.2271E-05_JPRB,1.1705E-05_JPRB,9.9611E-06_JPRB,6.4477E-06_JPRB,1.0502E-05_JPRB,3.6242E-05_JPRB,&
&4.2814E-05_JPRB,3.6156E-05_JPRB,5.9101E-06_JPRB/)
KAO( :, 4, 8, 2) = (/&
&1.5653E-05_JPRB,1.5070E-05_JPRB,1.3408E-05_JPRB,1.0377E-05_JPRB,7.4564E-06_JPRB,2.3003E-05_JPRB,&
&4.1378E-05_JPRB,3.6628E-05_JPRB,1.0378E-05_JPRB/)
KAO( :, 5, 8, 2) = (/&
&1.9451E-05_JPRB,1.8892E-05_JPRB,1.7102E-05_JPRB,1.4623E-05_JPRB,1.0332E-05_JPRB,1.2287E-05_JPRB,&
&3.5601E-05_JPRB,3.3798E-05_JPRB,1.7377E-05_JPRB/)
KAO( :, 1, 9, 2) = (/&
&5.2610E-06_JPRB,4.1633E-06_JPRB,4.0647E-06_JPRB,1.6473E-05_JPRB,4.2753E-05_JPRB,5.1385E-05_JPRB,&
&4.7611E-05_JPRB,4.8409E-05_JPRB,3.6172E-06_JPRB/)
KAO( :, 2, 9, 2) = (/&
&7.1572E-06_JPRB,6.5056E-06_JPRB,3.9269E-06_JPRB,9.8251E-06_JPRB,3.2469E-05_JPRB,4.6277E-05_JPRB,&
&4.7279E-05_JPRB,4.4658E-05_JPRB,6.1285E-06_JPRB/)
KAO( :, 3, 9, 2) = (/&
&9.4513E-06_JPRB,8.9266E-06_JPRB,6.7478E-06_JPRB,5.5531E-06_JPRB,2.0823E-05_JPRB,4.1922E-05_JPRB,&
&4.3117E-05_JPRB,3.6857E-05_JPRB,1.1095E-05_JPRB/)
KAO( :, 4, 9, 2) = (/&
&1.2144E-05_JPRB,1.1656E-05_JPRB,9.9211E-06_JPRB,6.5681E-06_JPRB,1.1366E-05_JPRB,3.4298E-05_JPRB,&
&3.9570E-05_JPRB,3.4386E-05_JPRB,2.0048E-05_JPRB/)
KAO( :, 5, 9, 2) = (/&
&1.5214E-05_JPRB,1.4744E-05_JPRB,1.3136E-05_JPRB,1.0200E-05_JPRB,7.5939E-06_JPRB,2.3119E-05_JPRB,&
&3.7419E-05_JPRB,3.3965E-05_JPRB,3.4968E-05_JPRB/)
KAO( :, 1,10, 2) = (/&
&4.1564E-06_JPRB,2.6079E-06_JPRB,6.9218E-06_JPRB,2.7859E-05_JPRB,4.8834E-05_JPRB,5.2686E-05_JPRB,&
&4.6389E-05_JPRB,4.9087E-05_JPRB,1.0652E-05_JPRB/)
KAO( :, 2,10, 2) = (/&
&5.6598E-06_JPRB,4.6524E-06_JPRB,4.2303E-06_JPRB,1.7606E-05_JPRB,4.1116E-05_JPRB,4.7567E-05_JPRB,&
&4.5264E-05_JPRB,4.6736E-05_JPRB,1.6225E-05_JPRB/)
KAO( :, 3,10, 2) = (/&
&7.4935E-06_JPRB,6.8980E-06_JPRB,4.2539E-06_JPRB,1.0638E-05_JPRB,3.2709E-05_JPRB,4.2416E-05_JPRB,&
&4.4544E-05_JPRB,4.1212E-05_JPRB,2.8258E-05_JPRB/)
KAO( :, 4,10, 2) = (/&
&9.6635E-06_JPRB,9.2067E-06_JPRB,7.0228E-06_JPRB,5.8835E-06_JPRB,2.2271E-05_JPRB,3.9179E-05_JPRB,&
&4.0535E-05_JPRB,3.4910E-05_JPRB,5.1242E-05_JPRB/)
KAO( :, 5,10, 2) = (/&
&1.2158E-05_JPRB,1.1756E-05_JPRB,1.0040E-05_JPRB,6.8113E-06_JPRB,1.2737E-05_JPRB,3.2445E-05_JPRB,&
&3.6666E-05_JPRB,3.2986E-05_JPRB,9.1455E-05_JPRB/)
KAO( :, 1,11, 2) = (/&
&3.8505E-06_JPRB,2.2272E-06_JPRB,9.0452E-06_JPRB,3.3373E-05_JPRB,4.6563E-05_JPRB,5.1119E-05_JPRB,&
&4.6293E-05_JPRB,4.7828E-05_JPRB,1.4850E-05_JPRB/)
KAO( :, 2,11, 2) = (/&
&5.1974E-06_JPRB,4.0087E-06_JPRB,5.3940E-06_JPRB,2.3158E-05_JPRB,4.1599E-05_JPRB,4.6146E-05_JPRB,&
&4.2299E-05_JPRB,4.6208E-05_JPRB,2.2452E-05_JPRB/)
KAO( :, 3,11, 2) = (/&
&6.8266E-06_JPRB,6.1648E-06_JPRB,4.0224E-06_JPRB,1.4825E-05_JPRB,3.4779E-05_JPRB,4.0817E-05_JPRB,&
&4.2127E-05_JPRB,4.1473E-05_JPRB,3.8968E-05_JPRB/)
KAO( :, 4,11, 2) = (/&
&8.7559E-06_JPRB,8.2911E-06_JPRB,5.8154E-06_JPRB,8.1179E-06_JPRB,2.7292E-05_JPRB,3.7470E-05_JPRB,&
&3.8829E-05_JPRB,3.4450E-05_JPRB,7.0589E-05_JPRB/)
KAO( :, 5,11, 2) = (/&
&1.0954E-05_JPRB,1.0574E-05_JPRB,8.7742E-06_JPRB,6.0446E-06_JPRB,1.8157E-05_JPRB,3.3048E-05_JPRB,&
&3.5168E-05_JPRB,3.1159E-05_JPRB,1.2578E-04_JPRB/)
KAO( :, 1,12, 2) = (/&
&3.5781E-06_JPRB,2.0859E-06_JPRB,9.5195E-06_JPRB,3.1787E-05_JPRB,4.2342E-05_JPRB,4.6653E-05_JPRB,&
&4.2689E-05_JPRB,4.4370E-05_JPRB,1.5650E-05_JPRB/)
KAO( :, 2,12, 2) = (/&
&4.8068E-06_JPRB,3.6887E-06_JPRB,5.7939E-06_JPRB,2.3796E-05_JPRB,3.7779E-05_JPRB,4.1997E-05_JPRB,&
&3.8426E-05_JPRB,4.2634E-05_JPRB,2.3652E-05_JPRB/)
KAO( :, 3,12, 2) = (/&
&6.2948E-06_JPRB,5.6556E-06_JPRB,3.7630E-06_JPRB,1.5847E-05_JPRB,3.2542E-05_JPRB,3.7297E-05_JPRB,&
&3.8083E-05_JPRB,3.7879E-05_JPRB,4.1024E-05_JPRB/)
KAO( :, 4,12, 2) = (/&
&8.0397E-06_JPRB,7.5827E-06_JPRB,5.0870E-06_JPRB,9.0305E-06_JPRB,2.6555E-05_JPRB,3.3515E-05_JPRB,&
&3.5502E-05_JPRB,3.1529E-05_JPRB,7.4223E-05_JPRB/)
KAO( :, 5,12, 2) = (/&
&1.0028E-05_JPRB,9.6397E-06_JPRB,7.9012E-06_JPRB,5.7864E-06_JPRB,1.8461E-05_JPRB,3.0406E-05_JPRB,&
&3.2113E-05_JPRB,2.8581E-05_JPRB,1.3214E-04_JPRB/)
KAO( :, 1,13, 2) = (/&
&3.3027E-06_JPRB,1.9849E-06_JPRB,1.0579E-05_JPRB,3.0102E-05_JPRB,3.8661E-05_JPRB,4.2078E-05_JPRB,&
&3.9451E-05_JPRB,4.0882E-05_JPRB,1.3351E-05_JPRB/)
KAO( :, 2,13, 2) = (/&
&4.4219E-06_JPRB,3.3751E-06_JPRB,6.3222E-06_JPRB,2.3724E-05_JPRB,3.3992E-05_JPRB,3.8161E-05_JPRB,&
&3.4651E-05_JPRB,3.8910E-05_JPRB,2.0209E-05_JPRB/)
KAO( :, 3,13, 2) = (/&
&5.7740E-06_JPRB,5.1371E-06_JPRB,3.6294E-06_JPRB,1.6612E-05_JPRB,3.0054E-05_JPRB,3.4084E-05_JPRB,&
&3.4363E-05_JPRB,3.4522E-05_JPRB,3.5082E-05_JPRB/)
KAO( :, 4,13, 2) = (/&
&7.3436E-06_JPRB,6.8959E-06_JPRB,4.5387E-06_JPRB,1.0066E-05_JPRB,2.5028E-05_JPRB,3.0345E-05_JPRB,&
&3.2120E-05_JPRB,2.8785E-05_JPRB,6.3433E-05_JPRB/)
KAO( :, 5,13, 2) = (/&
&9.1271E-06_JPRB,8.7491E-06_JPRB,7.0983E-06_JPRB,6.0072E-06_JPRB,1.8622E-05_JPRB,2.7834E-05_JPRB,&
&2.8936E-05_JPRB,2.5906E-05_JPRB,1.1287E-04_JPRB/)
KAO( :, 1, 1, 3) = (/&
&1.0561E-04_JPRB,9.9580E-05_JPRB,9.1881E-05_JPRB,8.2381E-05_JPRB,7.1375E-05_JPRB,5.7989E-05_JPRB,&
&3.5664E-05_JPRB,6.4412E-05_JPRB,3.1092E-05_JPRB/)
KAO( :, 2, 1, 3) = (/&
&1.2338E-04_JPRB,1.1773E-04_JPRB,1.0902E-04_JPRB,9.8327E-05_JPRB,8.5823E-05_JPRB,7.1198E-05_JPRB,&
&5.2267E-05_JPRB,4.7983E-05_JPRB,3.3217E-05_JPRB/)
KAO( :, 3, 1, 3) = (/&
&1.4195E-04_JPRB,1.3687E-04_JPRB,1.2720E-04_JPRB,1.1513E-04_JPRB,1.0071E-04_JPRB,8.3744E-05_JPRB,&
&6.2834E-05_JPRB,3.3890E-05_JPRB,3.3867E-05_JPRB/)
KAO( :, 4, 1, 3) = (/&
&1.6072E-04_JPRB,1.5621E-04_JPRB,1.4581E-04_JPRB,1.3254E-04_JPRB,1.1572E-04_JPRB,9.6056E-05_JPRB,&
&7.3269E-05_JPRB,4.4619E-05_JPRB,2.4444E-05_JPRB/)
KAO( :, 5, 1, 3) = (/&
&1.7870E-04_JPRB,1.7588E-04_JPRB,1.6519E-04_JPRB,1.5017E-04_JPRB,1.3146E-04_JPRB,1.0980E-04_JPRB,&
&8.4775E-05_JPRB,5.5831E-05_JPRB,2.9607E-05_JPRB/)
KAO( :, 1, 2, 3) = (/&
&9.0935E-05_JPRB,8.5722E-05_JPRB,7.8558E-05_JPRB,6.9752E-05_JPRB,5.9712E-05_JPRB,4.7385E-05_JPRB,&
&2.8063E-05_JPRB,6.1629E-05_JPRB,2.1541E-05_JPRB/)
KAO( :, 2, 2, 3) = (/&
&1.0613E-04_JPRB,1.0109E-04_JPRB,9.2923E-05_JPRB,8.2896E-05_JPRB,7.1836E-05_JPRB,5.9001E-05_JPRB,&
&4.0531E-05_JPRB,5.4238E-05_JPRB,2.6282E-05_JPRB/)
KAO( :, 3, 2, 3) = (/&
&1.2220E-04_JPRB,1.1726E-04_JPRB,1.0800E-04_JPRB,9.6883E-05_JPRB,8.4549E-05_JPRB,7.0132E-05_JPRB,&
&5.2211E-05_JPRB,3.5371E-05_JPRB,2.0831E-05_JPRB/)
KAO( :, 4, 2, 3) = (/&
&1.3840E-04_JPRB,1.3383E-04_JPRB,1.2384E-04_JPRB,1.1185E-04_JPRB,9.7762E-05_JPRB,8.1196E-05_JPRB,&
&6.1844E-05_JPRB,3.5901E-05_JPRB,1.8797E-05_JPRB/)
KAO( :, 5, 2, 3) = (/&
&1.5419E-04_JPRB,1.5072E-04_JPRB,1.4069E-04_JPRB,1.2749E-04_JPRB,1.1156E-04_JPRB,9.3151E-05_JPRB,&
&7.1896E-05_JPRB,4.6407E-05_JPRB,2.8564E-05_JPRB/)
KAO( :, 1, 3, 3) = (/&
&7.5234E-05_JPRB,7.0905E-05_JPRB,6.4619E-05_JPRB,5.6937E-05_JPRB,4.7925E-05_JPRB,3.4057E-05_JPRB,&
&2.9471E-05_JPRB,6.0714E-05_JPRB,1.5353E-05_JPRB/)
KAO( :, 2, 3, 3) = (/&
&8.8054E-05_JPRB,8.3720E-05_JPRB,7.6548E-05_JPRB,6.7694E-05_JPRB,5.7920E-05_JPRB,4.6422E-05_JPRB,&
&2.6506E-05_JPRB,5.8794E-05_JPRB,1.3222E-05_JPRB/)
KAO( :, 3, 3, 3) = (/&
&1.0142E-04_JPRB,9.7129E-05_JPRB,8.9011E-05_JPRB,7.9094E-05_JPRB,6.8344E-05_JPRB,5.6044E-05_JPRB,&
&3.9469E-05_JPRB,4.5819E-05_JPRB,1.2529E-05_JPRB/)
KAO( :, 4, 3, 3) = (/&
&1.1514E-04_JPRB,1.1089E-04_JPRB,1.0189E-04_JPRB,9.1196E-05_JPRB,7.9328E-05_JPRB,6.5564E-05_JPRB,&
&4.9536E-05_JPRB,2.9992E-05_JPRB,2.0006E-05_JPRB/)
KAO( :, 5, 3, 3) = (/&
&1.2867E-04_JPRB,1.2511E-04_JPRB,1.1573E-04_JPRB,1.0413E-04_JPRB,9.0747E-05_JPRB,7.5488E-05_JPRB,&
&5.8137E-05_JPRB,3.3705E-05_JPRB,2.9649E-05_JPRB/)
KAO( :, 1, 4, 3) = (/&
&6.1778E-05_JPRB,5.8294E-05_JPRB,5.2798E-05_JPRB,4.6202E-05_JPRB,3.7473E-05_JPRB,2.1169E-05_JPRB,&
&3.9527E-05_JPRB,6.1900E-05_JPRB,9.6628E-06_JPRB/)
KAO( :, 2, 4, 3) = (/&
&7.2880E-05_JPRB,6.9141E-05_JPRB,6.2841E-05_JPRB,5.5219E-05_JPRB,4.6442E-05_JPRB,3.4307E-05_JPRB,&
&2.4540E-05_JPRB,5.8099E-05_JPRB,8.2774E-06_JPRB/)
KAO( :, 3, 4, 3) = (/&
&8.4189E-05_JPRB,8.0422E-05_JPRB,7.3326E-05_JPRB,6.4671E-05_JPRB,5.5214E-05_JPRB,4.4201E-05_JPRB,&
&2.5763E-05_JPRB,5.4305E-05_JPRB,1.4320E-05_JPRB/)
KAO( :, 4, 4, 3) = (/&
&9.5731E-05_JPRB,9.1993E-05_JPRB,8.4010E-05_JPRB,7.4439E-05_JPRB,6.4080E-05_JPRB,5.2536E-05_JPRB,&
&3.7772E-05_JPRB,4.0812E-05_JPRB,2.1667E-05_JPRB/)
KAO( :, 5, 4, 3) = (/&
&1.0722E-04_JPRB,1.0376E-04_JPRB,9.5138E-05_JPRB,8.4789E-05_JPRB,7.3585E-05_JPRB,6.0982E-05_JPRB,&
&4.6442E-05_JPRB,2.6775E-05_JPRB,3.0897E-05_JPRB/)
KAO( :, 1, 5, 3) = (/&
&5.0693E-05_JPRB,4.7899E-05_JPRB,4.3078E-05_JPRB,3.7149E-05_JPRB,2.7343E-05_JPRB,1.8823E-05_JPRB,&
&5.3113E-05_JPRB,6.4247E-05_JPRB,5.8413E-06_JPRB/)
KAO( :, 2, 5, 3) = (/&
&6.0292E-05_JPRB,5.7244E-05_JPRB,5.1699E-05_JPRB,4.5062E-05_JPRB,3.6934E-05_JPRB,2.2807E-05_JPRB,&
&3.5085E-05_JPRB,5.8430E-05_JPRB,9.0461E-06_JPRB/)
KAO( :, 3, 5, 3) = (/&
&7.0130E-05_JPRB,6.6900E-05_JPRB,6.0628E-05_JPRB,5.3145E-05_JPRB,4.4673E-05_JPRB,3.3772E-05_JPRB,&
&2.2961E-05_JPRB,5.4725E-05_JPRB,1.4542E-05_JPRB/)
KAO( :, 4, 5, 3) = (/&
&7.9880E-05_JPRB,7.6664E-05_JPRB,6.9684E-05_JPRB,6.1301E-05_JPRB,5.2150E-05_JPRB,4.1916E-05_JPRB,&
&2.5438E-05_JPRB,4.9130E-05_JPRB,2.2207E-05_JPRB/)
KAO( :, 5, 5, 3) = (/&
&8.9549E-05_JPRB,8.6422E-05_JPRB,7.8834E-05_JPRB,6.9694E-05_JPRB,5.9898E-05_JPRB,4.9265E-05_JPRB,&
&3.5529E-05_JPRB,3.7520E-05_JPRB,3.2469E-05_JPRB/)
KAO( :, 1, 6, 3) = (/&
&4.1241E-05_JPRB,3.8825E-05_JPRB,3.4760E-05_JPRB,2.8889E-05_JPRB,1.6124E-05_JPRB,2.3998E-05_JPRB,&
&6.9344E-05_JPRB,6.4810E-05_JPRB,4.4340E-06_JPRB/)
KAO( :, 2, 6, 3) = (/&
&4.9399E-05_JPRB,4.6917E-05_JPRB,4.2198E-05_JPRB,3.6346E-05_JPRB,2.7704E-05_JPRB,1.8853E-05_JPRB,&
&4.8135E-05_JPRB,6.0892E-05_JPRB,8.2681E-06_JPRB/)
KAO( :, 3, 6, 3) = (/&
&5.7861E-05_JPRB,5.5206E-05_JPRB,4.9718E-05_JPRB,4.3299E-05_JPRB,3.5690E-05_JPRB,2.2202E-05_JPRB,&
&3.1528E-05_JPRB,5.5484E-05_JPRB,1.3906E-05_JPRB/)
KAO( :, 4, 6, 3) = (/&
&6.6294E-05_JPRB,6.3463E-05_JPRB,5.7396E-05_JPRB,5.0239E-05_JPRB,4.2302E-05_JPRB,3.1945E-05_JPRB,&
&2.0634E-05_JPRB,5.2274E-05_JPRB,2.1920E-05_JPRB/)
KAO( :, 5, 6, 3) = (/&
&7.4664E-05_JPRB,7.1784E-05_JPRB,6.5151E-05_JPRB,5.7238E-05_JPRB,4.8740E-05_JPRB,3.9314E-05_JPRB,&
&2.3437E-05_JPRB,4.4846E-05_JPRB,3.3007E-05_JPRB/)
KAO( :, 1, 7, 3) = (/&
&3.3565E-05_JPRB,3.1356E-05_JPRB,2.7729E-05_JPRB,1.9350E-05_JPRB,1.4415E-05_JPRB,3.7753E-05_JPRB,&
&7.9102E-05_JPRB,6.2223E-05_JPRB,4.1072E-06_JPRB/)
KAO( :, 2, 7, 3) = (/&
&4.0432E-05_JPRB,3.8210E-05_JPRB,3.4263E-05_JPRB,2.8707E-05_JPRB,1.6576E-05_JPRB,2.4516E-05_JPRB,&
&6.1614E-05_JPRB,6.3419E-05_JPRB,8.0365E-06_JPRB/)
KAO( :, 3, 7, 3) = (/&
&4.7650E-05_JPRB,4.5423E-05_JPRB,4.0777E-05_JPRB,3.5184E-05_JPRB,2.7131E-05_JPRB,1.8290E-05_JPRB,&
&4.3600E-05_JPRB,5.7557E-05_JPRB,1.3883E-05_JPRB/)
KAO( :, 4, 7, 3) = (/&
&5.4916E-05_JPRB,5.2553E-05_JPRB,4.7306E-05_JPRB,4.1198E-05_JPRB,3.3969E-05_JPRB,2.0841E-05_JPRB,&
&2.8970E-05_JPRB,5.2203E-05_JPRB,2.2718E-05_JPRB/)
KAO( :, 5, 7, 3) = (/&
&6.2191E-05_JPRB,5.9624E-05_JPRB,5.3859E-05_JPRB,4.7059E-05_JPRB,3.9626E-05_JPRB,3.0110E-05_JPRB,&
&1.8574E-05_JPRB,4.8026E-05_JPRB,3.5441E-05_JPRB/)
KAO( :, 1, 8, 3) = (/&
&2.7226E-05_JPRB,2.5212E-05_JPRB,2.1382E-05_JPRB,1.0543E-05_JPRB,2.2029E-05_JPRB,5.3627E-05_JPRB,&
&8.2097E-05_JPRB,5.8785E-05_JPRB,4.6971E-06_JPRB/)
KAO( :, 2, 8, 3) = (/&
&3.3008E-05_JPRB,3.0976E-05_JPRB,2.7464E-05_JPRB,1.9851E-05_JPRB,1.5586E-05_JPRB,3.6260E-05_JPRB,&
&7.0608E-05_JPRB,6.2688E-05_JPRB,9.0473E-06_JPRB/)
KAO( :, 3, 8, 3) = (/&
&3.9152E-05_JPRB,3.7119E-05_JPRB,3.3223E-05_JPRB,2.7933E-05_JPRB,1.6165E-05_JPRB,2.3754E-05_JPRB,&
&5.6757E-05_JPRB,6.1667E-05_JPRB,1.6403E-05_JPRB/)
KAO( :, 4, 8, 3) = (/&
&4.5401E-05_JPRB,4.3320E-05_JPRB,3.8890E-05_JPRB,3.3512E-05_JPRB,2.5986E-05_JPRB,1.7686E-05_JPRB,&
&4.1699E-05_JPRB,5.5000E-05_JPRB,2.8038E-05_JPRB/)
KAO( :, 5, 8, 3) = (/&
&5.1574E-05_JPRB,4.9405E-05_JPRB,4.4463E-05_JPRB,3.8672E-05_JPRB,3.1838E-05_JPRB,1.9274E-05_JPRB,&
&2.7957E-05_JPRB,4.8608E-05_JPRB,4.5414E-05_JPRB/)
KAO( :, 1, 9, 3) = (/&
&2.1974E-05_JPRB,2.0130E-05_JPRB,1.3358E-05_JPRB,1.2253E-05_JPRB,3.2656E-05_JPRB,7.0337E-05_JPRB,&
&8.9242E-05_JPRB,5.7837E-05_JPRB,9.3121E-06_JPRB/)
KAO( :, 2, 9, 3) = (/&
&2.6942E-05_JPRB,2.5061E-05_JPRB,2.1391E-05_JPRB,1.1226E-05_JPRB,2.1710E-05_JPRB,5.1789E-05_JPRB,&
&7.4746E-05_JPRB,5.8409E-05_JPRB,1.8445E-05_JPRB/)
KAO( :, 3, 9, 3) = (/&
&3.2174E-05_JPRB,3.0300E-05_JPRB,2.6794E-05_JPRB,1.9848E-05_JPRB,1.5650E-05_JPRB,3.5796E-05_JPRB,&
&6.3518E-05_JPRB,6.2556E-05_JPRB,3.5097E-05_JPRB/)
KAO( :, 4, 9, 3) = (/&
&3.7549E-05_JPRB,3.5640E-05_JPRB,3.1882E-05_JPRB,2.6804E-05_JPRB,1.5301E-05_JPRB,2.3066E-05_JPRB,&
&5.1951E-05_JPRB,5.9042E-05_JPRB,6.2870E-05_JPRB/)
KAO( :, 5, 9, 3) = (/&
&4.2852E-05_JPRB,4.0889E-05_JPRB,3.6715E-05_JPRB,3.1666E-05_JPRB,2.4183E-05_JPRB,1.7177E-05_JPRB,&
&4.0166E-05_JPRB,5.1290E-05_JPRB,1.0621E-04_JPRB/)
KAO( :, 1,10, 3) = (/&
&1.7885E-05_JPRB,1.6093E-05_JPRB,7.4609E-06_JPRB,1.9809E-05_JPRB,4.8743E-05_JPRB,8.4191E-05_JPRB,&
&9.7811E-05_JPRB,5.7087E-05_JPRB,2.4684E-05_JPRB/)
KAO( :, 2,10, 3) = (/&
&2.2205E-05_JPRB,2.0473E-05_JPRB,1.4192E-05_JPRB,1.3653E-05_JPRB,3.3673E-05_JPRB,6.6332E-05_JPRB,&
&8.1889E-05_JPRB,5.8933E-05_JPRB,4.8726E-05_JPRB/)
KAO( :, 3,10, 3) = (/&
&2.6710E-05_JPRB,2.4979E-05_JPRB,2.1384E-05_JPRB,1.1205E-05_JPRB,2.2836E-05_JPRB,5.0904E-05_JPRB,&
&6.7817E-05_JPRB,6.0017E-05_JPRB,9.5318E-05_JPRB/)
KAO( :, 4,10, 3) = (/&
&3.1308E-05_JPRB,2.9540E-05_JPRB,2.6146E-05_JPRB,1.9462E-05_JPRB,1.5742E-05_JPRB,3.6775E-05_JPRB,&
&5.7447E-05_JPRB,6.0670E-05_JPRB,1.7750E-04_JPRB/)
KAO( :, 5,10, 3) = (/&
&3.5884E-05_JPRB,3.4076E-05_JPRB,3.0469E-05_JPRB,2.5574E-05_JPRB,1.4532E-05_JPRB,2.3848E-05_JPRB,&
&4.8505E-05_JPRB,5.5852E-05_JPRB,3.1067E-04_JPRB/)
KAO( :, 1,11, 3) = (/&
&1.6247E-05_JPRB,1.4357E-05_JPRB,6.7662E-06_JPRB,2.3639E-05_JPRB,5.5683E-05_JPRB,8.1956E-05_JPRB,&
&9.4483E-05_JPRB,5.8077E-05_JPRB,3.4483E-05_JPRB/)
KAO( :, 2,11, 3) = (/&
&2.0083E-05_JPRB,1.8438E-05_JPRB,1.1223E-05_JPRB,1.6583E-05_JPRB,3.8809E-05_JPRB,6.7379E-05_JPRB,&
&8.0717E-05_JPRB,5.8833E-05_JPRB,6.8180E-05_JPRB/)
KAO( :, 3,11, 3) = (/&
&2.4035E-05_JPRB,2.2414E-05_JPRB,1.8252E-05_JPRB,1.1545E-05_JPRB,2.7168E-05_JPRB,5.4230E-05_JPRB,&
&6.6296E-05_JPRB,5.8218E-05_JPRB,1.3381E-04_JPRB/)
KAO( :, 4,11, 3) = (/&
&2.8028E-05_JPRB,2.6371E-05_JPRB,2.3077E-05_JPRB,1.4565E-05_JPRB,1.8361E-05_JPRB,4.2537E-05_JPRB,&
&5.6345E-05_JPRB,5.9076E-05_JPRB,2.5000E-04_JPRB/)
KAO( :, 5,11, 3) = (/&
&3.1996E-05_JPRB,3.0330E-05_JPRB,2.7020E-05_JPRB,2.1917E-05_JPRB,1.3395E-05_JPRB,2.9523E-05_JPRB,&
&4.8541E-05_JPRB,5.5094E-05_JPRB,4.3853E-04_JPRB/)
KAO( :, 1,12, 3) = (/&
&1.4787E-05_JPRB,1.2868E-05_JPRB,7.7779E-06_JPRB,2.3775E-05_JPRB,5.3535E-05_JPRB,7.5004E-05_JPRB,&
&8.6201E-05_JPRB,6.0383E-05_JPRB,3.6484E-05_JPRB/)
KAO( :, 2,12, 3) = (/&
&1.8188E-05_JPRB,1.6624E-05_JPRB,9.6989E-06_JPRB,1.6809E-05_JPRB,3.8801E-05_JPRB,6.1756E-05_JPRB,&
&7.3880E-05_JPRB,5.7828E-05_JPRB,7.2267E-05_JPRB/)
KAO( :, 3,12, 3) = (/&
&2.1698E-05_JPRB,2.0162E-05_JPRB,1.6039E-05_JPRB,1.1681E-05_JPRB,2.6941E-05_JPRB,5.0140E-05_JPRB,&
&6.0455E-05_JPRB,5.6955E-05_JPRB,1.4213E-04_JPRB/)
KAO( :, 4,12, 3) = (/&
&2.5223E-05_JPRB,2.3667E-05_JPRB,2.0595E-05_JPRB,1.1968E-05_JPRB,1.8179E-05_JPRB,4.0062E-05_JPRB,&
&5.0860E-05_JPRB,5.5338E-05_JPRB,2.6585E-04_JPRB/)
KAO( :, 5,12, 3) = (/&
&2.8679E-05_JPRB,2.7160E-05_JPRB,2.4085E-05_JPRB,1.8993E-05_JPRB,1.3232E-05_JPRB,3.0080E-05_JPRB,&
&4.4162E-05_JPRB,5.0190E-05_JPRB,4.6593E-04_JPRB/)
KAO( :, 1,13, 3) = (/&
&1.3378E-05_JPRB,1.1412E-05_JPRB,8.0344E-06_JPRB,2.3863E-05_JPRB,5.0631E-05_JPRB,6.7851E-05_JPRB,&
&7.7279E-05_JPRB,5.9944E-05_JPRB,3.1248E-05_JPRB/)
KAO( :, 2,13, 3) = (/&
&1.6405E-05_JPRB,1.4918E-05_JPRB,8.1452E-06_JPRB,1.7072E-05_JPRB,3.8399E-05_JPRB,5.6349E-05_JPRB,&
&6.7351E-05_JPRB,5.6397E-05_JPRB,6.1993E-05_JPRB/)
KAO( :, 3,13, 3) = (/&
&1.9514E-05_JPRB,1.8083E-05_JPRB,1.3959E-05_JPRB,1.1780E-05_JPRB,2.7506E-05_JPRB,4.6033E-05_JPRB,&
&5.5011E-05_JPRB,5.3246E-05_JPRB,1.2205E-04_JPRB/)
KAO( :, 4,13, 3) = (/&
&2.2612E-05_JPRB,2.1175E-05_JPRB,1.8198E-05_JPRB,9.8216E-06_JPRB,1.8940E-05_JPRB,3.7116E-05_JPRB,&
&4.6044E-05_JPRB,5.0287E-05_JPRB,2.2822E-04_JPRB/)
KAO( :, 5,13, 3) = (/&
&2.5652E-05_JPRB,2.4254E-05_JPRB,2.1392E-05_JPRB,1.5930E-05_JPRB,1.2761E-05_JPRB,2.9362E-05_JPRB,&
&4.0037E-05_JPRB,4.5639E-05_JPRB,3.9941E-04_JPRB/)
KAO( :, 1, 1, 4) = (/&
&1.9325E-04_JPRB,1.8065E-04_JPRB,1.6180E-04_JPRB,1.4199E-04_JPRB,1.2006E-04_JPRB,9.6342E-05_JPRB,&
&6.5622E-05_JPRB,4.8423E-05_JPRB,3.6972E-05_JPRB/)
KAO( :, 2, 1, 4) = (/&
&2.0819E-04_JPRB,1.9606E-04_JPRB,1.7737E-04_JPRB,1.5604E-04_JPRB,1.3291E-04_JPRB,1.0794E-04_JPRB,&
&7.9216E-05_JPRB,4.1605E-05_JPRB,3.5731E-05_JPRB/)
KAO( :, 3, 1, 4) = (/&
&2.2206E-04_JPRB,2.1170E-04_JPRB,1.9336E-04_JPRB,1.7130E-04_JPRB,1.4701E-04_JPRB,1.2089E-04_JPRB,&
&9.0968E-05_JPRB,4.3271E-05_JPRB,3.0303E-05_JPRB/)
KAO( :, 4, 1, 4) = (/&
&2.3676E-04_JPRB,2.2953E-04_JPRB,2.1085E-04_JPRB,1.8785E-04_JPRB,1.6294E-04_JPRB,1.3496E-04_JPRB,&
&1.0281E-04_JPRB,6.1284E-05_JPRB,3.2172E-05_JPRB/)
KAO( :, 5, 1, 4) = (/&
&2.5437E-04_JPRB,2.4947E-04_JPRB,2.3011E-04_JPRB,2.0700E-04_JPRB,1.8097E-04_JPRB,1.5051E-04_JPRB,&
&1.1633E-04_JPRB,7.7203E-05_JPRB,5.3094E-05_JPRB/)
KAO( :, 1, 2, 4) = (/&
&1.7573E-04_JPRB,1.6392E-04_JPRB,1.4659E-04_JPRB,1.2809E-04_JPRB,1.0782E-04_JPRB,8.5648E-05_JPRB,&
&5.2006E-05_JPRB,5.2667E-05_JPRB,2.6840E-05_JPRB/)
KAO( :, 2, 2, 4) = (/&
&1.8913E-04_JPRB,1.7769E-04_JPRB,1.6041E-04_JPRB,1.4067E-04_JPRB,1.1911E-04_JPRB,9.5721E-05_JPRB,&
&6.8639E-05_JPRB,4.4992E-05_JPRB,2.4069E-05_JPRB/)
KAO( :, 3, 2, 4) = (/&
&2.0133E-04_JPRB,1.9150E-04_JPRB,1.7426E-04_JPRB,1.5374E-04_JPRB,1.3095E-04_JPRB,1.0674E-04_JPRB,&
&7.9754E-05_JPRB,3.2688E-05_JPRB,1.8110E-05_JPRB/)
KAO( :, 4, 2, 4) = (/&
&2.1403E-04_JPRB,2.0644E-04_JPRB,1.8885E-04_JPRB,1.6750E-04_JPRB,1.4394E-04_JPRB,1.1875E-04_JPRB,&
&8.9867E-05_JPRB,4.7809E-05_JPRB,3.1086E-05_JPRB/)
KAO( :, 5, 2, 4) = (/&
&2.2856E-04_JPRB,2.2298E-04_JPRB,2.0481E-04_JPRB,1.8286E-04_JPRB,1.5862E-04_JPRB,1.3164E-04_JPRB,&
&1.0114E-04_JPRB,6.3503E-05_JPRB,4.8865E-05_JPRB/)
KAO( :, 1, 3, 4) = (/&
&1.5562E-04_JPRB,1.4484E-04_JPRB,1.2927E-04_JPRB,1.1236E-04_JPRB,9.3995E-05_JPRB,7.3269E-05_JPRB,&
&3.7797E-05_JPRB,5.7431E-05_JPRB,1.5095E-05_JPRB/)
KAO( :, 2, 3, 4) = (/&
&1.6743E-04_JPRB,1.5710E-04_JPRB,1.4113E-04_JPRB,1.2321E-04_JPRB,1.0375E-04_JPRB,8.2299E-05_JPRB,&
&5.2915E-05_JPRB,4.4705E-05_JPRB,1.4179E-05_JPRB/)
KAO( :, 3, 3, 4) = (/&
&1.7855E-04_JPRB,1.6918E-04_JPRB,1.5296E-04_JPRB,1.3430E-04_JPRB,1.1381E-04_JPRB,9.1766E-05_JPRB,&
&6.6891E-05_JPRB,3.9451E-05_JPRB,2.0319E-05_JPRB/)
KAO( :, 4, 3, 4) = (/&
&1.8934E-04_JPRB,1.8180E-04_JPRB,1.6533E-04_JPRB,1.4585E-04_JPRB,1.2452E-04_JPRB,1.0168E-04_JPRB,&
&7.6248E-05_JPRB,3.2208E-05_JPRB,3.3927E-05_JPRB/)
KAO( :, 5, 3, 4) = (/&
&2.0107E-04_JPRB,1.9484E-04_JPRB,1.7806E-04_JPRB,1.5818E-04_JPRB,1.3631E-04_JPRB,1.1252E-04_JPRB,&
&8.5478E-05_JPRB,4.8964E-05_JPRB,4.8647E-05_JPRB/)
KAO( :, 1, 4, 4) = (/&
&1.3687E-04_JPRB,1.2644E-04_JPRB,1.1299E-04_JPRB,9.7757E-05_JPRB,8.1171E-05_JPRB,6.0079E-05_JPRB,&
&3.3581E-05_JPRB,5.5796E-05_JPRB,9.0880E-06_JPRB/)
KAO( :, 2, 4, 4) = (/&
&1.4693E-04_JPRB,1.3749E-04_JPRB,1.2327E-04_JPRB,1.0708E-04_JPRB,8.9715E-05_JPRB,7.0113E-05_JPRB,&
&3.5389E-05_JPRB,5.3371E-05_JPRB,1.3014E-05_JPRB/)
KAO( :, 3, 4, 4) = (/&
&1.5672E-04_JPRB,1.4837E-04_JPRB,1.3344E-04_JPRB,1.1660E-04_JPRB,9.8197E-05_JPRB,7.8371E-05_JPRB,&
&5.1608E-05_JPRB,4.1358E-05_JPRB,2.3902E-05_JPRB/)
KAO( :, 4, 4, 4) = (/&
&1.6639E-04_JPRB,1.5936E-04_JPRB,1.4405E-04_JPRB,1.2651E-04_JPRB,1.0733E-04_JPRB,8.6606E-05_JPRB,&
&6.3258E-05_JPRB,3.2371E-05_JPRB,3.6595E-05_JPRB/)
KAO( :, 5, 4, 4) = (/&
&1.7628E-04_JPRB,1.7040E-04_JPRB,1.5502E-04_JPRB,1.3697E-04_JPRB,1.1689E-04_JPRB,9.5499E-05_JPRB,&
&7.1870E-05_JPRB,3.2326E-05_JPRB,5.1692E-05_JPRB/)
KAO( :, 1, 5, 4) = (/&
&1.2014E-04_JPRB,1.0999E-04_JPRB,9.8155E-05_JPRB,8.4680E-05_JPRB,6.9013E-05_JPRB,3.7866E-05_JPRB,&
&4.6216E-05_JPRB,5.4078E-05_JPRB,7.0562E-06_JPRB/)
KAO( :, 2, 5, 4) = (/&
&1.2869E-04_JPRB,1.1940E-04_JPRB,1.0711E-04_JPRB,9.2677E-05_JPRB,7.7027E-05_JPRB,5.7820E-05_JPRB,&
&3.1601E-05_JPRB,5.4237E-05_JPRB,1.5420E-05_JPRB/)
KAO( :, 3, 5, 4) = (/&
&1.3705E-04_JPRB,1.2928E-04_JPRB,1.1605E-04_JPRB,1.0090E-04_JPRB,8.4608E-05_JPRB,6.6395E-05_JPRB,&
&3.0335E-05_JPRB,4.8756E-05_JPRB,2.5527E-05_JPRB/)
KAO( :, 4, 5, 4) = (/&
&1.4539E-04_JPRB,1.3907E-04_JPRB,1.2508E-04_JPRB,1.0941E-04_JPRB,9.2394E-05_JPRB,7.3775E-05_JPRB,&
&4.9339E-05_JPRB,4.0777E-05_JPRB,3.8427E-05_JPRB/)
KAO( :, 5, 5, 4) = (/&
&1.5402E-04_JPRB,1.4864E-04_JPRB,1.3443E-04_JPRB,1.1832E-04_JPRB,1.0042E-04_JPRB,8.1145E-05_JPRB,&
&5.9883E-05_JPRB,2.8598E-05_JPRB,5.5173E-05_JPRB/)
KAO( :, 1, 6, 4) = (/&
&1.0508E-04_JPRB,9.5482E-05_JPRB,8.4601E-05_JPRB,7.2633E-05_JPRB,5.7469E-05_JPRB,2.8022E-05_JPRB,&
&6.0470E-05_JPRB,5.5709E-05_JPRB,8.4537E-06_JPRB/)
KAO( :, 2, 6, 4) = (/&
&1.1254E-04_JPRB,1.0355E-04_JPRB,9.2576E-05_JPRB,7.9894E-05_JPRB,6.5248E-05_JPRB,3.5620E-05_JPRB,&
&4.1186E-05_JPRB,5.3203E-05_JPRB,1.5781E-05_JPRB/)
KAO( :, 3, 6, 4) = (/&
&1.1968E-04_JPRB,1.1191E-04_JPRB,1.0054E-04_JPRB,8.6961E-05_JPRB,7.2380E-05_JPRB,5.4688E-05_JPRB,&
&2.8839E-05_JPRB,5.2690E-05_JPRB,2.5759E-05_JPRB/)
KAO( :, 4, 6, 4) = (/&
&1.2668E-04_JPRB,1.2066E-04_JPRB,1.0839E-04_JPRB,9.4280E-05_JPRB,7.9174E-05_JPRB,6.2217E-05_JPRB,&
&2.9595E-05_JPRB,4.6245E-05_JPRB,3.9594E-05_JPRB/)
KAO( :, 5, 6, 4) = (/&
&1.3386E-04_JPRB,1.2916E-04_JPRB,1.1625E-04_JPRB,1.0183E-04_JPRB,8.5941E-05_JPRB,6.8663E-05_JPRB,&
&4.7108E-05_JPRB,3.8925E-05_JPRB,5.8371E-05_JPRB/)
KAO( :, 1, 7, 4) = (/&
&9.1290E-05_JPRB,8.2455E-05_JPRB,7.2640E-05_JPRB,6.1602E-05_JPRB,3.5951E-05_JPRB,3.2065E-05_JPRB,&
&6.9438E-05_JPRB,5.4588E-05_JPRB,8.8732E-06_JPRB/)
KAO( :, 2, 7, 4) = (/&
&9.8266E-05_JPRB,8.9923E-05_JPRB,7.9846E-05_JPRB,6.8611E-05_JPRB,5.4855E-05_JPRB,2.5347E-05_JPRB,&
&5.3484E-05_JPRB,5.4646E-05_JPRB,1.6319E-05_JPRB/)
KAO( :, 3, 7, 4) = (/&
&1.0452E-04_JPRB,9.6912E-05_JPRB,8.6790E-05_JPRB,7.4880E-05_JPRB,6.1588E-05_JPRB,3.4215E-05_JPRB,&
&3.8465E-05_JPRB,5.3097E-05_JPRB,2.7544E-05_JPRB/)
KAO( :, 4, 7, 4) = (/&
&1.1064E-04_JPRB,1.0436E-04_JPRB,9.3727E-05_JPRB,8.1191E-05_JPRB,6.7704E-05_JPRB,5.1369E-05_JPRB,&
&2.6755E-05_JPRB,5.1792E-05_JPRB,4.3707E-05_JPRB/)
KAO( :, 5, 7, 4) = (/&
&1.1674E-04_JPRB,1.1189E-04_JPRB,1.0064E-04_JPRB,8.7738E-05_JPRB,7.3682E-05_JPRB,5.8032E-05_JPRB,&
&2.8026E-05_JPRB,4.3741E-05_JPRB,6.6125E-05_JPRB/)
KAO( :, 1, 8, 4) = (/&
&7.8671E-05_JPRB,7.0723E-05_JPRB,6.1903E-05_JPRB,5.0899E-05_JPRB,2.5388E-05_JPRB,4.7045E-05_JPRB,&
&8.3139E-05_JPRB,5.2475E-05_JPRB,1.0506E-05_JPRB/)
KAO( :, 2, 8, 4) = (/&
&8.5114E-05_JPRB,7.7503E-05_JPRB,6.8369E-05_JPRB,5.8071E-05_JPRB,3.2941E-05_JPRB,3.1252E-05_JPRB,&
&6.5972E-05_JPRB,5.4053E-05_JPRB,1.9913E-05_JPRB/)
KAO( :, 3, 8, 4) = (/&
&9.0774E-05_JPRB,8.3700E-05_JPRB,7.4489E-05_JPRB,6.3931E-05_JPRB,5.1217E-05_JPRB,2.3975E-05_JPRB,&
&4.9768E-05_JPRB,5.3114E-05_JPRB,3.5011E-05_JPRB/)
KAO( :, 4, 8, 4) = (/&
&9.6188E-05_JPRB,9.0023E-05_JPRB,8.0588E-05_JPRB,6.9637E-05_JPRB,5.7276E-05_JPRB,3.0654E-05_JPRB,&
&3.6814E-05_JPRB,5.0886E-05_JPRB,5.7647E-05_JPRB/)
KAO( :, 5, 8, 4) = (/&
&1.0147E-04_JPRB,9.6459E-05_JPRB,8.6744E-05_JPRB,7.5335E-05_JPRB,6.2848E-05_JPRB,4.7544E-05_JPRB,&
&2.4830E-05_JPRB,4.9742E-05_JPRB,8.9972E-05_JPRB/)
KAO( :, 1, 9, 4) = (/&
&6.7736E-05_JPRB,6.0618E-05_JPRB,5.2744E-05_JPRB,3.0920E-05_JPRB,2.9239E-05_JPRB,6.2840E-05_JPRB,&
&9.2889E-05_JPRB,5.0470E-05_JPRB,2.2355E-05_JPRB/)
KAO( :, 2, 9, 4) = (/&
&7.3171E-05_JPRB,6.6259E-05_JPRB,5.8117E-05_JPRB,4.7578E-05_JPRB,2.3188E-05_JPRB,4.4116E-05_JPRB,&
&7.7151E-05_JPRB,5.4835E-05_JPRB,4.4341E-05_JPRB/)
KAO( :, 3, 9, 4) = (/&
&7.8488E-05_JPRB,7.2012E-05_JPRB,6.3679E-05_JPRB,5.4052E-05_JPRB,2.9892E-05_JPRB,3.0664E-05_JPRB,&
&6.0561E-05_JPRB,5.3817E-05_JPRB,8.1564E-05_JPRB/)
KAO( :, 4, 9, 4) = (/&
&8.3263E-05_JPRB,7.7446E-05_JPRB,6.8972E-05_JPRB,5.9229E-05_JPRB,4.7000E-05_JPRB,2.3105E-05_JPRB,&
&4.7608E-05_JPRB,5.0373E-05_JPRB,1.4008E-04_JPRB/)
KAO( :, 5, 9, 4) = (/&
&8.7956E-05_JPRB,8.2925E-05_JPRB,7.4329E-05_JPRB,6.4343E-05_JPRB,5.3101E-05_JPRB,2.7223E-05_JPRB,&
&3.3997E-05_JPRB,5.1225E-05_JPRB,2.2664E-04_JPRB/)
KAO( :, 1,10, 4) = (/&
&5.8447E-05_JPRB,5.2123E-05_JPRB,4.4386E-05_JPRB,2.1253E-05_JPRB,4.1633E-05_JPRB,7.5363E-05_JPRB,&
&9.7685E-05_JPRB,4.9222E-05_JPRB,5.9155E-05_JPRB/)
KAO( :, 2,10, 4) = (/&
&6.2971E-05_JPRB,5.6773E-05_JPRB,4.9349E-05_JPRB,2.7108E-05_JPRB,2.8492E-05_JPRB,5.8974E-05_JPRB,&
&8.8305E-05_JPRB,5.1607E-05_JPRB,1.2250E-04_JPRB/)
KAO( :, 3,10, 4) = (/&
&6.7713E-05_JPRB,6.1803E-05_JPRB,5.4313E-05_JPRB,4.4294E-05_JPRB,2.2166E-05_JPRB,4.3639E-05_JPRB,&
&7.2310E-05_JPRB,5.3792E-05_JPRB,2.3595E-04_JPRB/)
KAO( :, 4,10, 4) = (/&
&7.2017E-05_JPRB,6.6651E-05_JPRB,5.9032E-05_JPRB,5.0145E-05_JPRB,2.5984E-05_JPRB,3.1163E-05_JPRB,&
&5.5814E-05_JPRB,5.4096E-05_JPRB,4.2155E-04_JPRB/)
KAO( :, 5,10, 4) = (/&
&7.6122E-05_JPRB,7.1340E-05_JPRB,6.3672E-05_JPRB,5.4807E-05_JPRB,4.2703E-05_JPRB,2.2571E-05_JPRB,&
&4.5447E-05_JPRB,5.0941E-05_JPRB,7.0536E-04_JPRB/)
KAO( :, 1,11, 4) = (/&
&5.1997E-05_JPRB,4.6399E-05_JPRB,3.7006E-05_JPRB,2.2118E-05_JPRB,4.9070E-05_JPRB,8.0297E-05_JPRB,&
&9.7665E-05_JPRB,4.9036E-05_JPRB,8.3819E-05_JPRB/)
KAO( :, 2,11, 4) = (/&
&5.5995E-05_JPRB,5.0499E-05_JPRB,4.3536E-05_JPRB,1.8160E-05_JPRB,3.3942E-05_JPRB,6.1798E-05_JPRB,&
&8.7929E-05_JPRB,5.1899E-05_JPRB,1.7378E-04_JPRB/)
KAO( :, 3,11, 4) = (/&
&6.0050E-05_JPRB,5.4855E-05_JPRB,4.8042E-05_JPRB,3.2999E-05_JPRB,2.4599E-05_JPRB,4.8087E-05_JPRB,&
&7.2580E-05_JPRB,5.4376E-05_JPRB,3.3527E-04_JPRB/)
KAO( :, 4,11, 4) = (/&
&6.3834E-05_JPRB,5.9102E-05_JPRB,5.2252E-05_JPRB,4.3696E-05_JPRB,1.9003E-05_JPRB,3.4301E-05_JPRB,&
&5.7788E-05_JPRB,5.3890E-05_JPRB,5.9988E-04_JPRB/)
KAO( :, 5,11, 4) = (/&
&6.7488E-05_JPRB,6.3205E-05_JPRB,5.6377E-05_JPRB,4.8245E-05_JPRB,3.1229E-05_JPRB,2.6140E-05_JPRB,&
&4.5484E-05_JPRB,5.1296E-05_JPRB,1.0059E-03_JPRB/)
KAO( :, 1,12, 4) = (/&
&4.6056E-05_JPRB,4.1083E-05_JPRB,2.9802E-05_JPRB,2.2251E-05_JPRB,4.6624E-05_JPRB,7.2962E-05_JPRB,&
&9.3907E-05_JPRB,4.7563E-05_JPRB,8.9454E-05_JPRB/)
KAO( :, 2,12, 4) = (/&
&4.9615E-05_JPRB,4.4762E-05_JPRB,3.8254E-05_JPRB,1.6590E-05_JPRB,3.3432E-05_JPRB,5.6542E-05_JPRB,&
&8.1508E-05_JPRB,5.1901E-05_JPRB,1.8559E-04_JPRB/)
KAO( :, 3,12, 4) = (/&
&5.3180E-05_JPRB,4.8610E-05_JPRB,4.2465E-05_JPRB,2.5666E-05_JPRB,2.4567E-05_JPRB,4.4887E-05_JPRB,&
&6.5994E-05_JPRB,5.4335E-05_JPRB,3.5825E-04_JPRB/)
KAO( :, 4,12, 4) = (/&
&5.6562E-05_JPRB,5.2350E-05_JPRB,4.6232E-05_JPRB,3.8181E-05_JPRB,1.8227E-05_JPRB,3.2932E-05_JPRB,&
&5.2904E-05_JPRB,5.3475E-05_JPRB,6.4181E-04_JPRB/)
KAO( :, 5,12, 4) = (/&
&5.9903E-05_JPRB,5.6017E-05_JPRB,4.9962E-05_JPRB,4.2621E-05_JPRB,2.4691E-05_JPRB,2.4714E-05_JPRB,&
&4.1916E-05_JPRB,5.0025E-05_JPRB,1.0767E-03_JPRB/)
KAO( :, 1,13, 4) = (/&
&4.0560E-05_JPRB,3.6160E-05_JPRB,2.3255E-05_JPRB,2.2093E-05_JPRB,4.4020E-05_JPRB,6.7810E-05_JPRB,&
&8.9069E-05_JPRB,4.8857E-05_JPRB,7.6979E-05_JPRB/)
KAO( :, 2,13, 4) = (/&
&4.3721E-05_JPRB,3.9447E-05_JPRB,3.3315E-05_JPRB,1.5735E-05_JPRB,3.2401E-05_JPRB,5.2990E-05_JPRB,&
&7.4939E-05_JPRB,5.2762E-05_JPRB,1.5983E-04_JPRB/)
KAO( :, 3,13, 4) = (/&
&4.6874E-05_JPRB,4.2856E-05_JPRB,3.7307E-05_JPRB,1.9448E-05_JPRB,2.3246E-05_JPRB,4.1872E-05_JPRB,&
&6.0127E-05_JPRB,5.4225E-05_JPRB,3.0871E-04_JPRB/)
KAO( :, 4,13, 4) = (/&
&4.9922E-05_JPRB,4.6146E-05_JPRB,4.0717E-05_JPRB,3.2736E-05_JPRB,1.7797E-05_JPRB,3.1779E-05_JPRB,&
&4.8971E-05_JPRB,5.3750E-05_JPRB,5.5309E-04_JPRB/)
KAO( :, 5,13, 4) = (/&
&5.3030E-05_JPRB,4.9529E-05_JPRB,4.4121E-05_JPRB,3.7423E-05_JPRB,1.9634E-05_JPRB,2.2842E-05_JPRB,&
&3.9348E-05_JPRB,4.8274E-05_JPRB,9.2736E-04_JPRB/)
KAO( :, 1, 1, 5) = (/&
&2.7778E-04_JPRB,2.5521E-04_JPRB,2.2685E-04_JPRB,1.9591E-04_JPRB,1.6332E-04_JPRB,1.2879E-04_JPRB,&
&9.0596E-05_JPRB,4.4043E-05_JPRB,3.2346E-05_JPRB/)
KAO( :, 2, 1, 5) = (/&
&2.9066E-04_JPRB,2.6987E-04_JPRB,2.4077E-04_JPRB,2.0932E-04_JPRB,1.7577E-04_JPRB,1.4048E-04_JPRB,&
&1.0294E-04_JPRB,3.8809E-05_JPRB,2.9426E-05_JPRB/)
KAO( :, 3, 1, 5) = (/&
&3.0544E-04_JPRB,2.8616E-04_JPRB,2.5754E-04_JPRB,2.2525E-04_JPRB,1.9101E-04_JPRB,1.5455E-04_JPRB,&
&1.1678E-04_JPRB,5.7173E-05_JPRB,3.3954E-05_JPRB/)
KAO( :, 4, 1, 5) = (/&
&3.2184E-04_JPRB,3.0525E-04_JPRB,2.7707E-04_JPRB,2.4441E-04_JPRB,2.0932E-04_JPRB,1.7239E-04_JPRB,&
&1.3430E-04_JPRB,8.9432E-05_JPRB,5.9307E-05_JPRB/)
KAO( :, 5, 1, 5) = (/&
&3.3997E-04_JPRB,3.2768E-04_JPRB,2.9971E-04_JPRB,2.6685E-04_JPRB,2.3158E-04_JPRB,1.9537E-04_JPRB,&
&1.5650E-04_JPRB,1.1300E-04_JPRB,9.1458E-05_JPRB/)
KAO( :, 1, 2, 5) = (/&
&2.6036E-04_JPRB,2.3849E-04_JPRB,2.1215E-04_JPRB,1.8325E-04_JPRB,1.5238E-04_JPRB,1.1978E-04_JPRB,&
&8.1666E-05_JPRB,4.4295E-05_JPRB,2.4496E-05_JPRB/)
KAO( :, 2, 2, 5) = (/&
&2.7147E-04_JPRB,2.5141E-04_JPRB,2.2439E-04_JPRB,1.9462E-04_JPRB,1.6271E-04_JPRB,1.2925E-04_JPRB,&
&9.2973E-05_JPRB,3.2500E-05_JPRB,1.9528E-05_JPRB/)
KAO( :, 3, 2, 5) = (/&
&2.8407E-04_JPRB,2.6548E-04_JPRB,2.3846E-04_JPRB,2.0759E-04_JPRB,1.7524E-04_JPRB,1.4054E-04_JPRB,&
&1.0396E-04_JPRB,4.5395E-05_JPRB,3.3431E-05_JPRB/)
KAO( :, 4, 2, 5) = (/&
&2.9719E-04_JPRB,2.8128E-04_JPRB,2.5423E-04_JPRB,2.2320E-04_JPRB,1.8996E-04_JPRB,1.5400E-04_JPRB,&
&1.1668E-04_JPRB,6.9584E-05_JPRB,5.7490E-05_JPRB/)
KAO( :, 5, 2, 5) = (/&
&3.1122E-04_JPRB,2.9870E-04_JPRB,2.7220E-04_JPRB,2.4100E-04_JPRB,2.0649E-04_JPRB,1.7035E-04_JPRB,&
&1.3266E-04_JPRB,9.1999E-05_JPRB,8.3000E-05_JPRB/)
KAO( :, 1, 3, 5) = (/&
&2.4050E-04_JPRB,2.1900E-04_JPRB,1.9501E-04_JPRB,1.6859E-04_JPRB,1.4005E-04_JPRB,1.0947E-04_JPRB,&
&5.4416E-05_JPRB,3.5695E-05_JPRB,1.3250E-05_JPRB/)
KAO( :, 2, 3, 5) = (/&
&2.4980E-04_JPRB,2.3024E-04_JPRB,2.0600E-04_JPRB,1.7839E-04_JPRB,1.4857E-04_JPRB,1.1723E-04_JPRB,&
&8.2222E-05_JPRB,4.3756E-05_JPRB,1.9778E-05_JPRB/)
KAO( :, 3, 3, 5) = (/&
&2.5986E-04_JPRB,2.4240E-04_JPRB,2.1776E-04_JPRB,1.8907E-04_JPRB,1.5831E-04_JPRB,1.2594E-04_JPRB,&
&9.1156E-05_JPRB,3.2284E-05_JPRB,3.8343E-05_JPRB/)
KAO( :, 4, 3, 5) = (/&
&2.7050E-04_JPRB,2.5528E-04_JPRB,2.3027E-04_JPRB,2.0105E-04_JPRB,1.6973E-04_JPRB,1.3628E-04_JPRB,&
&1.0110E-04_JPRB,4.6885E-05_JPRB,5.9630E-05_JPRB/)
KAO( :, 5, 3, 5) = (/&
&2.8151E-04_JPRB,2.6949E-04_JPRB,2.4440E-04_JPRB,2.1478E-04_JPRB,1.8246E-04_JPRB,1.4822E-04_JPRB,&
&1.1296E-04_JPRB,7.0463E-05_JPRB,8.2542E-05_JPRB/)
KAO( :, 1, 4, 5) = (/&
&2.2167E-04_JPRB,2.0054E-04_JPRB,1.7755E-04_JPRB,1.5346E-04_JPRB,1.2760E-04_JPRB,9.8873E-05_JPRB,&
&4.0720E-05_JPRB,3.6076E-05_JPRB,1.0820E-05_JPRB/)
KAO( :, 2, 4, 5) = (/&
&2.2949E-04_JPRB,2.0991E-04_JPRB,1.8792E-04_JPRB,1.6318E-04_JPRB,1.3546E-04_JPRB,1.0612E-04_JPRB,&
&6.1178E-05_JPRB,4.0667E-05_JPRB,2.5683E-05_JPRB/)
KAO( :, 3, 4, 5) = (/&
&2.3807E-04_JPRB,2.2061E-04_JPRB,1.9870E-04_JPRB,1.7224E-04_JPRB,1.4361E-04_JPRB,1.1345E-04_JPRB,&
&8.0170E-05_JPRB,3.9940E-05_JPRB,4.2610E-05_JPRB/)
KAO( :, 4, 4, 5) = (/&
&2.4662E-04_JPRB,2.3181E-04_JPRB,2.0905E-04_JPRB,1.8202E-04_JPRB,1.5268E-04_JPRB,1.2186E-04_JPRB,&
&8.8749E-05_JPRB,3.2893E-05_JPRB,6.1830E-05_JPRB/)
KAO( :, 5, 4, 5) = (/&
&2.5546E-04_JPRB,2.4342E-04_JPRB,2.2022E-04_JPRB,1.9281E-04_JPRB,1.6313E-04_JPRB,1.3125E-04_JPRB,&
&9.8124E-05_JPRB,4.6973E-05_JPRB,8.6084E-05_JPRB/)
KAO( :, 1, 5, 5) = (/&
&2.0312E-04_JPRB,1.8300E-04_JPRB,1.6095E-04_JPRB,1.3872E-04_JPRB,1.1510E-04_JPRB,8.6738E-05_JPRB,&
&4.3892E-05_JPRB,4.1155E-05_JPRB,1.4610E-05_JPRB/)
KAO( :, 2, 5, 5) = (/&
&2.1032E-04_JPRB,1.9153E-04_JPRB,1.7045E-04_JPRB,1.4818E-04_JPRB,1.2310E-04_JPRB,9.5120E-05_JPRB,&
&3.7530E-05_JPRB,4.0109E-05_JPRB,2.7956E-05_JPRB/)
KAO( :, 3, 5, 5) = (/&
&2.1754E-04_JPRB,2.0013E-04_JPRB,1.8048E-04_JPRB,1.5683E-04_JPRB,1.3036E-04_JPRB,1.0212E-04_JPRB,&
&6.5559E-05_JPRB,4.4646E-05_JPRB,4.3990E-05_JPRB/)
KAO( :, 4, 5, 5) = (/&
&2.2506E-04_JPRB,2.1008E-04_JPRB,1.8992E-04_JPRB,1.6512E-04_JPRB,1.3787E-04_JPRB,1.0933E-04_JPRB,&
&7.7878E-05_JPRB,3.3941E-05_JPRB,6.4638E-05_JPRB/)
KAO( :, 5, 5, 5) = (/&
&2.3238E-04_JPRB,2.2040E-04_JPRB,1.9936E-04_JPRB,1.7403E-04_JPRB,1.4649E-04_JPRB,1.1721E-04_JPRB,&
&8.5745E-05_JPRB,3.1943E-05_JPRB,9.1486E-05_JPRB/)
KAO( :, 1, 6, 5) = (/&
&1.8420E-04_JPRB,1.6521E-04_JPRB,1.4487E-04_JPRB,1.2401E-04_JPRB,1.0200E-04_JPRB,5.1119E-05_JPRB,&
&5.2764E-05_JPRB,4.0912E-05_JPRB,1.5202E-05_JPRB/)
KAO( :, 2, 6, 5) = (/&
&1.9125E-04_JPRB,1.7344E-04_JPRB,1.5331E-04_JPRB,1.3274E-04_JPRB,1.1039E-04_JPRB,8.3040E-05_JPRB,&
&4.0684E-05_JPRB,4.1198E-05_JPRB,2.7867E-05_JPRB/)
KAO( :, 3, 6, 5) = (/&
&1.9735E-04_JPRB,1.8080E-04_JPRB,1.6199E-04_JPRB,1.4097E-04_JPRB,1.1727E-04_JPRB,9.0932E-05_JPRB,&
&3.7180E-05_JPRB,4.3495E-05_JPRB,4.4553E-05_JPRB/)
KAO( :, 4, 6, 5) = (/&
&2.0383E-04_JPRB,1.8894E-04_JPRB,1.7073E-04_JPRB,1.4876E-04_JPRB,1.2398E-04_JPRB,9.7753E-05_JPRB,&
&6.3121E-05_JPRB,4.1277E-05_JPRB,6.7315E-05_JPRB/)
KAO( :, 5, 6, 5) = (/&
&2.1033E-04_JPRB,1.9804E-04_JPRB,1.7951E-04_JPRB,1.5655E-04_JPRB,1.3146E-04_JPRB,1.0454E-04_JPRB,&
&7.4462E-05_JPRB,2.9067E-05_JPRB,9.7382E-05_JPRB/)
KAO( :, 1, 7, 5) = (/&
&1.6701E-04_JPRB,1.4912E-04_JPRB,1.3042E-04_JPRB,1.1101E-04_JPRB,8.9476E-05_JPRB,4.0710E-05_JPRB,&
&6.0855E-05_JPRB,4.0116E-05_JPRB,1.6644E-05_JPRB/)
KAO( :, 2, 7, 5) = (/&
&1.7267E-04_JPRB,1.5557E-04_JPRB,1.3718E-04_JPRB,1.1786E-04_JPRB,9.7049E-05_JPRB,4.9928E-05_JPRB,&
&4.8787E-05_JPRB,4.5062E-05_JPRB,2.9556E-05_JPRB/)
KAO( :, 3, 7, 5) = (/&
&1.7837E-04_JPRB,1.6263E-04_JPRB,1.4469E-04_JPRB,1.2545E-04_JPRB,1.0416E-04_JPRB,7.8620E-05_JPRB,&
&3.6425E-05_JPRB,4.0796E-05_JPRB,4.8760E-05_JPRB/)
KAO( :, 4, 7, 5) = (/&
&1.8378E-04_JPRB,1.6956E-04_JPRB,1.5235E-04_JPRB,1.3267E-04_JPRB,1.1063E-04_JPRB,8.6254E-05_JPRB,&
&3.2851E-05_JPRB,4.0620E-05_JPRB,7.6055E-05_JPRB/)
KAO( :, 5, 7, 5) = (/&
&1.8944E-04_JPRB,1.7724E-04_JPRB,1.6021E-04_JPRB,1.4001E-04_JPRB,1.1733E-04_JPRB,9.2830E-05_JPRB,&
&6.1065E-05_JPRB,3.8081E-05_JPRB,1.1312E-04_JPRB/)
KAO( :, 1, 8, 5) = (/&
&1.5130E-04_JPRB,1.3448E-04_JPRB,1.1721E-04_JPRB,9.9034E-05_JPRB,5.7155E-05_JPRB,4.5775E-05_JPRB,&
&6.5418E-05_JPRB,3.6348E-05_JPRB,2.0483E-05_JPRB/)
KAO( :, 2, 8, 5) = (/&
&1.5492E-04_JPRB,1.3874E-04_JPRB,1.2199E-04_JPRB,1.0406E-04_JPRB,8.3301E-05_JPRB,3.7776E-05_JPRB,&
&5.8525E-05_JPRB,4.3657E-05_JPRB,3.7683E-05_JPRB/)
KAO( :, 3, 8, 5) = (/&
&1.6015E-04_JPRB,1.4504E-04_JPRB,1.2855E-04_JPRB,1.1077E-04_JPRB,9.0857E-05_JPRB,4.6752E-05_JPRB,&
&4.3822E-05_JPRB,4.5900E-05_JPRB,6.4480E-05_JPRB/)
KAO( :, 4, 8, 5) = (/&
&1.6485E-04_JPRB,1.5131E-04_JPRB,1.3522E-04_JPRB,1.1731E-04_JPRB,9.7584E-05_JPRB,7.3940E-05_JPRB,&
&3.2766E-05_JPRB,4.4537E-05_JPRB,1.0397E-04_JPRB/)
KAO( :, 5, 8, 5) = (/&
&1.6974E-04_JPRB,1.5791E-04_JPRB,1.4195E-04_JPRB,1.2381E-04_JPRB,1.0390E-04_JPRB,8.1150E-05_JPRB,&
&3.2012E-05_JPRB,4.1555E-05_JPRB,1.5936E-04_JPRB/)
KAO( :, 1, 9, 5) = (/&
&1.3564E-04_JPRB,1.2012E-04_JPRB,1.0422E-04_JPRB,8.6571E-05_JPRB,3.4561E-05_JPRB,5.5358E-05_JPRB,&
&6.8138E-05_JPRB,3.3996E-05_JPRB,4.5162E-05_JPRB/)
KAO( :, 2, 9, 5) = (/&
&1.3891E-04_JPRB,1.2385E-04_JPRB,1.0843E-04_JPRB,9.1664E-05_JPRB,5.0992E-05_JPRB,4.2386E-05_JPRB,&
&6.5806E-05_JPRB,4.0485E-05_JPRB,8.7517E-05_JPRB/)
KAO( :, 3, 9, 5) = (/&
&1.4289E-04_JPRB,1.2859E-04_JPRB,1.1355E-04_JPRB,9.7157E-05_JPRB,7.7469E-05_JPRB,3.4604E-05_JPRB,&
&5.5697E-05_JPRB,4.6781E-05_JPRB,1.5660E-04_JPRB/)
KAO( :, 4, 9, 5) = (/&
&1.4749E-04_JPRB,1.3449E-04_JPRB,1.1965E-04_JPRB,1.0332E-04_JPRB,8.5038E-05_JPRB,4.3487E-05_JPRB,&
&3.9087E-05_JPRB,4.7631E-05_JPRB,2.6232E-04_JPRB/)
KAO( :, 5, 9, 5) = (/&
&1.5175E-04_JPRB,1.4048E-04_JPRB,1.2566E-04_JPRB,1.0925E-04_JPRB,9.1216E-05_JPRB,6.9027E-05_JPRB,&
&3.0570E-05_JPRB,4.2818E-05_JPRB,4.1578E-04_JPRB/)
KAO( :, 1,10, 5) = (/&
&1.2050E-04_JPRB,1.0644E-04_JPRB,9.1895E-05_JPRB,5.4223E-05_JPRB,4.2282E-05_JPRB,7.1662E-05_JPRB,&
&7.3849E-05_JPRB,3.1216E-05_JPRB,1.2336E-04_JPRB/)
KAO( :, 2,10, 5) = (/&
&1.2385E-04_JPRB,1.1007E-04_JPRB,9.5885E-05_JPRB,7.9074E-05_JPRB,3.2785E-05_JPRB,5.1790E-05_JPRB,&
&7.0330E-05_JPRB,3.8106E-05_JPRB,2.4914E-04_JPRB/)
KAO( :, 3,10, 5) = (/&
&1.2701E-04_JPRB,1.1389E-04_JPRB,1.0009E-04_JPRB,8.4859E-05_JPRB,4.3697E-05_JPRB,3.8515E-05_JPRB,&
&6.4563E-05_JPRB,4.6857E-05_JPRB,4.6353E-04_JPRB/)
KAO( :, 4,10, 5) = (/&
&1.3108E-04_JPRB,1.1889E-04_JPRB,1.0547E-04_JPRB,9.0382E-05_JPRB,7.1811E-05_JPRB,3.1846E-05_JPRB,&
&5.3076E-05_JPRB,4.9334E-05_JPRB,8.0273E-04_JPRB/)
KAO( :, 5,10, 5) = (/&
&1.3517E-04_JPRB,1.2455E-04_JPRB,1.1096E-04_JPRB,9.6119E-05_JPRB,7.9300E-05_JPRB,3.9467E-05_JPRB,&
&3.6989E-05_JPRB,4.6816E-05_JPRB,1.3114E-03_JPRB/)
KAO( :, 1,11, 5) = (/&
&1.0765E-04_JPRB,9.5133E-05_JPRB,8.1740E-05_JPRB,2.9684E-05_JPRB,4.4771E-05_JPRB,7.3844E-05_JPRB,&
&7.4458E-05_JPRB,3.2353E-05_JPRB,1.7556E-04_JPRB/)
KAO( :, 2,11, 5) = (/&
&1.1086E-04_JPRB,9.8643E-05_JPRB,8.5755E-05_JPRB,6.3950E-05_JPRB,3.5072E-05_JPRB,5.6362E-05_JPRB,&
&7.3811E-05_JPRB,3.7974E-05_JPRB,3.5513E-04_JPRB/)
KAO( :, 3,11, 5) = (/&
&1.1390E-04_JPRB,1.0226E-04_JPRB,8.9873E-05_JPRB,7.5337E-05_JPRB,2.7488E-05_JPRB,4.0668E-05_JPRB,&
&6.6695E-05_JPRB,4.8469E-05_JPRB,6.6195E-04_JPRB/)
KAO( :, 4,11, 5) = (/&
&1.1768E-04_JPRB,1.0695E-04_JPRB,9.4758E-05_JPRB,8.0812E-05_JPRB,5.6203E-05_JPRB,3.0959E-05_JPRB,&
&5.4960E-05_JPRB,5.2325E-05_JPRB,1.1500E-03_JPRB/)
KAO( :, 5,11, 5) = (/&
&1.2143E-04_JPRB,1.1200E-04_JPRB,9.9665E-05_JPRB,8.6317E-05_JPRB,7.0507E-05_JPRB,2.8241E-05_JPRB,&
&4.0108E-05_JPRB,4.7823E-05_JPRB,1.8824E-03_JPRB/)
KAO( :, 1,12, 5) = (/&
&9.5550E-05_JPRB,8.4510E-05_JPRB,7.2433E-05_JPRB,2.4695E-05_JPRB,4.1319E-05_JPRB,6.8965E-05_JPRB,&
&7.5836E-05_JPRB,3.3972E-05_JPRB,1.8803E-04_JPRB/)
KAO( :, 2,12, 5) = (/&
&9.8585E-05_JPRB,8.7816E-05_JPRB,7.6262E-05_JPRB,5.0625E-05_JPRB,3.2099E-05_JPRB,5.2909E-05_JPRB,&
&7.1285E-05_JPRB,4.2092E-05_JPRB,3.8071E-04_JPRB/)
KAO( :, 3,12, 5) = (/&
&1.0170E-04_JPRB,9.1397E-05_JPRB,8.0291E-05_JPRB,6.6609E-05_JPRB,2.6053E-05_JPRB,3.8656E-05_JPRB,&
&6.2061E-05_JPRB,5.0288E-05_JPRB,7.1091E-04_JPRB/)
KAO( :, 4,12, 5) = (/&
&1.0532E-04_JPRB,9.5859E-05_JPRB,8.4741E-05_JPRB,7.2190E-05_JPRB,4.4571E-05_JPRB,2.9606E-05_JPRB,&
&5.1144E-05_JPRB,5.0950E-05_JPRB,1.2367E-03_JPRB/)
KAO( :, 5,12, 5) = (/&
&1.0873E-04_JPRB,1.0026E-04_JPRB,8.9123E-05_JPRB,7.7100E-05_JPRB,6.2475E-05_JPRB,2.4044E-05_JPRB,&
&3.7811E-05_JPRB,4.5929E-05_JPRB,2.0278E-03_JPRB/)
KAO( :, 1,13, 5) = (/&
&8.4205E-05_JPRB,7.4539E-05_JPRB,6.3467E-05_JPRB,2.3538E-05_JPRB,3.8325E-05_JPRB,6.4275E-05_JPRB,&
&7.5533E-05_JPRB,3.5671E-05_JPRB,1.6223E-04_JPRB/)
KAO( :, 2,13, 5) = (/&
&8.7134E-05_JPRB,7.7658E-05_JPRB,6.7263E-05_JPRB,3.8163E-05_JPRB,2.9276E-05_JPRB,4.8144E-05_JPRB,&
&6.6883E-05_JPRB,4.5962E-05_JPRB,3.2881E-04_JPRB/)
KAO( :, 3,13, 5) = (/&
&9.0177E-05_JPRB,8.1122E-05_JPRB,7.1136E-05_JPRB,5.8053E-05_JPRB,2.4699E-05_JPRB,3.6684E-05_JPRB,&
&5.7406E-05_JPRB,5.0678E-05_JPRB,6.1498E-04_JPRB/)
KAO( :, 4,13, 5) = (/&
&9.3566E-05_JPRB,8.5217E-05_JPRB,7.5208E-05_JPRB,6.3816E-05_JPRB,3.3862E-05_JPRB,2.8346E-05_JPRB,&
&4.7321E-05_JPRB,4.6618E-05_JPRB,1.0717E-03_JPRB/)
KAO( :, 5,13, 5) = (/&
&9.6738E-05_JPRB,8.9098E-05_JPRB,7.9178E-05_JPRB,6.8356E-05_JPRB,5.4471E-05_JPRB,2.2350E-05_JPRB,&
&3.5198E-05_JPRB,4.4559E-05_JPRB,1.7596E-03_JPRB/)
KAO( :, 1, 1, 6) = (/&
&3.5218E-04_JPRB,3.2067E-04_JPRB,2.8542E-04_JPRB,2.4691E-04_JPRB,2.0715E-04_JPRB,1.6430E-04_JPRB,&
&1.1630E-04_JPRB,3.0602E-05_JPRB,2.2334E-05_JPRB/)
KAO( :, 2, 1, 6) = (/&
&3.6703E-04_JPRB,3.3779E-04_JPRB,3.0330E-04_JPRB,2.6523E-04_JPRB,2.2344E-04_JPRB,1.7999E-04_JPRB,&
&1.3446E-04_JPRB,5.1639E-05_JPRB,3.3226E-05_JPRB/)
KAO( :, 3, 1, 6) = (/&
&3.8585E-04_JPRB,3.5978E-04_JPRB,3.2593E-04_JPRB,2.8711E-04_JPRB,2.4473E-04_JPRB,2.0196E-04_JPRB,&
&1.5783E-04_JPRB,1.0327E-04_JPRB,6.5420E-05_JPRB/)
KAO( :, 4, 1, 6) = (/&
&4.0907E-04_JPRB,3.8577E-04_JPRB,3.5450E-04_JPRB,3.1632E-04_JPRB,2.7470E-04_JPRB,2.3182E-04_JPRB,&
&1.8685E-04_JPRB,1.3638E-04_JPRB,1.1847E-04_JPRB/)
KAO( :, 5, 1, 6) = (/&
&4.3737E-04_JPRB,4.1878E-04_JPRB,3.9158E-04_JPRB,3.5534E-04_JPRB,3.1369E-04_JPRB,2.6894E-04_JPRB,&
&2.2111E-04_JPRB,1.7023E-04_JPRB,1.6126E-04_JPRB/)
KAO( :, 1, 2, 6) = (/&
&3.3988E-04_JPRB,3.0828E-04_JPRB,2.7319E-04_JPRB,2.3566E-04_JPRB,1.9671E-04_JPRB,1.5488E-04_JPRB,&
&1.0656E-04_JPRB,2.4639E-05_JPRB,2.0135E-05_JPRB/)
KAO( :, 2, 2, 6) = (/&
&3.5074E-04_JPRB,3.2145E-04_JPRB,2.8720E-04_JPRB,2.5072E-04_JPRB,2.1014E-04_JPRB,1.6733E-04_JPRB,&
&1.2121E-04_JPRB,3.9180E-05_JPRB,2.9901E-05_JPRB/)
KAO( :, 3, 2, 6) = (/&
&3.6475E-04_JPRB,3.3829E-04_JPRB,3.0546E-04_JPRB,2.6776E-04_JPRB,2.2592E-04_JPRB,1.8277E-04_JPRB,&
&1.3792E-04_JPRB,7.3527E-05_JPRB,6.9892E-05_JPRB/)
KAO( :, 4, 2, 6) = (/&
&3.8225E-04_JPRB,3.5820E-04_JPRB,3.2688E-04_JPRB,2.8858E-04_JPRB,2.4665E-04_JPRB,2.0403E-04_JPRB,&
&1.5963E-04_JPRB,1.1035E-04_JPRB,1.0774E-04_JPRB/)
KAO( :, 5, 2, 6) = (/&
&4.0273E-04_JPRB,3.8268E-04_JPRB,3.5304E-04_JPRB,3.1570E-04_JPRB,2.7513E-04_JPRB,2.3154E-04_JPRB,&
&1.8624E-04_JPRB,1.3783E-04_JPRB,1.4438E-04_JPRB/)
KAO( :, 1, 3, 6) = (/&
&3.2586E-04_JPRB,2.9354E-04_JPRB,2.5840E-04_JPRB,2.2211E-04_JPRB,1.8493E-04_JPRB,1.4459E-04_JPRB,&
&9.3968E-05_JPRB,2.6836E-05_JPRB,1.7667E-05_JPRB/)
KAO( :, 2, 3, 6) = (/&
&3.3335E-04_JPRB,3.0322E-04_JPRB,2.6938E-04_JPRB,2.3450E-04_JPRB,1.9584E-04_JPRB,1.5458E-04_JPRB,&
&1.0872E-04_JPRB,2.7860E-05_JPRB,4.2305E-05_JPRB/)
KAO( :, 3, 3, 6) = (/&
&3.4307E-04_JPRB,3.1560E-04_JPRB,2.8356E-04_JPRB,2.4811E-04_JPRB,2.0859E-04_JPRB,1.6657E-04_JPRB,&
&1.2164E-04_JPRB,4.3049E-05_JPRB,7.4173E-05_JPRB/)
KAO( :, 4, 3, 6) = (/&
&3.5510E-04_JPRB,3.3067E-04_JPRB,3.0030E-04_JPRB,2.6396E-04_JPRB,2.2347E-04_JPRB,1.8094E-04_JPRB,&
&1.3617E-04_JPRB,8.0549E-05_JPRB,1.0462E-04_JPRB/)
KAO( :, 5, 3, 6) = (/&
&3.6934E-04_JPRB,3.4886E-04_JPRB,3.1925E-04_JPRB,2.8285E-04_JPRB,2.4246E-04_JPRB,1.9904E-04_JPRB,&
&1.5402E-04_JPRB,1.0740E-04_JPRB,1.4134E-04_JPRB/)
KAO( :, 1, 4, 6) = (/&
&3.1202E-04_JPRB,2.8003E-04_JPRB,2.4507E-04_JPRB,2.0972E-04_JPRB,1.7365E-04_JPRB,1.3503E-04_JPRB,&
&5.8768E-05_JPRB,2.9314E-05_JPRB,2.4023E-05_JPRB/)
KAO( :, 2, 4, 6) = (/&
&3.1813E-04_JPRB,2.8791E-04_JPRB,2.5394E-04_JPRB,2.1965E-04_JPRB,1.8377E-04_JPRB,1.4389E-04_JPRB,&
&9.7093E-05_JPRB,2.3337E-05_JPRB,5.0021E-05_JPRB/)
KAO( :, 3, 4, 6) = (/&
&3.2483E-04_JPRB,2.9675E-04_JPRB,2.6510E-04_JPRB,2.3175E-04_JPRB,1.9444E-04_JPRB,1.5360E-04_JPRB,&
&1.0928E-04_JPRB,3.0718E-05_JPRB,7.6252E-05_JPRB/)
KAO( :, 4, 4, 6) = (/&
&3.3350E-04_JPRB,3.0829E-04_JPRB,2.7872E-04_JPRB,2.4437E-04_JPRB,2.0593E-04_JPRB,1.6469E-04_JPRB,&
&1.2057E-04_JPRB,4.4984E-05_JPRB,1.0921E-04_JPRB/)
KAO( :, 5, 4, 6) = (/&
&3.4440E-04_JPRB,3.2288E-04_JPRB,2.9368E-04_JPRB,2.5882E-04_JPRB,2.1958E-04_JPRB,1.7772E-04_JPRB,&
&1.3279E-04_JPRB,8.3344E-05_JPRB,1.5068E-04_JPRB/)
KAO( :, 1, 5, 6) = (/&
&2.9770E-04_JPRB,2.6568E-04_JPRB,2.3231E-04_JPRB,1.9760E-04_JPRB,1.6264E-04_JPRB,1.2501E-04_JPRB,&
&5.2212E-05_JPRB,2.7851E-05_JPRB,2.9425E-05_JPRB/)
KAO( :, 2, 5, 6) = (/&
&3.0341E-04_JPRB,2.7316E-04_JPRB,2.3988E-04_JPRB,2.0612E-04_JPRB,1.7178E-04_JPRB,1.3444E-04_JPRB,&
&6.8808E-05_JPRB,2.4233E-05_JPRB,5.0902E-05_JPRB/)
KAO( :, 3, 5, 6) = (/&
&3.0855E-04_JPRB,2.8044E-04_JPRB,2.4851E-04_JPRB,2.1615E-04_JPRB,1.8164E-04_JPRB,1.4300E-04_JPRB,&
&9.8456E-05_JPRB,2.2567E-05_JPRB,7.8789E-05_JPRB/)
KAO( :, 4, 5, 6) = (/&
&3.1479E-04_JPRB,2.8896E-04_JPRB,2.6020E-04_JPRB,2.2793E-04_JPRB,1.9183E-04_JPRB,1.5203E-04_JPRB,&
&1.0899E-04_JPRB,3.3886E-05_JPRB,1.1586E-04_JPRB/)
KAO( :, 5, 5, 6) = (/&
&3.2275E-04_JPRB,3.0062E-04_JPRB,2.7287E-04_JPRB,2.4005E-04_JPRB,2.0243E-04_JPRB,1.6230E-04_JPRB,&
&1.1916E-04_JPRB,4.8642E-05_JPRB,1.6375E-04_JPRB/)
KAO( :, 1, 6, 6) = (/&
&2.8451E-04_JPRB,2.5278E-04_JPRB,2.2028E-04_JPRB,1.8707E-04_JPRB,1.5294E-04_JPRB,1.1368E-04_JPRB,&
&5.1499E-05_JPRB,2.2491E-05_JPRB,2.9300E-05_JPRB/)
KAO( :, 2, 6, 6) = (/&
&2.8818E-04_JPRB,2.5756E-04_JPRB,2.2592E-04_JPRB,1.9305E-04_JPRB,1.5960E-04_JPRB,1.2358E-04_JPRB,&
&4.9278E-05_JPRB,2.8018E-05_JPRB,5.0020E-05_JPRB/)
KAO( :, 3, 6, 6) = (/&
&2.9308E-04_JPRB,2.6479E-04_JPRB,2.3342E-04_JPRB,2.0176E-04_JPRB,1.6837E-04_JPRB,1.3278E-04_JPRB,&
&7.5022E-05_JPRB,2.4679E-05_JPRB,7.9554E-05_JPRB/)
KAO( :, 4, 6, 6) = (/&
&2.9797E-04_JPRB,2.7171E-04_JPRB,2.4252E-04_JPRB,2.1130E-04_JPRB,1.7798E-04_JPRB,1.4080E-04_JPRB,&
&9.8593E-05_JPRB,2.6413E-05_JPRB,1.2029E-04_JPRB/)
KAO( :, 5, 6, 6) = (/&
&3.0385E-04_JPRB,2.8038E-04_JPRB,2.5320E-04_JPRB,2.2231E-04_JPRB,1.8746E-04_JPRB,1.4953E-04_JPRB,&
&1.0805E-04_JPRB,3.4957E-05_JPRB,1.7428E-04_JPRB/)
KAO( :, 1, 7, 6) = (/&
&2.7154E-04_JPRB,2.4047E-04_JPRB,2.0869E-04_JPRB,1.7653E-04_JPRB,1.4316E-04_JPRB,6.3076E-05_JPRB,&
&5.3076E-05_JPRB,1.8799E-05_JPRB,2.9459E-05_JPRB/)
KAO( :, 2, 7, 6) = (/&
&2.7322E-04_JPRB,2.4322E-04_JPRB,2.1245E-04_JPRB,1.8113E-04_JPRB,1.4876E-04_JPRB,1.1194E-04_JPRB,&
&4.9416E-05_JPRB,2.1766E-05_JPRB,5.1977E-05_JPRB/)
KAO( :, 3, 7, 6) = (/&
&2.7795E-04_JPRB,2.4940E-04_JPRB,2.1931E-04_JPRB,1.8853E-04_JPRB,1.5632E-04_JPRB,1.2173E-04_JPRB,&
&4.3459E-05_JPRB,2.7910E-05_JPRB,8.5515E-05_JPRB/)
KAO( :, 4, 7, 6) = (/&
&2.8245E-04_JPRB,2.5609E-04_JPRB,2.2726E-04_JPRB,1.9695E-04_JPRB,1.6467E-04_JPRB,1.3028E-04_JPRB,&
&8.3030E-05_JPRB,3.1238E-05_JPRB,1.3325E-04_JPRB/)
KAO( :, 5, 7, 6) = (/&
&2.8703E-04_JPRB,2.6318E-04_JPRB,2.3595E-04_JPRB,2.0579E-04_JPRB,1.7351E-04_JPRB,1.3813E-04_JPRB,&
&9.7826E-05_JPRB,2.9395E-05_JPRB,1.9863E-04_JPRB/)
KAO( :, 1, 8, 6) = (/&
&2.5666E-04_JPRB,2.2665E-04_JPRB,1.9623E-04_JPRB,1.6528E-04_JPRB,1.3188E-04_JPRB,5.2672E-05_JPRB,&
&5.4590E-05_JPRB,1.5212E-05_JPRB,3.5336E-05_JPRB/)
KAO( :, 2, 8, 6) = (/&
&2.5871E-04_JPRB,2.2976E-04_JPRB,1.9987E-04_JPRB,1.6976E-04_JPRB,1.3838E-04_JPRB,6.2293E-05_JPRB,&
&5.1049E-05_JPRB,2.0990E-05_JPRB,6.5164E-05_JPRB/)
KAO( :, 3, 8, 6) = (/&
&2.6131E-04_JPRB,2.3354E-04_JPRB,2.0472E-04_JPRB,1.7542E-04_JPRB,1.4479E-04_JPRB,1.0936E-04_JPRB,&
&4.3593E-05_JPRB,2.7838E-05_JPRB,1.1164E-04_JPRB/)
KAO( :, 4, 8, 6) = (/&
&2.6597E-04_JPRB,2.3972E-04_JPRB,2.1214E-04_JPRB,1.8293E-04_JPRB,1.5207E-04_JPRB,1.1872E-04_JPRB,&
&4.2928E-05_JPRB,2.9399E-05_JPRB,1.8005E-04_JPRB/)
KAO( :, 5, 8, 6) = (/&
&2.6965E-04_JPRB,2.4602E-04_JPRB,2.1946E-04_JPRB,1.9059E-04_JPRB,1.5945E-04_JPRB,1.2678E-04_JPRB,&
&8.1506E-05_JPRB,3.0396E-05_JPRB,2.7574E-04_JPRB/)
KAO( :, 1, 9, 6) = (/&
&2.4051E-04_JPRB,2.1191E-04_JPRB,1.8318E-04_JPRB,1.5348E-04_JPRB,8.9740E-05_JPRB,5.6443E-05_JPRB,&
&5.8323E-05_JPRB,1.3977E-05_JPRB,7.8714E-05_JPRB/)
KAO( :, 2, 9, 6) = (/&
&2.4280E-04_JPRB,2.1514E-04_JPRB,1.8659E-04_JPRB,1.5766E-04_JPRB,1.2621E-04_JPRB,4.8115E-05_JPRB,&
&5.1962E-05_JPRB,1.8297E-05_JPRB,1.5286E-04_JPRB/)
KAO( :, 3, 9, 6) = (/&
&2.4480E-04_JPRB,2.1809E-04_JPRB,1.9044E-04_JPRB,1.6238E-04_JPRB,1.3286E-04_JPRB,5.9719E-05_JPRB,&
&4.7955E-05_JPRB,2.2245E-05_JPRB,2.7373E-04_JPRB/)
KAO( :, 4, 9, 6) = (/&
&2.4800E-04_JPRB,2.2255E-04_JPRB,1.9613E-04_JPRB,1.6836E-04_JPRB,1.3908E-04_JPRB,1.0477E-04_JPRB,&
&3.9262E-05_JPRB,3.1477E-05_JPRB,4.5768E-04_JPRB/)
KAO( :, 5, 9, 6) = (/&
&2.5161E-04_JPRB,2.2818E-04_JPRB,2.0281E-04_JPRB,1.7515E-04_JPRB,1.4598E-04_JPRB,1.1469E-04_JPRB,&
&3.6846E-05_JPRB,3.4477E-05_JPRB,7.2229E-04_JPRB/)
KAO( :, 1,10, 6) = (/&
&2.2330E-04_JPRB,1.9647E-04_JPRB,1.6947E-04_JPRB,1.4070E-04_JPRB,5.0397E-05_JPRB,6.4372E-05_JPRB,&
&5.4119E-05_JPRB,1.3671E-05_JPRB,2.1819E-04_JPRB/)
KAO( :, 2,10, 6) = (/&
&2.2579E-04_JPRB,1.9970E-04_JPRB,1.7289E-04_JPRB,1.4528E-04_JPRB,8.0532E-05_JPRB,5.4367E-05_JPRB,&
&6.0104E-05_JPRB,1.5483E-05_JPRB,4.4393E-04_JPRB/)
KAO( :, 3,10, 6) = (/&
&2.2759E-04_JPRB,2.0234E-04_JPRB,1.7625E-04_JPRB,1.4950E-04_JPRB,1.1945E-04_JPRB,4.4354E-05_JPRB,&
&5.3052E-05_JPRB,2.1110E-05_JPRB,8.2682E-04_JPRB/)
KAO( :, 4,10, 6) = (/&
&2.2922E-04_JPRB,2.0521E-04_JPRB,1.8016E-04_JPRB,1.5410E-04_JPRB,1.2582E-04_JPRB,5.3486E-05_JPRB,&
&4.4581E-05_JPRB,2.9122E-05_JPRB,1.4295E-03_JPRB/)
KAO( :, 5,10, 6) = (/&
&2.3198E-04_JPRB,2.0949E-04_JPRB,1.8557E-04_JPRB,1.5950E-04_JPRB,1.3216E-04_JPRB,9.8775E-05_JPRB,&
&3.6643E-05_JPRB,3.6794E-05_JPRB,2.3221E-03_JPRB/)
KAO( :, 1,11, 6) = (/&
&2.0583E-04_JPRB,1.8127E-04_JPRB,1.5633E-04_JPRB,1.2776E-04_JPRB,4.7811E-05_JPRB,6.9737E-05_JPRB,&
&5.8557E-05_JPRB,1.2546E-05_JPRB,3.1512E-04_JPRB/)
KAO( :, 2,11, 6) = (/&
&2.0808E-04_JPRB,1.8417E-04_JPRB,1.5959E-04_JPRB,1.3341E-04_JPRB,4.2960E-05_JPRB,5.2587E-05_JPRB,&
&6.0943E-05_JPRB,1.7249E-05_JPRB,6.4309E-04_JPRB/)
KAO( :, 3,11, 6) = (/&
&2.0985E-04_JPRB,1.8679E-04_JPRB,1.6278E-04_JPRB,1.3786E-04_JPRB,1.0094E-04_JPRB,4.2926E-05_JPRB,&
&5.4000E-05_JPRB,2.1438E-05_JPRB,1.2009E-03_JPRB/)
KAO( :, 4,11, 6) = (/&
&2.1113E-04_JPRB,1.8931E-04_JPRB,1.6638E-04_JPRB,1.4208E-04_JPRB,1.1471E-04_JPRB,3.5997E-05_JPRB,&
&4.5064E-05_JPRB,2.9593E-05_JPRB,2.0809E-03_JPRB/)
KAO( :, 5,11, 6) = (/&
&2.1332E-04_JPRB,1.9322E-04_JPRB,1.7102E-04_JPRB,1.4678E-04_JPRB,1.2136E-04_JPRB,7.6714E-05_JPRB,&
&3.8255E-05_JPRB,4.0077E-05_JPRB,3.3932E-03_JPRB/)
KAO( :, 1,12, 6) = (/&
&1.8719E-04_JPRB,1.6501E-04_JPRB,1.4226E-04_JPRB,1.0840E-04_JPRB,4.3551E-05_JPRB,6.5135E-05_JPRB,&
&6.0449E-05_JPRB,1.2368E-05_JPRB,3.4134E-04_JPRB/)
KAO( :, 2,12, 6) = (/&
&1.8952E-04_JPRB,1.6785E-04_JPRB,1.4553E-04_JPRB,1.2117E-04_JPRB,3.5062E-05_JPRB,4.8573E-05_JPRB,&
&6.2841E-05_JPRB,1.5474E-05_JPRB,6.9803E-04_JPRB/)
KAO( :, 3,12, 6) = (/&
&1.9118E-04_JPRB,1.7048E-04_JPRB,1.4865E-04_JPRB,1.2583E-04_JPRB,8.1862E-05_JPRB,3.7617E-05_JPRB,&
&5.3564E-05_JPRB,2.1248E-05_JPRB,1.3057E-03_JPRB/)
KAO( :, 4,12, 6) = (/&
&1.9270E-04_JPRB,1.7320E-04_JPRB,1.5231E-04_JPRB,1.2983E-04_JPRB,1.0441E-04_JPRB,3.3342E-05_JPRB,&
&4.1959E-05_JPRB,3.5845E-05_JPRB,2.2690E-03_JPRB/)
KAO( :, 5,12, 6) = (/&
&1.9518E-04_JPRB,1.7738E-04_JPRB,1.5684E-04_JPRB,1.3457E-04_JPRB,1.1104E-04_JPRB,6.4947E-05_JPRB,&
&3.5407E-05_JPRB,4.3496E-05_JPRB,3.7128E-03_JPRB/)
KAO( :, 1,13, 6) = (/&
&1.6844E-04_JPRB,1.4859E-04_JPRB,1.2806E-04_JPRB,8.6165E-05_JPRB,4.0107E-05_JPRB,6.0133E-05_JPRB,&
&6.1357E-05_JPRB,1.2763E-05_JPRB,2.9734E-04_JPRB/)
KAO( :, 2,13, 6) = (/&
&1.7069E-04_JPRB,1.5140E-04_JPRB,1.3134E-04_JPRB,1.0891E-04_JPRB,3.2613E-05_JPRB,4.6872E-05_JPRB,&
&6.0094E-05_JPRB,1.5072E-05_JPRB,6.0887E-04_JPRB/)
KAO( :, 3,13, 6) = (/&
&1.7244E-04_JPRB,1.5407E-04_JPRB,1.3444E-04_JPRB,1.1361E-04_JPRB,6.4637E-05_JPRB,3.4627E-05_JPRB,&
&4.8765E-05_JPRB,2.7303E-05_JPRB,1.1416E-03_JPRB/)
KAO( :, 4,13, 6) = (/&
&1.7422E-04_JPRB,1.5702E-04_JPRB,1.3806E-04_JPRB,1.1756E-04_JPRB,9.3337E-05_JPRB,3.0148E-05_JPRB,&
&3.8538E-05_JPRB,4.2636E-05_JPRB,1.9903E-03_JPRB/)
KAO( :, 5,13, 6) = (/&
&1.7685E-04_JPRB,1.6120E-04_JPRB,1.4238E-04_JPRB,1.2222E-04_JPRB,1.0041E-04_JPRB,5.2947E-05_JPRB,&
&3.1886E-05_JPRB,4.0330E-05_JPRB,3.2638E-03_JPRB/)
KAO( :, 1, 1, 7) = (/&
&4.3889E-04_JPRB,3.9958E-04_JPRB,3.5783E-04_JPRB,3.1336E-04_JPRB,2.6698E-04_JPRB,2.1857E-04_JPRB,&
&1.6424E-04_JPRB,4.0399E-05_JPRB,2.8247E-05_JPRB/)
KAO( :, 2, 1, 7) = (/&
&4.5976E-04_JPRB,4.2497E-04_JPRB,3.8736E-04_JPRB,3.4581E-04_JPRB,3.0220E-04_JPRB,2.5189E-04_JPRB,&
&1.9631E-04_JPRB,1.0954E-04_JPRB,6.7630E-05_JPRB/)
KAO( :, 3, 1, 7) = (/&
&4.8944E-04_JPRB,4.6159E-04_JPRB,4.2784E-04_JPRB,3.8962E-04_JPRB,3.4476E-04_JPRB,2.9292E-04_JPRB,&
&2.3514E-04_JPRB,1.7014E-04_JPRB,1.5365E-04_JPRB/)
KAO( :, 4, 1, 7) = (/&
&5.2941E-04_JPRB,5.1023E-04_JPRB,4.7948E-04_JPRB,4.4219E-04_JPRB,3.9618E-04_JPRB,3.4392E-04_JPRB,&
&2.8630E-04_JPRB,2.2387E-04_JPRB,2.1803E-04_JPRB/)
KAO( :, 5, 1, 7) = (/&
&5.7974E-04_JPRB,5.6859E-04_JPRB,5.4269E-04_JPRB,5.0514E-04_JPRB,4.6062E-04_JPRB,4.1002E-04_JPRB,&
&3.5338E-04_JPRB,2.8599E-04_JPRB,2.8983E-04_JPRB/)
KAO( :, 1, 2, 7) = (/&
&4.2778E-04_JPRB,3.8751E-04_JPRB,3.4424E-04_JPRB,2.9838E-04_JPRB,2.5188E-04_JPRB,2.0290E-04_JPRB,&
&1.4875E-04_JPRB,2.6658E-05_JPRB,3.1573E-05_JPRB/)
KAO( :, 2, 2, 7) = (/&
&4.4270E-04_JPRB,4.0621E-04_JPRB,3.6561E-04_JPRB,3.2154E-04_JPRB,2.7708E-04_JPRB,2.2750E-04_JPRB,&
&1.7305E-04_JPRB,6.5324E-05_JPRB,8.8564E-05_JPRB/)
KAO( :, 3, 2, 7) = (/&
&4.6316E-04_JPRB,4.3154E-04_JPRB,3.9306E-04_JPRB,3.5392E-04_JPRB,3.0888E-04_JPRB,2.5881E-04_JPRB,&
&2.0328E-04_JPRB,1.3652E-04_JPRB,1.4781E-04_JPRB/)
KAO( :, 4, 2, 7) = (/&
&4.8891E-04_JPRB,4.6467E-04_JPRB,4.3116E-04_JPRB,3.9316E-04_JPRB,3.4835E-04_JPRB,2.9748E-04_JPRB,&
&2.4237E-04_JPRB,1.8240E-04_JPRB,2.0533E-04_JPRB/)
KAO( :, 5, 2, 7) = (/&
&5.2249E-04_JPRB,5.0735E-04_JPRB,4.7839E-04_JPRB,4.4173E-04_JPRB,3.9700E-04_JPRB,3.4683E-04_JPRB,&
&2.9289E-04_JPRB,2.3410E-04_JPRB,2.7363E-04_JPRB/)
KAO( :, 1, 3, 7) = (/&
&4.1666E-04_JPRB,3.7587E-04_JPRB,3.3124E-04_JPRB,2.8500E-04_JPRB,2.3719E-04_JPRB,1.8911E-04_JPRB,&
&1.3261E-04_JPRB,2.3452E-05_JPRB,4.9343E-05_JPRB/)
KAO( :, 2, 3, 7) = (/&
&4.2699E-04_JPRB,3.8906E-04_JPRB,3.4648E-04_JPRB,3.0084E-04_JPRB,2.5570E-04_JPRB,2.0628E-04_JPRB,&
&1.5092E-04_JPRB,2.8713E-05_JPRB,9.9198E-05_JPRB/)
KAO( :, 3, 3, 7) = (/&
&4.4021E-04_JPRB,4.0629E-04_JPRB,3.6539E-04_JPRB,3.2263E-04_JPRB,2.7685E-04_JPRB,2.2699E-04_JPRB,&
&1.7257E-04_JPRB,8.2898E-05_JPRB,1.4682E-04_JPRB/)
KAO( :, 4, 3, 7) = (/&
&4.5674E-04_JPRB,4.2778E-04_JPRB,3.8962E-04_JPRB,3.4911E-04_JPRB,3.0352E-04_JPRB,2.5381E-04_JPRB,&
&1.9998E-04_JPRB,1.3835E-04_JPRB,2.0520E-04_JPRB/)
KAO( :, 5, 3, 7) = (/&
&4.7776E-04_JPRB,4.5415E-04_JPRB,4.2101E-04_JPRB,3.8173E-04_JPRB,3.3698E-04_JPRB,2.8849E-04_JPRB,&
&2.3510E-04_JPRB,1.7936E-04_JPRB,2.7654E-04_JPRB/)
KAO( :, 1, 4, 7) = (/&
&4.0967E-04_JPRB,3.6653E-04_JPRB,3.2176E-04_JPRB,2.7479E-04_JPRB,2.2703E-04_JPRB,1.7902E-04_JPRB,&
&1.1570E-04_JPRB,2.0026E-05_JPRB,6.2716E-05_JPRB/)
KAO( :, 2, 4, 7) = (/&
&4.1728E-04_JPRB,3.7737E-04_JPRB,3.3344E-04_JPRB,2.8769E-04_JPRB,2.4076E-04_JPRB,1.9242E-04_JPRB,&
&1.3658E-04_JPRB,2.3923E-05_JPRB,1.0107E-04_JPRB/)
KAO( :, 3, 4, 7) = (/&
&4.2535E-04_JPRB,3.8928E-04_JPRB,3.4656E-04_JPRB,3.0255E-04_JPRB,2.5648E-04_JPRB,2.0706E-04_JPRB,&
&1.5237E-04_JPRB,3.0608E-05_JPRB,1.5048E-04_JPRB/)
KAO( :, 4, 4, 7) = (/&
&4.3671E-04_JPRB,4.0394E-04_JPRB,3.6448E-04_JPRB,3.2102E-04_JPRB,2.7530E-04_JPRB,2.2501E-04_JPRB,&
&1.7081E-04_JPRB,9.6060E-05_JPRB,2.1454E-04_JPRB/)
KAO( :, 5, 4, 7) = (/&
&4.4976E-04_JPRB,4.2181E-04_JPRB,3.8534E-04_JPRB,3.4353E-04_JPRB,2.9780E-04_JPRB,2.4759E-04_JPRB,&
&1.9471E-04_JPRB,1.3517E-04_JPRB,2.9601E-04_JPRB/)
KAO( :, 1, 5, 7) = (/&
&4.0808E-04_JPRB,3.6358E-04_JPRB,3.1756E-04_JPRB,2.7050E-04_JPRB,2.2238E-04_JPRB,1.7234E-04_JPRB,&
&5.9731E-05_JPRB,1.5183E-05_JPRB,6.3144E-05_JPRB/)
KAO( :, 2, 5, 7) = (/&
&4.1172E-04_JPRB,3.6950E-04_JPRB,3.2496E-04_JPRB,2.7819E-04_JPRB,2.3077E-04_JPRB,1.8213E-04_JPRB,&
&1.2446E-04_JPRB,2.0194E-05_JPRB,1.0232E-04_JPRB/)
KAO( :, 3, 5, 7) = (/&
&4.1699E-04_JPRB,3.7855E-04_JPRB,3.3456E-04_JPRB,2.8999E-04_JPRB,2.4284E-04_JPRB,1.9427E-04_JPRB,&
&1.3989E-04_JPRB,2.2013E-05_JPRB,1.5619E-04_JPRB/)
KAO( :, 4, 5, 7) = (/&
&4.2318E-04_JPRB,3.8831E-04_JPRB,3.4637E-04_JPRB,3.0279E-04_JPRB,2.5707E-04_JPRB,2.0772E-04_JPRB,&
&1.5350E-04_JPRB,3.7923E-05_JPRB,2.2888E-04_JPRB/)
KAO( :, 5, 5, 7) = (/&
&4.3181E-04_JPRB,3.9999E-04_JPRB,3.6216E-04_JPRB,3.1916E-04_JPRB,2.7412E-04_JPRB,2.2354E-04_JPRB,&
&1.6943E-04_JPRB,1.0257E-04_JPRB,3.2402E-04_JPRB/)
KAO( :, 1, 6, 7) = (/&
&4.0917E-04_JPRB,3.6282E-04_JPRB,3.1586E-04_JPRB,2.6754E-04_JPRB,2.1851E-04_JPRB,1.6735E-04_JPRB,&
&5.0306E-05_JPRB,1.4647E-05_JPRB,5.9838E-05_JPRB/)
KAO( :, 2, 6, 7) = (/&
&4.0728E-04_JPRB,3.6393E-04_JPRB,3.1828E-04_JPRB,2.7141E-04_JPRB,2.2388E-04_JPRB,1.7484E-04_JPRB,&
&6.6257E-05_JPRB,1.8734E-05_JPRB,1.0066E-04_JPRB/)
KAO( :, 3, 6, 7) = (/&
&4.1093E-04_JPRB,3.6989E-04_JPRB,3.2582E-04_JPRB,2.7999E-04_JPRB,2.3310E-04_JPRB,1.8335E-04_JPRB,&
&1.2803E-04_JPRB,1.9091E-05_JPRB,1.6014E-04_JPRB/)
KAO( :, 4, 6, 7) = (/&
&4.1435E-04_JPRB,3.7775E-04_JPRB,3.3462E-04_JPRB,2.9056E-04_JPRB,2.4377E-04_JPRB,1.9519E-04_JPRB,&
&1.4167E-04_JPRB,2.4651E-05_JPRB,2.4320E-04_JPRB/)
KAO( :, 5, 6, 7) = (/&
&4.1880E-04_JPRB,3.8572E-04_JPRB,3.4541E-04_JPRB,3.0219E-04_JPRB,2.5684E-04_JPRB,2.0763E-04_JPRB,&
&1.5383E-04_JPRB,5.0012E-05_JPRB,3.5512E-04_JPRB/)
KAO( :, 1, 7, 7) = (/&
&4.0843E-04_JPRB,3.6062E-04_JPRB,3.1311E-04_JPRB,2.6422E-04_JPRB,2.1469E-04_JPRB,1.5788E-04_JPRB,&
&4.4260E-05_JPRB,1.0477E-05_JPRB,5.9419E-05_JPRB/)
KAO( :, 2, 7, 7) = (/&
&4.0468E-04_JPRB,3.5984E-04_JPRB,3.1329E-04_JPRB,2.6596E-04_JPRB,2.1769E-04_JPRB,1.6781E-04_JPRB,&
&5.1786E-05_JPRB,1.4646E-05_JPRB,1.0524E-04_JPRB/)
KAO( :, 3, 7, 7) = (/&
&4.0363E-04_JPRB,3.6136E-04_JPRB,3.1683E-04_JPRB,2.7075E-04_JPRB,2.2418E-04_JPRB,1.7495E-04_JPRB,&
&8.7540E-05_JPRB,1.8041E-05_JPRB,1.7514E-04_JPRB/)
KAO( :, 4, 7, 7) = (/&
&4.0645E-04_JPRB,3.6771E-04_JPRB,3.2468E-04_JPRB,2.8007E-04_JPRB,2.3381E-04_JPRB,1.8431E-04_JPRB,&
&1.2997E-04_JPRB,1.8283E-05_JPRB,2.7663E-04_JPRB/)
KAO( :, 5, 7, 7) = (/&
&4.0882E-04_JPRB,3.7446E-04_JPRB,3.3339E-04_JPRB,2.9009E-04_JPRB,2.4386E-04_JPRB,1.9554E-04_JPRB,&
&1.4307E-04_JPRB,2.6104E-05_JPRB,4.1561E-04_JPRB/)
KAO( :, 1, 8, 7) = (/&
&4.0424E-04_JPRB,3.5590E-04_JPRB,3.0795E-04_JPRB,2.5922E-04_JPRB,2.0908E-04_JPRB,7.0272E-05_JPRB,&
&3.7437E-05_JPRB,1.0693E-05_JPRB,7.0148E-05_JPRB/)
KAO( :, 2, 8, 7) = (/&
&3.9936E-04_JPRB,3.5369E-04_JPRB,3.0725E-04_JPRB,2.5982E-04_JPRB,2.1133E-04_JPRB,1.5687E-04_JPRB,&
&4.6834E-05_JPRB,1.4067E-05_JPRB,1.3163E-04_JPRB/)
KAO( :, 3, 8, 7) = (/&
&3.9575E-04_JPRB,3.5313E-04_JPRB,3.0818E-04_JPRB,2.6229E-04_JPRB,2.1562E-04_JPRB,1.6577E-04_JPRB,&
&5.0426E-05_JPRB,1.5328E-05_JPRB,2.2983E-04_JPRB/)
KAO( :, 4, 8, 7) = (/&
&3.9577E-04_JPRB,3.5593E-04_JPRB,3.1259E-04_JPRB,2.6838E-04_JPRB,2.2238E-04_JPRB,1.7380E-04_JPRB,&
&9.5405E-05_JPRB,1.7738E-05_JPRB,3.7526E-04_JPRB/)
KAO( :, 5, 8, 7) = (/&
&3.9853E-04_JPRB,3.6216E-04_JPRB,3.2118E-04_JPRB,2.7729E-04_JPRB,2.3198E-04_JPRB,1.8391E-04_JPRB,&
&1.3140E-04_JPRB,2.3100E-05_JPRB,5.7971E-04_JPRB/)
KAO( :, 1, 9, 7) = (/&
&3.9550E-04_JPRB,3.4756E-04_JPRB,2.9976E-04_JPRB,2.5157E-04_JPRB,2.0053E-04_JPRB,6.3971E-05_JPRB,&
&3.0992E-05_JPRB,8.5618E-06_JPRB,1.5177E-04_JPRB/)
KAO( :, 2, 9, 7) = (/&
&3.9108E-04_JPRB,3.4522E-04_JPRB,2.9936E-04_JPRB,2.5239E-04_JPRB,2.0355E-04_JPRB,7.9459E-05_JPRB,&
&4.6168E-05_JPRB,1.0069E-05_JPRB,3.0222E-04_JPRB/)
KAO( :, 3, 9, 7) = (/&
&3.8711E-04_JPRB,3.4432E-04_JPRB,2.9976E-04_JPRB,2.5434E-04_JPRB,2.0775E-04_JPRB,1.5531E-04_JPRB,&
&4.6577E-05_JPRB,1.4628E-05_JPRB,5.5112E-04_JPRB/)
KAO( :, 4, 9, 7) = (/&
&3.8454E-04_JPRB,3.4471E-04_JPRB,3.0182E-04_JPRB,2.5833E-04_JPRB,2.1289E-04_JPRB,1.6399E-04_JPRB,&
&4.7735E-05_JPRB,1.8317E-05_JPRB,9.3434E-04_JPRB/)
KAO( :, 5, 9, 7) = (/&
&3.8590E-04_JPRB,3.4906E-04_JPRB,3.0820E-04_JPRB,2.6500E-04_JPRB,2.1985E-04_JPRB,1.7262E-04_JPRB,&
&1.0739E-04_JPRB,2.0046E-05_JPRB,1.4932E-03_JPRB/)
KAO( :, 1,10, 7) = (/&
&3.8145E-04_JPRB,3.3484E-04_JPRB,2.8824E-04_JPRB,2.4073E-04_JPRB,1.3749E-04_JPRB,6.8864E-05_JPRB,&
&1.3426E-05_JPRB,5.4253E-06_JPRB,4.2208E-04_JPRB/)
KAO( :, 2,10, 7) = (/&
&3.7808E-04_JPRB,3.3310E-04_JPRB,2.8836E-04_JPRB,2.4244E-04_JPRB,1.9222E-04_JPRB,5.4332E-05_JPRB,&
&3.8318E-05_JPRB,1.3544E-05_JPRB,8.8420E-04_JPRB/)
KAO( :, 3,10, 7) = (/&
&3.7522E-04_JPRB,3.3290E-04_JPRB,2.8933E-04_JPRB,2.4468E-04_JPRB,1.9821E-04_JPRB,8.2625E-05_JPRB,&
&4.6026E-05_JPRB,1.3859E-05_JPRB,1.6822E-03_JPRB/)
KAO( :, 4,10, 7) = (/&
&3.7308E-04_JPRB,3.3362E-04_JPRB,2.9154E-04_JPRB,2.4864E-04_JPRB,2.0415E-04_JPRB,1.5269E-04_JPRB,&
&4.6983E-05_JPRB,1.4205E-05_JPRB,2.9547E-03_JPRB/)
KAO( :, 5,10, 7) = (/&
&3.7174E-04_JPRB,3.3554E-04_JPRB,2.9552E-04_JPRB,2.5392E-04_JPRB,2.0969E-04_JPRB,1.6270E-04_JPRB,&
&4.1673E-05_JPRB,1.7828E-05_JPRB,4.8607E-03_JPRB/)
KAO( :, 1,11, 7) = (/&
&3.6294E-04_JPRB,3.1871E-04_JPRB,2.7451E-04_JPRB,2.2858E-04_JPRB,8.3578E-05_JPRB,6.1372E-05_JPRB,&
&1.3364E-05_JPRB,7.7912E-06_JPRB,6.2992E-04_JPRB/)
KAO( :, 2,11, 7) = (/&
&3.6112E-04_JPRB,3.1852E-04_JPRB,2.7580E-04_JPRB,2.3178E-04_JPRB,1.8037E-04_JPRB,5.7295E-05_JPRB,&
&4.0682E-05_JPRB,1.2520E-05_JPRB,1.3182E-03_JPRB/)
KAO( :, 3,11, 7) = (/&
&3.5947E-04_JPRB,3.1941E-04_JPRB,2.7779E-04_JPRB,2.3507E-04_JPRB,1.9020E-04_JPRB,4.7650E-05_JPRB,&
&4.7645E-05_JPRB,1.4087E-05_JPRB,2.5064E-03_JPRB/)
KAO( :, 4,11, 7) = (/&
&3.5796E-04_JPRB,3.2062E-04_JPRB,2.8056E-04_JPRB,2.3967E-04_JPRB,1.9644E-04_JPRB,1.3235E-04_JPRB,&
&4.6296E-05_JPRB,1.5164E-05_JPRB,4.4025E-03_JPRB/)
KAO( :, 5,11, 7) = (/&
&3.5673E-04_JPRB,3.2259E-04_JPRB,2.8479E-04_JPRB,2.4474E-04_JPRB,2.0200E-04_JPRB,1.5578E-04_JPRB,&
&4.2752E-05_JPRB,1.8894E-05_JPRB,7.2340E-03_JPRB/)
KAO( :, 1,12, 7) = (/&
&3.4280E-04_JPRB,3.0118E-04_JPRB,2.5967E-04_JPRB,2.1631E-04_JPRB,7.2200E-05_JPRB,5.9727E-05_JPRB,&
&3.2869E-05_JPRB,5.5658E-06_JPRB,7.0164E-04_JPRB/)
KAO( :, 2,12, 7) = (/&
&3.4212E-04_JPRB,3.0217E-04_JPRB,2.6182E-04_JPRB,2.2007E-04_JPRB,1.6435E-04_JPRB,5.4340E-05_JPRB,&
&4.2800E-05_JPRB,1.1130E-05_JPRB,1.4668E-03_JPRB/)
KAO( :, 3,12, 7) = (/&
&3.4134E-04_JPRB,3.0369E-04_JPRB,2.6435E-04_JPRB,2.2391E-04_JPRB,1.8076E-04_JPRB,4.4282E-05_JPRB,&
&4.6617E-05_JPRB,1.2881E-05_JPRB,2.7876E-03_JPRB/)
KAO( :, 4,12, 7) = (/&
&3.4044E-04_JPRB,3.0540E-04_JPRB,2.6773E-04_JPRB,2.2890E-04_JPRB,1.8713E-04_JPRB,1.1838E-04_JPRB,&
&4.1381E-05_JPRB,1.3556E-05_JPRB,4.8923E-03_JPRB/)
KAO( :, 5,12, 7) = (/&
&3.3969E-04_JPRB,3.0785E-04_JPRB,2.7216E-04_JPRB,2.3387E-04_JPRB,1.9308E-04_JPRB,1.4819E-04_JPRB,&
&3.8774E-05_JPRB,2.3365E-05_JPRB,8.0367E-03_JPRB/)
KAO( :, 1,13, 7) = (/&
&3.2074E-04_JPRB,2.8200E-04_JPRB,2.4335E-04_JPRB,2.0260E-04_JPRB,5.9755E-05_JPRB,5.5012E-05_JPRB,&
&4.0916E-05_JPRB,6.5979E-06_JPRB,6.2734E-04_JPRB/)
KAO( :, 2,13, 7) = (/&
&3.2081E-04_JPRB,2.8371E-04_JPRB,2.4601E-04_JPRB,2.0672E-04_JPRB,1.4264E-04_JPRB,4.7131E-05_JPRB,&
&4.6167E-05_JPRB,1.0279E-05_JPRB,1.3098E-03_JPRB/)
KAO( :, 3,13, 7) = (/&
&3.2050E-04_JPRB,2.8547E-04_JPRB,2.4888E-04_JPRB,2.1104E-04_JPRB,1.6957E-04_JPRB,3.8720E-05_JPRB,&
&4.6164E-05_JPRB,1.0646E-05_JPRB,2.4868E-03_JPRB/)
KAO( :, 4,13, 7) = (/&
&3.2004E-04_JPRB,2.8761E-04_JPRB,2.5261E-04_JPRB,2.1602E-04_JPRB,1.7644E-04_JPRB,1.0425E-04_JPRB,&
&3.7809E-05_JPRB,1.7867E-05_JPRB,4.3609E-03_JPRB/)
KAO( :, 5,13, 7) = (/&
&3.1955E-04_JPRB,2.9043E-04_JPRB,2.5703E-04_JPRB,2.2081E-04_JPRB,1.8253E-04_JPRB,1.3988E-04_JPRB,&
&3.6793E-05_JPRB,3.0837E-05_JPRB,7.1735E-03_JPRB/)
KAO( :, 1, 1, 8) = (/&
&5.6685E-04_JPRB,5.1953E-04_JPRB,4.6936E-04_JPRB,4.1592E-04_JPRB,3.5781E-04_JPRB,2.9881E-04_JPRB,&
&2.3721E-04_JPRB,1.2965E-04_JPRB,9.7553E-05_JPRB/)
KAO( :, 2, 1, 8) = (/&
&6.1498E-04_JPRB,5.7331E-04_JPRB,5.2736E-04_JPRB,4.7456E-04_JPRB,4.1825E-04_JPRB,3.6336E-04_JPRB,&
&3.0181E-04_JPRB,2.4017E-04_JPRB,2.2948E-04_JPRB/)
KAO( :, 3, 1, 8) = (/&
&6.7611E-04_JPRB,6.4061E-04_JPRB,6.0111E-04_JPRB,5.5388E-04_JPRB,5.0779E-04_JPRB,4.5514E-04_JPRB,&
&3.9223E-04_JPRB,3.3256E-04_JPRB,3.4276E-04_JPRB/)
KAO( :, 4, 1, 8) = (/&
&7.5480E-04_JPRB,7.2914E-04_JPRB,7.0254E-04_JPRB,6.6835E-04_JPRB,6.2923E-04_JPRB,5.7675E-04_JPRB,&
&5.0673E-04_JPRB,4.4275E-04_JPRB,4.7133E-04_JPRB/)
KAO( :, 5, 1, 8) = (/&
&8.5668E-04_JPRB,8.5031E-04_JPRB,8.3845E-04_JPRB,8.1883E-04_JPRB,7.8346E-04_JPRB,7.2655E-04_JPRB,&
&6.4693E-04_JPRB,5.7765E-04_JPRB,6.2516E-04_JPRB/)
KAO( :, 1, 2, 8) = (/&
&5.4710E-04_JPRB,4.9662E-04_JPRB,4.4514E-04_JPRB,3.9135E-04_JPRB,3.3202E-04_JPRB,2.7342E-04_JPRB,&
&2.1062E-04_JPRB,7.4193E-05_JPRB,1.1449E-04_JPRB/)
KAO( :, 2, 2, 8) = (/&
&5.7920E-04_JPRB,5.3530E-04_JPRB,4.8866E-04_JPRB,4.3544E-04_JPRB,3.7966E-04_JPRB,3.2266E-04_JPRB,&
&2.6099E-04_JPRB,1.8962E-04_JPRB,2.1819E-04_JPRB/)
KAO( :, 3, 2, 8) = (/&
&6.1998E-04_JPRB,5.8558E-04_JPRB,5.4532E-04_JPRB,4.9598E-04_JPRB,4.4601E-04_JPRB,3.9266E-04_JPRB,&
&3.3270E-04_JPRB,2.7330E-04_JPRB,3.1544E-04_JPRB/)
KAO( :, 4, 2, 8) = (/&
&6.7522E-04_JPRB,6.5257E-04_JPRB,6.1970E-04_JPRB,5.8199E-04_JPRB,5.3956E-04_JPRB,4.8955E-04_JPRB,&
&4.2848E-04_JPRB,3.6701E-04_JPRB,4.3346E-04_JPRB/)
KAO( :, 5, 2, 8) = (/&
&7.4593E-04_JPRB,7.3758E-04_JPRB,7.2139E-04_JPRB,6.9843E-04_JPRB,6.6276E-04_JPRB,6.1561E-04_JPRB,&
&5.4954E-04_JPRB,4.8184E-04_JPRB,5.7913E-04_JPRB/)
KAO( :, 1, 3, 8) = (/&
&5.3214E-04_JPRB,4.7681E-04_JPRB,4.2344E-04_JPRB,3.6680E-04_JPRB,3.0810E-04_JPRB,2.4726E-04_JPRB,&
&1.8453E-04_JPRB,2.5084E-05_JPRB,1.5128E-04_JPRB/)
KAO( :, 2, 3, 8) = (/&
&5.5191E-04_JPRB,5.0347E-04_JPRB,4.5239E-04_JPRB,3.9784E-04_JPRB,3.4016E-04_JPRB,2.8162E-04_JPRB,&
&2.1920E-04_JPRB,1.0464E-04_JPRB,2.3348E-04_JPRB/)
KAO( :, 3, 3, 8) = (/&
&5.7477E-04_JPRB,5.3435E-04_JPRB,4.8907E-04_JPRB,4.3911E-04_JPRB,3.8574E-04_JPRB,3.2874E-04_JPRB,&
&2.6890E-04_JPRB,2.0489E-04_JPRB,3.3684E-04_JPRB/)
KAO( :, 4, 3, 8) = (/&
&6.0596E-04_JPRB,5.7781E-04_JPRB,5.4062E-04_JPRB,4.9604E-04_JPRB,4.4703E-04_JPRB,3.9517E-04_JPRB,&
&3.3938E-04_JPRB,2.8379E-04_JPRB,4.6834E-04_JPRB/)
KAO( :, 5, 3, 8) = (/&
&6.4785E-04_JPRB,6.3446E-04_JPRB,6.0817E-04_JPRB,5.7312E-04_JPRB,5.3235E-04_JPRB,4.8682E-04_JPRB,&
&4.3334E-04_JPRB,3.7597E-04_JPRB,6.3257E-04_JPRB/)
KAO( :, 1, 4, 8) = (/&
&5.3110E-04_JPRB,4.7262E-04_JPRB,4.1623E-04_JPRB,3.5723E-04_JPRB,2.9627E-04_JPRB,2.3321E-04_JPRB,&
&1.6340E-04_JPRB,1.9895E-05_JPRB,1.6136E-04_JPRB/)
KAO( :, 2, 4, 8) = (/&
&5.4153E-04_JPRB,4.8798E-04_JPRB,4.3377E-04_JPRB,3.7487E-04_JPRB,3.1581E-04_JPRB,2.5480E-04_JPRB,&
&1.9036E-04_JPRB,3.4588E-05_JPRB,2.5102E-04_JPRB/)
KAO( :, 3, 4, 8) = (/&
&5.5497E-04_JPRB,5.0890E-04_JPRB,4.5760E-04_JPRB,4.0292E-04_JPRB,3.4647E-04_JPRB,2.8693E-04_JPRB,&
&2.2354E-04_JPRB,1.2964E-04_JPRB,3.6989E-04_JPRB/)
KAO( :, 4, 4, 8) = (/&
&5.7139E-04_JPRB,5.3494E-04_JPRB,4.8805E-04_JPRB,4.4096E-04_JPRB,3.8626E-04_JPRB,3.3033E-04_JPRB,&
&2.7143E-04_JPRB,2.1212E-04_JPRB,5.2455E-04_JPRB/)
KAO( :, 5, 4, 8) = (/&
&5.9415E-04_JPRB,5.6860E-04_JPRB,5.3306E-04_JPRB,4.9025E-04_JPRB,4.4085E-04_JPRB,3.9152E-04_JPRB,&
&3.3850E-04_JPRB,2.8746E-04_JPRB,7.1892E-04_JPRB/)
KAO( :, 1, 5, 8) = (/&
&5.4290E-04_JPRB,4.8021E-04_JPRB,4.2005E-04_JPRB,3.5773E-04_JPRB,2.9361E-04_JPRB,2.2840E-04_JPRB,&
&1.2412E-04_JPRB,1.6779E-05_JPRB,1.6478E-04_JPRB/)
KAO( :, 2, 5, 8) = (/&
&5.4234E-04_JPRB,4.8521E-04_JPRB,4.2730E-04_JPRB,3.6655E-04_JPRB,3.0462E-04_JPRB,2.4081E-04_JPRB,&
&1.7158E-04_JPRB,2.4577E-05_JPRB,2.6430E-04_JPRB/)
KAO( :, 3, 5, 8) = (/&
&5.5176E-04_JPRB,4.9971E-04_JPRB,4.4439E-04_JPRB,3.8473E-04_JPRB,3.2493E-04_JPRB,2.6199E-04_JPRB,&
&1.9530E-04_JPRB,5.1968E-05_JPRB,4.0107E-04_JPRB/)
KAO( :, 4, 5, 8) = (/&
&5.6082E-04_JPRB,5.1698E-04_JPRB,4.6451E-04_JPRB,4.1055E-04_JPRB,3.5125E-04_JPRB,2.9127E-04_JPRB,&
&2.2746E-04_JPRB,1.4698E-04_JPRB,5.8315E-04_JPRB/)
KAO( :, 5, 5, 8) = (/&
&5.7193E-04_JPRB,5.3856E-04_JPRB,4.9143E-04_JPRB,4.4154E-04_JPRB,3.8661E-04_JPRB,3.3087E-04_JPRB,&
&2.7242E-04_JPRB,2.1704E-04_JPRB,8.1664E-04_JPRB/)
KAO( :, 1, 6, 8) = (/&
&5.5933E-04_JPRB,4.9291E-04_JPRB,4.2842E-04_JPRB,3.6305E-04_JPRB,2.9613E-04_JPRB,2.2724E-04_JPRB,&
&5.3023E-05_JPRB,1.5921E-05_JPRB,1.6080E-04_JPRB/)
KAO( :, 2, 6, 8) = (/&
&5.5265E-04_JPRB,4.9132E-04_JPRB,4.3026E-04_JPRB,3.6705E-04_JPRB,3.0202E-04_JPRB,2.3616E-04_JPRB,&
&1.5492E-04_JPRB,1.7381E-05_JPRB,2.6878E-04_JPRB/)
KAO( :, 3, 6, 8) = (/&
&5.5383E-04_JPRB,4.9775E-04_JPRB,4.3880E-04_JPRB,3.7661E-04_JPRB,3.1407E-04_JPRB,2.4921E-04_JPRB,&
&1.7746E-04_JPRB,2.2302E-05_JPRB,4.2225E-04_JPRB/)
KAO( :, 4, 6, 8) = (/&
&5.6178E-04_JPRB,5.1138E-04_JPRB,4.5491E-04_JPRB,3.9556E-04_JPRB,3.3327E-04_JPRB,2.6812E-04_JPRB,&
&2.0001E-04_JPRB,6.4403E-05_JPRB,6.3155E-04_JPRB/)
KAO( :, 5, 6, 8) = (/&
&5.6806E-04_JPRB,5.2664E-04_JPRB,4.7387E-04_JPRB,4.1708E-04_JPRB,3.5623E-04_JPRB,2.9443E-04_JPRB,&
&2.3016E-04_JPRB,1.5609E-04_JPRB,9.0635E-04_JPRB/)
KAO( :, 1, 7, 8) = (/&
&5.7912E-04_JPRB,5.0929E-04_JPRB,4.4052E-04_JPRB,3.7179E-04_JPRB,3.0169E-04_JPRB,2.2904E-04_JPRB,&
&3.6739E-05_JPRB,9.8065E-06_JPRB,1.6369E-04_JPRB/)
KAO( :, 2, 7, 8) = (/&
&5.7054E-04_JPRB,5.0526E-04_JPRB,4.4059E-04_JPRB,3.7406E-04_JPRB,3.0610E-04_JPRB,2.3585E-04_JPRB,&
&6.5393E-05_JPRB,1.3372E-05_JPRB,2.8615E-04_JPRB/)
KAO( :, 3, 7, 8) = (/&
&5.6399E-04_JPRB,5.0435E-04_JPRB,4.4269E-04_JPRB,3.7826E-04_JPRB,3.1294E-04_JPRB,2.4573E-04_JPRB,&
&1.6693E-04_JPRB,2.0015E-05_JPRB,4.6772E-04_JPRB/)
KAO( :, 4, 7, 8) = (/&
&5.6580E-04_JPRB,5.1086E-04_JPRB,4.5119E-04_JPRB,3.8935E-04_JPRB,3.2489E-04_JPRB,2.5799E-04_JPRB,&
&1.8517E-04_JPRB,2.1193E-05_JPRB,7.2326E-04_JPRB/)
KAO( :, 5, 7, 8) = (/&
&5.7198E-04_JPRB,5.2353E-04_JPRB,4.6732E-04_JPRB,4.0650E-04_JPRB,3.4261E-04_JPRB,2.7564E-04_JPRB,&
&2.0638E-04_JPRB,8.3698E-05_JPRB,1.0705E-03_JPRB/)
KAO( :, 1, 8, 8) = (/&
&5.9871E-04_JPRB,5.2574E-04_JPRB,4.5363E-04_JPRB,3.8151E-04_JPRB,3.0818E-04_JPRB,2.2816E-04_JPRB,&
&3.1690E-05_JPRB,9.1563E-06_JPRB,1.9592E-04_JPRB/)
KAO( :, 2, 8, 8) = (/&
&5.8942E-04_JPRB,5.2019E-04_JPRB,4.5182E-04_JPRB,3.8232E-04_JPRB,3.1150E-04_JPRB,2.3688E-04_JPRB,&
&4.4878E-05_JPRB,1.3062E-05_JPRB,3.5981E-04_JPRB/)
KAO( :, 3, 8, 8) = (/&
&5.8144E-04_JPRB,5.1705E-04_JPRB,4.5231E-04_JPRB,3.8496E-04_JPRB,3.1600E-04_JPRB,2.4571E-04_JPRB,&
&1.0309E-04_JPRB,1.4129E-05_JPRB,6.1385E-04_JPRB/)
KAO( :, 4, 8, 8) = (/&
&5.7448E-04_JPRB,5.1610E-04_JPRB,4.5471E-04_JPRB,3.9018E-04_JPRB,3.2457E-04_JPRB,2.5556E-04_JPRB,&
&1.7544E-04_JPRB,1.7304E-05_JPRB,9.8945E-04_JPRB/)
KAO( :, 5, 8, 8) = (/&
&5.7483E-04_JPRB,5.2262E-04_JPRB,4.6340E-04_JPRB,4.0220E-04_JPRB,3.3597E-04_JPRB,2.6696E-04_JPRB,&
&1.9367E-04_JPRB,2.4514E-05_JPRB,1.5199E-03_JPRB/)
KAO( :, 1, 9, 8) = (/&
&6.1652E-04_JPRB,5.4081E-04_JPRB,4.6545E-04_JPRB,3.9056E-04_JPRB,3.1379E-04_JPRB,9.9114E-05_JPRB,&
&1.3949E-05_JPRB,3.9239E-06_JPRB,4.2520E-04_JPRB/)
KAO( :, 2, 9, 8) = (/&
&6.0629E-04_JPRB,5.3376E-04_JPRB,4.6202E-04_JPRB,3.8990E-04_JPRB,3.1655E-04_JPRB,2.3544E-04_JPRB,&
&3.7382E-05_JPRB,8.6951E-06_JPRB,8.3044E-04_JPRB/)
KAO( :, 3, 9, 8) = (/&
&5.9694E-04_JPRB,5.2858E-04_JPRB,4.6094E-04_JPRB,3.9128E-04_JPRB,3.1984E-04_JPRB,2.4585E-04_JPRB,&
&4.7453E-05_JPRB,1.1219E-05_JPRB,1.4978E-03_JPRB/)
KAO( :, 4, 9, 8) = (/&
&5.8812E-04_JPRB,5.2540E-04_JPRB,4.6162E-04_JPRB,3.9424E-04_JPRB,3.2635E-04_JPRB,2.5585E-04_JPRB,&
&1.3793E-04_JPRB,1.5823E-05_JPRB,2.5315E-03_JPRB/)
KAO( :, 5, 9, 8) = (/&
&5.8094E-04_JPRB,5.2489E-04_JPRB,4.6409E-04_JPRB,4.0156E-04_JPRB,3.3516E-04_JPRB,2.6461E-04_JPRB,&
&1.8608E-04_JPRB,1.9887E-05_JPRB,4.0512E-03_JPRB/)
KAO( :, 1,10, 8) = (/&
&6.2969E-04_JPRB,5.5181E-04_JPRB,4.7454E-04_JPRB,3.9703E-04_JPRB,3.1724E-04_JPRB,6.5127E-05_JPRB,&
&3.7452E-06_JPRB,3.2741E-06_JPRB,1.1769E-03_JPRB/)
KAO( :, 2,10, 8) = (/&
&6.1957E-04_JPRB,5.4459E-04_JPRB,4.7029E-04_JPRB,3.9585E-04_JPRB,3.1968E-04_JPRB,1.3041E-04_JPRB,&
&2.4515E-05_JPRB,7.2975E-06_JPRB,2.4417E-03_JPRB/)
KAO( :, 3,10, 8) = (/&
&6.0939E-04_JPRB,5.3813E-04_JPRB,4.6769E-04_JPRB,3.9651E-04_JPRB,3.2305E-04_JPRB,2.4182E-04_JPRB,&
&4.3807E-05_JPRB,1.1783E-05_JPRB,4.6287E-03_JPRB/)
KAO( :, 4,10, 8) = (/&
&5.9955E-04_JPRB,5.3329E-04_JPRB,4.6744E-04_JPRB,3.9835E-04_JPRB,3.2790E-04_JPRB,2.5437E-04_JPRB,&
&4.6423E-05_JPRB,1.1970E-05_JPRB,8.1527E-03_JPRB/)
KAO( :, 5,10, 8) = (/&
&5.9051E-04_JPRB,5.3069E-04_JPRB,4.6841E-04_JPRB,4.0335E-04_JPRB,3.3599E-04_JPRB,2.6411E-04_JPRB,&
&1.6905E-04_JPRB,1.8347E-05_JPRB,1.3511E-02_JPRB/)
KAO( :, 1,11, 8) = (/&
&6.3270E-04_JPRB,5.5469E-04_JPRB,4.7693E-04_JPRB,3.9917E-04_JPRB,3.1669E-04_JPRB,6.3388E-05_JPRB,&
&3.6721E-06_JPRB,3.2147E-07_JPRB,1.7207E-03_JPRB/)
KAO( :, 2,11, 8) = (/&
&6.2323E-04_JPRB,5.4792E-04_JPRB,4.7320E-04_JPRB,3.9836E-04_JPRB,3.2132E-04_JPRB,8.3669E-05_JPRB,&
&2.5421E-05_JPRB,6.2024E-06_JPRB,3.6065E-03_JPRB/)
KAO( :, 3,11, 8) = (/&
&6.1343E-04_JPRB,5.4174E-04_JPRB,4.7120E-04_JPRB,3.9965E-04_JPRB,3.2524E-04_JPRB,2.3807E-04_JPRB,&
&4.5288E-05_JPRB,1.1010E-05_JPRB,6.9077E-03_JPRB/)
KAO( :, 4,11, 8) = (/&
&6.0422E-04_JPRB,5.3760E-04_JPRB,4.7151E-04_JPRB,4.0215E-04_JPRB,3.3145E-04_JPRB,2.5596E-04_JPRB,&
&4.6438E-05_JPRB,1.1046E-05_JPRB,1.2276E-02_JPRB/)
KAO( :, 5,11, 8) = (/&
&5.9513E-04_JPRB,5.3553E-04_JPRB,4.7292E-04_JPRB,4.0786E-04_JPRB,3.3977E-04_JPRB,2.6645E-04_JPRB,&
&1.3530E-04_JPRB,1.8396E-05_JPRB,2.0378E-02_JPRB/)
KAO( :, 1,12, 8) = (/&
&6.3015E-04_JPRB,5.5264E-04_JPRB,4.7514E-04_JPRB,3.9757E-04_JPRB,3.1556E-04_JPRB,6.0378E-05_JPRB,&
&5.1686E-06_JPRB,4.1217E-06_JPRB,1.9089E-03_JPRB/)
KAO( :, 2,12, 8) = (/&
&6.2156E-04_JPRB,5.4661E-04_JPRB,4.7228E-04_JPRB,3.9794E-04_JPRB,3.2115E-04_JPRB,9.3459E-05_JPRB,&
&3.5910E-05_JPRB,6.9491E-06_JPRB,4.0407E-03_JPRB/)
KAO( :, 3,12, 8) = (/&
&6.1284E-04_JPRB,5.4153E-04_JPRB,4.7137E-04_JPRB,3.9993E-04_JPRB,3.2562E-04_JPRB,2.3942E-04_JPRB,&
&4.5459E-05_JPRB,1.2207E-05_JPRB,7.7972E-03_JPRB/)
KAO( :, 4,12, 8) = (/&
&6.0431E-04_JPRB,5.3827E-04_JPRB,4.7217E-04_JPRB,4.0315E-04_JPRB,3.3297E-04_JPRB,2.5722E-04_JPRB,&
&4.4991E-05_JPRB,1.1842E-05_JPRB,1.3838E-02_JPRB/)
KAO( :, 5,12, 8) = (/&
&5.9614E-04_JPRB,5.3719E-04_JPRB,4.7459E-04_JPRB,4.0965E-04_JPRB,3.4109E-04_JPRB,2.6763E-04_JPRB,&
&1.4327E-04_JPRB,1.6122E-05_JPRB,2.2897E-02_JPRB/)
KAO( :, 1,13, 8) = (/&
&6.2067E-04_JPRB,5.4442E-04_JPRB,4.6829E-04_JPRB,3.9206E-04_JPRB,3.1059E-04_JPRB,5.4570E-05_JPRB,&
&2.5324E-05_JPRB,1.9027E-06_JPRB,1.7246E-03_JPRB/)
KAO( :, 2,13, 8) = (/&
&6.1333E-04_JPRB,5.3966E-04_JPRB,4.6657E-04_JPRB,3.9353E-04_JPRB,3.1741E-04_JPRB,1.0184E-04_JPRB,&
&4.1822E-05_JPRB,6.3468E-06_JPRB,3.6765E-03_JPRB/)
KAO( :, 3,13, 8) = (/&
&6.0610E-04_JPRB,5.3617E-04_JPRB,4.6704E-04_JPRB,3.9622E-04_JPRB,3.2317E-04_JPRB,2.3665E-04_JPRB,&
&4.5927E-05_JPRB,1.1176E-05_JPRB,7.0786E-03_JPRB/)
KAO( :, 4,13, 8) = (/&
&5.9902E-04_JPRB,5.3443E-04_JPRB,4.6878E-04_JPRB,4.0069E-04_JPRB,3.3118E-04_JPRB,2.5588E-04_JPRB,&
&4.4674E-05_JPRB,1.1239E-05_JPRB,1.2524E-02_JPRB/)
KAO( :, 5,13, 8) = (/&
&5.9234E-04_JPRB,5.3454E-04_JPRB,4.7242E-04_JPRB,4.0791E-04_JPRB,3.3951E-04_JPRB,2.6646E-04_JPRB,&
&1.4670E-04_JPRB,2.0921E-05_JPRB,2.0681E-02_JPRB/)
KAO( :, 1, 1, 9) = (/&
&7.6730E-04_JPRB,6.9533E-04_JPRB,6.3435E-04_JPRB,5.7755E-04_JPRB,5.2747E-04_JPRB,4.8127E-04_JPRB,&
&4.6360E-04_JPRB,4.7153E-04_JPRB,5.0503E-04_JPRB/)
KAO( :, 2, 1, 9) = (/&
&8.9446E-04_JPRB,8.3145E-04_JPRB,7.7791E-04_JPRB,7.3079E-04_JPRB,6.8158E-04_JPRB,6.4054E-04_JPRB,&
&6.4060E-04_JPRB,6.7751E-04_JPRB,7.4127E-04_JPRB/)
KAO( :, 3, 1, 9) = (/&
&1.0839E-03_JPRB,1.0326E-03_JPRB,9.8910E-04_JPRB,9.4874E-04_JPRB,8.8995E-04_JPRB,8.5059E-04_JPRB,&
&8.6660E-04_JPRB,9.3858E-04_JPRB,1.0404E-03_JPRB/)
KAO( :, 4, 1, 9) = (/&
&1.3392E-03_JPRB,1.2976E-03_JPRB,1.2617E-03_JPRB,1.2187E-03_JPRB,1.1503E-03_JPRB,1.1142E-03_JPRB,&
&1.1537E-03_JPRB,1.2600E-03_JPRB,1.4074E-03_JPRB/)
KAO( :, 5, 1, 9) = (/&
&1.6572E-03_JPRB,1.6190E-03_JPRB,1.5928E-03_JPRB,1.5446E-03_JPRB,1.4696E-03_JPRB,1.4385E-03_JPRB,&
&1.5029E-03_JPRB,1.6559E-03_JPRB,1.8563E-03_JPRB/)
KAO( :, 1, 2, 9) = (/&
&7.2791E-04_JPRB,6.5760E-04_JPRB,5.9478E-04_JPRB,5.3539E-04_JPRB,4.8045E-04_JPRB,4.2766E-04_JPRB,&
&4.0009E-04_JPRB,3.9735E-04_JPRB,4.3728E-04_JPRB/)
KAO( :, 2, 2, 9) = (/&
&8.1810E-04_JPRB,7.5677E-04_JPRB,7.0172E-04_JPRB,6.5562E-04_JPRB,6.0484E-04_JPRB,5.6238E-04_JPRB,&
&5.5650E-04_JPRB,5.8260E-04_JPRB,6.4861E-04_JPRB/)
KAO( :, 3, 2, 9) = (/&
&9.5216E-04_JPRB,9.0507E-04_JPRB,8.6910E-04_JPRB,8.3462E-04_JPRB,7.8786E-04_JPRB,7.5096E-04_JPRB,&
&7.5914E-04_JPRB,8.1646E-04_JPRB,9.1827E-04_JPRB/)
KAO( :, 4, 2, 9) = (/&
&1.1442E-03_JPRB,1.1148E-03_JPRB,1.1009E-03_JPRB,1.0715E-03_JPRB,1.0248E-03_JPRB,9.9267E-04_JPRB,&
&1.0179E-03_JPRB,1.1078E-03_JPRB,1.2541E-03_JPRB/)
KAO( :, 5, 2, 9) = (/&
&1.3996E-03_JPRB,1.3905E-03_JPRB,1.3914E-03_JPRB,1.3624E-03_JPRB,1.3173E-03_JPRB,1.2906E-03_JPRB,&
&1.3365E-03_JPRB,1.4703E-03_JPRB,1.6733E-03_JPRB/)
KAO( :, 1, 3, 9) = (/&
&6.9198E-04_JPRB,6.2093E-04_JPRB,5.5500E-04_JPRB,4.9112E-04_JPRB,4.2858E-04_JPRB,3.6796E-04_JPRB,&
&3.2243E-04_JPRB,2.7068E-04_JPRB,3.8445E-04_JPRB/)
KAO( :, 2, 3, 9) = (/&
&7.4808E-04_JPRB,6.8197E-04_JPRB,6.2244E-04_JPRB,5.6656E-04_JPRB,5.0936E-04_JPRB,4.6235E-04_JPRB,&
&4.4533E-04_JPRB,4.5718E-04_JPRB,5.8212E-04_JPRB/)
KAO( :, 3, 3, 9) = (/&
&8.2613E-04_JPRB,7.7358E-04_JPRB,7.3159E-04_JPRB,6.8941E-04_JPRB,6.4390E-04_JPRB,6.1118E-04_JPRB,&
&6.1390E-04_JPRB,6.5687E-04_JPRB,8.4097E-04_JPRB/)
KAO( :, 4, 3, 9) = (/&
&9.3955E-04_JPRB,9.0936E-04_JPRB,8.9358E-04_JPRB,8.6993E-04_JPRB,8.3759E-04_JPRB,8.1431E-04_JPRB,&
&8.3330E-04_JPRB,9.0689E-04_JPRB,1.1736E-03_JPRB/)
KAO( :, 5, 3, 9) = (/&
&1.1024E-03_JPRB,1.1029E-03_JPRB,1.1144E-03_JPRB,1.1087E-03_JPRB,1.0858E-03_JPRB,1.0701E-03_JPRB,&
&1.1102E-03_JPRB,1.2203E-03_JPRB,1.5855E-03_JPRB/)
KAO( :, 1, 4, 9) = (/&
&6.9141E-04_JPRB,6.1573E-04_JPRB,5.4365E-04_JPRB,4.7268E-04_JPRB,4.0185E-04_JPRB,3.3169E-04_JPRB,&
&2.6484E-04_JPRB,1.1941E-04_JPRB,4.2525E-04_JPRB/)
KAO( :, 2, 4, 9) = (/&
&7.1303E-04_JPRB,6.4311E-04_JPRB,5.7730E-04_JPRB,5.1428E-04_JPRB,4.4890E-04_JPRB,3.8935E-04_JPRB,&
&3.5277E-04_JPRB,3.2803E-04_JPRB,6.6098E-04_JPRB/)
KAO( :, 3, 4, 9) = (/&
&7.6419E-04_JPRB,7.0113E-04_JPRB,6.4756E-04_JPRB,5.8990E-04_JPRB,5.3391E-04_JPRB,4.9265E-04_JPRB,&
&4.8275E-04_JPRB,5.0730E-04_JPRB,9.8045E-04_JPRB/)
KAO( :, 4, 4, 9) = (/&
&8.2609E-04_JPRB,7.8182E-04_JPRB,7.4991E-04_JPRB,7.1089E-04_JPRB,6.7442E-04_JPRB,6.5009E-04_JPRB,&
&6.6146E-04_JPRB,7.1854E-04_JPRB,1.3938E-03_JPRB/)
KAO( :, 5, 4, 9) = (/&
&9.1327E-04_JPRB,9.0245E-04_JPRB,8.9877E-04_JPRB,8.8705E-04_JPRB,8.7034E-04_JPRB,8.6010E-04_JPRB,&
&8.9180E-04_JPRB,9.8101E-04_JPRB,1.9118E-03_JPRB/)
KAO( :, 1, 5, 9) = (/&
&7.1194E-04_JPRB,6.3073E-04_JPRB,5.5152E-04_JPRB,4.7348E-04_JPRB,3.9513E-04_JPRB,3.1519E-04_JPRB,&
&2.2983E-04_JPRB,2.7452E-05_JPRB,4.8453E-04_JPRB/)
KAO( :, 2, 5, 9) = (/&
&7.1296E-04_JPRB,6.3797E-04_JPRB,5.6646E-04_JPRB,4.9574E-04_JPRB,4.2273E-04_JPRB,3.5196E-04_JPRB,&
&2.8944E-04_JPRB,1.7242E-04_JPRB,7.7671E-04_JPRB/)
KAO( :, 3, 5, 9) = (/&
&7.3444E-04_JPRB,6.6574E-04_JPRB,6.0369E-04_JPRB,5.3780E-04_JPRB,4.7146E-04_JPRB,4.1473E-04_JPRB,&
&3.8369E-04_JPRB,3.7633E-04_JPRB,1.1824E-03_JPRB/)
KAO( :, 4, 5, 9) = (/&
&7.7697E-04_JPRB,7.1991E-04_JPRB,6.7045E-04_JPRB,6.1217E-04_JPRB,5.6053E-04_JPRB,5.2336E-04_JPRB,&
&5.2023E-04_JPRB,5.5862E-04_JPRB,1.7181E-03_JPRB/)
KAO( :, 5, 5, 9) = (/&
&8.2601E-04_JPRB,7.9119E-04_JPRB,7.6213E-04_JPRB,7.3107E-04_JPRB,6.9880E-04_JPRB,6.8266E-04_JPRB,&
&7.0503E-04_JPRB,7.7701E-04_JPRB,2.3991E-03_JPRB/)
KAO( :, 1, 6, 9) = (/&
&7.4702E-04_JPRB,6.5911E-04_JPRB,5.7262E-04_JPRB,4.8679E-04_JPRB,4.0134E-04_JPRB,3.1318E-04_JPRB,&
&1.5461E-04_JPRB,1.6758E-05_JPRB,5.2688E-04_JPRB/)
KAO( :, 2, 6, 9) = (/&
&7.4128E-04_JPRB,6.5855E-04_JPRB,5.7826E-04_JPRB,4.9892E-04_JPRB,4.1789E-04_JPRB,3.3501E-04_JPRB,&
&2.5184E-04_JPRB,5.3936E-05_JPRB,8.7850E-04_JPRB/)
KAO( :, 3, 6, 9) = (/&
&7.3954E-04_JPRB,6.6416E-04_JPRB,5.9359E-04_JPRB,5.2126E-04_JPRB,4.4507E-04_JPRB,3.7370E-04_JPRB,&
&3.1408E-04_JPRB,2.2236E-04_JPRB,1.3809E-03_JPRB/)
KAO( :, 4, 6, 9) = (/&
&7.5717E-04_JPRB,6.9002E-04_JPRB,6.2962E-04_JPRB,5.6099E-04_JPRB,4.9557E-04_JPRB,4.3902E-04_JPRB,&
&4.1006E-04_JPRB,4.1489E-04_JPRB,2.0655E-03_JPRB/)
KAO( :, 5, 6, 9) = (/&
&7.8954E-04_JPRB,7.3758E-04_JPRB,6.8841E-04_JPRB,6.3360E-04_JPRB,5.8155E-04_JPRB,5.4713E-04_JPRB,&
&5.4922E-04_JPRB,5.9986E-04_JPRB,2.9589E-03_JPRB/)
KAO( :, 1, 7, 9) = (/&
&7.9467E-04_JPRB,6.9929E-04_JPRB,6.0424E-04_JPRB,5.1073E-04_JPRB,4.1693E-04_JPRB,3.2089E-04_JPRB,&
&5.1325E-05_JPRB,1.2122E-05_JPRB,6.0259E-04_JPRB/)
KAO( :, 2, 7, 9) = (/&
&7.8343E-04_JPRB,6.9250E-04_JPRB,6.0357E-04_JPRB,5.1592E-04_JPRB,4.2687E-04_JPRB,3.3542E-04_JPRB,&
&2.2592E-04_JPRB,1.5976E-05_JPRB,1.0502E-03_JPRB/)
KAO( :, 3, 7, 9) = (/&
&7.7573E-04_JPRB,6.9130E-04_JPRB,6.0997E-04_JPRB,5.2908E-04_JPRB,4.4409E-04_JPRB,3.5904E-04_JPRB,&
&2.7616E-04_JPRB,9.2965E-05_JPRB,1.7102E-03_JPRB/)
KAO( :, 4, 7, 9) = (/&
&7.7294E-04_JPRB,6.9692E-04_JPRB,6.2657E-04_JPRB,5.4965E-04_JPRB,4.7312E-04_JPRB,3.9920E-04_JPRB,&
&3.3903E-04_JPRB,2.7602E-04_JPRB,2.6319E-03_JPRB/)
KAO( :, 5, 7, 9) = (/&
&7.8731E-04_JPRB,7.2173E-04_JPRB,6.5887E-04_JPRB,5.9065E-04_JPRB,5.2295E-04_JPRB,4.6490E-04_JPRB,&
&4.3618E-04_JPRB,4.5346E-04_JPRB,3.8668E-03_JPRB/)
KAO( :, 1, 8, 9) = (/&
&8.5501E-04_JPRB,7.5078E-04_JPRB,6.4657E-04_JPRB,5.4366E-04_JPRB,4.4039E-04_JPRB,3.3294E-04_JPRB,&
&2.6688E-05_JPRB,1.2258E-05_JPRB,8.1286E-04_JPRB/)
KAO( :, 2, 8, 9) = (/&
&8.4099E-04_JPRB,7.4093E-04_JPRB,6.4228E-04_JPRB,5.4430E-04_JPRB,4.4636E-04_JPRB,3.4551E-04_JPRB,&
&1.0468E-04_JPRB,1.2830E-05_JPRB,1.4923E-03_JPRB/)
KAO( :, 3, 8, 9) = (/&
&8.2855E-04_JPRB,7.3472E-04_JPRB,6.4208E-04_JPRB,5.5147E-04_JPRB,4.5797E-04_JPRB,3.6152E-04_JPRB,&
&2.5538E-04_JPRB,1.6241E-05_JPRB,2.5369E-03_JPRB/)
KAO( :, 4, 8, 9) = (/&
&8.1840E-04_JPRB,7.3203E-04_JPRB,6.4929E-04_JPRB,5.6425E-04_JPRB,4.7544E-04_JPRB,3.8760E-04_JPRB,&
&3.0236E-04_JPRB,1.3733E-04_JPRB,4.0371E-03_JPRB/)
KAO( :, 5, 8, 9) = (/&
&8.1270E-04_JPRB,7.3589E-04_JPRB,6.6348E-04_JPRB,5.8412E-04_JPRB,5.0562E-04_JPRB,4.2829E-04_JPRB,&
&3.6616E-04_JPRB,3.2564E-04_JPRB,6.0900E-03_JPRB/)
KAO( :, 1, 9, 9) = (/&
&9.2560E-04_JPRB,8.1125E-04_JPRB,6.9819E-04_JPRB,5.8413E-04_JPRB,4.7055E-04_JPRB,3.5015E-04_JPRB,&
&5.5500E-06_JPRB,4.9629E-06_JPRB,2.0290E-03_JPRB/)
KAO( :, 2, 9, 9) = (/&
&9.1093E-04_JPRB,8.0097E-04_JPRB,6.9137E-04_JPRB,5.8249E-04_JPRB,4.7378E-04_JPRB,3.6194E-04_JPRB,&
&3.0062E-05_JPRB,1.0842E-05_JPRB,3.9531E-03_JPRB/)
KAO( :, 3, 9, 9) = (/&
&8.9709E-04_JPRB,7.9180E-04_JPRB,6.8775E-04_JPRB,5.8518E-04_JPRB,4.8156E-04_JPRB,3.7367E-04_JPRB,&
&1.7999E-04_JPRB,1.5619E-05_JPRB,7.0405E-03_JPRB/)
KAO( :, 4, 9, 9) = (/&
&8.8317E-04_JPRB,7.8542E-04_JPRB,6.8899E-04_JPRB,5.9345E-04_JPRB,4.9320E-04_JPRB,3.9217E-04_JPRB,&
&2.8412E-04_JPRB,3.4988E-05_JPRB,1.1630E-02_JPRB/)
KAO( :, 5, 9, 9) = (/&
&8.7042E-04_JPRB,7.8172E-04_JPRB,6.9655E-04_JPRB,6.0534E-04_JPRB,5.1346E-04_JPRB,4.2035E-04_JPRB,&
&3.3049E-04_JPRB,1.7732E-04_JPRB,1.8084E-02_JPRB/)
KAO( :, 1,10, 9) = (/&
&1.0020E-03_JPRB,8.7768E-04_JPRB,7.5453E-04_JPRB,6.2994E-04_JPRB,5.0369E-04_JPRB,2.0029E-04_JPRB,&
&4.8338E-06_JPRB,1.1150E-06_JPRB,6.1828E-03_JPRB/)
KAO( :, 2,10, 9) = (/&
&9.8614E-04_JPRB,8.6564E-04_JPRB,7.4527E-04_JPRB,6.2596E-04_JPRB,5.0608E-04_JPRB,3.8053E-04_JPRB,&
&2.2407E-05_JPRB,6.0753E-06_JPRB,1.2701E-02_JPRB/)
KAO( :, 3,10, 9) = (/&
&9.7041E-04_JPRB,8.5442E-04_JPRB,7.4008E-04_JPRB,6.2563E-04_JPRB,5.1190E-04_JPRB,3.9299E-04_JPRB,&
&5.6685E-05_JPRB,1.0644E-05_JPRB,2.3596E-02_JPRB/)
KAO( :, 4,10, 9) = (/&
&9.5474E-04_JPRB,8.4629E-04_JPRB,7.3757E-04_JPRB,6.3110E-04_JPRB,5.2156E-04_JPRB,4.0815E-04_JPRB,&
&2.6069E-04_JPRB,1.4418E-05_JPRB,4.0339E-02_JPRB/)
KAO( :, 5,10, 9) = (/&
&9.3936E-04_JPRB,8.3916E-04_JPRB,7.4145E-04_JPRB,6.4037E-04_JPRB,5.3630E-04_JPRB,4.3024E-04_JPRB,&
&3.1815E-04_JPRB,7.5689E-05_JPRB,6.4528E-02_JPRB/)
KAO( :, 1,11, 9) = (/&
&1.0733E-03_JPRB,9.4010E-04_JPRB,8.0821E-04_JPRB,6.7481E-04_JPRB,5.3993E-04_JPRB,1.7304E-04_JPRB,&
&4.5690E-06_JPRB,1.0947E-06_JPRB,9.5058E-03_JPRB/)
KAO( :, 2,11, 9) = (/&
&1.0562E-03_JPRB,9.2720E-04_JPRB,7.9859E-04_JPRB,6.7071E-04_JPRB,5.4165E-04_JPRB,4.0387E-04_JPRB,&
&2.1514E-05_JPRB,7.8378E-06_JPRB,1.9538E-02_JPRB/)
KAO( :, 3,11, 9) = (/&
&1.0391E-03_JPRB,9.1541E-04_JPRB,7.9272E-04_JPRB,6.7016E-04_JPRB,5.4829E-04_JPRB,4.2037E-04_JPRB,&
&4.6128E-05_JPRB,1.0839E-05_JPRB,3.6276E-02_JPRB/)
KAO( :, 4,11, 9) = (/&
&1.0222E-03_JPRB,9.0627E-04_JPRB,7.9028E-04_JPRB,6.7590E-04_JPRB,5.5839E-04_JPRB,4.3725E-04_JPRB,&
&2.4358E-04_JPRB,1.5967E-05_JPRB,6.2057E-02_JPRB/)
KAO( :, 5,11, 9) = (/&
&1.0062E-03_JPRB,8.9870E-04_JPRB,7.9417E-04_JPRB,6.8540E-04_JPRB,5.7395E-04_JPRB,4.5941E-04_JPRB,&
&3.3487E-04_JPRB,5.8510E-05_JPRB,9.9558E-02_JPRB/)
KAO( :, 1,12, 9) = (/&
&1.1429E-03_JPRB,1.0011E-03_JPRB,8.6066E-04_JPRB,7.1891E-04_JPRB,5.7572E-04_JPRB,2.3708E-04_JPRB,&
&4.4567E-06_JPRB,5.1497E-06_JPRB,1.0798E-02_JPRB/)
KAO( :, 2,12, 9) = (/&
&1.1252E-03_JPRB,9.8802E-04_JPRB,8.5145E-04_JPRB,7.1518E-04_JPRB,5.7793E-04_JPRB,4.3517E-04_JPRB,&
&2.8931E-05_JPRB,1.3305E-05_JPRB,2.2185E-02_JPRB/)
KAO( :, 3,12, 9) = (/&
&1.1078E-03_JPRB,9.7648E-04_JPRB,8.4588E-04_JPRB,7.1557E-04_JPRB,5.8568E-04_JPRB,4.5025E-04_JPRB,&
&8.7797E-05_JPRB,1.2058E-05_JPRB,4.1218E-02_JPRB/)
KAO( :, 4,12, 9) = (/&
&1.0907E-03_JPRB,9.6728E-04_JPRB,8.4415E-04_JPRB,7.2188E-04_JPRB,5.9608E-04_JPRB,4.6749E-04_JPRB,&
&2.9839E-04_JPRB,1.3906E-05_JPRB,7.0748E-02_JPRB/)
KAO( :, 5,12, 9) = (/&
&1.0737E-03_JPRB,9.5961E-04_JPRB,8.4835E-04_JPRB,7.3154E-04_JPRB,6.1267E-04_JPRB,4.9042E-04_JPRB,&
&3.5775E-04_JPRB,5.9229E-05_JPRB,1.1398E-01_JPRB/)
KAO( :, 1,13, 9) = (/&
&1.2093E-03_JPRB,1.0592E-03_JPRB,9.1069E-04_JPRB,7.6104E-04_JPRB,6.0998E-04_JPRB,3.0141E-04_JPRB,&
&8.4692E-06_JPRB,3.6390E-06_JPRB,9.7505E-03_JPRB/)
KAO( :, 2,13, 9) = (/&
&1.1916E-03_JPRB,1.0465E-03_JPRB,9.0223E-04_JPRB,7.5810E-04_JPRB,6.1322E-04_JPRB,4.6338E-04_JPRB,&
&3.8957E-05_JPRB,7.1625E-06_JPRB,2.0045E-02_JPRB/)
KAO( :, 3,13, 9) = (/&
&1.1742E-03_JPRB,1.0355E-03_JPRB,8.9704E-04_JPRB,7.5964E-04_JPRB,6.2169E-04_JPRB,4.7851E-04_JPRB,&
&1.3589E-04_JPRB,1.1895E-05_JPRB,3.7380E-02_JPRB/)
KAO( :, 4,13, 9) = (/&
&1.1565E-03_JPRB,1.0260E-03_JPRB,8.9628E-04_JPRB,7.6660E-04_JPRB,6.3308E-04_JPRB,4.9715E-04_JPRB,&
&3.4150E-04_JPRB,1.1060E-05_JPRB,6.4458E-02_JPRB/)
KAO( :, 5,13, 9) = (/&
&1.1382E-03_JPRB,1.0180E-03_JPRB,9.0061E-04_JPRB,7.7706E-04_JPRB,6.5089E-04_JPRB,5.2149E-04_JPRB,&
&3.8129E-04_JPRB,5.9752E-05_JPRB,1.0436E-01_JPRB/)
KAO( :, 1, 1,10) = (/&
&9.4926E-04_JPRB,8.5786E-04_JPRB,8.1138E-04_JPRB,7.6433E-04_JPRB,7.2663E-04_JPRB,7.8967E-04_JPRB,&
&8.8787E-04_JPRB,9.8903E-04_JPRB,1.1026E-03_JPRB/)
KAO( :, 2, 1,10) = (/&
&1.2390E-03_JPRB,1.1300E-03_JPRB,1.0621E-03_JPRB,9.8809E-04_JPRB,9.8084E-04_JPRB,1.1153E-03_JPRB,&
&1.2754E-03_JPRB,1.4463E-03_JPRB,1.6199E-03_JPRB/)
KAO( :, 3, 1,10) = (/&
&1.6285E-03_JPRB,1.4941E-03_JPRB,1.4019E-03_JPRB,1.3143E-03_JPRB,1.3388E-03_JPRB,1.5587E-03_JPRB,&
&1.7963E-03_JPRB,2.0319E-03_JPRB,2.2893E-03_JPRB/)
KAO( :, 4, 1,10) = (/&
&2.1075E-03_JPRB,1.9429E-03_JPRB,1.8233E-03_JPRB,1.7260E-03_JPRB,1.7987E-03_JPRB,2.1195E-03_JPRB,&
&2.4630E-03_JPRB,2.8065E-03_JPRB,3.1716E-03_JPRB/)
KAO( :, 5, 1,10) = (/&
&2.6676E-03_JPRB,2.4810E-03_JPRB,2.3359E-03_JPRB,2.2329E-03_JPRB,2.3416E-03_JPRB,2.7812E-03_JPRB,&
&3.2550E-03_JPRB,3.7334E-03_JPRB,4.2210E-03_JPRB/)
KAO( :, 1, 2,10) = (/&
&8.9025E-04_JPRB,8.0274E-04_JPRB,7.4274E-04_JPRB,6.8609E-04_JPRB,6.7102E-04_JPRB,7.1742E-04_JPRB,&
&7.9680E-04_JPRB,8.7045E-04_JPRB,9.7644E-04_JPRB/)
KAO( :, 2, 2,10) = (/&
&1.1017E-03_JPRB,1.0100E-03_JPRB,9.5453E-04_JPRB,8.9274E-04_JPRB,8.8682E-04_JPRB,1.0003E-03_JPRB,&
&1.1309E-03_JPRB,1.2737E-03_JPRB,1.4319E-03_JPRB/)
KAO( :, 3, 2,10) = (/&
&1.4395E-03_JPRB,1.3424E-03_JPRB,1.2619E-03_JPRB,1.1931E-03_JPRB,1.1956E-03_JPRB,1.3885E-03_JPRB,&
&1.5988E-03_JPRB,1.8061E-03_JPRB,2.0428E-03_JPRB/)
KAO( :, 4, 2,10) = (/&
&1.8618E-03_JPRB,1.7544E-03_JPRB,1.6479E-03_JPRB,1.5853E-03_JPRB,1.5993E-03_JPRB,1.8833E-03_JPRB,&
&2.1846E-03_JPRB,2.4927E-03_JPRB,2.8370E-03_JPRB/)
KAO( :, 5, 2,10) = (/&
&2.3686E-03_JPRB,2.2486E-03_JPRB,2.1364E-03_JPRB,2.0670E-03_JPRB,2.0882E-03_JPRB,2.4685E-03_JPRB,&
&2.8904E-03_JPRB,3.3295E-03_JPRB,3.7864E-03_JPRB/)
KAO( :, 1, 3,10) = (/&
&8.4979E-04_JPRB,7.6433E-04_JPRB,6.9594E-04_JPRB,6.3370E-04_JPRB,5.8853E-04_JPRB,5.9559E-04_JPRB,&
&6.5667E-04_JPRB,7.1533E-04_JPRB,8.1217E-04_JPRB/)
KAO( :, 2, 3,10) = (/&
&9.3603E-04_JPRB,8.5921E-04_JPRB,7.9338E-04_JPRB,7.5508E-04_JPRB,7.6062E-04_JPRB,8.4114E-04_JPRB,&
&9.4920E-04_JPRB,1.0487E-03_JPRB,1.2014E-03_JPRB/)
KAO( :, 3, 3,10) = (/&
&1.1433E-03_JPRB,1.0846E-03_JPRB,1.0263E-03_JPRB,9.9233E-04_JPRB,1.0119E-03_JPRB,1.1695E-03_JPRB,&
&1.3351E-03_JPRB,1.4995E-03_JPRB,1.7286E-03_JPRB/)
KAO( :, 4, 3,10) = (/&
&1.4720E-03_JPRB,1.4093E-03_JPRB,1.3576E-03_JPRB,1.3122E-03_JPRB,1.3394E-03_JPRB,1.5776E-03_JPRB,&
&1.8258E-03_JPRB,2.0744E-03_JPRB,2.3896E-03_JPRB/)
KAO( :, 5, 3,10) = (/&
&1.8783E-03_JPRB,1.8107E-03_JPRB,1.7793E-03_JPRB,1.7293E-03_JPRB,1.7612E-03_JPRB,2.0848E-03_JPRB,&
&2.4329E-03_JPRB,2.7873E-03_JPRB,3.2122E-03_JPRB/)
KAO( :, 1, 4,10) = (/&
&8.5598E-04_JPRB,7.6200E-04_JPRB,6.7698E-04_JPRB,6.0274E-04_JPRB,5.4143E-04_JPRB,4.8510E-04_JPRB,&
&5.0808E-04_JPRB,5.4195E-04_JPRB,7.2030E-04_JPRB/)
KAO( :, 2, 4,10) = (/&
&8.7829E-04_JPRB,7.9754E-04_JPRB,7.2820E-04_JPRB,6.8132E-04_JPRB,6.4105E-04_JPRB,6.7652E-04_JPRB,&
&7.5328E-04_JPRB,8.3000E-04_JPRB,1.1216E-03_JPRB/)
KAO( :, 3, 4,10) = (/&
&9.6941E-04_JPRB,9.0019E-04_JPRB,8.3950E-04_JPRB,8.2706E-04_JPRB,8.3972E-04_JPRB,9.4956E-04_JPRB,&
&1.0831E-03_JPRB,1.2181E-03_JPRB,1.6652E-03_JPRB/)
KAO( :, 4, 4,10) = (/&
&1.1497E-03_JPRB,1.1076E-03_JPRB,1.0973E-03_JPRB,1.0748E-03_JPRB,1.1139E-03_JPRB,1.3070E-03_JPRB,&
&1.5051E-03_JPRB,1.7091E-03_JPRB,2.3798E-03_JPRB/)
KAO( :, 5, 4,10) = (/&
&1.4423E-03_JPRB,1.4228E-03_JPRB,1.4377E-03_JPRB,1.4117E-03_JPRB,1.4741E-03_JPRB,1.7577E-03_JPRB,&
&2.0499E-03_JPRB,2.3324E-03_JPRB,3.2737E-03_JPRB/)
KAO( :, 1, 5,10) = (/&
&8.8900E-04_JPRB,7.8652E-04_JPRB,6.9034E-04_JPRB,5.9667E-04_JPRB,5.1545E-04_JPRB,4.4672E-04_JPRB,&
&3.9522E-04_JPRB,3.0801E-04_JPRB,9.0832E-04_JPRB/)
KAO( :, 2, 5,10) = (/&
&8.9256E-04_JPRB,7.9933E-04_JPRB,7.1388E-04_JPRB,6.4679E-04_JPRB,5.8953E-04_JPRB,5.4566E-04_JPRB,&
&5.8778E-04_JPRB,6.2517E-04_JPRB,1.4726E-03_JPRB/)
KAO( :, 3, 5,10) = (/&
&9.1630E-04_JPRB,8.3731E-04_JPRB,7.6863E-04_JPRB,7.3348E-04_JPRB,7.0053E-04_JPRB,7.6737E-04_JPRB,&
&8.6212E-04_JPRB,9.5439E-04_JPRB,2.2518E-03_JPRB/)
KAO( :, 4, 5,10) = (/&
&1.0039E-03_JPRB,9.3325E-04_JPRB,8.9498E-04_JPRB,8.8178E-04_JPRB,9.2025E-04_JPRB,1.0734E-03_JPRB,&
&1.2371E-03_JPRB,1.3976E-03_JPRB,3.3076E-03_JPRB/)
KAO( :, 5, 5,10) = (/&
&1.1384E-03_JPRB,1.1125E-03_JPRB,1.1459E-03_JPRB,1.1447E-03_JPRB,1.2384E-03_JPRB,1.4768E-03_JPRB,&
&1.7232E-03_JPRB,1.9621E-03_JPRB,4.6582E-03_JPRB/)
KAO( :, 1, 6,10) = (/&
&9.4887E-04_JPRB,8.3839E-04_JPRB,7.3102E-04_JPRB,6.2493E-04_JPRB,5.2042E-04_JPRB,4.2275E-04_JPRB,&
&3.3556E-04_JPRB,3.4740E-06_JPRB,1.1251E-03_JPRB/)
KAO( :, 2, 6,10) = (/&
&9.3677E-04_JPRB,8.3218E-04_JPRB,7.3454E-04_JPRB,6.4594E-04_JPRB,5.6378E-04_JPRB,4.9151E-04_JPRB,&
&4.4994E-04_JPRB,4.2597E-04_JPRB,1.8832E-03_JPRB/)
KAO( :, 3, 6,10) = (/&
&9.3921E-04_JPRB,8.4673E-04_JPRB,7.5957E-04_JPRB,6.9636E-04_JPRB,6.3706E-04_JPRB,6.1057E-04_JPRB,&
&6.7476E-04_JPRB,7.3912E-04_JPRB,2.9583E-03_JPRB/)
KAO( :, 4, 6,10) = (/&
&9.5719E-04_JPRB,8.7688E-04_JPRB,8.1813E-04_JPRB,7.7967E-04_JPRB,7.5775E-04_JPRB,8.5851E-04_JPRB,&
&9.8609E-04_JPRB,1.1121E-03_JPRB,4.4273E-03_JPRB/)
KAO( :, 5, 6,10) = (/&
&1.0294E-03_JPRB,9.6457E-04_JPRB,9.3753E-04_JPRB,9.2588E-04_JPRB,1.0133E-03_JPRB,1.2038E-03_JPRB,&
&1.4020E-03_JPRB,1.6034E-03_JPRB,6.3437E-03_JPRB/)
KAO( :, 1, 7,10) = (/&
&1.0279E-03_JPRB,9.0433E-04_JPRB,7.8375E-04_JPRB,6.6508E-04_JPRB,5.4484E-04_JPRB,4.2431E-04_JPRB,&
&2.6888E-04_JPRB,7.8015E-06_JPRB,1.4588E-03_JPRB/)
KAO( :, 2, 7,10) = (/&
&1.0083E-03_JPRB,8.9241E-04_JPRB,7.8172E-04_JPRB,6.7204E-04_JPRB,5.7124E-04_JPRB,4.6914E-04_JPRB,&
&3.6802E-04_JPRB,8.6137E-05_JPRB,2.5625E-03_JPRB/)
KAO( :, 3, 7,10) = (/&
&9.9596E-04_JPRB,8.9237E-04_JPRB,7.9108E-04_JPRB,7.0321E-04_JPRB,6.1556E-04_JPRB,5.3871E-04_JPRB,&
&5.1518E-04_JPRB,5.4052E-04_JPRB,4.1805E-03_JPRB/)
KAO( :, 4, 7,10) = (/&
&9.8826E-04_JPRB,8.9639E-04_JPRB,8.1334E-04_JPRB,7.5573E-04_JPRB,6.8824E-04_JPRB,6.8183E-04_JPRB,&
&7.7451E-04_JPRB,8.6801E-04_JPRB,6.4027E-03_JPRB/)
KAO( :, 5, 7,10) = (/&
&1.0011E-03_JPRB,9.2233E-04_JPRB,8.6964E-04_JPRB,8.2719E-04_JPRB,8.3320E-04_JPRB,9.6571E-04_JPRB,&
&1.1203E-03_JPRB,1.2853E-03_JPRB,9.3461E-03_JPRB/)
KAO( :, 1, 8,10) = (/&
&1.1125E-03_JPRB,9.7475E-04_JPRB,8.4628E-04_JPRB,7.1245E-04_JPRB,5.8223E-04_JPRB,4.4955E-04_JPRB,&
&1.2055E-05_JPRB,1.4979E-05_JPRB,2.2126E-03_JPRB/)
KAO( :, 2, 8,10) = (/&
&1.0938E-03_JPRB,9.6654E-04_JPRB,8.3997E-04_JPRB,7.1323E-04_JPRB,5.9255E-04_JPRB,4.7230E-04_JPRB,&
&3.2313E-04_JPRB,3.4269E-06_JPRB,4.0836E-03_JPRB/)
KAO( :, 3, 8,10) = (/&
&1.0758E-03_JPRB,9.5487E-04_JPRB,8.3741E-04_JPRB,7.2643E-04_JPRB,6.2166E-04_JPRB,5.1323E-04_JPRB,&
&4.2493E-04_JPRB,3.0113E-04_JPRB,6.9437E-03_JPRB/)
KAO( :, 4, 8,10) = (/&
&1.0550E-03_JPRB,9.4862E-04_JPRB,8.4799E-04_JPRB,7.6117E-04_JPRB,6.7028E-04_JPRB,5.9614E-04_JPRB,&
&6.0166E-04_JPRB,6.5642E-04_JPRB,1.1024E-02_JPRB/)
KAO( :, 5, 8,10) = (/&
&1.0393E-03_JPRB,9.5089E-04_JPRB,8.7866E-04_JPRB,8.1224E-04_JPRB,7.5400E-04_JPRB,7.6815E-04_JPRB,&
&8.8282E-04_JPRB,1.0221E-03_JPRB,1.6724E-02_JPRB/)
KAO( :, 1, 9,10) = (/&
&1.2180E-03_JPRB,1.0664E-03_JPRB,9.2270E-04_JPRB,7.7328E-04_JPRB,6.2475E-04_JPRB,4.6815E-04_JPRB,&
&9.5178E-06_JPRB,3.3772E-06_JPRB,6.2846E-03_JPRB/)
KAO( :, 2, 9,10) = (/&
&1.1921E-03_JPRB,1.0498E-03_JPRB,9.0635E-04_JPRB,7.6682E-04_JPRB,6.2317E-04_JPRB,4.8406E-04_JPRB,&
&8.3341E-05_JPRB,3.8343E-06_JPRB,1.2227E-02_JPRB/)
KAO( :, 3, 9,10) = (/&
&1.1669E-03_JPRB,1.0310E-03_JPRB,8.9852E-04_JPRB,7.6558E-04_JPRB,6.4277E-04_JPRB,5.2121E-04_JPRB,&
&3.7666E-04_JPRB,1.2040E-05_JPRB,2.1734E-02_JPRB/)
KAO( :, 4, 9,10) = (/&
&1.1470E-03_JPRB,1.0235E-03_JPRB,9.0044E-04_JPRB,7.8767E-04_JPRB,6.8183E-04_JPRB,5.6489E-04_JPRB,&
&4.9156E-04_JPRB,4.5088E-04_JPRB,3.6006E-02_JPRB/)
KAO( :, 5, 9,10) = (/&
&1.1295E-03_JPRB,1.0174E-03_JPRB,9.1849E-04_JPRB,8.2709E-04_JPRB,7.3027E-04_JPRB,6.6994E-04_JPRB,&
&6.9088E-04_JPRB,7.9186E-04_JPRB,5.6162E-02_JPRB/)
KAO( :, 1,10,10) = (/&
&1.3419E-03_JPRB,1.1745E-03_JPRB,1.0112E-03_JPRB,8.4729E-04_JPRB,6.7925E-04_JPRB,4.9697E-04_JPRB,&
&1.5254E-06_JPRB,1.5343E-06_JPRB,2.0999E-02_JPRB/)
KAO( :, 2,10,10) = (/&
&1.3141E-03_JPRB,1.1539E-03_JPRB,9.9630E-04_JPRB,8.3744E-04_JPRB,6.7916E-04_JPRB,5.1101E-04_JPRB,&
&6.8452E-06_JPRB,3.0451E-06_JPRB,4.3024E-02_JPRB/)
KAO( :, 3,10,10) = (/&
&1.2898E-03_JPRB,1.1375E-03_JPRB,9.8703E-04_JPRB,8.3404E-04_JPRB,6.8649E-04_JPRB,5.3929E-04_JPRB,&
&3.2626E-04_JPRB,6.0173E-06_JPRB,7.9885E-02_JPRB/)
KAO( :, 4,10,10) = (/&
&1.2672E-03_JPRB,1.1264E-03_JPRB,9.8249E-04_JPRB,8.4764E-04_JPRB,7.1223E-04_JPRB,5.7730E-04_JPRB,&
&4.4171E-04_JPRB,9.9896E-05_JPRB,1.3680E-01_JPRB/)
KAO( :, 5,10,10) = (/&
&1.2477E-03_JPRB,1.1172E-03_JPRB,9.9135E-04_JPRB,8.7077E-04_JPRB,7.4770E-04_JPRB,6.3934E-04_JPRB,&
&5.7696E-04_JPRB,6.1656E-04_JPRB,2.1952E-01_JPRB/)
KAO( :, 1,11,10) = (/&
&1.4755E-03_JPRB,1.2917E-03_JPRB,1.1119E-03_JPRB,9.3058E-04_JPRB,7.4744E-04_JPRB,5.5051E-04_JPRB,&
&1.6522E-06_JPRB,1.5412E-06_JPRB,3.4475E-02_JPRB/)
KAO( :, 2,11,10) = (/&
&1.4485E-03_JPRB,1.2719E-03_JPRB,1.0971E-03_JPRB,9.2191E-04_JPRB,7.4745E-04_JPRB,5.7109E-04_JPRB,&
&1.1696E-05_JPRB,3.1243E-06_JPRB,7.0850E-02_JPRB/)
KAO( :, 3,11,10) = (/&
&1.4264E-03_JPRB,1.2579E-03_JPRB,1.0914E-03_JPRB,9.2154E-04_JPRB,7.5855E-04_JPRB,5.9482E-04_JPRB,&
&3.1605E-04_JPRB,9.6309E-06_JPRB,1.3183E-01_JPRB/)
KAO( :, 4,11,10) = (/&
&1.4023E-03_JPRB,1.2457E-03_JPRB,1.0849E-03_JPRB,9.3462E-04_JPRB,7.7881E-04_JPRB,6.1925E-04_JPRB,&
&4.6174E-04_JPRB,2.1053E-05_JPRB,2.2597E-01_JPRB/)
KAO( :, 5,11,10) = (/&
&1.3792E-03_JPRB,1.2345E-03_JPRB,1.0916E-03_JPRB,9.5041E-04_JPRB,8.0615E-04_JPRB,6.7157E-04_JPRB,&
&5.8929E-04_JPRB,6.0215E-04_JPRB,3.6233E-01_JPRB/)
KAO( :, 1,12,10) = (/&
&1.6315E-03_JPRB,1.4286E-03_JPRB,1.2296E-03_JPRB,1.0282E-03_JPRB,8.2450E-04_JPRB,6.1652E-04_JPRB,&
&3.3057E-06_JPRB,1.5465E-06_JPRB,4.1474E-02_JPRB/)
KAO( :, 2,12,10) = (/&
&1.6041E-03_JPRB,1.4085E-03_JPRB,1.2135E-03_JPRB,1.0193E-03_JPRB,8.2407E-04_JPRB,6.2890E-04_JPRB,&
&2.0154E-05_JPRB,3.2488E-06_JPRB,8.5418E-02_JPRB/)
KAO( :, 3,12,10) = (/&
&1.5781E-03_JPRB,1.3908E-03_JPRB,1.2052E-03_JPRB,1.0160E-03_JPRB,8.3518E-04_JPRB,6.5087E-04_JPRB,&
&4.2444E-04_JPRB,1.1529E-05_JPRB,1.5881E-01_JPRB/)
KAO( :, 4,12,10) = (/&
&1.5539E-03_JPRB,1.3775E-03_JPRB,1.1979E-03_JPRB,1.0287E-03_JPRB,8.5555E-04_JPRB,6.7702E-04_JPRB,&
&4.9760E-04_JPRB,3.6698E-05_JPRB,2.7219E-01_JPRB/)
KAO( :, 5,12,10) = (/&
&1.5294E-03_JPRB,1.3662E-03_JPRB,1.2069E-03_JPRB,1.0470E-03_JPRB,8.8424E-04_JPRB,7.2459E-04_JPRB,&
&6.0457E-04_JPRB,5.8830E-04_JPRB,4.3580E-01_JPRB/)
KAO( :, 1,13,10) = (/&
&1.8076E-03_JPRB,1.5828E-03_JPRB,1.3613E-03_JPRB,1.1383E-03_JPRB,9.1463E-04_JPRB,6.8299E-04_JPRB,&
&3.0458E-06_JPRB,2.1473E-06_JPRB,3.9495E-02_JPRB/)
KAO( :, 2,13,10) = (/&
&1.7788E-03_JPRB,1.5607E-03_JPRB,1.3444E-03_JPRB,1.1293E-03_JPRB,9.1288E-04_JPRB,6.9366E-04_JPRB,&
&2.1339E-05_JPRB,1.1723E-05_JPRB,8.1294E-02_JPRB/)
KAO( :, 3,13,10) = (/&
&1.7495E-03_JPRB,1.5404E-03_JPRB,1.3343E-03_JPRB,1.1244E-03_JPRB,9.2221E-04_JPRB,7.1955E-04_JPRB,&
&4.9268E-04_JPRB,4.3370E-06_JPRB,1.5101E-01_JPRB/)
KAO( :, 4,13,10) = (/&
&1.7235E-03_JPRB,1.5270E-03_JPRB,1.3269E-03_JPRB,1.1365E-03_JPRB,9.4473E-04_JPRB,7.4612E-04_JPRB,&
&5.5227E-04_JPRB,4.6866E-05_JPRB,2.5856E-01_JPRB/)
KAO( :, 5,13,10) = (/&
&1.6990E-03_JPRB,1.5170E-03_JPRB,1.3368E-03_JPRB,1.1584E-03_JPRB,9.7488E-04_JPRB,7.9318E-04_JPRB,&
&6.2728E-04_JPRB,5.6960E-04_JPRB,4.1354E-01_JPRB/)
KAO( :, 1, 1,11) = (/&
&1.0196E-03_JPRB,9.3758E-04_JPRB,9.0316E-04_JPRB,8.5667E-04_JPRB,8.7577E-04_JPRB,1.0236E-03_JPRB,&
&1.1763E-03_JPRB,1.3143E-03_JPRB,1.4719E-03_JPRB/)
KAO( :, 2, 1,11) = (/&
&1.3459E-03_JPRB,1.2311E-03_JPRB,1.1576E-03_JPRB,1.1100E-03_JPRB,1.2232E-03_JPRB,1.4576E-03_JPRB,&
&1.6924E-03_JPRB,1.9154E-03_JPRB,2.1488E-03_JPRB/)
KAO( :, 3, 1,11) = (/&
&1.7777E-03_JPRB,1.6234E-03_JPRB,1.5128E-03_JPRB,1.4437E-03_JPRB,1.6918E-03_JPRB,2.0373E-03_JPRB,&
&2.3872E-03_JPRB,2.7172E-03_JPRB,3.0763E-03_JPRB/)
KAO( :, 4, 1,11) = (/&
&2.2969E-03_JPRB,2.1117E-03_JPRB,1.9790E-03_JPRB,1.9131E-03_JPRB,2.3134E-03_JPRB,2.7903E-03_JPRB,&
&3.2537E-03_JPRB,3.7099E-03_JPRB,4.2069E-03_JPRB/)
KAO( :, 5, 1,11) = (/&
&2.9364E-03_JPRB,2.7064E-03_JPRB,2.5487E-03_JPRB,2.4995E-03_JPRB,3.0802E-03_JPRB,3.7340E-03_JPRB,&
&4.3606E-03_JPRB,4.9323E-03_JPRB,5.6150E-03_JPRB/)
KAO( :, 1, 2,11) = (/&
&9.5564E-04_JPRB,8.6594E-04_JPRB,8.2247E-04_JPRB,7.8184E-04_JPRB,7.7258E-04_JPRB,8.9065E-04_JPRB,&
&1.0177E-03_JPRB,1.1498E-03_JPRB,1.2899E-03_JPRB/)
KAO( :, 2, 2,11) = (/&
&1.2029E-03_JPRB,1.1043E-03_JPRB,1.0479E-03_JPRB,9.9924E-04_JPRB,1.0917E-03_JPRB,1.3015E-03_JPRB,&
&1.5067E-03_JPRB,1.7035E-03_JPRB,1.9385E-03_JPRB/)
KAO( :, 3, 2,11) = (/&
&1.5957E-03_JPRB,1.4702E-03_JPRB,1.3834E-03_JPRB,1.3292E-03_JPRB,1.5404E-03_JPRB,1.8482E-03_JPRB,&
&2.1587E-03_JPRB,2.4595E-03_JPRB,2.8087E-03_JPRB/)
KAO( :, 4, 2,11) = (/&
&2.0836E-03_JPRB,1.9269E-03_JPRB,1.8210E-03_JPRB,1.7577E-03_JPRB,2.1115E-03_JPRB,2.5490E-03_JPRB,&
&2.9802E-03_JPRB,3.4053E-03_JPRB,3.8766E-03_JPRB/)
KAO( :, 5, 2,11) = (/&
&2.6761E-03_JPRB,2.4830E-03_JPRB,2.3690E-03_JPRB,2.3218E-03_JPRB,2.8435E-03_JPRB,3.4292E-03_JPRB,&
&4.0478E-03_JPRB,4.5913E-03_JPRB,5.2765E-03_JPRB/)
KAO( :, 1, 3,11) = (/&
&9.1098E-04_JPRB,8.1971E-04_JPRB,7.5453E-04_JPRB,6.8955E-04_JPRB,6.6573E-04_JPRB,7.4366E-04_JPRB,&
&8.3291E-04_JPRB,9.1681E-04_JPRB,1.0507E-03_JPRB/)
KAO( :, 2, 3,11) = (/&
&1.0095E-03_JPRB,9.2632E-04_JPRB,8.7912E-04_JPRB,8.5222E-04_JPRB,9.1711E-04_JPRB,1.0796E-03_JPRB,&
&1.2384E-03_JPRB,1.3937E-03_JPRB,1.6031E-03_JPRB/)
KAO( :, 3, 3,11) = (/&
&1.2860E-03_JPRB,1.2005E-03_JPRB,1.1448E-03_JPRB,1.1224E-03_JPRB,1.2896E-03_JPRB,1.5406E-03_JPRB,&
&1.7947E-03_JPRB,2.0396E-03_JPRB,2.3408E-03_JPRB/)
KAO( :, 4, 3,11) = (/&
&1.6840E-03_JPRB,1.5843E-03_JPRB,1.5072E-03_JPRB,1.4946E-03_JPRB,1.7912E-03_JPRB,2.1550E-03_JPRB,&
&2.5174E-03_JPRB,2.8934E-03_JPRB,3.3321E-03_JPRB/)
KAO( :, 5, 3,11) = (/&
&2.1821E-03_JPRB,2.0586E-03_JPRB,1.9862E-03_JPRB,1.9857E-03_JPRB,2.4329E-03_JPRB,2.9479E-03_JPRB,&
&3.4818E-03_JPRB,3.9625E-03_JPRB,4.5981E-03_JPRB/)
KAO( :, 1, 4,11) = (/&
&9.1007E-04_JPRB,8.1515E-04_JPRB,7.4019E-04_JPRB,6.6666E-04_JPRB,6.0223E-04_JPRB,6.1717E-04_JPRB,&
&6.7688E-04_JPRB,7.1358E-04_JPRB,8.7370E-04_JPRB/)
KAO( :, 2, 4,11) = (/&
&9.4061E-04_JPRB,8.5858E-04_JPRB,8.0024E-04_JPRB,7.4707E-04_JPRB,7.7220E-04_JPRB,8.8981E-04_JPRB,&
&1.0064E-03_JPRB,1.1094E-03_JPRB,1.3491E-03_JPRB/)
KAO( :, 3, 4,11) = (/&
&1.0580E-03_JPRB,9.8116E-04_JPRB,9.2713E-04_JPRB,9.3975E-04_JPRB,1.0753E-03_JPRB,1.2664E-03_JPRB,&
&1.4600E-03_JPRB,1.6482E-03_JPRB,1.9983E-03_JPRB/)
KAO( :, 4, 4,11) = (/&
&1.3185E-03_JPRB,1.2651E-03_JPRB,1.2235E-03_JPRB,1.2449E-03_JPRB,1.4893E-03_JPRB,1.7828E-03_JPRB,&
&2.0723E-03_JPRB,2.3550E-03_JPRB,2.8663E-03_JPRB/)
KAO( :, 5, 4,11) = (/&
&1.7012E-03_JPRB,1.6381E-03_JPRB,1.6202E-03_JPRB,1.6478E-03_JPRB,2.0248E-03_JPRB,2.4554E-03_JPRB,&
&2.8747E-03_JPRB,3.2963E-03_JPRB,4.0058E-03_JPRB/)
KAO( :, 1, 5,11) = (/&
&9.4336E-04_JPRB,8.3814E-04_JPRB,7.4599E-04_JPRB,6.5815E-04_JPRB,5.8713E-04_JPRB,5.1959E-04_JPRB,&
&5.3264E-04_JPRB,5.5247E-04_JPRB,1.0574E-03_JPRB/)
KAO( :, 2, 5,11) = (/&
&9.5312E-04_JPRB,8.5894E-04_JPRB,7.8295E-04_JPRB,7.1666E-04_JPRB,6.6657E-04_JPRB,7.2698E-04_JPRB,&
&8.1350E-04_JPRB,8.9727E-04_JPRB,1.7265E-03_JPRB/)
KAO( :, 3, 5,11) = (/&
&9.8083E-04_JPRB,9.0340E-04_JPRB,8.4536E-04_JPRB,8.1479E-04_JPRB,8.9835E-04_JPRB,1.0481E-03_JPRB,&
&1.2030E-03_JPRB,1.3495E-03_JPRB,2.6645E-03_JPRB/)
KAO( :, 4, 5,11) = (/&
&1.0919E-03_JPRB,1.0271E-03_JPRB,9.9432E-04_JPRB,1.0447E-03_JPRB,1.2444E-03_JPRB,1.4845E-03_JPRB,&
&1.7171E-03_JPRB,1.9373E-03_JPRB,3.9343E-03_JPRB/)
KAO( :, 5, 5,11) = (/&
&1.3125E-03_JPRB,1.2964E-03_JPRB,1.3064E-03_JPRB,1.3776E-03_JPRB,1.6940E-03_JPRB,2.0397E-03_JPRB,&
&2.3911E-03_JPRB,2.7218E-03_JPRB,5.5487E-03_JPRB/)
KAO( :, 1, 6,11) = (/&
&1.0191E-03_JPRB,8.9896E-04_JPRB,7.8508E-04_JPRB,6.7831E-04_JPRB,5.7633E-04_JPRB,4.9216E-04_JPRB,&
&4.0826E-04_JPRB,9.2980E-05_JPRB,1.3931E-03_JPRB/)
KAO( :, 2, 6,11) = (/&
&1.0047E-03_JPRB,8.9662E-04_JPRB,8.0205E-04_JPRB,7.1402E-04_JPRB,6.3991E-04_JPRB,5.8384E-04_JPRB,&
&6.2794E-04_JPRB,6.7696E-04_JPRB,2.3552E-03_JPRB/)
KAO( :, 3, 6,11) = (/&
&1.0047E-03_JPRB,9.1475E-04_JPRB,8.3262E-04_JPRB,7.7264E-04_JPRB,7.4682E-04_JPRB,8.3595E-04_JPRB,&
&9.5189E-04_JPRB,1.0656E-03_JPRB,3.7189E-03_JPRB/)
KAO( :, 4, 6,11) = (/&
&1.0246E-03_JPRB,9.4864E-04_JPRB,8.9322E-04_JPRB,8.8690E-04_JPRB,1.0204E-03_JPRB,1.2021E-03_JPRB,&
&1.3925E-03_JPRB,1.5656E-03_JPRB,5.5692E-03_JPRB/)
KAO( :, 5, 6,11) = (/&
&1.1192E-03_JPRB,1.0605E-03_JPRB,1.0485E-03_JPRB,1.1451E-03_JPRB,1.4045E-03_JPRB,1.6858E-03_JPRB,&
&1.9713E-03_JPRB,2.2360E-03_JPRB,7.9629E-03_JPRB/)
KAO( :, 1, 7,11) = (/&
&1.1105E-03_JPRB,9.7554E-04_JPRB,8.4845E-04_JPRB,7.2311E-04_JPRB,5.9822E-04_JPRB,4.8054E-04_JPRB,&
&3.5912E-04_JPRB,1.6334E-05_JPRB,1.8685E-03_JPRB/)
KAO( :, 2, 7,11) = (/&
&1.0953E-03_JPRB,9.7181E-04_JPRB,8.5659E-04_JPRB,7.3634E-04_JPRB,6.3339E-04_JPRB,5.4068E-04_JPRB,&
&4.8190E-04_JPRB,4.0504E-04_JPRB,3.3171E-03_JPRB/)
KAO( :, 3, 7,11) = (/&
&1.0776E-03_JPRB,9.6988E-04_JPRB,8.6596E-04_JPRB,7.7221E-04_JPRB,7.0034E-04_JPRB,6.6772E-04_JPRB,&
&7.4067E-04_JPRB,8.0814E-04_JPRB,5.4649E-03_JPRB/)
KAO( :, 4, 7,11) = (/&
&1.0633E-03_JPRB,9.7163E-04_JPRB,8.9525E-04_JPRB,8.4042E-04_JPRB,8.3803E-04_JPRB,9.5863E-04_JPRB,&
&1.0998E-03_JPRB,1.2373E-03_JPRB,8.4838E-03_JPRB/)
KAO( :, 5, 7,11) = (/&
&1.0727E-03_JPRB,1.0017E-03_JPRB,9.6422E-04_JPRB,9.7682E-04_JPRB,1.1474E-03_JPRB,1.3738E-03_JPRB,&
&1.6070E-03_JPRB,1.8227E-03_JPRB,1.2477E-02_JPRB/)
KAO( :, 1, 8,11) = (/&
&1.2212E-03_JPRB,1.0686E-03_JPRB,9.2776E-04_JPRB,7.8030E-04_JPRB,6.3679E-04_JPRB,4.9028E-04_JPRB,&
&2.5705E-05_JPRB,3.5598E-06_JPRB,3.0236E-03_JPRB/)
KAO( :, 2, 8,11) = (/&
&1.1904E-03_JPRB,1.0515E-03_JPRB,9.1846E-04_JPRB,7.8584E-04_JPRB,6.5098E-04_JPRB,5.2805E-04_JPRB,&
&4.1417E-04_JPRB,7.4299E-06_JPRB,5.6339E-03_JPRB/)
KAO( :, 3, 8,11) = (/&
&1.1656E-03_JPRB,1.0373E-03_JPRB,9.2017E-04_JPRB,7.9903E-04_JPRB,6.9375E-04_JPRB,6.0910E-04_JPRB,&
&5.7009E-04_JPRB,5.4932E-04_JPRB,9.6178E-03_JPRB/)
KAO( :, 4, 8,11) = (/&
&1.1498E-03_JPRB,1.0424E-03_JPRB,9.3266E-04_JPRB,8.4261E-04_JPRB,7.7492E-04_JPRB,7.6691E-04_JPRB,&
&8.6816E-04_JPRB,9.6408E-04_JPRB,1.5378E-02_JPRB/)
KAO( :, 5, 8,11) = (/&
&1.1310E-03_JPRB,1.0416E-03_JPRB,9.7038E-04_JPRB,9.2287E-04_JPRB,9.4475E-04_JPRB,1.1097E-03_JPRB,&
&1.2928E-03_JPRB,1.4673E-03_JPRB,2.3131E-02_JPRB/)
KAO( :, 1, 9,11) = (/&
&1.3346E-03_JPRB,1.1677E-03_JPRB,1.0079E-03_JPRB,8.4634E-04_JPRB,6.8278E-04_JPRB,5.1557E-04_JPRB,&
&6.2170E-06_JPRB,3.5575E-07_JPRB,9.0278E-03_JPRB/)
KAO( :, 2, 9,11) = (/&
&1.3004E-03_JPRB,1.1437E-03_JPRB,9.9288E-04_JPRB,8.4407E-04_JPRB,6.9152E-04_JPRB,5.4161E-04_JPRB,&
&3.0407E-04_JPRB,7.5811E-06_JPRB,1.7755E-02_JPRB/)
KAO( :, 3, 9,11) = (/&
&1.2716E-03_JPRB,1.1282E-03_JPRB,9.9193E-04_JPRB,8.4979E-04_JPRB,7.1877E-04_JPRB,5.8562E-04_JPRB,&
&4.7440E-04_JPRB,1.3642E-04_JPRB,3.1669E-02_JPRB/)
KAO( :, 4, 9,11) = (/&
&1.2493E-03_JPRB,1.1232E-03_JPRB,9.9486E-04_JPRB,8.7574E-04_JPRB,7.6208E-04_JPRB,6.8407E-04_JPRB,&
&6.7008E-04_JPRB,7.2430E-04_JPRB,5.2322E-02_JPRB/)
KAO( :, 5, 9,11) = (/&
&1.2292E-03_JPRB,1.1190E-03_JPRB,1.0123E-03_JPRB,9.2200E-04_JPRB,8.6839E-04_JPRB,8.8671E-04_JPRB,&
&1.0239E-03_JPRB,1.1645E-03_JPRB,8.1332E-02_JPRB/)
KAO( :, 1,10,11) = (/&
&1.4702E-03_JPRB,1.2866E-03_JPRB,1.1046E-03_JPRB,9.2775E-04_JPRB,7.4227E-04_JPRB,5.4877E-04_JPRB,&
&1.5669E-06_JPRB,2.1750E-07_JPRB,3.1809E-02_JPRB/)
KAO( :, 2,10,11) = (/&
&1.4381E-03_JPRB,1.2591E-03_JPRB,1.0910E-03_JPRB,9.1751E-04_JPRB,7.4581E-04_JPRB,5.6956E-04_JPRB,&
&1.4408E-05_JPRB,2.9977E-06_JPRB,6.5658E-02_JPRB/)
KAO( :, 3,10,11) = (/&
&1.4088E-03_JPRB,1.2443E-03_JPRB,1.0832E-03_JPRB,9.2001E-04_JPRB,7.6006E-04_JPRB,6.0163E-04_JPRB,&
&4.0981E-04_JPRB,3.3752E-06_JPRB,1.2158E-01_JPRB/)
KAO( :, 4,10,11) = (/&
&1.3837E-03_JPRB,1.2299E-03_JPRB,1.0785E-03_JPRB,9.3172E-04_JPRB,7.8792E-04_JPRB,6.5978E-04_JPRB,&
&5.6509E-04_JPRB,4.3870E-04_JPRB,2.0789E-01_JPRB/)
KAO( :, 5,10,11) = (/&
&1.3583E-03_JPRB,1.2214E-03_JPRB,1.0847E-03_JPRB,9.6075E-04_JPRB,8.5481E-04_JPRB,7.9082E-04_JPRB,&
&8.2900E-04_JPRB,9.3239E-04_JPRB,3.3217E-01_JPRB/)
KAO( :, 1,11,11) = (/&
&1.6253E-03_JPRB,1.4219E-03_JPRB,1.2219E-03_JPRB,1.0236E-03_JPRB,8.2003E-04_JPRB,6.0541E-04_JPRB,&
&1.4231E-06_JPRB,1.8071E-07_JPRB,5.4692E-02_JPRB/)
KAO( :, 2,11,11) = (/&
&1.5951E-03_JPRB,1.3985E-03_JPRB,1.2081E-03_JPRB,1.0150E-03_JPRB,8.2284E-04_JPRB,6.1646E-04_JPRB,&
&9.6207E-06_JPRB,2.7452E-06_JPRB,1.1216E-01_JPRB/)
KAO( :, 3,11,11) = (/&
&1.5642E-03_JPRB,1.3790E-03_JPRB,1.1965E-03_JPRB,1.0113E-03_JPRB,8.2943E-04_JPRB,6.4775E-04_JPRB,&
&4.3571E-04_JPRB,8.6785E-06_JPRB,2.0795E-01_JPRB/)
KAO( :, 4,11,11) = (/&
&1.5361E-03_JPRB,1.3630E-03_JPRB,1.1895E-03_JPRB,1.0207E-03_JPRB,8.5744E-04_JPRB,7.0323E-04_JPRB,&
&5.8809E-04_JPRB,4.1682E-04_JPRB,3.5571E-01_JPRB/)
KAO( :, 5,11,11) = (/&
&1.5066E-03_JPRB,1.3488E-03_JPRB,1.1930E-03_JPRB,1.0481E-03_JPRB,9.1295E-04_JPRB,8.2679E-04_JPRB,&
&8.2109E-04_JPRB,9.1792E-04_JPRB,5.7120E-01_JPRB/)
KAO( :, 1,12,11) = (/&
&1.8041E-03_JPRB,1.5789E-03_JPRB,1.3570E-03_JPRB,1.1389E-03_JPRB,9.1257E-04_JPRB,6.7888E-04_JPRB,&
&5.1658E-06_JPRB,1.5829E-07_JPRB,6.8561E-02_JPRB/)
KAO( :, 2,12,11) = (/&
&1.7738E-03_JPRB,1.5558E-03_JPRB,1.3438E-03_JPRB,1.1292E-03_JPRB,9.1436E-04_JPRB,6.9573E-04_JPRB,&
&2.0820E-05_JPRB,3.7433E-06_JPRB,1.4057E-01_JPRB/)
KAO( :, 3,12,11) = (/&
&1.7418E-03_JPRB,1.5353E-03_JPRB,1.3329E-03_JPRB,1.1261E-03_JPRB,9.2270E-04_JPRB,7.2358E-04_JPRB,&
&4.7954E-04_JPRB,1.5535E-05_JPRB,2.6118E-01_JPRB/)
KAO( :, 4,12,11) = (/&
&1.7090E-03_JPRB,1.5180E-03_JPRB,1.3238E-03_JPRB,1.1375E-03_JPRB,9.5111E-04_JPRB,7.6548E-04_JPRB,&
&6.0636E-04_JPRB,4.1209E-04_JPRB,4.4778E-01_JPRB/)
KAO( :, 5,12,11) = (/&
&1.6778E-03_JPRB,1.5017E-03_JPRB,1.3263E-03_JPRB,1.1626E-03_JPRB,9.9449E-04_JPRB,8.6348E-04_JPRB,&
&8.1707E-04_JPRB,9.1552E-04_JPRB,7.1823E-01_JPRB/)
KAO( :, 1,13,11) = (/&
&2.0162E-03_JPRB,1.7643E-03_JPRB,1.5166E-03_JPRB,1.2707E-03_JPRB,1.0200E-03_JPRB,7.6409E-04_JPRB,&
&1.3933E-06_JPRB,1.3814E-07_JPRB,6.7541E-02_JPRB/)
KAO( :, 2,13,11) = (/&
&1.9804E-03_JPRB,1.7378E-03_JPRB,1.5003E-03_JPRB,1.2598E-03_JPRB,1.0208E-03_JPRB,7.7583E-04_JPRB,&
&1.0519E-04_JPRB,2.9677E-05_JPRB,1.3898E-01_JPRB/)
KAO( :, 3,13,11) = (/&
&1.9463E-03_JPRB,1.7141E-03_JPRB,1.4887E-03_JPRB,1.2580E-03_JPRB,1.0319E-03_JPRB,8.0958E-04_JPRB,&
&5.4607E-04_JPRB,8.2236E-06_JPRB,2.5839E-01_JPRB/)
KAO( :, 4,13,11) = (/&
&1.9119E-03_JPRB,1.6986E-03_JPRB,1.4811E-03_JPRB,1.2741E-03_JPRB,1.0665E-03_JPRB,8.4965E-04_JPRB,&
&6.3669E-04_JPRB,4.3144E-04_JPRB,4.4372E-01_JPRB/)
KAO( :, 5,13,11) = (/&
&1.8807E-03_JPRB,1.6835E-03_JPRB,1.4885E-03_JPRB,1.3024E-03_JPRB,1.1081E-03_JPRB,9.2308E-04_JPRB,&
&8.2856E-04_JPRB,9.1296E-04_JPRB,7.1076E-01_JPRB/)
KAO( :, 1, 1,12) = (/&
&1.1348E-03_JPRB,1.0512E-03_JPRB,1.0112E-03_JPRB,1.0380E-03_JPRB,1.2591E-03_JPRB,1.5034E-03_JPRB,&
&1.7458E-03_JPRB,1.9916E-03_JPRB,2.2515E-03_JPRB/)
KAO( :, 2, 1,12) = (/&
&1.4497E-03_JPRB,1.3258E-03_JPRB,1.2902E-03_JPRB,1.3933E-03_JPRB,1.7402E-03_JPRB,2.0749E-03_JPRB,&
&2.4232E-03_JPRB,2.7843E-03_JPRB,3.1336E-03_JPRB/)
KAO( :, 3, 1,12) = (/&
&1.9087E-03_JPRB,1.7431E-03_JPRB,1.6616E-03_JPRB,1.8437E-03_JPRB,2.3259E-03_JPRB,2.8106E-03_JPRB,&
&3.3232E-03_JPRB,3.7674E-03_JPRB,4.2777E-03_JPRB/)
KAO( :, 4, 1,12) = (/&
&2.5088E-03_JPRB,2.2929E-03_JPRB,2.1415E-03_JPRB,2.4320E-03_JPRB,3.0901E-03_JPRB,3.7563E-03_JPRB,&
&4.4295E-03_JPRB,5.0514E-03_JPRB,5.7435E-03_JPRB/)
KAO( :, 5, 1,12) = (/&
&3.2224E-03_JPRB,2.9512E-03_JPRB,2.7375E-03_JPRB,3.2055E-03_JPRB,4.1147E-03_JPRB,5.0116E-03_JPRB,&
&5.9163E-03_JPRB,6.7642E-03_JPRB,7.7486E-03_JPRB/)
KAO( :, 1, 2,12) = (/&
&1.0492E-03_JPRB,9.6475E-04_JPRB,9.4375E-04_JPRB,9.3817E-04_JPRB,1.1146E-03_JPRB,1.3292E-03_JPRB,&
&1.5275E-03_JPRB,1.7383E-03_JPRB,1.9763E-03_JPRB/)
KAO( :, 2, 2,12) = (/&
&1.3114E-03_JPRB,1.2057E-03_JPRB,1.1899E-03_JPRB,1.2587E-03_JPRB,1.5556E-03_JPRB,1.8745E-03_JPRB,&
&2.1716E-03_JPRB,2.4737E-03_JPRB,2.8199E-03_JPRB/)
KAO( :, 3, 2,12) = (/&
&1.7413E-03_JPRB,1.5927E-03_JPRB,1.5301E-03_JPRB,1.6869E-03_JPRB,2.1324E-03_JPRB,2.5756E-03_JPRB,&
&3.0059E-03_JPRB,3.4270E-03_JPRB,3.9244E-03_JPRB/)
KAO( :, 4, 2,12) = (/&
&2.2840E-03_JPRB,2.1084E-03_JPRB,1.9850E-03_JPRB,2.2595E-03_JPRB,2.8933E-03_JPRB,3.5203E-03_JPRB,&
&4.1407E-03_JPRB,4.7114E-03_JPRB,5.4047E-03_JPRB/)
KAO( :, 5, 2,12) = (/&
&2.9533E-03_JPRB,2.7476E-03_JPRB,2.5658E-03_JPRB,3.0087E-03_JPRB,3.8774E-03_JPRB,4.7340E-03_JPRB,&
&5.5746E-03_JPRB,6.3471E-03_JPRB,7.3465E-03_JPRB/)
KAO( :, 1, 3,12) = (/&
&9.8854E-04_JPRB,8.9343E-04_JPRB,8.4035E-04_JPRB,7.9923E-04_JPRB,8.9609E-04_JPRB,1.0622E-03_JPRB,&
&1.2115E-03_JPRB,1.3909E-03_JPRB,1.5813E-03_JPRB/)
KAO( :, 2, 3,12) = (/&
&1.0879E-03_JPRB,1.0117E-03_JPRB,1.0134E-03_JPRB,1.0514E-03_JPRB,1.2838E-03_JPRB,1.5374E-03_JPRB,&
&1.7938E-03_JPRB,2.0363E-03_JPRB,2.3508E-03_JPRB/)
KAO( :, 3, 3,12) = (/&
&1.4163E-03_JPRB,1.3226E-03_JPRB,1.2897E-03_JPRB,1.4327E-03_JPRB,1.8163E-03_JPRB,2.1941E-03_JPRB,&
&2.5686E-03_JPRB,2.9319E-03_JPRB,3.4012E-03_JPRB/)
KAO( :, 4, 3,12) = (/&
&1.8714E-03_JPRB,1.7493E-03_JPRB,1.6791E-03_JPRB,1.9710E-03_JPRB,2.5266E-03_JPRB,3.0817E-03_JPRB,&
&3.6203E-03_JPRB,4.1272E-03_JPRB,4.8320E-03_JPRB/)
KAO( :, 5, 3,12) = (/&
&2.4278E-03_JPRB,2.3027E-03_JPRB,2.1923E-03_JPRB,2.6689E-03_JPRB,3.4381E-03_JPRB,4.1969E-03_JPRB,&
&4.9576E-03_JPRB,5.6521E-03_JPRB,6.6247E-03_JPRB/)
KAO( :, 1, 4,12) = (/&
&9.8669E-04_JPRB,8.8509E-04_JPRB,8.1352E-04_JPRB,7.2996E-04_JPRB,7.1817E-04_JPRB,8.1881E-04_JPRB,&
&9.2748E-04_JPRB,1.0403E-03_JPRB,1.2116E-03_JPRB/)
KAO( :, 2, 4,12) = (/&
&1.0290E-03_JPRB,9.4426E-04_JPRB,8.9000E-04_JPRB,8.7285E-04_JPRB,1.0287E-03_JPRB,1.2254E-03_JPRB,&
&1.4193E-03_JPRB,1.6044E-03_JPRB,1.8734E-03_JPRB/)
KAO( :, 3, 4,12) = (/&
&1.1436E-03_JPRB,1.0840E-03_JPRB,1.0833E-03_JPRB,1.1914E-03_JPRB,1.4983E-03_JPRB,1.8005E-03_JPRB,&
&2.1029E-03_JPRB,2.3872E-03_JPRB,2.8182E-03_JPRB/)
KAO( :, 4, 4,12) = (/&
&1.4872E-03_JPRB,1.4093E-03_JPRB,1.3825E-03_JPRB,1.6613E-03_JPRB,2.1282E-03_JPRB,2.5939E-03_JPRB,&
&3.0338E-03_JPRB,3.4691E-03_JPRB,4.1139E-03_JPRB/)
KAO( :, 5, 4,12) = (/&
&1.9382E-03_JPRB,1.8528E-03_JPRB,1.8277E-03_JPRB,2.2907E-03_JPRB,2.9502E-03_JPRB,3.6113E-03_JPRB,&
&4.2678E-03_JPRB,4.8667E-03_JPRB,5.7453E-03_JPRB/)
KAO( :, 1, 5,12) = (/&
&1.0261E-03_JPRB,9.1725E-04_JPRB,8.2759E-04_JPRB,7.3874E-04_JPRB,6.4512E-04_JPRB,6.5305E-04_JPRB,&
&7.2025E-04_JPRB,7.5251E-04_JPRB,1.2236E-03_JPRB/)
KAO( :, 2, 5,12) = (/&
&1.0342E-03_JPRB,9.3335E-04_JPRB,8.6180E-04_JPRB,7.8962E-04_JPRB,8.4539E-04_JPRB,9.8224E-04_JPRB,&
&1.1196E-03_JPRB,1.2424E-03_JPRB,1.9823E-03_JPRB/)
KAO( :, 3, 5,12) = (/&
&1.0684E-03_JPRB,1.0038E-03_JPRB,9.4286E-04_JPRB,9.9237E-04_JPRB,1.2238E-03_JPRB,1.4671E-03_JPRB,&
&1.7012E-03_JPRB,1.9194E-03_JPRB,3.0657E-03_JPRB/)
KAO( :, 4, 5,12) = (/&
&1.1964E-03_JPRB,1.1404E-03_JPRB,1.1495E-03_JPRB,1.3909E-03_JPRB,1.7635E-03_JPRB,2.1391E-03_JPRB,&
&2.5166E-03_JPRB,2.8551E-03_JPRB,4.5233E-03_JPRB/)
KAO( :, 5, 5,12) = (/&
&1.5188E-03_JPRB,1.4742E-03_JPRB,1.5113E-03_JPRB,1.9296E-03_JPRB,2.4758E-03_JPRB,3.0285E-03_JPRB,&
&3.5691E-03_JPRB,4.1028E-03_JPRB,6.4627E-03_JPRB/)
KAO( :, 1, 6,12) = (/&
&1.1049E-03_JPRB,9.7887E-04_JPRB,8.6230E-04_JPRB,7.6209E-04_JPRB,6.5337E-04_JPRB,5.5666E-04_JPRB,&
&5.5642E-04_JPRB,4.3457E-04_JPRB,1.6601E-03_JPRB/)
KAO( :, 2, 6,12) = (/&
&1.0940E-03_JPRB,9.8241E-04_JPRB,8.8704E-04_JPRB,7.8683E-04_JPRB,7.2565E-04_JPRB,7.9447E-04_JPRB,&
&8.9119E-04_JPRB,9.6573E-04_JPRB,2.8308E-03_JPRB/)
KAO( :, 3, 6,12) = (/&
&1.0875E-03_JPRB,9.9703E-04_JPRB,9.2009E-04_JPRB,8.7195E-04_JPRB,1.0022E-03_JPRB,1.1888E-03_JPRB,&
&1.3628E-03_JPRB,1.5154E-03_JPRB,4.5116E-03_JPRB/)
KAO( :, 4, 6,12) = (/&
&1.1159E-03_JPRB,1.0443E-03_JPRB,1.0086E-03_JPRB,1.1512E-03_JPRB,1.4495E-03_JPRB,1.7437E-03_JPRB,&
&2.0380E-03_JPRB,2.2956E-03_JPRB,6.7993E-03_JPRB/)
KAO( :, 5, 6,12) = (/&
&1.2286E-03_JPRB,1.1769E-03_JPRB,1.2461E-03_JPRB,1.5980E-03_JPRB,2.0421E-03_JPRB,2.4961E-03_JPRB,&
&2.9289E-03_JPRB,3.3559E-03_JPRB,9.7752E-03_JPRB/)
KAO( :, 1, 7,12) = (/&
&1.2137E-03_JPRB,1.0668E-03_JPRB,9.3381E-04_JPRB,8.0126E-04_JPRB,6.7255E-04_JPRB,5.4820E-04_JPRB,&
&4.1640E-04_JPRB,3.0869E-05_JPRB,2.3413E-03_JPRB/)
KAO( :, 2, 7,12) = (/&
&1.1848E-03_JPRB,1.0517E-03_JPRB,9.3479E-04_JPRB,8.1727E-04_JPRB,7.1224E-04_JPRB,6.5078E-04_JPRB,&
&7.0341E-04_JPRB,7.0961E-04_JPRB,4.1815E-03_JPRB/)
KAO( :, 3, 7,12) = (/&
&1.1720E-03_JPRB,1.0531E-03_JPRB,9.4856E-04_JPRB,8.6129E-04_JPRB,8.4208E-04_JPRB,9.5854E-04_JPRB,&
&1.0943E-03_JPRB,1.2041E-03_JPRB,6.9208E-03_JPRB/)
KAO( :, 4, 7,12) = (/&
&1.1592E-03_JPRB,1.0754E-03_JPRB,9.9552E-04_JPRB,9.9504E-04_JPRB,1.1919E-03_JPRB,1.4256E-03_JPRB,&
&1.6531E-03_JPRB,1.8455E-03_JPRB,1.0828E-02_JPRB/)
KAO( :, 5, 7,12) = (/&
&1.1731E-03_JPRB,1.1101E-03_JPRB,1.1084E-03_JPRB,1.3320E-03_JPRB,1.6974E-03_JPRB,2.0528E-03_JPRB,&
&2.4023E-03_JPRB,2.7339E-03_JPRB,1.6080E-02_JPRB/)
KAO( :, 1, 8,12) = (/&
&1.3302E-03_JPRB,1.1658E-03_JPRB,1.0139E-03_JPRB,8.5656E-04_JPRB,7.0725E-04_JPRB,5.4905E-04_JPRB,&
&1.6082E-04_JPRB,2.8484E-07_JPRB,3.9959E-03_JPRB/)
KAO( :, 2, 8,12) = (/&
&1.3004E-03_JPRB,1.1467E-03_JPRB,1.0012E-03_JPRB,8.6385E-04_JPRB,7.2504E-04_JPRB,6.1282E-04_JPRB,&
&5.3057E-04_JPRB,1.6656E-04_JPRB,7.5095E-03_JPRB/)
KAO( :, 3, 8,12) = (/&
&1.2723E-03_JPRB,1.1332E-03_JPRB,1.0084E-03_JPRB,8.8648E-04_JPRB,8.0497E-04_JPRB,7.6904E-04_JPRB,&
&8.5886E-04_JPRB,9.3436E-04_JPRB,1.2956E-02_JPRB/)
KAO( :, 4, 8,12) = (/&
&1.2504E-03_JPRB,1.1361E-03_JPRB,1.0320E-03_JPRB,9.6671E-04_JPRB,9.9043E-04_JPRB,1.1533E-03_JPRB,&
&1.3325E-03_JPRB,1.4846E-03_JPRB,2.0833E-02_JPRB/)
KAO( :, 5, 8,12) = (/&
&1.2393E-03_JPRB,1.1508E-03_JPRB,1.0962E-03_JPRB,1.1509E-03_JPRB,1.4064E-03_JPRB,1.6900E-03_JPRB,&
&1.9737E-03_JPRB,2.2347E-03_JPRB,3.1620E-02_JPRB/)
KAO( :, 1, 9,12) = (/&
&1.4663E-03_JPRB,1.2845E-03_JPRB,1.1076E-03_JPRB,9.3469E-04_JPRB,7.5727E-04_JPRB,5.8307E-04_JPRB,&
&1.6145E-06_JPRB,2.0592E-07_JPRB,1.2575E-02_JPRB/)
KAO( :, 2, 9,12) = (/&
&1.4356E-03_JPRB,1.2615E-03_JPRB,1.0955E-03_JPRB,9.3110E-04_JPRB,7.6732E-04_JPRB,6.0757E-04_JPRB,&
&4.4742E-04_JPRB,4.9464E-06_JPRB,2.4960E-02_JPRB/)
KAO( :, 3, 9,12) = (/&
&1.4052E-03_JPRB,1.2435E-03_JPRB,1.0940E-03_JPRB,9.3756E-04_JPRB,8.0269E-04_JPRB,7.0533E-04_JPRB,&
&6.6208E-04_JPRB,5.9691E-04_JPRB,4.4947E-02_JPRB/)
KAO( :, 4, 9,12) = (/&
&1.3734E-03_JPRB,1.2333E-03_JPRB,1.0941E-03_JPRB,9.8345E-04_JPRB,9.2035E-04_JPRB,9.1976E-04_JPRB,&
&1.0530E-03_JPRB,1.1532E-03_JPRB,7.5044E-02_JPRB/)
KAO( :, 5, 9,12) = (/&
&1.3495E-03_JPRB,1.2289E-03_JPRB,1.1320E-03_JPRB,1.1073E-03_JPRB,1.1561E-03_JPRB,1.3692E-03_JPRB,&
&1.6014E-03_JPRB,1.8055E-03_JPRB,1.1730E-01_JPRB/)
KAO( :, 1,10,12) = (/&
&1.6187E-03_JPRB,1.4174E-03_JPRB,1.2153E-03_JPRB,1.0239E-03_JPRB,8.2814E-04_JPRB,6.1453E-04_JPRB,&
&6.9444E-06_JPRB,1.3528E-07_JPRB,4.6442E-02_JPRB/)
KAO( :, 2,10,12) = (/&
&1.5845E-03_JPRB,1.3876E-03_JPRB,1.2040E-03_JPRB,1.0153E-03_JPRB,8.2732E-04_JPRB,6.3066E-04_JPRB,&
&6.0414E-06_JPRB,2.4038E-07_JPRB,9.7061E-02_JPRB/)
KAO( :, 3,10,12) = (/&
&1.5496E-03_JPRB,1.3649E-03_JPRB,1.1919E-03_JPRB,1.0167E-03_JPRB,8.3828E-04_JPRB,6.9321E-04_JPRB,&
&5.6244E-04_JPRB,1.6180E-05_JPRB,1.8182E-01_JPRB/)
KAO( :, 4,10,12) = (/&
&1.5143E-03_JPRB,1.3460E-03_JPRB,1.1894E-03_JPRB,1.0321E-03_JPRB,9.2147E-04_JPRB,8.3365E-04_JPRB,&
&8.4635E-04_JPRB,8.9521E-04_JPRB,3.1352E-01_JPRB/)
KAO( :, 5,10,12) = (/&
&1.4834E-03_JPRB,1.3403E-03_JPRB,1.2022E-03_JPRB,1.1224E-03_JPRB,1.0739E-03_JPRB,1.1316E-03_JPRB,&
&1.3218E-03_JPRB,1.4837E-03_JPRB,5.0232E-01_JPRB/)
KAO( :, 1,11,12) = (/&
&1.7757E-03_JPRB,1.5541E-03_JPRB,1.3331E-03_JPRB,1.1222E-03_JPRB,9.0093E-04_JPRB,6.6092E-04_JPRB,&
&2.1249E-07_JPRB,1.1902E-07_JPRB,8.4989E-02_JPRB/)
KAO( :, 2,11,12) = (/&
&1.7401E-03_JPRB,1.5236E-03_JPRB,1.3209E-03_JPRB,1.1131E-03_JPRB,9.0551E-04_JPRB,6.8456E-04_JPRB,&
&5.0849E-06_JPRB,2.2480E-07_JPRB,1.7663E-01_JPRB/)
KAO( :, 3,11,12) = (/&
&1.7062E-03_JPRB,1.5022E-03_JPRB,1.3117E-03_JPRB,1.1165E-03_JPRB,9.1999E-04_JPRB,7.4783E-04_JPRB,&
&5.9186E-04_JPRB,1.9217E-05_JPRB,3.2957E-01_JPRB/)
KAO( :, 4,11,12) = (/&
&1.6714E-03_JPRB,1.4855E-03_JPRB,1.3084E-03_JPRB,1.1327E-03_JPRB,9.9341E-04_JPRB,8.8882E-04_JPRB,&
&8.4081E-04_JPRB,8.6421E-04_JPRB,5.6545E-01_JPRB/)
KAO( :, 5,11,12) = (/&
&1.6419E-03_JPRB,1.4793E-03_JPRB,1.3196E-03_JPRB,1.2145E-03_JPRB,1.1433E-03_JPRB,1.1424E-03_JPRB,&
&1.3148E-03_JPRB,1.4973E-03_JPRB,9.0555E-01_JPRB/)
KAO( :, 1,12,12) = (/&
&1.9873E-03_JPRB,1.7393E-03_JPRB,1.4928E-03_JPRB,1.2520E-03_JPRB,1.0061E-03_JPRB,7.4569E-04_JPRB,&
&3.5180E-06_JPRB,1.0587E-07_JPRB,1.1338E-01_JPRB/)
KAO( :, 2,12,12) = (/&
&1.9520E-03_JPRB,1.7112E-03_JPRB,1.4785E-03_JPRB,1.2437E-03_JPRB,1.0101E-03_JPRB,7.5903E-04_JPRB,&
&1.0775E-04_JPRB,2.1135E-07_JPRB,2.3445E-01_JPRB/)
KAO( :, 3,12,12) = (/&
&1.9174E-03_JPRB,1.6867E-03_JPRB,1.4681E-03_JPRB,1.2458E-03_JPRB,1.0238E-03_JPRB,8.1622E-04_JPRB,&
&6.4203E-04_JPRB,3.7377E-05_JPRB,4.3560E-01_JPRB/)
KAO( :, 4,12,12) = (/&
&1.8834E-03_JPRB,1.6709E-03_JPRB,1.4657E-03_JPRB,1.2628E-03_JPRB,1.0856E-03_JPRB,9.4862E-04_JPRB,&
&8.6085E-04_JPRB,8.9434E-04_JPRB,7.4512E-01_JPRB/)
KAO( :, 5,12,12) = (/&
&1.8486E-03_JPRB,1.6625E-03_JPRB,1.4769E-03_JPRB,1.3298E-03_JPRB,1.2184E-03_JPRB,1.1740E-03_JPRB,&
&1.3120E-03_JPRB,1.5054E-03_JPRB,1.1919E+00_JPRB/)
KAO( :, 1,13,12) = (/&
&2.2427E-03_JPRB,1.9626E-03_JPRB,1.6858E-03_JPRB,1.4123E-03_JPRB,1.1345E-03_JPRB,8.4814E-04_JPRB,&
&1.1187E-05_JPRB,1.0167E-07_JPRB,1.1866E-01_JPRB/)
KAO( :, 2,13,12) = (/&
&2.2124E-03_JPRB,1.9395E-03_JPRB,1.6734E-03_JPRB,1.4094E-03_JPRB,1.1421E-03_JPRB,8.6480E-04_JPRB,&
&5.2696E-04_JPRB,2.8959E-06_JPRB,2.4434E-01_JPRB/)
KAO( :, 3,13,12) = (/&
&2.1775E-03_JPRB,1.9152E-03_JPRB,1.6674E-03_JPRB,1.4121E-03_JPRB,1.1577E-03_JPRB,9.1193E-04_JPRB,&
&6.8708E-04_JPRB,6.0943E-05_JPRB,4.5287E-01_JPRB/)
KAO( :, 4,13,12) = (/&
&2.1409E-03_JPRB,1.8984E-03_JPRB,1.6628E-03_JPRB,1.4290E-03_JPRB,1.2050E-03_JPRB,1.0161E-03_JPRB,&
&8.8642E-04_JPRB,9.0231E-04_JPRB,7.7451E-01_JPRB/)
KAO( :, 5,13,12) = (/&
&2.1006E-03_JPRB,1.8859E-03_JPRB,1.6731E-03_JPRB,1.4783E-03_JPRB,1.3081E-03_JPRB,1.2199E-03_JPRB,&
&1.3045E-03_JPRB,1.5082E-03_JPRB,1.2405E+00_JPRB/)
KAO( :, 1, 1,13) = (/&
&1.2739E-03_JPRB,1.1824E-03_JPRB,1.1666E-03_JPRB,1.5366E-03_JPRB,1.9783E-03_JPRB,2.4169E-03_JPRB,&
&2.8580E-03_JPRB,3.2493E-03_JPRB,3.6912E-03_JPRB/)
KAO( :, 2, 1,13) = (/&
&1.5764E-03_JPRB,1.4796E-03_JPRB,1.5934E-03_JPRB,2.2153E-03_JPRB,2.8682E-03_JPRB,3.5161E-03_JPRB,&
&4.1531E-03_JPRB,4.7522E-03_JPRB,5.3893E-03_JPRB/)
KAO( :, 3, 1,13) = (/&
&2.0474E-03_JPRB,1.8907E-03_JPRB,2.1514E-03_JPRB,3.0567E-03_JPRB,3.9747E-03_JPRB,4.8887E-03_JPRB,&
&5.7686E-03_JPRB,6.5999E-03_JPRB,7.5144E-03_JPRB/)
KAO( :, 4, 1,13) = (/&
&2.6856E-03_JPRB,2.4413E-03_JPRB,2.8242E-03_JPRB,4.0342E-03_JPRB,5.3078E-03_JPRB,6.5325E-03_JPRB,&
&7.7349E-03_JPRB,8.8443E-03_JPRB,1.0074E-02_JPRB/)
KAO( :, 5, 1,13) = (/&
&3.4590E-03_JPRB,3.1378E-03_JPRB,3.6496E-03_JPRB,5.2809E-03_JPRB,6.8982E-03_JPRB,8.3727E-03_JPRB,&
&9.9335E-03_JPRB,1.1522E-02_JPRB,1.3097E-02_JPRB/)
KAO( :, 1, 2,13) = (/&
&1.1866E-03_JPRB,1.1005E-03_JPRB,1.0888E-03_JPRB,1.4004E-03_JPRB,1.7886E-03_JPRB,2.1767E-03_JPRB,&
&2.5570E-03_JPRB,2.9296E-03_JPRB,3.3601E-03_JPRB/)
KAO( :, 2, 2,13) = (/&
&1.4562E-03_JPRB,1.3635E-03_JPRB,1.4719E-03_JPRB,2.0169E-03_JPRB,2.6032E-03_JPRB,3.1819E-03_JPRB,&
&3.7488E-03_JPRB,4.3087E-03_JPRB,4.9192E-03_JPRB/)
KAO( :, 3, 2,13) = (/&
&1.8764E-03_JPRB,1.7361E-03_JPRB,1.9709E-03_JPRB,2.7595E-03_JPRB,3.5900E-03_JPRB,4.4194E-03_JPRB,&
&5.2979E-03_JPRB,6.0766E-03_JPRB,6.9371E-03_JPRB/)
KAO( :, 4, 2,13) = (/&
&2.4859E-03_JPRB,2.2733E-03_JPRB,2.5962E-03_JPRB,3.6933E-03_JPRB,4.8528E-03_JPRB,5.9853E-03_JPRB,&
&7.0801E-03_JPRB,8.2323E-03_JPRB,9.3999E-03_JPRB/)
KAO( :, 5, 2,13) = (/&
&3.2381E-03_JPRB,2.9580E-03_JPRB,3.3897E-03_JPRB,4.8434E-03_JPRB,6.3274E-03_JPRB,7.7660E-03_JPRB,&
&9.2016E-03_JPRB,1.0766E-02_JPRB,1.2382E-02_JPRB/)
KAO( :, 1, 3,13) = (/&
&1.0869E-03_JPRB,9.8978E-04_JPRB,9.6295E-04_JPRB,1.1603E-03_JPRB,1.4657E-03_JPRB,1.7785E-03_JPRB,&
&2.0850E-03_JPRB,2.3589E-03_JPRB,2.7295E-03_JPRB/)
KAO( :, 2, 3,13) = (/&
&1.2497E-03_JPRB,1.1652E-03_JPRB,1.2498E-03_JPRB,1.6617E-03_JPRB,2.1329E-03_JPRB,2.6212E-03_JPRB,&
&3.0709E-03_JPRB,3.5231E-03_JPRB,4.1120E-03_JPRB/)
KAO( :, 3, 3,13) = (/&
&1.5536E-03_JPRB,1.4627E-03_JPRB,1.6643E-03_JPRB,2.3266E-03_JPRB,3.0120E-03_JPRB,3.7022E-03_JPRB,&
&4.3567E-03_JPRB,5.0579E-03_JPRB,5.8139E-03_JPRB/)
KAO( :, 4, 3,13) = (/&
&2.0446E-03_JPRB,1.9153E-03_JPRB,2.2001E-03_JPRB,3.1214E-03_JPRB,4.0764E-03_JPRB,5.0190E-03_JPRB,&
&6.0061E-03_JPRB,6.9576E-03_JPRB,7.9493E-03_JPRB/)
KAO( :, 5, 3,13) = (/&
&2.6968E-03_JPRB,2.5178E-03_JPRB,2.9045E-03_JPRB,4.1585E-03_JPRB,5.4384E-03_JPRB,6.6732E-03_JPRB,&
&7.9956E-03_JPRB,9.1997E-03_JPRB,1.0739E-02_JPRB/)
KAO( :, 1, 4,13) = (/&
&1.0799E-03_JPRB,9.7556E-04_JPRB,8.9641E-04_JPRB,9.5375E-04_JPRB,1.1834E-03_JPRB,1.4206E-03_JPRB,&
&1.6456E-03_JPRB,1.8574E-03_JPRB,2.1783E-03_JPRB/)
KAO( :, 2, 4,13) = (/&
&1.1355E-03_JPRB,1.0374E-03_JPRB,1.0646E-03_JPRB,1.3628E-03_JPRB,1.7241E-03_JPRB,2.0900E-03_JPRB,&
&2.4594E-03_JPRB,2.8248E-03_JPRB,3.3135E-03_JPRB/)
KAO( :, 3, 4,13) = (/&
&1.2900E-03_JPRB,1.2405E-03_JPRB,1.3881E-03_JPRB,1.9129E-03_JPRB,2.4612E-03_JPRB,3.0202E-03_JPRB,&
&3.5514E-03_JPRB,4.1507E-03_JPRB,4.7512E-03_JPRB/)
KAO( :, 4, 4,13) = (/&
&1.6429E-03_JPRB,1.5804E-03_JPRB,1.8599E-03_JPRB,2.6280E-03_JPRB,3.3944E-03_JPRB,4.1721E-03_JPRB,&
&4.9786E-03_JPRB,5.7576E-03_JPRB,6.6384E-03_JPRB/)
KAO( :, 5, 4,13) = (/&
&2.1595E-03_JPRB,2.0705E-03_JPRB,2.4561E-03_JPRB,3.5243E-03_JPRB,4.6000E-03_JPRB,5.6864E-03_JPRB,&
&6.7238E-03_JPRB,7.7228E-03_JPRB,9.0563E-03_JPRB/)
KAO( :, 1, 5,13) = (/&
&1.1289E-03_JPRB,1.0122E-03_JPRB,9.1285E-04_JPRB,8.4241E-04_JPRB,9.2546E-04_JPRB,1.1068E-03_JPRB,&
&1.2785E-03_JPRB,1.4321E-03_JPRB,1.7133E-03_JPRB/)
KAO( :, 2, 5,13) = (/&
&1.1322E-03_JPRB,1.0283E-03_JPRB,9.7216E-04_JPRB,1.1030E-03_JPRB,1.3905E-03_JPRB,1.6648E-03_JPRB,&
&1.9659E-03_JPRB,2.2474E-03_JPRB,2.6825E-03_JPRB/)
KAO( :, 3, 5,13) = (/&
&1.1835E-03_JPRB,1.1059E-03_JPRB,1.1769E-03_JPRB,1.5659E-03_JPRB,1.9991E-03_JPRB,2.4574E-03_JPRB,&
&2.8892E-03_JPRB,3.3463E-03_JPRB,3.9939E-03_JPRB/)
KAO( :, 4, 5,13) = (/&
&1.3233E-03_JPRB,1.3123E-03_JPRB,1.5693E-03_JPRB,2.1884E-03_JPRB,2.8269E-03_JPRB,3.4574E-03_JPRB,&
&4.1167E-03_JPRB,4.7382E-03_JPRB,5.7495E-03_JPRB/)
KAO( :, 5, 5,13) = (/&
&1.7059E-03_JPRB,1.6691E-03_JPRB,2.0917E-03_JPRB,2.9965E-03_JPRB,3.8855E-03_JPRB,4.8207E-03_JPRB,&
&5.6559E-03_JPRB,6.5131E-03_JPRB,7.9790E-03_JPRB/)
KAO( :, 1, 6,13) = (/&
&1.2255E-03_JPRB,1.0879E-03_JPRB,9.6530E-04_JPRB,8.5617E-04_JPRB,7.6660E-04_JPRB,8.1723E-04_JPRB,&
&9.3534E-04_JPRB,1.0402E-03_JPRB,1.9062E-03_JPRB/)
KAO( :, 2, 6,13) = (/&
&1.1965E-03_JPRB,1.0719E-03_JPRB,9.9849E-04_JPRB,9.4121E-04_JPRB,1.0795E-03_JPRB,1.2813E-03_JPRB,&
&1.4997E-03_JPRB,1.7132E-03_JPRB,3.2547E-03_JPRB/)
KAO( :, 3, 6,13) = (/&
&1.1926E-03_JPRB,1.1043E-03_JPRB,1.0603E-03_JPRB,1.2688E-03_JPRB,1.5962E-03_JPRB,1.9526E-03_JPRB,&
&2.2912E-03_JPRB,2.6142E-03_JPRB,5.2095E-03_JPRB/)
KAO( :, 4, 6,13) = (/&
&1.2240E-03_JPRB,1.1777E-03_JPRB,1.3174E-03_JPRB,1.8087E-03_JPRB,2.3347E-03_JPRB,2.8437E-03_JPRB,&
&3.3597E-03_JPRB,3.8303E-03_JPRB,7.9481E-03_JPRB/)
KAO( :, 5, 6,13) = (/&
&1.3458E-03_JPRB,1.3554E-03_JPRB,1.7833E-03_JPRB,2.5412E-03_JPRB,3.2833E-03_JPRB,4.0389E-03_JPRB,&
&4.7385E-03_JPRB,5.4113E-03_JPRB,1.1516E-02_JPRB/)
KAO( :, 1, 7,13) = (/&
&1.3402E-03_JPRB,1.1742E-03_JPRB,1.0361E-03_JPRB,8.9910E-04_JPRB,7.6679E-04_JPRB,6.5368E-04_JPRB,&
&6.8075E-04_JPRB,4.6956E-04_JPRB,2.7722E-03_JPRB/)
KAO( :, 2, 7,13) = (/&
&1.3037E-03_JPRB,1.1622E-03_JPRB,1.0519E-03_JPRB,9.4323E-04_JPRB,8.7488E-04_JPRB,9.7401E-04_JPRB,&
&1.1211E-03_JPRB,1.2635E-03_JPRB,5.0027E-03_JPRB/)
KAO( :, 3, 7,13) = (/&
&1.2784E-03_JPRB,1.1532E-03_JPRB,1.0893E-03_JPRB,1.0694E-03_JPRB,1.2699E-03_JPRB,1.5175E-03_JPRB,&
&1.7746E-03_JPRB,2.0272E-03_JPRB,8.3555E-03_JPRB/)
KAO( :, 4, 7,13) = (/&
&1.2774E-03_JPRB,1.1979E-03_JPRB,1.1860E-03_JPRB,1.4785E-03_JPRB,1.8884E-03_JPRB,2.2924E-03_JPRB,&
&2.6858E-03_JPRB,3.0881E-03_JPRB,1.3125E-02_JPRB/)
KAO( :, 5, 7,13) = (/&
&1.2892E-03_JPRB,1.2565E-03_JPRB,1.5103E-03_JPRB,2.1215E-03_JPRB,2.7429E-03_JPRB,3.3579E-03_JPRB,&
&3.9536E-03_JPRB,4.4822E-03_JPRB,1.9541E-02_JPRB/)
KAO( :, 1, 8,13) = (/&
&1.4772E-03_JPRB,1.2923E-03_JPRB,1.1263E-03_JPRB,9.6270E-04_JPRB,8.0241E-04_JPRB,6.4872E-04_JPRB,&
&4.5811E-04_JPRB,2.1716E-07_JPRB,4.9636E-03_JPRB/)
KAO( :, 2, 8,13) = (/&
&1.4370E-03_JPRB,1.2729E-03_JPRB,1.1241E-03_JPRB,9.9655E-04_JPRB,8.5931E-04_JPRB,7.7387E-04_JPRB,&
&8.4353E-04_JPRB,8.7711E-04_JPRB,9.4321E-03_JPRB/)
KAO( :, 3, 8,13) = (/&
&1.4034E-03_JPRB,1.2585E-03_JPRB,1.1607E-03_JPRB,1.0510E-03_JPRB,1.0272E-03_JPRB,1.1868E-03_JPRB,&
&1.3711E-03_JPRB,1.5476E-03_JPRB,1.6446E-02_JPRB/)
KAO( :, 4, 8,13) = (/&
&1.3792E-03_JPRB,1.2775E-03_JPRB,1.2067E-03_JPRB,1.2391E-03_JPRB,1.5156E-03_JPRB,1.8221E-03_JPRB,&
&2.1295E-03_JPRB,2.4428E-03_JPRB,2.6678E-02_JPRB/)
KAO( :, 5, 8,13) = (/&
&1.3692E-03_JPRB,1.3040E-03_JPRB,1.3510E-03_JPRB,1.7655E-03_JPRB,2.2564E-03_JPRB,2.7486E-03_JPRB,&
&3.2245E-03_JPRB,3.6702E-03_JPRB,4.0890E-02_JPRB/)
KAO( :, 1, 9,13) = (/&
&1.6318E-03_JPRB,1.4281E-03_JPRB,1.2324E-03_JPRB,1.0452E-03_JPRB,8.5200E-04_JPRB,6.6304E-04_JPRB,&
&1.2309E-05_JPRB,1.5379E-07_JPRB,1.6381E-02_JPRB/)
KAO( :, 2, 9,13) = (/&
&1.5875E-03_JPRB,1.3936E-03_JPRB,1.2247E-03_JPRB,1.0563E-03_JPRB,9.0066E-04_JPRB,7.3338E-04_JPRB,&
&6.0228E-04_JPRB,1.0871E-04_JPRB,3.2932E-02_JPRB/)
KAO( :, 3, 9,13) = (/&
&1.5482E-03_JPRB,1.3786E-03_JPRB,1.2438E-03_JPRB,1.1136E-03_JPRB,9.6991E-04_JPRB,9.4000E-04_JPRB,&
&1.0591E-03_JPRB,1.1303E-03_JPRB,6.0073E-02_JPRB/)
KAO( :, 4, 9,13) = (/&
&1.5167E-03_JPRB,1.3746E-03_JPRB,1.2857E-03_JPRB,1.1928E-03_JPRB,1.2413E-03_JPRB,1.4696E-03_JPRB,&
&1.6946E-03_JPRB,1.9089E-03_JPRB,1.0132E-01_JPRB/)
KAO( :, 5, 9,13) = (/&
&1.4899E-03_JPRB,1.4080E-03_JPRB,1.3636E-03_JPRB,1.4825E-03_JPRB,1.8628E-03_JPRB,2.2533E-03_JPRB,&
&2.6127E-03_JPRB,2.9482E-03_JPRB,1.5979E-01_JPRB/)
KAO( :, 1,10,13) = (/&
&1.8020E-03_JPRB,1.5774E-03_JPRB,1.3520E-03_JPRB,1.1382E-03_JPRB,9.2570E-04_JPRB,6.9265E-04_JPRB,&
&1.3740E-07_JPRB,1.3289E-07_JPRB,6.3524E-02_JPRB/)
KAO( :, 2,10,13) = (/&
&1.7549E-03_JPRB,1.5358E-03_JPRB,1.3388E-03_JPRB,1.1389E-03_JPRB,9.5013E-04_JPRB,7.6352E-04_JPRB,&
&2.9725E-04_JPRB,1.5747E-07_JPRB,1.3432E-01_JPRB/)
KAO( :, 3,10,13) = (/&
&1.7152E-03_JPRB,1.5184E-03_JPRB,1.3412E-03_JPRB,1.1838E-03_JPRB,1.0217E-03_JPRB,8.6702E-04_JPRB,&
&8.3836E-04_JPRB,6.8845E-04_JPRB,2.5555E-01_JPRB/)
KAO( :, 4,10,13) = (/&
&1.6812E-03_JPRB,1.5047E-03_JPRB,1.3857E-03_JPRB,1.2506E-03_JPRB,1.1577E-03_JPRB,1.2249E-03_JPRB,&
&1.4008E-03_JPRB,1.5238E-03_JPRB,4.4499E-01_JPRB/)
KAO( :, 5,10,13) = (/&
&1.6497E-03_JPRB,1.5369E-03_JPRB,1.4416E-03_JPRB,1.4073E-03_JPRB,1.5858E-03_JPRB,1.9083E-03_JPRB,&
&2.1930E-03_JPRB,2.4338E-03_JPRB,7.2126E-01_JPRB/)
KAO( :, 1,11,13) = (/&
&1.9883E-03_JPRB,1.7404E-03_JPRB,1.4929E-03_JPRB,1.2571E-03_JPRB,1.0189E-03_JPRB,7.6574E-04_JPRB,&
&1.2245E-07_JPRB,1.1939E-07_JPRB,1.2338E-01_JPRB/)
KAO( :, 2,11,13) = (/&
&1.9390E-03_JPRB,1.6974E-03_JPRB,1.4774E-03_JPRB,1.2577E-03_JPRB,1.0438E-03_JPRB,8.3574E-04_JPRB,&
&2.2761E-04_JPRB,1.3870E-07_JPRB,2.6041E-01_JPRB/)
KAO( :, 3,11,13) = (/&
&1.9012E-03_JPRB,1.6811E-03_JPRB,1.4837E-03_JPRB,1.3022E-03_JPRB,1.1118E-03_JPRB,9.5270E-04_JPRB,&
&8.5092E-04_JPRB,5.4921E-04_JPRB,4.9292E-01_JPRB/)
KAO( :, 4,11,13) = (/&
&1.8676E-03_JPRB,1.6686E-03_JPRB,1.5247E-03_JPRB,1.3663E-03_JPRB,1.2686E-03_JPRB,1.2743E-03_JPRB,&
&1.4286E-03_JPRB,1.5277E-03_JPRB,8.5618E-01_JPRB/)
KAO( :, 5,11,13) = (/&
&1.8327E-03_JPRB,1.6976E-03_JPRB,1.5788E-03_JPRB,1.5380E-03_JPRB,1.6440E-03_JPRB,1.9550E-03_JPRB,&
&2.2595E-03_JPRB,2.4555E-03_JPRB,1.3826E+00_JPRB/)
KAO( :, 1,12,13) = (/&
&2.2187E-03_JPRB,1.9406E-03_JPRB,1.6640E-03_JPRB,1.4003E-03_JPRB,1.1350E-03_JPRB,8.4971E-04_JPRB,&
&1.4328E-05_JPRB,1.0909E-07_JPRB,1.7650E-01_JPRB/)
KAO( :, 2,12,13) = (/&
&2.1703E-03_JPRB,1.8998E-03_JPRB,1.6482E-03_JPRB,1.4040E-03_JPRB,1.1602E-03_JPRB,9.1881E-04_JPRB,&
&5.8608E-04_JPRB,1.2488E-07_JPRB,3.7061E-01_JPRB/)
KAO( :, 3,12,13) = (/&
&2.1329E-03_JPRB,1.8834E-03_JPRB,1.6576E-03_JPRB,1.4426E-03_JPRB,1.2188E-03_JPRB,1.0435E-03_JPRB,&
&9.0113E-04_JPRB,6.0140E-04_JPRB,6.9805E-01_JPRB/)
KAO( :, 4,12,13) = (/&
&2.0986E-03_JPRB,1.8697E-03_JPRB,1.6880E-03_JPRB,1.4960E-03_JPRB,1.3858E-03_JPRB,1.3370E-03_JPRB,&
&1.4776E-03_JPRB,1.5577E-03_JPRB,1.2104E+00_JPRB/)
KAO( :, 5,12,13) = (/&
&2.0637E-03_JPRB,1.8889E-03_JPRB,1.7335E-03_JPRB,1.6736E-03_JPRB,1.7272E-03_JPRB,2.0047E-03_JPRB,&
&2.3234E-03_JPRB,2.5266E-03_JPRB,1.9488E+00_JPRB/)
KAO( :, 1,13,13) = (/&
&2.5214E-03_JPRB,2.2065E-03_JPRB,1.8921E-03_JPRB,1.5892E-03_JPRB,1.2848E-03_JPRB,9.6635E-04_JPRB,&
&1.4011E-05_JPRB,9.2652E-08_JPRB,1.9891E-01_JPRB/)
KAO( :, 2,13,13) = (/&
&2.4696E-03_JPRB,2.1633E-03_JPRB,1.8707E-03_JPRB,1.5871E-03_JPRB,1.3039E-03_JPRB,1.0191E-03_JPRB,&
&7.2224E-04_JPRB,1.1771E-07_JPRB,4.1557E-01_JPRB/)
KAO( :, 3,13,13) = (/&
&2.4301E-03_JPRB,2.1428E-03_JPRB,1.8727E-03_JPRB,1.6140E-03_JPRB,1.3467E-03_JPRB,1.1319E-03_JPRB,&
&9.6477E-04_JPRB,7.6672E-04_JPRB,7.8045E-01_JPRB/)
KAO( :, 4,13,13) = (/&
&2.3936E-03_JPRB,2.1221E-03_JPRB,1.8926E-03_JPRB,1.6520E-03_JPRB,1.5047E-03_JPRB,1.4110E-03_JPRB,&
&1.5144E-03_JPRB,1.6138E-03_JPRB,1.3452E+00_JPRB/)
KAO( :, 5,13,13) = (/&
&2.3541E-03_JPRB,2.1248E-03_JPRB,1.9211E-03_JPRB,1.8214E-03_JPRB,1.8209E-03_JPRB,2.0454E-03_JPRB,&
&2.3767E-03_JPRB,2.6027E-03_JPRB,2.1609E+00_JPRB/)
KAO( :, 1, 1,14) = (/&
&1.4077E-03_JPRB,1.3543E-03_JPRB,2.0015E-03_JPRB,2.9052E-03_JPRB,3.8062E-03_JPRB,4.7033E-03_JPRB,&
&5.5027E-03_JPRB,6.3534E-03_JPRB,7.2447E-03_JPRB/)
KAO( :, 2, 1,14) = (/&
&1.7458E-03_JPRB,1.7470E-03_JPRB,2.6822E-03_JPRB,3.8935E-03_JPRB,5.1049E-03_JPRB,6.3777E-03_JPRB,&
&7.5886E-03_JPRB,8.9435E-03_JPRB,1.0377E-02_JPRB/)
KAO( :, 3, 1,14) = (/&
&2.2077E-03_JPRB,2.2614E-03_JPRB,3.6964E-03_JPRB,5.3773E-03_JPRB,7.0539E-03_JPRB,8.7220E-03_JPRB,&
&1.0257E-02_JPRB,1.2410E-02_JPRB,1.4154E-02_JPRB/)
KAO( :, 4, 1,14) = (/&
&2.8109E-03_JPRB,2.9075E-03_JPRB,4.9134E-03_JPRB,7.1686E-03_JPRB,9.5162E-03_JPRB,1.1788E-02_JPRB,&
&1.3767E-02_JPRB,1.5840E-02_JPRB,1.8057E-02_JPRB/)
KAO( :, 5, 1,14) = (/&
&3.6086E-03_JPRB,3.7240E-03_JPRB,6.4216E-03_JPRB,9.3840E-03_JPRB,1.2343E-02_JPRB,1.5071E-02_JPRB,&
&1.7936E-02_JPRB,2.0469E-02_JPRB,2.3091E-02_JPRB/)
KAO( :, 1, 2,14) = (/&
&1.3294E-03_JPRB,1.2597E-03_JPRB,1.6974E-03_JPRB,2.4370E-03_JPRB,3.1928E-03_JPRB,3.9456E-03_JPRB,&
&4.9620E-03_JPRB,5.6067E-03_JPRB,6.6116E-03_JPRB/)
KAO( :, 2, 2,14) = (/&
&1.6318E-03_JPRB,1.6184E-03_JPRB,2.4692E-03_JPRB,3.6012E-03_JPRB,4.7302E-03_JPRB,5.7659E-03_JPRB,&
&6.8491E-03_JPRB,8.1205E-03_JPRB,8.9947E-03_JPRB/)
KAO( :, 3, 2,14) = (/&
&2.0588E-03_JPRB,2.1063E-03_JPRB,3.4156E-03_JPRB,4.9986E-03_JPRB,6.5782E-03_JPRB,8.1429E-03_JPRB,&
&9.7017E-03_JPRB,1.0879E-02_JPRB,1.2701E-02_JPRB/)
KAO( :, 4, 2,14) = (/&
&2.6403E-03_JPRB,2.6941E-03_JPRB,4.6292E-03_JPRB,6.7785E-03_JPRB,8.9613E-03_JPRB,1.1099E-02_JPRB,&
&1.3055E-02_JPRB,1.4808E-02_JPRB,1.7360E-02_JPRB/)
KAO( :, 5, 2,14) = (/&
&3.4097E-03_JPRB,3.4754E-03_JPRB,6.1509E-03_JPRB,9.0470E-03_JPRB,1.1928E-02_JPRB,1.4499E-02_JPRB,&
&1.7101E-02_JPRB,1.9409E-02_JPRB,2.2968E-02_JPRB/)
KAO( :, 1, 3,14) = (/&
&1.2102E-03_JPRB,1.1138E-03_JPRB,1.3857E-03_JPRB,2.0244E-03_JPRB,2.6529E-03_JPRB,3.2119E-03_JPRB,&
&4.0399E-03_JPRB,4.4246E-03_JPRB,5.1581E-03_JPRB/)
KAO( :, 2, 3,14) = (/&
&1.4090E-03_JPRB,1.3841E-03_JPRB,2.0941E-03_JPRB,3.0584E-03_JPRB,4.0208E-03_JPRB,4.9852E-03_JPRB,&
&5.9175E-03_JPRB,6.7182E-03_JPRB,7.9412E-03_JPRB/)
KAO( :, 3, 3,14) = (/&
&1.7427E-03_JPRB,1.7765E-03_JPRB,2.9090E-03_JPRB,4.4193E-03_JPRB,5.8208E-03_JPRB,7.2086E-03_JPRB,&
&8.4753E-03_JPRB,9.3954E-03_JPRB,1.1366E-02_JPRB/)
KAO( :, 4, 3,14) = (/&
&2.2157E-03_JPRB,2.2613E-03_JPRB,3.9916E-03_JPRB,5.8630E-03_JPRB,8.0161E-03_JPRB,9.9398E-03_JPRB,&
&1.1828E-02_JPRB,1.3094E-02_JPRB,1.5315E-02_JPRB/)
KAO( :, 5, 3,14) = (/&
&2.8879E-03_JPRB,2.9466E-03_JPRB,5.4167E-03_JPRB,7.9578E-03_JPRB,1.0502E-02_JPRB,1.2821E-02_JPRB,&
&1.5472E-02_JPRB,1.7483E-02_JPRB,2.0768E-02_JPRB/)
KAO( :, 1, 4,14) = (/&
&1.1727E-03_JPRB,1.0568E-03_JPRB,1.1437E-03_JPRB,1.6336E-03_JPRB,2.1314E-03_JPRB,2.5848E-03_JPRB,&
&3.0242E-03_JPRB,3.4499E-03_JPRB,4.1004E-03_JPRB/)
KAO( :, 2, 4,14) = (/&
&1.2525E-03_JPRB,1.1704E-03_JPRB,1.6924E-03_JPRB,2.4669E-03_JPRB,3.2745E-03_JPRB,3.9503E-03_JPRB,&
&4.8080E-03_JPRB,5.4438E-03_JPRB,6.5186E-03_JPRB/)
KAO( :, 3, 4,14) = (/&
&1.4517E-03_JPRB,1.4687E-03_JPRB,2.4478E-03_JPRB,3.6499E-03_JPRB,4.8038E-03_JPRB,6.0561E-03_JPRB,&
&7.1091E-03_JPRB,8.0698E-03_JPRB,9.5998E-03_JPRB/)
KAO( :, 4, 4,14) = (/&
&1.8147E-03_JPRB,1.9649E-03_JPRB,3.5509E-03_JPRB,5.2270E-03_JPRB,6.8077E-03_JPRB,8.4354E-03_JPRB,&
&1.0206E-02_JPRB,1.1463E-02_JPRB,1.3354E-02_JPRB/)
KAO( :, 5, 4,14) = (/&
&2.3595E-03_JPRB,2.5550E-03_JPRB,4.7325E-03_JPRB,6.9980E-03_JPRB,9.2811E-03_JPRB,1.1690E-02_JPRB,&
&1.3662E-02_JPRB,1.5386E-02_JPRB,1.8463E-02_JPRB/)
KAO( :, 1, 5,14) = (/&
&1.2458E-03_JPRB,1.1157E-03_JPRB,1.0306E-03_JPRB,1.3033E-03_JPRB,1.6734E-03_JPRB,2.0057E-03_JPRB,&
&2.3259E-03_JPRB,2.6388E-03_JPRB,3.1846E-03_JPRB/)
KAO( :, 2, 5,14) = (/&
&1.2388E-03_JPRB,1.1282E-03_JPRB,1.3991E-03_JPRB,2.0036E-03_JPRB,2.6425E-03_JPRB,3.1687E-03_JPRB,&
&3.8762E-03_JPRB,4.3488E-03_JPRB,5.2301E-03_JPRB/)
KAO( :, 3, 5,14) = (/&
&1.2913E-03_JPRB,1.2589E-03_JPRB,2.0814E-03_JPRB,3.0197E-03_JPRB,3.9667E-03_JPRB,4.9958E-03_JPRB,&
&5.9133E-03_JPRB,6.6574E-03_JPRB,8.0153E-03_JPRB/)
KAO( :, 4, 5,14) = (/&
&1.4963E-03_JPRB,1.6907E-03_JPRB,3.0309E-03_JPRB,4.4615E-03_JPRB,5.8606E-03_JPRB,7.1898E-03_JPRB,&
&8.6483E-03_JPRB,9.7418E-03_JPRB,1.1669E-02_JPRB/)
KAO( :, 5, 5,14) = (/&
&1.8886E-03_JPRB,2.2503E-03_JPRB,4.1688E-03_JPRB,6.1333E-03_JPRB,8.1604E-03_JPRB,1.0200E-02_JPRB,&
&1.2063E-02_JPRB,1.3620E-02_JPRB,1.6367E-02_JPRB/)
KAO( :, 1, 6,14) = (/&
&1.3667E-03_JPRB,1.2087E-03_JPRB,1.0726E-03_JPRB,1.0607E-03_JPRB,1.2821E-03_JPRB,1.5260E-03_JPRB,&
&1.8008E-03_JPRB,1.9547E-03_JPRB,2.5327E-03_JPRB/)
KAO( :, 2, 6,14) = (/&
&1.3345E-03_JPRB,1.2078E-03_JPRB,1.2022E-03_JPRB,1.6068E-03_JPRB,2.0999E-03_JPRB,2.5469E-03_JPRB,&
&3.0216E-03_JPRB,3.3465E-03_JPRB,4.2698E-03_JPRB/)
KAO( :, 3, 6,14) = (/&
&1.3246E-03_JPRB,1.2185E-03_JPRB,1.7375E-03_JPRB,2.5142E-03_JPRB,3.2318E-03_JPRB,4.0369E-03_JPRB,&
&4.7556E-03_JPRB,5.3249E-03_JPRB,6.8388E-03_JPRB/)
KAO( :, 4, 6,14) = (/&
&1.3486E-03_JPRB,1.4645E-03_JPRB,2.5454E-03_JPRB,3.7331E-03_JPRB,4.8424E-03_JPRB,6.0309E-03_JPRB,&
&7.1539E-03_JPRB,8.1418E-03_JPRB,1.0356E-02_JPRB/)
KAO( :, 5, 6,14) = (/&
&1.5159E-03_JPRB,1.9586E-03_JPRB,3.6257E-03_JPRB,5.3066E-03_JPRB,6.9540E-03_JPRB,8.6820E-03_JPRB,&
&1.0231E-02_JPRB,1.1546E-02_JPRB,1.5077E-02_JPRB/)
KAO( :, 1, 7,14) = (/&
&1.5156E-03_JPRB,1.3262E-03_JPRB,1.1714E-03_JPRB,1.0190E-03_JPRB,1.0169E-03_JPRB,1.1666E-03_JPRB,&
&1.3423E-03_JPRB,1.3981E-03_JPRB,3.1910E-03_JPRB/)
KAO( :, 2, 7,14) = (/&
&1.4765E-03_JPRB,1.3249E-03_JPRB,1.1925E-03_JPRB,1.3147E-03_JPRB,1.6557E-03_JPRB,1.9990E-03_JPRB,&
&2.2925E-03_JPRB,2.5530E-03_JPRB,5.7452E-03_JPRB/)
KAO( :, 3, 7,14) = (/&
&1.4370E-03_JPRB,1.3162E-03_JPRB,1.4936E-03_JPRB,2.0652E-03_JPRB,2.6453E-03_JPRB,3.2054E-03_JPRB,&
&3.7731E-03_JPRB,4.2042E-03_JPRB,9.6110E-03_JPRB/)
KAO( :, 4, 7,14) = (/&
&1.4149E-03_JPRB,1.3977E-03_JPRB,2.1475E-03_JPRB,3.1203E-03_JPRB,4.0198E-03_JPRB,4.9787E-03_JPRB,&
&5.7945E-03_JPRB,6.6068E-03_JPRB,1.5108E-02_JPRB/)
KAO( :, 5, 7,14) = (/&
&1.4374E-03_JPRB,1.7222E-03_JPRB,3.0905E-03_JPRB,4.5057E-03_JPRB,5.8428E-03_JPRB,7.2095E-03_JPRB,&
&8.5374E-03_JPRB,9.6315E-03_JPRB,2.2589E-02_JPRB/)
KAO( :, 1, 8,14) = (/&
&1.6998E-03_JPRB,1.4847E-03_JPRB,1.3004E-03_JPRB,1.1133E-03_JPRB,9.4349E-04_JPRB,9.0420E-04_JPRB,&
&1.0045E-03_JPRB,4.3482E-04_JPRB,5.8016E-03_JPRB/)
KAO( :, 2, 8,14) = (/&
&1.6532E-03_JPRB,1.4674E-03_JPRB,1.3041E-03_JPRB,1.2025E-03_JPRB,1.3140E-03_JPRB,1.5672E-03_JPRB,&
&1.7686E-03_JPRB,1.9237E-03_JPRB,1.1052E-02_JPRB/)
KAO( :, 3, 8,14) = (/&
&1.6074E-03_JPRB,1.4616E-03_JPRB,1.4143E-03_JPRB,1.6802E-03_JPRB,2.1261E-03_JPRB,2.5596E-03_JPRB,&
&3.0033E-03_JPRB,3.3007E-03_JPRB,1.9324E-02_JPRB/)
KAO( :, 4, 8,14) = (/&
&1.5686E-03_JPRB,1.4776E-03_JPRB,1.8215E-03_JPRB,2.5548E-03_JPRB,3.2874E-03_JPRB,4.0303E-03_JPRB,&
&4.7235E-03_JPRB,5.2596E-03_JPRB,3.1553E-02_JPRB/)
KAO( :, 5, 8,14) = (/&
&1.5375E-03_JPRB,1.6349E-03_JPRB,2.6125E-03_JPRB,3.7580E-03_JPRB,4.8839E-03_JPRB,6.0119E-03_JPRB,&
&7.1085E-03_JPRB,8.0648E-03_JPRB,4.8625E-02_JPRB/)
KAO( :, 1, 9,14) = (/&
&1.9224E-03_JPRB,1.6818E-03_JPRB,1.4431E-03_JPRB,1.2356E-03_JPRB,1.0226E-03_JPRB,8.1041E-04_JPRB,&
&6.6192E-04_JPRB,1.6289E-07_JPRB,1.9855E-02_JPRB/)
KAO( :, 2, 9,14) = (/&
&1.8714E-03_JPRB,1.6372E-03_JPRB,1.4546E-03_JPRB,1.2624E-03_JPRB,1.1376E-03_JPRB,1.2029E-03_JPRB,&
&1.3478E-03_JPRB,1.4009E-03_JPRB,4.0030E-02_JPRB/)
KAO( :, 3, 9,14) = (/&
&1.8227E-03_JPRB,1.6409E-03_JPRB,1.4856E-03_JPRB,1.4717E-03_JPRB,1.6810E-03_JPRB,2.0286E-03_JPRB,&
&2.3381E-03_JPRB,2.5517E-03_JPRB,7.3381E-02_JPRB/)
KAO( :, 4, 9,14) = (/&
&1.7776E-03_JPRB,1.6302E-03_JPRB,1.6842E-03_JPRB,2.0805E-03_JPRB,2.6540E-03_JPRB,3.2313E-03_JPRB,&
&3.7806E-03_JPRB,4.1994E-03_JPRB,1.2455E-01_JPRB/)
KAO( :, 5, 9,14) = (/&
&1.7367E-03_JPRB,1.7061E-03_JPRB,2.1848E-03_JPRB,3.1013E-03_JPRB,4.0216E-03_JPRB,4.9873E-03_JPRB,&
&5.8671E-03_JPRB,6.6087E-03_JPRB,1.9836E-01_JPRB/)
KAO( :, 1,10,14) = (/&
&2.1700E-03_JPRB,1.8991E-03_JPRB,1.6269E-03_JPRB,1.3797E-03_JPRB,1.1299E-03_JPRB,8.7387E-04_JPRB,&
&1.3980E-07_JPRB,1.2659E-07_JPRB,7.9784E-02_JPRB/)
KAO( :, 2,10,14) = (/&
&2.1212E-03_JPRB,1.8542E-03_JPRB,1.6327E-03_JPRB,1.4005E-03_JPRB,1.1807E-03_JPRB,1.0294E-03_JPRB,&
&1.0221E-03_JPRB,1.9929E-04_JPRB,1.6978E-01_JPRB/)
KAO( :, 3,10,14) = (/&
&2.0702E-03_JPRB,1.8475E-03_JPRB,1.6421E-03_JPRB,1.4813E-03_JPRB,1.4506E-03_JPRB,1.6271E-03_JPRB,&
&1.8528E-03_JPRB,1.9874E-03_JPRB,3.2534E-01_JPRB/)
KAO( :, 4,10,14) = (/&
&2.0197E-03_JPRB,1.8363E-03_JPRB,1.7391E-03_JPRB,1.8390E-03_JPRB,2.2028E-03_JPRB,2.6538E-03_JPRB,&
&3.1240E-03_JPRB,3.3958E-03_JPRB,5.7201E-01_JPRB/)
KAO( :, 5,10,14) = (/&
&1.9722E-03_JPRB,1.8724E-03_JPRB,2.0258E-03_JPRB,2.6203E-03_JPRB,3.3709E-03_JPRB,4.1714E-03_JPRB,&
&4.8976E-03_JPRB,5.4947E-03_JPRB,9.3618E-01_JPRB/)
KAO( :, 1,11,14) = (/&
&2.4346E-03_JPRB,2.1262E-03_JPRB,1.8242E-03_JPRB,1.5461E-03_JPRB,1.2663E-03_JPRB,9.7971E-04_JPRB,&
&1.2672E-07_JPRB,1.1257E-07_JPRB,1.6191E-01_JPRB/)
KAO( :, 2,11,14) = (/&
&2.3800E-03_JPRB,2.0803E-03_JPRB,1.8321E-03_JPRB,1.5714E-03_JPRB,1.3247E-03_JPRB,1.1173E-03_JPRB,&
&1.0133E-03_JPRB,1.0538E-04_JPRB,3.4424E-01_JPRB/)
KAO( :, 3,11,14) = (/&
&2.3211E-03_JPRB,2.0734E-03_JPRB,1.8393E-03_JPRB,1.6589E-03_JPRB,1.5627E-03_JPRB,1.6631E-03_JPRB,&
&1.8852E-03_JPRB,2.0216E-03_JPRB,6.6076E-01_JPRB/)
KAO( :, 4,11,14) = (/&
&2.2623E-03_JPRB,2.0579E-03_JPRB,1.9437E-03_JPRB,1.9604E-03_JPRB,2.2434E-03_JPRB,2.7165E-03_JPRB,&
&3.1823E-03_JPRB,3.4732E-03_JPRB,1.1622E+00_JPRB/)
KAO( :, 5,11,14) = (/&
&2.2095E-03_JPRB,2.1020E-03_JPRB,2.1745E-03_JPRB,2.6686E-03_JPRB,3.4370E-03_JPRB,4.2001E-03_JPRB,&
&4.9598E-03_JPRB,5.6011E-03_JPRB,1.8980E+00_JPRB/)
KAO( :, 1,12,14) = (/&
&2.7322E-03_JPRB,2.3881E-03_JPRB,2.0484E-03_JPRB,1.7387E-03_JPRB,1.4199E-03_JPRB,1.1012E-03_JPRB,&
&1.1269E-07_JPRB,1.0126E-07_JPRB,2.4431E-01_JPRB/)
KAO( :, 2,12,14) = (/&
&2.6690E-03_JPRB,2.3367E-03_JPRB,2.0556E-03_JPRB,1.7563E-03_JPRB,1.4836E-03_JPRB,1.2255E-03_JPRB,&
&1.0602E-03_JPRB,2.2342E-04_JPRB,5.2005E-01_JPRB/)
KAO( :, 3,12,14) = (/&
&2.6024E-03_JPRB,2.3216E-03_JPRB,2.0574E-03_JPRB,1.8575E-03_JPRB,1.6967E-03_JPRB,1.7241E-03_JPRB,&
&1.9458E-03_JPRB,2.1132E-03_JPRB,9.9525E-01_JPRB/)
KAO( :, 4,12,14) = (/&
&2.5362E-03_JPRB,2.2963E-03_JPRB,2.1666E-03_JPRB,2.1029E-03_JPRB,2.2976E-03_JPRB,2.7702E-03_JPRB,&
&3.2192E-03_JPRB,3.5953E-03_JPRB,1.7434E+00_JPRB/)
KAO( :, 5,12,14) = (/&
&2.4736E-03_JPRB,2.3442E-03_JPRB,2.3511E-03_JPRB,2.7323E-03_JPRB,3.5045E-03_JPRB,4.2744E-03_JPRB,&
&5.0574E-03_JPRB,5.7337E-03_JPRB,2.8511E+00_JPRB/)
KAO( :, 1,13,14) = (/&
&3.0694E-03_JPRB,2.6858E-03_JPRB,2.3020E-03_JPRB,1.9523E-03_JPRB,1.5893E-03_JPRB,1.2280E-03_JPRB,&
&9.6824E-05_JPRB,9.3571E-08_JPRB,2.9420E-01_JPRB/)
KAO( :, 2,13,14) = (/&
&2.9959E-03_JPRB,2.6225E-03_JPRB,2.2984E-03_JPRB,1.9588E-03_JPRB,1.6492E-03_JPRB,1.3537E-03_JPRB,&
&1.1186E-03_JPRB,4.7180E-04_JPRB,6.2570E-01_JPRB/)
KAO( :, 3,13,14) = (/&
&2.9125E-03_JPRB,2.5931E-03_JPRB,2.2966E-03_JPRB,2.0585E-03_JPRB,1.8442E-03_JPRB,1.7986E-03_JPRB,&
&1.9858E-03_JPRB,2.1644E-03_JPRB,1.1929E+00_JPRB/)
KAO( :, 4,13,14) = (/&
&2.8338E-03_JPRB,2.5576E-03_JPRB,2.3960E-03_JPRB,2.2668E-03_JPRB,2.3808E-03_JPRB,2.8162E-03_JPRB,&
&3.2861E-03_JPRB,3.6781E-03_JPRB,2.0900E+00_JPRB/)
KAO( :, 5,13,14) = (/&
&2.7615E-03_JPRB,2.6036E-03_JPRB,2.5577E-03_JPRB,2.8390E-03_JPRB,3.5800E-03_JPRB,4.3621E-03_JPRB,&
&5.1422E-03_JPRB,5.8469E-03_JPRB,3.4082E+00_JPRB/)
KAO( :, 1, 1,15) = (/&
&1.5335E-03_JPRB,1.9324E-03_JPRB,3.7679E-03_JPRB,5.5453E-03_JPRB,7.3003E-03_JPRB,9.0183E-03_JPRB,&
&1.0616E-02_JPRB,1.1802E-02_JPRB,1.3402E-02_JPRB/)
KAO( :, 2, 1,15) = (/&
&1.8833E-03_JPRB,2.7655E-03_JPRB,5.2889E-03_JPRB,7.8002E-03_JPRB,1.0284E-02_JPRB,1.2663E-02_JPRB,&
&1.4949E-02_JPRB,1.7186E-02_JPRB,1.9451E-02_JPRB/)
KAO( :, 3, 1,15) = (/&
&2.3483E-03_JPRB,3.8414E-03_JPRB,7.3773E-03_JPRB,1.0888E-02_JPRB,1.4361E-02_JPRB,1.7765E-02_JPRB,&
&2.0815E-02_JPRB,2.3917E-02_JPRB,2.7184E-02_JPRB/)
KAO( :, 4, 1,15) = (/&
&2.9416E-03_JPRB,5.1566E-03_JPRB,9.9228E-03_JPRB,1.4661E-02_JPRB,1.9210E-02_JPRB,2.3760E-02_JPRB,&
&2.8113E-02_JPRB,3.1154E-02_JPRB,3.5404E-02_JPRB/)
KAO( :, 5, 1,15) = (/&
&3.6966E-03_JPRB,6.6653E-03_JPRB,1.2941E-02_JPRB,1.9171E-02_JPRB,2.5316E-02_JPRB,3.1127E-02_JPRB,&
&3.6787E-02_JPRB,4.1016E-02_JPRB,4.6262E-02_JPRB/)
KAO( :, 1, 2,15) = (/&
&1.4383E-03_JPRB,1.8910E-03_JPRB,3.6349E-03_JPRB,5.3031E-03_JPRB,6.9932E-03_JPRB,8.6450E-03_JPRB,&
&1.0512E-02_JPRB,1.1619E-02_JPRB,1.3810E-02_JPRB/)
KAO( :, 2, 2,15) = (/&
&1.7711E-03_JPRB,2.7662E-03_JPRB,5.3277E-03_JPRB,7.8716E-03_JPRB,1.0388E-02_JPRB,1.2798E-02_JPRB,&
&1.4898E-02_JPRB,1.7232E-02_JPRB,1.9744E-02_JPRB/)
KAO( :, 3, 2,15) = (/&
&2.2091E-03_JPRB,3.9249E-03_JPRB,7.5049E-03_JPRB,1.1104E-02_JPRB,1.4661E-02_JPRB,1.8139E-02_JPRB,&
&2.1328E-02_JPRB,2.3602E-02_JPRB,2.7985E-02_JPRB/)
KAO( :, 4, 2,15) = (/&
&2.7705E-03_JPRB,5.2948E-03_JPRB,1.0279E-02_JPRB,1.5231E-02_JPRB,2.0000E-02_JPRB,2.4763E-02_JPRB,&
&2.9040E-02_JPRB,3.2255E-02_JPRB,3.8158E-02_JPRB/)
KAO( :, 5, 2,15) = (/&
&3.5089E-03_JPRB,6.9573E-03_JPRB,1.3524E-02_JPRB,2.0020E-02_JPRB,2.6474E-02_JPRB,3.2706E-02_JPRB,&
&3.8152E-02_JPRB,4.2439E-02_JPRB,5.0508E-02_JPRB/)
KAO( :, 1, 3,15) = (/&
&1.2705E-03_JPRB,1.6880E-03_JPRB,3.2165E-03_JPRB,4.7906E-03_JPRB,6.3186E-03_JPRB,7.6460E-03_JPRB,&
&9.3643E-03_JPRB,1.0229E-02_JPRB,1.2458E-02_JPRB/)
KAO( :, 2, 3,15) = (/&
&1.5436E-03_JPRB,2.5438E-03_JPRB,4.9323E-03_JPRB,7.3010E-03_JPRB,9.6387E-03_JPRB,1.1841E-02_JPRB,&
&1.4163E-02_JPRB,1.5548E-02_JPRB,1.9155E-02_JPRB/)
KAO( :, 3, 3,15) = (/&
&1.9176E-03_JPRB,3.6434E-03_JPRB,6.9853E-03_JPRB,1.0590E-02_JPRB,1.3995E-02_JPRB,1.7311E-02_JPRB,&
&2.0232E-02_JPRB,2.1858E-02_JPRB,2.7487E-02_JPRB/)
KAO( :, 4, 3,15) = (/&
&2.3869E-03_JPRB,4.9269E-03_JPRB,9.6201E-03_JPRB,1.4277E-02_JPRB,1.9500E-02_JPRB,2.4127E-02_JPRB,&
&2.8236E-02_JPRB,3.0501E-02_JPRB,3.7416E-02_JPRB/)
KAO( :, 5, 3,15) = (/&
&2.9972E-03_JPRB,6.6065E-03_JPRB,1.2887E-02_JPRB,1.9158E-02_JPRB,2.5345E-02_JPRB,3.1167E-02_JPRB,&
&3.7358E-02_JPRB,4.1161E-02_JPRB,5.0258E-02_JPRB/)
KAO( :, 1, 4,15) = (/&
&1.2393E-03_JPRB,1.4291E-03_JPRB,2.7934E-03_JPRB,4.1582E-03_JPRB,5.4860E-03_JPRB,6.6271E-03_JPRB,&
&7.7456E-03_JPRB,8.5638E-03_JPRB,1.0713E-02_JPRB/)
KAO( :, 2, 4,15) = (/&
&1.3400E-03_JPRB,2.1964E-03_JPRB,4.2752E-03_JPRB,6.3365E-03_JPRB,8.4061E-03_JPRB,1.0279E-02_JPRB,&
&1.2357E-02_JPRB,1.3474E-02_JPRB,1.7008E-02_JPRB/)
KAO( :, 3, 4,15) = (/&
&1.6349E-03_JPRB,3.2436E-03_JPRB,6.2304E-03_JPRB,9.4103E-03_JPRB,1.2432E-02_JPRB,1.5539E-02_JPRB,&
&1.8108E-02_JPRB,2.0011E-02_JPRB,2.5265E-02_JPRB/)
KAO( :, 4, 4,15) = (/&
&2.0292E-03_JPRB,4.6522E-03_JPRB,9.1141E-03_JPRB,1.3542E-02_JPRB,1.7761E-02_JPRB,2.1969E-02_JPRB,&
&2.5895E-02_JPRB,2.8549E-02_JPRB,3.4694E-02_JPRB/)
KAO( :, 5, 4,15) = (/&
&2.5299E-03_JPRB,6.1198E-03_JPRB,1.2014E-02_JPRB,1.7823E-02_JPRB,2.3626E-02_JPRB,3.0145E-02_JPRB,&
&3.4844E-02_JPRB,3.8179E-02_JPRB,4.7443E-02_JPRB/)
KAO( :, 1, 5,15) = (/&
&1.3376E-03_JPRB,1.3061E-03_JPRB,2.2933E-03_JPRB,3.4105E-03_JPRB,4.5058E-03_JPRB,5.4169E-03_JPRB,&
&6.3127E-03_JPRB,7.0090E-03_JPRB,8.8382E-03_JPRB/)
KAO( :, 2, 5,15) = (/&
&1.3263E-03_JPRB,1.8712E-03_JPRB,3.6486E-03_JPRB,5.3688E-03_JPRB,7.2653E-03_JPRB,8.6947E-03_JPRB,&
&1.0335E-02_JPRB,1.1527E-02_JPRB,1.4282E-02_JPRB/)
KAO( :, 3, 5,15) = (/&
&1.4243E-03_JPRB,2.8262E-03_JPRB,5.4158E-03_JPRB,8.2878E-03_JPRB,1.0953E-02_JPRB,1.3340E-02_JPRB,&
&1.6078E-02_JPRB,1.7370E-02_JPRB,2.2313E-02_JPRB/)
KAO( :, 4, 5,15) = (/&
&1.6989E-03_JPRB,4.0314E-03_JPRB,7.9177E-03_JPRB,1.2164E-02_JPRB,1.6022E-02_JPRB,1.9693E-02_JPRB,&
&2.2743E-02_JPRB,2.5430E-02_JPRB,3.1147E-02_JPRB/)
KAO( :, 5, 5,15) = (/&
&2.0980E-03_JPRB,5.4208E-03_JPRB,1.0645E-02_JPRB,1.5846E-02_JPRB,2.1457E-02_JPRB,2.6719E-02_JPRB,&
&3.1700E-02_JPRB,3.4634E-02_JPRB,4.2396E-02_JPRB/)
KAO( :, 1, 6,15) = (/&
&1.4699E-03_JPRB,1.3039E-03_JPRB,1.7682E-03_JPRB,2.6642E-03_JPRB,3.3901E-03_JPRB,4.1361E-03_JPRB,&
&4.9645E-03_JPRB,5.4015E-03_JPRB,7.0142E-03_JPRB/)
KAO( :, 2, 6,15) = (/&
&1.4420E-03_JPRB,1.6011E-03_JPRB,2.9603E-03_JPRB,4.2663E-03_JPRB,5.9096E-03_JPRB,7.1197E-03_JPRB,&
&8.3224E-03_JPRB,9.2909E-03_JPRB,1.1572E-02_JPRB/)
KAO( :, 3, 6,15) = (/&
&1.4209E-03_JPRB,2.3651E-03_JPRB,4.5056E-03_JPRB,6.8456E-03_JPRB,9.2009E-03_JPRB,1.1119E-02_JPRB,&
&1.3497E-02_JPRB,1.4341E-02_JPRB,1.8485E-02_JPRB/)
KAO( :, 4, 6,15) = (/&
&1.4876E-03_JPRB,3.4335E-03_JPRB,6.7368E-03_JPRB,1.0314E-02_JPRB,1.3111E-02_JPRB,1.6614E-02_JPRB,&
&1.9482E-02_JPRB,2.1613E-02_JPRB,2.6785E-02_JPRB/)
KAO( :, 5, 6,15) = (/&
&1.7311E-03_JPRB,4.9309E-03_JPRB,9.6716E-03_JPRB,1.4408E-02_JPRB,1.8785E-02_JPRB,2.3407E-02_JPRB,&
&2.7826E-02_JPRB,3.0253E-02_JPRB,3.8797E-02_JPRB/)
KAO( :, 1, 7,15) = (/&
&1.6452E-03_JPRB,1.4412E-03_JPRB,1.4879E-03_JPRB,1.9571E-03_JPRB,2.5256E-03_JPRB,3.0766E-03_JPRB,&
&3.7011E-03_JPRB,4.0149E-03_JPRB,5.3627E-03_JPRB/)
KAO( :, 2, 7,15) = (/&
&1.6160E-03_JPRB,1.5227E-03_JPRB,2.2973E-03_JPRB,3.3257E-03_JPRB,4.5738E-03_JPRB,5.5584E-03_JPRB,&
&6.3881E-03_JPRB,7.2538E-03_JPRB,9.6722E-03_JPRB/)
KAO( :, 3, 7,15) = (/&
&1.5860E-03_JPRB,2.0263E-03_JPRB,3.8492E-03_JPRB,5.5523E-03_JPRB,7.3824E-03_JPRB,9.0664E-03_JPRB,&
&1.0834E-02_JPRB,1.1569E-02_JPRB,1.5617E-02_JPRB/)
KAO( :, 4, 7,15) = (/&
&1.5638E-03_JPRB,2.9557E-03_JPRB,5.6559E-03_JPRB,8.6531E-03_JPRB,1.0991E-02_JPRB,1.3929E-02_JPRB,&
&1.6365E-02_JPRB,1.8010E-02_JPRB,2.4730E-02_JPRB/)
KAO( :, 5, 7,15) = (/&
&1.5935E-03_JPRB,4.3661E-03_JPRB,8.5392E-03_JPRB,1.2446E-02_JPRB,1.6667E-02_JPRB,2.0343E-02_JPRB,&
&2.3794E-02_JPRB,2.5830E-02_JPRB,3.6014E-02_JPRB/)
KAO( :, 1, 8,15) = (/&
&1.8723E-03_JPRB,1.6388E-03_JPRB,1.4610E-03_JPRB,1.5561E-03_JPRB,1.8720E-03_JPRB,2.3376E-03_JPRB,&
&2.6613E-03_JPRB,2.9039E-03_JPRB,6.4956E-03_JPRB/)
KAO( :, 2, 8,15) = (/&
&1.8456E-03_JPRB,1.6296E-03_JPRB,1.9116E-03_JPRB,2.6011E-03_JPRB,3.5199E-03_JPRB,4.2393E-03_JPRB,&
&4.8531E-03_JPRB,5.3550E-03_JPRB,1.2422E-02_JPRB/)
KAO( :, 3, 8,15) = (/&
&1.8093E-03_JPRB,1.9050E-03_JPRB,3.1124E-03_JPRB,4.4584E-03_JPRB,5.9417E-03_JPRB,7.2783E-03_JPRB,&
&8.6194E-03_JPRB,9.3908E-03_JPRB,2.1656E-02_JPRB/)
KAO( :, 4, 8,15) = (/&
&1.7796E-03_JPRB,2.5264E-03_JPRB,4.7746E-03_JPRB,7.1139E-03_JPRB,9.2445E-03_JPRB,1.1405E-02_JPRB,&
&1.3524E-02_JPRB,1.4718E-02_JPRB,3.5472E-02_JPRB/)
KAO( :, 5, 8,15) = (/&
&1.7474E-03_JPRB,3.6460E-03_JPRB,7.3775E-03_JPRB,1.0554E-02_JPRB,1.4351E-02_JPRB,1.7437E-02_JPRB,&
&2.0234E-02_JPRB,2.2659E-02_JPRB,5.4466E-02_JPRB/)
KAO( :, 1, 9,15) = (/&
&2.1531E-03_JPRB,1.8852E-03_JPRB,1.6173E-03_JPRB,1.4438E-03_JPRB,1.4392E-03_JPRB,1.6909E-03_JPRB,&
&1.8360E-03_JPRB,1.2556E-03_JPRB,2.2429E-02_JPRB/)
KAO( :, 2, 9,15) = (/&
&2.1197E-03_JPRB,1.8522E-03_JPRB,1.7919E-03_JPRB,2.0362E-03_JPRB,2.5897E-03_JPRB,3.1619E-03_JPRB,&
&3.6769E-03_JPRB,3.8809E-03_JPRB,4.5293E-02_JPRB/)
KAO( :, 3, 9,15) = (/&
&2.0806E-03_JPRB,1.9202E-03_JPRB,2.4651E-03_JPRB,3.5166E-03_JPRB,4.6833E-03_JPRB,5.6685E-03_JPRB,&
&6.7191E-03_JPRB,7.2005E-03_JPRB,8.3053E-02_JPRB/)
KAO( :, 4, 9,15) = (/&
&2.0479E-03_JPRB,2.3234E-03_JPRB,3.9257E-03_JPRB,5.8282E-03_JPRB,7.5382E-03_JPRB,9.2852E-03_JPRB,&
&1.0968E-02_JPRB,1.1755E-02_JPRB,1.4085E-01_JPRB/)
KAO( :, 5, 9,15) = (/&
&2.0135E-03_JPRB,3.1161E-03_JPRB,6.2953E-03_JPRB,8.9489E-03_JPRB,1.1910E-02_JPRB,1.4603E-02_JPRB,&
&1.7103E-02_JPRB,1.8687E-02_JPRB,2.2489E-01_JPRB/)
KAO( :, 1,10,15) = (/&
&2.4996E-03_JPRB,2.1860E-03_JPRB,1.8719E-03_JPRB,1.5736E-03_JPRB,1.3474E-03_JPRB,1.3138E-03_JPRB,&
&1.2455E-03_JPRB,1.1328E-07_JPRB,9.2144E-02_JPRB/)
KAO( :, 2,10,15) = (/&
&2.4545E-03_JPRB,2.1478E-03_JPRB,1.8895E-03_JPRB,1.8842E-03_JPRB,2.0494E-03_JPRB,2.4515E-03_JPRB,&
&2.7912E-03_JPRB,2.8411E-03_JPRB,1.9577E-01_JPRB/)
KAO( :, 3,10,15) = (/&
&2.4123E-03_JPRB,2.1379E-03_JPRB,2.2699E-03_JPRB,2.9106E-03_JPRB,3.7957E-03_JPRB,4.5303E-03_JPRB,&
&5.1569E-03_JPRB,5.5947E-03_JPRB,3.7579E-01_JPRB/)
KAO( :, 4,10,15) = (/&
&2.3670E-03_JPRB,2.3455E-03_JPRB,3.3904E-03_JPRB,4.7982E-03_JPRB,6.5586E-03_JPRB,7.6814E-03_JPRB,&
&8.9698E-03_JPRB,9.4919E-03_JPRB,6.5920E-01_JPRB/)
KAO( :, 5,10,15) = (/&
&2.3225E-03_JPRB,2.8728E-03_JPRB,5.4745E-03_JPRB,7.9446E-03_JPRB,1.0257E-02_JPRB,1.2466E-02_JPRB,&
&1.4486E-02_JPRB,1.5553E-02_JPRB,1.0800E+00_JPRB/)
KAO( :, 1,11,15) = (/&
&2.8637E-03_JPRB,2.5035E-03_JPRB,2.1436E-03_JPRB,1.8035E-03_JPRB,1.5339E-03_JPRB,1.4234E-03_JPRB,&
&1.1994E-03_JPRB,9.8829E-08_JPRB,1.9145E-01_JPRB/)
KAO( :, 2,11,15) = (/&
&2.8241E-03_JPRB,2.4682E-03_JPRB,2.1655E-03_JPRB,2.0940E-03_JPRB,2.2293E-03_JPRB,2.5943E-03_JPRB,&
&2.8972E-03_JPRB,2.9304E-03_JPRB,4.0810E-01_JPRB/)
KAO( :, 3,11,15) = (/&
&2.7755E-03_JPRB,2.4611E-03_JPRB,2.5498E-03_JPRB,3.0773E-03_JPRB,3.9941E-03_JPRB,4.8157E-03_JPRB,&
&5.3205E-03_JPRB,5.7118E-03_JPRB,7.8317E-01_JPRB/)
KAO( :, 4,11,15) = (/&
&2.7180E-03_JPRB,2.6251E-03_JPRB,3.6039E-03_JPRB,5.0535E-03_JPRB,6.8961E-03_JPRB,8.2198E-03_JPRB,&
&9.2474E-03_JPRB,9.6840E-03_JPRB,1.3768E+00_JPRB/)
KAO( :, 5,11,15) = (/&
&2.6558E-03_JPRB,3.1273E-03_JPRB,5.6600E-03_JPRB,8.3772E-03_JPRB,1.0624E-02_JPRB,1.3218E-02_JPRB,&
&1.5003E-02_JPRB,1.5876E-02_JPRB,2.2520E+00_JPRB/)
KAO( :, 1,12,15) = (/&
&3.2714E-03_JPRB,2.8584E-03_JPRB,2.4535E-03_JPRB,2.0680E-03_JPRB,1.7413E-03_JPRB,1.5693E-03_JPRB,&
&1.4195E-03_JPRB,8.7492E-08_JPRB,2.9715E-01_JPRB/)
KAO( :, 2,12,15) = (/&
&3.2238E-03_JPRB,2.8219E-03_JPRB,2.4898E-03_JPRB,2.3173E-03_JPRB,2.4029E-03_JPRB,2.7493E-03_JPRB,&
&3.0184E-03_JPRB,3.0151E-03_JPRB,6.3430E-01_JPRB/)
KAO( :, 3,12,15) = (/&
&3.1690E-03_JPRB,2.8261E-03_JPRB,2.8398E-03_JPRB,3.2763E-03_JPRB,4.1787E-03_JPRB,5.0712E-03_JPRB,&
&5.7128E-03_JPRB,5.7933E-03_JPRB,1.2146E+00_JPRB/)
KAO( :, 4,12,15) = (/&
&3.1066E-03_JPRB,2.9671E-03_JPRB,3.8178E-03_JPRB,5.5845E-03_JPRB,7.1025E-03_JPRB,8.6518E-03_JPRB,&
&9.8099E-03_JPRB,1.0106E-02_JPRB,2.1338E+00_JPRB/)
KAO( :, 5,12,15) = (/&
&3.0417E-03_JPRB,3.4447E-03_JPRB,5.9771E-03_JPRB,8.7849E-03_JPRB,1.1154E-02_JPRB,1.3933E-02_JPRB,&
&1.5683E-02_JPRB,1.6226E-02_JPRB,3.5026E+00_JPRB/)
KAO( :, 1,13,15) = (/&
&3.7174E-03_JPRB,3.2529E-03_JPRB,2.7876E-03_JPRB,2.3613E-03_JPRB,1.9840E-03_JPRB,1.7059E-03_JPRB,&
&1.5699E-03_JPRB,2.2638E-04_JPRB,3.7080E-01_JPRB/)
KAO( :, 2,13,15) = (/&
&3.6607E-03_JPRB,3.2024E-03_JPRB,2.8505E-03_JPRB,2.5957E-03_JPRB,2.5988E-03_JPRB,2.8843E-03_JPRB,&
&3.1480E-03_JPRB,3.2252E-03_JPRB,7.9012E-01_JPRB/)
KAO( :, 3,13,15) = (/&
&3.6056E-03_JPRB,3.2358E-03_JPRB,3.0977E-03_JPRB,3.5132E-03_JPRB,4.3893E-03_JPRB,5.3238E-03_JPRB,&
&5.9823E-03_JPRB,6.0551E-03_JPRB,1.5116E+00_JPRB/)
KAO( :, 4,13,15) = (/&
&3.5392E-03_JPRB,3.3725E-03_JPRB,4.1216E-03_JPRB,5.8741E-03_JPRB,7.4524E-03_JPRB,8.9744E-03_JPRB,&
&1.0256E-02_JPRB,1.0534E-02_JPRB,2.6566E+00_JPRB/)
KAO( :, 5,13,15) = (/&
&3.4654E-03_JPRB,3.8025E-03_JPRB,6.3205E-03_JPRB,9.1996E-03_JPRB,1.1773E-02_JPRB,1.4433E-02_JPRB,&
&1.6393E-02_JPRB,1.6955E-02_JPRB,4.3588E+00_JPRB/)
KAO( :, 1, 1,16) = (/&
&1.5672E-03_JPRB,2.1553E-03_JPRB,4.1215E-03_JPRB,6.0711E-03_JPRB,7.9933E-03_JPRB,9.8639E-03_JPRB,&
&1.1623E-02_JPRB,1.2894E-02_JPRB,1.4627E-02_JPRB/)
KAO( :, 2, 1,16) = (/&
&1.9455E-03_JPRB,3.1176E-03_JPRB,5.9834E-03_JPRB,8.8258E-03_JPRB,1.1628E-02_JPRB,1.4352E-02_JPRB,&
&1.6890E-02_JPRB,1.8782E-02_JPRB,2.1292E-02_JPRB/)
KAO( :, 3, 1,16) = (/&
&2.4286E-03_JPRB,4.3028E-03_JPRB,8.2818E-03_JPRB,1.2234E-02_JPRB,1.6127E-02_JPRB,1.9913E-02_JPRB,&
&2.3612E-02_JPRB,2.6215E-02_JPRB,2.9752E-02_JPRB/)
KAO( :, 4, 1,16) = (/&
&3.0199E-03_JPRB,5.7955E-03_JPRB,1.1212E-02_JPRB,1.6585E-02_JPRB,2.1939E-02_JPRB,2.7103E-02_JPRB,&
&3.1641E-02_JPRB,3.5382E-02_JPRB,4.0152E-02_JPRB/)
KAO( :, 5, 1,16) = (/&
&3.7301E-03_JPRB,7.5925E-03_JPRB,1.4663E-02_JPRB,2.1614E-02_JPRB,2.8523E-02_JPRB,3.5412E-02_JPRB,&
&4.1705E-02_JPRB,4.6016E-02_JPRB,5.2602E-02_JPRB/)
KAO( :, 1, 2,16) = (/&
&1.4714E-03_JPRB,2.1897E-03_JPRB,4.1859E-03_JPRB,6.1816E-03_JPRB,8.1457E-03_JPRB,1.0051E-02_JPRB,&
&1.1874E-02_JPRB,1.3114E-02_JPRB,1.5524E-02_JPRB/)
KAO( :, 2, 2,16) = (/&
&1.8243E-03_JPRB,3.2190E-03_JPRB,6.2284E-03_JPRB,9.2101E-03_JPRB,1.2144E-02_JPRB,1.5021E-02_JPRB,&
&1.7606E-02_JPRB,1.9473E-02_JPRB,2.2997E-02_JPRB/)
KAO( :, 3, 2,16) = (/&
&2.2843E-03_JPRB,4.5394E-03_JPRB,8.8033E-03_JPRB,1.3032E-02_JPRB,1.7194E-02_JPRB,2.1230E-02_JPRB,&
&2.5009E-02_JPRB,2.7460E-02_JPRB,3.2496E-02_JPRB/)
KAO( :, 4, 2,16) = (/&
&2.8708E-03_JPRB,6.2086E-03_JPRB,1.2093E-02_JPRB,1.7923E-02_JPRB,2.3632E-02_JPRB,2.9181E-02_JPRB,&
&3.4133E-02_JPRB,3.7858E-02_JPRB,4.4523E-02_JPRB/)
KAO( :, 5, 2,16) = (/&
&3.5701E-03_JPRB,8.1350E-03_JPRB,1.5874E-02_JPRB,2.3527E-02_JPRB,3.1085E-02_JPRB,3.8729E-02_JPRB,&
&4.5307E-02_JPRB,4.9567E-02_JPRB,5.9359E-02_JPRB/)
KAO( :, 1, 3,16) = (/&
&1.2836E-03_JPRB,2.0294E-03_JPRB,3.8863E-03_JPRB,5.8124E-03_JPRB,7.6573E-03_JPRB,9.3378E-03_JPRB,&
&1.1017E-02_JPRB,1.1974E-02_JPRB,1.4949E-02_JPRB/)
KAO( :, 2, 3,16) = (/&
&1.5660E-03_JPRB,3.0824E-03_JPRB,6.0009E-03_JPRB,8.8868E-03_JPRB,1.1717E-02_JPRB,1.4438E-02_JPRB,&
&1.6887E-02_JPRB,1.8445E-02_JPRB,2.2945E-02_JPRB/)
KAO( :, 3, 3,16) = (/&
&1.9600E-03_JPRB,4.4422E-03_JPRB,8.7147E-03_JPRB,1.2909E-02_JPRB,1.7029E-02_JPRB,2.0993E-02_JPRB,&
&2.4634E-02_JPRB,2.6606E-02_JPRB,3.3559E-02_JPRB/)
KAO( :, 4, 3,16) = (/&
&2.4642E-03_JPRB,6.2222E-03_JPRB,1.2184E-02_JPRB,1.8079E-02_JPRB,2.3727E-02_JPRB,2.9253E-02_JPRB,&
&3.4378E-02_JPRB,3.7595E-02_JPRB,4.7010E-02_JPRB/)
KAO( :, 5, 3,16) = (/&
&3.0951E-03_JPRB,8.3838E-03_JPRB,1.6309E-02_JPRB,2.4359E-02_JPRB,3.2164E-02_JPRB,3.9734E-02_JPRB,&
&4.6556E-02_JPRB,5.0749E-02_JPRB,6.3475E-02_JPRB/)
KAO( :, 1, 4,16) = (/&
&1.2574E-03_JPRB,1.8114E-03_JPRB,3.5154E-03_JPRB,5.2030E-03_JPRB,6.8473E-03_JPRB,8.4135E-03_JPRB,&
&9.7945E-03_JPRB,1.0467E-02_JPRB,1.3735E-02_JPRB/)
KAO( :, 2, 4,16) = (/&
&1.4045E-03_JPRB,2.8445E-03_JPRB,5.5546E-03_JPRB,8.2273E-03_JPRB,1.0867E-02_JPRB,1.3255E-02_JPRB,&
&1.5543E-02_JPRB,1.6757E-02_JPRB,2.1717E-02_JPRB/)
KAO( :, 3, 4,16) = (/&
&1.7089E-03_JPRB,4.2655E-03_JPRB,8.3342E-03_JPRB,1.2385E-02_JPRB,1.6320E-02_JPRB,2.0006E-02_JPRB,&
&2.3383E-02_JPRB,2.5166E-02_JPRB,3.2791E-02_JPRB/)
KAO( :, 4, 4,16) = (/&
&2.1090E-03_JPRB,6.0675E-03_JPRB,1.1915E-02_JPRB,1.7681E-02_JPRB,2.3322E-02_JPRB,2.8694E-02_JPRB,&
&3.3458E-02_JPRB,3.6118E-02_JPRB,4.7164E-02_JPRB/)
KAO( :, 5, 4,16) = (/&
&2.6086E-03_JPRB,8.3756E-03_JPRB,1.6515E-02_JPRB,2.4278E-02_JPRB,3.2230E-02_JPRB,3.9587E-02_JPRB,&
&4.6358E-02_JPRB,4.9833E-02_JPRB,6.4660E-02_JPRB/)
KAO( :, 1, 5,16) = (/&
&1.3825E-03_JPRB,1.5837E-03_JPRB,3.0919E-03_JPRB,4.5531E-03_JPRB,6.0074E-03_JPRB,7.3563E-03_JPRB,&
&8.5040E-03_JPRB,9.0047E-03_JPRB,1.2222E-02_JPRB/)
KAO( :, 2, 5,16) = (/&
&1.3514E-03_JPRB,2.5997E-03_JPRB,5.0814E-03_JPRB,7.5197E-03_JPRB,9.9239E-03_JPRB,1.2026E-02_JPRB,&
&1.3939E-02_JPRB,1.4883E-02_JPRB,2.0096E-02_JPRB/)
KAO( :, 3, 5,16) = (/&
&1.5206E-03_JPRB,4.0333E-03_JPRB,7.8158E-03_JPRB,1.1713E-02_JPRB,1.5405E-02_JPRB,1.8636E-02_JPRB,&
&2.1846E-02_JPRB,2.3099E-02_JPRB,3.1394E-02_JPRB/)
KAO( :, 4, 5,16) = (/&
&1.8386E-03_JPRB,5.8482E-03_JPRB,1.1495E-02_JPRB,1.7163E-02_JPRB,2.2705E-02_JPRB,2.7707E-02_JPRB,&
&3.1828E-02_JPRB,3.4087E-02_JPRB,4.5825E-02_JPRB/)
KAO( :, 5, 5,16) = (/&
&2.2527E-03_JPRB,8.2599E-03_JPRB,1.6275E-02_JPRB,2.4092E-02_JPRB,3.1836E-02_JPRB,3.8856E-02_JPRB,&
&4.5237E-02_JPRB,4.7798E-02_JPRB,6.5032E-02_JPRB/)
KAO( :, 1, 6,16) = (/&
&1.5452E-03_JPRB,1.3558E-03_JPRB,2.6064E-03_JPRB,3.8420E-03_JPRB,5.0190E-03_JPRB,6.1218E-03_JPRB,&
&7.0124E-03_JPRB,7.3072E-03_JPRB,1.0404E-02_JPRB/)
KAO( :, 2, 6,16) = (/&
&1.5160E-03_JPRB,2.2762E-03_JPRB,4.4992E-03_JPRB,6.5908E-03_JPRB,8.7549E-03_JPRB,1.0577E-02_JPRB,&
&1.2081E-02_JPRB,1.2650E-02_JPRB,1.7914E-02_JPRB/)
KAO( :, 3, 6,16) = (/&
&1.4831E-03_JPRB,3.6667E-03_JPRB,7.1626E-03_JPRB,1.0648E-02_JPRB,1.4117E-02_JPRB,1.6912E-02_JPRB,&
&1.9731E-02_JPRB,2.0210E-02_JPRB,2.8978E-02_JPRB/)
KAO( :, 4, 6,16) = (/&
&1.6115E-03_JPRB,5.5846E-03_JPRB,1.0973E-02_JPRB,1.6135E-02_JPRB,2.1251E-02_JPRB,2.6015E-02_JPRB,&
&2.9549E-02_JPRB,3.0765E-02_JPRB,4.3671E-02_JPRB/)
KAO( :, 5, 6,16) = (/&
&1.9392E-03_JPRB,8.0663E-03_JPRB,1.5907E-02_JPRB,2.3470E-02_JPRB,3.0817E-02_JPRB,3.7382E-02_JPRB,&
&4.3204E-02_JPRB,4.4622E-02_JPRB,6.3997E-02_JPRB/)
KAO( :, 1, 7,16) = (/&
&1.7424E-03_JPRB,1.5255E-03_JPRB,2.1507E-03_JPRB,3.1520E-03_JPRB,4.1047E-03_JPRB,4.9755E-03_JPRB,&
&5.6339E-03_JPRB,5.7296E-03_JPRB,8.6456E-03_JPRB/)
KAO( :, 2, 7,16) = (/&
&1.7170E-03_JPRB,1.9718E-03_JPRB,3.9047E-03_JPRB,5.6866E-03_JPRB,7.5061E-03_JPRB,9.0459E-03_JPRB,&
&1.0285E-02_JPRB,1.0440E-02_JPRB,1.5762E-02_JPRB/)
KAO( :, 3, 7,16) = (/&
&1.6789E-03_JPRB,3.3135E-03_JPRB,6.5455E-03_JPRB,9.5842E-03_JPRB,1.2571E-02_JPRB,1.5280E-02_JPRB,&
&1.7323E-02_JPRB,1.7346E-02_JPRB,2.6392E-02_JPRB/)
KAO( :, 4, 7,16) = (/&
&1.6475E-03_JPRB,5.2207E-03_JPRB,1.0255E-02_JPRB,1.5008E-02_JPRB,1.9715E-02_JPRB,2.4009E-02_JPRB,&
&2.7310E-02_JPRB,2.7325E-02_JPRB,4.1677E-02_JPRB/)
KAO( :, 5, 7,16) = (/&
&1.7171E-03_JPRB,7.7744E-03_JPRB,1.5301E-02_JPRB,2.2477E-02_JPRB,2.9556E-02_JPRB,3.5932E-02_JPRB,&
&4.0780E-02_JPRB,4.0784E-02_JPRB,6.2312E-02_JPRB/)
KAO( :, 1, 8,16) = (/&
&1.9724E-03_JPRB,1.7312E-03_JPRB,1.7354E-03_JPRB,2.5314E-03_JPRB,3.2671E-03_JPRB,3.9608E-03_JPRB,&
&4.3782E-03_JPRB,4.2763E-03_JPRB,7.0340E-03_JPRB/)
KAO( :, 2, 8,16) = (/&
&1.9569E-03_JPRB,1.7215E-03_JPRB,3.3340E-03_JPRB,4.8320E-03_JPRB,6.3356E-03_JPRB,7.5448E-03_JPRB,&
&8.4497E-03_JPRB,8.2045E-03_JPRB,1.3623E-02_JPRB/)
KAO( :, 3, 8,16) = (/&
&1.9222E-03_JPRB,3.0063E-03_JPRB,5.8393E-03_JPRB,8.4557E-03_JPRB,1.1082E-02_JPRB,1.3356E-02_JPRB,&
&1.4892E-02_JPRB,1.4508E-02_JPRB,2.3611E-02_JPRB/)
KAO( :, 4, 8,16) = (/&
&1.8856E-03_JPRB,4.8368E-03_JPRB,9.4413E-03_JPRB,1.3907E-02_JPRB,1.7960E-02_JPRB,2.1659E-02_JPRB,&
&2.4357E-02_JPRB,2.3676E-02_JPRB,3.8984E-02_JPRB/)
KAO( :, 5, 8,16) = (/&
&1.8442E-03_JPRB,7.3401E-03_JPRB,1.4568E-02_JPRB,2.1338E-02_JPRB,2.7859E-02_JPRB,3.3579E-02_JPRB,&
&3.7493E-02_JPRB,3.6571E-02_JPRB,5.9238E-02_JPRB/)
KAO( :, 1, 9,16) = (/&
&2.2527E-03_JPRB,1.9717E-03_JPRB,1.6910E-03_JPRB,1.9762E-03_JPRB,2.5161E-03_JPRB,3.0221E-03_JPRB,&
&3.2672E-03_JPRB,3.0670E-03_JPRB,2.3998E-02_JPRB/)
KAO( :, 2, 9,16) = (/&
&2.2414E-03_JPRB,1.9482E-03_JPRB,2.7675E-03_JPRB,3.9857E-03_JPRB,5.1603E-03_JPRB,6.1015E-03_JPRB,&
&6.6813E-03_JPRB,6.2533E-03_JPRB,4.8508E-02_JPRB/)
KAO( :, 3, 9,16) = (/&
&2.2044E-03_JPRB,2.6160E-03_JPRB,5.0727E-03_JPRB,7.3140E-03_JPRB,9.5554E-03_JPRB,1.1250E-02_JPRB,&
&1.2412E-02_JPRB,1.1623E-02_JPRB,8.8725E-02_JPRB/)
KAO( :, 4, 9,16) = (/&
&2.1701E-03_JPRB,4.4267E-03_JPRB,8.5607E-03_JPRB,1.2545E-02_JPRB,1.6038E-02_JPRB,1.9134E-02_JPRB,&
&2.1125E-02_JPRB,1.9740E-02_JPRB,1.5078E-01_JPRB/)
KAO( :, 5, 9,16) = (/&
&2.1291E-03_JPRB,6.8813E-03_JPRB,1.3705E-02_JPRB,1.9867E-02_JPRB,2.5629E-02_JPRB,3.0522E-02_JPRB,&
&3.3472E-02_JPRB,3.1537E-02_JPRB,2.4056E-01_JPRB/)
KAO( :, 1,10,16) = (/&
&2.6049E-03_JPRB,2.2811E-03_JPRB,1.9524E-03_JPRB,1.6297E-03_JPRB,1.9817E-03_JPRB,2.3323E-03_JPRB,&
&2.4538E-03_JPRB,1.0919E-07_JPRB,9.9434E-02_JPRB/)
KAO( :, 2,10,16) = (/&
&2.5564E-03_JPRB,2.2387E-03_JPRB,2.3682E-03_JPRB,3.4024E-03_JPRB,4.3056E-03_JPRB,4.9923E-03_JPRB,&
&5.3151E-03_JPRB,4.7395E-03_JPRB,2.1164E-01_JPRB/)
KAO( :, 3,10,16) = (/&
&2.5312E-03_JPRB,2.3572E-03_JPRB,4.5332E-03_JPRB,6.5179E-03_JPRB,8.3516E-03_JPRB,9.6321E-03_JPRB,&
&1.0262E-02_JPRB,9.2275E-03_JPRB,4.0466E-01_JPRB/)
KAO( :, 4,10,16) = (/&
&2.4933E-03_JPRB,4.1318E-03_JPRB,7.9555E-03_JPRB,1.1428E-02_JPRB,1.4719E-02_JPRB,1.6992E-02_JPRB,&
&1.8127E-02_JPRB,1.6262E-02_JPRB,7.1180E-01_JPRB/)
KAO( :, 5,10,16) = (/&
&2.4587E-03_JPRB,6.7099E-03_JPRB,1.3086E-02_JPRB,1.8862E-02_JPRB,2.3880E-02_JPRB,2.7946E-02_JPRB,&
&2.9807E-02_JPRB,2.6793E-02_JPRB,1.1699E+00_JPRB/)
KAO( :, 1,11,16) = (/&
&3.0995E-03_JPRB,2.7200E-03_JPRB,2.3118E-03_JPRB,1.9403E-03_JPRB,2.2912E-03_JPRB,2.6188E-03_JPRB,&
&2.6729E-03_JPRB,9.6247E-08_JPRB,2.0911E-01_JPRB/)
KAO( :, 2,11,16) = (/&
&2.9890E-03_JPRB,2.6201E-03_JPRB,2.7716E-03_JPRB,3.9533E-03_JPRB,4.9561E-03_JPRB,5.6265E-03_JPRB,&
&5.7942E-03_JPRB,4.9820E-03_JPRB,4.4548E-01_JPRB/)
KAO( :, 3,11,16) = (/&
&2.9190E-03_JPRB,2.7609E-03_JPRB,5.3580E-03_JPRB,7.5536E-03_JPRB,9.5654E-03_JPRB,1.0853E-02_JPRB,&
&1.1187E-02_JPRB,9.7006E-03_JPRB,8.5245E-01_JPRB/)
KAO( :, 4,11,16) = (/&
&2.8864E-03_JPRB,4.8539E-03_JPRB,9.3197E-03_JPRB,1.3213E-02_JPRB,1.6850E-02_JPRB,1.9193E-02_JPRB,&
&1.9763E-02_JPRB,1.7093E-02_JPRB,1.5055E+00_JPRB/)
KAO( :, 5,11,16) = (/&
&2.8813E-03_JPRB,7.9127E-03_JPRB,1.5164E-02_JPRB,2.1854E-02_JPRB,2.7083E-02_JPRB,3.1374E-02_JPRB,&
&3.2509E-02_JPRB,2.8179E-02_JPRB,2.4634E+00_JPRB/)
KAO( :, 1,12,16) = (/&
&3.7114E-03_JPRB,3.2586E-03_JPRB,2.7915E-03_JPRB,2.3232E-03_JPRB,2.6631E-03_JPRB,3.0175E-03_JPRB,&
&3.0634E-03_JPRB,8.7203E-08_JPRB,3.2918E-01_JPRB/)
KAO( :, 2,12,16) = (/&
&3.5714E-03_JPRB,3.1255E-03_JPRB,3.2432E-03_JPRB,4.6151E-03_JPRB,5.7633E-03_JPRB,6.4683E-03_JPRB,&
&6.5276E-03_JPRB,5.5718E-03_JPRB,7.0176E-01_JPRB/)
KAO( :, 3,12,16) = (/&
&3.4916E-03_JPRB,3.2858E-03_JPRB,6.3152E-03_JPRB,8.8262E-03_JPRB,1.0981E-02_JPRB,1.2464E-02_JPRB,&
&1.2740E-02_JPRB,1.0731E-02_JPRB,1.3410E+00_JPRB/)
KAO( :, 4,12,16) = (/&
&3.4311E-03_JPRB,5.7096E-03_JPRB,1.0941E-02_JPRB,1.5646E-02_JPRB,1.9404E-02_JPRB,2.2034E-02_JPRB,&
&2.2454E-02_JPRB,1.9063E-02_JPRB,2.3582E+00_JPRB/)
KAO( :, 5,12,16) = (/&
&3.4152E-03_JPRB,9.2951E-03_JPRB,1.7728E-02_JPRB,2.5434E-02_JPRB,3.1194E-02_JPRB,3.5945E-02_JPRB,&
&3.6575E-02_JPRB,3.1362E-02_JPRB,3.8718E+00_JPRB/)
KAO( :, 1,13,16) = (/&
&4.4410E-03_JPRB,3.8860E-03_JPRB,3.3353E-03_JPRB,2.7740E-03_JPRB,3.0544E-03_JPRB,3.4238E-03_JPRB,&
&3.4509E-03_JPRB,2.8859E-03_JPRB,4.1592E-01_JPRB/)
KAO( :, 2,13,16) = (/&
&4.2685E-03_JPRB,3.7372E-03_JPRB,3.7732E-03_JPRB,5.3427E-03_JPRB,6.6266E-03_JPRB,7.3589E-03_JPRB,&
&7.3233E-03_JPRB,6.2265E-03_JPRB,8.8643E-01_JPRB/)
KAO( :, 3,13,16) = (/&
&4.1797E-03_JPRB,3.9191E-03_JPRB,7.1821E-03_JPRB,1.0185E-02_JPRB,1.2582E-02_JPRB,1.4162E-02_JPRB,&
&1.4321E-02_JPRB,1.1935E-02_JPRB,1.6929E+00_JPRB/)
KAO( :, 4,13,16) = (/&
&4.0934E-03_JPRB,6.6879E-03_JPRB,1.2699E-02_JPRB,1.8078E-02_JPRB,2.2220E-02_JPRB,2.4912E-02_JPRB,&
&2.5205E-02_JPRB,2.1207E-02_JPRB,2.9775E+00_JPRB/)
KAO( :, 5,13,16) = (/&
&4.0583E-03_JPRB,1.0796E-02_JPRB,2.0731E-02_JPRB,2.9284E-02_JPRB,3.5883E-02_JPRB,4.0713E-02_JPRB,&
&4.0964E-02_JPRB,3.4894E-02_JPRB,4.8770E+00_JPRB/)


!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

KBO( :,13, 1) = (/&
&5.1259E-02_JPRB,7.3611E-02_JPRB,1.0293E-01_JPRB,1.3958E-01_JPRB,1.8370E-01_JPRB/)
KBO( :,14, 1) = (/&
&4.5713E-02_JPRB,6.5277E-02_JPRB,9.0553E-02_JPRB,1.2145E-01_JPRB,1.5795E-01_JPRB/)
KBO( :,15, 1) = (/&
&4.0795E-02_JPRB,5.7938E-02_JPRB,7.9664E-02_JPRB,1.0581E-01_JPRB,1.3605E-01_JPRB/)
KBO( :,16, 1) = (/&
&3.6460E-02_JPRB,5.1532E-02_JPRB,7.0278E-02_JPRB,9.2517E-02_JPRB,1.1775E-01_JPRB/)
KBO( :,17, 1) = (/&
&3.2358E-02_JPRB,4.5390E-02_JPRB,6.1388E-02_JPRB,8.0070E-02_JPRB,1.0088E-01_JPRB/)
KBO( :,18, 1) = (/&
&2.8485E-02_JPRB,3.9634E-02_JPRB,5.3109E-02_JPRB,6.8586E-02_JPRB,8.5607E-02_JPRB/)
KBO( :,19, 1) = (/&
&2.4839E-02_JPRB,3.4251E-02_JPRB,4.5451E-02_JPRB,5.8119E-02_JPRB,7.1935E-02_JPRB/)
KBO( :,20, 1) = (/&
&2.1646E-02_JPRB,2.9549E-02_JPRB,3.8829E-02_JPRB,4.9218E-02_JPRB,6.0534E-02_JPRB/)
KBO( :,21, 1) = (/&
&1.8726E-02_JPRB,2.5319E-02_JPRB,3.2990E-02_JPRB,4.1539E-02_JPRB,5.0831E-02_JPRB/)
KBO( :,22, 1) = (/&
&1.6430E-02_JPRB,2.1972E-02_JPRB,2.8373E-02_JPRB,3.5469E-02_JPRB,4.3144E-02_JPRB/)
KBO( :,23, 1) = (/&
&1.4344E-02_JPRB,1.9007E-02_JPRB,2.4347E-02_JPRB,3.0236E-02_JPRB,3.6575E-02_JPRB/)
KBO( :,24, 1) = (/&
&1.2498E-02_JPRB,1.6422E-02_JPRB,2.0874E-02_JPRB,2.5759E-02_JPRB,3.0990E-02_JPRB/)
KBO( :,25, 1) = (/&
&1.0890E-02_JPRB,1.4194E-02_JPRB,1.7906E-02_JPRB,2.1962E-02_JPRB,2.6282E-02_JPRB/)
KBO( :,26, 1) = (/&
&9.5169E-03_JPRB,1.2303E-02_JPRB,1.5406E-02_JPRB,1.8780E-02_JPRB,2.2347E-02_JPRB/)
KBO( :,27, 1) = (/&
&8.3127E-03_JPRB,1.0661E-02_JPRB,1.3260E-02_JPRB,1.6073E-02_JPRB,1.9015E-02_JPRB/)
KBO( :,28, 1) = (/&
&7.2555E-03_JPRB,9.2333E-03_JPRB,1.1414E-02_JPRB,1.3752E-02_JPRB,1.6182E-02_JPRB/)
KBO( :,29, 1) = (/&
&6.3460E-03_JPRB,8.0168E-03_JPRB,9.8497E-03_JPRB,1.1797E-02_JPRB,1.3808E-02_JPRB/)
KBO( :,30, 1) = (/&
&5.5479E-03_JPRB,6.9613E-03_JPRB,8.4972E-03_JPRB,1.0118E-02_JPRB,1.1783E-02_JPRB/)
KBO( :,31, 1) = (/&
&4.8584E-03_JPRB,6.0543E-03_JPRB,7.3446E-03_JPRB,8.6964E-03_JPRB,1.0081E-02_JPRB/)
KBO( :,32, 1) = (/&
&4.2533E-03_JPRB,5.2649E-03_JPRB,6.3493E-03_JPRB,7.4778E-03_JPRB,8.6341E-03_JPRB/)
KBO( :,33, 1) = (/&
&3.7229E-03_JPRB,4.5793E-03_JPRB,5.4910E-03_JPRB,6.4373E-03_JPRB,7.4041E-03_JPRB/)
KBO( :,34, 1) = (/&
&3.2276E-03_JPRB,3.9492E-03_JPRB,4.7134E-03_JPRB,5.5048E-03_JPRB,6.3115E-03_JPRB/)
KBO( :,35, 1) = (/&
&2.7399E-03_JPRB,3.3442E-03_JPRB,3.9827E-03_JPRB,4.6441E-03_JPRB,5.3183E-03_JPRB/)
KBO( :,36, 1) = (/&
&2.2726E-03_JPRB,2.7751E-03_JPRB,3.3064E-03_JPRB,3.8585E-03_JPRB,4.4216E-03_JPRB/)
KBO( :,37, 1) = (/&
&1.8221E-03_JPRB,2.2350E-03_JPRB,2.6736E-03_JPRB,3.1310E-03_JPRB,3.5993E-03_JPRB/)
KBO( :,38, 1) = (/&
&1.4592E-03_JPRB,1.7985E-03_JPRB,2.1611E-03_JPRB,2.5404E-03_JPRB,2.9304E-03_JPRB/)
KBO( :,39, 1) = (/&
&1.1699E-03_JPRB,1.4493E-03_JPRB,1.7501E-03_JPRB,2.0658E-03_JPRB,2.3919E-03_JPRB/)
KBO( :,40, 1) = (/&
&9.1194E-04_JPRB,1.1380E-03_JPRB,1.3840E-03_JPRB,1.6433E-03_JPRB,1.9130E-03_JPRB/)
KBO( :,41, 1) = (/&
&7.0723E-04_JPRB,8.8961E-04_JPRB,1.0899E-03_JPRB,1.3025E-03_JPRB,1.5252E-03_JPRB/)
KBO( :,42, 1) = (/&
&5.4756E-04_JPRB,6.9456E-04_JPRB,8.5764E-04_JPRB,1.0321E-03_JPRB,1.2157E-03_JPRB/)
KBO( :,43, 1) = (/&
&4.1699E-04_JPRB,5.3448E-04_JPRB,6.6629E-04_JPRB,8.0890E-04_JPRB,9.6007E-04_JPRB/)
KBO( :,44, 1) = (/&
&3.1440E-04_JPRB,4.0792E-04_JPRB,5.1407E-04_JPRB,6.3038E-04_JPRB,7.5481E-04_JPRB/)
KBO( :,45, 1) = (/&
&2.3640E-04_JPRB,3.1074E-04_JPRB,3.9606E-04_JPRB,4.9085E-04_JPRB,5.9335E-04_JPRB/)
KBO( :,46, 1) = (/&
&1.7594E-04_JPRB,2.3455E-04_JPRB,3.0267E-04_JPRB,3.7967E-04_JPRB,4.6391E-04_JPRB/)
KBO( :,47, 1) = (/&
&1.2843E-04_JPRB,1.7389E-04_JPRB,2.2775E-04_JPRB,2.8951E-04_JPRB,3.5820E-04_JPRB/)
KBO( :,48, 1) = (/&
&9.3343E-05_JPRB,1.2837E-04_JPRB,1.7092E-04_JPRB,2.2045E-04_JPRB,2.7649E-04_JPRB/)
KBO( :,49, 1) = (/&
&6.7599E-05_JPRB,9.4536E-05_JPRB,1.2808E-04_JPRB,1.6786E-04_JPRB,2.1369E-04_JPRB/)
KBO( :,50, 1) = (/&
&4.8948E-05_JPRB,6.9502E-05_JPRB,9.5623E-05_JPRB,1.2729E-04_JPRB,1.6435E-04_JPRB/)
KBO( :,51, 1) = (/&
&3.5346E-05_JPRB,5.0921E-05_JPRB,7.1079E-05_JPRB,9.6095E-05_JPRB,1.2578E-04_JPRB/)
KBO( :,52, 1) = (/&
&2.5450E-05_JPRB,3.7196E-05_JPRB,5.2726E-05_JPRB,7.2442E-05_JPRB,9.6232E-05_JPRB/)
KBO( :,53, 1) = (/&
&1.8296E-05_JPRB,2.7103E-05_JPRB,3.9075E-05_JPRB,5.4599E-05_JPRB,7.3735E-05_JPRB/)
KBO( :,54, 1) = (/&
&1.3152E-05_JPRB,1.9639E-05_JPRB,2.8663E-05_JPRB,4.0549E-05_JPRB,5.5484E-05_JPRB/)
KBO( :,55, 1) = (/&
&9.4445E-06_JPRB,1.4166E-05_JPRB,2.0853E-05_JPRB,2.9772E-05_JPRB,4.1184E-05_JPRB/)
KBO( :,56, 1) = (/&
&6.7805E-06_JPRB,1.0206E-05_JPRB,1.5127E-05_JPRB,2.1803E-05_JPRB,3.0469E-05_JPRB/)
KBO( :,57, 1) = (/&
&4.8676E-06_JPRB,7.3427E-06_JPRB,1.0945E-05_JPRB,1.5922E-05_JPRB,2.2468E-05_JPRB/)
KBO( :,58, 1) = (/&
&3.5190E-06_JPRB,5.3050E-06_JPRB,7.9365E-06_JPRB,1.1632E-05_JPRB,1.6547E-05_JPRB/)
KBO( :,59, 1) = (/&
&2.7224E-06_JPRB,4.0826E-06_JPRB,6.0785E-06_JPRB,8.8720E-06_JPRB,1.2572E-05_JPRB/)
KBO( :,13, 2) = (/&
&2.7119E-01_JPRB,3.6310E-01_JPRB,4.7414E-01_JPRB,6.0307E-01_JPRB,7.4957E-01_JPRB/)
KBO( :,14, 2) = (/&
&2.5353E-01_JPRB,3.3756E-01_JPRB,4.3733E-01_JPRB,5.5227E-01_JPRB,6.8177E-01_JPRB/)
KBO( :,15, 2) = (/&
&2.3613E-01_JPRB,3.1296E-01_JPRB,4.0272E-01_JPRB,5.0521E-01_JPRB,6.1950E-01_JPRB/)
KBO( :,16, 2) = (/&
&2.1883E-01_JPRB,2.8892E-01_JPRB,3.7007E-01_JPRB,4.6171E-01_JPRB,5.6222E-01_JPRB/)
KBO( :,17, 2) = (/&
&2.0046E-01_JPRB,2.6387E-01_JPRB,3.3671E-01_JPRB,4.1802E-01_JPRB,5.0615E-01_JPRB/)
KBO( :,18, 2) = (/&
&1.8162E-01_JPRB,2.3837E-01_JPRB,3.0306E-01_JPRB,3.7451E-01_JPRB,4.5033E-01_JPRB/)
KBO( :,19, 2) = (/&
&1.6273E-01_JPRB,2.1280E-01_JPRB,2.6942E-01_JPRB,3.3081E-01_JPRB,3.9474E-01_JPRB/)
KBO( :,20, 2) = (/&
&1.4529E-01_JPRB,1.8899E-01_JPRB,2.3756E-01_JPRB,2.8972E-01_JPRB,3.4258E-01_JPRB/)
KBO( :,21, 2) = (/&
&1.2870E-01_JPRB,1.6616E-01_JPRB,2.0730E-01_JPRB,2.5076E-01_JPRB,2.9377E-01_JPRB/)
KBO( :,22, 2) = (/&
&1.1499E-01_JPRB,1.4695E-01_JPRB,1.8158E-01_JPRB,2.1711E-01_JPRB,2.5164E-01_JPRB/)
KBO( :,23, 2) = (/&
&1.0194E-01_JPRB,1.2892E-01_JPRB,1.5758E-01_JPRB,1.8624E-01_JPRB,2.1370E-01_JPRB/)
KBO( :,24, 2) = (/&
&8.9789E-02_JPRB,1.1229E-01_JPRB,1.3567E-01_JPRB,1.5862E-01_JPRB,1.8060E-01_JPRB/)
KBO( :,25, 2) = (/&
&7.8662E-02_JPRB,9.7205E-02_JPRB,1.1609E-01_JPRB,1.3460E-01_JPRB,1.5226E-01_JPRB/)
KBO( :,26, 2) = (/&
&6.8677E-02_JPRB,8.3839E-02_JPRB,9.9146E-02_JPRB,1.1408E-01_JPRB,1.2832E-01_JPRB/)
KBO( :,27, 2) = (/&
&5.9597E-02_JPRB,7.2017E-02_JPRB,8.4456E-02_JPRB,9.6525E-02_JPRB,1.0804E-01_JPRB/)
KBO( :,28, 2) = (/&
&5.1479E-02_JPRB,6.1677E-02_JPRB,7.1788E-02_JPRB,8.1553E-02_JPRB,9.0870E-02_JPRB/)
KBO( :,29, 2) = (/&
&4.4418E-02_JPRB,5.2773E-02_JPRB,6.1008E-02_JPRB,6.8941E-02_JPRB,7.6507E-02_JPRB/)
KBO( :,30, 2) = (/&
&3.8240E-02_JPRB,4.5084E-02_JPRB,5.1802E-02_JPRB,5.8270E-02_JPRB,6.4403E-02_JPRB/)
KBO( :,31, 2) = (/&
&3.2906E-02_JPRB,3.8522E-02_JPRB,4.4011E-02_JPRB,4.9308E-02_JPRB,5.4268E-02_JPRB/)
KBO( :,32, 2) = (/&
&2.8286E-02_JPRB,3.2899E-02_JPRB,3.7402E-02_JPRB,4.1721E-02_JPRB,4.5728E-02_JPRB/)
KBO( :,33, 2) = (/&
&2.4296E-02_JPRB,2.8097E-02_JPRB,3.1779E-02_JPRB,3.5285E-02_JPRB,3.8510E-02_JPRB/)
KBO( :,34, 2) = (/&
&2.0730E-02_JPRB,2.3844E-02_JPRB,2.6852E-02_JPRB,2.9683E-02_JPRB,3.2295E-02_JPRB/)
KBO( :,35, 2) = (/&
&1.7417E-02_JPRB,1.9970E-02_JPRB,2.2433E-02_JPRB,2.4741E-02_JPRB,2.6876E-02_JPRB/)
KBO( :,36, 2) = (/&
&1.4391E-02_JPRB,1.6493E-02_JPRB,1.8520E-02_JPRB,2.0421E-02_JPRB,2.2183E-02_JPRB/)
KBO( :,37, 2) = (/&
&1.1614E-02_JPRB,1.3354E-02_JPRB,1.5031E-02_JPRB,1.6611E-02_JPRB,1.8085E-02_JPRB/)
KBO( :,38, 2) = (/&
&9.3636E-03_JPRB,1.0802E-02_JPRB,1.2193E-02_JPRB,1.3510E-02_JPRB,1.4737E-02_JPRB/)
KBO( :,39, 2) = (/&
&7.5541E-03_JPRB,8.7439E-03_JPRB,9.8975E-03_JPRB,1.0998E-02_JPRB,1.2026E-02_JPRB/)
KBO( :,40, 2) = (/&
&5.9794E-03_JPRB,6.9606E-03_JPRB,7.9183E-03_JPRB,8.8404E-03_JPRB,9.7022E-03_JPRB/)
KBO( :,41, 2) = (/&
&4.7162E-03_JPRB,5.5242E-03_JPRB,6.3175E-03_JPRB,7.0884E-03_JPRB,7.8122E-03_JPRB/)
KBO( :,42, 2) = (/&
&3.7141E-03_JPRB,4.3793E-03_JPRB,5.0373E-03_JPRB,5.6797E-03_JPRB,6.2875E-03_JPRB/)
KBO( :,43, 2) = (/&
&2.8894E-03_JPRB,3.4367E-03_JPRB,3.9819E-03_JPRB,4.5167E-03_JPRB,5.0302E-03_JPRB/)
KBO( :,44, 2) = (/&
&2.2311E-03_JPRB,2.6800E-03_JPRB,3.1318E-03_JPRB,3.5777E-03_JPRB,4.0109E-03_JPRB/)
KBO( :,45, 2) = (/&
&1.7190E-03_JPRB,2.0864E-03_JPRB,2.4595E-03_JPRB,2.8305E-03_JPRB,3.1948E-03_JPRB/)
KBO( :,46, 2) = (/&
&1.3144E-03_JPRB,1.6127E-03_JPRB,1.9198E-03_JPRB,2.2288E-03_JPRB,2.5338E-03_JPRB/)
KBO( :,47, 2) = (/&
&9.9072E-04_JPRB,1.2307E-03_JPRB,1.4827E-03_JPRB,1.7388E-03_JPRB,1.9939E-03_JPRB/)
KBO( :,48, 2) = (/&
&7.4328E-04_JPRB,9.3584E-04_JPRB,1.1422E-03_JPRB,1.3542E-03_JPRB,1.5673E-03_JPRB/)
KBO( :,49, 2) = (/&
&5.5568E-04_JPRB,7.0962E-04_JPRB,8.7747E-04_JPRB,1.0533E-03_JPRB,1.2311E-03_JPRB/)
KBO( :,50, 2) = (/&
&4.1543E-04_JPRB,5.3759E-04_JPRB,6.7298E-04_JPRB,8.1754E-04_JPRB,9.6501E-04_JPRB/)
KBO( :,51, 2) = (/&
&3.0972E-04_JPRB,4.0612E-04_JPRB,5.1480E-04_JPRB,6.3279E-04_JPRB,7.5447E-04_JPRB/)
KBO( :,52, 2) = (/&
&2.2960E-04_JPRB,3.0589E-04_JPRB,3.9277E-04_JPRB,4.8863E-04_JPRB,5.8929E-04_JPRB/)
KBO( :,53, 2) = (/&
&1.6933E-04_JPRB,2.2968E-04_JPRB,2.9891E-04_JPRB,3.7665E-04_JPRB,4.6003E-04_JPRB/)
KBO( :,54, 2) = (/&
&1.2476E-04_JPRB,1.7207E-04_JPRB,2.2658E-04_JPRB,2.8866E-04_JPRB,3.5637E-04_JPRB/)
KBO( :,55, 2) = (/&
&9.1638E-05_JPRB,1.2832E-04_JPRB,1.7102E-04_JPRB,2.1999E-04_JPRB,2.7423E-04_JPRB/)
KBO( :,56, 2) = (/&
&6.6998E-05_JPRB,9.5270E-05_JPRB,1.2875E-04_JPRB,1.6725E-04_JPRB,2.1034E-04_JPRB/)
KBO( :,57, 2) = (/&
&4.8715E-05_JPRB,7.0398E-05_JPRB,9.6609E-05_JPRB,1.2676E-04_JPRB,1.6093E-04_JPRB/)
KBO( :,58, 2) = (/&
&3.5429E-05_JPRB,5.2045E-05_JPRB,7.2448E-05_JPRB,9.6079E-05_JPRB,1.2306E-04_JPRB/)
KBO( :,59, 2) = (/&
&2.7567E-05_JPRB,4.0660E-05_JPRB,5.6784E-05_JPRB,7.5471E-05_JPRB,9.6741E-05_JPRB/)
KBO( :,13, 3) = (/&
&1.0985E+00_JPRB,1.3471E+00_JPRB,1.6024E+00_JPRB,1.8569E+00_JPRB,2.1065E+00_JPRB/)
KBO( :,14, 3) = (/&
&1.0057E+00_JPRB,1.2261E+00_JPRB,1.4487E+00_JPRB,1.6701E+00_JPRB,1.8867E+00_JPRB/)
KBO( :,15, 3) = (/&
&9.2327E-01_JPRB,1.1163E+00_JPRB,1.3096E+00_JPRB,1.5013E+00_JPRB,1.6927E+00_JPRB/)
KBO( :,16, 3) = (/&
&8.4655E-01_JPRB,1.0142E+00_JPRB,1.1813E+00_JPRB,1.3501E+00_JPRB,1.5181E+00_JPRB/)
KBO( :,17, 3) = (/&
&7.7095E-01_JPRB,9.1488E-01_JPRB,1.0609E+00_JPRB,1.2083E+00_JPRB,1.3539E+00_JPRB/)
KBO( :,18, 3) = (/&
&6.9584E-01_JPRB,8.2061E-01_JPRB,9.4796E-01_JPRB,1.0751E+00_JPRB,1.2000E+00_JPRB/)
KBO( :,19, 3) = (/&
&6.2275E-01_JPRB,7.3128E-01_JPRB,8.4109E-01_JPRB,9.5006E-01_JPRB,1.0557E+00_JPRB/)
KBO( :,20, 3) = (/&
&5.5466E-01_JPRB,6.4877E-01_JPRB,7.4343E-01_JPRB,8.3591E-01_JPRB,9.2515E-01_JPRB/)
KBO( :,21, 3) = (/&
&4.8960E-01_JPRB,5.7076E-01_JPRB,6.5178E-01_JPRB,7.3033E-01_JPRB,8.0430E-01_JPRB/)
KBO( :,22, 3) = (/&
&4.3303E-01_JPRB,5.0259E-01_JPRB,5.7096E-01_JPRB,6.3565E-01_JPRB,6.9649E-01_JPRB/)
KBO( :,23, 3) = (/&
&3.8028E-01_JPRB,4.3904E-01_JPRB,4.9534E-01_JPRB,5.4802E-01_JPRB,5.9732E-01_JPRB/)
KBO( :,24, 3) = (/&
&3.3218E-01_JPRB,3.8059E-01_JPRB,4.2634E-01_JPRB,4.6878E-01_JPRB,5.0765E-01_JPRB/)
KBO( :,25, 3) = (/&
&2.8849E-01_JPRB,3.2793E-01_JPRB,3.6460E-01_JPRB,3.9816E-01_JPRB,4.2820E-01_JPRB/)
KBO( :,26, 3) = (/&
&2.4952E-01_JPRB,2.8128E-01_JPRB,3.1016E-01_JPRB,3.3620E-01_JPRB,3.5944E-01_JPRB/)
KBO( :,27, 3) = (/&
&2.1458E-01_JPRB,2.3971E-01_JPRB,2.6222E-01_JPRB,2.8249E-01_JPRB,3.0071E-01_JPRB/)
KBO( :,28, 3) = (/&
&1.8348E-01_JPRB,2.0307E-01_JPRB,2.2063E-01_JPRB,2.3668E-01_JPRB,2.5103E-01_JPRB/)
KBO( :,29, 3) = (/&
&1.5612E-01_JPRB,1.7138E-01_JPRB,1.8529E-01_JPRB,1.9807E-01_JPRB,2.0946E-01_JPRB/)
KBO( :,30, 3) = (/&
&1.3217E-01_JPRB,1.4426E-01_JPRB,1.5536E-01_JPRB,1.6555E-01_JPRB,1.7467E-01_JPRB/)
KBO( :,31, 3) = (/&
&1.1164E-01_JPRB,1.2131E-01_JPRB,1.3020E-01_JPRB,1.3837E-01_JPRB,1.4579E-01_JPRB/)
KBO( :,32, 3) = (/&
&9.4160E-02_JPRB,1.0190E-01_JPRB,1.0909E-01_JPRB,1.1569E-01_JPRB,1.2174E-01_JPRB/)
KBO( :,33, 3) = (/&
&7.9328E-02_JPRB,8.5579E-02_JPRB,9.1418E-02_JPRB,9.6812E-02_JPRB,1.0174E-01_JPRB/)
KBO( :,34, 3) = (/&
&6.6575E-02_JPRB,7.1681E-02_JPRB,7.6449E-02_JPRB,8.0861E-02_JPRB,8.4837E-02_JPRB/)
KBO( :,35, 3) = (/&
&5.5452E-02_JPRB,5.9669E-02_JPRB,6.3583E-02_JPRB,6.7195E-02_JPRB,7.0402E-02_JPRB/)
KBO( :,36, 3) = (/&
&4.5817E-02_JPRB,4.9311E-02_JPRB,5.2541E-02_JPRB,5.5500E-02_JPRB,5.8136E-02_JPRB/)
KBO( :,37, 3) = (/&
&3.7392E-02_JPRB,4.0307E-02_JPRB,4.2995E-02_JPRB,4.5443E-02_JPRB,4.7667E-02_JPRB/)
KBO( :,38, 3) = (/&
&3.0507E-02_JPRB,3.2931E-02_JPRB,3.5170E-02_JPRB,3.7213E-02_JPRB,3.9076E-02_JPRB/)
KBO( :,39, 3) = (/&
&2.4900E-02_JPRB,2.6916E-02_JPRB,2.8785E-02_JPRB,3.0496E-02_JPRB,3.2065E-02_JPRB/)
KBO( :,40, 3) = (/&
&2.0117E-02_JPRB,2.1794E-02_JPRB,2.3370E-02_JPRB,2.4808E-02_JPRB,2.6137E-02_JPRB/)
KBO( :,41, 3) = (/&
&1.6225E-02_JPRB,1.7626E-02_JPRB,1.8947E-02_JPRB,2.0157E-02_JPRB,2.1285E-02_JPRB/)
KBO( :,42, 3) = (/&
&1.3079E-02_JPRB,1.4250E-02_JPRB,1.5359E-02_JPRB,1.6379E-02_JPRB,1.7329E-02_JPRB/)
KBO( :,43, 3) = (/&
&1.0482E-02_JPRB,1.1462E-02_JPRB,1.2394E-02_JPRB,1.3257E-02_JPRB,1.4064E-02_JPRB/)
KBO( :,44, 3) = (/&
&8.3710E-03_JPRB,9.1942E-03_JPRB,9.9787E-03_JPRB,1.0713E-02_JPRB,1.1396E-02_JPRB/)
KBO( :,45, 3) = (/&
&6.6788E-03_JPRB,7.3702E-03_JPRB,8.0298E-03_JPRB,8.6522E-03_JPRB,9.2329E-03_JPRB/)
KBO( :,46, 3) = (/&
&5.3081E-03_JPRB,5.8891E-03_JPRB,6.4422E-03_JPRB,6.9706E-03_JPRB,7.4651E-03_JPRB/)
KBO( :,47, 3) = (/&
&4.1866E-03_JPRB,4.6766E-03_JPRB,5.1419E-03_JPRB,5.5881E-03_JPRB,6.0116E-03_JPRB/)
KBO( :,48, 3) = (/&
&3.2935E-03_JPRB,3.7074E-03_JPRB,4.1001E-03_JPRB,4.4778E-03_JPRB,4.8397E-03_JPRB/)
KBO( :,49, 3) = (/&
&2.5846E-03_JPRB,2.9354E-03_JPRB,3.2677E-03_JPRB,3.5868E-03_JPRB,3.8959E-03_JPRB/)
KBO( :,50, 3) = (/&
&2.0269E-03_JPRB,2.3221E-03_JPRB,2.6022E-03_JPRB,2.8709E-03_JPRB,3.1320E-03_JPRB/)
KBO( :,51, 3) = (/&
&1.5861E-03_JPRB,1.8335E-03_JPRB,2.0693E-03_JPRB,2.2950E-03_JPRB,2.5144E-03_JPRB/)
KBO( :,52, 3) = (/&
&1.2373E-03_JPRB,1.4448E-03_JPRB,1.6433E-03_JPRB,1.8335E-03_JPRB,2.0181E-03_JPRB/)
KBO( :,53, 3) = (/&
&9.6238E-04_JPRB,1.1359E-03_JPRB,1.3032E-03_JPRB,1.4639E-03_JPRB,1.6200E-03_JPRB/)
KBO( :,54, 3) = (/&
&7.4760E-04_JPRB,8.9109E-04_JPRB,1.0310E-03_JPRB,1.1653E-03_JPRB,1.2951E-03_JPRB/)
KBO( :,55, 3) = (/&
&5.7948E-04_JPRB,6.9751E-04_JPRB,8.1351E-04_JPRB,9.2482E-04_JPRB,1.0323E-03_JPRB/)
KBO( :,56, 3) = (/&
&4.4747E-04_JPRB,5.4475E-04_JPRB,6.4072E-04_JPRB,7.3311E-04_JPRB,8.2203E-04_JPRB/)
KBO( :,57, 3) = (/&
&3.4377E-04_JPRB,4.2418E-04_JPRB,5.0351E-04_JPRB,5.8007E-04_JPRB,6.5383E-04_JPRB/)
KBO( :,58, 3) = (/&
&2.6362E-04_JPRB,3.3015E-04_JPRB,3.9544E-04_JPRB,4.5883E-04_JPRB,5.1985E-04_JPRB/)
KBO( :,59, 3) = (/&
&2.1059E-04_JPRB,2.6499E-04_JPRB,3.1808E-04_JPRB,3.6954E-04_JPRB,4.1891E-04_JPRB/)
KBO( :,13, 4) = (/&
&3.3302E+00_JPRB,3.5900E+00_JPRB,3.8490E+00_JPRB,4.0993E+00_JPRB,4.3544E+00_JPRB/)
KBO( :,14, 4) = (/&
&2.9375E+00_JPRB,3.1623E+00_JPRB,3.3912E+00_JPRB,3.6192E+00_JPRB,3.8536E+00_JPRB/)
KBO( :,15, 4) = (/&
&2.5847E+00_JPRB,2.7829E+00_JPRB,2.9920E+00_JPRB,3.2042E+00_JPRB,3.4159E+00_JPRB/)
KBO( :,16, 4) = (/&
&2.2723E+00_JPRB,2.4555E+00_JPRB,2.6487E+00_JPRB,2.8409E+00_JPRB,3.0352E+00_JPRB/)
KBO( :,17, 4) = (/&
&1.9985E+00_JPRB,2.1683E+00_JPRB,2.3422E+00_JPRB,2.5153E+00_JPRB,2.6950E+00_JPRB/)
KBO( :,18, 4) = (/&
&1.7574E+00_JPRB,1.9111E+00_JPRB,2.0646E+00_JPRB,2.2235E+00_JPRB,2.3882E+00_JPRB/)
KBO( :,19, 4) = (/&
&1.5417E+00_JPRB,1.6771E+00_JPRB,1.8159E+00_JPRB,1.9608E+00_JPRB,2.1091E+00_JPRB/)
KBO( :,20, 4) = (/&
&1.3501E+00_JPRB,1.4708E+00_JPRB,1.5966E+00_JPRB,1.7265E+00_JPRB,1.8579E+00_JPRB/)
KBO( :,21, 4) = (/&
&1.1792E+00_JPRB,1.2872E+00_JPRB,1.3996E+00_JPRB,1.5140E+00_JPRB,1.6291E+00_JPRB/)
KBO( :,22, 4) = (/&
&1.0331E+00_JPRB,1.1299E+00_JPRB,1.2292E+00_JPRB,1.3301E+00_JPRB,1.4294E+00_JPRB/)
KBO( :,23, 4) = (/&
&9.0257E-01_JPRB,9.8785E-01_JPRB,1.0758E+00_JPRB,1.1637E+00_JPRB,1.2469E+00_JPRB/)
KBO( :,24, 4) = (/&
&7.8462E-01_JPRB,8.6035E-01_JPRB,9.3739E-01_JPRB,1.0117E+00_JPRB,1.0795E+00_JPRB/)
KBO( :,25, 4) = (/&
&6.8021E-01_JPRB,7.4644E-01_JPRB,8.1147E-01_JPRB,8.7243E-01_JPRB,9.2768E-01_JPRB/)
KBO( :,26, 4) = (/&
&5.8877E-01_JPRB,6.4489E-01_JPRB,6.9856E-01_JPRB,7.4767E-01_JPRB,7.9152E-01_JPRB/)
KBO( :,27, 4) = (/&
&5.0790E-01_JPRB,5.5427E-01_JPRB,5.9771E-01_JPRB,6.3660E-01_JPRB,6.7040E-01_JPRB/)
KBO( :,28, 4) = (/&
&4.3619E-01_JPRB,4.7420E-01_JPRB,5.0861E-01_JPRB,5.3858E-01_JPRB,5.6428E-01_JPRB/)
KBO( :,29, 4) = (/&
&3.7351E-01_JPRB,4.0404E-01_JPRB,4.3062E-01_JPRB,4.5356E-01_JPRB,4.7355E-01_JPRB/)
KBO( :,30, 4) = (/&
&3.1877E-01_JPRB,3.4252E-01_JPRB,3.6291E-01_JPRB,3.8087E-01_JPRB,3.9669E-01_JPRB/)
KBO( :,31, 4) = (/&
&2.7097E-01_JPRB,2.8918E-01_JPRB,3.0519E-01_JPRB,3.1945E-01_JPRB,3.3218E-01_JPRB/)
KBO( :,32, 4) = (/&
&2.2933E-01_JPRB,2.4355E-01_JPRB,2.5629E-01_JPRB,2.6778E-01_JPRB,2.7819E-01_JPRB/)
KBO( :,33, 4) = (/&
&1.9352E-01_JPRB,2.0488E-01_JPRB,2.1514E-01_JPRB,2.2453E-01_JPRB,2.3322E-01_JPRB/)
KBO( :,34, 4) = (/&
&1.6266E-01_JPRB,1.7186E-01_JPRB,1.8021E-01_JPRB,1.8806E-01_JPRB,1.9533E-01_JPRB/)
KBO( :,35, 4) = (/&
&1.3588E-01_JPRB,1.4344E-01_JPRB,1.5044E-01_JPRB,1.5708E-01_JPRB,1.6319E-01_JPRB/)
KBO( :,36, 4) = (/&
&1.1281E-01_JPRB,1.1914E-01_JPRB,1.2508E-01_JPRB,1.3072E-01_JPRB,1.3587E-01_JPRB/)
KBO( :,37, 4) = (/&
&9.2816E-02_JPRB,9.8205E-02_JPRB,1.0328E-01_JPRB,1.0804E-01_JPRB,1.1242E-01_JPRB/)
KBO( :,38, 4) = (/&
&7.6370E-02_JPRB,8.0963E-02_JPRB,8.5283E-02_JPRB,8.9321E-02_JPRB,9.2973E-02_JPRB/)
KBO( :,39, 4) = (/&
&6.2888E-02_JPRB,6.6805E-02_JPRB,7.0475E-02_JPRB,7.3875E-02_JPRB,7.6971E-02_JPRB/)
KBO( :,40, 4) = (/&
&5.1396E-02_JPRB,5.4708E-02_JPRB,5.7829E-02_JPRB,6.0714E-02_JPRB,6.3350E-02_JPRB/)
KBO( :,41, 4) = (/&
&4.1955E-02_JPRB,4.4762E-02_JPRB,4.7396E-02_JPRB,4.9843E-02_JPRB,5.2102E-02_JPRB/)
KBO( :,42, 4) = (/&
&3.4234E-02_JPRB,3.6611E-02_JPRB,3.8848E-02_JPRB,4.0922E-02_JPRB,4.2851E-02_JPRB/)
KBO( :,43, 4) = (/&
&2.7815E-02_JPRB,2.9825E-02_JPRB,3.1727E-02_JPRB,3.3492E-02_JPRB,3.5154E-02_JPRB/)
KBO( :,44, 4) = (/&
&2.2537E-02_JPRB,2.4240E-02_JPRB,2.5867E-02_JPRB,2.7378E-02_JPRB,2.8807E-02_JPRB/)
KBO( :,45, 4) = (/&
&1.8246E-02_JPRB,1.9697E-02_JPRB,2.1085E-02_JPRB,2.2374E-02_JPRB,2.3604E-02_JPRB/)
KBO( :,46, 4) = (/&
&1.4728E-02_JPRB,1.5964E-02_JPRB,1.7142E-02_JPRB,1.8251E-02_JPRB,1.9308E-02_JPRB/)
KBO( :,47, 4) = (/&
&1.1818E-02_JPRB,1.2873E-02_JPRB,1.3878E-02_JPRB,1.4831E-02_JPRB,1.5740E-02_JPRB/)
KBO( :,48, 4) = (/&
&9.4657E-03_JPRB,1.0367E-02_JPRB,1.1228E-02_JPRB,1.2052E-02_JPRB,1.2833E-02_JPRB/)
KBO( :,49, 4) = (/&
&7.5680E-03_JPRB,8.3421E-03_JPRB,9.0805E-03_JPRB,9.7902E-03_JPRB,1.0464E-02_JPRB/)
KBO( :,50, 4) = (/&
&6.0502E-03_JPRB,6.7078E-03_JPRB,7.3374E-03_JPRB,7.9442E-03_JPRB,8.5226E-03_JPRB/)
KBO( :,51, 4) = (/&
&4.8299E-03_JPRB,5.3854E-03_JPRB,5.9216E-03_JPRB,6.4376E-03_JPRB,6.9334E-03_JPRB/)
KBO( :,52, 4) = (/&
&3.8467E-03_JPRB,4.3164E-03_JPRB,4.7737E-03_JPRB,5.2128E-03_JPRB,5.6384E-03_JPRB/)
KBO( :,53, 4) = (/&
&3.0576E-03_JPRB,3.4544E-03_JPRB,3.8447E-03_JPRB,4.2192E-03_JPRB,4.5847E-03_JPRB/)
KBO( :,54, 4) = (/&
&2.4302E-03_JPRB,2.7614E-03_JPRB,3.0899E-03_JPRB,3.4056E-03_JPRB,3.7134E-03_JPRB/)
KBO( :,55, 4) = (/&
&1.9293E-03_JPRB,2.2038E-03_JPRB,2.4777E-03_JPRB,2.7424E-03_JPRB,2.9994E-03_JPRB/)
KBO( :,56, 4) = (/&
&1.5286E-03_JPRB,1.7562E-03_JPRB,1.9841E-03_JPRB,2.2060E-03_JPRB,2.4199E-03_JPRB/)
KBO( :,57, 4) = (/&
&1.2085E-03_JPRB,1.3971E-03_JPRB,1.5864E-03_JPRB,1.7724E-03_JPRB,1.9514E-03_JPRB/)
KBO( :,58, 4) = (/&
&9.5537E-04_JPRB,1.1118E-03_JPRB,1.2685E-03_JPRB,1.4237E-03_JPRB,1.5733E-03_JPRB/)
KBO( :,59, 4) = (/&
&7.7590E-04_JPRB,9.0437E-04_JPRB,1.0323E-03_JPRB,1.1597E-03_JPRB,1.2822E-03_JPRB/)
KBO( :,13, 5) = (/&
&6.9141E+00_JPRB,7.1545E+00_JPRB,7.4046E+00_JPRB,7.6833E+00_JPRB,7.9432E+00_JPRB/)
KBO( :,14, 5) = (/&
&6.0755E+00_JPRB,6.2987E+00_JPRB,6.5306E+00_JPRB,6.7873E+00_JPRB,7.0278E+00_JPRB/)
KBO( :,15, 5) = (/&
&5.3116E+00_JPRB,5.5269E+00_JPRB,5.7512E+00_JPRB,5.9835E+00_JPRB,6.2117E+00_JPRB/)
KBO( :,16, 5) = (/&
&4.6343E+00_JPRB,4.8449E+00_JPRB,5.0585E+00_JPRB,5.2837E+00_JPRB,5.5069E+00_JPRB/)
KBO( :,17, 5) = (/&
&4.0419E+00_JPRB,4.2430E+00_JPRB,4.4508E+00_JPRB,4.6718E+00_JPRB,4.8821E+00_JPRB/)
KBO( :,18, 5) = (/&
&3.5281E+00_JPRB,3.7196E+00_JPRB,3.9254E+00_JPRB,4.1289E+00_JPRB,4.3250E+00_JPRB/)
KBO( :,19, 5) = (/&
&3.0859E+00_JPRB,3.2697E+00_JPRB,3.4594E+00_JPRB,3.6428E+00_JPRB,3.8279E+00_JPRB/)
KBO( :,20, 5) = (/&
&2.7073E+00_JPRB,2.8768E+00_JPRB,3.0450E+00_JPRB,3.2129E+00_JPRB,3.3880E+00_JPRB/)
KBO( :,21, 5) = (/&
&2.3737E+00_JPRB,2.5247E+00_JPRB,2.6757E+00_JPRB,2.8327E+00_JPRB,2.9960E+00_JPRB/)
KBO( :,22, 5) = (/&
&2.0857E+00_JPRB,2.2199E+00_JPRB,2.3591E+00_JPRB,2.5039E+00_JPRB,2.6519E+00_JPRB/)
KBO( :,23, 5) = (/&
&1.8289E+00_JPRB,1.9512E+00_JPRB,2.0778E+00_JPRB,2.2081E+00_JPRB,2.3436E+00_JPRB/)
KBO( :,24, 5) = (/&
&1.6014E+00_JPRB,1.7122E+00_JPRB,1.8266E+00_JPRB,1.9454E+00_JPRB,2.0684E+00_JPRB/)
KBO( :,25, 5) = (/&
&1.3998E+00_JPRB,1.4999E+00_JPRB,1.6048E+00_JPRB,1.7138E+00_JPRB,1.8217E+00_JPRB/)
KBO( :,26, 5) = (/&
&1.2210E+00_JPRB,1.3132E+00_JPRB,1.4097E+00_JPRB,1.5070E+00_JPRB,1.6011E+00_JPRB/)
KBO( :,27, 5) = (/&
&1.0633E+00_JPRB,1.1477E+00_JPRB,1.2343E+00_JPRB,1.3197E+00_JPRB,1.4013E+00_JPRB/)
KBO( :,28, 5) = (/&
&9.2471E-01_JPRB,1.0003E+00_JPRB,1.0762E+00_JPRB,1.1506E+00_JPRB,1.2207E+00_JPRB/)
KBO( :,29, 5) = (/&
&8.0378E-01_JPRB,8.6991E-01_JPRB,9.3571E-01_JPRB,9.9918E-01_JPRB,1.0579E+00_JPRB/)
KBO( :,30, 5) = (/&
&6.9745E-01_JPRB,7.5481E-01_JPRB,8.1124E-01_JPRB,8.6394E-01_JPRB,9.1132E-01_JPRB/)
KBO( :,31, 5) = (/&
&6.0465E-01_JPRB,6.5420E-01_JPRB,7.0129E-01_JPRB,7.4415E-01_JPRB,7.8220E-01_JPRB/)
KBO( :,32, 5) = (/&
&5.2389E-01_JPRB,5.6576E-01_JPRB,6.0408E-01_JPRB,6.3888E-01_JPRB,6.7018E-01_JPRB/)
KBO( :,33, 5) = (/&
&4.5339E-01_JPRB,4.8777E-01_JPRB,5.1895E-01_JPRB,5.4778E-01_JPRB,5.7413E-01_JPRB/)
KBO( :,34, 5) = (/&
&3.9043E-01_JPRB,4.1838E-01_JPRB,4.4436E-01_JPRB,4.6859E-01_JPRB,4.9150E-01_JPRB/)
KBO( :,35, 5) = (/&
&3.3304E-01_JPRB,3.5641E-01_JPRB,3.7837E-01_JPRB,3.9937E-01_JPRB,4.1969E-01_JPRB/)
KBO( :,36, 5) = (/&
&2.8159E-01_JPRB,3.0146E-01_JPRB,3.2042E-01_JPRB,3.3894E-01_JPRB,3.5721E-01_JPRB/)
KBO( :,37, 5) = (/&
&2.3528E-01_JPRB,2.5243E-01_JPRB,2.6898E-01_JPRB,2.8542E-01_JPRB,3.0190E-01_JPRB/)
KBO( :,38, 5) = (/&
&1.9653E-01_JPRB,2.1135E-01_JPRB,2.2593E-01_JPRB,2.4055E-01_JPRB,2.5537E-01_JPRB/)
KBO( :,39, 5) = (/&
&1.6424E-01_JPRB,1.7712E-01_JPRB,1.9008E-01_JPRB,2.0314E-01_JPRB,2.1645E-01_JPRB/)
KBO( :,40, 5) = (/&
&1.3599E-01_JPRB,1.4712E-01_JPRB,1.5856E-01_JPRB,1.7013E-01_JPRB,1.8191E-01_JPRB/)
KBO( :,41, 5) = (/&
&1.1240E-01_JPRB,1.2208E-01_JPRB,1.3208E-01_JPRB,1.4229E-01_JPRB,1.5269E-01_JPRB/)
KBO( :,42, 5) = (/&
&9.2848E-02_JPRB,1.0126E-01_JPRB,1.1003E-01_JPRB,1.1902E-01_JPRB,1.2816E-01_JPRB/)
KBO( :,43, 5) = (/&
&7.6272E-02_JPRB,8.3551E-02_JPRB,9.1173E-02_JPRB,9.9059E-02_JPRB,1.0710E-01_JPRB/)
KBO( :,44, 5) = (/&
&6.2420E-02_JPRB,6.8705E-02_JPRB,7.5347E-02_JPRB,8.2255E-02_JPRB,8.9304E-02_JPRB/)
KBO( :,45, 5) = (/&
&5.1037E-02_JPRB,5.6461E-02_JPRB,6.2222E-02_JPRB,6.8245E-02_JPRB,7.4410E-02_JPRB/)
KBO( :,46, 5) = (/&
&4.1575E-02_JPRB,4.6220E-02_JPRB,5.1187E-02_JPRB,5.6431E-02_JPRB,6.1814E-02_JPRB/)
KBO( :,47, 5) = (/&
&3.3624E-02_JPRB,3.7569E-02_JPRB,4.1825E-02_JPRB,4.6358E-02_JPRB,5.1051E-02_JPRB/)
KBO( :,48, 5) = (/&
&2.7133E-02_JPRB,3.0477E-02_JPRB,3.4127E-02_JPRB,3.8049E-02_JPRB,4.2137E-02_JPRB/)
KBO( :,49, 5) = (/&
&2.1850E-02_JPRB,2.4695E-02_JPRB,2.7812E-02_JPRB,3.1199E-02_JPRB,3.4749E-02_JPRB/)
KBO( :,50, 5) = (/&
&1.7588E-02_JPRB,1.9999E-02_JPRB,2.2640E-02_JPRB,2.5547E-02_JPRB,2.8612E-02_JPRB/)
KBO( :,51, 5) = (/&
&1.4133E-02_JPRB,1.6172E-02_JPRB,1.8401E-02_JPRB,2.0880E-02_JPRB,2.3515E-02_JPRB/)
KBO( :,52, 5) = (/&
&1.1330E-02_JPRB,1.3052E-02_JPRB,1.4932E-02_JPRB,1.7041E-02_JPRB,1.9304E-02_JPRB/)
KBO( :,53, 5) = (/&
&9.0563E-03_JPRB,1.0511E-02_JPRB,1.2096E-02_JPRB,1.3890E-02_JPRB,1.5837E-02_JPRB/)
KBO( :,54, 5) = (/&
&7.2337E-03_JPRB,8.4542E-03_JPRB,9.7774E-03_JPRB,1.1280E-02_JPRB,1.2936E-02_JPRB/)
KBO( :,55, 5) = (/&
&5.7674E-03_JPRB,6.7888E-03_JPRB,7.8837E-03_JPRB,9.1276E-03_JPRB,1.0528E-02_JPRB/)
KBO( :,56, 5) = (/&
&4.5854E-03_JPRB,5.4402E-03_JPRB,6.3461E-03_JPRB,7.3755E-03_JPRB,8.5458E-03_JPRB/)
KBO( :,57, 5) = (/&
&3.6334E-03_JPRB,4.3489E-03_JPRB,5.0994E-03_JPRB,5.9486E-03_JPRB,6.9270E-03_JPRB/)
KBO( :,58, 5) = (/&
&2.8784E-03_JPRB,3.4761E-03_JPRB,4.0992E-03_JPRB,4.7976E-03_JPRB,5.6122E-03_JPRB/)
KBO( :,59, 5) = (/&
&2.3567E-03_JPRB,2.8551E-03_JPRB,3.3744E-03_JPRB,3.9529E-03_JPRB,4.6311E-03_JPRB/)
KBO( :,13, 6) = (/&
&1.3830E+01_JPRB,1.4015E+01_JPRB,1.4160E+01_JPRB,1.4307E+01_JPRB,1.4522E+01_JPRB/)
KBO( :,14, 6) = (/&
&1.2340E+01_JPRB,1.2516E+01_JPRB,1.2660E+01_JPRB,1.2793E+01_JPRB,1.2966E+01_JPRB/)
KBO( :,15, 6) = (/&
&1.0924E+01_JPRB,1.1092E+01_JPRB,1.1224E+01_JPRB,1.1351E+01_JPRB,1.1516E+01_JPRB/)
KBO( :,16, 6) = (/&
&9.6024E+00_JPRB,9.7501E+00_JPRB,9.8836E+00_JPRB,1.0029E+01_JPRB,1.0212E+01_JPRB/)
KBO( :,17, 6) = (/&
&8.3708E+00_JPRB,8.5153E+00_JPRB,8.6644E+00_JPRB,8.8329E+00_JPRB,9.0401E+00_JPRB/)
KBO( :,18, 6) = (/&
&7.2569E+00_JPRB,7.4102E+00_JPRB,7.5767E+00_JPRB,7.7740E+00_JPRB,8.0051E+00_JPRB/)
KBO( :,19, 6) = (/&
&6.2750E+00_JPRB,6.4411E+00_JPRB,6.6283E+00_JPRB,6.8499E+00_JPRB,7.0924E+00_JPRB/)
KBO( :,20, 6) = (/&
&5.4324E+00_JPRB,5.6127E+00_JPRB,5.8201E+00_JPRB,6.0515E+00_JPRB,6.2952E+00_JPRB/)
KBO( :,21, 6) = (/&
&4.7199E+00_JPRB,4.9098E+00_JPRB,5.1220E+00_JPRB,5.3512E+00_JPRB,5.5929E+00_JPRB/)
KBO( :,22, 6) = (/&
&4.1275E+00_JPRB,4.3173E+00_JPRB,4.5250E+00_JPRB,4.7472E+00_JPRB,4.9873E+00_JPRB/)
KBO( :,23, 6) = (/&
&3.6186E+00_JPRB,3.8008E+00_JPRB,4.0007E+00_JPRB,4.2194E+00_JPRB,4.4546E+00_JPRB/)
KBO( :,24, 6) = (/&
&3.1789E+00_JPRB,3.3535E+00_JPRB,3.5481E+00_JPRB,3.7602E+00_JPRB,3.9826E+00_JPRB/)
KBO( :,25, 6) = (/&
&2.8009E+00_JPRB,2.9702E+00_JPRB,3.1571E+00_JPRB,3.3553E+00_JPRB,3.5661E+00_JPRB/)
KBO( :,26, 6) = (/&
&2.4787E+00_JPRB,2.6417E+00_JPRB,2.8161E+00_JPRB,3.0035E+00_JPRB,3.2026E+00_JPRB/)
KBO( :,27, 6) = (/&
&2.1990E+00_JPRB,2.3537E+00_JPRB,2.5197E+00_JPRB,2.6976E+00_JPRB,2.8845E+00_JPRB/)
KBO( :,28, 6) = (/&
&1.9523E+00_JPRB,2.1013E+00_JPRB,2.2618E+00_JPRB,2.4297E+00_JPRB,2.6035E+00_JPRB/)
KBO( :,29, 6) = (/&
&1.7370E+00_JPRB,1.8823E+00_JPRB,2.0367E+00_JPRB,2.1958E+00_JPRB,2.3561E+00_JPRB/)
KBO( :,30, 6) = (/&
&1.5497E+00_JPRB,1.6904E+00_JPRB,1.8375E+00_JPRB,1.9876E+00_JPRB,2.1376E+00_JPRB/)
KBO( :,31, 6) = (/&
&1.3874E+00_JPRB,1.5222E+00_JPRB,1.6617E+00_JPRB,1.8040E+00_JPRB,1.9446E+00_JPRB/)
KBO( :,32, 6) = (/&
&1.2460E+00_JPRB,1.3738E+00_JPRB,1.5067E+00_JPRB,1.6408E+00_JPRB,1.7720E+00_JPRB/)
KBO( :,33, 6) = (/&
&1.1223E+00_JPRB,1.2436E+00_JPRB,1.3697E+00_JPRB,1.4955E+00_JPRB,1.6172E+00_JPRB/)
KBO( :,34, 6) = (/&
&1.0099E+00_JPRB,1.1249E+00_JPRB,1.2434E+00_JPRB,1.3608E+00_JPRB,1.4735E+00_JPRB/)
KBO( :,35, 6) = (/&
&9.0209E-01_JPRB,1.0096E+00_JPRB,1.1199E+00_JPRB,1.2299E+00_JPRB,1.3354E+00_JPRB/)
KBO( :,36, 6) = (/&
&7.9733E-01_JPRB,8.9688E-01_JPRB,9.9932E-01_JPRB,1.1023E+00_JPRB,1.2028E+00_JPRB/)
KBO( :,37, 6) = (/&
&6.9211E-01_JPRB,7.8344E-01_JPRB,8.7821E-01_JPRB,9.7443E-01_JPRB,1.0708E+00_JPRB/)
KBO( :,38, 6) = (/&
&6.0006E-01_JPRB,6.8377E-01_JPRB,7.7149E-01_JPRB,8.6171E-01_JPRB,9.5413E-01_JPRB/)
KBO( :,39, 6) = (/&
&5.2043E-01_JPRB,5.9726E-01_JPRB,6.7852E-01_JPRB,7.6343E-01_JPRB,8.5244E-01_JPRB/)
KBO( :,40, 6) = (/&
&4.4416E-01_JPRB,5.1399E-01_JPRB,5.8862E-01_JPRB,6.6792E-01_JPRB,7.5268E-01_JPRB/)
KBO( :,41, 6) = (/&
&3.7776E-01_JPRB,4.4092E-01_JPRB,5.0931E-01_JPRB,5.8308E-01_JPRB,6.6368E-01_JPRB/)
KBO( :,42, 6) = (/&
&3.2073E-01_JPRB,3.7777E-01_JPRB,4.4039E-01_JPRB,5.0902E-01_JPRB,5.8559E-01_JPRB/)
KBO( :,43, 6) = (/&
&2.6920E-01_JPRB,3.2022E-01_JPRB,3.7707E-01_JPRB,4.4047E-01_JPRB,5.1263E-01_JPRB/)
KBO( :,44, 6) = (/&
&2.2419E-01_JPRB,2.6949E-01_JPRB,3.2089E-01_JPRB,3.7919E-01_JPRB,4.4668E-01_JPRB/)
KBO( :,45, 6) = (/&
&1.8610E-01_JPRB,2.2623E-01_JPRB,2.7250E-01_JPRB,3.2589E-01_JPRB,3.8881E-01_JPRB/)
KBO( :,46, 6) = (/&
&1.5321E-01_JPRB,1.8844E-01_JPRB,2.2973E-01_JPRB,2.7826E-01_JPRB,3.3646E-01_JPRB/)
KBO( :,47, 6) = (/&
&1.2434E-01_JPRB,1.5480E-01_JPRB,1.9116E-01_JPRB,2.3462E-01_JPRB,2.8768E-01_JPRB/)
KBO( :,48, 6) = (/&
&1.0036E-01_JPRB,1.2653E-01_JPRB,1.5835E-01_JPRB,1.9711E-01_JPRB,2.4528E-01_JPRB/)
KBO( :,49, 6) = (/&
&8.0612E-02_JPRB,1.0295E-01_JPRB,1.3061E-01_JPRB,1.6496E-01_JPRB,2.0845E-01_JPRB/)
KBO( :,50, 6) = (/&
&6.4743E-02_JPRB,8.3670E-02_JPRB,1.0758E-01_JPRB,1.3777E-01_JPRB,1.7673E-01_JPRB/)
KBO( :,51, 6) = (/&
&5.1836E-02_JPRB,6.7752E-02_JPRB,8.8282E-02_JPRB,1.1466E-01_JPRB,1.4926E-01_JPRB/)
KBO( :,52, 6) = (/&
&4.1270E-02_JPRB,5.4579E-02_JPRB,7.2088E-02_JPRB,9.5008E-02_JPRB,1.2557E-01_JPRB/)
KBO( :,53, 6) = (/&
&3.2703E-02_JPRB,4.3723E-02_JPRB,5.8551E-02_JPRB,7.8358E-02_JPRB,1.0523E-01_JPRB/)
KBO( :,54, 6) = (/&
&2.5932E-02_JPRB,3.5025E-02_JPRB,4.7496E-02_JPRB,6.4433E-02_JPRB,8.7763E-02_JPRB/)
KBO( :,55, 6) = (/&
&2.0516E-02_JPRB,2.7980E-02_JPRB,3.8384E-02_JPRB,5.2720E-02_JPRB,7.2773E-02_JPRB/)
KBO( :,56, 6) = (/&
&1.6157E-02_JPRB,2.2243E-02_JPRB,3.0860E-02_JPRB,4.2933E-02_JPRB,6.0054E-02_JPRB/)
KBO( :,57, 6) = (/&
&1.2662E-02_JPRB,1.7594E-02_JPRB,2.4676E-02_JPRB,3.4773E-02_JPRB,4.9299E-02_JPRB/)
KBO( :,58, 6) = (/&
&9.9314E-03_JPRB,1.3912E-02_JPRB,1.9723E-02_JPRB,2.8150E-02_JPRB,4.0439E-02_JPRB/)
KBO( :,59, 6) = (/&
&8.2224E-03_JPRB,1.1623E-02_JPRB,1.6659E-02_JPRB,2.4055E-02_JPRB,3.5006E-02_JPRB/)
KBO( :,13, 7) = (/&
&2.6335E+01_JPRB,2.6343E+01_JPRB,2.6317E+01_JPRB,2.6278E+01_JPRB,2.6240E+01_JPRB/)
KBO( :,14, 7) = (/&
&2.4335E+01_JPRB,2.4368E+01_JPRB,2.4378E+01_JPRB,2.4360E+01_JPRB,2.4346E+01_JPRB/)
KBO( :,15, 7) = (/&
&2.2209E+01_JPRB,2.2271E+01_JPRB,2.2317E+01_JPRB,2.2351E+01_JPRB,2.2363E+01_JPRB/)
KBO( :,16, 7) = (/&
&2.0041E+01_JPRB,2.0151E+01_JPRB,2.0235E+01_JPRB,2.0297E+01_JPRB,2.0322E+01_JPRB/)
KBO( :,17, 7) = (/&
&1.7927E+01_JPRB,1.8060E+01_JPRB,1.8168E+01_JPRB,1.8242E+01_JPRB,1.8304E+01_JPRB/)
KBO( :,18, 7) = (/&
&1.5898E+01_JPRB,1.6045E+01_JPRB,1.6164E+01_JPRB,1.6266E+01_JPRB,1.6378E+01_JPRB/)
KBO( :,19, 7) = (/&
&1.3992E+01_JPRB,1.4142E+01_JPRB,1.4282E+01_JPRB,1.4427E+01_JPRB,1.4606E+01_JPRB/)
KBO( :,20, 7) = (/&
&1.2229E+01_JPRB,1.2396E+01_JPRB,1.2574E+01_JPRB,1.2781E+01_JPRB,1.3031E+01_JPRB/)
KBO( :,21, 7) = (/&
&1.0639E+01_JPRB,1.0839E+01_JPRB,1.1068E+01_JPRB,1.1335E+01_JPRB,1.1649E+01_JPRB/)
KBO( :,22, 7) = (/&
&9.2636E+00_JPRB,9.5053E+00_JPRB,9.7840E+00_JPRB,1.0108E+01_JPRB,1.0461E+01_JPRB/)
KBO( :,23, 7) = (/&
&8.0952E+00_JPRB,8.3738E+00_JPRB,8.6908E+00_JPRB,9.0366E+00_JPRB,9.4060E+00_JPRB/)
KBO( :,24, 7) = (/&
&7.1130E+00_JPRB,7.4146E+00_JPRB,7.7429E+00_JPRB,8.0993E+00_JPRB,8.4864E+00_JPRB/)
KBO( :,25, 7) = (/&
&6.2837E+00_JPRB,6.5877E+00_JPRB,6.9205E+00_JPRB,7.2883E+00_JPRB,7.6912E+00_JPRB/)
KBO( :,26, 7) = (/&
&5.5745E+00_JPRB,5.8760E+00_JPRB,6.2151E+00_JPRB,6.5923E+00_JPRB,7.0080E+00_JPRB/)
KBO( :,27, 7) = (/&
&4.9643E+00_JPRB,5.2682E+00_JPRB,5.6134E+00_JPRB,5.9978E+00_JPRB,6.4129E+00_JPRB/)
KBO( :,28, 7) = (/&
&4.4473E+00_JPRB,4.7539E+00_JPRB,5.1020E+00_JPRB,5.4857E+00_JPRB,5.8980E+00_JPRB/)
KBO( :,29, 7) = (/&
&4.0139E+00_JPRB,4.3228E+00_JPRB,4.6679E+00_JPRB,5.0477E+00_JPRB,5.4611E+00_JPRB/)
KBO( :,30, 7) = (/&
&3.6503E+00_JPRB,3.9570E+00_JPRB,4.2982E+00_JPRB,4.6765E+00_JPRB,5.0904E+00_JPRB/)
KBO( :,31, 7) = (/&
&3.3458E+00_JPRB,3.6492E+00_JPRB,3.9896E+00_JPRB,4.3657E+00_JPRB,4.7803E+00_JPRB/)
KBO( :,32, 7) = (/&
&3.0885E+00_JPRB,3.3924E+00_JPRB,3.7326E+00_JPRB,4.1089E+00_JPRB,4.5242E+00_JPRB/)
KBO( :,33, 7) = (/&
&2.8733E+00_JPRB,3.1791E+00_JPRB,3.5210E+00_JPRB,3.8996E+00_JPRB,4.3193E+00_JPRB/)
KBO( :,34, 7) = (/&
&2.6844E+00_JPRB,2.9924E+00_JPRB,3.3348E+00_JPRB,3.7181E+00_JPRB,4.1445E+00_JPRB/)
KBO( :,35, 7) = (/&
&2.4984E+00_JPRB,2.8075E+00_JPRB,3.1505E+00_JPRB,3.5359E+00_JPRB,3.9675E+00_JPRB/)
KBO( :,36, 7) = (/&
&2.3072E+00_JPRB,2.6159E+00_JPRB,2.9582E+00_JPRB,3.3431E+00_JPRB,3.7763E+00_JPRB/)
KBO( :,37, 7) = (/&
&2.0954E+00_JPRB,2.4005E+00_JPRB,2.7380E+00_JPRB,3.1168E+00_JPRB,3.5461E+00_JPRB/)
KBO( :,38, 7) = (/&
&1.9034E+00_JPRB,2.2055E+00_JPRB,2.5402E+00_JPRB,2.9151E+00_JPRB,3.3403E+00_JPRB/)
KBO( :,39, 7) = (/&
&1.7317E+00_JPRB,2.0312E+00_JPRB,2.3647E+00_JPRB,2.7379E+00_JPRB,3.1615E+00_JPRB/)
KBO( :,40, 7) = (/&
&1.5481E+00_JPRB,1.8407E+00_JPRB,2.1704E+00_JPRB,2.5377E+00_JPRB,2.9544E+00_JPRB/)
KBO( :,41, 7) = (/&
&1.3778E+00_JPRB,1.6628E+00_JPRB,1.9879E+00_JPRB,2.3508E+00_JPRB,2.7602E+00_JPRB/)
KBO( :,42, 7) = (/&
&1.2232E+00_JPRB,1.4999E+00_JPRB,1.8203E+00_JPRB,2.1797E+00_JPRB,2.5828E+00_JPRB/)
KBO( :,43, 7) = (/&
&1.0698E+00_JPRB,1.3347E+00_JPRB,1.6469E+00_JPRB,2.0008E+00_JPRB,2.3963E+00_JPRB/)
KBO( :,44, 7) = (/&
&9.2588E-01_JPRB,1.1760E+00_JPRB,1.4777E+00_JPRB,1.8247E+00_JPRB,2.2132E+00_JPRB/)
KBO( :,45, 7) = (/&
&7.9702E-01_JPRB,1.0315E+00_JPRB,1.3210E+00_JPRB,1.6600E+00_JPRB,2.0420E+00_JPRB/)
KBO( :,46, 7) = (/&
&6.7818E-01_JPRB,8.9459E-01_JPRB,1.1684E+00_JPRB,1.4973E+00_JPRB,1.8716E+00_JPRB/)
KBO( :,47, 7) = (/&
&5.6580E-01_JPRB,7.6097E-01_JPRB,1.0151E+00_JPRB,1.3286E+00_JPRB,1.6923E+00_JPRB/)
KBO( :,48, 7) = (/&
&4.6791E-01_JPRB,6.4213E-01_JPRB,8.7532E-01_JPRB,1.1714E+00_JPRB,1.5227E+00_JPRB/)
KBO( :,49, 7) = (/&
&3.8353E-01_JPRB,5.3743E-01_JPRB,7.4923E-01_JPRB,1.0257E+00_JPRB,1.3624E+00_JPRB/)
KBO( :,50, 7) = (/&
&3.1398E-01_JPRB,4.4906E-01_JPRB,6.4014E-01_JPRB,8.9685E-01_JPRB,1.2172E+00_JPRB/)
KBO( :,51, 7) = (/&
&2.5573E-01_JPRB,3.7326E-01_JPRB,5.4427E-01_JPRB,7.8065E-01_JPRB,1.0832E+00_JPRB/)
KBO( :,52, 7) = (/&
&2.0647E-01_JPRB,3.0764E-01_JPRB,4.5931E-01_JPRB,6.7487E-01_JPRB,9.5820E-01_JPRB/)
KBO( :,53, 7) = (/&
&1.6527E-01_JPRB,2.5130E-01_JPRB,3.8436E-01_JPRB,5.7911E-01_JPRB,8.4227E-01_JPRB/)
KBO( :,54, 7) = (/&
&1.3250E-01_JPRB,2.0520E-01_JPRB,3.2144E-01_JPRB,4.9663E-01_JPRB,7.3948E-01_JPRB/)
KBO( :,55, 7) = (/&
&1.0586E-01_JPRB,1.6687E-01_JPRB,2.6744E-01_JPRB,4.2379E-01_JPRB,6.4623E-01_JPRB/)
KBO( :,56, 7) = (/&
&8.3917E-02_JPRB,1.3459E-01_JPRB,2.2056E-01_JPRB,3.5886E-01_JPRB,5.6114E-01_JPRB/)
KBO( :,57, 7) = (/&
&6.5997E-02_JPRB,1.0758E-01_JPRB,1.8019E-01_JPRB,3.0131E-01_JPRB,4.8364E-01_JPRB/)
KBO( :,58, 7) = (/&
&5.1899E-02_JPRB,8.5940E-02_JPRB,1.4705E-01_JPRB,2.5263E-01_JPRB,4.1642E-01_JPRB/)
KBO( :,59, 7) = (/&
&4.4275E-02_JPRB,7.4915E-02_JPRB,1.3121E-01_JPRB,2.3019E-01_JPRB,3.8591E-01_JPRB/)
KBO( :,13, 8) = (/&
&5.0965E+01_JPRB,5.0361E+01_JPRB,4.9768E+01_JPRB,4.9177E+01_JPRB,4.8632E+01_JPRB/)
KBO( :,14, 8) = (/&
&4.9580E+01_JPRB,4.9133E+01_JPRB,4.8669E+01_JPRB,4.8207E+01_JPRB,4.7744E+01_JPRB/)
KBO( :,15, 8) = (/&
&4.7755E+01_JPRB,4.7423E+01_JPRB,4.7054E+01_JPRB,4.6684E+01_JPRB,4.6310E+01_JPRB/)
KBO( :,16, 8) = (/&
&4.5437E+01_JPRB,4.5197E+01_JPRB,4.4948E+01_JPRB,4.4674E+01_JPRB,4.4398E+01_JPRB/)
KBO( :,17, 8) = (/&
&4.2668E+01_JPRB,4.2548E+01_JPRB,4.2401E+01_JPRB,4.2228E+01_JPRB,4.2024E+01_JPRB/)
KBO( :,18, 8) = (/&
&3.9590E+01_JPRB,3.9566E+01_JPRB,3.9492E+01_JPRB,3.9393E+01_JPRB,3.9273E+01_JPRB/)
KBO( :,19, 8) = (/&
&3.6298E+01_JPRB,3.6335E+01_JPRB,3.6351E+01_JPRB,3.6334E+01_JPRB,3.6282E+01_JPRB/)
KBO( :,20, 8) = (/&
&3.2906E+01_JPRB,3.3017E+01_JPRB,3.3099E+01_JPRB,3.3142E+01_JPRB,3.3168E+01_JPRB/)
KBO( :,21, 8) = (/&
&2.9547E+01_JPRB,2.9709E+01_JPRB,2.9845E+01_JPRB,2.9969E+01_JPRB,3.0103E+01_JPRB/)
KBO( :,22, 8) = (/&
&2.6311E+01_JPRB,2.6524E+01_JPRB,2.6733E+01_JPRB,2.6954E+01_JPRB,2.7222E+01_JPRB/)
KBO( :,23, 8) = (/&
&2.3277E+01_JPRB,2.3556E+01_JPRB,2.3854E+01_JPRB,2.4204E+01_JPRB,2.4638E+01_JPRB/)
KBO( :,24, 8) = (/&
&2.0517E+01_JPRB,2.0874E+01_JPRB,2.1304E+01_JPRB,2.1801E+01_JPRB,2.2391E+01_JPRB/)
KBO( :,25, 8) = (/&
&1.8081E+01_JPRB,1.8550E+01_JPRB,1.9103E+01_JPRB,1.9746E+01_JPRB,2.0474E+01_JPRB/)
KBO( :,26, 8) = (/&
&1.6011E+01_JPRB,1.6594E+01_JPRB,1.7264E+01_JPRB,1.8029E+01_JPRB,1.8873E+01_JPRB/)
KBO( :,27, 8) = (/&
&1.4287E+01_JPRB,1.4961E+01_JPRB,1.5728E+01_JPRB,1.6587E+01_JPRB,1.7528E+01_JPRB/)
KBO( :,28, 8) = (/&
&1.2856E+01_JPRB,1.3605E+01_JPRB,1.4442E+01_JPRB,1.5375E+01_JPRB,1.6398E+01_JPRB/)
KBO( :,29, 8) = (/&
&1.1675E+01_JPRB,1.2478E+01_JPRB,1.3380E+01_JPRB,1.4384E+01_JPRB,1.5477E+01_JPRB/)
KBO( :,30, 8) = (/&
&1.0695E+01_JPRB,1.1550E+01_JPRB,1.2511E+01_JPRB,1.3578E+01_JPRB,1.4743E+01_JPRB/)
KBO( :,31, 8) = (/&
&9.8981E+00_JPRB,1.0807E+01_JPRB,1.1824E+01_JPRB,1.2957E+01_JPRB,1.4200E+01_JPRB/)
KBO( :,32, 8) = (/&
&9.2617E+00_JPRB,1.0217E+01_JPRB,1.1294E+01_JPRB,1.2501E+01_JPRB,1.3819E+01_JPRB/)
KBO( :,33, 8) = (/&
&8.7596E+00_JPRB,9.7694E+00_JPRB,1.0911E+01_JPRB,1.2196E+01_JPRB,1.3598E+01_JPRB/)
KBO( :,34, 8) = (/&
&8.3433E+00_JPRB,9.4056E+00_JPRB,1.0617E+01_JPRB,1.1977E+01_JPRB,1.3459E+01_JPRB/)
KBO( :,35, 8) = (/&
&7.9357E+00_JPRB,9.0427E+00_JPRB,1.0314E+01_JPRB,1.1736E+01_JPRB,1.3286E+01_JPRB/)
KBO( :,36, 8) = (/&
&7.5046E+00_JPRB,8.6413E+00_JPRB,9.9524E+00_JPRB,1.1425E+01_JPRB,1.3024E+01_JPRB/)
KBO( :,37, 8) = (/&
&6.9879E+00_JPRB,8.1265E+00_JPRB,9.4503E+00_JPRB,1.0942E+01_JPRB,1.2567E+01_JPRB/)
KBO( :,38, 8) = (/&
&6.5288E+00_JPRB,7.6643E+00_JPRB,8.9952E+00_JPRB,1.0502E+01_JPRB,1.2144E+01_JPRB/)
KBO( :,39, 8) = (/&
&6.1286E+00_JPRB,7.2600E+00_JPRB,8.5928E+00_JPRB,1.0109E+01_JPRB,1.1767E+01_JPRB/)
KBO( :,40, 8) = (/&
&5.6684E+00_JPRB,6.7740E+00_JPRB,8.0799E+00_JPRB,9.5804E+00_JPRB,1.1233E+01_JPRB/)
KBO( :,41, 8) = (/&
&5.2402E+00_JPRB,6.3138E+00_JPRB,7.5882E+00_JPRB,9.0624E+00_JPRB,1.0701E+01_JPRB/)
KBO( :,42, 8) = (/&
&4.8506E+00_JPRB,5.8918E+00_JPRB,7.1323E+00_JPRB,8.5740E+00_JPRB,1.0194E+01_JPRB/)
KBO( :,43, 8) = (/&
&4.4438E+00_JPRB,5.4412E+00_JPRB,6.6345E+00_JPRB,8.0293E+00_JPRB,9.6145E+00_JPRB/)
KBO( :,44, 8) = (/&
&4.0493E+00_JPRB,4.9983E+00_JPRB,6.1400E+00_JPRB,7.4797E+00_JPRB,9.0187E+00_JPRB/)
KBO( :,45, 8) = (/&
&3.6876E+00_JPRB,4.5888E+00_JPRB,5.6785E+00_JPRB,6.9623E+00_JPRB,8.4500E+00_JPRB/)
KBO( :,46, 8) = (/&
&3.3383E+00_JPRB,4.1880E+00_JPRB,5.2207E+00_JPRB,6.4454E+00_JPRB,7.8745E+00_JPRB/)
KBO( :,47, 8) = (/&
&2.9856E+00_JPRB,3.7780E+00_JPRB,4.7472E+00_JPRB,5.9041E+00_JPRB,7.2615E+00_JPRB/)
KBO( :,48, 8) = (/&
&2.6572E+00_JPRB,3.4003E+00_JPRB,4.3078E+00_JPRB,5.3986E+00_JPRB,6.6852E+00_JPRB/)
KBO( :,49, 8) = (/&
&2.3488E+00_JPRB,3.0535E+00_JPRB,3.9013E+00_JPRB,4.9276E+00_JPRB,6.1472E+00_JPRB/)
KBO( :,50, 8) = (/&
&2.0729E+00_JPRB,2.7473E+00_JPRB,3.5436E+00_JPRB,4.5091E+00_JPRB,5.6655E+00_JPRB/)
KBO( :,51, 8) = (/&
&1.8206E+00_JPRB,2.4651E+00_JPRB,3.2190E+00_JPRB,4.1264E+00_JPRB,5.2204E+00_JPRB/)
KBO( :,52, 8) = (/&
&1.5859E+00_JPRB,2.1977E+00_JPRB,2.9176E+00_JPRB,3.7698E+00_JPRB,4.8036E+00_JPRB/)
KBO( :,53, 8) = (/&
&1.3682E+00_JPRB,1.9445E+00_JPRB,2.6333E+00_JPRB,3.4378E+00_JPRB,4.4138E+00_JPRB/)
KBO( :,54, 8) = (/&
&1.1812E+00_JPRB,1.7215E+00_JPRB,2.3803E+00_JPRB,3.1453E+00_JPRB,4.0633E+00_JPRB/)
KBO( :,55, 8) = (/&
&1.0150E+00_JPRB,1.5193E+00_JPRB,2.1463E+00_JPRB,2.8770E+00_JPRB,3.7398E+00_JPRB/)
KBO( :,56, 8) = (/&
&8.6368E-01_JPRB,1.3309E+00_JPRB,1.9241E+00_JPRB,2.6237E+00_JPRB,3.4375E+00_JPRB/)
KBO( :,57, 8) = (/&
&7.2682E-01_JPRB,1.1556E+00_JPRB,1.7137E+00_JPRB,2.3824E+00_JPRB,3.1551E+00_JPRB/)
KBO( :,58, 8) = (/&
&6.0967E-01_JPRB,1.0012E+00_JPRB,1.5247E+00_JPRB,2.1627E+00_JPRB,2.9020E+00_JPRB/)
KBO( :,59, 8) = (/&
&5.5853E-01_JPRB,9.3598E-01_JPRB,1.4448E+00_JPRB,2.0692E+00_JPRB,2.7925E+00_JPRB/)
KBO( :,13, 9) = (/&
&9.9288E+01_JPRB,9.7856E+01_JPRB,9.6419E+01_JPRB,9.4961E+01_JPRB,9.3473E+01_JPRB/)
KBO( :,14, 9) = (/&
&1.0412E+02_JPRB,1.0269E+02_JPRB,1.0123E+02_JPRB,9.9736E+01_JPRB,9.8238E+01_JPRB/)
KBO( :,15, 9) = (/&
&1.0817E+02_JPRB,1.0679E+02_JPRB,1.0540E+02_JPRB,1.0396E+02_JPRB,1.0249E+02_JPRB/)
KBO( :,16, 9) = (/&
&1.1129E+02_JPRB,1.1004E+02_JPRB,1.0873E+02_JPRB,1.0740E+02_JPRB,1.0603E+02_JPRB/)
KBO( :,17, 9) = (/&
&1.1340E+02_JPRB,1.1230E+02_JPRB,1.1113E+02_JPRB,1.0995E+02_JPRB,1.0873E+02_JPRB/)
KBO( :,18, 9) = (/&
&1.1434E+02_JPRB,1.1342E+02_JPRB,1.1248E+02_JPRB,1.1144E+02_JPRB,1.1034E+02_JPRB/)
KBO( :,19, 9) = (/&
&1.1401E+02_JPRB,1.1333E+02_JPRB,1.1256E+02_JPRB,1.1172E+02_JPRB,1.1083E+02_JPRB/)
KBO( :,20, 9) = (/&
&1.1234E+02_JPRB,1.1193E+02_JPRB,1.1143E+02_JPRB,1.1085E+02_JPRB,1.1019E+02_JPRB/)
KBO( :,21, 9) = (/&
&1.0946E+02_JPRB,1.0935E+02_JPRB,1.0914E+02_JPRB,1.0884E+02_JPRB,1.0846E+02_JPRB/)
KBO( :,22, 9) = (/&
&1.0557E+02_JPRB,1.0577E+02_JPRB,1.0588E+02_JPRB,1.0590E+02_JPRB,1.0584E+02_JPRB/)
KBO( :,23, 9) = (/&
&1.0094E+02_JPRB,1.0149E+02_JPRB,1.0194E+02_JPRB,1.0233E+02_JPRB,1.0260E+02_JPRB/)
KBO( :,24, 9) = (/&
&9.5817E+01_JPRB,9.6736E+01_JPRB,9.7569E+01_JPRB,9.8330E+01_JPRB,9.9010E+01_JPRB/)
KBO( :,25, 9) = (/&
&9.0469E+01_JPRB,9.1797E+01_JPRB,9.3074E+01_JPRB,9.4238E+01_JPRB,9.5339E+01_JPRB/)
KBO( :,26, 9) = (/&
&8.5212E+01_JPRB,8.6963E+01_JPRB,8.8676E+01_JPRB,9.0313E+01_JPRB,9.1842E+01_JPRB/)
KBO( :,27, 9) = (/&
&8.0235E+01_JPRB,8.2437E+01_JPRB,8.4599E+01_JPRB,8.6731E+01_JPRB,8.8747E+01_JPRB/)
KBO( :,28, 9) = (/&
&7.5722E+01_JPRB,7.8382E+01_JPRB,8.1040E+01_JPRB,8.3660E+01_JPRB,8.6177E+01_JPRB/)
KBO( :,29, 9) = (/&
&7.1851E+01_JPRB,7.4992E+01_JPRB,7.8130E+01_JPRB,8.1223E+01_JPRB,8.4209E+01_JPRB/)
KBO( :,30, 9) = (/&
&6.8679E+01_JPRB,7.2286E+01_JPRB,7.5891E+01_JPRB,7.9421E+01_JPRB,8.2811E+01_JPRB/)
KBO( :,31, 9) = (/&
&6.6225E+01_JPRB,7.0279E+01_JPRB,7.4326E+01_JPRB,7.8245E+01_JPRB,8.1966E+01_JPRB/)
KBO( :,32, 9) = (/&
&6.4479E+01_JPRB,6.8946E+01_JPRB,7.3367E+01_JPRB,7.7627E+01_JPRB,8.1643E+01_JPRB/)
KBO( :,33, 9) = (/&
&6.3393E+01_JPRB,6.8225E+01_JPRB,7.2967E+01_JPRB,7.7506E+01_JPRB,8.1771E+01_JPRB/)
KBO( :,34, 9) = (/&
&6.2705E+01_JPRB,6.7842E+01_JPRB,7.2848E+01_JPRB,7.7622E+01_JPRB,8.2086E+01_JPRB/)
KBO( :,35, 9) = (/&
&6.1970E+01_JPRB,6.7369E+01_JPRB,7.2611E+01_JPRB,7.7614E+01_JPRB,8.2278E+01_JPRB/)
KBO( :,36, 9) = (/&
&6.0967E+01_JPRB,6.6598E+01_JPRB,7.2072E+01_JPRB,7.7300E+01_JPRB,8.2185E+01_JPRB/)
KBO( :,37, 9) = (/&
&5.9279E+01_JPRB,6.5142E+01_JPRB,7.0846E+01_JPRB,7.6292E+01_JPRB,8.1436E+01_JPRB/)
KBO( :,38, 9) = (/&
&5.7701E+01_JPRB,6.3776E+01_JPRB,6.9699E+01_JPRB,7.5382E+01_JPRB,8.0760E+01_JPRB/)
KBO( :,39, 9) = (/&
&5.6270E+01_JPRB,6.2546E+01_JPRB,6.8688E+01_JPRB,7.4617E+01_JPRB,8.0162E+01_JPRB/)
KBO( :,40, 9) = (/&
&5.4230E+01_JPRB,6.0690E+01_JPRB,6.6996E+01_JPRB,7.3138E+01_JPRB,7.8857E+01_JPRB/)
KBO( :,41, 9) = (/&
&5.2156E+01_JPRB,5.8758E+01_JPRB,6.5235E+01_JPRB,7.1572E+01_JPRB,7.7464E+01_JPRB/)
KBO( :,42, 9) = (/&
&5.0129E+01_JPRB,5.6855E+01_JPRB,6.3499E+01_JPRB,7.0016E+01_JPRB,7.6080E+01_JPRB/)
KBO( :,43, 9) = (/&
&4.7760E+01_JPRB,5.4598E+01_JPRB,6.1399E+01_JPRB,6.8099E+01_JPRB,7.4350E+01_JPRB/)
KBO( :,44, 9) = (/&
&4.5249E+01_JPRB,5.2184E+01_JPRB,5.9131E+01_JPRB,6.6010E+01_JPRB,7.2452E+01_JPRB/)
KBO( :,45, 9) = (/&
&4.2770E+01_JPRB,4.9790E+01_JPRB,5.6875E+01_JPRB,6.3919E+01_JPRB,7.0547E+01_JPRB/)
KBO( :,46, 9) = (/&
&4.0163E+01_JPRB,4.7243E+01_JPRB,5.4479E+01_JPRB,6.1655E+01_JPRB,6.8464E+01_JPRB/)
KBO( :,47, 9) = (/&
&3.7279E+01_JPRB,4.4372E+01_JPRB,5.1688E+01_JPRB,5.9007E+01_JPRB,6.6000E+01_JPRB/)
KBO( :,48, 9) = (/&
&3.4455E+01_JPRB,4.1531E+01_JPRB,4.8914E+01_JPRB,5.6355E+01_JPRB,6.3516E+01_JPRB/)
KBO( :,49, 9) = (/&
&3.1707E+01_JPRB,3.8733E+01_JPRB,4.6179E+01_JPRB,5.3719E+01_JPRB,6.1038E+01_JPRB/)
KBO( :,50, 9) = (/&
&2.9168E+01_JPRB,3.6084E+01_JPRB,4.3531E+01_JPRB,5.1127E+01_JPRB,5.8574E+01_JPRB/)
KBO( :,51, 9) = (/&
&2.6765E+01_JPRB,3.3523E+01_JPRB,4.0920E+01_JPRB,4.8550E+01_JPRB,5.6098E+01_JPRB/)
KBO( :,52, 9) = (/&
&2.4432E+01_JPRB,3.1037E+01_JPRB,3.8359E+01_JPRB,4.5995E+01_JPRB,5.3635E+01_JPRB/)
KBO( :,53, 9) = (/&
&2.2208E+01_JPRB,2.8629E+01_JPRB,3.5855E+01_JPRB,4.3474E+01_JPRB,5.1186E+01_JPRB/)
KBO( :,54, 9) = (/&
&2.0205E+01_JPRB,2.6401E+01_JPRB,3.3414E+01_JPRB,4.0973E+01_JPRB,4.8699E+01_JPRB/)
KBO( :,55, 9) = (/&
&1.8353E+01_JPRB,2.4282E+01_JPRB,3.1024E+01_JPRB,3.8470E+01_JPRB,4.6173E+01_JPRB/)
KBO( :,56, 9) = (/&
&1.6601E+01_JPRB,2.2262E+01_JPRB,2.8733E+01_JPRB,3.6003E+01_JPRB,4.3640E+01_JPRB/)
KBO( :,57, 9) = (/&
&1.4942E+01_JPRB,2.0332E+01_JPRB,2.6541E+01_JPRB,3.3571E+01_JPRB,4.1137E+01_JPRB/)
KBO( :,58, 9) = (/&
&1.3455E+01_JPRB,1.8580E+01_JPRB,2.4530E+01_JPRB,3.1284E+01_JPRB,3.8733E+01_JPRB/)
KBO( :,59, 9) = (/&
&1.2865E+01_JPRB,1.7859E+01_JPRB,2.3642E+01_JPRB,3.0152E+01_JPRB,3.7359E+01_JPRB/)
KBO( :,13,10) = (/&
&1.4836E+02_JPRB,1.4604E+02_JPRB,1.4370E+02_JPRB,1.4155E+02_JPRB,1.3951E+02_JPRB/)
KBO( :,14,10) = (/&
&1.6431E+02_JPRB,1.6174E+02_JPRB,1.5931E+02_JPRB,1.5707E+02_JPRB,1.5447E+02_JPRB/)
KBO( :,15,10) = (/&
&1.8088E+02_JPRB,1.7844E+02_JPRB,1.7598E+02_JPRB,1.7321E+02_JPRB,1.7049E+02_JPRB/)
KBO( :,16,10) = (/&
&1.9837E+02_JPRB,1.9582E+02_JPRB,1.9294E+02_JPRB,1.9007E+02_JPRB,1.8732E+02_JPRB/)
KBO( :,17,10) = (/&
&2.1550E+02_JPRB,2.1268E+02_JPRB,2.0959E+02_JPRB,2.0637E+02_JPRB,2.0299E+02_JPRB/)
KBO( :,18,10) = (/&
&2.3147E+02_JPRB,2.2811E+02_JPRB,2.2491E+02_JPRB,2.2179E+02_JPRB,2.1873E+02_JPRB/)
KBO( :,19,10) = (/&
&2.4561E+02_JPRB,2.4282E+02_JPRB,2.3998E+02_JPRB,2.3673E+02_JPRB,2.3333E+02_JPRB/)
KBO( :,20,10) = (/&
&2.5875E+02_JPRB,2.5597E+02_JPRB,2.5299E+02_JPRB,2.4975E+02_JPRB,2.4650E+02_JPRB/)
KBO( :,21,10) = (/&
&2.6956E+02_JPRB,2.6694E+02_JPRB,2.6416E+02_JPRB,2.6126E+02_JPRB,2.5829E+02_JPRB/)
KBO( :,22,10) = (/&
&2.7742E+02_JPRB,2.7556E+02_JPRB,2.7346E+02_JPRB,2.7109E+02_JPRB,2.6822E+02_JPRB/)
KBO( :,23,10) = (/&
&2.8259E+02_JPRB,2.8167E+02_JPRB,2.8054E+02_JPRB,2.7877E+02_JPRB,2.7640E+02_JPRB/)
KBO( :,24,10) = (/&
&2.8579E+02_JPRB,2.8593E+02_JPRB,2.8555E+02_JPRB,2.8452E+02_JPRB,2.8281E+02_JPRB/)
KBO( :,25,10) = (/&
&2.8759E+02_JPRB,2.8855E+02_JPRB,2.8897E+02_JPRB,2.8899E+02_JPRB,2.8805E+02_JPRB/)
KBO( :,26,10) = (/&
&2.8827E+02_JPRB,2.9039E+02_JPRB,2.9171E+02_JPRB,2.9254E+02_JPRB,2.9232E+02_JPRB/)
KBO( :,27,10) = (/&
&2.8831E+02_JPRB,2.9160E+02_JPRB,2.9410E+02_JPRB,2.9547E+02_JPRB,2.9582E+02_JPRB/)
KBO( :,28,10) = (/&
&2.8830E+02_JPRB,2.9281E+02_JPRB,2.9591E+02_JPRB,2.9817E+02_JPRB,2.9880E+02_JPRB/)
KBO( :,29,10) = (/&
&2.8819E+02_JPRB,2.9390E+02_JPRB,2.9762E+02_JPRB,3.0035E+02_JPRB,3.0140E+02_JPRB/)
KBO( :,30,10) = (/&
&2.8853E+02_JPRB,2.9509E+02_JPRB,2.9931E+02_JPRB,3.0230E+02_JPRB,3.0384E+02_JPRB/)
KBO( :,31,10) = (/&
&2.8941E+02_JPRB,2.9638E+02_JPRB,3.0093E+02_JPRB,3.0407E+02_JPRB,3.0610E+02_JPRB/)
KBO( :,32,10) = (/&
&2.9067E+02_JPRB,2.9787E+02_JPRB,3.0275E+02_JPRB,3.0577E+02_JPRB,3.0795E+02_JPRB/)
KBO( :,33,10) = (/&
&2.9222E+02_JPRB,2.9942E+02_JPRB,3.0456E+02_JPRB,3.0752E+02_JPRB,3.0966E+02_JPRB/)
KBO( :,34,10) = (/&
&2.9363E+02_JPRB,3.0091E+02_JPRB,3.0608E+02_JPRB,3.0904E+02_JPRB,3.1115E+02_JPRB/)
KBO( :,35,10) = (/&
&2.9423E+02_JPRB,3.0182E+02_JPRB,3.0717E+02_JPRB,3.1018E+02_JPRB,3.1229E+02_JPRB/)
KBO( :,36,10) = (/&
&2.9400E+02_JPRB,3.0205E+02_JPRB,3.0771E+02_JPRB,3.1091E+02_JPRB,3.1314E+02_JPRB/)
KBO( :,37,10) = (/&
&2.9277E+02_JPRB,3.0116E+02_JPRB,3.0745E+02_JPRB,3.1132E+02_JPRB,3.1369E+02_JPRB/)
KBO( :,38,10) = (/&
&2.9103E+02_JPRB,3.0008E+02_JPRB,3.0698E+02_JPRB,3.1126E+02_JPRB,3.1405E+02_JPRB/)
KBO( :,39,10) = (/&
&2.8923E+02_JPRB,2.9890E+02_JPRB,3.0637E+02_JPRB,3.1107E+02_JPRB,3.1517E+02_JPRB/)
KBO( :,40,10) = (/&
&2.8609E+02_JPRB,2.9711E+02_JPRB,3.0497E+02_JPRB,3.1036E+02_JPRB,3.1550E+02_JPRB/)
KBO( :,41,10) = (/&
&2.8252E+02_JPRB,2.9448E+02_JPRB,3.0316E+02_JPRB,3.0942E+02_JPRB,3.1556E+02_JPRB/)
KBO( :,42,10) = (/&
&2.7862E+02_JPRB,2.9160E+02_JPRB,3.0113E+02_JPRB,3.0834E+02_JPRB,3.1556E+02_JPRB/)
KBO( :,43,10) = (/&
&2.7361E+02_JPRB,2.8779E+02_JPRB,2.9836E+02_JPRB,3.0666E+02_JPRB,3.1512E+02_JPRB/)
KBO( :,44,10) = (/&
&2.6782E+02_JPRB,2.8324E+02_JPRB,2.9499E+02_JPRB,3.0453E+02_JPRB,3.1441E+02_JPRB/)
KBO( :,45,10) = (/&
&2.6165E+02_JPRB,2.7823E+02_JPRB,2.9120E+02_JPRB,3.0219E+02_JPRB,3.1362E+02_JPRB/)
KBO( :,46,10) = (/&
&2.5462E+02_JPRB,2.7249E+02_JPRB,2.8693E+02_JPRB,2.9929E+02_JPRB,3.1228E+02_JPRB/)
KBO( :,47,10) = (/&
&2.4622E+02_JPRB,2.6556E+02_JPRB,2.8145E+02_JPRB,2.9525E+02_JPRB,3.0983E+02_JPRB/)
KBO( :,48,10) = (/&
&2.3713E+02_JPRB,2.5803E+02_JPRB,2.7541E+02_JPRB,2.9095E+02_JPRB,3.0719E+02_JPRB/)
KBO( :,49,10) = (/&
&2.2739E+02_JPRB,2.4986E+02_JPRB,2.6881E+02_JPRB,2.8662E+02_JPRB,3.0453E+02_JPRB/)
KBO( :,50,10) = (/&
&2.1772E+02_JPRB,2.4169E+02_JPRB,2.6202E+02_JPRB,2.8158E+02_JPRB,3.0094E+02_JPRB/)
KBO( :,51,10) = (/&
&2.0784E+02_JPRB,2.3330E+02_JPRB,2.5496E+02_JPRB,2.7591E+02_JPRB,2.9666E+02_JPRB/)
KBO( :,52,10) = (/&
&1.9746E+02_JPRB,2.2442E+02_JPRB,2.4742E+02_JPRB,2.7004E+02_JPRB,2.9216E+02_JPRB/)
KBO( :,53,10) = (/&
&1.8667E+02_JPRB,2.1498E+02_JPRB,2.3949E+02_JPRB,2.6404E+02_JPRB,2.8766E+02_JPRB/)
KBO( :,54,10) = (/&
&1.7641E+02_JPRB,2.0557E+02_JPRB,2.3152E+02_JPRB,2.5629E+02_JPRB,2.8134E+02_JPRB/)
KBO( :,55,10) = (/&
&1.6630E+02_JPRB,1.9645E+02_JPRB,2.2352E+02_JPRB,2.4801E+02_JPRB,2.7356E+02_JPRB/)
KBO( :,56,10) = (/&
&1.5594E+02_JPRB,1.8700E+02_JPRB,2.1520E+02_JPRB,2.3992E+02_JPRB,2.6576E+02_JPRB/)
KBO( :,57,10) = (/&
&1.4539E+02_JPRB,1.7728E+02_JPRB,2.0648E+02_JPRB,2.3204E+02_JPRB,2.5725E+02_JPRB/)
KBO( :,58,10) = (/&
&1.3524E+02_JPRB,1.6780E+02_JPRB,1.9789E+02_JPRB,2.2459E+02_JPRB,2.4918E+02_JPRB/)
KBO( :,59,10) = (/&
&1.3112E+02_JPRB,1.6391E+02_JPRB,1.9433E+02_JPRB,2.2152E+02_JPRB,2.4535E+02_JPRB/)
KBO( :,13,11) = (/&
&1.6552E+02_JPRB,1.6259E+02_JPRB,1.5976E+02_JPRB,1.5701E+02_JPRB,1.5440E+02_JPRB/)
KBO( :,14,11) = (/&
&1.8516E+02_JPRB,1.8233E+02_JPRB,1.7933E+02_JPRB,1.7635E+02_JPRB,1.7362E+02_JPRB/)
KBO( :,15,11) = (/&
&2.0794E+02_JPRB,2.0481E+02_JPRB,2.0174E+02_JPRB,1.9859E+02_JPRB,1.9534E+02_JPRB/)
KBO( :,16,11) = (/&
&2.3251E+02_JPRB,2.2934E+02_JPRB,2.2596E+02_JPRB,2.2193E+02_JPRB,2.1747E+02_JPRB/)
KBO( :,17,11) = (/&
&2.5822E+02_JPRB,2.5449E+02_JPRB,2.5028E+02_JPRB,2.4575E+02_JPRB,2.4111E+02_JPRB/)
KBO( :,18,11) = (/&
&2.8377E+02_JPRB,2.7983E+02_JPRB,2.7512E+02_JPRB,2.7022E+02_JPRB,2.6507E+02_JPRB/)
KBO( :,19,11) = (/&
&3.0872E+02_JPRB,3.0403E+02_JPRB,2.9887E+02_JPRB,2.9373E+02_JPRB,2.8833E+02_JPRB/)
KBO( :,20,11) = (/&
&3.3154E+02_JPRB,3.2667E+02_JPRB,3.2149E+02_JPRB,3.1658E+02_JPRB,3.1110E+02_JPRB/)
KBO( :,21,11) = (/&
&3.5303E+02_JPRB,3.4859E+02_JPRB,3.4368E+02_JPRB,3.3863E+02_JPRB,3.3281E+02_JPRB/)
KBO( :,22,11) = (/&
&3.7308E+02_JPRB,3.6866E+02_JPRB,3.6382E+02_JPRB,3.5853E+02_JPRB,3.5259E+02_JPRB/)
KBO( :,23,11) = (/&
&3.9085E+02_JPRB,3.8660E+02_JPRB,3.8185E+02_JPRB,3.7650E+02_JPRB,3.7123E+02_JPRB/)
KBO( :,24,11) = (/&
&4.0631E+02_JPRB,4.0255E+02_JPRB,3.9828E+02_JPRB,3.9348E+02_JPRB,3.8793E+02_JPRB/)
KBO( :,25,11) = (/&
&4.1938E+02_JPRB,4.1686E+02_JPRB,4.1282E+02_JPRB,4.0821E+02_JPRB,4.0269E+02_JPRB/)
KBO( :,26,11) = (/&
&4.3004E+02_JPRB,4.2864E+02_JPRB,4.2545E+02_JPRB,4.2097E+02_JPRB,4.1544E+02_JPRB/)
KBO( :,27,11) = (/&
&4.3932E+02_JPRB,4.3875E+02_JPRB,4.3604E+02_JPRB,4.3201E+02_JPRB,4.2641E+02_JPRB/)
KBO( :,28,11) = (/&
&4.4708E+02_JPRB,4.4715E+02_JPRB,4.4516E+02_JPRB,4.4121E+02_JPRB,4.3584E+02_JPRB/)
KBO( :,29,11) = (/&
&4.5390E+02_JPRB,4.5431E+02_JPRB,4.5282E+02_JPRB,4.4905E+02_JPRB,4.4353E+02_JPRB/)
KBO( :,30,11) = (/&
&4.5978E+02_JPRB,4.6051E+02_JPRB,4.5914E+02_JPRB,4.5563E+02_JPRB,4.4966E+02_JPRB/)
KBO( :,31,11) = (/&
&4.6502E+02_JPRB,4.6582E+02_JPRB,4.6429E+02_JPRB,4.6092E+02_JPRB,4.5451E+02_JPRB/)
KBO( :,32,11) = (/&
&4.6952E+02_JPRB,4.7023E+02_JPRB,4.6854E+02_JPRB,4.6499E+02_JPRB,4.5830E+02_JPRB/)
KBO( :,33,11) = (/&
&4.7348E+02_JPRB,4.7409E+02_JPRB,4.7192E+02_JPRB,4.6794E+02_JPRB,4.6103E+02_JPRB/)
KBO( :,34,11) = (/&
&4.7685E+02_JPRB,4.7731E+02_JPRB,4.7475E+02_JPRB,4.7028E+02_JPRB,4.6319E+02_JPRB/)
KBO( :,35,11) = (/&
&4.7958E+02_JPRB,4.8002E+02_JPRB,4.7736E+02_JPRB,4.7259E+02_JPRB,4.6551E+02_JPRB/)
KBO( :,36,11) = (/&
&4.8169E+02_JPRB,4.8240E+02_JPRB,4.7987E+02_JPRB,4.7499E+02_JPRB,4.6813E+02_JPRB/)
KBO( :,37,11) = (/&
&4.8298E+02_JPRB,4.8446E+02_JPRB,4.8243E+02_JPRB,4.7809E+02_JPRB,4.7147E+02_JPRB/)
KBO( :,38,11) = (/&
&4.8394E+02_JPRB,4.8606E+02_JPRB,4.8459E+02_JPRB,4.8068E+02_JPRB,4.7405E+02_JPRB/)
KBO( :,39,11) = (/&
&4.8451E+02_JPRB,4.8733E+02_JPRB,4.8637E+02_JPRB,4.8291E+02_JPRB,4.7658E+02_JPRB/)
KBO( :,40,11) = (/&
&4.8421E+02_JPRB,4.8736E+02_JPRB,4.8800E+02_JPRB,4.8523E+02_JPRB,4.7946E+02_JPRB/)
KBO( :,41,11) = (/&
&4.8335E+02_JPRB,4.8764E+02_JPRB,4.8927E+02_JPRB,4.8717E+02_JPRB,4.8206E+02_JPRB/)
KBO( :,42,11) = (/&
&4.8204E+02_JPRB,4.8748E+02_JPRB,4.9006E+02_JPRB,4.8875E+02_JPRB,4.8434E+02_JPRB/)
KBO( :,43,11) = (/&
&4.7975E+02_JPRB,4.8654E+02_JPRB,4.9041E+02_JPRB,4.9008E+02_JPRB,4.8652E+02_JPRB/)
KBO( :,44,11) = (/&
&4.7655E+02_JPRB,4.8494E+02_JPRB,4.9019E+02_JPRB,4.9098E+02_JPRB,4.8839E+02_JPRB/)
KBO( :,45,11) = (/&
&4.7253E+02_JPRB,4.8276E+02_JPRB,4.8943E+02_JPRB,4.9145E+02_JPRB,4.9003E+02_JPRB/)
KBO( :,46,11) = (/&
&4.6734E+02_JPRB,4.7968E+02_JPRB,4.8743E+02_JPRB,4.9144E+02_JPRB,4.9142E+02_JPRB/)
KBO( :,47,11) = (/&
&4.6037E+02_JPRB,4.7532E+02_JPRB,4.8503E+02_JPRB,4.9075E+02_JPRB,4.9230E+02_JPRB/)
KBO( :,48,11) = (/&
&4.5226E+02_JPRB,4.6987E+02_JPRB,4.8198E+02_JPRB,4.8932E+02_JPRB,4.9295E+02_JPRB/)
KBO( :,49,11) = (/&
&4.4290E+02_JPRB,4.6342E+02_JPRB,4.7813E+02_JPRB,4.8707E+02_JPRB,4.9364E+02_JPRB/)
KBO( :,50,11) = (/&
&4.3303E+02_JPRB,4.5634E+02_JPRB,4.7362E+02_JPRB,4.8430E+02_JPRB,4.9319E+02_JPRB/)
KBO( :,51,11) = (/&
&4.2231E+02_JPRB,4.4854E+02_JPRB,4.6823E+02_JPRB,4.8097E+02_JPRB,4.9173E+02_JPRB/)
KBO( :,52,11) = (/&
&4.1028E+02_JPRB,4.3983E+02_JPRB,4.6194E+02_JPRB,4.7695E+02_JPRB,4.9018E+02_JPRB/)
KBO( :,53,11) = (/&
&3.9747E+02_JPRB,4.3006E+02_JPRB,4.5475E+02_JPRB,4.7218E+02_JPRB,4.8896E+02_JPRB/)
KBO( :,54,11) = (/&
&3.8468E+02_JPRB,4.1991E+02_JPRB,4.4737E+02_JPRB,4.6699E+02_JPRB,4.8405E+02_JPRB/)
KBO( :,55,11) = (/&
&3.7148E+02_JPRB,4.0953E+02_JPRB,4.3953E+02_JPRB,4.6157E+02_JPRB,4.7789E+02_JPRB/)
KBO( :,56,11) = (/&
&3.5741E+02_JPRB,3.9825E+02_JPRB,4.3092E+02_JPRB,4.5516E+02_JPRB,4.7290E+02_JPRB/)
KBO( :,57,11) = (/&
&3.4261E+02_JPRB,3.8598E+02_JPRB,4.2152E+02_JPRB,4.4813E+02_JPRB,4.6777E+02_JPRB/)
KBO( :,58,11) = (/&
&3.2780E+02_JPRB,3.7359E+02_JPRB,4.1192E+02_JPRB,4.4072E+02_JPRB,4.6249E+02_JPRB/)
KBO( :,59,11) = (/&
&3.2152E+02_JPRB,3.6839E+02_JPRB,4.0780E+02_JPRB,4.3751E+02_JPRB,4.6016E+02_JPRB/)
KBO( :,13,12) = (/&
&1.8421E+02_JPRB,1.8166E+02_JPRB,1.7879E+02_JPRB,1.7574E+02_JPRB,1.7251E+02_JPRB/)
KBO( :,14,12) = (/&
&2.0903E+02_JPRB,2.0619E+02_JPRB,2.0324E+02_JPRB,1.9988E+02_JPRB,1.9636E+02_JPRB/)
KBO( :,15,12) = (/&
&2.3780E+02_JPRB,2.3442E+02_JPRB,2.3068E+02_JPRB,2.2666E+02_JPRB,2.2225E+02_JPRB/)
KBO( :,16,12) = (/&
&2.7012E+02_JPRB,2.6570E+02_JPRB,2.6084E+02_JPRB,2.5612E+02_JPRB,2.5162E+02_JPRB/)
KBO( :,17,12) = (/&
&3.0507E+02_JPRB,2.9990E+02_JPRB,2.9472E+02_JPRB,2.8913E+02_JPRB,2.8362E+02_JPRB/)
KBO( :,18,12) = (/&
&3.4264E+02_JPRB,3.3653E+02_JPRB,3.3027E+02_JPRB,3.2388E+02_JPRB,3.1713E+02_JPRB/)
KBO( :,19,12) = (/&
&3.8113E+02_JPRB,3.7455E+02_JPRB,3.6765E+02_JPRB,3.6040E+02_JPRB,3.5292E+02_JPRB/)
KBO( :,20,12) = (/&
&4.2119E+02_JPRB,4.1426E+02_JPRB,4.0655E+02_JPRB,3.9813E+02_JPRB,3.8981E+02_JPRB/)
KBO( :,21,12) = (/&
&4.6191E+02_JPRB,4.5363E+02_JPRB,4.4508E+02_JPRB,4.3611E+02_JPRB,4.2662E+02_JPRB/)
KBO( :,22,12) = (/&
&5.0045E+02_JPRB,4.9187E+02_JPRB,4.8228E+02_JPRB,4.7267E+02_JPRB,4.6269E+02_JPRB/)
KBO( :,23,12) = (/&
&5.3771E+02_JPRB,5.2859E+02_JPRB,5.1832E+02_JPRB,5.0803E+02_JPRB,4.9670E+02_JPRB/)
KBO( :,24,12) = (/&
&5.7227E+02_JPRB,5.6260E+02_JPRB,5.5214E+02_JPRB,5.4076E+02_JPRB,5.2846E+02_JPRB/)
KBO( :,25,12) = (/&
&6.0401E+02_JPRB,5.9384E+02_JPRB,5.8279E+02_JPRB,5.7065E+02_JPRB,5.5724E+02_JPRB/)
KBO( :,26,12) = (/&
&6.3275E+02_JPRB,6.2182E+02_JPRB,6.0975E+02_JPRB,5.9668E+02_JPRB,5.8248E+02_JPRB/)
KBO( :,27,12) = (/&
&6.5788E+02_JPRB,6.4612E+02_JPRB,6.3329E+02_JPRB,6.1912E+02_JPRB,6.0393E+02_JPRB/)
KBO( :,28,12) = (/&
&6.7977E+02_JPRB,6.6741E+02_JPRB,6.5368E+02_JPRB,6.3839E+02_JPRB,6.2186E+02_JPRB/)
KBO( :,29,12) = (/&
&6.9860E+02_JPRB,6.8540E+02_JPRB,6.7056E+02_JPRB,6.5407E+02_JPRB,6.3669E+02_JPRB/)
KBO( :,30,12) = (/&
&7.1428E+02_JPRB,7.0014E+02_JPRB,6.8436E+02_JPRB,6.6687E+02_JPRB,6.4843E+02_JPRB/)
KBO( :,31,12) = (/&
&7.2707E+02_JPRB,7.1224E+02_JPRB,6.9535E+02_JPRB,6.7679E+02_JPRB,6.5732E+02_JPRB/)
KBO( :,32,12) = (/&
&7.3739E+02_JPRB,7.2161E+02_JPRB,7.0352E+02_JPRB,6.8424E+02_JPRB,6.6374E+02_JPRB/)
KBO( :,33,12) = (/&
&7.4529E+02_JPRB,7.2852E+02_JPRB,7.0939E+02_JPRB,6.8945E+02_JPRB,6.6810E+02_JPRB/)
KBO( :,34,12) = (/&
&7.5166E+02_JPRB,7.3380E+02_JPRB,7.1390E+02_JPRB,6.9344E+02_JPRB,6.7141E+02_JPRB/)
KBO( :,35,12) = (/&
&7.5785E+02_JPRB,7.3918E+02_JPRB,7.1874E+02_JPRB,6.9799E+02_JPRB,6.7527E+02_JPRB/)
KBO( :,36,12) = (/&
&7.6435E+02_JPRB,7.4538E+02_JPRB,7.2454E+02_JPRB,7.0358E+02_JPRB,6.8040E+02_JPRB/)
KBO( :,37,12) = (/&
&7.7161E+02_JPRB,7.5340E+02_JPRB,7.3251E+02_JPRB,7.1089E+02_JPRB,6.8800E+02_JPRB/)
KBO( :,38,12) = (/&
&7.7853E+02_JPRB,7.6067E+02_JPRB,7.3983E+02_JPRB,7.1816E+02_JPRB,6.9536E+02_JPRB/)
KBO( :,39,12) = (/&
&7.8464E+02_JPRB,7.6713E+02_JPRB,7.4647E+02_JPRB,7.2475E+02_JPRB,7.0178E+02_JPRB/)
KBO( :,40,12) = (/&
&7.9160E+02_JPRB,7.7414E+02_JPRB,7.5465E+02_JPRB,7.3306E+02_JPRB,7.1009E+02_JPRB/)
KBO( :,41,12) = (/&
&7.9795E+02_JPRB,7.8137E+02_JPRB,7.6252E+02_JPRB,7.4117E+02_JPRB,7.1825E+02_JPRB/)
KBO( :,42,12) = (/&
&8.0363E+02_JPRB,7.8805E+02_JPRB,7.6985E+02_JPRB,7.4880E+02_JPRB,7.2604E+02_JPRB/)
KBO( :,43,12) = (/&
&8.0918E+02_JPRB,7.9503E+02_JPRB,7.7774E+02_JPRB,7.5724E+02_JPRB,7.3478E+02_JPRB/)
KBO( :,44,12) = (/&
&8.1405E+02_JPRB,8.0171E+02_JPRB,7.8561E+02_JPRB,7.6584E+02_JPRB,7.4379E+02_JPRB/)
KBO( :,45,12) = (/&
&8.1783E+02_JPRB,8.0759E+02_JPRB,7.9294E+02_JPRB,7.7397E+02_JPRB,7.5240E+02_JPRB/)
KBO( :,46,12) = (/&
&8.2078E+02_JPRB,8.1309E+02_JPRB,8.0010E+02_JPRB,7.8201E+02_JPRB,7.6131E+02_JPRB/)
KBO( :,47,12) = (/&
&8.2288E+02_JPRB,8.1791E+02_JPRB,8.0688E+02_JPRB,7.9031E+02_JPRB,7.7082E+02_JPRB/)
KBO( :,48,12) = (/&
&8.2365E+02_JPRB,8.2167E+02_JPRB,8.1273E+02_JPRB,7.9796E+02_JPRB,7.7963E+02_JPRB/)
KBO( :,49,12) = (/&
&8.2287E+02_JPRB,8.2431E+02_JPRB,8.1763E+02_JPRB,8.0487E+02_JPRB,7.8791E+02_JPRB/)
KBO( :,50,12) = (/&
&8.2045E+02_JPRB,8.2549E+02_JPRB,8.2124E+02_JPRB,8.1073E+02_JPRB,7.9521E+02_JPRB/)
KBO( :,51,12) = (/&
&8.1647E+02_JPRB,8.2526E+02_JPRB,8.2370E+02_JPRB,8.1563E+02_JPRB,8.0180E+02_JPRB/)
KBO( :,52,12) = (/&
&8.1121E+02_JPRB,8.2367E+02_JPRB,8.2531E+02_JPRB,8.1967E+02_JPRB,8.0788E+02_JPRB/)
KBO( :,53,12) = (/&
&8.0411E+02_JPRB,8.2055E+02_JPRB,8.2579E+02_JPRB,8.2272E+02_JPRB,8.1321E+02_JPRB/)
KBO( :,54,12) = (/&
&7.9588E+02_JPRB,8.1607E+02_JPRB,8.2504E+02_JPRB,8.2471E+02_JPRB,8.1743E+02_JPRB/)
KBO( :,55,12) = (/&
&7.8606E+02_JPRB,8.1098E+02_JPRB,8.2328E+02_JPRB,8.2571E+02_JPRB,8.2076E+02_JPRB/)
KBO( :,56,12) = (/&
&7.7445E+02_JPRB,8.0478E+02_JPRB,8.2051E+02_JPRB,8.2610E+02_JPRB,8.2295E+02_JPRB/)
KBO( :,57,12) = (/&
&7.6082E+02_JPRB,7.9711E+02_JPRB,8.1649E+02_JPRB,8.2552E+02_JPRB,8.2493E+02_JPRB/)
KBO( :,58,12) = (/&
&7.4626E+02_JPRB,7.8808E+02_JPRB,8.1174E+02_JPRB,8.2409E+02_JPRB,8.2621E+02_JPRB/)
KBO( :,59,12) = (/&
&7.3987E+02_JPRB,7.8401E+02_JPRB,8.0954E+02_JPRB,8.2334E+02_JPRB,8.2653E+02_JPRB/)
KBO( :,13,13) = (/&
&2.0706E+02_JPRB,2.0275E+02_JPRB,1.9960E+02_JPRB,1.9642E+02_JPRB,1.9325E+02_JPRB/)
KBO( :,14,13) = (/&
&2.3740E+02_JPRB,2.3314E+02_JPRB,2.2927E+02_JPRB,2.2508E+02_JPRB,2.2071E+02_JPRB/)
KBO( :,15,13) = (/&
&2.7338E+02_JPRB,2.6831E+02_JPRB,2.6304E+02_JPRB,2.5795E+02_JPRB,2.5294E+02_JPRB/)
KBO( :,16,13) = (/&
&3.1308E+02_JPRB,3.0705E+02_JPRB,3.0154E+02_JPRB,2.9582E+02_JPRB,2.8990E+02_JPRB/)
KBO( :,17,13) = (/&
&3.5766E+02_JPRB,3.5096E+02_JPRB,3.4421E+02_JPRB,3.3769E+02_JPRB,3.3070E+02_JPRB/)
KBO( :,18,13) = (/&
&4.0731E+02_JPRB,3.9992E+02_JPRB,3.9262E+02_JPRB,3.8506E+02_JPRB,3.7703E+02_JPRB/)
KBO( :,19,13) = (/&
&4.6388E+02_JPRB,4.5553E+02_JPRB,4.4668E+02_JPRB,4.3762E+02_JPRB,4.2783E+02_JPRB/)
KBO( :,20,13) = (/&
&5.2583E+02_JPRB,5.1576E+02_JPRB,5.0510E+02_JPRB,4.9383E+02_JPRB,4.8218E+02_JPRB/)
KBO( :,21,13) = (/&
&5.9116E+02_JPRB,5.7950E+02_JPRB,5.6656E+02_JPRB,5.5310E+02_JPRB,5.3897E+02_JPRB/)
KBO( :,22,13) = (/&
&6.5823E+02_JPRB,6.4391E+02_JPRB,6.2839E+02_JPRB,6.1210E+02_JPRB,5.9534E+02_JPRB/)
KBO( :,23,13) = (/&
&7.2542E+02_JPRB,7.0808E+02_JPRB,6.8952E+02_JPRB,6.6991E+02_JPRB,6.4969E+02_JPRB/)
KBO( :,24,13) = (/&
&7.9029E+02_JPRB,7.7002E+02_JPRB,7.4790E+02_JPRB,7.2486E+02_JPRB,7.0140E+02_JPRB/)
KBO( :,25,13) = (/&
&8.5203E+02_JPRB,8.2748E+02_JPRB,8.0207E+02_JPRB,7.7556E+02_JPRB,7.4909E+02_JPRB/)
KBO( :,26,13) = (/&
&9.0879E+02_JPRB,8.8008E+02_JPRB,8.5133E+02_JPRB,8.2123E+02_JPRB,7.9187E+02_JPRB/)
KBO( :,27,13) = (/&
&9.5929E+02_JPRB,9.2767E+02_JPRB,8.9539E+02_JPRB,8.6200E+02_JPRB,8.2944E+02_JPRB/)
KBO( :,28,13) = (/&
&1.0038E+03_JPRB,9.6874E+02_JPRB,9.3346E+02_JPRB,8.9698E+02_JPRB,8.6129E+02_JPRB/)
KBO( :,29,13) = (/&
&1.0414E+03_JPRB,1.0031E+03_JPRB,9.6490E+02_JPRB,9.2572E+02_JPRB,8.8715E+02_JPRB/)
KBO( :,30,13) = (/&
&1.0721E+03_JPRB,1.0311E+03_JPRB,9.9002E+02_JPRB,9.4833E+02_JPRB,9.0740E+02_JPRB/)
KBO( :,31,13) = (/&
&1.0964E+03_JPRB,1.0523E+03_JPRB,1.0091E+03_JPRB,9.6516E+02_JPRB,9.2258E+02_JPRB/)
KBO( :,32,13) = (/&
&1.1144E+03_JPRB,1.0680E+03_JPRB,1.0228E+03_JPRB,9.7704E+02_JPRB,9.3296E+02_JPRB/)
KBO( :,33,13) = (/&
&1.1268E+03_JPRB,1.0785E+03_JPRB,1.0318E+03_JPRB,9.8453E+02_JPRB,9.3914E+02_JPRB/)
KBO( :,34,13) = (/&
&1.1363E+03_JPRB,1.0866E+03_JPRB,1.0383E+03_JPRB,9.8991E+02_JPRB,9.4342E+02_JPRB/)
KBO( :,35,13) = (/&
&1.1468E+03_JPRB,1.0959E+03_JPRB,1.0463E+03_JPRB,9.9687E+02_JPRB,9.4938E+02_JPRB/)
KBO( :,36,13) = (/&
&1.1600E+03_JPRB,1.1078E+03_JPRB,1.0572E+03_JPRB,1.0067E+03_JPRB,9.5830E+02_JPRB/)
KBO( :,37,13) = (/&
&1.1790E+03_JPRB,1.1257E+03_JPRB,1.0738E+03_JPRB,1.0220E+03_JPRB,9.7295E+02_JPRB/)
KBO( :,38,13) = (/&
&1.1965E+03_JPRB,1.1423E+03_JPRB,1.0895E+03_JPRB,1.0368E+03_JPRB,9.8736E+02_JPRB/)
KBO( :,39,13) = (/&
&1.2126E+03_JPRB,1.1577E+03_JPRB,1.1039E+03_JPRB,1.0505E+03_JPRB,1.0002E+03_JPRB/)
KBO( :,40,13) = (/&
&1.2331E+03_JPRB,1.1780E+03_JPRB,1.1227E+03_JPRB,1.0686E+03_JPRB,1.0174E+03_JPRB/)
KBO( :,41,13) = (/&
&1.2534E+03_JPRB,1.1977E+03_JPRB,1.1416E+03_JPRB,1.0868E+03_JPRB,1.0348E+03_JPRB/)
KBO( :,42,13) = (/&
&1.2728E+03_JPRB,1.2168E+03_JPRB,1.1600E+03_JPRB,1.1045E+03_JPRB,1.0518E+03_JPRB/)
KBO( :,43,13) = (/&
&1.2945E+03_JPRB,1.2387E+03_JPRB,1.1810E+03_JPRB,1.1249E+03_JPRB,1.0714E+03_JPRB/)
KBO( :,44,13) = (/&
&1.3174E+03_JPRB,1.2614E+03_JPRB,1.2031E+03_JPRB,1.1464E+03_JPRB,1.0923E+03_JPRB/)
KBO( :,45,13) = (/&
&1.3398E+03_JPRB,1.2836E+03_JPRB,1.2250E+03_JPRB,1.1678E+03_JPRB,1.1130E+03_JPRB/)
KBO( :,46,13) = (/&
&1.3628E+03_JPRB,1.3065E+03_JPRB,1.2489E+03_JPRB,1.1905E+03_JPRB,1.1348E+03_JPRB/)
KBO( :,47,13) = (/&
&1.3873E+03_JPRB,1.3317E+03_JPRB,1.2742E+03_JPRB,1.2156E+03_JPRB,1.1587E+03_JPRB/)
KBO( :,48,13) = (/&
&1.4108E+03_JPRB,1.3565E+03_JPRB,1.2991E+03_JPRB,1.2406E+03_JPRB,1.1829E+03_JPRB/)
KBO( :,49,13) = (/&
&1.4335E+03_JPRB,1.3803E+03_JPRB,1.3234E+03_JPRB,1.2654E+03_JPRB,1.2072E+03_JPRB/)
KBO( :,50,13) = (/&
&1.4541E+03_JPRB,1.4021E+03_JPRB,1.3460E+03_JPRB,1.2885E+03_JPRB,1.2302E+03_JPRB/)
KBO( :,51,13) = (/&
&1.4730E+03_JPRB,1.4228E+03_JPRB,1.3681E+03_JPRB,1.3104E+03_JPRB,1.2525E+03_JPRB/)
KBO( :,52,13) = (/&
&1.4907E+03_JPRB,1.4427E+03_JPRB,1.3898E+03_JPRB,1.3321E+03_JPRB,1.2744E+03_JPRB/)
KBO( :,53,13) = (/&
&1.5061E+03_JPRB,1.4619E+03_JPRB,1.4106E+03_JPRB,1.3539E+03_JPRB,1.2962E+03_JPRB/)
KBO( :,54,13) = (/&
&1.5192E+03_JPRB,1.4794E+03_JPRB,1.4292E+03_JPRB,1.3736E+03_JPRB,1.3161E+03_JPRB/)
KBO( :,55,13) = (/&
&1.5309E+03_JPRB,1.4941E+03_JPRB,1.4465E+03_JPRB,1.3926E+03_JPRB,1.3351E+03_JPRB/)
KBO( :,56,13) = (/&
&1.5407E+03_JPRB,1.5075E+03_JPRB,1.4630E+03_JPRB,1.4106E+03_JPRB,1.3542E+03_JPRB/)
KBO( :,57,13) = (/&
&1.5484E+03_JPRB,1.5197E+03_JPRB,1.4789E+03_JPRB,1.4283E+03_JPRB,1.3728E+03_JPRB/)
KBO( :,58,13) = (/&
&1.5535E+03_JPRB,1.5303E+03_JPRB,1.4929E+03_JPRB,1.4443E+03_JPRB,1.3902E+03_JPRB/)
KBO( :,59,13) = (/&
&1.5550E+03_JPRB,1.5344E+03_JPRB,1.4983E+03_JPRB,1.4507E+03_JPRB,1.3972E+03_JPRB/)
KBO( :,13,14) = (/&
&2.5200E+02_JPRB,2.4567E+02_JPRB,2.3912E+02_JPRB,2.3261E+02_JPRB,2.2671E+02_JPRB/)
KBO( :,14,14) = (/&
&2.8356E+02_JPRB,2.7567E+02_JPRB,2.6762E+02_JPRB,2.6041E+02_JPRB,2.5414E+02_JPRB/)
KBO( :,15,14) = (/&
&3.2000E+02_JPRB,3.1086E+02_JPRB,3.0278E+02_JPRB,2.9520E+02_JPRB,2.8835E+02_JPRB/)
KBO( :,16,14) = (/&
&3.6501E+02_JPRB,3.5545E+02_JPRB,3.4663E+02_JPRB,3.3835E+02_JPRB,3.3040E+02_JPRB/)
KBO( :,17,14) = (/&
&4.2043E+02_JPRB,4.1003E+02_JPRB,4.0038E+02_JPRB,3.9117E+02_JPRB,3.8254E+02_JPRB/)
KBO( :,18,14) = (/&
&4.8684E+02_JPRB,4.7541E+02_JPRB,4.6423E+02_JPRB,4.5366E+02_JPRB,4.4317E+02_JPRB/)
KBO( :,19,14) = (/&
&5.6352E+02_JPRB,5.4977E+02_JPRB,5.3699E+02_JPRB,5.2451E+02_JPRB,5.1166E+02_JPRB/)
KBO( :,20,14) = (/&
&6.4946E+02_JPRB,6.3281E+02_JPRB,6.1710E+02_JPRB,6.0187E+02_JPRB,5.8639E+02_JPRB/)
KBO( :,21,14) = (/&
&7.4362E+02_JPRB,7.2356E+02_JPRB,7.0410E+02_JPRB,6.8448E+02_JPRB,6.6564E+02_JPRB/)
KBO( :,22,14) = (/&
&8.4333E+02_JPRB,8.1844E+02_JPRB,7.9450E+02_JPRB,7.7017E+02_JPRB,7.4626E+02_JPRB/)
KBO( :,23,14) = (/&
&9.4680E+02_JPRB,9.1686E+02_JPRB,8.8724E+02_JPRB,8.5711E+02_JPRB,8.2794E+02_JPRB/)
KBO( :,24,14) = (/&
&1.0528E+03_JPRB,1.0161E+03_JPRB,9.7917E+02_JPRB,9.4320E+02_JPRB,9.0772E+02_JPRB/)
KBO( :,25,14) = (/&
&1.1567E+03_JPRB,1.1128E+03_JPRB,1.0684E+03_JPRB,1.0249E+03_JPRB,9.8260E+02_JPRB/)
KBO( :,26,14) = (/&
&1.2530E+03_JPRB,1.2021E+03_JPRB,1.1497E+03_JPRB,1.0989E+03_JPRB,1.0499E+03_JPRB/)
KBO( :,27,14) = (/&
&1.3414E+03_JPRB,1.2817E+03_JPRB,1.2215E+03_JPRB,1.1632E+03_JPRB,1.1083E+03_JPRB/)
KBO( :,28,14) = (/&
&1.4184E+03_JPRB,1.3503E+03_JPRB,1.2822E+03_JPRB,1.2175E+03_JPRB,1.1569E+03_JPRB/)
KBO( :,29,14) = (/&
&1.4829E+03_JPRB,1.4069E+03_JPRB,1.3322E+03_JPRB,1.2616E+03_JPRB,1.1958E+03_JPRB/)
KBO( :,30,14) = (/&
&1.5347E+03_JPRB,1.4521E+03_JPRB,1.3719E+03_JPRB,1.2961E+03_JPRB,1.2258E+03_JPRB/)
KBO( :,31,14) = (/&
&1.5740E+03_JPRB,1.4863E+03_JPRB,1.4011E+03_JPRB,1.3213E+03_JPRB,1.2473E+03_JPRB/)
KBO( :,32,14) = (/&
&1.6019E+03_JPRB,1.5104E+03_JPRB,1.4212E+03_JPRB,1.3381E+03_JPRB,1.2613E+03_JPRB/)
KBO( :,33,14) = (/&
&1.6206E+03_JPRB,1.5254E+03_JPRB,1.4335E+03_JPRB,1.3478E+03_JPRB,1.2690E+03_JPRB/)
KBO( :,34,14) = (/&
&1.6343E+03_JPRB,1.5362E+03_JPRB,1.4422E+03_JPRB,1.3545E+03_JPRB,1.2743E+03_JPRB/)
KBO( :,35,14) = (/&
&1.6513E+03_JPRB,1.5505E+03_JPRB,1.4543E+03_JPRB,1.3647E+03_JPRB,1.2829E+03_JPRB/)
KBO( :,36,14) = (/&
&1.6747E+03_JPRB,1.5711E+03_JPRB,1.4723E+03_JPRB,1.3806E+03_JPRB,1.2969E+03_JPRB/)
KBO( :,37,14) = (/&
&1.7119E+03_JPRB,1.6037E+03_JPRB,1.5018E+03_JPRB,1.4086E+03_JPRB,1.3210E+03_JPRB/)
KBO( :,38,14) = (/&
&1.7464E+03_JPRB,1.6348E+03_JPRB,1.5298E+03_JPRB,1.4339E+03_JPRB,1.3446E+03_JPRB/)
KBO( :,39,14) = (/&
&1.7785E+03_JPRB,1.6638E+03_JPRB,1.5560E+03_JPRB,1.4575E+03_JPRB,1.3661E+03_JPRB/)
KBO( :,40,14) = (/&
&1.8213E+03_JPRB,1.7031E+03_JPRB,1.5916E+03_JPRB,1.4897E+03_JPRB,1.3957E+03_JPRB/)
KBO( :,41,14) = (/&
&1.8650E+03_JPRB,1.7429E+03_JPRB,1.6279E+03_JPRB,1.5226E+03_JPRB,1.4260E+03_JPRB/)
KBO( :,42,14) = (/&
&1.9083E+03_JPRB,1.7822E+03_JPRB,1.6638E+03_JPRB,1.5553E+03_JPRB,1.4560E+03_JPRB/)
KBO( :,43,14) = (/&
&1.9590E+03_JPRB,1.8282E+03_JPRB,1.7062E+03_JPRB,1.5939E+03_JPRB,1.4914E+03_JPRB/)
KBO( :,44,14) = (/&
&2.0135E+03_JPRB,1.8780E+03_JPRB,1.7518E+03_JPRB,1.6354E+03_JPRB,1.5294E+03_JPRB/)
KBO( :,45,14) = (/&
&2.0686E+03_JPRB,1.9283E+03_JPRB,1.7978E+03_JPRB,1.6776E+03_JPRB,1.5679E+03_JPRB/)
KBO( :,46,14) = (/&
&2.1281E+03_JPRB,1.9824E+03_JPRB,1.8468E+03_JPRB,1.7228E+03_JPRB,1.6096E+03_JPRB/)
KBO( :,47,14) = (/&
&2.1954E+03_JPRB,2.0435E+03_JPRB,1.9031E+03_JPRB,1.7740E+03_JPRB,1.6572E+03_JPRB/)
KBO( :,48,14) = (/&
&2.2648E+03_JPRB,2.1064E+03_JPRB,1.9610E+03_JPRB,1.8268E+03_JPRB,1.7061E+03_JPRB/)
KBO( :,49,14) = (/&
&2.3361E+03_JPRB,2.1712E+03_JPRB,2.0209E+03_JPRB,1.8815E+03_JPRB,1.7562E+03_JPRB/)
KBO( :,50,14) = (/&
&2.4045E+03_JPRB,2.2339E+03_JPRB,2.0788E+03_JPRB,1.9343E+03_JPRB,1.8042E+03_JPRB/)
KBO( :,51,14) = (/&
&2.4726E+03_JPRB,2.2963E+03_JPRB,2.1361E+03_JPRB,1.9873E+03_JPRB,1.8522E+03_JPRB/)
KBO( :,52,14) = (/&
&2.5428E+03_JPRB,2.3607E+03_JPRB,2.1949E+03_JPRB,2.0419E+03_JPRB,1.9016E+03_JPRB/)
KBO( :,53,14) = (/&
&2.6141E+03_JPRB,2.4269E+03_JPRB,2.2555E+03_JPRB,2.0978E+03_JPRB,1.9528E+03_JPRB/)
KBO( :,54,14) = (/&
&2.6807E+03_JPRB,2.4886E+03_JPRB,2.3128E+03_JPRB,2.1502E+03_JPRB,2.0011E+03_JPRB/)
KBO( :,55,14) = (/&
&2.7459E+03_JPRB,2.5495E+03_JPRB,2.3693E+03_JPRB,2.2020E+03_JPRB,2.0486E+03_JPRB/)
KBO( :,56,14) = (/&
&2.8130E+03_JPRB,2.6116E+03_JPRB,2.4267E+03_JPRB,2.2548E+03_JPRB,2.0964E+03_JPRB/)
KBO( :,57,14) = (/&
&2.8820E+03_JPRB,2.6749E+03_JPRB,2.4855E+03_JPRB,2.3093E+03_JPRB,2.1460E+03_JPRB/)
KBO( :,58,14) = (/&
&2.9481E+03_JPRB,2.7364E+03_JPRB,2.5424E+03_JPRB,2.3624E+03_JPRB,2.1944E+03_JPRB/)
KBO( :,59,14) = (/&
&2.9753E+03_JPRB,2.7616E+03_JPRB,2.5658E+03_JPRB,2.3843E+03_JPRB,2.2142E+03_JPRB/)
KBO( :,13,15) = (/&
&3.0496E+02_JPRB,3.0081E+02_JPRB,2.9676E+02_JPRB,2.9051E+02_JPRB,2.8450E+02_JPRB/)
KBO( :,14,15) = (/&
&3.4462E+02_JPRB,3.4099E+02_JPRB,3.3527E+02_JPRB,3.3016E+02_JPRB,3.2406E+02_JPRB/)
KBO( :,15,15) = (/&
&3.8936E+02_JPRB,3.8628E+02_JPRB,3.8183E+02_JPRB,3.7492E+02_JPRB,3.6807E+02_JPRB/)
KBO( :,16,15) = (/&
&4.4332E+02_JPRB,4.3856E+02_JPRB,4.3430E+02_JPRB,4.2589E+02_JPRB,4.1877E+02_JPRB/)
KBO( :,17,15) = (/&
&5.0835E+02_JPRB,5.0183E+02_JPRB,4.9489E+02_JPRB,4.8561E+02_JPRB,4.7621E+02_JPRB/)
KBO( :,18,15) = (/&
&5.8677E+02_JPRB,5.7885E+02_JPRB,5.6791E+02_JPRB,5.5537E+02_JPRB,5.4279E+02_JPRB/)
KBO( :,19,15) = (/&
&6.8130E+02_JPRB,6.6815E+02_JPRB,6.5194E+02_JPRB,6.3561E+02_JPRB,6.1955E+02_JPRB/)
KBO( :,20,15) = (/&
&7.8879E+02_JPRB,7.7015E+02_JPRB,7.4875E+02_JPRB,7.2676E+02_JPRB,7.0600E+02_JPRB/)
KBO( :,21,15) = (/&
&9.1167E+02_JPRB,8.8542E+02_JPRB,8.5728E+02_JPRB,8.2924E+02_JPRB,8.0222E+02_JPRB/)
KBO( :,22,15) = (/&
&1.0456E+03_JPRB,1.0104E+03_JPRB,9.7413E+02_JPRB,9.3830E+02_JPRB,9.0416E+02_JPRB/)
KBO( :,23,15) = (/&
&1.1890E+03_JPRB,1.1427E+03_JPRB,1.0964E+03_JPRB,1.0517E+03_JPRB,1.0073E+03_JPRB/)
KBO( :,24,15) = (/&
&1.3341E+03_JPRB,1.2769E+03_JPRB,1.2199E+03_JPRB,1.1637E+03_JPRB,1.1097E+03_JPRB/)
KBO( :,25,15) = (/&
&1.4777E+03_JPRB,1.4064E+03_JPRB,1.3371E+03_JPRB,1.2692E+03_JPRB,1.2051E+03_JPRB/)
KBO( :,26,15) = (/&
&1.6127E+03_JPRB,1.5257E+03_JPRB,1.4439E+03_JPRB,1.3652E+03_JPRB,1.2908E+03_JPRB/)
KBO( :,27,15) = (/&
&1.7363E+03_JPRB,1.6345E+03_JPRB,1.5403E+03_JPRB,1.4516E+03_JPRB,1.3681E+03_JPRB/)
KBO( :,28,15) = (/&
&1.8456E+03_JPRB,1.7310E+03_JPRB,1.6252E+03_JPRB,1.5262E+03_JPRB,1.4343E+03_JPRB/)
KBO( :,29,15) = (/&
&1.9374E+03_JPRB,1.8114E+03_JPRB,1.6953E+03_JPRB,1.5870E+03_JPRB,1.4880E+03_JPRB/)
KBO( :,30,15) = (/&
&2.0123E+03_JPRB,1.8759E+03_JPRB,1.7509E+03_JPRB,1.6347E+03_JPRB,1.5297E+03_JPRB/)
KBO( :,31,15) = (/&
&2.0695E+03_JPRB,1.9241E+03_JPRB,1.7919E+03_JPRB,1.6696E+03_JPRB,1.5595E+03_JPRB/)
KBO( :,32,15) = (/&
&2.1098E+03_JPRB,1.9573E+03_JPRB,1.8199E+03_JPRB,1.6927E+03_JPRB,1.5791E+03_JPRB/)
KBO( :,33,15) = (/&
&2.1350E+03_JPRB,1.9776E+03_JPRB,1.8360E+03_JPRB,1.7058E+03_JPRB,1.5896E+03_JPRB/)
KBO( :,34,15) = (/&
&2.1531E+03_JPRB,1.9921E+03_JPRB,1.8473E+03_JPRB,1.7146E+03_JPRB,1.5966E+03_JPRB/)
KBO( :,35,15) = (/&
&2.1773E+03_JPRB,2.0121E+03_JPRB,1.8641E+03_JPRB,1.7288E+03_JPRB,1.6085E+03_JPRB/)
KBO( :,36,15) = (/&
&2.2124E+03_JPRB,2.0424E+03_JPRB,1.8903E+03_JPRB,1.7515E+03_JPRB,1.6285E+03_JPRB/)
KBO( :,37,15) = (/&
&2.2692E+03_JPRB,2.0922E+03_JPRB,1.9342E+03_JPRB,1.7916E+03_JPRB,1.6630E+03_JPRB/)
KBO( :,38,15) = (/&
&2.3243E+03_JPRB,2.1400E+03_JPRB,1.9765E+03_JPRB,1.8290E+03_JPRB,1.6948E+03_JPRB/)
KBO( :,39,15) = (/&
&2.3761E+03_JPRB,2.1849E+03_JPRB,2.0163E+03_JPRB,1.8643E+03_JPRB,1.7262E+03_JPRB/)
KBO( :,40,15) = (/&
&2.4467E+03_JPRB,2.2470E+03_JPRB,2.0711E+03_JPRB,1.9128E+03_JPRB,1.7697E+03_JPRB/)
KBO( :,41,15) = (/&
&2.5197E+03_JPRB,2.3108E+03_JPRB,2.1276E+03_JPRB,1.9630E+03_JPRB,1.8147E+03_JPRB/)
KBO( :,42,15) = (/&
&2.5927E+03_JPRB,2.3746E+03_JPRB,2.1839E+03_JPRB,2.0131E+03_JPRB,1.8595E+03_JPRB/)
KBO( :,43,15) = (/&
&2.6795E+03_JPRB,2.4509E+03_JPRB,2.2509E+03_JPRB,2.0729E+03_JPRB,1.9127E+03_JPRB/)
KBO( :,44,15) = (/&
&2.7746E+03_JPRB,2.5346E+03_JPRB,2.3244E+03_JPRB,2.1382E+03_JPRB,1.9711E+03_JPRB/)
KBO( :,45,15) = (/&
&2.8725E+03_JPRB,2.6210E+03_JPRB,2.4001E+03_JPRB,2.2052E+03_JPRB,2.0310E+03_JPRB/)
KBO( :,46,15) = (/&
&2.9808E+03_JPRB,2.7160E+03_JPRB,2.4820E+03_JPRB,2.2786E+03_JPRB,2.0965E+03_JPRB/)
KBO( :,47,15) = (/&
&3.1065E+03_JPRB,2.8260E+03_JPRB,2.5776E+03_JPRB,2.3630E+03_JPRB,2.1714E+03_JPRB/)
KBO( :,48,15) = (/&
&3.2382E+03_JPRB,2.9414E+03_JPRB,2.6779E+03_JPRB,2.4515E+03_JPRB,2.2491E+03_JPRB/)
KBO( :,49,15) = (/&
&3.3769E+03_JPRB,3.0628E+03_JPRB,2.7828E+03_JPRB,2.5435E+03_JPRB,2.3301E+03_JPRB/)
KBO( :,50,15) = (/&
&3.5153E+03_JPRB,3.1825E+03_JPRB,2.8860E+03_JPRB,2.6340E+03_JPRB,2.4097E+03_JPRB/)
KBO( :,51,15) = (/&
&3.6567E+03_JPRB,3.3043E+03_JPRB,2.9915E+03_JPRB,2.7258E+03_JPRB,2.4905E+03_JPRB/)
KBO( :,52,15) = (/&
&3.8059E+03_JPRB,3.4316E+03_JPRB,3.1018E+03_JPRB,2.8218E+03_JPRB,2.5746E+03_JPRB/)
KBO( :,53,15) = (/&
&3.9647E+03_JPRB,3.5659E+03_JPRB,3.2181E+03_JPRB,2.9226E+03_JPRB,2.6623E+03_JPRB/)
KBO( :,54,15) = (/&
&4.1182E+03_JPRB,3.6932E+03_JPRB,3.3305E+03_JPRB,3.0197E+03_JPRB,2.7461E+03_JPRB/)
KBO( :,55,15) = (/&
&4.2719E+03_JPRB,3.8244E+03_JPRB,3.4429E+03_JPRB,3.1156E+03_JPRB,2.8302E+03_JPRB/)
KBO( :,56,15) = (/&
&4.4321E+03_JPRB,3.9623E+03_JPRB,3.5606E+03_JPRB,3.2171E+03_JPRB,2.9172E+03_JPRB/)
KBO( :,57,15) = (/&
&4.6005E+03_JPRB,4.1071E+03_JPRB,3.6841E+03_JPRB,3.3227E+03_JPRB,3.0093E+03_JPRB/)
KBO( :,58,15) = (/&
&4.7711E+03_JPRB,4.2512E+03_JPRB,3.8068E+03_JPRB,3.4270E+03_JPRB,3.1000E+03_JPRB/)
KBO( :,59,15) = (/&
&4.8435E+03_JPRB,4.3113E+03_JPRB,3.8580E+03_JPRB,3.4704E+03_JPRB,3.1379E+03_JPRB/)
KBO( :,13,16) = (/&
&3.6480E+02_JPRB,3.5145E+02_JPRB,3.4350E+02_JPRB,3.3674E+02_JPRB,3.3295E+02_JPRB/)
KBO( :,14,16) = (/&
&4.3305E+02_JPRB,4.2002E+02_JPRB,4.0834E+02_JPRB,4.0114E+02_JPRB,3.9514E+02_JPRB/)
KBO( :,15,16) = (/&
&5.1021E+02_JPRB,4.9566E+02_JPRB,4.8445E+02_JPRB,4.7500E+02_JPRB,4.6664E+02_JPRB/)
KBO( :,16,16) = (/&
&6.0095E+02_JPRB,5.8332E+02_JPRB,5.7034E+02_JPRB,5.5793E+02_JPRB,5.4743E+02_JPRB/)
KBO( :,17,16) = (/&
&6.9984E+02_JPRB,6.8135E+02_JPRB,6.6501E+02_JPRB,6.5003E+02_JPRB,6.3773E+02_JPRB/)
KBO( :,18,16) = (/&
&8.1052E+02_JPRB,7.8978E+02_JPRB,7.6911E+02_JPRB,7.5277E+02_JPRB,7.3709E+02_JPRB/)
KBO( :,19,16) = (/&
&9.3185E+02_JPRB,9.0651E+02_JPRB,8.8287E+02_JPRB,8.6357E+02_JPRB,8.4262E+02_JPRB/)
KBO( :,20,16) = (/&
&1.0617E+03_JPRB,1.0323E+03_JPRB,1.0033E+03_JPRB,9.7715E+02_JPRB,9.5295E+02_JPRB/)
KBO( :,21,16) = (/&
&1.1955E+03_JPRB,1.1605E+03_JPRB,1.1266E+03_JPRB,1.0931E+03_JPRB,1.0626E+03_JPRB/)
KBO( :,22,16) = (/&
&1.3313E+03_JPRB,1.2888E+03_JPRB,1.2452E+03_JPRB,1.2039E+03_JPRB,1.1668E+03_JPRB/)
KBO( :,23,16) = (/&
&1.4677E+03_JPRB,1.4171E+03_JPRB,1.3647E+03_JPRB,1.3122E+03_JPRB,1.2693E+03_JPRB/)
KBO( :,24,16) = (/&
&1.6031E+03_JPRB,1.5431E+03_JPRB,1.4805E+03_JPRB,1.4214E+03_JPRB,1.3711E+03_JPRB/)
KBO( :,25,16) = (/&
&1.7446E+03_JPRB,1.6761E+03_JPRB,1.6075E+03_JPRB,1.5354E+03_JPRB,1.4755E+03_JPRB/)
KBO( :,26,16) = (/&
&1.8991E+03_JPRB,1.8163E+03_JPRB,1.7331E+03_JPRB,1.6466E+03_JPRB,1.5750E+03_JPRB/)
KBO( :,27,16) = (/&
&2.0473E+03_JPRB,1.9486E+03_JPRB,1.8508E+03_JPRB,1.7507E+03_JPRB,1.6645E+03_JPRB/)
KBO( :,28,16) = (/&
&2.1841E+03_JPRB,2.0672E+03_JPRB,1.9532E+03_JPRB,1.8416E+03_JPRB,1.7427E+03_JPRB/)
KBO( :,29,16) = (/&
&2.3013E+03_JPRB,2.1668E+03_JPRB,2.0380E+03_JPRB,1.9159E+03_JPRB,1.8061E+03_JPRB/)
KBO( :,30,16) = (/&
&2.3968E+03_JPRB,2.2468E+03_JPRB,2.1057E+03_JPRB,1.9742E+03_JPRB,1.8547E+03_JPRB/)
KBO( :,31,16) = (/&
&2.4698E+03_JPRB,2.3066E+03_JPRB,2.1555E+03_JPRB,2.0162E+03_JPRB,1.8899E+03_JPRB/)
KBO( :,32,16) = (/&
&2.5212E+03_JPRB,2.3480E+03_JPRB,2.1899E+03_JPRB,2.0439E+03_JPRB,1.9131E+03_JPRB/)
KBO( :,33,16) = (/&
&2.5535E+03_JPRB,2.3733E+03_JPRB,2.2102E+03_JPRB,2.0593E+03_JPRB,1.9261E+03_JPRB/)
KBO( :,34,16) = (/&
&2.5772E+03_JPRB,2.3915E+03_JPRB,2.2247E+03_JPRB,2.0705E+03_JPRB,1.9349E+03_JPRB/)
KBO( :,35,16) = (/&
&2.6073E+03_JPRB,2.4161E+03_JPRB,2.2452E+03_JPRB,2.0872E+03_JPRB,1.9493E+03_JPRB/)
KBO( :,36,16) = (/&
&2.6509E+03_JPRB,2.4529E+03_JPRB,2.2766E+03_JPRB,2.1138E+03_JPRB,1.9720E+03_JPRB/)
KBO( :,37,16) = (/&
&2.7188E+03_JPRB,2.5136E+03_JPRB,2.3285E+03_JPRB,2.1597E+03_JPRB,2.0114E+03_JPRB/)
KBO( :,38,16) = (/&
&2.7845E+03_JPRB,2.5721E+03_JPRB,2.3785E+03_JPRB,2.2030E+03_JPRB,2.0515E+03_JPRB/)
KBO( :,39,16) = (/&
&2.8472E+03_JPRB,2.6270E+03_JPRB,2.4254E+03_JPRB,2.2449E+03_JPRB,2.0875E+03_JPRB/)
KBO( :,40,16) = (/&
&2.9330E+03_JPRB,2.6993E+03_JPRB,2.4900E+03_JPRB,2.3030E+03_JPRB,2.1374E+03_JPRB/)
KBO( :,41,16) = (/&
&3.0218E+03_JPRB,2.7769E+03_JPRB,2.5568E+03_JPRB,2.3631E+03_JPRB,2.1888E+03_JPRB/)
KBO( :,42,16) = (/&
&3.1113E+03_JPRB,2.8546E+03_JPRB,2.6243E+03_JPRB,2.4236E+03_JPRB,2.2399E+03_JPRB/)
KBO( :,43,16) = (/&
&3.2191E+03_JPRB,2.9464E+03_JPRB,2.7051E+03_JPRB,2.4953E+03_JPRB,2.3016E+03_JPRB/)
KBO( :,44,16) = (/&
&3.3385E+03_JPRB,3.0469E+03_JPRB,2.7942E+03_JPRB,2.5737E+03_JPRB,2.3700E+03_JPRB/)
KBO( :,45,16) = (/&
&3.4626E+03_JPRB,3.1506E+03_JPRB,2.8863E+03_JPRB,2.6539E+03_JPRB,2.4394E+03_JPRB/)
KBO( :,46,16) = (/&
&3.6001E+03_JPRB,3.2642E+03_JPRB,2.9874E+03_JPRB,2.7413E+03_JPRB,2.5151E+03_JPRB/)
KBO( :,47,16) = (/&
&3.7610E+03_JPRB,3.3965E+03_JPRB,3.1046E+03_JPRB,2.8425E+03_JPRB,2.6031E+03_JPRB/)
KBO( :,48,16) = (/&
&3.9321E+03_JPRB,3.5361E+03_JPRB,3.2276E+03_JPRB,2.9476E+03_JPRB,2.6982E+03_JPRB/)
KBO( :,49,16) = (/&
&4.1176E+03_JPRB,3.6899E+03_JPRB,3.3583E+03_JPRB,3.0595E+03_JPRB,2.7974E+03_JPRB/)
KBO( :,50,16) = (/&
&4.3032E+03_JPRB,3.8456E+03_JPRB,3.4873E+03_JPRB,3.1701E+03_JPRB,2.8952E+03_JPRB/)
KBO( :,51,16) = (/&
&4.4935E+03_JPRB,4.0060E+03_JPRB,3.6203E+03_JPRB,3.2826E+03_JPRB,2.9949E+03_JPRB/)
KBO( :,52,16) = (/&
&4.6944E+03_JPRB,4.1760E+03_JPRB,3.7596E+03_JPRB,3.4020E+03_JPRB,3.0994E+03_JPRB/)
KBO( :,53,16) = (/&
&4.9137E+03_JPRB,4.3562E+03_JPRB,3.9079E+03_JPRB,3.5294E+03_JPRB,3.2093E+03_JPRB/)
KBO( :,54,16) = (/&
&5.1332E+03_JPRB,4.5465E+03_JPRB,4.0538E+03_JPRB,3.6533E+03_JPRB,3.3147E+03_JPRB/)
KBO( :,55,16) = (/&
&5.3615E+03_JPRB,4.7268E+03_JPRB,4.2040E+03_JPRB,3.7715E+03_JPRB,3.4204E+03_JPRB/)
KBO( :,56,16) = (/&
&5.6101E+03_JPRB,4.9206E+03_JPRB,4.3611E+03_JPRB,3.9031E+03_JPRB,3.5302E+03_JPRB/)
KBO( :,57,16) = (/&
&5.8786E+03_JPRB,5.1280E+03_JPRB,4.5273E+03_JPRB,4.0416E+03_JPRB,3.6469E+03_JPRB/)
KBO( :,58,16) = (/&
&6.1495E+03_JPRB,5.3426E+03_JPRB,4.6971E+03_JPRB,4.1821E+03_JPRB,3.7629E+03_JPRB/)
KBO( :,59,16) = (/&
&6.2646E+03_JPRB,5.4342E+03_JPRB,4.7694E+03_JPRB,4.2411E+03_JPRB,3.8114E+03_JPRB/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
&5.19175E-02_JPRB, 4.28815E-02_JPRB, 3.54182E-02_JPRB, 2.92539E-02_JPRB, 2.41624E-02_JPRB,&
&1.99571E-02_JPRB, 1.64836E-02_JPRB, 1.36148E-02_JPRB, 1.12452E-02_JPRB, 9.28801E-03_JPRB/)
SELFREFO( :, 2) = (/&
&4.36985E-02_JPRB, 3.78503E-02_JPRB, 3.27848E-02_JPRB, 2.83973E-02_JPRB, 2.45969E-02_JPRB,&
&2.13051E-02_JPRB, 1.84538E-02_JPRB, 1.59842E-02_JPRB, 1.38450E-02_JPRB, 1.19921E-02_JPRB/)
SELFREFO( :, 3) = (/&
&4.25575E-02_JPRB, 3.71214E-02_JPRB, 3.23797E-02_JPRB, 2.82437E-02_JPRB, 2.46360E-02_JPRB,&
&2.14891E-02_JPRB, 1.87442E-02_JPRB, 1.63499E-02_JPRB, 1.42615E-02_JPRB, 1.24398E-02_JPRB/)
SELFREFO( :, 4) = (/&
&4.03854E-02_JPRB, 3.54677E-02_JPRB, 3.11488E-02_JPRB, 2.73558E-02_JPRB, 2.40247E-02_JPRB,&
&2.10992E-02_JPRB, 1.85300E-02_JPRB, 1.62736E-02_JPRB, 1.42920E-02_JPRB, 1.25517E-02_JPRB/)
SELFREFO( :, 5) = (/&
&3.95070E-02_JPRB, 3.46726E-02_JPRB, 3.04297E-02_JPRB, 2.67060E-02_JPRB, 2.34380E-02_JPRB,&
&2.05699E-02_JPRB, 1.80528E-02_JPRB, 1.58437E-02_JPRB, 1.39049E-02_JPRB, 1.22034E-02_JPRB/)
SELFREFO( :, 6) = (/&
&3.89748E-02_JPRB, 3.40186E-02_JPRB, 2.96926E-02_JPRB, 2.59168E-02_JPRB, 2.26211E-02_JPRB,&
&1.97445E-02_JPRB, 1.72337E-02_JPRB, 1.50422E-02_JPRB, 1.31293E-02_JPRB, 1.14597E-02_JPRB/)
SELFREFO( :, 7) = (/&
&3.85527E-02_JPRB, 3.36561E-02_JPRB, 2.93815E-02_JPRB, 2.56497E-02_JPRB, 2.23920E-02_JPRB,&
&1.95480E-02_JPRB, 1.70652E-02_JPRB, 1.48977E-02_JPRB, 1.30056E-02_JPRB, 1.13537E-02_JPRB/)
SELFREFO( :, 8) = (/&
&3.78212E-02_JPRB, 3.30614E-02_JPRB, 2.89005E-02_JPRB, 2.52633E-02_JPRB, 2.20839E-02_JPRB,&
&1.93046E-02_JPRB, 1.68751E-02_JPRB, 1.47513E-02_JPRB, 1.28948E-02_JPRB, 1.12720E-02_JPRB/)
SELFREFO( :, 9) = (/&
&3.68624E-02_JPRB, 3.22676E-02_JPRB, 2.82456E-02_JPRB, 2.47248E-02_JPRB, 2.16429E-02_JPRB,&
&1.89452E-02_JPRB, 1.65838E-02_JPRB, 1.45166E-02_JPRB, 1.27072E-02_JPRB, 1.11233E-02_JPRB/)
SELFREFO( :,10) = (/&
&3.63135E-02_JPRB, 3.19332E-02_JPRB, 2.80813E-02_JPRB, 2.46940E-02_JPRB, 2.17154E-02_JPRB,&
&1.90960E-02_JPRB, 1.67926E-02_JPRB, 1.47670E-02_JPRB, 1.29857E-02_JPRB, 1.14193E-02_JPRB/)
SELFREFO( :,11) = (/&
&3.60018E-02_JPRB, 3.17294E-02_JPRB, 2.79640E-02_JPRB, 2.46454E-02_JPRB, 2.17207E-02_JPRB,&
&1.91430E-02_JPRB, 1.68713E-02_JPRB, 1.48691E-02_JPRB, 1.31045E-02_JPRB, 1.15494E-02_JPRB/)
SELFREFO( :,12) = (/&
&3.65147E-02_JPRB, 3.19158E-02_JPRB, 2.78962E-02_JPRB, 2.43827E-02_JPRB, 2.13118E-02_JPRB,&
&1.86277E-02_JPRB, 1.62816E-02_JPRB, 1.42310E-02_JPRB, 1.24386E-02_JPRB, 1.08720E-02_JPRB/)
SELFREFO( :,13) = (/&
&3.72684E-02_JPRB, 3.23732E-02_JPRB, 2.81210E-02_JPRB, 2.44274E-02_JPRB, 2.12189E-02_JPRB,&
&1.84318E-02_JPRB, 1.60108E-02_JPRB, 1.39078E-02_JPRB, 1.20810E-02_JPRB, 1.04942E-02_JPRB/)
SELFREFO( :,14) = (/&
&3.87604E-02_JPRB, 3.34099E-02_JPRB, 2.87979E-02_JPRB, 2.48226E-02_JPRB, 2.13960E-02_JPRB,&
&1.84425E-02_JPRB, 1.58967E-02_JPRB, 1.37023E-02_JPRB, 1.18108E-02_JPRB, 1.01804E-02_JPRB/)
SELFREFO( :,15) = (/&
&3.51227E-02_JPRB, 3.05052E-02_JPRB, 2.64947E-02_JPRB, 2.30115E-02_JPRB, 1.99862E-02_JPRB,&
&1.73586E-02_JPRB, 1.50765E-02_JPRB, 1.30944E-02_JPRB, 1.13729E-02_JPRB, 9.87775E-03_JPRB/)
SELFREFO( :,16) = (/&
&3.51227E-02_JPRB, 3.05052E-02_JPRB, 2.64947E-02_JPRB, 2.30115E-02_JPRB, 1.99862E-02_JPRB,&
&1.73586E-02_JPRB, 1.50765E-02_JPRB, 1.30944E-02_JPRB, 1.13729E-02_JPRB, 9.87775E-03_JPRB/)

FRACREFAO( :, 1) = (/&
  &0.16461779_JPRB, 0.14889984_JPRB, 0.14233345_JPRB, 0.13156526_JPRB,&
  &0.11679733_JPRB, 0.09988949_JPRB, 0.08078653_JPRB, 0.06006384_JPRB,&
  &0.04028391_JPRB, 0.00435899_JPRB, 0.00359173_JPRB, 0.00281707_JPRB,&
  &0.00206767_JPRB, 0.00135012_JPRB, 0.00050720_JPRB, 0.00007146_JPRB/)
FRACREFAO( :, 2) = (/&
  &0.16442357_JPRB, 0.14944240_JPRB, 0.14245804_JPRB, 0.13111183_JPRB,&
  &0.11688625_JPRB, 0.09983791_JPRB, 0.08085148_JPRB, 0.05993948_JPRB,&
  &0.04028057_JPRB, 0.00435939_JPRB, 0.00358708_JPRB, 0.00284036_JPRB,&
  &0.00208869_JPRB, 0.00133256_JPRB, 0.00049260_JPRB, 0.00006931_JPRB/)
FRACREFAO( :, 3) = (/&
  &0.16368519_JPRB, 0.15018989_JPRB, 0.14262174_JPRB, 0.13084342_JPRB,&
  &0.11682195_JPRB, 0.09996257_JPRB, 0.08074036_JPRB, 0.05985692_JPRB,&
  &0.04045362_JPRB, 0.00436208_JPRB, 0.00358257_JPRB, 0.00287122_JPRB,&
  &0.00211004_JPRB, 0.00133804_JPRB, 0.00049260_JPRB, 0.00006931_JPRB/)
FRACREFAO( :, 4) = (/&
  &0.16274056_JPRB, 0.15133780_JPRB, 0.14228874_JPRB, 0.13081114_JPRB,&
  &0.11688486_JPRB, 0.09979610_JPRB, 0.08073687_JPRB, 0.05996741_JPRB,&
  &0.04040616_JPRB, 0.00439869_JPRB, 0.00368910_JPRB, 0.00293041_JPRB,&
  &0.00211604_JPRB, 0.00133536_JPRB, 0.00049260_JPRB, 0.00006931_JPRB/)
FRACREFAO( :, 5) = (/&
  &0.16176532_JPRB, 0.15207882_JPRB, 0.14226955_JPRB, 0.13079646_JPRB,&
  &0.11688191_JPRB, 0.09966998_JPRB, 0.08066384_JPRB, 0.06020275_JPRB,&
  &0.04047901_JPRB, 0.00446696_JPRB, 0.00377456_JPRB, 0.00294410_JPRB,&
  &0.00211082_JPRB, 0.00133536_JPRB, 0.00049260_JPRB, 0.00006931_JPRB/)
FRACREFAO( :, 6) = (/&
  &0.15993737_JPRB, 0.15305527_JPRB, 0.14259829_JPRB, 0.13078023_JPRB,&
  &0.11686983_JPRB, 0.09980131_JPRB, 0.08058286_JPRB, 0.06031430_JPRB,&
  &0.04082833_JPRB, 0.00450509_JPRB, 0.00377574_JPRB, 0.00294823_JPRB,&
  &0.00210977_JPRB, 0.00133302_JPRB, 0.00049260_JPRB, 0.00006931_JPRB/)
FRACREFAO( :, 7) = (/&
  &0.15371189_JPRB, 0.15592396_JPRB, 0.14430280_JPRB, 0.13076764_JPRB,&
  &0.11720382_JPRB, 0.10023471_JPRB, 0.08066396_JPRB, 0.06073554_JPRB,&
  &0.04121581_JPRB, 0.00451202_JPRB, 0.00377832_JPRB, 0.00294609_JPRB,&
  &0.00210943_JPRB, 0.00133336_JPRB, 0.00049260_JPRB, 0.00006931_JPRB/)
FRACREFAO( :, 8) = (/&
  &0.14262275_JPRB, 0.14572631_JPRB, 0.14560597_JPRB, 0.13736825_JPRB,&
  &0.12271351_JPRB, 0.10419556_JPRB, 0.08294533_JPRB, 0.06199794_JPRB,&
  &0.04157615_JPRB, 0.00452842_JPRB, 0.00377704_JPRB, 0.00293852_JPRB,&
  &0.00211034_JPRB, 0.00133278_JPRB, 0.00049259_JPRB, 0.00006931_JPRB/)
FRACREFAO( :, 9) = (/&
  &0.14500433_JPRB, 0.14590444_JPRB, 0.14430299_JPRB, 0.13770708_JPRB,&
  &0.12288283_JPRB, 0.10350952_JPRB, 0.08269450_JPRB, 0.06130579_JPRB,&
  &0.04144571_JPRB, 0.00452096_JPRB, 0.00377382_JPRB, 0.00294532_JPRB,&
  &0.00210943_JPRB, 0.00133228_JPRB, 0.00049260_JPRB, 0.00006931_JPRB/)

!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB7
