!OCL SCALAR
SUBROUTINE RRTM_KGB5

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 5:  700-820 cm-1 (low - H2O,CO2; high - O3,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO5 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO, CCL4O
USE YOERRTA5 , ONLY : STRRAT1   ,STRRAT2

!     ------------------------------------------------------------------


IMPLICIT NONE
CCL4O( :) = (/&
     &26.1407_JPRB,  53.9776_JPRB,  63.8085_JPRB,  36.1701_JPRB,&
     &15.4099_JPRB, 10.23116_JPRB,  4.82948_JPRB,  5.03836_JPRB,&
     &1.75558_JPRB,  _ZERO_     ,  _ZERO_     ,  _ZERO_     ,&
     &_ZERO_     ,  _ZERO_     ,  _ZERO_     ,  _ZERO_      /)

STRRAT1 = 90.4894_JPRB
STRRAT2 = 0.900502_JPRB

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 9 and corresponds to different water vapor to CO2 ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = h2o/(h20 + (rat) * co2), where rat is the ratio of the integrated
!     line strength in the band of co2 to that of h2o.  For instance,
!     JS=1 refers to dry air (eta = 0), JS = 9 corresponds to eta = 1.0.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature TREF-15, 
!     JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 1) = (/&
&1.2281E-06_JPRB,7.3444E-06_JPRB,1.3802E-05_JPRB,2.1363E-05_JPRB,3.4026E-05_JPRB,5.1149E-05_JPRB,&
&7.6454E-05_JPRB,1.1492E-04_JPRB,5.1051E-05_JPRB/)
KAO( :, 2, 1, 1) = (/&
&1.6369E-06_JPRB,8.9617E-06_JPRB,1.6072E-05_JPRB,2.4135E-05_JPRB,3.4106E-05_JPRB,4.9214E-05_JPRB,&
&7.9048E-05_JPRB,1.3905E-04_JPRB,5.4063E-05_JPRB/)
KAO( :, 3, 1, 1) = (/&
&2.1611E-06_JPRB,1.1094E-05_JPRB,1.8726E-05_JPRB,2.7825E-05_JPRB,3.8281E-05_JPRB,5.1592E-05_JPRB,&
&7.6813E-05_JPRB,1.3616E-04_JPRB,6.0994E-05_JPRB/)
KAO( :, 4, 1, 1) = (/&
&2.8032E-06_JPRB,1.3911E-05_JPRB,2.1873E-05_JPRB,3.1872E-05_JPRB,4.3669E-05_JPRB,5.8650E-05_JPRB,&
&8.1107E-05_JPRB,1.3247E-04_JPRB,6.8413E-05_JPRB/)
KAO( :, 5, 1, 1) = (/&
&3.5749E-06_JPRB,1.7399E-05_JPRB,2.6270E-05_JPRB,3.5363E-05_JPRB,4.8470E-05_JPRB,6.5479E-05_JPRB,&
&9.0735E-05_JPRB,1.4099E-04_JPRB,5.7731E-05_JPRB/)
KAO( :, 1, 2, 1) = (/&
&9.2208E-07_JPRB,5.6661E-06_JPRB,1.0853E-05_JPRB,1.7695E-05_JPRB,2.8111E-05_JPRB,4.1811E-05_JPRB,&
&5.7766E-05_JPRB,8.8171E-05_JPRB,3.6499E-05_JPRB/)
KAO( :, 2, 2, 1) = (/&
&1.2339E-06_JPRB,6.8718E-06_JPRB,1.2450E-05_JPRB,1.9038E-05_JPRB,2.7428E-05_JPRB,4.2214E-05_JPRB,&
&6.5891E-05_JPRB,1.0808E-04_JPRB,3.9328E-05_JPRB/)
KAO( :, 3, 2, 1) = (/&
&1.6382E-06_JPRB,8.4733E-06_JPRB,1.4470E-05_JPRB,2.1567E-05_JPRB,3.0172E-05_JPRB,4.1842E-05_JPRB,&
&6.2761E-05_JPRB,1.1359E-04_JPRB,4.4926E-05_JPRB/)
KAO( :, 4, 2, 1) = (/&
&2.1437E-06_JPRB,1.0582E-05_JPRB,1.7090E-05_JPRB,2.4961E-05_JPRB,3.4319E-05_JPRB,4.6334E-05_JPRB,&
&6.4942E-05_JPRB,1.0880E-04_JPRB,4.8706E-05_JPRB/)
KAO( :, 5, 2, 1) = (/&
&2.7550E-06_JPRB,1.3307E-05_JPRB,2.0303E-05_JPRB,2.7768E-05_JPRB,3.8649E-05_JPRB,5.3069E-05_JPRB,&
&7.1656E-05_JPRB,1.1174E-04_JPRB,4.2264E-05_JPRB/)
KAO( :, 1, 3, 1) = (/&
&6.5681E-07_JPRB,4.2928E-06_JPRB,8.6206E-06_JPRB,1.4813E-05_JPRB,2.2795E-05_JPRB,3.0956E-05_JPRB,&
&4.2159E-05_JPRB,6.7143E-05_JPRB,2.4558E-05_JPRB/)
KAO( :, 2, 3, 1) = (/&
&8.8032E-07_JPRB,5.0858E-06_JPRB,9.4979E-06_JPRB,1.4908E-05_JPRB,2.3302E-05_JPRB,3.4761E-05_JPRB,&
&5.2810E-05_JPRB,7.8083E-05_JPRB,2.7352E-05_JPRB/)
KAO( :, 3, 3, 1) = (/&
&1.1757E-06_JPRB,6.2479E-06_JPRB,1.1007E-05_JPRB,1.6613E-05_JPRB,2.3543E-05_JPRB,3.3879E-05_JPRB,&
&5.3064E-05_JPRB,9.3905E-05_JPRB,3.1433E-05_JPRB/)
KAO( :, 4, 3, 1) = (/&
&1.5541E-06_JPRB,7.7549E-06_JPRB,1.2987E-05_JPRB,1.9178E-05_JPRB,2.6197E-05_JPRB,3.5750E-05_JPRB,&
&5.1915E-05_JPRB,9.2229E-05_JPRB,2.9423E-05_JPRB/)
KAO( :, 5, 3, 1) = (/&
&2.0193E-06_JPRB,9.7639E-06_JPRB,1.5167E-05_JPRB,2.2031E-05_JPRB,3.0010E-05_JPRB,4.0258E-05_JPRB,&
&5.5267E-05_JPRB,9.0112E-05_JPRB,2.9943E-05_JPRB/)
KAO( :, 1, 4, 1) = (/&
&4.6419E-07_JPRB,3.2238E-06_JPRB,7.0968E-06_JPRB,1.2172E-05_JPRB,1.6732E-05_JPRB,2.2369E-05_JPRB,&
&3.1463E-05_JPRB,5.3229E-05_JPRB,1.7381E-05_JPRB/)
KAO( :, 2, 4, 1) = (/&
&6.2245E-07_JPRB,3.7726E-06_JPRB,7.2766E-06_JPRB,1.2504E-05_JPRB,1.9255E-05_JPRB,2.8079E-05_JPRB,&
&3.7485E-05_JPRB,5.7403E-05_JPRB,1.9667E-05_JPRB/)
KAO( :, 3, 4, 1) = (/&
&8.3351E-07_JPRB,4.5653E-06_JPRB,8.3036E-06_JPRB,1.2777E-05_JPRB,1.8816E-05_JPRB,2.9030E-05_JPRB,&
&4.4417E-05_JPRB,7.0863E-05_JPRB,2.1895E-05_JPRB/)
KAO( :, 4, 4, 1) = (/&
&1.1087E-06_JPRB,5.6384E-06_JPRB,9.6405E-06_JPRB,1.4565E-05_JPRB,2.0321E-05_JPRB,2.8264E-05_JPRB,&
&4.3444E-05_JPRB,7.7444E-05_JPRB,2.1414E-05_JPRB/)
KAO( :, 5, 4, 1) = (/&
&1.4581E-06_JPRB,7.0726E-06_JPRB,1.1402E-05_JPRB,1.6579E-05_JPRB,2.3011E-05_JPRB,3.1009E-05_JPRB,&
&4.3245E-05_JPRB,7.3708E-05_JPRB,2.2863E-05_JPRB/)
KAO( :, 1, 5, 1) = (/&
&3.3427E-07_JPRB,2.5337E-06_JPRB,5.7680E-06_JPRB,8.9425E-06_JPRB,1.2242E-05_JPRB,1.6995E-05_JPRB,&
&2.4164E-05_JPRB,4.4230E-05_JPRB,1.3422E-05_JPRB/)
KAO( :, 2, 5, 1) = (/&
&4.4601E-07_JPRB,2.8401E-06_JPRB,5.8531E-06_JPRB,1.0220E-05_JPRB,1.5419E-05_JPRB,2.0153E-05_JPRB,&
&2.7336E-05_JPRB,4.3727E-05_JPRB,1.5115E-05_JPRB/)
KAO( :, 3, 5, 1) = (/&
&5.9812E-07_JPRB,3.3532E-06_JPRB,6.3191E-06_JPRB,1.0031E-05_JPRB,1.5953E-05_JPRB,2.3950E-05_JPRB,&
&3.4195E-05_JPRB,5.0601E-05_JPRB,1.6591E-05_JPRB/)
KAO( :, 4, 5, 1) = (/&
&7.9837E-07_JPRB,4.1280E-06_JPRB,7.3147E-06_JPRB,1.1079E-05_JPRB,1.5854E-05_JPRB,2.3810E-05_JPRB,&
&3.6514E-05_JPRB,6.2591E-05_JPRB,1.7658E-05_JPRB/)
KAO( :, 5, 5, 1) = (/&
&1.0575E-06_JPRB,5.1440E-06_JPRB,8.5910E-06_JPRB,1.2709E-05_JPRB,1.7592E-05_JPRB,2.4262E-05_JPRB,&
&3.5276E-05_JPRB,6.2368E-05_JPRB,1.9388E-05_JPRB/)
KAO( :, 1, 6, 1) = (/&
&2.4467E-07_JPRB,2.0115E-06_JPRB,4.4506E-06_JPRB,6.5328E-06_JPRB,9.2134E-06_JPRB,1.2867E-05_JPRB,&
&1.9266E-05_JPRB,3.4226E-05_JPRB,1.1020E-05_JPRB/)
KAO( :, 2, 6, 1) = (/&
&3.2244E-07_JPRB,2.1802E-06_JPRB,4.7859E-06_JPRB,8.3031E-06_JPRB,1.1024E-05_JPRB,1.4816E-05_JPRB,&
&2.0767E-05_JPRB,3.3867E-05_JPRB,1.2361E-05_JPRB/)
KAO( :, 3, 6, 1) = (/&
&4.3252E-07_JPRB,2.5034E-06_JPRB,4.8788E-06_JPRB,8.5188E-06_JPRB,1.3353E-05_JPRB,1.8353E-05_JPRB,&
&2.4440E-05_JPRB,3.7220E-05_JPRB,1.3756E-05_JPRB/)
KAO( :, 4, 6, 1) = (/&
&5.7866E-07_JPRB,3.0227E-06_JPRB,5.4901E-06_JPRB,8.5441E-06_JPRB,1.3294E-05_JPRB,1.9970E-05_JPRB,&
&3.0079E-05_JPRB,4.5487E-05_JPRB,1.5370E-05_JPRB/)
KAO( :, 5, 6, 1) = (/&
&7.6960E-07_JPRB,3.7504E-06_JPRB,6.3767E-06_JPRB,9.6311E-06_JPRB,1.3563E-05_JPRB,1.9464E-05_JPRB,&
&3.0023E-05_JPRB,5.3031E-05_JPRB,1.7349E-05_JPRB/)
KAO( :, 1, 7, 1) = (/&
&1.8363E-07_JPRB,1.6339E-06_JPRB,3.2365E-06_JPRB,4.8736E-06_JPRB,7.0565E-06_JPRB,1.0168E-05_JPRB,&
&1.5448E-05_JPRB,2.6119E-05_JPRB,9.9973E-06_JPRB/)
KAO( :, 2, 7, 1) = (/&
&2.3828E-07_JPRB,1.7045E-06_JPRB,3.9446E-06_JPRB,5.9885E-06_JPRB,8.1187E-06_JPRB,1.1164E-05_JPRB,&
&1.5910E-05_JPRB,2.7804E-05_JPRB,1.1252E-05_JPRB/)
KAO( :, 3, 7, 1) = (/&
&3.1712E-07_JPRB,1.8915E-06_JPRB,4.0133E-06_JPRB,6.9371E-06_JPRB,1.0184E-05_JPRB,1.3247E-05_JPRB,&
&1.8144E-05_JPRB,2.8687E-05_JPRB,1.2767E-05_JPRB/)
KAO( :, 4, 7, 1) = (/&
&4.2549E-07_JPRB,2.2415E-06_JPRB,4.2001E-06_JPRB,7.0066E-06_JPRB,1.0950E-05_JPRB,1.6323E-05_JPRB,&
&2.2218E-05_JPRB,3.2987E-05_JPRB,1.4591E-05_JPRB/)
KAO( :, 5, 7, 1) = (/&
&5.6782E-07_JPRB,2.7608E-06_JPRB,4.8541E-06_JPRB,7.3705E-06_JPRB,1.0748E-05_JPRB,1.6390E-05_JPRB,&
&2.5035E-05_JPRB,4.1583E-05_JPRB,1.6759E-05_JPRB/)
KAO( :, 1, 8, 1) = (/&
&1.4297E-07_JPRB,1.2986E-06_JPRB,2.4296E-06_JPRB,3.7740E-06_JPRB,5.5717E-06_JPRB,8.1007E-06_JPRB,&
&1.2269E-05_JPRB,2.0668E-05_JPRB,1.1224E-05_JPRB/)
KAO( :, 2, 8, 1) = (/&
&1.8237E-07_JPRB,1.3796E-06_JPRB,2.9841E-06_JPRB,4.4232E-06_JPRB,6.1625E-06_JPRB,8.6070E-06_JPRB,&
&1.2749E-05_JPRB,2.2374E-05_JPRB,1.3050E-05_JPRB/)
KAO( :, 3, 8, 1) = (/&
&2.3995E-07_JPRB,1.4828E-06_JPRB,3.2302E-06_JPRB,5.5721E-06_JPRB,7.4009E-06_JPRB,9.9584E-06_JPRB,&
&1.3793E-05_JPRB,2.2720E-05_JPRB,1.5037E-05_JPRB/)
KAO( :, 4, 8, 1) = (/&
&3.2109E-07_JPRB,1.7086E-06_JPRB,3.3052E-06_JPRB,5.7552E-06_JPRB,9.1163E-06_JPRB,1.2137E-05_JPRB,&
&1.6200E-05_JPRB,2.4932E-05_JPRB,1.7316E-05_JPRB/)
KAO( :, 5, 8, 1) = (/&
&4.2933E-07_JPRB,2.0665E-06_JPRB,3.6851E-06_JPRB,5.7093E-06_JPRB,9.1231E-06_JPRB,1.3616E-05_JPRB,&
&2.0240E-05_JPRB,2.9795E-05_JPRB,1.9811E-05_JPRB/)
KAO( :, 1, 9, 1) = (/&
&1.1391E-07_JPRB,9.6607E-07_JPRB,1.8596E-06_JPRB,2.9960E-06_JPRB,4.4278E-06_JPRB,6.4496E-06_JPRB,&
&9.3668E-06_JPRB,1.6296E-05_JPRB,2.3175E-05_JPRB/)
KAO( :, 2, 9, 1) = (/&
&1.4318E-07_JPRB,1.1432E-06_JPRB,2.1917E-06_JPRB,3.3465E-06_JPRB,4.7894E-06_JPRB,6.8583E-06_JPRB,&
&1.0124E-05_JPRB,1.7732E-05_JPRB,2.8424E-05_JPRB/)
KAO( :, 3, 9, 1) = (/&
&1.8594E-07_JPRB,1.1885E-06_JPRB,2.6962E-06_JPRB,4.0343E-06_JPRB,5.5351E-06_JPRB,7.5514E-06_JPRB,&
&1.0675E-05_JPRB,1.8150E-05_JPRB,3.4053E-05_JPRB/)
KAO( :, 4, 9, 1) = (/&
&2.4670E-07_JPRB,1.3380E-06_JPRB,2.7503E-06_JPRB,4.7549E-06_JPRB,6.8876E-06_JPRB,8.9087E-06_JPRB,&
&1.2295E-05_JPRB,1.9210E-05_JPRB,3.9839E-05_JPRB/)
KAO( :, 5, 9, 1) = (/&
&3.3010E-07_JPRB,1.5784E-06_JPRB,2.8513E-06_JPRB,4.8049E-06_JPRB,7.4827E-06_JPRB,1.1096E-05_JPRB,&
&1.4749E-05_JPRB,2.1955E-05_JPRB,4.5594E-05_JPRB/)
KAO( :, 1,10, 1) = (/&
&9.5530E-08_JPRB,7.6103E-07_JPRB,1.4822E-06_JPRB,2.4013E-06_JPRB,3.5241E-06_JPRB,5.0863E-06_JPRB,&
&7.7041E-06_JPRB,1.2423E-05_JPRB,8.9067E-05_JPRB/)
KAO( :, 2,10, 1) = (/&
&1.1882E-07_JPRB,9.2450E-07_JPRB,1.6979E-06_JPRB,2.6207E-06_JPRB,3.8503E-06_JPRB,5.4657E-06_JPRB,&
&7.9684E-06_JPRB,1.3651E-05_JPRB,1.1125E-04_JPRB/)
KAO( :, 3,10, 1) = (/&
&1.5289E-07_JPRB,9.7942E-07_JPRB,2.0846E-06_JPRB,3.0524E-06_JPRB,4.2640E-06_JPRB,5.9216E-06_JPRB,&
&8.6666E-06_JPRB,1.4411E-05_JPRB,1.3376E-04_JPRB/)
KAO( :, 4,10, 1) = (/&
&2.0094E-07_JPRB,1.0816E-06_JPRB,2.2331E-06_JPRB,3.8855E-06_JPRB,5.1239E-06_JPRB,6.8144E-06_JPRB,&
&9.5102E-06_JPRB,1.5396E-05_JPRB,1.5621E-04_JPRB/)
KAO( :, 5,10, 1) = (/&
&2.6711E-07_JPRB,1.2572E-06_JPRB,2.3283E-06_JPRB,3.9502E-06_JPRB,6.1703E-06_JPRB,8.4471E-06_JPRB,&
&1.1047E-05_JPRB,1.7057E-05_JPRB,1.7815E-04_JPRB/)
KAO( :, 1,11, 1) = (/&
&8.8479E-08_JPRB,6.5723E-07_JPRB,1.2585E-06_JPRB,2.0039E-06_JPRB,2.9121E-06_JPRB,4.1955E-06_JPRB,&
&6.2637E-06_JPRB,1.0419E-05_JPRB,1.7219E-04_JPRB/)
KAO( :, 2,11, 1) = (/&
&1.1103E-07_JPRB,7.9724E-07_JPRB,1.4388E-06_JPRB,2.1938E-06_JPRB,3.2099E-06_JPRB,4.5380E-06_JPRB,&
&6.5334E-06_JPRB,1.1529E-05_JPRB,2.1393E-04_JPRB/)
KAO( :, 3,11, 1) = (/&
&1.4325E-07_JPRB,8.5009E-07_JPRB,1.7790E-06_JPRB,2.5762E-06_JPRB,3.5853E-06_JPRB,4.9027E-06_JPRB,&
&7.2087E-06_JPRB,1.1783E-05_JPRB,2.5548E-04_JPRB/)
KAO( :, 4,11, 1) = (/&
&1.8796E-07_JPRB,9.4910E-07_JPRB,1.8794E-06_JPRB,3.2448E-06_JPRB,4.3096E-06_JPRB,5.7004E-06_JPRB,&
&7.8146E-06_JPRB,1.2759E-05_JPRB,2.9570E-04_JPRB/)
KAO( :, 5,11, 1) = (/&
&2.4830E-07_JPRB,1.0997E-06_JPRB,1.9987E-06_JPRB,3.2788E-06_JPRB,5.0983E-06_JPRB,7.0948E-06_JPRB,&
&9.2185E-06_JPRB,1.4157E-05_JPRB,3.3417E-04_JPRB/)
KAO( :, 1,12, 1) = (/&
&7.8411E-08_JPRB,5.6432E-07_JPRB,1.0564E-06_JPRB,1.6792E-06_JPRB,2.4262E-06_JPRB,3.3875E-06_JPRB,&
&5.1824E-06_JPRB,8.5930E-06_JPRB,2.1970E-04_JPRB/)
KAO( :, 2,12, 1) = (/&
&9.8958E-08_JPRB,6.8328E-07_JPRB,1.2215E-06_JPRB,1.8350E-06_JPRB,2.6716E-06_JPRB,3.7787E-06_JPRB,&
&5.3849E-06_JPRB,9.1860E-06_JPRB,2.7209E-04_JPRB/)
KAO( :, 3,12, 1) = (/&
&1.2797E-07_JPRB,7.2421E-07_JPRB,1.5209E-06_JPRB,2.1711E-06_JPRB,3.0040E-06_JPRB,4.0829E-06_JPRB,&
&6.0229E-06_JPRB,9.7068E-06_JPRB,3.2380E-04_JPRB/)
KAO( :, 4,12, 1) = (/&
&1.6772E-07_JPRB,8.1500E-07_JPRB,1.5843E-06_JPRB,2.7212E-06_JPRB,3.6141E-06_JPRB,4.7595E-06_JPRB,&
&6.4840E-06_JPRB,1.0629E-05_JPRB,3.7332E-04_JPRB/)
KAO( :, 5,12, 1) = (/&
&2.2081E-07_JPRB,9.4887E-07_JPRB,1.7061E-06_JPRB,2.7338E-06_JPRB,4.2409E-06_JPRB,5.9628E-06_JPRB,&
&7.7123E-06_JPRB,1.1668E-05_JPRB,4.2006E-04_JPRB/)
KAO( :, 1,13, 1) = (/&
&6.9984E-08_JPRB,4.8746E-07_JPRB,8.9934E-07_JPRB,1.4101E-06_JPRB,2.0188E-06_JPRB,2.7991E-06_JPRB,&
&4.1521E-06_JPRB,7.2727E-06_JPRB,2.2865E-04_JPRB/)
KAO( :, 2,13, 1) = (/&
&8.8821E-08_JPRB,5.8672E-07_JPRB,1.0421E-06_JPRB,1.5517E-06_JPRB,2.2340E-06_JPRB,3.1346E-06_JPRB,&
&4.4727E-06_JPRB,7.4604E-06_JPRB,2.8267E-04_JPRB/)
KAO( :, 3,13, 1) = (/&
&1.1504E-07_JPRB,6.2137E-07_JPRB,1.3015E-06_JPRB,1.8350E-06_JPRB,2.5305E-06_JPRB,3.4076E-06_JPRB,&
&4.9426E-06_JPRB,8.0265E-06_JPRB,3.3576E-04_JPRB/)
KAO( :, 4,13, 1) = (/&
&1.5036E-07_JPRB,7.0084E-07_JPRB,1.3483E-06_JPRB,2.2875E-06_JPRB,3.0337E-06_JPRB,3.9839E-06_JPRB,&
&5.4210E-06_JPRB,8.7755E-06_JPRB,3.8637E-04_JPRB/)
KAO( :, 5,13, 1) = (/&
&1.9712E-07_JPRB,8.1525E-07_JPRB,1.4451E-06_JPRB,2.3051E-06_JPRB,3.5032E-06_JPRB,5.0029E-06_JPRB,&
&6.4407E-06_JPRB,9.6564E-06_JPRB,4.3385E-04_JPRB/)
KAO( :, 1, 1, 2) = (/&
&3.7010E-06_JPRB,1.8091E-05_JPRB,2.8711E-05_JPRB,4.8863E-05_JPRB,7.2307E-05_JPRB,1.1413E-04_JPRB,&
&1.8771E-04_JPRB,3.6122E-04_JPRB,1.1281E-04_JPRB/)
KAO( :, 2, 1, 2) = (/&
&5.3266E-06_JPRB,2.4423E-05_JPRB,3.4269E-05_JPRB,4.7704E-05_JPRB,7.6078E-05_JPRB,1.1442E-04_JPRB,&
&1.6436E-04_JPRB,3.2838E-04_JPRB,8.7847E-05_JPRB/)
KAO( :, 3, 1, 2) = (/&
&7.5177E-06_JPRB,3.2854E-05_JPRB,4.4289E-05_JPRB,5.4913E-05_JPRB,7.2779E-05_JPRB,1.0814E-04_JPRB,&
&1.7906E-04_JPRB,2.8467E-04_JPRB,8.6883E-05_JPRB/)
KAO( :, 4, 1, 2) = (/&
&1.0391E-05_JPRB,4.3522E-05_JPRB,5.8544E-05_JPRB,6.9693E-05_JPRB,8.1288E-05_JPRB,1.0220E-04_JPRB,&
&1.5047E-04_JPRB,3.0285E-04_JPRB,9.1049E-05_JPRB/)
KAO( :, 5, 1, 2) = (/&
&1.4024E-05_JPRB,5.6758E-05_JPRB,7.6016E-05_JPRB,9.1662E-05_JPRB,1.0372E-04_JPRB,1.1700E-04_JPRB,&
&1.4991E-04_JPRB,2.3704E-04_JPRB,1.3000E-04_JPRB/)
KAO( :, 1, 2, 2) = (/&
&2.7903E-06_JPRB,1.3902E-05_JPRB,2.3771E-05_JPRB,3.9190E-05_JPRB,6.1137E-05_JPRB,9.7231E-05_JPRB,&
&1.5250E-04_JPRB,2.8746E-04_JPRB,7.5943E-05_JPRB/)
KAO( :, 2, 2, 2) = (/&
&4.0561E-06_JPRB,1.8720E-05_JPRB,2.7225E-05_JPRB,3.9741E-05_JPRB,6.4537E-05_JPRB,9.0899E-05_JPRB,&
&1.4609E-04_JPRB,2.7008E-04_JPRB,6.2612E-05_JPRB/)
KAO( :, 3, 2, 2) = (/&
&5.7887E-06_JPRB,2.5353E-05_JPRB,3.4446E-05_JPRB,4.3750E-05_JPRB,5.8352E-05_JPRB,9.7668E-05_JPRB,&
&1.4210E-04_JPRB,2.4211E-04_JPRB,6.1269E-05_JPRB/)
KAO( :, 4, 2, 2) = (/&
&8.0784E-06_JPRB,3.3950E-05_JPRB,4.5325E-05_JPRB,5.3921E-05_JPRB,6.4280E-05_JPRB,8.5665E-05_JPRB,&
&1.3688E-04_JPRB,2.4556E-04_JPRB,6.9568E-05_JPRB/)
KAO( :, 5, 2, 2) = (/&
&1.1019E-05_JPRB,4.4672E-05_JPRB,5.9575E-05_JPRB,7.1166E-05_JPRB,7.9595E-05_JPRB,9.1088E-05_JPRB,&
&1.2520E-04_JPRB,2.1802E-04_JPRB,9.5557E-05_JPRB/)
KAO( :, 1, 3, 2) = (/&
&1.9479E-06_JPRB,1.0095E-05_JPRB,1.9141E-05_JPRB,3.0705E-05_JPRB,5.2363E-05_JPRB,7.9991E-05_JPRB,&
&1.2823E-04_JPRB,2.3806E-04_JPRB,4.6992E-05_JPRB/)
KAO( :, 2, 3, 2) = (/&
&2.8509E-06_JPRB,1.3413E-05_JPRB,2.1137E-05_JPRB,3.4101E-05_JPRB,4.9706E-05_JPRB,7.8708E-05_JPRB,&
&1.2808E-04_JPRB,2.2769E-04_JPRB,4.2012E-05_JPRB/)
KAO( :, 3, 3, 2) = (/&
&4.1189E-06_JPRB,1.8265E-05_JPRB,2.5419E-05_JPRB,3.4683E-05_JPRB,5.2513E-05_JPRB,8.0240E-05_JPRB,&
&1.1481E-04_JPRB,2.1816E-04_JPRB,4.3174E-05_JPRB/)
KAO( :, 4, 3, 2) = (/&
&5.8233E-06_JPRB,2.4801E-05_JPRB,3.3200E-05_JPRB,4.0180E-05_JPRB,5.1786E-05_JPRB,7.2468E-05_JPRB,&
&1.2549E-04_JPRB,1.9856E-04_JPRB,5.6282E-05_JPRB/)
KAO( :, 5, 3, 2) = (/&
&8.0612E-06_JPRB,3.3094E-05_JPRB,4.4191E-05_JPRB,5.1801E-05_JPRB,5.9300E-05_JPRB,7.2075E-05_JPRB,&
&1.0386E-04_JPRB,2.0859E-04_JPRB,6.8039E-05_JPRB/)
KAO( :, 1, 4, 2) = (/&
&1.3432E-06_JPRB,7.4538E-06_JPRB,1.4964E-05_JPRB,2.5625E-05_JPRB,4.3243E-05_JPRB,6.6019E-05_JPRB,&
&1.0530E-04_JPRB,1.9952E-04_JPRB,3.1575E-05_JPRB/)
KAO( :, 2, 4, 2) = (/&
&1.9591E-06_JPRB,9.5155E-06_JPRB,1.6737E-05_JPRB,2.6791E-05_JPRB,4.2345E-05_JPRB,6.7439E-05_JPRB,&
&1.0271E-04_JPRB,1.8871E-04_JPRB,3.0704E-05_JPRB/)
KAO( :, 3, 4, 2) = (/&
&2.8537E-06_JPRB,1.2845E-05_JPRB,1.8934E-05_JPRB,2.8752E-05_JPRB,4.4199E-05_JPRB,6.2430E-05_JPRB,&
&1.0202E-04_JPRB,1.8062E-04_JPRB,3.4088E-05_JPRB/)
KAO( :, 4, 4, 2) = (/&
&4.0888E-06_JPRB,1.7612E-05_JPRB,2.3922E-05_JPRB,3.0749E-05_JPRB,4.2010E-05_JPRB,6.5728E-05_JPRB,&
&9.6566E-05_JPRB,1.7460E-04_JPRB,4.3387E-05_JPRB/)
KAO( :, 5, 4, 2) = (/&
&5.7388E-06_JPRB,2.3829E-05_JPRB,3.1758E-05_JPRB,3.7789E-05_JPRB,4.5312E-05_JPRB,5.9095E-05_JPRB,&
&1.0064E-04_JPRB,1.6850E-04_JPRB,5.1079E-05_JPRB/)
KAO( :, 1, 5, 2) = (/&
&9.4882E-07_JPRB,5.7155E-06_JPRB,1.1980E-05_JPRB,2.2295E-05_JPRB,3.5116E-05_JPRB,5.3339E-05_JPRB,&
&8.8729E-05_JPRB,1.5937E-04_JPRB,2.5456E-05_JPRB/)
KAO( :, 2, 5, 2) = (/&
&1.3669E-06_JPRB,6.8739E-06_JPRB,1.3459E-05_JPRB,2.1396E-05_JPRB,3.6297E-05_JPRB,5.4282E-05_JPRB,&
&8.6042E-05_JPRB,1.6025E-04_JPRB,2.6654E-05_JPRB/)
KAO( :, 3, 5, 2) = (/&
&1.9884E-06_JPRB,9.0859E-06_JPRB,1.4605E-05_JPRB,2.3671E-05_JPRB,3.4093E-05_JPRB,5.5324E-05_JPRB,&
&8.6463E-05_JPRB,1.5363E-04_JPRB,3.0684E-05_JPRB/)
KAO( :, 4, 5, 2) = (/&
&2.8701E-06_JPRB,1.2430E-05_JPRB,1.7294E-05_JPRB,2.4580E-05_JPRB,3.7203E-05_JPRB,5.3154E-05_JPRB,&
&8.1963E-05_JPRB,1.5281E-04_JPRB,3.6321E-05_JPRB/)
KAO( :, 5, 5, 2) = (/&
&4.0709E-06_JPRB,1.7029E-05_JPRB,2.2743E-05_JPRB,2.7902E-05_JPRB,3.6353E-05_JPRB,5.3115E-05_JPRB,&
&8.4864E-05_JPRB,1.3732E-04_JPRB,4.2547E-05_JPRB/)
KAO( :, 1, 6, 2) = (/&
&6.8988E-07_JPRB,4.4652E-06_JPRB,9.7580E-06_JPRB,1.7678E-05_JPRB,2.8332E-05_JPRB,4.4145E-05_JPRB,&
&7.0109E-05_JPRB,1.2493E-04_JPRB,2.3716E-05_JPRB/)
KAO( :, 2, 6, 2) = (/&
&9.7314E-07_JPRB,5.0974E-06_JPRB,1.0412E-05_JPRB,1.7485E-05_JPRB,2.9376E-05_JPRB,4.4804E-05_JPRB,&
&7.0122E-05_JPRB,1.3276E-04_JPRB,2.6375E-05_JPRB/)
KAO( :, 3, 6, 2) = (/&
&1.3972E-06_JPRB,6.4724E-06_JPRB,1.1564E-05_JPRB,1.8858E-05_JPRB,2.8568E-05_JPRB,4.7043E-05_JPRB,&
&7.0202E-05_JPRB,1.2748E-04_JPRB,3.0169E-05_JPRB/)
KAO( :, 4, 6, 2) = (/&
&2.0156E-06_JPRB,8.7063E-06_JPRB,1.3025E-05_JPRB,2.0355E-05_JPRB,3.0069E-05_JPRB,4.4240E-05_JPRB,&
&7.1336E-05_JPRB,1.2324E-04_JPRB,3.4994E-05_JPRB/)
KAO( :, 5, 6, 2) = (/&
&2.8756E-06_JPRB,1.1976E-05_JPRB,1.6242E-05_JPRB,2.1147E-05_JPRB,3.0629E-05_JPRB,4.5526E-05_JPRB,&
&6.5474E-05_JPRB,1.2130E-04_JPRB,4.0495E-05_JPRB/)
KAO( :, 1, 7, 2) = (/&
&5.2255E-07_JPRB,3.4411E-06_JPRB,7.7789E-06_JPRB,1.4395E-05_JPRB,2.2965E-05_JPRB,3.5662E-05_JPRB,&
&5.5652E-05_JPRB,9.9078E-05_JPRB,2.5677E-05_JPRB/)
KAO( :, 2, 7, 2) = (/&
&7.2172E-07_JPRB,4.0179E-06_JPRB,8.3376E-06_JPRB,1.4853E-05_JPRB,2.4331E-05_JPRB,3.6364E-05_JPRB,&
&5.7791E-05_JPRB,1.0563E-04_JPRB,2.9556E-05_JPRB/)
KAO( :, 3, 7, 2) = (/&
&1.0201E-06_JPRB,4.7217E-06_JPRB,9.3095E-06_JPRB,1.5083E-05_JPRB,2.5365E-05_JPRB,3.7347E-05_JPRB,&
&5.8190E-05_JPRB,1.0603E-04_JPRB,3.3998E-05_JPRB/)
KAO( :, 4, 7, 2) = (/&
&1.4537E-06_JPRB,6.1748E-06_JPRB,1.0020E-05_JPRB,1.6138E-05_JPRB,2.3962E-05_JPRB,3.7967E-05_JPRB,&
&5.8451E-05_JPRB,1.0372E-04_JPRB,3.9119E-05_JPRB/)
KAO( :, 5, 7, 2) = (/&
&2.0693E-06_JPRB,8.4363E-06_JPRB,1.1705E-05_JPRB,1.7001E-05_JPRB,2.5826E-05_JPRB,3.5527E-05_JPRB,&
&5.8296E-05_JPRB,1.0385E-04_JPRB,4.4936E-05_JPRB/)
KAO( :, 1, 8, 2) = (/&
&4.1700E-07_JPRB,2.7639E-06_JPRB,6.4938E-06_JPRB,1.1630E-05_JPRB,1.8371E-05_JPRB,2.7706E-05_JPRB,&
&4.4850E-05_JPRB,8.0696E-05_JPRB,3.5956E-05_JPRB/)
KAO( :, 2, 8, 2) = (/&
&5.6411E-07_JPRB,3.1556E-06_JPRB,6.9457E-06_JPRB,1.2120E-05_JPRB,1.9397E-05_JPRB,2.9581E-05_JPRB,&
&4.6513E-05_JPRB,8.4727E-05_JPRB,4.2511E-05_JPRB/)
KAO( :, 3, 8, 2) = (/&
&7.8647E-07_JPRB,3.6535E-06_JPRB,7.3255E-06_JPRB,1.2353E-05_JPRB,2.0079E-05_JPRB,3.0844E-05_JPRB,&
&4.7401E-05_JPRB,8.6525E-05_JPRB,4.9724E-05_JPRB/)
KAO( :, 4, 8, 2) = (/&
&1.1061E-06_JPRB,4.5424E-06_JPRB,7.9917E-06_JPRB,1.3185E-05_JPRB,1.9791E-05_JPRB,3.2038E-05_JPRB,&
&4.8054E-05_JPRB,8.5457E-05_JPRB,5.7233E-05_JPRB/)
KAO( :, 5, 8, 2) = (/&
&1.5569E-06_JPRB,6.0599E-06_JPRB,9.0209E-06_JPRB,1.3990E-05_JPRB,2.0815E-05_JPRB,3.0475E-05_JPRB,&
&4.9899E-05_JPRB,8.4659E-05_JPRB,6.5356E-05_JPRB/)
KAO( :, 1, 9, 2) = (/&
&3.4646E-07_JPRB,2.3339E-06_JPRB,5.2376E-06_JPRB,9.2182E-06_JPRB,1.4337E-05_JPRB,2.2490E-05_JPRB,&
&3.6396E-05_JPRB,6.1412E-05_JPRB,1.0490E-04_JPRB/)
KAO( :, 2, 9, 2) = (/&
&4.5919E-07_JPRB,2.4585E-06_JPRB,5.5676E-06_JPRB,9.8533E-06_JPRB,1.5559E-05_JPRB,2.3683E-05_JPRB,&
&3.6999E-05_JPRB,7.0677E-05_JPRB,1.2405E-04_JPRB/)
KAO( :, 3, 9, 2) = (/&
&6.2898E-07_JPRB,2.9262E-06_JPRB,5.8022E-06_JPRB,1.0344E-05_JPRB,1.6840E-05_JPRB,2.4691E-05_JPRB,&
&3.8818E-05_JPRB,7.0031E-05_JPRB,1.4290E-04_JPRB/)
KAO( :, 4, 9, 2) = (/&
&8.7625E-07_JPRB,3.4474E-06_JPRB,6.4904E-06_JPRB,1.0589E-05_JPRB,1.7378E-05_JPRB,2.5849E-05_JPRB,&
&3.9400E-05_JPRB,7.0716E-05_JPRB,1.6112E-04_JPRB/)
KAO( :, 5, 9, 2) = (/&
&1.2209E-06_JPRB,4.4922E-06_JPRB,7.0958E-06_JPRB,1.1298E-05_JPRB,1.6936E-05_JPRB,2.6020E-05_JPRB,&
&4.0325E-05_JPRB,7.2083E-05_JPRB,1.7893E-04_JPRB/)
KAO( :, 1,10, 2) = (/&
&3.1214E-07_JPRB,1.9536E-06_JPRB,4.2576E-06_JPRB,7.3396E-06_JPRB,1.1621E-05_JPRB,1.8021E-05_JPRB,&
&2.8013E-05_JPRB,4.7749E-05_JPRB,4.9962E-04_JPRB/)
KAO( :, 2,10, 2) = (/&
&4.0887E-07_JPRB,2.0598E-06_JPRB,4.7149E-06_JPRB,8.0606E-06_JPRB,1.2573E-05_JPRB,1.8809E-05_JPRB,&
&3.0275E-05_JPRB,5.6188E-05_JPRB,5.8548E-04_JPRB/)
KAO( :, 3,10, 2) = (/&
&5.5155E-07_JPRB,2.4175E-06_JPRB,4.9545E-06_JPRB,8.5941E-06_JPRB,1.3457E-05_JPRB,2.0204E-05_JPRB,&
&3.1138E-05_JPRB,5.6286E-05_JPRB,6.6291E-04_JPRB/)
KAO( :, 4,10, 2) = (/&
&7.5650E-07_JPRB,2.8298E-06_JPRB,5.3256E-06_JPRB,8.7402E-06_JPRB,1.3978E-05_JPRB,2.1601E-05_JPRB,&
&3.2082E-05_JPRB,5.7693E-05_JPRB,7.2972E-04_JPRB/)
KAO( :, 5,10, 2) = (/&
&1.0427E-06_JPRB,3.5400E-06_JPRB,5.8501E-06_JPRB,9.4137E-06_JPRB,1.4055E-05_JPRB,2.2092E-05_JPRB,&
&3.3371E-05_JPRB,5.7680E-05_JPRB,7.8611E-04_JPRB/)
KAO( :, 1,11, 2) = (/&
&3.2074E-07_JPRB,1.7276E-06_JPRB,3.6239E-06_JPRB,6.1854E-06_JPRB,9.6607E-06_JPRB,1.4993E-05_JPRB,&
&2.3443E-05_JPRB,4.1061E-05_JPRB,1.0142E-03_JPRB/)
KAO( :, 2,11, 2) = (/&
&4.2113E-07_JPRB,1.8116E-06_JPRB,4.1199E-06_JPRB,6.7716E-06_JPRB,1.0543E-05_JPRB,1.5526E-05_JPRB,&
&2.4849E-05_JPRB,4.5454E-05_JPRB,1.1742E-03_JPRB/)
KAO( :, 3,11, 2) = (/&
&5.6514E-07_JPRB,2.1552E-06_JPRB,4.2148E-06_JPRB,7.3585E-06_JPRB,1.1239E-05_JPRB,1.6846E-05_JPRB,&
&2.5655E-05_JPRB,4.5531E-05_JPRB,1.3139E-03_JPRB/)
KAO( :, 4,11, 2) = (/&
&7.6814E-07_JPRB,2.5322E-06_JPRB,4.6852E-06_JPRB,7.3538E-06_JPRB,1.1830E-05_JPRB,1.8155E-05_JPRB,&
&2.6824E-05_JPRB,4.7139E-05_JPRB,1.4305E-03_JPRB/)
KAO( :, 5,11, 2) = (/&
&1.0464E-06_JPRB,3.2313E-06_JPRB,5.0889E-06_JPRB,8.1260E-06_JPRB,1.1741E-05_JPRB,1.8567E-05_JPRB,&
&2.7673E-05_JPRB,4.7684E-05_JPRB,1.5261E-03_JPRB/)
KAO( :, 1,12, 2) = (/&
&3.0483E-07_JPRB,1.4986E-06_JPRB,3.1036E-06_JPRB,5.2551E-06_JPRB,7.9883E-06_JPRB,1.2411E-05_JPRB,&
&1.9208E-05_JPRB,3.3894E-05_JPRB,1.3243E-03_JPRB/)
KAO( :, 2,12, 2) = (/&
&4.0026E-07_JPRB,1.5746E-06_JPRB,3.5034E-06_JPRB,5.7409E-06_JPRB,8.9248E-06_JPRB,1.2928E-05_JPRB,&
&2.0014E-05_JPRB,3.7406E-05_JPRB,1.5202E-03_JPRB/)
KAO( :, 3,12, 2) = (/&
&5.3553E-07_JPRB,1.8879E-06_JPRB,3.5598E-06_JPRB,6.2204E-06_JPRB,9.4506E-06_JPRB,1.4131E-05_JPRB,&
&2.1193E-05_JPRB,3.7290E-05_JPRB,1.6892E-03_JPRB/)
KAO( :, 4,12, 2) = (/&
&7.2441E-07_JPRB,2.2261E-06_JPRB,4.0611E-06_JPRB,6.2008E-06_JPRB,9.9865E-06_JPRB,1.4941E-05_JPRB,&
&2.2423E-05_JPRB,3.8766E-05_JPRB,1.8301E-03_JPRB/)
KAO( :, 5,12, 2) = (/&
&9.8233E-07_JPRB,2.8782E-06_JPRB,4.3585E-06_JPRB,6.9707E-06_JPRB,9.7990E-06_JPRB,1.5463E-05_JPRB,&
&2.2949E-05_JPRB,3.9658E-05_JPRB,1.9441E-03_JPRB/)
KAO( :, 1,13, 2) = (/&
&2.9003E-07_JPRB,1.3003E-06_JPRB,2.6851E-06_JPRB,4.4901E-06_JPRB,6.6847E-06_JPRB,1.0336E-05_JPRB,&
&1.6084E-05_JPRB,2.8206E-05_JPRB,1.3971E-03_JPRB/)
KAO( :, 2,13, 2) = (/&
&3.7990E-07_JPRB,1.3887E-06_JPRB,2.9888E-06_JPRB,4.8895E-06_JPRB,7.4887E-06_JPRB,1.0848E-05_JPRB,&
&1.6497E-05_JPRB,3.0927E-05_JPRB,1.5951E-03_JPRB/)
KAO( :, 3,13, 2) = (/&
&5.0572E-07_JPRB,1.6533E-06_JPRB,3.0166E-06_JPRB,5.2825E-06_JPRB,8.0084E-06_JPRB,1.1877E-05_JPRB,&
&1.7766E-05_JPRB,3.0474E-05_JPRB,1.7653E-03_JPRB/)
KAO( :, 4,13, 2) = (/&
&6.7947E-07_JPRB,1.9700E-06_JPRB,3.4410E-06_JPRB,5.2325E-06_JPRB,8.4395E-06_JPRB,1.2460E-05_JPRB,&
&1.8625E-05_JPRB,3.2158E-05_JPRB,1.9067E-03_JPRB/)
KAO( :, 5,13, 2) = (/&
&9.1576E-07_JPRB,2.5777E-06_JPRB,3.7459E-06_JPRB,5.9026E-06_JPRB,8.2962E-06_JPRB,1.2772E-05_JPRB,&
&1.8972E-05_JPRB,3.2948E-05_JPRB,2.0202E-03_JPRB/)
KAO( :, 1, 1, 3) = (/&
&1.2955E-05_JPRB,5.0522E-05_JPRB,7.1945E-05_JPRB,8.6154E-05_JPRB,1.0208E-04_JPRB,1.2598E-04_JPRB,&
&1.9123E-04_JPRB,3.6418E-04_JPRB,1.3186E-04_JPRB/)
KAO( :, 2, 1, 3) = (/&
&1.9287E-05_JPRB,7.0010E-05_JPRB,9.9593E-05_JPRB,1.2286E-04_JPRB,1.3525E-04_JPRB,1.5548E-04_JPRB,&
&2.0918E-04_JPRB,3.4739E-04_JPRB,1.7322E-04_JPRB/)
KAO( :, 3, 1, 3) = (/&
&2.7759E-05_JPRB,9.4510E-05_JPRB,1.3259E-04_JPRB,1.6366E-04_JPRB,1.8879E-04_JPRB,2.0943E-04_JPRB,&
&2.3157E-04_JPRB,3.4811E-04_JPRB,1.6150E-04_JPRB/)
KAO( :, 4, 1, 3) = (/&
&3.8738E-05_JPRB,1.2422E-04_JPRB,1.7221E-04_JPRB,2.0992E-04_JPRB,2.4272E-04_JPRB,2.7453E-04_JPRB,&
&3.1488E-04_JPRB,3.8180E-04_JPRB,1.6247E-04_JPRB/)
KAO( :, 5, 1, 3) = (/&
&5.2551E-05_JPRB,1.5948E-04_JPRB,2.1800E-04_JPRB,2.6091E-04_JPRB,2.8985E-04_JPRB,3.1670E-04_JPRB,&
&3.5730E-04_JPRB,5.0275E-04_JPRB,1.6769E-04_JPRB/)
KAO( :, 1, 2, 3) = (/&
&1.0215E-05_JPRB,3.8380E-05_JPRB,5.3048E-05_JPRB,6.6381E-05_JPRB,7.9446E-05_JPRB,1.0242E-04_JPRB,&
&1.6771E-04_JPRB,3.2794E-04_JPRB,9.6316E-05_JPRB/)
KAO( :, 2, 2, 3) = (/&
&1.5451E-05_JPRB,5.4104E-05_JPRB,7.5600E-05_JPRB,9.3324E-05_JPRB,1.0289E-04_JPRB,1.2339E-04_JPRB,&
&1.5508E-04_JPRB,2.9561E-04_JPRB,1.1950E-04_JPRB/)
KAO( :, 3, 2, 3) = (/&
&2.2597E-05_JPRB,7.3963E-05_JPRB,1.0253E-04_JPRB,1.2549E-04_JPRB,1.4695E-04_JPRB,1.5501E-04_JPRB,&
&1.8766E-04_JPRB,2.7580E-04_JPRB,1.1963E-04_JPRB/)
KAO( :, 4, 2, 3) = (/&
&3.1981E-05_JPRB,9.8266E-05_JPRB,1.3455E-04_JPRB,1.6363E-04_JPRB,1.9057E-04_JPRB,2.1405E-04_JPRB,&
&2.4009E-04_JPRB,3.0871E-04_JPRB,1.1944E-04_JPRB/)
KAO( :, 5, 2, 3) = (/&
&4.3949E-05_JPRB,1.2724E-04_JPRB,1.7210E-04_JPRB,2.0576E-04_JPRB,2.2967E-04_JPRB,2.5641E-04_JPRB,&
&2.9387E-04_JPRB,3.8545E-04_JPRB,1.2834E-04_JPRB/)
KAO( :, 1, 3, 3) = (/&
&7.2365E-06_JPRB,2.6998E-05_JPRB,3.6477E-05_JPRB,4.7217E-05_JPRB,5.6642E-05_JPRB,8.7936E-05_JPRB,&
&1.4529E-04_JPRB,2.7769E-04_JPRB,6.9628E-05_JPRB/)
KAO( :, 2, 3, 3) = (/&
&1.1199E-05_JPRB,3.9041E-05_JPRB,5.3564E-05_JPRB,6.4272E-05_JPRB,7.6774E-05_JPRB,9.0855E-05_JPRB,&
&1.2382E-04_JPRB,2.6260E-04_JPRB,7.7539E-05_JPRB/)
KAO( :, 3, 3, 3) = (/&
&1.6746E-05_JPRB,5.4459E-05_JPRB,7.4537E-05_JPRB,8.9917E-05_JPRB,1.0355E-04_JPRB,1.1572E-04_JPRB,&
&1.4649E-04_JPRB,2.2179E-04_JPRB,7.9988E-05_JPRB/)
KAO( :, 4, 3, 3) = (/&
&2.4191E-05_JPRB,7.3480E-05_JPRB,9.9615E-05_JPRB,1.2140E-04_JPRB,1.3959E-04_JPRB,1.5714E-04_JPRB,&
&1.6549E-04_JPRB,2.4024E-04_JPRB,8.5666E-05_JPRB/)
KAO( :, 5, 3, 3) = (/&
&3.3870E-05_JPRB,9.6615E-05_JPRB,1.2939E-04_JPRB,1.5483E-04_JPRB,1.7605E-04_JPRB,2.0033E-04_JPRB,&
&2.2747E-04_JPRB,2.7100E-04_JPRB,9.7295E-05_JPRB/)
KAO( :, 1, 4, 3) = (/&
&4.9164E-06_JPRB,1.8370E-05_JPRB,2.4721E-05_JPRB,3.3121E-05_JPRB,4.7620E-05_JPRB,7.5266E-05_JPRB,&
&1.2052E-04_JPRB,2.1534E-04_JPRB,5.2534E-05_JPRB/)
KAO( :, 2, 4, 3) = (/&
&7.7659E-06_JPRB,2.7326E-05_JPRB,3.6365E-05_JPRB,4.5331E-05_JPRB,5.4377E-05_JPRB,7.0048E-05_JPRB,&
&1.1606E-04_JPRB,2.2356E-04_JPRB,5.6606E-05_JPRB/)
KAO( :, 3, 4, 3) = (/&
&1.1872E-05_JPRB,3.9091E-05_JPRB,5.2753E-05_JPRB,6.2810E-05_JPRB,7.2334E-05_JPRB,8.5510E-05_JPRB,&
&1.0655E-04_JPRB,2.0132E-04_JPRB,6.1013E-05_JPRB/)
KAO( :, 4, 4, 3) = (/&
&1.7537E-05_JPRB,5.3794E-05_JPRB,7.2225E-05_JPRB,8.6566E-05_JPRB,1.0009E-04_JPRB,1.0905E-04_JPRB,&
&1.2927E-04_JPRB,1.7979E-04_JPRB,6.7247E-05_JPRB/)
KAO( :, 5, 4, 3) = (/&
&2.5077E-05_JPRB,7.1949E-05_JPRB,9.5586E-05_JPRB,1.1422E-04_JPRB,1.3046E-04_JPRB,1.4874E-04_JPRB,&
&1.6151E-04_JPRB,2.1004E-04_JPRB,7.8070E-05_JPRB/)
KAO( :, 1, 5, 3) = (/&
&3.3274E-06_JPRB,1.2413E-05_JPRB,1.6893E-05_JPRB,2.5297E-05_JPRB,3.9702E-05_JPRB,6.2471E-05_JPRB,&
&9.4799E-05_JPRB,1.7379E-04_JPRB,4.3352E-05_JPRB/)
KAO( :, 2, 5, 3) = (/&
&5.3144E-06_JPRB,1.8924E-05_JPRB,2.4595E-05_JPRB,3.1378E-05_JPRB,3.9382E-05_JPRB,6.2226E-05_JPRB,&
&9.6051E-05_JPRB,1.8141E-04_JPRB,4.9071E-05_JPRB/)
KAO( :, 3, 5, 3) = (/&
&8.2729E-06_JPRB,2.7735E-05_JPRB,3.6853E-05_JPRB,4.3473E-05_JPRB,5.3077E-05_JPRB,6.0111E-05_JPRB,&
&8.8205E-05_JPRB,1.7170E-04_JPRB,5.3581E-05_JPRB/)
KAO( :, 4, 5, 3) = (/&
&1.2483E-05_JPRB,3.8936E-05_JPRB,5.1944E-05_JPRB,6.0771E-05_JPRB,7.0416E-05_JPRB,8.1406E-05_JPRB,&
&9.7912E-05_JPRB,1.4624E-04_JPRB,6.0502E-05_JPRB/)
KAO( :, 5, 5, 3) = (/&
&1.8234E-05_JPRB,5.2997E-05_JPRB,7.0214E-05_JPRB,8.3889E-05_JPRB,9.4583E-05_JPRB,1.0646E-04_JPRB,&
&1.1645E-04_JPRB,1.6664E-04_JPRB,6.9524E-05_JPRB/)
KAO( :, 1, 6, 3) = (/&
&2.2627E-06_JPRB,8.2256E-06_JPRB,1.2662E-05_JPRB,2.0881E-05_JPRB,3.2287E-05_JPRB,4.9842E-05_JPRB,&
&7.8514E-05_JPRB,1.5143E-04_JPRB,4.2185E-05_JPRB/)
KAO( :, 2, 6, 3) = (/&
&3.5902E-06_JPRB,1.2715E-05_JPRB,1.6777E-05_JPRB,2.2883E-05_JPRB,3.3890E-05_JPRB,5.0807E-05_JPRB,&
&8.0753E-05_JPRB,1.4463E-04_JPRB,4.8590E-05_JPRB/)
KAO( :, 3, 6, 3) = (/&
&5.6436E-06_JPRB,1.9109E-05_JPRB,2.4998E-05_JPRB,3.0305E-05_JPRB,3.7831E-05_JPRB,4.7255E-05_JPRB,&
&7.8945E-05_JPRB,1.4406E-04_JPRB,5.5296E-05_JPRB/)
KAO( :, 4, 6, 3) = (/&
&8.6680E-06_JPRB,2.7468E-05_JPRB,3.6416E-05_JPRB,4.2070E-05_JPRB,4.9055E-05_JPRB,5.8245E-05_JPRB,&
&7.2889E-05_JPRB,1.3759E-04_JPRB,6.2699E-05_JPRB/)
KAO( :, 5, 6, 3) = (/&
&1.2910E-05_JPRB,3.8070E-05_JPRB,5.0552E-05_JPRB,5.9531E-05_JPRB,6.5990E-05_JPRB,7.5485E-05_JPRB,&
&9.0151E-05_JPRB,1.2519E-04_JPRB,7.1158E-05_JPRB/)
KAO( :, 1, 7, 3) = (/&
&1.6260E-06_JPRB,5.6512E-06_JPRB,1.0534E-05_JPRB,1.6548E-05_JPRB,2.5722E-05_JPRB,3.9212E-05_JPRB,&
&6.5255E-05_JPRB,1.1642E-04_JPRB,4.8396E-05_JPRB/)
KAO( :, 2, 7, 3) = (/&
&2.4977E-06_JPRB,8.5111E-06_JPRB,1.1552E-05_JPRB,1.8620E-05_JPRB,2.6964E-05_JPRB,4.1086E-05_JPRB,&
&6.5326E-05_JPRB,1.2038E-04_JPRB,5.6755E-05_JPRB/)
KAO( :, 3, 7, 3) = (/&
&3.8937E-06_JPRB,1.3083E-05_JPRB,1.6837E-05_JPRB,2.1037E-05_JPRB,2.8103E-05_JPRB,4.1971E-05_JPRB,&
&6.4916E-05_JPRB,1.2035E-04_JPRB,6.5643E-05_JPRB/)
KAO( :, 4, 7, 3) = (/&
&6.0131E-06_JPRB,1.9182E-05_JPRB,2.5262E-05_JPRB,2.9578E-05_JPRB,3.5380E-05_JPRB,4.1824E-05_JPRB,&
&6.4389E-05_JPRB,1.1625E-04_JPRB,7.5112E-05_JPRB/)
KAO( :, 5, 7, 3) = (/&
&9.0775E-06_JPRB,2.7049E-05_JPRB,3.5910E-05_JPRB,4.1673E-05_JPRB,4.7430E-05_JPRB,5.6675E-05_JPRB,&
&6.4662E-05_JPRB,1.0376E-04_JPRB,8.5479E-05_JPRB/)
KAO( :, 1, 8, 3) = (/&
&1.2762E-06_JPRB,4.2855E-06_JPRB,8.2820E-06_JPRB,1.3051E-05_JPRB,1.9907E-05_JPRB,3.3971E-05_JPRB,&
&5.0446E-05_JPRB,8.6971E-05_JPRB,7.7745E-05_JPRB/)
KAO( :, 2, 8, 3) = (/&
&1.8844E-06_JPRB,5.9050E-06_JPRB,8.9489E-06_JPRB,1.4806E-05_JPRB,2.1839E-05_JPRB,3.2608E-05_JPRB,&
&5.2540E-05_JPRB,9.7610E-05_JPRB,8.9498E-05_JPRB/)
KAO( :, 3, 8, 3) = (/&
&2.8385E-06_JPRB,8.9737E-06_JPRB,1.1895E-05_JPRB,1.5870E-05_JPRB,2.4156E-05_JPRB,3.3906E-05_JPRB,&
&5.3605E-05_JPRB,9.6849E-05_JPRB,1.0287E-04_JPRB/)
KAO( :, 4, 8, 3) = (/&
&4.3106E-06_JPRB,1.3404E-05_JPRB,1.7498E-05_JPRB,2.1009E-05_JPRB,2.6036E-05_JPRB,3.4758E-05_JPRB,&
&5.4115E-05_JPRB,9.7671E-05_JPRB,1.1774E-04_JPRB/)
KAO( :, 5, 8, 3) = (/&
&6.4933E-06_JPRB,1.9198E-05_JPRB,2.5108E-05_JPRB,2.9532E-05_JPRB,3.3547E-05_JPRB,4.0870E-05_JPRB,&
&5.0672E-05_JPRB,9.4048E-05_JPRB,1.3326E-04_JPRB/)
KAO( :, 1, 9, 3) = (/&
&1.0706E-06_JPRB,3.3489E-06_JPRB,6.5283E-06_JPRB,1.0192E-05_JPRB,1.7278E-05_JPRB,2.6238E-05_JPRB,&
&3.9041E-05_JPRB,7.0346E-05_JPRB,2.7103E-04_JPRB/)
KAO( :, 2, 9, 3) = (/&
&1.5238E-06_JPRB,4.4647E-06_JPRB,7.4896E-06_JPRB,1.1805E-05_JPRB,1.7404E-05_JPRB,2.6241E-05_JPRB,&
&4.5076E-05_JPRB,7.3357E-05_JPRB,3.0478E-04_JPRB/)
KAO( :, 3, 9, 3) = (/&
&2.2245E-06_JPRB,6.3482E-06_JPRB,8.7814E-06_JPRB,1.3182E-05_JPRB,1.8649E-05_JPRB,2.8139E-05_JPRB,&
&4.2432E-05_JPRB,8.1918E-05_JPRB,3.3943E-04_JPRB/)
KAO( :, 4, 9, 3) = (/&
&3.2853E-06_JPRB,9.5377E-06_JPRB,1.2081E-05_JPRB,1.5048E-05_JPRB,2.0438E-05_JPRB,2.9250E-05_JPRB,&
&4.4492E-05_JPRB,8.0054E-05_JPRB,3.7569E-04_JPRB/)
KAO( :, 5, 9, 3) = (/&
&4.8340E-06_JPRB,1.3704E-05_JPRB,1.7727E-05_JPRB,2.0846E-05_JPRB,2.4389E-05_JPRB,3.0169E-05_JPRB,&
&4.5558E-05_JPRB,7.6780E-05_JPRB,4.1363E-04_JPRB/)
KAO( :, 1,10, 3) = (/&
&1.0087E-06_JPRB,2.8522E-06_JPRB,5.3847E-06_JPRB,8.7589E-06_JPRB,1.3656E-05_JPRB,2.0793E-05_JPRB,&
&3.0265E-05_JPRB,5.6466E-05_JPRB,1.4467E-03_JPRB/)
KAO( :, 2,10, 3) = (/&
&1.3893E-06_JPRB,3.6572E-06_JPRB,6.0381E-06_JPRB,9.5656E-06_JPRB,1.3744E-05_JPRB,2.2378E-05_JPRB,&
&3.6073E-05_JPRB,5.8999E-05_JPRB,1.6134E-03_JPRB/)
KAO( :, 3,10, 3) = (/&
&1.9601E-06_JPRB,4.9746E-06_JPRB,7.1675E-06_JPRB,1.0782E-05_JPRB,1.5548E-05_JPRB,2.2425E-05_JPRB,&
&3.4813E-05_JPRB,6.8188E-05_JPRB,1.7742E-03_JPRB/)
KAO( :, 4,10, 3) = (/&
&2.8046E-06_JPRB,7.3061E-06_JPRB,9.2760E-06_JPRB,1.2016E-05_JPRB,1.7674E-05_JPRB,2.3526E-05_JPRB,&
&3.6626E-05_JPRB,6.3451E-05_JPRB,1.9257E-03_JPRB/)
KAO( :, 5,10, 3) = (/&
&4.0204E-06_JPRB,1.0448E-05_JPRB,1.3168E-05_JPRB,1.5711E-05_JPRB,1.8780E-05_JPRB,2.5290E-05_JPRB,&
&3.7179E-05_JPRB,6.5468E-05_JPRB,2.0654E-03_JPRB/)
KAO( :, 1,11, 3) = (/&
&1.1167E-06_JPRB,2.7196E-06_JPRB,4.8414E-06_JPRB,7.5750E-06_JPRB,1.1619E-05_JPRB,1.6844E-05_JPRB,&
&2.5920E-05_JPRB,4.2497E-05_JPRB,3.0648E-03_JPRB/)
KAO( :, 2,11, 3) = (/&
&1.5177E-06_JPRB,3.5342E-06_JPRB,5.4336E-06_JPRB,8.4346E-06_JPRB,1.1729E-05_JPRB,1.8362E-05_JPRB,&
&2.9194E-05_JPRB,5.0129E-05_JPRB,3.3976E-03_JPRB/)
KAO( :, 3,11, 3) = (/&
&2.0984E-06_JPRB,4.8006E-06_JPRB,6.5451E-06_JPRB,9.5029E-06_JPRB,1.3465E-05_JPRB,1.9020E-05_JPRB,&
&2.8692E-05_JPRB,5.7928E-05_JPRB,3.7050E-03_JPRB/)
KAO( :, 4,11, 3) = (/&
&2.9335E-06_JPRB,6.8708E-06_JPRB,8.4101E-06_JPRB,1.0863E-05_JPRB,1.4762E-05_JPRB,2.0091E-05_JPRB,&
&3.0371E-05_JPRB,5.2028E-05_JPRB,3.9809E-03_JPRB/)
KAO( :, 5,11, 3) = (/&
&4.1000E-06_JPRB,9.6543E-06_JPRB,1.1857E-05_JPRB,1.3714E-05_JPRB,1.6526E-05_JPRB,2.1427E-05_JPRB,&
&3.1464E-05_JPRB,5.4245E-05_JPRB,4.2143E-03_JPRB/)
KAO( :, 1,12, 3) = (/&
&1.1265E-06_JPRB,2.5186E-06_JPRB,4.3674E-06_JPRB,6.5192E-06_JPRB,9.8193E-06_JPRB,1.4195E-05_JPRB,&
&2.1669E-05_JPRB,3.5591E-05_JPRB,4.1354E-03_JPRB/)
KAO( :, 2,12, 3) = (/&
&1.5273E-06_JPRB,3.2471E-06_JPRB,4.8453E-06_JPRB,7.4929E-06_JPRB,9.9333E-06_JPRB,1.5224E-05_JPRB,&
&2.4490E-05_JPRB,4.2520E-05_JPRB,4.5631E-03_JPRB/)
KAO( :, 3,12, 3) = (/&
&2.0931E-06_JPRB,4.4632E-06_JPRB,5.8990E-06_JPRB,8.1723E-06_JPRB,1.1637E-05_JPRB,1.5989E-05_JPRB,&
&2.3803E-05_JPRB,4.4958E-05_JPRB,4.9406E-03_JPRB/)
KAO( :, 4,12, 3) = (/&
&2.8927E-06_JPRB,6.3250E-06_JPRB,7.6186E-06_JPRB,9.4669E-06_JPRB,1.2563E-05_JPRB,1.7445E-05_JPRB,&
&2.5222E-05_JPRB,4.2668E-05_JPRB,5.2603E-03_JPRB/)
KAO( :, 5,12, 3) = (/&
&3.9848E-06_JPRB,8.7921E-06_JPRB,1.0605E-05_JPRB,1.2004E-05_JPRB,1.4341E-05_JPRB,1.8049E-05_JPRB,&
&2.6521E-05_JPRB,4.4754E-05_JPRB,5.5165E-03_JPRB/)
KAO( :, 1,13, 3) = (/&
&1.1328E-06_JPRB,2.3238E-06_JPRB,3.9430E-06_JPRB,5.6932E-06_JPRB,8.4038E-06_JPRB,1.1800E-05_JPRB,&
&1.7829E-05_JPRB,3.0820E-05_JPRB,4.4819E-03_JPRB/)
KAO( :, 2,13, 3) = (/&
&1.5311E-06_JPRB,3.0098E-06_JPRB,4.3521E-06_JPRB,6.6679E-06_JPRB,8.7081E-06_JPRB,1.2897E-05_JPRB,&
&1.9883E-05_JPRB,3.4493E-05_JPRB,4.9164E-03_JPRB/)
KAO( :, 3,13, 3) = (/&
&2.0853E-06_JPRB,4.1223E-06_JPRB,5.4114E-06_JPRB,7.2554E-06_JPRB,1.0229E-05_JPRB,1.3641E-05_JPRB,&
&1.9729E-05_JPRB,3.6438E-05_JPRB,5.2852E-03_JPRB/)
KAO( :, 4,13, 3) = (/&
&2.8506E-06_JPRB,5.8568E-06_JPRB,6.9938E-06_JPRB,8.4840E-06_JPRB,1.0942E-05_JPRB,1.5066E-05_JPRB,&
&2.1270E-05_JPRB,3.5313E-05_JPRB,5.5871E-03_JPRB/)
KAO( :, 5,13, 3) = (/&
&3.8711E-06_JPRB,8.0712E-06_JPRB,9.6159E-06_JPRB,1.0719E-05_JPRB,1.2561E-05_JPRB,1.5293E-05_JPRB,&
&2.2681E-05_JPRB,3.7058E-05_JPRB,5.8266E-03_JPRB/)
KAO( :, 1, 1, 4) = (/&
&7.4893E-05_JPRB,1.7660E-04_JPRB,2.0743E-04_JPRB,2.2345E-04_JPRB,2.5541E-04_JPRB,3.0113E-04_JPRB,&
&4.0065E-04_JPRB,5.1140E-04_JPRB,1.9420E-04_JPRB/)
KAO( :, 2, 1, 4) = (/&
&1.0396E-04_JPRB,2.3012E-04_JPRB,2.6622E-04_JPRB,2.8243E-04_JPRB,2.9424E-04_JPRB,3.3000E-04_JPRB,&
&4.1387E-04_JPRB,6.5618E-04_JPRB,1.7248E-04_JPRB/)
KAO( :, 3, 1, 4) = (/&
&1.3874E-04_JPRB,2.9171E-04_JPRB,3.3413E-04_JPRB,3.5198E-04_JPRB,3.5734E-04_JPRB,3.6401E-04_JPRB,&
&4.2489E-04_JPRB,6.4403E-04_JPRB,1.9641E-04_JPRB/)
KAO( :, 4, 1, 4) = (/&
&1.7941E-04_JPRB,3.6434E-04_JPRB,4.1317E-04_JPRB,4.3271E-04_JPRB,4.3728E-04_JPRB,4.3279E-04_JPRB,&
&4.4184E-04_JPRB,6.1293E-04_JPRB,2.4660E-04_JPRB/)
KAO( :, 5, 1, 4) = (/&
&2.2524E-04_JPRB,4.4700E-04_JPRB,5.0389E-04_JPRB,5.2899E-04_JPRB,5.4228E-04_JPRB,5.4473E-04_JPRB,&
&5.3368E-04_JPRB,5.6423E-04_JPRB,3.1492E-04_JPRB/)
KAO( :, 1, 2, 4) = (/&
&5.8910E-05_JPRB,1.3730E-04_JPRB,1.6111E-04_JPRB,1.7338E-04_JPRB,1.9974E-04_JPRB,2.3614E-04_JPRB,&
&3.1448E-04_JPRB,3.8866E-04_JPRB,1.4405E-04_JPRB/)
KAO( :, 2, 2, 4) = (/&
&8.3036E-05_JPRB,1.8135E-04_JPRB,2.0964E-04_JPRB,2.2070E-04_JPRB,2.3158E-04_JPRB,2.7057E-04_JPRB,&
&3.3372E-04_JPRB,5.4726E-04_JPRB,1.2817E-04_JPRB/)
KAO( :, 3, 2, 4) = (/&
&1.1213E-04_JPRB,2.3284E-04_JPRB,2.6662E-04_JPRB,2.8050E-04_JPRB,2.8374E-04_JPRB,2.9072E-04_JPRB,&
&3.5956E-04_JPRB,5.3062E-04_JPRB,1.4567E-04_JPRB/)
KAO( :, 4, 2, 4) = (/&
&1.4639E-04_JPRB,2.9331E-04_JPRB,3.3229E-04_JPRB,3.4773E-04_JPRB,3.4771E-04_JPRB,3.4598E-04_JPRB,&
&3.5609E-04_JPRB,5.3796E-04_JPRB,1.8917E-04_JPRB/)
KAO( :, 5, 2, 4) = (/&
&1.8573E-04_JPRB,3.6333E-04_JPRB,4.0899E-04_JPRB,4.2805E-04_JPRB,4.3596E-04_JPRB,4.3023E-04_JPRB,&
&4.2036E-04_JPRB,4.7310E-04_JPRB,2.4106E-04_JPRB/)
KAO( :, 1, 3, 4) = (/&
&4.2697E-05_JPRB,9.9737E-05_JPRB,1.1762E-04_JPRB,1.3175E-04_JPRB,1.5206E-04_JPRB,1.7738E-04_JPRB,&
&2.2461E-04_JPRB,3.0012E-04_JPRB,9.0760E-05_JPRB/)
KAO( :, 2, 3, 4) = (/&
&6.1628E-05_JPRB,1.3453E-04_JPRB,1.5553E-04_JPRB,1.6395E-04_JPRB,1.7863E-04_JPRB,2.1026E-04_JPRB,&
&2.6559E-04_JPRB,4.0665E-04_JPRB,9.5213E-05_JPRB/)
KAO( :, 3, 3, 4) = (/&
&8.5155E-05_JPRB,1.7580E-04_JPRB,2.0156E-04_JPRB,2.1203E-04_JPRB,2.1267E-04_JPRB,2.2935E-04_JPRB,&
&2.8279E-04_JPRB,4.3028E-04_JPRB,1.1265E-04_JPRB/)
KAO( :, 4, 3, 4) = (/&
&1.1317E-04_JPRB,2.2386E-04_JPRB,2.5438E-04_JPRB,2.6544E-04_JPRB,2.6602E-04_JPRB,2.6653E-04_JPRB,&
&2.9745E-04_JPRB,4.2745E-04_JPRB,1.4173E-04_JPRB/)
KAO( :, 5, 3, 4) = (/&
&1.4597E-04_JPRB,2.8045E-04_JPRB,3.1649E-04_JPRB,3.3077E-04_JPRB,3.3240E-04_JPRB,3.2175E-04_JPRB,&
&3.2192E-04_JPRB,4.1153E-04_JPRB,1.7765E-04_JPRB/)
KAO( :, 1, 4, 4) = (/&
&2.9896E-05_JPRB,7.0709E-05_JPRB,8.4360E-05_JPRB,9.7466E-05_JPRB,1.0874E-04_JPRB,1.3074E-04_JPRB,&
&1.6227E-04_JPRB,2.5464E-04_JPRB,6.8134E-05_JPRB/)
KAO( :, 2, 4, 4) = (/&
&4.4341E-05_JPRB,9.6962E-05_JPRB,1.1247E-04_JPRB,1.1929E-04_JPRB,1.3785E-04_JPRB,1.5834E-04_JPRB,&
&2.0071E-04_JPRB,2.9189E-04_JPRB,7.8206E-05_JPRB/)
KAO( :, 3, 4, 4) = (/&
&6.2914E-05_JPRB,1.2902E-04_JPRB,1.4817E-04_JPRB,1.5527E-04_JPRB,1.5849E-04_JPRB,1.8569E-04_JPRB,&
&2.2497E-04_JPRB,3.4124E-04_JPRB,9.0845E-05_JPRB/)
KAO( :, 4, 4, 4) = (/&
&8.5677E-05_JPRB,1.6689E-04_JPRB,1.9068E-04_JPRB,1.9916E-04_JPRB,1.9978E-04_JPRB,2.0155E-04_JPRB,&
&2.4936E-04_JPRB,3.5340E-04_JPRB,1.0988E-04_JPRB/)
KAO( :, 5, 4, 4) = (/&
&1.1242E-04_JPRB,2.1149E-04_JPRB,2.3915E-04_JPRB,2.5028E-04_JPRB,2.4989E-04_JPRB,2.4272E-04_JPRB,&
&2.4831E-04_JPRB,3.6709E-04_JPRB,1.3381E-04_JPRB/)
KAO( :, 1, 5, 4) = (/&
&2.0688E-05_JPRB,4.9203E-05_JPRB,5.9785E-05_JPRB,6.6990E-05_JPRB,7.8124E-05_JPRB,9.2624E-05_JPRB,&
&1.2472E-04_JPRB,2.0745E-04_JPRB,6.1812E-05_JPRB/)
KAO( :, 2, 5, 4) = (/&
&3.1637E-05_JPRB,6.9271E-05_JPRB,8.0604E-05_JPRB,9.0077E-05_JPRB,1.0181E-04_JPRB,1.1707E-04_JPRB,&
&1.4853E-04_JPRB,2.1722E-04_JPRB,7.1005E-05_JPRB/)
KAO( :, 3, 5, 4) = (/&
&4.6076E-05_JPRB,9.3625E-05_JPRB,1.0769E-04_JPRB,1.1334E-04_JPRB,1.2174E-04_JPRB,1.4414E-04_JPRB,&
&1.7668E-04_JPRB,2.5800E-04_JPRB,8.3094E-05_JPRB/)
KAO( :, 4, 5, 4) = (/&
&6.4341E-05_JPRB,1.2346E-04_JPRB,1.4103E-04_JPRB,1.4850E-04_JPRB,1.4693E-04_JPRB,1.5815E-04_JPRB,&
&1.9286E-04_JPRB,2.8817E-04_JPRB,9.6701E-05_JPRB/)
KAO( :, 5, 5, 4) = (/&
&8.6238E-05_JPRB,1.5868E-04_JPRB,1.7942E-04_JPRB,1.8707E-04_JPRB,1.8806E-04_JPRB,1.8319E-04_JPRB,&
&2.0554E-04_JPRB,2.8611E-04_JPRB,1.1287E-04_JPRB/)
KAO( :, 1, 6, 4) = (/&
&1.4006E-05_JPRB,3.3343E-05_JPRB,4.0079E-05_JPRB,4.5588E-05_JPRB,5.4107E-05_JPRB,6.6418E-05_JPRB,&
&1.0066E-04_JPRB,1.4196E-04_JPRB,6.6243E-05_JPRB/)
KAO( :, 2, 6, 4) = (/&
&2.2071E-05_JPRB,4.8614E-05_JPRB,5.7228E-05_JPRB,6.5093E-05_JPRB,7.1721E-05_JPRB,8.5635E-05_JPRB,&
&1.0856E-04_JPRB,1.8021E-04_JPRB,7.5554E-05_JPRB/)
KAO( :, 3, 6, 4) = (/&
&3.3040E-05_JPRB,6.6682E-05_JPRB,7.6698E-05_JPRB,8.2380E-05_JPRB,9.3552E-05_JPRB,1.0700E-04_JPRB,&
&1.3596E-04_JPRB,1.9405E-04_JPRB,8.6063E-05_JPRB/)
KAO( :, 4, 6, 4) = (/&
&4.7386E-05_JPRB,8.9793E-05_JPRB,1.0237E-04_JPRB,1.0759E-04_JPRB,1.0965E-04_JPRB,1.2726E-04_JPRB,&
&1.5398E-04_JPRB,2.2704E-04_JPRB,9.8696E-05_JPRB/)
KAO( :, 5, 6, 4) = (/&
&6.5121E-05_JPRB,1.1757E-04_JPRB,1.3268E-04_JPRB,1.3869E-04_JPRB,1.4006E-04_JPRB,1.3836E-04_JPRB,&
&1.7051E-04_JPRB,2.3669E-04_JPRB,1.1305E-04_JPRB/)
KAO( :, 1, 7, 4) = (/&
&9.5061E-06_JPRB,2.2311E-05_JPRB,2.6088E-05_JPRB,3.0162E-05_JPRB,3.7877E-05_JPRB,5.4505E-05_JPRB,&
&7.5227E-05_JPRB,1.1255E-04_JPRB,8.3483E-05_JPRB/)
KAO( :, 2, 7, 4) = (/&
&1.5323E-05_JPRB,3.3598E-05_JPRB,4.0386E-05_JPRB,4.3881E-05_JPRB,5.0583E-05_JPRB,6.2493E-05_JPRB,&
&8.2842E-05_JPRB,1.4322E-04_JPRB,9.4311E-05_JPRB/)
KAO( :, 3, 7, 4) = (/&
&2.3596E-05_JPRB,4.7494E-05_JPRB,5.4556E-05_JPRB,6.1372E-05_JPRB,6.7015E-05_JPRB,7.9350E-05_JPRB,&
&9.7496E-05_JPRB,1.4436E-04_JPRB,1.0703E-04_JPRB/)
KAO( :, 4, 7, 4) = (/&
&3.4570E-05_JPRB,6.4860E-05_JPRB,7.3694E-05_JPRB,7.7754E-05_JPRB,8.4695E-05_JPRB,9.7029E-05_JPRB,&
&1.1678E-04_JPRB,1.6858E-04_JPRB,1.2127E-04_JPRB/)
KAO( :, 5, 7, 4) = (/&
&4.8551E-05_JPRB,8.6609E-05_JPRB,9.7619E-05_JPRB,1.0164E-04_JPRB,1.0226E-04_JPRB,1.0885E-04_JPRB,&
&1.3405E-04_JPRB,1.9133E-04_JPRB,1.3656E-04_JPRB/)
KAO( :, 1, 8, 4) = (/&
&6.7311E-06_JPRB,1.4755E-05_JPRB,1.6935E-05_JPRB,2.1463E-05_JPRB,3.1231E-05_JPRB,4.0742E-05_JPRB,&
&5.6656E-05_JPRB,8.5927E-05_JPRB,1.5049E-04_JPRB/)
KAO( :, 2, 8, 4) = (/&
&1.0838E-05_JPRB,2.3183E-05_JPRB,2.7453E-05_JPRB,3.0553E-05_JPRB,3.5694E-05_JPRB,4.6374E-05_JPRB,&
&6.9419E-05_JPRB,1.0643E-04_JPRB,1.6866E-04_JPRB/)
KAO( :, 3, 8, 4) = (/&
&1.6914E-05_JPRB,3.3766E-05_JPRB,3.8989E-05_JPRB,4.4447E-05_JPRB,4.8070E-05_JPRB,5.7198E-05_JPRB,&
&7.1116E-05_JPRB,1.2478E-04_JPRB,1.8779E-04_JPRB/)
KAO( :, 4, 8, 4) = (/&
&2.5195E-05_JPRB,4.6972E-05_JPRB,5.3026E-05_JPRB,5.6927E-05_JPRB,6.4565E-05_JPRB,7.1923E-05_JPRB,&
&9.0751E-05_JPRB,1.2249E-04_JPRB,2.0805E-04_JPRB/)
KAO( :, 5, 8, 4) = (/&
&3.5942E-05_JPRB,6.3786E-05_JPRB,7.1729E-05_JPRB,7.3949E-05_JPRB,7.6446E-05_JPRB,8.8163E-05_JPRB,&
&1.0367E-04_JPRB,1.5461E-04_JPRB,2.3067E-04_JPRB/)
KAO( :, 1, 9, 4) = (/&
&5.1599E-06_JPRB,1.0081E-05_JPRB,1.1772E-05_JPRB,1.6698E-05_JPRB,2.2821E-05_JPRB,2.9936E-05_JPRB,&
&4.2105E-05_JPRB,6.2990E-05_JPRB,5.8733E-04_JPRB/)
KAO( :, 2, 9, 4) = (/&
&8.0231E-06_JPRB,1.6031E-05_JPRB,1.8581E-05_JPRB,2.0889E-05_JPRB,2.6202E-05_JPRB,3.8502E-05_JPRB,&
&5.1188E-05_JPRB,8.2231E-05_JPRB,6.4455E-04_JPRB/)
KAO( :, 3, 9, 4) = (/&
&1.2365E-05_JPRB,2.3962E-05_JPRB,2.7785E-05_JPRB,3.0574E-05_JPRB,3.4959E-05_JPRB,4.1433E-05_JPRB,&
&5.7939E-05_JPRB,9.7311E-05_JPRB,7.0196E-04_JPRB/)
KAO( :, 4, 9, 4) = (/&
&1.8494E-05_JPRB,3.4148E-05_JPRB,3.8522E-05_JPRB,4.2610E-05_JPRB,4.6125E-05_JPRB,5.4566E-05_JPRB,&
&6.5066E-05_JPRB,9.3543E-05_JPRB,7.5838E-04_JPRB/)
KAO( :, 5, 9, 4) = (/&
&2.6560E-05_JPRB,4.6839E-05_JPRB,5.2429E-05_JPRB,5.4183E-05_JPRB,5.9609E-05_JPRB,6.7149E-05_JPRB,&
&7.9436E-05_JPRB,1.1417E-04_JPRB,8.1247E-04_JPRB/)
KAO( :, 1,10, 4) = (/&
&4.5845E-06_JPRB,7.8051E-06_JPRB,9.3693E-06_JPRB,1.2991E-05_JPRB,1.7572E-05_JPRB,2.3437E-05_JPRB,&
&3.3813E-05_JPRB,4.9188E-05_JPRB,3.3674E-03_JPRB/)
KAO( :, 2,10, 4) = (/&
&6.8084E-06_JPRB,1.2034E-05_JPRB,1.3688E-05_JPRB,1.5733E-05_JPRB,2.1211E-05_JPRB,2.9098E-05_JPRB,&
&3.8545E-05_JPRB,6.3500E-05_JPRB,3.6391E-03_JPRB/)
KAO( :, 3,10, 4) = (/&
&1.0062E-05_JPRB,1.7982E-05_JPRB,2.0409E-05_JPRB,2.2663E-05_JPRB,2.5613E-05_JPRB,3.1784E-05_JPRB,&
&4.7385E-05_JPRB,7.3006E-05_JPRB,3.8993E-03_JPRB/)
KAO( :, 4,10, 4) = (/&
&1.4658E-05_JPRB,2.5727E-05_JPRB,2.8782E-05_JPRB,3.2310E-05_JPRB,3.4485E-05_JPRB,4.0752E-05_JPRB,&
&4.8720E-05_JPRB,8.2499E-05_JPRB,4.1490E-03_JPRB/)
KAO( :, 5,10, 4) = (/&
&2.0786E-05_JPRB,3.5657E-05_JPRB,3.9659E-05_JPRB,4.1123E-05_JPRB,4.6983E-05_JPRB,5.0556E-05_JPRB,&
&6.3521E-05_JPRB,8.4499E-05_JPRB,4.3775E-03_JPRB/)
KAO( :, 1,11, 4) = (/&
&5.0356E-06_JPRB,7.7353E-06_JPRB,8.8833E-06_JPRB,1.1452E-05_JPRB,1.5243E-05_JPRB,2.1044E-05_JPRB,&
&2.8338E-05_JPRB,4.9949E-05_JPRB,7.2577E-03_JPRB/)
KAO( :, 2,11, 4) = (/&
&7.2423E-06_JPRB,1.1514E-05_JPRB,1.2798E-05_JPRB,1.4086E-05_JPRB,1.8007E-05_JPRB,2.4558E-05_JPRB,&
&3.3851E-05_JPRB,5.2802E-05_JPRB,7.8158E-03_JPRB/)
KAO( :, 3,11, 4) = (/&
&1.0309E-05_JPRB,1.6653E-05_JPRB,1.8407E-05_JPRB,2.0089E-05_JPRB,2.2296E-05_JPRB,2.7018E-05_JPRB,&
&3.8586E-05_JPRB,6.0068E-05_JPRB,8.3354E-03_JPRB/)
KAO( :, 4,11, 4) = (/&
&1.4421E-05_JPRB,2.3379E-05_JPRB,2.5740E-05_JPRB,2.7750E-05_JPRB,3.0309E-05_JPRB,3.4851E-05_JPRB,&
&4.1245E-05_JPRB,6.8211E-05_JPRB,8.8296E-03_JPRB/)
KAO( :, 5,11, 4) = (/&
&1.9663E-05_JPRB,3.1842E-05_JPRB,3.4991E-05_JPRB,3.6140E-05_JPRB,3.9688E-05_JPRB,4.2983E-05_JPRB,&
&5.3776E-05_JPRB,6.9907E-05_JPRB,9.2688E-03_JPRB/)
KAO( :, 1,12, 4) = (/&
&5.1165E-06_JPRB,7.4029E-06_JPRB,8.1941E-06_JPRB,1.0138E-05_JPRB,1.3490E-05_JPRB,1.7256E-05_JPRB,&
&2.4419E-05_JPRB,4.0146E-05_JPRB,9.9448E-03_JPRB/)
KAO( :, 2,12, 4) = (/&
&7.2283E-06_JPRB,1.0802E-05_JPRB,1.1887E-05_JPRB,1.2642E-05_JPRB,1.5734E-05_JPRB,2.0542E-05_JPRB,&
&2.7886E-05_JPRB,4.3910E-05_JPRB,1.0705E-02_JPRB/)
KAO( :, 3,12, 4) = (/&
&1.0065E-05_JPRB,1.5284E-05_JPRB,1.6642E-05_JPRB,1.8157E-05_JPRB,1.9448E-05_JPRB,2.3207E-05_JPRB,&
&3.2168E-05_JPRB,5.3905E-05_JPRB,1.1409E-02_JPRB/)
KAO( :, 4,12, 4) = (/&
&1.3731E-05_JPRB,2.1142E-05_JPRB,2.2780E-05_JPRB,2.4378E-05_JPRB,2.6665E-05_JPRB,2.9738E-05_JPRB,&
&3.5163E-05_JPRB,5.5828E-05_JPRB,1.2051E-02_JPRB/)
KAO( :, 5,12, 4) = (/&
&1.8328E-05_JPRB,2.8382E-05_JPRB,3.0850E-05_JPRB,3.1430E-05_JPRB,3.3929E-05_JPRB,3.7016E-05_JPRB,&
&4.5266E-05_JPRB,5.8847E-05_JPRB,1.2603E-02_JPRB/)
KAO( :, 1,13, 4) = (/&
&5.1628E-06_JPRB,7.0476E-06_JPRB,7.6783E-06_JPRB,9.1901E-06_JPRB,1.1659E-05_JPRB,1.4990E-05_JPRB,&
&2.0746E-05_JPRB,3.1591E-05_JPRB,1.0979E-02_JPRB/)
KAO( :, 2,13, 4) = (/&
&7.1656E-06_JPRB,1.0090E-05_JPRB,1.0951E-05_JPRB,1.1562E-05_JPRB,1.3750E-05_JPRB,1.7398E-05_JPRB,&
&2.3701E-05_JPRB,3.7488E-05_JPRB,1.1813E-02_JPRB/)
KAO( :, 3,13, 4) = (/&
&9.7810E-06_JPRB,1.4159E-05_JPRB,1.5003E-05_JPRB,1.6207E-05_JPRB,1.7175E-05_JPRB,1.9965E-05_JPRB,&
&2.7079E-05_JPRB,4.3382E-05_JPRB,1.2578E-02_JPRB/)
KAO( :, 4,13, 4) = (/&
&1.3104E-05_JPRB,1.9253E-05_JPRB,2.0395E-05_JPRB,2.1436E-05_JPRB,2.3261E-05_JPRB,2.5640E-05_JPRB,&
&2.9895E-05_JPRB,4.6045E-05_JPRB,1.3231E-02_JPRB/)
KAO( :, 5,13, 4) = (/&
&1.7208E-05_JPRB,2.5546E-05_JPRB,2.7424E-05_JPRB,2.7535E-05_JPRB,2.9380E-05_JPRB,3.2546E-05_JPRB,&
&3.8040E-05_JPRB,4.9840E-05_JPRB,1.3742E-02_JPRB/)
KAO( :, 1, 1, 5) = (/&
&3.1090E-04_JPRB,4.1312E-04_JPRB,4.5176E-04_JPRB,4.6856E-04_JPRB,4.5586E-04_JPRB,4.3213E-04_JPRB,&
&4.5397E-04_JPRB,7.8015E-04_JPRB,2.0103E-04_JPRB/)
KAO( :, 2, 1, 5) = (/&
&3.8398E-04_JPRB,5.2122E-04_JPRB,5.7336E-04_JPRB,6.0217E-04_JPRB,6.0591E-04_JPRB,5.7511E-04_JPRB,&
&5.3422E-04_JPRB,6.1896E-04_JPRB,2.8351E-04_JPRB/)
KAO( :, 3, 1, 5) = (/&
&4.6534E-04_JPRB,6.4382E-04_JPRB,7.1301E-04_JPRB,7.5438E-04_JPRB,7.7134E-04_JPRB,7.6006E-04_JPRB,&
&7.0811E-04_JPRB,7.4234E-04_JPRB,3.7763E-04_JPRB/)
KAO( :, 4, 1, 5) = (/&
&5.5987E-04_JPRB,7.8442E-04_JPRB,8.7478E-04_JPRB,9.3078E-04_JPRB,9.6145E-04_JPRB,9.6632E-04_JPRB,&
&9.4057E-04_JPRB,8.7094E-04_JPRB,4.7321E-04_JPRB/)
KAO( :, 5, 1, 5) = (/&
&6.6579E-04_JPRB,9.4348E-04_JPRB,1.0594E-03_JPRB,1.1323E-03_JPRB,1.1769E-03_JPRB,1.1973E-03_JPRB,&
&1.1941E-03_JPRB,1.1720E-03_JPRB,5.8670E-04_JPRB/)
KAO( :, 1, 2, 5) = (/&
&2.4736E-04_JPRB,3.2724E-04_JPRB,3.5306E-04_JPRB,3.6178E-04_JPRB,3.4912E-04_JPRB,3.3979E-04_JPRB,&
&3.6882E-04_JPRB,6.4661E-04_JPRB,1.4637E-04_JPRB/)
KAO( :, 2, 2, 5) = (/&
&3.1002E-04_JPRB,4.1717E-04_JPRB,4.5359E-04_JPRB,4.7283E-04_JPRB,4.7168E-04_JPRB,4.4103E-04_JPRB,&
&4.4124E-04_JPRB,5.1519E-04_JPRB,2.1389E-04_JPRB/)
KAO( :, 3, 2, 5) = (/&
&3.8079E-04_JPRB,5.2107E-04_JPRB,5.7062E-04_JPRB,5.9973E-04_JPRB,6.0662E-04_JPRB,5.9325E-04_JPRB,&
&5.3745E-04_JPRB,5.8652E-04_JPRB,2.8633E-04_JPRB/)
KAO( :, 4, 2, 5) = (/&
&4.6210E-04_JPRB,6.4094E-04_JPRB,7.0763E-04_JPRB,7.4776E-04_JPRB,7.6652E-04_JPRB,7.5984E-04_JPRB,&
&7.3202E-04_JPRB,6.4140E-04_JPRB,3.5290E-04_JPRB/)
KAO( :, 5, 2, 5) = (/&
&5.5546E-04_JPRB,7.7925E-04_JPRB,8.6616E-04_JPRB,9.1863E-04_JPRB,9.4674E-04_JPRB,9.5490E-04_JPRB,&
&9.4094E-04_JPRB,9.1867E-04_JPRB,4.4201E-04_JPRB/)
KAO( :, 1, 3, 5) = (/&
&1.8639E-04_JPRB,2.4387E-04_JPRB,2.5915E-04_JPRB,2.5906E-04_JPRB,2.4918E-04_JPRB,2.5967E-04_JPRB,&
&3.1653E-04_JPRB,4.7580E-04_JPRB,1.1679E-04_JPRB/)
KAO( :, 2, 3, 5) = (/&
&2.3798E-04_JPRB,3.1564E-04_JPRB,3.3906E-04_JPRB,3.5000E-04_JPRB,3.4157E-04_JPRB,3.1943E-04_JPRB,&
&3.2743E-04_JPRB,4.5496E-04_JPRB,1.5856E-04_JPRB/)
KAO( :, 3, 3, 5) = (/&
&2.9733E-04_JPRB,4.0070E-04_JPRB,4.3349E-04_JPRB,4.5188E-04_JPRB,4.5270E-04_JPRB,4.3123E-04_JPRB,&
&3.9880E-04_JPRB,4.4081E-04_JPRB,2.0446E-04_JPRB/)
KAO( :, 4, 3, 5) = (/&
&3.6501E-04_JPRB,4.9946E-04_JPRB,5.4499E-04_JPRB,5.7170E-04_JPRB,5.7932E-04_JPRB,5.6633E-04_JPRB,&
&5.2704E-04_JPRB,5.1414E-04_JPRB,2.5539E-04_JPRB/)
KAO( :, 5, 3, 5) = (/&
&4.4410E-04_JPRB,6.1578E-04_JPRB,6.7619E-04_JPRB,7.1133E-04_JPRB,7.2738E-04_JPRB,7.2351E-04_JPRB,&
&7.0138E-04_JPRB,6.6673E-04_JPRB,3.2169E-04_JPRB/)
KAO( :, 1, 4, 5) = (/&
&1.3808E-04_JPRB,1.7775E-04_JPRB,1.8565E-04_JPRB,1.8174E-04_JPRB,1.8202E-04_JPRB,1.9738E-04_JPRB,&
&2.6854E-04_JPRB,3.3980E-04_JPRB,9.6622E-05_JPRB/)
KAO( :, 2, 4, 5) = (/&
&1.7835E-04_JPRB,2.3331E-04_JPRB,2.4753E-04_JPRB,2.5139E-04_JPRB,2.3877E-04_JPRB,2.3221E-04_JPRB,&
&2.5394E-04_JPRB,4.0618E-04_JPRB,1.2075E-04_JPRB/)
KAO( :, 3, 4, 5) = (/&
&2.2702E-04_JPRB,3.0170E-04_JPRB,3.2275E-04_JPRB,3.3261E-04_JPRB,3.2998E-04_JPRB,3.0635E-04_JPRB,&
&3.0422E-04_JPRB,3.7513E-04_JPRB,1.4994E-04_JPRB/)
KAO( :, 4, 4, 5) = (/&
&2.8327E-04_JPRB,3.8288E-04_JPRB,4.1191E-04_JPRB,4.2826E-04_JPRB,4.2837E-04_JPRB,4.1511E-04_JPRB,&
&3.7299E-04_JPRB,4.1488E-04_JPRB,1.8740E-04_JPRB/)
KAO( :, 5, 4, 5) = (/&
&3.4778E-04_JPRB,4.7798E-04_JPRB,5.1863E-04_JPRB,5.4065E-04_JPRB,5.4665E-04_JPRB,5.3624E-04_JPRB,&
&5.0550E-04_JPRB,4.5874E-04_JPRB,2.3509E-04_JPRB/)
KAO( :, 1, 5, 5) = (/&
&1.0090E-04_JPRB,1.2840E-04_JPRB,1.3222E-04_JPRB,1.3092E-04_JPRB,1.3649E-04_JPRB,1.6019E-04_JPRB,&
&2.1671E-04_JPRB,2.5303E-04_JPRB,9.1217E-05_JPRB/)
KAO( :, 2, 5, 5) = (/&
&1.3290E-04_JPRB,1.7161E-04_JPRB,1.7952E-04_JPRB,1.7693E-04_JPRB,1.6957E-04_JPRB,1.7378E-04_JPRB,&
&2.2031E-04_JPRB,3.2593E-04_JPRB,1.0460E-04_JPRB/)
KAO( :, 3, 5, 5) = (/&
&1.7169E-04_JPRB,2.2556E-04_JPRB,2.3842E-04_JPRB,2.4266E-04_JPRB,2.3387E-04_JPRB,2.1722E-04_JPRB,&
&2.2376E-04_JPRB,3.3249E-04_JPRB,1.2312E-04_JPRB/)
KAO( :, 4, 5, 5) = (/&
&2.1761E-04_JPRB,2.9095E-04_JPRB,3.1013E-04_JPRB,3.1776E-04_JPRB,3.1556E-04_JPRB,2.9734E-04_JPRB,&
&2.7621E-04_JPRB,3.0674E-04_JPRB,1.4846E-04_JPRB/)
KAO( :, 5, 5, 5) = (/&
&2.6974E-04_JPRB,3.6873E-04_JPRB,3.9640E-04_JPRB,4.0873E-04_JPRB,4.0796E-04_JPRB,3.9425E-04_JPRB,&
&3.6157E-04_JPRB,3.6174E-04_JPRB,1.8146E-04_JPRB/)
KAO( :, 1, 6, 5) = (/&
&7.2092E-05_JPRB,9.1048E-05_JPRB,9.3429E-05_JPRB,9.5226E-05_JPRB,1.0150E-04_JPRB,1.3173E-04_JPRB,&
&1.4984E-04_JPRB,1.9196E-04_JPRB,9.8397E-05_JPRB/)
KAO( :, 2, 6, 5) = (/&
&9.7448E-05_JPRB,1.2423E-04_JPRB,1.2792E-04_JPRB,1.2413E-04_JPRB,1.2424E-04_JPRB,1.3383E-04_JPRB,&
&1.7960E-04_JPRB,2.4434E-04_JPRB,1.1133E-04_JPRB/)
KAO( :, 3, 6, 5) = (/&
&1.2736E-04_JPRB,1.6584E-04_JPRB,1.7360E-04_JPRB,1.7200E-04_JPRB,1.6167E-04_JPRB,1.5892E-04_JPRB,&
&1.7153E-04_JPRB,2.8218E-04_JPRB,1.2781E-04_JPRB/)
KAO( :, 4, 6, 5) = (/&
&1.6376E-04_JPRB,2.1742E-04_JPRB,2.3003E-04_JPRB,2.3266E-04_JPRB,2.2686E-04_JPRB,2.0723E-04_JPRB,&
&2.0538E-04_JPRB,2.5489E-04_JPRB,1.4690E-04_JPRB/)
KAO( :, 5, 6, 5) = (/&
&2.0555E-04_JPRB,2.7960E-04_JPRB,2.9861E-04_JPRB,3.0501E-04_JPRB,3.0003E-04_JPRB,2.8746E-04_JPRB,&
&2.5983E-04_JPRB,2.8313E-04_JPRB,1.7007E-04_JPRB/)
KAO( :, 1, 7, 5) = (/&
&5.0915E-05_JPRB,6.4096E-05_JPRB,6.5839E-05_JPRB,7.0435E-05_JPRB,8.2474E-05_JPRB,1.0016E-04_JPRB,&
&1.1360E-04_JPRB,1.4590E-04_JPRB,1.4032E-04_JPRB/)
KAO( :, 2, 7, 5) = (/&
&7.0625E-05_JPRB,8.9097E-05_JPRB,9.0314E-05_JPRB,8.9429E-05_JPRB,9.3251E-05_JPRB,1.0724E-04_JPRB,&
&1.4912E-04_JPRB,1.8863E-04_JPRB,1.5518E-04_JPRB/)
KAO( :, 3, 7, 5) = (/&
&9.4098E-05_JPRB,1.2125E-04_JPRB,1.2537E-04_JPRB,1.2091E-04_JPRB,1.1603E-04_JPRB,1.1857E-04_JPRB,&
&1.4624E-04_JPRB,2.2506E-04_JPRB,1.7262E-04_JPRB/)
KAO( :, 4, 7, 5) = (/&
&1.2191E-04_JPRB,1.6102E-04_JPRB,1.6901E-04_JPRB,1.6848E-04_JPRB,1.5829E-04_JPRB,1.4830E-04_JPRB,&
&1.5156E-04_JPRB,2.2031E-04_JPRB,1.9339E-04_JPRB/)
KAO( :, 5, 7, 5) = (/&
&1.5529E-04_JPRB,2.0973E-04_JPRB,2.2297E-04_JPRB,2.2562E-04_JPRB,2.1894E-04_JPRB,2.0410E-04_JPRB,&
&1.8782E-04_JPRB,2.1024E-04_JPRB,2.1671E-04_JPRB/)
KAO( :, 1, 8, 5) = (/&
&3.6049E-05_JPRB,4.5291E-05_JPRB,4.7754E-05_JPRB,5.1919E-05_JPRB,6.1186E-05_JPRB,6.9190E-05_JPRB,&
&8.4378E-05_JPRB,1.1648E-04_JPRB,2.7572E-04_JPRB/)
KAO( :, 2, 8, 5) = (/&
&5.1045E-05_JPRB,6.3896E-05_JPRB,6.4272E-05_JPRB,6.5150E-05_JPRB,6.9954E-05_JPRB,8.8868E-05_JPRB,&
&1.0162E-04_JPRB,1.4598E-04_JPRB,3.0000E-04_JPRB/)
KAO( :, 3, 8, 5) = (/&
&6.9216E-05_JPRB,8.8252E-05_JPRB,9.0050E-05_JPRB,8.5873E-05_JPRB,8.5359E-05_JPRB,9.1693E-05_JPRB,&
&1.2432E-04_JPRB,1.5741E-04_JPRB,3.2619E-04_JPRB/)
KAO( :, 4, 8, 5) = (/&
&9.0719E-05_JPRB,1.1854E-04_JPRB,1.2391E-04_JPRB,1.2089E-04_JPRB,1.1160E-04_JPRB,1.0845E-04_JPRB,&
&1.1912E-04_JPRB,1.9063E-04_JPRB,3.5459E-04_JPRB/)
KAO( :, 5, 8, 5) = (/&
&1.1702E-04_JPRB,1.5606E-04_JPRB,1.6531E-04_JPRB,1.6622E-04_JPRB,1.5932E-04_JPRB,1.4248E-04_JPRB,&
&1.4183E-04_JPRB,1.7131E-04_JPRB,3.8497E-04_JPRB/)
KAO( :, 1, 9, 5) = (/&
&2.5866E-05_JPRB,3.2320E-05_JPRB,3.4576E-05_JPRB,3.8709E-05_JPRB,4.6229E-05_JPRB,5.2438E-05_JPRB,&
&6.5503E-05_JPRB,9.3730E-05_JPRB,1.1703E-03_JPRB/)
KAO( :, 2, 9, 5) = (/&
&3.7130E-05_JPRB,4.6042E-05_JPRB,4.6409E-05_JPRB,4.8783E-05_JPRB,5.6170E-05_JPRB,6.7762E-05_JPRB,&
&7.7225E-05_JPRB,1.1273E-04_JPRB,1.2364E-03_JPRB/)
KAO( :, 3, 9, 5) = (/&
&5.1057E-05_JPRB,6.4238E-05_JPRB,6.4747E-05_JPRB,6.3009E-05_JPRB,6.3858E-05_JPRB,7.4779E-05_JPRB,&
&9.9385E-05_JPRB,1.2137E-04_JPRB,1.3035E-03_JPRB/)
KAO( :, 4, 9, 5) = (/&
&6.7872E-05_JPRB,8.7074E-05_JPRB,9.0171E-05_JPRB,8.6365E-05_JPRB,8.1775E-05_JPRB,8.1150E-05_JPRB,&
&1.0091E-04_JPRB,1.5846E-04_JPRB,1.3706E-03_JPRB/)
KAO( :, 5, 9, 5) = (/&
&8.8212E-05_JPRB,1.1565E-04_JPRB,1.2170E-04_JPRB,1.2148E-04_JPRB,1.1255E-04_JPRB,1.0392E-04_JPRB,&
&1.0391E-04_JPRB,1.5035E-04_JPRB,1.4393E-03_JPRB/)
KAO( :, 1,10, 5) = (/&
&2.0052E-05_JPRB,2.4599E-05_JPRB,2.6224E-05_JPRB,2.9775E-05_JPRB,3.4377E-05_JPRB,3.9753E-05_JPRB,&
&5.1870E-05_JPRB,7.0614E-05_JPRB,6.9310E-03_JPRB/)
KAO( :, 2,10, 5) = (/&
&2.8642E-05_JPRB,3.5006E-05_JPRB,3.5601E-05_JPRB,3.7670E-05_JPRB,4.4192E-05_JPRB,5.0297E-05_JPRB,&
&6.0753E-05_JPRB,8.8409E-05_JPRB,7.2473E-03_JPRB/)
KAO( :, 3,10, 5) = (/&
&3.9509E-05_JPRB,4.8803E-05_JPRB,4.8668E-05_JPRB,4.7951E-05_JPRB,5.0708E-05_JPRB,6.1469E-05_JPRB,&
&7.4297E-05_JPRB,9.6176E-05_JPRB,7.5424E-03_JPRB/)
KAO( :, 4,10, 5) = (/&
&5.2822E-05_JPRB,6.6323E-05_JPRB,6.7918E-05_JPRB,6.3993E-05_JPRB,6.2062E-05_JPRB,6.4519E-05_JPRB,&
&8.5147E-05_JPRB,1.1230E-04_JPRB,7.8121E-03_JPRB/)
KAO( :, 5,10, 5) = (/&
&6.8969E-05_JPRB,8.8314E-05_JPRB,9.1957E-05_JPRB,9.0701E-05_JPRB,8.2062E-05_JPRB,7.8779E-05_JPRB,&
&8.1888E-05_JPRB,1.3051E-04_JPRB,8.0714E-03_JPRB/)
KAO( :, 1,11, 5) = (/&
&1.9311E-05_JPRB,2.2943E-05_JPRB,2.3712E-05_JPRB,2.6076E-05_JPRB,2.9763E-05_JPRB,3.4761E-05_JPRB,&
&4.2561E-05_JPRB,5.7624E-05_JPRB,1.5187E-02_JPRB/)
KAO( :, 2,11, 5) = (/&
&2.6757E-05_JPRB,3.2178E-05_JPRB,3.2098E-05_JPRB,3.3425E-05_JPRB,3.7561E-05_JPRB,4.3432E-05_JPRB,&
&5.1256E-05_JPRB,7.3332E-05_JPRB,1.5840E-02_JPRB/)
KAO( :, 3,11, 5) = (/&
&3.6196E-05_JPRB,4.4102E-05_JPRB,4.3948E-05_JPRB,4.2431E-05_JPRB,4.4099E-05_JPRB,5.1811E-05_JPRB,&
&6.2145E-05_JPRB,8.0656E-05_JPRB,1.6449E-02_JPRB/)
KAO( :, 4,11, 5) = (/&
&4.7882E-05_JPRB,5.9111E-05_JPRB,6.0086E-05_JPRB,5.7204E-05_JPRB,5.4371E-05_JPRB,5.5076E-05_JPRB,&
&7.0526E-05_JPRB,9.2945E-05_JPRB,1.6989E-02_JPRB/)
KAO( :, 5,11, 5) = (/&
&6.2068E-05_JPRB,7.8174E-05_JPRB,8.0859E-05_JPRB,7.9258E-05_JPRB,7.2738E-05_JPRB,6.8607E-05_JPRB,&
&6.8925E-05_JPRB,1.0616E-04_JPRB,1.7481E-02_JPRB/)
KAO( :, 1,12, 5) = (/&
&1.8157E-05_JPRB,2.1121E-05_JPRB,2.1509E-05_JPRB,2.2736E-05_JPRB,2.6145E-05_JPRB,3.0200E-05_JPRB,&
&3.7064E-05_JPRB,5.0458E-05_JPRB,2.1164E-02_JPRB/)
KAO( :, 2,12, 5) = (/&
&2.4750E-05_JPRB,2.9265E-05_JPRB,2.8640E-05_JPRB,2.9365E-05_JPRB,3.1815E-05_JPRB,3.7644E-05_JPRB,&
&4.4258E-05_JPRB,6.0893E-05_JPRB,2.2083E-02_JPRB/)
KAO( :, 3,12, 5) = (/&
&3.3051E-05_JPRB,3.9669E-05_JPRB,3.9323E-05_JPRB,3.7322E-05_JPRB,3.8330E-05_JPRB,4.3268E-05_JPRB,&
&5.2953E-05_JPRB,6.6459E-05_JPRB,2.2904E-02_JPRB/)
KAO( :, 4,12, 5) = (/&
&4.3268E-05_JPRB,5.2755E-05_JPRB,5.3305E-05_JPRB,5.0755E-05_JPRB,4.7183E-05_JPRB,4.7321E-05_JPRB,&
&5.8905E-05_JPRB,7.8211E-05_JPRB,2.3625E-02_JPRB/)
KAO( :, 5,12, 5) = (/&
&5.5712E-05_JPRB,6.9313E-05_JPRB,7.1134E-05_JPRB,6.9400E-05_JPRB,6.4153E-05_JPRB,5.9244E-05_JPRB,&
&5.8683E-05_JPRB,8.6772E-05_JPRB,2.4304E-02_JPRB/)
KAO( :, 1,13, 5) = (/&
&1.7179E-05_JPRB,1.9773E-05_JPRB,1.9599E-05_JPRB,2.0374E-05_JPRB,2.3480E-05_JPRB,2.5935E-05_JPRB,&
&3.2097E-05_JPRB,4.3807E-05_JPRB,2.3722E-02_JPRB/)
KAO( :, 2,13, 5) = (/&
&2.3195E-05_JPRB,2.7018E-05_JPRB,2.6155E-05_JPRB,2.6118E-05_JPRB,2.7654E-05_JPRB,3.2413E-05_JPRB,&
&3.6439E-05_JPRB,5.1480E-05_JPRB,2.4748E-02_JPRB/)
KAO( :, 3,13, 5) = (/&
&3.0612E-05_JPRB,3.6208E-05_JPRB,3.5603E-05_JPRB,3.3306E-05_JPRB,3.3238E-05_JPRB,3.6754E-05_JPRB,&
&4.5231E-05_JPRB,5.7370E-05_JPRB,2.5646E-02_JPRB/)
KAO( :, 4,13, 5) = (/&
&3.9626E-05_JPRB,4.7737E-05_JPRB,4.7941E-05_JPRB,4.5252E-05_JPRB,4.1653E-05_JPRB,4.0753E-05_JPRB,&
&4.9320E-05_JPRB,6.5660E-05_JPRB,2.6492E-02_JPRB/)
KAO( :, 5,13, 5) = (/&
&5.0622E-05_JPRB,6.2138E-05_JPRB,6.3203E-05_JPRB,6.1426E-05_JPRB,5.6252E-05_JPRB,5.1272E-05_JPRB,&
&5.0385E-05_JPRB,7.0865E-05_JPRB,2.7279E-02_JPRB/)
KAO( :, 1, 1, 6) = (/&
&7.6668E-04_JPRB,9.5698E-04_JPRB,1.0451E-03_JPRB,1.0706E-03_JPRB,1.0458E-03_JPRB,9.8544E-04_JPRB,&
&8.4925E-04_JPRB,7.0084E-04_JPRB,3.6790E-04_JPRB/)
KAO( :, 2, 1, 6) = (/&
&9.3715E-04_JPRB,1.2033E-03_JPRB,1.3264E-03_JPRB,1.3678E-03_JPRB,1.3579E-03_JPRB,1.2955E-03_JPRB,&
&1.2019E-03_JPRB,1.0530E-03_JPRB,4.9374E-04_JPRB/)
KAO( :, 3, 1, 6) = (/&
&1.1259E-03_JPRB,1.4892E-03_JPRB,1.6507E-03_JPRB,1.7086E-03_JPRB,1.7099E-03_JPRB,1.6660E-03_JPRB,&
&1.5468E-03_JPRB,1.3572E-03_JPRB,6.9469E-04_JPRB/)
KAO( :, 4, 1, 6) = (/&
&1.3346E-03_JPRB,1.8150E-03_JPRB,2.0125E-03_JPRB,2.0930E-03_JPRB,2.1054E-03_JPRB,2.0604E-03_JPRB,&
&1.9461E-03_JPRB,1.7694E-03_JPRB,9.3629E-04_JPRB/)
KAO( :, 5, 1, 6) = (/&
&1.5631E-03_JPRB,2.1751E-03_JPRB,2.4107E-03_JPRB,2.5177E-03_JPRB,2.5412E-03_JPRB,2.4997E-03_JPRB,&
&2.4003E-03_JPRB,2.2329E-03_JPRB,1.1943E-03_JPRB/)
KAO( :, 1, 2, 6) = (/&
&6.1736E-04_JPRB,7.7957E-04_JPRB,8.4495E-04_JPRB,8.5822E-04_JPRB,8.3168E-04_JPRB,7.6710E-04_JPRB,&
&6.8197E-04_JPRB,6.1117E-04_JPRB,2.7552E-04_JPRB/)
KAO( :, 2, 2, 6) = (/&
&7.6431E-04_JPRB,9.9047E-04_JPRB,1.0825E-03_JPRB,1.1059E-03_JPRB,1.0905E-03_JPRB,1.0282E-03_JPRB,&
&9.1763E-04_JPRB,8.3788E-04_JPRB,3.8116E-04_JPRB/)
KAO( :, 3, 2, 6) = (/&
&9.2906E-04_JPRB,1.2346E-03_JPRB,1.3561E-03_JPRB,1.3925E-03_JPRB,1.3898E-03_JPRB,1.3440E-03_JPRB,&
&1.2411E-03_JPRB,1.1007E-03_JPRB,5.2777E-04_JPRB/)
KAO( :, 4, 2, 6) = (/&
&1.1126E-03_JPRB,1.5138E-03_JPRB,1.6623E-03_JPRB,1.7166E-03_JPRB,1.7237E-03_JPRB,1.6799E-03_JPRB,&
&1.5813E-03_JPRB,1.4262E-03_JPRB,7.0852E-04_JPRB/)
KAO( :, 5, 2, 6) = (/&
&1.3161E-03_JPRB,1.8216E-03_JPRB,2.0023E-03_JPRB,2.0780E-03_JPRB,2.0918E-03_JPRB,2.0576E-03_JPRB,&
&1.9689E-03_JPRB,1.8083E-03_JPRB,9.0055E-04_JPRB/)
KAO( :, 1, 3, 6) = (/&
&4.6874E-04_JPRB,5.9508E-04_JPRB,6.3781E-04_JPRB,6.4117E-04_JPRB,6.1436E-04_JPRB,5.4822E-04_JPRB,&
&5.0421E-04_JPRB,5.3533E-04_JPRB,2.0334E-04_JPRB/)
KAO( :, 2, 3, 6) = (/&
&5.9055E-04_JPRB,7.6700E-04_JPRB,8.2890E-04_JPRB,8.3946E-04_JPRB,8.1795E-04_JPRB,7.6034E-04_JPRB,&
&6.7368E-04_JPRB,6.0816E-04_JPRB,2.8145E-04_JPRB/)
KAO( :, 3, 3, 6) = (/&
&7.2955E-04_JPRB,9.6821E-04_JPRB,1.0493E-03_JPRB,1.0696E-03_JPRB,1.0616E-03_JPRB,1.0150E-03_JPRB,&
&9.2112E-04_JPRB,8.3960E-04_JPRB,3.8605E-04_JPRB/)
KAO( :, 4, 3, 6) = (/&
&8.8621E-04_JPRB,1.1995E-03_JPRB,1.3001E-03_JPRB,1.3322E-03_JPRB,1.3333E-03_JPRB,1.2938E-03_JPRB,&
&1.2044E-03_JPRB,1.0885E-03_JPRB,5.0764E-04_JPRB/)
KAO( :, 5, 3, 6) = (/&
&1.0620E-03_JPRB,1.4561E-03_JPRB,1.5813E-03_JPRB,1.6291E-03_JPRB,1.6339E-03_JPRB,1.6065E-03_JPRB,&
&1.5265E-03_JPRB,1.3705E-03_JPRB,6.4701E-04_JPRB/)
KAO( :, 1, 4, 6) = (/&
&3.4631E-04_JPRB,4.3892E-04_JPRB,4.6539E-04_JPRB,4.6252E-04_JPRB,4.3395E-04_JPRB,3.8559E-04_JPRB,&
&3.5487E-04_JPRB,4.4831E-04_JPRB,1.5114E-04_JPRB/)
KAO( :, 2, 4, 6) = (/&
&4.4425E-04_JPRB,5.7553E-04_JPRB,6.1538E-04_JPRB,6.1883E-04_JPRB,5.9314E-04_JPRB,5.4165E-04_JPRB,&
&4.8640E-04_JPRB,4.4227E-04_JPRB,2.0515E-04_JPRB/)
KAO( :, 3, 4, 6) = (/&
&5.5883E-04_JPRB,7.3740E-04_JPRB,7.9031E-04_JPRB,7.9974E-04_JPRB,7.8639E-04_JPRB,7.3691E-04_JPRB,&
&6.4680E-04_JPRB,6.1866E-04_JPRB,2.7731E-04_JPRB/)
KAO( :, 4, 4, 6) = (/&
&6.8974E-04_JPRB,9.2537E-04_JPRB,9.9228E-04_JPRB,1.0098E-03_JPRB,1.0044E-03_JPRB,9.6650E-04_JPRB,&
&8.8358E-04_JPRB,7.6484E-04_JPRB,3.6266E-04_JPRB/)
KAO( :, 5, 4, 6) = (/&
&8.3990E-04_JPRB,1.1361E-03_JPRB,1.2201E-03_JPRB,1.2496E-03_JPRB,1.2472E-03_JPRB,1.2194E-03_JPRB,&
&1.1540E-03_JPRB,1.0325E-03_JPRB,4.6430E-04_JPRB/)
KAO( :, 1, 5, 6) = (/&
&2.5250E-04_JPRB,3.1808E-04_JPRB,3.3386E-04_JPRB,3.2714E-04_JPRB,3.0037E-04_JPRB,2.7399E-04_JPRB,&
&2.6791E-04_JPRB,3.5704E-04_JPRB,1.2908E-04_JPRB/)
KAO( :, 2, 5, 6) = (/&
&3.3043E-04_JPRB,4.2488E-04_JPRB,4.5012E-04_JPRB,4.4889E-04_JPRB,4.2554E-04_JPRB,3.8200E-04_JPRB,&
&3.3745E-04_JPRB,3.7310E-04_JPRB,1.6348E-04_JPRB/)
KAO( :, 3, 5, 6) = (/&
&4.2316E-04_JPRB,5.5338E-04_JPRB,5.8740E-04_JPRB,5.9160E-04_JPRB,5.7542E-04_JPRB,5.3101E-04_JPRB,&
&4.6257E-04_JPRB,4.4755E-04_JPRB,2.1057E-04_JPRB/)
KAO( :, 4, 5, 6) = (/&
&5.3209E-04_JPRB,7.0370E-04_JPRB,7.4784E-04_JPRB,7.5773E-04_JPRB,7.4773E-04_JPRB,7.1163E-04_JPRB,&
&6.4170E-04_JPRB,5.6009E-04_JPRB,2.6995E-04_JPRB/)
KAO( :, 5, 5, 6) = (/&
&6.5954E-04_JPRB,8.7577E-04_JPRB,9.3136E-04_JPRB,9.4956E-04_JPRB,9.4321E-04_JPRB,9.1424E-04_JPRB,&
&8.5021E-04_JPRB,7.6505E-04_JPRB,3.4403E-04_JPRB/)
KAO( :, 1, 6, 6) = (/&
&1.8041E-04_JPRB,2.2490E-04_JPRB,2.3336E-04_JPRB,2.2464E-04_JPRB,2.0963E-04_JPRB,1.9425E-04_JPRB,&
&2.2107E-04_JPRB,2.7984E-04_JPRB,1.4894E-04_JPRB/)
KAO( :, 2, 6, 6) = (/&
&2.4129E-04_JPRB,3.0664E-04_JPRB,3.2201E-04_JPRB,3.1753E-04_JPRB,2.9432E-04_JPRB,2.6424E-04_JPRB,&
&2.4608E-04_JPRB,3.2717E-04_JPRB,1.7150E-04_JPRB/)
KAO( :, 3, 6, 6) = (/&
&3.1506E-04_JPRB,4.0665E-04_JPRB,4.2823E-04_JPRB,4.2924E-04_JPRB,4.1092E-04_JPRB,3.7075E-04_JPRB,&
&3.2608E-04_JPRB,3.0715E-04_JPRB,1.9997E-04_JPRB/)
KAO( :, 4, 6, 6) = (/&
&4.0467E-04_JPRB,5.2530E-04_JPRB,5.5383E-04_JPRB,5.5842E-04_JPRB,5.4724E-04_JPRB,5.1243E-04_JPRB,&
&4.4254E-04_JPRB,3.9888E-04_JPRB,2.3767E-04_JPRB/)
KAO( :, 5, 6, 6) = (/&
&5.1106E-04_JPRB,6.6417E-04_JPRB,6.9974E-04_JPRB,7.0967E-04_JPRB,7.0212E-04_JPRB,6.7161E-04_JPRB,&
&6.0464E-04_JPRB,5.2589E-04_JPRB,2.8598E-04_JPRB/)
KAO( :, 1, 7, 6) = (/&
&1.2786E-04_JPRB,1.5741E-04_JPRB,1.6149E-04_JPRB,1.5385E-04_JPRB,1.4113E-04_JPRB,1.3717E-04_JPRB,&
&1.7921E-04_JPRB,2.1884E-04_JPRB,2.2335E-04_JPRB/)
KAO( :, 2, 7, 6) = (/&
&1.7476E-04_JPRB,2.1914E-04_JPRB,2.2777E-04_JPRB,2.2084E-04_JPRB,2.0229E-04_JPRB,1.8812E-04_JPRB,&
&1.8018E-04_JPRB,2.7538E-04_JPRB,2.4653E-04_JPRB/)
KAO( :, 3, 7, 6) = (/&
&2.3335E-04_JPRB,2.9589E-04_JPRB,3.0942E-04_JPRB,3.0765E-04_JPRB,2.8977E-04_JPRB,2.5625E-04_JPRB,&
&2.3275E-04_JPRB,2.5170E-04_JPRB,2.7339E-04_JPRB/)
KAO( :, 4, 7, 6) = (/&
&3.0583E-04_JPRB,3.8902E-04_JPRB,4.0709E-04_JPRB,4.0819E-04_JPRB,3.9588E-04_JPRB,3.6356E-04_JPRB,&
&3.1361E-04_JPRB,2.9658E-04_JPRB,3.0348E-04_JPRB/)
KAO( :, 5, 7, 6) = (/&
&3.9359E-04_JPRB,5.0084E-04_JPRB,5.2271E-04_JPRB,5.2613E-04_JPRB,5.1742E-04_JPRB,4.8862E-04_JPRB,&
&4.3693E-04_JPRB,3.8092E-04_JPRB,3.3962E-04_JPRB/)
KAO( :, 1, 8, 6) = (/&
&9.0775E-05_JPRB,1.1005E-04_JPRB,1.1099E-04_JPRB,1.0509E-04_JPRB,9.9650E-05_JPRB,1.1055E-04_JPRB,&
&1.4832E-04_JPRB,1.7530E-04_JPRB,4.7525E-04_JPRB/)
KAO( :, 2, 8, 6) = (/&
&1.2669E-04_JPRB,1.5629E-04_JPRB,1.6068E-04_JPRB,1.5361E-04_JPRB,1.4250E-04_JPRB,1.3452E-04_JPRB,&
&1.4933E-04_JPRB,2.0310E-04_JPRB,5.0480E-04_JPRB/)
KAO( :, 3, 8, 6) = (/&
&1.7285E-04_JPRB,2.1483E-04_JPRB,2.2274E-04_JPRB,2.1837E-04_JPRB,2.0107E-04_JPRB,1.8034E-04_JPRB,&
&1.6967E-04_JPRB,2.2418E-04_JPRB,5.3971E-04_JPRB/)
KAO( :, 4, 8, 6) = (/&
&2.3078E-04_JPRB,2.8784E-04_JPRB,2.9834E-04_JPRB,2.9682E-04_JPRB,2.8348E-04_JPRB,2.5378E-04_JPRB,&
&2.1967E-04_JPRB,2.1775E-04_JPRB,5.7949E-04_JPRB/)
KAO( :, 5, 8, 6) = (/&
&3.0207E-04_JPRB,3.7730E-04_JPRB,3.9003E-04_JPRB,3.8941E-04_JPRB,3.7851E-04_JPRB,3.5314E-04_JPRB,&
&3.0320E-04_JPRB,2.7345E-04_JPRB,6.2347E-04_JPRB/)
KAO( :, 1, 9, 6) = (/&
&6.4923E-05_JPRB,7.7301E-05_JPRB,7.6873E-05_JPRB,7.2507E-05_JPRB,7.2968E-05_JPRB,8.8916E-05_JPRB,&
&1.0626E-04_JPRB,1.3047E-04_JPRB,2.1479E-03_JPRB/)
KAO( :, 2, 9, 6) = (/&
&9.2060E-05_JPRB,1.1144E-04_JPRB,1.1301E-04_JPRB,1.0673E-04_JPRB,9.8741E-05_JPRB,9.7585E-05_JPRB,&
&1.2203E-04_JPRB,1.5315E-04_JPRB,2.2213E-03_JPRB/)
KAO( :, 3, 9, 6) = (/&
&1.2784E-04_JPRB,1.5591E-04_JPRB,1.5957E-04_JPRB,1.5395E-04_JPRB,1.4101E-04_JPRB,1.2937E-04_JPRB,&
&1.2902E-04_JPRB,1.8269E-04_JPRB,2.3004E-03_JPRB/)
KAO( :, 4, 9, 6) = (/&
&1.7362E-04_JPRB,2.1265E-04_JPRB,2.1819E-04_JPRB,2.1460E-04_JPRB,2.0088E-04_JPRB,1.7687E-04_JPRB,&
&1.6114E-04_JPRB,1.7045E-04_JPRB,2.3836E-03_JPRB/)
KAO( :, 5, 9, 6) = (/&
&2.3060E-04_JPRB,2.8346E-04_JPRB,2.9069E-04_JPRB,2.8691E-04_JPRB,2.7538E-04_JPRB,2.5192E-04_JPRB,&
&2.1567E-04_JPRB,2.0242E-04_JPRB,2.4645E-03_JPRB/)
KAO( :, 1,10, 6) = (/&
&4.9625E-05_JPRB,5.7572E-05_JPRB,5.6443E-05_JPRB,5.4999E-05_JPRB,5.9435E-05_JPRB,7.0786E-05_JPRB,&
&7.6295E-05_JPRB,1.0573E-04_JPRB,1.3224E-02_JPRB/)
KAO( :, 2,10, 6) = (/&
&7.0134E-05_JPRB,8.3014E-05_JPRB,8.2620E-05_JPRB,7.7969E-05_JPRB,7.3377E-05_JPRB,8.0016E-05_JPRB,&
&9.8395E-05_JPRB,1.2266E-04_JPRB,1.3476E-02_JPRB/)
KAO( :, 3,10, 6) = (/&
&9.7838E-05_JPRB,1.1716E-04_JPRB,1.1840E-04_JPRB,1.1257E-04_JPRB,1.0247E-04_JPRB,9.5389E-05_JPRB,&
&1.0384E-04_JPRB,1.4488E-04_JPRB,1.3733E-02_JPRB/)
KAO( :, 4,10, 6) = (/&
&1.3411E-04_JPRB,1.6175E-04_JPRB,1.6407E-04_JPRB,1.5918E-04_JPRB,1.4592E-04_JPRB,1.2914E-04_JPRB,&
&1.2234E-04_JPRB,1.5601E-04_JPRB,1.4015E-02_JPRB/)
KAO( :, 5,10, 6) = (/&
&1.7947E-04_JPRB,2.1813E-04_JPRB,2.2167E-04_JPRB,2.1661E-04_JPRB,2.0497E-04_JPRB,1.8308E-04_JPRB,&
&1.5705E-04_JPRB,1.5556E-04_JPRB,1.4285E-02_JPRB/)
KAO( :, 1,11, 6) = (/&
&4.6838E-05_JPRB,5.3188E-05_JPRB,5.1940E-05_JPRB,4.9560E-05_JPRB,5.2867E-05_JPRB,6.0471E-05_JPRB,&
&6.7131E-05_JPRB,8.9235E-05_JPRB,2.9682E-02_JPRB/)
KAO( :, 2,11, 6) = (/&
&6.4771E-05_JPRB,7.4879E-05_JPRB,7.3789E-05_JPRB,6.9085E-05_JPRB,6.5402E-05_JPRB,6.9078E-05_JPRB,&
&8.2402E-05_JPRB,9.7823E-05_JPRB,3.0214E-02_JPRB/)
KAO( :, 3,11, 6) = (/&
&8.8977E-05_JPRB,1.0443E-04_JPRB,1.0449E-04_JPRB,9.8837E-05_JPRB,8.9325E-05_JPRB,8.2564E-05_JPRB,&
&9.0256E-05_JPRB,1.2264E-04_JPRB,3.0751E-02_JPRB/)
KAO( :, 4,11, 6) = (/&
&1.2031E-04_JPRB,1.4341E-04_JPRB,1.4439E-04_JPRB,1.3909E-04_JPRB,1.2684E-04_JPRB,1.1148E-04_JPRB,&
&1.0343E-04_JPRB,1.2710E-04_JPRB,3.1294E-02_JPRB/)
KAO( :, 5,11, 6) = (/&
&1.5966E-04_JPRB,1.9217E-04_JPRB,1.9445E-04_JPRB,1.8922E-04_JPRB,1.7785E-04_JPRB,1.5826E-04_JPRB,&
&1.3426E-04_JPRB,1.3572E-04_JPRB,3.1828E-02_JPRB/)
KAO( :, 1,12, 6) = (/&
&4.4013E-05_JPRB,4.9051E-05_JPRB,4.7310E-05_JPRB,4.5083E-05_JPRB,4.5655E-05_JPRB,5.3046E-05_JPRB,&
&5.5846E-05_JPRB,7.3868E-05_JPRB,4.2262E-02_JPRB/)
KAO( :, 2,12, 6) = (/&
&5.9811E-05_JPRB,6.7905E-05_JPRB,6.6450E-05_JPRB,6.1482E-05_JPRB,5.7471E-05_JPRB,5.8427E-05_JPRB,&
&7.0235E-05_JPRB,8.1755E-05_JPRB,4.3100E-02_JPRB/)
KAO( :, 3,12, 6) = (/&
&8.0771E-05_JPRB,9.3483E-05_JPRB,9.2712E-05_JPRB,8.7290E-05_JPRB,7.8335E-05_JPRB,7.2055E-05_JPRB,&
&7.5619E-05_JPRB,1.0330E-04_JPRB,4.3963E-02_JPRB/)
KAO( :, 4,12, 6) = (/&
&1.0778E-04_JPRB,1.2684E-04_JPRB,1.2706E-04_JPRB,1.2188E-04_JPRB,1.1092E-04_JPRB,9.6993E-05_JPRB,&
&8.8534E-05_JPRB,1.0545E-04_JPRB,4.4781E-02_JPRB/)
KAO( :, 5,12, 6) = (/&
&1.4170E-04_JPRB,1.6874E-04_JPRB,1.7020E-04_JPRB,1.6546E-04_JPRB,1.5470E-04_JPRB,1.3786E-04_JPRB,&
&1.1554E-04_JPRB,1.1534E-04_JPRB,4.5542E-02_JPRB/)
KAO( :, 1,13, 6) = (/&
&4.2090E-05_JPRB,4.6101E-05_JPRB,4.3965E-05_JPRB,4.1016E-05_JPRB,4.0300E-05_JPRB,4.5499E-05_JPRB,&
&4.8852E-05_JPRB,6.1759E-05_JPRB,4.8346E-02_JPRB/)
KAO( :, 2,13, 6) = (/&
&5.6243E-05_JPRB,6.2753E-05_JPRB,6.0819E-05_JPRB,5.5713E-05_JPRB,5.1322E-05_JPRB,5.0494E-05_JPRB,&
&6.0604E-05_JPRB,6.8003E-05_JPRB,4.9462E-02_JPRB/)
KAO( :, 3,13, 6) = (/&
&7.4458E-05_JPRB,8.4643E-05_JPRB,8.3343E-05_JPRB,7.8251E-05_JPRB,6.9869E-05_JPRB,6.3030E-05_JPRB,&
&6.3206E-05_JPRB,8.7133E-05_JPRB,5.0553E-02_JPRB/)
KAO( :, 4,13, 6) = (/&
&9.7702E-05_JPRB,1.1298E-04_JPRB,1.1246E-04_JPRB,1.0753E-04_JPRB,9.7507E-05_JPRB,8.4857E-05_JPRB,&
&7.6788E-05_JPRB,8.6167E-05_JPRB,5.1568E-02_JPRB/)
KAO( :, 5,13, 6) = (/&
&1.2694E-04_JPRB,1.4871E-04_JPRB,1.4954E-04_JPRB,1.4480E-04_JPRB,1.3473E-04_JPRB,1.1941E-04_JPRB,&
&9.9413E-05_JPRB,9.9688E-05_JPRB,5.2519E-02_JPRB/)
KAO( :, 1, 1, 7) = (/&
&2.0564E-03_JPRB,2.2357E-03_JPRB,2.2921E-03_JPRB,2.2746E-03_JPRB,2.1808E-03_JPRB,2.0118E-03_JPRB,&
&1.7401E-03_JPRB,1.3032E-03_JPRB,9.5552E-04_JPRB/)
KAO( :, 2, 1, 7) = (/&
&2.5245E-03_JPRB,2.7780E-03_JPRB,2.8722E-03_JPRB,2.8575E-03_JPRB,2.7633E-03_JPRB,2.6046E-03_JPRB,&
&2.3222E-03_JPRB,1.8131E-03_JPRB,1.3540E-03_JPRB/)
KAO( :, 3, 1, 7) = (/&
&3.0325E-03_JPRB,3.3773E-03_JPRB,3.5284E-03_JPRB,3.5242E-03_JPRB,3.4302E-03_JPRB,3.2547E-03_JPRB,&
&2.9982E-03_JPRB,2.6610E-03_JPRB,1.7942E-03_JPRB/)
KAO( :, 4, 1, 7) = (/&
&3.5774E-03_JPRB,4.0328E-03_JPRB,4.2570E-03_JPRB,4.2786E-03_JPRB,4.1734E-03_JPRB,3.9880E-03_JPRB,&
&3.7418E-03_JPRB,3.6443E-03_JPRB,2.2977E-03_JPRB/)
KAO( :, 5, 1, 7) = (/&
&4.1551E-03_JPRB,4.7493E-03_JPRB,5.0612E-03_JPRB,5.1084E-03_JPRB,4.9896E-03_JPRB,4.7828E-03_JPRB,&
&4.5388E-03_JPRB,4.6729E-03_JPRB,2.8901E-03_JPRB/)
KAO( :, 1, 2, 7) = (/&
&1.7021E-03_JPRB,1.8729E-03_JPRB,1.9247E-03_JPRB,1.9078E-03_JPRB,1.8213E-03_JPRB,1.6737E-03_JPRB,&
&1.4152E-03_JPRB,1.0410E-03_JPRB,7.2465E-04_JPRB/)
KAO( :, 2, 2, 7) = (/&
&2.1085E-03_JPRB,2.3473E-03_JPRB,2.4306E-03_JPRB,2.4189E-03_JPRB,2.3372E-03_JPRB,2.1946E-03_JPRB,&
&1.9650E-03_JPRB,1.4507E-03_JPRB,1.0070E-03_JPRB/)
KAO( :, 3, 2, 7) = (/&
&2.5539E-03_JPRB,2.8790E-03_JPRB,3.0056E-03_JPRB,3.0096E-03_JPRB,2.9218E-03_JPRB,2.7596E-03_JPRB,&
&2.5256E-03_JPRB,2.1562E-03_JPRB,1.3358E-03_JPRB/)
KAO( :, 4, 2, 7) = (/&
&3.0381E-03_JPRB,3.4689E-03_JPRB,3.6518E-03_JPRB,3.6778E-03_JPRB,3.5757E-03_JPRB,3.4032E-03_JPRB,&
&3.1678E-03_JPRB,2.9648E-03_JPRB,1.7229E-03_JPRB/)
KAO( :, 5, 2, 7) = (/&
&3.5521E-03_JPRB,4.1214E-03_JPRB,4.3704E-03_JPRB,4.4118E-03_JPRB,4.3015E-03_JPRB,4.1082E-03_JPRB,&
&3.8609E-03_JPRB,3.8044E-03_JPRB,2.1852E-03_JPRB/)
KAO( :, 1, 3, 7) = (/&
&1.3207E-03_JPRB,1.4650E-03_JPRB,1.5081E-03_JPRB,1.4879E-03_JPRB,1.4138E-03_JPRB,1.2859E-03_JPRB,&
&1.0511E-03_JPRB,7.8811E-04_JPRB,5.1479E-04_JPRB/)
KAO( :, 2, 3, 7) = (/&
&1.6600E-03_JPRB,1.8649E-03_JPRB,1.9312E-03_JPRB,1.9179E-03_JPRB,1.8422E-03_JPRB,1.7178E-03_JPRB,&
&1.5069E-03_JPRB,1.1268E-03_JPRB,7.0924E-04_JPRB/)
KAO( :, 3, 3, 7) = (/&
&2.0389E-03_JPRB,2.3205E-03_JPRB,2.4185E-03_JPRB,2.4171E-03_JPRB,2.3339E-03_JPRB,2.1929E-03_JPRB,&
&1.9846E-03_JPRB,1.6361E-03_JPRB,9.4601E-04_JPRB/)
KAO( :, 4, 3, 7) = (/&
&2.4547E-03_JPRB,2.8320E-03_JPRB,2.9726E-03_JPRB,2.9883E-03_JPRB,2.8925E-03_JPRB,2.7393E-03_JPRB,&
&2.5305E-03_JPRB,2.2455E-03_JPRB,1.2306E-03_JPRB/)
KAO( :, 5, 3, 7) = (/&
&2.8997E-03_JPRB,3.4059E-03_JPRB,3.5906E-03_JPRB,3.6183E-03_JPRB,3.5177E-03_JPRB,3.3454E-03_JPRB,&
&3.1285E-03_JPRB,2.9519E-03_JPRB,1.5729E-03_JPRB/)
KAO( :, 1, 4, 7) = (/&
&9.9106E-04_JPRB,1.1077E-03_JPRB,1.1376E-03_JPRB,1.1157E-03_JPRB,1.0521E-03_JPRB,9.4148E-04_JPRB,&
&7.8510E-04_JPRB,5.6824E-04_JPRB,3.5975E-04_JPRB/)
KAO( :, 2, 4, 7) = (/&
&1.2690E-03_JPRB,1.4351E-03_JPRB,1.4835E-03_JPRB,1.4646E-03_JPRB,1.3997E-03_JPRB,1.2889E-03_JPRB,&
&1.0960E-03_JPRB,8.9289E-04_JPRB,4.9353E-04_JPRB/)
KAO( :, 3, 4, 7) = (/&
&1.5842E-03_JPRB,1.8142E-03_JPRB,1.8866E-03_JPRB,1.8780E-03_JPRB,1.8013E-03_JPRB,1.6820E-03_JPRB,&
&1.5023E-03_JPRB,1.1830E-03_JPRB,6.6203E-04_JPRB/)
KAO( :, 4, 4, 7) = (/&
&1.9340E-03_JPRB,2.2471E-03_JPRB,2.3499E-03_JPRB,2.3511E-03_JPRB,2.2648E-03_JPRB,2.1322E-03_JPRB,&
&1.9509E-03_JPRB,1.6764E-03_JPRB,8.7194E-04_JPRB/)
KAO( :, 5, 4, 7) = (/&
&2.3113E-03_JPRB,2.7351E-03_JPRB,2.8762E-03_JPRB,2.8805E-03_JPRB,2.7879E-03_JPRB,2.6395E-03_JPRB,&
&2.4567E-03_JPRB,2.2403E-03_JPRB,1.1262E-03_JPRB/)
KAO( :, 1, 5, 7) = (/&
&7.3127E-04_JPRB,8.2296E-04_JPRB,8.4087E-04_JPRB,8.1934E-04_JPRB,7.6237E-04_JPRB,6.6355E-04_JPRB,&
&5.7712E-04_JPRB,4.2586E-04_JPRB,2.6106E-04_JPRB/)
KAO( :, 2, 5, 7) = (/&
&9.5564E-04_JPRB,1.0866E-03_JPRB,1.1175E-03_JPRB,1.0975E-03_JPRB,1.0423E-03_JPRB,9.4115E-04_JPRB,&
&7.8089E-04_JPRB,7.0271E-04_JPRB,3.5186E-04_JPRB/)
KAO( :, 3, 5, 7) = (/&
&1.2139E-03_JPRB,1.3968E-03_JPRB,1.4447E-03_JPRB,1.4289E-03_JPRB,1.3656E-03_JPRB,1.2642E-03_JPRB,&
&1.1044E-03_JPRB,8.5519E-04_JPRB,4.7090E-04_JPRB/)
KAO( :, 4, 5, 7) = (/&
&1.5030E-03_JPRB,1.7556E-03_JPRB,1.8265E-03_JPRB,1.8139E-03_JPRB,1.7423E-03_JPRB,1.6256E-03_JPRB,&
&1.4668E-03_JPRB,1.2302E-03_JPRB,6.2262E-04_JPRB/)
KAO( :, 5, 5, 7) = (/&
&1.8204E-03_JPRB,2.1651E-03_JPRB,2.2625E-03_JPRB,2.2502E-03_JPRB,2.1716E-03_JPRB,2.0469E-03_JPRB,&
&1.8925E-03_JPRB,1.6626E-03_JPRB,8.1240E-04_JPRB/)
KAO( :, 1, 6, 7) = (/&
&5.2529E-04_JPRB,5.9432E-04_JPRB,6.0352E-04_JPRB,5.8305E-04_JPRB,5.3304E-04_JPRB,4.5328E-04_JPRB,&
&4.1878E-04_JPRB,3.5780E-04_JPRB,2.4217E-04_JPRB/)
KAO( :, 2, 6, 7) = (/&
&7.0212E-04_JPRB,8.0206E-04_JPRB,8.1885E-04_JPRB,8.0064E-04_JPRB,7.5267E-04_JPRB,6.6720E-04_JPRB,&
&5.4925E-04_JPRB,4.7137E-04_JPRB,2.9304E-04_JPRB/)
KAO( :, 3, 6, 7) = (/&
&9.0974E-04_JPRB,1.0505E-03_JPRB,1.0784E-03_JPRB,1.0608E-03_JPRB,1.0082E-03_JPRB,9.2191E-04_JPRB,&
&7.8184E-04_JPRB,6.5554E-04_JPRB,3.6650E-04_JPRB/)
KAO( :, 4, 6, 7) = (/&
&1.1453E-03_JPRB,1.3423E-03_JPRB,1.3852E-03_JPRB,1.3677E-03_JPRB,1.3077E-03_JPRB,1.2097E-03_JPRB,&
&1.0767E-03_JPRB,8.5645E-04_JPRB,4.6653E-04_JPRB/)
KAO( :, 5, 6, 7) = (/&
&1.4081E-03_JPRB,1.6785E-03_JPRB,1.7408E-03_JPRB,1.7212E-03_JPRB,1.6525E-03_JPRB,1.5502E-03_JPRB,&
&1.4183E-03_JPRB,1.2157E-03_JPRB,5.9973E-04_JPRB/)
KAO( :, 1, 7, 7) = (/&
&3.7120E-04_JPRB,4.2080E-04_JPRB,4.2477E-04_JPRB,4.0604E-04_JPRB,3.6355E-04_JPRB,3.1468E-04_JPRB,&
&2.7452E-04_JPRB,3.0003E-04_JPRB,3.4329E-04_JPRB/)
KAO( :, 2, 7, 7) = (/&
&5.0811E-04_JPRB,5.8113E-04_JPRB,5.8975E-04_JPRB,5.7433E-04_JPRB,5.3282E-04_JPRB,4.5716E-04_JPRB,&
&3.8591E-04_JPRB,3.1558E-04_JPRB,3.8021E-04_JPRB/)
KAO( :, 3, 7, 7) = (/&
&6.7189E-04_JPRB,7.7708E-04_JPRB,7.9243E-04_JPRB,7.7528E-04_JPRB,7.3224E-04_JPRB,6.5998E-04_JPRB,&
&5.4384E-04_JPRB,5.0808E-04_JPRB,4.2510E-04_JPRB/)
KAO( :, 4, 7, 7) = (/&
&8.6172E-04_JPRB,1.0111E-03_JPRB,1.0357E-03_JPRB,1.0171E-03_JPRB,9.6771E-04_JPRB,8.8863E-04_JPRB,&
&7.7053E-04_JPRB,5.9901E-04_JPRB,4.8327E-04_JPRB/)
KAO( :, 5, 7, 7) = (/&
&1.0762E-03_JPRB,1.2838E-03_JPRB,1.3208E-03_JPRB,1.3007E-03_JPRB,1.2428E-03_JPRB,1.1566E-03_JPRB,&
&1.0378E-03_JPRB,8.6101E-04_JPRB,5.6256E-04_JPRB/)
KAO( :, 1, 8, 7) = (/&
&2.6005E-04_JPRB,2.9445E-04_JPRB,2.9544E-04_JPRB,2.7954E-04_JPRB,2.4583E-04_JPRB,2.1647E-04_JPRB,&
&1.8002E-04_JPRB,2.3598E-04_JPRB,7.9092E-04_JPRB/)
KAO( :, 2, 8, 7) = (/&
&3.6459E-04_JPRB,4.1637E-04_JPRB,4.2010E-04_JPRB,4.0556E-04_JPRB,3.7047E-04_JPRB,3.0940E-04_JPRB,&
&2.7524E-04_JPRB,2.5435E-04_JPRB,8.3476E-04_JPRB/)
KAO( :, 3, 8, 7) = (/&
&4.9221E-04_JPRB,5.6877E-04_JPRB,5.7633E-04_JPRB,5.6089E-04_JPRB,5.2598E-04_JPRB,4.6466E-04_JPRB,&
&3.7776E-04_JPRB,3.4121E-04_JPRB,8.7965E-04_JPRB/)
KAO( :, 4, 8, 7) = (/&
&6.4351E-04_JPRB,7.5336E-04_JPRB,7.6684E-04_JPRB,7.4955E-04_JPRB,7.0992E-04_JPRB,6.4867E-04_JPRB,&
&5.4671E-04_JPRB,4.4943E-04_JPRB,9.3048E-04_JPRB/)
KAO( :, 5, 8, 7) = (/&
&8.1696E-04_JPRB,9.7167E-04_JPRB,9.9275E-04_JPRB,9.7485E-04_JPRB,9.2841E-04_JPRB,8.5440E-04_JPRB,&
&7.5642E-04_JPRB,5.9342E-04_JPRB,9.8996E-04_JPRB/)
KAO( :, 1, 9, 7) = (/&
&1.8087E-04_JPRB,2.0393E-04_JPRB,2.0319E-04_JPRB,1.8996E-04_JPRB,1.6599E-04_JPRB,1.4845E-04_JPRB,&
&1.4517E-04_JPRB,1.8943E-04_JPRB,3.7840E-03_JPRB/)
KAO( :, 2, 9, 7) = (/&
&2.5947E-04_JPRB,2.9518E-04_JPRB,2.9598E-04_JPRB,2.8323E-04_JPRB,2.5237E-04_JPRB,2.1334E-04_JPRB,&
&1.9297E-04_JPRB,2.0265E-04_JPRB,3.8746E-03_JPRB/)
KAO( :, 3, 9, 7) = (/&
&3.5788E-04_JPRB,4.1170E-04_JPRB,4.1507E-04_JPRB,4.0085E-04_JPRB,3.7117E-04_JPRB,3.1718E-04_JPRB,&
&2.6164E-04_JPRB,2.2715E-04_JPRB,3.9645E-03_JPRB/)
KAO( :, 4, 9, 7) = (/&
&4.7699E-04_JPRB,5.5569E-04_JPRB,5.6204E-04_JPRB,5.4699E-04_JPRB,5.1526E-04_JPRB,4.6408E-04_JPRB,&
&3.7784E-04_JPRB,3.4199E-04_JPRB,4.0560E-03_JPRB/)
KAO( :, 5, 9, 7) = (/&
&6.1621E-04_JPRB,7.2836E-04_JPRB,7.3953E-04_JPRB,7.2389E-04_JPRB,6.8675E-04_JPRB,6.2690E-04_JPRB,&
&5.4244E-04_JPRB,4.1506E-04_JPRB,4.1481E-03_JPRB/)
KAO( :, 1,10, 7) = (/&
&1.3094E-04_JPRB,1.4617E-04_JPRB,1.4409E-04_JPRB,1.3166E-04_JPRB,1.1671E-04_JPRB,1.0840E-04_JPRB,&
&1.1994E-04_JPRB,1.5334E-04_JPRB,2.4678E-02_JPRB/)
KAO( :, 2,10, 7) = (/&
&1.9036E-04_JPRB,2.1493E-04_JPRB,2.1399E-04_JPRB,2.0239E-04_JPRB,1.7779E-04_JPRB,1.5202E-04_JPRB,&
&1.3461E-04_JPRB,1.6391E-04_JPRB,2.4818E-02_JPRB/)
KAO( :, 3,10, 7) = (/&
&2.6670E-04_JPRB,3.0451E-04_JPRB,3.0518E-04_JPRB,2.9252E-04_JPRB,2.6713E-04_JPRB,2.2545E-04_JPRB,&
&1.9430E-04_JPRB,1.7654E-04_JPRB,2.4944E-02_JPRB/)
KAO( :, 4,10, 7) = (/&
&3.6077E-04_JPRB,4.1729E-04_JPRB,4.1982E-04_JPRB,4.0619E-04_JPRB,3.7979E-04_JPRB,3.3605E-04_JPRB,&
&2.6665E-04_JPRB,2.5064E-04_JPRB,2.5043E-02_JPRB/)
KAO( :, 5,10, 7) = (/&
&4.7368E-04_JPRB,5.5457E-04_JPRB,5.6006E-04_JPRB,5.4560E-04_JPRB,5.1520E-04_JPRB,4.6682E-04_JPRB,&
&3.9587E-04_JPRB,3.0490E-04_JPRB,2.5182E-02_JPRB/)
KAO( :, 1,11, 7) = (/&
&1.1672E-04_JPRB,1.2865E-04_JPRB,1.2575E-04_JPRB,1.1552E-04_JPRB,1.0159E-04_JPRB,9.2164E-05_JPRB,&
&9.9270E-05_JPRB,1.2653E-04_JPRB,5.7559E-02_JPRB/)
KAO( :, 2,11, 7) = (/&
&1.6732E-04_JPRB,1.8741E-04_JPRB,1.8550E-04_JPRB,1.7442E-04_JPRB,1.5354E-04_JPRB,1.3133E-04_JPRB,&
&1.1767E-04_JPRB,1.4329E-04_JPRB,5.7684E-02_JPRB/)
KAO( :, 3,11, 7) = (/&
&2.3276E-04_JPRB,2.6444E-04_JPRB,2.6342E-04_JPRB,2.5118E-04_JPRB,2.2884E-04_JPRB,1.9264E-04_JPRB,&
&1.6524E-04_JPRB,1.4558E-04_JPRB,5.7855E-02_JPRB/)
KAO( :, 4,11, 7) = (/&
&3.1443E-04_JPRB,3.6154E-04_JPRB,3.6203E-04_JPRB,3.4857E-04_JPRB,3.2499E-04_JPRB,2.8713E-04_JPRB,&
&2.2934E-04_JPRB,2.1182E-04_JPRB,5.7981E-02_JPRB/)
KAO( :, 5,11, 7) = (/&
&4.1392E-04_JPRB,4.8111E-04_JPRB,4.8318E-04_JPRB,4.6852E-04_JPRB,4.4073E-04_JPRB,3.9804E-04_JPRB,&
&3.3719E-04_JPRB,2.5664E-04_JPRB,5.8015E-02_JPRB/)
KAO( :, 1,12, 7) = (/&
&1.0495E-04_JPRB,1.1425E-04_JPRB,1.1065E-04_JPRB,1.0139E-04_JPRB,8.8702E-05_JPRB,8.0270E-05_JPRB,&
&8.3227E-05_JPRB,1.1035E-04_JPRB,8.4777E-02_JPRB/)
KAO( :, 2,12, 7) = (/&
&1.4811E-04_JPRB,1.6444E-04_JPRB,1.6133E-04_JPRB,1.5088E-04_JPRB,1.3304E-04_JPRB,1.1329E-04_JPRB,&
&1.0211E-04_JPRB,1.1814E-04_JPRB,8.5052E-02_JPRB/)
KAO( :, 3,12, 7) = (/&
&2.0461E-04_JPRB,2.3053E-04_JPRB,2.2799E-04_JPRB,2.1647E-04_JPRB,1.9655E-04_JPRB,1.6510E-04_JPRB,&
&1.3813E-04_JPRB,1.2052E-04_JPRB,8.5320E-02_JPRB/)
KAO( :, 4,12, 7) = (/&
&2.7614E-04_JPRB,3.1483E-04_JPRB,3.1311E-04_JPRB,3.0005E-04_JPRB,2.7866E-04_JPRB,2.4569E-04_JPRB,&
&1.9595E-04_JPRB,1.7650E-04_JPRB,8.5551E-02_JPRB/)
KAO( :, 5,12, 7) = (/&
&3.6369E-04_JPRB,4.1945E-04_JPRB,4.1876E-04_JPRB,4.0374E-04_JPRB,3.7792E-04_JPRB,3.3990E-04_JPRB,&
&2.8821E-04_JPRB,2.1660E-04_JPRB,8.5586E-02_JPRB/)
KAO( :, 1,13, 7) = (/&
&9.6451E-05_JPRB,1.0341E-04_JPRB,9.9264E-05_JPRB,9.0436E-05_JPRB,7.8283E-05_JPRB,7.1353E-05_JPRB,&
&7.0038E-05_JPRB,8.7127E-05_JPRB,1.0017E-01_JPRB/)
KAO( :, 2,13, 7) = (/&
&1.3353E-04_JPRB,1.4634E-04_JPRB,1.4212E-04_JPRB,1.3211E-04_JPRB,1.1628E-04_JPRB,9.7846E-05_JPRB,&
&8.8593E-05_JPRB,9.9520E-05_JPRB,1.0066E-01_JPRB/)
KAO( :, 3,13, 7) = (/&
&1.8247E-04_JPRB,2.0319E-04_JPRB,1.9922E-04_JPRB,1.8770E-04_JPRB,1.6984E-04_JPRB,1.4285E-04_JPRB,&
&1.1822E-04_JPRB,1.0096E-04_JPRB,1.0114E-01_JPRB/)
KAO( :, 4,13, 7) = (/&
&2.4463E-04_JPRB,2.7635E-04_JPRB,2.7262E-04_JPRB,2.5991E-04_JPRB,2.4023E-04_JPRB,2.1109E-04_JPRB,&
&1.6739E-04_JPRB,1.4711E-04_JPRB,1.0151E-01_JPRB/)
KAO( :, 5,13, 7) = (/&
&3.2023E-04_JPRB,3.6781E-04_JPRB,3.6463E-04_JPRB,3.4949E-04_JPRB,3.2644E-04_JPRB,2.9244E-04_JPRB,&
&2.4737E-04_JPRB,1.8188E-04_JPRB,1.0162E-01_JPRB/)
KAO( :, 1, 1, 8) = (/&
&4.4239E-03_JPRB,4.5519E-03_JPRB,4.5724E-03_JPRB,4.4178E-03_JPRB,4.2198E-03_JPRB,4.0058E-03_JPRB,&
&3.6615E-03_JPRB,3.0019E-03_JPRB,2.7752E-03_JPRB/)
KAO( :, 2, 1, 8) = (/&
&5.3797E-03_JPRB,5.6034E-03_JPRB,5.6810E-03_JPRB,5.5458E-03_JPRB,5.3768E-03_JPRB,5.2131E-03_JPRB,&
&5.0349E-03_JPRB,4.6587E-03_JPRB,3.8056E-03_JPRB/)
KAO( :, 3, 1, 8) = (/&
&6.4347E-03_JPRB,6.7859E-03_JPRB,6.9273E-03_JPRB,6.8482E-03_JPRB,6.7118E-03_JPRB,6.6177E-03_JPRB,&
&6.6013E-03_JPRB,6.5225E-03_JPRB,5.0401E-03_JPRB/)
KAO( :, 4, 1, 8) = (/&
&7.5645E-03_JPRB,8.0892E-03_JPRB,8.3352E-03_JPRB,8.3083E-03_JPRB,8.2560E-03_JPRB,8.2611E-03_JPRB,&
&8.3847E-03_JPRB,8.5252E-03_JPRB,6.4996E-03_JPRB/)
KAO( :, 5, 1, 8) = (/&
&8.7680E-03_JPRB,9.5130E-03_JPRB,9.8898E-03_JPRB,9.9473E-03_JPRB,1.0011E-02_JPRB,1.0143E-02_JPRB,&
&1.0425E-02_JPRB,1.0769E-02_JPRB,8.2076E-03_JPRB/)
KAO( :, 1, 2, 8) = (/&
&3.8956E-03_JPRB,4.0502E-03_JPRB,4.0603E-03_JPRB,3.9353E-03_JPRB,3.7465E-03_JPRB,3.4739E-03_JPRB,&
&3.0905E-03_JPRB,2.3943E-03_JPRB,2.1184E-03_JPRB/)
KAO( :, 2, 2, 8) = (/&
&4.7918E-03_JPRB,5.0484E-03_JPRB,5.0971E-03_JPRB,4.9960E-03_JPRB,4.7901E-03_JPRB,4.5311E-03_JPRB,&
&4.2459E-03_JPRB,3.8455E-03_JPRB,2.9268E-03_JPRB/)
KAO( :, 3, 2, 8) = (/&
&5.7854E-03_JPRB,6.1757E-03_JPRB,6.2838E-03_JPRB,6.2127E-03_JPRB,6.0071E-03_JPRB,5.7828E-03_JPRB,&
&5.6083E-03_JPRB,5.4427E-03_JPRB,3.9021E-03_JPRB/)
KAO( :, 4, 2, 8) = (/&
&6.8580E-03_JPRB,7.4217E-03_JPRB,7.6327E-03_JPRB,7.5901E-03_JPRB,7.4062E-03_JPRB,7.2358E-03_JPRB,&
&7.1625E-03_JPRB,7.2397E-03_JPRB,5.0676E-03_JPRB/)
KAO( :, 5, 2, 8) = (/&
&8.0102E-03_JPRB,8.7860E-03_JPRB,9.1257E-03_JPRB,9.1299E-03_JPRB,8.9977E-03_JPRB,8.9056E-03_JPRB,&
&8.9466E-03_JPRB,9.2132E-03_JPRB,6.4234E-03_JPRB/)
KAO( :, 1, 3, 8) = (/&
&3.2185E-03_JPRB,3.3667E-03_JPRB,3.3683E-03_JPRB,3.2709E-03_JPRB,3.1158E-03_JPRB,2.8506E-03_JPRB,&
&2.4272E-03_JPRB,1.7393E-03_JPRB,1.4905E-03_JPRB/)
KAO( :, 2, 3, 8) = (/&
&4.0272E-03_JPRB,4.2617E-03_JPRB,4.2966E-03_JPRB,4.2148E-03_JPRB,4.0495E-03_JPRB,3.7679E-03_JPRB,&
&3.4096E-03_JPRB,2.8817E-03_JPRB,2.0706E-03_JPRB/)
KAO( :, 3, 3, 8) = (/&
&4.9255E-03_JPRB,5.2838E-03_JPRB,5.3750E-03_JPRB,5.3109E-03_JPRB,5.1338E-03_JPRB,4.8398E-03_JPRB,&
&4.5501E-03_JPRB,4.1909E-03_JPRB,2.7937E-03_JPRB/)
KAO( :, 4, 3, 8) = (/&
&5.9079E-03_JPRB,6.4325E-03_JPRB,6.6107E-03_JPRB,6.5630E-03_JPRB,6.3820E-03_JPRB,6.0909E-03_JPRB,&
&5.8611E-03_JPRB,5.7562E-03_JPRB,3.6692E-03_JPRB/)
KAO( :, 5, 3, 8) = (/&
&6.9696E-03_JPRB,7.6975E-03_JPRB,7.9877E-03_JPRB,7.9811E-03_JPRB,7.8040E-03_JPRB,7.5290E-03_JPRB,&
&7.3615E-03_JPRB,7.4650E-03_JPRB,4.7053E-03_JPRB/)
KAO( :, 1, 4, 8) = (/&
&2.5545E-03_JPRB,2.6859E-03_JPRB,2.6880E-03_JPRB,2.6203E-03_JPRB,2.4823E-03_JPRB,2.2588E-03_JPRB,&
&1.8322E-03_JPRB,1.2713E-03_JPRB,1.0214E-03_JPRB/)
KAO( :, 2, 4, 8) = (/&
&3.2572E-03_JPRB,3.4677E-03_JPRB,3.4957E-03_JPRB,3.4378E-03_JPRB,3.2931E-03_JPRB,3.0601E-03_JPRB,&
&2.6717E-03_JPRB,2.0170E-03_JPRB,1.4352E-03_JPRB/)
KAO( :, 3, 4, 8) = (/&
&4.0447E-03_JPRB,4.3684E-03_JPRB,4.4456E-03_JPRB,4.3951E-03_JPRB,4.2405E-03_JPRB,3.9923E-03_JPRB,&
&3.6333E-03_JPRB,3.0944E-03_JPRB,1.9579E-03_JPRB/)
KAO( :, 4, 4, 8) = (/&
&4.9198E-03_JPRB,5.3921E-03_JPRB,5.5389E-03_JPRB,5.5062E-03_JPRB,5.3434E-03_JPRB,5.0807E-03_JPRB,&
&4.7402E-03_JPRB,4.4587E-03_JPRB,2.6028E-03_JPRB/)
KAO( :, 5, 4, 8) = (/&
&5.8819E-03_JPRB,6.5317E-03_JPRB,6.7822E-03_JPRB,6.7765E-03_JPRB,6.6162E-03_JPRB,6.3253E-03_JPRB,&
&5.9954E-03_JPRB,5.8840E-03_JPRB,3.3755E-03_JPRB/)
KAO( :, 1, 5, 8) = (/&
&1.9756E-03_JPRB,2.0856E-03_JPRB,2.0921E-03_JPRB,2.0392E-03_JPRB,1.9309E-03_JPRB,1.7377E-03_JPRB,&
&1.3394E-03_JPRB,9.1353E-04_JPRB,7.0438E-04_JPRB/)
KAO( :, 2, 5, 8) = (/&
&2.5687E-03_JPRB,2.7468E-03_JPRB,2.7774E-03_JPRB,2.7346E-03_JPRB,2.6141E-03_JPRB,2.4178E-03_JPRB,&
&2.0843E-03_JPRB,1.3471E-03_JPRB,9.9854E-04_JPRB/)
KAO( :, 3, 5, 8) = (/&
&3.2454E-03_JPRB,3.5226E-03_JPRB,3.5942E-03_JPRB,3.5589E-03_JPRB,3.4246E-03_JPRB,3.2139E-03_JPRB,&
&2.8968E-03_JPRB,2.2808E-03_JPRB,1.3756E-03_JPRB/)
KAO( :, 4, 5, 8) = (/&
&4.0078E-03_JPRB,4.4135E-03_JPRB,4.5464E-03_JPRB,4.5227E-03_JPRB,4.3801E-03_JPRB,4.1565E-03_JPRB,&
&3.8227E-03_JPRB,3.4129E-03_JPRB,1.8460E-03_JPRB/)
KAO( :, 5, 5, 8) = (/&
&4.8571E-03_JPRB,5.4208E-03_JPRB,5.6379E-03_JPRB,5.6316E-03_JPRB,5.4908E-03_JPRB,5.2408E-03_JPRB,&
&4.8842E-03_JPRB,4.5932E-03_JPRB,2.4240E-03_JPRB/)
KAO( :, 1, 6, 8) = (/&
&1.4751E-03_JPRB,1.5649E-03_JPRB,1.5698E-03_JPRB,1.5250E-03_JPRB,1.4367E-03_JPRB,1.2692E-03_JPRB,&
&9.2432E-04_JPRB,6.8601E-04_JPRB,5.0937E-04_JPRB/)
KAO( :, 2, 6, 8) = (/&
&1.9613E-03_JPRB,2.1071E-03_JPRB,2.1348E-03_JPRB,2.0943E-03_JPRB,1.9976E-03_JPRB,1.8330E-03_JPRB,&
&1.5334E-03_JPRB,9.4512E-04_JPRB,7.0634E-04_JPRB/)
KAO( :, 3, 6, 8) = (/&
&2.5283E-03_JPRB,2.7572E-03_JPRB,2.8184E-03_JPRB,2.7830E-03_JPRB,2.6756E-03_JPRB,2.5003E-03_JPRB,&
&2.2237E-03_JPRB,1.6320E-03_JPRB,9.7275E-04_JPRB/)
KAO( :, 4, 6, 8) = (/&
&3.1771E-03_JPRB,3.5120E-03_JPRB,3.6225E-03_JPRB,3.5959E-03_JPRB,3.4819E-03_JPRB,3.2887E-03_JPRB,&
&3.0155E-03_JPRB,2.5468E-03_JPRB,1.3152E-03_JPRB/)
KAO( :, 5, 6, 8) = (/&
&3.9082E-03_JPRB,4.3796E-03_JPRB,4.5491E-03_JPRB,4.5475E-03_JPRB,4.4280E-03_JPRB,4.2073E-03_JPRB,&
&3.9106E-03_JPRB,3.5240E-03_JPRB,1.7410E-03_JPRB/)
KAO( :, 1, 7, 8) = (/&
&1.0756E-03_JPRB,1.1457E-03_JPRB,1.1474E-03_JPRB,1.1092E-03_JPRB,1.0328E-03_JPRB,8.8328E-04_JPRB,&
&6.4847E-04_JPRB,4.9589E-04_JPRB,5.7093E-04_JPRB/)
KAO( :, 2, 7, 8) = (/&
&1.4649E-03_JPRB,1.5820E-03_JPRB,1.5990E-03_JPRB,1.5629E-03_JPRB,1.4809E-03_JPRB,1.3423E-03_JPRB,&
&1.0733E-03_JPRB,6.5945E-04_JPRB,6.7059E-04_JPRB/)
KAO( :, 3, 7, 8) = (/&
&1.9283E-03_JPRB,2.1130E-03_JPRB,2.1564E-03_JPRB,2.1214E-03_JPRB,2.0320E-03_JPRB,1.8875E-03_JPRB,&
&1.6475E-03_JPRB,1.0998E-03_JPRB,8.2028E-04_JPRB/)
KAO( :, 4, 7, 8) = (/&
&2.4693E-03_JPRB,2.7409E-03_JPRB,2.8220E-03_JPRB,2.7928E-03_JPRB,2.6936E-03_JPRB,2.5390E-03_JPRB,&
&2.3115E-03_JPRB,1.8751E-03_JPRB,1.0332E-03_JPRB/)
KAO( :, 5, 7, 8) = (/&
&3.0886E-03_JPRB,3.4749E-03_JPRB,3.5989E-03_JPRB,3.5853E-03_JPRB,3.4794E-03_JPRB,3.3014E-03_JPRB,&
&3.0555E-03_JPRB,2.6855E-03_JPRB,1.3202E-03_JPRB/)
KAO( :, 1, 8, 8) = (/&
&7.7013E-04_JPRB,8.2269E-04_JPRB,8.2096E-04_JPRB,7.8766E-04_JPRB,7.2051E-04_JPRB,5.9734E-04_JPRB,&
&4.5221E-04_JPRB,3.6815E-04_JPRB,1.2465E-03_JPRB/)
KAO( :, 2, 8, 8) = (/&
&1.0761E-03_JPRB,1.1666E-03_JPRB,1.1753E-03_JPRB,1.1418E-03_JPRB,1.0747E-03_JPRB,9.5486E-04_JPRB,&
&7.2722E-04_JPRB,4.9024E-04_JPRB,1.3265E-03_JPRB/)
KAO( :, 3, 8, 8) = (/&
&1.4486E-03_JPRB,1.5933E-03_JPRB,1.6206E-03_JPRB,1.5872E-03_JPRB,1.5112E-03_JPRB,1.3931E-03_JPRB,&
&1.1791E-03_JPRB,7.7032E-04_JPRB,1.4183E-03_JPRB/)
KAO( :, 4, 8, 8) = (/&
&1.8914E-03_JPRB,2.1096E-03_JPRB,2.1595E-03_JPRB,2.1285E-03_JPRB,2.0449E-03_JPRB,1.9150E-03_JPRB,&
&1.7248E-03_JPRB,1.3234E-03_JPRB,1.5297E-03_JPRB/)
KAO( :, 5, 8, 8) = (/&
&2.4078E-03_JPRB,2.7196E-03_JPRB,2.8008E-03_JPRB,2.7757E-03_JPRB,2.6827E-03_JPRB,2.5404E-03_JPRB,&
&2.3451E-03_JPRB,2.0264E-03_JPRB,1.6770E-03_JPRB/)
KAO( :, 1, 9, 8) = (/&
&5.4062E-04_JPRB,5.7894E-04_JPRB,5.7406E-04_JPRB,5.4447E-04_JPRB,4.8698E-04_JPRB,3.9028E-04_JPRB,&
&3.0735E-04_JPRB,2.8186E-04_JPRB,6.3377E-03_JPRB/)
KAO( :, 2, 9, 8) = (/&
&7.7655E-04_JPRB,8.4391E-04_JPRB,8.4599E-04_JPRB,8.1629E-04_JPRB,7.6016E-04_JPRB,6.5450E-04_JPRB,&
&4.7980E-04_JPRB,3.6416E-04_JPRB,6.4305E-03_JPRB/)
KAO( :, 3, 9, 8) = (/&
&1.0705E-03_JPRB,1.1799E-03_JPRB,1.1936E-03_JPRB,1.1638E-03_JPRB,1.1017E-03_JPRB,1.0023E-03_JPRB,&
&8.1517E-04_JPRB,5.4679E-04_JPRB,6.5495E-03_JPRB/)
KAO( :, 4, 9, 8) = (/&
&1.4270E-03_JPRB,1.5951E-03_JPRB,1.6232E-03_JPRB,1.5910E-03_JPRB,1.5219E-03_JPRB,1.4168E-03_JPRB,&
&1.2519E-03_JPRB,8.7875E-04_JPRB,6.6729E-03_JPRB/)
KAO( :, 5, 9, 8) = (/&
&1.8505E-03_JPRB,2.0950E-03_JPRB,2.1415E-03_JPRB,2.1108E-03_JPRB,2.0308E-03_JPRB,1.9153E-03_JPRB,&
&1.7561E-03_JPRB,1.4678E-03_JPRB,6.8190E-03_JPRB/)
KAO( :, 1,10, 8) = (/&
&3.8585E-04_JPRB,4.1375E-04_JPRB,4.0806E-04_JPRB,3.8295E-04_JPRB,3.3374E-04_JPRB,2.6302E-04_JPRB,&
&2.1519E-04_JPRB,2.1943E-04_JPRB,4.4307E-02_JPRB/)
KAO( :, 2,10, 8) = (/&
&5.6783E-04_JPRB,6.1776E-04_JPRB,6.1659E-04_JPRB,5.9118E-04_JPRB,5.4276E-04_JPRB,4.5386E-04_JPRB,&
&3.3714E-04_JPRB,2.8172E-04_JPRB,4.4039E-02_JPRB/)
KAO( :, 3,10, 8) = (/&
&7.9994E-04_JPRB,8.8269E-04_JPRB,8.8820E-04_JPRB,8.6201E-04_JPRB,8.1182E-04_JPRB,7.2562E-04_JPRB,&
&5.6386E-04_JPRB,3.8153E-04_JPRB,4.3887E-02_JPRB/)
KAO( :, 4,10, 8) = (/&
&1.0873E-03_JPRB,1.2167E-03_JPRB,1.2305E-03_JPRB,1.2016E-03_JPRB,1.1439E-03_JPRB,1.0569E-03_JPRB,&
&9.1489E-04_JPRB,6.0012E-04_JPRB,4.3695E-02_JPRB/)
KAO( :, 5,10, 8) = (/&
&1.4329E-03_JPRB,1.6260E-03_JPRB,1.6511E-03_JPRB,1.6186E-03_JPRB,1.5509E-03_JPRB,1.4549E-03_JPRB,&
&1.3198E-03_JPRB,1.0619E-03_JPRB,4.3454E-02_JPRB/)
KAO( :, 1,11, 8) = (/&
&3.3331E-04_JPRB,3.5859E-04_JPRB,3.5347E-04_JPRB,3.3213E-04_JPRB,2.8916E-04_JPRB,2.2877E-04_JPRB,&
&1.7900E-04_JPRB,1.9967E-04_JPRB,1.0878E-01_JPRB/)
KAO( :, 2,11, 8) = (/&
&4.9047E-04_JPRB,5.3552E-04_JPRB,5.3381E-04_JPRB,5.1299E-04_JPRB,4.7115E-04_JPRB,3.9388E-04_JPRB,&
&2.9080E-04_JPRB,2.3623E-04_JPRB,1.0793E-01_JPRB/)
KAO( :, 3,11, 8) = (/&
&6.9278E-04_JPRB,7.6757E-04_JPRB,7.7025E-04_JPRB,7.4755E-04_JPRB,7.0442E-04_JPRB,6.3244E-04_JPRB,&
&4.9501E-04_JPRB,3.3029E-04_JPRB,1.0687E-01_JPRB/)
KAO( :, 4,11, 8) = (/&
&9.4454E-04_JPRB,1.0621E-03_JPRB,1.0699E-03_JPRB,1.0431E-03_JPRB,9.9167E-04_JPRB,9.1658E-04_JPRB,&
&7.9795E-04_JPRB,5.4407E-04_JPRB,1.0586E-01_JPRB/)
KAO( :, 5,11, 8) = (/&
&1.2469E-03_JPRB,1.4253E-03_JPRB,1.4411E-03_JPRB,1.4083E-03_JPRB,1.3458E-03_JPRB,1.2607E-03_JPRB,&
&1.1470E-03_JPRB,9.3092E-04_JPRB,1.0499E-01_JPRB/)
KAO( :, 1,12, 8) = (/&
&2.8868E-04_JPRB,3.1016E-04_JPRB,3.0546E-04_JPRB,2.8704E-04_JPRB,2.5147E-04_JPRB,1.9676E-04_JPRB,&
&1.5529E-04_JPRB,1.6943E-04_JPRB,1.6800E-01_JPRB/)
KAO( :, 2,12, 8) = (/&
&4.2419E-04_JPRB,4.6341E-04_JPRB,4.6115E-04_JPRB,4.4308E-04_JPRB,4.0808E-04_JPRB,3.4351E-04_JPRB,&
&2.4857E-04_JPRB,1.9580E-04_JPRB,1.6656E-01_JPRB/)
KAO( :, 3,12, 8) = (/&
&6.0023E-04_JPRB,6.6617E-04_JPRB,6.6650E-04_JPRB,6.4587E-04_JPRB,6.0783E-04_JPRB,5.4736E-04_JPRB,&
&4.3585E-04_JPRB,2.8774E-04_JPRB,1.6485E-01_JPRB/)
KAO( :, 4,12, 8) = (/&
&8.1906E-04_JPRB,9.2524E-04_JPRB,9.2921E-04_JPRB,9.0286E-04_JPRB,8.5627E-04_JPRB,7.9080E-04_JPRB,&
&6.9052E-04_JPRB,4.8039E-04_JPRB,1.6324E-01_JPRB/)
KAO( :, 5,12, 8) = (/&
&1.0839E-03_JPRB,1.2432E-03_JPRB,1.2546E-03_JPRB,1.2224E-03_JPRB,1.1638E-03_JPRB,1.0874E-03_JPRB,&
&9.8876E-04_JPRB,8.1388E-04_JPRB,1.6195E-01_JPRB/)
KAO( :, 1,13, 8) = (/&
&2.5312E-04_JPRB,2.6982E-04_JPRB,2.6458E-04_JPRB,2.4857E-04_JPRB,2.1806E-04_JPRB,1.7081E-04_JPRB,&
&1.3117E-04_JPRB,1.3895E-04_JPRB,2.0739E-01_JPRB/)
KAO( :, 2,13, 8) = (/&
&3.6904E-04_JPRB,4.0143E-04_JPRB,3.9817E-04_JPRB,3.8186E-04_JPRB,3.5137E-04_JPRB,2.9757E-04_JPRB,&
&2.1658E-04_JPRB,1.6379E-04_JPRB,2.0586E-01_JPRB/)
KAO( :, 3,13, 8) = (/&
&5.2080E-04_JPRB,5.7811E-04_JPRB,5.7661E-04_JPRB,5.5693E-04_JPRB,5.2224E-04_JPRB,4.6985E-04_JPRB,&
&3.7580E-04_JPRB,2.4807E-04_JPRB,2.0409E-01_JPRB/)
KAO( :, 4,13, 8) = (/&
&7.1123E-04_JPRB,8.0344E-04_JPRB,8.0567E-04_JPRB,7.8029E-04_JPRB,7.3718E-04_JPRB,6.7848E-04_JPRB,&
&5.9304E-04_JPRB,4.2232E-04_JPRB,2.0245E-01_JPRB/)
KAO( :, 5,13, 8) = (/&
&9.4485E-04_JPRB,1.0811E-03_JPRB,1.0875E-03_JPRB,1.0578E-03_JPRB,1.0044E-03_JPRB,9.3443E-04_JPRB,&
&8.4723E-04_JPRB,7.0315E-04_JPRB,2.0129E-01_JPRB/)
KAO( :, 1, 1, 9) = (/&
&1.0292E-02_JPRB,1.0074E-02_JPRB,1.0433E-02_JPRB,1.0920E-02_JPRB,1.1239E-02_JPRB,1.1304E-02_JPRB,&
&1.1018E-02_JPRB,9.9412E-03_JPRB,1.0267E-02_JPRB/)
KAO( :, 2, 1, 9) = (/&
&1.2495E-02_JPRB,1.2453E-02_JPRB,1.3049E-02_JPRB,1.3792E-02_JPRB,1.4278E-02_JPRB,1.4496E-02_JPRB,&
&1.4236E-02_JPRB,1.3361E-02_JPRB,1.3925E-02_JPRB/)
KAO( :, 3, 1, 9) = (/&
&1.4859E-02_JPRB,1.5091E-02_JPRB,1.6017E-02_JPRB,1.7045E-02_JPRB,1.7806E-02_JPRB,1.8195E-02_JPRB,&
&1.7952E-02_JPRB,1.7365E-02_JPRB,1.8464E-02_JPRB/)
KAO( :, 4, 1, 9) = (/&
&1.7363E-02_JPRB,1.7942E-02_JPRB,1.9281E-02_JPRB,2.0718E-02_JPRB,2.1801E-02_JPRB,2.2424E-02_JPRB,&
&2.2300E-02_JPRB,2.2092E-02_JPRB,2.3948E-02_JPRB/)
KAO( :, 5, 1, 9) = (/&
&1.9984E-02_JPRB,2.1018E-02_JPRB,2.2868E-02_JPRB,2.4808E-02_JPRB,2.6324E-02_JPRB,2.7242E-02_JPRB,&
&2.7276E-02_JPRB,2.7701E-02_JPRB,3.0488E-02_JPRB/)
KAO( :, 1, 2, 9) = (/&
&9.5128E-03_JPRB,9.2867E-03_JPRB,9.5490E-03_JPRB,9.8633E-03_JPRB,1.0027E-02_JPRB,1.0058E-02_JPRB,&
&9.7636E-03_JPRB,8.7994E-03_JPRB,8.5570E-03_JPRB/)
KAO( :, 2, 2, 9) = (/&
&1.1668E-02_JPRB,1.1584E-02_JPRB,1.2077E-02_JPRB,1.2559E-02_JPRB,1.2920E-02_JPRB,1.3060E-02_JPRB,&
&1.2825E-02_JPRB,1.1983E-02_JPRB,1.1751E-02_JPRB/)
KAO( :, 3, 2, 9) = (/&
&1.4011E-02_JPRB,1.4151E-02_JPRB,1.4940E-02_JPRB,1.5660E-02_JPRB,1.6284E-02_JPRB,1.6579E-02_JPRB,&
&1.6367E-02_JPRB,1.5804E-02_JPRB,1.5742E-02_JPRB/)
KAO( :, 4, 2, 9) = (/&
&1.6508E-02_JPRB,1.6961E-02_JPRB,1.8102E-02_JPRB,1.9197E-02_JPRB,2.0137E-02_JPRB,2.0668E-02_JPRB,&
&2.0505E-02_JPRB,2.0318E-02_JPRB,2.0610E-02_JPRB/)
KAO( :, 5, 2, 9) = (/&
&1.9122E-02_JPRB,2.0006E-02_JPRB,2.1590E-02_JPRB,2.3174E-02_JPRB,2.4520E-02_JPRB,2.5288E-02_JPRB,&
&2.5261E-02_JPRB,2.5631E-02_JPRB,2.6467E-02_JPRB/)
KAO( :, 1, 3, 9) = (/&
&8.4316E-03_JPRB,8.1842E-03_JPRB,8.3414E-03_JPRB,8.4601E-03_JPRB,8.4527E-03_JPRB,8.3467E-03_JPRB,&
&8.0420E-03_JPRB,7.1142E-03_JPRB,6.5461E-03_JPRB/)
KAO( :, 2, 3, 9) = (/&
&1.0508E-02_JPRB,1.0365E-02_JPRB,1.0700E-02_JPRB,1.0941E-02_JPRB,1.1049E-02_JPRB,1.1031E-02_JPRB,&
&1.0751E-02_JPRB,9.9386E-03_JPRB,9.1449E-03_JPRB/)
KAO( :, 3, 3, 9) = (/&
&1.2785E-02_JPRB,1.2829E-02_JPRB,1.3389E-02_JPRB,1.3825E-02_JPRB,1.4105E-02_JPRB,1.4232E-02_JPRB,&
&1.3991E-02_JPRB,1.3420E-02_JPRB,1.2428E-02_JPRB/)
KAO( :, 4, 3, 9) = (/&
&1.5245E-02_JPRB,1.5545E-02_JPRB,1.6390E-02_JPRB,1.7132E-02_JPRB,1.7666E-02_JPRB,1.7977E-02_JPRB,&
&1.7716E-02_JPRB,1.7486E-02_JPRB,1.6472E-02_JPRB/)
KAO( :, 5, 3, 9) = (/&
&1.7859E-02_JPRB,1.8505E-02_JPRB,1.9736E-02_JPRB,2.0852E-02_JPRB,2.1757E-02_JPRB,2.2224E-02_JPRB,&
&2.2056E-02_JPRB,2.2280E-02_JPRB,2.1403E-02_JPRB/)
KAO( :, 1, 4, 9) = (/&
&7.3484E-03_JPRB,7.0902E-03_JPRB,7.1380E-03_JPRB,7.1024E-03_JPRB,6.9776E-03_JPRB,6.7400E-03_JPRB,&
&6.3521E-03_JPRB,5.4673E-03_JPRB,4.8295E-03_JPRB/)
KAO( :, 2, 4, 9) = (/&
&9.3310E-03_JPRB,9.1397E-03_JPRB,9.3159E-03_JPRB,9.3538E-03_JPRB,9.2681E-03_JPRB,9.0554E-03_JPRB,&
&8.7344E-03_JPRB,7.9076E-03_JPRB,6.8828E-03_JPRB/)
KAO( :, 3, 4, 9) = (/&
&1.1534E-02_JPRB,1.1475E-02_JPRB,1.1819E-02_JPRB,1.1988E-02_JPRB,1.2000E-02_JPRB,1.1864E-02_JPRB,&
&1.1575E-02_JPRB,1.0994E-02_JPRB,9.4901E-03_JPRB/)
KAO( :, 4, 4, 9) = (/&
&1.3943E-02_JPRB,1.4087E-02_JPRB,1.4649E-02_JPRB,1.5032E-02_JPRB,1.5214E-02_JPRB,1.5176E-02_JPRB,&
&1.4865E-02_JPRB,1.4524E-02_JPRB,1.2777E-02_JPRB/)
KAO( :, 5, 4, 9) = (/&
&1.6517E-02_JPRB,1.6976E-02_JPRB,1.7827E-02_JPRB,1.8519E-02_JPRB,1.8920E-02_JPRB,1.9000E-02_JPRB,&
&1.8720E-02_JPRB,1.8746E-02_JPRB,1.6804E-02_JPRB/)
KAO( :, 1, 5, 9) = (/&
&6.3624E-03_JPRB,6.1133E-03_JPRB,6.0634E-03_JPRB,5.9330E-03_JPRB,5.7181E-03_JPRB,5.4022E-03_JPRB,&
&4.9483E-03_JPRB,4.1022E-03_JPRB,3.4892E-03_JPRB/)
KAO( :, 2, 5, 9) = (/&
&8.2407E-03_JPRB,8.0303E-03_JPRB,8.0632E-03_JPRB,7.9504E-03_JPRB,7.7253E-03_JPRB,7.3962E-03_JPRB,&
&6.9698E-03_JPRB,6.1767E-03_JPRB,5.0748E-03_JPRB/)
KAO( :, 3, 5, 9) = (/&
&1.0363E-02_JPRB,1.0246E-02_JPRB,1.0387E-02_JPRB,1.0335E-02_JPRB,1.0149E-02_JPRB,9.8386E-03_JPRB,&
&9.4225E-03_JPRB,8.8118E-03_JPRB,7.1402E-03_JPRB/)
KAO( :, 4, 5, 9) = (/&
&1.2695E-02_JPRB,1.2755E-02_JPRB,1.3046E-02_JPRB,1.3138E-02_JPRB,1.3029E-02_JPRB,1.2750E-02_JPRB,&
&1.2327E-02_JPRB,1.1882E-02_JPRB,9.7414E-03_JPRB/)
KAO( :, 5, 5, 9) = (/&
&1.5221E-02_JPRB,1.5544E-02_JPRB,1.6067E-02_JPRB,1.6367E-02_JPRB,1.6363E-02_JPRB,1.6145E-02_JPRB,&
&1.5702E-02_JPRB,1.5530E-02_JPRB,1.2966E-02_JPRB/)
KAO( :, 1, 6, 9) = (/&
&5.3819E-03_JPRB,5.1682E-03_JPRB,5.0489E-03_JPRB,4.8682E-03_JPRB,4.6033E-03_JPRB,4.2570E-03_JPRB,&
&3.7892E-03_JPRB,2.8608E-03_JPRB,2.4512E-03_JPRB/)
KAO( :, 2, 6, 9) = (/&
&7.1280E-03_JPRB,6.9367E-03_JPRB,6.8489E-03_JPRB,6.6487E-03_JPRB,6.3384E-03_JPRB,5.9570E-03_JPRB,&
&5.4784E-03_JPRB,4.6646E-03_JPRB,3.6355E-03_JPRB/)
KAO( :, 3, 6, 9) = (/&
&9.1302E-03_JPRB,9.0145E-03_JPRB,8.9822E-03_JPRB,8.7868E-03_JPRB,8.4616E-03_JPRB,8.0561E-03_JPRB,&
&7.5662E-03_JPRB,6.8605E-03_JPRB,5.2018E-03_JPRB/)
KAO( :, 4, 6, 9) = (/&
&1.1358E-02_JPRB,1.1388E-02_JPRB,1.1456E-02_JPRB,1.1318E-02_JPRB,1.1012E-02_JPRB,1.0595E-02_JPRB,&
&1.0058E-02_JPRB,9.4902E-03_JPRB,7.2223E-03_JPRB/)
KAO( :, 5, 6, 9) = (/&
&1.3798E-02_JPRB,1.4041E-02_JPRB,1.4287E-02_JPRB,1.4257E-02_JPRB,1.3997E-02_JPRB,1.3586E-02_JPRB,&
&1.2991E-02_JPRB,1.2596E-02_JPRB,9.7278E-03_JPRB/)
KAO( :, 1, 7, 9) = (/&
&4.4201E-03_JPRB,4.2655E-03_JPRB,4.1450E-03_JPRB,3.9476E-03_JPRB,3.6722E-03_JPRB,3.3249E-03_JPRB,&
&2.8458E-03_JPRB,1.9671E-03_JPRB,1.7803E-03_JPRB/)
KAO( :, 2, 7, 9) = (/&
&5.9991E-03_JPRB,5.8588E-03_JPRB,5.7556E-03_JPRB,5.5028E-03_JPRB,5.1661E-03_JPRB,4.7702E-03_JPRB,&
&4.2756E-03_JPRB,3.4608E-03_JPRB,2.6084E-03_JPRB/)
KAO( :, 3, 7, 9) = (/&
&7.8395E-03_JPRB,7.7643E-03_JPRB,7.6944E-03_JPRB,7.4017E-03_JPRB,7.0170E-03_JPRB,6.5646E-03_JPRB,&
&6.0423E-03_JPRB,5.2630E-03_JPRB,3.7628E-03_JPRB/)
KAO( :, 4, 7, 9) = (/&
&9.9189E-03_JPRB,9.9815E-03_JPRB,9.9658E-03_JPRB,9.6723E-03_JPRB,9.2685E-03_JPRB,8.7611E-03_JPRB,&
&8.1722E-03_JPRB,7.4723E-03_JPRB,5.2872E-03_JPRB/)
KAO( :, 5, 7, 9) = (/&
&1.2224E-02_JPRB,1.2487E-02_JPRB,1.2587E-02_JPRB,1.2338E-02_JPRB,1.1918E-02_JPRB,1.1379E-02_JPRB,&
&1.0715E-02_JPRB,1.0101E-02_JPRB,7.2253E-03_JPRB/)
KAO( :, 1, 8, 9) = (/&
&3.5350E-03_JPRB,3.4325E-03_JPRB,3.3275E-03_JPRB,3.1605E-03_JPRB,2.8988E-03_JPRB,2.5686E-03_JPRB,&
&2.1091E-03_JPRB,1.2955E-03_JPRB,2.2677E-03_JPRB/)
KAO( :, 2, 8, 9) = (/&
&4.9245E-03_JPRB,4.8341E-03_JPRB,4.7376E-03_JPRB,4.5164E-03_JPRB,4.1844E-03_JPRB,3.7894E-03_JPRB,&
&3.3070E-03_JPRB,2.4762E-03_JPRB,2.6602E-03_JPRB/)
KAO( :, 3, 8, 9) = (/&
&6.5727E-03_JPRB,6.5413E-03_JPRB,6.4715E-03_JPRB,6.1921E-03_JPRB,5.7948E-03_JPRB,5.3290E-03_JPRB,&
&4.7963E-03_JPRB,4.0123E-03_JPRB,3.3053E-03_JPRB/)
KAO( :, 4, 8, 9) = (/&
&8.4673E-03_JPRB,8.5585E-03_JPRB,8.5340E-03_JPRB,8.2251E-03_JPRB,7.7660E-03_JPRB,7.2331E-03_JPRB,&
&6.6181E-03_JPRB,5.8537E-03_JPRB,4.2835E-03_JPRB/)
KAO( :, 5, 8, 9) = (/&
&1.0594E-02_JPRB,1.0877E-02_JPRB,1.0934E-02_JPRB,1.0630E-02_JPRB,1.0118E-02_JPRB,9.5083E-03_JPRB,&
&8.7956E-03_JPRB,8.0306E-03_JPRB,5.6393E-03_JPRB/)
KAO( :, 1, 9, 9) = (/&
&2.7403E-03_JPRB,2.6787E-03_JPRB,2.5973E-03_JPRB,2.4570E-03_JPRB,2.2443E-03_JPRB,1.9562E-03_JPRB,&
&1.5185E-03_JPRB,8.3616E-04_JPRB,1.0274E-02_JPRB/)
KAO( :, 2, 9, 9) = (/&
&3.9274E-03_JPRB,3.8796E-03_JPRB,3.7992E-03_JPRB,3.6140E-03_JPRB,3.3367E-03_JPRB,2.9763E-03_JPRB,&
&2.5173E-03_JPRB,1.7223E-03_JPRB,1.0390E-02_JPRB/)
KAO( :, 3, 9, 9) = (/&
&5.3634E-03_JPRB,5.3721E-03_JPRB,5.3082E-03_JPRB,5.0709E-03_JPRB,4.7250E-03_JPRB,4.2829E-03_JPRB,&
&3.7573E-03_JPRB,2.9940E-03_JPRB,1.0638E-02_JPRB/)
KAO( :, 4, 9, 9) = (/&
&7.0458E-03_JPRB,7.1640E-03_JPRB,7.1301E-03_JPRB,6.8617E-03_JPRB,6.4511E-03_JPRB,5.9118E-03_JPRB,&
&5.2974E-03_JPRB,4.5531E-03_JPRB,1.1091E-02_JPRB/)
KAO( :, 5, 9, 9) = (/&
&8.9617E-03_JPRB,9.2589E-03_JPRB,9.2849E-03_JPRB,9.0088E-03_JPRB,8.5345E-03_JPRB,7.8845E-03_JPRB,&
&7.1544E-03_JPRB,6.3553E-03_JPRB,1.1709E-02_JPRB/)
KAO( :, 1,10, 9) = (/&
&2.1319E-03_JPRB,2.1004E-03_JPRB,2.0372E-03_JPRB,1.9210E-03_JPRB,1.7497E-03_JPRB,1.5111E-03_JPRB,&
&1.1301E-03_JPRB,5.5756E-04_JPRB,7.5283E-02_JPRB/)
KAO( :, 2,10, 9) = (/&
&3.1363E-03_JPRB,3.1212E-03_JPRB,3.0574E-03_JPRB,2.9015E-03_JPRB,2.6722E-03_JPRB,2.3756E-03_JPRB,&
&1.9576E-03_JPRB,1.2195E-03_JPRB,7.4064E-02_JPRB/)
KAO( :, 3,10, 9) = (/&
&4.3731E-03_JPRB,4.4117E-03_JPRB,4.3602E-03_JPRB,4.1608E-03_JPRB,3.8669E-03_JPRB,3.4927E-03_JPRB,&
&3.0050E-03_JPRB,2.2902E-03_JPRB,7.3035E-02_JPRB/)
KAO( :, 4,10, 9) = (/&
&5.8455E-03_JPRB,5.9881E-03_JPRB,5.9565E-03_JPRB,5.7270E-03_JPRB,5.3754E-03_JPRB,4.9035E-03_JPRB,&
&4.3124E-03_JPRB,3.6091E-03_JPRB,7.2537E-02_JPRB/)
KAO( :, 5,10, 9) = (/&
&7.5468E-03_JPRB,7.8566E-03_JPRB,7.8695E-03_JPRB,7.6289E-03_JPRB,7.2133E-03_JPRB,6.6234E-03_JPRB,&
&5.9025E-03_JPRB,5.1322E-03_JPRB,7.2257E-02_JPRB/)
KAO( :, 1,11, 9) = (/&
&1.9745E-03_JPRB,1.9703E-03_JPRB,1.9199E-03_JPRB,1.8121E-03_JPRB,1.6559E-03_JPRB,1.4431E-03_JPRB,&
&1.1163E-03_JPRB,5.3500E-04_JPRB,1.9757E-01_JPRB/)
KAO( :, 2,11, 9) = (/&
&2.8999E-03_JPRB,2.9279E-03_JPRB,2.8819E-03_JPRB,2.7350E-03_JPRB,2.5277E-03_JPRB,2.2543E-03_JPRB,&
&1.8746E-03_JPRB,1.2124E-03_JPRB,1.9384E-01_JPRB/)
KAO( :, 3,11, 9) = (/&
&4.0444E-03_JPRB,4.1420E-03_JPRB,4.1037E-03_JPRB,3.9240E-03_JPRB,3.6578E-03_JPRB,3.3096E-03_JPRB,&
&2.8567E-03_JPRB,2.1998E-03_JPRB,1.9071E-01_JPRB/)
KAO( :, 4,11, 9) = (/&
&5.4085E-03_JPRB,5.6287E-03_JPRB,5.6077E-03_JPRB,5.4059E-03_JPRB,5.0834E-03_JPRB,4.6413E-03_JPRB,&
&4.0709E-03_JPRB,3.3776E-03_JPRB,1.8809E-01_JPRB/)
KAO( :, 5,11, 9) = (/&
&6.9941E-03_JPRB,7.3880E-03_JPRB,7.4108E-03_JPRB,7.2046E-03_JPRB,6.8126E-03_JPRB,6.2573E-03_JPRB,&
&5.5477E-03_JPRB,4.7861E-03_JPRB,1.8600E-01_JPRB/)
KAO( :, 1,12, 9) = (/&
&1.7996E-03_JPRB,1.8206E-03_JPRB,1.7805E-03_JPRB,1.6829E-03_JPRB,1.5433E-03_JPRB,1.3501E-03_JPRB,&
&1.0572E-03_JPRB,5.4808E-04_JPRB,3.2846E-01_JPRB/)
KAO( :, 2,12, 9) = (/&
&2.6426E-03_JPRB,2.7068E-03_JPRB,2.6687E-03_JPRB,2.5393E-03_JPRB,2.3520E-03_JPRB,2.1038E-03_JPRB,&
&1.7678E-03_JPRB,1.1889E-03_JPRB,3.2273E-01_JPRB/)
KAO( :, 3,12, 9) = (/&
&3.6853E-03_JPRB,3.8343E-03_JPRB,3.8028E-03_JPRB,3.6418E-03_JPRB,3.4031E-03_JPRB,3.0855E-03_JPRB,&
&2.6713E-03_JPRB,2.0755E-03_JPRB,3.1779E-01_JPRB/)
KAO( :, 4,12, 9) = (/&
&4.9356E-03_JPRB,5.2142E-03_JPRB,5.1981E-03_JPRB,5.0221E-03_JPRB,4.7252E-03_JPRB,4.3142E-03_JPRB,&
&3.7960E-03_JPRB,3.1444E-03_JPRB,3.1325E-01_JPRB/)
KAO( :, 5,12, 9) = (/&
&6.3947E-03_JPRB,6.8520E-03_JPRB,6.8760E-03_JPRB,6.6872E-03_JPRB,6.3222E-03_JPRB,5.8083E-03_JPRB,&
&5.1616E-03_JPRB,4.4214E-03_JPRB,3.0903E-01_JPRB/)
KAO( :, 1,13, 9) = (/&
&1.6151E-03_JPRB,1.6567E-03_JPRB,1.6234E-03_JPRB,1.5373E-03_JPRB,1.4124E-03_JPRB,1.2394E-03_JPRB,&
&9.8564E-04_JPRB,5.5616E-04_JPRB,4.3871E-01_JPRB/)
KAO( :, 2,13, 9) = (/&
&2.3710E-03_JPRB,2.4678E-03_JPRB,2.4327E-03_JPRB,2.3183E-03_JPRB,2.1495E-03_JPRB,1.9302E-03_JPRB,&
&1.6336E-03_JPRB,1.1398E-03_JPRB,4.3206E-01_JPRB/)
KAO( :, 3,13, 9) = (/&
&3.3121E-03_JPRB,3.4978E-03_JPRB,3.4669E-03_JPRB,3.3267E-03_JPRB,3.1113E-03_JPRB,2.8243E-03_JPRB,&
&2.4585E-03_JPRB,1.9402E-03_JPRB,4.2585E-01_JPRB/)
KAO( :, 4,13, 9) = (/&
&4.4457E-03_JPRB,4.7587E-03_JPRB,4.7468E-03_JPRB,4.5875E-03_JPRB,4.3110E-03_JPRB,3.9394E-03_JPRB,&
&3.4774E-03_JPRB,2.8993E-03_JPRB,4.1993E-01_JPRB/)
KAO( :, 5,13, 9) = (/&
&5.7689E-03_JPRB,6.2589E-03_JPRB,6.2951E-03_JPRB,6.1057E-03_JPRB,5.7619E-03_JPRB,5.2957E-03_JPRB,&
&4.7230E-03_JPRB,4.0528E-03_JPRB,4.1400E-01_JPRB/)
KAO( :, 1, 1,10) = (/&
&2.8341E-02_JPRB,2.4949E-02_JPRB,2.4794E-02_JPRB,2.3987E-02_JPRB,2.3812E-02_JPRB,2.2586E-02_JPRB,&
&2.0187E-02_JPRB,1.9376E-02_JPRB,2.5381E-02_JPRB/)
KAO( :, 2, 1,10) = (/&
&3.3991E-02_JPRB,3.0192E-02_JPRB,3.0574E-02_JPRB,3.0065E-02_JPRB,2.9840E-02_JPRB,2.8013E-02_JPRB,&
&2.5566E-02_JPRB,2.6044E-02_JPRB,3.3447E-02_JPRB/)
KAO( :, 3, 1,10) = (/&
&3.9910E-02_JPRB,3.6271E-02_JPRB,3.6774E-02_JPRB,3.6789E-02_JPRB,3.6160E-02_JPRB,3.4328E-02_JPRB,&
&3.2309E-02_JPRB,3.3900E-02_JPRB,4.2891E-02_JPRB/)
KAO( :, 4, 1,10) = (/&
&4.5950E-02_JPRB,4.3254E-02_JPRB,4.3515E-02_JPRB,4.3816E-02_JPRB,4.3274E-02_JPRB,4.0958E-02_JPRB,&
&3.9828E-02_JPRB,4.3039E-02_JPRB,5.4536E-02_JPRB/)
KAO( :, 5, 1,10) = (/&
&5.2074E-02_JPRB,5.0170E-02_JPRB,5.0735E-02_JPRB,5.1340E-02_JPRB,5.0699E-02_JPRB,4.7916E-02_JPRB,&
&4.9158E-02_JPRB,5.3574E-02_JPRB,6.8520E-02_JPRB/)
KAO( :, 1, 2,10) = (/&
&2.6184E-02_JPRB,2.3296E-02_JPRB,2.3226E-02_JPRB,2.2714E-02_JPRB,2.2514E-02_JPRB,2.1363E-02_JPRB,&
&1.9364E-02_JPRB,1.8250E-02_JPRB,2.2856E-02_JPRB/)
KAO( :, 2, 2,10) = (/&
&3.1743E-02_JPRB,2.8597E-02_JPRB,2.8854E-02_JPRB,2.8835E-02_JPRB,2.8199E-02_JPRB,2.7046E-02_JPRB,&
&2.4544E-02_JPRB,2.4456E-02_JPRB,3.0699E-02_JPRB/)
KAO( :, 3, 2,10) = (/&
&3.7600E-02_JPRB,3.4758E-02_JPRB,3.5112E-02_JPRB,3.5357E-02_JPRB,3.4504E-02_JPRB,3.3441E-02_JPRB,&
&3.1117E-02_JPRB,3.2055E-02_JPRB,4.0509E-02_JPRB/)
KAO( :, 4, 2,10) = (/&
&4.3772E-02_JPRB,4.1496E-02_JPRB,4.2012E-02_JPRB,4.2309E-02_JPRB,4.1696E-02_JPRB,3.9959E-02_JPRB,&
&3.8762E-02_JPRB,4.0415E-02_JPRB,5.2629E-02_JPRB/)
KAO( :, 5, 2,10) = (/&
&5.0069E-02_JPRB,4.8330E-02_JPRB,4.9427E-02_JPRB,4.9767E-02_JPRB,4.9310E-02_JPRB,4.7260E-02_JPRB,&
&4.8222E-02_JPRB,5.0586E-02_JPRB,6.6929E-02_JPRB/)
KAO( :, 1, 3,10) = (/&
&2.2843E-02_JPRB,2.0821E-02_JPRB,2.0350E-02_JPRB,2.0283E-02_JPRB,1.9897E-02_JPRB,1.9120E-02_JPRB,&
&1.7384E-02_JPRB,1.6170E-02_JPRB,1.8446E-02_JPRB/)
KAO( :, 2, 3,10) = (/&
&2.8199E-02_JPRB,2.6062E-02_JPRB,2.5776E-02_JPRB,2.5997E-02_JPRB,2.5440E-02_JPRB,2.4723E-02_JPRB,&
&2.2441E-02_JPRB,2.1717E-02_JPRB,2.5483E-02_JPRB/)
KAO( :, 3, 3,10) = (/&
&3.3953E-02_JPRB,3.1919E-02_JPRB,3.1941E-02_JPRB,3.2157E-02_JPRB,3.1747E-02_JPRB,3.0922E-02_JPRB,&
&2.8559E-02_JPRB,2.8709E-02_JPRB,3.4439E-02_JPRB/)
KAO( :, 4, 3,10) = (/&
&4.0002E-02_JPRB,3.8423E-02_JPRB,3.8902E-02_JPRB,3.8911E-02_JPRB,3.8820E-02_JPRB,3.7594E-02_JPRB,&
&3.6351E-02_JPRB,3.6718E-02_JPRB,4.5775E-02_JPRB/)
KAO( :, 5, 3,10) = (/&
&4.6219E-02_JPRB,4.5155E-02_JPRB,4.6197E-02_JPRB,4.6387E-02_JPRB,4.6153E-02_JPRB,4.5334E-02_JPRB,&
&4.5834E-02_JPRB,4.6534E-02_JPRB,5.9401E-02_JPRB/)
KAO( :, 1, 4,10) = (/&
&1.9312E-02_JPRB,1.7992E-02_JPRB,1.7480E-02_JPRB,1.7446E-02_JPRB,1.7111E-02_JPRB,1.6477E-02_JPRB,&
&1.5243E-02_JPRB,1.3399E-02_JPRB,1.4121E-02_JPRB/)
KAO( :, 2, 4,10) = (/&
&2.4344E-02_JPRB,2.2955E-02_JPRB,2.2617E-02_JPRB,2.2783E-02_JPRB,2.2496E-02_JPRB,2.1867E-02_JPRB,&
&1.9808E-02_JPRB,1.8936E-02_JPRB,1.9938E-02_JPRB/)
KAO( :, 3, 4,10) = (/&
&2.9801E-02_JPRB,2.8523E-02_JPRB,2.8566E-02_JPRB,2.8709E-02_JPRB,2.8682E-02_JPRB,2.7725E-02_JPRB,&
&2.5334E-02_JPRB,2.5284E-02_JPRB,2.7743E-02_JPRB/)
KAO( :, 4, 4,10) = (/&
&3.5620E-02_JPRB,3.4742E-02_JPRB,3.5299E-02_JPRB,3.5308E-02_JPRB,3.5457E-02_JPRB,3.4419E-02_JPRB,&
&3.2604E-02_JPRB,3.3013E-02_JPRB,3.7587E-02_JPRB/)
KAO( :, 5, 4,10) = (/&
&4.1887E-02_JPRB,4.1321E-02_JPRB,4.2274E-02_JPRB,4.2660E-02_JPRB,4.2937E-02_JPRB,4.2081E-02_JPRB,&
&4.1593E-02_JPRB,4.2622E-02_JPRB,4.9653E-02_JPRB/)
KAO( :, 1, 5,10) = (/&
&1.5962E-02_JPRB,1.5091E-02_JPRB,1.4926E-02_JPRB,1.4725E-02_JPRB,1.4471E-02_JPRB,1.4016E-02_JPRB,&
&1.2941E-02_JPRB,1.0781E-02_JPRB,1.0820E-02_JPRB/)
KAO( :, 2, 5,10) = (/&
&2.0561E-02_JPRB,1.9656E-02_JPRB,1.9606E-02_JPRB,1.9723E-02_JPRB,1.9597E-02_JPRB,1.8959E-02_JPRB,&
&1.7070E-02_JPRB,1.5994E-02_JPRB,1.5507E-02_JPRB/)
KAO( :, 3, 5,10) = (/&
&2.5675E-02_JPRB,2.4818E-02_JPRB,2.5196E-02_JPRB,2.5517E-02_JPRB,2.5439E-02_JPRB,2.4412E-02_JPRB,&
&2.1991E-02_JPRB,2.1552E-02_JPRB,2.1888E-02_JPRB/)
KAO( :, 4, 5,10) = (/&
&3.1284E-02_JPRB,3.0688E-02_JPRB,3.1452E-02_JPRB,3.1913E-02_JPRB,3.1938E-02_JPRB,3.0781E-02_JPRB,&
&2.8330E-02_JPRB,2.8796E-02_JPRB,3.0247E-02_JPRB/)
KAO( :, 5, 5,10) = (/&
&3.7244E-02_JPRB,3.7039E-02_JPRB,3.8113E-02_JPRB,3.9041E-02_JPRB,3.9409E-02_JPRB,3.8138E-02_JPRB,&
&3.6567E-02_JPRB,3.7730E-02_JPRB,4.0679E-02_JPRB/)
KAO( :, 1, 6,10) = (/&
&1.2975E-02_JPRB,1.2256E-02_JPRB,1.2340E-02_JPRB,1.2080E-02_JPRB,1.1895E-02_JPRB,1.1506E-02_JPRB,&
&1.0365E-02_JPRB,8.5383E-03_JPRB,8.0172E-03_JPRB/)
KAO( :, 2, 6,10) = (/&
&1.7187E-02_JPRB,1.6321E-02_JPRB,1.6561E-02_JPRB,1.6669E-02_JPRB,1.6611E-02_JPRB,1.5858E-02_JPRB,&
&1.4206E-02_JPRB,1.2638E-02_JPRB,1.1866E-02_JPRB/)
KAO( :, 3, 6,10) = (/&
&2.1950E-02_JPRB,2.1039E-02_JPRB,2.1721E-02_JPRB,2.2100E-02_JPRB,2.1989E-02_JPRB,2.0834E-02_JPRB,&
&1.8607E-02_JPRB,1.7648E-02_JPRB,1.7187E-02_JPRB/)
KAO( :, 4, 6,10) = (/&
&2.7221E-02_JPRB,2.6492E-02_JPRB,2.7582E-02_JPRB,2.8232E-02_JPRB,2.8034E-02_JPRB,2.6720E-02_JPRB,&
&2.4048E-02_JPRB,2.4099E-02_JPRB,2.3975E-02_JPRB/)
KAO( :, 5, 6,10) = (/&
&3.2966E-02_JPRB,3.2596E-02_JPRB,3.4013E-02_JPRB,3.5128E-02_JPRB,3.5174E-02_JPRB,3.3585E-02_JPRB,&
&3.0966E-02_JPRB,3.2147E-02_JPRB,3.2714E-02_JPRB/)
KAO( :, 1, 7,10) = (/&
&1.1003E-02_JPRB,1.0172E-02_JPRB,9.9689E-03_JPRB,9.7030E-03_JPRB,9.5816E-03_JPRB,9.1864E-03_JPRB,&
&8.3157E-03_JPRB,6.5477E-03_JPRB,5.8584E-03_JPRB/)
KAO( :, 2, 7,10) = (/&
&1.4954E-02_JPRB,1.3915E-02_JPRB,1.3705E-02_JPRB,1.3805E-02_JPRB,1.3711E-02_JPRB,1.2918E-02_JPRB,&
&1.1613E-02_JPRB,9.7524E-03_JPRB,8.8921E-03_JPRB/)
KAO( :, 3, 7,10) = (/&
&1.9525E-02_JPRB,1.8286E-02_JPRB,1.8359E-02_JPRB,1.8803E-02_JPRB,1.8505E-02_JPRB,1.7397E-02_JPRB,&
&1.5545E-02_JPRB,1.4074E-02_JPRB,1.3147E-02_JPRB/)
KAO( :, 4, 7,10) = (/&
&2.4765E-02_JPRB,2.3347E-02_JPRB,2.3852E-02_JPRB,2.4521E-02_JPRB,2.4046E-02_JPRB,2.2746E-02_JPRB,&
&2.0338E-02_JPRB,1.9593E-02_JPRB,1.8718E-02_JPRB/)
KAO( :, 5, 7,10) = (/&
&3.0444E-02_JPRB,2.9114E-02_JPRB,2.9981E-02_JPRB,3.1001E-02_JPRB,3.0659E-02_JPRB,2.9115E-02_JPRB,&
&2.6153E-02_JPRB,2.6663E-02_JPRB,2.5778E-02_JPRB/)
KAO( :, 1, 8,10) = (/&
&9.5903E-03_JPRB,8.7677E-03_JPRB,8.2751E-03_JPRB,7.7628E-03_JPRB,7.6194E-03_JPRB,7.2194E-03_JPRB,&
&6.4757E-03_JPRB,5.1626E-03_JPRB,4.5446E-03_JPRB/)
KAO( :, 2, 8,10) = (/&
&1.3386E-02_JPRB,1.2290E-02_JPRB,1.1661E-02_JPRB,1.1306E-02_JPRB,1.1055E-02_JPRB,1.0454E-02_JPRB,&
&9.3918E-03_JPRB,7.5740E-03_JPRB,6.6212E-03_JPRB/)
KAO( :, 3, 8,10) = (/&
&1.7895E-02_JPRB,1.6495E-02_JPRB,1.5871E-02_JPRB,1.5730E-02_JPRB,1.5237E-02_JPRB,1.4347E-02_JPRB,&
&1.2880E-02_JPRB,1.1121E-02_JPRB,9.9657E-03_JPRB/)
KAO( :, 4, 8,10) = (/&
&2.3088E-02_JPRB,2.1460E-02_JPRB,2.0931E-02_JPRB,2.0828E-02_JPRB,2.0243E-02_JPRB,1.9039E-02_JPRB,&
&1.7178E-02_JPRB,1.5707E-02_JPRB,1.4369E-02_JPRB/)
KAO( :, 5, 8,10) = (/&
&2.8768E-02_JPRB,2.7065E-02_JPRB,2.6736E-02_JPRB,2.6678E-02_JPRB,2.6248E-02_JPRB,2.4878E-02_JPRB,&
&2.2359E-02_JPRB,2.1798E-02_JPRB,1.9974E-02_JPRB/)
KAO( :, 1, 9,10) = (/&
&8.1489E-03_JPRB,7.4648E-03_JPRB,6.9804E-03_JPRB,6.4191E-03_JPRB,5.9636E-03_JPRB,5.4909E-03_JPRB,&
&4.8784E-03_JPRB,3.8347E-03_JPRB,1.5314E-02_JPRB/)
KAO( :, 2, 9,10) = (/&
&1.1712E-02_JPRB,1.0789E-02_JPRB,1.0109E-02_JPRB,9.4829E-03_JPRB,8.8584E-03_JPRB,8.2278E-03_JPRB,&
&7.3764E-03_JPRB,5.7877E-03_JPRB,1.6244E-02_JPRB/)
KAO( :, 3, 9,10) = (/&
&1.6046E-02_JPRB,1.4820E-02_JPRB,1.4055E-02_JPRB,1.3332E-02_JPRB,1.2456E-02_JPRB,1.1636E-02_JPRB,&
&1.0489E-02_JPRB,8.6873E-03_JPRB,1.7494E-02_JPRB/)
KAO( :, 4, 9,10) = (/&
&2.1066E-02_JPRB,1.9610E-02_JPRB,1.8931E-02_JPRB,1.7888E-02_JPRB,1.6756E-02_JPRB,1.5784E-02_JPRB,&
&1.4417E-02_JPRB,1.2557E-02_JPRB,1.9326E-02_JPRB/)
KAO( :, 5, 9,10) = (/&
&2.6667E-02_JPRB,2.5074E-02_JPRB,2.4522E-02_JPRB,2.3189E-02_JPRB,2.2008E-02_JPRB,2.0995E-02_JPRB,&
&1.9281E-02_JPRB,1.7791E-02_JPRB,2.1654E-02_JPRB/)
KAO( :, 1,10,10) = (/&
&6.9366E-03_JPRB,6.3789E-03_JPRB,5.9595E-03_JPRB,5.4852E-03_JPRB,4.9360E-03_JPRB,4.3201E-03_JPRB,&
&3.7060E-03_JPRB,2.8411E-03_JPRB,1.0865E-01_JPRB/)
KAO( :, 2,10,10) = (/&
&1.0236E-02_JPRB,9.4750E-03_JPRB,8.8501E-03_JPRB,8.3036E-03_JPRB,7.4880E-03_JPRB,6.6146E-03_JPRB,&
&5.8580E-03_JPRB,4.5793E-03_JPRB,1.0627E-01_JPRB/)
KAO( :, 3,10,10) = (/&
&1.4332E-02_JPRB,1.3324E-02_JPRB,1.2604E-02_JPRB,1.1845E-02_JPRB,1.0730E-02_JPRB,9.5741E-03_JPRB,&
&8.5876E-03_JPRB,7.0236E-03_JPRB,1.0490E-01_JPRB/)
KAO( :, 4,10,10) = (/&
&1.9120E-02_JPRB,1.7914E-02_JPRB,1.7311E-02_JPRB,1.6108E-02_JPRB,1.4592E-02_JPRB,1.3253E-02_JPRB,&
&1.2097E-02_JPRB,1.0165E-02_JPRB,1.0426E-01_JPRB/)
KAO( :, 5,10,10) = (/&
&2.4561E-02_JPRB,2.3221E-02_JPRB,2.2646E-02_JPRB,2.1122E-02_JPRB,1.9334E-02_JPRB,1.7961E-02_JPRB,&
&1.6559E-02_JPRB,1.4610E-02_JPRB,1.0510E-01_JPRB/)
KAO( :, 1,11,10) = (/&
&7.0237E-03_JPRB,6.5225E-03_JPRB,6.1043E-03_JPRB,5.6444E-03_JPRB,5.0633E-03_JPRB,4.3399E-03_JPRB,&
&3.5607E-03_JPRB,2.6850E-03_JPRB,2.8892E-01_JPRB/)
KAO( :, 2,11,10) = (/&
&1.0384E-02_JPRB,9.6831E-03_JPRB,9.0835E-03_JPRB,8.5192E-03_JPRB,7.6404E-03_JPRB,6.6528E-03_JPRB,&
&5.6514E-03_JPRB,4.5273E-03_JPRB,2.8169E-01_JPRB/)
KAO( :, 3,11,10) = (/&
&1.4456E-02_JPRB,1.3566E-02_JPRB,1.2997E-02_JPRB,1.2107E-02_JPRB,1.0901E-02_JPRB,9.5425E-03_JPRB,&
&8.2374E-03_JPRB,6.8400E-03_JPRB,2.7734E-01_JPRB/)
KAO( :, 4,11,10) = (/&
&1.9195E-02_JPRB,1.8156E-02_JPRB,1.7656E-02_JPRB,1.6419E-02_JPRB,1.4881E-02_JPRB,1.3205E-02_JPRB,&
&1.1741E-02_JPRB,9.9915E-03_JPRB,2.7331E-01_JPRB/)
KAO( :, 5,11,10) = (/&
&2.4521E-02_JPRB,2.3536E-02_JPRB,2.2979E-02_JPRB,2.1464E-02_JPRB,1.9799E-02_JPRB,1.7771E-02_JPRB,&
&1.6045E-02_JPRB,1.4047E-02_JPRB,2.7061E-01_JPRB/)
KAO( :, 1,12,10) = (/&
&6.9801E-03_JPRB,6.5414E-03_JPRB,6.1464E-03_JPRB,5.6988E-03_JPRB,5.0902E-03_JPRB,4.4198E-03_JPRB,&
&3.6370E-03_JPRB,2.5506E-03_JPRB,4.9609E-01_JPRB/)
KAO( :, 2,12,10) = (/&
&1.0252E-02_JPRB,9.6631E-03_JPRB,9.2104E-03_JPRB,8.5451E-03_JPRB,7.6724E-03_JPRB,6.7086E-03_JPRB,&
&5.5412E-03_JPRB,4.4277E-03_JPRB,4.8672E-01_JPRB/)
KAO( :, 3,12,10) = (/&
&1.4194E-02_JPRB,1.3473E-02_JPRB,1.3019E-02_JPRB,1.2130E-02_JPRB,1.0940E-02_JPRB,9.6059E-03_JPRB,&
&8.1091E-03_JPRB,6.7337E-03_JPRB,4.7779E-01_JPRB/)
KAO( :, 4,12,10) = (/&
&1.8764E-02_JPRB,1.7996E-02_JPRB,1.7549E-02_JPRB,1.6391E-02_JPRB,1.4970E-02_JPRB,1.3362E-02_JPRB,&
&1.1424E-02_JPRB,9.7371E-03_JPRB,4.7094E-01_JPRB/)
KAO( :, 5,12,10) = (/&
&2.3822E-02_JPRB,2.3255E-02_JPRB,2.2798E-02_JPRB,2.1487E-02_JPRB,1.9935E-02_JPRB,1.7893E-02_JPRB,&
&1.5477E-02_JPRB,1.3501E-02_JPRB,4.6404E-01_JPRB/)
KAO( :, 1,13,10) = (/&
&6.7570E-03_JPRB,6.3985E-03_JPRB,6.0648E-03_JPRB,5.6090E-03_JPRB,5.0372E-03_JPRB,4.3896E-03_JPRB,&
&3.5984E-03_JPRB,2.5612E-03_JPRB,7.0129E-01_JPRB/)
KAO( :, 2,13,10) = (/&
&9.8516E-03_JPRB,9.3610E-03_JPRB,9.0380E-03_JPRB,8.3857E-03_JPRB,7.5801E-03_JPRB,6.6037E-03_JPRB,&
&5.4660E-03_JPRB,4.1572E-03_JPRB,6.8624E-01_JPRB/)
KAO( :, 3,13,10) = (/&
&1.3565E-02_JPRB,1.3023E-02_JPRB,1.2697E-02_JPRB,1.1845E-02_JPRB,1.0771E-02_JPRB,9.5129E-03_JPRB,&
&8.0355E-03_JPRB,6.4068E-03_JPRB,6.7348E-01_JPRB/)
KAO( :, 4,13,10) = (/&
&1.7823E-02_JPRB,1.7451E-02_JPRB,1.7031E-02_JPRB,1.6025E-02_JPRB,1.4810E-02_JPRB,1.3226E-02_JPRB,&
&1.1248E-02_JPRB,9.2627E-03_JPRB,6.6252E-01_JPRB/)
KAO( :, 5,13,10) = (/&
&2.2635E-02_JPRB,2.2570E-02_JPRB,2.2029E-02_JPRB,2.1116E-02_JPRB,1.9648E-02_JPRB,1.7648E-02_JPRB,&
&1.5125E-02_JPRB,1.2814E-02_JPRB,6.5224E-01_JPRB/)
KAO( :, 1, 1,11) = (/&
&4.0423E-02_JPRB,3.5511E-02_JPRB,3.2385E-02_JPRB,3.1302E-02_JPRB,2.9329E-02_JPRB,2.7493E-02_JPRB,&
&2.5237E-02_JPRB,2.6262E-02_JPRB,3.3335E-02_JPRB/)
KAO( :, 2, 1,11) = (/&
&4.8068E-02_JPRB,4.2224E-02_JPRB,3.9790E-02_JPRB,3.8473E-02_JPRB,3.6916E-02_JPRB,3.3889E-02_JPRB,&
&3.2387E-02_JPRB,3.4784E-02_JPRB,4.3954E-02_JPRB/)
KAO( :, 3, 1,11) = (/&
&5.5962E-02_JPRB,4.9147E-02_JPRB,4.7932E-02_JPRB,4.6498E-02_JPRB,4.4808E-02_JPRB,4.0788E-02_JPRB,&
&4.1145E-02_JPRB,4.4752E-02_JPRB,5.6848E-02_JPRB/)
KAO( :, 4, 1,11) = (/&
&6.3927E-02_JPRB,5.6554E-02_JPRB,5.6496E-02_JPRB,5.5146E-02_JPRB,5.2972E-02_JPRB,4.9275E-02_JPRB,&
&5.2218E-02_JPRB,5.7028E-02_JPRB,7.1593E-02_JPRB/)
KAO( :, 5, 1,11) = (/&
&7.1900E-02_JPRB,6.5533E-02_JPRB,6.5482E-02_JPRB,6.4060E-02_JPRB,6.1054E-02_JPRB,5.9498E-02_JPRB,&
&6.4850E-02_JPRB,7.0769E-02_JPRB,8.8897E-02_JPRB/)
KAO( :, 1, 2,11) = (/&
&3.8292E-02_JPRB,3.3588E-02_JPRB,3.1358E-02_JPRB,2.9906E-02_JPRB,2.8447E-02_JPRB,2.6569E-02_JPRB,&
&2.3944E-02_JPRB,2.4132E-02_JPRB,3.1513E-02_JPRB/)
KAO( :, 2, 2,11) = (/&
&4.5994E-02_JPRB,4.0345E-02_JPRB,3.8650E-02_JPRB,3.7178E-02_JPRB,3.6077E-02_JPRB,3.2811E-02_JPRB,&
&3.1189E-02_JPRB,3.2232E-02_JPRB,4.1849E-02_JPRB/)
KAO( :, 3, 2,11) = (/&
&5.3984E-02_JPRB,4.7456E-02_JPRB,4.6641E-02_JPRB,4.5568E-02_JPRB,4.3973E-02_JPRB,3.9559E-02_JPRB,&
&3.9776E-02_JPRB,4.1895E-02_JPRB,5.4339E-02_JPRB/)
KAO( :, 4, 2,11) = (/&
&6.2153E-02_JPRB,5.5541E-02_JPRB,5.5147E-02_JPRB,5.4419E-02_JPRB,5.2145E-02_JPRB,4.8212E-02_JPRB,&
&5.0049E-02_JPRB,5.4211E-02_JPRB,6.8573E-02_JPRB/)
KAO( :, 5, 2,11) = (/&
&7.0498E-02_JPRB,6.4912E-02_JPRB,6.4005E-02_JPRB,6.3675E-02_JPRB,6.0340E-02_JPRB,5.8471E-02_JPRB,&
&6.1765E-02_JPRB,6.8106E-02_JPRB,8.5795E-02_JPRB/)
KAO( :, 1, 3,11) = (/&
&3.4351E-02_JPRB,3.0114E-02_JPRB,2.8690E-02_JPRB,2.7033E-02_JPRB,2.5922E-02_JPRB,2.4043E-02_JPRB,&
&2.1412E-02_JPRB,2.0519E-02_JPRB,2.7411E-02_JPRB/)
KAO( :, 2, 3,11) = (/&
&4.1940E-02_JPRB,3.6767E-02_JPRB,3.5782E-02_JPRB,3.4187E-02_JPRB,3.3188E-02_JPRB,3.0297E-02_JPRB,&
&2.8550E-02_JPRB,2.8551E-02_JPRB,3.7044E-02_JPRB/)
KAO( :, 3, 3,11) = (/&
&5.0028E-02_JPRB,4.4118E-02_JPRB,4.3712E-02_JPRB,4.2513E-02_JPRB,4.0818E-02_JPRB,3.7223E-02_JPRB,&
&3.6892E-02_JPRB,3.7585E-02_JPRB,4.9025E-02_JPRB/)
KAO( :, 4, 3,11) = (/&
&5.8382E-02_JPRB,5.2350E-02_JPRB,5.2192E-02_JPRB,5.1365E-02_JPRB,4.8840E-02_JPRB,4.5605E-02_JPRB,&
&4.6688E-02_JPRB,4.8795E-02_JPRB,6.3308E-02_JPRB/)
KAO( :, 5, 3,11) = (/&
&6.6855E-02_JPRB,6.1851E-02_JPRB,6.1319E-02_JPRB,6.0440E-02_JPRB,5.7553E-02_JPRB,5.5141E-02_JPRB,&
&5.7507E-02_JPRB,6.1726E-02_JPRB,8.0747E-02_JPRB/)
KAO( :, 1, 4,11) = (/&
&2.9914E-02_JPRB,2.6434E-02_JPRB,2.5229E-02_JPRB,2.3960E-02_JPRB,2.2872E-02_JPRB,2.1167E-02_JPRB,&
&1.8618E-02_JPRB,1.7654E-02_JPRB,2.2206E-02_JPRB/)
KAO( :, 2, 4,11) = (/&
&3.7311E-02_JPRB,3.2955E-02_JPRB,3.1987E-02_JPRB,3.0816E-02_JPRB,2.9746E-02_JPRB,2.7451E-02_JPRB,&
&2.5496E-02_JPRB,2.4816E-02_JPRB,3.0769E-02_JPRB/)
KAO( :, 3, 4,11) = (/&
&4.5214E-02_JPRB,4.0225E-02_JPRB,3.9665E-02_JPRB,3.8830E-02_JPRB,3.7073E-02_JPRB,3.4317E-02_JPRB,&
&3.3498E-02_JPRB,3.3259E-02_JPRB,4.1672E-02_JPRB/)
KAO( :, 4, 4,11) = (/&
&5.3522E-02_JPRB,4.8440E-02_JPRB,4.8077E-02_JPRB,4.7499E-02_JPRB,4.5060E-02_JPRB,4.2198E-02_JPRB,&
&4.2877E-02_JPRB,4.3659E-02_JPRB,5.5415E-02_JPRB/)
KAO( :, 5, 4,11) = (/&
&6.2112E-02_JPRB,5.7637E-02_JPRB,5.7355E-02_JPRB,5.6365E-02_JPRB,5.3831E-02_JPRB,5.1483E-02_JPRB,&
&5.3578E-02_JPRB,5.5548E-02_JPRB,7.2397E-02_JPRB/)
KAO( :, 1, 5,11) = (/&
&2.5525E-02_JPRB,2.2961E-02_JPRB,2.1743E-02_JPRB,2.1045E-02_JPRB,1.9762E-02_JPRB,1.8313E-02_JPRB,&
&1.6006E-02_JPRB,1.4928E-02_JPRB,1.7243E-02_JPRB/)
KAO( :, 2, 5,11) = (/&
&3.2562E-02_JPRB,2.9297E-02_JPRB,2.8118E-02_JPRB,2.7378E-02_JPRB,2.6219E-02_JPRB,2.4429E-02_JPRB,&
&2.2374E-02_JPRB,2.1608E-02_JPRB,2.4409E-02_JPRB/)
KAO( :, 3, 5,11) = (/&
&4.0237E-02_JPRB,3.6530E-02_JPRB,3.5529E-02_JPRB,3.4947E-02_JPRB,3.3507E-02_JPRB,3.1205E-02_JPRB,&
&2.9865E-02_JPRB,2.9668E-02_JPRB,3.3965E-02_JPRB/)
KAO( :, 4, 5,11) = (/&
&4.8489E-02_JPRB,4.4640E-02_JPRB,4.3882E-02_JPRB,4.3184E-02_JPRB,4.1466E-02_JPRB,3.8716E-02_JPRB,&
&3.8839E-02_JPRB,3.9053E-02_JPRB,4.6193E-02_JPRB/)
KAO( :, 5, 5,11) = (/&
&5.7075E-02_JPRB,5.3520E-02_JPRB,5.3151E-02_JPRB,5.1813E-02_JPRB,5.0143E-02_JPRB,4.7699E-02_JPRB,&
&4.9575E-02_JPRB,5.0287E-02_JPRB,6.1844E-02_JPRB/)
KAO( :, 1, 6,11) = (/&
&2.1185E-02_JPRB,1.9366E-02_JPRB,1.8345E-02_JPRB,1.7861E-02_JPRB,1.6696E-02_JPRB,1.5286E-02_JPRB,&
&1.3538E-02_JPRB,1.2110E-02_JPRB,1.3050E-02_JPRB/)
KAO( :, 2, 6,11) = (/&
&2.7736E-02_JPRB,2.5421E-02_JPRB,2.4344E-02_JPRB,2.3686E-02_JPRB,2.2632E-02_JPRB,2.1167E-02_JPRB,&
&1.8994E-02_JPRB,1.8327E-02_JPRB,1.8722E-02_JPRB/)
KAO( :, 3, 6,11) = (/&
&3.5098E-02_JPRB,3.2433E-02_JPRB,3.1346E-02_JPRB,3.0890E-02_JPRB,2.9717E-02_JPRB,2.7709E-02_JPRB,&
&2.5626E-02_JPRB,2.5639E-02_JPRB,2.6411E-02_JPRB/)
KAO( :, 4, 6,11) = (/&
&4.3033E-02_JPRB,4.0261E-02_JPRB,3.9466E-02_JPRB,3.8845E-02_JPRB,3.7545E-02_JPRB,3.4640E-02_JPRB,&
&3.3862E-02_JPRB,3.4287E-02_JPRB,3.6956E-02_JPRB/)
KAO( :, 5, 6,11) = (/&
&5.1415E-02_JPRB,4.8889E-02_JPRB,4.8524E-02_JPRB,4.7406E-02_JPRB,4.5977E-02_JPRB,4.3021E-02_JPRB,&
&4.4126E-02_JPRB,4.4906E-02_JPRB,5.0432E-02_JPRB/)
KAO( :, 1, 7,11) = (/&
&1.7209E-02_JPRB,1.5911E-02_JPRB,1.5312E-02_JPRB,1.4785E-02_JPRB,1.3788E-02_JPRB,1.2644E-02_JPRB,&
&1.1178E-02_JPRB,9.4262E-03_JPRB,9.6250E-03_JPRB/)
KAO( :, 2, 7,11) = (/&
&2.3204E-02_JPRB,2.1530E-02_JPRB,2.0850E-02_JPRB,2.0150E-02_JPRB,1.9195E-02_JPRB,1.8013E-02_JPRB,&
&1.5715E-02_JPRB,1.4967E-02_JPRB,1.4283E-02_JPRB/)
KAO( :, 3, 7,11) = (/&
&3.0021E-02_JPRB,2.8103E-02_JPRB,2.7384E-02_JPRB,2.6841E-02_JPRB,2.5917E-02_JPRB,2.4071E-02_JPRB,&
&2.1339E-02_JPRB,2.1364E-02_JPRB,2.0562E-02_JPRB/)
KAO( :, 4, 7,11) = (/&
&3.7516E-02_JPRB,3.5493E-02_JPRB,3.5022E-02_JPRB,3.4550E-02_JPRB,3.3425E-02_JPRB,3.0562E-02_JPRB,&
&2.8485E-02_JPRB,2.9108E-02_JPRB,2.9186E-02_JPRB/)
KAO( :, 5, 7,11) = (/&
&4.5622E-02_JPRB,4.3704E-02_JPRB,4.3641E-02_JPRB,4.3057E-02_JPRB,4.1664E-02_JPRB,3.8186E-02_JPRB,&
&3.7831E-02_JPRB,3.8897E-02_JPRB,4.0505E-02_JPRB/)
KAO( :, 1, 8,11) = (/&
&1.3818E-02_JPRB,1.2820E-02_JPRB,1.2555E-02_JPRB,1.2034E-02_JPRB,1.1176E-02_JPRB,1.0359E-02_JPRB,&
&9.1227E-03_JPRB,7.1909E-03_JPRB,7.1385E-03_JPRB/)
KAO( :, 2, 8,11) = (/&
&1.9199E-02_JPRB,1.7868E-02_JPRB,1.7585E-02_JPRB,1.6871E-02_JPRB,1.6078E-02_JPRB,1.5016E-02_JPRB,&
&1.2893E-02_JPRB,1.1875E-02_JPRB,1.0811E-02_JPRB/)
KAO( :, 3, 8,11) = (/&
&2.5464E-02_JPRB,2.3910E-02_JPRB,2.3566E-02_JPRB,2.3034E-02_JPRB,2.2314E-02_JPRB,2.0472E-02_JPRB,&
&1.7635E-02_JPRB,1.7256E-02_JPRB,1.5992E-02_JPRB/)
KAO( :, 4, 8,11) = (/&
&3.2551E-02_JPRB,3.0722E-02_JPRB,3.0704E-02_JPRB,3.0409E-02_JPRB,2.9339E-02_JPRB,2.6650E-02_JPRB,&
&2.3599E-02_JPRB,2.4044E-02_JPRB,2.3236E-02_JPRB/)
KAO( :, 5, 8,11) = (/&
&4.0250E-02_JPRB,3.8454E-02_JPRB,3.8842E-02_JPRB,3.8675E-02_JPRB,3.7147E-02_JPRB,3.3647E-02_JPRB,&
&3.1602E-02_JPRB,3.2839E-02_JPRB,3.2581E-02_JPRB/)
KAO( :, 1, 9,11) = (/&
&1.1316E-02_JPRB,1.0378E-02_JPRB,1.0058E-02_JPRB,9.5388E-03_JPRB,8.9583E-03_JPRB,8.3215E-03_JPRB,&
&7.2172E-03_JPRB,5.3794E-03_JPRB,1.8355E-02_JPRB/)
KAO( :, 2, 9,11) = (/&
&1.6231E-02_JPRB,1.4928E-02_JPRB,1.4498E-02_JPRB,1.3829E-02_JPRB,1.3241E-02_JPRB,1.2313E-02_JPRB,&
&1.0614E-02_JPRB,9.2668E-03_JPRB,1.9770E-02_JPRB/)
KAO( :, 3, 9,11) = (/&
&2.2130E-02_JPRB,2.0494E-02_JPRB,1.9903E-02_JPRB,1.9411E-02_JPRB,1.8773E-02_JPRB,1.7143E-02_JPRB,&
&1.4703E-02_JPRB,1.3790E-02_JPRB,2.1581E-02_JPRB/)
KAO( :, 4, 9,11) = (/&
&2.8872E-02_JPRB,2.6893E-02_JPRB,2.6410E-02_JPRB,2.6293E-02_JPRB,2.5184E-02_JPRB,2.2875E-02_JPRB,&
&1.9599E-02_JPRB,1.9453E-02_JPRB,2.4207E-02_JPRB/)
KAO( :, 5, 9,11) = (/&
&3.6434E-02_JPRB,3.4163E-02_JPRB,3.4039E-02_JPRB,3.4059E-02_JPRB,3.2485E-02_JPRB,2.9558E-02_JPRB,&
&2.6124E-02_JPRB,2.6908E-02_JPRB,2.8766E-02_JPRB/)
KAO( :, 1,10,11) = (/&
&9.7526E-03_JPRB,8.8471E-03_JPRB,8.4095E-03_JPRB,7.7992E-03_JPRB,7.2733E-03_JPRB,6.6861E-03_JPRB,&
&5.7804E-03_JPRB,4.0724E-03_JPRB,1.2763E-01_JPRB/)
KAO( :, 2,10,11) = (/&
&1.4441E-02_JPRB,1.3149E-02_JPRB,1.2436E-02_JPRB,1.1554E-02_JPRB,1.1049E-02_JPRB,1.0173E-02_JPRB,&
&8.7698E-03_JPRB,7.1450E-03_JPRB,1.2600E-01_JPRB/)
KAO( :, 3,10,11) = (/&
&2.0155E-02_JPRB,1.8437E-02_JPRB,1.7426E-02_JPRB,1.6603E-02_JPRB,1.5853E-02_JPRB,1.4561E-02_JPRB,&
&1.2511E-02_JPRB,1.1073E-02_JPRB,1.2528E-01_JPRB/)
KAO( :, 4,10,11) = (/&
&2.6846E-02_JPRB,2.4609E-02_JPRB,2.3486E-02_JPRB,2.2854E-02_JPRB,2.1623E-02_JPRB,1.9796E-02_JPRB,&
&1.6929E-02_JPRB,1.5991E-02_JPRB,1.2447E-01_JPRB/)
KAO( :, 5,10,11) = (/&
&3.4410E-02_JPRB,3.1744E-02_JPRB,3.0750E-02_JPRB,2.9972E-02_JPRB,2.8397E-02_JPRB,2.5966E-02_JPRB,&
&2.2616E-02_JPRB,2.2449E-02_JPRB,1.2610E-01_JPRB/)
KAO( :, 1,11,11) = (/&
&1.0324E-02_JPRB,9.3720E-03_JPRB,8.7252E-03_JPRB,7.9450E-03_JPRB,7.2482E-03_JPRB,6.5147E-03_JPRB,&
&5.6100E-03_JPRB,4.1662E-03_JPRB,3.4329E-01_JPRB/)
KAO( :, 2,11,11) = (/&
&1.5204E-02_JPRB,1.3885E-02_JPRB,1.2891E-02_JPRB,1.1869E-02_JPRB,1.0956E-02_JPRB,9.8826E-03_JPRB,&
&8.5703E-03_JPRB,6.8061E-03_JPRB,3.3565E-01_JPRB/)
KAO( :, 3,11,11) = (/&
&2.1115E-02_JPRB,1.9367E-02_JPRB,1.8058E-02_JPRB,1.6962E-02_JPRB,1.5612E-02_JPRB,1.4165E-02_JPRB,&
&1.2308E-02_JPRB,1.0528E-02_JPRB,3.2746E-01_JPRB/)
KAO( :, 4,11,11) = (/&
&2.8056E-02_JPRB,2.5869E-02_JPRB,2.4495E-02_JPRB,2.3019E-02_JPRB,2.1190E-02_JPRB,1.9340E-02_JPRB,&
&1.6909E-02_JPRB,1.5353E-02_JPRB,3.2105E-01_JPRB/)
KAO( :, 5,11,11) = (/&
&3.5830E-02_JPRB,3.3269E-02_JPRB,3.2053E-02_JPRB,3.0019E-02_JPRB,2.7764E-02_JPRB,2.5746E-02_JPRB,&
&2.2821E-02_JPRB,2.2018E-02_JPRB,3.1597E-01_JPRB/)
KAO( :, 1,12,11) = (/&
&1.0672E-02_JPRB,9.7549E-03_JPRB,9.0561E-03_JPRB,8.2466E-03_JPRB,7.3613E-03_JPRB,6.3875E-03_JPRB,&
&5.3947E-03_JPRB,4.0883E-03_JPRB,5.8394E-01_JPRB/)
KAO( :, 2,12,11) = (/&
&1.5642E-02_JPRB,1.4385E-02_JPRB,1.3307E-02_JPRB,1.2366E-02_JPRB,1.1058E-02_JPRB,9.6585E-03_JPRB,&
&8.3795E-03_JPRB,6.6353E-03_JPRB,5.6769E-01_JPRB/)
KAO( :, 3,12,11) = (/&
&2.1675E-02_JPRB,2.0001E-02_JPRB,1.8764E-02_JPRB,1.7488E-02_JPRB,1.5704E-02_JPRB,1.3828E-02_JPRB,&
&1.2045E-02_JPRB,1.0080E-02_JPRB,5.5255E-01_JPRB/)
KAO( :, 4,12,11) = (/&
&2.8647E-02_JPRB,2.6665E-02_JPRB,2.5514E-02_JPRB,2.3603E-02_JPRB,2.1257E-02_JPRB,1.8966E-02_JPRB,&
&1.6778E-02_JPRB,1.4837E-02_JPRB,5.4088E-01_JPRB/)
KAO( :, 5,12,11) = (/&
&3.6513E-02_JPRB,3.4282E-02_JPRB,3.3140E-02_JPRB,3.0751E-02_JPRB,2.7941E-02_JPRB,2.5430E-02_JPRB,&
&2.2803E-02_JPRB,2.1312E-02_JPRB,5.3155E-01_JPRB/)
KAO( :, 1,13,11) = (/&
&1.0760E-02_JPRB,9.9165E-03_JPRB,9.2107E-03_JPRB,8.4431E-03_JPRB,7.5043E-03_JPRB,6.4219E-03_JPRB,&
&5.3322E-03_JPRB,3.9942E-03_JPRB,8.0574E-01_JPRB/)
KAO( :, 2,13,11) = (/&
&1.5718E-02_JPRB,1.4579E-02_JPRB,1.3580E-02_JPRB,1.2603E-02_JPRB,1.1240E-02_JPRB,9.7118E-03_JPRB,&
&8.1489E-03_JPRB,6.5540E-03_JPRB,7.8546E-01_JPRB/)
KAO( :, 3,13,11) = (/&
&2.1709E-02_JPRB,2.0244E-02_JPRB,1.9196E-02_JPRB,1.7788E-02_JPRB,1.5932E-02_JPRB,1.3847E-02_JPRB,&
&1.1724E-02_JPRB,9.8122E-03_JPRB,7.6747E-01_JPRB/)
KAO( :, 4,13,11) = (/&
&2.8590E-02_JPRB,2.6855E-02_JPRB,2.5888E-02_JPRB,2.3974E-02_JPRB,2.1610E-02_JPRB,1.9031E-02_JPRB,&
&1.6481E-02_JPRB,1.4419E-02_JPRB,7.5290E-01_JPRB/)
KAO( :, 5,13,11) = (/&
&3.6243E-02_JPRB,3.4524E-02_JPRB,3.3518E-02_JPRB,3.1146E-02_JPRB,2.8589E-02_JPRB,2.5416E-02_JPRB,&
&2.2358E-02_JPRB,2.0400E-02_JPRB,7.4359E-01_JPRB/)
KAO( :, 1, 1,12) = (/&
&5.6231E-02_JPRB,4.9245E-02_JPRB,4.2437E-02_JPRB,3.9377E-02_JPRB,3.6183E-02_JPRB,3.2140E-02_JPRB,&
&3.2423E-02_JPRB,3.1523E-02_JPRB,4.6750E-02_JPRB/)
KAO( :, 2, 1,12) = (/&
&6.6148E-02_JPRB,5.7978E-02_JPRB,5.1041E-02_JPRB,4.8104E-02_JPRB,4.3912E-02_JPRB,4.1677E-02_JPRB,&
&4.3817E-02_JPRB,4.4437E-02_JPRB,6.2584E-02_JPRB/)
KAO( :, 3, 1,12) = (/&
&7.6244E-02_JPRB,6.6854E-02_JPRB,6.1488E-02_JPRB,5.7173E-02_JPRB,5.2540E-02_JPRB,5.2875E-02_JPRB,&
&5.7103E-02_JPRB,5.8708E-02_JPRB,8.0763E-02_JPRB/)
KAO( :, 4, 1,12) = (/&
&8.6310E-02_JPRB,7.5728E-02_JPRB,7.2130E-02_JPRB,6.6817E-02_JPRB,6.2530E-02_JPRB,6.5257E-02_JPRB,&
&7.2354E-02_JPRB,7.4823E-02_JPRB,1.0291E-01_JPRB/)
KAO( :, 5, 1,12) = (/&
&9.6172E-02_JPRB,8.4532E-02_JPRB,8.2586E-02_JPRB,7.6624E-02_JPRB,7.4096E-02_JPRB,7.9889E-02_JPRB,&
&9.0215E-02_JPRB,9.5892E-02_JPRB,1.2765E-01_JPRB/)
KAO( :, 1, 2,12) = (/&
&5.4471E-02_JPRB,4.7727E-02_JPRB,4.1337E-02_JPRB,3.9056E-02_JPRB,3.5201E-02_JPRB,3.1688E-02_JPRB,&
&3.1483E-02_JPRB,3.1390E-02_JPRB,4.4121E-02_JPRB/)
KAO( :, 2, 2,12) = (/&
&6.4761E-02_JPRB,5.6767E-02_JPRB,5.0472E-02_JPRB,4.7843E-02_JPRB,4.3316E-02_JPRB,4.1425E-02_JPRB,&
&4.2288E-02_JPRB,4.3887E-02_JPRB,5.9020E-02_JPRB/)
KAO( :, 3, 2,12) = (/&
&7.5278E-02_JPRB,6.6006E-02_JPRB,6.0892E-02_JPRB,5.7036E-02_JPRB,5.2510E-02_JPRB,5.2589E-02_JPRB,&
&5.4973E-02_JPRB,5.8082E-02_JPRB,7.6747E-02_JPRB/)
KAO( :, 4, 2,12) = (/&
&8.5814E-02_JPRB,7.5272E-02_JPRB,7.1653E-02_JPRB,6.6752E-02_JPRB,6.2771E-02_JPRB,6.5169E-02_JPRB,&
&7.0350E-02_JPRB,7.4345E-02_JPRB,9.8748E-02_JPRB/)
KAO( :, 5, 2,12) = (/&
&9.6214E-02_JPRB,8.4711E-02_JPRB,8.2534E-02_JPRB,7.6688E-02_JPRB,7.5320E-02_JPRB,7.9513E-02_JPRB,&
&8.8443E-02_JPRB,9.3326E-02_JPRB,1.2393E-01_JPRB/)
KAO( :, 1, 3,12) = (/&
&5.0240E-02_JPRB,4.4018E-02_JPRB,3.8537E-02_JPRB,3.6190E-02_JPRB,3.2727E-02_JPRB,2.9265E-02_JPRB,&
&2.8718E-02_JPRB,2.8539E-02_JPRB,3.8545E-02_JPRB/)
KAO( :, 2, 3,12) = (/&
&6.0700E-02_JPRB,5.3194E-02_JPRB,4.7696E-02_JPRB,4.4849E-02_JPRB,4.0923E-02_JPRB,3.8400E-02_JPRB,&
&3.8699E-02_JPRB,3.9635E-02_JPRB,5.2691E-02_JPRB/)
KAO( :, 3, 3,12) = (/&
&7.1446E-02_JPRB,6.2599E-02_JPRB,5.7763E-02_JPRB,5.4243E-02_JPRB,5.0207E-02_JPRB,4.9187E-02_JPRB,&
&5.0052E-02_JPRB,5.3471E-02_JPRB,6.9258E-02_JPRB/)
KAO( :, 4, 3,12) = (/&
&8.2289E-02_JPRB,7.2095E-02_JPRB,6.8416E-02_JPRB,6.4344E-02_JPRB,6.0447E-02_JPRB,6.1241E-02_JPRB,&
&6.3891E-02_JPRB,6.9264E-02_JPRB,8.9560E-02_JPRB/)
KAO( :, 5, 3,12) = (/&
&9.3052E-02_JPRB,8.1807E-02_JPRB,7.9129E-02_JPRB,7.4686E-02_JPRB,7.2461E-02_JPRB,7.5879E-02_JPRB,&
&8.1262E-02_JPRB,8.8197E-02_JPRB,1.1309E-01_JPRB/)
KAO( :, 1, 4,12) = (/&
&4.5028E-02_JPRB,3.9435E-02_JPRB,3.5334E-02_JPRB,3.2580E-02_JPRB,2.9727E-02_JPRB,2.6383E-02_JPRB,&
&2.5279E-02_JPRB,2.4249E-02_JPRB,3.2836E-02_JPRB/)
KAO( :, 2, 4,12) = (/&
&5.5340E-02_JPRB,4.8463E-02_JPRB,4.4234E-02_JPRB,4.0965E-02_JPRB,3.7511E-02_JPRB,3.4709E-02_JPRB,&
&3.4617E-02_JPRB,3.4578E-02_JPRB,4.5997E-02_JPRB/)
KAO( :, 3, 4,12) = (/&
&6.6183E-02_JPRB,5.7963E-02_JPRB,5.3924E-02_JPRB,5.0425E-02_JPRB,4.6576E-02_JPRB,4.4933E-02_JPRB,&
&4.5427E-02_JPRB,4.7054E-02_JPRB,6.1726E-02_JPRB/)
KAO( :, 4, 4,12) = (/&
&7.7283E-02_JPRB,6.7685E-02_JPRB,6.4408E-02_JPRB,6.0620E-02_JPRB,5.6689E-02_JPRB,5.6675E-02_JPRB,&
&5.7994E-02_JPRB,6.1679E-02_JPRB,8.0866E-02_JPRB/)
KAO( :, 5, 4,12) = (/&
&8.8418E-02_JPRB,7.8061E-02_JPRB,7.5140E-02_JPRB,7.1155E-02_JPRB,6.8119E-02_JPRB,7.0861E-02_JPRB,&
&7.3683E-02_JPRB,7.9503E-02_JPRB,1.0285E-01_JPRB/)
KAO( :, 1, 5,12) = (/&
&3.9662E-02_JPRB,3.4731E-02_JPRB,3.1644E-02_JPRB,2.8938E-02_JPRB,2.6745E-02_JPRB,2.3268E-02_JPRB,&
&2.1825E-02_JPRB,2.0476E-02_JPRB,2.7392E-02_JPRB/)
KAO( :, 2, 5,12) = (/&
&4.9795E-02_JPRB,4.3597E-02_JPRB,4.0424E-02_JPRB,3.7076E-02_JPRB,3.4194E-02_JPRB,3.1021E-02_JPRB,&
&3.0623E-02_JPRB,2.9562E-02_JPRB,3.9492E-02_JPRB/)
KAO( :, 3, 5,12) = (/&
&6.0584E-02_JPRB,5.3042E-02_JPRB,4.9894E-02_JPRB,4.6289E-02_JPRB,4.2817E-02_JPRB,4.0884E-02_JPRB,&
&4.1181E-02_JPRB,4.1314E-02_JPRB,5.4083E-02_JPRB/)
KAO( :, 4, 5,12) = (/&
&7.1810E-02_JPRB,6.2970E-02_JPRB,6.0288E-02_JPRB,5.6611E-02_JPRB,5.2417E-02_JPRB,5.2364E-02_JPRB,&
&5.3447E-02_JPRB,5.4733E-02_JPRB,7.1895E-02_JPRB/)
KAO( :, 5, 5,12) = (/&
&8.3191E-02_JPRB,7.3693E-02_JPRB,7.1136E-02_JPRB,6.7175E-02_JPRB,6.3303E-02_JPRB,6.5794E-02_JPRB,&
&6.8047E-02_JPRB,7.1167E-02_JPRB,9.3099E-02_JPRB/)
KAO( :, 1, 6,12) = (/&
&3.4073E-02_JPRB,2.9970E-02_JPRB,2.7448E-02_JPRB,2.5187E-02_JPRB,2.3238E-02_JPRB,2.0151E-02_JPRB,&
&1.8356E-02_JPRB,1.7087E-02_JPRB,2.1825E-02_JPRB/)
KAO( :, 2, 6,12) = (/&
&4.3805E-02_JPRB,3.8540E-02_JPRB,3.5809E-02_JPRB,3.2989E-02_JPRB,3.0183E-02_JPRB,2.7066E-02_JPRB,&
&2.6460E-02_JPRB,2.5241E-02_JPRB,3.2266E-02_JPRB/)
KAO( :, 3, 6,12) = (/&
&5.4408E-02_JPRB,4.7827E-02_JPRB,4.4959E-02_JPRB,4.1832E-02_JPRB,3.8412E-02_JPRB,3.6156E-02_JPRB,&
&3.6616E-02_JPRB,3.5630E-02_JPRB,4.5299E-02_JPRB/)
KAO( :, 4, 6,12) = (/&
&6.5566E-02_JPRB,5.7738E-02_JPRB,5.4996E-02_JPRB,5.1938E-02_JPRB,4.7753E-02_JPRB,4.7435E-02_JPRB,&
&4.8559E-02_JPRB,4.8244E-02_JPRB,6.1467E-02_JPRB/)
KAO( :, 5, 6,12) = (/&
&7.7055E-02_JPRB,6.8635E-02_JPRB,6.5830E-02_JPRB,6.2404E-02_JPRB,5.8371E-02_JPRB,6.0640E-02_JPRB,&
&6.2553E-02_JPRB,6.3410E-02_JPRB,8.1734E-02_JPRB/)
KAO( :, 1, 7,12) = (/&
&2.8703E-02_JPRB,2.5583E-02_JPRB,2.3276E-02_JPRB,2.1697E-02_JPRB,1.9747E-02_JPRB,1.7089E-02_JPRB,&
&1.5072E-02_JPRB,1.3835E-02_JPRB,1.6883E-02_JPRB/)
KAO( :, 2, 7,12) = (/&
&3.7935E-02_JPRB,3.3728E-02_JPRB,3.1173E-02_JPRB,2.9047E-02_JPRB,2.6304E-02_JPRB,2.3254E-02_JPRB,&
&2.2495E-02_JPRB,2.1233E-02_JPRB,2.5258E-02_JPRB/)
KAO( :, 3, 7,12) = (/&
&4.8109E-02_JPRB,4.2733E-02_JPRB,3.9875E-02_JPRB,3.7411E-02_JPRB,3.4221E-02_JPRB,3.1727E-02_JPRB,&
&3.2013E-02_JPRB,3.0954E-02_JPRB,3.6228E-02_JPRB/)
KAO( :, 4, 7,12) = (/&
&5.9015E-02_JPRB,5.2712E-02_JPRB,4.9724E-02_JPRB,4.7098E-02_JPRB,4.3201E-02_JPRB,4.2396E-02_JPRB,&
&4.3420E-02_JPRB,4.2821E-02_JPRB,5.0322E-02_JPRB/)
KAO( :, 5, 7,12) = (/&
&7.0562E-02_JPRB,6.3765E-02_JPRB,6.0647E-02_JPRB,5.7324E-02_JPRB,5.3581E-02_JPRB,5.4932E-02_JPRB,&
&5.6750E-02_JPRB,5.6861E-02_JPRB,6.8648E-02_JPRB/)
KAO( :, 1, 8,12) = (/&
&2.3797E-02_JPRB,2.1507E-02_JPRB,1.9481E-02_JPRB,1.8328E-02_JPRB,1.6567E-02_JPRB,1.4195E-02_JPRB,&
&1.2226E-02_JPRB,1.1084E-02_JPRB,1.2769E-02_JPRB/)
KAO( :, 2, 8,12) = (/&
&3.2290E-02_JPRB,2.9132E-02_JPRB,2.6787E-02_JPRB,2.5154E-02_JPRB,2.2698E-02_JPRB,1.9789E-02_JPRB,&
&1.8738E-02_JPRB,1.7668E-02_JPRB,1.9523E-02_JPRB/)
KAO( :, 3, 8,12) = (/&
&4.1971E-02_JPRB,3.7809E-02_JPRB,3.5153E-02_JPRB,3.3039E-02_JPRB,3.0227E-02_JPRB,2.7550E-02_JPRB,&
&2.7403E-02_JPRB,2.6633E-02_JPRB,2.8356E-02_JPRB/)
KAO( :, 4, 8,12) = (/&
&5.2643E-02_JPRB,4.7711E-02_JPRB,4.4776E-02_JPRB,4.2382E-02_JPRB,3.8941E-02_JPRB,3.7160E-02_JPRB,&
&3.7962E-02_JPRB,3.7660E-02_JPRB,4.0067E-02_JPRB/)
KAO( :, 5, 8,12) = (/&
&6.4120E-02_JPRB,5.8657E-02_JPRB,5.5707E-02_JPRB,5.2735E-02_JPRB,4.8989E-02_JPRB,4.8789E-02_JPRB,&
&5.0472E-02_JPRB,5.0598E-02_JPRB,5.5953E-02_JPRB/)
KAO( :, 1, 9,12) = (/&
&1.9250E-02_JPRB,1.7588E-02_JPRB,1.6042E-02_JPRB,1.5146E-02_JPRB,1.3631E-02_JPRB,1.1686E-02_JPRB,&
&9.9858E-03_JPRB,8.6677E-03_JPRB,2.1707E-02_JPRB/)
KAO( :, 2, 9,12) = (/&
&2.7012E-02_JPRB,2.4595E-02_JPRB,2.2809E-02_JPRB,2.1369E-02_JPRB,1.9226E-02_JPRB,1.6776E-02_JPRB,&
&1.5292E-02_JPRB,1.4425E-02_JPRB,2.4366E-02_JPRB/)
KAO( :, 3, 9,12) = (/&
&3.6057E-02_JPRB,3.2810E-02_JPRB,3.0756E-02_JPRB,2.8820E-02_JPRB,2.6287E-02_JPRB,2.3677E-02_JPRB,&
&2.2692E-02_JPRB,2.2334E-02_JPRB,2.7809E-02_JPRB/)
KAO( :, 4, 9,12) = (/&
&4.6276E-02_JPRB,4.2323E-02_JPRB,4.0041E-02_JPRB,3.7778E-02_JPRB,3.4895E-02_JPRB,3.2122E-02_JPRB,&
&3.2057E-02_JPRB,3.2163E-02_JPRB,3.3773E-02_JPRB/)
KAO( :, 5, 9,12) = (/&
&5.7287E-02_JPRB,5.2928E-02_JPRB,5.0545E-02_JPRB,4.8124E-02_JPRB,4.4442E-02_JPRB,4.2249E-02_JPRB,&
&4.3334E-02_JPRB,4.4067E-02_JPRB,4.5714E-02_JPRB/)
KAO( :, 1,10,12) = (/&
&1.5724E-02_JPRB,1.4480E-02_JPRB,1.3399E-02_JPRB,1.2607E-02_JPRB,1.1371E-02_JPRB,9.8756E-03_JPRB,&
&8.2202E-03_JPRB,7.0920E-03_JPRB,1.5327E-01_JPRB/)
KAO( :, 2,10,12) = (/&
&2.2742E-02_JPRB,2.0839E-02_JPRB,1.9648E-02_JPRB,1.8330E-02_JPRB,1.6472E-02_JPRB,1.4615E-02_JPRB,&
&1.2794E-02_JPRB,1.2185E-02_JPRB,1.5107E-01_JPRB/)
KAO( :, 3,10,12) = (/&
&3.1111E-02_JPRB,2.8526E-02_JPRB,2.7137E-02_JPRB,2.5313E-02_JPRB,2.3236E-02_JPRB,2.0664E-02_JPRB,&
&1.8952E-02_JPRB,1.8782E-02_JPRB,1.5057E-01_JPRB/)
KAO( :, 4,10,12) = (/&
&4.0637E-02_JPRB,3.7549E-02_JPRB,3.5922E-02_JPRB,3.3978E-02_JPRB,3.1652E-02_JPRB,2.8132E-02_JPRB,&
&2.7006E-02_JPRB,2.7319E-02_JPRB,1.5207E-01_JPRB/)
KAO( :, 5,10,12) = (/&
&5.1227E-02_JPRB,4.7699E-02_JPRB,4.6069E-02_JPRB,4.4170E-02_JPRB,4.0891E-02_JPRB,3.7225E-02_JPRB,&
&3.7060E-02_JPRB,3.8071E-02_JPRB,1.5409E-01_JPRB/)
KAO( :, 1,11,12) = (/&
&1.5555E-02_JPRB,1.4241E-02_JPRB,1.3404E-02_JPRB,1.2541E-02_JPRB,1.1360E-02_JPRB,1.0012E-02_JPRB,&
&8.3342E-03_JPRB,7.3523E-03_JPRB,4.1658E-01_JPRB/)
KAO( :, 2,11,12) = (/&
&2.2569E-02_JPRB,2.0619E-02_JPRB,1.9629E-02_JPRB,1.8217E-02_JPRB,1.6713E-02_JPRB,1.4923E-02_JPRB,&
&1.2799E-02_JPRB,1.2337E-02_JPRB,4.0531E-01_JPRB/)
KAO( :, 3,11,12) = (/&
&3.1003E-02_JPRB,2.8414E-02_JPRB,2.7101E-02_JPRB,2.5438E-02_JPRB,2.3803E-02_JPRB,2.0993E-02_JPRB,&
&1.8716E-02_JPRB,1.8686E-02_JPRB,3.9474E-01_JPRB/)
KAO( :, 4,11,12) = (/&
&4.0722E-02_JPRB,3.7543E-02_JPRB,3.5908E-02_JPRB,3.4570E-02_JPRB,3.2168E-02_JPRB,2.8356E-02_JPRB,&
&2.6227E-02_JPRB,2.6848E-02_JPRB,3.8831E-01_JPRB/)
KAO( :, 5,11,12) = (/&
&5.1560E-02_JPRB,4.7783E-02_JPRB,4.6376E-02_JPRB,4.5061E-02_JPRB,4.1670E-02_JPRB,3.7328E-02_JPRB,&
&3.5965E-02_JPRB,3.7251E-02_JPRB,3.8125E-01_JPRB/)
KAO( :, 1,12,12) = (/&
&1.5830E-02_JPRB,1.4387E-02_JPRB,1.3516E-02_JPRB,1.2418E-02_JPRB,1.1346E-02_JPRB,1.0079E-02_JPRB,&
&8.3729E-03_JPRB,7.3472E-03_JPRB,7.1942E-01_JPRB/)
KAO( :, 2,12,12) = (/&
&2.3055E-02_JPRB,2.0962E-02_JPRB,1.9738E-02_JPRB,1.8144E-02_JPRB,1.6929E-02_JPRB,1.5067E-02_JPRB,&
&1.2702E-02_JPRB,1.1955E-02_JPRB,6.9772E-01_JPRB/)
KAO( :, 3,12,12) = (/&
&3.1847E-02_JPRB,2.9081E-02_JPRB,2.7322E-02_JPRB,2.5612E-02_JPRB,2.3940E-02_JPRB,2.1303E-02_JPRB,&
&1.8481E-02_JPRB,1.8181E-02_JPRB,6.7687E-01_JPRB/)
KAO( :, 4,12,12) = (/&
&4.1961E-02_JPRB,3.8413E-02_JPRB,3.6388E-02_JPRB,3.4886E-02_JPRB,3.2236E-02_JPRB,2.8808E-02_JPRB,&
&2.5797E-02_JPRB,2.6077E-02_JPRB,6.5603E-01_JPRB/)
KAO( :, 5,12,12) = (/&
&5.3319E-02_JPRB,4.9117E-02_JPRB,4.7169E-02_JPRB,4.5236E-02_JPRB,4.1943E-02_JPRB,3.7873E-02_JPRB,&
&3.5355E-02_JPRB,3.6412E-02_JPRB,6.4190E-01_JPRB/)
KAO( :, 1,13,12) = (/&
&1.6495E-02_JPRB,1.4909E-02_JPRB,1.3825E-02_JPRB,1.2544E-02_JPRB,1.1340E-02_JPRB,9.9975E-03_JPRB,&
&8.3433E-03_JPRB,7.0546E-03_JPRB,9.9911E-01_JPRB/)
KAO( :, 2,13,12) = (/&
&2.4109E-02_JPRB,2.1885E-02_JPRB,2.0210E-02_JPRB,1.8488E-02_JPRB,1.6936E-02_JPRB,1.4953E-02_JPRB,&
&1.2660E-02_JPRB,1.1467E-02_JPRB,9.6984E-01_JPRB/)
KAO( :, 3,13,12) = (/&
&3.3220E-02_JPRB,3.0296E-02_JPRB,2.8083E-02_JPRB,2.6185E-02_JPRB,2.3860E-02_JPRB,2.1223E-02_JPRB,&
&1.8346E-02_JPRB,1.7437E-02_JPRB,9.3888E-01_JPRB/)
KAO( :, 4,13,12) = (/&
&4.3831E-02_JPRB,4.0158E-02_JPRB,3.7697E-02_JPRB,3.5285E-02_JPRB,3.2116E-02_JPRB,2.8881E-02_JPRB,&
&2.5602E-02_JPRB,2.5164E-02_JPRB,9.0808E-01_JPRB/)
KAO( :, 5,13,12) = (/&
&5.5677E-02_JPRB,5.1368E-02_JPRB,4.8923E-02_JPRB,4.5702E-02_JPRB,4.1832E-02_JPRB,3.8470E-02_JPRB,&
&3.5318E-02_JPRB,3.5646E-02_JPRB,8.8465E-01_JPRB/)
KAO( :, 1, 1,13) = (/&
&7.2506E-02_JPRB,6.3446E-02_JPRB,5.4408E-02_JPRB,4.7483E-02_JPRB,4.2382E-02_JPRB,4.1239E-02_JPRB,&
&4.3386E-02_JPRB,4.4074E-02_JPRB,6.4271E-02_JPRB/)
KAO( :, 2, 1,13) = (/&
&8.4465E-02_JPRB,7.3953E-02_JPRB,6.3427E-02_JPRB,5.6900E-02_JPRB,5.2376E-02_JPRB,5.3648E-02_JPRB,&
&5.8354E-02_JPRB,5.9101E-02_JPRB,8.6583E-02_JPRB/)
KAO( :, 3, 1,13) = (/&
&9.6444E-02_JPRB,8.4439E-02_JPRB,7.3063E-02_JPRB,6.7601E-02_JPRB,6.5429E-02_JPRB,6.9474E-02_JPRB,&
&7.7817E-02_JPRB,8.1204E-02_JPRB,1.1413E-01_JPRB/)
KAO( :, 4, 1,13) = (/&
&1.0833E-01_JPRB,9.4864E-02_JPRB,8.5278E-02_JPRB,7.9673E-02_JPRB,8.1089E-02_JPRB,9.1367E-02_JPRB,&
&1.0434E-01_JPRB,1.1177E-01_JPRB,1.4904E-01_JPRB/)
KAO( :, 5, 1,13) = (/&
&1.1980E-01_JPRB,1.0493E-01_JPRB,9.6406E-02_JPRB,9.4783E-02_JPRB,1.0132E-01_JPRB,1.1971E-01_JPRB,&
&1.3809E-01_JPRB,1.4964E-01_JPRB,1.9375E-01_JPRB/)
KAO( :, 1, 2,13) = (/&
&7.1478E-02_JPRB,6.2570E-02_JPRB,5.3664E-02_JPRB,4.6754E-02_JPRB,4.2681E-02_JPRB,4.1156E-02_JPRB,&
&4.2008E-02_JPRB,4.2483E-02_JPRB,6.2959E-02_JPRB/)
KAO( :, 2, 2,13) = (/&
&8.4247E-02_JPRB,7.3747E-02_JPRB,6.3249E-02_JPRB,5.6233E-02_JPRB,5.3534E-02_JPRB,5.3727E-02_JPRB,&
&5.7468E-02_JPRB,5.8178E-02_JPRB,8.6328E-02_JPRB/)
KAO( :, 3, 2,13) = (/&
&9.6812E-02_JPRB,8.4747E-02_JPRB,7.4116E-02_JPRB,6.7508E-02_JPRB,6.6781E-02_JPRB,6.9983E-02_JPRB,&
&7.6767E-02_JPRB,7.7852E-02_JPRB,1.1485E-01_JPRB/)
KAO( :, 4, 2,13) = (/&
&1.0887E-01_JPRB,9.5297E-02_JPRB,8.6108E-02_JPRB,8.0754E-02_JPRB,8.2919E-02_JPRB,8.8967E-02_JPRB,&
&1.0013E-01_JPRB,1.0496E-01_JPRB,1.4738E-01_JPRB/)
KAO( :, 5, 2,13) = (/&
&1.2040E-01_JPRB,1.0544E-01_JPRB,9.8262E-02_JPRB,9.7024E-02_JPRB,1.0128E-01_JPRB,1.1389E-01_JPRB,&
&1.3047E-01_JPRB,1.4126E-01_JPRB,1.8810E-01_JPRB/)
KAO( :, 1, 3,13) = (/&
&6.7428E-02_JPRB,5.9012E-02_JPRB,5.0600E-02_JPRB,4.4820E-02_JPRB,4.0284E-02_JPRB,3.8905E-02_JPRB,&
&3.8433E-02_JPRB,3.8221E-02_JPRB,5.7695E-02_JPRB/)
KAO( :, 2, 3,13) = (/&
&8.0097E-02_JPRB,7.0092E-02_JPRB,6.0231E-02_JPRB,5.4560E-02_JPRB,5.1238E-02_JPRB,5.1427E-02_JPRB,&
&5.2635E-02_JPRB,5.3599E-02_JPRB,7.9873E-02_JPRB/)
KAO( :, 3, 3,13) = (/&
&9.2835E-02_JPRB,8.1288E-02_JPRB,7.1303E-02_JPRB,6.5788E-02_JPRB,6.5168E-02_JPRB,6.7196E-02_JPRB,&
&7.1689E-02_JPRB,7.2641E-02_JPRB,1.0771E-01_JPRB/)
KAO( :, 4, 3,13) = (/&
&1.0559E-01_JPRB,9.2480E-02_JPRB,8.3299E-02_JPRB,7.8616E-02_JPRB,8.1678E-02_JPRB,8.5882E-02_JPRB,&
&9.4318E-02_JPRB,9.6259E-02_JPRB,1.4043E-01_JPRB/)
KAO( :, 5, 3,13) = (/&
&1.1824E-01_JPRB,1.0358E-01_JPRB,9.6455E-02_JPRB,9.5066E-02_JPRB,9.9972E-02_JPRB,1.0747E-01_JPRB,&
&1.2012E-01_JPRB,1.2676E-01_JPRB,1.7816E-01_JPRB/)
KAO( :, 1, 4,13) = (/&
&6.1574E-02_JPRB,5.3893E-02_JPRB,4.6221E-02_JPRB,4.1581E-02_JPRB,3.7011E-02_JPRB,3.6135E-02_JPRB,&
&3.5573E-02_JPRB,3.4371E-02_JPRB,5.0320E-02_JPRB/)
KAO( :, 2, 4,13) = (/&
&7.4469E-02_JPRB,6.5196E-02_JPRB,5.6073E-02_JPRB,5.1353E-02_JPRB,4.7821E-02_JPRB,4.7971E-02_JPRB,&
&4.8104E-02_JPRB,4.8151E-02_JPRB,7.0598E-02_JPRB/)
KAO( :, 3, 4,13) = (/&
&8.7893E-02_JPRB,7.6969E-02_JPRB,6.7380E-02_JPRB,6.2778E-02_JPRB,6.1745E-02_JPRB,6.3327E-02_JPRB,&
&6.5251E-02_JPRB,6.6605E-02_JPRB,9.6688E-02_JPRB/)
KAO( :, 4, 4,13) = (/&
&1.0128E-01_JPRB,8.8666E-02_JPRB,7.9558E-02_JPRB,7.6113E-02_JPRB,7.8711E-02_JPRB,8.2067E-02_JPRB,&
&8.7118E-02_JPRB,8.9685E-02_JPRB,1.2734E-01_JPRB/)
KAO( :, 5, 4,13) = (/&
&1.1397E-01_JPRB,9.9791E-02_JPRB,9.3095E-02_JPRB,9.2358E-02_JPRB,9.7817E-02_JPRB,1.0283E-01_JPRB,&
&1.1271E-01_JPRB,1.1615E-01_JPRB,1.6394E-01_JPRB/)
KAO( :, 1, 5,13) = (/&
&5.5644E-02_JPRB,4.8706E-02_JPRB,4.2042E-02_JPRB,3.7730E-02_JPRB,3.3816E-02_JPRB,3.3296E-02_JPRB,&
&3.2567E-02_JPRB,3.1307E-02_JPRB,4.2852E-02_JPRB/)
KAO( :, 2, 5,13) = (/&
&6.8700E-02_JPRB,6.0145E-02_JPRB,5.2078E-02_JPRB,4.7465E-02_JPRB,4.4257E-02_JPRB,4.4542E-02_JPRB,&
&4.3904E-02_JPRB,4.3555E-02_JPRB,6.1397E-02_JPRB/)
KAO( :, 3, 5,13) = (/&
&8.2079E-02_JPRB,7.1842E-02_JPRB,6.3336E-02_JPRB,5.8826E-02_JPRB,5.7771E-02_JPRB,5.9150E-02_JPRB,&
&5.9615E-02_JPRB,6.0276E-02_JPRB,8.5213E-02_JPRB/)
KAO( :, 4, 5,13) = (/&
&9.5395E-02_JPRB,8.3509E-02_JPRB,7.5491E-02_JPRB,7.2428E-02_JPRB,7.4615E-02_JPRB,7.7323E-02_JPRB,&
&7.9697E-02_JPRB,8.2375E-02_JPRB,1.1408E-01_JPRB/)
KAO( :, 5, 5,13) = (/&
&1.0879E-01_JPRB,9.5224E-02_JPRB,8.9008E-02_JPRB,8.9139E-02_JPRB,9.4277E-02_JPRB,9.8162E-02_JPRB,&
&1.0347E-01_JPRB,1.0938E-01_JPRB,1.4850E-01_JPRB/)
KAO( :, 1, 6,13) = (/&
&4.9166E-02_JPRB,4.3032E-02_JPRB,3.7697E-02_JPRB,3.3418E-02_JPRB,3.0271E-02_JPRB,2.9707E-02_JPRB,&
&2.8739E-02_JPRB,2.7107E-02_JPRB,3.5180E-02_JPRB/)
KAO( :, 2, 6,13) = (/&
&6.1802E-02_JPRB,5.4091E-02_JPRB,4.7585E-02_JPRB,4.2912E-02_JPRB,4.0335E-02_JPRB,4.0310E-02_JPRB,&
&3.9360E-02_JPRB,3.8194E-02_JPRB,5.1590E-02_JPRB/)
KAO( :, 3, 6,13) = (/&
&7.4933E-02_JPRB,6.5583E-02_JPRB,5.8743E-02_JPRB,5.3925E-02_JPRB,5.3041E-02_JPRB,5.4106E-02_JPRB,&
&5.3825E-02_JPRB,5.3725E-02_JPRB,7.3865E-02_JPRB/)
KAO( :, 4, 6,13) = (/&
&8.8794E-02_JPRB,7.7714E-02_JPRB,7.0892E-02_JPRB,6.7266E-02_JPRB,6.9411E-02_JPRB,7.1602E-02_JPRB,&
&7.2167E-02_JPRB,7.4198E-02_JPRB,1.0072E-01_JPRB/)
KAO( :, 5, 6,13) = (/&
&1.0284E-01_JPRB,9.0019E-02_JPRB,8.4346E-02_JPRB,8.3697E-02_JPRB,8.8853E-02_JPRB,9.1618E-02_JPRB,&
&9.4095E-02_JPRB,9.9493E-02_JPRB,1.3200E-01_JPRB/)
KAO( :, 1, 7,13) = (/&
&4.2481E-02_JPRB,3.7182E-02_JPRB,3.2941E-02_JPRB,2.9053E-02_JPRB,2.6729E-02_JPRB,2.5857E-02_JPRB,&
&2.4817E-02_JPRB,2.3036E-02_JPRB,2.8513E-02_JPRB/)
KAO( :, 2, 7,13) = (/&
&5.4646E-02_JPRB,4.7829E-02_JPRB,4.2493E-02_JPRB,3.8260E-02_JPRB,3.6179E-02_JPRB,3.5843E-02_JPRB,&
&3.4675E-02_JPRB,3.3090E-02_JPRB,4.3061E-02_JPRB/)
KAO( :, 3, 7,13) = (/&
&6.7949E-02_JPRB,5.9473E-02_JPRB,5.3629E-02_JPRB,4.8997E-02_JPRB,4.7960E-02_JPRB,4.8517E-02_JPRB,&
&4.7980E-02_JPRB,4.6686E-02_JPRB,6.3225E-02_JPRB/)
KAO( :, 4, 7,13) = (/&
&8.2011E-02_JPRB,7.1775E-02_JPRB,6.5638E-02_JPRB,6.1779E-02_JPRB,6.3457E-02_JPRB,6.4989E-02_JPRB,&
&6.5420E-02_JPRB,6.5338E-02_JPRB,8.8114E-02_JPRB/)
KAO( :, 5, 7,13) = (/&
&9.6121E-02_JPRB,8.4118E-02_JPRB,7.9080E-02_JPRB,7.7840E-02_JPRB,8.2099E-02_JPRB,8.4733E-02_JPRB,&
&8.6013E-02_JPRB,8.9165E-02_JPRB,1.1782E-01_JPRB/)
KAO( :, 1, 8,13) = (/&
&3.6137E-02_JPRB,3.1658E-02_JPRB,2.8232E-02_JPRB,2.4974E-02_JPRB,2.3118E-02_JPRB,2.2088E-02_JPRB,&
&2.1064E-02_JPRB,1.9376E-02_JPRB,2.2745E-02_JPRB/)
KAO( :, 2, 8,13) = (/&
&4.8016E-02_JPRB,4.2076E-02_JPRB,3.7504E-02_JPRB,3.3789E-02_JPRB,3.1931E-02_JPRB,3.1218E-02_JPRB,&
&3.0077E-02_JPRB,2.8144E-02_JPRB,3.5232E-02_JPRB/)
KAO( :, 3, 8,13) = (/&
&6.1205E-02_JPRB,5.3668E-02_JPRB,4.8373E-02_JPRB,4.4145E-02_JPRB,4.2766E-02_JPRB,4.3001E-02_JPRB,&
&4.2234E-02_JPRB,4.0332E-02_JPRB,5.3276E-02_JPRB/)
KAO( :, 4, 8,13) = (/&
&7.5025E-02_JPRB,6.5801E-02_JPRB,6.0176E-02_JPRB,5.6410E-02_JPRB,5.7125E-02_JPRB,5.8703E-02_JPRB,&
&5.8721E-02_JPRB,5.7394E-02_JPRB,7.6141E-02_JPRB/)
KAO( :, 5, 8,13) = (/&
&8.9588E-02_JPRB,7.8614E-02_JPRB,7.3265E-02_JPRB,7.1609E-02_JPRB,7.4944E-02_JPRB,7.7845E-02_JPRB,&
&7.8817E-02_JPRB,7.9234E-02_JPRB,1.0406E-01_JPRB/)
KAO( :, 1, 9,13) = (/&
&3.0354E-02_JPRB,2.6812E-02_JPRB,2.3806E-02_JPRB,2.1190E-02_JPRB,1.9445E-02_JPRB,1.8240E-02_JPRB,&
&1.7300E-02_JPRB,1.5970E-02_JPRB,2.7469E-02_JPRB/)
KAO( :, 2, 9,13) = (/&
&4.1683E-02_JPRB,3.6828E-02_JPRB,3.2679E-02_JPRB,2.9622E-02_JPRB,2.7586E-02_JPRB,2.6377E-02_JPRB,&
&2.5396E-02_JPRB,2.3781E-02_JPRB,3.1985E-02_JPRB/)
KAO( :, 3, 9,13) = (/&
&5.4431E-02_JPRB,4.8107E-02_JPRB,4.3192E-02_JPRB,3.9529E-02_JPRB,3.7624E-02_JPRB,3.7195E-02_JPRB,&
&3.6607E-02_JPRB,3.4524E-02_JPRB,4.4340E-02_JPRB/)
KAO( :, 4, 9,13) = (/&
&6.8321E-02_JPRB,6.0391E-02_JPRB,5.4610E-02_JPRB,5.1211E-02_JPRB,5.0615E-02_JPRB,5.1938E-02_JPRB,&
&5.2206E-02_JPRB,5.0002E-02_JPRB,6.4376E-02_JPRB/)
KAO( :, 5, 9,13) = (/&
&8.3382E-02_JPRB,7.3864E-02_JPRB,6.7608E-02_JPRB,6.5416E-02_JPRB,6.7796E-02_JPRB,7.0544E-02_JPRB,&
&7.1581E-02_JPRB,7.0367E-02_JPRB,8.9820E-02_JPRB/)
KAO( :, 1,10,13) = (/&
&2.5866E-02_JPRB,2.3096E-02_JPRB,2.0359E-02_JPRB,1.8244E-02_JPRB,1.6555E-02_JPRB,1.5241E-02_JPRB,&
&1.4537E-02_JPRB,1.3197E-02_JPRB,1.8207E-01_JPRB/)
KAO( :, 2,10,13) = (/&
&3.6597E-02_JPRB,3.2659E-02_JPRB,2.8899E-02_JPRB,2.6262E-02_JPRB,2.4046E-02_JPRB,2.2449E-02_JPRB,&
&2.1774E-02_JPRB,2.0251E-02_JPRB,1.8269E-01_JPRB/)
KAO( :, 3,10,13) = (/&
&4.8990E-02_JPRB,4.3688E-02_JPRB,3.9094E-02_JPRB,3.5827E-02_JPRB,3.3277E-02_JPRB,3.2592E-02_JPRB,&
&3.2234E-02_JPRB,3.0480E-02_JPRB,1.8337E-01_JPRB/)
KAO( :, 4,10,13) = (/&
&6.3031E-02_JPRB,5.6150E-02_JPRB,5.0614E-02_JPRB,4.7098E-02_JPRB,4.5295E-02_JPRB,4.6573E-02_JPRB,&
&4.6974E-02_JPRB,4.5107E-02_JPRB,1.8526E-01_JPRB/)
KAO( :, 5,10,13) = (/&
&7.8337E-02_JPRB,7.0036E-02_JPRB,6.3907E-02_JPRB,6.0875E-02_JPRB,6.1588E-02_JPRB,6.4404E-02_JPRB,&
&6.5574E-02_JPRB,6.4038E-02_JPRB,1.9009E-01_JPRB/)
KAO( :, 1,11,13) = (/&
&2.6170E-02_JPRB,2.3547E-02_JPRB,2.0835E-02_JPRB,1.8825E-02_JPRB,1.6889E-02_JPRB,1.5401E-02_JPRB,&
&1.4727E-02_JPRB,1.3614E-02_JPRB,5.0818E-01_JPRB/)
KAO( :, 2,11,13) = (/&
&3.7087E-02_JPRB,3.3315E-02_JPRB,2.9858E-02_JPRB,2.7151E-02_JPRB,2.4450E-02_JPRB,2.2833E-02_JPRB,&
&2.2404E-02_JPRB,2.1001E-02_JPRB,5.0103E-01_JPRB/)
KAO( :, 3,11,13) = (/&
&4.9963E-02_JPRB,4.4837E-02_JPRB,4.0625E-02_JPRB,3.7044E-02_JPRB,3.4135E-02_JPRB,3.3574E-02_JPRB,&
&3.3602E-02_JPRB,3.2090E-02_JPRB,4.9194E-01_JPRB/)
KAO( :, 4,11,13) = (/&
&6.4516E-02_JPRB,5.7977E-02_JPRB,5.3206E-02_JPRB,4.8937E-02_JPRB,4.7272E-02_JPRB,4.8448E-02_JPRB,&
&4.9192E-02_JPRB,4.7870E-02_JPRB,4.8323E-01_JPRB/)
KAO( :, 5,11,13) = (/&
&8.0357E-02_JPRB,7.2810E-02_JPRB,6.7423E-02_JPRB,6.3846E-02_JPRB,6.4063E-02_JPRB,6.6805E-02_JPRB,&
&6.8458E-02_JPRB,6.7693E-02_JPRB,4.8224E-01_JPRB/)
KAO( :, 1,12,13) = (/&
&2.6382E-02_JPRB,2.3869E-02_JPRB,2.1423E-02_JPRB,1.9530E-02_JPRB,1.7276E-02_JPRB,1.5597E-02_JPRB,&
&1.4852E-02_JPRB,1.3926E-02_JPRB,8.8613E-01_JPRB/)
KAO( :, 2,12,13) = (/&
&3.7554E-02_JPRB,3.3911E-02_JPRB,3.0989E-02_JPRB,2.8114E-02_JPRB,2.5051E-02_JPRB,2.3359E-02_JPRB,&
&2.2994E-02_JPRB,2.2005E-02_JPRB,8.7122E-01_JPRB/)
KAO( :, 3,12,13) = (/&
&5.0689E-02_JPRB,4.5835E-02_JPRB,4.2372E-02_JPRB,3.8639E-02_JPRB,3.5524E-02_JPRB,3.4470E-02_JPRB,&
&3.4752E-02_JPRB,3.3789E-02_JPRB,8.5297E-01_JPRB/)
KAO( :, 4,12,13) = (/&
&6.5611E-02_JPRB,5.9692E-02_JPRB,5.5677E-02_JPRB,5.1555E-02_JPRB,4.9587E-02_JPRB,4.9441E-02_JPRB,&
&5.0436E-02_JPRB,4.9926E-02_JPRB,8.3445E-01_JPRB/)
KAO( :, 5,12,13) = (/&
&8.2012E-02_JPRB,7.5239E-02_JPRB,7.1004E-02_JPRB,6.7701E-02_JPRB,6.6707E-02_JPRB,6.7915E-02_JPRB,&
&6.9915E-02_JPRB,7.0294E-02_JPRB,8.1920E-01_JPRB/)
KAO( :, 1,13,13) = (/&
&2.6411E-02_JPRB,2.4001E-02_JPRB,2.2003E-02_JPRB,2.0098E-02_JPRB,1.7783E-02_JPRB,1.5910E-02_JPRB,&
&1.4921E-02_JPRB,1.4266E-02_JPRB,1.2499E+00_JPRB/)
KAO( :, 2,13,13) = (/&
&3.7728E-02_JPRB,3.4235E-02_JPRB,3.1890E-02_JPRB,2.9069E-02_JPRB,2.6051E-02_JPRB,2.4137E-02_JPRB,&
&2.3431E-02_JPRB,2.2763E-02_JPRB,1.2233E+00_JPRB/)
KAO( :, 3,13,13) = (/&
&5.1168E-02_JPRB,4.6582E-02_JPRB,4.3725E-02_JPRB,4.0296E-02_JPRB,3.7356E-02_JPRB,3.5542E-02_JPRB,&
&3.5231E-02_JPRB,3.4850E-02_JPRB,1.1970E+00_JPRB/)
KAO( :, 4,13,13) = (/&
&6.6532E-02_JPRB,6.1023E-02_JPRB,5.7678E-02_JPRB,5.4658E-02_JPRB,5.1906E-02_JPRB,5.0202E-02_JPRB,&
&5.0477E-02_JPRB,5.0911E-02_JPRB,1.1702E+00_JPRB/)
KAO( :, 5,13,13) = (/&
&8.3713E-02_JPRB,7.7246E-02_JPRB,7.4186E-02_JPRB,7.1956E-02_JPRB,6.9311E-02_JPRB,6.8138E-02_JPRB,&
&6.9472E-02_JPRB,7.1080E-02_JPRB,1.1427E+00_JPRB/)
KAO( :, 1, 1,14) = (/&
&8.4406E-02_JPRB,7.3923E-02_JPRB,6.3390E-02_JPRB,5.3666E-02_JPRB,5.2956E-02_JPRB,5.5472E-02_JPRB,&
&6.0634E-02_JPRB,5.8813E-02_JPRB,9.2877E-02_JPRB/)
KAO( :, 2, 1,14) = (/&
&9.8373E-02_JPRB,8.6109E-02_JPRB,7.3836E-02_JPRB,6.7549E-02_JPRB,6.9431E-02_JPRB,7.7739E-02_JPRB,&
&8.6438E-02_JPRB,8.5388E-02_JPRB,1.3005E-01_JPRB/)
KAO( :, 3, 1,14) = (/&
&1.1220E-01_JPRB,9.8227E-02_JPRB,8.4237E-02_JPRB,8.6127E-02_JPRB,9.3558E-02_JPRB,1.1007E-01_JPRB,&
&1.2298E-01_JPRB,1.2120E-01_JPRB,1.8519E-01_JPRB/)
KAO( :, 4, 1,14) = (/&
&1.2589E-01_JPRB,1.1021E-01_JPRB,9.7341E-02_JPRB,1.0805E-01_JPRB,1.2702E-01_JPRB,1.5181E-01_JPRB,&
&1.6898E-01_JPRB,1.6664E-01_JPRB,2.5570E-01_JPRB/)
KAO( :, 5, 1,14) = (/&
&1.3898E-01_JPRB,1.2167E-01_JPRB,1.1790E-01_JPRB,1.3538E-01_JPRB,1.6936E-01_JPRB,2.0147E-01_JPRB,&
&2.2468E-01_JPRB,2.1901E-01_JPRB,3.4200E-01_JPRB/)
KAO( :, 1, 2,14) = (/&
&8.6965E-02_JPRB,7.6122E-02_JPRB,6.5271E-02_JPRB,5.5929E-02_JPRB,5.5266E-02_JPRB,5.6412E-02_JPRB,&
&6.1162E-02_JPRB,5.9084E-02_JPRB,9.4145E-02_JPRB/)
KAO( :, 2, 2,14) = (/&
&1.0214E-01_JPRB,8.9404E-02_JPRB,7.6670E-02_JPRB,7.1026E-02_JPRB,7.1152E-02_JPRB,7.6438E-02_JPRB,&
&8.4319E-02_JPRB,8.3198E-02_JPRB,1.2897E-01_JPRB/)
KAO( :, 3, 2,14) = (/&
&1.1758E-01_JPRB,1.0294E-01_JPRB,8.8300E-02_JPRB,9.0301E-02_JPRB,9.3552E-02_JPRB,1.0592E-01_JPRB,&
&1.1887E-01_JPRB,1.2017E-01_JPRB,1.7974E-01_JPRB/)
KAO( :, 4, 2,14) = (/&
&1.3321E-01_JPRB,1.1665E-01_JPRB,1.0423E-01_JPRB,1.1370E-01_JPRB,1.2505E-01_JPRB,1.4860E-01_JPRB,&
&1.6715E-01_JPRB,1.6784E-01_JPRB,2.5046E-01_JPRB/)
KAO( :, 5, 2,14) = (/&
&1.4865E-01_JPRB,1.3020E-01_JPRB,1.2666E-01_JPRB,1.3953E-01_JPRB,1.6682E-01_JPRB,2.0058E-01_JPRB,&
&2.2553E-01_JPRB,2.2565E-01_JPRB,3.3899E-01_JPRB/)
KAO( :, 1, 3,14) = (/&
&8.6079E-02_JPRB,7.5340E-02_JPRB,6.4607E-02_JPRB,5.5456E-02_JPRB,5.5272E-02_JPRB,5.5233E-02_JPRB,&
&5.8267E-02_JPRB,5.6783E-02_JPRB,8.9464E-02_JPRB/)
KAO( :, 2, 3,14) = (/&
&1.0304E-01_JPRB,9.0205E-02_JPRB,7.7348E-02_JPRB,7.0519E-02_JPRB,7.0862E-02_JPRB,7.2390E-02_JPRB,&
&7.8791E-02_JPRB,7.7229E-02_JPRB,1.2132E-01_JPRB/)
KAO( :, 3, 3,14) = (/&
&1.2050E-01_JPRB,1.0550E-01_JPRB,9.0628E-02_JPRB,8.9686E-02_JPRB,9.0578E-02_JPRB,9.7251E-02_JPRB,&
&1.0832E-01_JPRB,1.0857E-01_JPRB,1.6570E-01_JPRB/)
KAO( :, 4, 3,14) = (/&
&1.3798E-01_JPRB,1.2081E-01_JPRB,1.0757E-01_JPRB,1.1366E-01_JPRB,1.1771E-01_JPRB,1.3404E-01_JPRB,&
&1.5114E-01_JPRB,1.5446E-01_JPRB,2.2779E-01_JPRB/)
KAO( :, 5, 3,14) = (/&
&1.5527E-01_JPRB,1.3594E-01_JPRB,1.3049E-01_JPRB,1.4065E-01_JPRB,1.5498E-01_JPRB,1.8347E-01_JPRB,&
&2.0928E-01_JPRB,2.1357E-01_JPRB,3.1056E-01_JPRB/)
KAO( :, 1, 4,14) = (/&
&8.3658E-02_JPRB,7.3219E-02_JPRB,6.2782E-02_JPRB,5.4421E-02_JPRB,5.4252E-02_JPRB,5.2373E-02_JPRB,&
&5.2872E-02_JPRB,5.3249E-02_JPRB,8.1760E-02_JPRB/)
KAO( :, 2, 4,14) = (/&
&1.0179E-01_JPRB,8.9084E-02_JPRB,7.6372E-02_JPRB,6.9322E-02_JPRB,6.9646E-02_JPRB,6.9291E-02_JPRB,&
&7.2799E-02_JPRB,7.2370E-02_JPRB,1.1302E-01_JPRB/)
KAO( :, 3, 4,14) = (/&
&1.2055E-01_JPRB,1.0553E-01_JPRB,9.0925E-02_JPRB,8.8158E-02_JPRB,8.8997E-02_JPRB,9.0835E-02_JPRB,&
&9.8776E-02_JPRB,9.8752E-02_JPRB,1.5269E-01_JPRB/)
KAO( :, 4, 4,14) = (/&
&1.3976E-01_JPRB,1.2239E-01_JPRB,1.0872E-01_JPRB,1.1120E-01_JPRB,1.1304E-01_JPRB,1.2136E-01_JPRB,&
&1.3545E-01_JPRB,1.3720E-01_JPRB,2.0650E-01_JPRB/)
KAO( :, 5, 4,14) = (/&
&1.5964E-01_JPRB,1.3984E-01_JPRB,1.3154E-01_JPRB,1.3870E-01_JPRB,1.4428E-01_JPRB,1.6405E-01_JPRB,&
&1.8578E-01_JPRB,1.9371E-01_JPRB,2.7910E-01_JPRB/)
KAO( :, 1, 5,14) = (/&
&7.9613E-02_JPRB,6.9667E-02_JPRB,5.9735E-02_JPRB,5.2890E-02_JPRB,5.1672E-02_JPRB,4.9631E-02_JPRB,&
&4.7983E-02_JPRB,4.7891E-02_JPRB,7.3721E-02_JPRB/)
KAO( :, 2, 5,14) = (/&
&9.8444E-02_JPRB,8.6165E-02_JPRB,7.3879E-02_JPRB,6.8004E-02_JPRB,6.7906E-02_JPRB,6.5760E-02_JPRB,&
&6.6820E-02_JPRB,6.7095E-02_JPRB,1.0263E-01_JPRB/)
KAO( :, 3, 5,14) = (/&
&1.1874E-01_JPRB,1.0393E-01_JPRB,8.9653E-02_JPRB,8.6769E-02_JPRB,8.7048E-02_JPRB,8.6781E-02_JPRB,&
&9.1705E-02_JPRB,9.1503E-02_JPRB,1.4159E-01_JPRB/)
KAO( :, 4, 5,14) = (/&
&1.4009E-01_JPRB,1.2266E-01_JPRB,1.0834E-01_JPRB,1.0954E-01_JPRB,1.1083E-01_JPRB,1.1372E-01_JPRB,&
&1.2361E-01_JPRB,1.2496E-01_JPRB,1.9192E-01_JPRB/)
KAO( :, 5, 5,14) = (/&
&1.6191E-01_JPRB,1.4179E-01_JPRB,1.3132E-01_JPRB,1.3664E-01_JPRB,1.3962E-01_JPRB,1.5009E-01_JPRB,&
&1.6802E-01_JPRB,1.7246E-01_JPRB,2.5602E-01_JPRB/)
KAO( :, 1, 6,14) = (/&
&7.3321E-02_JPRB,6.4173E-02_JPRB,5.5115E-02_JPRB,5.0047E-02_JPRB,4.8003E-02_JPRB,4.5729E-02_JPRB,&
&4.3413E-02_JPRB,4.2157E-02_JPRB,6.5110E-02_JPRB/)
KAO( :, 2, 6,14) = (/&
&9.2952E-02_JPRB,8.1355E-02_JPRB,6.9976E-02_JPRB,6.5257E-02_JPRB,6.4561E-02_JPRB,6.2014E-02_JPRB,&
&6.0594E-02_JPRB,6.0655E-02_JPRB,9.1731E-02_JPRB/)
KAO( :, 3, 6,14) = (/&
&1.1439E-01_JPRB,1.0014E-01_JPRB,8.6575E-02_JPRB,8.3912E-02_JPRB,8.3786E-02_JPRB,8.2279E-02_JPRB,&
&8.3550E-02_JPRB,8.4201E-02_JPRB,1.2740E-01_JPRB/)
KAO( :, 4, 6,14) = (/&
&1.3703E-01_JPRB,1.1997E-01_JPRB,1.0601E-01_JPRB,1.0652E-01_JPRB,1.0715E-01_JPRB,1.0792E-01_JPRB,&
&1.1407E-01_JPRB,1.1447E-01_JPRB,1.7570E-01_JPRB/)
KAO( :, 5, 6,14) = (/&
&1.6047E-01_JPRB,1.4048E-01_JPRB,1.2948E-01_JPRB,1.3382E-01_JPRB,1.3571E-01_JPRB,1.4072E-01_JPRB,&
&1.5346E-01_JPRB,1.5557E-01_JPRB,2.3674E-01_JPRB/)
KAO( :, 1, 7,14) = (/&
&6.6096E-02_JPRB,5.7840E-02_JPRB,5.0291E-02_JPRB,4.6255E-02_JPRB,4.3749E-02_JPRB,4.1346E-02_JPRB,&
&3.9237E-02_JPRB,3.7187E-02_JPRB,5.6581E-02_JPRB/)
KAO( :, 2, 7,14) = (/&
&8.5997E-02_JPRB,7.5272E-02_JPRB,6.5564E-02_JPRB,6.1464E-02_JPRB,6.0084E-02_JPRB,5.7566E-02_JPRB,&
&5.5305E-02_JPRB,5.4415E-02_JPRB,8.1052E-02_JPRB/)
KAO( :, 3, 7,14) = (/&
&1.0792E-01_JPRB,9.4463E-02_JPRB,8.2746E-02_JPRB,8.0231E-02_JPRB,7.9656E-02_JPRB,7.7519E-02_JPRB,&
&7.6243E-02_JPRB,7.6636E-02_JPRB,1.1376E-01_JPRB/)
KAO( :, 4, 7,14) = (/&
&1.3147E-01_JPRB,1.1508E-01_JPRB,1.0289E-01_JPRB,1.0281E-01_JPRB,1.0321E-01_JPRB,1.0267E-01_JPRB,&
&1.0428E-01_JPRB,1.0618E-01_JPRB,1.5831E-01_JPRB/)
KAO( :, 5, 7,14) = (/&
&1.5658E-01_JPRB,1.3709E-01_JPRB,1.2648E-01_JPRB,1.2964E-01_JPRB,1.3186E-01_JPRB,1.3458E-01_JPRB,&
&1.4246E-01_JPRB,1.4352E-01_JPRB,2.1656E-01_JPRB/)
KAO( :, 1, 8,14) = (/&
&5.8400E-02_JPRB,5.1103E-02_JPRB,4.5168E-02_JPRB,4.1948E-02_JPRB,3.9253E-02_JPRB,3.7020E-02_JPRB,&
&3.5370E-02_JPRB,3.2290E-02_JPRB,4.8663E-02_JPRB/)
KAO( :, 2, 8,14) = (/&
&7.8005E-02_JPRB,6.8268E-02_JPRB,6.0453E-02_JPRB,5.7096E-02_JPRB,5.4905E-02_JPRB,5.3117E-02_JPRB,&
&5.0732E-02_JPRB,4.8891E-02_JPRB,7.1101E-02_JPRB/)
KAO( :, 3, 8,14) = (/&
&9.9991E-02_JPRB,8.7516E-02_JPRB,7.8019E-02_JPRB,7.5868E-02_JPRB,7.4621E-02_JPRB,7.2463E-02_JPRB,&
&7.0304E-02_JPRB,6.9569E-02_JPRB,1.0104E-01_JPRB/)
KAO( :, 4, 8,14) = (/&
&1.2410E-01_JPRB,1.0864E-01_JPRB,9.8489E-02_JPRB,9.8564E-02_JPRB,9.8094E-02_JPRB,9.6833E-02_JPRB,&
&9.6022E-02_JPRB,9.6830E-02_JPRB,1.4193E-01_JPRB/)
KAO( :, 5, 8,14) = (/&
&1.4968E-01_JPRB,1.3103E-01_JPRB,1.2227E-01_JPRB,1.2491E-01_JPRB,1.2710E-01_JPRB,1.2811E-01_JPRB,&
&1.3093E-01_JPRB,1.3351E-01_JPRB,1.9610E-01_JPRB/)
KAO( :, 1, 9,14) = (/&
&5.0397E-02_JPRB,4.4093E-02_JPRB,3.9683E-02_JPRB,3.6946E-02_JPRB,3.4574E-02_JPRB,3.2784E-02_JPRB,&
&3.1190E-02_JPRB,2.7785E-02_JPRB,4.2938E-02_JPRB/)
KAO( :, 2, 9,14) = (/&
&6.9192E-02_JPRB,6.0558E-02_JPRB,5.4594E-02_JPRB,5.1616E-02_JPRB,4.9513E-02_JPRB,4.8432E-02_JPRB,&
&4.6308E-02_JPRB,4.3232E-02_JPRB,6.1150E-02_JPRB/)
KAO( :, 3, 9,14) = (/&
&9.0684E-02_JPRB,7.9364E-02_JPRB,7.1928E-02_JPRB,7.0062E-02_JPRB,6.8840E-02_JPRB,6.7293E-02_JPRB,&
&6.5005E-02_JPRB,6.2608E-02_JPRB,8.8443E-02_JPRB/)
KAO( :, 4, 9,14) = (/&
&1.1460E-01_JPRB,1.0028E-01_JPRB,9.2569E-02_JPRB,9.2695E-02_JPRB,9.1960E-02_JPRB,9.0808E-02_JPRB,&
&8.8903E-02_JPRB,8.7875E-02_JPRB,1.2618E-01_JPRB/)
KAO( :, 5, 9,14) = (/&
&1.4029E-01_JPRB,1.2278E-01_JPRB,1.1658E-01_JPRB,1.1927E-01_JPRB,1.2033E-01_JPRB,1.2086E-01_JPRB,&
&1.2101E-01_JPRB,1.2214E-01_JPRB,1.7683E-01_JPRB/)
KAO( :, 1,10,14) = (/&
&4.3717E-02_JPRB,3.8278E-02_JPRB,3.5080E-02_JPRB,3.2701E-02_JPRB,3.0716E-02_JPRB,2.9342E-02_JPRB,&
&2.7684E-02_JPRB,2.4470E-02_JPRB,2.2009E-01_JPRB/)
KAO( :, 2,10,14) = (/&
&6.1476E-02_JPRB,5.3866E-02_JPRB,4.9319E-02_JPRB,4.6960E-02_JPRB,4.5259E-02_JPRB,4.4478E-02_JPRB,&
&4.2577E-02_JPRB,3.9251E-02_JPRB,2.1963E-01_JPRB/)
KAO( :, 3,10,14) = (/&
&8.2385E-02_JPRB,7.2234E-02_JPRB,6.6445E-02_JPRB,6.4962E-02_JPRB,6.4371E-02_JPRB,6.3180E-02_JPRB,&
&6.0931E-02_JPRB,5.7438E-02_JPRB,2.2242E-01_JPRB/)
KAO( :, 4,10,14) = (/&
&1.0599E-01_JPRB,9.3000E-02_JPRB,8.7065E-02_JPRB,8.7339E-02_JPRB,8.7286E-02_JPRB,8.6396E-02_JPRB,&
&8.4334E-02_JPRB,8.1297E-02_JPRB,2.2730E-01_JPRB/)
KAO( :, 5,10,14) = (/&
&1.3194E-01_JPRB,1.1580E-01_JPRB,1.1124E-01_JPRB,1.1411E-01_JPRB,1.1533E-01_JPRB,1.1612E-01_JPRB,&
&1.1515E-01_JPRB,1.1414E-01_JPRB,2.3906E-01_JPRB/)
KAO( :, 1,11,14) = (/&
&4.4414E-02_JPRB,3.9124E-02_JPRB,3.6276E-02_JPRB,3.4192E-02_JPRB,3.2709E-02_JPRB,3.1757E-02_JPRB,&
&3.0272E-02_JPRB,2.7274E-02_JPRB,6.0923E-01_JPRB/)
KAO( :, 2,11,14) = (/&
&6.2792E-02_JPRB,5.5349E-02_JPRB,5.1175E-02_JPRB,4.9442E-02_JPRB,4.8780E-02_JPRB,4.8068E-02_JPRB,&
&4.6106E-02_JPRB,4.2789E-02_JPRB,6.0862E-01_JPRB/)
KAO( :, 3,11,14) = (/&
&8.4498E-02_JPRB,7.4522E-02_JPRB,6.9553E-02_JPRB,6.8963E-02_JPRB,6.9106E-02_JPRB,6.8253E-02_JPRB,&
&6.6044E-02_JPRB,6.2338E-02_JPRB,6.0545E-01_JPRB/)
KAO( :, 4,11,14) = (/&
&1.0929E-01_JPRB,9.6406E-02_JPRB,9.1543E-02_JPRB,9.3189E-02_JPRB,9.3647E-02_JPRB,9.3574E-02_JPRB,&
&9.1735E-02_JPRB,8.8253E-02_JPRB,5.9922E-01_JPRB/)
KAO( :, 5,11,14) = (/&
&1.3686E-01_JPRB,1.2067E-01_JPRB,1.1766E-01_JPRB,1.2167E-01_JPRB,1.2456E-01_JPRB,1.2652E-01_JPRB,&
&1.2561E-01_JPRB,1.2397E-01_JPRB,5.9856E-01_JPRB/)
KAO( :, 1,12,14) = (/&
&4.5286E-02_JPRB,4.0194E-02_JPRB,3.7498E-02_JPRB,3.5426E-02_JPRB,3.4720E-02_JPRB,3.4064E-02_JPRB,&
&3.2556E-02_JPRB,2.9605E-02_JPRB,1.0899E+00_JPRB/)
KAO( :, 2,12,14) = (/&
&6.4484E-02_JPRB,5.7256E-02_JPRB,5.3321E-02_JPRB,5.1760E-02_JPRB,5.1954E-02_JPRB,5.1386E-02_JPRB,&
&4.9166E-02_JPRB,4.5588E-02_JPRB,1.0909E+00_JPRB/)
KAO( :, 3,12,14) = (/&
&8.7239E-02_JPRB,7.7409E-02_JPRB,7.3021E-02_JPRB,7.2641E-02_JPRB,7.3363E-02_JPRB,7.2923E-02_JPRB,&
&7.0510E-02_JPRB,6.6538E-02_JPRB,1.0837E+00_JPRB/)
KAO( :, 4,12,14) = (/&
&1.1325E-01_JPRB,1.0044E-01_JPRB,9.6532E-02_JPRB,9.7960E-02_JPRB,9.9715E-02_JPRB,1.0061E-01_JPRB,&
&9.8953E-02_JPRB,9.5070E-02_JPRB,1.0714E+00_JPRB/)
KAO( :, 5,12,14) = (/&
&1.4215E-01_JPRB,1.2620E-01_JPRB,1.2476E-01_JPRB,1.2858E-01_JPRB,1.3345E-01_JPRB,1.3645E-01_JPRB,&
&1.3637E-01_JPRB,1.3374E-01_JPRB,1.0563E+00_JPRB/)
KAO( :, 1,13,14) = (/&
&4.6570E-02_JPRB,4.1678E-02_JPRB,3.8725E-02_JPRB,3.6717E-02_JPRB,3.6394E-02_JPRB,3.5946E-02_JPRB,&
&3.4376E-02_JPRB,3.1454E-02_JPRB,1.5895E+00_JPRB/)
KAO( :, 2,13,14) = (/&
&6.6498E-02_JPRB,5.9462E-02_JPRB,5.5660E-02_JPRB,5.4101E-02_JPRB,5.4467E-02_JPRB,5.3788E-02_JPRB,&
&5.1648E-02_JPRB,4.8046E-02_JPRB,1.5849E+00_JPRB/)
KAO( :, 3,13,14) = (/&
&9.0364E-02_JPRB,8.0700E-02_JPRB,7.6577E-02_JPRB,7.6135E-02_JPRB,7.6849E-02_JPRB,7.6753E-02_JPRB,&
&7.4630E-02_JPRB,7.0420E-02_JPRB,1.5698E+00_JPRB/)
KAO( :, 4,13,14) = (/&
&1.1790E-01_JPRB,1.0519E-01_JPRB,1.0195E-01_JPRB,1.0248E-01_JPRB,1.0532E-01_JPRB,1.0714E-01_JPRB,&
&1.0603E-01_JPRB,1.0171E-01_JPRB,1.5492E+00_JPRB/)
KAO( :, 5,13,14) = (/&
&1.4874E-01_JPRB,1.3321E-01_JPRB,1.3189E-01_JPRB,1.3520E-01_JPRB,1.4175E-01_JPRB,1.4629E-01_JPRB,&
&1.4735E-01_JPRB,1.4395E-01_JPRB,1.5228E+00_JPRB/)
KAO( :, 1, 1,15) = (/&
&1.1131E-01_JPRB,9.7434E-02_JPRB,8.3539E-02_JPRB,6.9673E-02_JPRB,6.4542E-02_JPRB,7.4907E-02_JPRB,&
&8.0610E-02_JPRB,7.4592E-02_JPRB,1.2983E-01_JPRB/)
KAO( :, 2, 1,15) = (/&
&1.2948E-01_JPRB,1.1334E-01_JPRB,9.7201E-02_JPRB,8.1647E-02_JPRB,9.0214E-02_JPRB,1.0535E-01_JPRB,&
&1.1308E-01_JPRB,1.0399E-01_JPRB,1.8473E-01_JPRB/)
KAO( :, 3, 1,15) = (/&
&1.4765E-01_JPRB,1.2925E-01_JPRB,1.1103E-01_JPRB,1.0059E-01_JPRB,1.2467E-01_JPRB,1.4566E-01_JPRB,&
&1.5615E-01_JPRB,1.4358E-01_JPRB,2.5548E-01_JPRB/)
KAO( :, 4, 1,15) = (/&
&1.6551E-01_JPRB,1.4490E-01_JPRB,1.2421E-01_JPRB,1.3376E-01_JPRB,1.6988E-01_JPRB,1.9836E-01_JPRB,&
&2.1296E-01_JPRB,1.9754E-01_JPRB,3.4830E-01_JPRB/)
KAO( :, 5, 1,15) = (/&
&1.8295E-01_JPRB,1.6015E-01_JPRB,1.4430E-01_JPRB,1.8250E-01_JPRB,2.3252E-01_JPRB,2.7304E-01_JPRB,&
&2.9658E-01_JPRB,2.7983E-01_JPRB,4.7759E-01_JPRB/)
KAO( :, 1, 2,15) = (/&
&1.2229E-01_JPRB,1.0698E-01_JPRB,9.1752E-02_JPRB,7.6480E-02_JPRB,6.8179E-02_JPRB,7.6324E-02_JPRB,&
&8.2595E-02_JPRB,7.6957E-02_JPRB,1.3490E-01_JPRB/)
KAO( :, 2, 2,15) = (/&
&1.4324E-01_JPRB,1.2538E-01_JPRB,1.0747E-01_JPRB,9.0191E-02_JPRB,9.3013E-02_JPRB,1.0900E-01_JPRB,&
&1.1749E-01_JPRB,1.0918E-01_JPRB,1.9459E-01_JPRB/)
KAO( :, 3, 2,15) = (/&
&1.6466E-01_JPRB,1.4413E-01_JPRB,1.2359E-01_JPRB,1.1001E-01_JPRB,1.3054E-01_JPRB,1.5305E-01_JPRB,&
&1.6497E-01_JPRB,1.5263E-01_JPRB,2.7373E-01_JPRB/)
KAO( :, 4, 2,15) = (/&
&1.8622E-01_JPRB,1.6296E-01_JPRB,1.3975E-01_JPRB,1.4019E-01_JPRB,1.7799E-01_JPRB,2.0816E-01_JPRB,&
&2.2421E-01_JPRB,2.0784E-01_JPRB,3.7366E-01_JPRB/)
KAO( :, 5, 2,15) = (/&
&2.0755E-01_JPRB,1.8167E-01_JPRB,1.5934E-01_JPRB,1.9033E-01_JPRB,2.4247E-01_JPRB,2.8472E-01_JPRB,&
&3.0675E-01_JPRB,2.8798E-01_JPRB,5.0930E-01_JPRB/)
KAO( :, 1, 3,15) = (/&
&1.2835E-01_JPRB,1.1233E-01_JPRB,9.6332E-02_JPRB,8.0294E-02_JPRB,6.8892E-02_JPRB,7.2388E-02_JPRB,&
&7.7841E-02_JPRB,7.2996E-02_JPRB,1.3009E-01_JPRB/)
KAO( :, 2, 3,15) = (/&
&1.5296E-01_JPRB,1.3385E-01_JPRB,1.1480E-01_JPRB,9.5678E-02_JPRB,9.1260E-02_JPRB,1.0384E-01_JPRB,&
&1.1265E-01_JPRB,1.0600E-01_JPRB,1.8774E-01_JPRB/)
KAO( :, 3, 3,15) = (/&
&1.7841E-01_JPRB,1.5614E-01_JPRB,1.3387E-01_JPRB,1.1551E-01_JPRB,1.2609E-01_JPRB,1.4839E-01_JPRB,&
&1.6074E-01_JPRB,1.4978E-01_JPRB,2.6916E-01_JPRB/)
KAO( :, 4, 3,15) = (/&
&2.0421E-01_JPRB,1.7872E-01_JPRB,1.5328E-01_JPRB,1.4514E-01_JPRB,1.7532E-01_JPRB,2.0570E-01_JPRB,&
&2.2217E-01_JPRB,2.0725E-01_JPRB,3.7502E-01_JPRB/)
KAO( :, 5, 3,15) = (/&
&2.2993E-01_JPRB,2.0124E-01_JPRB,1.7291E-01_JPRB,1.8782E-01_JPRB,2.3935E-01_JPRB,2.8099E-01_JPRB,&
&3.0349E-01_JPRB,2.8229E-01_JPRB,5.1274E-01_JPRB/)
KAO( :, 1, 4,15) = (/&
&1.3220E-01_JPRB,1.1572E-01_JPRB,9.9179E-02_JPRB,8.2676E-02_JPRB,6.8587E-02_JPRB,6.9929E-02_JPRB,&
&7.4555E-02_JPRB,6.8313E-02_JPRB,1.2618E-01_JPRB/)
KAO( :, 2, 4,15) = (/&
&1.6060E-01_JPRB,1.4053E-01_JPRB,1.2046E-01_JPRB,1.0042E-01_JPRB,9.1232E-02_JPRB,9.6578E-02_JPRB,&
&1.0443E-01_JPRB,9.9068E-02_JPRB,1.7466E-01_JPRB/)
KAO( :, 3, 4,15) = (/&
&1.9027E-01_JPRB,1.6651E-01_JPRB,1.4275E-01_JPRB,1.1998E-01_JPRB,1.2056E-01_JPRB,1.3873E-01_JPRB,&
&1.5129E-01_JPRB,1.4272E-01_JPRB,2.5148E-01_JPRB/)
KAO( :, 4, 4,15) = (/&
&2.2066E-01_JPRB,1.9311E-01_JPRB,1.6558E-01_JPRB,1.4877E-01_JPRB,1.6676E-01_JPRB,1.9681E-01_JPRB,&
&2.1452E-01_JPRB,2.0223E-01_JPRB,3.5884E-01_JPRB/)
KAO( :, 5, 4,15) = (/&
&2.5122E-01_JPRB,2.1983E-01_JPRB,1.8845E-01_JPRB,1.8829E-01_JPRB,2.3159E-01_JPRB,2.7258E-01_JPRB,&
&2.9545E-01_JPRB,2.7646E-01_JPRB,4.9974E-01_JPRB/)
KAO( :, 1, 5,15) = (/&
&1.3465E-01_JPRB,1.1783E-01_JPRB,1.0104E-01_JPRB,8.4191E-02_JPRB,7.0181E-02_JPRB,6.7764E-02_JPRB,&
&7.2349E-02_JPRB,6.6738E-02_JPRB,1.2182E-01_JPRB/)
KAO( :, 2, 5,15) = (/&
&1.6678E-01_JPRB,1.4597E-01_JPRB,1.2512E-01_JPRB,1.0428E-01_JPRB,9.0356E-02_JPRB,9.3548E-02_JPRB,&
&1.0047E-01_JPRB,9.3395E-02_JPRB,1.6838E-01_JPRB/)
KAO( :, 3, 5,15) = (/&
&2.0080E-01_JPRB,1.7573E-01_JPRB,1.5067E-01_JPRB,1.2564E-01_JPRB,1.1939E-01_JPRB,1.2897E-01_JPRB,&
&1.4021E-01_JPRB,1.3389E-01_JPRB,2.3367E-01_JPRB/)
KAO( :, 4, 5,15) = (/&
&2.3601E-01_JPRB,2.0651E-01_JPRB,1.7705E-01_JPRB,1.5299E-01_JPRB,1.5971E-01_JPRB,1.8409E-01_JPRB,&
&2.0223E-01_JPRB,1.9297E-01_JPRB,3.3364E-01_JPRB/)
KAO( :, 5, 5,15) = (/&
&2.7164E-01_JPRB,2.3767E-01_JPRB,2.0377E-01_JPRB,1.9351E-01_JPRB,2.2099E-01_JPRB,2.6145E-01_JPRB,&
&2.8569E-01_JPRB,2.7068E-01_JPRB,4.7598E-01_JPRB/)
KAO( :, 1, 6,15) = (/&
&1.3406E-01_JPRB,1.1731E-01_JPRB,1.0056E-01_JPRB,8.3806E-02_JPRB,7.0762E-02_JPRB,6.6238E-02_JPRB,&
&6.8971E-02_JPRB,6.4722E-02_JPRB,1.1369E-01_JPRB/)
KAO( :, 2, 6,15) = (/&
&1.6963E-01_JPRB,1.4845E-01_JPRB,1.2729E-01_JPRB,1.0606E-01_JPRB,9.0231E-02_JPRB,9.0723E-02_JPRB,&
&9.7199E-02_JPRB,9.0437E-02_JPRB,1.6138E-01_JPRB/)
KAO( :, 3, 6,15) = (/&
&2.0786E-01_JPRB,1.8191E-01_JPRB,1.5592E-01_JPRB,1.2995E-01_JPRB,1.1861E-01_JPRB,1.2279E-01_JPRB,&
&1.3287E-01_JPRB,1.2524E-01_JPRB,2.2069E-01_JPRB/)
KAO( :, 4, 6,15) = (/&
&2.4779E-01_JPRB,2.1681E-01_JPRB,1.8585E-01_JPRB,1.5823E-01_JPRB,1.5558E-01_JPRB,1.7012E-01_JPRB,&
&1.8594E-01_JPRB,1.7956E-01_JPRB,3.0607E-01_JPRB/)
KAO( :, 5, 6,15) = (/&
&2.8850E-01_JPRB,2.5250E-01_JPRB,2.1644E-01_JPRB,1.9593E-01_JPRB,2.0861E-01_JPRB,2.4203E-01_JPRB,&
&2.6660E-01_JPRB,2.5670E-01_JPRB,4.3563E-01_JPRB/)
KAO( :, 1, 7,15) = (/&
&1.3101E-01_JPRB,1.1464E-01_JPRB,9.8272E-02_JPRB,8.1907E-02_JPRB,7.0350E-02_JPRB,6.5243E-02_JPRB,&
&6.4994E-02_JPRB,6.2397E-02_JPRB,1.0427E-01_JPRB/)
KAO( :, 2, 7,15) = (/&
&1.6960E-01_JPRB,1.4841E-01_JPRB,1.2720E-01_JPRB,1.0602E-01_JPRB,9.1007E-02_JPRB,8.8046E-02_JPRB,&
&9.1985E-02_JPRB,8.6734E-02_JPRB,1.5008E-01_JPRB/)
KAO( :, 3, 7,15) = (/&
&2.1159E-01_JPRB,1.8512E-01_JPRB,1.5869E-01_JPRB,1.3227E-01_JPRB,1.1799E-01_JPRB,1.2016E-01_JPRB,&
&1.2848E-01_JPRB,1.2123E-01_JPRB,2.0928E-01_JPRB/)
KAO( :, 4, 7,15) = (/&
&2.5591E-01_JPRB,2.2393E-01_JPRB,1.9196E-01_JPRB,1.6246E-01_JPRB,1.5474E-01_JPRB,1.6150E-01_JPRB,&
&1.7579E-01_JPRB,1.6710E-01_JPRB,2.8812E-01_JPRB/)
KAO( :, 5, 7,15) = (/&
&3.0213E-01_JPRB,2.6429E-01_JPRB,2.2656E-01_JPRB,2.0075E-01_JPRB,2.0206E-01_JPRB,2.2299E-01_JPRB,&
&2.4482E-01_JPRB,2.3852E-01_JPRB,4.0014E-01_JPRB/)
KAO( :, 1, 8,15) = (/&
&1.2571E-01_JPRB,1.1002E-01_JPRB,9.4301E-02_JPRB,7.8660E-02_JPRB,6.9028E-02_JPRB,6.3512E-02_JPRB,&
&6.0386E-02_JPRB,5.9283E-02_JPRB,9.4594E-02_JPRB/)
KAO( :, 2, 8,15) = (/&
&1.6658E-01_JPRB,1.4578E-01_JPRB,1.2499E-01_JPRB,1.0438E-01_JPRB,9.1618E-02_JPRB,8.5835E-02_JPRB,&
&8.6312E-02_JPRB,8.2954E-02_JPRB,1.3781E-01_JPRB/)
KAO( :, 3, 8,15) = (/&
&2.1185E-01_JPRB,1.8540E-01_JPRB,1.5894E-01_JPRB,1.3292E-01_JPRB,1.1859E-01_JPRB,1.1793E-01_JPRB,&
&1.2293E-01_JPRB,1.1767E-01_JPRB,1.9732E-01_JPRB/)
KAO( :, 4, 8,15) = (/&
&2.6124E-01_JPRB,2.2860E-01_JPRB,1.9595E-01_JPRB,1.6484E-01_JPRB,1.5535E-01_JPRB,1.5770E-01_JPRB,&
&1.6881E-01_JPRB,1.6159E-01_JPRB,2.7186E-01_JPRB/)
KAO( :, 5, 8,15) = (/&
&3.1377E-01_JPRB,2.7455E-01_JPRB,2.3536E-01_JPRB,2.0526E-01_JPRB,2.0139E-01_JPRB,2.1210E-01_JPRB,&
&2.3209E-01_JPRB,2.2418E-01_JPRB,3.7448E-01_JPRB/)
KAO( :, 1, 9,15) = (/&
&1.1779E-01_JPRB,1.0307E-01_JPRB,8.8332E-02_JPRB,7.4504E-02_JPRB,6.6446E-02_JPRB,6.0468E-02_JPRB,&
&5.6136E-02_JPRB,5.4947E-02_JPRB,8.6169E-02_JPRB/)
KAO( :, 2, 9,15) = (/&
&1.6035E-01_JPRB,1.4031E-01_JPRB,1.2024E-01_JPRB,1.0163E-01_JPRB,9.0617E-02_JPRB,8.2714E-02_JPRB,&
&7.9922E-02_JPRB,7.8110E-02_JPRB,1.2654E-01_JPRB/)
KAO( :, 3, 9,15) = (/&
&2.0927E-01_JPRB,1.8312E-01_JPRB,1.5698E-01_JPRB,1.3222E-01_JPRB,1.1873E-01_JPRB,1.1424E-01_JPRB,&
&1.1454E-01_JPRB,1.1174E-01_JPRB,1.8302E-01_JPRB/)
KAO( :, 4, 9,15) = (/&
&2.6349E-01_JPRB,2.3054E-01_JPRB,1.9763E-01_JPRB,1.6626E-01_JPRB,1.5598E-01_JPRB,1.5598E-01_JPRB,&
&1.6166E-01_JPRB,1.5736E-01_JPRB,2.5852E-01_JPRB/)
KAO( :, 5, 9,15) = (/&
&3.2165E-01_JPRB,2.8148E-01_JPRB,2.4130E-01_JPRB,2.0798E-01_JPRB,2.0349E-01_JPRB,2.0671E-01_JPRB,&
&2.2142E-01_JPRB,2.1528E-01_JPRB,3.5292E-01_JPRB/)
KAO( :, 1,10,15) = (/&
&1.1095E-01_JPRB,9.7087E-02_JPRB,8.3232E-02_JPRB,7.1375E-02_JPRB,6.4431E-02_JPRB,5.8222E-02_JPRB,&
&5.3438E-02_JPRB,5.1856E-02_JPRB,2.8234E-01_JPRB/)
KAO( :, 2,10,15) = (/&
&1.5568E-01_JPRB,1.3623E-01_JPRB,1.1675E-01_JPRB,9.9778E-02_JPRB,9.0053E-02_JPRB,8.1186E-02_JPRB,&
&7.6199E-02_JPRB,7.4185E-02_JPRB,2.7084E-01_JPRB/)
KAO( :, 3,10,15) = (/&
&2.0787E-01_JPRB,1.8189E-01_JPRB,1.5590E-01_JPRB,1.3290E-01_JPRB,1.2001E-01_JPRB,1.1270E-01_JPRB,&
&1.0975E-01_JPRB,1.0759E-01_JPRB,2.7158E-01_JPRB/)
KAO( :, 4,10,15) = (/&
&2.6636E-01_JPRB,2.3306E-01_JPRB,1.9979E-01_JPRB,1.7021E-01_JPRB,1.5900E-01_JPRB,1.5510E-01_JPRB,&
&1.5611E-01_JPRB,1.5403E-01_JPRB,2.9598E-01_JPRB/)
KAO( :, 5,10,15) = (/&
&3.2972E-01_JPRB,2.8850E-01_JPRB,2.4729E-01_JPRB,2.1458E-01_JPRB,2.0828E-01_JPRB,2.0718E-01_JPRB,&
&2.1605E-01_JPRB,2.1269E-01_JPRB,3.5425E-01_JPRB/)
KAO( :, 1,11,15) = (/&
&1.2309E-01_JPRB,1.0770E-01_JPRB,9.2318E-02_JPRB,8.0169E-02_JPRB,7.2987E-02_JPRB,6.5556E-02_JPRB,&
&5.9599E-02_JPRB,5.7207E-02_JPRB,7.8086E-01_JPRB/)
KAO( :, 2,11,15) = (/&
&1.7300E-01_JPRB,1.5138E-01_JPRB,1.2976E-01_JPRB,1.1252E-01_JPRB,1.0172E-01_JPRB,9.2390E-02_JPRB,&
&8.6481E-02_JPRB,8.3441E-02_JPRB,7.5756E-01_JPRB/)
KAO( :, 3,11,15) = (/&
&2.3096E-01_JPRB,2.0210E-01_JPRB,1.7324E-01_JPRB,1.5024E-01_JPRB,1.3705E-01_JPRB,1.2915E-01_JPRB,&
&1.2474E-01_JPRB,1.2191E-01_JPRB,7.4457E-01_JPRB/)
KAO( :, 4,11,15) = (/&
&2.9558E-01_JPRB,2.5867E-01_JPRB,2.2168E-01_JPRB,1.9321E-01_JPRB,1.8253E-01_JPRB,1.7759E-01_JPRB,&
&1.7734E-01_JPRB,1.7484E-01_JPRB,7.3821E-01_JPRB/)
KAO( :, 5,11,15) = (/&
&3.6617E-01_JPRB,3.2039E-01_JPRB,2.7464E-01_JPRB,2.4544E-01_JPRB,2.3942E-01_JPRB,2.3664E-01_JPRB,&
&2.4480E-01_JPRB,2.4186E-01_JPRB,7.3136E-01_JPRB/)
KAO( :, 1,12,15) = (/&
&1.3535E-01_JPRB,1.1843E-01_JPRB,1.0165E-01_JPRB,8.9837E-02_JPRB,8.1690E-02_JPRB,7.3571E-02_JPRB,&
&6.6791E-02_JPRB,6.3661E-02_JPRB,1.3757E+00_JPRB/)
KAO( :, 2,12,15) = (/&
&1.8999E-01_JPRB,1.6623E-01_JPRB,1.4287E-01_JPRB,1.2620E-01_JPRB,1.1425E-01_JPRB,1.0484E-01_JPRB,&
&9.8183E-02_JPRB,9.4523E-02_JPRB,1.3459E+00_JPRB/)
KAO( :, 3,12,15) = (/&
&2.5368E-01_JPRB,2.2195E-01_JPRB,1.9057E-01_JPRB,1.6840E-01_JPRB,1.5584E-01_JPRB,1.4733E-01_JPRB,&
&1.4186E-01_JPRB,1.3807E-01_JPRB,1.3315E+00_JPRB/)
KAO( :, 4,12,15) = (/&
&3.2577E-01_JPRB,2.8506E-01_JPRB,2.4459E-01_JPRB,2.1851E-01_JPRB,2.0824E-01_JPRB,2.0259E-01_JPRB,&
&2.0145E-01_JPRB,1.9850E-01_JPRB,1.3194E+00_JPRB/)
KAO( :, 5,12,15) = (/&
&4.0459E-01_JPRB,3.5405E-01_JPRB,3.0385E-01_JPRB,2.7860E-01_JPRB,2.7319E-01_JPRB,2.7033E-01_JPRB,&
&2.7684E-01_JPRB,2.7490E-01_JPRB,1.2999E+00_JPRB/)
KAO( :, 1,13,15) = (/&
&1.4666E-01_JPRB,1.2832E-01_JPRB,1.1128E-01_JPRB,9.9675E-02_JPRB,9.0808E-02_JPRB,8.2287E-02_JPRB,&
&7.4732E-02_JPRB,7.0894E-02_JPRB,1.9726E+00_JPRB/)
KAO( :, 2,13,15) = (/&
&2.0655E-01_JPRB,1.8072E-01_JPRB,1.5634E-01_JPRB,1.3981E-01_JPRB,1.2800E-01_JPRB,1.1883E-01_JPRB,&
&1.1080E-01_JPRB,1.0633E-01_JPRB,1.9427E+00_JPRB/)
KAO( :, 3,13,15) = (/&
&2.7678E-01_JPRB,2.4218E-01_JPRB,2.0938E-01_JPRB,1.8714E-01_JPRB,1.7583E-01_JPRB,1.6736E-01_JPRB,&
&1.6095E-01_JPRB,1.5626E-01_JPRB,1.9257E+00_JPRB/)
KAO( :, 4,13,15) = (/&
&3.5575E-01_JPRB,3.1133E-01_JPRB,2.6913E-01_JPRB,2.4484E-01_JPRB,2.3543E-01_JPRB,2.2998E-01_JPRB,&
&2.2795E-01_JPRB,2.2454E-01_JPRB,1.9087E+00_JPRB/)
KAO( :, 5,13,15) = (/&
&4.4176E-01_JPRB,3.8657E-01_JPRB,3.3600E-01_JPRB,3.1312E-01_JPRB,3.0900E-01_JPRB,3.0654E-01_JPRB,&
&3.1167E-01_JPRB,3.1059E-01_JPRB,1.8847E+00_JPRB/)
KAO( :, 1, 1,16) = (/&
&1.2027E-01_JPRB,1.0526E-01_JPRB,9.0268E-02_JPRB,7.5271E-02_JPRB,6.8242E-02_JPRB,7.9946E-02_JPRB,&
&8.4979E-02_JPRB,7.6217E-02_JPRB,1.4103E-01_JPRB/)
KAO( :, 2, 1,16) = (/&
&1.4080E-01_JPRB,1.2324E-01_JPRB,1.0567E-01_JPRB,8.8126E-02_JPRB,9.6089E-02_JPRB,1.1140E-01_JPRB,&
&1.1849E-01_JPRB,1.0627E-01_JPRB,1.9684E-01_JPRB/)
KAO( :, 3, 1,16) = (/&
&1.6158E-01_JPRB,1.4144E-01_JPRB,1.1993E-01_JPRB,1.0577E-01_JPRB,1.3446E-01_JPRB,1.5713E-01_JPRB,&
&1.6954E-01_JPRB,1.5459E-01_JPRB,2.8205E-01_JPRB/)
KAO( :, 4, 1,16) = (/&
&1.8229E-01_JPRB,1.5953E-01_JPRB,1.3683E-01_JPRB,1.5400E-01_JPRB,1.9491E-01_JPRB,2.2859E-01_JPRB,&
&2.4701E-01_JPRB,2.2397E-01_JPRB,4.1109E-01_JPRB/)
KAO( :, 5, 1,16) = (/&
&2.0257E-01_JPRB,1.7732E-01_JPRB,1.5205E-01_JPRB,2.1653E-01_JPRB,2.7743E-01_JPRB,3.2485E-01_JPRB,&
&3.4587E-01_JPRB,3.1685E-01_JPRB,5.7776E-01_JPRB/)
KAO( :, 1, 2,16) = (/&
&1.3618E-01_JPRB,1.1918E-01_JPRB,1.0218E-01_JPRB,8.5185E-02_JPRB,7.2061E-02_JPRB,8.3641E-02_JPRB,&
&8.9007E-02_JPRB,8.0776E-02_JPRB,1.5158E-01_JPRB/)
KAO( :, 2, 2,16) = (/&
&1.6091E-01_JPRB,1.4083E-01_JPRB,1.2073E-01_JPRB,1.0065E-01_JPRB,1.0215E-01_JPRB,1.1864E-01_JPRB,&
&1.2628E-01_JPRB,1.1335E-01_JPRB,2.1521E-01_JPRB/)
KAO( :, 3, 2,16) = (/&
&1.8613E-01_JPRB,1.6291E-01_JPRB,1.3967E-01_JPRB,1.1644E-01_JPRB,1.3974E-01_JPRB,1.6244E-01_JPRB,&
&1.7346E-01_JPRB,1.5531E-01_JPRB,2.9678E-01_JPRB/)
KAO( :, 4, 2,16) = (/&
&2.1139E-01_JPRB,1.8501E-01_JPRB,1.5862E-01_JPRB,1.6081E-01_JPRB,2.0532E-01_JPRB,2.4099E-01_JPRB,&
&2.5759E-01_JPRB,2.3243E-01_JPRB,4.4014E-01_JPRB/)
KAO( :, 5, 2,16) = (/&
&2.3633E-01_JPRB,2.0681E-01_JPRB,1.7734E-01_JPRB,2.3037E-01_JPRB,2.9357E-01_JPRB,3.4250E-01_JPRB,&
&3.6944E-01_JPRB,3.3497E-01_JPRB,6.2683E-01_JPRB/)
KAO( :, 1, 3,16) = (/&
&1.4816E-01_JPRB,1.2967E-01_JPRB,1.1115E-01_JPRB,9.2659E-02_JPRB,7.4159E-02_JPRB,8.0583E-02_JPRB,&
&8.5826E-02_JPRB,7.7925E-02_JPRB,1.4987E-01_JPRB/)
KAO( :, 2, 3,16) = (/&
&1.7766E-01_JPRB,1.5547E-01_JPRB,1.3328E-01_JPRB,1.1109E-01_JPRB,1.0104E-01_JPRB,1.1748E-01_JPRB,&
&1.2514E-01_JPRB,1.1367E-01_JPRB,2.1867E-01_JPRB/)
KAO( :, 3, 3,16) = (/&
&2.0806E-01_JPRB,1.8208E-01_JPRB,1.5612E-01_JPRB,1.3012E-01_JPRB,1.4100E-01_JPRB,1.6398E-01_JPRB,&
&1.7474E-01_JPRB,1.5873E-01_JPRB,3.0539E-01_JPRB/)
KAO( :, 4, 3,16) = (/&
&2.3885E-01_JPRB,2.0905E-01_JPRB,1.7920E-01_JPRB,1.5462E-01_JPRB,1.9704E-01_JPRB,2.3104E-01_JPRB,&
&2.4836E-01_JPRB,2.2742E-01_JPRB,4.3187E-01_JPRB/)
KAO( :, 5, 3,16) = (/&
&2.6947E-01_JPRB,2.3583E-01_JPRB,2.0218E-01_JPRB,2.2565E-01_JPRB,2.8814E-01_JPRB,3.3769E-01_JPRB,&
&3.6257E-01_JPRB,3.3019E-01_JPRB,6.3080E-01_JPRB/)
KAO( :, 1, 4,16) = (/&
&1.5818E-01_JPRB,1.3843E-01_JPRB,1.1868E-01_JPRB,9.8906E-02_JPRB,7.9147E-02_JPRB,7.4782E-02_JPRB,&
&7.9730E-02_JPRB,7.2448E-02_JPRB,1.4101E-01_JPRB/)
KAO( :, 2, 4,16) = (/&
&1.9302E-01_JPRB,1.6890E-01_JPRB,1.4479E-01_JPRB,1.2067E-01_JPRB,9.6946E-02_JPRB,1.1266E-01_JPRB,&
&1.2012E-01_JPRB,1.0916E-01_JPRB,2.1249E-01_JPRB/)
KAO( :, 3, 4,16) = (/&
&2.2940E-01_JPRB,2.0076E-01_JPRB,1.7206E-01_JPRB,1.4345E-01_JPRB,1.3883E-01_JPRB,1.6162E-01_JPRB,&
&1.7237E-01_JPRB,1.5669E-01_JPRB,3.0501E-01_JPRB/)
KAO( :, 4, 4,16) = (/&
&2.6665E-01_JPRB,2.3335E-01_JPRB,2.0002E-01_JPRB,1.6674E-01_JPRB,1.9115E-01_JPRB,2.2258E-01_JPRB,&
&2.3743E-01_JPRB,2.1581E-01_JPRB,4.2004E-01_JPRB/)
KAO( :, 5, 4,16) = (/&
&3.0410E-01_JPRB,2.6615E-01_JPRB,2.2811E-01_JPRB,2.1285E-01_JPRB,2.7372E-01_JPRB,3.2083E-01_JPRB,&
&3.4541E-01_JPRB,3.1599E-01_JPRB,6.0405E-01_JPRB/)
KAO( :, 1, 5,16) = (/&
&1.6744E-01_JPRB,1.4653E-01_JPRB,1.2561E-01_JPRB,1.0468E-01_JPRB,8.3763E-02_JPRB,7.6430E-02_JPRB,&
&8.0078E-02_JPRB,7.1821E-02_JPRB,1.3817E-01_JPRB/)
KAO( :, 2, 5,16) = (/&
&2.0817E-01_JPRB,1.8217E-01_JPRB,1.5617E-01_JPRB,1.3014E-01_JPRB,1.0413E-01_JPRB,1.0666E-01_JPRB,&
&1.1380E-01_JPRB,1.0350E-01_JPRB,2.0245E-01_JPRB/)
KAO( :, 3, 5,16) = (/&
&2.5135E-01_JPRB,2.1998E-01_JPRB,1.8857E-01_JPRB,1.5714E-01_JPRB,1.3525E-01_JPRB,1.5761E-01_JPRB,&
&1.6824E-01_JPRB,1.5302E-01_JPRB,2.9921E-01_JPRB/)
KAO( :, 4, 5,16) = (/&
&2.9614E-01_JPRB,2.5913E-01_JPRB,2.2214E-01_JPRB,1.8514E-01_JPRB,1.9095E-01_JPRB,2.2256E-01_JPRB,&
&2.3757E-01_JPRB,2.1609E-01_JPRB,4.2253E-01_JPRB/)
KAO( :, 5, 5,16) = (/&
&3.4165E-01_JPRB,2.9890E-01_JPRB,2.5626E-01_JPRB,2.1358E-01_JPRB,2.6276E-01_JPRB,3.0710E-01_JPRB,&
&3.2753E-01_JPRB,2.9875E-01_JPRB,5.8403E-01_JPRB/)
KAO( :, 1, 6,16) = (/&
&1.7406E-01_JPRB,1.5231E-01_JPRB,1.3056E-01_JPRB,1.0879E-01_JPRB,8.7033E-02_JPRB,7.9557E-02_JPRB,&
&8.3495E-02_JPRB,7.4970E-02_JPRB,1.4461E-01_JPRB/)
KAO( :, 2, 6,16) = (/&
&2.2115E-01_JPRB,1.9353E-01_JPRB,1.6587E-01_JPRB,1.3825E-01_JPRB,1.1058E-01_JPRB,1.0079E-01_JPRB,&
&1.0571E-01_JPRB,9.5354E-02_JPRB,1.8669E-01_JPRB/)
KAO( :, 3, 6,16) = (/&
&2.7185E-01_JPRB,2.3789E-01_JPRB,2.0389E-01_JPRB,1.6994E-01_JPRB,1.3598E-01_JPRB,1.4993E-01_JPRB,&
&1.6017E-01_JPRB,1.4582E-01_JPRB,2.8546E-01_JPRB/)
KAO( :, 4, 6,16) = (/&
&3.2519E-01_JPRB,2.8454E-01_JPRB,2.4391E-01_JPRB,2.0327E-01_JPRB,1.8667E-01_JPRB,2.1780E-01_JPRB,&
&2.3273E-01_JPRB,2.1193E-01_JPRB,4.1454E-01_JPRB/)
KAO( :, 5, 6,16) = (/&
&3.7997E-01_JPRB,3.3252E-01_JPRB,2.8502E-01_JPRB,2.3749E-01_JPRB,2.5973E-01_JPRB,3.0308E-01_JPRB,&
&3.2386E-01_JPRB,2.9502E-01_JPRB,5.7680E-01_JPRB/)
KAO( :, 1, 7,16) = (/&
&1.7875E-01_JPRB,1.5642E-01_JPRB,1.3408E-01_JPRB,1.1175E-01_JPRB,8.9415E-02_JPRB,8.1831E-02_JPRB,&
&8.6005E-02_JPRB,7.7323E-02_JPRB,1.4922E-01_JPRB/)
KAO( :, 2, 7,16) = (/&
&2.3257E-01_JPRB,2.0349E-01_JPRB,1.7445E-01_JPRB,1.4538E-01_JPRB,1.1631E-01_JPRB,1.0616E-01_JPRB,&
&1.1147E-01_JPRB,1.0017E-01_JPRB,1.9290E-01_JPRB/)
KAO( :, 3, 7,16) = (/&
&2.9155E-01_JPRB,2.5511E-01_JPRB,2.1872E-01_JPRB,1.8226E-01_JPRB,1.4581E-01_JPRB,1.4057E-01_JPRB,&
&1.5032E-01_JPRB,1.3703E-01_JPRB,2.6795E-01_JPRB/)
KAO( :, 4, 7,16) = (/&
&3.5453E-01_JPRB,3.1018E-01_JPRB,2.6586E-01_JPRB,2.2158E-01_JPRB,1.8072E-01_JPRB,2.1059E-01_JPRB,&
&2.2528E-01_JPRB,2.0539E-01_JPRB,4.0134E-01_JPRB/)
KAO( :, 5, 7,16) = (/&
&4.2001E-01_JPRB,3.6750E-01_JPRB,3.1500E-01_JPRB,2.6252E-01_JPRB,2.5742E-01_JPRB,3.0072E-01_JPRB,&
&3.2172E-01_JPRB,2.9345E-01_JPRB,5.7279E-01_JPRB/)
KAO( :, 1, 8,16) = (/&
&1.8184E-01_JPRB,1.5912E-01_JPRB,1.3638E-01_JPRB,1.1367E-01_JPRB,9.0918E-02_JPRB,8.3330E-02_JPRB,&
&8.7708E-02_JPRB,7.9039E-02_JPRB,1.5236E-01_JPRB/)
KAO( :, 2, 8,16) = (/&
&2.4266E-01_JPRB,2.1231E-01_JPRB,1.8198E-01_JPRB,1.5168E-01_JPRB,1.2132E-01_JPRB,1.1090E-01_JPRB,&
&1.1664E-01_JPRB,1.0501E-01_JPRB,2.0199E-01_JPRB/)
KAO( :, 3, 8,16) = (/&
&3.1060E-01_JPRB,2.7177E-01_JPRB,2.3297E-01_JPRB,1.9411E-01_JPRB,1.5532E-01_JPRB,1.4153E-01_JPRB,&
&1.4874E-01_JPRB,1.3387E-01_JPRB,2.5753E-01_JPRB/)
KAO( :, 4, 8,16) = (/&
&3.8422E-01_JPRB,3.3618E-01_JPRB,2.8820E-01_JPRB,2.4017E-01_JPRB,1.9212E-01_JPRB,2.0191E-01_JPRB,&
&2.1622E-01_JPRB,1.9751E-01_JPRB,3.8483E-01_JPRB/)
KAO( :, 5, 8,16) = (/&
&4.6183E-01_JPRB,4.0412E-01_JPRB,3.4637E-01_JPRB,2.8861E-01_JPRB,2.5332E-01_JPRB,2.9628E-01_JPRB,&
&3.1743E-01_JPRB,2.9007E-01_JPRB,5.6429E-01_JPRB/)
KAO( :, 1, 9,16) = (/&
&1.8242E-01_JPRB,1.5964E-01_JPRB,1.3685E-01_JPRB,1.1403E-01_JPRB,9.1238E-02_JPRB,8.3650E-02_JPRB,&
&8.8221E-02_JPRB,7.9647E-02_JPRB,1.5343E-01_JPRB/)
KAO( :, 2, 9,16) = (/&
&2.5031E-01_JPRB,2.1903E-01_JPRB,1.8774E-01_JPRB,1.5645E-01_JPRB,1.2518E-01_JPRB,1.1450E-01_JPRB,&
&1.2069E-01_JPRB,1.0894E-01_JPRB,2.0909E-01_JPRB/)
KAO( :, 3, 9,16) = (/&
&3.2780E-01_JPRB,2.8681E-01_JPRB,2.4582E-01_JPRB,2.0484E-01_JPRB,1.6390E-01_JPRB,1.4947E-01_JPRB,&
&1.5744E-01_JPRB,1.4207E-01_JPRB,2.7178E-01_JPRB/)
KAO( :, 4, 9,16) = (/&
&4.1288E-01_JPRB,3.6136E-01_JPRB,3.0972E-01_JPRB,2.5810E-01_JPRB,2.0648E-01_JPRB,1.9240E-01_JPRB,&
&2.0499E-01_JPRB,1.8750E-01_JPRB,3.6520E-01_JPRB/)
KAO( :, 5, 9,16) = (/&
&5.0401E-01_JPRB,4.4105E-01_JPRB,3.7793E-01_JPRB,3.1504E-01_JPRB,2.5430E-01_JPRB,2.8859E-01_JPRB,&
&3.0964E-01_JPRB,2.8367E-01_JPRB,5.5002E-01_JPRB/)
KAO( :, 1,10,16) = (/&
&1.8581E-01_JPRB,1.6259E-01_JPRB,1.3934E-01_JPRB,1.1613E-01_JPRB,9.2903E-02_JPRB,8.5148E-02_JPRB,&
&9.0034E-02_JPRB,8.1540E-02_JPRB,3.4590E-01_JPRB/)
KAO( :, 2,10,16) = (/&
&2.6163E-01_JPRB,2.2890E-01_JPRB,1.9618E-01_JPRB,1.6349E-01_JPRB,1.3077E-01_JPRB,1.1965E-01_JPRB,&
&1.2644E-01_JPRB,1.1450E-01_JPRB,3.2865E-01_JPRB/)
KAO( :, 3,10,16) = (/&
&3.4958E-01_JPRB,3.0586E-01_JPRB,2.6220E-01_JPRB,2.1849E-01_JPRB,1.7478E-01_JPRB,1.5951E-01_JPRB,&
&1.6845E-01_JPRB,1.5252E-01_JPRB,3.1204E-01_JPRB/)
KAO( :, 4,10,16) = (/&
&4.4787E-01_JPRB,3.9191E-01_JPRB,3.3594E-01_JPRB,2.7989E-01_JPRB,2.2397E-01_JPRB,2.0376E-01_JPRB,&
&2.1506E-01_JPRB,1.9478E-01_JPRB,3.7906E-01_JPRB/)
KAO( :, 5,10,16) = (/&
&5.5414E-01_JPRB,4.8494E-01_JPRB,4.1561E-01_JPRB,3.4636E-01_JPRB,2.7711E-01_JPRB,2.8690E-01_JPRB,&
&3.0857E-01_JPRB,2.8362E-01_JPRB,5.5736E-01_JPRB/)
KAO( :, 1,11,16) = (/&
&2.2387E-01_JPRB,1.9590E-01_JPRB,1.6793E-01_JPRB,1.3995E-01_JPRB,1.1196E-01_JPRB,1.0248E-01_JPRB,&
&1.0866E-01_JPRB,9.8759E-02_JPRB,9.7232E-01_JPRB/)
KAO( :, 2,11,16) = (/&
&3.1487E-01_JPRB,2.7553E-01_JPRB,2.3616E-01_JPRB,1.9682E-01_JPRB,1.5747E-01_JPRB,1.4389E-01_JPRB,&
&1.5251E-01_JPRB,1.3868E-01_JPRB,9.2352E-01_JPRB/)
KAO( :, 3,11,16) = (/&
&4.2034E-01_JPRB,3.6781E-01_JPRB,3.1526E-01_JPRB,2.6274E-01_JPRB,2.1020E-01_JPRB,1.9156E-01_JPRB,&
&2.0295E-01_JPRB,1.8465E-01_JPRB,8.7619E-01_JPRB/)
KAO( :, 4,11,16) = (/&
&5.3783E-01_JPRB,4.7062E-01_JPRB,4.0338E-01_JPRB,3.3619E-01_JPRB,2.6900E-01_JPRB,2.4463E-01_JPRB,&
&2.5910E-01_JPRB,2.3556E-01_JPRB,8.3528E-01_JPRB/)
KAO( :, 5,11,16) = (/&
&6.6465E-01_JPRB,5.8160E-01_JPRB,4.9850E-01_JPRB,4.1545E-01_JPRB,3.3262E-01_JPRB,3.4381E-01_JPRB,&
&3.7087E-01_JPRB,3.4266E-01_JPRB,8.3608E-01_JPRB/)
KAO( :, 1,12,16) = (/&
&2.6898E-01_JPRB,2.3539E-01_JPRB,2.0175E-01_JPRB,1.6812E-01_JPRB,1.3451E-01_JPRB,1.2295E-01_JPRB,&
&1.3082E-01_JPRB,1.1955E-01_JPRB,1.7254E+00_JPRB/)
KAO( :, 2,12,16) = (/&
&3.7759E-01_JPRB,3.3035E-01_JPRB,2.8322E-01_JPRB,2.3602E-01_JPRB,1.8879E-01_JPRB,1.7231E-01_JPRB,&
&1.8335E-01_JPRB,1.6769E-01_JPRB,1.6364E+00_JPRB/)
KAO( :, 3,12,16) = (/&
&5.0302E-01_JPRB,4.4026E-01_JPRB,3.7736E-01_JPRB,3.1440E-01_JPRB,2.5155E-01_JPRB,2.2898E-01_JPRB,&
&2.4369E-01_JPRB,2.2307E-01_JPRB,1.5678E+00_JPRB/)
KAO( :, 4,12,16) = (/&
&6.4249E-01_JPRB,5.6214E-01_JPRB,4.8190E-01_JPRB,4.0154E-01_JPRB,3.2127E-01_JPRB,2.9402E-01_JPRB,&
&3.1247E-01_JPRB,2.8485E-01_JPRB,1.5255E+00_JPRB/)
KAO( :, 5,12,16) = (/&
&7.9248E-01_JPRB,6.9340E-01_JPRB,5.9438E-01_JPRB,4.9520E-01_JPRB,3.9963E-01_JPRB,4.1148E-01_JPRB,&
&4.4433E-01_JPRB,4.1322E-01_JPRB,1.5412E+00_JPRB/)
KAO( :, 1,13,16) = (/&
&3.2111E-01_JPRB,2.8086E-01_JPRB,2.4080E-01_JPRB,2.0063E-01_JPRB,1.6053E-01_JPRB,1.4645E-01_JPRB,&
&1.5663E-01_JPRB,1.4415E-01_JPRB,2.4681E+00_JPRB/)
KAO( :, 2,13,16) = (/&
&4.4952E-01_JPRB,3.9337E-01_JPRB,3.3709E-01_JPRB,2.8095E-01_JPRB,2.2474E-01_JPRB,2.0495E-01_JPRB,&
&2.1909E-01_JPRB,2.0198E-01_JPRB,2.3822E+00_JPRB/)
KAO( :, 3,13,16) = (/&
&5.9739E-01_JPRB,5.2281E-01_JPRB,4.4809E-01_JPRB,3.7333E-01_JPRB,2.9881E-01_JPRB,2.7217E-01_JPRB,&
&2.9063E-01_JPRB,2.6832E-01_JPRB,2.3232E+00_JPRB/)
KAO( :, 4,13,16) = (/&
&7.6112E-01_JPRB,6.6586E-01_JPRB,5.7079E-01_JPRB,4.7570E-01_JPRB,3.8102E-01_JPRB,3.5288E-01_JPRB,&
&3.7640E-01_JPRB,3.4431E-01_JPRB,2.2950E+00_JPRB/)
KAO( :, 5,13,16) = (/&
&9.3631E-01_JPRB,8.1920E-01_JPRB,7.0224E-01_JPRB,5.8508E-01_JPRB,4.7927E-01_JPRB,4.9193E-01_JPRB,&
&5.3062E-01_JPRB,4.9592E-01_JPRB,2.3135E+00_JPRB/)


!     The array KB contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of O3 to CO2.  The first index in the array, JS, runs from 1 to 5, 
!     and corresponds to different O3 to CO2 ratios, as expressed through 
!     the binary species parameter eta, defined as eta = O3/(O3+RAT*CO2), 
!     where RAT is the ratio of the integrated line strength in the band 
!     of co2 to that of O3.  For instance, JS=1 refers to no O3 (eta = 0) 
!     and JS = 5 corresponds to eta = 1.0.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.

KBO( :, 1,13, 1) = (/&
&3.4470E-06_JPRB,2.6372E-04_JPRB,5.1063E-04_JPRB,7.5257E-04_JPRB,1.0534E-03_JPRB/)
KBO( :, 2,13, 1) = (/&
&4.0516E-06_JPRB,3.2949E-04_JPRB,6.3499E-04_JPRB,9.3141E-04_JPRB,1.3018E-03_JPRB/)
KBO( :, 3,13, 1) = (/&
&5.1108E-06_JPRB,3.9538E-04_JPRB,7.5778E-04_JPRB,1.1060E-03_JPRB,1.5459E-03_JPRB/)
KBO( :, 4,13, 1) = (/&
&6.7999E-06_JPRB,4.6001E-04_JPRB,8.7452E-04_JPRB,1.2718E-03_JPRB,1.7787E-03_JPRB/)
KBO( :, 5,13, 1) = (/&
&9.3241E-06_JPRB,5.2270E-04_JPRB,9.8350E-04_JPRB,1.4243E-03_JPRB,1.9970E-03_JPRB/)
KBO( :, 1,14, 1) = (/&
&2.8624E-06_JPRB,2.2203E-04_JPRB,4.2960E-04_JPRB,6.3242E-04_JPRB,8.7262E-04_JPRB/)
KBO( :, 2,14, 1) = (/&
&3.3872E-06_JPRB,2.7597E-04_JPRB,5.3199E-04_JPRB,7.7931E-04_JPRB,1.0726E-03_JPRB/)
KBO( :, 3,14, 1) = (/&
&4.3001E-06_JPRB,3.2993E-04_JPRB,6.3195E-04_JPRB,9.2225E-04_JPRB,1.2666E-03_JPRB/)
KBO( :, 4,14, 1) = (/&
&5.7406E-06_JPRB,3.8294E-04_JPRB,7.2707E-04_JPRB,1.0576E-03_JPRB,1.4495E-03_JPRB/)
KBO( :, 5,14, 1) = (/&
&7.8860E-06_JPRB,4.3459E-04_JPRB,8.1591E-04_JPRB,1.1810E-03_JPRB,1.6187E-03_JPRB/)
KBO( :, 1,15, 1) = (/&
&2.3825E-06_JPRB,1.8697E-04_JPRB,3.6183E-04_JPRB,5.3195E-04_JPRB,7.2587E-04_JPRB/)
KBO( :, 2,15, 1) = (/&
&2.8419E-06_JPRB,2.3121E-04_JPRB,4.4556E-04_JPRB,6.5240E-04_JPRB,8.8767E-04_JPRB/)
KBO( :, 3,15, 1) = (/&
&3.6307E-06_JPRB,2.7550E-04_JPRB,5.2710E-04_JPRB,7.6940E-04_JPRB,1.0435E-03_JPRB/)
KBO( :, 4,15, 1) = (/&
&4.8654E-06_JPRB,3.1911E-04_JPRB,6.0466E-04_JPRB,8.7922E-04_JPRB,1.1890E-03_JPRB/)
KBO( :, 5,15, 1) = (/&
&6.6952E-06_JPRB,3.6172E-04_JPRB,6.7720E-04_JPRB,9.7928E-04_JPRB,1.3218E-03_JPRB/)
KBO( :, 1,16, 1) = (/&
&1.9858E-06_JPRB,1.5742E-04_JPRB,3.0462E-04_JPRB,4.4743E-04_JPRB,6.0679E-04_JPRB/)
KBO( :, 2,16, 1) = (/&
&2.3893E-06_JPRB,1.9376E-04_JPRB,3.7303E-04_JPRB,5.4624E-04_JPRB,7.3818E-04_JPRB/)
KBO( :, 3,16, 1) = (/&
&3.0717E-06_JPRB,2.3016E-04_JPRB,4.3960E-04_JPRB,6.4157E-04_JPRB,8.6419E-04_JPRB/)
KBO( :, 4,16, 1) = (/&
&4.1308E-06_JPRB,2.6599E-04_JPRB,5.0281E-04_JPRB,7.3058E-04_JPRB,9.8120E-04_JPRB/)
KBO( :, 5,16, 1) = (/&
&5.6927E-06_JPRB,3.0109E-04_JPRB,5.6202E-04_JPRB,8.1155E-04_JPRB,1.0872E-03_JPRB/)
KBO( :, 1,17, 1) = (/&
&1.6559E-06_JPRB,1.3226E-04_JPRB,2.5580E-04_JPRB,3.7568E-04_JPRB,5.0686E-04_JPRB/)
KBO( :, 2,17, 1) = (/&
&2.0083E-06_JPRB,1.6212E-04_JPRB,3.1178E-04_JPRB,4.5651E-04_JPRB,6.1368E-04_JPRB/)
KBO( :, 3,17, 1) = (/&
&2.5968E-06_JPRB,1.9205E-04_JPRB,3.6613E-04_JPRB,5.3405E-04_JPRB,7.1563E-04_JPRB/)
KBO( :, 4,17, 1) = (/&
&3.5047E-06_JPRB,2.2153E-04_JPRB,4.1782E-04_JPRB,6.0641E-04_JPRB,8.1002E-04_JPRB/)
KBO( :, 5,17, 1) = (/&
&4.8351E-06_JPRB,2.5056E-04_JPRB,4.6632E-04_JPRB,6.7217E-04_JPRB,8.9508E-04_JPRB/)
KBO( :, 1,18, 1) = (/&
&1.3818E-06_JPRB,1.1100E-04_JPRB,2.1454E-04_JPRB,3.1506E-04_JPRB,4.2338E-04_JPRB/)
KBO( :, 2,18, 1) = (/&
&1.6887E-06_JPRB,1.3556E-04_JPRB,2.6035E-04_JPRB,3.8099E-04_JPRB,5.1025E-04_JPRB/)
KBO( :, 3,18, 1) = (/&
&2.1957E-06_JPRB,1.6016E-04_JPRB,3.0479E-04_JPRB,4.4417E-04_JPRB,5.9284E-04_JPRB/)
KBO( :, 4,18, 1) = (/&
&2.9733E-06_JPRB,1.8444E-04_JPRB,3.4704E-04_JPRB,5.0300E-04_JPRB,6.6896E-04_JPRB/)
KBO( :, 5,18, 1) = (/&
&4.1061E-06_JPRB,2.0846E-04_JPRB,3.8680E-04_JPRB,5.5649E-04_JPRB,7.3738E-04_JPRB/)
KBO( :, 1,19, 1) = (/&
&1.1530E-06_JPRB,9.3038E-05_JPRB,1.7970E-04_JPRB,2.6380E-04_JPRB,3.5309E-04_JPRB/)
KBO( :, 2,19, 1) = (/&
&1.4193E-06_JPRB,1.1326E-04_JPRB,2.1722E-04_JPRB,3.1768E-04_JPRB,4.2371E-04_JPRB/)
KBO( :, 3,19, 1) = (/&
&1.8551E-06_JPRB,1.3348E-04_JPRB,2.5355E-04_JPRB,3.6914E-04_JPRB,4.9054E-04_JPRB/)
KBO( :, 4,19, 1) = (/&
&2.5194E-06_JPRB,1.5356E-04_JPRB,2.8811E-04_JPRB,4.1698E-04_JPRB,5.5182E-04_JPRB/)
KBO( :, 5,19, 1) = (/&
&3.4823E-06_JPRB,1.7336E-04_JPRB,3.2068E-04_JPRB,4.6050E-04_JPRB,6.0663E-04_JPRB/)
KBO( :, 1,20, 1) = (/&
&9.6514E-07_JPRB,7.8220E-05_JPRB,1.5093E-04_JPRB,2.2146E-04_JPRB,2.9562E-04_JPRB/)
KBO( :, 2,20, 1) = (/&
&1.1977E-06_JPRB,9.4837E-05_JPRB,1.8160E-04_JPRB,2.6538E-04_JPRB,3.5295E-04_JPRB/)
KBO( :, 3,20, 1) = (/&
&1.5743E-06_JPRB,1.1151E-04_JPRB,2.1133E-04_JPRB,3.0732E-04_JPRB,4.0705E-04_JPRB/)
KBO( :, 4,20, 1) = (/&
&2.1452E-06_JPRB,1.2810E-04_JPRB,2.3959E-04_JPRB,3.4625E-04_JPRB,4.5647E-04_JPRB/)
KBO( :, 5,20, 1) = (/&
&2.9673E-06_JPRB,1.4434E-04_JPRB,2.6631E-04_JPRB,3.8162E-04_JPRB,5.0047E-04_JPRB/)
KBO( :, 1,21, 1) = (/&
&8.0884E-07_JPRB,6.5739E-05_JPRB,1.2670E-04_JPRB,1.8581E-04_JPRB,2.4748E-04_JPRB/)
KBO( :, 2,21, 1) = (/&
&1.0118E-06_JPRB,7.9430E-05_JPRB,1.5182E-04_JPRB,2.2166E-04_JPRB,2.9412E-04_JPRB/)
KBO( :, 3,21, 1) = (/&
&1.3370E-06_JPRB,9.3177E-05_JPRB,1.7611E-04_JPRB,2.5580E-04_JPRB,3.3790E-04_JPRB/)
KBO( :, 4,21, 1) = (/&
&1.8276E-06_JPRB,1.0684E-04_JPRB,1.9928E-04_JPRB,2.8745E-04_JPRB,3.7772E-04_JPRB/)
KBO( :, 5,21, 1) = (/&
&2.5289E-06_JPRB,1.2011E-04_JPRB,2.2122E-04_JPRB,3.1628E-04_JPRB,4.1308E-04_JPRB/)
KBO( :, 1,22, 1) = (/&
&6.8770E-07_JPRB,5.5977E-05_JPRB,1.0768E-04_JPRB,1.5779E-04_JPRB,2.0975E-04_JPRB/)
KBO( :, 2,22, 1) = (/&
&8.7051E-07_JPRB,6.7267E-05_JPRB,1.2822E-04_JPRB,1.8696E-04_JPRB,2.4752E-04_JPRB/)
KBO( :, 3,22, 1) = (/&
&1.1593E-06_JPRB,7.8612E-05_JPRB,1.4804E-04_JPRB,2.1465E-04_JPRB,2.8275E-04_JPRB/)
KBO( :, 4,22, 1) = (/&
&1.5914E-06_JPRB,8.9752E-05_JPRB,1.6700E-04_JPRB,2.4024E-04_JPRB,3.1462E-04_JPRB/)
KBO( :, 5,22, 1) = (/&
&2.2022E-06_JPRB,1.0055E-04_JPRB,1.8482E-04_JPRB,2.6358E-04_JPRB,3.4283E-04_JPRB/)
KBO( :, 1,23, 1) = (/&
&5.8681E-07_JPRB,4.7674E-05_JPRB,9.1507E-05_JPRB,1.3393E-04_JPRB,1.7770E-04_JPRB/)
KBO( :, 2,23, 1) = (/&
&7.5149E-07_JPRB,5.7003E-05_JPRB,1.0829E-04_JPRB,1.5767E-04_JPRB,2.0825E-04_JPRB/)
KBO( :, 3,23, 1) = (/&
&1.0080E-06_JPRB,6.6289E-05_JPRB,1.2450E-04_JPRB,1.8010E-04_JPRB,2.3658E-04_JPRB/)
KBO( :, 4,23, 1) = (/&
&1.3887E-06_JPRB,7.5365E-05_JPRB,1.3995E-04_JPRB,2.0079E-04_JPRB,2.6204E-04_JPRB/)
KBO( :, 5,23, 1) = (/&
&1.9208E-06_JPRB,8.4126E-05_JPRB,1.5435E-04_JPRB,2.1972E-04_JPRB,2.8449E-04_JPRB/)
KBO( :, 1,24, 1) = (/&
&5.0292E-07_JPRB,4.0632E-05_JPRB,7.7788E-05_JPRB,1.1370E-04_JPRB,1.5053E-04_JPRB/)
KBO( :, 2,24, 1) = (/&
&6.5118E-07_JPRB,4.8318E-05_JPRB,9.1504E-05_JPRB,1.3299E-04_JPRB,1.7517E-04_JPRB/)
KBO( :, 3,24, 1) = (/&
&8.7976E-07_JPRB,5.5886E-05_JPRB,1.0475E-04_JPRB,1.5115E-04_JPRB,1.9787E-04_JPRB/)
KBO( :, 4,24, 1) = (/&
&1.2151E-06_JPRB,6.3269E-05_JPRB,1.1727E-04_JPRB,1.6792E-04_JPRB,2.1820E-04_JPRB/)
KBO( :, 5,24, 1) = (/&
&1.6790E-06_JPRB,7.0361E-05_JPRB,1.2886E-04_JPRB,1.8317E-04_JPRB,2.3599E-04_JPRB/)
KBO( :, 1,25, 1) = (/&
&4.3320E-07_JPRB,3.4672E-05_JPRB,6.6172E-05_JPRB,9.6557E-05_JPRB,1.2755E-04_JPRB/)
KBO( :, 2,25, 1) = (/&
&5.6706E-07_JPRB,4.0954E-05_JPRB,7.7399E-05_JPRB,1.1224E-04_JPRB,1.4744E-04_JPRB/)
KBO( :, 3,25, 1) = (/&
&7.7121E-07_JPRB,4.7130E-05_JPRB,8.8173E-05_JPRB,1.2695E-04_JPRB,1.6559E-04_JPRB/)
KBO( :, 4,25, 1) = (/&
&1.0669E-06_JPRB,5.3117E-05_JPRB,9.8264E-05_JPRB,1.4052E-04_JPRB,1.8177E-04_JPRB/)
KBO( :, 5,25, 1) = (/&
&1.4722E-06_JPRB,5.8854E-05_JPRB,1.0754E-04_JPRB,1.5271E-04_JPRB,1.9584E-04_JPRB/)
KBO( :, 1,26, 1) = (/&
&3.7607E-07_JPRB,2.9637E-05_JPRB,5.6418E-05_JPRB,8.2160E-05_JPRB,1.0828E-04_JPRB/)
KBO( :, 2,26, 1) = (/&
&4.9757E-07_JPRB,3.4761E-05_JPRB,6.5581E-05_JPRB,9.4869E-05_JPRB,1.2424E-04_JPRB/)
KBO( :, 3,26, 1) = (/&
&6.8088E-07_JPRB,3.9782E-05_JPRB,7.4280E-05_JPRB,1.0678E-04_JPRB,1.3874E-04_JPRB/)
KBO( :, 4,26, 1) = (/&
&9.4259E-07_JPRB,4.4634E-05_JPRB,8.2385E-05_JPRB,1.1768E-04_JPRB,1.5157E-04_JPRB/)
KBO( :, 5,26, 1) = (/&
&1.2981E-06_JPRB,4.9274E-05_JPRB,8.9787E-05_JPRB,1.2735E-04_JPRB,1.6265E-04_JPRB/)
KBO( :, 1,27, 1) = (/&
&3.2783E-07_JPRB,2.5292E-05_JPRB,4.8063E-05_JPRB,6.9840E-05_JPRB,9.1852E-05_JPRB/)
KBO( :, 2,27, 1) = (/&
&4.3792E-07_JPRB,2.9476E-05_JPRB,5.5497E-05_JPRB,8.0152E-05_JPRB,1.0466E-04_JPRB/)
KBO( :, 3,27, 1) = (/&
&6.0227E-07_JPRB,3.3553E-05_JPRB,6.2514E-05_JPRB,8.9762E-05_JPRB,1.1621E-04_JPRB/)
KBO( :, 4,27, 1) = (/&
&8.3354E-07_JPRB,3.7479E-05_JPRB,6.9000E-05_JPRB,9.8462E-05_JPRB,1.2640E-04_JPRB/)
KBO( :, 5,27, 1) = (/&
&1.1448E-06_JPRB,4.1239E-05_JPRB,7.4917E-05_JPRB,1.0612E-04_JPRB,1.3514E-04_JPRB/)
KBO( :, 1,28, 1) = (/&
&2.8669E-07_JPRB,2.1556E-05_JPRB,4.0892E-05_JPRB,5.9304E-05_JPRB,7.7833E-05_JPRB/)
KBO( :, 2,28, 1) = (/&
&3.8635E-07_JPRB,2.4960E-05_JPRB,4.6902E-05_JPRB,6.7670E-05_JPRB,8.8103E-05_JPRB/)
KBO( :, 3,28, 1) = (/&
&5.3330E-07_JPRB,2.8270E-05_JPRB,5.2542E-05_JPRB,7.5364E-05_JPRB,9.7308E-05_JPRB/)
KBO( :, 4,28, 1) = (/&
&7.3734E-07_JPRB,3.1446E-05_JPRB,5.7727E-05_JPRB,8.2286E-05_JPRB,1.0537E-04_JPRB/)
KBO( :, 5,28, 1) = (/&
&1.0096E-06_JPRB,3.4495E-05_JPRB,6.2455E-05_JPRB,8.8340E-05_JPRB,1.1227E-04_JPRB/)
KBO( :, 1,29, 1) = (/&
&2.5201E-07_JPRB,1.8361E-05_JPRB,3.4763E-05_JPRB,5.0351E-05_JPRB,6.5987E-05_JPRB/)
KBO( :, 2,29, 1) = (/&
&3.4236E-07_JPRB,2.1129E-05_JPRB,3.9617E-05_JPRB,5.7095E-05_JPRB,7.4216E-05_JPRB/)
KBO( :, 3,29, 1) = (/&
&4.7361E-07_JPRB,2.3813E-05_JPRB,4.4138E-05_JPRB,6.3255E-05_JPRB,8.1563E-05_JPRB/)
KBO( :, 4,29, 1) = (/&
&6.5380E-07_JPRB,2.6387E-05_JPRB,4.8286E-05_JPRB,6.8730E-05_JPRB,8.7959E-05_JPRB/)
KBO( :, 5,29, 1) = (/&
&8.9193E-07_JPRB,2.8857E-05_JPRB,5.2062E-05_JPRB,7.3497E-05_JPRB,9.3411E-05_JPRB/)
KBO( :, 1,30, 1) = (/&
&2.2221E-07_JPRB,1.5617E-05_JPRB,2.9506E-05_JPRB,4.2701E-05_JPRB,5.5901E-05_JPRB/)
KBO( :, 2,30, 1) = (/&
&3.0397E-07_JPRB,1.7865E-05_JPRB,3.3414E-05_JPRB,4.8107E-05_JPRB,6.2491E-05_JPRB/)
KBO( :, 3,30, 1) = (/&
&4.2084E-07_JPRB,2.0038E-05_JPRB,3.7035E-05_JPRB,5.3015E-05_JPRB,6.8354E-05_JPRB/)
KBO( :, 4,30, 1) = (/&
&5.7974E-07_JPRB,2.2125E-05_JPRB,4.0351E-05_JPRB,5.7341E-05_JPRB,7.3435E-05_JPRB/)
KBO( :, 5,30, 1) = (/&
&7.8765E-07_JPRB,2.4127E-05_JPRB,4.3366E-05_JPRB,6.1092E-05_JPRB,7.7733E-05_JPRB/)
KBO( :, 1,31, 1) = (/&
&1.9681E-07_JPRB,1.3270E-05_JPRB,2.5018E-05_JPRB,3.6169E-05_JPRB,4.7371E-05_JPRB/)
KBO( :, 2,31, 1) = (/&
&2.7071E-07_JPRB,1.5097E-05_JPRB,2.8159E-05_JPRB,4.0500E-05_JPRB,5.2659E-05_JPRB/)
KBO( :, 3,31, 1) = (/&
&3.7475E-07_JPRB,1.6858E-05_JPRB,3.1057E-05_JPRB,4.4392E-05_JPRB,5.7349E-05_JPRB/)
KBO( :, 4,31, 1) = (/&
&5.1477E-07_JPRB,1.8547E-05_JPRB,3.3705E-05_JPRB,4.7805E-05_JPRB,6.1389E-05_JPRB/)
KBO( :, 5,31, 1) = (/&
&6.9625E-07_JPRB,2.0170E-05_JPRB,3.6118E-05_JPRB,5.0758E-05_JPRB,6.4797E-05_JPRB/)
KBO( :, 1,32, 1) = (/&
&1.7485E-07_JPRB,1.1265E-05_JPRB,2.1186E-05_JPRB,3.0600E-05_JPRB,4.0119E-05_JPRB/)
KBO( :, 2,32, 1) = (/&
&2.4148E-07_JPRB,1.2747E-05_JPRB,2.3704E-05_JPRB,3.4052E-05_JPRB,4.4364E-05_JPRB/)
KBO( :, 3,32, 1) = (/&
&3.3391E-07_JPRB,1.4173E-05_JPRB,2.6023E-05_JPRB,3.7134E-05_JPRB,4.8107E-05_JPRB/)
KBO( :, 4,32, 1) = (/&
&4.5712E-07_JPRB,1.5544E-05_JPRB,2.8139E-05_JPRB,3.9822E-05_JPRB,5.1320E-05_JPRB/)
KBO( :, 5,32, 1) = (/&
&6.1526E-07_JPRB,1.6857E-05_JPRB,3.0064E-05_JPRB,4.2147E-05_JPRB,5.4009E-05_JPRB/)
KBO( :, 1,33, 1) = (/&
&1.5570E-07_JPRB,9.5475E-06_JPRB,1.7911E-05_JPRB,2.5842E-05_JPRB,3.3957E-05_JPRB/)
KBO( :, 2,33, 1) = (/&
&2.1549E-07_JPRB,1.0751E-05_JPRB,1.9931E-05_JPRB,2.8592E-05_JPRB,3.7370E-05_JPRB/)
KBO( :, 3,33, 1) = (/&
&2.9746E-07_JPRB,1.1906E-05_JPRB,2.1783E-05_JPRB,3.1027E-05_JPRB,4.0353E-05_JPRB/)
KBO( :, 4,33, 1) = (/&
&4.0565E-07_JPRB,1.3019E-05_JPRB,2.3473E-05_JPRB,3.3146E-05_JPRB,4.2910E-05_JPRB/)
KBO( :, 5,33, 1) = (/&
&5.4308E-07_JPRB,1.4082E-05_JPRB,2.5010E-05_JPRB,3.4973E-05_JPRB,4.5040E-05_JPRB/)
KBO( :, 1,34, 1) = (/&
&1.3721E-07_JPRB,8.0465E-06_JPRB,1.5060E-05_JPRB,2.1707E-05_JPRB,2.8588E-05_JPRB/)
KBO( :, 2,34, 1) = (/&
&1.9002E-07_JPRB,9.0232E-06_JPRB,1.6681E-05_JPRB,2.3900E-05_JPRB,3.1327E-05_JPRB/)
KBO( :, 3,34, 1) = (/&
&2.6180E-07_JPRB,9.9630E-06_JPRB,1.8168E-05_JPRB,2.5833E-05_JPRB,3.3720E-05_JPRB/)
KBO( :, 4,34, 1) = (/&
&3.5566E-07_JPRB,1.0865E-05_JPRB,1.9523E-05_JPRB,2.7511E-05_JPRB,3.5767E-05_JPRB/)
KBO( :, 5,34, 1) = (/&
&4.7391E-07_JPRB,1.1726E-05_JPRB,2.0751E-05_JPRB,2.8954E-05_JPRB,3.7468E-05_JPRB/)
KBO( :, 1,35, 1) = (/&
&1.1723E-07_JPRB,6.6964E-06_JPRB,1.2516E-05_JPRB,1.8031E-05_JPRB,2.3821E-05_JPRB/)
KBO( :, 2,35, 1) = (/&
&1.6235E-07_JPRB,7.4927E-06_JPRB,1.3829E-05_JPRB,1.9800E-05_JPRB,2.6051E-05_JPRB/)
KBO( :, 3,35, 1) = (/&
&2.2335E-07_JPRB,8.2568E-06_JPRB,1.5029E-05_JPRB,2.1350E-05_JPRB,2.8000E-05_JPRB/)
KBO( :, 4,35, 1) = (/&
&3.0275E-07_JPRB,8.9930E-06_JPRB,1.6127E-05_JPRB,2.2699E-05_JPRB,2.9671E-05_JPRB/)
KBO( :, 5,35, 1) = (/&
&4.0236E-07_JPRB,9.6965E-06_JPRB,1.7121E-05_JPRB,2.3858E-05_JPRB,3.1064E-05_JPRB/)
KBO( :, 1,36, 1) = (/&
&9.6662E-08_JPRB,5.4982E-06_JPRB,1.0275E-05_JPRB,1.4804E-05_JPRB,1.9630E-05_JPRB/)
KBO( :, 2,36, 1) = (/&
&1.3386E-07_JPRB,6.1501E-06_JPRB,1.1348E-05_JPRB,1.6247E-05_JPRB,2.1474E-05_JPRB/)
KBO( :, 3,36, 1) = (/&
&1.8410E-07_JPRB,6.7756E-06_JPRB,1.2329E-05_JPRB,1.7513E-05_JPRB,2.3090E-05_JPRB/)
KBO( :, 4,36, 1) = (/&
&2.4947E-07_JPRB,7.3775E-06_JPRB,1.3225E-05_JPRB,1.8612E-05_JPRB,2.4479E-05_JPRB/)
KBO( :, 5,36, 1) = (/&
&3.3138E-07_JPRB,7.9539E-06_JPRB,1.4038E-05_JPRB,1.9559E-05_JPRB,2.5645E-05_JPRB/)
KBO( :, 1,37, 1) = (/&
&7.5833E-08_JPRB,4.4319E-06_JPRB,8.2961E-06_JPRB,1.1965E-05_JPRB,1.5922E-05_JPRB/)
KBO( :, 2,37, 1) = (/&
&1.0502E-07_JPRB,4.9674E-06_JPRB,9.1830E-06_JPRB,1.3164E-05_JPRB,1.7469E-05_JPRB/)
KBO( :, 3,37, 1) = (/&
&1.4465E-07_JPRB,5.4834E-06_JPRB,9.9967E-06_JPRB,1.4218E-05_JPRB,1.8834E-05_JPRB/)
KBO( :, 4,37, 1) = (/&
&1.9645E-07_JPRB,5.9788E-06_JPRB,1.0738E-05_JPRB,1.5133E-05_JPRB,2.0012E-05_JPRB/)
KBO( :, 5,37, 1) = (/&
&2.6166E-07_JPRB,6.4529E-06_JPRB,1.1414E-05_JPRB,1.5924E-05_JPRB,2.1010E-05_JPRB/)
KBO( :, 1,38, 1) = (/&
&5.9339E-08_JPRB,3.5670E-06_JPRB,6.6893E-06_JPRB,9.6566E-06_JPRB,1.2902E-05_JPRB/)
KBO( :, 2,38, 1) = (/&
&8.2155E-08_JPRB,4.0080E-06_JPRB,7.4233E-06_JPRB,1.0653E-05_JPRB,1.4205E-05_JPRB/)
KBO( :, 3,38, 1) = (/&
&1.1331E-07_JPRB,4.4325E-06_JPRB,8.0980E-06_JPRB,1.1532E-05_JPRB,1.5359E-05_JPRB/)
KBO( :, 4,38, 1) = (/&
&1.5427E-07_JPRB,4.8410E-06_JPRB,8.7132E-06_JPRB,1.2297E-05_JPRB,1.6364E-05_JPRB/)
KBO( :, 5,38, 1) = (/&
&2.0603E-07_JPRB,5.2310E-06_JPRB,9.2738E-06_JPRB,1.2957E-05_JPRB,1.7220E-05_JPRB/)
KBO( :, 1,39, 1) = (/&
&4.6457E-08_JPRB,2.8706E-06_JPRB,5.3922E-06_JPRB,7.7916E-06_JPRB,1.0463E-05_JPRB/)
KBO( :, 2,39, 1) = (/&
&6.4280E-08_JPRB,3.2335E-06_JPRB,5.9995E-06_JPRB,8.6193E-06_JPRB,1.1561E-05_JPRB/)
KBO( :, 3,39, 1) = (/&
&8.8753E-08_JPRB,3.5826E-06_JPRB,6.5580E-06_JPRB,9.3509E-06_JPRB,1.2539E-05_JPRB/)
KBO( :, 4,39, 1) = (/&
&1.2109E-07_JPRB,3.9186E-06_JPRB,7.0688E-06_JPRB,9.9899E-06_JPRB,1.3398E-05_JPRB/)
KBO( :, 5,39, 1) = (/&
&1.6221E-07_JPRB,4.2407E-06_JPRB,7.5350E-06_JPRB,1.0543E-05_JPRB,1.4137E-05_JPRB/)
KBO( :, 1,40, 1) = (/&
&3.5213E-08_JPRB,2.2779E-06_JPRB,4.2906E-06_JPRB,6.2087E-06_JPRB,8.3621E-06_JPRB/)
KBO( :, 2,40, 1) = (/&
&4.8621E-08_JPRB,2.5769E-06_JPRB,4.7967E-06_JPRB,6.9026E-06_JPRB,9.2884E-06_JPRB/)
KBO( :, 3,40, 1) = (/&
&6.7228E-08_JPRB,2.8656E-06_JPRB,5.2643E-06_JPRB,7.5217E-06_JPRB,1.0122E-05_JPRB/)
KBO( :, 4,40, 1) = (/&
&9.2051E-08_JPRB,3.1437E-06_JPRB,5.6919E-06_JPRB,8.0632E-06_JPRB,1.0858E-05_JPRB/)
KBO( :, 5,40, 1) = (/&
&1.2392E-07_JPRB,3.4099E-06_JPRB,6.0819E-06_JPRB,8.5318E-06_JPRB,1.1495E-05_JPRB/)
KBO( :, 1,41, 1) = (/&
&2.6618E-08_JPRB,1.8019E-06_JPRB,3.4036E-06_JPRB,4.9321E-06_JPRB,6.6614E-06_JPRB/)
KBO( :, 2,41, 1) = (/&
&3.6608E-08_JPRB,2.0487E-06_JPRB,3.8262E-06_JPRB,5.5154E-06_JPRB,7.4437E-06_JPRB/)
KBO( :, 3,41, 1) = (/&
&5.0672E-08_JPRB,2.2872E-06_JPRB,4.2170E-06_JPRB,6.0380E-06_JPRB,8.1516E-06_JPRB/)
KBO( :, 4,41, 1) = (/&
&6.9610E-08_JPRB,2.5171E-06_JPRB,4.5756E-06_JPRB,6.4977E-06_JPRB,8.7822E-06_JPRB/)
KBO( :, 5,41, 1) = (/&
&9.4152E-08_JPRB,2.7376E-06_JPRB,4.9025E-06_JPRB,6.8959E-06_JPRB,9.3313E-06_JPRB/)
KBO( :, 1,42, 1) = (/&
&2.0157E-08_JPRB,1.4234E-06_JPRB,2.6959E-06_JPRB,3.9114E-06_JPRB,5.2999E-06_JPRB/)
KBO( :, 2,42, 1) = (/&
&2.7569E-08_JPRB,1.6266E-06_JPRB,3.0478E-06_JPRB,4.4003E-06_JPRB,5.9585E-06_JPRB/)
KBO( :, 3,42, 1) = (/&
&3.8168E-08_JPRB,1.8237E-06_JPRB,3.3743E-06_JPRB,4.8412E-06_JPRB,6.5607E-06_JPRB/)
KBO( :, 4,42, 1) = (/&
&5.2578E-08_JPRB,2.0137E-06_JPRB,3.6751E-06_JPRB,5.2309E-06_JPRB,7.1001E-06_JPRB/)
KBO( :, 5,42, 1) = (/&
&7.1438E-08_JPRB,2.1965E-06_JPRB,3.9491E-06_JPRB,5.5693E-06_JPRB,7.5736E-06_JPRB/)
KBO( :, 1,43, 1) = (/&
&1.5048E-08_JPRB,1.1128E-06_JPRB,2.1143E-06_JPRB,3.0719E-06_JPRB,4.1759E-06_JPRB/)
KBO( :, 2,43, 1) = (/&
&2.0401E-08_JPRB,1.2805E-06_JPRB,2.4084E-06_JPRB,3.4833E-06_JPRB,4.7326E-06_JPRB/)
KBO( :, 3,43, 1) = (/&
&2.8205E-08_JPRB,1.4438E-06_JPRB,2.6828E-06_JPRB,3.8579E-06_JPRB,5.2466E-06_JPRB/)
KBO( :, 4,43, 1) = (/&
&3.8951E-08_JPRB,1.6012E-06_JPRB,2.9353E-06_JPRB,4.1897E-06_JPRB,5.7090E-06_JPRB/)
KBO( :, 5,43, 1) = (/&
&5.3191E-08_JPRB,1.7525E-06_JPRB,3.1662E-06_JPRB,4.4792E-06_JPRB,6.1200E-06_JPRB/)
KBO( :, 1,44, 1) = (/&
&1.1198E-08_JPRB,8.6431E-07_JPRB,1.6473E-06_JPRB,2.3969E-06_JPRB,3.2705E-06_JPRB/)
KBO( :, 2,44, 1) = (/&
&1.5007E-08_JPRB,1.0027E-06_JPRB,1.8931E-06_JPRB,2.7433E-06_JPRB,3.7404E-06_JPRB/)
KBO( :, 3,44, 1) = (/&
&2.0665E-08_JPRB,1.1376E-06_JPRB,2.1233E-06_JPRB,3.0602E-06_JPRB,4.1782E-06_JPRB/)
KBO( :, 4,44, 1) = (/&
&2.8586E-08_JPRB,1.2680E-06_JPRB,2.3363E-06_JPRB,3.3439E-06_JPRB,4.5764E-06_JPRB/)
KBO( :, 5,44, 1) = (/&
&3.9218E-08_JPRB,1.3937E-06_JPRB,2.5309E-06_JPRB,3.5921E-06_JPRB,4.9322E-06_JPRB/)
KBO( :, 1,45, 1) = (/&
&8.3759E-09_JPRB,6.6910E-07_JPRB,1.2788E-06_JPRB,1.8633E-06_JPRB,2.5541E-06_JPRB/)
KBO( :, 2,45, 1) = (/&
&1.1074E-08_JPRB,7.8311E-07_JPRB,1.4838E-06_JPRB,2.1538E-06_JPRB,2.9501E-06_JPRB/)
KBO( :, 3,45, 1) = (/&
&1.5144E-08_JPRB,8.9455E-07_JPRB,1.6769E-06_JPRB,2.4217E-06_JPRB,3.3225E-06_JPRB/)
KBO( :, 4,45, 1) = (/&
&2.0959E-08_JPRB,1.0028E-06_JPRB,1.8560E-06_JPRB,2.6635E-06_JPRB,3.6644E-06_JPRB/)
KBO( :, 5,45, 1) = (/&
&2.8861E-08_JPRB,1.1068E-06_JPRB,2.0205E-06_JPRB,2.8768E-06_JPRB,3.9736E-06_JPRB/)
KBO( :, 1,46, 1) = (/&
&6.2739E-09_JPRB,5.1407E-07_JPRB,9.8522E-07_JPRB,1.4377E-06_JPRB,1.9806E-06_JPRB/)
KBO( :, 2,46, 1) = (/&
&8.1529E-09_JPRB,6.0797E-07_JPRB,1.1561E-06_JPRB,1.6807E-06_JPRB,2.3136E-06_JPRB/)
KBO( :, 3,46, 1) = (/&
&1.1038E-08_JPRB,7.0008E-07_JPRB,1.3179E-06_JPRB,1.9073E-06_JPRB,2.6301E-06_JPRB/)
KBO( :, 4,46, 1) = (/&
&1.5249E-08_JPRB,7.8964E-07_JPRB,1.4688E-06_JPRB,2.1133E-06_JPRB,2.9239E-06_JPRB/)
KBO( :, 5,46, 1) = (/&
&2.1058E-08_JPRB,8.7606E-07_JPRB,1.6079E-06_JPRB,2.2965E-06_JPRB,3.1920E-06_JPRB/)
KBO( :, 1,47, 1) = (/&
&4.6949E-09_JPRB,3.8992E-07_JPRB,7.4927E-07_JPRB,1.0952E-06_JPRB,1.5159E-06_JPRB/)
KBO( :, 2,47, 1) = (/&
&5.9645E-09_JPRB,4.6716E-07_JPRB,8.9151E-07_JPRB,1.2982E-06_JPRB,1.7952E-06_JPRB/)
KBO( :, 3,47, 1) = (/&
&7.9612E-09_JPRB,5.4321E-07_JPRB,1.0272E-06_JPRB,1.4897E-06_JPRB,2.0633E-06_JPRB/)
KBO( :, 4,47, 1) = (/&
&1.0938E-08_JPRB,6.1746E-07_JPRB,1.1545E-06_JPRB,1.6654E-06_JPRB,2.3153E-06_JPRB/)
KBO( :, 5,47, 1) = (/&
&1.5132E-08_JPRB,6.8917E-07_JPRB,1.2721E-06_JPRB,1.8228E-06_JPRB,2.5468E-06_JPRB/)
KBO( :, 1,48, 1) = (/&
&3.5531E-09_JPRB,2.9393E-07_JPRB,5.6622E-07_JPRB,8.2884E-07_JPRB,1.1544E-06_JPRB/)
KBO( :, 2,48, 1) = (/&
&4.3982E-09_JPRB,3.5721E-07_JPRB,6.8388E-07_JPRB,9.9751E-07_JPRB,1.3878E-06_JPRB/)
KBO( :, 3,48, 1) = (/&
&5.7699E-09_JPRB,4.1995E-07_JPRB,7.9742E-07_JPRB,1.1586E-06_JPRB,1.6142E-06_JPRB/)
KBO( :, 4,48, 1) = (/&
&7.8542E-09_JPRB,4.8132E-07_JPRB,9.0450E-07_JPRB,1.3078E-06_JPRB,1.8297E-06_JPRB/)
KBO( :, 5,48, 1) = (/&
&1.0862E-08_JPRB,5.4098E-07_JPRB,1.0041E-06_JPRB,1.4432E-06_JPRB,2.0302E-06_JPRB/)
KBO( :, 1,49, 1) = (/&
&2.7223E-09_JPRB,2.2011E-07_JPRB,4.2480E-07_JPRB,6.2273E-07_JPRB,8.7522E-07_JPRB/)
KBO( :, 2,49, 1) = (/&
&3.2751E-09_JPRB,2.7175E-07_JPRB,5.2169E-07_JPRB,7.6216E-07_JPRB,1.0695E-06_JPRB/)
KBO( :, 3,49, 1) = (/&
&4.2074E-09_JPRB,3.2338E-07_JPRB,6.1638E-07_JPRB,8.9710E-07_JPRB,1.2605E-06_JPRB/)
KBO( :, 4,49, 1) = (/&
&5.6548E-09_JPRB,3.7408E-07_JPRB,7.0619E-07_JPRB,1.0234E-06_JPRB,1.4445E-06_JPRB/)
KBO( :, 5,49, 1) = (/&
&7.7931E-09_JPRB,4.2353E-07_JPRB,7.9036E-07_JPRB,1.1391E-06_JPRB,1.6183E-06_JPRB/)
KBO( :, 1,50, 1) = (/&
&2.1171E-09_JPRB,1.6461E-07_JPRB,3.1815E-07_JPRB,4.6707E-07_JPRB,6.6131E-07_JPRB/)
KBO( :, 2,50, 1) = (/&
&2.4767E-09_JPRB,2.0654E-07_JPRB,3.9751E-07_JPRB,5.8161E-07_JPRB,8.2129E-07_JPRB/)
KBO( :, 3,50, 1) = (/&
&3.1098E-09_JPRB,2.4898E-07_JPRB,4.7607E-07_JPRB,6.9397E-07_JPRB,9.8108E-07_JPRB/)
KBO( :, 4,50, 1) = (/&
&4.1196E-09_JPRB,2.9082E-07_JPRB,5.5125E-07_JPRB,8.0034E-07_JPRB,1.1364E-06_JPRB/)
KBO( :, 5,50, 1) = (/&
&5.6373E-09_JPRB,3.3169E-07_JPRB,6.2193E-07_JPRB,8.9844E-07_JPRB,1.2847E-06_JPRB/)
KBO( :, 1,51, 1) = (/&
&1.6645E-09_JPRB,1.2257E-07_JPRB,2.3718E-07_JPRB,3.4865E-07_JPRB,4.9717E-07_JPRB/)
KBO( :, 2,51, 1) = (/&
&1.8963E-09_JPRB,1.5653E-07_JPRB,3.0185E-07_JPRB,4.4222E-07_JPRB,6.2797E-07_JPRB/)
KBO( :, 3,51, 1) = (/&
&2.3235E-09_JPRB,1.9123E-07_JPRB,3.6667E-07_JPRB,5.3530E-07_JPRB,7.6057E-07_JPRB/)
KBO( :, 4,51, 1) = (/&
&3.0254E-09_JPRB,2.2572E-07_JPRB,4.2945E-07_JPRB,6.2453E-07_JPRB,8.9069E-07_JPRB/)
KBO( :, 5,51, 1) = (/&
&4.0995E-09_JPRB,2.5950E-07_JPRB,4.8873E-07_JPRB,7.0742E-07_JPRB,1.0163E-06_JPRB/)
KBO( :, 1,52, 1) = (/&
&1.3206E-09_JPRB,9.0571E-08_JPRB,1.7550E-07_JPRB,2.5829E-07_JPRB,3.7195E-07_JPRB/)
KBO( :, 2,52, 1) = (/&
&1.4670E-09_JPRB,1.1797E-07_JPRB,2.2784E-07_JPRB,3.3424E-07_JPRB,4.7844E-07_JPRB/)
KBO( :, 3,52, 1) = (/&
&1.7505E-09_JPRB,1.4623E-07_JPRB,2.8107E-07_JPRB,4.1094E-07_JPRB,5.8801E-07_JPRB/)
KBO( :, 4,52, 1) = (/&
&2.2339E-09_JPRB,1.7460E-07_JPRB,3.3329E-07_JPRB,4.8542E-07_JPRB,6.9695E-07_JPRB/)
KBO( :, 5,52, 1) = (/&
&2.9899E-09_JPRB,2.0250E-07_JPRB,3.8293E-07_JPRB,5.5538E-07_JPRB,8.0322E-07_JPRB/)
KBO( :, 1,53, 1) = (/&
&1.0570E-09_JPRB,6.6355E-08_JPRB,1.2871E-07_JPRB,1.8963E-07_JPRB,2.7719E-07_JPRB/)
KBO( :, 2,53, 1) = (/&
&1.1456E-09_JPRB,8.8306E-08_JPRB,1.7079E-07_JPRB,2.5086E-07_JPRB,3.6333E-07_JPRB/)
KBO( :, 3,53, 1) = (/&
&1.3304E-09_JPRB,1.1127E-07_JPRB,2.1434E-07_JPRB,3.1381E-07_JPRB,4.5369E-07_JPRB/)
KBO( :, 4,53, 1) = (/&
&1.6595E-09_JPRB,1.3454E-07_JPRB,2.5758E-07_JPRB,3.7572E-07_JPRB,5.4496E-07_JPRB/)
KBO( :, 5,53, 1) = (/&
&2.1883E-09_JPRB,1.5755E-07_JPRB,2.9906E-07_JPRB,4.3451E-07_JPRB,6.3482E-07_JPRB/)
KBO( :, 1,54, 1) = (/&
&8.5518E-10_JPRB,4.8675E-08_JPRB,9.4477E-08_JPRB,1.3931E-07_JPRB,2.0489E-07_JPRB/)
KBO( :, 2,54, 1) = (/&
&9.0530E-10_JPRB,6.6186E-08_JPRB,1.2814E-07_JPRB,1.8845E-07_JPRB,2.7365E-07_JPRB/)
KBO( :, 3,54, 1) = (/&
&1.0265E-09_JPRB,8.4782E-08_JPRB,1.6360E-07_JPRB,2.3982E-07_JPRB,3.4689E-07_JPRB/)
KBO( :, 4,54, 1) = (/&
&1.2515E-09_JPRB,1.0381E-07_JPRB,1.9922E-07_JPRB,2.9100E-07_JPRB,4.2180E-07_JPRB/)
KBO( :, 5,54, 1) = (/&
&1.6232E-09_JPRB,1.2276E-07_JPRB,2.3378E-07_JPRB,3.4015E-07_JPRB,4.9603E-07_JPRB/)
KBO( :, 1,55, 1) = (/&
&6.9700E-10_JPRB,3.5570E-08_JPRB,6.9080E-08_JPRB,1.0195E-07_JPRB,1.4991E-07_JPRB/)
KBO( :, 2,55, 1) = (/&
&7.2150E-10_JPRB,4.9476E-08_JPRB,9.5896E-08_JPRB,1.4119E-07_JPRB,2.0429E-07_JPRB/)
KBO( :, 3,55, 1) = (/&
&8.0028E-10_JPRB,6.4502E-08_JPRB,1.2464E-07_JPRB,1.8291E-07_JPRB,2.6311E-07_JPRB/)
KBO( :, 4,55, 1) = (/&
&9.5310E-10_JPRB,8.0013E-08_JPRB,1.5388E-07_JPRB,2.2506E-07_JPRB,3.2381E-07_JPRB/)
KBO( :, 5,55, 1) = (/&
&1.2140E-09_JPRB,9.5569E-08_JPRB,1.8254E-07_JPRB,2.6597E-07_JPRB,3.8428E-07_JPRB/)
KBO( :, 1,56, 1) = (/&
&5.7187E-10_JPRB,2.5788E-08_JPRB,5.0091E-08_JPRB,7.3976E-08_JPRB,1.0884E-07_JPRB/)
KBO( :, 2,56, 1) = (/&
&5.7915E-10_JPRB,3.6758E-08_JPRB,7.1316E-08_JPRB,1.0509E-07_JPRB,1.5165E-07_JPRB/)
KBO( :, 3,56, 1) = (/&
&6.2849E-10_JPRB,4.8831E-08_JPRB,9.4465E-08_JPRB,1.3879E-07_JPRB,1.9866E-07_JPRB/)
KBO( :, 4,56, 1) = (/&
&7.3094E-10_JPRB,6.1436E-08_JPRB,1.1839E-07_JPRB,1.7336E-07_JPRB,2.4772E-07_JPRB/)
KBO( :, 5,56, 1) = (/&
&9.1271E-10_JPRB,7.4209E-08_JPRB,1.4210E-07_JPRB,2.0734E-07_JPRB,2.9707E-07_JPRB/)
KBO( :, 1,57, 1) = (/&
&4.7220E-10_JPRB,1.8526E-08_JPRB,3.5969E-08_JPRB,5.3151E-08_JPRB,7.8305E-08_JPRB/)
KBO( :, 2,57, 1) = (/&
&4.6852E-10_JPRB,2.7111E-08_JPRB,5.2630E-08_JPRB,7.7619E-08_JPRB,1.1181E-07_JPRB/)
KBO( :, 3,57, 1) = (/&
&4.9708E-10_JPRB,3.6762E-08_JPRB,7.1191E-08_JPRB,1.0471E-07_JPRB,1.4926E-07_JPRB/)
KBO( :, 4,57, 1) = (/&
&5.6499E-10_JPRB,4.6985E-08_JPRB,9.0692E-08_JPRB,1.3297E-07_JPRB,1.8882E-07_JPRB/)
KBO( :, 5,57, 1) = (/&
&6.9035E-10_JPRB,5.7429E-08_JPRB,1.1024E-07_JPRB,1.6105E-07_JPRB,2.2899E-07_JPRB/)
KBO( :, 1,58, 1) = (/&
&3.9157E-10_JPRB,1.3270E-08_JPRB,2.5747E-08_JPRB,3.8061E-08_JPRB,5.5988E-08_JPRB/)
KBO( :, 2,58, 1) = (/&
&3.8162E-10_JPRB,1.9958E-08_JPRB,3.8768E-08_JPRB,5.7217E-08_JPRB,8.2152E-08_JPRB/)
KBO( :, 3,58, 1) = (/&
&3.9640E-10_JPRB,2.7646E-08_JPRB,5.3592E-08_JPRB,7.8902E-08_JPRB,1.1187E-07_JPRB/)
KBO( :, 4,58, 1) = (/&
&4.4118E-10_JPRB,3.5913E-08_JPRB,6.9407E-08_JPRB,1.0187E-07_JPRB,1.4365E-07_JPRB/)
KBO( :, 5,58, 1) = (/&
&5.2734E-10_JPRB,4.4431E-08_JPRB,8.5459E-08_JPRB,1.2500E-07_JPRB,1.7617E-07_JPRB/)
KBO( :, 1,59, 1) = (/&
&3.2257E-10_JPRB,1.0274E-08_JPRB,1.9927E-08_JPRB,2.9461E-08_JPRB,4.2293E-08_JPRB/)
KBO( :, 2,59, 1) = (/&
&3.1226E-10_JPRB,1.5633E-08_JPRB,3.0371E-08_JPRB,4.4840E-08_JPRB,6.3166E-08_JPRB/)
KBO( :, 3,59, 1) = (/&
&3.2148E-10_JPRB,2.1846E-08_JPRB,4.2369E-08_JPRB,6.2405E-08_JPRB,8.6964E-08_JPRB/)
KBO( :, 4,59, 1) = (/&
&3.5488E-10_JPRB,2.8579E-08_JPRB,5.5262E-08_JPRB,8.1150E-08_JPRB,1.1238E-07_JPRB/)
KBO( :, 5,59, 1) = (/&
&4.2035E-10_JPRB,3.5535E-08_JPRB,6.8411E-08_JPRB,1.0012E-07_JPRB,1.3828E-07_JPRB/)
KBO( :, 1,13, 2) = (/&
&8.0175E-06_JPRB,1.6125E-03_JPRB,3.1478E-03_JPRB,4.6753E-03_JPRB,6.4316E-03_JPRB/)
KBO( :, 2,13, 2) = (/&
&1.0426E-05_JPRB,1.8783E-03_JPRB,3.6140E-03_JPRB,5.3229E-03_JPRB,7.3431E-03_JPRB/)
KBO( :, 3,13, 2) = (/&
&1.4927E-05_JPRB,2.1311E-03_JPRB,4.0477E-03_JPRB,5.8993E-03_JPRB,8.1260E-03_JPRB/)
KBO( :, 4,13, 2) = (/&
&2.2809E-05_JPRB,2.3738E-03_JPRB,4.4493E-03_JPRB,6.4056E-03_JPRB,8.7767E-03_JPRB/)
KBO( :, 5,13, 2) = (/&
&3.5487E-05_JPRB,2.6072E-03_JPRB,4.8181E-03_JPRB,6.8488E-03_JPRB,9.2993E-03_JPRB/)
KBO( :, 1,14, 2) = (/&
&6.7524E-06_JPRB,1.3623E-03_JPRB,2.6470E-03_JPRB,3.9213E-03_JPRB,5.3373E-03_JPRB/)
KBO( :, 2,14, 2) = (/&
&8.8908E-06_JPRB,1.5796E-03_JPRB,3.0298E-03_JPRB,4.4457E-03_JPRB,6.0495E-03_JPRB/)
KBO( :, 3,14, 2) = (/&
&1.2884E-05_JPRB,1.7866E-03_JPRB,3.3866E-03_JPRB,4.9144E-03_JPRB,6.6539E-03_JPRB/)
KBO( :, 4,14, 2) = (/&
&1.9813E-05_JPRB,1.9855E-03_JPRB,3.7147E-03_JPRB,5.3297E-03_JPRB,7.1488E-03_JPRB/)
KBO( :, 5,14, 2) = (/&
&3.0910E-05_JPRB,2.1779E-03_JPRB,4.0162E-03_JPRB,5.6950E-03_JPRB,7.5412E-03_JPRB/)
KBO( :, 1,15, 2) = (/&
&5.7112E-06_JPRB,1.1474E-03_JPRB,2.2216E-03_JPRB,3.2811E-03_JPRB,4.4313E-03_JPRB/)
KBO( :, 2,15, 2) = (/&
&7.6208E-06_JPRB,1.3247E-03_JPRB,2.5364E-03_JPRB,3.7071E-03_JPRB,4.9919E-03_JPRB/)
KBO( :, 3,15, 2) = (/&
&1.1171E-05_JPRB,1.4944E-03_JPRB,2.8273E-03_JPRB,4.0906E-03_JPRB,5.4623E-03_JPRB/)
KBO( :, 4,15, 2) = (/&
&1.7286E-05_JPRB,1.6573E-03_JPRB,3.0948E-03_JPRB,4.4313E-03_JPRB,5.8428E-03_JPRB/)
KBO( :, 5,15, 2) = (/&
&2.7064E-05_JPRB,1.8170E-03_JPRB,3.3404E-03_JPRB,4.7290E-03_JPRB,6.1397E-03_JPRB/)
KBO( :, 1,16, 2) = (/&
&4.8419E-06_JPRB,9.6341E-04_JPRB,1.8620E-03_JPRB,2.7407E-03_JPRB,3.6858E-03_JPRB/)
KBO( :, 2,16, 2) = (/&
&6.5431E-06_JPRB,1.1085E-03_JPRB,2.1191E-03_JPRB,3.0886E-03_JPRB,4.1319E-03_JPRB/)
KBO( :, 3,16, 2) = (/&
&9.6991E-06_JPRB,1.2471E-03_JPRB,2.3556E-03_JPRB,3.4027E-03_JPRB,4.5021E-03_JPRB/)
KBO( :, 4,16, 2) = (/&
&1.5112E-05_JPRB,1.3813E-03_JPRB,2.5735E-03_JPRB,3.6791E-03_JPRB,4.7992E-03_JPRB/)
KBO( :, 5,16, 2) = (/&
&2.3687E-05_JPRB,1.5146E-03_JPRB,2.7739E-03_JPRB,3.9205E-03_JPRB,5.0294E-03_JPRB/)
KBO( :, 1,17, 2) = (/&
&4.1046E-06_JPRB,8.0658E-04_JPRB,1.5568E-03_JPRB,2.2850E-03_JPRB,3.0607E-03_JPRB/)
KBO( :, 2,17, 2) = (/&
&5.6128E-06_JPRB,9.2491E-04_JPRB,1.7657E-03_JPRB,2.5701E-03_JPRB,3.4165E-03_JPRB/)
KBO( :, 3,17, 2) = (/&
&8.4118E-06_JPRB,1.0386E-03_JPRB,1.9589E-03_JPRB,2.8258E-03_JPRB,3.7101E-03_JPRB/)
KBO( :, 4,17, 2) = (/&
&1.3163E-05_JPRB,1.1499E-03_JPRB,2.1360E-03_JPRB,3.0493E-03_JPRB,3.9433E-03_JPRB/)
KBO( :, 5,17, 2) = (/&
&2.0607E-05_JPRB,1.2605E-03_JPRB,2.3001E-03_JPRB,3.2445E-03_JPRB,4.1227E-03_JPRB/)
KBO( :, 1,18, 2) = (/&
&3.4787E-06_JPRB,6.7375E-04_JPRB,1.2987E-03_JPRB,1.9033E-03_JPRB,2.5394E-03_JPRB/)
KBO( :, 2,18, 2) = (/&
&4.8193E-06_JPRB,7.7048E-04_JPRB,1.4690E-03_JPRB,2.1362E-03_JPRB,2.8237E-03_JPRB/)
KBO( :, 3,18, 2) = (/&
&7.2913E-06_JPRB,8.6393E-04_JPRB,1.6256E-03_JPRB,2.3423E-03_JPRB,3.0558E-03_JPRB/)
KBO( :, 4,18, 2) = (/&
&1.1432E-05_JPRB,9.5623E-04_JPRB,1.7704E-03_JPRB,2.5237E-03_JPRB,3.2404E-03_JPRB/)
KBO( :, 5,18, 2) = (/&
&1.7868E-05_JPRB,1.0481E-03_JPRB,1.9053E-03_JPRB,2.6812E-03_JPRB,3.3808E-03_JPRB/)
KBO( :, 1,19, 2) = (/&
&2.9467E-06_JPRB,5.6177E-04_JPRB,1.0818E-03_JPRB,1.5840E-03_JPRB,2.1035E-03_JPRB/)
KBO( :, 2,19, 2) = (/&
&4.1364E-06_JPRB,6.4090E-04_JPRB,1.2199E-03_JPRB,1.7723E-03_JPRB,2.3300E-03_JPRB/)
KBO( :, 3,19, 2) = (/&
&6.2999E-06_JPRB,7.1829E-04_JPRB,1.3476E-03_JPRB,1.9398E-03_JPRB,2.5147E-03_JPRB/)
KBO( :, 4,19, 2) = (/&
&9.8879E-06_JPRB,7.9456E-04_JPRB,1.4667E-03_JPRB,2.0867E-03_JPRB,2.6608E-03_JPRB/)
KBO( :, 5,19, 2) = (/&
&1.5425E-05_JPRB,8.7102E-04_JPRB,1.5773E-03_JPRB,2.2143E-03_JPRB,2.7707E-03_JPRB/)
KBO( :, 1,20, 2) = (/&
&2.5100E-06_JPRB,4.6893E-04_JPRB,9.0169E-04_JPRB,1.3192E-03_JPRB,1.7452E-03_JPRB/)
KBO( :, 2,20, 2) = (/&
&3.5701E-06_JPRB,5.3398E-04_JPRB,1.0139E-03_JPRB,1.4717E-03_JPRB,1.9261E-03_JPRB/)
KBO( :, 3,20, 2) = (/&
&5.4715E-06_JPRB,5.9772E-04_JPRB,1.1181E-03_JPRB,1.6068E-03_JPRB,2.0724E-03_JPRB/)
KBO( :, 4,20, 2) = (/&
&8.5950E-06_JPRB,6.6090E-04_JPRB,1.2157E-03_JPRB,1.7253E-03_JPRB,2.1875E-03_JPRB/)
KBO( :, 5,20, 2) = (/&
&1.3366E-05_JPRB,7.2450E-04_JPRB,1.3064E-03_JPRB,1.8293E-03_JPRB,2.2741E-03_JPRB/)
KBO( :, 1,21, 2) = (/&
&2.1419E-06_JPRB,3.9129E-04_JPRB,7.5108E-04_JPRB,1.0978E-03_JPRB,1.4477E-03_JPRB/)
KBO( :, 2,21, 2) = (/&
&3.0823E-06_JPRB,4.4480E-04_JPRB,8.4226E-04_JPRB,1.2211E-03_JPRB,1.5919E-03_JPRB/)
KBO( :, 3,21, 2) = (/&
&4.7515E-06_JPRB,4.9734E-04_JPRB,9.2759E-04_JPRB,1.3300E-03_JPRB,1.7080E-03_JPRB/)
KBO( :, 4,21, 2) = (/&
&7.4611E-06_JPRB,5.4971E-04_JPRB,1.0075E-03_JPRB,1.4263E-03_JPRB,1.7988E-03_JPRB/)
KBO( :, 5,21, 2) = (/&
&1.1567E-05_JPRB,6.0267E-04_JPRB,1.0819E-03_JPRB,1.5108E-03_JPRB,1.8668E-03_JPRB/)
KBO( :, 1,22, 2) = (/&
&1.8692E-06_JPRB,3.2930E-04_JPRB,6.3020E-04_JPRB,9.1986E-04_JPRB,1.2087E-03_JPRB/)
KBO( :, 2,22, 2) = (/&
&2.7364E-06_JPRB,3.7324E-04_JPRB,7.0426E-04_JPRB,1.0187E-03_JPRB,1.3222E-03_JPRB/)
KBO( :, 3,22, 2) = (/&
&4.2483E-06_JPRB,4.1663E-04_JPRB,7.7378E-04_JPRB,1.1062E-03_JPRB,1.4133E-03_JPRB/)
KBO( :, 4,22, 2) = (/&
&6.6614E-06_JPRB,4.6001E-04_JPRB,8.3899E-04_JPRB,1.1837E-03_JPRB,1.4836E-03_JPRB/)
KBO( :, 5,22, 2) = (/&
&1.0283E-05_JPRB,5.0444E-04_JPRB,8.9986E-04_JPRB,1.2517E-03_JPRB,1.5358E-03_JPRB/)
KBO( :, 1,23, 2) = (/&
&1.6399E-06_JPRB,2.7719E-04_JPRB,5.2862E-04_JPRB,7.7027E-04_JPRB,1.0088E-03_JPRB/)
KBO( :, 2,23, 2) = (/&
&2.4391E-06_JPRB,3.1328E-04_JPRB,5.8895E-04_JPRB,8.4951E-04_JPRB,1.0980E-03_JPRB/)
KBO( :, 3,23, 2) = (/&
&3.8063E-06_JPRB,3.4908E-04_JPRB,6.4555E-04_JPRB,9.1997E-04_JPRB,1.1688E-03_JPRB/)
KBO( :, 4,23, 2) = (/&
&5.9548E-06_JPRB,3.8523E-04_JPRB,6.9879E-04_JPRB,9.8233E-04_JPRB,1.2233E-03_JPRB/)
KBO( :, 5,23, 2) = (/&
&9.1467E-06_JPRB,4.2262E-04_JPRB,7.4870E-04_JPRB,1.0371E-03_JPRB,1.2635E-03_JPRB/)
KBO( :, 1,24, 2) = (/&
&1.4486E-06_JPRB,2.3343E-04_JPRB,4.4362E-04_JPRB,6.4490E-04_JPRB,8.4150E-04_JPRB/)
KBO( :, 2,24, 2) = (/&
&2.1847E-06_JPRB,2.6312E-04_JPRB,4.9268E-04_JPRB,7.0858E-04_JPRB,9.1131E-04_JPRB/)
KBO( :, 3,24, 2) = (/&
&3.4199E-06_JPRB,2.9273E-04_JPRB,5.3880E-04_JPRB,7.6525E-04_JPRB,9.6646E-04_JPRB/)
KBO( :, 4,24, 2) = (/&
&5.3366E-06_JPRB,3.2305E-04_JPRB,5.8221E-04_JPRB,8.1539E-04_JPRB,1.0083E-03_JPRB/)
KBO( :, 5,24, 2) = (/&
&8.1557E-06_JPRB,3.5422E-04_JPRB,6.2350E-04_JPRB,8.5963E-04_JPRB,1.0390E-03_JPRB/)
KBO( :, 1,25, 2) = (/&
&1.2896E-06_JPRB,1.9674E-04_JPRB,3.7250E-04_JPRB,5.4009E-04_JPRB,7.0204E-04_JPRB/)
KBO( :, 2,25, 2) = (/&
&1.9685E-06_JPRB,2.2117E-04_JPRB,4.1236E-04_JPRB,5.9119E-04_JPRB,7.5627E-04_JPRB/)
KBO( :, 3,25, 2) = (/&
&3.0862E-06_JPRB,2.4587E-04_JPRB,4.4997E-04_JPRB,6.3678E-04_JPRB,7.9915E-04_JPRB/)
KBO( :, 4,25, 2) = (/&
&4.8005E-06_JPRB,2.7122E-04_JPRB,4.8550E-04_JPRB,6.7707E-04_JPRB,8.3122E-04_JPRB/)
KBO( :, 5,25, 2) = (/&
&7.2939E-06_JPRB,2.9701E-04_JPRB,5.1977E-04_JPRB,7.1279E-04_JPRB,8.5451E-04_JPRB/)
KBO( :, 1,26, 2) = (/&
&1.1608E-06_JPRB,1.6612E-04_JPRB,3.1323E-04_JPRB,4.5281E-04_JPRB,5.8594E-04_JPRB/)
KBO( :, 2,26, 2) = (/&
&1.7905E-06_JPRB,1.8633E-04_JPRB,3.4562E-04_JPRB,4.9378E-04_JPRB,6.2806E-04_JPRB/)
KBO( :, 3,26, 2) = (/&
&2.8083E-06_JPRB,2.0700E-04_JPRB,3.7628E-04_JPRB,5.3030E-04_JPRB,6.6095E-04_JPRB/)
KBO( :, 4,26, 2) = (/&
&4.3494E-06_JPRB,2.2796E-04_JPRB,4.0557E-04_JPRB,5.6268E-04_JPRB,6.8538E-04_JPRB/)
KBO( :, 5,26, 2) = (/&
&6.5643E-06_JPRB,2.4920E-04_JPRB,4.3382E-04_JPRB,5.9177E-04_JPRB,7.0285E-04_JPRB/)
KBO( :, 1,27, 2) = (/&
&1.0500E-06_JPRB,1.4026E-04_JPRB,2.6331E-04_JPRB,3.7943E-04_JPRB,4.8869E-04_JPRB/)
KBO( :, 2,27, 2) = (/&
&1.6326E-06_JPRB,1.5709E-04_JPRB,2.8964E-04_JPRB,4.1228E-04_JPRB,5.2142E-04_JPRB/)
KBO( :, 3,27, 2) = (/&
&2.5571E-06_JPRB,1.7422E-04_JPRB,3.1477E-04_JPRB,4.4154E-04_JPRB,5.4660E-04_JPRB/)
KBO( :, 4,27, 2) = (/&
&3.9402E-06_JPRB,1.9156E-04_JPRB,3.3894E-04_JPRB,4.6764E-04_JPRB,5.6523E-04_JPRB/)
KBO( :, 5,27, 2) = (/&
&5.9052E-06_JPRB,2.0883E-04_JPRB,3.6207E-04_JPRB,4.9151E-04_JPRB,5.7833E-04_JPRB/)
KBO( :, 1,28, 2) = (/&
&9.5343E-07_JPRB,1.1844E-04_JPRB,2.2122E-04_JPRB,3.1775E-04_JPRB,4.0735E-04_JPRB/)
KBO( :, 2,28, 2) = (/&
&1.4904E-06_JPRB,1.3245E-04_JPRB,2.4271E-04_JPRB,3.4408E-04_JPRB,4.3267E-04_JPRB/)
KBO( :, 3,28, 2) = (/&
&2.3285E-06_JPRB,1.4658E-04_JPRB,2.6343E-04_JPRB,3.6757E-04_JPRB,4.5198E-04_JPRB/)
KBO( :, 4,28, 2) = (/&
&3.5672E-06_JPRB,1.6074E-04_JPRB,2.8315E-04_JPRB,3.8877E-04_JPRB,4.6611E-04_JPRB/)
KBO( :, 5,28, 2) = (/&
&5.3086E-06_JPRB,1.7472E-04_JPRB,3.0190E-04_JPRB,4.0830E-04_JPRB,4.7586E-04_JPRB/)
KBO( :, 1,29, 2) = (/&
&8.7130E-07_JPRB,1.0013E-04_JPRB,1.8593E-04_JPRB,2.6607E-04_JPRB,3.3959E-04_JPRB/)
KBO( :, 2,29, 2) = (/&
&1.3662E-06_JPRB,1.1169E-04_JPRB,2.0357E-04_JPRB,2.8717E-04_JPRB,3.5915E-04_JPRB/)
KBO( :, 3,29, 2) = (/&
&2.1272E-06_JPRB,1.2329E-04_JPRB,2.2053E-04_JPRB,3.0613E-04_JPRB,3.7392E-04_JPRB/)
KBO( :, 4,29, 2) = (/&
&3.2367E-06_JPRB,1.3475E-04_JPRB,2.3655E-04_JPRB,3.2340E-04_JPRB,3.8475E-04_JPRB/)
KBO( :, 5,29, 2) = (/&
&4.7798E-06_JPRB,1.4613E-04_JPRB,2.5163E-04_JPRB,3.3924E-04_JPRB,3.9199E-04_JPRB/)
KBO( :, 1,30, 2) = (/&
&7.9857E-07_JPRB,8.4615E-05_JPRB,1.5625E-04_JPRB,2.2266E-04_JPRB,2.8295E-04_JPRB/)
KBO( :, 2,30, 2) = (/&
&1.2528E-06_JPRB,9.4125E-05_JPRB,1.7078E-04_JPRB,2.3961E-04_JPRB,2.9806E-04_JPRB/)
KBO( :, 3,30, 2) = (/&
&1.9419E-06_JPRB,1.0355E-04_JPRB,1.8452E-04_JPRB,2.5499E-04_JPRB,3.0943E-04_JPRB/)
KBO( :, 4,30, 2) = (/&
&2.9342E-06_JPRB,1.1289E-04_JPRB,1.9751E-04_JPRB,2.6906E-04_JPRB,3.1766E-04_JPRB/)
KBO( :, 5,30, 2) = (/&
&4.2987E-06_JPRB,1.2210E-04_JPRB,2.0947E-04_JPRB,2.8172E-04_JPRB,3.2307E-04_JPRB/)
KBO( :, 1,31, 2) = (/&
&7.3491E-07_JPRB,7.1470E-05_JPRB,1.3139E-04_JPRB,1.8630E-04_JPRB,2.3588E-04_JPRB/)
KBO( :, 2,31, 2) = (/&
&1.1514E-06_JPRB,7.9261E-05_JPRB,1.4322E-04_JPRB,1.9997E-04_JPRB,2.4758E-04_JPRB/)
KBO( :, 3,31, 2) = (/&
&1.7751E-06_JPRB,8.6934E-05_JPRB,1.5438E-04_JPRB,2.1250E-04_JPRB,2.5633E-04_JPRB/)
KBO( :, 4,31, 2) = (/&
&2.6619E-06_JPRB,9.4503E-05_JPRB,1.6470E-04_JPRB,2.2379E-04_JPRB,2.6262E-04_JPRB/)
KBO( :, 5,31, 2) = (/&
&3.8682E-06_JPRB,1.0203E-04_JPRB,1.7422E-04_JPRB,2.3379E-04_JPRB,2.6667E-04_JPRB/)
KBO( :, 1,32, 2) = (/&
&6.7761E-07_JPRB,6.0344E-05_JPRB,1.1046E-04_JPRB,1.5585E-04_JPRB,1.9661E-04_JPRB/)
KBO( :, 2,32, 2) = (/&
&1.0588E-06_JPRB,6.6689E-05_JPRB,1.2006E-04_JPRB,1.6697E-04_JPRB,2.0563E-04_JPRB/)
KBO( :, 3,32, 2) = (/&
&1.6222E-06_JPRB,7.2918E-05_JPRB,1.2900E-04_JPRB,1.7702E-04_JPRB,2.1238E-04_JPRB/)
KBO( :, 4,32, 2) = (/&
&2.4128E-06_JPRB,7.9073E-05_JPRB,1.3719E-04_JPRB,1.8602E-04_JPRB,2.1720E-04_JPRB/)
KBO( :, 5,32, 2) = (/&
&3.4779E-06_JPRB,8.5263E-05_JPRB,1.4481E-04_JPRB,1.9388E-04_JPRB,2.2025E-04_JPRB/)
KBO( :, 1,33, 2) = (/&
&6.2527E-07_JPRB,5.0902E-05_JPRB,9.2812E-05_JPRB,1.3037E-04_JPRB,1.6382E-04_JPRB/)
KBO( :, 2,33, 2) = (/&
&9.7334E-07_JPRB,5.6048E-05_JPRB,1.0055E-04_JPRB,1.3935E-04_JPRB,1.7082E-04_JPRB/)
KBO( :, 3,33, 2) = (/&
&1.4801E-06_JPRB,6.1101E-05_JPRB,1.0766E-04_JPRB,1.4740E-04_JPRB,1.7611E-04_JPRB/)
KBO( :, 4,33, 2) = (/&
&2.1838E-06_JPRB,6.6144E-05_JPRB,1.1420E-04_JPRB,1.5452E-04_JPRB,1.7978E-04_JPRB/)
KBO( :, 5,33, 2) = (/&
&3.1224E-06_JPRB,7.1225E-05_JPRB,1.2030E-04_JPRB,1.6062E-04_JPRB,1.8204E-04_JPRB/)
KBO( :, 1,34, 2) = (/&
&5.6731E-07_JPRB,4.2730E-05_JPRB,7.7685E-05_JPRB,1.0877E-04_JPRB,1.3615E-04_JPRB/)
KBO( :, 2,34, 2) = (/&
&8.7950E-07_JPRB,4.6905E-05_JPRB,8.3883E-05_JPRB,1.1598E-04_JPRB,1.4163E-04_JPRB/)
KBO( :, 3,34, 2) = (/&
&1.3287E-06_JPRB,5.1034E-05_JPRB,8.9565E-05_JPRB,1.2242E-04_JPRB,1.4574E-04_JPRB/)
KBO( :, 4,34, 2) = (/&
&1.9464E-06_JPRB,5.5143E-05_JPRB,9.4797E-05_JPRB,1.2801E-04_JPRB,1.4856E-04_JPRB/)
KBO( :, 5,34, 2) = (/&
&2.7640E-06_JPRB,5.9346E-05_JPRB,9.9732E-05_JPRB,1.3280E-04_JPRB,1.5030E-04_JPRB/)
KBO( :, 1,35, 2) = (/&
&4.9270E-07_JPRB,3.5501E-05_JPRB,6.4454E-05_JPRB,9.0102E-05_JPRB,1.1262E-04_JPRB/)
KBO( :, 2,35, 2) = (/&
&7.6173E-07_JPRB,3.8902E-05_JPRB,6.9450E-05_JPRB,9.5970E-05_JPRB,1.1707E-04_JPRB/)
KBO( :, 3,35, 2) = (/&
&1.1464E-06_JPRB,4.2272E-05_JPRB,7.4027E-05_JPRB,1.0112E-04_JPRB,1.2036E-04_JPRB/)
KBO( :, 4,35, 2) = (/&
&1.6726E-06_JPRB,4.5640E-05_JPRB,7.8266E-05_JPRB,1.0556E-04_JPRB,1.2264E-04_JPRB/)
KBO( :, 5,35, 2) = (/&
&2.3658E-06_JPRB,4.9091E-05_JPRB,8.2279E-05_JPRB,1.0938E-04_JPRB,1.2407E-04_JPRB/)
KBO( :, 1,36, 2) = (/&
&4.0753E-07_JPRB,2.9178E-05_JPRB,5.2991E-05_JPRB,7.4090E-05_JPRB,9.2739E-05_JPRB/)
KBO( :, 2,36, 2) = (/&
&6.2965E-07_JPRB,3.1953E-05_JPRB,5.7057E-05_JPRB,7.8888E-05_JPRB,9.6418E-05_JPRB/)
KBO( :, 3,36, 2) = (/&
&9.4705E-07_JPRB,3.4706E-05_JPRB,6.0784E-05_JPRB,8.3065E-05_JPRB,9.9161E-05_JPRB/)
KBO( :, 4,36, 2) = (/&
&1.3808E-06_JPRB,3.7469E-05_JPRB,6.4241E-05_JPRB,8.6658E-05_JPRB,1.0108E-04_JPRB/)
KBO( :, 5,36, 2) = (/&
&1.9520E-06_JPRB,4.0294E-05_JPRB,6.7509E-05_JPRB,8.9744E-05_JPRB,1.0229E-04_JPRB/)
KBO( :, 1,37, 2) = (/&
&3.1476E-07_JPRB,2.3629E-05_JPRB,4.3024E-05_JPRB,6.0274E-05_JPRB,7.5761E-05_JPRB/)
KBO( :, 2,37, 2) = (/&
&4.8773E-07_JPRB,2.5900E-05_JPRB,4.6378E-05_JPRB,6.4261E-05_JPRB,7.8929E-05_JPRB/)
KBO( :, 3,37, 2) = (/&
&7.3652E-07_JPRB,2.8152E-05_JPRB,4.9455E-05_JPRB,6.7730E-05_JPRB,8.1326E-05_JPRB/)
KBO( :, 4,37, 2) = (/&
&1.0783E-06_JPRB,3.0411E-05_JPRB,5.2306E-05_JPRB,7.0712E-05_JPRB,8.3006E-05_JPRB/)
KBO( :, 5,37, 2) = (/&
&1.5305E-06_JPRB,3.2717E-05_JPRB,5.4998E-05_JPRB,7.3285E-05_JPRB,8.4133E-05_JPRB/)
KBO( :, 1,38, 2) = (/&
&2.4210E-07_JPRB,1.9112E-05_JPRB,3.4895E-05_JPRB,4.8985E-05_JPRB,6.1887E-05_JPRB/)
KBO( :, 2,38, 2) = (/&
&3.7627E-07_JPRB,2.0975E-05_JPRB,3.7671E-05_JPRB,5.2313E-05_JPRB,6.4617E-05_JPRB/)
KBO( :, 3,38, 2) = (/&
&5.7052E-07_JPRB,2.2818E-05_JPRB,4.0210E-05_JPRB,5.5193E-05_JPRB,6.6701E-05_JPRB/)
KBO( :, 4,38, 2) = (/&
&8.3911E-07_JPRB,2.4669E-05_JPRB,4.2570E-05_JPRB,5.7682E-05_JPRB,6.8211E-05_JPRB/)
KBO( :, 5,38, 2) = (/&
&1.1958E-06_JPRB,2.6548E-05_JPRB,4.4784E-05_JPRB,5.9818E-05_JPRB,6.9237E-05_JPRB/)
KBO( :, 1,39, 2) = (/&
&1.8625E-07_JPRB,1.5459E-05_JPRB,2.8298E-05_JPRB,3.9805E-05_JPRB,5.0586E-05_JPRB/)
KBO( :, 2,39, 2) = (/&
&2.9016E-07_JPRB,1.6986E-05_JPRB,3.0594E-05_JPRB,4.2577E-05_JPRB,5.2943E-05_JPRB/)
KBO( :, 3,39, 2) = (/&
&4.4173E-07_JPRB,1.8495E-05_JPRB,3.2693E-05_JPRB,4.4970E-05_JPRB,5.4767E-05_JPRB/)
KBO( :, 4,39, 2) = (/&
&6.5253E-07_JPRB,2.0005E-05_JPRB,3.4636E-05_JPRB,4.7036E-05_JPRB,5.6106E-05_JPRB/)
KBO( :, 5,39, 2) = (/&
&9.3398E-07_JPRB,2.1545E-05_JPRB,3.6467E-05_JPRB,4.8821E-05_JPRB,5.7052E-05_JPRB/)
KBO( :, 1,40, 2) = (/&
&1.3668E-07_JPRB,1.2370E-05_JPRB,2.2736E-05_JPRB,3.2075E-05_JPRB,4.1000E-05_JPRB/)
KBO( :, 2,40, 2) = (/&
&2.1371E-07_JPRB,1.3625E-05_JPRB,2.4652E-05_JPRB,3.4419E-05_JPRB,4.3071E-05_JPRB/)
KBO( :, 3,40, 2) = (/&
&3.2755E-07_JPRB,1.4863E-05_JPRB,2.6404E-05_JPRB,3.6442E-05_JPRB,4.4686E-05_JPRB/)
KBO( :, 4,40, 2) = (/&
&4.8754E-07_JPRB,1.6102E-05_JPRB,2.8025E-05_JPRB,3.8191E-05_JPRB,4.5890E-05_JPRB/)
KBO( :, 5,40, 2) = (/&
&7.0305E-07_JPRB,1.7351E-05_JPRB,2.9541E-05_JPRB,3.9702E-05_JPRB,4.6757E-05_JPRB/)
KBO( :, 1,41, 2) = (/&
&9.9669E-08_JPRB,9.8770E-06_JPRB,1.8228E-05_JPRB,2.5797E-05_JPRB,3.3169E-05_JPRB/)
KBO( :, 2,41, 2) = (/&
&1.5628E-07_JPRB,1.0911E-05_JPRB,1.9833E-05_JPRB,2.7783E-05_JPRB,3.4989E-05_JPRB/)
KBO( :, 3,41, 2) = (/&
&2.4106E-07_JPRB,1.1926E-05_JPRB,2.1297E-05_JPRB,2.9495E-05_JPRB,3.6412E-05_JPRB/)
KBO( :, 4,41, 2) = (/&
&3.6163E-07_JPRB,1.2938E-05_JPRB,2.2645E-05_JPRB,3.0975E-05_JPRB,3.7495E-05_JPRB/)
KBO( :, 5,41, 2) = (/&
&5.2576E-07_JPRB,1.3959E-05_JPRB,2.3909E-05_JPRB,3.2258E-05_JPRB,3.8288E-05_JPRB/)
KBO( :, 1,42, 2) = (/&
&7.2678E-08_JPRB,7.8801E-06_JPRB,1.4600E-05_JPRB,2.0724E-05_JPRB,2.6808E-05_JPRB/)
KBO( :, 2,42, 2) = (/&
&1.1413E-07_JPRB,8.7322E-06_JPRB,1.5944E-05_JPRB,2.2404E-05_JPRB,2.8406E-05_JPRB/)
KBO( :, 3,42, 2) = (/&
&1.7705E-07_JPRB,9.5648E-06_JPRB,1.7165E-05_JPRB,2.3855E-05_JPRB,2.9660E-05_JPRB/)
KBO( :, 4,42, 2) = (/&
&2.6763E-07_JPRB,1.0394E-05_JPRB,1.8292E-05_JPRB,2.5108E-05_JPRB,3.0631E-05_JPRB/)
KBO( :, 5,42, 2) = (/&
&3.9231E-07_JPRB,1.1225E-05_JPRB,1.9340E-05_JPRB,2.6194E-05_JPRB,3.1357E-05_JPRB/)
KBO( :, 1,43, 2) = (/&
&5.1710E-08_JPRB,6.2405E-06_JPRB,1.1615E-05_JPRB,1.6545E-05_JPRB,2.1547E-05_JPRB/)
KBO( :, 2,43, 2) = (/&
&8.1128E-08_JPRB,6.9428E-06_JPRB,1.2742E-05_JPRB,1.7971E-05_JPRB,2.2964E-05_JPRB/)
KBO( :, 3,43, 2) = (/&
&1.2657E-07_JPRB,7.6287E-06_JPRB,1.3773E-05_JPRB,1.9217E-05_JPRB,2.4086E-05_JPRB/)
KBO( :, 4,43, 2) = (/&
&1.9308E-07_JPRB,8.3079E-06_JPRB,1.4717E-05_JPRB,2.0287E-05_JPRB,2.4962E-05_JPRB/)
KBO( :, 5,43, 2) = (/&
&2.8583E-07_JPRB,8.9896E-06_JPRB,1.5595E-05_JPRB,2.1216E-05_JPRB,2.5632E-05_JPRB/)
KBO( :, 1,44, 2) = (/&
&3.6495E-08_JPRB,4.9199E-06_JPRB,9.1989E-06_JPRB,1.3152E-05_JPRB,1.7255E-05_JPRB/)
KBO( :, 2,44, 2) = (/&
&5.6951E-08_JPRB,5.5005E-06_JPRB,1.0149E-05_JPRB,1.4368E-05_JPRB,1.8514E-05_JPRB/)
KBO( :, 3,44, 2) = (/&
&8.9239E-08_JPRB,6.0652E-06_JPRB,1.1016E-05_JPRB,1.5437E-05_JPRB,1.9519E-05_JPRB/)
KBO( :, 4,44, 2) = (/&
&1.3737E-07_JPRB,6.6226E-06_JPRB,1.1811E-05_JPRB,1.6355E-05_JPRB,2.0314E-05_JPRB/)
KBO( :, 5,44, 2) = (/&
&2.0554E-07_JPRB,7.1784E-06_JPRB,1.2547E-05_JPRB,1.7152E-05_JPRB,2.0929E-05_JPRB/)
KBO( :, 1,45, 2) = (/&
&2.5907E-08_JPRB,3.8721E-06_JPRB,7.2719E-06_JPRB,1.0434E-05_JPRB,1.3790E-05_JPRB/)
KBO( :, 2,45, 2) = (/&
&3.9986E-08_JPRB,4.3511E-06_JPRB,8.0697E-06_JPRB,1.1466E-05_JPRB,1.4905E-05_JPRB/)
KBO( :, 3,45, 2) = (/&
&6.2804E-08_JPRB,4.8176E-06_JPRB,8.8015E-06_JPRB,1.2382E-05_JPRB,1.5806E-05_JPRB/)
KBO( :, 4,45, 2) = (/&
&9.7423E-08_JPRB,5.2749E-06_JPRB,9.4698E-06_JPRB,1.3171E-05_JPRB,1.6523E-05_JPRB/)
KBO( :, 5,45, 2) = (/&
&1.4724E-07_JPRB,5.7306E-06_JPRB,1.0089E-05_JPRB,1.3855E-05_JPRB,1.7089E-05_JPRB/)
KBO( :, 1,46, 2) = (/&
&1.8373E-08_JPRB,3.0320E-06_JPRB,5.7197E-06_JPRB,8.2358E-06_JPRB,1.0971E-05_JPRB/)
KBO( :, 2,46, 2) = (/&
&2.7848E-08_JPRB,3.4277E-06_JPRB,6.3901E-06_JPRB,9.1142E-06_JPRB,1.1956E-05_JPRB/)
KBO( :, 3,46, 2) = (/&
&4.3687E-08_JPRB,3.8134E-06_JPRB,7.0085E-06_JPRB,9.9001E-06_JPRB,1.2766E-05_JPRB/)
KBO( :, 4,46, 2) = (/&
&6.8194E-08_JPRB,4.1901E-06_JPRB,7.5729E-06_JPRB,1.0581E-05_JPRB,1.3413E-05_JPRB/)
KBO( :, 5,46, 2) = (/&
&1.0416E-07_JPRB,4.5633E-06_JPRB,8.0938E-06_JPRB,1.1169E-05_JPRB,1.3933E-05_JPRB/)
KBO( :, 1,47, 2) = (/&
&1.2986E-08_JPRB,2.3533E-06_JPRB,4.4615E-06_JPRB,6.4491E-06_JPRB,8.6543E-06_JPRB/)
KBO( :, 2,47, 2) = (/&
&1.9128E-08_JPRB,2.6815E-06_JPRB,5.0257E-06_JPRB,7.1971E-06_JPRB,9.5261E-06_JPRB/)
KBO( :, 3,47, 2) = (/&
&2.9772E-08_JPRB,3.0001E-06_JPRB,5.5492E-06_JPRB,7.8735E-06_JPRB,1.0255E-05_JPRB/)
KBO( :, 4,47, 2) = (/&
&4.6702E-08_JPRB,3.3116E-06_JPRB,6.0282E-06_JPRB,8.4652E-06_JPRB,1.0843E-05_JPRB/)
KBO( :, 5,47, 2) = (/&
&7.2070E-08_JPRB,3.6175E-06_JPRB,6.4678E-06_JPRB,8.9726E-06_JPRB,1.1318E-05_JPRB/)
KBO( :, 1,48, 2) = (/&
&9.3416E-09_JPRB,1.8200E-06_JPRB,3.4670E-06_JPRB,5.0294E-06_JPRB,6.7990E-06_JPRB/)
KBO( :, 2,48, 2) = (/&
&1.3255E-08_JPRB,2.0919E-06_JPRB,3.9405E-06_JPRB,5.6643E-06_JPRB,7.5695E-06_JPRB/)
KBO( :, 3,48, 2) = (/&
&2.0305E-08_JPRB,2.3557E-06_JPRB,4.3829E-06_JPRB,6.2449E-06_JPRB,8.2237E-06_JPRB/)
KBO( :, 4,48, 2) = (/&
&3.1895E-08_JPRB,2.6129E-06_JPRB,4.7893E-06_JPRB,6.7563E-06_JPRB,8.7563E-06_JPRB/)
KBO( :, 5,48, 2) = (/&
&4.9634E-08_JPRB,2.8647E-06_JPRB,5.1614E-06_JPRB,7.1978E-06_JPRB,9.1908E-06_JPRB/)
KBO( :, 1,49, 2) = (/&
&6.8359E-09_JPRB,1.4019E-06_JPRB,2.6826E-06_JPRB,3.9057E-06_JPRB,5.3233E-06_JPRB/)
KBO( :, 2,49, 2) = (/&
&9.2996E-09_JPRB,1.6269E-06_JPRB,3.0793E-06_JPRB,4.4431E-06_JPRB,6.0005E-06_JPRB/)
KBO( :, 3,49, 2) = (/&
&1.3902E-08_JPRB,1.8452E-06_JPRB,3.4523E-06_JPRB,4.9386E-06_JPRB,6.5835E-06_JPRB/)
KBO( :, 4,49, 2) = (/&
&2.1742E-08_JPRB,2.0580E-06_JPRB,3.7970E-06_JPRB,5.3806E-06_JPRB,7.0678E-06_JPRB/)
KBO( :, 5,49, 2) = (/&
&3.4035E-08_JPRB,2.2660E-06_JPRB,4.1122E-06_JPRB,5.7639E-06_JPRB,7.4641E-06_JPRB/)
KBO( :, 1,50, 2) = (/&
&5.1178E-09_JPRB,1.0792E-06_JPRB,2.0739E-06_JPRB,3.0301E-06_JPRB,4.1532E-06_JPRB/)
KBO( :, 2,50, 2) = (/&
&6.6862E-09_JPRB,1.2653E-06_JPRB,2.4055E-06_JPRB,3.4823E-06_JPRB,4.7385E-06_JPRB/)
KBO( :, 3,50, 2) = (/&
&9.6897E-09_JPRB,1.4463E-06_JPRB,2.7192E-06_JPRB,3.9039E-06_JPRB,5.2519E-06_JPRB/)
KBO( :, 4,50, 2) = (/&
&1.4989E-08_JPRB,1.6221E-06_JPRB,3.0101E-06_JPRB,4.2829E-06_JPRB,5.6841E-06_JPRB/)
KBO( :, 5,50, 2) = (/&
&2.3540E-08_JPRB,1.7939E-06_JPRB,3.2769E-06_JPRB,4.6145E-06_JPRB,6.0402E-06_JPRB/)
KBO( :, 1,51, 2) = (/&
&3.8928E-09_JPRB,8.2870E-07_JPRB,1.5995E-06_JPRB,2.3444E-06_JPRB,3.2274E-06_JPRB/)
KBO( :, 2,51, 2) = (/&
&4.8976E-09_JPRB,9.8251E-07_JPRB,1.8756E-06_JPRB,2.7234E-06_JPRB,3.7274E-06_JPRB/)
KBO( :, 3,51, 2) = (/&
&6.8457E-09_JPRB,1.1323E-06_JPRB,2.1385E-06_JPRB,3.0800E-06_JPRB,4.1752E-06_JPRB/)
KBO( :, 4,51, 2) = (/&
&1.0404E-08_JPRB,1.2777E-06_JPRB,2.3837E-06_JPRB,3.4044E-06_JPRB,4.5574E-06_JPRB/)
KBO( :, 5,51, 2) = (/&
&1.6329E-08_JPRB,1.4195E-06_JPRB,2.6091E-06_JPRB,3.6893E-06_JPRB,4.8743E-06_JPRB/)
KBO( :, 1,52, 2) = (/&
&3.0020E-09_JPRB,6.3363E-07_JPRB,1.2279E-06_JPRB,1.8052E-06_JPRB,2.4975E-06_JPRB/)
KBO( :, 2,52, 2) = (/&
&3.6400E-09_JPRB,7.6019E-07_JPRB,1.4569E-06_JPRB,2.1220E-06_JPRB,2.9231E-06_JPRB/)
KBO( :, 3,52, 2) = (/&
&4.8925E-09_JPRB,8.8432E-07_JPRB,1.6773E-06_JPRB,2.4234E-06_JPRB,3.3127E-06_JPRB/)
KBO( :, 4,52, 2) = (/&
&7.2540E-09_JPRB,1.0045E-06_JPRB,1.8834E-06_JPRB,2.6996E-06_JPRB,3.6485E-06_JPRB/)
KBO( :, 5,52, 2) = (/&
&1.1316E-08_JPRB,1.1218E-06_JPRB,2.0739E-06_JPRB,2.9444E-06_JPRB,3.9318E-06_JPRB/)
KBO( :, 1,53, 2) = (/&
&2.3480E-09_JPRB,4.8194E-07_JPRB,9.3751E-07_JPRB,1.3817E-06_JPRB,1.9236E-06_JPRB/)
KBO( :, 2,53, 2) = (/&
&2.7431E-09_JPRB,5.8562E-07_JPRB,1.1268E-06_JPRB,1.6465E-06_JPRB,2.2857E-06_JPRB/)
KBO( :, 3,53, 2) = (/&
&3.5464E-09_JPRB,6.8845E-07_JPRB,1.3110E-06_JPRB,1.8999E-06_JPRB,2.6221E-06_JPRB/)
KBO( :, 4,53, 2) = (/&
&5.0907E-09_JPRB,7.8797E-07_JPRB,1.4844E-06_JPRB,2.1348E-06_JPRB,2.9184E-06_JPRB/)
KBO( :, 5,53, 2) = (/&
&7.8410E-09_JPRB,8.8479E-07_JPRB,1.6450E-06_JPRB,2.3447E-06_JPRB,3.1713E-06_JPRB/)
KBO( :, 1,54, 2) = (/&
&1.8594E-09_JPRB,3.6706E-07_JPRB,7.1625E-07_JPRB,1.0575E-06_JPRB,1.4721E-06_JPRB/)
KBO( :, 2,54, 2) = (/&
&2.1055E-09_JPRB,4.5181E-07_JPRB,8.7256E-07_JPRB,1.2786E-06_JPRB,1.7762E-06_JPRB/)
KBO( :, 3,54, 2) = (/&
&2.6291E-09_JPRB,5.3666E-07_JPRB,1.0257E-06_JPRB,1.4904E-06_JPRB,2.0598E-06_JPRB/)
KBO( :, 4,54, 2) = (/&
&3.6482E-09_JPRB,6.1906E-07_JPRB,1.1709E-06_JPRB,1.6887E-06_JPRB,2.3147E-06_JPRB/)
KBO( :, 5,54, 2) = (/&
&5.5210E-09_JPRB,6.9901E-07_JPRB,1.3059E-06_JPRB,1.8680E-06_JPRB,2.5342E-06_JPRB/)
KBO( :, 1,55, 2) = (/&
&1.4849E-09_JPRB,2.7894E-07_JPRB,5.4560E-07_JPRB,8.0660E-07_JPRB,1.1188E-06_JPRB/)
KBO( :, 2,55, 2) = (/&
&1.6383E-09_JPRB,3.4819E-07_JPRB,6.7462E-07_JPRB,9.9127E-07_JPRB,1.3721E-06_JPRB/)
KBO( :, 3,55, 2) = (/&
&1.9800E-09_JPRB,4.1799E-07_JPRB,8.0161E-07_JPRB,1.1677E-06_JPRB,1.6084E-06_JPRB/)
KBO( :, 4,55, 2) = (/&
&2.6536E-09_JPRB,4.8615E-07_JPRB,9.2306E-07_JPRB,1.3349E-06_JPRB,1.8249E-06_JPRB/)
KBO( :, 5,55, 2) = (/&
&3.9260E-09_JPRB,5.5226E-07_JPRB,1.0363E-06_JPRB,1.4870E-06_JPRB,2.0117E-06_JPRB/)
KBO( :, 1,56, 2) = (/&
&1.1936E-09_JPRB,2.1075E-07_JPRB,4.1302E-07_JPRB,6.1132E-07_JPRB,8.4513E-07_JPRB/)
KBO( :, 2,56, 2) = (/&
&1.2886E-09_JPRB,2.6729E-07_JPRB,5.1942E-07_JPRB,7.6519E-07_JPRB,1.0555E-06_JPRB/)
KBO( :, 3,56, 2) = (/&
&1.5077E-09_JPRB,3.2455E-07_JPRB,6.2452E-07_JPRB,9.1202E-07_JPRB,1.2523E-06_JPRB/)
KBO( :, 4,56, 2) = (/&
&1.9525E-09_JPRB,3.8098E-07_JPRB,7.2592E-07_JPRB,1.0524E-06_JPRB,1.4345E-06_JPRB/)
KBO( :, 5,56, 2) = (/&
&2.8077E-09_JPRB,4.3561E-07_JPRB,8.2084E-07_JPRB,1.1815E-06_JPRB,1.5940E-06_JPRB/)
KBO( :, 1,57, 2) = (/&
&9.6583E-10_JPRB,1.5815E-07_JPRB,3.1044E-07_JPRB,4.6005E-07_JPRB,6.3408E-07_JPRB/)
KBO( :, 2,57, 2) = (/&
&1.0215E-09_JPRB,2.0426E-07_JPRB,3.9810E-07_JPRB,5.8767E-07_JPRB,8.0766E-07_JPRB/)
KBO( :, 3,57, 2) = (/&
&1.1597E-09_JPRB,2.5112E-07_JPRB,4.8491E-07_JPRB,7.0984E-07_JPRB,9.7174E-07_JPRB/)
KBO( :, 4,57, 2) = (/&
&1.4523E-09_JPRB,2.9779E-07_JPRB,5.6934E-07_JPRB,8.2739E-07_JPRB,1.1242E-06_JPRB/)
KBO( :, 5,57, 2) = (/&
&2.0219E-09_JPRB,3.4296E-07_JPRB,6.4886E-07_JPRB,9.3651E-07_JPRB,1.2602E-06_JPRB/)
KBO( :, 1,58, 2) = (/&
&7.8662E-10_JPRB,1.1835E-07_JPRB,2.3255E-07_JPRB,3.4498E-07_JPRB,4.7381E-07_JPRB/)
KBO( :, 2,58, 2) = (/&
&8.1625E-10_JPRB,1.5593E-07_JPRB,3.0466E-07_JPRB,4.5040E-07_JPRB,6.1632E-07_JPRB/)
KBO( :, 3,58, 2) = (/&
&9.0341E-10_JPRB,1.9427E-07_JPRB,3.7628E-07_JPRB,5.5215E-07_JPRB,7.5284E-07_JPRB/)
KBO( :, 4,58, 2) = (/&
&1.0971E-09_JPRB,2.3273E-07_JPRB,4.4632E-07_JPRB,6.5008E-07_JPRB,8.7941E-07_JPRB/)
KBO( :, 5,58, 2) = (/&
&1.4779E-09_JPRB,2.7004E-07_JPRB,5.1274E-07_JPRB,7.4188E-07_JPRB,9.9429E-07_JPRB/)
KBO( :, 1,59, 2) = (/&
&6.4355E-10_JPRB,9.3344E-08_JPRB,1.8349E-07_JPRB,2.7230E-07_JPRB,3.7011E-07_JPRB/)
KBO( :, 2,59, 2) = (/&
&6.6262E-10_JPRB,1.2407E-07_JPRB,2.4261E-07_JPRB,3.5886E-07_JPRB,4.8556E-07_JPRB/)
KBO( :, 3,59, 2) = (/&
&7.2712E-10_JPRB,1.5550E-07_JPRB,3.0153E-07_JPRB,4.4284E-07_JPRB,5.9628E-07_JPRB/)
KBO( :, 4,59, 2) = (/&
&8.7156E-10_JPRB,1.8704E-07_JPRB,3.5919E-07_JPRB,5.2368E-07_JPRB,6.9842E-07_JPRB/)
KBO( :, 5,59, 2) = (/&
&1.1587E-09_JPRB,2.1775E-07_JPRB,4.1408E-07_JPRB,5.9979E-07_JPRB,7.9133E-07_JPRB/)
KBO( :, 1,13, 3) = (/&
&2.0353E-05_JPRB,5.6795E-03_JPRB,1.0879E-02_JPRB,1.5836E-02_JPRB,2.0631E-02_JPRB/)
KBO( :, 2,13, 3) = (/&
&3.3777E-05_JPRB,6.5066E-03_JPRB,1.2221E-02_JPRB,1.7564E-02_JPRB,2.2630E-02_JPRB/)
KBO( :, 3,13, 3) = (/&
&5.9522E-05_JPRB,7.3512E-03_JPRB,1.3499E-02_JPRB,1.9109E-02_JPRB,2.4328E-02_JPRB/)
KBO( :, 4,13, 3) = (/&
&1.0349E-04_JPRB,8.2028E-03_JPRB,1.4689E-02_JPRB,2.0461E-02_JPRB,2.5718E-02_JPRB/)
KBO( :, 5,13, 3) = (/&
&1.7303E-04_JPRB,9.0516E-03_JPRB,1.5806E-02_JPRB,2.1651E-02_JPRB,2.6820E-02_JPRB/)
KBO( :, 1,14, 3) = (/&
&1.7783E-05_JPRB,4.9056E-03_JPRB,9.3358E-03_JPRB,1.3535E-02_JPRB,1.7457E-02_JPRB/)
KBO( :, 2,14, 3) = (/&
&3.0011E-05_JPRB,5.5977E-03_JPRB,1.0428E-02_JPRB,1.4906E-02_JPRB,1.8958E-02_JPRB/)
KBO( :, 3,14, 3) = (/&
&5.3112E-05_JPRB,6.2970E-03_JPRB,1.1454E-02_JPRB,1.6118E-02_JPRB,2.0210E-02_JPRB/)
KBO( :, 4,14, 3) = (/&
&9.2284E-05_JPRB,6.9980E-03_JPRB,1.2425E-02_JPRB,1.7194E-02_JPRB,2.1221E-02_JPRB/)
KBO( :, 5,14, 3) = (/&
&1.5395E-04_JPRB,7.6990E-03_JPRB,1.3352E-02_JPRB,1.8155E-02_JPRB,2.2006E-02_JPRB/)
KBO( :, 1,15, 3) = (/&
&1.5619E-05_JPRB,4.1987E-03_JPRB,7.9342E-03_JPRB,1.1456E-02_JPRB,1.4646E-02_JPRB/)
KBO( :, 2,15, 3) = (/&
&2.6774E-05_JPRB,4.7704E-03_JPRB,8.8150E-03_JPRB,1.2537E-02_JPRB,1.5771E-02_JPRB/)
KBO( :, 3,15, 3) = (/&
&4.7563E-05_JPRB,5.3462E-03_JPRB,9.6501E-03_JPRB,1.3503E-02_JPRB,1.6713E-02_JPRB/)
KBO( :, 4,15, 3) = (/&
&8.2516E-05_JPRB,5.9238E-03_JPRB,1.0452E-02_JPRB,1.4374E-02_JPRB,1.7466E-02_JPRB/)
KBO( :, 5,15, 3) = (/&
&1.3728E-04_JPRB,6.5026E-03_JPRB,1.1222E-02_JPRB,1.5161E-02_JPRB,1.8044E-02_JPRB/)
KBO( :, 1,16, 3) = (/&
&1.3779E-05_JPRB,3.5660E-03_JPRB,6.6881E-03_JPRB,9.6171E-03_JPRB,1.2220E-02_JPRB/)
KBO( :, 2,16, 3) = (/&
&2.3944E-05_JPRB,4.0358E-03_JPRB,7.4057E-03_JPRB,1.0483E-02_JPRB,1.3089E-02_JPRB/)
KBO( :, 3,16, 3) = (/&
&4.2620E-05_JPRB,4.5089E-03_JPRB,8.0943E-03_JPRB,1.1266E-02_JPRB,1.3818E-02_JPRB/)
KBO( :, 4,16, 3) = (/&
&7.3893E-05_JPRB,4.9861E-03_JPRB,8.7577E-03_JPRB,1.1978E-02_JPRB,1.4391E-02_JPRB/)
KBO( :, 5,16, 3) = (/&
&1.2258E-04_JPRB,5.4637E-03_JPRB,9.3940E-03_JPRB,1.2628E-02_JPRB,1.4828E-02_JPRB/)
KBO( :, 1,17, 3) = (/&
&1.2160E-05_JPRB,3.0074E-03_JPRB,5.6060E-03_JPRB,8.0296E-03_JPRB,1.0147E-02_JPRB/)
KBO( :, 2,17, 3) = (/&
&2.1375E-05_JPRB,3.3935E-03_JPRB,6.1972E-03_JPRB,8.7313E-03_JPRB,1.0830E-02_JPRB/)
KBO( :, 3,17, 3) = (/&
&3.8127E-05_JPRB,3.7835E-03_JPRB,6.7643E-03_JPRB,9.3718E-03_JPRB,1.1398E-02_JPRB/)
KBO( :, 4,17, 3) = (/&
&6.6011E-05_JPRB,4.1770E-03_JPRB,7.3104E-03_JPRB,9.9575E-03_JPRB,1.1840E-02_JPRB/)
KBO( :, 5,17, 3) = (/&
&1.0918E-04_JPRB,4.5738E-03_JPRB,7.8339E-03_JPRB,1.0495E-02_JPRB,1.2173E-02_JPRB/)
KBO( :, 1,18, 3) = (/&
&1.0748E-05_JPRB,2.5245E-03_JPRB,4.6847E-03_JPRB,6.6825E-03_JPRB,8.4030E-03_JPRB/)
KBO( :, 2,18, 3) = (/&
&1.9076E-05_JPRB,2.8417E-03_JPRB,5.1713E-03_JPRB,7.2560E-03_JPRB,8.9449E-03_JPRB/)
KBO( :, 3,18, 3) = (/&
&3.4073E-05_JPRB,3.1636E-03_JPRB,5.6356E-03_JPRB,7.7811E-03_JPRB,9.3891E-03_JPRB/)
KBO( :, 4,18, 3) = (/&
&5.8868E-05_JPRB,3.4883E-03_JPRB,6.0850E-03_JPRB,8.2633E-03_JPRB,9.7334E-03_JPRB/)
KBO( :, 5,18, 3) = (/&
&9.7060E-05_JPRB,3.8208E-03_JPRB,6.5140E-03_JPRB,8.7058E-03_JPRB,9.9894E-03_JPRB/)
KBO( :, 1,19, 3) = (/&
&9.4932E-06_JPRB,2.1111E-03_JPRB,3.9060E-03_JPRB,5.5505E-03_JPRB,6.9419E-03_JPRB/)
KBO( :, 2,19, 3) = (/&
&1.6990E-05_JPRB,2.3724E-03_JPRB,4.3041E-03_JPRB,6.0210E-03_JPRB,7.3719E-03_JPRB/)
KBO( :, 3,19, 3) = (/&
&3.0379E-05_JPRB,2.6375E-03_JPRB,4.6850E-03_JPRB,6.4526E-03_JPRB,7.7206E-03_JPRB/)
KBO( :, 4,19, 3) = (/&
&5.2318E-05_JPRB,2.9073E-03_JPRB,5.0535E-03_JPRB,6.8468E-03_JPRB,7.9880E-03_JPRB/)
KBO( :, 5,19, 3) = (/&
&8.5851E-05_JPRB,3.1863E-03_JPRB,5.4069E-03_JPRB,7.2090E-03_JPRB,8.1842E-03_JPRB/)
KBO( :, 1,20, 3) = (/&
&8.4621E-06_JPRB,1.7648E-03_JPRB,3.2563E-03_JPRB,4.6122E-03_JPRB,5.7360E-03_JPRB/)
KBO( :, 2,20, 3) = (/&
&1.5250E-05_JPRB,1.9802E-03_JPRB,3.5810E-03_JPRB,4.9972E-03_JPRB,6.0779E-03_JPRB/)
KBO( :, 3,20, 3) = (/&
&2.7245E-05_JPRB,2.1990E-03_JPRB,3.8932E-03_JPRB,5.3488E-03_JPRB,6.3511E-03_JPRB/)
KBO( :, 4,20, 3) = (/&
&4.6707E-05_JPRB,2.4242E-03_JPRB,4.1953E-03_JPRB,5.6710E-03_JPRB,6.5600E-03_JPRB/)
KBO( :, 5,20, 3) = (/&
&7.6165E-05_JPRB,2.6575E-03_JPRB,4.4893E-03_JPRB,5.9661E-03_JPRB,6.7108E-03_JPRB/)
KBO( :, 1,21, 3) = (/&
&7.5453E-06_JPRB,1.4733E-03_JPRB,2.7104E-03_JPRB,3.8302E-03_JPRB,4.7372E-03_JPRB/)
KBO( :, 2,21, 3) = (/&
&1.3660E-05_JPRB,1.6505E-03_JPRB,2.9759E-03_JPRB,4.1434E-03_JPRB,5.0081E-03_JPRB/)
KBO( :, 3,21, 3) = (/&
&2.4360E-05_JPRB,1.8325E-03_JPRB,3.2316E-03_JPRB,4.4300E-03_JPRB,5.2232E-03_JPRB/)
KBO( :, 4,21, 3) = (/&
&4.1539E-05_JPRB,2.0202E-03_JPRB,3.4804E-03_JPRB,4.6921E-03_JPRB,5.3862E-03_JPRB/)
KBO( :, 5,21, 3) = (/&
&6.7226E-05_JPRB,2.2135E-03_JPRB,3.7240E-03_JPRB,4.9321E-03_JPRB,5.5010E-03_JPRB/)
KBO( :, 1,22, 3) = (/&
&6.9875E-06_JPRB,1.2377E-03_JPRB,2.2680E-03_JPRB,3.1957E-03_JPRB,3.9253E-03_JPRB/)
KBO( :, 2,22, 3) = (/&
&1.2689E-05_JPRB,1.3846E-03_JPRB,2.4844E-03_JPRB,3.4484E-03_JPRB,4.1374E-03_JPRB/)
KBO( :, 3,22, 3) = (/&
&2.2485E-05_JPRB,1.5363E-03_JPRB,2.6941E-03_JPRB,3.6801E-03_JPRB,4.3039E-03_JPRB/)
KBO( :, 4,22, 3) = (/&
&3.7954E-05_JPRB,1.6925E-03_JPRB,2.8992E-03_JPRB,3.8918E-03_JPRB,4.4280E-03_JPRB/)
KBO( :, 5,22, 3) = (/&
&6.0729E-05_JPRB,1.8529E-03_JPRB,3.1002E-03_JPRB,4.0883E-03_JPRB,4.5144E-03_JPRB/)
KBO( :, 1,23, 3) = (/&
&6.4953E-06_JPRB,1.0396E-03_JPRB,1.8968E-03_JPRB,2.6642E-03_JPRB,3.2502E-03_JPRB/)
KBO( :, 2,23, 3) = (/&
&1.1793E-05_JPRB,1.1619E-03_JPRB,2.0732E-03_JPRB,2.8684E-03_JPRB,3.4159E-03_JPRB/)
KBO( :, 3,23, 3) = (/&
&2.0715E-05_JPRB,1.2879E-03_JPRB,2.2459E-03_JPRB,3.0558E-03_JPRB,3.5445E-03_JPRB/)
KBO( :, 4,23, 3) = (/&
&3.4551E-05_JPRB,1.4176E-03_JPRB,2.4147E-03_JPRB,3.2275E-03_JPRB,3.6395E-03_JPRB/)
KBO( :, 5,23, 3) = (/&
&5.4641E-05_JPRB,1.5512E-03_JPRB,2.5804E-03_JPRB,3.3885E-03_JPRB,3.7034E-03_JPRB/)
KBO( :, 1,24, 3) = (/&
&6.0670E-06_JPRB,8.7365E-04_JPRB,1.5859E-03_JPRB,2.2204E-03_JPRB,2.6897E-03_JPRB/)
KBO( :, 2,24, 3) = (/&
&1.0981E-05_JPRB,9.7532E-04_JPRB,1.7303E-03_JPRB,2.3852E-03_JPRB,2.8188E-03_JPRB/)
KBO( :, 3,24, 3) = (/&
&1.9078E-05_JPRB,1.0799E-03_JPRB,1.8727E-03_JPRB,2.5367E-03_JPRB,2.9175E-03_JPRB/)
KBO( :, 4,24, 3) = (/&
&3.1407E-05_JPRB,1.1876E-03_JPRB,2.0114E-03_JPRB,2.6770E-03_JPRB,2.9899E-03_JPRB/)
KBO( :, 5,24, 3) = (/&
&4.9067E-05_JPRB,1.2997E-03_JPRB,2.1481E-03_JPRB,2.8086E-03_JPRB,3.0371E-03_JPRB/)
KBO( :, 1,25, 3) = (/&
&5.6989E-06_JPRB,7.3485E-04_JPRB,1.3264E-03_JPRB,1.8506E-03_JPRB,2.2259E-03_JPRB/)
KBO( :, 2,25, 3) = (/&
&1.0240E-05_JPRB,8.1910E-04_JPRB,1.4452E-03_JPRB,1.9836E-03_JPRB,2.3255E-03_JPRB/)
KBO( :, 3,25, 3) = (/&
&1.7580E-05_JPRB,9.0587E-04_JPRB,1.5621E-03_JPRB,2.1066E-03_JPRB,2.4014E-03_JPRB/)
KBO( :, 4,25, 3) = (/&
&2.8572E-05_JPRB,9.9581E-04_JPRB,1.6762E-03_JPRB,2.2210E-03_JPRB,2.4559E-03_JPRB/)
KBO( :, 5,25, 3) = (/&
&4.4075E-05_JPRB,1.0904E-03_JPRB,1.7895E-03_JPRB,2.3285E-03_JPRB,2.4904E-03_JPRB/)
KBO( :, 1,26, 3) = (/&
&5.4044E-06_JPRB,6.1917E-04_JPRB,1.1109E-03_JPRB,1.5435E-03_JPRB,1.8428E-03_JPRB/)
KBO( :, 2,26, 3) = (/&
&9.6129E-06_JPRB,6.8903E-04_JPRB,1.2086E-03_JPRB,1.6510E-03_JPRB,1.9194E-03_JPRB/)
KBO( :, 3,26, 3) = (/&
&1.6279E-05_JPRB,7.6112E-04_JPRB,1.3044E-03_JPRB,1.7509E-03_JPRB,1.9770E-03_JPRB/)
KBO( :, 4,26, 3) = (/&
&2.6098E-05_JPRB,8.3688E-04_JPRB,1.3985E-03_JPRB,1.8442E-03_JPRB,2.0178E-03_JPRB/)
KBO( :, 5,26, 3) = (/&
&3.9757E-05_JPRB,9.1748E-04_JPRB,1.4931E-03_JPRB,1.9319E-03_JPRB,2.0426E-03_JPRB/)
KBO( :, 1,27, 3) = (/&
&5.1208E-06_JPRB,5.2155E-04_JPRB,9.3033E-04_JPRB,1.2869E-03_JPRB,1.5252E-03_JPRB/)
KBO( :, 2,27, 3) = (/&
&9.0050E-06_JPRB,5.7947E-04_JPRB,1.0106E-03_JPRB,1.3741E-03_JPRB,1.5841E-03_JPRB/)
KBO( :, 3,27, 3) = (/&
&1.5028E-05_JPRB,6.3999E-04_JPRB,1.0891E-03_JPRB,1.4551E-03_JPRB,1.6279E-03_JPRB/)
KBO( :, 4,27, 3) = (/&
&2.3771E-05_JPRB,7.0422E-04_JPRB,1.1674E-03_JPRB,1.5313E-03_JPRB,1.6583E-03_JPRB/)
KBO( :, 5,27, 3) = (/&
&3.5789E-05_JPRB,7.7220E-04_JPRB,1.2465E-03_JPRB,1.6033E-03_JPRB,1.6759E-03_JPRB/)
KBO( :, 1,28, 3) = (/&
&4.8426E-06_JPRB,4.3932E-04_JPRB,7.7909E-04_JPRB,1.0728E-03_JPRB,1.2619E-03_JPRB/)
KBO( :, 2,28, 3) = (/&
&8.4123E-06_JPRB,4.8757E-04_JPRB,8.4493E-04_JPRB,1.1435E-03_JPRB,1.3071E-03_JPRB/)
KBO( :, 3,28, 3) = (/&
&1.3833E-05_JPRB,5.3874E-04_JPRB,9.0955E-04_JPRB,1.2094E-03_JPRB,1.3406E-03_JPRB/)
KBO( :, 4,28, 3) = (/&
&2.1607E-05_JPRB,5.9328E-04_JPRB,9.7513E-04_JPRB,1.2716E-03_JPRB,1.3629E-03_JPRB/)
KBO( :, 5,28, 3) = (/&
&3.2146E-05_JPRB,6.4978E-04_JPRB,1.0416E-03_JPRB,1.3310E-03_JPRB,1.3752E-03_JPRB/)
KBO( :, 1,29, 3) = (/&
&4.5849E-06_JPRB,3.7023E-04_JPRB,6.5264E-04_JPRB,8.9457E-04_JPRB,1.0445E-03_JPRB/)
KBO( :, 2,29, 3) = (/&
&7.8572E-06_JPRB,4.1089E-04_JPRB,7.0665E-04_JPRB,9.5187E-04_JPRB,1.0793E-03_JPRB/)
KBO( :, 3,29, 3) = (/&
&1.2741E-05_JPRB,4.5436E-04_JPRB,7.6034E-04_JPRB,1.0055E-03_JPRB,1.1048E-03_JPRB/)
KBO( :, 4,29, 3) = (/&
&1.9649E-05_JPRB,4.9998E-04_JPRB,8.1550E-04_JPRB,1.0566E-03_JPRB,1.1213E-03_JPRB/)
KBO( :, 5,29, 3) = (/&
&2.8896E-05_JPRB,5.4682E-04_JPRB,8.7093E-04_JPRB,1.1060E-03_JPRB,1.1298E-03_JPRB/)
KBO( :, 1,30, 3) = (/&
&4.3297E-06_JPRB,3.1217E-04_JPRB,5.4663E-04_JPRB,7.4580E-04_JPRB,8.6464E-04_JPRB/)
KBO( :, 2,30, 3) = (/&
&7.3120E-06_JPRB,3.4668E-04_JPRB,5.9106E-04_JPRB,7.9232E-04_JPRB,8.9143E-04_JPRB/)
KBO( :, 3,30, 3) = (/&
&1.1705E-05_JPRB,3.8338E-04_JPRB,6.3627E-04_JPRB,8.3604E-04_JPRB,9.1074E-04_JPRB/)
KBO( :, 4,30, 3) = (/&
&1.7828E-05_JPRB,4.2125E-04_JPRB,6.8249E-04_JPRB,8.7824E-04_JPRB,9.2283E-04_JPRB/)
KBO( :, 5,30, 3) = (/&
&2.5924E-05_JPRB,4.5966E-04_JPRB,7.2827E-04_JPRB,9.1964E-04_JPRB,9.2875E-04_JPRB/)
KBO( :, 1,31, 3) = (/&
&4.0874E-06_JPRB,2.6368E-04_JPRB,4.5791E-04_JPRB,6.2183E-04_JPRB,7.1613E-04_JPRB/)
KBO( :, 2,31, 3) = (/&
&6.8015E-06_JPRB,2.9293E-04_JPRB,4.9490E-04_JPRB,6.5949E-04_JPRB,7.3687E-04_JPRB/)
KBO( :, 3,31, 3) = (/&
&1.0746E-05_JPRB,3.2348E-04_JPRB,5.3298E-04_JPRB,6.9547E-04_JPRB,7.5159E-04_JPRB/)
KBO( :, 4,31, 3) = (/&
&1.6163E-05_JPRB,3.5480E-04_JPRB,5.7136E-04_JPRB,7.3073E-04_JPRB,7.6056E-04_JPRB/)
KBO( :, 5,31, 3) = (/&
&2.3251E-05_JPRB,3.8597E-04_JPRB,6.0897E-04_JPRB,7.6515E-04_JPRB,7.6467E-04_JPRB/)
KBO( :, 1,32, 3) = (/&
&3.8514E-06_JPRB,2.2297E-04_JPRB,3.8374E-04_JPRB,5.1829E-04_JPRB,5.9305E-04_JPRB/)
KBO( :, 2,32, 3) = (/&
&6.3168E-06_JPRB,2.4754E-04_JPRB,4.1485E-04_JPRB,5.4904E-04_JPRB,6.0924E-04_JPRB/)
KBO( :, 3,32, 3) = (/&
&9.8501E-06_JPRB,2.7292E-04_JPRB,4.4681E-04_JPRB,5.7897E-04_JPRB,6.2044E-04_JPRB/)
KBO( :, 4,32, 3) = (/&
&1.4638E-05_JPRB,2.9846E-04_JPRB,4.7840E-04_JPRB,6.0852E-04_JPRB,6.2707E-04_JPRB/)
KBO( :, 5,32, 3) = (/&
&2.0831E-05_JPRB,3.2361E-04_JPRB,5.0883E-04_JPRB,6.3658E-04_JPRB,6.2999E-04_JPRB/)
KBO( :, 1,33, 3) = (/&
&3.6163E-06_JPRB,1.8866E-04_JPRB,3.2190E-04_JPRB,4.3205E-04_JPRB,4.9144E-04_JPRB/)
KBO( :, 2,33, 3) = (/&
&5.8503E-06_JPRB,2.0912E-04_JPRB,3.4811E-04_JPRB,4.5736E-04_JPRB,5.0397E-04_JPRB/)
KBO( :, 3,33, 3) = (/&
&9.0067E-06_JPRB,2.2999E-04_JPRB,3.7456E-04_JPRB,4.8239E-04_JPRB,5.1238E-04_JPRB/)
KBO( :, 4,33, 3) = (/&
&1.3226E-05_JPRB,2.5067E-04_JPRB,4.0039E-04_JPRB,5.0676E-04_JPRB,5.1732E-04_JPRB/)
KBO( :, 5,33, 3) = (/&
&1.8631E-05_JPRB,2.7107E-04_JPRB,4.2476E-04_JPRB,5.2963E-04_JPRB,5.1944E-04_JPRB/)
KBO( :, 1,34, 3) = (/&
&3.3238E-06_JPRB,1.5902E-04_JPRB,2.6946E-04_JPRB,3.5933E-04_JPRB,4.0648E-04_JPRB/)
KBO( :, 2,34, 3) = (/&
&5.3166E-06_JPRB,1.7590E-04_JPRB,2.9135E-04_JPRB,3.8047E-04_JPRB,4.1623E-04_JPRB/)
KBO( :, 3,34, 3) = (/&
&8.0935E-06_JPRB,1.9289E-04_JPRB,3.1309E-04_JPRB,4.0135E-04_JPRB,4.2273E-04_JPRB/)
KBO( :, 4,34, 3) = (/&
&1.1767E-05_JPRB,2.0963E-04_JPRB,3.3398E-04_JPRB,4.2136E-04_JPRB,4.2646E-04_JPRB/)
KBO( :, 5,34, 3) = (/&
&1.6441E-05_JPRB,2.2628E-04_JPRB,3.5340E-04_JPRB,4.3976E-04_JPRB,4.2791E-04_JPRB/)
KBO( :, 1,35, 3) = (/&
&2.9067E-06_JPRB,1.3259E-04_JPRB,2.2393E-04_JPRB,2.9733E-04_JPRB,3.3540E-04_JPRB/)
KBO( :, 2,35, 3) = (/&
&4.6187E-06_JPRB,1.4644E-04_JPRB,2.4206E-04_JPRB,3.1503E-04_JPRB,3.4321E-04_JPRB/)
KBO( :, 3,35, 3) = (/&
&6.9869E-06_JPRB,1.6027E-04_JPRB,2.5990E-04_JPRB,3.3236E-04_JPRB,3.4842E-04_JPRB/)
KBO( :, 4,35, 3) = (/&
&1.0104E-05_JPRB,1.7387E-04_JPRB,2.7672E-04_JPRB,3.4881E-04_JPRB,3.5145E-04_JPRB/)
KBO( :, 5,35, 3) = (/&
&1.4052E-05_JPRB,1.8746E-04_JPRB,2.9226E-04_JPRB,3.6359E-04_JPRB,3.5262E-04_JPRB/)
KBO( :, 1,36, 3) = (/&
&2.4089E-06_JPRB,1.0927E-04_JPRB,1.8451E-04_JPRB,2.4455E-04_JPRB,2.7594E-04_JPRB/)
KBO( :, 2,36, 3) = (/&
&3.8233E-06_JPRB,1.2060E-04_JPRB,1.9949E-04_JPRB,2.5938E-04_JPRB,2.8242E-04_JPRB/)
KBO( :, 3,36, 3) = (/&
&5.7778E-06_JPRB,1.3185E-04_JPRB,2.1404E-04_JPRB,2.7372E-04_JPRB,2.8680E-04_JPRB/)
KBO( :, 4,36, 3) = (/&
&8.3484E-06_JPRB,1.4295E-04_JPRB,2.2765E-04_JPRB,2.8727E-04_JPRB,2.8945E-04_JPRB/)
KBO( :, 5,36, 3) = (/&
&1.1603E-05_JPRB,1.5407E-04_JPRB,2.4022E-04_JPRB,2.9918E-04_JPRB,2.9054E-04_JPRB/)
KBO( :, 1,37, 3) = (/&
&1.8525E-06_JPRB,8.8636E-05_JPRB,1.5015E-04_JPRB,1.9932E-04_JPRB,2.2585E-04_JPRB/)
KBO( :, 2,37, 3) = (/&
&2.9593E-06_JPRB,9.7894E-05_JPRB,1.6249E-04_JPRB,2.1170E-04_JPRB,2.3148E-04_JPRB/)
KBO( :, 3,37, 3) = (/&
&4.5018E-06_JPRB,1.0706E-04_JPRB,1.7444E-04_JPRB,2.2370E-04_JPRB,2.3543E-04_JPRB/)
KBO( :, 4,37, 3) = (/&
&6.5383E-06_JPRB,1.1615E-04_JPRB,1.8559E-04_JPRB,2.3492E-04_JPRB,2.3791E-04_JPRB/)
KBO( :, 5,37, 3) = (/&
&9.1296E-06_JPRB,1.2523E-04_JPRB,1.9593E-04_JPRB,2.4478E-04_JPRB,2.3911E-04_JPRB/)
KBO( :, 1,38, 3) = (/&
&1.4171E-06_JPRB,7.1807E-05_JPRB,1.2206E-04_JPRB,1.6233E-04_JPRB,1.8481E-04_JPRB/)
KBO( :, 2,38, 3) = (/&
&2.2804E-06_JPRB,7.9379E-05_JPRB,1.3224E-04_JPRB,1.7271E-04_JPRB,1.8979E-04_JPRB/)
KBO( :, 3,38, 3) = (/&
&3.4913E-06_JPRB,8.6867E-05_JPRB,1.4204E-04_JPRB,1.8270E-04_JPRB,1.9335E-04_JPRB/)
KBO( :, 4,38, 3) = (/&
&5.1024E-06_JPRB,9.4294E-05_JPRB,1.5119E-04_JPRB,1.9201E-04_JPRB,1.9566E-04_JPRB/)
KBO( :, 5,38, 3) = (/&
&7.1603E-06_JPRB,1.0172E-04_JPRB,1.5970E-04_JPRB,2.0015E-04_JPRB,1.9689E-04_JPRB/)
KBO( :, 1,39, 3) = (/&
&1.0836E-06_JPRB,5.8166E-05_JPRB,9.9215E-05_JPRB,1.3222E-04_JPRB,1.5133E-04_JPRB/)
KBO( :, 2,39, 3) = (/&
&1.7555E-06_JPRB,6.4345E-05_JPRB,1.0758E-04_JPRB,1.4088E-04_JPRB,1.5570E-04_JPRB/)
KBO( :, 3,39, 3) = (/&
&2.7062E-06_JPRB,7.0477E-05_JPRB,1.1564E-04_JPRB,1.4921E-04_JPRB,1.5890E-04_JPRB/)
KBO( :, 4,39, 3) = (/&
&3.9795E-06_JPRB,7.6546E-05_JPRB,1.2316E-04_JPRB,1.5693E-04_JPRB,1.6103E-04_JPRB/)
KBO( :, 5,39, 3) = (/&
&5.6128E-06_JPRB,8.2626E-05_JPRB,1.3018E-04_JPRB,1.6363E-04_JPRB,1.6230E-04_JPRB/)
KBO( :, 1,40, 3) = (/&
&7.8445E-07_JPRB,4.6585E-05_JPRB,7.9902E-05_JPRB,1.0692E-04_JPRB,1.2321E-04_JPRB/)
KBO( :, 2,40, 3) = (/&
&1.2866E-06_JPRB,5.1634E-05_JPRB,8.6802E-05_JPRB,1.1417E-04_JPRB,1.2708E-04_JPRB/)
KBO( :, 3,40, 3) = (/&
&2.0073E-06_JPRB,5.6656E-05_JPRB,9.3478E-05_JPRB,1.2114E-04_JPRB,1.2998E-04_JPRB/)
KBO( :, 4,40, 3) = (/&
&2.9837E-06_JPRB,6.1628E-05_JPRB,9.9689E-05_JPRB,1.2758E-04_JPRB,1.3201E-04_JPRB/)
KBO( :, 5,40, 3) = (/&
&4.2474E-06_JPRB,6.6601E-05_JPRB,1.0552E-04_JPRB,1.3318E-04_JPRB,1.3326E-04_JPRB/)
KBO( :, 1,41, 3) = (/&
&5.6200E-07_JPRB,3.7239E-05_JPRB,6.4245E-05_JPRB,8.6338E-05_JPRB,1.0021E-04_JPRB/)
KBO( :, 2,41, 3) = (/&
&9.3423E-07_JPRB,4.1365E-05_JPRB,6.9922E-05_JPRB,9.2387E-05_JPRB,1.0362E-04_JPRB/)
KBO( :, 3,41, 3) = (/&
&1.4759E-06_JPRB,4.5473E-05_JPRB,7.5442E-05_JPRB,9.8211E-05_JPRB,1.0623E-04_JPRB/)
KBO( :, 4,41, 3) = (/&
&2.2204E-06_JPRB,4.9548E-05_JPRB,8.0603E-05_JPRB,1.0362E-04_JPRB,1.0811E-04_JPRB/)
KBO( :, 5,41, 3) = (/&
&3.1941E-06_JPRB,5.3616E-05_JPRB,8.5442E-05_JPRB,1.0831E-04_JPRB,1.0933E-04_JPRB/)
KBO( :, 1,42, 3) = (/&
&4.0111E-07_JPRB,2.9743E-05_JPRB,5.1608E-05_JPRB,6.9660E-05_JPRB,8.1453E-05_JPRB/)
KBO( :, 2,42, 3) = (/&
&6.7588E-07_JPRB,3.3120E-05_JPRB,5.6295E-05_JPRB,7.4726E-05_JPRB,8.4452E-05_JPRB/)
KBO( :, 3,42, 3) = (/&
&1.0815E-06_JPRB,3.6481E-05_JPRB,6.0861E-05_JPRB,7.9587E-05_JPRB,8.6802E-05_JPRB/)
KBO( :, 4,42, 3) = (/&
&1.6472E-06_JPRB,3.9818E-05_JPRB,6.5135E-05_JPRB,8.4095E-05_JPRB,8.8535E-05_JPRB/)
KBO( :, 5,42, 3) = (/&
&2.3953E-06_JPRB,4.3150E-05_JPRB,6.9163E-05_JPRB,8.8053E-05_JPRB,8.9707E-05_JPRB/)
KBO( :, 1,43, 3) = (/&
&2.7634E-07_JPRB,2.3586E-05_JPRB,4.1208E-05_JPRB,5.5916E-05_JPRB,6.5980E-05_JPRB/)
KBO( :, 2,43, 3) = (/&
&4.7339E-07_JPRB,2.6349E-05_JPRB,4.5082E-05_JPRB,6.0171E-05_JPRB,6.8655E-05_JPRB/)
KBO( :, 3,43, 3) = (/&
&7.6946E-07_JPRB,2.9095E-05_JPRB,4.8858E-05_JPRB,6.4228E-05_JPRB,7.0769E-05_JPRB/)
KBO( :, 4,43, 3) = (/&
&1.1899E-06_JPRB,3.1831E-05_JPRB,5.2419E-05_JPRB,6.8020E-05_JPRB,7.2392E-05_JPRB/)
KBO( :, 5,43, 3) = (/&
&1.7542E-06_JPRB,3.4560E-05_JPRB,5.5769E-05_JPRB,7.1373E-05_JPRB,7.3520E-05_JPRB/)
KBO( :, 1,44, 3) = (/&
&1.8677E-07_JPRB,1.8630E-05_JPRB,3.2790E-05_JPRB,4.4748E-05_JPRB,5.3325E-05_JPRB/)
KBO( :, 2,44, 3) = (/&
&3.2545E-07_JPRB,2.0878E-05_JPRB,3.5981E-05_JPRB,4.8304E-05_JPRB,5.5702E-05_JPRB/)
KBO( :, 3,44, 3) = (/&
&5.3812E-07_JPRB,2.3132E-05_JPRB,3.9119E-05_JPRB,5.1707E-05_JPRB,5.7625E-05_JPRB/)
KBO( :, 4,44, 3) = (/&
&8.4624E-07_JPRB,2.5378E-05_JPRB,4.2094E-05_JPRB,5.4904E-05_JPRB,5.9117E-05_JPRB/)
KBO( :, 5,44, 3) = (/&
&1.2670E-06_JPRB,2.7605E-05_JPRB,4.4873E-05_JPRB,5.7740E-05_JPRB,6.0210E-05_JPRB/)
KBO( :, 1,45, 3) = (/&
&1.2570E-07_JPRB,1.4697E-05_JPRB,2.6055E-05_JPRB,3.5757E-05_JPRB,4.3043E-05_JPRB/)
KBO( :, 2,45, 3) = (/&
&2.2228E-07_JPRB,1.6531E-05_JPRB,2.8696E-05_JPRB,3.8740E-05_JPRB,4.5168E-05_JPRB/)
KBO( :, 3,45, 3) = (/&
&3.7425E-07_JPRB,1.8375E-05_JPRB,3.1286E-05_JPRB,4.1584E-05_JPRB,4.6892E-05_JPRB/)
KBO( :, 4,45, 3) = (/&
&5.9851E-07_JPRB,2.0210E-05_JPRB,3.3765E-05_JPRB,4.4275E-05_JPRB,4.8273E-05_JPRB/)
KBO( :, 5,45, 3) = (/&
&9.1064E-07_JPRB,2.2043E-05_JPRB,3.6086E-05_JPRB,4.6686E-05_JPRB,4.9306E-05_JPRB/)
KBO( :, 1,46, 3) = (/&
&8.3151E-08_JPRB,1.1545E-05_JPRB,2.0622E-05_JPRB,2.8475E-05_JPRB,3.4643E-05_JPRB/)
KBO( :, 2,46, 3) = (/&
&1.4909E-07_JPRB,1.3038E-05_JPRB,2.2804E-05_JPRB,3.0968E-05_JPRB,3.6538E-05_JPRB/)
KBO( :, 3,46, 3) = (/&
&2.5589E-07_JPRB,1.4552E-05_JPRB,2.4958E-05_JPRB,3.3368E-05_JPRB,3.8096E-05_JPRB/)
KBO( :, 4,46, 3) = (/&
&4.1668E-07_JPRB,1.6050E-05_JPRB,2.7017E-05_JPRB,3.5626E-05_JPRB,3.9358E-05_JPRB/)
KBO( :, 5,46, 3) = (/&
&6.4518E-07_JPRB,1.7554E-05_JPRB,2.8957E-05_JPRB,3.7672E-05_JPRB,4.0331E-05_JPRB/)
KBO( :, 1,47, 3) = (/&
&5.3540E-08_JPRB,9.0044E-06_JPRB,1.6219E-05_JPRB,2.2547E-05_JPRB,2.7739E-05_JPRB/)
KBO( :, 2,47, 3) = (/&
&9.7029E-08_JPRB,1.0218E-05_JPRB,1.8025E-05_JPRB,2.4635E-05_JPRB,2.9430E-05_JPRB/)
KBO( :, 3,47, 3) = (/&
&1.6982E-07_JPRB,1.1454E-05_JPRB,1.9806E-05_JPRB,2.6651E-05_JPRB,3.0836E-05_JPRB/)
KBO( :, 4,47, 3) = (/&
&2.8228E-07_JPRB,1.2681E-05_JPRB,2.1522E-05_JPRB,2.8552E-05_JPRB,3.1984E-05_JPRB/)
KBO( :, 5,47, 3) = (/&
&4.4593E-07_JPRB,1.3911E-05_JPRB,2.3146E-05_JPRB,3.0298E-05_JPRB,3.2902E-05_JPRB/)
KBO( :, 1,48, 3) = (/&
&3.4557E-08_JPRB,7.0084E-06_JPRB,1.2731E-05_JPRB,1.7817E-05_JPRB,2.2170E-05_JPRB/)
KBO( :, 2,48, 3) = (/&
&6.2743E-08_JPRB,7.9919E-06_JPRB,1.4216E-05_JPRB,1.9554E-05_JPRB,2.3663E-05_JPRB/)
KBO( :, 3,48, 3) = (/&
&1.1169E-07_JPRB,8.9994E-06_JPRB,1.5688E-05_JPRB,2.1246E-05_JPRB,2.4930E-05_JPRB/)
KBO( :, 4,48, 3) = (/&
&1.8970E-07_JPRB,1.0009E-05_JPRB,1.7121E-05_JPRB,2.2855E-05_JPRB,2.5977E-05_JPRB/)
KBO( :, 5,48, 3) = (/&
&3.0578E-07_JPRB,1.1013E-05_JPRB,1.8479E-05_JPRB,2.4337E-05_JPRB,2.6830E-05_JPRB/)
KBO( :, 1,49, 3) = (/&
&2.2502E-08_JPRB,5.4403E-06_JPRB,9.9701E-06_JPRB,1.4043E-05_JPRB,1.7685E-05_JPRB/)
KBO( :, 2,49, 3) = (/&
&4.0407E-08_JPRB,6.2386E-06_JPRB,1.1187E-05_JPRB,1.5489E-05_JPRB,1.8999E-05_JPRB/)
KBO( :, 3,49, 3) = (/&
&7.2903E-08_JPRB,7.0592E-06_JPRB,1.2408E-05_JPRB,1.6909E-05_JPRB,2.0138E-05_JPRB/)
KBO( :, 4,49, 3) = (/&
&1.2643E-07_JPRB,7.8874E-06_JPRB,1.3602E-05_JPRB,1.8265E-05_JPRB,2.1093E-05_JPRB/)
KBO( :, 5,49, 3) = (/&
&2.0803E-07_JPRB,8.7090E-06_JPRB,1.4734E-05_JPRB,1.9523E-05_JPRB,2.1885E-05_JPRB/)
KBO( :, 1,50, 3) = (/&
&1.5095E-08_JPRB,4.2287E-06_JPRB,7.8121E-06_JPRB,1.1070E-05_JPRB,1.4078E-05_JPRB/)
KBO( :, 2,50, 3) = (/&
&2.6427E-08_JPRB,4.8766E-06_JPRB,8.8105E-06_JPRB,1.2276E-05_JPRB,1.5222E-05_JPRB/)
KBO( :, 3,50, 3) = (/&
&4.7991E-08_JPRB,5.5443E-06_JPRB,9.8192E-06_JPRB,1.3460E-05_JPRB,1.6227E-05_JPRB/)
KBO( :, 4,50, 3) = (/&
&8.4675E-08_JPRB,6.2215E-06_JPRB,1.0811E-05_JPRB,1.4600E-05_JPRB,1.7078E-05_JPRB/)
KBO( :, 5,50, 3) = (/&
&1.4213E-07_JPRB,6.8957E-06_JPRB,1.1757E-05_JPRB,1.5668E-05_JPRB,1.7797E-05_JPRB/)
KBO( :, 1,51, 3) = (/&
&1.0409E-08_JPRB,3.2863E-06_JPRB,6.1164E-06_JPRB,8.7177E-06_JPRB,1.1179E-05_JPRB/)
KBO( :, 2,51, 3) = (/&
&1.7475E-08_JPRB,3.8101E-06_JPRB,6.9343E-06_JPRB,9.7209E-06_JPRB,1.2172E-05_JPRB/)
KBO( :, 3,51, 3) = (/&
&3.1652E-08_JPRB,4.3546E-06_JPRB,7.7683E-06_JPRB,1.0708E-05_JPRB,1.3048E-05_JPRB/)
KBO( :, 4,51, 3) = (/&
&5.6664E-08_JPRB,4.9075E-06_JPRB,8.5891E-06_JPRB,1.1663E-05_JPRB,1.3802E-05_JPRB/)
KBO( :, 5,51, 3) = (/&
&9.6978E-08_JPRB,5.4606E-06_JPRB,9.3785E-06_JPRB,1.2566E-05_JPRB,1.4438E-05_JPRB/)
KBO( :, 1,52, 3) = (/&
&7.3730E-09_JPRB,2.5481E-06_JPRB,4.7781E-06_JPRB,6.8480E-06_JPRB,8.8551E-06_JPRB/)
KBO( :, 2,52, 3) = (/&
&1.1665E-08_JPRB,2.9707E-06_JPRB,5.4480E-06_JPRB,7.6826E-06_JPRB,9.7180E-06_JPRB/)
KBO( :, 3,52, 3) = (/&
&2.0839E-08_JPRB,3.4136E-06_JPRB,6.1334E-06_JPRB,8.5017E-06_JPRB,1.0476E-05_JPRB/)
KBO( :, 4,52, 3) = (/&
&3.7702E-08_JPRB,3.8651E-06_JPRB,6.8133E-06_JPRB,9.3029E-06_JPRB,1.1144E-05_JPRB/)
KBO( :, 5,52, 3) = (/&
&6.5719E-08_JPRB,4.3178E-06_JPRB,7.4715E-06_JPRB,1.0064E-05_JPRB,1.1709E-05_JPRB/)
KBO( :, 1,53, 3) = (/&
&5.3750E-09_JPRB,1.9710E-06_JPRB,3.7222E-06_JPRB,5.3652E-06_JPRB,6.9985E-06_JPRB/)
KBO( :, 2,53, 3) = (/&
&7.9112E-09_JPRB,2.3105E-06_JPRB,4.2696E-06_JPRB,6.0569E-06_JPRB,7.7450E-06_JPRB/)
KBO( :, 3,53, 3) = (/&
&1.3727E-08_JPRB,2.6711E-06_JPRB,4.8332E-06_JPRB,6.7376E-06_JPRB,8.4040E-06_JPRB/)
KBO( :, 4,53, 3) = (/&
&2.4945E-08_JPRB,3.0391E-06_JPRB,5.3954E-06_JPRB,7.4078E-06_JPRB,8.9922E-06_JPRB/)
KBO( :, 5,53, 3) = (/&
&4.4184E-08_JPRB,3.4095E-06_JPRB,5.9433E-06_JPRB,8.0475E-06_JPRB,9.4957E-06_JPRB/)
KBO( :, 1,54, 3) = (/&
&4.0653E-09_JPRB,1.5287E-06_JPRB,2.9053E-06_JPRB,4.2078E-06_JPRB,5.5137E-06_JPRB/)
KBO( :, 2,54, 3) = (/&
&5.5613E-09_JPRB,1.8017E-06_JPRB,3.3529E-06_JPRB,4.7820E-06_JPRB,6.1506E-06_JPRB/)
KBO( :, 3,54, 3) = (/&
&9.2526E-09_JPRB,2.0941E-06_JPRB,3.8143E-06_JPRB,5.3462E-06_JPRB,6.7127E-06_JPRB/)
KBO( :, 4,54, 3) = (/&
&1.6740E-08_JPRB,2.3952E-06_JPRB,4.2796E-06_JPRB,5.9051E-06_JPRB,7.2164E-06_JPRB/)
KBO( :, 5,54, 3) = (/&
&3.0031E-08_JPRB,2.6979E-06_JPRB,4.7338E-06_JPRB,6.4403E-06_JPRB,7.6524E-06_JPRB/)
KBO( :, 1,55, 3) = (/&
&3.1540E-09_JPRB,1.1858E-06_JPRB,2.2670E-06_JPRB,3.2967E-06_JPRB,4.3283E-06_JPRB/)
KBO( :, 2,55, 3) = (/&
&4.0196E-09_JPRB,1.4051E-06_JPRB,2.6332E-06_JPRB,3.7741E-06_JPRB,4.8678E-06_JPRB/)
KBO( :, 3,55, 3) = (/&
&6.3379E-09_JPRB,1.6423E-06_JPRB,3.0104E-06_JPRB,4.2413E-06_JPRB,5.3455E-06_JPRB/)
KBO( :, 4,55, 3) = (/&
&1.1312E-08_JPRB,1.8877E-06_JPRB,3.3935E-06_JPRB,4.7052E-06_JPRB,5.7689E-06_JPRB/)
KBO( :, 5,55, 3) = (/&
&2.0477E-08_JPRB,2.1358E-06_JPRB,3.7709E-06_JPRB,5.1537E-06_JPRB,6.1417E-06_JPRB/)
KBO( :, 1,56, 3) = (/&
&2.4885E-09_JPRB,9.1751E-07_JPRB,1.7642E-06_JPRB,2.5751E-06_JPRB,3.3880E-06_JPRB/)
KBO( :, 2,56, 3) = (/&
&2.9720E-09_JPRB,1.0942E-06_JPRB,2.0641E-06_JPRB,2.9723E-06_JPRB,3.8440E-06_JPRB/)
KBO( :, 3,56, 3) = (/&
&4.3988E-09_JPRB,1.2857E-06_JPRB,2.3716E-06_JPRB,3.3596E-06_JPRB,4.2506E-06_JPRB/)
KBO( :, 4,56, 3) = (/&
&7.6547E-09_JPRB,1.4859E-06_JPRB,2.6877E-06_JPRB,3.7438E-06_JPRB,4.6065E-06_JPRB/)
KBO( :, 5,56, 3) = (/&
&1.3911E-08_JPRB,1.6888E-06_JPRB,2.9997E-06_JPRB,4.1185E-06_JPRB,4.9232E-06_JPRB/)
KBO( :, 1,57, 3) = (/&
&1.9886E-09_JPRB,7.0763E-07_JPRB,1.3683E-06_JPRB,2.0041E-06_JPRB,2.6428E-06_JPRB/)
KBO( :, 2,57, 3) = (/&
&2.2504E-09_JPRB,8.5035E-07_JPRB,1.6145E-06_JPRB,2.3353E-06_JPRB,3.0283E-06_JPRB/)
KBO( :, 3,57, 3) = (/&
&3.1057E-09_JPRB,1.0047E-06_JPRB,1.8650E-06_JPRB,2.6564E-06_JPRB,3.3731E-06_JPRB/)
KBO( :, 4,57, 3) = (/&
&5.1987E-09_JPRB,1.1674E-06_JPRB,2.1248E-06_JPRB,2.9740E-06_JPRB,3.6745E-06_JPRB/)
KBO( :, 5,57, 3) = (/&
&9.4155E-09_JPRB,1.3335E-06_JPRB,2.3825E-06_JPRB,3.2869E-06_JPRB,3.9424E-06_JPRB/)
KBO( :, 1,58, 3) = (/&
&1.6068E-09_JPRB,5.4596E-07_JPRB,1.0610E-06_JPRB,1.5587E-06_JPRB,2.0582E-06_JPRB/)
KBO( :, 2,58, 3) = (/&
&1.7459E-09_JPRB,6.6156E-07_JPRB,1.2631E-06_JPRB,1.8343E-06_JPRB,2.3824E-06_JPRB/)
KBO( :, 3,58, 3) = (/&
&2.2524E-09_JPRB,7.8545E-07_JPRB,1.4674E-06_JPRB,2.1005E-06_JPRB,2.6733E-06_JPRB/)
KBO( :, 4,58, 3) = (/&
&3.5899E-09_JPRB,9.1799E-07_JPRB,1.6806E-06_JPRB,2.3630E-06_JPRB,2.9296E-06_JPRB/)
KBO( :, 5,58, 3) = (/&
&6.4281E-09_JPRB,1.0538E-06_JPRB,1.8933E-06_JPRB,2.6237E-06_JPRB,3.1542E-06_JPRB/)
KBO( :, 1,59, 3) = (/&
&1.3115E-09_JPRB,4.3655E-07_JPRB,8.4995E-07_JPRB,1.2498E-06_JPRB,1.6427E-06_JPRB/)
KBO( :, 2,59, 3) = (/&
&1.4063E-09_JPRB,5.3104E-07_JPRB,1.0161E-06_JPRB,1.4776E-06_JPRB,1.9087E-06_JPRB/)
KBO( :, 3,59, 3) = (/&
&1.7670E-09_JPRB,6.3221E-07_JPRB,1.1839E-06_JPRB,1.6975E-06_JPRB,2.1469E-06_JPRB/)
KBO( :, 4,59, 3) = (/&
&2.7538E-09_JPRB,7.4064E-07_JPRB,1.3591E-06_JPRB,1.9143E-06_JPRB,2.3563E-06_JPRB/)
KBO( :, 5,59, 3) = (/&
&4.8966E-09_JPRB,8.5194E-07_JPRB,1.5343E-06_JPRB,2.1300E-06_JPRB,2.5372E-06_JPRB/)
KBO( :, 1,13, 4) = (/&
&1.4832E-04_JPRB,1.5698E-02_JPRB,2.8434E-02_JPRB,4.0000E-02_JPRB,5.0535E-02_JPRB/)
KBO( :, 2,13, 4) = (/&
&2.7354E-04_JPRB,1.7679E-02_JPRB,3.1476E-02_JPRB,4.3634E-02_JPRB,5.4373E-02_JPRB/)
KBO( :, 3,13, 4) = (/&
&4.7514E-04_JPRB,1.9768E-02_JPRB,3.4498E-02_JPRB,4.7113E-02_JPRB,5.7896E-02_JPRB/)
KBO( :, 4,13, 4) = (/&
&7.6575E-04_JPRB,2.1934E-02_JPRB,3.7431E-02_JPRB,5.0364E-02_JPRB,6.0901E-02_JPRB/)
KBO( :, 5,13, 4) = (/&
&1.1458E-03_JPRB,2.4148E-02_JPRB,4.0264E-02_JPRB,5.3231E-02_JPRB,6.3251E-02_JPRB/)
KBO( :, 1,14, 4) = (/&
&1.3350E-04_JPRB,1.3782E-02_JPRB,2.4857E-02_JPRB,3.4870E-02_JPRB,4.3573E-02_JPRB/)
KBO( :, 2,14, 4) = (/&
&2.4593E-04_JPRB,1.5547E-02_JPRB,2.7509E-02_JPRB,3.8001E-02_JPRB,4.6776E-02_JPRB/)
KBO( :, 3,14, 4) = (/&
&4.2506E-04_JPRB,1.7409E-02_JPRB,3.0122E-02_JPRB,4.0944E-02_JPRB,4.9474E-02_JPRB/)
KBO( :, 4,14, 4) = (/&
&6.7927E-04_JPRB,1.9326E-02_JPRB,3.2594E-02_JPRB,4.3519E-02_JPRB,5.1527E-02_JPRB/)
KBO( :, 5,14, 4) = (/&
&1.0076E-03_JPRB,2.1255E-02_JPRB,3.4899E-02_JPRB,4.5670E-02_JPRB,5.2951E-02_JPRB/)
KBO( :, 1,15, 4) = (/&
&1.2065E-04_JPRB,1.2024E-02_JPRB,2.1582E-02_JPRB,3.0176E-02_JPRB,3.7371E-02_JPRB/)
KBO( :, 2,15, 4) = (/&
&2.2207E-04_JPRB,1.3580E-02_JPRB,2.3845E-02_JPRB,3.2795E-02_JPRB,3.9887E-02_JPRB/)
KBO( :, 3,15, 4) = (/&
&3.8077E-04_JPRB,1.5191E-02_JPRB,2.6000E-02_JPRB,3.5116E-02_JPRB,4.1764E-02_JPRB/)
KBO( :, 4,15, 4) = (/&
&6.0257E-04_JPRB,1.6816E-02_JPRB,2.7979E-02_JPRB,3.7046E-02_JPRB,4.3070E-02_JPRB/)
KBO( :, 5,15, 4) = (/&
&8.8599E-04_JPRB,1.8418E-02_JPRB,2.9799E-02_JPRB,3.8653E-02_JPRB,4.3914E-02_JPRB/)
KBO( :, 1,16, 4) = (/&
&1.0931E-04_JPRB,1.0419E-02_JPRB,1.8587E-02_JPRB,2.5887E-02_JPRB,3.1833E-02_JPRB/)
KBO( :, 2,16, 4) = (/&
&2.0062E-04_JPRB,1.1752E-02_JPRB,2.0443E-02_JPRB,2.7962E-02_JPRB,3.3659E-02_JPRB/)
KBO( :, 3,16, 4) = (/&
&3.4061E-04_JPRB,1.3095E-02_JPRB,2.2148E-02_JPRB,2.9721E-02_JPRB,3.4939E-02_JPRB/)
KBO( :, 4,16, 4) = (/&
&5.3341E-04_JPRB,1.4426E-02_JPRB,2.3724E-02_JPRB,3.1189E-02_JPRB,3.5807E-02_JPRB/)
KBO( :, 5,16, 4) = (/&
&7.7707E-04_JPRB,1.5740E-02_JPRB,2.5194E-02_JPRB,3.2443E-02_JPRB,3.6342E-02_JPRB/)
KBO( :, 1,17, 4) = (/&
&9.8787E-05_JPRB,8.9488E-03_JPRB,1.5843E-02_JPRB,2.1968E-02_JPRB,2.6812E-02_JPRB/)
KBO( :, 2,17, 4) = (/&
&1.8034E-04_JPRB,1.0053E-02_JPRB,1.7312E-02_JPRB,2.3563E-02_JPRB,2.8105E-02_JPRB/)
KBO( :, 3,17, 4) = (/&
&3.0330E-04_JPRB,1.1150E-02_JPRB,1.8677E-02_JPRB,2.4918E-02_JPRB,2.9010E-02_JPRB/)
KBO( :, 4,17, 4) = (/&
&4.6915E-04_JPRB,1.2239E-02_JPRB,1.9960E-02_JPRB,2.6083E-02_JPRB,2.9616E-02_JPRB/)
KBO( :, 5,17, 4) = (/&
&6.7860E-04_JPRB,1.3325E-02_JPRB,2.1171E-02_JPRB,2.7089E-02_JPRB,2.9962E-02_JPRB/)
KBO( :, 1,18, 4) = (/&
&8.9115E-05_JPRB,7.6114E-03_JPRB,1.3364E-02_JPRB,1.8461E-02_JPRB,2.2371E-02_JPRB/)
KBO( :, 2,18, 4) = (/&
&1.6151E-04_JPRB,8.5146E-03_JPRB,1.4542E-02_JPRB,1.9706E-02_JPRB,2.3318E-02_JPRB/)
KBO( :, 3,18, 4) = (/&
&2.6853E-04_JPRB,9.4157E-03_JPRB,1.5660E-02_JPRB,2.0781E-02_JPRB,2.3982E-02_JPRB/)
KBO( :, 4,18, 4) = (/&
&4.1020E-04_JPRB,1.0310E-02_JPRB,1.6712E-02_JPRB,2.1721E-02_JPRB,2.4416E-02_JPRB/)
KBO( :, 5,18, 4) = (/&
&5.9029E-04_JPRB,1.1212E-02_JPRB,1.7715E-02_JPRB,2.2537E-02_JPRB,2.4643E-02_JPRB/)
KBO( :, 1,19, 4) = (/&
&8.0095E-05_JPRB,6.4231E-03_JPRB,1.1196E-02_JPRB,1.5414E-02_JPRB,1.8549E-02_JPRB/)
KBO( :, 2,19, 4) = (/&
&1.4382E-04_JPRB,7.1662E-03_JPRB,1.2159E-02_JPRB,1.6403E-02_JPRB,1.9259E-02_JPRB/)
KBO( :, 3,19, 4) = (/&
&2.3623E-04_JPRB,7.9047E-03_JPRB,1.3080E-02_JPRB,1.7271E-02_JPRB,1.9754E-02_JPRB/)
KBO( :, 4,19, 4) = (/&
&3.5687E-04_JPRB,8.6444E-03_JPRB,1.3944E-02_JPRB,1.8036E-02_JPRB,2.0065E-02_JPRB/)
KBO( :, 5,19, 4) = (/&
&5.1169E-04_JPRB,9.3924E-03_JPRB,1.4772E-02_JPRB,1.8710E-02_JPRB,2.0213E-02_JPRB/)
KBO( :, 1,20, 4) = (/&
&7.2492E-05_JPRB,5.4035E-03_JPRB,9.3587E-03_JPRB,1.2831E-02_JPRB,1.5342E-02_JPRB/)
KBO( :, 2,20, 4) = (/&
&1.2843E-04_JPRB,6.0138E-03_JPRB,1.0150E-02_JPRB,1.3627E-02_JPRB,1.5882E-02_JPRB/)
KBO( :, 3,20, 4) = (/&
&2.0800E-04_JPRB,6.6212E-03_JPRB,1.0905E-02_JPRB,1.4334E-02_JPRB,1.6254E-02_JPRB/)
KBO( :, 4,20, 4) = (/&
&3.1139E-04_JPRB,7.2334E-03_JPRB,1.1615E-02_JPRB,1.4959E-02_JPRB,1.6478E-02_JPRB/)
KBO( :, 5,20, 4) = (/&
&4.4561E-04_JPRB,7.8568E-03_JPRB,1.2299E-02_JPRB,1.5516E-02_JPRB,1.6574E-02_JPRB/)
KBO( :, 1,21, 4) = (/&
&6.5335E-05_JPRB,4.5290E-03_JPRB,7.8063E-03_JPRB,1.0655E-02_JPRB,1.2662E-02_JPRB/)
KBO( :, 2,21, 4) = (/&
&1.1419E-04_JPRB,5.0316E-03_JPRB,8.4549E-03_JPRB,1.1302E-02_JPRB,1.3077E-02_JPRB/)
KBO( :, 3,21, 4) = (/&
&1.8257E-04_JPRB,5.5323E-03_JPRB,9.0718E-03_JPRB,1.1880E-02_JPRB,1.3357E-02_JPRB/)
KBO( :, 4,21, 4) = (/&
&2.7150E-04_JPRB,6.0382E-03_JPRB,9.6571E-03_JPRB,1.2392E-02_JPRB,1.3520E-02_JPRB/)
KBO( :, 5,21, 4) = (/&
&3.8801E-04_JPRB,6.5620E-03_JPRB,1.0220E-02_JPRB,1.2849E-02_JPRB,1.3582E-02_JPRB/)
KBO( :, 1,22, 4) = (/&
&6.0922E-05_JPRB,3.8139E-03_JPRB,6.5357E-03_JPRB,8.8714E-03_JPRB,1.0461E-02_JPRB/)
KBO( :, 2,22, 4) = (/&
&1.0454E-04_JPRB,4.2277E-03_JPRB,7.0637E-03_JPRB,9.3969E-03_JPRB,1.0774E-02_JPRB/)
KBO( :, 3,22, 4) = (/&
&1.6444E-04_JPRB,4.6414E-03_JPRB,7.5689E-03_JPRB,9.8658E-03_JPRB,1.0980E-02_JPRB/)
KBO( :, 4,22, 4) = (/&
&2.4255E-04_JPRB,5.0640E-03_JPRB,8.0491E-03_JPRB,1.0279E-02_JPRB,1.1093E-02_JPRB/)
KBO( :, 5,22, 4) = (/&
&3.4545E-04_JPRB,5.5019E-03_JPRB,8.5122E-03_JPRB,1.0654E-02_JPRB,1.1125E-02_JPRB/)
KBO( :, 1,23, 4) = (/&
&5.6689E-05_JPRB,3.2067E-03_JPRB,5.4634E-03_JPRB,7.3826E-03_JPRB,8.6316E-03_JPRB/)
KBO( :, 2,23, 4) = (/&
&9.5550E-05_JPRB,3.5483E-03_JPRB,5.8959E-03_JPRB,7.8077E-03_JPRB,8.8675E-03_JPRB/)
KBO( :, 3,23, 4) = (/&
&1.4822E-04_JPRB,3.8901E-03_JPRB,6.3080E-03_JPRB,8.1829E-03_JPRB,9.0160E-03_JPRB/)
KBO( :, 4,23, 4) = (/&
&2.1693E-04_JPRB,4.2438E-03_JPRB,6.7020E-03_JPRB,8.5212E-03_JPRB,9.0932E-03_JPRB/)
KBO( :, 5,23, 4) = (/&
&3.0734E-04_JPRB,4.6091E-03_JPRB,7.0873E-03_JPRB,8.8256E-03_JPRB,9.1050E-03_JPRB/)
KBO( :, 1,24, 4) = (/&
&5.2736E-05_JPRB,2.6949E-03_JPRB,4.5641E-03_JPRB,6.1416E-03_JPRB,7.1164E-03_JPRB/)
KBO( :, 2,24, 4) = (/&
&8.7372E-05_JPRB,2.9764E-03_JPRB,4.9186E-03_JPRB,6.4817E-03_JPRB,7.2904E-03_JPRB/)
KBO( :, 3,24, 4) = (/&
&1.3390E-04_JPRB,3.2620E-03_JPRB,5.2557E-03_JPRB,6.7856E-03_JPRB,7.3982E-03_JPRB/)
KBO( :, 4,24, 4) = (/&
&1.9446E-04_JPRB,3.5561E-03_JPRB,5.5797E-03_JPRB,7.0599E-03_JPRB,7.4464E-03_JPRB/)
KBO( :, 5,24, 4) = (/&
&2.7345E-04_JPRB,3.8596E-03_JPRB,5.8982E-03_JPRB,7.3057E-03_JPRB,7.4438E-03_JPRB/)
KBO( :, 1,25, 4) = (/&
&4.9165E-05_JPRB,2.2652E-03_JPRB,3.8124E-03_JPRB,5.1055E-03_JPRB,5.8623E-03_JPRB/)
KBO( :, 2,25, 4) = (/&
&8.0068E-05_JPRB,2.4983E-03_JPRB,4.1027E-03_JPRB,5.3800E-03_JPRB,5.9915E-03_JPRB/)
KBO( :, 3,25, 4) = (/&
&1.2114E-04_JPRB,2.7360E-03_JPRB,4.3785E-03_JPRB,5.6255E-03_JPRB,6.0673E-03_JPRB/)
KBO( :, 4,25, 4) = (/&
&1.7452E-04_JPRB,2.9807E-03_JPRB,4.6460E-03_JPRB,5.8473E-03_JPRB,6.0957E-03_JPRB/)
KBO( :, 5,25, 4) = (/&
&2.4297E-04_JPRB,3.2336E-03_JPRB,4.9074E-03_JPRB,6.0470E-03_JPRB,6.0845E-03_JPRB/)
KBO( :, 1,26, 4) = (/&
&4.6134E-05_JPRB,1.9065E-03_JPRB,3.1876E-03_JPRB,4.2457E-03_JPRB,4.8285E-03_JPRB/)
KBO( :, 2,26, 4) = (/&
&7.3723E-05_JPRB,2.0998E-03_JPRB,3.4240E-03_JPRB,4.4668E-03_JPRB,4.9227E-03_JPRB/)
KBO( :, 3,26, 4) = (/&
&1.0992E-04_JPRB,2.2971E-03_JPRB,3.6508E-03_JPRB,4.6650E-03_JPRB,4.9747E-03_JPRB/)
KBO( :, 4,26, 4) = (/&
&1.5687E-04_JPRB,2.5009E-03_JPRB,3.8701E-03_JPRB,4.8439E-03_JPRB,4.9884E-03_JPRB/)
KBO( :, 5,26, 4) = (/&
&2.1597E-04_JPRB,2.7132E-03_JPRB,4.0857E-03_JPRB,5.0072E-03_JPRB,4.9727E-03_JPRB/)
KBO( :, 1,27, 4) = (/&
&4.3156E-05_JPRB,1.6045E-03_JPRB,2.6642E-03_JPRB,3.5293E-03_JPRB,3.9753E-03_JPRB/)
KBO( :, 2,27, 4) = (/&
&6.7610E-05_JPRB,1.7645E-03_JPRB,2.8577E-03_JPRB,3.7073E-03_JPRB,4.0435E-03_JPRB/)
KBO( :, 3,27, 4) = (/&
&9.9302E-05_JPRB,1.9283E-03_JPRB,3.0434E-03_JPRB,3.8675E-03_JPRB,4.0783E-03_JPRB/)
KBO( :, 4,27, 4) = (/&
&1.4035E-04_JPRB,2.0987E-03_JPRB,3.2238E-03_JPRB,4.0126E-03_JPRB,4.0827E-03_JPRB/)
KBO( :, 5,27, 4) = (/&
&1.9112E-04_JPRB,2.2790E-03_JPRB,3.4026E-03_JPRB,4.1445E-03_JPRB,4.0645E-03_JPRB/)
KBO( :, 1,28, 4) = (/&
&4.0151E-05_JPRB,1.3496E-03_JPRB,2.2256E-03_JPRB,2.9318E-03_JPRB,3.2709E-03_JPRB/)
KBO( :, 2,28, 4) = (/&
&6.1693E-05_JPRB,1.4821E-03_JPRB,2.3842E-03_JPRB,3.0756E-03_JPRB,3.3203E-03_JPRB/)
KBO( :, 3,28, 4) = (/&
&8.9314E-05_JPRB,1.6183E-03_JPRB,2.5363E-03_JPRB,3.2052E-03_JPRB,3.3423E-03_JPRB/)
KBO( :, 4,28, 4) = (/&
&1.2503E-04_JPRB,1.7621E-03_JPRB,2.6850E-03_JPRB,3.3229E-03_JPRB,3.3419E-03_JPRB/)
KBO( :, 5,28, 4) = (/&
&1.6847E-04_JPRB,1.9159E-03_JPRB,2.8346E-03_JPRB,3.4298E-03_JPRB,3.3234E-03_JPRB/)
KBO( :, 1,29, 4) = (/&
&3.7204E-05_JPRB,1.1357E-03_JPRB,1.8605E-03_JPRB,2.4364E-03_JPRB,2.6925E-03_JPRB/)
KBO( :, 2,29, 4) = (/&
&5.6126E-05_JPRB,1.2453E-03_JPRB,1.9896E-03_JPRB,2.5519E-03_JPRB,2.7276E-03_JPRB/)
KBO( :, 3,29, 4) = (/&
&8.0329E-05_JPRB,1.3596E-03_JPRB,2.1150E-03_JPRB,2.6576E-03_JPRB,2.7417E-03_JPRB/)
KBO( :, 4,29, 4) = (/&
&1.1119E-04_JPRB,1.4821E-03_JPRB,2.2379E-03_JPRB,2.7526E-03_JPRB,2.7376E-03_JPRB/)
KBO( :, 5,29, 4) = (/&
&1.4835E-04_JPRB,1.6135E-03_JPRB,2.3653E-03_JPRB,2.8402E-03_JPRB,2.7209E-03_JPRB/)
KBO( :, 1,30, 4) = (/&
&3.4278E-05_JPRB,9.5541E-04_JPRB,1.5548E-03_JPRB,2.0242E-03_JPRB,2.2164E-03_JPRB/)
KBO( :, 2,30, 4) = (/&
&5.0802E-05_JPRB,1.0465E-03_JPRB,1.6607E-03_JPRB,2.1179E-03_JPRB,2.2411E-03_JPRB/)
KBO( :, 3,30, 4) = (/&
&7.2016E-05_JPRB,1.1433E-03_JPRB,1.7631E-03_JPRB,2.2027E-03_JPRB,2.2491E-03_JPRB/)
KBO( :, 4,30, 4) = (/&
&9.8522E-05_JPRB,1.2484E-03_JPRB,1.8671E-03_JPRB,2.2807E-03_JPRB,2.2444E-03_JPRB/)
KBO( :, 5,30, 4) = (/&
&1.3037E-04_JPRB,1.3590E-03_JPRB,1.9752E-03_JPRB,2.3528E-03_JPRB,2.2289E-03_JPRB/)
KBO( :, 1,31, 4) = (/&
&3.1460E-05_JPRB,8.0377E-04_JPRB,1.2994E-03_JPRB,1.6818E-03_JPRB,1.8252E-03_JPRB/)
KBO( :, 2,31, 4) = (/&
&4.5877E-05_JPRB,8.8014E-04_JPRB,1.3859E-03_JPRB,1.7575E-03_JPRB,1.8427E-03_JPRB/)
KBO( :, 3,31, 4) = (/&
&6.4417E-05_JPRB,9.6356E-04_JPRB,1.4714E-03_JPRB,1.8269E-03_JPRB,1.8476E-03_JPRB/)
KBO( :, 4,31, 4) = (/&
&8.7181E-05_JPRB,1.0525E-03_JPRB,1.5596E-03_JPRB,1.8902E-03_JPRB,1.8422E-03_JPRB/)
KBO( :, 5,31, 4) = (/&
&1.1453E-04_JPRB,1.1450E-03_JPRB,1.6516E-03_JPRB,1.9513E-03_JPRB,1.8286E-03_JPRB/)
KBO( :, 1,32, 4) = (/&
&2.8746E-05_JPRB,6.7650E-04_JPRB,1.0860E-03_JPRB,1.3976E-03_JPRB,1.5036E-03_JPRB/)
KBO( :, 2,32, 4) = (/&
&4.1322E-05_JPRB,7.4162E-04_JPRB,1.1570E-03_JPRB,1.4588E-03_JPRB,1.5157E-03_JPRB/)
KBO( :, 3,32, 4) = (/&
&5.7453E-05_JPRB,8.1295E-04_JPRB,1.2291E-03_JPRB,1.5152E-03_JPRB,1.5184E-03_JPRB/)
KBO( :, 4,32, 4) = (/&
&7.7060E-05_JPRB,8.8760E-04_JPRB,1.3041E-03_JPRB,1.5676E-03_JPRB,1.5130E-03_JPRB/)
KBO( :, 5,32, 4) = (/&
&1.0055E-04_JPRB,9.6447E-04_JPRB,1.3816E-03_JPRB,1.6201E-03_JPRB,1.5011E-03_JPRB/)
KBO( :, 1,33, 4) = (/&
&2.6149E-05_JPRB,5.6986E-04_JPRB,9.0744E-04_JPRB,1.1611E-03_JPRB,1.2388E-03_JPRB/)
KBO( :, 2,33, 4) = (/&
&3.7187E-05_JPRB,6.2590E-04_JPRB,9.6645E-04_JPRB,1.2109E-03_JPRB,1.2475E-03_JPRB/)
KBO( :, 3,33, 4) = (/&
&5.1122E-05_JPRB,6.8620E-04_JPRB,1.0278E-03_JPRB,1.2567E-03_JPRB,1.2488E-03_JPRB/)
KBO( :, 4,33, 4) = (/&
&6.7992E-05_JPRB,7.4863E-04_JPRB,1.0916E-03_JPRB,1.3015E-03_JPRB,1.2439E-03_JPRB/)
KBO( :, 5,33, 4) = (/&
&8.8264E-05_JPRB,8.1165E-04_JPRB,1.1560E-03_JPRB,1.3467E-03_JPRB,1.2339E-03_JPRB/)
KBO( :, 1,34, 4) = (/&
&2.3383E-05_JPRB,4.7914E-04_JPRB,7.5656E-04_JPRB,9.6327E-04_JPRB,1.0201E-03_JPRB/)
KBO( :, 2,34, 4) = (/&
&3.2952E-05_JPRB,5.2698E-04_JPRB,8.0647E-04_JPRB,1.0038E-03_JPRB,1.0263E-03_JPRB/)
KBO( :, 3,34, 4) = (/&
&4.4898E-05_JPRB,5.7759E-04_JPRB,8.5874E-04_JPRB,1.0423E-03_JPRB,1.0268E-03_JPRB/)
KBO( :, 4,34, 4) = (/&
&5.9304E-05_JPRB,6.2906E-04_JPRB,9.1184E-04_JPRB,1.0803E-03_JPRB,1.0223E-03_JPRB/)
KBO( :, 5,34, 4) = (/&
&7.6697E-05_JPRB,6.8025E-04_JPRB,9.6511E-04_JPRB,1.1186E-03_JPRB,1.0139E-03_JPRB/)
KBO( :, 1,35, 4) = (/&
&2.0135E-05_JPRB,3.9961E-04_JPRB,6.2708E-04_JPRB,7.9562E-04_JPRB,8.3915E-04_JPRB/)
KBO( :, 2,35, 4) = (/&
&2.8240E-05_JPRB,4.3984E-04_JPRB,6.6953E-04_JPRB,8.2921E-04_JPRB,8.4431E-04_JPRB/)
KBO( :, 3,35, 4) = (/&
&3.8284E-05_JPRB,4.8179E-04_JPRB,7.1336E-04_JPRB,8.6176E-04_JPRB,8.4473E-04_JPRB/)
KBO( :, 4,35, 4) = (/&
&5.0380E-05_JPRB,5.2399E-04_JPRB,7.5755E-04_JPRB,8.9436E-04_JPRB,8.4105E-04_JPRB/)
KBO( :, 5,35, 4) = (/&
&6.4985E-05_JPRB,5.6538E-04_JPRB,8.0096E-04_JPRB,9.2613E-04_JPRB,8.3390E-04_JPRB/)
KBO( :, 1,36, 4) = (/&
&1.6672E-05_JPRB,3.3001E-04_JPRB,5.1652E-04_JPRB,6.5429E-04_JPRB,6.8995E-04_JPRB/)
KBO( :, 2,36, 4) = (/&
&2.3356E-05_JPRB,3.6341E-04_JPRB,5.5227E-04_JPRB,6.8236E-04_JPRB,6.9447E-04_JPRB/)
KBO( :, 3,36, 4) = (/&
&3.1620E-05_JPRB,3.9798E-04_JPRB,5.8880E-04_JPRB,7.1017E-04_JPRB,6.9516E-04_JPRB/)
KBO( :, 4,36, 4) = (/&
&4.1586E-05_JPRB,4.3228E-04_JPRB,6.2537E-04_JPRB,7.3771E-04_JPRB,6.9235E-04_JPRB/)
KBO( :, 5,36, 4) = (/&
&5.3612E-05_JPRB,4.6581E-04_JPRB,6.6082E-04_JPRB,7.6427E-04_JPRB,6.8669E-04_JPRB/)
KBO( :, 1,37, 4) = (/&
&1.3087E-05_JPRB,2.6849E-04_JPRB,4.2115E-04_JPRB,5.3442E-04_JPRB,5.6613E-04_JPRB/)
KBO( :, 2,37, 4) = (/&
&1.8389E-05_JPRB,2.9596E-04_JPRB,4.5110E-04_JPRB,5.5819E-04_JPRB,5.7060E-04_JPRB/)
KBO( :, 3,37, 4) = (/&
&2.4989E-05_JPRB,3.2427E-04_JPRB,4.8144E-04_JPRB,5.8191E-04_JPRB,5.7172E-04_JPRB/)
KBO( :, 4,37, 4) = (/&
&3.2975E-05_JPRB,3.5221E-04_JPRB,5.1177E-04_JPRB,6.0525E-04_JPRB,5.6998E-04_JPRB/)
KBO( :, 5,37, 4) = (/&
&4.2603E-05_JPRB,3.7949E-04_JPRB,5.4072E-04_JPRB,6.2738E-04_JPRB,5.6571E-04_JPRB/)
KBO( :, 1,38, 4) = (/&
&1.0230E-05_JPRB,2.1818E-04_JPRB,3.4316E-04_JPRB,4.3622E-04_JPRB,4.6452E-04_JPRB/)
KBO( :, 2,38, 4) = (/&
&1.4428E-05_JPRB,2.4074E-04_JPRB,3.6819E-04_JPRB,4.5640E-04_JPRB,4.6888E-04_JPRB/)
KBO( :, 3,38, 4) = (/&
&1.9697E-05_JPRB,2.6389E-04_JPRB,3.9346E-04_JPRB,4.7668E-04_JPRB,4.7037E-04_JPRB/)
KBO( :, 4,38, 4) = (/&
&2.6076E-05_JPRB,2.8667E-04_JPRB,4.1847E-04_JPRB,4.9632E-04_JPRB,4.6943E-04_JPRB/)
KBO( :, 5,38, 4) = (/&
&3.3772E-05_JPRB,3.0890E-04_JPRB,4.4212E-04_JPRB,5.1488E-04_JPRB,4.6632E-04_JPRB/)
KBO( :, 1,39, 4) = (/&
&7.9957E-06_JPRB,1.7734E-04_JPRB,2.7964E-04_JPRB,3.5608E-04_JPRB,3.8137E-04_JPRB/)
KBO( :, 2,39, 4) = (/&
&1.1315E-05_JPRB,1.9578E-04_JPRB,3.0056E-04_JPRB,3.7320E-04_JPRB,3.8548E-04_JPRB/)
KBO( :, 3,39, 4) = (/&
&1.5521E-05_JPRB,2.1469E-04_JPRB,3.2152E-04_JPRB,3.9044E-04_JPRB,3.8726E-04_JPRB/)
KBO( :, 4,39, 4) = (/&
&2.0623E-05_JPRB,2.3327E-04_JPRB,3.4211E-04_JPRB,4.0694E-04_JPRB,3.8696E-04_JPRB/)
KBO( :, 5,39, 4) = (/&
&2.6775E-05_JPRB,2.5145E-04_JPRB,3.6146E-04_JPRB,4.2258E-04_JPRB,3.8472E-04_JPRB/)
KBO( :, 1,40, 4) = (/&
&6.0059E-06_JPRB,1.4255E-04_JPRB,2.2608E-04_JPRB,2.8913E-04_JPRB,3.1195E-04_JPRB/)
KBO( :, 2,40, 4) = (/&
&8.5603E-06_JPRB,1.5759E-04_JPRB,2.4350E-04_JPRB,3.0367E-04_JPRB,3.1602E-04_JPRB/)
KBO( :, 3,40, 4) = (/&
&1.1848E-05_JPRB,1.7303E-04_JPRB,2.6092E-04_JPRB,3.1829E-04_JPRB,3.1800E-04_JPRB/)
KBO( :, 4,40, 4) = (/&
&1.5848E-05_JPRB,1.8824E-04_JPRB,2.7792E-04_JPRB,3.3233E-04_JPRB,3.1813E-04_JPRB/)
KBO( :, 5,40, 4) = (/&
&2.0655E-05_JPRB,2.0317E-04_JPRB,2.9386E-04_JPRB,3.4558E-04_JPRB,3.1680E-04_JPRB/)
KBO( :, 1,41, 4) = (/&
&4.4737E-06_JPRB,1.1440E-04_JPRB,1.8254E-04_JPRB,2.3457E-04_JPRB,2.5497E-04_JPRB/)
KBO( :, 2,41, 4) = (/&
&6.4501E-06_JPRB,1.2664E-04_JPRB,1.9704E-04_JPRB,2.4685E-04_JPRB,2.5884E-04_JPRB/)
KBO( :, 3,41, 4) = (/&
&8.9908E-06_JPRB,1.3923E-04_JPRB,2.1149E-04_JPRB,2.5926E-04_JPRB,2.6097E-04_JPRB/)
KBO( :, 4,41, 4) = (/&
&1.2113E-05_JPRB,1.5171E-04_JPRB,2.2552E-04_JPRB,2.7117E-04_JPRB,2.6150E-04_JPRB/)
KBO( :, 5,41, 4) = (/&
&1.5882E-05_JPRB,1.6391E-04_JPRB,2.3860E-04_JPRB,2.8232E-04_JPRB,2.6072E-04_JPRB/)
KBO( :, 1,42, 4) = (/&
&3.3198E-06_JPRB,9.1718E-05_JPRB,1.4723E-04_JPRB,1.9011E-04_JPRB,2.0829E-04_JPRB/)
KBO( :, 2,42, 4) = (/&
&4.8502E-06_JPRB,1.0170E-04_JPRB,1.5931E-04_JPRB,2.0051E-04_JPRB,2.1195E-04_JPRB/)
KBO( :, 3,42, 4) = (/&
&6.8039E-06_JPRB,1.1200E-04_JPRB,1.7132E-04_JPRB,2.1108E-04_JPRB,2.1414E-04_JPRB/)
KBO( :, 4,42, 4) = (/&
&9.2426E-06_JPRB,1.2222E-04_JPRB,1.8289E-04_JPRB,2.2117E-04_JPRB,2.1495E-04_JPRB/)
KBO( :, 5,42, 4) = (/&
&1.2195E-05_JPRB,1.3221E-04_JPRB,1.9367E-04_JPRB,2.3056E-04_JPRB,2.1462E-04_JPRB/)
KBO( :, 1,43, 4) = (/&
&2.3953E-06_JPRB,7.3035E-05_JPRB,1.1812E-04_JPRB,1.5350E-04_JPRB,1.6984E-04_JPRB/)
KBO( :, 2,43, 4) = (/&
&3.5612E-06_JPRB,8.1187E-05_JPRB,1.2819E-04_JPRB,1.6232E-04_JPRB,1.7330E-04_JPRB/)
KBO( :, 3,43, 4) = (/&
&5.0399E-06_JPRB,8.9542E-05_JPRB,1.3813E-04_JPRB,1.7126E-04_JPRB,1.7552E-04_JPRB/)
KBO( :, 4,43, 4) = (/&
&6.9214E-06_JPRB,9.7944E-05_JPRB,1.4772E-04_JPRB,1.7984E-04_JPRB,1.7653E-04_JPRB/)
KBO( :, 5,43, 4) = (/&
&9.2081E-06_JPRB,1.0615E-04_JPRB,1.5668E-04_JPRB,1.8781E-04_JPRB,1.7659E-04_JPRB/)
KBO( :, 1,44, 4) = (/&
&1.6976E-06_JPRB,5.7928E-05_JPRB,9.4481E-05_JPRB,1.2365E-04_JPRB,1.3829E-04_JPRB/)
KBO( :, 2,44, 4) = (/&
&2.5776E-06_JPRB,6.4569E-05_JPRB,1.0281E-04_JPRB,1.3107E-04_JPRB,1.4154E-04_JPRB/)
KBO( :, 3,44, 4) = (/&
&3.6914E-06_JPRB,7.1395E-05_JPRB,1.1108E-04_JPRB,1.3867E-04_JPRB,1.4376E-04_JPRB/)
KBO( :, 4,44, 4) = (/&
&5.1284E-06_JPRB,7.8255E-05_JPRB,1.1905E-04_JPRB,1.4597E-04_JPRB,1.4496E-04_JPRB/)
KBO( :, 5,44, 4) = (/&
&6.8839E-06_JPRB,8.5009E-05_JPRB,1.2651E-04_JPRB,1.5274E-04_JPRB,1.4528E-04_JPRB/)
KBO( :, 1,45, 4) = (/&
&1.1934E-06_JPRB,4.5877E-05_JPRB,7.5459E-05_JPRB,9.9465E-05_JPRB,1.1252E-04_JPRB/)
KBO( :, 2,45, 4) = (/&
&1.8535E-06_JPRB,5.1319E-05_JPRB,8.2366E-05_JPRB,1.0575E-04_JPRB,1.1552E-04_JPRB/)
KBO( :, 3,45, 4) = (/&
&2.7008E-06_JPRB,5.6880E-05_JPRB,8.9246E-05_JPRB,1.1216E-04_JPRB,1.1771E-04_JPRB/)
KBO( :, 4,45, 4) = (/&
&3.7837E-06_JPRB,6.2494E-05_JPRB,9.5875E-05_JPRB,1.1839E-04_JPRB,1.1899E-04_JPRB/)
KBO( :, 5,45, 4) = (/&
&5.1348E-06_JPRB,6.8027E-05_JPRB,1.0210E-04_JPRB,1.2412E-04_JPRB,1.1954E-04_JPRB/)
KBO( :, 1,46, 4) = (/&
&8.2182E-07_JPRB,3.6187E-05_JPRB,6.0090E-05_JPRB,7.9818E-05_JPRB,9.1376E-05_JPRB/)
KBO( :, 2,46, 4) = (/&
&1.3116E-06_JPRB,4.0642E-05_JPRB,6.5780E-05_JPRB,8.5120E-05_JPRB,9.4184E-05_JPRB/)
KBO( :, 3,46, 4) = (/&
&1.9501E-06_JPRB,4.5184E-05_JPRB,7.1520E-05_JPRB,9.0515E-05_JPRB,9.6278E-05_JPRB/)
KBO( :, 4,46, 4) = (/&
&2.7596E-06_JPRB,4.9774E-05_JPRB,7.7042E-05_JPRB,9.5816E-05_JPRB,9.7611E-05_JPRB/)
KBO( :, 5,46, 4) = (/&
&3.7920E-06_JPRB,5.4316E-05_JPRB,8.2245E-05_JPRB,1.0070E-04_JPRB,9.8321E-05_JPRB/)
KBO( :, 1,47, 4) = (/&
&5.4572E-07_JPRB,2.8352E-05_JPRB,4.7590E-05_JPRB,6.3770E-05_JPRB,7.3936E-05_JPRB/)
KBO( :, 2,47, 4) = (/&
&9.0249E-07_JPRB,3.1986E-05_JPRB,5.2255E-05_JPRB,6.8238E-05_JPRB,7.6557E-05_JPRB/)
KBO( :, 3,47, 4) = (/&
&1.3764E-06_JPRB,3.5691E-05_JPRB,5.7035E-05_JPRB,7.2769E-05_JPRB,7.8547E-05_JPRB/)
KBO( :, 4,47, 4) = (/&
&1.9784E-06_JPRB,3.9441E-05_JPRB,6.1643E-05_JPRB,7.7278E-05_JPRB,7.9920E-05_JPRB/)
KBO( :, 5,47, 4) = (/&
&2.7518E-06_JPRB,4.3171E-05_JPRB,6.6014E-05_JPRB,8.1443E-05_JPRB,8.0725E-05_JPRB/)
KBO( :, 1,48, 4) = (/&
&3.5613E-07_JPRB,2.2167E-05_JPRB,3.7637E-05_JPRB,5.0854E-05_JPRB,5.9741E-05_JPRB/)
KBO( :, 2,48, 4) = (/&
&6.1385E-07_JPRB,2.5120E-05_JPRB,4.1451E-05_JPRB,5.4622E-05_JPRB,6.2174E-05_JPRB/)
KBO( :, 3,48, 4) = (/&
&9.6245E-07_JPRB,2.8151E-05_JPRB,4.5401E-05_JPRB,5.8409E-05_JPRB,6.4024E-05_JPRB/)
KBO( :, 4,48, 4) = (/&
&1.4130E-06_JPRB,3.1220E-05_JPRB,4.9258E-05_JPRB,6.2234E-05_JPRB,6.5397E-05_JPRB/)
KBO( :, 5,48, 4) = (/&
&1.9862E-06_JPRB,3.4268E-05_JPRB,5.2922E-05_JPRB,6.5784E-05_JPRB,6.6274E-05_JPRB/)
KBO( :, 1,49, 4) = (/&
&2.2854E-07_JPRB,1.7300E-05_JPRB,2.9705E-05_JPRB,4.0466E-05_JPRB,4.8198E-05_JPRB/)
KBO( :, 2,49, 4) = (/&
&4.1152E-07_JPRB,1.9683E-05_JPRB,3.2825E-05_JPRB,4.3649E-05_JPRB,5.0447E-05_JPRB/)
KBO( :, 3,49, 4) = (/&
&6.6605E-07_JPRB,2.2175E-05_JPRB,3.6088E-05_JPRB,4.6825E-05_JPRB,5.2181E-05_JPRB/)
KBO( :, 4,49, 4) = (/&
&1.0015E-06_JPRB,2.4680E-05_JPRB,3.9305E-05_JPRB,5.0044E-05_JPRB,5.3514E-05_JPRB/)
KBO( :, 5,49, 4) = (/&
&1.4253E-06_JPRB,2.7183E-05_JPRB,4.2380E-05_JPRB,5.3073E-05_JPRB,5.4435E-05_JPRB/)
KBO( :, 1,50, 4) = (/&
&1.4675E-07_JPRB,1.3524E-05_JPRB,2.3463E-05_JPRB,3.2195E-05_JPRB,3.8796E-05_JPRB/)
KBO( :, 2,50, 4) = (/&
&2.7518E-07_JPRB,1.5442E-05_JPRB,2.6020E-05_JPRB,3.4887E-05_JPRB,4.0832E-05_JPRB/)
KBO( :, 3,50, 4) = (/&
&4.6153E-07_JPRB,1.7480E-05_JPRB,2.8694E-05_JPRB,3.7541E-05_JPRB,4.2427E-05_JPRB/)
KBO( :, 4,50, 4) = (/&
&7.1099E-07_JPRB,1.9535E-05_JPRB,3.1383E-05_JPRB,4.0252E-05_JPRB,4.3676E-05_JPRB/)
KBO( :, 5,50, 4) = (/&
&1.0304E-06_JPRB,2.1596E-05_JPRB,3.3959E-05_JPRB,4.2830E-05_JPRB,4.4585E-05_JPRB/)
KBO( :, 1,51, 4) = (/&
&9.3830E-08_JPRB,1.0573E-05_JPRB,1.8529E-05_JPRB,2.5594E-05_JPRB,3.1167E-05_JPRB/)
KBO( :, 2,51, 4) = (/&
&1.8257E-07_JPRB,1.2113E-05_JPRB,2.0626E-05_JPRB,2.7865E-05_JPRB,3.2983E-05_JPRB/)
KBO( :, 3,51, 4) = (/&
&3.1815E-07_JPRB,1.3777E-05_JPRB,2.2807E-05_JPRB,3.0085E-05_JPRB,3.4435E-05_JPRB/)
KBO( :, 4,51, 4) = (/&
&5.0296E-07_JPRB,1.5465E-05_JPRB,2.5047E-05_JPRB,3.2352E-05_JPRB,3.5572E-05_JPRB/)
KBO( :, 5,51, 4) = (/&
&7.4372E-07_JPRB,1.7150E-05_JPRB,2.7196E-05_JPRB,3.4538E-05_JPRB,3.6442E-05_JPRB/)
KBO( :, 1,52, 4) = (/&
&5.9402E-08_JPRB,8.2536E-06_JPRB,1.4613E-05_JPRB,2.0313E-05_JPRB,2.4997E-05_JPRB/)
KBO( :, 2,52, 4) = (/&
&1.1950E-07_JPRB,9.4874E-06_JPRB,1.6325E-05_JPRB,2.2218E-05_JPRB,2.6608E-05_JPRB/)
KBO( :, 3,52, 4) = (/&
&2.1668E-07_JPRB,1.0839E-05_JPRB,1.8107E-05_JPRB,2.4086E-05_JPRB,2.7927E-05_JPRB/)
KBO( :, 4,52, 4) = (/&
&3.5284E-07_JPRB,1.2223E-05_JPRB,1.9960E-05_JPRB,2.5966E-05_JPRB,2.8965E-05_JPRB/)
KBO( :, 5,52, 4) = (/&
&5.3348E-07_JPRB,1.3609E-05_JPRB,2.1758E-05_JPRB,2.7822E-05_JPRB,2.9780E-05_JPRB/)
KBO( :, 1,53, 4) = (/&
&3.7345E-08_JPRB,6.4324E-06_JPRB,1.1502E-05_JPRB,1.6089E-05_JPRB,2.0014E-05_JPRB/)
KBO( :, 2,53, 4) = (/&
&7.7125E-08_JPRB,7.4212E-06_JPRB,1.2900E-05_JPRB,1.7682E-05_JPRB,2.1442E-05_JPRB/)
KBO( :, 3,53, 4) = (/&
&1.4542E-07_JPRB,8.5076E-06_JPRB,1.4352E-05_JPRB,1.9246E-05_JPRB,2.2631E-05_JPRB/)
KBO( :, 4,53, 4) = (/&
&2.4523E-07_JPRB,9.6460E-06_JPRB,1.5883E-05_JPRB,2.0812E-05_JPRB,2.3585E-05_JPRB/)
KBO( :, 5,53, 4) = (/&
&3.7962E-07_JPRB,1.0784E-05_JPRB,1.7382E-05_JPRB,2.2378E-05_JPRB,2.4349E-05_JPRB/)
KBO( :, 1,54, 4) = (/&
&2.4018E-08_JPRB,5.0298E-06_JPRB,9.0727E-06_JPRB,1.2757E-05_JPRB,1.5972E-05_JPRB/)
KBO( :, 2,54, 4) = (/&
&5.0282E-08_JPRB,5.8191E-06_JPRB,1.0210E-05_JPRB,1.4083E-05_JPRB,1.7202E-05_JPRB/)
KBO( :, 3,54, 4) = (/&
&9.8093E-08_JPRB,6.6934E-06_JPRB,1.1398E-05_JPRB,1.5393E-05_JPRB,1.8246E-05_JPRB/)
KBO( :, 4,54, 4) = (/&
&1.7136E-07_JPRB,7.6261E-06_JPRB,1.2653E-05_JPRB,1.6695E-05_JPRB,1.9090E-05_JPRB/)
KBO( :, 5,54, 4) = (/&
&2.7159E-07_JPRB,8.5620E-06_JPRB,1.3903E-05_JPRB,1.8013E-05_JPRB,1.9768E-05_JPRB/)
KBO( :, 1,55, 4) = (/&
&1.5705E-08_JPRB,3.9361E-06_JPRB,7.1560E-06_JPRB,1.0111E-05_JPRB,1.2713E-05_JPRB/)
KBO( :, 2,55, 4) = (/&
&3.2852E-08_JPRB,4.5671E-06_JPRB,8.0833E-06_JPRB,1.1215E-05_JPRB,1.3756E-05_JPRB/)
KBO( :, 3,55, 4) = (/&
&6.5995E-08_JPRB,5.2691E-06_JPRB,9.0558E-06_JPRB,1.2309E-05_JPRB,1.4658E-05_JPRB/)
KBO( :, 4,55, 4) = (/&
&1.1933E-07_JPRB,6.0307E-06_JPRB,1.0082E-05_JPRB,1.3396E-05_JPRB,1.5392E-05_JPRB/)
KBO( :, 5,55, 4) = (/&
&1.9407E-07_JPRB,6.7994E-06_JPRB,1.1122E-05_JPRB,1.4497E-05_JPRB,1.5981E-05_JPRB/)
KBO( :, 1,56, 4) = (/&
&1.0423E-08_JPRB,3.0764E-06_JPRB,5.6365E-06_JPRB,8.0036E-06_JPRB,1.0107E-05_JPRB/)
KBO( :, 2,56, 4) = (/&
&2.1352E-08_JPRB,3.5821E-06_JPRB,6.3947E-06_JPRB,8.9204E-06_JPRB,1.0989E-05_JPRB/)
KBO( :, 3,56, 4) = (/&
&4.3941E-08_JPRB,4.1425E-06_JPRB,7.1860E-06_JPRB,9.8275E-06_JPRB,1.1759E-05_JPRB/)
KBO( :, 4,56, 4) = (/&
&8.2219E-08_JPRB,4.7612E-06_JPRB,8.0218E-06_JPRB,1.0735E-05_JPRB,1.2399E-05_JPRB/)
KBO( :, 5,56, 4) = (/&
&1.3782E-07_JPRB,5.3933E-06_JPRB,8.8859E-06_JPRB,1.1651E-05_JPRB,1.2911E-05_JPRB/)
KBO( :, 1,57, 4) = (/&
&7.0716E-09_JPRB,2.4016E-06_JPRB,4.4336E-06_JPRB,6.3273E-06_JPRB,8.0236E-06_JPRB/)
KBO( :, 2,57, 4) = (/&
&1.3864E-08_JPRB,2.8058E-06_JPRB,5.0502E-06_JPRB,7.0825E-06_JPRB,8.7616E-06_JPRB/)
KBO( :, 3,57, 4) = (/&
&2.8989E-08_JPRB,3.2523E-06_JPRB,5.6949E-06_JPRB,7.8345E-06_JPRB,9.4204E-06_JPRB/)
KBO( :, 4,57, 4) = (/&
&5.6049E-08_JPRB,3.7535E-06_JPRB,6.3764E-06_JPRB,8.5926E-06_JPRB,9.9758E-06_JPRB/)
KBO( :, 5,57, 4) = (/&
&9.7119E-08_JPRB,4.2717E-06_JPRB,7.0902E-06_JPRB,9.3510E-06_JPRB,1.0422E-05_JPRB/)
KBO( :, 1,58, 4) = (/&
&4.9738E-09_JPRB,1.8772E-06_JPRB,3.4889E-06_JPRB,5.0033E-06_JPRB,6.3670E-06_JPRB/)
KBO( :, 2,58, 4) = (/&
&9.1491E-09_JPRB,2.2003E-06_JPRB,3.9908E-06_JPRB,5.6234E-06_JPRB,6.9822E-06_JPRB/)
KBO( :, 3,58, 4) = (/&
&1.9204E-08_JPRB,2.5577E-06_JPRB,4.5175E-06_JPRB,6.2482E-06_JPRB,7.5411E-06_JPRB/)
KBO( :, 4,58, 4) = (/&
&3.8223E-08_JPRB,2.9606E-06_JPRB,5.0708E-06_JPRB,6.8776E-06_JPRB,8.0170E-06_JPRB/)
KBO( :, 5,58, 4) = (/&
&6.8398E-08_JPRB,3.3850E-06_JPRB,5.6590E-06_JPRB,7.5062E-06_JPRB,8.4029E-06_JPRB/)
KBO( :, 1,59, 4) = (/&
&3.8735E-09_JPRB,1.5107E-06_JPRB,2.8146E-06_JPRB,4.0428E-06_JPRB,5.1269E-06_JPRB/)
KBO( :, 2,59, 4) = (/&
&6.9185E-09_JPRB,1.7736E-06_JPRB,3.2266E-06_JPRB,4.5533E-06_JPRB,5.6260E-06_JPRB/)
KBO( :, 3,59, 4) = (/&
&1.4484E-08_JPRB,2.0648E-06_JPRB,3.6588E-06_JPRB,5.0704E-06_JPRB,6.0775E-06_JPRB/)
KBO( :, 4,59, 4) = (/&
&2.9105E-08_JPRB,2.3952E-06_JPRB,4.1152E-06_JPRB,5.5930E-06_JPRB,6.4648E-06_JPRB/)
KBO( :, 5,59, 4) = (/&
&5.2712E-08_JPRB,2.7434E-06_JPRB,4.6004E-06_JPRB,6.1168E-06_JPRB,6.7765E-06_JPRB/)
KBO( :, 1,13, 5) = (/&
&9.5206E-04_JPRB,3.5867E-02_JPRB,6.3329E-02_JPRB,8.8273E-02_JPRB,1.0919E-01_JPRB/)
KBO( :, 2,13, 5) = (/&
&1.4606E-03_JPRB,3.9499E-02_JPRB,6.8038E-02_JPRB,9.3530E-02_JPRB,1.1392E-01_JPRB/)
KBO( :, 3,13, 5) = (/&
&2.1122E-03_JPRB,4.3255E-02_JPRB,7.2755E-02_JPRB,9.8485E-02_JPRB,1.1804E-01_JPRB/)
KBO( :, 4,13, 5) = (/&
&2.9342E-03_JPRB,4.7055E-02_JPRB,7.7481E-02_JPRB,1.0325E-01_JPRB,1.2194E-01_JPRB/)
KBO( :, 5,13, 5) = (/&
&3.9691E-03_JPRB,5.0998E-02_JPRB,8.2111E-02_JPRB,1.0793E-01_JPRB,1.2556E-01_JPRB/)
KBO( :, 1,14, 5) = (/&
&8.3529E-04_JPRB,3.1756E-02_JPRB,5.5904E-02_JPRB,7.7763E-02_JPRB,9.5354E-02_JPRB/)
KBO( :, 2,14, 5) = (/&
&1.2709E-03_JPRB,3.5009E-02_JPRB,6.0040E-02_JPRB,8.2374E-02_JPRB,9.9262E-02_JPRB/)
KBO( :, 3,14, 5) = (/&
&1.8315E-03_JPRB,3.8336E-02_JPRB,6.4269E-02_JPRB,8.6806E-02_JPRB,1.0290E-01_JPRB/)
KBO( :, 4,14, 5) = (/&
&2.5450E-03_JPRB,4.1786E-02_JPRB,6.8525E-02_JPRB,9.1155E-02_JPRB,1.0629E-01_JPRB/)
KBO( :, 5,14, 5) = (/&
&3.4515E-03_JPRB,4.5381E-02_JPRB,7.2773E-02_JPRB,9.5396E-02_JPRB,1.0928E-01_JPRB/)
KBO( :, 1,15, 5) = (/&
&7.3165E-04_JPRB,2.7921E-02_JPRB,4.8914E-02_JPRB,6.7922E-02_JPRB,8.2662E-02_JPRB/)
KBO( :, 2,15, 5) = (/&
&1.1052E-03_JPRB,3.0784E-02_JPRB,5.2602E-02_JPRB,7.1990E-02_JPRB,8.6043E-02_JPRB/)
KBO( :, 3,15, 5) = (/&
&1.5893E-03_JPRB,3.3752E-02_JPRB,5.6376E-02_JPRB,7.5928E-02_JPRB,8.9235E-02_JPRB/)
KBO( :, 4,15, 5) = (/&
&2.2106E-03_JPRB,3.6890E-02_JPRB,6.0189E-02_JPRB,7.9806E-02_JPRB,9.1982E-02_JPRB/)
KBO( :, 5,15, 5) = (/&
&3.0053E-03_JPRB,4.0122E-02_JPRB,6.4009E-02_JPRB,8.3450E-02_JPRB,9.3979E-02_JPRB/)
KBO( :, 1,16, 5) = (/&
&6.3939E-04_JPRB,2.4371E-02_JPRB,4.2503E-02_JPRB,5.8900E-02_JPRB,7.1290E-02_JPRB/)
KBO( :, 2,16, 5) = (/&
&9.6055E-04_JPRB,2.6877E-02_JPRB,4.5773E-02_JPRB,6.2455E-02_JPRB,7.4252E-02_JPRB/)
KBO( :, 3,16, 5) = (/&
&1.3794E-03_JPRB,2.9539E-02_JPRB,4.9114E-02_JPRB,6.5898E-02_JPRB,7.6813E-02_JPRB/)
KBO( :, 4,16, 5) = (/&
&1.9216E-03_JPRB,3.2321E-02_JPRB,5.2426E-02_JPRB,6.9093E-02_JPRB,7.8632E-02_JPRB/)
KBO( :, 5,16, 5) = (/&
&2.6144E-03_JPRB,3.5146E-02_JPRB,5.5567E-02_JPRB,7.1811E-02_JPRB,7.9616E-02_JPRB/)
KBO( :, 1,17, 5) = (/&
&5.5621E-04_JPRB,2.1119E-02_JPRB,3.6702E-02_JPRB,5.0729E-02_JPRB,6.1106E-02_JPRB/)
KBO( :, 2,17, 5) = (/&
&8.3232E-04_JPRB,2.3324E-02_JPRB,3.9564E-02_JPRB,5.3768E-02_JPRB,6.3482E-02_JPRB/)
KBO( :, 3,17, 5) = (/&
&1.1952E-03_JPRB,2.5644E-02_JPRB,4.2368E-02_JPRB,5.6531E-02_JPRB,6.5194E-02_JPRB/)
KBO( :, 4,17, 5) = (/&
&1.6664E-03_JPRB,2.8012E-02_JPRB,4.5051E-02_JPRB,5.8907E-02_JPRB,6.6158E-02_JPRB/)
KBO( :, 5,17, 5) = (/&
&2.2697E-03_JPRB,3.0355E-02_JPRB,4.7479E-02_JPRB,6.0879E-02_JPRB,6.6574E-02_JPRB/)
KBO( :, 1,18, 5) = (/&
&4.8259E-04_JPRB,1.8188E-02_JPRB,3.1503E-02_JPRB,4.3373E-02_JPRB,5.1944E-02_JPRB/)
KBO( :, 2,18, 5) = (/&
&7.2053E-04_JPRB,2.0086E-02_JPRB,3.3870E-02_JPRB,4.5795E-02_JPRB,5.3602E-02_JPRB/)
KBO( :, 3,18, 5) = (/&
&1.0344E-03_JPRB,2.2024E-02_JPRB,3.6106E-02_JPRB,4.7862E-02_JPRB,5.4601E-02_JPRB/)
KBO( :, 4,18, 5) = (/&
&1.4426E-03_JPRB,2.3955E-02_JPRB,3.8187E-02_JPRB,4.9634E-02_JPRB,5.5105E-02_JPRB/)
KBO( :, 5,18, 5) = (/&
&1.9652E-03_JPRB,2.5872E-02_JPRB,4.0129E-02_JPRB,5.1165E-02_JPRB,5.5250E-02_JPRB/)
KBO( :, 1,19, 5) = (/&
&4.1792E-04_JPRB,1.5551E-02_JPRB,2.6815E-02_JPRB,3.6748E-02_JPRB,4.3685E-02_JPRB/)
KBO( :, 2,19, 5) = (/&
&6.2288E-04_JPRB,1.7122E-02_JPRB,2.8681E-02_JPRB,3.8570E-02_JPRB,4.4726E-02_JPRB/)
KBO( :, 3,19, 5) = (/&
&8.9314E-04_JPRB,1.8695E-02_JPRB,3.0435E-02_JPRB,4.0145E-02_JPRB,4.5326E-02_JPRB/)
KBO( :, 4,19, 5) = (/&
&1.2454E-03_JPRB,2.0272E-02_JPRB,3.2103E-02_JPRB,4.1538E-02_JPRB,4.5592E-02_JPRB/)
KBO( :, 5,19, 5) = (/&
&1.6963E-03_JPRB,2.1865E-02_JPRB,3.3692E-02_JPRB,4.2753E-02_JPRB,4.5589E-02_JPRB/)
KBO( :, 1,20, 5) = (/&
&3.6420E-04_JPRB,1.3204E-02_JPRB,2.2627E-02_JPRB,3.0869E-02_JPRB,3.6406E-02_JPRB/)
KBO( :, 2,20, 5) = (/&
&5.4128E-04_JPRB,1.4478E-02_JPRB,2.4102E-02_JPRB,3.2269E-02_JPRB,3.7086E-02_JPRB/)
KBO( :, 3,20, 5) = (/&
&7.7497E-04_JPRB,1.5768E-02_JPRB,2.5513E-02_JPRB,3.3512E-02_JPRB,3.7454E-02_JPRB/)
KBO( :, 4,20, 5) = (/&
&1.0788E-03_JPRB,1.7071E-02_JPRB,2.6877E-02_JPRB,3.4628E-02_JPRB,3.7589E-02_JPRB/)
KBO( :, 5,20, 5) = (/&
&1.4684E-03_JPRB,1.8409E-02_JPRB,2.8186E-02_JPRB,3.5595E-02_JPRB,3.7513E-02_JPRB/)
KBO( :, 1,21, 5) = (/&
&3.1749E-04_JPRB,1.1126E-02_JPRB,1.8957E-02_JPRB,2.5768E-02_JPRB,3.0157E-02_JPRB/)
KBO( :, 2,21, 5) = (/&
&4.7023E-04_JPRB,1.2173E-02_JPRB,2.0148E-02_JPRB,2.6878E-02_JPRB,3.0618E-02_JPRB/)
KBO( :, 3,21, 5) = (/&
&6.7172E-04_JPRB,1.3233E-02_JPRB,2.1304E-02_JPRB,2.7875E-02_JPRB,3.0852E-02_JPRB/)
KBO( :, 4,21, 5) = (/&
&9.3331E-04_JPRB,1.4327E-02_JPRB,2.2423E-02_JPRB,2.8768E-02_JPRB,3.0908E-02_JPRB/)
KBO( :, 5,21, 5) = (/&
&1.2694E-03_JPRB,1.5438E-02_JPRB,2.3509E-02_JPRB,2.9558E-02_JPRB,3.0797E-02_JPRB/)
KBO( :, 1,22, 5) = (/&
&2.8408E-04_JPRB,9.3883E-03_JPRB,1.5880E-02_JPRB,2.1492E-02_JPRB,2.4916E-02_JPRB/)
KBO( :, 2,22, 5) = (/&
&4.1797E-04_JPRB,1.0249E-02_JPRB,1.6855E-02_JPRB,2.2374E-02_JPRB,2.5222E-02_JPRB/)
KBO( :, 3,22, 5) = (/&
&5.9453E-04_JPRB,1.1132E-02_JPRB,1.7800E-02_JPRB,2.3170E-02_JPRB,2.5366E-02_JPRB/)
KBO( :, 4,22, 5) = (/&
&8.2301E-04_JPRB,1.2047E-02_JPRB,1.8719E-02_JPRB,2.3894E-02_JPRB,2.5365E-02_JPRB/)
KBO( :, 5,22, 5) = (/&
&1.1184E-03_JPRB,1.2973E-02_JPRB,1.9629E-02_JPRB,2.4534E-02_JPRB,2.5237E-02_JPRB/)
KBO( :, 1,23, 5) = (/&
&2.5418E-04_JPRB,7.8977E-03_JPRB,1.3269E-02_JPRB,1.7874E-02_JPRB,2.0529E-02_JPRB/)
KBO( :, 2,23, 5) = (/&
&3.7141E-04_JPRB,8.6092E-03_JPRB,1.4071E-02_JPRB,1.8581E-02_JPRB,2.0735E-02_JPRB/)
KBO( :, 3,23, 5) = (/&
&5.2592E-04_JPRB,9.3501E-03_JPRB,1.4842E-02_JPRB,1.9229E-02_JPRB,2.0817E-02_JPRB/)
KBO( :, 4,23, 5) = (/&
&7.2596E-04_JPRB,1.0112E-02_JPRB,1.5610E-02_JPRB,1.9813E-02_JPRB,2.0787E-02_JPRB/)
KBO( :, 5,23, 5) = (/&
&9.8686E-04_JPRB,1.0888E-02_JPRB,1.6368E-02_JPRB,2.0340E-02_JPRB,2.0658E-02_JPRB/)
KBO( :, 1,24, 5) = (/&
&2.2750E-04_JPRB,6.6317E-03_JPRB,1.1075E-02_JPRB,1.4842E-02_JPRB,1.6884E-02_JPRB/)
KBO( :, 2,24, 5) = (/&
&3.3026E-04_JPRB,7.2252E-03_JPRB,1.1728E-02_JPRB,1.5415E-02_JPRB,1.7024E-02_JPRB/)
KBO( :, 3,24, 5) = (/&
&4.6578E-04_JPRB,7.8440E-03_JPRB,1.2367E-02_JPRB,1.5941E-02_JPRB,1.7063E-02_JPRB/)
KBO( :, 4,24, 5) = (/&
&6.4270E-04_JPRB,8.4805E-03_JPRB,1.3008E-02_JPRB,1.6415E-02_JPRB,1.7016E-02_JPRB/)
KBO( :, 5,24, 5) = (/&
&8.7339E-04_JPRB,9.1332E-03_JPRB,1.3636E-02_JPRB,1.6855E-02_JPRB,1.6890E-02_JPRB/)
KBO( :, 1,25, 5) = (/&
&2.0394E-04_JPRB,5.5639E-03_JPRB,9.2339E-03_JPRB,1.2315E-02_JPRB,1.3870E-02_JPRB/)
KBO( :, 2,25, 5) = (/&
&2.9439E-04_JPRB,6.0615E-03_JPRB,9.7694E-03_JPRB,1.2780E-02_JPRB,1.3961E-02_JPRB/)
KBO( :, 3,25, 5) = (/&
&4.1407E-04_JPRB,6.5784E-03_JPRB,1.0303E-02_JPRB,1.3206E-02_JPRB,1.3975E-02_JPRB/)
KBO( :, 4,25, 5) = (/&
&5.7180E-04_JPRB,7.1121E-03_JPRB,1.0835E-02_JPRB,1.3598E-02_JPRB,1.3919E-02_JPRB/)
KBO( :, 5,25, 5) = (/&
&7.7557E-04_JPRB,7.6591E-03_JPRB,1.1360E-02_JPRB,1.3963E-02_JPRB,1.3799E-02_JPRB/)
KBO( :, 1,26, 5) = (/&
&1.8382E-04_JPRB,4.6737E-03_JPRB,7.6992E-03_JPRB,1.0216E-02_JPRB,1.1388E-02_JPRB/)
KBO( :, 2,26, 5) = (/&
&2.6412E-04_JPRB,5.0893E-03_JPRB,8.1430E-03_JPRB,1.0593E-02_JPRB,1.1444E-02_JPRB/)
KBO( :, 3,26, 5) = (/&
&3.7112E-04_JPRB,5.5248E-03_JPRB,8.5884E-03_JPRB,1.0942E-02_JPRB,1.1439E-02_JPRB/)
KBO( :, 4,26, 5) = (/&
&5.1206E-04_JPRB,5.9696E-03_JPRB,9.0299E-03_JPRB,1.1267E-02_JPRB,1.1378E-02_JPRB/)
KBO( :, 5,26, 5) = (/&
&6.9168E-04_JPRB,6.4260E-03_JPRB,9.4675E-03_JPRB,1.1565E-02_JPRB,1.1265E-02_JPRB/)
KBO( :, 1,27, 5) = (/&
&1.6571E-04_JPRB,3.9248E-03_JPRB,6.4172E-03_JPRB,8.4701E-03_JPRB,9.3451E-03_JPRB/)
KBO( :, 2,27, 5) = (/&
&2.3754E-04_JPRB,4.2747E-03_JPRB,6.7865E-03_JPRB,8.7783E-03_JPRB,9.3771E-03_JPRB/)
KBO( :, 3,27, 5) = (/&
&3.3337E-04_JPRB,4.6378E-03_JPRB,7.1567E-03_JPRB,9.0646E-03_JPRB,9.3601E-03_JPRB/)
KBO( :, 4,27, 5) = (/&
&4.5858E-04_JPRB,5.0089E-03_JPRB,7.5246E-03_JPRB,9.3326E-03_JPRB,9.2999E-03_JPRB/)
KBO( :, 5,27, 5) = (/&
&6.1684E-04_JPRB,5.3899E-03_JPRB,7.8886E-03_JPRB,9.5804E-03_JPRB,9.1956E-03_JPRB/)
KBO( :, 1,28, 5) = (/&
&1.4962E-04_JPRB,3.2968E-03_JPRB,5.3486E-03_JPRB,7.0211E-03_JPRB,7.6657E-03_JPRB/)
KBO( :, 2,28, 5) = (/&
&2.1414E-04_JPRB,3.5906E-03_JPRB,5.6546E-03_JPRB,7.2727E-03_JPRB,7.6801E-03_JPRB/)
KBO( :, 3,28, 5) = (/&
&2.9958E-04_JPRB,3.8927E-03_JPRB,5.9643E-03_JPRB,7.5099E-03_JPRB,7.6582E-03_JPRB/)
KBO( :, 4,28, 5) = (/&
&4.1038E-04_JPRB,4.2012E-03_JPRB,6.2693E-03_JPRB,7.7298E-03_JPRB,7.5988E-03_JPRB/)
KBO( :, 5,28, 5) = (/&
&5.4914E-04_JPRB,4.5240E-03_JPRB,6.5722E-03_JPRB,7.9359E-03_JPRB,7.5057E-03_JPRB/)
KBO( :, 1,29, 5) = (/&
&1.3561E-04_JPRB,2.7716E-03_JPRB,4.4584E-03_JPRB,5.8201E-03_JPRB,6.2872E-03_JPRB/)
KBO( :, 2,29, 5) = (/&
&1.9362E-04_JPRB,3.0169E-03_JPRB,4.7155E-03_JPRB,6.0283E-03_JPRB,6.2926E-03_JPRB/)
KBO( :, 3,29, 5) = (/&
&2.6977E-04_JPRB,3.2683E-03_JPRB,4.9713E-03_JPRB,6.2221E-03_JPRB,6.2669E-03_JPRB/)
KBO( :, 4,29, 5) = (/&
&3.6734E-04_JPRB,3.5269E-03_JPRB,5.2257E-03_JPRB,6.4042E-03_JPRB,6.2118E-03_JPRB/)
KBO( :, 5,29, 5) = (/&
&4.8841E-04_JPRB,3.8031E-03_JPRB,5.4769E-03_JPRB,6.5743E-03_JPRB,6.1306E-03_JPRB/)
KBO( :, 1,30, 5) = (/&
&1.2311E-04_JPRB,2.3299E-03_JPRB,3.7176E-03_JPRB,4.8241E-03_JPRB,5.1561E-03_JPRB/)
KBO( :, 2,30, 5) = (/&
&1.7495E-04_JPRB,2.5344E-03_JPRB,3.9319E-03_JPRB,4.9954E-03_JPRB,5.1555E-03_JPRB/)
KBO( :, 3,30, 5) = (/&
&2.4248E-04_JPRB,2.7440E-03_JPRB,4.1448E-03_JPRB,5.1563E-03_JPRB,5.1297E-03_JPRB/)
KBO( :, 4,30, 5) = (/&
&3.2798E-04_JPRB,2.9629E-03_JPRB,4.3553E-03_JPRB,5.3054E-03_JPRB,5.0790E-03_JPRB/)
KBO( :, 5,30, 5) = (/&
&4.3295E-04_JPRB,3.2017E-03_JPRB,4.5670E-03_JPRB,5.4466E-03_JPRB,5.0095E-03_JPRB/)
KBO( :, 1,31, 5) = (/&
&1.1192E-04_JPRB,1.9595E-03_JPRB,3.1024E-03_JPRB,4.0004E-03_JPRB,4.2313E-03_JPRB/)
KBO( :, 2,31, 5) = (/&
&1.5800E-04_JPRB,2.1296E-03_JPRB,3.2801E-03_JPRB,4.1421E-03_JPRB,4.2268E-03_JPRB/)
KBO( :, 3,31, 5) = (/&
&2.1757E-04_JPRB,2.3054E-03_JPRB,3.4565E-03_JPRB,4.2735E-03_JPRB,4.2017E-03_JPRB/)
KBO( :, 4,31, 5) = (/&
&2.9222E-04_JPRB,2.4942E-03_JPRB,3.6328E-03_JPRB,4.3970E-03_JPRB,4.1575E-03_JPRB/)
KBO( :, 5,31, 5) = (/&
&3.8261E-04_JPRB,2.7007E-03_JPRB,3.8145E-03_JPRB,4.5146E-03_JPRB,4.0989E-03_JPRB/)
KBO( :, 1,32, 5) = (/&
&1.0163E-04_JPRB,1.6481E-03_JPRB,2.5899E-03_JPRB,3.3182E-03_JPRB,3.4733E-03_JPRB/)
KBO( :, 2,32, 5) = (/&
&1.4246E-04_JPRB,1.7902E-03_JPRB,2.7371E-03_JPRB,3.4345E-03_JPRB,3.4660E-03_JPRB/)
KBO( :, 3,32, 5) = (/&
&1.9480E-04_JPRB,1.9398E-03_JPRB,2.8839E-03_JPRB,3.5427E-03_JPRB,3.4424E-03_JPRB/)
KBO( :, 4,32, 5) = (/&
&2.5957E-04_JPRB,2.1035E-03_JPRB,3.0336E-03_JPRB,3.6462E-03_JPRB,3.4050E-03_JPRB/)
KBO( :, 5,32, 5) = (/&
&3.3711E-04_JPRB,2.2803E-03_JPRB,3.1908E-03_JPRB,3.7450E-03_JPRB,3.3564E-03_JPRB/)
KBO( :, 1,33, 5) = (/&
&9.2126E-05_JPRB,1.3862E-03_JPRB,2.1619E-03_JPRB,2.7533E-03_JPRB,2.8512E-03_JPRB/)
KBO( :, 2,33, 5) = (/&
&1.2819E-04_JPRB,1.5059E-03_JPRB,2.2846E-03_JPRB,2.8490E-03_JPRB,2.8435E-03_JPRB/)
KBO( :, 3,33, 5) = (/&
&1.7396E-04_JPRB,1.6352E-03_JPRB,2.4079E-03_JPRB,2.9394E-03_JPRB,2.8229E-03_JPRB/)
KBO( :, 4,33, 5) = (/&
&2.2988E-04_JPRB,1.7763E-03_JPRB,2.5366E-03_JPRB,3.0253E-03_JPRB,2.7916E-03_JPRB/)
KBO( :, 5,33, 5) = (/&
&2.9642E-04_JPRB,1.9270E-03_JPRB,2.6736E-03_JPRB,3.1112E-03_JPRB,2.7515E-03_JPRB/)
KBO( :, 1,34, 5) = (/&
&8.2273E-05_JPRB,1.1628E-03_JPRB,1.8018E-03_JPRB,2.2821E-03_JPRB,2.3408E-03_JPRB/)
KBO( :, 2,34, 5) = (/&
&1.1377E-04_JPRB,1.2650E-03_JPRB,1.9038E-03_JPRB,2.3616E-03_JPRB,2.3330E-03_JPRB/)
KBO( :, 3,34, 5) = (/&
&1.5328E-04_JPRB,1.3767E-03_JPRB,2.0090E-03_JPRB,2.4362E-03_JPRB,2.3154E-03_JPRB/)
KBO( :, 4,34, 5) = (/&
&2.0116E-04_JPRB,1.4967E-03_JPRB,2.1205E-03_JPRB,2.5102E-03_JPRB,2.2896E-03_JPRB/)
KBO( :, 5,34, 5) = (/&
&2.5794E-04_JPRB,1.6239E-03_JPRB,2.2376E-03_JPRB,2.5850E-03_JPRB,2.2567E-03_JPRB/)
KBO( :, 1,35, 5) = (/&
&7.0985E-05_JPRB,9.6792E-04_JPRB,1.4935E-03_JPRB,1.8860E-03_JPRB,1.9224E-03_JPRB/)
KBO( :, 2,35, 5) = (/&
&9.7802E-05_JPRB,1.0553E-03_JPRB,1.5791E-03_JPRB,1.9515E-03_JPRB,1.9160E-03_JPRB/)
KBO( :, 3,35, 5) = (/&
&1.3114E-04_JPRB,1.1504E-03_JPRB,1.6692E-03_JPRB,2.0149E-03_JPRB,1.9021E-03_JPRB/)
KBO( :, 4,35, 5) = (/&
&1.7143E-04_JPRB,1.2515E-03_JPRB,1.7654E-03_JPRB,2.0786E-03_JPRB,1.8814E-03_JPRB/)
KBO( :, 5,35, 5) = (/&
&2.1910E-04_JPRB,1.3576E-03_JPRB,1.8646E-03_JPRB,2.1453E-03_JPRB,1.8551E-03_JPRB/)
KBO( :, 1,36, 5) = (/&
&5.9035E-05_JPRB,7.9892E-04_JPRB,1.2308E-03_JPRB,1.5523E-03_JPRB,1.5795E-03_JPRB/)
KBO( :, 2,36, 5) = (/&
&8.1217E-05_JPRB,8.7305E-04_JPRB,1.3026E-03_JPRB,1.6078E-03_JPRB,1.5749E-03_JPRB/)
KBO( :, 3,36, 5) = (/&
&1.0874E-04_JPRB,9.5286E-04_JPRB,1.3800E-03_JPRB,1.6617E-03_JPRB,1.5644E-03_JPRB/)
KBO( :, 4,36, 5) = (/&
&1.4198E-04_JPRB,1.0374E-03_JPRB,1.4616E-03_JPRB,1.7169E-03_JPRB,1.5482E-03_JPRB/)
KBO( :, 5,36, 5) = (/&
&1.8132E-04_JPRB,1.1249E-03_JPRB,1.5450E-03_JPRB,1.7750E-03_JPRB,1.5279E-03_JPRB/)
KBO( :, 1,37, 5) = (/&
&4.6641E-05_JPRB,6.5099E-04_JPRB,1.0056E-03_JPRB,1.2714E-03_JPRB,1.2972E-03_JPRB/)
KBO( :, 2,37, 5) = (/&
&6.4348E-05_JPRB,7.1292E-04_JPRB,1.0660E-03_JPRB,1.3181E-03_JPRB,1.2951E-03_JPRB/)
KBO( :, 3,37, 5) = (/&
&8.6362E-05_JPRB,7.7917E-04_JPRB,1.1314E-03_JPRB,1.3641E-03_JPRB,1.2877E-03_JPRB/)
KBO( :, 4,37, 5) = (/&
&1.1309E-04_JPRB,8.4913E-04_JPRB,1.1999E-03_JPRB,1.4118E-03_JPRB,1.2757E-03_JPRB/)
KBO( :, 5,37, 5) = (/&
&1.4475E-04_JPRB,9.2097E-04_JPRB,1.2698E-03_JPRB,1.4619E-03_JPRB,1.2601E-03_JPRB/)
KBO( :, 1,38, 5) = (/&
&3.6723E-05_JPRB,5.3005E-04_JPRB,8.2089E-04_JPRB,1.0406E-03_JPRB,1.0656E-03_JPRB/)
KBO( :, 2,38, 5) = (/&
&5.0809E-05_JPRB,5.8160E-04_JPRB,8.7173E-04_JPRB,1.0802E-03_JPRB,1.0654E-03_JPRB/)
KBO( :, 3,38, 5) = (/&
&6.8411E-05_JPRB,6.3671E-04_JPRB,9.2702E-04_JPRB,1.1191E-03_JPRB,1.0602E-03_JPRB/)
KBO( :, 4,38, 5) = (/&
&8.9837E-05_JPRB,6.9447E-04_JPRB,9.8469E-04_JPRB,1.1603E-03_JPRB,1.0517E-03_JPRB/)
KBO( :, 5,38, 5) = (/&
&1.1531E-04_JPRB,7.5325E-04_JPRB,1.0431E-03_JPRB,1.2032E-03_JPRB,1.0398E-03_JPRB/)
KBO( :, 1,39, 5) = (/&
&2.8898E-05_JPRB,4.3158E-04_JPRB,6.7024E-04_JPRB,8.5167E-04_JPRB,8.7586E-04_JPRB/)
KBO( :, 2,39, 5) = (/&
&4.0107E-05_JPRB,4.7450E-04_JPRB,7.1291E-04_JPRB,8.8507E-04_JPRB,8.7670E-04_JPRB/)
KBO( :, 3,39, 5) = (/&
&5.4168E-05_JPRB,5.2021E-04_JPRB,7.5961E-04_JPRB,9.1815E-04_JPRB,8.7354E-04_JPRB/)
KBO( :, 4,39, 5) = (/&
&7.1354E-05_JPRB,5.6789E-04_JPRB,8.0816E-04_JPRB,9.5425E-04_JPRB,8.6787E-04_JPRB/)
KBO( :, 5,39, 5) = (/&
&9.1825E-05_JPRB,6.1595E-04_JPRB,8.5693E-04_JPRB,9.9080E-04_JPRB,8.5879E-04_JPRB/)
KBO( :, 1,40, 5) = (/&
&2.1926E-05_JPRB,3.4792E-04_JPRB,5.4363E-04_JPRB,6.9406E-04_JPRB,7.1842E-04_JPRB/)
KBO( :, 2,40, 5) = (/&
&3.0613E-05_JPRB,3.8334E-04_JPRB,5.7923E-04_JPRB,7.2214E-04_JPRB,7.2011E-04_JPRB/)
KBO( :, 3,40, 5) = (/&
&4.1595E-05_JPRB,4.2107E-04_JPRB,6.1835E-04_JPRB,7.5061E-04_JPRB,7.1871E-04_JPRB/)
KBO( :, 4,40, 5) = (/&
&5.5108E-05_JPRB,4.6016E-04_JPRB,6.5893E-04_JPRB,7.8109E-04_JPRB,7.1463E-04_JPRB/)
KBO( :, 5,40, 5) = (/&
&7.1275E-05_JPRB,4.9940E-04_JPRB,6.9980E-04_JPRB,8.1264E-04_JPRB,7.0800E-04_JPRB/)
KBO( :, 1,41, 5) = (/&
&1.6527E-05_JPRB,2.7994E-04_JPRB,4.4041E-04_JPRB,5.6504E-04_JPRB,5.8892E-04_JPRB/)
KBO( :, 2,41, 5) = (/&
&2.3240E-05_JPRB,3.0917E-04_JPRB,4.7005E-04_JPRB,5.8887E-04_JPRB,5.9140E-04_JPRB/)
KBO( :, 3,41, 5) = (/&
&3.1779E-05_JPRB,3.4025E-04_JPRB,5.0274E-04_JPRB,6.1295E-04_JPRB,5.9095E-04_JPRB/)
KBO( :, 4,41, 5) = (/&
&4.2345E-05_JPRB,3.7229E-04_JPRB,5.3669E-04_JPRB,6.3912E-04_JPRB,5.8845E-04_JPRB/)
KBO( :, 5,41, 5) = (/&
&5.5088E-05_JPRB,4.0429E-04_JPRB,5.7085E-04_JPRB,6.6587E-04_JPRB,5.8356E-04_JPRB/)
KBO( :, 1,42, 5) = (/&
&1.2429E-05_JPRB,2.2514E-04_JPRB,3.5666E-04_JPRB,4.5978E-04_JPRB,4.8268E-04_JPRB/)
KBO( :, 2,42, 5) = (/&
&1.7617E-05_JPRB,2.4922E-04_JPRB,3.8130E-04_JPRB,4.8000E-04_JPRB,4.8554E-04_JPRB/)
KBO( :, 3,42, 5) = (/&
&2.4234E-05_JPRB,2.7477E-04_JPRB,4.0862E-04_JPRB,5.0042E-04_JPRB,4.8593E-04_JPRB/)
KBO( :, 4,42, 5) = (/&
&3.2488E-05_JPRB,3.0100E-04_JPRB,4.3706E-04_JPRB,5.2275E-04_JPRB,4.8456E-04_JPRB/)
KBO( :, 5,42, 5) = (/&
&4.2516E-05_JPRB,3.2713E-04_JPRB,4.6549E-04_JPRB,5.4559E-04_JPRB,4.8115E-04_JPRB/)
KBO( :, 1,43, 5) = (/&
&9.1288E-06_JPRB,1.7990E-04_JPRB,2.8763E-04_JPRB,3.7307E-04_JPRB,3.9529E-04_JPRB/)
KBO( :, 2,43, 5) = (/&
&1.3070E-05_JPRB,1.9955E-04_JPRB,3.0790E-04_JPRB,3.8997E-04_JPRB,3.9826E-04_JPRB/)
KBO( :, 3,43, 5) = (/&
&1.8123E-05_JPRB,2.2051E-04_JPRB,3.3057E-04_JPRB,4.0731E-04_JPRB,3.9935E-04_JPRB/)
KBO( :, 4,43, 5) = (/&
&2.4489E-05_JPRB,2.4201E-04_JPRB,3.5433E-04_JPRB,4.2614E-04_JPRB,3.9876E-04_JPRB/)
KBO( :, 5,43, 5) = (/&
&3.2280E-05_JPRB,2.6336E-04_JPRB,3.7813E-04_JPRB,4.4577E-04_JPRB,3.9669E-04_JPRB/)
KBO( :, 1,44, 5) = (/&
&6.6151E-06_JPRB,1.4326E-04_JPRB,2.3138E-04_JPRB,3.0204E-04_JPRB,3.2336E-04_JPRB/)
KBO( :, 2,44, 5) = (/&
&9.5822E-06_JPRB,1.5927E-04_JPRB,2.4809E-04_JPRB,3.1644E-04_JPRB,3.2651E-04_JPRB/)
KBO( :, 3,44, 5) = (/&
&1.3410E-05_JPRB,1.7639E-04_JPRB,2.6682E-04_JPRB,3.3096E-04_JPRB,3.2809E-04_JPRB/)
KBO( :, 4,44, 5) = (/&
&1.8276E-05_JPRB,1.9397E-04_JPRB,2.8664E-04_JPRB,3.4697E-04_JPRB,3.2823E-04_JPRB/)
KBO( :, 5,44, 5) = (/&
&2.4286E-05_JPRB,2.1151E-04_JPRB,3.0643E-04_JPRB,3.6349E-04_JPRB,3.2698E-04_JPRB/)
KBO( :, 1,45, 5) = (/&
&4.7734E-06_JPRB,1.1403E-04_JPRB,1.8604E-04_JPRB,2.4442E-04_JPRB,2.6449E-04_JPRB/)
KBO( :, 2,45, 5) = (/&
&6.9996E-06_JPRB,1.2693E-04_JPRB,1.9973E-04_JPRB,2.5644E-04_JPRB,2.6762E-04_JPRB/)
KBO( :, 3,45, 5) = (/&
&9.8982E-06_JPRB,1.4091E-04_JPRB,2.1513E-04_JPRB,2.6865E-04_JPRB,2.6944E-04_JPRB/)
KBO( :, 4,45, 5) = (/&
&1.3603E-05_JPRB,1.5533E-04_JPRB,2.3165E-04_JPRB,2.8211E-04_JPRB,2.7010E-04_JPRB/)
KBO( :, 5,45, 5) = (/&
&1.8224E-05_JPRB,1.6976E-04_JPRB,2.4816E-04_JPRB,2.9621E-04_JPRB,2.6963E-04_JPRB/)
KBO( :, 1,46, 5) = (/&
&3.3983E-06_JPRB,9.0473E-05_JPRB,1.4921E-04_JPRB,1.9732E-04_JPRB,2.1604E-04_JPRB/)
KBO( :, 2,46, 5) = (/&
&5.0514E-06_JPRB,1.0084E-04_JPRB,1.6045E-04_JPRB,2.0752E-04_JPRB,2.1916E-04_JPRB/)
KBO( :, 3,46, 5) = (/&
&7.2271E-06_JPRB,1.1223E-04_JPRB,1.7305E-04_JPRB,2.1775E-04_JPRB,2.2117E-04_JPRB/)
KBO( :, 4,46, 5) = (/&
&1.0026E-05_JPRB,1.2405E-04_JPRB,1.8678E-04_JPRB,2.2906E-04_JPRB,2.2224E-04_JPRB/)
KBO( :, 5,46, 5) = (/&
&1.3554E-05_JPRB,1.3592E-04_JPRB,2.0050E-04_JPRB,2.4099E-04_JPRB,2.2226E-04_JPRB/)
KBO( :, 1,47, 5) = (/&
&2.3650E-06_JPRB,7.1417E-05_JPRB,1.1919E-04_JPRB,1.5882E-04_JPRB,1.7611E-04_JPRB/)
KBO( :, 2,47, 5) = (/&
&3.5679E-06_JPRB,7.9650E-05_JPRB,1.2838E-04_JPRB,1.6748E-04_JPRB,1.7919E-04_JPRB/)
KBO( :, 3,47, 5) = (/&
&5.1778E-06_JPRB,8.8892E-05_JPRB,1.3863E-04_JPRB,1.7599E-04_JPRB,1.8128E-04_JPRB/)
KBO( :, 4,47, 5) = (/&
&7.2636E-06_JPRB,9.8532E-05_JPRB,1.4995E-04_JPRB,1.8532E-04_JPRB,1.8257E-04_JPRB/)
KBO( :, 5,47, 5) = (/&
&9.9200E-06_JPRB,1.0829E-04_JPRB,1.6134E-04_JPRB,1.9543E-04_JPRB,1.8296E-04_JPRB/)
KBO( :, 1,48, 5) = (/&
&1.6346E-06_JPRB,5.6335E-05_JPRB,9.5109E-05_JPRB,1.2769E-04_JPRB,1.4342E-04_JPRB/)
KBO( :, 2,48, 5) = (/&
&2.5038E-06_JPRB,6.2854E-05_JPRB,1.0261E-04_JPRB,1.3493E-04_JPRB,1.4636E-04_JPRB/)
KBO( :, 3,48, 5) = (/&
&3.6896E-06_JPRB,7.0296E-05_JPRB,1.1094E-04_JPRB,1.4209E-04_JPRB,1.4851E-04_JPRB/)
KBO( :, 4,48, 5) = (/&
&5.2406E-06_JPRB,7.8146E-05_JPRB,1.2020E-04_JPRB,1.4978E-04_JPRB,1.4992E-04_JPRB/)
KBO( :, 5,48, 5) = (/&
&7.2291E-06_JPRB,8.6170E-05_JPRB,1.2966E-04_JPRB,1.5832E-04_JPRB,1.5064E-04_JPRB/)
KBO( :, 1,49, 5) = (/&
&1.1213E-06_JPRB,4.4399E-05_JPRB,7.5829E-05_JPRB,1.0254E-04_JPRB,1.1671E-04_JPRB/)
KBO( :, 2,49, 5) = (/&
&1.7465E-06_JPRB,4.9565E-05_JPRB,8.1954E-05_JPRB,1.0863E-04_JPRB,1.1954E-04_JPRB/)
KBO( :, 3,49, 5) = (/&
&2.6146E-06_JPRB,5.5485E-05_JPRB,8.8647E-05_JPRB,1.1460E-04_JPRB,1.2164E-04_JPRB/)
KBO( :, 4,49, 5) = (/&
&3.7631E-06_JPRB,6.1900E-05_JPRB,9.6246E-05_JPRB,1.2097E-04_JPRB,1.2315E-04_JPRB/)
KBO( :, 5,49, 5) = (/&
&5.2478E-06_JPRB,6.8486E-05_JPRB,1.0411E-04_JPRB,1.2810E-04_JPRB,1.2412E-04_JPRB/)
KBO( :, 1,50, 5) = (/&
&7.7219E-07_JPRB,3.5060E-05_JPRB,6.0501E-05_JPRB,8.2333E-05_JPRB,9.4799E-05_JPRB/)
KBO( :, 2,50, 5) = (/&
&1.2243E-06_JPRB,3.9171E-05_JPRB,6.5508E-05_JPRB,8.7444E-05_JPRB,9.7433E-05_JPRB/)
KBO( :, 3,50, 5) = (/&
&1.8601E-06_JPRB,4.3898E-05_JPRB,7.0971E-05_JPRB,9.2481E-05_JPRB,9.9443E-05_JPRB/)
KBO( :, 4,50, 5) = (/&
&2.7138E-06_JPRB,4.9113E-05_JPRB,7.7142E-05_JPRB,9.7774E-05_JPRB,1.0093E-04_JPRB/)
KBO( :, 5,50, 5) = (/&
&3.8270E-06_JPRB,5.4504E-05_JPRB,8.3666E-05_JPRB,1.0372E-04_JPRB,1.0197E-04_JPRB/)
KBO( :, 1,51, 5) = (/&
&5.3024E-07_JPRB,2.7696E-05_JPRB,4.8261E-05_JPRB,6.6083E-05_JPRB,7.6892E-05_JPRB/)
KBO( :, 2,51, 5) = (/&
&8.5735E-07_JPRB,3.0983E-05_JPRB,5.2368E-05_JPRB,7.0412E-05_JPRB,7.9289E-05_JPRB/)
KBO( :, 3,51, 5) = (/&
&1.3218E-06_JPRB,3.4738E-05_JPRB,5.6824E-05_JPRB,7.4609E-05_JPRB,8.1180E-05_JPRB/)
KBO( :, 4,51, 5) = (/&
&1.9559E-06_JPRB,3.8961E-05_JPRB,6.1833E-05_JPRB,7.8998E-05_JPRB,8.2596E-05_JPRB/)
KBO( :, 5,51, 5) = (/&
&2.7897E-06_JPRB,4.3372E-05_JPRB,6.7221E-05_JPRB,8.3927E-05_JPRB,8.3636E-05_JPRB/)
KBO( :, 1,52, 5) = (/&
&3.6108E-07_JPRB,2.1866E-05_JPRB,3.8454E-05_JPRB,5.2969E-05_JPRB,6.2335E-05_JPRB/)
KBO( :, 2,52, 5) = (/&
&5.9667E-07_JPRB,2.4493E-05_JPRB,4.1837E-05_JPRB,5.6625E-05_JPRB,6.4483E-05_JPRB/)
KBO( :, 3,52, 5) = (/&
&9.3484E-07_JPRB,2.7465E-05_JPRB,4.5448E-05_JPRB,6.0126E-05_JPRB,6.6246E-05_JPRB/)
KBO( :, 4,52, 5) = (/&
&1.4036E-06_JPRB,3.0877E-05_JPRB,4.9517E-05_JPRB,6.3789E-05_JPRB,6.7578E-05_JPRB/)
KBO( :, 5,52, 5) = (/&
&2.0268E-06_JPRB,3.4479E-05_JPRB,5.3935E-05_JPRB,6.7855E-05_JPRB,6.8602E-05_JPRB/)
KBO( :, 1,53, 5) = (/&
&2.4332E-07_JPRB,1.7244E-05_JPRB,3.0597E-05_JPRB,4.2405E-05_JPRB,5.0498E-05_JPRB/)
KBO( :, 2,53, 5) = (/&
&4.1214E-07_JPRB,1.9345E-05_JPRB,3.3390E-05_JPRB,4.5480E-05_JPRB,5.2422E-05_JPRB/)
KBO( :, 3,53, 5) = (/&
&6.5730E-07_JPRB,2.1709E-05_JPRB,3.6329E-05_JPRB,4.8415E-05_JPRB,5.4043E-05_JPRB/)
KBO( :, 4,53, 5) = (/&
&1.0016E-06_JPRB,2.4434E-05_JPRB,3.9600E-05_JPRB,5.1439E-05_JPRB,5.5301E-05_JPRB/)
KBO( :, 5,53, 5) = (/&
&1.4656E-06_JPRB,2.7368E-05_JPRB,4.3227E-05_JPRB,5.4790E-05_JPRB,5.6292E-05_JPRB/)
KBO( :, 1,54, 5) = (/&
&1.6511E-07_JPRB,1.3630E-05_JPRB,2.4378E-05_JPRB,3.3979E-05_JPRB,4.0794E-05_JPRB/)
KBO( :, 2,54, 5) = (/&
&2.8688E-07_JPRB,1.5326E-05_JPRB,2.6694E-05_JPRB,3.6556E-05_JPRB,4.2472E-05_JPRB/)
KBO( :, 3,54, 5) = (/&
&4.6588E-07_JPRB,1.7208E-05_JPRB,2.9089E-05_JPRB,3.9026E-05_JPRB,4.3891E-05_JPRB/)
KBO( :, 4,54, 5) = (/&
&7.2012E-07_JPRB,1.9389E-05_JPRB,3.1742E-05_JPRB,4.1533E-05_JPRB,4.5023E-05_JPRB/)
KBO( :, 5,54, 5) = (/&
&1.0672E-06_JPRB,2.1776E-05_JPRB,3.4708E-05_JPRB,4.4305E-05_JPRB,4.5917E-05_JPRB/)
KBO( :, 1,55, 5) = (/&
&1.1192E-07_JPRB,1.0784E-05_JPRB,1.9433E-05_JPRB,2.7227E-05_JPRB,3.2881E-05_JPRB/)
KBO( :, 2,55, 5) = (/&
&1.9966E-07_JPRB,1.2152E-05_JPRB,2.1341E-05_JPRB,2.9385E-05_JPRB,3.4331E-05_JPRB/)
KBO( :, 3,55, 5) = (/&
&3.3052E-07_JPRB,1.3654E-05_JPRB,2.3300E-05_JPRB,3.1458E-05_JPRB,3.5546E-05_JPRB/)
KBO( :, 4,55, 5) = (/&
&5.1840E-07_JPRB,1.5395E-05_JPRB,2.5450E-05_JPRB,3.3531E-05_JPRB,3.6538E-05_JPRB/)
KBO( :, 5,55, 5) = (/&
&7.7808E-07_JPRB,1.7333E-05_JPRB,2.7868E-05_JPRB,3.5813E-05_JPRB,3.7304E-05_JPRB/)
KBO( :, 1,56, 5) = (/&
&7.5122E-08_JPRB,8.5244E-06_JPRB,1.5477E-05_JPRB,2.1786E-05_JPRB,2.6473E-05_JPRB/)
KBO( :, 2,56, 5) = (/&
&1.3800E-07_JPRB,9.6271E-06_JPRB,1.7041E-05_JPRB,2.3587E-05_JPRB,2.7734E-05_JPRB/)
KBO( :, 3,56, 5) = (/&
&2.3328E-07_JPRB,1.0832E-05_JPRB,1.8654E-05_JPRB,2.5333E-05_JPRB,2.8773E-05_JPRB/)
KBO( :, 4,56, 5) = (/&
&3.7175E-07_JPRB,1.2217E-05_JPRB,2.0395E-05_JPRB,2.7050E-05_JPRB,2.9637E-05_JPRB/)
KBO( :, 5,56, 5) = (/&
&5.6529E-07_JPRB,1.3785E-05_JPRB,2.2358E-05_JPRB,2.8934E-05_JPRB,3.0300E-05_JPRB/)
KBO( :, 1,57, 5) = (/&
&4.9911E-08_JPRB,6.7334E-06_JPRB,1.2315E-05_JPRB,1.7411E-05_JPRB,2.1292E-05_JPRB/)
KBO( :, 2,57, 5) = (/&
&9.4564E-08_JPRB,7.6208E-06_JPRB,1.3595E-05_JPRB,1.8912E-05_JPRB,2.2387E-05_JPRB/)
KBO( :, 3,57, 5) = (/&
&1.6361E-07_JPRB,8.5900E-06_JPRB,1.4922E-05_JPRB,2.0379E-05_JPRB,2.3279E-05_JPRB/)
KBO( :, 4,57, 5) = (/&
&2.6533E-07_JPRB,9.6896E-06_JPRB,1.6333E-05_JPRB,2.1806E-05_JPRB,2.4024E-05_JPRB/)
KBO( :, 5,57, 5) = (/&
&4.0896E-07_JPRB,1.0955E-05_JPRB,1.7923E-05_JPRB,2.3357E-05_JPRB,2.4605E-05_JPRB/)
KBO( :, 1,58, 5) = (/&
&3.3413E-08_JPRB,5.3223E-06_JPRB,9.7997E-06_JPRB,1.3911E-05_JPRB,1.7115E-05_JPRB/)
KBO( :, 2,58, 5) = (/&
&6.4876E-08_JPRB,6.0389E-06_JPRB,1.0850E-05_JPRB,1.5164E-05_JPRB,1.8057E-05_JPRB/)
KBO( :, 3,58, 5) = (/&
&1.1501E-07_JPRB,6.8202E-06_JPRB,1.1942E-05_JPRB,1.6396E-05_JPRB,1.8824E-05_JPRB/)
KBO( :, 4,58, 5) = (/&
&1.8988E-07_JPRB,7.6962E-06_JPRB,1.3093E-05_JPRB,1.7589E-05_JPRB,1.9461E-05_JPRB/)
KBO( :, 5,58, 5) = (/&
&2.9670E-07_JPRB,8.7155E-06_JPRB,1.4378E-05_JPRB,1.8862E-05_JPRB,1.9967E-05_JPRB/)
KBO( :, 1,59, 5) = (/&
&2.5326E-08_JPRB,4.3059E-06_JPRB,7.9479E-06_JPRB,1.1296E-05_JPRB,1.3872E-05_JPRB/)
KBO( :, 2,59, 5) = (/&
&4.9570E-08_JPRB,4.8933E-06_JPRB,8.8138E-06_JPRB,1.2338E-05_JPRB,1.4642E-05_JPRB/)
KBO( :, 3,59, 5) = (/&
&8.8759E-08_JPRB,5.5323E-06_JPRB,9.7147E-06_JPRB,1.3360E-05_JPRB,1.5267E-05_JPRB/)
KBO( :, 4,59, 5) = (/&
&1.4767E-07_JPRB,6.2484E-06_JPRB,1.0666E-05_JPRB,1.4358E-05_JPRB,1.5775E-05_JPRB/)
KBO( :, 5,59, 5) = (/&
&2.3207E-07_JPRB,7.0847E-06_JPRB,1.1728E-05_JPRB,1.5422E-05_JPRB,1.6178E-05_JPRB/)
KBO( :, 1,13, 6) = (/&
&2.6469E-03_JPRB,7.2603E-02_JPRB,1.2898E-01_JPRB,1.8080E-01_JPRB,2.2253E-01_JPRB/)
KBO( :, 2,13, 6) = (/&
&4.0410E-03_JPRB,7.8062E-02_JPRB,1.3546E-01_JPRB,1.8736E-01_JPRB,2.2767E-01_JPRB/)
KBO( :, 3,13, 6) = (/&
&5.9076E-03_JPRB,8.4142E-02_JPRB,1.4233E-01_JPRB,1.9380E-01_JPRB,2.3269E-01_JPRB/)
KBO( :, 4,13, 6) = (/&
&8.3159E-03_JPRB,9.0550E-02_JPRB,1.4952E-01_JPRB,2.0027E-01_JPRB,2.3737E-01_JPRB/)
KBO( :, 5,13, 6) = (/&
&1.1338E-02_JPRB,9.6973E-02_JPRB,1.5692E-01_JPRB,2.0664E-01_JPRB,2.4174E-01_JPRB/)
KBO( :, 1,14, 6) = (/&
&2.3459E-03_JPRB,6.5146E-02_JPRB,1.1561E-01_JPRB,1.6205E-01_JPRB,1.9813E-01_JPRB/)
KBO( :, 2,14, 6) = (/&
&3.5742E-03_JPRB,7.0309E-02_JPRB,1.2183E-01_JPRB,1.6837E-01_JPRB,2.0310E-01_JPRB/)
KBO( :, 3,14, 6) = (/&
&5.2156E-03_JPRB,7.5953E-02_JPRB,1.2830E-01_JPRB,1.7462E-01_JPRB,2.0779E-01_JPRB/)
KBO( :, 4,14, 6) = (/&
&7.3297E-03_JPRB,8.1768E-02_JPRB,1.3506E-01_JPRB,1.8090E-01_JPRB,2.1206E-01_JPRB/)
KBO( :, 5,14, 6) = (/&
&9.9793E-03_JPRB,8.7785E-02_JPRB,1.4192E-01_JPRB,1.8688E-01_JPRB,2.1597E-01_JPRB/)
KBO( :, 1,15, 6) = (/&
&2.0815E-03_JPRB,5.8070E-02_JPRB,1.0290E-01_JPRB,1.4403E-01_JPRB,1.7518E-01_JPRB/)
KBO( :, 2,15, 6) = (/&
&3.1616E-03_JPRB,6.2877E-02_JPRB,1.0871E-01_JPRB,1.5003E-01_JPRB,1.7983E-01_JPRB/)
KBO( :, 3,15, 6) = (/&
&4.5990E-03_JPRB,6.8034E-02_JPRB,1.1474E-01_JPRB,1.5600E-01_JPRB,1.8413E-01_JPRB/)
KBO( :, 4,15, 6) = (/&
&6.4457E-03_JPRB,7.3357E-02_JPRB,1.2094E-01_JPRB,1.6184E-01_JPRB,1.8811E-01_JPRB/)
KBO( :, 5,15, 6) = (/&
&8.7688E-03_JPRB,7.8954E-02_JPRB,1.2718E-01_JPRB,1.6743E-01_JPRB,1.9184E-01_JPRB/)
KBO( :, 1,16, 6) = (/&
&1.8434E-03_JPRB,5.1431E-02_JPRB,9.0904E-02_JPRB,1.2695E-01_JPRB,1.5373E-01_JPRB/)
KBO( :, 2,16, 6) = (/&
&2.7883E-03_JPRB,5.5853E-02_JPRB,9.6202E-02_JPRB,1.3255E-01_JPRB,1.5805E-01_JPRB/)
KBO( :, 3,16, 6) = (/&
&4.0405E-03_JPRB,6.0484E-02_JPRB,1.0174E-01_JPRB,1.3809E-01_JPRB,1.6209E-01_JPRB/)
KBO( :, 4,16, 6) = (/&
&5.6545E-03_JPRB,6.5388E-02_JPRB,1.0742E-01_JPRB,1.4346E-01_JPRB,1.6594E-01_JPRB/)
KBO( :, 5,16, 6) = (/&
&7.6948E-03_JPRB,7.0557E-02_JPRB,1.1317E-01_JPRB,1.4876E-01_JPRB,1.6944E-01_JPRB/)
KBO( :, 1,17, 6) = (/&
&1.6228E-03_JPRB,4.5214E-02_JPRB,7.9628E-02_JPRB,1.1095E-01_JPRB,1.3382E-01_JPRB/)
KBO( :, 2,17, 6) = (/&
&2.4444E-03_JPRB,4.9201E-02_JPRB,8.4449E-02_JPRB,1.1610E-01_JPRB,1.3782E-01_JPRB/)
KBO( :, 3,17, 6) = (/&
&3.5341E-03_JPRB,5.3403E-02_JPRB,8.9520E-02_JPRB,1.2115E-01_JPRB,1.4166E-01_JPRB/)
KBO( :, 4,17, 6) = (/&
&4.9442E-03_JPRB,5.7899E-02_JPRB,9.4657E-02_JPRB,1.2610E-01_JPRB,1.4516E-01_JPRB/)
KBO( :, 5,17, 6) = (/&
&6.7314E-03_JPRB,6.2605E-02_JPRB,9.9934E-02_JPRB,1.3078E-01_JPRB,1.4759E-01_JPRB/)
KBO( :, 1,18, 6) = (/&
&1.4215E-03_JPRB,3.9490E-02_JPRB,6.9231E-02_JPRB,9.6243E-02_JPRB,1.1568E-01_JPRB/)
KBO( :, 2,18, 6) = (/&
&2.1346E-03_JPRB,4.3045E-02_JPRB,7.3605E-02_JPRB,1.0089E-01_JPRB,1.1941E-01_JPRB/)
KBO( :, 3,18, 6) = (/&
&3.0824E-03_JPRB,4.6855E-02_JPRB,7.8190E-02_JPRB,1.0547E-01_JPRB,1.2277E-01_JPRB/)
KBO( :, 4,18, 6) = (/&
&4.3155E-03_JPRB,5.0887E-02_JPRB,8.2789E-02_JPRB,1.0966E-01_JPRB,1.2516E-01_JPRB/)
KBO( :, 5,18, 6) = (/&
&5.8773E-03_JPRB,5.5100E-02_JPRB,8.7246E-02_JPRB,1.1319E-01_JPRB,1.2607E-01_JPRB/)
KBO( :, 1,19, 6) = (/&
&1.2396E-03_JPRB,3.4273E-02_JPRB,5.9817E-02_JPRB,8.2935E-02_JPRB,9.9419E-02_JPRB/)
KBO( :, 2,19, 6) = (/&
&1.8580E-03_JPRB,3.7439E-02_JPRB,6.3787E-02_JPRB,8.7073E-02_JPRB,1.0261E-01_JPRB/)
KBO( :, 3,19, 6) = (/&
&2.6842E-03_JPRB,4.0827E-02_JPRB,6.7738E-02_JPRB,9.0822E-02_JPRB,1.0491E-01_JPRB/)
KBO( :, 4,19, 6) = (/&
&3.7596E-03_JPRB,4.4308E-02_JPRB,7.1517E-02_JPRB,9.3932E-02_JPRB,1.0593E-01_JPRB/)
KBO( :, 5,19, 6) = (/&
&5.1106E-03_JPRB,4.7901E-02_JPRB,7.4978E-02_JPRB,9.6351E-02_JPRB,1.0588E-01_JPRB/)
KBO( :, 1,20, 6) = (/&
&1.0863E-03_JPRB,2.9636E-02_JPRB,5.1506E-02_JPRB,7.1094E-02_JPRB,8.4913E-02_JPRB/)
KBO( :, 2,20, 6) = (/&
&1.6251E-03_JPRB,3.2413E-02_JPRB,5.4873E-02_JPRB,7.4436E-02_JPRB,8.7129E-02_JPRB/)
KBO( :, 3,20, 6) = (/&
&2.3482E-03_JPRB,3.5255E-02_JPRB,5.8051E-02_JPRB,7.7198E-02_JPRB,8.8290E-02_JPRB/)
KBO( :, 4,20, 6) = (/&
&3.2830E-03_JPRB,3.8154E-02_JPRB,6.0963E-02_JPRB,7.9391E-02_JPRB,8.8534E-02_JPRB/)
KBO( :, 5,20, 6) = (/&
&4.4496E-03_JPRB,4.1105E-02_JPRB,6.3670E-02_JPRB,8.1212E-02_JPRB,8.8096E-02_JPRB/)
KBO( :, 1,21, 6) = (/&
&9.5155E-04_JPRB,2.5477E-02_JPRB,4.4023E-02_JPRB,6.0405E-02_JPRB,7.1745E-02_JPRB/)
KBO( :, 2,21, 6) = (/&
&1.4227E-03_JPRB,2.7779E-02_JPRB,4.6702E-02_JPRB,6.2887E-02_JPRB,7.3006E-02_JPRB/)
KBO( :, 3,21, 6) = (/&
&2.0513E-03_JPRB,3.0099E-02_JPRB,4.9167E-02_JPRB,6.4894E-02_JPRB,7.3521E-02_JPRB/)
KBO( :, 4,21, 6) = (/&
&2.8588E-03_JPRB,3.2465E-02_JPRB,5.1448E-02_JPRB,6.6586E-02_JPRB,7.3416E-02_JPRB/)
KBO( :, 5,21, 6) = (/&
&3.8612E-03_JPRB,3.4927E-02_JPRB,5.3670E-02_JPRB,6.8026E-02_JPRB,7.2850E-02_JPRB/)
KBO( :, 1,22, 6) = (/&
&8.5713E-04_JPRB,2.1832E-02_JPRB,3.7420E-02_JPRB,5.0944E-02_JPRB,6.0002E-02_JPRB/)
KBO( :, 2,22, 6) = (/&
&1.2758E-03_JPRB,2.3688E-02_JPRB,3.9495E-02_JPRB,5.2772E-02_JPRB,6.0672E-02_JPRB/)
KBO( :, 3,22, 6) = (/&
&1.8291E-03_JPRB,2.5590E-02_JPRB,4.1428E-02_JPRB,5.4322E-02_JPRB,6.0829E-02_JPRB/)
KBO( :, 4,22, 6) = (/&
&2.5337E-03_JPRB,2.7556E-02_JPRB,4.3286E-02_JPRB,5.5664E-02_JPRB,6.0555E-02_JPRB/)
KBO( :, 5,22, 6) = (/&
&3.4060E-03_JPRB,2.9653E-02_JPRB,4.5131E-02_JPRB,5.6799E-02_JPRB,5.9942E-02_JPRB/)
KBO( :, 1,23, 6) = (/&
&7.7308E-04_JPRB,1.8541E-02_JPRB,3.1541E-02_JPRB,4.2653E-02_JPRB,4.9784E-02_JPRB/)
KBO( :, 2,23, 6) = (/&
&1.1436E-03_JPRB,2.0060E-02_JPRB,3.3177E-02_JPRB,4.4071E-02_JPRB,5.0135E-02_JPRB/)
KBO( :, 3,23, 6) = (/&
&1.6287E-03_JPRB,2.1636E-02_JPRB,3.4743E-02_JPRB,4.5309E-02_JPRB,5.0108E-02_JPRB/)
KBO( :, 4,23, 6) = (/&
&2.2433E-03_JPRB,2.3301E-02_JPRB,3.6276E-02_JPRB,4.6369E-02_JPRB,4.9769E-02_JPRB/)
KBO( :, 5,23, 6) = (/&
&3.0015E-03_JPRB,2.5093E-02_JPRB,3.7820E-02_JPRB,4.7284E-02_JPRB,4.9161E-02_JPRB/)
KBO( :, 1,24, 6) = (/&
&6.9820E-04_JPRB,1.5662E-02_JPRB,2.6451E-02_JPRB,3.5569E-02_JPRB,4.1103E-02_JPRB/)
KBO( :, 2,24, 6) = (/&
&1.0252E-03_JPRB,1.6916E-02_JPRB,2.7766E-02_JPRB,3.6705E-02_JPRB,4.1269E-02_JPRB/)
KBO( :, 3,24, 6) = (/&
&1.4503E-03_JPRB,1.8243E-02_JPRB,2.9050E-02_JPRB,3.7680E-02_JPRB,4.1148E-02_JPRB/)
KBO( :, 4,24, 6) = (/&
&1.9860E-03_JPRB,1.9665E-02_JPRB,3.0328E-02_JPRB,3.8530E-02_JPRB,4.0787E-02_JPRB/)
KBO( :, 5,24, 6) = (/&
&2.6469E-03_JPRB,2.1188E-02_JPRB,3.1637E-02_JPRB,3.9277E-02_JPRB,4.0220E-02_JPRB/)
KBO( :, 1,25, 6) = (/&
&6.3170E-04_JPRB,1.3191E-02_JPRB,2.2113E-02_JPRB,2.9594E-02_JPRB,3.3832E-02_JPRB/)
KBO( :, 2,25, 6) = (/&
&9.2001E-04_JPRB,1.4240E-02_JPRB,2.3188E-02_JPRB,3.0496E-02_JPRB,3.3883E-02_JPRB/)
KBO( :, 3,25, 6) = (/&
&1.2928E-03_JPRB,1.5370E-02_JPRB,2.4249E-02_JPRB,3.1273E-02_JPRB,3.3716E-02_JPRB/)
KBO( :, 4,25, 6) = (/&
&1.7603E-03_JPRB,1.6573E-02_JPRB,2.5329E-02_JPRB,3.1960E-02_JPRB,3.3363E-02_JPRB/)
KBO( :, 5,25, 6) = (/&
&2.3402E-03_JPRB,1.7869E-02_JPRB,2.6443E-02_JPRB,3.2590E-02_JPRB,3.2859E-02_JPRB/)
KBO( :, 1,26, 6) = (/&
&5.7419E-04_JPRB,1.1097E-02_JPRB,1.8461E-02_JPRB,2.4587E-02_JPRB,2.7791E-02_JPRB/)
KBO( :, 2,26, 6) = (/&
&8.2924E-04_JPRB,1.1987E-02_JPRB,1.9343E-02_JPRB,2.5297E-02_JPRB,2.7770E-02_JPRB/)
KBO( :, 3,26, 6) = (/&
&1.1565E-03_JPRB,1.2945E-02_JPRB,2.0233E-02_JPRB,2.5928E-02_JPRB,2.7584E-02_JPRB/)
KBO( :, 4,26, 6) = (/&
&1.5683E-03_JPRB,1.3972E-02_JPRB,2.1156E-02_JPRB,2.6492E-02_JPRB,2.7256E-02_JPRB/)
KBO( :, 5,26, 6) = (/&
&2.0814E-03_JPRB,1.5076E-02_JPRB,2.2099E-02_JPRB,2.7036E-02_JPRB,2.6815E-02_JPRB/)
KBO( :, 1,27, 6) = (/&
&5.2085E-04_JPRB,9.3262E-03_JPRB,1.5390E-02_JPRB,2.0394E-02_JPRB,2.2795E-02_JPRB/)
KBO( :, 2,27, 6) = (/&
&7.4611E-04_JPRB,1.0083E-02_JPRB,1.6124E-02_JPRB,2.0964E-02_JPRB,2.2740E-02_JPRB/)
KBO( :, 3,27, 6) = (/&
&1.0345E-03_JPRB,1.0897E-02_JPRB,1.6882E-02_JPRB,2.1477E-02_JPRB,2.2550E-02_JPRB/)
KBO( :, 4,27, 6) = (/&
&1.3997E-03_JPRB,1.1774E-02_JPRB,1.7663E-02_JPRB,2.1954E-02_JPRB,2.2255E-02_JPRB/)
KBO( :, 5,27, 6) = (/&
&1.8540E-03_JPRB,1.2711E-02_JPRB,1.8466E-02_JPRB,2.2421E-02_JPRB,2.1874E-02_JPRB/)
KBO( :, 1,28, 6) = (/&
&4.7154E-04_JPRB,7.8350E-03_JPRB,1.2820E-02_JPRB,1.6898E-02_JPRB,1.8683E-02_JPRB/)
KBO( :, 2,28, 6) = (/&
&6.7041E-04_JPRB,8.4791E-03_JPRB,1.3441E-02_JPRB,1.7362E-02_JPRB,1.8606E-02_JPRB/)
KBO( :, 3,28, 6) = (/&
&9.2613E-04_JPRB,9.1729E-03_JPRB,1.4084E-02_JPRB,1.7787E-02_JPRB,1.8427E-02_JPRB/)
KBO( :, 4,28, 6) = (/&
&1.2511E-03_JPRB,9.9188E-03_JPRB,1.4746E-02_JPRB,1.8199E-02_JPRB,1.8168E-02_JPRB/)
KBO( :, 5,28, 6) = (/&
&1.6528E-03_JPRB,1.0715E-02_JPRB,1.5432E-02_JPRB,1.8597E-02_JPRB,1.7841E-02_JPRB/)
KBO( :, 1,29, 6) = (/&
&4.2728E-04_JPRB,6.5872E-03_JPRB,1.0682E-02_JPRB,1.3997E-02_JPRB,1.5306E-02_JPRB/)
KBO( :, 2,29, 6) = (/&
&6.0398E-04_JPRB,7.1366E-03_JPRB,1.1209E-02_JPRB,1.4377E-02_JPRB,1.5221E-02_JPRB/)
KBO( :, 3,29, 6) = (/&
&8.3275E-04_JPRB,7.7277E-03_JPRB,1.1754E-02_JPRB,1.4740E-02_JPRB,1.5060E-02_JPRB/)
KBO( :, 4,29, 6) = (/&
&1.1219E-03_JPRB,8.3625E-03_JPRB,1.2318E-02_JPRB,1.5088E-02_JPRB,1.4833E-02_JPRB/)
KBO( :, 5,29, 6) = (/&
&1.4752E-03_JPRB,9.0420E-03_JPRB,1.2902E-02_JPRB,1.5434E-02_JPRB,1.4555E-02_JPRB/)
KBO( :, 1,30, 6) = (/&
&3.8695E-04_JPRB,5.5390E-03_JPRB,8.9023E-03_JPRB,1.1592E-02_JPRB,1.2537E-02_JPRB/)
KBO( :, 2,30, 6) = (/&
&5.4519E-04_JPRB,6.0089E-03_JPRB,9.3487E-03_JPRB,1.1911E-02_JPRB,1.2451E-02_JPRB/)
KBO( :, 3,30, 6) = (/&
&7.4997E-04_JPRB,6.5118E-03_JPRB,9.8133E-03_JPRB,1.2219E-02_JPRB,1.2307E-02_JPRB/)
KBO( :, 4,30, 6) = (/&
&1.0057E-03_JPRB,7.0541E-03_JPRB,1.0293E-02_JPRB,1.2517E-02_JPRB,1.2111E-02_JPRB/)
KBO( :, 5,30, 6) = (/&
&1.3159E-03_JPRB,7.6360E-03_JPRB,1.0791E-02_JPRB,1.2813E-02_JPRB,1.1876E-02_JPRB/)
KBO( :, 1,31, 6) = (/&
&3.5135E-04_JPRB,4.6635E-03_JPRB,7.4241E-03_JPRB,9.6038E-03_JPRB,1.0269E-02_JPRB/)
KBO( :, 2,31, 6) = (/&
&4.9394E-04_JPRB,5.0642E-03_JPRB,7.8045E-03_JPRB,9.8736E-03_JPRB,1.0187E-02_JPRB/)
KBO( :, 3,31, 6) = (/&
&6.7641E-04_JPRB,5.4940E-03_JPRB,8.1988E-03_JPRB,1.0135E-02_JPRB,1.0061E-02_JPRB/)
KBO( :, 4,31, 6) = (/&
&9.0234E-04_JPRB,5.9565E-03_JPRB,8.6081E-03_JPRB,1.0392E-02_JPRB,9.8960E-03_JPRB/)
KBO( :, 5,31, 6) = (/&
&1.1742E-03_JPRB,6.4605E-03_JPRB,9.0359E-03_JPRB,1.0646E-02_JPRB,9.7006E-03_JPRB/)
KBO( :, 1,32, 6) = (/&
&3.2001E-04_JPRB,3.9308E-03_JPRB,6.1947E-03_JPRB,7.9626E-03_JPRB,8.4097E-03_JPRB/)
KBO( :, 2,32, 6) = (/&
&4.4829E-04_JPRB,4.2720E-03_JPRB,6.5203E-03_JPRB,8.1905E-03_JPRB,8.3364E-03_JPRB/)
KBO( :, 3,32, 6) = (/&
&6.1024E-04_JPRB,4.6387E-03_JPRB,6.8547E-03_JPRB,8.4122E-03_JPRB,8.2274E-03_JPRB/)
KBO( :, 4,32, 6) = (/&
&8.0906E-04_JPRB,5.0375E-03_JPRB,7.2071E-03_JPRB,8.6330E-03_JPRB,8.0902E-03_JPRB/)
KBO( :, 5,32, 6) = (/&
&1.0464E-03_JPRB,5.4823E-03_JPRB,7.5792E-03_JPRB,8.8523E-03_JPRB,7.9289E-03_JPRB/)
KBO( :, 1,33, 6) = (/&
&2.9187E-04_JPRB,3.3162E-03_JPRB,5.1759E-03_JPRB,6.6059E-03_JPRB,6.8900E-03_JPRB/)
KBO( :, 2,33, 6) = (/&
&4.0643E-04_JPRB,3.6075E-03_JPRB,5.4523E-03_JPRB,6.7980E-03_JPRB,6.8251E-03_JPRB/)
KBO( :, 3,33, 6) = (/&
&5.4996E-04_JPRB,3.9216E-03_JPRB,5.7391E-03_JPRB,6.9881E-03_JPRB,6.7331E-03_JPRB/)
KBO( :, 4,33, 6) = (/&
&7.2438E-04_JPRB,4.2703E-03_JPRB,6.0424E-03_JPRB,7.1762E-03_JPRB,6.6187E-03_JPRB/)
KBO( :, 5,33, 6) = (/&
&9.3060E-04_JPRB,4.6643E-03_JPRB,6.3702E-03_JPRB,7.3681E-03_JPRB,6.4878E-03_JPRB/)
KBO( :, 1,34, 6) = (/&
&2.6296E-04_JPRB,2.7910E-03_JPRB,4.3184E-03_JPRB,5.4761E-03_JPRB,5.6450E-03_JPRB/)
KBO( :, 2,34, 6) = (/&
&3.6417E-04_JPRB,3.0392E-03_JPRB,4.5551E-03_JPRB,5.6403E-03_JPRB,5.5898E-03_JPRB/)
KBO( :, 3,34, 6) = (/&
&4.8977E-04_JPRB,3.3104E-03_JPRB,4.8001E-03_JPRB,5.8026E-03_JPRB,5.5129E-03_JPRB/)
KBO( :, 4,34, 6) = (/&
&6.4109E-04_JPRB,3.6176E-03_JPRB,5.0649E-03_JPRB,5.9649E-03_JPRB,5.4188E-03_JPRB/)
KBO( :, 5,34, 6) = (/&
&8.1804E-04_JPRB,3.9621E-03_JPRB,5.3546E-03_JPRB,6.1354E-03_JPRB,5.3128E-03_JPRB/)
KBO( :, 1,35, 6) = (/&
&2.2910E-04_JPRB,2.3313E-03_JPRB,3.5886E-03_JPRB,4.5289E-03_JPRB,4.6300E-03_JPRB/)
KBO( :, 2,35, 6) = (/&
&3.1618E-04_JPRB,2.5413E-03_JPRB,3.7885E-03_JPRB,4.6696E-03_JPRB,4.5851E-03_JPRB/)
KBO( :, 3,35, 6) = (/&
&4.2365E-04_JPRB,2.7760E-03_JPRB,3.9992E-03_JPRB,4.8085E-03_JPRB,4.5223E-03_JPRB/)
KBO( :, 4,35, 6) = (/&
&5.5209E-04_JPRB,3.0435E-03_JPRB,4.2290E-03_JPRB,4.9499E-03_JPRB,4.4473E-03_JPRB/)
KBO( :, 5,35, 6) = (/&
&7.0126E-04_JPRB,3.3413E-03_JPRB,4.4858E-03_JPRB,5.1019E-03_JPRB,4.3622E-03_JPRB/)
KBO( :, 1,36, 6) = (/&
&1.9220E-04_JPRB,1.9293E-03_JPRB,2.9645E-03_JPRB,3.7347E-03_JPRB,3.8021E-03_JPRB/)
KBO( :, 2,36, 6) = (/&
&2.6515E-04_JPRB,2.1069E-03_JPRB,3.1345E-03_JPRB,3.8546E-03_JPRB,3.7663E-03_JPRB/)
KBO( :, 3,36, 6) = (/&
&3.5491E-04_JPRB,2.3084E-03_JPRB,3.3147E-03_JPRB,3.9746E-03_JPRB,3.7181E-03_JPRB/)
KBO( :, 4,36, 6) = (/&
&4.6148E-04_JPRB,2.5376E-03_JPRB,3.5142E-03_JPRB,4.0989E-03_JPRB,3.6590E-03_JPRB/)
KBO( :, 5,36, 6) = (/&
&5.8535E-04_JPRB,2.7911E-03_JPRB,3.7375E-03_JPRB,4.2333E-03_JPRB,3.5914E-03_JPRB/)
KBO( :, 1,37, 6) = (/&
&1.5305E-04_JPRB,1.5760E-03_JPRB,2.4302E-03_JPRB,3.0653E-03_JPRB,3.1247E-03_JPRB/)
KBO( :, 2,37, 6) = (/&
&2.1204E-04_JPRB,1.7239E-03_JPRB,2.5719E-03_JPRB,3.1677E-03_JPRB,3.0989E-03_JPRB/)
KBO( :, 3,37, 6) = (/&
&2.8465E-04_JPRB,1.8937E-03_JPRB,2.7243E-03_JPRB,3.2712E-03_JPRB,3.0625E-03_JPRB/)
KBO( :, 4,37, 6) = (/&
&3.7093E-04_JPRB,2.0863E-03_JPRB,2.8955E-03_JPRB,3.3791E-03_JPRB,3.0167E-03_JPRB/)
KBO( :, 5,37, 6) = (/&
&4.7146E-04_JPRB,2.2992E-03_JPRB,3.0865E-03_JPRB,3.4968E-03_JPRB,2.9640E-03_JPRB/)
KBO( :, 1,38, 6) = (/&
&1.2136E-04_JPRB,1.2859E-03_JPRB,1.9906E-03_JPRB,2.5150E-03_JPRB,2.5688E-03_JPRB/)
KBO( :, 2,38, 6) = (/&
&1.6887E-04_JPRB,1.4096E-03_JPRB,2.1097E-03_JPRB,2.6028E-03_JPRB,2.5509E-03_JPRB/)
KBO( :, 3,38, 6) = (/&
&2.2753E-04_JPRB,1.5523E-03_JPRB,2.2385E-03_JPRB,2.6923E-03_JPRB,2.5240E-03_JPRB/)
KBO( :, 4,38, 6) = (/&
&2.9721E-04_JPRB,1.7139E-03_JPRB,2.3837E-03_JPRB,2.7852E-03_JPRB,2.4889E-03_JPRB/)
KBO( :, 5,38, 6) = (/&
&3.7858E-04_JPRB,1.8923E-03_JPRB,2.5471E-03_JPRB,2.8888E-03_JPRB,2.4479E-03_JPRB/)
KBO( :, 1,39, 6) = (/&
&9.6167E-05_JPRB,1.0495E-03_JPRB,1.6303E-03_JPRB,2.0636E-03_JPRB,2.1132E-03_JPRB/)
KBO( :, 2,39, 6) = (/&
&1.3440E-04_JPRB,1.1528E-03_JPRB,1.7304E-03_JPRB,2.1389E-03_JPRB,2.1009E-03_JPRB/)
KBO( :, 3,39, 6) = (/&
&1.8170E-04_JPRB,1.2730E-03_JPRB,1.8388E-03_JPRB,2.2153E-03_JPRB,2.0813E-03_JPRB/)
KBO( :, 4,39, 6) = (/&
&2.3793E-04_JPRB,1.4086E-03_JPRB,1.9640E-03_JPRB,2.2962E-03_JPRB,2.0549E-03_JPRB/)
KBO( :, 5,39, 6) = (/&
&3.0389E-04_JPRB,1.5581E-03_JPRB,2.1030E-03_JPRB,2.3870E-03_JPRB,2.0237E-03_JPRB/)
KBO( :, 1,40, 6) = (/&
&7.3361E-05_JPRB,8.4824E-04_JPRB,1.3271E-03_JPRB,1.6866E-03_JPRB,1.7362E-03_JPRB/)
KBO( :, 2,40, 6) = (/&
&1.0336E-04_JPRB,9.3344E-04_JPRB,1.4100E-03_JPRB,1.7510E-03_JPRB,1.7287E-03_JPRB/)
KBO( :, 3,40, 6) = (/&
&1.4073E-04_JPRB,1.0330E-03_JPRB,1.5012E-03_JPRB,1.8164E-03_JPRB,1.7149E-03_JPRB/)
KBO( :, 4,40, 6) = (/&
&1.8535E-04_JPRB,1.1457E-03_JPRB,1.6065E-03_JPRB,1.8858E-03_JPRB,1.6953E-03_JPRB/)
KBO( :, 5,40, 6) = (/&
&2.3794E-04_JPRB,1.2701E-03_JPRB,1.7242E-03_JPRB,1.9642E-03_JPRB,1.6715E-03_JPRB/)
KBO( :, 1,41, 6) = (/&
&5.5536E-05_JPRB,6.8458E-04_JPRB,1.0790E-03_JPRB,1.3774E-03_JPRB,1.4257E-03_JPRB/)
KBO( :, 2,41, 6) = (/&
&7.8965E-05_JPRB,7.5448E-04_JPRB,1.1479E-03_JPRB,1.4323E-03_JPRB,1.4220E-03_JPRB/)
KBO( :, 3,41, 6) = (/&
&1.0837E-04_JPRB,8.3692E-04_JPRB,1.2239E-03_JPRB,1.4879E-03_JPRB,1.4126E-03_JPRB/)
KBO( :, 4,41, 6) = (/&
&1.4371E-04_JPRB,9.3022E-04_JPRB,1.3127E-03_JPRB,1.5474E-03_JPRB,1.3983E-03_JPRB/)
KBO( :, 5,41, 6) = (/&
&1.8543E-04_JPRB,1.0335E-03_JPRB,1.4117E-03_JPRB,1.6149E-03_JPRB,1.3804E-03_JPRB/)
KBO( :, 1,42, 6) = (/&
&4.1927E-05_JPRB,5.5223E-04_JPRB,8.7661E-04_JPRB,1.1242E-03_JPRB,1.1705E-03_JPRB/)
KBO( :, 2,42, 6) = (/&
&6.0156E-05_JPRB,6.0961E-04_JPRB,9.3423E-04_JPRB,1.1710E-03_JPRB,1.1695E-03_JPRB/)
KBO( :, 3,42, 6) = (/&
&8.3258E-05_JPRB,6.7778E-04_JPRB,9.9759E-04_JPRB,1.2187E-03_JPRB,1.1637E-03_JPRB/)
KBO( :, 4,42, 6) = (/&
&1.1119E-04_JPRB,7.5501E-04_JPRB,1.0720E-03_JPRB,1.2691E-03_JPRB,1.1534E-03_JPRB/)
KBO( :, 5,42, 6) = (/&
&1.4431E-04_JPRB,8.4052E-04_JPRB,1.1554E-03_JPRB,1.3271E-03_JPRB,1.1399E-03_JPRB/)
KBO( :, 1,43, 6) = (/&
&3.0871E-05_JPRB,4.4295E-04_JPRB,7.0961E-04_JPRB,9.1501E-04_JPRB,9.6059E-04_JPRB/)
KBO( :, 2,43, 6) = (/&
&4.4814E-05_JPRB,4.8939E-04_JPRB,7.5700E-04_JPRB,9.5494E-04_JPRB,9.6152E-04_JPRB/)
KBO( :, 3,43, 6) = (/&
&6.2693E-05_JPRB,5.4521E-04_JPRB,8.0961E-04_JPRB,9.9510E-04_JPRB,9.5849E-04_JPRB/)
KBO( :, 4,43, 6) = (/&
&8.4515E-05_JPRB,6.0874E-04_JPRB,8.7133E-04_JPRB,1.0381E-03_JPRB,9.5168E-04_JPRB/)
KBO( :, 5,43, 6) = (/&
&1.1049E-04_JPRB,6.7929E-04_JPRB,9.4142E-04_JPRB,1.0873E-03_JPRB,9.4176E-04_JPRB/)
KBO( :, 1,44, 6) = (/&
&2.2405E-05_JPRB,3.5419E-04_JPRB,5.7300E-04_JPRB,7.4330E-04_JPRB,7.8767E-04_JPRB/)
KBO( :, 2,44, 6) = (/&
&3.2966E-05_JPRB,3.9175E-04_JPRB,6.1232E-04_JPRB,7.7738E-04_JPRB,7.9040E-04_JPRB/)
KBO( :, 3,44, 6) = (/&
&4.6673E-05_JPRB,4.3706E-04_JPRB,6.5546E-04_JPRB,8.1138E-04_JPRB,7.8937E-04_JPRB/)
KBO( :, 4,44, 6) = (/&
&6.3585E-05_JPRB,4.8914E-04_JPRB,7.0656E-04_JPRB,8.4741E-04_JPRB,7.8495E-04_JPRB/)
KBO( :, 5,44, 6) = (/&
&8.3871E-05_JPRB,5.4682E-04_JPRB,7.6475E-04_JPRB,8.8894E-04_JPRB,7.7792E-04_JPRB/)
KBO( :, 1,45, 6) = (/&
&1.6187E-05_JPRB,2.8311E-04_JPRB,4.6245E-04_JPRB,6.0348E-04_JPRB,6.4574E-04_JPRB/)
KBO( :, 2,45, 6) = (/&
&2.4128E-05_JPRB,3.1327E-04_JPRB,4.9462E-04_JPRB,6.3227E-04_JPRB,6.4929E-04_JPRB/)
KBO( :, 3,45, 6) = (/&
&3.4598E-05_JPRB,3.4993E-04_JPRB,5.3013E-04_JPRB,6.6097E-04_JPRB,6.4978E-04_JPRB/)
KBO( :, 4,45, 6) = (/&
&4.7680E-05_JPRB,3.9262E-04_JPRB,5.7224E-04_JPRB,6.9137E-04_JPRB,6.4736E-04_JPRB/)
KBO( :, 5,45, 6) = (/&
&6.3477E-05_JPRB,4.3989E-04_JPRB,6.2080E-04_JPRB,7.2641E-04_JPRB,6.4265E-04_JPRB/)
KBO( :, 1,46, 6) = (/&
&1.1520E-05_JPRB,2.2564E-04_JPRB,3.7222E-04_JPRB,4.8884E-04_JPRB,5.2865E-04_JPRB/)
KBO( :, 2,46, 6) = (/&
&1.7434E-05_JPRB,2.4986E-04_JPRB,3.9882E-04_JPRB,5.1333E-04_JPRB,5.3299E-04_JPRB/)
KBO( :, 3,46, 6) = (/&
&2.5336E-05_JPRB,2.7928E-04_JPRB,4.2790E-04_JPRB,5.3774E-04_JPRB,5.3473E-04_JPRB/)
KBO( :, 4,46, 6) = (/&
&3.5391E-05_JPRB,3.1408E-04_JPRB,4.6247E-04_JPRB,5.6316E-04_JPRB,5.3383E-04_JPRB/)
KBO( :, 5,46, 6) = (/&
&4.7626E-05_JPRB,3.5268E-04_JPRB,5.0275E-04_JPRB,5.9251E-04_JPRB,5.3089E-04_JPRB/)
KBO( :, 1,47, 6) = (/&
&7.9924E-06_JPRB,1.7901E-04_JPRB,2.9855E-04_JPRB,3.9477E-04_JPRB,4.3220E-04_JPRB/)
KBO( :, 2,47, 6) = (/&
&1.2309E-05_JPRB,1.9833E-04_JPRB,3.2055E-04_JPRB,4.1563E-04_JPRB,4.3695E-04_JPRB/)
KBO( :, 3,47, 6) = (/&
&1.8181E-05_JPRB,2.2162E-04_JPRB,3.4407E-04_JPRB,4.3618E-04_JPRB,4.3945E-04_JPRB/)
KBO( :, 4,47, 6) = (/&
&2.5793E-05_JPRB,2.4965E-04_JPRB,3.7202E-04_JPRB,4.5733E-04_JPRB,4.3966E-04_JPRB/)
KBO( :, 5,47, 6) = (/&
&3.5147E-05_JPRB,2.8107E-04_JPRB,4.0519E-04_JPRB,4.8165E-04_JPRB,4.3810E-04_JPRB/)
KBO( :, 1,48, 6) = (/&
&5.4989E-06_JPRB,1.4192E-04_JPRB,2.3922E-04_JPRB,3.1843E-04_JPRB,3.5311E-04_JPRB/)
KBO( :, 2,48, 6) = (/&
&8.6315E-06_JPRB,1.5730E-04_JPRB,2.5726E-04_JPRB,3.3610E-04_JPRB,3.5792E-04_JPRB/)
KBO( :, 3,48, 6) = (/&
&1.2966E-05_JPRB,1.7572E-04_JPRB,2.7645E-04_JPRB,3.5343E-04_JPRB,3.6095E-04_JPRB/)
KBO( :, 4,48, 6) = (/&
&1.8681E-05_JPRB,1.9817E-04_JPRB,2.9900E-04_JPRB,3.7105E-04_JPRB,3.6197E-04_JPRB/)
KBO( :, 5,48, 6) = (/&
&2.5826E-05_JPRB,2.2362E-04_JPRB,3.2610E-04_JPRB,3.9105E-04_JPRB,3.6145E-04_JPRB/)
KBO( :, 1,49, 6) = (/&
&3.7496E-06_JPRB,1.1244E-04_JPRB,1.9146E-04_JPRB,2.5656E-04_JPRB,2.8829E-04_JPRB/)
KBO( :, 2,49, 6) = (/&
&6.0096E-06_JPRB,1.2470E-04_JPRB,2.0632E-04_JPRB,2.7145E-04_JPRB,2.9308E-04_JPRB/)
KBO( :, 3,49, 6) = (/&
&9.1827E-06_JPRB,1.3921E-04_JPRB,2.2197E-04_JPRB,2.8604E-04_JPRB,2.9630E-04_JPRB/)
KBO( :, 4,49, 6) = (/&
&1.3445E-05_JPRB,1.5710E-04_JPRB,2.4010E-04_JPRB,3.0080E-04_JPRB,2.9804E-04_JPRB/)
KBO( :, 5,49, 6) = (/&
&1.8873E-05_JPRB,1.7770E-04_JPRB,2.6214E-04_JPRB,3.1726E-04_JPRB,2.9838E-04_JPRB/)
KBO( :, 1,50, 6) = (/&
&2.5671E-06_JPRB,8.9202E-05_JPRB,1.5332E-04_JPRB,2.0675E-04_JPRB,2.3501E-04_JPRB/)
KBO( :, 2,50, 6) = (/&
&4.1982E-06_JPRB,9.9030E-05_JPRB,1.6552E-04_JPRB,2.1923E-04_JPRB,2.3945E-04_JPRB/)
KBO( :, 3,50, 6) = (/&
&6.5267E-06_JPRB,1.1055E-04_JPRB,1.7841E-04_JPRB,2.3163E-04_JPRB,2.4283E-04_JPRB/)
KBO( :, 4,50, 6) = (/&
&9.7111E-06_JPRB,1.2482E-04_JPRB,1.9315E-04_JPRB,2.4401E-04_JPRB,2.4486E-04_JPRB/)
KBO( :, 5,50, 6) = (/&
&1.3834E-05_JPRB,1.4148E-04_JPRB,2.1114E-04_JPRB,2.5764E-04_JPRB,2.4575E-04_JPRB/)
KBO( :, 1,51, 6) = (/&
&1.7531E-06_JPRB,7.0824E-05_JPRB,1.2282E-04_JPRB,1.6665E-04_JPRB,1.9149E-04_JPRB/)
KBO( :, 2,51, 6) = (/&
&2.9260E-06_JPRB,7.8726E-05_JPRB,1.3289E-04_JPRB,1.7703E-04_JPRB,1.9549E-04_JPRB/)
KBO( :, 3,51, 6) = (/&
&4.6328E-06_JPRB,8.7882E-05_JPRB,1.4342E-04_JPRB,1.8752E-04_JPRB,1.9871E-04_JPRB/)
KBO( :, 4,51, 6) = (/&
&7.0046E-06_JPRB,9.9229E-05_JPRB,1.5538E-04_JPRB,1.9791E-04_JPRB,2.0087E-04_JPRB/)
KBO( :, 5,51, 6) = (/&
&1.0130E-05_JPRB,1.1266E-04_JPRB,1.6996E-04_JPRB,2.0914E-04_JPRB,2.0202E-04_JPRB/)
KBO( :, 1,52, 6) = (/&
&1.1881E-06_JPRB,5.6174E-05_JPRB,9.8252E-05_JPRB,1.3417E-04_JPRB,1.5588E-04_JPRB/)
KBO( :, 2,52, 6) = (/&
&2.0257E-06_JPRB,6.2550E-05_JPRB,1.0656E-04_JPRB,1.4280E-04_JPRB,1.5952E-04_JPRB/)
KBO( :, 3,52, 6) = (/&
&3.2686E-06_JPRB,6.9845E-05_JPRB,1.1522E-04_JPRB,1.5163E-04_JPRB,1.6251E-04_JPRB/)
KBO( :, 4,52, 6) = (/&
&5.0263E-06_JPRB,7.8807E-05_JPRB,1.2491E-04_JPRB,1.6037E-04_JPRB,1.6475E-04_JPRB/)
KBO( :, 5,52, 6) = (/&
&7.3808E-06_JPRB,8.9616E-05_JPRB,1.3676E-04_JPRB,1.6966E-04_JPRB,1.6606E-04_JPRB/)
KBO( :, 1,53, 6) = (/&
&7.9832E-07_JPRB,4.4542E-05_JPRB,7.8584E-05_JPRB,1.0800E-04_JPRB,1.2691E-04_JPRB/)
KBO( :, 2,53, 6) = (/&
&1.3907E-06_JPRB,4.9657E-05_JPRB,8.5371E-05_JPRB,1.1509E-04_JPRB,1.3015E-04_JPRB/)
KBO( :, 3,53, 6) = (/&
&2.2894E-06_JPRB,5.5484E-05_JPRB,9.2507E-05_JPRB,1.2251E-04_JPRB,1.3293E-04_JPRB/)
KBO( :, 4,53, 6) = (/&
&3.5816E-06_JPRB,6.2524E-05_JPRB,1.0033E-04_JPRB,1.2981E-04_JPRB,1.3510E-04_JPRB/)
KBO( :, 5,53, 6) = (/&
&5.3461E-06_JPRB,7.1179E-05_JPRB,1.0986E-04_JPRB,1.3751E-04_JPRB,1.3653E-04_JPRB/)
KBO( :, 1,54, 6) = (/&
&5.4266E-07_JPRB,3.5380E-05_JPRB,6.2932E-05_JPRB,8.7009E-05_JPRB,1.0307E-04_JPRB/)
KBO( :, 2,54, 6) = (/&
&9.6274E-07_JPRB,3.9519E-05_JPRB,6.8507E-05_JPRB,9.2859E-05_JPRB,1.0590E-04_JPRB/)
KBO( :, 3,54, 6) = (/&
&1.6160E-06_JPRB,4.4199E-05_JPRB,7.4364E-05_JPRB,9.9034E-05_JPRB,1.0834E-04_JPRB/)
KBO( :, 4,54, 6) = (/&
&2.5711E-06_JPRB,4.9786E-05_JPRB,8.0771E-05_JPRB,1.0520E-04_JPRB,1.1032E-04_JPRB/)
KBO( :, 5,54, 6) = (/&
&3.8980E-06_JPRB,5.6706E-05_JPRB,8.8453E-05_JPRB,1.1157E-04_JPRB,1.1168E-04_JPRB/)
KBO( :, 1,55, 6) = (/&
&3.6993E-07_JPRB,2.8151E-05_JPRB,5.0447E-05_JPRB,7.0154E-05_JPRB,8.3628E-05_JPRB/)
KBO( :, 2,55, 6) = (/&
&6.6712E-07_JPRB,3.1488E-05_JPRB,5.5000E-05_JPRB,7.4925E-05_JPRB,8.6021E-05_JPRB/)
KBO( :, 3,55, 6) = (/&
&1.1415E-06_JPRB,3.5243E-05_JPRB,5.9803E-05_JPRB,8.0054E-05_JPRB,8.8077E-05_JPRB/)
KBO( :, 4,55, 6) = (/&
&1.8471E-06_JPRB,3.9685E-05_JPRB,6.5040E-05_JPRB,8.5219E-05_JPRB,8.9795E-05_JPRB/)
KBO( :, 5,55, 6) = (/&
&2.8436E-06_JPRB,4.5216E-05_JPRB,7.1236E-05_JPRB,9.0537E-05_JPRB,9.1036E-05_JPRB/)
KBO( :, 1,56, 6) = (/&
&2.5120E-07_JPRB,2.2384E-05_JPRB,4.0408E-05_JPRB,5.6527E-05_JPRB,6.7818E-05_JPRB/)
KBO( :, 2,56, 6) = (/&
&4.5929E-07_JPRB,2.5052E-05_JPRB,4.4089E-05_JPRB,6.0389E-05_JPRB,6.9831E-05_JPRB/)
KBO( :, 3,56, 6) = (/&
&8.0167E-07_JPRB,2.8088E-05_JPRB,4.8066E-05_JPRB,6.4674E-05_JPRB,7.1604E-05_JPRB/)
KBO( :, 4,56, 6) = (/&
&1.3201E-06_JPRB,3.1626E-05_JPRB,5.2345E-05_JPRB,6.8997E-05_JPRB,7.3067E-05_JPRB/)
KBO( :, 5,56, 6) = (/&
&2.0659E-06_JPRB,3.6024E-05_JPRB,5.7338E-05_JPRB,7.3417E-05_JPRB,7.4207E-05_JPRB/)
KBO( :, 1,57, 6) = (/&
&1.7004E-07_JPRB,1.7782E-05_JPRB,3.2345E-05_JPRB,4.5525E-05_JPRB,5.4975E-05_JPRB/)
KBO( :, 2,57, 6) = (/&
&3.1410E-07_JPRB,1.9933E-05_JPRB,3.5335E-05_JPRB,4.8660E-05_JPRB,5.6678E-05_JPRB/)
KBO( :, 3,57, 6) = (/&
&5.5924E-07_JPRB,2.2368E-05_JPRB,3.8595E-05_JPRB,5.2193E-05_JPRB,5.8180E-05_JPRB/)
KBO( :, 4,57, 6) = (/&
&9.3826E-07_JPRB,2.5192E-05_JPRB,4.2090E-05_JPRB,5.5809E-05_JPRB,5.9446E-05_JPRB/)
KBO( :, 5,57, 6) = (/&
&1.4926E-06_JPRB,2.8677E-05_JPRB,4.6125E-05_JPRB,5.9484E-05_JPRB,6.0455E-05_JPRB/)
KBO( :, 1,58, 6) = (/&
&1.1577E-07_JPRB,1.4158E-05_JPRB,2.5932E-05_JPRB,3.6700E-05_JPRB,4.4570E-05_JPRB/)
KBO( :, 2,58, 6) = (/&
&2.1587E-07_JPRB,1.5875E-05_JPRB,2.8345E-05_JPRB,3.9233E-05_JPRB,4.6003E-05_JPRB/)
KBO( :, 3,58, 6) = (/&
&3.9135E-07_JPRB,1.7835E-05_JPRB,3.1005E-05_JPRB,4.2122E-05_JPRB,4.7262E-05_JPRB/)
KBO( :, 4,58, 6) = (/&
&6.6857E-07_JPRB,2.0101E-05_JPRB,3.3873E-05_JPRB,4.5147E-05_JPRB,4.8336E-05_JPRB/)
KBO( :, 5,58, 6) = (/&
&1.0806E-06_JPRB,2.2861E-05_JPRB,3.7148E-05_JPRB,4.8221E-05_JPRB,4.9215E-05_JPRB/)
KBO( :, 1,59, 6) = (/&
&8.8304E-08_JPRB,1.1506E-05_JPRB,2.1115E-05_JPRB,2.9926E-05_JPRB,3.6293E-05_JPRB/)
KBO( :, 2,59, 6) = (/&
&1.6550E-07_JPRB,1.2912E-05_JPRB,2.3105E-05_JPRB,3.2031E-05_JPRB,3.7443E-05_JPRB/)
KBO( :, 3,59, 6) = (/&
&3.0240E-07_JPRB,1.4529E-05_JPRB,2.5310E-05_JPRB,3.4431E-05_JPRB,3.8446E-05_JPRB/)
KBO( :, 4,59, 6) = (/&
&5.2081E-07_JPRB,1.6394E-05_JPRB,2.7692E-05_JPRB,3.6949E-05_JPRB,3.9290E-05_JPRB/)
KBO( :, 5,59, 6) = (/&
&8.4770E-07_JPRB,1.8680E-05_JPRB,3.0444E-05_JPRB,3.9546E-05_JPRB,3.9972E-05_JPRB/)
KBO( :, 1,13, 7) = (/&
&7.6417E-03_JPRB,1.4685E-01_JPRB,2.6416E-01_JPRB,3.6864E-01_JPRB,4.6109E-01_JPRB/)
KBO( :, 2,13, 7) = (/&
&1.1521E-02_JPRB,1.5454E-01_JPRB,2.7251E-01_JPRB,3.7688E-01_JPRB,4.6334E-01_JPRB/)
KBO( :, 3,13, 7) = (/&
&1.6613E-02_JPRB,1.6273E-01_JPRB,2.8042E-01_JPRB,3.8453E-01_JPRB,4.6553E-01_JPRB/)
KBO( :, 4,13, 7) = (/&
&2.3028E-02_JPRB,1.7232E-01_JPRB,2.8850E-01_JPRB,3.9133E-01_JPRB,4.6726E-01_JPRB/)
KBO( :, 5,13, 7) = (/&
&3.0788E-02_JPRB,1.8356E-01_JPRB,2.9741E-01_JPRB,3.9745E-01_JPRB,4.6774E-01_JPRB/)
KBO( :, 1,14, 7) = (/&
&6.7826E-03_JPRB,1.3584E-01_JPRB,2.4414E-01_JPRB,3.4060E-01_JPRB,4.2274E-01_JPRB/)
KBO( :, 2,14, 7) = (/&
&1.0248E-02_JPRB,1.4315E-01_JPRB,2.5224E-01_JPRB,3.4887E-01_JPRB,4.2540E-01_JPRB/)
KBO( :, 3,14, 7) = (/&
&1.4775E-02_JPRB,1.5124E-01_JPRB,2.6040E-01_JPRB,3.5649E-01_JPRB,4.2762E-01_JPRB/)
KBO( :, 4,14, 7) = (/&
&2.0429E-02_JPRB,1.6084E-01_JPRB,2.6907E-01_JPRB,3.6333E-01_JPRB,4.2937E-01_JPRB/)
KBO( :, 5,14, 7) = (/&
&2.7297E-02_JPRB,1.7167E-01_JPRB,2.7817E-01_JPRB,3.7020E-01_JPRB,4.3049E-01_JPRB/)
KBO( :, 1,15, 7) = (/&
&6.0553E-03_JPRB,1.2441E-01_JPRB,2.2318E-01_JPRB,3.1131E-01_JPRB,3.8387E-01_JPRB/)
KBO( :, 2,15, 7) = (/&
&9.1374E-03_JPRB,1.3148E-01_JPRB,2.3116E-01_JPRB,3.1936E-01_JPRB,3.8692E-01_JPRB/)
KBO( :, 3,15, 7) = (/&
&1.3123E-02_JPRB,1.3959E-01_JPRB,2.3951E-01_JPRB,3.2683E-01_JPRB,3.8938E-01_JPRB/)
KBO( :, 4,15, 7) = (/&
&1.8101E-02_JPRB,1.4896E-01_JPRB,2.4836E-01_JPRB,3.3404E-01_JPRB,3.9141E-01_JPRB/)
KBO( :, 5,15, 7) = (/&
&2.4175E-02_JPRB,1.5911E-01_JPRB,2.5777E-01_JPRB,3.4141E-01_JPRB,3.9315E-01_JPRB/)
KBO( :, 1,16, 7) = (/&
&5.4131E-03_JPRB,1.1283E-01_JPRB,2.0186E-01_JPRB,2.8155E-01_JPRB,3.4527E-01_JPRB/)
KBO( :, 2,16, 7) = (/&
&8.1288E-03_JPRB,1.1972E-01_JPRB,2.0981E-01_JPRB,2.8928E-01_JPRB,3.4862E-01_JPRB/)
KBO( :, 3,16, 7) = (/&
&1.1627E-02_JPRB,1.2773E-01_JPRB,2.1812E-01_JPRB,2.9668E-01_JPRB,3.5162E-01_JPRB/)
KBO( :, 4,16, 7) = (/&
&1.6009E-02_JPRB,1.3671E-01_JPRB,2.2693E-01_JPRB,3.0423E-01_JPRB,3.5439E-01_JPRB/)
KBO( :, 5,16, 7) = (/&
&2.1373E-02_JPRB,1.4625E-01_JPRB,2.3648E-01_JPRB,3.1202E-01_JPRB,3.5679E-01_JPRB/)
KBO( :, 1,17, 7) = (/&
&4.8149E-03_JPRB,1.0146E-01_JPRB,1.8080E-01_JPRB,2.5190E-01_JPRB,3.0738E-01_JPRB/)
KBO( :, 2,17, 7) = (/&
&7.1924E-03_JPRB,1.0816E-01_JPRB,1.8856E-01_JPRB,2.5937E-01_JPRB,3.1115E-01_JPRB/)
KBO( :, 3,17, 7) = (/&
&1.0254E-02_JPRB,1.1589E-01_JPRB,1.9675E-01_JPRB,2.6692E-01_JPRB,3.1465E-01_JPRB/)
KBO( :, 4,17, 7) = (/&
&1.4092E-02_JPRB,1.2436E-01_JPRB,2.0561E-01_JPRB,2.7457E-01_JPRB,3.1792E-01_JPRB/)
KBO( :, 5,17, 7) = (/&
&1.8801E-02_JPRB,1.3345E-01_JPRB,2.1493E-01_JPRB,2.8234E-01_JPRB,3.2110E-01_JPRB/)
KBO( :, 1,18, 7) = (/&
&4.2633E-03_JPRB,9.0462E-02_JPRB,1.6049E-01_JPRB,2.2327E-01_JPRB,2.7128E-01_JPRB/)
KBO( :, 2,18, 7) = (/&
&6.3371E-03_JPRB,9.6983E-02_JPRB,1.6798E-01_JPRB,2.3054E-01_JPRB,2.7526E-01_JPRB/)
KBO( :, 3,18, 7) = (/&
&9.0048E-03_JPRB,1.0434E-01_JPRB,1.7596E-01_JPRB,2.3795E-01_JPRB,2.7919E-01_JPRB/)
KBO( :, 4,18, 7) = (/&
&1.2349E-02_JPRB,1.1235E-01_JPRB,1.8455E-01_JPRB,2.4558E-01_JPRB,2.8307E-01_JPRB/)
KBO( :, 5,18, 7) = (/&
&1.6477E-02_JPRB,1.2095E-01_JPRB,1.9366E-01_JPRB,2.5349E-01_JPRB,2.8698E-01_JPRB/)
KBO( :, 1,19, 7) = (/&
&3.7554E-03_JPRB,8.0086E-02_JPRB,1.4130E-01_JPRB,1.9618E-01_JPRB,2.3729E-01_JPRB/)
KBO( :, 2,19, 7) = (/&
&5.5565E-03_JPRB,8.6345E-02_JPRB,1.4840E-01_JPRB,2.0316E-01_JPRB,2.4150E-01_JPRB/)
KBO( :, 3,19, 7) = (/&
&7.8702E-03_JPRB,9.3236E-02_JPRB,1.5616E-01_JPRB,2.1043E-01_JPRB,2.4581E-01_JPRB/)
KBO( :, 4,19, 7) = (/&
&1.0787E-02_JPRB,1.0080E-01_JPRB,1.6449E-01_JPRB,2.1798E-01_JPRB,2.5008E-01_JPRB/)
KBO( :, 5,19, 7) = (/&
&1.4413E-02_JPRB,1.0887E-01_JPRB,1.7330E-01_JPRB,2.2565E-01_JPRB,2.5355E-01_JPRB/)
KBO( :, 1,20, 7) = (/&
&3.3111E-03_JPRB,7.0557E-02_JPRB,1.2355E-01_JPRB,1.7117E-01_JPRB,2.0615E-01_JPRB/)
KBO( :, 2,20, 7) = (/&
&4.8768E-03_JPRB,7.6467E-02_JPRB,1.3039E-01_JPRB,1.7787E-01_JPRB,2.1057E-01_JPRB/)
KBO( :, 3,20, 7) = (/&
&6.8937E-03_JPRB,8.2939E-02_JPRB,1.3783E-01_JPRB,1.8491E-01_JPRB,2.1500E-01_JPRB/)
KBO( :, 4,20, 7) = (/&
&9.4568E-03_JPRB,8.9997E-02_JPRB,1.4573E-01_JPRB,1.9190E-01_JPRB,2.1847E-01_JPRB/)
KBO( :, 5,20, 7) = (/&
&1.2649E-02_JPRB,9.7398E-02_JPRB,1.5380E-01_JPRB,1.9837E-01_JPRB,2.2024E-01_JPRB/)
KBO( :, 1,21, 7) = (/&
&2.9095E-03_JPRB,6.1851E-02_JPRB,1.0745E-01_JPRB,1.4844E-01_JPRB,1.7810E-01_JPRB/)
KBO( :, 2,21, 7) = (/&
&4.2692E-03_JPRB,6.7344E-02_JPRB,1.1397E-01_JPRB,1.5479E-01_JPRB,1.8248E-01_JPRB/)
KBO( :, 3,21, 7) = (/&
&6.0338E-03_JPRB,7.3350E-02_JPRB,1.2086E-01_JPRB,1.6105E-01_JPRB,1.8592E-01_JPRB/)
KBO( :, 4,21, 7) = (/&
&8.2818E-03_JPRB,7.9701E-02_JPRB,1.2784E-01_JPRB,1.6671E-01_JPRB,1.8765E-01_JPRB/)
KBO( :, 5,21, 7) = (/&
&1.1081E-02_JPRB,8.6263E-02_JPRB,1.3464E-01_JPRB,1.7152E-01_JPRB,1.8756E-01_JPRB/)
KBO( :, 1,22, 7) = (/&
&2.6181E-03_JPRB,5.4287E-02_JPRB,9.3450E-02_JPRB,1.2844E-01_JPRB,1.5335E-01_JPRB/)
KBO( :, 2,22, 7) = (/&
&3.8243E-03_JPRB,5.9349E-02_JPRB,9.9393E-02_JPRB,1.3393E-01_JPRB,1.5664E-01_JPRB/)
KBO( :, 3,22, 7) = (/&
&5.3935E-03_JPRB,6.4666E-02_JPRB,1.0530E-01_JPRB,1.3879E-01_JPRB,1.5834E-01_JPRB/)
KBO( :, 4,22, 7) = (/&
&7.3925E-03_JPRB,7.0137E-02_JPRB,1.1102E-01_JPRB,1.4284E-01_JPRB,1.5840E-01_JPRB/)
KBO( :, 5,22, 7) = (/&
&9.8581E-03_JPRB,7.5739E-02_JPRB,1.1637E-01_JPRB,1.4626E-01_JPRB,1.5728E-01_JPRB/)
KBO( :, 1,23, 7) = (/&
&2.3567E-03_JPRB,4.7466E-02_JPRB,8.0891E-02_JPRB,1.1029E-01_JPRB,1.3073E-01_JPRB/)
KBO( :, 2,23, 7) = (/&
&3.4308E-03_JPRB,5.1876E-02_JPRB,8.5843E-02_JPRB,1.1448E-01_JPRB,1.3247E-01_JPRB/)
KBO( :, 3,23, 7) = (/&
&4.8257E-03_JPRB,5.6351E-02_JPRB,9.0620E-02_JPRB,1.1795E-01_JPRB,1.3277E-01_JPRB/)
KBO( :, 4,23, 7) = (/&
&6.5958E-03_JPRB,6.0900E-02_JPRB,9.5105E-02_JPRB,1.2092E-01_JPRB,1.3207E-01_JPRB/)
KBO( :, 5,23, 7) = (/&
&8.7592E-03_JPRB,6.5586E-02_JPRB,9.9383E-02_JPRB,1.2354E-01_JPRB,1.3064E-01_JPRB/)
KBO( :, 1,24, 7) = (/&
&2.1271E-03_JPRB,4.1190E-02_JPRB,6.9395E-02_JPRB,9.3707E-02_JPRB,1.1002E-01_JPRB/)
KBO( :, 2,24, 7) = (/&
&3.0856E-03_JPRB,4.4852E-02_JPRB,7.3354E-02_JPRB,9.6714E-02_JPRB,1.1057E-01_JPRB/)
KBO( :, 3,24, 7) = (/&
&4.3257E-03_JPRB,4.8524E-02_JPRB,7.7130E-02_JPRB,9.9321E-02_JPRB,1.1024E-01_JPRB/)
KBO( :, 4,24, 7) = (/&
&5.8826E-03_JPRB,5.2297E-02_JPRB,8.0734E-02_JPRB,1.0166E-01_JPRB,1.0927E-01_JPRB/)
KBO( :, 5,24, 7) = (/&
&7.7717E-03_JPRB,5.6295E-02_JPRB,8.4275E-02_JPRB,1.0378E-01_JPRB,1.0782E-01_JPRB/)
KBO( :, 1,25, 7) = (/&
&1.9281E-03_JPRB,3.5411E-02_JPRB,5.8998E-02_JPRB,7.8852E-02_JPRB,9.1568E-02_JPRB/)
KBO( :, 2,25, 7) = (/&
&2.7824E-03_JPRB,3.8393E-02_JPRB,6.2155E-02_JPRB,8.1138E-02_JPRB,9.1561E-02_JPRB/)
KBO( :, 3,25, 7) = (/&
&3.8806E-03_JPRB,4.1433E-02_JPRB,6.5194E-02_JPRB,8.3215E-02_JPRB,9.0981E-02_JPRB/)
KBO( :, 4,25, 7) = (/&
&5.2453E-03_JPRB,4.4637E-02_JPRB,6.8168E-02_JPRB,8.5119E-02_JPRB,8.9958E-02_JPRB/)
KBO( :, 5,25, 7) = (/&
&6.8977E-03_JPRB,4.8120E-02_JPRB,7.1175E-02_JPRB,8.6855E-02_JPRB,8.8595E-02_JPRB/)
KBO( :, 1,26, 7) = (/&
&1.7587E-03_JPRB,3.0214E-02_JPRB,4.9851E-02_JPRB,6.5996E-02_JPRB,7.5710E-02_JPRB/)
KBO( :, 2,26, 7) = (/&
&2.5210E-03_JPRB,3.2677E-02_JPRB,5.2397E-02_JPRB,6.7829E-02_JPRB,7.5438E-02_JPRB/)
KBO( :, 3,26, 7) = (/&
&3.4928E-03_JPRB,3.5239E-02_JPRB,5.4896E-02_JPRB,6.9528E-02_JPRB,7.4777E-02_JPRB/)
KBO( :, 4,26, 7) = (/&
&4.6908E-03_JPRB,3.8029E-02_JPRB,5.7397E-02_JPRB,7.1083E-02_JPRB,7.3800E-02_JPRB/)
KBO( :, 5,26, 7) = (/&
&6.1395E-03_JPRB,4.1060E-02_JPRB,5.9986E-02_JPRB,7.2531E-02_JPRB,7.2558E-02_JPRB/)
KBO( :, 1,27, 7) = (/&
&1.6029E-03_JPRB,2.5642E-02_JPRB,4.1927E-02_JPRB,5.5065E-02_JPRB,6.2332E-02_JPRB/)
KBO( :, 2,27, 7) = (/&
&2.2812E-03_JPRB,2.7700E-02_JPRB,4.4008E-02_JPRB,5.6573E-02_JPRB,6.1961E-02_JPRB/)
KBO( :, 3,27, 7) = (/&
&3.1372E-03_JPRB,2.9918E-02_JPRB,4.6094E-02_JPRB,5.7948E-02_JPRB,6.1302E-02_JPRB/)
KBO( :, 4,27, 7) = (/&
&4.1899E-03_JPRB,3.2354E-02_JPRB,4.8227E-02_JPRB,5.9239E-02_JPRB,6.0407E-02_JPRB/)
KBO( :, 5,27, 7) = (/&
&5.4669E-03_JPRB,3.4991E-02_JPRB,5.0494E-02_JPRB,6.0487E-02_JPRB,5.9313E-02_JPRB/)
KBO( :, 1,28, 7) = (/&
&1.4587E-03_JPRB,2.1692E-02_JPRB,3.5152E-02_JPRB,4.5868E-02_JPRB,5.1191E-02_JPRB/)
KBO( :, 2,28, 7) = (/&
&2.0600E-03_JPRB,2.3452E-02_JPRB,3.6880E-02_JPRB,4.7085E-02_JPRB,5.0788E-02_JPRB/)
KBO( :, 3,28, 7) = (/&
&2.8147E-03_JPRB,2.5390E-02_JPRB,3.8642E-02_JPRB,4.8221E-02_JPRB,5.0174E-02_JPRB/)
KBO( :, 4,28, 7) = (/&
&3.7416E-03_JPRB,2.7500E-02_JPRB,4.0500E-02_JPRB,4.9318E-02_JPRB,4.9374E-02_JPRB/)
KBO( :, 5,28, 7) = (/&
&4.8758E-03_JPRB,2.9796E-02_JPRB,4.2469E-02_JPRB,5.0418E-02_JPRB,4.8430E-02_JPRB/)
KBO( :, 1,29, 7) = (/&
&1.3284E-03_JPRB,1.8334E-02_JPRB,2.9430E-02_JPRB,3.8154E-02_JPRB,4.1977E-02_JPRB/)
KBO( :, 2,29, 7) = (/&
&1.8615E-03_JPRB,1.9864E-02_JPRB,3.0877E-02_JPRB,3.9147E-02_JPRB,4.1585E-02_JPRB/)
KBO( :, 3,29, 7) = (/&
&2.5273E-03_JPRB,2.1548E-02_JPRB,3.2404E-02_JPRB,4.0101E-02_JPRB,4.1024E-02_JPRB/)
KBO( :, 4,29, 7) = (/&
&3.3502E-03_JPRB,2.3383E-02_JPRB,3.4027E-02_JPRB,4.1054E-02_JPRB,4.0329E-02_JPRB/)
KBO( :, 5,29, 7) = (/&
&4.3678E-03_JPRB,2.5374E-02_JPRB,3.5730E-02_JPRB,4.2021E-02_JPRB,3.9526E-02_JPRB/)
KBO( :, 1,30, 7) = (/&
&1.2077E-03_JPRB,1.5498E-02_JPRB,2.4613E-02_JPRB,3.1700E-02_JPRB,3.4385E-02_JPRB/)
KBO( :, 2,30, 7) = (/&
&1.6794E-03_JPRB,1.6830E-02_JPRB,2.5859E-02_JPRB,3.2527E-02_JPRB,3.4019E-02_JPRB/)
KBO( :, 3,30, 7) = (/&
&2.2700E-03_JPRB,1.8290E-02_JPRB,2.7194E-02_JPRB,3.3342E-02_JPRB,3.3526E-02_JPRB/)
KBO( :, 4,30, 7) = (/&
&3.0076E-03_JPRB,1.9884E-02_JPRB,2.8602E-02_JPRB,3.4179E-02_JPRB,3.2934E-02_JPRB/)
KBO( :, 5,30, 7) = (/&
&3.9239E-03_JPRB,2.1618E-02_JPRB,3.0083E-02_JPRB,3.5038E-02_JPRB,3.2267E-02_JPRB/)
KBO( :, 1,31, 7) = (/&
&1.0979E-03_JPRB,1.3116E-02_JPRB,2.0595E-02_JPRB,2.6327E-02_JPRB,2.8152E-02_JPRB/)
KBO( :, 2,31, 7) = (/&
&1.5169E-03_JPRB,1.4272E-02_JPRB,2.1683E-02_JPRB,2.7024E-02_JPRB,2.7826E-02_JPRB/)
KBO( :, 3,31, 7) = (/&
&2.0453E-03_JPRB,1.5538E-02_JPRB,2.2843E-02_JPRB,2.7738E-02_JPRB,2.7405E-02_JPRB/)
KBO( :, 4,31, 7) = (/&
&2.7116E-03_JPRB,1.6927E-02_JPRB,2.4066E-02_JPRB,2.8483E-02_JPRB,2.6914E-02_JPRB/)
KBO( :, 5,31, 7) = (/&
&3.5394E-03_JPRB,1.8442E-02_JPRB,2.5352E-02_JPRB,2.9238E-02_JPRB,2.6357E-02_JPRB/)
KBO( :, 1,32, 7) = (/&
&9.9745E-04_JPRB,1.1111E-02_JPRB,1.7254E-02_JPRB,2.1864E-02_JPRB,2.3045E-02_JPRB/)
KBO( :, 2,32, 7) = (/&
&1.3720E-03_JPRB,1.2113E-02_JPRB,1.8202E-02_JPRB,2.2466E-02_JPRB,2.2758E-02_JPRB/)
KBO( :, 3,32, 7) = (/&
&1.8496E-03_JPRB,1.3215E-02_JPRB,1.9210E-02_JPRB,2.3105E-02_JPRB,2.2405E-02_JPRB/)
KBO( :, 4,32, 7) = (/&
&2.4534E-03_JPRB,1.4429E-02_JPRB,2.0269E-02_JPRB,2.3758E-02_JPRB,2.1994E-02_JPRB/)
KBO( :, 5,32, 7) = (/&
&3.1994E-03_JPRB,1.5763E-02_JPRB,2.1391E-02_JPRB,2.4424E-02_JPRB,2.1537E-02_JPRB/)
KBO( :, 1,33, 7) = (/&
&9.0609E-04_JPRB,9.4233E-03_JPRB,1.4475E-02_JPRB,1.8167E-02_JPRB,1.8863E-02_JPRB/)
KBO( :, 2,33, 7) = (/&
&1.2447E-03_JPRB,1.0296E-02_JPRB,1.5300E-02_JPRB,1.8704E-02_JPRB,1.8620E-02_JPRB/)
KBO( :, 3,33, 7) = (/&
&1.6790E-03_JPRB,1.1258E-02_JPRB,1.6171E-02_JPRB,1.9267E-02_JPRB,1.8323E-02_JPRB/)
KBO( :, 4,33, 7) = (/&
&2.2252E-03_JPRB,1.2324E-02_JPRB,1.7095E-02_JPRB,1.9844E-02_JPRB,1.7985E-02_JPRB/)
KBO( :, 5,33, 7) = (/&
&2.8950E-03_JPRB,1.3521E-02_JPRB,1.8082E-02_JPRB,2.0433E-02_JPRB,1.7614E-02_JPRB/)
KBO( :, 1,34, 7) = (/&
&8.1514E-04_JPRB,7.9756E-03_JPRB,1.2137E-02_JPRB,1.5099E-02_JPRB,1.5443E-02_JPRB/)
KBO( :, 2,34, 7) = (/&
&1.1204E-03_JPRB,8.7356E-03_JPRB,1.2847E-02_JPRB,1.5577E-02_JPRB,1.5237E-02_JPRB/)
KBO( :, 3,34, 7) = (/&
&1.5119E-03_JPRB,9.5758E-03_JPRB,1.3604E-02_JPRB,1.6072E-02_JPRB,1.4994E-02_JPRB/)
KBO( :, 4,34, 7) = (/&
&2.0012E-03_JPRB,1.0522E-02_JPRB,1.4410E-02_JPRB,1.6579E-02_JPRB,1.4722E-02_JPRB/)
KBO( :, 5,34, 7) = (/&
&2.5995E-03_JPRB,1.1602E-02_JPRB,1.5283E-02_JPRB,1.7098E-02_JPRB,1.4425E-02_JPRB/)
KBO( :, 1,35, 7) = (/&
&7.1227E-04_JPRB,6.7018E-03_JPRB,1.0127E-02_JPRB,1.2528E-02_JPRB,1.2660E-02_JPRB/)
KBO( :, 2,35, 7) = (/&
&9.8163E-04_JPRB,7.3560E-03_JPRB,1.0739E-02_JPRB,1.2948E-02_JPRB,1.2494E-02_JPRB/)
KBO( :, 3,35, 7) = (/&
&1.3263E-03_JPRB,8.0909E-03_JPRB,1.1393E-02_JPRB,1.3382E-02_JPRB,1.2302E-02_JPRB/)
KBO( :, 4,35, 7) = (/&
&1.7561E-03_JPRB,8.9242E-03_JPRB,1.2096E-02_JPRB,1.3825E-02_JPRB,1.2085E-02_JPRB/)
KBO( :, 5,35, 7) = (/&
&2.2810E-03_JPRB,9.8947E-03_JPRB,1.2873E-02_JPRB,1.4284E-02_JPRB,1.1851E-02_JPRB/)
KBO( :, 1,36, 7) = (/&
&6.0202E-04_JPRB,5.5779E-03_JPRB,8.4015E-03_JPRB,1.0366E-02_JPRB,1.0396E-02_JPRB/)
KBO( :, 2,36, 7) = (/&
&8.3319E-04_JPRB,6.1400E-03_JPRB,8.9260E-03_JPRB,1.0732E-02_JPRB,1.0268E-02_JPRB/)
KBO( :, 3,36, 7) = (/&
&1.1287E-03_JPRB,6.7734E-03_JPRB,9.4880E-03_JPRB,1.1109E-02_JPRB,1.0116E-02_JPRB/)
KBO( :, 4,36, 7) = (/&
&1.4983E-03_JPRB,7.5040E-03_JPRB,1.0100E-02_JPRB,1.1497E-02_JPRB,9.9466E-03_JPRB/)
KBO( :, 5,36, 7) = (/&
&1.9490E-03_JPRB,8.3637E-03_JPRB,1.0791E-02_JPRB,1.1906E-02_JPRB,9.7636E-03_JPRB/)
KBO( :, 1,37, 7) = (/&
&4.8416E-04_JPRB,4.5804E-03_JPRB,6.9086E-03_JPRB,8.5355E-03_JPRB,8.5508E-03_JPRB/)
KBO( :, 2,37, 7) = (/&
&6.7495E-04_JPRB,5.0520E-03_JPRB,7.3527E-03_JPRB,8.8519E-03_JPRB,8.4527E-03_JPRB/)
KBO( :, 3,37, 7) = (/&
&9.1952E-04_JPRB,5.5894E-03_JPRB,7.8325E-03_JPRB,9.1782E-03_JPRB,8.3356E-03_JPRB/)
KBO( :, 4,37, 7) = (/&
&1.2272E-03_JPRB,6.2161E-03_JPRB,8.3611E-03_JPRB,9.5172E-03_JPRB,8.2045E-03_JPRB/)
KBO( :, 5,37, 7) = (/&
&1.6032E-03_JPRB,6.9603E-03_JPRB,8.9629E-03_JPRB,9.8764E-03_JPRB,8.0631E-03_JPRB/)
KBO( :, 1,38, 7) = (/&
&3.8815E-04_JPRB,3.7581E-03_JPRB,5.6778E-03_JPRB,7.0261E-03_JPRB,7.0356E-03_JPRB/)
KBO( :, 2,38, 7) = (/&
&5.4489E-04_JPRB,4.1553E-03_JPRB,6.0551E-03_JPRB,7.3001E-03_JPRB,6.9620E-03_JPRB/)
KBO( :, 3,38, 7) = (/&
&7.4720E-04_JPRB,4.6096E-03_JPRB,6.4646E-03_JPRB,7.5820E-03_JPRB,6.8735E-03_JPRB/)
KBO( :, 4,38, 7) = (/&
&1.0025E-03_JPRB,5.1457E-03_JPRB,6.9210E-03_JPRB,7.8773E-03_JPRB,6.7744E-03_JPRB/)
KBO( :, 5,38, 7) = (/&
&1.3158E-03_JPRB,5.7907E-03_JPRB,7.4467E-03_JPRB,8.1937E-03_JPRB,6.6650E-03_JPRB/)
KBO( :, 1,39, 7) = (/&
&3.1112E-04_JPRB,3.0839E-03_JPRB,4.6680E-03_JPRB,5.7846E-03_JPRB,5.7911E-03_JPRB/)
KBO( :, 2,39, 7) = (/&
&4.3990E-04_JPRB,3.4180E-03_JPRB,4.9880E-03_JPRB,6.0205E-03_JPRB,5.7382E-03_JPRB/)
KBO( :, 3,39, 7) = (/&
&6.0701E-04_JPRB,3.8014E-03_JPRB,5.3384E-03_JPRB,6.2649E-03_JPRB,5.6729E-03_JPRB/)
KBO( :, 4,39, 7) = (/&
&8.1924E-04_JPRB,4.2647E-03_JPRB,5.7318E-03_JPRB,6.5208E-03_JPRB,5.5990E-03_JPRB/)
KBO( :, 5,39, 7) = (/&
&1.0794E-03_JPRB,4.8235E-03_JPRB,6.1904E-03_JPRB,6.7997E-03_JPRB,5.5155E-03_JPRB/)
KBO( :, 1,40, 7) = (/&
&2.3999E-04_JPRB,2.5045E-03_JPRB,3.8112E-03_JPRB,4.7419E-03_JPRB,4.7659E-03_JPRB/)
KBO( :, 2,40, 7) = (/&
&3.4272E-04_JPRB,2.7807E-03_JPRB,4.0807E-03_JPRB,4.9438E-03_JPRB,4.7281E-03_JPRB/)
KBO( :, 3,40, 7) = (/&
&4.7709E-04_JPRB,3.1013E-03_JPRB,4.3772E-03_JPRB,5.1542E-03_JPRB,4.6798E-03_JPRB/)
KBO( :, 4,40, 7) = (/&
&6.4876E-04_JPRB,3.4905E-03_JPRB,4.7113E-03_JPRB,5.3759E-03_JPRB,4.6247E-03_JPRB/)
KBO( :, 5,40, 7) = (/&
&8.6088E-04_JPRB,3.9661E-03_JPRB,5.1051E-03_JPRB,5.6199E-03_JPRB,4.5616E-03_JPRB/)
KBO( :, 1,41, 7) = (/&
&1.8373E-04_JPRB,2.0302E-03_JPRB,3.1081E-03_JPRB,3.8838E-03_JPRB,3.9218E-03_JPRB/)
KBO( :, 2,41, 7) = (/&
&2.6521E-04_JPRB,2.2593E-03_JPRB,3.3353E-03_JPRB,4.0566E-03_JPRB,3.8950E-03_JPRB/)
KBO( :, 3,41, 7) = (/&
&3.7260E-04_JPRB,2.5252E-03_JPRB,3.5847E-03_JPRB,4.2368E-03_JPRB,3.8605E-03_JPRB/)
KBO( :, 4,41, 7) = (/&
&5.1095E-04_JPRB,2.8525E-03_JPRB,3.8680E-03_JPRB,4.4284E-03_JPRB,3.8199E-03_JPRB/)
KBO( :, 5,41, 7) = (/&
&6.8302E-04_JPRB,3.2540E-03_JPRB,4.2038E-03_JPRB,4.6408E-03_JPRB,3.7718E-03_JPRB/)
KBO( :, 1,42, 7) = (/&
&1.4021E-04_JPRB,1.6447E-03_JPRB,2.5340E-03_JPRB,3.1794E-03_JPRB,3.2271E-03_JPRB/)
KBO( :, 2,42, 7) = (/&
&2.0457E-04_JPRB,1.8341E-03_JPRB,2.7244E-03_JPRB,3.3270E-03_JPRB,3.2092E-03_JPRB/)
KBO( :, 3,42, 7) = (/&
&2.9014E-04_JPRB,2.0556E-03_JPRB,2.9350E-03_JPRB,3.4824E-03_JPRB,3.1854E-03_JPRB/)
KBO( :, 4,42, 7) = (/&
&4.0126E-04_JPRB,2.3289E-03_JPRB,3.1740E-03_JPRB,3.6472E-03_JPRB,3.1554E-03_JPRB/)
KBO( :, 5,42, 7) = (/&
&5.4072E-04_JPRB,2.6686E-03_JPRB,3.4603E-03_JPRB,3.8315E-03_JPRB,3.1192E-03_JPRB/)
KBO( :, 1,43, 7) = (/&
&1.0418E-04_JPRB,1.3241E-03_JPRB,2.0566E-03_JPRB,2.5949E-03_JPRB,2.6555E-03_JPRB/)
KBO( :, 2,43, 7) = (/&
&1.5394E-04_JPRB,1.4792E-03_JPRB,2.2158E-03_JPRB,2.7206E-03_JPRB,2.6446E-03_JPRB/)
KBO( :, 3,43, 7) = (/&
&2.2089E-04_JPRB,1.6609E-03_JPRB,2.3912E-03_JPRB,2.8530E-03_JPRB,2.6280E-03_JPRB/)
KBO( :, 4,43, 7) = (/&
&3.0843E-04_JPRB,1.8861E-03_JPRB,2.5915E-03_JPRB,2.9949E-03_JPRB,2.6073E-03_JPRB/)
KBO( :, 5,43, 7) = (/&
&4.1975E-04_JPRB,2.1696E-03_JPRB,2.8326E-03_JPRB,3.1535E-03_JPRB,2.5807E-03_JPRB/)
KBO( :, 1,44, 7) = (/&
&7.6179E-05_JPRB,1.0623E-03_JPRB,1.6648E-03_JPRB,2.1141E-03_JPRB,2.1847E-03_JPRB/)
KBO( :, 2,44, 7) = (/&
&1.1420E-04_JPRB,1.1887E-03_JPRB,1.7975E-03_JPRB,2.2205E-03_JPRB,2.1791E-03_JPRB/)
KBO( :, 3,44, 7) = (/&
&1.6589E-04_JPRB,1.3367E-03_JPRB,1.9435E-03_JPRB,2.3337E-03_JPRB,2.1689E-03_JPRB/)
KBO( :, 4,44, 7) = (/&
&2.3431E-04_JPRB,1.5216E-03_JPRB,2.1097E-03_JPRB,2.4546E-03_JPRB,2.1546E-03_JPRB/)
KBO( :, 5,44, 7) = (/&
&3.2209E-04_JPRB,1.7553E-03_JPRB,2.3110E-03_JPRB,2.5901E-03_JPRB,2.1354E-03_JPRB/)
KBO( :, 1,45, 7) = (/&
&5.5380E-05_JPRB,8.5190E-04_JPRB,1.3470E-03_JPRB,1.7214E-03_JPRB,1.7974E-03_JPRB/)
KBO( :, 2,45, 7) = (/&
&8.4230E-05_JPRB,9.5419E-04_JPRB,1.4571E-03_JPRB,1.8110E-03_JPRB,1.7954E-03_JPRB/)
KBO( :, 3,45, 7) = (/&
&1.2398E-04_JPRB,1.0747E-03_JPRB,1.5782E-03_JPRB,1.9072E-03_JPRB,1.7895E-03_JPRB/)
KBO( :, 4,45, 7) = (/&
&1.7714E-04_JPRB,1.2254E-03_JPRB,1.7161E-03_JPRB,2.0103E-03_JPRB,1.7807E-03_JPRB/)
KBO( :, 5,45, 7) = (/&
&2.4615E-04_JPRB,1.4185E-03_JPRB,1.8836E-03_JPRB,2.1255E-03_JPRB,1.7676E-03_JPRB/)
KBO( :, 1,46, 7) = (/&
&3.9608E-05_JPRB,6.8065E-04_JPRB,1.0869E-03_JPRB,1.3989E-03_JPRB,1.4780E-03_JPRB/)
KBO( :, 2,46, 7) = (/&
&6.1254E-05_JPRB,7.6359E-04_JPRB,1.1780E-03_JPRB,1.4742E-03_JPRB,1.4788E-03_JPRB/)
KBO( :, 3,46, 7) = (/&
&9.1434E-05_JPRB,8.6131E-04_JPRB,1.2786E-03_JPRB,1.5561E-03_JPRB,1.4768E-03_JPRB/)
KBO( :, 4,46, 7) = (/&
&1.3231E-04_JPRB,9.8314E-04_JPRB,1.3925E-03_JPRB,1.6437E-03_JPRB,1.4719E-03_JPRB/)
KBO( :, 5,46, 7) = (/&
&1.8599E-04_JPRB,1.1411E-03_JPRB,1.5309E-03_JPRB,1.7412E-03_JPRB,1.4636E-03_JPRB/)
KBO( :, 1,47, 7) = (/&
&2.7565E-05_JPRB,5.4081E-04_JPRB,8.7346E-04_JPRB,1.1337E-03_JPRB,1.2145E-03_JPRB/)
KBO( :, 2,47, 7) = (/&
&4.3444E-05_JPRB,6.0782E-04_JPRB,9.4864E-04_JPRB,1.1966E-03_JPRB,1.2173E-03_JPRB/)
KBO( :, 3,47, 7) = (/&
&6.5911E-05_JPRB,6.8599E-04_JPRB,1.0313E-03_JPRB,1.2655E-03_JPRB,1.2177E-03_JPRB/)
KBO( :, 4,47, 7) = (/&
&9.6767E-05_JPRB,7.8305E-04_JPRB,1.1246E-03_JPRB,1.3397E-03_JPRB,1.2159E-03_JPRB/)
KBO( :, 5,47, 7) = (/&
&1.3786E-04_JPRB,9.1017E-04_JPRB,1.2371E-03_JPRB,1.4212E-03_JPRB,1.2107E-03_JPRB/)
KBO( :, 1,48, 7) = (/&
&1.9010E-05_JPRB,4.2934E-04_JPRB,7.0139E-04_JPRB,9.1842E-04_JPRB,9.9781E-04_JPRB/)
KBO( :, 2,48, 7) = (/&
&3.0547E-05_JPRB,4.8321E-04_JPRB,7.6298E-04_JPRB,9.7015E-04_JPRB,1.0019E-03_JPRB/)
KBO( :, 3,48, 7) = (/&
&4.7172E-05_JPRB,5.4566E-04_JPRB,8.3089E-04_JPRB,1.0280E-03_JPRB,1.0041E-03_JPRB/)
KBO( :, 4,48, 7) = (/&
&7.0312E-05_JPRB,6.2270E-04_JPRB,9.0704E-04_JPRB,1.0904E-03_JPRB,1.0043E-03_JPRB/)
KBO( :, 5,48, 7) = (/&
&1.0158E-04_JPRB,7.2457E-04_JPRB,9.9839E-04_JPRB,1.1584E-03_JPRB,1.0014E-03_JPRB/)
KBO( :, 1,49, 7) = (/&
&1.2989E-05_JPRB,3.4041E-04_JPRB,5.6254E-04_JPRB,7.4336E-04_JPRB,8.1967E-04_JPRB/)
KBO( :, 2,49, 7) = (/&
&2.1288E-05_JPRB,3.8375E-04_JPRB,6.1286E-04_JPRB,7.8566E-04_JPRB,8.2462E-04_JPRB/)
KBO( :, 3,49, 7) = (/&
&3.3501E-05_JPRB,4.3371E-04_JPRB,6.6869E-04_JPRB,8.3391E-04_JPRB,8.2791E-04_JPRB/)
KBO( :, 4,49, 7) = (/&
&5.0757E-05_JPRB,4.9477E-04_JPRB,7.3099E-04_JPRB,8.8650E-04_JPRB,8.2973E-04_JPRB/)
KBO( :, 5,49, 7) = (/&
&7.4391E-05_JPRB,5.7603E-04_JPRB,8.0512E-04_JPRB,9.4378E-04_JPRB,8.2902E-04_JPRB/)
KBO( :, 1,50, 7) = (/&
&8.9107E-06_JPRB,2.7028E-04_JPRB,4.5165E-04_JPRB,6.0203E-04_JPRB,6.7224E-04_JPRB/)
KBO( :, 2,50, 7) = (/&
&1.4889E-05_JPRB,3.0526E-04_JPRB,4.9281E-04_JPRB,6.3656E-04_JPRB,6.7754E-04_JPRB/)
KBO( :, 3,50, 7) = (/&
&2.3877E-05_JPRB,3.4554E-04_JPRB,5.3891E-04_JPRB,6.7691E-04_JPRB,6.8139E-04_JPRB/)
KBO( :, 4,50, 7) = (/&
&3.6771E-05_JPRB,3.9444E-04_JPRB,5.9020E-04_JPRB,7.2140E-04_JPRB,6.8414E-04_JPRB/)
KBO( :, 5,50, 7) = (/&
&5.4655E-05_JPRB,4.5942E-04_JPRB,6.5054E-04_JPRB,7.6968E-04_JPRB,6.8480E-04_JPRB/)
KBO( :, 1,51, 7) = (/&
&6.0961E-06_JPRB,2.1476E-04_JPRB,3.6280E-04_JPRB,4.8765E-04_JPRB,5.5078E-04_JPRB/)
KBO( :, 2,51, 7) = (/&
&1.0381E-05_JPRB,2.4307E-04_JPRB,3.9642E-04_JPRB,5.1588E-04_JPRB,5.5623E-04_JPRB/)
KBO( :, 3,51, 7) = (/&
&1.6982E-05_JPRB,2.7555E-04_JPRB,4.3451E-04_JPRB,5.4955E-04_JPRB,5.6027E-04_JPRB/)
KBO( :, 4,51, 7) = (/&
&2.6587E-05_JPRB,3.1466E-04_JPRB,4.7661E-04_JPRB,5.8697E-04_JPRB,5.6337E-04_JPRB/)
KBO( :, 5,51, 7) = (/&
&4.0101E-05_JPRB,3.6650E-04_JPRB,5.2570E-04_JPRB,6.2745E-04_JPRB,5.6478E-04_JPRB/)
KBO( :, 1,52, 7) = (/&
&4.1353E-06_JPRB,1.7061E-04_JPRB,2.9145E-04_JPRB,3.9501E-04_JPRB,4.5130E-04_JPRB/)
KBO( :, 2,52, 7) = (/&
&7.1818E-06_JPRB,1.9335E-04_JPRB,3.1863E-04_JPRB,4.1793E-04_JPRB,4.5663E-04_JPRB/)
KBO( :, 3,52, 7) = (/&
&1.1989E-05_JPRB,2.1956E-04_JPRB,3.4994E-04_JPRB,4.4575E-04_JPRB,4.6074E-04_JPRB/)
KBO( :, 4,52, 7) = (/&
&1.9102E-05_JPRB,2.5087E-04_JPRB,3.8455E-04_JPRB,4.7710E-04_JPRB,4.6395E-04_JPRB/)
KBO( :, 5,52, 7) = (/&
&2.9266E-05_JPRB,2.9208E-04_JPRB,4.2456E-04_JPRB,5.1110E-04_JPRB,4.6590E-04_JPRB/)
KBO( :, 1,53, 7) = (/&
&2.7771E-06_JPRB,1.3543E-04_JPRB,2.3402E-04_JPRB,3.1978E-04_JPRB,3.6971E-04_JPRB/)
KBO( :, 2,53, 7) = (/&
&4.9256E-06_JPRB,1.5363E-04_JPRB,2.5583E-04_JPRB,3.3830E-04_JPRB,3.7486E-04_JPRB/)
KBO( :, 3,53, 7) = (/&
&8.3927E-06_JPRB,1.7477E-04_JPRB,2.8146E-04_JPRB,3.6113E-04_JPRB,3.7892E-04_JPRB/)
KBO( :, 4,53, 7) = (/&
&1.3629E-05_JPRB,1.9978E-04_JPRB,3.0996E-04_JPRB,3.8736E-04_JPRB,3.8222E-04_JPRB/)
KBO( :, 5,53, 7) = (/&
&2.1224E-05_JPRB,2.3248E-04_JPRB,3.4254E-04_JPRB,4.1583E-04_JPRB,3.8453E-04_JPRB/)
KBO( :, 1,54, 7) = (/&
&1.8811E-06_JPRB,1.0783E-04_JPRB,1.8829E-04_JPRB,2.5915E-04_JPRB,3.0210E-04_JPRB/)
KBO( :, 2,54, 7) = (/&
&3.4084E-06_JPRB,1.2242E-04_JPRB,2.0578E-04_JPRB,2.7417E-04_JPRB,3.0673E-04_JPRB/)
KBO( :, 3,54, 7) = (/&
&5.9212E-06_JPRB,1.3950E-04_JPRB,2.2680E-04_JPRB,2.9292E-04_JPRB,3.1041E-04_JPRB/)
KBO( :, 4,54, 7) = (/&
&9.7966E-06_JPRB,1.5966E-04_JPRB,2.5030E-04_JPRB,3.1483E-04_JPRB,3.1342E-04_JPRB/)
KBO( :, 5,54, 7) = (/&
&1.5501E-05_JPRB,1.8577E-04_JPRB,2.7693E-04_JPRB,3.3870E-04_JPRB,3.1563E-04_JPRB/)
KBO( :, 1,55, 7) = (/&
&1.2736E-06_JPRB,8.5960E-05_JPRB,1.5164E-04_JPRB,2.1009E-04_JPRB,2.4656E-04_JPRB/)
KBO( :, 2,55, 7) = (/&
&2.3598E-06_JPRB,9.7655E-05_JPRB,1.6564E-04_JPRB,2.2229E-04_JPRB,2.5059E-04_JPRB/)
KBO( :, 3,55, 7) = (/&
&4.1776E-06_JPRB,1.1145E-04_JPRB,1.8284E-04_JPRB,2.3762E-04_JPRB,2.5377E-04_JPRB/)
KBO( :, 4,55, 7) = (/&
&7.0441E-06_JPRB,1.2773E-04_JPRB,2.0219E-04_JPRB,2.5588E-04_JPRB,2.5634E-04_JPRB/)
KBO( :, 5,55, 7) = (/&
&1.1323E-05_JPRB,1.4864E-04_JPRB,2.2410E-04_JPRB,2.7593E-04_JPRB,2.5827E-04_JPRB/)
KBO( :, 1,56, 7) = (/&
&8.5479E-07_JPRB,6.8495E-05_JPRB,1.2209E-04_JPRB,1.7021E-04_JPRB,2.0114E-04_JPRB/)
KBO( :, 2,56, 7) = (/&
&1.6225E-06_JPRB,7.7817E-05_JPRB,1.3325E-04_JPRB,1.8015E-04_JPRB,2.0463E-04_JPRB/)
KBO( :, 3,56, 7) = (/&
&2.9270E-06_JPRB,8.8970E-05_JPRB,1.4725E-04_JPRB,1.9262E-04_JPRB,2.0743E-04_JPRB/)
KBO( :, 4,56, 7) = (/&
&5.0340E-06_JPRB,1.0210E-04_JPRB,1.6318E-04_JPRB,2.0779E-04_JPRB,2.0965E-04_JPRB/)
KBO( :, 5,56, 7) = (/&
&8.2279E-06_JPRB,1.1881E-04_JPRB,1.8117E-04_JPRB,2.2455E-04_JPRB,2.1130E-04_JPRB/)
KBO( :, 1,57, 7) = (/&
&5.6832E-07_JPRB,5.4568E-05_JPRB,9.8248E-05_JPRB,1.3779E-04_JPRB,1.6394E-04_JPRB/)
KBO( :, 2,57, 7) = (/&
&1.1069E-06_JPRB,6.1982E-05_JPRB,1.0712E-04_JPRB,1.4596E-04_JPRB,1.6709E-04_JPRB/)
KBO( :, 3,57, 7) = (/&
&2.0353E-06_JPRB,7.0945E-05_JPRB,1.1847E-04_JPRB,1.5604E-04_JPRB,1.6951E-04_JPRB/)
KBO( :, 4,57, 7) = (/&
&3.5732E-06_JPRB,8.1530E-05_JPRB,1.3155E-04_JPRB,1.6855E-04_JPRB,1.7142E-04_JPRB/)
KBO( :, 5,57, 7) = (/&
&5.9454E-06_JPRB,9.4896E-05_JPRB,1.4631E-04_JPRB,1.8257E-04_JPRB,1.7286E-04_JPRB/)
KBO( :, 1,58, 7) = (/&
&3.7890E-07_JPRB,4.3568E-05_JPRB,7.9163E-05_JPRB,1.1161E-04_JPRB,1.3361E-04_JPRB/)
KBO( :, 2,58, 7) = (/&
&7.5700E-07_JPRB,4.9431E-05_JPRB,8.6199E-05_JPRB,1.1831E-04_JPRB,1.3638E-04_JPRB/)
KBO( :, 3,58, 7) = (/&
&1.4190E-06_JPRB,5.6651E-05_JPRB,9.5379E-05_JPRB,1.2647E-04_JPRB,1.3843E-04_JPRB/)
KBO( :, 4,58, 7) = (/&
&2.5422E-06_JPRB,6.5215E-05_JPRB,1.0612E-04_JPRB,1.3677E-04_JPRB,1.4007E-04_JPRB/)
KBO( :, 5,58, 7) = (/&
&4.3056E-06_JPRB,7.5939E-05_JPRB,1.1825E-04_JPRB,1.4847E-04_JPRB,1.4132E-04_JPRB/)
KBO( :, 1,59, 7) = (/&
&2.8711E-07_JPRB,3.5512E-05_JPRB,6.4676E-05_JPRB,9.1313E-05_JPRB,1.0905E-04_JPRB/)
KBO( :, 2,59, 7) = (/&
&5.8051E-07_JPRB,4.0372E-05_JPRB,7.0558E-05_JPRB,9.6940E-05_JPRB,1.1137E-04_JPRB/)
KBO( :, 3,59, 7) = (/&
&1.1009E-06_JPRB,4.6368E-05_JPRB,7.8242E-05_JPRB,1.0385E-04_JPRB,1.1298E-04_JPRB/)
KBO( :, 4,59, 7) = (/&
&1.9927E-06_JPRB,5.3528E-05_JPRB,8.7247E-05_JPRB,1.1259E-04_JPRB,1.1418E-04_JPRB/)
KBO( :, 5,59, 7) = (/&
&3.4060E-06_JPRB,6.2579E-05_JPRB,9.7497E-05_JPRB,1.2251E-04_JPRB,1.1509E-04_JPRB/)
KBO( :, 1,13, 8) = (/&
&2.3970E-02_JPRB,3.0710E-01_JPRB,5.4364E-01_JPRB,7.5219E-01_JPRB,9.5462E-01_JPRB/)
KBO( :, 2,13, 8) = (/&
&3.5910E-02_JPRB,3.2191E-01_JPRB,5.5986E-01_JPRB,7.6221E-01_JPRB,9.4753E-01_JPRB/)
KBO( :, 3,13, 8) = (/&
&5.1314E-02_JPRB,3.3704E-01_JPRB,5.7518E-01_JPRB,7.7250E-01_JPRB,9.3944E-01_JPRB/)
KBO( :, 4,13, 8) = (/&
&7.0544E-02_JPRB,3.5215E-01_JPRB,5.8965E-01_JPRB,7.8209E-01_JPRB,9.3187E-01_JPRB/)
KBO( :, 5,13, 8) = (/&
&9.4072E-02_JPRB,3.6813E-01_JPRB,6.0322E-01_JPRB,7.9095E-01_JPRB,9.2652E-01_JPRB/)
KBO( :, 1,14, 8) = (/&
&2.1394E-02_JPRB,2.9767E-01_JPRB,5.2636E-01_JPRB,7.2588E-01_JPRB,9.1476E-01_JPRB/)
KBO( :, 2,14, 8) = (/&
&3.2006E-02_JPRB,3.1221E-01_JPRB,5.4240E-01_JPRB,7.3771E-01_JPRB,9.0915E-01_JPRB/)
KBO( :, 3,14, 8) = (/&
&4.5714E-02_JPRB,3.2744E-01_JPRB,5.5760E-01_JPRB,7.4911E-01_JPRB,9.0264E-01_JPRB/)
KBO( :, 4,14, 8) = (/&
&6.3005E-02_JPRB,3.4291E-01_JPRB,5.7202E-01_JPRB,7.5985E-01_JPRB,8.9702E-01_JPRB/)
KBO( :, 5,14, 8) = (/&
&8.4224E-02_JPRB,3.5938E-01_JPRB,5.8648E-01_JPRB,7.6955E-01_JPRB,8.9207E-01_JPRB/)
KBO( :, 1,15, 8) = (/&
&1.9200E-02_JPRB,2.8555E-01_JPRB,5.0447E-01_JPRB,6.9471E-01_JPRB,8.6829E-01_JPRB/)
KBO( :, 2,15, 8) = (/&
&2.8674E-02_JPRB,2.9984E-01_JPRB,5.2000E-01_JPRB,7.0783E-01_JPRB,8.6420E-01_JPRB/)
KBO( :, 3,15, 8) = (/&
&4.1036E-02_JPRB,3.1465E-01_JPRB,5.3501E-01_JPRB,7.2026E-01_JPRB,8.6024E-01_JPRB/)
KBO( :, 4,15, 8) = (/&
&5.6691E-02_JPRB,3.3028E-01_JPRB,5.4991E-01_JPRB,7.3143E-01_JPRB,8.5592E-01_JPRB/)
KBO( :, 5,15, 8) = (/&
&7.5884E-02_JPRB,3.4766E-01_JPRB,5.6508E-01_JPRB,7.4152E-01_JPRB,8.5184E-01_JPRB/)
KBO( :, 1,16, 8) = (/&
&1.7280E-02_JPRB,2.7106E-01_JPRB,4.7797E-01_JPRB,6.5828E-01_JPRB,8.1566E-01_JPRB/)
KBO( :, 2,16, 8) = (/&
&2.5826E-02_JPRB,2.8505E-01_JPRB,4.9327E-01_JPRB,6.7219E-01_JPRB,8.1411E-01_JPRB/)
KBO( :, 3,16, 8) = (/&
&3.7038E-02_JPRB,2.9951E-01_JPRB,5.0847E-01_JPRB,6.8487E-01_JPRB,8.1174E-01_JPRB/)
KBO( :, 4,16, 8) = (/&
&5.1196E-02_JPRB,3.1526E-01_JPRB,5.2352E-01_JPRB,6.9628E-01_JPRB,8.0904E-01_JPRB/)
KBO( :, 5,16, 8) = (/&
&6.8473E-02_JPRB,3.3321E-01_JPRB,5.3879E-01_JPRB,7.0679E-01_JPRB,8.0649E-01_JPRB/)
KBO( :, 1,17, 8) = (/&
&1.5538E-02_JPRB,2.5421E-01_JPRB,4.4772E-01_JPRB,6.1710E-01_JPRB,7.5839E-01_JPRB/)
KBO( :, 2,17, 8) = (/&
&2.3272E-02_JPRB,2.6785E-01_JPRB,4.6279E-01_JPRB,6.3082E-01_JPRB,7.5816E-01_JPRB/)
KBO( :, 3,17, 8) = (/&
&3.3383E-02_JPRB,2.8231E-01_JPRB,4.7772E-01_JPRB,6.4345E-01_JPRB,7.5757E-01_JPRB/)
KBO( :, 4,17, 8) = (/&
&4.6070E-02_JPRB,2.9815E-01_JPRB,4.9276E-01_JPRB,6.5511E-01_JPRB,7.5658E-01_JPRB/)
KBO( :, 5,17, 8) = (/&
&6.1414E-02_JPRB,3.1621E-01_JPRB,5.0851E-01_JPRB,6.6619E-01_JPRB,7.5588E-01_JPRB/)
KBO( :, 1,18, 8) = (/&
&1.3967E-02_JPRB,2.3577E-01_JPRB,4.1440E-01_JPRB,5.7110E-01_JPRB,6.9644E-01_JPRB/)
KBO( :, 2,18, 8) = (/&
&2.0919E-02_JPRB,2.4897E-01_JPRB,4.2906E-01_JPRB,5.8444E-01_JPRB,6.9784E-01_JPRB/)
KBO( :, 3,18, 8) = (/&
&2.9927E-02_JPRB,2.6320E-01_JPRB,4.4386E-01_JPRB,5.9706E-01_JPRB,6.9881E-01_JPRB/)
KBO( :, 4,18, 8) = (/&
&4.1175E-02_JPRB,2.7935E-01_JPRB,4.5908E-01_JPRB,6.0918E-01_JPRB,6.9970E-01_JPRB/)
KBO( :, 5,18, 8) = (/&
&5.4768E-02_JPRB,2.9730E-01_JPRB,4.7517E-01_JPRB,6.2117E-01_JPRB,7.0068E-01_JPRB/)
KBO( :, 1,19, 8) = (/&
&1.2535E-02_JPRB,2.1612E-01_JPRB,3.7880E-01_JPRB,5.2193E-01_JPRB,6.3226E-01_JPRB/)
KBO( :, 2,19, 8) = (/&
&1.8709E-02_JPRB,2.2885E-01_JPRB,3.9316E-01_JPRB,5.3486E-01_JPRB,6.3494E-01_JPRB/)
KBO( :, 3,19, 8) = (/&
&2.6683E-02_JPRB,2.4307E-01_JPRB,4.0782E-01_JPRB,5.4746E-01_JPRB,6.3735E-01_JPRB/)
KBO( :, 4,19, 8) = (/&
&3.6602E-02_JPRB,2.5923E-01_JPRB,4.2323E-01_JPRB,5.6013E-01_JPRB,6.4003E-01_JPRB/)
KBO( :, 5,19, 8) = (/&
&4.8595E-02_JPRB,2.7710E-01_JPRB,4.3996E-01_JPRB,5.7286E-01_JPRB,6.4337E-01_JPRB/)
KBO( :, 1,20, 8) = (/&
&1.1287E-02_JPRB,1.9616E-01_JPRB,3.4278E-01_JPRB,4.7146E-01_JPRB,5.6767E-01_JPRB/)
KBO( :, 2,20, 8) = (/&
&1.6764E-02_JPRB,2.0859E-01_JPRB,3.5655E-01_JPRB,4.8417E-01_JPRB,5.7171E-01_JPRB/)
KBO( :, 3,20, 8) = (/&
&2.3811E-02_JPRB,2.2281E-01_JPRB,3.7110E-01_JPRB,4.9713E-01_JPRB,5.7584E-01_JPRB/)
KBO( :, 4,20, 8) = (/&
&3.2552E-02_JPRB,2.3876E-01_JPRB,3.8677E-01_JPRB,5.1039E-01_JPRB,5.8077E-01_JPRB/)
KBO( :, 5,20, 8) = (/&
&4.3159E-02_JPRB,2.5646E-01_JPRB,4.0398E-01_JPRB,5.2418E-01_JPRB,5.8653E-01_JPRB/)
KBO( :, 1,21, 8) = (/&
&1.0123E-02_JPRB,1.7642E-01_JPRB,3.0702E-01_JPRB,4.2164E-01_JPRB,5.0497E-01_JPRB/)
KBO( :, 2,21, 8) = (/&
&1.4960E-02_JPRB,1.8865E-01_JPRB,3.2047E-01_JPRB,4.3442E-01_JPRB,5.1019E-01_JPRB/)
KBO( :, 3,21, 8) = (/&
&2.1152E-02_JPRB,2.0268E-01_JPRB,3.3499E-01_JPRB,4.4767E-01_JPRB,5.1630E-01_JPRB/)
KBO( :, 4,21, 8) = (/&
&2.8843E-02_JPRB,2.1843E-01_JPRB,3.5106E-01_JPRB,4.6165E-01_JPRB,5.2357E-01_JPRB/)
KBO( :, 5,21, 8) = (/&
&3.8204E-02_JPRB,2.3577E-01_JPRB,3.6853E-01_JPRB,4.7644E-01_JPRB,5.3124E-01_JPRB/)
KBO( :, 1,22, 8) = (/&
&9.2874E-03_JPRB,1.5831E-01_JPRB,2.7358E-01_JPRB,3.7468E-01_JPRB,4.4590E-01_JPRB/)
KBO( :, 2,22, 8) = (/&
&1.3605E-02_JPRB,1.7047E-01_JPRB,2.8679E-01_JPRB,3.8765E-01_JPRB,4.5286E-01_JPRB/)
KBO( :, 3,22, 8) = (/&
&1.9114E-02_JPRB,1.8434E-01_JPRB,3.0159E-01_JPRB,4.0144E-01_JPRB,4.6097E-01_JPRB/)
KBO( :, 4,22, 8) = (/&
&2.5961E-02_JPRB,1.9982E-01_JPRB,3.1798E-01_JPRB,4.1606E-01_JPRB,4.6951E-01_JPRB/)
KBO( :, 5,22, 8) = (/&
&3.4349E-02_JPRB,2.1668E-01_JPRB,3.3570E-01_JPRB,4.3114E-01_JPRB,4.7729E-01_JPRB/)
KBO( :, 1,23, 8) = (/&
&8.4921E-03_JPRB,1.4152E-01_JPRB,2.4231E-01_JPRB,3.3110E-01_JPRB,3.9186E-01_JPRB/)
KBO( :, 2,23, 8) = (/&
&1.2342E-02_JPRB,1.5348E-01_JPRB,2.5569E-01_JPRB,3.4426E-01_JPRB,4.0022E-01_JPRB/)
KBO( :, 3,23, 8) = (/&
&1.7244E-02_JPRB,1.6712E-01_JPRB,2.7061E-01_JPRB,3.5816E-01_JPRB,4.0905E-01_JPRB/)
KBO( :, 4,23, 8) = (/&
&2.3366E-02_JPRB,1.8219E-01_JPRB,2.8684E-01_JPRB,3.7242E-01_JPRB,4.1729E-01_JPRB/)
KBO( :, 5,23, 8) = (/&
&3.0906E-02_JPRB,1.9826E-01_JPRB,3.0394E-01_JPRB,3.8658E-01_JPRB,4.2349E-01_JPRB/)
KBO( :, 1,24, 8) = (/&
&7.7535E-03_JPRB,1.2629E-01_JPRB,2.1405E-01_JPRB,2.9135E-01_JPRB,3.4301E-01_JPRB/)
KBO( :, 2,24, 8) = (/&
&1.1183E-02_JPRB,1.3800E-01_JPRB,2.2733E-01_JPRB,3.0427E-01_JPRB,3.5176E-01_JPRB/)
KBO( :, 3,24, 8) = (/&
&1.5576E-02_JPRB,1.5118E-01_JPRB,2.4185E-01_JPRB,3.1749E-01_JPRB,3.6002E-01_JPRB/)
KBO( :, 4,24, 8) = (/&
&2.1087E-02_JPRB,1.6543E-01_JPRB,2.5728E-01_JPRB,3.3050E-01_JPRB,3.6605E-01_JPRB/)
KBO( :, 5,24, 8) = (/&
&2.7862E-02_JPRB,1.8042E-01_JPRB,2.7311E-01_JPRB,3.4269E-01_JPRB,3.6924E-01_JPRB/)
KBO( :, 1,25, 8) = (/&
&7.0742E-03_JPRB,1.1262E-01_JPRB,1.8871E-01_JPRB,2.5540E-01_JPRB,2.9903E-01_JPRB/)
KBO( :, 2,25, 8) = (/&
&1.0155E-02_JPRB,1.2387E-01_JPRB,2.0149E-01_JPRB,2.6744E-01_JPRB,3.0694E-01_JPRB/)
KBO( :, 3,25, 8) = (/&
&1.4119E-02_JPRB,1.3621E-01_JPRB,2.1507E-01_JPRB,2.7908E-01_JPRB,3.1279E-01_JPRB/)
KBO( :, 4,25, 8) = (/&
&1.9079E-02_JPRB,1.4928E-01_JPRB,2.2897E-01_JPRB,2.8986E-01_JPRB,3.1583E-01_JPRB/)
KBO( :, 5,25, 8) = (/&
&2.5164E-02_JPRB,1.6305E-01_JPRB,2.4282E-01_JPRB,2.9961E-01_JPRB,3.1616E-01_JPRB/)
KBO( :, 1,26, 8) = (/&
&6.4819E-03_JPRB,1.0046E-01_JPRB,1.6616E-01_JPRB,2.2296E-01_JPRB,2.5906E-01_JPRB/)
KBO( :, 2,26, 8) = (/&
&9.2746E-03_JPRB,1.1094E-01_JPRB,1.7789E-01_JPRB,2.3321E-01_JPRB,2.6463E-01_JPRB/)
KBO( :, 3,26, 8) = (/&
&1.2860E-02_JPRB,1.2211E-01_JPRB,1.8982E-01_JPRB,2.4261E-01_JPRB,2.6762E-01_JPRB/)
KBO( :, 4,26, 8) = (/&
&1.7340E-02_JPRB,1.3390E-01_JPRB,2.0176E-01_JPRB,2.5109E-01_JPRB,2.6820E-01_JPRB/)
KBO( :, 5,26, 8) = (/&
&2.2797E-02_JPRB,1.4641E-01_JPRB,2.1346E-01_JPRB,2.5871E-01_JPRB,2.6701E-01_JPRB/)
KBO( :, 1,27, 8) = (/&
&5.9496E-03_JPRB,8.9354E-02_JPRB,1.4559E-01_JPRB,1.9301E-01_JPRB,2.2196E-01_JPRB/)
KBO( :, 2,27, 8) = (/&
&8.4823E-03_JPRB,9.8713E-02_JPRB,1.5575E-01_JPRB,2.0121E-01_JPRB,2.2502E-01_JPRB/)
KBO( :, 3,27, 8) = (/&
&1.1723E-02_JPRB,1.0860E-01_JPRB,1.6592E-01_JPRB,2.0857E-01_JPRB,2.2594E-01_JPRB/)
KBO( :, 4,27, 8) = (/&
&1.5760E-02_JPRB,1.1910E-01_JPRB,1.7588E-01_JPRB,2.1528E-01_JPRB,2.2532E-01_JPRB/)
KBO( :, 5,27, 8) = (/&
&2.0640E-02_JPRB,1.3042E-01_JPRB,1.8584E-01_JPRB,2.2158E-01_JPRB,2.2357E-01_JPRB/)
KBO( :, 1,28, 8) = (/&
&5.4648E-03_JPRB,7.8954E-02_JPRB,1.2664E-01_JPRB,1.6556E-01_JPRB,1.8790E-01_JPRB/)
KBO( :, 2,28, 8) = (/&
&7.7612E-03_JPRB,8.7134E-02_JPRB,1.3525E-01_JPRB,1.7197E-01_JPRB,1.8917E-01_JPRB/)
KBO( :, 3,28, 8) = (/&
&1.0688E-02_JPRB,9.5816E-02_JPRB,1.4371E-01_JPRB,1.7791E-01_JPRB,1.8910E-01_JPRB/)
KBO( :, 4,28, 8) = (/&
&1.4301E-02_JPRB,1.0515E-01_JPRB,1.5218E-01_JPRB,1.8352E-01_JPRB,1.8804E-01_JPRB/)
KBO( :, 5,28, 8) = (/&
&1.8668E-02_JPRB,1.1540E-01_JPRB,1.6098E-01_JPRB,1.8889E-01_JPRB,1.8616E-01_JPRB/)
KBO( :, 1,29, 8) = (/&
&5.0360E-03_JPRB,6.9325E-02_JPRB,1.0943E-01_JPRB,1.4091E-01_JPRB,1.5759E-01_JPRB/)
KBO( :, 2,29, 8) = (/&
&7.1202E-03_JPRB,7.6426E-02_JPRB,1.1663E-01_JPRB,1.4615E-01_JPRB,1.5798E-01_JPRB/)
KBO( :, 3,29, 8) = (/&
&9.7533E-03_JPRB,8.4055E-02_JPRB,1.2381E-01_JPRB,1.5115E-01_JPRB,1.5749E-01_JPRB/)
KBO( :, 4,29, 8) = (/&
&1.2997E-02_JPRB,9.2463E-02_JPRB,1.3122E-01_JPRB,1.5595E-01_JPRB,1.5628E-01_JPRB/)
KBO( :, 5,29, 8) = (/&
&1.6906E-02_JPRB,1.0185E-01_JPRB,1.3918E-01_JPRB,1.6061E-01_JPRB,1.5451E-01_JPRB/)
KBO( :, 1,30, 8) = (/&
&4.6402E-03_JPRB,6.0489E-02_JPRB,9.4043E-02_JPRB,1.1942E-01_JPRB,1.3140E-01_JPRB/)
KBO( :, 2,30, 8) = (/&
&6.5263E-03_JPRB,6.6689E-02_JPRB,1.0012E-01_JPRB,1.2384E-01_JPRB,1.3139E-01_JPRB/)
KBO( :, 3,30, 8) = (/&
&8.8957E-03_JPRB,7.3511E-02_JPRB,1.0635E-01_JPRB,1.2814E-01_JPRB,1.3072E-01_JPRB/)
KBO( :, 4,30, 8) = (/&
&1.1806E-02_JPRB,8.1191E-02_JPRB,1.1302E-01_JPRB,1.3230E-01_JPRB,1.2954E-01_JPRB/)
KBO( :, 5,30, 8) = (/&
&1.5321E-02_JPRB,8.9861E-02_JPRB,1.2036E-01_JPRB,1.3654E-01_JPRB,1.2795E-01_JPRB/)
KBO( :, 1,31, 8) = (/&
&4.2816E-03_JPRB,5.2594E-02_JPRB,8.0556E-02_JPRB,1.0100E-01_JPRB,1.0923E-01_JPRB/)
KBO( :, 2,31, 8) = (/&
&5.9928E-03_JPRB,5.8093E-02_JPRB,8.5788E-02_JPRB,1.0484E-01_JPRB,1.0901E-01_JPRB/)
KBO( :, 3,31, 8) = (/&
&8.1254E-03_JPRB,6.4313E-02_JPRB,9.1351E-02_JPRB,1.0855E-01_JPRB,1.0832E-01_JPRB/)
KBO( :, 4,31, 8) = (/&
&1.0750E-02_JPRB,7.1406E-02_JPRB,9.7440E-02_JPRB,1.1230E-01_JPRB,1.0725E-01_JPRB/)
KBO( :, 5,31, 8) = (/&
&1.3934E-02_JPRB,7.9435E-02_JPRB,1.0429E-01_JPRB,1.1627E-01_JPRB,1.0582E-01_JPRB/)
KBO( :, 1,32, 8) = (/&
&3.9575E-03_JPRB,4.5682E-02_JPRB,6.8898E-02_JPRB,8.5411E-02_JPRB,9.0602E-02_JPRB/)
KBO( :, 2,32, 8) = (/&
&5.5021E-03_JPRB,5.0658E-02_JPRB,7.3522E-02_JPRB,8.8727E-02_JPRB,9.0292E-02_JPRB/)
KBO( :, 3,32, 8) = (/&
&7.4345E-03_JPRB,5.6386E-02_JPRB,7.8565E-02_JPRB,9.2013E-02_JPRB,8.9633E-02_JPRB/)
KBO( :, 4,32, 8) = (/&
&9.8223E-03_JPRB,6.2960E-02_JPRB,8.4228E-02_JPRB,9.5465E-02_JPRB,8.8660E-02_JPRB/)
KBO( :, 5,32, 8) = (/&
&1.2730E-02_JPRB,7.0429E-02_JPRB,9.0625E-02_JPRB,9.9233E-02_JPRB,8.7449E-02_JPRB/)
KBO( :, 1,33, 8) = (/&
&3.6591E-03_JPRB,3.9715E-02_JPRB,5.8948E-02_JPRB,7.2241E-02_JPRB,7.5055E-02_JPRB/)
KBO( :, 2,33, 8) = (/&
&5.0639E-03_JPRB,4.4286E-02_JPRB,6.3097E-02_JPRB,7.5129E-02_JPRB,7.4722E-02_JPRB/)
KBO( :, 3,33, 8) = (/&
&6.8217E-03_JPRB,4.9606E-02_JPRB,6.7743E-02_JPRB,7.8113E-02_JPRB,7.4121E-02_JPRB/)
KBO( :, 4,33, 8) = (/&
&9.0010E-03_JPRB,5.5729E-02_JPRB,7.3038E-02_JPRB,8.1349E-02_JPRB,7.3284E-02_JPRB/)
KBO( :, 5,33, 8) = (/&
&1.1693E-02_JPRB,6.2702E-02_JPRB,7.9022E-02_JPRB,8.4992E-02_JPRB,7.2286E-02_JPRB/)
KBO( :, 1,34, 8) = (/&
&3.3424E-03_JPRB,3.4485E-02_JPRB,5.0364E-02_JPRB,6.1041E-02_JPRB,6.2108E-02_JPRB/)
KBO( :, 2,34, 8) = (/&
&4.6136E-03_JPRB,3.8708E-02_JPRB,5.4132E-02_JPRB,6.3612E-02_JPRB,6.1791E-02_JPRB/)
KBO( :, 3,34, 8) = (/&
&6.2081E-03_JPRB,4.3641E-02_JPRB,5.8453E-02_JPRB,6.6369E-02_JPRB,6.1269E-02_JPRB/)
KBO( :, 4,34, 8) = (/&
&8.2079E-03_JPRB,4.9328E-02_JPRB,6.3400E-02_JPRB,6.9443E-02_JPRB,6.0579E-02_JPRB/)
KBO( :, 5,34, 8) = (/&
&1.0690E-02_JPRB,5.5879E-02_JPRB,6.9026E-02_JPRB,7.2976E-02_JPRB,5.9770E-02_JPRB/)
KBO( :, 1,35, 8) = (/&
&2.9610E-03_JPRB,2.9708E-02_JPRB,4.2806E-02_JPRB,5.1414E-02_JPRB,5.1399E-02_JPRB/)
KBO( :, 2,35, 8) = (/&
&4.0852E-03_JPRB,3.3563E-02_JPRB,4.6239E-02_JPRB,5.3734E-02_JPRB,5.1129E-02_JPRB/)
KBO( :, 3,35, 8) = (/&
&5.5146E-03_JPRB,3.8090E-02_JPRB,5.0226E-02_JPRB,5.6294E-02_JPRB,5.0708E-02_JPRB/)
KBO( :, 4,35, 8) = (/&
&7.3191E-03_JPRB,4.3348E-02_JPRB,5.4809E-02_JPRB,5.9220E-02_JPRB,5.0169E-02_JPRB/)
KBO( :, 5,35, 8) = (/&
&9.5862E-03_JPRB,4.9447E-02_JPRB,6.0051E-02_JPRB,6.2576E-02_JPRB,4.9549E-02_JPRB/)
KBO( :, 1,36, 8) = (/&
&2.5291E-03_JPRB,2.5317E-02_JPRB,3.6139E-02_JPRB,4.3139E-02_JPRB,4.2550E-02_JPRB/)
KBO( :, 2,36, 8) = (/&
&3.5081E-03_JPRB,2.8787E-02_JPRB,3.9246E-02_JPRB,4.5245E-02_JPRB,4.2349E-02_JPRB/)
KBO( :, 3,36, 8) = (/&
&4.7623E-03_JPRB,3.2880E-02_JPRB,4.2875E-02_JPRB,4.7610E-02_JPRB,4.2034E-02_JPRB/)
KBO( :, 4,36, 8) = (/&
&6.3600E-03_JPRB,3.7684E-02_JPRB,4.7082E-02_JPRB,5.0344E-02_JPRB,4.1631E-02_JPRB/)
KBO( :, 5,36, 8) = (/&
&8.3828E-03_JPRB,4.3328E-02_JPRB,5.1915E-02_JPRB,5.3486E-02_JPRB,4.1174E-02_JPRB/)
KBO( :, 1,37, 8) = (/&
&2.0572E-03_JPRB,2.1190E-02_JPRB,3.0172E-02_JPRB,3.5966E-02_JPRB,3.5231E-02_JPRB/)
KBO( :, 2,37, 8) = (/&
&2.8742E-03_JPRB,2.4234E-02_JPRB,3.2921E-02_JPRB,3.7847E-02_JPRB,3.5097E-02_JPRB/)
KBO( :, 3,37, 8) = (/&
&3.9377E-03_JPRB,2.7856E-02_JPRB,3.6156E-02_JPRB,3.9991E-02_JPRB,3.4880E-02_JPRB/)
KBO( :, 4,37, 8) = (/&
&5.3075E-03_JPRB,3.2157E-02_JPRB,3.9929E-02_JPRB,4.2485E-02_JPRB,3.4595E-02_JPRB/)
KBO( :, 5,37, 8) = (/&
&7.0531E-03_JPRB,3.7266E-02_JPRB,4.4310E-02_JPRB,4.5361E-02_JPRB,3.4266E-02_JPRB/)
KBO( :, 1,38, 8) = (/&
&1.6668E-03_JPRB,1.7718E-02_JPRB,2.5179E-02_JPRB,2.9976E-02_JPRB,2.9178E-02_JPRB/)
KBO( :, 2,38, 8) = (/&
&2.3512E-03_JPRB,2.0388E-02_JPRB,2.7616E-02_JPRB,3.1654E-02_JPRB,2.9106E-02_JPRB/)
KBO( :, 3,38, 8) = (/&
&3.2489E-03_JPRB,2.3599E-02_JPRB,3.0491E-02_JPRB,3.3589E-02_JPRB,2.8965E-02_JPRB/)
KBO( :, 4,38, 8) = (/&
&4.4197E-03_JPRB,2.7448E-02_JPRB,3.3876E-02_JPRB,3.5861E-02_JPRB,2.8777E-02_JPRB/)
KBO( :, 5,38, 8) = (/&
&5.9291E-03_JPRB,3.2085E-02_JPRB,3.7857E-02_JPRB,3.8499E-02_JPRB,2.8558E-02_JPRB/)
KBO( :, 1,39, 8) = (/&
&1.3505E-03_JPRB,1.4824E-02_JPRB,2.1025E-02_JPRB,2.4988E-02_JPRB,2.4183E-02_JPRB/)
KBO( :, 2,39, 8) = (/&
&1.9237E-03_JPRB,1.7169E-02_JPRB,2.3181E-02_JPRB,2.6485E-02_JPRB,2.4157E-02_JPRB/)
KBO( :, 3,39, 8) = (/&
&2.6812E-03_JPRB,2.0015E-02_JPRB,2.5740E-02_JPRB,2.8232E-02_JPRB,2.4081E-02_JPRB/)
KBO( :, 4,39, 8) = (/&
&3.6890E-03_JPRB,2.3470E-02_JPRB,2.8781E-02_JPRB,3.0301E-02_JPRB,2.3974E-02_JPRB/)
KBO( :, 5,39, 8) = (/&
&4.9956E-03_JPRB,2.7688E-02_JPRB,3.2410E-02_JPRB,3.2726E-02_JPRB,2.3849E-02_JPRB/)
KBO( :, 1,40, 8) = (/&
&1.0535E-03_JPRB,1.2217E-02_JPRB,1.7388E-02_JPRB,2.0709E-02_JPRB,2.0019E-02_JPRB/)
KBO( :, 2,40, 8) = (/&
&1.5173E-03_JPRB,1.4233E-02_JPRB,1.9255E-02_JPRB,2.2025E-02_JPRB,2.0029E-02_JPRB/)
KBO( :, 3,40, 8) = (/&
&2.1424E-03_JPRB,1.6709E-02_JPRB,2.1499E-02_JPRB,2.3574E-02_JPRB,2.0001E-02_JPRB/)
KBO( :, 4,40, 8) = (/&
&2.9806E-03_JPRB,1.9754E-02_JPRB,2.4186E-02_JPRB,2.5425E-02_JPRB,1.9953E-02_JPRB/)
KBO( :, 5,40, 8) = (/&
&4.0841E-03_JPRB,2.3521E-02_JPRB,2.7438E-02_JPRB,2.7615E-02_JPRB,1.9891E-02_JPRB/)
KBO( :, 1,41, 8) = (/&
&8.1549E-04_JPRB,1.0039E-02_JPRB,1.4352E-02_JPRB,1.7141E-02_JPRB,1.6569E-02_JPRB/)
KBO( :, 2,41, 8) = (/&
&1.1896E-03_JPRB,1.1765E-02_JPRB,1.5963E-02_JPRB,1.8295E-02_JPRB,1.6609E-02_JPRB/)
KBO( :, 3,41, 8) = (/&
&1.7007E-03_JPRB,1.3910E-02_JPRB,1.7922E-02_JPRB,1.9664E-02_JPRB,1.6616E-02_JPRB/)
KBO( :, 4,41, 8) = (/&
&2.3967E-03_JPRB,1.6587E-02_JPRB,2.0295E-02_JPRB,2.1313E-02_JPRB,1.6608E-02_JPRB/)
KBO( :, 5,41, 8) = (/&
&3.3209E-03_JPRB,1.9941E-02_JPRB,2.3193E-02_JPRB,2.3279E-02_JPRB,1.6596E-02_JPRB/)
KBO( :, 1,42, 8) = (/&
&6.2885E-04_JPRB,8.2389E-03_JPRB,1.1838E-02_JPRB,1.4182E-02_JPRB,1.3717E-02_JPRB/)
KBO( :, 2,42, 8) = (/&
&9.3075E-04_JPRB,9.7147E-03_JPRB,1.3226E-02_JPRB,1.5189E-02_JPRB,1.3775E-02_JPRB/)
KBO( :, 3,42, 8) = (/&
&1.3476E-03_JPRB,1.1572E-02_JPRB,1.4934E-02_JPRB,1.6397E-02_JPRB,1.3812E-02_JPRB/)
KBO( :, 4,42, 8) = (/&
&1.9221E-03_JPRB,1.3921E-02_JPRB,1.7022E-02_JPRB,1.7862E-02_JPRB,1.3835E-02_JPRB/)
KBO( :, 5,42, 8) = (/&
&2.6974E-03_JPRB,1.6905E-02_JPRB,1.9608E-02_JPRB,1.9625E-02_JPRB,1.3858E-02_JPRB/)
KBO( :, 1,43, 8) = (/&
&4.7225E-04_JPRB,6.6911E-03_JPRB,9.6971E-03_JPRB,1.1682E-02_JPRB,1.1351E-02_JPRB/)
KBO( :, 2,43, 8) = (/&
&7.0933E-04_JPRB,7.9348E-03_JPRB,1.0877E-02_JPRB,1.2551E-02_JPRB,1.1424E-02_JPRB/)
KBO( :, 3,43, 8) = (/&
&1.0435E-03_JPRB,9.5155E-03_JPRB,1.2344E-02_JPRB,1.3602E-02_JPRB,1.1480E-02_JPRB/)
KBO( :, 4,43, 8) = (/&
&1.5082E-03_JPRB,1.1547E-02_JPRB,1.4158E-02_JPRB,1.4886E-02_JPRB,1.1523E-02_JPRB/)
KBO( :, 5,43, 8) = (/&
&2.1454E-03_JPRB,1.4163E-02_JPRB,1.6434E-02_JPRB,1.6450E-02_JPRB,1.1573E-02_JPRB/)
KBO( :, 1,44, 8) = (/&
&3.4902E-04_JPRB,5.4014E-03_JPRB,7.9122E-03_JPRB,9.5973E-03_JPRB,9.3906E-03_JPRB/)
KBO( :, 2,44, 8) = (/&
&5.3336E-04_JPRB,6.4385E-03_JPRB,8.9048E-03_JPRB,1.0341E-02_JPRB,9.4727E-03_JPRB/)
KBO( :, 3,44, 8) = (/&
&7.9641E-04_JPRB,7.7741E-03_JPRB,1.0155E-02_JPRB,1.1247E-02_JPRB,9.5408E-03_JPRB/)
KBO( :, 4,44, 8) = (/&
&1.1697E-03_JPRB,9.5107E-03_JPRB,1.1718E-02_JPRB,1.2366E-02_JPRB,9.5994E-03_JPRB/)
KBO( :, 5,44, 8) = (/&
&1.6866E-03_JPRB,1.1782E-02_JPRB,1.3700E-02_JPRB,1.3737E-02_JPRB,9.6629E-03_JPRB/)
KBO( :, 1,45, 8) = (/&
&2.5641E-04_JPRB,4.3524E-03_JPRB,6.4489E-03_JPRB,7.8776E-03_JPRB,7.7700E-03_JPRB/)
KBO( :, 2,45, 8) = (/&
&3.9819E-04_JPRB,5.2131E-03_JPRB,7.2796E-03_JPRB,8.5115E-03_JPRB,7.8565E-03_JPRB/)
KBO( :, 3,45, 8) = (/&
&6.0452E-04_JPRB,6.3356E-03_JPRB,8.3400E-03_JPRB,9.2883E-03_JPRB,7.9298E-03_JPRB/)
KBO( :, 4,45, 8) = (/&
&9.0225E-04_JPRB,7.8148E-03_JPRB,9.6818E-03_JPRB,1.0257E-02_JPRB,7.9978E-03_JPRB/)
KBO( :, 5,45, 8) = (/&
&1.3212E-03_JPRB,9.7779E-03_JPRB,1.1402E-02_JPRB,1.1457E-02_JPRB,8.0738E-03_JPRB/)
KBO( :, 1,46, 8) = (/&
&1.8524E-04_JPRB,3.4864E-03_JPRB,5.2341E-03_JPRB,6.4466E-03_JPRB,6.4230E-03_JPRB/)
KBO( :, 2,46, 8) = (/&
&2.9313E-04_JPRB,4.1931E-03_JPRB,5.9228E-03_JPRB,6.9831E-03_JPRB,6.5117E-03_JPRB/)
KBO( :, 3,46, 8) = (/&
&4.5241E-04_JPRB,5.1271E-03_JPRB,6.8142E-03_JPRB,7.6439E-03_JPRB,6.5889E-03_JPRB/)
KBO( :, 4,46, 8) = (/&
&6.8674E-04_JPRB,6.3729E-03_JPRB,7.9564E-03_JPRB,8.4768E-03_JPRB,6.6644E-03_JPRB/)
KBO( :, 5,46, 8) = (/&
&1.0220E-03_JPRB,8.0538E-03_JPRB,9.4380E-03_JPRB,9.5193E-03_JPRB,6.7476E-03_JPRB/)
KBO( :, 1,47, 8) = (/&
&1.3000E-04_JPRB,2.7663E-03_JPRB,4.2208E-03_JPRB,5.2521E-03_JPRB,5.3026E-03_JPRB/)
KBO( :, 2,47, 8) = (/&
&2.1025E-04_JPRB,3.3363E-03_JPRB,4.7828E-03_JPRB,5.7020E-03_JPRB,5.3902E-03_JPRB/)
KBO( :, 3,47, 8) = (/&
&3.3047E-04_JPRB,4.0995E-03_JPRB,5.5201E-03_JPRB,6.2559E-03_JPRB,5.4679E-03_JPRB/)
KBO( :, 4,47, 8) = (/&
&5.1029E-04_JPRB,5.1296E-03_JPRB,6.4755E-03_JPRB,6.9601E-03_JPRB,5.5444E-03_JPRB/)
KBO( :, 5,47, 8) = (/&
&7.7317E-04_JPRB,6.5403E-03_JPRB,7.7293E-03_JPRB,7.8503E-03_JPRB,5.6289E-03_JPRB/)
KBO( :, 1,48, 8) = (/&
&9.0250E-05_JPRB,2.1914E-03_JPRB,3.3994E-03_JPRB,4.2738E-03_JPRB,4.3771E-03_JPRB/)
KBO( :, 2,48, 8) = (/&
&1.4933E-04_JPRB,2.6470E-03_JPRB,3.8547E-03_JPRB,4.6490E-03_JPRB,4.4611E-03_JPRB/)
KBO( :, 3,48, 8) = (/&
&2.3950E-04_JPRB,3.2661E-03_JPRB,4.4586E-03_JPRB,5.1091E-03_JPRB,4.5366E-03_JPRB/)
KBO( :, 4,48, 8) = (/&
&3.7635E-04_JPRB,4.1116E-03_JPRB,5.2534E-03_JPRB,5.7004E-03_JPRB,4.6124E-03_JPRB/)
KBO( :, 5,48, 8) = (/&
&5.8082E-04_JPRB,5.2884E-03_JPRB,6.3086E-03_JPRB,6.4573E-03_JPRB,4.6977E-03_JPRB/)
KBO( :, 1,49, 8) = (/&
&6.1993E-05_JPRB,1.7331E-03_JPRB,2.7330E-03_JPRB,3.4719E-03_JPRB,3.6111E-03_JPRB/)
KBO( :, 2,49, 8) = (/&
&1.0511E-04_JPRB,2.0938E-03_JPRB,3.1004E-03_JPRB,3.7836E-03_JPRB,3.6915E-03_JPRB/)
KBO( :, 3,49, 8) = (/&
&1.7216E-04_JPRB,2.5932E-03_JPRB,3.5917E-03_JPRB,4.1650E-03_JPRB,3.7653E-03_JPRB/)
KBO( :, 4,49, 8) = (/&
&2.7551E-04_JPRB,3.2829E-03_JPRB,4.2486E-03_JPRB,4.6580E-03_JPRB,3.8405E-03_JPRB/)
KBO( :, 5,49, 8) = (/&
&4.3301E-04_JPRB,4.2570E-03_JPRB,5.1317E-03_JPRB,5.2985E-03_JPRB,3.9263E-03_JPRB/)
KBO( :, 1,50, 8) = (/&
&4.2678E-05_JPRB,1.3745E-03_JPRB,2.2002E-03_JPRB,2.8212E-03_JPRB,2.9737E-03_JPRB/)
KBO( :, 2,50, 8) = (/&
&7.4146E-05_JPRB,1.6605E-03_JPRB,2.4974E-03_JPRB,3.0815E-03_JPRB,3.0479E-03_JPRB/)
KBO( :, 3,50, 8) = (/&
&1.2406E-04_JPRB,2.0639E-03_JPRB,2.8982E-03_JPRB,3.3988E-03_JPRB,3.1188E-03_JPRB/)
KBO( :, 4,50, 8) = (/&
&2.0253E-04_JPRB,2.6282E-03_JPRB,3.4425E-03_JPRB,3.8116E-03_JPRB,3.1913E-03_JPRB/)
KBO( :, 5,50, 8) = (/&
&3.2424E-04_JPRB,3.4369E-03_JPRB,4.1830E-03_JPRB,4.3547E-03_JPRB,3.2730E-03_JPRB/)
KBO( :, 1,51, 8) = (/&
&2.9237E-05_JPRB,1.0909E-03_JPRB,1.7714E-03_JPRB,2.2917E-03_JPRB,2.4464E-03_JPRB/)
KBO( :, 2,51, 8) = (/&
&5.2166E-05_JPRB,1.3176E-03_JPRB,2.0125E-03_JPRB,2.5102E-03_JPRB,2.5148E-03_JPRB/)
KBO( :, 3,51, 8) = (/&
&8.9091E-05_JPRB,1.6426E-03_JPRB,2.3388E-03_JPRB,2.7738E-03_JPRB,2.5806E-03_JPRB/)
KBO( :, 4,51, 8) = (/&
&1.4840E-04_JPRB,2.1028E-03_JPRB,2.7878E-03_JPRB,3.1176E-03_JPRB,2.6477E-03_JPRB/)
KBO( :, 5,51, 8) = (/&
&2.4207E-04_JPRB,2.7714E-03_JPRB,3.4063E-03_JPRB,3.5762E-03_JPRB,2.7227E-03_JPRB/)
KBO( :, 1,52, 8) = (/&
&1.9807E-05_JPRB,8.6538E-04_JPRB,1.4249E-03_JPRB,1.8595E-03_JPRB,2.0124E-03_JPRB/)
KBO( :, 2,52, 8) = (/&
&3.6322E-05_JPRB,1.0438E-03_JPRB,1.6200E-03_JPRB,2.0422E-03_JPRB,2.0750E-03_JPRB/)
KBO( :, 3,52, 8) = (/&
&6.3515E-05_JPRB,1.3037E-03_JPRB,1.8836E-03_JPRB,2.2603E-03_JPRB,2.1352E-03_JPRB/)
KBO( :, 4,52, 8) = (/&
&1.0788E-04_JPRB,1.6767E-03_JPRB,2.2517E-03_JPRB,2.5448E-03_JPRB,2.1970E-03_JPRB/)
KBO( :, 5,52, 8) = (/&
&1.7958E-04_JPRB,2.2260E-03_JPRB,2.7651E-03_JPRB,2.9295E-03_JPRB,2.2657E-03_JPRB/)
KBO( :, 1,53, 8) = (/&
&1.3242E-05_JPRB,6.8573E-04_JPRB,1.1446E-03_JPRB,1.5067E-03_JPRB,1.6550E-03_JPRB/)
KBO( :, 2,53, 8) = (/&
&2.5022E-05_JPRB,8.2535E-04_JPRB,1.3018E-03_JPRB,1.6587E-03_JPRB,1.7117E-03_JPRB/)
KBO( :, 3,53, 8) = (/&
&4.4849E-05_JPRB,1.0313E-03_JPRB,1.5135E-03_JPRB,1.8385E-03_JPRB,1.7670E-03_JPRB/)
KBO( :, 4,53, 8) = (/&
&7.7724E-05_JPRB,1.3321E-03_JPRB,1.8130E-03_JPRB,2.0729E-03_JPRB,1.8239E-03_JPRB/)
KBO( :, 5,53, 8) = (/&
&1.3199E-04_JPRB,1.7794E-03_JPRB,2.2365E-03_JPRB,2.3931E-03_JPRB,1.8874E-03_JPRB/)
KBO( :, 1,54, 8) = (/&
&8.9248E-06_JPRB,5.4556E-04_JPRB,9.2163E-04_JPRB,1.2225E-03_JPRB,1.3566E-03_JPRB/)
KBO( :, 2,54, 8) = (/&
&1.7372E-05_JPRB,6.5581E-04_JPRB,1.0492E-03_JPRB,1.3494E-03_JPRB,1.4063E-03_JPRB/)
KBO( :, 3,54, 8) = (/&
&3.1907E-05_JPRB,8.1979E-04_JPRB,1.2202E-03_JPRB,1.4983E-03_JPRB,1.4551E-03_JPRB/)
KBO( :, 4,54, 8) = (/&
&5.6506E-05_JPRB,1.0634E-03_JPRB,1.4647E-03_JPRB,1.6922E-03_JPRB,1.5046E-03_JPRB/)
KBO( :, 5,54, 8) = (/&
&9.7836E-05_JPRB,1.4301E-03_JPRB,1.8159E-03_JPRB,1.9597E-03_JPRB,1.5596E-03_JPRB/)
KBO( :, 1,55, 8) = (/&
&6.0009E-06_JPRB,4.3459E-04_JPRB,7.4215E-04_JPRB,9.9172E-04_JPRB,1.1093E-03_JPRB/)
KBO( :, 2,55, 8) = (/&
&1.2050E-05_JPRB,5.2184E-04_JPRB,8.4618E-04_JPRB,1.0977E-03_JPRB,1.1520E-03_JPRB/)
KBO( :, 3,55, 8) = (/&
&2.2697E-05_JPRB,6.5227E-04_JPRB,9.8427E-04_JPRB,1.2212E-03_JPRB,1.1941E-03_JPRB/)
KBO( :, 4,55, 8) = (/&
&4.1051E-05_JPRB,8.4944E-04_JPRB,1.1837E-03_JPRB,1.3815E-03_JPRB,1.2361E-03_JPRB/)
KBO( :, 5,55, 8) = (/&
&7.2472E-05_JPRB,1.1494E-03_JPRB,1.4743E-03_JPRB,1.6046E-03_JPRB,1.2823E-03_JPRB/)
KBO( :, 1,56, 8) = (/&
&3.9898E-06_JPRB,3.4589E-04_JPRB,5.9689E-04_JPRB,8.0352E-04_JPRB,9.0649E-04_JPRB/)
KBO( :, 2,56, 8) = (/&
&8.2750E-06_JPRB,4.1470E-04_JPRB,6.8153E-04_JPRB,8.9166E-04_JPRB,9.4301E-04_JPRB/)
KBO( :, 3,56, 8) = (/&
&1.6003E-05_JPRB,5.1786E-04_JPRB,7.9279E-04_JPRB,9.9410E-04_JPRB,9.7913E-04_JPRB/)
KBO( :, 4,56, 8) = (/&
&2.9587E-05_JPRB,6.7655E-04_JPRB,9.5450E-04_JPRB,1.1258E-03_JPRB,1.0149E-03_JPRB/)
KBO( :, 5,56, 8) = (/&
&5.3280E-05_JPRB,9.2055E-04_JPRB,1.1938E-03_JPRB,1.3111E-03_JPRB,1.0536E-03_JPRB/)
KBO( :, 1,57, 8) = (/&
&2.6173E-06_JPRB,2.7500E-04_JPRB,4.7940E-04_JPRB,6.5022E-04_JPRB,7.4014E-04_JPRB/)
KBO( :, 2,57, 8) = (/&
&5.6185E-06_JPRB,3.2928E-04_JPRB,5.4834E-04_JPRB,7.2338E-04_JPRB,7.7148E-04_JPRB/)
KBO( :, 3,57, 8) = (/&
&1.1178E-05_JPRB,4.1034E-04_JPRB,6.3758E-04_JPRB,8.0791E-04_JPRB,8.0223E-04_JPRB/)
KBO( :, 4,57, 8) = (/&
&2.1131E-05_JPRB,5.3714E-04_JPRB,7.6779E-04_JPRB,9.1604E-04_JPRB,8.3279E-04_JPRB/)
KBO( :, 5,57, 8) = (/&
&3.8855E-05_JPRB,7.3446E-04_JPRB,9.6373E-04_JPRB,1.0689E-03_JPRB,8.6527E-04_JPRB/)
KBO( :, 1,58, 8) = (/&
&1.7187E-06_JPRB,2.1897E-04_JPRB,3.8537E-04_JPRB,5.2636E-04_JPRB,6.0391E-04_JPRB/)
KBO( :, 2,58, 8) = (/&
&3.8204E-06_JPRB,2.6201E-04_JPRB,4.4157E-04_JPRB,5.8689E-04_JPRB,6.3061E-04_JPRB/)
KBO( :, 3,58, 8) = (/&
&7.8175E-06_JPRB,3.2596E-04_JPRB,5.1345E-04_JPRB,6.5702E-04_JPRB,6.5669E-04_JPRB/)
KBO( :, 4,58, 8) = (/&
&1.5128E-05_JPRB,4.2731E-04_JPRB,6.1848E-04_JPRB,7.4589E-04_JPRB,6.8257E-04_JPRB/)
KBO( :, 5,58, 8) = (/&
&2.8383E-05_JPRB,5.8709E-04_JPRB,7.7891E-04_JPRB,8.7185E-04_JPRB,7.0967E-04_JPRB/)
KBO( :, 1,59, 8) = (/&
&1.3071E-06_JPRB,1.7971E-04_JPRB,3.1713E-04_JPRB,4.3408E-04_JPRB,4.9479E-04_JPRB/)
KBO( :, 2,59, 8) = (/&
&2.9593E-06_JPRB,2.1590E-04_JPRB,3.6455E-04_JPRB,4.8545E-04_JPRB,5.1653E-04_JPRB/)
KBO( :, 3,59, 8) = (/&
&6.1606E-06_JPRB,2.7044E-04_JPRB,4.2589E-04_JPRB,5.4538E-04_JPRB,5.3752E-04_JPRB/)
KBO( :, 4,59, 8) = (/&
&1.2116E-05_JPRB,3.5815E-04_JPRB,5.1701E-04_JPRB,6.2252E-04_JPRB,5.5854E-04_JPRB/)
KBO( :, 5,59, 8) = (/&
&2.3132E-05_JPRB,4.9905E-04_JPRB,6.5830E-04_JPRB,7.3365E-04_JPRB,5.8023E-04_JPRB/)
KBO( :, 1,13, 9) = (/&
&1.6103E-01_JPRB,6.6158E-01_JPRB,1.1273E+00_JPRB,1.5637E+00_JPRB,2.0193E+00_JPRB/)
KBO( :, 2,13, 9) = (/&
&2.3702E-01_JPRB,7.0502E-01_JPRB,1.1597E+00_JPRB,1.5650E+00_JPRB,1.9887E+00_JPRB/)
KBO( :, 3,13, 9) = (/&
&3.3165E-01_JPRB,7.5350E-01_JPRB,1.1971E+00_JPRB,1.5759E+00_JPRB,1.9602E+00_JPRB/)
KBO( :, 4,13, 9) = (/&
&4.4557E-01_JPRB,8.0998E-01_JPRB,1.2356E+00_JPRB,1.5909E+00_JPRB,1.9329E+00_JPRB/)
KBO( :, 5,13, 9) = (/&
&5.7859E-01_JPRB,8.7605E-01_JPRB,1.2746E+00_JPRB,1.6061E+00_JPRB,1.9056E+00_JPRB/)
KBO( :, 1,14, 9) = (/&
&1.4761E-01_JPRB,6.9347E-01_JPRB,1.1794E+00_JPRB,1.6262E+00_JPRB,2.0952E+00_JPRB/)
KBO( :, 2,14, 9) = (/&
&2.1664E-01_JPRB,7.3539E-01_JPRB,1.2185E+00_JPRB,1.6328E+00_JPRB,2.0656E+00_JPRB/)
KBO( :, 3,14, 9) = (/&
&3.0271E-01_JPRB,7.8091E-01_JPRB,1.2580E+00_JPRB,1.6489E+00_JPRB,2.0363E+00_JPRB/)
KBO( :, 4,14, 9) = (/&
&4.0599E-01_JPRB,8.3259E-01_JPRB,1.2961E+00_JPRB,1.6672E+00_JPRB,2.0067E+00_JPRB/)
KBO( :, 5,14, 9) = (/&
&5.2635E-01_JPRB,8.9136E-01_JPRB,1.3335E+00_JPRB,1.6865E+00_JPRB,1.9784E+00_JPRB/)
KBO( :, 1,15, 9) = (/&
&1.3457E-01_JPRB,7.2100E-01_JPRB,1.2219E+00_JPRB,1.6745E+00_JPRB,2.1504E+00_JPRB/)
KBO( :, 2,15, 9) = (/&
&1.9694E-01_JPRB,7.6310E-01_JPRB,1.2659E+00_JPRB,1.6872E+00_JPRB,2.1231E+00_JPRB/)
KBO( :, 3,15, 9) = (/&
&2.7439E-01_JPRB,8.0691E-01_JPRB,1.3081E+00_JPRB,1.7082E+00_JPRB,2.0944E+00_JPRB/)
KBO( :, 4,15, 9) = (/&
&3.6719E-01_JPRB,8.5456E-01_JPRB,1.3474E+00_JPRB,1.7304E+00_JPRB,2.0661E+00_JPRB/)
KBO( :, 5,15, 9) = (/&
&4.7561E-01_JPRB,9.0769E-01_JPRB,1.3846E+00_JPRB,1.7533E+00_JPRB,2.0378E+00_JPRB/)
KBO( :, 1,16, 9) = (/&
&1.2205E-01_JPRB,7.4077E-01_JPRB,1.2541E+00_JPRB,1.7073E+00_JPRB,2.1827E+00_JPRB/)
KBO( :, 2,16, 9) = (/&
&1.7791E-01_JPRB,7.8396E-01_JPRB,1.3002E+00_JPRB,1.7270E+00_JPRB,2.1581E+00_JPRB/)
KBO( :, 3,16, 9) = (/&
&2.4715E-01_JPRB,8.2834E-01_JPRB,1.3436E+00_JPRB,1.7521E+00_JPRB,2.1327E+00_JPRB/)
KBO( :, 4,16, 9) = (/&
&3.3034E-01_JPRB,8.7418E-01_JPRB,1.3847E+00_JPRB,1.7782E+00_JPRB,2.1067E+00_JPRB/)
KBO( :, 5,16, 9) = (/&
&4.2786E-01_JPRB,9.2279E-01_JPRB,1.4244E+00_JPRB,1.8037E+00_JPRB,2.0808E+00_JPRB/)
KBO( :, 1,17, 9) = (/&
&1.0982E-01_JPRB,7.5143E-01_JPRB,1.2725E+00_JPRB,1.7242E+00_JPRB,2.1909E+00_JPRB/)
KBO( :, 2,17, 9) = (/&
&1.5953E-01_JPRB,7.9549E-01_JPRB,1.3193E+00_JPRB,1.7501E+00_JPRB,2.1703E+00_JPRB/)
KBO( :, 3,17, 9) = (/&
&2.2127E-01_JPRB,8.4054E-01_JPRB,1.3636E+00_JPRB,1.7793E+00_JPRB,2.1486E+00_JPRB/)
KBO( :, 4,17, 9) = (/&
&2.9584E-01_JPRB,8.8682E-01_JPRB,1.4059E+00_JPRB,1.8091E+00_JPRB,2.1266E+00_JPRB/)
KBO( :, 5,17, 9) = (/&
&3.8385E-01_JPRB,9.3422E-01_JPRB,1.4466E+00_JPRB,1.8364E+00_JPRB,2.1039E+00_JPRB/)
KBO( :, 1,18, 9) = (/&
&9.8329E-02_JPRB,7.5240E-01_JPRB,1.2756E+00_JPRB,1.7244E+00_JPRB,2.1757E+00_JPRB/)
KBO( :, 2,18, 9) = (/&
&1.4251E-01_JPRB,7.9706E-01_JPRB,1.3228E+00_JPRB,1.7556E+00_JPRB,2.1597E+00_JPRB/)
KBO( :, 3,18, 9) = (/&
&1.9773E-01_JPRB,8.4264E-01_JPRB,1.3673E+00_JPRB,1.7888E+00_JPRB,2.1427E+00_JPRB/)
KBO( :, 4,18, 9) = (/&
&2.6482E-01_JPRB,8.8901E-01_JPRB,1.4101E+00_JPRB,1.8204E+00_JPRB,2.1245E+00_JPRB/)
KBO( :, 5,18, 9) = (/&
&3.4448E-01_JPRB,9.3666E-01_JPRB,1.4514E+00_JPRB,1.8483E+00_JPRB,2.1059E+00_JPRB/)
KBO( :, 1,19, 9) = (/&
&8.7815E-02_JPRB,7.4384E-01_JPRB,1.2637E+00_JPRB,1.7067E+00_JPRB,2.1362E+00_JPRB/)
KBO( :, 2,19, 9) = (/&
&1.2725E-01_JPRB,7.8828E-01_JPRB,1.3102E+00_JPRB,1.7428E+00_JPRB,2.1257E+00_JPRB/)
KBO( :, 3,19, 9) = (/&
&1.7679E-01_JPRB,8.3379E-01_JPRB,1.3547E+00_JPRB,1.7786E+00_JPRB,2.1135E+00_JPRB/)
KBO( :, 4,19, 9) = (/&
&2.3728E-01_JPRB,8.8010E-01_JPRB,1.3977E+00_JPRB,1.8108E+00_JPRB,2.0991E+00_JPRB/)
KBO( :, 5,19, 9) = (/&
&3.0895E-01_JPRB,9.2824E-01_JPRB,1.4393E+00_JPRB,1.8391E+00_JPRB,2.0837E+00_JPRB/)
KBO( :, 1,20, 9) = (/&
&7.9041E-02_JPRB,7.2700E-01_JPRB,1.2374E+00_JPRB,1.6719E+00_JPRB,2.0747E+00_JPRB/)
KBO( :, 2,20, 9) = (/&
&1.1454E-01_JPRB,7.7070E-01_JPRB,1.2831E+00_JPRB,1.7109E+00_JPRB,2.0685E+00_JPRB/)
KBO( :, 3,20, 9) = (/&
&1.5930E-01_JPRB,8.1568E-01_JPRB,1.3273E+00_JPRB,1.7472E+00_JPRB,2.0604E+00_JPRB/)
KBO( :, 4,20, 9) = (/&
&2.1376E-01_JPRB,8.6194E-01_JPRB,1.3702E+00_JPRB,1.7799E+00_JPRB,2.0509E+00_JPRB/)
KBO( :, 5,20, 9) = (/&
&2.7842E-01_JPRB,9.1045E-01_JPRB,1.4124E+00_JPRB,1.8091E+00_JPRB,2.0408E+00_JPRB/)
KBO( :, 1,21, 9) = (/&
&7.1445E-02_JPRB,7.0244E-01_JPRB,1.1970E+00_JPRB,1.6199E+00_JPRB,1.9923E+00_JPRB/)
KBO( :, 2,21, 9) = (/&
&1.0353E-01_JPRB,7.4522E-01_JPRB,1.2418E+00_JPRB,1.6596E+00_JPRB,1.9909E+00_JPRB/)
KBO( :, 3,21, 9) = (/&
&1.4384E-01_JPRB,7.8934E-01_JPRB,1.2854E+00_JPRB,1.6962E+00_JPRB,1.9875E+00_JPRB/)
KBO( :, 4,21, 9) = (/&
&1.9307E-01_JPRB,8.3547E-01_JPRB,1.3286E+00_JPRB,1.7297E+00_JPRB,1.9830E+00_JPRB/)
KBO( :, 5,21, 9) = (/&
&2.5151E-01_JPRB,8.8443E-01_JPRB,1.3716E+00_JPRB,1.7608E+00_JPRB,1.9785E+00_JPRB/)
KBO( :, 1,22, 9) = (/&
&6.6536E-02_JPRB,6.7362E-01_JPRB,1.1476E+00_JPRB,1.5553E+00_JPRB,1.8930E+00_JPRB/)
KBO( :, 2,22, 9) = (/&
&9.5961E-02_JPRB,7.1546E-01_JPRB,1.1915E+00_JPRB,1.5946E+00_JPRB,1.8960E+00_JPRB/)
KBO( :, 3,22, 9) = (/&
&1.3293E-01_JPRB,7.5906E-01_JPRB,1.2350E+00_JPRB,1.6314E+00_JPRB,1.8977E+00_JPRB/)
KBO( :, 4,22, 9) = (/&
&1.7791E-01_JPRB,8.0536E-01_JPRB,1.2788E+00_JPRB,1.6663E+00_JPRB,1.8991E+00_JPRB/)
KBO( :, 5,22, 9) = (/&
&2.3124E-01_JPRB,8.5502E-01_JPRB,1.3230E+00_JPRB,1.6998E+00_JPRB,1.9008E+00_JPRB/)
KBO( :, 1,23, 9) = (/&
&6.2130E-02_JPRB,6.3989E-01_JPRB,1.0889E+00_JPRB,1.4764E+00_JPRB,1.7800E+00_JPRB/)
KBO( :, 2,23, 9) = (/&
&8.9203E-02_JPRB,6.8080E-01_JPRB,1.1324E+00_JPRB,1.5163E+00_JPRB,1.7885E+00_JPRB/)
KBO( :, 3,23, 9) = (/&
&1.2310E-01_JPRB,7.2420E-01_JPRB,1.1763E+00_JPRB,1.5547E+00_JPRB,1.7963E+00_JPRB/)
KBO( :, 4,23, 9) = (/&
&1.6423E-01_JPRB,7.7098E-01_JPRB,1.2210E+00_JPRB,1.5918E+00_JPRB,1.8040E+00_JPRB/)
KBO( :, 5,23, 9) = (/&
&2.1277E-01_JPRB,8.2154E-01_JPRB,1.2673E+00_JPRB,1.6285E+00_JPRB,1.8132E+00_JPRB/)
KBO( :, 1,24, 9) = (/&
&5.8273E-02_JPRB,6.0306E-01_JPRB,1.0238E+00_JPRB,1.3884E+00_JPRB,1.6590E+00_JPRB/)
KBO( :, 2,24, 9) = (/&
&8.3232E-02_JPRB,6.4338E-01_JPRB,1.0676E+00_JPRB,1.4297E+00_JPRB,1.6731E+00_JPRB/)
KBO( :, 3,24, 9) = (/&
&1.1427E-01_JPRB,6.8692E-01_JPRB,1.1126E+00_JPRB,1.4703E+00_JPRB,1.6874E+00_JPRB/)
KBO( :, 4,24, 9) = (/&
&1.5163E-01_JPRB,7.3448E-01_JPRB,1.1591E+00_JPRB,1.5108E+00_JPRB,1.7035E+00_JPRB/)
KBO( :, 5,24, 9) = (/&
&1.9552E-01_JPRB,7.8610E-01_JPRB,1.2077E+00_JPRB,1.5519E+00_JPRB,1.7219E+00_JPRB/)
KBO( :, 1,25, 9) = (/&
&5.4812E-02_JPRB,5.6477E-01_JPRB,9.5569E-01_JPRB,1.2954E+00_JPRB,1.5347E+00_JPRB/)
KBO( :, 2,25, 9) = (/&
&7.7748E-02_JPRB,6.0521E-01_JPRB,1.0005E+00_JPRB,1.3386E+00_JPRB,1.5551E+00_JPRB/)
KBO( :, 3,25, 9) = (/&
&1.0600E-01_JPRB,6.4947E-01_JPRB,1.0471E+00_JPRB,1.3828E+00_JPRB,1.5779E+00_JPRB/)
KBO( :, 4,25, 9) = (/&
&1.3990E-01_JPRB,6.9799E-01_JPRB,1.0963E+00_JPRB,1.4282E+00_JPRB,1.6034E+00_JPRB/)
KBO( :, 5,25, 9) = (/&
&1.7983E-01_JPRB,7.5057E-01_JPRB,1.1486E+00_JPRB,1.4751E+00_JPRB,1.6307E+00_JPRB/)
KBO( :, 1,26, 9) = (/&
&5.1716E-02_JPRB,5.2713E-01_JPRB,8.8788E-01_JPRB,1.2018E+00_JPRB,1.4126E+00_JPRB/)
KBO( :, 2,26, 9) = (/&
&7.2684E-02_JPRB,5.6826E-01_JPRB,9.3427E-01_JPRB,1.2488E+00_JPRB,1.4411E+00_JPRB/)
KBO( :, 3,26, 9) = (/&
&9.8449E-02_JPRB,6.1372E-01_JPRB,9.8375E-01_JPRB,1.2977E+00_JPRB,1.4727E+00_JPRB/)
KBO( :, 4,26, 9) = (/&
&1.2939E-01_JPRB,6.6352E-01_JPRB,1.0365E+00_JPRB,1.3486E+00_JPRB,1.5064E+00_JPRB/)
KBO( :, 5,26, 9) = (/&
&1.6591E-01_JPRB,7.1727E-01_JPRB,1.0930E+00_JPRB,1.4010E+00_JPRB,1.5406E+00_JPRB/)
KBO( :, 1,27, 9) = (/&
&4.8584E-02_JPRB,4.9097E-01_JPRB,8.2256E-01_JPRB,1.1121E+00_JPRB,1.2977E+00_JPRB/)
KBO( :, 2,27, 9) = (/&
&6.7759E-02_JPRB,5.3335E-01_JPRB,8.7159E-01_JPRB,1.1633E+00_JPRB,1.3342E+00_JPRB/)
KBO( :, 3,27, 9) = (/&
&9.1281E-02_JPRB,5.8032E-01_JPRB,9.2435E-01_JPRB,1.2172E+00_JPRB,1.3733E+00_JPRB/)
KBO( :, 4,27, 9) = (/&
&1.1958E-01_JPRB,6.3161E-01_JPRB,9.8117E-01_JPRB,1.2730E+00_JPRB,1.4135E+00_JPRB/)
KBO( :, 5,27, 9) = (/&
&1.5306E-01_JPRB,6.8640E-01_JPRB,1.0413E+00_JPRB,1.3298E+00_JPRB,1.4532E+00_JPRB/)
KBO( :, 1,28, 9) = (/&
&4.5513E-02_JPRB,4.5771E-01_JPRB,7.6221E-01_JPRB,1.0285E+00_JPRB,1.1920E+00_JPRB/)
KBO( :, 2,28, 9) = (/&
&6.3043E-02_JPRB,5.0158E-01_JPRB,8.1400E-01_JPRB,1.0840E+00_JPRB,1.2355E+00_JPRB/)
KBO( :, 3,28, 9) = (/&
&8.4577E-02_JPRB,5.5008E-01_JPRB,8.7020E-01_JPRB,1.1421E+00_JPRB,1.2807E+00_JPRB/)
KBO( :, 4,28, 9) = (/&
&1.1056E-01_JPRB,6.0266E-01_JPRB,9.3037E-01_JPRB,1.2019E+00_JPRB,1.3261E+00_JPRB/)
KBO( :, 5,28, 9) = (/&
&1.4146E-01_JPRB,6.5861E-01_JPRB,9.9361E-01_JPRB,1.2630E+00_JPRB,1.3707E+00_JPRB/)
KBO( :, 1,29, 9) = (/&
&4.2634E-02_JPRB,4.2840E-01_JPRB,7.0804E-01_JPRB,9.5295E-01_JPRB,1.0976E+00_JPRB/)
KBO( :, 2,29, 9) = (/&
&5.8749E-02_JPRB,4.7373E-01_JPRB,7.6274E-01_JPRB,1.0122E+00_JPRB,1.1466E+00_JPRB/)
KBO( :, 3,29, 9) = (/&
&7.8594E-02_JPRB,5.2372E-01_JPRB,8.2196E-01_JPRB,1.0740E+00_JPRB,1.1968E+00_JPRB/)
KBO( :, 4,29, 9) = (/&
&1.0258E-01_JPRB,5.7741E-01_JPRB,8.8498E-01_JPRB,1.1377E+00_JPRB,1.2469E+00_JPRB/)
KBO( :, 5,29, 9) = (/&
&1.3125E-01_JPRB,6.3414E-01_JPRB,9.5133E-01_JPRB,1.2027E+00_JPRB,1.2962E+00_JPRB/)
KBO( :, 1,30, 9) = (/&
&3.9899E-02_JPRB,4.0291E-01_JPRB,6.6036E-01_JPRB,8.8584E-01_JPRB,1.0137E+00_JPRB/)
KBO( :, 2,30, 9) = (/&
&5.4774E-02_JPRB,4.4971E-01_JPRB,7.1779E-01_JPRB,9.4836E-01_JPRB,1.0674E+00_JPRB/)
KBO( :, 3,30, 9) = (/&
&7.3108E-02_JPRB,5.0075E-01_JPRB,7.7974E-01_JPRB,1.0137E+00_JPRB,1.1221E+00_JPRB/)
KBO( :, 4,30, 9) = (/&
&9.5439E-02_JPRB,5.5545E-01_JPRB,8.4558E-01_JPRB,1.0809E+00_JPRB,1.1769E+00_JPRB/)
KBO( :, 5,30, 9) = (/&
&1.2214E-01_JPRB,6.1274E-01_JPRB,9.1443E-01_JPRB,1.1496E+00_JPRB,1.2307E+00_JPRB/)
KBO( :, 1,31, 9) = (/&
&3.7399E-02_JPRB,3.8153E-01_JPRB,6.1964E-01_JPRB,8.2749E-01_JPRB,9.4112E-01_JPRB/)
KBO( :, 2,31, 9) = (/&
&5.1170E-02_JPRB,4.2947E-01_JPRB,6.7967E-01_JPRB,8.9330E-01_JPRB,9.9936E-01_JPRB/)
KBO( :, 3,31, 9) = (/&
&6.8267E-02_JPRB,4.8157E-01_JPRB,7.4418E-01_JPRB,9.6186E-01_JPRB,1.0590E+00_JPRB/)
KBO( :, 4,31, 9) = (/&
&8.9119E-02_JPRB,5.3688E-01_JPRB,8.1247E-01_JPRB,1.0326E+00_JPRB,1.1185E+00_JPRB/)
KBO( :, 5,31, 9) = (/&
&1.1420E-01_JPRB,5.9468E-01_JPRB,8.8352E-01_JPRB,1.1045E+00_JPRB,1.1767E+00_JPRB/)
KBO( :, 1,32, 9) = (/&
&3.5118E-02_JPRB,3.6406E-01_JPRB,5.8571E-01_JPRB,7.7819E-01_JPRB,8.7995E-01_JPRB/)
KBO( :, 2,32, 9) = (/&
&4.7970E-02_JPRB,4.1299E-01_JPRB,6.4823E-01_JPRB,8.4697E-01_JPRB,9.4296E-01_JPRB/)
KBO( :, 3,32, 9) = (/&
&6.4004E-02_JPRB,4.6590E-01_JPRB,7.1516E-01_JPRB,9.1892E-01_JPRB,1.0071E+00_JPRB/)
KBO( :, 4,32, 9) = (/&
&8.3615E-02_JPRB,5.2189E-01_JPRB,7.8583E-01_JPRB,9.9290E-01_JPRB,1.0709E+00_JPRB/)
KBO( :, 5,32, 9) = (/&
&1.0720E-01_JPRB,5.8002E-01_JPRB,8.5872E-01_JPRB,1.0680E+00_JPRB,1.1336E+00_JPRB/)
KBO( :, 1,33, 9) = (/&
&3.3077E-02_JPRB,3.5017E-01_JPRB,5.5838E-01_JPRB,7.3762E-01_JPRB,8.3032E-01_JPRB/)
KBO( :, 2,33, 9) = (/&
&4.5163E-02_JPRB,4.0001E-01_JPRB,6.2312E-01_JPRB,8.0956E-01_JPRB,8.9776E-01_JPRB/)
KBO( :, 3,33, 9) = (/&
&6.0263E-02_JPRB,4.5365E-01_JPRB,6.9243E-01_JPRB,8.8459E-01_JPRB,9.6617E-01_JPRB/)
KBO( :, 4,33, 9) = (/&
&7.8793E-02_JPRB,5.1005E-01_JPRB,7.6498E-01_JPRB,9.6177E-01_JPRB,1.0343E+00_JPRB/)
KBO( :, 5,33, 9) = (/&
&1.0108E-01_JPRB,5.6875E-01_JPRB,8.3998E-01_JPRB,1.0396E+00_JPRB,1.1011E+00_JPRB/)
KBO( :, 1,34, 9) = (/&
&3.0915E-02_JPRB,3.3781E-01_JPRB,5.3486E-01_JPRB,7.0304E-01_JPRB,7.8832E-01_JPRB/)
KBO( :, 2,34, 9) = (/&
&4.2252E-02_JPRB,3.8839E-01_JPRB,6.0166E-01_JPRB,7.7789E-01_JPRB,8.5967E-01_JPRB/)
KBO( :, 3,34, 9) = (/&
&5.6470E-02_JPRB,4.4255E-01_JPRB,6.7299E-01_JPRB,8.5584E-01_JPRB,9.3187E-01_JPRB/)
KBO( :, 4,34, 9) = (/&
&7.3896E-02_JPRB,4.9923E-01_JPRB,7.4727E-01_JPRB,9.3566E-01_JPRB,1.0039E+00_JPRB/)
KBO( :, 5,34, 9) = (/&
&9.5018E-02_JPRB,5.5848E-01_JPRB,8.2408E-01_JPRB,1.0160E+00_JPRB,1.0743E+00_JPRB/)
KBO( :, 1,35, 9) = (/&
&2.8132E-02_JPRB,3.2365E-01_JPRB,5.1055E-01_JPRB,6.6895E-01_JPRB,7.4864E-01_JPRB/)
KBO( :, 2,35, 9) = (/&
&3.8581E-02_JPRB,3.7456E-01_JPRB,5.7889E-01_JPRB,7.4628E-01_JPRB,8.2332E-01_JPRB/)
KBO( :, 3,35, 9) = (/&
&5.1721E-02_JPRB,4.2888E-01_JPRB,6.5160E-01_JPRB,8.2665E-01_JPRB,8.9938E-01_JPRB/)
KBO( :, 4,35, 9) = (/&
&6.7950E-02_JPRB,4.8574E-01_JPRB,7.2738E-01_JPRB,9.0865E-01_JPRB,9.7493E-01_JPRB/)
KBO( :, 5,35, 9) = (/&
&8.7661E-02_JPRB,5.4539E-01_JPRB,8.0566E-01_JPRB,9.9133E-01_JPRB,1.0487E+00_JPRB/)
KBO( :, 1,36, 9) = (/&
&2.4794E-02_JPRB,3.0684E-01_JPRB,4.8374E-01_JPRB,6.3315E-01_JPRB,7.0816E-01_JPRB/)
KBO( :, 2,36, 9) = (/&
&3.4216E-02_JPRB,3.5764E-01_JPRB,5.5293E-01_JPRB,7.1235E-01_JPRB,7.8609E-01_JPRB/)
KBO( :, 3,36, 9) = (/&
&4.6142E-02_JPRB,4.1180E-01_JPRB,6.2660E-01_JPRB,7.9449E-01_JPRB,8.6552E-01_JPRB/)
KBO( :, 4,36, 9) = (/&
&6.0983E-02_JPRB,4.6863E-01_JPRB,7.0343E-01_JPRB,8.7846E-01_JPRB,9.4446E-01_JPRB/)
KBO( :, 5,36, 9) = (/&
&7.9101E-02_JPRB,5.2833E-01_JPRB,7.8277E-01_JPRB,9.6328E-01_JPRB,1.0212E+00_JPRB/)
KBO( :, 1,37, 9) = (/&
&2.0815E-02_JPRB,2.8513E-01_JPRB,4.5081E-01_JPRB,5.9101E-01_JPRB,6.6164E-01_JPRB/)
KBO( :, 2,37, 9) = (/&
&2.9022E-02_JPRB,3.3521E-01_JPRB,5.2012E-01_JPRB,6.7125E-01_JPRB,7.4211E-01_JPRB/)
KBO( :, 3,37, 9) = (/&
&3.9516E-02_JPRB,3.8880E-01_JPRB,5.9400E-01_JPRB,7.5469E-01_JPRB,8.2434E-01_JPRB/)
KBO( :, 4,37, 9) = (/&
&5.2685E-02_JPRB,4.4520E-01_JPRB,6.7131E-01_JPRB,8.4030E-01_JPRB,9.0639E-01_JPRB/)
KBO( :, 5,37, 9) = (/&
&6.8908E-02_JPRB,5.0450E-01_JPRB,7.5128E-01_JPRB,9.2687E-01_JPRB,9.8613E-01_JPRB/)
KBO( :, 1,38, 9) = (/&
&1.7440E-02_JPRB,2.6532E-01_JPRB,4.2090E-01_JPRB,5.5282E-01_JPRB,6.1999E-01_JPRB/)
KBO( :, 2,38, 9) = (/&
&2.4585E-02_JPRB,3.1463E-01_JPRB,4.9010E-01_JPRB,6.3385E-01_JPRB,7.0267E-01_JPRB/)
KBO( :, 3,38, 9) = (/&
&3.3827E-02_JPRB,3.6763E-01_JPRB,5.6406E-01_JPRB,7.1841E-01_JPRB,7.8751E-01_JPRB/)
KBO( :, 4,38, 9) = (/&
&4.5497E-02_JPRB,4.2358E-01_JPRB,6.4172E-01_JPRB,8.0528E-01_JPRB,8.7233E-01_JPRB/)
KBO( :, 5,38, 9) = (/&
&6.0061E-02_JPRB,4.8245E-01_JPRB,7.2216E-01_JPRB,8.9334E-01_JPRB,9.5488E-01_JPRB/)
KBO( :, 1,39, 9) = (/&
&1.4635E-02_JPRB,2.4758E-01_JPRB,3.9422E-01_JPRB,5.1882E-01_JPRB,5.8346E-01_JPRB/)
KBO( :, 2,39, 9) = (/&
&2.0862E-02_JPRB,2.9613E-01_JPRB,4.6317E-01_JPRB,6.0043E-01_JPRB,6.6823E-01_JPRB/)
KBO( :, 3,39, 9) = (/&
&2.9010E-02_JPRB,3.4853E-01_JPRB,5.3715E-01_JPRB,6.8585E-01_JPRB,7.5543E-01_JPRB/)
KBO( :, 4,39, 9) = (/&
&3.9392E-02_JPRB,4.0402E-01_JPRB,6.1498E-01_JPRB,7.7375E-01_JPRB,8.4272E-01_JPRB/)
KBO( :, 5,39, 9) = (/&
&5.2487E-02_JPRB,4.6246E-01_JPRB,6.9574E-01_JPRB,8.6309E-01_JPRB,9.2808E-01_JPRB/)
KBO( :, 1,40, 9) = (/&
&1.1817E-02_JPRB,2.2703E-01_JPRB,3.6362E-01_JPRB,4.8024E-01_JPRB,5.4110E-01_JPRB/)
KBO( :, 2,40, 9) = (/&
&1.7093E-02_JPRB,2.7438E-01_JPRB,4.3164E-01_JPRB,5.6172E-01_JPRB,6.2692E-01_JPRB/)
KBO( :, 3,40, 9) = (/&
&2.4086E-02_JPRB,3.2578E-01_JPRB,5.0508E-01_JPRB,6.4747E-01_JPRB,7.1559E-01_JPRB/)
KBO( :, 4,40, 9) = (/&
&3.3120E-02_JPRB,3.8047E-01_JPRB,5.8258E-01_JPRB,7.3604E-01_JPRB,8.0488E-01_JPRB/)
KBO( :, 5,40, 9) = (/&
&4.4642E-02_JPRB,4.3816E-01_JPRB,6.6329E-01_JPRB,8.2630E-01_JPRB,8.9263E-01_JPRB/)
KBO( :, 1,41, 9) = (/&
&9.4732E-03_JPRB,2.0772E-01_JPRB,3.3472E-01_JPRB,4.4372E-01_JPRB,5.0098E-01_JPRB/)
KBO( :, 2,41, 9) = (/&
&1.3924E-02_JPRB,2.5378E-01_JPRB,4.0168E-01_JPRB,5.2481E-01_JPRB,5.8738E-01_JPRB/)
KBO( :, 3,41, 9) = (/&
&1.9893E-02_JPRB,3.0412E-01_JPRB,4.7431E-01_JPRB,6.1058E-01_JPRB,6.7711E-01_JPRB/)
KBO( :, 4,41, 9) = (/&
&2.7726E-02_JPRB,3.5790E-01_JPRB,5.5133E-01_JPRB,6.9954E-01_JPRB,7.6804E-01_JPRB/)
KBO( :, 5,41, 9) = (/&
&3.7835E-02_JPRB,4.1479E-01_JPRB,6.3183E-01_JPRB,7.9045E-01_JPRB,8.5793E-01_JPRB/)
KBO( :, 1,42, 9) = (/&
&7.5682E-03_JPRB,1.9007E-01_JPRB,3.0814E-01_JPRB,4.0997E-01_JPRB,4.6395E-01_JPRB/)
KBO( :, 2,42, 9) = (/&
&1.1315E-02_JPRB,2.3478E-01_JPRB,3.7386E-01_JPRB,4.9039E-01_JPRB,5.5062E-01_JPRB/)
KBO( :, 3,42, 9) = (/&
&1.6414E-02_JPRB,2.8401E-01_JPRB,4.4556E-01_JPRB,5.7596E-01_JPRB,6.4116E-01_JPRB/)
KBO( :, 4,42, 9) = (/&
&2.3189E-02_JPRB,3.3687E-01_JPRB,5.2199E-01_JPRB,6.6509E-01_JPRB,7.3350E-01_JPRB/)
KBO( :, 5,42, 9) = (/&
&3.2053E-02_JPRB,3.9299E-01_JPRB,6.0205E-01_JPRB,7.5646E-01_JPRB,8.2526E-01_JPRB/)
KBO( :, 1,43, 9) = (/&
&5.8792E-03_JPRB,1.7158E-01_JPRB,2.8021E-01_JPRB,3.7439E-01_JPRB,4.2476E-01_JPRB/)
KBO( :, 2,43, 9) = (/&
&8.9664E-03_JPRB,2.1465E-01_JPRB,3.4423E-01_JPRB,4.5359E-01_JPRB,5.1109E-01_JPRB/)
KBO( :, 3,43, 9) = (/&
&1.3239E-02_JPRB,2.6247E-01_JPRB,4.1451E-01_JPRB,5.3841E-01_JPRB,6.0195E-01_JPRB/)
KBO( :, 4,43, 9) = (/&
&1.8999E-02_JPRB,3.1420E-01_JPRB,4.8991E-01_JPRB,6.2734E-01_JPRB,6.9535E-01_JPRB/)
KBO( :, 5,43, 9) = (/&
&2.6643E-02_JPRB,3.6926E-01_JPRB,5.6925E-01_JPRB,7.1886E-01_JPRB,7.8877E-01_JPRB/)
KBO( :, 1,44, 9) = (/&
&4.4882E-03_JPRB,1.5364E-01_JPRB,2.5283E-01_JPRB,3.3925E-01_JPRB,3.8604E-01_JPRB/)
KBO( :, 2,44, 9) = (/&
&6.9936E-03_JPRB,1.9487E-01_JPRB,3.1482E-01_JPRB,4.1683E-01_JPRB,4.7142E-01_JPRB/)
KBO( :, 3,44, 9) = (/&
&1.0532E-02_JPRB,2.4110E-01_JPRB,3.8337E-01_JPRB,5.0055E-01_JPRB,5.6226E-01_JPRB/)
KBO( :, 4,44, 9) = (/&
&1.5385E-02_JPRB,2.9150E-01_JPRB,4.5750E-01_JPRB,5.8891E-01_JPRB,6.5637E-01_JPRB/)
KBO( :, 5,44, 9) = (/&
&2.1907E-02_JPRB,3.4545E-01_JPRB,5.3592E-01_JPRB,6.8023E-01_JPRB,7.5115E-01_JPRB/)
KBO( :, 1,45, 9) = (/&
&3.4023E-03_JPRB,1.3718E-01_JPRB,2.2742E-01_JPRB,3.0640E-01_JPRB,3.4986E-01_JPRB/)
KBO( :, 2,45, 9) = (/&
&5.4211E-03_JPRB,1.7648E-01_JPRB,2.8724E-01_JPRB,3.8210E-01_JPRB,4.3396E-01_JPRB/)
KBO( :, 3,45, 9) = (/&
&8.3344E-03_JPRB,2.2102E-01_JPRB,3.5390E-01_JPRB,4.6443E-01_JPRB,5.2448E-01_JPRB/)
KBO( :, 4,45, 9) = (/&
&1.2410E-02_JPRB,2.7007E-01_JPRB,4.2657E-01_JPRB,5.5186E-01_JPRB,6.1889E-01_JPRB/)
KBO( :, 5,45, 9) = (/&
&1.7962E-02_JPRB,3.2284E-01_JPRB,5.0389E-01_JPRB,6.4288E-01_JPRB,7.1489E-01_JPRB/)
KBO( :, 1,46, 9) = (/&
&2.5298E-03_JPRB,1.2128E-01_JPRB,2.0265E-01_JPRB,2.7417E-01_JPRB,3.1426E-01_JPRB/)
KBO( :, 2,46, 9) = (/&
&4.1311E-03_JPRB,1.5849E-01_JPRB,2.6002E-01_JPRB,3.4751E-01_JPRB,3.9644E-01_JPRB/)
KBO( :, 3,46, 9) = (/&
&6.4978E-03_JPRB,2.0122E-01_JPRB,3.2453E-01_JPRB,4.2805E-01_JPRB,4.8611E-01_JPRB/)
KBO( :, 4,46, 9) = (/&
&9.8756E-03_JPRB,2.4871E-01_JPRB,3.9537E-01_JPRB,5.1423E-01_JPRB,5.8048E-01_JPRB/)
KBO( :, 5,46, 9) = (/&
&1.4561E-02_JPRB,3.0016E-01_JPRB,4.7134E-01_JPRB,6.0463E-01_JPRB,6.7732E-01_JPRB/)
KBO( :, 1,47, 9) = (/&
&1.8212E-03_JPRB,1.0532E-01_JPRB,1.7755E-01_JPRB,2.4129E-01_JPRB,2.7755E-01_JPRB/)
KBO( :, 2,47, 9) = (/&
&3.0568E-03_JPRB,1.4024E-01_JPRB,2.3198E-01_JPRB,3.1155E-01_JPRB,3.5689E-01_JPRB/)
KBO( :, 3,47, 9) = (/&
&4.9310E-03_JPRB,1.8078E-01_JPRB,2.9385E-01_JPRB,3.8973E-01_JPRB,4.4482E-01_JPRB/)
KBO( :, 4,47, 9) = (/&
&7.6712E-03_JPRB,2.2639E-01_JPRB,3.6245E-01_JPRB,4.7424E-01_JPRB,5.3854E-01_JPRB/)
KBO( :, 5,47, 9) = (/&
&1.1548E-02_JPRB,2.7630E-01_JPRB,4.3672E-01_JPRB,5.6347E-01_JPRB,6.3559E-01_JPRB/)
KBO( :, 1,48, 9) = (/&
&1.2952E-03_JPRB,9.0848E-02_JPRB,1.5447E-01_JPRB,2.1078E-01_JPRB,2.4345E-01_JPRB/)
KBO( :, 2,48, 9) = (/&
&2.2372E-03_JPRB,1.2337E-01_JPRB,2.0574E-01_JPRB,2.7761E-01_JPRB,3.1960E-01_JPRB/)
KBO( :, 3,48, 9) = (/&
&3.7056E-03_JPRB,1.6164E-01_JPRB,2.6488E-01_JPRB,3.5315E-01_JPRB,4.0534E-01_JPRB/)
KBO( :, 4,48, 9) = (/&
&5.9066E-03_JPRB,2.0530E-01_JPRB,3.3102E-01_JPRB,4.3559E-01_JPRB,4.9804E-01_JPRB/)
KBO( :, 5,48, 9) = (/&
&9.0925E-03_JPRB,2.5355E-01_JPRB,4.0335E-01_JPRB,5.2339E-01_JPRB,5.9498E-01_JPRB/)
KBO( :, 1,49, 9) = (/&
&9.0858E-04_JPRB,7.7773E-02_JPRB,1.3333E-01_JPRB,1.8263E-01_JPRB,2.1203E-01_JPRB/)
KBO( :, 2,49, 9) = (/&
&1.6178E-03_JPRB,1.0781E-01_JPRB,1.8129E-01_JPRB,2.4570E-01_JPRB,2.8465E-01_JPRB/)
KBO( :, 3,49, 9) = (/&
&2.7562E-03_JPRB,1.4379E-01_JPRB,2.3752E-01_JPRB,3.1823E-01_JPRB,3.6781E-01_JPRB/)
KBO( :, 4,49, 9) = (/&
&4.5071E-03_JPRB,1.8535E-01_JPRB,3.0106E-01_JPRB,3.9831E-01_JPRB,4.5913E-01_JPRB/)
KBO( :, 5,49, 9) = (/&
&7.1028E-03_JPRB,2.3184E-01_JPRB,3.7117E-01_JPRB,4.8442E-01_JPRB,5.5577E-01_JPRB/)
KBO( :, 1,50, 9) = (/&
&6.3845E-04_JPRB,6.6632E-02_JPRB,1.1508E-01_JPRB,1.5813E-01_JPRB,1.8420E-01_JPRB/)
KBO( :, 2,50, 9) = (/&
&1.1723E-03_JPRB,9.4330E-02_JPRB,1.5988E-01_JPRB,2.1752E-01_JPRB,2.5295E-01_JPRB/)
KBO( :, 3,50, 9) = (/&
&2.0555E-03_JPRB,1.2813E-01_JPRB,2.1319E-01_JPRB,2.8686E-01_JPRB,3.3317E-01_JPRB/)
KBO( :, 4,50, 9) = (/&
&3.4507E-03_JPRB,1.6762E-01_JPRB,2.7419E-01_JPRB,3.6453E-01_JPRB,4.2252E-01_JPRB/)
KBO( :, 5,50, 9) = (/&
&5.5676E-03_JPRB,2.1233E-01_JPRB,3.4204E-01_JPRB,4.4881E-01_JPRB,5.1834E-01_JPRB/)
KBO( :, 1,51, 9) = (/&
&4.4606E-04_JPRB,5.6891E-02_JPRB,9.8867E-02_JPRB,1.3627E-01_JPRB,1.5911E-01_JPRB/)
KBO( :, 2,51, 9) = (/&
&8.4540E-04_JPRB,8.2329E-02_JPRB,1.4056E-01_JPRB,1.9187E-01_JPRB,2.2375E-01_JPRB/)
KBO( :, 3,51, 9) = (/&
&1.5266E-03_JPRB,1.1393E-01_JPRB,1.9092E-01_JPRB,2.5792E-01_JPRB,3.0065E-01_JPRB/)
KBO( :, 4,51, 9) = (/&
&2.6330E-03_JPRB,1.5136E-01_JPRB,2.4932E-01_JPRB,3.3298E-01_JPRB,3.8756E-01_JPRB/)
KBO( :, 5,51, 9) = (/&
&4.3537E-03_JPRB,1.9426E-01_JPRB,3.1486E-01_JPRB,4.1517E-01_JPRB,4.8205E-01_JPRB/)
KBO( :, 1,52, 9) = (/&
&3.0758E-04_JPRB,4.8172E-02_JPRB,8.4225E-02_JPRB,1.1640E-01_JPRB,1.3632E-01_JPRB/)
KBO( :, 2,52, 9) = (/&
&6.0273E-04_JPRB,7.1379E-02_JPRB,1.2274E-01_JPRB,1.6806E-01_JPRB,1.9667E-01_JPRB/)
KBO( :, 3,52, 9) = (/&
&1.1225E-03_JPRB,1.0074E-01_JPRB,1.7004E-01_JPRB,2.3059E-01_JPRB,2.6996E-01_JPRB/)
KBO( :, 4,52, 9) = (/&
&1.9908E-03_JPRB,1.3610E-01_JPRB,2.2571E-01_JPRB,3.0271E-01_JPRB,3.5416E-01_JPRB/)
KBO( :, 5,52, 9) = (/&
&3.3781E-03_JPRB,1.7706E-01_JPRB,2.8879E-01_JPRB,3.8263E-01_JPRB,4.4697E-01_JPRB/)
KBO( :, 1,53, 9) = (/&
&2.0907E-04_JPRB,4.0394E-02_JPRB,7.1019E-02_JPRB,9.8396E-02_JPRB,1.1571E-01_JPRB/)
KBO( :, 2,53, 9) = (/&
&4.2389E-04_JPRB,6.1427E-02_JPRB,1.0630E-01_JPRB,1.4598E-01_JPRB,1.7164E-01_JPRB/)
KBO( :, 3,53, 9) = (/&
&8.1536E-04_JPRB,8.8519E-02_JPRB,1.5049E-01_JPRB,2.0480E-01_JPRB,2.4110E-01_JPRB/)
KBO( :, 4,53, 9) = (/&
&1.4900E-03_JPRB,1.2174E-01_JPRB,2.0325E-01_JPRB,2.7370E-01_JPRB,3.2235E-01_JPRB/)
KBO( :, 5,53, 9) = (/&
&2.5972E-03_JPRB,1.6068E-01_JPRB,2.6380E-01_JPRB,3.5112E-01_JPRB,4.1323E-01_JPRB/)
KBO( :, 1,54, 9) = (/&
&1.4322E-04_JPRB,3.4010E-02_JPRB,6.0069E-02_JPRB,8.3407E-02_JPRB,9.8018E-02_JPRB/)
KBO( :, 2,54, 9) = (/&
&3.0073E-04_JPRB,5.3101E-02_JPRB,9.2377E-02_JPRB,1.2719E-01_JPRB,1.4939E-01_JPRB/)
KBO( :, 3,54, 9) = (/&
&5.9718E-04_JPRB,7.8129E-02_JPRB,1.3368E-01_JPRB,1.8244E-01_JPRB,2.1463E-01_JPRB/)
KBO( :, 4,54, 9) = (/&
&1.1241E-03_JPRB,1.0934E-01_JPRB,1.8368E-01_JPRB,2.4822E-01_JPRB,2.9238E-01_JPRB/)
KBO( :, 5,54, 9) = (/&
&2.0131E-03_JPRB,1.4639E-01_JPRB,2.4179E-01_JPRB,3.2314E-01_JPRB,3.8050E-01_JPRB/)
KBO( :, 1,55, 9) = (/&
&9.7902E-05_JPRB,2.8554E-02_JPRB,5.0642E-02_JPRB,7.0457E-02_JPRB,8.2500E-02_JPRB/)
KBO( :, 2,55, 9) = (/&
&2.1303E-04_JPRB,4.5829E-02_JPRB,8.0130E-02_JPRB,1.1056E-01_JPRB,1.2929E-01_JPRB/)
KBO( :, 3,55, 9) = (/&
&4.3705E-04_JPRB,6.8906E-02_JPRB,1.1861E-01_JPRB,1.6229E-01_JPRB,1.9004E-01_JPRB/)
KBO( :, 4,55, 9) = (/&
&8.4778E-04_JPRB,9.8145E-02_JPRB,1.6589E-01_JPRB,2.2492E-01_JPRB,2.6385E-01_JPRB/)
KBO( :, 5,55, 9) = (/&
&1.5604E-03_JPRB,1.3338E-01_JPRB,2.2157E-01_JPRB,2.9717E-01_JPRB,3.4860E-01_JPRB/)
KBO( :, 1,56, 9) = (/&
&6.5982E-05_JPRB,2.3749E-02_JPRB,4.2283E-02_JPRB,5.8930E-02_JPRB,6.8770E-02_JPRB/)
KBO( :, 2,56, 9) = (/&
&1.4918E-04_JPRB,3.9269E-02_JPRB,6.8966E-02_JPRB,9.5347E-02_JPRB,1.1107E-01_JPRB/)
KBO( :, 3,56, 9) = (/&
&3.1651E-04_JPRB,6.0448E-02_JPRB,1.0460E-01_JPRB,1.4348E-01_JPRB,1.6725E-01_JPRB/)
KBO( :, 4,56, 9) = (/&
&6.3389E-04_JPRB,8.7699E-02_JPRB,1.4915E-01_JPRB,2.0282E-01_JPRB,2.3679E-01_JPRB/)
KBO( :, 5,56, 9) = (/&
&1.2004E-03_JPRB,1.2107E-01_JPRB,2.0225E-01_JPRB,2.7220E-01_JPRB,3.1806E-01_JPRB/)
KBO( :, 1,57, 9) = (/&
&4.3767E-05_JPRB,1.9535E-02_JPRB,3.4912E-02_JPRB,4.8732E-02_JPRB,5.6673E-02_JPRB/)
KBO( :, 2,57, 9) = (/&
&1.0316E-04_JPRB,3.3365E-02_JPRB,5.8830E-02_JPRB,8.1501E-02_JPRB,9.4580E-02_JPRB/)
KBO( :, 3,57, 9) = (/&
&2.2677E-04_JPRB,5.2688E-02_JPRB,9.1608E-02_JPRB,1.2597E-01_JPRB,1.4616E-01_JPRB/)
KBO( :, 4,57, 9) = (/&
&4.6916E-04_JPRB,7.7962E-02_JPRB,1.3338E-01_JPRB,1.8187E-01_JPRB,2.1133E-01_JPRB/)
KBO( :, 5,57, 9) = (/&
&9.1588E-04_JPRB,1.0942E-01_JPRB,1.8382E-01_JPRB,2.4826E-01_JPRB,2.8886E-01_JPRB/)
KBO( :, 1,58, 9) = (/&
&2.9014E-05_JPRB,1.6044E-02_JPRB,2.8753E-02_JPRB,4.0190E-02_JPRB,4.6551E-02_JPRB/)
KBO( :, 2,58, 9) = (/&
&7.1292E-05_JPRB,2.8332E-02_JPRB,5.0135E-02_JPRB,6.9583E-02_JPRB,8.0381E-02_JPRB/)
KBO( :, 3,58, 9) = (/&
&1.6267E-04_JPRB,4.5930E-02_JPRB,8.0232E-02_JPRB,1.1053E-01_JPRB,1.2757E-01_JPRB/)
KBO( :, 4,58, 9) = (/&
&3.4791E-04_JPRB,6.9359E-02_JPRB,1.1932E-01_JPRB,1.6310E-01_JPRB,1.8840E-01_JPRB/)
KBO( :, 5,58, 9) = (/&
&7.0018E-04_JPRB,9.8967E-02_JPRB,1.6720E-01_JPRB,2.2650E-01_JPRB,2.6195E-01_JPRB/)
KBO( :, 1,59, 9) = (/&
&2.2635E-05_JPRB,1.4643E-02_JPRB,2.6255E-02_JPRB,3.6697E-02_JPRB,4.2048E-02_JPRB/)
KBO( :, 2,59, 9) = (/&
&5.7212E-05_JPRB,2.6338E-02_JPRB,4.6664E-02_JPRB,6.4796E-02_JPRB,7.3964E-02_JPRB/)
KBO( :, 3,59, 9) = (/&
&1.3405E-04_JPRB,4.3265E-02_JPRB,7.5702E-02_JPRB,1.0436E-01_JPRB,1.1887E-01_JPRB/)
KBO( :, 4,59, 9) = (/&
&2.9326E-04_JPRB,6.5970E-02_JPRB,1.1372E-01_JPRB,1.5558E-01_JPRB,1.7711E-01_JPRB/)
KBO( :, 5,59, 9) = (/&
&6.0242E-04_JPRB,9.4820E-02_JPRB,1.6057E-01_JPRB,2.1777E-01_JPRB,2.4787E-01_JPRB/)
KBO( :, 1,13,10) = (/&
&6.7750E-01_JPRB,1.1612E+00_JPRB,1.7683E+00_JPRB,2.4833E+00_JPRB,3.2280E+00_JPRB/)
KBO( :, 2,13,10) = (/&
&9.8868E-01_JPRB,1.3195E+00_JPRB,1.8430E+00_JPRB,2.4544E+00_JPRB,3.1587E+00_JPRB/)
KBO( :, 3,13,10) = (/&
&1.3619E+00_JPRB,1.5274E+00_JPRB,1.9406E+00_JPRB,2.4411E+00_JPRB,3.1000E+00_JPRB/)
KBO( :, 4,13,10) = (/&
&1.7899E+00_JPRB,1.7565E+00_JPRB,2.0793E+00_JPRB,2.4696E+00_JPRB,3.0494E+00_JPRB/)
KBO( :, 5,13,10) = (/&
&2.2734E+00_JPRB,2.0120E+00_JPRB,2.2415E+00_JPRB,2.5072E+00_JPRB,3.0022E+00_JPRB/)
KBO( :, 1,14,10) = (/&
&6.6134E-01_JPRB,1.2265E+00_JPRB,1.9371E+00_JPRB,2.7275E+00_JPRB,3.5435E+00_JPRB/)
KBO( :, 2,14,10) = (/&
&9.5434E-01_JPRB,1.3839E+00_JPRB,2.0016E+00_JPRB,2.7009E+00_JPRB,3.4774E+00_JPRB/)
KBO( :, 3,14,10) = (/&
&1.3032E+00_JPRB,1.5702E+00_JPRB,2.0959E+00_JPRB,2.6930E+00_JPRB,3.4197E+00_JPRB/)
KBO( :, 4,14,10) = (/&
&1.7103E+00_JPRB,1.7846E+00_JPRB,2.2135E+00_JPRB,2.7227E+00_JPRB,3.3624E+00_JPRB/)
KBO( :, 5,14,10) = (/&
&2.1701E+00_JPRB,2.0313E+00_JPRB,2.3489E+00_JPRB,2.7404E+00_JPRB,3.3020E+00_JPRB/)
KBO( :, 1,15,10) = (/&
&6.3051E-01_JPRB,1.3065E+00_JPRB,2.1302E+00_JPRB,2.9787E+00_JPRB,3.8647E+00_JPRB/)
KBO( :, 2,15,10) = (/&
&9.0166E-01_JPRB,1.4415E+00_JPRB,2.2062E+00_JPRB,2.9568E+00_JPRB,3.8040E+00_JPRB/)
KBO( :, 3,15,10) = (/&
&1.2283E+00_JPRB,1.6099E+00_JPRB,2.2945E+00_JPRB,2.9614E+00_JPRB,3.7464E+00_JPRB/)
KBO( :, 4,15,10) = (/&
&1.6076E+00_JPRB,1.8076E+00_JPRB,2.3898E+00_JPRB,2.9892E+00_JPRB,3.6813E+00_JPRB/)
KBO( :, 5,15,10) = (/&
&2.0350E+00_JPRB,2.0302E+00_JPRB,2.4952E+00_JPRB,3.0078E+00_JPRB,3.6149E+00_JPRB/)
KBO( :, 1,16,10) = (/&
&5.8908E-01_JPRB,1.4179E+00_JPRB,2.3250E+00_JPRB,3.2386E+00_JPRB,4.2028E+00_JPRB/)
KBO( :, 2,16,10) = (/&
&8.3922E-01_JPRB,1.5233E+00_JPRB,2.4132E+00_JPRB,3.2198E+00_JPRB,4.1391E+00_JPRB/)
KBO( :, 3,16,10) = (/&
&1.1390E+00_JPRB,1.6562E+00_JPRB,2.5083E+00_JPRB,3.2400E+00_JPRB,4.0764E+00_JPRB/)
KBO( :, 4,16,10) = (/&
&1.4867E+00_JPRB,1.8239E+00_JPRB,2.5939E+00_JPRB,3.2704E+00_JPRB,4.0090E+00_JPRB/)
KBO( :, 5,16,10) = (/&
&1.8763E+00_JPRB,2.0203E+00_JPRB,2.6728E+00_JPRB,3.3036E+00_JPRB,3.9360E+00_JPRB/)
KBO( :, 1,17,10) = (/&
&5.4248E-01_JPRB,1.5341E+00_JPRB,2.5200E+00_JPRB,3.4785E+00_JPRB,4.5198E+00_JPRB/)
KBO( :, 2,17,10) = (/&
&7.6928E-01_JPRB,1.6341E+00_JPRB,2.6202E+00_JPRB,3.4798E+00_JPRB,4.4583E+00_JPRB/)
KBO( :, 3,17,10) = (/&
&1.0404E+00_JPRB,1.7374E+00_JPRB,2.7194E+00_JPRB,3.5099E+00_JPRB,4.3924E+00_JPRB/)
KBO( :, 4,17,10) = (/&
&1.3522E+00_JPRB,1.8611E+00_JPRB,2.8021E+00_JPRB,3.5422E+00_JPRB,4.3166E+00_JPRB/)
KBO( :, 5,17,10) = (/&
&1.7001E+00_JPRB,2.0150E+00_JPRB,2.8795E+00_JPRB,3.5848E+00_JPRB,4.2409E+00_JPRB/)
KBO( :, 1,18,10) = (/&
&4.9348E-01_JPRB,1.6382E+00_JPRB,2.7119E+00_JPRB,3.6984E+00_JPRB,4.7971E+00_JPRB/)
KBO( :, 2,18,10) = (/&
&6.9669E-01_JPRB,1.7374E+00_JPRB,2.8139E+00_JPRB,3.7221E+00_JPRB,4.7361E+00_JPRB/)
KBO( :, 3,18,10) = (/&
&9.3760E-01_JPRB,1.8373E+00_JPRB,2.9117E+00_JPRB,3.7521E+00_JPRB,4.6633E+00_JPRB/)
KBO( :, 4,18,10) = (/&
&1.2130E+00_JPRB,1.9403E+00_JPRB,3.0001E+00_JPRB,3.7974E+00_JPRB,4.5895E+00_JPRB/)
KBO( :, 5,18,10) = (/&
&1.5215E+00_JPRB,2.0549E+00_JPRB,3.0821E+00_JPRB,3.8475E+00_JPRB,4.5159E+00_JPRB/)
KBO( :, 1,19,10) = (/&
&4.4294E-01_JPRB,1.7294E+00_JPRB,2.8772E+00_JPRB,3.8900E+00_JPRB,5.0246E+00_JPRB/)
KBO( :, 2,19,10) = (/&
&6.2191E-01_JPRB,1.8298E+00_JPRB,2.9845E+00_JPRB,3.9195E+00_JPRB,4.9572E+00_JPRB/)
KBO( :, 3,19,10) = (/&
&8.3280E-01_JPRB,1.9296E+00_JPRB,3.0814E+00_JPRB,3.9651E+00_JPRB,4.8890E+00_JPRB/)
KBO( :, 4,19,10) = (/&
&1.0758E+00_JPRB,2.0307E+00_JPRB,3.1709E+00_JPRB,4.0288E+00_JPRB,4.8272E+00_JPRB/)
KBO( :, 5,19,10) = (/&
&1.3553E+00_JPRB,2.1313E+00_JPRB,3.2530E+00_JPRB,4.0885E+00_JPRB,4.7625E+00_JPRB/)
KBO( :, 1,20,10) = (/&
&3.9571E-01_JPRB,1.8051E+00_JPRB,3.0095E+00_JPRB,4.0443E+00_JPRB,5.1864E+00_JPRB/)
KBO( :, 2,20,10) = (/&
&5.5188E-01_JPRB,1.9076E+00_JPRB,3.1223E+00_JPRB,4.0868E+00_JPRB,5.1320E+00_JPRB/)
KBO( :, 3,20,10) = (/&
&7.3749E-01_JPRB,2.0075E+00_JPRB,3.2244E+00_JPRB,4.1593E+00_JPRB,5.0769E+00_JPRB/)
KBO( :, 4,20,10) = (/&
&9.5721E-01_JPRB,2.1096E+00_JPRB,3.3164E+00_JPRB,4.2324E+00_JPRB,5.0165E+00_JPRB/)
KBO( :, 5,20,10) = (/&
&1.2100E+00_JPRB,2.2109E+00_JPRB,3.3994E+00_JPRB,4.2966E+00_JPRB,4.9507E+00_JPRB/)
KBO( :, 1,21,10) = (/&
&3.5072E-01_JPRB,1.8556E+00_JPRB,3.1080E+00_JPRB,4.1542E+00_JPRB,5.2872E+00_JPRB/)
KBO( :, 2,21,10) = (/&
&4.8766E-01_JPRB,1.9607E+00_JPRB,3.2231E+00_JPRB,4.2283E+00_JPRB,5.2442E+00_JPRB/)
KBO( :, 3,21,10) = (/&
&6.5440E-01_JPRB,2.0647E+00_JPRB,3.3316E+00_JPRB,4.3160E+00_JPRB,5.1977E+00_JPRB/)
KBO( :, 4,21,10) = (/&
&8.5123E-01_JPRB,2.1675E+00_JPRB,3.4268E+00_JPRB,4.3944E+00_JPRB,5.1446E+00_JPRB/)
KBO( :, 5,21,10) = (/&
&1.0760E+00_JPRB,2.2689E+00_JPRB,3.5139E+00_JPRB,4.4592E+00_JPRB,5.0861E+00_JPRB/)
KBO( :, 1,22,10) = (/&
&3.1704E-01_JPRB,1.8909E+00_JPRB,3.1718E+00_JPRB,4.2211E+00_JPRB,5.3188E+00_JPRB/)
KBO( :, 2,22,10) = (/&
&4.4113E-01_JPRB,1.9967E+00_JPRB,3.2921E+00_JPRB,4.3258E+00_JPRB,5.2898E+00_JPRB/)
KBO( :, 3,22,10) = (/&
&5.9182E-01_JPRB,2.1052E+00_JPRB,3.4006E+00_JPRB,4.4235E+00_JPRB,5.2566E+00_JPRB/)
KBO( :, 4,22,10) = (/&
&7.6857E-01_JPRB,2.2097E+00_JPRB,3.4994E+00_JPRB,4.5051E+00_JPRB,5.2176E+00_JPRB/)
KBO( :, 5,22,10) = (/&
&9.7285E-01_JPRB,2.3126E+00_JPRB,3.5927E+00_JPRB,4.5701E+00_JPRB,5.1722E+00_JPRB/)
KBO( :, 1,23,10) = (/&
&2.8927E-01_JPRB,1.9014E+00_JPRB,3.1969E+00_JPRB,4.2666E+00_JPRB,5.3040E+00_JPRB/)
KBO( :, 2,23,10) = (/&
&4.0191E-01_JPRB,2.0125E+00_JPRB,3.3191E+00_JPRB,4.3795E+00_JPRB,5.2890E+00_JPRB/)
KBO( :, 3,23,10) = (/&
&5.3783E-01_JPRB,2.1222E+00_JPRB,3.4289E+00_JPRB,4.4796E+00_JPRB,5.2663E+00_JPRB/)
KBO( :, 4,23,10) = (/&
&6.9875E-01_JPRB,2.2290E+00_JPRB,3.5339E+00_JPRB,4.5665E+00_JPRB,5.2397E+00_JPRB/)
KBO( :, 5,23,10) = (/&
&8.8602E-01_JPRB,2.3359E+00_JPRB,3.6321E+00_JPRB,4.6372E+00_JPRB,5.2101E+00_JPRB/)
KBO( :, 1,24,10) = (/&
&2.6648E-01_JPRB,1.8914E+00_JPRB,3.1927E+00_JPRB,4.2785E+00_JPRB,5.2470E+00_JPRB/)
KBO( :, 2,24,10) = (/&
&3.6872E-01_JPRB,2.0063E+00_JPRB,3.3129E+00_JPRB,4.3925E+00_JPRB,5.2443E+00_JPRB/)
KBO( :, 3,24,10) = (/&
&4.9335E-01_JPRB,2.1181E+00_JPRB,3.4275E+00_JPRB,4.4944E+00_JPRB,5.2358E+00_JPRB/)
KBO( :, 4,24,10) = (/&
&6.4237E-01_JPRB,2.2281E+00_JPRB,3.5391E+00_JPRB,4.5872E+00_JPRB,5.2224E+00_JPRB/)
KBO( :, 5,24,10) = (/&
&8.1853E-01_JPRB,2.3388E+00_JPRB,3.6424E+00_JPRB,4.6721E+00_JPRB,5.2057E+00_JPRB/)
KBO( :, 1,25,10) = (/&
&2.4735E-01_JPRB,1.8676E+00_JPRB,3.1644E+00_JPRB,4.2512E+00_JPRB,5.1457E+00_JPRB/)
KBO( :, 2,25,10) = (/&
&3.4172E-01_JPRB,1.9814E+00_JPRB,3.2839E+00_JPRB,4.3716E+00_JPRB,5.1625E+00_JPRB/)
KBO( :, 3,25,10) = (/&
&4.5795E-01_JPRB,2.0952E+00_JPRB,3.4036E+00_JPRB,4.4805E+00_JPRB,5.1730E+00_JPRB/)
KBO( :, 4,25,10) = (/&
&5.9795E-01_JPRB,2.2113E+00_JPRB,3.5208E+00_JPRB,4.5808E+00_JPRB,5.1736E+00_JPRB/)
KBO( :, 5,25,10) = (/&
&7.5984E-01_JPRB,2.3264E+00_JPRB,3.6336E+00_JPRB,4.6738E+00_JPRB,5.1743E+00_JPRB/)
KBO( :, 1,26,10) = (/&
&2.3360E-01_JPRB,1.8352E+00_JPRB,3.1131E+00_JPRB,4.1942E+00_JPRB,5.0148E+00_JPRB/)
KBO( :, 2,26,10) = (/&
&3.2286E-01_JPRB,1.9478E+00_JPRB,3.2410E+00_JPRB,4.3228E+00_JPRB,5.0531E+00_JPRB/)
KBO( :, 3,26,10) = (/&
&4.3204E-01_JPRB,2.0643E+00_JPRB,3.3666E+00_JPRB,4.4432E+00_JPRB,5.0819E+00_JPRB/)
KBO( :, 4,26,10) = (/&
&5.6016E-01_JPRB,2.1838E+00_JPRB,3.4889E+00_JPRB,4.5535E+00_JPRB,5.1063E+00_JPRB/)
KBO( :, 5,26,10) = (/&
&7.0753E-01_JPRB,2.3058E+00_JPRB,3.6092E+00_JPRB,4.6573E+00_JPRB,5.1261E+00_JPRB/)
KBO( :, 1,27,10) = (/&
&2.2294E-01_JPRB,1.7950E+00_JPRB,3.0495E+00_JPRB,4.1133E+00_JPRB,4.8609E+00_JPRB/)
KBO( :, 2,27,10) = (/&
&3.0707E-01_JPRB,1.9093E+00_JPRB,3.1862E+00_JPRB,4.2562E+00_JPRB,4.9227E+00_JPRB/)
KBO( :, 3,27,10) = (/&
&4.0769E-01_JPRB,2.0286E+00_JPRB,3.3192E+00_JPRB,4.3886E+00_JPRB,4.9781E+00_JPRB/)
KBO( :, 4,27,10) = (/&
&5.2517E-01_JPRB,2.1513E+00_JPRB,3.4485E+00_JPRB,4.5128E+00_JPRB,5.0272E+00_JPRB/)
KBO( :, 5,27,10) = (/&
&6.6106E-01_JPRB,2.2811E+00_JPRB,3.5767E+00_JPRB,4.6309E+00_JPRB,5.0714E+00_JPRB/)
KBO( :, 1,28,10) = (/&
&2.1278E-01_JPRB,1.7516E+00_JPRB,2.9793E+00_JPRB,4.0203E+00_JPRB,4.7023E+00_JPRB/)
KBO( :, 2,28,10) = (/&
&2.9077E-01_JPRB,1.8695E+00_JPRB,3.1275E+00_JPRB,4.1790E+00_JPRB,4.7891E+00_JPRB/)
KBO( :, 3,28,10) = (/&
&3.8371E-01_JPRB,1.9907E+00_JPRB,3.2690E+00_JPRB,4.3298E+00_JPRB,4.8703E+00_JPRB/)
KBO( :, 4,28,10) = (/&
&4.9305E-01_JPRB,2.1190E+00_JPRB,3.4062E+00_JPRB,4.4719E+00_JPRB,4.9485E+00_JPRB/)
KBO( :, 5,28,10) = (/&
&6.1872E-01_JPRB,2.2538E+00_JPRB,3.5418E+00_JPRB,4.5998E+00_JPRB,5.0210E+00_JPRB/)
KBO( :, 1,29,10) = (/&
&2.0270E-01_JPRB,1.7094E+00_JPRB,2.9099E+00_JPRB,3.9283E+00_JPRB,4.5455E+00_JPRB/)
KBO( :, 2,29,10) = (/&
&2.7494E-01_JPRB,1.8321E+00_JPRB,3.0685E+00_JPRB,4.1039E+00_JPRB,4.6641E+00_JPRB/)
KBO( :, 3,29,10) = (/&
&3.6154E-01_JPRB,1.9564E+00_JPRB,3.2214E+00_JPRB,4.2736E+00_JPRB,4.7773E+00_JPRB/)
KBO( :, 4,29,10) = (/&
&4.6300E-01_JPRB,2.0903E+00_JPRB,3.3694E+00_JPRB,4.4317E+00_JPRB,4.8838E+00_JPRB/)
KBO( :, 5,29,10) = (/&
&5.8057E-01_JPRB,2.2289E+00_JPRB,3.5079E+00_JPRB,4.5763E+00_JPRB,4.9830E+00_JPRB/)
KBO( :, 1,30,10) = (/&
&1.9279E-01_JPRB,1.6706E+00_JPRB,2.8469E+00_JPRB,3.8440E+00_JPRB,4.4080E+00_JPRB/)
KBO( :, 2,30,10) = (/&
&2.6009E-01_JPRB,1.7962E+00_JPRB,3.0153E+00_JPRB,4.0402E+00_JPRB,4.5583E+00_JPRB/)
KBO( :, 3,30,10) = (/&
&3.4074E-01_JPRB,1.9283E+00_JPRB,3.1794E+00_JPRB,4.2253E+00_JPRB,4.7038E+00_JPRB/)
KBO( :, 4,30,10) = (/&
&4.3604E-01_JPRB,2.0655E+00_JPRB,3.3337E+00_JPRB,4.4011E+00_JPRB,4.8377E+00_JPRB/)
KBO( :, 5,30,10) = (/&
&5.4764E-01_JPRB,2.2092E+00_JPRB,3.4808E+00_JPRB,4.5595E+00_JPRB,4.9628E+00_JPRB/)
KBO( :, 1,31,10) = (/&
&1.8369E-01_JPRB,1.6365E+00_JPRB,2.7938E+00_JPRB,3.7778E+00_JPRB,4.2984E+00_JPRB/)
KBO( :, 2,31,10) = (/&
&2.4679E-01_JPRB,1.7684E+00_JPRB,2.9729E+00_JPRB,3.9905E+00_JPRB,4.4818E+00_JPRB/)
KBO( :, 3,31,10) = (/&
&3.2266E-01_JPRB,1.9061E+00_JPRB,3.1442E+00_JPRB,4.1950E+00_JPRB,4.6519E+00_JPRB/)
KBO( :, 4,31,10) = (/&
&4.1304E-01_JPRB,2.0477E+00_JPRB,3.3074E+00_JPRB,4.3826E+00_JPRB,4.8118E+00_JPRB/)
KBO( :, 5,31,10) = (/&
&5.2000E-01_JPRB,2.1969E+00_JPRB,3.4636E+00_JPRB,4.5527E+00_JPRB,4.9659E+00_JPRB/)
KBO( :, 1,32,10) = (/&
&1.7551E-01_JPRB,1.6097E+00_JPRB,2.7544E+00_JPRB,3.7286E+00_JPRB,4.2211E+00_JPRB/)
KBO( :, 2,32,10) = (/&
&2.3510E-01_JPRB,1.7486E+00_JPRB,2.9407E+00_JPRB,3.9624E+00_JPRB,4.4263E+00_JPRB/)
KBO( :, 3,32,10) = (/&
&3.0724E-01_JPRB,1.8916E+00_JPRB,3.1218E+00_JPRB,4.1778E+00_JPRB,4.6235E+00_JPRB/)
KBO( :, 4,32,10) = (/&
&3.9398E-01_JPRB,2.0379E+00_JPRB,3.2915E+00_JPRB,4.3768E+00_JPRB,4.8156E+00_JPRB/)
KBO( :, 5,32,10) = (/&
&4.9781E-01_JPRB,2.1923E+00_JPRB,3.4588E+00_JPRB,4.5574E+00_JPRB,4.9861E+00_JPRB/)
KBO( :, 1,33,10) = (/&
&1.6799E-01_JPRB,1.5914E+00_JPRB,2.7274E+00_JPRB,3.7024E+00_JPRB,4.1697E+00_JPRB/)
KBO( :, 2,33,10) = (/&
&2.2491E-01_JPRB,1.7368E+00_JPRB,2.9243E+00_JPRB,3.9492E+00_JPRB,4.4031E+00_JPRB/)
KBO( :, 3,33,10) = (/&
&2.9437E-01_JPRB,1.8837E+00_JPRB,3.1109E+00_JPRB,4.1768E+00_JPRB,4.6308E+00_JPRB/)
KBO( :, 4,33,10) = (/&
&3.7842E-01_JPRB,2.0362E+00_JPRB,3.2892E+00_JPRB,4.3833E+00_JPRB,4.8420E+00_JPRB/)
KBO( :, 5,33,10) = (/&
&4.8057E-01_JPRB,2.1931E+00_JPRB,3.4634E+00_JPRB,4.5721E+00_JPRB,5.0256E+00_JPRB/)
KBO( :, 1,34,10) = (/&
&1.5948E-01_JPRB,1.5775E+00_JPRB,2.7077E+00_JPRB,3.6846E+00_JPRB,4.1408E+00_JPRB/)
KBO( :, 2,34,10) = (/&
&2.1390E-01_JPRB,1.7270E+00_JPRB,2.9131E+00_JPRB,3.9429E+00_JPRB,4.4016E+00_JPRB/)
KBO( :, 3,34,10) = (/&
&2.8085E-01_JPRB,1.8791E+00_JPRB,3.1047E+00_JPRB,4.1792E+00_JPRB,4.6526E+00_JPRB/)
KBO( :, 4,34,10) = (/&
&3.6334E-01_JPRB,2.0371E+00_JPRB,3.2904E+00_JPRB,4.3938E+00_JPRB,4.8733E+00_JPRB/)
KBO( :, 5,34,10) = (/&
&4.6344E-01_JPRB,2.1941E+00_JPRB,3.4718E+00_JPRB,4.5911E+00_JPRB,5.0724E+00_JPRB/)
KBO( :, 1,35,10) = (/&
&1.4741E-01_JPRB,1.5567E+00_JPRB,2.6803E+00_JPRB,3.6561E+00_JPRB,4.1139E+00_JPRB/)
KBO( :, 2,35,10) = (/&
&1.9866E-01_JPRB,1.7096E+00_JPRB,2.8922E+00_JPRB,3.9256E+00_JPRB,4.4015E+00_JPRB/)
KBO( :, 3,35,10) = (/&
&2.6293E-01_JPRB,1.8664E+00_JPRB,3.0898E+00_JPRB,4.1709E+00_JPRB,4.6633E+00_JPRB/)
KBO( :, 4,35,10) = (/&
&3.4264E-01_JPRB,2.0276E+00_JPRB,3.2824E+00_JPRB,4.3940E+00_JPRB,4.8993E+00_JPRB/)
KBO( :, 5,35,10) = (/&
&4.3976E-01_JPRB,2.1842E+00_JPRB,3.4695E+00_JPRB,4.5966E+00_JPRB,5.1130E+00_JPRB/)
KBO( :, 1,36,10) = (/&
&1.3214E-01_JPRB,1.5254E+00_JPRB,2.6382E+00_JPRB,3.6093E+00_JPRB,4.0744E+00_JPRB/)
KBO( :, 2,36,10) = (/&
&1.7956E-01_JPRB,1.6813E+00_JPRB,2.8567E+00_JPRB,3.8896E+00_JPRB,4.3806E+00_JPRB/)
KBO( :, 3,36,10) = (/&
&2.4004E-01_JPRB,1.8415E+00_JPRB,3.0610E+00_JPRB,4.1453E+00_JPRB,4.6577E+00_JPRB/)
KBO( :, 4,36,10) = (/&
&3.1565E-01_JPRB,2.0040E+00_JPRB,3.2597E+00_JPRB,4.3756E+00_JPRB,4.9082E+00_JPRB/)
KBO( :, 5,36,10) = (/&
&4.0871E-01_JPRB,2.1610E+00_JPRB,3.4521E+00_JPRB,4.5836E+00_JPRB,5.1373E+00_JPRB/)
KBO( :, 1,37,10) = (/&
&1.1316E-01_JPRB,1.4752E+00_JPRB,2.5688E+00_JPRB,3.5261E+00_JPRB,3.9938E+00_JPRB/)
KBO( :, 2,37,10) = (/&
&1.5558E-01_JPRB,1.6337E+00_JPRB,2.7946E+00_JPRB,3.8188E+00_JPRB,4.3194E+00_JPRB/)
KBO( :, 3,37,10) = (/&
&2.1051E-01_JPRB,1.7957E+00_JPRB,3.0066E+00_JPRB,4.0860E+00_JPRB,4.6128E+00_JPRB/)
KBO( :, 4,37,10) = (/&
&2.8028E-01_JPRB,1.9593E+00_JPRB,3.2111E+00_JPRB,4.3259E+00_JPRB,4.8781E+00_JPRB/)
KBO( :, 5,37,10) = (/&
&3.6684E-01_JPRB,2.1183E+00_JPRB,3.4096E+00_JPRB,4.5437E+00_JPRB,5.1231E+00_JPRB/)
KBO( :, 1,38,10) = (/&
&9.6748E-02_JPRB,1.4275E+00_JPRB,2.5025E+00_JPRB,3.4448E+00_JPRB,3.9178E+00_JPRB/)
KBO( :, 2,38,10) = (/&
&1.3470E-01_JPRB,1.5886E+00_JPRB,2.7351E+00_JPRB,3.7489E+00_JPRB,4.2599E+00_JPRB/)
KBO( :, 3,38,10) = (/&
&1.8442E-01_JPRB,1.7514E+00_JPRB,2.9540E+00_JPRB,4.0269E+00_JPRB,4.5684E+00_JPRB/)
KBO( :, 4,38,10) = (/&
&2.4862E-01_JPRB,1.9169E+00_JPRB,3.1637E+00_JPRB,4.2769E+00_JPRB,4.8492E+00_JPRB/)
KBO( :, 5,38,10) = (/&
&3.2905E-01_JPRB,2.0776E+00_JPRB,3.3672E+00_JPRB,4.5027E+00_JPRB,5.1082E+00_JPRB/)
KBO( :, 1,39,10) = (/&
&8.2846E-02_JPRB,1.3834E+00_JPRB,2.4412E+00_JPRB,3.3680E+00_JPRB,3.8485E+00_JPRB/)
KBO( :, 2,39,10) = (/&
&1.1685E-01_JPRB,1.5463E+00_JPRB,2.6796E+00_JPRB,3.6824E+00_JPRB,4.2039E+00_JPRB/)
KBO( :, 3,39,10) = (/&
&1.6194E-01_JPRB,1.7108E+00_JPRB,2.9043E+00_JPRB,3.9699E+00_JPRB,4.5285E+00_JPRB/)
KBO( :, 4,39,10) = (/&
&2.2088E-01_JPRB,1.8779E+00_JPRB,3.1188E+00_JPRB,4.2292E+00_JPRB,4.8250E+00_JPRB/)
KBO( :, 5,39,10) = (/&
&2.9576E-01_JPRB,2.0398E+00_JPRB,3.3275E+00_JPRB,4.4625E+00_JPRB,5.0971E+00_JPRB/)
KBO( :, 1,40,10) = (/&
&6.8460E-02_JPRB,1.3257E+00_JPRB,2.3577E+00_JPRB,3.2603E+00_JPRB,3.7339E+00_JPRB/)
KBO( :, 2,40,10) = (/&
&9.7988E-02_JPRB,1.4903E+00_JPRB,2.6023E+00_JPRB,3.5872E+00_JPRB,4.1045E+00_JPRB/)
KBO( :, 3,40,10) = (/&
&1.3775E-01_JPRB,1.6559E+00_JPRB,2.8336E+00_JPRB,3.8858E+00_JPRB,4.4458E+00_JPRB/)
KBO( :, 4,40,10) = (/&
&1.9045E-01_JPRB,1.8245E+00_JPRB,3.0542E+00_JPRB,4.1559E+00_JPRB,4.7581E+00_JPRB/)
KBO( :, 5,40,10) = (/&
&2.5849E-01_JPRB,1.9886E+00_JPRB,3.2674E+00_JPRB,4.3994E+00_JPRB,5.0432E+00_JPRB/)
KBO( :, 1,41,10) = (/&
&5.6234E-02_JPRB,1.2690E+00_JPRB,2.2720E+00_JPRB,3.1495E+00_JPRB,3.6139E+00_JPRB/)
KBO( :, 2,41,10) = (/&
&8.1724E-02_JPRB,1.4342E+00_JPRB,2.5230E+00_JPRB,3.4875E+00_JPRB,3.9992E+00_JPRB/)
KBO( :, 3,41,10) = (/&
&1.1661E-01_JPRB,1.6007E+00_JPRB,2.7616E+00_JPRB,3.7972E+00_JPRB,4.3567E+00_JPRB/)
KBO( :, 4,41,10) = (/&
&1.6350E-01_JPRB,1.7709E+00_JPRB,2.9870E+00_JPRB,4.0779E+00_JPRB,4.6840E+00_JPRB/)
KBO( :, 5,41,10) = (/&
&2.2482E-01_JPRB,1.9373E+00_JPRB,3.2036E+00_JPRB,4.3314E+00_JPRB,4.9822E+00_JPRB/)
KBO( :, 1,42,10) = (/&
&4.6099E-02_JPRB,1.2146E+00_JPRB,2.1872E+00_JPRB,3.0381E+00_JPRB,3.4945E+00_JPRB/)
KBO( :, 2,42,10) = (/&
&6.8068E-02_JPRB,1.3798E+00_JPRB,2.4452E+00_JPRB,3.3871E+00_JPRB,3.8938E+00_JPRB/)
KBO( :, 3,42,10) = (/&
&9.8587E-02_JPRB,1.5478E+00_JPRB,2.6891E+00_JPRB,3.7072E+00_JPRB,4.2665E+00_JPRB/)
KBO( :, 4,42,10) = (/&
&1.4020E-01_JPRB,1.7187E+00_JPRB,2.9198E+00_JPRB,3.9988E+00_JPRB,4.6092E+00_JPRB/)
KBO( :, 5,42,10) = (/&
&1.9544E-01_JPRB,1.8864E+00_JPRB,3.1414E+00_JPRB,4.2616E+00_JPRB,4.9213E+00_JPRB/)
KBO( :, 1,43,10) = (/&
&3.6837E-02_JPRB,1.1530E+00_JPRB,2.0885E+00_JPRB,2.9067E+00_JPRB,3.3518E+00_JPRB/)
KBO( :, 2,43,10) = (/&
&5.5339E-02_JPRB,1.3181E+00_JPRB,2.3532E+00_JPRB,3.2663E+00_JPRB,3.7650E+00_JPRB/)
KBO( :, 3,43,10) = (/&
&8.1513E-02_JPRB,1.4866E+00_JPRB,2.6028E+00_JPRB,3.5988E+00_JPRB,4.1527E+00_JPRB/)
KBO( :, 4,43,10) = (/&
&1.1773E-01_JPRB,1.6570E+00_JPRB,2.8399E+00_JPRB,3.9012E+00_JPRB,4.5115E+00_JPRB/)
KBO( :, 5,43,10) = (/&
&1.6664E-01_JPRB,1.8278E+00_JPRB,3.0668E+00_JPRB,4.1754E+00_JPRB,4.8396E+00_JPRB/)
KBO( :, 1,44,10) = (/&
&2.8988E-02_JPRB,1.0887E+00_JPRB,1.9830E+00_JPRB,2.7653E+00_JPRB,3.1966E+00_JPRB/)
KBO( :, 2,44,10) = (/&
&4.4338E-02_JPRB,1.2532E+00_JPRB,2.2540E+00_JPRB,3.1344E+00_JPRB,3.6243E+00_JPRB/)
KBO( :, 3,44,10) = (/&
&6.6501E-02_JPRB,1.4222E+00_JPRB,2.5105E+00_JPRB,3.4789E+00_JPRB,4.0260E+00_JPRB/)
KBO( :, 4,44,10) = (/&
&9.7639E-02_JPRB,1.5932E+00_JPRB,2.7543E+00_JPRB,3.7931E+00_JPRB,4.4021E+00_JPRB/)
KBO( :, 5,44,10) = (/&
&1.4052E-01_JPRB,1.7655E+00_JPRB,2.9842E+00_JPRB,4.0798E+00_JPRB,4.7466E+00_JPRB/)
KBO( :, 1,45,10) = (/&
&2.2674E-02_JPRB,1.0257E+00_JPRB,1.8783E+00_JPRB,2.6228E+00_JPRB,3.0412E+00_JPRB/)
KBO( :, 2,45,10) = (/&
&3.5361E-02_JPRB,1.1906E+00_JPRB,2.1544E+00_JPRB,3.0007E+00_JPRB,3.4821E+00_JPRB/)
KBO( :, 3,45,10) = (/&
&5.3984E-02_JPRB,1.3593E+00_JPRB,2.4179E+00_JPRB,3.3558E+00_JPRB,3.8978E+00_JPRB/)
KBO( :, 4,45,10) = (/&
&8.0687E-02_JPRB,1.5302E+00_JPRB,2.6662E+00_JPRB,3.6830E+00_JPRB,4.2916E+00_JPRB/)
KBO( :, 5,45,10) = (/&
&1.1807E-01_JPRB,1.7032E+00_JPRB,2.9026E+00_JPRB,3.9804E+00_JPRB,4.6530E+00_JPRB/)
KBO( :, 1,46,10) = (/&
&1.7410E-02_JPRB,9.6094E-01_JPRB,1.7674E+00_JPRB,2.4706E+00_JPRB,2.8739E+00_JPRB/)
KBO( :, 2,46,10) = (/&
&2.7786E-02_JPRB,1.1256E+00_JPRB,2.0477E+00_JPRB,2.8564E+00_JPRB,3.3272E+00_JPRB/)
KBO( :, 3,46,10) = (/&
&4.3233E-02_JPRB,1.2931E+00_JPRB,2.3174E+00_JPRB,3.2226E+00_JPRB,3.7574E+00_JPRB/)
KBO( :, 4,46,10) = (/&
&6.5795E-02_JPRB,1.4641E+00_JPRB,2.5723E+00_JPRB,3.5627E+00_JPRB,4.1675E+00_JPRB/)
KBO( :, 5,46,10) = (/&
&9.8017E-02_JPRB,1.6372E+00_JPRB,2.8147E+00_JPRB,3.8708E+00_JPRB,4.5474E+00_JPRB/)
KBO( :, 1,47,10) = (/&
&1.2932E-02_JPRB,8.9077E-01_JPRB,1.6439E+00_JPRB,2.2995E+00_JPRB,2.6825E+00_JPRB/)
KBO( :, 2,47,10) = (/&
&2.1223E-02_JPRB,1.0540E+00_JPRB,1.9287E+00_JPRB,2.6946E+00_JPRB,3.1473E+00_JPRB/)
KBO( :, 3,47,10) = (/&
&3.3771E-02_JPRB,1.2207E+00_JPRB,2.2047E+00_JPRB,3.0711E+00_JPRB,3.5926E+00_JPRB/)
KBO( :, 4,47,10) = (/&
&5.2401E-02_JPRB,1.3916E+00_JPRB,2.4667E+00_JPRB,3.4226E+00_JPRB,4.0177E+00_JPRB/)
KBO( :, 5,47,10) = (/&
&7.9614E-02_JPRB,1.5646E+00_JPRB,2.7148E+00_JPRB,3.7454E+00_JPRB,4.4170E+00_JPRB/)
KBO( :, 1,48,10) = (/&
&9.4853E-03_JPRB,8.2116E-01_JPRB,1.5192E+00_JPRB,2.1278E+00_JPRB,2.4903E+00_JPRB/)
KBO( :, 2,48,10) = (/&
&1.6017E-02_JPRB,9.8364E-01_JPRB,1.8094E+00_JPRB,2.5302E+00_JPRB,2.9654E+00_JPRB/)
KBO( :, 3,48,10) = (/&
&2.6151E-02_JPRB,1.1500E+00_JPRB,2.0897E+00_JPRB,2.9152E+00_JPRB,3.4258E+00_JPRB/)
KBO( :, 4,48,10) = (/&
&4.1450E-02_JPRB,1.3196E+00_JPRB,2.3589E+00_JPRB,3.2790E+00_JPRB,3.8661E+00_JPRB/)
KBO( :, 5,48,10) = (/&
&6.4206E-02_JPRB,1.4922E+00_JPRB,2.6125E+00_JPRB,3.6159E+00_JPRB,4.2851E+00_JPRB/)
KBO( :, 1,49,10) = (/&
&6.8584E-03_JPRB,7.5265E-01_JPRB,1.3951E+00_JPRB,1.9557E+00_JPRB,2.2987E+00_JPRB/)
KBO( :, 2,49,10) = (/&
&1.1934E-02_JPRB,9.1467E-01_JPRB,1.6885E+00_JPRB,2.3631E+00_JPRB,2.7820E+00_JPRB/)
KBO( :, 3,49,10) = (/&
&2.0019E-02_JPRB,1.0797E+00_JPRB,1.9731E+00_JPRB,2.7567E+00_JPRB,3.2569E+00_JPRB/)
KBO( :, 4,49,10) = (/&
&3.2532E-02_JPRB,1.2481E+00_JPRB,2.2484E+00_JPRB,3.1312E+00_JPRB,3.7144E+00_JPRB/)
KBO( :, 5,49,10) = (/&
&5.1423E-02_JPRB,1.4202E+00_JPRB,2.5087E+00_JPRB,3.4802E+00_JPRB,4.1524E+00_JPRB/)
KBO( :, 1,50,10) = (/&
&4.9588E-03_JPRB,6.8907E-01_JPRB,1.2794E+00_JPRB,1.7942E+00_JPRB,2.1153E+00_JPRB/)
KBO( :, 2,50,10) = (/&
&8.8947E-03_JPRB,8.5045E-01_JPRB,1.5739E+00_JPRB,2.2042E+00_JPRB,2.6031E+00_JPRB/)
KBO( :, 3,50,10) = (/&
&1.5348E-02_JPRB,1.0143E+00_JPRB,1.8632E+00_JPRB,2.6056E+00_JPRB,3.0870E+00_JPRB/)
KBO( :, 4,50,10) = (/&
&2.5608E-02_JPRB,1.1821E+00_JPRB,2.1430E+00_JPRB,2.9888E+00_JPRB,3.5596E+00_JPRB/)
KBO( :, 5,50,10) = (/&
&4.1387E-02_JPRB,1.3536E+00_JPRB,2.4101E+00_JPRB,3.3481E+00_JPRB,4.0115E+00_JPRB/)
KBO( :, 1,51,10) = (/&
&3.5571E-03_JPRB,6.2785E-01_JPRB,1.1678E+00_JPRB,1.6386E+00_JPRB,1.9369E+00_JPRB/)
KBO( :, 2,51,10) = (/&
&6.5893E-03_JPRB,7.8876E-01_JPRB,1.4624E+00_JPRB,2.0498E+00_JPRB,2.4257E+00_JPRB/)
KBO( :, 3,51,10) = (/&
&1.1707E-02_JPRB,9.5177E-01_JPRB,1.7551E+00_JPRB,2.4566E+00_JPRB,2.9162E+00_JPRB/)
KBO( :, 4,51,10) = (/&
&2.0074E-02_JPRB,1.1187E+00_JPRB,2.0387E+00_JPRB,2.8466E+00_JPRB,3.3998E+00_JPRB/)
KBO( :, 5,51,10) = (/&
&3.3273E-02_JPRB,1.2890E+00_JPRB,2.3117E+00_JPRB,3.2168E+00_JPRB,3.8651E+00_JPRB/)
KBO( :, 1,52,10) = (/&
&2.5127E-03_JPRB,5.6820E-01_JPRB,1.0583E+00_JPRB,1.4864E+00_JPRB,1.7624E+00_JPRB/)
KBO( :, 2,52,10) = (/&
&4.8248E-03_JPRB,7.2792E-01_JPRB,1.3512E+00_JPRB,1.8952E+00_JPRB,2.2490E+00_JPRB/)
KBO( :, 3,52,10) = (/&
&8.8346E-03_JPRB,8.9029E-01_JPRB,1.6463E+00_JPRB,2.3052E+00_JPRB,2.7452E+00_JPRB/)
KBO( :, 4,52,10) = (/&
&1.5583E-02_JPRB,1.0558E+00_JPRB,1.9336E+00_JPRB,2.7033E+00_JPRB,3.2391E+00_JPRB/)
KBO( :, 5,52,10) = (/&
&2.6529E-02_JPRB,1.2246E+00_JPRB,2.2115E+00_JPRB,3.0824E+00_JPRB,3.7180E+00_JPRB/)
KBO( :, 1,53,10) = (/&
&1.7459E-03_JPRB,5.1010E-01_JPRB,9.5136E-01_JPRB,1.3367E+00_JPRB,1.5916E+00_JPRB/)
KBO( :, 2,53,10) = (/&
&3.4808E-03_JPRB,6.6729E-01_JPRB,1.2403E+00_JPRB,1.7405E+00_JPRB,2.0746E+00_JPRB/)
KBO( :, 3,53,10) = (/&
&6.5872E-03_JPRB,8.2899E-01_JPRB,1.5363E+00_JPRB,2.1529E+00_JPRB,2.5747E+00_JPRB/)
KBO( :, 4,53,10) = (/&
&1.1962E-02_JPRB,9.9325E-01_JPRB,1.8279E+00_JPRB,2.5576E+00_JPRB,3.0783E+00_JPRB/)
KBO( :, 5,53,10) = (/&
&2.0951E-02_JPRB,1.1616E+00_JPRB,2.1096E+00_JPRB,2.9440E+00_JPRB,3.5715E+00_JPRB/)
KBO( :, 1,54,10) = (/&
&1.2204E-03_JPRB,4.5823E-01_JPRB,8.5579E-01_JPRB,1.2025E+00_JPRB,1.4326E+00_JPRB/)
KBO( :, 2,54,10) = (/&
&2.5281E-03_JPRB,6.1212E-01_JPRB,1.1396E+00_JPRB,1.5999E+00_JPRB,1.9069E+00_JPRB/)
KBO( :, 3,54,10) = (/&
&4.9409E-03_JPRB,7.7338E-01_JPRB,1.4350E+00_JPRB,2.0125E+00_JPRB,2.4041E+00_JPRB/)
KBO( :, 4,54,10) = (/&
&9.2436E-03_JPRB,9.3695E-01_JPRB,1.7295E+00_JPRB,2.4215E+00_JPRB,2.9094E+00_JPRB/)
KBO( :, 5,54,10) = (/&
&1.6670E-02_JPRB,1.1040E+00_JPRB,2.0145E+00_JPRB,2.8142E+00_JPRB,3.4095E+00_JPRB/)
KBO( :, 1,55,10) = (/&
&8.4904E-04_JPRB,4.1031E-01_JPRB,7.6714E-01_JPRB,1.0777E+00_JPRB,1.2810E+00_JPRB/)
KBO( :, 2,55,10) = (/&
&1.8289E-03_JPRB,5.6051E-01_JPRB,1.0445E+00_JPRB,1.4675E+00_JPRB,1.7437E+00_JPRB/)
KBO( :, 3,55,10) = (/&
&3.6957E-03_JPRB,7.2049E-01_JPRB,1.3381E+00_JPRB,1.8775E+00_JPRB,2.2346E+00_JPRB/)
KBO( :, 4,55,10) = (/&
&7.1338E-03_JPRB,8.8320E-01_JPRB,1.6342E+00_JPRB,2.2888E+00_JPRB,2.7356E+00_JPRB/)
KBO( :, 5,55,10) = (/&
&1.3248E-02_JPRB,1.0490E+00_JPRB,1.9226E+00_JPRB,2.6886E+00_JPRB,3.2366E+00_JPRB/)
KBO( :, 1,56,10) = (/&
&5.8188E-04_JPRB,3.6451E-01_JPRB,6.8188E-01_JPRB,9.5775E-01_JPRB,1.1364E+00_JPRB/)
KBO( :, 2,56,10) = (/&
&1.3061E-03_JPRB,5.1010E-01_JPRB,9.5157E-01_JPRB,1.3373E+00_JPRB,1.5849E+00_JPRB/)
KBO( :, 3,56,10) = (/&
&2.7348E-03_JPRB,6.6775E-01_JPRB,1.2416E+00_JPRB,1.7426E+00_JPRB,2.0675E+00_JPRB/)
KBO( :, 4,56,10) = (/&
&5.4506E-03_JPRB,8.2982E-01_JPRB,1.5384E+00_JPRB,2.1560E+00_JPRB,2.5656E+00_JPRB/)
KBO( :, 5,56,10) = (/&
&1.0438E-02_JPRB,9.9464E-01_JPRB,1.8304E+00_JPRB,2.5617E+00_JPRB,3.0643E+00_JPRB/)
KBO( :, 1,57,10) = (/&
&3.9249E-04_JPRB,3.2068E-01_JPRB,6.0044E-01_JPRB,8.4280E-01_JPRB,9.9873E-01_JPRB/)
KBO( :, 2,57,10) = (/&
&9.2030E-04_JPRB,4.6083E-01_JPRB,8.6077E-01_JPRB,1.2098E+00_JPRB,1.4302E+00_JPRB/)
KBO( :, 3,57,10) = (/&
&2.0002E-03_JPRB,6.1542E-01_JPRB,1.1460E+00_JPRB,1.6091E+00_JPRB,1.9029E+00_JPRB/)
KBO( :, 4,57,10) = (/&
&4.1235E-03_JPRB,7.7708E-01_JPRB,1.4422E+00_JPRB,2.0227E+00_JPRB,2.3967E+00_JPRB/)
KBO( :, 5,57,10) = (/&
&8.1478E-03_JPRB,9.4098E-01_JPRB,1.7369E+00_JPRB,2.4323E+00_JPRB,2.8933E+00_JPRB/)
KBO( :, 1,58,10) = (/&
&2.6430E-04_JPRB,2.8122E-01_JPRB,5.2695E-01_JPRB,7.3930E-01_JPRB,8.7420E-01_JPRB/)
KBO( :, 2,58,10) = (/&
&6.4821E-04_JPRB,4.1579E-01_JPRB,7.7745E-01_JPRB,1.0922E+00_JPRB,1.2875E+00_JPRB/)
KBO( :, 3,58,10) = (/&
&1.4624E-03_JPRB,5.6685E-01_JPRB,1.0564E+00_JPRB,1.4844E+00_JPRB,1.7489E+00_JPRB/)
KBO( :, 4,58,10) = (/&
&3.1206E-03_JPRB,7.2740E-01_JPRB,1.3510E+00_JPRB,1.8958E+00_JPRB,2.2357E+00_JPRB/)
KBO( :, 5,58,10) = (/&
&6.3628E-03_JPRB,8.9041E-01_JPRB,1.6474E+00_JPRB,2.3075E+00_JPRB,2.7302E+00_JPRB/)
KBO( :, 1,59,10) = (/&
&2.0990E-04_JPRB,2.6575E-01_JPRB,4.9806E-01_JPRB,6.9856E-01_JPRB,8.1922E-01_JPRB/)
KBO( :, 2,59,10) = (/&
&5.2942E-04_JPRB,3.9787E-01_JPRB,7.4416E-01_JPRB,1.0453E+00_JPRB,1.2213E+00_JPRB/)
KBO( :, 3,59,10) = (/&
&1.2254E-03_JPRB,5.4737E-01_JPRB,1.0206E+00_JPRB,1.4342E+00_JPRB,1.6735E+00_JPRB/)
KBO( :, 4,59,10) = (/&
&2.6840E-03_JPRB,7.0712E-01_JPRB,1.3141E+00_JPRB,1.8442E+00_JPRB,2.1507E+00_JPRB/)
KBO( :, 5,59,10) = (/&
&5.6182E-03_JPRB,8.7007E-01_JPRB,1.6111E+00_JPRB,2.2569E+00_JPRB,2.6371E+00_JPRB/)
KBO( :, 1,13,11) = (/&
&1.0801E+00_JPRB,1.4348E+00_JPRB,2.0789E+00_JPRB,2.8766E+00_JPRB,3.7088E+00_JPRB/)
KBO( :, 2,13,11) = (/&
&1.5786E+00_JPRB,1.6909E+00_JPRB,2.2344E+00_JPRB,2.8378E+00_JPRB,3.6154E+00_JPRB/)
KBO( :, 3,13,11) = (/&
&2.1806E+00_JPRB,1.9878E+00_JPRB,2.3945E+00_JPRB,2.8212E+00_JPRB,3.5326E+00_JPRB/)
KBO( :, 4,13,11) = (/&
&2.8720E+00_JPRB,2.3800E+00_JPRB,2.5914E+00_JPRB,2.8385E+00_JPRB,3.4655E+00_JPRB/)
KBO( :, 5,13,11) = (/&
&3.6411E+00_JPRB,2.8911E+00_JPRB,2.8480E+00_JPRB,2.9116E+00_JPRB,3.4228E+00_JPRB/)
KBO( :, 1,14,11) = (/&
&1.1044E+00_JPRB,1.5475E+00_JPRB,2.2497E+00_JPRB,3.1463E+00_JPRB,4.0884E+00_JPRB/)
KBO( :, 2,14,11) = (/&
&1.5971E+00_JPRB,1.7939E+00_JPRB,2.3794E+00_JPRB,3.1054E+00_JPRB,3.9980E+00_JPRB/)
KBO( :, 3,14,11) = (/&
&2.1821E+00_JPRB,2.0987E+00_JPRB,2.5507E+00_JPRB,3.0870E+00_JPRB,3.9208E+00_JPRB/)
KBO( :, 4,14,11) = (/&
&2.8502E+00_JPRB,2.4509E+00_JPRB,2.7671E+00_JPRB,3.1108E+00_JPRB,3.8503E+00_JPRB/)
KBO( :, 5,14,11) = (/&
&3.5884E+00_JPRB,2.8921E+00_JPRB,3.0089E+00_JPRB,3.1705E+00_JPRB,3.7851E+00_JPRB/)
KBO( :, 1,15,11) = (/&
&1.1021E+00_JPRB,1.6587E+00_JPRB,2.4815E+00_JPRB,3.5024E+00_JPRB,4.5632E+00_JPRB/)
KBO( :, 2,15,11) = (/&
&1.5743E+00_JPRB,1.8988E+00_JPRB,2.5745E+00_JPRB,3.4612E+00_JPRB,4.4691E+00_JPRB/)
KBO( :, 3,15,11) = (/&
&2.1315E+00_JPRB,2.1848E+00_JPRB,2.7319E+00_JPRB,3.4370E+00_JPRB,4.3819E+00_JPRB/)
KBO( :, 4,15,11) = (/&
&2.7650E+00_JPRB,2.5138E+00_JPRB,2.9331E+00_JPRB,3.4633E+00_JPRB,4.3032E+00_JPRB/)
KBO( :, 5,15,11) = (/&
&3.4727E+00_JPRB,2.9032E+00_JPRB,3.1579E+00_JPRB,3.5044E+00_JPRB,4.2227E+00_JPRB/)
KBO( :, 1,16,11) = (/&
&1.0714E+00_JPRB,1.7588E+00_JPRB,2.7564E+00_JPRB,3.8747E+00_JPRB,5.0508E+00_JPRB/)
KBO( :, 2,16,11) = (/&
&1.5150E+00_JPRB,1.9873E+00_JPRB,2.8550E+00_JPRB,3.8426E+00_JPRB,4.9605E+00_JPRB/)
KBO( :, 3,16,11) = (/&
&2.0368E+00_JPRB,2.2470E+00_JPRB,2.9773E+00_JPRB,3.8351E+00_JPRB,4.8716E+00_JPRB/)
KBO( :, 4,16,11) = (/&
&2.6368E+00_JPRB,2.5533E+00_JPRB,3.1361E+00_JPRB,3.8536E+00_JPRB,4.7863E+00_JPRB/)
KBO( :, 5,16,11) = (/&
&3.3066E+00_JPRB,2.9151E+00_JPRB,3.3174E+00_JPRB,3.8762E+00_JPRB,4.6948E+00_JPRB/)
KBO( :, 1,17,11) = (/&
&1.0151E+00_JPRB,1.8852E+00_JPRB,3.0518E+00_JPRB,4.2628E+00_JPRB,5.5542E+00_JPRB/)
KBO( :, 2,17,11) = (/&
&1.4250E+00_JPRB,2.0700E+00_JPRB,3.1614E+00_JPRB,4.2288E+00_JPRB,5.4601E+00_JPRB/)
KBO( :, 3,17,11) = (/&
&1.9121E+00_JPRB,2.3001E+00_JPRB,3.2776E+00_JPRB,4.2348E+00_JPRB,5.3679E+00_JPRB/)
KBO( :, 4,17,11) = (/&
&2.4694E+00_JPRB,2.5770E+00_JPRB,3.4037E+00_JPRB,4.2558E+00_JPRB,5.2730E+00_JPRB/)
KBO( :, 5,17,11) = (/&
&3.0899E+00_JPRB,2.9049E+00_JPRB,3.5383E+00_JPRB,4.2898E+00_JPRB,5.1747E+00_JPRB/)
KBO( :, 1,18,11) = (/&
&9.4290E-01_JPRB,2.0484E+00_JPRB,3.3469E+00_JPRB,4.6479E+00_JPRB,6.0575E+00_JPRB/)
KBO( :, 2,18,11) = (/&
&1.3205E+00_JPRB,2.1931E+00_JPRB,3.4728E+00_JPRB,4.6183E+00_JPRB,5.9563E+00_JPRB/)
KBO( :, 3,18,11) = (/&
&1.7655E+00_JPRB,2.3717E+00_JPRB,3.5959E+00_JPRB,4.6412E+00_JPRB,5.8591E+00_JPRB/)
KBO( :, 4,18,11) = (/&
&2.2742E+00_JPRB,2.6014E+00_JPRB,3.7076E+00_JPRB,4.6704E+00_JPRB,5.7576E+00_JPRB/)
KBO( :, 5,18,11) = (/&
&2.8368E+00_JPRB,2.8834E+00_JPRB,3.8149E+00_JPRB,4.7239E+00_JPRB,5.6493E+00_JPRB/)
KBO( :, 1,19,11) = (/&
&8.6437E-01_JPRB,2.2167E+00_JPRB,3.6423E+00_JPRB,5.0107E+00_JPRB,6.5258E+00_JPRB/)
KBO( :, 2,19,11) = (/&
&1.2052E+00_JPRB,2.3536E+00_JPRB,3.7778E+00_JPRB,5.0137E+00_JPRB,6.4336E+00_JPRB/)
KBO( :, 3,19,11) = (/&
&1.6063E+00_JPRB,2.4963E+00_JPRB,3.9078E+00_JPRB,5.0409E+00_JPRB,6.3317E+00_JPRB/)
KBO( :, 4,19,11) = (/&
&2.0613E+00_JPRB,2.6673E+00_JPRB,4.0216E+00_JPRB,5.0848E+00_JPRB,6.2172E+00_JPRB/)
KBO( :, 5,19,11) = (/&
&2.5635E+00_JPRB,2.8852E+00_JPRB,4.1233E+00_JPRB,5.1457E+00_JPRB,6.0969E+00_JPRB/)
KBO( :, 1,20,11) = (/&
&7.8779E-01_JPRB,2.3765E+00_JPRB,3.9264E+00_JPRB,5.3499E+00_JPRB,6.9480E+00_JPRB/)
KBO( :, 2,20,11) = (/&
&1.0926E+00_JPRB,2.5148E+00_JPRB,4.0670E+00_JPRB,5.3834E+00_JPRB,6.8553E+00_JPRB/)
KBO( :, 3,20,11) = (/&
&1.4487E+00_JPRB,2.6525E+00_JPRB,4.1962E+00_JPRB,5.4179E+00_JPRB,6.7496E+00_JPRB/)
KBO( :, 4,20,11) = (/&
&1.8513E+00_JPRB,2.7916E+00_JPRB,4.3148E+00_JPRB,5.4862E+00_JPRB,6.6370E+00_JPRB/)
KBO( :, 5,20,11) = (/&
&2.2991E+00_JPRB,2.9510E+00_JPRB,4.4216E+00_JPRB,5.5498E+00_JPRB,6.5228E+00_JPRB/)
KBO( :, 1,21,11) = (/&
&7.0932E-01_JPRB,2.5175E+00_JPRB,4.1824E+00_JPRB,5.6525E+00_JPRB,7.2957E+00_JPRB/)
KBO( :, 2,21,11) = (/&
&9.7801E-01_JPRB,2.6602E+00_JPRB,4.3300E+00_JPRB,5.6984E+00_JPRB,7.2060E+00_JPRB/)
KBO( :, 3,21,11) = (/&
&1.2908E+00_JPRB,2.7977E+00_JPRB,4.4565E+00_JPRB,5.7675E+00_JPRB,7.1115E+00_JPRB/)
KBO( :, 4,21,11) = (/&
&1.6486E+00_JPRB,2.9337E+00_JPRB,4.5784E+00_JPRB,5.8514E+00_JPRB,7.0112E+00_JPRB/)
KBO( :, 5,21,11) = (/&
&2.0548E+00_JPRB,3.0662E+00_JPRB,4.6884E+00_JPRB,5.9211E+00_JPRB,6.9051E+00_JPRB/)
KBO( :, 1,22,11) = (/&
&6.4634E-01_JPRB,2.6427E+00_JPRB,4.4108E+00_JPRB,5.9111E+00_JPRB,7.5603E+00_JPRB/)
KBO( :, 2,22,11) = (/&
&8.8382E-01_JPRB,2.7886E+00_JPRB,4.5605E+00_JPRB,5.9821E+00_JPRB,7.4874E+00_JPRB/)
KBO( :, 3,22,11) = (/&
&1.1630E+00_JPRB,2.9292E+00_JPRB,4.6954E+00_JPRB,6.0879E+00_JPRB,7.4042E+00_JPRB/)
KBO( :, 4,22,11) = (/&
&1.4885E+00_JPRB,3.0664E+00_JPRB,4.8184E+00_JPRB,6.1855E+00_JPRB,7.3136E+00_JPRB/)
KBO( :, 5,22,11) = (/&
&1.8588E+00_JPRB,3.1975E+00_JPRB,4.9293E+00_JPRB,6.2618E+00_JPRB,7.2153E+00_JPRB/)
KBO( :, 1,23,11) = (/&
&5.8489E-01_JPRB,2.7446E+00_JPRB,4.5940E+00_JPRB,6.1135E+00_JPRB,7.7491E+00_JPRB/)
KBO( :, 2,23,11) = (/&
&7.9682E-01_JPRB,2.8912E+00_JPRB,4.7488E+00_JPRB,6.2356E+00_JPRB,7.6928E+00_JPRB/)
KBO( :, 3,23,11) = (/&
&1.0504E+00_JPRB,3.0346E+00_JPRB,4.8968E+00_JPRB,6.3608E+00_JPRB,7.6287E+00_JPRB/)
KBO( :, 4,23,11) = (/&
&1.3447E+00_JPRB,3.1725E+00_JPRB,5.0242E+00_JPRB,6.4689E+00_JPRB,7.5521E+00_JPRB/)
KBO( :, 5,23,11) = (/&
&1.6807E+00_JPRB,3.3048E+00_JPRB,5.1382E+00_JPRB,6.5524E+00_JPRB,7.4632E+00_JPRB/)
KBO( :, 1,24,11) = (/&
&5.2989E-01_JPRB,2.8195E+00_JPRB,4.7301E+00_JPRB,6.2761E+00_JPRB,7.8550E+00_JPRB/)
KBO( :, 2,24,11) = (/&
&7.2198E-01_JPRB,2.9702E+00_JPRB,4.8974E+00_JPRB,6.4380E+00_JPRB,7.8243E+00_JPRB/)
KBO( :, 3,24,11) = (/&
&9.5134E-01_JPRB,3.1164E+00_JPRB,5.0504E+00_JPRB,6.5817E+00_JPRB,7.7816E+00_JPRB/)
KBO( :, 4,24,11) = (/&
&1.2196E+00_JPRB,3.2537E+00_JPRB,5.1885E+00_JPRB,6.6940E+00_JPRB,7.7249E+00_JPRB/)
KBO( :, 5,24,11) = (/&
&1.5265E+00_JPRB,3.3851E+00_JPRB,5.3089E+00_JPRB,6.7822E+00_JPRB,7.6563E+00_JPRB/)
KBO( :, 1,25,11) = (/&
&4.8476E-01_JPRB,2.8697E+00_JPRB,4.8218E+00_JPRB,6.4097E+00_JPRB,7.9026E+00_JPRB/)
KBO( :, 2,25,11) = (/&
&6.5969E-01_JPRB,3.0274E+00_JPRB,5.0029E+00_JPRB,6.5890E+00_JPRB,7.8973E+00_JPRB/)
KBO( :, 3,25,11) = (/&
&8.6906E-01_JPRB,3.1754E+00_JPRB,5.1656E+00_JPRB,6.7410E+00_JPRB,7.8772E+00_JPRB/)
KBO( :, 4,25,11) = (/&
&1.1152E+00_JPRB,3.3120E+00_JPRB,5.3111E+00_JPRB,6.8679E+00_JPRB,7.8462E+00_JPRB/)
KBO( :, 5,25,11) = (/&
&1.4024E+00_JPRB,3.4449E+00_JPRB,5.4363E+00_JPRB,6.9674E+00_JPRB,7.7978E+00_JPRB/)
KBO( :, 1,26,11) = (/&
&4.4920E-01_JPRB,2.9004E+00_JPRB,4.8834E+00_JPRB,6.5041E+00_JPRB,7.9089E+00_JPRB/)
KBO( :, 2,26,11) = (/&
&6.0999E-01_JPRB,3.0628E+00_JPRB,5.0713E+00_JPRB,6.6966E+00_JPRB,7.9304E+00_JPRB/)
KBO( :, 3,26,11) = (/&
&8.0376E-01_JPRB,3.2124E+00_JPRB,5.2452E+00_JPRB,6.8629E+00_JPRB,7.9361E+00_JPRB/)
KBO( :, 4,26,11) = (/&
&1.0358E+00_JPRB,3.3523E+00_JPRB,5.4003E+00_JPRB,7.0027E+00_JPRB,7.9285E+00_JPRB/)
KBO( :, 5,26,11) = (/&
&1.3073E+00_JPRB,3.4838E+00_JPRB,5.5299E+00_JPRB,7.1136E+00_JPRB,7.9075E+00_JPRB/)
KBO( :, 1,27,11) = (/&
&4.1952E-01_JPRB,2.9133E+00_JPRB,4.9160E+00_JPRB,6.5693E+00_JPRB,7.8901E+00_JPRB/)
KBO( :, 2,27,11) = (/&
&5.6911E-01_JPRB,3.0774E+00_JPRB,5.1132E+00_JPRB,6.7755E+00_JPRB,7.9378E+00_JPRB/)
KBO( :, 3,27,11) = (/&
&7.5273E-01_JPRB,3.2297E+00_JPRB,5.2948E+00_JPRB,6.9532E+00_JPRB,7.9707E+00_JPRB/)
KBO( :, 4,27,11) = (/&
&9.7351E-01_JPRB,3.3745E+00_JPRB,5.4563E+00_JPRB,7.1054E+00_JPRB,7.9865E+00_JPRB/)
KBO( :, 5,27,11) = (/&
&1.2293E+00_JPRB,3.5064E+00_JPRB,5.5938E+00_JPRB,7.2297E+00_JPRB,7.9857E+00_JPRB/)
KBO( :, 1,28,11) = (/&
&3.9524E-01_JPRB,2.9112E+00_JPRB,4.9316E+00_JPRB,6.6151E+00_JPRB,7.8478E+00_JPRB/)
KBO( :, 2,28,11) = (/&
&5.3765E-01_JPRB,3.0764E+00_JPRB,5.1350E+00_JPRB,6.8313E+00_JPRB,7.9309E+00_JPRB/)
KBO( :, 3,28,11) = (/&
&7.1264E-01_JPRB,3.2343E+00_JPRB,5.3248E+00_JPRB,7.0207E+00_JPRB,7.9898E+00_JPRB/)
KBO( :, 4,28,11) = (/&
&9.1903E-01_JPRB,3.3816E+00_JPRB,5.4915E+00_JPRB,7.1844E+00_JPRB,8.0261E+00_JPRB/)
KBO( :, 5,28,11) = (/&
&1.1585E+00_JPRB,3.5178E+00_JPRB,5.6384E+00_JPRB,7.3251E+00_JPRB,8.0453E+00_JPRB/)
KBO( :, 1,29,11) = (/&
&3.7850E-01_JPRB,2.9006E+00_JPRB,4.9391E+00_JPRB,6.6424E+00_JPRB,7.8025E+00_JPRB/)
KBO( :, 2,29,11) = (/&
&5.1450E-01_JPRB,3.0673E+00_JPRB,5.1512E+00_JPRB,6.8720E+00_JPRB,7.9130E+00_JPRB/)
KBO( :, 3,29,11) = (/&
&6.7825E-01_JPRB,3.2303E+00_JPRB,5.3447E+00_JPRB,7.0744E+00_JPRB,7.9988E+00_JPRB/)
KBO( :, 4,29,11) = (/&
&8.7094E-01_JPRB,3.3797E+00_JPRB,5.5169E+00_JPRB,7.2525E+00_JPRB,8.0603E+00_JPRB/)
KBO( :, 5,29,11) = (/&
&1.0951E+00_JPRB,3.5266E+00_JPRB,5.6745E+00_JPRB,7.3989E+00_JPRB,8.0964E+00_JPRB/)
KBO( :, 1,30,11) = (/&
&3.6524E-01_JPRB,2.8876E+00_JPRB,4.9408E+00_JPRB,6.6613E+00_JPRB,7.7569E+00_JPRB/)
KBO( :, 2,30,11) = (/&
&4.9379E-01_JPRB,3.0581E+00_JPRB,5.1612E+00_JPRB,6.9058E+00_JPRB,7.8990E+00_JPRB/)
KBO( :, 3,30,11) = (/&
&6.4720E-01_JPRB,3.2216E+00_JPRB,5.3594E+00_JPRB,7.1246E+00_JPRB,8.0078E+00_JPRB/)
KBO( :, 4,30,11) = (/&
&8.2776E-01_JPRB,3.3773E+00_JPRB,5.5423E+00_JPRB,7.3074E+00_JPRB,8.0873E+00_JPRB/)
KBO( :, 5,30,11) = (/&
&1.0381E+00_JPRB,3.5327E+00_JPRB,5.7037E+00_JPRB,7.4625E+00_JPRB,8.1388E+00_JPRB/)
KBO( :, 1,31,11) = (/&
&3.5308E-01_JPRB,2.8782E+00_JPRB,4.9477E+00_JPRB,6.6803E+00_JPRB,7.7265E+00_JPRB/)
KBO( :, 2,31,11) = (/&
&4.7488E-01_JPRB,3.0504E+00_JPRB,5.1727E+00_JPRB,6.9441E+00_JPRB,7.8903E+00_JPRB/)
KBO( :, 3,31,11) = (/&
&6.2002E-01_JPRB,3.2131E+00_JPRB,5.3800E+00_JPRB,7.1680E+00_JPRB,8.0238E+00_JPRB/)
KBO( :, 4,31,11) = (/&
&7.9132E-01_JPRB,3.3767E+00_JPRB,5.5675E+00_JPRB,7.3599E+00_JPRB,8.1232E+00_JPRB/)
KBO( :, 5,31,11) = (/&
&9.9103E-01_JPRB,3.5400E+00_JPRB,5.7311E+00_JPRB,7.5249E+00_JPRB,8.1871E+00_JPRB/)
KBO( :, 1,32,11) = (/&
&3.4150E-01_JPRB,2.8720E+00_JPRB,4.9582E+00_JPRB,6.7133E+00_JPRB,7.7054E+00_JPRB/)
KBO( :, 2,32,11) = (/&
&4.5747E-01_JPRB,3.0437E+00_JPRB,5.1930E+00_JPRB,6.9826E+00_JPRB,7.9024E+00_JPRB/)
KBO( :, 3,32,11) = (/&
&5.9670E-01_JPRB,3.2099E+00_JPRB,5.4027E+00_JPRB,7.2169E+00_JPRB,8.0545E+00_JPRB/)
KBO( :, 4,32,11) = (/&
&7.6078E-01_JPRB,3.3797E+00_JPRB,5.5915E+00_JPRB,7.4162E+00_JPRB,8.1621E+00_JPRB/)
KBO( :, 5,32,11) = (/&
&9.5335E-01_JPRB,3.5468E+00_JPRB,5.7567E+00_JPRB,7.5820E+00_JPRB,8.2482E+00_JPRB/)
KBO( :, 1,33,11) = (/&
&3.3112E-01_JPRB,2.8707E+00_JPRB,4.9789E+00_JPRB,6.7544E+00_JPRB,7.7163E+00_JPRB/)
KBO( :, 2,33,11) = (/&
&4.4241E-01_JPRB,3.0429E+00_JPRB,5.2166E+00_JPRB,7.0302E+00_JPRB,7.9310E+00_JPRB/)
KBO( :, 3,33,11) = (/&
&5.7622E-01_JPRB,3.2140E+00_JPRB,5.4288E+00_JPRB,7.2705E+00_JPRB,8.0890E+00_JPRB/)
KBO( :, 4,33,11) = (/&
&7.3587E-01_JPRB,3.3885E+00_JPRB,5.6201E+00_JPRB,7.4720E+00_JPRB,8.2154E+00_JPRB/)
KBO( :, 5,33,11) = (/&
&9.2410E-01_JPRB,3.5572E+00_JPRB,5.7855E+00_JPRB,7.6373E+00_JPRB,8.3240E+00_JPRB/)
KBO( :, 1,34,11) = (/&
&3.1870E-01_JPRB,2.8673E+00_JPRB,5.0003E+00_JPRB,6.7932E+00_JPRB,7.7350E+00_JPRB/)
KBO( :, 2,34,11) = (/&
&4.2545E-01_JPRB,3.0410E+00_JPRB,5.2383E+00_JPRB,7.0757E+00_JPRB,7.9562E+00_JPRB/)
KBO( :, 3,34,11) = (/&
&5.5478E-01_JPRB,3.2165E+00_JPRB,5.4526E+00_JPRB,7.3185E+00_JPRB,8.1289E+00_JPRB/)
KBO( :, 4,34,11) = (/&
&7.0990E-01_JPRB,3.3947E+00_JPRB,5.6453E+00_JPRB,7.5211E+00_JPRB,8.2807E+00_JPRB/)
KBO( :, 5,34,11) = (/&
&8.9548E-01_JPRB,3.5658E+00_JPRB,5.8091E+00_JPRB,7.6845E+00_JPRB,8.3957E+00_JPRB/)
KBO( :, 1,35,11) = (/&
&2.9899E-01_JPRB,2.8528E+00_JPRB,5.0022E+00_JPRB,6.8098E+00_JPRB,7.7352E+00_JPRB/)
KBO( :, 2,35,11) = (/&
&4.0035E-01_JPRB,3.0296E+00_JPRB,5.2435E+00_JPRB,7.1001E+00_JPRB,7.9730E+00_JPRB/)
KBO( :, 3,35,11) = (/&
&5.2425E-01_JPRB,3.2088E+00_JPRB,5.4619E+00_JPRB,7.3466E+00_JPRB,8.1718E+00_JPRB/)
KBO( :, 4,35,11) = (/&
&6.7403E-01_JPRB,3.3885E+00_JPRB,5.6558E+00_JPRB,7.5526E+00_JPRB,8.3426E+00_JPRB/)
KBO( :, 5,35,11) = (/&
&8.5588E-01_JPRB,3.5636E+00_JPRB,5.8215E+00_JPRB,7.7184E+00_JPRB,8.4695E+00_JPRB/)
KBO( :, 1,36,11) = (/&
&2.7267E-01_JPRB,2.8247E+00_JPRB,4.9811E+00_JPRB,6.7967E+00_JPRB,7.7171E+00_JPRB/)
KBO( :, 2,36,11) = (/&
&3.6730E-01_JPRB,3.0036E+00_JPRB,5.2282E+00_JPRB,7.0962E+00_JPRB,7.9794E+00_JPRB/)
KBO( :, 3,36,11) = (/&
&4.8410E-01_JPRB,3.1863E+00_JPRB,5.4514E+00_JPRB,7.3517E+00_JPRB,8.2066E+00_JPRB/)
KBO( :, 4,36,11) = (/&
&6.2745E-01_JPRB,3.3693E+00_JPRB,5.6486E+00_JPRB,7.5634E+00_JPRB,8.3923E+00_JPRB/)
KBO( :, 5,36,11) = (/&
&8.0265E-01_JPRB,3.5462E+00_JPRB,5.8174E+00_JPRB,7.7338E+00_JPRB,8.5363E+00_JPRB/)
KBO( :, 1,37,11) = (/&
&2.3789E-01_JPRB,2.7731E+00_JPRB,4.9241E+00_JPRB,6.7346E+00_JPRB,7.6594E+00_JPRB/)
KBO( :, 2,37,11) = (/&
&3.2371E-01_JPRB,2.9546E+00_JPRB,5.1797E+00_JPRB,7.0518E+00_JPRB,7.9502E+00_JPRB/)
KBO( :, 3,37,11) = (/&
&4.3093E-01_JPRB,3.1396E+00_JPRB,5.4103E+00_JPRB,7.3206E+00_JPRB,8.2067E+00_JPRB/)
KBO( :, 4,37,11) = (/&
&5.6432E-01_JPRB,3.3261E+00_JPRB,5.6154E+00_JPRB,7.5430E+00_JPRB,8.4107E+00_JPRB/)
KBO( :, 5,37,11) = (/&
&7.2921E-01_JPRB,3.5055E+00_JPRB,5.7906E+00_JPRB,7.7231E+00_JPRB,8.5767E+00_JPRB/)
KBO( :, 1,38,11) = (/&
&2.0735E-01_JPRB,2.7246E+00_JPRB,4.8643E+00_JPRB,6.6686E+00_JPRB,7.6002E+00_JPRB/)
KBO( :, 2,38,11) = (/&
&2.8530E-01_JPRB,2.9075E+00_JPRB,5.1303E+00_JPRB,7.0023E+00_JPRB,7.9233E+00_JPRB/)
KBO( :, 3,38,11) = (/&
&3.8349E-01_JPRB,3.0952E+00_JPRB,5.3688E+00_JPRB,7.2838E+00_JPRB,8.2079E+00_JPRB/)
KBO( :, 4,38,11) = (/&
&5.0781E-01_JPRB,3.2834E+00_JPRB,5.5805E+00_JPRB,7.5172E+00_JPRB,8.4321E+00_JPRB/)
KBO( :, 5,38,11) = (/&
&6.6307E-01_JPRB,3.4663E+00_JPRB,5.7630E+00_JPRB,7.7072E+00_JPRB,8.6191E+00_JPRB/)
KBO( :, 1,39,11) = (/&
&1.8082E-01_JPRB,2.6797E+00_JPRB,4.8064E+00_JPRB,6.6001E+00_JPRB,7.5476E+00_JPRB/)
KBO( :, 2,39,11) = (/&
&2.5186E-01_JPRB,2.8651E+00_JPRB,5.0819E+00_JPRB,6.9495E+00_JPRB,7.9070E+00_JPRB/)
KBO( :, 3,39,11) = (/&
&3.4240E-01_JPRB,3.0532E+00_JPRB,5.3282E+00_JPRB,7.2446E+00_JPRB,8.2139E+00_JPRB/)
KBO( :, 4,39,11) = (/&
&4.5842E-01_JPRB,3.2439E+00_JPRB,5.5467E+00_JPRB,7.4896E+00_JPRB,8.4602E+00_JPRB/)
KBO( :, 5,39,11) = (/&
&6.0509E-01_JPRB,3.4298E+00_JPRB,5.7341E+00_JPRB,7.6881E+00_JPRB,8.6682E+00_JPRB/)
KBO( :, 1,40,11) = (/&
&1.5207E-01_JPRB,2.6179E+00_JPRB,4.7176E+00_JPRB,6.4886E+00_JPRB,7.4449E+00_JPRB/)
KBO( :, 2,40,11) = (/&
&2.1512E-01_JPRB,2.8059E+00_JPRB,5.0086E+00_JPRB,6.8609E+00_JPRB,7.8328E+00_JPRB/)
KBO( :, 3,40,11) = (/&
&2.9689E-01_JPRB,2.9943E+00_JPRB,5.2638E+00_JPRB,7.1743E+00_JPRB,8.1664E+00_JPRB/)
KBO( :, 4,40,11) = (/&
&4.0254E-01_JPRB,3.1876E+00_JPRB,5.4913E+00_JPRB,7.4357E+00_JPRB,8.4349E+00_JPRB/)
KBO( :, 5,40,11) = (/&
&5.3785E-01_JPRB,3.3763E+00_JPRB,5.6880E+00_JPRB,7.6474E+00_JPRB,8.6627E+00_JPRB/)
KBO( :, 1,41,11) = (/&
&1.2695E-01_JPRB,2.5542E+00_JPRB,4.6228E+00_JPRB,6.3672E+00_JPRB,7.3294E+00_JPRB/)
KBO( :, 2,41,11) = (/&
&1.8252E-01_JPRB,2.7470E+00_JPRB,4.9288E+00_JPRB,6.7628E+00_JPRB,7.7447E+00_JPRB/)
KBO( :, 3,41,11) = (/&
&2.5614E-01_JPRB,2.9363E+00_JPRB,5.1938E+00_JPRB,7.0965E+00_JPRB,8.1064E+00_JPRB/)
KBO( :, 4,41,11) = (/&
&3.5214E-01_JPRB,3.1287E+00_JPRB,5.4316E+00_JPRB,7.3741E+00_JPRB,8.3985E+00_JPRB/)
KBO( :, 5,41,11) = (/&
&4.7642E-01_JPRB,3.3197E+00_JPRB,5.6390E+00_JPRB,7.5995E+00_JPRB,8.6452E+00_JPRB/)
KBO( :, 1,42,11) = (/&
&1.0572E-01_JPRB,2.4914E+00_JPRB,4.5264E+00_JPRB,6.2425E+00_JPRB,7.2103E+00_JPRB/)
KBO( :, 2,42,11) = (/&
&1.5450E-01_JPRB,2.6890E+00_JPRB,4.8460E+00_JPRB,6.6593E+00_JPRB,7.6506E+00_JPRB/)
KBO( :, 3,42,11) = (/&
&2.2046E-01_JPRB,2.8775E+00_JPRB,5.1228E+00_JPRB,7.0129E+00_JPRB,8.0405E+00_JPRB/)
KBO( :, 4,42,11) = (/&
&3.0794E-01_JPRB,3.0704E+00_JPRB,5.3705E+00_JPRB,7.3070E+00_JPRB,8.3576E+00_JPRB/)
KBO( :, 5,42,11) = (/&
&4.2243E-01_JPRB,3.2655E+00_JPRB,5.5859E+00_JPRB,7.5484E+00_JPRB,8.6234E+00_JPRB/)
KBO( :, 1,43,11) = (/&
&8.5799E-02_JPRB,2.4158E+00_JPRB,4.4064E+00_JPRB,6.0854E+00_JPRB,7.0535E+00_JPRB/)
KBO( :, 2,43,11) = (/&
&1.2776E-01_JPRB,2.6198E+00_JPRB,4.7439E+00_JPRB,6.5289E+00_JPRB,7.5260E+00_JPRB/)
KBO( :, 3,43,11) = (/&
&1.8555E-01_JPRB,2.8110E+00_JPRB,5.0358E+00_JPRB,6.9052E+00_JPRB,7.9459E+00_JPRB/)
KBO( :, 4,43,11) = (/&
&2.6399E-01_JPRB,3.0044E+00_JPRB,5.2930E+00_JPRB,7.2200E+00_JPRB,8.2902E+00_JPRB/)
KBO( :, 5,43,11) = (/&
&3.6761E-01_JPRB,3.2003E+00_JPRB,5.5191E+00_JPRB,7.4799E+00_JPRB,8.5786E+00_JPRB/)
KBO( :, 1,44,11) = (/&
&6.8535E-02_JPRB,2.3354E+00_JPRB,4.2721E+00_JPRB,5.9087E+00_JPRB,6.8762E+00_JPRB/)
KBO( :, 2,44,11) = (/&
&1.0421E-01_JPRB,2.5468E+00_JPRB,4.6283E+00_JPRB,6.3792E+00_JPRB,7.3815E+00_JPRB/)
KBO( :, 3,44,11) = (/&
&1.5420E-01_JPRB,2.7418E+00_JPRB,4.9358E+00_JPRB,6.7810E+00_JPRB,7.8336E+00_JPRB/)
KBO( :, 4,44,11) = (/&
&2.2347E-01_JPRB,2.9335E+00_JPRB,5.2044E+00_JPRB,7.1195E+00_JPRB,8.2083E+00_JPRB/)
KBO( :, 5,44,11) = (/&
&3.1682E-01_JPRB,3.1294E+00_JPRB,5.4461E+00_JPRB,7.3981E+00_JPRB,8.5217E+00_JPRB/)
KBO( :, 1,45,11) = (/&
&5.4457E-02_JPRB,2.2535E+00_JPRB,4.1320E+00_JPRB,5.7238E+00_JPRB,6.6894E+00_JPRB/)
KBO( :, 2,45,11) = (/&
&8.4549E-02_JPRB,2.4711E+00_JPRB,4.5065E+00_JPRB,6.2198E+00_JPRB,7.2293E+00_JPRB/)
KBO( :, 3,45,11) = (/&
&1.2761E-01_JPRB,2.6717E+00_JPRB,4.8324E+00_JPRB,6.6492E+00_JPRB,7.7146E+00_JPRB/)
KBO( :, 4,45,11) = (/&
&1.8837E-01_JPRB,2.8633E+00_JPRB,5.1155E+00_JPRB,7.0100E+00_JPRB,8.1205E+00_JPRB/)
KBO( :, 5,45,11) = (/&
&2.7227E-01_JPRB,3.0592E+00_JPRB,5.3653E+00_JPRB,7.3089E+00_JPRB,8.4600E+00_JPRB/)
KBO( :, 1,46,11) = (/&
&4.2589E-02_JPRB,2.1649E+00_JPRB,3.9784E+00_JPRB,5.5163E+00_JPRB,6.4796E+00_JPRB/)
KBO( :, 2,46,11) = (/&
&6.7560E-02_JPRB,2.3893E+00_JPRB,4.3722E+00_JPRB,6.0430E+00_JPRB,7.0551E+00_JPRB/)
KBO( :, 3,46,11) = (/&
&1.0417E-01_JPRB,2.5968E+00_JPRB,4.7173E+00_JPRB,6.4988E+00_JPRB,7.5749E+00_JPRB/)
KBO( :, 4,46,11) = (/&
&1.5686E-01_JPRB,2.7912E+00_JPRB,5.0150E+00_JPRB,6.8844E+00_JPRB,8.0167E+00_JPRB/)
KBO( :, 5,46,11) = (/&
&2.3102E-01_JPRB,2.9860E+00_JPRB,5.2763E+00_JPRB,7.2084E+00_JPRB,8.3844E+00_JPRB/)
KBO( :, 1,47,11) = (/&
&3.2329E-02_JPRB,2.0635E+00_JPRB,3.7990E+00_JPRB,5.2746E+00_JPRB,6.2270E+00_JPRB/)
KBO( :, 2,47,11) = (/&
&5.2621E-02_JPRB,2.2974E+00_JPRB,4.2140E+00_JPRB,5.8338E+00_JPRB,6.8413E+00_JPRB/)
KBO( :, 3,47,11) = (/&
&8.2966E-02_JPRB,2.5124E+00_JPRB,4.5790E+00_JPRB,6.3183E+00_JPRB,7.3957E+00_JPRB/)
KBO( :, 4,47,11) = (/&
&1.2765E-01_JPRB,2.7111E+00_JPRB,4.8962E+00_JPRB,6.7355E+00_JPRB,7.8773E+00_JPRB/)
KBO( :, 5,47,11) = (/&
&1.9183E-01_JPRB,2.9039E+00_JPRB,5.1733E+00_JPRB,7.0849E+00_JPRB,8.2769E+00_JPRB/)
KBO( :, 1,48,11) = (/&
&2.4260E-02_JPRB,1.9590E+00_JPRB,3.6114E+00_JPRB,5.0219E+00_JPRB,5.9614E+00_JPRB/)
KBO( :, 2,48,11) = (/&
&4.0661E-02_JPRB,2.2016E+00_JPRB,4.0471E+00_JPRB,5.6109E+00_JPRB,6.6162E+00_JPRB/)
KBO( :, 3,48,11) = (/&
&6.5567E-02_JPRB,2.4242E+00_JPRB,4.4350E+00_JPRB,6.1272E+00_JPRB,7.2066E+00_JPRB/)
KBO( :, 4,48,11) = (/&
&1.0316E-01_JPRB,2.6297E+00_JPRB,4.7726E+00_JPRB,6.5740E+00_JPRB,7.7277E+00_JPRB/)
KBO( :, 5,48,11) = (/&
&1.5827E-01_JPRB,2.8235E+00_JPRB,5.0650E+00_JPRB,6.9498E+00_JPRB,8.1636E+00_JPRB/)
KBO( :, 1,49,11) = (/&
&1.7994E-02_JPRB,1.8499E+00_JPRB,3.4182E+00_JPRB,4.7557E+00_JPRB,5.6860E+00_JPRB/)
KBO( :, 2,49,11) = (/&
&3.1088E-02_JPRB,2.1039E+00_JPRB,3.8735E+00_JPRB,5.3754E+00_JPRB,6.3833E+00_JPRB/)
KBO( :, 3,49,11) = (/&
&5.1455E-02_JPRB,2.3348E+00_JPRB,4.2824E+00_JPRB,5.9252E+00_JPRB,7.0121E+00_JPRB/)
KBO( :, 4,49,11) = (/&
&8.2689E-02_JPRB,2.5471E+00_JPRB,4.6395E+00_JPRB,6.4001E+00_JPRB,7.5720E+00_JPRB/)
KBO( :, 5,49,11) = (/&
&1.2977E-01_JPRB,2.7449E+00_JPRB,4.9494E+00_JPRB,6.8054E+00_JPRB,8.0481E+00_JPRB/)
KBO( :, 1,50,11) = (/&
&1.3371E-02_JPRB,1.7459E+00_JPRB,3.2314E+00_JPRB,4.4954E+00_JPRB,5.4078E+00_JPRB/)
KBO( :, 2,50,11) = (/&
&2.3833E-02_JPRB,2.0084E+00_JPRB,3.7026E+00_JPRB,5.1456E+00_JPRB,6.1414E+00_JPRB/)
KBO( :, 3,50,11) = (/&
&4.0559E-02_JPRB,2.2474E+00_JPRB,4.1296E+00_JPRB,5.7236E+00_JPRB,6.8056E+00_JPRB/)
KBO( :, 4,50,11) = (/&
&6.6648E-02_JPRB,2.4671E+00_JPRB,4.5076E+00_JPRB,6.2258E+00_JPRB,7.4018E+00_JPRB/)
KBO( :, 5,50,11) = (/&
&1.0683E-01_JPRB,2.6694E+00_JPRB,4.8363E+00_JPRB,6.6602E+00_JPRB,7.9136E+00_JPRB/)
KBO( :, 1,51,11) = (/&
&9.8653E-03_JPRB,1.6429E+00_JPRB,3.0451E+00_JPRB,4.2358E+00_JPRB,5.1231E+00_JPRB/)
KBO( :, 2,51,11) = (/&
&1.8201E-02_JPRB,1.9124E+00_JPRB,3.5299E+00_JPRB,4.9113E+00_JPRB,5.8903E+00_JPRB/)
KBO( :, 3,51,11) = (/&
&3.1898E-02_JPRB,2.1605E+00_JPRB,3.9764E+00_JPRB,5.5162E+00_JPRB,6.5869E+00_JPRB/)
KBO( :, 4,51,11) = (/&
&5.3712E-02_JPRB,2.3869E+00_JPRB,4.3743E+00_JPRB,6.0489E+00_JPRB,7.2173E+00_JPRB/)
KBO( :, 5,51,11) = (/&
&8.7772E-02_JPRB,2.5955E+00_JPRB,4.7209E+00_JPRB,6.5087E+00_JPRB,7.7625E+00_JPRB/)
KBO( :, 1,52,11) = (/&
&7.1653E-03_JPRB,1.5381E+00_JPRB,2.8544E+00_JPRB,3.9674E+00_JPRB,4.8308E+00_JPRB/)
KBO( :, 2,52,11) = (/&
&1.3765E-02_JPRB,1.8137E+00_JPRB,3.3544E+00_JPRB,4.6675E+00_JPRB,5.6327E+00_JPRB/)
KBO( :, 3,52,11) = (/&
&2.4855E-02_JPRB,2.0712E+00_JPRB,3.8173E+00_JPRB,5.3003E+00_JPRB,6.3625E+00_JPRB/)
KBO( :, 4,52,11) = (/&
&4.3007E-02_JPRB,2.3053E+00_JPRB,4.2329E+00_JPRB,5.8617E+00_JPRB,7.0261E+00_JPRB/)
KBO( :, 5,52,11) = (/&
&7.1746E-02_JPRB,2.5209E+00_JPRB,4.5976E+00_JPRB,6.3464E+00_JPRB,7.6074E+00_JPRB/)
KBO( :, 1,53,11) = (/&
&5.1115E-03_JPRB,1.4319E+00_JPRB,2.6598E+00_JPRB,3.6923E+00_JPRB,4.5327E+00_JPRB/)
KBO( :, 2,53,11) = (/&
&1.0264E-02_JPRB,1.7132E+00_JPRB,3.1732E+00_JPRB,4.4138E+00_JPRB,5.3644E+00_JPRB/)
KBO( :, 3,53,11) = (/&
&1.9168E-02_JPRB,1.9787E+00_JPRB,3.6497E+00_JPRB,5.0750E+00_JPRB,6.1311E+00_JPRB/)
KBO( :, 4,53,11) = (/&
&3.4142E-02_JPRB,2.2206E+00_JPRB,4.0841E+00_JPRB,5.6629E+00_JPRB,6.8305E+00_JPRB/)
KBO( :, 5,53,11) = (/&
&5.8320E-02_JPRB,2.4429E+00_JPRB,4.4694E+00_JPRB,6.1755E+00_JPRB,7.4521E+00_JPRB/)
KBO( :, 1,54,11) = (/&
&3.6599E-03_JPRB,1.3331E+00_JPRB,2.4769E+00_JPRB,3.4372E+00_JPRB,4.2368E+00_JPRB/)
KBO( :, 2,54,11) = (/&
&7.6954E-03_JPRB,1.6189E+00_JPRB,3.0020E+00_JPRB,4.1755E+00_JPRB,5.0910E+00_JPRB/)
KBO( :, 3,54,11) = (/&
&1.4927E-02_JPRB,1.8903E+00_JPRB,3.4914E+00_JPRB,4.8585E+00_JPRB,5.8811E+00_JPRB/)
KBO( :, 4,54,11) = (/&
&2.7354E-02_JPRB,2.1411E+00_JPRB,3.9432E+00_JPRB,5.4718E+00_JPRB,6.6071E+00_JPRB/)
KBO( :, 5,54,11) = (/&
&4.7880E-02_JPRB,2.3694E+00_JPRB,4.3455E+00_JPRB,6.0119E+00_JPRB,7.2530E+00_JPRB/)
KBO( :, 1,55,11) = (/&
&2.6041E-03_JPRB,1.2377E+00_JPRB,2.2999E+00_JPRB,3.1900E+00_JPRB,3.9377E+00_JPRB/)
KBO( :, 2,55,11) = (/&
&5.7429E-03_JPRB,1.5271E+00_JPRB,2.8349E+00_JPRB,3.9397E+00_JPRB,4.8084E+00_JPRB/)
KBO( :, 3,55,11) = (/&
&1.1607E-02_JPRB,1.8036E+00_JPRB,3.3372E+00_JPRB,4.6433E+00_JPRB,5.6183E+00_JPRB/)
KBO( :, 4,55,11) = (/&
&2.1919E-02_JPRB,2.0624E+00_JPRB,3.8024E+00_JPRB,5.2808E+00_JPRB,6.3606E+00_JPRB/)
KBO( :, 5,55,11) = (/&
&3.9357E-02_JPRB,2.2976E+00_JPRB,4.2205E+00_JPRB,5.8462E+00_JPRB,7.0320E+00_JPRB/)
KBO( :, 1,56,11) = (/&
&1.8212E-03_JPRB,1.1423E+00_JPRB,2.1234E+00_JPRB,2.9415E+00_JPRB,3.6402E+00_JPRB/)
KBO( :, 2,56,11) = (/&
&4.2220E-03_JPRB,1.4344E+00_JPRB,2.6648E+00_JPRB,3.6993E+00_JPRB,4.5216E+00_JPRB/)
KBO( :, 3,56,11) = (/&
&8.9199E-03_JPRB,1.7161E+00_JPRB,3.1791E+00_JPRB,4.4224E+00_JPRB,5.3514E+00_JPRB/)
KBO( :, 4,56,11) = (/&
&1.7443E-02_JPRB,1.9818E+00_JPRB,3.6561E+00_JPRB,5.0841E+00_JPRB,6.1109E+00_JPRB/)
KBO( :, 5,56,11) = (/&
&3.2146E-02_JPRB,2.2236E+00_JPRB,4.0904E+00_JPRB,5.6718E+00_JPRB,6.8038E+00_JPRB/)
KBO( :, 1,57,11) = (/&
&1.2487E-03_JPRB,1.0475E+00_JPRB,1.9452E+00_JPRB,2.6920E+00_JPRB,3.3454E+00_JPRB/)
KBO( :, 2,57,11) = (/&
&3.0556E-03_JPRB,1.3407E+00_JPRB,2.4912E+00_JPRB,3.4567E+00_JPRB,4.2318E+00_JPRB/)
KBO( :, 3,57,11) = (/&
&6.7633E-03_JPRB,1.6266E+00_JPRB,3.0165E+00_JPRB,4.1956E+00_JPRB,5.0790E+00_JPRB/)
KBO( :, 4,57,11) = (/&
&1.3762E-02_JPRB,1.8981E+00_JPRB,3.5056E+00_JPRB,4.8781E+00_JPRB,5.8578E+00_JPRB/)
KBO( :, 5,57,11) = (/&
&2.6062E-02_JPRB,2.1481E+00_JPRB,3.9566E+00_JPRB,5.4903E+00_JPRB,6.5663E+00_JPRB/)
KBO( :, 1,58,11) = (/&
&8.5190E-04_JPRB,9.5769E-01_JPRB,1.7770E+00_JPRB,2.4580E+00_JPRB,3.0673E+00_JPRB/)
KBO( :, 2,58,11) = (/&
&2.2048E-03_JPRB,1.2510E+00_JPRB,2.3247E+00_JPRB,3.2249E+00_JPRB,3.9528E+00_JPRB/)
KBO( :, 3,58,11) = (/&
&5.1227E-03_JPRB,1.5404E+00_JPRB,2.8593E+00_JPRB,3.9742E+00_JPRB,4.8120E+00_JPRB/)
KBO( :, 4,58,11) = (/&
&1.0857E-02_JPRB,1.8165E+00_JPRB,3.3607E+00_JPRB,4.6761E+00_JPRB,5.6102E+00_JPRB/)
KBO( :, 5,58,11) = (/&
&2.1207E-02_JPRB,2.0743E+00_JPRB,3.8247E+00_JPRB,5.3111E+00_JPRB,6.3315E+00_JPRB/)
KBO( :, 1,59,11) = (/&
&6.9156E-04_JPRB,9.2148E-01_JPRB,1.7091E+00_JPRB,2.3639E+00_JPRB,2.9470E+00_JPRB/)
KBO( :, 2,59,11) = (/&
&1.8554E-03_JPRB,1.2146E+00_JPRB,2.2573E+00_JPRB,3.1301E+00_JPRB,3.8229E+00_JPRB/)
KBO( :, 3,59,11) = (/&
&4.4546E-03_JPRB,1.5052E+00_JPRB,2.7951E+00_JPRB,3.8834E+00_JPRB,4.6728E+00_JPRB/)
KBO( :, 4,59,11) = (/&
&9.7022E-03_JPRB,1.7833E+00_JPRB,3.3009E+00_JPRB,4.5928E+00_JPRB,5.4696E+00_JPRB/)
KBO( :, 5,59,11) = (/&
&1.9310E-02_JPRB,2.0440E+00_JPRB,3.7699E+00_JPRB,5.2372E+00_JPRB,6.1828E+00_JPRB/)
KBO( :, 1,13,12) = (/&
&1.6565E+00_JPRB,1.7848E+00_JPRB,2.5700E+00_JPRB,3.5717E+00_JPRB,4.5988E+00_JPRB/)
KBO( :, 2,13,12) = (/&
&2.4215E+00_JPRB,2.1271E+00_JPRB,2.6999E+00_JPRB,3.5485E+00_JPRB,4.4641E+00_JPRB/)
KBO( :, 3,13,12) = (/&
&3.3369E+00_JPRB,2.6815E+00_JPRB,2.9576E+00_JPRB,3.5009E+00_JPRB,4.3216E+00_JPRB/)
KBO( :, 4,13,12) = (/&
&4.4039E+00_JPRB,3.4401E+00_JPRB,3.2679E+00_JPRB,3.4869E+00_JPRB,4.1798E+00_JPRB/)
KBO( :, 5,13,12) = (/&
&5.5941E+00_JPRB,4.3251E+00_JPRB,3.6079E+00_JPRB,3.5523E+00_JPRB,4.0718E+00_JPRB/)
KBO( :, 1,14,12) = (/&
&1.7762E+00_JPRB,1.9421E+00_JPRB,2.7864E+00_JPRB,3.8795E+00_JPRB,4.9959E+00_JPRB/)
KBO( :, 2,14,12) = (/&
&2.5729E+00_JPRB,2.3289E+00_JPRB,2.9407E+00_JPRB,3.8344E+00_JPRB,4.8460E+00_JPRB/)
KBO( :, 3,14,12) = (/&
&3.5256E+00_JPRB,2.8532E+00_JPRB,3.1735E+00_JPRB,3.7815E+00_JPRB,4.6937E+00_JPRB/)
KBO( :, 4,14,12) = (/&
&4.6225E+00_JPRB,3.6062E+00_JPRB,3.4878E+00_JPRB,3.7727E+00_JPRB,4.5592E+00_JPRB/)
KBO( :, 5,14,12) = (/&
&5.8383E+00_JPRB,4.5040E+00_JPRB,3.8887E+00_JPRB,3.8650E+00_JPRB,4.4445E+00_JPRB/)
KBO( :, 1,15,12) = (/&
&1.8721E+00_JPRB,2.1191E+00_JPRB,3.0241E+00_JPRB,4.2075E+00_JPRB,5.4430E+00_JPRB/)
KBO( :, 2,15,12) = (/&
&2.6862E+00_JPRB,2.5250E+00_JPRB,3.1995E+00_JPRB,4.1499E+00_JPRB,5.2993E+00_JPRB/)
KBO( :, 3,15,12) = (/&
&3.6549E+00_JPRB,3.0295E+00_JPRB,3.4400E+00_JPRB,4.1044E+00_JPRB,5.1665E+00_JPRB/)
KBO( :, 4,15,12) = (/&
&4.7570E+00_JPRB,3.7259E+00_JPRB,3.7691E+00_JPRB,4.1180E+00_JPRB,5.0472E+00_JPRB/)
KBO( :, 5,15,12) = (/&
&5.9648E+00_JPRB,4.5949E+00_JPRB,4.1611E+00_JPRB,4.2079E+00_JPRB,4.9426E+00_JPRB/)
KBO( :, 1,16,12) = (/&
&1.9290E+00_JPRB,2.3038E+00_JPRB,3.3146E+00_JPRB,4.6435E+00_JPRB,6.0407E+00_JPRB/)
KBO( :, 2,16,12) = (/&
&2.7431E+00_JPRB,2.7084E+00_JPRB,3.4673E+00_JPRB,4.5698E+00_JPRB,5.8966E+00_JPRB/)
KBO( :, 3,16,12) = (/&
&3.6970E+00_JPRB,3.2040E+00_JPRB,3.7345E+00_JPRB,4.5214E+00_JPRB,5.7687E+00_JPRB/)
KBO( :, 4,16,12) = (/&
&4.7715E+00_JPRB,3.8272E+00_JPRB,4.0666E+00_JPRB,4.5545E+00_JPRB,5.6476E+00_JPRB/)
KBO( :, 5,16,12) = (/&
&5.9496E+00_JPRB,4.6127E+00_JPRB,4.4402E+00_JPRB,4.6207E+00_JPRB,5.5338E+00_JPRB/)
KBO( :, 1,17,12) = (/&
&1.9373E+00_JPRB,2.4828E+00_JPRB,3.6697E+00_JPRB,5.1796E+00_JPRB,6.7612E+00_JPRB/)
KBO( :, 2,17,12) = (/&
&2.7255E+00_JPRB,2.8755E+00_JPRB,3.8159E+00_JPRB,5.1042E+00_JPRB,6.6167E+00_JPRB/)
KBO( :, 3,17,12) = (/&
&3.6395E+00_JPRB,3.3552E+00_JPRB,4.0591E+00_JPRB,5.0640E+00_JPRB,6.4791E+00_JPRB/)
KBO( :, 4,17,12) = (/&
&4.6714E+00_JPRB,3.9092E+00_JPRB,4.3629E+00_JPRB,5.0919E+00_JPRB,6.3471E+00_JPRB/)
KBO( :, 5,17,12) = (/&
&5.8138E+00_JPRB,4.6040E+00_JPRB,4.7123E+00_JPRB,5.1320E+00_JPRB,6.2136E+00_JPRB/)
KBO( :, 1,18,12) = (/&
&1.8923E+00_JPRB,2.6601E+00_JPRB,4.0950E+00_JPRB,5.7689E+00_JPRB,7.5292E+00_JPRB/)
KBO( :, 2,18,12) = (/&
&2.6358E+00_JPRB,3.0291E+00_JPRB,4.2495E+00_JPRB,5.7045E+00_JPRB,7.3896E+00_JPRB/)
KBO( :, 3,18,12) = (/&
&3.5005E+00_JPRB,3.4699E+00_JPRB,4.4508E+00_JPRB,5.6824E+00_JPRB,7.2449E+00_JPRB/)
KBO( :, 4,18,12) = (/&
&4.4831E+00_JPRB,3.9859E+00_JPRB,4.6968E+00_JPRB,5.6976E+00_JPRB,7.0972E+00_JPRB/)
KBO( :, 5,18,12) = (/&
&5.5803E+00_JPRB,4.6005E+00_JPRB,4.9912E+00_JPRB,5.7191E+00_JPRB,6.9473E+00_JPRB/)
KBO( :, 1,19,12) = (/&
&1.8026E+00_JPRB,2.8675E+00_JPRB,4.5643E+00_JPRB,6.3966E+00_JPRB,8.3446E+00_JPRB/)
KBO( :, 2,19,12) = (/&
&2.4955E+00_JPRB,3.1750E+00_JPRB,4.7346E+00_JPRB,6.3280E+00_JPRB,8.1858E+00_JPRB/)
KBO( :, 3,19,12) = (/&
&3.3065E+00_JPRB,3.5656E+00_JPRB,4.9096E+00_JPRB,6.3278E+00_JPRB,8.0274E+00_JPRB/)
KBO( :, 4,19,12) = (/&
&4.2336E+00_JPRB,4.0373E+00_JPRB,5.1018E+00_JPRB,6.3400E+00_JPRB,7.8734E+00_JPRB/)
KBO( :, 5,19,12) = (/&
&5.2638E+00_JPRB,4.5965E+00_JPRB,5.3281E+00_JPRB,6.3749E+00_JPRB,7.7186E+00_JPRB/)
KBO( :, 1,20,12) = (/&
&1.6924E+00_JPRB,3.1159E+00_JPRB,5.0615E+00_JPRB,7.0193E+00_JPRB,9.1509E+00_JPRB/)
KBO( :, 2,20,12) = (/&
&2.3342E+00_JPRB,3.3609E+00_JPRB,5.2475E+00_JPRB,6.9651E+00_JPRB,8.9802E+00_JPRB/)
KBO( :, 3,20,12) = (/&
&3.0883E+00_JPRB,3.6808E+00_JPRB,5.4216E+00_JPRB,6.9801E+00_JPRB,8.8129E+00_JPRB/)
KBO( :, 4,20,12) = (/&
&3.9463E+00_JPRB,4.0848E+00_JPRB,5.5777E+00_JPRB,7.0012E+00_JPRB,8.6463E+00_JPRB/)
KBO( :, 5,20,12) = (/&
&4.8961E+00_JPRB,4.5736E+00_JPRB,5.7512E+00_JPRB,7.0663E+00_JPRB,8.4743E+00_JPRB/)
KBO( :, 1,21,12) = (/&
&1.5690E+00_JPRB,3.3918E+00_JPRB,5.5679E+00_JPRB,7.6325E+00_JPRB,9.9359E+00_JPRB/)
KBO( :, 2,21,12) = (/&
&2.1586E+00_JPRB,3.5959E+00_JPRB,5.7632E+00_JPRB,7.6131E+00_JPRB,9.7631E+00_JPRB/)
KBO( :, 3,21,12) = (/&
&2.8476E+00_JPRB,3.8439E+00_JPRB,5.9415E+00_JPRB,7.6317E+00_JPRB,9.5829E+00_JPRB/)
KBO( :, 4,21,12) = (/&
&3.6276E+00_JPRB,4.1634E+00_JPRB,6.0894E+00_JPRB,7.6838E+00_JPRB,9.4023E+00_JPRB/)
KBO( :, 5,21,12) = (/&
&4.4917E+00_JPRB,4.5642E+00_JPRB,6.2271E+00_JPRB,7.7630E+00_JPRB,9.2137E+00_JPRB/)
KBO( :, 1,22,12) = (/&
&1.4699E+00_JPRB,3.6838E+00_JPRB,6.0744E+00_JPRB,8.2202E+00_JPRB,1.0664E+01_JPRB/)
KBO( :, 2,22,12) = (/&
&2.0081E+00_JPRB,3.8770E+00_JPRB,6.2779E+00_JPRB,8.2401E+00_JPRB,1.0485E+01_JPRB/)
KBO( :, 3,22,12) = (/&
&2.6322E+00_JPRB,4.0768E+00_JPRB,6.4526E+00_JPRB,8.2804E+00_JPRB,1.0306E+01_JPRB/)
KBO( :, 4,22,12) = (/&
&3.3385E+00_JPRB,4.3174E+00_JPRB,6.6003E+00_JPRB,8.3666E+00_JPRB,1.0115E+01_JPRB/)
KBO( :, 5,22,12) = (/&
&4.1224E+00_JPRB,4.6294E+00_JPRB,6.7220E+00_JPRB,8.4420E+00_JPRB,9.9167E+00_JPRB/)
KBO( :, 1,23,12) = (/&
&1.3635E+00_JPRB,3.9535E+00_JPRB,6.5578E+00_JPRB,8.7891E+00_JPRB,1.1317E+01_JPRB/)
KBO( :, 2,23,12) = (/&
&1.8479E+00_JPRB,4.1472E+00_JPRB,6.7653E+00_JPRB,8.8306E+00_JPRB,1.1151E+01_JPRB/)
KBO( :, 3,23,12) = (/&
&2.4090E+00_JPRB,4.3291E+00_JPRB,6.9299E+00_JPRB,8.9124E+00_JPRB,1.0971E+01_JPRB/)
KBO( :, 4,23,12) = (/&
&3.0476E+00_JPRB,4.5186E+00_JPRB,7.0757E+00_JPRB,9.0158E+00_JPRB,1.0781E+01_JPRB/)
KBO( :, 5,23,12) = (/&
&3.7677E+00_JPRB,4.7466E+00_JPRB,7.1916E+00_JPRB,9.0858E+00_JPRB,1.0580E+01_JPRB/)
KBO( :, 1,24,12) = (/&
&1.2524E+00_JPRB,4.1964E+00_JPRB,7.0027E+00_JPRB,9.3088E+00_JPRB,1.1891E+01_JPRB/)
KBO( :, 2,24,12) = (/&
&1.6860E+00_JPRB,4.3866E+00_JPRB,7.2061E+00_JPRB,9.3894E+00_JPRB,1.1740E+01_JPRB/)
KBO( :, 3,24,12) = (/&
&2.1916E+00_JPRB,4.5632E+00_JPRB,7.3707E+00_JPRB,9.5161E+00_JPRB,1.1574E+01_JPRB/)
KBO( :, 4,24,12) = (/&
&2.7755E+00_JPRB,4.7310E+00_JPRB,7.5040E+00_JPRB,9.6239E+00_JPRB,1.1390E+01_JPRB/)
KBO( :, 5,24,12) = (/&
&3.4421E+00_JPRB,4.9112E+00_JPRB,7.6141E+00_JPRB,9.6873E+00_JPRB,1.1189E+01_JPRB/)
KBO( :, 1,25,12) = (/&
&1.1444E+00_JPRB,4.4093E+00_JPRB,7.3963E+00_JPRB,9.7702E+00_JPRB,1.2380E+01_JPRB/)
KBO( :, 2,25,12) = (/&
&1.5338E+00_JPRB,4.5946E+00_JPRB,7.5950E+00_JPRB,9.9140E+00_JPRB,1.2253E+01_JPRB/)
KBO( :, 3,25,12) = (/&
&1.9951E+00_JPRB,4.7679E+00_JPRB,7.7559E+00_JPRB,1.0074E+01_JPRB,1.2101E+01_JPRB/)
KBO( :, 4,25,12) = (/&
&2.5340E+00_JPRB,4.9285E+00_JPRB,7.8837E+00_JPRB,1.0178E+01_JPRB,1.1928E+01_JPRB/)
KBO( :, 5,25,12) = (/&
&3.1490E+00_JPRB,5.0856E+00_JPRB,7.9862E+00_JPRB,1.0230E+01_JPRB,1.1731E+01_JPRB/)
KBO( :, 1,26,12) = (/&
&1.0478E+00_JPRB,4.5874E+00_JPRB,7.7327E+00_JPRB,1.0197E+01_JPRB,1.2777E+01_JPRB/)
KBO( :, 2,26,12) = (/&
&1.4034E+00_JPRB,4.7724E+00_JPRB,7.9352E+00_JPRB,1.0399E+01_JPRB,1.2676E+01_JPRB/)
KBO( :, 3,26,12) = (/&
&1.8290E+00_JPRB,4.9445E+00_JPRB,8.0940E+00_JPRB,1.0560E+01_JPRB,1.2548E+01_JPRB/)
KBO( :, 4,26,12) = (/&
&2.3262E+00_JPRB,5.0995E+00_JPRB,8.2175E+00_JPRB,1.0662E+01_JPRB,1.2385E+01_JPRB/)
KBO( :, 5,26,12) = (/&
&2.8994E+00_JPRB,5.2504E+00_JPRB,8.3168E+00_JPRB,1.0708E+01_JPRB,1.2185E+01_JPRB/)
KBO( :, 1,27,12) = (/&
&9.6295E-01_JPRB,4.7357E+00_JPRB,8.0186E+00_JPRB,1.0582E+01_JPRB,1.3091E+01_JPRB/)
KBO( :, 2,27,12) = (/&
&1.2910E+00_JPRB,4.9215E+00_JPRB,8.2248E+00_JPRB,1.0814E+01_JPRB,1.3028E+01_JPRB/)
KBO( :, 3,27,12) = (/&
&1.6838E+00_JPRB,5.0898E+00_JPRB,8.3871E+00_JPRB,1.0984E+01_JPRB,1.2918E+01_JPRB/)
KBO( :, 4,27,12) = (/&
&2.1466E+00_JPRB,5.2404E+00_JPRB,8.5110E+00_JPRB,1.1084E+01_JPRB,1.2766E+01_JPRB/)
KBO( :, 5,27,12) = (/&
&2.6872E+00_JPRB,5.3861E+00_JPRB,8.6027E+00_JPRB,1.1128E+01_JPRB,1.2572E+01_JPRB/)
KBO( :, 1,28,12) = (/&
&8.9212E-01_JPRB,4.8606E+00_JPRB,8.2568E+00_JPRB,1.0928E+01_JPRB,1.3355E+01_JPRB/)
KBO( :, 2,28,12) = (/&
&1.1960E+00_JPRB,5.0446E+00_JPRB,8.4744E+00_JPRB,1.1178E+01_JPRB,1.3316E+01_JPRB/)
KBO( :, 3,28,12) = (/&
&1.5631E+00_JPRB,5.2061E+00_JPRB,8.6403E+00_JPRB,1.1353E+01_JPRB,1.3227E+01_JPRB/)
KBO( :, 4,28,12) = (/&
&2.0020E+00_JPRB,5.3547E+00_JPRB,8.7642E+00_JPRB,1.1451E+01_JPRB,1.3084E+01_JPRB/)
KBO( :, 5,28,12) = (/&
&2.5209E+00_JPRB,5.4919E+00_JPRB,8.8461E+00_JPRB,1.1491E+01_JPRB,1.2898E+01_JPRB/)
KBO( :, 1,29,12) = (/&
&8.3439E-01_JPRB,4.9630E+00_JPRB,8.4638E+00_JPRB,1.1240E+01_JPRB,1.3569E+01_JPRB/)
KBO( :, 2,29,12) = (/&
&1.1207E+00_JPRB,5.1454E+00_JPRB,8.6875E+00_JPRB,1.1503E+01_JPRB,1.3552E+01_JPRB/)
KBO( :, 3,29,12) = (/&
&1.4717E+00_JPRB,5.3013E+00_JPRB,8.8580E+00_JPRB,1.1673E+01_JPRB,1.3478E+01_JPRB/)
KBO( :, 4,29,12) = (/&
&1.8931E+00_JPRB,5.4461E+00_JPRB,8.9793E+00_JPRB,1.1770E+01_JPRB,1.3347E+01_JPRB/)
KBO( :, 5,29,12) = (/&
&2.3917E+00_JPRB,5.5710E+00_JPRB,9.0514E+00_JPRB,1.1806E+01_JPRB,1.3171E+01_JPRB/)
KBO( :, 1,30,12) = (/&
&7.8953E-01_JPRB,5.0479E+00_JPRB,8.6488E+00_JPRB,1.1520E+01_JPRB,1.3753E+01_JPRB/)
KBO( :, 2,30,12) = (/&
&1.0632E+00_JPRB,5.2264E+00_JPRB,8.8753E+00_JPRB,1.1783E+01_JPRB,1.3755E+01_JPRB/)
KBO( :, 3,30,12) = (/&
&1.4002E+00_JPRB,5.3769E+00_JPRB,9.0463E+00_JPRB,1.1951E+01_JPRB,1.3696E+01_JPRB/)
KBO( :, 4,30,12) = (/&
&1.8078E+00_JPRB,5.5153E+00_JPRB,9.1561E+00_JPRB,1.2049E+01_JPRB,1.3577E+01_JPRB/)
KBO( :, 5,30,12) = (/&
&2.2911E+00_JPRB,5.6294E+00_JPRB,9.2248E+00_JPRB,1.2077E+01_JPRB,1.3407E+01_JPRB/)
KBO( :, 1,31,12) = (/&
&7.5763E-01_JPRB,5.1182E+00_JPRB,8.8135E+00_JPRB,1.1775E+01_JPRB,1.3909E+01_JPRB/)
KBO( :, 2,31,12) = (/&
&1.0216E+00_JPRB,5.2915E+00_JPRB,9.0421E+00_JPRB,1.2027E+01_JPRB,1.3937E+01_JPRB/)
KBO( :, 3,31,12) = (/&
&1.3478E+00_JPRB,5.4413E+00_JPRB,9.2028E+00_JPRB,1.2197E+01_JPRB,1.3886E+01_JPRB/)
KBO( :, 4,31,12) = (/&
&1.7441E+00_JPRB,5.5694E+00_JPRB,9.3055E+00_JPRB,1.2288E+01_JPRB,1.3772E+01_JPRB/)
KBO( :, 5,31,12) = (/&
&2.2144E+00_JPRB,5.6760E+00_JPRB,9.3680E+00_JPRB,1.2303E+01_JPRB,1.3606E+01_JPRB/)
KBO( :, 1,32,12) = (/&
&7.3463E-01_JPRB,5.1776E+00_JPRB,8.9653E+00_JPRB,1.1995E+01_JPRB,1.4066E+01_JPRB/)
KBO( :, 2,32,12) = (/&
&9.9287E-01_JPRB,5.3488E+00_JPRB,9.1823E+00_JPRB,1.2248E+01_JPRB,1.4093E+01_JPRB/)
KBO( :, 3,32,12) = (/&
&1.3124E+00_JPRB,5.4937E+00_JPRB,9.3364E+00_JPRB,1.2412E+01_JPRB,1.4048E+01_JPRB/)
KBO( :, 4,32,12) = (/&
&1.6979E+00_JPRB,5.6116E+00_JPRB,9.4348E+00_JPRB,1.2490E+01_JPRB,1.3938E+01_JPRB/)
KBO( :, 5,32,12) = (/&
&2.1569E+00_JPRB,5.7180E+00_JPRB,9.4915E+00_JPRB,1.2493E+01_JPRB,1.3768E+01_JPRB/)
KBO( :, 1,33,12) = (/&
&7.1977E-01_JPRB,5.2298E+00_JPRB,9.0982E+00_JPRB,1.2196E+01_JPRB,1.4201E+01_JPRB/)
KBO( :, 2,33,12) = (/&
&9.7359E-01_JPRB,5.3967E+00_JPRB,9.3054E+00_JPRB,1.2444E+01_JPRB,1.4231E+01_JPRB/)
KBO( :, 3,33,12) = (/&
&1.2863E+00_JPRB,5.5361E+00_JPRB,9.4542E+00_JPRB,1.2592E+01_JPRB,1.4192E+01_JPRB/)
KBO( :, 4,33,12) = (/&
&1.6635E+00_JPRB,5.6471E+00_JPRB,9.5434E+00_JPRB,1.2656E+01_JPRB,1.4080E+01_JPRB/)
KBO( :, 5,33,12) = (/&
&2.1169E+00_JPRB,5.7606E+00_JPRB,9.5939E+00_JPRB,1.2650E+01_JPRB,1.3912E+01_JPRB/)
KBO( :, 1,34,12) = (/&
&7.0357E-01_JPRB,5.2718E+00_JPRB,9.2058E+00_JPRB,1.2367E+01_JPRB,1.4318E+01_JPRB/)
KBO( :, 2,34,12) = (/&
&9.5100E-01_JPRB,5.4364E+00_JPRB,9.4086E+00_JPRB,1.2603E+01_JPRB,1.4360E+01_JPRB/)
KBO( :, 3,34,12) = (/&
&1.2571E+00_JPRB,5.5683E+00_JPRB,9.5524E+00_JPRB,1.2741E+01_JPRB,1.4321E+01_JPRB/)
KBO( :, 4,34,12) = (/&
&1.6282E+00_JPRB,5.6772E+00_JPRB,9.6331E+00_JPRB,1.2794E+01_JPRB,1.4205E+01_JPRB/)
KBO( :, 5,34,12) = (/&
&2.0759E+00_JPRB,5.7973E+00_JPRB,9.6806E+00_JPRB,1.2780E+01_JPRB,1.4057E+01_JPRB/)
KBO( :, 1,35,12) = (/&
&6.7127E-01_JPRB,5.2954E+00_JPRB,9.2834E+00_JPRB,1.2496E+01_JPRB,1.4429E+01_JPRB/)
KBO( :, 2,35,12) = (/&
&9.0855E-01_JPRB,5.4587E+00_JPRB,9.4864E+00_JPRB,1.2723E+01_JPRB,1.4480E+01_JPRB/)
KBO( :, 3,35,12) = (/&
&1.2033E+00_JPRB,5.5864E+00_JPRB,9.6267E+00_JPRB,1.2858E+01_JPRB,1.4440E+01_JPRB/)
KBO( :, 4,35,12) = (/&
&1.5648E+00_JPRB,5.6975E+00_JPRB,9.7046E+00_JPRB,1.2909E+01_JPRB,1.4336E+01_JPRB/)
KBO( :, 5,35,12) = (/&
&2.0039E+00_JPRB,5.8207E+00_JPRB,9.7512E+00_JPRB,1.2890E+01_JPRB,1.4208E+01_JPRB/)
KBO( :, 1,36,12) = (/&
&6.2192E-01_JPRB,5.2979E+00_JPRB,9.3271E+00_JPRB,1.2576E+01_JPRB,1.4520E+01_JPRB/)
KBO( :, 2,36,12) = (/&
&8.4546E-01_JPRB,5.4637E+00_JPRB,9.5367E+00_JPRB,1.2809E+01_JPRB,1.4583E+01_JPRB/)
KBO( :, 3,36,12) = (/&
&1.1251E+00_JPRB,5.5908E+00_JPRB,9.6790E+00_JPRB,1.2948E+01_JPRB,1.4550E+01_JPRB/)
KBO( :, 4,36,12) = (/&
&1.4725E+00_JPRB,5.7038E+00_JPRB,9.7597E+00_JPRB,1.3004E+01_JPRB,1.4471E+01_JPRB/)
KBO( :, 5,36,12) = (/&
&1.8981E+00_JPRB,5.8306E+00_JPRB,9.8077E+00_JPRB,1.2987E+01_JPRB,1.4353E+01_JPRB/)
KBO( :, 1,37,12) = (/&
&5.5089E-01_JPRB,5.2730E+00_JPRB,9.3242E+00_JPRB,1.2595E+01_JPRB,1.4578E+01_JPRB/)
KBO( :, 2,37,12) = (/&
&7.5546E-01_JPRB,5.4446E+00_JPRB,9.5503E+00_JPRB,1.2851E+01_JPRB,1.4663E+01_JPRB/)
KBO( :, 3,37,12) = (/&
&1.0138E+00_JPRB,5.5779E+00_JPRB,9.7054E+00_JPRB,1.3008E+01_JPRB,1.4649E+01_JPRB/)
KBO( :, 4,37,12) = (/&
&1.3388E+00_JPRB,5.6937E+00_JPRB,9.7968E+00_JPRB,1.3080E+01_JPRB,1.4599E+01_JPRB/)
KBO( :, 5,37,12) = (/&
&1.7405E+00_JPRB,5.8196E+00_JPRB,9.8483E+00_JPRB,1.3074E+01_JPRB,1.4497E+01_JPRB/)
KBO( :, 1,38,12) = (/&
&4.8774E-01_JPRB,5.2446E+00_JPRB,9.3121E+00_JPRB,1.2598E+01_JPRB,1.4624E+01_JPRB/)
KBO( :, 2,38,12) = (/&
&6.7596E-01_JPRB,5.4236E+00_JPRB,9.5535E+00_JPRB,1.2878E+01_JPRB,1.4727E+01_JPRB/)
KBO( :, 3,38,12) = (/&
&9.1580E-01_JPRB,5.5635E+00_JPRB,9.7210E+00_JPRB,1.3053E+01_JPRB,1.4738E+01_JPRB/)
KBO( :, 4,38,12) = (/&
&1.2196E+00_JPRB,5.6813E+00_JPRB,9.8236E+00_JPRB,1.3139E+01_JPRB,1.4721E+01_JPRB/)
KBO( :, 5,38,12) = (/&
&1.5995E+00_JPRB,5.8073E+00_JPRB,9.8794E+00_JPRB,1.3147E+01_JPRB,1.4637E+01_JPRB/)
KBO( :, 1,39,12) = (/&
&4.3319E-01_JPRB,5.2171E+00_JPRB,9.2923E+00_JPRB,1.2591E+01_JPRB,1.4655E+01_JPRB/)
KBO( :, 2,39,12) = (/&
&6.0674E-01_JPRB,5.4013E+00_JPRB,9.5491E+00_JPRB,1.2892E+01_JPRB,1.4779E+01_JPRB/)
KBO( :, 3,39,12) = (/&
&8.3076E-01_JPRB,5.5491E+00_JPRB,9.7285E+00_JPRB,1.3083E+01_JPRB,1.4825E+01_JPRB/)
KBO( :, 4,39,12) = (/&
&1.1162E+00_JPRB,5.6693E+00_JPRB,9.8420E+00_JPRB,1.3183E+01_JPRB,1.4848E+01_JPRB/)
KBO( :, 5,39,12) = (/&
&1.4760E+00_JPRB,5.7939E+00_JPRB,9.9065E+00_JPRB,1.3208E+01_JPRB,1.4788E+01_JPRB/)
KBO( :, 1,40,12) = (/&
&3.7146E-01_JPRB,5.1676E+00_JPRB,9.2350E+00_JPRB,1.2533E+01_JPRB,1.4645E+01_JPRB/)
KBO( :, 2,40,12) = (/&
&5.2844E-01_JPRB,5.3608E+00_JPRB,9.5128E+00_JPRB,1.2866E+01_JPRB,1.4804E+01_JPRB/)
KBO( :, 3,40,12) = (/&
&7.3313E-01_JPRB,5.5191E+00_JPRB,9.7148E+00_JPRB,1.3086E+01_JPRB,1.4881E+01_JPRB/)
KBO( :, 4,40,12) = (/&
&9.9528E-01_JPRB,5.6415E+00_JPRB,9.8443E+00_JPRB,1.3210E+01_JPRB,1.4931E+01_JPRB/)
KBO( :, 5,40,12) = (/&
&1.3291E+00_JPRB,5.7657E+00_JPRB,9.9220E+00_JPRB,1.3255E+01_JPRB,1.4902E+01_JPRB/)
KBO( :, 1,41,12) = (/&
&3.1691E-01_JPRB,5.1123E+00_JPRB,9.1654E+00_JPRB,1.2453E+01_JPRB,1.4615E+01_JPRB/)
KBO( :, 2,41,12) = (/&
&4.5854E-01_JPRB,5.3141E+00_JPRB,9.4645E+00_JPRB,1.2820E+01_JPRB,1.4813E+01_JPRB/)
KBO( :, 3,41,12) = (/&
&6.4497E-01_JPRB,5.4832E+00_JPRB,9.6893E+00_JPRB,1.3072E+01_JPRB,1.4921E+01_JPRB/)
KBO( :, 4,41,12) = (/&
&8.8600E-01_JPRB,5.6149E+00_JPRB,9.8376E+00_JPRB,1.3222E+01_JPRB,1.5000E+01_JPRB/)
KBO( :, 5,41,12) = (/&
&1.1949E+00_JPRB,5.7388E+00_JPRB,9.9263E+00_JPRB,1.3289E+01_JPRB,1.5001E+01_JPRB/)
KBO( :, 1,42,12) = (/&
&2.6990E-01_JPRB,5.0545E+00_JPRB,9.0851E+00_JPRB,1.2357E+01_JPRB,1.4568E+01_JPRB/)
KBO( :, 2,42,12) = (/&
&3.9791E-01_JPRB,5.2666E+00_JPRB,9.4059E+00_JPRB,1.2762E+01_JPRB,1.4811E+01_JPRB/)
KBO( :, 3,42,12) = (/&
&5.6786E-01_JPRB,5.4473E+00_JPRB,9.6535E+00_JPRB,1.3042E+01_JPRB,1.4951E+01_JPRB/)
KBO( :, 4,42,12) = (/&
&7.8985E-01_JPRB,5.5889E+00_JPRB,9.8202E+00_JPRB,1.3220E+01_JPRB,1.5062E+01_JPRB/)
KBO( :, 5,42,12) = (/&
&1.0759E+00_JPRB,5.7103E+00_JPRB,9.9256E+00_JPRB,1.3308E+01_JPRB,1.5095E+01_JPRB/)
KBO( :, 1,43,12) = (/&
&2.2408E-01_JPRB,4.9801E+00_JPRB,8.9750E+00_JPRB,1.2220E+01_JPRB,1.4488E+01_JPRB/)
KBO( :, 2,43,12) = (/&
&3.3742E-01_JPRB,5.2050E+00_JPRB,9.3221E+00_JPRB,1.2666E+01_JPRB,1.4779E+01_JPRB/)
KBO( :, 3,43,12) = (/&
&4.9010E-01_JPRB,5.3960E+00_JPRB,9.5945E+00_JPRB,1.2984E+01_JPRB,1.4959E+01_JPRB/)
KBO( :, 4,43,12) = (/&
&6.9169E-01_JPRB,5.5493E+00_JPRB,9.7889E+00_JPRB,1.3197E+01_JPRB,1.5104E+01_JPRB/)
KBO( :, 5,43,12) = (/&
&9.5305E-01_JPRB,5.6745E+00_JPRB,9.9131E+00_JPRB,1.3310E+01_JPRB,1.5176E+01_JPRB/)
KBO( :, 1,44,12) = (/&
&1.8323E-01_JPRB,4.8933E+00_JPRB,8.8410E+00_JPRB,1.2051E+01_JPRB,1.4377E+01_JPRB/)
KBO( :, 2,44,12) = (/&
&2.8217E-01_JPRB,5.1330E+00_JPRB,9.2212E+00_JPRB,1.2543E+01_JPRB,1.4725E+01_JPRB/)
KBO( :, 3,44,12) = (/&
&4.1838E-01_JPRB,5.3347E+00_JPRB,9.5219E+00_JPRB,1.2906E+01_JPRB,1.4949E+01_JPRB/)
KBO( :, 4,44,12) = (/&
&5.9984E-01_JPRB,5.5043E+00_JPRB,9.7457E+00_JPRB,1.3153E+01_JPRB,1.5131E+01_JPRB/)
KBO( :, 5,44,12) = (/&
&8.3730E-01_JPRB,5.6361E+00_JPRB,9.8881E+00_JPRB,1.3302E+01_JPRB,1.5248E+01_JPRB/)
KBO( :, 1,45,12) = (/&
&1.4904E-01_JPRB,4.8014E+00_JPRB,8.6942E+00_JPRB,1.1857E+01_JPRB,1.4243E+01_JPRB/)
KBO( :, 2,45,12) = (/&
&2.3486E-01_JPRB,5.0590E+00_JPRB,9.1087E+00_JPRB,1.2404E+01_JPRB,1.4652E+01_JPRB/)
KBO( :, 3,45,12) = (/&
&3.5578E-01_JPRB,5.2728E+00_JPRB,9.4361E+00_JPRB,1.2811E+01_JPRB,1.4928E+01_JPRB/)
KBO( :, 4,45,12) = (/&
&5.1907E-01_JPRB,5.4551E+00_JPRB,9.6849E+00_JPRB,1.3095E+01_JPRB,1.5155E+01_JPRB/)
KBO( :, 5,45,12) = (/&
&7.3447E-01_JPRB,5.5970E+00_JPRB,9.8551E+00_JPRB,1.3278E+01_JPRB,1.5316E+01_JPRB/)
KBO( :, 1,46,12) = (/&
&1.1910E-01_JPRB,4.6973E+00_JPRB,8.5264E+00_JPRB,1.1635E+01_JPRB,1.4074E+01_JPRB/)
KBO( :, 2,46,12) = (/&
&1.9264E-01_JPRB,4.9713E+00_JPRB,8.9752E+00_JPRB,1.2231E+01_JPRB,1.4552E+01_JPRB/)
KBO( :, 3,46,12) = (/&
&2.9840E-01_JPRB,5.1994E+00_JPRB,9.3302E+00_JPRB,1.2687E+01_JPRB,1.4886E+01_JPRB/)
KBO( :, 4,46,12) = (/&
&4.4420E-01_JPRB,5.3934E+00_JPRB,9.6109E+00_JPRB,1.3017E+01_JPRB,1.5158E+01_JPRB/)
KBO( :, 5,46,12) = (/&
&6.3821E-01_JPRB,5.5501E+00_JPRB,9.8128E+00_JPRB,1.3236E+01_JPRB,1.5371E+01_JPRB/)
KBO( :, 1,47,12) = (/&
&9.2205E-02_JPRB,4.5728E+00_JPRB,8.3222E+00_JPRB,1.1357E+01_JPRB,1.3848E+01_JPRB/)
KBO( :, 2,47,12) = (/&
&1.5376E-01_JPRB,4.8658E+00_JPRB,8.8065E+00_JPRB,1.2014E+01_JPRB,1.4405E+01_JPRB/)
KBO( :, 3,47,12) = (/&
&2.4420E-01_JPRB,5.1135E+00_JPRB,9.2023E+00_JPRB,1.2528E+01_JPRB,1.4805E+01_JPRB/)
KBO( :, 4,47,12) = (/&
&3.7202E-01_JPRB,5.3206E+00_JPRB,9.5150E+00_JPRB,1.2907E+01_JPRB,1.5121E+01_JPRB/)
KBO( :, 5,47,12) = (/&
&5.4440E-01_JPRB,5.4945E+00_JPRB,9.7455E+00_JPRB,1.3168E+01_JPRB,1.5387E+01_JPRB/)
KBO( :, 1,48,12) = (/&
&7.0454E-02_JPRB,4.4412E+00_JPRB,8.1011E+00_JPRB,1.1048E+01_JPRB,1.3590E+01_JPRB/)
KBO( :, 2,48,12) = (/&
&1.2149E-01_JPRB,4.7546E+00_JPRB,8.6257E+00_JPRB,1.1771E+01_JPRB,1.4231E+01_JPRB/)
KBO( :, 3,48,12) = (/&
&1.9826E-01_JPRB,5.0205E+00_JPRB,9.0577E+00_JPRB,1.2345E+01_JPRB,1.4705E+01_JPRB/)
KBO( :, 4,48,12) = (/&
&3.0915E-01_JPRB,5.2415E+00_JPRB,9.3998E+00_JPRB,1.2778E+01_JPRB,1.5077E+01_JPRB/)
KBO( :, 5,48,12) = (/&
&4.6199E-01_JPRB,5.4308E+00_JPRB,9.6652E+00_JPRB,1.3083E+01_JPRB,1.5397E+01_JPRB/)
KBO( :, 1,49,12) = (/&
&5.3088E-02_JPRB,4.3008E+00_JPRB,7.8587E+00_JPRB,1.0710E+01_JPRB,1.3300E+01_JPRB/)
KBO( :, 2,49,12) = (/&
&9.4886E-02_JPRB,4.6325E+00_JPRB,8.4260E+00_JPRB,1.1503E+01_JPRB,1.4035E+01_JPRB/)
KBO( :, 3,49,12) = (/&
&1.5966E-01_JPRB,4.9173E+00_JPRB,8.8952E+00_JPRB,1.2135E+01_JPRB,1.4593E+01_JPRB/)
KBO( :, 4,49,12) = (/&
&2.5505E-01_JPRB,5.1573E+00_JPRB,9.2755E+00_JPRB,1.2624E+01_JPRB,1.5028E+01_JPRB/)
KBO( :, 5,49,12) = (/&
&3.8941E-01_JPRB,5.3580E+00_JPRB,9.5745E+00_JPRB,1.2980E+01_JPRB,1.5409E+01_JPRB/)
KBO( :, 1,50,12) = (/&
&4.0067E-02_JPRB,4.1596E+00_JPRB,7.6089E+00_JPRB,1.0372E+01_JPRB,1.2988E+01_JPRB/)
KBO( :, 2,50,12) = (/&
&7.4256E-02_JPRB,4.5125E+00_JPRB,8.2260E+00_JPRB,1.1225E+01_JPRB,1.3810E+01_JPRB/)
KBO( :, 3,50,12) = (/&
&1.2901E-01_JPRB,4.8174E+00_JPRB,8.7310E+00_JPRB,1.1915E+01_JPRB,1.4444E+01_JPRB/)
KBO( :, 4,50,12) = (/&
&2.1116E-01_JPRB,5.0740E+00_JPRB,9.1458E+00_JPRB,1.2461E+01_JPRB,1.4934E+01_JPRB/)
KBO( :, 5,50,12) = (/&
&3.2945E-01_JPRB,5.2879E+00_JPRB,9.4738E+00_JPRB,1.2866E+01_JPRB,1.5371E+01_JPRB/)
KBO( :, 1,51,12) = (/&
&3.0082E-02_JPRB,4.0166E+00_JPRB,7.3470E+00_JPRB,1.0024E+01_JPRB,1.2649E+01_JPRB/)
KBO( :, 2,51,12) = (/&
&5.7864E-02_JPRB,4.3904E+00_JPRB,8.0166E+00_JPRB,1.0930E+01_JPRB,1.3555E+01_JPRB/)
KBO( :, 3,51,12) = (/&
&1.0385E-01_JPRB,4.7103E+00_JPRB,8.5593E+00_JPRB,1.1684E+01_JPRB,1.4265E+01_JPRB/)
KBO( :, 4,51,12) = (/&
&1.7451E-01_JPRB,4.9838E+00_JPRB,9.0063E+00_JPRB,1.2280E+01_JPRB,1.4812E+01_JPRB/)
KBO( :, 5,51,12) = (/&
&2.7822E-01_JPRB,5.2130E+00_JPRB,9.3629E+00_JPRB,1.2735E+01_JPRB,1.5297E+01_JPRB/)
KBO( :, 1,52,12) = (/&
&2.2321E-02_JPRB,3.8633E+00_JPRB,7.0669E+00_JPRB,9.6645E+00_JPRB,1.2286E+01_JPRB/)
KBO( :, 2,52,12) = (/&
&4.4568E-02_JPRB,4.2586E+00_JPRB,7.7887E+00_JPRB,1.0615E+01_JPRB,1.3275E+01_JPRB/)
KBO( :, 3,52,12) = (/&
&8.2764E-02_JPRB,4.5976E+00_JPRB,8.3722E+00_JPRB,1.1430E+01_JPRB,1.4067E+01_JPRB/)
KBO( :, 4,52,12) = (/&
&1.4332E-01_JPRB,4.8897E+00_JPRB,8.8533E+00_JPRB,1.2081E+01_JPRB,1.4681E+01_JPRB/)
KBO( :, 5,52,12) = (/&
&2.3359E-01_JPRB,5.1350E+00_JPRB,9.2453E+00_JPRB,1.2589E+01_JPRB,1.5214E+01_JPRB/)
KBO( :, 1,53,12) = (/&
&1.6320E-02_JPRB,3.7017E+00_JPRB,6.7670E+00_JPRB,9.2859E+00_JPRB,1.1890E+01_JPRB/)
KBO( :, 2,53,12) = (/&
&3.3883E-02_JPRB,4.1210E+00_JPRB,7.5408E+00_JPRB,1.0281E+01_JPRB,1.2972E+01_JPRB/)
KBO( :, 3,53,12) = (/&
&6.5211E-02_JPRB,4.4803E+00_JPRB,8.1737E+00_JPRB,1.1152E+01_JPRB,1.3849E+01_JPRB/)
KBO( :, 4,53,12) = (/&
&1.1656E-01_JPRB,4.7901E+00_JPRB,8.6895E+00_JPRB,1.1861E+01_JPRB,1.4540E+01_JPRB/)
KBO( :, 5,53,12) = (/&
&1.9454E-01_JPRB,5.0513E+00_JPRB,9.1138E+00_JPRB,1.2423E+01_JPRB,1.5132E+01_JPRB/)
KBO( :, 1,54,12) = (/&
&1.2044E-02_JPRB,3.5460E+00_JPRB,6.4769E+00_JPRB,8.9175E+00_JPRB,1.1478E+01_JPRB/)
KBO( :, 2,54,12) = (/&
&2.6009E-02_JPRB,3.9878E+00_JPRB,7.2955E+00_JPRB,9.9571E+00_JPRB,1.2628E+01_JPRB/)
KBO( :, 3,54,12) = (/&
&5.1821E-02_JPRB,4.3666E+00_JPRB,7.9779E+00_JPRB,1.0876E+01_JPRB,1.3583E+01_JPRB/)
KBO( :, 4,54,12) = (/&
&9.5474E-02_JPRB,4.6901E+00_JPRB,8.5279E+00_JPRB,1.1644E+01_JPRB,1.4331E+01_JPRB/)
KBO( :, 5,54,12) = (/&
&1.6346E-01_JPRB,4.9679E+00_JPRB,8.9829E+00_JPRB,1.2251E+01_JPRB,1.4953E+01_JPRB/)
KBO( :, 1,55,12) = (/&
&8.8474E-03_JPRB,3.3874E+00_JPRB,6.1849E+00_JPRB,8.5463E+00_JPRB,1.1054E+01_JPRB/)
KBO( :, 2,55,12) = (/&
&1.9964E-02_JPRB,3.8514E+00_JPRB,7.0467E+00_JPRB,9.6387E+00_JPRB,1.2268E+01_JPRB/)
KBO( :, 3,55,12) = (/&
&4.1152E-02_JPRB,4.2498E+00_JPRB,7.7746E+00_JPRB,1.0596E+01_JPRB,1.3279E+01_JPRB/)
KBO( :, 4,55,12) = (/&
&7.8159E-02_JPRB,4.5905E+00_JPRB,8.3623E+00_JPRB,1.1417E+01_JPRB,1.4084E+01_JPRB/)
KBO( :, 5,55,12) = (/&
&1.3750E-01_JPRB,4.8845E+00_JPRB,8.8463E+00_JPRB,1.2073E+01_JPRB,1.4722E+01_JPRB/)
KBO( :, 1,56,12) = (/&
&6.4082E-03_JPRB,3.2244E+00_JPRB,5.8774E+00_JPRB,8.1652E+00_JPRB,1.0610E+01_JPRB/)
KBO( :, 2,56,12) = (/&
&1.5162E-02_JPRB,3.7100E+00_JPRB,6.7838E+00_JPRB,9.3060E+00_JPRB,1.1893E+01_JPRB/)
KBO( :, 3,56,12) = (/&
&3.2388E-02_JPRB,4.1289E+00_JPRB,7.5561E+00_JPRB,1.0301E+01_JPRB,1.2952E+01_JPRB/)
KBO( :, 4,56,12) = (/&
&6.3471E-02_JPRB,4.4879E+00_JPRB,8.1882E+00_JPRB,1.1172E+01_JPRB,1.3823E+01_JPRB/)
KBO( :, 5,56,12) = (/&
&1.1487E-01_JPRB,4.7971E+00_JPRB,8.7028E+00_JPRB,1.1880E+01_JPRB,1.4496E+01_JPRB/)
KBO( :, 1,57,12) = (/&
&4.5631E-03_JPRB,3.0511E+00_JPRB,5.5587E+00_JPRB,7.7750E+00_JPRB,1.0138E+01_JPRB/)
KBO( :, 2,57,12) = (/&
&1.1368E-02_JPRB,3.5622E+00_JPRB,6.5073E+00_JPRB,8.9555E+00_JPRB,1.1499E+01_JPRB/)
KBO( :, 3,57,12) = (/&
&2.5250E-02_JPRB,4.0025E+00_JPRB,7.3232E+00_JPRB,9.9930E+00_JPRB,1.2617E+01_JPRB/)
KBO( :, 4,57,12) = (/&
&5.1105E-02_JPRB,4.3794E+00_JPRB,8.0015E+00_JPRB,1.0910E+01_JPRB,1.3544E+01_JPRB/)
KBO( :, 5,57,12) = (/&
&9.5178E-02_JPRB,4.7023E+00_JPRB,8.5498E+00_JPRB,1.1673E+01_JPRB,1.4270E+01_JPRB/)
KBO( :, 1,58,12) = (/&
&3.2442E-03_JPRB,2.8817E+00_JPRB,5.2469E+00_JPRB,7.3938E+00_JPRB,9.6647E+00_JPRB/)
KBO( :, 2,58,12) = (/&
&8.5196E-03_JPRB,3.4130E+00_JPRB,6.2333E+00_JPRB,8.6058E+00_JPRB,1.1102E+01_JPRB/)
KBO( :, 3,58,12) = (/&
&1.9737E-02_JPRB,3.8740E+00_JPRB,7.0888E+00_JPRB,9.6922E+00_JPRB,1.2287E+01_JPRB/)
KBO( :, 4,58,12) = (/&
&4.1256E-02_JPRB,4.2697E+00_JPRB,7.8107E+00_JPRB,1.0646E+01_JPRB,1.3253E+01_JPRB/)
KBO( :, 5,58,12) = (/&
&7.9005E-02_JPRB,4.6081E+00_JPRB,8.3923E+00_JPRB,1.1459E+01_JPRB,1.4032E+01_JPRB/)
KBO( :, 1,59,12) = (/&
&2.7554E-03_JPRB,2.8115E+00_JPRB,5.1204E+00_JPRB,7.2380E+00_JPRB,9.4574E+00_JPRB/)
KBO( :, 2,59,12) = (/&
&7.4695E-03_JPRB,3.3520E+00_JPRB,6.1191E+00_JPRB,8.4629E+00_JPRB,1.0919E+01_JPRB/)
KBO( :, 3,59,12) = (/&
&1.7700E-02_JPRB,3.8208E+00_JPRB,6.9919E+00_JPRB,9.5688E+00_JPRB,1.2133E+01_JPRB/)
KBO( :, 4,59,12) = (/&
&3.7590E-02_JPRB,4.2246E+00_JPRB,7.7306E+00_JPRB,1.0537E+01_JPRB,1.3092E+01_JPRB/)
KBO( :, 5,59,12) = (/&
&7.2976E-02_JPRB,4.5698E+00_JPRB,8.3286E+00_JPRB,1.1370E+01_JPRB,1.3863E+01_JPRB/)
KBO( :, 1,13,13) = (/&
&2.6529E+00_JPRB,2.2831E+00_JPRB,3.2422E+00_JPRB,4.4425E+00_JPRB,5.7532E+00_JPRB/)
KBO( :, 2,13,13) = (/&
&3.7901E+00_JPRB,3.0012E+00_JPRB,3.3868E+00_JPRB,4.4780E+00_JPRB,5.6304E+00_JPRB/)
KBO( :, 3,13,13) = (/&
&5.1407E+00_JPRB,3.9898E+00_JPRB,3.7034E+00_JPRB,4.5284E+00_JPRB,5.5094E+00_JPRB/)
KBO( :, 4,13,13) = (/&
&6.6849E+00_JPRB,5.1505E+00_JPRB,4.1152E+00_JPRB,4.5525E+00_JPRB,5.3863E+00_JPRB/)
KBO( :, 5,13,13) = (/&
&8.4107E+00_JPRB,6.4413E+00_JPRB,4.6939E+00_JPRB,4.5962E+00_JPRB,5.2598E+00_JPRB/)
KBO( :, 1,14,13) = (/&
&2.7859E+00_JPRB,2.4754E+00_JPRB,3.5707E+00_JPRB,4.9274E+00_JPRB,6.3617E+00_JPRB/)
KBO( :, 2,14,13) = (/&
&3.9819E+00_JPRB,3.1616E+00_JPRB,3.7430E+00_JPRB,4.9467E+00_JPRB,6.2248E+00_JPRB/)
KBO( :, 3,14,13) = (/&
&5.4169E+00_JPRB,4.1984E+00_JPRB,4.1076E+00_JPRB,4.9547E+00_JPRB,6.0805E+00_JPRB/)
KBO( :, 4,14,13) = (/&
&7.0660E+00_JPRB,5.4307E+00_JPRB,4.5231E+00_JPRB,4.9634E+00_JPRB,5.9266E+00_JPRB/)
KBO( :, 5,14,13) = (/&
&8.9144E+00_JPRB,6.8140E+00_JPRB,5.0663E+00_JPRB,5.0044E+00_JPRB,5.7690E+00_JPRB/)
KBO( :, 1,15,13) = (/&
&2.9857E+00_JPRB,2.7217E+00_JPRB,3.9316E+00_JPRB,5.4603E+00_JPRB,7.0398E+00_JPRB/)
KBO( :, 2,15,13) = (/&
&4.2764E+00_JPRB,3.4089E+00_JPRB,4.1424E+00_JPRB,5.4476E+00_JPRB,6.8612E+00_JPRB/)
KBO( :, 3,15,13) = (/&
&5.8211E+00_JPRB,4.5002E+00_JPRB,4.5148E+00_JPRB,5.4204E+00_JPRB,6.6790E+00_JPRB/)
KBO( :, 4,15,13) = (/&
&7.6022E+00_JPRB,5.8275E+00_JPRB,4.9790E+00_JPRB,5.4051E+00_JPRB,6.4972E+00_JPRB/)
KBO( :, 5,15,13) = (/&
&9.6077E+00_JPRB,7.3247E+00_JPRB,5.5648E+00_JPRB,5.4790E+00_JPRB,6.3175E+00_JPRB/)
KBO( :, 1,16,13) = (/&
&3.2520E+00_JPRB,3.0398E+00_JPRB,4.3234E+00_JPRB,6.0080E+00_JPRB,7.7322E+00_JPRB/)
KBO( :, 2,16,13) = (/&
&4.6456E+00_JPRB,3.7621E+00_JPRB,4.5833E+00_JPRB,5.9695E+00_JPRB,7.5298E+00_JPRB/)
KBO( :, 3,16,13) = (/&
&6.3086E+00_JPRB,4.8685E+00_JPRB,4.9506E+00_JPRB,5.9143E+00_JPRB,7.3233E+00_JPRB/)
KBO( :, 4,16,13) = (/&
&8.2262E+00_JPRB,6.2820E+00_JPRB,5.4881E+00_JPRB,5.8959E+00_JPRB,7.1229E+00_JPRB/)
KBO( :, 5,16,13) = (/&
&1.0371E+01_JPRB,7.8838E+00_JPRB,6.1617E+00_JPRB,6.0261E+00_JPRB,6.9371E+00_JPRB/)
KBO( :, 1,17,13) = (/&
&3.5103E+00_JPRB,3.4027E+00_JPRB,4.7571E+00_JPRB,6.5946E+00_JPRB,8.5011E+00_JPRB/)
KBO( :, 2,17,13) = (/&
&4.9855E+00_JPRB,4.1396E+00_JPRB,5.0300E+00_JPRB,6.5219E+00_JPRB,8.2752E+00_JPRB/)
KBO( :, 3,17,13) = (/&
&6.7391E+00_JPRB,5.2214E+00_JPRB,5.4410E+00_JPRB,6.4503E+00_JPRB,8.0549E+00_JPRB/)
KBO( :, 4,17,13) = (/&
&8.7527E+00_JPRB,6.6750E+00_JPRB,6.0440E+00_JPRB,6.4589E+00_JPRB,7.8521E+00_JPRB/)
KBO( :, 5,17,13) = (/&
&1.0977E+01_JPRB,8.3330E+00_JPRB,6.7610E+00_JPRB,6.6072E+00_JPRB,7.6623E+00_JPRB/)
KBO( :, 1,18,13) = (/&
&3.7201E+00_JPRB,3.7715E+00_JPRB,5.2410E+00_JPRB,7.2877E+00_JPRB,9.4447E+00_JPRB/)
KBO( :, 2,18,13) = (/&
&5.2473E+00_JPRB,4.5163E+00_JPRB,5.5131E+00_JPRB,7.1747E+00_JPRB,9.1964E+00_JPRB/)
KBO( :, 3,18,13) = (/&
&7.0567E+00_JPRB,5.5681E+00_JPRB,5.9890E+00_JPRB,7.0880E+00_JPRB,8.9663E+00_JPRB/)
KBO( :, 4,18,13) = (/&
&9.1072E+00_JPRB,6.9581E+00_JPRB,6.6273E+00_JPRB,7.1370E+00_JPRB,8.7546E+00_JPRB/)
KBO( :, 5,18,13) = (/&
&1.1367E+01_JPRB,8.6174E+00_JPRB,7.3488E+00_JPRB,7.2704E+00_JPRB,8.5556E+00_JPRB/)
KBO( :, 1,19,13) = (/&
&3.8561E+00_JPRB,4.1299E+00_JPRB,5.8089E+00_JPRB,8.1195E+00_JPRB,1.0564E+01_JPRB/)
KBO( :, 2,19,13) = (/&
&5.4052E+00_JPRB,4.8948E+00_JPRB,6.0739E+00_JPRB,7.9918E+00_JPRB,1.0309E+01_JPRB/)
KBO( :, 3,19,13) = (/&
&7.2158E+00_JPRB,5.8804E+00_JPRB,6.5899E+00_JPRB,7.9071E+00_JPRB,1.0068E+01_JPRB/)
KBO( :, 4,19,13) = (/&
&9.2611E+00_JPRB,7.1822E+00_JPRB,7.2047E+00_JPRB,7.9510E+00_JPRB,9.8352E+00_JPRB/)
KBO( :, 5,19,13) = (/&
&1.1520E+01_JPRB,8.7584E+00_JPRB,7.9092E+00_JPRB,8.0447E+00_JPRB,9.6021E+00_JPRB/)
KBO( :, 1,20,13) = (/&
&3.9352E+00_JPRB,4.4974E+00_JPRB,6.4850E+00_JPRB,9.0968E+00_JPRB,1.1862E+01_JPRB/)
KBO( :, 2,20,13) = (/&
&5.4656E+00_JPRB,5.2567E+00_JPRB,6.7702E+00_JPRB,8.9553E+00_JPRB,1.1592E+01_JPRB/)
KBO( :, 3,20,13) = (/&
&7.2432E+00_JPRB,6.1806E+00_JPRB,7.2339E+00_JPRB,8.8912E+00_JPRB,1.1329E+01_JPRB/)
KBO( :, 4,20,13) = (/&
&9.2559E+00_JPRB,7.3730E+00_JPRB,7.8059E+00_JPRB,8.9109E+00_JPRB,1.1059E+01_JPRB/)
KBO( :, 5,20,13) = (/&
&1.1478E+01_JPRB,8.8414E+00_JPRB,8.4557E+00_JPRB,8.9640E+00_JPRB,1.0785E+01_JPRB/)
KBO( :, 1,21,13) = (/&
&3.9152E+00_JPRB,4.8660E+00_JPRB,7.2675E+00_JPRB,1.0177E+01_JPRB,1.3275E+01_JPRB/)
KBO( :, 2,21,13) = (/&
&5.3925E+00_JPRB,5.5769E+00_JPRB,7.5673E+00_JPRB,1.0032E+01_JPRB,1.2988E+01_JPRB/)
KBO( :, 3,21,13) = (/&
&7.1172E+00_JPRB,6.4580E+00_JPRB,7.9491E+00_JPRB,9.9865E+00_JPRB,1.2690E+01_JPRB/)
KBO( :, 4,21,13) = (/&
&9.0683E+00_JPRB,7.5180E+00_JPRB,8.4370E+00_JPRB,9.9647E+00_JPRB,1.2379E+01_JPRB/)
KBO( :, 5,21,13) = (/&
&1.1238E+01_JPRB,8.8639E+00_JPRB,9.0125E+00_JPRB,9.9895E+00_JPRB,1.2064E+01_JPRB/)
KBO( :, 1,22,13) = (/&
&3.8909E+00_JPRB,5.2900E+00_JPRB,8.1566E+00_JPRB,1.1308E+01_JPRB,1.4732E+01_JPRB/)
KBO( :, 2,22,13) = (/&
&5.3181E+00_JPRB,5.9209E+00_JPRB,8.4402E+00_JPRB,1.1175E+01_JPRB,1.4410E+01_JPRB/)
KBO( :, 3,22,13) = (/&
&6.9795E+00_JPRB,6.7348E+00_JPRB,8.7599E+00_JPRB,1.1122E+01_JPRB,1.4067E+01_JPRB/)
KBO( :, 4,22,13) = (/&
&8.8688E+00_JPRB,7.7237E+00_JPRB,9.1513E+00_JPRB,1.1075E+01_JPRB,1.3709E+01_JPRB/)
KBO( :, 5,22,13) = (/&
&1.0970E+01_JPRB,8.9302E+00_JPRB,9.6408E+00_JPRB,1.1105E+01_JPRB,1.3343E+01_JPRB/)
KBO( :, 1,23,13) = (/&
&3.7997E+00_JPRB,5.7292E+00_JPRB,9.0913E+00_JPRB,1.2436E+01_JPRB,1.6180E+01_JPRB/)
KBO( :, 2,23,13) = (/&
&5.1595E+00_JPRB,6.2753E+00_JPRB,9.3535E+00_JPRB,1.2331E+01_JPRB,1.5809E+01_JPRB/)
KBO( :, 3,23,13) = (/&
&6.7493E+00_JPRB,6.9925E+00_JPRB,9.6137E+00_JPRB,1.2263E+01_JPRB,1.5425E+01_JPRB/)
KBO( :, 4,23,13) = (/&
&8.5542E+00_JPRB,7.9012E+00_JPRB,9.9104E+00_JPRB,1.2220E+01_JPRB,1.5025E+01_JPRB/)
KBO( :, 5,23,13) = (/&
&1.0561E+01_JPRB,8.9781E+00_JPRB,1.0309E+01_JPRB,1.2253E+01_JPRB,1.4614E+01_JPRB/)
KBO( :, 1,24,13) = (/&
&3.6631E+00_JPRB,6.1905E+00_JPRB,1.0011E+01_JPRB,1.3544E+01_JPRB,1.7573E+01_JPRB/)
KBO( :, 2,24,13) = (/&
&4.9530E+00_JPRB,6.6528E+00_JPRB,1.0267E+01_JPRB,1.3455E+01_JPRB,1.7161E+01_JPRB/)
KBO( :, 3,24,13) = (/&
&6.4554E+00_JPRB,7.2715E+00_JPRB,1.0481E+01_JPRB,1.3377E+01_JPRB,1.6726E+01_JPRB/)
KBO( :, 4,24,13) = (/&
&8.1608E+00_JPRB,8.0605E+00_JPRB,1.0709E+01_JPRB,1.3365E+01_JPRB,1.6282E+01_JPRB/)
KBO( :, 5,24,13) = (/&
&1.0048E+01_JPRB,9.0171E+00_JPRB,1.1006E+01_JPRB,1.3382E+01_JPRB,1.5827E+01_JPRB/)
KBO( :, 1,25,13) = (/&
&3.5057E+00_JPRB,6.6591E+00_JPRB,1.0912E+01_JPRB,1.4625E+01_JPRB,1.8883E+01_JPRB/)
KBO( :, 2,25,13) = (/&
&4.7154E+00_JPRB,7.0448E+00_JPRB,1.1156E+01_JPRB,1.4541E+01_JPRB,1.8427E+01_JPRB/)
KBO( :, 3,25,13) = (/&
&6.1224E+00_JPRB,7.5602E+00_JPRB,1.1335E+01_JPRB,1.4472E+01_JPRB,1.7954E+01_JPRB/)
KBO( :, 4,25,13) = (/&
&7.7153E+00_JPRB,8.2240E+00_JPRB,1.1508E+01_JPRB,1.4486E+01_JPRB,1.7464E+01_JPRB/)
KBO( :, 5,25,13) = (/&
&9.4941E+00_JPRB,9.0534E+00_JPRB,1.1717E+01_JPRB,1.4473E+01_JPRB,1.6960E+01_JPRB/)
KBO( :, 1,26,13) = (/&
&3.3374E+00_JPRB,7.1235E+00_JPRB,1.1789E+01_JPRB,1.5669E+01_JPRB,2.0088E+01_JPRB/)
KBO( :, 2,26,13) = (/&
&4.4661E+00_JPRB,7.4439E+00_JPRB,1.2007E+01_JPRB,1.5575E+01_JPRB,1.9597E+01_JPRB/)
KBO( :, 3,26,13) = (/&
&5.7769E+00_JPRB,7.8591E+00_JPRB,1.2149E+01_JPRB,1.5545E+01_JPRB,1.9088E+01_JPRB/)
KBO( :, 4,26,13) = (/&
&7.2756E+00_JPRB,8.4078E+00_JPRB,1.2269E+01_JPRB,1.5555E+01_JPRB,1.8555E+01_JPRB/)
KBO( :, 5,26,13) = (/&
&8.9639E+00_JPRB,9.1104E+00_JPRB,1.2401E+01_JPRB,1.5501E+01_JPRB,1.8008E+01_JPRB/)
KBO( :, 1,27,13) = (/&
&3.1533E+00_JPRB,7.5608E+00_JPRB,1.2611E+01_JPRB,1.6642E+01_JPRB,2.1191E+01_JPRB/)
KBO( :, 2,27,13) = (/&
&4.1993E+00_JPRB,7.8220E+00_JPRB,1.2795E+01_JPRB,1.6570E+01_JPRB,2.0672E+01_JPRB/)
KBO( :, 3,27,13) = (/&
&5.4265E+00_JPRB,8.1469E+00_JPRB,1.2900E+01_JPRB,1.6567E+01_JPRB,2.0125E+01_JPRB/)
KBO( :, 4,27,13) = (/&
&6.8378E+00_JPRB,8.5911E+00_JPRB,1.2961E+01_JPRB,1.6544E+01_JPRB,1.9552E+01_JPRB/)
KBO( :, 5,27,13) = (/&
&8.4460E+00_JPRB,9.1761E+00_JPRB,1.3028E+01_JPRB,1.6437E+01_JPRB,1.8965E+01_JPRB/)
KBO( :, 1,28,13) = (/&
&2.9616E+00_JPRB,7.9550E+00_JPRB,1.3362E+01_JPRB,1.7538E+01_JPRB,2.2180E+01_JPRB/)
KBO( :, 2,28,13) = (/&
&3.9383E+00_JPRB,8.1625E+00_JPRB,1.3501E+01_JPRB,1.7502E+01_JPRB,2.1637E+01_JPRB/)
KBO( :, 3,28,13) = (/&
&5.0899E+00_JPRB,8.4137E+00_JPRB,1.3570E+01_JPRB,1.7504E+01_JPRB,2.1054E+01_JPRB/)
KBO( :, 4,28,13) = (/&
&6.4309E+00_JPRB,8.7658E+00_JPRB,1.3582E+01_JPRB,1.7435E+01_JPRB,2.0443E+01_JPRB/)
KBO( :, 5,28,13) = (/&
&7.9687E+00_JPRB,9.2612E+00_JPRB,1.3583E+01_JPRB,1.7274E+01_JPRB,1.9806E+01_JPRB/)
KBO( :, 1,29,13) = (/&
&2.7798E+00_JPRB,8.2996E+00_JPRB,1.4029E+01_JPRB,1.8369E+01_JPRB,2.3056E+01_JPRB/)
KBO( :, 2,29,13) = (/&
&3.6961E+00_JPRB,8.4616E+00_JPRB,1.4123E+01_JPRB,1.8351E+01_JPRB,2.2490E+01_JPRB/)
KBO( :, 3,29,13) = (/&
&4.7900E+00_JPRB,8.6571E+00_JPRB,1.4153E+01_JPRB,1.8339E+01_JPRB,2.1869E+01_JPRB/)
KBO( :, 4,29,13) = (/&
&6.0802E+00_JPRB,8.9313E+00_JPRB,1.4117E+01_JPRB,1.8214E+01_JPRB,2.1214E+01_JPRB/)
KBO( :, 5,29,13) = (/&
&7.5801E+00_JPRB,9.3590E+00_JPRB,1.4065E+01_JPRB,1.8003E+01_JPRB,2.0531E+01_JPRB/)
KBO( :, 1,30,13) = (/&
&2.6097E+00_JPRB,8.5908E+00_JPRB,1.4603E+01_JPRB,1.9121E+01_JPRB,2.3810E+01_JPRB/)
KBO( :, 2,30,13) = (/&
&3.4798E+00_JPRB,8.7177E+00_JPRB,1.4662E+01_JPRB,1.9123E+01_JPRB,2.3210E+01_JPRB/)
KBO( :, 3,30,13) = (/&
&4.5355E+00_JPRB,8.8683E+00_JPRB,1.4648E+01_JPRB,1.9056E+01_JPRB,2.2548E+01_JPRB/)
KBO( :, 4,30,13) = (/&
&5.7939E+00_JPRB,9.0839E+00_JPRB,1.4573E+01_JPRB,1.8881E+01_JPRB,2.1848E+01_JPRB/)
KBO( :, 5,30,13) = (/&
&7.2765E+00_JPRB,9.4615E+00_JPRB,1.4472E+01_JPRB,1.8622E+01_JPRB,2.1123E+01_JPRB/)
KBO( :, 1,31,13) = (/&
&2.4675E+00_JPRB,8.8387E+00_JPRB,1.5097E+01_JPRB,1.9786E+01_JPRB,2.4442E+01_JPRB/)
KBO( :, 2,31,13) = (/&
&3.3065E+00_JPRB,8.9332E+00_JPRB,1.5120E+01_JPRB,1.9782E+01_JPRB,2.3801E+01_JPRB/)
KBO( :, 3,31,13) = (/&
&4.3370E+00_JPRB,9.0438E+00_JPRB,1.5067E+01_JPRB,1.9662E+01_JPRB,2.3103E+01_JPRB/)
KBO( :, 4,31,13) = (/&
&5.5801E+00_JPRB,9.2263E+00_JPRB,1.4955E+01_JPRB,1.9437E+01_JPRB,2.2362E+01_JPRB/)
KBO( :, 5,31,13) = (/&
&7.0509E+00_JPRB,9.5653E+00_JPRB,1.4810E+01_JPRB,1.9130E+01_JPRB,2.1597E+01_JPRB/)
KBO( :, 1,32,13) = (/&
&2.3570E+00_JPRB,9.0474E+00_JPRB,1.5512E+01_JPRB,2.0376E+01_JPRB,2.4941E+01_JPRB/)
KBO( :, 2,32,13) = (/&
&3.1778E+00_JPRB,9.1115E+00_JPRB,1.5508E+01_JPRB,2.0335E+01_JPRB,2.4268E+01_JPRB/)
KBO( :, 3,32,13) = (/&
&4.1934E+00_JPRB,9.1907E+00_JPRB,1.5415E+01_JPRB,2.0161E+01_JPRB,2.3538E+01_JPRB/)
KBO( :, 4,32,13) = (/&
&5.4301E+00_JPRB,9.3557E+00_JPRB,1.5262E+01_JPRB,1.9889E+01_JPRB,2.2767E+01_JPRB/)
KBO( :, 5,32,13) = (/&
&6.9074E+00_JPRB,9.6740E+00_JPRB,1.5082E+01_JPRB,1.9542E+01_JPRB,2.1974E+01_JPRB/)
KBO( :, 1,33,13) = (/&
&2.2789E+00_JPRB,9.2179E+00_JPRB,1.5861E+01_JPRB,2.0884E+01_JPRB,2.5338E+01_JPRB/)
KBO( :, 2,33,13) = (/&
&3.0898E+00_JPRB,9.2539E+00_JPRB,1.5825E+01_JPRB,2.0788E+01_JPRB,2.4635E+01_JPRB/)
KBO( :, 3,33,13) = (/&
&4.1032E+00_JPRB,9.3163E+00_JPRB,1.5692E+01_JPRB,2.0569E+01_JPRB,2.3873E+01_JPRB/)
KBO( :, 4,33,13) = (/&
&5.3488E+00_JPRB,9.4706E+00_JPRB,1.5505E+01_JPRB,2.0254E+01_JPRB,2.3076E+01_JPRB/)
KBO( :, 5,33,13) = (/&
&6.8488E+00_JPRB,9.7721E+00_JPRB,1.5299E+01_JPRB,1.9864E+01_JPRB,2.2268E+01_JPRB/)
KBO( :, 1,34,13) = (/&
&2.2036E+00_JPRB,9.3532E+00_JPRB,1.6153E+01_JPRB,2.1306E+01_JPRB,2.5672E+01_JPRB/)
KBO( :, 2,34,13) = (/&
&3.0096E+00_JPRB,9.3699E+00_JPRB,1.6083E+01_JPRB,2.1168E+01_JPRB,2.4937E+01_JPRB/)
KBO( :, 3,34,13) = (/&
&4.0278E+00_JPRB,9.4208E+00_JPRB,1.5917E+01_JPRB,2.0905E+01_JPRB,2.4148E+01_JPRB/)
KBO( :, 4,34,13) = (/&
&5.2881E+00_JPRB,9.5680E+00_JPRB,1.5706E+01_JPRB,2.0553E+01_JPRB,2.3339E+01_JPRB/)
KBO( :, 5,34,13) = (/&
&6.8127E+00_JPRB,9.8518E+00_JPRB,1.5477E+01_JPRB,2.0124E+01_JPRB,2.2490E+01_JPRB/)
KBO( :, 1,35,13) = (/&
&2.0911E+00_JPRB,9.4628E+00_JPRB,1.6401E+01_JPRB,2.1656E+01_JPRB,2.5992E+01_JPRB/)
KBO( :, 2,35,13) = (/&
&2.8838E+00_JPRB,9.4629E+00_JPRB,1.6303E+01_JPRB,2.1492E+01_JPRB,2.5233E+01_JPRB/)
KBO( :, 3,35,13) = (/&
&3.8959E+00_JPRB,9.5011E+00_JPRB,1.6117E+01_JPRB,2.1198E+01_JPRB,2.4439E+01_JPRB/)
KBO( :, 4,35,13) = (/&
&5.1566E+00_JPRB,9.6352E+00_JPRB,1.5885E+01_JPRB,2.0818E+01_JPRB,2.3603E+01_JPRB/)
KBO( :, 5,35,13) = (/&
&6.6907E+00_JPRB,9.8962E+00_JPRB,1.5633E+01_JPRB,2.0364E+01_JPRB,2.2731E+01_JPRB/)
KBO( :, 1,36,13) = (/&
&1.9336E+00_JPRB,9.5525E+00_JPRB,1.6611E+01_JPRB,2.1959E+01_JPRB,2.6325E+01_JPRB/)
KBO( :, 2,36,13) = (/&
&2.7002E+00_JPRB,9.5428E+00_JPRB,1.6501E+01_JPRB,2.1782E+01_JPRB,2.5563E+01_JPRB/)
KBO( :, 3,36,13) = (/&
&3.6889E+00_JPRB,9.5627E+00_JPRB,1.6302E+01_JPRB,2.1472E+01_JPRB,2.4764E+01_JPRB/)
KBO( :, 4,36,13) = (/&
&4.9268E+00_JPRB,9.6763E+00_JPRB,1.6053E+01_JPRB,2.1074E+01_JPRB,2.3903E+01_JPRB/)
KBO( :, 5,36,13) = (/&
&6.4449E+00_JPRB,9.9025E+00_JPRB,1.5784E+01_JPRB,2.0602E+01_JPRB,2.3039E+01_JPRB/)
KBO( :, 1,37,13) = (/&
&1.7104E+00_JPRB,9.6249E+00_JPRB,1.6795E+01_JPRB,2.2228E+01_JPRB,2.6709E+01_JPRB/)
KBO( :, 2,37,13) = (/&
&2.4252E+00_JPRB,9.6135E+00_JPRB,1.6690E+01_JPRB,2.2061E+01_JPRB,2.5960E+01_JPRB/)
KBO( :, 3,37,13) = (/&
&3.3606E+00_JPRB,9.6107E+00_JPRB,1.6491E+01_JPRB,2.1757E+01_JPRB,2.5160E+01_JPRB/)
KBO( :, 4,37,13) = (/&
&4.5420E+00_JPRB,9.6944E+00_JPRB,1.6238E+01_JPRB,2.1356E+01_JPRB,2.4291E+01_JPRB/)
KBO( :, 5,37,13) = (/&
&6.0039E+00_JPRB,9.8734E+00_JPRB,1.5956E+01_JPRB,2.0878E+01_JPRB,2.3432E+01_JPRB/)
KBO( :, 1,38,13) = (/&
&1.5178E+00_JPRB,9.6872E+00_JPRB,1.6953E+01_JPRB,2.2459E+01_JPRB,2.7050E+01_JPRB/)
KBO( :, 2,38,13) = (/&
&2.1837E+00_JPRB,9.6773E+00_JPRB,1.6856E+01_JPRB,2.2300E+01_JPRB,2.6324E+01_JPRB/)
KBO( :, 3,38,13) = (/&
&3.0661E+00_JPRB,9.6576E+00_JPRB,1.6660E+01_JPRB,2.2007E+01_JPRB,2.5527E+01_JPRB/)
KBO( :, 4,38,13) = (/&
&4.1937E+00_JPRB,9.7120E+00_JPRB,1.6406E+01_JPRB,2.1607E+01_JPRB,2.4654E+01_JPRB/)
KBO( :, 5,38,13) = (/&
&5.6039E+00_JPRB,9.8559E+00_JPRB,1.6114E+01_JPRB,2.1125E+01_JPRB,2.3814E+01_JPRB/)
KBO( :, 1,39,13) = (/&
&1.3554E+00_JPRB,9.7390E+00_JPRB,1.7088E+01_JPRB,2.2653E+01_JPRB,2.7361E+01_JPRB/)
KBO( :, 2,39,13) = (/&
&1.9775E+00_JPRB,9.7313E+00_JPRB,1.6998E+01_JPRB,2.2506E+01_JPRB,2.6660E+01_JPRB/)
KBO( :, 3,39,13) = (/&
&2.8107E+00_JPRB,9.7018E+00_JPRB,1.6808E+01_JPRB,2.2224E+01_JPRB,2.5863E+01_JPRB/)
KBO( :, 4,39,13) = (/&
&3.8900E+00_JPRB,9.7305E+00_JPRB,1.6552E+01_JPRB,2.1827E+01_JPRB,2.4995E+01_JPRB/)
KBO( :, 5,39,13) = (/&
&5.2496E+00_JPRB,9.8477E+00_JPRB,1.6251E+01_JPRB,2.1343E+01_JPRB,2.4180E+01_JPRB/)
KBO( :, 1,40,13) = (/&
&1.1681E+00_JPRB,9.7791E+00_JPRB,1.7201E+01_JPRB,2.2818E+01_JPRB,2.7695E+01_JPRB/)
KBO( :, 2,40,13) = (/&
&1.7299E+00_JPRB,9.7827E+00_JPRB,1.7132E+01_JPRB,2.2703E+01_JPRB,2.7023E+01_JPRB/)
KBO( :, 3,40,13) = (/&
&2.4946E+00_JPRB,9.7467E+00_JPRB,1.6955E+01_JPRB,2.2448E+01_JPRB,2.6240E+01_JPRB/)
KBO( :, 4,40,13) = (/&
&3.5017E+00_JPRB,9.7482E+00_JPRB,1.6709E+01_JPRB,2.2060E+01_JPRB,2.5376E+01_JPRB/)
KBO( :, 5,40,13) = (/&
&4.7836E+00_JPRB,9.8329E+00_JPRB,1.6405E+01_JPRB,2.1591E+01_JPRB,2.4561E+01_JPRB/)
KBO( :, 1,41,13) = (/&
&1.0033E+00_JPRB,9.8102E+00_JPRB,1.7286E+01_JPRB,2.2943E+01_JPRB,2.8002E+01_JPRB/)
KBO( :, 2,41,13) = (/&
&1.5079E+00_JPRB,9.8257E+00_JPRB,1.7243E+01_JPRB,2.2872E+01_JPRB,2.7362E+01_JPRB/)
KBO( :, 3,41,13) = (/&
&2.2063E+00_JPRB,9.7913E+00_JPRB,1.7089E+01_JPRB,2.2643E+01_JPRB,2.6601E+01_JPRB/)
KBO( :, 4,41,13) = (/&
&3.1401E+00_JPRB,9.7698E+00_JPRB,1.6851E+01_JPRB,2.2278E+01_JPRB,2.5742E+01_JPRB/)
KBO( :, 5,41,13) = (/&
&4.3440E+00_JPRB,9.8243E+00_JPRB,1.6560E+01_JPRB,2.1826E+01_JPRB,2.4926E+01_JPRB/)
KBO( :, 1,42,13) = (/&
&8.6335E-01_JPRB,9.8273E+00_JPRB,1.7356E+01_JPRB,2.3044E+01_JPRB,2.8283E+01_JPRB/)
KBO( :, 2,42,13) = (/&
&1.3157E+00_JPRB,9.8564E+00_JPRB,1.7335E+01_JPRB,2.3007E+01_JPRB,2.7677E+01_JPRB/)
KBO( :, 3,42,13) = (/&
&1.9522E+00_JPRB,9.8313E+00_JPRB,1.7204E+01_JPRB,2.2814E+01_JPRB,2.6940E+01_JPRB/)
KBO( :, 4,42,13) = (/&
&2.8149E+00_JPRB,9.7926E+00_JPRB,1.6984E+01_JPRB,2.2480E+01_JPRB,2.6086E+01_JPRB/)
KBO( :, 5,42,13) = (/&
&3.9427E+00_JPRB,9.8251E+00_JPRB,1.6704E+01_JPRB,2.2040E+01_JPRB,2.5280E+01_JPRB/)
KBO( :, 1,43,13) = (/&
&7.2508E-01_JPRB,9.8337E+00_JPRB,1.7398E+01_JPRB,2.3109E+01_JPRB,2.8558E+01_JPRB/)
KBO( :, 2,43,13) = (/&
&1.1220E+00_JPRB,9.8829E+00_JPRB,1.7414E+01_JPRB,2.3123E+01_JPRB,2.7999E+01_JPRB/)
KBO( :, 3,43,13) = (/&
&1.6895E+00_JPRB,9.8684E+00_JPRB,1.7314E+01_JPRB,2.2973E+01_JPRB,2.7299E+01_JPRB/)
KBO( :, 4,43,13) = (/&
&2.4716E+00_JPRB,9.8264E+00_JPRB,1.7115E+01_JPRB,2.2681E+01_JPRB,2.6464E+01_JPRB/)
KBO( :, 5,43,13) = (/&
&3.5092E+00_JPRB,9.8254E+00_JPRB,1.6846E+01_JPRB,2.2258E+01_JPRB,2.5655E+01_JPRB/)
KBO( :, 1,44,13) = (/&
&6.0013E-01_JPRB,9.8242E+00_JPRB,1.7407E+01_JPRB,2.3147E+01_JPRB,2.8810E+01_JPRB/)
KBO( :, 2,44,13) = (/&
&9.4539E-01_JPRB,9.8972E+00_JPRB,1.7468E+01_JPRB,2.3207E+01_JPRB,2.8309E+01_JPRB/)
KBO( :, 3,44,13) = (/&
&1.4447E+00_JPRB,9.9041E+00_JPRB,1.7409E+01_JPRB,2.3114E+01_JPRB,2.7658E+01_JPRB/)
KBO( :, 4,44,13) = (/&
&2.1455E+00_JPRB,9.8623E+00_JPRB,1.7235E+01_JPRB,2.2860E+01_JPRB,2.6847E+01_JPRB/)
KBO( :, 5,44,13) = (/&
&3.0884E+00_JPRB,9.8324E+00_JPRB,1.6982E+01_JPRB,2.2470E+01_JPRB,2.6041E+01_JPRB/)
KBO( :, 1,45,13) = (/&
&4.9465E-01_JPRB,9.7992E+00_JPRB,1.7389E+01_JPRB,2.3167E+01_JPRB,2.9031E+01_JPRB/)
KBO( :, 2,45,13) = (/&
&7.9499E-01_JPRB,9.8981E+00_JPRB,1.7509E+01_JPRB,2.3257E+01_JPRB,2.8598E+01_JPRB/)
KBO( :, 3,45,13) = (/&
&1.2327E+00_JPRB,9.9225E+00_JPRB,1.7478E+01_JPRB,2.3219E+01_JPRB,2.7995E+01_JPRB/)
KBO( :, 4,45,13) = (/&
&1.8567E+00_JPRB,9.8915E+00_JPRB,1.7341E+01_JPRB,2.3018E+01_JPRB,2.7214E+01_JPRB/)
KBO( :, 5,45,13) = (/&
&2.7102E+00_JPRB,9.8493E+00_JPRB,1.7115E+01_JPRB,2.2672E+01_JPRB,2.6426E+01_JPRB/)
KBO( :, 1,46,13) = (/&
&4.0155E-01_JPRB,9.7565E+00_JPRB,1.7327E+01_JPRB,2.3150E+01_JPRB,2.9223E+01_JPRB/)
KBO( :, 2,46,13) = (/&
&6.5885E-01_JPRB,9.8895E+00_JPRB,1.7519E+01_JPRB,2.3282E+01_JPRB,2.8865E+01_JPRB/)
KBO( :, 3,46,13) = (/&
&1.0393E+00_JPRB,9.9389E+00_JPRB,1.7538E+01_JPRB,2.3304E+01_JPRB,2.8321E+01_JPRB/)
KBO( :, 4,46,13) = (/&
&1.5881E+00_JPRB,9.9248E+00_JPRB,1.7436E+01_JPRB,2.3155E+01_JPRB,2.7586E+01_JPRB/)
KBO( :, 5,46,13) = (/&
&2.3518E+00_JPRB,9.8787E+00_JPRB,1.7232E+01_JPRB,2.2856E+01_JPRB,2.6820E+01_JPRB/)
KBO( :, 1,47,13) = (/&
&3.1717E-01_JPRB,9.6922E+00_JPRB,1.7208E+01_JPRB,2.3094E+01_JPRB,2.9376E+01_JPRB/)
KBO( :, 2,47,13) = (/&
&5.3176E-01_JPRB,9.8626E+00_JPRB,1.7496E+01_JPRB,2.3281E+01_JPRB,2.9106E+01_JPRB/)
KBO( :, 3,47,13) = (/&
&8.5644E-01_JPRB,9.9410E+00_JPRB,1.7572E+01_JPRB,2.3352E+01_JPRB,2.8639E+01_JPRB/)
KBO( :, 4,47,13) = (/&
&1.3291E+00_JPRB,9.9482E+00_JPRB,1.7517E+01_JPRB,2.3272E+01_JPRB,2.7966E+01_JPRB/)
KBO( :, 5,47,13) = (/&
&1.9994E+00_JPRB,9.9068E+00_JPRB,1.7348E+01_JPRB,2.3029E+01_JPRB,2.7224E+01_JPRB/)
KBO( :, 1,48,13) = (/&
&2.4862E-01_JPRB,9.6017E+00_JPRB,1.7047E+01_JPRB,2.3003E+01_JPRB,2.9483E+01_JPRB/)
KBO( :, 2,48,13) = (/&
&4.2613E-01_JPRB,9.8140E+00_JPRB,1.7433E+01_JPRB,2.3259E+01_JPRB,2.9313E+01_JPRB/)
KBO( :, 3,48,13) = (/&
&7.0129E-01_JPRB,9.9267E+00_JPRB,1.7586E+01_JPRB,2.3367E+01_JPRB,2.8930E+01_JPRB/)
KBO( :, 4,48,13) = (/&
&1.1072E+00_JPRB,9.9609E+00_JPRB,1.7574E+01_JPRB,2.3356E+01_JPRB,2.8330E+01_JPRB/)
KBO( :, 5,48,13) = (/&
&1.6909E+00_JPRB,9.9361E+00_JPRB,1.7449E+01_JPRB,2.3177E+01_JPRB,2.7634E+01_JPRB/)
KBO( :, 1,49,13) = (/&
&1.9264E-01_JPRB,9.4936E+00_JPRB,1.6831E+01_JPRB,2.2884E+01_JPRB,2.9536E+01_JPRB/)
KBO( :, 2,49,13) = (/&
&3.3927E-01_JPRB,9.7516E+00_JPRB,1.7325E+01_JPRB,2.3198E+01_JPRB,2.9479E+01_JPRB/)
KBO( :, 3,49,13) = (/&
&5.6996E-01_JPRB,9.9055E+00_JPRB,1.7565E+01_JPRB,2.3359E+01_JPRB,2.9191E+01_JPRB/)
KBO( :, 4,49,13) = (/&
&9.1758E-01_JPRB,9.9664E+00_JPRB,1.7609E+01_JPRB,2.3411E+01_JPRB,2.8684E+01_JPRB/)
KBO( :, 5,49,13) = (/&
&1.4225E+00_JPRB,9.9636E+00_JPRB,1.7532E+01_JPRB,2.3297E+01_JPRB,2.8060E+01_JPRB/)
KBO( :, 1,50,13) = (/&
&1.4991E-01_JPRB,9.3720E+00_JPRB,1.6585E+01_JPRB,2.2746E+01_JPRB,2.9526E+01_JPRB/)
KBO( :, 2,50,13) = (/&
&2.7206E-01_JPRB,9.6777E+00_JPRB,1.7184E+01_JPRB,2.3116E+01_JPRB,2.9581E+01_JPRB/)
KBO( :, 3,50,13) = (/&
&4.6587E-01_JPRB,9.8653E+00_JPRB,1.7520E+01_JPRB,2.3339E+01_JPRB,2.9394E+01_JPRB/)
KBO( :, 4,50,13) = (/&
&7.6520E-01_JPRB,9.9556E+00_JPRB,1.7628E+01_JPRB,2.3427E+01_JPRB,2.8975E+01_JPRB/)
KBO( :, 5,50,13) = (/&
&1.2040E+00_JPRB,9.9732E+00_JPRB,1.7585E+01_JPRB,2.3377E+01_JPRB,2.8410E+01_JPRB/)
KBO( :, 1,51,13) = (/&
&1.1613E-01_JPRB,9.2274E+00_JPRB,1.6313E+01_JPRB,2.2591E+01_JPRB,2.9458E+01_JPRB/)
KBO( :, 2,51,13) = (/&
&2.1747E-01_JPRB,9.5837E+00_JPRB,1.7015E+01_JPRB,2.3015E+01_JPRB,2.9634E+01_JPRB/)
KBO( :, 3,51,13) = (/&
&3.8080E-01_JPRB,9.8127E+00_JPRB,1.7438E+01_JPRB,2.3293E+01_JPRB,2.9540E+01_JPRB/)
KBO( :, 4,51,13) = (/&
&6.3740E-01_JPRB,9.9403E+00_JPRB,1.7621E+01_JPRB,2.3422E+01_JPRB,2.9215E+01_JPRB/)
KBO( :, 5,51,13) = (/&
&1.0193E+00_JPRB,9.9828E+00_JPRB,1.7629E+01_JPRB,2.3438E+01_JPRB,2.8716E+01_JPRB/)
KBO( :, 1,52,13) = (/&
&8.8830E-02_JPRB,9.0603E+00_JPRB,1.6002E+01_JPRB,2.2409E+01_JPRB,2.9330E+01_JPRB/)
KBO( :, 2,52,13) = (/&
&1.7228E-01_JPRB,9.4776E+00_JPRB,1.6796E+01_JPRB,2.2887E+01_JPRB,2.9643E+01_JPRB/)
KBO( :, 3,52,13) = (/&
&3.0974E-01_JPRB,9.7502E+00_JPRB,1.7322E+01_JPRB,2.3223E+01_JPRB,2.9659E+01_JPRB/)
KBO( :, 4,52,13) = (/&
&5.2763E-01_JPRB,9.9116E+00_JPRB,1.7589E+01_JPRB,2.3402E+01_JPRB,2.9438E+01_JPRB/)
KBO( :, 5,52,13) = (/&
&8.5949E-01_JPRB,9.9800E+00_JPRB,1.7648E+01_JPRB,2.3465E+01_JPRB,2.9019E+01_JPRB/)
KBO( :, 1,53,13) = (/&
&6.6880E-02_JPRB,8.8647E+00_JPRB,1.5677E+01_JPRB,2.2193E+01_JPRB,2.9155E+01_JPRB/)
KBO( :, 2,53,13) = (/&
&1.3508E-01_JPRB,9.3494E+00_JPRB,1.6545E+01_JPRB,2.2742E+01_JPRB,2.9618E+01_JPRB/)
KBO( :, 3,53,13) = (/&
&2.5013E-01_JPRB,9.6673E+00_JPRB,1.7171E+01_JPRB,2.3128E+01_JPRB,2.9750E+01_JPRB/)
KBO( :, 4,53,13) = (/&
&4.3419E-01_JPRB,9.8656E+00_JPRB,1.7531E+01_JPRB,2.3368E+01_JPRB,2.9650E+01_JPRB/)
KBO( :, 5,53,13) = (/&
&7.2052E-01_JPRB,9.9643E+00_JPRB,1.7656E+01_JPRB,2.3466E+01_JPRB,2.9335E+01_JPRB/)
KBO( :, 1,54,13) = (/&
&5.0839E-02_JPRB,8.6560E+00_JPRB,1.5373E+01_JPRB,2.1974E+01_JPRB,2.8918E+01_JPRB/)
KBO( :, 2,54,13) = (/&
&1.0673E-01_JPRB,9.2095E+00_JPRB,1.6282E+01_JPRB,2.2589E+01_JPRB,2.9523E+01_JPRB/)
KBO( :, 3,54,13) = (/&
&2.0374E-01_JPRB,9.5773E+00_JPRB,1.7000E+01_JPRB,2.3024E+01_JPRB,2.9743E+01_JPRB/)
KBO( :, 4,54,13) = (/&
&3.6116E-01_JPRB,9.8132E+00_JPRB,1.7444E+01_JPRB,2.3313E+01_JPRB,2.9733E+01_JPRB/)
KBO( :, 5,54,13) = (/&
&6.0938E-01_JPRB,9.9478E+00_JPRB,1.7641E+01_JPRB,2.3452E+01_JPRB,2.9479E+01_JPRB/)
KBO( :, 1,55,13) = (/&
&3.8590E-02_JPRB,8.4380E+00_JPRB,1.5071E+01_JPRB,2.1738E+01_JPRB,2.8629E+01_JPRB/)
KBO( :, 2,55,13) = (/&
&8.4187E-02_JPRB,9.0594E+00_JPRB,1.6002E+01_JPRB,2.2420E+01_JPRB,2.9369E+01_JPRB/)
KBO( :, 3,55,13) = (/&
&1.6606E-01_JPRB,9.4812E+00_JPRB,1.6803E+01_JPRB,2.2906E+01_JPRB,2.9692E+01_JPRB/)
KBO( :, 4,55,13) = (/&
&3.0143E-01_JPRB,9.7562E+00_JPRB,1.7333E+01_JPRB,2.3245E+01_JPRB,2.9737E+01_JPRB/)
KBO( :, 5,55,13) = (/&
&5.1631E-01_JPRB,9.9193E+00_JPRB,1.7608E+01_JPRB,2.3429E+01_JPRB,2.9535E+01_JPRB/)
KBO( :, 1,56,13) = (/&
&2.8925E-02_JPRB,8.1981E+00_JPRB,1.4756E+01_JPRB,2.1468E+01_JPRB,2.8292E+01_JPRB/)
KBO( :, 2,56,13) = (/&
&6.5661E-02_JPRB,8.8869E+00_JPRB,1.5713E+01_JPRB,2.2226E+01_JPRB,2.9164E+01_JPRB/)
KBO( :, 3,56,13) = (/&
&1.3426E-01_JPRB,9.3664E+00_JPRB,1.6578E+01_JPRB,2.2772E+01_JPRB,2.9626E+01_JPRB/)
KBO( :, 4,56,13) = (/&
&2.5023E-01_JPRB,9.6820E+00_JPRB,1.7199E+01_JPRB,2.3159E+01_JPRB,2.9723E+01_JPRB/)
KBO( :, 5,56,13) = (/&
&4.3568E-01_JPRB,9.8776E+00_JPRB,1.7553E+01_JPRB,2.3395E+01_JPRB,2.9592E+01_JPRB/)
KBO( :, 1,57,13) = (/&
&2.1373E-02_JPRB,7.9379E+00_JPRB,1.4433E+01_JPRB,2.1148E+01_JPRB,2.7903E+01_JPRB/)
KBO( :, 2,57,13) = (/&
&5.0645E-02_JPRB,8.6879E+00_JPRB,1.5420E+01_JPRB,2.2015E+01_JPRB,2.8928E+01_JPRB/)
KBO( :, 3,57,13) = (/&
&1.0745E-01_JPRB,9.2330E+00_JPRB,1.6328E+01_JPRB,2.2623E+01_JPRB,2.9512E+01_JPRB/)
KBO( :, 4,57,13) = (/&
&2.0610E-01_JPRB,9.5955E+00_JPRB,1.7038E+01_JPRB,2.3057E+01_JPRB,2.9704E+01_JPRB/)
KBO( :, 5,57,13) = (/&
&3.6599E-01_JPRB,9.8279E+00_JPRB,1.7470E+01_JPRB,2.3341E+01_JPRB,2.9632E+01_JPRB/)
KBO( :, 1,58,13) = (/&
&1.5800E-02_JPRB,7.6756E+00_JPRB,1.4130E+01_JPRB,2.0811E+01_JPRB,2.7488E+01_JPRB/)
KBO( :, 2,58,13) = (/&
&3.9154E-02_JPRB,8.4827E+00_JPRB,1.5134E+01_JPRB,2.1791E+01_JPRB,2.8663E+01_JPRB/)
KBO( :, 3,58,13) = (/&
&8.6058E-02_JPRB,9.0936E+00_JPRB,1.6064E+01_JPRB,2.2465E+01_JPRB,2.9358E+01_JPRB/)
KBO( :, 4,58,13) = (/&
&1.7024E-01_JPRB,9.5047E+00_JPRB,1.6851E+01_JPRB,2.2942E+01_JPRB,2.9664E+01_JPRB/)
KBO( :, 5,58,13) = (/&
&3.0899E-01_JPRB,9.7734E+00_JPRB,1.7367E+01_JPRB,2.3275E+01_JPRB,2.9640E+01_JPRB/)
KBO( :, 1,59,13) = (/&
&1.3838E-02_JPRB,7.5677E+00_JPRB,1.4007E+01_JPRB,2.0664E+01_JPRB,2.7307E+01_JPRB/)
KBO( :, 2,59,13) = (/&
&3.5056E-02_JPRB,8.3966E+00_JPRB,1.5017E+01_JPRB,2.1696E+01_JPRB,2.8542E+01_JPRB/)
KBO( :, 3,59,13) = (/&
&7.8363E-02_JPRB,9.0327E+00_JPRB,1.5954E+01_JPRB,2.2395E+01_JPRB,2.9259E+01_JPRB/)
KBO( :, 4,59,13) = (/&
&1.5720E-01_JPRB,9.4649E+00_JPRB,1.6772E+01_JPRB,2.2896E+01_JPRB,2.9587E+01_JPRB/)
KBO( :, 5,59,13) = (/&
&2.8816E-01_JPRB,9.7494E+00_JPRB,1.7321E+01_JPRB,2.3246E+01_JPRB,2.9569E+01_JPRB/)
KBO( :, 1,13,14) = (/&
&4.6782E+00_JPRB,3.6509E+00_JPRB,4.2069E+00_JPRB,5.5965E+00_JPRB,7.3161E+00_JPRB/)
KBO( :, 2,13,14) = (/&
&6.6812E+00_JPRB,5.1302E+00_JPRB,4.5042E+00_JPRB,5.7107E+00_JPRB,7.2956E+00_JPRB/)
KBO( :, 3,13,14) = (/&
&9.0802E+00_JPRB,6.9191E+00_JPRB,5.0854E+00_JPRB,5.8389E+00_JPRB,7.2254E+00_JPRB/)
KBO( :, 4,13,14) = (/&
&1.1847E+01_JPRB,8.9860E+00_JPRB,6.1879E+00_JPRB,5.9827E+00_JPRB,7.1308E+00_JPRB/)
KBO( :, 5,13,14) = (/&
&1.4944E+01_JPRB,1.1307E+01_JPRB,7.6807E+00_JPRB,6.1087E+00_JPRB,7.0090E+00_JPRB/)
KBO( :, 1,14,14) = (/&
&4.9923E+00_JPRB,3.8888E+00_JPRB,4.7381E+00_JPRB,6.4037E+00_JPRB,8.3224E+00_JPRB/)
KBO( :, 2,14,14) = (/&
&7.1439E+00_JPRB,5.4635E+00_JPRB,4.9958E+00_JPRB,6.5120E+00_JPRB,8.2505E+00_JPRB/)
KBO( :, 3,14,14) = (/&
&9.7357E+00_JPRB,7.4026E+00_JPRB,5.5402E+00_JPRB,6.6306E+00_JPRB,8.1450E+00_JPRB/)
KBO( :, 4,14,14) = (/&
&1.2709E+01_JPRB,9.6301E+00_JPRB,6.6722E+00_JPRB,6.7341E+00_JPRB,8.0104E+00_JPRB/)
KBO( :, 5,14,14) = (/&
&1.6035E+01_JPRB,1.2120E+01_JPRB,8.2226E+00_JPRB,6.8436E+00_JPRB,7.8600E+00_JPRB/)
KBO( :, 1,15,14) = (/&
&5.4062E+00_JPRB,4.2107E+00_JPRB,5.3329E+00_JPRB,7.2809E+00_JPRB,9.4098E+00_JPRB/)
KBO( :, 2,15,14) = (/&
&7.7383E+00_JPRB,5.9068E+00_JPRB,5.5826E+00_JPRB,7.3825E+00_JPRB,9.2906E+00_JPRB/)
KBO( :, 3,15,14) = (/&
&1.0510E+01_JPRB,7.9793E+00_JPRB,6.1638E+00_JPRB,7.4874E+00_JPRB,9.1316E+00_JPRB/)
KBO( :, 4,15,14) = (/&
&1.3725E+01_JPRB,1.0385E+01_JPRB,7.2775E+00_JPRB,7.5682E+00_JPRB,8.9529E+00_JPRB/)
KBO( :, 5,15,14) = (/&
&1.7334E+01_JPRB,1.3091E+01_JPRB,8.9110E+00_JPRB,7.6564E+00_JPRB,8.7607E+00_JPRB/)
KBO( :, 1,16,14) = (/&
&5.9070E+00_JPRB,4.6227E+00_JPRB,6.0140E+00_JPRB,8.2333E+00_JPRB,1.0600E+01_JPRB/)
KBO( :, 2,16,14) = (/&
&8.4297E+00_JPRB,6.4209E+00_JPRB,6.2881E+00_JPRB,8.3090E+00_JPRB,1.0416E+01_JPRB/)
KBO( :, 3,16,14) = (/&
&1.1476E+01_JPRB,8.7000E+00_JPRB,6.9539E+00_JPRB,8.3944E+00_JPRB,1.0210E+01_JPRB/)
KBO( :, 4,16,14) = (/&
&1.4985E+01_JPRB,1.1333E+01_JPRB,8.0898E+00_JPRB,8.4541E+00_JPRB,9.9887E+00_JPRB/)
KBO( :, 5,16,14) = (/&
&1.8893E+01_JPRB,1.4263E+01_JPRB,9.7433E+00_JPRB,8.5272E+00_JPRB,9.7516E+00_JPRB/)
KBO( :, 1,17,14) = (/&
&6.5286E+00_JPRB,5.1327E+00_JPRB,6.7700E+00_JPRB,9.2670E+00_JPRB,1.1882E+01_JPRB/)
KBO( :, 2,17,14) = (/&
&9.3114E+00_JPRB,7.0853E+00_JPRB,7.1236E+00_JPRB,9.3227E+00_JPRB,1.1650E+01_JPRB/)
KBO( :, 3,17,14) = (/&
&1.2634E+01_JPRB,9.5700E+00_JPRB,7.8705E+00_JPRB,9.3681E+00_JPRB,1.1400E+01_JPRB/)
KBO( :, 4,17,14) = (/&
&1.6437E+01_JPRB,1.2419E+01_JPRB,9.0210E+00_JPRB,9.4013E+00_JPRB,1.1124E+01_JPRB/)
KBO( :, 5,17,14) = (/&
&2.0695E+01_JPRB,1.5610E+01_JPRB,1.0717E+01_JPRB,9.5036E+00_JPRB,1.0836E+01_JPRB/)
KBO( :, 1,18,14) = (/&
&7.2317E+00_JPRB,5.7331E+00_JPRB,7.5895E+00_JPRB,1.0388E+01_JPRB,1.3283E+01_JPRB/)
KBO( :, 2,18,14) = (/&
&1.0272E+01_JPRB,7.8128E+00_JPRB,8.0485E+00_JPRB,1.0408E+01_JPRB,1.2989E+01_JPRB/)
KBO( :, 3,18,14) = (/&
&1.3865E+01_JPRB,1.0490E+01_JPRB,8.8399E+00_JPRB,1.0411E+01_JPRB,1.2668E+01_JPRB/)
KBO( :, 4,18,14) = (/&
&1.8001E+01_JPRB,1.3591E+01_JPRB,1.0044E+01_JPRB,1.0415E+01_JPRB,1.2336E+01_JPRB/)
KBO( :, 5,18,14) = (/&
&2.2607E+01_JPRB,1.7043E+01_JPRB,1.1818E+01_JPRB,1.0584E+01_JPRB,1.2000E+01_JPRB/)
KBO( :, 1,19,14) = (/&
&7.9818E+00_JPRB,6.4241E+00_JPRB,8.4744E+00_JPRB,1.1590E+01_JPRB,1.4808E+01_JPRB/)
KBO( :, 2,19,14) = (/&
&1.1265E+01_JPRB,8.5751E+00_JPRB,9.0608E+00_JPRB,1.1546E+01_JPRB,1.4436E+01_JPRB/)
KBO( :, 3,19,14) = (/&
&1.5159E+01_JPRB,1.1457E+01_JPRB,9.8998E+00_JPRB,1.1494E+01_JPRB,1.4048E+01_JPRB/)
KBO( :, 4,19,14) = (/&
&1.9623E+01_JPRB,1.4803E+01_JPRB,1.1193E+01_JPRB,1.1515E+01_JPRB,1.3659E+01_JPRB/)
KBO( :, 5,19,14) = (/&
&2.4552E+01_JPRB,1.8498E+01_JPRB,1.3028E+01_JPRB,1.1768E+01_JPRB,1.3289E+01_JPRB/)
KBO( :, 1,20,14) = (/&
&8.8016E+00_JPRB,7.2179E+00_JPRB,9.4445E+00_JPRB,1.2859E+01_JPRB,1.6432E+01_JPRB/)
KBO( :, 2,20,14) = (/&
&1.2354E+01_JPRB,9.4599E+00_JPRB,1.0108E+01_JPRB,1.2760E+01_JPRB,1.5989E+01_JPRB/)
KBO( :, 3,20,14) = (/&
&1.6553E+01_JPRB,1.2501E+01_JPRB,1.1094E+01_JPRB,1.2659E+01_JPRB,1.5545E+01_JPRB/)
KBO( :, 4,20,14) = (/&
&2.1320E+01_JPRB,1.6075E+01_JPRB,1.2479E+01_JPRB,1.2712E+01_JPRB,1.5125E+01_JPRB/)
KBO( :, 5,20,14) = (/&
&2.6584E+01_JPRB,2.0023E+01_JPRB,1.4364E+01_JPRB,1.3028E+01_JPRB,1.4722E+01_JPRB/)
KBO( :, 1,21,14) = (/&
&9.6531E+00_JPRB,8.0964E+00_JPRB,1.0501E+01_JPRB,1.4235E+01_JPRB,1.8234E+01_JPRB/)
KBO( :, 2,21,14) = (/&
&1.3477E+01_JPRB,1.0427E+01_JPRB,1.1223E+01_JPRB,1.4069E+01_JPRB,1.7720E+01_JPRB/)
KBO( :, 3,21,14) = (/&
&1.7944E+01_JPRB,1.3555E+01_JPRB,1.2376E+01_JPRB,1.3942E+01_JPRB,1.7224E+01_JPRB/)
KBO( :, 4,21,14) = (/&
&2.3006E+01_JPRB,1.7340E+01_JPRB,1.3886E+01_JPRB,1.4053E+01_JPRB,1.6755E+01_JPRB/)
KBO( :, 5,21,14) = (/&
&2.8574E+01_JPRB,2.1516E+01_JPRB,1.5811E+01_JPRB,1.4416E+01_JPRB,1.6302E+01_JPRB/)
KBO( :, 1,22,14) = (/&
&1.0760E+01_JPRB,9.1888E+00_JPRB,1.1695E+01_JPRB,1.5745E+01_JPRB,2.0205E+01_JPRB/)
KBO( :, 2,22,14) = (/&
&1.4853E+01_JPRB,1.1640E+01_JPRB,1.2517E+01_JPRB,1.5515E+01_JPRB,1.9617E+01_JPRB/)
KBO( :, 3,22,14) = (/&
&1.9615E+01_JPRB,1.4884E+01_JPRB,1.3822E+01_JPRB,1.5397E+01_JPRB,1.9064E+01_JPRB/)
KBO( :, 4,22,14) = (/&
&2.4968E+01_JPRB,1.8810E+01_JPRB,1.5484E+01_JPRB,1.5561E+01_JPRB,1.8540E+01_JPRB/)
KBO( :, 5,22,14) = (/&
&3.0827E+01_JPRB,2.3206E+01_JPRB,1.7456E+01_JPRB,1.5921E+01_JPRB,1.8033E+01_JPRB/)
KBO( :, 1,23,14) = (/&
&1.1802E+01_JPRB,1.0322E+01_JPRB,1.2998E+01_JPRB,1.7421E+01_JPRB,2.2401E+01_JPRB/)
KBO( :, 2,23,14) = (/&
&1.6133E+01_JPRB,1.2850E+01_JPRB,1.3921E+01_JPRB,1.7123E+01_JPRB,2.1737E+01_JPRB/)
KBO( :, 3,23,14) = (/&
&2.1125E+01_JPRB,1.6165E+01_JPRB,1.5339E+01_JPRB,1.7031E+01_JPRB,2.1100E+01_JPRB/)
KBO( :, 4,23,14) = (/&
&2.6726E+01_JPRB,2.0157E+01_JPRB,1.7101E+01_JPRB,1.7209E+01_JPRB,2.0484E+01_JPRB/)
KBO( :, 5,23,14) = (/&
&3.2827E+01_JPRB,2.4712E+01_JPRB,1.9081E+01_JPRB,1.7519E+01_JPRB,1.9884E+01_JPRB/)
KBO( :, 1,24,14) = (/&
&1.2745E+01_JPRB,1.1442E+01_JPRB,1.4445E+01_JPRB,1.9244E+01_JPRB,2.4809E+01_JPRB/)
KBO( :, 2,24,14) = (/&
&1.7253E+01_JPRB,1.4016E+01_JPRB,1.5441E+01_JPRB,1.8901E+01_JPRB,2.4045E+01_JPRB/)
KBO( :, 3,24,14) = (/&
&2.2449E+01_JPRB,1.7365E+01_JPRB,1.6912E+01_JPRB,1.8816E+01_JPRB,2.3295E+01_JPRB/)
KBO( :, 4,24,14) = (/&
&2.8233E+01_JPRB,2.1395E+01_JPRB,1.8672E+01_JPRB,1.8934E+01_JPRB,2.2558E+01_JPRB/)
KBO( :, 5,24,14) = (/&
&3.4560E+01_JPRB,2.6021E+01_JPRB,2.0658E+01_JPRB,1.9202E+01_JPRB,2.1836E+01_JPRB/)
KBO( :, 1,25,14) = (/&
&1.3566E+01_JPRB,1.2543E+01_JPRB,1.5996E+01_JPRB,2.1177E+01_JPRB,2.7336E+01_JPRB/)
KBO( :, 2,25,14) = (/&
&1.8227E+01_JPRB,1.5135E+01_JPRB,1.7035E+01_JPRB,2.0783E+01_JPRB,2.6441E+01_JPRB/)
KBO( :, 3,25,14) = (/&
&2.3565E+01_JPRB,1.8483E+01_JPRB,1.8488E+01_JPRB,2.0675E+01_JPRB,2.5549E+01_JPRB/)
KBO( :, 4,25,14) = (/&
&2.9531E+01_JPRB,2.2535E+01_JPRB,2.0204E+01_JPRB,2.0688E+01_JPRB,2.4667E+01_JPRB/)
KBO( :, 5,25,14) = (/&
&3.6063E+01_JPRB,2.7206E+01_JPRB,2.2162E+01_JPRB,2.0908E+01_JPRB,2.3805E+01_JPRB/)
KBO( :, 1,26,14) = (/&
&1.4327E+01_JPRB,1.3631E+01_JPRB,1.7595E+01_JPRB,2.3118E+01_JPRB,2.9859E+01_JPRB/)
KBO( :, 2,26,14) = (/&
&1.9108E+01_JPRB,1.6210E+01_JPRB,1.8663E+01_JPRB,2.2706E+01_JPRB,2.8803E+01_JPRB/)
KBO( :, 3,26,14) = (/&
&2.4589E+01_JPRB,1.9567E+01_JPRB,2.0048E+01_JPRB,2.2494E+01_JPRB,2.7746E+01_JPRB/)
KBO( :, 4,26,14) = (/&
&3.0710E+01_JPRB,2.3631E+01_JPRB,2.1693E+01_JPRB,2.2407E+01_JPRB,2.6705E+01_JPRB/)
KBO( :, 5,26,14) = (/&
&3.7411E+01_JPRB,2.8326E+01_JPRB,2.3613E+01_JPRB,2.2582E+01_JPRB,2.5687E+01_JPRB/)
KBO( :, 1,27,14) = (/&
&1.4974E+01_JPRB,1.4661E+01_JPRB,1.9208E+01_JPRB,2.5017E+01_JPRB,3.2282E+01_JPRB/)
KBO( :, 2,27,14) = (/&
&1.9864E+01_JPRB,1.7209E+01_JPRB,2.0231E+01_JPRB,2.4566E+01_JPRB,3.1037E+01_JPRB/)
KBO( :, 3,27,14) = (/&
&2.5463E+01_JPRB,2.0563E+01_JPRB,2.1528E+01_JPRB,2.4213E+01_JPRB,2.9805E+01_JPRB/)
KBO( :, 4,27,14) = (/&
&3.1732E+01_JPRB,2.4635E+01_JPRB,2.3113E+01_JPRB,2.4054E+01_JPRB,2.8597E+01_JPRB/)
KBO( :, 5,27,14) = (/&
&3.8595E+01_JPRB,2.9368E+01_JPRB,2.4984E+01_JPRB,2.4188E+01_JPRB,2.7415E+01_JPRB/)
KBO( :, 1,28,14) = (/&
&1.5529E+01_JPRB,1.5623E+01_JPRB,2.0763E+01_JPRB,2.6821E+01_JPRB,3.4499E+01_JPRB/)
KBO( :, 2,28,14) = (/&
&2.0516E+01_JPRB,1.8143E+01_JPRB,2.1720E+01_JPRB,2.6283E+01_JPRB,3.3057E+01_JPRB/)
KBO( :, 3,28,14) = (/&
&2.6237E+01_JPRB,2.1495E+01_JPRB,2.2921E+01_JPRB,2.5811E+01_JPRB,3.1645E+01_JPRB/)
KBO( :, 4,28,14) = (/&
&3.2647E+01_JPRB,2.5586E+01_JPRB,2.4438E+01_JPRB,2.5592E+01_JPRB,3.0274E+01_JPRB/)
KBO( :, 5,28,14) = (/&
&3.9662E+01_JPRB,3.0339E+01_JPRB,2.6263E+01_JPRB,2.5678E+01_JPRB,2.8942E+01_JPRB/)
KBO( :, 1,29,14) = (/&
&1.6065E+01_JPRB,1.6544E+01_JPRB,2.2216E+01_JPRB,2.8472E+01_JPRB,3.6458E+01_JPRB/)
KBO( :, 2,29,14) = (/&
&2.1153E+01_JPRB,1.9041E+01_JPRB,2.3104E+01_JPRB,2.7817E+01_JPRB,3.4827E+01_JPRB/)
KBO( :, 3,29,14) = (/&
&2.7000E+01_JPRB,2.2394E+01_JPRB,2.4221E+01_JPRB,2.7267E+01_JPRB,3.3240E+01_JPRB/)
KBO( :, 4,29,14) = (/&
&3.3548E+01_JPRB,2.6519E+01_JPRB,2.5679E+01_JPRB,2.7001E+01_JPRB,3.1702E+01_JPRB/)
KBO( :, 5,29,14) = (/&
&4.0738E+01_JPRB,3.1323E+01_JPRB,2.7457E+01_JPRB,2.7031E+01_JPRB,3.0226E+01_JPRB/)
KBO( :, 1,30,14) = (/&
&1.6583E+01_JPRB,1.7406E+01_JPRB,2.3544E+01_JPRB,2.9947E+01_JPRB,3.8146E+01_JPRB/)
KBO( :, 2,30,14) = (/&
&2.1792E+01_JPRB,1.9899E+01_JPRB,2.4353E+01_JPRB,2.9156E+01_JPRB,3.6330E+01_JPRB/)
KBO( :, 3,30,14) = (/&
&2.7775E+01_JPRB,2.3269E+01_JPRB,2.5405E+01_JPRB,2.8560E+01_JPRB,3.4577E+01_JPRB/)
KBO( :, 4,30,14) = (/&
&3.4468E+01_JPRB,2.7442E+01_JPRB,2.6816E+01_JPRB,2.8255E+01_JPRB,3.2901E+01_JPRB/)
KBO( :, 5,30,14) = (/&
&4.1847E+01_JPRB,3.2326E+01_JPRB,2.8565E+01_JPRB,2.8235E+01_JPRB,3.1294E+01_JPRB/)
KBO( :, 1,31,14) = (/&
&1.7141E+01_JPRB,1.8216E+01_JPRB,2.4732E+01_JPRB,3.1198E+01_JPRB,3.9531E+01_JPRB/)
KBO( :, 2,31,14) = (/&
&2.2491E+01_JPRB,2.0743E+01_JPRB,2.5474E+01_JPRB,3.0318E+01_JPRB,3.7553E+01_JPRB/)
KBO( :, 3,31,14) = (/&
&2.8624E+01_JPRB,2.4158E+01_JPRB,2.6485E+01_JPRB,2.9690E+01_JPRB,3.5656E+01_JPRB/)
KBO( :, 4,31,14) = (/&
&3.5512E+01_JPRB,2.8414E+01_JPRB,2.7854E+01_JPRB,2.9357E+01_JPRB,3.3855E+01_JPRB/)
KBO( :, 5,31,14) = (/&
&4.3115E+01_JPRB,3.3401E+01_JPRB,2.9611E+01_JPRB,2.9290E+01_JPRB,3.2132E+01_JPRB/)
KBO( :, 1,32,14) = (/&
&1.7775E+01_JPRB,1.8991E+01_JPRB,2.5780E+01_JPRB,3.2231E+01_JPRB,4.0629E+01_JPRB/)
KBO( :, 2,32,14) = (/&
&2.3279E+01_JPRB,2.1576E+01_JPRB,2.6467E+01_JPRB,3.1293E+01_JPRB,3.8513E+01_JPRB/)
KBO( :, 3,32,14) = (/&
&2.9596E+01_JPRB,2.5078E+01_JPRB,2.7453E+01_JPRB,3.0651E+01_JPRB,3.6492E+01_JPRB/)
KBO( :, 4,32,14) = (/&
&3.6705E+01_JPRB,2.9433E+01_JPRB,2.8819E+01_JPRB,3.0298E+01_JPRB,3.4575E+01_JPRB/)
KBO( :, 5,32,14) = (/&
&4.4536E+01_JPRB,3.4534E+01_JPRB,3.0584E+01_JPRB,3.0174E+01_JPRB,3.2756E+01_JPRB/)
KBO( :, 1,33,14) = (/&
&1.8489E+01_JPRB,1.9733E+01_JPRB,2.6684E+01_JPRB,3.3047E+01_JPRB,4.1445E+01_JPRB/)
KBO( :, 2,33,14) = (/&
&2.4189E+01_JPRB,2.2424E+01_JPRB,2.7346E+01_JPRB,3.2099E+01_JPRB,3.9209E+01_JPRB/)
KBO( :, 3,33,14) = (/&
&3.0723E+01_JPRB,2.6034E+01_JPRB,2.8320E+01_JPRB,3.1451E+01_JPRB,3.7092E+01_JPRB/)
KBO( :, 4,33,14) = (/&
&3.8063E+01_JPRB,3.0513E+01_JPRB,2.9704E+01_JPRB,3.1070E+01_JPRB,3.5085E+01_JPRB/)
KBO( :, 5,33,14) = (/&
&4.6119E+01_JPRB,3.5751E+01_JPRB,3.1499E+01_JPRB,3.0917E+01_JPRB,3.3191E+01_JPRB/)
KBO( :, 1,34,14) = (/&
&1.9120E+01_JPRB,2.0380E+01_JPRB,2.7451E+01_JPRB,3.3738E+01_JPRB,4.2092E+01_JPRB/)
KBO( :, 2,34,14) = (/&
&2.5003E+01_JPRB,2.3162E+01_JPRB,2.8086E+01_JPRB,3.2774E+01_JPRB,3.9759E+01_JPRB/)
KBO( :, 3,34,14) = (/&
&3.1744E+01_JPRB,2.6883E+01_JPRB,2.9061E+01_JPRB,3.2120E+01_JPRB,3.7559E+01_JPRB/)
KBO( :, 4,34,14) = (/&
&3.9301E+01_JPRB,3.1483E+01_JPRB,3.0464E+01_JPRB,3.1710E+01_JPRB,3.5480E+01_JPRB/)
KBO( :, 5,34,14) = (/&
&4.7562E+01_JPRB,3.6856E+01_JPRB,3.2292E+01_JPRB,3.1536E+01_JPRB,3.3568E+01_JPRB/)
KBO( :, 1,35,14) = (/&
&1.9330E+01_JPRB,2.0794E+01_JPRB,2.8053E+01_JPRB,3.4390E+01_JPRB,4.2763E+01_JPRB/)
KBO( :, 2,35,14) = (/&
&2.5319E+01_JPRB,2.3595E+01_JPRB,2.8656E+01_JPRB,3.3397E+01_JPRB,4.0342E+01_JPRB/)
KBO( :, 3,35,14) = (/&
&3.2191E+01_JPRB,2.7358E+01_JPRB,2.9608E+01_JPRB,3.2717E+01_JPRB,3.8062E+01_JPRB/)
KBO( :, 4,35,14) = (/&
&3.9886E+01_JPRB,3.2011E+01_JPRB,3.1003E+01_JPRB,3.2263E+01_JPRB,3.5938E+01_JPRB/)
KBO( :, 5,35,14) = (/&
&4.8294E+01_JPRB,3.7467E+01_JPRB,3.2840E+01_JPRB,3.2051E+01_JPRB,3.4008E+01_JPRB/)
KBO( :, 1,36,14) = (/&
&1.9010E+01_JPRB,2.0941E+01_JPRB,2.8519E+01_JPRB,3.5044E+01_JPRB,4.3548E+01_JPRB/)
KBO( :, 2,36,14) = (/&
&2.5019E+01_JPRB,2.3674E+01_JPRB,2.9070E+01_JPRB,3.3996E+01_JPRB,4.1038E+01_JPRB/)
KBO( :, 3,36,14) = (/&
&3.1927E+01_JPRB,2.7395E+01_JPRB,2.9968E+01_JPRB,3.3265E+01_JPRB,3.8679E+01_JPRB/)
KBO( :, 4,36,14) = (/&
&3.9672E+01_JPRB,3.2015E+01_JPRB,3.1322E+01_JPRB,3.2758E+01_JPRB,3.6525E+01_JPRB/)
KBO( :, 5,36,14) = (/&
&4.8151E+01_JPRB,3.7481E+01_JPRB,3.3115E+01_JPRB,3.2494E+01_JPRB,3.4530E+01_JPRB/)
KBO( :, 1,37,14) = (/&
&1.7926E+01_JPRB,2.0769E+01_JPRB,2.8871E+01_JPRB,3.5793E+01_JPRB,4.4612E+01_JPRB/)
KBO( :, 2,37,14) = (/&
&2.3809E+01_JPRB,2.3285E+01_JPRB,2.9325E+01_JPRB,3.4640E+01_JPRB,4.1997E+01_JPRB/)
KBO( :, 3,37,14) = (/&
&3.0620E+01_JPRB,2.6825E+01_JPRB,3.0118E+01_JPRB,3.3823E+01_JPRB,3.9558E+01_JPRB/)
KBO( :, 4,37,14) = (/&
&3.8296E+01_JPRB,3.1288E+01_JPRB,3.1366E+01_JPRB,3.3235E+01_JPRB,3.7337E+01_JPRB/)
KBO( :, 5,37,14) = (/&
&4.6724E+01_JPRB,3.6634E+01_JPRB,3.3044E+01_JPRB,3.2894E+01_JPRB,3.5259E+01_JPRB/)
KBO( :, 1,38,14) = (/&
&1.6878E+01_JPRB,2.0610E+01_JPRB,2.9172E+01_JPRB,3.6472E+01_JPRB,4.5609E+01_JPRB/)
KBO( :, 2,38,14) = (/&
&2.2623E+01_JPRB,2.2907E+01_JPRB,2.9536E+01_JPRB,3.5227E+01_JPRB,4.2904E+01_JPRB/)
KBO( :, 3,38,14) = (/&
&2.9321E+01_JPRB,2.6260E+01_JPRB,3.0234E+01_JPRB,3.4327E+01_JPRB,4.0395E+01_JPRB/)
KBO( :, 4,38,14) = (/&
&3.6903E+01_JPRB,3.0559E+01_JPRB,3.1375E+01_JPRB,3.3664E+01_JPRB,3.8108E+01_JPRB/)
KBO( :, 5,38,14) = (/&
&4.5262E+01_JPRB,3.5766E+01_JPRB,3.2950E+01_JPRB,3.3255E+01_JPRB,3.5951E+01_JPRB/)
KBO( :, 1,39,14) = (/&
&1.5902E+01_JPRB,2.0474E+01_JPRB,2.9440E+01_JPRB,3.7085E+01_JPRB,4.6521E+01_JPRB/)
KBO( :, 2,39,14) = (/&
&2.1511E+01_JPRB,2.2570E+01_JPRB,2.9719E+01_JPRB,3.5757E+01_JPRB,4.3739E+01_JPRB/)
KBO( :, 3,39,14) = (/&
&2.8094E+01_JPRB,2.5734E+01_JPRB,3.0328E+01_JPRB,3.4778E+01_JPRB,4.1182E+01_JPRB/)
KBO( :, 4,39,14) = (/&
&3.5578E+01_JPRB,2.9877E+01_JPRB,3.1374E+01_JPRB,3.4050E+01_JPRB,3.8820E+01_JPRB/)
KBO( :, 5,39,14) = (/&
&4.3862E+01_JPRB,3.4943E+01_JPRB,3.2862E+01_JPRB,3.3572E+01_JPRB,3.6607E+01_JPRB/)
KBO( :, 1,40,14) = (/&
&1.4487E+01_JPRB,2.0210E+01_JPRB,2.9678E+01_JPRB,3.7814E+01_JPRB,4.7667E+01_JPRB/)
KBO( :, 2,40,14) = (/&
&1.9857E+01_JPRB,2.2013E+01_JPRB,2.9846E+01_JPRB,3.6374E+01_JPRB,4.4798E+01_JPRB/)
KBO( :, 3,40,14) = (/&
&2.6217E+01_JPRB,2.4887E+01_JPRB,3.0342E+01_JPRB,3.5275E+01_JPRB,4.2152E+01_JPRB/)
KBO( :, 4,40,14) = (/&
&3.3508E+01_JPRB,2.8778E+01_JPRB,3.1239E+01_JPRB,3.4477E+01_JPRB,3.9718E+01_JPRB/)
KBO( :, 5,40,14) = (/&
&4.1627E+01_JPRB,3.3601E+01_JPRB,3.2609E+01_JPRB,3.3904E+01_JPRB,3.7435E+01_JPRB/)
KBO( :, 1,41,14) = (/&
&1.3110E+01_JPRB,1.9958E+01_JPRB,2.9912E+01_JPRB,3.8549E+01_JPRB,4.8809E+01_JPRB/)
KBO( :, 2,41,14) = (/&
&1.8221E+01_JPRB,2.1507E+01_JPRB,2.9962E+01_JPRB,3.6988E+01_JPRB,4.5856E+01_JPRB/)
KBO( :, 3,41,14) = (/&
&2.4334E+01_JPRB,2.4070E+01_JPRB,3.0356E+01_JPRB,3.5769E+01_JPRB,4.3126E+01_JPRB/)
KBO( :, 4,41,14) = (/&
&3.1415E+01_JPRB,2.7692E+01_JPRB,3.1100E+01_JPRB,3.4894E+01_JPRB,4.0627E+01_JPRB/)
KBO( :, 5,41,14) = (/&
&3.9350E+01_JPRB,3.2265E+01_JPRB,3.2344E+01_JPRB,3.4220E+01_JPRB,3.8269E+01_JPRB/)
KBO( :, 1,42,14) = (/&
&1.1835E+01_JPRB,1.9752E+01_JPRB,3.0145E+01_JPRB,3.9251E+01_JPRB,4.9910E+01_JPRB/)
KBO( :, 2,42,14) = (/&
&1.6674E+01_JPRB,2.1083E+01_JPRB,3.0080E+01_JPRB,3.7587E+01_JPRB,4.6885E+01_JPRB/)
KBO( :, 3,42,14) = (/&
&2.2540E+01_JPRB,2.3336E+01_JPRB,3.0367E+01_JPRB,3.6256E+01_JPRB,4.4084E+01_JPRB/)
KBO( :, 4,42,14) = (/&
&2.9380E+01_JPRB,2.6668E+01_JPRB,3.0980E+01_JPRB,3.5287E+01_JPRB,4.1523E+01_JPRB/)
KBO( :, 5,42,14) = (/&
&3.7130E+01_JPRB,3.0990E+01_JPRB,3.2078E+01_JPRB,3.4533E+01_JPRB,3.9096E+01_JPRB/)
KBO( :, 1,43,14) = (/&
&1.0424E+01_JPRB,1.9517E+01_JPRB,3.0390E+01_JPRB,4.0028E+01_JPRB,5.1165E+01_JPRB/)
KBO( :, 2,43,14) = (/&
&1.4940E+01_JPRB,2.0651E+01_JPRB,3.0207E+01_JPRB,3.8268E+01_JPRB,4.8059E+01_JPRB/)
KBO( :, 3,43,14) = (/&
&2.0485E+01_JPRB,2.2541E+01_JPRB,3.0363E+01_JPRB,3.6818E+01_JPRB,4.5176E+01_JPRB/)
KBO( :, 4,43,14) = (/&
&2.7034E+01_JPRB,2.5521E+01_JPRB,3.0853E+01_JPRB,3.5715E+01_JPRB,4.2549E+01_JPRB/)
KBO( :, 5,43,14) = (/&
&3.4521E+01_JPRB,2.9529E+01_JPRB,3.1770E+01_JPRB,3.4894E+01_JPRB,4.0051E+01_JPRB/)
KBO( :, 1,44,14) = (/&
&9.0454E+00_JPRB,1.9303E+01_JPRB,3.0654E+01_JPRB,4.0829E+01_JPRB,5.2486E+01_JPRB/)
KBO( :, 2,44,14) = (/&
&1.3210E+01_JPRB,2.0258E+01_JPRB,3.0364E+01_JPRB,3.9018E+01_JPRB,4.9303E+01_JPRB/)
KBO( :, 3,44,14) = (/&
&1.8410E+01_JPRB,2.1811E+01_JPRB,3.0377E+01_JPRB,3.7427E+01_JPRB,4.6338E+01_JPRB/)
KBO( :, 4,44,14) = (/&
&2.4625E+01_JPRB,2.4403E+01_JPRB,3.0751E+01_JPRB,3.6187E+01_JPRB,4.3644E+01_JPRB/)
KBO( :, 5,44,14) = (/&
&3.1810E+01_JPRB,2.8069E+01_JPRB,3.1486E+01_JPRB,3.5287E+01_JPRB,4.1079E+01_JPRB/)
KBO( :, 1,45,14) = (/&
&7.7991E+00_JPRB,1.9124E+01_JPRB,3.0912E+01_JPRB,4.1626E+01_JPRB,5.3793E+01_JPRB/)
KBO( :, 2,45,14) = (/&
&1.1620E+01_JPRB,1.9930E+01_JPRB,3.0535E+01_JPRB,3.9772E+01_JPRB,5.0542E+01_JPRB/)
KBO( :, 3,45,14) = (/&
&1.6462E+01_JPRB,2.1220E+01_JPRB,3.0424E+01_JPRB,3.8053E+01_JPRB,4.7507E+01_JPRB/)
KBO( :, 4,45,14) = (/&
&2.2340E+01_JPRB,2.3424E+01_JPRB,3.0669E+01_JPRB,3.6679E+01_JPRB,4.4753E+01_JPRB/)
KBO( :, 5,45,14) = (/&
&2.9206E+01_JPRB,2.6717E+01_JPRB,3.1243E+01_JPRB,3.5671E+01_JPRB,4.2118E+01_JPRB/)
KBO( :, 1,46,14) = (/&
&6.6114E+00_JPRB,1.8975E+01_JPRB,3.1192E+01_JPRB,4.2505E+01_JPRB,5.5177E+01_JPRB/)
KBO( :, 2,46,14) = (/&
&1.0078E+01_JPRB,1.9636E+01_JPRB,3.0742E+01_JPRB,4.0557E+01_JPRB,5.1854E+01_JPRB/)
KBO( :, 3,46,14) = (/&
&1.4541E+01_JPRB,2.0717E+01_JPRB,3.0510E+01_JPRB,3.8745E+01_JPRB,4.8748E+01_JPRB/)
KBO( :, 4,46,14) = (/&
&2.0050E+01_JPRB,2.2518E+01_JPRB,3.0610E+01_JPRB,3.7236E+01_JPRB,4.5932E+01_JPRB/)
KBO( :, 5,46,14) = (/&
&2.6570E+01_JPRB,2.5413E+01_JPRB,3.1056E+01_JPRB,3.6085E+01_JPRB,4.3222E+01_JPRB/)
KBO( :, 1,47,14) = (/&
&5.4426E+00_JPRB,1.8843E+01_JPRB,3.1468E+01_JPRB,4.3504E+01_JPRB,5.6708E+01_JPRB/)
KBO( :, 2,47,14) = (/&
&8.5243E+00_JPRB,1.9360E+01_JPRB,3.0989E+01_JPRB,4.1408E+01_JPRB,5.3314E+01_JPRB/)
KBO( :, 3,47,14) = (/&
&1.2575E+01_JPRB,2.0245E+01_JPRB,3.0638E+01_JPRB,3.9555E+01_JPRB,5.0119E+01_JPRB/)
KBO( :, 4,47,14) = (/&
&1.7661E+01_JPRB,2.1683E+01_JPRB,3.0580E+01_JPRB,3.7894E+01_JPRB,4.7238E+01_JPRB/)
KBO( :, 5,47,14) = (/&
&2.3779E+01_JPRB,2.4127E+01_JPRB,3.0897E+01_JPRB,3.6585E+01_JPRB,4.4450E+01_JPRB/)
KBO( :, 1,48,14) = (/&
&4.4277E+00_JPRB,1.8761E+01_JPRB,3.1768E+01_JPRB,4.4555E+01_JPRB,5.8239E+01_JPRB/)
KBO( :, 2,48,14) = (/&
&7.1412E+00_JPRB,1.9151E+01_JPRB,3.1244E+01_JPRB,4.2299E+01_JPRB,5.4783E+01_JPRB/)
KBO( :, 3,48,14) = (/&
&1.0789E+01_JPRB,1.9869E+01_JPRB,3.0807E+01_JPRB,4.0379E+01_JPRB,5.1522E+01_JPRB/)
KBO( :, 4,48,14) = (/&
&1.5451E+01_JPRB,2.1038E+01_JPRB,3.0616E+01_JPRB,3.8583E+01_JPRB,4.8572E+01_JPRB/)
KBO( :, 5,48,14) = (/&
&2.1160E+01_JPRB,2.3022E+01_JPRB,3.0768E+01_JPRB,3.7126E+01_JPRB,4.5703E+01_JPRB/)
KBO( :, 1,49,14) = (/&
&3.5582E+00_JPRB,1.8724E+01_JPRB,3.2110E+01_JPRB,4.5630E+01_JPRB,5.9777E+01_JPRB/)
KBO( :, 2,49,14) = (/&
&5.9176E+00_JPRB,1.8981E+01_JPRB,3.1512E+01_JPRB,4.3246E+01_JPRB,5.6279E+01_JPRB/)
KBO( :, 3,49,14) = (/&
&9.1765E+00_JPRB,1.9555E+01_JPRB,3.1023E+01_JPRB,4.1205E+01_JPRB,5.2968E+01_JPRB/)
KBO( :, 4,49,14) = (/&
&1.3419E+01_JPRB,2.0517E+01_JPRB,3.0706E+01_JPRB,3.9341E+01_JPRB,4.9951E+01_JPRB/)
KBO( :, 5,49,14) = (/&
&1.8709E+01_JPRB,2.2099E+01_JPRB,3.0706E+01_JPRB,3.7732E+01_JPRB,4.7001E+01_JPRB/)
KBO( :, 1,50,14) = (/&
&2.8621E+00_JPRB,1.8722E+01_JPRB,3.2476E+01_JPRB,4.6653E+01_JPRB,6.1210E+01_JPRB/)
KBO( :, 2,50,14) = (/&
&4.9088E+00_JPRB,1.8875E+01_JPRB,3.1754E+01_JPRB,4.4175E+01_JPRB,5.7683E+01_JPRB/)
KBO( :, 3,50,14) = (/&
&7.8135E+00_JPRB,1.9320E+01_JPRB,3.1237E+01_JPRB,4.1987E+01_JPRB,5.4314E+01_JPRB/)
KBO( :, 4,50,14) = (/&
&1.1676E+01_JPRB,2.0117E+01_JPRB,3.0830E+01_JPRB,4.0088E+01_JPRB,5.1232E+01_JPRB/)
KBO( :, 5,50,14) = (/&
&1.6567E+01_JPRB,2.1410E+01_JPRB,3.0696E+01_JPRB,3.8343E+01_JPRB,4.8212E+01_JPRB/)
KBO( :, 1,51,14) = (/&
&2.2871E+00_JPRB,1.8709E+01_JPRB,3.2860E+01_JPRB,4.7625E+01_JPRB,6.2589E+01_JPRB/)
KBO( :, 2,51,14) = (/&
&4.0542E+00_JPRB,1.8811E+01_JPRB,3.2015E+01_JPRB,4.5121E+01_JPRB,5.9058E+01_JPRB/)
KBO( :, 3,51,14) = (/&
&6.6290E+00_JPRB,1.9146E+01_JPRB,3.1467E+01_JPRB,4.2798E+01_JPRB,5.5634E+01_JPRB/)
KBO( :, 4,51,14) = (/&
&1.0131E+01_JPRB,1.9796E+01_JPRB,3.0988E+01_JPRB,4.0823E+01_JPRB,5.2469E+01_JPRB/)
KBO( :, 5,51,14) = (/&
&1.4636E+01_JPRB,2.0878E+01_JPRB,3.0739E+01_JPRB,3.8979E+01_JPRB,4.9405E+01_JPRB/)
KBO( :, 1,52,14) = (/&
&1.8042E+00_JPRB,1.8682E+01_JPRB,3.3246E+01_JPRB,4.8560E+01_JPRB,6.3938E+01_JPRB/)
KBO( :, 2,52,14) = (/&
&3.3141E+00_JPRB,1.8789E+01_JPRB,3.2326E+01_JPRB,4.6081E+01_JPRB,6.0432E+01_JPRB/)
KBO( :, 3,52,14) = (/&
&5.5749E+00_JPRB,1.9001E+01_JPRB,3.1682E+01_JPRB,4.3646E+01_JPRB,5.6974E+01_JPRB/)
KBO( :, 4,52,14) = (/&
&8.7257E+00_JPRB,1.9525E+01_JPRB,3.1181E+01_JPRB,4.1550E+01_JPRB,5.3732E+01_JPRB/)
KBO( :, 5,52,14) = (/&
&1.2856E+01_JPRB,2.0429E+01_JPRB,3.0821E+01_JPRB,3.9666E+01_JPRB,5.0627E+01_JPRB/)
KBO( :, 1,53,14) = (/&
&1.4016E+00_JPRB,1.8621E+01_JPRB,3.3678E+01_JPRB,4.9490E+01_JPRB,6.5279E+01_JPRB/)
KBO( :, 2,53,14) = (/&
&2.6762E+00_JPRB,1.8776E+01_JPRB,3.2671E+01_JPRB,4.7047E+01_JPRB,6.1804E+01_JPRB/)
KBO( :, 3,53,14) = (/&
&4.6412E+00_JPRB,1.8903E+01_JPRB,3.1912E+01_JPRB,4.4545E+01_JPRB,5.8349E+01_JPRB/)
KBO( :, 4,53,14) = (/&
&7.4512E+00_JPRB,1.9311E+01_JPRB,3.1378E+01_JPRB,4.2307E+01_JPRB,5.5036E+01_JPRB/)
KBO( :, 5,53,14) = (/&
&1.1217E+01_JPRB,2.0061E+01_JPRB,3.0940E+01_JPRB,4.0380E+01_JPRB,5.1884E+01_JPRB/)
KBO( :, 1,54,14) = (/&
&1.0961E+00_JPRB,1.8547E+01_JPRB,3.4112E+01_JPRB,5.0332E+01_JPRB,6.6490E+01_JPRB/)
KBO( :, 2,54,14) = (/&
&2.1755E+00_JPRB,1.8757E+01_JPRB,3.3015E+01_JPRB,4.7918E+01_JPRB,6.3018E+01_JPRB/)
KBO( :, 3,54,14) = (/&
&3.8890E+00_JPRB,1.8845E+01_JPRB,3.2149E+01_JPRB,4.5398E+01_JPRB,5.9550E+01_JPRB/)
KBO( :, 4,54,14) = (/&
&6.4008E+00_JPRB,1.9153E+01_JPRB,3.1582E+01_JPRB,4.3046E+01_JPRB,5.6158E+01_JPRB/)
KBO( :, 5,54,14) = (/&
&9.8389E+00_JPRB,1.9773E+01_JPRB,3.1086E+01_JPRB,4.1043E+01_JPRB,5.2991E+01_JPRB/)
KBO( :, 1,55,14) = (/&
&8.5398E-01_JPRB,1.8492E+01_JPRB,3.4545E+01_JPRB,5.1111E+01_JPRB,6.7620E+01_JPRB/)
KBO( :, 2,55,14) = (/&
&1.7643E+00_JPRB,1.8724E+01_JPRB,3.3346E+01_JPRB,4.8723E+01_JPRB,6.4160E+01_JPRB/)
KBO( :, 3,55,14) = (/&
&3.2551E+00_JPRB,1.8827E+01_JPRB,3.2415E+01_JPRB,4.6233E+01_JPRB,6.0665E+01_JPRB/)
KBO( :, 4,55,14) = (/&
&5.4933E+00_JPRB,1.9028E+01_JPRB,3.1761E+01_JPRB,4.3784E+01_JPRB,5.7216E+01_JPRB/)
KBO( :, 5,55,14) = (/&
&8.6198E+00_JPRB,1.9538E+01_JPRB,3.1251E+01_JPRB,4.1673E+01_JPRB,5.3976E+01_JPRB/)
KBO( :, 1,56,14) = (/&
&6.5583E-01_JPRB,1.8466E+01_JPRB,3.5009E+01_JPRB,5.1852E+01_JPRB,6.8713E+01_JPRB/)
KBO( :, 2,56,14) = (/&
&1.4149E+00_JPRB,1.8664E+01_JPRB,3.3714E+01_JPRB,4.9524E+01_JPRB,6.5316E+01_JPRB/)
KBO( :, 3,56,14) = (/&
&2.7001E+00_JPRB,1.8813E+01_JPRB,3.2708E+01_JPRB,4.7069E+01_JPRB,6.1791E+01_JPRB/)
KBO( :, 4,56,14) = (/&
&4.6799E+00_JPRB,1.8938E+01_JPRB,3.1954E+01_JPRB,4.4562E+01_JPRB,5.8292E+01_JPRB/)
KBO( :, 5,56,14) = (/&
&7.5092E+00_JPRB,1.9349E+01_JPRB,3.1417E+01_JPRB,4.2326E+01_JPRB,5.4949E+01_JPRB/)
KBO( :, 1,57,14) = (/&
&4.9569E-01_JPRB,1.8461E+01_JPRB,3.5476E+01_JPRB,5.2586E+01_JPRB,6.9771E+01_JPRB/)
KBO( :, 2,57,14) = (/&
&1.1207E+00_JPRB,1.8588E+01_JPRB,3.4120E+01_JPRB,5.0320E+01_JPRB,6.6462E+01_JPRB/)
KBO( :, 3,57,14) = (/&
&2.2185E+00_JPRB,1.8789E+01_JPRB,3.3026E+01_JPRB,4.7890E+01_JPRB,6.2944E+01_JPRB/)
KBO( :, 4,57,14) = (/&
&3.9561E+00_JPRB,1.8878E+01_JPRB,3.2169E+01_JPRB,4.5368E+01_JPRB,5.9404E+01_JPRB/)
KBO( :, 5,57,14) = (/&
&6.5001E+00_JPRB,1.9194E+01_JPRB,3.1605E+01_JPRB,4.3020E+01_JPRB,5.5955E+01_JPRB/)
KBO( :, 1,58,14) = (/&
&3.7410E-01_JPRB,1.8476E+01_JPRB,3.5878E+01_JPRB,5.3233E+01_JPRB,7.0727E+01_JPRB/)
KBO( :, 2,58,14) = (/&
&8.8722E-01_JPRB,1.8527E+01_JPRB,3.4515E+01_JPRB,5.1048E+01_JPRB,6.7516E+01_JPRB/)
KBO( :, 3,58,14) = (/&
&1.8232E+00_JPRB,1.8757E+01_JPRB,3.3332E+01_JPRB,4.8650E+01_JPRB,6.4043E+01_JPRB/)
KBO( :, 4,58,14) = (/&
&3.3485E+00_JPRB,1.8853E+01_JPRB,3.2410E+01_JPRB,4.6145E+01_JPRB,6.0474E+01_JPRB/)
KBO( :, 5,58,14) = (/&
&5.6308E+00_JPRB,1.9066E+01_JPRB,3.1770E+01_JPRB,4.3707E+01_JPRB,5.6952E+01_JPRB/)
KBO( :, 1,59,14) = (/&
&3.3226E-01_JPRB,1.8499E+01_JPRB,3.6042E+01_JPRB,5.3487E+01_JPRB,7.1108E+01_JPRB/)
KBO( :, 2,59,14) = (/&
&8.0465E-01_JPRB,1.8512E+01_JPRB,3.4692E+01_JPRB,5.1340E+01_JPRB,6.7946E+01_JPRB/)
KBO( :, 3,59,14) = (/&
&1.6796E+00_JPRB,1.8742E+01_JPRB,3.3465E+01_JPRB,4.8954E+01_JPRB,6.4485E+01_JPRB/)
KBO( :, 4,59,14) = (/&
&3.1244E+00_JPRB,1.8851E+01_JPRB,3.2518E+01_JPRB,4.6468E+01_JPRB,6.0924E+01_JPRB/)
KBO( :, 5,59,14) = (/&
&5.3047E+00_JPRB,1.9029E+01_JPRB,3.1839E+01_JPRB,4.3997E+01_JPRB,5.7335E+01_JPRB/)
KBO( :, 1,13,15) = (/&
&1.4736E+01_JPRB,1.1137E+01_JPRB,7.6940E+00_JPRB,7.1072E+00_JPRB,9.0794E+00_JPRB/)
KBO( :, 2,13,15) = (/&
&2.0753E+01_JPRB,1.5659E+01_JPRB,1.0572E+01_JPRB,7.4219E+00_JPRB,8.9416E+00_JPRB/)
KBO( :, 3,13,15) = (/&
&2.7810E+01_JPRB,2.0956E+01_JPRB,1.4105E+01_JPRB,8.2365E+00_JPRB,8.8640E+00_JPRB/)
KBO( :, 4,13,15) = (/&
&3.5751E+01_JPRB,2.6911E+01_JPRB,1.8075E+01_JPRB,9.6167E+00_JPRB,8.7852E+00_JPRB/)
KBO( :, 5,13,15) = (/&
&4.4392E+01_JPRB,3.3391E+01_JPRB,2.2391E+01_JPRB,1.1515E+01_JPRB,8.6750E+00_JPRB/)
KBO( :, 1,14,15) = (/&
&1.6396E+01_JPRB,1.2398E+01_JPRB,8.6531E+00_JPRB,8.0901E+00_JPRB,1.0338E+01_JPRB/)
KBO( :, 2,14,15) = (/&
&2.3021E+01_JPRB,1.7368E+01_JPRB,1.1723E+01_JPRB,8.4557E+00_JPRB,1.0225E+01_JPRB/)
KBO( :, 3,14,15) = (/&
&3.0725E+01_JPRB,2.3145E+01_JPRB,1.5568E+01_JPRB,9.3794E+00_JPRB,1.0164E+01_JPRB/)
KBO( :, 4,14,15) = (/&
&3.9405E+01_JPRB,2.9646E+01_JPRB,1.9890E+01_JPRB,1.0857E+01_JPRB,1.0076E+01_JPRB/)
KBO( :, 5,14,15) = (/&
&4.8887E+01_JPRB,3.6753E+01_JPRB,2.4621E+01_JPRB,1.2810E+01_JPRB,9.9619E+00_JPRB/)
KBO( :, 1,15,15) = (/&
&1.8108E+01_JPRB,1.3685E+01_JPRB,9.7296E+00_JPRB,9.2864E+00_JPRB,1.1891E+01_JPRB/)
KBO( :, 2,15,15) = (/&
&2.5292E+01_JPRB,1.9065E+01_JPRB,1.2925E+01_JPRB,9.7320E+00_JPRB,1.1822E+01_JPRB/)
KBO( :, 3,15,15) = (/&
&3.3657E+01_JPRB,2.5333E+01_JPRB,1.7012E+01_JPRB,1.0681E+01_JPRB,1.1765E+01_JPRB/)
KBO( :, 4,15,15) = (/&
&4.3009E+01_JPRB,3.2342E+01_JPRB,2.1677E+01_JPRB,1.2195E+01_JPRB,1.1648E+01_JPRB/)
KBO( :, 5,15,15) = (/&
&5.3119E+01_JPRB,3.9920E+01_JPRB,2.6722E+01_JPRB,1.4174E+01_JPRB,1.1512E+01_JPRB/)
KBO( :, 1,16,15) = (/&
&1.9766E+01_JPRB,1.4918E+01_JPRB,1.0847E+01_JPRB,1.0763E+01_JPRB,1.3814E+01_JPRB/)
KBO( :, 2,16,15) = (/&
&2.7468E+01_JPRB,2.0688E+01_JPRB,1.4114E+01_JPRB,1.1259E+01_JPRB,1.3757E+01_JPRB/)
KBO( :, 3,16,15) = (/&
&3.6341E+01_JPRB,2.7338E+01_JPRB,1.8370E+01_JPRB,1.2200E+01_JPRB,1.3647E+01_JPRB/)
KBO( :, 4,16,15) = (/&
&4.6268E+01_JPRB,3.4775E+01_JPRB,2.3285E+01_JPRB,1.3712E+01_JPRB,1.3493E+01_JPRB/)
KBO( :, 5,16,15) = (/&
&5.7098E+01_JPRB,4.2893E+01_JPRB,2.8688E+01_JPRB,1.5674E+01_JPRB,1.3336E+01_JPRB/)
KBO( :, 1,17,15) = (/&
&2.1283E+01_JPRB,1.6042E+01_JPRB,1.2037E+01_JPRB,1.2521E+01_JPRB,1.6103E+01_JPRB/)
KBO( :, 2,17,15) = (/&
&2.9464E+01_JPRB,2.2172E+01_JPRB,1.5299E+01_JPRB,1.3029E+01_JPRB,1.5994E+01_JPRB/)
KBO( :, 3,17,15) = (/&
&3.8948E+01_JPRB,2.9275E+01_JPRB,1.9669E+01_JPRB,1.3963E+01_JPRB,1.5820E+01_JPRB/)
KBO( :, 4,17,15) = (/&
&4.9621E+01_JPRB,3.7275E+01_JPRB,2.4936E+01_JPRB,1.5438E+01_JPRB,1.5638E+01_JPRB/)
KBO( :, 5,17,15) = (/&
&6.1258E+01_JPRB,4.5999E+01_JPRB,3.0742E+01_JPRB,1.7360E+01_JPRB,1.5449E+01_JPRB/)
KBO( :, 1,18,15) = (/&
&2.2877E+01_JPRB,1.7231E+01_JPRB,1.3375E+01_JPRB,1.4554E+01_JPRB,1.8639E+01_JPRB/)
KBO( :, 2,18,15) = (/&
&3.1639E+01_JPRB,2.3798E+01_JPRB,1.6609E+01_JPRB,1.5067E+01_JPRB,1.8464E+01_JPRB/)
KBO( :, 3,18,15) = (/&
&4.1858E+01_JPRB,3.1457E+01_JPRB,2.1141E+01_JPRB,1.5981E+01_JPRB,1.8293E+01_JPRB/)
KBO( :, 4,18,15) = (/&
&5.3342E+01_JPRB,4.0067E+01_JPRB,2.6795E+01_JPRB,1.7399E+01_JPRB,1.8084E+01_JPRB/)
KBO( :, 5,18,15) = (/&
&6.5884E+01_JPRB,4.9471E+01_JPRB,3.3060E+01_JPRB,1.9258E+01_JPRB,1.7848E+01_JPRB/)
KBO( :, 1,19,15) = (/&
&2.4623E+01_JPRB,1.8531E+01_JPRB,1.4907E+01_JPRB,1.6838E+01_JPRB,2.1462E+01_JPRB/)
KBO( :, 2,19,15) = (/&
&3.4070E+01_JPRB,2.5614E+01_JPRB,1.8084E+01_JPRB,1.7369E+01_JPRB,2.1261E+01_JPRB/)
KBO( :, 3,19,15) = (/&
&4.5079E+01_JPRB,3.3868E+01_JPRB,2.2784E+01_JPRB,1.8262E+01_JPRB,2.1046E+01_JPRB/)
KBO( :, 4,19,15) = (/&
&5.7371E+01_JPRB,4.3086E+01_JPRB,2.8804E+01_JPRB,1.9597E+01_JPRB,2.0788E+01_JPRB/)
KBO( :, 5,19,15) = (/&
&7.0794E+01_JPRB,5.3152E+01_JPRB,3.5511E+01_JPRB,2.1320E+01_JPRB,2.0472E+01_JPRB/)
KBO( :, 1,20,15) = (/&
&2.6740E+01_JPRB,2.0113E+01_JPRB,1.6687E+01_JPRB,1.9463E+01_JPRB,2.4692E+01_JPRB/)
KBO( :, 2,20,15) = (/&
&3.6896E+01_JPRB,2.7729E+01_JPRB,1.9869E+01_JPRB,1.9965E+01_JPRB,2.4417E+01_JPRB/)
KBO( :, 3,20,15) = (/&
&4.8627E+01_JPRB,3.6527E+01_JPRB,2.4686E+01_JPRB,2.0749E+01_JPRB,2.4109E+01_JPRB/)
KBO( :, 4,20,15) = (/&
&6.1800E+01_JPRB,4.6406E+01_JPRB,3.1013E+01_JPRB,2.1980E+01_JPRB,2.3749E+01_JPRB/)
KBO( :, 5,20,15) = (/&
&7.6193E+01_JPRB,5.7200E+01_JPRB,3.8207E+01_JPRB,2.3582E+01_JPRB,2.3335E+01_JPRB/)
KBO( :, 1,21,15) = (/&
&2.8977E+01_JPRB,2.1786E+01_JPRB,1.8588E+01_JPRB,2.2423E+01_JPRB,2.8316E+01_JPRB/)
KBO( :, 2,21,15) = (/&
&3.9801E+01_JPRB,2.9904E+01_JPRB,2.1842E+01_JPRB,2.2829E+01_JPRB,2.7905E+01_JPRB/)
KBO( :, 3,21,15) = (/&
&5.2367E+01_JPRB,3.9328E+01_JPRB,2.6804E+01_JPRB,2.3451E+01_JPRB,2.7467E+01_JPRB/)
KBO( :, 4,21,15) = (/&
&6.6469E+01_JPRB,4.9905E+01_JPRB,3.3345E+01_JPRB,2.4522E+01_JPRB,2.6969E+01_JPRB/)
KBO( :, 5,21,15) = (/&
&8.1848E+01_JPRB,6.1440E+01_JPRB,4.1033E+01_JPRB,2.6023E+01_JPRB,2.6435E+01_JPRB/)
KBO( :, 1,22,15) = (/&
&3.1988E+01_JPRB,2.4041E+01_JPRB,2.0812E+01_JPRB,2.5651E+01_JPRB,3.2255E+01_JPRB/)
KBO( :, 2,22,15) = (/&
&4.3721E+01_JPRB,3.2841E+01_JPRB,2.4334E+01_JPRB,2.5950E+01_JPRB,3.1687E+01_JPRB/)
KBO( :, 3,22,15) = (/&
&5.7294E+01_JPRB,4.3022E+01_JPRB,2.9561E+01_JPRB,2.6432E+01_JPRB,3.1040E+01_JPRB/)
KBO( :, 4,22,15) = (/&
&7.2474E+01_JPRB,5.4409E+01_JPRB,3.6410E+01_JPRB,2.7333E+01_JPRB,3.0338E+01_JPRB/)
KBO( :, 5,22,15) = (/&
&8.8942E+01_JPRB,6.6761E+01_JPRB,4.4583E+01_JPRB,2.8834E+01_JPRB,2.9615E+01_JPRB/)
KBO( :, 1,23,15) = (/&
&3.5516E+01_JPRB,2.6690E+01_JPRB,2.3334E+01_JPRB,2.9036E+01_JPRB,3.6353E+01_JPRB/)
KBO( :, 2,23,15) = (/&
&4.8281E+01_JPRB,3.6264E+01_JPRB,2.7127E+01_JPRB,2.9241E+01_JPRB,3.5539E+01_JPRB/)
KBO( :, 3,23,15) = (/&
&6.2902E+01_JPRB,4.7230E+01_JPRB,3.2633E+01_JPRB,2.9564E+01_JPRB,3.4668E+01_JPRB/)
KBO( :, 4,23,15) = (/&
&7.9108E+01_JPRB,5.9385E+01_JPRB,3.9793E+01_JPRB,3.0280E+01_JPRB,3.3772E+01_JPRB/)
KBO( :, 5,23,15) = (/&
&9.6701E+01_JPRB,7.2580E+01_JPRB,4.8461E+01_JPRB,3.1825E+01_JPRB,3.2859E+01_JPRB/)
KBO( :, 1,24,15) = (/&
&3.9680E+01_JPRB,2.9829E+01_JPRB,2.6160E+01_JPRB,3.2548E+01_JPRB,4.0469E+01_JPRB/)
KBO( :, 2,24,15) = (/&
&5.3468E+01_JPRB,4.0169E+01_JPRB,3.0146E+01_JPRB,3.2629E+01_JPRB,3.9411E+01_JPRB/)
KBO( :, 3,24,15) = (/&
&6.9159E+01_JPRB,5.1932E+01_JPRB,3.5957E+01_JPRB,3.2753E+01_JPRB,3.8325E+01_JPRB/)
KBO( :, 4,24,15) = (/&
&8.6552E+01_JPRB,6.4969E+01_JPRB,4.3591E+01_JPRB,3.3410E+01_JPRB,3.7213E+01_JPRB/)
KBO( :, 5,24,15) = (/&
&1.0532E+02_JPRB,7.9041E+01_JPRB,5.2783E+01_JPRB,3.4989E+01_JPRB,3.6087E+01_JPRB/)
KBO( :, 1,25,15) = (/&
&4.4432E+01_JPRB,3.3401E+01_JPRB,2.9194E+01_JPRB,3.6051E+01_JPRB,4.4622E+01_JPRB/)
KBO( :, 2,25,15) = (/&
&5.9330E+01_JPRB,4.4578E+01_JPRB,3.3433E+01_JPRB,3.6017E+01_JPRB,4.3268E+01_JPRB/)
KBO( :, 3,25,15) = (/&
&7.6262E+01_JPRB,5.7273E+01_JPRB,3.9678E+01_JPRB,3.5986E+01_JPRB,4.1914E+01_JPRB/)
KBO( :, 4,25,15) = (/&
&9.4907E+01_JPRB,7.1254E+01_JPRB,4.7861E+01_JPRB,3.6668E+01_JPRB,4.0563E+01_JPRB/)
KBO( :, 5,25,15) = (/&
&1.1490E+02_JPRB,8.6240E+01_JPRB,5.7602E+01_JPRB,3.8320E+01_JPRB,3.9224E+01_JPRB/)
KBO( :, 1,26,15) = (/&
&4.9945E+01_JPRB,3.7542E+01_JPRB,3.2485E+01_JPRB,3.9526E+01_JPRB,4.8685E+01_JPRB/)
KBO( :, 2,26,15) = (/&
&6.6132E+01_JPRB,4.9685E+01_JPRB,3.7067E+01_JPRB,3.9294E+01_JPRB,4.7029E+01_JPRB/)
KBO( :, 3,26,15) = (/&
&8.4358E+01_JPRB,6.3353E+01_JPRB,4.3878E+01_JPRB,3.9293E+01_JPRB,4.5384E+01_JPRB/)
KBO( :, 4,26,15) = (/&
&1.0419E+02_JPRB,7.8224E+01_JPRB,5.2598E+01_JPRB,4.0034E+01_JPRB,4.3769E+01_JPRB/)
KBO( :, 5,26,15) = (/&
&1.2529E+02_JPRB,9.4044E+01_JPRB,6.2813E+01_JPRB,4.1703E+01_JPRB,4.2207E+01_JPRB/)
KBO( :, 1,27,15) = (/&
&5.6070E+01_JPRB,4.2141E+01_JPRB,3.5908E+01_JPRB,4.2930E+01_JPRB,5.2613E+01_JPRB/)
KBO( :, 2,27,15) = (/&
&7.3488E+01_JPRB,5.5206E+01_JPRB,4.0960E+01_JPRB,4.2467E+01_JPRB,5.0627E+01_JPRB/)
KBO( :, 3,27,15) = (/&
&9.2902E+01_JPRB,6.9766E+01_JPRB,4.8295E+01_JPRB,4.2561E+01_JPRB,4.8685E+01_JPRB/)
KBO( :, 4,27,15) = (/&
&1.1389E+02_JPRB,8.5509E+01_JPRB,5.7519E+01_JPRB,4.3345E+01_JPRB,4.6803E+01_JPRB/)
KBO( :, 5,27,15) = (/&
&1.3609E+02_JPRB,1.0215E+02_JPRB,6.8230E+01_JPRB,4.5005E+01_JPRB,4.4998E+01_JPRB/)
KBO( :, 1,28,15) = (/&
&6.2602E+01_JPRB,4.7047E+01_JPRB,3.9407E+01_JPRB,4.6160E+01_JPRB,5.6361E+01_JPRB/)
KBO( :, 2,28,15) = (/&
&8.1239E+01_JPRB,6.1026E+01_JPRB,4.4978E+01_JPRB,4.5556E+01_JPRB,5.4022E+01_JPRB/)
KBO( :, 3,28,15) = (/&
&1.0182E+02_JPRB,7.6460E+01_JPRB,5.2849E+01_JPRB,4.5684E+01_JPRB,5.1781E+01_JPRB/)
KBO( :, 4,28,15) = (/&
&1.2390E+02_JPRB,9.3015E+01_JPRB,6.2567E+01_JPRB,4.6514E+01_JPRB,4.9625E+01_JPRB/)
KBO( :, 5,28,15) = (/&
&1.4712E+02_JPRB,1.1043E+02_JPRB,7.3749E+01_JPRB,4.8179E+01_JPRB,4.7555E+01_JPRB/)
KBO( :, 1,29,15) = (/&
&6.9623E+01_JPRB,5.2320E+01_JPRB,4.3015E+01_JPRB,4.9123E+01_JPRB,5.9729E+01_JPRB/)
KBO( :, 2,29,15) = (/&
&8.9447E+01_JPRB,6.7187E+01_JPRB,4.9134E+01_JPRB,4.8482E+01_JPRB,5.7058E+01_JPRB/)
KBO( :, 3,29,15) = (/&
&1.1112E+02_JPRB,8.3443E+01_JPRB,5.7534E+01_JPRB,4.8630E+01_JPRB,5.4527E+01_JPRB/)
KBO( :, 4,29,15) = (/&
&1.3428E+02_JPRB,1.0081E+02_JPRB,6.7748E+01_JPRB,4.9484E+01_JPRB,5.2105E+01_JPRB/)
KBO( :, 5,29,15) = (/&
&1.5845E+02_JPRB,1.1893E+02_JPRB,7.9425E+01_JPRB,5.1210E+01_JPRB,4.9788E+01_JPRB/)
KBO( :, 1,30,15) = (/&
&7.6956E+01_JPRB,5.7823E+01_JPRB,4.6660E+01_JPRB,5.1758E+01_JPRB,6.2685E+01_JPRB/)
KBO( :, 2,30,15) = (/&
&9.7902E+01_JPRB,7.3533E+01_JPRB,5.3332E+01_JPRB,5.1164E+01_JPRB,5.9706E+01_JPRB/)
KBO( :, 3,30,15) = (/&
&1.2067E+02_JPRB,9.0610E+01_JPRB,6.2274E+01_JPRB,5.1339E+01_JPRB,5.6887E+01_JPRB/)
KBO( :, 4,30,15) = (/&
&1.4481E+02_JPRB,1.0871E+02_JPRB,7.2976E+01_JPRB,5.2237E+01_JPRB,5.4217E+01_JPRB/)
KBO( :, 5,30,15) = (/&
&1.6975E+02_JPRB,1.2741E+02_JPRB,8.5081E+01_JPRB,5.4027E+01_JPRB,5.1685E+01_JPRB/)
KBO( :, 1,31,15) = (/&
&8.4668E+01_JPRB,6.3613E+01_JPRB,5.0308E+01_JPRB,5.4125E+01_JPRB,6.5163E+01_JPRB/)
KBO( :, 2,31,15) = (/&
&1.0670E+02_JPRB,8.0139E+01_JPRB,5.7571E+01_JPRB,5.3567E+01_JPRB,6.1881E+01_JPRB/)
KBO( :, 3,31,15) = (/&
&1.3043E+02_JPRB,9.7932E+01_JPRB,6.7030E+01_JPRB,5.3784E+01_JPRB,5.8816E+01_JPRB/)
KBO( :, 4,31,15) = (/&
&1.5531E+02_JPRB,1.1659E+02_JPRB,7.8195E+01_JPRB,5.4732E+01_JPRB,5.5925E+01_JPRB/)
KBO( :, 5,31,15) = (/&
&1.8083E+02_JPRB,1.3573E+02_JPRB,9.0627E+01_JPRB,5.6617E+01_JPRB,5.3201E+01_JPRB/)
KBO( :, 1,32,15) = (/&
&9.2652E+01_JPRB,6.9602E+01_JPRB,5.3950E+01_JPRB,5.6194E+01_JPRB,6.7147E+01_JPRB/)
KBO( :, 2,32,15) = (/&
&1.1562E+02_JPRB,8.6827E+01_JPRB,6.1761E+01_JPRB,5.5696E+01_JPRB,6.3605E+01_JPRB/)
KBO( :, 3,32,15) = (/&
&1.4016E+02_JPRB,1.0523E+02_JPRB,7.1723E+01_JPRB,5.5956E+01_JPRB,6.0313E+01_JPRB/)
KBO( :, 4,32,15) = (/&
&1.6571E+02_JPRB,1.2439E+02_JPRB,8.3322E+01_JPRB,5.6967E+01_JPRB,5.7235E+01_JPRB/)
KBO( :, 5,32,15) = (/&
&1.9180E+02_JPRB,1.4395E+02_JPRB,9.6112E+01_JPRB,5.9039E+01_JPRB,5.4359E+01_JPRB/)
KBO( :, 1,33,15) = (/&
&1.0072E+02_JPRB,7.5656E+01_JPRB,5.7525E+01_JPRB,5.7981E+01_JPRB,6.8650E+01_JPRB/)
KBO( :, 2,33,15) = (/&
&1.2455E+02_JPRB,9.3526E+01_JPRB,6.5887E+01_JPRB,5.7530E+01_JPRB,6.4898E+01_JPRB/)
KBO( :, 3,33,15) = (/&
&1.4981E+02_JPRB,1.1247E+02_JPRB,7.6362E+01_JPRB,5.7872E+01_JPRB,6.1421E+01_JPRB/)
KBO( :, 4,33,15) = (/&
&1.7592E+02_JPRB,1.3205E+02_JPRB,8.8345E+01_JPRB,5.9018E+01_JPRB,5.8197E+01_JPRB/)
KBO( :, 5,33,15) = (/&
&2.0244E+02_JPRB,1.5193E+02_JPRB,1.0144E+02_JPRB,6.1255E+01_JPRB,5.5191E+01_JPRB/)
KBO( :, 1,34,15) = (/&
&1.0805E+02_JPRB,8.1154E+01_JPRB,6.0752E+01_JPRB,5.9538E+01_JPRB,6.9858E+01_JPRB/)
KBO( :, 2,34,15) = (/&
&1.3258E+02_JPRB,9.9553E+01_JPRB,6.9613E+01_JPRB,5.9127E+01_JPRB,6.5932E+01_JPRB/)
KBO( :, 3,34,15) = (/&
&1.5841E+02_JPRB,1.1893E+02_JPRB,8.0500E+01_JPRB,5.9515E+01_JPRB,6.2316E+01_JPRB/)
KBO( :, 4,34,15) = (/&
&1.8496E+02_JPRB,1.3883E+02_JPRB,9.2804E+01_JPRB,6.0816E+01_JPRB,5.8960E+01_JPRB/)
KBO( :, 5,34,15) = (/&
&2.1175E+02_JPRB,1.5892E+02_JPRB,1.0610E+02_JPRB,6.3176E+01_JPRB,5.5844E+01_JPRB/)
KBO( :, 1,35,15) = (/&
&1.1294E+02_JPRB,8.4826E+01_JPRB,6.3098E+01_JPRB,6.0919E+01_JPRB,7.1099E+01_JPRB/)
KBO( :, 2,35,15) = (/&
&1.3798E+02_JPRB,1.0360E+02_JPRB,7.2230E+01_JPRB,6.0487E+01_JPRB,6.7012E+01_JPRB/)
KBO( :, 3,35,15) = (/&
&1.6418E+02_JPRB,1.2325E+02_JPRB,8.3338E+01_JPRB,6.0862E+01_JPRB,6.3251E+01_JPRB/)
KBO( :, 4,35,15) = (/&
&1.9102E+02_JPRB,1.4338E+02_JPRB,9.5820E+01_JPRB,6.2223E+01_JPRB,5.9778E+01_JPRB/)
KBO( :, 5,35,15) = (/&
&2.1806E+02_JPRB,1.6365E+02_JPRB,1.0925E+02_JPRB,6.4647E+01_JPRB,5.6557E+01_JPRB/)
KBO( :, 1,36,15) = (/&
&1.1497E+02_JPRB,8.6347E+01_JPRB,6.4397E+01_JPRB,6.2153E+01_JPRB,7.2517E+01_JPRB/)
KBO( :, 2,36,15) = (/&
&1.4029E+02_JPRB,1.0534E+02_JPRB,7.3555E+01_JPRB,6.1644E+01_JPRB,6.8256E+01_JPRB/)
KBO( :, 3,36,15) = (/&
&1.6674E+02_JPRB,1.2517E+02_JPRB,8.4714E+01_JPRB,6.1952E+01_JPRB,6.4357E+01_JPRB/)
KBO( :, 4,36,15) = (/&
&1.9381E+02_JPRB,1.4548E+02_JPRB,9.7239E+01_JPRB,6.3251E+01_JPRB,6.0757E+01_JPRB/)
KBO( :, 5,36,15) = (/&
&2.2104E+02_JPRB,1.6589E+02_JPRB,1.1075E+02_JPRB,6.5650E+01_JPRB,5.7519E+01_JPRB/)
KBO( :, 1,37,15) = (/&
&1.1301E+02_JPRB,8.4880E+01_JPRB,6.4331E+01_JPRB,6.3346E+01_JPRB,7.4417E+01_JPRB/)
KBO( :, 2,37,15) = (/&
&1.3839E+02_JPRB,1.0391E+02_JPRB,7.3187E+01_JPRB,6.2656E+01_JPRB,6.9936E+01_JPRB/)
KBO( :, 3,37,15) = (/&
&1.6490E+02_JPRB,1.2380E+02_JPRB,8.4124E+01_JPRB,6.2789E+01_JPRB,6.5851E+01_JPRB/)
KBO( :, 4,37,15) = (/&
&1.9210E+02_JPRB,1.4420E+02_JPRB,9.6503E+01_JPRB,6.3870E+01_JPRB,6.2117E+01_JPRB/)
KBO( :, 5,37,15) = (/&
&2.1953E+02_JPRB,1.6476E+02_JPRB,1.1000E+02_JPRB,6.6083E+01_JPRB,5.8820E+01_JPRB/)
KBO( :, 1,38,15) = (/&
&1.1060E+02_JPRB,8.3078E+01_JPRB,6.4103E+01_JPRB,6.4426E+01_JPRB,7.6201E+01_JPRB/)
KBO( :, 2,38,15) = (/&
&1.3599E+02_JPRB,1.0211E+02_JPRB,7.2632E+01_JPRB,6.3555E+01_JPRB,7.1515E+01_JPRB/)
KBO( :, 3,38,15) = (/&
&1.6253E+02_JPRB,1.2202E+02_JPRB,8.3307E+01_JPRB,6.3503E+01_JPRB,6.7259E+01_JPRB/)
KBO( :, 4,38,15) = (/&
&1.8982E+02_JPRB,1.4248E+02_JPRB,9.5509E+01_JPRB,6.4372E+01_JPRB,6.3412E+01_JPRB/)
KBO( :, 5,38,15) = (/&
&2.1740E+02_JPRB,1.6316E+02_JPRB,1.0894E+02_JPRB,6.6382E+01_JPRB,6.0081E+01_JPRB/)
KBO( :, 1,39,15) = (/&
&1.0803E+02_JPRB,8.1144E+01_JPRB,6.3771E+01_JPRB,6.5414E+01_JPRB,7.7868E+01_JPRB/)
KBO( :, 2,39,15) = (/&
&1.3337E+02_JPRB,1.0015E+02_JPRB,7.1982E+01_JPRB,6.4350E+01_JPRB,7.2975E+01_JPRB/)
KBO( :, 3,39,15) = (/&
&1.5993E+02_JPRB,1.2007E+02_JPRB,8.2398E+01_JPRB,6.4114E+01_JPRB,6.8560E+01_JPRB/)
KBO( :, 4,39,15) = (/&
&1.8726E+02_JPRB,1.4057E+02_JPRB,9.4413E+01_JPRB,6.4795E+01_JPRB,6.4662E+01_JPRB/)
KBO( :, 5,39,15) = (/&
&2.1494E+02_JPRB,1.6132E+02_JPRB,1.0771E+02_JPRB,6.6595E+01_JPRB,6.1311E+01_JPRB/)
KBO( :, 1,40,15) = (/&
&1.0282E+02_JPRB,7.7288E+01_JPRB,6.2719E+01_JPRB,6.6497E+01_JPRB,7.9980E+01_JPRB/)
KBO( :, 2,40,15) = (/&
&1.2788E+02_JPRB,9.6038E+01_JPRB,7.0327E+01_JPRB,6.5135E+01_JPRB,7.4834E+01_JPRB/)
KBO( :, 3,40,15) = (/&
&1.5434E+02_JPRB,1.1588E+02_JPRB,8.0252E+01_JPRB,6.4644E+01_JPRB,7.0224E+01_JPRB/)
KBO( :, 4,40,15) = (/&
&1.8163E+02_JPRB,1.3634E+02_JPRB,9.1957E+01_JPRB,6.5051E+01_JPRB,6.6166E+01_JPRB/)
KBO( :, 5,40,15) = (/&
&2.0939E+02_JPRB,1.5716E+02_JPRB,1.0497E+02_JPRB,6.6532E+01_JPRB,6.2695E+01_JPRB/)
KBO( :, 1,41,15) = (/&
&9.7246E+01_JPRB,7.3264E+01_JPRB,6.1654E+01_JPRB,6.7606E+01_JPRB,8.2110E+01_JPRB/)
KBO( :, 2,41,15) = (/&
&1.2196E+02_JPRB,9.1598E+01_JPRB,6.8639E+01_JPRB,6.5918E+01_JPRB,7.6715E+01_JPRB/)
KBO( :, 3,41,15) = (/&
&1.4825E+02_JPRB,1.1131E+02_JPRB,7.7976E+01_JPRB,6.5166E+01_JPRB,7.1898E+01_JPRB/)
KBO( :, 4,41,15) = (/&
&1.7546E+02_JPRB,1.3172E+02_JPRB,8.9341E+01_JPRB,6.5294E+01_JPRB,6.7663E+01_JPRB/)
KBO( :, 5,41,15) = (/&
&2.0319E+02_JPRB,1.5251E+02_JPRB,1.0200E+02_JPRB,6.6466E+01_JPRB,6.4089E+01_JPRB/)
KBO( :, 1,42,15) = (/&
&9.1646E+01_JPRB,6.9319E+01_JPRB,6.0662E+01_JPRB,6.8736E+01_JPRB,8.4225E+01_JPRB/)
KBO( :, 2,42,15) = (/&
&1.1599E+02_JPRB,8.7117E+01_JPRB,6.7035E+01_JPRB,6.6694E+01_JPRB,7.8581E+01_JPRB/)
KBO( :, 3,42,15) = (/&
&1.4201E+02_JPRB,1.0663E+02_JPRB,7.5772E+01_JPRB,6.5694E+01_JPRB,7.3551E+01_JPRB/)
KBO( :, 4,42,15) = (/&
&1.6913E+02_JPRB,1.2698E+02_JPRB,8.6698E+01_JPRB,6.5537E+01_JPRB,6.9143E+01_JPRB/)
KBO( :, 5,42,15) = (/&
&1.9682E+02_JPRB,1.4774E+02_JPRB,9.9046E+01_JPRB,6.6404E+01_JPRB,6.5463E+01_JPRB/)
KBO( :, 1,43,15) = (/&
&8.4789E+01_JPRB,6.4636E+01_JPRB,5.9566E+01_JPRB,7.0099E+01_JPRB,8.6671E+01_JPRB/)
KBO( :, 2,43,15) = (/&
&1.0857E+02_JPRB,8.1571E+01_JPRB,6.5097E+01_JPRB,6.7581E+01_JPRB,8.0749E+01_JPRB/)
KBO( :, 3,43,15) = (/&
&1.3420E+02_JPRB,1.0078E+02_JPRB,7.3112E+01_JPRB,6.6245E+01_JPRB,7.5464E+01_JPRB/)
KBO( :, 4,43,15) = (/&
&1.6112E+02_JPRB,1.2096E+02_JPRB,8.3408E+01_JPRB,6.5806E+01_JPRB,7.0849E+01_JPRB/)
KBO( :, 5,43,15) = (/&
&1.8873E+02_JPRB,1.4167E+02_JPRB,9.5382E+01_JPRB,6.6299E+01_JPRB,6.7006E+01_JPRB/)
KBO( :, 1,44,15) = (/&
&7.7526E+01_JPRB,5.9880E+01_JPRB,5.8674E+01_JPRB,7.1657E+01_JPRB,8.9332E+01_JPRB/)
KBO( :, 2,44,15) = (/&
&1.0062E+02_JPRB,7.5764E+01_JPRB,6.3217E+01_JPRB,6.8595E+01_JPRB,8.3089E+01_JPRB/)
KBO( :, 3,44,15) = (/&
&1.2573E+02_JPRB,9.4425E+01_JPRB,7.0405E+01_JPRB,6.6884E+01_JPRB,7.7528E+01_JPRB/)
KBO( :, 4,44,15) = (/&
&1.5235E+02_JPRB,1.1439E+02_JPRB,7.9935E+01_JPRB,6.6125E+01_JPRB,7.2672E+01_JPRB/)
KBO( :, 5,44,15) = (/&
&1.7985E+02_JPRB,1.3501E+02_JPRB,9.1481E+01_JPRB,6.6264E+01_JPRB,6.8668E+01_JPRB/)
KBO( :, 1,45,15) = (/&
&7.0491E+01_JPRB,5.5510E+01_JPRB,5.8020E+01_JPRB,7.3319E+01_JPRB,9.2047E+01_JPRB/)
KBO( :, 2,45,15) = (/&
&9.2796E+01_JPRB,7.0229E+01_JPRB,6.1583E+01_JPRB,6.9737E+01_JPRB,8.5464E+01_JPRB/)
KBO( :, 3,45,15) = (/&
&1.1733E+02_JPRB,8.8127E+01_JPRB,6.7937E+01_JPRB,6.7594E+01_JPRB,7.9635E+01_JPRB/)
KBO( :, 4,45,15) = (/&
&1.4359E+02_JPRB,1.0781E+02_JPRB,7.6707E+01_JPRB,6.6524E+01_JPRB,7.4535E+01_JPRB/)
KBO( :, 5,45,15) = (/&
&1.7088E+02_JPRB,1.2829E+02_JPRB,8.7650E+01_JPRB,6.6303E+01_JPRB,7.0370E+01_JPRB/)
KBO( :, 1,46,15) = (/&
&6.3285E+01_JPRB,5.1283E+01_JPRB,5.7489E+01_JPRB,7.5126E+01_JPRB,9.5002E+01_JPRB/)
KBO( :, 2,46,15) = (/&
&8.4647E+01_JPRB,6.4675E+01_JPRB,6.0155E+01_JPRB,7.1107E+01_JPRB,8.8042E+01_JPRB/)
KBO( :, 3,46,15) = (/&
&1.0850E+02_JPRB,8.1543E+01_JPRB,6.5540E+01_JPRB,6.8434E+01_JPRB,8.1933E+01_JPRB/)
KBO( :, 4,46,15) = (/&
&1.3425E+02_JPRB,1.0081E+02_JPRB,7.3459E+01_JPRB,6.6985E+01_JPRB,7.6545E+01_JPRB/)
KBO( :, 5,46,15) = (/&
&1.6128E+02_JPRB,1.2109E+02_JPRB,8.3670E+01_JPRB,6.6464E+01_JPRB,7.2233E+01_JPRB/)
KBO( :, 1,47,15) = (/&
&5.5631E+01_JPRB,4.7112E+01_JPRB,5.7366E+01_JPRB,7.7250E+01_JPRB,9.8390E+01_JPRB/)
KBO( :, 2,47,15) = (/&
&7.5847E+01_JPRB,5.8961E+01_JPRB,5.9001E+01_JPRB,7.2829E+01_JPRB,9.1005E+01_JPRB/)
KBO( :, 3,47,15) = (/&
&9.8817E+01_JPRB,7.4522E+01_JPRB,6.3205E+01_JPRB,6.9511E+01_JPRB,8.4535E+01_JPRB/)
KBO( :, 4,47,15) = (/&
&1.2390E+02_JPRB,9.3053E+01_JPRB,7.0147E+01_JPRB,6.7616E+01_JPRB,7.8824E+01_JPRB/)
KBO( :, 5,47,15) = (/&
&1.5053E+02_JPRB,1.1302E+02_JPRB,7.9443E+01_JPRB,6.6722E+01_JPRB,7.4271E+01_JPRB/)
KBO( :, 1,48,15) = (/&
&4.8436E+01_JPRB,4.3553E+01_JPRB,5.7561E+01_JPRB,7.9397E+01_JPRB,1.0193E+02_JPRB/)
KBO( :, 2,48,15) = (/&
&6.7454E+01_JPRB,5.3825E+01_JPRB,5.8172E+01_JPRB,7.4675E+01_JPRB,9.4102E+01_JPRB/)
KBO( :, 3,48,15) = (/&
&8.9409E+01_JPRB,6.7955E+01_JPRB,6.1273E+01_JPRB,7.0816E+01_JPRB,8.7238E+01_JPRB/)
KBO( :, 4,48,15) = (/&
&1.1374E+02_JPRB,8.5433E+01_JPRB,6.7178E+01_JPRB,6.8391E+01_JPRB,8.1214E+01_JPRB/)
KBO( :, 5,48,15) = (/&
&1.3983E+02_JPRB,1.0500E+02_JPRB,7.5561E+01_JPRB,6.7098E+01_JPRB,7.6443E+01_JPRB/)
KBO( :, 1,49,15) = (/&
&4.1740E+01_JPRB,4.0612E+01_JPRB,5.8201E+01_JPRB,8.1772E+01_JPRB,1.0563E+02_JPRB/)
KBO( :, 2,49,15) = (/&
&5.9508E+01_JPRB,4.9323E+01_JPRB,5.7719E+01_JPRB,7.6675E+01_JPRB,9.7333E+01_JPRB/)
KBO( :, 3,49,15) = (/&
&8.0351E+01_JPRB,6.1919E+01_JPRB,5.9828E+01_JPRB,7.2362E+01_JPRB,9.0062E+01_JPRB/)
KBO( :, 4,49,15) = (/&
&1.0383E+02_JPRB,7.8144E+01_JPRB,6.4592E+01_JPRB,6.9309E+01_JPRB,8.3761E+01_JPRB/)
KBO( :, 5,49,15) = (/&
&1.2931E+02_JPRB,9.7110E+01_JPRB,7.1998E+01_JPRB,6.7617E+01_JPRB,7.8823E+01_JPRB/)
KBO( :, 1,50,15) = (/&
&3.5934E+01_JPRB,3.8439E+01_JPRB,5.9112E+01_JPRB,8.4116E+01_JPRB,1.0931E+02_JPRB/)
KBO( :, 2,50,15) = (/&
&5.2489E+01_JPRB,4.5633E+01_JPRB,5.7703E+01_JPRB,7.8607E+01_JPRB,1.0052E+02_JPRB/)
KBO( :, 3,50,15) = (/&
&7.2228E+01_JPRB,5.6786E+01_JPRB,5.8886E+01_JPRB,7.4022E+01_JPRB,9.2854E+01_JPRB/)
KBO( :, 4,50,15) = (/&
&9.4805E+01_JPRB,7.1728E+01_JPRB,6.2540E+01_JPRB,7.0379E+01_JPRB,8.6215E+01_JPRB/)
KBO( :, 5,50,15) = (/&
&1.1961E+02_JPRB,8.9835E+01_JPRB,6.9015E+01_JPRB,6.8227E+01_JPRB,8.1035E+01_JPRB/)
KBO( :, 1,51,15) = (/&
&3.0771E+01_JPRB,3.7000E+01_JPRB,6.0264E+01_JPRB,8.6506E+01_JPRB,1.1308E+02_JPRB/)
KBO( :, 2,51,15) = (/&
&4.6091E+01_JPRB,4.2604E+01_JPRB,5.8016E+01_JPRB,8.0604E+01_JPRB,1.0374E+02_JPRB/)
KBO( :, 3,51,15) = (/&
&6.4712E+01_JPRB,5.2306E+01_JPRB,5.8175E+01_JPRB,7.5702E+01_JPRB,9.5668E+01_JPRB/)
KBO( :, 4,51,15) = (/&
&8.6318E+01_JPRB,6.5907E+01_JPRB,6.0924E+01_JPRB,7.1626E+01_JPRB,8.8689E+01_JPRB/)
KBO( :, 5,51,15) = (/&
&1.1042E+02_JPRB,8.2968E+01_JPRB,6.6417E+01_JPRB,6.8953E+01_JPRB,8.3187E+01_JPRB/)
KBO( :, 1,52,15) = (/&
&2.6073E+01_JPRB,3.6045E+01_JPRB,6.1822E+01_JPRB,8.9117E+01_JPRB,1.1704E+02_JPRB/)
KBO( :, 2,52,15) = (/&
&4.0129E+01_JPRB,4.0074E+01_JPRB,5.8683E+01_JPRB,8.2788E+01_JPRB,1.0713E+02_JPRB/)
KBO( :, 3,52,15) = (/&
&5.7599E+01_JPRB,4.8365E+01_JPRB,5.7911E+01_JPRB,7.7538E+01_JPRB,9.8609E+01_JPRB/)
KBO( :, 4,52,15) = (/&
&7.8172E+01_JPRB,6.0565E+01_JPRB,5.9728E+01_JPRB,7.3072E+01_JPRB,9.1293E+01_JPRB/)
KBO( :, 5,52,15) = (/&
&1.0144E+02_JPRB,7.6446E+01_JPRB,6.4164E+01_JPRB,6.9820E+01_JPRB,8.5483E+01_JPRB/)
KBO( :, 1,53,15) = (/&
&2.1825E+01_JPRB,3.5431E+01_JPRB,6.3525E+01_JPRB,9.1916E+01_JPRB,1.2120E+02_JPRB/)
KBO( :, 2,53,15) = (/&
&3.4602E+01_JPRB,3.8125E+01_JPRB,5.9600E+01_JPRB,8.5050E+01_JPRB,1.1069E+02_JPRB/)
KBO( :, 3,53,15) = (/&
&5.0871E+01_JPRB,4.4917E+01_JPRB,5.7933E+01_JPRB,7.9373E+01_JPRB,1.0169E+02_JPRB/)
KBO( :, 4,53,15) = (/&
&7.0355E+01_JPRB,5.5689E+01_JPRB,5.8850E+01_JPRB,7.4670E+01_JPRB,9.4071E+01_JPRB/)
KBO( :, 5,53,15) = (/&
&9.2711E+01_JPRB,7.0293E+01_JPRB,6.2235E+01_JPRB,7.0877E+01_JPRB,8.7997E+01_JPRB/)
KBO( :, 1,54,15) = (/&
&1.8337E+01_JPRB,3.5294E+01_JPRB,6.5103E+01_JPRB,9.4568E+01_JPRB,1.2522E+02_JPRB/)
KBO( :, 2,54,15) = (/&
&2.9950E+01_JPRB,3.6915E+01_JPRB,6.0716E+01_JPRB,8.7228E+01_JPRB,1.1414E+02_JPRB/)
KBO( :, 3,54,15) = (/&
&4.5070E+01_JPRB,4.2223E+01_JPRB,5.8276E+01_JPRB,8.1216E+01_JPRB,1.0463E+02_JPRB/)
KBO( :, 4,54,15) = (/&
&6.3520E+01_JPRB,5.1682E+01_JPRB,5.8241E+01_JPRB,7.6218E+01_JPRB,9.6556E+01_JPRB/)
KBO( :, 5,54,15) = (/&
&8.4973E+01_JPRB,6.5035E+01_JPRB,6.0814E+01_JPRB,7.2031E+01_JPRB,8.9905E+01_JPRB/)
KBO( :, 1,55,15) = (/&
&1.5337E+01_JPRB,3.5484E+01_JPRB,6.6783E+01_JPRB,9.7340E+01_JPRB,1.2928E+02_JPRB/)
KBO( :, 2,55,15) = (/&
&2.5852E+01_JPRB,3.6097E+01_JPRB,6.2097E+01_JPRB,8.9537E+01_JPRB,1.1762E+02_JPRB/)
KBO( :, 3,55,15) = (/&
&3.9852E+01_JPRB,4.0035E+01_JPRB,5.8876E+01_JPRB,8.3127E+01_JPRB,1.0760E+02_JPRB/)
KBO( :, 4,55,15) = (/&
&5.7277E+01_JPRB,4.8243E+01_JPRB,5.8037E+01_JPRB,7.7828E+01_JPRB,9.9021E+01_JPRB/)
KBO( :, 5,55,15) = (/&
&7.7821E+01_JPRB,6.0372E+01_JPRB,5.9798E+01_JPRB,7.3320E+01_JPRB,9.1766E+01_JPRB/)
KBO( :, 1,56,15) = (/&
&1.2678E+01_JPRB,3.5873E+01_JPRB,6.8551E+01_JPRB,1.0034E+02_JPRB,1.3352E+02_JPRB/)
KBO( :, 2,56,15) = (/&
&2.2123E+01_JPRB,3.5552E+01_JPRB,6.3571E+01_JPRB,9.1965E+01_JPRB,1.2124E+02_JPRB/)
KBO( :, 3,56,15) = (/&
&3.5001E+01_JPRB,3.8317E+01_JPRB,5.9669E+01_JPRB,8.5094E+01_JPRB,1.1071E+02_JPRB/)
KBO( :, 4,56,15) = (/&
&5.1365E+01_JPRB,4.5210E+01_JPRB,5.8041E+01_JPRB,7.9413E+01_JPRB,1.0170E+02_JPRB/)
KBO( :, 5,56,15) = (/&
&7.0946E+01_JPRB,5.6077E+01_JPRB,5.9007E+01_JPRB,7.4694E+01_JPRB,9.3909E+01_JPRB/)
KBO( :, 1,57,15) = (/&
&1.0339E+01_JPRB,3.6549E+01_JPRB,7.0411E+01_JPRB,1.0357E+02_JPRB,1.3800E+02_JPRB/)
KBO( :, 2,57,15) = (/&
&1.8742E+01_JPRB,3.5363E+01_JPRB,6.5053E+01_JPRB,9.4457E+01_JPRB,1.2502E+02_JPRB/)
KBO( :, 3,57,15) = (/&
&3.0504E+01_JPRB,3.7104E+01_JPRB,6.0681E+01_JPRB,8.7139E+01_JPRB,1.1395E+02_JPRB/)
KBO( :, 4,57,15) = (/&
&4.5773E+01_JPRB,4.2584E+01_JPRB,5.8331E+01_JPRB,8.1143E+01_JPRB,1.0448E+02_JPRB/)
KBO( :, 5,57,15) = (/&
&6.4363E+01_JPRB,5.2190E+01_JPRB,5.8389E+01_JPRB,7.6157E+01_JPRB,9.6302E+01_JPRB/)
KBO( :, 1,58,15) = (/&
&8.4072E+00_JPRB,3.7388E+01_JPRB,7.2338E+01_JPRB,1.0684E+02_JPRB,1.4246E+02_JPRB/)
KBO( :, 2,58,15) = (/&
&1.5855E+01_JPRB,3.5502E+01_JPRB,6.6608E+01_JPRB,9.7023E+01_JPRB,1.2881E+02_JPRB/)
KBO( :, 3,58,15) = (/&
&2.6572E+01_JPRB,3.6289E+01_JPRB,6.1949E+01_JPRB,8.9266E+01_JPRB,1.1719E+02_JPRB/)
KBO( :, 4,58,15) = (/&
&4.0779E+01_JPRB,4.0444E+01_JPRB,5.8844E+01_JPRB,8.2917E+01_JPRB,1.0723E+02_JPRB/)
KBO( :, 5,58,15) = (/&
&5.8404E+01_JPRB,4.8880E+01_JPRB,5.8134E+01_JPRB,7.7647E+01_JPRB,9.8698E+01_JPRB/)
KBO( :, 1,59,15) = (/&
&7.7095E+00_JPRB,3.7763E+01_JPRB,7.3160E+01_JPRB,1.0825E+02_JPRB,1.4434E+02_JPRB/)
KBO( :, 2,59,15) = (/&
&1.4785E+01_JPRB,3.5623E+01_JPRB,6.7273E+01_JPRB,9.8137E+01_JPRB,1.3040E+02_JPRB/)
KBO( :, 3,59,15) = (/&
&2.5092E+01_JPRB,3.6030E+01_JPRB,6.2505E+01_JPRB,9.0193E+01_JPRB,1.1856E+02_JPRB/)
KBO( :, 4,59,15) = (/&
&3.8875E+01_JPRB,3.9709E+01_JPRB,5.9122E+01_JPRB,8.3653E+01_JPRB,1.0840E+02_JPRB/)
KBO( :, 5,59,15) = (/&
&5.6102E+01_JPRB,4.7649E+01_JPRB,5.8109E+01_JPRB,7.8262E+01_JPRB,9.9705E+01_JPRB/)
KBO( :, 1,13,16) = (/&
&3.2263E+01_JPRB,2.4210E+01_JPRB,1.6158E+01_JPRB,8.6472E+00_JPRB,1.1361E+01_JPRB/)
KBO( :, 2,13,16) = (/&
&4.5174E+01_JPRB,3.3894E+01_JPRB,2.2614E+01_JPRB,1.1334E+01_JPRB,1.0965E+01_JPRB/)
KBO( :, 3,13,16) = (/&
&6.0029E+01_JPRB,4.5035E+01_JPRB,3.0042E+01_JPRB,1.5048E+01_JPRB,1.0696E+01_JPRB/)
KBO( :, 4,13,16) = (/&
&7.6465E+01_JPRB,5.7362E+01_JPRB,3.8260E+01_JPRB,1.9157E+01_JPRB,1.0564E+01_JPRB/)
KBO( :, 5,13,16) = (/&
&9.4073E+01_JPRB,7.0568E+01_JPRB,4.7064E+01_JPRB,2.3559E+01_JPRB,1.0648E+01_JPRB/)
KBO( :, 1,14,16) = (/&
&3.9418E+01_JPRB,2.9575E+01_JPRB,1.9732E+01_JPRB,1.0271E+01_JPRB,1.2990E+01_JPRB/)
KBO( :, 2,14,16) = (/&
&5.4735E+01_JPRB,4.1063E+01_JPRB,2.7391E+01_JPRB,1.3719E+01_JPRB,1.2722E+01_JPRB/)
KBO( :, 3,14,16) = (/&
&7.2196E+01_JPRB,5.4159E+01_JPRB,3.6122E+01_JPRB,1.8084E+01_JPRB,1.2482E+01_JPRB/)
KBO( :, 4,14,16) = (/&
&9.1581E+01_JPRB,6.8699E+01_JPRB,4.5817E+01_JPRB,2.2935E+01_JPRB,1.2482E+01_JPRB/)
KBO( :, 5,14,16) = (/&
&1.1260E+02_JPRB,8.4466E+01_JPRB,5.6330E+01_JPRB,2.8194E+01_JPRB,1.2541E+01_JPRB/)
KBO( :, 1,15,16) = (/&
&4.7744E+01_JPRB,3.5818E+01_JPRB,2.3892E+01_JPRB,1.2552E+01_JPRB,1.5030E+01_JPRB/)
KBO( :, 2,15,16) = (/&
&6.5839E+01_JPRB,4.9390E+01_JPRB,3.2941E+01_JPRB,1.6492E+01_JPRB,1.4777E+01_JPRB/)
KBO( :, 3,15,16) = (/&
&8.6769E+01_JPRB,6.5089E+01_JPRB,4.3408E+01_JPRB,2.1728E+01_JPRB,1.4586E+01_JPRB/)
KBO( :, 4,15,16) = (/&
&1.1002E+02_JPRB,8.2528E+01_JPRB,5.5036E+01_JPRB,2.7544E+01_JPRB,1.4666E+01_JPRB/)
KBO( :, 5,15,16) = (/&
&1.3516E+02_JPRB,1.0139E+02_JPRB,6.7610E+01_JPRB,3.3833E+01_JPRB,1.4702E+01_JPRB/)
KBO( :, 1,16,16) = (/&
&5.7645E+01_JPRB,4.3243E+01_JPRB,2.8842E+01_JPRB,1.5267E+01_JPRB,1.7359E+01_JPRB/)
KBO( :, 2,16,16) = (/&
&7.9413E+01_JPRB,5.9570E+01_JPRB,3.9727E+01_JPRB,1.9884E+01_JPRB,1.7054E+01_JPRB/)
KBO( :, 3,16,16) = (/&
&1.0440E+02_JPRB,7.8314E+01_JPRB,5.2225E+01_JPRB,2.6135E+01_JPRB,1.7041E+01_JPRB/)
KBO( :, 4,16,16) = (/&
&1.3208E+02_JPRB,9.9071E+01_JPRB,6.6063E+01_JPRB,3.3056E+01_JPRB,1.7119E+01_JPRB/)
KBO( :, 5,16,16) = (/&
&1.6175E+02_JPRB,1.2132E+02_JPRB,8.0899E+01_JPRB,4.0476E+01_JPRB,1.7152E+01_JPRB/)
KBO( :, 1,17,16) = (/&
&6.9575E+01_JPRB,5.2190E+01_JPRB,3.4804E+01_JPRB,1.8369E+01_JPRB,1.9921E+01_JPRB/)
KBO( :, 2,17,16) = (/&
&9.5428E+01_JPRB,7.1580E+01_JPRB,4.7733E+01_JPRB,2.3885E+01_JPRB,1.9756E+01_JPRB/)
KBO( :, 3,17,16) = (/&
&1.2491E+02_JPRB,9.3694E+01_JPRB,6.2476E+01_JPRB,3.1259E+01_JPRB,1.9810E+01_JPRB/)
KBO( :, 4,17,16) = (/&
&1.5735E+02_JPRB,1.1802E+02_JPRB,7.8696E+01_JPRB,3.9370E+01_JPRB,1.9895E+01_JPRB/)
KBO( :, 5,17,16) = (/&
&1.9186E+02_JPRB,1.4391E+02_JPRB,9.5955E+01_JPRB,4.8001E+01_JPRB,1.9910E+01_JPRB/)
KBO( :, 1,18,16) = (/&
&8.3432E+01_JPRB,6.2581E+01_JPRB,4.1731E+01_JPRB,2.1854E+01_JPRB,2.3228E+01_JPRB/)
KBO( :, 2,18,16) = (/&
&1.1378E+02_JPRB,8.5346E+01_JPRB,5.6908E+01_JPRB,2.8471E+01_JPRB,2.3168E+01_JPRB/)
KBO( :, 3,18,16) = (/&
&1.4807E+02_JPRB,1.1106E+02_JPRB,7.4051E+01_JPRB,3.7043E+01_JPRB,2.3063E+01_JPRB/)
KBO( :, 4,18,16) = (/&
&1.8546E+02_JPRB,1.3910E+02_JPRB,9.2747E+01_JPRB,4.6393E+01_JPRB,2.3051E+01_JPRB/)
KBO( :, 5,18,16) = (/&
&2.2501E+02_JPRB,1.6877E+02_JPRB,1.1253E+02_JPRB,5.6286E+01_JPRB,2.2993E+01_JPRB/)
KBO( :, 1,19,16) = (/&
&9.9057E+01_JPRB,7.4299E+01_JPRB,4.9542E+01_JPRB,2.5942E+01_JPRB,2.7272E+01_JPRB/)
KBO( :, 2,19,16) = (/&
&1.3405E+02_JPRB,1.0055E+02_JPRB,6.7042E+01_JPRB,3.3543E+01_JPRB,2.7144E+01_JPRB/)
KBO( :, 3,19,16) = (/&
&1.7334E+02_JPRB,1.3002E+02_JPRB,8.6689E+01_JPRB,4.3364E+01_JPRB,2.6916E+01_JPRB/)
KBO( :, 4,19,16) = (/&
&2.1641E+02_JPRB,1.6232E+02_JPRB,1.0823E+02_JPRB,5.4140E+01_JPRB,2.6725E+01_JPRB/)
KBO( :, 5,19,16) = (/&
&2.6236E+02_JPRB,1.9678E+02_JPRB,1.3121E+02_JPRB,6.5630E+01_JPRB,2.6538E+01_JPRB/)
KBO( :, 1,20,16) = (/&
&1.1670E+02_JPRB,8.7534E+01_JPRB,5.8366E+01_JPRB,3.0680E+01_JPRB,3.1959E+01_JPRB/)
KBO( :, 2,20,16) = (/&
&1.5709E+02_JPRB,1.1783E+02_JPRB,7.8566E+01_JPRB,3.9305E+01_JPRB,3.1724E+01_JPRB/)
KBO( :, 3,20,16) = (/&
&2.0269E+02_JPRB,1.5203E+02_JPRB,1.0137E+02_JPRB,5.0708E+01_JPRB,3.1376E+01_JPRB/)
KBO( :, 4,20,16) = (/&
&2.5230E+02_JPRB,1.8924E+02_JPRB,1.2618E+02_JPRB,6.3114E+01_JPRB,3.0984E+01_JPRB/)
KBO( :, 5,20,16) = (/&
&3.0479E+02_JPRB,2.2861E+02_JPRB,1.5242E+02_JPRB,7.6237E+01_JPRB,3.0606E+01_JPRB/)
KBO( :, 1,21,16) = (/&
&1.3677E+02_JPRB,1.0259E+02_JPRB,6.8408E+01_JPRB,3.5947E+01_JPRB,3.7295E+01_JPRB/)
KBO( :, 2,21,16) = (/&
&1.8327E+02_JPRB,1.3746E+02_JPRB,9.1655E+01_JPRB,4.5850E+01_JPRB,3.6923E+01_JPRB/)
KBO( :, 3,21,16) = (/&
&2.3530E+02_JPRB,1.7648E+02_JPRB,1.1767E+02_JPRB,5.8860E+01_JPRB,3.6405E+01_JPRB/)
KBO( :, 4,21,16) = (/&
&2.9155E+02_JPRB,2.1867E+02_JPRB,1.4580E+02_JPRB,7.2922E+01_JPRB,3.5874E+01_JPRB/)
KBO( :, 5,21,16) = (/&
&3.5033E+02_JPRB,2.6276E+02_JPRB,1.7519E+02_JPRB,8.7619E+01_JPRB,3.5270E+01_JPRB/)
KBO( :, 1,22,16) = (/&
&1.6233E+02_JPRB,1.2176E+02_JPRB,8.1187E+01_JPRB,4.2657E+01_JPRB,4.3248E+01_JPRB/)
KBO( :, 2,22,16) = (/&
&2.1544E+02_JPRB,1.6159E+02_JPRB,1.0774E+02_JPRB,5.3945E+01_JPRB,4.2701E+01_JPRB/)
KBO( :, 3,22,16) = (/&
&2.7410E+02_JPRB,2.0559E+02_JPRB,1.3707E+02_JPRB,6.8557E+01_JPRB,4.2119E+01_JPRB/)
KBO( :, 4,22,16) = (/&
&3.3685E+02_JPRB,2.5265E+02_JPRB,1.6845E+02_JPRB,8.4248E+01_JPRB,4.1509E+01_JPRB/)
KBO( :, 5,22,16) = (/&
&4.0263E+02_JPRB,3.0199E+02_JPRB,2.0134E+02_JPRB,1.0070E+02_JPRB,4.0811E+01_JPRB/)
KBO( :, 1,23,16) = (/&
&1.9053E+02_JPRB,1.4291E+02_JPRB,9.5285E+01_JPRB,5.0617E+01_JPRB,5.0337E+01_JPRB/)
KBO( :, 2,23,16) = (/&
&2.5017E+02_JPRB,1.8764E+02_JPRB,1.2511E+02_JPRB,6.2998E+01_JPRB,4.9660E+01_JPRB/)
KBO( :, 3,23,16) = (/&
&3.1595E+02_JPRB,2.3698E+02_JPRB,1.5800E+02_JPRB,7.9029E+01_JPRB,4.8927E+01_JPRB/)
KBO( :, 4,23,16) = (/&
&3.8628E+02_JPRB,2.8972E+02_JPRB,1.9317E+02_JPRB,9.6612E+01_JPRB,4.8034E+01_JPRB/)
KBO( :, 5,23,16) = (/&
&4.5926E+02_JPRB,3.4446E+02_JPRB,2.2966E+02_JPRB,1.1486E+02_JPRB,4.7018E+01_JPRB/)
KBO( :, 1,24,16) = (/&
&2.2153E+02_JPRB,1.6616E+02_JPRB,1.1079E+02_JPRB,5.9590E+01_JPRB,5.8418E+01_JPRB/)
KBO( :, 2,24,16) = (/&
&2.8858E+02_JPRB,2.1645E+02_JPRB,1.4432E+02_JPRB,7.2964E+01_JPRB,5.7353E+01_JPRB/)
KBO( :, 3,24,16) = (/&
&3.6176E+02_JPRB,2.7134E+02_JPRB,1.8091E+02_JPRB,9.0484E+01_JPRB,5.6191E+01_JPRB/)
KBO( :, 4,24,16) = (/&
&4.3913E+02_JPRB,3.2936E+02_JPRB,2.1959E+02_JPRB,1.0983E+02_JPRB,5.4899E+01_JPRB/)
KBO( :, 5,24,16) = (/&
&5.1871E+02_JPRB,3.8905E+02_JPRB,2.5939E+02_JPRB,1.2972E+02_JPRB,5.3493E+01_JPRB/)
KBO( :, 1,25,16) = (/&
&2.5592E+02_JPRB,1.9195E+02_JPRB,1.2799E+02_JPRB,6.9505E+01_JPRB,6.6958E+01_JPRB/)
KBO( :, 2,25,16) = (/&
&3.3021E+02_JPRB,2.4767E+02_JPRB,1.6513E+02_JPRB,8.3805E+01_JPRB,6.5388E+01_JPRB/)
KBO( :, 3,25,16) = (/&
&4.1034E+02_JPRB,3.0777E+02_JPRB,2.0520E+02_JPRB,1.0263E+02_JPRB,6.3684E+01_JPRB/)
KBO( :, 4,25,16) = (/&
&4.9407E+02_JPRB,3.7057E+02_JPRB,2.4706E+02_JPRB,1.2356E+02_JPRB,6.1889E+01_JPRB/)
KBO( :, 5,25,16) = (/&
&5.7945E+02_JPRB,4.3460E+02_JPRB,2.8975E+02_JPRB,1.4490E+02_JPRB,6.0007E+01_JPRB/)
KBO( :, 1,26,16) = (/&
&2.9375E+02_JPRB,2.2033E+02_JPRB,1.4690E+02_JPRB,8.0244E+01_JPRB,7.5657E+01_JPRB/)
KBO( :, 2,26,16) = (/&
&3.7482E+02_JPRB,2.8113E+02_JPRB,1.8744E+02_JPRB,9.5627E+01_JPRB,7.3427E+01_JPRB/)
KBO( :, 3,26,16) = (/&
&4.6126E+02_JPRB,3.4596E+02_JPRB,2.3065E+02_JPRB,1.1546E+02_JPRB,7.1104E+01_JPRB/)
KBO( :, 4,26,16) = (/&
&5.5138E+02_JPRB,4.1354E+02_JPRB,2.7571E+02_JPRB,1.3788E+02_JPRB,6.8732E+01_JPRB/)
KBO( :, 5,26,16) = (/&
&6.4282E+02_JPRB,4.8213E+02_JPRB,3.2143E+02_JPRB,1.6074E+02_JPRB,6.6296E+01_JPRB/)
KBO( :, 1,27,16) = (/&
&3.3321E+02_JPRB,2.4992E+02_JPRB,1.6663E+02_JPRB,9.1366E+01_JPRB,8.4138E+01_JPRB/)
KBO( :, 2,27,16) = (/&
&4.2092E+02_JPRB,3.1570E+02_JPRB,2.1048E+02_JPRB,1.0786E+02_JPRB,8.1216E+01_JPRB/)
KBO( :, 3,27,16) = (/&
&5.1399E+02_JPRB,3.8550E+02_JPRB,2.5701E+02_JPRB,1.2862E+02_JPRB,7.8186E+01_JPRB/)
KBO( :, 4,27,16) = (/&
&6.0988E+02_JPRB,4.5742E+02_JPRB,3.0496E+02_JPRB,1.5250E+02_JPRB,7.5179E+01_JPRB/)
KBO( :, 5,27,16) = (/&
&7.0613E+02_JPRB,5.2960E+02_JPRB,3.5308E+02_JPRB,1.7656E+02_JPRB,7.2191E+01_JPRB/)
KBO( :, 1,28,16) = (/&
&3.7433E+02_JPRB,2.8075E+02_JPRB,1.8718E+02_JPRB,1.0259E+02_JPRB,9.2146E+01_JPRB/)
KBO( :, 2,28,16) = (/&
&4.6847E+02_JPRB,3.5136E+02_JPRB,2.3425E+02_JPRB,1.2023E+02_JPRB,8.8477E+01_JPRB/)
KBO( :, 3,28,16) = (/&
&5.6719E+02_JPRB,4.2540E+02_JPRB,2.8361E+02_JPRB,1.4204E+02_JPRB,8.4711E+01_JPRB/)
KBO( :, 4,28,16) = (/&
&6.6805E+02_JPRB,5.0105E+02_JPRB,3.3404E+02_JPRB,1.6704E+02_JPRB,8.1058E+01_JPRB/)
KBO( :, 5,28,16) = (/&
&7.6861E+02_JPRB,5.7647E+02_JPRB,3.8432E+02_JPRB,1.9217E+02_JPRB,7.7535E+01_JPRB/)
KBO( :, 1,29,16) = (/&
&4.1725E+02_JPRB,3.1294E+02_JPRB,2.0864E+02_JPRB,1.1391E+02_JPRB,9.9444E+01_JPRB/)
KBO( :, 2,29,16) = (/&
&5.1701E+02_JPRB,3.8777E+02_JPRB,2.5852E+02_JPRB,1.3257E+02_JPRB,9.4950E+01_JPRB/)
KBO( :, 3,29,16) = (/&
&6.2080E+02_JPRB,4.6561E+02_JPRB,3.1041E+02_JPRB,1.5542E+02_JPRB,9.0532E+01_JPRB/)
KBO( :, 4,29,16) = (/&
&7.2558E+02_JPRB,5.4419E+02_JPRB,3.6280E+02_JPRB,1.8141E+02_JPRB,8.6254E+01_JPRB/)
KBO( :, 5,29,16) = (/&
&8.2901E+02_JPRB,6.2176E+02_JPRB,4.1451E+02_JPRB,2.0727E+02_JPRB,8.2152E+01_JPRB/)
KBO( :, 1,30,16) = (/&
&4.6074E+02_JPRB,3.4556E+02_JPRB,2.3038E+02_JPRB,1.2510E+02_JPRB,1.0583E+02_JPRB/)
KBO( :, 2,30,16) = (/&
&5.6540E+02_JPRB,4.2406E+02_JPRB,2.8271E+02_JPRB,1.4464E+02_JPRB,1.0057E+02_JPRB/)
KBO( :, 3,30,16) = (/&
&6.7286E+02_JPRB,5.0465E+02_JPRB,3.3644E+02_JPRB,1.6852E+02_JPRB,9.5505E+01_JPRB/)
KBO( :, 4,30,16) = (/&
&7.8088E+02_JPRB,5.8566E+02_JPRB,3.9045E+02_JPRB,1.9523E+02_JPRB,9.0661E+01_JPRB/)
KBO( :, 5,30,16) = (/&
&8.8686E+02_JPRB,6.6515E+02_JPRB,4.4344E+02_JPRB,2.2173E+02_JPRB,8.6036E+01_JPRB/)
KBO( :, 1,31,16) = (/&
&5.0472E+02_JPRB,3.7854E+02_JPRB,2.5237E+02_JPRB,1.3614E+02_JPRB,1.1117E+02_JPRB/)
KBO( :, 2,31,16) = (/&
&6.1339E+02_JPRB,4.6004E+02_JPRB,3.0670E+02_JPRB,1.5661E+02_JPRB,1.0529E+02_JPRB/)
KBO( :, 3,31,16) = (/&
&7.2433E+02_JPRB,5.4325E+02_JPRB,3.6217E+02_JPRB,1.8144E+02_JPRB,9.9591E+01_JPRB/)
KBO( :, 4,31,16) = (/&
&8.3504E+02_JPRB,6.2629E+02_JPRB,4.1753E+02_JPRB,2.0877E+02_JPRB,9.4229E+01_JPRB/)
KBO( :, 5,31,16) = (/&
&9.4280E+02_JPRB,7.0711E+02_JPRB,4.7141E+02_JPRB,2.3571E+02_JPRB,8.9176E+01_JPRB/)
KBO( :, 1,32,16) = (/&
&5.4855E+02_JPRB,4.1142E+02_JPRB,2.7428E+02_JPRB,1.4676E+02_JPRB,1.1548E+02_JPRB/)
KBO( :, 2,32,16) = (/&
&6.6091E+02_JPRB,4.9568E+02_JPRB,3.3046E+02_JPRB,1.6826E+02_JPRB,1.0901E+02_JPRB/)
KBO( :, 3,32,16) = (/&
&7.7477E+02_JPRB,5.8108E+02_JPRB,3.8739E+02_JPRB,1.9388E+02_JPRB,1.0281E+02_JPRB/)
KBO( :, 4,32,16) = (/&
&8.8730E+02_JPRB,6.6548E+02_JPRB,4.4366E+02_JPRB,2.2183E+02_JPRB,9.7004E+01_JPRB/)
KBO( :, 5,32,16) = (/&
&9.9594E+02_JPRB,7.4695E+02_JPRB,4.9797E+02_JPRB,2.4899E+02_JPRB,9.1601E+01_JPRB/)
KBO( :, 1,33,16) = (/&
&5.9242E+02_JPRB,4.4432E+02_JPRB,2.9622E+02_JPRB,1.5694E+02_JPRB,1.1883E+02_JPRB/)
KBO( :, 2,33,16) = (/&
&7.0777E+02_JPRB,5.3083E+02_JPRB,3.5389E+02_JPRB,1.7956E+02_JPRB,1.1183E+02_JPRB/)
KBO( :, 3,33,16) = (/&
&8.2358E+02_JPRB,6.1768E+02_JPRB,4.1179E+02_JPRB,2.0591E+02_JPRB,1.0524E+02_JPRB/)
KBO( :, 4,33,16) = (/&
&9.3713E+02_JPRB,7.0285E+02_JPRB,4.6857E+02_JPRB,2.3429E+02_JPRB,9.9066E+01_JPRB/)
KBO( :, 5,33,16) = (/&
&1.0459E+03_JPRB,7.8446E+02_JPRB,5.2297E+02_JPRB,2.6149E+02_JPRB,9.3354E+01_JPRB/)
KBO( :, 1,34,16) = (/&
&6.3153E+02_JPRB,4.7365E+02_JPRB,3.1577E+02_JPRB,1.6595E+02_JPRB,1.2152E+02_JPRB/)
KBO( :, 2,34,16) = (/&
&7.4904E+02_JPRB,5.6178E+02_JPRB,3.7452E+02_JPRB,1.8952E+02_JPRB,1.1409E+02_JPRB/)
KBO( :, 3,34,16) = (/&
&8.6625E+02_JPRB,6.4969E+02_JPRB,4.3313E+02_JPRB,2.1657E+02_JPRB,1.0714E+02_JPRB/)
KBO( :, 4,34,16) = (/&
&9.8045E+02_JPRB,7.3534E+02_JPRB,4.9023E+02_JPRB,2.4512E+02_JPRB,1.0070E+02_JPRB/)
KBO( :, 5,34,16) = (/&
&1.0897E+03_JPRB,8.1726E+02_JPRB,5.4484E+02_JPRB,2.7243E+02_JPRB,9.4730E+01_JPRB/)
KBO( :, 1,35,16) = (/&
&6.5821E+02_JPRB,4.9366E+02_JPRB,3.2911E+02_JPRB,1.7240E+02_JPRB,1.2419E+02_JPRB/)
KBO( :, 2,35,16) = (/&
&7.7728E+02_JPRB,5.8296E+02_JPRB,3.8864E+02_JPRB,1.9649E+02_JPRB,1.1638E+02_JPRB/)
KBO( :, 3,35,16) = (/&
&8.9594E+02_JPRB,6.7196E+02_JPRB,4.4797E+02_JPRB,2.2399E+02_JPRB,1.0909E+02_JPRB/)
KBO( :, 4,35,16) = (/&
&1.0109E+03_JPRB,7.5821E+02_JPRB,5.0548E+02_JPRB,2.5274E+02_JPRB,1.0239E+02_JPRB/)
KBO( :, 5,35,16) = (/&
&1.1199E+03_JPRB,8.3992E+02_JPRB,5.5995E+02_JPRB,2.7998E+02_JPRB,9.6183E+01_JPRB/)
KBO( :, 1,36,16) = (/&
&6.7059E+02_JPRB,5.0294E+02_JPRB,3.3530E+02_JPRB,1.7604E+02_JPRB,1.2715E+02_JPRB/)
KBO( :, 2,36,16) = (/&
&7.9094E+02_JPRB,5.9320E+02_JPRB,3.9547E+02_JPRB,2.0012E+02_JPRB,1.1897E+02_JPRB/)
KBO( :, 3,36,16) = (/&
&9.1055E+02_JPRB,6.8291E+02_JPRB,4.5528E+02_JPRB,2.2764E+02_JPRB,1.1135E+02_JPRB/)
KBO( :, 4,36,16) = (/&
&1.0266E+03_JPRB,7.6996E+02_JPRB,5.1331E+02_JPRB,2.5666E+02_JPRB,1.0436E+02_JPRB/)
KBO( :, 5,36,16) = (/&
&1.1363E+03_JPRB,8.5221E+02_JPRB,5.6814E+02_JPRB,2.8407E+02_JPRB,9.7934E+01_JPRB/)
KBO( :, 1,37,16) = (/&
&6.6319E+02_JPRB,4.9740E+02_JPRB,3.3160E+02_JPRB,1.7601E+02_JPRB,1.3096E+02_JPRB/)
KBO( :, 2,37,16) = (/&
&7.8424E+02_JPRB,5.8818E+02_JPRB,3.9212E+02_JPRB,1.9937E+02_JPRB,1.2236E+02_JPRB/)
KBO( :, 3,37,16) = (/&
&9.0524E+02_JPRB,6.7893E+02_JPRB,4.5262E+02_JPRB,2.2635E+02_JPRB,1.1439E+02_JPRB/)
KBO( :, 4,37,16) = (/&
&1.0226E+03_JPRB,7.6693E+02_JPRB,5.1129E+02_JPRB,2.5565E+02_JPRB,1.0707E+02_JPRB/)
KBO( :, 5,37,16) = (/&
&1.1340E+03_JPRB,8.5053E+02_JPRB,5.6702E+02_JPRB,2.8351E+02_JPRB,1.0033E+02_JPRB/)
KBO( :, 1,38,16) = (/&
&6.5328E+02_JPRB,4.8996E+02_JPRB,3.2664E+02_JPRB,1.7551E+02_JPRB,1.3460E+02_JPRB/)
KBO( :, 2,38,16) = (/&
&7.7497E+02_JPRB,5.8123E+02_JPRB,3.8749E+02_JPRB,1.9811E+02_JPRB,1.2556E+02_JPRB/)
KBO( :, 3,38,16) = (/&
&8.9678E+02_JPRB,6.7259E+02_JPRB,4.4839E+02_JPRB,2.2452E+02_JPRB,1.1726E+02_JPRB/)
KBO( :, 4,38,16) = (/&
&1.0156E+03_JPRB,7.6168E+02_JPRB,5.0779E+02_JPRB,2.5390E+02_JPRB,1.0960E+02_JPRB/)
KBO( :, 5,38,16) = (/&
&1.1289E+03_JPRB,8.4669E+02_JPRB,5.6446E+02_JPRB,2.8223E+02_JPRB,1.0262E+02_JPRB/)
KBO( :, 1,39,16) = (/&
&6.4257E+02_JPRB,4.8193E+02_JPRB,3.2129E+02_JPRB,1.7479E+02_JPRB,1.3792E+02_JPRB/)
KBO( :, 2,39,16) = (/&
&7.6414E+02_JPRB,5.7310E+02_JPRB,3.8207E+02_JPRB,1.9654E+02_JPRB,1.2851E+02_JPRB/)
KBO( :, 3,39,16) = (/&
&8.8664E+02_JPRB,6.6498E+02_JPRB,4.4332E+02_JPRB,2.2243E+02_JPRB,1.1989E+02_JPRB/)
KBO( :, 4,39,16) = (/&
&1.0066E+03_JPRB,7.5495E+02_JPRB,5.0330E+02_JPRB,2.5165E+02_JPRB,1.1192E+02_JPRB/)
KBO( :, 5,39,16) = (/&
&1.1211E+03_JPRB,8.4084E+02_JPRB,5.6056E+02_JPRB,2.8028E+02_JPRB,1.0470E+02_JPRB/)
KBO( :, 1,40,16) = (/&
&6.1808E+02_JPRB,4.6356E+02_JPRB,3.0904E+02_JPRB,1.7192E+02_JPRB,1.4210E+02_JPRB/)
KBO( :, 2,40,16) = (/&
&7.3974E+02_JPRB,5.5481E+02_JPRB,3.6987E+02_JPRB,1.9237E+02_JPRB,1.3221E+02_JPRB/)
KBO( :, 3,40,16) = (/&
&8.6274E+02_JPRB,6.4706E+02_JPRB,4.3137E+02_JPRB,2.1745E+02_JPRB,1.2321E+02_JPRB/)
KBO( :, 4,40,16) = (/&
&9.8377E+02_JPRB,7.3783E+02_JPRB,4.9189E+02_JPRB,2.4594E+02_JPRB,1.1493E+02_JPRB/)
KBO( :, 5,40,16) = (/&
&1.1003E+03_JPRB,8.2526E+02_JPRB,5.5018E+02_JPRB,2.7509E+02_JPRB,1.0740E+02_JPRB/)
KBO( :, 1,41,16) = (/&
&5.9120E+02_JPRB,4.4340E+02_JPRB,2.9560E+02_JPRB,1.6877E+02_JPRB,1.4632E+02_JPRB/)
KBO( :, 2,41,16) = (/&
&7.1268E+02_JPRB,5.3451E+02_JPRB,3.5634E+02_JPRB,1.8787E+02_JPRB,1.3592E+02_JPRB/)
KBO( :, 3,41,16) = (/&
&8.3597E+02_JPRB,6.2698E+02_JPRB,4.1798E+02_JPRB,2.1205E+02_JPRB,1.2655E+02_JPRB/)
KBO( :, 4,41,16) = (/&
&9.5842E+02_JPRB,7.1882E+02_JPRB,4.7921E+02_JPRB,2.3967E+02_JPRB,1.1795E+02_JPRB/)
KBO( :, 5,41,16) = (/&
&1.0766E+03_JPRB,8.0748E+02_JPRB,5.3832E+02_JPRB,2.6916E+02_JPRB,1.1013E+02_JPRB/)
KBO( :, 1,42,16) = (/&
&5.6381E+02_JPRB,4.2287E+02_JPRB,2.8192E+02_JPRB,1.6586E+02_JPRB,1.5054E+02_JPRB/)
KBO( :, 2,42,16) = (/&
&6.8496E+02_JPRB,5.1372E+02_JPRB,3.4248E+02_JPRB,1.8375E+02_JPRB,1.3960E+02_JPRB/)
KBO( :, 3,42,16) = (/&
&8.0821E+02_JPRB,6.0616E+02_JPRB,4.0411E+02_JPRB,2.0657E+02_JPRB,1.2981E+02_JPRB/)
KBO( :, 4,42,16) = (/&
&9.3135E+02_JPRB,6.9851E+02_JPRB,4.6567E+02_JPRB,2.3323E+02_JPRB,1.2093E+02_JPRB/)
KBO( :, 5,42,16) = (/&
&1.0512E+03_JPRB,7.8842E+02_JPRB,5.2562E+02_JPRB,2.6281E+02_JPRB,1.1278E+02_JPRB/)
KBO( :, 1,43,16) = (/&
&5.2955E+02_JPRB,3.9717E+02_JPRB,2.6480E+02_JPRB,1.6239E+02_JPRB,1.5543E+02_JPRB/)
KBO( :, 2,43,16) = (/&
&6.4929E+02_JPRB,4.8697E+02_JPRB,3.2465E+02_JPRB,1.7863E+02_JPRB,1.4384E+02_JPRB/)
KBO( :, 3,43,16) = (/&
&7.7272E+02_JPRB,5.7954E+02_JPRB,3.8636E+02_JPRB,1.9990E+02_JPRB,1.3363E+02_JPRB/)
KBO( :, 4,43,16) = (/&
&8.9638E+02_JPRB,6.7229E+02_JPRB,4.4819E+02_JPRB,2.2542E+02_JPRB,1.2436E+02_JPRB/)
KBO( :, 5,43,16) = (/&
&1.0176E+03_JPRB,7.6322E+02_JPRB,5.0881E+02_JPRB,2.5441E+02_JPRB,1.1585E+02_JPRB/)
KBO( :, 1,44,16) = (/&
&4.9226E+02_JPRB,3.6921E+02_JPRB,2.4618E+02_JPRB,1.5919E+02_JPRB,1.6071E+02_JPRB/)
KBO( :, 2,44,16) = (/&
&6.1049E+02_JPRB,4.5787E+02_JPRB,3.0525E+02_JPRB,1.7333E+02_JPRB,1.4841E+02_JPRB/)
KBO( :, 3,44,16) = (/&
&7.3319E+02_JPRB,5.4989E+02_JPRB,3.6660E+02_JPRB,1.9274E+02_JPRB,1.3765E+02_JPRB/)
KBO( :, 4,44,16) = (/&
&8.5738E+02_JPRB,6.4303E+02_JPRB,4.2869E+02_JPRB,2.1719E+02_JPRB,1.2801E+02_JPRB/)
KBO( :, 5,44,16) = (/&
&9.7980E+02_JPRB,7.3485E+02_JPRB,4.8990E+02_JPRB,2.4500E+02_JPRB,1.1918E+02_JPRB/)
KBO( :, 1,45,16) = (/&
&4.5538E+02_JPRB,3.4155E+02_JPRB,2.2854E+02_JPRB,1.5641E+02_JPRB,1.6609E+02_JPRB/)
KBO( :, 2,45,16) = (/&
&5.7191E+02_JPRB,4.2894E+02_JPRB,2.8597E+02_JPRB,1.6860E+02_JPRB,1.5314E+02_JPRB/)
KBO( :, 3,45,16) = (/&
&6.9342E+02_JPRB,5.2007E+02_JPRB,3.4671E+02_JPRB,1.8629E+02_JPRB,1.4178E+02_JPRB/)
KBO( :, 4,45,16) = (/&
&8.1734E+02_JPRB,6.1301E+02_JPRB,4.0867E+02_JPRB,2.0907E+02_JPRB,1.3172E+02_JPRB/)
KBO( :, 5,45,16) = (/&
&9.4113E+02_JPRB,7.0584E+02_JPRB,4.7056E+02_JPRB,2.3576E+02_JPRB,1.2254E+02_JPRB/)
KBO( :, 1,46,16) = (/&
&4.1669E+02_JPRB,3.1253E+02_JPRB,2.1183E+02_JPRB,1.5432E+02_JPRB,1.7199E+02_JPRB/)
KBO( :, 2,46,16) = (/&
&5.3032E+02_JPRB,3.9775E+02_JPRB,2.6519E+02_JPRB,1.6403E+02_JPRB,1.5825E+02_JPRB/)
KBO( :, 3,46,16) = (/&
&6.5084E+02_JPRB,4.8813E+02_JPRB,3.2542E+02_JPRB,1.7998E+02_JPRB,1.4624E+02_JPRB/)
KBO( :, 4,46,16) = (/&
&7.7453E+02_JPRB,5.8090E+02_JPRB,3.8727E+02_JPRB,2.0089E+02_JPRB,1.3568E+02_JPRB/)
KBO( :, 5,46,16) = (/&
&8.9886E+02_JPRB,6.7414E+02_JPRB,4.4943E+02_JPRB,2.2628E+02_JPRB,1.2618E+02_JPRB/)
KBO( :, 1,47,16) = (/&
&3.7428E+02_JPRB,2.8073E+02_JPRB,1.9464E+02_JPRB,1.5283E+02_JPRB,1.7876E+02_JPRB/)
KBO( :, 2,47,16) = (/&
&4.8479E+02_JPRB,3.6362E+02_JPRB,2.4253E+02_JPRB,1.5990E+02_JPRB,1.6413E+02_JPRB/)
KBO( :, 3,47,16) = (/&
&6.0294E+02_JPRB,4.5221E+02_JPRB,3.0147E+02_JPRB,1.7328E+02_JPRB,1.5134E+02_JPRB/)
KBO( :, 4,47,16) = (/&
&7.2591E+02_JPRB,5.4443E+02_JPRB,3.6295E+02_JPRB,1.9215E+02_JPRB,1.4020E+02_JPRB/)
KBO( :, 5,47,16) = (/&
&8.5037E+02_JPRB,6.3778E+02_JPRB,4.2518E+02_JPRB,2.1607E+02_JPRB,1.3023E+02_JPRB/)
KBO( :, 1,48,16) = (/&
&3.3349E+02_JPRB,2.5014E+02_JPRB,1.7970E+02_JPRB,1.5302E+02_JPRB,1.8591E+02_JPRB/)
KBO( :, 2,48,16) = (/&
&4.4002E+02_JPRB,3.3004E+02_JPRB,2.2195E+02_JPRB,1.5666E+02_JPRB,1.7030E+02_JPRB/)
KBO( :, 3,48,16) = (/&
&5.5563E+02_JPRB,4.1673E+02_JPRB,2.7783E+02_JPRB,1.6752E+02_JPRB,1.5672E+02_JPRB/)
KBO( :, 4,48,16) = (/&
&6.7724E+02_JPRB,5.0793E+02_JPRB,3.3862E+02_JPRB,1.8443E+02_JPRB,1.4489E+02_JPRB/)
KBO( :, 5,48,16) = (/&
&8.0113E+02_JPRB,6.0085E+02_JPRB,4.0056E+02_JPRB,2.0627E+02_JPRB,1.3444E+02_JPRB/)
KBO( :, 1,49,16) = (/&
&2.9450E+02_JPRB,2.2091E+02_JPRB,1.6633E+02_JPRB,1.5392E+02_JPRB,1.9354E+02_JPRB/)
KBO( :, 2,49,16) = (/&
&3.9655E+02_JPRB,2.9743E+02_JPRB,2.0370E+02_JPRB,1.5444E+02_JPRB,1.7673E+02_JPRB/)
KBO( :, 3,49,16) = (/&
&5.0897E+02_JPRB,3.8174E+02_JPRB,2.5452E+02_JPRB,1.6274E+02_JPRB,1.6236E+02_JPRB/)
KBO( :, 4,49,16) = (/&
&6.2857E+02_JPRB,4.7143E+02_JPRB,3.1428E+02_JPRB,1.7731E+02_JPRB,1.4974E+02_JPRB/)
KBO( :, 5,49,16) = (/&
&7.5222E+02_JPRB,5.6417E+02_JPRB,3.7611E+02_JPRB,1.9706E+02_JPRB,1.3876E+02_JPRB/)
KBO( :, 1,50,16) = (/&
&2.5985E+02_JPRB,1.9491E+02_JPRB,1.5586E+02_JPRB,1.5616E+02_JPRB,2.0113E+02_JPRB/)
KBO( :, 2,50,16) = (/&
&3.5704E+02_JPRB,2.6780E+02_JPRB,1.8851E+02_JPRB,1.5379E+02_JPRB,1.8310E+02_JPRB/)
KBO( :, 3,50,16) = (/&
&4.6618E+02_JPRB,3.4965E+02_JPRB,2.3374E+02_JPRB,1.5907E+02_JPRB,1.6786E+02_JPRB/)
KBO( :, 4,50,16) = (/&
&5.8341E+02_JPRB,4.3757E+02_JPRB,2.9172E+02_JPRB,1.7138E+02_JPRB,1.5459E+02_JPRB/)
KBO( :, 5,50,16) = (/&
&7.0619E+02_JPRB,5.2964E+02_JPRB,3.5310E+02_JPRB,1.8927E+02_JPRB,1.4300E+02_JPRB/)
KBO( :, 1,51,16) = (/&
&2.2810E+02_JPRB,1.7111E+02_JPRB,1.4781E+02_JPRB,1.5986E+02_JPRB,2.0899E+02_JPRB/)
KBO( :, 2,51,16) = (/&
&3.2034E+02_JPRB,2.4028E+02_JPRB,1.7546E+02_JPRB,1.5410E+02_JPRB,1.8970E+02_JPRB/)
KBO( :, 3,51,16) = (/&
&4.2561E+02_JPRB,3.1923E+02_JPRB,2.1599E+02_JPRB,1.5649E+02_JPRB,1.7346E+02_JPRB/)
KBO( :, 4,51,16) = (/&
&5.4039E+02_JPRB,4.0531E+02_JPRB,2.7023E+02_JPRB,1.6638E+02_JPRB,1.5946E+02_JPRB/)
KBO( :, 5,51,16) = (/&
&6.6162E+02_JPRB,4.9621E+02_JPRB,3.3081E+02_JPRB,1.8245E+02_JPRB,1.4725E+02_JPRB/)
KBO( :, 1,52,16) = (/&
&1.9828E+02_JPRB,1.4993E+02_JPRB,1.4119E+02_JPRB,1.6436E+02_JPRB,2.1740E+02_JPRB/)
KBO( :, 2,52,16) = (/&
&2.8540E+02_JPRB,2.1407E+02_JPRB,1.6382E+02_JPRB,1.5520E+02_JPRB,1.9665E+02_JPRB/)
KBO( :, 3,52,16) = (/&
&3.8626E+02_JPRB,2.8971E+02_JPRB,1.9981E+02_JPRB,1.5468E+02_JPRB,1.7935E+02_JPRB/)
KBO( :, 4,52,16) = (/&
&4.9804E+02_JPRB,3.7355E+02_JPRB,2.4908E+02_JPRB,1.6225E+02_JPRB,1.6458E+02_JPRB/)
KBO( :, 5,52,16) = (/&
&6.1718E+02_JPRB,4.6289E+02_JPRB,3.0859E+02_JPRB,1.7607E+02_JPRB,1.5168E+02_JPRB/)
KBO( :, 1,53,16) = (/&
&1.7053E+02_JPRB,1.3271E+02_JPRB,1.3636E+02_JPRB,1.6986E+02_JPRB,2.2630E+02_JPRB/)
KBO( :, 2,53,16) = (/&
&2.5204E+02_JPRB,1.8906E+02_JPRB,1.5417E+02_JPRB,1.5767E+02_JPRB,2.0404E+02_JPRB/)
KBO( :, 3,53,16) = (/&
&3.4819E+02_JPRB,2.6116E+02_JPRB,1.8555E+02_JPRB,1.5442E+02_JPRB,1.8552E+02_JPRB/)
KBO( :, 4,53,16) = (/&
&4.5652E+02_JPRB,3.4241E+02_JPRB,2.2942E+02_JPRB,1.5882E+02_JPRB,1.6992E+02_JPRB/)
KBO( :, 5,53,16) = (/&
&5.7327E+02_JPRB,4.2996E+02_JPRB,2.8665E+02_JPRB,1.7045E+02_JPRB,1.5636E+02_JPRB/)
KBO( :, 1,54,16) = (/&
&1.4705E+02_JPRB,1.1956E+02_JPRB,1.3416E+02_JPRB,1.7624E+02_JPRB,2.3498E+02_JPRB/)
KBO( :, 2,54,16) = (/&
&2.2318E+02_JPRB,1.6747E+02_JPRB,1.4694E+02_JPRB,1.6122E+02_JPRB,2.1126E+02_JPRB/)
KBO( :, 3,54,16) = (/&
&3.1471E+02_JPRB,2.3606E+02_JPRB,1.7373E+02_JPRB,1.5475E+02_JPRB,1.9160E+02_JPRB/)
KBO( :, 4,54,16) = (/&
&4.1929E+02_JPRB,3.1449E+02_JPRB,2.1344E+02_JPRB,1.5657E+02_JPRB,1.7506E+02_JPRB/)
KBO( :, 5,54,16) = (/&
&5.3373E+02_JPRB,4.0031E+02_JPRB,2.6690E+02_JPRB,1.6597E+02_JPRB,1.6083E+02_JPRB/)
KBO( :, 1,55,16) = (/&
&1.2631E+02_JPRB,1.0869E+02_JPRB,1.3316E+02_JPRB,1.8286E+02_JPRB,2.4381E+02_JPRB/)
KBO( :, 2,55,16) = (/&
&1.9709E+02_JPRB,1.4921E+02_JPRB,1.4131E+02_JPRB,1.6522E+02_JPRB,2.1865E+02_JPRB/)
KBO( :, 3,55,16) = (/&
&2.8395E+02_JPRB,2.1299E+02_JPRB,1.6360E+02_JPRB,1.5579E+02_JPRB,1.9769E+02_JPRB/)
KBO( :, 4,55,16) = (/&
&3.8466E+02_JPRB,2.8852E+02_JPRB,1.9931E+02_JPRB,1.5501E+02_JPRB,1.8019E+02_JPRB/)
KBO( :, 5,55,16) = (/&
&4.9642E+02_JPRB,3.7233E+02_JPRB,2.4828E+02_JPRB,1.6238E+02_JPRB,1.6531E+02_JPRB/)
KBO( :, 1,56,16) = (/&
&1.0745E+02_JPRB,1.0001E+02_JPRB,1.3351E+02_JPRB,1.8985E+02_JPRB,2.5313E+02_JPRB/)
KBO( :, 2,56,16) = (/&
&1.7263E+02_JPRB,1.3401E+02_JPRB,1.3702E+02_JPRB,1.6999E+02_JPRB,2.2638E+02_JPRB/)
KBO( :, 3,56,16) = (/&
&2.5461E+02_JPRB,1.9098E+02_JPRB,1.5506E+02_JPRB,1.5788E+02_JPRB,2.0410E+02_JPRB/)
KBO( :, 4,56,16) = (/&
&3.5127E+02_JPRB,2.6347E+02_JPRB,1.8679E+02_JPRB,1.5477E+02_JPRB,1.8556E+02_JPRB/)
KBO( :, 5,56,16) = (/&
&4.5985E+02_JPRB,3.4491E+02_JPRB,2.3096E+02_JPRB,1.5935E+02_JPRB,1.6993E+02_JPRB/)
KBO( :, 1,57,16) = (/&
&9.0369E+01_JPRB,9.3013E+01_JPRB,1.3545E+02_JPRB,1.9732E+02_JPRB,2.6309E+02_JPRB/)
KBO( :, 2,57,16) = (/&
&1.4993E+02_JPRB,1.2125E+02_JPRB,1.3471E+02_JPRB,1.7593E+02_JPRB,2.3457E+02_JPRB/)
KBO( :, 3,57,16) = (/&
&2.2676E+02_JPRB,1.7012E+02_JPRB,1.4804E+02_JPRB,1.6118E+02_JPRB,2.1092E+02_JPRB/)
KBO( :, 4,57,16) = (/&
&3.1896E+02_JPRB,2.3925E+02_JPRB,1.7532E+02_JPRB,1.5501E+02_JPRB,1.9130E+02_JPRB/)
KBO( :, 5,57,16) = (/&
&4.2411E+02_JPRB,3.1810E+02_JPRB,2.1552E+02_JPRB,1.5708E+02_JPRB,1.7479E+02_JPRB/)
KBO( :, 1,58,16) = (/&
&7.5798E+01_JPRB,8.7968E+01_JPRB,1.3839E+02_JPRB,2.0486E+02_JPRB,2.7315E+02_JPRB/)
KBO( :, 2,58,16) = (/&
&1.3002E+02_JPRB,1.1067E+02_JPRB,1.3357E+02_JPRB,1.8211E+02_JPRB,2.4282E+02_JPRB/)
KBO( :, 3,58,16) = (/&
&2.0177E+02_JPRB,1.5234E+02_JPRB,1.4243E+02_JPRB,1.6481E+02_JPRB,2.1780E+02_JPRB/)
KBO( :, 4,58,16) = (/&
&2.8967E+02_JPRB,2.1728E+02_JPRB,1.6554E+02_JPRB,1.5580E+02_JPRB,1.9696E+02_JPRB/)
KBO( :, 5,58,16) = (/&
&3.9118E+02_JPRB,2.9340E+02_JPRB,2.0194E+02_JPRB,1.5548E+02_JPRB,1.7957E+02_JPRB/)
KBO( :, 1,59,16) = (/&
&7.0427E+01_JPRB,8.6420E+01_JPRB,1.3992E+02_JPRB,2.0810E+02_JPRB,2.7747E+02_JPRB/)
KBO( :, 2,59,16) = (/&
&1.2257E+02_JPRB,1.0699E+02_JPRB,1.3342E+02_JPRB,1.8471E+02_JPRB,2.4629E+02_JPRB/)
KBO( :, 3,59,16) = (/&
&1.9225E+02_JPRB,1.4609E+02_JPRB,1.4061E+02_JPRB,1.6649E+02_JPRB,2.2067E+02_JPRB/)
KBO( :, 4,59,16) = (/&
&2.7820E+02_JPRB,2.0868E+02_JPRB,1.6196E+02_JPRB,1.5644E+02_JPRB,1.9936E+02_JPRB/)
KBO( :, 5,59,16) = (/&
&3.7829E+02_JPRB,2.8373E+02_JPRB,1.9693E+02_JPRB,1.5516E+02_JPRB,1.8158E+02_JPRB/)


!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
&1.27664E-01_JPRB, 1.09296E-01_JPRB, 9.35703E-02_JPRB, 8.01075E-02_JPRB, 6.85818E-02_JPRB,&
&5.87143E-02_JPRB, 5.02666E-02_JPRB, 4.30343E-02_JPRB, 3.68426E-02_JPRB, 3.15417E-02_JPRB/)
SELFREFO( :, 2) = (/&
&1.39620E-01_JPRB, 1.20381E-01_JPRB, 1.03793E-01_JPRB, 8.94908E-02_JPRB, 7.71595E-02_JPRB,&
&6.65273E-02_JPRB, 5.73601E-02_JPRB, 4.94562E-02_JPRB, 4.26414E-02_JPRB, 3.67656E-02_JPRB/)
SELFREFO( :, 3) = (/&
&1.42628E-01_JPRB, 1.23043E-01_JPRB, 1.06148E-01_JPRB, 9.15726E-02_JPRB, 7.89986E-02_JPRB,&
&6.81511E-02_JPRB, 5.87931E-02_JPRB, 5.07201E-02_JPRB, 4.37556E-02_JPRB, 3.77474E-02_JPRB/)
SELFREFO( :, 4) = (/&
&1.53569E-01_JPRB, 1.33143E-01_JPRB, 1.15435E-01_JPRB, 1.00082E-01_JPRB, 8.67706E-02_JPRB,&
&7.52299E-02_JPRB, 6.52241E-02_JPRB, 5.65491E-02_JPRB, 4.90279E-02_JPRB, 4.25070E-02_JPRB/)
SELFREFO( :, 5) = (/&
&1.70491E-01_JPRB, 1.46448E-01_JPRB, 1.25796E-01_JPRB, 1.08056E-01_JPRB, 9.28182E-02_JPRB,&
&7.97290E-02_JPRB, 6.84856E-02_JPRB, 5.88278E-02_JPRB, 5.05319E-02_JPRB, 4.34059E-02_JPRB/)
SELFREFO( :, 6) = (/&
&1.76394E-01_JPRB, 1.51432E-01_JPRB, 1.30003E-01_JPRB, 1.11606E-01_JPRB, 9.58127E-02_JPRB,&
&8.22542E-02_JPRB, 7.06144E-02_JPRB, 6.06217E-02_JPRB, 5.20431E-02_JPRB, 4.46784E-02_JPRB/)
SELFREFO( :, 7) = (/&
&1.85706E-01_JPRB, 1.59172E-01_JPRB, 1.36429E-01_JPRB, 1.16936E-01_JPRB, 1.00228E-01_JPRB,&
&8.59068E-02_JPRB, 7.36322E-02_JPRB, 6.31114E-02_JPRB, 5.40939E-02_JPRB, 4.63648E-02_JPRB/)
SELFREFO( :, 8) = (/&
&1.88647E-01_JPRB, 1.61657E-01_JPRB, 1.38529E-01_JPRB, 1.18710E-01_JPRB, 1.01726E-01_JPRB,&
&8.71722E-02_JPRB, 7.47005E-02_JPRB, 6.40132E-02_JPRB, 5.48549E-02_JPRB, 4.70068E-02_JPRB/)
SELFREFO( :, 9) = (/&
&1.90074E-01_JPRB, 1.62793E-01_JPRB, 1.39427E-01_JPRB, 1.19415E-01_JPRB, 1.02275E-01_JPRB,&
&8.75959E-02_JPRB, 7.50233E-02_JPRB, 6.42552E-02_JPRB, 5.50327E-02_JPRB, 4.71338E-02_JPRB/)
SELFREFO( :,10) = (/&
&1.94769E-01_JPRB, 1.66338E-01_JPRB, 1.42057E-01_JPRB, 1.21320E-01_JPRB, 1.03611E-01_JPRB,&
&8.84863E-02_JPRB, 7.55696E-02_JPRB, 6.45384E-02_JPRB, 5.51175E-02_JPRB, 4.70718E-02_JPRB/)
SELFREFO( :,11) = (/&
&1.90624E-01_JPRB, 1.64229E-01_JPRB, 1.41488E-01_JPRB, 1.21896E-01_JPRB, 1.05017E-01_JPRB,&
&9.04757E-02_JPRB, 7.79475E-02_JPRB, 6.71542E-02_JPRB, 5.78554E-02_JPRB, 4.98442E-02_JPRB/)
SELFREFO( :,12) = (/&
&1.90502E-01_JPRB, 1.64025E-01_JPRB, 1.41228E-01_JPRB, 1.21599E-01_JPRB, 1.04699E-01_JPRB,&
&9.01472E-02_JPRB, 7.76181E-02_JPRB, 6.68303E-02_JPRB, 5.75419E-02_JPRB, 4.95444E-02_JPRB/)
SELFREFO( :,13) = (/&
&1.86786E-01_JPRB, 1.61636E-01_JPRB, 1.39872E-01_JPRB, 1.21039E-01_JPRB, 1.04741E-01_JPRB,&
&9.06380E-02_JPRB, 7.84338E-02_JPRB, 6.78729E-02_JPRB, 5.87340E-02_JPRB, 5.08256E-02_JPRB/)
SELFREFO( :,14) = (/&
&1.99149E-01_JPRB, 1.71475E-01_JPRB, 1.47646E-01_JPRB, 1.27129E-01_JPRB, 1.09462E-01_JPRB,&
&9.42512E-02_JPRB, 8.11538E-02_JPRB, 6.98764E-02_JPRB, 6.01662E-02_JPRB, 5.18053E-02_JPRB/)
SELFREFO( :,15) = (/&
&2.02676E-01_JPRB, 1.73701E-01_JPRB, 1.48869E-01_JPRB, 1.27587E-01_JPRB, 1.09347E-01_JPRB,&
&9.37144E-02_JPRB, 8.03170E-02_JPRB, 6.88348E-02_JPRB, 5.89941E-02_JPRB, 5.05603E-02_JPRB/)
SELFREFO( :,16) = (/&
&1.99865E-01_JPRB, 1.72699E-01_JPRB, 1.49225E-01_JPRB, 1.28942E-01_JPRB, 1.11416E-01_JPRB,&
&9.62721E-02_JPRB, 8.31866E-02_JPRB, 7.18797E-02_JPRB, 6.21097E-02_JPRB, 5.36676E-02_JPRB/)      

FRACREFAO( :, 1) = (/&
!     From P = 387.6 mb.
    &0.13966499_JPRB,0.14138900_JPRB,0.13763399_JPRB,0.13076700_JPRB,&
    &0.12299100_JPRB,0.10747700_JPRB,0.08942000_JPRB,0.06769200_JPRB,&
    &0.04587610_JPRB,0.00501173_JPRB,0.00415809_JPRB,0.00328398_JPRB,&
    &0.00240015_JPRB,0.00156222_JPRB,0.00059104_JPRB,0.00008323_JPRB/)
FRACREFAO( :, 2) = (/&
    &0.13958199_JPRB,0.14332899_JPRB,0.13785399_JPRB,0.13205400_JPRB,&
    &0.12199700_JPRB,0.10679600_JPRB,0.08861080_JPRB,0.06712320_JPRB,&
    &0.04556030_JPRB,0.00500863_JPRB,0.00416315_JPRB,0.00328629_JPRB,&
    &0.00240023_JPRB,0.00156220_JPRB,0.00059104_JPRB,0.00008323_JPRB/)
FRACREFAO( :, 3) = (/&
    &0.13907100_JPRB,0.14250501_JPRB,0.13889600_JPRB,0.13297300_JPRB,&
    &0.12218700_JPRB,0.10683800_JPRB,0.08839260_JPRB,0.06677310_JPRB,&
    &0.04538570_JPRB,0.00495402_JPRB,0.00409863_JPRB,0.00328219_JPRB,&
    &0.00240805_JPRB,0.00156266_JPRB,0.00059104_JPRB,0.00008323_JPRB/)
FRACREFAO( :, 4) = (/&
    &0.13867700_JPRB,0.14190100_JPRB,0.13932300_JPRB,0.13327099_JPRB,&
    &0.12280800_JPRB,0.10692500_JPRB,0.08844510_JPRB,0.06658510_JPRB,&
    &0.04519340_JPRB,0.00492276_JPRB,0.00408832_JPRB,0.00323856_JPRB,&
    &0.00239289_JPRB,0.00155698_JPRB,0.00059104_JPRB,0.00008323_JPRB/)
FRACREFAO( :, 5) = (/&
    &0.13845000_JPRB,0.14158800_JPRB,0.13929300_JPRB,0.13295600_JPRB,&
    &0.12348300_JPRB,0.10736700_JPRB,0.08859480_JPRB,0.06650610_JPRB,&
    &0.04498230_JPRB,0.00491335_JPRB,0.00406968_JPRB,0.00322901_JPRB,&
    &0.00234666_JPRB,0.00155235_JPRB,0.00058813_JPRB,0.00008323_JPRB/)
FRACREFAO( :, 6) = (/&
    &0.13837101_JPRB,0.14113200_JPRB,0.13930500_JPRB,0.13283101_JPRB,&
    &0.12349200_JPRB,0.10796400_JPRB,0.08890490_JPRB,0.06646480_JPRB,&
    &0.04485990_JPRB,0.00489554_JPRB,0.00405264_JPRB,0.00320313_JPRB,&
    &0.00234742_JPRB,0.00151159_JPRB,0.00058438_JPRB,0.00008253_JPRB/)
FRACREFAO( :, 7) = (/&
    &0.13834500_JPRB,0.14093500_JPRB,0.13896500_JPRB,0.13262001_JPRB,&
    &0.12326900_JPRB,0.10828900_JPRB,0.08950050_JPRB,0.06674610_JPRB,&
    &0.04476560_JPRB,0.00489624_JPRB,0.00400962_JPRB,0.00317423_JPRB,&
    &0.00233479_JPRB,0.00148249_JPRB,0.00058590_JPRB,0.00008253_JPRB/)
FRACREFAO( :, 8) = (/&
    &0.13831300_JPRB,0.14069000_JPRB,0.13871400_JPRB,0.13247600_JPRB,&
    &0.12251400_JPRB,0.10831300_JPRB,0.08977090_JPRB,0.06776920_JPRB,&
    &0.04498390_JPRB,0.00484111_JPRB,0.00398948_JPRB,0.00316069_JPRB,&
    &0.00229741_JPRB,0.00150104_JPRB,0.00058608_JPRB,0.00008253_JPRB/)
FRACREFAO( :, 9) = (/&
    &0.14027201_JPRB,0.14420401_JPRB,0.14215700_JPRB,0.13446601_JPRB,&
    &0.12303700_JPRB,0.10596100_JPRB,0.08650370_JPRB,0.06409570_JPRB,&
    &0.04312310_JPRB,0.00471110_JPRB,0.00393954_JPRB,0.00310850_JPRB,&
    &0.00229588_JPRB,0.00146366_JPRB,0.00058194_JPRB,0.00008253_JPRB/)

FRACREFBO( :, 1) = (/&
!     From P = 1.17 mb.
    &0.14339100_JPRB,0.14358699_JPRB,0.13935301_JPRB,0.13306700_JPRB,&
    &0.12135700_JPRB,0.10590600_JPRB,0.08688240_JPRB,0.06553220_JPRB,&
    &0.04446740_JPRB,0.00483580_JPRB,0.00399413_JPRB,0.00316225_JPRB,&
    &0.00233007_JPRB,0.00149135_JPRB,0.00056246_JPRB,0.00008059_JPRB/)
FRACREFBO( :, 2) = (/&
    &0.14330500_JPRB,0.14430299_JPRB,0.14053699_JPRB,0.13355300_JPRB,&
    &0.12151200_JPRB,0.10529100_JPRB,0.08627630_JPRB,0.06505230_JPRB,&
    &0.04385850_JPRB,0.00476555_JPRB,0.00395010_JPRB,0.00313878_JPRB,&
    &0.00232273_JPRB,0.00149354_JPRB,0.00056246_JPRB,0.00008059_JPRB/)
FRACREFBO( :, 3) = (/&
    &0.14328399_JPRB,0.14442700_JPRB,0.14078601_JPRB,0.13390100_JPRB,&
    &0.12132600_JPRB,0.10510600_JPRB,0.08613660_JPRB,0.06494630_JPRB,&
    &0.04381310_JPRB,0.00475378_JPRB,0.00394166_JPRB,0.00313076_JPRB,&
    &0.00231235_JPRB,0.00149159_JPRB,0.00056301_JPRB,0.00008059_JPRB/)
FRACREFBO( :, 4) = (/&
    &0.14326900_JPRB,0.14453100_JPRB,0.14114200_JPRB,0.13397101_JPRB,&
    &0.12127200_JPRB,0.10493400_JPRB,0.08601380_JPRB,0.06483360_JPRB,&
    &0.04378900_JPRB,0.00474655_JPRB,0.00393549_JPRB,0.00312583_JPRB,&
    &0.00230686_JPRB,0.00148433_JPRB,0.00056502_JPRB,0.00008059_JPRB/)
FRACREFBO( :, 5) = (/&
    &0.14328900_JPRB,0.14532700_JPRB,0.14179000_JPRB,0.13384600_JPRB,&
    &0.12093700_JPRB,0.10461500_JPRB,0.08573010_JPRB,0.06461340_JPRB,&
    &0.04366570_JPRB,0.00473087_JPRB,0.00392539_JPRB,0.00311238_JPRB,&
    &0.00229865_JPRB,0.00147572_JPRB,0.00056517_JPRB,0.00007939_JPRB/)

!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB5
