!OCL SCALAR
SUBROUTINE RRTM_KGB4

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 4:  630-700 cm-1 (low - H2O,CO2; high - O3,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO4 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,FRACREFBO
USE YOERRTA4 , ONLY : STRRAT1   ,STRRAT2

!     ------------------------------------------------------------------


IMPLICIT NONE
STRRAT1 = 850.577_JPRB
STRRAT2 = 35.7416_JPRB

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 9 and corresponds to different water vapor to CO2 ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = h2o/(h20 + (rat) * co2), where rat is the ratio of the integrated
!     line strength in the band of co2 to that of h2o.  For instance,
!     JS=1 refers to dry air (eta = 0), JS = 9 corresponds to eta = 1.0.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15,
!     JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 1) = (/&
&6.6520E-04_JPRB,9.3651E-04_JPRB,1.4195E-03_JPRB,1.7255E-03_JPRB,1.7636E-03_JPRB,1.9179E-03_JPRB,&
&2.2204E-03_JPRB,6.6521E-04_JPRB,2.9560E-04_JPRB/)
KAO( :, 2, 1, 1) = (/&
&7.2624E-04_JPRB,1.0466E-03_JPRB,1.3888E-03_JPRB,1.7096E-03_JPRB,1.7897E-03_JPRB,1.8561E-03_JPRB,&
&2.1300E-03_JPRB,7.2624E-04_JPRB,3.1103E-04_JPRB/)
KAO( :, 3, 1, 1) = (/&
&7.8383E-04_JPRB,1.1584E-03_JPRB,1.4071E-03_JPRB,1.6420E-03_JPRB,1.7160E-03_JPRB,1.8518E-03_JPRB,&
&1.8802E-03_JPRB,7.8382E-04_JPRB,3.3914E-04_JPRB/)
KAO( :, 4, 1, 1) = (/&
&8.3828E-04_JPRB,1.2570E-03_JPRB,1.4277E-03_JPRB,1.5406E-03_JPRB,1.6601E-03_JPRB,1.7661E-03_JPRB,&
&1.9135E-03_JPRB,8.3828E-04_JPRB,3.4976E-04_JPRB/)
KAO( :, 5, 1, 1) = (/&
&8.9042E-04_JPRB,1.3363E-03_JPRB,1.4623E-03_JPRB,1.4949E-03_JPRB,1.5948E-03_JPRB,1.7209E-03_JPRB,&
&1.8800E-03_JPRB,8.9042E-04_JPRB,3.6339E-04_JPRB/)
KAO( :, 1, 2, 1) = (/&
&5.6062E-04_JPRB,7.7127E-04_JPRB,1.2084E-03_JPRB,1.4307E-03_JPRB,1.4610E-03_JPRB,1.6052E-03_JPRB,&
&1.8465E-03_JPRB,5.6064E-04_JPRB,2.2622E-04_JPRB/)
KAO( :, 2, 2, 1) = (/&
&6.1375E-04_JPRB,8.6380E-04_JPRB,1.1701E-03_JPRB,1.4336E-03_JPRB,1.4895E-03_JPRB,1.5756E-03_JPRB,&
&1.7789E-03_JPRB,6.1375E-04_JPRB,2.4137E-04_JPRB/)
KAO( :, 3, 2, 1) = (/&
&6.6443E-04_JPRB,9.5953E-04_JPRB,1.1781E-03_JPRB,1.4158E-03_JPRB,1.4693E-03_JPRB,1.5606E-03_JPRB,&
&1.5694E-03_JPRB,6.6443E-04_JPRB,2.6320E-04_JPRB/)
KAO( :, 4, 2, 1) = (/&
&7.1315E-04_JPRB,1.0478E-03_JPRB,1.1975E-03_JPRB,1.3128E-03_JPRB,1.4207E-03_JPRB,1.5299E-03_JPRB,&
&1.6204E-03_JPRB,7.1315E-04_JPRB,2.6697E-04_JPRB/)
KAO( :, 5, 2, 1) = (/&
&7.6110E-04_JPRB,1.1196E-03_JPRB,1.2294E-03_JPRB,1.2636E-03_JPRB,1.3416E-03_JPRB,1.4292E-03_JPRB,&
&1.6103E-03_JPRB,7.6110E-04_JPRB,2.8176E-04_JPRB/)
KAO( :, 1, 3, 1) = (/&
&4.5610E-04_JPRB,6.1532E-04_JPRB,1.0634E-03_JPRB,1.1828E-03_JPRB,1.2321E-03_JPRB,1.3407E-03_JPRB,&
&1.5585E-03_JPRB,4.5610E-04_JPRB,1.7188E-04_JPRB/)
KAO( :, 2, 3, 1) = (/&
&5.0238E-04_JPRB,6.9021E-04_JPRB,9.8179E-04_JPRB,1.2124E-03_JPRB,1.2375E-03_JPRB,1.3359E-03_JPRB,&
&1.5396E-03_JPRB,5.0238E-04_JPRB,1.8492E-04_JPRB/)
KAO( :, 3, 3, 1) = (/&
&5.4735E-04_JPRB,7.7249E-04_JPRB,9.8402E-04_JPRB,1.2068E-03_JPRB,1.2546E-03_JPRB,1.2975E-03_JPRB,&
&1.4283E-03_JPRB,5.4735E-04_JPRB,1.9939E-04_JPRB/)
KAO( :, 4, 3, 1) = (/&
&5.9112E-04_JPRB,8.5275E-04_JPRB,9.9833E-04_JPRB,1.1432E-03_JPRB,1.2143E-03_JPRB,1.3053E-03_JPRB,&
&1.3316E-03_JPRB,5.9111E-04_JPRB,2.0334E-04_JPRB/)
KAO( :, 5, 3, 1) = (/&
&6.3422E-04_JPRB,9.1933E-04_JPRB,1.0199E-03_JPRB,1.0852E-03_JPRB,1.1540E-03_JPRB,1.2145E-03_JPRB,&
&1.3760E-03_JPRB,6.3422E-04_JPRB,2.1583E-04_JPRB/)
KAO( :, 1, 4, 1) = (/&
&3.6423E-04_JPRB,4.8714E-04_JPRB,9.4139E-04_JPRB,9.6507E-04_JPRB,9.9104E-04_JPRB,1.0740E-03_JPRB,&
&1.2797E-03_JPRB,3.6423E-04_JPRB,1.3905E-04_JPRB/)
KAO( :, 2, 4, 1) = (/&
&4.0448E-04_JPRB,5.4353E-04_JPRB,8.4041E-04_JPRB,9.9900E-04_JPRB,1.0270E-03_JPRB,1.1129E-03_JPRB,&
&1.2594E-03_JPRB,4.0448E-04_JPRB,1.4875E-04_JPRB/)
KAO( :, 3, 4, 1) = (/&
&4.4401E-04_JPRB,6.1201E-04_JPRB,8.1748E-04_JPRB,1.0205E-03_JPRB,1.0406E-03_JPRB,1.0943E-03_JPRB,&
&1.2249E-03_JPRB,4.4401E-04_JPRB,1.5559E-04_JPRB/)
KAO( :, 4, 4, 1) = (/&
&4.8291E-04_JPRB,6.8107E-04_JPRB,8.2218E-04_JPRB,9.9576E-04_JPRB,1.0515E-03_JPRB,1.1006E-03_JPRB,&
&1.1252E-03_JPRB,4.8291E-04_JPRB,1.6190E-04_JPRB/)
KAO( :, 5, 4, 1) = (/&
&5.2123E-04_JPRB,7.4343E-04_JPRB,8.4151E-04_JPRB,9.3019E-04_JPRB,1.0130E-03_JPRB,1.0785E-03_JPRB,&
&1.1439E-03_JPRB,5.2123E-04_JPRB,1.7165E-04_JPRB/)
KAO( :, 1, 5, 1) = (/&
&2.8763E-04_JPRB,3.8654E-04_JPRB,7.7838E-04_JPRB,7.8467E-04_JPRB,8.0817E-04_JPRB,8.9938E-04_JPRB,&
&1.0676E-03_JPRB,2.8763E-04_JPRB,1.2485E-04_JPRB/)
KAO( :, 2, 5, 1) = (/&
&3.2269E-04_JPRB,4.2830E-04_JPRB,7.4590E-04_JPRB,8.1887E-04_JPRB,8.5674E-04_JPRB,9.1744E-04_JPRB,&
&1.0598E-03_JPRB,3.2269E-04_JPRB,1.2888E-04_JPRB/)
KAO( :, 3, 5, 1) = (/&
&3.5710E-04_JPRB,4.8150E-04_JPRB,6.8301E-04_JPRB,8.4014E-04_JPRB,8.5447E-04_JPRB,9.4082E-04_JPRB,&
&1.0595E-03_JPRB,3.5710E-04_JPRB,1.3287E-04_JPRB/)
KAO( :, 4, 5, 1) = (/&
&3.9114E-04_JPRB,5.4044E-04_JPRB,6.7913E-04_JPRB,8.5598E-04_JPRB,8.6451E-04_JPRB,8.9768E-04_JPRB,&
&1.0160E-03_JPRB,3.9114E-04_JPRB,1.3801E-04_JPRB/)
KAO( :, 5, 5, 1) = (/&
&4.2493E-04_JPRB,5.9616E-04_JPRB,6.9081E-04_JPRB,8.1432E-04_JPRB,8.7086E-04_JPRB,9.0230E-04_JPRB,&
&9.2751E-04_JPRB,4.2493E-04_JPRB,1.4524E-04_JPRB/)
KAO( :, 1, 6, 1) = (/&
&2.2397E-04_JPRB,3.0352E-04_JPRB,6.2893E-04_JPRB,6.2633E-04_JPRB,6.5793E-04_JPRB,7.3403E-04_JPRB,&
&8.4350E-04_JPRB,2.2397E-04_JPRB,1.2107E-04_JPRB/)
KAO( :, 2, 6, 1) = (/&
&2.5420E-04_JPRB,3.3557E-04_JPRB,6.5797E-04_JPRB,6.6891E-04_JPRB,6.8491E-04_JPRB,7.4023E-04_JPRB,&
&8.5687E-04_JPRB,2.5420E-04_JPRB,1.2280E-04_JPRB/)
KAO( :, 3, 6, 1) = (/&
&2.8396E-04_JPRB,3.7655E-04_JPRB,5.9102E-04_JPRB,6.9033E-04_JPRB,7.1783E-04_JPRB,7.6667E-04_JPRB,&
&8.6376E-04_JPRB,2.8396E-04_JPRB,1.2577E-04_JPRB/)
KAO( :, 4, 6, 1) = (/&
&3.1350E-04_JPRB,4.2404E-04_JPRB,5.6109E-04_JPRB,7.1632E-04_JPRB,7.2169E-04_JPRB,7.5902E-04_JPRB,&
&8.5063E-04_JPRB,3.1350E-04_JPRB,1.3038E-04_JPRB/)
KAO( :, 5, 6, 1) = (/&
&3.4283E-04_JPRB,4.7259E-04_JPRB,5.6315E-04_JPRB,6.9669E-04_JPRB,7.3767E-04_JPRB,7.6266E-04_JPRB,&
&8.1179E-04_JPRB,3.4283E-04_JPRB,1.3594E-04_JPRB/)
KAO( :, 1, 7, 1) = (/&
&1.7269E-04_JPRB,2.3971E-04_JPRB,5.0297E-04_JPRB,4.9860E-04_JPRB,5.2471E-04_JPRB,5.7932E-04_JPRB,&
&6.8439E-04_JPRB,1.7269E-04_JPRB,1.2386E-04_JPRB/)
KAO( :, 2, 7, 1) = (/&
&1.9843E-04_JPRB,2.6259E-04_JPRB,5.3532E-04_JPRB,5.3729E-04_JPRB,5.5606E-04_JPRB,6.0939E-04_JPRB,&
&7.1230E-04_JPRB,1.9843E-04_JPRB,1.2615E-04_JPRB/)
KAO( :, 3, 7, 1) = (/&
&2.2393E-04_JPRB,2.9362E-04_JPRB,5.3350E-04_JPRB,5.6384E-04_JPRB,5.8750E-04_JPRB,6.2580E-04_JPRB,&
&7.2255E-04_JPRB,2.2393E-04_JPRB,1.3021E-04_JPRB/)
KAO( :, 4, 7, 1) = (/&
&2.4925E-04_JPRB,3.3156E-04_JPRB,4.6934E-04_JPRB,5.8250E-04_JPRB,5.9359E-04_JPRB,6.5453E-04_JPRB,&
&7.2305E-04_JPRB,2.4925E-04_JPRB,1.3523E-04_JPRB/)
KAO( :, 5, 7, 1) = (/&
&2.7472E-04_JPRB,3.7184E-04_JPRB,4.6283E-04_JPRB,5.9977E-04_JPRB,6.0303E-04_JPRB,6.2094E-04_JPRB,&
&7.0629E-04_JPRB,2.7472E-04_JPRB,1.4126E-04_JPRB/)
KAO( :, 1, 8, 1) = (/&
&1.3221E-04_JPRB,1.9199E-04_JPRB,3.9770E-04_JPRB,3.9939E-04_JPRB,4.1807E-04_JPRB,4.5731E-04_JPRB,&
&5.2988E-04_JPRB,1.3221E-04_JPRB,1.4509E-04_JPRB/)
KAO( :, 2, 8, 1) = (/&
&1.5393E-04_JPRB,2.0559E-04_JPRB,4.3250E-04_JPRB,4.2908E-04_JPRB,4.4968E-04_JPRB,4.9581E-04_JPRB,&
&5.6885E-04_JPRB,1.5393E-04_JPRB,1.5038E-04_JPRB/)
KAO( :, 3, 8, 1) = (/&
&1.7558E-04_JPRB,2.2912E-04_JPRB,4.5525E-04_JPRB,4.5996E-04_JPRB,4.7140E-04_JPRB,5.1385E-04_JPRB,&
&5.9033E-04_JPRB,1.7558E-04_JPRB,1.5764E-04_JPRB/)
KAO( :, 4, 8, 1) = (/&
&1.9711E-04_JPRB,2.5824E-04_JPRB,4.0990E-04_JPRB,4.7600E-04_JPRB,4.9383E-04_JPRB,5.2727E-04_JPRB,&
&5.9173E-04_JPRB,1.9711E-04_JPRB,1.6674E-04_JPRB/)
KAO( :, 5, 8, 1) = (/&
&2.1892E-04_JPRB,2.9157E-04_JPRB,3.8268E-04_JPRB,4.9451E-04_JPRB,4.9883E-04_JPRB,5.2700E-04_JPRB,&
&5.9438E-04_JPRB,2.1892E-04_JPRB,1.7746E-04_JPRB/)
KAO( :, 1, 9, 1) = (/&
&1.0035E-04_JPRB,1.5952E-04_JPRB,3.1293E-04_JPRB,3.1348E-04_JPRB,3.2666E-04_JPRB,3.7028E-04_JPRB,&
&4.1425E-04_JPRB,1.0035E-04_JPRB,2.6669E-04_JPRB/)
KAO( :, 2, 9, 1) = (/&
&1.1858E-04_JPRB,1.6346E-04_JPRB,3.4529E-04_JPRB,3.4165E-04_JPRB,3.5657E-04_JPRB,3.9289E-04_JPRB,&
&4.5949E-04_JPRB,1.1858E-04_JPRB,2.9076E-04_JPRB/)
KAO( :, 3, 9, 1) = (/&
&1.3693E-04_JPRB,1.7866E-04_JPRB,3.6700E-04_JPRB,3.7083E-04_JPRB,3.8336E-04_JPRB,4.1668E-04_JPRB,&
&4.8180E-04_JPRB,1.3693E-04_JPRB,3.1567E-04_JPRB/)
KAO( :, 4, 9, 1) = (/&
&1.5518E-04_JPRB,2.0111E-04_JPRB,3.6635E-04_JPRB,3.8855E-04_JPRB,4.0471E-04_JPRB,4.3043E-04_JPRB,&
&4.9285E-04_JPRB,1.5518E-04_JPRB,3.4209E-04_JPRB/)
KAO( :, 5, 9, 1) = (/&
&1.7362E-04_JPRB,2.2754E-04_JPRB,3.2201E-04_JPRB,4.0291E-04_JPRB,4.1258E-04_JPRB,4.4913E-04_JPRB,&
&4.9613E-04_JPRB,1.7362E-04_JPRB,3.6921E-04_JPRB/)
KAO( :, 1,10, 1) = (/&
&7.6756E-05_JPRB,1.3962E-04_JPRB,2.4767E-04_JPRB,2.4912E-04_JPRB,2.5968E-04_JPRB,2.8653E-04_JPRB,&
&3.2992E-04_JPRB,7.6756E-05_JPRB,9.2332E-04_JPRB/)
KAO( :, 2,10, 1) = (/&
&9.1972E-05_JPRB,1.3177E-04_JPRB,2.7498E-04_JPRB,2.7460E-04_JPRB,2.8768E-04_JPRB,3.1486E-04_JPRB,&
&3.6117E-04_JPRB,9.1972E-05_JPRB,1.0290E-03_JPRB/)
KAO( :, 3,10, 1) = (/&
&1.0747E-04_JPRB,1.4129E-04_JPRB,2.9762E-04_JPRB,2.9728E-04_JPRB,3.1080E-04_JPRB,3.3927E-04_JPRB,&
&3.8542E-04_JPRB,1.0747E-04_JPRB,1.1258E-03_JPRB/)
KAO( :, 4,10, 1) = (/&
&1.2295E-04_JPRB,1.5843E-04_JPRB,3.0850E-04_JPRB,3.1535E-04_JPRB,3.2529E-04_JPRB,3.5387E-04_JPRB,&
&4.0422E-04_JPRB,1.2295E-04_JPRB,1.2119E-03_JPRB/)
KAO( :, 5,10, 1) = (/&
&1.3850E-04_JPRB,1.7919E-04_JPRB,2.7969E-04_JPRB,3.2918E-04_JPRB,3.4141E-04_JPRB,3.6383E-04_JPRB,&
&4.0592E-04_JPRB,1.3850E-04_JPRB,1.2885E-03_JPRB/)
KAO( :, 1,11, 1) = (/&
&6.4262E-05_JPRB,1.1488E-04_JPRB,2.0652E-04_JPRB,2.0693E-04_JPRB,2.1515E-04_JPRB,2.3759E-04_JPRB,&
&2.7074E-04_JPRB,6.4262E-05_JPRB,1.7436E-03_JPRB/)
KAO( :, 2,11, 1) = (/&
&7.7063E-05_JPRB,1.0910E-04_JPRB,2.2893E-04_JPRB,2.2837E-04_JPRB,2.3880E-04_JPRB,2.5987E-04_JPRB,&
&3.0065E-04_JPRB,7.7062E-05_JPRB,1.9352E-03_JPRB/)
KAO( :, 3,11, 1) = (/&
&9.0126E-05_JPRB,1.1759E-04_JPRB,2.4677E-04_JPRB,2.4752E-04_JPRB,2.5932E-04_JPRB,2.8168E-04_JPRB,&
&3.2064E-04_JPRB,9.0126E-05_JPRB,2.1015E-03_JPRB/)
KAO( :, 4,11, 1) = (/&
&1.0318E-04_JPRB,1.3204E-04_JPRB,2.5349E-04_JPRB,2.6117E-04_JPRB,2.7047E-04_JPRB,2.9445E-04_JPRB,&
&3.3354E-04_JPRB,1.0318E-04_JPRB,2.2375E-03_JPRB/)
KAO( :, 5,11, 1) = (/&
&1.1625E-04_JPRB,1.4979E-04_JPRB,2.3047E-04_JPRB,2.7288E-04_JPRB,2.8316E-04_JPRB,3.0222E-04_JPRB,&
&3.3717E-04_JPRB,1.1625E-04_JPRB,2.3499E-03_JPRB/)
KAO( :, 1,12, 1) = (/&
&5.3838E-05_JPRB,9.4472E-05_JPRB,1.7221E-04_JPRB,1.7229E-04_JPRB,1.7912E-04_JPRB,1.9811E-04_JPRB,&
&2.2298E-04_JPRB,5.3838E-05_JPRB,2.2190E-03_JPRB/)
KAO( :, 2,12, 1) = (/&
&6.4583E-05_JPRB,9.0416E-05_JPRB,1.9070E-04_JPRB,1.8997E-04_JPRB,1.9851E-04_JPRB,2.1621E-04_JPRB,&
&2.4883E-04_JPRB,6.4583E-05_JPRB,2.4508E-03_JPRB/)
KAO( :, 3,12, 1) = (/&
&7.5579E-05_JPRB,9.8146E-05_JPRB,2.0479E-04_JPRB,2.0556E-04_JPRB,2.1508E-04_JPRB,2.3475E-04_JPRB,&
&2.6564E-04_JPRB,7.5579E-05_JPRB,2.6460E-03_JPRB/)
KAO( :, 4,12, 1) = (/&
&8.6531E-05_JPRB,1.1008E-04_JPRB,2.0887E-04_JPRB,2.1630E-04_JPRB,2.2430E-04_JPRB,2.4416E-04_JPRB,&
&2.7688E-04_JPRB,8.6531E-05_JPRB,2.8013E-03_JPRB/)
KAO( :, 5,12, 1) = (/&
&9.7427E-05_JPRB,1.2490E-04_JPRB,1.8859E-04_JPRB,2.2596E-04_JPRB,2.3336E-04_JPRB,2.5057E-04_JPRB,&
&2.7888E-04_JPRB,9.7427E-05_JPRB,2.9236E-03_JPRB/)
KAO( :, 1,13, 1) = (/&
&4.5099E-05_JPRB,7.7513E-05_JPRB,1.4325E-04_JPRB,1.4387E-04_JPRB,1.4900E-04_JPRB,1.6404E-04_JPRB,&
&1.8470E-04_JPRB,4.5100E-05_JPRB,2.3136E-03_JPRB/)
KAO( :, 2,13, 1) = (/&
&5.4137E-05_JPRB,7.5163E-05_JPRB,1.5870E-04_JPRB,1.5797E-04_JPRB,1.6505E-04_JPRB,1.7934E-04_JPRB,&
&2.0687E-04_JPRB,5.4137E-05_JPRB,2.5403E-03_JPRB/)
KAO( :, 3,13, 1) = (/&
&6.3329E-05_JPRB,8.1727E-05_JPRB,1.6965E-04_JPRB,1.7063E-04_JPRB,1.7871E-04_JPRB,1.9512E-04_JPRB,&
&2.2035E-04_JPRB,6.3329E-05_JPRB,2.7282E-03_JPRB/)
KAO( :, 4,13, 1) = (/&
&7.2450E-05_JPRB,9.1778E-05_JPRB,1.7219E-04_JPRB,1.7914E-04_JPRB,1.8635E-04_JPRB,2.0203E-04_JPRB,&
&2.2943E-04_JPRB,7.2450E-05_JPRB,2.8788E-03_JPRB/)
KAO( :, 5,13, 1) = (/&
&8.1530E-05_JPRB,1.0397E-04_JPRB,1.5476E-04_JPRB,1.8739E-04_JPRB,1.9322E-04_JPRB,2.0819E-04_JPRB,&
&2.3071E-04_JPRB,8.1530E-05_JPRB,2.9950E-03_JPRB/)
KAO( :, 1, 1, 2) = (/&
&1.5260E-03_JPRB,1.7595E-03_JPRB,1.6480E-03_JPRB,2.2258E-03_JPRB,2.8344E-03_JPRB,3.1469E-03_JPRB,&
&3.6918E-03_JPRB,1.5260E-03_JPRB,4.9914E-04_JPRB/)
KAO( :, 2, 1, 2) = (/&
&1.5826E-03_JPRB,1.8212E-03_JPRB,1.7561E-03_JPRB,1.9980E-03_JPRB,2.4681E-03_JPRB,2.9684E-03_JPRB,&
&3.2872E-03_JPRB,1.5826E-03_JPRB,4.6415E-04_JPRB/)
KAO( :, 3, 1, 2) = (/&
&1.6227E-03_JPRB,1.8571E-03_JPRB,1.8350E-03_JPRB,1.9032E-03_JPRB,2.3046E-03_JPRB,2.7220E-03_JPRB,&
&3.3030E-03_JPRB,1.6227E-03_JPRB,4.6231E-04_JPRB/)
KAO( :, 4, 1, 2) = (/&
&1.6627E-03_JPRB,1.9016E-03_JPRB,1.9450E-03_JPRB,1.9945E-03_JPRB,2.2414E-03_JPRB,2.5327E-03_JPRB,&
&2.8363E-03_JPRB,1.6627E-03_JPRB,4.9516E-04_JPRB/)
KAO( :, 5, 1, 2) = (/&
&1.6942E-03_JPRB,1.9567E-03_JPRB,2.0282E-03_JPRB,2.1178E-03_JPRB,2.1837E-03_JPRB,2.3289E-03_JPRB,&
&2.6951E-03_JPRB,1.6942E-03_JPRB,5.5604E-04_JPRB/)
KAO( :, 1, 2, 2) = (/&
&1.2957E-03_JPRB,1.4736E-03_JPRB,1.3696E-03_JPRB,1.9219E-03_JPRB,2.4448E-03_JPRB,2.7185E-03_JPRB,&
&3.0973E-03_JPRB,1.2957E-03_JPRB,3.5777E-04_JPRB/)
KAO( :, 2, 2, 2) = (/&
&1.3520E-03_JPRB,1.5352E-03_JPRB,1.4594E-03_JPRB,1.7363E-03_JPRB,2.1608E-03_JPRB,2.5931E-03_JPRB,&
&2.9477E-03_JPRB,1.3520E-03_JPRB,3.5334E-04_JPRB/)
KAO( :, 3, 2, 2) = (/&
&1.3955E-03_JPRB,1.5728E-03_JPRB,1.5388E-03_JPRB,1.5910E-03_JPRB,1.9652E-03_JPRB,2.3965E-03_JPRB,&
&2.8214E-03_JPRB,1.3955E-03_JPRB,3.5208E-04_JPRB/)
KAO( :, 4, 2, 2) = (/&
&1.4306E-03_JPRB,1.6119E-03_JPRB,1.6289E-03_JPRB,1.6668E-03_JPRB,1.8749E-03_JPRB,2.1515E-03_JPRB,&
&2.5798E-03_JPRB,1.4306E-03_JPRB,3.8903E-04_JPRB/)
KAO( :, 5, 2, 2) = (/&
&1.4618E-03_JPRB,1.6648E-03_JPRB,1.7112E-03_JPRB,1.7696E-03_JPRB,1.8658E-03_JPRB,2.0390E-03_JPRB,&
&2.2630E-03_JPRB,1.4618E-03_JPRB,4.3501E-04_JPRB/)
KAO( :, 1, 3, 2) = (/&
&1.0941E-03_JPRB,1.2249E-03_JPRB,1.1110E-03_JPRB,1.6978E-03_JPRB,2.0757E-03_JPRB,2.3977E-03_JPRB,&
&2.5385E-03_JPRB,1.0941E-03_JPRB,2.5435E-04_JPRB/)
KAO( :, 2, 3, 2) = (/&
&1.1496E-03_JPRB,1.2893E-03_JPRB,1.2094E-03_JPRB,1.5400E-03_JPRB,1.9037E-03_JPRB,2.2282E-03_JPRB,&
&2.6108E-03_JPRB,1.1496E-03_JPRB,2.5844E-04_JPRB/)
KAO( :, 3, 3, 2) = (/&
&1.1926E-03_JPRB,1.3278E-03_JPRB,1.2717E-03_JPRB,1.3590E-03_JPRB,1.7088E-03_JPRB,2.1812E-03_JPRB,&
&2.3392E-03_JPRB,1.1926E-03_JPRB,2.6804E-04_JPRB/)
KAO( :, 4, 3, 2) = (/&
&1.2267E-03_JPRB,1.3589E-03_JPRB,1.3473E-03_JPRB,1.3690E-03_JPRB,1.6042E-03_JPRB,1.9290E-03_JPRB,&
&2.3507E-03_JPRB,1.2267E-03_JPRB,3.0065E-04_JPRB/)
KAO( :, 5, 3, 2) = (/&
&1.2554E-03_JPRB,1.4034E-03_JPRB,1.4269E-03_JPRB,1.4462E-03_JPRB,1.5803E-03_JPRB,1.7891E-03_JPRB,&
&1.9934E-03_JPRB,1.2554E-03_JPRB,3.3529E-04_JPRB/)
KAO( :, 1, 4, 2) = (/&
&9.2228E-04_JPRB,1.0144E-03_JPRB,8.9155E-04_JPRB,1.5523E-03_JPRB,1.8182E-03_JPRB,2.0790E-03_JPRB,&
&2.1019E-03_JPRB,9.2229E-04_JPRB,1.9739E-04_JPRB/)
KAO( :, 2, 4, 2) = (/&
&9.7173E-04_JPRB,1.0764E-03_JPRB,9.9094E-04_JPRB,1.3563E-03_JPRB,1.7130E-03_JPRB,1.9182E-03_JPRB,&
&2.1666E-03_JPRB,9.7173E-04_JPRB,1.9900E-04_JPRB/)
KAO( :, 3, 4, 2) = (/&
&1.0138E-03_JPRB,1.1151E-03_JPRB,1.0445E-03_JPRB,1.2251E-03_JPRB,1.5369E-03_JPRB,1.8521E-03_JPRB,&
&2.1013E-03_JPRB,1.0138E-03_JPRB,2.1276E-04_JPRB/)
KAO( :, 4, 4, 2) = (/&
&1.0473E-03_JPRB,1.1460E-03_JPRB,1.1161E-03_JPRB,1.1284E-03_JPRB,1.3578E-03_JPRB,1.6754E-03_JPRB,&
&2.0077E-03_JPRB,1.0473E-03_JPRB,2.3595E-04_JPRB/)
KAO( :, 5, 4, 2) = (/&
&1.0726E-03_JPRB,1.1805E-03_JPRB,1.1814E-03_JPRB,1.1848E-03_JPRB,1.3479E-03_JPRB,1.5615E-03_JPRB,&
&1.8994E-03_JPRB,1.0726E-03_JPRB,2.6165E-04_JPRB/)
KAO( :, 1, 5, 2) = (/&
&7.6690E-04_JPRB,8.2765E-04_JPRB,7.8062E-04_JPRB,1.3867E-03_JPRB,1.5867E-03_JPRB,1.6936E-03_JPRB,&
&1.7521E-03_JPRB,7.6690E-04_JPRB,1.6280E-04_JPRB/)
KAO( :, 2, 5, 2) = (/&
&8.1285E-04_JPRB,8.8774E-04_JPRB,7.8341E-04_JPRB,1.1988E-03_JPRB,1.4770E-03_JPRB,1.6719E-03_JPRB,&
&1.7693E-03_JPRB,8.1285E-04_JPRB,1.6768E-04_JPRB/)
KAO( :, 3, 5, 2) = (/&
&8.5183E-04_JPRB,9.2930E-04_JPRB,8.6098E-04_JPRB,1.1035E-03_JPRB,1.3517E-03_JPRB,1.5871E-03_JPRB,&
&1.8468E-03_JPRB,8.5182E-04_JPRB,1.7918E-04_JPRB/)
KAO( :, 4, 5, 2) = (/&
&8.8381E-04_JPRB,9.6005E-04_JPRB,9.1547E-04_JPRB,9.4610E-04_JPRB,1.2396E-03_JPRB,1.5757E-03_JPRB,&
&1.6719E-03_JPRB,8.8381E-04_JPRB,1.9528E-04_JPRB/)
KAO( :, 5, 5, 2) = (/&
&9.0780E-04_JPRB,9.9038E-04_JPRB,9.7867E-04_JPRB,9.6385E-04_JPRB,1.1363E-03_JPRB,1.3750E-03_JPRB,&
&1.6759E-03_JPRB,9.0780E-04_JPRB,2.1430E-04_JPRB/)
KAO( :, 1, 6, 2) = (/&
&6.2795E-04_JPRB,6.6838E-04_JPRB,7.3561E-04_JPRB,1.2263E-03_JPRB,1.3683E-03_JPRB,1.4046E-03_JPRB,&
&1.5094E-03_JPRB,6.2795E-04_JPRB,1.5216E-04_JPRB/)
KAO( :, 2, 6, 2) = (/&
&6.7183E-04_JPRB,7.2288E-04_JPRB,6.1801E-04_JPRB,1.0919E-03_JPRB,1.2712E-03_JPRB,1.4757E-03_JPRB,&
&1.4814E-03_JPRB,6.7183E-04_JPRB,1.5894E-04_JPRB/)
KAO( :, 3, 6, 2) = (/&
&7.0773E-04_JPRB,7.6513E-04_JPRB,6.8912E-04_JPRB,9.6974E-04_JPRB,1.1945E-03_JPRB,1.3671E-03_JPRB,&
&1.5170E-03_JPRB,7.0773E-04_JPRB,1.6897E-04_JPRB/)
KAO( :, 4, 6, 2) = (/&
&7.3816E-04_JPRB,7.9782E-04_JPRB,7.4473E-04_JPRB,8.7065E-04_JPRB,1.1028E-03_JPRB,1.3310E-03_JPRB,&
&1.4982E-03_JPRB,7.3816E-04_JPRB,1.8083E-04_JPRB/)
KAO( :, 5, 6, 2) = (/&
&7.6173E-04_JPRB,8.2557E-04_JPRB,8.0696E-04_JPRB,7.9653E-04_JPRB,9.7171E-04_JPRB,1.2001E-03_JPRB,&
&1.4350E-03_JPRB,7.6173E-04_JPRB,1.9544E-04_JPRB/)
KAO( :, 1, 7, 2) = (/&
&5.0891E-04_JPRB,5.3280E-04_JPRB,7.2820E-04_JPRB,1.0600E-03_JPRB,1.1897E-03_JPRB,1.2028E-03_JPRB,&
&1.2645E-03_JPRB,5.0891E-04_JPRB,1.6819E-04_JPRB/)
KAO( :, 2, 7, 2) = (/&
&5.5019E-04_JPRB,5.8559E-04_JPRB,5.5050E-04_JPRB,9.8189E-04_JPRB,1.1133E-03_JPRB,1.1994E-03_JPRB,&
&1.2177E-03_JPRB,5.5019E-04_JPRB,1.7740E-04_JPRB/)
KAO( :, 3, 7, 2) = (/&
&5.8438E-04_JPRB,6.2588E-04_JPRB,5.2192E-04_JPRB,8.6875E-04_JPRB,1.0399E-03_JPRB,1.1761E-03_JPRB,&
&1.2214E-03_JPRB,5.8438E-04_JPRB,1.8897E-04_JPRB/)
KAO( :, 4, 7, 2) = (/&
&6.1239E-04_JPRB,6.5682E-04_JPRB,6.0713E-04_JPRB,7.7808E-04_JPRB,9.7331E-04_JPRB,1.1140E-03_JPRB,&
&1.3014E-03_JPRB,6.1239E-04_JPRB,2.0290E-04_JPRB/)
KAO( :, 5, 7, 2) = (/&
&6.3467E-04_JPRB,6.8419E-04_JPRB,6.5295E-04_JPRB,6.7554E-04_JPRB,8.8119E-04_JPRB,1.1133E-03_JPRB,&
&1.2053E-03_JPRB,6.3467E-04_JPRB,2.1872E-04_JPRB/)
KAO( :, 1, 8, 2) = (/&
&4.0935E-04_JPRB,4.1885E-04_JPRB,6.7101E-04_JPRB,9.1256E-04_JPRB,1.0194E-03_JPRB,1.0135E-03_JPRB,&
&1.0819E-03_JPRB,4.0935E-04_JPRB,2.1824E-04_JPRB/)
KAO( :, 2, 8, 2) = (/&
&4.4692E-04_JPRB,4.7118E-04_JPRB,5.1659E-04_JPRB,8.5913E-04_JPRB,9.6357E-04_JPRB,9.8846E-04_JPRB,&
&1.0429E-03_JPRB,4.4692E-04_JPRB,2.3690E-04_JPRB/)
KAO( :, 3, 8, 2) = (/&
&4.7903E-04_JPRB,5.0921E-04_JPRB,4.2513E-04_JPRB,7.7866E-04_JPRB,8.9423E-04_JPRB,1.0205E-03_JPRB,&
&1.0213E-03_JPRB,4.7903E-04_JPRB,2.5819E-04_JPRB/)
KAO( :, 4, 8, 2) = (/&
&5.0519E-04_JPRB,5.3873E-04_JPRB,4.7470E-04_JPRB,6.8242E-04_JPRB,8.4925E-04_JPRB,9.6082E-04_JPRB,&
&1.0565E-03_JPRB,5.0519E-04_JPRB,2.8169E-04_JPRB/)
KAO( :, 5, 8, 2) = (/&
&5.2646E-04_JPRB,5.6355E-04_JPRB,5.3173E-04_JPRB,6.2134E-04_JPRB,7.8503E-04_JPRB,9.3706E-04_JPRB,&
&1.0322E-03_JPRB,5.2647E-04_JPRB,3.0574E-04_JPRB/)
KAO( :, 1, 9, 2) = (/&
&3.2639E-04_JPRB,3.2062E-04_JPRB,6.1707E-04_JPRB,7.9540E-04_JPRB,8.4564E-04_JPRB,8.5817E-04_JPRB,&
&9.0723E-04_JPRB,3.2639E-04_JPRB,5.5545E-04_JPRB/)
KAO( :, 2, 9, 2) = (/&
&3.6012E-04_JPRB,3.7319E-04_JPRB,5.0226E-04_JPRB,7.4254E-04_JPRB,8.4023E-04_JPRB,8.3301E-04_JPRB,&
&8.5728E-04_JPRB,3.6012E-04_JPRB,6.1165E-04_JPRB/)
KAO( :, 3, 9, 2) = (/&
&3.8987E-04_JPRB,4.1225E-04_JPRB,3.7907E-04_JPRB,6.8530E-04_JPRB,7.7881E-04_JPRB,8.3778E-04_JPRB,&
&8.4817E-04_JPRB,3.8987E-04_JPRB,6.6653E-04_JPRB/)
KAO( :, 4, 9, 2) = (/&
&4.1424E-04_JPRB,4.3910E-04_JPRB,3.6051E-04_JPRB,6.1000E-04_JPRB,7.2902E-04_JPRB,8.1999E-04_JPRB,&
&8.4396E-04_JPRB,4.1424E-04_JPRB,7.1819E-04_JPRB/)
KAO( :, 5, 9, 2) = (/&
&4.3431E-04_JPRB,4.6239E-04_JPRB,4.2288E-04_JPRB,5.4880E-04_JPRB,6.8867E-04_JPRB,7.7866E-04_JPRB,&
&8.9097E-04_JPRB,4.3431E-04_JPRB,7.7202E-04_JPRB/)
KAO( :, 1,10, 2) = (/&
&2.6062E-04_JPRB,2.4097E-04_JPRB,5.6760E-04_JPRB,6.7838E-04_JPRB,7.0839E-04_JPRB,7.4582E-04_JPRB,&
&7.5583E-04_JPRB,2.6062E-04_JPRB,2.5277E-03_JPRB/)
KAO( :, 2,10, 2) = (/&
&2.9023E-04_JPRB,2.9545E-04_JPRB,4.5173E-04_JPRB,6.2994E-04_JPRB,7.1727E-04_JPRB,7.0001E-04_JPRB,&
&7.3420E-04_JPRB,2.9022E-04_JPRB,2.7784E-03_JPRB/)
KAO( :, 3,10, 2) = (/&
&3.1702E-04_JPRB,3.3294E-04_JPRB,3.4527E-04_JPRB,5.9793E-04_JPRB,6.6774E-04_JPRB,6.9352E-04_JPRB,&
&7.1312E-04_JPRB,3.1702E-04_JPRB,3.0145E-03_JPRB/)
KAO( :, 4,10, 2) = (/&
&3.3919E-04_JPRB,3.5815E-04_JPRB,2.9459E-04_JPRB,5.3609E-04_JPRB,6.2952E-04_JPRB,7.0029E-04_JPRB,&
&6.9972E-04_JPRB,3.3919E-04_JPRB,3.2222E-03_JPRB/)
KAO( :, 5,10, 2) = (/&
&3.5768E-04_JPRB,3.7923E-04_JPRB,3.2874E-04_JPRB,4.7549E-04_JPRB,5.9483E-04_JPRB,6.7311E-04_JPRB,&
&7.3613E-04_JPRB,3.5768E-04_JPRB,3.4035E-03_JPRB/)
KAO( :, 1,11, 2) = (/&
&2.1907E-04_JPRB,2.0328E-04_JPRB,4.6419E-04_JPRB,5.6297E-04_JPRB,5.8907E-04_JPRB,6.1155E-04_JPRB,&
&6.1013E-04_JPRB,2.1907E-04_JPRB,5.1242E-03_JPRB/)
KAO( :, 2,11, 2) = (/&
&2.4410E-04_JPRB,2.4843E-04_JPRB,3.7130E-04_JPRB,5.2284E-04_JPRB,5.9762E-04_JPRB,5.8585E-04_JPRB,&
&6.0135E-04_JPRB,2.4411E-04_JPRB,5.5864E-03_JPRB/)
KAO( :, 3,11, 2) = (/&
&2.6625E-04_JPRB,2.7930E-04_JPRB,2.8189E-04_JPRB,4.9405E-04_JPRB,5.5402E-04_JPRB,5.7720E-04_JPRB,&
&5.8571E-04_JPRB,2.6625E-04_JPRB,6.0066E-03_JPRB/)
KAO( :, 4,11, 2) = (/&
&2.8487E-04_JPRB,3.0018E-04_JPRB,2.4472E-04_JPRB,4.4200E-04_JPRB,5.2652E-04_JPRB,5.8248E-04_JPRB,&
&5.7961E-04_JPRB,2.8487E-04_JPRB,6.3763E-03_JPRB/)
KAO( :, 5,11, 2) = (/&
&3.0010E-04_JPRB,3.1719E-04_JPRB,2.7311E-04_JPRB,3.9201E-04_JPRB,4.9427E-04_JPRB,5.6306E-04_JPRB,&
&6.1631E-04_JPRB,3.0010E-04_JPRB,6.6804E-03_JPRB/)
KAO( :, 1,12, 2) = (/&
&1.8394E-04_JPRB,1.7118E-04_JPRB,3.7730E-04_JPRB,4.6792E-04_JPRB,4.8975E-04_JPRB,4.9917E-04_JPRB,&
&5.0397E-04_JPRB,1.8394E-04_JPRB,6.7953E-03_JPRB/)
KAO( :, 2,12, 2) = (/&
&2.0488E-04_JPRB,2.0891E-04_JPRB,3.0355E-04_JPRB,4.3536E-04_JPRB,4.9195E-04_JPRB,4.8369E-04_JPRB,&
&4.9615E-04_JPRB,2.0488E-04_JPRB,7.3722E-03_JPRB/)
KAO( :, 3,12, 2) = (/&
&2.2338E-04_JPRB,2.3370E-04_JPRB,2.2853E-04_JPRB,4.0848E-04_JPRB,4.6057E-04_JPRB,4.8139E-04_JPRB,&
&4.8293E-04_JPRB,2.2338E-04_JPRB,7.8888E-03_JPRB/)
KAO( :, 4,12, 2) = (/&
&2.3905E-04_JPRB,2.5126E-04_JPRB,2.0156E-04_JPRB,3.6557E-04_JPRB,4.3992E-04_JPRB,4.8195E-04_JPRB,&
&4.8526E-04_JPRB,2.3905E-04_JPRB,8.3181E-03_JPRB/)
KAO( :, 5,12, 2) = (/&
&2.5129E-04_JPRB,2.6467E-04_JPRB,2.2905E-04_JPRB,3.2273E-04_JPRB,4.1230E-04_JPRB,4.6630E-04_JPRB,&
&5.1248E-04_JPRB,2.5129E-04_JPRB,8.6386E-03_JPRB/)
KAO( :, 1,13, 2) = (/&
&1.5430E-04_JPRB,1.4442E-04_JPRB,3.0805E-04_JPRB,3.8950E-04_JPRB,4.0767E-04_JPRB,4.1179E-04_JPRB,&
&4.1330E-04_JPRB,1.5430E-04_JPRB,7.3053E-03_JPRB/)
KAO( :, 2,13, 2) = (/&
&1.7179E-04_JPRB,1.7510E-04_JPRB,2.4818E-04_JPRB,3.6198E-04_JPRB,4.0625E-04_JPRB,3.9974E-04_JPRB,&
&4.1166E-04_JPRB,1.7179E-04_JPRB,7.9022E-03_JPRB/)
KAO( :, 3,13, 2) = (/&
&1.8741E-04_JPRB,1.9575E-04_JPRB,1.8604E-04_JPRB,3.3670E-04_JPRB,3.8272E-04_JPRB,4.0145E-04_JPRB,&
&4.0060E-04_JPRB,1.8741E-04_JPRB,8.4145E-03_JPRB/)
KAO( :, 4,13, 2) = (/&
&2.0031E-04_JPRB,2.0975E-04_JPRB,1.6656E-04_JPRB,3.0379E-04_JPRB,3.6769E-04_JPRB,4.0078E-04_JPRB,&
&4.0187E-04_JPRB,2.0032E-04_JPRB,8.8018E-03_JPRB/)
KAO( :, 5,13, 2) = (/&
&2.1018E-04_JPRB,2.2076E-04_JPRB,1.9159E-04_JPRB,2.6448E-04_JPRB,3.4432E-04_JPRB,3.8512E-04_JPRB,&
&4.2420E-04_JPRB,2.1018E-04_JPRB,9.0680E-03_JPRB/)
KAO( :, 1, 1, 3) = (/&
&2.3465E-03_JPRB,2.4031E-03_JPRB,2.2597E-03_JPRB,2.1524E-03_JPRB,2.8276E-03_JPRB,3.5761E-03_JPRB,&
&4.3079E-03_JPRB,2.3465E-03_JPRB,5.1471E-04_JPRB/)
KAO( :, 2, 1, 3) = (/&
&2.3042E-03_JPRB,2.4485E-03_JPRB,2.4199E-03_JPRB,2.2938E-03_JPRB,2.9847E-03_JPRB,3.1952E-03_JPRB,&
&4.1667E-03_JPRB,2.3042E-03_JPRB,6.2319E-04_JPRB/)
KAO( :, 3, 1, 3) = (/&
&2.2700E-03_JPRB,2.4966E-03_JPRB,2.5862E-03_JPRB,2.6511E-03_JPRB,2.8738E-03_JPRB,2.9164E-03_JPRB,&
&3.6118E-03_JPRB,2.2700E-03_JPRB,7.4229E-04_JPRB/)
KAO( :, 4, 1, 3) = (/&
&2.2509E-03_JPRB,2.5573E-03_JPRB,2.7581E-03_JPRB,2.9718E-03_JPRB,3.0657E-03_JPRB,3.3376E-03_JPRB,&
&3.1600E-03_JPRB,2.2509E-03_JPRB,8.5977E-04_JPRB/)
KAO( :, 5, 1, 3) = (/&
&2.2422E-03_JPRB,2.6355E-03_JPRB,2.9552E-03_JPRB,3.2531E-03_JPRB,3.4296E-03_JPRB,3.4558E-03_JPRB,&
&3.2808E-03_JPRB,2.2422E-03_JPRB,9.9766E-04_JPRB/)
KAO( :, 1, 2, 3) = (/&
&2.0157E-03_JPRB,2.0510E-03_JPRB,1.8851E-03_JPRB,1.8206E-03_JPRB,2.4343E-03_JPRB,2.9704E-03_JPRB,&
&3.8311E-03_JPRB,2.0157E-03_JPRB,4.1396E-04_JPRB/)
KAO( :, 2, 2, 3) = (/&
&1.9815E-03_JPRB,2.0886E-03_JPRB,2.0439E-03_JPRB,1.8938E-03_JPRB,2.5204E-03_JPRB,2.7128E-03_JPRB,&
&3.3350E-03_JPRB,1.9815E-03_JPRB,4.8039E-04_JPRB/)
KAO( :, 3, 2, 3) = (/&
&1.9576E-03_JPRB,2.1326E-03_JPRB,2.1790E-03_JPRB,2.1795E-03_JPRB,2.4882E-03_JPRB,2.4941E-03_JPRB,&
&3.2109E-03_JPRB,1.9575E-03_JPRB,5.7955E-04_JPRB/)
KAO( :, 4, 2, 3) = (/&
&1.9481E-03_JPRB,2.1829E-03_JPRB,2.3235E-03_JPRB,2.4676E-03_JPRB,2.6097E-03_JPRB,2.8349E-03_JPRB,&
&2.5868E-03_JPRB,1.9481E-03_JPRB,6.6714E-04_JPRB/)
KAO( :, 5, 2, 3) = (/&
&1.9507E-03_JPRB,2.2521E-03_JPRB,2.4912E-03_JPRB,2.7356E-03_JPRB,2.8987E-03_JPRB,2.9418E-03_JPRB,&
&2.7830E-03_JPRB,1.9507E-03_JPRB,7.7523E-04_JPRB/)
KAO( :, 1, 3, 3) = (/&
&1.7285E-03_JPRB,1.7377E-03_JPRB,1.5305E-03_JPRB,1.6757E-03_JPRB,2.1680E-03_JPRB,2.5609E-03_JPRB,&
&3.3887E-03_JPRB,1.7285E-03_JPRB,3.2280E-04_JPRB/)
KAO( :, 2, 3, 3) = (/&
&1.7015E-03_JPRB,1.7653E-03_JPRB,1.6878E-03_JPRB,1.5112E-03_JPRB,2.1719E-03_JPRB,2.4083E-03_JPRB,&
&2.8061E-03_JPRB,1.7015E-03_JPRB,3.7412E-04_JPRB/)
KAO( :, 3, 3, 3) = (/&
&1.6851E-03_JPRB,1.8101E-03_JPRB,1.8073E-03_JPRB,1.7539E-03_JPRB,2.2398E-03_JPRB,2.1112E-03_JPRB,&
&2.7333E-03_JPRB,1.6851E-03_JPRB,4.3157E-04_JPRB/)
KAO( :, 4, 3, 3) = (/&
&1.6786E-03_JPRB,1.8567E-03_JPRB,1.9291E-03_JPRB,1.9927E-03_JPRB,2.1347E-03_JPRB,2.2693E-03_JPRB,&
&2.2801E-03_JPRB,1.6786E-03_JPRB,5.0448E-04_JPRB/)
KAO( :, 5, 3, 3) = (/&
&1.6877E-03_JPRB,1.9156E-03_JPRB,2.0710E-03_JPRB,2.2420E-03_JPRB,2.3625E-03_JPRB,2.5310E-03_JPRB,&
&2.3182E-03_JPRB,1.6877E-03_JPRB,5.8583E-04_JPRB/)
KAO( :, 1, 4, 3) = (/&
&1.4834E-03_JPRB,1.4711E-03_JPRB,1.2522E-03_JPRB,1.4479E-03_JPRB,1.9854E-03_JPRB,2.2569E-03_JPRB,&
&2.9775E-03_JPRB,1.4834E-03_JPRB,2.5081E-04_JPRB/)
KAO( :, 2, 4, 3) = (/&
&1.4601E-03_JPRB,1.4870E-03_JPRB,1.3690E-03_JPRB,1.2662E-03_JPRB,1.8060E-03_JPRB,2.0826E-03_JPRB,&
&2.4977E-03_JPRB,1.4601E-03_JPRB,2.9277E-04_JPRB/)
KAO( :, 3, 4, 3) = (/&
&1.4467E-03_JPRB,1.5271E-03_JPRB,1.4979E-03_JPRB,1.3500E-03_JPRB,1.8497E-03_JPRB,1.9610E-03_JPRB,&
&2.2907E-03_JPRB,1.4467E-03_JPRB,3.3271E-04_JPRB/)
KAO( :, 4, 4, 3) = (/&
&1.4432E-03_JPRB,1.5714E-03_JPRB,1.5969E-03_JPRB,1.5937E-03_JPRB,1.7902E-03_JPRB,1.9320E-03_JPRB,&
&2.2420E-03_JPRB,1.4432E-03_JPRB,3.8467E-04_JPRB/)
KAO( :, 5, 4, 3) = (/&
&1.4550E-03_JPRB,1.6236E-03_JPRB,1.7127E-03_JPRB,1.8068E-03_JPRB,1.8486E-03_JPRB,2.1176E-03_JPRB,&
&1.8018E-03_JPRB,1.4551E-03_JPRB,4.4551E-04_JPRB/)
KAO( :, 1, 5, 3) = (/&
&1.2773E-03_JPRB,1.2497E-03_JPRB,1.0064E-03_JPRB,1.2506E-03_JPRB,1.7352E-03_JPRB,2.1064E-03_JPRB,&
&2.5188E-03_JPRB,1.2773E-03_JPRB,2.1025E-04_JPRB/)
KAO( :, 2, 5, 3) = (/&
&1.2595E-03_JPRB,1.2634E-03_JPRB,1.1147E-03_JPRB,1.1296E-03_JPRB,1.5824E-03_JPRB,1.8075E-03_JPRB,&
&2.2978E-03_JPRB,1.2595E-03_JPRB,2.3601E-04_JPRB/)
KAO( :, 3, 5, 3) = (/&
&1.2471E-03_JPRB,1.2907E-03_JPRB,1.2226E-03_JPRB,1.0559E-03_JPRB,1.5556E-03_JPRB,1.7264E-03_JPRB,&
&1.8319E-03_JPRB,1.2471E-03_JPRB,2.6674E-04_JPRB/)
KAO( :, 4, 5, 3) = (/&
&1.2460E-03_JPRB,1.3277E-03_JPRB,1.3232E-03_JPRB,1.2839E-03_JPRB,1.5266E-03_JPRB,1.5639E-03_JPRB,&
&1.9030E-03_JPRB,1.2460E-03_JPRB,3.0491E-04_JPRB/)
KAO( :, 5, 5, 3) = (/&
&1.2575E-03_JPRB,1.3721E-03_JPRB,1.4143E-03_JPRB,1.4453E-03_JPRB,1.5006E-03_JPRB,1.7674E-03_JPRB,&
&1.7436E-03_JPRB,1.2575E-03_JPRB,3.5060E-04_JPRB/)
KAO( :, 1, 6, 3) = (/&
&1.0958E-03_JPRB,1.0595E-03_JPRB,7.7664E-04_JPRB,1.1085E-03_JPRB,1.5393E-03_JPRB,1.9338E-03_JPRB,&
&2.1934E-03_JPRB,1.0958E-03_JPRB,1.9645E-04_JPRB/)
KAO( :, 2, 6, 3) = (/&
&1.0816E-03_JPRB,1.0727E-03_JPRB,9.0695E-04_JPRB,1.0023E-03_JPRB,1.4434E-03_JPRB,1.5856E-03_JPRB,&
&2.0291E-03_JPRB,1.0816E-03_JPRB,2.1208E-04_JPRB/)
KAO( :, 3, 6, 3) = (/&
&1.0710E-03_JPRB,1.0888E-03_JPRB,9.9129E-04_JPRB,8.7443E-04_JPRB,1.3179E-03_JPRB,1.5033E-03_JPRB,&
&1.7077E-03_JPRB,1.0710E-03_JPRB,2.3481E-04_JPRB/)
KAO( :, 4, 6, 3) = (/&
&1.0708E-03_JPRB,1.1186E-03_JPRB,1.0874E-03_JPRB,9.5969E-04_JPRB,1.2671E-03_JPRB,1.4010E-03_JPRB,&
&1.5917E-03_JPRB,1.0708E-03_JPRB,2.6339E-04_JPRB/)
KAO( :, 5, 6, 3) = (/&
&1.0806E-03_JPRB,1.1572E-03_JPRB,1.1631E-03_JPRB,1.1545E-03_JPRB,1.2485E-03_JPRB,1.4294E-03_JPRB,&
&1.6004E-03_JPRB,1.0806E-03_JPRB,2.9803E-04_JPRB/)
KAO( :, 1, 7, 3) = (/&
&9.3348E-04_JPRB,8.9092E-04_JPRB,5.7161E-04_JPRB,1.0208E-03_JPRB,1.3784E-03_JPRB,1.7037E-03_JPRB,&
&1.8935E-03_JPRB,9.3348E-04_JPRB,2.1146E-04_JPRB/)
KAO( :, 2, 7, 3) = (/&
&9.2171E-04_JPRB,9.0329E-04_JPRB,7.1477E-04_JPRB,8.4903E-04_JPRB,1.2778E-03_JPRB,1.4945E-03_JPRB,&
&1.7270E-03_JPRB,9.2171E-04_JPRB,2.3005E-04_JPRB/)
KAO( :, 3, 7, 3) = (/&
&9.1419E-04_JPRB,9.1920E-04_JPRB,8.1160E-04_JPRB,7.6435E-04_JPRB,1.1213E-03_JPRB,1.3301E-03_JPRB,&
&1.6214E-03_JPRB,9.1419E-04_JPRB,2.5234E-04_JPRB/)
KAO( :, 4, 7, 3) = (/&
&9.1402E-04_JPRB,9.3968E-04_JPRB,8.8126E-04_JPRB,7.5287E-04_JPRB,1.0570E-03_JPRB,1.2475E-03_JPRB,&
&1.2998E-03_JPRB,9.1402E-04_JPRB,2.7815E-04_JPRB/)
KAO( :, 5, 7, 3) = (/&
&9.2290E-04_JPRB,9.7254E-04_JPRB,9.5644E-04_JPRB,8.9479E-04_JPRB,1.0508E-03_JPRB,1.1268E-03_JPRB,&
&1.3501E-03_JPRB,9.2290E-04_JPRB,3.0806E-04_JPRB/)
KAO( :, 1, 8, 3) = (/&
&7.8900E-04_JPRB,7.4488E-04_JPRB,4.6218E-04_JPRB,9.6318E-04_JPRB,1.2372E-03_JPRB,1.5237E-03_JPRB,&
&1.6722E-03_JPRB,7.8900E-04_JPRB,3.0765E-04_JPRB/)
KAO( :, 2, 8, 3) = (/&
&7.8043E-04_JPRB,7.5428E-04_JPRB,5.4366E-04_JPRB,7.5909E-04_JPRB,1.0879E-03_JPRB,1.3550E-03_JPRB,&
&1.4794E-03_JPRB,7.8043E-04_JPRB,3.3864E-04_JPRB/)
KAO( :, 3, 8, 3) = (/&
&7.7466E-04_JPRB,7.6980E-04_JPRB,6.4963E-04_JPRB,7.0009E-04_JPRB,9.7649E-04_JPRB,1.1689E-03_JPRB,&
&1.4326E-03_JPRB,7.7466E-04_JPRB,3.7286E-04_JPRB/)
KAO( :, 4, 8, 3) = (/&
&7.7506E-04_JPRB,7.8870E-04_JPRB,7.1575E-04_JPRB,6.1864E-04_JPRB,8.9565E-04_JPRB,1.0708E-03_JPRB,&
&1.2387E-03_JPRB,7.7506E-04_JPRB,4.1070E-04_JPRB/)
KAO( :, 5, 8, 3) = (/&
&7.8287E-04_JPRB,8.1561E-04_JPRB,7.7836E-04_JPRB,6.6838E-04_JPRB,8.8453E-04_JPRB,9.5158E-04_JPRB,&
&1.1620E-03_JPRB,7.8287E-04_JPRB,4.5222E-04_JPRB/)
KAO( :, 1, 9, 3) = (/&
&6.6353E-04_JPRB,6.2207E-04_JPRB,4.1497E-04_JPRB,8.5325E-04_JPRB,1.1545E-03_JPRB,1.3202E-03_JPRB,&
&1.4543E-03_JPRB,6.6353E-04_JPRB,9.2255E-04_JPRB/)
KAO( :, 2, 9, 3) = (/&
&6.5824E-04_JPRB,6.2786E-04_JPRB,3.9339E-04_JPRB,7.1164E-04_JPRB,9.5910E-04_JPRB,1.2248E-03_JPRB,&
&1.2834E-03_JPRB,6.5824E-04_JPRB,1.0047E-03_JPRB/)
KAO( :, 3, 9, 3) = (/&
&6.5331E-04_JPRB,6.3921E-04_JPRB,5.1016E-04_JPRB,5.9654E-04_JPRB,8.7596E-04_JPRB,1.0857E-03_JPRB,&
&1.2145E-03_JPRB,6.5331E-04_JPRB,1.0900E-03_JPRB/)
KAO( :, 4, 9, 3) = (/&
&6.5413E-04_JPRB,6.5950E-04_JPRB,5.8244E-04_JPRB,5.3974E-04_JPRB,7.9259E-04_JPRB,9.3024E-04_JPRB,&
&1.1600E-03_JPRB,6.5413E-04_JPRB,1.1801E-03_JPRB/)
KAO( :, 5, 9, 3) = (/&
&6.6022E-04_JPRB,6.8110E-04_JPRB,6.3639E-04_JPRB,5.2716E-04_JPRB,7.2311E-04_JPRB,8.5016E-04_JPRB,&
&9.6256E-04_JPRB,6.6022E-04_JPRB,1.2684E-03_JPRB/)
KAO( :, 1,10, 3) = (/&
&5.5537E-04_JPRB,5.1658E-04_JPRB,3.5969E-04_JPRB,7.5778E-04_JPRB,1.0268E-03_JPRB,1.1188E-03_JPRB,&
&1.2385E-03_JPRB,5.5537E-04_JPRB,4.6647E-03_JPRB/)
KAO( :, 2,10, 3) = (/&
&5.5299E-04_JPRB,5.2259E-04_JPRB,3.1728E-04_JPRB,6.5526E-04_JPRB,8.4363E-04_JPRB,1.0738E-03_JPRB,&
&1.0790E-03_JPRB,5.5299E-04_JPRB,4.9960E-03_JPRB/)
KAO( :, 3,10, 3) = (/&
&5.4881E-04_JPRB,5.3065E-04_JPRB,3.9373E-04_JPRB,5.2361E-04_JPRB,7.6014E-04_JPRB,9.4697E-04_JPRB,&
&1.0409E-03_JPRB,5.4881E-04_JPRB,5.3035E-03_JPRB/)
KAO( :, 4,10, 3) = (/&
&5.5010E-04_JPRB,5.4878E-04_JPRB,4.7038E-04_JPRB,4.9342E-04_JPRB,6.7583E-04_JPRB,8.0683E-04_JPRB,&
&1.0299E-03_JPRB,5.5010E-04_JPRB,5.6055E-03_JPRB/)
KAO( :, 5,10, 3) = (/&
&5.5598E-04_JPRB,5.6871E-04_JPRB,5.2247E-04_JPRB,4.3615E-04_JPRB,6.1815E-04_JPRB,7.4431E-04_JPRB,&
&8.6008E-04_JPRB,5.5598E-04_JPRB,5.8866E-03_JPRB/)
KAO( :, 1,11, 3) = (/&
&4.6383E-04_JPRB,4.3181E-04_JPRB,2.9311E-04_JPRB,6.2613E-04_JPRB,8.4464E-04_JPRB,9.4332E-04_JPRB,&
&1.0276E-03_JPRB,4.6383E-04_JPRB,9.7820E-03_JPRB/)
KAO( :, 2,11, 3) = (/&
&4.6171E-04_JPRB,4.3648E-04_JPRB,2.6562E-04_JPRB,5.3382E-04_JPRB,6.9685E-04_JPRB,9.0179E-04_JPRB,&
&9.0128E-04_JPRB,4.6171E-04_JPRB,1.0398E-02_JPRB/)
KAO( :, 3,11, 3) = (/&
&4.5971E-04_JPRB,4.4491E-04_JPRB,3.3508E-04_JPRB,4.3267E-04_JPRB,6.3864E-04_JPRB,7.7944E-04_JPRB,&
&8.8922E-04_JPRB,4.5971E-04_JPRB,1.0944E-02_JPRB/)
KAO( :, 4,11, 3) = (/&
&4.6259E-04_JPRB,4.6298E-04_JPRB,4.0175E-04_JPRB,4.0894E-04_JPRB,5.5874E-04_JPRB,6.6574E-04_JPRB,&
&8.6378E-04_JPRB,4.6259E-04_JPRB,1.1452E-02_JPRB/)
KAO( :, 5,11, 3) = (/&
&4.6974E-04_JPRB,4.8223E-04_JPRB,4.4819E-04_JPRB,3.7104E-04_JPRB,5.1007E-04_JPRB,6.1091E-04_JPRB,&
&6.9095E-04_JPRB,4.6974E-04_JPRB,1.1916E-02_JPRB/)
KAO( :, 1,12, 3) = (/&
&3.8677E-04_JPRB,3.6035E-04_JPRB,2.4184E-04_JPRB,5.1647E-04_JPRB,6.9945E-04_JPRB,8.0460E-04_JPRB,&
&8.3717E-04_JPRB,3.8677E-04_JPRB,1.3274E-02_JPRB/)
KAO( :, 2,12, 3) = (/&
&3.8521E-04_JPRB,3.6402E-04_JPRB,2.2242E-04_JPRB,4.3447E-04_JPRB,5.8110E-04_JPRB,7.4047E-04_JPRB,&
&7.6321E-04_JPRB,3.8521E-04_JPRB,1.4068E-02_JPRB/)
KAO( :, 3,12, 3) = (/&
&3.8458E-04_JPRB,3.7296E-04_JPRB,2.8696E-04_JPRB,3.5751E-04_JPRB,5.2960E-04_JPRB,6.4366E-04_JPRB,&
&7.5179E-04_JPRB,3.8458E-04_JPRB,1.4758E-02_JPRB/)
KAO( :, 4,12, 3) = (/&
&3.8810E-04_JPRB,3.8944E-04_JPRB,3.4377E-04_JPRB,3.3355E-04_JPRB,4.6692E-04_JPRB,5.5746E-04_JPRB,&
&7.0895E-04_JPRB,3.8810E-04_JPRB,1.5376E-02_JPRB/)
KAO( :, 5,12, 3) = (/&
&3.9595E-04_JPRB,4.0863E-04_JPRB,3.8125E-04_JPRB,3.1202E-04_JPRB,4.2678E-04_JPRB,5.1131E-04_JPRB,&
&5.7489E-04_JPRB,3.9595E-04_JPRB,1.5941E-02_JPRB/)
KAO( :, 1,13, 3) = (/&
&3.2194E-04_JPRB,2.9976E-04_JPRB,1.9852E-04_JPRB,4.2567E-04_JPRB,5.7525E-04_JPRB,6.7061E-04_JPRB,&
&6.9907E-04_JPRB,3.2194E-04_JPRB,1.4565E-02_JPRB/)
KAO( :, 2,13, 3) = (/&
&3.2103E-04_JPRB,3.0342E-04_JPRB,1.8519E-04_JPRB,3.5157E-04_JPRB,4.8791E-04_JPRB,6.1939E-04_JPRB,&
&6.5160E-04_JPRB,3.2103E-04_JPRB,1.5395E-02_JPRB/)
KAO( :, 3,13, 3) = (/&
&3.2113E-04_JPRB,3.1205E-04_JPRB,2.4410E-04_JPRB,2.9571E-04_JPRB,4.4082E-04_JPRB,5.2957E-04_JPRB,&
&6.2741E-04_JPRB,3.2112E-04_JPRB,1.6107E-02_JPRB/)
KAO( :, 4,13, 3) = (/&
&3.2542E-04_JPRB,3.2754E-04_JPRB,2.9103E-04_JPRB,2.6678E-04_JPRB,3.8858E-04_JPRB,4.6663E-04_JPRB,&
&5.7700E-04_JPRB,3.2542E-04_JPRB,1.6764E-02_JPRB/)
KAO( :, 5,13, 3) = (/&
&3.3271E-04_JPRB,3.4522E-04_JPRB,3.2313E-04_JPRB,2.6306E-04_JPRB,3.5325E-04_JPRB,4.2786E-04_JPRB,&
&4.7758E-04_JPRB,3.3271E-04_JPRB,1.7329E-02_JPRB/)
KAO( :, 1, 1, 4) = (/&
&3.2539E-03_JPRB,3.4940E-03_JPRB,3.4388E-03_JPRB,3.0659E-03_JPRB,3.4522E-03_JPRB,4.1188E-03_JPRB,&
&4.1472E-03_JPRB,3.2539E-03_JPRB,9.9646E-04_JPRB/)
KAO( :, 2, 1, 4) = (/&
&3.2363E-03_JPRB,3.6045E-03_JPRB,3.7021E-03_JPRB,3.5901E-03_JPRB,3.1463E-03_JPRB,4.3360E-03_JPRB,&
&4.0838E-03_JPRB,3.2363E-03_JPRB,1.0956E-03_JPRB/)
KAO( :, 3, 1, 4) = (/&
&3.2334E-03_JPRB,3.7700E-03_JPRB,3.9602E-03_JPRB,3.9629E-03_JPRB,3.8081E-03_JPRB,4.2925E-03_JPRB,&
&5.1219E-03_JPRB,3.2334E-03_JPRB,1.3007E-03_JPRB/)
KAO( :, 4, 1, 4) = (/&
&3.2490E-03_JPRB,3.9748E-03_JPRB,4.2071E-03_JPRB,4.2935E-03_JPRB,4.3164E-03_JPRB,4.2604E-03_JPRB,&
&5.6033E-03_JPRB,3.2490E-03_JPRB,1.5944E-03_JPRB/)
KAO( :, 5, 1, 4) = (/&
&3.2698E-03_JPRB,4.1740E-03_JPRB,4.4497E-03_JPRB,4.6155E-03_JPRB,4.8047E-03_JPRB,5.1537E-03_JPRB,&
&5.5559E-03_JPRB,3.2698E-03_JPRB,1.9119E-03_JPRB/)
KAO( :, 1, 2, 4) = (/&
&2.8229E-03_JPRB,2.9984E-03_JPRB,2.9248E-03_JPRB,2.5710E-03_JPRB,2.9591E-03_JPRB,3.5685E-03_JPRB,&
&3.3471E-03_JPRB,2.8229E-03_JPRB,7.1037E-04_JPRB/)
KAO( :, 2, 2, 4) = (/&
&2.8182E-03_JPRB,3.1079E-03_JPRB,3.1510E-03_JPRB,3.0220E-03_JPRB,2.6456E-03_JPRB,3.5065E-03_JPRB,&
&3.5091E-03_JPRB,2.8182E-03_JPRB,8.2941E-04_JPRB/)
KAO( :, 3, 2, 4) = (/&
&2.8273E-03_JPRB,3.2641E-03_JPRB,3.3991E-03_JPRB,3.3882E-03_JPRB,3.1076E-03_JPRB,3.6339E-03_JPRB,&
&4.1453E-03_JPRB,2.8273E-03_JPRB,9.9329E-04_JPRB/)
KAO( :, 4, 2, 4) = (/&
&2.8479E-03_JPRB,3.4537E-03_JPRB,3.6378E-03_JPRB,3.6922E-03_JPRB,3.5902E-03_JPRB,3.4985E-03_JPRB,&
&4.8079E-03_JPRB,2.8479E-03_JPRB,1.2207E-03_JPRB/)
KAO( :, 5, 2, 4) = (/&
&2.8762E-03_JPRB,3.6435E-03_JPRB,3.8640E-03_JPRB,3.9829E-03_JPRB,4.0196E-03_JPRB,4.2137E-03_JPRB,&
&4.6057E-03_JPRB,2.8762E-03_JPRB,1.4645E-03_JPRB/)
KAO( :, 1, 3, 4) = (/&
&2.4480E-03_JPRB,2.5503E-03_JPRB,2.4276E-03_JPRB,1.9299E-03_JPRB,2.4394E-03_JPRB,2.9600E-03_JPRB,&
&3.0819E-03_JPRB,2.4480E-03_JPRB,5.1310E-04_JPRB/)
KAO( :, 2, 3, 4) = (/&
&2.4484E-03_JPRB,2.6489E-03_JPRB,2.6249E-03_JPRB,2.4613E-03_JPRB,2.1891E-03_JPRB,2.8113E-03_JPRB,&
&2.9085E-03_JPRB,2.4484E-03_JPRB,6.0695E-04_JPRB/)
KAO( :, 3, 3, 4) = (/&
&2.4631E-03_JPRB,2.7817E-03_JPRB,2.8578E-03_JPRB,2.8021E-03_JPRB,2.3361E-03_JPRB,3.1956E-03_JPRB,&
&3.2912E-03_JPRB,2.4631E-03_JPRB,7.4313E-04_JPRB/)
KAO( :, 4, 3, 4) = (/&
&2.4843E-03_JPRB,2.9440E-03_JPRB,3.0734E-03_JPRB,3.0947E-03_JPRB,2.9596E-03_JPRB,2.9621E-03_JPRB,&
&3.8254E-03_JPRB,2.4843E-03_JPRB,8.9831E-04_JPRB/)
KAO( :, 5, 3, 4) = (/&
&2.5152E-03_JPRB,3.1190E-03_JPRB,3.2801E-03_JPRB,3.3527E-03_JPRB,3.3374E-03_JPRB,3.2653E-03_JPRB,&
&3.7266E-03_JPRB,2.5152E-03_JPRB,1.0797E-03_JPRB/)
KAO( :, 1, 4, 4) = (/&
&2.1250E-03_JPRB,2.1670E-03_JPRB,1.9990E-03_JPRB,1.5199E-03_JPRB,1.9962E-03_JPRB,2.4995E-03_JPRB,&
&2.9024E-03_JPRB,2.1250E-03_JPRB,3.7531E-04_JPRB/)
KAO( :, 2, 4, 4) = (/&
&2.1204E-03_JPRB,2.2489E-03_JPRB,2.1700E-03_JPRB,1.9399E-03_JPRB,1.9963E-03_JPRB,2.4266E-03_JPRB,&
&2.6000E-03_JPRB,2.1204E-03_JPRB,4.4756E-04_JPRB/)
KAO( :, 3, 4, 4) = (/&
&2.1413E-03_JPRB,2.3587E-03_JPRB,2.3627E-03_JPRB,2.2544E-03_JPRB,1.9195E-03_JPRB,2.4658E-03_JPRB,&
&2.5172E-03_JPRB,2.1413E-03_JPRB,5.4705E-04_JPRB/)
KAO( :, 4, 4, 4) = (/&
&2.1654E-03_JPRB,2.4980E-03_JPRB,2.5663E-03_JPRB,2.5373E-03_JPRB,2.3728E-03_JPRB,2.4769E-03_JPRB,&
&2.8318E-03_JPRB,2.1654E-03_JPRB,6.6125E-04_JPRB/)
KAO( :, 5, 4, 4) = (/&
&2.1913E-03_JPRB,2.6456E-03_JPRB,2.7536E-03_JPRB,2.7816E-03_JPRB,2.7405E-03_JPRB,2.5702E-03_JPRB,&
&3.2605E-03_JPRB,2.1913E-03_JPRB,7.9714E-04_JPRB/)
KAO( :, 1, 5, 4) = (/&
&1.8265E-03_JPRB,1.8381E-03_JPRB,1.6457E-03_JPRB,1.2486E-03_JPRB,1.7229E-03_JPRB,2.0547E-03_JPRB,&
&2.6848E-03_JPRB,1.8265E-03_JPRB,2.8596E-04_JPRB/)
KAO( :, 2, 5, 4) = (/&
&1.8274E-03_JPRB,1.9048E-03_JPRB,1.7983E-03_JPRB,1.4752E-03_JPRB,1.7469E-03_JPRB,2.1116E-03_JPRB,&
&2.1134E-03_JPRB,1.8274E-03_JPRB,3.4190E-04_JPRB/)
KAO( :, 3, 5, 4) = (/&
&1.8508E-03_JPRB,2.0003E-03_JPRB,1.9620E-03_JPRB,1.8188E-03_JPRB,1.6077E-03_JPRB,1.9516E-03_JPRB,&
&2.1073E-03_JPRB,1.8508E-03_JPRB,4.1292E-04_JPRB/)
KAO( :, 4, 5, 4) = (/&
&1.8793E-03_JPRB,2.1182E-03_JPRB,2.1350E-03_JPRB,2.0517E-03_JPRB,1.8087E-03_JPRB,2.2071E-03_JPRB,&
&2.2714E-03_JPRB,1.8793E-03_JPRB,4.9789E-04_JPRB/)
KAO( :, 5, 5, 4) = (/&
&1.9065E-03_JPRB,2.2435E-03_JPRB,2.3053E-03_JPRB,2.2926E-03_JPRB,2.2224E-03_JPRB,2.0829E-03_JPRB,&
&2.5565E-03_JPRB,1.9065E-03_JPRB,5.9975E-04_JPRB/)
KAO( :, 1, 6, 4) = (/&
&1.5738E-03_JPRB,1.5536E-03_JPRB,1.3462E-03_JPRB,1.0905E-03_JPRB,1.5345E-03_JPRB,1.8378E-03_JPRB,&
&2.3696E-03_JPRB,1.5738E-03_JPRB,2.4570E-04_JPRB/)
KAO( :, 2, 6, 4) = (/&
&1.5785E-03_JPRB,1.6102E-03_JPRB,1.4864E-03_JPRB,1.0878E-03_JPRB,1.4533E-03_JPRB,1.8096E-03_JPRB,&
&1.9208E-03_JPRB,1.5785E-03_JPRB,2.8650E-04_JPRB/)
KAO( :, 3, 6, 4) = (/&
&1.5938E-03_JPRB,1.6886E-03_JPRB,1.6242E-03_JPRB,1.4329E-03_JPRB,1.3971E-03_JPRB,1.6588E-03_JPRB,&
&1.7977E-03_JPRB,1.5938E-03_JPRB,3.3646E-04_JPRB/)
KAO( :, 4, 6, 4) = (/&
&1.6207E-03_JPRB,1.7903E-03_JPRB,1.7740E-03_JPRB,1.6609E-03_JPRB,1.4090E-03_JPRB,1.7880E-03_JPRB,&
&1.8264E-03_JPRB,1.6207E-03_JPRB,3.9927E-04_JPRB/)
KAO( :, 5, 6, 4) = (/&
&1.6514E-03_JPRB,1.8945E-03_JPRB,1.9189E-03_JPRB,1.8707E-03_JPRB,1.7309E-03_JPRB,1.7651E-03_JPRB,&
&1.8956E-03_JPRB,1.6514E-03_JPRB,4.7341E-04_JPRB/)
KAO( :, 1, 7, 4) = (/&
&1.3566E-03_JPRB,1.3176E-03_JPRB,1.0800E-03_JPRB,9.9879E-04_JPRB,1.3645E-03_JPRB,1.6716E-03_JPRB,&
&2.0138E-03_JPRB,1.3566E-03_JPRB,2.7117E-04_JPRB/)
KAO( :, 2, 7, 4) = (/&
&1.3616E-03_JPRB,1.3614E-03_JPRB,1.2294E-03_JPRB,8.6943E-04_JPRB,1.2441E-03_JPRB,1.4557E-03_JPRB,&
&1.7627E-03_JPRB,1.3616E-03_JPRB,3.0497E-04_JPRB/)
KAO( :, 3, 7, 4) = (/&
&1.3738E-03_JPRB,1.4251E-03_JPRB,1.3424E-03_JPRB,1.0748E-03_JPRB,1.3239E-03_JPRB,1.4948E-03_JPRB,&
&1.4893E-03_JPRB,1.3738E-03_JPRB,3.4547E-04_JPRB/)
KAO( :, 4, 7, 4) = (/&
&1.3909E-03_JPRB,1.5062E-03_JPRB,1.4675E-03_JPRB,1.3314E-03_JPRB,1.1299E-03_JPRB,1.4256E-03_JPRB,&
&1.5101E-03_JPRB,1.3909E-03_JPRB,3.9363E-04_JPRB/)
KAO( :, 5, 7, 4) = (/&
&1.4214E-03_JPRB,1.5939E-03_JPRB,1.5929E-03_JPRB,1.5159E-03_JPRB,1.3044E-03_JPRB,1.5546E-03_JPRB,&
&1.5847E-03_JPRB,1.4214E-03_JPRB,4.4999E-04_JPRB/)
KAO( :, 1, 8, 4) = (/&
&1.1638E-03_JPRB,1.1139E-03_JPRB,8.4796E-04_JPRB,8.4668E-04_JPRB,1.2396E-03_JPRB,1.5094E-03_JPRB,&
&1.6975E-03_JPRB,1.1638E-03_JPRB,4.3052E-04_JPRB/)
KAO( :, 2, 8, 4) = (/&
&1.1671E-03_JPRB,1.1491E-03_JPRB,9.9702E-04_JPRB,7.1894E-04_JPRB,1.1157E-03_JPRB,1.2835E-03_JPRB,&
&1.5171E-03_JPRB,1.1671E-03_JPRB,4.7244E-04_JPRB/)
KAO( :, 3, 8, 4) = (/&
&1.1763E-03_JPRB,1.1971E-03_JPRB,1.1061E-03_JPRB,7.5625E-04_JPRB,1.0948E-03_JPRB,1.3227E-03_JPRB,&
&1.3243E-03_JPRB,1.1763E-03_JPRB,5.1908E-04_JPRB/)
KAO( :, 4, 8, 4) = (/&
&1.1882E-03_JPRB,1.2582E-03_JPRB,1.2081E-03_JPRB,1.0410E-03_JPRB,9.4931E-04_JPRB,1.2112E-03_JPRB,&
&1.2350E-03_JPRB,1.1882E-03_JPRB,5.7242E-04_JPRB/)
KAO( :, 5, 8, 4) = (/&
&1.2141E-03_JPRB,1.3322E-03_JPRB,1.3142E-03_JPRB,1.2208E-03_JPRB,9.8671E-04_JPRB,1.3128E-03_JPRB,&
&1.3456E-03_JPRB,1.2141E-03_JPRB,6.3120E-04_JPRB/)
KAO( :, 1, 9, 4) = (/&
&9.9337E-04_JPRB,9.3743E-04_JPRB,6.1970E-04_JPRB,7.5456E-04_JPRB,1.1089E-03_JPRB,1.3407E-03_JPRB,&
&1.5068E-03_JPRB,9.9337E-04_JPRB,1.4422E-03_JPRB/)
KAO( :, 2, 9, 4) = (/&
&9.9471E-04_JPRB,9.6601E-04_JPRB,8.0263E-04_JPRB,6.4260E-04_JPRB,9.9035E-04_JPRB,1.1710E-03_JPRB,&
&1.3289E-03_JPRB,9.9471E-04_JPRB,1.5498E-03_JPRB/)
KAO( :, 3, 9, 4) = (/&
&1.0028E-03_JPRB,1.0037E-03_JPRB,9.0388E-04_JPRB,5.9394E-04_JPRB,8.7485E-04_JPRB,1.0779E-03_JPRB,&
&1.1968E-03_JPRB,1.0028E-03_JPRB,1.6632E-03_JPRB/)
KAO( :, 4, 9, 4) = (/&
&1.0138E-03_JPRB,1.0500E-03_JPRB,9.8794E-04_JPRB,7.6322E-04_JPRB,8.5312E-04_JPRB,1.1047E-03_JPRB,&
&1.0664E-03_JPRB,1.0138E-03_JPRB,1.7764E-03_JPRB/)
KAO( :, 5, 9, 4) = (/&
&1.0324E-03_JPRB,1.1072E-03_JPRB,1.0751E-03_JPRB,9.6755E-04_JPRB,7.9829E-04_JPRB,1.0354E-03_JPRB,&
&1.1339E-03_JPRB,1.0324E-03_JPRB,1.8836E-03_JPRB/)
KAO( :, 1,10, 4) = (/&
&8.4390E-04_JPRB,7.8883E-04_JPRB,4.5496E-04_JPRB,6.3978E-04_JPRB,9.7062E-04_JPRB,1.1888E-03_JPRB,&
&1.3025E-03_JPRB,8.4390E-04_JPRB,7.7978E-03_JPRB/)
KAO( :, 2,10, 4) = (/&
&8.4417E-04_JPRB,8.1047E-04_JPRB,6.4039E-04_JPRB,5.5867E-04_JPRB,8.6775E-04_JPRB,1.0100E-03_JPRB,&
&1.1972E-03_JPRB,8.4417E-04_JPRB,8.1651E-03_JPRB/)
KAO( :, 3,10, 4) = (/&
&8.5209E-04_JPRB,8.4218E-04_JPRB,7.3701E-04_JPRB,4.8053E-04_JPRB,7.5503E-04_JPRB,9.4507E-04_JPRB,&
&1.0394E-03_JPRB,8.5209E-04_JPRB,8.5320E-03_JPRB/)
KAO( :, 4,10, 4) = (/&
&8.6243E-04_JPRB,8.7871E-04_JPRB,8.1378E-04_JPRB,5.4794E-04_JPRB,7.5693E-04_JPRB,9.4093E-04_JPRB,&
&9.0694E-04_JPRB,8.6243E-04_JPRB,8.8886E-03_JPRB/)
KAO( :, 5,10, 4) = (/&
&8.7838E-04_JPRB,9.2500E-04_JPRB,8.8544E-04_JPRB,7.6044E-04_JPRB,6.4236E-04_JPRB,8.2354E-04_JPRB,&
&9.4540E-04_JPRB,8.7839E-04_JPRB,9.2325E-03_JPRB/)
KAO( :, 1,11, 4) = (/&
&7.1140E-04_JPRB,6.6686E-04_JPRB,3.9659E-04_JPRB,5.3128E-04_JPRB,8.2390E-04_JPRB,9.6334E-04_JPRB,&
&1.0535E-03_JPRB,7.1140E-04_JPRB,1.6752E-02_JPRB/)
KAO( :, 2,11, 4) = (/&
&7.1470E-04_JPRB,6.8928E-04_JPRB,5.4857E-04_JPRB,4.7790E-04_JPRB,7.0017E-04_JPRB,8.4578E-04_JPRB,&
&9.6239E-04_JPRB,7.1470E-04_JPRB,1.7467E-02_JPRB/)
KAO( :, 3,11, 4) = (/&
&7.2406E-04_JPRB,7.1829E-04_JPRB,6.3252E-04_JPRB,4.0136E-04_JPRB,6.0473E-04_JPRB,8.1229E-04_JPRB,&
&8.6413E-04_JPRB,7.2406E-04_JPRB,1.8154E-02_JPRB/)
KAO( :, 4,11, 4) = (/&
&7.3750E-04_JPRB,7.5088E-04_JPRB,6.9603E-04_JPRB,4.8007E-04_JPRB,6.2834E-04_JPRB,7.5345E-04_JPRB,&
&7.8530E-04_JPRB,7.3750E-04_JPRB,1.8779E-02_JPRB/)
KAO( :, 5,11, 4) = (/&
&7.5575E-04_JPRB,7.9367E-04_JPRB,7.5606E-04_JPRB,6.5213E-04_JPRB,5.4718E-04_JPRB,7.0193E-04_JPRB,&
&8.3404E-04_JPRB,7.5575E-04_JPRB,1.9352E-02_JPRB/)
KAO( :, 1,12, 4) = (/&
&5.9829E-04_JPRB,5.6157E-04_JPRB,3.4347E-04_JPRB,4.4145E-04_JPRB,6.8008E-04_JPRB,7.8397E-04_JPRB,&
&8.5127E-04_JPRB,5.9830E-04_JPRB,2.3223E-02_JPRB/)
KAO( :, 2,12, 4) = (/&
&6.0344E-04_JPRB,5.8387E-04_JPRB,4.6957E-04_JPRB,3.9737E-04_JPRB,5.7696E-04_JPRB,7.2078E-04_JPRB,&
&7.8930E-04_JPRB,6.0344E-04_JPRB,2.4171E-02_JPRB/)
KAO( :, 3,12, 4) = (/&
&6.1383E-04_JPRB,6.1057E-04_JPRB,5.4014E-04_JPRB,3.4306E-04_JPRB,5.0450E-04_JPRB,6.7941E-04_JPRB,&
&7.3306E-04_JPRB,6.1383E-04_JPRB,2.5042E-02_JPRB/)
KAO( :, 4,12, 4) = (/&
&6.2909E-04_JPRB,6.4187E-04_JPRB,5.9443E-04_JPRB,4.2049E-04_JPRB,5.1244E-04_JPRB,6.1921E-04_JPRB,&
&6.8115E-04_JPRB,6.2909E-04_JPRB,2.5830E-02_JPRB/)
KAO( :, 5,12, 4) = (/&
&6.5010E-04_JPRB,6.8123E-04_JPRB,6.4805E-04_JPRB,5.6243E-04_JPRB,4.5555E-04_JPRB,5.8069E-04_JPRB,&
&6.9766E-04_JPRB,6.5010E-04_JPRB,2.6537E-02_JPRB/)
KAO( :, 1,13, 4) = (/&
&5.0269E-04_JPRB,4.7309E-04_JPRB,2.9722E-04_JPRB,3.6029E-04_JPRB,5.5327E-04_JPRB,6.7267E-04_JPRB,&
&6.9641E-04_JPRB,5.0269E-04_JPRB,2.5949E-02_JPRB/)
KAO( :, 2,13, 4) = (/&
&5.0863E-04_JPRB,4.9324E-04_JPRB,4.0227E-04_JPRB,3.2512E-04_JPRB,4.7435E-04_JPRB,5.7218E-04_JPRB,&
&6.4965E-04_JPRB,5.0863E-04_JPRB,2.6966E-02_JPRB/)
KAO( :, 3,13, 4) = (/&
&5.1998E-04_JPRB,5.1754E-04_JPRB,4.6042E-04_JPRB,2.9200E-04_JPRB,4.1919E-04_JPRB,5.5920E-04_JPRB,&
&6.2355E-04_JPRB,5.1997E-04_JPRB,2.7905E-02_JPRB/)
KAO( :, 4,13, 4) = (/&
&5.3565E-04_JPRB,5.4724E-04_JPRB,5.0865E-04_JPRB,3.7273E-04_JPRB,4.1799E-04_JPRB,5.1125E-04_JPRB,&
&5.5790E-04_JPRB,5.3565E-04_JPRB,2.8735E-02_JPRB/)
KAO( :, 5,13, 4) = (/&
&5.5698E-04_JPRB,5.8373E-04_JPRB,5.5557E-04_JPRB,4.8519E-04_JPRB,3.8080E-04_JPRB,4.8575E-04_JPRB,&
&5.9866E-04_JPRB,5.5698E-04_JPRB,2.9481E-02_JPRB/)
KAO( :, 1, 1, 5) = (/&
&5.1773E-03_JPRB,5.5179E-03_JPRB,5.4794E-03_JPRB,5.0590E-03_JPRB,3.8870E-03_JPRB,4.6296E-03_JPRB,&
&5.9241E-03_JPRB,5.1773E-03_JPRB,1.5277E-03_JPRB/)
KAO( :, 2, 1, 5) = (/&
&5.2034E-03_JPRB,5.6993E-03_JPRB,5.7195E-03_JPRB,5.6065E-03_JPRB,5.1571E-03_JPRB,4.6383E-03_JPRB,&
&6.9998E-03_JPRB,5.2034E-03_JPRB,2.0327E-03_JPRB/)
KAO( :, 3, 1, 5) = (/&
&5.2523E-03_JPRB,5.8787E-03_JPRB,6.0084E-03_JPRB,6.0684E-03_JPRB,6.0397E-03_JPRB,6.1073E-03_JPRB,&
&5.9208E-03_JPRB,5.2523E-03_JPRB,2.5125E-03_JPRB/)
KAO( :, 4, 1, 5) = (/&
&5.3054E-03_JPRB,6.0746E-03_JPRB,6.3010E-03_JPRB,6.5205E-03_JPRB,6.8111E-03_JPRB,7.3269E-03_JPRB,&
&7.5915E-03_JPRB,5.3054E-03_JPRB,3.0259E-03_JPRB/)
KAO( :, 5, 1, 5) = (/&
&5.3679E-03_JPRB,6.2880E-03_JPRB,6.5896E-03_JPRB,6.9769E-03_JPRB,7.5426E-03_JPRB,8.2616E-03_JPRB,&
&9.5734E-03_JPRB,5.3679E-03_JPRB,3.5988E-03_JPRB/)
KAO( :, 1, 2, 5) = (/&
&4.6050E-03_JPRB,4.8904E-03_JPRB,4.7826E-03_JPRB,4.2812E-03_JPRB,3.0961E-03_JPRB,4.0066E-03_JPRB,&
&5.0115E-03_JPRB,4.6050E-03_JPRB,1.1833E-03_JPRB/)
KAO( :, 2, 2, 5) = (/&
&4.6546E-03_JPRB,5.0669E-03_JPRB,5.0153E-03_JPRB,4.8028E-03_JPRB,4.2371E-03_JPRB,3.8571E-03_JPRB,&
&5.7082E-03_JPRB,4.6545E-03_JPRB,1.5250E-03_JPRB/)
KAO( :, 3, 2, 5) = (/&
&4.7163E-03_JPRB,5.2445E-03_JPRB,5.2818E-03_JPRB,5.2193E-03_JPRB,5.0401E-03_JPRB,4.8158E-03_JPRB,&
&4.8111E-03_JPRB,4.7163E-03_JPRB,1.8851E-03_JPRB/)
KAO( :, 4, 2, 5) = (/&
&4.7840E-03_JPRB,5.4375E-03_JPRB,5.5428E-03_JPRB,5.6145E-03_JPRB,5.7557E-03_JPRB,6.0979E-03_JPRB,&
&6.0650E-03_JPRB,4.7840E-03_JPRB,2.2872E-03_JPRB/)
KAO( :, 5, 2, 5) = (/&
&4.8541E-03_JPRB,5.6350E-03_JPRB,5.8029E-03_JPRB,5.9983E-03_JPRB,6.3916E-03_JPRB,6.9220E-03_JPRB,&
&7.8417E-03_JPRB,4.8542E-03_JPRB,2.7410E-03_JPRB/)
KAO( :, 1, 3, 5) = (/&
&4.0566E-03_JPRB,4.2666E-03_JPRB,4.1136E-03_JPRB,3.4902E-03_JPRB,2.4320E-03_JPRB,3.7448E-03_JPRB,&
&4.0596E-03_JPRB,4.0566E-03_JPRB,8.5537E-04_JPRB/)
KAO( :, 2, 3, 5) = (/&
&4.1192E-03_JPRB,4.4343E-03_JPRB,4.3374E-03_JPRB,4.0126E-03_JPRB,3.2863E-03_JPRB,3.1710E-03_JPRB,&
&4.6913E-03_JPRB,4.1192E-03_JPRB,1.0912E-03_JPRB/)
KAO( :, 3, 3, 5) = (/&
&4.1883E-03_JPRB,4.6068E-03_JPRB,4.5710E-03_JPRB,4.4080E-03_JPRB,4.0587E-03_JPRB,3.3970E-03_JPRB,&
&4.0950E-03_JPRB,4.1883E-03_JPRB,1.3564E-03_JPRB/)
KAO( :, 4, 3, 5) = (/&
&4.2607E-03_JPRB,4.7874E-03_JPRB,4.8302E-03_JPRB,4.7600E-03_JPRB,4.6789E-03_JPRB,4.6803E-03_JPRB,&
&4.6046E-03_JPRB,4.2607E-03_JPRB,1.6587E-03_JPRB/)
KAO( :, 5, 3, 5) = (/&
&4.3291E-03_JPRB,4.9729E-03_JPRB,5.0821E-03_JPRB,5.1132E-03_JPRB,5.2389E-03_JPRB,5.5501E-03_JPRB,&
&6.1453E-03_JPRB,4.3291E-03_JPRB,2.0123E-03_JPRB/)
KAO( :, 1, 4, 5) = (/&
&3.5459E-03_JPRB,3.6825E-03_JPRB,3.4932E-03_JPRB,2.7637E-03_JPRB,1.9201E-03_JPRB,3.0460E-03_JPRB,&
&3.2749E-03_JPRB,3.5459E-03_JPRB,6.1561E-04_JPRB/)
KAO( :, 2, 4, 5) = (/&
&3.6061E-03_JPRB,3.8362E-03_JPRB,3.7182E-03_JPRB,3.3223E-03_JPRB,2.3497E-03_JPRB,2.6627E-03_JPRB,&
&3.6845E-03_JPRB,3.6061E-03_JPRB,7.8011E-04_JPRB/)
KAO( :, 3, 4, 5) = (/&
&3.6751E-03_JPRB,4.0009E-03_JPRB,3.9352E-03_JPRB,3.7212E-03_JPRB,3.1586E-03_JPRB,2.6599E-03_JPRB,&
&3.9284E-03_JPRB,3.6751E-03_JPRB,9.7541E-04_JPRB/)
KAO( :, 4, 4, 5) = (/&
&3.7472E-03_JPRB,4.1657E-03_JPRB,4.1547E-03_JPRB,4.0471E-03_JPRB,3.7579E-03_JPRB,3.4987E-03_JPRB,&
&3.4684E-03_JPRB,3.7472E-03_JPRB,1.2060E-03_JPRB/)
KAO( :, 5, 4, 5) = (/&
&3.8173E-03_JPRB,4.3392E-03_JPRB,4.3926E-03_JPRB,4.3575E-03_JPRB,4.2919E-03_JPRB,4.2730E-03_JPRB,&
&4.3662E-03_JPRB,3.8173E-03_JPRB,1.4743E-03_JPRB/)
KAO( :, 1, 5, 5) = (/&
&3.0911E-03_JPRB,3.1547E-03_JPRB,2.9517E-03_JPRB,2.1585E-03_JPRB,1.7089E-03_JPRB,2.5065E-03_JPRB,&
&2.6736E-03_JPRB,3.0911E-03_JPRB,4.5259E-04_JPRB/)
KAO( :, 2, 5, 5) = (/&
&3.1432E-03_JPRB,3.2952E-03_JPRB,3.1535E-03_JPRB,2.7144E-03_JPRB,1.7305E-03_JPRB,2.3740E-03_JPRB,&
&2.9171E-03_JPRB,3.1432E-03_JPRB,5.6940E-04_JPRB/)
KAO( :, 3, 5, 5) = (/&
&3.2011E-03_JPRB,3.4418E-03_JPRB,3.3526E-03_JPRB,3.0998E-03_JPRB,2.4424E-03_JPRB,2.1728E-03_JPRB,&
&3.3563E-03_JPRB,3.2011E-03_JPRB,7.1313E-04_JPRB/)
KAO( :, 4, 5, 5) = (/&
&3.2691E-03_JPRB,3.5925E-03_JPRB,3.5476E-03_JPRB,3.4130E-03_JPRB,3.0304E-03_JPRB,2.4542E-03_JPRB,&
&2.7853E-03_JPRB,3.2691E-03_JPRB,8.8641E-04_JPRB/)
KAO( :, 5, 5, 5) = (/&
&3.3413E-03_JPRB,3.7507E-03_JPRB,3.7512E-03_JPRB,3.6954E-03_JPRB,3.5144E-03_JPRB,3.3039E-03_JPRB,&
&3.1174E-03_JPRB,3.3413E-03_JPRB,1.0913E-03_JPRB/)
KAO( :, 1, 6, 5) = (/&
&2.6814E-03_JPRB,2.6940E-03_JPRB,2.4706E-03_JPRB,1.6241E-03_JPRB,1.5796E-03_JPRB,1.9986E-03_JPRB,&
&2.3111E-03_JPRB,2.6814E-03_JPRB,3.5673E-04_JPRB/)
KAO( :, 2, 6, 5) = (/&
&2.7286E-03_JPRB,2.8170E-03_JPRB,2.6566E-03_JPRB,2.1953E-03_JPRB,1.3951E-03_JPRB,2.0187E-03_JPRB,&
&2.3167E-03_JPRB,2.7286E-03_JPRB,4.3928E-04_JPRB/)
KAO( :, 3, 6, 5) = (/&
&2.7784E-03_JPRB,2.9396E-03_JPRB,2.8323E-03_JPRB,2.5431E-03_JPRB,1.8045E-03_JPRB,1.8580E-03_JPRB,&
&2.5230E-03_JPRB,2.7784E-03_JPRB,5.4225E-04_JPRB/)
KAO( :, 4, 6, 5) = (/&
&2.8457E-03_JPRB,3.0707E-03_JPRB,3.0040E-03_JPRB,2.8313E-03_JPRB,2.4304E-03_JPRB,1.8757E-03_JPRB,&
&2.4280E-03_JPRB,2.8457E-03_JPRB,6.6880E-04_JPRB/)
KAO( :, 5, 6, 5) = (/&
&2.9149E-03_JPRB,3.2145E-03_JPRB,3.1791E-03_JPRB,3.0927E-03_JPRB,2.8718E-03_JPRB,2.5020E-03_JPRB,&
&2.4114E-03_JPRB,2.9149E-03_JPRB,8.2090E-04_JPRB/)
KAO( :, 1, 7, 5) = (/&
&2.3167E-03_JPRB,2.2952E-03_JPRB,2.0696E-03_JPRB,1.1773E-03_JPRB,1.4001E-03_JPRB,1.6742E-03_JPRB,&
&2.1113E-03_JPRB,2.3167E-03_JPRB,3.6556E-04_JPRB/)
KAO( :, 2, 7, 5) = (/&
&2.3617E-03_JPRB,2.3995E-03_JPRB,2.2278E-03_JPRB,1.7561E-03_JPRB,1.2221E-03_JPRB,1.7039E-03_JPRB,&
&1.9252E-03_JPRB,2.3617E-03_JPRB,4.2264E-04_JPRB/)
KAO( :, 3, 7, 5) = (/&
&2.4125E-03_JPRB,2.5066E-03_JPRB,2.3818E-03_JPRB,2.0804E-03_JPRB,1.2642E-03_JPRB,1.6328E-03_JPRB,&
&2.0160E-03_JPRB,2.4124E-03_JPRB,4.9466E-04_JPRB/)
KAO( :, 4, 7, 5) = (/&
&2.4726E-03_JPRB,2.6189E-03_JPRB,2.5346E-03_JPRB,2.3337E-03_JPRB,1.9285E-03_JPRB,1.5396E-03_JPRB,&
&2.2851E-03_JPRB,2.4726E-03_JPRB,5.8211E-04_JPRB/)
KAO( :, 5, 7, 5) = (/&
&2.5348E-03_JPRB,2.7473E-03_JPRB,2.6870E-03_JPRB,2.5696E-03_JPRB,2.3235E-03_JPRB,1.8153E-03_JPRB,&
&1.9526E-03_JPRB,2.5348E-03_JPRB,6.8811E-04_JPRB/)
KAO( :, 1, 8, 5) = (/&
&1.9955E-03_JPRB,1.9488E-03_JPRB,1.7343E-03_JPRB,8.5576E-04_JPRB,1.2169E-03_JPRB,1.3982E-03_JPRB,&
&1.8806E-03_JPRB,1.9955E-03_JPRB,5.8425E-04_JPRB/)
KAO( :, 2, 8, 5) = (/&
&2.0363E-03_JPRB,2.0385E-03_JPRB,1.8715E-03_JPRB,1.3678E-03_JPRB,1.1488E-03_JPRB,1.3583E-03_JPRB,&
&1.6630E-03_JPRB,2.0363E-03_JPRB,6.4943E-04_JPRB/)
KAO( :, 3, 8, 5) = (/&
&2.0848E-03_JPRB,2.1355E-03_JPRB,2.0016E-03_JPRB,1.7099E-03_JPRB,1.0490E-03_JPRB,1.3612E-03_JPRB,&
&1.5304E-03_JPRB,2.0848E-03_JPRB,7.2039E-04_JPRB/)
KAO( :, 4, 8, 5) = (/&
&2.1402E-03_JPRB,2.2347E-03_JPRB,2.1377E-03_JPRB,1.9281E-03_JPRB,1.4576E-03_JPRB,1.3615E-03_JPRB,&
&1.7494E-03_JPRB,2.1402E-03_JPRB,7.9144E-04_JPRB/)
KAO( :, 5, 8, 5) = (/&
&2.1918E-03_JPRB,2.3439E-03_JPRB,2.2739E-03_JPRB,2.1323E-03_JPRB,1.8701E-03_JPRB,1.4117E-03_JPRB,&
&1.6694E-03_JPRB,2.1918E-03_JPRB,8.7428E-04_JPRB/)
KAO( :, 1, 9, 5) = (/&
&1.7089E-03_JPRB,1.6461E-03_JPRB,1.4363E-03_JPRB,6.6011E-04_JPRB,1.0235E-03_JPRB,1.2576E-03_JPRB,&
&1.6021E-03_JPRB,1.7089E-03_JPRB,2.1905E-03_JPRB/)
KAO( :, 2, 9, 5) = (/&
&1.7449E-03_JPRB,1.7240E-03_JPRB,1.5611E-03_JPRB,9.5939E-04_JPRB,1.0171E-03_JPRB,1.0930E-03_JPRB,&
&1.4980E-03_JPRB,1.7449E-03_JPRB,2.3032E-03_JPRB/)
KAO( :, 3, 9, 5) = (/&
&1.7892E-03_JPRB,1.8095E-03_JPRB,1.6779E-03_JPRB,1.3700E-03_JPRB,8.8733E-04_JPRB,1.1976E-03_JPRB,&
&1.2362E-03_JPRB,1.7892E-03_JPRB,2.4285E-03_JPRB/)
KAO( :, 4, 9, 5) = (/&
&1.8369E-03_JPRB,1.8975E-03_JPRB,1.7975E-03_JPRB,1.5888E-03_JPRB,1.0202E-03_JPRB,1.1883E-03_JPRB,&
&1.3430E-03_JPRB,1.8369E-03_JPRB,2.5680E-03_JPRB/)
KAO( :, 5, 9, 5) = (/&
&1.8812E-03_JPRB,1.9874E-03_JPRB,1.9123E-03_JPRB,1.7614E-03_JPRB,1.4649E-03_JPRB,1.1491E-03_JPRB,&
&1.5713E-03_JPRB,1.8812E-03_JPRB,2.7221E-03_JPRB/)
KAO( :, 1,10, 5) = (/&
&1.4572E-03_JPRB,1.3868E-03_JPRB,1.1826E-03_JPRB,6.2346E-04_JPRB,8.6762E-04_JPRB,1.0836E-03_JPRB,&
&1.3348E-03_JPRB,1.4572E-03_JPRB,1.2658E-02_JPRB/)
KAO( :, 2,10, 5) = (/&
&1.4886E-03_JPRB,1.4531E-03_JPRB,1.3004E-03_JPRB,6.9239E-04_JPRB,8.6868E-04_JPRB,9.6168E-04_JPRB,&
&1.2569E-03_JPRB,1.4886E-03_JPRB,1.3059E-02_JPRB/)
KAO( :, 3,10, 5) = (/&
&1.5264E-03_JPRB,1.5274E-03_JPRB,1.4051E-03_JPRB,1.0747E-03_JPRB,7.7218E-04_JPRB,9.7410E-04_JPRB,&
&1.0859E-03_JPRB,1.5264E-03_JPRB,1.3449E-02_JPRB/)
KAO( :, 4,10, 5) = (/&
&1.5664E-03_JPRB,1.6018E-03_JPRB,1.5021E-03_JPRB,1.3016E-03_JPRB,7.5442E-04_JPRB,1.0421E-03_JPRB,&
&1.0986E-03_JPRB,1.5664E-03_JPRB,1.3823E-02_JPRB/)
KAO( :, 5,10, 5) = (/&
&1.6039E-03_JPRB,1.6782E-03_JPRB,1.6029E-03_JPRB,1.4558E-03_JPRB,1.1428E-03_JPRB,9.8459E-04_JPRB,&
&1.2311E-03_JPRB,1.6039E-03_JPRB,1.4197E-02_JPRB/)
KAO( :, 1,11, 5) = (/&
&1.2517E-03_JPRB,1.1909E-03_JPRB,1.0253E-03_JPRB,4.8905E-04_JPRB,7.3597E-04_JPRB,9.0427E-04_JPRB,&
&1.2588E-03_JPRB,1.2517E-03_JPRB,2.8270E-02_JPRB/)
KAO( :, 2,11, 5) = (/&
&1.2817E-03_JPRB,1.2489E-03_JPRB,1.1208E-03_JPRB,6.0287E-04_JPRB,7.2254E-04_JPRB,8.2946E-04_JPRB,&
&1.0205E-03_JPRB,1.2817E-03_JPRB,2.9032E-02_JPRB/)
KAO( :, 3,11, 5) = (/&
&1.3127E-03_JPRB,1.3112E-03_JPRB,1.2059E-03_JPRB,9.4181E-04_JPRB,6.2131E-04_JPRB,8.6171E-04_JPRB,&
&8.9101E-04_JPRB,1.3127E-03_JPRB,2.9698E-02_JPRB/)
KAO( :, 4,11, 5) = (/&
&1.3452E-03_JPRB,1.3741E-03_JPRB,1.2883E-03_JPRB,1.1215E-03_JPRB,6.5766E-04_JPRB,8.7354E-04_JPRB,&
&9.3021E-04_JPRB,1.3452E-03_JPRB,3.0336E-02_JPRB/)
KAO( :, 5,11, 5) = (/&
&1.3753E-03_JPRB,1.4371E-03_JPRB,1.3746E-03_JPRB,1.2547E-03_JPRB,9.9517E-04_JPRB,7.9857E-04_JPRB,&
&1.0959E-03_JPRB,1.3753E-03_JPRB,3.0956E-02_JPRB/)
KAO( :, 1,12, 5) = (/&
&1.0733E-03_JPRB,1.0215E-03_JPRB,8.8454E-04_JPRB,3.9006E-04_JPRB,6.2359E-04_JPRB,7.4085E-04_JPRB,&
&1.0395E-03_JPRB,1.0733E-03_JPRB,4.0158E-02_JPRB/)
KAO( :, 2,12, 5) = (/&
&1.0987E-03_JPRB,1.0703E-03_JPRB,9.6221E-04_JPRB,5.3528E-04_JPRB,5.8115E-04_JPRB,7.1438E-04_JPRB,&
&8.3203E-04_JPRB,1.0987E-03_JPRB,4.1196E-02_JPRB/)
KAO( :, 3,12, 5) = (/&
&1.1257E-03_JPRB,1.1222E-03_JPRB,1.0309E-03_JPRB,8.1291E-04_JPRB,4.9033E-04_JPRB,7.2341E-04_JPRB,&
&7.5536E-04_JPRB,1.1257E-03_JPRB,4.2149E-02_JPRB/)
KAO( :, 4,12, 5) = (/&
&1.1520E-03_JPRB,1.1737E-03_JPRB,1.0999E-03_JPRB,9.6654E-04_JPRB,5.7890E-04_JPRB,6.9991E-04_JPRB,&
&7.9257E-04_JPRB,1.1520E-03_JPRB,4.3060E-02_JPRB/)
KAO( :, 5,12, 5) = (/&
&1.1770E-03_JPRB,1.2266E-03_JPRB,1.1727E-03_JPRB,1.0746E-03_JPRB,8.6506E-04_JPRB,6.5737E-04_JPRB,&
&9.1851E-04_JPRB,1.1770E-03_JPRB,4.3899E-02_JPRB/)
KAO( :, 1,13, 5) = (/&
&9.1723E-04_JPRB,8.7340E-04_JPRB,7.5855E-04_JPRB,3.3160E-04_JPRB,5.1898E-04_JPRB,6.0675E-04_JPRB,&
&8.3666E-04_JPRB,9.1723E-04_JPRB,4.5805E-02_JPRB/)
KAO( :, 2,13, 5) = (/&
&9.3894E-04_JPRB,9.1416E-04_JPRB,8.2179E-04_JPRB,4.8369E-04_JPRB,4.6977E-04_JPRB,6.3046E-04_JPRB,&
&6.9917E-04_JPRB,9.3894E-04_JPRB,4.7104E-02_JPRB/)
KAO( :, 3,13, 5) = (/&
&9.6174E-04_JPRB,9.5729E-04_JPRB,8.7932E-04_JPRB,7.0453E-04_JPRB,4.0162E-04_JPRB,5.9248E-04_JPRB,&
&6.3372E-04_JPRB,9.6174E-04_JPRB,4.8249E-02_JPRB/)
KAO( :, 4,13, 5) = (/&
&9.8438E-04_JPRB,1.0004E-03_JPRB,9.3575E-04_JPRB,8.2536E-04_JPRB,5.0557E-04_JPRB,5.5685E-04_JPRB,&
&6.8082E-04_JPRB,9.8438E-04_JPRB,4.9296E-02_JPRB/)
KAO( :, 5,13, 5) = (/&
&1.0080E-03_JPRB,1.0464E-03_JPRB,9.9862E-04_JPRB,9.1769E-04_JPRB,7.4911E-04_JPRB,5.5133E-04_JPRB,&
&7.2141E-04_JPRB,1.0080E-03_JPRB,5.0236E-02_JPRB/)
KAO( :, 1, 1, 6) = (/&
&8.5333E-03_JPRB,9.0798E-03_JPRB,9.1539E-03_JPRB,8.9379E-03_JPRB,8.0082E-03_JPRB,5.5783E-03_JPRB,&
&6.6117E-03_JPRB,8.5333E-03_JPRB,2.8261E-03_JPRB/)
KAO( :, 2, 1, 6) = (/&
&8.4109E-03_JPRB,9.3459E-03_JPRB,9.6624E-03_JPRB,9.7547E-03_JPRB,9.5796E-03_JPRB,8.4027E-03_JPRB,&
&6.4961E-03_JPRB,8.4109E-03_JPRB,3.5780E-03_JPRB/)
KAO( :, 3, 1, 6) = (/&
&8.3030E-03_JPRB,9.6326E-03_JPRB,1.0206E-02_JPRB,1.0614E-02_JPRB,1.0858E-02_JPRB,1.0462E-02_JPRB,&
&9.8456E-03_JPRB,8.3030E-03_JPRB,4.4090E-03_JPRB/)
KAO( :, 4, 1, 6) = (/&
&8.2237E-03_JPRB,9.8958E-03_JPRB,1.0796E-02_JPRB,1.1545E-02_JPRB,1.2099E-02_JPRB,1.2369E-02_JPRB,&
&1.2077E-02_JPRB,8.2237E-03_JPRB,5.3050E-03_JPRB/)
KAO( :, 5, 1, 6) = (/&
&8.1599E-03_JPRB,1.0181E-02_JPRB,1.1469E-02_JPRB,1.2490E-02_JPRB,1.3377E-02_JPRB,1.4165E-02_JPRB,&
&1.4318E-02_JPRB,8.1599E-03_JPRB,6.2987E-03_JPRB/)
KAO( :, 1, 2, 6) = (/&
&7.7094E-03_JPRB,8.1495E-03_JPRB,8.1817E-03_JPRB,7.9690E-03_JPRB,7.0574E-03_JPRB,4.6583E-03_JPRB,&
&5.9458E-03_JPRB,7.7094E-03_JPRB,2.1253E-03_JPRB/)
KAO( :, 2, 2, 6) = (/&
&7.6098E-03_JPRB,8.3857E-03_JPRB,8.6188E-03_JPRB,8.6202E-03_JPRB,8.3668E-03_JPRB,7.2354E-03_JPRB,&
&5.4614E-03_JPRB,7.6098E-03_JPRB,2.6911E-03_JPRB/)
KAO( :, 3, 2, 6) = (/&
&7.5380E-03_JPRB,8.6324E-03_JPRB,9.0696E-03_JPRB,9.3578E-03_JPRB,9.5323E-03_JPRB,9.1344E-03_JPRB,&
&8.4099E-03_JPRB,7.5380E-03_JPRB,3.3283E-03_JPRB/)
KAO( :, 4, 2, 6) = (/&
&7.4926E-03_JPRB,8.8750E-03_JPRB,9.5781E-03_JPRB,1.0164E-02_JPRB,1.0603E-02_JPRB,1.0755E-02_JPRB,&
&1.0378E-02_JPRB,7.4926E-03_JPRB,4.0288E-03_JPRB/)
KAO( :, 5, 2, 6) = (/&
&7.4775E-03_JPRB,9.1627E-03_JPRB,1.0156E-02_JPRB,1.0982E-02_JPRB,1.1695E-02_JPRB,1.2352E-02_JPRB,&
&1.2667E-02_JPRB,7.4775E-03_JPRB,4.8116E-03_JPRB/)
KAO( :, 1, 3, 6) = (/&
&6.9121E-03_JPRB,7.2188E-03_JPRB,7.1796E-03_JPRB,6.8889E-03_JPRB,5.8502E-03_JPRB,3.2278E-03_JPRB,&
&4.9879E-03_JPRB,6.9121E-03_JPRB,1.5160E-03_JPRB/)
KAO( :, 2, 3, 6) = (/&
&6.8480E-03_JPRB,7.4276E-03_JPRB,7.5203E-03_JPRB,7.4048E-03_JPRB,7.0014E-03_JPRB,5.7055E-03_JPRB,&
&4.3384E-03_JPRB,6.8480E-03_JPRB,1.9279E-03_JPRB/)
KAO( :, 3, 3, 6) = (/&
&6.8135E-03_JPRB,7.6493E-03_JPRB,7.8976E-03_JPRB,8.0141E-03_JPRB,8.0170E-03_JPRB,7.5441E-03_JPRB,&
&6.5174E-03_JPRB,6.8135E-03_JPRB,2.4028E-03_JPRB/)
KAO( :, 4, 3, 6) = (/&
&6.8122E-03_JPRB,7.8956E-03_JPRB,8.3131E-03_JPRB,8.6965E-03_JPRB,8.9952E-03_JPRB,8.9752E-03_JPRB,&
&8.4882E-03_JPRB,6.8122E-03_JPRB,2.9375E-03_JPRB/)
KAO( :, 5, 3, 6) = (/&
&6.8492E-03_JPRB,8.1657E-03_JPRB,8.7936E-03_JPRB,9.3904E-03_JPRB,9.9168E-03_JPRB,1.0345E-02_JPRB,&
&1.0484E-02_JPRB,6.8492E-03_JPRB,3.5390E-03_JPRB/)
KAO( :, 1, 4, 6) = (/&
&6.1397E-03_JPRB,6.3324E-03_JPRB,6.2269E-03_JPRB,5.8666E-03_JPRB,4.6601E-03_JPRB,2.6335E-03_JPRB,&
&4.3502E-03_JPRB,6.1397E-03_JPRB,1.0676E-03_JPRB/)
KAO( :, 2, 4, 6) = (/&
&6.1071E-03_JPRB,6.5281E-03_JPRB,6.5061E-03_JPRB,6.2987E-03_JPRB,5.7315E-03_JPRB,4.2122E-03_JPRB,&
&3.5243E-03_JPRB,6.1071E-03_JPRB,1.3674E-03_JPRB/)
KAO( :, 3, 4, 6) = (/&
&6.1173E-03_JPRB,6.7424E-03_JPRB,6.8351E-03_JPRB,6.7928E-03_JPRB,6.6355E-03_JPRB,6.0084E-03_JPRB,&
&4.4111E-03_JPRB,6.1173E-03_JPRB,1.7216E-03_JPRB/)
KAO( :, 4, 4, 6) = (/&
&6.1616E-03_JPRB,6.9850E-03_JPRB,7.2018E-03_JPRB,7.3533E-03_JPRB,7.4639E-03_JPRB,7.3054E-03_JPRB,&
&6.7355E-03_JPRB,6.1616E-03_JPRB,2.1295E-03_JPRB/)
KAO( :, 5, 4, 6) = (/&
&6.2327E-03_JPRB,7.2498E-03_JPRB,7.6166E-03_JPRB,7.9404E-03_JPRB,8.2799E-03_JPRB,8.5196E-03_JPRB,&
&8.4780E-03_JPRB,6.2327E-03_JPRB,2.5893E-03_JPRB/)
KAO( :, 1, 5, 6) = (/&
&5.4116E-03_JPRB,5.5054E-03_JPRB,5.3551E-03_JPRB,4.9387E-03_JPRB,3.4030E-03_JPRB,2.3925E-03_JPRB,&
&3.5026E-03_JPRB,5.4116E-03_JPRB,7.5991E-04_JPRB/)
KAO( :, 2, 5, 6) = (/&
&5.4112E-03_JPRB,5.7013E-03_JPRB,5.6024E-03_JPRB,5.3215E-03_JPRB,4.5735E-03_JPRB,2.7843E-03_JPRB,&
&3.3021E-03_JPRB,5.4112E-03_JPRB,9.7889E-04_JPRB/)
KAO( :, 3, 5, 6) = (/&
&5.4571E-03_JPRB,5.9124E-03_JPRB,5.8939E-03_JPRB,5.7468E-03_JPRB,5.4242E-03_JPRB,4.5784E-03_JPRB,&
&3.1711E-03_JPRB,5.4571E-03_JPRB,1.2420E-03_JPRB/)
KAO( :, 4, 5, 6) = (/&
&5.5303E-03_JPRB,6.1539E-03_JPRB,6.2322E-03_JPRB,6.2166E-03_JPRB,6.1395E-03_JPRB,5.8002E-03_JPRB,&
&5.0694E-03_JPRB,5.5303E-03_JPRB,1.5508E-03_JPRB/)
KAO( :, 5, 5, 6) = (/&
&5.6126E-03_JPRB,6.4231E-03_JPRB,6.6120E-03_JPRB,6.7193E-03_JPRB,6.8307E-03_JPRB,6.8747E-03_JPRB,&
&6.7129E-03_JPRB,5.6126E-03_JPRB,1.9069E-03_JPRB/)
KAO( :, 1, 6, 6) = (/&
&4.7396E-03_JPRB,4.7463E-03_JPRB,4.5518E-03_JPRB,4.0433E-03_JPRB,2.2638E-03_JPRB,2.3141E-03_JPRB,&
&2.8805E-03_JPRB,4.7396E-03_JPRB,5.6698E-04_JPRB/)
KAO( :, 2, 6, 6) = (/&
&4.7673E-03_JPRB,4.9357E-03_JPRB,4.7801E-03_JPRB,4.4457E-03_JPRB,3.5304E-03_JPRB,1.8920E-03_JPRB,&
&2.9747E-03_JPRB,4.7673E-03_JPRB,7.2146E-04_JPRB/)
KAO( :, 3, 6, 6) = (/&
&4.8326E-03_JPRB,5.1460E-03_JPRB,5.0538E-03_JPRB,4.8362E-03_JPRB,4.3455E-03_JPRB,3.2638E-03_JPRB,&
&2.4492E-03_JPRB,4.8326E-03_JPRB,9.1393E-04_JPRB/)
KAO( :, 4, 6, 6) = (/&
&4.9138E-03_JPRB,5.3898E-03_JPRB,5.3670E-03_JPRB,5.2448E-03_JPRB,5.0135E-03_JPRB,4.4890E-03_JPRB,&
&3.4781E-03_JPRB,4.9137E-03_JPRB,1.1441E-03_JPRB/)
KAO( :, 5, 6, 6) = (/&
&5.0007E-03_JPRB,5.6605E-03_JPRB,5.7246E-03_JPRB,5.6834E-03_JPRB,5.6159E-03_JPRB,5.4449E-03_JPRB,&
&5.0343E-03_JPRB,5.0007E-03_JPRB,1.4139E-03_JPRB/)
KAO( :, 1, 7, 6) = (/&
&4.1378E-03_JPRB,4.0754E-03_JPRB,3.8389E-03_JPRB,3.2475E-03_JPRB,1.4857E-03_JPRB,2.1025E-03_JPRB,&
&2.2984E-03_JPRB,4.1378E-03_JPRB,5.2481E-04_JPRB/)
KAO( :, 2, 7, 6) = (/&
&4.1822E-03_JPRB,4.2521E-03_JPRB,4.0570E-03_JPRB,3.6688E-03_JPRB,2.5306E-03_JPRB,1.4831E-03_JPRB,&
&2.6067E-03_JPRB,4.1822E-03_JPRB,6.3111E-04_JPRB/)
KAO( :, 3, 7, 6) = (/&
&4.2509E-03_JPRB,4.4583E-03_JPRB,4.3081E-03_JPRB,4.0486E-03_JPRB,3.4473E-03_JPRB,2.1091E-03_JPRB,&
&1.9768E-03_JPRB,4.2509E-03_JPRB,7.6397E-04_JPRB/)
KAO( :, 4, 7, 6) = (/&
&4.3334E-03_JPRB,4.6876E-03_JPRB,4.6037E-03_JPRB,4.4308E-03_JPRB,4.0651E-03_JPRB,3.3647E-03_JPRB,&
&2.1587E-03_JPRB,4.3334E-03_JPRB,9.2876E-04_JPRB/)
KAO( :, 5, 7, 6) = (/&
&4.4225E-03_JPRB,4.9342E-03_JPRB,4.9410E-03_JPRB,4.8191E-03_JPRB,4.6280E-03_JPRB,4.2870E-03_JPRB,&
&3.6120E-03_JPRB,4.4226E-03_JPRB,1.1252E-03_JPRB/)
KAO( :, 1, 8, 6) = (/&
&3.6094E-03_JPRB,3.5033E-03_JPRB,3.2400E-03_JPRB,2.6287E-03_JPRB,9.9863E-04_JPRB,1.7500E-03_JPRB,&
&1.8960E-03_JPRB,3.6094E-03_JPRB,8.2600E-04_JPRB/)
KAO( :, 2, 8, 6) = (/&
&3.6637E-03_JPRB,3.6642E-03_JPRB,3.4430E-03_JPRB,3.0211E-03_JPRB,1.7119E-03_JPRB,1.3558E-03_JPRB,&
&2.1462E-03_JPRB,3.6637E-03_JPRB,9.0812E-04_JPRB/)
KAO( :, 3, 8, 6) = (/&
&3.7354E-03_JPRB,3.8451E-03_JPRB,3.6742E-03_JPRB,3.3691E-03_JPRB,2.6819E-03_JPRB,1.3910E-03_JPRB,&
&1.9474E-03_JPRB,3.7354E-03_JPRB,1.0101E-03_JPRB/)
KAO( :, 4, 8, 6) = (/&
&3.8119E-03_JPRB,4.0509E-03_JPRB,3.9304E-03_JPRB,3.7228E-03_JPRB,3.3248E-03_JPRB,2.3768E-03_JPRB,&
&1.6650E-03_JPRB,3.8120E-03_JPRB,1.1353E-03_JPRB/)
KAO( :, 5, 8, 6) = (/&
&3.8974E-03_JPRB,4.2692E-03_JPRB,4.2189E-03_JPRB,4.0809E-03_JPRB,3.8147E-03_JPRB,3.3186E-03_JPRB,&
&2.4419E-03_JPRB,3.8974E-03_JPRB,1.2742E-03_JPRB/)
KAO( :, 1, 9, 6) = (/&
&3.1509E-03_JPRB,3.0135E-03_JPRB,2.7414E-03_JPRB,2.0848E-03_JPRB,8.0225E-04_JPRB,1.3860E-03_JPRB,&
&1.6095E-03_JPRB,3.1509E-03_JPRB,3.2874E-03_JPRB/)
KAO( :, 2, 9, 6) = (/&
&3.2069E-03_JPRB,3.1552E-03_JPRB,2.9300E-03_JPRB,2.5120E-03_JPRB,1.1882E-03_JPRB,1.2244E-03_JPRB,&
&1.8134E-03_JPRB,3.2069E-03_JPRB,3.4426E-03_JPRB/)
KAO( :, 3, 9, 6) = (/&
&3.2779E-03_JPRB,3.3142E-03_JPRB,3.1292E-03_JPRB,2.8177E-03_JPRB,2.0556E-03_JPRB,1.0032E-03_JPRB,&
&1.7964E-03_JPRB,3.2779E-03_JPRB,3.6002E-03_JPRB/)
KAO( :, 4, 9, 6) = (/&
&3.3512E-03_JPRB,3.4918E-03_JPRB,3.3477E-03_JPRB,3.1214E-03_JPRB,2.7090E-03_JPRB,1.5625E-03_JPRB,&
&1.3565E-03_JPRB,3.3512E-03_JPRB,3.7586E-03_JPRB/)
KAO( :, 5, 9, 6) = (/&
&3.4301E-03_JPRB,3.6852E-03_JPRB,3.5951E-03_JPRB,3.4314E-03_JPRB,3.1547E-03_JPRB,2.5504E-03_JPRB,&
&1.5207E-03_JPRB,3.4301E-03_JPRB,3.9312E-03_JPRB/)
KAO( :, 1,10, 6) = (/&
&2.7434E-03_JPRB,2.5990E-03_JPRB,2.3418E-03_JPRB,1.5988E-03_JPRB,7.7035E-04_JPRB,1.2159E-03_JPRB,&
&1.3978E-03_JPRB,2.7434E-03_JPRB,2.0046E-02_JPRB/)
KAO( :, 2,10, 6) = (/&
&2.7987E-03_JPRB,2.7245E-03_JPRB,2.5022E-03_JPRB,2.1126E-03_JPRB,8.9708E-04_JPRB,1.0763E-03_JPRB,&
&1.5093E-03_JPRB,2.7987E-03_JPRB,2.0516E-02_JPRB/)
KAO( :, 3,10, 6) = (/&
&2.8639E-03_JPRB,2.8623E-03_JPRB,2.6825E-03_JPRB,2.3837E-03_JPRB,1.5791E-03_JPRB,8.7614E-04_JPRB,&
&1.4149E-03_JPRB,2.8639E-03_JPRB,2.0938E-02_JPRB/)
KAO( :, 4,10, 6) = (/&
&2.9341E-03_JPRB,3.0198E-03_JPRB,2.8777E-03_JPRB,2.6425E-03_JPRB,2.2095E-03_JPRB,1.1197E-03_JPRB,&
&1.2062E-03_JPRB,2.9342E-03_JPRB,2.1345E-02_JPRB/)
KAO( :, 5,10, 6) = (/&
&3.0129E-03_JPRB,3.1899E-03_JPRB,3.0825E-03_JPRB,2.9045E-03_JPRB,2.6201E-03_JPRB,1.9654E-03_JPRB,&
&1.1926E-03_JPRB,3.0129E-03_JPRB,2.1744E-02_JPRB/)
KAO( :, 1,11, 6) = (/&
&2.3930E-03_JPRB,2.2760E-03_JPRB,2.0475E-03_JPRB,1.4917E-03_JPRB,6.1519E-04_JPRB,9.5739E-04_JPRB,&
&1.2117E-03_JPRB,2.3930E-03_JPRB,4.6010E-02_JPRB/)
KAO( :, 2,11, 6) = (/&
&2.4495E-03_JPRB,2.3897E-03_JPRB,2.1964E-03_JPRB,1.8774E-03_JPRB,8.8795E-04_JPRB,8.5785E-04_JPRB,&
&1.2212E-03_JPRB,2.4495E-03_JPRB,4.7118E-02_JPRB/)
KAO( :, 3,11, 6) = (/&
&2.5108E-03_JPRB,2.5149E-03_JPRB,2.3607E-03_JPRB,2.1179E-03_JPRB,1.5063E-03_JPRB,7.2487E-04_JPRB,&
&1.1617E-03_JPRB,2.5108E-03_JPRB,4.8044E-02_JPRB/)
KAO( :, 4,11, 6) = (/&
&2.5797E-03_JPRB,2.6613E-03_JPRB,2.5391E-03_JPRB,2.3353E-03_JPRB,1.9791E-03_JPRB,1.1049E-03_JPRB,&
&9.4883E-04_JPRB,2.5797E-03_JPRB,4.8805E-02_JPRB/)
KAO( :, 5,11, 6) = (/&
&2.6499E-03_JPRB,2.8182E-03_JPRB,2.7229E-03_JPRB,2.5580E-03_JPRB,2.3142E-03_JPRB,1.8079E-03_JPRB,&
&1.0035E-03_JPRB,2.6499E-03_JPRB,4.9391E-02_JPRB/)
KAO( :, 1,12, 6) = (/&
&2.0746E-03_JPRB,1.9783E-03_JPRB,1.7801E-03_JPRB,1.3556E-03_JPRB,4.8267E-04_JPRB,8.1463E-04_JPRB,&
&1.0185E-03_JPRB,2.0746E-03_JPRB,6.7547E-02_JPRB/)
KAO( :, 2,12, 6) = (/&
&2.1273E-03_JPRB,2.0770E-03_JPRB,1.9105E-03_JPRB,1.6481E-03_JPRB,8.3724E-04_JPRB,7.1683E-04_JPRB,&
&1.0103E-03_JPRB,2.1273E-03_JPRB,6.9266E-02_JPRB/)
KAO( :, 3,12, 6) = (/&
&2.1844E-03_JPRB,2.1915E-03_JPRB,2.0594E-03_JPRB,1.8587E-03_JPRB,1.3892E-03_JPRB,6.4751E-04_JPRB,&
&9.5728E-04_JPRB,2.1844E-03_JPRB,7.0619E-02_JPRB/)
KAO( :, 4,12, 6) = (/&
&2.2441E-03_JPRB,2.3226E-03_JPRB,2.2206E-03_JPRB,2.0453E-03_JPRB,1.7491E-03_JPRB,1.0405E-03_JPRB,&
&7.8138E-04_JPRB,2.2441E-03_JPRB,7.1602E-02_JPRB/)
KAO( :, 5,12, 6) = (/&
&2.3050E-03_JPRB,2.4598E-03_JPRB,2.3822E-03_JPRB,2.2381E-03_JPRB,2.0304E-03_JPRB,1.6325E-03_JPRB,&
&9.2438E-04_JPRB,2.3050E-03_JPRB,7.2303E-02_JPRB/)
KAO( :, 1,13, 6) = (/&
&1.7883E-03_JPRB,1.7065E-03_JPRB,1.5374E-03_JPRB,1.2007E-03_JPRB,4.3025E-04_JPRB,6.7590E-04_JPRB,&
&8.1885E-04_JPRB,1.7883E-03_JPRB,7.9860E-02_JPRB/)
KAO( :, 2,13, 6) = (/&
&1.8363E-03_JPRB,1.7948E-03_JPRB,1.6528E-03_JPRB,1.4324E-03_JPRB,7.6774E-04_JPRB,6.2246E-04_JPRB,&
&8.1329E-04_JPRB,1.8363E-03_JPRB,8.1807E-02_JPRB/)
KAO( :, 3,13, 6) = (/&
&1.8869E-03_JPRB,1.8960E-03_JPRB,1.7818E-03_JPRB,1.6095E-03_JPRB,1.2397E-03_JPRB,5.6950E-04_JPRB,&
&8.2318E-04_JPRB,1.8869E-03_JPRB,8.3291E-02_JPRB/)
KAO( :, 4,13, 6) = (/&
&1.9378E-03_JPRB,2.0074E-03_JPRB,1.9206E-03_JPRB,1.7755E-03_JPRB,1.5322E-03_JPRB,9.5845E-04_JPRB,&
&6.9708E-04_JPRB,1.9378E-03_JPRB,8.4416E-02_JPRB/)
KAO( :, 5,13, 6) = (/&
&1.9900E-03_JPRB,2.1258E-03_JPRB,2.0644E-03_JPRB,1.9405E-03_JPRB,1.7651E-03_JPRB,1.4419E-03_JPRB,&
&8.3688E-04_JPRB,1.9900E-03_JPRB,8.5292E-02_JPRB/)
KAO( :, 1, 1, 7) = (/&
&1.6473E-02_JPRB,1.6639E-02_JPRB,1.6620E-02_JPRB,1.6044E-02_JPRB,1.5024E-02_JPRB,1.3187E-02_JPRB,&
&7.6213E-03_JPRB,1.6473E-02_JPRB,5.9369E-03_JPRB/)
KAO( :, 2, 1, 7) = (/&
&1.6283E-02_JPRB,1.7319E-02_JPRB,1.7601E-02_JPRB,1.7371E-02_JPRB,1.6714E-02_JPRB,1.5606E-02_JPRB,&
&1.2675E-02_JPRB,1.6283E-02_JPRB,7.5309E-03_JPRB/)
KAO( :, 3, 1, 7) = (/&
&1.6044E-02_JPRB,1.7939E-02_JPRB,1.8616E-02_JPRB,1.8736E-02_JPRB,1.8509E-02_JPRB,1.7932E-02_JPRB,&
&1.6316E-02_JPRB,1.6044E-02_JPRB,9.3034E-03_JPRB/)
KAO( :, 4, 1, 7) = (/&
&1.5780E-02_JPRB,1.8566E-02_JPRB,1.9707E-02_JPRB,2.0218E-02_JPRB,2.0468E-02_JPRB,2.0392E-02_JPRB,&
&2.0221E-02_JPRB,1.5780E-02_JPRB,1.1241E-02_JPRB/)
KAO( :, 5, 1, 7) = (/&
&1.5514E-02_JPRB,1.9239E-02_JPRB,2.0866E-02_JPRB,2.1848E-02_JPRB,2.2518E-02_JPRB,2.2938E-02_JPRB,&
&2.4338E-02_JPRB,1.5514E-02_JPRB,1.3369E-02_JPRB/)
KAO( :, 1, 2, 7) = (/&
&1.5534E-02_JPRB,1.5698E-02_JPRB,1.5655E-02_JPRB,1.5068E-02_JPRB,1.4135E-02_JPRB,1.2270E-02_JPRB,&
&7.4181E-03_JPRB,1.5534E-02_JPRB,4.4640E-03_JPRB/)
KAO( :, 2, 2, 7) = (/&
&1.5342E-02_JPRB,1.6324E-02_JPRB,1.6590E-02_JPRB,1.6353E-02_JPRB,1.5831E-02_JPRB,1.4815E-02_JPRB,&
&1.2543E-02_JPRB,1.5342E-02_JPRB,5.6970E-03_JPRB/)
KAO( :, 3, 2, 7) = (/&
&1.5098E-02_JPRB,1.6904E-02_JPRB,1.7545E-02_JPRB,1.7691E-02_JPRB,1.7497E-02_JPRB,1.7085E-02_JPRB,&
&1.5776E-02_JPRB,1.5098E-02_JPRB,7.0876E-03_JPRB/)
KAO( :, 4, 2, 7) = (/&
&1.4834E-02_JPRB,1.7491E-02_JPRB,1.8583E-02_JPRB,1.9136E-02_JPRB,1.9381E-02_JPRB,1.9396E-02_JPRB,&
&1.8919E-02_JPRB,1.4834E-02_JPRB,8.6392E-03_JPRB/)
KAO( :, 5, 2, 7) = (/&
&1.4582E-02_JPRB,1.8087E-02_JPRB,1.9710E-02_JPRB,2.0699E-02_JPRB,2.1415E-02_JPRB,2.1844E-02_JPRB,&
&2.2101E-02_JPRB,1.4582E-02_JPRB,1.0344E-02_JPRB/)
KAO( :, 1, 3, 7) = (/&
&1.4379E-02_JPRB,1.4400E-02_JPRB,1.4273E-02_JPRB,1.3714E-02_JPRB,1.2774E-02_JPRB,1.0758E-02_JPRB,&
&5.9221E-03_JPRB,1.4379E-02_JPRB,3.1627E-03_JPRB/)
KAO( :, 2, 3, 7) = (/&
&1.4181E-02_JPRB,1.4962E-02_JPRB,1.5204E-02_JPRB,1.4906E-02_JPRB,1.4357E-02_JPRB,1.3275E-02_JPRB,&
&1.0750E-02_JPRB,1.4181E-02_JPRB,4.0720E-03_JPRB/)
KAO( :, 3, 3, 7) = (/&
&1.3955E-02_JPRB,1.5485E-02_JPRB,1.6078E-02_JPRB,1.6124E-02_JPRB,1.5928E-02_JPRB,1.5419E-02_JPRB,&
&1.4145E-02_JPRB,1.3955E-02_JPRB,5.1227E-03_JPRB/)
KAO( :, 4, 3, 7) = (/&
&1.3715E-02_JPRB,1.6019E-02_JPRB,1.7011E-02_JPRB,1.7443E-02_JPRB,1.7601E-02_JPRB,1.7599E-02_JPRB,&
&1.7151E-02_JPRB,1.3715E-02_JPRB,6.3251E-03_JPRB/)
KAO( :, 5, 3, 7) = (/&
&1.3488E-02_JPRB,1.6566E-02_JPRB,1.8015E-02_JPRB,1.8885E-02_JPRB,1.9466E-02_JPRB,1.9880E-02_JPRB,&
&1.9891E-02_JPRB,1.3488E-02_JPRB,7.6362E-03_JPRB/)
KAO( :, 1, 4, 7) = (/&
&1.3100E-02_JPRB,1.2948E-02_JPRB,1.2709E-02_JPRB,1.2152E-02_JPRB,1.1211E-02_JPRB,8.9540E-03_JPRB,&
&3.9235E-03_JPRB,1.3100E-02_JPRB,2.2077E-03_JPRB/)
KAO( :, 2, 4, 7) = (/&
&1.2922E-02_JPRB,1.3421E-02_JPRB,1.3563E-02_JPRB,1.3273E-02_JPRB,1.2687E-02_JPRB,1.1465E-02_JPRB,&
&8.5932E-03_JPRB,1.2922E-02_JPRB,2.8908E-03_JPRB/)
KAO( :, 3, 4, 7) = (/&
&1.2710E-02_JPRB,1.3886E-02_JPRB,1.4373E-02_JPRB,1.4371E-02_JPRB,1.4080E-02_JPRB,1.3407E-02_JPRB,&
&1.1985E-02_JPRB,1.2710E-02_JPRB,3.6760E-03_JPRB/)
KAO( :, 4, 4, 7) = (/&
&1.2510E-02_JPRB,1.4373E-02_JPRB,1.5200E-02_JPRB,1.5503E-02_JPRB,1.5542E-02_JPRB,1.5364E-02_JPRB,&
&1.4835E-02_JPRB,1.2510E-02_JPRB,4.5891E-03_JPRB/)
KAO( :, 5, 4, 7) = (/&
&1.2325E-02_JPRB,1.4885E-02_JPRB,1.6099E-02_JPRB,1.6758E-02_JPRB,1.7169E-02_JPRB,1.7435E-02_JPRB,&
&1.7471E-02_JPRB,1.2325E-02_JPRB,5.6179E-03_JPRB/)
KAO( :, 1, 5, 7) = (/&
&1.1785E-02_JPRB,1.1507E-02_JPRB,1.1168E-02_JPRB,1.0600E-02_JPRB,9.6507E-03_JPRB,6.9414E-03_JPRB,&
&2.9345E-03_JPRB,1.1785E-02_JPRB,1.5496E-03_JPRB/)
KAO( :, 2, 5, 7) = (/&
&1.1618E-02_JPRB,1.1886E-02_JPRB,1.1906E-02_JPRB,1.1601E-02_JPRB,1.1008E-02_JPRB,9.7482E-03_JPRB,&
&6.3716E-03_JPRB,1.1618E-02_JPRB,2.0513E-03_JPRB/)
KAO( :, 3, 5, 7) = (/&
&1.1447E-02_JPRB,1.2288E-02_JPRB,1.2620E-02_JPRB,1.2540E-02_JPRB,1.2196E-02_JPRB,1.1475E-02_JPRB,&
&9.8448E-03_JPRB,1.1447E-02_JPRB,2.6474E-03_JPRB/)
KAO( :, 4, 5, 7) = (/&
&1.1293E-02_JPRB,1.2719E-02_JPRB,1.3350E-02_JPRB,1.3509E-02_JPRB,1.3472E-02_JPRB,1.3207E-02_JPRB,&
&1.2517E-02_JPRB,1.1293E-02_JPRB,3.3414E-03_JPRB/)
KAO( :, 5, 5, 7) = (/&
&1.1183E-02_JPRB,1.3178E-02_JPRB,1.4123E-02_JPRB,1.4583E-02_JPRB,1.4883E-02_JPRB,1.5015E-02_JPRB,&
&1.4926E-02_JPRB,1.1183E-02_JPRB,4.1312E-03_JPRB/)
KAO( :, 1, 6, 7) = (/&
&1.0487E-02_JPRB,1.0124E-02_JPRB,9.7249E-03_JPRB,9.1457E-03_JPRB,8.1285E-03_JPRB,4.8996E-03_JPRB,&
&1.9678E-03_JPRB,1.0487E-02_JPRB,1.0937E-03_JPRB/)
KAO( :, 2, 6, 7) = (/&
&1.0349E-02_JPRB,1.0437E-02_JPRB,1.0332E-02_JPRB,9.9754E-03_JPRB,9.2866E-03_JPRB,7.9160E-03_JPRB,&
&4.3878E-03_JPRB,1.0349E-02_JPRB,1.4598E-03_JPRB/)
KAO( :, 3, 6, 7) = (/&
&1.0220E-02_JPRB,1.0784E-02_JPRB,1.0929E-02_JPRB,1.0753E-02_JPRB,1.0353E-02_JPRB,9.5432E-03_JPRB,&
&7.8232E-03_JPRB,1.0220E-02_JPRB,1.9008E-03_JPRB/)
KAO( :, 4, 6, 7) = (/&
&1.0135E-02_JPRB,1.1143E-02_JPRB,1.1530E-02_JPRB,1.1576E-02_JPRB,1.1439E-02_JPRB,1.1088E-02_JPRB,&
&1.0277E-02_JPRB,1.0135E-02_JPRB,2.4221E-03_JPRB/)
KAO( :, 5, 6, 7) = (/&
&1.0102E-02_JPRB,1.1554E-02_JPRB,1.2194E-02_JPRB,1.2480E-02_JPRB,1.2652E-02_JPRB,1.2678E-02_JPRB,&
&1.2494E-02_JPRB,1.0102E-02_JPRB,3.0257E-03_JPRB/)
KAO( :, 1, 7, 7) = (/&
&9.2309E-03_JPRB,8.8319E-03_JPRB,8.3968E-03_JPRB,7.7952E-03_JPRB,6.7475E-03_JPRB,3.2870E-03_JPRB,&
&1.9179E-03_JPRB,9.2309E-03_JPRB,8.9645E-04_JPRB/)
KAO( :, 2, 7, 7) = (/&
&9.1242E-03_JPRB,9.0932E-03_JPRB,8.9046E-03_JPRB,8.4994E-03_JPRB,7.7737E-03_JPRB,6.2095E-03_JPRB,&
&2.8211E-03_JPRB,9.1242E-03_JPRB,1.1346E-03_JPRB/)
KAO( :, 3, 7, 7) = (/&
&9.0499E-03_JPRB,9.3880E-03_JPRB,9.3912E-03_JPRB,9.1437E-03_JPRB,8.6640E-03_JPRB,7.8059E-03_JPRB,&
&5.8358E-03_JPRB,9.0499E-03_JPRB,1.4379E-03_JPRB/)
KAO( :, 4, 7, 7) = (/&
&9.0319E-03_JPRB,9.7281E-03_JPRB,9.8888E-03_JPRB,9.8240E-03_JPRB,9.6043E-03_JPRB,9.1535E-03_JPRB,&
&8.2625E-03_JPRB,9.0319E-03_JPRB,1.8162E-03_JPRB/)
KAO( :, 5, 7, 7) = (/&
&9.0677E-03_JPRB,1.0114E-02_JPRB,1.0453E-02_JPRB,1.0590E-02_JPRB,1.0614E-02_JPRB,1.0515E-02_JPRB,&
&1.0212E-02_JPRB,9.0678E-03_JPRB,2.2700E-03_JPRB/)
KAO( :, 1, 8, 7) = (/&
&8.0750E-03_JPRB,7.6623E-03_JPRB,7.2138E-03_JPRB,6.5975E-03_JPRB,5.4257E-03_JPRB,2.2723E-03_JPRB,&
&1.6249E-03_JPRB,8.0750E-03_JPRB,1.2831E-03_JPRB/)
KAO( :, 2, 8, 7) = (/&
&7.9997E-03_JPRB,7.8793E-03_JPRB,7.6227E-03_JPRB,7.1817E-03_JPRB,6.4216E-03_JPRB,4.5366E-03_JPRB,&
&1.9736E-03_JPRB,7.9997E-03_JPRB,1.4497E-03_JPRB/)
KAO( :, 3, 8, 7) = (/&
&7.9739E-03_JPRB,8.1496E-03_JPRB,8.0220E-03_JPRB,7.7220E-03_JPRB,7.1874E-03_JPRB,6.2455E-03_JPRB,&
&3.8530E-03_JPRB,7.9739E-03_JPRB,1.6552E-03_JPRB/)
KAO( :, 4, 8, 7) = (/&
&8.0128E-03_JPRB,8.4694E-03_JPRB,8.4614E-03_JPRB,8.2951E-03_JPRB,7.9668E-03_JPRB,7.4368E-03_JPRB,&
&6.3444E-03_JPRB,8.0128E-03_JPRB,1.8965E-03_JPRB/)
KAO( :, 5, 8, 7) = (/&
&8.1136E-03_JPRB,8.8341E-03_JPRB,8.9710E-03_JPRB,8.9459E-03_JPRB,8.8203E-03_JPRB,8.6006E-03_JPRB,&
&8.1402E-03_JPRB,8.1136E-03_JPRB,2.1909E-03_JPRB/)
KAO( :, 1, 9, 7) = (/&
&7.0296E-03_JPRB,6.6308E-03_JPRB,6.1804E-03_JPRB,5.5360E-03_JPRB,4.1437E-03_JPRB,1.5632E-03_JPRB,&
&1.4348E-03_JPRB,7.0296E-03_JPRB,5.0746E-03_JPRB/)
KAO( :, 2, 9, 7) = (/&
&6.9891E-03_JPRB,6.8154E-03_JPRB,6.5047E-03_JPRB,6.0126E-03_JPRB,5.1664E-03_JPRB,3.1309E-03_JPRB,&
&1.3440E-03_JPRB,6.9891E-03_JPRB,5.2575E-03_JPRB/)
KAO( :, 3, 9, 7) = (/&
&7.0047E-03_JPRB,7.0682E-03_JPRB,6.8401E-03_JPRB,6.4671E-03_JPRB,5.8881E-03_JPRB,4.8032E-03_JPRB,&
&2.4408E-03_JPRB,7.0047E-03_JPRB,5.4725E-03_JPRB/)
KAO( :, 4, 9, 7) = (/&
&7.0937E-03_JPRB,7.3642E-03_JPRB,7.2266E-03_JPRB,6.9602E-03_JPRB,6.5505E-03_JPRB,5.9472E-03_JPRB,&
&4.6225E-03_JPRB,7.0937E-03_JPRB,5.7075E-03_JPRB/)
KAO( :, 5, 9, 7) = (/&
&7.2359E-03_JPRB,7.7189E-03_JPRB,7.6898E-03_JPRB,7.5393E-03_JPRB,7.2796E-03_JPRB,6.9540E-03_JPRB,&
&6.3115E-03_JPRB,7.2359E-03_JPRB,5.9395E-03_JPRB/)
KAO( :, 1,10, 7) = (/&
&6.0824E-03_JPRB,5.7201E-03_JPRB,5.2950E-03_JPRB,4.6533E-03_JPRB,3.1243E-03_JPRB,1.0849E-03_JPRB,&
&1.3514E-03_JPRB,6.0824E-03_JPRB,3.2036E-02_JPRB/)
KAO( :, 2,10, 7) = (/&
&6.0816E-03_JPRB,5.8999E-03_JPRB,5.5711E-03_JPRB,5.0543E-03_JPRB,4.1674E-03_JPRB,2.1951E-03_JPRB,&
&1.1513E-03_JPRB,6.0816E-03_JPRB,3.2646E-02_JPRB/)
KAO( :, 3,10, 7) = (/&
&6.1454E-03_JPRB,6.1496E-03_JPRB,5.8546E-03_JPRB,5.4437E-03_JPRB,4.8180E-03_JPRB,3.6424E-03_JPRB,&
&1.7330E-03_JPRB,6.1454E-03_JPRB,3.3079E-02_JPRB/)
KAO( :, 4,10, 7) = (/&
&6.2758E-03_JPRB,6.4382E-03_JPRB,6.1991E-03_JPRB,5.8783E-03_JPRB,5.4350E-03_JPRB,4.7237E-03_JPRB,&
&3.2810E-03_JPRB,6.2757E-03_JPRB,3.3401E-02_JPRB/)
KAO( :, 5,10, 7) = (/&
&6.4344E-03_JPRB,6.7774E-03_JPRB,6.6295E-03_JPRB,6.3941E-03_JPRB,6.0678E-03_JPRB,5.6397E-03_JPRB,&
&4.8978E-03_JPRB,6.4344E-03_JPRB,3.3652E-02_JPRB/)
KAO( :, 1,11, 7) = (/&
&5.2811E-03_JPRB,5.0055E-03_JPRB,4.6335E-03_JPRB,4.0757E-03_JPRB,2.8727E-03_JPRB,1.0865E-03_JPRB,&
&1.0171E-03_JPRB,5.2811E-03_JPRB,7.6840E-02_JPRB/)
KAO( :, 2,11, 7) = (/&
&5.3409E-03_JPRB,5.2140E-03_JPRB,4.8806E-03_JPRB,4.4140E-03_JPRB,3.6622E-03_JPRB,2.0302E-03_JPRB,&
&9.1811E-04_JPRB,5.3409E-03_JPRB,7.7870E-02_JPRB/)
KAO( :, 3,11, 7) = (/&
&5.4674E-03_JPRB,5.4758E-03_JPRB,5.1638E-03_JPRB,4.7679E-03_JPRB,4.2203E-03_JPRB,3.2247E-03_JPRB,&
&1.5980E-03_JPRB,5.4674E-03_JPRB,7.8594E-02_JPRB/)
KAO( :, 4,11, 7) = (/&
&5.6175E-03_JPRB,5.7677E-03_JPRB,5.5092E-03_JPRB,5.1897E-03_JPRB,4.7728E-03_JPRB,4.1267E-03_JPRB,&
&2.9888E-03_JPRB,5.6175E-03_JPRB,7.8959E-02_JPRB/)
KAO( :, 5,11, 7) = (/&
&5.7848E-03_JPRB,6.0885E-03_JPRB,5.9189E-03_JPRB,5.6782E-03_JPRB,5.3431E-03_JPRB,4.9223E-03_JPRB,&
&4.2500E-03_JPRB,5.7848E-03_JPRB,7.9148E-02_JPRB/)
KAO( :, 1,12, 7) = (/&
&4.6406E-03_JPRB,4.4264E-03_JPRB,4.0750E-03_JPRB,3.5822E-03_JPRB,2.6510E-03_JPRB,1.0132E-03_JPRB,&
&9.2156E-04_JPRB,4.6406E-03_JPRB,1.1768E-01_JPRB/)
KAO( :, 2,12, 7) = (/&
&4.7513E-03_JPRB,4.6501E-03_JPRB,4.3133E-03_JPRB,3.8811E-03_JPRB,3.2507E-03_JPRB,1.8501E-03_JPRB,&
&7.3924E-04_JPRB,4.7513E-03_JPRB,1.1892E-01_JPRB/)
KAO( :, 3,12, 7) = (/&
&4.8892E-03_JPRB,4.8966E-03_JPRB,4.5920E-03_JPRB,4.2162E-03_JPRB,3.7357E-03_JPRB,2.9015E-03_JPRB,&
&1.4402E-03_JPRB,4.8892E-03_JPRB,1.1988E-01_JPRB/)
KAO( :, 4,12, 7) = (/&
&5.0434E-03_JPRB,5.1649E-03_JPRB,4.9117E-03_JPRB,4.6087E-03_JPRB,4.2340E-03_JPRB,3.6743E-03_JPRB,&
&2.6652E-03_JPRB,5.0434E-03_JPRB,1.2040E-01_JPRB/)
KAO( :, 5,12, 7) = (/&
&5.1943E-03_JPRB,5.4604E-03_JPRB,5.2859E-03_JPRB,5.0532E-03_JPRB,4.7466E-03_JPRB,4.3367E-03_JPRB,&
&3.6758E-03_JPRB,5.1943E-03_JPRB,1.2066E-01_JPRB/)
KAO( :, 1,13, 7) = (/&
&4.1040E-03_JPRB,3.9320E-03_JPRB,3.6016E-03_JPRB,3.1660E-03_JPRB,2.4198E-03_JPRB,9.6006E-04_JPRB,&
&7.4336E-04_JPRB,4.1040E-03_JPRB,1.4478E-01_JPRB/)
KAO( :, 2,13, 7) = (/&
&4.2232E-03_JPRB,4.1425E-03_JPRB,3.8331E-03_JPRB,3.4407E-03_JPRB,2.9046E-03_JPRB,1.6979E-03_JPRB,&
&6.7921E-04_JPRB,4.2232E-03_JPRB,1.4623E-01_JPRB/)
KAO( :, 3,13, 7) = (/&
&4.3611E-03_JPRB,4.3698E-03_JPRB,4.0899E-03_JPRB,3.7461E-03_JPRB,3.3273E-03_JPRB,2.6603E-03_JPRB,&
&1.2963E-03_JPRB,4.3611E-03_JPRB,1.4748E-01_JPRB/)
KAO( :, 4,13, 7) = (/&
&4.4992E-03_JPRB,4.6148E-03_JPRB,4.3841E-03_JPRB,4.0963E-03_JPRB,3.7570E-03_JPRB,3.2859E-03_JPRB,&
&2.3687E-03_JPRB,4.4992E-03_JPRB,1.4817E-01_JPRB/)
KAO( :, 5,13, 7) = (/&
&4.6327E-03_JPRB,4.8729E-03_JPRB,4.7086E-03_JPRB,4.4884E-03_JPRB,4.2102E-03_JPRB,3.8391E-03_JPRB,&
&3.2592E-03_JPRB,4.6327E-03_JPRB,1.4848E-01_JPRB/)
KAO( :, 1, 1, 8) = (/&
&3.2446E-02_JPRB,3.0961E-02_JPRB,2.9943E-02_JPRB,2.8814E-02_JPRB,2.6701E-02_JPRB,2.3826E-02_JPRB,&
&2.0786E-02_JPRB,3.2446E-02_JPRB,1.5676E-02_JPRB/)
KAO( :, 2, 1, 8) = (/&
&3.2527E-02_JPRB,3.1848E-02_JPRB,3.1994E-02_JPRB,3.1175E-02_JPRB,2.9719E-02_JPRB,2.8532E-02_JPRB,&
&2.8157E-02_JPRB,3.2527E-02_JPRB,2.0060E-02_JPRB/)
KAO( :, 3, 1, 8) = (/&
&3.2555E-02_JPRB,3.3035E-02_JPRB,3.4009E-02_JPRB,3.3632E-02_JPRB,3.3098E-02_JPRB,3.4035E-02_JPRB,&
&3.6093E-02_JPRB,3.2555E-02_JPRB,2.5319E-02_JPRB/)
KAO( :, 4, 1, 8) = (/&
&3.2520E-02_JPRB,3.4424E-02_JPRB,3.5893E-02_JPRB,3.6221E-02_JPRB,3.7173E-02_JPRB,4.0037E-02_JPRB,&
&4.3790E-02_JPRB,3.2520E-02_JPRB,3.1444E-02_JPRB/)
KAO( :, 5, 1, 8) = (/&
&3.2436E-02_JPRB,3.5761E-02_JPRB,3.7828E-02_JPRB,3.9167E-02_JPRB,4.2081E-02_JPRB,4.6777E-02_JPRB,&
&5.1699E-02_JPRB,3.2436E-02_JPRB,3.8339E-02_JPRB/)
KAO( :, 1, 2, 8) = (/&
&3.3259E-02_JPRB,3.1637E-02_JPRB,3.0502E-02_JPRB,2.9322E-02_JPRB,2.7192E-02_JPRB,2.4045E-02_JPRB,&
&1.9418E-02_JPRB,3.3259E-02_JPRB,1.2401E-02_JPRB/)
KAO( :, 2, 2, 8) = (/&
&3.3309E-02_JPRB,3.2542E-02_JPRB,3.2579E-02_JPRB,3.1869E-02_JPRB,3.0109E-02_JPRB,2.7900E-02_JPRB,&
&2.5530E-02_JPRB,3.3309E-02_JPRB,1.5971E-02_JPRB/)
KAO( :, 3, 2, 8) = (/&
&3.3352E-02_JPRB,3.3755E-02_JPRB,3.4718E-02_JPRB,3.4392E-02_JPRB,3.3246E-02_JPRB,3.2250E-02_JPRB,&
&3.2349E-02_JPRB,3.3352E-02_JPRB,2.0278E-02_JPRB/)
KAO( :, 4, 2, 8) = (/&
&3.3330E-02_JPRB,3.5174E-02_JPRB,3.6737E-02_JPRB,3.6916E-02_JPRB,3.6641E-02_JPRB,3.7274E-02_JPRB,&
&3.9441E-02_JPRB,3.3330E-02_JPRB,2.5234E-02_JPRB/)
KAO( :, 5, 2, 8) = (/&
&3.3226E-02_JPRB,3.6569E-02_JPRB,3.8777E-02_JPRB,3.9713E-02_JPRB,4.0596E-02_JPRB,4.2979E-02_JPRB,&
&4.7032E-02_JPRB,3.3226E-02_JPRB,3.0759E-02_JPRB/)
KAO( :, 1, 3, 8) = (/&
&3.3391E-02_JPRB,3.1594E-02_JPRB,3.0176E-02_JPRB,2.8739E-02_JPRB,2.6633E-02_JPRB,2.3336E-02_JPRB,&
&1.8177E-02_JPRB,3.3391E-02_JPRB,9.1438E-03_JPRB/)
KAO( :, 2, 3, 8) = (/&
&3.3463E-02_JPRB,3.2445E-02_JPRB,3.2154E-02_JPRB,3.1362E-02_JPRB,2.9626E-02_JPRB,2.6963E-02_JPRB,&
&2.3198E-02_JPRB,3.3463E-02_JPRB,1.1964E-02_JPRB/)
KAO( :, 3, 3, 8) = (/&
&3.3507E-02_JPRB,3.3666E-02_JPRB,3.4348E-02_JPRB,3.4020E-02_JPRB,3.2664E-02_JPRB,3.0729E-02_JPRB,&
&2.8675E-02_JPRB,3.3507E-02_JPRB,1.5312E-02_JPRB/)
KAO( :, 4, 3, 8) = (/&
&3.3484E-02_JPRB,3.5076E-02_JPRB,3.6460E-02_JPRB,3.6685E-02_JPRB,3.5851E-02_JPRB,3.4760E-02_JPRB,&
&3.4446E-02_JPRB,3.3484E-02_JPRB,1.9144E-02_JPRB/)
KAO( :, 5, 3, 8) = (/&
&3.3365E-02_JPRB,3.6491E-02_JPRB,3.8546E-02_JPRB,3.9400E-02_JPRB,3.9309E-02_JPRB,3.9340E-02_JPRB,&
&4.1039E-02_JPRB,3.3365E-02_JPRB,2.3426E-02_JPRB/)
KAO( :, 1, 4, 8) = (/&
&3.2823E-02_JPRB,3.0856E-02_JPRB,2.9216E-02_JPRB,2.7536E-02_JPRB,2.5263E-02_JPRB,2.2005E-02_JPRB,&
&1.7126E-02_JPRB,3.2823E-02_JPRB,6.4847E-03_JPRB/)
KAO( :, 2, 4, 8) = (/&
&3.2916E-02_JPRB,3.1703E-02_JPRB,3.1081E-02_JPRB,3.0059E-02_JPRB,2.8252E-02_JPRB,2.5566E-02_JPRB,&
&2.1643E-02_JPRB,3.2916E-02_JPRB,8.6411E-03_JPRB/)
KAO( :, 3, 4, 8) = (/&
&3.2942E-02_JPRB,3.2855E-02_JPRB,3.3172E-02_JPRB,3.2679E-02_JPRB,3.1442E-02_JPRB,2.9283E-02_JPRB,&
&2.6180E-02_JPRB,3.2942E-02_JPRB,1.1256E-02_JPRB/)
KAO( :, 4, 4, 8) = (/&
&3.2895E-02_JPRB,3.4207E-02_JPRB,3.5261E-02_JPRB,3.5386E-02_JPRB,3.4683E-02_JPRB,3.2992E-02_JPRB,&
&3.0830E-02_JPRB,3.2895E-02_JPRB,1.4266E-02_JPRB/)
KAO( :, 5, 4, 8) = (/&
&3.2791E-02_JPRB,3.5598E-02_JPRB,3.7342E-02_JPRB,3.8144E-02_JPRB,3.7958E-02_JPRB,3.6915E-02_JPRB,&
&3.6060E-02_JPRB,3.2791E-02_JPRB,1.7623E-02_JPRB/)
KAO( :, 1, 5, 8) = (/&
&3.1527E-02_JPRB,2.9441E-02_JPRB,2.7666E-02_JPRB,2.5800E-02_JPRB,2.3517E-02_JPRB,2.0290E-02_JPRB,&
&1.5284E-02_JPRB,3.1527E-02_JPRB,4.5483E-03_JPRB/)
KAO( :, 2, 5, 8) = (/&
&3.1627E-02_JPRB,3.0253E-02_JPRB,2.9410E-02_JPRB,2.8191E-02_JPRB,2.6385E-02_JPRB,2.3754E-02_JPRB,&
&1.9782E-02_JPRB,3.1627E-02_JPRB,6.1662E-03_JPRB/)
KAO( :, 3, 5, 8) = (/&
&3.1653E-02_JPRB,3.1374E-02_JPRB,3.1394E-02_JPRB,3.0704E-02_JPRB,2.9499E-02_JPRB,2.7410E-02_JPRB,&
&2.4207E-02_JPRB,3.1653E-02_JPRB,8.1447E-03_JPRB/)
KAO( :, 4, 5, 8) = (/&
&3.1587E-02_JPRB,3.2681E-02_JPRB,3.3373E-02_JPRB,3.3364E-02_JPRB,3.2711E-02_JPRB,3.1061E-02_JPRB,&
&2.8366E-02_JPRB,3.1587E-02_JPRB,1.0460E-02_JPRB/)
KAO( :, 5, 5, 8) = (/&
&3.1459E-02_JPRB,3.4035E-02_JPRB,3.5391E-02_JPRB,3.6063E-02_JPRB,3.5941E-02_JPRB,3.4747E-02_JPRB,&
&3.2643E-02_JPRB,3.1459E-02_JPRB,1.3095E-02_JPRB/)
KAO( :, 1, 6, 8) = (/&
&2.9690E-02_JPRB,2.7513E-02_JPRB,2.5633E-02_JPRB,2.3605E-02_JPRB,2.1298E-02_JPRB,1.8147E-02_JPRB,&
&1.3146E-02_JPRB,2.9690E-02_JPRB,3.1369E-03_JPRB/)
KAO( :, 2, 6, 8) = (/&
&2.9770E-02_JPRB,2.8288E-02_JPRB,2.7183E-02_JPRB,2.5789E-02_JPRB,2.4036E-02_JPRB,2.1561E-02_JPRB,&
&1.7543E-02_JPRB,2.9770E-02_JPRB,4.3187E-03_JPRB/)
KAO( :, 3, 6, 8) = (/&
&2.9783E-02_JPRB,2.9294E-02_JPRB,2.9045E-02_JPRB,2.8192E-02_JPRB,2.6960E-02_JPRB,2.5034E-02_JPRB,&
&2.1858E-02_JPRB,2.9783E-02_JPRB,5.7867E-03_JPRB/)
KAO( :, 4, 6, 8) = (/&
&2.9692E-02_JPRB,3.0523E-02_JPRB,3.0946E-02_JPRB,3.0715E-02_JPRB,3.0007E-02_JPRB,2.8497E-02_JPRB,&
&2.5800E-02_JPRB,2.9692E-02_JPRB,7.5502E-03_JPRB/)
KAO( :, 5, 6, 8) = (/&
&2.9534E-02_JPRB,3.1783E-02_JPRB,3.2869E-02_JPRB,3.3262E-02_JPRB,3.3064E-02_JPRB,3.1999E-02_JPRB,&
&2.9755E-02_JPRB,2.9534E-02_JPRB,9.5800E-03_JPRB/)
KAO( :, 1, 7, 8) = (/&
&2.7399E-02_JPRB,2.5219E-02_JPRB,2.3318E-02_JPRB,2.1250E-02_JPRB,1.8905E-02_JPRB,1.5866E-02_JPRB,&
&1.0211E-02_JPRB,2.7399E-02_JPRB,2.2133E-03_JPRB/)
KAO( :, 2, 7, 8) = (/&
&2.7465E-02_JPRB,2.5918E-02_JPRB,2.4664E-02_JPRB,2.3195E-02_JPRB,2.1415E-02_JPRB,1.9044E-02_JPRB,&
&1.5287E-02_JPRB,2.7465E-02_JPRB,3.0581E-03_JPRB/)
KAO( :, 3, 7, 8) = (/&
&2.7467E-02_JPRB,2.6847E-02_JPRB,2.6363E-02_JPRB,2.5381E-02_JPRB,2.4103E-02_JPRB,2.2261E-02_JPRB,&
&1.9298E-02_JPRB,2.7467E-02_JPRB,4.1379E-03_JPRB/)
KAO( :, 4, 7, 8) = (/&
&2.7377E-02_JPRB,2.7967E-02_JPRB,2.8113E-02_JPRB,2.7721E-02_JPRB,2.6897E-02_JPRB,2.5513E-02_JPRB,&
&2.3011E-02_JPRB,2.7377E-02_JPRB,5.4434E-03_JPRB/)
KAO( :, 5, 7, 8) = (/&
&2.7205E-02_JPRB,2.9095E-02_JPRB,2.9889E-02_JPRB,3.0064E-02_JPRB,2.9735E-02_JPRB,2.8823E-02_JPRB,&
&2.6785E-02_JPRB,2.7205E-02_JPRB,6.9886E-03_JPRB/)
KAO( :, 1, 8, 8) = (/&
&2.4838E-02_JPRB,2.2730E-02_JPRB,2.0879E-02_JPRB,1.8847E-02_JPRB,1.6562E-02_JPRB,1.3598E-02_JPRB,&
&7.9263E-03_JPRB,2.4838E-02_JPRB,2.3197E-03_JPRB/)
KAO( :, 2, 8, 8) = (/&
&2.4890E-02_JPRB,2.3360E-02_JPRB,2.2033E-02_JPRB,2.0523E-02_JPRB,1.8797E-02_JPRB,1.6567E-02_JPRB,&
&1.2790E-02_JPRB,2.4890E-02_JPRB,2.7806E-03_JPRB/)
KAO( :, 3, 8, 8) = (/&
&2.4862E-02_JPRB,2.4160E-02_JPRB,2.3528E-02_JPRB,2.2491E-02_JPRB,2.1199E-02_JPRB,1.9477E-02_JPRB,&
&1.6802E-02_JPRB,2.4862E-02_JPRB,3.4079E-03_JPRB/)
KAO( :, 4, 8, 8) = (/&
&2.4775E-02_JPRB,2.5154E-02_JPRB,2.5100E-02_JPRB,2.4578E-02_JPRB,2.3711E-02_JPRB,2.2381E-02_JPRB,&
&2.0219E-02_JPRB,2.4775E-02_JPRB,4.2580E-03_JPRB/)
KAO( :, 5, 8, 8) = (/&
&2.4622E-02_JPRB,2.6148E-02_JPRB,2.6699E-02_JPRB,2.6671E-02_JPRB,2.6294E-02_JPRB,2.5372E-02_JPRB,&
&2.3589E-02_JPRB,2.4622E-02_JPRB,5.3361E-03_JPRB/)
KAO( :, 1, 9, 8) = (/&
&2.2221E-02_JPRB,2.0209E-02_JPRB,1.8418E-02_JPRB,1.6497E-02_JPRB,1.4362E-02_JPRB,1.1452E-02_JPRB,&
&5.8464E-03_JPRB,2.2221E-02_JPRB,8.1045E-03_JPRB/)
KAO( :, 2, 9, 8) = (/&
&2.2228E-02_JPRB,2.0738E-02_JPRB,1.9399E-02_JPRB,1.7929E-02_JPRB,1.6274E-02_JPRB,1.4180E-02_JPRB,&
&1.0256E-02_JPRB,2.2228E-02_JPRB,8.4976E-03_JPRB/)
KAO( :, 3, 9, 8) = (/&
&2.2181E-02_JPRB,2.1419E-02_JPRB,2.0685E-02_JPRB,1.9636E-02_JPRB,1.8370E-02_JPRB,1.6740E-02_JPRB,&
&1.4221E-02_JPRB,2.2181E-02_JPRB,8.9064E-03_JPRB/)
KAO( :, 4, 9, 8) = (/&
&2.2077E-02_JPRB,2.2259E-02_JPRB,2.2053E-02_JPRB,2.1452E-02_JPRB,2.0561E-02_JPRB,1.9271E-02_JPRB,&
&1.7337E-02_JPRB,2.2077E-02_JPRB,9.3666E-03_JPRB/)
KAO( :, 5, 9, 8) = (/&
&2.1959E-02_JPRB,2.3140E-02_JPRB,2.3450E-02_JPRB,2.3281E-02_JPRB,2.2789E-02_JPRB,2.1856E-02_JPRB,&
&2.0328E-02_JPRB,2.1959E-02_JPRB,9.8960E-03_JPRB/)
KAO( :, 1,10, 8) = (/&
&1.9665E-02_JPRB,1.7813E-02_JPRB,1.6135E-02_JPRB,1.4379E-02_JPRB,1.2423E-02_JPRB,9.6194E-03_JPRB,&
&4.3665E-03_JPRB,1.9665E-02_JPRB,5.0859E-02_JPRB/)
KAO( :, 2,10, 8) = (/&
&1.9655E-02_JPRB,1.8254E-02_JPRB,1.6961E-02_JPRB,1.5587E-02_JPRB,1.4053E-02_JPRB,1.2088E-02_JPRB,&
&8.1382E-03_JPRB,1.9655E-02_JPRB,5.1465E-02_JPRB/)
KAO( :, 3,10, 8) = (/&
&1.9577E-02_JPRB,1.8805E-02_JPRB,1.8054E-02_JPRB,1.7058E-02_JPRB,1.5850E-02_JPRB,1.4336E-02_JPRB,&
&1.1950E-02_JPRB,1.9577E-02_JPRB,5.1955E-02_JPRB/)
KAO( :, 4,10, 8) = (/&
&1.9473E-02_JPRB,1.9523E-02_JPRB,1.9227E-02_JPRB,1.8591E-02_JPRB,1.7700E-02_JPRB,1.6478E-02_JPRB,&
&1.4693E-02_JPRB,1.9473E-02_JPRB,5.2354E-02_JPRB/)
KAO( :, 5,10, 8) = (/&
&1.9405E-02_JPRB,2.0288E-02_JPRB,2.0423E-02_JPRB,2.0132E-02_JPRB,1.9564E-02_JPRB,1.8691E-02_JPRB,&
&1.7347E-02_JPRB,1.9405E-02_JPRB,5.2682E-02_JPRB/)
KAO( :, 1,11, 8) = (/&
&1.7199E-02_JPRB,1.5692E-02_JPRB,1.4307E-02_JPRB,1.2861E-02_JPRB,1.1262E-02_JPRB,9.0316E-03_JPRB,&
&4.4212E-03_JPRB,1.7199E-02_JPRB,1.2641E-01_JPRB/)
KAO( :, 2,11, 8) = (/&
&1.7139E-02_JPRB,1.6089E-02_JPRB,1.5094E-02_JPRB,1.3995E-02_JPRB,1.2699E-02_JPRB,1.1063E-02_JPRB,&
&8.1294E-03_JPRB,1.7139E-02_JPRB,1.2630E-01_JPRB/)
KAO( :, 3,11, 8) = (/&
&1.7062E-02_JPRB,1.6616E-02_JPRB,1.6068E-02_JPRB,1.5250E-02_JPRB,1.4213E-02_JPRB,1.2927E-02_JPRB,&
&1.0968E-02_JPRB,1.7062E-02_JPRB,1.2657E-01_JPRB/)
KAO( :, 4,11, 8) = (/&
&1.7027E-02_JPRB,1.7284E-02_JPRB,1.7074E-02_JPRB,1.6503E-02_JPRB,1.5727E-02_JPRB,1.4747E-02_JPRB,&
&1.3302E-02_JPRB,1.7027E-02_JPRB,1.2680E-01_JPRB/)
KAO( :, 5,11, 8) = (/&
&1.7051E-02_JPRB,1.8003E-02_JPRB,1.8097E-02_JPRB,1.7795E-02_JPRB,1.7338E-02_JPRB,1.6670E-02_JPRB,&
&1.5656E-02_JPRB,1.7051E-02_JPRB,1.2668E-01_JPRB/)
KAO( :, 1,12, 8) = (/&
&1.4892E-02_JPRB,1.3707E-02_JPRB,1.2589E-02_JPRB,1.1424E-02_JPRB,1.0096E-02_JPRB,8.2815E-03_JPRB,&
&4.4233E-03_JPRB,1.4892E-02_JPRB,2.0178E-01_JPRB/)
KAO( :, 2,12, 8) = (/&
&1.4830E-02_JPRB,1.4076E-02_JPRB,1.3327E-02_JPRB,1.2415E-02_JPRB,1.1306E-02_JPRB,9.9128E-03_JPRB,&
&7.6510E-03_JPRB,1.4830E-02_JPRB,2.0127E-01_JPRB/)
KAO( :, 3,12, 8) = (/&
&1.4815E-02_JPRB,1.4616E-02_JPRB,1.4166E-02_JPRB,1.3436E-02_JPRB,1.2531E-02_JPRB,1.1419E-02_JPRB,&
&9.8144E-03_JPRB,1.4815E-02_JPRB,2.0109E-01_JPRB/)
KAO( :, 4,12, 8) = (/&
&1.4874E-02_JPRB,1.5249E-02_JPRB,1.5019E-02_JPRB,1.4484E-02_JPRB,1.3802E-02_JPRB,1.2969E-02_JPRB,&
&1.1802E-02_JPRB,1.4874E-02_JPRB,2.0108E-01_JPRB/)
KAO( :, 5,12, 8) = (/&
&1.5028E-02_JPRB,1.5947E-02_JPRB,1.5923E-02_JPRB,1.5630E-02_JPRB,1.5205E-02_JPRB,1.4665E-02_JPRB,&
&1.3888E-02_JPRB,1.5028E-02_JPRB,2.0061E-01_JPRB/)
KAO( :, 1,13, 8) = (/&
&1.2856E-02_JPRB,1.1926E-02_JPRB,1.1034E-02_JPRB,1.0051E-02_JPRB,8.9048E-03_JPRB,7.3808E-03_JPRB,&
&4.3560E-03_JPRB,1.2856E-02_JPRB,2.5947E-01_JPRB/)
KAO( :, 2,13, 8) = (/&
&1.2849E-02_JPRB,1.2317E-02_JPRB,1.1692E-02_JPRB,1.0882E-02_JPRB,9.8884E-03_JPRB,8.6786E-03_JPRB,&
&6.8479E-03_JPRB,1.2849E-02_JPRB,2.5953E-01_JPRB/)
KAO( :, 3,13, 8) = (/&
&1.2913E-02_JPRB,1.2850E-02_JPRB,1.2417E-02_JPRB,1.1721E-02_JPRB,1.0882E-02_JPRB,9.9190E-03_JPRB,&
&8.6023E-03_JPRB,1.2913E-02_JPRB,2.5942E-01_JPRB/)
KAO( :, 4,13, 8) = (/&
&1.3088E-02_JPRB,1.3471E-02_JPRB,1.3169E-02_JPRB,1.2637E-02_JPRB,1.1989E-02_JPRB,1.1248E-02_JPRB,&
&1.0301E-02_JPRB,1.3088E-02_JPRB,2.5909E-01_JPRB/)
KAO( :, 5,13, 8) = (/&
&1.3373E-02_JPRB,1.4159E-02_JPRB,1.4029E-02_JPRB,1.3679E-02_JPRB,1.3241E-02_JPRB,1.2749E-02_JPRB,&
&1.2125E-02_JPRB,1.3373E-02_JPRB,2.5815E-01_JPRB/)
KAO( :, 1, 1, 9) = (/&
&6.4733E-02_JPRB,6.0521E-02_JPRB,5.8252E-02_JPRB,5.6866E-02_JPRB,5.6526E-02_JPRB,5.5742E-02_JPRB,&
&5.2046E-02_JPRB,6.4733E-02_JPRB,5.6233E-02_JPRB/)
KAO( :, 2, 1, 9) = (/&
&6.5477E-02_JPRB,6.3047E-02_JPRB,6.3106E-02_JPRB,6.4612E-02_JPRB,6.6790E-02_JPRB,6.7507E-02_JPRB,&
&6.4723E-02_JPRB,6.5477E-02_JPRB,7.2720E-02_JPRB/)
KAO( :, 3, 1, 9) = (/&
&6.6216E-02_JPRB,6.6108E-02_JPRB,6.9181E-02_JPRB,7.4268E-02_JPRB,7.9047E-02_JPRB,8.0497E-02_JPRB,&
&7.8280E-02_JPRB,6.6216E-02_JPRB,9.1648E-02_JPRB/)
KAO( :, 4, 1, 9) = (/&
&6.6791E-02_JPRB,6.9579E-02_JPRB,7.6737E-02_JPRB,8.5244E-02_JPRB,9.1845E-02_JPRB,9.4527E-02_JPRB,&
&9.2441E-02_JPRB,6.6791E-02_JPRB,1.1307E-01_JPRB/)
KAO( :, 5, 1, 9) = (/&
&6.7298E-02_JPRB,7.3839E-02_JPRB,8.5356E-02_JPRB,9.7147E-02_JPRB,1.0554E-01_JPRB,1.0978E-01_JPRB,&
&1.0752E-01_JPRB,6.7298E-02_JPRB,1.3678E-01_JPRB/)
KAO( :, 1, 2, 9) = (/&
&7.0877E-02_JPRB,6.5253E-02_JPRB,6.1232E-02_JPRB,5.7942E-02_JPRB,5.5662E-02_JPRB,5.3703E-02_JPRB,&
&5.0251E-02_JPRB,7.0877E-02_JPRB,4.8550E-02_JPRB/)
KAO( :, 2, 2, 9) = (/&
&7.1555E-02_JPRB,6.7492E-02_JPRB,6.5473E-02_JPRB,6.4551E-02_JPRB,6.5054E-02_JPRB,6.5264E-02_JPRB,&
&6.3231E-02_JPRB,7.1555E-02_JPRB,6.3334E-02_JPRB/)
KAO( :, 3, 2, 9) = (/&
&7.2159E-02_JPRB,7.0218E-02_JPRB,7.0742E-02_JPRB,7.3278E-02_JPRB,7.6459E-02_JPRB,7.8274E-02_JPRB,&
&7.6836E-02_JPRB,7.2159E-02_JPRB,8.0528E-02_JPRB/)
KAO( :, 4, 2, 9) = (/&
&7.2672E-02_JPRB,7.3326E-02_JPRB,7.7456E-02_JPRB,8.3314E-02_JPRB,8.9061E-02_JPRB,9.2382E-02_JPRB,&
&9.1438E-02_JPRB,7.2672E-02_JPRB,1.0017E-01_JPRB/)
KAO( :, 5, 2, 9) = (/&
&7.3068E-02_JPRB,7.7090E-02_JPRB,8.5132E-02_JPRB,9.4518E-02_JPRB,1.0309E-01_JPRB,1.0796E-01_JPRB,&
&1.0651E-01_JPRB,7.3067E-02_JPRB,1.2229E-01_JPRB/)
KAO( :, 1, 3, 9) = (/&
&7.7836E-02_JPRB,7.0551E-02_JPRB,6.4559E-02_JPRB,5.9167E-02_JPRB,5.4414E-02_JPRB,5.0314E-02_JPRB,&
&4.5794E-02_JPRB,7.7836E-02_JPRB,3.8882E-02_JPRB/)
KAO( :, 2, 3, 9) = (/&
&7.8435E-02_JPRB,7.2532E-02_JPRB,6.8092E-02_JPRB,6.4613E-02_JPRB,6.2358E-02_JPRB,6.0608E-02_JPRB,&
&5.8276E-02_JPRB,7.8435E-02_JPRB,5.1370E-02_JPRB/)
KAO( :, 3, 3, 9) = (/&
&7.8932E-02_JPRB,7.4825E-02_JPRB,7.2527E-02_JPRB,7.1989E-02_JPRB,7.2471E-02_JPRB,7.2873E-02_JPRB,&
&7.1766E-02_JPRB,7.8932E-02_JPRB,6.6086E-02_JPRB/)
KAO( :, 4, 3, 9) = (/&
&7.9379E-02_JPRB,7.7501E-02_JPRB,7.8388E-02_JPRB,8.0847E-02_JPRB,8.4097E-02_JPRB,8.6801E-02_JPRB,&
&8.6568E-02_JPRB,7.9379E-02_JPRB,8.3141E-02_JPRB/)
KAO( :, 5, 3, 9) = (/&
&7.9699E-02_JPRB,8.0691E-02_JPRB,8.5121E-02_JPRB,9.1008E-02_JPRB,9.7441E-02_JPRB,1.0226E-01_JPRB,&
&1.0163E-01_JPRB,7.9699E-02_JPRB,1.0254E-01_JPRB/)
KAO( :, 1, 4, 9) = (/&
&8.4906E-02_JPRB,7.6241E-02_JPRB,6.8684E-02_JPRB,6.1260E-02_JPRB,5.4322E-02_JPRB,4.8027E-02_JPRB,&
&4.1411E-02_JPRB,8.4906E-02_JPRB,3.0325E-02_JPRB/)
KAO( :, 2, 4, 9) = (/&
&8.5698E-02_JPRB,7.8243E-02_JPRB,7.1748E-02_JPRB,6.5778E-02_JPRB,6.0935E-02_JPRB,5.6719E-02_JPRB,&
&5.2610E-02_JPRB,8.5698E-02_JPRB,4.0549E-02_JPRB/)
KAO( :, 3, 4, 9) = (/&
&8.6275E-02_JPRB,8.0324E-02_JPRB,7.5429E-02_JPRB,7.2009E-02_JPRB,6.9531E-02_JPRB,6.7539E-02_JPRB,&
&6.5470E-02_JPRB,8.6275E-02_JPRB,5.2700E-02_JPRB/)
KAO( :, 4, 4, 9) = (/&
&8.6713E-02_JPRB,8.2575E-02_JPRB,8.0462E-02_JPRB,7.9748E-02_JPRB,7.9735E-02_JPRB,8.0326E-02_JPRB,&
&7.9974E-02_JPRB,8.6713E-02_JPRB,6.7029E-02_JPRB/)
KAO( :, 5, 4, 9) = (/&
&8.7027E-02_JPRB,8.5276E-02_JPRB,8.6509E-02_JPRB,8.8819E-02_JPRB,9.1761E-02_JPRB,9.4798E-02_JPRB,&
&9.4801E-02_JPRB,8.7027E-02_JPRB,8.3508E-02_JPRB/)
KAO( :, 1, 5, 9) = (/&
&9.1507E-02_JPRB,8.1620E-02_JPRB,7.2828E-02_JPRB,6.4142E-02_JPRB,5.5568E-02_JPRB,4.7251E-02_JPRB,&
&3.8880E-02_JPRB,9.1507E-02_JPRB,2.3229E-02_JPRB/)
KAO( :, 2, 5, 9) = (/&
&9.2405E-02_JPRB,8.3679E-02_JPRB,7.5863E-02_JPRB,6.8216E-02_JPRB,6.1046E-02_JPRB,5.4513E-02_JPRB,&
&4.8261E-02_JPRB,9.2405E-02_JPRB,3.1508E-02_JPRB/)
KAO( :, 3, 5, 9) = (/&
&9.3115E-02_JPRB,8.5700E-02_JPRB,7.9335E-02_JPRB,7.3579E-02_JPRB,6.8420E-02_JPRB,6.3872E-02_JPRB,&
&5.9567E-02_JPRB,9.3115E-02_JPRB,4.1511E-02_JPRB/)
KAO( :, 4, 5, 9) = (/&
&9.3636E-02_JPRB,8.7963E-02_JPRB,8.3776E-02_JPRB,8.0336E-02_JPRB,7.7284E-02_JPRB,7.5046E-02_JPRB,&
&7.2882E-02_JPRB,9.3636E-02_JPRB,5.3333E-02_JPRB/)
KAO( :, 5, 5, 9) = (/&
&9.4011E-02_JPRB,9.0504E-02_JPRB,8.9128E-02_JPRB,8.8247E-02_JPRB,8.7824E-02_JPRB,8.7979E-02_JPRB,&
&8.7078E-02_JPRB,9.4011E-02_JPRB,6.7155E-02_JPRB/)
KAO( :, 1, 6, 9) = (/&
&9.7472E-02_JPRB,8.6538E-02_JPRB,7.6624E-02_JPRB,6.6824E-02_JPRB,5.7059E-02_JPRB,4.7268E-02_JPRB,&
&3.7138E-02_JPRB,9.7472E-02_JPRB,1.7221E-02_JPRB/)
KAO( :, 2, 6, 9) = (/&
&9.8451E-02_JPRB,8.8518E-02_JPRB,7.9536E-02_JPRB,7.0737E-02_JPRB,6.1956E-02_JPRB,5.3328E-02_JPRB,&
&4.4923E-02_JPRB,9.8451E-02_JPRB,2.3780E-02_JPRB/)
KAO( :, 3, 6, 9) = (/&
&9.9270E-02_JPRB,9.0592E-02_JPRB,8.2992E-02_JPRB,7.5645E-02_JPRB,6.8338E-02_JPRB,6.1246E-02_JPRB,&
&5.4647E-02_JPRB,9.9270E-02_JPRB,3.1821E-02_JPRB/)
KAO( :, 4, 6, 9) = (/&
&9.9874E-02_JPRB,9.2825E-02_JPRB,8.7145E-02_JPRB,8.1713E-02_JPRB,7.6024E-02_JPRB,7.0895E-02_JPRB,&
&6.6256E-02_JPRB,9.9874E-02_JPRB,4.1514E-02_JPRB/)
KAO( :, 5, 6, 9) = (/&
&1.0031E-01_JPRB,9.5362E-02_JPRB,9.2196E-02_JPRB,8.8672E-02_JPRB,8.5237E-02_JPRB,8.2164E-02_JPRB,&
&7.9017E-02_JPRB,1.0031E-01_JPRB,5.2892E-02_JPRB/)
KAO( :, 1, 7, 9) = (/&
&1.0232E-01_JPRB,9.0553E-02_JPRB,7.9624E-02_JPRB,6.8906E-02_JPRB,5.8070E-02_JPRB,4.7256E-02_JPRB,&
&3.6147E-02_JPRB,1.0232E-01_JPRB,1.2551E-02_JPRB/)
KAO( :, 2, 7, 9) = (/&
&1.0337E-01_JPRB,9.2407E-02_JPRB,8.2434E-02_JPRB,7.2548E-02_JPRB,6.2643E-02_JPRB,5.2753E-02_JPRB,&
&4.2581E-02_JPRB,1.0337E-01_JPRB,1.7575E-02_JPRB/)
KAO( :, 3, 7, 9) = (/&
&1.0428E-01_JPRB,9.4463E-02_JPRB,8.5756E-02_JPRB,7.7103E-02_JPRB,6.8472E-02_JPRB,5.9711E-02_JPRB,&
&5.0861E-02_JPRB,1.0428E-01_JPRB,2.3865E-02_JPRB/)
KAO( :, 4, 7, 9) = (/&
&1.0499E-01_JPRB,9.6649E-02_JPRB,8.9715E-02_JPRB,8.2804E-02_JPRB,7.5682E-02_JPRB,6.8094E-02_JPRB,&
&6.0862E-02_JPRB,1.0499E-01_JPRB,3.1546E-02_JPRB/)
KAO( :, 5, 7, 9) = (/&
&1.0547E-01_JPRB,9.9180E-02_JPRB,9.4519E-02_JPRB,8.9479E-02_JPRB,8.3717E-02_JPRB,7.7813E-02_JPRB,&
&7.1993E-02_JPRB,1.0547E-01_JPRB,4.0721E-02_JPRB/)
KAO( :, 1, 8, 9) = (/&
&1.0518E-01_JPRB,9.2886E-02_JPRB,8.1191E-02_JPRB,6.9957E-02_JPRB,5.8508E-02_JPRB,4.6965E-02_JPRB,&
&3.4947E-02_JPRB,1.0518E-01_JPRB,9.1670E-03_JPRB/)
KAO( :, 2, 8, 9) = (/&
&1.0636E-01_JPRB,9.4674E-02_JPRB,8.4036E-02_JPRB,7.3413E-02_JPRB,6.2776E-02_JPRB,5.2007E-02_JPRB,&
&4.0951E-02_JPRB,1.0636E-01_JPRB,1.2998E-02_JPRB/)
KAO( :, 3, 8, 9) = (/&
&1.0733E-01_JPRB,9.6738E-02_JPRB,8.7252E-02_JPRB,7.7783E-02_JPRB,6.8203E-02_JPRB,5.8372E-02_JPRB,&
&4.8034E-02_JPRB,1.0733E-01_JPRB,1.7878E-02_JPRB/)
KAO( :, 4, 8, 9) = (/&
&1.0812E-01_JPRB,9.8911E-02_JPRB,9.1152E-02_JPRB,8.3173E-02_JPRB,7.4963E-02_JPRB,6.6116E-02_JPRB,&
&5.6655E-02_JPRB,1.0812E-01_JPRB,2.3868E-02_JPRB/)
KAO( :, 5, 8, 9) = (/&
&1.0863E-01_JPRB,1.0151E-01_JPRB,9.5717E-02_JPRB,8.9578E-02_JPRB,8.2572E-02_JPRB,7.4669E-02_JPRB,&
&6.6397E-02_JPRB,1.0863E-01_JPRB,3.1082E-02_JPRB/)
KAO( :, 1, 9, 9) = (/&
&1.0589E-01_JPRB,9.3378E-02_JPRB,8.1320E-02_JPRB,6.9699E-02_JPRB,5.7939E-02_JPRB,4.5963E-02_JPRB,&
&3.3510E-02_JPRB,1.0589E-01_JPRB,1.5005E-02_JPRB/)
KAO( :, 2, 9, 9) = (/&
&1.0710E-01_JPRB,9.5046E-02_JPRB,8.3992E-02_JPRB,7.2968E-02_JPRB,6.1840E-02_JPRB,5.0670E-02_JPRB,&
&3.9172E-02_JPRB,1.0710E-01_JPRB,1.6687E-02_JPRB/)
KAO( :, 3, 9, 9) = (/&
&1.0811E-01_JPRB,9.7025E-02_JPRB,8.7062E-02_JPRB,7.7135E-02_JPRB,6.7008E-02_JPRB,5.6693E-02_JPRB,&
&4.5539E-02_JPRB,1.0811E-01_JPRB,1.9062E-02_JPRB/)
KAO( :, 4, 9, 9) = (/&
&1.0893E-01_JPRB,9.9210E-02_JPRB,9.0893E-02_JPRB,8.2268E-02_JPRB,7.3432E-02_JPRB,6.3872E-02_JPRB,&
&5.3354E-02_JPRB,1.0893E-01_JPRB,2.2517E-02_JPRB/)
KAO( :, 5, 9, 9) = (/&
&1.0951E-01_JPRB,1.0180E-01_JPRB,9.5328E-02_JPRB,8.8533E-02_JPRB,8.0777E-02_JPRB,7.1933E-02_JPRB,&
&6.1860E-02_JPRB,1.0951E-01_JPRB,2.7194E-02_JPRB/)
KAO( :, 1,10, 9) = (/&
&1.0463E-01_JPRB,9.2191E-02_JPRB,8.0132E-02_JPRB,6.8413E-02_JPRB,5.6641E-02_JPRB,4.4619E-02_JPRB,&
&3.2080E-02_JPRB,1.0463E-01_JPRB,8.3991E-02_JPRB/)
KAO( :, 2,10, 9) = (/&
&1.0582E-01_JPRB,9.3770E-02_JPRB,8.2627E-02_JPRB,7.1539E-02_JPRB,6.0265E-02_JPRB,4.8989E-02_JPRB,&
&3.7366E-02_JPRB,1.0582E-01_JPRB,8.5008E-02_JPRB/)
KAO( :, 3,10, 9) = (/&
&1.0683E-01_JPRB,9.5651E-02_JPRB,8.5587E-02_JPRB,7.5429E-02_JPRB,6.5154E-02_JPRB,5.4715E-02_JPRB,&
&4.3408E-02_JPRB,1.0683E-01_JPRB,8.6636E-02_JPRB/)
KAO( :, 4,10, 9) = (/&
&1.0759E-01_JPRB,9.7764E-02_JPRB,8.9220E-02_JPRB,8.0336E-02_JPRB,7.1349E-02_JPRB,6.1576E-02_JPRB,&
&5.0720E-02_JPRB,1.0759E-01_JPRB,8.8133E-02_JPRB/)
KAO( :, 5,10, 9) = (/&
&1.0814E-01_JPRB,1.0027E-01_JPRB,9.3476E-02_JPRB,8.6461E-02_JPRB,7.8470E-02_JPRB,6.9232E-02_JPRB,&
&5.8604E-02_JPRB,1.0814E-01_JPRB,8.9595E-02_JPRB/)
KAO( :, 1,11, 9) = (/&
&1.0192E-01_JPRB,8.9934E-02_JPRB,7.8442E-02_JPRB,6.7206E-02_JPRB,5.5807E-02_JPRB,4.4274E-02_JPRB,&
&3.2485E-02_JPRB,1.0192E-01_JPRB,2.1346E-01_JPRB/)
KAO( :, 2,11, 9) = (/&
&1.0294E-01_JPRB,9.1474E-02_JPRB,8.1001E-02_JPRB,7.0324E-02_JPRB,5.9618E-02_JPRB,4.8890E-02_JPRB,&
&3.7724E-02_JPRB,1.0294E-01_JPRB,2.1319E-01_JPRB/)
KAO( :, 3,11, 9) = (/&
&1.0376E-01_JPRB,9.3370E-02_JPRB,8.3962E-02_JPRB,7.4435E-02_JPRB,6.4795E-02_JPRB,5.4795E-02_JPRB,&
&4.3827E-02_JPRB,1.0376E-01_JPRB,2.1289E-01_JPRB/)
KAO( :, 4,11, 9) = (/&
&1.0437E-01_JPRB,9.5489E-02_JPRB,8.7682E-02_JPRB,7.9614E-02_JPRB,7.1102E-02_JPRB,6.1619E-02_JPRB,&
&5.1046E-02_JPRB,1.0437E-01_JPRB,2.1287E-01_JPRB/)
KAO( :, 5,11, 9) = (/&
&1.0475E-01_JPRB,9.8083E-02_JPRB,9.2124E-02_JPRB,8.5743E-02_JPRB,7.7946E-02_JPRB,6.9048E-02_JPRB,&
&5.8627E-02_JPRB,1.0475E-01_JPRB,2.1310E-01_JPRB/)
KAO( :, 1,12, 9) = (/&
&9.7261E-02_JPRB,8.5991E-02_JPRB,7.5324E-02_JPRB,6.4737E-02_JPRB,5.3989E-02_JPRB,4.3184E-02_JPRB,&
&3.2169E-02_JPRB,9.7261E-02_JPRB,3.5384E-01_JPRB/)
KAO( :, 2,12, 9) = (/&
&9.8101E-02_JPRB,8.7528E-02_JPRB,7.7838E-02_JPRB,6.7921E-02_JPRB,5.8031E-02_JPRB,4.8011E-02_JPRB,&
&3.7356E-02_JPRB,9.8101E-02_JPRB,3.5110E-01_JPRB/)
KAO( :, 3,12, 9) = (/&
&9.8721E-02_JPRB,8.9358E-02_JPRB,8.0844E-02_JPRB,7.2156E-02_JPRB,6.3303E-02_JPRB,5.3812E-02_JPRB,&
&4.3478E-02_JPRB,9.8721E-02_JPRB,3.4905E-01_JPRB/)
KAO( :, 4,12, 9) = (/&
&9.9073E-02_JPRB,9.1448E-02_JPRB,8.4556E-02_JPRB,7.7373E-02_JPRB,6.9369E-02_JPRB,6.0482E-02_JPRB,&
&5.0434E-02_JPRB,9.9073E-02_JPRB,3.4710E-01_JPRB/)
KAO( :, 5,12, 9) = (/&
&9.9229E-02_JPRB,9.3917E-02_JPRB,8.9028E-02_JPRB,8.3070E-02_JPRB,7.5795E-02_JPRB,6.7464E-02_JPRB,&
&5.7745E-02_JPRB,9.9229E-02_JPRB,3.4526E-01_JPRB/)
KAO( :, 1,13, 9) = (/&
&9.0938E-02_JPRB,8.0633E-02_JPRB,7.0954E-02_JPRB,6.1198E-02_JPRB,5.1349E-02_JPRB,4.1513E-02_JPRB,&
&3.1321E-02_JPRB,9.0938E-02_JPRB,4.7630E-01_JPRB/)
KAO( :, 2,13, 9) = (/&
&9.1524E-02_JPRB,8.2076E-02_JPRB,7.3333E-02_JPRB,6.4427E-02_JPRB,5.5526E-02_JPRB,4.6304E-02_JPRB,&
&3.6408E-02_JPRB,9.1524E-02_JPRB,4.7149E-01_JPRB/)
KAO( :, 3,13, 9) = (/&
&9.1870E-02_JPRB,8.3785E-02_JPRB,7.6354E-02_JPRB,6.8726E-02_JPRB,6.0650E-02_JPRB,5.1878E-02_JPRB,&
&4.2350E-02_JPRB,9.1870E-02_JPRB,4.6781E-01_JPRB/)
KAO( :, 4,13, 9) = (/&
&9.2057E-02_JPRB,8.5864E-02_JPRB,8.0053E-02_JPRB,7.3650E-02_JPRB,6.6361E-02_JPRB,5.8175E-02_JPRB,&
&4.8890E-02_JPRB,9.2057E-02_JPRB,4.6471E-01_JPRB/)
KAO( :, 5,13, 9) = (/&
&9.2051E-02_JPRB,8.8153E-02_JPRB,8.4238E-02_JPRB,7.8829E-02_JPRB,7.2224E-02_JPRB,6.4662E-02_JPRB,&
&5.5790E-02_JPRB,9.2051E-02_JPRB,4.6177E-01_JPRB/)
KAO( :, 1, 1,10) = (/&
&1.8970E-01_JPRB,1.6722E-01_JPRB,1.5940E-01_JPRB,1.4654E-01_JPRB,1.3412E-01_JPRB,1.1990E-01_JPRB,&
&1.0153E-01_JPRB,1.8970E-01_JPRB,1.2683E-01_JPRB/)
KAO( :, 2, 1,10) = (/&
&1.9310E-01_JPRB,1.7584E-01_JPRB,1.7032E-01_JPRB,1.6287E-01_JPRB,1.5198E-01_JPRB,1.3637E-01_JPRB,&
&1.1338E-01_JPRB,1.9310E-01_JPRB,1.6492E-01_JPRB/)
KAO( :, 3, 1,10) = (/&
&1.9644E-01_JPRB,1.8616E-01_JPRB,1.8463E-01_JPRB,1.7853E-01_JPRB,1.6686E-01_JPRB,1.5307E-01_JPRB,&
&1.3006E-01_JPRB,1.9644E-01_JPRB,2.0951E-01_JPRB/)
KAO( :, 4, 1,10) = (/&
&1.9909E-01_JPRB,1.9510E-01_JPRB,1.9794E-01_JPRB,1.9455E-01_JPRB,1.8814E-01_JPRB,1.6970E-01_JPRB,&
&1.4049E-01_JPRB,1.9909E-01_JPRB,2.6023E-01_JPRB/)
KAO( :, 5, 1,10) = (/&
&2.0141E-01_JPRB,2.0423E-01_JPRB,2.1198E-01_JPRB,2.1359E-01_JPRB,2.0320E-01_JPRB,1.7839E-01_JPRB,&
&1.6166E-01_JPRB,2.0141E-01_JPRB,3.1814E-01_JPRB/)
KAO( :, 1, 2,10) = (/&
&1.8513E-01_JPRB,1.6417E-01_JPRB,1.5570E-01_JPRB,1.4299E-01_JPRB,1.3028E-01_JPRB,1.1558E-01_JPRB,&
&9.7575E-02_JPRB,1.8513E-01_JPRB,1.2033E-01_JPRB/)
KAO( :, 2, 2,10) = (/&
&1.8950E-01_JPRB,1.7381E-01_JPRB,1.6710E-01_JPRB,1.5962E-01_JPRB,1.4697E-01_JPRB,1.3061E-01_JPRB,&
&1.0961E-01_JPRB,1.8950E-01_JPRB,1.5920E-01_JPRB/)
KAO( :, 3, 2,10) = (/&
&1.9362E-01_JPRB,1.8395E-01_JPRB,1.8195E-01_JPRB,1.7419E-01_JPRB,1.6167E-01_JPRB,1.4828E-01_JPRB,&
&1.2568E-01_JPRB,1.9362E-01_JPRB,2.0282E-01_JPRB/)
KAO( :, 4, 2,10) = (/&
&1.9721E-01_JPRB,1.9348E-01_JPRB,1.9530E-01_JPRB,1.9112E-01_JPRB,1.8284E-01_JPRB,1.6500E-01_JPRB,&
&1.3708E-01_JPRB,1.9721E-01_JPRB,2.5204E-01_JPRB/)
KAO( :, 5, 2,10) = (/&
&2.0023E-01_JPRB,2.0320E-01_JPRB,2.1020E-01_JPRB,2.0819E-01_JPRB,1.9741E-01_JPRB,1.7466E-01_JPRB,&
&1.5343E-01_JPRB,2.0023E-01_JPRB,3.0808E-01_JPRB/)
KAO( :, 1, 3,10) = (/&
&1.8001E-01_JPRB,1.5918E-01_JPRB,1.4957E-01_JPRB,1.3634E-01_JPRB,1.2400E-01_JPRB,1.1052E-01_JPRB,&
&9.3510E-02_JPRB,1.8001E-01_JPRB,1.0219E-01_JPRB/)
KAO( :, 2, 3,10) = (/&
&1.8528E-01_JPRB,1.6901E-01_JPRB,1.6096E-01_JPRB,1.5327E-01_JPRB,1.4061E-01_JPRB,1.2481E-01_JPRB,&
&1.0682E-01_JPRB,1.8528E-01_JPRB,1.3773E-01_JPRB/)
KAO( :, 3, 3,10) = (/&
&1.9023E-01_JPRB,1.7929E-01_JPRB,1.7582E-01_JPRB,1.6700E-01_JPRB,1.5430E-01_JPRB,1.4161E-01_JPRB,&
&1.2252E-01_JPRB,1.9023E-01_JPRB,1.7877E-01_JPRB/)
KAO( :, 4, 3,10) = (/&
&1.9469E-01_JPRB,1.8893E-01_JPRB,1.8906E-01_JPRB,1.8314E-01_JPRB,1.7449E-01_JPRB,1.5948E-01_JPRB,&
&1.3408E-01_JPRB,1.9469E-01_JPRB,2.2723E-01_JPRB/)
KAO( :, 5, 3,10) = (/&
&1.9821E-01_JPRB,1.9946E-01_JPRB,2.0415E-01_JPRB,1.9922E-01_JPRB,1.8972E-01_JPRB,1.7229E-01_JPRB,&
&1.5170E-01_JPRB,1.9821E-01_JPRB,2.8243E-01_JPRB/)
KAO( :, 1, 4,10) = (/&
&1.7916E-01_JPRB,1.5693E-01_JPRB,1.4317E-01_JPRB,1.2970E-01_JPRB,1.1820E-01_JPRB,1.0542E-01_JPRB,&
&8.8810E-02_JPRB,1.7916E-01_JPRB,8.1629E-02_JPRB/)
KAO( :, 2, 4,10) = (/&
&1.8393E-01_JPRB,1.6496E-01_JPRB,1.5408E-01_JPRB,1.4656E-01_JPRB,1.3470E-01_JPRB,1.1968E-01_JPRB,&
&1.0109E-01_JPRB,1.8393E-01_JPRB,1.1300E-01_JPRB/)
KAO( :, 3, 4,10) = (/&
&1.8829E-01_JPRB,1.7395E-01_JPRB,1.6912E-01_JPRB,1.6090E-01_JPRB,1.4836E-01_JPRB,1.3533E-01_JPRB,&
&1.1688E-01_JPRB,1.8829E-01_JPRB,1.5011E-01_JPRB/)
KAO( :, 4, 4,10) = (/&
&1.9238E-01_JPRB,1.8364E-01_JPRB,1.8242E-01_JPRB,1.7617E-01_JPRB,1.6761E-01_JPRB,1.5430E-01_JPRB,&
&1.3056E-01_JPRB,1.9230E-01_JPRB,1.9532E-01_JPRB/)
KAO( :, 5, 4,10) = (/&
&1.9574E-01_JPRB,1.9463E-01_JPRB,1.9705E-01_JPRB,1.9264E-01_JPRB,1.8511E-01_JPRB,1.7157E-01_JPRB,&
&1.5145E-01_JPRB,1.9574E-01_JPRB,2.4701E-01_JPRB/)
KAO( :, 1, 5,10) = (/&
&1.8797E-01_JPRB,1.6453E-01_JPRB,1.4533E-01_JPRB,1.2686E-01_JPRB,1.1219E-01_JPRB,9.8719E-02_JPRB,&
&8.1932E-02_JPRB,1.8797E-01_JPRB,6.5166E-02_JPRB/)
KAO( :, 2, 5,10) = (/&
&1.9160E-01_JPRB,1.6925E-01_JPRB,1.5218E-01_JPRB,1.4014E-01_JPRB,1.2917E-01_JPRB,1.1302E-01_JPRB,&
&9.4480E-02_JPRB,1.9160E-01_JPRB,9.2077E-02_JPRB/)
KAO( :, 3, 5,10) = (/&
&1.9446E-01_JPRB,1.7578E-01_JPRB,1.6402E-01_JPRB,1.5506E-01_JPRB,1.4235E-01_JPRB,1.2780E-01_JPRB,&
&1.1066E-01_JPRB,1.9446E-01_JPRB,1.2479E-01_JPRB/)
KAO( :, 4, 5,10) = (/&
&1.9736E-01_JPRB,1.8183E-01_JPRB,1.7664E-01_JPRB,1.6999E-01_JPRB,1.6179E-01_JPRB,1.4826E-01_JPRB,&
&1.2816E-01_JPRB,1.9736E-01_JPRB,1.6346E-01_JPRB/)
KAO( :, 5, 5,10) = (/&
&2.0011E-01_JPRB,1.9074E-01_JPRB,1.9082E-01_JPRB,1.8829E-01_JPRB,1.8080E-01_JPRB,1.6858E-01_JPRB,&
&1.5009E-01_JPRB,2.0011E-01_JPRB,2.0822E-01_JPRB/)
KAO( :, 1, 6,10) = (/&
&2.0223E-01_JPRB,1.7699E-01_JPRB,1.5322E-01_JPRB,1.3128E-01_JPRB,1.1092E-01_JPRB,9.1561E-02_JPRB,&
&7.3661E-02_JPRB,2.0223E-01_JPRB,5.1377E-02_JPRB/)
KAO( :, 2, 6,10) = (/&
&2.0512E-01_JPRB,1.7967E-01_JPRB,1.5788E-01_JPRB,1.3938E-01_JPRB,1.2268E-01_JPRB,1.0543E-01_JPRB,&
&8.7385E-02_JPRB,2.0512E-01_JPRB,7.3853E-02_JPRB/)
KAO( :, 3, 6,10) = (/&
&2.0790E-01_JPRB,1.8450E-01_JPRB,1.6529E-01_JPRB,1.5112E-01_JPRB,1.3529E-01_JPRB,1.2022E-01_JPRB,&
&1.0398E-01_JPRB,2.0790E-01_JPRB,1.0087E-01_JPRB/)
KAO( :, 4, 6,10) = (/&
&2.1004E-01_JPRB,1.8823E-01_JPRB,1.7509E-01_JPRB,1.6284E-01_JPRB,1.5386E-01_JPRB,1.4155E-01_JPRB,&
&1.2427E-01_JPRB,2.1004E-01_JPRB,1.3360E-01_JPRB/)
KAO( :, 5, 6,10) = (/&
&2.1183E-01_JPRB,1.9428E-01_JPRB,1.8513E-01_JPRB,1.8177E-01_JPRB,1.7498E-01_JPRB,1.6423E-01_JPRB,&
&1.4704E-01_JPRB,2.1183E-01_JPRB,1.7178E-01_JPRB/)
KAO( :, 1, 7,10) = (/&
&2.1966E-01_JPRB,1.9223E-01_JPRB,1.6487E-01_JPRB,1.4075E-01_JPRB,1.1743E-01_JPRB,9.2352E-02_JPRB,&
&6.7165E-02_JPRB,2.1966E-01_JPRB,3.9844E-02_JPRB/)
KAO( :, 2, 7,10) = (/&
&2.2289E-01_JPRB,1.9505E-01_JPRB,1.7012E-01_JPRB,1.4711E-01_JPRB,1.2482E-01_JPRB,1.0166E-01_JPRB,&
&8.1116E-02_JPRB,2.2289E-01_JPRB,5.8803E-02_JPRB/)
KAO( :, 3, 7,10) = (/&
&2.2562E-01_JPRB,1.9918E-01_JPRB,1.7558E-01_JPRB,1.5579E-01_JPRB,1.3361E-01_JPRB,1.1381E-01_JPRB,&
&9.8296E-02_JPRB,2.2562E-01_JPRB,8.2105E-02_JPRB/)
KAO( :, 4, 7,10) = (/&
&2.2798E-01_JPRB,2.0283E-01_JPRB,1.8393E-01_JPRB,1.6360E-01_JPRB,1.4672E-01_JPRB,1.3482E-01_JPRB,&
&1.1942E-01_JPRB,2.2798E-01_JPRB,1.1013E-01_JPRB/)
KAO( :, 5, 7,10) = (/&
&2.2965E-01_JPRB,2.0713E-01_JPRB,1.9045E-01_JPRB,1.7711E-01_JPRB,1.6890E-01_JPRB,1.5875E-01_JPRB,&
&1.4294E-01_JPRB,2.2965E-01_JPRB,1.4301E-01_JPRB/)
KAO( :, 1, 8,10) = (/&
&2.3927E-01_JPRB,2.0940E-01_JPRB,1.7953E-01_JPRB,1.5074E-01_JPRB,1.2505E-01_JPRB,9.7338E-02_JPRB,&
&6.8761E-02_JPRB,2.3927E-01_JPRB,3.1572E-02_JPRB/)
KAO( :, 2, 8,10) = (/&
&2.4243E-01_JPRB,2.1216E-01_JPRB,1.8359E-01_JPRB,1.5756E-01_JPRB,1.3069E-01_JPRB,1.0456E-01_JPRB,&
&7.7923E-02_JPRB,2.4243E-01_JPRB,4.5978E-02_JPRB/)
KAO( :, 3, 8,10) = (/&
&2.4547E-01_JPRB,2.1534E-01_JPRB,1.8853E-01_JPRB,1.6503E-01_JPRB,1.3896E-01_JPRB,1.1377E-01_JPRB,&
&9.3425E-02_JPRB,2.4547E-01_JPRB,6.4381E-02_JPRB/)
KAO( :, 4, 8,10) = (/&
&2.4802E-01_JPRB,2.1966E-01_JPRB,1.9648E-01_JPRB,1.7197E-01_JPRB,1.4872E-01_JPRB,1.2967E-01_JPRB,&
&1.1417E-01_JPRB,2.4802E-01_JPRB,8.7970E-02_JPRB/)
KAO( :, 5, 8,10) = (/&
&2.4998E-01_JPRB,2.2309E-01_JPRB,2.0261E-01_JPRB,1.8232E-01_JPRB,1.6517E-01_JPRB,1.5264E-01_JPRB,&
&1.3834E-01_JPRB,2.4998E-01_JPRB,1.1639E-01_JPRB/)
KAO( :, 1, 9,10) = (/&
&2.6148E-01_JPRB,2.2882E-01_JPRB,1.9618E-01_JPRB,1.6370E-01_JPRB,1.3448E-01_JPRB,1.0395E-01_JPRB,&
&7.1629E-02_JPRB,2.6148E-01_JPRB,2.8503E-02_JPRB/)
KAO( :, 2, 9,10) = (/&
&2.6519E-01_JPRB,2.3210E-01_JPRB,1.9937E-01_JPRB,1.7015E-01_JPRB,1.3964E-01_JPRB,1.0892E-01_JPRB,&
&7.8889E-02_JPRB,2.6519E-01_JPRB,3.8008E-02_JPRB/)
KAO( :, 3, 9,10) = (/&
&2.6824E-01_JPRB,2.3478E-01_JPRB,2.0449E-01_JPRB,1.7562E-01_JPRB,1.4652E-01_JPRB,1.1674E-01_JPRB,&
&9.2270E-02_JPRB,2.6824E-01_JPRB,5.2422E-02_JPRB/)
KAO( :, 4, 9,10) = (/&
&2.7078E-01_JPRB,2.3877E-01_JPRB,2.1054E-01_JPRB,1.8264E-01_JPRB,1.5412E-01_JPRB,1.3041E-01_JPRB,&
&1.0749E-01_JPRB,2.7078E-01_JPRB,7.0338E-02_JPRB/)
KAO( :, 5, 9,10) = (/&
&2.7264E-01_JPRB,2.4161E-01_JPRB,2.1662E-01_JPRB,1.8978E-01_JPRB,1.6860E-01_JPRB,1.4804E-01_JPRB,&
&1.3080E-01_JPRB,2.7264E-01_JPRB,9.2554E-02_JPRB/)
KAO( :, 1,10,10) = (/&
&2.8201E-01_JPRB,2.4678E-01_JPRB,2.1156E-01_JPRB,1.7638E-01_JPRB,1.4352E-01_JPRB,1.1084E-01_JPRB,&
&7.6972E-02_JPRB,2.8201E-01_JPRB,1.2471E-01_JPRB/)
KAO( :, 2,10,10) = (/&
&2.8576E-01_JPRB,2.5006E-01_JPRB,2.1438E-01_JPRB,1.8231E-01_JPRB,1.4961E-01_JPRB,1.1549E-01_JPRB,&
&8.2006E-02_JPRB,2.8576E-01_JPRB,1.2496E-01_JPRB/)
KAO( :, 3,10,10) = (/&
&2.8893E-01_JPRB,2.5286E-01_JPRB,2.1949E-01_JPRB,1.8787E-01_JPRB,1.5551E-01_JPRB,1.2228E-01_JPRB,&
&9.3406E-02_JPRB,2.8893E-01_JPRB,1.2857E-01_JPRB/)
KAO( :, 4,10,10) = (/&
&2.9143E-01_JPRB,2.5653E-01_JPRB,2.2518E-01_JPRB,1.9466E-01_JPRB,1.6197E-01_JPRB,1.3409E-01_JPRB,&
&1.0614E-01_JPRB,2.9143E-01_JPRB,1.3664E-01_JPRB/)
KAO( :, 5,10,10) = (/&
&2.9269E-01_JPRB,2.5878E-01_JPRB,2.3097E-01_JPRB,1.9967E-01_JPRB,1.7426E-01_JPRB,1.4933E-01_JPRB,&
&1.2477E-01_JPRB,2.9269E-01_JPRB,1.4648E-01_JPRB/)
KAO( :, 1,11,10) = (/&
&3.0003E-01_JPRB,2.6255E-01_JPRB,2.2506E-01_JPRB,1.8819E-01_JPRB,1.5371E-01_JPRB,1.1851E-01_JPRB,&
&8.1809E-02_JPRB,3.0003E-01_JPRB,3.1454E-01_JPRB/)
KAO( :, 2,11,10) = (/&
&3.0324E-01_JPRB,2.6535E-01_JPRB,2.2775E-01_JPRB,1.9448E-01_JPRB,1.5903E-01_JPRB,1.2292E-01_JPRB,&
&8.8865E-02_JPRB,3.0324E-01_JPRB,3.0861E-01_JPRB/)
KAO( :, 3,11,10) = (/&
&3.0493E-01_JPRB,2.6686E-01_JPRB,2.3266E-01_JPRB,1.9918E-01_JPRB,1.6490E-01_JPRB,1.3153E-01_JPRB,&
&1.0078E-01_JPRB,3.0493E-01_JPRB,3.0699E-01_JPRB/)
KAO( :, 4,11,10) = (/&
&3.0577E-01_JPRB,2.6940E-01_JPRB,2.3789E-01_JPRB,2.0495E-01_JPRB,1.7338E-01_JPRB,1.4467E-01_JPRB,&
&1.1314E-01_JPRB,3.0577E-01_JPRB,3.1082E-01_JPRB/)
KAO( :, 5,11,10) = (/&
&3.0551E-01_JPRB,2.7044E-01_JPRB,2.4227E-01_JPRB,2.1229E-01_JPRB,1.8801E-01_JPRB,1.5979E-01_JPRB,&
&1.3090E-01_JPRB,3.0551E-01_JPRB,3.1527E-01_JPRB/)
KAO( :, 1,12,10) = (/&
&3.1134E-01_JPRB,2.7243E-01_JPRB,2.3354E-01_JPRB,1.9639E-01_JPRB,1.6090E-01_JPRB,1.2387E-01_JPRB,&
&8.6052E-02_JPRB,3.1134E-01_JPRB,5.2978E-01_JPRB/)
KAO( :, 2,12,10) = (/&
&3.1359E-01_JPRB,2.7441E-01_JPRB,2.3677E-01_JPRB,2.0238E-01_JPRB,1.6552E-01_JPRB,1.2901E-01_JPRB,&
&9.5207E-02_JPRB,3.1359E-01_JPRB,5.2052E-01_JPRB/)
KAO( :, 3,12,10) = (/&
&3.1415E-01_JPRB,2.7537E-01_JPRB,2.4122E-01_JPRB,2.0715E-01_JPRB,1.7193E-01_JPRB,1.3997E-01_JPRB,&
&1.0720E-01_JPRB,3.1415E-01_JPRB,5.1560E-01_JPRB/)
KAO( :, 4,12,10) = (/&
&3.1372E-01_JPRB,2.7678E-01_JPRB,2.4609E-01_JPRB,2.1256E-01_JPRB,1.8335E-01_JPRB,1.5322E-01_JPRB,&
&1.2081E-01_JPRB,3.1372E-01_JPRB,5.1557E-01_JPRB/)
KAO( :, 5,12,10) = (/&
&3.1239E-01_JPRB,2.7822E-01_JPRB,2.4956E-01_JPRB,2.2367E-01_JPRB,1.9838E-01_JPRB,1.6937E-01_JPRB,&
&1.3606E-01_JPRB,3.1239E-01_JPRB,5.1667E-01_JPRB/)
KAO( :, 1,13,10) = (/&
&3.1638E-01_JPRB,2.7683E-01_JPRB,2.3750E-01_JPRB,2.0114E-01_JPRB,1.6456E-01_JPRB,1.2632E-01_JPRB,&
&8.9253E-02_JPRB,3.1638E-01_JPRB,7.3497E-01_JPRB/)
KAO( :, 2,13,10) = (/&
&3.1671E-01_JPRB,2.7713E-01_JPRB,2.4097E-01_JPRB,2.0542E-01_JPRB,1.6866E-01_JPRB,1.3347E-01_JPRB,&
&9.9658E-02_JPRB,3.1671E-01_JPRB,7.1891E-01_JPRB/)
KAO( :, 3,13,10) = (/&
&3.1659E-01_JPRB,2.7824E-01_JPRB,2.4448E-01_JPRB,2.1048E-01_JPRB,1.7715E-01_JPRB,1.4549E-01_JPRB,&
&1.1132E-01_JPRB,3.1659E-01_JPRB,7.1020E-01_JPRB/)
KAO( :, 4,13,10) = (/&
&3.1484E-01_JPRB,2.7845E-01_JPRB,2.4849E-01_JPRB,2.1796E-01_JPRB,1.8948E-01_JPRB,1.5955E-01_JPRB,&
&1.2635E-01_JPRB,3.1484E-01_JPRB,7.0756E-01_JPRB/)
KAO( :, 5,13,10) = (/&
&3.1186E-01_JPRB,2.8054E-01_JPRB,2.5362E-01_JPRB,2.3086E-01_JPRB,2.0496E-01_JPRB,1.7512E-01_JPRB,&
&1.4143E-01_JPRB,3.1186E-01_JPRB,7.0584E-01_JPRB/)
KAO( :, 1, 1,11) = (/&
&3.1327E-01_JPRB,2.7438E-01_JPRB,2.3864E-01_JPRB,2.1648E-01_JPRB,1.8690E-01_JPRB,1.5673E-01_JPRB,&
&1.2734E-01_JPRB,3.1327E-01_JPRB,1.4986E-01_JPRB/)
KAO( :, 2, 1,11) = (/&
&3.1392E-01_JPRB,2.7491E-01_JPRB,2.5200E-01_JPRB,2.2734E-01_JPRB,2.0303E-01_JPRB,1.7541E-01_JPRB,&
&1.4089E-01_JPRB,3.1392E-01_JPRB,1.9707E-01_JPRB/)
KAO( :, 3, 1,11) = (/&
&3.1383E-01_JPRB,2.7650E-01_JPRB,2.6109E-01_JPRB,2.4195E-01_JPRB,2.1927E-01_JPRB,1.8650E-01_JPRB,&
&1.4955E-01_JPRB,3.1383E-01_JPRB,2.5159E-01_JPRB/)
KAO( :, 4, 1,11) = (/&
&3.1272E-01_JPRB,2.8403E-01_JPRB,2.7223E-01_JPRB,2.5585E-01_JPRB,2.2854E-01_JPRB,2.0092E-01_JPRB,&
&1.8691E-01_JPRB,3.1272E-01_JPRB,3.1304E-01_JPRB/)
KAO( :, 5, 1,11) = (/&
&3.1090E-01_JPRB,2.8955E-01_JPRB,2.8191E-01_JPRB,2.6664E-01_JPRB,2.4121E-01_JPRB,2.1301E-01_JPRB,&
&2.4137E-01_JPRB,3.1090E-01_JPRB,3.8118E-01_JPRB/)
KAO( :, 1, 2,11) = (/&
&3.1324E-01_JPRB,2.7422E-01_JPRB,2.3920E-01_JPRB,2.1500E-01_JPRB,1.8495E-01_JPRB,1.5528E-01_JPRB,&
&1.2577E-01_JPRB,3.1324E-01_JPRB,1.5045E-01_JPRB/)
KAO( :, 2, 2,11) = (/&
&3.1470E-01_JPRB,2.7557E-01_JPRB,2.5223E-01_JPRB,2.2657E-01_JPRB,2.0210E-01_JPRB,1.7421E-01_JPRB,&
&1.3837E-01_JPRB,3.1470E-01_JPRB,1.9866E-01_JPRB/)
KAO( :, 3, 2,11) = (/&
&3.1536E-01_JPRB,2.7926E-01_JPRB,2.6141E-01_JPRB,2.4214E-01_JPRB,2.1888E-01_JPRB,1.8478E-01_JPRB,&
&1.5074E-01_JPRB,3.1536E-01_JPRB,2.5677E-01_JPRB/)
KAO( :, 4, 2,11) = (/&
&3.1504E-01_JPRB,2.8779E-01_JPRB,2.7376E-01_JPRB,2.5633E-01_JPRB,2.2942E-01_JPRB,1.9993E-01_JPRB,&
&1.7112E-01_JPRB,3.1504E-01_JPRB,3.2302E-01_JPRB/)
KAO( :, 5, 2,11) = (/&
&3.1381E-01_JPRB,2.9324E-01_JPRB,2.8519E-01_JPRB,2.6951E-01_JPRB,2.4055E-01_JPRB,2.0793E-01_JPRB,&
&2.1700E-01_JPRB,3.1381E-01_JPRB,3.9625E-01_JPRB/)
KAO( :, 1, 3,11) = (/&
&3.1204E-01_JPRB,2.7315E-01_JPRB,2.3704E-01_JPRB,2.1094E-01_JPRB,1.7966E-01_JPRB,1.4896E-01_JPRB,&
&1.2013E-01_JPRB,3.1204E-01_JPRB,1.3758E-01_JPRB/)
KAO( :, 2, 3,11) = (/&
&3.1466E-01_JPRB,2.7547E-01_JPRB,2.5029E-01_JPRB,2.2183E-01_JPRB,1.9651E-01_JPRB,1.6912E-01_JPRB,&
&1.3258E-01_JPRB,3.1466E-01_JPRB,1.8586E-01_JPRB/)
KAO( :, 3, 3,11) = (/&
&3.1617E-01_JPRB,2.7992E-01_JPRB,2.5948E-01_JPRB,2.3884E-01_JPRB,2.1445E-01_JPRB,1.8030E-01_JPRB,&
&1.4450E-01_JPRB,3.1617E-01_JPRB,2.4266E-01_JPRB/)
KAO( :, 4, 3,11) = (/&
&3.1681E-01_JPRB,2.8890E-01_JPRB,2.7221E-01_JPRB,2.5334E-01_JPRB,2.2580E-01_JPRB,1.9471E-01_JPRB,&
&1.5799E-01_JPRB,3.1681E-01_JPRB,3.0762E-01_JPRB/)
KAO( :, 5, 3,11) = (/&
&3.1660E-01_JPRB,2.9490E-01_JPRB,2.8472E-01_JPRB,2.6817E-01_JPRB,2.3814E-01_JPRB,2.0506E-01_JPRB,&
&1.8418E-01_JPRB,3.1660E-01_JPRB,3.8162E-01_JPRB/)
KAO( :, 1, 4,11) = (/&
&3.0866E-01_JPRB,2.7016E-01_JPRB,2.3341E-01_JPRB,2.0592E-01_JPRB,1.7365E-01_JPRB,1.4152E-01_JPRB,&
&1.1350E-01_JPRB,3.0866E-01_JPRB,1.1729E-01_JPRB/)
KAO( :, 2, 4,11) = (/&
&3.1261E-01_JPRB,2.7364E-01_JPRB,2.4679E-01_JPRB,2.1687E-01_JPRB,1.8912E-01_JPRB,1.6227E-01_JPRB,&
&1.2877E-01_JPRB,3.1261E-01_JPRB,1.6263E-01_JPRB/)
KAO( :, 3, 4,11) = (/&
&3.1517E-01_JPRB,2.7866E-01_JPRB,2.5633E-01_JPRB,2.3322E-01_JPRB,2.0818E-01_JPRB,1.7524E-01_JPRB,&
&1.4011E-01_JPRB,3.1517E-01_JPRB,2.1741E-01_JPRB/)
KAO( :, 4, 4,11) = (/&
&3.1718E-01_JPRB,2.8802E-01_JPRB,2.6947E-01_JPRB,2.4866E-01_JPRB,2.2061E-01_JPRB,1.8942E-01_JPRB,&
&1.5695E-01_JPRB,3.1727E-01_JPRB,2.8012E-01_JPRB/)
KAO( :, 5, 4,11) = (/&
&3.1858E-01_JPRB,2.9479E-01_JPRB,2.8190E-01_JPRB,2.6309E-01_JPRB,2.3448E-01_JPRB,2.0068E-01_JPRB,&
&1.6930E-01_JPRB,3.1858E-01_JPRB,3.4979E-01_JPRB/)
KAO( :, 1, 5,11) = (/&
&3.0359E-01_JPRB,2.6572E-01_JPRB,2.2874E-01_JPRB,1.9974E-01_JPRB,1.6826E-01_JPRB,1.3653E-01_JPRB,&
&1.0959E-01_JPRB,3.0359E-01_JPRB,9.5564E-02_JPRB/)
KAO( :, 2, 5,11) = (/&
&3.0961E-01_JPRB,2.7098E-01_JPRB,2.4191E-01_JPRB,2.1172E-01_JPRB,1.8197E-01_JPRB,1.5688E-01_JPRB,&
&1.2682E-01_JPRB,3.0961E-01_JPRB,1.3546E-01_JPRB/)
KAO( :, 3, 5,11) = (/&
&3.1431E-01_JPRB,2.7737E-01_JPRB,2.5231E-01_JPRB,2.2743E-01_JPRB,2.0217E-01_JPRB,1.7268E-01_JPRB,&
&1.3768E-01_JPRB,3.1431E-01_JPRB,1.8484E-01_JPRB/)
KAO( :, 4, 5,11) = (/&
&3.1787E-01_JPRB,2.8734E-01_JPRB,2.6579E-01_JPRB,2.4308E-01_JPRB,2.1533E-01_JPRB,1.8679E-01_JPRB,&
&1.5347E-01_JPRB,3.1787E-01_JPRB,2.4315E-01_JPRB/)
KAO( :, 5, 5,11) = (/&
&3.2027E-01_JPRB,2.9468E-01_JPRB,2.7870E-01_JPRB,2.5695E-01_JPRB,2.3189E-01_JPRB,2.0016E-01_JPRB,&
&1.6850E-01_JPRB,3.2027E-01_JPRB,3.1159E-01_JPRB/)
KAO( :, 1, 6,11) = (/&
&2.9865E-01_JPRB,2.6139E-01_JPRB,2.2417E-01_JPRB,1.9237E-01_JPRB,1.6261E-01_JPRB,1.3306E-01_JPRB,&
&1.0402E-01_JPRB,2.9865E-01_JPRB,7.4728E-02_JPRB/)
KAO( :, 2, 6,11) = (/&
&3.0619E-01_JPRB,2.6800E-01_JPRB,2.3652E-01_JPRB,2.0579E-01_JPRB,1.7684E-01_JPRB,1.5168E-01_JPRB,&
&1.2223E-01_JPRB,3.0619E-01_JPRB,1.0829E-01_JPRB/)
KAO( :, 3, 6,11) = (/&
&3.1241E-01_JPRB,2.7514E-01_JPRB,2.4815E-01_JPRB,2.2081E-01_JPRB,1.9720E-01_JPRB,1.6917E-01_JPRB,&
&1.3396E-01_JPRB,3.1241E-01_JPRB,1.5151E-01_JPRB/)
KAO( :, 4, 6,11) = (/&
&3.1661E-01_JPRB,2.8538E-01_JPRB,2.6104E-01_JPRB,2.3841E-01_JPRB,2.1165E-01_JPRB,1.8243E-01_JPRB,&
&1.4887E-01_JPRB,3.1661E-01_JPRB,2.0348E-01_JPRB/)
KAO( :, 5, 6,11) = (/&
&3.2000E-01_JPRB,2.9293E-01_JPRB,2.7479E-01_JPRB,2.5146E-01_JPRB,2.2881E-01_JPRB,1.9893E-01_JPRB,&
&1.6745E-01_JPRB,3.2000E-01_JPRB,2.6520E-01_JPRB/)
KAO( :, 1, 7,11) = (/&
&3.0081E-01_JPRB,2.6324E-01_JPRB,2.2567E-01_JPRB,1.8947E-01_JPRB,1.5824E-01_JPRB,1.2934E-01_JPRB,&
&9.9139E-02_JPRB,3.0081E-01_JPRB,5.8236E-02_JPRB/)
KAO( :, 2, 7,11) = (/&
&3.0785E-01_JPRB,2.6938E-01_JPRB,2.3362E-01_JPRB,2.0225E-01_JPRB,1.7197E-01_JPRB,1.4526E-01_JPRB,&
&1.1606E-01_JPRB,3.0785E-01_JPRB,8.6143E-02_JPRB/)
KAO( :, 3, 7,11) = (/&
&3.1355E-01_JPRB,2.7471E-01_JPRB,2.4475E-01_JPRB,2.1558E-01_JPRB,1.9203E-01_JPRB,1.6359E-01_JPRB,&
&1.2884E-01_JPRB,3.1355E-01_JPRB,1.2279E-01_JPRB/)
KAO( :, 4, 7,11) = (/&
&3.1773E-01_JPRB,2.8339E-01_JPRB,2.5534E-01_JPRB,2.3396E-01_JPRB,2.0755E-01_JPRB,1.7658E-01_JPRB,&
&1.4450E-01_JPRB,3.1773E-01_JPRB,1.6752E-01_JPRB/)
KAO( :, 5, 7,11) = (/&
&3.2073E-01_JPRB,2.9018E-01_JPRB,2.6952E-01_JPRB,2.4697E-01_JPRB,2.2381E-01_JPRB,1.9623E-01_JPRB,&
&1.6582E-01_JPRB,3.2073E-01_JPRB,2.2165E-01_JPRB/)
KAO( :, 1, 8,11) = (/&
&3.1629E-01_JPRB,2.7676E-01_JPRB,2.3728E-01_JPRB,1.9776E-01_JPRB,1.6109E-01_JPRB,1.2901E-01_JPRB,&
&9.4699E-02_JPRB,3.1629E-01_JPRB,4.5300E-02_JPRB/)
KAO( :, 2, 8,11) = (/&
&3.2227E-01_JPRB,2.8203E-01_JPRB,2.4214E-01_JPRB,2.0636E-01_JPRB,1.7262E-01_JPRB,1.4016E-01_JPRB,&
&1.0877E-01_JPRB,3.2227E-01_JPRB,6.8853E-02_JPRB/)
KAO( :, 3, 8,11) = (/&
&3.2688E-01_JPRB,2.8607E-01_JPRB,2.5069E-01_JPRB,2.1556E-01_JPRB,1.8748E-01_JPRB,1.5661E-01_JPRB,&
&1.2299E-01_JPRB,3.2688E-01_JPRB,1.0018E-01_JPRB/)
KAO( :, 4, 8,11) = (/&
&3.2981E-01_JPRB,2.9140E-01_JPRB,2.5712E-01_JPRB,2.3078E-01_JPRB,2.0158E-01_JPRB,1.7058E-01_JPRB,&
&1.4006E-01_JPRB,3.2981E-01_JPRB,1.3838E-01_JPRB/)
KAO( :, 5, 8,11) = (/&
&3.3188E-01_JPRB,2.9618E-01_JPRB,2.6784E-01_JPRB,2.4209E-01_JPRB,2.1696E-01_JPRB,1.9240E-01_JPRB,&
&1.6480E-01_JPRB,3.3188E-01_JPRB,1.8388E-01_JPRB/)
KAO( :, 1, 9,11) = (/&
&3.4054E-01_JPRB,2.9798E-01_JPRB,2.5543E-01_JPRB,2.1287E-01_JPRB,1.7079E-01_JPRB,1.3421E-01_JPRB,&
&9.5710E-02_JPRB,3.4054E-01_JPRB,3.8236E-02_JPRB/)
KAO( :, 2, 9,11) = (/&
&3.4633E-01_JPRB,3.0305E-01_JPRB,2.5976E-01_JPRB,2.1890E-01_JPRB,1.8147E-01_JPRB,1.4225E-01_JPRB,&
&1.0350E-01_JPRB,3.4633E-01_JPRB,5.6238E-02_JPRB/)
KAO( :, 3, 9,11) = (/&
&3.5037E-01_JPRB,3.0657E-01_JPRB,2.6602E-01_JPRB,2.2678E-01_JPRB,1.8994E-01_JPRB,1.5344E-01_JPRB,&
&1.1667E-01_JPRB,3.5037E-01_JPRB,8.1743E-02_JPRB/)
KAO( :, 4, 9,11) = (/&
&3.5228E-01_JPRB,3.0944E-01_JPRB,2.6992E-01_JPRB,2.3660E-01_JPRB,2.0123E-01_JPRB,1.6487E-01_JPRB,&
&1.3602E-01_JPRB,3.5228E-01_JPRB,1.1413E-01_JPRB/)
KAO( :, 5, 9,11) = (/&
&3.5225E-01_JPRB,3.1211E-01_JPRB,2.7731E-01_JPRB,2.4493E-01_JPRB,2.1160E-01_JPRB,1.8738E-01_JPRB,&
&1.6276E-01_JPRB,3.5225E-01_JPRB,1.5348E-01_JPRB/)
KAO( :, 1,10,11) = (/&
&3.6852E-01_JPRB,3.2247E-01_JPRB,2.7644E-01_JPRB,2.3039E-01_JPRB,1.8448E-01_JPRB,1.4188E-01_JPRB,&
&9.9757E-02_JPRB,3.6852E-01_JPRB,1.4040E-01_JPRB/)
KAO( :, 2,10,11) = (/&
&3.7315E-01_JPRB,3.2652E-01_JPRB,2.7989E-01_JPRB,2.3366E-01_JPRB,1.9261E-01_JPRB,1.5003E-01_JPRB,&
&1.0586E-01_JPRB,3.7315E-01_JPRB,1.4526E-01_JPRB/)
KAO( :, 3,10,11) = (/&
&3.7571E-01_JPRB,3.2878E-01_JPRB,2.8366E-01_JPRB,2.4104E-01_JPRB,1.9987E-01_JPRB,1.5820E-01_JPRB,&
&1.1578E-01_JPRB,3.7571E-01_JPRB,1.5497E-01_JPRB/)
KAO( :, 4,10,11) = (/&
&3.7705E-01_JPRB,3.3024E-01_JPRB,2.8735E-01_JPRB,2.4933E-01_JPRB,2.0907E-01_JPRB,1.6748E-01_JPRB,&
&1.3413E-01_JPRB,3.7705E-01_JPRB,1.6746E-01_JPRB/)
KAO( :, 5,10,11) = (/&
&3.7628E-01_JPRB,3.3247E-01_JPRB,2.9343E-01_JPRB,2.5663E-01_JPRB,2.1748E-01_JPRB,1.8673E-01_JPRB,&
&1.6058E-01_JPRB,3.7628E-01_JPRB,1.8275E-01_JPRB/)
KAO( :, 1,11,11) = (/&
&4.0038E-01_JPRB,3.5035E-01_JPRB,3.0034E-01_JPRB,2.5030E-01_JPRB,2.0116E-01_JPRB,1.5522E-01_JPRB,&
&1.0823E-01_JPRB,4.0038E-01_JPRB,3.5490E-01_JPRB/)
KAO( :, 2,11,11) = (/&
&4.0396E-01_JPRB,3.5350E-01_JPRB,3.0301E-01_JPRB,2.5425E-01_JPRB,2.0946E-01_JPRB,1.6195E-01_JPRB,&
&1.1374E-01_JPRB,4.0396E-01_JPRB,3.4856E-01_JPRB/)
KAO( :, 3,11,11) = (/&
&4.0565E-01_JPRB,3.5496E-01_JPRB,3.0665E-01_JPRB,2.6112E-01_JPRB,2.1551E-01_JPRB,1.6958E-01_JPRB,&
&1.2572E-01_JPRB,4.0565E-01_JPRB,3.5076E-01_JPRB/)
KAO( :, 4,11,11) = (/&
&4.0558E-01_JPRB,3.5595E-01_JPRB,3.0938E-01_JPRB,2.6840E-01_JPRB,2.2301E-01_JPRB,1.8046E-01_JPRB,&
&1.4403E-01_JPRB,4.0558E-01_JPRB,3.5722E-01_JPRB/)
KAO( :, 5,11,11) = (/&
&4.0446E-01_JPRB,3.5712E-01_JPRB,3.1553E-01_JPRB,2.7323E-01_JPRB,2.3366E-01_JPRB,2.0210E-01_JPRB,&
&1.6875E-01_JPRB,4.0446E-01_JPRB,3.6719E-01_JPRB/)
KAO( :, 1,12,11) = (/&
&4.3154E-01_JPRB,3.7764E-01_JPRB,3.2370E-01_JPRB,2.6981E-01_JPRB,2.1804E-01_JPRB,1.6850E-01_JPRB,&
&1.1669E-01_JPRB,4.3154E-01_JPRB,6.0134E-01_JPRB/)
KAO( :, 2,12,11) = (/&
&4.3374E-01_JPRB,3.7956E-01_JPRB,3.2536E-01_JPRB,2.7466E-01_JPRB,2.2555E-01_JPRB,1.7385E-01_JPRB,&
&1.2290E-01_JPRB,4.3374E-01_JPRB,5.8479E-01_JPRB/)
KAO( :, 3,12,11) = (/&
&4.3331E-01_JPRB,3.7916E-01_JPRB,3.2808E-01_JPRB,2.8000E-01_JPRB,2.3156E-01_JPRB,1.8166E-01_JPRB,&
&1.3630E-01_JPRB,4.3331E-01_JPRB,5.7701E-01_JPRB/)
KAO( :, 4,12,11) = (/&
&4.3216E-01_JPRB,3.8009E-01_JPRB,3.3136E-01_JPRB,2.8692E-01_JPRB,2.3835E-01_JPRB,1.9569E-01_JPRB,&
&1.5406E-01_JPRB,4.3216E-01_JPRB,5.7788E-01_JPRB/)
KAO( :, 5,12,11) = (/&
&4.2924E-01_JPRB,3.7929E-01_JPRB,3.3644E-01_JPRB,2.9162E-01_JPRB,2.5358E-01_JPRB,2.1598E-01_JPRB,&
&1.7801E-01_JPRB,4.2924E-01_JPRB,5.8590E-01_JPRB/)
KAO( :, 1,13,11) = (/&
&4.5507E-01_JPRB,3.9820E-01_JPRB,3.4134E-01_JPRB,2.8486E-01_JPRB,2.3199E-01_JPRB,1.7908E-01_JPRB,&
&1.2378E-01_JPRB,4.5507E-01_JPRB,8.3466E-01_JPRB/)
KAO( :, 2,13,11) = (/&
&4.5560E-01_JPRB,3.9865E-01_JPRB,3.4207E-01_JPRB,2.9076E-01_JPRB,2.3824E-01_JPRB,1.8413E-01_JPRB,&
&1.3231E-01_JPRB,4.5560E-01_JPRB,8.1743E-01_JPRB/)
KAO( :, 3,13,11) = (/&
&4.5408E-01_JPRB,3.9738E-01_JPRB,3.4508E-01_JPRB,2.9494E-01_JPRB,2.4447E-01_JPRB,1.9400E-01_JPRB,&
&1.4658E-01_JPRB,4.5408E-01_JPRB,8.0395E-01_JPRB/)
KAO( :, 4,13,11) = (/&
&4.5061E-01_JPRB,3.9693E-01_JPRB,3.4841E-01_JPRB,3.0086E-01_JPRB,2.5386E-01_JPRB,2.0976E-01_JPRB,&
&1.6407E-01_JPRB,4.5061E-01_JPRB,8.0112E-01_JPRB/)
KAO( :, 5,13,11) = (/&
&4.4632E-01_JPRB,3.9509E-01_JPRB,3.5179E-01_JPRB,3.0910E-01_JPRB,2.7153E-01_JPRB,2.3030E-01_JPRB,&
&1.8645E-01_JPRB,4.4632E-01_JPRB,8.0445E-01_JPRB/)
KAO( :, 1, 1,12) = (/&
&4.5134E-01_JPRB,3.9508E-01_JPRB,3.3890E-01_JPRB,2.8825E-01_JPRB,2.4778E-01_JPRB,1.9924E-01_JPRB,&
&1.4875E-01_JPRB,4.5134E-01_JPRB,1.8824E-01_JPRB/)
KAO( :, 2, 1,12) = (/&
&4.4302E-01_JPRB,3.8780E-01_JPRB,3.3477E-01_JPRB,2.9793E-01_JPRB,2.5163E-01_JPRB,2.0880E-01_JPRB,&
&1.6421E-01_JPRB,4.4302E-01_JPRB,2.4393E-01_JPRB/)
KAO( :, 3, 1,12) = (/&
&4.3442E-01_JPRB,3.8027E-01_JPRB,3.4110E-01_JPRB,2.9993E-01_JPRB,2.6022E-01_JPRB,2.1949E-01_JPRB,&
&2.0337E-01_JPRB,4.3442E-01_JPRB,3.1211E-01_JPRB/)
KAO( :, 4, 1,12) = (/&
&4.2548E-01_JPRB,3.7248E-01_JPRB,3.4001E-01_JPRB,3.0363E-01_JPRB,2.6872E-01_JPRB,2.3529E-01_JPRB,&
&2.6208E-01_JPRB,4.2548E-01_JPRB,4.0218E-01_JPRB/)
KAO( :, 5, 1,12) = (/&
&4.1637E-01_JPRB,3.7184E-01_JPRB,3.3956E-01_JPRB,3.0702E-01_JPRB,2.7666E-01_JPRB,3.0048E-01_JPRB,&
&3.3370E-01_JPRB,4.1637E-01_JPRB,5.1810E-01_JPRB/)
KAO( :, 1, 2,12) = (/&
&4.5993E-01_JPRB,4.0257E-01_JPRB,3.4522E-01_JPRB,2.9460E-01_JPRB,2.5120E-01_JPRB,2.0075E-01_JPRB,&
&1.4994E-01_JPRB,4.5993E-01_JPRB,1.8380E-01_JPRB/)
KAO( :, 2, 2,12) = (/&
&4.5214E-01_JPRB,3.9569E-01_JPRB,3.4306E-01_JPRB,3.0314E-01_JPRB,2.5542E-01_JPRB,2.1170E-01_JPRB,&
&1.6517E-01_JPRB,4.5214E-01_JPRB,2.4302E-01_JPRB/)
KAO( :, 3, 2,12) = (/&
&4.4392E-01_JPRB,3.8859E-01_JPRB,3.4836E-01_JPRB,3.0544E-01_JPRB,2.6499E-01_JPRB,2.2418E-01_JPRB,&
&1.8731E-01_JPRB,4.4392E-01_JPRB,3.1300E-01_JPRB/)
KAO( :, 4, 2,12) = (/&
&4.3542E-01_JPRB,3.8194E-01_JPRB,3.4769E-01_JPRB,3.0985E-01_JPRB,2.7291E-01_JPRB,2.3160E-01_JPRB,&
&2.4758E-01_JPRB,4.3542E-01_JPRB,3.9636E-01_JPRB/)
KAO( :, 5, 2,12) = (/&
&4.2659E-01_JPRB,3.8102E-01_JPRB,3.4597E-01_JPRB,3.1267E-01_JPRB,2.8101E-01_JPRB,2.8559E-01_JPRB,&
&3.2264E-01_JPRB,4.2659E-01_JPRB,5.0187E-01_JPRB/)
KAO( :, 1, 3,12) = (/&
&4.6833E-01_JPRB,4.0988E-01_JPRB,3.5146E-01_JPRB,2.9725E-01_JPRB,2.5255E-01_JPRB,2.0071E-01_JPRB,&
&1.4658E-01_JPRB,4.6833E-01_JPRB,1.7493E-01_JPRB/)
KAO( :, 2, 3,12) = (/&
&4.6121E-01_JPRB,4.0366E-01_JPRB,3.4878E-01_JPRB,3.0682E-01_JPRB,2.5668E-01_JPRB,2.1030E-01_JPRB,&
&1.6556E-01_JPRB,4.6121E-01_JPRB,2.3373E-01_JPRB/)
KAO( :, 3, 3,12) = (/&
&4.5378E-01_JPRB,3.9716E-01_JPRB,3.5415E-01_JPRB,3.0895E-01_JPRB,2.6677E-01_JPRB,2.2483E-01_JPRB,&
&1.7374E-01_JPRB,4.5378E-01_JPRB,3.0656E-01_JPRB/)
KAO( :, 4, 3,12) = (/&
&4.4576E-01_JPRB,3.9132E-01_JPRB,3.5375E-01_JPRB,3.1409E-01_JPRB,2.7473E-01_JPRB,2.3114E-01_JPRB,&
&2.1677E-01_JPRB,4.4576E-01_JPRB,3.9296E-01_JPRB/)
KAO( :, 5, 3,12) = (/&
&4.3705E-01_JPRB,3.9046E-01_JPRB,3.5326E-01_JPRB,3.1679E-01_JPRB,2.8502E-01_JPRB,2.5712E-01_JPRB,&
&2.8930E-01_JPRB,4.3705E-01_JPRB,4.9026E-01_JPRB/)
KAO( :, 1, 4,12) = (/&
&4.7595E-01_JPRB,4.1655E-01_JPRB,3.5714E-01_JPRB,2.9920E-01_JPRB,2.5213E-01_JPRB,1.9982E-01_JPRB,&
&1.4381E-01_JPRB,4.7595E-01_JPRB,1.5872E-01_JPRB/)
KAO( :, 2, 4,12) = (/&
&4.7033E-01_JPRB,4.1161E-01_JPRB,3.5414E-01_JPRB,3.0922E-01_JPRB,2.5846E-01_JPRB,2.0731E-01_JPRB,&
&1.6215E-01_JPRB,4.7033E-01_JPRB,2.1800E-01_JPRB/)
KAO( :, 3, 4,12) = (/&
&4.6352E-01_JPRB,4.0565E-01_JPRB,3.5971E-01_JPRB,3.1204E-01_JPRB,2.6678E-01_JPRB,2.2292E-01_JPRB,&
&1.7122E-01_JPRB,4.6352E-01_JPRB,2.9018E-01_JPRB/)
KAO( :, 4, 4,12) = (/&
&4.5585E-01_JPRB,4.0027E-01_JPRB,3.5920E-01_JPRB,3.1814E-01_JPRB,2.7571E-01_JPRB,2.2988E-01_JPRB,&
&1.8807E-01_JPRB,4.5585E-01_JPRB,3.7615E-01_JPRB/)
KAO( :, 5, 4,12) = (/&
&4.4747E-01_JPRB,3.9994E-01_JPRB,3.6045E-01_JPRB,3.2102E-01_JPRB,2.8482E-01_JPRB,2.4194E-01_JPRB,&
&2.4872E-01_JPRB,4.4747E-01_JPRB,4.7733E-01_JPRB/)
KAO( :, 1, 5,12) = (/&
&4.8332E-01_JPRB,4.2296E-01_JPRB,3.6260E-01_JPRB,3.0235E-01_JPRB,2.5042E-01_JPRB,1.9864E-01_JPRB,&
&1.4130E-01_JPRB,4.8332E-01_JPRB,1.3745E-01_JPRB/)
KAO( :, 2, 5,12) = (/&
&4.7867E-01_JPRB,4.1890E-01_JPRB,3.5947E-01_JPRB,3.1127E-01_JPRB,2.5927E-01_JPRB,2.0493E-01_JPRB,&
&1.5750E-01_JPRB,4.7867E-01_JPRB,1.9596E-01_JPRB/)
KAO( :, 3, 5,12) = (/&
&4.7259E-01_JPRB,4.1358E-01_JPRB,3.6520E-01_JPRB,3.1459E-01_JPRB,2.6723E-01_JPRB,2.2048E-01_JPRB,&
&1.7032E-01_JPRB,4.7259E-01_JPRB,2.6742E-01_JPRB/)
KAO( :, 4, 5,12) = (/&
&4.6538E-01_JPRB,4.0850E-01_JPRB,3.6518E-01_JPRB,3.2176E-01_JPRB,2.7688E-01_JPRB,2.2777E-01_JPRB,&
&1.8088E-01_JPRB,4.6538E-01_JPRB,3.5196E-01_JPRB/)
KAO( :, 5, 5,12) = (/&
&4.5769E-01_JPRB,4.0896E-01_JPRB,3.6726E-01_JPRB,3.2571E-01_JPRB,2.8321E-01_JPRB,2.4098E-01_JPRB,&
&2.1462E-01_JPRB,4.5769E-01_JPRB,4.5123E-01_JPRB/)
KAO( :, 1, 6,12) = (/&
&4.8993E-01_JPRB,4.2877E-01_JPRB,3.6756E-01_JPRB,3.0637E-01_JPRB,2.4861E-01_JPRB,1.9592E-01_JPRB,&
&1.4097E-01_JPRB,4.8993E-01_JPRB,1.1309E-01_JPRB/)
KAO( :, 2, 6,12) = (/&
&4.8623E-01_JPRB,4.2551E-01_JPRB,3.6480E-01_JPRB,3.1259E-01_JPRB,2.5937E-01_JPRB,2.0293E-01_JPRB,&
&1.5359E-01_JPRB,4.8623E-01_JPRB,1.6654E-01_JPRB/)
KAO( :, 3, 6,12) = (/&
&4.8158E-01_JPRB,4.2145E-01_JPRB,3.6981E-01_JPRB,3.1811E-01_JPRB,2.6579E-01_JPRB,2.1805E-01_JPRB,&
&1.7034E-01_JPRB,4.8158E-01_JPRB,2.3416E-01_JPRB/)
KAO( :, 4, 6,12) = (/&
&4.7580E-01_JPRB,4.1675E-01_JPRB,3.7108E-01_JPRB,3.2456E-01_JPRB,2.7803E-01_JPRB,2.2833E-01_JPRB,&
&1.8066E-01_JPRB,4.7580E-01_JPRB,3.1607E-01_JPRB/)
KAO( :, 5, 6,12) = (/&
&4.6758E-01_JPRB,4.1652E-01_JPRB,3.7367E-01_JPRB,3.3147E-01_JPRB,2.8380E-01_JPRB,2.4223E-01_JPRB,&
&1.9841E-01_JPRB,4.6758E-01_JPRB,4.1181E-01_JPRB/)
KAO( :, 1, 7,12) = (/&
&4.9556E-01_JPRB,4.3365E-01_JPRB,3.7175E-01_JPRB,3.0985E-01_JPRB,2.4854E-01_JPRB,1.9277E-01_JPRB,&
&1.4013E-01_JPRB,4.9556E-01_JPRB,8.9473E-02_JPRB/)
KAO( :, 2, 7,12) = (/&
&4.9363E-01_JPRB,4.3195E-01_JPRB,3.7029E-01_JPRB,3.1256E-01_JPRB,2.5963E-01_JPRB,2.0328E-01_JPRB,&
&1.5194E-01_JPRB,4.9363E-01_JPRB,1.3619E-01_JPRB/)
KAO( :, 3, 7,12) = (/&
&4.8988E-01_JPRB,4.2866E-01_JPRB,3.7265E-01_JPRB,3.2073E-01_JPRB,2.6549E-01_JPRB,2.1787E-01_JPRB,&
&1.7010E-01_JPRB,4.8988E-01_JPRB,1.9644E-01_JPRB/)
KAO( :, 4, 7,12) = (/&
&4.8356E-01_JPRB,4.2335E-01_JPRB,3.7640E-01_JPRB,3.2648E-01_JPRB,2.8045E-01_JPRB,2.3190E-01_JPRB,&
&1.7955E-01_JPRB,4.8356E-01_JPRB,2.7163E-01_JPRB/)
KAO( :, 5, 7,12) = (/&
&4.7613E-01_JPRB,4.2343E-01_JPRB,3.7941E-01_JPRB,3.3677E-01_JPRB,2.8839E-01_JPRB,2.4416E-01_JPRB,&
&1.9240E-01_JPRB,4.7613E-01_JPRB,3.6146E-01_JPRB/)
KAO( :, 1, 8,12) = (/&
&4.9952E-01_JPRB,4.3713E-01_JPRB,3.7469E-01_JPRB,3.1228E-01_JPRB,2.4992E-01_JPRB,1.8992E-01_JPRB,&
&1.3910E-01_JPRB,4.9952E-01_JPRB,7.0068E-02_JPRB/)
KAO( :, 2, 8,12) = (/&
&4.9876E-01_JPRB,4.3647E-01_JPRB,3.7415E-01_JPRB,3.1359E-01_JPRB,2.5898E-01_JPRB,2.0365E-01_JPRB,&
&1.5225E-01_JPRB,4.9876E-01_JPRB,1.0911E-01_JPRB/)
KAO( :, 3, 8,12) = (/&
&4.9561E-01_JPRB,4.3367E-01_JPRB,3.7478E-01_JPRB,3.2253E-01_JPRB,2.6652E-01_JPRB,2.1802E-01_JPRB,&
&1.6931E-01_JPRB,4.9561E-01_JPRB,1.6065E-01_JPRB/)
KAO( :, 4, 8,12) = (/&
&4.9132E-01_JPRB,4.2995E-01_JPRB,3.8056E-01_JPRB,3.2825E-01_JPRB,2.8313E-01_JPRB,2.3561E-01_JPRB,&
&1.7963E-01_JPRB,4.9132E-01_JPRB,2.2657E-01_JPRB/)
KAO( :, 5, 8,12) = (/&
&4.8493E-01_JPRB,4.3037E-01_JPRB,3.8392E-01_JPRB,3.3999E-01_JPRB,2.9506E-01_JPRB,2.4592E-01_JPRB,&
&1.9305E-01_JPRB,4.8493E-01_JPRB,3.0798E-01_JPRB/)
KAO( :, 1, 9,12) = (/&
&5.0297E-01_JPRB,4.4011E-01_JPRB,3.7727E-01_JPRB,3.1445E-01_JPRB,2.5164E-01_JPRB,1.8923E-01_JPRB,&
&1.3630E-01_JPRB,5.0297E-01_JPRB,5.5928E-02_JPRB/)
KAO( :, 2, 9,12) = (/&
&5.0280E-01_JPRB,4.3999E-01_JPRB,3.7719E-01_JPRB,3.1439E-01_JPRB,2.5596E-01_JPRB,2.0387E-01_JPRB,&
&1.5194E-01_JPRB,5.0280E-01_JPRB,8.7259E-02_JPRB/)
KAO( :, 3, 9,12) = (/&
&5.0165E-01_JPRB,4.3899E-01_JPRB,3.7733E-01_JPRB,3.2316E-01_JPRB,2.6815E-01_JPRB,2.1765E-01_JPRB,&
&1.6729E-01_JPRB,5.0165E-01_JPRB,1.3032E-01_JPRB/)
KAO( :, 4, 9,12) = (/&
&4.9775E-01_JPRB,4.3558E-01_JPRB,3.8325E-01_JPRB,3.2898E-01_JPRB,2.8348E-01_JPRB,2.3696E-01_JPRB,&
&1.7992E-01_JPRB,4.9775E-01_JPRB,1.8697E-01_JPRB/)
KAO( :, 5, 9,12) = (/&
&4.9256E-01_JPRB,4.3533E-01_JPRB,3.8600E-01_JPRB,3.4285E-01_JPRB,2.9917E-01_JPRB,2.4757E-01_JPRB,&
&1.9469E-01_JPRB,4.9256E-01_JPRB,2.5776E-01_JPRB/)
KAO( :, 1,10,12) = (/&
&5.1773E-01_JPRB,4.5305E-01_JPRB,3.8832E-01_JPRB,3.2361E-01_JPRB,2.5894E-01_JPRB,1.9444E-01_JPRB,&
&1.3626E-01_JPRB,5.1773E-01_JPRB,1.7143E-01_JPRB/)
KAO( :, 2,10,12) = (/&
&5.2014E-01_JPRB,4.5518E-01_JPRB,3.9014E-01_JPRB,3.2511E-01_JPRB,2.6137E-01_JPRB,2.0558E-01_JPRB,&
&1.5091E-01_JPRB,5.2014E-01_JPRB,1.7878E-01_JPRB/)
KAO( :, 3,10,12) = (/&
&5.1859E-01_JPRB,4.5376E-01_JPRB,3.8899E-01_JPRB,3.2977E-01_JPRB,2.7178E-01_JPRB,2.1806E-01_JPRB,&
&1.6450E-01_JPRB,5.1859E-01_JPRB,1.8778E-01_JPRB/)
KAO( :, 4,10,12) = (/&
&5.1464E-01_JPRB,4.5036E-01_JPRB,3.9278E-01_JPRB,3.3429E-01_JPRB,2.8520E-01_JPRB,2.3593E-01_JPRB,&
&1.7923E-01_JPRB,5.1464E-01_JPRB,2.0686E-01_JPRB/)
KAO( :, 5,10,12) = (/&
&5.1018E-01_JPRB,4.4905E-01_JPRB,3.9440E-01_JPRB,3.4703E-01_JPRB,3.0026E-01_JPRB,2.4817E-01_JPRB,&
&1.9727E-01_JPRB,5.1018E-01_JPRB,2.4342E-01_JPRB/)
KAO( :, 1,11,12) = (/&
&5.4832E-01_JPRB,4.7977E-01_JPRB,4.1126E-01_JPRB,3.4274E-01_JPRB,2.7420E-01_JPRB,2.0703E-01_JPRB,&
&1.4636E-01_JPRB,5.4832E-01_JPRB,4.2229E-01_JPRB/)
KAO( :, 2,11,12) = (/&
&5.4890E-01_JPRB,4.8029E-01_JPRB,4.1169E-01_JPRB,3.4308E-01_JPRB,2.7803E-01_JPRB,2.1902E-01_JPRB,&
&1.5675E-01_JPRB,5.4890E-01_JPRB,4.1304E-01_JPRB/)
KAO( :, 3,11,12) = (/&
&5.4760E-01_JPRB,4.7912E-01_JPRB,4.1148E-01_JPRB,3.4845E-01_JPRB,2.8802E-01_JPRB,2.2864E-01_JPRB,&
&1.6957E-01_JPRB,5.4760E-01_JPRB,4.1866E-01_JPRB/)
KAO( :, 4,11,12) = (/&
&5.4451E-01_JPRB,4.7646E-01_JPRB,4.1466E-01_JPRB,3.5324E-01_JPRB,3.0043E-01_JPRB,2.4253E-01_JPRB,&
&1.8588E-01_JPRB,5.4451E-01_JPRB,4.2963E-01_JPRB/)
KAO( :, 5,11,12) = (/&
&5.3844E-01_JPRB,4.7499E-01_JPRB,4.1514E-01_JPRB,3.6472E-01_JPRB,3.0977E-01_JPRB,2.5655E-01_JPRB,&
&2.1387E-01_JPRB,5.3844E-01_JPRB,4.4513E-01_JPRB/)
KAO( :, 1,12,12) = (/&
&5.9065E-01_JPRB,5.1684E-01_JPRB,4.4304E-01_JPRB,3.6914E-01_JPRB,2.9536E-01_JPRB,2.2452E-01_JPRB,&
&1.5812E-01_JPRB,5.9065E-01_JPRB,7.0088E-01_JPRB/)
KAO( :, 2,12,12) = (/&
&5.8872E-01_JPRB,5.1516E-01_JPRB,4.4157E-01_JPRB,3.6818E-01_JPRB,3.0050E-01_JPRB,2.3470E-01_JPRB,&
&1.6533E-01_JPRB,5.8872E-01_JPRB,6.8724E-01_JPRB/)
KAO( :, 3,12,12) = (/&
&5.8657E-01_JPRB,5.1328E-01_JPRB,4.4183E-01_JPRB,3.7357E-01_JPRB,3.0883E-01_JPRB,2.4369E-01_JPRB,&
&1.7720E-01_JPRB,5.8657E-01_JPRB,6.7692E-01_JPRB/)
KAO( :, 4,12,12) = (/&
&5.8202E-01_JPRB,5.0954E-01_JPRB,4.4287E-01_JPRB,3.7996E-01_JPRB,3.1901E-01_JPRB,2.5355E-01_JPRB,&
&1.9754E-01_JPRB,5.8202E-01_JPRB,6.8063E-01_JPRB/)
KAO( :, 5,12,12) = (/&
&5.7488E-01_JPRB,5.0736E-01_JPRB,4.4448E-01_JPRB,3.8734E-01_JPRB,3.2636E-01_JPRB,2.7530E-01_JPRB,&
&2.2896E-01_JPRB,5.7488E-01_JPRB,6.8864E-01_JPRB/)
KAO( :, 1,13,12) = (/&
&6.3330E-01_JPRB,5.5414E-01_JPRB,4.7500E-01_JPRB,3.9585E-01_JPRB,3.1697E-01_JPRB,2.4329E-01_JPRB,&
&1.7024E-01_JPRB,6.3330E-01_JPRB,9.6193E-01_JPRB/)
KAO( :, 2,13,12) = (/&
&6.3223E-01_JPRB,5.5319E-01_JPRB,4.7424E-01_JPRB,3.9638E-01_JPRB,3.2473E-01_JPRB,2.5152E-01_JPRB,&
&1.7599E-01_JPRB,6.3223E-01_JPRB,9.4444E-01_JPRB/)
KAO( :, 3,13,12) = (/&
&6.2744E-01_JPRB,5.4905E-01_JPRB,4.7373E-01_JPRB,4.0076E-01_JPRB,3.3050E-01_JPRB,2.6025E-01_JPRB,&
&1.8993E-01_JPRB,6.2744E-01_JPRB,9.2859E-01_JPRB/)
KAO( :, 4,13,12) = (/&
&6.2161E-01_JPRB,5.4502E-01_JPRB,4.7279E-01_JPRB,4.0774E-01_JPRB,3.3922E-01_JPRB,2.7164E-01_JPRB,&
&2.1216E-01_JPRB,6.2161E-01_JPRB,9.1983E-01_JPRB/)
KAO( :, 5,13,12) = (/&
&6.1416E-01_JPRB,5.4190E-01_JPRB,4.7545E-01_JPRB,4.1094E-01_JPRB,3.4988E-01_JPRB,2.9767E-01_JPRB,&
&2.4315E-01_JPRB,6.1416E-01_JPRB,9.2076E-01_JPRB/)
KAO( :, 1, 1,13) = (/&
&5.6801E-01_JPRB,4.9753E-01_JPRB,4.2614E-01_JPRB,3.5562E-01_JPRB,2.9784E-01_JPRB,2.3762E-01_JPRB,&
&1.7067E-01_JPRB,5.6801E-01_JPRB,2.8847E-01_JPRB/)
KAO( :, 2, 1,13) = (/&
&5.4506E-01_JPRB,4.7713E-01_JPRB,4.0945E-01_JPRB,3.5614E-01_JPRB,2.9906E-01_JPRB,2.3687E-01_JPRB,&
&2.1806E-01_JPRB,5.4506E-01_JPRB,3.9566E-01_JPRB/)
KAO( :, 3, 1,13) = (/&
&5.2208E-01_JPRB,4.5704E-01_JPRB,4.0103E-01_JPRB,3.5099E-01_JPRB,2.9640E-01_JPRB,2.7382E-01_JPRB,&
&2.9611E-01_JPRB,5.2208E-01_JPRB,5.3813E-01_JPRB/)
KAO( :, 4, 1,13) = (/&
&5.0009E-01_JPRB,4.3777E-01_JPRB,3.9424E-01_JPRB,3.4743E-01_JPRB,3.1380E-01_JPRB,3.5655E-01_JPRB,&
&3.8844E-01_JPRB,5.0009E-01_JPRB,7.1248E-01_JPRB/)
KAO( :, 5, 1,13) = (/&
&4.7842E-01_JPRB,4.2067E-01_JPRB,3.8681E-01_JPRB,3.4438E-01_JPRB,3.8224E-01_JPRB,4.4874E-01_JPRB,&
&4.9670E-01_JPRB,4.7842E-01_JPRB,9.2069E-01_JPRB/)
KAO( :, 1, 2,13) = (/&
&5.8929E-01_JPRB,5.1576E-01_JPRB,4.4253E-01_JPRB,3.6899E-01_JPRB,3.0866E-01_JPRB,2.4593E-01_JPRB,&
&1.7419E-01_JPRB,5.8929E-01_JPRB,2.7016E-01_JPRB/)
KAO( :, 2, 2,13) = (/&
&5.6495E-01_JPRB,4.9446E-01_JPRB,4.2405E-01_JPRB,3.6956E-01_JPRB,3.0941E-01_JPRB,2.4584E-01_JPRB,&
&2.0900E-01_JPRB,5.6495E-01_JPRB,3.6136E-01_JPRB/)
KAO( :, 3, 2,13) = (/&
&5.4068E-01_JPRB,4.7328E-01_JPRB,4.1750E-01_JPRB,3.6380E-01_JPRB,3.0869E-01_JPRB,2.6782E-01_JPRB,&
&2.8845E-01_JPRB,5.4068E-01_JPRB,4.8684E-01_JPRB/)
KAO( :, 4, 2,13) = (/&
&5.1706E-01_JPRB,4.5259E-01_JPRB,4.0848E-01_JPRB,3.6075E-01_JPRB,3.1658E-01_JPRB,3.4323E-01_JPRB,&
&3.8025E-01_JPRB,5.1706E-01_JPRB,6.5346E-01_JPRB/)
KAO( :, 5, 2,13) = (/&
&4.9404E-01_JPRB,4.3831E-01_JPRB,4.0091E-01_JPRB,3.5604E-01_JPRB,3.7274E-01_JPRB,4.3563E-01_JPRB,&
&4.8657E-01_JPRB,4.9404E-01_JPRB,8.5443E-01_JPRB/)
KAO( :, 1, 3,13) = (/&
&6.1460E-01_JPRB,5.3792E-01_JPRB,4.6119E-01_JPRB,3.8446E-01_JPRB,3.1580E-01_JPRB,2.5245E-01_JPRB,&
&1.8069E-01_JPRB,6.1460E-01_JPRB,2.4476E-01_JPRB/)
KAO( :, 2, 3,13) = (/&
&5.8902E-01_JPRB,5.1550E-01_JPRB,4.4201E-01_JPRB,3.8201E-01_JPRB,3.1981E-01_JPRB,2.5246E-01_JPRB,&
&1.9290E-01_JPRB,5.8902E-01_JPRB,3.2384E-01_JPRB/)
KAO( :, 3, 3,13) = (/&
&5.6359E-01_JPRB,4.9325E-01_JPRB,4.3340E-01_JPRB,3.7717E-01_JPRB,3.1924E-01_JPRB,2.6085E-01_JPRB,&
&2.6060E-01_JPRB,5.6359E-01_JPRB,4.2953E-01_JPRB/)
KAO( :, 4, 3,13) = (/&
&5.3858E-01_JPRB,4.7139E-01_JPRB,4.2433E-01_JPRB,3.7392E-01_JPRB,3.2043E-01_JPRB,3.1006E-01_JPRB,&
&3.4867E-01_JPRB,5.3858E-01_JPRB,5.6773E-01_JPRB/)
KAO( :, 5, 3,13) = (/&
&5.1490E-01_JPRB,4.5696E-01_JPRB,4.1592E-01_JPRB,3.6991E-01_JPRB,3.4822E-01_JPRB,4.0122E-01_JPRB,&
&4.5118E-01_JPRB,5.1490E-01_JPRB,7.4387E-01_JPRB/)
KAO( :, 1, 4,13) = (/&
&6.4145E-01_JPRB,5.6134E-01_JPRB,4.8123E-01_JPRB,4.0119E-01_JPRB,3.2332E-01_JPRB,2.5778E-01_JPRB,&
&1.8494E-01_JPRB,6.4145E-01_JPRB,2.1630E-01_JPRB/)
KAO( :, 2, 4,13) = (/&
&6.1419E-01_JPRB,5.3750E-01_JPRB,4.6079E-01_JPRB,3.9241E-01_JPRB,3.2922E-01_JPRB,2.5906E-01_JPRB,&
&1.8892E-01_JPRB,6.1419E-01_JPRB,2.9208E-01_JPRB/)
KAO( :, 3, 4,13) = (/&
&5.8813E-01_JPRB,5.1468E-01_JPRB,4.4799E-01_JPRB,3.9004E-01_JPRB,3.2671E-01_JPRB,2.6510E-01_JPRB,&
&2.2685E-01_JPRB,5.8813E-01_JPRB,3.9137E-01_JPRB/)
KAO( :, 4, 4,13) = (/&
&5.6273E-01_JPRB,4.9248E-01_JPRB,4.4059E-01_JPRB,3.8556E-01_JPRB,3.3060E-01_JPRB,2.8625E-01_JPRB,&
&3.0760E-01_JPRB,5.6273E-01_JPRB,5.0589E-01_JPRB/)
KAO( :, 5, 4,13) = (/&
&5.3804E-01_JPRB,4.7588E-01_JPRB,4.3067E-01_JPRB,3.8369E-01_JPRB,3.3395E-01_JPRB,3.5921E-01_JPRB,&
&4.0495E-01_JPRB,5.3804E-01_JPRB,6.5237E-01_JPRB/)
KAO( :, 1, 5,13) = (/&
&6.6759E-01_JPRB,5.8420E-01_JPRB,5.0082E-01_JPRB,4.1745E-01_JPRB,3.3417E-01_JPRB,2.6101E-01_JPRB,&
&1.8769E-01_JPRB,6.6759E-01_JPRB,1.9371E-01_JPRB/)
KAO( :, 2, 5,13) = (/&
&6.3993E-01_JPRB,5.5998E-01_JPRB,4.8009E-01_JPRB,4.0342E-01_JPRB,3.3762E-01_JPRB,2.6493E-01_JPRB,&
&1.8973E-01_JPRB,6.3993E-01_JPRB,2.6409E-01_JPRB/)
KAO( :, 3, 5,13) = (/&
&6.1332E-01_JPRB,5.3667E-01_JPRB,4.6314E-01_JPRB,4.0266E-01_JPRB,3.3397E-01_JPRB,2.6941E-01_JPRB,&
&2.0819E-01_JPRB,6.1332E-01_JPRB,3.5928E-01_JPRB/)
KAO( :, 4, 5,13) = (/&
&5.8743E-01_JPRB,5.1406E-01_JPRB,4.5644E-01_JPRB,3.9637E-01_JPRB,3.3947E-01_JPRB,2.7620E-01_JPRB,&
&2.6432E-01_JPRB,5.8743E-01_JPRB,4.7554E-01_JPRB/)
KAO( :, 5, 5,13) = (/&
&5.6212E-01_JPRB,4.9526E-01_JPRB,4.4574E-01_JPRB,3.9617E-01_JPRB,3.3572E-01_JPRB,3.1407E-01_JPRB,&
&3.5828E-01_JPRB,5.6212E-01_JPRB,6.0837E-01_JPRB/)
KAO( :, 1, 6,13) = (/&
&6.9473E-01_JPRB,6.0793E-01_JPRB,5.2119E-01_JPRB,4.3440E-01_JPRB,3.4764E-01_JPRB,2.6336E-01_JPRB,&
&1.8896E-01_JPRB,6.9473E-01_JPRB,1.7250E-01_JPRB/)
KAO( :, 2, 6,13) = (/&
&6.6721E-01_JPRB,5.8382E-01_JPRB,5.0053E-01_JPRB,4.1719E-01_JPRB,3.4561E-01_JPRB,2.7121E-01_JPRB,&
&1.9177E-01_JPRB,6.6721E-01_JPRB,2.4044E-01_JPRB/)
KAO( :, 3, 6,13) = (/&
&6.4000E-01_JPRB,5.6004E-01_JPRB,4.8024E-01_JPRB,4.1554E-01_JPRB,3.4402E-01_JPRB,2.7206E-01_JPRB,&
&2.0202E-01_JPRB,6.4000E-01_JPRB,3.3099E-01_JPRB/)
KAO( :, 4, 6,13) = (/&
&6.1394E-01_JPRB,5.3727E-01_JPRB,4.7423E-01_JPRB,4.0811E-01_JPRB,3.4656E-01_JPRB,2.7984E-01_JPRB,&
&2.2944E-01_JPRB,6.1394E-01_JPRB,4.4214E-01_JPRB/)
KAO( :, 5, 6,13) = (/&
&5.9084E-01_JPRB,5.1879E-01_JPRB,4.6252E-01_JPRB,4.0758E-01_JPRB,3.4602E-01_JPRB,2.8751E-01_JPRB,&
&3.0432E-01_JPRB,5.9084E-01_JPRB,5.7787E-01_JPRB/)
KAO( :, 1, 7,13) = (/&
&7.2249E-01_JPRB,6.3225E-01_JPRB,5.4192E-01_JPRB,4.5166E-01_JPRB,3.6141E-01_JPRB,2.7115E-01_JPRB,&
&1.8926E-01_JPRB,7.2249E-01_JPRB,1.4840E-01_JPRB/)
KAO( :, 2, 7,13) = (/&
&6.9569E-01_JPRB,6.0876E-01_JPRB,5.2183E-01_JPRB,4.3493E-01_JPRB,3.5253E-01_JPRB,2.7700E-01_JPRB,&
&1.9463E-01_JPRB,6.9569E-01_JPRB,2.1366E-01_JPRB/)
KAO( :, 3, 7,13) = (/&
&6.7030E-01_JPRB,5.8656E-01_JPRB,5.0282E-01_JPRB,4.3054E-01_JPRB,3.5472E-01_JPRB,2.7582E-01_JPRB,&
&2.0558E-01_JPRB,6.7030E-01_JPRB,3.0169E-01_JPRB/)
KAO( :, 4, 7,13) = (/&
&6.4750E-01_JPRB,5.6659E-01_JPRB,4.9555E-01_JPRB,4.2297E-01_JPRB,3.5382E-01_JPRB,2.8571E-01_JPRB,&
&2.1673E-01_JPRB,6.4750E-01_JPRB,4.1281E-01_JPRB/)
KAO( :, 5, 7,13) = (/&
&6.2512E-01_JPRB,5.4760E-01_JPRB,4.8374E-01_JPRB,4.2116E-01_JPRB,3.5619E-01_JPRB,2.8468E-01_JPRB,&
&2.6466E-01_JPRB,6.2512E-01_JPRB,5.4714E-01_JPRB/)
KAO( :, 1, 8,13) = (/&
&7.5294E-01_JPRB,6.5887E-01_JPRB,5.6474E-01_JPRB,4.7064E-01_JPRB,3.7654E-01_JPRB,2.8248E-01_JPRB,&
&1.8974E-01_JPRB,7.5294E-01_JPRB,1.2274E-01_JPRB/)
KAO( :, 2, 8,13) = (/&
&7.2891E-01_JPRB,6.3781E-01_JPRB,5.4671E-01_JPRB,4.5563E-01_JPRB,3.6498E-01_JPRB,2.8342E-01_JPRB,&
&1.9844E-01_JPRB,7.2891E-01_JPRB,1.8310E-01_JPRB/)
KAO( :, 3, 8,13) = (/&
&7.0557E-01_JPRB,6.1744E-01_JPRB,5.2928E-01_JPRB,4.4666E-01_JPRB,3.6716E-01_JPRB,2.8351E-01_JPRB,&
&2.0879E-01_JPRB,7.0557E-01_JPRB,2.6614E-01_JPRB/)
KAO( :, 4, 8,13) = (/&
&6.8244E-01_JPRB,5.9719E-01_JPRB,5.1867E-01_JPRB,4.4210E-01_JPRB,3.6383E-01_JPRB,2.9223E-01_JPRB,&
&2.1877E-01_JPRB,6.8244E-01_JPRB,3.7635E-01_JPRB/)
KAO( :, 5, 8,13) = (/&
&6.6089E-01_JPRB,5.7833E-01_JPRB,5.0944E-01_JPRB,4.4005E-01_JPRB,3.6857E-01_JPRB,2.9676E-01_JPRB,&
&2.4160E-01_JPRB,6.6089E-01_JPRB,5.0930E-01_JPRB/)
KAO( :, 1, 9,13) = (/&
&7.8582E-01_JPRB,6.8762E-01_JPRB,5.8934E-01_JPRB,4.9123E-01_JPRB,3.9298E-01_JPRB,2.9487E-01_JPRB,&
&1.9668E-01_JPRB,7.8582E-01_JPRB,9.8816E-02_JPRB/)
KAO( :, 2, 9,13) = (/&
&7.6340E-01_JPRB,6.6798E-01_JPRB,5.7260E-01_JPRB,4.7718E-01_JPRB,3.8186E-01_JPRB,2.8922E-01_JPRB,&
&2.0391E-01_JPRB,7.6340E-01_JPRB,1.5257E-01_JPRB/)
KAO( :, 3, 9,13) = (/&
&7.4083E-01_JPRB,6.4825E-01_JPRB,5.5561E-01_JPRB,4.6459E-01_JPRB,3.8180E-01_JPRB,2.9456E-01_JPRB,&
&2.1305E-01_JPRB,7.4083E-01_JPRB,2.2771E-01_JPRB/)
KAO( :, 4, 9,13) = (/&
&7.2071E-01_JPRB,6.3065E-01_JPRB,5.4414E-01_JPRB,4.6459E-01_JPRB,3.7956E-01_JPRB,3.0226E-01_JPRB,&
&2.2460E-01_JPRB,7.2071E-01_JPRB,3.3060E-01_JPRB/)
KAO( :, 5, 9,13) = (/&
&7.0101E-01_JPRB,6.1340E-01_JPRB,5.3848E-01_JPRB,4.5996E-01_JPRB,3.8516E-01_JPRB,3.1030E-01_JPRB,&
&2.3292E-01_JPRB,7.0101E-01_JPRB,4.5916E-01_JPRB/)
KAO( :, 1,10,13) = (/&
&8.1699E-01_JPRB,7.1490E-01_JPRB,6.1279E-01_JPRB,5.1070E-01_JPRB,4.0862E-01_JPRB,3.0651E-01_JPRB,&
&2.0447E-01_JPRB,8.1699E-01_JPRB,2.0223E-01_JPRB/)
KAO( :, 2,10,13) = (/&
&7.9680E-01_JPRB,6.9725E-01_JPRB,5.9768E-01_JPRB,4.9808E-01_JPRB,3.9857E-01_JPRB,2.9954E-01_JPRB,&
&2.1116E-01_JPRB,7.9680E-01_JPRB,2.1512E-01_JPRB/)
KAO( :, 3,10,13) = (/&
&7.7769E-01_JPRB,6.8054E-01_JPRB,5.8332E-01_JPRB,4.8646E-01_JPRB,3.9735E-01_JPRB,3.0638E-01_JPRB,&
&2.2182E-01_JPRB,7.7769E-01_JPRB,2.3973E-01_JPRB/)
KAO( :, 4,10,13) = (/&
&7.5760E-01_JPRB,6.6294E-01_JPRB,5.6993E-01_JPRB,4.8571E-01_JPRB,3.9617E-01_JPRB,3.1482E-01_JPRB,&
&2.3294E-01_JPRB,7.5760E-01_JPRB,3.0285E-01_JPRB/)
KAO( :, 5,10,13) = (/&
&7.3618E-01_JPRB,6.4414E-01_JPRB,5.6442E-01_JPRB,4.8052E-01_JPRB,4.0378E-01_JPRB,3.2545E-01_JPRB,&
&2.3666E-01_JPRB,7.3618E-01_JPRB,4.1601E-01_JPRB/)
KAO( :, 1,11,13) = (/&
&8.3942E-01_JPRB,7.3450E-01_JPRB,6.2963E-01_JPRB,5.2471E-01_JPRB,4.1987E-01_JPRB,3.1499E-01_JPRB,&
&2.1173E-01_JPRB,8.3942E-01_JPRB,5.1704E-01_JPRB/)
KAO( :, 2,11,13) = (/&
&8.2051E-01_JPRB,7.1798E-01_JPRB,6.1544E-01_JPRB,5.1289E-01_JPRB,4.1041E-01_JPRB,3.1180E-01_JPRB,&
&2.2477E-01_JPRB,8.2051E-01_JPRB,5.0715E-01_JPRB/)
KAO( :, 3,11,13) = (/&
&8.0104E-01_JPRB,7.0099E-01_JPRB,6.0089E-01_JPRB,5.0362E-01_JPRB,4.1222E-01_JPRB,3.2198E-01_JPRB,&
&2.3377E-01_JPRB,8.0104E-01_JPRB,5.0602E-01_JPRB/)
KAO( :, 4,11,13) = (/&
&7.7897E-01_JPRB,6.8168E-01_JPRB,5.9030E-01_JPRB,5.0190E-01_JPRB,4.1316E-01_JPRB,3.3484E-01_JPRB,&
&2.4521E-01_JPRB,7.7897E-01_JPRB,5.2719E-01_JPRB/)
KAO( :, 5,11,13) = (/&
&7.5657E-01_JPRB,6.6294E-01_JPRB,5.8168E-01_JPRB,4.9940E-01_JPRB,4.2397E-01_JPRB,3.4229E-01_JPRB,&
&2.5422E-01_JPRB,7.5657E-01_JPRB,5.6893E-01_JPRB/)
KAO( :, 1,12,13) = (/&
&8.6084E-01_JPRB,7.5332E-01_JPRB,6.4569E-01_JPRB,5.3811E-01_JPRB,4.3054E-01_JPRB,3.2302E-01_JPRB,&
&2.2089E-01_JPRB,8.6084E-01_JPRB,8.5915E-01_JPRB/)
KAO( :, 2,12,13) = (/&
&8.4383E-01_JPRB,7.3849E-01_JPRB,6.3296E-01_JPRB,5.2757E-01_JPRB,4.2272E-01_JPRB,3.2652E-01_JPRB,&
&2.3662E-01_JPRB,8.4383E-01_JPRB,8.4258E-01_JPRB/)
KAO( :, 3,12,13) = (/&
&8.2461E-01_JPRB,7.2162E-01_JPRB,6.1861E-01_JPRB,5.2173E-01_JPRB,4.2609E-01_JPRB,3.3651E-01_JPRB,&
&2.4602E-01_JPRB,8.2461E-01_JPRB,8.2424E-01_JPRB/)
KAO( :, 4,12,13) = (/&
&8.0362E-01_JPRB,7.0330E-01_JPRB,6.1076E-01_JPRB,5.1642E-01_JPRB,4.3196E-01_JPRB,3.5024E-01_JPRB,&
&2.5788E-01_JPRB,8.0362E-01_JPRB,8.1526E-01_JPRB/)
KAO( :, 5,12,13) = (/&
&7.8196E-01_JPRB,6.8686E-01_JPRB,5.9993E-01_JPRB,5.1915E-01_JPRB,4.4219E-01_JPRB,3.5857E-01_JPRB,&
&2.8318E-01_JPRB,7.8196E-01_JPRB,8.4417E-01_JPRB/)
KAO( :, 1,13,13) = (/&
&8.9885E-01_JPRB,7.8652E-01_JPRB,6.7417E-01_JPRB,5.6190E-01_JPRB,4.4957E-01_JPRB,3.3736E-01_JPRB,&
&2.3468E-01_JPRB,8.9885E-01_JPRB,1.1747E+00_JPRB/)
KAO( :, 2,13,13) = (/&
&8.8176E-01_JPRB,7.7157E-01_JPRB,6.6138E-01_JPRB,5.5126E-01_JPRB,4.4334E-01_JPRB,3.4503E-01_JPRB,&
&2.4591E-01_JPRB,8.8176E-01_JPRB,1.1474E+00_JPRB/)
KAO( :, 3,13,13) = (/&
&8.6445E-01_JPRB,7.5644E-01_JPRB,6.4871E-01_JPRB,5.4797E-01_JPRB,4.4798E-01_JPRB,3.5260E-01_JPRB,&
&2.5729E-01_JPRB,8.6445E-01_JPRB,1.1167E+00_JPRB/)
KAO( :, 4,13,13) = (/&
&8.4531E-01_JPRB,7.3968E-01_JPRB,6.4228E-01_JPRB,5.4288E-01_JPRB,4.5703E-01_JPRB,3.6588E-01_JPRB,&
&2.7546E-01_JPRB,8.4531E-01_JPRB,1.0937E+00_JPRB/)
KAO( :, 5,13,13) = (/&
&8.2636E-01_JPRB,7.2791E-01_JPRB,6.3427E-01_JPRB,5.5035E-01_JPRB,4.6456E-01_JPRB,3.8210E-01_JPRB,&
&3.1914E-01_JPRB,8.2636E-01_JPRB,1.1091E+00_JPRB/)
KAO( :, 1, 1,14) = (/&
&6.4697E-01_JPRB,5.6581E-01_JPRB,4.8619E-01_JPRB,4.0514E-01_JPRB,3.2628E-01_JPRB,2.6560E-01_JPRB,&
&2.6000E-01_JPRB,6.4697E-01_JPRB,5.4302E-01_JPRB/)
KAO( :, 2, 1,14) = (/&
&6.1615E-01_JPRB,5.3934E-01_JPRB,4.6216E-01_JPRB,3.9067E-01_JPRB,3.3456E-01_JPRB,3.3408E-01_JPRB,&
&3.5677E-01_JPRB,6.1615E-01_JPRB,7.5638E-01_JPRB/)
KAO( :, 3, 1,14) = (/&
&5.8533E-01_JPRB,5.1238E-01_JPRB,4.4004E-01_JPRB,3.8617E-01_JPRB,3.9537E-01_JPRB,4.4466E-01_JPRB,&
&4.7278E-01_JPRB,5.8533E-01_JPRB,1.0166E+00_JPRB/)
KAO( :, 4, 1,14) = (/&
&5.5669E-01_JPRB,4.8735E-01_JPRB,4.2781E-01_JPRB,4.2678E-01_JPRB,5.1253E-01_JPRB,5.7332E-01_JPRB,&
&6.0788E-01_JPRB,5.5669E-01_JPRB,1.3240E+00_JPRB/)
KAO( :, 5, 1,14) = (/&
&5.2879E-01_JPRB,4.6247E-01_JPRB,4.2802E-01_JPRB,5.3254E-01_JPRB,6.4936E-01_JPRB,7.2566E-01_JPRB,&
&7.6206E-01_JPRB,5.2879E-01_JPRB,1.6773E+00_JPRB/)
KAO( :, 1, 2,14) = (/&
&6.8303E-01_JPRB,5.9781E-01_JPRB,5.1220E-01_JPRB,4.2706E-01_JPRB,3.4379E-01_JPRB,2.7382E-01_JPRB,&
&2.5162E-01_JPRB,6.8303E-01_JPRB,5.1036E-01_JPRB/)
KAO( :, 2, 2,14) = (/&
&6.4954E-01_JPRB,5.6917E-01_JPRB,4.8810E-01_JPRB,4.1304E-01_JPRB,3.4632E-01_JPRB,3.2639E-01_JPRB,&
&3.5170E-01_JPRB,6.4954E-01_JPRB,7.2343E-01_JPRB/)
KAO( :, 3, 2,14) = (/&
&6.1641E-01_JPRB,5.3958E-01_JPRB,4.6497E-01_JPRB,4.0263E-01_JPRB,3.9007E-01_JPRB,4.3907E-01_JPRB,&
&4.7004E-01_JPRB,6.1641E-01_JPRB,9.8553E-01_JPRB/)
KAO( :, 4, 2,14) = (/&
&5.8470E-01_JPRB,5.1185E-01_JPRB,4.4927E-01_JPRB,4.3064E-01_JPRB,5.0846E-01_JPRB,5.7765E-01_JPRB,&
&6.1669E-01_JPRB,5.8470E-01_JPRB,1.2985E+00_JPRB/)
KAO( :, 5, 2,14) = (/&
&5.5467E-01_JPRB,4.8565E-01_JPRB,4.4367E-01_JPRB,5.2819E-01_JPRB,6.4947E-01_JPRB,7.3873E-01_JPRB,&
&7.8515E-01_JPRB,5.5467E-01_JPRB,1.6649E+00_JPRB/)
KAO( :, 1, 3,14) = (/&
&7.2604E-01_JPRB,6.3550E-01_JPRB,5.4494E-01_JPRB,4.5437E-01_JPRB,3.6385E-01_JPRB,2.8334E-01_JPRB,&
&2.2702E-01_JPRB,7.2604E-01_JPRB,4.3950E-01_JPRB/)
KAO( :, 2, 3,14) = (/&
&6.8954E-01_JPRB,6.0362E-01_JPRB,5.1760E-01_JPRB,4.3356E-01_JPRB,3.5873E-01_JPRB,3.0878E-01_JPRB,&
&3.1582E-01_JPRB,6.8954E-01_JPRB,6.3380E-01_JPRB/)
KAO( :, 3, 3,14) = (/&
&6.5385E-01_JPRB,5.7238E-01_JPRB,4.9126E-01_JPRB,4.2254E-01_JPRB,3.7557E-01_JPRB,4.0304E-01_JPRB,&
&4.3683E-01_JPRB,6.5385E-01_JPRB,8.8264E-01_JPRB/)
KAO( :, 4, 3,14) = (/&
&6.1901E-01_JPRB,5.4191E-01_JPRB,4.7603E-01_JPRB,4.2566E-01_JPRB,4.6990E-01_JPRB,5.3966E-01_JPRB,&
&5.8392E-01_JPRB,6.1901E-01_JPRB,1.1869E+00_JPRB/)
KAO( :, 5, 3,14) = (/&
&5.8653E-01_JPRB,5.1354E-01_JPRB,4.5882E-01_JPRB,4.9733E-01_JPRB,6.1274E-01_JPRB,7.0260E-01_JPRB,&
&7.5851E-01_JPRB,5.8653E-01_JPRB,1.5549E+00_JPRB/)
KAO( :, 1, 4,14) = (/&
&7.7382E-01_JPRB,6.7722E-01_JPRB,5.8077E-01_JPRB,4.8422E-01_JPRB,3.8766E-01_JPRB,2.9794E-01_JPRB,&
&2.1506E-01_JPRB,7.7382E-01_JPRB,3.8561E-01_JPRB/)
KAO( :, 2, 4,14) = (/&
&7.3238E-01_JPRB,6.4104E-01_JPRB,5.4969E-01_JPRB,4.5833E-01_JPRB,3.7818E-01_JPRB,3.0063E-01_JPRB,&
&2.7269E-01_JPRB,7.3238E-01_JPRB,5.4567E-01_JPRB/)
KAO( :, 3, 4,14) = (/&
&6.9409E-01_JPRB,6.0760E-01_JPRB,5.2105E-01_JPRB,4.4727E-01_JPRB,3.7346E-01_JPRB,3.5556E-01_JPRB,&
&3.8970E-01_JPRB,6.9409E-01_JPRB,7.5575E-01_JPRB/)
KAO( :, 4, 4,14) = (/&
&6.5680E-01_JPRB,5.7500E-01_JPRB,5.0421E-01_JPRB,4.3210E-01_JPRB,4.2750E-01_JPRB,4.8792E-01_JPRB,&
&5.3313E-01_JPRB,6.5680E-01_JPRB,1.0436E+00_JPRB/)
KAO( :, 5, 4,14) = (/&
&6.2089E-01_JPRB,5.4362E-01_JPRB,4.8130E-01_JPRB,4.7140E-01_JPRB,5.6311E-01_JPRB,6.4743E-01_JPRB,&
&7.0793E-01_JPRB,6.2089E-01_JPRB,1.3960E+00_JPRB/)
KAO( :, 1, 5,14) = (/&
&8.2229E-01_JPRB,7.1962E-01_JPRB,6.1700E-01_JPRB,5.1439E-01_JPRB,4.1134E-01_JPRB,3.0886E-01_JPRB,&
&2.1652E-01_JPRB,8.2229E-01_JPRB,3.4617E-01_JPRB/)
KAO( :, 2, 5,14) = (/&
&7.7737E-01_JPRB,6.8035E-01_JPRB,5.8334E-01_JPRB,4.8633E-01_JPRB,3.9777E-01_JPRB,3.0668E-01_JPRB,&
&2.4242E-01_JPRB,7.7737E-01_JPRB,4.8134E-01_JPRB/)
KAO( :, 3, 5,14) = (/&
&7.3545E-01_JPRB,6.4364E-01_JPRB,5.5194E-01_JPRB,4.7124E-01_JPRB,3.8457E-01_JPRB,3.2665E-01_JPRB,&
&3.3917E-01_JPRB,7.3545E-01_JPRB,6.5879E-01_JPRB/)
KAO( :, 4, 5,14) = (/&
&6.9572E-01_JPRB,6.0902E-01_JPRB,5.3204E-01_JPRB,4.5117E-01_JPRB,4.0273E-01_JPRB,4.3738E-01_JPRB,&
&4.7818E-01_JPRB,6.9572E-01_JPRB,9.0069E-01_JPRB/)
KAO( :, 5, 5,14) = (/&
&6.5745E-01_JPRB,5.7553E-01_JPRB,5.0705E-01_JPRB,4.6147E-01_JPRB,5.1159E-01_JPRB,5.9239E-01_JPRB,&
&6.4809E-01_JPRB,6.5745E-01_JPRB,1.2234E+00_JPRB/)
KAO( :, 1, 6,14) = (/&
&8.7308E-01_JPRB,7.6408E-01_JPRB,6.5505E-01_JPRB,5.4604E-01_JPRB,4.3705E-01_JPRB,3.2789E-01_JPRB,&
&2.2557E-01_JPRB,8.7308E-01_JPRB,2.9961E-01_JPRB/)
KAO( :, 2, 6,14) = (/&
&8.2540E-01_JPRB,7.2233E-01_JPRB,6.1930E-01_JPRB,5.1628E-01_JPRB,4.1422E-01_JPRB,3.2146E-01_JPRB,&
&2.2994E-01_JPRB,8.2540E-01_JPRB,4.2262E-01_JPRB/)
KAO( :, 3, 6,14) = (/&
&7.7924E-01_JPRB,6.8203E-01_JPRB,5.8479E-01_JPRB,4.9474E-01_JPRB,4.0395E-01_JPRB,3.1715E-01_JPRB,&
&2.8904E-01_JPRB,7.7924E-01_JPRB,5.7314E-01_JPRB/)
KAO( :, 4, 6,14) = (/&
&7.3709E-01_JPRB,6.4513E-01_JPRB,5.5979E-01_JPRB,4.7521E-01_JPRB,3.9636E-01_JPRB,3.8185E-01_JPRB,&
&4.1862E-01_JPRB,7.3709E-01_JPRB,7.8091E-01_JPRB/)
KAO( :, 5, 6,14) = (/&
&6.9621E-01_JPRB,6.0938E-01_JPRB,5.3478E-01_JPRB,4.6425E-01_JPRB,4.6297E-01_JPRB,5.2802E-01_JPRB,&
&5.8170E-01_JPRB,6.9621E-01_JPRB,1.0527E+00_JPRB/)
KAO( :, 1, 7,14) = (/&
&9.2395E-01_JPRB,8.0850E-01_JPRB,6.9306E-01_JPRB,5.7769E-01_JPRB,4.6224E-01_JPRB,3.4691E-01_JPRB,&
&2.3084E-01_JPRB,9.2395E-01_JPRB,2.5497E-01_JPRB/)
KAO( :, 2, 7,14) = (/&
&8.7317E-01_JPRB,7.6415E-01_JPRB,6.5513E-01_JPRB,5.4606E-01_JPRB,4.3714E-01_JPRB,3.3528E-01_JPRB,&
&2.3202E-01_JPRB,8.7317E-01_JPRB,3.7202E-01_JPRB/)
KAO( :, 3, 7,14) = (/&
&8.2438E-01_JPRB,7.2141E-01_JPRB,6.1853E-01_JPRB,5.1767E-01_JPRB,4.2475E-01_JPRB,3.2596E-01_JPRB,&
&2.5061E-01_JPRB,8.2438E-01_JPRB,5.0761E-01_JPRB/)
KAO( :, 4, 7,14) = (/&
&7.7804E-01_JPRB,6.8094E-01_JPRB,5.8814E-01_JPRB,5.0039E-01_JPRB,4.0791E-01_JPRB,3.4702E-01_JPRB,&
&3.6090E-01_JPRB,7.7804E-01_JPRB,6.8063E-01_JPRB/)
KAO( :, 5, 7,14) = (/&
&7.3636E-01_JPRB,6.4448E-01_JPRB,5.6430E-01_JPRB,4.8129E-01_JPRB,4.3569E-01_JPRB,4.6156E-01_JPRB,&
&5.1425E-01_JPRB,7.3636E-01_JPRB,9.1422E-01_JPRB/)
KAO( :, 1, 8,14) = (/&
&9.7397E-01_JPRB,8.5236E-01_JPRB,7.3070E-01_JPRB,6.0905E-01_JPRB,4.8737E-01_JPRB,3.6576E-01_JPRB,&
&2.4401E-01_JPRB,9.7397E-01_JPRB,2.1663E-01_JPRB/)
KAO( :, 2, 8,14) = (/&
&9.2100E-01_JPRB,8.0595E-01_JPRB,6.9096E-01_JPRB,5.7592E-01_JPRB,4.6092E-01_JPRB,3.4695E-01_JPRB,&
&2.4168E-01_JPRB,9.2100E-01_JPRB,3.2348E-01_JPRB/)
KAO( :, 3, 8,14) = (/&
&8.7221E-01_JPRB,7.6329E-01_JPRB,6.5435E-01_JPRB,5.4550E-01_JPRB,4.4631E-01_JPRB,3.4181E-01_JPRB,&
&2.3826E-01_JPRB,8.7221E-01_JPRB,4.5837E-01_JPRB/)
KAO( :, 4, 8,14) = (/&
&8.2606E-01_JPRB,7.2291E-01_JPRB,6.2015E-01_JPRB,5.2779E-01_JPRB,4.2860E-01_JPRB,3.3690E-01_JPRB,&
&3.1094E-01_JPRB,8.2606E-01_JPRB,6.1646E-01_JPRB/)
KAO( :, 5, 8,14) = (/&
&7.8339E-01_JPRB,6.8563E-01_JPRB,5.9715E-01_JPRB,5.0560E-01_JPRB,4.2904E-01_JPRB,4.0836E-01_JPRB,&
&4.4759E-01_JPRB,7.8339E-01_JPRB,8.2068E-01_JPRB/)
KAO( :, 1, 9,14) = (/&
&1.0301E+00_JPRB,9.0147E-01_JPRB,7.7271E-01_JPRB,6.4407E-01_JPRB,5.1534E-01_JPRB,3.8666E-01_JPRB,&
&2.5795E-01_JPRB,1.0301E+00_JPRB,1.8238E-01_JPRB/)
KAO( :, 2, 9,14) = (/&
&9.7820E-01_JPRB,8.5599E-01_JPRB,7.3388E-01_JPRB,6.1168E-01_JPRB,4.8943E-01_JPRB,3.6719E-01_JPRB,&
&2.5130E-01_JPRB,9.7820E-01_JPRB,2.7990E-01_JPRB/)
KAO( :, 3, 9,14) = (/&
&9.2786E-01_JPRB,8.1203E-01_JPRB,6.9612E-01_JPRB,5.8026E-01_JPRB,4.6878E-01_JPRB,3.5884E-01_JPRB,&
&2.4589E-01_JPRB,9.2786E-01_JPRB,4.0829E-01_JPRB/)
KAO( :, 4, 9,14) = (/&
&8.8063E-01_JPRB,7.7081E-01_JPRB,6.6089E-01_JPRB,5.5869E-01_JPRB,4.5326E-01_JPRB,3.4687E-01_JPRB,&
&2.8154E-01_JPRB,8.8063E-01_JPRB,5.6423E-01_JPRB/)
KAO( :, 5, 9,14) = (/&
&8.3750E-01_JPRB,7.3300E-01_JPRB,6.3612E-01_JPRB,5.3674E-01_JPRB,4.4242E-01_JPRB,3.8121E-01_JPRB,&
&3.9514E-01_JPRB,8.3750E-01_JPRB,7.6101E-01_JPRB/)
KAO( :, 1,10,14) = (/&
&1.0910E+00_JPRB,9.5477E-01_JPRB,8.1845E-01_JPRB,6.8213E-01_JPRB,5.4582E-01_JPRB,4.0946E-01_JPRB,&
&2.7317E-01_JPRB,1.0910E+00_JPRB,2.4894E-01_JPRB/)
KAO( :, 2,10,14) = (/&
&1.0359E+00_JPRB,9.0651E-01_JPRB,7.7708E-01_JPRB,6.4767E-01_JPRB,5.1833E-01_JPRB,3.8894E-01_JPRB,&
&2.6039E-01_JPRB,1.0359E+00_JPRB,2.7831E-01_JPRB/)
KAO( :, 3,10,14) = (/&
&9.8652E-01_JPRB,8.6341E-01_JPRB,7.4018E-01_JPRB,6.1698E-01_JPRB,4.9398E-01_JPRB,3.7879E-01_JPRB,&
&2.6008E-01_JPRB,9.8652E-01_JPRB,3.7798E-01_JPRB/)
KAO( :, 4,10,14) = (/&
&9.4211E-01_JPRB,8.2452E-01_JPRB,7.0695E-01_JPRB,5.9553E-01_JPRB,4.8274E-01_JPRB,3.6793E-01_JPRB,&
&2.7883E-01_JPRB,9.4211E-01_JPRB,5.3013E-01_JPRB/)
KAO( :, 5,10,14) = (/&
&9.0248E-01_JPRB,7.8992E-01_JPRB,6.8355E-01_JPRB,5.7648E-01_JPRB,4.7251E-01_JPRB,3.8441E-01_JPRB,&
&3.6799E-01_JPRB,9.0248E-01_JPRB,7.2595E-01_JPRB/)
KAO( :, 1,11,14) = (/&
&1.1319E+00_JPRB,9.9048E-01_JPRB,8.4899E-01_JPRB,7.0760E-01_JPRB,5.6613E-01_JPRB,4.2478E-01_JPRB,&
&2.8341E-01_JPRB,1.1319E+00_JPRB,6.1592E-01_JPRB/)
KAO( :, 2,11,14) = (/&
&1.0823E+00_JPRB,9.4725E-01_JPRB,8.1199E-01_JPRB,6.7675E-01_JPRB,5.4154E-01_JPRB,4.0630E-01_JPRB,&
&2.7609E-01_JPRB,1.0823E+00_JPRB,6.1773E-01_JPRB/)
KAO( :, 3,11,14) = (/&
&1.0367E+00_JPRB,9.0731E-01_JPRB,7.7783E-01_JPRB,6.4834E-01_JPRB,5.2311E-01_JPRB,3.9934E-01_JPRB,&
&2.8089E-01_JPRB,1.0367E+00_JPRB,6.2937E-01_JPRB/)
KAO( :, 4,11,14) = (/&
&9.9754E-01_JPRB,8.7303E-01_JPRB,7.4854E-01_JPRB,6.3329E-01_JPRB,5.1385E-01_JPRB,3.9730E-01_JPRB,&
&3.1217E-01_JPRB,9.9754E-01_JPRB,6.7492E-01_JPRB/)
KAO( :, 5,11,14) = (/&
&9.6377E-01_JPRB,8.4344E-01_JPRB,7.3462E-01_JPRB,6.2175E-01_JPRB,5.1718E-01_JPRB,4.2421E-01_JPRB,&
&3.9708E-01_JPRB,9.6377E-01_JPRB,8.2165E-01_JPRB/)
KAO( :, 1,12,14) = (/&
&1.1865E+00_JPRB,1.0383E+00_JPRB,8.9009E-01_JPRB,7.4185E-01_JPRB,5.9361E-01_JPRB,4.4539E-01_JPRB,&
&2.9703E-01_JPRB,1.1865E+00_JPRB,1.0367E+00_JPRB/)
KAO( :, 2,12,14) = (/&
&1.1417E+00_JPRB,9.9913E-01_JPRB,8.5647E-01_JPRB,7.1379E-01_JPRB,5.7124E-01_JPRB,4.2863E-01_JPRB,&
&2.9688E-01_JPRB,1.1417E+00_JPRB,1.0233E+00_JPRB/)
KAO( :, 3,12,14) = (/&
&1.1032E+00_JPRB,9.6547E-01_JPRB,8.2760E-01_JPRB,6.8985E-01_JPRB,5.6085E-01_JPRB,4.2892E-01_JPRB,&
&3.0866E-01_JPRB,1.1032E+00_JPRB,1.0143E+00_JPRB/)
KAO( :, 4,12,14) = (/&
&1.0706E+00_JPRB,9.3688E-01_JPRB,8.0548E-01_JPRB,6.8453E-01_JPRB,5.5710E-01_JPRB,4.4460E-01_JPRB,&
&3.4889E-01_JPRB,1.0706E+00_JPRB,1.0266E+00_JPRB/)
KAO( :, 5,12,14) = (/&
&1.0446E+00_JPRB,9.1422E-01_JPRB,8.0059E-01_JPRB,6.8230E-01_JPRB,5.7500E-01_JPRB,4.7448E-01_JPRB,&
&4.2513E-01_JPRB,1.0446E+00_JPRB,1.0801E+00_JPRB/)
KAO( :, 1,13,14) = (/&
&1.2550E+00_JPRB,1.0982E+00_JPRB,9.4143E-01_JPRB,7.8461E-01_JPRB,6.2776E-01_JPRB,4.7103E-01_JPRB,&
&3.1423E-01_JPRB,1.2550E+00_JPRB,1.4399E+00_JPRB/)
KAO( :, 2,13,14) = (/&
&1.2174E+00_JPRB,1.0653E+00_JPRB,9.1318E-01_JPRB,7.6114E-01_JPRB,6.0904E-01_JPRB,4.6025E-01_JPRB,&
&3.2716E-01_JPRB,1.2174E+00_JPRB,1.4068E+00_JPRB/)
KAO( :, 3,13,14) = (/&
&1.1864E+00_JPRB,1.0381E+00_JPRB,8.9001E-01_JPRB,7.4479E-01_JPRB,6.0816E-01_JPRB,4.7143E-01_JPRB,&
&3.4454E-01_JPRB,1.1864E+00_JPRB,1.3882E+00_JPRB/)
KAO( :, 4,13,14) = (/&
&1.1616E+00_JPRB,1.0165E+00_JPRB,8.7886E-01_JPRB,7.4766E-01_JPRB,6.1245E-01_JPRB,5.0020E-01_JPRB,&
&3.8828E-01_JPRB,1.1616E+00_JPRB,1.3917E+00_JPRB/)
KAO( :, 5,13,14) = (/&
&1.1397E+00_JPRB,9.9781E-01_JPRB,8.7736E-01_JPRB,7.5469E-01_JPRB,6.4460E-01_JPRB,5.3210E-01_JPRB,&
&4.5910E-01_JPRB,1.1397E+00_JPRB,1.4042E+00_JPRB/)
KAO( :, 1, 1,15) = (/&
&6.7013E-01_JPRB,5.8657E-01_JPRB,5.0312E-01_JPRB,4.1845E-01_JPRB,3.3604E-01_JPRB,3.2447E-01_JPRB,&
&3.1596E-01_JPRB,6.7013E-01_JPRB,1.0209E+00_JPRB/)
KAO( :, 2, 1,15) = (/&
&6.3713E-01_JPRB,5.5910E-01_JPRB,4.7959E-01_JPRB,4.0042E-01_JPRB,4.3246E-01_JPRB,4.5455E-01_JPRB,&
&4.4491E-01_JPRB,6.3714E-01_JPRB,1.4151E+00_JPRB/)
KAO( :, 3, 1,15) = (/&
&6.0413E-01_JPRB,5.2881E-01_JPRB,4.5365E-01_JPRB,5.1141E-01_JPRB,5.7932E-01_JPRB,6.0400E-01_JPRB,&
&5.9194E-01_JPRB,6.0413E-01_JPRB,1.8935E+00_JPRB/)
KAO( :, 4, 1,15) = (/&
&5.7379E-01_JPRB,5.0236E-01_JPRB,5.0998E-01_JPRB,6.6283E-01_JPRB,7.5577E-01_JPRB,7.9134E-01_JPRB,&
&7.7383E-01_JPRB,5.7379E-01_JPRB,2.4386E+00_JPRB/)
KAO( :, 5, 1,15) = (/&
&5.4412E-01_JPRB,4.7644E-01_JPRB,6.4179E-01_JPRB,8.3374E-01_JPRB,9.4901E-01_JPRB,9.9647E-01_JPRB,&
&9.6829E-01_JPRB,5.4412E-01_JPRB,3.0668E+00_JPRB/)
KAO( :, 1, 2,15) = (/&
&7.1168E-01_JPRB,6.2291E-01_JPRB,5.3428E-01_JPRB,4.4560E-01_JPRB,3.5787E-01_JPRB,3.3695E-01_JPRB,&
&3.3151E-01_JPRB,7.1168E-01_JPRB,1.0408E+00_JPRB/)
KAO( :, 2, 2,15) = (/&
&6.7551E-01_JPRB,5.8980E-01_JPRB,5.0589E-01_JPRB,4.2379E-01_JPRB,4.5484E-01_JPRB,4.7493E-01_JPRB,&
&4.6615E-01_JPRB,6.7551E-01_JPRB,1.4628E+00_JPRB/)
KAO( :, 3, 2,15) = (/&
&6.3979E-01_JPRB,5.6002E-01_JPRB,4.8033E-01_JPRB,5.3992E-01_JPRB,6.1725E-01_JPRB,6.4789E-01_JPRB,&
&6.3640E-01_JPRB,6.3979E-01_JPRB,1.9740E+00_JPRB/)
KAO( :, 4, 2,15) = (/&
&6.0574E-01_JPRB,5.3026E-01_JPRB,5.4102E-01_JPRB,7.0781E-01_JPRB,8.0810E-01_JPRB,8.5154E-01_JPRB,&
&8.3777E-01_JPRB,6.0574E-01_JPRB,2.5770E+00_JPRB/)
KAO( :, 5, 2,15) = (/&
&5.7367E-01_JPRB,5.0230E-01_JPRB,6.8564E-01_JPRB,8.9765E-01_JPRB,1.0319E+00_JPRB,1.0843E+00_JPRB,&
&1.0692E+00_JPRB,5.7367E-01_JPRB,3.2665E+00_JPRB/)
KAO( :, 1, 3,15) = (/&
&7.6206E-01_JPRB,6.6694E-01_JPRB,5.7209E-01_JPRB,4.7696E-01_JPRB,3.8092E-01_JPRB,3.2070E-01_JPRB,&
&3.1660E-01_JPRB,7.6206E-01_JPRB,9.6051E-01_JPRB/)
KAO( :, 2, 3,15) = (/&
&7.2225E-01_JPRB,6.3222E-01_JPRB,5.4222E-01_JPRB,4.5212E-01_JPRB,4.4022E-01_JPRB,4.6467E-01_JPRB,&
&4.5854E-01_JPRB,7.2225E-01_JPRB,1.3827E+00_JPRB/)
KAO( :, 3, 3,15) = (/&
&6.8319E-01_JPRB,5.9821E-01_JPRB,5.1315E-01_JPRB,5.2942E-01_JPRB,6.1251E-01_JPRB,6.4502E-01_JPRB,&
&6.3732E-01_JPRB,6.8319E-01_JPRB,1.9060E+00_JPRB/)
KAO( :, 4, 3,15) = (/&
&6.4520E-01_JPRB,5.6501E-01_JPRB,5.4637E-01_JPRB,7.0565E-01_JPRB,8.1836E-01_JPRB,8.6755E-01_JPRB,&
&8.5856E-01_JPRB,6.4520E-01_JPRB,2.5416E+00_JPRB/)
KAO( :, 5, 3,15) = (/&
&6.1032E-01_JPRB,5.3440E-01_JPRB,6.8762E-01_JPRB,9.1192E-01_JPRB,1.0544E+00_JPRB,1.1220E+00_JPRB,&
&1.1118E+00_JPRB,6.1032E-01_JPRB,3.2899E+00_JPRB/)
KAO( :, 1, 4,15) = (/&
&8.1880E-01_JPRB,7.1671E-01_JPRB,6.1469E-01_JPRB,5.1259E-01_JPRB,4.1035E-01_JPRB,3.0900E-01_JPRB,&
&2.8774E-01_JPRB,8.1880E-01_JPRB,8.3214E-01_JPRB/)
KAO( :, 2, 4,15) = (/&
&7.7244E-01_JPRB,6.7627E-01_JPRB,5.8000E-01_JPRB,4.8371E-01_JPRB,4.1707E-01_JPRB,4.3611E-01_JPRB,&
&4.3242E-01_JPRB,7.7244E-01_JPRB,1.2349E+00_JPRB/)
KAO( :, 3, 4,15) = (/&
&7.3041E-01_JPRB,6.3939E-01_JPRB,5.4855E-01_JPRB,5.1182E-01_JPRB,5.8284E-01_JPRB,6.2247E-01_JPRB,&
&6.1822E-01_JPRB,7.3041E-01_JPRB,1.7591E+00_JPRB/)
KAO( :, 4, 4,15) = (/&
&6.8937E-01_JPRB,6.0366E-01_JPRB,5.5228E-01_JPRB,6.8053E-01_JPRB,7.9580E-01_JPRB,8.4999E-01_JPRB,&
&8.5210E-01_JPRB,6.8937E-01_JPRB,2.4071E+00_JPRB/)
KAO( :, 5, 4,15) = (/&
&6.5021E-01_JPRB,5.6936E-01_JPRB,6.6656E-01_JPRB,8.9418E-01_JPRB,1.0485E+00_JPRB,1.1290E+00_JPRB,&
&1.1228E+00_JPRB,6.5021E-01_JPRB,3.1879E+00_JPRB/)
KAO( :, 1, 5,15) = (/&
&8.7693E-01_JPRB,7.6771E-01_JPRB,6.5835E-01_JPRB,5.4884E-01_JPRB,4.4068E-01_JPRB,3.3005E-01_JPRB,&
&2.5822E-01_JPRB,8.7693E-01_JPRB,6.9752E-01_JPRB/)
KAO( :, 2, 5,15) = (/&
&8.2534E-01_JPRB,7.2250E-01_JPRB,6.1982E-01_JPRB,5.1679E-01_JPRB,4.1772E-01_JPRB,4.0063E-01_JPRB,&
&4.0196E-01_JPRB,8.2534E-01_JPRB,1.0779E+00_JPRB/)
KAO( :, 3, 5,15) = (/&
&7.7811E-01_JPRB,6.8129E-01_JPRB,5.8442E-01_JPRB,5.0960E-01_JPRB,5.4382E-01_JPRB,5.8808E-01_JPRB,&
&5.9145E-01_JPRB,7.7811E-01_JPRB,1.5826E+00_JPRB/)
KAO( :, 4, 5,15) = (/&
&7.3361E-01_JPRB,6.4251E-01_JPRB,5.6661E-01_JPRB,6.4134E-01_JPRB,7.5938E-01_JPRB,8.2208E-01_JPRB,&
&8.2942E-01_JPRB,7.3361E-01_JPRB,2.2230E+00_JPRB/)
KAO( :, 5, 5,15) = (/&
&6.9110E-01_JPRB,6.0518E-01_JPRB,6.5033E-01_JPRB,8.5838E-01_JPRB,1.0195E+00_JPRB,1.1130E+00_JPRB,&
&1.1201E+00_JPRB,6.9110E-01_JPRB,3.0082E+00_JPRB/)
KAO( :, 1, 6,15) = (/&
&9.3756E-01_JPRB,8.2068E-01_JPRB,7.0383E-01_JPRB,5.8672E-01_JPRB,4.6972E-01_JPRB,3.5270E-01_JPRB,&
&2.3642E-01_JPRB,9.3756E-01_JPRB,5.8692E-01_JPRB/)
KAO( :, 2, 6,15) = (/&
&8.8146E-01_JPRB,7.7172E-01_JPRB,6.6172E-01_JPRB,5.5196E-01_JPRB,4.4195E-01_JPRB,3.6409E-01_JPRB,&
&3.5917E-01_JPRB,8.8146E-01_JPRB,9.0877E-01_JPRB/)
KAO( :, 3, 6,15) = (/&
&8.2746E-01_JPRB,7.2459E-01_JPRB,6.2157E-01_JPRB,5.2255E-01_JPRB,4.9923E-01_JPRB,5.3612E-01_JPRB,&
&5.4635E-01_JPRB,8.2746E-01_JPRB,1.3807E+00_JPRB/)
KAO( :, 4, 6,15) = (/&
&7.7986E-01_JPRB,6.8286E-01_JPRB,5.9009E-01_JPRB,6.0449E-01_JPRB,7.0052E-01_JPRB,7.7068E-01_JPRB,&
&7.9084E-01_JPRB,7.7986E-01_JPRB,1.9934E+00_JPRB/)
KAO( :, 5, 6,15) = (/&
&7.3459E-01_JPRB,6.4331E-01_JPRB,6.4051E-01_JPRB,8.0328E-01_JPRB,9.6129E-01_JPRB,1.0614E+00_JPRB,&
&1.0888E+00_JPRB,7.3459E-01_JPRB,2.7652E+00_JPRB/)
KAO( :, 1, 7,15) = (/&
&1.0010E+00_JPRB,8.7619E-01_JPRB,7.5131E-01_JPRB,6.2639E-01_JPRB,5.0149E-01_JPRB,3.7652E-01_JPRB,&
&2.5149E-01_JPRB,1.0010E+00_JPRB,5.1478E-01_JPRB/)
KAO( :, 2, 7,15) = (/&
&9.4042E-01_JPRB,8.2317E-01_JPRB,7.0607E-01_JPRB,5.8870E-01_JPRB,4.7134E-01_JPRB,3.5775E-01_JPRB,&
&3.1227E-01_JPRB,9.4042E-01_JPRB,7.6928E-01_JPRB/)
KAO( :, 3, 7,15) = (/&
&8.8237E-01_JPRB,7.7255E-01_JPRB,6.6259E-01_JPRB,5.5268E-01_JPRB,4.7859E-01_JPRB,4.7554E-01_JPRB,&
&4.9216E-01_JPRB,8.8237E-01_JPRB,1.1825E+00_JPRB/)
KAO( :, 4, 7,15) = (/&
&8.2933E-01_JPRB,7.2604E-01_JPRB,6.2305E-01_JPRB,5.8548E-01_JPRB,6.3044E-01_JPRB,7.0378E-01_JPRB,&
&7.3153E-01_JPRB,8.2933E-01_JPRB,1.7634E+00_JPRB/)
KAO( :, 5, 7,15) = (/&
&7.8131E-01_JPRB,6.8426E-01_JPRB,6.4094E-01_JPRB,7.3798E-01_JPRB,8.8857E-01_JPRB,9.9138E-01_JPRB,&
&1.0340E+00_JPRB,7.8131E-01_JPRB,2.5071E+00_JPRB/)
KAO( :, 1, 8,15) = (/&
&1.0680E+00_JPRB,9.3481E-01_JPRB,8.0158E-01_JPRB,6.6826E-01_JPRB,5.3482E-01_JPRB,4.0154E-01_JPRB,&
&2.6788E-01_JPRB,1.0680E+00_JPRB,4.6455E-01_JPRB/)
KAO( :, 2, 8,15) = (/&
&1.0024E+00_JPRB,8.7742E-01_JPRB,7.5246E-01_JPRB,6.2743E-01_JPRB,5.0223E-01_JPRB,3.7717E-01_JPRB,&
&2.7719E-01_JPRB,1.0024E+00_JPRB,6.8110E-01_JPRB/)
KAO( :, 3, 8,15) = (/&
&9.4024E-01_JPRB,8.2314E-01_JPRB,7.0609E-01_JPRB,5.8881E-01_JPRB,4.8025E-01_JPRB,4.2864E-01_JPRB,&
&4.3393E-01_JPRB,9.4024E-01_JPRB,1.0170E+00_JPRB/)
KAO( :, 4, 8,15) = (/&
&8.8264E-01_JPRB,7.7273E-01_JPRB,6.6282E-01_JPRB,5.8404E-01_JPRB,5.7821E-01_JPRB,6.2771E-01_JPRB,&
&6.6458E-01_JPRB,8.8264E-01_JPRB,1.5302E+00_JPRB/)
KAO( :, 5, 8,15) = (/&
&8.3199E-01_JPRB,7.2845E-01_JPRB,6.5427E-01_JPRB,6.8741E-01_JPRB,8.0945E-01_JPRB,9.0978E-01_JPRB,&
&9.6418E-01_JPRB,8.3199E-01_JPRB,2.2337E+00_JPRB/)
KAO( :, 1, 9,15) = (/&
&1.1381E+00_JPRB,9.9610E-01_JPRB,8.5409E-01_JPRB,7.1197E-01_JPRB,5.6977E-01_JPRB,4.2770E-01_JPRB,&
&2.8544E-01_JPRB,1.1381E+00_JPRB,4.2382E-01_JPRB/)
KAO( :, 2, 9,15) = (/&
&1.0667E+00_JPRB,9.3372E-01_JPRB,8.0061E-01_JPRB,6.6744E-01_JPRB,5.3433E-01_JPRB,4.0118E-01_JPRB,&
&2.6997E-01_JPRB,1.0667E+00_JPRB,6.1324E-01_JPRB/)
KAO( :, 3, 9,15) = (/&
&1.0035E+00_JPRB,8.7845E-01_JPRB,7.5330E-01_JPRB,6.2805E-01_JPRB,5.0276E-01_JPRB,4.0704E-01_JPRB,&
&3.7170E-01_JPRB,1.0035E+00_JPRB,9.0055E-01_JPRB/)
KAO( :, 4, 9,15) = (/&
&9.4646E-01_JPRB,8.2850E-01_JPRB,7.1051E-01_JPRB,6.0313E-01_JPRB,5.4959E-01_JPRB,5.4972E-01_JPRB,&
&5.8769E-01_JPRB,9.4646E-01_JPRB,1.3351E+00_JPRB/)
KAO( :, 5, 9,15) = (/&
&8.9740E-01_JPRB,7.8559E-01_JPRB,6.8592E-01_JPRB,6.6573E-01_JPRB,7.2528E-01_JPRB,8.1924E-01_JPRB,&
&8.7543E-01_JPRB,8.9740E-01_JPRB,1.9504E+00_JPRB/)
KAO( :, 1,10,15) = (/&
&1.2073E+00_JPRB,1.0565E+00_JPRB,9.0576E-01_JPRB,7.5488E-01_JPRB,6.0419E-01_JPRB,4.5329E-01_JPRB,&
&3.0227E-01_JPRB,1.2073E+00_JPRB,3.9999E-01_JPRB/)
KAO( :, 2,10,15) = (/&
&1.1382E+00_JPRB,9.9608E-01_JPRB,8.5413E-01_JPRB,7.1184E-01_JPRB,5.6976E-01_JPRB,4.2763E-01_JPRB,&
&2.8536E-01_JPRB,1.1382E+00_JPRB,5.7883E-01_JPRB/)
KAO( :, 3,10,15) = (/&
&1.0785E+00_JPRB,9.4391E-01_JPRB,8.0923E-01_JPRB,6.7459E-01_JPRB,5.3984E-01_JPRB,4.1488E-01_JPRB,&
&3.3805E-01_JPRB,1.0785E+00_JPRB,8.3839E-01_JPRB/)
KAO( :, 4,10,15) = (/&
&1.0278E+00_JPRB,8.9961E-01_JPRB,7.7127E-01_JPRB,6.4730E-01_JPRB,5.5430E-01_JPRB,5.1106E-01_JPRB,&
&5.2425E-01_JPRB,1.0278E+00_JPRB,1.2284E+00_JPRB/)
KAO( :, 5,10,15) = (/&
&9.8618E-01_JPRB,8.6326E-01_JPRB,7.4679E-01_JPRB,6.7988E-01_JPRB,6.7637E-01_JPRB,7.4989E-01_JPRB,&
&8.0479E-01_JPRB,9.8618E-01_JPRB,1.7791E+00_JPRB/)
KAO( :, 1,11,15) = (/&
&1.2644E+00_JPRB,1.1063E+00_JPRB,9.4846E-01_JPRB,7.9047E-01_JPRB,6.3247E-01_JPRB,4.7453E-01_JPRB,&
&3.1659E-01_JPRB,1.2644E+00_JPRB,7.4298E-01_JPRB/)
KAO( :, 2,11,15) = (/&
&1.2071E+00_JPRB,1.0565E+00_JPRB,9.0557E-01_JPRB,7.5491E-01_JPRB,6.0392E-01_JPRB,4.5270E-01_JPRB,&
&3.0399E-01_JPRB,1.2071E+00_JPRB,8.1705E-01_JPRB/)
KAO( :, 3,11,15) = (/&
&1.1615E+00_JPRB,1.0165E+00_JPRB,8.7147E-01_JPRB,7.2637E-01_JPRB,5.8138E-01_JPRB,4.5624E-01_JPRB,&
&3.7840E-01_JPRB,1.1615E+00_JPRB,9.7765E-01_JPRB/)
KAO( :, 4,11,15) = (/&
&1.1264E+00_JPRB,9.8590E-01_JPRB,8.4531E-01_JPRB,7.1438E-01_JPRB,6.1502E-01_JPRB,5.6197E-01_JPRB,&
&5.7803E-01_JPRB,1.1264E+00_JPRB,1.3520E+00_JPRB/)
KAO( :, 5,11,15) = (/&
&1.0994E+00_JPRB,9.6216E-01_JPRB,8.3568E-01_JPRB,7.5689E-01_JPRB,7.4680E-01_JPRB,8.2884E-01_JPRB,&
&8.8880E-01_JPRB,1.0994E+00_JPRB,1.9292E+00_JPRB/)
KAO( :, 1,12,15) = (/&
&1.3647E+00_JPRB,1.1941E+00_JPRB,1.0237E+00_JPRB,8.5312E-01_JPRB,6.8264E-01_JPRB,5.1188E-01_JPRB,&
&3.4108E-01_JPRB,1.3647E+00_JPRB,1.2788E+00_JPRB/)
KAO( :, 2,12,15) = (/&
&1.3242E+00_JPRB,1.1588E+00_JPRB,9.9341E-01_JPRB,8.2794E-01_JPRB,6.6255E-01_JPRB,4.9690E-01_JPRB,&
&3.3841E-01_JPRB,1.3242E+00_JPRB,1.2778E+00_JPRB/)
KAO( :, 3,12,15) = (/&
&1.2955E+00_JPRB,1.1336E+00_JPRB,9.7197E-01_JPRB,8.1003E-01_JPRB,6.5411E-01_JPRB,5.1488E-01_JPRB,&
&4.3081E-01_JPRB,1.2955E+00_JPRB,1.3626E+00_JPRB/)
KAO( :, 4,12,15) = (/&
&1.2745E+00_JPRB,1.1153E+00_JPRB,9.5614E-01_JPRB,8.1202E-01_JPRB,6.9456E-01_JPRB,6.2323E-01_JPRB,&
&6.4228E-01_JPRB,1.2745E+00_JPRB,1.6020E+00_JPRB/)
KAO( :, 5,12,15) = (/&
&1.2602E+00_JPRB,1.1028E+00_JPRB,9.6134E-01_JPRB,8.5786E-01_JPRB,8.3175E-01_JPRB,9.1010E-01_JPRB,&
&9.8660E-01_JPRB,1.2602E+00_JPRB,2.1013E+00_JPRB/)
KAO( :, 1,13,15) = (/&
&1.5182E+00_JPRB,1.3286E+00_JPRB,1.1388E+00_JPRB,9.4918E-01_JPRB,7.5925E-01_JPRB,5.6967E-01_JPRB,&
&3.7977E-01_JPRB,1.5182E+00_JPRB,1.8162E+00_JPRB/)
KAO( :, 2,13,15) = (/&
&1.4954E+00_JPRB,1.3087E+00_JPRB,1.1217E+00_JPRB,9.3496E-01_JPRB,7.4798E-01_JPRB,5.6069E-01_JPRB,&
&3.8653E-01_JPRB,1.4954E+00_JPRB,1.7757E+00_JPRB/)
KAO( :, 3,13,15) = (/&
&1.4806E+00_JPRB,1.2956E+00_JPRB,1.1104E+00_JPRB,9.2545E-01_JPRB,7.5238E-01_JPRB,5.8983E-01_JPRB,&
&4.8997E-01_JPRB,1.4806E+00_JPRB,1.8395E+00_JPRB/)
KAO( :, 4,13,15) = (/&
&1.4707E+00_JPRB,1.2870E+00_JPRB,1.1033E+00_JPRB,9.3978E-01_JPRB,7.9436E-01_JPRB,6.9884E-01_JPRB,&
&7.1743E-01_JPRB,1.4707E+00_JPRB,1.9733E+00_JPRB/)
KAO( :, 5,13,15) = (/&
&1.4617E+00_JPRB,1.2790E+00_JPRB,1.1197E+00_JPRB,9.8344E-01_JPRB,9.3195E-01_JPRB,9.9536E-01_JPRB,&
&1.0841E+00_JPRB,1.4617E+00_JPRB,2.3960E+00_JPRB/)
KAO( :, 1, 1,16) = (/&
&6.7204E-01_JPRB,5.8835E-01_JPRB,4.9493E-01_JPRB,4.2075E-01_JPRB,3.2404E-01_JPRB,3.2835E-01_JPRB,&
&3.1694E-01_JPRB,6.7204E-01_JPRB,1.1553E+00_JPRB/)
KAO( :, 2, 1,16) = (/&
&6.3886E-01_JPRB,5.4837E-01_JPRB,4.7048E-01_JPRB,4.0570E-01_JPRB,4.5211E-01_JPRB,4.4664E-01_JPRB,&
&4.2417E-01_JPRB,6.3887E-01_JPRB,1.6108E+00_JPRB/)
KAO( :, 3, 1,16) = (/&
&6.0571E-01_JPRB,5.3024E-01_JPRB,4.5482E-01_JPRB,5.4623E-01_JPRB,6.0722E-01_JPRB,6.1523E-01_JPRB,&
&6.0675E-01_JPRB,6.0571E-01_JPRB,2.1229E+00_JPRB/)
KAO( :, 4, 1,16) = (/&
&5.7537E-01_JPRB,5.0361E-01_JPRB,5.5977E-01_JPRB,6.9780E-01_JPRB,7.7428E-01_JPRB,7.8387E-01_JPRB,&
&7.5743E-01_JPRB,5.7537E-01_JPRB,2.8238E+00_JPRB/)
KAO( :, 5, 1,16) = (/&
&5.4532E-01_JPRB,4.7762E-01_JPRB,7.0785E-01_JPRB,8.9753E-01_JPRB,9.9932E-01_JPRB,1.0137E+00_JPRB,&
&1.0005E+00_JPRB,5.4532E-01_JPRB,3.5639E+00_JPRB/)
KAO( :, 1, 2,16) = (/&
&7.1419E-01_JPRB,6.2513E-01_JPRB,5.3613E-01_JPRB,4.4716E-01_JPRB,3.5137E-01_JPRB,3.4275E-01_JPRB,&
&3.2618E-01_JPRB,7.1419E-01_JPRB,1.2386E+00_JPRB/)
KAO( :, 2, 2,16) = (/&
&6.7776E-01_JPRB,5.9352E-01_JPRB,5.0900E-01_JPRB,4.3513E-01_JPRB,4.7304E-01_JPRB,4.9853E-01_JPRB,&
&4.7175E-01_JPRB,6.7776E-01_JPRB,1.7603E+00_JPRB/)
KAO( :, 3, 2,16) = (/&
&6.4195E-01_JPRB,5.6188E-01_JPRB,4.8194E-01_JPRB,5.9011E-01_JPRB,6.5773E-01_JPRB,6.7703E-01_JPRB,&
&6.5466E-01_JPRB,6.4195E-01_JPRB,2.4018E+00_JPRB/)
KAO( :, 4, 2,16) = (/&
&6.0760E-01_JPRB,5.3187E-01_JPRB,6.1665E-01_JPRB,7.6305E-01_JPRB,8.6650E-01_JPRB,8.7779E-01_JPRB,&
&8.4546E-01_JPRB,6.0760E-01_JPRB,3.1623E+00_JPRB/)
KAO( :, 5, 2,16) = (/&
&5.7557E-01_JPRB,5.0389E-01_JPRB,7.8645E-01_JPRB,9.9605E-01_JPRB,1.1101E+00_JPRB,1.1441E+00_JPRB,&
&1.0872E+00_JPRB,5.7557E-01_JPRB,4.0554E+00_JPRB/)
KAO( :, 1, 3,16) = (/&
&7.6539E-01_JPRB,6.6993E-01_JPRB,5.7468E-01_JPRB,4.7908E-01_JPRB,3.8366E-01_JPRB,3.3164E-01_JPRB,&
&3.1419E-01_JPRB,7.6539E-01_JPRB,1.2218E+00_JPRB/)
KAO( :, 2, 3,16) = (/&
&7.2520E-01_JPRB,6.3496E-01_JPRB,5.4460E-01_JPRB,4.5403E-01_JPRB,4.7919E-01_JPRB,4.8518E-01_JPRB,&
&4.6775E-01_JPRB,7.2520E-01_JPRB,1.7874E+00_JPRB/)
KAO( :, 3, 3,16) = (/&
&6.8607E-01_JPRB,6.0066E-01_JPRB,5.1535E-01_JPRB,6.0192E-01_JPRB,6.5742E-01_JPRB,6.8742E-01_JPRB,&
&6.6482E-01_JPRB,6.8607E-01_JPRB,2.4947E+00_JPRB/)
KAO( :, 4, 3,16) = (/&
&6.4786E-01_JPRB,5.6724E-01_JPRB,6.3678E-01_JPRB,8.0813E-01_JPRB,8.8359E-01_JPRB,9.1109E-01_JPRB,&
&8.7792E-01_JPRB,6.4786E-01_JPRB,3.3575E+00_JPRB/)
KAO( :, 5, 3,16) = (/&
&6.1260E-01_JPRB,5.3649E-01_JPRB,8.2910E-01_JPRB,1.0492E+00_JPRB,1.1703E+00_JPRB,1.2063E+00_JPRB,&
&1.1675E+00_JPRB,6.1260E-01_JPRB,4.3791E+00_JPRB/)
KAO( :, 1, 4,16) = (/&
&8.2264E-01_JPRB,7.2018E-01_JPRB,6.1760E-01_JPRB,5.1504E-01_JPRB,4.1228E-01_JPRB,3.1403E-01_JPRB,&
&3.0330E-01_JPRB,8.2264E-01_JPRB,1.1500E+00_JPRB/)
KAO( :, 2, 4,16) = (/&
&7.7591E-01_JPRB,6.7905E-01_JPRB,5.8222E-01_JPRB,4.8587E-01_JPRB,4.6170E-01_JPRB,4.7497E-01_JPRB,&
&4.5862E-01_JPRB,7.7591E-01_JPRB,1.7280E+00_JPRB/)
KAO( :, 3, 4,16) = (/&
&7.3290E-01_JPRB,6.4193E-01_JPRB,5.5048E-01_JPRB,5.9279E-01_JPRB,6.6051E-01_JPRB,6.8079E-01_JPRB,&
&6.5994E-01_JPRB,7.3290E-01_JPRB,2.4901E+00_JPRB/)
KAO( :, 4, 4,16) = (/&
&6.9170E-01_JPRB,6.0563E-01_JPRB,6.4428E-01_JPRB,8.1421E-01_JPRB,9.0809E-01_JPRB,9.3805E-01_JPRB,&
&8.9044E-01_JPRB,6.9170E-01_JPRB,3.4202E+00_JPRB/)
KAO( :, 5, 4,16) = (/&
&6.5200E-01_JPRB,5.7086E-01_JPRB,8.5544E-01_JPRB,1.0841E+00_JPRB,1.2072E+00_JPRB,1.2191E+00_JPRB,&
&1.2042E+00_JPRB,6.5200E-01_JPRB,4.5618E+00_JPRB/)
KAO( :, 1, 5,16) = (/&
&8.8181E-01_JPRB,7.7179E-01_JPRB,6.6204E-01_JPRB,5.5199E-01_JPRB,4.3343E-01_JPRB,3.3186E-01_JPRB,&
&2.7727E-01_JPRB,8.8181E-01_JPRB,1.0520E+00_JPRB/)
KAO( :, 2, 5,16) = (/&
&8.2952E-01_JPRB,7.2638E-01_JPRB,6.2324E-01_JPRB,5.1947E-01_JPRB,4.3588E-01_JPRB,4.4832E-01_JPRB,&
&4.3512E-01_JPRB,8.2952E-01_JPRB,1.6494E+00_JPRB/)
KAO( :, 3, 5,16) = (/&
&7.8170E-01_JPRB,6.8471E-01_JPRB,5.8732E-01_JPRB,5.7928E-01_JPRB,6.4579E-01_JPRB,6.6360E-01_JPRB,&
&6.4439E-01_JPRB,7.8170E-01_JPRB,2.4300E+00_JPRB/)
KAO( :, 4, 5,16) = (/&
&7.3700E-01_JPRB,6.4559E-01_JPRB,6.4470E-01_JPRB,8.1536E-01_JPRB,9.1269E-01_JPRB,9.3873E-01_JPRB,&
&9.0753E-01_JPRB,7.3700E-01_JPRB,3.4492E+00_JPRB/)
KAO( :, 5, 5,16) = (/&
&6.9437E-01_JPRB,6.0807E-01_JPRB,8.7385E-01_JPRB,1.1073E+00_JPRB,1.2374E+00_JPRB,1.2510E+00_JPRB,&
&1.2316E+00_JPRB,6.9437E-01_JPRB,4.6799E+00_JPRB/)
KAO( :, 1, 6,16) = (/&
&9.4656E-01_JPRB,8.2884E-01_JPRB,7.1064E-01_JPRB,5.9233E-01_JPRB,4.7420E-01_JPRB,3.5608E-01_JPRB,&
&2.4362E-01_JPRB,9.4656E-01_JPRB,9.2837E-01_JPRB/)
KAO( :, 2, 6,16) = (/&
&8.9042E-01_JPRB,7.7970E-01_JPRB,6.6875E-01_JPRB,5.5799E-01_JPRB,4.4670E-01_JPRB,4.1251E-01_JPRB,&
&4.0025E-01_JPRB,8.9042E-01_JPRB,1.5112E+00_JPRB/)
KAO( :, 3, 6,16) = (/&
&8.3666E-01_JPRB,7.3284E-01_JPRB,6.2869E-01_JPRB,5.5096E-01_JPRB,6.1404E-01_JPRB,6.3375E-01_JPRB,&
&6.1412E-01_JPRB,8.3666E-01_JPRB,2.3236E+00_JPRB/)
KAO( :, 4, 6,16) = (/&
&7.8888E-01_JPRB,6.9101E-01_JPRB,6.2966E-01_JPRB,7.9961E-01_JPRB,8.9414E-01_JPRB,9.2254E-01_JPRB,&
&8.7581E-01_JPRB,7.8888E-01_JPRB,3.3711E+00_JPRB/)
KAO( :, 5, 6,16) = (/&
&7.4306E-01_JPRB,6.5113E-01_JPRB,8.7601E-01_JPRB,1.1131E+00_JPRB,1.2418E+00_JPRB,1.2838E+00_JPRB,&
&1.2412E+00_JPRB,7.4306E-01_JPRB,4.6947E+00_JPRB/)
KAO( :, 1, 7,16) = (/&
&1.0141E+00_JPRB,8.8774E-01_JPRB,7.6121E-01_JPRB,6.3477E-01_JPRB,5.0825E-01_JPRB,3.8150E-01_JPRB,&
&2.5476E-01_JPRB,1.0141E+00_JPRB,7.9663E-01_JPRB/)
KAO( :, 2, 7,16) = (/&
&9.5399E-01_JPRB,8.3513E-01_JPRB,7.1620E-01_JPRB,5.9743E-01_JPRB,4.7818E-01_JPRB,3.7373E-01_JPRB,&
&3.6192E-01_JPRB,9.5399E-01_JPRB,1.3655E+00_JPRB/)
KAO( :, 3, 7,16) = (/&
&8.9634E-01_JPRB,7.8499E-01_JPRB,6.7347E-01_JPRB,5.6171E-01_JPRB,5.7673E-01_JPRB,5.9473E-01_JPRB,&
&5.7642E-01_JPRB,8.9634E-01_JPRB,2.1680E+00_JPRB/)
KAO( :, 4, 7,16) = (/&
&8.4326E-01_JPRB,7.3869E-01_JPRB,6.3388E-01_JPRB,7.7423E-01_JPRB,8.6537E-01_JPRB,8.9227E-01_JPRB,&
&8.6433E-01_JPRB,8.4326E-01_JPRB,3.2604E+00_JPRB/)
KAO( :, 5, 7,16) = (/&
&7.9491E-01_JPRB,6.9647E-01_JPRB,8.6797E-01_JPRB,1.1053E+00_JPRB,1.2365E+00_JPRB,1.2774E+00_JPRB,&
&1.2375E+00_JPRB,7.9491E-01_JPRB,4.6484E+00_JPRB/)
KAO( :, 1, 8,16) = (/&
&1.0826E+00_JPRB,9.4750E-01_JPRB,8.1241E-01_JPRB,6.7724E-01_JPRB,5.4220E-01_JPRB,4.0687E-01_JPRB,&
&2.7135E-01_JPRB,1.0826E+00_JPRB,6.7305E-01_JPRB/)
KAO( :, 2, 8,16) = (/&
&1.0187E+00_JPRB,8.9193E-01_JPRB,7.6505E-01_JPRB,6.3785E-01_JPRB,5.1061E-01_JPRB,3.8339E-01_JPRB,&
&3.2268E-01_JPRB,1.0187E+00_JPRB,1.2085E+00_JPRB/)
KAO( :, 3, 8,16) = (/&
&9.5858E-01_JPRB,8.3946E-01_JPRB,7.2017E-01_JPRB,6.0051E-01_JPRB,5.3532E-01_JPRB,5.5217E-01_JPRB,&
&5.3452E-01_JPRB,9.5858E-01_JPRB,2.0055E+00_JPRB/)
KAO( :, 4, 8,16) = (/&
&9.0233E-01_JPRB,7.9038E-01_JPRB,6.7816E-01_JPRB,7.4178E-01_JPRB,8.2987E-01_JPRB,8.5828E-01_JPRB,&
&8.2989E-01_JPRB,9.0233E-01_JPRB,3.1045E+00_JPRB/)
KAO( :, 5, 8,16) = (/&
&8.5134E-01_JPRB,7.4583E-01_JPRB,8.5421E-01_JPRB,1.0895E+00_JPRB,1.2207E+00_JPRB,1.2603E+00_JPRB,&
&1.2206E+00_JPRB,8.5134E-01_JPRB,4.5597E+00_JPRB/)
KAO( :, 1, 9,16) = (/&
&1.1564E+00_JPRB,1.0121E+00_JPRB,8.6800E-01_JPRB,7.2367E-01_JPRB,5.7876E-01_JPRB,4.3457E-01_JPRB,&
&2.8981E-01_JPRB,1.1564E+00_JPRB,5.5525E-01_JPRB/)
KAO( :, 2, 9,16) = (/&
&1.0903E+00_JPRB,9.5491E-01_JPRB,8.1871E-01_JPRB,6.8281E-01_JPRB,5.4658E-01_JPRB,4.0983E-01_JPRB,&
&2.8183E-01_JPRB,1.0903E+00_JPRB,1.0488E+00_JPRB/)
KAO( :, 3, 9,16) = (/&
&1.0293E+00_JPRB,9.0147E-01_JPRB,7.7309E-01_JPRB,6.4495E-01_JPRB,5.1624E-01_JPRB,5.0522E-01_JPRB,&
&4.8904E-01_JPRB,1.0293E+00_JPRB,1.8131E+00_JPRB/)
KAO( :, 4, 9,16) = (/&
&9.7173E-01_JPRB,8.5120E-01_JPRB,7.3048E-01_JPRB,7.0120E-01_JPRB,7.8672E-01_JPRB,8.1370E-01_JPRB,&
&7.8991E-01_JPRB,9.7173E-01_JPRB,2.9196E+00_JPRB/)
KAO( :, 5, 9,16) = (/&
&9.1923E-01_JPRB,8.0514E-01_JPRB,8.3021E-01_JPRB,1.0615E+00_JPRB,1.1921E+00_JPRB,1.2331E+00_JPRB,&
&1.1982E+00_JPRB,9.1923E-01_JPRB,4.4066E+00_JPRB/)
KAO( :, 1,10,16) = (/&
&1.2374E+00_JPRB,1.0830E+00_JPRB,9.2878E-01_JPRB,7.7400E-01_JPRB,6.1971E-01_JPRB,4.6496E-01_JPRB,&
&3.0999E-01_JPRB,1.2374E+00_JPRB,5.8062E-01_JPRB/)
KAO( :, 2,10,16) = (/&
&1.1711E+00_JPRB,1.0252E+00_JPRB,8.7935E-01_JPRB,7.3302E-01_JPRB,5.8682E-01_JPRB,4.4044E-01_JPRB,&
&2.9397E-01_JPRB,1.1711E+00_JPRB,9.3348E-01_JPRB/)
KAO( :, 3,10,16) = (/&
&1.1097E+00_JPRB,9.7179E-01_JPRB,8.3349E-01_JPRB,6.9517E-01_JPRB,5.5660E-01_JPRB,4.7411E-01_JPRB,&
&4.6026E-01_JPRB,1.1097E+00_JPRB,1.6848E+00_JPRB/)
KAO( :, 4,10,16) = (/&
&1.0572E+00_JPRB,9.2545E-01_JPRB,7.9343E-01_JPRB,6.8000E-01_JPRB,7.6310E-01_JPRB,7.9077E-01_JPRB,&
&7.6860E-01_JPRB,1.0572E+00_JPRB,2.7940E+00_JPRB/)
KAO( :, 5,10,16) = (/&
&1.0175E+00_JPRB,8.9035E-01_JPRB,8.2349E-01_JPRB,1.0563E+00_JPRB,1.1865E+00_JPRB,1.2328E+00_JPRB,&
&1.1994E+00_JPRB,1.0175E+00_JPRB,4.3373E+00_JPRB/)
KAO( :, 1,11,16) = (/&
&1.3078E+00_JPRB,1.1446E+00_JPRB,9.8121E-01_JPRB,8.1822E-01_JPRB,6.5451E-01_JPRB,4.9148E-01_JPRB,&
&3.2796E-01_JPRB,1.3078E+00_JPRB,8.7955E-01_JPRB/)
KAO( :, 2,11,16) = (/&
&1.2495E+00_JPRB,1.0937E+00_JPRB,9.3769E-01_JPRB,7.8176E-01_JPRB,6.2549E-01_JPRB,4.6880E-01_JPRB,&
&3.1026E-01_JPRB,1.2495E+00_JPRB,1.1103E+00_JPRB/)
KAO( :, 3,11,16) = (/&
&1.2067E+00_JPRB,1.0559E+00_JPRB,9.0509E-01_JPRB,7.5401E-01_JPRB,6.0340E-01_JPRB,5.7377E-01_JPRB,&
&5.5854E-01_JPRB,1.2067E+00_JPRB,1.9965E+00_JPRB/)
KAO( :, 4,11,16) = (/&
&1.1748E+00_JPRB,1.0281E+00_JPRB,8.8102E-01_JPRB,8.1540E-01_JPRB,9.2020E-01_JPRB,9.5681E-01_JPRB,&
&9.3190E-01_JPRB,1.1748E+00_JPRB,3.3092E+00_JPRB/)
KAO( :, 5,11,16) = (/&
&1.1528E+00_JPRB,1.0088E+00_JPRB,9.8178E-01_JPRB,1.2680E+00_JPRB,1.4334E+00_JPRB,1.4913E+00_JPRB,&
&1.4507E+00_JPRB,1.1528E+00_JPRB,5.1215E+00_JPRB/)
KAO( :, 1,12,16) = (/&
&1.4264E+00_JPRB,1.2483E+00_JPRB,1.0700E+00_JPRB,8.9156E-01_JPRB,7.1342E-01_JPRB,5.3490E-01_JPRB,&
&3.5601E-01_JPRB,1.4264E+00_JPRB,1.5795E+00_JPRB/)
KAO( :, 2,12,16) = (/&
&1.3956E+00_JPRB,1.2210E+00_JPRB,1.0467E+00_JPRB,8.7214E-01_JPRB,6.9777E-01_JPRB,5.2320E-01_JPRB,&
&3.7423E-01_JPRB,1.3956E+00_JPRB,1.5601E+00_JPRB/)
KAO( :, 3,12,16) = (/&
&1.3711E+00_JPRB,1.1997E+00_JPRB,1.0285E+00_JPRB,8.5684E-01_JPRB,6.8534E-01_JPRB,6.9284E-01_JPRB,&
&6.7781E-01_JPRB,1.3711E+00_JPRB,2.3512E+00_JPRB/)
KAO( :, 4,12,16) = (/&
&1.3565E+00_JPRB,1.1870E+00_JPRB,1.0173E+00_JPRB,9.7613E-01_JPRB,1.1079E+00_JPRB,1.1568E+00_JPRB,&
&1.1307E+00_JPRB,1.3565E+00_JPRB,3.8814E+00_JPRB/)
KAO( :, 5,12,16) = (/&
&1.3408E+00_JPRB,1.1733E+00_JPRB,1.1680E+00_JPRB,1.5162E+00_JPRB,1.7205E+00_JPRB,1.8012E+00_JPRB,&
&1.7627E+00_JPRB,1.3408E+00_JPRB,5.9949E+00_JPRB/)
KAO( :, 1,13,16) = (/&
&1.6257E+00_JPRB,1.4225E+00_JPRB,1.2194E+00_JPRB,1.0160E+00_JPRB,8.1283E-01_JPRB,6.0965E-01_JPRB,&
&4.0604E-01_JPRB,1.6257E+00_JPRB,2.2989E+00_JPRB/)
KAO( :, 2,13,16) = (/&
&1.6092E+00_JPRB,1.4081E+00_JPRB,1.2069E+00_JPRB,1.0056E+00_JPRB,8.0424E-01_JPRB,6.0284E-01_JPRB,&
&4.5252E-01_JPRB,1.6092E+00_JPRB,2.2727E+00_JPRB/)
KAO( :, 3,13,16) = (/&
&1.6030E+00_JPRB,1.4026E+00_JPRB,1.2019E+00_JPRB,1.0013E+00_JPRB,8.1602E-01_JPRB,8.3675E-01_JPRB,&
&8.2085E-01_JPRB,1.6030E+00_JPRB,2.7443E+00_JPRB/)
KAO( :, 4,13,16) = (/&
&1.5933E+00_JPRB,1.3941E+00_JPRB,1.1949E+00_JPRB,1.1601E+00_JPRB,1.3266E+00_JPRB,1.3927E+00_JPRB,&
&1.3677E+00_JPRB,1.5933E+00_JPRB,4.4922E+00_JPRB/)
KAO( :, 5,13,16) = (/&
&1.5870E+00_JPRB,1.3885E+00_JPRB,1.3769E+00_JPRB,1.7994E+00_JPRB,2.0601E+00_JPRB,2.1667E+00_JPRB,&
&2.1254E+00_JPRB,1.5870E+00_JPRB,6.9188E+00_JPRB/)


!     The array KBO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of O3 to CO2.  The first index in the array, JS, runs from 1 to 6, 
!     and corresponds to different O3 to CO2 ratios, as expressed through 
!     the binary species parameter eta, defined as eta = O3/(O3+RAT*H2O), 
!     where RAT is the ratio of the integrated line strength in the band 
!     of CO2 to that of O3.  For instance, JS=1 refers to no O3 (eta = 0) 
!     and JS = 5 corresponds to eta = 1.0.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.

KBO( :, 1,13, 1) = (/&
&1.0590E-03_JPRB,1.1708E-03_JPRB,6.1804E-03_JPRB,8.3851E-03_JPRB,9.8401E-03_JPRB,1.0650E-02_JPRB/)
KBO( :, 2,13, 1) = (/&
&1.2737E-03_JPRB,1.3921E-03_JPRB,6.7837E-03_JPRB,9.1802E-03_JPRB,1.0724E-02_JPRB,1.1694E-02_JPRB/)
KBO( :, 3,13, 1) = (/&
&1.4928E-03_JPRB,1.6167E-03_JPRB,7.3037E-03_JPRB,9.8097E-03_JPRB,1.1413E-02_JPRB,1.2559E-02_JPRB/)
KBO( :, 4,13, 1) = (/&
&1.7101E-03_JPRB,1.8380E-03_JPRB,7.7361E-03_JPRB,1.0305E-02_JPRB,1.1932E-02_JPRB,1.3252E-02_JPRB/)
KBO( :, 5,13, 1) = (/&
&1.9268E-03_JPRB,2.0574E-03_JPRB,8.1040E-03_JPRB,1.0709E-02_JPRB,1.2321E-02_JPRB,1.3787E-02_JPRB/)
KBO( :, 1,14, 1) = (/&
&8.9853E-04_JPRB,1.0053E-03_JPRB,5.2612E-03_JPRB,7.1257E-03_JPRB,8.3170E-03_JPRB,8.6277E-03_JPRB/)
KBO( :, 2,14, 1) = (/&
&1.0785E-03_JPRB,1.1914E-03_JPRB,5.7513E-03_JPRB,7.7564E-03_JPRB,9.0118E-03_JPRB,9.3819E-03_JPRB/)
KBO( :, 3,14, 1) = (/&
&1.2591E-03_JPRB,1.3782E-03_JPRB,6.1715E-03_JPRB,8.2478E-03_JPRB,9.5484E-03_JPRB,9.9996E-03_JPRB/)
KBO( :, 4,14, 1) = (/&
&1.4397E-03_JPRB,1.5627E-03_JPRB,6.5193E-03_JPRB,8.6487E-03_JPRB,9.9620E-03_JPRB,1.0485E-02_JPRB/)
KBO( :, 5,14, 1) = (/&
&1.6201E-03_JPRB,1.7459E-03_JPRB,6.8165E-03_JPRB,8.9827E-03_JPRB,1.0273E-02_JPRB,1.0855E-02_JPRB/)
KBO( :, 1,15, 1) = (/&
&7.6248E-04_JPRB,8.6279E-04_JPRB,4.4557E-03_JPRB,6.0207E-03_JPRB,6.9896E-03_JPRB,7.0236E-03_JPRB/)
KBO( :, 2,15, 1) = (/&
&9.1117E-04_JPRB,1.0180E-03_JPRB,4.8561E-03_JPRB,6.5127E-03_JPRB,7.5369E-03_JPRB,7.5846E-03_JPRB/)
KBO( :, 3,15, 1) = (/&
&1.0596E-03_JPRB,1.1723E-03_JPRB,5.1898E-03_JPRB,6.9089E-03_JPRB,7.9643E-03_JPRB,8.0325E-03_JPRB/)
KBO( :, 4,15, 1) = (/&
&1.2094E-03_JPRB,1.3263E-03_JPRB,5.4734E-03_JPRB,7.2380E-03_JPRB,8.2957E-03_JPRB,8.3723E-03_JPRB/)
KBO( :, 5,15, 1) = (/&
&1.3603E-03_JPRB,1.4802E-03_JPRB,5.7085E-03_JPRB,7.5104E-03_JPRB,8.5497E-03_JPRB,8.6178E-03_JPRB/)
KBO( :, 1,16, 1) = (/&
&6.4558E-04_JPRB,7.3804E-04_JPRB,3.7596E-03_JPRB,5.0589E-03_JPRB,5.8485E-03_JPRB,5.7705E-03_JPRB/)
KBO( :, 2,16, 1) = (/&
&7.6748E-04_JPRB,8.6612E-04_JPRB,4.0796E-03_JPRB,5.4496E-03_JPRB,6.2858E-03_JPRB,6.2010E-03_JPRB/)
KBO( :, 3,16, 1) = (/&
&8.9029E-04_JPRB,9.9466E-04_JPRB,4.3523E-03_JPRB,5.7735E-03_JPRB,6.6286E-03_JPRB,6.5375E-03_JPRB/)
KBO( :, 4,16, 1) = (/&
&1.0154E-03_JPRB,1.1242E-03_JPRB,4.5767E-03_JPRB,6.0430E-03_JPRB,6.8981E-03_JPRB,6.7855E-03_JPRB/)
KBO( :, 5,16, 1) = (/&
&1.1412E-03_JPRB,1.2532E-03_JPRB,4.7673E-03_JPRB,6.2610E-03_JPRB,7.1083E-03_JPRB,6.9585E-03_JPRB/)
KBO( :, 1,17, 1) = (/&
&5.4461E-04_JPRB,6.2792E-04_JPRB,3.1575E-03_JPRB,4.2329E-03_JPRB,4.8773E-03_JPRB,4.7433E-03_JPRB/)
KBO( :, 2,17, 1) = (/&
&6.4498E-04_JPRB,7.3395E-04_JPRB,3.4178E-03_JPRB,4.5500E-03_JPRB,5.2291E-03_JPRB,5.0778E-03_JPRB/)
KBO( :, 3,17, 1) = (/&
&7.4677E-04_JPRB,8.4137E-04_JPRB,3.6368E-03_JPRB,4.8153E-03_JPRB,5.5080E-03_JPRB,5.3328E-03_JPRB/)
KBO( :, 4,17, 1) = (/&
&8.5117E-04_JPRB,9.5016E-04_JPRB,3.8176E-03_JPRB,5.0337E-03_JPRB,5.7279E-03_JPRB,5.5173E-03_JPRB/)
KBO( :, 5,17, 1) = (/&
&9.5670E-04_JPRB,1.0591E-03_JPRB,3.9736E-03_JPRB,5.2057E-03_JPRB,5.9001E-03_JPRB,5.6411E-03_JPRB/)
KBO( :, 1,18, 1) = (/&
&4.5831E-04_JPRB,5.3207E-04_JPRB,2.6453E-03_JPRB,3.5350E-03_JPRB,4.0595E-03_JPRB,3.9025E-03_JPRB/)
KBO( :, 2,18, 1) = (/&
&5.4148E-04_JPRB,6.2048E-04_JPRB,2.8564E-03_JPRB,3.7920E-03_JPRB,4.3430E-03_JPRB,4.1638E-03_JPRB/)
KBO( :, 3,18, 1) = (/&
&6.2620E-04_JPRB,7.1046E-04_JPRB,3.0316E-03_JPRB,4.0093E-03_JPRB,4.5705E-03_JPRB,4.3594E-03_JPRB/)
KBO( :, 4,18, 1) = (/&
&7.1296E-04_JPRB,8.0140E-04_JPRB,3.1785E-03_JPRB,4.1822E-03_JPRB,4.7500E-03_JPRB,4.4993E-03_JPRB/)
KBO( :, 5,18, 1) = (/&
&8.0117E-04_JPRB,8.9283E-04_JPRB,3.3073E-03_JPRB,4.3215E-03_JPRB,4.8888E-03_JPRB,4.5891E-03_JPRB/)
KBO( :, 1,19, 1) = (/&
&3.8494E-04_JPRB,4.4957E-04_JPRB,2.2130E-03_JPRB,2.9470E-03_JPRB,3.3734E-03_JPRB,3.2052E-03_JPRB/)
KBO( :, 2,19, 1) = (/&
&4.5392E-04_JPRB,5.2326E-04_JPRB,2.3822E-03_JPRB,3.1567E-03_JPRB,3.6037E-03_JPRB,3.4087E-03_JPRB/)
KBO( :, 3,19, 1) = (/&
&5.2442E-04_JPRB,5.9860E-04_JPRB,2.5231E-03_JPRB,3.3307E-03_JPRB,3.7894E-03_JPRB,3.5584E-03_JPRB/)
KBO( :, 4,19, 1) = (/&
&5.9668E-04_JPRB,6.7462E-04_JPRB,2.6423E-03_JPRB,3.4702E-03_JPRB,3.9343E-03_JPRB,3.6638E-03_JPRB/)
KBO( :, 5,19, 1) = (/&
&6.7047E-04_JPRB,7.5133E-04_JPRB,2.7479E-03_JPRB,3.5833E-03_JPRB,4.0439E-03_JPRB,3.7286E-03_JPRB/)
KBO( :, 1,20, 1) = (/&
&3.2391E-04_JPRB,3.8002E-04_JPRB,1.8505E-03_JPRB,2.4575E-03_JPRB,2.8045E-03_JPRB,2.6400E-03_JPRB/)
KBO( :, 2,20, 1) = (/&
&3.8111E-04_JPRB,4.4150E-04_JPRB,1.9855E-03_JPRB,2.6268E-03_JPRB,2.9913E-03_JPRB,2.7980E-03_JPRB/)
KBO( :, 3,20, 1) = (/&
&4.3985E-04_JPRB,5.0438E-04_JPRB,2.0980E-03_JPRB,2.7657E-03_JPRB,3.1412E-03_JPRB,2.9140E-03_JPRB/)
KBO( :, 4,20, 1) = (/&
&5.0012E-04_JPRB,5.6796E-04_JPRB,2.1952E-03_JPRB,2.8783E-03_JPRB,3.2557E-03_JPRB,2.9937E-03_JPRB/)
KBO( :, 5,20, 1) = (/&
&5.6151E-04_JPRB,6.3169E-04_JPRB,2.2834E-03_JPRB,2.9700E-03_JPRB,3.3427E-03_JPRB,3.0410E-03_JPRB/)
KBO( :, 1,21, 1) = (/&
&2.7240E-04_JPRB,3.2071E-04_JPRB,1.5442E-03_JPRB,2.0481E-03_JPRB,2.3310E-03_JPRB,2.1748E-03_JPRB/)
KBO( :, 2,21, 1) = (/&
&3.1992E-04_JPRB,3.7200E-04_JPRB,1.6519E-03_JPRB,2.1831E-03_JPRB,2.4822E-03_JPRB,2.2984E-03_JPRB/)
KBO( :, 3,21, 1) = (/&
&3.6883E-04_JPRB,4.2432E-04_JPRB,1.7430E-03_JPRB,2.2945E-03_JPRB,2.6004E-03_JPRB,2.3880E-03_JPRB/)
KBO( :, 4,21, 1) = (/&
&4.1890E-04_JPRB,4.7736E-04_JPRB,1.8230E-03_JPRB,2.3849E-03_JPRB,2.6916E-03_JPRB,2.4483E-03_JPRB/)
KBO( :, 5,21, 1) = (/&
&4.7018E-04_JPRB,5.3020E-04_JPRB,1.8963E-03_JPRB,2.4601E-03_JPRB,2.7620E-03_JPRB,2.4834E-03_JPRB/)
KBO( :, 1,22, 1) = (/&
&2.3153E-04_JPRB,2.7303E-04_JPRB,1.2915E-03_JPRB,1.7120E-03_JPRB,1.9456E-03_JPRB,1.7989E-03_JPRB/)
KBO( :, 2,22, 1) = (/&
&2.7103E-04_JPRB,3.1578E-04_JPRB,1.3773E-03_JPRB,1.8187E-03_JPRB,2.0643E-03_JPRB,1.8940E-03_JPRB/)
KBO( :, 3,22, 1) = (/&
&3.1187E-04_JPRB,3.5947E-04_JPRB,1.4512E-03_JPRB,1.9068E-03_JPRB,2.1566E-03_JPRB,1.9615E-03_JPRB/)
KBO( :, 4,22, 1) = (/&
&3.5350E-04_JPRB,4.0345E-04_JPRB,1.5172E-03_JPRB,1.9794E-03_JPRB,2.2288E-03_JPRB,2.0059E-03_JPRB/)
KBO( :, 5,22, 1) = (/&
&3.9619E-04_JPRB,4.4713E-04_JPRB,1.5771E-03_JPRB,2.0415E-03_JPRB,2.2843E-03_JPRB,2.0310E-03_JPRB/)
KBO( :, 1,23, 1) = (/&
&1.9680E-04_JPRB,2.3224E-04_JPRB,1.0785E-03_JPRB,1.4288E-03_JPRB,1.6223E-03_JPRB,1.4871E-03_JPRB/)
KBO( :, 2,23, 1) = (/&
&2.2970E-04_JPRB,2.6791E-04_JPRB,1.1474E-03_JPRB,1.5138E-03_JPRB,1.7153E-03_JPRB,1.5600E-03_JPRB/)
KBO( :, 3,23, 1) = (/&
&2.6356E-04_JPRB,3.0411E-04_JPRB,1.2075E-03_JPRB,1.5839E-03_JPRB,1.7875E-03_JPRB,1.6111E-03_JPRB/)
KBO( :, 4,23, 1) = (/&
&2.9823E-04_JPRB,3.4049E-04_JPRB,1.2615E-03_JPRB,1.6428E-03_JPRB,1.8444E-03_JPRB,1.6436E-03_JPRB/)
KBO( :, 5,23, 1) = (/&
&3.3366E-04_JPRB,3.7655E-04_JPRB,1.3106E-03_JPRB,1.6936E-03_JPRB,1.8885E-03_JPRB,1.6606E-03_JPRB/)
KBO( :, 1,24, 1) = (/&
&1.6732E-04_JPRB,1.9749E-04_JPRB,9.0024E-04_JPRB,1.1912E-03_JPRB,1.3515E-03_JPRB,1.2284E-03_JPRB/)
KBO( :, 2,24, 1) = (/&
&1.9470E-04_JPRB,2.2712E-04_JPRB,9.5558E-04_JPRB,1.2587E-03_JPRB,1.4239E-03_JPRB,1.2838E-03_JPRB/)
KBO( :, 3,24, 1) = (/&
&2.2281E-04_JPRB,2.5707E-04_JPRB,1.0048E-03_JPRB,1.3153E-03_JPRB,1.4808E-03_JPRB,1.3221E-03_JPRB/)
KBO( :, 4,24, 1) = (/&
&2.5169E-04_JPRB,2.8708E-04_JPRB,1.0484E-03_JPRB,1.3630E-03_JPRB,1.5260E-03_JPRB,1.3453E-03_JPRB/)
KBO( :, 5,24, 1) = (/&
&2.8094E-04_JPRB,3.1674E-04_JPRB,1.0886E-03_JPRB,1.4046E-03_JPRB,1.5614E-03_JPRB,1.3561E-03_JPRB/)
KBO( :, 1,25, 1) = (/&
&1.4236E-04_JPRB,1.6794E-04_JPRB,7.5125E-04_JPRB,9.9289E-04_JPRB,1.1254E-03_JPRB,1.0148E-03_JPRB/)
KBO( :, 2,25, 1) = (/&
&1.6512E-04_JPRB,1.9246E-04_JPRB,7.9598E-04_JPRB,1.0465E-03_JPRB,1.1819E-03_JPRB,1.0567E-03_JPRB/)
KBO( :, 3,25, 1) = (/&
&1.8845E-04_JPRB,2.1722E-04_JPRB,8.3598E-04_JPRB,1.0925E-03_JPRB,1.2269E-03_JPRB,1.0851E-03_JPRB/)
KBO( :, 4,25, 1) = (/&
&2.1255E-04_JPRB,2.4198E-04_JPRB,8.7137E-04_JPRB,1.1312E-03_JPRB,1.2632E-03_JPRB,1.1012E-03_JPRB/)
KBO( :, 5,25, 1) = (/&
&2.3642E-04_JPRB,2.6609E-04_JPRB,9.0373E-04_JPRB,1.1641E-03_JPRB,1.2904E-03_JPRB,1.1075E-03_JPRB/)
KBO( :, 1,26, 1) = (/&
&1.2135E-04_JPRB,1.4296E-04_JPRB,6.2705E-04_JPRB,8.2752E-04_JPRB,9.3670E-04_JPRB,8.3888E-04_JPRB/)
KBO( :, 2,26, 1) = (/&
&1.4025E-04_JPRB,1.6320E-04_JPRB,6.6335E-04_JPRB,8.7086E-04_JPRB,9.8124E-04_JPRB,8.7024E-04_JPRB/)
KBO( :, 3,26, 1) = (/&
&1.5968E-04_JPRB,1.8367E-04_JPRB,6.9554E-04_JPRB,9.0762E-04_JPRB,1.0171E-03_JPRB,8.9085E-04_JPRB/)
KBO( :, 4,26, 1) = (/&
&1.7968E-04_JPRB,2.0411E-04_JPRB,7.2423E-04_JPRB,9.3899E-04_JPRB,1.0460E-03_JPRB,9.0171E-04_JPRB/)
KBO( :, 5,26, 1) = (/&
&1.9911E-04_JPRB,2.2355E-04_JPRB,7.5041E-04_JPRB,9.6460E-04_JPRB,1.0668E-03_JPRB,9.0488E-04_JPRB/)
KBO( :, 1,27, 1) = (/&
&1.0341E-04_JPRB,1.2153E-04_JPRB,5.2310E-04_JPRB,6.8960E-04_JPRB,7.7919E-04_JPRB,6.9370E-04_JPRB/)
KBO( :, 2,27, 1) = (/&
&1.1910E-04_JPRB,1.3828E-04_JPRB,5.5242E-04_JPRB,7.2420E-04_JPRB,8.1412E-04_JPRB,7.1711E-04_JPRB/)
KBO( :, 3,27, 1) = (/&
&1.3529E-04_JPRB,1.5520E-04_JPRB,5.7820E-04_JPRB,7.5373E-04_JPRB,8.4285E-04_JPRB,7.3175E-04_JPRB/)
KBO( :, 4,27, 1) = (/&
&1.5173E-04_JPRB,1.7193E-04_JPRB,6.0154E-04_JPRB,7.7867E-04_JPRB,8.6563E-04_JPRB,7.3890E-04_JPRB/)
KBO( :, 5,27, 1) = (/&
&1.6753E-04_JPRB,1.8765E-04_JPRB,6.2289E-04_JPRB,7.9883E-04_JPRB,8.8130E-04_JPRB,7.3997E-04_JPRB/)
KBO( :, 1,28, 1) = (/&
&8.8061E-05_JPRB,1.0321E-04_JPRB,4.3625E-04_JPRB,5.7437E-04_JPRB,6.4777E-04_JPRB,5.7348E-04_JPRB/)
KBO( :, 2,28, 1) = (/&
&1.0110E-04_JPRB,1.1708E-04_JPRB,4.5983E-04_JPRB,6.0227E-04_JPRB,6.7553E-04_JPRB,5.9094E-04_JPRB/)
KBO( :, 3,28, 1) = (/&
&1.1455E-04_JPRB,1.3102E-04_JPRB,4.8047E-04_JPRB,6.2567E-04_JPRB,6.9826E-04_JPRB,6.0125E-04_JPRB/)
KBO( :, 4,28, 1) = (/&
&1.2801E-04_JPRB,1.4469E-04_JPRB,4.9957E-04_JPRB,6.4544E-04_JPRB,7.1609E-04_JPRB,6.0583E-04_JPRB/)
KBO( :, 5,28, 1) = (/&
&1.4086E-04_JPRB,1.5736E-04_JPRB,5.1693E-04_JPRB,6.6170E-04_JPRB,7.2796E-04_JPRB,6.0570E-04_JPRB/)
KBO( :, 1,29, 1) = (/&
&7.5003E-05_JPRB,8.7664E-05_JPRB,3.6374E-04_JPRB,4.7834E-04_JPRB,5.3844E-04_JPRB,4.7486E-04_JPRB/)
KBO( :, 2,29, 1) = (/&
&8.5847E-05_JPRB,9.9153E-05_JPRB,3.8260E-04_JPRB,5.0066E-04_JPRB,5.6048E-04_JPRB,4.8785E-04_JPRB/)
KBO( :, 3,29, 1) = (/&
&9.7004E-05_JPRB,1.1064E-04_JPRB,3.9929E-04_JPRB,5.1926E-04_JPRB,5.7857E-04_JPRB,4.9509E-04_JPRB/)
KBO( :, 4,29, 1) = (/&
&1.0798E-04_JPRB,1.2169E-04_JPRB,4.1471E-04_JPRB,5.3469E-04_JPRB,5.9200E-04_JPRB,4.9798E-04_JPRB/)
KBO( :, 5,29, 1) = (/&
&1.1839E-04_JPRB,1.3193E-04_JPRB,4.2885E-04_JPRB,5.4790E-04_JPRB,6.0121E-04_JPRB,4.9719E-04_JPRB/)
KBO( :, 1,30, 1) = (/&
&6.3856E-05_JPRB,7.4428E-05_JPRB,3.0309E-04_JPRB,3.9831E-04_JPRB,4.4748E-04_JPRB,3.9336E-04_JPRB/)
KBO( :, 2,30, 1) = (/&
&7.2870E-05_JPRB,8.3906E-05_JPRB,3.1816E-04_JPRB,4.1597E-04_JPRB,4.6500E-04_JPRB,4.0292E-04_JPRB/)
KBO( :, 3,30, 1) = (/&
&8.2079E-05_JPRB,9.3343E-05_JPRB,3.3169E-04_JPRB,4.3066E-04_JPRB,4.7913E-04_JPRB,4.0807E-04_JPRB/)
KBO( :, 4,30, 1) = (/&
&9.1015E-05_JPRB,1.0225E-04_JPRB,3.4430E-04_JPRB,4.4314E-04_JPRB,4.8947E-04_JPRB,4.0977E-04_JPRB/)
KBO( :, 5,30, 1) = (/&
&9.9395E-05_JPRB,1.1051E-04_JPRB,3.5570E-04_JPRB,4.5357E-04_JPRB,4.9658E-04_JPRB,4.0872E-04_JPRB/)
KBO( :, 1,31, 1) = (/&
&5.4357E-05_JPRB,6.3176E-05_JPRB,2.5245E-04_JPRB,3.3157E-04_JPRB,3.7178E-04_JPRB,3.2647E-04_JPRB/)
KBO( :, 2,31, 1) = (/&
&6.1861E-05_JPRB,7.0996E-05_JPRB,2.6445E-04_JPRB,3.4538E-04_JPRB,3.8570E-04_JPRB,3.3355E-04_JPRB/)
KBO( :, 3,31, 1) = (/&
&6.9416E-05_JPRB,7.8709E-05_JPRB,2.7554E-04_JPRB,3.5712E-04_JPRB,3.9671E-04_JPRB,3.3723E-04_JPRB/)
KBO( :, 4,31, 1) = (/&
&7.6656E-05_JPRB,8.5880E-05_JPRB,2.8577E-04_JPRB,3.6709E-04_JPRB,4.0449E-04_JPRB,3.3826E-04_JPRB/)
KBO( :, 5,31, 1) = (/&
&8.3388E-05_JPRB,9.2525E-05_JPRB,2.9501E-04_JPRB,3.7530E-04_JPRB,4.1001E-04_JPRB,3.3724E-04_JPRB/)
KBO( :, 1,32, 1) = (/&
&4.6259E-05_JPRB,5.3603E-05_JPRB,2.1016E-04_JPRB,2.7584E-04_JPRB,3.0892E-04_JPRB,2.7109E-04_JPRB/)
KBO( :, 2,32, 1) = (/&
&5.2498E-05_JPRB,6.0059E-05_JPRB,2.1987E-04_JPRB,2.8676E-04_JPRB,3.1987E-04_JPRB,2.7630E-04_JPRB/)
KBO( :, 3,32, 1) = (/&
&5.8656E-05_JPRB,6.6298E-05_JPRB,2.2891E-04_JPRB,2.9611E-04_JPRB,3.2832E-04_JPRB,2.7895E-04_JPRB/)
KBO( :, 4,32, 1) = (/&
&6.4498E-05_JPRB,7.2071E-05_JPRB,2.3718E-04_JPRB,3.0404E-04_JPRB,3.3430E-04_JPRB,2.7957E-04_JPRB/)
KBO( :, 5,32, 1) = (/&
&6.9916E-05_JPRB,7.7424E-05_JPRB,2.4471E-04_JPRB,3.1058E-04_JPRB,3.3850E-04_JPRB,2.7859E-04_JPRB/)
KBO( :, 1,33, 1) = (/&
&3.9361E-05_JPRB,4.5460E-05_JPRB,1.7493E-04_JPRB,2.2932E-04_JPRB,2.5656E-04_JPRB,2.2525E-04_JPRB/)
KBO( :, 2,33, 1) = (/&
&4.4512E-05_JPRB,5.0768E-05_JPRB,1.8281E-04_JPRB,2.3800E-04_JPRB,2.6516E-04_JPRB,2.2918E-04_JPRB/)
KBO( :, 3,33, 1) = (/&
&4.9514E-05_JPRB,5.5781E-05_JPRB,1.9016E-04_JPRB,2.4549E-04_JPRB,2.7165E-04_JPRB,2.3114E-04_JPRB/)
KBO( :, 4,33, 1) = (/&
&5.4222E-05_JPRB,6.0427E-05_JPRB,1.9683E-04_JPRB,2.5168E-04_JPRB,2.7625E-04_JPRB,2.3152E-04_JPRB/)
KBO( :, 5,33, 1) = (/&
&5.8568E-05_JPRB,6.4731E-05_JPRB,2.0299E-04_JPRB,2.5697E-04_JPRB,2.7939E-04_JPRB,2.3058E-04_JPRB/)
KBO( :, 1,34, 1) = (/&
&3.3323E-05_JPRB,3.8371E-05_JPRB,1.4532E-04_JPRB,1.9026E-04_JPRB,2.1273E-04_JPRB,1.8680E-04_JPRB/)
KBO( :, 2,34, 1) = (/&
&3.7542E-05_JPRB,4.2703E-05_JPRB,1.5176E-04_JPRB,1.9725E-04_JPRB,2.1949E-04_JPRB,1.8982E-04_JPRB/)
KBO( :, 3,34, 1) = (/&
&4.1603E-05_JPRB,4.6750E-05_JPRB,1.5775E-04_JPRB,2.0322E-04_JPRB,2.2449E-04_JPRB,1.9126E-04_JPRB/)
KBO( :, 4,34, 1) = (/&
&4.5410E-05_JPRB,5.0505E-05_JPRB,1.6321E-04_JPRB,2.0822E-04_JPRB,2.2810E-04_JPRB,1.9147E-04_JPRB/)
KBO( :, 5,34, 1) = (/&
&4.8872E-05_JPRB,5.3940E-05_JPRB,1.6826E-04_JPRB,2.1254E-04_JPRB,2.3048E-04_JPRB,1.9060E-04_JPRB/)
KBO( :, 1,35, 1) = (/&
&2.7848E-05_JPRB,3.2017E-05_JPRB,1.2019E-04_JPRB,1.5723E-04_JPRB,1.7574E-04_JPRB,1.5467E-04_JPRB/)
KBO( :, 2,35, 1) = (/&
&3.1305E-05_JPRB,3.5553E-05_JPRB,1.2549E-04_JPRB,1.6294E-04_JPRB,1.8117E-04_JPRB,1.5712E-04_JPRB/)
KBO( :, 3,35, 1) = (/&
&3.4621E-05_JPRB,3.8848E-05_JPRB,1.3039E-04_JPRB,1.6780E-04_JPRB,1.8517E-04_JPRB,1.5830E-04_JPRB/)
KBO( :, 4,35, 1) = (/&
&3.7704E-05_JPRB,4.1891E-05_JPRB,1.3491E-04_JPRB,1.7188E-04_JPRB,1.8805E-04_JPRB,1.5843E-04_JPRB/)
KBO( :, 5,35, 1) = (/&
&4.0476E-05_JPRB,4.4649E-05_JPRB,1.3909E-04_JPRB,1.7549E-04_JPRB,1.8997E-04_JPRB,1.5779E-04_JPRB/)
KBO( :, 1,36, 1) = (/&
&2.2956E-05_JPRB,2.6385E-05_JPRB,9.8921E-05_JPRB,1.2940E-04_JPRB,1.4463E-04_JPRB,1.2779E-04_JPRB/)
KBO( :, 2,36, 1) = (/&
&2.5793E-05_JPRB,2.9285E-05_JPRB,1.0333E-04_JPRB,1.3415E-04_JPRB,1.4912E-04_JPRB,1.2989E-04_JPRB/)
KBO( :, 3,36, 1) = (/&
&2.8520E-05_JPRB,3.1993E-05_JPRB,1.0740E-04_JPRB,1.3821E-04_JPRB,1.5246E-04_JPRB,1.3097E-04_JPRB/)
KBO( :, 4,36, 1) = (/&
&3.1028E-05_JPRB,3.4473E-05_JPRB,1.1115E-04_JPRB,1.4160E-04_JPRB,1.5487E-04_JPRB,1.3116E-04_JPRB/)
KBO( :, 5,36, 1) = (/&
&3.3268E-05_JPRB,3.6701E-05_JPRB,1.1464E-04_JPRB,1.4466E-04_JPRB,1.5648E-04_JPRB,1.3075E-04_JPRB/)
KBO( :, 1,37, 1) = (/&
&1.8563E-05_JPRB,2.1372E-05_JPRB,8.0857E-05_JPRB,1.0587E-04_JPRB,1.1839E-04_JPRB,1.0509E-04_JPRB/)
KBO( :, 2,37, 1) = (/&
&2.0902E-05_JPRB,2.3771E-05_JPRB,8.4550E-05_JPRB,1.0990E-04_JPRB,1.2224E-04_JPRB,1.0704E-04_JPRB/)
KBO( :, 3,37, 1) = (/&
&2.3158E-05_JPRB,2.6017E-05_JPRB,8.7968E-05_JPRB,1.1334E-04_JPRB,1.2513E-04_JPRB,1.0806E-04_JPRB/)
KBO( :, 4,37, 1) = (/&
&2.5232E-05_JPRB,2.8068E-05_JPRB,9.1139E-05_JPRB,1.1630E-04_JPRB,1.2729E-04_JPRB,1.0839E-04_JPRB/)
KBO( :, 5,37, 1) = (/&
&2.7075E-05_JPRB,2.9898E-05_JPRB,9.4071E-05_JPRB,1.1891E-04_JPRB,1.2874E-04_JPRB,1.0822E-04_JPRB/)
KBO( :, 1,38, 1) = (/&
&1.4988E-05_JPRB,1.7289E-05_JPRB,6.6055E-05_JPRB,8.6575E-05_JPRB,9.6855E-05_JPRB,8.6493E-05_JPRB/)
KBO( :, 2,38, 1) = (/&
&1.6918E-05_JPRB,1.9272E-05_JPRB,6.9150E-05_JPRB,8.9996E-05_JPRB,1.0016E-04_JPRB,8.8280E-05_JPRB/)
KBO( :, 3,38, 1) = (/&
&1.8783E-05_JPRB,2.1138E-05_JPRB,7.2026E-05_JPRB,9.2962E-05_JPRB,1.0270E-04_JPRB,8.9275E-05_JPRB/)
KBO( :, 4,38, 1) = (/&
&2.0496E-05_JPRB,2.2834E-05_JPRB,7.4689E-05_JPRB,9.5470E-05_JPRB,1.0459E-04_JPRB,8.9701E-05_JPRB/)
KBO( :, 5,38, 1) = (/&
&2.2016E-05_JPRB,2.4338E-05_JPRB,7.7162E-05_JPRB,9.7704E-05_JPRB,1.0591E-04_JPRB,8.9718E-05_JPRB/)
KBO( :, 1,39, 1) = (/&
&1.2096E-05_JPRB,1.3982E-05_JPRB,5.3949E-05_JPRB,7.0786E-05_JPRB,7.9230E-05_JPRB,7.1287E-05_JPRB/)
KBO( :, 2,39, 1) = (/&
&1.3689E-05_JPRB,1.5620E-05_JPRB,5.6546E-05_JPRB,7.3698E-05_JPRB,8.2063E-05_JPRB,7.2936E-05_JPRB/)
KBO( :, 3,39, 1) = (/&
&1.5231E-05_JPRB,1.7169E-05_JPRB,5.8966E-05_JPRB,7.6225E-05_JPRB,8.4277E-05_JPRB,7.3907E-05_JPRB/)
KBO( :, 4,39, 1) = (/&
&1.6645E-05_JPRB,1.8570E-05_JPRB,6.1204E-05_JPRB,7.8367E-05_JPRB,8.5941E-05_JPRB,7.4418E-05_JPRB/)
KBO( :, 5,39, 1) = (/&
&1.7901E-05_JPRB,1.9810E-05_JPRB,6.3290E-05_JPRB,8.0298E-05_JPRB,8.7131E-05_JPRB,7.4561E-05_JPRB/)
KBO( :, 1,40, 1) = (/&
&9.6276E-06_JPRB,1.1165E-05_JPRB,4.3831E-05_JPRB,5.7599E-05_JPRB,6.4509E-05_JPRB,5.8273E-05_JPRB/)
KBO( :, 2,40, 1) = (/&
&1.0939E-05_JPRB,1.2519E-05_JPRB,4.6024E-05_JPRB,6.0108E-05_JPRB,6.6994E-05_JPRB,5.9810E-05_JPRB/)
KBO( :, 3,40, 1) = (/&
&1.2220E-05_JPRB,1.3814E-05_JPRB,4.8073E-05_JPRB,6.2293E-05_JPRB,6.8988E-05_JPRB,6.0759E-05_JPRB/)
KBO( :, 4,40, 1) = (/&
&1.3401E-05_JPRB,1.4988E-05_JPRB,4.9968E-05_JPRB,6.4170E-05_JPRB,7.0494E-05_JPRB,6.1313E-05_JPRB/)
KBO( :, 5,40, 1) = (/&
&1.4450E-05_JPRB,1.6022E-05_JPRB,5.1742E-05_JPRB,6.5833E-05_JPRB,7.1594E-05_JPRB,6.1539E-05_JPRB/)
KBO( :, 1,41, 1) = (/&
&7.6383E-06_JPRB,8.8906E-06_JPRB,3.5555E-05_JPRB,4.6806E-05_JPRB,5.2458E-05_JPRB,4.7568E-05_JPRB/)
KBO( :, 2,41, 1) = (/&
&8.7190E-06_JPRB,1.0010E-05_JPRB,3.7422E-05_JPRB,4.8972E-05_JPRB,5.4631E-05_JPRB,4.8981E-05_JPRB/)
KBO( :, 3,41, 1) = (/&
&9.7816E-06_JPRB,1.1092E-05_JPRB,3.9150E-05_JPRB,5.0862E-05_JPRB,5.6413E-05_JPRB,4.9899E-05_JPRB/)
KBO( :, 4,41, 1) = (/&
&1.0770E-05_JPRB,1.2078E-05_JPRB,4.0765E-05_JPRB,5.2505E-05_JPRB,5.7788E-05_JPRB,5.0461E-05_JPRB/)
KBO( :, 5,41, 1) = (/&
&1.1650E-05_JPRB,1.2944E-05_JPRB,4.2271E-05_JPRB,5.3948E-05_JPRB,5.8801E-05_JPRB,5.0748E-05_JPRB/)
KBO( :, 1,42, 1) = (/&
&6.0542E-06_JPRB,7.0721E-06_JPRB,2.8820E-05_JPRB,3.8000E-05_JPRB,4.2624E-05_JPRB,3.8819E-05_JPRB/)
KBO( :, 2,42, 1) = (/&
&6.9406E-06_JPRB,7.9951E-06_JPRB,3.0412E-05_JPRB,3.9875E-05_JPRB,4.4529E-05_JPRB,4.0118E-05_JPRB/)
KBO( :, 3,42, 1) = (/&
&7.8202E-06_JPRB,8.8967E-06_JPRB,3.1870E-05_JPRB,4.1509E-05_JPRB,4.6106E-05_JPRB,4.0986E-05_JPRB/)
KBO( :, 4,42, 1) = (/&
&8.6462E-06_JPRB,9.7239E-06_JPRB,3.3236E-05_JPRB,4.2934E-05_JPRB,4.7338E-05_JPRB,4.1549E-05_JPRB/)
KBO( :, 5,42, 1) = (/&
&9.3841E-06_JPRB,1.0450E-05_JPRB,3.4511E-05_JPRB,4.4186E-05_JPRB,4.8277E-05_JPRB,4.1876E-05_JPRB/)
KBO( :, 1,43, 1) = (/&
&4.7535E-06_JPRB,5.5762E-06_JPRB,2.3267E-05_JPRB,3.0725E-05_JPRB,3.4509E-05_JPRB,3.1571E-05_JPRB/)
KBO( :, 2,43, 1) = (/&
&5.4765E-06_JPRB,6.3357E-06_JPRB,2.4631E-05_JPRB,3.2364E-05_JPRB,3.6180E-05_JPRB,3.2776E-05_JPRB/)
KBO( :, 3,43, 1) = (/&
&6.2063E-06_JPRB,7.0878E-06_JPRB,2.5870E-05_JPRB,3.3787E-05_JPRB,3.7588E-05_JPRB,3.3603E-05_JPRB/)
KBO( :, 4,43, 1) = (/&
&6.8971E-06_JPRB,7.7847E-06_JPRB,2.7025E-05_JPRB,3.5030E-05_JPRB,3.8710E-05_JPRB,3.4166E-05_JPRB/)
KBO( :, 5,43, 1) = (/&
&7.5200E-06_JPRB,8.3995E-06_JPRB,2.8111E-05_JPRB,3.6121E-05_JPRB,3.9582E-05_JPRB,3.4523E-05_JPRB/)
KBO( :, 1,44, 1) = (/&
&3.7108E-06_JPRB,4.3735E-06_JPRB,1.8735E-05_JPRB,2.4774E-05_JPRB,2.7859E-05_JPRB,2.5624E-05_JPRB/)
KBO( :, 2,44, 1) = (/&
&4.2986E-06_JPRB,4.9970E-06_JPRB,1.9896E-05_JPRB,2.6202E-05_JPRB,2.9326E-05_JPRB,2.6740E-05_JPRB/)
KBO( :, 3,44, 1) = (/&
&4.9004E-06_JPRB,5.6209E-06_JPRB,2.0953E-05_JPRB,2.7445E-05_JPRB,3.0581E-05_JPRB,2.7533E-05_JPRB/)
KBO( :, 4,44, 1) = (/&
&5.4800E-06_JPRB,6.2094E-06_JPRB,2.1942E-05_JPRB,2.8536E-05_JPRB,3.1606E-05_JPRB,2.8081E-05_JPRB/)
KBO( :, 5,44, 1) = (/&
&6.0067E-06_JPRB,6.7326E-06_JPRB,2.2861E-05_JPRB,2.9489E-05_JPRB,3.2408E-05_JPRB,2.8452E-05_JPRB/)
KBO( :, 1,45, 1) = (/&
&2.8911E-06_JPRB,3.4227E-06_JPRB,1.5064E-05_JPRB,1.9947E-05_JPRB,2.2457E-05_JPRB,2.0791E-05_JPRB/)
KBO( :, 2,45, 1) = (/&
&3.3674E-06_JPRB,3.9335E-06_JPRB,1.6057E-05_JPRB,2.1189E-05_JPRB,2.3743E-05_JPRB,2.1813E-05_JPRB/)
KBO( :, 3,45, 1) = (/&
&3.8624E-06_JPRB,4.4499E-06_JPRB,1.6962E-05_JPRB,2.2274E-05_JPRB,2.4852E-05_JPRB,2.2566E-05_JPRB/)
KBO( :, 4,45, 1) = (/&
&4.3456E-06_JPRB,4.9443E-06_JPRB,1.7794E-05_JPRB,2.3219E-05_JPRB,2.5777E-05_JPRB,2.3098E-05_JPRB/)
KBO( :, 5,45, 1) = (/&
&4.7911E-06_JPRB,5.3898E-06_JPRB,1.8581E-05_JPRB,2.4056E-05_JPRB,2.6509E-05_JPRB,2.3470E-05_JPRB/)
KBO( :, 1,46, 1) = (/&
&2.2383E-06_JPRB,2.6637E-06_JPRB,1.2073E-05_JPRB,1.6011E-05_JPRB,1.8044E-05_JPRB,1.6831E-05_JPRB/)
KBO( :, 2,46, 1) = (/&
&2.6247E-06_JPRB,3.0814E-06_JPRB,1.2921E-05_JPRB,1.7081E-05_JPRB,1.9170E-05_JPRB,1.7760E-05_JPRB/)
KBO( :, 3,46, 1) = (/&
&3.0283E-06_JPRB,3.5061E-06_JPRB,1.3701E-05_JPRB,1.8033E-05_JPRB,2.0150E-05_JPRB,1.8469E-05_JPRB/)
KBO( :, 4,46, 1) = (/&
&3.4307E-06_JPRB,3.9211E-06_JPRB,1.4408E-05_JPRB,1.8862E-05_JPRB,2.0983E-05_JPRB,1.8985E-05_JPRB/)
KBO( :, 5,46, 1) = (/&
&3.8069E-06_JPRB,4.3002E-06_JPRB,1.5076E-05_JPRB,1.9597E-05_JPRB,2.1654E-05_JPRB,1.9353E-05_JPRB/)
KBO( :, 1,47, 1) = (/&
&1.7157E-06_JPRB,2.0538E-06_JPRB,9.6246E-06_JPRB,1.2782E-05_JPRB,1.4416E-05_JPRB,1.3539E-05_JPRB/)
KBO( :, 2,47, 1) = (/&
&2.0274E-06_JPRB,2.3938E-06_JPRB,1.0355E-05_JPRB,1.3710E-05_JPRB,1.5413E-05_JPRB,1.4388E-05_JPRB/)
KBO( :, 3,47, 1) = (/&
&2.3547E-06_JPRB,2.7420E-06_JPRB,1.1027E-05_JPRB,1.4546E-05_JPRB,1.6278E-05_JPRB,1.5051E-05_JPRB/)
KBO( :, 4,47, 1) = (/&
&2.6881E-06_JPRB,3.0885E-06_JPRB,1.1632E-05_JPRB,1.5275E-05_JPRB,1.7026E-05_JPRB,1.5547E-05_JPRB/)
KBO( :, 5,47, 1) = (/&
&3.0058E-06_JPRB,3.4107E-06_JPRB,1.2197E-05_JPRB,1.5919E-05_JPRB,1.7642E-05_JPRB,1.5912E-05_JPRB/)
KBO( :, 1,48, 1) = (/&
&1.3107E-06_JPRB,1.5782E-06_JPRB,7.6508E-06_JPRB,1.0175E-05_JPRB,1.1482E-05_JPRB,1.0883E-05_JPRB/)
KBO( :, 2,48, 1) = (/&
&1.5615E-06_JPRB,1.8540E-06_JPRB,8.2825E-06_JPRB,1.0980E-05_JPRB,1.2364E-05_JPRB,1.1653E-05_JPRB/)
KBO( :, 3,48, 1) = (/&
&1.8258E-06_JPRB,2.1385E-06_JPRB,8.8579E-06_JPRB,1.1710E-05_JPRB,1.3124E-05_JPRB,1.2269E-05_JPRB/)
KBO( :, 4,48, 1) = (/&
&2.0996E-06_JPRB,2.4258E-06_JPRB,9.3784E-06_JPRB,1.2351E-05_JPRB,1.3790E-05_JPRB,1.2743E-05_JPRB/)
KBO( :, 5,48, 1) = (/&
&2.3667E-06_JPRB,2.6988E-06_JPRB,9.8574E-06_JPRB,1.2914E-05_JPRB,1.4353E-05_JPRB,1.3101E-05_JPRB/)
KBO( :, 1,49, 1) = (/&
&9.9722E-07_JPRB,1.2088E-06_JPRB,6.0640E-06_JPRB,8.0714E-06_JPRB,9.1144E-06_JPRB,8.7529E-06_JPRB/)
KBO( :, 2,49, 1) = (/&
&1.1984E-06_JPRB,1.4315E-06_JPRB,6.6089E-06_JPRB,8.7743E-06_JPRB,9.8916E-06_JPRB,9.4492E-06_JPRB/)
KBO( :, 3,49, 1) = (/&
&1.4119E-06_JPRB,1.6631E-06_JPRB,7.1011E-06_JPRB,9.4039E-06_JPRB,1.0560E-05_JPRB,1.0016E-05_JPRB/)
KBO( :, 4,49, 1) = (/&
&1.6351E-06_JPRB,1.8997E-06_JPRB,7.5513E-06_JPRB,9.9685E-06_JPRB,1.1148E-05_JPRB,1.0465E-05_JPRB/)
KBO( :, 5,49, 1) = (/&
&1.8579E-06_JPRB,2.1297E-06_JPRB,7.9577E-06_JPRB,1.0461E-05_JPRB,1.1654E-05_JPRB,1.0817E-05_JPRB/)
KBO( :, 1,50, 1) = (/&
&7.5886E-07_JPRB,9.2721E-07_JPRB,4.8038E-06_JPRB,6.3978E-06_JPRB,7.2231E-06_JPRB,7.0033E-06_JPRB/)
KBO( :, 2,50, 1) = (/&
&9.2100E-07_JPRB,1.1063E-06_JPRB,5.2714E-06_JPRB,7.0056E-06_JPRB,7.9040E-06_JPRB,7.6216E-06_JPRB/)
KBO( :, 3,50, 1) = (/&
&1.0933E-06_JPRB,1.2947E-06_JPRB,5.6945E-06_JPRB,7.5500E-06_JPRB,8.4922E-06_JPRB,8.1346E-06_JPRB/)
KBO( :, 4,50, 1) = (/&
&1.2741E-06_JPRB,1.4882E-06_JPRB,6.0797E-06_JPRB,8.0421E-06_JPRB,9.0066E-06_JPRB,8.5490E-06_JPRB/)
KBO( :, 5,50, 1) = (/&
&1.4586E-06_JPRB,1.6807E-06_JPRB,6.4274E-06_JPRB,8.4750E-06_JPRB,9.4574E-06_JPRB,8.8779E-06_JPRB/)
KBO( :, 1,51, 1) = (/&
&5.7629E-07_JPRB,7.1029E-07_JPRB,3.7943E-06_JPRB,5.0570E-06_JPRB,5.7108E-06_JPRB,5.5791E-06_JPRB/)
KBO( :, 2,51, 1) = (/&
&7.0702E-07_JPRB,8.5393E-07_JPRB,4.1966E-06_JPRB,5.5839E-06_JPRB,6.3056E-06_JPRB,6.1262E-06_JPRB/)
KBO( :, 3,51, 1) = (/&
&8.4587E-07_JPRB,1.0071E-06_JPRB,4.5610E-06_JPRB,6.0549E-06_JPRB,6.8186E-06_JPRB,6.5832E-06_JPRB/)
KBO( :, 4,51, 1) = (/&
&9.9205E-07_JPRB,1.1651E-06_JPRB,4.8914E-06_JPRB,6.4815E-06_JPRB,7.2681E-06_JPRB,6.9582E-06_JPRB/)
KBO( :, 5,51, 1) = (/&
&1.1437E-06_JPRB,1.3245E-06_JPRB,5.1899E-06_JPRB,6.8593E-06_JPRB,7.6670E-06_JPRB,7.2604E-06_JPRB/)
KBO( :, 1,52, 1) = (/&
&4.3584E-07_JPRB,5.4224E-07_JPRB,2.9855E-06_JPRB,3.9817E-06_JPRB,4.4976E-06_JPRB,4.4442E-06_JPRB/)
KBO( :, 2,52, 1) = (/&
&5.4097E-07_JPRB,6.5764E-07_JPRB,3.3334E-06_JPRB,4.4392E-06_JPRB,5.0153E-06_JPRB,4.9246E-06_JPRB/)
KBO( :, 3,52, 1) = (/&
&6.5253E-07_JPRB,7.8129E-07_JPRB,3.6456E-06_JPRB,4.8458E-06_JPRB,5.4625E-06_JPRB,5.3314E-06_JPRB/)
KBO( :, 4,52, 1) = (/&
&7.7086E-07_JPRB,9.1002E-07_JPRB,3.9287E-06_JPRB,5.2127E-06_JPRB,5.8546E-06_JPRB,5.6688E-06_JPRB/)
KBO( :, 5,52, 1) = (/&
&8.9444E-07_JPRB,1.0413E-06_JPRB,4.1837E-06_JPRB,5.5418E-06_JPRB,6.2037E-06_JPRB,5.9475E-06_JPRB/)
KBO( :, 1,53, 1) = (/&
&3.2796E-07_JPRB,4.1214E-07_JPRB,2.3394E-06_JPRB,3.1195E-06_JPRB,3.5262E-06_JPRB,3.5455E-06_JPRB/)
KBO( :, 2,53, 1) = (/&
&4.1213E-07_JPRB,5.0498E-07_JPRB,2.6399E-06_JPRB,3.5184E-06_JPRB,3.9742E-06_JPRB,3.9662E-06_JPRB/)
KBO( :, 3,53, 1) = (/&
&5.0194E-07_JPRB,6.0442E-07_JPRB,2.9073E-06_JPRB,3.8680E-06_JPRB,4.3642E-06_JPRB,4.3273E-06_JPRB/)
KBO( :, 4,53, 1) = (/&
&5.9752E-07_JPRB,7.0914E-07_JPRB,3.1505E-06_JPRB,4.1837E-06_JPRB,4.7059E-06_JPRB,4.6313E-06_JPRB/)
KBO( :, 5,53, 1) = (/&
&6.9765E-07_JPRB,8.1659E-07_JPRB,3.3684E-06_JPRB,4.4697E-06_JPRB,5.0106E-06_JPRB,4.8882E-06_JPRB/)
KBO( :, 1,54, 1) = (/&
&2.4768E-07_JPRB,3.1412E-07_JPRB,1.8333E-06_JPRB,2.4420E-06_JPRB,2.7649E-06_JPRB,2.7862E-06_JPRB/)
KBO( :, 2,54, 1) = (/&
&3.1476E-07_JPRB,3.8873E-07_JPRB,2.0902E-06_JPRB,2.7876E-06_JPRB,3.1500E-06_JPRB,3.1426E-06_JPRB/)
KBO( :, 3,54, 1) = (/&
&3.8724E-07_JPRB,4.6872E-07_JPRB,2.3192E-06_JPRB,3.0882E-06_JPRB,3.4874E-06_JPRB,3.4564E-06_JPRB/)
KBO( :, 4,54, 1) = (/&
&4.6434E-07_JPRB,5.5384E-07_JPRB,2.5276E-06_JPRB,3.3593E-06_JPRB,3.7832E-06_JPRB,3.7206E-06_JPRB/)
KBO( :, 5,54, 1) = (/&
&5.4537E-07_JPRB,6.4156E-07_JPRB,2.7141E-06_JPRB,3.6064E-06_JPRB,4.0468E-06_JPRB,3.9453E-06_JPRB/)
KBO( :, 1,55, 1) = (/&
&1.8693E-07_JPRB,2.3927E-07_JPRB,1.4336E-06_JPRB,1.9074E-06_JPRB,2.1635E-06_JPRB,2.1619E-06_JPRB/)
KBO( :, 2,55, 1) = (/&
&2.4025E-07_JPRB,2.9918E-07_JPRB,1.6519E-06_JPRB,2.2048E-06_JPRB,2.4926E-06_JPRB,2.4604E-06_JPRB/)
KBO( :, 3,55, 1) = (/&
&2.9872E-07_JPRB,3.6360E-07_JPRB,1.8488E-06_JPRB,2.4633E-06_JPRB,2.7832E-06_JPRB,2.7282E-06_JPRB/)
KBO( :, 4,55, 1) = (/&
&3.6075E-07_JPRB,4.3251E-07_JPRB,2.0265E-06_JPRB,2.6954E-06_JPRB,3.0391E-06_JPRB,2.9551E-06_JPRB/)
KBO( :, 5,55, 1) = (/&
&4.2648E-07_JPRB,5.0404E-07_JPRB,2.1855E-06_JPRB,2.9070E-06_JPRB,3.2663E-06_JPRB,3.1458E-06_JPRB/)
KBO( :, 1,56, 1) = (/&
&1.4054E-07_JPRB,1.8176E-07_JPRB,1.1161E-06_JPRB,1.4834E-06_JPRB,1.6858E-06_JPRB,1.6706E-06_JPRB/)
KBO( :, 2,56, 1) = (/&
&1.8272E-07_JPRB,2.2962E-07_JPRB,1.3014E-06_JPRB,1.7377E-06_JPRB,1.9656E-06_JPRB,1.9215E-06_JPRB/)
KBO( :, 3,56, 1) = (/&
&2.2968E-07_JPRB,2.8144E-07_JPRB,1.4702E-06_JPRB,1.9602E-06_JPRB,2.2149E-06_JPRB,2.1478E-06_JPRB/)
KBO( :, 4,56, 1) = (/&
&2.7973E-07_JPRB,3.3709E-07_JPRB,1.6219E-06_JPRB,2.1586E-06_JPRB,2.4358E-06_JPRB,2.3428E-06_JPRB/)
KBO( :, 5,56, 1) = (/&
&3.3292E-07_JPRB,3.9535E-07_JPRB,1.7578E-06_JPRB,2.3398E-06_JPRB,2.6321E-06_JPRB,2.5058E-06_JPRB/)
KBO( :, 1,57, 1) = (/&
&1.0510E-07_JPRB,1.3750E-07_JPRB,8.6405E-07_JPRB,1.1473E-06_JPRB,1.3076E-06_JPRB,1.2850E-06_JPRB/)
KBO( :, 2,57, 1) = (/&
&1.3849E-07_JPRB,1.7560E-07_JPRB,1.0222E-06_JPRB,1.3638E-06_JPRB,1.5446E-06_JPRB,1.4961E-06_JPRB/)
KBO( :, 3,57, 1) = (/&
&1.7599E-07_JPRB,2.1727E-07_JPRB,1.1659E-06_JPRB,1.5556E-06_JPRB,1.7583E-06_JPRB,1.6859E-06_JPRB/)
KBO( :, 4,57, 1) = (/&
&2.1642E-07_JPRB,2.6216E-07_JPRB,1.2954E-06_JPRB,1.7252E-06_JPRB,1.9483E-06_JPRB,1.8528E-06_JPRB/)
KBO( :, 5,57, 1) = (/&
&2.5937E-07_JPRB,3.0954E-07_JPRB,1.4120E-06_JPRB,1.8802E-06_JPRB,2.1177E-06_JPRB,1.9931E-06_JPRB/)
KBO( :, 1,58, 1) = (/&
&7.8562E-08_JPRB,1.0412E-07_JPRB,6.6697E-07_JPRB,8.8547E-07_JPRB,1.0122E-06_JPRB,9.8359E-07_JPRB/)
KBO( :, 2,58, 1) = (/&
&1.0505E-07_JPRB,1.3435E-07_JPRB,8.0186E-07_JPRB,1.0688E-06_JPRB,1.2123E-06_JPRB,1.1602E-06_JPRB/)
KBO( :, 3,58, 1) = (/&
&1.3491E-07_JPRB,1.6781E-07_JPRB,9.2343E-07_JPRB,1.2330E-06_JPRB,1.3947E-06_JPRB,1.3189E-06_JPRB/)
KBO( :, 4,58, 1) = (/&
&1.6755E-07_JPRB,2.0398E-07_JPRB,1.0341E-06_JPRB,1.3781E-06_JPRB,1.5576E-06_JPRB,1.4600E-06_JPRB/)
KBO( :, 5,58, 1) = (/&
&2.0219E-07_JPRB,2.4245E-07_JPRB,1.1337E-06_JPRB,1.5104E-06_JPRB,1.7029E-06_JPRB,1.5797E-06_JPRB/)
KBO( :, 1,59, 1) = (/&
&6.2032E-08_JPRB,8.2667E-08_JPRB,5.3358E-07_JPRB,7.0860E-07_JPRB,8.1061E-07_JPRB,7.5992E-07_JPRB/)
KBO( :, 2,59, 1) = (/&
&8.3464E-08_JPRB,1.0714E-07_JPRB,6.4596E-07_JPRB,8.6092E-07_JPRB,9.7714E-07_JPRB,9.0330E-07_JPRB/)
KBO( :, 3,59, 1) = (/&
&1.0772E-07_JPRB,1.3445E-07_JPRB,7.4727E-07_JPRB,9.9822E-07_JPRB,1.1293E-06_JPRB,1.0310E-06_JPRB/)
KBO( :, 4,59, 1) = (/&
&1.3434E-07_JPRB,1.6394E-07_JPRB,8.4000E-07_JPRB,1.1197E-06_JPRB,1.2658E-06_JPRB,1.1431E-06_JPRB/)
KBO( :, 5,59, 1) = (/&
&1.6260E-07_JPRB,1.9540E-07_JPRB,9.2328E-07_JPRB,1.2307E-06_JPRB,1.3881E-06_JPRB,1.2388E-06_JPRB/)
KBO( :, 1,13, 2) = (/&
&3.6523E-03_JPRB,3.8939E-03_JPRB,1.9272E-02_JPRB,2.7740E-02_JPRB,3.3512E-02_JPRB,3.3627E-02_JPRB/)
KBO( :, 2,13, 2) = (/&
&4.0698E-03_JPRB,4.3006E-03_JPRB,2.0140E-02_JPRB,2.9159E-02_JPRB,3.5603E-02_JPRB,3.6375E-02_JPRB/)
KBO( :, 3,13, 2) = (/&
&4.4412E-03_JPRB,4.6650E-03_JPRB,2.0907E-02_JPRB,3.0329E-02_JPRB,3.7178E-02_JPRB,3.8732E-02_JPRB/)
KBO( :, 4,13, 2) = (/&
&4.7483E-03_JPRB,4.9652E-03_JPRB,2.1592E-02_JPRB,3.1266E-02_JPRB,3.8222E-02_JPRB,4.0514E-02_JPRB/)
KBO( :, 5,13, 2) = (/&
&4.9829E-03_JPRB,5.1938E-03_JPRB,2.2168E-02_JPRB,3.1969E-02_JPRB,3.8794E-02_JPRB,4.1741E-02_JPRB/)
KBO( :, 1,14, 2) = (/&
&3.0865E-03_JPRB,3.3200E-03_JPRB,1.6531E-02_JPRB,2.3817E-02_JPRB,2.8897E-02_JPRB,2.8142E-02_JPRB/)
KBO( :, 2,14, 2) = (/&
&3.4362E-03_JPRB,3.6603E-03_JPRB,1.7252E-02_JPRB,2.4966E-02_JPRB,3.0545E-02_JPRB,3.0211E-02_JPRB/)
KBO( :, 3,14, 2) = (/&
&3.7431E-03_JPRB,3.9586E-03_JPRB,1.7899E-02_JPRB,2.5891E-02_JPRB,3.1684E-02_JPRB,3.1824E-02_JPRB/)
KBO( :, 4,14, 2) = (/&
&3.9872E-03_JPRB,4.1955E-03_JPRB,1.8459E-02_JPRB,2.6594E-02_JPRB,3.2362E-02_JPRB,3.2907E-02_JPRB/)
KBO( :, 5,14, 2) = (/&
&4.1703E-03_JPRB,4.3748E-03_JPRB,1.8911E-02_JPRB,2.7074E-02_JPRB,3.2683E-02_JPRB,3.3591E-02_JPRB/)
KBO( :, 1,15, 2) = (/&
&2.6115E-03_JPRB,2.8311E-03_JPRB,1.4085E-02_JPRB,2.0304E-02_JPRB,2.4710E-02_JPRB,2.3514E-02_JPRB/)
KBO( :, 2,15, 2) = (/&
&2.9041E-03_JPRB,3.1144E-03_JPRB,1.4680E-02_JPRB,2.1210E-02_JPRB,2.5931E-02_JPRB,2.4999E-02_JPRB/)
KBO( :, 3,15, 2) = (/&
&3.1530E-03_JPRB,3.3540E-03_JPRB,1.5212E-02_JPRB,2.1904E-02_JPRB,2.6711E-02_JPRB,2.6064E-02_JPRB/)
KBO( :, 4,15, 2) = (/&
&3.3446E-03_JPRB,3.5395E-03_JPRB,1.5641E-02_JPRB,2.2409E-02_JPRB,2.7141E-02_JPRB,2.6755E-02_JPRB/)
KBO( :, 5,15, 2) = (/&
&3.4849E-03_JPRB,3.6794E-03_JPRB,1.5995E-02_JPRB,2.2750E-02_JPRB,2.7330E-02_JPRB,2.7152E-02_JPRB/)
KBO( :, 1,16, 2) = (/&
&2.2129E-03_JPRB,2.4168E-03_JPRB,1.1928E-02_JPRB,1.7179E-02_JPRB,2.0938E-02_JPRB,1.9617E-02_JPRB/)
KBO( :, 2,16, 2) = (/&
&2.4536E-03_JPRB,2.6491E-03_JPRB,1.2409E-02_JPRB,1.7866E-02_JPRB,2.1799E-02_JPRB,2.0682E-02_JPRB/)
KBO( :, 3,16, 2) = (/&
&2.6514E-03_JPRB,2.8384E-03_JPRB,1.2822E-02_JPRB,1.8380E-02_JPRB,2.2338E-02_JPRB,2.1426E-02_JPRB/)
KBO( :, 4,16, 2) = (/&
&2.7951E-03_JPRB,2.9778E-03_JPRB,1.3157E-02_JPRB,1.8769E-02_JPRB,2.2630E-02_JPRB,2.1902E-02_JPRB/)
KBO( :, 5,16, 2) = (/&
&2.9036E-03_JPRB,3.0860E-03_JPRB,1.3435E-02_JPRB,1.9027E-02_JPRB,2.2746E-02_JPRB,2.2146E-02_JPRB/)
KBO( :, 1,17, 2) = (/&
&1.8735E-03_JPRB,2.0627E-03_JPRB,1.0036E-02_JPRB,1.4424E-02_JPRB,1.7577E-02_JPRB,1.6265E-02_JPRB/)
KBO( :, 2,17, 2) = (/&
&2.0662E-03_JPRB,2.2488E-03_JPRB,1.0418E-02_JPRB,1.4944E-02_JPRB,1.8199E-02_JPRB,1.7052E-02_JPRB/)
KBO( :, 3,17, 2) = (/&
&2.2194E-03_JPRB,2.3925E-03_JPRB,1.0739E-02_JPRB,1.5350E-02_JPRB,1.8589E-02_JPRB,1.7595E-02_JPRB/)
KBO( :, 4,17, 2) = (/&
&2.3291E-03_JPRB,2.4990E-03_JPRB,1.1009E-02_JPRB,1.5656E-02_JPRB,1.8796E-02_JPRB,1.7924E-02_JPRB/)
KBO( :, 5,17, 2) = (/&
&2.4168E-03_JPRB,2.5869E-03_JPRB,1.1220E-02_JPRB,1.5867E-02_JPRB,1.8872E-02_JPRB,1.8072E-02_JPRB/)
KBO( :, 1,18, 2) = (/&
&1.5803E-03_JPRB,1.7549E-03_JPRB,8.3982E-03_JPRB,1.2038E-02_JPRB,1.4657E-02_JPRB,1.3443E-02_JPRB/)
KBO( :, 2,18, 2) = (/&
&1.7325E-03_JPRB,1.9010E-03_JPRB,8.7001E-03_JPRB,1.2445E-02_JPRB,1.5124E-02_JPRB,1.4037E-02_JPRB/)
KBO( :, 3,18, 2) = (/&
&1.8506E-03_JPRB,2.0095E-03_JPRB,8.9599E-03_JPRB,1.2773E-02_JPRB,1.5415E-02_JPRB,1.4442E-02_JPRB/)
KBO( :, 4,18, 2) = (/&
&1.9372E-03_JPRB,2.0945E-03_JPRB,9.1682E-03_JPRB,1.3023E-02_JPRB,1.5571E-02_JPRB,1.4673E-02_JPRB/)
KBO( :, 5,18, 2) = (/&
&2.0086E-03_JPRB,2.1668E-03_JPRB,9.3360E-03_JPRB,1.3189E-02_JPRB,1.5627E-02_JPRB,1.4767E-02_JPRB/)
KBO( :, 1,19, 2) = (/&
&1.3263E-03_JPRB,1.4842E-03_JPRB,6.9965E-03_JPRB,1.0005E-02_JPRB,1.2171E-02_JPRB,1.1073E-02_JPRB/)
KBO( :, 2,19, 2) = (/&
&1.4463E-03_JPRB,1.5975E-03_JPRB,7.2420E-03_JPRB,1.0335E-02_JPRB,1.2532E-02_JPRB,1.1527E-02_JPRB/)
KBO( :, 3,19, 2) = (/&
&1.5391E-03_JPRB,1.6819E-03_JPRB,7.4473E-03_JPRB,1.0605E-02_JPRB,1.2756E-02_JPRB,1.1825E-02_JPRB/)
KBO( :, 4,19, 2) = (/&
&1.6087E-03_JPRB,1.7515E-03_JPRB,7.6132E-03_JPRB,1.0806E-02_JPRB,1.2879E-02_JPRB,1.1987E-02_JPRB/)
KBO( :, 5,19, 2) = (/&
&1.6667E-03_JPRB,1.8113E-03_JPRB,7.7489E-03_JPRB,1.0927E-02_JPRB,1.2923E-02_JPRB,1.2042E-02_JPRB/)
KBO( :, 1,20, 2) = (/&
&1.1106E-03_JPRB,1.2504E-03_JPRB,5.8179E-03_JPRB,8.3016E-03_JPRB,1.0088E-02_JPRB,9.1254E-03_JPRB/)
KBO( :, 2,20, 2) = (/&
&1.2060E-03_JPRB,1.3385E-03_JPRB,6.0163E-03_JPRB,8.5726E-03_JPRB,1.0368E-02_JPRB,9.4723E-03_JPRB/)
KBO( :, 3,20, 2) = (/&
&1.2789E-03_JPRB,1.4052E-03_JPRB,6.1769E-03_JPRB,8.7907E-03_JPRB,1.0541E-02_JPRB,9.6942E-03_JPRB/)
KBO( :, 4,20, 2) = (/&
&1.3351E-03_JPRB,1.4622E-03_JPRB,6.3118E-03_JPRB,8.9433E-03_JPRB,1.0640E-02_JPRB,9.8077E-03_JPRB/)
KBO( :, 5,20, 2) = (/&
&1.3825E-03_JPRB,1.5123E-03_JPRB,6.4218E-03_JPRB,9.0350E-03_JPRB,1.0672E-02_JPRB,9.8366E-03_JPRB/)
KBO( :, 1,21, 2) = (/&
&9.2789E-04_JPRB,1.0499E-03_JPRB,4.8309E-03_JPRB,6.8776E-03_JPRB,8.3442E-03_JPRB,7.5157E-03_JPRB/)
KBO( :, 2,21, 2) = (/&
&1.0039E-03_JPRB,1.1183E-03_JPRB,4.9870E-03_JPRB,7.1016E-03_JPRB,8.5650E-03_JPRB,7.7816E-03_JPRB/)
KBO( :, 3,21, 2) = (/&
&1.0617E-03_JPRB,1.1723E-03_JPRB,5.1161E-03_JPRB,7.2723E-03_JPRB,8.7032E-03_JPRB,7.9463E-03_JPRB/)
KBO( :, 4,21, 2) = (/&
&1.1070E-03_JPRB,1.2185E-03_JPRB,5.2236E-03_JPRB,7.3886E-03_JPRB,8.7799E-03_JPRB,8.0257E-03_JPRB/)
KBO( :, 5,21, 2) = (/&
&1.1455E-03_JPRB,1.2607E-03_JPRB,5.3143E-03_JPRB,7.4590E-03_JPRB,8.7976E-03_JPRB,8.0381E-03_JPRB/)
KBO( :, 1,22, 2) = (/&
&7.7838E-04_JPRB,8.8274E-04_JPRB,4.0143E-03_JPRB,5.7070E-03_JPRB,6.9079E-03_JPRB,6.2019E-03_JPRB/)
KBO( :, 2,22, 2) = (/&
&8.3803E-04_JPRB,9.3549E-04_JPRB,4.1360E-03_JPRB,5.8838E-03_JPRB,7.0782E-03_JPRB,6.4006E-03_JPRB/)
KBO( :, 3,22, 2) = (/&
&8.8314E-04_JPRB,9.7914E-04_JPRB,4.2374E-03_JPRB,6.0145E-03_JPRB,7.1845E-03_JPRB,6.5168E-03_JPRB/)
KBO( :, 4,22, 2) = (/&
&9.1968E-04_JPRB,1.0165E-03_JPRB,4.3241E-03_JPRB,6.1026E-03_JPRB,7.2358E-03_JPRB,6.5682E-03_JPRB/)
KBO( :, 5,22, 2) = (/&
&9.5047E-04_JPRB,1.0512E-03_JPRB,4.4012E-03_JPRB,6.1547E-03_JPRB,7.2428E-03_JPRB,6.5673E-03_JPRB/)
KBO( :, 1,23, 2) = (/&
&6.5215E-04_JPRB,7.4036E-04_JPRB,3.3305E-03_JPRB,4.7319E-03_JPRB,5.7142E-03_JPRB,5.1137E-03_JPRB/)
KBO( :, 2,23, 2) = (/&
&6.9894E-04_JPRB,7.8162E-04_JPRB,3.4264E-03_JPRB,4.8693E-03_JPRB,5.8456E-03_JPRB,5.2602E-03_JPRB/)
KBO( :, 3,23, 2) = (/&
&7.3388E-04_JPRB,8.1618E-04_JPRB,3.5078E-03_JPRB,4.9682E-03_JPRB,5.9222E-03_JPRB,5.3417E-03_JPRB/)
KBO( :, 4,23, 2) = (/&
&7.6333E-04_JPRB,8.4695E-04_JPRB,3.5799E-03_JPRB,5.0349E-03_JPRB,5.9564E-03_JPRB,5.3733E-03_JPRB/)
KBO( :, 5,23, 2) = (/&
&7.8904E-04_JPRB,8.7612E-04_JPRB,3.6454E-03_JPRB,5.0755E-03_JPRB,5.9574E-03_JPRB,5.3648E-03_JPRB/)
KBO( :, 1,24, 2) = (/&
&5.4610E-04_JPRB,6.1977E-04_JPRB,2.7598E-03_JPRB,3.9203E-03_JPRB,4.7245E-03_JPRB,4.2113E-03_JPRB/)
KBO( :, 2,24, 2) = (/&
&5.8222E-04_JPRB,6.5205E-04_JPRB,2.8366E-03_JPRB,4.0258E-03_JPRB,4.8222E-03_JPRB,4.3180E-03_JPRB/)
KBO( :, 3,24, 2) = (/&
&6.0969E-04_JPRB,6.7974E-04_JPRB,2.9034E-03_JPRB,4.1010E-03_JPRB,4.8778E-03_JPRB,4.3739E-03_JPRB/)
KBO( :, 4,24, 2) = (/&
&6.3347E-04_JPRB,7.0509E-04_JPRB,2.9644E-03_JPRB,4.1523E-03_JPRB,4.8995E-03_JPRB,4.3910E-03_JPRB/)
KBO( :, 5,24, 2) = (/&
&6.5545E-04_JPRB,7.3021E-04_JPRB,3.0198E-03_JPRB,4.1861E-03_JPRB,4.8976E-03_JPRB,4.3789E-03_JPRB/)
KBO( :, 1,25, 2) = (/&
&4.5690E-04_JPRB,5.1793E-04_JPRB,2.2852E-03_JPRB,3.2458E-03_JPRB,3.9043E-03_JPRB,3.4680E-03_JPRB/)
KBO( :, 2,25, 2) = (/&
&4.8458E-04_JPRB,5.4334E-04_JPRB,2.3475E-03_JPRB,3.3264E-03_JPRB,3.9752E-03_JPRB,3.5434E-03_JPRB/)
KBO( :, 3,25, 2) = (/&
&5.0654E-04_JPRB,5.6573E-04_JPRB,2.4036E-03_JPRB,3.3847E-03_JPRB,4.0147E-03_JPRB,3.5813E-03_JPRB/)
KBO( :, 4,25, 2) = (/&
&5.2568E-04_JPRB,5.8676E-04_JPRB,2.4547E-03_JPRB,3.4258E-03_JPRB,4.0284E-03_JPRB,3.5893E-03_JPRB/)
KBO( :, 5,25, 2) = (/&
&5.4469E-04_JPRB,6.0841E-04_JPRB,2.5000E-03_JPRB,3.4530E-03_JPRB,4.0252E-03_JPRB,3.5735E-03_JPRB/)
KBO( :, 1,26, 2) = (/&
&3.8205E-04_JPRB,4.3242E-04_JPRB,1.8925E-03_JPRB,2.6857E-03_JPRB,3.2237E-03_JPRB,2.8541E-03_JPRB/)
KBO( :, 2,26, 2) = (/&
&4.0335E-04_JPRB,4.5263E-04_JPRB,1.9438E-03_JPRB,2.7484E-03_JPRB,3.2757E-03_JPRB,2.9087E-03_JPRB/)
KBO( :, 3,26, 2) = (/&
&4.2092E-04_JPRB,4.7075E-04_JPRB,1.9904E-03_JPRB,2.7942E-03_JPRB,3.3026E-03_JPRB,2.9324E-03_JPRB/)
KBO( :, 4,26, 2) = (/&
&4.3655E-04_JPRB,4.8821E-04_JPRB,2.0326E-03_JPRB,2.8271E-03_JPRB,3.3119E-03_JPRB,2.9344E-03_JPRB/)
KBO( :, 5,26, 2) = (/&
&4.5316E-04_JPRB,5.0712E-04_JPRB,2.0685E-03_JPRB,2.8499E-03_JPRB,3.3084E-03_JPRB,2.9162E-03_JPRB/)
KBO( :, 1,27, 2) = (/&
&3.1896E-04_JPRB,3.6052E-04_JPRB,1.5673E-03_JPRB,2.2211E-03_JPRB,2.6601E-03_JPRB,2.3492E-03_JPRB/)
KBO( :, 2,27, 2) = (/&
&3.3544E-04_JPRB,3.7654E-04_JPRB,1.6095E-03_JPRB,2.2697E-03_JPRB,2.6969E-03_JPRB,2.3868E-03_JPRB/)
KBO( :, 3,27, 2) = (/&
&3.4965E-04_JPRB,3.9143E-04_JPRB,1.6478E-03_JPRB,2.3068E-03_JPRB,2.7163E-03_JPRB,2.4023E-03_JPRB/)
KBO( :, 4,27, 2) = (/&
&3.6268E-04_JPRB,4.0612E-04_JPRB,1.6818E-03_JPRB,2.3333E-03_JPRB,2.7227E-03_JPRB,2.3999E-03_JPRB/)
KBO( :, 5,27, 2) = (/&
&3.7708E-04_JPRB,4.2263E-04_JPRB,1.7104E-03_JPRB,2.3514E-03_JPRB,2.7191E-03_JPRB,2.3811E-03_JPRB/)
KBO( :, 1,28, 2) = (/&
&2.6585E-04_JPRB,3.0014E-04_JPRB,1.2979E-03_JPRB,1.8363E-03_JPRB,2.1935E-03_JPRB,1.9332E-03_JPRB/)
KBO( :, 2,28, 2) = (/&
&2.7887E-04_JPRB,3.1300E-04_JPRB,1.3325E-03_JPRB,1.8753E-03_JPRB,2.2207E-03_JPRB,1.9593E-03_JPRB/)
KBO( :, 3,28, 2) = (/&
&2.9041E-04_JPRB,3.2530E-04_JPRB,1.3637E-03_JPRB,1.9047E-03_JPRB,2.2348E-03_JPRB,1.9687E-03_JPRB/)
KBO( :, 4,28, 2) = (/&
&3.0139E-04_JPRB,3.3786E-04_JPRB,1.3910E-03_JPRB,1.9260E-03_JPRB,2.2395E-03_JPRB,1.9637E-03_JPRB/)
KBO( :, 5,28, 2) = (/&
&3.1381E-04_JPRB,3.5218E-04_JPRB,1.4147E-03_JPRB,1.9395E-03_JPRB,2.2363E-03_JPRB,1.9458E-03_JPRB/)
KBO( :, 1,29, 2) = (/&
&2.2143E-04_JPRB,2.4968E-04_JPRB,1.0748E-03_JPRB,1.5182E-03_JPRB,1.8078E-03_JPRB,1.5923E-03_JPRB/)
KBO( :, 2,29, 2) = (/&
&2.3186E-04_JPRB,2.6016E-04_JPRB,1.1033E-03_JPRB,1.5493E-03_JPRB,1.8281E-03_JPRB,1.6104E-03_JPRB/)
KBO( :, 3,29, 2) = (/&
&2.4121E-04_JPRB,2.7036E-04_JPRB,1.1285E-03_JPRB,1.5726E-03_JPRB,1.8388E-03_JPRB,1.6155E-03_JPRB/)
KBO( :, 4,29, 2) = (/&
&2.5062E-04_JPRB,2.8128E-04_JPRB,1.1506E-03_JPRB,1.5888E-03_JPRB,1.8420E-03_JPRB,1.6082E-03_JPRB/)
KBO( :, 5,29, 2) = (/&
&2.6130E-04_JPRB,2.9358E-04_JPRB,1.1704E-03_JPRB,1.5992E-03_JPRB,1.8391E-03_JPRB,1.5924E-03_JPRB/)
KBO( :, 1,30, 2) = (/&
&1.8434E-04_JPRB,2.0754E-04_JPRB,8.9026E-04_JPRB,1.2554E-03_JPRB,1.4899E-03_JPRB,1.3119E-03_JPRB/)
KBO( :, 2,30, 2) = (/&
&1.9271E-04_JPRB,2.1620E-04_JPRB,9.1339E-04_JPRB,1.2800E-03_JPRB,1.5055E-03_JPRB,1.3245E-03_JPRB/)
KBO( :, 3,30, 2) = (/&
&2.0034E-04_JPRB,2.2477E-04_JPRB,9.3373E-04_JPRB,1.2981E-03_JPRB,1.5133E-03_JPRB,1.3262E-03_JPRB/)
KBO( :, 4,30, 2) = (/&
&2.0838E-04_JPRB,2.3416E-04_JPRB,9.5188E-04_JPRB,1.3104E-03_JPRB,1.5159E-03_JPRB,1.3190E-03_JPRB/)
KBO( :, 5,30, 2) = (/&
&2.1766E-04_JPRB,2.4475E-04_JPRB,9.6842E-04_JPRB,1.3190E-03_JPRB,1.5130E-03_JPRB,1.3047E-03_JPRB/)
KBO( :, 1,31, 2) = (/&
&1.5342E-04_JPRB,1.7254E-04_JPRB,7.3736E-04_JPRB,1.0379E-03_JPRB,1.2280E-03_JPRB,1.0823E-03_JPRB/)
KBO( :, 2,31, 2) = (/&
&1.6018E-04_JPRB,1.7972E-04_JPRB,7.5593E-04_JPRB,1.0574E-03_JPRB,1.2397E-03_JPRB,1.0908E-03_JPRB/)
KBO( :, 3,31, 2) = (/&
&1.6648E-04_JPRB,1.8697E-04_JPRB,7.7274E-04_JPRB,1.0714E-03_JPRB,1.2460E-03_JPRB,1.0906E-03_JPRB/)
KBO( :, 4,31, 2) = (/&
&1.7342E-04_JPRB,1.9506E-04_JPRB,7.8773E-04_JPRB,1.0812E-03_JPRB,1.2476E-03_JPRB,1.0837E-03_JPRB/)
KBO( :, 5,31, 2) = (/&
&1.8149E-04_JPRB,2.0420E-04_JPRB,8.0154E-04_JPRB,1.0881E-03_JPRB,1.2445E-03_JPRB,1.0711E-03_JPRB/)
KBO( :, 1,32, 2) = (/&
&1.2767E-04_JPRB,1.4347E-04_JPRB,6.1066E-04_JPRB,8.5823E-04_JPRB,1.0121E-03_JPRB,8.9310E-04_JPRB/)
KBO( :, 2,32, 2) = (/&
&1.3312E-04_JPRB,1.4941E-04_JPRB,6.2581E-04_JPRB,8.7345E-04_JPRB,1.0214E-03_JPRB,8.9860E-04_JPRB/)
KBO( :, 3,32, 2) = (/&
&1.3844E-04_JPRB,1.5562E-04_JPRB,6.3952E-04_JPRB,8.8432E-04_JPRB,1.0259E-03_JPRB,8.9742E-04_JPRB/)
KBO( :, 4,32, 2) = (/&
&1.4447E-04_JPRB,1.6260E-04_JPRB,6.5205E-04_JPRB,8.9226E-04_JPRB,1.0266E-03_JPRB,8.9098E-04_JPRB/)
KBO( :, 5,32, 2) = (/&
&1.5144E-04_JPRB,1.7054E-04_JPRB,6.6359E-04_JPRB,8.9794E-04_JPRB,1.0240E-03_JPRB,8.8056E-04_JPRB/)
KBO( :, 1,33, 2) = (/&
&1.0619E-04_JPRB,1.1931E-04_JPRB,5.0573E-04_JPRB,7.0964E-04_JPRB,8.3455E-04_JPRB,7.3747E-04_JPRB/)
KBO( :, 2,33, 2) = (/&
&1.1061E-04_JPRB,1.2424E-04_JPRB,5.1808E-04_JPRB,7.2136E-04_JPRB,8.4148E-04_JPRB,7.4075E-04_JPRB/)
KBO( :, 3,33, 2) = (/&
&1.1517E-04_JPRB,1.2959E-04_JPRB,5.2944E-04_JPRB,7.3007E-04_JPRB,8.4469E-04_JPRB,7.3913E-04_JPRB/)
KBO( :, 4,33, 2) = (/&
&1.2041E-04_JPRB,1.3563E-04_JPRB,5.3985E-04_JPRB,7.3647E-04_JPRB,8.4479E-04_JPRB,7.3349E-04_JPRB/)
KBO( :, 5,33, 2) = (/&
&1.2648E-04_JPRB,1.4256E-04_JPRB,5.4947E-04_JPRB,7.4123E-04_JPRB,8.4271E-04_JPRB,7.2498E-04_JPRB/)
KBO( :, 1,34, 2) = (/&
&8.8157E-05_JPRB,9.9062E-05_JPRB,4.1842E-04_JPRB,5.8633E-04_JPRB,6.8789E-04_JPRB,6.0807E-04_JPRB/)
KBO( :, 2,34, 2) = (/&
&9.1811E-05_JPRB,1.0321E-04_JPRB,4.2863E-04_JPRB,5.9556E-04_JPRB,6.9312E-04_JPRB,6.1023E-04_JPRB/)
KBO( :, 3,34, 2) = (/&
&9.5729E-05_JPRB,1.0782E-04_JPRB,4.3808E-04_JPRB,6.0259E-04_JPRB,6.9556E-04_JPRB,6.0848E-04_JPRB/)
KBO( :, 4,34, 2) = (/&
&1.0025E-04_JPRB,1.1302E-04_JPRB,4.4678E-04_JPRB,6.0791E-04_JPRB,6.9562E-04_JPRB,6.0393E-04_JPRB/)
KBO( :, 5,34, 2) = (/&
&1.0555E-04_JPRB,1.1907E-04_JPRB,4.5478E-04_JPRB,6.1180E-04_JPRB,6.9395E-04_JPRB,5.9689E-04_JPRB/)
KBO( :, 1,35, 2) = (/&
&7.2889E-05_JPRB,8.1925E-05_JPRB,3.4533E-04_JPRB,4.8352E-04_JPRB,5.6643E-04_JPRB,5.0117E-04_JPRB/)
KBO( :, 2,35, 2) = (/&
&7.5938E-05_JPRB,8.5438E-05_JPRB,3.5394E-04_JPRB,4.9121E-04_JPRB,5.7081E-04_JPRB,5.0282E-04_JPRB/)
KBO( :, 3,35, 2) = (/&
&7.9261E-05_JPRB,8.9337E-05_JPRB,3.6188E-04_JPRB,4.9693E-04_JPRB,5.7284E-04_JPRB,5.0143E-04_JPRB/)
KBO( :, 4,35, 2) = (/&
&8.3119E-05_JPRB,9.3779E-05_JPRB,3.6918E-04_JPRB,5.0156E-04_JPRB,5.7314E-04_JPRB,4.9808E-04_JPRB/)
KBO( :, 5,35, 2) = (/&
&8.7666E-05_JPRB,9.8982E-05_JPRB,3.7599E-04_JPRB,5.0487E-04_JPRB,5.7194E-04_JPRB,4.9242E-04_JPRB/)
KBO( :, 1,36, 2) = (/&
&5.9995E-05_JPRB,6.7468E-05_JPRB,2.8433E-04_JPRB,3.9801E-04_JPRB,4.6610E-04_JPRB,4.1281E-04_JPRB/)
KBO( :, 2,36, 2) = (/&
&6.2532E-05_JPRB,7.0399E-05_JPRB,2.9160E-04_JPRB,4.0447E-04_JPRB,4.6992E-04_JPRB,4.1443E-04_JPRB/)
KBO( :, 3,36, 2) = (/&
&6.5308E-05_JPRB,7.3661E-05_JPRB,2.9838E-04_JPRB,4.0950E-04_JPRB,4.7187E-04_JPRB,4.1372E-04_JPRB/)
KBO( :, 4,36, 2) = (/&
&6.8562E-05_JPRB,7.7412E-05_JPRB,3.0448E-04_JPRB,4.1355E-04_JPRB,4.7234E-04_JPRB,4.1122E-04_JPRB/)
KBO( :, 5,36, 2) = (/&
&7.2367E-05_JPRB,8.1795E-05_JPRB,3.1033E-04_JPRB,4.1642E-04_JPRB,4.7161E-04_JPRB,4.0689E-04_JPRB/)
KBO( :, 1,37, 2) = (/&
&4.9059E-05_JPRB,5.5199E-05_JPRB,2.3317E-04_JPRB,3.2671E-04_JPRB,3.8295E-04_JPRB,3.3938E-04_JPRB/)
KBO( :, 2,37, 2) = (/&
&5.1165E-05_JPRB,5.7620E-05_JPRB,2.3941E-04_JPRB,3.3239E-04_JPRB,3.8652E-04_JPRB,3.4120E-04_JPRB/)
KBO( :, 3,37, 2) = (/&
&5.3443E-05_JPRB,6.0304E-05_JPRB,2.4519E-04_JPRB,3.3687E-04_JPRB,3.8853E-04_JPRB,3.4110E-04_JPRB/)
KBO( :, 4,37, 2) = (/&
&5.6114E-05_JPRB,6.3395E-05_JPRB,2.5044E-04_JPRB,3.4049E-04_JPRB,3.8930E-04_JPRB,3.3955E-04_JPRB/)
KBO( :, 5,37, 2) = (/&
&5.9214E-05_JPRB,6.6999E-05_JPRB,2.5546E-04_JPRB,3.4318E-04_JPRB,3.8905E-04_JPRB,3.3631E-04_JPRB/)
KBO( :, 1,38, 2) = (/&
&4.0104E-05_JPRB,4.5145E-05_JPRB,1.9118E-04_JPRB,2.6808E-04_JPRB,3.1457E-04_JPRB,2.7912E-04_JPRB/)
KBO( :, 2,38, 2) = (/&
&4.1848E-05_JPRB,4.7145E-05_JPRB,1.9649E-04_JPRB,2.7305E-04_JPRB,3.1789E-04_JPRB,2.8112E-04_JPRB/)
KBO( :, 3,38, 2) = (/&
&4.3721E-05_JPRB,4.9348E-05_JPRB,2.0143E-04_JPRB,2.7709E-04_JPRB,3.1990E-04_JPRB,2.8154E-04_JPRB/)
KBO( :, 4,38, 2) = (/&
&4.5908E-05_JPRB,5.1893E-05_JPRB,2.0595E-04_JPRB,2.8033E-04_JPRB,3.2086E-04_JPRB,2.8062E-04_JPRB/)
KBO( :, 5,38, 2) = (/&
&4.8428E-05_JPRB,5.4848E-05_JPRB,2.1030E-04_JPRB,2.8287E-04_JPRB,3.2098E-04_JPRB,2.7832E-04_JPRB/)
KBO( :, 1,39, 2) = (/&
&3.2779E-05_JPRB,3.6913E-05_JPRB,1.5676E-04_JPRB,2.1996E-04_JPRB,2.5835E-04_JPRB,2.2986E-04_JPRB/)
KBO( :, 2,39, 2) = (/&
&3.4226E-05_JPRB,3.8568E-05_JPRB,1.6127E-04_JPRB,2.2431E-04_JPRB,2.6140E-04_JPRB,2.3193E-04_JPRB/)
KBO( :, 3,39, 2) = (/&
&3.5764E-05_JPRB,4.0382E-05_JPRB,1.6550E-04_JPRB,2.2790E-04_JPRB,2.6334E-04_JPRB,2.3271E-04_JPRB/)
KBO( :, 4,39, 2) = (/&
&3.7558E-05_JPRB,4.2480E-05_JPRB,1.6939E-04_JPRB,2.3082E-04_JPRB,2.6439E-04_JPRB,2.3230E-04_JPRB/)
KBO( :, 5,39, 2) = (/&
&3.9596E-05_JPRB,4.4889E-05_JPRB,1.7315E-04_JPRB,2.3313E-04_JPRB,2.6477E-04_JPRB,2.3072E-04_JPRB/)
KBO( :, 1,40, 2) = (/&
&2.6669E-05_JPRB,3.0049E-05_JPRB,1.2812E-04_JPRB,1.8003E-04_JPRB,2.1187E-04_JPRB,1.8838E-04_JPRB/)
KBO( :, 2,40, 2) = (/&
&2.7871E-05_JPRB,3.1411E-05_JPRB,1.3197E-04_JPRB,1.8389E-04_JPRB,2.1472E-04_JPRB,1.9052E-04_JPRB/)
KBO( :, 3,40, 2) = (/&
&2.9115E-05_JPRB,3.2883E-05_JPRB,1.3564E-04_JPRB,1.8717E-04_JPRB,2.1664E-04_JPRB,1.9149E-04_JPRB/)
KBO( :, 4,40, 2) = (/&
&3.0569E-05_JPRB,3.4584E-05_JPRB,1.3899E-04_JPRB,1.8980E-04_JPRB,2.1779E-04_JPRB,1.9147E-04_JPRB/)
KBO( :, 5,40, 2) = (/&
&3.2192E-05_JPRB,3.6525E-05_JPRB,1.4223E-04_JPRB,1.9192E-04_JPRB,2.1835E-04_JPRB,1.9045E-04_JPRB/)
KBO( :, 1,41, 2) = (/&
&2.1671E-05_JPRB,2.4436E-05_JPRB,1.0464E-04_JPRB,1.4721E-04_JPRB,1.7354E-04_JPRB,1.5422E-04_JPRB/)
KBO( :, 2,41, 2) = (/&
&2.2673E-05_JPRB,2.5564E-05_JPRB,1.0794E-04_JPRB,1.5067E-04_JPRB,1.7624E-04_JPRB,1.5635E-04_JPRB/)
KBO( :, 3,41, 2) = (/&
&2.3692E-05_JPRB,2.6758E-05_JPRB,1.1109E-04_JPRB,1.5359E-04_JPRB,1.7809E-04_JPRB,1.5746E-04_JPRB/)
KBO( :, 4,41, 2) = (/&
&2.4859E-05_JPRB,2.8133E-05_JPRB,1.1398E-04_JPRB,1.5600E-04_JPRB,1.7932E-04_JPRB,1.5772E-04_JPRB/)
KBO( :, 5,41, 2) = (/&
&2.6157E-05_JPRB,2.9694E-05_JPRB,1.1679E-04_JPRB,1.5797E-04_JPRB,1.8006E-04_JPRB,1.5714E-04_JPRB/)
KBO( :, 1,42, 2) = (/&
&1.7599E-05_JPRB,1.9868E-05_JPRB,8.5428E-05_JPRB,1.2033E-04_JPRB,1.4210E-04_JPRB,1.2624E-04_JPRB/)
KBO( :, 2,42, 2) = (/&
&1.8437E-05_JPRB,2.0798E-05_JPRB,8.8247E-05_JPRB,1.2340E-04_JPRB,1.4460E-04_JPRB,1.2832E-04_JPRB/)
KBO( :, 3,42, 2) = (/&
&1.9276E-05_JPRB,2.1771E-05_JPRB,9.0940E-05_JPRB,1.2600E-04_JPRB,1.4636E-04_JPRB,1.2953E-04_JPRB/)
KBO( :, 4,42, 2) = (/&
&2.0214E-05_JPRB,2.2883E-05_JPRB,9.3444E-05_JPRB,1.2819E-04_JPRB,1.4761E-04_JPRB,1.2995E-04_JPRB/)
KBO( :, 5,42, 2) = (/&
&2.1256E-05_JPRB,2.4138E-05_JPRB,9.5879E-05_JPRB,1.2999E-04_JPRB,1.4842E-04_JPRB,1.2971E-04_JPRB/)
KBO( :, 1,43, 2) = (/&
&1.4241E-05_JPRB,1.6107E-05_JPRB,6.9575E-05_JPRB,9.8122E-05_JPRB,1.1610E-04_JPRB,1.0313E-04_JPRB/)
KBO( :, 2,43, 2) = (/&
&1.4953E-05_JPRB,1.6876E-05_JPRB,7.1989E-05_JPRB,1.0088E-04_JPRB,1.1847E-04_JPRB,1.0516E-04_JPRB/)
KBO( :, 3,43, 2) = (/&
&1.5643E-05_JPRB,1.7668E-05_JPRB,7.4322E-05_JPRB,1.0321E-04_JPRB,1.2016E-04_JPRB,1.0643E-04_JPRB/)
KBO( :, 4,43, 2) = (/&
&1.6392E-05_JPRB,1.8559E-05_JPRB,7.6469E-05_JPRB,1.0519E-04_JPRB,1.2140E-04_JPRB,1.0702E-04_JPRB/)
KBO( :, 5,43, 2) = (/&
&1.7225E-05_JPRB,1.9561E-05_JPRB,7.8569E-05_JPRB,1.0686E-04_JPRB,1.2228E-04_JPRB,1.0704E-04_JPRB/)
KBO( :, 1,44, 2) = (/&
&1.1498E-05_JPRB,1.3036E-05_JPRB,5.6576E-05_JPRB,7.9895E-05_JPRB,9.4733E-05_JPRB,8.4131E-05_JPRB/)
KBO( :, 2,44, 2) = (/&
&1.2106E-05_JPRB,1.3670E-05_JPRB,5.8637E-05_JPRB,8.2333E-05_JPRB,9.6917E-05_JPRB,8.6094E-05_JPRB/)
KBO( :, 3,44, 2) = (/&
&1.2676E-05_JPRB,1.4317E-05_JPRB,6.0634E-05_JPRB,8.4429E-05_JPRB,9.8546E-05_JPRB,8.7409E-05_JPRB/)
KBO( :, 4,44, 2) = (/&
&1.3277E-05_JPRB,1.5031E-05_JPRB,6.2499E-05_JPRB,8.6240E-05_JPRB,9.9772E-05_JPRB,8.8130E-05_JPRB/)
KBO( :, 5,44, 2) = (/&
&1.3943E-05_JPRB,1.5832E-05_JPRB,6.4310E-05_JPRB,8.7770E-05_JPRB,1.0066E-04_JPRB,8.8344E-05_JPRB/)
KBO( :, 1,45, 2) = (/&
&9.2693E-06_JPRB,1.0543E-05_JPRB,4.5963E-05_JPRB,6.4978E-05_JPRB,7.7194E-05_JPRB,6.8589E-05_JPRB/)
KBO( :, 2,45, 2) = (/&
&9.7957E-06_JPRB,1.1074E-05_JPRB,4.7739E-05_JPRB,6.7165E-05_JPRB,7.9241E-05_JPRB,7.0483E-05_JPRB/)
KBO( :, 3,45, 2) = (/&
&1.0267E-05_JPRB,1.1600E-05_JPRB,4.9445E-05_JPRB,6.9027E-05_JPRB,8.0769E-05_JPRB,7.1812E-05_JPRB/)
KBO( :, 4,45, 2) = (/&
&1.0754E-05_JPRB,1.2174E-05_JPRB,5.1050E-05_JPRB,7.0661E-05_JPRB,8.1921E-05_JPRB,7.2601E-05_JPRB/)
KBO( :, 5,45, 2) = (/&
&1.1287E-05_JPRB,1.2814E-05_JPRB,5.2605E-05_JPRB,7.2048E-05_JPRB,8.2819E-05_JPRB,7.2974E-05_JPRB/)
KBO( :, 1,46, 2) = (/&
&7.4503E-06_JPRB,8.5075E-06_JPRB,3.7281E-05_JPRB,5.2735E-05_JPRB,6.2776E-05_JPRB,5.5797E-05_JPRB/)
KBO( :, 2,46, 2) = (/&
&7.9071E-06_JPRB,8.9566E-06_JPRB,3.8801E-05_JPRB,5.4682E-05_JPRB,6.4662E-05_JPRB,5.7621E-05_JPRB/)
KBO( :, 3,46, 2) = (/&
&8.3054E-06_JPRB,9.3874E-06_JPRB,4.0254E-05_JPRB,5.6347E-05_JPRB,6.6096E-05_JPRB,5.8936E-05_JPRB/)
KBO( :, 4,46, 2) = (/&
&8.7047E-06_JPRB,9.8508E-06_JPRB,4.1643E-05_JPRB,5.7815E-05_JPRB,6.7206E-05_JPRB,5.9793E-05_JPRB/)
KBO( :, 5,46, 2) = (/&
&9.1293E-06_JPRB,1.0362E-05_JPRB,4.2978E-05_JPRB,5.9086E-05_JPRB,6.8087E-05_JPRB,6.0275E-05_JPRB/)
KBO( :, 1,47, 2) = (/&
&5.9482E-06_JPRB,6.8343E-06_JPRB,3.0152E-05_JPRB,4.2665E-05_JPRB,5.0898E-05_JPRB,4.5169E-05_JPRB/)
KBO( :, 2,47, 2) = (/&
&6.3610E-06_JPRB,7.2250E-06_JPRB,3.1455E-05_JPRB,4.4406E-05_JPRB,5.2643E-05_JPRB,4.6942E-05_JPRB/)
KBO( :, 3,47, 2) = (/&
&6.7018E-06_JPRB,7.5799E-06_JPRB,3.2695E-05_JPRB,4.5897E-05_JPRB,5.3992E-05_JPRB,4.8229E-05_JPRB/)
KBO( :, 4,47, 2) = (/&
&7.0296E-06_JPRB,7.9549E-06_JPRB,3.3896E-05_JPRB,4.7210E-05_JPRB,5.5050E-05_JPRB,4.9112E-05_JPRB/)
KBO( :, 5,47, 2) = (/&
&7.3684E-06_JPRB,8.3623E-06_JPRB,3.5042E-05_JPRB,4.8359E-05_JPRB,5.5895E-05_JPRB,4.9665E-05_JPRB/)
KBO( :, 1,48, 2) = (/&
&4.7226E-06_JPRB,5.4755E-06_JPRB,2.4366E-05_JPRB,3.4470E-05_JPRB,4.1173E-05_JPRB,3.6520E-05_JPRB/)
KBO( :, 2,48, 2) = (/&
&5.1075E-06_JPRB,5.8220E-06_JPRB,2.5469E-05_JPRB,3.6010E-05_JPRB,4.2797E-05_JPRB,3.8222E-05_JPRB/)
KBO( :, 3,48, 2) = (/&
&5.4030E-06_JPRB,6.1196E-06_JPRB,2.6535E-05_JPRB,3.7342E-05_JPRB,4.4049E-05_JPRB,3.9474E-05_JPRB/)
KBO( :, 4,48, 2) = (/&
&5.6740E-06_JPRB,6.4213E-06_JPRB,2.7566E-05_JPRB,3.8507E-05_JPRB,4.5041E-05_JPRB,4.0367E-05_JPRB/)
KBO( :, 5,48, 2) = (/&
&5.9485E-06_JPRB,6.7483E-06_JPRB,2.8544E-05_JPRB,3.9542E-05_JPRB,4.5839E-05_JPRB,4.0966E-05_JPRB/)
KBO( :, 1,49, 2) = (/&
&3.7285E-06_JPRB,4.3687E-06_JPRB,1.9662E-05_JPRB,2.7800E-05_JPRB,3.3218E-05_JPRB,2.9501E-05_JPRB/)
KBO( :, 2,49, 2) = (/&
&4.0884E-06_JPRB,4.6821E-06_JPRB,2.0602E-05_JPRB,2.9151E-05_JPRB,3.4721E-05_JPRB,3.1112E-05_JPRB/)
KBO( :, 3,49, 2) = (/&
&4.3499E-06_JPRB,4.9382E-06_JPRB,2.1513E-05_JPRB,3.0331E-05_JPRB,3.5872E-05_JPRB,3.2329E-05_JPRB/)
KBO( :, 4,49, 2) = (/&
&4.5782E-06_JPRB,5.1831E-06_JPRB,2.2388E-05_JPRB,3.1370E-05_JPRB,3.6806E-05_JPRB,3.3224E-05_JPRB/)
KBO( :, 5,49, 2) = (/&
&4.8038E-06_JPRB,5.4471E-06_JPRB,2.3228E-05_JPRB,3.2295E-05_JPRB,3.7558E-05_JPRB,3.3865E-05_JPRB/)
KBO( :, 1,50, 2) = (/&
&2.9385E-06_JPRB,3.4756E-06_JPRB,1.5868E-05_JPRB,2.2413E-05_JPRB,2.6776E-05_JPRB,2.3745E-05_JPRB/)
KBO( :, 2,50, 2) = (/&
&3.2647E-06_JPRB,3.7628E-06_JPRB,1.6666E-05_JPRB,2.3594E-05_JPRB,2.8150E-05_JPRB,2.5211E-05_JPRB/)
KBO( :, 3,50, 2) = (/&
&3.5024E-06_JPRB,3.9867E-06_JPRB,1.7439E-05_JPRB,2.4630E-05_JPRB,2.9198E-05_JPRB,2.6360E-05_JPRB/)
KBO( :, 4,50, 2) = (/&
&3.6969E-06_JPRB,4.1885E-06_JPRB,1.8186E-05_JPRB,2.5547E-05_JPRB,3.0054E-05_JPRB,2.7214E-05_JPRB/)
KBO( :, 5,50, 2) = (/&
&3.8815E-06_JPRB,4.4012E-06_JPRB,1.8910E-05_JPRB,2.6369E-05_JPRB,3.0754E-05_JPRB,2.7855E-05_JPRB/)
KBO( :, 1,51, 2) = (/&
&2.3100E-06_JPRB,2.7563E-06_JPRB,1.2803E-05_JPRB,1.8054E-05_JPRB,2.1547E-05_JPRB,1.9044E-05_JPRB/)
KBO( :, 2,51, 2) = (/&
&2.5961E-06_JPRB,3.0186E-06_JPRB,1.3477E-05_JPRB,1.9076E-05_JPRB,2.2781E-05_JPRB,2.0360E-05_JPRB/)
KBO( :, 3,51, 2) = (/&
&2.8167E-06_JPRB,3.2170E-06_JPRB,1.4130E-05_JPRB,1.9983E-05_JPRB,2.3743E-05_JPRB,2.1431E-05_JPRB/)
KBO( :, 4,51, 2) = (/&
&2.9847E-06_JPRB,3.3863E-06_JPRB,1.4767E-05_JPRB,2.0790E-05_JPRB,2.4523E-05_JPRB,2.2225E-05_JPRB/)
KBO( :, 5,51, 2) = (/&
&3.1380E-06_JPRB,3.5588E-06_JPRB,1.5387E-05_JPRB,2.1516E-05_JPRB,2.5161E-05_JPRB,2.2842E-05_JPRB/)
KBO( :, 1,52, 2) = (/&
&1.8092E-06_JPRB,2.1783E-06_JPRB,1.0320E-05_JPRB,1.4520E-05_JPRB,1.7296E-05_JPRB,1.5258E-05_JPRB/)
KBO( :, 2,52, 2) = (/&
&2.0552E-06_JPRB,2.4128E-06_JPRB,1.0887E-05_JPRB,1.5404E-05_JPRB,1.8400E-05_JPRB,1.6432E-05_JPRB/)
KBO( :, 3,52, 2) = (/&
&2.2593E-06_JPRB,2.5914E-06_JPRB,1.1440E-05_JPRB,1.6191E-05_JPRB,1.9279E-05_JPRB,1.7410E-05_JPRB/)
KBO( :, 4,52, 2) = (/&
&2.4069E-06_JPRB,2.7365E-06_JPRB,1.1980E-05_JPRB,1.6899E-05_JPRB,1.9980E-05_JPRB,1.8159E-05_JPRB/)
KBO( :, 5,52, 2) = (/&
&2.5360E-06_JPRB,2.8766E-06_JPRB,1.2509E-05_JPRB,1.7535E-05_JPRB,2.0563E-05_JPRB,1.8740E-05_JPRB/)
KBO( :, 1,53, 2) = (/&
&1.4105E-06_JPRB,1.7158E-06_JPRB,8.3084E-06_JPRB,1.1659E-05_JPRB,1.3847E-05_JPRB,1.2214E-05_JPRB/)
KBO( :, 2,53, 2) = (/&
&1.6202E-06_JPRB,1.9199E-06_JPRB,8.7865E-06_JPRB,1.2420E-05_JPRB,1.4832E-05_JPRB,1.3260E-05_JPRB/)
KBO( :, 3,53, 2) = (/&
&1.8048E-06_JPRB,2.0833E-06_JPRB,9.2542E-06_JPRB,1.3103E-05_JPRB,1.5629E-05_JPRB,1.4148E-05_JPRB/)
KBO( :, 4,53, 2) = (/&
&1.9388E-06_JPRB,2.2099E-06_JPRB,9.7095E-06_JPRB,1.3720E-05_JPRB,1.6258E-05_JPRB,1.4856E-05_JPRB/)
KBO( :, 5,53, 2) = (/&
&2.0484E-06_JPRB,2.3252E-06_JPRB,1.0159E-05_JPRB,1.4275E-05_JPRB,1.6786E-05_JPRB,1.5408E-05_JPRB/)
KBO( :, 1,54, 2) = (/&
&1.1001E-06_JPRB,1.3520E-06_JPRB,6.6915E-06_JPRB,9.3651E-06_JPRB,1.1080E-05_JPRB,9.6915E-06_JPRB/)
KBO( :, 2,54, 2) = (/&
&1.2776E-06_JPRB,1.5264E-06_JPRB,7.0980E-06_JPRB,1.0019E-05_JPRB,1.1951E-05_JPRB,1.0599E-05_JPRB/)
KBO( :, 3,54, 2) = (/&
&1.4389E-06_JPRB,1.6744E-06_JPRB,7.4896E-06_JPRB,1.0605E-05_JPRB,1.2661E-05_JPRB,1.1371E-05_JPRB/)
KBO( :, 4,54, 2) = (/&
&1.5618E-06_JPRB,1.7856E-06_JPRB,7.8730E-06_JPRB,1.1139E-05_JPRB,1.3225E-05_JPRB,1.2005E-05_JPRB/)
KBO( :, 5,54, 2) = (/&
&1.6563E-06_JPRB,1.8821E-06_JPRB,8.2537E-06_JPRB,1.1621E-05_JPRB,1.3700E-05_JPRB,1.2497E-05_JPRB/)
KBO( :, 1,55, 2) = (/&
&8.5645E-07_JPRB,1.0639E-06_JPRB,5.3882E-06_JPRB,7.5160E-06_JPRB,8.8564E-06_JPRB,7.6411E-06_JPRB/)
KBO( :, 2,55, 2) = (/&
&1.0060E-06_JPRB,1.2118E-06_JPRB,5.7336E-06_JPRB,8.0780E-06_JPRB,9.6170E-06_JPRB,8.4151E-06_JPRB/)
KBO( :, 3,55, 2) = (/&
&1.1442E-06_JPRB,1.3431E-06_JPRB,6.0604E-06_JPRB,8.5801E-06_JPRB,1.0247E-05_JPRB,9.0709E-06_JPRB/)
KBO( :, 4,55, 2) = (/&
&1.2568E-06_JPRB,1.4421E-06_JPRB,6.3829E-06_JPRB,9.0380E-06_JPRB,1.0752E-05_JPRB,9.6232E-06_JPRB/)
KBO( :, 5,55, 2) = (/&
&1.3389E-06_JPRB,1.5239E-06_JPRB,6.7048E-06_JPRB,9.4560E-06_JPRB,1.1172E-05_JPRB,1.0049E-05_JPRB/)
KBO( :, 1,56, 2) = (/&
&6.6442E-07_JPRB,8.3379E-07_JPRB,4.3324E-06_JPRB,6.0198E-06_JPRB,7.0629E-06_JPRB,6.0049E-06_JPRB/)
KBO( :, 2,56, 2) = (/&
&7.8950E-07_JPRB,9.5952E-07_JPRB,4.6273E-06_JPRB,6.5047E-06_JPRB,7.7219E-06_JPRB,6.6682E-06_JPRB/)
KBO( :, 3,56, 2) = (/&
&9.0717E-07_JPRB,1.0738E-06_JPRB,4.9008E-06_JPRB,6.9329E-06_JPRB,8.2806E-06_JPRB,7.2285E-06_JPRB/)
KBO( :, 4,56, 2) = (/&
&1.0084E-06_JPRB,1.1629E-06_JPRB,5.1710E-06_JPRB,7.3266E-06_JPRB,8.7308E-06_JPRB,7.6993E-06_JPRB/)
KBO( :, 5,56, 2) = (/&
&1.0813E-06_JPRB,1.2332E-06_JPRB,5.4414E-06_JPRB,7.6876E-06_JPRB,9.1018E-06_JPRB,8.0751E-06_JPRB/)
KBO( :, 1,57, 2) = (/&
&5.1317E-07_JPRB,6.4951E-07_JPRB,3.4793E-06_JPRB,4.8121E-06_JPRB,5.6195E-06_JPRB,4.7031E-06_JPRB/)
KBO( :, 2,57, 2) = (/&
&6.1735E-07_JPRB,7.5758E-07_JPRB,3.7304E-06_JPRB,5.2293E-06_JPRB,6.1863E-06_JPRB,5.2741E-06_JPRB/)
KBO( :, 3,57, 2) = (/&
&7.1698E-07_JPRB,8.5543E-07_JPRB,3.9609E-06_JPRB,5.5969E-06_JPRB,6.6797E-06_JPRB,5.7513E-06_JPRB/)
KBO( :, 4,57, 2) = (/&
&8.0608E-07_JPRB,9.3608E-07_JPRB,4.1867E-06_JPRB,5.9326E-06_JPRB,7.0780E-06_JPRB,6.1535E-06_JPRB/)
KBO( :, 5,57, 2) = (/&
&8.7220E-07_JPRB,9.9722E-07_JPRB,4.4123E-06_JPRB,6.2442E-06_JPRB,7.4063E-06_JPRB,6.4839E-06_JPRB/)
KBO( :, 1,58, 2) = (/&
&3.9480E-07_JPRB,5.0435E-07_JPRB,2.7935E-06_JPRB,3.8432E-06_JPRB,4.4657E-06_JPRB,3.6764E-06_JPRB/)
KBO( :, 2,58, 2) = (/&
&4.8219E-07_JPRB,5.9772E-07_JPRB,3.0073E-06_JPRB,4.2025E-06_JPRB,4.9518E-06_JPRB,4.1625E-06_JPRB/)
KBO( :, 3,58, 2) = (/&
&5.6606E-07_JPRB,6.8070E-07_JPRB,3.2015E-06_JPRB,4.5174E-06_JPRB,5.3832E-06_JPRB,4.5681E-06_JPRB/)
KBO( :, 4,58, 2) = (/&
&6.4282E-07_JPRB,7.5255E-07_JPRB,3.3896E-06_JPRB,4.8024E-06_JPRB,5.7338E-06_JPRB,4.9081E-06_JPRB/)
KBO( :, 5,58, 2) = (/&
&7.0311E-07_JPRB,8.0645E-07_JPRB,3.5782E-06_JPRB,5.0698E-06_JPRB,6.0234E-06_JPRB,5.1890E-06_JPRB/)
KBO( :, 1,59, 2) = (/&
&3.1539E-07_JPRB,4.0480E-07_JPRB,2.2738E-06_JPRB,3.1211E-06_JPRB,3.6182E-06_JPRB,2.9204E-06_JPRB/)
KBO( :, 2,59, 2) = (/&
&3.8822E-07_JPRB,4.8324E-07_JPRB,2.4529E-06_JPRB,3.4232E-06_JPRB,4.0269E-06_JPRB,3.3117E-06_JPRB/)
KBO( :, 3,59, 2) = (/&
&4.5803E-07_JPRB,5.5251E-07_JPRB,2.6142E-06_JPRB,3.6873E-06_JPRB,4.3909E-06_JPRB,3.6397E-06_JPRB/)
KBO( :, 4,59, 2) = (/&
&5.2209E-07_JPRB,6.1313E-07_JPRB,2.7709E-06_JPRB,3.9267E-06_JPRB,4.6885E-06_JPRB,3.9100E-06_JPRB/)
KBO( :, 5,59, 2) = (/&
&5.7356E-07_JPRB,6.5884E-07_JPRB,2.9288E-06_JPRB,4.1516E-06_JPRB,4.9350E-06_JPRB,4.1280E-06_JPRB/)
KBO( :, 1,13, 3) = (/&
&7.6409E-03_JPRB,7.8630E-03_JPRB,3.5099E-02_JPRB,5.1489E-02_JPRB,6.3478E-02_JPRB,6.7045E-02_JPRB/)
KBO( :, 2,13, 3) = (/&
&7.6194E-03_JPRB,7.8439E-03_JPRB,3.6320E-02_JPRB,5.3590E-02_JPRB,6.5755E-02_JPRB,7.0861E-02_JPRB/)
KBO( :, 3,13, 3) = (/&
&7.6221E-03_JPRB,7.8478E-03_JPRB,3.7408E-02_JPRB,5.5388E-02_JPRB,6.7789E-02_JPRB,7.4140E-02_JPRB/)
KBO( :, 4,13, 3) = (/&
&7.7245E-03_JPRB,7.9516E-03_JPRB,3.8346E-02_JPRB,5.6822E-02_JPRB,6.9566E-02_JPRB,7.7166E-02_JPRB/)
KBO( :, 5,13, 3) = (/&
&7.8978E-03_JPRB,8.1255E-03_JPRB,3.9191E-02_JPRB,5.7916E-02_JPRB,7.1029E-02_JPRB,7.9766E-02_JPRB/)
KBO( :, 1,14, 3) = (/&
&6.3458E-03_JPRB,6.5743E-03_JPRB,3.0544E-02_JPRB,4.4937E-02_JPRB,5.5150E-02_JPRB,5.7197E-02_JPRB/)
KBO( :, 2,14, 3) = (/&
&6.3293E-03_JPRB,6.5605E-03_JPRB,3.1591E-02_JPRB,4.6706E-02_JPRB,5.7142E-02_JPRB,6.0155E-02_JPRB/)
KBO( :, 3,14, 3) = (/&
&6.3587E-03_JPRB,6.5945E-03_JPRB,3.2496E-02_JPRB,4.8185E-02_JPRB,5.8909E-02_JPRB,6.2706E-02_JPRB/)
KBO( :, 4,14, 3) = (/&
&6.4686E-03_JPRB,6.7092E-03_JPRB,3.3313E-02_JPRB,4.9362E-02_JPRB,6.0431E-02_JPRB,6.4908E-02_JPRB/)
KBO( :, 5,14, 3) = (/&
&6.6255E-03_JPRB,6.8640E-03_JPRB,3.4024E-02_JPRB,5.0218E-02_JPRB,6.1528E-02_JPRB,6.6516E-02_JPRB/)
KBO( :, 1,15, 3) = (/&
&5.2608E-03_JPRB,5.4955E-03_JPRB,2.6384E-02_JPRB,3.8869E-02_JPRB,4.7602E-02_JPRB,4.8635E-02_JPRB/)
KBO( :, 2,15, 3) = (/&
&5.2548E-03_JPRB,5.4956E-03_JPRB,2.7249E-02_JPRB,4.0345E-02_JPRB,4.9310E-02_JPRB,5.0945E-02_JPRB/)
KBO( :, 3,15, 3) = (/&
&5.2993E-03_JPRB,5.5500E-03_JPRB,2.8019E-02_JPRB,4.1551E-02_JPRB,5.0814E-02_JPRB,5.2823E-02_JPRB/)
KBO( :, 4,15, 3) = (/&
&5.4066E-03_JPRB,5.6608E-03_JPRB,2.8708E-02_JPRB,4.2452E-02_JPRB,5.1926E-02_JPRB,5.4154E-02_JPRB/)
KBO( :, 5,15, 3) = (/&
&5.5521E-03_JPRB,5.8017E-03_JPRB,2.9282E-02_JPRB,4.3007E-02_JPRB,5.2526E-02_JPRB,5.4943E-02_JPRB/)
KBO( :, 1,16, 3) = (/&
&4.3548E-03_JPRB,4.5880E-03_JPRB,2.2610E-02_JPRB,3.3375E-02_JPRB,4.0790E-02_JPRB,4.1260E-02_JPRB/)
KBO( :, 2,16, 3) = (/&
&4.3619E-03_JPRB,4.6068E-03_JPRB,2.3348E-02_JPRB,3.4577E-02_JPRB,4.2241E-02_JPRB,4.3009E-02_JPRB/)
KBO( :, 3,16, 3) = (/&
&4.4136E-03_JPRB,4.6705E-03_JPRB,2.3984E-02_JPRB,3.5504E-02_JPRB,4.3353E-02_JPRB,4.4224E-02_JPRB/)
KBO( :, 4,16, 3) = (/&
&4.5178E-03_JPRB,4.7766E-03_JPRB,2.4528E-02_JPRB,3.6072E-02_JPRB,4.4010E-02_JPRB,4.4975E-02_JPRB/)
KBO( :, 5,16, 3) = (/&
&4.6504E-03_JPRB,4.9071E-03_JPRB,2.4942E-02_JPRB,3.6363E-02_JPRB,4.4282E-02_JPRB,4.5379E-02_JPRB/)
KBO( :, 1,17, 3) = (/&
&3.6046E-03_JPRB,3.8291E-03_JPRB,1.9257E-02_JPRB,2.8451E-02_JPRB,3.4711E-02_JPRB,3.4756E-02_JPRB/)
KBO( :, 2,17, 3) = (/&
&3.6213E-03_JPRB,3.8592E-03_JPRB,1.9862E-02_JPRB,2.9374E-02_JPRB,3.5819E-02_JPRB,3.5957E-02_JPRB/)
KBO( :, 3,17, 3) = (/&
&3.6771E-03_JPRB,3.9291E-03_JPRB,2.0363E-02_JPRB,2.9994E-02_JPRB,3.6526E-02_JPRB,3.6699E-02_JPRB/)
KBO( :, 4,17, 3) = (/&
&3.7714E-03_JPRB,4.0283E-03_JPRB,2.0759E-02_JPRB,3.0326E-02_JPRB,3.6910E-02_JPRB,3.7152E-02_JPRB/)
KBO( :, 5,17, 3) = (/&
&3.8899E-03_JPRB,4.1466E-03_JPRB,2.1065E-02_JPRB,3.0505E-02_JPRB,3.7035E-02_JPRB,3.7347E-02_JPRB/)
KBO( :, 1,18, 3) = (/&
&2.9885E-03_JPRB,3.1998E-03_JPRB,1.6296E-02_JPRB,2.4061E-02_JPRB,2.9310E-02_JPRB,2.9021E-02_JPRB/)
KBO( :, 2,18, 3) = (/&
&3.0092E-03_JPRB,3.2357E-03_JPRB,1.6767E-02_JPRB,2.4711E-02_JPRB,3.0069E-02_JPRB,2.9818E-02_JPRB/)
KBO( :, 3,18, 3) = (/&
&3.0601E-03_JPRB,3.3019E-03_JPRB,1.7137E-02_JPRB,2.5107E-02_JPRB,3.0527E-02_JPRB,3.0314E-02_JPRB/)
KBO( :, 4,18, 3) = (/&
&3.1433E-03_JPRB,3.3904E-03_JPRB,1.7445E-02_JPRB,2.5340E-02_JPRB,3.0772E-02_JPRB,3.0595E-02_JPRB/)
KBO( :, 5,18, 3) = (/&
&3.2491E-03_JPRB,3.4975E-03_JPRB,1.7663E-02_JPRB,2.5461E-02_JPRB,3.0822E-02_JPRB,3.0677E-02_JPRB/)
KBO( :, 1,19, 3) = (/&
&2.4792E-03_JPRB,2.6786E-03_JPRB,1.3691E-02_JPRB,2.0180E-02_JPRB,2.4544E-02_JPRB,2.4040E-02_JPRB/)
KBO( :, 2,19, 3) = (/&
&2.4982E-03_JPRB,2.7134E-03_JPRB,1.4049E-02_JPRB,2.0629E-02_JPRB,2.5069E-02_JPRB,2.4597E-02_JPRB/)
KBO( :, 3,19, 3) = (/&
&2.5452E-03_JPRB,2.7746E-03_JPRB,1.4344E-02_JPRB,2.0921E-02_JPRB,2.5390E-02_JPRB,2.4935E-02_JPRB/)
KBO( :, 4,19, 3) = (/&
&2.6196E-03_JPRB,2.8530E-03_JPRB,1.4579E-02_JPRB,2.1097E-02_JPRB,2.5555E-02_JPRB,2.5107E-02_JPRB/)
KBO( :, 5,19, 3) = (/&
&2.7162E-03_JPRB,2.9530E-03_JPRB,1.4732E-02_JPRB,2.1186E-02_JPRB,2.5572E-02_JPRB,2.5118E-02_JPRB/)
KBO( :, 1,20, 3) = (/&
&2.0528E-03_JPRB,2.2395E-03_JPRB,1.1440E-02_JPRB,1.6822E-02_JPRB,2.0437E-02_JPRB,1.9854E-02_JPRB/)
KBO( :, 2,20, 3) = (/&
&2.0711E-03_JPRB,2.2736E-03_JPRB,1.1723E-02_JPRB,1.7158E-02_JPRB,2.0817E-02_JPRB,2.0254E-02_JPRB/)
KBO( :, 3,20, 3) = (/&
&2.1151E-03_JPRB,2.3293E-03_JPRB,1.1957E-02_JPRB,1.7380E-02_JPRB,2.1050E-02_JPRB,2.0492E-02_JPRB/)
KBO( :, 4,20, 3) = (/&
&2.1833E-03_JPRB,2.4015E-03_JPRB,1.2129E-02_JPRB,1.7522E-02_JPRB,2.1168E-02_JPRB,2.0597E-02_JPRB/)
KBO( :, 5,20, 3) = (/&
&2.2724E-03_JPRB,2.4949E-03_JPRB,1.2249E-02_JPRB,1.7578E-02_JPRB,2.1166E-02_JPRB,2.0571E-02_JPRB/)
KBO( :, 1,21, 3) = (/&
&1.6965E-03_JPRB,1.8666E-03_JPRB,9.5200E-03_JPRB,1.3965E-02_JPRB,1.6952E-02_JPRB,1.6357E-02_JPRB/)
KBO( :, 2,21, 3) = (/&
&1.7152E-03_JPRB,1.9002E-03_JPRB,9.7517E-03_JPRB,1.4227E-02_JPRB,1.7236E-02_JPRB,1.6650E-02_JPRB/)
KBO( :, 3,21, 3) = (/&
&1.7567E-03_JPRB,1.9510E-03_JPRB,9.9283E-03_JPRB,1.4408E-02_JPRB,1.7419E-02_JPRB,1.6821E-02_JPRB/)
KBO( :, 4,21, 3) = (/&
&1.8182E-03_JPRB,2.0179E-03_JPRB,1.0061E-02_JPRB,1.4512E-02_JPRB,1.7502E-02_JPRB,1.6883E-02_JPRB/)
KBO( :, 5,21, 3) = (/&
&1.9002E-03_JPRB,2.1049E-03_JPRB,1.0160E-02_JPRB,1.4547E-02_JPRB,1.7493E-02_JPRB,1.6838E-02_JPRB/)
KBO( :, 1,22, 3) = (/&
&1.4012E-03_JPRB,1.5543E-03_JPRB,7.9187E-03_JPRB,1.1582E-02_JPRB,1.4044E-02_JPRB,1.3475E-02_JPRB/)
KBO( :, 2,22, 3) = (/&
&1.4217E-03_JPRB,1.5878E-03_JPRB,8.0975E-03_JPRB,1.1789E-02_JPRB,1.4260E-02_JPRB,1.3686E-02_JPRB/)
KBO( :, 3,22, 3) = (/&
&1.4625E-03_JPRB,1.6356E-03_JPRB,8.2342E-03_JPRB,1.1928E-02_JPRB,1.4399E-02_JPRB,1.3802E-02_JPRB/)
KBO( :, 4,22, 3) = (/&
&1.5189E-03_JPRB,1.6982E-03_JPRB,8.3363E-03_JPRB,1.1996E-02_JPRB,1.4455E-02_JPRB,1.3830E-02_JPRB/)
KBO( :, 5,22, 3) = (/&
&1.5929E-03_JPRB,1.7785E-03_JPRB,8.4131E-03_JPRB,1.2015E-02_JPRB,1.4430E-02_JPRB,1.3772E-02_JPRB/)
KBO( :, 1,23, 3) = (/&
&1.1570E-03_JPRB,1.2929E-03_JPRB,6.5744E-03_JPRB,9.5929E-03_JPRB,1.1615E-02_JPRB,1.1086E-02_JPRB/)
KBO( :, 2,23, 3) = (/&
&1.1790E-03_JPRB,1.3257E-03_JPRB,6.7098E-03_JPRB,9.7544E-03_JPRB,1.1782E-02_JPRB,1.1237E-02_JPRB/)
KBO( :, 3,23, 3) = (/&
&1.2175E-03_JPRB,1.3704E-03_JPRB,6.8141E-03_JPRB,9.8515E-03_JPRB,1.1889E-02_JPRB,1.1315E-02_JPRB/)
KBO( :, 4,23, 3) = (/&
&1.2686E-03_JPRB,1.4282E-03_JPRB,6.8934E-03_JPRB,9.9002E-03_JPRB,1.1920E-02_JPRB,1.1318E-02_JPRB/)
KBO( :, 5,23, 3) = (/&
&1.3340E-03_JPRB,1.5001E-03_JPRB,6.9577E-03_JPRB,9.9108E-03_JPRB,1.1886E-02_JPRB,1.1254E-02_JPRB/)
KBO( :, 1,24, 3) = (/&
&9.5574E-04_JPRB,1.0753E-03_JPRB,5.4476E-03_JPRB,7.9376E-03_JPRB,9.5959E-03_JPRB,9.1100E-03_JPRB/)
KBO( :, 2,24, 3) = (/&
&9.7834E-04_JPRB,1.1070E-03_JPRB,5.5506E-03_JPRB,8.0557E-03_JPRB,9.7276E-03_JPRB,9.2176E-03_JPRB/)
KBO( :, 3,24, 3) = (/&
&1.0140E-03_JPRB,1.1485E-03_JPRB,5.6323E-03_JPRB,8.1281E-03_JPRB,9.8028E-03_JPRB,9.2635E-03_JPRB/)
KBO( :, 4,24, 3) = (/&
&1.0594E-03_JPRB,1.2005E-03_JPRB,5.6966E-03_JPRB,8.1612E-03_JPRB,9.8145E-03_JPRB,9.2505E-03_JPRB/)
KBO( :, 5,24, 3) = (/&
&1.1172E-03_JPRB,1.2644E-03_JPRB,5.7523E-03_JPRB,8.1643E-03_JPRB,9.7794E-03_JPRB,9.1865E-03_JPRB/)
KBO( :, 1,25, 3) = (/&
&7.9031E-04_JPRB,8.9498E-04_JPRB,4.5093E-03_JPRB,6.5597E-03_JPRB,7.9226E-03_JPRB,7.4814E-03_JPRB/)
KBO( :, 2,25, 3) = (/&
&8.1263E-04_JPRB,9.2459E-04_JPRB,4.5880E-03_JPRB,6.6467E-03_JPRB,8.0247E-03_JPRB,7.5572E-03_JPRB/)
KBO( :, 3,25, 3) = (/&
&8.4479E-04_JPRB,9.6257E-04_JPRB,4.6527E-03_JPRB,6.6977E-03_JPRB,8.0725E-03_JPRB,7.5813E-03_JPRB/)
KBO( :, 4,25, 3) = (/&
&8.8545E-04_JPRB,1.0093E-03_JPRB,4.7088E-03_JPRB,6.7186E-03_JPRB,8.0725E-03_JPRB,7.5582E-03_JPRB/)
KBO( :, 5,25, 3) = (/&
&9.3639E-04_JPRB,1.0658E-03_JPRB,4.7580E-03_JPRB,6.7210E-03_JPRB,8.0368E-03_JPRB,7.4940E-03_JPRB/)
KBO( :, 1,26, 3) = (/&
&6.5440E-04_JPRB,7.4555E-04_JPRB,3.7287E-03_JPRB,5.4156E-03_JPRB,6.5397E-03_JPRB,6.1435E-03_JPRB/)
KBO( :, 2,26, 3) = (/&
&6.7588E-04_JPRB,7.7292E-04_JPRB,3.7917E-03_JPRB,5.4786E-03_JPRB,6.6119E-03_JPRB,6.1927E-03_JPRB/)
KBO( :, 3,26, 3) = (/&
&7.0450E-04_JPRB,8.0706E-04_JPRB,3.8452E-03_JPRB,5.5137E-03_JPRB,6.6415E-03_JPRB,6.2018E-03_JPRB/)
KBO( :, 4,26, 3) = (/&
&7.4139E-04_JPRB,8.4916E-04_JPRB,3.8959E-03_JPRB,5.5296E-03_JPRB,6.6347E-03_JPRB,6.1729E-03_JPRB/)
KBO( :, 5,26, 3) = (/&
&7.8678E-04_JPRB,8.9964E-04_JPRB,3.9398E-03_JPRB,5.5339E-03_JPRB,6.6007E-03_JPRB,6.1130E-03_JPRB/)
KBO( :, 1,27, 3) = (/&
&5.4261E-04_JPRB,6.2138E-04_JPRB,3.0812E-03_JPRB,4.4673E-03_JPRB,5.3930E-03_JPRB,5.0432E-03_JPRB/)
KBO( :, 2,27, 3) = (/&
&5.6244E-04_JPRB,6.4623E-04_JPRB,3.1326E-03_JPRB,4.5130E-03_JPRB,5.4441E-03_JPRB,5.0746E-03_JPRB/)
KBO( :, 3,27, 3) = (/&
&5.8793E-04_JPRB,6.7665E-04_JPRB,3.1799E-03_JPRB,4.5386E-03_JPRB,5.4598E-03_JPRB,5.0735E-03_JPRB/)
KBO( :, 4,27, 3) = (/&
&6.2139E-04_JPRB,7.1456E-04_JPRB,3.2246E-03_JPRB,4.5530E-03_JPRB,5.4488E-03_JPRB,5.0440E-03_JPRB/)
KBO( :, 5,27, 3) = (/&
&6.6189E-04_JPRB,7.5928E-04_JPRB,3.2622E-03_JPRB,4.5583E-03_JPRB,5.4192E-03_JPRB,4.9887E-03_JPRB/)
KBO( :, 1,28, 3) = (/&
&4.5041E-04_JPRB,5.1802E-04_JPRB,2.5459E-03_JPRB,3.6826E-03_JPRB,4.4432E-03_JPRB,4.1386E-03_JPRB/)
KBO( :, 2,28, 3) = (/&
&4.6818E-04_JPRB,5.4025E-04_JPRB,2.5901E-03_JPRB,3.7166E-03_JPRB,4.4776E-03_JPRB,4.1576E-03_JPRB/)
KBO( :, 3,28, 3) = (/&
&4.9122E-04_JPRB,5.6731E-04_JPRB,2.6317E-03_JPRB,3.7378E-03_JPRB,4.4848E-03_JPRB,4.1511E-03_JPRB/)
KBO( :, 4,28, 3) = (/&
&5.2165E-04_JPRB,6.0153E-04_JPRB,2.6701E-03_JPRB,3.7517E-03_JPRB,4.4733E-03_JPRB,4.1214E-03_JPRB/)
KBO( :, 5,28, 3) = (/&
&5.5747E-04_JPRB,6.4051E-04_JPRB,2.7007E-03_JPRB,3.7587E-03_JPRB,4.4498E-03_JPRB,4.0722E-03_JPRB/)
KBO( :, 1,29, 3) = (/&
&3.7413E-04_JPRB,4.3196E-04_JPRB,2.1044E-03_JPRB,3.0343E-03_JPRB,3.6585E-03_JPRB,3.3981E-03_JPRB/)
KBO( :, 2,29, 3) = (/&
&3.9017E-04_JPRB,4.5166E-04_JPRB,2.1424E-03_JPRB,3.0612E-03_JPRB,3.6810E-03_JPRB,3.4095E-03_JPRB/)
KBO( :, 3,29, 3) = (/&
&4.1157E-04_JPRB,4.7625E-04_JPRB,2.1792E-03_JPRB,3.0806E-03_JPRB,3.6837E-03_JPRB,3.4002E-03_JPRB/)
KBO( :, 4,29, 3) = (/&
&4.3865E-04_JPRB,5.0663E-04_JPRB,2.2090E-03_JPRB,3.0938E-03_JPRB,3.6744E-03_JPRB,3.3735E-03_JPRB/)
KBO( :, 5,29, 3) = (/&
&4.7012E-04_JPRB,5.4039E-04_JPRB,2.2354E-03_JPRB,3.1005E-03_JPRB,3.6551E-03_JPRB,3.3297E-03_JPRB/)
KBO( :, 1,30, 3) = (/&
&3.1103E-04_JPRB,3.6024E-04_JPRB,1.7406E-03_JPRB,2.5005E-03_JPRB,3.0110E-03_JPRB,2.7911E-03_JPRB/)
KBO( :, 2,30, 3) = (/&
&3.2577E-04_JPRB,3.7785E-04_JPRB,1.7737E-03_JPRB,2.5236E-03_JPRB,3.0255E-03_JPRB,2.7972E-03_JPRB/)
KBO( :, 3,30, 3) = (/&
&3.4538E-04_JPRB,4.0017E-04_JPRB,1.8036E-03_JPRB,2.5406E-03_JPRB,3.0269E-03_JPRB,2.7870E-03_JPRB/)
KBO( :, 4,30, 3) = (/&
&3.6935E-04_JPRB,4.2673E-04_JPRB,1.8286E-03_JPRB,2.5529E-03_JPRB,3.0186E-03_JPRB,2.7615E-03_JPRB/)
KBO( :, 5,30, 3) = (/&
&3.9676E-04_JPRB,4.5608E-04_JPRB,1.8513E-03_JPRB,2.5584E-03_JPRB,3.0040E-03_JPRB,2.7242E-03_JPRB/)
KBO( :, 1,31, 3) = (/&
&2.5900E-04_JPRB,3.0066E-04_JPRB,1.4406E-03_JPRB,2.0618E-03_JPRB,2.4773E-03_JPRB,2.2948E-03_JPRB/)
KBO( :, 2,31, 3) = (/&
&2.7261E-04_JPRB,3.1655E-04_JPRB,1.4684E-03_JPRB,2.0810E-03_JPRB,2.4873E-03_JPRB,2.2978E-03_JPRB/)
KBO( :, 3,31, 3) = (/&
&2.9037E-04_JPRB,3.3669E-04_JPRB,1.4928E-03_JPRB,2.0966E-03_JPRB,2.4881E-03_JPRB,2.2878E-03_JPRB/)
KBO( :, 4,31, 3) = (/&
&3.1154E-04_JPRB,3.5979E-04_JPRB,1.5138E-03_JPRB,2.1064E-03_JPRB,2.4823E-03_JPRB,2.2654E-03_JPRB/)
KBO( :, 5,31, 3) = (/&
&3.3507E-04_JPRB,3.8509E-04_JPRB,1.5342E-03_JPRB,2.1116E-03_JPRB,2.4709E-03_JPRB,2.2338E-03_JPRB/)
KBO( :, 1,32, 3) = (/&
&2.1614E-04_JPRB,2.5126E-04_JPRB,1.1930E-03_JPRB,1.7007E-03_JPRB,2.0381E-03_JPRB,1.8878E-03_JPRB/)
KBO( :, 2,32, 3) = (/&
&2.2861E-04_JPRB,2.6571E-04_JPRB,1.2162E-03_JPRB,1.7180E-03_JPRB,2.0460E-03_JPRB,1.8890E-03_JPRB/)
KBO( :, 3,32, 3) = (/&
&2.4457E-04_JPRB,2.8365E-04_JPRB,1.2363E-03_JPRB,1.7307E-03_JPRB,2.0470E-03_JPRB,1.8790E-03_JPRB/)
KBO( :, 4,32, 3) = (/&
&2.6297E-04_JPRB,3.0364E-04_JPRB,1.2543E-03_JPRB,1.7385E-03_JPRB,2.0430E-03_JPRB,1.8594E-03_JPRB/)
KBO( :, 5,32, 3) = (/&
&2.8320E-04_JPRB,3.2527E-04_JPRB,1.2726E-03_JPRB,1.7439E-03_JPRB,2.0334E-03_JPRB,1.8328E-03_JPRB/)
KBO( :, 1,33, 3) = (/&
&1.8077E-04_JPRB,2.1039E-04_JPRB,9.8840E-04_JPRB,1.4043E-03_JPRB,1.6777E-03_JPRB,1.5543E-03_JPRB/)
KBO( :, 2,33, 3) = (/&
&1.9220E-04_JPRB,2.2350E-04_JPRB,1.0074E-03_JPRB,1.4187E-03_JPRB,1.6838E-03_JPRB,1.5538E-03_JPRB/)
KBO( :, 3,33, 3) = (/&
&2.0626E-04_JPRB,2.3918E-04_JPRB,1.0244E-03_JPRB,1.4289E-03_JPRB,1.6852E-03_JPRB,1.5443E-03_JPRB/)
KBO( :, 4,33, 3) = (/&
&2.2215E-04_JPRB,2.5639E-04_JPRB,1.0403E-03_JPRB,1.4356E-03_JPRB,1.6818E-03_JPRB,1.5277E-03_JPRB/)
KBO( :, 5,33, 3) = (/&
&2.3958E-04_JPRB,2.7494E-04_JPRB,1.0565E-03_JPRB,1.4410E-03_JPRB,1.6741E-03_JPRB,1.5054E-03_JPRB/)
KBO( :, 1,34, 3) = (/&
&1.5119E-04_JPRB,1.7609E-04_JPRB,8.1855E-04_JPRB,1.1596E-03_JPRB,1.3812E-03_JPRB,1.2791E-03_JPRB/)
KBO( :, 2,34, 3) = (/&
&1.6145E-04_JPRB,1.8785E-04_JPRB,8.3425E-04_JPRB,1.1712E-03_JPRB,1.3866E-03_JPRB,1.2773E-03_JPRB/)
KBO( :, 3,34, 3) = (/&
&1.7367E-04_JPRB,2.0133E-04_JPRB,8.4883E-04_JPRB,1.1799E-03_JPRB,1.3882E-03_JPRB,1.2691E-03_JPRB/)
KBO( :, 4,34, 3) = (/&
&1.8734E-04_JPRB,2.1609E-04_JPRB,8.6307E-04_JPRB,1.1863E-03_JPRB,1.3855E-03_JPRB,1.2550E-03_JPRB/)
KBO( :, 5,34, 3) = (/&
&2.0225E-04_JPRB,2.3202E-04_JPRB,8.7752E-04_JPRB,1.1920E-03_JPRB,1.3795E-03_JPRB,1.2363E-03_JPRB/)
KBO( :, 1,35, 3) = (/&
&1.2586E-04_JPRB,1.4671E-04_JPRB,6.7658E-04_JPRB,9.5649E-04_JPRB,1.1370E-03_JPRB,1.0523E-03_JPRB/)
KBO( :, 2,35, 3) = (/&
&1.3479E-04_JPRB,1.5694E-04_JPRB,6.9016E-04_JPRB,9.6658E-04_JPRB,1.1423E-03_JPRB,1.0509E-03_JPRB/)
KBO( :, 3,35, 3) = (/&
&1.4527E-04_JPRB,1.6840E-04_JPRB,7.0251E-04_JPRB,9.7407E-04_JPRB,1.1435E-03_JPRB,1.0441E-03_JPRB/)
KBO( :, 4,35, 3) = (/&
&1.5691E-04_JPRB,1.8098E-04_JPRB,7.1533E-04_JPRB,9.8058E-04_JPRB,1.1418E-03_JPRB,1.0326E-03_JPRB/)
KBO( :, 5,35, 3) = (/&
&1.6957E-04_JPRB,1.9459E-04_JPRB,7.2799E-04_JPRB,9.8636E-04_JPRB,1.1378E-03_JPRB,1.0171E-03_JPRB/)
KBO( :, 1,36, 3) = (/&
&1.0414E-04_JPRB,1.2151E-04_JPRB,5.5801E-04_JPRB,7.8827E-04_JPRB,9.3599E-04_JPRB,8.6559E-04_JPRB/)
KBO( :, 2,36, 3) = (/&
&1.1170E-04_JPRB,1.3016E-04_JPRB,5.6976E-04_JPRB,7.9724E-04_JPRB,9.4085E-04_JPRB,8.6498E-04_JPRB/)
KBO( :, 3,36, 3) = (/&
&1.2056E-04_JPRB,1.3986E-04_JPRB,5.8091E-04_JPRB,8.0448E-04_JPRB,9.4273E-04_JPRB,8.5997E-04_JPRB/)
KBO( :, 4,36, 3) = (/&
&1.3038E-04_JPRB,1.5047E-04_JPRB,5.9203E-04_JPRB,8.1040E-04_JPRB,9.4179E-04_JPRB,8.5084E-04_JPRB/)
KBO( :, 5,36, 3) = (/&
&1.4104E-04_JPRB,1.6199E-04_JPRB,6.0308E-04_JPRB,8.1605E-04_JPRB,9.3933E-04_JPRB,8.3818E-04_JPRB/)
KBO( :, 1,37, 3) = (/&
&8.5323E-05_JPRB,9.9664E-05_JPRB,4.5884E-04_JPRB,6.4852E-04_JPRB,7.6974E-04_JPRB,7.1141E-04_JPRB/)
KBO( :, 2,37, 3) = (/&
&9.1527E-05_JPRB,1.0682E-04_JPRB,4.6909E-04_JPRB,6.5669E-04_JPRB,7.7467E-04_JPRB,7.1194E-04_JPRB/)
KBO( :, 3,37, 3) = (/&
&9.8871E-05_JPRB,1.1487E-04_JPRB,4.7886E-04_JPRB,6.6345E-04_JPRB,7.7695E-04_JPRB,7.0849E-04_JPRB/)
KBO( :, 4,37, 3) = (/&
&1.0704E-04_JPRB,1.2374E-04_JPRB,4.8883E-04_JPRB,6.6930E-04_JPRB,7.7737E-04_JPRB,7.0168E-04_JPRB/)
KBO( :, 5,37, 3) = (/&
&1.1597E-04_JPRB,1.3339E-04_JPRB,4.9841E-04_JPRB,6.7481E-04_JPRB,7.7624E-04_JPRB,6.9182E-04_JPRB/)
KBO( :, 1,38, 3) = (/&
&6.9864E-05_JPRB,8.1702E-05_JPRB,3.7720E-04_JPRB,5.3356E-04_JPRB,6.3309E-04_JPRB,5.8498E-04_JPRB/)
KBO( :, 2,38, 3) = (/&
&7.4949E-05_JPRB,8.7605E-05_JPRB,3.8612E-04_JPRB,5.4085E-04_JPRB,6.3774E-04_JPRB,5.8615E-04_JPRB/)
KBO( :, 3,38, 3) = (/&
&8.1032E-05_JPRB,9.4290E-05_JPRB,3.9469E-04_JPRB,5.4710E-04_JPRB,6.4046E-04_JPRB,5.8424E-04_JPRB/)
KBO( :, 4,38, 3) = (/&
&8.7830E-05_JPRB,1.0169E-04_JPRB,4.0337E-04_JPRB,5.5261E-04_JPRB,6.4155E-04_JPRB,5.7913E-04_JPRB/)
KBO( :, 5,38, 3) = (/&
&9.5293E-05_JPRB,1.0978E-04_JPRB,4.1177E-04_JPRB,5.5788E-04_JPRB,6.4154E-04_JPRB,5.7166E-04_JPRB/)
KBO( :, 1,39, 3) = (/&
&5.7197E-05_JPRB,6.6973E-05_JPRB,3.1005E-04_JPRB,4.3874E-04_JPRB,5.2056E-04_JPRB,4.8131E-04_JPRB/)
KBO( :, 2,39, 3) = (/&
&6.1371E-05_JPRB,7.1842E-05_JPRB,3.1779E-04_JPRB,4.4531E-04_JPRB,5.2502E-04_JPRB,4.8298E-04_JPRB/)
KBO( :, 3,39, 3) = (/&
&6.6407E-05_JPRB,7.7394E-05_JPRB,3.2540E-04_JPRB,4.5115E-04_JPRB,5.2799E-04_JPRB,4.8215E-04_JPRB/)
KBO( :, 4,39, 3) = (/&
&7.2064E-05_JPRB,8.3560E-05_JPRB,3.3301E-04_JPRB,4.5632E-04_JPRB,5.2961E-04_JPRB,4.7858E-04_JPRB/)
KBO( :, 5,39, 3) = (/&
&7.8303E-05_JPRB,9.0355E-05_JPRB,3.4035E-04_JPRB,4.6134E-04_JPRB,5.3031E-04_JPRB,4.7308E-04_JPRB/)
KBO( :, 1,40, 3) = (/&
&4.6522E-05_JPRB,5.4522E-05_JPRB,2.5421E-04_JPRB,3.6027E-04_JPRB,4.2767E-04_JPRB,3.9473E-04_JPRB/)
KBO( :, 2,40, 3) = (/&
&4.9863E-05_JPRB,5.8471E-05_JPRB,2.6092E-04_JPRB,3.6612E-04_JPRB,4.3197E-04_JPRB,3.9681E-04_JPRB/)
KBO( :, 3,40, 3) = (/&
&5.3968E-05_JPRB,6.3027E-05_JPRB,2.6757E-04_JPRB,3.7152E-04_JPRB,4.3513E-04_JPRB,3.9683E-04_JPRB/)
KBO( :, 4,40, 3) = (/&
&5.8623E-05_JPRB,6.8126E-05_JPRB,2.7426E-04_JPRB,3.7636E-04_JPRB,4.3711E-04_JPRB,3.9452E-04_JPRB/)
KBO( :, 5,40, 3) = (/&
&6.3789E-05_JPRB,7.3766E-05_JPRB,2.8070E-04_JPRB,3.8106E-04_JPRB,4.3831E-04_JPRB,3.9053E-04_JPRB/)
KBO( :, 1,41, 3) = (/&
&3.7804E-05_JPRB,4.4333E-05_JPRB,2.0821E-04_JPRB,2.9549E-04_JPRB,3.5103E-04_JPRB,3.2341E-04_JPRB/)
KBO( :, 2,41, 3) = (/&
&4.0492E-05_JPRB,4.7550E-05_JPRB,2.1408E-04_JPRB,3.0089E-04_JPRB,3.5532E-04_JPRB,3.2587E-04_JPRB/)
KBO( :, 3,41, 3) = (/&
&4.3795E-05_JPRB,5.1265E-05_JPRB,2.1987E-04_JPRB,3.0577E-04_JPRB,3.5843E-04_JPRB,3.2638E-04_JPRB/)
KBO( :, 4,41, 3) = (/&
&4.7619E-05_JPRB,5.5462E-05_JPRB,2.2575E-04_JPRB,3.1023E-04_JPRB,3.6066E-04_JPRB,3.2506E-04_JPRB/)
KBO( :, 5,41, 3) = (/&
&5.1898E-05_JPRB,6.0154E-05_JPRB,2.3138E-04_JPRB,3.1463E-04_JPRB,3.6219E-04_JPRB,3.2225E-04_JPRB/)
KBO( :, 1,42, 3) = (/&
&3.0725E-05_JPRB,3.6043E-05_JPRB,1.7048E-04_JPRB,2.4228E-04_JPRB,2.8802E-04_JPRB,2.6497E-04_JPRB/)
KBO( :, 2,42, 3) = (/&
&3.2881E-05_JPRB,3.8663E-05_JPRB,1.7559E-04_JPRB,2.4716E-04_JPRB,2.9210E-04_JPRB,2.6748E-04_JPRB/)
KBO( :, 3,42, 3) = (/&
&3.5527E-05_JPRB,4.1681E-05_JPRB,1.8062E-04_JPRB,2.5152E-04_JPRB,2.9511E-04_JPRB,2.6841E-04_JPRB/)
KBO( :, 4,42, 3) = (/&
&3.8664E-05_JPRB,4.5134E-05_JPRB,1.8577E-04_JPRB,2.5564E-04_JPRB,2.9747E-04_JPRB,2.6786E-04_JPRB/)
KBO( :, 5,42, 3) = (/&
&4.2195E-05_JPRB,4.9021E-05_JPRB,1.9068E-04_JPRB,2.5970E-04_JPRB,2.9919E-04_JPRB,2.6599E-04_JPRB/)
KBO( :, 1,43, 3) = (/&
&2.4891E-05_JPRB,2.9187E-05_JPRB,1.3928E-04_JPRB,1.9831E-04_JPRB,2.3592E-04_JPRB,2.1675E-04_JPRB/)
KBO( :, 2,43, 3) = (/&
&2.6593E-05_JPRB,3.1301E-05_JPRB,1.4374E-04_JPRB,2.0272E-04_JPRB,2.3983E-04_JPRB,2.1942E-04_JPRB/)
KBO( :, 3,43, 3) = (/&
&2.8690E-05_JPRB,3.3747E-05_JPRB,1.4810E-04_JPRB,2.0668E-04_JPRB,2.4285E-04_JPRB,2.2071E-04_JPRB/)
KBO( :, 4,43, 3) = (/&
&3.1232E-05_JPRB,3.6547E-05_JPRB,1.5256E-04_JPRB,2.1038E-04_JPRB,2.4515E-04_JPRB,2.2071E-04_JPRB/)
KBO( :, 5,43, 3) = (/&
&3.4120E-05_JPRB,3.9743E-05_JPRB,1.5683E-04_JPRB,2.1407E-04_JPRB,2.4696E-04_JPRB,2.1958E-04_JPRB/)
KBO( :, 1,44, 3) = (/&
&2.0144E-05_JPRB,2.3605E-05_JPRB,1.1366E-04_JPRB,1.6217E-04_JPRB,1.9304E-04_JPRB,1.7720E-04_JPRB/)
KBO( :, 2,44, 3) = (/&
&2.1468E-05_JPRB,2.5288E-05_JPRB,1.1746E-04_JPRB,1.6601E-04_JPRB,1.9664E-04_JPRB,1.7978E-04_JPRB/)
KBO( :, 3,44, 3) = (/&
&2.3117E-05_JPRB,2.7255E-05_JPRB,1.2127E-04_JPRB,1.6962E-04_JPRB,1.9955E-04_JPRB,1.8133E-04_JPRB/)
KBO( :, 4,44, 3) = (/&
&2.5167E-05_JPRB,2.9525E-05_JPRB,1.2515E-04_JPRB,1.7298E-04_JPRB,2.0188E-04_JPRB,1.8182E-04_JPRB/)
KBO( :, 5,44, 3) = (/&
&2.7509E-05_JPRB,3.2133E-05_JPRB,1.2890E-04_JPRB,1.7631E-04_JPRB,2.0373E-04_JPRB,1.8128E-04_JPRB/)
KBO( :, 1,45, 3) = (/&
&1.6315E-05_JPRB,1.9099E-05_JPRB,9.2658E-05_JPRB,1.3247E-04_JPRB,1.5777E-04_JPRB,1.4481E-04_JPRB/)
KBO( :, 2,45, 3) = (/&
&1.7341E-05_JPRB,2.0427E-05_JPRB,9.5960E-05_JPRB,1.3596E-04_JPRB,1.6122E-04_JPRB,1.4738E-04_JPRB/)
KBO( :, 3,45, 3) = (/&
&1.8647E-05_JPRB,2.2022E-05_JPRB,9.9238E-05_JPRB,1.3912E-04_JPRB,1.6388E-04_JPRB,1.4901E-04_JPRB/)
KBO( :, 4,45, 3) = (/&
&2.0262E-05_JPRB,2.3840E-05_JPRB,1.0260E-04_JPRB,1.4211E-04_JPRB,1.6610E-04_JPRB,1.4980E-04_JPRB/)
KBO( :, 5,45, 3) = (/&
&2.2167E-05_JPRB,2.5969E-05_JPRB,1.0588E-04_JPRB,1.4512E-04_JPRB,1.6796E-04_JPRB,1.4976E-04_JPRB/)
KBO( :, 1,46, 3) = (/&
&1.3211E-05_JPRB,1.5446E-05_JPRB,7.5427E-05_JPRB,1.0806E-04_JPRB,1.2876E-04_JPRB,1.1821E-04_JPRB/)
KBO( :, 2,46, 3) = (/&
&1.3990E-05_JPRB,1.6470E-05_JPRB,7.8248E-05_JPRB,1.1113E-04_JPRB,1.3193E-04_JPRB,1.2064E-04_JPRB/)
KBO( :, 3,46, 3) = (/&
&1.5013E-05_JPRB,1.7753E-05_JPRB,8.1102E-05_JPRB,1.1397E-04_JPRB,1.3444E-04_JPRB,1.2234E-04_JPRB/)
KBO( :, 4,46, 3) = (/&
&1.6277E-05_JPRB,1.9210E-05_JPRB,8.3980E-05_JPRB,1.1663E-04_JPRB,1.3652E-04_JPRB,1.2338E-04_JPRB/)
KBO( :, 5,46, 3) = (/&
&1.7816E-05_JPRB,2.0932E-05_JPRB,8.6856E-05_JPRB,1.1931E-04_JPRB,1.3833E-04_JPRB,1.2371E-04_JPRB/)
KBO( :, 1,47, 3) = (/&
&1.0695E-05_JPRB,1.2476E-05_JPRB,6.1245E-05_JPRB,8.7921E-05_JPRB,1.0481E-04_JPRB,9.6236E-05_JPRB/)
KBO( :, 2,47, 3) = (/&
&1.1263E-05_JPRB,1.3243E-05_JPRB,6.3648E-05_JPRB,9.0656E-05_JPRB,1.0772E-04_JPRB,9.8519E-05_JPRB/)
KBO( :, 3,47, 3) = (/&
&1.2048E-05_JPRB,1.4259E-05_JPRB,6.6115E-05_JPRB,9.3168E-05_JPRB,1.1009E-04_JPRB,1.0023E-04_JPRB/)
KBO( :, 4,47, 3) = (/&
&1.3032E-05_JPRB,1.5427E-05_JPRB,6.8598E-05_JPRB,9.5568E-05_JPRB,1.1206E-04_JPRB,1.0142E-04_JPRB/)
KBO( :, 5,47, 3) = (/&
&1.4254E-05_JPRB,1.6795E-05_JPRB,7.1096E-05_JPRB,9.7934E-05_JPRB,1.1379E-04_JPRB,1.0199E-04_JPRB/)
KBO( :, 1,48, 3) = (/&
&8.6841E-06_JPRB,1.0096E-05_JPRB,4.9694E-05_JPRB,7.1452E-05_JPRB,8.5259E-05_JPRB,7.8307E-05_JPRB/)
KBO( :, 2,48, 3) = (/&
&9.0796E-06_JPRB,1.0659E-05_JPRB,5.1740E-05_JPRB,7.3900E-05_JPRB,8.7875E-05_JPRB,8.0451E-05_JPRB/)
KBO( :, 3,48, 3) = (/&
&9.6769E-06_JPRB,1.1450E-05_JPRB,5.3831E-05_JPRB,7.6095E-05_JPRB,9.0067E-05_JPRB,8.2117E-05_JPRB/)
KBO( :, 4,48, 3) = (/&
&1.0440E-05_JPRB,1.2385E-05_JPRB,5.5960E-05_JPRB,7.8221E-05_JPRB,9.1891E-05_JPRB,8.3379E-05_JPRB/)
KBO( :, 5,48, 3) = (/&
&1.1399E-05_JPRB,1.3468E-05_JPRB,5.8115E-05_JPRB,8.0301E-05_JPRB,9.3494E-05_JPRB,8.4132E-05_JPRB/)
KBO( :, 1,49, 3) = (/&
&7.0695E-06_JPRB,8.1883E-06_JPRB,4.0270E-05_JPRB,5.7981E-05_JPRB,6.9259E-05_JPRB,6.3681E-05_JPRB/)
KBO( :, 2,49, 3) = (/&
&7.3322E-06_JPRB,8.5897E-06_JPRB,4.2014E-05_JPRB,6.0156E-05_JPRB,7.1569E-05_JPRB,6.5714E-05_JPRB/)
KBO( :, 3,49, 3) = (/&
&7.7779E-06_JPRB,9.1932E-06_JPRB,4.3778E-05_JPRB,6.2075E-05_JPRB,7.3581E-05_JPRB,6.7311E-05_JPRB/)
KBO( :, 4,49, 3) = (/&
&8.3667E-06_JPRB,9.9391E-06_JPRB,4.5605E-05_JPRB,6.3945E-05_JPRB,7.5254E-05_JPRB,6.8602E-05_JPRB/)
KBO( :, 5,49, 3) = (/&
&9.1100E-06_JPRB,1.0797E-05_JPRB,4.7455E-05_JPRB,6.5783E-05_JPRB,7.6741E-05_JPRB,6.9496E-05_JPRB/)
KBO( :, 1,50, 3) = (/&
&5.7666E-06_JPRB,6.6617E-06_JPRB,3.2634E-05_JPRB,4.7026E-05_JPRB,5.6231E-05_JPRB,5.1646E-05_JPRB/)
KBO( :, 2,50, 3) = (/&
&5.9413E-06_JPRB,6.9423E-06_JPRB,3.4121E-05_JPRB,4.8951E-05_JPRB,5.8275E-05_JPRB,5.3533E-05_JPRB/)
KBO( :, 3,50, 3) = (/&
&6.2683E-06_JPRB,7.3972E-06_JPRB,3.5607E-05_JPRB,5.0641E-05_JPRB,6.0090E-05_JPRB,5.4999E-05_JPRB/)
KBO( :, 4,50, 3) = (/&
&6.7199E-06_JPRB,7.9879E-06_JPRB,3.7167E-05_JPRB,5.2275E-05_JPRB,6.1608E-05_JPRB,5.6235E-05_JPRB/)
KBO( :, 5,50, 3) = (/&
&7.3034E-06_JPRB,8.6808E-06_JPRB,3.8757E-05_JPRB,5.3881E-05_JPRB,6.2968E-05_JPRB,5.7167E-05_JPRB/)
KBO( :, 1,51, 3) = (/&
&4.7086E-06_JPRB,5.4299E-06_JPRB,2.6424E-05_JPRB,3.8115E-05_JPRB,4.5610E-05_JPRB,4.1794E-05_JPRB/)
KBO( :, 2,51, 3) = (/&
&4.8287E-06_JPRB,5.6240E-06_JPRB,2.7697E-05_JPRB,3.9799E-05_JPRB,4.7412E-05_JPRB,4.3512E-05_JPRB/)
KBO( :, 3,51, 3) = (/&
&5.0606E-06_JPRB,5.9604E-06_JPRB,2.8952E-05_JPRB,4.1290E-05_JPRB,4.9031E-05_JPRB,4.4849E-05_JPRB/)
KBO( :, 4,51, 3) = (/&
&5.4065E-06_JPRB,6.4263E-06_JPRB,3.0283E-05_JPRB,4.2717E-05_JPRB,5.0424E-05_JPRB,4.5995E-05_JPRB/)
KBO( :, 5,51, 3) = (/&
&5.8615E-06_JPRB,6.9820E-06_JPRB,3.1641E-05_JPRB,4.4120E-05_JPRB,5.1647E-05_JPRB,4.6912E-05_JPRB/)
KBO( :, 1,52, 3) = (/&
&3.8436E-06_JPRB,4.4274E-06_JPRB,2.1373E-05_JPRB,3.0858E-05_JPRB,3.6953E-05_JPRB,3.3785E-05_JPRB/)
KBO( :, 2,52, 3) = (/&
&3.9328E-06_JPRB,4.5651E-06_JPRB,2.2468E-05_JPRB,3.2320E-05_JPRB,3.8527E-05_JPRB,3.5353E-05_JPRB/)
KBO( :, 3,52, 3) = (/&
&4.0914E-06_JPRB,4.8085E-06_JPRB,2.3521E-05_JPRB,3.3631E-05_JPRB,3.9963E-05_JPRB,3.6585E-05_JPRB/)
KBO( :, 4,52, 3) = (/&
&4.3531E-06_JPRB,5.1701E-06_JPRB,2.4643E-05_JPRB,3.4861E-05_JPRB,4.1208E-05_JPRB,3.7630E-05_JPRB/)
KBO( :, 5,52, 3) = (/&
&4.7050E-06_JPRB,5.6131E-06_JPRB,2.5801E-05_JPRB,3.6084E-05_JPRB,4.2308E-05_JPRB,3.8507E-05_JPRB/)
KBO( :, 1,53, 3) = (/&
&3.1307E-06_JPRB,3.6090E-06_JPRB,1.7271E-05_JPRB,2.4948E-05_JPRB,2.9905E-05_JPRB,2.7291E-05_JPRB/)
KBO( :, 2,53, 3) = (/&
&3.2062E-06_JPRB,3.7126E-06_JPRB,1.8207E-05_JPRB,2.6210E-05_JPRB,3.1263E-05_JPRB,2.8728E-05_JPRB/)
KBO( :, 3,53, 3) = (/&
&3.3144E-06_JPRB,3.8844E-06_JPRB,1.9096E-05_JPRB,2.7367E-05_JPRB,3.2548E-05_JPRB,2.9869E-05_JPRB/)
KBO( :, 4,53, 3) = (/&
&3.5077E-06_JPRB,4.1595E-06_JPRB,2.0034E-05_JPRB,2.8427E-05_JPRB,3.3652E-05_JPRB,3.0823E-05_JPRB/)
KBO( :, 5,53, 3) = (/&
&3.7772E-06_JPRB,4.5101E-06_JPRB,2.1018E-05_JPRB,2.9487E-05_JPRB,3.4629E-05_JPRB,3.1664E-05_JPRB/)
KBO( :, 1,54, 3) = (/&
&2.5452E-06_JPRB,2.9417E-06_JPRB,1.3965E-05_JPRB,2.0178E-05_JPRB,2.4209E-05_JPRB,2.1911E-05_JPRB/)
KBO( :, 2,54, 3) = (/&
&2.6173E-06_JPRB,3.0265E-06_JPRB,1.4760E-05_JPRB,2.1266E-05_JPRB,2.5377E-05_JPRB,2.3188E-05_JPRB/)
KBO( :, 3,54, 3) = (/&
&2.6943E-06_JPRB,3.1475E-06_JPRB,1.5512E-05_JPRB,2.2269E-05_JPRB,2.6497E-05_JPRB,2.4193E-05_JPRB/)
KBO( :, 4,54, 3) = (/&
&2.8346E-06_JPRB,3.3549E-06_JPRB,1.6295E-05_JPRB,2.3183E-05_JPRB,2.7474E-05_JPRB,2.5015E-05_JPRB/)
KBO( :, 5,54, 3) = (/&
&3.0408E-06_JPRB,3.6324E-06_JPRB,1.7127E-05_JPRB,2.4100E-05_JPRB,2.8339E-05_JPRB,2.5745E-05_JPRB/)
KBO( :, 1,55, 3) = (/&
&2.0632E-06_JPRB,2.3940E-06_JPRB,1.1296E-05_JPRB,1.6316E-05_JPRB,1.9586E-05_JPRB,1.7519E-05_JPRB/)
KBO( :, 2,55, 3) = (/&
&2.1373E-06_JPRB,2.4691E-06_JPRB,1.1961E-05_JPRB,1.7242E-05_JPRB,2.0583E-05_JPRB,1.8621E-05_JPRB/)
KBO( :, 3,55, 3) = (/&
&2.1949E-06_JPRB,2.5561E-06_JPRB,1.2600E-05_JPRB,1.8111E-05_JPRB,2.1559E-05_JPRB,1.9499E-05_JPRB/)
KBO( :, 4,55, 3) = (/&
&2.2950E-06_JPRB,2.7109E-06_JPRB,1.3250E-05_JPRB,1.8899E-05_JPRB,2.2414E-05_JPRB,2.0198E-05_JPRB/)
KBO( :, 5,55, 3) = (/&
&2.4530E-06_JPRB,2.9291E-06_JPRB,1.3951E-05_JPRB,1.9686E-05_JPRB,2.3177E-05_JPRB,2.0800E-05_JPRB/)
KBO( :, 1,56, 3) = (/&
&1.6642E-06_JPRB,1.9426E-06_JPRB,9.1341E-06_JPRB,1.3181E-05_JPRB,1.5829E-05_JPRB,1.3992E-05_JPRB/)
KBO( :, 2,56, 3) = (/&
&1.7429E-06_JPRB,2.0139E-06_JPRB,9.6851E-06_JPRB,1.3963E-05_JPRB,1.6681E-05_JPRB,1.4936E-05_JPRB/)
KBO( :, 3,56, 3) = (/&
&1.7896E-06_JPRB,2.0795E-06_JPRB,1.0225E-05_JPRB,1.4716E-05_JPRB,1.7517E-05_JPRB,1.5702E-05_JPRB/)
KBO( :, 4,56, 3) = (/&
&1.8607E-06_JPRB,2.1923E-06_JPRB,1.0768E-05_JPRB,1.5397E-05_JPRB,1.8274E-05_JPRB,1.6306E-05_JPRB/)
KBO( :, 5,56, 3) = (/&
&1.9799E-06_JPRB,2.3617E-06_JPRB,1.1356E-05_JPRB,1.6070E-05_JPRB,1.8948E-05_JPRB,1.6801E-05_JPRB/)
KBO( :, 1,57, 3) = (/&
&1.3353E-06_JPRB,1.5730E-06_JPRB,7.3811E-06_JPRB,1.0640E-05_JPRB,1.2777E-05_JPRB,1.1158E-05_JPRB/)
KBO( :, 2,57, 3) = (/&
&1.4179E-06_JPRB,1.6416E-06_JPRB,7.8345E-06_JPRB,1.1296E-05_JPRB,1.3506E-05_JPRB,1.1962E-05_JPRB/)
KBO( :, 3,57, 3) = (/&
&1.4599E-06_JPRB,1.6939E-06_JPRB,8.2917E-06_JPRB,1.1945E-05_JPRB,1.4220E-05_JPRB,1.2633E-05_JPRB/)
KBO( :, 4,57, 3) = (/&
&1.5112E-06_JPRB,1.7747E-06_JPRB,8.7450E-06_JPRB,1.2531E-05_JPRB,1.4885E-05_JPRB,1.3158E-05_JPRB/)
KBO( :, 5,57, 3) = (/&
&1.5993E-06_JPRB,1.9047E-06_JPRB,9.2362E-06_JPRB,1.3103E-05_JPRB,1.5471E-05_JPRB,1.3571E-05_JPRB/)
KBO( :, 1,58, 3) = (/&
&1.0682E-06_JPRB,1.2707E-06_JPRB,5.9673E-06_JPRB,8.5915E-06_JPRB,1.0313E-05_JPRB,8.8875E-06_JPRB/)
KBO( :, 2,58, 3) = (/&
&1.1510E-06_JPRB,1.3372E-06_JPRB,6.3383E-06_JPRB,9.1371E-06_JPRB,1.0932E-05_JPRB,9.5717E-06_JPRB/)
KBO( :, 3,58, 3) = (/&
&1.1918E-06_JPRB,1.3813E-06_JPRB,6.7246E-06_JPRB,9.6935E-06_JPRB,1.1539E-05_JPRB,1.0149E-05_JPRB/)
KBO( :, 4,58, 3) = (/&
&1.2303E-06_JPRB,1.4399E-06_JPRB,7.1031E-06_JPRB,1.0198E-05_JPRB,1.2120E-05_JPRB,1.0603E-05_JPRB/)
KBO( :, 5,58, 3) = (/&
&1.2943E-06_JPRB,1.5387E-06_JPRB,7.5113E-06_JPRB,1.0682E-05_JPRB,1.2629E-05_JPRB,1.0955E-05_JPRB/)
KBO( :, 1,59, 3) = (/&
&8.6844E-07_JPRB,1.0371E-06_JPRB,4.8749E-06_JPRB,7.0111E-06_JPRB,8.4115E-06_JPRB,7.1461E-06_JPRB/)
KBO( :, 2,59, 3) = (/&
&9.4083E-07_JPRB,1.0954E-06_JPRB,5.1836E-06_JPRB,7.4691E-06_JPRB,8.9328E-06_JPRB,7.7016E-06_JPRB/)
KBO( :, 3,59, 3) = (/&
&9.7741E-07_JPRB,1.1331E-06_JPRB,5.5070E-06_JPRB,7.9393E-06_JPRB,9.4488E-06_JPRB,8.1607E-06_JPRB/)
KBO( :, 4,59, 3) = (/&
&1.0092E-06_JPRB,1.1806E-06_JPRB,5.8246E-06_JPRB,8.3651E-06_JPRB,9.9432E-06_JPRB,8.5246E-06_JPRB/)
KBO( :, 5,59, 3) = (/&
&1.0602E-06_JPRB,1.2608E-06_JPRB,6.1682E-06_JPRB,8.7778E-06_JPRB,1.0376E-05_JPRB,8.8030E-06_JPRB/)
KBO( :, 1,13, 4) = (/&
&1.1944E-02_JPRB,1.2168E-02_JPRB,5.9922E-02_JPRB,8.9367E-02_JPRB,1.1074E-01_JPRB,1.1944E-01_JPRB/)
KBO( :, 2,13, 4) = (/&
&1.2086E-02_JPRB,1.2304E-02_JPRB,6.1460E-02_JPRB,9.1456E-02_JPRB,1.1344E-01_JPRB,1.2412E-01_JPRB/)
KBO( :, 3,13, 4) = (/&
&1.2357E-02_JPRB,1.2570E-02_JPRB,6.2887E-02_JPRB,9.3358E-02_JPRB,1.1570E-01_JPRB,1.2845E-01_JPRB/)
KBO( :, 4,13, 4) = (/&
&1.2729E-02_JPRB,1.2937E-02_JPRB,6.4147E-02_JPRB,9.5013E-02_JPRB,1.1762E-01_JPRB,1.3226E-01_JPRB/)
KBO( :, 5,13, 4) = (/&
&1.3238E-02_JPRB,1.3440E-02_JPRB,6.5153E-02_JPRB,9.6392E-02_JPRB,1.1918E-01_JPRB,1.3570E-01_JPRB/)
KBO( :, 1,14, 4) = (/&
&1.0012E-02_JPRB,1.0247E-02_JPRB,5.2975E-02_JPRB,7.8942E-02_JPRB,9.7346E-02_JPRB,1.0368E-01_JPRB/)
KBO( :, 2,14, 4) = (/&
&1.0180E-02_JPRB,1.0410E-02_JPRB,5.4409E-02_JPRB,8.0856E-02_JPRB,9.9740E-02_JPRB,1.0751E-01_JPRB/)
KBO( :, 3,14, 4) = (/&
&1.0467E-02_JPRB,1.0689E-02_JPRB,5.5693E-02_JPRB,8.2579E-02_JPRB,1.0188E-01_JPRB,1.1093E-01_JPRB/)
KBO( :, 4,14, 4) = (/&
&1.0854E-02_JPRB,1.1067E-02_JPRB,5.6775E-02_JPRB,8.4028E-02_JPRB,1.0368E-01_JPRB,1.1389E-01_JPRB/)
KBO( :, 5,14, 4) = (/&
&1.1343E-02_JPRB,1.1549E-02_JPRB,5.7714E-02_JPRB,8.5292E-02_JPRB,1.0511E-01_JPRB,1.1652E-01_JPRB/)
KBO( :, 1,15, 4) = (/&
&8.3778E-03_JPRB,8.6309E-03_JPRB,4.6498E-02_JPRB,6.9169E-02_JPRB,8.4926E-02_JPRB,8.9479E-02_JPRB/)
KBO( :, 2,15, 4) = (/&
&8.5667E-03_JPRB,8.8101E-03_JPRB,4.7757E-02_JPRB,7.0912E-02_JPRB,8.7130E-02_JPRB,9.2622E-02_JPRB/)
KBO( :, 3,15, 4) = (/&
&8.8588E-03_JPRB,9.0893E-03_JPRB,4.8864E-02_JPRB,7.2379E-02_JPRB,8.9054E-02_JPRB,9.5411E-02_JPRB/)
KBO( :, 4,15, 4) = (/&
&9.2397E-03_JPRB,9.4599E-03_JPRB,4.9829E-02_JPRB,7.3692E-02_JPRB,9.0686E-02_JPRB,9.7794E-02_JPRB/)
KBO( :, 5,15, 4) = (/&
&9.6728E-03_JPRB,9.8843E-03_JPRB,5.0711E-02_JPRB,7.4868E-02_JPRB,9.2000E-02_JPRB,9.9673E-02_JPRB/)
KBO( :, 1,16, 4) = (/&
&7.0032E-03_JPRB,7.2800E-03_JPRB,4.0493E-02_JPRB,6.0087E-02_JPRB,7.3654E-02_JPRB,7.6847E-02_JPRB/)
KBO( :, 2,16, 4) = (/&
&7.2046E-03_JPRB,7.4657E-03_JPRB,4.1559E-02_JPRB,6.1552E-02_JPRB,7.5591E-02_JPRB,7.9522E-02_JPRB/)
KBO( :, 3,16, 4) = (/&
&7.4951E-03_JPRB,7.7408E-03_JPRB,4.2525E-02_JPRB,6.2872E-02_JPRB,7.7303E-02_JPRB,8.1850E-02_JPRB/)
KBO( :, 4,16, 4) = (/&
&7.8374E-03_JPRB,8.0731E-03_JPRB,4.3431E-02_JPRB,6.4066E-02_JPRB,7.8697E-02_JPRB,8.3564E-02_JPRB/)
KBO( :, 5,16, 4) = (/&
&8.2028E-03_JPRB,8.4261E-03_JPRB,4.4256E-02_JPRB,6.5005E-02_JPRB,7.9598E-02_JPRB,8.4430E-02_JPRB/)
KBO( :, 1,17, 4) = (/&
&5.8518E-03_JPRB,6.1531E-03_JPRB,3.4959E-02_JPRB,5.1741E-02_JPRB,6.3466E-02_JPRB,6.5605E-02_JPRB/)
KBO( :, 2,17, 4) = (/&
&6.0575E-03_JPRB,6.3417E-03_JPRB,3.5874E-02_JPRB,5.3013E-02_JPRB,6.5151E-02_JPRB,6.7823E-02_JPRB/)
KBO( :, 3,17, 4) = (/&
&6.3232E-03_JPRB,6.5951E-03_JPRB,3.6761E-02_JPRB,5.4168E-02_JPRB,6.6560E-02_JPRB,6.9496E-02_JPRB/)
KBO( :, 4,17, 4) = (/&
&6.6221E-03_JPRB,6.8782E-03_JPRB,3.7567E-02_JPRB,5.5100E-02_JPRB,6.7478E-02_JPRB,7.0358E-02_JPRB/)
KBO( :, 5,17, 4) = (/&
&6.9347E-03_JPRB,7.1778E-03_JPRB,3.8256E-02_JPRB,5.5641E-02_JPRB,6.7818E-02_JPRB,7.0537E-02_JPRB/)
KBO( :, 1,18, 4) = (/&
&4.8880E-03_JPRB,5.2055E-03_JPRB,2.9960E-02_JPRB,4.4255E-02_JPRB,5.4342E-02_JPRB,5.5684E-02_JPRB/)
KBO( :, 2,18, 4) = (/&
&5.0836E-03_JPRB,5.3884E-03_JPRB,3.0780E-02_JPRB,4.5359E-02_JPRB,5.5706E-02_JPRB,5.7297E-02_JPRB/)
KBO( :, 3,18, 4) = (/&
&5.3194E-03_JPRB,5.6126E-03_JPRB,3.1543E-02_JPRB,4.6238E-02_JPRB,5.6632E-02_JPRB,5.8242E-02_JPRB/)
KBO( :, 4,18, 4) = (/&
&5.5796E-03_JPRB,5.8558E-03_JPRB,3.2190E-02_JPRB,4.6796E-02_JPRB,5.7064E-02_JPRB,5.8579E-02_JPRB/)
KBO( :, 5,18, 4) = (/&
&5.8422E-03_JPRB,6.1083E-03_JPRB,3.2701E-02_JPRB,4.7066E-02_JPRB,5.7105E-02_JPRB,5.8483E-02_JPRB/)
KBO( :, 1,19, 4) = (/&
&4.0830E-03_JPRB,4.4003E-03_JPRB,2.5536E-02_JPRB,3.7635E-02_JPRB,4.6188E-02_JPRB,4.6830E-02_JPRB/)
KBO( :, 2,19, 4) = (/&
&4.2621E-03_JPRB,4.5739E-03_JPRB,2.6225E-02_JPRB,3.8473E-02_JPRB,4.7113E-02_JPRB,4.7821E-02_JPRB/)
KBO( :, 3,19, 4) = (/&
&4.4701E-03_JPRB,4.7726E-03_JPRB,2.6827E-02_JPRB,3.9028E-02_JPRB,4.7627E-02_JPRB,4.8310E-02_JPRB/)
KBO( :, 4,19, 4) = (/&
&4.6836E-03_JPRB,4.9742E-03_JPRB,2.7306E-02_JPRB,3.9355E-02_JPRB,4.7801E-02_JPRB,4.8408E-02_JPRB/)
KBO( :, 5,19, 4) = (/&
&4.9101E-03_JPRB,5.1908E-03_JPRB,2.7671E-02_JPRB,3.9547E-02_JPRB,4.7738E-02_JPRB,4.8196E-02_JPRB/)
KBO( :, 1,20, 4) = (/&
&3.4183E-03_JPRB,3.7281E-03_JPRB,2.1635E-02_JPRB,3.1767E-02_JPRB,3.8910E-02_JPRB,3.9035E-02_JPRB/)
KBO( :, 2,20, 4) = (/&
&3.5755E-03_JPRB,3.8847E-03_JPRB,2.2172E-02_JPRB,3.2321E-02_JPRB,3.9468E-02_JPRB,3.9630E-02_JPRB/)
KBO( :, 3,20, 4) = (/&
&3.7470E-03_JPRB,4.0489E-03_JPRB,2.2621E-02_JPRB,3.2676E-02_JPRB,3.9755E-02_JPRB,3.9891E-02_JPRB/)
KBO( :, 4,20, 4) = (/&
&3.9257E-03_JPRB,4.2203E-03_JPRB,2.2997E-02_JPRB,3.2924E-02_JPRB,3.9820E-02_JPRB,3.9868E-02_JPRB/)
KBO( :, 5,20, 4) = (/&
&4.1248E-03_JPRB,4.4107E-03_JPRB,2.3239E-02_JPRB,3.3086E-02_JPRB,3.9734E-02_JPRB,3.9622E-02_JPRB/)
KBO( :, 1,21, 4) = (/&
&2.8606E-03_JPRB,3.1596E-03_JPRB,1.8191E-02_JPRB,2.6601E-02_JPRB,3.2515E-02_JPRB,3.2317E-02_JPRB/)
KBO( :, 2,21, 4) = (/&
&2.9928E-03_JPRB,3.2930E-03_JPRB,1.8598E-02_JPRB,2.6970E-02_JPRB,3.2866E-02_JPRB,3.2699E-02_JPRB/)
KBO( :, 3,21, 4) = (/&
&3.1369E-03_JPRB,3.4309E-03_JPRB,1.8968E-02_JPRB,2.7247E-02_JPRB,3.3035E-02_JPRB,3.2834E-02_JPRB/)
KBO( :, 4,21, 4) = (/&
&3.2911E-03_JPRB,3.5807E-03_JPRB,1.9242E-02_JPRB,2.7455E-02_JPRB,3.3060E-02_JPRB,3.2754E-02_JPRB/)
KBO( :, 5,21, 4) = (/&
&3.4660E-03_JPRB,3.7486E-03_JPRB,1.9402E-02_JPRB,2.7577E-02_JPRB,3.2988E-02_JPRB,3.2505E-02_JPRB/)
KBO( :, 1,22, 4) = (/&
&2.3958E-03_JPRB,2.6786E-03_JPRB,1.5221E-02_JPRB,2.2163E-02_JPRB,2.7039E-02_JPRB,2.6675E-02_JPRB/)
KBO( :, 2,22, 4) = (/&
&2.5089E-03_JPRB,2.7922E-03_JPRB,1.5555E-02_JPRB,2.2444E-02_JPRB,2.7268E-02_JPRB,2.6915E-02_JPRB/)
KBO( :, 3,22, 4) = (/&
&2.6330E-03_JPRB,2.9125E-03_JPRB,1.5842E-02_JPRB,2.2675E-02_JPRB,2.7372E-02_JPRB,2.6968E-02_JPRB/)
KBO( :, 4,22, 4) = (/&
&2.7694E-03_JPRB,3.0464E-03_JPRB,1.6030E-02_JPRB,2.2843E-02_JPRB,2.7392E-02_JPRB,2.6856E-02_JPRB/)
KBO( :, 5,22, 4) = (/&
&2.9232E-03_JPRB,3.1956E-03_JPRB,1.6145E-02_JPRB,2.2906E-02_JPRB,2.7331E-02_JPRB,2.6610E-02_JPRB/)
KBO( :, 1,23, 4) = (/&
&2.0042E-03_JPRB,2.2640E-03_JPRB,1.2690E-02_JPRB,1.8401E-02_JPRB,2.2404E-02_JPRB,2.1959E-02_JPRB/)
KBO( :, 2,23, 4) = (/&
&2.1023E-03_JPRB,2.3617E-03_JPRB,1.2965E-02_JPRB,1.8637E-02_JPRB,2.2564E-02_JPRB,2.2109E-02_JPRB/)
KBO( :, 3,23, 4) = (/&
&2.2103E-03_JPRB,2.4685E-03_JPRB,1.3173E-02_JPRB,1.8833E-02_JPRB,2.2645E-02_JPRB,2.2108E-02_JPRB/)
KBO( :, 4,23, 4) = (/&
&2.3303E-03_JPRB,2.5871E-03_JPRB,1.3312E-02_JPRB,1.8940E-02_JPRB,2.2663E-02_JPRB,2.1985E-02_JPRB/)
KBO( :, 5,23, 4) = (/&
&2.4661E-03_JPRB,2.7218E-03_JPRB,1.3399E-02_JPRB,1.8972E-02_JPRB,2.2604E-02_JPRB,2.1760E-02_JPRB/)
KBO( :, 1,24, 4) = (/&
&1.6762E-03_JPRB,1.9090E-03_JPRB,1.0559E-02_JPRB,1.5252E-02_JPRB,1.8521E-02_JPRB,1.8042E-02_JPRB/)
KBO( :, 2,24, 4) = (/&
&1.7614E-03_JPRB,1.9932E-03_JPRB,1.0770E-02_JPRB,1.5455E-02_JPRB,1.8647E-02_JPRB,1.8128E-02_JPRB/)
KBO( :, 3,24, 4) = (/&
&1.8564E-03_JPRB,2.0890E-03_JPRB,1.0927E-02_JPRB,1.5598E-02_JPRB,1.8716E-02_JPRB,1.8097E-02_JPRB/)
KBO( :, 4,24, 4) = (/&
&1.9618E-03_JPRB,2.1951E-03_JPRB,1.1029E-02_JPRB,1.5669E-02_JPRB,1.8728E-02_JPRB,1.7971E-02_JPRB/)
KBO( :, 5,24, 4) = (/&
&2.0788E-03_JPRB,2.3139E-03_JPRB,1.1094E-02_JPRB,1.5685E-02_JPRB,1.8656E-02_JPRB,1.7765E-02_JPRB/)
KBO( :, 1,25, 4) = (/&
&1.4025E-03_JPRB,1.6067E-03_JPRB,8.7676E-03_JPRB,1.2632E-02_JPRB,1.5295E-02_JPRB,1.4808E-02_JPRB/)
KBO( :, 2,25, 4) = (/&
&1.4767E-03_JPRB,1.6810E-03_JPRB,8.9285E-03_JPRB,1.2792E-02_JPRB,1.5398E-02_JPRB,1.4849E-02_JPRB/)
KBO( :, 3,25, 4) = (/&
&1.5600E-03_JPRB,1.7664E-03_JPRB,9.0451E-03_JPRB,1.2893E-02_JPRB,1.5458E-02_JPRB,1.4803E-02_JPRB/)
KBO( :, 4,25, 4) = (/&
&1.6518E-03_JPRB,1.8613E-03_JPRB,9.1218E-03_JPRB,1.2945E-02_JPRB,1.5449E-02_JPRB,1.4682E-02_JPRB/)
KBO( :, 5,25, 4) = (/&
&1.7503E-03_JPRB,1.9622E-03_JPRB,9.1788E-03_JPRB,1.2954E-02_JPRB,1.5378E-02_JPRB,1.4496E-02_JPRB/)
KBO( :, 1,26, 4) = (/&
&1.1743E-03_JPRB,1.3515E-03_JPRB,7.2680E-03_JPRB,1.0453E-02_JPRB,1.2624E-02_JPRB,1.2143E-02_JPRB/)
KBO( :, 2,26, 4) = (/&
&1.2397E-03_JPRB,1.4187E-03_JPRB,7.3884E-03_JPRB,1.0572E-02_JPRB,1.2713E-02_JPRB,1.2158E-02_JPRB/)
KBO( :, 3,26, 4) = (/&
&1.3121E-03_JPRB,1.4944E-03_JPRB,7.4769E-03_JPRB,1.0647E-02_JPRB,1.2748E-02_JPRB,1.2101E-02_JPRB/)
KBO( :, 4,26, 4) = (/&
&1.3904E-03_JPRB,1.5774E-03_JPRB,7.5401E-03_JPRB,1.0684E-02_JPRB,1.2728E-02_JPRB,1.1986E-02_JPRB/)
KBO( :, 5,26, 4) = (/&
&1.4736E-03_JPRB,1.6625E-03_JPRB,7.5925E-03_JPRB,1.0683E-02_JPRB,1.2662E-02_JPRB,1.1823E-02_JPRB/)
KBO( :, 1,27, 4) = (/&
&9.8402E-04_JPRB,1.1373E-03_JPRB,6.0162E-03_JPRB,8.6394E-03_JPRB,1.0419E-02_JPRB,9.9561E-03_JPRB/)
KBO( :, 2,27, 4) = (/&
&1.0411E-03_JPRB,1.1972E-03_JPRB,6.1086E-03_JPRB,8.7287E-03_JPRB,1.0483E-02_JPRB,9.9519E-03_JPRB/)
KBO( :, 3,27, 4) = (/&
&1.1029E-03_JPRB,1.2633E-03_JPRB,6.1781E-03_JPRB,8.7827E-03_JPRB,1.0501E-02_JPRB,9.8918E-03_JPRB/)
KBO( :, 4,27, 4) = (/&
&1.1695E-03_JPRB,1.3344E-03_JPRB,6.2341E-03_JPRB,8.8083E-03_JPRB,1.0478E-02_JPRB,9.7857E-03_JPRB/)
KBO( :, 5,27, 4) = (/&
&1.2409E-03_JPRB,1.4079E-03_JPRB,6.2822E-03_JPRB,8.8079E-03_JPRB,1.0418E-02_JPRB,9.6453E-03_JPRB/)
KBO( :, 1,28, 4) = (/&
&8.2502E-04_JPRB,9.5751E-04_JPRB,4.9758E-03_JPRB,7.1338E-03_JPRB,8.5938E-03_JPRB,8.1599E-03_JPRB/)
KBO( :, 2,28, 4) = (/&
&8.7450E-04_JPRB,1.0105E-03_JPRB,5.0486E-03_JPRB,7.1996E-03_JPRB,8.6369E-03_JPRB,8.1441E-03_JPRB/)
KBO( :, 3,28, 4) = (/&
&9.2664E-04_JPRB,1.0674E-03_JPRB,5.1070E-03_JPRB,7.2390E-03_JPRB,8.6457E-03_JPRB,8.0849E-03_JPRB/)
KBO( :, 4,28, 4) = (/&
&9.8426E-04_JPRB,1.1287E-03_JPRB,5.1587E-03_JPRB,7.2593E-03_JPRB,8.6218E-03_JPRB,7.9907E-03_JPRB/)
KBO( :, 5,28, 4) = (/&
&1.0460E-03_JPRB,1.1932E-03_JPRB,5.2066E-03_JPRB,7.2612E-03_JPRB,8.5694E-03_JPRB,7.8705E-03_JPRB/)
KBO( :, 1,29, 4) = (/&
&6.9236E-04_JPRB,8.0674E-04_JPRB,4.1133E-03_JPRB,5.8863E-03_JPRB,7.0815E-03_JPRB,6.6900E-03_JPRB/)
KBO( :, 2,29, 4) = (/&
&7.3441E-04_JPRB,8.5270E-04_JPRB,4.1735E-03_JPRB,5.9349E-03_JPRB,7.1122E-03_JPRB,6.6683E-03_JPRB/)
KBO( :, 3,29, 4) = (/&
&7.7930E-04_JPRB,9.0247E-04_JPRB,4.2252E-03_JPRB,5.9662E-03_JPRB,7.1136E-03_JPRB,6.6140E-03_JPRB/)
KBO( :, 4,29, 4) = (/&
&8.2905E-04_JPRB,9.5490E-04_JPRB,4.2746E-03_JPRB,5.9835E-03_JPRB,7.0898E-03_JPRB,6.5328E-03_JPRB/)
KBO( :, 5,29, 4) = (/&
&8.8288E-04_JPRB,1.0121E-03_JPRB,4.3168E-03_JPRB,5.9898E-03_JPRB,7.0475E-03_JPRB,6.4307E-03_JPRB/)
KBO( :, 1,30, 4) = (/&
&5.8109E-04_JPRB,6.7992E-04_JPRB,3.4007E-03_JPRB,4.8546E-03_JPRB,5.8338E-03_JPRB,5.4857E-03_JPRB/)
KBO( :, 2,30, 4) = (/&
&6.1672E-04_JPRB,7.1953E-04_JPRB,3.4531E-03_JPRB,4.8921E-03_JPRB,5.8538E-03_JPRB,5.4623E-03_JPRB/)
KBO( :, 3,30, 4) = (/&
&6.5564E-04_JPRB,7.6235E-04_JPRB,3.5001E-03_JPRB,4.9200E-03_JPRB,5.8508E-03_JPRB,5.4136E-03_JPRB/)
KBO( :, 4,30, 4) = (/&
&6.9916E-04_JPRB,8.0837E-04_JPRB,3.5445E-03_JPRB,4.9361E-03_JPRB,5.8315E-03_JPRB,5.3448E-03_JPRB/)
KBO( :, 5,30, 4) = (/&
&7.4588E-04_JPRB,8.5907E-04_JPRB,3.5814E-03_JPRB,4.9470E-03_JPRB,5.7972E-03_JPRB,5.2575E-03_JPRB/)
KBO( :, 1,31, 4) = (/&
&4.8773E-04_JPRB,5.7298E-04_JPRB,2.8142E-03_JPRB,4.0034E-03_JPRB,4.8046E-03_JPRB,4.5018E-03_JPRB/)
KBO( :, 2,31, 4) = (/&
&5.1790E-04_JPRB,6.0687E-04_JPRB,2.8592E-03_JPRB,4.0352E-03_JPRB,4.8163E-03_JPRB,4.4785E-03_JPRB/)
KBO( :, 3,31, 4) = (/&
&5.5259E-04_JPRB,6.4420E-04_JPRB,2.9026E-03_JPRB,4.0596E-03_JPRB,4.8128E-03_JPRB,4.4370E-03_JPRB/)
KBO( :, 4,31, 4) = (/&
&5.9027E-04_JPRB,6.8473E-04_JPRB,2.9396E-03_JPRB,4.0779E-03_JPRB,4.7972E-03_JPRB,4.3789E-03_JPRB/)
KBO( :, 5,31, 4) = (/&
&6.3109E-04_JPRB,7.2996E-04_JPRB,2.9730E-03_JPRB,4.0892E-03_JPRB,4.7703E-03_JPRB,4.3063E-03_JPRB/)
KBO( :, 1,32, 4) = (/&
&4.0943E-04_JPRB,4.8260E-04_JPRB,2.3307E-03_JPRB,3.3026E-03_JPRB,3.9553E-03_JPRB,3.6951E-03_JPRB/)
KBO( :, 2,32, 4) = (/&
&4.3585E-04_JPRB,5.1194E-04_JPRB,2.3706E-03_JPRB,3.3307E-03_JPRB,3.9627E-03_JPRB,3.6751E-03_JPRB/)
KBO( :, 3,32, 4) = (/&
&4.6644E-04_JPRB,5.4471E-04_JPRB,2.4075E-03_JPRB,3.3544E-03_JPRB,3.9608E-03_JPRB,3.6388E-03_JPRB/)
KBO( :, 4,32, 4) = (/&
&4.9918E-04_JPRB,5.8045E-04_JPRB,2.4395E-03_JPRB,3.3725E-03_JPRB,3.9485E-03_JPRB,3.5900E-03_JPRB/)
KBO( :, 5,32, 4) = (/&
&5.3458E-04_JPRB,6.2069E-04_JPRB,2.4710E-03_JPRB,3.3839E-03_JPRB,3.9292E-03_JPRB,3.5299E-03_JPRB/)
KBO( :, 1,33, 4) = (/&
&3.4410E-04_JPRB,4.0654E-04_JPRB,1.9317E-03_JPRB,2.7269E-03_JPRB,3.2560E-03_JPRB,3.0357E-03_JPRB/)
KBO( :, 2,33, 4) = (/&
&3.6780E-04_JPRB,4.3231E-04_JPRB,1.9669E-03_JPRB,2.7524E-03_JPRB,3.2622E-03_JPRB,3.0171E-03_JPRB/)
KBO( :, 3,33, 4) = (/&
&3.9422E-04_JPRB,4.6103E-04_JPRB,1.9979E-03_JPRB,2.7749E-03_JPRB,3.2617E-03_JPRB,2.9869E-03_JPRB/)
KBO( :, 4,33, 4) = (/&
&4.2274E-04_JPRB,4.9289E-04_JPRB,2.0268E-03_JPRB,2.7910E-03_JPRB,3.2533E-03_JPRB,2.9461E-03_JPRB/)
KBO( :, 5,33, 4) = (/&
&4.5356E-04_JPRB,5.2826E-04_JPRB,2.0558E-03_JPRB,2.8026E-03_JPRB,3.2388E-03_JPRB,2.8971E-03_JPRB/)
KBO( :, 1,34, 4) = (/&
&2.8907E-04_JPRB,3.4197E-04_JPRB,1.6017E-03_JPRB,2.2527E-03_JPRB,2.6816E-03_JPRB,2.4934E-03_JPRB/)
KBO( :, 2,34, 4) = (/&
&3.0999E-04_JPRB,3.6459E-04_JPRB,1.6314E-03_JPRB,2.2770E-03_JPRB,2.6881E-03_JPRB,2.4774E-03_JPRB/)
KBO( :, 3,34, 4) = (/&
&3.3292E-04_JPRB,3.8989E-04_JPRB,1.6587E-03_JPRB,2.2965E-03_JPRB,2.6882E-03_JPRB,2.4516E-03_JPRB/)
KBO( :, 4,34, 4) = (/&
&3.5758E-04_JPRB,4.1817E-04_JPRB,1.6851E-03_JPRB,2.3118E-03_JPRB,2.6837E-03_JPRB,2.4183E-03_JPRB/)
KBO( :, 5,34, 4) = (/&
&3.8443E-04_JPRB,4.4891E-04_JPRB,1.7117E-03_JPRB,2.3241E-03_JPRB,2.6734E-03_JPRB,2.3789E-03_JPRB/)
KBO( :, 1,35, 4) = (/&
&2.4163E-04_JPRB,2.8613E-04_JPRB,1.3262E-03_JPRB,1.8610E-03_JPRB,2.2092E-03_JPRB,2.0492E-03_JPRB/)
KBO( :, 2,35, 4) = (/&
&2.5980E-04_JPRB,3.0590E-04_JPRB,1.3518E-03_JPRB,1.8829E-03_JPRB,2.2161E-03_JPRB,2.0364E-03_JPRB/)
KBO( :, 3,35, 4) = (/&
&2.7948E-04_JPRB,3.2806E-04_JPRB,1.3762E-03_JPRB,1.9000E-03_JPRB,2.2186E-03_JPRB,2.0149E-03_JPRB/)
KBO( :, 4,35, 4) = (/&
&3.0066E-04_JPRB,3.5268E-04_JPRB,1.4004E-03_JPRB,1.9149E-03_JPRB,2.2165E-03_JPRB,1.9889E-03_JPRB/)
KBO( :, 5,35, 4) = (/&
&3.2401E-04_JPRB,3.7942E-04_JPRB,1.4250E-03_JPRB,1.9278E-03_JPRB,2.2099E-03_JPRB,1.9578E-03_JPRB/)
KBO( :, 1,36, 4) = (/&
&2.0066E-04_JPRB,2.3797E-04_JPRB,1.0962E-03_JPRB,1.5363E-03_JPRB,1.8202E-03_JPRB,1.6851E-03_JPRB/)
KBO( :, 2,36, 4) = (/&
&2.1623E-04_JPRB,2.5498E-04_JPRB,1.1188E-03_JPRB,1.5557E-03_JPRB,1.8279E-03_JPRB,1.6749E-03_JPRB/)
KBO( :, 3,36, 4) = (/&
&2.3303E-04_JPRB,2.7423E-04_JPRB,1.1407E-03_JPRB,1.5718E-03_JPRB,1.8325E-03_JPRB,1.6591E-03_JPRB/)
KBO( :, 4,36, 4) = (/&
&2.5102E-04_JPRB,2.9534E-04_JPRB,1.1626E-03_JPRB,1.5863E-03_JPRB,1.8324E-03_JPRB,1.6382E-03_JPRB/)
KBO( :, 5,36, 4) = (/&
&2.7107E-04_JPRB,3.1839E-04_JPRB,1.1850E-03_JPRB,1.5990E-03_JPRB,1.8295E-03_JPRB,1.6138E-03_JPRB/)
KBO( :, 1,37, 4) = (/&
&1.6489E-04_JPRB,1.9598E-04_JPRB,9.0338E-04_JPRB,1.2660E-03_JPRB,1.4992E-03_JPRB,1.3858E-03_JPRB/)
KBO( :, 2,37, 4) = (/&
&1.7800E-04_JPRB,2.1035E-04_JPRB,9.2319E-04_JPRB,1.2835E-03_JPRB,1.5078E-03_JPRB,1.3789E-03_JPRB/)
KBO( :, 3,37, 4) = (/&
&1.9213E-04_JPRB,2.2670E-04_JPRB,9.4286E-04_JPRB,1.2987E-03_JPRB,1.5138E-03_JPRB,1.3673E-03_JPRB/)
KBO( :, 4,37, 4) = (/&
&2.0731E-04_JPRB,2.4467E-04_JPRB,9.6260E-04_JPRB,1.3129E-03_JPRB,1.5159E-03_JPRB,1.3520E-03_JPRB/)
KBO( :, 5,37, 4) = (/&
&2.2426E-04_JPRB,2.6433E-04_JPRB,9.8317E-04_JPRB,1.3255E-03_JPRB,1.5160E-03_JPRB,1.3330E-03_JPRB/)
KBO( :, 1,38, 4) = (/&
&1.3545E-04_JPRB,1.6133E-04_JPRB,7.4423E-04_JPRB,1.0430E-03_JPRB,1.2345E-03_JPRB,1.1400E-03_JPRB/)
KBO( :, 2,38, 4) = (/&
&1.4647E-04_JPRB,1.7346E-04_JPRB,7.6176E-04_JPRB,1.0590E-03_JPRB,1.2440E-03_JPRB,1.1357E-03_JPRB/)
KBO( :, 3,38, 4) = (/&
&1.5834E-04_JPRB,1.8731E-04_JPRB,7.7933E-04_JPRB,1.0731E-03_JPRB,1.2505E-03_JPRB,1.1275E-03_JPRB/)
KBO( :, 4,38, 4) = (/&
&1.7112E-04_JPRB,2.0254E-04_JPRB,7.9709E-04_JPRB,1.0866E-03_JPRB,1.2542E-03_JPRB,1.1163E-03_JPRB/)
KBO( :, 5,38, 4) = (/&
&1.8543E-04_JPRB,2.1932E-04_JPRB,8.1567E-04_JPRB,1.0989E-03_JPRB,1.2562E-03_JPRB,1.1014E-03_JPRB/)
KBO( :, 1,39, 4) = (/&
&1.1128E-04_JPRB,1.3279E-04_JPRB,6.1308E-04_JPRB,8.5960E-04_JPRB,1.0171E-03_JPRB,9.3831E-04_JPRB/)
KBO( :, 2,39, 4) = (/&
&1.2054E-04_JPRB,1.4305E-04_JPRB,6.2838E-04_JPRB,8.7394E-04_JPRB,1.0264E-03_JPRB,9.3635E-04_JPRB/)
KBO( :, 3,39, 4) = (/&
&1.3051E-04_JPRB,1.5480E-04_JPRB,6.4408E-04_JPRB,8.8688E-04_JPRB,1.0332E-03_JPRB,9.3078E-04_JPRB/)
KBO( :, 4,39, 4) = (/&
&1.4126E-04_JPRB,1.6774E-04_JPRB,6.5994E-04_JPRB,8.9946E-04_JPRB,1.0378E-03_JPRB,9.2268E-04_JPRB/)
KBO( :, 5,39, 4) = (/&
&1.5338E-04_JPRB,1.8209E-04_JPRB,6.7678E-04_JPRB,9.1123E-04_JPRB,1.0413E-03_JPRB,9.1137E-04_JPRB/)
KBO( :, 1,40, 4) = (/&
&9.0705E-05_JPRB,1.0852E-04_JPRB,5.0355E-04_JPRB,7.0681E-04_JPRB,8.3684E-04_JPRB,7.7091E-04_JPRB/)
KBO( :, 2,40, 4) = (/&
&9.8348E-05_JPRB,1.1706E-04_JPRB,5.1697E-04_JPRB,7.2009E-04_JPRB,8.4601E-04_JPRB,7.7004E-04_JPRB/)
KBO( :, 3,40, 4) = (/&
&1.0671E-04_JPRB,1.2689E-04_JPRB,5.3086E-04_JPRB,7.3191E-04_JPRB,8.5298E-04_JPRB,7.6666E-04_JPRB/)
KBO( :, 4,40, 4) = (/&
&1.1570E-04_JPRB,1.3781E-04_JPRB,5.4507E-04_JPRB,7.4355E-04_JPRB,8.5831E-04_JPRB,7.6093E-04_JPRB/)
KBO( :, 5,40, 4) = (/&
&1.2578E-04_JPRB,1.4990E-04_JPRB,5.6002E-04_JPRB,7.5473E-04_JPRB,8.6284E-04_JPRB,7.5245E-04_JPRB/)
KBO( :, 1,41, 4) = (/&
&7.3817E-05_JPRB,8.8549E-05_JPRB,4.1325E-04_JPRB,5.8106E-04_JPRB,6.8830E-04_JPRB,6.3269E-04_JPRB/)
KBO( :, 2,41, 4) = (/&
&8.0158E-05_JPRB,9.5680E-05_JPRB,4.2501E-04_JPRB,5.9293E-04_JPRB,6.9700E-04_JPRB,6.3310E-04_JPRB/)
KBO( :, 3,41, 4) = (/&
&8.7116E-05_JPRB,1.0384E-04_JPRB,4.3722E-04_JPRB,6.0369E-04_JPRB,7.0401E-04_JPRB,6.3122E-04_JPRB/)
KBO( :, 4,41, 4) = (/&
&9.4610E-05_JPRB,1.1303E-04_JPRB,4.4976E-04_JPRB,6.1448E-04_JPRB,7.0977E-04_JPRB,6.2726E-04_JPRB/)
KBO( :, 5,41, 4) = (/&
&1.0305E-04_JPRB,1.2324E-04_JPRB,4.6311E-04_JPRB,6.2475E-04_JPRB,7.1477E-04_JPRB,6.2101E-04_JPRB/)
KBO( :, 1,42, 4) = (/&
&6.0047E-05_JPRB,7.2210E-05_JPRB,3.3900E-04_JPRB,4.7749E-04_JPRB,5.6596E-04_JPRB,5.1926E-04_JPRB/)
KBO( :, 2,42, 4) = (/&
&6.5307E-05_JPRB,7.8183E-05_JPRB,3.4927E-04_JPRB,4.8800E-04_JPRB,5.7404E-04_JPRB,5.2049E-04_JPRB/)
KBO( :, 3,42, 4) = (/&
&7.1083E-05_JPRB,8.4948E-05_JPRB,3.5991E-04_JPRB,4.9776E-04_JPRB,5.8092E-04_JPRB,5.1968E-04_JPRB/)
KBO( :, 4,42, 4) = (/&
&7.7339E-05_JPRB,9.2668E-05_JPRB,3.7098E-04_JPRB,5.0759E-04_JPRB,5.8676E-04_JPRB,5.1717E-04_JPRB/)
KBO( :, 5,42, 4) = (/&
&8.4391E-05_JPRB,1.0128E-04_JPRB,3.8284E-04_JPRB,5.1710E-04_JPRB,5.9200E-04_JPRB,5.1265E-04_JPRB/)
KBO( :, 1,43, 4) = (/&
&4.8611E-05_JPRB,5.8601E-05_JPRB,2.7749E-04_JPRB,3.9145E-04_JPRB,4.6464E-04_JPRB,4.2584E-04_JPRB/)
KBO( :, 2,43, 4) = (/&
&5.2925E-05_JPRB,6.3562E-05_JPRB,2.8637E-04_JPRB,4.0094E-04_JPRB,4.7226E-04_JPRB,4.2773E-04_JPRB/)
KBO( :, 3,43, 4) = (/&
&5.7704E-05_JPRB,6.9143E-05_JPRB,2.9565E-04_JPRB,4.0976E-04_JPRB,4.7882E-04_JPRB,4.2784E-04_JPRB/)
KBO( :, 4,43, 4) = (/&
&6.2890E-05_JPRB,7.5555E-05_JPRB,3.0531E-04_JPRB,4.1861E-04_JPRB,4.8454E-04_JPRB,4.2632E-04_JPRB/)
KBO( :, 5,43, 4) = (/&
&6.8733E-05_JPRB,8.2754E-05_JPRB,3.1574E-04_JPRB,4.2729E-04_JPRB,4.8985E-04_JPRB,4.2324E-04_JPRB/)
KBO( :, 1,44, 4) = (/&
&3.9255E-05_JPRB,4.7428E-05_JPRB,2.2682E-04_JPRB,3.2053E-04_JPRB,3.8115E-04_JPRB,3.4904E-04_JPRB/)
KBO( :, 2,44, 4) = (/&
&4.2756E-05_JPRB,5.1518E-05_JPRB,2.3446E-04_JPRB,3.2900E-04_JPRB,3.8818E-04_JPRB,3.5126E-04_JPRB/)
KBO( :, 3,44, 4) = (/&
&4.6702E-05_JPRB,5.6118E-05_JPRB,2.4254E-04_JPRB,3.3696E-04_JPRB,3.9445E-04_JPRB,3.5204E-04_JPRB/)
KBO( :, 4,44, 4) = (/&
&5.0988E-05_JPRB,6.1414E-05_JPRB,2.5093E-04_JPRB,3.4483E-04_JPRB,3.9984E-04_JPRB,3.5150E-04_JPRB/)
KBO( :, 5,44, 4) = (/&
&5.5818E-05_JPRB,6.7413E-05_JPRB,2.6004E-04_JPRB,3.5271E-04_JPRB,4.0508E-04_JPRB,3.4955E-04_JPRB/)
KBO( :, 1,45, 4) = (/&
&3.1677E-05_JPRB,3.8360E-05_JPRB,1.8523E-04_JPRB,2.6222E-04_JPRB,3.1238E-04_JPRB,2.8592E-04_JPRB/)
KBO( :, 2,45, 4) = (/&
&3.4522E-05_JPRB,4.1731E-05_JPRB,1.9192E-04_JPRB,2.6971E-04_JPRB,3.1883E-04_JPRB,2.8860E-04_JPRB/)
KBO( :, 3,45, 4) = (/&
&3.7775E-05_JPRB,4.5523E-05_JPRB,1.9882E-04_JPRB,2.7680E-04_JPRB,3.2469E-04_JPRB,2.8979E-04_JPRB/)
KBO( :, 4,45, 4) = (/&
&4.1306E-05_JPRB,4.9872E-05_JPRB,2.0608E-04_JPRB,2.8384E-04_JPRB,3.2984E-04_JPRB,2.8984E-04_JPRB/)
KBO( :, 5,45, 4) = (/&
&4.5292E-05_JPRB,5.4864E-05_JPRB,2.1395E-04_JPRB,2.9088E-04_JPRB,3.3473E-04_JPRB,2.8876E-04_JPRB/)
KBO( :, 1,46, 4) = (/&
&2.5501E-05_JPRB,3.0949E-05_JPRB,1.5106E-04_JPRB,2.1422E-04_JPRB,2.5570E-04_JPRB,2.3396E-04_JPRB/)
KBO( :, 2,46, 4) = (/&
&2.7795E-05_JPRB,3.3698E-05_JPRB,1.5681E-04_JPRB,2.2083E-04_JPRB,2.6153E-04_JPRB,2.3683E-04_JPRB/)
KBO( :, 3,46, 4) = (/&
&3.0473E-05_JPRB,3.6830E-05_JPRB,1.6271E-04_JPRB,2.2704E-04_JPRB,2.6695E-04_JPRB,2.3842E-04_JPRB/)
KBO( :, 4,46, 4) = (/&
&3.3376E-05_JPRB,4.0385E-05_JPRB,1.6899E-04_JPRB,2.3332E-04_JPRB,2.7178E-04_JPRB,2.3894E-04_JPRB/)
KBO( :, 5,46, 4) = (/&
&3.6637E-05_JPRB,4.4507E-05_JPRB,1.7585E-04_JPRB,2.3962E-04_JPRB,2.7638E-04_JPRB,2.3855E-04_JPRB/)
KBO( :, 1,47, 4) = (/&
&2.0450E-05_JPRB,2.4871E-05_JPRB,1.2285E-04_JPRB,1.7458E-04_JPRB,2.0883E-04_JPRB,1.9097E-04_JPRB/)
KBO( :, 2,47, 4) = (/&
&2.2286E-05_JPRB,2.7086E-05_JPRB,1.2784E-04_JPRB,1.8042E-04_JPRB,2.1404E-04_JPRB,1.9395E-04_JPRB/)
KBO( :, 3,47, 4) = (/&
&2.4454E-05_JPRB,2.9649E-05_JPRB,1.3286E-04_JPRB,1.8591E-04_JPRB,2.1910E-04_JPRB,1.9581E-04_JPRB/)
KBO( :, 4,47, 4) = (/&
&2.6844E-05_JPRB,3.2545E-05_JPRB,1.3825E-04_JPRB,1.9143E-04_JPRB,2.2358E-04_JPRB,1.9673E-04_JPRB/)
KBO( :, 5,47, 4) = (/&
&2.9484E-05_JPRB,3.5918E-05_JPRB,1.4411E-04_JPRB,1.9700E-04_JPRB,2.2781E-04_JPRB,1.9684E-04_JPRB/)
KBO( :, 1,48, 4) = (/&
&1.6395E-05_JPRB,1.9987E-05_JPRB,9.9787E-05_JPRB,1.4214E-04_JPRB,1.7032E-04_JPRB,1.5582E-04_JPRB/)
KBO( :, 2,48, 4) = (/&
&1.7860E-05_JPRB,2.1753E-05_JPRB,1.0413E-04_JPRB,1.4725E-04_JPRB,1.7499E-04_JPRB,1.5884E-04_JPRB/)
KBO( :, 3,48, 4) = (/&
&1.9600E-05_JPRB,2.3834E-05_JPRB,1.0839E-04_JPRB,1.5207E-04_JPRB,1.7957E-04_JPRB,1.6083E-04_JPRB/)
KBO( :, 4,48, 4) = (/&
&2.1567E-05_JPRB,2.6208E-05_JPRB,1.1299E-04_JPRB,1.5690E-04_JPRB,1.8370E-04_JPRB,1.6199E-04_JPRB/)
KBO( :, 5,48, 4) = (/&
&2.3704E-05_JPRB,2.8946E-05_JPRB,1.1797E-04_JPRB,1.6178E-04_JPRB,1.8753E-04_JPRB,1.6246E-04_JPRB/)
KBO( :, 1,49, 4) = (/&
&1.3139E-05_JPRB,1.6062E-05_JPRB,8.0976E-05_JPRB,1.1562E-04_JPRB,1.3876E-04_JPRB,1.2714E-04_JPRB/)
KBO( :, 2,49, 4) = (/&
&1.4304E-05_JPRB,1.7455E-05_JPRB,8.4710E-05_JPRB,1.2004E-04_JPRB,1.4288E-04_JPRB,1.3003E-04_JPRB/)
KBO( :, 3,49, 4) = (/&
&1.5690E-05_JPRB,1.9136E-05_JPRB,8.8348E-05_JPRB,1.2427E-04_JPRB,1.4700E-04_JPRB,1.3213E-04_JPRB/)
KBO( :, 4,49, 4) = (/&
&1.7304E-05_JPRB,2.1080E-05_JPRB,9.2222E-05_JPRB,1.2844E-04_JPRB,1.5072E-04_JPRB,1.3349E-04_JPRB/)
KBO( :, 5,49, 4) = (/&
&1.9045E-05_JPRB,2.3296E-05_JPRB,9.6473E-05_JPRB,1.3272E-04_JPRB,1.5420E-04_JPRB,1.3424E-04_JPRB/)
KBO( :, 1,50, 4) = (/&
&1.0555E-05_JPRB,1.2937E-05_JPRB,6.5695E-05_JPRB,9.4043E-05_JPRB,1.1302E-04_JPRB,1.0345E-04_JPRB/)
KBO( :, 2,50, 4) = (/&
&1.1477E-05_JPRB,1.4031E-05_JPRB,6.8893E-05_JPRB,9.7810E-05_JPRB,1.1659E-04_JPRB,1.0618E-04_JPRB/)
KBO( :, 3,50, 4) = (/&
&1.2581E-05_JPRB,1.5385E-05_JPRB,7.2022E-05_JPRB,1.0152E-04_JPRB,1.2023E-04_JPRB,1.0825E-04_JPRB/)
KBO( :, 4,50, 4) = (/&
&1.3900E-05_JPRB,1.6979E-05_JPRB,7.5298E-05_JPRB,1.0513E-04_JPRB,1.2362E-04_JPRB,1.0965E-04_JPRB/)
KBO( :, 5,50, 4) = (/&
&1.5333E-05_JPRB,1.8783E-05_JPRB,7.8918E-05_JPRB,1.0888E-04_JPRB,1.2677E-04_JPRB,1.1057E-04_JPRB/)
KBO( :, 1,51, 4) = (/&
&8.4921E-06_JPRB,1.0428E-05_JPRB,5.3292E-05_JPRB,7.6448E-05_JPRB,9.1988E-05_JPRB,8.4025E-05_JPRB/)
KBO( :, 2,51, 4) = (/&
&9.2127E-06_JPRB,1.1285E-05_JPRB,5.6005E-05_JPRB,7.9650E-05_JPRB,9.5066E-05_JPRB,8.6539E-05_JPRB/)
KBO( :, 3,51, 4) = (/&
&1.0093E-05_JPRB,1.2374E-05_JPRB,5.8695E-05_JPRB,8.2891E-05_JPRB,9.8274E-05_JPRB,8.8509E-05_JPRB/)
KBO( :, 4,51, 4) = (/&
&1.1165E-05_JPRB,1.3675E-05_JPRB,6.1461E-05_JPRB,8.6028E-05_JPRB,1.0132E-04_JPRB,8.9926E-05_JPRB/)
KBO( :, 5,51, 4) = (/&
&1.2344E-05_JPRB,1.5149E-05_JPRB,6.4533E-05_JPRB,8.9294E-05_JPRB,1.0416E-04_JPRB,9.0887E-05_JPRB/)
KBO( :, 1,52, 4) = (/&
&6.8430E-06_JPRB,8.4090E-06_JPRB,4.3193E-05_JPRB,6.2073E-05_JPRB,7.4815E-05_JPRB,6.8216E-05_JPRB/)
KBO( :, 2,52, 4) = (/&
&7.3942E-06_JPRB,9.0790E-06_JPRB,4.5492E-05_JPRB,6.4818E-05_JPRB,7.7473E-05_JPRB,7.0540E-05_JPRB/)
KBO( :, 3,52, 4) = (/&
&8.0962E-06_JPRB,9.9455E-06_JPRB,4.7801E-05_JPRB,6.7638E-05_JPRB,8.0241E-05_JPRB,7.2366E-05_JPRB/)
KBO( :, 4,52, 4) = (/&
&8.9532E-06_JPRB,1.0996E-05_JPRB,5.0136E-05_JPRB,7.0352E-05_JPRB,8.2988E-05_JPRB,7.3738E-05_JPRB/)
KBO( :, 5,52, 4) = (/&
&9.9254E-06_JPRB,1.2206E-05_JPRB,5.2722E-05_JPRB,7.3154E-05_JPRB,8.5502E-05_JPRB,7.4723E-05_JPRB/)
KBO( :, 1,53, 4) = (/&
&5.5275E-06_JPRB,6.7826E-06_JPRB,3.4992E-05_JPRB,5.0387E-05_JPRB,6.0795E-05_JPRB,5.5379E-05_JPRB/)
KBO( :, 2,53, 4) = (/&
&5.9360E-06_JPRB,7.3070E-06_JPRB,3.6904E-05_JPRB,5.2681E-05_JPRB,6.3070E-05_JPRB,5.7475E-05_JPRB/)
KBO( :, 3,53, 4) = (/&
&6.4916E-06_JPRB,7.9876E-06_JPRB,3.8885E-05_JPRB,5.5123E-05_JPRB,6.5445E-05_JPRB,5.9194E-05_JPRB/)
KBO( :, 4,53, 4) = (/&
&7.1721E-06_JPRB,8.8314E-06_JPRB,4.0856E-05_JPRB,5.7465E-05_JPRB,6.7875E-05_JPRB,6.0530E-05_JPRB/)
KBO( :, 5,53, 4) = (/&
&7.9695E-06_JPRB,9.8225E-06_JPRB,4.3031E-05_JPRB,5.9870E-05_JPRB,7.0118E-05_JPRB,6.1520E-05_JPRB/)
KBO( :, 1,54, 4) = (/&
&4.4841E-06_JPRB,5.4855E-06_JPRB,2.8370E-05_JPRB,4.0916E-05_JPRB,4.9401E-05_JPRB,4.4764E-05_JPRB/)
KBO( :, 2,54, 4) = (/&
&4.7805E-06_JPRB,5.8965E-06_JPRB,2.9962E-05_JPRB,4.2832E-05_JPRB,5.1350E-05_JPRB,4.6575E-05_JPRB/)
KBO( :, 3,54, 4) = (/&
&5.2175E-06_JPRB,6.4303E-06_JPRB,3.1646E-05_JPRB,4.4921E-05_JPRB,5.3377E-05_JPRB,4.8101E-05_JPRB/)
KBO( :, 4,54, 4) = (/&
&5.7596E-06_JPRB,7.1078E-06_JPRB,3.3313E-05_JPRB,4.6951E-05_JPRB,5.5518E-05_JPRB,4.9299E-05_JPRB/)
KBO( :, 5,54, 4) = (/&
&6.4121E-06_JPRB,7.9214E-06_JPRB,3.5145E-05_JPRB,4.9005E-05_JPRB,5.7497E-05_JPRB,5.0216E-05_JPRB/)
KBO( :, 1,55, 4) = (/&
&3.6502E-06_JPRB,4.4452E-06_JPRB,2.3004E-05_JPRB,3.3225E-05_JPRB,4.0131E-05_JPRB,3.6076E-05_JPRB/)
KBO( :, 2,55, 4) = (/&
&3.8584E-06_JPRB,4.7638E-06_JPRB,2.4322E-05_JPRB,3.4820E-05_JPRB,4.1798E-05_JPRB,3.7608E-05_JPRB/)
KBO( :, 3,55, 4) = (/&
&4.1970E-06_JPRB,5.1824E-06_JPRB,2.5746E-05_JPRB,3.6594E-05_JPRB,4.3525E-05_JPRB,3.8921E-05_JPRB/)
KBO( :, 4,55, 4) = (/&
&4.6296E-06_JPRB,5.7238E-06_JPRB,2.7170E-05_JPRB,3.8354E-05_JPRB,4.5386E-05_JPRB,3.9954E-05_JPRB/)
KBO( :, 5,55, 4) = (/&
&5.1596E-06_JPRB,6.3897E-06_JPRB,2.8703E-05_JPRB,4.0103E-05_JPRB,4.7130E-05_JPRB,4.0748E-05_JPRB/)
KBO( :, 1,56, 4) = (/&
&2.9798E-06_JPRB,3.6097E-06_JPRB,1.8645E-05_JPRB,2.6958E-05_JPRB,3.2565E-05_JPRB,2.9049E-05_JPRB/)
KBO( :, 2,56, 4) = (/&
&3.1203E-06_JPRB,3.8503E-06_JPRB,1.9728E-05_JPRB,2.8285E-05_JPRB,3.3997E-05_JPRB,3.0362E-05_JPRB/)
KBO( :, 3,56, 4) = (/&
&3.3770E-06_JPRB,4.1764E-06_JPRB,2.0929E-05_JPRB,2.9782E-05_JPRB,3.5468E-05_JPRB,3.1480E-05_JPRB/)
KBO( :, 4,56, 4) = (/&
&3.7197E-06_JPRB,4.6073E-06_JPRB,2.2137E-05_JPRB,3.1299E-05_JPRB,3.7064E-05_JPRB,3.2373E-05_JPRB/)
KBO( :, 5,56, 4) = (/&
&4.1476E-06_JPRB,5.1481E-06_JPRB,2.3420E-05_JPRB,3.2792E-05_JPRB,3.8590E-05_JPRB,3.3070E-05_JPRB/)
KBO( :, 1,57, 4) = (/&
&2.4380E-06_JPRB,2.9371E-06_JPRB,1.5101E-05_JPRB,2.1849E-05_JPRB,2.6384E-05_JPRB,2.3378E-05_JPRB/)
KBO( :, 2,57, 4) = (/&
&2.5283E-06_JPRB,3.1131E-06_JPRB,1.5990E-05_JPRB,2.2961E-05_JPRB,2.7628E-05_JPRB,2.4501E-05_JPRB/)
KBO( :, 3,57, 4) = (/&
&2.7173E-06_JPRB,3.3659E-06_JPRB,1.6995E-05_JPRB,2.4208E-05_JPRB,2.8876E-05_JPRB,2.5443E-05_JPRB/)
KBO( :, 4,57, 4) = (/&
&2.9882E-06_JPRB,3.7073E-06_JPRB,1.8018E-05_JPRB,2.5516E-05_JPRB,3.0235E-05_JPRB,2.6220E-05_JPRB/)
KBO( :, 5,57, 4) = (/&
&3.3309E-06_JPRB,4.1429E-06_JPRB,1.9094E-05_JPRB,2.6794E-05_JPRB,3.1575E-05_JPRB,2.6825E-05_JPRB/)
KBO( :, 1,58, 4) = (/&
&1.9991E-06_JPRB,2.3969E-06_JPRB,1.2235E-05_JPRB,1.7713E-05_JPRB,2.1380E-05_JPRB,1.8819E-05_JPRB/)
KBO( :, 2,58, 4) = (/&
&2.0552E-06_JPRB,2.5217E-06_JPRB,1.2969E-05_JPRB,1.8641E-05_JPRB,2.2450E-05_JPRB,1.9754E-05_JPRB/)
KBO( :, 3,58, 4) = (/&
&2.1912E-06_JPRB,2.7184E-06_JPRB,1.3803E-05_JPRB,1.9678E-05_JPRB,2.3501E-05_JPRB,2.0555E-05_JPRB/)
KBO( :, 4,58, 4) = (/&
&2.4045E-06_JPRB,2.9869E-06_JPRB,1.4668E-05_JPRB,2.0799E-05_JPRB,2.4657E-05_JPRB,2.1216E-05_JPRB/)
KBO( :, 5,58, 4) = (/&
&2.6779E-06_JPRB,3.3369E-06_JPRB,1.5570E-05_JPRB,2.1893E-05_JPRB,2.5824E-05_JPRB,2.1730E-05_JPRB/)
KBO( :, 1,59, 4) = (/&
&1.6438E-06_JPRB,1.9701E-06_JPRB,1.0010E-05_JPRB,1.4487E-05_JPRB,1.7470E-05_JPRB,1.5234E-05_JPRB/)
KBO( :, 2,59, 4) = (/&
&1.6869E-06_JPRB,2.0683E-06_JPRB,1.0627E-05_JPRB,1.5272E-05_JPRB,1.8381E-05_JPRB,1.5979E-05_JPRB/)
KBO( :, 3,59, 4) = (/&
&1.7947E-06_JPRB,2.2294E-06_JPRB,1.1332E-05_JPRB,1.6155E-05_JPRB,1.9286E-05_JPRB,1.6622E-05_JPRB/)
KBO( :, 4,59, 4) = (/&
&1.9699E-06_JPRB,2.4516E-06_JPRB,1.2063E-05_JPRB,1.7108E-05_JPRB,2.0268E-05_JPRB,1.7134E-05_JPRB/)
KBO( :, 5,59, 4) = (/&
&2.1967E-06_JPRB,2.7433E-06_JPRB,1.2831E-05_JPRB,1.8043E-05_JPRB,2.1274E-05_JPRB,1.7524E-05_JPRB/)
KBO( :, 1,13, 5) = (/&
&2.1807E-02_JPRB,2.2021E-02_JPRB,1.0044E-01_JPRB,1.4940E-01_JPRB,1.9004E-01_JPRB,2.1084E-01_JPRB/)
KBO( :, 2,13, 5) = (/&
&2.2325E-02_JPRB,2.2543E-02_JPRB,1.0227E-01_JPRB,1.5170E-01_JPRB,1.9324E-01_JPRB,2.1682E-01_JPRB/)
KBO( :, 3,13, 5) = (/&
&2.2866E-02_JPRB,2.3082E-02_JPRB,1.0400E-01_JPRB,1.5406E-01_JPRB,1.9625E-01_JPRB,2.2209E-01_JPRB/)
KBO( :, 4,13, 5) = (/&
&2.3407E-02_JPRB,2.3630E-02_JPRB,1.0542E-01_JPRB,1.5634E-01_JPRB,1.9882E-01_JPRB,2.2691E-01_JPRB/)
KBO( :, 5,13, 5) = (/&
&2.3969E-02_JPRB,2.4198E-02_JPRB,1.0673E-01_JPRB,1.5832E-01_JPRB,2.0084E-01_JPRB,2.3123E-01_JPRB/)
KBO( :, 1,14, 5) = (/&
&1.8584E-02_JPRB,1.8801E-02_JPRB,9.0492E-02_JPRB,1.3383E-01_JPRB,1.6989E-01_JPRB,1.8690E-01_JPRB/)
KBO( :, 2,14, 5) = (/&
&1.9043E-02_JPRB,1.9260E-02_JPRB,9.2363E-02_JPRB,1.3650E-01_JPRB,1.7338E-01_JPRB,1.9215E-01_JPRB/)
KBO( :, 3,14, 5) = (/&
&1.9509E-02_JPRB,1.9727E-02_JPRB,9.4036E-02_JPRB,1.3911E-01_JPRB,1.7652E-01_JPRB,1.9653E-01_JPRB/)
KBO( :, 4,14, 5) = (/&
&2.0012E-02_JPRB,2.0240E-02_JPRB,9.5547E-02_JPRB,1.4152E-01_JPRB,1.7904E-01_JPRB,2.0046E-01_JPRB/)
KBO( :, 5,14, 5) = (/&
&2.0601E-02_JPRB,2.0831E-02_JPRB,9.6825E-02_JPRB,1.4354E-01_JPRB,1.8105E-01_JPRB,2.0381E-01_JPRB/)
KBO( :, 1,15, 5) = (/&
&1.5764E-02_JPRB,1.5986E-02_JPRB,8.0805E-02_JPRB,1.1930E-01_JPRB,1.5084E-01_JPRB,1.6442E-01_JPRB/)
KBO( :, 2,15, 5) = (/&
&1.6176E-02_JPRB,1.6398E-02_JPRB,8.2630E-02_JPRB,1.2205E-01_JPRB,1.5430E-01_JPRB,1.6881E-01_JPRB/)
KBO( :, 3,15, 5) = (/&
&1.6614E-02_JPRB,1.6841E-02_JPRB,8.4265E-02_JPRB,1.2470E-01_JPRB,1.5722E-01_JPRB,1.7258E-01_JPRB/)
KBO( :, 4,15, 5) = (/&
&1.7119E-02_JPRB,1.7353E-02_JPRB,8.5716E-02_JPRB,1.2695E-01_JPRB,1.5969E-01_JPRB,1.7588E-01_JPRB/)
KBO( :, 5,15, 5) = (/&
&1.7713E-02_JPRB,1.7947E-02_JPRB,8.6884E-02_JPRB,1.2867E-01_JPRB,1.6168E-01_JPRB,1.7864E-01_JPRB/)
KBO( :, 1,16, 5) = (/&
&1.3330E-02_JPRB,1.3559E-02_JPRB,7.1525E-02_JPRB,1.0570E-01_JPRB,1.3292E-01_JPRB,1.4360E-01_JPRB/)
KBO( :, 2,16, 5) = (/&
&1.3693E-02_JPRB,1.3924E-02_JPRB,7.3291E-02_JPRB,1.0840E-01_JPRB,1.3614E-01_JPRB,1.4745E-01_JPRB/)
KBO( :, 3,16, 5) = (/&
&1.4116E-02_JPRB,1.4356E-02_JPRB,7.4804E-02_JPRB,1.1084E-01_JPRB,1.3892E-01_JPRB,1.5078E-01_JPRB/)
KBO( :, 4,16, 5) = (/&
&1.4627E-02_JPRB,1.4869E-02_JPRB,7.6067E-02_JPRB,1.1275E-01_JPRB,1.4132E-01_JPRB,1.5373E-01_JPRB/)
KBO( :, 5,16, 5) = (/&
&1.5182E-02_JPRB,1.5422E-02_JPRB,7.7137E-02_JPRB,1.1432E-01_JPRB,1.4325E-01_JPRB,1.5618E-01_JPRB/)
KBO( :, 1,17, 5) = (/&
&1.1226E-02_JPRB,1.1471E-02_JPRB,6.2864E-02_JPRB,9.2970E-02_JPRB,1.1624E-01_JPRB,1.2435E-01_JPRB/)
KBO( :, 2,17, 5) = (/&
&1.1567E-02_JPRB,1.1813E-02_JPRB,6.4427E-02_JPRB,9.5505E-02_JPRB,1.1921E-01_JPRB,1.2773E-01_JPRB/)
KBO( :, 3,17, 5) = (/&
&1.1990E-02_JPRB,1.2239E-02_JPRB,6.5773E-02_JPRB,9.7566E-02_JPRB,1.2183E-01_JPRB,1.3076E-01_JPRB/)
KBO( :, 4,17, 5) = (/&
&1.2459E-02_JPRB,1.2709E-02_JPRB,6.6900E-02_JPRB,9.9291E-02_JPRB,1.2409E-01_JPRB,1.3335E-01_JPRB/)
KBO( :, 5,17, 5) = (/&
&1.2942E-02_JPRB,1.3188E-02_JPRB,6.7902E-02_JPRB,1.0077E-01_JPRB,1.2586E-01_JPRB,1.3513E-01_JPRB/)
KBO( :, 1,18, 5) = (/&
&9.4274E-03_JPRB,9.6965E-03_JPRB,5.4803E-02_JPRB,8.1156E-02_JPRB,1.0095E-01_JPRB,1.0689E-01_JPRB/)
KBO( :, 2,18, 5) = (/&
&9.7636E-03_JPRB,1.0029E-02_JPRB,5.6180E-02_JPRB,8.3292E-02_JPRB,1.0368E-01_JPRB,1.0994E-01_JPRB/)
KBO( :, 3,18, 5) = (/&
&1.0159E-02_JPRB,1.0423E-02_JPRB,5.7359E-02_JPRB,8.5142E-02_JPRB,1.0612E-01_JPRB,1.1256E-01_JPRB/)
KBO( :, 4,18, 5) = (/&
&1.0557E-02_JPRB,1.0823E-02_JPRB,5.8403E-02_JPRB,8.6709E-02_JPRB,1.0803E-01_JPRB,1.1430E-01_JPRB/)
KBO( :, 5,18, 5) = (/&
&1.0979E-02_JPRB,1.1237E-02_JPRB,5.9376E-02_JPRB,8.7774E-02_JPRB,1.0903E-01_JPRB,1.1483E-01_JPRB/)
KBO( :, 1,19, 5) = (/&
&7.9098E-03_JPRB,8.2116E-03_JPRB,4.7414E-02_JPRB,7.0216E-02_JPRB,8.7160E-02_JPRB,9.1322E-02_JPRB/)
KBO( :, 2,19, 5) = (/&
&8.2326E-03_JPRB,8.5288E-03_JPRB,4.8610E-02_JPRB,7.2087E-02_JPRB,8.9657E-02_JPRB,9.3915E-02_JPRB/)
KBO( :, 3,19, 5) = (/&
&8.5662E-03_JPRB,8.8617E-03_JPRB,4.9664E-02_JPRB,7.3691E-02_JPRB,9.1636E-02_JPRB,9.5646E-02_JPRB/)
KBO( :, 4,19, 5) = (/&
&8.9074E-03_JPRB,9.1995E-03_JPRB,5.0599E-02_JPRB,7.4784E-02_JPRB,9.2706E-02_JPRB,9.6286E-02_JPRB/)
KBO( :, 5,19, 5) = (/&
&9.2777E-03_JPRB,9.5603E-03_JPRB,5.1404E-02_JPRB,7.5248E-02_JPRB,9.2890E-02_JPRB,9.6015E-02_JPRB/)
KBO( :, 1,20, 5) = (/&
&6.6406E-03_JPRB,6.9730E-03_JPRB,4.0765E-02_JPRB,6.0395E-02_JPRB,7.4894E-02_JPRB,7.7615E-02_JPRB/)
KBO( :, 2,20, 5) = (/&
&6.9207E-03_JPRB,7.2477E-03_JPRB,4.1802E-02_JPRB,6.1965E-02_JPRB,7.6901E-02_JPRB,7.9381E-02_JPRB/)
KBO( :, 3,20, 5) = (/&
&7.2065E-03_JPRB,7.5323E-03_JPRB,4.2689E-02_JPRB,6.3071E-02_JPRB,7.8052E-02_JPRB,8.0177E-02_JPRB/)
KBO( :, 4,20, 5) = (/&
&7.5033E-03_JPRB,7.8245E-03_JPRB,4.3401E-02_JPRB,6.3586E-02_JPRB,7.8425E-02_JPRB,8.0205E-02_JPRB/)
KBO( :, 5,20, 5) = (/&
&7.8207E-03_JPRB,8.1353E-03_JPRB,4.3986E-02_JPRB,6.3704E-02_JPRB,7.8211E-02_JPRB,7.9644E-02_JPRB/)
KBO( :, 1,21, 5) = (/&
&5.5684E-03_JPRB,5.9172E-03_JPRB,3.4857E-02_JPRB,5.1594E-02_JPRB,6.3858E-02_JPRB,6.5331E-02_JPRB/)
KBO( :, 2,21, 5) = (/&
&5.8079E-03_JPRB,6.1557E-03_JPRB,3.5708E-02_JPRB,5.2705E-02_JPRB,6.5132E-02_JPRB,6.6285E-02_JPRB/)
KBO( :, 3,21, 5) = (/&
&6.0503E-03_JPRB,6.4001E-03_JPRB,3.6352E-02_JPRB,5.3300E-02_JPRB,6.5675E-02_JPRB,6.6569E-02_JPRB/)
KBO( :, 4,21, 5) = (/&
&6.2998E-03_JPRB,6.6477E-03_JPRB,3.6852E-02_JPRB,5.3519E-02_JPRB,6.5720E-02_JPRB,6.6352E-02_JPRB/)
KBO( :, 5,21, 5) = (/&
&6.5744E-03_JPRB,6.9172E-03_JPRB,3.7271E-02_JPRB,5.3554E-02_JPRB,6.5371E-02_JPRB,6.5708E-02_JPRB/)
KBO( :, 1,22, 5) = (/&
&4.6792E-03_JPRB,5.0331E-03_JPRB,2.9657E-02_JPRB,4.3716E-02_JPRB,5.3931E-02_JPRB,5.4472E-02_JPRB/)
KBO( :, 2,22, 5) = (/&
&4.8778E-03_JPRB,5.2371E-03_JPRB,3.0261E-02_JPRB,4.4366E-02_JPRB,5.4607E-02_JPRB,5.4935E-02_JPRB/)
KBO( :, 3,22, 5) = (/&
&5.0770E-03_JPRB,5.4422E-03_JPRB,3.0710E-02_JPRB,4.4665E-02_JPRB,5.4836E-02_JPRB,5.4959E-02_JPRB/)
KBO( :, 4,22, 5) = (/&
&5.2927E-03_JPRB,5.6586E-03_JPRB,3.1096E-02_JPRB,4.4798E-02_JPRB,5.4724E-02_JPRB,5.4622E-02_JPRB/)
KBO( :, 5,22, 5) = (/&
&5.5434E-03_JPRB,5.9042E-03_JPRB,3.1379E-02_JPRB,4.4838E-02_JPRB,5.4360E-02_JPRB,5.3969E-02_JPRB/)
KBO( :, 1,23, 5) = (/&
&3.9250E-03_JPRB,4.2788E-03_JPRB,2.5012E-02_JPRB,3.6685E-02_JPRB,4.5117E-02_JPRB,4.5081E-02_JPRB/)
KBO( :, 2,23, 5) = (/&
&4.0873E-03_JPRB,4.4491E-03_JPRB,2.5443E-02_JPRB,3.7065E-02_JPRB,4.5485E-02_JPRB,4.5295E-02_JPRB/)
KBO( :, 3,23, 5) = (/&
&4.2581E-03_JPRB,4.6288E-03_JPRB,2.5803E-02_JPRB,3.7271E-02_JPRB,4.5559E-02_JPRB,4.5199E-02_JPRB/)
KBO( :, 4,23, 5) = (/&
&4.4522E-03_JPRB,4.8247E-03_JPRB,2.6083E-02_JPRB,3.7398E-02_JPRB,4.5404E-02_JPRB,4.4816E-02_JPRB/)
KBO( :, 5,23, 5) = (/&
&4.6797E-03_JPRB,5.0478E-03_JPRB,2.6273E-02_JPRB,3.7409E-02_JPRB,4.5088E-02_JPRB,4.4196E-02_JPRB/)
KBO( :, 1,24, 5) = (/&
&3.2858E-03_JPRB,3.6291E-03_JPRB,2.0947E-02_JPRB,3.0585E-02_JPRB,3.7522E-02_JPRB,3.7149E-02_JPRB/)
KBO( :, 2,24, 5) = (/&
&3.4236E-03_JPRB,3.7775E-03_JPRB,2.1296E-02_JPRB,3.0855E-02_JPRB,3.7729E-02_JPRB,3.7225E-02_JPRB/)
KBO( :, 3,24, 5) = (/&
&3.5756E-03_JPRB,3.9404E-03_JPRB,2.1574E-02_JPRB,3.1034E-02_JPRB,3.7731E-02_JPRB,3.7059E-02_JPRB/)
KBO( :, 4,24, 5) = (/&
&3.7547E-03_JPRB,4.1217E-03_JPRB,2.1772E-02_JPRB,3.1132E-02_JPRB,3.7589E-02_JPRB,3.6671E-02_JPRB/)
KBO( :, 5,24, 5) = (/&
&3.9592E-03_JPRB,4.3220E-03_JPRB,2.1911E-02_JPRB,3.1105E-02_JPRB,3.7336E-02_JPRB,3.6105E-02_JPRB/)
KBO( :, 1,25, 5) = (/&
&2.7485E-03_JPRB,3.0715E-03_JPRB,1.7485E-02_JPRB,2.5411E-02_JPRB,3.1088E-02_JPRB,3.0529E-02_JPRB/)
KBO( :, 2,25, 5) = (/&
&2.8696E-03_JPRB,3.2062E-03_JPRB,1.7760E-02_JPRB,2.5637E-02_JPRB,3.1212E-02_JPRB,3.0522E-02_JPRB/)
KBO( :, 3,25, 5) = (/&
&3.0093E-03_JPRB,3.3562E-03_JPRB,1.7965E-02_JPRB,2.5792E-02_JPRB,3.1200E-02_JPRB,3.0326E-02_JPRB/)
KBO( :, 4,25, 5) = (/&
&3.1710E-03_JPRB,3.5209E-03_JPRB,1.8112E-02_JPRB,2.5834E-02_JPRB,3.1084E-02_JPRB,2.9961E-02_JPRB/)
KBO( :, 5,25, 5) = (/&
&3.3541E-03_JPRB,3.7049E-03_JPRB,1.8221E-02_JPRB,2.5787E-02_JPRB,3.0865E-02_JPRB,2.9461E-02_JPRB/)
KBO( :, 1,26, 5) = (/&
&2.3019E-03_JPRB,2.5991E-03_JPRB,1.4558E-02_JPRB,2.1083E-02_JPRB,2.5705E-02_JPRB,2.5046E-02_JPRB/)
KBO( :, 2,26, 5) = (/&
&2.4097E-03_JPRB,2.7218E-03_JPRB,1.4765E-02_JPRB,2.1273E-02_JPRB,2.5791E-02_JPRB,2.4990E-02_JPRB/)
KBO( :, 3,26, 5) = (/&
&2.5374E-03_JPRB,2.8582E-03_JPRB,1.4920E-02_JPRB,2.1375E-02_JPRB,2.5785E-02_JPRB,2.4784E-02_JPRB/)
KBO( :, 4,26, 5) = (/&
&2.6838E-03_JPRB,3.0095E-03_JPRB,1.5036E-02_JPRB,2.1391E-02_JPRB,2.5681E-02_JPRB,2.4453E-02_JPRB/)
KBO( :, 5,26, 5) = (/&
&2.8416E-03_JPRB,3.1735E-03_JPRB,1.5124E-02_JPRB,2.1341E-02_JPRB,2.5468E-02_JPRB,2.4016E-02_JPRB/)
KBO( :, 1,27, 5) = (/&
&1.9284E-03_JPRB,2.1979E-03_JPRB,1.2092E-02_JPRB,1.7474E-02_JPRB,2.1233E-02_JPRB,2.0526E-02_JPRB/)
KBO( :, 2,27, 5) = (/&
&2.0271E-03_JPRB,2.3110E-03_JPRB,1.2248E-02_JPRB,1.7617E-02_JPRB,2.1305E-02_JPRB,2.0445E-02_JPRB/)
KBO( :, 3,27, 5) = (/&
&2.1413E-03_JPRB,2.4339E-03_JPRB,1.2368E-02_JPRB,1.7683E-02_JPRB,2.1297E-02_JPRB,2.0248E-02_JPRB/)
KBO( :, 4,27, 5) = (/&
&2.2700E-03_JPRB,2.5708E-03_JPRB,1.2461E-02_JPRB,1.7683E-02_JPRB,2.1187E-02_JPRB,1.9954E-02_JPRB/)
KBO( :, 5,27, 5) = (/&
&2.4050E-03_JPRB,2.7137E-03_JPRB,1.2547E-02_JPRB,1.7644E-02_JPRB,2.0996E-02_JPRB,1.9578E-02_JPRB/)
KBO( :, 1,28, 5) = (/&
&1.6177E-03_JPRB,1.8598E-03_JPRB,1.0025E-02_JPRB,1.4464E-02_JPRB,1.7533E-02_JPRB,1.6811E-02_JPRB/)
KBO( :, 2,28, 5) = (/&
&1.7070E-03_JPRB,1.9616E-03_JPRB,1.0146E-02_JPRB,1.4566E-02_JPRB,1.7595E-02_JPRB,1.6720E-02_JPRB/)
KBO( :, 3,28, 5) = (/&
&1.8084E-03_JPRB,2.0731E-03_JPRB,1.0240E-02_JPRB,1.4610E-02_JPRB,1.7567E-02_JPRB,1.6539E-02_JPRB/)
KBO( :, 4,28, 5) = (/&
&1.9191E-03_JPRB,2.1930E-03_JPRB,1.0326E-02_JPRB,1.4610E-02_JPRB,1.7462E-02_JPRB,1.6282E-02_JPRB/)
KBO( :, 5,28, 5) = (/&
&2.0364E-03_JPRB,2.3203E-03_JPRB,1.0409E-02_JPRB,1.4583E-02_JPRB,1.7296E-02_JPRB,1.5960E-02_JPRB/)
KBO( :, 1,29, 5) = (/&
&1.3593E-03_JPRB,1.5756E-03_JPRB,8.3017E-03_JPRB,1.1957E-02_JPRB,1.4479E-02_JPRB,1.3772E-02_JPRB/)
KBO( :, 2,29, 5) = (/&
&1.4401E-03_JPRB,1.6674E-03_JPRB,8.3969E-03_JPRB,1.2033E-02_JPRB,1.4515E-02_JPRB,1.3681E-02_JPRB/)
KBO( :, 3,29, 5) = (/&
&1.5286E-03_JPRB,1.7667E-03_JPRB,8.4784E-03_JPRB,1.2064E-02_JPRB,1.4477E-02_JPRB,1.3518E-02_JPRB/)
KBO( :, 4,29, 5) = (/&
&1.6239E-03_JPRB,1.8725E-03_JPRB,8.5587E-03_JPRB,1.2064E-02_JPRB,1.4381E-02_JPRB,1.3294E-02_JPRB/)
KBO( :, 5,29, 5) = (/&
&1.7270E-03_JPRB,1.9868E-03_JPRB,8.6438E-03_JPRB,1.2057E-02_JPRB,1.4239E-02_JPRB,1.3028E-02_JPRB/)
KBO( :, 1,30, 5) = (/&
&1.1445E-03_JPRB,1.3361E-03_JPRB,6.8720E-03_JPRB,9.8791E-03_JPRB,1.1950E-02_JPRB,1.1283E-02_JPRB/)
KBO( :, 2,30, 5) = (/&
&1.2156E-03_JPRB,1.4188E-03_JPRB,6.9493E-03_JPRB,9.9349E-03_JPRB,1.1964E-02_JPRB,1.1195E-02_JPRB/)
KBO( :, 3,30, 5) = (/&
&1.2922E-03_JPRB,1.5061E-03_JPRB,7.0248E-03_JPRB,9.9580E-03_JPRB,1.1924E-02_JPRB,1.1051E-02_JPRB/)
KBO( :, 4,30, 5) = (/&
&1.3747E-03_JPRB,1.6004E-03_JPRB,7.1033E-03_JPRB,9.9696E-03_JPRB,1.1840E-02_JPRB,1.0864E-02_JPRB/)
KBO( :, 5,30, 5) = (/&
&1.4679E-03_JPRB,1.7048E-03_JPRB,7.1904E-03_JPRB,9.9722E-03_JPRB,1.1724E-02_JPRB,1.0645E-02_JPRB/)
KBO( :, 1,31, 5) = (/&
&9.6571E-04_JPRB,1.1355E-03_JPRB,5.6867E-03_JPRB,8.1598E-03_JPRB,9.8539E-03_JPRB,9.2507E-03_JPRB/)
KBO( :, 2,31, 5) = (/&
&1.0268E-03_JPRB,1.2081E-03_JPRB,5.7561E-03_JPRB,8.2013E-03_JPRB,9.8560E-03_JPRB,9.1701E-03_JPRB/)
KBO( :, 3,31, 5) = (/&
&1.0932E-03_JPRB,1.2857E-03_JPRB,5.8273E-03_JPRB,8.2243E-03_JPRB,9.8178E-03_JPRB,9.0482E-03_JPRB/)
KBO( :, 4,31, 5) = (/&
&1.1666E-03_JPRB,1.3712E-03_JPRB,5.9075E-03_JPRB,8.2428E-03_JPRB,9.7465E-03_JPRB,8.8946E-03_JPRB/)
KBO( :, 5,31, 5) = (/&
&1.2509E-03_JPRB,1.4662E-03_JPRB,5.9896E-03_JPRB,8.2555E-03_JPRB,9.6578E-03_JPRB,8.7121E-03_JPRB/)
KBO( :, 1,32, 5) = (/&
&8.1549E-04_JPRB,9.6647E-04_JPRB,4.7087E-03_JPRB,6.7390E-03_JPRB,8.1222E-03_JPRB,7.5866E-03_JPRB/)
KBO( :, 2,32, 5) = (/&
&8.6808E-04_JPRB,1.0303E-03_JPRB,4.7745E-03_JPRB,6.7731E-03_JPRB,8.1188E-03_JPRB,7.5153E-03_JPRB/)
KBO( :, 3,32, 5) = (/&
&9.2635E-04_JPRB,1.0997E-03_JPRB,4.8447E-03_JPRB,6.7992E-03_JPRB,8.0828E-03_JPRB,7.4160E-03_JPRB/)
KBO( :, 4,32, 5) = (/&
&9.9293E-04_JPRB,1.1779E-03_JPRB,4.9222E-03_JPRB,6.8226E-03_JPRB,8.0279E-03_JPRB,7.2877E-03_JPRB/)
KBO( :, 5,32, 5) = (/&
&1.0686E-03_JPRB,1.2641E-03_JPRB,4.9952E-03_JPRB,6.8449E-03_JPRB,7.9628E-03_JPRB,7.1366E-03_JPRB/)
KBO( :, 1,33, 5) = (/&
&6.8866E-04_JPRB,8.2347E-04_JPRB,3.9045E-03_JPRB,5.5660E-03_JPRB,6.6934E-03_JPRB,6.2259E-03_JPRB/)
KBO( :, 2,33, 5) = (/&
&7.3455E-04_JPRB,8.7986E-04_JPRB,3.9663E-03_JPRB,5.5986E-03_JPRB,6.6866E-03_JPRB,6.1677E-03_JPRB/)
KBO( :, 3,33, 5) = (/&
&7.8698E-04_JPRB,9.4282E-04_JPRB,4.0361E-03_JPRB,5.6281E-03_JPRB,6.6584E-03_JPRB,6.0842E-03_JPRB/)
KBO( :, 4,33, 5) = (/&
&8.4706E-04_JPRB,1.0140E-03_JPRB,4.1036E-03_JPRB,5.6568E-03_JPRB,6.6185E-03_JPRB,5.9772E-03_JPRB/)
KBO( :, 5,33, 5) = (/&
&9.1579E-04_JPRB,1.0926E-03_JPRB,4.1728E-03_JPRB,5.6818E-03_JPRB,6.5697E-03_JPRB,5.8519E-03_JPRB/)
KBO( :, 1,34, 5) = (/&
&5.8058E-04_JPRB,7.0023E-04_JPRB,3.2403E-03_JPRB,4.6005E-03_JPRB,5.5166E-03_JPRB,5.1111E-03_JPRB/)
KBO( :, 2,34, 5) = (/&
&6.2122E-04_JPRB,7.5048E-04_JPRB,3.3005E-03_JPRB,4.6334E-03_JPRB,5.5099E-03_JPRB,5.0626E-03_JPRB/)
KBO( :, 3,34, 5) = (/&
&6.6865E-04_JPRB,8.0788E-04_JPRB,3.3630E-03_JPRB,4.6658E-03_JPRB,5.4906E-03_JPRB,4.9925E-03_JPRB/)
KBO( :, 4,34, 5) = (/&
&7.2278E-04_JPRB,8.7227E-04_JPRB,3.4246E-03_JPRB,4.6970E-03_JPRB,5.4619E-03_JPRB,4.9033E-03_JPRB/)
KBO( :, 5,34, 5) = (/&
&7.8420E-04_JPRB,9.4411E-04_JPRB,3.4913E-03_JPRB,4.7221E-03_JPRB,5.4290E-03_JPRB,4.7999E-03_JPRB/)
KBO( :, 1,35, 5) = (/&
&4.8680E-04_JPRB,5.9168E-04_JPRB,2.6886E-03_JPRB,3.8031E-03_JPRB,4.5472E-03_JPRB,4.2007E-03_JPRB/)
KBO( :, 2,35, 5) = (/&
&5.2287E-04_JPRB,6.3647E-04_JPRB,2.7442E-03_JPRB,3.8365E-03_JPRB,4.5442E-03_JPRB,4.1613E-03_JPRB/)
KBO( :, 3,35, 5) = (/&
&5.6494E-04_JPRB,6.8801E-04_JPRB,2.7990E-03_JPRB,3.8713E-03_JPRB,4.5326E-03_JPRB,4.1035E-03_JPRB/)
KBO( :, 4,35, 5) = (/&
&6.1346E-04_JPRB,7.4591E-04_JPRB,2.8564E-03_JPRB,3.9017E-03_JPRB,4.5150E-03_JPRB,4.0303E-03_JPRB/)
KBO( :, 5,35, 5) = (/&
&6.6714E-04_JPRB,8.1053E-04_JPRB,2.9207E-03_JPRB,3.9294E-03_JPRB,4.4955E-03_JPRB,3.9472E-03_JPRB/)
KBO( :, 1,36, 5) = (/&
&4.0556E-04_JPRB,4.9618E-04_JPRB,2.2284E-03_JPRB,3.1440E-03_JPRB,3.7492E-03_JPRB,3.4553E-03_JPRB/)
KBO( :, 2,36, 5) = (/&
&4.3716E-04_JPRB,5.3572E-04_JPRB,2.2775E-03_JPRB,3.1778E-03_JPRB,3.7514E-03_JPRB,3.4245E-03_JPRB/)
KBO( :, 3,36, 5) = (/&
&4.7403E-04_JPRB,5.8132E-04_JPRB,2.3270E-03_JPRB,3.2124E-03_JPRB,3.7468E-03_JPRB,3.3780E-03_JPRB/)
KBO( :, 4,36, 5) = (/&
&5.1659E-04_JPRB,6.3283E-04_JPRB,2.3801E-03_JPRB,3.2412E-03_JPRB,3.7380E-03_JPRB,3.3193E-03_JPRB/)
KBO( :, 5,36, 5) = (/&
&5.6320E-04_JPRB,6.9001E-04_JPRB,2.4401E-03_JPRB,3.2716E-03_JPRB,3.7268E-03_JPRB,3.2538E-03_JPRB/)
KBO( :, 1,37, 5) = (/&
&3.3445E-04_JPRB,4.1138E-04_JPRB,1.8414E-03_JPRB,2.5960E-03_JPRB,3.0918E-03_JPRB,2.8440E-03_JPRB/)
KBO( :, 2,37, 5) = (/&
&3.6139E-04_JPRB,4.4542E-04_JPRB,1.8850E-03_JPRB,2.6293E-03_JPRB,3.0984E-03_JPRB,2.8216E-03_JPRB/)
KBO( :, 3,37, 5) = (/&
&3.9302E-04_JPRB,4.8495E-04_JPRB,1.9291E-03_JPRB,2.6624E-03_JPRB,3.0995E-03_JPRB,2.7862E-03_JPRB/)
KBO( :, 4,37, 5) = (/&
&4.2962E-04_JPRB,5.3000E-04_JPRB,1.9778E-03_JPRB,2.6913E-03_JPRB,3.0985E-03_JPRB,2.7408E-03_JPRB/)
KBO( :, 5,37, 5) = (/&
&4.6957E-04_JPRB,5.7981E-04_JPRB,2.0321E-03_JPRB,2.7224E-03_JPRB,3.0939E-03_JPRB,2.6899E-03_JPRB/)
KBO( :, 1,38, 5) = (/&
&2.7565E-04_JPRB,3.4069E-04_JPRB,1.5215E-03_JPRB,2.1439E-03_JPRB,2.5502E-03_JPRB,2.3418E-03_JPRB/)
KBO( :, 2,38, 5) = (/&
&2.9863E-04_JPRB,3.7003E-04_JPRB,1.5598E-03_JPRB,2.1756E-03_JPRB,2.5600E-03_JPRB,2.3264E-03_JPRB/)
KBO( :, 3,38, 5) = (/&
&3.2577E-04_JPRB,4.0422E-04_JPRB,1.5995E-03_JPRB,2.2068E-03_JPRB,2.5657E-03_JPRB,2.2995E-03_JPRB/)
KBO( :, 4,38, 5) = (/&
&3.5709E-04_JPRB,4.4339E-04_JPRB,1.6429E-03_JPRB,2.2349E-03_JPRB,2.5695E-03_JPRB,2.2650E-03_JPRB/)
KBO( :, 5,38, 5) = (/&
&3.9150E-04_JPRB,4.8695E-04_JPRB,1.6922E-03_JPRB,2.2658E-03_JPRB,2.5693E-03_JPRB,2.2257E-03_JPRB/)
KBO( :, 1,39, 5) = (/&
&2.2724E-04_JPRB,2.8211E-04_JPRB,1.2574E-03_JPRB,1.7709E-03_JPRB,2.1038E-03_JPRB,1.9299E-03_JPRB/)
KBO( :, 2,39, 5) = (/&
&2.4681E-04_JPRB,3.0736E-04_JPRB,1.2915E-03_JPRB,1.8008E-03_JPRB,2.1155E-03_JPRB,1.9194E-03_JPRB/)
KBO( :, 3,39, 5) = (/&
&2.7014E-04_JPRB,3.3704E-04_JPRB,1.3268E-03_JPRB,1.8293E-03_JPRB,2.1247E-03_JPRB,1.8997E-03_JPRB/)
KBO( :, 4,39, 5) = (/&
&2.9696E-04_JPRB,3.7109E-04_JPRB,1.3658E-03_JPRB,1.8564E-03_JPRB,2.1316E-03_JPRB,1.8739E-03_JPRB/)
KBO( :, 5,39, 5) = (/&
&3.2661E-04_JPRB,4.0911E-04_JPRB,1.4099E-03_JPRB,1.8866E-03_JPRB,2.1349E-03_JPRB,1.8442E-03_JPRB/)
KBO( :, 1,40, 5) = (/&
&1.8579E-04_JPRB,2.3160E-04_JPRB,1.0365E-03_JPRB,1.4603E-03_JPRB,1.7343E-03_JPRB,1.5866E-03_JPRB/)
KBO( :, 2,40, 5) = (/&
&2.0221E-04_JPRB,2.5290E-04_JPRB,1.0666E-03_JPRB,1.4877E-03_JPRB,1.7476E-03_JPRB,1.5810E-03_JPRB/)
KBO( :, 3,40, 5) = (/&
&2.2187E-04_JPRB,2.7826E-04_JPRB,1.0975E-03_JPRB,1.5141E-03_JPRB,1.7589E-03_JPRB,1.5669E-03_JPRB/)
KBO( :, 4,40, 5) = (/&
&2.4464E-04_JPRB,3.0747E-04_JPRB,1.1320E-03_JPRB,1.5399E-03_JPRB,1.7682E-03_JPRB,1.5479E-03_JPRB/)
KBO( :, 5,40, 5) = (/&
&2.6982E-04_JPRB,3.4023E-04_JPRB,1.1712E-03_JPRB,1.5681E-03_JPRB,1.7744E-03_JPRB,1.5254E-03_JPRB/)
KBO( :, 1,41, 5) = (/&
&1.5166E-04_JPRB,1.8980E-04_JPRB,8.5379E-04_JPRB,1.2035E-03_JPRB,1.4293E-03_JPRB,1.3039E-03_JPRB/)
KBO( :, 2,41, 5) = (/&
&1.6546E-04_JPRB,2.0775E-04_JPRB,8.8025E-04_JPRB,1.2284E-03_JPRB,1.4432E-03_JPRB,1.3014E-03_JPRB/)
KBO( :, 3,41, 5) = (/&
&1.8194E-04_JPRB,2.2930E-04_JPRB,9.0741E-04_JPRB,1.2528E-03_JPRB,1.4560E-03_JPRB,1.2919E-03_JPRB/)
KBO( :, 4,41, 5) = (/&
&2.0120E-04_JPRB,2.5429E-04_JPRB,9.3787E-04_JPRB,1.2766E-03_JPRB,1.4664E-03_JPRB,1.2782E-03_JPRB/)
KBO( :, 5,41, 5) = (/&
&2.2263E-04_JPRB,2.8250E-04_JPRB,9.7232E-04_JPRB,1.3029E-03_JPRB,1.4746E-03_JPRB,1.2613E-03_JPRB/)
KBO( :, 1,42, 5) = (/&
&1.2374E-04_JPRB,1.5546E-04_JPRB,7.0307E-04_JPRB,9.9137E-04_JPRB,1.1774E-03_JPRB,1.0716E-03_JPRB/)
KBO( :, 2,42, 5) = (/&
&1.3533E-04_JPRB,1.7055E-04_JPRB,7.2623E-04_JPRB,1.0140E-03_JPRB,1.1917E-03_JPRB,1.0713E-03_JPRB/)
KBO( :, 3,42, 5) = (/&
&1.4914E-04_JPRB,1.8882E-04_JPRB,7.4998E-04_JPRB,1.0363E-03_JPRB,1.2049E-03_JPRB,1.0651E-03_JPRB/)
KBO( :, 4,42, 5) = (/&
&1.6539E-04_JPRB,2.1022E-04_JPRB,7.7693E-04_JPRB,1.0584E-03_JPRB,1.2160E-03_JPRB,1.0556E-03_JPRB/)
KBO( :, 5,42, 5) = (/&
&1.8361E-04_JPRB,2.3442E-04_JPRB,8.0719E-04_JPRB,1.0824E-03_JPRB,1.2253E-03_JPRB,1.0431E-03_JPRB/)
KBO( :, 1,43, 5) = (/&
&1.0045E-04_JPRB,1.2664E-04_JPRB,5.7734E-04_JPRB,8.1536E-04_JPRB,9.6884E-04_JPRB,8.7977E-04_JPRB/)
KBO( :, 2,43, 5) = (/&
&1.1005E-04_JPRB,1.3917E-04_JPRB,5.9774E-04_JPRB,8.3582E-04_JPRB,9.8292E-04_JPRB,8.8149E-04_JPRB/)
KBO( :, 3,43, 5) = (/&
&1.2153E-04_JPRB,1.5445E-04_JPRB,6.1853E-04_JPRB,8.5606E-04_JPRB,9.9619E-04_JPRB,8.7826E-04_JPRB/)
KBO( :, 4,43, 5) = (/&
&1.3510E-04_JPRB,1.7258E-04_JPRB,6.4186E-04_JPRB,8.7601E-04_JPRB,1.0075E-03_JPRB,8.7187E-04_JPRB/)
KBO( :, 5,43, 5) = (/&
&1.5043E-04_JPRB,1.9318E-04_JPRB,6.6828E-04_JPRB,8.9763E-04_JPRB,1.0172E-03_JPRB,8.6294E-04_JPRB/)
KBO( :, 1,44, 5) = (/&
&8.1305E-05_JPRB,1.0284E-04_JPRB,4.7336E-04_JPRB,6.6976E-04_JPRB,7.9626E-04_JPRB,7.2189E-04_JPRB/)
KBO( :, 2,44, 5) = (/&
&8.9193E-05_JPRB,1.1315E-04_JPRB,4.9111E-04_JPRB,6.8790E-04_JPRB,8.0980E-04_JPRB,7.2505E-04_JPRB/)
KBO( :, 3,44, 5) = (/&
&9.8676E-05_JPRB,1.2583E-04_JPRB,5.0913E-04_JPRB,7.0617E-04_JPRB,8.2256E-04_JPRB,7.2410E-04_JPRB/)
KBO( :, 4,44, 5) = (/&
&1.0996E-04_JPRB,1.4111E-04_JPRB,5.2937E-04_JPRB,7.2436E-04_JPRB,8.3410E-04_JPRB,7.2019E-04_JPRB/)
KBO( :, 5,44, 5) = (/&
&1.2282E-04_JPRB,1.5859E-04_JPRB,5.5236E-04_JPRB,7.4376E-04_JPRB,8.4405E-04_JPRB,7.1417E-04_JPRB/)
KBO( :, 1,45, 5) = (/&
&6.5786E-05_JPRB,8.3420E-05_JPRB,3.8779E-04_JPRB,5.4957E-04_JPRB,6.5386E-04_JPRB,5.9205E-04_JPRB/)
KBO( :, 2,45, 5) = (/&
&7.2236E-05_JPRB,9.1932E-05_JPRB,4.0331E-04_JPRB,5.6601E-04_JPRB,6.6677E-04_JPRB,5.9628E-04_JPRB/)
KBO( :, 3,45, 5) = (/&
&8.0050E-05_JPRB,1.0242E-04_JPRB,4.1883E-04_JPRB,5.8238E-04_JPRB,6.7888E-04_JPRB,5.9688E-04_JPRB/)
KBO( :, 4,45, 5) = (/&
&8.9405E-05_JPRB,1.1521E-04_JPRB,4.3614E-04_JPRB,5.9853E-04_JPRB,6.8997E-04_JPRB,5.9495E-04_JPRB/)
KBO( :, 5,45, 5) = (/&
&1.0018E-04_JPRB,1.3003E-04_JPRB,4.5610E-04_JPRB,6.1576E-04_JPRB,6.9970E-04_JPRB,5.9107E-04_JPRB/)
KBO( :, 1,46, 5) = (/&
&5.3104E-05_JPRB,6.7476E-05_JPRB,3.1711E-04_JPRB,4.5030E-04_JPRB,5.3634E-04_JPRB,4.8529E-04_JPRB/)
KBO( :, 2,46, 5) = (/&
&5.8310E-05_JPRB,7.4440E-05_JPRB,3.3050E-04_JPRB,4.6471E-04_JPRB,5.4814E-04_JPRB,4.8994E-04_JPRB/)
KBO( :, 3,46, 5) = (/&
&6.4721E-05_JPRB,8.3070E-05_JPRB,3.4388E-04_JPRB,4.7945E-04_JPRB,5.5942E-04_JPRB,4.9178E-04_JPRB/)
KBO( :, 4,46, 5) = (/&
&7.2446E-05_JPRB,9.3711E-05_JPRB,3.5879E-04_JPRB,4.9397E-04_JPRB,5.7010E-04_JPRB,4.9130E-04_JPRB/)
KBO( :, 5,46, 5) = (/&
&8.1435E-05_JPRB,1.0620E-04_JPRB,3.7604E-04_JPRB,5.0936E-04_JPRB,5.7974E-04_JPRB,4.8929E-04_JPRB/)
KBO( :, 1,47, 5) = (/&
&4.2686E-05_JPRB,5.4314E-05_JPRB,2.5853E-04_JPRB,3.6799E-04_JPRB,4.3908E-04_JPRB,3.9686E-04_JPRB/)
KBO( :, 2,47, 5) = (/&
&4.6834E-05_JPRB,5.9958E-05_JPRB,2.7010E-04_JPRB,3.8053E-04_JPRB,4.4992E-04_JPRB,4.0194E-04_JPRB/)
KBO( :, 3,47, 5) = (/&
&5.2031E-05_JPRB,6.6956E-05_JPRB,2.8174E-04_JPRB,3.9382E-04_JPRB,4.6023E-04_JPRB,4.0464E-04_JPRB/)
KBO( :, 4,47, 5) = (/&
&5.8344E-05_JPRB,7.5683E-05_JPRB,2.9437E-04_JPRB,4.0674E-04_JPRB,4.7039E-04_JPRB,4.0528E-04_JPRB/)
KBO( :, 5,47, 5) = (/&
&6.5774E-05_JPRB,8.6102E-05_JPRB,3.0904E-04_JPRB,4.2022E-04_JPRB,4.7955E-04_JPRB,4.0445E-04_JPRB/)
KBO( :, 1,48, 5) = (/&
&3.4313E-05_JPRB,4.3687E-05_JPRB,2.1071E-04_JPRB,3.0035E-04_JPRB,3.5902E-04_JPRB,3.2436E-04_JPRB/)
KBO( :, 2,48, 5) = (/&
&3.7593E-05_JPRB,4.8250E-05_JPRB,2.2059E-04_JPRB,3.1121E-04_JPRB,3.6875E-04_JPRB,3.2956E-04_JPRB/)
KBO( :, 3,48, 5) = (/&
&4.1785E-05_JPRB,5.3906E-05_JPRB,2.3062E-04_JPRB,3.2298E-04_JPRB,3.7819E-04_JPRB,3.3287E-04_JPRB/)
KBO( :, 4,48, 5) = (/&
&4.6905E-05_JPRB,6.0993E-05_JPRB,2.4128E-04_JPRB,3.3438E-04_JPRB,3.8763E-04_JPRB,3.3428E-04_JPRB/)
KBO( :, 5,48, 5) = (/&
&5.3020E-05_JPRB,6.9645E-05_JPRB,2.5366E-04_JPRB,3.4620E-04_JPRB,3.9625E-04_JPRB,3.3440E-04_JPRB/)
KBO( :, 1,49, 5) = (/&
&2.7583E-05_JPRB,3.5115E-05_JPRB,1.7155E-04_JPRB,2.4481E-04_JPRB,2.9317E-04_JPRB,2.6498E-04_JPRB/)
KBO( :, 2,49, 5) = (/&
&3.0170E-05_JPRB,3.8800E-05_JPRB,1.7986E-04_JPRB,2.5418E-04_JPRB,3.0189E-04_JPRB,2.7025E-04_JPRB/)
KBO( :, 3,49, 5) = (/&
&3.3521E-05_JPRB,4.3336E-05_JPRB,1.8852E-04_JPRB,2.6447E-04_JPRB,3.1043E-04_JPRB,2.7387E-04_JPRB/)
KBO( :, 4,49, 5) = (/&
&3.7657E-05_JPRB,4.9084E-05_JPRB,1.9758E-04_JPRB,2.7449E-04_JPRB,3.1899E-04_JPRB,2.7586E-04_JPRB/)
KBO( :, 5,49, 5) = (/&
&4.2653E-05_JPRB,5.6226E-05_JPRB,2.0799E-04_JPRB,2.8484E-04_JPRB,3.2703E-04_JPRB,2.7676E-04_JPRB/)
KBO( :, 1,50, 5) = (/&
&2.2217E-05_JPRB,2.8271E-05_JPRB,1.3969E-04_JPRB,1.9948E-04_JPRB,2.3919E-04_JPRB,2.1597E-04_JPRB/)
KBO( :, 2,50, 5) = (/&
&2.4266E-05_JPRB,3.1256E-05_JPRB,1.4667E-04_JPRB,2.0754E-04_JPRB,2.4693E-04_JPRB,2.2097E-04_JPRB/)
KBO( :, 3,50, 5) = (/&
&2.6941E-05_JPRB,3.4914E-05_JPRB,1.5413E-04_JPRB,2.1640E-04_JPRB,2.5457E-04_JPRB,2.2461E-04_JPRB/)
KBO( :, 4,50, 5) = (/&
&3.0285E-05_JPRB,3.9575E-05_JPRB,1.6186E-04_JPRB,2.2530E-04_JPRB,2.6234E-04_JPRB,2.2692E-04_JPRB/)
KBO( :, 5,50, 5) = (/&
&3.4382E-05_JPRB,4.5471E-05_JPRB,1.7067E-04_JPRB,2.3435E-04_JPRB,2.6986E-04_JPRB,2.2825E-04_JPRB/)
KBO( :, 1,51, 5) = (/&
&1.7903E-05_JPRB,2.2773E-05_JPRB,1.1369E-04_JPRB,1.6241E-04_JPRB,1.9498E-04_JPRB,1.7573E-04_JPRB/)
KBO( :, 2,51, 5) = (/&
&1.9536E-05_JPRB,2.5192E-05_JPRB,1.1954E-04_JPRB,1.6937E-04_JPRB,2.0181E-04_JPRB,1.8035E-04_JPRB/)
KBO( :, 3,51, 5) = (/&
&2.1660E-05_JPRB,2.8144E-05_JPRB,1.2601E-04_JPRB,1.7700E-04_JPRB,2.0866E-04_JPRB,1.8387E-04_JPRB/)
KBO( :, 4,51, 5) = (/&
&2.4364E-05_JPRB,3.1929E-05_JPRB,1.3264E-04_JPRB,1.8486E-04_JPRB,2.1560E-04_JPRB,1.8633E-04_JPRB/)
KBO( :, 5,51, 5) = (/&
&2.7713E-05_JPRB,3.6767E-05_JPRB,1.4007E-04_JPRB,1.9273E-04_JPRB,2.2249E-04_JPRB,1.8786E-04_JPRB/)
KBO( :, 1,52, 5) = (/&
&1.4419E-05_JPRB,1.8337E-05_JPRB,9.2470E-05_JPRB,1.3214E-04_JPRB,1.5869E-04_JPRB,1.4290E-04_JPRB/)
KBO( :, 2,52, 5) = (/&
&1.5732E-05_JPRB,2.0292E-05_JPRB,9.7355E-05_JPRB,1.3808E-04_JPRB,1.6476E-04_JPRB,1.4717E-04_JPRB/)
KBO( :, 3,52, 5) = (/&
&1.7402E-05_JPRB,2.2667E-05_JPRB,1.0291E-04_JPRB,1.4460E-04_JPRB,1.7083E-04_JPRB,1.5054E-04_JPRB/)
KBO( :, 4,52, 5) = (/&
&1.9581E-05_JPRB,2.5730E-05_JPRB,1.0857E-04_JPRB,1.5152E-04_JPRB,1.7697E-04_JPRB,1.5305E-04_JPRB/)
KBO( :, 5,52, 5) = (/&
&2.2301E-05_JPRB,2.9666E-05_JPRB,1.1484E-04_JPRB,1.5832E-04_JPRB,1.8319E-04_JPRB,1.5468E-04_JPRB/)
KBO( :, 1,53, 5) = (/&
&1.1603E-05_JPRB,1.4759E-05_JPRB,7.5154E-05_JPRB,1.0740E-04_JPRB,1.2904E-04_JPRB,1.1618E-04_JPRB/)
KBO( :, 2,53, 5) = (/&
&1.2667E-05_JPRB,1.6333E-05_JPRB,7.9235E-05_JPRB,1.1248E-04_JPRB,1.3438E-04_JPRB,1.2007E-04_JPRB/)
KBO( :, 3,53, 5) = (/&
&1.3975E-05_JPRB,1.8245E-05_JPRB,8.3933E-05_JPRB,1.1800E-04_JPRB,1.3960E-04_JPRB,1.2329E-04_JPRB/)
KBO( :, 4,53, 5) = (/&
&1.5718E-05_JPRB,2.0708E-05_JPRB,8.8803E-05_JPRB,1.2402E-04_JPRB,1.4502E-04_JPRB,1.2574E-04_JPRB/)
KBO( :, 5,53, 5) = (/&
&1.7916E-05_JPRB,2.3895E-05_JPRB,9.4069E-05_JPRB,1.2995E-04_JPRB,1.5061E-04_JPRB,1.2749E-04_JPRB/)
KBO( :, 1,54, 5) = (/&
&9.3552E-06_JPRB,1.1912E-05_JPRB,6.1100E-05_JPRB,8.7316E-05_JPRB,1.0492E-04_JPRB,9.4080E-05_JPRB/)
KBO( :, 2,54, 5) = (/&
&1.0223E-05_JPRB,1.3180E-05_JPRB,6.4519E-05_JPRB,9.1648E-05_JPRB,1.0960E-04_JPRB,9.7474E-05_JPRB/)
KBO( :, 3,54, 5) = (/&
&1.1260E-05_JPRB,1.4728E-05_JPRB,6.8487E-05_JPRB,9.6346E-05_JPRB,1.1410E-04_JPRB,1.0031E-04_JPRB/)
KBO( :, 4,54, 5) = (/&
&1.2653E-05_JPRB,1.6714E-05_JPRB,7.2680E-05_JPRB,1.0156E-04_JPRB,1.1881E-04_JPRB,1.0254E-04_JPRB/)
KBO( :, 5,54, 5) = (/&
&1.4429E-05_JPRB,1.9299E-05_JPRB,7.7137E-05_JPRB,1.0670E-04_JPRB,1.2378E-04_JPRB,1.0417E-04_JPRB/)
KBO( :, 1,55, 5) = (/&
&7.5478E-06_JPRB,9.6233E-06_JPRB,4.9651E-05_JPRB,7.0961E-05_JPRB,8.5289E-05_JPRB,7.6005E-05_JPRB/)
KBO( :, 2,55, 5) = (/&
&8.2560E-06_JPRB,1.0645E-05_JPRB,5.2535E-05_JPRB,7.4651E-05_JPRB,8.9338E-05_JPRB,7.8872E-05_JPRB/)
KBO( :, 3,55, 5) = (/&
&9.0843E-06_JPRB,1.1897E-05_JPRB,5.5871E-05_JPRB,7.8654E-05_JPRB,9.3220E-05_JPRB,8.1320E-05_JPRB/)
KBO( :, 4,55, 5) = (/&
&1.0193E-05_JPRB,1.3501E-05_JPRB,5.9444E-05_JPRB,8.3119E-05_JPRB,9.7325E-05_JPRB,8.3263E-05_JPRB/)
KBO( :, 5,55, 5) = (/&
&1.1628E-05_JPRB,1.5599E-05_JPRB,6.3252E-05_JPRB,8.7606E-05_JPRB,1.0169E-04_JPRB,8.4683E-05_JPRB/)
KBO( :, 1,56, 5) = (/&
&6.0903E-06_JPRB,7.7718E-06_JPRB,4.0310E-05_JPRB,5.7612E-05_JPRB,6.9244E-05_JPRB,6.1397E-05_JPRB/)
KBO( :, 2,56, 5) = (/&
&6.6641E-06_JPRB,8.5930E-06_JPRB,4.2736E-05_JPRB,6.0755E-05_JPRB,7.2744E-05_JPRB,6.3793E-05_JPRB/)
KBO( :, 3,56, 5) = (/&
&7.3291E-06_JPRB,9.6040E-06_JPRB,4.5523E-05_JPRB,6.4146E-05_JPRB,7.6097E-05_JPRB,6.5892E-05_JPRB/)
KBO( :, 4,56, 5) = (/&
&8.2059E-06_JPRB,1.0897E-05_JPRB,4.8582E-05_JPRB,6.7958E-05_JPRB,7.9612E-05_JPRB,6.7572E-05_JPRB/)
KBO( :, 5,56, 5) = (/&
&9.3593E-06_JPRB,1.2596E-05_JPRB,5.1826E-05_JPRB,7.1849E-05_JPRB,8.3426E-05_JPRB,6.8816E-05_JPRB/)
KBO( :, 1,57, 5) = (/&
&4.9169E-06_JPRB,6.2768E-06_JPRB,3.2692E-05_JPRB,4.6726E-05_JPRB,5.6174E-05_JPRB,4.9561E-05_JPRB/)
KBO( :, 2,57, 5) = (/&
&5.3758E-06_JPRB,6.9313E-06_JPRB,3.4730E-05_JPRB,4.9399E-05_JPRB,5.9171E-05_JPRB,5.1566E-05_JPRB/)
KBO( :, 3,57, 5) = (/&
&5.9131E-06_JPRB,7.7475E-06_JPRB,3.7055E-05_JPRB,5.2261E-05_JPRB,6.2056E-05_JPRB,5.3362E-05_JPRB/)
KBO( :, 4,57, 5) = (/&
&6.6016E-06_JPRB,8.7843E-06_JPRB,3.9661E-05_JPRB,5.5498E-05_JPRB,6.5058E-05_JPRB,5.4813E-05_JPRB/)
KBO( :, 5,57, 5) = (/&
&7.5245E-06_JPRB,1.0159E-05_JPRB,4.2420E-05_JPRB,5.8870E-05_JPRB,6.8384E-05_JPRB,5.5909E-05_JPRB/)
KBO( :, 1,58, 5) = (/&
&3.9769E-06_JPRB,5.0771E-06_JPRB,2.6520E-05_JPRB,3.7905E-05_JPRB,4.5566E-05_JPRB,3.9988E-05_JPRB/)
KBO( :, 2,58, 5) = (/&
&4.3395E-06_JPRB,5.5964E-06_JPRB,2.8222E-05_JPRB,4.0161E-05_JPRB,4.8120E-05_JPRB,4.1683E-05_JPRB/)
KBO( :, 3,58, 5) = (/&
&4.7765E-06_JPRB,6.2573E-06_JPRB,3.0162E-05_JPRB,4.2567E-05_JPRB,5.0612E-05_JPRB,4.3174E-05_JPRB/)
KBO( :, 4,58, 5) = (/&
&5.3191E-06_JPRB,7.0924E-06_JPRB,3.2377E-05_JPRB,4.5319E-05_JPRB,5.3172E-05_JPRB,4.4428E-05_JPRB/)
KBO( :, 5,58, 5) = (/&
&6.0584E-06_JPRB,8.2028E-06_JPRB,3.4727E-05_JPRB,4.8232E-05_JPRB,5.6042E-05_JPRB,4.5381E-05_JPRB/)
KBO( :, 1,59, 5) = (/&
&3.2625E-06_JPRB,4.1716E-06_JPRB,2.1747E-05_JPRB,3.1052E-05_JPRB,3.7329E-05_JPRB,3.2409E-05_JPRB/)
KBO( :, 2,59, 5) = (/&
&3.5622E-06_JPRB,4.6062E-06_JPRB,2.3191E-05_JPRB,3.2966E-05_JPRB,3.9488E-05_JPRB,3.3775E-05_JPRB/)
KBO( :, 3,59, 5) = (/&
&3.9265E-06_JPRB,5.1603E-06_JPRB,2.4857E-05_JPRB,3.5039E-05_JPRB,4.1610E-05_JPRB,3.4936E-05_JPRB/)
KBO( :, 4,59, 5) = (/&
&4.3796E-06_JPRB,5.8651E-06_JPRB,2.6758E-05_JPRB,3.7407E-05_JPRB,4.3840E-05_JPRB,3.5912E-05_JPRB/)
KBO( :, 5,59, 5) = (/&
&5.0004E-06_JPRB,6.8064E-06_JPRB,2.8778E-05_JPRB,3.9920E-05_JPRB,4.6344E-05_JPRB,3.6645E-05_JPRB/)
KBO( :, 1,13, 6) = (/&
&4.2535E-02_JPRB,4.2762E-02_JPRB,1.6998E-01_JPRB,2.5943E-01_JPRB,3.3118E-01_JPRB,3.6759E-01_JPRB/)
KBO( :, 2,13, 6) = (/&
&4.3681E-02_JPRB,4.3907E-02_JPRB,1.7098E-01_JPRB,2.6169E-01_JPRB,3.3567E-01_JPRB,3.7656E-01_JPRB/)
KBO( :, 3,13, 6) = (/&
&4.4881E-02_JPRB,4.5106E-02_JPRB,1.7235E-01_JPRB,2.6332E-01_JPRB,3.3843E-01_JPRB,3.8337E-01_JPRB/)
KBO( :, 4,13, 6) = (/&
&4.6097E-02_JPRB,4.6310E-02_JPRB,1.7381E-01_JPRB,2.6438E-01_JPRB,3.3969E-01_JPRB,3.8855E-01_JPRB/)
KBO( :, 5,13, 6) = (/&
&4.7339E-02_JPRB,4.7538E-02_JPRB,1.7512E-01_JPRB,2.6493E-01_JPRB,3.3999E-01_JPRB,3.9260E-01_JPRB/)
KBO( :, 1,14, 6) = (/&
&3.6653E-02_JPRB,3.6883E-02_JPRB,1.5729E-01_JPRB,2.3949E-01_JPRB,3.0622E-01_JPRB,3.3569E-01_JPRB/)
KBO( :, 2,14, 6) = (/&
&3.7645E-02_JPRB,3.7873E-02_JPRB,1.5902E-01_JPRB,2.4213E-01_JPRB,3.1018E-01_JPRB,3.4313E-01_JPRB/)
KBO( :, 3,14, 6) = (/&
&3.8674E-02_JPRB,3.8902E-02_JPRB,1.6072E-01_JPRB,2.4398E-01_JPRB,3.1256E-01_JPRB,3.4927E-01_JPRB/)
KBO( :, 4,14, 6) = (/&
&3.9715E-02_JPRB,3.9924E-02_JPRB,1.6228E-01_JPRB,2.4539E-01_JPRB,3.1431E-01_JPRB,3.5395E-01_JPRB/)
KBO( :, 5,14, 6) = (/&
&4.0819E-02_JPRB,4.1022E-02_JPRB,1.6343E-01_JPRB,2.4658E-01_JPRB,3.1537E-01_JPRB,3.5723E-01_JPRB/)
KBO( :, 1,15, 6) = (/&
&3.1489E-02_JPRB,3.1717E-02_JPRB,1.4459E-01_JPRB,2.1886E-01_JPRB,2.7929E-01_JPRB,3.0333E-01_JPRB/)
KBO( :, 2,15, 6) = (/&
&3.2325E-02_JPRB,3.2551E-02_JPRB,1.4651E-01_JPRB,2.2152E-01_JPRB,2.8283E-01_JPRB,3.1026E-01_JPRB/)
KBO( :, 3,15, 6) = (/&
&3.3201E-02_JPRB,3.3419E-02_JPRB,1.4819E-01_JPRB,2.2372E-01_JPRB,2.8570E-01_JPRB,3.1588E-01_JPRB/)
KBO( :, 4,15, 6) = (/&
&3.4109E-02_JPRB,3.4317E-02_JPRB,1.4957E-01_JPRB,2.2574E-01_JPRB,2.8792E-01_JPRB,3.2003E-01_JPRB/)
KBO( :, 5,15, 6) = (/&
&3.5196E-02_JPRB,3.5403E-02_JPRB,1.5074E-01_JPRB,2.2750E-01_JPRB,2.8937E-01_JPRB,3.2300E-01_JPRB/)
KBO( :, 1,16, 6) = (/&
&2.6937E-02_JPRB,2.7164E-02_JPRB,1.3162E-01_JPRB,1.9777E-01_JPRB,2.5164E-01_JPRB,2.7236E-01_JPRB/)
KBO( :, 2,16, 6) = (/&
&2.7655E-02_JPRB,2.7881E-02_JPRB,1.3342E-01_JPRB,2.0067E-01_JPRB,2.5537E-01_JPRB,2.7880E-01_JPRB/)
KBO( :, 3,16, 6) = (/&
&2.8404E-02_JPRB,2.8615E-02_JPRB,1.3503E-01_JPRB,2.0326E-01_JPRB,2.5856E-01_JPRB,2.8387E-01_JPRB/)
KBO( :, 4,16, 6) = (/&
&2.9270E-02_JPRB,2.9476E-02_JPRB,1.3640E-01_JPRB,2.0574E-01_JPRB,2.6105E-01_JPRB,2.8764E-01_JPRB/)
KBO( :, 5,16, 6) = (/&
&3.0417E-02_JPRB,3.0624E-02_JPRB,1.3764E-01_JPRB,2.0798E-01_JPRB,2.6293E-01_JPRB,2.9041E-01_JPRB/)
KBO( :, 1,17, 6) = (/&
&2.2953E-02_JPRB,2.3180E-02_JPRB,1.1845E-01_JPRB,1.7721E-01_JPRB,2.2460E-01_JPRB,2.4224E-01_JPRB/)
KBO( :, 2,17, 6) = (/&
&2.3559E-02_JPRB,2.3784E-02_JPRB,1.2023E-01_JPRB,1.8031E-01_JPRB,2.2852E-01_JPRB,2.4805E-01_JPRB/)
KBO( :, 3,17, 6) = (/&
&2.4252E-02_JPRB,2.4462E-02_JPRB,1.2174E-01_JPRB,1.8322E-01_JPRB,2.3188E-01_JPRB,2.5256E-01_JPRB/)
KBO( :, 4,17, 6) = (/&
&2.5160E-02_JPRB,2.5369E-02_JPRB,1.2317E-01_JPRB,1.8595E-01_JPRB,2.3461E-01_JPRB,2.5595E-01_JPRB/)
KBO( :, 5,17, 6) = (/&
&2.6326E-02_JPRB,2.6536E-02_JPRB,1.2445E-01_JPRB,1.8813E-01_JPRB,2.3684E-01_JPRB,2.5843E-01_JPRB/)
KBO( :, 1,18, 6) = (/&
&1.9482E-02_JPRB,1.9716E-02_JPRB,1.0560E-01_JPRB,1.5764E-01_JPRB,1.9885E-01_JPRB,2.1333E-01_JPRB/)
KBO( :, 2,18, 6) = (/&
&2.0020E-02_JPRB,2.0247E-02_JPRB,1.0728E-01_JPRB,1.6080E-01_JPRB,2.0278E-01_JPRB,2.1852E-01_JPRB/)
KBO( :, 3,18, 6) = (/&
&2.0718E-02_JPRB,2.0933E-02_JPRB,1.0881E-01_JPRB,1.6380E-01_JPRB,2.0619E-01_JPRB,2.2252E-01_JPRB/)
KBO( :, 4,18, 6) = (/&
&2.1659E-02_JPRB,2.1872E-02_JPRB,1.1021E-01_JPRB,1.6633E-01_JPRB,2.0912E-01_JPRB,2.2570E-01_JPRB/)
KBO( :, 5,18, 6) = (/&
&2.2723E-02_JPRB,2.2936E-02_JPRB,1.1153E-01_JPRB,1.6848E-01_JPRB,2.1149E-01_JPRB,2.2818E-01_JPRB/)
KBO( :, 1,19, 6) = (/&
&1.6474E-02_JPRB,1.6726E-02_JPRB,9.3278E-02_JPRB,1.3911E-01_JPRB,1.7470E-01_JPRB,1.8607E-01_JPRB/)
KBO( :, 2,19, 6) = (/&
&1.6988E-02_JPRB,1.7224E-02_JPRB,9.4914E-02_JPRB,1.4229E-01_JPRB,1.7855E-01_JPRB,1.9060E-01_JPRB/)
KBO( :, 3,19, 6) = (/&
&1.7719E-02_JPRB,1.7943E-02_JPRB,9.6402E-02_JPRB,1.4506E-01_JPRB,1.8201E-01_JPRB,1.9424E-01_JPRB/)
KBO( :, 4,19, 6) = (/&
&1.8600E-02_JPRB,1.8821E-02_JPRB,9.7809E-02_JPRB,1.4747E-01_JPRB,1.8495E-01_JPRB,1.9716E-01_JPRB/)
KBO( :, 5,19, 6) = (/&
&1.9511E-02_JPRB,1.9731E-02_JPRB,9.9198E-02_JPRB,1.4957E-01_JPRB,1.8726E-01_JPRB,1.9887E-01_JPRB/)
KBO( :, 1,20, 6) = (/&
&1.3891E-02_JPRB,1.4173E-02_JPRB,8.1755E-02_JPRB,1.2196E-01_JPRB,1.5249E-01_JPRB,1.6109E-01_JPRB/)
KBO( :, 2,20, 6) = (/&
&1.4432E-02_JPRB,1.4692E-02_JPRB,8.3314E-02_JPRB,1.2486E-01_JPRB,1.5622E-01_JPRB,1.6508E-01_JPRB/)
KBO( :, 3,20, 6) = (/&
&1.5139E-02_JPRB,1.5385E-02_JPRB,8.4783E-02_JPRB,1.2741E-01_JPRB,1.5952E-01_JPRB,1.6830E-01_JPRB/)
KBO( :, 4,20, 6) = (/&
&1.5913E-02_JPRB,1.6152E-02_JPRB,8.6223E-02_JPRB,1.2966E-01_JPRB,1.6214E-01_JPRB,1.7014E-01_JPRB/)
KBO( :, 5,20, 6) = (/&
&1.6685E-02_JPRB,1.6917E-02_JPRB,8.7642E-02_JPRB,1.3138E-01_JPRB,1.6356E-01_JPRB,1.7014E-01_JPRB/)
KBO( :, 1,21, 6) = (/&
&1.1702E-02_JPRB,1.2032E-02_JPRB,7.1105E-02_JPRB,1.0613E-01_JPRB,1.3235E-01_JPRB,1.3851E-01_JPRB/)
KBO( :, 2,21, 6) = (/&
&1.2249E-02_JPRB,1.2553E-02_JPRB,7.2595E-02_JPRB,1.0875E-01_JPRB,1.3581E-01_JPRB,1.4193E-01_JPRB/)
KBO( :, 3,21, 6) = (/&
&1.2879E-02_JPRB,1.3168E-02_JPRB,7.4032E-02_JPRB,1.1102E-01_JPRB,1.3861E-01_JPRB,1.4396E-01_JPRB/)
KBO( :, 4,21, 6) = (/&
&1.3537E-02_JPRB,1.3810E-02_JPRB,7.5416E-02_JPRB,1.1273E-01_JPRB,1.4012E-01_JPRB,1.4419E-01_JPRB/)
KBO( :, 5,21, 6) = (/&
&1.4190E-02_JPRB,1.4451E-02_JPRB,7.6688E-02_JPRB,1.1355E-01_JPRB,1.4025E-01_JPRB,1.4302E-01_JPRB/)
KBO( :, 1,22, 6) = (/&
&9.9001E-03_JPRB,1.0285E-02_JPRB,6.1552E-02_JPRB,9.1903E-02_JPRB,1.1446E-01_JPRB,1.1850E-01_JPRB/)
KBO( :, 2,22, 6) = (/&
&1.0402E-02_JPRB,1.0764E-02_JPRB,6.2928E-02_JPRB,9.4123E-02_JPRB,1.1729E-01_JPRB,1.2066E-01_JPRB/)
KBO( :, 3,22, 6) = (/&
&1.0945E-02_JPRB,1.1287E-02_JPRB,6.4219E-02_JPRB,9.5745E-02_JPRB,1.1884E-01_JPRB,1.2116E-01_JPRB/)
KBO( :, 4,22, 6) = (/&
&1.1502E-02_JPRB,1.1824E-02_JPRB,6.5352E-02_JPRB,9.6543E-02_JPRB,1.1912E-01_JPRB,1.2043E-01_JPRB/)
KBO( :, 5,22, 6) = (/&
&1.2057E-02_JPRB,1.2365E-02_JPRB,6.6306E-02_JPRB,9.6694E-02_JPRB,1.1850E-01_JPRB,1.1887E-01_JPRB/)
KBO( :, 1,23, 6) = (/&
&8.3712E-03_JPRB,8.8014E-03_JPRB,5.2987E-02_JPRB,7.9036E-02_JPRB,9.8229E-02_JPRB,1.0022E-01_JPRB/)
KBO( :, 2,23, 6) = (/&
&8.8086E-03_JPRB,9.2239E-03_JPRB,5.4159E-02_JPRB,8.0566E-02_JPRB,9.9889E-02_JPRB,1.0104E-01_JPRB/)
KBO( :, 3,23, 6) = (/&
&9.2697E-03_JPRB,9.6659E-03_JPRB,5.5152E-02_JPRB,8.1379E-02_JPRB,1.0039E-01_JPRB,1.0074E-01_JPRB/)
KBO( :, 4,23, 6) = (/&
&9.7327E-03_JPRB,1.0110E-02_JPRB,5.5972E-02_JPRB,8.1635E-02_JPRB,1.0009E-01_JPRB,9.9702E-02_JPRB/)
KBO( :, 5,23, 6) = (/&
&1.0213E-02_JPRB,1.0575E-02_JPRB,5.6627E-02_JPRB,8.1638E-02_JPRB,9.9238E-02_JPRB,9.8092E-02_JPRB/)
KBO( :, 1,24, 6) = (/&
&7.0727E-03_JPRB,7.5361E-03_JPRB,4.5321E-02_JPRB,6.7260E-02_JPRB,8.3279E-02_JPRB,8.3647E-02_JPRB/)
KBO( :, 2,24, 6) = (/&
&7.4427E-03_JPRB,7.8986E-03_JPRB,4.6188E-02_JPRB,6.8096E-02_JPRB,8.4019E-02_JPRB,8.3747E-02_JPRB/)
KBO( :, 3,24, 6) = (/&
&7.8269E-03_JPRB,8.2674E-03_JPRB,4.6892E-02_JPRB,6.8450E-02_JPRB,8.4013E-02_JPRB,8.3148E-02_JPRB/)
KBO( :, 4,24, 6) = (/&
&8.2189E-03_JPRB,8.6445E-03_JPRB,4.7510E-02_JPRB,6.8583E-02_JPRB,8.3512E-02_JPRB,8.2039E-02_JPRB/)
KBO( :, 5,24, 6) = (/&
&8.6506E-03_JPRB,9.0639E-03_JPRB,4.7979E-02_JPRB,6.8589E-02_JPRB,8.2686E-02_JPRB,8.0530E-02_JPRB/)
KBO( :, 1,25, 6) = (/&
&5.9648E-03_JPRB,6.4506E-03_JPRB,3.8407E-02_JPRB,5.6605E-02_JPRB,6.9840E-02_JPRB,6.9218E-02_JPRB/)
KBO( :, 2,25, 6) = (/&
&6.2753E-03_JPRB,6.7567E-03_JPRB,3.9061E-02_JPRB,5.7057E-02_JPRB,7.0098E-02_JPRB,6.9005E-02_JPRB/)
KBO( :, 3,25, 6) = (/&
&6.5979E-03_JPRB,7.0692E-03_JPRB,3.9618E-02_JPRB,5.7283E-02_JPRB,6.9890E-02_JPRB,6.8312E-02_JPRB/)
KBO( :, 4,25, 6) = (/&
&6.9472E-03_JPRB,7.4089E-03_JPRB,4.0072E-02_JPRB,5.7410E-02_JPRB,6.9371E-02_JPRB,6.7241E-02_JPRB/)
KBO( :, 5,25, 6) = (/&
&7.3458E-03_JPRB,7.7968E-03_JPRB,4.0424E-02_JPRB,5.7407E-02_JPRB,6.8690E-02_JPRB,6.5883E-02_JPRB/)
KBO( :, 1,26, 6) = (/&
&5.0276E-03_JPRB,5.5197E-03_JPRB,3.2341E-02_JPRB,4.7306E-02_JPRB,5.8159E-02_JPRB,5.6987E-02_JPRB/)
KBO( :, 2,26, 6) = (/&
&5.2905E-03_JPRB,5.7808E-03_JPRB,3.2856E-02_JPRB,4.7610E-02_JPRB,5.8188E-02_JPRB,5.6640E-02_JPRB/)
KBO( :, 3,26, 6) = (/&
&5.5724E-03_JPRB,6.0595E-03_JPRB,3.3306E-02_JPRB,4.7831E-02_JPRB,5.7928E-02_JPRB,5.5939E-02_JPRB/)
KBO( :, 4,26, 6) = (/&
&5.8946E-03_JPRB,6.3770E-03_JPRB,3.3653E-02_JPRB,4.7935E-02_JPRB,5.7502E-02_JPRB,5.4956E-02_JPRB/)
KBO( :, 5,26, 6) = (/&
&6.2574E-03_JPRB,6.7355E-03_JPRB,3.3928E-02_JPRB,4.7887E-02_JPRB,5.6970E-02_JPRB,5.3762E-02_JPRB/)
KBO( :, 1,27, 6) = (/&
&4.2349E-03_JPRB,4.7179E-03_JPRB,2.7116E-02_JPRB,3.9401E-02_JPRB,4.8220E-02_JPRB,4.6782E-02_JPRB/)
KBO( :, 2,27, 6) = (/&
&4.4634E-03_JPRB,4.9470E-03_JPRB,2.7543E-02_JPRB,3.9674E-02_JPRB,4.8162E-02_JPRB,4.6385E-02_JPRB/)
KBO( :, 3,27, 6) = (/&
&4.7202E-03_JPRB,5.2071E-03_JPRB,2.7886E-02_JPRB,3.9869E-02_JPRB,4.7941E-02_JPRB,4.5722E-02_JPRB/)
KBO( :, 4,27, 6) = (/&
&5.0160E-03_JPRB,5.5039E-03_JPRB,2.8167E-02_JPRB,3.9934E-02_JPRB,4.7615E-02_JPRB,4.4846E-02_JPRB/)
KBO( :, 5,27, 6) = (/&
&5.3481E-03_JPRB,5.8380E-03_JPRB,2.8394E-02_JPRB,3.9860E-02_JPRB,4.7184E-02_JPRB,4.3824E-02_JPRB/)
KBO( :, 1,28, 6) = (/&
&3.5674E-03_JPRB,4.0284E-03_JPRB,2.2673E-02_JPRB,3.2772E-02_JPRB,3.9872E-02_JPRB,3.8332E-02_JPRB/)
KBO( :, 2,28, 6) = (/&
&3.7734E-03_JPRB,4.2398E-03_JPRB,2.3008E-02_JPRB,3.3028E-02_JPRB,3.9810E-02_JPRB,3.7930E-02_JPRB/)
KBO( :, 3,28, 6) = (/&
&4.0097E-03_JPRB,4.4845E-03_JPRB,2.3286E-02_JPRB,3.3175E-02_JPRB,3.9654E-02_JPRB,3.7324E-02_JPRB/)
KBO( :, 4,28, 6) = (/&
&4.2788E-03_JPRB,4.7627E-03_JPRB,2.3514E-02_JPRB,3.3194E-02_JPRB,3.9398E-02_JPRB,3.6571E-02_JPRB/)
KBO( :, 5,28, 6) = (/&
&4.5757E-03_JPRB,5.0676E-03_JPRB,2.3719E-02_JPRB,3.3118E-02_JPRB,3.9020E-02_JPRB,3.5708E-02_JPRB/)
KBO( :, 1,29, 6) = (/&
&3.0115E-03_JPRB,3.4411E-03_JPRB,1.8911E-02_JPRB,2.7247E-02_JPRB,3.2943E-02_JPRB,3.1382E-02_JPRB/)
KBO( :, 2,29, 6) = (/&
&3.1994E-03_JPRB,3.6407E-03_JPRB,1.9179E-02_JPRB,2.7455E-02_JPRB,3.2911E-02_JPRB,3.1000E-02_JPRB/)
KBO( :, 3,29, 6) = (/&
&3.4147E-03_JPRB,3.8682E-03_JPRB,1.9409E-02_JPRB,2.7552E-02_JPRB,3.2798E-02_JPRB,3.0472E-02_JPRB/)
KBO( :, 4,29, 6) = (/&
&3.6579E-03_JPRB,4.1270E-03_JPRB,1.9605E-02_JPRB,2.7559E-02_JPRB,3.2573E-02_JPRB,2.9835E-02_JPRB/)
KBO( :, 5,29, 6) = (/&
&3.9162E-03_JPRB,4.3987E-03_JPRB,1.9809E-02_JPRB,2.7488E-02_JPRB,3.2240E-02_JPRB,2.9120E-02_JPRB/)
KBO( :, 1,30, 6) = (/&
&2.5481E-03_JPRB,2.9444E-03_JPRB,1.5745E-02_JPRB,2.2634E-02_JPRB,2.7226E-02_JPRB,2.5677E-02_JPRB/)
KBO( :, 2,30, 6) = (/&
&2.7188E-03_JPRB,3.1307E-03_JPRB,1.5966E-02_JPRB,2.2786E-02_JPRB,2.7220E-02_JPRB,2.5335E-02_JPRB/)
KBO( :, 3,30, 6) = (/&
&2.9148E-03_JPRB,3.3439E-03_JPRB,1.6160E-02_JPRB,2.2855E-02_JPRB,2.7119E-02_JPRB,2.4882E-02_JPRB/)
KBO( :, 4,30, 6) = (/&
&3.1280E-03_JPRB,3.5773E-03_JPRB,1.6348E-02_JPRB,2.2854E-02_JPRB,2.6917E-02_JPRB,2.4354E-02_JPRB/)
KBO( :, 5,30, 6) = (/&
&3.3553E-03_JPRB,3.8202E-03_JPRB,1.6558E-02_JPRB,2.2811E-02_JPRB,2.6630E-02_JPRB,2.3768E-02_JPRB/)
KBO( :, 1,31, 6) = (/&
&2.1615E-03_JPRB,2.5257E-03_JPRB,1.3098E-02_JPRB,1.8778E-02_JPRB,2.2519E-02_JPRB,2.1018E-02_JPRB/)
KBO( :, 2,31, 6) = (/&
&2.3170E-03_JPRB,2.6986E-03_JPRB,1.3284E-02_JPRB,1.8891E-02_JPRB,2.2515E-02_JPRB,2.0722E-02_JPRB/)
KBO( :, 3,31, 6) = (/&
&2.4905E-03_JPRB,2.8953E-03_JPRB,1.3459E-02_JPRB,1.8946E-02_JPRB,2.2414E-02_JPRB,2.0345E-02_JPRB/)
KBO( :, 4,31, 6) = (/&
&2.6777E-03_JPRB,3.1024E-03_JPRB,1.3649E-02_JPRB,1.8949E-02_JPRB,2.2235E-02_JPRB,1.9908E-02_JPRB/)
KBO( :, 5,31, 6) = (/&
&2.8803E-03_JPRB,3.3243E-03_JPRB,1.3860E-02_JPRB,1.8946E-02_JPRB,2.1996E-02_JPRB,1.9437E-02_JPRB/)
KBO( :, 1,32, 6) = (/&
&1.8385E-03_JPRB,2.1718E-03_JPRB,1.0896E-02_JPRB,1.5564E-02_JPRB,1.8628E-02_JPRB,1.7209E-02_JPRB/)
KBO( :, 2,32, 6) = (/&
&1.9787E-03_JPRB,2.3333E-03_JPRB,1.1058E-02_JPRB,1.5657E-02_JPRB,1.8613E-02_JPRB,1.6956E-02_JPRB/)
KBO( :, 3,32, 6) = (/&
&2.1311E-03_JPRB,2.5090E-03_JPRB,1.1225E-02_JPRB,1.5701E-02_JPRB,1.8522E-02_JPRB,1.6642E-02_JPRB/)
KBO( :, 4,32, 6) = (/&
&2.2971E-03_JPRB,2.6964E-03_JPRB,1.1416E-02_JPRB,1.5725E-02_JPRB,1.8369E-02_JPRB,1.6291E-02_JPRB/)
KBO( :, 5,32, 6) = (/&
&2.4814E-03_JPRB,2.9021E-03_JPRB,1.1629E-02_JPRB,1.5757E-02_JPRB,1.8177E-02_JPRB,1.5913E-02_JPRB/)
KBO( :, 1,33, 6) = (/&
&1.5686E-03_JPRB,1.8737E-03_JPRB,9.0681E-03_JPRB,1.2902E-02_JPRB,1.5408E-02_JPRB,1.4096E-02_JPRB/)
KBO( :, 2,33, 6) = (/&
&1.6920E-03_JPRB,2.0214E-03_JPRB,9.2168E-03_JPRB,1.2976E-02_JPRB,1.5384E-02_JPRB,1.3883E-02_JPRB/)
KBO( :, 3,33, 6) = (/&
&1.8273E-03_JPRB,2.1791E-03_JPRB,9.3843E-03_JPRB,1.3022E-02_JPRB,1.5304E-02_JPRB,1.3632E-02_JPRB/)
KBO( :, 4,33, 6) = (/&
&1.9765E-03_JPRB,2.3516E-03_JPRB,9.5730E-03_JPRB,1.3071E-02_JPRB,1.5178E-02_JPRB,1.3350E-02_JPRB/)
KBO( :, 5,33, 6) = (/&
&2.1452E-03_JPRB,2.5432E-03_JPRB,9.7830E-03_JPRB,1.3131E-02_JPRB,1.5037E-02_JPRB,1.3045E-02_JPRB/)
KBO( :, 1,34, 6) = (/&
&1.3372E-03_JPRB,1.6178E-03_JPRB,7.5519E-03_JPRB,1.0693E-02_JPRB,1.2740E-02_JPRB,1.1549E-02_JPRB/)
KBO( :, 2,34, 6) = (/&
&1.4461E-03_JPRB,1.7503E-03_JPRB,7.6945E-03_JPRB,1.0757E-02_JPRB,1.2715E-02_JPRB,1.1377E-02_JPRB/)
KBO( :, 3,34, 6) = (/&
&1.5660E-03_JPRB,1.8937E-03_JPRB,7.8583E-03_JPRB,1.0816E-02_JPRB,1.2648E-02_JPRB,1.1176E-02_JPRB/)
KBO( :, 4,34, 6) = (/&
&1.7014E-03_JPRB,2.0534E-03_JPRB,8.0448E-03_JPRB,1.0884E-02_JPRB,1.2559E-02_JPRB,1.0950E-02_JPRB/)
KBO( :, 5,34, 6) = (/&
&1.8558E-03_JPRB,2.2315E-03_JPRB,8.2423E-03_JPRB,1.0963E-02_JPRB,1.2464E-02_JPRB,1.0705E-02_JPRB/)
KBO( :, 1,35, 6) = (/&
&1.1329E-03_JPRB,1.3895E-03_JPRB,6.2880E-03_JPRB,8.8610E-03_JPRB,1.0532E-02_JPRB,9.4809E-03_JPRB/)
KBO( :, 2,35, 6) = (/&
&1.2284E-03_JPRB,1.5079E-03_JPRB,6.4262E-03_JPRB,8.9261E-03_JPRB,1.0516E-02_JPRB,9.3462E-03_JPRB/)
KBO( :, 3,35, 6) = (/&
&1.3351E-03_JPRB,1.6386E-03_JPRB,6.5845E-03_JPRB,8.9958E-03_JPRB,1.0468E-02_JPRB,9.1865E-03_JPRB/)
KBO( :, 4,35, 6) = (/&
&1.4573E-03_JPRB,1.7849E-03_JPRB,6.7614E-03_JPRB,9.0760E-03_JPRB,1.0410E-02_JPRB,9.0064E-03_JPRB/)
KBO( :, 5,35, 6) = (/&
&1.5970E-03_JPRB,1.9487E-03_JPRB,6.9420E-03_JPRB,9.1662E-03_JPRB,1.0351E-02_JPRB,8.8117E-03_JPRB/)
KBO( :, 1,36, 6) = (/&
&9.5211E-04_JPRB,1.1843E-03_JPRB,5.2312E-03_JPRB,7.3412E-03_JPRB,8.7087E-03_JPRB,7.7981E-03_JPRB/)
KBO( :, 2,36, 6) = (/&
&1.0354E-03_JPRB,1.2901E-03_JPRB,5.3625E-03_JPRB,7.4088E-03_JPRB,8.7005E-03_JPRB,7.6928E-03_JPRB/)
KBO( :, 3,36, 6) = (/&
&1.1296E-03_JPRB,1.4079E-03_JPRB,5.5138E-03_JPRB,7.4862E-03_JPRB,8.6732E-03_JPRB,7.5689E-03_JPRB/)
KBO( :, 4,36, 6) = (/&
&1.2388E-03_JPRB,1.5409E-03_JPRB,5.6750E-03_JPRB,7.5726E-03_JPRB,8.6424E-03_JPRB,7.4262E-03_JPRB/)
KBO( :, 5,36, 6) = (/&
&1.3638E-03_JPRB,1.6902E-03_JPRB,5.8416E-03_JPRB,7.6677E-03_JPRB,8.6124E-03_JPRB,7.2708E-03_JPRB/)
KBO( :, 1,37, 6) = (/&
&7.9067E-04_JPRB,9.9728E-04_JPRB,4.3412E-03_JPRB,6.0781E-03_JPRB,7.2010E-03_JPRB,6.4225E-03_JPRB/)
KBO( :, 2,37, 6) = (/&
&8.6207E-04_JPRB,1.0903E-03_JPRB,4.4618E-03_JPRB,6.1477E-03_JPRB,7.2040E-03_JPRB,6.3450E-03_JPRB/)
KBO( :, 3,37, 6) = (/&
&9.4365E-04_JPRB,1.1951E-03_JPRB,4.6016E-03_JPRB,6.2259E-03_JPRB,7.1949E-03_JPRB,6.2491E-03_JPRB/)
KBO( :, 4,37, 6) = (/&
&1.0390E-03_JPRB,1.3137E-03_JPRB,4.7474E-03_JPRB,6.3134E-03_JPRB,7.1835E-03_JPRB,6.1371E-03_JPRB/)
KBO( :, 5,37, 6) = (/&
&1.1493E-03_JPRB,1.4482E-03_JPRB,4.9008E-03_JPRB,6.4092E-03_JPRB,7.1759E-03_JPRB,6.0153E-03_JPRB/)
KBO( :, 1,38, 6) = (/&
&6.5574E-04_JPRB,8.3902E-04_JPRB,3.6029E-03_JPRB,5.0338E-03_JPRB,5.9535E-03_JPRB,5.2931E-03_JPRB/)
KBO( :, 2,38, 6) = (/&
&7.1723E-04_JPRB,9.2092E-04_JPRB,3.7143E-03_JPRB,5.1033E-03_JPRB,5.9664E-03_JPRB,5.2356E-03_JPRB/)
KBO( :, 3,38, 6) = (/&
&7.8817E-04_JPRB,1.0140E-03_JPRB,3.8410E-03_JPRB,5.1788E-03_JPRB,5.9694E-03_JPRB,5.1631E-03_JPRB/)
KBO( :, 4,38, 6) = (/&
&8.7142E-04_JPRB,1.1199E-03_JPRB,3.9722E-03_JPRB,5.2685E-03_JPRB,5.9738E-03_JPRB,5.0758E-03_JPRB/)
KBO( :, 5,38, 6) = (/&
&9.6814E-04_JPRB,1.2406E-03_JPRB,4.1130E-03_JPRB,5.3594E-03_JPRB,5.9796E-03_JPRB,4.9809E-03_JPRB/)
KBO( :, 1,39, 6) = (/&
&5.4394E-04_JPRB,7.0587E-04_JPRB,2.9920E-03_JPRB,4.1712E-03_JPRB,4.9241E-03_JPRB,4.3648E-03_JPRB/)
KBO( :, 2,39, 6) = (/&
&5.9679E-04_JPRB,7.7794E-04_JPRB,3.0938E-03_JPRB,4.2387E-03_JPRB,4.9429E-03_JPRB,4.3244E-03_JPRB/)
KBO( :, 3,39, 6) = (/&
&6.5862E-04_JPRB,8.6057E-04_JPRB,3.2080E-03_JPRB,4.3149E-03_JPRB,4.9560E-03_JPRB,4.2705E-03_JPRB/)
KBO( :, 4,39, 6) = (/&
&7.3136E-04_JPRB,9.5521E-04_JPRB,3.3261E-03_JPRB,4.3998E-03_JPRB,4.9704E-03_JPRB,4.2037E-03_JPRB/)
KBO( :, 5,39, 6) = (/&
&8.1646E-04_JPRB,1.0637E-03_JPRB,3.4565E-03_JPRB,4.4868E-03_JPRB,4.9875E-03_JPRB,4.1313E-03_JPRB/)
KBO( :, 1,40, 6) = (/&
&4.4679E-04_JPRB,5.8745E-04_JPRB,2.4763E-03_JPRB,3.4505E-03_JPRB,4.0708E-03_JPRB,3.5945E-03_JPRB/)
KBO( :, 2,40, 6) = (/&
&4.9169E-04_JPRB,6.5005E-04_JPRB,2.5677E-03_JPRB,3.5152E-03_JPRB,4.0943E-03_JPRB,3.5667E-03_JPRB/)
KBO( :, 3,40, 6) = (/&
&5.4450E-04_JPRB,7.2222E-04_JPRB,2.6693E-03_JPRB,3.5873E-03_JPRB,4.1135E-03_JPRB,3.5266E-03_JPRB/)
KBO( :, 4,40, 6) = (/&
&6.0712E-04_JPRB,8.0578E-04_JPRB,2.7753E-03_JPRB,3.6696E-03_JPRB,4.1353E-03_JPRB,3.4759E-03_JPRB/)
KBO( :, 5,40, 6) = (/&
&6.8061E-04_JPRB,9.0198E-04_JPRB,2.8937E-03_JPRB,3.7510E-03_JPRB,4.1595E-03_JPRB,3.4202E-03_JPRB/)
KBO( :, 1,41, 6) = (/&
&3.6654E-04_JPRB,4.8763E-04_JPRB,2.0497E-03_JPRB,2.8544E-03_JPRB,3.3652E-03_JPRB,2.9593E-03_JPRB/)
KBO( :, 2,41, 6) = (/&
&4.0436E-04_JPRB,5.4168E-04_JPRB,2.1297E-03_JPRB,2.9143E-03_JPRB,3.3913E-03_JPRB,2.9409E-03_JPRB/)
KBO( :, 3,41, 6) = (/&
&4.4941E-04_JPRB,6.0442E-04_JPRB,2.2197E-03_JPRB,2.9825E-03_JPRB,3.4145E-03_JPRB,2.9122E-03_JPRB/)
KBO( :, 4,41, 6) = (/&
&5.0288E-04_JPRB,6.7766E-04_JPRB,2.3143E-03_JPRB,3.0596E-03_JPRB,3.4407E-03_JPRB,2.8738E-03_JPRB/)
KBO( :, 5,41, 6) = (/&
&5.6627E-04_JPRB,7.6296E-04_JPRB,2.4209E-03_JPRB,3.1354E-03_JPRB,3.4693E-03_JPRB,2.8312E-03_JPRB/)
KBO( :, 1,42, 6) = (/&
&3.0056E-04_JPRB,4.0423E-04_JPRB,1.6955E-03_JPRB,2.3604E-03_JPRB,2.7815E-03_JPRB,2.4359E-03_JPRB/)
KBO( :, 2,42, 6) = (/&
&3.3240E-04_JPRB,4.5078E-04_JPRB,1.7662E-03_JPRB,2.4162E-03_JPRB,2.8087E-03_JPRB,2.4250E-03_JPRB/)
KBO( :, 3,42, 6) = (/&
&3.7060E-04_JPRB,5.0501E-04_JPRB,1.8455E-03_JPRB,2.4795E-03_JPRB,2.8342E-03_JPRB,2.4047E-03_JPRB/)
KBO( :, 4,42, 6) = (/&
&4.1638E-04_JPRB,5.6912E-04_JPRB,1.9299E-03_JPRB,2.5508E-03_JPRB,2.8626E-03_JPRB,2.3765E-03_JPRB/)
KBO( :, 5,42, 6) = (/&
&4.7089E-04_JPRB,6.4463E-04_JPRB,2.0249E-03_JPRB,2.6208E-03_JPRB,2.8943E-03_JPRB,2.3447E-03_JPRB/)
KBO( :, 1,43, 6) = (/&
&2.4502E-04_JPRB,3.3261E-04_JPRB,1.3991E-03_JPRB,1.9481E-03_JPRB,2.2961E-03_JPRB,2.0045E-03_JPRB/)
KBO( :, 2,43, 6) = (/&
&2.7152E-04_JPRB,3.7212E-04_JPRB,1.4606E-03_JPRB,1.9988E-03_JPRB,2.3241E-03_JPRB,1.9999E-03_JPRB/)
KBO( :, 3,43, 6) = (/&
&3.0343E-04_JPRB,4.1851E-04_JPRB,1.5301E-03_JPRB,2.0581E-03_JPRB,2.3515E-03_JPRB,1.9867E-03_JPRB/)
KBO( :, 4,43, 6) = (/&
&3.4217E-04_JPRB,4.7384E-04_JPRB,1.6047E-03_JPRB,2.1225E-03_JPRB,2.3804E-03_JPRB,1.9662E-03_JPRB/)
KBO( :, 5,43, 6) = (/&
&3.8865E-04_JPRB,5.3980E-04_JPRB,1.6888E-03_JPRB,2.1871E-03_JPRB,2.4134E-03_JPRB,1.9423E-03_JPRB/)
KBO( :, 1,44, 6) = (/&
&1.9915E-04_JPRB,2.7249E-04_JPRB,1.1527E-03_JPRB,1.6068E-03_JPRB,1.8949E-03_JPRB,1.6492E-03_JPRB/)
KBO( :, 2,44, 6) = (/&
&2.2104E-04_JPRB,3.0586E-04_JPRB,1.2059E-03_JPRB,1.6524E-03_JPRB,1.9220E-03_JPRB,1.6487E-03_JPRB/)
KBO( :, 3,44, 6) = (/&
&2.4764E-04_JPRB,3.4529E-04_JPRB,1.2668E-03_JPRB,1.7051E-03_JPRB,1.9490E-03_JPRB,1.6410E-03_JPRB/)
KBO( :, 4,44, 6) = (/&
&2.8005E-04_JPRB,3.9253E-04_JPRB,1.3322E-03_JPRB,1.7635E-03_JPRB,1.9786E-03_JPRB,1.6274E-03_JPRB/)
KBO( :, 5,44, 6) = (/&
&3.1937E-04_JPRB,4.4948E-04_JPRB,1.4058E-03_JPRB,1.8224E-03_JPRB,2.0114E-03_JPRB,1.6103E-03_JPRB/)
KBO( :, 1,45, 6) = (/&
&1.6169E-04_JPRB,2.2287E-04_JPRB,9.4886E-04_JPRB,1.3244E-03_JPRB,1.5624E-03_JPRB,1.3564E-03_JPRB/)
KBO( :, 2,45, 6) = (/&
&1.7988E-04_JPRB,2.5107E-04_JPRB,9.9462E-04_JPRB,1.3650E-03_JPRB,1.5885E-03_JPRB,1.3595E-03_JPRB/)
KBO( :, 3,45, 6) = (/&
&2.0188E-04_JPRB,2.8430E-04_JPRB,1.0481E-03_JPRB,1.4121E-03_JPRB,1.6151E-03_JPRB,1.3561E-03_JPRB/)
KBO( :, 4,45, 6) = (/&
&2.2901E-04_JPRB,3.2458E-04_JPRB,1.1056E-03_JPRB,1.4643E-03_JPRB,1.6434E-03_JPRB,1.3471E-03_JPRB/)
KBO( :, 5,45, 6) = (/&
&2.6215E-04_JPRB,3.7359E-04_JPRB,1.1700E-03_JPRB,1.5178E-03_JPRB,1.6750E-03_JPRB,1.3351E-03_JPRB/)
KBO( :, 1,46, 6) = (/&
&1.3087E-04_JPRB,1.8153E-04_JPRB,7.8014E-04_JPRB,1.0903E-03_JPRB,1.2862E-03_JPRB,1.1149E-03_JPRB/)
KBO( :, 2,46, 6) = (/&
&1.4588E-04_JPRB,2.0523E-04_JPRB,8.1887E-04_JPRB,1.1260E-03_JPRB,1.3113E-03_JPRB,1.1201E-03_JPRB/)
KBO( :, 3,46, 6) = (/&
&1.6401E-04_JPRB,2.3309E-04_JPRB,8.6531E-04_JPRB,1.1670E-03_JPRB,1.3362E-03_JPRB,1.1199E-03_JPRB/)
KBO( :, 4,46, 6) = (/&
&1.8657E-04_JPRB,2.6716E-04_JPRB,9.1576E-04_JPRB,1.2141E-03_JPRB,1.3636E-03_JPRB,1.1150E-03_JPRB/)
KBO( :, 5,46, 6) = (/&
&2.1433E-04_JPRB,3.0901E-04_JPRB,9.7156E-04_JPRB,1.2621E-03_JPRB,1.3940E-03_JPRB,1.1075E-03_JPRB/)
KBO( :, 1,47, 6) = (/&
&1.0532E-04_JPRB,1.4678E-04_JPRB,6.3931E-04_JPRB,8.9566E-04_JPRB,1.0570E-03_JPRB,9.1457E-04_JPRB/)
KBO( :, 2,47, 6) = (/&
&1.1765E-04_JPRB,1.6658E-04_JPRB,6.7225E-04_JPRB,9.2702E-04_JPRB,1.0808E-03_JPRB,9.2153E-04_JPRB/)
KBO( :, 3,47, 6) = (/&
&1.3241E-04_JPRB,1.8980E-04_JPRB,7.1202E-04_JPRB,9.6250E-04_JPRB,1.1041E-03_JPRB,9.2404E-04_JPRB/)
KBO( :, 4,47, 6) = (/&
&1.5090E-04_JPRB,2.1814E-04_JPRB,7.5592E-04_JPRB,1.0038E-03_JPRB,1.1296E-03_JPRB,9.2224E-04_JPRB/)
KBO( :, 5,47, 6) = (/&
&1.7385E-04_JPRB,2.5344E-04_JPRB,8.0420E-04_JPRB,1.0471E-03_JPRB,1.1580E-03_JPRB,9.1765E-04_JPRB/)
KBO( :, 1,48, 6) = (/&
&8.4617E-05_JPRB,1.1838E-04_JPRB,5.2334E-04_JPRB,7.3546E-04_JPRB,8.6835E-04_JPRB,7.5017E-04_JPRB/)
KBO( :, 2,48, 6) = (/&
&9.4785E-05_JPRB,1.3495E-04_JPRB,5.5091E-04_JPRB,7.6251E-04_JPRB,8.9031E-04_JPRB,7.5816E-04_JPRB/)
KBO( :, 3,48, 6) = (/&
&1.0679E-04_JPRB,1.5426E-04_JPRB,5.8488E-04_JPRB,7.9332E-04_JPRB,9.1168E-04_JPRB,7.6245E-04_JPRB/)
KBO( :, 4,48, 6) = (/&
&1.2188E-04_JPRB,1.7784E-04_JPRB,6.2314E-04_JPRB,8.2922E-04_JPRB,9.3479E-04_JPRB,7.6276E-04_JPRB/)
KBO( :, 5,48, 6) = (/&
&1.4083E-04_JPRB,2.0741E-04_JPRB,6.6491E-04_JPRB,8.6778E-04_JPRB,9.6073E-04_JPRB,7.6049E-04_JPRB/)
KBO( :, 1,49, 6) = (/&
&6.7867E-05_JPRB,9.5270E-05_JPRB,4.2786E-04_JPRB,6.0311E-04_JPRB,7.1217E-04_JPRB,6.1511E-04_JPRB/)
KBO( :, 2,49, 6) = (/&
&7.6245E-05_JPRB,1.0908E-04_JPRB,4.5097E-04_JPRB,6.2662E-04_JPRB,7.3243E-04_JPRB,6.2369E-04_JPRB/)
KBO( :, 3,49, 6) = (/&
&8.6029E-05_JPRB,1.2515E-04_JPRB,4.7966E-04_JPRB,6.5287E-04_JPRB,7.5158E-04_JPRB,6.2923E-04_JPRB/)
KBO( :, 4,49, 6) = (/&
&9.8304E-05_JPRB,1.4466E-04_JPRB,5.1259E-04_JPRB,6.8383E-04_JPRB,7.7254E-04_JPRB,6.3132E-04_JPRB/)
KBO( :, 5,49, 6) = (/&
&1.1386E-04_JPRB,1.6934E-04_JPRB,5.4863E-04_JPRB,7.1799E-04_JPRB,7.9596E-04_JPRB,6.3100E-04_JPRB/)
KBO( :, 1,50, 6) = (/&
&5.4470E-05_JPRB,7.6746E-05_JPRB,3.4976E-04_JPRB,4.9428E-04_JPRB,5.8397E-04_JPRB,5.0306E-04_JPRB/)
KBO( :, 2,50, 6) = (/&
&6.1410E-05_JPRB,8.8237E-05_JPRB,3.6915E-04_JPRB,5.1456E-04_JPRB,6.0217E-04_JPRB,5.1154E-04_JPRB/)
KBO( :, 3,50, 6) = (/&
&6.9439E-05_JPRB,1.0166E-04_JPRB,3.9314E-04_JPRB,5.3721E-04_JPRB,6.1939E-04_JPRB,5.1755E-04_JPRB/)
KBO( :, 4,50, 6) = (/&
&7.9454E-05_JPRB,1.1792E-04_JPRB,4.2160E-04_JPRB,5.6412E-04_JPRB,6.3835E-04_JPRB,5.2074E-04_JPRB/)
KBO( :, 5,50, 6) = (/&
&9.2275E-05_JPRB,1.3855E-04_JPRB,4.5301E-04_JPRB,5.9448E-04_JPRB,6.5950E-04_JPRB,5.2175E-04_JPRB/)
KBO( :, 1,51, 6) = (/&
&4.3722E-05_JPRB,6.1806E-05_JPRB,2.8578E-04_JPRB,4.0468E-04_JPRB,4.7855E-04_JPRB,4.1074E-04_JPRB/)
KBO( :, 2,51, 6) = (/&
&4.9457E-05_JPRB,7.1342E-05_JPRB,3.0211E-04_JPRB,4.2230E-04_JPRB,4.9488E-04_JPRB,4.1886E-04_JPRB/)
KBO( :, 3,51, 6) = (/&
&5.6064E-05_JPRB,8.2554E-05_JPRB,3.2225E-04_JPRB,4.4204E-04_JPRB,5.1049E-04_JPRB,4.2506E-04_JPRB/)
KBO( :, 4,51, 6) = (/&
&6.4238E-05_JPRB,9.6120E-05_JPRB,3.4672E-04_JPRB,4.6528E-04_JPRB,5.2743E-04_JPRB,4.2888E-04_JPRB/)
KBO( :, 5,51, 6) = (/&
&7.4796E-05_JPRB,1.1334E-04_JPRB,3.7378E-04_JPRB,4.9196E-04_JPRB,5.4618E-04_JPRB,4.3057E-04_JPRB/)
KBO( :, 1,52, 6) = (/&
&3.5070E-05_JPRB,4.9691E-05_JPRB,2.3330E-04_JPRB,3.3093E-04_JPRB,3.9172E-04_JPRB,3.3527E-04_JPRB/)
KBO( :, 2,52, 6) = (/&
&3.9769E-05_JPRB,5.7541E-05_JPRB,2.4706E-04_JPRB,3.4637E-04_JPRB,4.0670E-04_JPRB,3.4297E-04_JPRB/)
KBO( :, 3,52, 6) = (/&
&4.5223E-05_JPRB,6.6916E-05_JPRB,2.6381E-04_JPRB,3.6327E-04_JPRB,4.2045E-04_JPRB,3.4912E-04_JPRB/)
KBO( :, 4,52, 6) = (/&
&5.1871E-05_JPRB,7.8200E-05_JPRB,2.8472E-04_JPRB,3.8310E-04_JPRB,4.3533E-04_JPRB,3.5324E-04_JPRB/)
KBO( :, 5,52, 6) = (/&
&6.0522E-05_JPRB,9.2554E-05_JPRB,3.0796E-04_JPRB,4.0644E-04_JPRB,4.5190E-04_JPRB,3.5548E-04_JPRB/)
KBO( :, 1,53, 6) = (/&
&2.8114E-05_JPRB,3.9895E-05_JPRB,1.9033E-04_JPRB,2.7035E-04_JPRB,3.2027E-04_JPRB,2.7374E-04_JPRB/)
KBO( :, 2,53, 6) = (/&
&3.1912E-05_JPRB,4.6272E-05_JPRB,2.0180E-04_JPRB,2.8364E-04_JPRB,3.3368E-04_JPRB,2.8088E-04_JPRB/)
KBO( :, 3,53, 6) = (/&
&3.6415E-05_JPRB,5.4088E-05_JPRB,2.1570E-04_JPRB,2.9812E-04_JPRB,3.4609E-04_JPRB,2.8682E-04_JPRB/)
KBO( :, 4,53, 6) = (/&
&4.1826E-05_JPRB,6.3486E-05_JPRB,2.3334E-04_JPRB,3.1498E-04_JPRB,3.5898E-04_JPRB,2.9120E-04_JPRB/)
KBO( :, 5,53, 6) = (/&
&4.8885E-05_JPRB,7.5408E-05_JPRB,2.5337E-04_JPRB,3.3531E-04_JPRB,3.7352E-04_JPRB,2.9386E-04_JPRB/)
KBO( :, 1,54, 6) = (/&
&2.2610E-05_JPRB,3.2120E-05_JPRB,1.5540E-04_JPRB,2.2090E-04_JPRB,2.6189E-04_JPRB,2.2252E-04_JPRB/)
KBO( :, 2,54, 6) = (/&
&2.5670E-05_JPRB,3.7304E-05_JPRB,1.6500E-04_JPRB,2.3234E-04_JPRB,2.7383E-04_JPRB,2.2881E-04_JPRB/)
KBO( :, 3,54, 6) = (/&
&2.9398E-05_JPRB,4.3828E-05_JPRB,1.7662E-04_JPRB,2.4475E-04_JPRB,2.8488E-04_JPRB,2.3410E-04_JPRB/)
KBO( :, 4,54, 6) = (/&
&3.3830E-05_JPRB,5.1689E-05_JPRB,1.9147E-04_JPRB,2.5918E-04_JPRB,2.9621E-04_JPRB,2.3818E-04_JPRB/)
KBO( :, 5,54, 6) = (/&
&3.9626E-05_JPRB,6.1637E-05_JPRB,2.0865E-04_JPRB,2.7674E-04_JPRB,3.0891E-04_JPRB,2.4078E-04_JPRB/)
KBO( :, 1,55, 6) = (/&
&1.8209E-05_JPRB,2.5880E-05_JPRB,1.2688E-04_JPRB,1.8045E-04_JPRB,2.1398E-04_JPRB,1.8038E-04_JPRB/)
KBO( :, 2,55, 6) = (/&
&2.0657E-05_JPRB,3.0086E-05_JPRB,1.3493E-04_JPRB,1.9025E-04_JPRB,2.2450E-04_JPRB,1.8582E-04_JPRB/)
KBO( :, 3,55, 6) = (/&
&2.3739E-05_JPRB,3.5514E-05_JPRB,1.4460E-04_JPRB,2.0081E-04_JPRB,2.3430E-04_JPRB,1.9033E-04_JPRB/)
KBO( :, 4,55, 6) = (/&
&2.7397E-05_JPRB,4.2088E-05_JPRB,1.5714E-04_JPRB,2.1306E-04_JPRB,2.4416E-04_JPRB,1.9386E-04_JPRB/)
KBO( :, 5,55, 6) = (/&
&3.2153E-05_JPRB,5.0387E-05_JPRB,1.7186E-04_JPRB,2.2820E-04_JPRB,2.5533E-04_JPRB,1.9627E-04_JPRB/)
KBO( :, 1,56, 6) = (/&
&1.4654E-05_JPRB,2.0836E-05_JPRB,1.0350E-04_JPRB,1.4723E-04_JPRB,1.7458E-04_JPRB,1.4613E-04_JPRB/)
KBO( :, 2,56, 6) = (/&
&1.6602E-05_JPRB,2.4224E-05_JPRB,1.1023E-04_JPRB,1.5562E-04_JPRB,1.8380E-04_JPRB,1.5087E-04_JPRB/)
KBO( :, 3,56, 6) = (/&
&1.9145E-05_JPRB,2.8713E-05_JPRB,1.1831E-04_JPRB,1.6458E-04_JPRB,1.9243E-04_JPRB,1.5466E-04_JPRB/)
KBO( :, 4,56, 6) = (/&
&2.2162E-05_JPRB,3.4205E-05_JPRB,1.2877E-04_JPRB,1.7500E-04_JPRB,2.0107E-04_JPRB,1.5776E-04_JPRB/)
KBO( :, 5,56, 6) = (/&
&2.6047E-05_JPRB,4.1114E-05_JPRB,1.4137E-04_JPRB,1.8796E-04_JPRB,2.1083E-04_JPRB,1.5994E-04_JPRB/)
KBO( :, 1,57, 6) = (/&
&1.1795E-05_JPRB,1.6760E-05_JPRB,8.4304E-05_JPRB,1.1999E-04_JPRB,1.4218E-04_JPRB,1.1830E-04_JPRB/)
KBO( :, 2,57, 6) = (/&
&1.3335E-05_JPRB,1.9476E-05_JPRB,8.9964E-05_JPRB,1.2718E-04_JPRB,1.5035E-04_JPRB,1.2244E-04_JPRB/)
KBO( :, 3,57, 6) = (/&
&1.5412E-05_JPRB,2.3150E-05_JPRB,9.6680E-05_JPRB,1.3478E-04_JPRB,1.5779E-04_JPRB,1.2566E-04_JPRB/)
KBO( :, 4,57, 6) = (/&
&1.7896E-05_JPRB,2.7728E-05_JPRB,1.0539E-04_JPRB,1.4358E-04_JPRB,1.6536E-04_JPRB,1.2835E-04_JPRB/)
KBO( :, 5,57, 6) = (/&
&2.1071E-05_JPRB,3.3474E-05_JPRB,1.1614E-04_JPRB,1.5456E-04_JPRB,1.7382E-04_JPRB,1.3028E-04_JPRB/)
KBO( :, 1,58, 6) = (/&
&9.5144E-06_JPRB,1.3504E-05_JPRB,6.8670E-05_JPRB,9.7752E-05_JPRB,1.1572E-04_JPRB,9.5731E-05_JPRB/)
KBO( :, 2,58, 6) = (/&
&1.0727E-05_JPRB,1.5682E-05_JPRB,7.3425E-05_JPRB,1.0393E-04_JPRB,1.2288E-04_JPRB,9.9268E-05_JPRB/)
KBO( :, 3,58, 6) = (/&
&1.2418E-05_JPRB,1.8676E-05_JPRB,7.9036E-05_JPRB,1.1042E-04_JPRB,1.2941E-04_JPRB,1.0205E-04_JPRB/)
KBO( :, 4,58, 6) = (/&
&1.4470E-05_JPRB,2.2492E-05_JPRB,8.6301E-05_JPRB,1.1787E-04_JPRB,1.3601E-04_JPRB,1.0431E-04_JPRB/)
KBO( :, 5,58, 6) = (/&
&1.7068E-05_JPRB,2.7290E-05_JPRB,9.5445E-05_JPRB,1.2711E-04_JPRB,1.4326E-04_JPRB,1.0599E-04_JPRB/)
KBO( :, 1,59, 6) = (/&
&7.8205E-06_JPRB,1.1144E-05_JPRB,5.6553E-05_JPRB,8.0518E-05_JPRB,9.5253E-05_JPRB,7.7758E-05_JPRB/)
KBO( :, 2,59, 6) = (/&
&8.8412E-06_JPRB,1.2994E-05_JPRB,6.0645E-05_JPRB,8.5808E-05_JPRB,1.0137E-04_JPRB,8.0565E-05_JPRB/)
KBO( :, 3,59, 6) = (/&
&1.0275E-05_JPRB,1.5556E-05_JPRB,6.5508E-05_JPRB,9.1408E-05_JPRB,1.0703E-04_JPRB,8.2767E-05_JPRB/)
KBO( :, 4,59, 6) = (/&
&1.2026E-05_JPRB,1.8861E-05_JPRB,7.1879E-05_JPRB,9.7918E-05_JPRB,1.1277E-04_JPRB,8.4443E-05_JPRB/)
KBO( :, 5,59, 6) = (/&
&1.4259E-05_JPRB,2.3051E-05_JPRB,7.9857E-05_JPRB,1.0611E-04_JPRB,1.1921E-04_JPRB,8.5697E-05_JPRB/)
KBO( :, 1,13, 7) = (/&
&9.7647E-02_JPRB,9.7855E-02_JPRB,3.0363E-01_JPRB,4.7031E-01_JPRB,5.9904E-01_JPRB,6.6640E-01_JPRB/)
KBO( :, 2,13, 7) = (/&
&1.0049E-01_JPRB,1.0069E-01_JPRB,3.0218E-01_JPRB,4.6982E-01_JPRB,6.0036E-01_JPRB,6.7308E-01_JPRB/)
KBO( :, 3,13, 7) = (/&
&1.0377E-01_JPRB,1.0396E-01_JPRB,3.0033E-01_JPRB,4.6762E-01_JPRB,5.9983E-01_JPRB,6.7883E-01_JPRB/)
KBO( :, 4,13, 7) = (/&
&1.0704E-01_JPRB,1.0722E-01_JPRB,2.9892E-01_JPRB,4.6467E-01_JPRB,5.9751E-01_JPRB,6.8204E-01_JPRB/)
KBO( :, 5,13, 7) = (/&
&1.1023E-01_JPRB,1.1040E-01_JPRB,2.9802E-01_JPRB,4.6155E-01_JPRB,5.9382E-01_JPRB,6.8342E-01_JPRB/)
KBO( :, 1,14, 7) = (/&
&8.6235E-02_JPRB,8.6450E-02_JPRB,2.9028E-01_JPRB,4.5055E-01_JPRB,5.7620E-01_JPRB,6.3435E-01_JPRB/)
KBO( :, 2,14, 7) = (/&
&8.9084E-02_JPRB,8.9292E-02_JPRB,2.8945E-01_JPRB,4.5002E-01_JPRB,5.7817E-01_JPRB,6.3980E-01_JPRB/)
KBO( :, 3,14, 7) = (/&
&9.1939E-02_JPRB,9.2133E-02_JPRB,2.8902E-01_JPRB,4.4871E-01_JPRB,5.7814E-01_JPRB,6.4427E-01_JPRB/)
KBO( :, 4,14, 7) = (/&
&9.4793E-02_JPRB,9.4979E-02_JPRB,2.8897E-01_JPRB,4.4708E-01_JPRB,5.7621E-01_JPRB,6.4667E-01_JPRB/)
KBO( :, 5,14, 7) = (/&
&9.7493E-02_JPRB,9.7668E-02_JPRB,2.8924E-01_JPRB,4.4518E-01_JPRB,5.7317E-01_JPRB,6.4671E-01_JPRB/)
KBO( :, 1,15, 7) = (/&
&7.5804E-02_JPRB,7.6029E-02_JPRB,2.7446E-01_JPRB,4.2589E-01_JPRB,5.4720E-01_JPRB,5.9726E-01_JPRB/)
KBO( :, 2,15, 7) = (/&
&7.8300E-02_JPRB,7.8517E-02_JPRB,2.7502E-01_JPRB,4.2618E-01_JPRB,5.4948E-01_JPRB,6.0171E-01_JPRB/)
KBO( :, 3,15, 7) = (/&
&8.0785E-02_JPRB,8.0989E-02_JPRB,2.7599E-01_JPRB,4.2609E-01_JPRB,5.4964E-01_JPRB,6.0469E-01_JPRB/)
KBO( :, 4,15, 7) = (/&
&8.3195E-02_JPRB,8.3388E-02_JPRB,2.7720E-01_JPRB,4.2579E-01_JPRB,5.4827E-01_JPRB,6.0587E-01_JPRB/)
KBO( :, 5,15, 7) = (/&
&8.5455E-02_JPRB,8.5636E-02_JPRB,2.7832E-01_JPRB,4.2510E-01_JPRB,5.4565E-01_JPRB,6.0534E-01_JPRB/)
KBO( :, 1,16, 7) = (/&
&6.6118E-02_JPRB,6.6355E-02_JPRB,2.5732E-01_JPRB,3.9829E-01_JPRB,5.1265E-01_JPRB,5.5527E-01_JPRB/)
KBO( :, 2,16, 7) = (/&
&6.8340E-02_JPRB,6.8565E-02_JPRB,2.5922E-01_JPRB,3.9972E-01_JPRB,5.1481E-01_JPRB,5.5901E-01_JPRB/)
KBO( :, 3,16, 7) = (/&
&7.0479E-02_JPRB,7.0691E-02_JPRB,2.6131E-01_JPRB,4.0064E-01_JPRB,5.1513E-01_JPRB,5.6129E-01_JPRB/)
KBO( :, 4,16, 7) = (/&
&7.2489E-02_JPRB,7.2689E-02_JPRB,2.6335E-01_JPRB,4.0108E-01_JPRB,5.1406E-01_JPRB,5.6253E-01_JPRB/)
KBO( :, 5,16, 7) = (/&
&7.4397E-02_JPRB,7.4586E-02_JPRB,2.6518E-01_JPRB,4.0098E-01_JPRB,5.1222E-01_JPRB,5.6243E-01_JPRB/)
KBO( :, 1,17, 7) = (/&
&5.7406E-02_JPRB,5.7650E-02_JPRB,2.3930E-01_JPRB,3.6866E-01_JPRB,4.7357E-01_JPRB,5.0878E-01_JPRB/)
KBO( :, 2,17, 7) = (/&
&5.9309E-02_JPRB,5.9537E-02_JPRB,2.4214E-01_JPRB,3.7060E-01_JPRB,4.7573E-01_JPRB,5.1192E-01_JPRB/)
KBO( :, 3,17, 7) = (/&
&6.1082E-02_JPRB,6.1301E-02_JPRB,2.4481E-01_JPRB,3.7220E-01_JPRB,4.7608E-01_JPRB,5.1457E-01_JPRB/)
KBO( :, 4,17, 7) = (/&
&6.2769E-02_JPRB,6.2976E-02_JPRB,2.4726E-01_JPRB,3.7333E-01_JPRB,4.7575E-01_JPRB,5.1639E-01_JPRB/)
KBO( :, 5,17, 7) = (/&
&6.4538E-02_JPRB,6.4738E-02_JPRB,2.4921E-01_JPRB,3.7444E-01_JPRB,4.7491E-01_JPRB,5.1718E-01_JPRB/)
KBO( :, 1,18, 7) = (/&
&4.9552E-02_JPRB,4.9801E-02_JPRB,2.2056E-01_JPRB,3.3735E-01_JPRB,4.3161E-01_JPRB,4.5988E-01_JPRB/)
KBO( :, 2,18, 7) = (/&
&5.1121E-02_JPRB,5.1359E-02_JPRB,2.2361E-01_JPRB,3.3991E-01_JPRB,4.3345E-01_JPRB,4.6346E-01_JPRB/)
KBO( :, 3,18, 7) = (/&
&5.2593E-02_JPRB,5.2821E-02_JPRB,2.2654E-01_JPRB,3.4220E-01_JPRB,4.3440E-01_JPRB,4.6667E-01_JPRB/)
KBO( :, 4,18, 7) = (/&
&5.4109E-02_JPRB,5.4323E-02_JPRB,2.2905E-01_JPRB,3.4438E-01_JPRB,4.3513E-01_JPRB,4.6905E-01_JPRB/)
KBO( :, 5,18, 7) = (/&
&5.5939E-02_JPRB,5.6145E-02_JPRB,2.3107E-01_JPRB,3.4628E-01_JPRB,4.3581E-01_JPRB,4.7075E-01_JPRB/)
KBO( :, 1,19, 7) = (/&
&4.2494E-02_JPRB,4.2746E-02_JPRB,2.0106E-01_JPRB,3.0520E-01_JPRB,3.8813E-01_JPRB,4.1087E-01_JPRB/)
KBO( :, 2,19, 7) = (/&
&4.3779E-02_JPRB,4.4022E-02_JPRB,2.0425E-01_JPRB,3.0836E-01_JPRB,3.9036E-01_JPRB,4.1494E-01_JPRB/)
KBO( :, 3,19, 7) = (/&
&4.5047E-02_JPRB,4.5279E-02_JPRB,2.0714E-01_JPRB,3.1149E-01_JPRB,3.9227E-01_JPRB,4.1866E-01_JPRB/)
KBO( :, 4,19, 7) = (/&
&4.6572E-02_JPRB,4.6791E-02_JPRB,2.0960E-01_JPRB,3.1442E-01_JPRB,3.9443E-01_JPRB,4.2162E-01_JPRB/)
KBO( :, 5,19, 7) = (/&
&4.8486E-02_JPRB,4.8693E-02_JPRB,2.1178E-01_JPRB,3.1724E-01_JPRB,3.9648E-01_JPRB,4.2406E-01_JPRB/)
KBO( :, 1,20, 7) = (/&
&3.6269E-02_JPRB,3.6528E-02_JPRB,1.8145E-01_JPRB,2.7358E-01_JPRB,3.4556E-01_JPRB,3.6362E-01_JPRB/)
KBO( :, 2,20, 7) = (/&
&3.7339E-02_JPRB,3.7589E-02_JPRB,1.8454E-01_JPRB,2.7744E-01_JPRB,3.4849E-01_JPRB,3.6815E-01_JPRB/)
KBO( :, 3,20, 7) = (/&
&3.8549E-02_JPRB,3.8787E-02_JPRB,1.8732E-01_JPRB,2.8107E-01_JPRB,3.5173E-01_JPRB,3.7214E-01_JPRB/)
KBO( :, 4,20, 7) = (/&
&4.0135E-02_JPRB,4.0360E-02_JPRB,1.8991E-01_JPRB,2.8468E-01_JPRB,3.5494E-01_JPRB,3.7578E-01_JPRB/)
KBO( :, 5,20, 7) = (/&
&4.2034E-02_JPRB,4.2244E-02_JPRB,1.9231E-01_JPRB,2.8796E-01_JPRB,3.5825E-01_JPRB,3.7920E-01_JPRB/)
KBO( :, 1,21, 7) = (/&
&3.0838E-02_JPRB,3.1110E-02_JPRB,1.6217E-01_JPRB,2.4347E-01_JPRB,3.0519E-01_JPRB,3.1909E-01_JPRB/)
KBO( :, 2,21, 7) = (/&
&3.1802E-02_JPRB,3.2063E-02_JPRB,1.6515E-01_JPRB,2.4761E-01_JPRB,3.0911E-01_JPRB,3.2385E-01_JPRB/)
KBO( :, 3,21, 7) = (/&
&3.3062E-02_JPRB,3.3309E-02_JPRB,1.6796E-01_JPRB,2.5173E-01_JPRB,3.1324E-01_JPRB,3.2836E-01_JPRB/)
KBO( :, 4,21, 7) = (/&
&3.4629E-02_JPRB,3.4862E-02_JPRB,1.7066E-01_JPRB,2.5561E-01_JPRB,3.1762E-01_JPRB,3.3243E-01_JPRB/)
KBO( :, 5,21, 7) = (/&
&3.6342E-02_JPRB,3.6556E-02_JPRB,1.7331E-01_JPRB,2.5945E-01_JPRB,3.2161E-01_JPRB,3.3536E-01_JPRB/)
KBO( :, 1,22, 7) = (/&
&2.6185E-02_JPRB,2.6480E-02_JPRB,1.4390E-01_JPRB,2.1535E-01_JPRB,2.6825E-01_JPRB,2.7831E-01_JPRB/)
KBO( :, 2,22, 7) = (/&
&2.7170E-02_JPRB,2.7445E-02_JPRB,1.4681E-01_JPRB,2.1972E-01_JPRB,2.7298E-01_JPRB,2.8332E-01_JPRB/)
KBO( :, 3,22, 7) = (/&
&2.8461E-02_JPRB,2.8721E-02_JPRB,1.4967E-01_JPRB,2.2403E-01_JPRB,2.7800E-01_JPRB,2.8771E-01_JPRB/)
KBO( :, 4,22, 7) = (/&
&2.9895E-02_JPRB,3.0136E-02_JPRB,1.5252E-01_JPRB,2.2826E-01_JPRB,2.8245E-01_JPRB,2.9094E-01_JPRB/)
KBO( :, 5,22, 7) = (/&
&3.1389E-02_JPRB,3.1609E-02_JPRB,1.5546E-01_JPRB,2.3192E-01_JPRB,2.8576E-01_JPRB,2.9204E-01_JPRB/)
KBO( :, 1,23, 7) = (/&
&2.2242E-02_JPRB,2.2585E-02_JPRB,1.2678E-01_JPRB,1.8942E-01_JPRB,2.3494E-01_JPRB,2.4143E-01_JPRB/)
KBO( :, 2,23, 7) = (/&
&2.3269E-02_JPRB,2.3584E-02_JPRB,1.2966E-01_JPRB,1.9392E-01_JPRB,2.4012E-01_JPRB,2.4601E-01_JPRB/)
KBO( :, 3,23, 7) = (/&
&2.4462E-02_JPRB,2.4752E-02_JPRB,1.3262E-01_JPRB,1.9826E-01_JPRB,2.4479E-01_JPRB,2.4932E-01_JPRB/)
KBO( :, 4,23, 7) = (/&
&2.5724E-02_JPRB,2.5987E-02_JPRB,1.3562E-01_JPRB,2.0194E-01_JPRB,2.4827E-01_JPRB,2.5044E-01_JPRB/)
KBO( :, 5,23, 7) = (/&
&2.7009E-02_JPRB,2.7247E-02_JPRB,1.3866E-01_JPRB,2.0472E-01_JPRB,2.4987E-01_JPRB,2.4911E-01_JPRB/)
KBO( :, 1,24, 7) = (/&
&1.8924E-02_JPRB,1.9342E-02_JPRB,1.1105E-01_JPRB,1.6590E-01_JPRB,2.0499E-01_JPRB,2.0802E-01_JPRB/)
KBO( :, 2,24, 7) = (/&
&1.9910E-02_JPRB,2.0290E-02_JPRB,1.1397E-01_JPRB,1.7018E-01_JPRB,2.0970E-01_JPRB,2.1135E-01_JPRB/)
KBO( :, 3,24, 7) = (/&
&2.0965E-02_JPRB,2.1308E-02_JPRB,1.1690E-01_JPRB,1.7382E-01_JPRB,2.1319E-01_JPRB,2.1255E-01_JPRB/)
KBO( :, 4,24, 7) = (/&
&2.2052E-02_JPRB,2.2362E-02_JPRB,1.1976E-01_JPRB,1.7647E-01_JPRB,2.1472E-01_JPRB,2.1155E-01_JPRB/)
KBO( :, 5,24, 7) = (/&
&2.3159E-02_JPRB,2.3438E-02_JPRB,1.2254E-01_JPRB,1.7790E-01_JPRB,2.1436E-01_JPRB,2.0899E-01_JPRB/)
KBO( :, 1,25, 7) = (/&
&1.6126E-02_JPRB,1.6634E-02_JPRB,9.6918E-02_JPRB,1.4450E-01_JPRB,1.7776E-01_JPRB,1.7751E-01_JPRB/)
KBO( :, 2,25, 7) = (/&
&1.7005E-02_JPRB,1.7471E-02_JPRB,9.9655E-02_JPRB,1.4804E-01_JPRB,1.8117E-01_JPRB,1.7889E-01_JPRB/)
KBO( :, 3,25, 7) = (/&
&1.7908E-02_JPRB,1.8330E-02_JPRB,1.0231E-01_JPRB,1.5056E-01_JPRB,1.8277E-01_JPRB,1.7834E-01_JPRB/)
KBO( :, 4,25, 7) = (/&
&1.8834E-02_JPRB,1.9214E-02_JPRB,1.0481E-01_JPRB,1.5188E-01_JPRB,1.8269E-01_JPRB,1.7644E-01_JPRB/)
KBO( :, 5,25, 7) = (/&
&1.9803E-02_JPRB,2.0147E-02_JPRB,1.0706E-01_JPRB,1.5241E-01_JPRB,1.8142E-01_JPRB,1.7360E-01_JPRB/)
KBO( :, 1,26, 7) = (/&
&1.3733E-02_JPRB,1.4333E-02_JPRB,8.4163E-02_JPRB,1.2491E-01_JPRB,1.5264E-01_JPRB,1.4950E-01_JPRB/)
KBO( :, 2,26, 7) = (/&
&1.4485E-02_JPRB,1.5042E-02_JPRB,8.6571E-02_JPRB,1.2729E-01_JPRB,1.5433E-01_JPRB,1.4938E-01_JPRB/)
KBO( :, 3,26, 7) = (/&
&1.5263E-02_JPRB,1.5775E-02_JPRB,8.8793E-02_JPRB,1.2861E-01_JPRB,1.5456E-01_JPRB,1.4809E-01_JPRB/)
KBO( :, 4,26, 7) = (/&
&1.6060E-02_JPRB,1.6526E-02_JPRB,9.0766E-02_JPRB,1.2922E-01_JPRB,1.5373E-01_JPRB,1.4598E-01_JPRB/)
KBO( :, 5,26, 7) = (/&
&1.6936E-02_JPRB,1.7356E-02_JPRB,9.2410E-02_JPRB,1.2957E-01_JPRB,1.5224E-01_JPRB,1.4323E-01_JPRB/)
KBO( :, 1,27, 7) = (/&
&1.1673E-02_JPRB,1.2349E-02_JPRB,7.2668E-02_JPRB,1.0678E-01_JPRB,1.2946E-01_JPRB,1.2446E-01_JPRB/)
KBO( :, 2,27, 7) = (/&
&1.2313E-02_JPRB,1.2955E-02_JPRB,7.4613E-02_JPRB,1.0813E-01_JPRB,1.2998E-01_JPRB,1.2372E-01_JPRB/)
KBO( :, 3,27, 7) = (/&
&1.2974E-02_JPRB,1.3574E-02_JPRB,7.6365E-02_JPRB,1.0885E-01_JPRB,1.2958E-01_JPRB,1.2223E-01_JPRB/)
KBO( :, 4,27, 7) = (/&
&1.3688E-02_JPRB,1.4241E-02_JPRB,7.7870E-02_JPRB,1.0934E-01_JPRB,1.2859E-01_JPRB,1.2019E-01_JPRB/)
KBO( :, 5,27, 7) = (/&
&1.4500E-02_JPRB,1.5004E-02_JPRB,7.9154E-02_JPRB,1.0968E-01_JPRB,1.2721E-01_JPRB,1.1769E-01_JPRB/)
KBO( :, 1,28, 7) = (/&
&9.9017E-03_JPRB,1.0637E-02_JPRB,6.2269E-02_JPRB,9.0336E-02_JPRB,1.0873E-01_JPRB,1.0289E-01_JPRB/)
KBO( :, 2,28, 7) = (/&
&1.0447E-02_JPRB,1.1155E-02_JPRB,6.3837E-02_JPRB,9.1161E-02_JPRB,1.0870E-01_JPRB,1.0194E-01_JPRB/)
KBO( :, 3,28, 7) = (/&
&1.1031E-02_JPRB,1.1703E-02_JPRB,6.5234E-02_JPRB,9.1757E-02_JPRB,1.0813E-01_JPRB,1.0049E-01_JPRB/)
KBO( :, 4,28, 7) = (/&
&1.1687E-02_JPRB,1.2317E-02_JPRB,6.6435E-02_JPRB,9.2244E-02_JPRB,1.0722E-01_JPRB,9.8621E-02_JPRB/)
KBO( :, 5,28, 7) = (/&
&1.2452E-02_JPRB,1.3036E-02_JPRB,6.7452E-02_JPRB,9.2541E-02_JPRB,1.0617E-01_JPRB,9.6430E-02_JPRB/)
KBO( :, 1,29, 7) = (/&
&8.3943E-03_JPRB,9.1654E-03_JPRB,5.3047E-02_JPRB,7.5941E-02_JPRB,9.0764E-02_JPRB,8.4732E-02_JPRB/)
KBO( :, 2,29, 7) = (/&
&8.8669E-03_JPRB,9.6211E-03_JPRB,5.4351E-02_JPRB,7.6615E-02_JPRB,9.0534E-02_JPRB,8.3768E-02_JPRB/)
KBO( :, 3,29, 7) = (/&
&9.3976E-03_JPRB,1.0125E-02_JPRB,5.5501E-02_JPRB,7.7201E-02_JPRB,8.9989E-02_JPRB,8.2428E-02_JPRB/)
KBO( :, 4,29, 7) = (/&
&1.0017E-02_JPRB,1.0708E-02_JPRB,5.6489E-02_JPRB,7.7643E-02_JPRB,8.9310E-02_JPRB,8.0785E-02_JPRB/)
KBO( :, 5,29, 7) = (/&
&1.0736E-02_JPRB,1.1389E-02_JPRB,5.7305E-02_JPRB,7.7877E-02_JPRB,8.8545E-02_JPRB,7.8917E-02_JPRB/)
KBO( :, 1,30, 7) = (/&
&7.1195E-03_JPRB,7.9064E-03_JPRB,4.5048E-02_JPRB,6.3701E-02_JPRB,7.5506E-02_JPRB,6.9609E-02_JPRB/)
KBO( :, 2,30, 7) = (/&
&7.5430E-03_JPRB,8.3223E-03_JPRB,4.6141E-02_JPRB,6.4336E-02_JPRB,7.5249E-02_JPRB,6.8691E-02_JPRB/)
KBO( :, 3,30, 7) = (/&
&8.0392E-03_JPRB,8.8028E-03_JPRB,4.7092E-02_JPRB,6.4887E-02_JPRB,7.4865E-02_JPRB,6.7513E-02_JPRB/)
KBO( :, 4,30, 7) = (/&
&8.6260E-03_JPRB,9.3657E-03_JPRB,4.7903E-02_JPRB,6.5263E-02_JPRB,7.4401E-02_JPRB,6.6108E-02_JPRB/)
KBO( :, 5,30, 7) = (/&
&9.2967E-03_JPRB,1.0007E-02_JPRB,4.8615E-02_JPRB,6.5447E-02_JPRB,7.3852E-02_JPRB,6.4545E-02_JPRB/)
KBO( :, 1,31, 7) = (/&
&6.0475E-03_JPRB,6.8335E-03_JPRB,3.8158E-02_JPRB,5.3421E-02_JPRB,6.2695E-02_JPRB,5.7118E-02_JPRB/)
KBO( :, 2,31, 7) = (/&
&6.4423E-03_JPRB,7.2306E-03_JPRB,3.9087E-02_JPRB,5.4038E-02_JPRB,6.2533E-02_JPRB,5.6304E-02_JPRB/)
KBO( :, 3,31, 7) = (/&
&6.9157E-03_JPRB,7.6990E-03_JPRB,3.9885E-02_JPRB,5.4507E-02_JPRB,6.2314E-02_JPRB,5.5291E-02_JPRB/)
KBO( :, 4,31, 7) = (/&
&7.4643E-03_JPRB,8.2378E-03_JPRB,4.0585E-02_JPRB,5.4818E-02_JPRB,6.2007E-02_JPRB,5.4123E-02_JPRB/)
KBO( :, 5,31, 7) = (/&
&8.0870E-03_JPRB,8.8427E-03_JPRB,4.1238E-02_JPRB,5.4956E-02_JPRB,6.1571E-02_JPRB,5.2845E-02_JPRB/)
KBO( :, 1,32, 7) = (/&
&5.1572E-03_JPRB,5.9281E-03_JPRB,3.2288E-02_JPRB,4.4834E-02_JPRB,5.2063E-02_JPRB,4.6838E-02_JPRB/)
KBO( :, 2,32, 7) = (/&
&5.5343E-03_JPRB,6.3178E-03_JPRB,3.3066E-02_JPRB,4.5379E-02_JPRB,5.2022E-02_JPRB,4.6134E-02_JPRB/)
KBO( :, 3,32, 7) = (/&
&5.9793E-03_JPRB,6.7732E-03_JPRB,3.3755E-02_JPRB,4.5782E-02_JPRB,5.1906E-02_JPRB,4.5284E-02_JPRB/)
KBO( :, 4,32, 7) = (/&
&6.4923E-03_JPRB,7.2876E-03_JPRB,3.4382E-02_JPRB,4.6031E-02_JPRB,5.1677E-02_JPRB,4.4332E-02_JPRB/)
KBO( :, 5,32, 7) = (/&
&7.0596E-03_JPRB,7.8510E-03_JPRB,3.5020E-02_JPRB,4.6157E-02_JPRB,5.1326E-02_JPRB,4.3327E-02_JPRB/)
KBO( :, 1,33, 7) = (/&
&4.4193E-03_JPRB,5.1672E-03_JPRB,2.7281E-02_JPRB,3.7643E-02_JPRB,4.3289E-02_JPRB,3.8410E-02_JPRB/)
KBO( :, 2,33, 7) = (/&
&4.7780E-03_JPRB,5.5509E-03_JPRB,2.7954E-02_JPRB,3.8112E-02_JPRB,4.3323E-02_JPRB,3.7821E-02_JPRB/)
KBO( :, 3,33, 7) = (/&
&5.1954E-03_JPRB,5.9899E-03_JPRB,2.8558E-02_JPRB,3.8442E-02_JPRB,4.3253E-02_JPRB,3.7133E-02_JPRB/)
KBO( :, 4,33, 7) = (/&
&5.6675E-03_JPRB,6.4760E-03_JPRB,2.9162E-02_JPRB,3.8661E-02_JPRB,4.3077E-02_JPRB,3.6382E-02_JPRB/)
KBO( :, 5,33, 7) = (/&
&6.1867E-03_JPRB,6.9981E-03_JPRB,2.9817E-02_JPRB,3.8817E-02_JPRB,4.2791E-02_JPRB,3.5593E-02_JPRB/)
KBO( :, 1,34, 7) = (/&
&3.7967E-03_JPRB,4.5190E-03_JPRB,2.3030E-02_JPRB,3.1601E-02_JPRB,3.6054E-02_JPRB,3.1509E-02_JPRB/)
KBO( :, 2,34, 7) = (/&
&4.1317E-03_JPRB,4.8886E-03_JPRB,2.3612E-02_JPRB,3.1993E-02_JPRB,3.6114E-02_JPRB,3.1025E-02_JPRB/)
KBO( :, 3,34, 7) = (/&
&4.5197E-03_JPRB,5.3080E-03_JPRB,2.4172E-02_JPRB,3.2284E-02_JPRB,3.6075E-02_JPRB,3.0475E-02_JPRB/)
KBO( :, 4,34, 7) = (/&
&4.9490E-03_JPRB,5.7615E-03_JPRB,2.4765E-02_JPRB,3.2500E-02_JPRB,3.5934E-02_JPRB,2.9886E-02_JPRB/)
KBO( :, 5,34, 7) = (/&
&5.4277E-03_JPRB,6.2506E-03_JPRB,2.5457E-02_JPRB,3.2703E-02_JPRB,3.5717E-02_JPRB,2.9265E-02_JPRB/)
KBO( :, 1,35, 7) = (/&
&3.2485E-03_JPRB,3.9401E-03_JPRB,1.9395E-02_JPRB,2.6487E-02_JPRB,3.0061E-02_JPRB,2.5898E-02_JPRB/)
KBO( :, 2,35, 7) = (/&
&3.5574E-03_JPRB,4.2902E-03_JPRB,1.9918E-02_JPRB,2.6839E-02_JPRB,3.0137E-02_JPRB,2.5509E-02_JPRB/)
KBO( :, 3,35, 7) = (/&
&3.9084E-03_JPRB,4.6823E-03_JPRB,2.0454E-02_JPRB,2.7112E-02_JPRB,3.0123E-02_JPRB,2.5080E-02_JPRB/)
KBO( :, 4,35, 7) = (/&
&4.2975E-03_JPRB,5.1039E-03_JPRB,2.1052E-02_JPRB,2.7348E-02_JPRB,3.0028E-02_JPRB,2.4626E-02_JPRB/)
KBO( :, 5,35, 7) = (/&
&4.7400E-03_JPRB,5.5642E-03_JPRB,2.1748E-02_JPRB,2.7600E-02_JPRB,2.9873E-02_JPRB,2.4136E-02_JPRB/)
KBO( :, 1,36, 7) = (/&
&2.7607E-03_JPRB,3.4142E-03_JPRB,1.6292E-02_JPRB,2.2168E-02_JPRB,2.5071E-02_JPRB,2.1321E-02_JPRB/)
KBO( :, 2,36, 7) = (/&
&3.0408E-03_JPRB,3.7429E-03_JPRB,1.6771E-02_JPRB,2.2492E-02_JPRB,2.5167E-02_JPRB,2.1022E-02_JPRB/)
KBO( :, 3,36, 7) = (/&
&3.3541E-03_JPRB,4.1050E-03_JPRB,1.7286E-02_JPRB,2.2762E-02_JPRB,2.5179E-02_JPRB,2.0697E-02_JPRB/)
KBO( :, 4,36, 7) = (/&
&3.7038E-03_JPRB,4.4924E-03_JPRB,1.7882E-02_JPRB,2.3025E-02_JPRB,2.5128E-02_JPRB,2.0344E-02_JPRB/)
KBO( :, 5,36, 7) = (/&
&4.1115E-03_JPRB,4.9275E-03_JPRB,1.8561E-02_JPRB,2.3321E-02_JPRB,2.5038E-02_JPRB,1.9966E-02_JPRB/)
KBO( :, 1,37, 7) = (/&
&2.3165E-03_JPRB,2.9243E-03_JPRB,1.3632E-02_JPRB,1.8511E-02_JPRB,2.0911E-02_JPRB,1.7582E-02_JPRB/)
KBO( :, 2,37, 7) = (/&
&2.5620E-03_JPRB,3.2240E-03_JPRB,1.4078E-02_JPRB,1.8817E-02_JPRB,2.1021E-02_JPRB,1.7359E-02_JPRB/)
KBO( :, 3,37, 7) = (/&
&2.8378E-03_JPRB,3.5536E-03_JPRB,1.4566E-02_JPRB,1.9089E-02_JPRB,2.1062E-02_JPRB,1.7112E-02_JPRB/)
KBO( :, 4,37, 7) = (/&
&3.1506E-03_JPRB,3.9105E-03_JPRB,1.5134E-02_JPRB,1.9368E-02_JPRB,2.1055E-02_JPRB,1.6843E-02_JPRB/)
KBO( :, 5,37, 7) = (/&
&3.5154E-03_JPRB,4.3116E-03_JPRB,1.5780E-02_JPRB,1.9690E-02_JPRB,2.1025E-02_JPRB,1.6554E-02_JPRB/)
KBO( :, 1,38, 7) = (/&
&1.9436E-03_JPRB,2.5043E-03_JPRB,1.1409E-02_JPRB,1.5449E-02_JPRB,1.7439E-02_JPRB,1.4509E-02_JPRB/)
KBO( :, 2,38, 7) = (/&
&2.1585E-03_JPRB,2.7776E-03_JPRB,1.1822E-02_JPRB,1.5741E-02_JPRB,1.7560E-02_JPRB,1.4349E-02_JPRB/)
KBO( :, 3,38, 7) = (/&
&2.4018E-03_JPRB,3.0766E-03_JPRB,1.2278E-02_JPRB,1.6010E-02_JPRB,1.7625E-02_JPRB,1.4163E-02_JPRB/)
KBO( :, 4,38, 7) = (/&
&2.6807E-03_JPRB,3.4074E-03_JPRB,1.2821E-02_JPRB,1.6300E-02_JPRB,1.7653E-02_JPRB,1.3961E-02_JPRB/)
KBO( :, 5,38, 7) = (/&
&3.0074E-03_JPRB,3.7767E-03_JPRB,1.3427E-02_JPRB,1.6635E-02_JPRB,1.7670E-02_JPRB,1.3745E-02_JPRB/)
KBO( :, 1,39, 7) = (/&
&1.6324E-03_JPRB,2.1472E-03_JPRB,9.5576E-03_JPRB,1.2899E-02_JPRB,1.4546E-02_JPRB,1.1989E-02_JPRB/)
KBO( :, 2,39, 7) = (/&
&1.8200E-03_JPRB,2.3947E-03_JPRB,9.9337E-03_JPRB,1.3170E-02_JPRB,1.4671E-02_JPRB,1.1875E-02_JPRB/)
KBO( :, 3,39, 7) = (/&
&2.0341E-03_JPRB,2.6676E-03_JPRB,1.0368E-02_JPRB,1.3436E-02_JPRB,1.4754E-02_JPRB,1.1741E-02_JPRB/)
KBO( :, 4,39, 7) = (/&
&2.2822E-03_JPRB,2.9700E-03_JPRB,1.0873E-02_JPRB,1.3729E-02_JPRB,1.4811E-02_JPRB,1.1592E-02_JPRB/)
KBO( :, 5,39, 7) = (/&
&2.5777E-03_JPRB,3.3169E-03_JPRB,1.1451E-02_JPRB,1.4071E-02_JPRB,1.4864E-02_JPRB,1.1429E-02_JPRB/)
KBO( :, 1,40, 7) = (/&
&1.3560E-03_JPRB,1.8205E-03_JPRB,7.9786E-03_JPRB,1.0746E-02_JPRB,1.2116E-02_JPRB,9.8937E-03_JPRB/)
KBO( :, 2,40, 7) = (/&
&1.5188E-03_JPRB,2.0432E-03_JPRB,8.3209E-03_JPRB,1.1001E-02_JPRB,1.2248E-02_JPRB,9.8116E-03_JPRB/)
KBO( :, 3,40, 7) = (/&
&1.7047E-03_JPRB,2.2893E-03_JPRB,8.7183E-03_JPRB,1.1256E-02_JPRB,1.2346E-02_JPRB,9.7139E-03_JPRB/)
KBO( :, 4,40, 7) = (/&
&1.9222E-03_JPRB,2.5662E-03_JPRB,9.1877E-03_JPRB,1.1545E-02_JPRB,1.2425E-02_JPRB,9.6034E-03_JPRB/)
KBO( :, 5,40, 7) = (/&
&2.1827E-03_JPRB,2.8825E-03_JPRB,9.7216E-03_JPRB,1.1880E-02_JPRB,1.2506E-02_JPRB,9.4790E-03_JPRB/)
KBO( :, 1,41, 7) = (/&
&1.1245E-03_JPRB,1.5415E-03_JPRB,6.6591E-03_JPRB,8.9478E-03_JPRB,1.0087E-02_JPRB,8.1642E-03_JPRB/)
KBO( :, 2,41, 7) = (/&
&1.2648E-03_JPRB,1.7402E-03_JPRB,6.9688E-03_JPRB,9.1871E-03_JPRB,1.0221E-02_JPRB,8.1056E-03_JPRB/)
KBO( :, 3,41, 7) = (/&
&1.4266E-03_JPRB,1.9622E-03_JPRB,7.3306E-03_JPRB,9.4300E-03_JPRB,1.0328E-02_JPRB,8.0356E-03_JPRB/)
KBO( :, 4,41, 7) = (/&
&1.6162E-03_JPRB,2.2132E-03_JPRB,7.7614E-03_JPRB,9.7094E-03_JPRB,1.0422E-02_JPRB,7.9538E-03_JPRB/)
KBO( :, 5,41, 7) = (/&
&1.8452E-03_JPRB,2.5020E-03_JPRB,8.2540E-03_JPRB,1.0030E-02_JPRB,1.0522E-02_JPRB,7.8592E-03_JPRB/)
KBO( :, 1,42, 7) = (/&
&9.3219E-04_JPRB,1.3042E-03_JPRB,5.5558E-03_JPRB,7.4502E-03_JPRB,8.3930E-03_JPRB,6.7373E-03_JPRB/)
KBO( :, 2,42, 7) = (/&
&1.0531E-03_JPRB,1.4817E-03_JPRB,5.8359E-03_JPRB,7.6727E-03_JPRB,8.5267E-03_JPRB,6.6979E-03_JPRB/)
KBO( :, 3,42, 7) = (/&
&1.1932E-03_JPRB,1.6822E-03_JPRB,6.1662E-03_JPRB,7.9012E-03_JPRB,8.6371E-03_JPRB,6.6486E-03_JPRB/)
KBO( :, 4,42, 7) = (/&
&1.3591E-03_JPRB,1.9101E-03_JPRB,6.5594E-03_JPRB,8.1659E-03_JPRB,8.7400E-03_JPRB,6.5900E-03_JPRB/)
KBO( :, 5,42, 7) = (/&
&1.5595E-03_JPRB,2.1712E-03_JPRB,7.0143E-03_JPRB,8.4711E-03_JPRB,8.8520E-03_JPRB,6.5197E-03_JPRB/)
KBO( :, 1,43, 7) = (/&
&7.6655E-04_JPRB,1.0948E-03_JPRB,4.6199E-03_JPRB,6.1929E-03_JPRB,6.9738E-03_JPRB,5.5590E-03_JPRB/)
KBO( :, 2,43, 7) = (/&
&8.7006E-04_JPRB,1.2519E-03_JPRB,4.8725E-03_JPRB,6.3982E-03_JPRB,7.1051E-03_JPRB,5.5354E-03_JPRB/)
KBO( :, 3,43, 7) = (/&
&9.9067E-04_JPRB,1.4317E-03_JPRB,5.1714E-03_JPRB,6.6094E-03_JPRB,7.2167E-03_JPRB,5.5034E-03_JPRB/)
KBO( :, 4,43, 7) = (/&
&1.1333E-03_JPRB,1.6361E-03_JPRB,5.5238E-03_JPRB,6.8549E-03_JPRB,7.3224E-03_JPRB,5.4615E-03_JPRB/)
KBO( :, 5,43, 7) = (/&
&1.3078E-03_JPRB,1.8729E-03_JPRB,5.9392E-03_JPRB,7.1404E-03_JPRB,7.4395E-03_JPRB,5.4098E-03_JPRB/)
KBO( :, 1,44, 7) = (/&
&6.2716E-04_JPRB,9.1445E-04_JPRB,3.8379E-03_JPRB,5.1423E-03_JPRB,5.7885E-03_JPRB,4.5879E-03_JPRB/)
KBO( :, 2,44, 7) = (/&
&7.1539E-04_JPRB,1.0525E-03_JPRB,4.0608E-03_JPRB,5.3284E-03_JPRB,5.9139E-03_JPRB,4.5750E-03_JPRB/)
KBO( :, 3,44, 7) = (/&
&8.1868E-04_JPRB,1.2124E-03_JPRB,4.3261E-03_JPRB,5.5223E-03_JPRB,6.0237E-03_JPRB,4.5564E-03_JPRB/)
KBO( :, 4,44, 7) = (/&
&9.4076E-04_JPRB,1.3951E-03_JPRB,4.6439E-03_JPRB,5.7493E-03_JPRB,6.1304E-03_JPRB,4.5291E-03_JPRB/)
KBO( :, 5,44, 7) = (/&
&1.0905E-03_JPRB,1.6074E-03_JPRB,5.0184E-03_JPRB,6.0132E-03_JPRB,6.2498E-03_JPRB,4.4930E-03_JPRB/)
KBO( :, 1,45, 7) = (/&
&5.1229E-04_JPRB,7.6193E-04_JPRB,3.1853E-03_JPRB,4.2678E-03_JPRB,4.8007E-03_JPRB,3.7867E-03_JPRB/)
KBO( :, 2,45, 7) = (/&
&5.8700E-04_JPRB,8.8309E-04_JPRB,3.3822E-03_JPRB,4.4376E-03_JPRB,4.9204E-03_JPRB,3.7837E-03_JPRB/)
KBO( :, 3,45, 7) = (/&
&6.7532E-04_JPRB,1.0253E-03_JPRB,3.6172E-03_JPRB,4.6137E-03_JPRB,5.0263E-03_JPRB,3.7750E-03_JPRB/)
KBO( :, 4,45, 7) = (/&
&7.7992E-04_JPRB,1.1886E-03_JPRB,3.9001E-03_JPRB,4.8193E-03_JPRB,5.1305E-03_JPRB,3.7582E-03_JPRB/)
KBO( :, 5,45, 7) = (/&
&9.0898E-04_JPRB,1.3801E-03_JPRB,4.2375E-03_JPRB,5.0602E-03_JPRB,5.2468E-03_JPRB,3.7339E-03_JPRB/)
KBO( :, 1,46, 7) = (/&
&4.1645E-04_JPRB,6.3110E-04_JPRB,2.6350E-03_JPRB,3.5353E-03_JPRB,3.9769E-03_JPRB,3.1256E-03_JPRB/)
KBO( :, 2,46, 7) = (/&
&4.7902E-04_JPRB,7.3636E-04_JPRB,2.8091E-03_JPRB,3.6888E-03_JPRB,4.0884E-03_JPRB,3.1284E-03_JPRB/)
KBO( :, 3,46, 7) = (/&
&5.5407E-04_JPRB,8.6233E-04_JPRB,3.0151E-03_JPRB,3.8480E-03_JPRB,4.1890E-03_JPRB,3.1266E-03_JPRB/)
KBO( :, 4,46, 7) = (/&
&6.4357E-04_JPRB,1.0083E-03_JPRB,3.2677E-03_JPRB,4.0349E-03_JPRB,4.2897E-03_JPRB,3.1195E-03_JPRB/)
KBO( :, 5,46, 7) = (/&
&7.5354E-04_JPRB,1.1783E-03_JPRB,3.5685E-03_JPRB,4.2544E-03_JPRB,4.4018E-03_JPRB,3.1063E-03_JPRB/)
KBO( :, 1,47, 7) = (/&
&3.3601E-04_JPRB,5.1777E-04_JPRB,2.1723E-03_JPRB,2.9197E-03_JPRB,3.2860E-03_JPRB,2.5760E-03_JPRB/)
KBO( :, 2,47, 7) = (/&
&3.8754E-04_JPRB,6.0796E-04_JPRB,2.3239E-03_JPRB,3.0581E-03_JPRB,3.3911E-03_JPRB,2.5844E-03_JPRB/)
KBO( :, 3,47, 7) = (/&
&4.5065E-04_JPRB,7.1798E-04_JPRB,2.5022E-03_JPRB,3.2019E-03_JPRB,3.4875E-03_JPRB,2.5889E-03_JPRB/)
KBO( :, 4,47, 7) = (/&
&5.2613E-04_JPRB,8.4682E-04_JPRB,2.7238E-03_JPRB,3.3682E-03_JPRB,3.5815E-03_JPRB,2.5884E-03_JPRB/)
KBO( :, 5,47, 7) = (/&
&6.1929E-04_JPRB,9.9786E-04_JPRB,2.9897E-03_JPRB,3.5658E-03_JPRB,3.6861E-03_JPRB,2.5827E-03_JPRB/)
KBO( :, 1,48, 7) = (/&
&2.7083E-04_JPRB,4.2347E-04_JPRB,1.7899E-03_JPRB,2.4088E-03_JPRB,2.7136E-03_JPRB,2.1244E-03_JPRB/)
KBO( :, 2,48, 7) = (/&
&3.1279E-04_JPRB,4.9999E-04_JPRB,1.9206E-03_JPRB,2.5330E-03_JPRB,2.8112E-03_JPRB,2.1367E-03_JPRB/)
KBO( :, 3,48, 7) = (/&
&3.6550E-04_JPRB,5.9533E-04_JPRB,2.0740E-03_JPRB,2.6614E-03_JPRB,2.9002E-03_JPRB,2.1451E-03_JPRB/)
KBO( :, 4,48, 7) = (/&
&4.2897E-04_JPRB,7.0913E-04_JPRB,2.2662E-03_JPRB,2.8083E-03_JPRB,2.9875E-03_JPRB,2.1497E-03_JPRB/)
KBO( :, 5,48, 7) = (/&
&5.0746E-04_JPRB,8.4310E-04_JPRB,2.4995E-03_JPRB,2.9841E-03_JPRB,3.0838E-03_JPRB,2.1494E-03_JPRB/)
KBO( :, 1,49, 7) = (/&
&2.1798E-04_JPRB,3.4528E-04_JPRB,1.4710E-03_JPRB,1.9833E-03_JPRB,2.2375E-03_JPRB,1.7528E-03_JPRB/)
KBO( :, 2,49, 7) = (/&
&2.5177E-04_JPRB,4.0956E-04_JPRB,1.5850E-03_JPRB,2.0943E-03_JPRB,2.3273E-03_JPRB,1.7678E-03_JPRB/)
KBO( :, 3,49, 7) = (/&
&2.9568E-04_JPRB,4.9144E-04_JPRB,1.7161E-03_JPRB,2.2089E-03_JPRB,2.4094E-03_JPRB,1.7791E-03_JPRB/)
KBO( :, 4,49, 7) = (/&
&3.4874E-04_JPRB,5.9100E-04_JPRB,1.8818E-03_JPRB,2.3380E-03_JPRB,2.4892E-03_JPRB,1.7874E-03_JPRB/)
KBO( :, 5,49, 7) = (/&
&4.1458E-04_JPRB,7.0951E-04_JPRB,2.0849E-03_JPRB,2.4934E-03_JPRB,2.5772E-03_JPRB,1.7919E-03_JPRB/)
KBO( :, 1,50, 7) = (/&
&1.7585E-04_JPRB,2.8189E-04_JPRB,1.2093E-03_JPRB,1.6329E-03_JPRB,1.8441E-03_JPRB,1.4430E-03_JPRB/)
KBO( :, 2,50, 7) = (/&
&2.0319E-04_JPRB,3.3574E-04_JPRB,1.3080E-03_JPRB,1.7313E-03_JPRB,1.9256E-03_JPRB,1.4584E-03_JPRB/)
KBO( :, 3,50, 7) = (/&
&2.3954E-04_JPRB,4.0576E-04_JPRB,1.4210E-03_JPRB,1.8326E-03_JPRB,2.0011E-03_JPRB,1.4708E-03_JPRB/)
KBO( :, 4,50, 7) = (/&
&2.8402E-04_JPRB,4.9271E-04_JPRB,1.5642E-03_JPRB,1.9468E-03_JPRB,2.0746E-03_JPRB,1.4813E-03_JPRB/)
KBO( :, 5,50, 7) = (/&
&3.3943E-04_JPRB,5.9790E-04_JPRB,1.7417E-03_JPRB,2.0852E-03_JPRB,2.1555E-03_JPRB,1.4890E-03_JPRB/)
KBO( :, 1,51, 7) = (/&
&1.4190E-04_JPRB,2.2992E-04_JPRB,9.9404E-04_JPRB,1.3435E-03_JPRB,1.5181E-03_JPRB,1.1857E-03_JPRB/)
KBO( :, 2,51, 7) = (/&
&1.6404E-04_JPRB,2.7497E-04_JPRB,1.0789E-03_JPRB,1.4304E-03_JPRB,1.5921E-03_JPRB,1.2010E-03_JPRB/)
KBO( :, 3,51, 7) = (/&
&1.9404E-04_JPRB,3.3460E-04_JPRB,1.1768E-03_JPRB,1.5204E-03_JPRB,1.6616E-03_JPRB,1.2144E-03_JPRB/)
KBO( :, 4,51, 7) = (/&
&2.3131E-04_JPRB,4.1015E-04_JPRB,1.3000E-03_JPRB,1.6207E-03_JPRB,1.7290E-03_JPRB,1.2257E-03_JPRB/)
KBO( :, 5,51, 7) = (/&
&2.7780E-04_JPRB,5.0292E-04_JPRB,1.4546E-03_JPRB,1.7432E-03_JPRB,1.8024E-03_JPRB,1.2347E-03_JPRB/)
KBO( :, 1,52, 7) = (/&
&1.1444E-04_JPRB,1.8707E-04_JPRB,8.1510E-04_JPRB,1.1036E-03_JPRB,1.2481E-03_JPRB,9.7442E-04_JPRB/)
KBO( :, 2,52, 7) = (/&
&1.3222E-04_JPRB,2.2446E-04_JPRB,8.8966E-04_JPRB,1.1810E-03_JPRB,1.3153E-03_JPRB,9.8987E-04_JPRB/)
KBO( :, 3,52, 7) = (/&
&1.5685E-04_JPRB,2.7479E-04_JPRB,9.7350E-04_JPRB,1.2602E-03_JPRB,1.3785E-03_JPRB,1.0031E-03_JPRB/)
KBO( :, 4,52, 7) = (/&
&1.8798E-04_JPRB,3.3998E-04_JPRB,1.0787E-03_JPRB,1.3479E-03_JPRB,1.4399E-03_JPRB,1.0147E-03_JPRB/)
KBO( :, 5,52, 7) = (/&
&2.2685E-04_JPRB,4.2103E-04_JPRB,1.2129E-03_JPRB,1.4553E-03_JPRB,1.5058E-03_JPRB,1.0246E-03_JPRB/)
KBO( :, 1,53, 7) = (/&
&9.2203E-05_JPRB,1.5178E-04_JPRB,6.6684E-04_JPRB,9.0491E-04_JPRB,1.0248E-03_JPRB,8.0095E-04_JPRB/)
KBO( :, 2,53, 7) = (/&
&1.0645E-04_JPRB,1.8273E-04_JPRB,7.3180E-04_JPRB,9.7345E-04_JPRB,1.0848E-03_JPRB,8.1627E-04_JPRB/)
KBO( :, 3,53, 7) = (/&
&1.2645E-04_JPRB,2.2480E-04_JPRB,8.0421E-04_JPRB,1.0432E-03_JPRB,1.1420E-03_JPRB,8.2935E-04_JPRB/)
KBO( :, 4,53, 7) = (/&
&1.5240E-04_JPRB,2.8048E-04_JPRB,8.9332E-04_JPRB,1.1196E-03_JPRB,1.1976E-03_JPRB,8.4108E-04_JPRB/)
KBO( :, 5,53, 7) = (/&
&1.8493E-04_JPRB,3.5120E-04_JPRB,1.0092E-03_JPRB,1.2130E-03_JPRB,1.2568E-03_JPRB,8.5144E-04_JPRB/)
KBO( :, 1,54, 7) = (/&
&7.4475E-05_JPRB,1.2345E-04_JPRB,5.4618E-04_JPRB,7.4261E-04_JPRB,8.4183E-04_JPRB,6.5530E-04_JPRB/)
KBO( :, 2,54, 7) = (/&
&8.5959E-05_JPRB,1.4923E-04_JPRB,6.0251E-04_JPRB,8.0294E-04_JPRB,8.9490E-04_JPRB,6.6891E-04_JPRB/)
KBO( :, 3,54, 7) = (/&
&1.0229E-04_JPRB,1.8454E-04_JPRB,6.6507E-04_JPRB,8.6435E-04_JPRB,9.4622E-04_JPRB,6.8052E-04_JPRB/)
KBO( :, 4,54, 7) = (/&
&1.2399E-04_JPRB,2.3208E-04_JPRB,7.4156E-04_JPRB,9.3133E-04_JPRB,9.9626E-04_JPRB,6.9113E-04_JPRB/)
KBO( :, 5,54, 7) = (/&
&1.5132E-04_JPRB,2.9378E-04_JPRB,8.4147E-04_JPRB,1.0125E-03_JPRB,1.0494E-03_JPRB,7.0039E-04_JPRB/)
KBO( :, 1,55, 7) = (/&
&6.0192E-05_JPRB,1.0040E-04_JPRB,4.4700E-04_JPRB,6.0908E-04_JPRB,6.9112E-04_JPRB,5.3444E-04_JPRB/)
KBO( :, 2,55, 7) = (/&
&6.9457E-05_JPRB,1.2191E-04_JPRB,4.9554E-04_JPRB,6.6216E-04_JPRB,7.3789E-04_JPRB,5.4620E-04_JPRB/)
KBO( :, 3,55, 7) = (/&
&8.2806E-05_JPRB,1.5147E-04_JPRB,5.4968E-04_JPRB,7.1596E-04_JPRB,7.8355E-04_JPRB,5.5595E-04_JPRB/)
KBO( :, 4,55, 7) = (/&
&1.0089E-04_JPRB,1.9188E-04_JPRB,6.1506E-04_JPRB,7.7451E-04_JPRB,8.2844E-04_JPRB,5.6494E-04_JPRB/)
KBO( :, 5,55, 7) = (/&
&1.2391E-04_JPRB,2.4549E-04_JPRB,7.0152E-04_JPRB,8.4524E-04_JPRB,8.7589E-04_JPRB,5.7264E-04_JPRB/)
KBO( :, 1,56, 7) = (/&
&4.8580E-05_JPRB,8.1447E-05_JPRB,3.6499E-04_JPRB,4.9860E-04_JPRB,5.6674E-04_JPRB,4.3567E-04_JPRB/)
KBO( :, 2,56, 7) = (/&
&5.6047E-05_JPRB,9.9320E-05_JPRB,4.0649E-04_JPRB,5.4492E-04_JPRB,6.0760E-04_JPRB,4.4586E-04_JPRB/)
KBO( :, 3,56, 7) = (/&
&6.6893E-05_JPRB,1.2391E-04_JPRB,4.5320E-04_JPRB,5.9224E-04_JPRB,6.4818E-04_JPRB,4.5422E-04_JPRB/)
KBO( :, 4,56, 7) = (/&
&8.1912E-05_JPRB,1.5812E-04_JPRB,5.0921E-04_JPRB,6.4326E-04_JPRB,6.8817E-04_JPRB,4.6166E-04_JPRB/)
KBO( :, 5,56, 7) = (/&
&1.0126E-04_JPRB,2.0443E-04_JPRB,5.8380E-04_JPRB,7.0456E-04_JPRB,7.3041E-04_JPRB,4.6808E-04_JPRB/)
KBO( :, 1,57, 7) = (/&
&3.9160E-05_JPRB,6.5848E-05_JPRB,2.9734E-04_JPRB,4.0720E-04_JPRB,4.6401E-04_JPRB,3.5487E-04_JPRB/)
KBO( :, 2,57, 7) = (/&
&4.5169E-05_JPRB,8.0667E-05_JPRB,3.3303E-04_JPRB,4.4771E-04_JPRB,4.9960E-04_JPRB,3.6385E-04_JPRB/)
KBO( :, 3,57, 7) = (/&
&5.3922E-05_JPRB,1.0107E-04_JPRB,3.7271E-04_JPRB,4.8901E-04_JPRB,5.3556E-04_JPRB,3.7100E-04_JPRB/)
KBO( :, 4,57, 7) = (/&
&6.6309E-05_JPRB,1.2986E-04_JPRB,4.2066E-04_JPRB,5.3363E-04_JPRB,5.7118E-04_JPRB,3.7715E-04_JPRB/)
KBO( :, 5,57, 7) = (/&
&8.2558E-05_JPRB,1.6957E-04_JPRB,4.8458E-04_JPRB,5.8660E-04_JPRB,6.0854E-04_JPRB,3.8261E-04_JPRB/)
KBO( :, 1,58, 7) = (/&
&3.1595E-05_JPRB,5.3251E-05_JPRB,2.4214E-04_JPRB,3.3220E-04_JPRB,3.7979E-04_JPRB,2.8893E-04_JPRB/)
KBO( :, 2,58, 7) = (/&
&3.6453E-05_JPRB,6.5530E-05_JPRB,2.7256E-04_JPRB,3.6744E-04_JPRB,4.1068E-04_JPRB,2.9670E-04_JPRB/)
KBO( :, 3,58, 7) = (/&
&4.3522E-05_JPRB,8.2522E-05_JPRB,3.0670E-04_JPRB,4.0362E-04_JPRB,4.4239E-04_JPRB,3.0276E-04_JPRB/)
KBO( :, 4,58, 7) = (/&
&5.3718E-05_JPRB,1.0672E-04_JPRB,3.4774E-04_JPRB,4.4273E-04_JPRB,4.7408E-04_JPRB,3.0780E-04_JPRB/)
KBO( :, 5,58, 7) = (/&
&6.7377E-05_JPRB,1.4070E-04_JPRB,4.0225E-04_JPRB,4.8863E-04_JPRB,5.0717E-04_JPRB,3.1234E-04_JPRB/)
KBO( :, 1,59, 7) = (/&
&2.6095E-05_JPRB,4.4557E-05_JPRB,2.0135E-04_JPRB,2.7586E-04_JPRB,3.1509E-04_JPRB,2.3542E-04_JPRB/)
KBO( :, 2,59, 7) = (/&
&3.0251E-05_JPRB,5.5296E-05_JPRB,2.2770E-04_JPRB,3.0652E-04_JPRB,3.4210E-04_JPRB,2.4160E-04_JPRB/)
KBO( :, 3,59, 7) = (/&
&3.6364E-05_JPRB,7.0315E-05_JPRB,2.5762E-04_JPRB,3.3839E-04_JPRB,3.7008E-04_JPRB,2.4615E-04_JPRB/)
KBO( :, 4,59, 7) = (/&
&4.5252E-05_JPRB,9.1955E-05_JPRB,2.9410E-04_JPRB,3.7318E-04_JPRB,3.9814E-04_JPRB,2.4968E-04_JPRB/)
KBO( :, 5,59, 7) = (/&
&5.7239E-05_JPRB,1.2271E-04_JPRB,3.4336E-04_JPRB,4.1464E-04_JPRB,4.2794E-04_JPRB,2.5280E-04_JPRB/)
KBO( :, 1,13, 8) = (/&
&3.0593E-01_JPRB,3.0601E-01_JPRB,5.8936E-01_JPRB,8.8205E-01_JPRB,1.0947E+00_JPRB,1.1943E+00_JPRB/)
KBO( :, 2,13, 8) = (/&
&3.0576E-01_JPRB,3.0585E-01_JPRB,5.8416E-01_JPRB,8.7445E-01_JPRB,1.0842E+00_JPRB,1.1946E+00_JPRB/)
KBO( :, 3,13, 8) = (/&
&3.0730E-01_JPRB,3.0739E-01_JPRB,5.7838E-01_JPRB,8.6622E-01_JPRB,1.0736E+00_JPRB,1.1941E+00_JPRB/)
KBO( :, 4,13, 8) = (/&
&3.1143E-01_JPRB,3.1153E-01_JPRB,5.7236E-01_JPRB,8.5664E-01_JPRB,1.0623E+00_JPRB,1.1926E+00_JPRB/)
KBO( :, 5,13, 8) = (/&
&3.1821E-01_JPRB,3.1830E-01_JPRB,5.6671E-01_JPRB,8.4589E-01_JPRB,1.0496E+00_JPRB,1.1883E+00_JPRB/)
KBO( :, 1,14, 8) = (/&
&2.6541E-01_JPRB,2.6552E-01_JPRB,5.8043E-01_JPRB,8.8352E-01_JPRB,1.1026E+00_JPRB,1.1931E+00_JPRB/)
KBO( :, 2,14, 8) = (/&
&2.6695E-01_JPRB,2.6706E-01_JPRB,5.7539E-01_JPRB,8.7778E-01_JPRB,1.0951E+00_JPRB,1.1937E+00_JPRB/)
KBO( :, 3,14, 8) = (/&
&2.7112E-01_JPRB,2.7123E-01_JPRB,5.7000E-01_JPRB,8.7108E-01_JPRB,1.0869E+00_JPRB,1.1910E+00_JPRB/)
KBO( :, 4,14, 8) = (/&
&2.7807E-01_JPRB,2.7818E-01_JPRB,5.6514E-01_JPRB,8.6271E-01_JPRB,1.0767E+00_JPRB,1.1867E+00_JPRB/)
KBO( :, 5,14, 8) = (/&
&2.8739E-01_JPRB,2.8751E-01_JPRB,5.6126E-01_JPRB,8.5280E-01_JPRB,1.0643E+00_JPRB,1.1809E+00_JPRB/)
KBO( :, 1,15, 8) = (/&
&2.3178E-01_JPRB,2.3191E-01_JPRB,5.7184E-01_JPRB,8.7693E-01_JPRB,1.1022E+00_JPRB,1.1813E+00_JPRB/)
KBO( :, 2,15, 8) = (/&
&2.3560E-01_JPRB,2.3573E-01_JPRB,5.6724E-01_JPRB,8.7349E-01_JPRB,1.0976E+00_JPRB,1.1800E+00_JPRB/)
KBO( :, 3,15, 8) = (/&
&2.4219E-01_JPRB,2.4233E-01_JPRB,5.6272E-01_JPRB,8.6826E-01_JPRB,1.0904E+00_JPRB,1.1766E+00_JPRB/)
KBO( :, 4,15, 8) = (/&
&2.5074E-01_JPRB,2.5088E-01_JPRB,5.5919E-01_JPRB,8.6097E-01_JPRB,1.0807E+00_JPRB,1.1720E+00_JPRB/)
KBO( :, 5,15, 8) = (/&
&2.6000E-01_JPRB,2.6013E-01_JPRB,5.5698E-01_JPRB,8.5261E-01_JPRB,1.0688E+00_JPRB,1.1657E+00_JPRB/)
KBO( :, 1,16, 8) = (/&
&2.0414E-01_JPRB,2.0429E-01_JPRB,5.5967E-01_JPRB,8.6370E-01_JPRB,1.0904E+00_JPRB,1.1562E+00_JPRB/)
KBO( :, 2,16, 8) = (/&
&2.1009E-01_JPRB,2.1024E-01_JPRB,5.5625E-01_JPRB,8.6141E-01_JPRB,1.0865E+00_JPRB,1.1558E+00_JPRB/)
KBO( :, 3,16, 8) = (/&
&2.1753E-01_JPRB,2.1768E-01_JPRB,5.5355E-01_JPRB,8.5657E-01_JPRB,1.0800E+00_JPRB,1.1537E+00_JPRB/)
KBO( :, 4,16, 8) = (/&
&2.2581E-01_JPRB,2.2595E-01_JPRB,5.5210E-01_JPRB,8.5071E-01_JPRB,1.0712E+00_JPRB,1.1497E+00_JPRB/)
KBO( :, 5,16, 8) = (/&
&2.3451E-01_JPRB,2.3466E-01_JPRB,5.5166E-01_JPRB,8.4445E-01_JPRB,1.0599E+00_JPRB,1.1442E+00_JPRB/)
KBO( :, 1,17, 8) = (/&
&1.8111E-01_JPRB,1.8127E-01_JPRB,5.4370E-01_JPRB,8.4066E-01_JPRB,1.0633E+00_JPRB,1.1173E+00_JPRB/)
KBO( :, 2,17, 8) = (/&
&1.8751E-01_JPRB,1.8767E-01_JPRB,5.4225E-01_JPRB,8.3870E-01_JPRB,1.0603E+00_JPRB,1.1188E+00_JPRB/)
KBO( :, 3,17, 8) = (/&
&1.9478E-01_JPRB,1.9494E-01_JPRB,5.4182E-01_JPRB,8.3528E-01_JPRB,1.0547E+00_JPRB,1.1179E+00_JPRB/)
KBO( :, 4,17, 8) = (/&
&2.0226E-01_JPRB,2.0242E-01_JPRB,5.4242E-01_JPRB,8.3135E-01_JPRB,1.0462E+00_JPRB,1.1153E+00_JPRB/)
KBO( :, 5,17, 8) = (/&
&2.0977E-01_JPRB,2.0992E-01_JPRB,5.4408E-01_JPRB,8.2665E-01_JPRB,1.0353E+00_JPRB,1.1109E+00_JPRB/)
KBO( :, 1,18, 8) = (/&
&1.6037E-01_JPRB,1.6054E-01_JPRB,5.2354E-01_JPRB,8.0743E-01_JPRB,1.0214E+00_JPRB,1.0665E+00_JPRB/)
KBO( :, 2,18, 8) = (/&
&1.6652E-01_JPRB,1.6669E-01_JPRB,5.2468E-01_JPRB,8.0676E-01_JPRB,1.0196E+00_JPRB,1.0692E+00_JPRB/)
KBO( :, 3,18, 8) = (/&
&1.7290E-01_JPRB,1.7307E-01_JPRB,5.2655E-01_JPRB,8.0477E-01_JPRB,1.0147E+00_JPRB,1.0691E+00_JPRB/)
KBO( :, 4,18, 8) = (/&
&1.7934E-01_JPRB,1.7951E-01_JPRB,5.2943E-01_JPRB,8.0251E-01_JPRB,1.0069E+00_JPRB,1.0675E+00_JPRB/)
KBO( :, 5,18, 8) = (/&
&1.8580E-01_JPRB,1.8596E-01_JPRB,5.3218E-01_JPRB,7.9996E-01_JPRB,9.9675E-01_JPRB,1.0641E+00_JPRB/)
KBO( :, 1,19, 8) = (/&
&1.4147E-01_JPRB,1.4165E-01_JPRB,4.9931E-01_JPRB,7.6579E-01_JPRB,9.6706E-01_JPRB,1.0036E+00_JPRB/)
KBO( :, 2,19, 8) = (/&
&1.4680E-01_JPRB,1.4699E-01_JPRB,5.0235E-01_JPRB,7.6624E-01_JPRB,9.6598E-01_JPRB,1.0066E+00_JPRB/)
KBO( :, 3,19, 8) = (/&
&1.5225E-01_JPRB,1.5244E-01_JPRB,5.0654E-01_JPRB,7.6618E-01_JPRB,9.6124E-01_JPRB,1.0077E+00_JPRB/)
KBO( :, 4,19, 8) = (/&
&1.5772E-01_JPRB,1.5791E-01_JPRB,5.1074E-01_JPRB,7.6598E-01_JPRB,9.5363E-01_JPRB,1.0072E+00_JPRB/)
KBO( :, 5,19, 8) = (/&
&1.6330E-01_JPRB,1.6348E-01_JPRB,5.1433E-01_JPRB,7.6482E-01_JPRB,9.4459E-01_JPRB,1.0048E+00_JPRB/)
KBO( :, 1,20, 8) = (/&
&1.2415E-01_JPRB,1.2435E-01_JPRB,4.7152E-01_JPRB,7.1700E-01_JPRB,9.0180E-01_JPRB,9.3194E-01_JPRB/)
KBO( :, 2,20, 8) = (/&
&1.2873E-01_JPRB,1.2894E-01_JPRB,4.7682E-01_JPRB,7.1874E-01_JPRB,9.0028E-01_JPRB,9.3593E-01_JPRB/)
KBO( :, 3,20, 8) = (/&
&1.3332E-01_JPRB,1.3352E-01_JPRB,4.8227E-01_JPRB,7.2020E-01_JPRB,8.9592E-01_JPRB,9.3812E-01_JPRB/)
KBO( :, 4,20, 8) = (/&
&1.3806E-01_JPRB,1.3826E-01_JPRB,4.8689E-01_JPRB,7.2110E-01_JPRB,8.9003E-01_JPRB,9.3865E-01_JPRB/)
KBO( :, 5,20, 8) = (/&
&1.4304E-01_JPRB,1.4323E-01_JPRB,4.9097E-01_JPRB,7.2157E-01_JPRB,8.8366E-01_JPRB,9.3774E-01_JPRB/)
KBO( :, 1,21, 8) = (/&
&1.0824E-01_JPRB,1.0845E-01_JPRB,4.4084E-01_JPRB,6.6237E-01_JPRB,8.2840E-01_JPRB,8.5416E-01_JPRB/)
KBO( :, 2,21, 8) = (/&
&1.1215E-01_JPRB,1.1237E-01_JPRB,4.4741E-01_JPRB,6.6560E-01_JPRB,8.2721E-01_JPRB,8.5880E-01_JPRB/)
KBO( :, 3,21, 8) = (/&
&1.1610E-01_JPRB,1.1631E-01_JPRB,4.5328E-01_JPRB,6.6844E-01_JPRB,8.2433E-01_JPRB,8.6217E-01_JPRB/)
KBO( :, 4,21, 8) = (/&
&1.2031E-01_JPRB,1.2052E-01_JPRB,4.5831E-01_JPRB,6.7112E-01_JPRB,8.2101E-01_JPRB,8.6470E-01_JPRB/)
KBO( :, 5,21, 8) = (/&
&1.2513E-01_JPRB,1.2535E-01_JPRB,4.6228E-01_JPRB,6.7321E-01_JPRB,8.1773E-01_JPRB,8.6681E-01_JPRB/)
KBO( :, 1,22, 8) = (/&
&9.4136E-02_JPRB,9.4356E-02_JPRB,4.0812E-01_JPRB,6.0557E-01_JPRB,7.5102E-01_JPRB,7.7334E-01_JPRB/)
KBO( :, 2,22, 8) = (/&
&9.7453E-02_JPRB,9.7680E-02_JPRB,4.1479E-01_JPRB,6.0994E-01_JPRB,7.5090E-01_JPRB,7.7909E-01_JPRB/)
KBO( :, 3,22, 8) = (/&
&1.0097E-01_JPRB,1.0120E-01_JPRB,4.2075E-01_JPRB,6.1446E-01_JPRB,7.5039E-01_JPRB,7.8458E-01_JPRB/)
KBO( :, 4,22, 8) = (/&
&1.0505E-01_JPRB,1.0527E-01_JPRB,4.2583E-01_JPRB,6.1845E-01_JPRB,7.5036E-01_JPRB,7.8977E-01_JPRB/)
KBO( :, 5,22, 8) = (/&
&1.0993E-01_JPRB,1.1016E-01_JPRB,4.2991E-01_JPRB,6.2156E-01_JPRB,7.5073E-01_JPRB,7.9510E-01_JPRB/)
KBO( :, 1,23, 8) = (/&
&8.1349E-02_JPRB,8.1584E-02_JPRB,3.7354E-01_JPRB,5.4796E-01_JPRB,6.7356E-01_JPRB,6.9291E-01_JPRB/)
KBO( :, 2,23, 8) = (/&
&8.4276E-02_JPRB,8.4510E-02_JPRB,3.8021E-01_JPRB,5.5386E-01_JPRB,6.7570E-01_JPRB,7.0065E-01_JPRB/)
KBO( :, 3,23, 8) = (/&
&8.7640E-02_JPRB,8.7874E-02_JPRB,3.8598E-01_JPRB,5.5948E-01_JPRB,6.7838E-01_JPRB,7.0844E-01_JPRB/)
KBO( :, 4,23, 8) = (/&
&9.1780E-02_JPRB,9.2021E-02_JPRB,3.9102E-01_JPRB,5.6473E-01_JPRB,6.8175E-01_JPRB,7.1651E-01_JPRB/)
KBO( :, 5,23, 8) = (/&
&9.6686E-02_JPRB,9.6939E-02_JPRB,3.9533E-01_JPRB,5.6950E-01_JPRB,6.8602E-01_JPRB,7.2456E-01_JPRB/)
KBO( :, 1,24, 8) = (/&
&6.9990E-02_JPRB,7.0237E-02_JPRB,3.3858E-01_JPRB,4.9217E-01_JPRB,5.9977E-01_JPRB,6.1602E-01_JPRB/)
KBO( :, 2,24, 8) = (/&
&7.2713E-02_JPRB,7.2959E-02_JPRB,3.4483E-01_JPRB,4.9901E-01_JPRB,6.0467E-01_JPRB,6.2572E-01_JPRB/)
KBO( :, 3,24, 8) = (/&
&7.6092E-02_JPRB,7.6339E-02_JPRB,3.5052E-01_JPRB,5.0586E-01_JPRB,6.1039E-01_JPRB,6.3593E-01_JPRB/)
KBO( :, 4,24, 8) = (/&
&8.0272E-02_JPRB,8.0531E-02_JPRB,3.5585E-01_JPRB,5.1250E-01_JPRB,6.1729E-01_JPRB,6.4602E-01_JPRB/)
KBO( :, 5,24, 8) = (/&
&8.5043E-02_JPRB,8.5307E-02_JPRB,3.6095E-01_JPRB,5.1914E-01_JPRB,6.2467E-01_JPRB,6.5479E-01_JPRB/)
KBO( :, 1,25, 8) = (/&
&6.0058E-02_JPRB,6.0325E-02_JPRB,3.0404E-01_JPRB,4.3931E-01_JPRB,5.3180E-01_JPRB,5.4488E-01_JPRB/)
KBO( :, 2,25, 8) = (/&
&6.2808E-02_JPRB,6.3070E-02_JPRB,3.1019E-01_JPRB,4.4720E-01_JPRB,5.3927E-01_JPRB,5.5647E-01_JPRB/)
KBO( :, 3,25, 8) = (/&
&6.6253E-02_JPRB,6.6517E-02_JPRB,3.1620E-01_JPRB,4.5515E-01_JPRB,5.4804E-01_JPRB,5.6793E-01_JPRB/)
KBO( :, 4,25, 8) = (/&
&7.0286E-02_JPRB,7.0564E-02_JPRB,3.2210E-01_JPRB,4.6317E-01_JPRB,5.5729E-01_JPRB,5.7748E-01_JPRB/)
KBO( :, 5,25, 8) = (/&
&7.4631E-02_JPRB,7.4904E-02_JPRB,3.2818E-01_JPRB,4.7084E-01_JPRB,5.6535E-01_JPRB,5.8428E-01_JPRB/)
KBO( :, 1,26, 8) = (/&
&5.1659E-02_JPRB,5.1968E-02_JPRB,2.7136E-01_JPRB,3.9044E-01_JPRB,4.7061E-01_JPRB,4.8066E-01_JPRB/)
KBO( :, 2,26, 8) = (/&
&5.4454E-02_JPRB,5.4749E-02_JPRB,2.7780E-01_JPRB,3.9925E-01_JPRB,4.8060E-01_JPRB,4.9280E-01_JPRB/)
KBO( :, 3,26, 8) = (/&
&5.7864E-02_JPRB,5.8160E-02_JPRB,2.8427E-01_JPRB,4.0818E-01_JPRB,4.9092E-01_JPRB,5.0289E-01_JPRB/)
KBO( :, 4,26, 8) = (/&
&6.1551E-02_JPRB,6.1849E-02_JPRB,2.9095E-01_JPRB,4.1685E-01_JPRB,4.9998E-01_JPRB,5.1033E-01_JPRB/)
KBO( :, 5,26, 8) = (/&
&6.5434E-02_JPRB,6.5724E-02_JPRB,2.9806E-01_JPRB,4.2453E-01_JPRB,5.0716E-01_JPRB,5.1469E-01_JPRB/)
KBO( :, 1,27, 8) = (/&
&4.4574E-02_JPRB,4.4959E-02_JPRB,2.4126E-01_JPRB,3.4609E-01_JPRB,4.1629E-01_JPRB,4.2248E-01_JPRB/)
KBO( :, 2,27, 8) = (/&
&4.7372E-02_JPRB,4.7727E-02_JPRB,2.4803E-01_JPRB,3.5548E-01_JPRB,4.2721E-01_JPRB,4.3291E-01_JPRB/)
KBO( :, 3,27, 8) = (/&
&5.0509E-02_JPRB,5.0855E-02_JPRB,2.5505E-01_JPRB,3.6464E-01_JPRB,4.3687E-01_JPRB,4.4067E-01_JPRB/)
KBO( :, 4,27, 8) = (/&
&5.3857E-02_JPRB,5.4187E-02_JPRB,2.6242E-01_JPRB,3.7281E-01_JPRB,4.4478E-01_JPRB,4.4531E-01_JPRB/)
KBO( :, 5,27, 8) = (/&
&5.7275E-02_JPRB,5.7589E-02_JPRB,2.7029E-01_JPRB,3.7997E-01_JPRB,4.5055E-01_JPRB,4.4651E-01_JPRB/)
KBO( :, 1,28, 8) = (/&
&3.8595E-02_JPRB,3.9083E-02_JPRB,2.1409E-01_JPRB,3.0626E-01_JPRB,3.6758E-01_JPRB,3.6870E-01_JPRB/)
KBO( :, 2,28, 8) = (/&
&4.1250E-02_JPRB,4.1701E-02_JPRB,2.2115E-01_JPRB,3.1552E-01_JPRB,3.7756E-01_JPRB,3.7664E-01_JPRB/)
KBO( :, 3,28, 8) = (/&
&4.4090E-02_JPRB,4.4510E-02_JPRB,2.2858E-01_JPRB,3.2391E-01_JPRB,3.8579E-01_JPRB,3.8144E-01_JPRB/)
KBO( :, 4,28, 8) = (/&
&4.7006E-02_JPRB,4.7391E-02_JPRB,2.3638E-01_JPRB,3.3136E-01_JPRB,3.9193E-01_JPRB,3.8299E-01_JPRB/)
KBO( :, 5,28, 8) = (/&
&5.0054E-02_JPRB,5.0402E-02_JPRB,2.4452E-01_JPRB,3.3791E-01_JPRB,3.9580E-01_JPRB,3.8186E-01_JPRB/)
KBO( :, 1,29, 8) = (/&
&3.3476E-02_JPRB,3.4098E-02_JPRB,1.8985E-01_JPRB,2.7044E-01_JPRB,3.2310E-01_JPRB,3.1910E-01_JPRB/)
KBO( :, 2,29, 8) = (/&
&3.5905E-02_JPRB,3.6473E-02_JPRB,1.9710E-01_JPRB,2.7881E-01_JPRB,3.3147E-01_JPRB,3.2409E-01_JPRB/)
KBO( :, 3,29, 8) = (/&
&3.8420E-02_JPRB,3.8933E-02_JPRB,2.0468E-01_JPRB,2.8629E-01_JPRB,3.3775E-01_JPRB,3.2611E-01_JPRB/)
KBO( :, 4,29, 8) = (/&
&4.1043E-02_JPRB,4.1502E-02_JPRB,2.1261E-01_JPRB,2.9284E-01_JPRB,3.4187E-01_JPRB,3.2584E-01_JPRB/)
KBO( :, 5,29, 8) = (/&
&4.3764E-02_JPRB,4.4163E-02_JPRB,2.2069E-01_JPRB,2.9879E-01_JPRB,3.4414E-01_JPRB,3.2382E-01_JPRB/)
KBO( :, 1,30, 8) = (/&
&2.9059E-02_JPRB,2.9833E-02_JPRB,1.6831E-01_JPRB,2.3789E-01_JPRB,2.8228E-01_JPRB,2.7330E-01_JPRB/)
KBO( :, 2,30, 8) = (/&
&3.1236E-02_JPRB,3.1934E-02_JPRB,1.7554E-01_JPRB,2.4524E-01_JPRB,2.8861E-01_JPRB,2.7583E-01_JPRB/)
KBO( :, 3,30, 8) = (/&
&3.3473E-02_JPRB,3.4095E-02_JPRB,1.8314E-01_JPRB,2.5166E-01_JPRB,2.9297E-01_JPRB,2.7628E-01_JPRB/)
KBO( :, 4,30, 8) = (/&
&3.5829E-02_JPRB,3.6370E-02_JPRB,1.9099E-01_JPRB,2.5743E-01_JPRB,2.9573E-01_JPRB,2.7526E-01_JPRB/)
KBO( :, 5,30, 8) = (/&
&3.8342E-02_JPRB,3.8806E-02_JPRB,1.9889E-01_JPRB,2.6291E-01_JPRB,2.9753E-01_JPRB,2.7308E-01_JPRB/)
KBO( :, 1,31, 8) = (/&
&2.5215E-02_JPRB,2.6144E-02_JPRB,1.4919E-01_JPRB,2.0841E-01_JPRB,2.4479E-01_JPRB,2.3198E-01_JPRB/)
KBO( :, 2,31, 8) = (/&
&2.7144E-02_JPRB,2.7979E-02_JPRB,1.5634E-01_JPRB,2.1462E-01_JPRB,2.4940E-01_JPRB,2.3311E-01_JPRB/)
KBO( :, 3,31, 8) = (/&
&2.9169E-02_JPRB,2.9907E-02_JPRB,1.6380E-01_JPRB,2.2020E-01_JPRB,2.5250E-01_JPRB,2.3291E-01_JPRB/)
KBO( :, 4,31, 8) = (/&
&3.1339E-02_JPRB,3.1975E-02_JPRB,1.7145E-01_JPRB,2.2560E-01_JPRB,2.5484E-01_JPRB,2.3169E-01_JPRB/)
KBO( :, 5,31, 8) = (/&
&3.3710E-02_JPRB,3.4248E-02_JPRB,1.7897E-01_JPRB,2.3122E-01_JPRB,2.5681E-01_JPRB,2.2968E-01_JPRB/)
KBO( :, 1,32, 8) = (/&
&2.1908E-02_JPRB,2.2988E-02_JPRB,1.3234E-01_JPRB,1.8179E-01_JPRB,2.1098E-01_JPRB,1.9567E-01_JPRB/)
KBO( :, 2,32, 8) = (/&
&2.3644E-02_JPRB,2.4617E-02_JPRB,1.3932E-01_JPRB,1.8712E-01_JPRB,2.1438E-01_JPRB,1.9614E-01_JPRB/)
KBO( :, 3,32, 8) = (/&
&2.5493E-02_JPRB,2.6345E-02_JPRB,1.4655E-01_JPRB,1.9237E-01_JPRB,2.1705E-01_JPRB,1.9570E-01_JPRB/)
KBO( :, 4,32, 8) = (/&
&2.7518E-02_JPRB,2.8252E-02_JPRB,1.5380E-01_JPRB,1.9790E-01_JPRB,2.1948E-01_JPRB,1.9455E-01_JPRB/)
KBO( :, 5,32, 8) = (/&
&2.9773E-02_JPRB,3.0387E-02_JPRB,1.6098E-01_JPRB,2.0383E-01_JPRB,2.2190E-01_JPRB,1.9286E-01_JPRB/)
KBO( :, 1,33, 8) = (/&
&1.9045E-02_JPRB,2.0261E-02_JPRB,1.1752E-01_JPRB,1.5812E-01_JPRB,1.8110E-01_JPRB,1.6448E-01_JPRB/)
KBO( :, 2,33, 8) = (/&
&2.0626E-02_JPRB,2.1724E-02_JPRB,1.2423E-01_JPRB,1.6307E-01_JPRB,1.8397E-01_JPRB,1.6464E-01_JPRB/)
KBO( :, 3,33, 8) = (/&
&2.2336E-02_JPRB,2.3302E-02_JPRB,1.3114E-01_JPRB,1.6839E-01_JPRB,1.8664E-01_JPRB,1.6418E-01_JPRB/)
KBO( :, 4,33, 8) = (/&
&2.4266E-02_JPRB,2.5093E-02_JPRB,1.3811E-01_JPRB,1.7421E-01_JPRB,1.8938E-01_JPRB,1.6325E-01_JPRB/)
KBO( :, 5,33, 8) = (/&
&2.6466E-02_JPRB,2.7164E-02_JPRB,1.4513E-01_JPRB,1.8048E-01_JPRB,1.9238E-01_JPRB,1.6211E-01_JPRB/)
KBO( :, 1,34, 8) = (/&
&1.6556E-02_JPRB,1.7892E-02_JPRB,1.0429E-01_JPRB,1.3736E-01_JPRB,1.5516E-01_JPRB,1.3789E-01_JPRB/)
KBO( :, 2,34, 8) = (/&
&1.7996E-02_JPRB,1.9210E-02_JPRB,1.1072E-01_JPRB,1.4236E-01_JPRB,1.5794E-01_JPRB,1.3797E-01_JPRB/)
KBO( :, 3,34, 8) = (/&
&1.9608E-02_JPRB,2.0681E-02_JPRB,1.1739E-01_JPRB,1.4788E-01_JPRB,1.6081E-01_JPRB,1.3764E-01_JPRB/)
KBO( :, 4,34, 8) = (/&
&2.1464E-02_JPRB,2.2387E-02_JPRB,1.2421E-01_JPRB,1.5396E-01_JPRB,1.6395E-01_JPRB,1.3706E-01_JPRB/)
KBO( :, 5,34, 8) = (/&
&2.3594E-02_JPRB,2.4379E-02_JPRB,1.3126E-01_JPRB,1.6048E-01_JPRB,1.6756E-01_JPRB,1.3645E-01_JPRB/)
KBO( :, 1,35, 8) = (/&
&1.4319E-02_JPRB,1.5758E-02_JPRB,9.2204E-02_JPRB,1.1925E-01_JPRB,1.3286E-01_JPRB,1.1548E-01_JPRB/)
KBO( :, 2,35, 8) = (/&
&1.5652E-02_JPRB,1.6978E-02_JPRB,9.8399E-02_JPRB,1.2433E-01_JPRB,1.3567E-01_JPRB,1.1564E-01_JPRB/)
KBO( :, 3,35, 8) = (/&
&1.7169E-02_JPRB,1.8350E-02_JPRB,1.0487E-01_JPRB,1.3003E-01_JPRB,1.3879E-01_JPRB,1.1554E-01_JPRB/)
KBO( :, 4,35, 8) = (/&
&1.8944E-02_JPRB,1.9975E-02_JPRB,1.1167E-01_JPRB,1.3629E-01_JPRB,1.4236E-01_JPRB,1.1534E-01_JPRB/)
KBO( :, 5,35, 8) = (/&
&2.0938E-02_JPRB,2.1824E-02_JPRB,1.1877E-01_JPRB,1.4294E-01_JPRB,1.4651E-01_JPRB,1.1522E-01_JPRB/)
KBO( :, 1,36, 8) = (/&
&1.2304E-02_JPRB,1.3829E-02_JPRB,8.1120E-02_JPRB,1.0334E-01_JPRB,1.1366E-01_JPRB,9.6686E-02_JPRB/)
KBO( :, 2,36, 8) = (/&
&1.3517E-02_JPRB,1.4942E-02_JPRB,8.7082E-02_JPRB,1.0850E-01_JPRB,1.1660E-01_JPRB,9.6981E-02_JPRB/)
KBO( :, 3,36, 8) = (/&
&1.4939E-02_JPRB,1.6232E-02_JPRB,9.3439E-02_JPRB,1.1431E-01_JPRB,1.1995E-01_JPRB,9.7085E-02_JPRB/)
KBO( :, 4,36, 8) = (/&
&1.6604E-02_JPRB,1.7754E-02_JPRB,1.0020E-01_JPRB,1.2061E-01_JPRB,1.2384E-01_JPRB,9.7245E-02_JPRB/)
KBO( :, 5,36, 8) = (/&
&1.8458E-02_JPRB,1.9458E-02_JPRB,1.0732E-01_JPRB,1.2741E-01_JPRB,1.2840E-01_JPRB,9.7611E-02_JPRB/)
KBO( :, 1,37, 8) = (/&
&1.0441E-02_JPRB,1.2037E-02_JPRB,7.0733E-02_JPRB,8.9104E-02_JPRB,9.7006E-02_JPRB,8.0853E-02_JPRB/)
KBO( :, 2,37, 8) = (/&
&1.1538E-02_JPRB,1.3055E-02_JPRB,7.6444E-02_JPRB,9.4227E-02_JPRB,1.0002E-01_JPRB,8.1261E-02_JPRB/)
KBO( :, 3,37, 8) = (/&
&1.2840E-02_JPRB,1.4247E-02_JPRB,8.2653E-02_JPRB,9.9992E-02_JPRB,1.0351E-01_JPRB,8.1587E-02_JPRB/)
KBO( :, 4,37, 8) = (/&
&1.4355E-02_JPRB,1.5634E-02_JPRB,8.9312E-02_JPRB,1.0629E-01_JPRB,1.0761E-01_JPRB,8.2022E-02_JPRB/)
KBO( :, 5,37, 8) = (/&
&1.6059E-02_JPRB,1.7188E-02_JPRB,9.6394E-02_JPRB,1.1316E-01_JPRB,1.1240E-01_JPRB,8.2731E-02_JPRB/)
KBO( :, 1,38, 8) = (/&
&8.8645E-03_JPRB,1.0501E-02_JPRB,6.1698E-02_JPRB,7.6908E-02_JPRB,8.2883E-02_JPRB,6.7642E-02_JPRB/)
KBO( :, 2,38, 8) = (/&
&9.8554E-03_JPRB,1.1441E-02_JPRB,6.7213E-02_JPRB,8.1954E-02_JPRB,8.5931E-02_JPRB,6.8150E-02_JPRB/)
KBO( :, 3,38, 8) = (/&
&1.1041E-02_JPRB,1.2540E-02_JPRB,7.3258E-02_JPRB,8.7642E-02_JPRB,8.9506E-02_JPRB,6.8667E-02_JPRB/)
KBO( :, 4,38, 8) = (/&
&1.2430E-02_JPRB,1.3817E-02_JPRB,7.9801E-02_JPRB,9.3936E-02_JPRB,9.3782E-02_JPRB,6.9339E-02_JPRB/)
KBO( :, 5,38, 8) = (/&
&1.3983E-02_JPRB,1.5235E-02_JPRB,8.6814E-02_JPRB,1.0083E-01_JPRB,9.8742E-02_JPRB,7.0319E-02_JPRB/)
KBO( :, 1,39, 8) = (/&
&7.5404E-03_JPRB,9.1874E-03_JPRB,5.3906E-02_JPRB,6.6495E-02_JPRB,7.0902E-02_JPRB,5.6657E-02_JPRB/)
KBO( :, 2,39, 8) = (/&
&8.4340E-03_JPRB,1.0061E-02_JPRB,5.9245E-02_JPRB,7.1435E-02_JPRB,7.3979E-02_JPRB,5.7261E-02_JPRB/)
KBO( :, 3,39, 8) = (/&
&9.5242E-03_JPRB,1.1089E-02_JPRB,6.5132E-02_JPRB,7.7048E-02_JPRB,7.7636E-02_JPRB,5.7943E-02_JPRB/)
KBO( :, 4,39, 8) = (/&
&1.0781E-02_JPRB,1.2259E-02_JPRB,7.1549E-02_JPRB,8.3326E-02_JPRB,8.2004E-02_JPRB,5.8823E-02_JPRB/)
KBO( :, 5,39, 8) = (/&
&1.2213E-02_JPRB,1.3570E-02_JPRB,7.8488E-02_JPRB,9.0234E-02_JPRB,8.7139E-02_JPRB,6.0045E-02_JPRB/)
KBO( :, 1,40, 8) = (/&
&6.3480E-03_JPRB,7.9841E-03_JPRB,4.6707E-02_JPRB,5.7154E-02_JPRB,6.0478E-02_JPRB,4.7309E-02_JPRB/)
KBO( :, 2,40, 8) = (/&
&7.1416E-03_JPRB,8.7876E-03_JPRB,5.1799E-02_JPRB,6.1892E-02_JPRB,6.3504E-02_JPRB,4.7969E-02_JPRB/)
KBO( :, 3,40, 8) = (/&
&8.1113E-03_JPRB,9.7274E-03_JPRB,5.7484E-02_JPRB,6.7350E-02_JPRB,6.7140E-02_JPRB,4.8718E-02_JPRB/)
KBO( :, 4,40, 8) = (/&
&9.2465E-03_JPRB,1.0801E-02_JPRB,6.3707E-02_JPRB,7.3511E-02_JPRB,7.1497E-02_JPRB,4.9676E-02_JPRB/)
KBO( :, 5,40, 8) = (/&
&1.0544E-02_JPRB,1.2001E-02_JPRB,7.0505E-02_JPRB,8.0368E-02_JPRB,7.6674E-02_JPRB,5.0981E-02_JPRB/)
KBO( :, 1,41, 8) = (/&
&5.3391E-03_JPRB,6.9383E-03_JPRB,4.0421E-02_JPRB,4.9104E-02_JPRB,5.1567E-02_JPRB,3.9495E-02_JPRB/)
KBO( :, 2,41, 8) = (/&
&6.0420E-03_JPRB,7.6785E-03_JPRB,4.5260E-02_JPRB,5.3617E-02_JPRB,5.4523E-02_JPRB,4.0174E-02_JPRB/)
KBO( :, 3,41, 8) = (/&
&6.9017E-03_JPRB,8.5389E-03_JPRB,5.0726E-02_JPRB,5.8886E-02_JPRB,5.8106E-02_JPRB,4.0950E-02_JPRB/)
KBO( :, 4,41, 8) = (/&
&7.9215E-03_JPRB,9.5281E-03_JPRB,5.6758E-02_JPRB,6.4894E-02_JPRB,6.2425E-02_JPRB,4.1953E-02_JPRB/)
KBO( :, 5,41, 8) = (/&
&9.0958E-03_JPRB,1.0632E-02_JPRB,6.3380E-02_JPRB,7.1665E-02_JPRB,6.7575E-02_JPRB,4.3294E-02_JPRB/)
KBO( :, 1,42, 8) = (/&
&4.4874E-03_JPRB,6.0277E-03_JPRB,3.4973E-02_JPRB,4.2181E-02_JPRB,4.3972E-02_JPRB,3.2976E-02_JPRB/)
KBO( :, 2,42, 8) = (/&
&5.1084E-03_JPRB,6.7117E-03_JPRB,3.9569E-02_JPRB,4.6481E-02_JPRB,4.6838E-02_JPRB,3.3656E-02_JPRB/)
KBO( :, 3,42, 8) = (/&
&5.8774E-03_JPRB,7.5092E-03_JPRB,4.4793E-02_JPRB,5.1534E-02_JPRB,5.0349E-02_JPRB,3.4440E-02_JPRB/)
KBO( :, 4,42, 8) = (/&
&6.7906E-03_JPRB,8.4227E-03_JPRB,5.0631E-02_JPRB,5.7384E-02_JPRB,5.4620E-02_JPRB,3.5462E-02_JPRB/)
KBO( :, 5,42, 8) = (/&
&7.8525E-03_JPRB,9.4467E-03_JPRB,5.7082E-02_JPRB,6.4044E-02_JPRB,5.9718E-02_JPRB,3.6824E-02_JPRB/)
KBO( :, 1,43, 8) = (/&
&3.7422E-03_JPRB,5.2033E-03_JPRB,3.0024E-02_JPRB,3.6022E-02_JPRB,3.7358E-02_JPRB,2.7486E-02_JPRB/)
KBO( :, 2,43, 8) = (/&
&4.2855E-03_JPRB,5.8316E-03_JPRB,3.4344E-02_JPRB,4.0070E-02_JPRB,4.0089E-02_JPRB,2.8154E-02_JPRB/)
KBO( :, 3,43, 8) = (/&
&4.9638E-03_JPRB,6.5666E-03_JPRB,3.9296E-02_JPRB,4.4870E-02_JPRB,4.3472E-02_JPRB,2.8929E-02_JPRB/)
KBO( :, 4,43, 8) = (/&
&5.7736E-03_JPRB,7.4071E-03_JPRB,4.4883E-02_JPRB,5.0478E-02_JPRB,4.7614E-02_JPRB,2.9920E-02_JPRB/)
KBO( :, 5,43, 8) = (/&
&6.7269E-03_JPRB,8.3547E-03_JPRB,5.1126E-02_JPRB,5.6946E-02_JPRB,5.2603E-02_JPRB,3.1259E-02_JPRB/)
KBO( :, 1,44, 8) = (/&
&3.1123E-03_JPRB,4.4787E-03_JPRB,2.5629E-02_JPRB,3.0645E-02_JPRB,3.1662E-02_JPRB,2.2891E-02_JPRB/)
KBO( :, 2,44, 8) = (/&
&3.5819E-03_JPRB,5.0510E-03_JPRB,2.9662E-02_JPRB,3.4404E-02_JPRB,3.4213E-02_JPRB,2.3525E-02_JPRB/)
KBO( :, 3,44, 8) = (/&
&4.1717E-03_JPRB,5.7219E-03_JPRB,3.4337E-02_JPRB,3.8941E-02_JPRB,3.7437E-02_JPRB,2.4274E-02_JPRB/)
KBO( :, 4,44, 8) = (/&
&4.8874E-03_JPRB,6.4997E-03_JPRB,3.9651E-02_JPRB,4.4278E-02_JPRB,4.1431E-02_JPRB,2.5229E-02_JPRB/)
KBO( :, 5,44, 8) = (/&
&5.7377E-03_JPRB,7.3726E-03_JPRB,4.5649E-02_JPRB,5.0511E-02_JPRB,4.6265E-02_JPRB,2.6526E-02_JPRB/)
KBO( :, 1,45, 8) = (/&
&2.5853E-03_JPRB,3.8513E-03_JPRB,2.1823E-02_JPRB,2.6026E-02_JPRB,2.6804E-02_JPRB,1.9058E-02_JPRB/)
KBO( :, 2,45, 8) = (/&
&2.9888E-03_JPRB,4.3719E-03_JPRB,2.5563E-02_JPRB,2.9502E-02_JPRB,2.9182E-02_JPRB,1.9668E-02_JPRB/)
KBO( :, 3,45, 8) = (/&
&3.5037E-03_JPRB,4.9832E-03_JPRB,2.9957E-02_JPRB,3.3763E-02_JPRB,3.2213E-02_JPRB,2.0379E-02_JPRB/)
KBO( :, 4,45, 8) = (/&
&4.1322E-03_JPRB,5.6995E-03_JPRB,3.5000E-02_JPRB,3.8824E-02_JPRB,3.6032E-02_JPRB,2.1286E-02_JPRB/)
KBO( :, 5,45, 8) = (/&
&4.8892E-03_JPRB,6.5060E-03_JPRB,4.0741E-02_JPRB,4.4793E-02_JPRB,4.0699E-02_JPRB,2.2533E-02_JPRB/)
KBO( :, 1,46, 8) = (/&
&2.1331E-03_JPRB,3.2909E-03_JPRB,1.8461E-02_JPRB,2.1996E-02_JPRB,2.2623E-02_JPRB,1.5851E-02_JPRB/)
KBO( :, 2,46, 8) = (/&
&2.4815E-03_JPRB,3.7686E-03_JPRB,2.1893E-02_JPRB,2.5181E-02_JPRB,2.4805E-02_JPRB,1.6418E-02_JPRB/)
KBO( :, 3,46, 8) = (/&
&2.9255E-03_JPRB,4.3224E-03_JPRB,2.5992E-02_JPRB,2.9135E-02_JPRB,2.7620E-02_JPRB,1.7082E-02_JPRB/)
KBO( :, 4,46, 8) = (/&
&3.4773E-03_JPRB,4.9794E-03_JPRB,3.0754E-02_JPRB,3.3905E-02_JPRB,3.1233E-02_JPRB,1.7942E-02_JPRB/)
KBO( :, 5,46, 8) = (/&
&4.1439E-03_JPRB,5.7240E-03_JPRB,3.6209E-02_JPRB,3.9579E-02_JPRB,3.5705E-02_JPRB,1.9124E-02_JPRB/)
KBO( :, 1,47, 8) = (/&
&1.7489E-03_JPRB,2.7917E-03_JPRB,1.5439E-02_JPRB,1.8422E-02_JPRB,1.8978E-02_JPRB,1.3134E-02_JPRB/)
KBO( :, 2,47, 8) = (/&
&2.0428E-03_JPRB,3.2234E-03_JPRB,1.8541E-02_JPRB,2.1302E-02_JPRB,2.0952E-02_JPRB,1.3661E-02_JPRB/)
KBO( :, 3,47, 8) = (/&
&2.4192E-03_JPRB,3.7223E-03_JPRB,2.2314E-02_JPRB,2.4927E-02_JPRB,2.3525E-02_JPRB,1.4273E-02_JPRB/)
KBO( :, 4,47, 8) = (/&
&2.8969E-03_JPRB,4.3171E-03_JPRB,2.6764E-02_JPRB,2.9356E-02_JPRB,2.6874E-02_JPRB,1.5058E-02_JPRB/)
KBO( :, 5,47, 8) = (/&
&3.4807E-03_JPRB,5.0006E-03_JPRB,3.1906E-02_JPRB,3.4693E-02_JPRB,3.1094E-02_JPRB,1.6142E-02_JPRB/)
KBO( :, 1,48, 8) = (/&
&1.4327E-03_JPRB,2.3618E-03_JPRB,1.2851E-02_JPRB,1.5372E-02_JPRB,1.5885E-02_JPRB,1.0883E-02_JPRB/)
KBO( :, 2,48, 8) = (/&
&1.6785E-03_JPRB,2.7495E-03_JPRB,1.5626E-02_JPRB,1.7950E-02_JPRB,1.7654E-02_JPRB,1.1366E-02_JPRB/)
KBO( :, 3,48, 8) = (/&
&1.9967E-03_JPRB,3.1986E-03_JPRB,1.9069E-02_JPRB,2.1252E-02_JPRB,1.9987E-02_JPRB,1.1922E-02_JPRB/)
KBO( :, 4,48, 8) = (/&
&2.4067E-03_JPRB,3.7350E-03_JPRB,2.3203E-02_JPRB,2.5339E-02_JPRB,2.3066E-02_JPRB,1.2640E-02_JPRB/)
KBO( :, 5,48, 8) = (/&
&2.9156E-03_JPRB,4.3597E-03_JPRB,2.8035E-02_JPRB,3.0335E-02_JPRB,2.7010E-02_JPRB,1.3635E-02_JPRB/)
KBO( :, 1,49, 8) = (/&
&1.1689E-03_JPRB,1.9883E-03_JPRB,1.0644E-02_JPRB,1.2774E-02_JPRB,1.3257E-02_JPRB,9.0102E-03_JPRB/)
KBO( :, 2,49, 8) = (/&
&1.3778E-03_JPRB,2.3380E-03_JPRB,1.3100E-02_JPRB,1.5054E-02_JPRB,1.4830E-02_JPRB,9.4528E-03_JPRB/)
KBO( :, 3,49, 8) = (/&
&1.6437E-03_JPRB,2.7417E-03_JPRB,1.6213E-02_JPRB,1.8042E-02_JPRB,1.6928E-02_JPRB,9.9612E-03_JPRB/)
KBO( :, 4,49, 8) = (/&
&1.9940E-03_JPRB,3.2236E-03_JPRB,2.0024E-02_JPRB,2.1800E-02_JPRB,1.9739E-02_JPRB,1.0620E-02_JPRB/)
KBO( :, 5,49, 8) = (/&
&2.4346E-03_JPRB,3.7942E-03_JPRB,2.4548E-02_JPRB,2.6440E-02_JPRB,2.3396E-02_JPRB,1.1534E-02_JPRB/)
KBO( :, 1,50, 8) = (/&
&9.5607E-04_JPRB,1.6753E-03_JPRB,8.8167E-03_JPRB,1.0612E-02_JPRB,1.1052E-02_JPRB,7.4373E-03_JPRB/)
KBO( :, 2,50, 8) = (/&
&1.1316E-03_JPRB,1.9897E-03_JPRB,1.0983E-02_JPRB,1.2621E-02_JPRB,1.2456E-02_JPRB,7.8368E-03_JPRB/)
KBO( :, 3,50, 8) = (/&
&1.3565E-03_JPRB,2.3537E-03_JPRB,1.3790E-02_JPRB,1.5320E-02_JPRB,1.4346E-02_JPRB,8.2918E-03_JPRB/)
KBO( :, 4,50, 8) = (/&
&1.6563E-03_JPRB,2.7888E-03_JPRB,1.7295E-02_JPRB,1.8780E-02_JPRB,1.6915E-02_JPRB,8.8832E-03_JPRB/)
KBO( :, 5,50, 8) = (/&
&2.0379E-03_JPRB,3.3085E-03_JPRB,2.1524E-02_JPRB,2.3092E-02_JPRB,2.0305E-02_JPRB,9.7144E-03_JPRB/)
KBO( :, 1,51, 8) = (/&
&7.8250E-04_JPRB,1.4092E-03_JPRB,7.2896E-03_JPRB,8.7965E-03_JPRB,9.1930E-03_JPRB,6.1252E-03_JPRB/)
KBO( :, 2,51, 8) = (/&
&9.2963E-04_JPRB,1.6917E-03_JPRB,9.1856E-03_JPRB,1.0556E-02_JPRB,1.0442E-02_JPRB,6.4818E-03_JPRB/)
KBO( :, 3,51, 8) = (/&
&1.1199E-03_JPRB,2.0205E-03_JPRB,1.1706E-02_JPRB,1.2981E-02_JPRB,1.2146E-02_JPRB,6.8899E-03_JPRB/)
KBO( :, 4,51, 8) = (/&
&1.3754E-03_JPRB,2.4116E-03_JPRB,1.4910E-02_JPRB,1.6157E-02_JPRB,1.4484E-02_JPRB,7.4151E-03_JPRB/)
KBO( :, 5,51, 8) = (/&
&1.7057E-03_JPRB,2.8850E-03_JPRB,1.8848E-02_JPRB,2.0162E-02_JPRB,1.7617E-02_JPRB,8.1571E-03_JPRB/)
KBO( :, 1,52, 8) = (/&
&6.3740E-04_JPRB,1.1795E-03_JPRB,6.0058E-03_JPRB,7.2694E-03_JPRB,7.6231E-03_JPRB,5.0413E-03_JPRB/)
KBO( :, 2,52, 8) = (/&
&7.6292E-04_JPRB,1.4345E-03_JPRB,7.6473E-03_JPRB,8.7976E-03_JPRB,8.7274E-03_JPRB,5.3621E-03_JPRB/)
KBO( :, 3,52, 8) = (/&
&9.2276E-04_JPRB,1.7301E-03_JPRB,9.8884E-03_JPRB,1.0949E-02_JPRB,1.0250E-02_JPRB,5.7262E-03_JPRB/)
KBO( :, 4,52, 8) = (/&
&1.1390E-03_JPRB,2.0817E-03_JPRB,1.2797E-02_JPRB,1.3842E-02_JPRB,1.2367E-02_JPRB,6.1911E-03_JPRB/)
KBO( :, 5,52, 8) = (/&
&1.4240E-03_JPRB,2.5099E-03_JPRB,1.6438E-02_JPRB,1.7549E-02_JPRB,1.5248E-02_JPRB,6.8528E-03_JPRB/)
KBO( :, 1,53, 8) = (/&
&5.1732E-04_JPRB,9.8178E-04_JPRB,4.9291E-03_JPRB,5.9861E-03_JPRB,6.3013E-03_JPRB,4.1478E-03_JPRB/)
KBO( :, 2,53, 8) = (/&
&6.2319E-04_JPRB,1.2101E-03_JPRB,6.3342E-03_JPRB,7.2982E-03_JPRB,7.2668E-03_JPRB,4.4355E-03_JPRB/)
KBO( :, 3,53, 8) = (/&
&7.5896E-04_JPRB,1.4772E-03_JPRB,8.3073E-03_JPRB,9.1884E-03_JPRB,8.6166E-03_JPRB,4.7615E-03_JPRB/)
KBO( :, 4,53, 8) = (/&
&9.4032E-04_JPRB,1.7923E-03_JPRB,1.0926E-02_JPRB,1.1795E-02_JPRB,1.0522E-02_JPRB,5.1760E-03_JPRB/)
KBO( :, 5,53, 8) = (/&
&1.1855E-03_JPRB,2.1779E-03_JPRB,1.4267E-02_JPRB,1.5211E-02_JPRB,1.3151E-02_JPRB,5.7675E-03_JPRB/)
KBO( :, 1,54, 8) = (/&
&4.2099E-04_JPRB,8.1896E-04_JPRB,4.0587E-03_JPRB,4.9414E-03_JPRB,5.2122E-03_JPRB,3.3954E-03_JPRB/)
KBO( :, 2,54, 8) = (/&
&5.1072E-04_JPRB,1.0232E-03_JPRB,5.2659E-03_JPRB,6.0692E-03_JPRB,6.0577E-03_JPRB,3.6461E-03_JPRB/)
KBO( :, 3,54, 8) = (/&
&6.2630E-04_JPRB,1.2640E-03_JPRB,7.0010E-03_JPRB,7.7316E-03_JPRB,7.2545E-03_JPRB,3.9269E-03_JPRB/)
KBO( :, 4,54, 8) = (/&
&7.8065E-04_JPRB,1.5498E-03_JPRB,9.3602E-03_JPRB,1.0080E-02_JPRB,8.9779E-03_JPRB,4.2798E-03_JPRB/)
KBO( :, 5,54, 8) = (/&
&9.9133E-04_JPRB,1.8976E-03_JPRB,1.2427E-02_JPRB,1.3231E-02_JPRB,1.1388E-02_JPRB,4.7881E-03_JPRB/)
KBO( :, 1,55, 8) = (/&
&3.4264E-04_JPRB,6.8196E-04_JPRB,3.3418E-03_JPRB,4.0786E-03_JPRB,4.3077E-03_JPRB,2.7691E-03_JPRB/)
KBO( :, 2,55, 8) = (/&
&4.1827E-04_JPRB,8.6407E-04_JPRB,4.3772E-03_JPRB,5.0438E-03_JPRB,5.0439E-03_JPRB,2.9836E-03_JPRB/)
KBO( :, 3,55, 8) = (/&
&5.1651E-04_JPRB,1.0809E-03_JPRB,5.8977E-03_JPRB,6.5003E-03_JPRB,6.1007E-03_JPRB,3.2208E-03_JPRB/)
KBO( :, 4,55, 8) = (/&
&6.4755E-04_JPRB,1.3394E-03_JPRB,8.0143E-03_JPRB,8.6084E-03_JPRB,7.6585E-03_JPRB,3.5143E-03_JPRB/)
KBO( :, 5,55, 8) = (/&
&8.2913E-04_JPRB,1.6553E-03_JPRB,1.0821E-02_JPRB,1.1504E-02_JPRB,9.8668E-03_JPRB,3.9383E-03_JPRB/)
KBO( :, 1,56, 8) = (/&
&2.7803E-04_JPRB,5.6487E-04_JPRB,2.7420E-03_JPRB,3.3568E-03_JPRB,3.5496E-03_JPRB,2.2543E-03_JPRB/)
KBO( :, 2,56, 8) = (/&
&3.4121E-04_JPRB,7.2622E-04_JPRB,3.6228E-03_JPRB,4.1781E-03_JPRB,4.1862E-03_JPRB,2.4382E-03_JPRB/)
KBO( :, 3,56, 8) = (/&
&4.2449E-04_JPRB,9.2149E-04_JPRB,4.9469E-03_JPRB,5.4413E-03_JPRB,5.1116E-03_JPRB,2.6387E-03_JPRB/)
KBO( :, 4,56, 8) = (/&
&5.3591E-04_JPRB,1.1547E-03_JPRB,6.8316E-03_JPRB,7.3206E-03_JPRB,6.5078E-03_JPRB,2.8830E-03_JPRB/)
KBO( :, 5,56, 8) = (/&
&6.9206E-04_JPRB,1.4413E-03_JPRB,9.3865E-03_JPRB,9.9613E-03_JPRB,8.5223E-03_JPRB,3.2344E-03_JPRB/)
KBO( :, 1,57, 8) = (/&
&2.2504E-04_JPRB,4.6500E-04_JPRB,2.2403E-03_JPRB,2.7543E-03_JPRB,2.9166E-03_JPRB,1.8323E-03_JPRB/)
KBO( :, 2,57, 8) = (/&
&2.7798E-04_JPRB,6.0783E-04_JPRB,2.9851E-03_JPRB,3.4491E-03_JPRB,3.4628E-03_JPRB,1.9897E-03_JPRB/)
KBO( :, 3,57, 8) = (/&
&3.4753E-04_JPRB,7.8225E-04_JPRB,4.1312E-03_JPRB,4.5352E-03_JPRB,4.2657E-03_JPRB,2.1593E-03_JPRB/)
KBO( :, 4,57, 8) = (/&
&4.4202E-04_JPRB,9.9272E-04_JPRB,5.7973E-03_JPRB,6.1951E-03_JPRB,5.5060E-03_JPRB,2.3628E-03_JPRB/)
KBO( :, 5,57, 8) = (/&
&5.7558E-04_JPRB,1.2517E-03_JPRB,8.1058E-03_JPRB,8.5872E-03_JPRB,7.3360E-03_JPRB,2.6522E-03_JPRB/)
KBO( :, 1,58, 8) = (/&
&1.8228E-04_JPRB,3.8208E-04_JPRB,1.8308E-03_JPRB,2.2613E-03_JPRB,2.3970E-03_JPRB,1.4881E-03_JPRB/)
KBO( :, 2,58, 8) = (/&
&2.2635E-04_JPRB,5.0773E-04_JPRB,2.4625E-03_JPRB,2.8501E-03_JPRB,2.8647E-03_JPRB,1.6219E-03_JPRB/)
KBO( :, 3,58, 8) = (/&
&2.8516E-04_JPRB,6.6412E-04_JPRB,3.4519E-03_JPRB,3.7830E-03_JPRB,3.5592E-03_JPRB,1.7642E-03_JPRB/)
KBO( :, 4,58, 8) = (/&
&3.6538E-04_JPRB,8.5444E-04_JPRB,4.9230E-03_JPRB,5.2451E-03_JPRB,4.6580E-03_JPRB,1.9336E-03_JPRB/)
KBO( :, 5,58, 8) = (/&
&4.7911E-04_JPRB,1.0886E-03_JPRB,7.0070E-03_JPRB,7.4069E-03_JPRB,6.3208E-03_JPRB,2.1715E-03_JPRB/)
KBO( :, 1,59, 8) = (/&
&1.5316E-04_JPRB,3.3009E-04_JPRB,1.5697E-03_JPRB,1.9267E-03_JPRB,2.0287E-03_JPRB,1.2203E-03_JPRB/)
KBO( :, 2,59, 8) = (/&
&1.9174E-04_JPRB,4.4479E-04_JPRB,2.1483E-03_JPRB,2.4646E-03_JPRB,2.4521E-03_JPRB,1.3301E-03_JPRB/)
KBO( :, 3,59, 8) = (/&
&2.4392E-04_JPRB,5.8967E-04_JPRB,3.0690E-03_JPRB,3.3341E-03_JPRB,3.1017E-03_JPRB,1.4481E-03_JPRB/)
KBO( :, 4,59, 8) = (/&
&3.1594E-04_JPRB,7.6769E-04_JPRB,4.4545E-03_JPRB,4.7180E-03_JPRB,4.1523E-03_JPRB,1.5884E-03_JPRB/)
KBO( :, 5,59, 8) = (/&
&4.1934E-04_JPRB,9.8859E-04_JPRB,6.4430E-03_JPRB,6.7951E-03_JPRB,5.7622E-03_JPRB,1.7867E-03_JPRB/)
KBO( :, 1,13, 9) = (/&
&2.1640E+00_JPRB,2.1630E+00_JPRB,1.9037E+00_JPRB,1.9914E+00_JPRB,2.1507E+00_JPRB,2.1924E+00_JPRB/)
KBO( :, 2,13, 9) = (/&
&2.1780E+00_JPRB,2.1770E+00_JPRB,1.9043E+00_JPRB,1.9692E+00_JPRB,2.1183E+00_JPRB,2.1702E+00_JPRB/)
KBO( :, 3,13, 9) = (/&
&2.1863E+00_JPRB,2.1853E+00_JPRB,1.9004E+00_JPRB,1.9443E+00_JPRB,2.0822E+00_JPRB,2.1533E+00_JPRB/)
KBO( :, 4,13, 9) = (/&
&2.1908E+00_JPRB,2.1898E+00_JPRB,1.8939E+00_JPRB,1.9183E+00_JPRB,2.0440E+00_JPRB,2.1390E+00_JPRB/)
KBO( :, 5,13, 9) = (/&
&2.1905E+00_JPRB,2.1895E+00_JPRB,1.8836E+00_JPRB,1.8902E+00_JPRB,2.0042E+00_JPRB,2.1255E+00_JPRB/)
KBO( :, 1,14, 9) = (/&
&1.9847E+00_JPRB,1.9838E+00_JPRB,1.8303E+00_JPRB,2.0353E+00_JPRB,2.2590E+00_JPRB,2.3088E+00_JPRB/)
KBO( :, 2,14, 9) = (/&
&1.9934E+00_JPRB,1.9925E+00_JPRB,1.8250E+00_JPRB,2.0091E+00_JPRB,2.2231E+00_JPRB,2.2801E+00_JPRB/)
KBO( :, 3,14, 9) = (/&
&1.9976E+00_JPRB,1.9967E+00_JPRB,1.8170E+00_JPRB,1.9802E+00_JPRB,2.1840E+00_JPRB,2.2566E+00_JPRB/)
KBO( :, 4,14, 9) = (/&
&1.9974E+00_JPRB,1.9965E+00_JPRB,1.8053E+00_JPRB,1.9495E+00_JPRB,2.1431E+00_JPRB,2.2372E+00_JPRB/)
KBO( :, 5,14, 9) = (/&
&1.9939E+00_JPRB,1.9930E+00_JPRB,1.7904E+00_JPRB,1.9177E+00_JPRB,2.1004E+00_JPRB,2.2192E+00_JPRB/)
KBO( :, 1,15, 9) = (/&
&1.7889E+00_JPRB,1.7882E+00_JPRB,1.7547E+00_JPRB,2.0779E+00_JPRB,2.3573E+00_JPRB,2.4290E+00_JPRB/)
KBO( :, 2,15, 9) = (/&
&1.7928E+00_JPRB,1.7920E+00_JPRB,1.7452E+00_JPRB,2.0486E+00_JPRB,2.3189E+00_JPRB,2.4037E+00_JPRB/)
KBO( :, 3,15, 9) = (/&
&1.7928E+00_JPRB,1.7920E+00_JPRB,1.7330E+00_JPRB,2.0171E+00_JPRB,2.2790E+00_JPRB,2.3775E+00_JPRB/)
KBO( :, 4,15, 9) = (/&
&1.7917E+00_JPRB,1.7909E+00_JPRB,1.7182E+00_JPRB,1.9838E+00_JPRB,2.2366E+00_JPRB,2.3528E+00_JPRB/)
KBO( :, 5,15, 9) = (/&
&1.7907E+00_JPRB,1.7899E+00_JPRB,1.7010E+00_JPRB,1.9495E+00_JPRB,2.1934E+00_JPRB,2.3317E+00_JPRB/)
KBO( :, 1,16, 9) = (/&
&1.5869E+00_JPRB,1.5863E+00_JPRB,1.6883E+00_JPRB,2.1193E+00_JPRB,2.4455E+00_JPRB,2.5492E+00_JPRB/)
KBO( :, 2,16, 9) = (/&
&1.5874E+00_JPRB,1.5868E+00_JPRB,1.6750E+00_JPRB,2.0881E+00_JPRB,2.4087E+00_JPRB,2.5259E+00_JPRB/)
KBO( :, 3,16, 9) = (/&
&1.5879E+00_JPRB,1.5873E+00_JPRB,1.6596E+00_JPRB,2.0559E+00_JPRB,2.3694E+00_JPRB,2.5006E+00_JPRB/)
KBO( :, 4,16, 9) = (/&
&1.5893E+00_JPRB,1.5886E+00_JPRB,1.6420E+00_JPRB,2.0221E+00_JPRB,2.3275E+00_JPRB,2.4758E+00_JPRB/)
KBO( :, 5,16, 9) = (/&
&1.5915E+00_JPRB,1.5908E+00_JPRB,1.6225E+00_JPRB,1.9860E+00_JPRB,2.2837E+00_JPRB,2.4531E+00_JPRB/)
KBO( :, 1,17, 9) = (/&
&1.3911E+00_JPRB,1.3906E+00_JPRB,1.6357E+00_JPRB,2.1551E+00_JPRB,2.5270E+00_JPRB,2.6550E+00_JPRB/)
KBO( :, 2,17, 9) = (/&
&1.3924E+00_JPRB,1.3919E+00_JPRB,1.6197E+00_JPRB,2.1251E+00_JPRB,2.4914E+00_JPRB,2.6342E+00_JPRB/)
KBO( :, 3,17, 9) = (/&
&1.3948E+00_JPRB,1.3943E+00_JPRB,1.6016E+00_JPRB,2.0927E+00_JPRB,2.4529E+00_JPRB,2.6104E+00_JPRB/)
KBO( :, 4,17, 9) = (/&
&1.4001E+00_JPRB,1.3995E+00_JPRB,1.5824E+00_JPRB,2.0573E+00_JPRB,2.4118E+00_JPRB,2.5862E+00_JPRB/)
KBO( :, 5,17, 9) = (/&
&1.4089E+00_JPRB,1.4083E+00_JPRB,1.5632E+00_JPRB,2.0202E+00_JPRB,2.3685E+00_JPRB,2.5625E+00_JPRB/)
KBO( :, 1,18, 9) = (/&
&1.2109E+00_JPRB,1.2104E+00_JPRB,1.5964E+00_JPRB,2.1814E+00_JPRB,2.5952E+00_JPRB,2.7389E+00_JPRB/)
KBO( :, 2,18, 9) = (/&
&1.2140E+00_JPRB,1.2136E+00_JPRB,1.5784E+00_JPRB,2.1525E+00_JPRB,2.5616E+00_JPRB,2.7209E+00_JPRB/)
KBO( :, 3,18, 9) = (/&
&1.2208E+00_JPRB,1.2204E+00_JPRB,1.5595E+00_JPRB,2.1201E+00_JPRB,2.5247E+00_JPRB,2.7005E+00_JPRB/)
KBO( :, 4,18, 9) = (/&
&1.2322E+00_JPRB,1.2318E+00_JPRB,1.5407E+00_JPRB,2.0849E+00_JPRB,2.4850E+00_JPRB,2.6784E+00_JPRB/)
KBO( :, 5,18, 9) = (/&
&1.2477E+00_JPRB,1.2472E+00_JPRB,1.5230E+00_JPRB,2.0478E+00_JPRB,2.4440E+00_JPRB,2.6553E+00_JPRB/)
KBO( :, 1,19, 9) = (/&
&1.0487E+00_JPRB,1.0484E+00_JPRB,1.5649E+00_JPRB,2.1968E+00_JPRB,2.6409E+00_JPRB,2.7963E+00_JPRB/)
KBO( :, 2,19, 9) = (/&
&1.0560E+00_JPRB,1.0557E+00_JPRB,1.5474E+00_JPRB,2.1687E+00_JPRB,2.6108E+00_JPRB,2.7829E+00_JPRB/)
KBO( :, 3,19, 9) = (/&
&1.0685E+00_JPRB,1.0682E+00_JPRB,1.5292E+00_JPRB,2.1368E+00_JPRB,2.5782E+00_JPRB,2.7649E+00_JPRB/)
KBO( :, 4,19, 9) = (/&
&1.0859E+00_JPRB,1.0855E+00_JPRB,1.5121E+00_JPRB,2.1019E+00_JPRB,2.5438E+00_JPRB,2.7445E+00_JPRB/)
KBO( :, 5,19, 9) = (/&
&1.1065E+00_JPRB,1.1062E+00_JPRB,1.4975E+00_JPRB,2.0661E+00_JPRB,2.5062E+00_JPRB,2.7222E+00_JPRB/)
KBO( :, 1,20, 9) = (/&
&9.0827E-01_JPRB,9.0805E-01_JPRB,1.5341E+00_JPRB,2.1956E+00_JPRB,2.6632E+00_JPRB,2.8242E+00_JPRB/)
KBO( :, 2,20, 9) = (/&
&9.2064E-01_JPRB,9.2040E-01_JPRB,1.5172E+00_JPRB,2.1687E+00_JPRB,2.6400E+00_JPRB,2.8145E+00_JPRB/)
KBO( :, 3,20, 9) = (/&
&9.3844E-01_JPRB,9.3819E-01_JPRB,1.5016E+00_JPRB,2.1388E+00_JPRB,2.6129E+00_JPRB,2.8000E+00_JPRB/)
KBO( :, 4,20, 9) = (/&
&9.6013E-01_JPRB,9.5986E-01_JPRB,1.4885E+00_JPRB,2.1071E+00_JPRB,2.5814E+00_JPRB,2.7828E+00_JPRB/)
KBO( :, 5,20, 9) = (/&
&9.8430E-01_JPRB,9.8400E-01_JPRB,1.4771E+00_JPRB,2.0741E+00_JPRB,2.5454E+00_JPRB,2.7636E+00_JPRB/)
KBO( :, 1,21, 9) = (/&
&7.8993E-01_JPRB,7.8978E-01_JPRB,1.4986E+00_JPRB,2.1733E+00_JPRB,2.6623E+00_JPRB,2.8179E+00_JPRB/)
KBO( :, 2,21, 9) = (/&
&8.0667E-01_JPRB,8.0650E-01_JPRB,1.4848E+00_JPRB,2.1496E+00_JPRB,2.6446E+00_JPRB,2.8129E+00_JPRB/)
KBO( :, 3,21, 9) = (/&
&8.2802E-01_JPRB,8.2784E-01_JPRB,1.4733E+00_JPRB,2.1235E+00_JPRB,2.6208E+00_JPRB,2.8029E+00_JPRB/)
KBO( :, 4,21, 9) = (/&
&8.5232E-01_JPRB,8.5211E-01_JPRB,1.4639E+00_JPRB,2.0960E+00_JPRB,2.5913E+00_JPRB,2.7898E+00_JPRB/)
KBO( :, 5,21, 9) = (/&
&8.7899E-01_JPRB,8.7876E-01_JPRB,1.4566E+00_JPRB,2.0681E+00_JPRB,2.5576E+00_JPRB,2.7727E+00_JPRB/)
KBO( :, 1,22, 9) = (/&
&6.9217E-01_JPRB,6.9207E-01_JPRB,1.4567E+00_JPRB,2.1294E+00_JPRB,2.6320E+00_JPRB,2.7789E+00_JPRB/)
KBO( :, 2,22, 9) = (/&
&7.1220E-01_JPRB,7.1209E-01_JPRB,1.4478E+00_JPRB,2.1106E+00_JPRB,2.6173E+00_JPRB,2.7783E+00_JPRB/)
KBO( :, 3,22, 9) = (/&
&7.3566E-01_JPRB,7.3553E-01_JPRB,1.4413E+00_JPRB,2.0897E+00_JPRB,2.5963E+00_JPRB,2.7722E+00_JPRB/)
KBO( :, 4,22, 9) = (/&
&7.6128E-01_JPRB,7.6113E-01_JPRB,1.4363E+00_JPRB,2.0682E+00_JPRB,2.5703E+00_JPRB,2.7624E+00_JPRB/)
KBO( :, 5,22, 9) = (/&
&7.8574E-01_JPRB,7.8555E-01_JPRB,1.4327E+00_JPRB,2.0477E+00_JPRB,2.5401E+00_JPRB,2.7492E+00_JPRB/)
KBO( :, 1,23, 9) = (/&
&6.1008E-01_JPRB,6.1003E-01_JPRB,1.4083E+00_JPRB,2.0681E+00_JPRB,2.5705E+00_JPRB,2.7083E+00_JPRB/)
KBO( :, 2,23, 9) = (/&
&6.3198E-01_JPRB,6.3192E-01_JPRB,1.4051E+00_JPRB,2.0548E+00_JPRB,2.5593E+00_JPRB,2.7117E+00_JPRB/)
KBO( :, 3,23, 9) = (/&
&6.5543E-01_JPRB,6.5535E-01_JPRB,1.4040E+00_JPRB,2.0403E+00_JPRB,2.5427E+00_JPRB,2.7102E+00_JPRB/)
KBO( :, 4,23, 9) = (/&
&6.7837E-01_JPRB,6.7826E-01_JPRB,1.4041E+00_JPRB,2.0263E+00_JPRB,2.5213E+00_JPRB,2.7060E+00_JPRB/)
KBO( :, 5,23, 9) = (/&
&7.0030E-01_JPRB,7.0016E-01_JPRB,1.4050E+00_JPRB,2.0127E+00_JPRB,2.4961E+00_JPRB,2.6994E+00_JPRB/)
KBO( :, 1,24, 9) = (/&
&5.4033E-01_JPRB,5.4033E-01_JPRB,1.3546E+00_JPRB,1.9899E+00_JPRB,2.4822E+00_JPRB,2.6084E+00_JPRB/)
KBO( :, 2,24, 9) = (/&
&5.6139E-01_JPRB,5.6138E-01_JPRB,1.3577E+00_JPRB,1.9836E+00_JPRB,2.4759E+00_JPRB,2.6174E+00_JPRB/)
KBO( :, 3,24, 9) = (/&
&5.8245E-01_JPRB,5.8242E-01_JPRB,1.3618E+00_JPRB,1.9770E+00_JPRB,2.4649E+00_JPRB,2.6232E+00_JPRB/)
KBO( :, 4,24, 9) = (/&
&6.0241E-01_JPRB,6.0233E-01_JPRB,1.3664E+00_JPRB,1.9707E+00_JPRB,2.4498E+00_JPRB,2.6268E+00_JPRB/)
KBO( :, 5,24, 9) = (/&
&6.2165E-01_JPRB,6.2155E-01_JPRB,1.3699E+00_JPRB,1.9646E+00_JPRB,2.4321E+00_JPRB,2.6277E+00_JPRB/)
KBO( :, 1,25, 9) = (/&
&4.7832E-01_JPRB,4.7836E-01_JPRB,1.2974E+00_JPRB,1.9000E+00_JPRB,2.3730E+00_JPRB,2.4875E+00_JPRB/)
KBO( :, 2,25, 9) = (/&
&4.9733E-01_JPRB,4.9735E-01_JPRB,1.3057E+00_JPRB,1.9014E+00_JPRB,2.3734E+00_JPRB,2.5038E+00_JPRB/)
KBO( :, 3,25, 9) = (/&
&5.1523E-01_JPRB,5.1522E-01_JPRB,1.3146E+00_JPRB,1.9031E+00_JPRB,2.3699E+00_JPRB,2.5183E+00_JPRB/)
KBO( :, 4,25, 9) = (/&
&5.3256E-01_JPRB,5.3251E-01_JPRB,1.3228E+00_JPRB,1.9051E+00_JPRB,2.3637E+00_JPRB,2.5320E+00_JPRB/)
KBO( :, 5,25, 9) = (/&
&5.4968E-01_JPRB,5.4961E-01_JPRB,1.3292E+00_JPRB,1.9068E+00_JPRB,2.3561E+00_JPRB,2.5438E+00_JPRB/)
KBO( :, 1,26, 9) = (/&
&4.2201E-01_JPRB,4.2207E-01_JPRB,1.2364E+00_JPRB,1.8029E+00_JPRB,2.2507E+00_JPRB,2.3533E+00_JPRB/)
KBO( :, 2,26, 9) = (/&
&4.3804E-01_JPRB,4.3809E-01_JPRB,1.2498E+00_JPRB,1.8126E+00_JPRB,2.2597E+00_JPRB,2.3788E+00_JPRB/)
KBO( :, 3,26, 9) = (/&
&4.5354E-01_JPRB,4.5356E-01_JPRB,1.2632E+00_JPRB,1.8229E+00_JPRB,2.2657E+00_JPRB,2.4047E+00_JPRB/)
KBO( :, 4,26, 9) = (/&
&4.6906E-01_JPRB,4.6904E-01_JPRB,1.2746E+00_JPRB,1.8333E+00_JPRB,2.2706E+00_JPRB,2.4304E+00_JPRB/)
KBO( :, 5,26, 9) = (/&
&4.8497E-01_JPRB,4.8494E-01_JPRB,1.2839E+00_JPRB,1.8429E+00_JPRB,2.2744E+00_JPRB,2.4544E+00_JPRB/)
KBO( :, 1,27, 9) = (/&
&3.7036E-01_JPRB,3.7045E-01_JPRB,1.1734E+00_JPRB,1.7029E+00_JPRB,2.1233E+00_JPRB,2.2152E+00_JPRB/)
KBO( :, 2,27, 9) = (/&
&3.8398E-01_JPRB,3.8406E-01_JPRB,1.1918E+00_JPRB,1.7218E+00_JPRB,2.1420E+00_JPRB,2.2527E+00_JPRB/)
KBO( :, 3,27, 9) = (/&
&3.9787E-01_JPRB,3.9791E-01_JPRB,1.2085E+00_JPRB,1.7412E+00_JPRB,2.1596E+00_JPRB,2.2917E+00_JPRB/)
KBO( :, 4,27, 9) = (/&
&4.1227E-01_JPRB,4.1229E-01_JPRB,1.2235E+00_JPRB,1.7604E+00_JPRB,2.1764E+00_JPRB,2.3307E+00_JPRB/)
KBO( :, 5,27, 9) = (/&
&4.2780E-01_JPRB,4.2779E-01_JPRB,1.2358E+00_JPRB,1.7785E+00_JPRB,2.1924E+00_JPRB,2.3678E+00_JPRB/)
KBO( :, 1,28, 9) = (/&
&3.2384E-01_JPRB,3.2396E-01_JPRB,1.1111E+00_JPRB,1.6050E+00_JPRB,1.9966E+00_JPRB,2.0814E+00_JPRB/)
KBO( :, 2,28, 9) = (/&
&3.3603E-01_JPRB,3.3613E-01_JPRB,1.1332E+00_JPRB,1.6332E+00_JPRB,2.0271E+00_JPRB,2.1324E+00_JPRB/)
KBO( :, 3,28, 9) = (/&
&3.4881E-01_JPRB,3.4887E-01_JPRB,1.1536E+00_JPRB,1.6622E+00_JPRB,2.0573E+00_JPRB,2.1850E+00_JPRB/)
KBO( :, 4,28, 9) = (/&
&3.6268E-01_JPRB,3.6273E-01_JPRB,1.1720E+00_JPRB,1.6900E+00_JPRB,2.0870E+00_JPRB,2.2373E+00_JPRB/)
KBO( :, 5,28, 9) = (/&
&3.7804E-01_JPRB,3.7806E-01_JPRB,1.1877E+00_JPRB,1.7173E+00_JPRB,2.1162E+00_JPRB,2.2869E+00_JPRB/)
KBO( :, 1,29, 9) = (/&
&2.8312E-01_JPRB,2.8326E-01_JPRB,1.0508E+00_JPRB,1.5130E+00_JPRB,1.8780E+00_JPRB,1.9589E+00_JPRB/)
KBO( :, 2,29, 9) = (/&
&2.9434E-01_JPRB,2.9445E-01_JPRB,1.0766E+00_JPRB,1.5511E+00_JPRB,1.9210E+00_JPRB,2.0243E+00_JPRB/)
KBO( :, 3,29, 9) = (/&
&3.0652E-01_JPRB,3.0661E-01_JPRB,1.1009E+00_JPRB,1.5889E+00_JPRB,1.9642E+00_JPRB,2.0907E+00_JPRB/)
KBO( :, 4,29, 9) = (/&
&3.2016E-01_JPRB,3.2023E-01_JPRB,1.1226E+00_JPRB,1.6261E+00_JPRB,2.0071E+00_JPRB,2.1548E+00_JPRB/)
KBO( :, 5,29, 9) = (/&
&3.3571E-01_JPRB,3.3577E-01_JPRB,1.1421E+00_JPRB,1.6615E+00_JPRB,2.0485E+00_JPRB,2.2151E+00_JPRB/)
KBO( :, 1,30, 9) = (/&
&2.4766E-01_JPRB,2.4782E-01_JPRB,9.9433E-01_JPRB,1.4304E+00_JPRB,1.7715E+00_JPRB,1.8514E+00_JPRB/)
KBO( :, 2,30, 9) = (/&
&2.5837E-01_JPRB,2.5850E-01_JPRB,1.0241E+00_JPRB,1.4775E+00_JPRB,1.8271E+00_JPRB,1.9302E+00_JPRB/)
KBO( :, 3,30, 9) = (/&
&2.7045E-01_JPRB,2.7056E-01_JPRB,1.0517E+00_JPRB,1.5244E+00_JPRB,1.8833E+00_JPRB,2.0084E+00_JPRB/)
KBO( :, 4,30, 9) = (/&
&2.8427E-01_JPRB,2.8436E-01_JPRB,1.0773E+00_JPRB,1.5701E+00_JPRB,1.9380E+00_JPRB,2.0829E+00_JPRB/)
KBO( :, 5,30, 9) = (/&
&3.0013E-01_JPRB,3.0021E-01_JPRB,1.1005E+00_JPRB,1.6130E+00_JPRB,1.9897E+00_JPRB,2.1530E+00_JPRB/)
KBO( :, 1,31, 9) = (/&
&2.1718E-01_JPRB,2.1735E-01_JPRB,9.4336E-01_JPRB,1.3592E+00_JPRB,1.6802E+00_JPRB,1.7623E+00_JPRB/)
KBO( :, 2,31, 9) = (/&
&2.2773E-01_JPRB,2.2787E-01_JPRB,9.7667E-01_JPRB,1.4147E+00_JPRB,1.7480E+00_JPRB,1.8530E+00_JPRB/)
KBO( :, 3,31, 9) = (/&
&2.3995E-01_JPRB,2.4007E-01_JPRB,1.0080E+00_JPRB,1.4699E+00_JPRB,1.8151E+00_JPRB,1.9409E+00_JPRB/)
KBO( :, 4,31, 9) = (/&
&2.5414E-01_JPRB,2.5424E-01_JPRB,1.0371E+00_JPRB,1.5227E+00_JPRB,1.8795E+00_JPRB,2.0251E+00_JPRB/)
KBO( :, 5,31, 9) = (/&
&2.7018E-01_JPRB,2.7028E-01_JPRB,1.0644E+00_JPRB,1.5717E+00_JPRB,1.9397E+00_JPRB,2.1038E+00_JPRB/)
KBO( :, 1,32, 9) = (/&
&1.9126E-01_JPRB,1.9146E-01_JPRB,8.9853E-01_JPRB,1.2997E+00_JPRB,1.6046E+00_JPRB,1.6901E+00_JPRB/)
KBO( :, 2,32, 9) = (/&
&2.0193E-01_JPRB,2.0209E-01_JPRB,9.3540E-01_JPRB,1.3632E+00_JPRB,1.6829E+00_JPRB,1.7901E+00_JPRB/)
KBO( :, 3,32, 9) = (/&
&2.1445E-01_JPRB,2.1459E-01_JPRB,9.7036E-01_JPRB,1.4251E+00_JPRB,1.7593E+00_JPRB,1.8876E+00_JPRB/)
KBO( :, 4,32, 9) = (/&
&2.2890E-01_JPRB,2.2902E-01_JPRB,1.0032E+00_JPRB,1.4834E+00_JPRB,1.8319E+00_JPRB,1.9801E+00_JPRB/)
KBO( :, 5,32, 9) = (/&
&2.4476E-01_JPRB,2.4488E-01_JPRB,1.0341E+00_JPRB,1.5373E+00_JPRB,1.8995E+00_JPRB,2.0662E+00_JPRB/)
KBO( :, 1,33, 9) = (/&
&1.6940E-01_JPRB,1.6962E-01_JPRB,8.6040E-01_JPRB,1.2516E+00_JPRB,1.5440E+00_JPRB,1.6336E+00_JPRB/)
KBO( :, 2,33, 9) = (/&
&1.8040E-01_JPRB,1.8058E-01_JPRB,9.0069E-01_JPRB,1.3217E+00_JPRB,1.6313E+00_JPRB,1.7427E+00_JPRB/)
KBO( :, 3,33, 9) = (/&
&1.9322E-01_JPRB,1.9338E-01_JPRB,9.3905E-01_JPRB,1.3887E+00_JPRB,1.7155E+00_JPRB,1.8483E+00_JPRB/)
KBO( :, 4,33, 9) = (/&
&2.0759E-01_JPRB,2.0774E-01_JPRB,9.7525E-01_JPRB,1.4518E+00_JPRB,1.7950E+00_JPRB,1.9477E+00_JPRB/)
KBO( :, 5,33, 9) = (/&
&2.2287E-01_JPRB,2.2300E-01_JPRB,1.0095E+00_JPRB,1.5103E+00_JPRB,1.8688E+00_JPRB,2.0398E+00_JPRB/)
KBO( :, 1,34, 9) = (/&
&1.5076E-01_JPRB,1.5101E-01_JPRB,8.2749E-01_JPRB,1.2115E+00_JPRB,1.4944E+00_JPRB,1.5862E+00_JPRB/)
KBO( :, 2,34, 9) = (/&
&1.6203E-01_JPRB,1.6224E-01_JPRB,8.7097E-01_JPRB,1.2867E+00_JPRB,1.5891E+00_JPRB,1.7034E+00_JPRB/)
KBO( :, 3,34, 9) = (/&
&1.7492E-01_JPRB,1.7510E-01_JPRB,9.1244E-01_JPRB,1.3584E+00_JPRB,1.6800E+00_JPRB,1.8152E+00_JPRB/)
KBO( :, 4,34, 9) = (/&
&1.8884E-01_JPRB,1.8900E-01_JPRB,9.5164E-01_JPRB,1.4257E+00_JPRB,1.7654E+00_JPRB,1.9207E+00_JPRB/)
KBO( :, 5,34, 9) = (/&
&2.0347E-01_JPRB,2.0361E-01_JPRB,9.8858E-01_JPRB,1.4882E+00_JPRB,1.8441E+00_JPRB,2.0182E+00_JPRB/)
KBO( :, 1,35, 9) = (/&
&1.3410E-01_JPRB,1.3442E-01_JPRB,7.9621E-01_JPRB,1.1726E+00_JPRB,1.4470E+00_JPRB,1.5402E+00_JPRB/)
KBO( :, 2,35, 9) = (/&
&1.4542E-01_JPRB,1.4567E-01_JPRB,8.4262E-01_JPRB,1.2523E+00_JPRB,1.5484E+00_JPRB,1.6636E+00_JPRB/)
KBO( :, 3,35, 9) = (/&
&1.5802E-01_JPRB,1.5823E-01_JPRB,8.8698E-01_JPRB,1.3283E+00_JPRB,1.6454E+00_JPRB,1.7818E+00_JPRB/)
KBO( :, 4,35, 9) = (/&
&1.7135E-01_JPRB,1.7153E-01_JPRB,9.2894E-01_JPRB,1.3999E+00_JPRB,1.7361E+00_JPRB,1.8932E+00_JPRB/)
KBO( :, 5,35, 9) = (/&
&1.8540E-01_JPRB,1.8556E-01_JPRB,9.6841E-01_JPRB,1.4664E+00_JPRB,1.8195E+00_JPRB,1.9967E+00_JPRB/)
KBO( :, 1,36, 9) = (/&
&1.1885E-01_JPRB,1.1927E-01_JPRB,7.6459E-01_JPRB,1.1318E+00_JPRB,1.3978E+00_JPRB,1.4899E+00_JPRB/)
KBO( :, 2,36, 9) = (/&
&1.2990E-01_JPRB,1.3022E-01_JPRB,8.1382E-01_JPRB,1.2158E+00_JPRB,1.5052E+00_JPRB,1.6195E+00_JPRB/)
KBO( :, 3,36, 9) = (/&
&1.4201E-01_JPRB,1.4226E-01_JPRB,8.6094E-01_JPRB,1.2962E+00_JPRB,1.6079E+00_JPRB,1.7441E+00_JPRB/)
KBO( :, 4,36, 9) = (/&
&1.5478E-01_JPRB,1.5499E-01_JPRB,9.0551E-01_JPRB,1.3720E+00_JPRB,1.7039E+00_JPRB,1.8614E+00_JPRB/)
KBO( :, 5,36, 9) = (/&
&1.6836E-01_JPRB,1.6854E-01_JPRB,9.4765E-01_JPRB,1.4424E+00_JPRB,1.7920E+00_JPRB,1.9701E+00_JPRB/)
KBO( :, 1,37, 9) = (/&
&1.0428E-01_JPRB,1.0485E-01_JPRB,7.2899E-01_JPRB,1.0835E+00_JPRB,1.3388E+00_JPRB,1.4259E+00_JPRB/)
KBO( :, 2,37, 9) = (/&
&1.1481E-01_JPRB,1.1525E-01_JPRB,7.8118E-01_JPRB,1.1719E+00_JPRB,1.4522E+00_JPRB,1.5616E+00_JPRB/)
KBO( :, 3,37, 9) = (/&
&1.2629E-01_JPRB,1.2662E-01_JPRB,8.3108E-01_JPRB,1.2566E+00_JPRB,1.5607E+00_JPRB,1.6925E+00_JPRB/)
KBO( :, 4,37, 9) = (/&
&1.3851E-01_JPRB,1.3876E-01_JPRB,8.7848E-01_JPRB,1.3370E+00_JPRB,1.6624E+00_JPRB,1.8161E+00_JPRB/)
KBO( :, 5,37, 9) = (/&
&1.5156E-01_JPRB,1.5177E-01_JPRB,9.2339E-01_JPRB,1.4116E+00_JPRB,1.7558E+00_JPRB,1.9309E+00_JPRB/)
KBO( :, 1,38, 9) = (/&
&9.1605E-02_JPRB,9.2343E-02_JPRB,6.9610E-01_JPRB,1.0388E+00_JPRB,1.2845E+00_JPRB,1.3674E+00_JPRB/)
KBO( :, 2,38, 9) = (/&
&1.0158E-01_JPRB,1.0215E-01_JPRB,7.5088E-01_JPRB,1.1311E+00_JPRB,1.4032E+00_JPRB,1.5087E+00_JPRB/)
KBO( :, 3,38, 9) = (/&
&1.1247E-01_JPRB,1.1289E-01_JPRB,8.0339E-01_JPRB,1.2200E+00_JPRB,1.5169E+00_JPRB,1.6453E+00_JPRB/)
KBO( :, 4,38, 9) = (/&
&1.2417E-01_JPRB,1.2448E-01_JPRB,8.5338E-01_JPRB,1.3042E+00_JPRB,1.6236E+00_JPRB,1.7750E+00_JPRB/)
KBO( :, 5,38, 9) = (/&
&1.3676E-01_JPRB,1.3700E-01_JPRB,9.0083E-01_JPRB,1.3828E+00_JPRB,1.7217E+00_JPRB,1.8952E+00_JPRB/)
KBO( :, 1,39, 9) = (/&
&8.0656E-02_JPRB,8.1594E-02_JPRB,6.6607E-01_JPRB,9.9815E-01_JPRB,1.2351E+00_JPRB,1.3152E+00_JPRB/)
KBO( :, 2,39, 9) = (/&
&9.0069E-02_JPRB,9.0786E-02_JPRB,7.2321E-01_JPRB,1.0941E+00_JPRB,1.3584E+00_JPRB,1.4617E+00_JPRB/)
KBO( :, 3,39, 9) = (/&
&1.0038E-01_JPRB,1.0092E-01_JPRB,7.7814E-01_JPRB,1.1864E+00_JPRB,1.4767E+00_JPRB,1.6037E+00_JPRB/)
KBO( :, 4,39, 9) = (/&
&1.1160E-01_JPRB,1.1200E-01_JPRB,8.3050E-01_JPRB,1.2742E+00_JPRB,1.5879E+00_JPRB,1.7392E+00_JPRB/)
KBO( :, 5,39, 9) = (/&
&1.2381E-01_JPRB,1.2410E-01_JPRB,8.8026E-01_JPRB,1.3564E+00_JPRB,1.6903E+00_JPRB,1.8642E+00_JPRB/)
KBO( :, 1,40, 9) = (/&
&7.0343E-02_JPRB,7.1517E-02_JPRB,6.3258E-01_JPRB,9.5074E-01_JPRB,1.1768E+00_JPRB,1.2495E+00_JPRB/)
KBO( :, 2,40, 9) = (/&
&7.9103E-02_JPRB,8.0020E-02_JPRB,6.9189E-01_JPRB,1.0501E+00_JPRB,1.3045E+00_JPRB,1.4003E+00_JPRB/)
KBO( :, 3,40, 9) = (/&
&8.8790E-02_JPRB,8.9492E-02_JPRB,7.4925E-01_JPRB,1.1461E+00_JPRB,1.4274E+00_JPRB,1.5476E+00_JPRB/)
KBO( :, 4,40, 9) = (/&
&9.9461E-02_JPRB,9.9977E-02_JPRB,8.0414E-01_JPRB,1.2375E+00_JPRB,1.5434E+00_JPRB,1.6884E+00_JPRB/)
KBO( :, 5,40, 9) = (/&
&1.1114E-01_JPRB,1.1151E-01_JPRB,8.5633E-01_JPRB,1.3236E+00_JPRB,1.6507E+00_JPRB,1.8191E+00_JPRB/)
KBO( :, 1,41, 9) = (/&
&6.1266E-02_JPRB,6.2696E-02_JPRB,6.0022E-01_JPRB,9.0450E-01_JPRB,1.1198E+00_JPRB,1.1852E+00_JPRB/)
KBO( :, 2,41, 9) = (/&
&6.9449E-02_JPRB,7.0593E-02_JPRB,6.6161E-01_JPRB,1.0070E+00_JPRB,1.2513E+00_JPRB,1.3399E+00_JPRB/)
KBO( :, 3,41, 9) = (/&
&7.8517E-02_JPRB,7.9409E-02_JPRB,7.2121E-01_JPRB,1.1063E+00_JPRB,1.3785E+00_JPRB,1.4916E+00_JPRB/)
KBO( :, 4,41, 9) = (/&
&8.8610E-02_JPRB,8.9276E-02_JPRB,7.7839E-01_JPRB,1.2012E+00_JPRB,1.4990E+00_JPRB,1.6374E+00_JPRB/)
KBO( :, 5,41, 9) = (/&
&9.9774E-02_JPRB,1.0026E-01_JPRB,8.3284E-01_JPRB,1.2906E+00_JPRB,1.6108E+00_JPRB,1.7737E+00_JPRB/)
KBO( :, 1,42, 9) = (/&
&5.3360E-02_JPRB,5.5059E-02_JPRB,5.6966E-01_JPRB,8.6038E-01_JPRB,1.0655E+00_JPRB,1.1243E+00_JPRB/)
KBO( :, 2,42, 9) = (/&
&6.0993E-02_JPRB,6.2382E-02_JPRB,6.3280E-01_JPRB,9.6562E-01_JPRB,1.2001E+00_JPRB,1.2823E+00_JPRB/)
KBO( :, 3,42, 9) = (/&
&6.9507E-02_JPRB,7.0610E-02_JPRB,6.9445E-01_JPRB,1.0679E+00_JPRB,1.3311E+00_JPRB,1.4380E+00_JPRB/)
KBO( :, 4,42, 9) = (/&
&7.9032E-02_JPRB,7.9871E-02_JPRB,7.5376E-01_JPRB,1.1658E+00_JPRB,1.4555E+00_JPRB,1.5883E+00_JPRB/)
KBO( :, 5,42, 9) = (/&
&8.9684E-02_JPRB,9.0303E-02_JPRB,8.1031E-01_JPRB,1.2585E+00_JPRB,1.5717E+00_JPRB,1.7298E+00_JPRB/)
KBO( :, 1,43, 9) = (/&
&4.6136E-02_JPRB,4.8125E-02_JPRB,5.3704E-01_JPRB,8.1220E-01_JPRB,1.0058E+00_JPRB,1.0569E+00_JPRB/)
KBO( :, 2,43, 9) = (/&
&5.3161E-02_JPRB,5.4823E-02_JPRB,6.0168E-01_JPRB,9.1982E-01_JPRB,1.1431E+00_JPRB,1.2177E+00_JPRB/)
KBO( :, 3,43, 9) = (/&
&6.1123E-02_JPRB,6.2470E-02_JPRB,6.6532E-01_JPRB,1.0249E+00_JPRB,1.2775E+00_JPRB,1.3770E+00_JPRB/)
KBO( :, 4,43, 9) = (/&
&7.0049E-02_JPRB,7.1098E-02_JPRB,7.2673E-01_JPRB,1.1259E+00_JPRB,1.4060E+00_JPRB,1.5318E+00_JPRB/)
KBO( :, 5,43, 9) = (/&
&8.0119E-02_JPRB,8.0908E-02_JPRB,7.8534E-01_JPRB,1.2218E+00_JPRB,1.5266E+00_JPRB,1.6786E+00_JPRB/)
KBO( :, 1,44, 9) = (/&
&3.9685E-02_JPRB,4.1972E-02_JPRB,5.0412E-01_JPRB,7.6296E-01_JPRB,9.4428E-01_JPRB,9.8787E-01_JPRB/)
KBO( :, 2,44, 9) = (/&
&4.6152E-02_JPRB,4.8103E-02_JPRB,5.7004E-01_JPRB,8.7240E-01_JPRB,1.0838E+00_JPRB,1.1508E+00_JPRB/)
KBO( :, 3,44, 9) = (/&
&5.3529E-02_JPRB,5.5143E-02_JPRB,6.3536E-01_JPRB,9.8002E-01_JPRB,1.2213E+00_JPRB,1.3132E+00_JPRB/)
KBO( :, 4,44, 9) = (/&
&6.1901E-02_JPRB,6.3183E-02_JPRB,6.9879E-01_JPRB,1.0840E+00_JPRB,1.3536E+00_JPRB,1.4723E+00_JPRB/)
KBO( :, 5,44, 9) = (/&
&7.1354E-02_JPRB,7.2347E-02_JPRB,7.5939E-01_JPRB,1.1829E+00_JPRB,1.4784E+00_JPRB,1.6242E+00_JPRB/)
KBO( :, 1,45, 9) = (/&
&3.4076E-02_JPRB,3.6651E-02_JPRB,4.7238E-01_JPRB,7.1511E-01_JPRB,8.8440E-01_JPRB,9.2130E-01_JPRB/)
KBO( :, 2,45, 9) = (/&
&4.0025E-02_JPRB,4.2260E-02_JPRB,5.3939E-01_JPRB,8.2584E-01_JPRB,1.0257E+00_JPRB,1.0858E+00_JPRB/)
KBO( :, 3,45, 9) = (/&
&4.6843E-02_JPRB,4.8732E-02_JPRB,6.0607E-01_JPRB,9.3570E-01_JPRB,1.1656E+00_JPRB,1.2509E+00_JPRB/)
KBO( :, 4,45, 9) = (/&
&5.4663E-02_JPRB,5.6198E-02_JPRB,6.7125E-01_JPRB,1.0423E+00_JPRB,1.3013E+00_JPRB,1.4137E+00_JPRB/)
KBO( :, 5,45, 9) = (/&
&6.3560E-02_JPRB,6.4776E-02_JPRB,7.3381E-01_JPRB,1.1441E+00_JPRB,1.4299E+00_JPRB,1.5705E+00_JPRB/)
KBO( :, 1,46, 9) = (/&
&2.9074E-02_JPRB,3.1936E-02_JPRB,4.4021E-01_JPRB,6.6617E-01_JPRB,8.2306E-01_JPRB,8.5311E-01_JPRB/)
KBO( :, 2,46, 9) = (/&
&3.4514E-02_JPRB,3.7034E-02_JPRB,5.0803E-01_JPRB,7.7771E-01_JPRB,9.6537E-01_JPRB,1.0184E+00_JPRB/)
KBO( :, 3,46, 9) = (/&
&4.0817E-02_JPRB,4.2987E-02_JPRB,5.7579E-01_JPRB,8.8933E-01_JPRB,1.1073E+00_JPRB,1.1856E+00_JPRB/)
KBO( :, 4,46, 9) = (/&
&4.8065E-02_JPRB,4.9872E-02_JPRB,6.4255E-01_JPRB,9.9829E-01_JPRB,1.2460E+00_JPRB,1.3517E+00_JPRB/)
KBO( :, 5,46, 9) = (/&
&5.6423E-02_JPRB,5.7882E-02_JPRB,7.0700E-01_JPRB,1.1029E+00_JPRB,1.3784E+00_JPRB,1.5131E+00_JPRB/)
KBO( :, 1,47, 9) = (/&
&2.4535E-02_JPRB,2.7684E-02_JPRB,4.0628E-01_JPRB,6.1382E-01_JPRB,7.5741E-01_JPRB,7.7949E-01_JPRB/)
KBO( :, 2,47, 9) = (/&
&2.9449E-02_JPRB,3.2260E-02_JPRB,4.7443E-01_JPRB,7.2561E-01_JPRB,8.9979E-01_JPRB,9.4468E-01_JPRB/)
KBO( :, 3,47, 9) = (/&
&3.5234E-02_JPRB,3.7694E-02_JPRB,5.4316E-01_JPRB,8.3846E-01_JPRB,1.0433E+00_JPRB,1.1130E+00_JPRB/)
KBO( :, 4,47, 9) = (/&
&4.1912E-02_JPRB,4.4006E-02_JPRB,6.1119E-01_JPRB,9.4961E-01_JPRB,1.1846E+00_JPRB,1.2819E+00_JPRB/)
KBO( :, 5,47, 9) = (/&
&4.9674E-02_JPRB,5.1405E-02_JPRB,6.7740E-01_JPRB,1.0570E+00_JPRB,1.3207E+00_JPRB,1.4474E+00_JPRB/)
KBO( :, 1,48, 9) = (/&
&2.0618E-02_JPRB,2.4026E-02_JPRB,3.7343E-01_JPRB,5.6290E-01_JPRB,6.9352E-01_JPRB,7.0849E-01_JPRB/)
KBO( :, 2,48, 9) = (/&
&2.5013E-02_JPRB,2.8103E-02_JPRB,4.4151E-01_JPRB,6.7436E-01_JPRB,8.3513E-01_JPRB,8.7266E-01_JPRB/)
KBO( :, 3,48, 9) = (/&
&3.0305E-02_JPRB,3.3049E-02_JPRB,5.1090E-01_JPRB,7.8783E-01_JPRB,9.7958E-01_JPRB,1.0415E+00_JPRB/)
KBO( :, 4,48, 9) = (/&
&3.6461E-02_JPRB,3.8842E-02_JPRB,5.7999E-01_JPRB,9.0076E-01_JPRB,1.1229E+00_JPRB,1.2126E+00_JPRB/)
KBO( :, 5,48, 9) = (/&
&4.3637E-02_JPRB,4.5645E-02_JPRB,6.4766E-01_JPRB,1.0105E+00_JPRB,1.2621E+00_JPRB,1.3817E+00_JPRB/)
KBO( :, 1,49, 9) = (/&
&1.7262E-02_JPRB,2.0889E-02_JPRB,3.4154E-01_JPRB,5.1353E-01_JPRB,6.3147E-01_JPRB,6.4035E-01_JPRB/)
KBO( :, 2,49, 9) = (/&
&2.1137E-02_JPRB,2.4489E-02_JPRB,4.0924E-01_JPRB,6.2397E-01_JPRB,7.7164E-01_JPRB,8.0268E-01_JPRB/)
KBO( :, 3,49, 9) = (/&
&2.5945E-02_JPRB,2.8963E-02_JPRB,4.7895E-01_JPRB,7.3764E-01_JPRB,9.1622E-01_JPRB,9.7159E-01_JPRB/)
KBO( :, 4,49, 9) = (/&
&3.1605E-02_JPRB,3.4269E-02_JPRB,5.4885E-01_JPRB,8.5174E-01_JPRB,1.0610E+00_JPRB,1.1442E+00_JPRB/)
KBO( :, 5,49, 9) = (/&
&3.8248E-02_JPRB,4.0534E-02_JPRB,6.1776E-01_JPRB,9.6350E-01_JPRB,1.2028E+00_JPRB,1.3168E+00_JPRB/)
KBO( :, 1,50, 9) = (/&
&1.4461E-02_JPRB,1.8256E-02_JPRB,3.1238E-01_JPRB,4.6845E-01_JPRB,5.7488E-01_JPRB,5.7744E-01_JPRB/)
KBO( :, 2,50, 9) = (/&
&1.7870E-02_JPRB,2.1439E-02_JPRB,3.7949E-01_JPRB,5.7732E-01_JPRB,7.1302E-01_JPRB,7.3703E-01_JPRB/)
KBO( :, 3,50, 9) = (/&
&2.2222E-02_JPRB,2.5490E-02_JPRB,4.4914E-01_JPRB,6.9079E-01_JPRB,8.5702E-01_JPRB,9.0516E-01_JPRB/)
KBO( :, 4,50, 9) = (/&
&2.7435E-02_JPRB,3.0361E-02_JPRB,5.1966E-01_JPRB,8.0553E-01_JPRB,1.0027E+00_JPRB,1.0781E+00_JPRB/)
KBO( :, 5,50, 9) = (/&
&3.3599E-02_JPRB,3.6150E-02_JPRB,5.8955E-01_JPRB,9.1897E-01_JPRB,1.1465E+00_JPRB,1.2529E+00_JPRB/)
KBO( :, 1,51, 9) = (/&
&1.2097E-02_JPRB,1.6003E-02_JPRB,2.8492E-01_JPRB,4.2603E-01_JPRB,5.2182E-01_JPRB,5.1816E-01_JPRB/)
KBO( :, 2,51, 9) = (/&
&1.5083E-02_JPRB,1.8829E-02_JPRB,3.5127E-01_JPRB,5.3304E-01_JPRB,6.5735E-01_JPRB,6.7429E-01_JPRB/)
KBO( :, 3,51, 9) = (/&
&1.8997E-02_JPRB,2.2488E-02_JPRB,4.2058E-01_JPRB,6.4583E-01_JPRB,8.0019E-01_JPRB,8.4077E-01_JPRB/)
KBO( :, 4,51, 9) = (/&
&2.3775E-02_JPRB,2.6948E-02_JPRB,4.9143E-01_JPRB,7.6084E-01_JPRB,9.4628E-01_JPRB,1.0134E+00_JPRB/)
KBO( :, 5,51, 9) = (/&
&2.9499E-02_JPRB,3.2304E-02_JPRB,5.6205E-01_JPRB,8.7547E-01_JPRB,1.0915E+00_JPRB,1.1895E+00_JPRB/)
KBO( :, 1,52, 9) = (/&
&1.0095E-02_JPRB,1.4050E-02_JPRB,2.5854E-01_JPRB,3.8529E-01_JPRB,4.7109E-01_JPRB,4.6197E-01_JPRB/)
KBO( :, 2,52, 9) = (/&
&1.2680E-02_JPRB,1.6562E-02_JPRB,3.2378E-01_JPRB,4.9000E-01_JPRB,6.0315E-01_JPRB,6.1385E-01_JPRB/)
KBO( :, 3,52, 9) = (/&
&1.6167E-02_JPRB,1.9851E-02_JPRB,3.9257E-01_JPRB,6.0150E-01_JPRB,7.4434E-01_JPRB,7.7805E-01_JPRB/)
KBO( :, 4,52, 9) = (/&
&2.0524E-02_JPRB,2.3923E-02_JPRB,4.6343E-01_JPRB,7.1644E-01_JPRB,8.9011E-01_JPRB,9.4994E-01_JPRB/)
KBO( :, 5,52, 9) = (/&
&2.5821E-02_JPRB,2.8872E-02_JPRB,5.3465E-01_JPRB,8.3183E-01_JPRB,1.0363E+00_JPRB,1.1268E+00_JPRB/)
KBO( :, 1,53, 9) = (/&
&8.3963E-03_JPRB,1.2343E-02_JPRB,2.3325E-01_JPRB,3.4626E-01_JPRB,4.2244E-01_JPRB,4.0883E-01_JPRB/)
KBO( :, 2,53, 9) = (/&
&1.0621E-02_JPRB,1.4581E-02_JPRB,2.9700E-01_JPRB,4.4811E-01_JPRB,5.5051E-01_JPRB,5.5572E-01_JPRB/)
KBO( :, 3,53, 9) = (/&
&1.3693E-02_JPRB,1.7537E-02_JPRB,3.6501E-01_JPRB,5.5778E-01_JPRB,6.8933E-01_JPRB,7.1705E-01_JPRB/)
KBO( :, 4,53, 9) = (/&
&1.7633E-02_JPRB,2.1242E-02_JPRB,4.3562E-01_JPRB,6.7222E-01_JPRB,8.3412E-01_JPRB,8.8780E-01_JPRB/)
KBO( :, 5,53, 9) = (/&
&2.2506E-02_JPRB,2.5791E-02_JPRB,5.0721E-01_JPRB,7.8803E-01_JPRB,9.8102E-01_JPRB,1.0650E+00_JPRB/)
KBO( :, 1,54, 9) = (/&
&7.0177E-03_JPRB,1.0894E-02_JPRB,2.1095E-01_JPRB,3.1199E-01_JPRB,3.7969E-01_JPRB,3.6085E-01_JPRB/)
KBO( :, 2,54, 9) = (/&
&8.9302E-03_JPRB,1.2918E-02_JPRB,2.7298E-01_JPRB,4.1066E-01_JPRB,5.0363E-01_JPRB,5.0181E-01_JPRB/)
KBO( :, 3,54, 9) = (/&
&1.1634E-02_JPRB,1.5589E-02_JPRB,3.4013E-01_JPRB,5.1838E-01_JPRB,6.3970E-01_JPRB,6.5930E-01_JPRB/)
KBO( :, 4,54, 9) = (/&
&1.5199E-02_JPRB,1.8979E-02_JPRB,4.1032E-01_JPRB,6.3200E-01_JPRB,7.8327E-01_JPRB,8.2770E-01_JPRB/)
KBO( :, 5,54, 9) = (/&
&1.9687E-02_JPRB,2.3177E-02_JPRB,4.8201E-01_JPRB,7.4784E-01_JPRB,9.3015E-01_JPRB,1.0034E+00_JPRB/)
KBO( :, 1,55, 9) = (/&
&5.8731E-03_JPRB,9.6286E-03_JPRB,1.9052E-01_JPRB,2.8063E-01_JPRB,3.4069E-01_JPRB,3.1655E-01_JPRB/)
KBO( :, 2,55, 9) = (/&
&7.5168E-03_JPRB,1.1480E-02_JPRB,2.5064E-01_JPRB,3.7586E-01_JPRB,4.6019E-01_JPRB,4.5069E-01_JPRB/)
KBO( :, 3,55, 9) = (/&
&9.8853E-03_JPRB,1.3900E-02_JPRB,3.1669E-01_JPRB,4.8140E-01_JPRB,5.9307E-01_JPRB,6.0350E-01_JPRB/)
KBO( :, 4,55, 9) = (/&
&1.3096E-02_JPRB,1.7018E-02_JPRB,3.8628E-01_JPRB,5.9371E-01_JPRB,7.3500E-01_JPRB,7.6887E-01_JPRB/)
KBO( :, 5,55, 9) = (/&
&1.7222E-02_JPRB,2.0899E-02_JPRB,4.5791E-01_JPRB,7.0935E-01_JPRB,8.8144E-01_JPRB,9.4215E-01_JPRB/)
KBO( :, 1,56, 9) = (/&
&4.9060E-03_JPRB,8.5039E-03_JPRB,1.7111E-01_JPRB,2.5106E-01_JPRB,3.0385E-01_JPRB,2.7511E-01_JPRB/)
KBO( :, 2,56, 9) = (/&
&6.3120E-03_JPRB,1.0201E-02_JPRB,2.2915E-01_JPRB,3.4243E-01_JPRB,4.1847E-01_JPRB,4.0215E-01_JPRB/)
KBO( :, 3,56, 9) = (/&
&8.3672E-03_JPRB,1.2401E-02_JPRB,2.9378E-01_JPRB,4.4537E-01_JPRB,5.4774E-01_JPRB,5.4959E-01_JPRB/)
KBO( :, 4,56, 9) = (/&
&1.1240E-02_JPRB,1.5268E-02_JPRB,3.6263E-01_JPRB,5.5595E-01_JPRB,6.8746E-01_JPRB,7.1138E-01_JPRB/)
KBO( :, 5,56, 9) = (/&
&1.5010E-02_JPRB,1.8851E-02_JPRB,4.3398E-01_JPRB,6.7113E-01_JPRB,8.3300E-01_JPRB,8.8217E-01_JPRB/)
KBO( :, 1,57, 9) = (/&
&4.0878E-03_JPRB,7.4982E-03_JPRB,1.5269E-01_JPRB,2.2324E-01_JPRB,2.6911E-01_JPRB,2.3696E-01_JPRB/)
KBO( :, 2,57, 9) = (/&
&5.2898E-03_JPRB,9.0610E-03_JPRB,2.0850E-01_JPRB,3.1039E-01_JPRB,3.7842E-01_JPRB,3.5615E-01_JPRB/)
KBO( :, 3,57, 9) = (/&
&7.0606E-03_JPRB,1.1069E-02_JPRB,2.7146E-01_JPRB,4.1021E-01_JPRB,5.0366E-01_JPRB,4.9745E-01_JPRB/)
KBO( :, 4,57, 9) = (/&
&9.6071E-03_JPRB,1.3700E-02_JPRB,3.3939E-01_JPRB,5.1887E-01_JPRB,6.4072E-01_JPRB,6.5511E-01_JPRB/)
KBO( :, 5,57, 9) = (/&
&1.3031E-02_JPRB,1.7013E-02_JPRB,4.1025E-01_JPRB,6.3316E-01_JPRB,7.8498E-01_JPRB,8.2331E-01_JPRB/)
KBO( :, 1,58, 9) = (/&
&3.4110E-03_JPRB,6.6187E-03_JPRB,1.3608E-01_JPRB,1.9844E-01_JPRB,2.3812E-01_JPRB,2.0347E-01_JPRB/)
KBO( :, 2,58, 9) = (/&
&4.4437E-03_JPRB,8.0723E-03_JPRB,1.8969E-01_JPRB,2.8123E-01_JPRB,3.4208E-01_JPRB,3.1439E-01_JPRB/)
KBO( :, 3,58, 9) = (/&
&5.9725E-03_JPRB,9.9123E-03_JPRB,2.5079E-01_JPRB,3.7777E-01_JPRB,4.6311E-01_JPRB,4.4931E-01_JPRB/)
KBO( :, 4,58, 9) = (/&
&8.2191E-03_JPRB,1.2333E-02_JPRB,3.1765E-01_JPRB,4.8433E-01_JPRB,5.9715E-01_JPRB,6.0236E-01_JPRB/)
KBO( :, 5,58, 9) = (/&
&1.1325E-02_JPRB,1.5419E-02_JPRB,3.8789E-01_JPRB,5.9740E-01_JPRB,7.3982E-01_JPRB,7.6757E-01_JPRB/)
KBO( :, 1,59, 9) = (/&
&2.9777E-03_JPRB,6.0559E-03_JPRB,1.2911E-01_JPRB,1.8831E-01_JPRB,2.2557E-01_JPRB,1.8804E-01_JPRB/)
KBO( :, 2,59, 9) = (/&
&3.9243E-03_JPRB,7.4586E-03_JPRB,1.8188E-01_JPRB,2.6942E-01_JPRB,3.2742E-01_JPRB,2.9431E-01_JPRB/)
KBO( :, 3,59, 9) = (/&
&5.3410E-03_JPRB,9.2341E-03_JPRB,2.4229E-01_JPRB,3.6461E-01_JPRB,4.4670E-01_JPRB,4.2516E-01_JPRB/)
KBO( :, 4,59, 9) = (/&
&7.4484E-03_JPRB,1.1574E-02_JPRB,3.0869E-01_JPRB,4.7031E-01_JPRB,5.7948E-01_JPRB,5.7493E-01_JPRB/)
KBO( :, 5,59, 9) = (/&
&1.0416E-02_JPRB,1.4573E-02_JPRB,3.7872E-01_JPRB,5.8281E-01_JPRB,7.2146E-01_JPRB,7.3756E-01_JPRB/)
KBO( :, 1,13,10) = (/&
&7.5289E+00_JPRB,7.5248E+00_JPRB,5.8020E+00_JPRB,4.2235E+00_JPRB,3.4788E+00_JPRB,3.3830E+00_JPRB/)
KBO( :, 2,13,10) = (/&
&7.5373E+00_JPRB,7.5331E+00_JPRB,5.7965E+00_JPRB,4.1949E+00_JPRB,3.4100E+00_JPRB,3.3091E+00_JPRB/)
KBO( :, 3,13,10) = (/&
&7.5342E+00_JPRB,7.5300E+00_JPRB,5.7907E+00_JPRB,4.1656E+00_JPRB,3.3402E+00_JPRB,3.2690E+00_JPRB/)
KBO( :, 4,13,10) = (/&
&7.4927E+00_JPRB,7.4886E+00_JPRB,5.7565E+00_JPRB,4.1206E+00_JPRB,3.2641E+00_JPRB,3.2567E+00_JPRB/)
KBO( :, 5,13,10) = (/&
&7.4212E+00_JPRB,7.4171E+00_JPRB,5.6978E+00_JPRB,4.0611E+00_JPRB,3.1856E+00_JPRB,3.2490E+00_JPRB/)
KBO( :, 1,14,10) = (/&
&7.4571E+00_JPRB,7.4529E+00_JPRB,5.7300E+00_JPRB,4.2516E+00_JPRB,3.6973E+00_JPRB,3.6249E+00_JPRB/)
KBO( :, 2,14,10) = (/&
&7.4407E+00_JPRB,7.4365E+00_JPRB,5.7211E+00_JPRB,4.2113E+00_JPRB,3.6244E+00_JPRB,3.5667E+00_JPRB/)
KBO( :, 3,14,10) = (/&
&7.3963E+00_JPRB,7.3922E+00_JPRB,5.6812E+00_JPRB,4.1556E+00_JPRB,3.5526E+00_JPRB,3.5115E+00_JPRB/)
KBO( :, 4,14,10) = (/&
&7.3296E+00_JPRB,7.3255E+00_JPRB,5.6249E+00_JPRB,4.0935E+00_JPRB,3.4766E+00_JPRB,3.4707E+00_JPRB/)
KBO( :, 5,14,10) = (/&
&7.2465E+00_JPRB,7.2425E+00_JPRB,5.5619E+00_JPRB,4.0245E+00_JPRB,3.4020E+00_JPRB,3.4493E+00_JPRB/)
KBO( :, 1,15,10) = (/&
&7.1911E+00_JPRB,7.1871E+00_JPRB,5.5280E+00_JPRB,4.2968E+00_JPRB,3.9627E+00_JPRB,3.9090E+00_JPRB/)
KBO( :, 2,15,10) = (/&
&7.1513E+00_JPRB,7.1474E+00_JPRB,5.4956E+00_JPRB,4.2289E+00_JPRB,3.8871E+00_JPRB,3.8400E+00_JPRB/)
KBO( :, 3,15,10) = (/&
&7.0923E+00_JPRB,7.0884E+00_JPRB,5.4464E+00_JPRB,4.1468E+00_JPRB,3.8062E+00_JPRB,3.7828E+00_JPRB/)
KBO( :, 4,15,10) = (/&
&6.9934E+00_JPRB,6.9895E+00_JPRB,5.3713E+00_JPRB,4.0638E+00_JPRB,3.7328E+00_JPRB,3.7290E+00_JPRB/)
KBO( :, 5,15,10) = (/&
&6.8864E+00_JPRB,6.8825E+00_JPRB,5.2899E+00_JPRB,3.9761E+00_JPRB,3.6483E+00_JPRB,3.6704E+00_JPRB/)
KBO( :, 1,16,10) = (/&
&6.7911E+00_JPRB,6.7873E+00_JPRB,5.2205E+00_JPRB,4.3199E+00_JPRB,4.2502E+00_JPRB,4.2466E+00_JPRB/)
KBO( :, 2,16,10) = (/&
&6.7263E+00_JPRB,6.7226E+00_JPRB,5.1711E+00_JPRB,4.2329E+00_JPRB,4.1599E+00_JPRB,4.1741E+00_JPRB/)
KBO( :, 3,16,10) = (/&
&6.6333E+00_JPRB,6.6296E+00_JPRB,5.0988E+00_JPRB,4.1448E+00_JPRB,4.0703E+00_JPRB,4.1094E+00_JPRB/)
KBO( :, 4,16,10) = (/&
&6.5280E+00_JPRB,6.5244E+00_JPRB,5.0198E+00_JPRB,4.0496E+00_JPRB,3.9801E+00_JPRB,4.0403E+00_JPRB/)
KBO( :, 5,16,10) = (/&
&6.4167E+00_JPRB,6.4131E+00_JPRB,4.9361E+00_JPRB,3.9499E+00_JPRB,3.8927E+00_JPRB,3.9614E+00_JPRB/)
KBO( :, 1,17,10) = (/&
&6.2531E+00_JPRB,6.2497E+00_JPRB,4.8286E+00_JPRB,4.3686E+00_JPRB,4.5172E+00_JPRB,4.6364E+00_JPRB/)
KBO( :, 2,17,10) = (/&
&6.1677E+00_JPRB,6.1643E+00_JPRB,4.7626E+00_JPRB,4.2792E+00_JPRB,4.4298E+00_JPRB,4.5601E+00_JPRB/)
KBO( :, 3,17,10) = (/&
&6.0747E+00_JPRB,6.0713E+00_JPRB,4.6908E+00_JPRB,4.1860E+00_JPRB,4.3428E+00_JPRB,4.4812E+00_JPRB/)
KBO( :, 4,17,10) = (/&
&5.9604E+00_JPRB,5.9571E+00_JPRB,4.6053E+00_JPRB,4.0899E+00_JPRB,4.2570E+00_JPRB,4.3935E+00_JPRB/)
KBO( :, 5,17,10) = (/&
&5.8291E+00_JPRB,5.8259E+00_JPRB,4.5089E+00_JPRB,3.9935E+00_JPRB,4.1733E+00_JPRB,4.3011E+00_JPRB/)
KBO( :, 1,18,10) = (/&
&5.6266E+00_JPRB,5.6236E+00_JPRB,4.4207E+00_JPRB,4.4989E+00_JPRB,4.8053E+00_JPRB,5.0247E+00_JPRB/)
KBO( :, 2,18,10) = (/&
&5.5427E+00_JPRB,5.5397E+00_JPRB,4.3512E+00_JPRB,4.4021E+00_JPRB,4.7226E+00_JPRB,4.9470E+00_JPRB/)
KBO( :, 3,18,10) = (/&
&5.4374E+00_JPRB,5.4345E+00_JPRB,4.2669E+00_JPRB,4.3054E+00_JPRB,4.6429E+00_JPRB,4.8548E+00_JPRB/)
KBO( :, 4,18,10) = (/&
&5.3118E+00_JPRB,5.3090E+00_JPRB,4.1727E+00_JPRB,4.2046E+00_JPRB,4.5567E+00_JPRB,4.7652E+00_JPRB/)
KBO( :, 5,18,10) = (/&
&5.1788E+00_JPRB,5.1760E+00_JPRB,4.0826E+00_JPRB,4.1045E+00_JPRB,4.4583E+00_JPRB,4.6766E+00_JPRB/)
KBO( :, 1,19,10) = (/&
&4.9892E+00_JPRB,4.9865E+00_JPRB,4.1022E+00_JPRB,4.6290E+00_JPRB,5.1554E+00_JPRB,5.3946E+00_JPRB/)
KBO( :, 2,19,10) = (/&
&4.8951E+00_JPRB,4.8924E+00_JPRB,4.0165E+00_JPRB,4.5273E+00_JPRB,5.0702E+00_JPRB,5.3073E+00_JPRB/)
KBO( :, 3,19,10) = (/&
&4.7798E+00_JPRB,4.7773E+00_JPRB,3.9238E+00_JPRB,4.4269E+00_JPRB,4.9753E+00_JPRB,5.2208E+00_JPRB/)
KBO( :, 4,19,10) = (/&
&4.6598E+00_JPRB,4.6573E+00_JPRB,3.8352E+00_JPRB,4.3303E+00_JPRB,4.8704E+00_JPRB,5.1400E+00_JPRB/)
KBO( :, 5,19,10) = (/&
&4.5508E+00_JPRB,4.5484E+00_JPRB,3.7462E+00_JPRB,4.2290E+00_JPRB,4.7590E+00_JPRB,5.0603E+00_JPRB/)
KBO( :, 1,20,10) = (/&
&4.3446E+00_JPRB,4.3423E+00_JPRB,3.8795E+00_JPRB,4.7522E+00_JPRB,5.5065E+00_JPRB,5.7535E+00_JPRB/)
KBO( :, 2,20,10) = (/&
&4.2431E+00_JPRB,4.2409E+00_JPRB,3.7927E+00_JPRB,4.6561E+00_JPRB,5.4004E+00_JPRB,5.6800E+00_JPRB/)
KBO( :, 3,20,10) = (/&
&4.1397E+00_JPRB,4.1376E+00_JPRB,3.7047E+00_JPRB,4.5585E+00_JPRB,5.2878E+00_JPRB,5.6033E+00_JPRB/)
KBO( :, 4,20,10) = (/&
&4.0481E+00_JPRB,4.0460E+00_JPRB,3.6150E+00_JPRB,4.4575E+00_JPRB,5.1721E+00_JPRB,5.5261E+00_JPRB/)
KBO( :, 5,20,10) = (/&
&3.9765E+00_JPRB,3.9744E+00_JPRB,3.5343E+00_JPRB,4.3595E+00_JPRB,5.0554E+00_JPRB,5.4406E+00_JPRB/)
KBO( :, 1,21,10) = (/&
&3.7211E+00_JPRB,3.7192E+00_JPRB,3.7613E+00_JPRB,4.9074E+00_JPRB,5.7827E+00_JPRB,6.1154E+00_JPRB/)
KBO( :, 2,21,10) = (/&
&3.6330E+00_JPRB,3.6312E+00_JPRB,3.6717E+00_JPRB,4.8116E+00_JPRB,5.6714E+00_JPRB,6.0506E+00_JPRB/)
KBO( :, 3,21,10) = (/&
&3.5589E+00_JPRB,3.5571E+00_JPRB,3.5807E+00_JPRB,4.7108E+00_JPRB,5.5635E+00_JPRB,5.9724E+00_JPRB/)
KBO( :, 4,21,10) = (/&
&3.5073E+00_JPRB,3.5055E+00_JPRB,3.5016E+00_JPRB,4.6097E+00_JPRB,5.4603E+00_JPRB,5.8886E+00_JPRB/)
KBO( :, 5,21,10) = (/&
&3.4691E+00_JPRB,3.4674E+00_JPRB,3.4364E+00_JPRB,4.5052E+00_JPRB,5.3541E+00_JPRB,5.8090E+00_JPRB/)
KBO( :, 1,22,10) = (/&
&3.1543E+00_JPRB,3.1527E+00_JPRB,3.6782E+00_JPRB,5.0447E+00_JPRB,6.0160E+00_JPRB,6.4253E+00_JPRB/)
KBO( :, 2,22,10) = (/&
&3.0969E+00_JPRB,3.0954E+00_JPRB,3.5898E+00_JPRB,4.9499E+00_JPRB,5.9206E+00_JPRB,6.3659E+00_JPRB/)
KBO( :, 3,22,10) = (/&
&3.0620E+00_JPRB,3.0605E+00_JPRB,3.5058E+00_JPRB,4.8486E+00_JPRB,5.8265E+00_JPRB,6.2989E+00_JPRB/)
KBO( :, 4,22,10) = (/&
&3.0425E+00_JPRB,3.0410E+00_JPRB,3.4395E+00_JPRB,4.7446E+00_JPRB,5.7289E+00_JPRB,6.2283E+00_JPRB/)
KBO( :, 5,22,10) = (/&
&3.0546E+00_JPRB,3.0532E+00_JPRB,3.3854E+00_JPRB,4.6358E+00_JPRB,5.6252E+00_JPRB,6.1603E+00_JPRB/)
KBO( :, 1,23,10) = (/&
&2.6854E+00_JPRB,2.6841E+00_JPRB,3.6308E+00_JPRB,5.1459E+00_JPRB,6.2399E+00_JPRB,6.6740E+00_JPRB/)
KBO( :, 2,23,10) = (/&
&2.6617E+00_JPRB,2.6604E+00_JPRB,3.5468E+00_JPRB,5.0540E+00_JPRB,6.1652E+00_JPRB,6.6315E+00_JPRB/)
KBO( :, 3,23,10) = (/&
&2.6584E+00_JPRB,2.6571E+00_JPRB,3.4703E+00_JPRB,4.9599E+00_JPRB,6.0780E+00_JPRB,6.5824E+00_JPRB/)
KBO( :, 4,23,10) = (/&
&2.6872E+00_JPRB,2.6859E+00_JPRB,3.4111E+00_JPRB,4.8587E+00_JPRB,5.9856E+00_JPRB,6.5287E+00_JPRB/)
KBO( :, 5,23,10) = (/&
&2.7417E+00_JPRB,2.7405E+00_JPRB,3.3560E+00_JPRB,4.7548E+00_JPRB,5.8884E+00_JPRB,6.4686E+00_JPRB/)
KBO( :, 1,24,10) = (/&
&2.3151E+00_JPRB,2.3140E+00_JPRB,3.5886E+00_JPRB,5.2274E+00_JPRB,6.4311E+00_JPRB,6.8789E+00_JPRB/)
KBO( :, 2,24,10) = (/&
&2.3230E+00_JPRB,2.3219E+00_JPRB,3.5113E+00_JPRB,5.1442E+00_JPRB,6.3705E+00_JPRB,6.8549E+00_JPRB/)
KBO( :, 3,24,10) = (/&
&2.3609E+00_JPRB,2.3598E+00_JPRB,3.4524E+00_JPRB,5.0514E+00_JPRB,6.2984E+00_JPRB,6.8163E+00_JPRB/)
KBO( :, 4,24,10) = (/&
&2.4175E+00_JPRB,2.4164E+00_JPRB,3.3989E+00_JPRB,4.9521E+00_JPRB,6.2181E+00_JPRB,6.7710E+00_JPRB/)
KBO( :, 5,24,10) = (/&
&2.4762E+00_JPRB,2.4752E+00_JPRB,3.3577E+00_JPRB,4.8533E+00_JPRB,6.1278E+00_JPRB,6.7244E+00_JPRB/)
KBO( :, 1,25,10) = (/&
&2.0244E+00_JPRB,2.0235E+00_JPRB,3.5269E+00_JPRB,5.2724E+00_JPRB,6.5740E+00_JPRB,7.0315E+00_JPRB/)
KBO( :, 2,25,10) = (/&
&2.0651E+00_JPRB,2.0643E+00_JPRB,3.4750E+00_JPRB,5.1965E+00_JPRB,6.5327E+00_JPRB,7.0283E+00_JPRB/)
KBO( :, 3,25,10) = (/&
&2.1229E+00_JPRB,2.1220E+00_JPRB,3.4316E+00_JPRB,5.1098E+00_JPRB,6.4777E+00_JPRB,7.0013E+00_JPRB/)
KBO( :, 4,25,10) = (/&
&2.1858E+00_JPRB,2.1849E+00_JPRB,3.3932E+00_JPRB,5.0189E+00_JPRB,6.4050E+00_JPRB,6.9699E+00_JPRB/)
KBO( :, 5,25,10) = (/&
&2.2519E+00_JPRB,2.2510E+00_JPRB,3.3680E+00_JPRB,4.9354E+00_JPRB,6.3143E+00_JPRB,6.9411E+00_JPRB/)
KBO( :, 1,26,10) = (/&
&1.8038E+00_JPRB,1.8031E+00_JPRB,3.4751E+00_JPRB,5.2741E+00_JPRB,6.6754E+00_JPRB,7.1367E+00_JPRB/)
KBO( :, 2,26,10) = (/&
&1.8584E+00_JPRB,1.8577E+00_JPRB,3.4421E+00_JPRB,5.2128E+00_JPRB,6.6468E+00_JPRB,7.1525E+00_JPRB/)
KBO( :, 3,26,10) = (/&
&1.9217E+00_JPRB,1.9209E+00_JPRB,3.4089E+00_JPRB,5.1445E+00_JPRB,6.6040E+00_JPRB,7.1457E+00_JPRB/)
KBO( :, 4,26,10) = (/&
&1.9824E+00_JPRB,1.9816E+00_JPRB,3.3919E+00_JPRB,5.0736E+00_JPRB,6.5398E+00_JPRB,7.1301E+00_JPRB/)
KBO( :, 5,26,10) = (/&
&2.0431E+00_JPRB,2.0423E+00_JPRB,3.3693E+00_JPRB,5.0098E+00_JPRB,6.4614E+00_JPRB,7.1116E+00_JPRB/)
KBO( :, 1,27,10) = (/&
&1.6205E+00_JPRB,1.6200E+00_JPRB,3.4312E+00_JPRB,5.2512E+00_JPRB,6.7302E+00_JPRB,7.1916E+00_JPRB/)
KBO( :, 2,27,10) = (/&
&1.6821E+00_JPRB,1.6815E+00_JPRB,3.4096E+00_JPRB,5.2107E+00_JPRB,6.7204E+00_JPRB,7.2341E+00_JPRB/)
KBO( :, 3,27,10) = (/&
&1.7393E+00_JPRB,1.7387E+00_JPRB,3.3986E+00_JPRB,5.1611E+00_JPRB,6.6901E+00_JPRB,7.2461E+00_JPRB/)
KBO( :, 4,27,10) = (/&
&1.7952E+00_JPRB,1.7945E+00_JPRB,3.3849E+00_JPRB,5.1118E+00_JPRB,6.6400E+00_JPRB,7.2521E+00_JPRB/)
KBO( :, 5,27,10) = (/&
&1.8467E+00_JPRB,1.8460E+00_JPRB,3.3678E+00_JPRB,5.0688E+00_JPRB,6.5750E+00_JPRB,7.2529E+00_JPRB/)
KBO( :, 1,28,10) = (/&
&1.4581E+00_JPRB,1.4577E+00_JPRB,3.3793E+00_JPRB,5.2151E+00_JPRB,6.7528E+00_JPRB,7.2099E+00_JPRB/)
KBO( :, 2,28,10) = (/&
&1.5130E+00_JPRB,1.5126E+00_JPRB,3.3785E+00_JPRB,5.1947E+00_JPRB,6.7653E+00_JPRB,7.2740E+00_JPRB/)
KBO( :, 3,28,10) = (/&
&1.5669E+00_JPRB,1.5664E+00_JPRB,3.3810E+00_JPRB,5.1664E+00_JPRB,6.7512E+00_JPRB,7.3192E+00_JPRB/)
KBO( :, 4,28,10) = (/&
&1.6172E+00_JPRB,1.6166E+00_JPRB,3.3732E+00_JPRB,5.1425E+00_JPRB,6.7177E+00_JPRB,7.3590E+00_JPRB/)
KBO( :, 5,28,10) = (/&
&1.6631E+00_JPRB,1.6625E+00_JPRB,3.3694E+00_JPRB,5.1109E+00_JPRB,6.6624E+00_JPRB,7.3782E+00_JPRB/)
KBO( :, 1,29,10) = (/&
&1.3022E+00_JPRB,1.3019E+00_JPRB,3.3270E+00_JPRB,5.1728E+00_JPRB,6.7559E+00_JPRB,7.2096E+00_JPRB/)
KBO( :, 2,29,10) = (/&
&1.3533E+00_JPRB,1.3529E+00_JPRB,3.3473E+00_JPRB,5.1723E+00_JPRB,6.7905E+00_JPRB,7.3069E+00_JPRB/)
KBO( :, 3,29,10) = (/&
&1.4031E+00_JPRB,1.4027E+00_JPRB,3.3571E+00_JPRB,5.1703E+00_JPRB,6.7965E+00_JPRB,7.3925E+00_JPRB/)
KBO( :, 4,29,10) = (/&
&1.4491E+00_JPRB,1.4487E+00_JPRB,3.3643E+00_JPRB,5.1652E+00_JPRB,6.7741E+00_JPRB,7.4637E+00_JPRB/)
KBO( :, 5,29,10) = (/&
&1.4926E+00_JPRB,1.4921E+00_JPRB,3.3697E+00_JPRB,5.1473E+00_JPRB,6.7261E+00_JPRB,7.4940E+00_JPRB/)
KBO( :, 1,30,10) = (/&
&1.1600E+00_JPRB,1.1597E+00_JPRB,3.2811E+00_JPRB,5.1242E+00_JPRB,6.7455E+00_JPRB,7.2055E+00_JPRB/)
KBO( :, 2,30,10) = (/&
&1.2064E+00_JPRB,1.2061E+00_JPRB,3.3125E+00_JPRB,5.1497E+00_JPRB,6.8027E+00_JPRB,7.3456E+00_JPRB/)
KBO( :, 3,30,10) = (/&
&1.2511E+00_JPRB,1.2508E+00_JPRB,3.3366E+00_JPRB,5.1707E+00_JPRB,6.8233E+00_JPRB,7.4712E+00_JPRB/)
KBO( :, 4,30,10) = (/&
&1.2939E+00_JPRB,1.2935E+00_JPRB,3.3556E+00_JPRB,5.1801E+00_JPRB,6.8143E+00_JPRB,7.5611E+00_JPRB/)
KBO( :, 5,30,10) = (/&
&1.3350E+00_JPRB,1.3346E+00_JPRB,3.3660E+00_JPRB,5.1735E+00_JPRB,6.7754E+00_JPRB,7.6031E+00_JPRB/)
KBO( :, 1,31,10) = (/&
&1.0335E+00_JPRB,1.0333E+00_JPRB,3.2413E+00_JPRB,5.0768E+00_JPRB,6.7328E+00_JPRB,7.2247E+00_JPRB/)
KBO( :, 2,31,10) = (/&
&1.0751E+00_JPRB,1.0749E+00_JPRB,3.2817E+00_JPRB,5.1294E+00_JPRB,6.8096E+00_JPRB,7.4118E+00_JPRB/)
KBO( :, 3,31,10) = (/&
&1.1154E+00_JPRB,1.1152E+00_JPRB,3.3173E+00_JPRB,5.1678E+00_JPRB,6.8467E+00_JPRB,7.5648E+00_JPRB/)
KBO( :, 4,31,10) = (/&
&1.1549E+00_JPRB,1.1546E+00_JPRB,3.3453E+00_JPRB,5.1899E+00_JPRB,6.8485E+00_JPRB,7.6626E+00_JPRB/)
KBO( :, 5,31,10) = (/&
&1.1976E+00_JPRB,1.1973E+00_JPRB,3.3597E+00_JPRB,5.1968E+00_JPRB,6.8174E+00_JPRB,7.7173E+00_JPRB/)
KBO( :, 1,32,10) = (/&
&9.2196E-01_JPRB,9.2184E-01_JPRB,3.2061E+00_JPRB,5.0420E+00_JPRB,6.7251E+00_JPRB,7.2717E+00_JPRB/)
KBO( :, 2,32,10) = (/&
&9.5916E-01_JPRB,9.5901E-01_JPRB,3.2581E+00_JPRB,5.1143E+00_JPRB,6.8187E+00_JPRB,7.4921E+00_JPRB/)
KBO( :, 3,32,10) = (/&
&9.9613E-01_JPRB,9.9593E-01_JPRB,3.3030E+00_JPRB,5.1678E+00_JPRB,6.8677E+00_JPRB,7.6515E+00_JPRB/)
KBO( :, 4,32,10) = (/&
&1.0359E+00_JPRB,1.0357E+00_JPRB,3.3356E+00_JPRB,5.2002E+00_JPRB,6.8779E+00_JPRB,7.7596E+00_JPRB/)
KBO( :, 5,32,10) = (/&
&1.0855E+00_JPRB,1.0851E+00_JPRB,3.3519E+00_JPRB,5.2172E+00_JPRB,6.8517E+00_JPRB,7.8246E+00_JPRB/)
KBO( :, 1,33,10) = (/&
&8.2444E-01_JPRB,8.2438E-01_JPRB,3.1786E+00_JPRB,5.0173E+00_JPRB,6.7243E+00_JPRB,7.3448E+00_JPRB/)
KBO( :, 2,33,10) = (/&
&8.5838E-01_JPRB,8.5826E-01_JPRB,3.2411E+00_JPRB,5.1061E+00_JPRB,6.8299E+00_JPRB,7.5783E+00_JPRB/)
KBO( :, 3,33,10) = (/&
&8.9425E-01_JPRB,8.9407E-01_JPRB,3.2909E+00_JPRB,5.1715E+00_JPRB,6.8889E+00_JPRB,7.7451E+00_JPRB/)
KBO( :, 4,33,10) = (/&
&9.3902E-01_JPRB,9.3875E-01_JPRB,3.3252E+00_JPRB,5.2146E+00_JPRB,6.9056E+00_JPRB,7.8681E+00_JPRB/)
KBO( :, 5,33,10) = (/&
&9.9963E-01_JPRB,9.9926E-01_JPRB,3.3429E+00_JPRB,5.2364E+00_JPRB,6.8820E+00_JPRB,7.9383E+00_JPRB/)
KBO( :, 1,34,10) = (/&
&7.3808E-01_JPRB,7.3807E-01_JPRB,3.1554E+00_JPRB,5.0005E+00_JPRB,6.7270E+00_JPRB,7.4193E+00_JPRB/)
KBO( :, 2,34,10) = (/&
&7.7041E-01_JPRB,7.7031E-01_JPRB,3.2245E+00_JPRB,5.1037E+00_JPRB,6.8428E+00_JPRB,7.6564E+00_JPRB/)
KBO( :, 3,34,10) = (/&
&8.0927E-01_JPRB,8.0908E-01_JPRB,3.2785E+00_JPRB,5.1786E+00_JPRB,6.9090E+00_JPRB,7.8421E+00_JPRB/)
KBO( :, 4,34,10) = (/&
&8.6226E-01_JPRB,8.6198E-01_JPRB,3.3161E+00_JPRB,5.2290E+00_JPRB,6.9264E+00_JPRB,7.9654E+00_JPRB/)
KBO( :, 5,34,10) = (/&
&9.3161E-01_JPRB,9.3129E-01_JPRB,3.3332E+00_JPRB,5.2535E+00_JPRB,6.9068E+00_JPRB,8.0359E+00_JPRB/)
KBO( :, 1,35,10) = (/&
&6.6091E-01_JPRB,6.6090E-01_JPRB,3.1297E+00_JPRB,4.9826E+00_JPRB,6.7231E+00_JPRB,7.4730E+00_JPRB/)
KBO( :, 2,35,10) = (/&
&6.9343E-01_JPRB,6.9337E-01_JPRB,3.2054E+00_JPRB,5.0985E+00_JPRB,6.8504E+00_JPRB,7.7289E+00_JPRB/)
KBO( :, 3,35,10) = (/&
&7.3707E-01_JPRB,7.3689E-01_JPRB,3.2647E+00_JPRB,5.1833E+00_JPRB,6.9233E+00_JPRB,7.9244E+00_JPRB/)
KBO( :, 4,35,10) = (/&
&7.9689E-01_JPRB,7.9665E-01_JPRB,3.3047E+00_JPRB,5.2421E+00_JPRB,6.9456E+00_JPRB,8.0506E+00_JPRB/)
KBO( :, 5,35,10) = (/&
&8.7135E-01_JPRB,8.7107E-01_JPRB,3.3248E+00_JPRB,5.2688E+00_JPRB,6.9299E+00_JPRB,8.1175E+00_JPRB/)
KBO( :, 1,36,10) = (/&
&5.9261E-01_JPRB,5.9263E-01_JPRB,3.0998E+00_JPRB,4.9572E+00_JPRB,6.7063E+00_JPRB,7.5006E+00_JPRB/)
KBO( :, 2,36,10) = (/&
&6.2616E-01_JPRB,6.2611E-01_JPRB,3.1830E+00_JPRB,5.0867E+00_JPRB,6.8489E+00_JPRB,7.7811E+00_JPRB/)
KBO( :, 3,36,10) = (/&
&6.7343E-01_JPRB,6.7330E-01_JPRB,3.2478E+00_JPRB,5.1832E+00_JPRB,6.9309E+00_JPRB,7.9826E+00_JPRB/)
KBO( :, 4,36,10) = (/&
&7.3660E-01_JPRB,7.3640E-01_JPRB,3.2928E+00_JPRB,5.2484E+00_JPRB,6.9611E+00_JPRB,8.1184E+00_JPRB/)
KBO( :, 5,36,10) = (/&
&8.1395E-01_JPRB,8.1372E-01_JPRB,3.3165E+00_JPRB,5.2807E+00_JPRB,6.9512E+00_JPRB,8.1925E+00_JPRB/)
KBO( :, 1,37,10) = (/&
&5.2989E-01_JPRB,5.2996E-01_JPRB,3.0580E+00_JPRB,4.9104E+00_JPRB,6.6637E+00_JPRB,7.4740E+00_JPRB/)
KBO( :, 2,37,10) = (/&
&5.6419E-01_JPRB,5.6414E-01_JPRB,3.1506E+00_JPRB,5.0576E+00_JPRB,6.8262E+00_JPRB,7.7836E+00_JPRB/)
KBO( :, 3,37,10) = (/&
&6.1196E-01_JPRB,6.1186E-01_JPRB,3.2232E+00_JPRB,5.1694E+00_JPRB,6.9254E+00_JPRB,8.0021E+00_JPRB/)
KBO( :, 4,37,10) = (/&
&6.7516E-01_JPRB,6.7503E-01_JPRB,3.2773E+00_JPRB,5.2468E+00_JPRB,6.9696E+00_JPRB,8.1546E+00_JPRB/)
KBO( :, 5,37,10) = (/&
&7.5242E-01_JPRB,7.5225E-01_JPRB,3.3077E+00_JPRB,5.2880E+00_JPRB,6.9712E+00_JPRB,8.2436E+00_JPRB/)
KBO( :, 1,38,10) = (/&
&4.7505E-01_JPRB,4.7513E-01_JPRB,3.0176E+00_JPRB,4.8628E+00_JPRB,6.6172E+00_JPRB,7.4494E+00_JPRB/)
KBO( :, 2,38,10) = (/&
&5.1071E-01_JPRB,5.1070E-01_JPRB,3.1197E+00_JPRB,5.0269E+00_JPRB,6.7975E+00_JPRB,7.7810E+00_JPRB/)
KBO( :, 3,38,10) = (/&
&5.5877E-01_JPRB,5.5872E-01_JPRB,3.2002E+00_JPRB,5.1526E+00_JPRB,6.9148E+00_JPRB,8.0180E+00_JPRB/)
KBO( :, 4,38,10) = (/&
&6.2123E-01_JPRB,6.2116E-01_JPRB,3.2619E+00_JPRB,5.2424E+00_JPRB,6.9725E+00_JPRB,8.1853E+00_JPRB/)
KBO( :, 5,38,10) = (/&
&6.9700E-01_JPRB,6.9689E-01_JPRB,3.2986E+00_JPRB,5.2927E+00_JPRB,6.9850E+00_JPRB,8.2945E+00_JPRB/)
KBO( :, 1,39,10) = (/&
&4.2667E-01_JPRB,4.2675E-01_JPRB,2.9792E+00_JPRB,4.8162E+00_JPRB,6.5678E+00_JPRB,7.4301E+00_JPRB/)
KBO( :, 2,39,10) = (/&
&4.6368E-01_JPRB,4.6371E-01_JPRB,3.0898E+00_JPRB,4.9949E+00_JPRB,6.7657E+00_JPRB,7.7791E+00_JPRB/)
KBO( :, 3,39,10) = (/&
&5.1271E-01_JPRB,5.1271E-01_JPRB,3.1789E+00_JPRB,5.1345E+00_JPRB,6.8995E+00_JPRB,8.0327E+00_JPRB/)
KBO( :, 4,39,10) = (/&
&5.7418E-01_JPRB,5.7416E-01_JPRB,3.2474E+00_JPRB,5.2350E+00_JPRB,6.9705E+00_JPRB,8.2154E+00_JPRB/)
KBO( :, 5,39,10) = (/&
&6.4813E-01_JPRB,6.4808E-01_JPRB,3.2906E+00_JPRB,5.2946E+00_JPRB,6.9954E+00_JPRB,8.3481E+00_JPRB/)
KBO( :, 1,40,10) = (/&
&3.8059E-01_JPRB,3.8066E-01_JPRB,2.9294E+00_JPRB,4.7482E+00_JPRB,6.4900E+00_JPRB,7.3413E+00_JPRB/)
KBO( :, 2,40,10) = (/&
&4.1764E-01_JPRB,4.1768E-01_JPRB,3.0517E+00_JPRB,4.9455E+00_JPRB,6.7137E+00_JPRB,7.7220E+00_JPRB/)
KBO( :, 3,40,10) = (/&
&4.6631E-01_JPRB,4.6635E-01_JPRB,3.1498E+00_JPRB,5.1004E+00_JPRB,6.8682E+00_JPRB,8.0003E+00_JPRB/)
KBO( :, 4,40,10) = (/&
&5.2644E-01_JPRB,5.2648E-01_JPRB,3.2265E+00_JPRB,5.2162E+00_JPRB,6.9603E+00_JPRB,8.2072E+00_JPRB/)
KBO( :, 5,40,10) = (/&
&5.9702E-01_JPRB,5.9703E-01_JPRB,3.2787E+00_JPRB,5.2882E+00_JPRB,7.0004E+00_JPRB,8.3571E+00_JPRB/)
KBO( :, 1,41,10) = (/&
&3.3906E-01_JPRB,3.3914E-01_JPRB,2.8764E+00_JPRB,4.6750E+00_JPRB,6.4031E+00_JPRB,7.2374E+00_JPRB/)
KBO( :, 2,41,10) = (/&
&3.7555E-01_JPRB,3.7562E-01_JPRB,3.0116E+00_JPRB,4.8899E+00_JPRB,6.6527E+00_JPRB,7.6510E+00_JPRB/)
KBO( :, 3,41,10) = (/&
&4.2374E-01_JPRB,4.2382E-01_JPRB,3.1192E+00_JPRB,5.0596E+00_JPRB,6.8298E+00_JPRB,7.9584E+00_JPRB/)
KBO( :, 4,41,10) = (/&
&4.8252E-01_JPRB,4.8261E-01_JPRB,3.2032E+00_JPRB,5.1909E+00_JPRB,6.9423E+00_JPRB,8.1883E+00_JPRB/)
KBO( :, 5,41,10) = (/&
&5.5055E-01_JPRB,5.5059E-01_JPRB,3.2647E+00_JPRB,5.2767E+00_JPRB,6.9993E+00_JPRB,8.3564E+00_JPRB/)
KBO( :, 1,42,10) = (/&
&3.0216E-01_JPRB,3.0227E-01_JPRB,2.8228E+00_JPRB,4.6001E+00_JPRB,6.3100E+00_JPRB,7.1283E+00_JPRB/)
KBO( :, 2,42,10) = (/&
&3.3749E-01_JPRB,3.3759E-01_JPRB,2.9700E+00_JPRB,4.8303E+00_JPRB,6.5864E+00_JPRB,7.5749E+00_JPRB/)
KBO( :, 3,42,10) = (/&
&3.8480E-01_JPRB,3.8492E-01_JPRB,3.0865E+00_JPRB,5.0162E+00_JPRB,6.7847E+00_JPRB,7.9100E+00_JPRB/)
KBO( :, 4,42,10) = (/&
&4.4288E-01_JPRB,4.4301E-01_JPRB,3.1790E+00_JPRB,5.1608E+00_JPRB,6.9184E+00_JPRB,8.1647E+00_JPRB/)
KBO( :, 5,42,10) = (/&
&5.0928E-01_JPRB,5.0935E-01_JPRB,3.2490E+00_JPRB,5.2607E+00_JPRB,6.9918E+00_JPRB,8.3533E+00_JPRB/)
KBO( :, 1,43,10) = (/&
&2.6768E-01_JPRB,2.6781E-01_JPRB,2.7595E+00_JPRB,4.5068E+00_JPRB,6.1924E+00_JPRB,6.9816E+00_JPRB/)
KBO( :, 2,43,10) = (/&
&3.0121E-01_JPRB,3.0134E-01_JPRB,2.9195E+00_JPRB,4.7538E+00_JPRB,6.4985E+00_JPRB,7.4658E+00_JPRB/)
KBO( :, 3,43,10) = (/&
&3.4636E-01_JPRB,3.4652E-01_JPRB,3.0475E+00_JPRB,4.9586E+00_JPRB,6.7250E+00_JPRB,7.8363E+00_JPRB/)
KBO( :, 4,43,10) = (/&
&4.0279E-01_JPRB,4.0294E-01_JPRB,3.1487E+00_JPRB,5.1186E+00_JPRB,6.8816E+00_JPRB,8.1193E+00_JPRB/)
KBO( :, 5,43,10) = (/&
&4.6775E-01_JPRB,4.6784E-01_JPRB,3.2281E+00_JPRB,5.2365E+00_JPRB,6.9765E+00_JPRB,8.3335E+00_JPRB/)
KBO( :, 1,44,10) = (/&
&2.3663E-01_JPRB,2.3679E-01_JPRB,2.6889E+00_JPRB,4.3996E+00_JPRB,6.0559E+00_JPRB,6.8135E+00_JPRB/)
KBO( :, 2,44,10) = (/&
&2.6748E-01_JPRB,2.6764E-01_JPRB,2.8618E+00_JPRB,4.6667E+00_JPRB,6.3943E+00_JPRB,7.3355E+00_JPRB/)
KBO( :, 3,44,10) = (/&
&3.1007E-01_JPRB,3.1028E-01_JPRB,3.0033E+00_JPRB,4.8904E+00_JPRB,6.6510E+00_JPRB,7.7469E+00_JPRB/)
KBO( :, 4,44,10) = (/&
&3.6426E-01_JPRB,3.6444E-01_JPRB,3.1143E+00_JPRB,5.0666E+00_JPRB,6.8341E+00_JPRB,8.0609E+00_JPRB/)
KBO( :, 5,44,10) = (/&
&4.2790E-01_JPRB,4.2800E-01_JPRB,3.2017E+00_JPRB,5.2027E+00_JPRB,6.9510E+00_JPRB,8.3005E+00_JPRB/)
KBO( :, 1,45,10) = (/&
&2.0943E-01_JPRB,2.0961E-01_JPRB,2.6149E+00_JPRB,4.2870E+00_JPRB,5.9088E+00_JPRB,6.6376E+00_JPRB/)
KBO( :, 2,45,10) = (/&
&2.3748E-01_JPRB,2.3768E-01_JPRB,2.7996E+00_JPRB,4.5739E+00_JPRB,6.2800E+00_JPRB,7.1981E+00_JPRB/)
KBO( :, 3,45,10) = (/&
&2.7717E-01_JPRB,2.7741E-01_JPRB,2.9545E+00_JPRB,4.8149E+00_JPRB,6.5679E+00_JPRB,7.6498E+00_JPRB/)
KBO( :, 4,45,10) = (/&
&3.2881E-01_JPRB,3.2900E-01_JPRB,3.0769E+00_JPRB,5.0100E+00_JPRB,6.7767E+00_JPRB,7.9956E+00_JPRB/)
KBO( :, 5,45,10) = (/&
&3.9089E-01_JPRB,3.9099E-01_JPRB,3.1729E+00_JPRB,5.1617E+00_JPRB,6.9184E+00_JPRB,8.2647E+00_JPRB/)
KBO( :, 1,46,10) = (/&
&1.8488E-01_JPRB,1.8509E-01_JPRB,2.5337E+00_JPRB,4.1619E+00_JPRB,5.7408E+00_JPRB,6.4343E+00_JPRB/)
KBO( :, 2,46,10) = (/&
&2.1029E-01_JPRB,2.1052E-01_JPRB,2.7308E+00_JPRB,4.4685E+00_JPRB,6.1476E+00_JPRB,7.0351E+00_JPRB/)
KBO( :, 3,46,10) = (/&
&2.4641E-01_JPRB,2.4669E-01_JPRB,2.8991E+00_JPRB,4.7282E+00_JPRB,6.4680E+00_JPRB,7.5299E+00_JPRB/)
KBO( :, 4,46,10) = (/&
&2.9502E-01_JPRB,2.9523E-01_JPRB,3.0336E+00_JPRB,4.9428E+00_JPRB,6.7064E+00_JPRB,7.9122E+00_JPRB/)
KBO( :, 5,46,10) = (/&
&3.5492E-01_JPRB,3.5504E-01_JPRB,3.1395E+00_JPRB,5.1108E+00_JPRB,6.8742E+00_JPRB,8.2122E+00_JPRB/)
KBO( :, 1,47,10) = (/&
&1.6240E-01_JPRB,1.6263E-01_JPRB,2.4388E+00_JPRB,4.0166E+00_JPRB,5.5397E+00_JPRB,6.1804E+00_JPRB/)
KBO( :, 2,47,10) = (/&
&1.8504E-01_JPRB,1.8532E-01_JPRB,2.6496E+00_JPRB,4.3442E+00_JPRB,5.9864E+00_JPRB,6.8265E+00_JPRB/)
KBO( :, 3,47,10) = (/&
&2.1735E-01_JPRB,2.1764E-01_JPRB,2.8316E+00_JPRB,4.6250E+00_JPRB,6.3441E+00_JPRB,7.3704E+00_JPRB/)
KBO( :, 4,47,10) = (/&
&2.6219E-01_JPRB,2.6243E-01_JPRB,2.9807E+00_JPRB,4.8597E+00_JPRB,6.6165E+00_JPRB,7.7948E+00_JPRB/)
KBO( :, 5,47,10) = (/&
&3.1904E-01_JPRB,3.1916E-01_JPRB,3.0987E+00_JPRB,5.0473E+00_JPRB,6.8132E+00_JPRB,8.1318E+00_JPRB/)
KBO( :, 1,48,10) = (/&
&1.4274E-01_JPRB,1.4309E-01_JPRB,2.3378E+00_JPRB,3.8621E+00_JPRB,5.3223E+00_JPRB,5.9129E+00_JPRB/)
KBO( :, 2,48,10) = (/&
&1.6289E-01_JPRB,1.6319E-01_JPRB,2.5631E+00_JPRB,4.2108E+00_JPRB,5.8103E+00_JPRB,6.6062E+00_JPRB/)
KBO( :, 3,48,10) = (/&
&1.9167E-01_JPRB,1.9198E-01_JPRB,2.7584E+00_JPRB,4.5133E+00_JPRB,6.2051E+00_JPRB,7.1967E+00_JPRB/)
KBO( :, 4,48,10) = (/&
&2.3239E-01_JPRB,2.3264E-01_JPRB,2.9226E+00_JPRB,4.7680E+00_JPRB,6.5135E+00_JPRB,7.6665E+00_JPRB/)
KBO( :, 5,48,10) = (/&
&2.8577E-01_JPRB,2.8592E-01_JPRB,3.0525E+00_JPRB,4.9759E+00_JPRB,6.7401E+00_JPRB,8.0423E+00_JPRB/)
KBO( :, 1,49,10) = (/&
&1.2506E-01_JPRB,1.2569E-01_JPRB,2.2315E+00_JPRB,3.6984E+00_JPRB,5.0916E+00_JPRB,5.6363E+00_JPRB/)
KBO( :, 2,49,10) = (/&
&1.4348E-01_JPRB,1.4383E-01_JPRB,2.4717E+00_JPRB,4.0691E+00_JPRB,5.6178E+00_JPRB,6.3745E+00_JPRB/)
KBO( :, 3,49,10) = (/&
&1.6900E-01_JPRB,1.6934E-01_JPRB,2.6802E+00_JPRB,4.3928E+00_JPRB,6.0515E+00_JPRB,7.0127E+00_JPRB/)
KBO( :, 4,49,10) = (/&
&2.0581E-01_JPRB,2.0606E-01_JPRB,2.8586E+00_JPRB,4.6682E+00_JPRB,6.3962E+00_JPRB,7.5292E+00_JPRB/)
KBO( :, 5,49,10) = (/&
&2.5518E-01_JPRB,2.5533E-01_JPRB,3.0025E+00_JPRB,4.8968E+00_JPRB,6.6558E+00_JPRB,7.9457E+00_JPRB/)
KBO( :, 1,50,10) = (/&
&1.0959E-01_JPRB,1.1070E-01_JPRB,2.1267E+00_JPRB,3.5368E+00_JPRB,4.8615E+00_JPRB,5.3538E+00_JPRB/)
KBO( :, 2,50,10) = (/&
&1.2689E-01_JPRB,1.2744E-01_JPRB,2.3809E+00_JPRB,3.9302E+00_JPRB,5.4235E+00_JPRB,6.1306E+00_JPRB/)
KBO( :, 3,50,10) = (/&
&1.4973E-01_JPRB,1.5009E-01_JPRB,2.6019E+00_JPRB,4.2725E+00_JPRB,5.8946E+00_JPRB,6.8112E+00_JPRB/)
KBO( :, 4,50,10) = (/&
&1.8304E-01_JPRB,1.8331E-01_JPRB,2.7927E+00_JPRB,4.5675E+00_JPRB,6.2731E+00_JPRB,7.3745E+00_JPRB/)
KBO( :, 5,50,10) = (/&
&2.2866E-01_JPRB,2.2882E-01_JPRB,2.9508E+00_JPRB,4.8146E+00_JPRB,6.5657E+00_JPRB,7.8282E+00_JPRB/)
KBO( :, 1,51,10) = (/&
&9.5768E-02_JPRB,9.7661E-02_JPRB,2.0216E+00_JPRB,3.3751E+00_JPRB,4.6268E+00_JPRB,5.0597E+00_JPRB/)
KBO( :, 2,51,10) = (/&
&1.1216E-01_JPRB,1.1307E-01_JPRB,2.2881E+00_JPRB,3.7875E+00_JPRB,5.2217E+00_JPRB,5.8744E+00_JPRB/)
KBO( :, 3,51,10) = (/&
&1.3299E-01_JPRB,1.3343E-01_JPRB,2.5219E+00_JPRB,4.1480E+00_JPRB,5.7284E+00_JPRB,6.5943E+00_JPRB/)
KBO( :, 4,51,10) = (/&
&1.6308E-01_JPRB,1.6337E-01_JPRB,2.7248E+00_JPRB,4.4626E+00_JPRB,6.1415E+00_JPRB,7.2033E+00_JPRB/)
KBO( :, 5,51,10) = (/&
&2.0524E-01_JPRB,2.0541E-01_JPRB,2.8961E+00_JPRB,4.7281E+00_JPRB,6.4666E+00_JPRB,7.6945E+00_JPRB/)
KBO( :, 1,52,10) = (/&
&8.3171E-02_JPRB,8.6221E-02_JPRB,1.9144E+00_JPRB,3.2076E+00_JPRB,4.3819E+00_JPRB,4.7580E+00_JPRB/)
KBO( :, 2,52,10) = (/&
&9.8912E-02_JPRB,1.0039E-01_JPRB,2.1906E+00_JPRB,3.6370E+00_JPRB,5.0088E+00_JPRB,5.6089E+00_JPRB/)
KBO( :, 3,52,10) = (/&
&1.1809E-01_JPRB,1.1874E-01_JPRB,2.4381E+00_JPRB,4.0185E+00_JPRB,5.5505E+00_JPRB,6.3684E+00_JPRB/)
KBO( :, 4,52,10) = (/&
&1.4539E-01_JPRB,1.4572E-01_JPRB,2.6526E+00_JPRB,4.3511E+00_JPRB,5.9980E+00_JPRB,7.0214E+00_JPRB/)
KBO( :, 5,52,10) = (/&
&1.8406E-01_JPRB,1.8425E-01_JPRB,2.8362E+00_JPRB,4.6354E+00_JPRB,6.3565E+00_JPRB,7.5532E+00_JPRB/)
KBO( :, 1,53,10) = (/&
&7.1760E-02_JPRB,7.6225E-02_JPRB,1.8049E+00_JPRB,3.0338E+00_JPRB,4.1285E+00_JPRB,4.4543E+00_JPRB/)
KBO( :, 2,53,10) = (/&
&8.6733E-02_JPRB,8.9133E-02_JPRB,2.0890E+00_JPRB,3.4808E+00_JPRB,4.7838E+00_JPRB,5.3384E+00_JPRB/)
KBO( :, 3,53,10) = (/&
&1.0470E-01_JPRB,1.0571E-01_JPRB,2.3496E+00_JPRB,3.8826E+00_JPRB,5.3593E+00_JPRB,6.1340E+00_JPRB/)
KBO( :, 4,53,10) = (/&
&1.2964E-01_JPRB,1.3004E-01_JPRB,2.5758E+00_JPRB,4.2328E+00_JPRB,5.8432E+00_JPRB,6.8310E+00_JPRB/)
KBO( :, 5,53,10) = (/&
&1.6486E-01_JPRB,1.6505E-01_JPRB,2.7718E+00_JPRB,4.5358E+00_JPRB,6.2341E+00_JPRB,7.4042E+00_JPRB/)
KBO( :, 1,54,10) = (/&
&6.1882E-02_JPRB,6.7940E-02_JPRB,1.7027E+00_JPRB,2.8705E+00_JPRB,3.8894E+00_JPRB,4.1460E+00_JPRB/)
KBO( :, 2,54,10) = (/&
&7.6155E-02_JPRB,7.9684E-02_JPRB,1.9930E+00_JPRB,3.3325E+00_JPRB,4.5678E+00_JPRB,5.0509E+00_JPRB/)
KBO( :, 3,54,10) = (/&
&9.3240E-02_JPRB,9.4826E-02_JPRB,2.2641E+00_JPRB,3.7513E+00_JPRB,5.1730E+00_JPRB,5.8771E+00_JPRB/)
KBO( :, 4,54,10) = (/&
&1.1632E-01_JPRB,1.1690E-01_JPRB,2.5020E+00_JPRB,4.1182E+00_JPRB,5.6892E+00_JPRB,6.6127E+00_JPRB/)
KBO( :, 5,54,10) = (/&
&1.4865E-01_JPRB,1.4887E-01_JPRB,2.7085E+00_JPRB,4.4384E+00_JPRB,6.1110E+00_JPRB,7.2268E+00_JPRB/)
KBO( :, 1,55,10) = (/&
&5.3143E-02_JPRB,6.0929E-02_JPRB,1.6034E+00_JPRB,2.7108E+00_JPRB,3.6519E+00_JPRB,3.8346E+00_JPRB/)
KBO( :, 2,55,10) = (/&
&6.6664E-02_JPRB,7.1549E-02_JPRB,1.8993E+00_JPRB,3.1854E+00_JPRB,4.3528E+00_JPRB,4.7449E+00_JPRB/)
KBO( :, 3,55,10) = (/&
&8.2988E-02_JPRB,8.5434E-02_JPRB,2.1781E+00_JPRB,3.6188E+00_JPRB,4.9850E+00_JPRB,5.6016E+00_JPRB/)
KBO( :, 4,55,10) = (/&
&1.0455E-01_JPRB,1.0541E-01_JPRB,2.4283E+00_JPRB,4.0035E+00_JPRB,5.5314E+00_JPRB,6.3670E+00_JPRB/)
KBO( :, 5,55,10) = (/&
&1.3450E-01_JPRB,1.3475E-01_JPRB,2.6447E+00_JPRB,4.3400E+00_JPRB,5.9837E+00_JPRB,7.0246E+00_JPRB/)
KBO( :, 1,56,10) = (/&
&4.5363E-02_JPRB,5.4761E-02_JPRB,1.5057E+00_JPRB,2.5465E+00_JPRB,3.4107E+00_JPRB,3.5270E+00_JPRB/)
KBO( :, 2,56,10) = (/&
&5.8005E-02_JPRB,6.4431E-02_JPRB,1.8040E+00_JPRB,3.0340E+00_JPRB,4.1322E+00_JPRB,4.4343E+00_JPRB/)
KBO( :, 3,56,10) = (/&
&7.3593E-02_JPRB,7.7144E-02_JPRB,2.0898E+00_JPRB,3.4823E+00_JPRB,4.7884E+00_JPRB,5.3173E+00_JPRB/)
KBO( :, 4,56,10) = (/&
&9.3887E-02_JPRB,9.5237E-02_JPRB,2.3510E+00_JPRB,3.8850E+00_JPRB,5.3647E+00_JPRB,6.1108E+00_JPRB/)
KBO( :, 5,56,10) = (/&
&1.2181E-01_JPRB,1.2219E-01_JPRB,2.5776E+00_JPRB,4.2361E+00_JPRB,5.8482E+00_JPRB,6.8081E+00_JPRB/)
KBO( :, 1,57,10) = (/&
&3.8484E-02_JPRB,4.9332E-02_JPRB,1.4087E+00_JPRB,2.3775E+00_JPRB,3.1673E+00_JPRB,3.2197E+00_JPRB/)
KBO( :, 2,57,10) = (/&
&5.0147E-02_JPRB,5.8221E-02_JPRB,1.7073E+00_JPRB,2.8793E+00_JPRB,3.9049E+00_JPRB,4.1273E+00_JPRB/)
KBO( :, 3,57,10) = (/&
&6.4931E-02_JPRB,6.9815E-02_JPRB,1.9987E+00_JPRB,3.3420E+00_JPRB,4.5839E+00_JPRB,5.0218E+00_JPRB/)
KBO( :, 4,57,10) = (/&
&8.4109E-02_JPRB,8.6186E-02_JPRB,2.2698E+00_JPRB,3.7606E+00_JPRB,5.1878E+00_JPRB,5.8449E+00_JPRB/)
KBO( :, 5,57,10) = (/&
&1.1023E-01_JPRB,1.1081E-01_JPRB,2.5075E+00_JPRB,4.1274E+00_JPRB,5.7022E+00_JPRB,6.5747E+00_JPRB/)
KBO( :, 1,58,10) = (/&
&3.2626E-02_JPRB,4.4633E-02_JPRB,1.3174E+00_JPRB,2.2156E+00_JPRB,2.9363E+00_JPRB,2.9278E+00_JPRB/)
KBO( :, 2,58,10) = (/&
&4.3298E-02_JPRB,5.2922E-02_JPRB,1.6144E+00_JPRB,2.7304E+00_JPRB,3.6831E+00_JPRB,3.8325E+00_JPRB/)
KBO( :, 3,58,10) = (/&
&5.7247E-02_JPRB,6.3597E-02_JPRB,1.9107E+00_JPRB,3.2043E+00_JPRB,4.3821E+00_JPRB,4.7236E+00_JPRB/)
KBO( :, 4,58,10) = (/&
&7.5473E-02_JPRB,7.8525E-02_JPRB,2.1894E+00_JPRB,3.6369E+00_JPRB,5.0121E+00_JPRB,5.5748E+00_JPRB/)
KBO( :, 5,58,10) = (/&
&1.0003E-01_JPRB,1.0093E-01_JPRB,2.4389E+00_JPRB,4.0197E+00_JPRB,5.5549E+00_JPRB,6.3325E+00_JPRB/)
KBO( :, 1,59,10) = (/&
&2.9072E-02_JPRB,4.1705E-02_JPRB,1.2802E+00_JPRB,2.1494E+00_JPRB,2.8421E+00_JPRB,2.7798E+00_JPRB/)
KBO( :, 2,59,10) = (/&
&3.9252E-02_JPRB,4.9835E-02_JPRB,1.5765E+00_JPRB,2.6680E+00_JPRB,3.5911E+00_JPRB,3.6659E+00_JPRB/)
KBO( :, 3,59,10) = (/&
&5.3000E-02_JPRB,6.0270E-02_JPRB,1.8744E+00_JPRB,3.1473E+00_JPRB,4.2993E+00_JPRB,4.5411E+00_JPRB/)
KBO( :, 4,59,10) = (/&
&7.1218E-02_JPRB,7.4859E-02_JPRB,2.1561E+00_JPRB,3.5852E+00_JPRB,4.9384E+00_JPRB,5.3790E+00_JPRB/)
KBO( :, 5,59,10) = (/&
&9.5581E-02_JPRB,9.6679E-02_JPRB,2.4098E+00_JPRB,3.9752E+00_JPRB,5.4931E+00_JPRB,6.1513E+00_JPRB/)
KBO( :, 1,13,11) = (/&
&1.0830E+01_JPRB,1.0824E+01_JPRB,8.2966E+00_JPRB,5.7775E+00_JPRB,4.2067E+00_JPRB,3.8416E+00_JPRB/)
KBO( :, 2,13,11) = (/&
&1.0842E+01_JPRB,1.0836E+01_JPRB,8.3048E+00_JPRB,5.7756E+00_JPRB,4.1117E+00_JPRB,3.7626E+00_JPRB/)
KBO( :, 3,13,11) = (/&
&1.0806E+01_JPRB,1.0800E+01_JPRB,8.2770E+00_JPRB,5.7524E+00_JPRB,4.0103E+00_JPRB,3.7005E+00_JPRB/)
KBO( :, 4,13,11) = (/&
&1.0724E+01_JPRB,1.0718E+01_JPRB,8.2112E+00_JPRB,5.7002E+00_JPRB,3.9058E+00_JPRB,3.6875E+00_JPRB/)
KBO( :, 5,13,11) = (/&
&1.0621E+01_JPRB,1.0615E+01_JPRB,8.1337E+00_JPRB,5.6465E+00_JPRB,3.8013E+00_JPRB,3.7028E+00_JPRB/)
KBO( :, 1,14,11) = (/&
&1.1181E+01_JPRB,1.1175E+01_JPRB,8.5568E+00_JPRB,5.9649E+00_JPRB,4.4522E+00_JPRB,4.2077E+00_JPRB/)
KBO( :, 2,14,11) = (/&
&1.1133E+01_JPRB,1.1127E+01_JPRB,8.5167E+00_JPRB,5.9323E+00_JPRB,4.3476E+00_JPRB,4.1247E+00_JPRB/)
KBO( :, 3,14,11) = (/&
&1.1053E+01_JPRB,1.1047E+01_JPRB,8.4570E+00_JPRB,5.8889E+00_JPRB,4.2415E+00_JPRB,4.0417E+00_JPRB/)
KBO( :, 4,14,11) = (/&
&1.0933E+01_JPRB,1.0927E+01_JPRB,8.3682E+00_JPRB,5.8252E+00_JPRB,4.1413E+00_JPRB,3.9695E+00_JPRB/)
KBO( :, 5,14,11) = (/&
&1.0780E+01_JPRB,1.0774E+01_JPRB,8.2481E+00_JPRB,5.7382E+00_JPRB,4.0362E+00_JPRB,3.9481E+00_JPRB/)
KBO( :, 1,15,11) = (/&
&1.1265E+01_JPRB,1.1259E+01_JPRB,8.6144E+00_JPRB,6.0504E+00_JPRB,4.7323E+00_JPRB,4.5971E+00_JPRB/)
KBO( :, 2,15,11) = (/&
&1.1162E+01_JPRB,1.1156E+01_JPRB,8.5378E+00_JPRB,5.9895E+00_JPRB,4.6323E+00_JPRB,4.4988E+00_JPRB/)
KBO( :, 3,15,11) = (/&
&1.1022E+01_JPRB,1.1015E+01_JPRB,8.4337E+00_JPRB,5.9199E+00_JPRB,4.5312E+00_JPRB,4.4142E+00_JPRB/)
KBO( :, 4,15,11) = (/&
&1.0880E+01_JPRB,1.0874E+01_JPRB,8.3234E+00_JPRB,5.8348E+00_JPRB,4.4237E+00_JPRB,4.3326E+00_JPRB/)
KBO( :, 5,15,11) = (/&
&1.0698E+01_JPRB,1.0692E+01_JPRB,8.1811E+00_JPRB,5.7294E+00_JPRB,4.3189E+00_JPRB,4.2569E+00_JPRB/)
KBO( :, 1,16,11) = (/&
&1.1047E+01_JPRB,1.1041E+01_JPRB,8.4566E+00_JPRB,6.0733E+00_JPRB,5.0987E+00_JPRB,4.9814E+00_JPRB/)
KBO( :, 2,16,11) = (/&
&1.0912E+01_JPRB,1.0905E+01_JPRB,8.3558E+00_JPRB,5.9956E+00_JPRB,4.9979E+00_JPRB,4.8884E+00_JPRB/)
KBO( :, 3,16,11) = (/&
&1.0758E+01_JPRB,1.0752E+01_JPRB,8.2381E+00_JPRB,5.8935E+00_JPRB,4.8881E+00_JPRB,4.7986E+00_JPRB/)
KBO( :, 4,16,11) = (/&
&1.0569E+01_JPRB,1.0563E+01_JPRB,8.0898E+00_JPRB,5.7760E+00_JPRB,4.7808E+00_JPRB,4.7200E+00_JPRB/)
KBO( :, 5,16,11) = (/&
&1.0363E+01_JPRB,1.0357E+01_JPRB,7.9324E+00_JPRB,5.6614E+00_JPRB,4.6746E+00_JPRB,4.6272E+00_JPRB/)
KBO( :, 1,17,11) = (/&
&1.0577E+01_JPRB,1.0572E+01_JPRB,8.1098E+00_JPRB,6.0991E+00_JPRB,5.5106E+00_JPRB,5.4165E+00_JPRB/)
KBO( :, 2,17,11) = (/&
&1.0411E+01_JPRB,1.0405E+01_JPRB,7.9835E+00_JPRB,5.9805E+00_JPRB,5.3996E+00_JPRB,5.3206E+00_JPRB/)
KBO( :, 3,17,11) = (/&
&1.0224E+01_JPRB,1.0219E+01_JPRB,7.8406E+00_JPRB,5.8520E+00_JPRB,5.2910E+00_JPRB,5.2289E+00_JPRB/)
KBO( :, 4,17,11) = (/&
&1.0028E+01_JPRB,1.0022E+01_JPRB,7.6890E+00_JPRB,5.7215E+00_JPRB,5.1803E+00_JPRB,5.1373E+00_JPRB/)
KBO( :, 5,17,11) = (/&
&9.8160E+00_JPRB,9.8105E+00_JPRB,7.5244E+00_JPRB,5.5839E+00_JPRB,5.0653E+00_JPRB,5.0432E+00_JPRB/)
KBO( :, 1,18,11) = (/&
&9.8986E+00_JPRB,9.8931E+00_JPRB,7.6044E+00_JPRB,6.1164E+00_JPRB,5.9534E+00_JPRB,5.9474E+00_JPRB/)
KBO( :, 2,18,11) = (/&
&9.7140E+00_JPRB,9.7086E+00_JPRB,7.4654E+00_JPRB,5.9795E+00_JPRB,5.8383E+00_JPRB,5.8411E+00_JPRB/)
KBO( :, 3,18,11) = (/&
&9.5273E+00_JPRB,9.5220E+00_JPRB,7.3210E+00_JPRB,5.8383E+00_JPRB,5.7189E+00_JPRB,5.7395E+00_JPRB/)
KBO( :, 4,18,11) = (/&
&9.3182E+00_JPRB,9.3130E+00_JPRB,7.1594E+00_JPRB,5.7006E+00_JPRB,5.6002E+00_JPRB,5.6385E+00_JPRB/)
KBO( :, 5,18,11) = (/&
&9.0984E+00_JPRB,9.0934E+00_JPRB,6.9901E+00_JPRB,5.5596E+00_JPRB,5.4784E+00_JPRB,5.5361E+00_JPRB/)
KBO( :, 1,19,11) = (/&
&9.0617E+00_JPRB,9.0567E+00_JPRB,6.9882E+00_JPRB,6.1944E+00_JPRB,6.4032E+00_JPRB,6.5506E+00_JPRB/)
KBO( :, 2,19,11) = (/&
&8.8807E+00_JPRB,8.8758E+00_JPRB,6.8508E+00_JPRB,6.0541E+00_JPRB,6.2790E+00_JPRB,6.4421E+00_JPRB/)
KBO( :, 3,19,11) = (/&
&8.6840E+00_JPRB,8.6793E+00_JPRB,6.6993E+00_JPRB,5.9155E+00_JPRB,6.1530E+00_JPRB,6.3302E+00_JPRB/)
KBO( :, 4,19,11) = (/&
&8.4690E+00_JPRB,8.4643E+00_JPRB,6.5346E+00_JPRB,5.7782E+00_JPRB,6.0205E+00_JPRB,6.1969E+00_JPRB/)
KBO( :, 5,19,11) = (/&
&8.2461E+00_JPRB,8.2415E+00_JPRB,6.3683E+00_JPRB,5.6418E+00_JPRB,5.8884E+00_JPRB,6.0738E+00_JPRB/)
KBO( :, 1,20,11) = (/&
&8.1338E+00_JPRB,8.1294E+00_JPRB,6.3787E+00_JPRB,6.3724E+00_JPRB,6.8676E+00_JPRB,7.1512E+00_JPRB/)
KBO( :, 2,20,11) = (/&
&7.9489E+00_JPRB,7.9446E+00_JPRB,6.2323E+00_JPRB,6.2367E+00_JPRB,6.7380E+00_JPRB,7.0235E+00_JPRB/)
KBO( :, 3,20,11) = (/&
&7.7484E+00_JPRB,7.7442E+00_JPRB,6.0747E+00_JPRB,6.0984E+00_JPRB,6.6037E+00_JPRB,6.8886E+00_JPRB/)
KBO( :, 4,20,11) = (/&
&7.5336E+00_JPRB,7.5295E+00_JPRB,5.9158E+00_JPRB,5.9585E+00_JPRB,6.4615E+00_JPRB,6.7483E+00_JPRB/)
KBO( :, 5,20,11) = (/&
&7.3192E+00_JPRB,7.3153E+00_JPRB,5.7540E+00_JPRB,5.8154E+00_JPRB,6.3114E+00_JPRB,6.6285E+00_JPRB/)
KBO( :, 1,21,11) = (/&
&7.1783E+00_JPRB,7.1745E+00_JPRB,5.8792E+00_JPRB,6.5789E+00_JPRB,7.3613E+00_JPRB,7.7022E+00_JPRB/)
KBO( :, 2,21,11) = (/&
&6.9919E+00_JPRB,6.9882E+00_JPRB,5.7299E+00_JPRB,6.4389E+00_JPRB,7.2225E+00_JPRB,7.5647E+00_JPRB/)
KBO( :, 3,21,11) = (/&
&6.7909E+00_JPRB,6.7873E+00_JPRB,5.5766E+00_JPRB,6.2973E+00_JPRB,7.0712E+00_JPRB,7.4405E+00_JPRB/)
KBO( :, 4,21,11) = (/&
&6.5939E+00_JPRB,6.5903E+00_JPRB,5.4217E+00_JPRB,6.1490E+00_JPRB,6.9129E+00_JPRB,7.3122E+00_JPRB/)
KBO( :, 5,21,11) = (/&
&6.4093E+00_JPRB,6.4059E+00_JPRB,5.2663E+00_JPRB,5.9963E+00_JPRB,6.7516E+00_JPRB,7.1970E+00_JPRB/)
KBO( :, 1,22,11) = (/&
&6.2177E+00_JPRB,6.2144E+00_JPRB,5.5479E+00_JPRB,6.7900E+00_JPRB,7.8374E+00_JPRB,8.2375E+00_JPRB/)
KBO( :, 2,22,11) = (/&
&6.0356E+00_JPRB,6.0324E+00_JPRB,5.3995E+00_JPRB,6.6451E+00_JPRB,7.6895E+00_JPRB,8.1166E+00_JPRB/)
KBO( :, 3,22,11) = (/&
&5.8596E+00_JPRB,5.8565E+00_JPRB,5.2499E+00_JPRB,6.4943E+00_JPRB,7.5342E+00_JPRB,8.0016E+00_JPRB/)
KBO( :, 4,22,11) = (/&
&5.7069E+00_JPRB,5.7039E+00_JPRB,5.1029E+00_JPRB,6.3342E+00_JPRB,7.3721E+00_JPRB,7.8779E+00_JPRB/)
KBO( :, 5,22,11) = (/&
&5.5907E+00_JPRB,5.5878E+00_JPRB,4.9677E+00_JPRB,6.1731E+00_JPRB,7.2068E+00_JPRB,7.7598E+00_JPRB/)
KBO( :, 1,23,11) = (/&
&5.3001E+00_JPRB,5.2974E+00_JPRB,5.3392E+00_JPRB,7.0212E+00_JPRB,8.2731E+00_JPRB,8.7769E+00_JPRB/)
KBO( :, 2,23,11) = (/&
&5.1465E+00_JPRB,5.1439E+00_JPRB,5.1959E+00_JPRB,6.8658E+00_JPRB,8.1318E+00_JPRB,8.6756E+00_JPRB/)
KBO( :, 3,23,11) = (/&
&5.0259E+00_JPRB,5.0234E+00_JPRB,5.0568E+00_JPRB,6.6964E+00_JPRB,7.9822E+00_JPRB,8.5635E+00_JPRB/)
KBO( :, 4,23,11) = (/&
&4.9408E+00_JPRB,4.9383E+00_JPRB,4.9256E+00_JPRB,6.5229E+00_JPRB,7.8283E+00_JPRB,8.4337E+00_JPRB/)
KBO( :, 5,23,11) = (/&
&4.8982E+00_JPRB,4.8957E+00_JPRB,4.8170E+00_JPRB,6.3467E+00_JPRB,7.6656E+00_JPRB,8.3117E+00_JPRB/)
KBO( :, 1,24,11) = (/&
&4.4810E+00_JPRB,4.4788E+00_JPRB,5.2117E+00_JPRB,7.2187E+00_JPRB,8.6894E+00_JPRB,9.2830E+00_JPRB/)
KBO( :, 2,24,11) = (/&
&4.3875E+00_JPRB,4.3854E+00_JPRB,5.0729E+00_JPRB,7.0552E+00_JPRB,8.5552E+00_JPRB,9.1952E+00_JPRB/)
KBO( :, 3,24,11) = (/&
&4.3298E+00_JPRB,4.3277E+00_JPRB,4.9395E+00_JPRB,6.8841E+00_JPRB,8.4129E+00_JPRB,9.0854E+00_JPRB/)
KBO( :, 4,24,11) = (/&
&4.3240E+00_JPRB,4.3219E+00_JPRB,4.8305E+00_JPRB,6.7106E+00_JPRB,8.2583E+00_JPRB,8.9534E+00_JPRB/)
KBO( :, 5,24,11) = (/&
&4.3568E+00_JPRB,4.3547E+00_JPRB,4.7450E+00_JPRB,6.5341E+00_JPRB,8.0917E+00_JPRB,8.8298E+00_JPRB/)
KBO( :, 1,25,11) = (/&
&3.8157E+00_JPRB,3.8139E+00_JPRB,5.1260E+00_JPRB,7.3753E+00_JPRB,9.0809E+00_JPRB,9.7303E+00_JPRB/)
KBO( :, 2,25,11) = (/&
&3.7828E+00_JPRB,3.7809E+00_JPRB,4.9881E+00_JPRB,7.2252E+00_JPRB,8.9546E+00_JPRB,9.6529E+00_JPRB/)
KBO( :, 3,25,11) = (/&
&3.7966E+00_JPRB,3.7948E+00_JPRB,4.8698E+00_JPRB,7.0694E+00_JPRB,8.8114E+00_JPRB,9.5492E+00_JPRB/)
KBO( :, 4,25,11) = (/&
&3.8447E+00_JPRB,3.8429E+00_JPRB,4.7808E+00_JPRB,6.9055E+00_JPRB,8.6548E+00_JPRB,9.4220E+00_JPRB/)
KBO( :, 5,25,11) = (/&
&3.9327E+00_JPRB,3.9309E+00_JPRB,4.7021E+00_JPRB,6.7298E+00_JPRB,8.4889E+00_JPRB,9.2936E+00_JPRB/)
KBO( :, 1,26,11) = (/&
&3.3036E+00_JPRB,3.3021E+00_JPRB,5.0575E+00_JPRB,7.5192E+00_JPRB,9.4189E+00_JPRB,1.0102E+01_JPRB/)
KBO( :, 2,26,11) = (/&
&3.3285E+00_JPRB,3.3270E+00_JPRB,4.9281E+00_JPRB,7.3849E+00_JPRB,9.3027E+00_JPRB,1.0041E+01_JPRB/)
KBO( :, 3,26,11) = (/&
&3.3889E+00_JPRB,3.3874E+00_JPRB,4.8326E+00_JPRB,7.2371E+00_JPRB,9.1673E+00_JPRB,9.9526E+00_JPRB/)
KBO( :, 4,26,11) = (/&
&3.4837E+00_JPRB,3.4822E+00_JPRB,4.7525E+00_JPRB,7.0754E+00_JPRB,9.0130E+00_JPRB,9.8334E+00_JPRB/)
KBO( :, 5,26,11) = (/&
&3.5869E+00_JPRB,3.5853E+00_JPRB,4.6879E+00_JPRB,6.9081E+00_JPRB,8.8429E+00_JPRB,9.7104E+00_JPRB/)
KBO( :, 1,27,11) = (/&
&2.9165E+00_JPRB,2.9152E+00_JPRB,4.9857E+00_JPRB,7.6560E+00_JPRB,9.7110E+00_JPRB,1.0421E+01_JPRB/)
KBO( :, 2,27,11) = (/&
&2.9834E+00_JPRB,2.9822E+00_JPRB,4.8877E+00_JPRB,7.5297E+00_JPRB,9.6106E+00_JPRB,1.0382E+01_JPRB/)
KBO( :, 3,27,11) = (/&
&3.0758E+00_JPRB,3.0745E+00_JPRB,4.8130E+00_JPRB,7.3870E+00_JPRB,9.4838E+00_JPRB,1.0306E+01_JPRB/)
KBO( :, 4,27,11) = (/&
&3.1796E+00_JPRB,3.1781E+00_JPRB,4.7485E+00_JPRB,7.2327E+00_JPRB,9.3303E+00_JPRB,1.0198E+01_JPRB/)
KBO( :, 5,27,11) = (/&
&3.2957E+00_JPRB,3.2941E+00_JPRB,4.7038E+00_JPRB,7.0683E+00_JPRB,9.1564E+00_JPRB,1.0089E+01_JPRB/)
KBO( :, 1,28,11) = (/&
&2.6155E+00_JPRB,2.6145E+00_JPRB,4.9275E+00_JPRB,7.7638E+00_JPRB,9.9551E+00_JPRB,1.0696E+01_JPRB/)
KBO( :, 2,28,11) = (/&
&2.7046E+00_JPRB,2.7035E+00_JPRB,4.8641E+00_JPRB,7.6476E+00_JPRB,9.8682E+00_JPRB,1.0682E+01_JPRB/)
KBO( :, 3,28,11) = (/&
&2.8078E+00_JPRB,2.8066E+00_JPRB,4.8086E+00_JPRB,7.5132E+00_JPRB,9.7479E+00_JPRB,1.0615E+01_JPRB/)
KBO( :, 4,28,11) = (/&
&2.9220E+00_JPRB,2.9207E+00_JPRB,4.7661E+00_JPRB,7.3606E+00_JPRB,9.5999E+00_JPRB,1.0521E+01_JPRB/)
KBO( :, 5,28,11) = (/&
&3.0419E+00_JPRB,3.0404E+00_JPRB,4.7235E+00_JPRB,7.2046E+00_JPRB,9.4195E+00_JPRB,1.0424E+01_JPRB/)
KBO( :, 1,29,11) = (/&
&2.3732E+00_JPRB,2.3723E+00_JPRB,4.8900E+00_JPRB,7.8375E+00_JPRB,1.0150E+01_JPRB,1.0951E+01_JPRB/)
KBO( :, 2,29,11) = (/&
&2.4712E+00_JPRB,2.4702E+00_JPRB,4.8481E+00_JPRB,7.7319E+00_JPRB,1.0078E+01_JPRB,1.0946E+01_JPRB/)
KBO( :, 3,29,11) = (/&
&2.5783E+00_JPRB,2.5771E+00_JPRB,4.8118E+00_JPRB,7.6037E+00_JPRB,9.9721E+00_JPRB,1.0893E+01_JPRB/)
KBO( :, 4,29,11) = (/&
&2.6902E+00_JPRB,2.6889E+00_JPRB,4.7850E+00_JPRB,7.4580E+00_JPRB,9.8268E+00_JPRB,1.0822E+01_JPRB/)
KBO( :, 5,29,11) = (/&
&2.8045E+00_JPRB,2.8032E+00_JPRB,4.7400E+00_JPRB,7.3154E+00_JPRB,9.6483E+00_JPRB,1.0741E+01_JPRB/)
KBO( :, 1,30,11) = (/&
&2.1658E+00_JPRB,2.1650E+00_JPRB,4.8677E+00_JPRB,7.8862E+00_JPRB,1.0317E+01_JPRB,1.1167E+01_JPRB/)
KBO( :, 2,30,11) = (/&
&2.2662E+00_JPRB,2.2652E+00_JPRB,4.8423E+00_JPRB,7.7911E+00_JPRB,1.0262E+01_JPRB,1.1177E+01_JPRB/)
KBO( :, 3,30,11) = (/&
&2.3698E+00_JPRB,2.3687E+00_JPRB,4.8249E+00_JPRB,7.6717E+00_JPRB,1.0162E+01_JPRB,1.1145E+01_JPRB/)
KBO( :, 4,30,11) = (/&
&2.4773E+00_JPRB,2.4761E+00_JPRB,4.7959E+00_JPRB,7.5389E+00_JPRB,1.0012E+01_JPRB,1.1105E+01_JPRB/)
KBO( :, 5,30,11) = (/&
&2.5877E+00_JPRB,2.5865E+00_JPRB,4.7569E+00_JPRB,7.4115E+00_JPRB,9.8340E+00_JPRB,1.1029E+01_JPRB/)
KBO( :, 1,31,11) = (/&
&1.9790E+00_JPRB,1.9782E+00_JPRB,4.8500E+00_JPRB,7.9143E+00_JPRB,1.0464E+01_JPRB,1.1366E+01_JPRB/)
KBO( :, 2,31,11) = (/&
&2.0776E+00_JPRB,2.0767E+00_JPRB,4.8427E+00_JPRB,7.8316E+00_JPRB,1.0417E+01_JPRB,1.1398E+01_JPRB/)
KBO( :, 3,31,11) = (/&
&2.1797E+00_JPRB,2.1787E+00_JPRB,4.8321E+00_JPRB,7.7240E+00_JPRB,1.0316E+01_JPRB,1.1410E+01_JPRB/)
KBO( :, 4,31,11) = (/&
&2.2842E+00_JPRB,2.2832E+00_JPRB,4.8021E+00_JPRB,7.6072E+00_JPRB,1.0171E+01_JPRB,1.1390E+01_JPRB/)
KBO( :, 5,31,11) = (/&
&2.3904E+00_JPRB,2.3893E+00_JPRB,4.7702E+00_JPRB,7.4874E+00_JPRB,9.9885E+00_JPRB,1.1305E+01_JPRB/)
KBO( :, 1,32,11) = (/&
&1.8065E+00_JPRB,1.8057E+00_JPRB,4.8337E+00_JPRB,7.9321E+00_JPRB,1.0594E+01_JPRB,1.1553E+01_JPRB/)
KBO( :, 2,32,11) = (/&
&1.9056E+00_JPRB,1.9048E+00_JPRB,4.8404E+00_JPRB,7.8602E+00_JPRB,1.0550E+01_JPRB,1.1632E+01_JPRB/)
KBO( :, 3,32,11) = (/&
&2.0071E+00_JPRB,2.0062E+00_JPRB,4.8291E+00_JPRB,7.7660E+00_JPRB,1.0447E+01_JPRB,1.1676E+01_JPRB/)
KBO( :, 4,32,11) = (/&
&2.1091E+00_JPRB,2.1082E+00_JPRB,4.8052E+00_JPRB,7.6656E+00_JPRB,1.0296E+01_JPRB,1.1648E+01_JPRB/)
KBO( :, 5,32,11) = (/&
&2.2144E+00_JPRB,2.2134E+00_JPRB,4.7806E+00_JPRB,7.5529E+00_JPRB,1.0105E+01_JPRB,1.1557E+01_JPRB/)
KBO( :, 1,33,11) = (/&
&1.6510E+00_JPRB,1.6503E+00_JPRB,4.8210E+00_JPRB,7.9482E+00_JPRB,1.0706E+01_JPRB,1.1767E+01_JPRB/)
KBO( :, 2,33,11) = (/&
&1.7494E+00_JPRB,1.7487E+00_JPRB,4.8343E+00_JPRB,7.8861E+00_JPRB,1.0658E+01_JPRB,1.1881E+01_JPRB/)
KBO( :, 3,33,11) = (/&
&1.8501E+00_JPRB,1.8493E+00_JPRB,4.8252E+00_JPRB,7.8076E+00_JPRB,1.0548E+01_JPRB,1.1918E+01_JPRB/)
KBO( :, 4,33,11) = (/&
&1.9524E+00_JPRB,1.9516E+00_JPRB,4.8101E+00_JPRB,7.7163E+00_JPRB,1.0391E+01_JPRB,1.1878E+01_JPRB/)
KBO( :, 5,33,11) = (/&
&2.0594E+00_JPRB,2.0586E+00_JPRB,4.7896E+00_JPRB,7.6047E+00_JPRB,1.0193E+01_JPRB,1.1783E+01_JPRB/)
KBO( :, 1,34,11) = (/&
&1.5098E+00_JPRB,1.5093E+00_JPRB,4.8119E+00_JPRB,7.9653E+00_JPRB,1.0798E+01_JPRB,1.1972E+01_JPRB/)
KBO( :, 2,34,11) = (/&
&1.6067E+00_JPRB,1.6061E+00_JPRB,4.8282E+00_JPRB,7.9164E+00_JPRB,1.0745E+01_JPRB,1.2091E+01_JPRB/)
KBO( :, 3,34,11) = (/&
&1.7068E+00_JPRB,1.7062E+00_JPRB,4.8254E+00_JPRB,7.8470E+00_JPRB,1.0632E+01_JPRB,1.2113E+01_JPRB/)
KBO( :, 4,34,11) = (/&
&1.8116E+00_JPRB,1.8109E+00_JPRB,4.8147E+00_JPRB,7.7622E+00_JPRB,1.0470E+01_JPRB,1.2073E+01_JPRB/)
KBO( :, 5,34,11) = (/&
&1.9232E+00_JPRB,1.9225E+00_JPRB,4.7977E+00_JPRB,7.6521E+00_JPRB,1.0264E+01_JPRB,1.1969E+01_JPRB/)
KBO( :, 1,35,11) = (/&
&1.3777E+00_JPRB,1.3773E+00_JPRB,4.8007E+00_JPRB,7.9865E+00_JPRB,1.0878E+01_JPRB,1.2152E+01_JPRB/)
KBO( :, 2,35,11) = (/&
&1.4720E+00_JPRB,1.4715E+00_JPRB,4.8220E+00_JPRB,7.9505E+00_JPRB,1.0824E+01_JPRB,1.2272E+01_JPRB/)
KBO( :, 3,35,11) = (/&
&1.5713E+00_JPRB,1.5708E+00_JPRB,4.8275E+00_JPRB,7.8907E+00_JPRB,1.0710E+01_JPRB,1.2296E+01_JPRB/)
KBO( :, 4,35,11) = (/&
&1.6790E+00_JPRB,1.6784E+00_JPRB,4.8220E+00_JPRB,7.8081E+00_JPRB,1.0547E+01_JPRB,1.2260E+01_JPRB/)
KBO( :, 5,35,11) = (/&
&1.7986E+00_JPRB,1.7980E+00_JPRB,4.8075E+00_JPRB,7.7002E+00_JPRB,1.0336E+01_JPRB,1.2159E+01_JPRB/)
KBO( :, 1,36,11) = (/&
&1.2514E+00_JPRB,1.2511E+00_JPRB,4.7868E+00_JPRB,8.0109E+00_JPRB,1.0946E+01_JPRB,1.2304E+01_JPRB/)
KBO( :, 2,36,11) = (/&
&1.3435E+00_JPRB,1.3431E+00_JPRB,4.8179E+00_JPRB,7.9877E+00_JPRB,1.0897E+01_JPRB,1.2427E+01_JPRB/)
KBO( :, 3,36,11) = (/&
&1.4435E+00_JPRB,1.4430E+00_JPRB,4.8314E+00_JPRB,7.9353E+00_JPRB,1.0788E+01_JPRB,1.2470E+01_JPRB/)
KBO( :, 4,36,11) = (/&
&1.5538E+00_JPRB,1.5533E+00_JPRB,4.8318E+00_JPRB,7.8582E+00_JPRB,1.0627E+01_JPRB,1.2438E+01_JPRB/)
KBO( :, 5,36,11) = (/&
&1.6810E+00_JPRB,1.6804E+00_JPRB,4.8203E+00_JPRB,7.7528E+00_JPRB,1.0416E+01_JPRB,1.2339E+01_JPRB/)
KBO( :, 1,37,11) = (/&
&1.1282E+00_JPRB,1.1280E+00_JPRB,4.7699E+00_JPRB,8.0315E+00_JPRB,1.1000E+01_JPRB,1.2396E+01_JPRB/)
KBO( :, 2,37,11) = (/&
&1.2167E+00_JPRB,1.2164E+00_JPRB,4.8125E+00_JPRB,8.0243E+00_JPRB,1.0970E+01_JPRB,1.2544E+01_JPRB/)
KBO( :, 3,37,11) = (/&
&1.3158E+00_JPRB,1.3155E+00_JPRB,4.8359E+00_JPRB,7.9814E+00_JPRB,1.0872E+01_JPRB,1.2615E+01_JPRB/)
KBO( :, 4,37,11) = (/&
&1.4284E+00_JPRB,1.4280E+00_JPRB,4.8417E+00_JPRB,7.9120E+00_JPRB,1.0722E+01_JPRB,1.2596E+01_JPRB/)
KBO( :, 5,37,11) = (/&
&1.5612E+00_JPRB,1.5606E+00_JPRB,4.8348E+00_JPRB,7.8131E+00_JPRB,1.0516E+01_JPRB,1.2504E+01_JPRB/)
KBO( :, 1,38,11) = (/&
&1.0204E+00_JPRB,1.0202E+00_JPRB,4.7523E+00_JPRB,8.0470E+00_JPRB,1.1041E+01_JPRB,1.2476E+01_JPRB/)
KBO( :, 2,38,11) = (/&
&1.1044E+00_JPRB,1.1042E+00_JPRB,4.8063E+00_JPRB,8.0526E+00_JPRB,1.1031E+01_JPRB,1.2656E+01_JPRB/)
KBO( :, 3,38,11) = (/&
&1.2026E+00_JPRB,1.2023E+00_JPRB,4.8389E+00_JPRB,8.0207E+00_JPRB,1.0945E+01_JPRB,1.2754E+01_JPRB/)
KBO( :, 4,38,11) = (/&
&1.3171E+00_JPRB,1.3167E+00_JPRB,4.8508E+00_JPRB,7.9583E+00_JPRB,1.0805E+01_JPRB,1.2746E+01_JPRB/)
KBO( :, 5,38,11) = (/&
&1.4551E+00_JPRB,1.4546E+00_JPRB,4.8486E+00_JPRB,7.8661E+00_JPRB,1.0608E+01_JPRB,1.2659E+01_JPRB/)
KBO( :, 1,39,11) = (/&
&9.2697E-01_JPRB,9.2690E-01_JPRB,4.7345E+00_JPRB,8.0529E+00_JPRB,1.1070E+01_JPRB,1.2554E+01_JPRB/)
KBO( :, 2,39,11) = (/&
&1.0083E+00_JPRB,1.0081E+00_JPRB,4.8007E+00_JPRB,8.0735E+00_JPRB,1.1079E+01_JPRB,1.2773E+01_JPRB/)
KBO( :, 3,39,11) = (/&
&1.1037E+00_JPRB,1.1035E+00_JPRB,4.8402E+00_JPRB,8.0520E+00_JPRB,1.1008E+01_JPRB,1.2893E+01_JPRB/)
KBO( :, 4,39,11) = (/&
&1.2204E+00_JPRB,1.2201E+00_JPRB,4.8590E+00_JPRB,7.9971E+00_JPRB,1.0876E+01_JPRB,1.2892E+01_JPRB/)
KBO( :, 5,39,11) = (/&
&1.3628E+00_JPRB,1.3623E+00_JPRB,4.8606E+00_JPRB,7.9113E+00_JPRB,1.0688E+01_JPRB,1.2810E+01_JPRB/)
KBO( :, 1,40,11) = (/&
&8.3758E-01_JPRB,8.3760E-01_JPRB,4.7063E+00_JPRB,8.0487E+00_JPRB,1.1082E+01_JPRB,1.2556E+01_JPRB/)
KBO( :, 2,40,11) = (/&
&9.1581E-01_JPRB,9.1577E-01_JPRB,4.7869E+00_JPRB,8.0879E+00_JPRB,1.1120E+01_JPRB,1.2816E+01_JPRB/)
KBO( :, 3,40,11) = (/&
&1.0079E+00_JPRB,1.0078E+00_JPRB,4.8371E+00_JPRB,8.0805E+00_JPRB,1.1070E+01_JPRB,1.2970E+01_JPRB/)
KBO( :, 4,40,11) = (/&
&1.1225E+00_JPRB,1.1222E+00_JPRB,4.8639E+00_JPRB,8.0357E+00_JPRB,1.0954E+01_JPRB,1.2989E+01_JPRB/)
KBO( :, 5,40,11) = (/&
&1.2665E+00_JPRB,1.2660E+00_JPRB,4.8714E+00_JPRB,7.9591E+00_JPRB,1.0779E+01_JPRB,1.2926E+01_JPRB/)
KBO( :, 1,41,11) = (/&
&7.5804E-01_JPRB,7.5812E-01_JPRB,4.6746E+00_JPRB,8.0347E+00_JPRB,1.1077E+01_JPRB,1.2530E+01_JPRB/)
KBO( :, 2,41,11) = (/&
&8.3424E-01_JPRB,8.3425E-01_JPRB,4.7690E+00_JPRB,8.0936E+00_JPRB,1.1147E+01_JPRB,1.2837E+01_JPRB/)
KBO( :, 3,41,11) = (/&
&9.2284E-01_JPRB,9.2272E-01_JPRB,4.8295E+00_JPRB,8.1031E+00_JPRB,1.1121E+01_JPRB,1.3026E+01_JPRB/)
KBO( :, 4,41,11) = (/&
&1.0345E+00_JPRB,1.0342E+00_JPRB,4.8660E+00_JPRB,8.0690E+00_JPRB,1.1022E+01_JPRB,1.3069E+01_JPRB/)
KBO( :, 5,41,11) = (/&
&1.1779E+00_JPRB,1.1775E+00_JPRB,4.8792E+00_JPRB,8.0025E+00_JPRB,1.0862E+01_JPRB,1.3028E+01_JPRB/)
KBO( :, 1,42,11) = (/&
&6.8836E-01_JPRB,6.8850E-01_JPRB,4.6395E+00_JPRB,8.0108E+00_JPRB,1.1057E+01_JPRB,1.2493E+01_JPRB/)
KBO( :, 2,42,11) = (/&
&7.6202E-01_JPRB,7.6208E-01_JPRB,4.7478E+00_JPRB,8.0915E+00_JPRB,1.1161E+01_JPRB,1.2847E+01_JPRB/)
KBO( :, 3,42,11) = (/&
&8.4897E-01_JPRB,8.4889E-01_JPRB,4.8194E+00_JPRB,8.1177E+00_JPRB,1.1160E+01_JPRB,1.3071E+01_JPRB/)
KBO( :, 4,42,11) = (/&
&9.5721E-01_JPRB,9.5697E-01_JPRB,4.8642E+00_JPRB,8.0964E+00_JPRB,1.1081E+01_JPRB,1.3142E+01_JPRB/)
KBO( :, 5,42,11) = (/&
&1.0979E+00_JPRB,1.0975E+00_JPRB,4.8838E+00_JPRB,8.0399E+00_JPRB,1.0937E+01_JPRB,1.3122E+01_JPRB/)
KBO( :, 1,43,11) = (/&
&6.2327E-01_JPRB,6.2346E-01_JPRB,4.5920E+00_JPRB,7.9682E+00_JPRB,1.1010E+01_JPRB,1.2410E+01_JPRB/)
KBO( :, 2,43,11) = (/&
&6.9363E-01_JPRB,6.9372E-01_JPRB,4.7172E+00_JPRB,8.0779E+00_JPRB,1.1157E+01_JPRB,1.2823E+01_JPRB/)
KBO( :, 3,43,11) = (/&
&7.7812E-01_JPRB,7.7808E-01_JPRB,4.8024E+00_JPRB,8.1237E+00_JPRB,1.1190E+01_JPRB,1.3092E+01_JPRB/)
KBO( :, 4,43,11) = (/&
&8.8257E-01_JPRB,8.8240E-01_JPRB,4.8564E+00_JPRB,8.1185E+00_JPRB,1.1134E+01_JPRB,1.3199E+01_JPRB/)
KBO( :, 5,43,11) = (/&
&1.0175E+00_JPRB,1.0172E+00_JPRB,4.8852E+00_JPRB,8.0748E+00_JPRB,1.1010E+01_JPRB,1.3208E+01_JPRB/)
KBO( :, 1,44,11) = (/&
&5.6319E-01_JPRB,5.6344E-01_JPRB,4.5362E+00_JPRB,7.9098E+00_JPRB,1.0942E+01_JPRB,1.2291E+01_JPRB/)
KBO( :, 2,44,11) = (/&
&6.3128E-01_JPRB,6.3143E-01_JPRB,4.6773E+00_JPRB,8.0513E+00_JPRB,1.1133E+01_JPRB,1.2773E+01_JPRB/)
KBO( :, 3,44,11) = (/&
&7.1290E-01_JPRB,7.1288E-01_JPRB,4.7788E+00_JPRB,8.1200E+00_JPRB,1.1206E+01_JPRB,1.3092E+01_JPRB/)
KBO( :, 4,44,11) = (/&
&8.1370E-01_JPRB,8.1356E-01_JPRB,4.8431E+00_JPRB,8.1349E+00_JPRB,1.1178E+01_JPRB,1.3245E+01_JPRB/)
KBO( :, 5,44,11) = (/&
&9.4155E-01_JPRB,9.4126E-01_JPRB,4.8828E+00_JPRB,8.1039E+00_JPRB,1.1076E+01_JPRB,1.3283E+01_JPRB/)
KBO( :, 1,45,11) = (/&
&5.0848E-01_JPRB,5.0877E-01_JPRB,4.4759E+00_JPRB,7.8396E+00_JPRB,1.0853E+01_JPRB,1.2157E+01_JPRB/)
KBO( :, 2,45,11) = (/&
&5.7558E-01_JPRB,5.7574E-01_JPRB,4.6321E+00_JPRB,8.0148E+00_JPRB,1.1090E+01_JPRB,1.2710E+01_JPRB/)
KBO( :, 3,45,11) = (/&
&6.5428E-01_JPRB,6.5431E-01_JPRB,4.7490E+00_JPRB,8.1075E+00_JPRB,1.1206E+01_JPRB,1.3081E+01_JPRB/)
KBO( :, 4,45,11) = (/&
&7.5171E-01_JPRB,7.5160E-01_JPRB,4.8272E+00_JPRB,8.1428E+00_JPRB,1.1211E+01_JPRB,1.3283E+01_JPRB/)
KBO( :, 5,45,11) = (/&
&8.7320E-01_JPRB,8.7295E-01_JPRB,4.8756E+00_JPRB,8.1271E+00_JPRB,1.1133E+01_JPRB,1.3354E+01_JPRB/)
KBO( :, 1,46,11) = (/&
&4.5749E-01_JPRB,4.5781E-01_JPRB,4.4050E+00_JPRB,7.7477E+00_JPRB,1.0733E+01_JPRB,1.1988E+01_JPRB/)
KBO( :, 2,46,11) = (/&
&5.2335E-01_JPRB,5.2354E-01_JPRB,4.5777E+00_JPRB,7.9624E+00_JPRB,1.1027E+01_JPRB,1.2622E+01_JPRB/)
KBO( :, 3,46,11) = (/&
&5.9972E-01_JPRB,5.9977E-01_JPRB,4.7113E+00_JPRB,8.0849E+00_JPRB,1.1188E+01_JPRB,1.3051E+01_JPRB/)
KBO( :, 4,46,11) = (/&
&6.9340E-01_JPRB,6.9332E-01_JPRB,4.8042E+00_JPRB,8.1402E+00_JPRB,1.1232E+01_JPRB,1.3309E+01_JPRB/)
KBO( :, 5,46,11) = (/&
&8.0900E-01_JPRB,8.0880E-01_JPRB,4.8629E+00_JPRB,8.1438E+00_JPRB,1.1182E+01_JPRB,1.3415E+01_JPRB/)
KBO( :, 1,47,11) = (/&
&4.0799E-01_JPRB,4.0834E-01_JPRB,4.3192E+00_JPRB,7.6262E+00_JPRB,1.0570E+01_JPRB,1.1748E+01_JPRB/)
KBO( :, 2,47,11) = (/&
&4.7291E-01_JPRB,4.7311E-01_JPRB,4.5111E+00_JPRB,7.8858E+00_JPRB,1.0930E+01_JPRB,1.2474E+01_JPRB/)
KBO( :, 3,47,11) = (/&
&5.4737E-01_JPRB,5.4746E-01_JPRB,4.6622E+00_JPRB,8.0462E+00_JPRB,1.1144E+01_JPRB,1.2972E+01_JPRB/)
KBO( :, 4,47,11) = (/&
&6.3579E-01_JPRB,6.3575E-01_JPRB,4.7722E+00_JPRB,8.1275E+00_JPRB,1.1235E+01_JPRB,1.3300E+01_JPRB/)
KBO( :, 5,47,11) = (/&
&7.4500E-01_JPRB,7.4486E-01_JPRB,4.8444E+00_JPRB,8.1534E+00_JPRB,1.1220E+01_JPRB,1.3455E+01_JPRB/)
KBO( :, 1,48,11) = (/&
&3.6234E-01_JPRB,3.6271E-01_JPRB,4.2229E+00_JPRB,7.4847E+00_JPRB,1.0381E+01_JPRB,1.1491E+01_JPRB/)
KBO( :, 2,48,11) = (/&
&4.2649E-01_JPRB,4.2672E-01_JPRB,4.4362E+00_JPRB,7.7928E+00_JPRB,1.0805E+01_JPRB,1.2307E+01_JPRB/)
KBO( :, 3,48,11) = (/&
&4.9899E-01_JPRB,4.9911E-01_JPRB,4.6047E+00_JPRB,7.9930E+00_JPRB,1.1077E+01_JPRB,1.2882E+01_JPRB/)
KBO( :, 4,48,11) = (/&
&5.8344E-01_JPRB,5.8343E-01_JPRB,4.7326E+00_JPRB,8.1042E+00_JPRB,1.1219E+01_JPRB,1.3280E+01_JPRB/)
KBO( :, 5,48,11) = (/&
&6.8655E-01_JPRB,6.8645E-01_JPRB,4.8209E+00_JPRB,8.1532E+00_JPRB,1.1244E+01_JPRB,1.3490E+01_JPRB/)
KBO( :, 1,49,11) = (/&
&3.2105E-01_JPRB,3.2141E-01_JPRB,4.1218E+00_JPRB,7.3215E+00_JPRB,1.0162E+01_JPRB,1.1223E+01_JPRB/)
KBO( :, 2,49,11) = (/&
&3.8263E-01_JPRB,3.8290E-01_JPRB,4.3538E+00_JPRB,7.6804E+00_JPRB,1.0654E+01_JPRB,1.2130E+01_JPRB/)
KBO( :, 3,49,11) = (/&
&4.5423E-01_JPRB,4.5438E-01_JPRB,4.5413E+00_JPRB,7.9230E+00_JPRB,1.0989E+01_JPRB,1.2791E+01_JPRB/)
KBO( :, 4,49,11) = (/&
&5.3583E-01_JPRB,5.3587E-01_JPRB,4.6861E+00_JPRB,8.0697E+00_JPRB,1.1180E+01_JPRB,1.3260E+01_JPRB/)
KBO( :, 5,49,11) = (/&
&6.3293E-01_JPRB,6.3285E-01_JPRB,4.7905E+00_JPRB,8.1418E+00_JPRB,1.1253E+01_JPRB,1.3527E+01_JPRB/)
KBO( :, 1,50,11) = (/&
&2.8508E-01_JPRB,2.8546E-01_JPRB,4.0216E+00_JPRB,7.1533E+00_JPRB,9.9242E+00_JPRB,1.0908E+01_JPRB/)
KBO( :, 2,50,11) = (/&
&3.4378E-01_JPRB,3.4406E-01_JPRB,4.2684E+00_JPRB,7.5560E+00_JPRB,1.0485E+01_JPRB,1.1896E+01_JPRB/)
KBO( :, 3,50,11) = (/&
&4.1407E-01_JPRB,4.1424E-01_JPRB,4.4746E+00_JPRB,7.8430E+00_JPRB,1.0882E+01_JPRB,1.2647E+01_JPRB/)
KBO( :, 4,50,11) = (/&
&4.9363E-01_JPRB,4.9370E-01_JPRB,4.6366E+00_JPRB,8.0253E+00_JPRB,1.1126E+01_JPRB,1.3186E+01_JPRB/)
KBO( :, 5,50,11) = (/&
&5.8619E-01_JPRB,5.8614E-01_JPRB,4.7566E+00_JPRB,8.1231E+00_JPRB,1.1244E+01_JPRB,1.3516E+01_JPRB/)
KBO( :, 1,51,11) = (/&
&2.5326E-01_JPRB,2.5365E-01_JPRB,3.9197E+00_JPRB,6.9713E+00_JPRB,9.6644E+00_JPRB,1.0563E+01_JPRB/)
KBO( :, 2,51,11) = (/&
&3.0874E-01_JPRB,3.0902E-01_JPRB,4.1778E+00_JPRB,7.4188E+00_JPRB,1.0300E+01_JPRB,1.1619E+01_JPRB/)
KBO( :, 3,51,11) = (/&
&3.7711E-01_JPRB,3.7728E-01_JPRB,4.4030E+00_JPRB,7.7505E+00_JPRB,1.0757E+01_JPRB,1.2466E+01_JPRB/)
KBO( :, 4,51,11) = (/&
&4.5549E-01_JPRB,4.5558E-01_JPRB,4.5816E+00_JPRB,7.9699E+00_JPRB,1.1056E+01_JPRB,1.3074E+01_JPRB/)
KBO( :, 5,51,11) = (/&
&5.4422E-01_JPRB,5.4419E-01_JPRB,4.7173E+00_JPRB,8.0963E+00_JPRB,1.1218E+01_JPRB,1.3472E+01_JPRB/)
KBO( :, 1,52,11) = (/&
&2.2461E-01_JPRB,2.2501E-01_JPRB,3.8110E+00_JPRB,6.7727E+00_JPRB,9.3780E+00_JPRB,1.0204E+01_JPRB/)
KBO( :, 2,52,11) = (/&
&2.7696E-01_JPRB,2.7724E-01_JPRB,4.0846E+00_JPRB,7.2661E+00_JPRB,1.0090E+01_JPRB,1.1325E+01_JPRB/)
KBO( :, 3,52,11) = (/&
&3.4251E-01_JPRB,3.4273E-01_JPRB,4.3258E+00_JPRB,7.6413E+00_JPRB,1.0608E+01_JPRB,1.2266E+01_JPRB/)
KBO( :, 4,52,11) = (/&
&4.1924E-01_JPRB,4.1934E-01_JPRB,4.5215E+00_JPRB,7.9004E+00_JPRB,1.0966E+01_JPRB,1.2948E+01_JPRB/)
KBO( :, 5,52,11) = (/&
&5.0516E-01_JPRB,5.0516E-01_JPRB,4.6729E+00_JPRB,8.0607E+00_JPRB,1.1176E+01_JPRB,1.3418E+01_JPRB/)
KBO( :, 1,53,11) = (/&
&1.9876E-01_JPRB,1.9925E-01_JPRB,3.6957E+00_JPRB,6.5526E+00_JPRB,9.0627E+00_JPRB,9.8215E+00_JPRB/)
KBO( :, 2,53,11) = (/&
&2.4812E-01_JPRB,2.4842E-01_JPRB,3.9863E+00_JPRB,7.0970E+00_JPRB,9.8501E+00_JPRB,1.1018E+01_JPRB/)
KBO( :, 3,53,11) = (/&
&3.1019E-01_JPRB,3.1042E-01_JPRB,4.2400E+00_JPRB,7.5167E+00_JPRB,1.0436E+01_JPRB,1.2052E+01_JPRB/)
KBO( :, 4,53,11) = (/&
&3.8453E-01_JPRB,3.8465E-01_JPRB,4.4543E+00_JPRB,7.8181E+00_JPRB,1.0855E+01_JPRB,1.2811E+01_JPRB/)
KBO( :, 5,53,11) = (/&
&4.6824E-01_JPRB,4.6827E-01_JPRB,4.6221E+00_JPRB,8.0127E+00_JPRB,1.1114E+01_JPRB,1.3357E+01_JPRB/)
KBO( :, 1,54,11) = (/&
&1.7658E-01_JPRB,1.7738E-01_JPRB,3.5830E+00_JPRB,6.3331E+00_JPRB,8.7501E+00_JPRB,9.3830E+00_JPRB/)
KBO( :, 2,54,11) = (/&
&2.2311E-01_JPRB,2.2343E-01_JPRB,3.8924E+00_JPRB,6.9272E+00_JPRB,9.6066E+00_JPRB,1.0637E+01_JPRB/)
KBO( :, 3,54,11) = (/&
&2.8225E-01_JPRB,2.8249E-01_JPRB,4.1567E+00_JPRB,7.3875E+00_JPRB,1.0262E+01_JPRB,1.1745E+01_JPRB/)
KBO( :, 4,54,11) = (/&
&3.5407E-01_JPRB,3.5420E-01_JPRB,4.3869E+00_JPRB,7.7293E+00_JPRB,1.0733E+01_JPRB,1.2587E+01_JPRB/)
KBO( :, 5,54,11) = (/&
&4.3599E-01_JPRB,4.3605E-01_JPRB,4.5705E+00_JPRB,7.9578E+00_JPRB,1.1045E+01_JPRB,1.3213E+01_JPRB/)
KBO( :, 1,55,11) = (/&
&1.5693E-01_JPRB,1.5821E-01_JPRB,3.4683E+00_JPRB,6.1089E+00_JPRB,8.4282E+00_JPRB,8.9090E+00_JPRB/)
KBO( :, 2,55,11) = (/&
&2.0085E-01_JPRB,2.0128E-01_JPRB,3.7963E+00_JPRB,6.7515E+00_JPRB,9.3517E+00_JPRB,1.0215E+01_JPRB/)
KBO( :, 3,55,11) = (/&
&2.5734E-01_JPRB,2.5756E-01_JPRB,4.0737E+00_JPRB,7.2511E+00_JPRB,1.0072E+01_JPRB,1.1362E+01_JPRB/)
KBO( :, 4,55,11) = (/&
&3.2630E-01_JPRB,3.2643E-01_JPRB,4.3183E+00_JPRB,7.6321E+00_JPRB,1.0598E+01_JPRB,1.2305E+01_JPRB/)
KBO( :, 5,55,11) = (/&
&4.0605E-01_JPRB,4.0612E-01_JPRB,4.5166E+00_JPRB,7.8950E+00_JPRB,1.0962E+01_JPRB,1.2994E+01_JPRB/)
KBO( :, 1,56,11) = (/&
&1.3887E-01_JPRB,1.4103E-01_JPRB,3.3452E+00_JPRB,5.8712E+00_JPRB,8.0833E+00_JPRB,8.4282E+00_JPRB/)
KBO( :, 2,56,11) = (/&
&1.8055E-01_JPRB,1.8122E-01_JPRB,3.6957E+00_JPRB,6.5591E+00_JPRB,9.0757E+00_JPRB,9.7805E+00_JPRB/)
KBO( :, 3,56,11) = (/&
&2.3436E-01_JPRB,2.3458E-01_JPRB,3.9878E+00_JPRB,7.1027E+00_JPRB,9.8624E+00_JPRB,1.0961E+01_JPRB/)
KBO( :, 4,56,11) = (/&
&2.9996E-01_JPRB,3.0009E-01_JPRB,4.2431E+00_JPRB,7.5221E+00_JPRB,1.0447E+01_JPRB,1.1989E+01_JPRB/)
KBO( :, 5,56,11) = (/&
&3.7712E-01_JPRB,3.7719E-01_JPRB,4.4577E+00_JPRB,7.8227E+00_JPRB,1.0864E+01_JPRB,1.2750E+01_JPRB/)
KBO( :, 1,57,11) = (/&
&1.2231E-01_JPRB,1.2572E-01_JPRB,3.2149E+00_JPRB,5.6195E+00_JPRB,7.7189E+00_JPRB,7.9409E+00_JPRB/)
KBO( :, 2,57,11) = (/&
&1.6188E-01_JPRB,1.6303E-01_JPRB,3.5895E+00_JPRB,6.3509E+00_JPRB,8.7789E+00_JPRB,9.3239E+00_JPRB/)
KBO( :, 3,57,11) = (/&
&2.1281E-01_JPRB,2.1309E-01_JPRB,3.8984E+00_JPRB,6.9426E+00_JPRB,9.6313E+00_JPRB,1.0551E+01_JPRB/)
KBO( :, 4,57,11) = (/&
&2.7533E-01_JPRB,2.7549E-01_JPRB,4.1635E+00_JPRB,7.3997E+00_JPRB,1.0280E+01_JPRB,1.1629E+01_JPRB/)
KBO( :, 5,57,11) = (/&
&3.4953E-01_JPRB,3.4962E-01_JPRB,4.3933E+00_JPRB,7.7390E+00_JPRB,1.0749E+01_JPRB,1.2483E+01_JPRB/)
KBO( :, 1,58,11) = (/&
&1.0753E-01_JPRB,1.1255E-01_JPRB,3.0845E+00_JPRB,5.3675E+00_JPRB,7.3519E+00_JPRB,7.4714E+00_JPRB/)
KBO( :, 2,58,11) = (/&
&1.4527E-01_JPRB,1.4713E-01_JPRB,3.4823E+00_JPRB,6.1407E+00_JPRB,8.4780E+00_JPRB,8.8781E+00_JPRB/)
KBO( :, 3,58,11) = (/&
&1.9346E-01_JPRB,1.9393E-01_JPRB,3.8086E+00_JPRB,6.7779E+00_JPRB,9.3926E+00_JPRB,1.0139E+01_JPRB/)
KBO( :, 4,58,11) = (/&
&2.5331E-01_JPRB,2.5345E-01_JPRB,4.0858E+00_JPRB,7.2725E+00_JPRB,1.0104E+01_JPRB,1.1238E+01_JPRB/)
KBO( :, 5,58,11) = (/&
&3.2441E-01_JPRB,3.2451E-01_JPRB,4.3290E+00_JPRB,7.6484E+00_JPRB,1.0623E+01_JPRB,1.2180E+01_JPRB/)
KBO( :, 1,59,11) = (/&
&9.9614E-02_JPRB,1.0577E-01_JPRB,3.0288E+00_JPRB,5.2610E+00_JPRB,7.1978E+00_JPRB,7.2394E+00_JPRB/)
KBO( :, 2,59,11) = (/&
&1.3736E-01_JPRB,1.3969E-01_JPRB,3.4366E+00_JPRB,6.0532E+00_JPRB,8.3509E+00_JPRB,8.6179E+00_JPRB/)
KBO( :, 3,59,11) = (/&
&1.8506E-01_JPRB,1.8566E-01_JPRB,3.7708E+00_JPRB,6.7076E+00_JPRB,9.2912E+00_JPRB,9.8422E+00_JPRB/)
KBO( :, 4,59,11) = (/&
&2.4408E-01_JPRB,2.4421E-01_JPRB,4.0531E+00_JPRB,7.2180E+00_JPRB,1.0029E+01_JPRB,1.0900E+01_JPRB/)
KBO( :, 5,59,11) = (/&
&3.1395E-01_JPRB,3.1406E-01_JPRB,4.3016E+00_JPRB,7.6085E+00_JPRB,1.0568E+01_JPRB,1.1809E+01_JPRB/)
KBO( :, 1,13,12) = (/&
&1.5071E+01_JPRB,1.5062E+01_JPRB,1.1553E+01_JPRB,8.0422E+00_JPRB,5.1775E+00_JPRB,4.4276E+00_JPRB/)
KBO( :, 2,13,12) = (/&
&1.5045E+01_JPRB,1.5037E+01_JPRB,1.1523E+01_JPRB,8.0068E+00_JPRB,5.0603E+00_JPRB,4.3468E+00_JPRB/)
KBO( :, 3,13,12) = (/&
&1.4932E+01_JPRB,1.4924E+01_JPRB,1.1428E+01_JPRB,7.9305E+00_JPRB,4.9434E+00_JPRB,4.2743E+00_JPRB/)
KBO( :, 4,13,12) = (/&
&1.4793E+01_JPRB,1.4785E+01_JPRB,1.1318E+01_JPRB,7.8509E+00_JPRB,4.8345E+00_JPRB,4.2338E+00_JPRB/)
KBO( :, 5,13,12) = (/&
&1.4616E+01_JPRB,1.4607E+01_JPRB,1.1172E+01_JPRB,7.7373E+00_JPRB,4.7181E+00_JPRB,4.2382E+00_JPRB/)
KBO( :, 1,14,12) = (/&
&1.6109E+01_JPRB,1.6100E+01_JPRB,1.2313E+01_JPRB,8.5158E+00_JPRB,5.5307E+00_JPRB,4.8392E+00_JPRB/)
KBO( :, 2,14,12) = (/&
&1.6026E+01_JPRB,1.6017E+01_JPRB,1.2244E+01_JPRB,8.4632E+00_JPRB,5.4108E+00_JPRB,4.7399E+00_JPRB/)
KBO( :, 3,14,12) = (/&
&1.5874E+01_JPRB,1.5865E+01_JPRB,1.2127E+01_JPRB,8.3786E+00_JPRB,5.2843E+00_JPRB,4.6480E+00_JPRB/)
KBO( :, 4,14,12) = (/&
&1.5690E+01_JPRB,1.5681E+01_JPRB,1.1982E+01_JPRB,8.2687E+00_JPRB,5.1442E+00_JPRB,4.5663E+00_JPRB/)
KBO( :, 5,14,12) = (/&
&1.5467E+01_JPRB,1.5458E+01_JPRB,1.1810E+01_JPRB,8.1473E+00_JPRB,5.0031E+00_JPRB,4.5067E+00_JPRB/)
KBO( :, 1,15,12) = (/&
&1.6950E+01_JPRB,1.6940E+01_JPRB,1.2936E+01_JPRB,8.9243E+00_JPRB,5.9139E+00_JPRB,5.3392E+00_JPRB/)
KBO( :, 2,15,12) = (/&
&1.6795E+01_JPRB,1.6786E+01_JPRB,1.2817E+01_JPRB,8.8403E+00_JPRB,5.7728E+00_JPRB,5.2173E+00_JPRB/)
KBO( :, 3,15,12) = (/&
&1.6618E+01_JPRB,1.6608E+01_JPRB,1.2675E+01_JPRB,8.7335E+00_JPRB,5.6294E+00_JPRB,5.1076E+00_JPRB/)
KBO( :, 4,15,12) = (/&
&1.6363E+01_JPRB,1.6354E+01_JPRB,1.2477E+01_JPRB,8.5926E+00_JPRB,5.4844E+00_JPRB,5.0174E+00_JPRB/)
KBO( :, 5,15,12) = (/&
&1.6071E+01_JPRB,1.6061E+01_JPRB,1.2263E+01_JPRB,8.4516E+00_JPRB,5.3505E+00_JPRB,4.9217E+00_JPRB/)
KBO( :, 1,16,12) = (/&
&1.7483E+01_JPRB,1.7473E+01_JPRB,1.3331E+01_JPRB,9.1930E+00_JPRB,6.3135E+00_JPRB,5.9094E+00_JPRB/)
KBO( :, 2,16,12) = (/&
&1.7265E+01_JPRB,1.7255E+01_JPRB,1.3158E+01_JPRB,9.0640E+00_JPRB,6.1752E+00_JPRB,5.7636E+00_JPRB/)
KBO( :, 3,16,12) = (/&
&1.7001E+01_JPRB,1.6992E+01_JPRB,1.2961E+01_JPRB,8.9272E+00_JPRB,6.0421E+00_JPRB,5.6420E+00_JPRB/)
KBO( :, 4,16,12) = (/&
&1.6715E+01_JPRB,1.6706E+01_JPRB,1.2750E+01_JPRB,8.7873E+00_JPRB,5.9067E+00_JPRB,5.5250E+00_JPRB/)
KBO( :, 5,16,12) = (/&
&1.6400E+01_JPRB,1.6391E+01_JPRB,1.2509E+01_JPRB,8.6238E+00_JPRB,5.7670E+00_JPRB,5.4408E+00_JPRB/)
KBO( :, 1,17,12) = (/&
&1.7611E+01_JPRB,1.7601E+01_JPRB,1.3423E+01_JPRB,9.2865E+00_JPRB,6.8286E+00_JPRB,6.5192E+00_JPRB/)
KBO( :, 2,17,12) = (/&
&1.7351E+01_JPRB,1.7341E+01_JPRB,1.3231E+01_JPRB,9.1506E+00_JPRB,6.6893E+00_JPRB,6.3748E+00_JPRB/)
KBO( :, 3,17,12) = (/&
&1.7056E+01_JPRB,1.7047E+01_JPRB,1.3013E+01_JPRB,9.0104E+00_JPRB,6.5437E+00_JPRB,6.2526E+00_JPRB/)
KBO( :, 4,17,12) = (/&
&1.6747E+01_JPRB,1.6738E+01_JPRB,1.2778E+01_JPRB,8.8490E+00_JPRB,6.3936E+00_JPRB,6.1321E+00_JPRB/)
KBO( :, 5,17,12) = (/&
&1.6425E+01_JPRB,1.6416E+01_JPRB,1.2531E+01_JPRB,8.6800E+00_JPRB,6.2394E+00_JPRB,6.0341E+00_JPRB/)
KBO( :, 1,18,12) = (/&
&1.7373E+01_JPRB,1.7363E+01_JPRB,1.3259E+01_JPRB,9.2987E+00_JPRB,7.4434E+00_JPRB,7.1986E+00_JPRB/)
KBO( :, 2,18,12) = (/&
&1.7075E+01_JPRB,1.7065E+01_JPRB,1.3035E+01_JPRB,9.1492E+00_JPRB,7.2871E+00_JPRB,7.0606E+00_JPRB/)
KBO( :, 3,18,12) = (/&
&1.6756E+01_JPRB,1.6747E+01_JPRB,1.2796E+01_JPRB,8.9869E+00_JPRB,7.1229E+00_JPRB,6.9365E+00_JPRB/)
KBO( :, 4,18,12) = (/&
&1.6448E+01_JPRB,1.6438E+01_JPRB,1.2559E+01_JPRB,8.8102E+00_JPRB,6.9614E+00_JPRB,6.7953E+00_JPRB/)
KBO( :, 5,18,12) = (/&
&1.6127E+01_JPRB,1.6118E+01_JPRB,1.2311E+01_JPRB,8.6284E+00_JPRB,6.8009E+00_JPRB,6.6712E+00_JPRB/)
KBO( :, 1,19,12) = (/&
&1.6746E+01_JPRB,1.6736E+01_JPRB,1.2803E+01_JPRB,9.3167E+00_JPRB,8.0934E+00_JPRB,7.9604E+00_JPRB/)
KBO( :, 2,19,12) = (/&
&1.6435E+01_JPRB,1.6426E+01_JPRB,1.2567E+01_JPRB,9.1426E+00_JPRB,7.9243E+00_JPRB,7.8083E+00_JPRB/)
KBO( :, 3,19,12) = (/&
&1.6123E+01_JPRB,1.6114E+01_JPRB,1.2329E+01_JPRB,8.9518E+00_JPRB,7.7527E+00_JPRB,7.6627E+00_JPRB/)
KBO( :, 4,19,12) = (/&
&1.5818E+01_JPRB,1.5809E+01_JPRB,1.2094E+01_JPRB,8.7559E+00_JPRB,7.5782E+00_JPRB,7.5080E+00_JPRB/)
KBO( :, 5,19,12) = (/&
&1.5498E+01_JPRB,1.5490E+01_JPRB,1.1845E+01_JPRB,8.5563E+00_JPRB,7.3997E+00_JPRB,7.3552E+00_JPRB/)
KBO( :, 1,20,12) = (/&
&1.5808E+01_JPRB,1.5799E+01_JPRB,1.2109E+01_JPRB,9.3560E+00_JPRB,8.7540E+00_JPRB,8.7978E+00_JPRB/)
KBO( :, 2,20,12) = (/&
&1.5503E+01_JPRB,1.5494E+01_JPRB,1.1873E+01_JPRB,9.1479E+00_JPRB,8.5752E+00_JPRB,8.6307E+00_JPRB/)
KBO( :, 3,20,12) = (/&
&1.5194E+01_JPRB,1.5185E+01_JPRB,1.1636E+01_JPRB,8.9392E+00_JPRB,8.3955E+00_JPRB,8.4731E+00_JPRB/)
KBO( :, 4,20,12) = (/&
&1.4894E+01_JPRB,1.4886E+01_JPRB,1.1403E+01_JPRB,8.7296E+00_JPRB,8.2170E+00_JPRB,8.2989E+00_JPRB/)
KBO( :, 5,20,12) = (/&
&1.4572E+01_JPRB,1.4563E+01_JPRB,1.1152E+01_JPRB,8.5115E+00_JPRB,8.0382E+00_JPRB,8.1214E+00_JPRB/)
KBO( :, 1,21,12) = (/&
&1.4618E+01_JPRB,1.4609E+01_JPRB,1.1224E+01_JPRB,9.4749E+00_JPRB,9.4674E+00_JPRB,9.7176E+00_JPRB/)
KBO( :, 2,21,12) = (/&
&1.4320E+01_JPRB,1.4312E+01_JPRB,1.0993E+01_JPRB,9.2613E+00_JPRB,9.2871E+00_JPRB,9.5392E+00_JPRB/)
KBO( :, 3,21,12) = (/&
&1.4030E+01_JPRB,1.4022E+01_JPRB,1.0770E+01_JPRB,9.0451E+00_JPRB,9.1076E+00_JPRB,9.3604E+00_JPRB/)
KBO( :, 4,21,12) = (/&
&1.3731E+01_JPRB,1.3724E+01_JPRB,1.0538E+01_JPRB,8.8193E+00_JPRB,8.9189E+00_JPRB,9.1661E+00_JPRB/)
KBO( :, 5,21,12) = (/&
&1.3412E+01_JPRB,1.3405E+01_JPRB,1.0288E+01_JPRB,8.5978E+00_JPRB,8.7269E+00_JPRB,8.9634E+00_JPRB/)
KBO( :, 1,22,12) = (/&
&1.3252E+01_JPRB,1.3245E+01_JPRB,1.0263E+01_JPRB,9.6884E+00_JPRB,1.0237E+01_JPRB,1.0659E+01_JPRB/)
KBO( :, 2,22,12) = (/&
&1.2974E+01_JPRB,1.2967E+01_JPRB,1.0045E+01_JPRB,9.4635E+00_JPRB,1.0051E+01_JPRB,1.0470E+01_JPRB/)
KBO( :, 3,22,12) = (/&
&1.2686E+01_JPRB,1.2679E+01_JPRB,9.8204E+00_JPRB,9.2336E+00_JPRB,9.8532E+00_JPRB,1.0276E+01_JPRB/)
KBO( :, 4,22,12) = (/&
&1.2392E+01_JPRB,1.2385E+01_JPRB,9.5853E+00_JPRB,9.0077E+00_JPRB,9.6460E+00_JPRB,1.0057E+01_JPRB/)
KBO( :, 5,22,12) = (/&
&1.2080E+01_JPRB,1.2073E+01_JPRB,9.3373E+00_JPRB,8.7763E+00_JPRB,9.4290E+00_JPRB,9.8257E+00_JPRB/)
KBO( :, 1,23,12) = (/&
&1.1802E+01_JPRB,1.1796E+01_JPRB,9.3955E+00_JPRB,9.9793E+00_JPRB,1.1071E+01_JPRB,1.1590E+01_JPRB/)
KBO( :, 2,23,12) = (/&
&1.1532E+01_JPRB,1.1526E+01_JPRB,9.1740E+00_JPRB,9.7510E+00_JPRB,1.0853E+01_JPRB,1.1387E+01_JPRB/)
KBO( :, 3,23,12) = (/&
&1.1254E+01_JPRB,1.1248E+01_JPRB,8.9457E+00_JPRB,9.5279E+00_JPRB,1.0621E+01_JPRB,1.1176E+01_JPRB/)
KBO( :, 4,23,12) = (/&
&1.0971E+01_JPRB,1.0965E+01_JPRB,8.7049E+00_JPRB,9.2947E+00_JPRB,1.0373E+01_JPRB,1.0939E+01_JPRB/)
KBO( :, 5,23,12) = (/&
&1.0694E+01_JPRB,1.0688E+01_JPRB,8.4691E+00_JPRB,9.0520E+00_JPRB,1.0118E+01_JPRB,1.0692E+01_JPRB/)
KBO( :, 1,24,12) = (/&
&1.0339E+01_JPRB,1.0334E+01_JPRB,8.7416E+00_JPRB,1.0311E+01_JPRB,1.1869E+01_JPRB,1.2496E+01_JPRB/)
KBO( :, 2,24,12) = (/&
&1.0079E+01_JPRB,1.0074E+01_JPRB,8.5118E+00_JPRB,1.0085E+01_JPRB,1.1623E+01_JPRB,1.2266E+01_JPRB/)
KBO( :, 3,24,12) = (/&
&9.8237E+00_JPRB,9.8183E+00_JPRB,8.2739E+00_JPRB,9.8502E+00_JPRB,1.1362E+01_JPRB,1.2041E+01_JPRB/)
KBO( :, 4,24,12) = (/&
&9.5837E+00_JPRB,9.5785E+00_JPRB,8.0352E+00_JPRB,9.6060E+00_JPRB,1.1087E+01_JPRB,1.1795E+01_JPRB/)
KBO( :, 5,24,12) = (/&
&9.4022E+00_JPRB,9.3971E+00_JPRB,7.8130E+00_JPRB,9.3488E+00_JPRB,1.0802E+01_JPRB,1.1530E+01_JPRB/)
KBO( :, 1,25,12) = (/&
&8.9159E+00_JPRB,8.9112E+00_JPRB,8.3253E+00_JPRB,1.0680E+01_JPRB,1.2624E+01_JPRB,1.3349E+01_JPRB/)
KBO( :, 2,25,12) = (/&
&8.6856E+00_JPRB,8.6810E+00_JPRB,8.0901E+00_JPRB,1.0434E+01_JPRB,1.2357E+01_JPRB,1.3117E+01_JPRB/)
KBO( :, 3,25,12) = (/&
&8.4955E+00_JPRB,8.4909E+00_JPRB,7.8520E+00_JPRB,1.0179E+01_JPRB,1.2070E+01_JPRB,1.2889E+01_JPRB/)
KBO( :, 4,25,12) = (/&
&8.3669E+00_JPRB,8.3624E+00_JPRB,7.6206E+00_JPRB,9.9074E+00_JPRB,1.1769E+01_JPRB,1.2627E+01_JPRB/)
KBO( :, 5,25,12) = (/&
&8.2951E+00_JPRB,8.2906E+00_JPRB,7.4263E+00_JPRB,9.6322E+00_JPRB,1.1459E+01_JPRB,1.2339E+01_JPRB/)
KBO( :, 1,26,12) = (/&
&7.5918E+00_JPRB,7.5878E+00_JPRB,8.0448E+00_JPRB,1.1047E+01_JPRB,1.3308E+01_JPRB,1.4181E+01_JPRB/)
KBO( :, 2,26,12) = (/&
&7.4417E+00_JPRB,7.4378E+00_JPRB,7.8118E+00_JPRB,1.0782E+01_JPRB,1.3032E+01_JPRB,1.3946E+01_JPRB/)
KBO( :, 3,26,12) = (/&
&7.3590E+00_JPRB,7.3551E+00_JPRB,7.5780E+00_JPRB,1.0497E+01_JPRB,1.2721E+01_JPRB,1.3696E+01_JPRB/)
KBO( :, 4,26,12) = (/&
&7.3502E+00_JPRB,7.3462E+00_JPRB,7.3714E+00_JPRB,1.0203E+01_JPRB,1.2399E+01_JPRB,1.3409E+01_JPRB/)
KBO( :, 5,26,12) = (/&
&7.4276E+00_JPRB,7.4236E+00_JPRB,7.2173E+00_JPRB,9.8998E+00_JPRB,1.2064E+01_JPRB,1.3105E+01_JPRB/)
KBO( :, 1,27,12) = (/&
&6.4683E+00_JPRB,6.4649E+00_JPRB,7.8812E+00_JPRB,1.1375E+01_JPRB,1.3927E+01_JPRB,1.4966E+01_JPRB/)
KBO( :, 2,27,12) = (/&
&6.4189E+00_JPRB,6.4156E+00_JPRB,7.6472E+00_JPRB,1.1088E+01_JPRB,1.3638E+01_JPRB,1.4716E+01_JPRB/)
KBO( :, 3,27,12) = (/&
&6.4591E+00_JPRB,6.4557E+00_JPRB,7.4245E+00_JPRB,1.0785E+01_JPRB,1.3326E+01_JPRB,1.4451E+01_JPRB/)
KBO( :, 4,27,12) = (/&
&6.5895E+00_JPRB,6.5861E+00_JPRB,7.2540E+00_JPRB,1.0466E+01_JPRB,1.2988E+01_JPRB,1.4141E+01_JPRB/)
KBO( :, 5,27,12) = (/&
&6.7673E+00_JPRB,6.7638E+00_JPRB,7.1253E+00_JPRB,1.0145E+01_JPRB,1.2630E+01_JPRB,1.3805E+01_JPRB/)
KBO( :, 1,28,12) = (/&
&5.5812E+00_JPRB,5.5783E+00_JPRB,7.7689E+00_JPRB,1.1658E+01_JPRB,1.4504E+01_JPRB,1.5676E+01_JPRB/)
KBO( :, 2,28,12) = (/&
&5.6494E+00_JPRB,5.6465E+00_JPRB,7.5324E+00_JPRB,1.1356E+01_JPRB,1.4208E+01_JPRB,1.5420E+01_JPRB/)
KBO( :, 3,28,12) = (/&
&5.8063E+00_JPRB,5.8033E+00_JPRB,7.3350E+00_JPRB,1.1035E+01_JPRB,1.3883E+01_JPRB,1.5136E+01_JPRB/)
KBO( :, 4,28,12) = (/&
&5.9982E+00_JPRB,5.9952E+00_JPRB,7.1895E+00_JPRB,1.0705E+01_JPRB,1.3523E+01_JPRB,1.4796E+01_JPRB/)
KBO( :, 5,28,12) = (/&
&6.2275E+00_JPRB,6.2243E+00_JPRB,7.0847E+00_JPRB,1.0363E+01_JPRB,1.3144E+01_JPRB,1.4440E+01_JPRB/)
KBO( :, 1,29,12) = (/&
&4.9263E+00_JPRB,4.9239E+00_JPRB,7.6738E+00_JPRB,1.1886E+01_JPRB,1.5034E+01_JPRB,1.6303E+01_JPRB/)
KBO( :, 2,29,12) = (/&
&5.0905E+00_JPRB,5.0880E+00_JPRB,7.4511E+00_JPRB,1.1577E+01_JPRB,1.4725E+01_JPRB,1.6056E+01_JPRB/)
KBO( :, 3,29,12) = (/&
&5.2910E+00_JPRB,5.2884E+00_JPRB,7.2824E+00_JPRB,1.1245E+01_JPRB,1.4371E+01_JPRB,1.5737E+01_JPRB/)
KBO( :, 4,29,12) = (/&
&5.5388E+00_JPRB,5.5361E+00_JPRB,7.1566E+00_JPRB,1.0903E+01_JPRB,1.3995E+01_JPRB,1.5373E+01_JPRB/)
KBO( :, 5,29,12) = (/&
&5.8140E+00_JPRB,5.8111E+00_JPRB,7.0642E+00_JPRB,1.0551E+01_JPRB,1.3590E+01_JPRB,1.5023E+01_JPRB/)
KBO( :, 1,30,12) = (/&
&4.4481E+00_JPRB,4.4460E+00_JPRB,7.5927E+00_JPRB,1.2072E+01_JPRB,1.5506E+01_JPRB,1.6872E+01_JPRB/)
KBO( :, 2,30,12) = (/&
&4.6495E+00_JPRB,4.6473E+00_JPRB,7.3991E+00_JPRB,1.1764E+01_JPRB,1.5173E+01_JPRB,1.6609E+01_JPRB/)
KBO( :, 3,30,12) = (/&
&4.9026E+00_JPRB,4.9003E+00_JPRB,7.2499E+00_JPRB,1.1426E+01_JPRB,1.4795E+01_JPRB,1.6261E+01_JPRB/)
KBO( :, 4,30,12) = (/&
&5.1748E+00_JPRB,5.1723E+00_JPRB,7.1402E+00_JPRB,1.1073E+01_JPRB,1.4399E+01_JPRB,1.5886E+01_JPRB/)
KBO( :, 5,30,12) = (/&
&5.4669E+00_JPRB,5.4641E+00_JPRB,7.0513E+00_JPRB,1.0712E+01_JPRB,1.3969E+01_JPRB,1.5546E+01_JPRB/)
KBO( :, 1,31,12) = (/&
&4.0826E+00_JPRB,4.0808E+00_JPRB,7.5248E+00_JPRB,1.2230E+01_JPRB,1.5909E+01_JPRB,1.7372E+01_JPRB/)
KBO( :, 2,31,12) = (/&
&4.3203E+00_JPRB,4.3184E+00_JPRB,7.3583E+00_JPRB,1.1921E+01_JPRB,1.5546E+01_JPRB,1.7073E+01_JPRB/)
KBO( :, 3,31,12) = (/&
&4.5820E+00_JPRB,4.5799E+00_JPRB,7.2311E+00_JPRB,1.1577E+01_JPRB,1.5153E+01_JPRB,1.6713E+01_JPRB/)
KBO( :, 4,31,12) = (/&
&4.8695E+00_JPRB,4.8672E+00_JPRB,7.1286E+00_JPRB,1.1212E+01_JPRB,1.4724E+01_JPRB,1.6381E+01_JPRB/)
KBO( :, 5,31,12) = (/&
&5.1816E+00_JPRB,5.1790E+00_JPRB,7.0469E+00_JPRB,1.0847E+01_JPRB,1.4274E+01_JPRB,1.6048E+01_JPRB/)
KBO( :, 1,32,12) = (/&
&3.7968E+00_JPRB,3.7952E+00_JPRB,7.4739E+00_JPRB,1.2361E+01_JPRB,1.6239E+01_JPRB,1.7800E+01_JPRB/)
KBO( :, 2,32,12) = (/&
&4.0447E+00_JPRB,4.0430E+00_JPRB,7.3338E+00_JPRB,1.2050E+01_JPRB,1.5855E+01_JPRB,1.7484E+01_JPRB/)
KBO( :, 3,32,12) = (/&
&4.3179E+00_JPRB,4.3159E+00_JPRB,7.2183E+00_JPRB,1.1702E+01_JPRB,1.5442E+01_JPRB,1.7161E+01_JPRB/)
KBO( :, 4,32,12) = (/&
&4.6213E+00_JPRB,4.6191E+00_JPRB,7.1240E+00_JPRB,1.1329E+01_JPRB,1.4991E+01_JPRB,1.6858E+01_JPRB/)
KBO( :, 5,32,12) = (/&
&4.9485E+00_JPRB,4.9460E+00_JPRB,7.0483E+00_JPRB,1.0954E+01_JPRB,1.4516E+01_JPRB,1.6491E+01_JPRB/)
KBO( :, 1,33,12) = (/&
&3.5568E+00_JPRB,3.5554E+00_JPRB,7.4337E+00_JPRB,1.2471E+01_JPRB,1.6507E+01_JPRB,1.8167E+01_JPRB/)
KBO( :, 2,33,12) = (/&
&3.8191E+00_JPRB,3.8174E+00_JPRB,7.3162E+00_JPRB,1.2150E+01_JPRB,1.6107E+01_JPRB,1.7878E+01_JPRB/)
KBO( :, 3,33,12) = (/&
&4.1081E+00_JPRB,4.1061E+00_JPRB,7.2154E+00_JPRB,1.1795E+01_JPRB,1.5670E+01_JPRB,1.7617E+01_JPRB/)
KBO( :, 4,33,12) = (/&
&4.4244E+00_JPRB,4.4223E+00_JPRB,7.1305E+00_JPRB,1.1413E+01_JPRB,1.5196E+01_JPRB,1.7282E+01_JPRB/)
KBO( :, 5,33,12) = (/&
&4.7677E+00_JPRB,4.7653E+00_JPRB,7.0542E+00_JPRB,1.1036E+01_JPRB,1.4698E+01_JPRB,1.6888E+01_JPRB/)
KBO( :, 1,34,12) = (/&
&3.3521E+00_JPRB,3.3507E+00_JPRB,7.4128E+00_JPRB,1.2559E+01_JPRB,1.6734E+01_JPRB,1.8506E+01_JPRB/)
KBO( :, 2,34,12) = (/&
&3.6291E+00_JPRB,3.6275E+00_JPRB,7.3128E+00_JPRB,1.2232E+01_JPRB,1.6317E+01_JPRB,1.8280E+01_JPRB/)
KBO( :, 3,34,12) = (/&
&3.9317E+00_JPRB,3.9298E+00_JPRB,7.2212E+00_JPRB,1.1872E+01_JPRB,1.5854E+01_JPRB,1.8005E+01_JPRB/)
KBO( :, 4,34,12) = (/&
&4.2593E+00_JPRB,4.2572E+00_JPRB,7.1423E+00_JPRB,1.1481E+01_JPRB,1.5360E+01_JPRB,1.7643E+01_JPRB/)
KBO( :, 5,34,12) = (/&
&4.6153E+00_JPRB,4.6130E+00_JPRB,7.0650E+00_JPRB,1.1105E+01_JPRB,1.4842E+01_JPRB,1.7226E+01_JPRB/)
KBO( :, 1,35,12) = (/&
&3.1598E+00_JPRB,3.1585E+00_JPRB,7.4142E+00_JPRB,1.2657E+01_JPRB,1.6945E+01_JPRB,1.8872E+01_JPRB/)
KBO( :, 2,35,12) = (/&
&3.4442E+00_JPRB,3.4427E+00_JPRB,7.3257E+00_JPRB,1.2327E+01_JPRB,1.6516E+01_JPRB,1.8673E+01_JPRB/)
KBO( :, 3,35,12) = (/&
&3.7587E+00_JPRB,3.7569E+00_JPRB,7.2409E+00_JPRB,1.1960E+01_JPRB,1.6036E+01_JPRB,1.8373E+01_JPRB/)
KBO( :, 4,35,12) = (/&
&4.0964E+00_JPRB,4.0944E+00_JPRB,7.1633E+00_JPRB,1.1567E+01_JPRB,1.5526E+01_JPRB,1.7979E+01_JPRB/)
KBO( :, 5,35,12) = (/&
&4.4686E+00_JPRB,4.4663E+00_JPRB,7.0860E+00_JPRB,1.1190E+01_JPRB,1.4992E+01_JPRB,1.7544E+01_JPRB/)
KBO( :, 1,36,12) = (/&
&2.9654E+00_JPRB,2.9641E+00_JPRB,7.4313E+00_JPRB,1.2766E+01_JPRB,1.7160E+01_JPRB,1.9227E+01_JPRB/)
KBO( :, 2,36,12) = (/&
&3.2570E+00_JPRB,3.2555E+00_JPRB,7.3495E+00_JPRB,1.2436E+01_JPRB,1.6723E+01_JPRB,1.9033E+01_JPRB/)
KBO( :, 3,36,12) = (/&
&3.5797E+00_JPRB,3.5780E+00_JPRB,7.2711E+00_JPRB,1.2069E+01_JPRB,1.6233E+01_JPRB,1.8715E+01_JPRB/)
KBO( :, 4,36,12) = (/&
&3.9316E+00_JPRB,3.9297E+00_JPRB,7.1919E+00_JPRB,1.1675E+01_JPRB,1.5711E+01_JPRB,1.8314E+01_JPRB/)
KBO( :, 5,36,12) = (/&
&4.3127E+00_JPRB,4.3105E+00_JPRB,7.1101E+00_JPRB,1.1293E+01_JPRB,1.5166E+01_JPRB,1.7865E+01_JPRB/)
KBO( :, 1,37,12) = (/&
&2.7533E+00_JPRB,2.7522E+00_JPRB,7.4577E+00_JPRB,1.2906E+01_JPRB,1.7405E+01_JPRB,1.9546E+01_JPRB/)
KBO( :, 2,37,12) = (/&
&3.0486E+00_JPRB,3.0472E+00_JPRB,7.3839E+00_JPRB,1.2582E+01_JPRB,1.6967E+01_JPRB,1.9367E+01_JPRB/)
KBO( :, 3,37,12) = (/&
&3.3772E+00_JPRB,3.3756E+00_JPRB,7.3093E+00_JPRB,1.2218E+01_JPRB,1.6476E+01_JPRB,1.9050E+01_JPRB/)
KBO( :, 4,37,12) = (/&
&3.7381E+00_JPRB,3.7362E+00_JPRB,7.2303E+00_JPRB,1.1826E+01_JPRB,1.5946E+01_JPRB,1.8659E+01_JPRB/)
KBO( :, 5,37,12) = (/&
&4.1246E+00_JPRB,4.1225E+00_JPRB,7.1455E+00_JPRB,1.1440E+01_JPRB,1.5395E+01_JPRB,1.8212E+01_JPRB/)
KBO( :, 1,38,12) = (/&
&2.5620E+00_JPRB,2.5610E+00_JPRB,7.4808E+00_JPRB,1.3030E+01_JPRB,1.7619E+01_JPRB,1.9841E+01_JPRB/)
KBO( :, 2,38,12) = (/&
&2.8608E+00_JPRB,2.8595E+00_JPRB,7.4174E+00_JPRB,1.2714E+01_JPRB,1.7188E+01_JPRB,1.9683E+01_JPRB/)
KBO( :, 3,38,12) = (/&
&3.1956E+00_JPRB,3.1942E+00_JPRB,7.3440E+00_JPRB,1.2353E+01_JPRB,1.6696E+01_JPRB,1.9369E+01_JPRB/)
KBO( :, 4,38,12) = (/&
&3.5649E+00_JPRB,3.5631E+00_JPRB,7.2670E+00_JPRB,1.1965E+01_JPRB,1.6163E+01_JPRB,1.8994E+01_JPRB/)
KBO( :, 5,38,12) = (/&
&3.9585E+00_JPRB,3.9565E+00_JPRB,7.1817E+00_JPRB,1.1573E+01_JPRB,1.5604E+01_JPRB,1.8550E+01_JPRB/)
KBO( :, 1,39,12) = (/&
&2.3896E+00_JPRB,2.3887E+00_JPRB,7.5031E+00_JPRB,1.3145E+01_JPRB,1.7806E+01_JPRB,2.0123E+01_JPRB/)
KBO( :, 2,39,12) = (/&
&2.6949E+00_JPRB,2.6937E+00_JPRB,7.4455E+00_JPRB,1.2830E+01_JPRB,1.7380E+01_JPRB,1.9979E+01_JPRB/)
KBO( :, 3,39,12) = (/&
&3.0362E+00_JPRB,3.0348E+00_JPRB,7.3756E+00_JPRB,1.2474E+01_JPRB,1.6890E+01_JPRB,1.9683E+01_JPRB/)
KBO( :, 4,39,12) = (/&
&3.4116E+00_JPRB,3.4099E+00_JPRB,7.3010E+00_JPRB,1.2089E+01_JPRB,1.6357E+01_JPRB,1.9331E+01_JPRB/)
KBO( :, 5,39,12) = (/&
&3.8125E+00_JPRB,3.8105E+00_JPRB,7.2161E+00_JPRB,1.1695E+01_JPRB,1.5793E+01_JPRB,1.8893E+01_JPRB/)
KBO( :, 1,40,12) = (/&
&2.2084E+00_JPRB,2.2076E+00_JPRB,7.5257E+00_JPRB,1.3272E+01_JPRB,1.8011E+01_JPRB,2.0327E+01_JPRB/)
KBO( :, 2,40,12) = (/&
&2.5142E+00_JPRB,2.5132E+00_JPRB,7.4776E+00_JPRB,1.2969E+01_JPRB,1.7599E+01_JPRB,2.0223E+01_JPRB/)
KBO( :, 3,40,12) = (/&
&2.8571E+00_JPRB,2.8558E+00_JPRB,7.4104E+00_JPRB,1.2622E+01_JPRB,1.7115E+01_JPRB,1.9951E+01_JPRB/)
KBO( :, 4,40,12) = (/&
&3.2355E+00_JPRB,3.2339E+00_JPRB,7.3412E+00_JPRB,1.2241E+01_JPRB,1.6586E+01_JPRB,1.9625E+01_JPRB/)
KBO( :, 5,40,12) = (/&
&3.6402E+00_JPRB,3.6383E+00_JPRB,7.2559E+00_JPRB,1.1846E+01_JPRB,1.6023E+01_JPRB,1.9193E+01_JPRB/)
KBO( :, 1,41,12) = (/&
&2.0392E+00_JPRB,2.0384E+00_JPRB,7.5497E+00_JPRB,1.3388E+01_JPRB,1.8196E+01_JPRB,2.0499E+01_JPRB/)
KBO( :, 2,41,12) = (/&
&2.3453E+00_JPRB,2.3444E+00_JPRB,7.5055E+00_JPRB,1.3103E+01_JPRB,1.7800E+01_JPRB,2.0441E+01_JPRB/)
KBO( :, 3,41,12) = (/&
&2.6889E+00_JPRB,2.6876E+00_JPRB,7.4442E+00_JPRB,1.2764E+01_JPRB,1.7330E+01_JPRB,2.0201E+01_JPRB/)
KBO( :, 4,41,12) = (/&
&3.0674E+00_JPRB,3.0659E+00_JPRB,7.3773E+00_JPRB,1.2388E+01_JPRB,1.6806E+01_JPRB,1.9901E+01_JPRB/)
KBO( :, 5,41,12) = (/&
&3.4739E+00_JPRB,3.4722E+00_JPRB,7.2932E+00_JPRB,1.1996E+01_JPRB,1.6248E+01_JPRB,1.9478E+01_JPRB/)
KBO( :, 1,42,12) = (/&
&1.8842E+00_JPRB,1.8835E+00_JPRB,7.5738E+00_JPRB,1.3492E+01_JPRB,1.8356E+01_JPRB,2.0651E+01_JPRB/)
KBO( :, 2,42,12) = (/&
&2.1916E+00_JPRB,2.1907E+00_JPRB,7.5284E+00_JPRB,1.3224E+01_JPRB,1.7982E+01_JPRB,2.0639E+01_JPRB/)
KBO( :, 3,42,12) = (/&
&2.5344E+00_JPRB,2.5332E+00_JPRB,7.4756E+00_JPRB,1.2895E+01_JPRB,1.7528E+01_JPRB,2.0438E+01_JPRB/)
KBO( :, 4,42,12) = (/&
&2.9115E+00_JPRB,2.9101E+00_JPRB,7.4107E+00_JPRB,1.2526E+01_JPRB,1.7014E+01_JPRB,2.0170E+01_JPRB/)
KBO( :, 5,42,12) = (/&
&3.3176E+00_JPRB,3.3160E+00_JPRB,7.3300E+00_JPRB,1.2138E+01_JPRB,1.6460E+01_JPRB,1.9759E+01_JPRB/)
KBO( :, 1,43,12) = (/&
&1.7267E+00_JPRB,1.7260E+00_JPRB,7.5950E+00_JPRB,1.3597E+01_JPRB,1.8513E+01_JPRB,2.0770E+01_JPRB/)
KBO( :, 2,43,12) = (/&
&2.0318E+00_JPRB,2.0310E+00_JPRB,7.5508E+00_JPRB,1.3350E+01_JPRB,1.8172E+01_JPRB,2.0815E+01_JPRB/)
KBO( :, 3,43,12) = (/&
&2.3711E+00_JPRB,2.3700E+00_JPRB,7.5067E+00_JPRB,1.3037E+01_JPRB,1.7739E+01_JPRB,2.0667E+01_JPRB/)
KBO( :, 4,43,12) = (/&
&2.7430E+00_JPRB,2.7417E+00_JPRB,7.4433E+00_JPRB,1.2679E+01_JPRB,1.7236E+01_JPRB,2.0434E+01_JPRB/)
KBO( :, 5,43,12) = (/&
&3.1470E+00_JPRB,3.1454E+00_JPRB,7.3686E+00_JPRB,1.2292E+01_JPRB,1.6691E+01_JPRB,2.0048E+01_JPRB/)
KBO( :, 1,44,12) = (/&
&1.5761E+00_JPRB,1.5756E+00_JPRB,7.6126E+00_JPRB,1.3691E+01_JPRB,1.8648E+01_JPRB,2.0862E+01_JPRB/)
KBO( :, 2,44,12) = (/&
&1.8753E+00_JPRB,1.8746E+00_JPRB,7.5725E+00_JPRB,1.3468E+01_JPRB,1.8351E+01_JPRB,2.0968E+01_JPRB/)
KBO( :, 3,44,12) = (/&
&2.2096E+00_JPRB,2.2086E+00_JPRB,7.5342E+00_JPRB,1.3177E+01_JPRB,1.7945E+01_JPRB,2.0887E+01_JPRB/)
KBO( :, 4,44,12) = (/&
&2.5754E+00_JPRB,2.5742E+00_JPRB,7.4767E+00_JPRB,1.2832E+01_JPRB,1.7460E+01_JPRB,2.0692E+01_JPRB/)
KBO( :, 5,44,12) = (/&
&2.9738E+00_JPRB,2.9723E+00_JPRB,7.4066E+00_JPRB,1.2450E+01_JPRB,1.6925E+01_JPRB,2.0342E+01_JPRB/)
KBO( :, 1,45,12) = (/&
&1.4392E+00_JPRB,1.4387E+00_JPRB,7.6289E+00_JPRB,1.3769E+01_JPRB,1.8760E+01_JPRB,2.0935E+01_JPRB/)
KBO( :, 2,45,12) = (/&
&1.7286E+00_JPRB,1.7279E+00_JPRB,7.5921E+00_JPRB,1.3574E+01_JPRB,1.8509E+01_JPRB,2.1105E+01_JPRB/)
KBO( :, 3,45,12) = (/&
&2.0581E+00_JPRB,2.0572E+00_JPRB,7.5558E+00_JPRB,1.3307E+01_JPRB,1.8131E+01_JPRB,2.1101E+01_JPRB/)
KBO( :, 4,45,12) = (/&
&2.4180E+00_JPRB,2.4169E+00_JPRB,7.5062E+00_JPRB,1.2976E+01_JPRB,1.7672E+01_JPRB,2.0953E+01_JPRB/)
KBO( :, 5,45,12) = (/&
&2.8084E+00_JPRB,2.8070E+00_JPRB,7.4420E+00_JPRB,1.2604E+01_JPRB,1.7149E+01_JPRB,2.0640E+01_JPRB/)
KBO( :, 1,46,12) = (/&
&1.3097E+00_JPRB,1.3093E+00_JPRB,7.6423E+00_JPRB,1.3829E+01_JPRB,1.8849E+01_JPRB,2.0974E+01_JPRB/)
KBO( :, 2,46,12) = (/&
&1.5854E+00_JPRB,1.5848E+00_JPRB,7.6098E+00_JPRB,1.3672E+01_JPRB,1.8651E+01_JPRB,2.1212E+01_JPRB/)
KBO( :, 3,46,12) = (/&
&1.9071E+00_JPRB,1.9063E+00_JPRB,7.5745E+00_JPRB,1.3430E+01_JPRB,1.8314E+01_JPRB,2.1300E+01_JPRB/)
KBO( :, 4,46,12) = (/&
&2.2598E+00_JPRB,2.2588E+00_JPRB,7.5350E+00_JPRB,1.3119E+01_JPRB,1.7880E+01_JPRB,2.1201E+01_JPRB/)
KBO( :, 5,46,12) = (/&
&2.6412E+00_JPRB,2.6399E+00_JPRB,7.4731E+00_JPRB,1.2761E+01_JPRB,1.7374E+01_JPRB,2.0932E+01_JPRB/)
KBO( :, 1,47,12) = (/&
&1.1830E+00_JPRB,1.1826E+00_JPRB,7.6481E+00_JPRB,1.3869E+01_JPRB,1.8908E+01_JPRB,2.0951E+01_JPRB/)
KBO( :, 2,47,12) = (/&
&1.4407E+00_JPRB,1.4402E+00_JPRB,7.6261E+00_JPRB,1.3765E+01_JPRB,1.8775E+01_JPRB,2.1251E+01_JPRB/)
KBO( :, 3,47,12) = (/&
&1.7493E+00_JPRB,1.7485E+00_JPRB,7.5928E+00_JPRB,1.3553E+01_JPRB,1.8492E+01_JPRB,2.1457E+01_JPRB/)
KBO( :, 4,47,12) = (/&
&2.0941E+00_JPRB,2.0931E+00_JPRB,7.5591E+00_JPRB,1.3267E+01_JPRB,1.8091E+01_JPRB,2.1416E+01_JPRB/)
KBO( :, 5,47,12) = (/&
&2.4666E+00_JPRB,2.4654E+00_JPRB,7.5056E+00_JPRB,1.2925E+01_JPRB,1.7610E+01_JPRB,2.1209E+01_JPRB/)
KBO( :, 1,48,12) = (/&
&1.0695E+00_JPRB,1.0692E+00_JPRB,7.6498E+00_JPRB,1.3881E+01_JPRB,1.8927E+01_JPRB,2.0896E+01_JPRB/)
KBO( :, 2,48,12) = (/&
&1.3081E+00_JPRB,1.3076E+00_JPRB,7.6404E+00_JPRB,1.3836E+01_JPRB,1.8873E+01_JPRB,2.1276E+01_JPRB/)
KBO( :, 3,48,12) = (/&
&1.6006E+00_JPRB,1.5999E+00_JPRB,7.6097E+00_JPRB,1.3659E+01_JPRB,1.8647E+01_JPRB,2.1600E+01_JPRB/)
KBO( :, 4,48,12) = (/&
&1.9354E+00_JPRB,1.9345E+00_JPRB,7.5773E+00_JPRB,1.3403E+01_JPRB,1.8286E+01_JPRB,2.1634E+01_JPRB/)
KBO( :, 5,48,12) = (/&
&2.2984E+00_JPRB,2.2973E+00_JPRB,7.5353E+00_JPRB,1.3082E+01_JPRB,1.7836E+01_JPRB,2.1486E+01_JPRB/)
KBO( :, 1,49,12) = (/&
&9.6483E-01_JPRB,9.6464E-01_JPRB,7.6392E+00_JPRB,1.3864E+01_JPRB,1.8901E+01_JPRB,2.0809E+01_JPRB/)
KBO( :, 2,49,12) = (/&
&1.1880E+00_JPRB,1.1876E+00_JPRB,7.6494E+00_JPRB,1.3882E+01_JPRB,1.8939E+01_JPRB,2.1303E+01_JPRB/)
KBO( :, 3,49,12) = (/&
&1.4610E+00_JPRB,1.4604E+00_JPRB,7.6246E+00_JPRB,1.3753E+01_JPRB,1.8773E+01_JPRB,2.1746E+01_JPRB/)
KBO( :, 4,49,12) = (/&
&1.7825E+00_JPRB,1.7817E+00_JPRB,7.5952E+00_JPRB,1.3527E+01_JPRB,1.8464E+01_JPRB,2.1864E+01_JPRB/)
KBO( :, 5,49,12) = (/&
&2.1366E+00_JPRB,2.1357E+00_JPRB,7.5591E+00_JPRB,1.3229E+01_JPRB,1.8046E+01_JPRB,2.1779E+01_JPRB/)
KBO( :, 1,50,12) = (/&
&8.7334E-01_JPRB,8.7321E-01_JPRB,7.6167E+00_JPRB,1.3816E+01_JPRB,1.8840E+01_JPRB,2.0653E+01_JPRB/)
KBO( :, 2,50,12) = (/&
&1.0849E+00_JPRB,1.0846E+00_JPRB,7.6499E+00_JPRB,1.3902E+01_JPRB,1.8966E+01_JPRB,2.1256E+01_JPRB/)
KBO( :, 3,50,12) = (/&
&1.3397E+00_JPRB,1.3393E+00_JPRB,7.6369E+00_JPRB,1.3826E+01_JPRB,1.8870E+01_JPRB,2.1793E+01_JPRB/)
KBO( :, 4,50,12) = (/&
&1.6451E+00_JPRB,1.6444E+00_JPRB,7.6078E+00_JPRB,1.3629E+01_JPRB,1.8612E+01_JPRB,2.2015E+01_JPRB/)
KBO( :, 5,50,12) = (/&
&1.9901E+00_JPRB,1.9893E+00_JPRB,7.5766E+00_JPRB,1.3357E+01_JPRB,1.8227E+01_JPRB,2.2000E+01_JPRB/)
KBO( :, 1,51,12) = (/&
&7.9109E-01_JPRB,7.9101E-01_JPRB,7.5808E+00_JPRB,1.3738E+01_JPRB,1.8738E+01_JPRB,2.0437E+01_JPRB/)
KBO( :, 2,51,12) = (/&
&9.9151E-01_JPRB,9.9125E-01_JPRB,7.6471E+00_JPRB,1.3897E+01_JPRB,1.8959E+01_JPRB,2.1160E+01_JPRB/)
KBO( :, 3,51,12) = (/&
&1.2299E+00_JPRB,1.2295E+00_JPRB,7.6471E+00_JPRB,1.3876E+01_JPRB,1.8940E+01_JPRB,2.1766E+01_JPRB/)
KBO( :, 4,51,12) = (/&
&1.5182E+00_JPRB,1.5176E+00_JPRB,7.6211E+00_JPRB,1.3717E+01_JPRB,1.8736E+01_JPRB,2.2115E+01_JPRB/)
KBO( :, 5,51,12) = (/&
&1.8518E+00_JPRB,1.8510E+00_JPRB,7.5920E+00_JPRB,1.3472E+01_JPRB,1.8393E+01_JPRB,2.2169E+01_JPRB/)
KBO( :, 1,52,12) = (/&
&7.1584E-01_JPRB,7.1581E-01_JPRB,7.5315E+00_JPRB,1.3629E+01_JPRB,1.8592E+01_JPRB,2.0184E+01_JPRB/)
KBO( :, 2,52,12) = (/&
&9.0437E-01_JPRB,9.0419E-01_JPRB,7.6323E+00_JPRB,1.3867E+01_JPRB,1.8918E+01_JPRB,2.1052E+01_JPRB/)
KBO( :, 3,52,12) = (/&
&1.1294E+00_JPRB,1.1290E+00_JPRB,7.6500E+00_JPRB,1.3907E+01_JPRB,1.8982E+01_JPRB,2.1738E+01_JPRB/)
KBO( :, 4,52,12) = (/&
&1.3999E+00_JPRB,1.3994E+00_JPRB,7.6316E+00_JPRB,1.3795E+01_JPRB,1.8838E+01_JPRB,2.2212E+01_JPRB/)
KBO( :, 5,52,12) = (/&
&1.7187E+00_JPRB,1.7179E+00_JPRB,7.6040E+00_JPRB,1.3576E+01_JPRB,1.8542E+01_JPRB,2.2347E+01_JPRB/)
KBO( :, 1,53,12) = (/&
&6.4519E-01_JPRB,6.4525E-01_JPRB,7.4665E+00_JPRB,1.3494E+01_JPRB,1.8401E+01_JPRB,1.9906E+01_JPRB/)
KBO( :, 2,53,12) = (/&
&8.2291E-01_JPRB,8.2276E-01_JPRB,7.6064E+00_JPRB,1.3809E+01_JPRB,1.8841E+01_JPRB,2.0928E+01_JPRB/)
KBO( :, 3,53,12) = (/&
&1.0366E+00_JPRB,1.0363E+00_JPRB,7.6500E+00_JPRB,1.3915E+01_JPRB,1.8993E+01_JPRB,2.1723E+01_JPRB/)
KBO( :, 4,53,12) = (/&
&1.2893E+00_JPRB,1.2888E+00_JPRB,7.6422E+00_JPRB,1.3856E+01_JPRB,1.8918E+01_JPRB,2.2328E+01_JPRB/)
KBO( :, 5,53,12) = (/&
&1.5912E+00_JPRB,1.5905E+00_JPRB,7.6165E+00_JPRB,1.3669E+01_JPRB,1.8674E+01_JPRB,2.2548E+01_JPRB/)
KBO( :, 1,54,12) = (/&
&5.8435E-01_JPRB,5.8444E-01_JPRB,7.3907E+00_JPRB,1.3327E+01_JPRB,1.8178E+01_JPRB,1.9515E+01_JPRB/)
KBO( :, 2,54,12) = (/&
&7.5368E-01_JPRB,7.5356E-01_JPRB,7.5705E+00_JPRB,1.3729E+01_JPRB,1.8734E+01_JPRB,2.0634E+01_JPRB/)
KBO( :, 3,54,12) = (/&
&9.5607E-01_JPRB,9.5580E-01_JPRB,7.6449E+00_JPRB,1.3905E+01_JPRB,1.8977E+01_JPRB,2.1497E+01_JPRB/)
KBO( :, 4,54,12) = (/&
&1.1937E+00_JPRB,1.1933E+00_JPRB,7.6499E+00_JPRB,1.3896E+01_JPRB,1.8973E+01_JPRB,2.2212E+01_JPRB/)
KBO( :, 5,54,12) = (/&
&1.4797E+00_JPRB,1.4791E+00_JPRB,7.6261E+00_JPRB,1.3745E+01_JPRB,1.8779E+01_JPRB,2.2527E+01_JPRB/)
KBO( :, 1,55,12) = (/&
&5.2854E-01_JPRB,5.2867E-01_JPRB,7.3044E+00_JPRB,1.3131E+01_JPRB,1.7924E+01_JPRB,1.9047E+01_JPRB/)
KBO( :, 2,55,12) = (/&
&6.9118E-01_JPRB,6.9109E-01_JPRB,7.5254E+00_JPRB,1.3628E+01_JPRB,1.8597E+01_JPRB,2.0249E+01_JPRB/)
KBO( :, 3,55,12) = (/&
&8.8293E-01_JPRB,8.8272E-01_JPRB,7.6307E+00_JPRB,1.3873E+01_JPRB,1.8933E+01_JPRB,2.1158E+01_JPRB/)
KBO( :, 4,55,12) = (/&
&1.1091E+00_JPRB,1.1087E+00_JPRB,7.6507E+00_JPRB,1.3919E+01_JPRB,1.9002E+01_JPRB,2.1900E+01_JPRB/)
KBO( :, 5,55,12) = (/&
&1.3791E+00_JPRB,1.3786E+00_JPRB,7.6348E+00_JPRB,1.3810E+01_JPRB,1.8863E+01_JPRB,2.2367E+01_JPRB/)
KBO( :, 1,56,12) = (/&
&4.7560E-01_JPRB,4.7583E-01_JPRB,7.2007E+00_JPRB,1.2908E+01_JPRB,1.7624E+01_JPRB,1.8559E+01_JPRB/)
KBO( :, 2,56,12) = (/&
&6.3205E-01_JPRB,6.3206E-01_JPRB,7.4679E+00_JPRB,1.3507E+01_JPRB,1.8426E+01_JPRB,1.9860E+01_JPRB/)
KBO( :, 3,56,12) = (/&
&8.1360E-01_JPRB,8.1344E-01_JPRB,7.6074E+00_JPRB,1.3821E+01_JPRB,1.8863E+01_JPRB,2.0825E+01_JPRB/)
KBO( :, 4,56,12) = (/&
&1.0301E+00_JPRB,1.0298E+00_JPRB,7.6506E+00_JPRB,1.3924E+01_JPRB,1.9011E+01_JPRB,2.1557E+01_JPRB/)
KBO( :, 5,56,12) = (/&
&1.2841E+00_JPRB,1.2836E+00_JPRB,7.6437E+00_JPRB,1.3864E+01_JPRB,1.8933E+01_JPRB,2.2162E+01_JPRB/)
KBO( :, 1,57,12) = (/&
&4.2603E-01_JPRB,4.2637E-01_JPRB,7.0800E+00_JPRB,1.2651E+01_JPRB,1.7279E+01_JPRB,1.8044E+01_JPRB/)
KBO( :, 2,57,12) = (/&
&5.7620E-01_JPRB,5.7623E-01_JPRB,7.3960E+00_JPRB,1.3349E+01_JPRB,1.8215E+01_JPRB,1.9448E+01_JPRB/)
KBO( :, 3,57,12) = (/&
&7.4950E-01_JPRB,7.4937E-01_JPRB,7.5736E+00_JPRB,1.3745E+01_JPRB,1.8761E+01_JPRB,2.0480E+01_JPRB/)
KBO( :, 4,57,12) = (/&
&9.5476E-01_JPRB,9.5448E-01_JPRB,7.6455E+00_JPRB,1.3913E+01_JPRB,1.8993E+01_JPRB,2.1239E+01_JPRB/)
KBO( :, 5,57,12) = (/&
&1.1947E+00_JPRB,1.1943E+00_JPRB,7.6507E+00_JPRB,1.3900E+01_JPRB,1.8982E+01_JPRB,2.1879E+01_JPRB/)
KBO( :, 1,58,12) = (/&
&3.8222E-01_JPRB,3.8258E-01_JPRB,6.9487E+00_JPRB,1.2376E+01_JPRB,1.6911E+01_JPRB,1.7525E+01_JPRB/)
KBO( :, 2,58,12) = (/&
&5.2528E-01_JPRB,5.2538E-01_JPRB,7.3177E+00_JPRB,1.3169E+01_JPRB,1.7977E+01_JPRB,1.9013E+01_JPRB/)
KBO( :, 3,58,12) = (/&
&6.9186E-01_JPRB,6.9176E-01_JPRB,7.5326E+00_JPRB,1.3651E+01_JPRB,1.8633E+01_JPRB,2.0139E+01_JPRB/)
KBO( :, 4,58,12) = (/&
&8.8662E-01_JPRB,8.8639E-01_JPRB,7.6334E+00_JPRB,1.3885E+01_JPRB,1.8953E+01_JPRB,2.0942E+01_JPRB/)
KBO( :, 5,58,12) = (/&
&1.1152E+00_JPRB,1.1149E+00_JPRB,7.6513E+00_JPRB,1.3923E+01_JPRB,1.9012E+01_JPRB,2.1525E+01_JPRB/)
KBO( :, 1,59,12) = (/&
&3.6401E-01_JPRB,3.6437E-01_JPRB,6.8886E+00_JPRB,1.2256E+01_JPRB,1.6751E+01_JPRB,1.7277E+01_JPRB/)
KBO( :, 2,59,12) = (/&
&5.0412E-01_JPRB,5.0423E-01_JPRB,7.2807E+00_JPRB,1.3088E+01_JPRB,1.7871E+01_JPRB,1.8767E+01_JPRB/)
KBO( :, 3,59,12) = (/&
&6.6841E-01_JPRB,6.6833E-01_JPRB,7.5138E+00_JPRB,1.3610E+01_JPRB,1.8575E+01_JPRB,1.9865E+01_JPRB/)
KBO( :, 4,59,12) = (/&
&8.5925E-01_JPRB,8.5905E-01_JPRB,7.6263E+00_JPRB,1.3870E+01_JPRB,1.8932E+01_JPRB,2.0637E+01_JPRB/)
KBO( :, 5,59,12) = (/&
&1.0843E+00_JPRB,1.0840E+00_JPRB,7.6509E+00_JPRB,1.3928E+01_JPRB,1.9019E+01_JPRB,2.1126E+01_JPRB/)
KBO( :, 1,13,13) = (/&
&2.1392E+01_JPRB,2.1380E+01_JPRB,1.6377E+01_JPRB,1.1373E+01_JPRB,6.6382E+00_JPRB,5.4072E+00_JPRB/)
KBO( :, 2,13,13) = (/&
&2.0984E+01_JPRB,2.0973E+01_JPRB,1.6065E+01_JPRB,1.1155E+01_JPRB,6.4809E+00_JPRB,5.2816E+00_JPRB/)
KBO( :, 3,13,13) = (/&
&2.0571E+01_JPRB,2.0560E+01_JPRB,1.5742E+01_JPRB,1.0918E+01_JPRB,6.3142E+00_JPRB,5.1399E+00_JPRB/)
KBO( :, 4,13,13) = (/&
&2.0116E+01_JPRB,2.0104E+01_JPRB,1.5385E+01_JPRB,1.0661E+01_JPRB,6.1353E+00_JPRB,5.0342E+00_JPRB/)
KBO( :, 5,13,13) = (/&
&1.9665E+01_JPRB,1.9654E+01_JPRB,1.5041E+01_JPRB,1.0410E+01_JPRB,5.9659E+00_JPRB,5.1046E+00_JPRB/)
KBO( :, 1,14,13) = (/&
&2.2611E+01_JPRB,2.2598E+01_JPRB,1.7286E+01_JPRB,1.1979E+01_JPRB,6.9848E+00_JPRB,5.8003E+00_JPRB/)
KBO( :, 2,14,13) = (/&
&2.2235E+01_JPRB,2.2222E+01_JPRB,1.6999E+01_JPRB,1.1763E+01_JPRB,6.8307E+00_JPRB,5.6143E+00_JPRB/)
KBO( :, 3,14,13) = (/&
&2.1845E+01_JPRB,2.1832E+01_JPRB,1.6684E+01_JPRB,1.1532E+01_JPRB,6.6725E+00_JPRB,5.4768E+00_JPRB/)
KBO( :, 4,14,13) = (/&
&2.1455E+01_JPRB,2.1442E+01_JPRB,1.6377E+01_JPRB,1.1313E+01_JPRB,6.5206E+00_JPRB,5.3624E+00_JPRB/)
KBO( :, 5,14,13) = (/&
&2.1081E+01_JPRB,2.1069E+01_JPRB,1.6078E+01_JPRB,1.1090E+01_JPRB,6.3823E+00_JPRB,5.2307E+00_JPRB/)
KBO( :, 1,15,13) = (/&
&2.4085E+01_JPRB,2.4071E+01_JPRB,1.8394E+01_JPRB,1.2709E+01_JPRB,7.4960E+00_JPRB,6.3317E+00_JPRB/)
KBO( :, 2,15,13) = (/&
&2.3744E+01_JPRB,2.3731E+01_JPRB,1.8118E+01_JPRB,1.2499E+01_JPRB,7.3422E+00_JPRB,6.1431E+00_JPRB/)
KBO( :, 3,15,13) = (/&
&2.3384E+01_JPRB,2.3371E+01_JPRB,1.7836E+01_JPRB,1.2301E+01_JPRB,7.1895E+00_JPRB,5.9905E+00_JPRB/)
KBO( :, 4,15,13) = (/&
&2.3079E+01_JPRB,2.3065E+01_JPRB,1.7598E+01_JPRB,1.2125E+01_JPRB,7.0485E+00_JPRB,5.8455E+00_JPRB/)
KBO( :, 5,15,13) = (/&
&2.2790E+01_JPRB,2.2777E+01_JPRB,1.7354E+01_JPRB,1.1938E+01_JPRB,6.8999E+00_JPRB,5.7410E+00_JPRB/)
KBO( :, 1,16,13) = (/&
&2.5695E+01_JPRB,2.5680E+01_JPRB,1.9581E+01_JPRB,1.3479E+01_JPRB,8.1349E+00_JPRB,7.0625E+00_JPRB/)
KBO( :, 2,16,13) = (/&
&2.5421E+01_JPRB,2.5406E+01_JPRB,1.9374E+01_JPRB,1.3336E+01_JPRB,7.9760E+00_JPRB,6.8886E+00_JPRB/)
KBO( :, 3,16,13) = (/&
&2.5170E+01_JPRB,2.5155E+01_JPRB,1.9169E+01_JPRB,1.3185E+01_JPRB,7.8208E+00_JPRB,6.7331E+00_JPRB/)
KBO( :, 4,16,13) = (/&
&2.4917E+01_JPRB,2.4902E+01_JPRB,1.8958E+01_JPRB,1.3021E+01_JPRB,7.6613E+00_JPRB,6.5695E+00_JPRB/)
KBO( :, 5,16,13) = (/&
&2.4671E+01_JPRB,2.4656E+01_JPRB,1.8755E+01_JPRB,1.2857E+01_JPRB,7.5038E+00_JPRB,6.4414E+00_JPRB/)
KBO( :, 1,17,13) = (/&
&2.7485E+01_JPRB,2.7469E+01_JPRB,2.0920E+01_JPRB,1.4359E+01_JPRB,8.8403E+00_JPRB,7.9625E+00_JPRB/)
KBO( :, 2,17,13) = (/&
&2.7261E+01_JPRB,2.7245E+01_JPRB,2.0734E+01_JPRB,1.4221E+01_JPRB,8.6752E+00_JPRB,7.7696E+00_JPRB/)
KBO( :, 3,17,13) = (/&
&2.7019E+01_JPRB,2.7003E+01_JPRB,2.0538E+01_JPRB,1.4067E+01_JPRB,8.5095E+00_JPRB,7.5869E+00_JPRB/)
KBO( :, 4,17,13) = (/&
&2.6774E+01_JPRB,2.6758E+01_JPRB,2.0340E+01_JPRB,1.3916E+01_JPRB,8.3433E+00_JPRB,7.4093E+00_JPRB/)
KBO( :, 5,17,13) = (/&
&2.6489E+01_JPRB,2.6473E+01_JPRB,2.0113E+01_JPRB,1.3747E+01_JPRB,8.1757E+00_JPRB,7.2580E+00_JPRB/)
KBO( :, 1,18,13) = (/&
&2.9073E+01_JPRB,2.9056E+01_JPRB,2.2090E+01_JPRB,1.5130E+01_JPRB,9.6108E+00_JPRB,8.9667E+00_JPRB/)
KBO( :, 2,18,13) = (/&
&2.8847E+01_JPRB,2.8830E+01_JPRB,2.1906E+01_JPRB,1.4984E+01_JPRB,9.4415E+00_JPRB,8.7341E+00_JPRB/)
KBO( :, 3,18,13) = (/&
&2.8614E+01_JPRB,2.8597E+01_JPRB,2.1721E+01_JPRB,1.4840E+01_JPRB,9.2727E+00_JPRB,8.5308E+00_JPRB/)
KBO( :, 4,18,13) = (/&
&2.8333E+01_JPRB,2.8317E+01_JPRB,2.1498E+01_JPRB,1.4677E+01_JPRB,9.0956E+00_JPRB,8.3322E+00_JPRB/)
KBO( :, 5,18,13) = (/&
&2.8019E+01_JPRB,2.8003E+01_JPRB,2.1254E+01_JPRB,1.4499E+01_JPRB,8.9142E+00_JPRB,8.1468E+00_JPRB/)
KBO( :, 1,19,13) = (/&
&3.0315E+01_JPRB,3.0297E+01_JPRB,2.3006E+01_JPRB,1.5724E+01_JPRB,1.0512E+01_JPRB,1.0019E+01_JPRB/)
KBO( :, 2,19,13) = (/&
&3.0061E+01_JPRB,3.0044E+01_JPRB,2.2808E+01_JPRB,1.5577E+01_JPRB,1.0342E+01_JPRB,9.7644E+00_JPRB/)
KBO( :, 3,19,13) = (/&
&2.9787E+01_JPRB,2.9769E+01_JPRB,2.2595E+01_JPRB,1.5419E+01_JPRB,1.0163E+01_JPRB,9.5327E+00_JPRB/)
KBO( :, 4,19,13) = (/&
&2.9464E+01_JPRB,2.9447E+01_JPRB,2.2343E+01_JPRB,1.5239E+01_JPRB,9.9795E+00_JPRB,9.3290E+00_JPRB/)
KBO( :, 5,19,13) = (/&
&2.9104E+01_JPRB,2.9087E+01_JPRB,2.2065E+01_JPRB,1.5039E+01_JPRB,9.7881E+00_JPRB,9.1292E+00_JPRB/)
KBO( :, 1,20,13) = (/&
&3.1036E+01_JPRB,3.1018E+01_JPRB,2.3548E+01_JPRB,1.6113E+01_JPRB,1.1579E+01_JPRB,1.1154E+01_JPRB/)
KBO( :, 2,20,13) = (/&
&3.0755E+01_JPRB,3.0737E+01_JPRB,2.3334E+01_JPRB,1.5957E+01_JPRB,1.1393E+01_JPRB,1.0893E+01_JPRB/)
KBO( :, 3,20,13) = (/&
&3.0452E+01_JPRB,3.0434E+01_JPRB,2.3095E+01_JPRB,1.5780E+01_JPRB,1.1192E+01_JPRB,1.0651E+01_JPRB/)
KBO( :, 4,20,13) = (/&
&3.0086E+01_JPRB,3.0068E+01_JPRB,2.2811E+01_JPRB,1.5577E+01_JPRB,1.0976E+01_JPRB,1.0441E+01_JPRB/)
KBO( :, 5,20,13) = (/&
&2.9696E+01_JPRB,2.9679E+01_JPRB,2.2510E+01_JPRB,1.5363E+01_JPRB,1.0748E+01_JPRB,1.0213E+01_JPRB/)
KBO( :, 1,21,13) = (/&
&3.1144E+01_JPRB,3.1126E+01_JPRB,2.3635E+01_JPRB,1.6360E+01_JPRB,1.2781E+01_JPRB,1.2415E+01_JPRB/)
KBO( :, 2,21,13) = (/&
&3.0844E+01_JPRB,3.0826E+01_JPRB,2.3403E+01_JPRB,1.6172E+01_JPRB,1.2549E+01_JPRB,1.2147E+01_JPRB/)
KBO( :, 3,21,13) = (/&
&3.0498E+01_JPRB,3.0480E+01_JPRB,2.3133E+01_JPRB,1.5960E+01_JPRB,1.2302E+01_JPRB,1.1885E+01_JPRB/)
KBO( :, 4,21,13) = (/&
&3.0111E+01_JPRB,3.0093E+01_JPRB,2.2836E+01_JPRB,1.5742E+01_JPRB,1.2041E+01_JPRB,1.1642E+01_JPRB/)
KBO( :, 5,21,13) = (/&
&2.9700E+01_JPRB,2.9683E+01_JPRB,2.2517E+01_JPRB,1.5496E+01_JPRB,1.1766E+01_JPRB,1.1381E+01_JPRB/)
KBO( :, 1,22,13) = (/&
&3.0579E+01_JPRB,3.0561E+01_JPRB,2.3219E+01_JPRB,1.6510E+01_JPRB,1.4016E+01_JPRB,1.3791E+01_JPRB/)
KBO( :, 2,22,13) = (/&
&3.0252E+01_JPRB,3.0234E+01_JPRB,2.2968E+01_JPRB,1.6283E+01_JPRB,1.3741E+01_JPRB,1.3488E+01_JPRB/)
KBO( :, 3,22,13) = (/&
&2.9906E+01_JPRB,2.9889E+01_JPRB,2.2700E+01_JPRB,1.6051E+01_JPRB,1.3445E+01_JPRB,1.3187E+01_JPRB/)
KBO( :, 4,22,13) = (/&
&2.9523E+01_JPRB,2.9506E+01_JPRB,2.2405E+01_JPRB,1.5794E+01_JPRB,1.3135E+01_JPRB,1.2905E+01_JPRB/)
KBO( :, 5,22,13) = (/&
&2.9116E+01_JPRB,2.9100E+01_JPRB,2.2090E+01_JPRB,1.5521E+01_JPRB,1.2819E+01_JPRB,1.2597E+01_JPRB/)
KBO( :, 1,23,13) = (/&
&2.9397E+01_JPRB,2.9380E+01_JPRB,2.2345E+01_JPRB,1.6640E+01_JPRB,1.5241E+01_JPRB,1.5271E+01_JPRB/)
KBO( :, 2,23,13) = (/&
&2.9096E+01_JPRB,2.9079E+01_JPRB,2.2113E+01_JPRB,1.6382E+01_JPRB,1.4921E+01_JPRB,1.4908E+01_JPRB/)
KBO( :, 3,23,13) = (/&
&2.8759E+01_JPRB,2.8742E+01_JPRB,2.1850E+01_JPRB,1.6098E+01_JPRB,1.4591E+01_JPRB,1.4553E+01_JPRB/)
KBO( :, 4,23,13) = (/&
&2.8405E+01_JPRB,2.8388E+01_JPRB,2.1576E+01_JPRB,1.5810E+01_JPRB,1.4244E+01_JPRB,1.4213E+01_JPRB/)
KBO( :, 5,23,13) = (/&
&2.8010E+01_JPRB,2.7994E+01_JPRB,2.1268E+01_JPRB,1.5508E+01_JPRB,1.3883E+01_JPRB,1.3842E+01_JPRB/)
KBO( :, 1,24,13) = (/&
&2.7736E+01_JPRB,2.7720E+01_JPRB,2.1114E+01_JPRB,1.6904E+01_JPRB,1.6493E+01_JPRB,1.6795E+01_JPRB/)
KBO( :, 2,24,13) = (/&
&2.7462E+01_JPRB,2.7446E+01_JPRB,2.0900E+01_JPRB,1.6582E+01_JPRB,1.6130E+01_JPRB,1.6394E+01_JPRB/)
KBO( :, 3,24,13) = (/&
&2.7151E+01_JPRB,2.7136E+01_JPRB,2.0660E+01_JPRB,1.6247E+01_JPRB,1.5745E+01_JPRB,1.5974E+01_JPRB/)
KBO( :, 4,24,13) = (/&
&2.6831E+01_JPRB,2.6816E+01_JPRB,2.0409E+01_JPRB,1.5908E+01_JPRB,1.5345E+01_JPRB,1.5569E+01_JPRB/)
KBO( :, 5,24,13) = (/&
&2.6459E+01_JPRB,2.6444E+01_JPRB,2.0122E+01_JPRB,1.5560E+01_JPRB,1.4934E+01_JPRB,1.5132E+01_JPRB/)
KBO( :, 1,25,13) = (/&
&2.5741E+01_JPRB,2.5726E+01_JPRB,1.9691E+01_JPRB,1.7263E+01_JPRB,1.7747E+01_JPRB,1.8359E+01_JPRB/)
KBO( :, 2,25,13) = (/&
&2.5497E+01_JPRB,2.5482E+01_JPRB,1.9486E+01_JPRB,1.6895E+01_JPRB,1.7326E+01_JPRB,1.7886E+01_JPRB/)
KBO( :, 3,25,13) = (/&
&2.5241E+01_JPRB,2.5227E+01_JPRB,1.9275E+01_JPRB,1.6517E+01_JPRB,1.6889E+01_JPRB,1.7399E+01_JPRB/)
KBO( :, 4,25,13) = (/&
&2.4941E+01_JPRB,2.4927E+01_JPRB,1.9033E+01_JPRB,1.6125E+01_JPRB,1.6436E+01_JPRB,1.6925E+01_JPRB/)
KBO( :, 5,25,13) = (/&
&2.4625E+01_JPRB,2.4611E+01_JPRB,1.8780E+01_JPRB,1.5723E+01_JPRB,1.5971E+01_JPRB,1.6420E+01_JPRB/)
KBO( :, 1,26,13) = (/&
&2.3543E+01_JPRB,2.3530E+01_JPRB,1.8282E+01_JPRB,1.7640E+01_JPRB,1.9000E+01_JPRB,1.9879E+01_JPRB/)
KBO( :, 2,26,13) = (/&
&2.3344E+01_JPRB,2.3330E+01_JPRB,1.8083E+01_JPRB,1.7232E+01_JPRB,1.8508E+01_JPRB,1.9336E+01_JPRB/)
KBO( :, 3,26,13) = (/&
&2.3131E+01_JPRB,2.3118E+01_JPRB,1.7881E+01_JPRB,1.6809E+01_JPRB,1.8012E+01_JPRB,1.8780E+01_JPRB/)
KBO( :, 4,26,13) = (/&
&2.2891E+01_JPRB,2.2878E+01_JPRB,1.7660E+01_JPRB,1.6381E+01_JPRB,1.7496E+01_JPRB,1.8235E+01_JPRB/)
KBO( :, 5,26,13) = (/&
&2.2635E+01_JPRB,2.2623E+01_JPRB,1.7424E+01_JPRB,1.5941E+01_JPRB,1.6965E+01_JPRB,1.7649E+01_JPRB/)
KBO( :, 1,27,13) = (/&
&2.1263E+01_JPRB,2.1251E+01_JPRB,1.6999E+01_JPRB,1.8073E+01_JPRB,2.0218E+01_JPRB,2.1326E+01_JPRB/)
KBO( :, 2,27,13) = (/&
&2.1130E+01_JPRB,2.1118E+01_JPRB,1.6805E+01_JPRB,1.7603E+01_JPRB,1.9655E+01_JPRB,2.0714E+01_JPRB/)
KBO( :, 3,27,13) = (/&
&2.0964E+01_JPRB,2.0953E+01_JPRB,1.6591E+01_JPRB,1.7141E+01_JPRB,1.9068E+01_JPRB,2.0084E+01_JPRB/)
KBO( :, 4,27,13) = (/&
&2.0811E+01_JPRB,2.0800E+01_JPRB,1.6383E+01_JPRB,1.6665E+01_JPRB,1.8477E+01_JPRB,1.9460E+01_JPRB/)
KBO( :, 5,27,13) = (/&
&2.0671E+01_JPRB,2.0659E+01_JPRB,1.6163E+01_JPRB,1.6182E+01_JPRB,1.7875E+01_JPRB,1.8801E+01_JPRB/)
KBO( :, 1,28,13) = (/&
&1.9006E+01_JPRB,1.8995E+01_JPRB,1.5933E+01_JPRB,1.8511E+01_JPRB,2.1355E+01_JPRB,2.2683E+01_JPRB/)
KBO( :, 2,28,13) = (/&
&1.8934E+01_JPRB,1.8923E+01_JPRB,1.5716E+01_JPRB,1.8009E+01_JPRB,2.0708E+01_JPRB,2.1993E+01_JPRB/)
KBO( :, 3,28,13) = (/&
&1.8875E+01_JPRB,1.8864E+01_JPRB,1.5505E+01_JPRB,1.7487E+01_JPRB,2.0041E+01_JPRB,2.1291E+01_JPRB/)
KBO( :, 4,28,13) = (/&
&1.8867E+01_JPRB,1.8856E+01_JPRB,1.5292E+01_JPRB,1.6969E+01_JPRB,1.9370E+01_JPRB,2.0578E+01_JPRB/)
KBO( :, 5,28,13) = (/&
&1.8926E+01_JPRB,1.8916E+01_JPRB,1.5114E+01_JPRB,1.6444E+01_JPRB,1.8700E+01_JPRB,1.9834E+01_JPRB/)
KBO( :, 1,29,13) = (/&
&1.6866E+01_JPRB,1.6856E+01_JPRB,1.5090E+01_JPRB,1.8932E+01_JPRB,2.2378E+01_JPRB,2.3900E+01_JPRB/)
KBO( :, 2,29,13) = (/&
&1.6895E+01_JPRB,1.6885E+01_JPRB,1.4848E+01_JPRB,1.8394E+01_JPRB,2.1642E+01_JPRB,2.3131E+01_JPRB/)
KBO( :, 3,29,13) = (/&
&1.7005E+01_JPRB,1.6996E+01_JPRB,1.4617E+01_JPRB,1.7836E+01_JPRB,2.0899E+01_JPRB,2.2368E+01_JPRB/)
KBO( :, 4,29,13) = (/&
&1.7186E+01_JPRB,1.7177E+01_JPRB,1.4419E+01_JPRB,1.7274E+01_JPRB,2.0148E+01_JPRB,2.1559E+01_JPRB/)
KBO( :, 5,29,13) = (/&
&1.7419E+01_JPRB,1.7409E+01_JPRB,1.4291E+01_JPRB,1.6708E+01_JPRB,1.9414E+01_JPRB,2.0739E+01_JPRB/)
KBO( :, 1,30,13) = (/&
&1.4953E+01_JPRB,1.4945E+01_JPRB,1.4448E+01_JPRB,1.9321E+01_JPRB,2.3266E+01_JPRB,2.4961E+01_JPRB/)
KBO( :, 2,30,13) = (/&
&1.5147E+01_JPRB,1.5138E+01_JPRB,1.4172E+01_JPRB,1.8728E+01_JPRB,2.2451E+01_JPRB,2.4136E+01_JPRB/)
KBO( :, 3,30,13) = (/&
&1.5423E+01_JPRB,1.5415E+01_JPRB,1.3932E+01_JPRB,1.8138E+01_JPRB,2.1636E+01_JPRB,2.3296E+01_JPRB/)
KBO( :, 4,30,13) = (/&
&1.5783E+01_JPRB,1.5774E+01_JPRB,1.3754E+01_JPRB,1.7532E+01_JPRB,2.0815E+01_JPRB,2.2402E+01_JPRB/)
KBO( :, 5,30,13) = (/&
&1.6221E+01_JPRB,1.6212E+01_JPRB,1.3682E+01_JPRB,1.6932E+01_JPRB,2.0014E+01_JPRB,2.1530E+01_JPRB/)
KBO( :, 1,31,13) = (/&
&1.3343E+01_JPRB,1.3335E+01_JPRB,1.3979E+01_JPRB,1.9651E+01_JPRB,2.4006E+01_JPRB,2.5869E+01_JPRB/)
KBO( :, 2,31,13) = (/&
&1.3698E+01_JPRB,1.3690E+01_JPRB,1.3675E+01_JPRB,1.9009E+01_JPRB,2.3133E+01_JPRB,2.5002E+01_JPRB/)
KBO( :, 3,31,13) = (/&
&1.4163E+01_JPRB,1.4155E+01_JPRB,1.3429E+01_JPRB,1.8375E+01_JPRB,2.2243E+01_JPRB,2.4068E+01_JPRB/)
KBO( :, 4,31,13) = (/&
&1.4712E+01_JPRB,1.4703E+01_JPRB,1.3295E+01_JPRB,1.7748E+01_JPRB,2.1362E+01_JPRB,2.3103E+01_JPRB/)
KBO( :, 5,31,13) = (/&
&1.5311E+01_JPRB,1.5303E+01_JPRB,1.3250E+01_JPRB,1.7114E+01_JPRB,2.0500E+01_JPRB,2.2261E+01_JPRB/)
KBO( :, 1,32,13) = (/&
&1.2052E+01_JPRB,1.2045E+01_JPRB,1.3628E+01_JPRB,1.9911E+01_JPRB,2.4618E+01_JPRB,2.6646E+01_JPRB/)
KBO( :, 2,32,13) = (/&
&1.2587E+01_JPRB,1.2580E+01_JPRB,1.3324E+01_JPRB,1.9233E+01_JPRB,2.3679E+01_JPRB,2.5689E+01_JPRB/)
KBO( :, 3,32,13) = (/&
&1.3218E+01_JPRB,1.3210E+01_JPRB,1.3094E+01_JPRB,1.8557E+01_JPRB,2.2722E+01_JPRB,2.4678E+01_JPRB/)
KBO( :, 4,32,13) = (/&
&1.3914E+01_JPRB,1.3907E+01_JPRB,1.2978E+01_JPRB,1.7906E+01_JPRB,2.1782E+01_JPRB,2.3743E+01_JPRB/)
KBO( :, 5,32,13) = (/&
&1.4655E+01_JPRB,1.4646E+01_JPRB,1.2957E+01_JPRB,1.7249E+01_JPRB,2.0874E+01_JPRB,2.2925E+01_JPRB/)
KBO( :, 1,33,13) = (/&
&1.1069E+01_JPRB,1.1063E+01_JPRB,1.3365E+01_JPRB,2.0106E+01_JPRB,2.5097E+01_JPRB,2.7267E+01_JPRB/)
KBO( :, 2,33,13) = (/&
&1.1756E+01_JPRB,1.1750E+01_JPRB,1.3070E+01_JPRB,1.9396E+01_JPRB,2.4095E+01_JPRB,2.6242E+01_JPRB/)
KBO( :, 3,33,13) = (/&
&1.2532E+01_JPRB,1.2525E+01_JPRB,1.2868E+01_JPRB,1.8687E+01_JPRB,2.3087E+01_JPRB,2.5240E+01_JPRB/)
KBO( :, 4,33,13) = (/&
&1.3360E+01_JPRB,1.3352E+01_JPRB,1.2765E+01_JPRB,1.8010E+01_JPRB,2.2099E+01_JPRB,2.4405E+01_JPRB/)
KBO( :, 5,33,13) = (/&
&1.4221E+01_JPRB,1.4213E+01_JPRB,1.2776E+01_JPRB,1.7337E+01_JPRB,2.1144E+01_JPRB,2.3571E+01_JPRB/)
KBO( :, 1,34,13) = (/&
&1.0330E+01_JPRB,1.0325E+01_JPRB,1.3170E+01_JPRB,2.0275E+01_JPRB,2.5492E+01_JPRB,2.7791E+01_JPRB/)
KBO( :, 2,34,13) = (/&
&1.1144E+01_JPRB,1.1137E+01_JPRB,1.2897E+01_JPRB,1.9532E+01_JPRB,2.4430E+01_JPRB,2.6740E+01_JPRB/)
KBO( :, 3,34,13) = (/&
&1.2039E+01_JPRB,1.2032E+01_JPRB,1.2723E+01_JPRB,1.8800E+01_JPRB,2.3383E+01_JPRB,2.5842E+01_JPRB/)
KBO( :, 4,34,13) = (/&
&1.2978E+01_JPRB,1.2971E+01_JPRB,1.2635E+01_JPRB,1.8099E+01_JPRB,2.2352E+01_JPRB,2.4982E+01_JPRB/)
KBO( :, 5,34,13) = (/&
&1.3934E+01_JPRB,1.3926E+01_JPRB,1.2668E+01_JPRB,1.7413E+01_JPRB,2.1361E+01_JPRB,2.4094E+01_JPRB/)
KBO( :, 1,35,13) = (/&
&9.7254E+00_JPRB,9.7201E+00_JPRB,1.3055E+01_JPRB,2.0467E+01_JPRB,2.5890E+01_JPRB,2.8316E+01_JPRB/)
KBO( :, 2,35,13) = (/&
&1.0642E+01_JPRB,1.0636E+01_JPRB,1.2799E+01_JPRB,1.9691E+01_JPRB,2.4776E+01_JPRB,2.7321E+01_JPRB/)
KBO( :, 3,35,13) = (/&
&1.1630E+01_JPRB,1.1624E+01_JPRB,1.2635E+01_JPRB,1.8939E+01_JPRB,2.3691E+01_JPRB,2.6463E+01_JPRB/)
KBO( :, 4,35,13) = (/&
&1.2660E+01_JPRB,1.2653E+01_JPRB,1.2560E+01_JPRB,1.8216E+01_JPRB,2.2621E+01_JPRB,2.5557E+01_JPRB/)
KBO( :, 5,35,13) = (/&
&1.3686E+01_JPRB,1.3678E+01_JPRB,1.2601E+01_JPRB,1.7514E+01_JPRB,2.1598E+01_JPRB,2.4647E+01_JPRB/)
KBO( :, 1,36,13) = (/&
&9.1824E+00_JPRB,9.1775E+00_JPRB,1.3014E+01_JPRB,2.0702E+01_JPRB,2.6319E+01_JPRB,2.8897E+01_JPRB/)
KBO( :, 2,36,13) = (/&
&1.0178E+01_JPRB,1.0173E+01_JPRB,1.2753E+01_JPRB,1.9897E+01_JPRB,2.5164E+01_JPRB,2.7977E+01_JPRB/)
KBO( :, 3,36,13) = (/&
&1.1240E+01_JPRB,1.1234E+01_JPRB,1.2589E+01_JPRB,1.9121E+01_JPRB,2.4043E+01_JPRB,2.7098E+01_JPRB/)
KBO( :, 4,36,13) = (/&
&1.2332E+01_JPRB,1.2325E+01_JPRB,1.2520E+01_JPRB,1.8377E+01_JPRB,2.2938E+01_JPRB,2.6162E+01_JPRB/)
KBO( :, 5,36,13) = (/&
&1.3423E+01_JPRB,1.3415E+01_JPRB,1.2563E+01_JPRB,1.7662E+01_JPRB,2.1883E+01_JPRB,2.5220E+01_JPRB/)
KBO( :, 1,37,13) = (/&
&8.6099E+00_JPRB,8.6053E+00_JPRB,1.3043E+01_JPRB,2.1019E+01_JPRB,2.6856E+01_JPRB,2.9568E+01_JPRB/)
KBO( :, 2,37,13) = (/&
&9.6546E+00_JPRB,9.6493E+00_JPRB,1.2762E+01_JPRB,2.0197E+01_JPRB,2.5667E+01_JPRB,2.8665E+01_JPRB/)
KBO( :, 3,37,13) = (/&
&1.0769E+01_JPRB,1.0763E+01_JPRB,1.2583E+01_JPRB,1.9394E+01_JPRB,2.4509E+01_JPRB,2.7775E+01_JPRB/)
KBO( :, 4,37,13) = (/&
&1.1910E+01_JPRB,1.1903E+01_JPRB,1.2502E+01_JPRB,1.8624E+01_JPRB,2.3371E+01_JPRB,2.6796E+01_JPRB/)
KBO( :, 5,37,13) = (/&
&1.3054E+01_JPRB,1.3047E+01_JPRB,1.2531E+01_JPRB,1.7890E+01_JPRB,2.2279E+01_JPRB,2.5830E+01_JPRB/)
KBO( :, 1,38,13) = (/&
&8.1124E+00_JPRB,8.1081E+00_JPRB,1.3090E+01_JPRB,2.1323E+01_JPRB,2.7354E+01_JPRB,3.0221E+01_JPRB/)
KBO( :, 2,38,13) = (/&
&9.1955E+00_JPRB,9.1905E+00_JPRB,1.2789E+01_JPRB,2.0480E+01_JPRB,2.6132E+01_JPRB,2.9338E+01_JPRB/)
KBO( :, 3,38,13) = (/&
&1.0346E+01_JPRB,1.0340E+01_JPRB,1.2594E+01_JPRB,1.9657E+01_JPRB,2.4940E+01_JPRB,2.8430E+01_JPRB/)
KBO( :, 4,38,13) = (/&
&1.1526E+01_JPRB,1.1520E+01_JPRB,1.2499E+01_JPRB,1.8864E+01_JPRB,2.3774E+01_JPRB,2.7417E+01_JPRB/)
KBO( :, 5,38,13) = (/&
&1.2710E+01_JPRB,1.2703E+01_JPRB,1.2513E+01_JPRB,1.8110E+01_JPRB,2.2651E+01_JPRB,2.6428E+01_JPRB/)
KBO( :, 1,39,13) = (/&
&7.6875E+00_JPRB,7.6835E+00_JPRB,1.3146E+01_JPRB,2.1600E+01_JPRB,2.7801E+01_JPRB,3.0872E+01_JPRB/)
KBO( :, 2,39,13) = (/&
&8.7929E+00_JPRB,8.7882E+00_JPRB,1.2830E+01_JPRB,2.0739E+01_JPRB,2.6556E+01_JPRB,3.0007E+01_JPRB/)
KBO( :, 3,39,13) = (/&
&9.9744E+00_JPRB,9.9689E+00_JPRB,1.2617E+01_JPRB,1.9901E+01_JPRB,2.5334E+01_JPRB,2.9071E+01_JPRB/)
KBO( :, 4,39,13) = (/&
&1.1184E+01_JPRB,1.1178E+01_JPRB,1.2503E+01_JPRB,1.9085E+01_JPRB,2.4144E+01_JPRB,2.8025E+01_JPRB/)
KBO( :, 5,39,13) = (/&
&1.2397E+01_JPRB,1.2390E+01_JPRB,1.2501E+01_JPRB,1.8314E+01_JPRB,2.2991E+01_JPRB,2.7022E+01_JPRB/)
KBO( :, 1,40,13) = (/&
&7.2073E+00_JPRB,7.2036E+00_JPRB,1.3244E+01_JPRB,2.1941E+01_JPRB,2.8335E+01_JPRB,3.1477E+01_JPRB/)
KBO( :, 2,40,13) = (/&
&8.3183E+00_JPRB,8.3138E+00_JPRB,1.2905E+01_JPRB,2.1071E+01_JPRB,2.7076E+01_JPRB,3.0598E+01_JPRB/)
KBO( :, 3,40,13) = (/&
&9.5140E+00_JPRB,9.5088E+00_JPRB,1.2663E+01_JPRB,2.0213E+01_JPRB,2.5823E+01_JPRB,2.9671E+01_JPRB/)
KBO( :, 4,40,13) = (/&
&1.0744E+01_JPRB,1.0738E+01_JPRB,1.2520E+01_JPRB,1.9377E+01_JPRB,2.4607E+01_JPRB,2.8610E+01_JPRB/)
KBO( :, 5,40,13) = (/&
&1.1983E+01_JPRB,1.1976E+01_JPRB,1.2493E+01_JPRB,1.8588E+01_JPRB,2.3425E+01_JPRB,2.7600E+01_JPRB/)
KBO( :, 1,41,13) = (/&
&6.7611E+00_JPRB,6.7576E+00_JPRB,1.3349E+01_JPRB,2.2280E+01_JPRB,2.8859E+01_JPRB,3.2049E+01_JPRB/)
KBO( :, 2,41,13) = (/&
&7.8674E+00_JPRB,7.8632E+00_JPRB,1.2993E+01_JPRB,2.1395E+01_JPRB,2.7586E+01_JPRB,3.1155E+01_JPRB/)
KBO( :, 3,41,13) = (/&
&9.0665E+00_JPRB,9.0616E+00_JPRB,1.2725E+01_JPRB,2.0522E+01_JPRB,2.6310E+01_JPRB,3.0246E+01_JPRB/)
KBO( :, 4,41,13) = (/&
&1.0311E+01_JPRB,1.0306E+01_JPRB,1.2549E+01_JPRB,1.9674E+01_JPRB,2.5066E+01_JPRB,2.9176E+01_JPRB/)
KBO( :, 5,41,13) = (/&
&1.1568E+01_JPRB,1.1562E+01_JPRB,1.2494E+01_JPRB,1.8859E+01_JPRB,2.3856E+01_JPRB,2.8161E+01_JPRB/)
KBO( :, 1,42,13) = (/&
&6.3548E+00_JPRB,6.3515E+00_JPRB,1.3456E+01_JPRB,2.2608E+01_JPRB,2.9366E+01_JPRB,3.2606E+01_JPRB/)
KBO( :, 2,42,13) = (/&
&7.4451E+00_JPRB,7.4412E+00_JPRB,1.3085E+01_JPRB,2.1711E+01_JPRB,2.8070E+01_JPRB,3.1692E+01_JPRB/)
KBO( :, 3,42,13) = (/&
&8.6411E+00_JPRB,8.6364E+00_JPRB,1.2793E+01_JPRB,2.0822E+01_JPRB,2.6779E+01_JPRB,3.0806E+01_JPRB/)
KBO( :, 4,42,13) = (/&
&9.8929E+00_JPRB,9.8874E+00_JPRB,1.2589E+01_JPRB,1.9962E+01_JPRB,2.5511E+01_JPRB,2.9730E+01_JPRB/)
KBO( :, 5,42,13) = (/&
&1.1166E+01_JPRB,1.1160E+01_JPRB,1.2501E+01_JPRB,1.9127E+01_JPRB,2.4277E+01_JPRB,2.8718E+01_JPRB/)
KBO( :, 1,43,13) = (/&
&5.9236E+00_JPRB,5.9206E+00_JPRB,1.3597E+01_JPRB,2.2980E+01_JPRB,2.9923E+01_JPRB,3.3179E+01_JPRB/)
KBO( :, 2,43,13) = (/&
&6.9885E+00_JPRB,6.9848E+00_JPRB,1.3206E+01_JPRB,2.2070E+01_JPRB,2.8607E+01_JPRB,3.2249E+01_JPRB/)
KBO( :, 3,43,13) = (/&
&8.1682E+00_JPRB,8.1638E+00_JPRB,1.2880E+01_JPRB,2.1165E+01_JPRB,2.7304E+01_JPRB,3.1388E+01_JPRB/)
KBO( :, 4,43,13) = (/&
&9.4211E+00_JPRB,9.4159E+00_JPRB,1.2650E+01_JPRB,2.0290E+01_JPRB,2.6012E+01_JPRB,3.0330E+01_JPRB/)
KBO( :, 5,43,13) = (/&
&1.0699E+01_JPRB,1.0693E+01_JPRB,1.2520E+01_JPRB,1.9438E+01_JPRB,2.4759E+01_JPRB,2.9317E+01_JPRB/)
KBO( :, 1,44,13) = (/&
&5.4998E+00_JPRB,5.4970E+00_JPRB,1.3748E+01_JPRB,2.3364E+01_JPRB,3.0492E+01_JPRB,3.3756E+01_JPRB/)
KBO( :, 2,44,13) = (/&
&6.5311E+00_JPRB,6.5277E+00_JPRB,1.3340E+01_JPRB,2.2442E+01_JPRB,2.9167E+01_JPRB,3.2820E+01_JPRB/)
KBO( :, 3,44,13) = (/&
&7.6857E+00_JPRB,7.6816E+00_JPRB,1.2985E+01_JPRB,2.1531E+01_JPRB,2.7848E+01_JPRB,3.1979E+01_JPRB/)
KBO( :, 4,44,13) = (/&
&8.9256E+00_JPRB,8.9207E+00_JPRB,1.2724E+01_JPRB,2.0635E+01_JPRB,2.6540E+01_JPRB,3.0955E+01_JPRB/)
KBO( :, 5,44,13) = (/&
&1.0209E+01_JPRB,1.0203E+01_JPRB,1.2556E+01_JPRB,1.9768E+01_JPRB,2.5264E+01_JPRB,2.9937E+01_JPRB/)
KBO( :, 1,45,13) = (/&
&5.1066E+00_JPRB,5.1040E+00_JPRB,1.3894E+01_JPRB,2.3735E+01_JPRB,3.1041E+01_JPRB,3.4324E+01_JPRB/)
KBO( :, 2,45,13) = (/&
&6.1015E+00_JPRB,6.0983E+00_JPRB,1.3484E+01_JPRB,2.2813E+01_JPRB,2.9715E+01_JPRB,3.3401E+01_JPRB/)
KBO( :, 3,45,13) = (/&
&7.2220E+00_JPRB,7.2182E+00_JPRB,1.3105E+01_JPRB,2.1889E+01_JPRB,2.8383E+01_JPRB,3.2574E+01_JPRB/)
KBO( :, 4,45,13) = (/&
&8.4438E+00_JPRB,8.4392E+00_JPRB,1.2807E+01_JPRB,2.0975E+01_JPRB,2.7061E+01_JPRB,3.1594E+01_JPRB/)
KBO( :, 5,45,13) = (/&
&9.7243E+00_JPRB,9.7189E+00_JPRB,1.2602E+01_JPRB,2.0098E+01_JPRB,2.5763E+01_JPRB,3.0584E+01_JPRB/)
KBO( :, 1,46,13) = (/&
&4.7235E+00_JPRB,4.7212E+00_JPRB,1.4046E+01_JPRB,2.4121E+01_JPRB,3.1588E+01_JPRB,3.4885E+01_JPRB/)
KBO( :, 2,46,13) = (/&
&5.6742E+00_JPRB,5.6713E+00_JPRB,1.3640E+01_JPRB,2.3201E+01_JPRB,3.0277E+01_JPRB,3.3993E+01_JPRB/)
KBO( :, 3,46,13) = (/&
&6.7562E+00_JPRB,6.7526E+00_JPRB,1.3243E+01_JPRB,2.2266E+01_JPRB,2.8936E+01_JPRB,3.3171E+01_JPRB/)
KBO( :, 4,46,13) = (/&
&7.9500E+00_JPRB,7.9457E+00_JPRB,1.2906E+01_JPRB,2.1341E+01_JPRB,2.7604E+01_JPRB,3.2255E+01_JPRB/)
KBO( :, 5,46,13) = (/&
&9.2204E+00_JPRB,9.2153E+00_JPRB,1.2671E+01_JPRB,2.0448E+01_JPRB,2.6287E+01_JPRB,3.1265E+01_JPRB/)
KBO( :, 1,47,13) = (/&
&4.3300E+00_JPRB,4.3280E+00_JPRB,1.4218E+01_JPRB,2.4532E+01_JPRB,3.2164E+01_JPRB,3.5437E+01_JPRB/)
KBO( :, 2,47,13) = (/&
&5.2306E+00_JPRB,5.2279E+00_JPRB,1.3812E+01_JPRB,2.3616E+01_JPRB,3.0887E+01_JPRB,3.4582E+01_JPRB/)
KBO( :, 3,47,13) = (/&
&6.2646E+00_JPRB,6.2614E+00_JPRB,1.3402E+01_JPRB,2.2678E+01_JPRB,2.9542E+01_JPRB,3.3739E+01_JPRB/)
KBO( :, 4,47,13) = (/&
&7.4192E+00_JPRB,7.4152E+00_JPRB,1.3037E+01_JPRB,2.1748E+01_JPRB,2.8196E+01_JPRB,3.2920E+01_JPRB/)
KBO( :, 5,47,13) = (/&
&8.6683E+00_JPRB,8.6636E+00_JPRB,1.2760E+01_JPRB,2.0830E+01_JPRB,2.6867E+01_JPRB,3.1949E+01_JPRB/)
KBO( :, 1,48,13) = (/&
&3.9563E+00_JPRB,3.9545E+00_JPRB,1.4390E+01_JPRB,2.4924E+01_JPRB,3.2712E+01_JPRB,3.5975E+01_JPRB/)
KBO( :, 2,48,13) = (/&
&4.8163E+00_JPRB,4.8139E+00_JPRB,1.3982E+01_JPRB,2.4022E+01_JPRB,3.1475E+01_JPRB,3.5176E+01_JPRB/)
KBO( :, 3,48,13) = (/&
&5.7995E+00_JPRB,5.7966E+00_JPRB,1.3571E+01_JPRB,2.3093E+01_JPRB,3.0140E+01_JPRB,3.4333E+01_JPRB/)
KBO( :, 4,48,13) = (/&
&6.9101E+00_JPRB,6.9064E+00_JPRB,1.3183E+01_JPRB,2.2151E+01_JPRB,2.8787E+01_JPRB,3.3609E+01_JPRB/)
KBO( :, 5,48,13) = (/&
&8.1290E+00_JPRB,8.1246E+00_JPRB,1.2862E+01_JPRB,2.1218E+01_JPRB,2.7446E+01_JPRB,3.2685E+01_JPRB/)
KBO( :, 1,49,13) = (/&
&3.6095E+00_JPRB,3.6078E+00_JPRB,1.4558E+01_JPRB,2.5296E+01_JPRB,3.3234E+01_JPRB,3.6504E+01_JPRB/)
KBO( :, 2,49,13) = (/&
&4.4271E+00_JPRB,4.4249E+00_JPRB,1.4150E+01_JPRB,2.4423E+01_JPRB,3.2036E+01_JPRB,3.5772E+01_JPRB/)
KBO( :, 3,49,13) = (/&
&5.3603E+00_JPRB,5.3576E+00_JPRB,1.3742E+01_JPRB,2.3500E+01_JPRB,3.0731E+01_JPRB,3.4966E+01_JPRB/)
KBO( :, 4,49,13) = (/&
&6.4234E+00_JPRB,6.4201E+00_JPRB,1.3335E+01_JPRB,2.2553E+01_JPRB,2.9376E+01_JPRB,3.4358E+01_JPRB/)
KBO( :, 5,49,13) = (/&
&7.6032E+00_JPRB,7.5991E+00_JPRB,1.2984E+01_JPRB,2.1616E+01_JPRB,2.8020E+01_JPRB,3.3502E+01_JPRB/)
KBO( :, 1,50,13) = (/&
&3.3075E+00_JPRB,3.3060E+00_JPRB,1.4713E+01_JPRB,2.5635E+01_JPRB,3.3698E+01_JPRB,3.6916E+01_JPRB/)
KBO( :, 2,50,13) = (/&
&4.0785E+00_JPRB,4.0766E+00_JPRB,1.4310E+01_JPRB,2.4788E+01_JPRB,3.2546E+01_JPRB,3.6251E+01_JPRB/)
KBO( :, 3,50,13) = (/&
&4.9697E+00_JPRB,4.9672E+00_JPRB,1.3904E+01_JPRB,2.3873E+01_JPRB,3.1275E+01_JPRB,3.5481E+01_JPRB/)
KBO( :, 4,50,13) = (/&
&5.9880E+00_JPRB,5.9849E+00_JPRB,1.3488E+01_JPRB,2.2931E+01_JPRB,2.9923E+01_JPRB,3.4946E+01_JPRB/)
KBO( :, 5,50,13) = (/&
&7.1253E+00_JPRB,7.1215E+00_JPRB,1.3112E+01_JPRB,2.1989E+01_JPRB,2.8565E+01_JPRB,3.4166E+01_JPRB/)
KBO( :, 1,51,13) = (/&
&3.0350E+00_JPRB,3.0337E+00_JPRB,1.4851E+01_JPRB,2.5935E+01_JPRB,3.4107E+01_JPRB,3.7237E+01_JPRB/)
KBO( :, 2,51,13) = (/&
&3.7587E+00_JPRB,3.7569E+00_JPRB,1.4465E+01_JPRB,2.5129E+01_JPRB,3.3019E+01_JPRB,3.6650E+01_JPRB/)
KBO( :, 3,51,13) = (/&
&4.6142E+00_JPRB,4.6119E+00_JPRB,1.4053E+01_JPRB,2.4233E+01_JPRB,3.1785E+01_JPRB,3.5945E+01_JPRB/)
KBO( :, 4,51,13) = (/&
&5.5848E+00_JPRB,5.5820E+00_JPRB,1.3644E+01_JPRB,2.3300E+01_JPRB,3.0450E+01_JPRB,3.5428E+01_JPRB/)
KBO( :, 5,51,13) = (/&
&6.6798E+00_JPRB,6.6762E+00_JPRB,1.3245E+01_JPRB,2.2350E+01_JPRB,2.9088E+01_JPRB,3.4747E+01_JPRB/)
KBO( :, 1,52,13) = (/&
&2.7825E+00_JPRB,2.7814E+00_JPRB,1.4975E+01_JPRB,2.6195E+01_JPRB,3.4492E+01_JPRB,3.7510E+01_JPRB/)
KBO( :, 2,52,13) = (/&
&3.4605E+00_JPRB,3.4589E+00_JPRB,1.4616E+01_JPRB,2.5455E+01_JPRB,3.3469E+01_JPRB,3.7042E+01_JPRB/)
KBO( :, 3,52,13) = (/&
&4.2744E+00_JPRB,4.2723E+00_JPRB,1.4207E+01_JPRB,2.4585E+01_JPRB,3.2279E+01_JPRB,3.6429E+01_JPRB/)
KBO( :, 4,52,13) = (/&
&5.1994E+00_JPRB,5.1968E+00_JPRB,1.3797E+01_JPRB,2.3661E+01_JPRB,3.0975E+01_JPRB,3.5933E+01_JPRB/)
KBO( :, 5,52,13) = (/&
&6.2531E+00_JPRB,6.2499E+00_JPRB,1.3386E+01_JPRB,2.2706E+01_JPRB,2.9608E+01_JPRB,3.5360E+01_JPRB/)
KBO( :, 1,53,13) = (/&
&2.5462E+00_JPRB,2.5451E+00_JPRB,1.5076E+01_JPRB,2.6414E+01_JPRB,3.4840E+01_JPRB,3.7769E+01_JPRB/)
KBO( :, 2,53,13) = (/&
&3.1815E+00_JPRB,3.1801E+00_JPRB,1.4759E+01_JPRB,2.5766E+01_JPRB,3.3894E+01_JPRB,3.7437E+01_JPRB/)
KBO( :, 3,53,13) = (/&
&3.9476E+00_JPRB,3.9457E+00_JPRB,1.4361E+01_JPRB,2.4924E+01_JPRB,3.2751E+01_JPRB,3.6936E+01_JPRB/)
KBO( :, 4,53,13) = (/&
&4.8360E+00_JPRB,4.8336E+00_JPRB,1.3950E+01_JPRB,2.4012E+01_JPRB,3.1482E+01_JPRB,3.6505E+01_JPRB/)
KBO( :, 5,53,13) = (/&
&5.8444E+00_JPRB,5.8414E+00_JPRB,1.3535E+01_JPRB,2.3068E+01_JPRB,3.0128E+01_JPRB,3.6046E+01_JPRB/)
KBO( :, 1,54,13) = (/&
&2.3476E+00_JPRB,2.3467E+00_JPRB,1.5163E+01_JPRB,2.6598E+01_JPRB,3.5117E+01_JPRB,3.7852E+01_JPRB/)
KBO( :, 2,54,13) = (/&
&2.9439E+00_JPRB,2.9426E+00_JPRB,1.4884E+01_JPRB,2.6029E+01_JPRB,3.4253E+01_JPRB,3.7637E+01_JPRB/)
KBO( :, 3,54,13) = (/&
&3.6641E+00_JPRB,3.6624E+00_JPRB,1.4503E+01_JPRB,2.5231E+01_JPRB,3.3172E+01_JPRB,3.7161E+01_JPRB/)
KBO( :, 4,54,13) = (/&
&4.5193E+00_JPRB,4.5171E+00_JPRB,1.4088E+01_JPRB,2.4334E+01_JPRB,3.1938E+01_JPRB,3.6656E+01_JPRB/)
KBO( :, 5,54,13) = (/&
&5.4838E+00_JPRB,5.4810E+00_JPRB,1.3677E+01_JPRB,2.3400E+01_JPRB,3.0603E+01_JPRB,3.6329E+01_JPRB/)
KBO( :, 1,55,13) = (/&
&2.1710E+00_JPRB,2.1701E+00_JPRB,1.5234E+01_JPRB,2.6747E+01_JPRB,3.5339E+01_JPRB,3.7885E+01_JPRB/)
KBO( :, 2,55,13) = (/&
&2.7278E+00_JPRB,2.7266E+00_JPRB,1.4989E+01_JPRB,2.6245E+01_JPRB,3.4579E+01_JPRB,3.7689E+01_JPRB/)
KBO( :, 3,55,13) = (/&
&3.4082E+00_JPRB,3.4067E+00_JPRB,1.4633E+01_JPRB,2.5510E+01_JPRB,3.3556E+01_JPRB,3.7242E+01_JPRB/)
KBO( :, 4,55,13) = (/&
&4.2238E+00_JPRB,4.2218E+00_JPRB,1.4223E+01_JPRB,2.4639E+01_JPRB,3.2363E+01_JPRB,3.6666E+01_JPRB/)
KBO( :, 5,55,13) = (/&
&5.1513E+00_JPRB,5.1487E+00_JPRB,1.3812E+01_JPRB,2.3712E+01_JPRB,3.1057E+01_JPRB,3.6276E+01_JPRB/)
KBO( :, 1,56,13) = (/&
&2.0079E+00_JPRB,2.0070E+00_JPRB,1.5283E+01_JPRB,2.6864E+01_JPRB,3.5527E+01_JPRB,3.7901E+01_JPRB/)
KBO( :, 2,56,13) = (/&
&2.5254E+00_JPRB,2.5243E+00_JPRB,1.5077E+01_JPRB,2.6433E+01_JPRB,3.4877E+01_JPRB,3.7697E+01_JPRB/)
KBO( :, 3,56,13) = (/&
&3.1684E+00_JPRB,3.1669E+00_JPRB,1.4757E+01_JPRB,2.5780E+01_JPRB,3.3923E+01_JPRB,3.7342E+01_JPRB/)
KBO( :, 4,56,13) = (/&
&3.9407E+00_JPRB,3.9388E+00_JPRB,1.4357E+01_JPRB,2.4934E+01_JPRB,3.2773E+01_JPRB,3.6769E+01_JPRB/)
KBO( :, 5,56,13) = (/&
&4.8364E+00_JPRB,4.8339E+00_JPRB,1.3945E+01_JPRB,2.4018E+01_JPRB,3.1497E+01_JPRB,3.6172E+01_JPRB/)
KBO( :, 1,57,13) = (/&
&1.8578E+00_JPRB,1.8569E+00_JPRB,1.5303E+01_JPRB,2.6949E+01_JPRB,3.5653E+01_JPRB,3.7877E+01_JPRB/)
KBO( :, 2,57,13) = (/&
&2.3391E+00_JPRB,2.3382E+00_JPRB,1.5160E+01_JPRB,2.6604E+01_JPRB,3.5134E+01_JPRB,3.7763E+01_JPRB/)
KBO( :, 3,57,13) = (/&
&2.9439E+00_JPRB,2.9426E+00_JPRB,1.4876E+01_JPRB,2.6028E+01_JPRB,3.4258E+01_JPRB,3.7439E+01_JPRB/)
KBO( :, 4,57,13) = (/&
&3.6722E+00_JPRB,3.6705E+00_JPRB,1.4492E+01_JPRB,2.5221E+01_JPRB,3.3167E+01_JPRB,3.6862E+01_JPRB/)
KBO( :, 5,57,13) = (/&
&4.5340E+00_JPRB,4.5318E+00_JPRB,1.4076E+01_JPRB,2.4322E+01_JPRB,3.1926E+01_JPRB,3.6169E+01_JPRB/)
KBO( :, 1,58,13) = (/&
&1.7257E+00_JPRB,1.7249E+00_JPRB,1.5300E+01_JPRB,2.6987E+01_JPRB,3.5715E+01_JPRB,3.7771E+01_JPRB/)
KBO( :, 2,58,13) = (/&
&2.1747E+00_JPRB,2.1738E+00_JPRB,1.5228E+01_JPRB,2.6747E+01_JPRB,3.5343E+01_JPRB,3.7835E+01_JPRB/)
KBO( :, 3,58,13) = (/&
&2.7413E+00_JPRB,2.7402E+00_JPRB,1.4977E+01_JPRB,2.6232E+01_JPRB,3.4563E+01_JPRB,3.7436E+01_JPRB/)
KBO( :, 4,58,13) = (/&
&3.4316E+00_JPRB,3.4300E+00_JPRB,1.4616E+01_JPRB,2.5484E+01_JPRB,3.3527E+01_JPRB,3.6930E+01_JPRB/)
KBO( :, 5,58,13) = (/&
&4.2563E+00_JPRB,4.2542E+00_JPRB,1.4203E+01_JPRB,2.4608E+01_JPRB,3.2326E+01_JPRB,3.6245E+01_JPRB/)
KBO( :, 1,59,13) = (/&
&1.6718E+00_JPRB,1.6710E+00_JPRB,1.5295E+01_JPRB,2.6993E+01_JPRB,3.5730E+01_JPRB,3.7608E+01_JPRB/)
KBO( :, 2,59,13) = (/&
&2.1089E+00_JPRB,2.1080E+00_JPRB,1.5254E+01_JPRB,2.6799E+01_JPRB,3.5425E+01_JPRB,3.7786E+01_JPRB/)
KBO( :, 3,59,13) = (/&
&2.6604E+00_JPRB,2.6594E+00_JPRB,1.5013E+01_JPRB,2.6309E+01_JPRB,3.4684E+01_JPRB,3.7341E+01_JPRB/)
KBO( :, 4,59,13) = (/&
&3.3364E+00_JPRB,3.3349E+00_JPRB,1.4664E+01_JPRB,2.5591E+01_JPRB,3.3675E+01_JPRB,3.6669E+01_JPRB/)
KBO( :, 5,59,13) = (/&
&4.1451E+00_JPRB,4.1431E+00_JPRB,1.4254E+01_JPRB,2.4723E+01_JPRB,3.2485E+01_JPRB,3.5871E+01_JPRB/)
KBO( :, 1,13,14) = (/&
&2.9867E+01_JPRB,2.9850E+01_JPRB,2.2813E+01_JPRB,1.5747E+01_JPRB,8.6461E+00_JPRB,6.6277E+00_JPRB/)
KBO( :, 2,13,14) = (/&
&2.8970E+01_JPRB,2.8953E+01_JPRB,2.2112E+01_JPRB,1.5258E+01_JPRB,8.4453E+00_JPRB,6.4752E+00_JPRB/)
KBO( :, 3,13,14) = (/&
&2.8231E+01_JPRB,2.8215E+01_JPRB,2.1546E+01_JPRB,1.4872E+01_JPRB,8.2664E+00_JPRB,6.3900E+00_JPRB/)
KBO( :, 4,13,14) = (/&
&2.7643E+01_JPRB,2.7627E+01_JPRB,2.1093E+01_JPRB,1.4551E+01_JPRB,8.1037E+00_JPRB,6.4058E+00_JPRB/)
KBO( :, 5,13,14) = (/&
&2.7121E+01_JPRB,2.7106E+01_JPRB,2.0679E+01_JPRB,1.4264E+01_JPRB,7.9370E+00_JPRB,6.4632E+00_JPRB/)
KBO( :, 1,14,14) = (/&
&3.1721E+01_JPRB,3.1703E+01_JPRB,2.4198E+01_JPRB,1.6672E+01_JPRB,9.2683E+00_JPRB,7.3049E+00_JPRB/)
KBO( :, 2,14,14) = (/&
&3.1076E+01_JPRB,3.1058E+01_JPRB,2.3689E+01_JPRB,1.6337E+01_JPRB,9.1193E+00_JPRB,7.0508E+00_JPRB/)
KBO( :, 3,14,14) = (/&
&3.0563E+01_JPRB,3.0546E+01_JPRB,2.3305E+01_JPRB,1.6071E+01_JPRB,8.9743E+00_JPRB,6.8812E+00_JPRB/)
KBO( :, 4,14,14) = (/&
&3.0148E+01_JPRB,3.0131E+01_JPRB,2.2977E+01_JPRB,1.5835E+01_JPRB,8.8320E+00_JPRB,6.7605E+00_JPRB/)
KBO( :, 5,14,14) = (/&
&2.9764E+01_JPRB,2.9747E+01_JPRB,2.2687E+01_JPRB,1.5631E+01_JPRB,8.6858E+00_JPRB,6.7365E+00_JPRB/)
KBO( :, 1,15,14) = (/&
&3.4331E+01_JPRB,3.4311E+01_JPRB,2.6139E+01_JPRB,1.7967E+01_JPRB,1.0028E+01_JPRB,8.1321E+00_JPRB/)
KBO( :, 2,15,14) = (/&
&3.3952E+01_JPRB,3.3933E+01_JPRB,2.5854E+01_JPRB,1.7780E+01_JPRB,9.9136E+00_JPRB,7.8472E+00_JPRB/)
KBO( :, 3,15,14) = (/&
&3.3650E+01_JPRB,3.3631E+01_JPRB,2.5615E+01_JPRB,1.7601E+01_JPRB,9.7954E+00_JPRB,7.6157E+00_JPRB/)
KBO( :, 4,15,14) = (/&
&3.3344E+01_JPRB,3.3325E+01_JPRB,2.5376E+01_JPRB,1.7433E+01_JPRB,9.6656E+00_JPRB,7.3952E+00_JPRB/)
KBO( :, 5,15,14) = (/&
&3.3055E+01_JPRB,3.3036E+01_JPRB,2.5149E+01_JPRB,1.7257E+01_JPRB,9.5339E+00_JPRB,7.2585E+00_JPRB/)
KBO( :, 1,16,14) = (/&
&3.7768E+01_JPRB,3.7746E+01_JPRB,2.8736E+01_JPRB,1.9717E+01_JPRB,1.0946E+01_JPRB,9.0577E+00_JPRB/)
KBO( :, 2,16,14) = (/&
&3.7568E+01_JPRB,3.7546E+01_JPRB,2.8561E+01_JPRB,1.9575E+01_JPRB,1.0848E+01_JPRB,8.7437E+00_JPRB/)
KBO( :, 3,16,14) = (/&
&3.7327E+01_JPRB,3.7305E+01_JPRB,2.8371E+01_JPRB,1.9439E+01_JPRB,1.0735E+01_JPRB,8.4668E+00_JPRB/)
KBO( :, 4,16,14) = (/&
&3.7089E+01_JPRB,3.7067E+01_JPRB,2.8181E+01_JPRB,1.9291E+01_JPRB,1.0617E+01_JPRB,8.2419E+00_JPRB/)
KBO( :, 5,16,14) = (/&
&3.6772E+01_JPRB,3.6751E+01_JPRB,2.7932E+01_JPRB,1.9114E+01_JPRB,1.0484E+01_JPRB,8.0316E+00_JPRB/)
KBO( :, 1,17,14) = (/&
&4.1800E+01_JPRB,4.1776E+01_JPRB,3.1755E+01_JPRB,2.1740E+01_JPRB,1.2078E+01_JPRB,1.0093E+01_JPRB/)
KBO( :, 2,17,14) = (/&
&4.1678E+01_JPRB,4.1653E+01_JPRB,3.1650E+01_JPRB,2.1659E+01_JPRB,1.1979E+01_JPRB,9.7654E+00_JPRB/)
KBO( :, 3,17,14) = (/&
&4.1542E+01_JPRB,4.1518E+01_JPRB,3.1528E+01_JPRB,2.1552E+01_JPRB,1.1863E+01_JPRB,9.4632E+00_JPRB/)
KBO( :, 4,17,14) = (/&
&4.1281E+01_JPRB,4.1257E+01_JPRB,3.1316E+01_JPRB,2.1389E+01_JPRB,1.1731E+01_JPRB,9.2257E+00_JPRB/)
KBO( :, 5,17,14) = (/&
&4.1001E+01_JPRB,4.0977E+01_JPRB,3.1090E+01_JPRB,2.1207E+01_JPRB,1.1579E+01_JPRB,8.9705E+00_JPRB/)
KBO( :, 1,18,14) = (/&
&4.6476E+01_JPRB,4.6449E+01_JPRB,3.5262E+01_JPRB,2.4079E+01_JPRB,1.3398E+01_JPRB,1.1310E+01_JPRB/)
KBO( :, 2,18,14) = (/&
&4.6434E+01_JPRB,4.6407E+01_JPRB,3.5219E+01_JPRB,2.4028E+01_JPRB,1.3279E+01_JPRB,1.0988E+01_JPRB/)
KBO( :, 3,18,14) = (/&
&4.6265E+01_JPRB,4.6238E+01_JPRB,3.5074E+01_JPRB,2.3903E+01_JPRB,1.3136E+01_JPRB,1.0670E+01_JPRB/)
KBO( :, 4,18,14) = (/&
&4.6056E+01_JPRB,4.6029E+01_JPRB,3.4898E+01_JPRB,2.3749E+01_JPRB,1.2970E+01_JPRB,1.0429E+01_JPRB/)
KBO( :, 5,18,14) = (/&
&4.5721E+01_JPRB,4.5694E+01_JPRB,3.4620E+01_JPRB,2.3533E+01_JPRB,1.2786E+01_JPRB,1.0167E+01_JPRB/)
KBO( :, 1,19,14) = (/&
&5.1627E+01_JPRB,5.1597E+01_JPRB,3.9121E+01_JPRB,2.6626E+01_JPRB,1.4901E+01_JPRB,1.2801E+01_JPRB/)
KBO( :, 2,19,14) = (/&
&5.1560E+01_JPRB,5.1530E+01_JPRB,3.9050E+01_JPRB,2.6558E+01_JPRB,1.4739E+01_JPRB,1.2472E+01_JPRB/)
KBO( :, 3,19,14) = (/&
&5.1413E+01_JPRB,5.1383E+01_JPRB,3.8915E+01_JPRB,2.6432E+01_JPRB,1.4553E+01_JPRB,1.2141E+01_JPRB/)
KBO( :, 4,19,14) = (/&
&5.1136E+01_JPRB,5.1106E+01_JPRB,3.8684E+01_JPRB,2.6245E+01_JPRB,1.4345E+01_JPRB,1.1879E+01_JPRB/)
KBO( :, 5,19,14) = (/&
&5.0773E+01_JPRB,5.0743E+01_JPRB,3.8384E+01_JPRB,2.6014E+01_JPRB,1.4118E+01_JPRB,1.1591E+01_JPRB/)
KBO( :, 1,20,14) = (/&
&5.6884E+01_JPRB,5.6851E+01_JPRB,4.3042E+01_JPRB,2.9216E+01_JPRB,1.6557E+01_JPRB,1.4595E+01_JPRB/)
KBO( :, 2,20,14) = (/&
&5.6797E+01_JPRB,5.6764E+01_JPRB,4.2946E+01_JPRB,2.9117E+01_JPRB,1.6341E+01_JPRB,1.4232E+01_JPRB/)
KBO( :, 3,20,14) = (/&
&5.6571E+01_JPRB,5.6538E+01_JPRB,4.2757E+01_JPRB,2.8963E+01_JPRB,1.6110E+01_JPRB,1.3871E+01_JPRB/)
KBO( :, 4,20,14) = (/&
&5.6241E+01_JPRB,5.6208E+01_JPRB,4.2485E+01_JPRB,2.8752E+01_JPRB,1.5861E+01_JPRB,1.3552E+01_JPRB/)
KBO( :, 5,20,14) = (/&
&5.5778E+01_JPRB,5.5746E+01_JPRB,4.2122E+01_JPRB,2.8488E+01_JPRB,1.5601E+01_JPRB,1.3221E+01_JPRB/)
KBO( :, 1,21,14) = (/&
&6.2117E+01_JPRB,6.2081E+01_JPRB,4.6932E+01_JPRB,3.1772E+01_JPRB,1.8332E+01_JPRB,1.6634E+01_JPRB/)
KBO( :, 2,21,14) = (/&
&6.1948E+01_JPRB,6.1912E+01_JPRB,4.6785E+01_JPRB,3.1648E+01_JPRB,1.8084E+01_JPRB,1.6213E+01_JPRB/)
KBO( :, 3,21,14) = (/&
&6.1644E+01_JPRB,6.1608E+01_JPRB,4.6541E+01_JPRB,3.1461E+01_JPRB,1.7808E+01_JPRB,1.5772E+01_JPRB/)
KBO( :, 4,21,14) = (/&
&6.1212E+01_JPRB,6.1176E+01_JPRB,4.6198E+01_JPRB,3.1208E+01_JPRB,1.7516E+01_JPRB,1.5375E+01_JPRB/)
KBO( :, 5,21,14) = (/&
&6.0660E+01_JPRB,6.0625E+01_JPRB,4.5764E+01_JPRB,3.0893E+01_JPRB,1.7197E+01_JPRB,1.4982E+01_JPRB/)
KBO( :, 1,22,14) = (/&
&6.7064E+01_JPRB,6.7024E+01_JPRB,5.0622E+01_JPRB,3.4206E+01_JPRB,2.0283E+01_JPRB,1.8773E+01_JPRB/)
KBO( :, 2,22,14) = (/&
&6.6814E+01_JPRB,6.6775E+01_JPRB,5.0411E+01_JPRB,3.4038E+01_JPRB,1.9964E+01_JPRB,1.8268E+01_JPRB/)
KBO( :, 3,22,14) = (/&
&6.6405E+01_JPRB,6.6365E+01_JPRB,5.0089E+01_JPRB,3.3800E+01_JPRB,1.9618E+01_JPRB,1.7753E+01_JPRB/)
KBO( :, 4,22,14) = (/&
&6.5854E+01_JPRB,6.5815E+01_JPRB,4.9659E+01_JPRB,3.3490E+01_JPRB,1.9247E+01_JPRB,1.7292E+01_JPRB/)
KBO( :, 5,22,14) = (/&
&6.5177E+01_JPRB,6.5139E+01_JPRB,4.9133E+01_JPRB,3.3115E+01_JPRB,1.8852E+01_JPRB,1.6841E+01_JPRB/)
KBO( :, 1,23,14) = (/&
&7.1524E+01_JPRB,7.1482E+01_JPRB,5.3943E+01_JPRB,3.6394E+01_JPRB,2.2409E+01_JPRB,2.1034E+01_JPRB/)
KBO( :, 2,23,14) = (/&
&7.1180E+01_JPRB,7.1138E+01_JPRB,5.3667E+01_JPRB,3.6188E+01_JPRB,2.2011E+01_JPRB,2.0463E+01_JPRB/)
KBO( :, 3,23,14) = (/&
&7.0675E+01_JPRB,7.0634E+01_JPRB,5.3273E+01_JPRB,3.5900E+01_JPRB,2.1570E+01_JPRB,1.9880E+01_JPRB/)
KBO( :, 4,23,14) = (/&
&7.0044E+01_JPRB,7.0003E+01_JPRB,5.2781E+01_JPRB,3.5547E+01_JPRB,2.1106E+01_JPRB,1.9340E+01_JPRB/)
KBO( :, 5,23,14) = (/&
&6.9258E+01_JPRB,6.9217E+01_JPRB,5.2177E+01_JPRB,3.5122E+01_JPRB,2.0624E+01_JPRB,1.8817E+01_JPRB/)
KBO( :, 1,24,14) = (/&
&7.5188E+01_JPRB,7.5144E+01_JPRB,5.6672E+01_JPRB,3.8194E+01_JPRB,2.4653E+01_JPRB,2.3438E+01_JPRB/)
KBO( :, 2,24,14) = (/&
&7.4771E+01_JPRB,7.4727E+01_JPRB,5.6346E+01_JPRB,3.7956E+01_JPRB,2.4153E+01_JPRB,2.2769E+01_JPRB/)
KBO( :, 3,24,14) = (/&
&7.4256E+01_JPRB,7.4212E+01_JPRB,5.5942E+01_JPRB,3.7664E+01_JPRB,2.3612E+01_JPRB,2.2098E+01_JPRB/)
KBO( :, 4,24,14) = (/&
&7.3533E+01_JPRB,7.3489E+01_JPRB,5.5386E+01_JPRB,3.7269E+01_JPRB,2.3047E+01_JPRB,2.1446E+01_JPRB/)
KBO( :, 5,24,14) = (/&
&7.2712E+01_JPRB,7.2669E+01_JPRB,5.4752E+01_JPRB,3.6822E+01_JPRB,2.2450E+01_JPRB,2.0823E+01_JPRB/)
KBO( :, 1,25,14) = (/&
&7.7905E+01_JPRB,7.7859E+01_JPRB,5.8695E+01_JPRB,3.9643E+01_JPRB,2.6946E+01_JPRB,2.5911E+01_JPRB/)
KBO( :, 2,25,14) = (/&
&7.7541E+01_JPRB,7.7495E+01_JPRB,5.8407E+01_JPRB,3.9379E+01_JPRB,2.6314E+01_JPRB,2.5120E+01_JPRB/)
KBO( :, 3,25,14) = (/&
&7.6964E+01_JPRB,7.6919E+01_JPRB,5.7957E+01_JPRB,3.9027E+01_JPRB,2.5656E+01_JPRB,2.4314E+01_JPRB/)
KBO( :, 4,25,14) = (/&
&7.6272E+01_JPRB,7.6227E+01_JPRB,5.7424E+01_JPRB,3.8630E+01_JPRB,2.4965E+01_JPRB,2.3534E+01_JPRB/)
KBO( :, 5,25,14) = (/&
&7.5432E+01_JPRB,7.5387E+01_JPRB,5.6779E+01_JPRB,3.8173E+01_JPRB,2.4252E+01_JPRB,2.2796E+01_JPRB/)
KBO( :, 1,26,14) = (/&
&7.9766E+01_JPRB,7.9719E+01_JPRB,6.0079E+01_JPRB,4.0881E+01_JPRB,2.9223E+01_JPRB,2.8381E+01_JPRB/)
KBO( :, 2,26,14) = (/&
&7.9434E+01_JPRB,7.9387E+01_JPRB,5.9813E+01_JPRB,4.0549E+01_JPRB,2.8445E+01_JPRB,2.7433E+01_JPRB/)
KBO( :, 3,26,14) = (/&
&7.8929E+01_JPRB,7.8882E+01_JPRB,5.9418E+01_JPRB,4.0176E+01_JPRB,2.7639E+01_JPRB,2.6466E+01_JPRB/)
KBO( :, 4,26,14) = (/&
&7.8299E+01_JPRB,7.8253E+01_JPRB,5.8927E+01_JPRB,3.9741E+01_JPRB,2.6813E+01_JPRB,2.5543E+01_JPRB/)
KBO( :, 5,26,14) = (/&
&7.7472E+01_JPRB,7.7426E+01_JPRB,5.8300E+01_JPRB,3.9244E+01_JPRB,2.5976E+01_JPRB,2.4671E+01_JPRB/)
KBO( :, 1,27,14) = (/&
&8.0841E+01_JPRB,8.0794E+01_JPRB,6.0873E+01_JPRB,4.1874E+01_JPRB,3.1425E+01_JPRB,3.0772E+01_JPRB/)
KBO( :, 2,27,14) = (/&
&8.0592E+01_JPRB,8.0544E+01_JPRB,6.0668E+01_JPRB,4.1525E+01_JPRB,3.0489E+01_JPRB,2.9641E+01_JPRB/)
KBO( :, 3,27,14) = (/&
&8.0232E+01_JPRB,8.0184E+01_JPRB,6.0383E+01_JPRB,4.1112E+01_JPRB,2.9523E+01_JPRB,2.8513E+01_JPRB/)
KBO( :, 4,27,14) = (/&
&7.9648E+01_JPRB,7.9600E+01_JPRB,5.9935E+01_JPRB,4.0653E+01_JPRB,2.8551E+01_JPRB,2.7444E+01_JPRB/)
KBO( :, 5,27,14) = (/&
&7.8924E+01_JPRB,7.8877E+01_JPRB,5.9378E+01_JPRB,4.0128E+01_JPRB,2.7582E+01_JPRB,2.6425E+01_JPRB/)
KBO( :, 1,28,14) = (/&
&8.1302E+01_JPRB,8.1254E+01_JPRB,6.1208E+01_JPRB,4.2732E+01_JPRB,3.3493E+01_JPRB,3.3014E+01_JPRB/)
KBO( :, 2,28,14) = (/&
&8.1246E+01_JPRB,8.1198E+01_JPRB,6.1149E+01_JPRB,4.2327E+01_JPRB,3.2380E+01_JPRB,3.1684E+01_JPRB/)
KBO( :, 3,28,14) = (/&
&8.0968E+01_JPRB,8.0920E+01_JPRB,6.0927E+01_JPRB,4.1887E+01_JPRB,3.1259E+01_JPRB,3.0389E+01_JPRB/)
KBO( :, 4,28,14) = (/&
&8.0565E+01_JPRB,8.0517E+01_JPRB,6.0611E+01_JPRB,4.1407E+01_JPRB,3.0143E+01_JPRB,2.9193E+01_JPRB/)
KBO( :, 5,28,14) = (/&
&7.9942E+01_JPRB,7.9894E+01_JPRB,6.0131E+01_JPRB,4.0878E+01_JPRB,2.9022E+01_JPRB,2.8027E+01_JPRB/)
KBO( :, 1,29,14) = (/&
&8.1307E+01_JPRB,8.1259E+01_JPRB,6.1205E+01_JPRB,4.3500E+01_JPRB,3.5359E+01_JPRB,3.5050E+01_JPRB/)
KBO( :, 2,29,14) = (/&
&8.1478E+01_JPRB,8.1430E+01_JPRB,6.1314E+01_JPRB,4.3042E+01_JPRB,3.4075E+01_JPRB,3.3533E+01_JPRB/)
KBO( :, 3,29,14) = (/&
&8.1374E+01_JPRB,8.1326E+01_JPRB,6.1221E+01_JPRB,4.2543E+01_JPRB,3.2801E+01_JPRB,3.2073E+01_JPRB/)
KBO( :, 4,29,14) = (/&
&8.1081E+01_JPRB,8.1032E+01_JPRB,6.0988E+01_JPRB,4.2019E+01_JPRB,3.1534E+01_JPRB,3.0765E+01_JPRB/)
KBO( :, 5,29,14) = (/&
&8.0577E+01_JPRB,8.0529E+01_JPRB,6.0599E+01_JPRB,4.1461E+01_JPRB,3.0285E+01_JPRB,2.9423E+01_JPRB/)
KBO( :, 1,30,14) = (/&
&8.1051E+01_JPRB,8.1003E+01_JPRB,6.1003E+01_JPRB,4.4185E+01_JPRB,3.7000E+01_JPRB,3.6850E+01_JPRB/)
KBO( :, 2,30,14) = (/&
&8.1462E+01_JPRB,8.1414E+01_JPRB,6.1293E+01_JPRB,4.3687E+01_JPRB,3.5552E+01_JPRB,3.5134E+01_JPRB/)
KBO( :, 3,30,14) = (/&
&8.1539E+01_JPRB,8.1490E+01_JPRB,6.1337E+01_JPRB,4.3125E+01_JPRB,3.4127E+01_JPRB,3.3561E+01_JPRB/)
KBO( :, 4,30,14) = (/&
&8.1391E+01_JPRB,8.1342E+01_JPRB,6.1214E+01_JPRB,4.2562E+01_JPRB,3.2726E+01_JPRB,3.2101E+01_JPRB/)
KBO( :, 5,30,14) = (/&
&8.0955E+01_JPRB,8.0906E+01_JPRB,6.0875E+01_JPRB,4.1945E+01_JPRB,3.1354E+01_JPRB,3.0606E+01_JPRB/)
KBO( :, 1,31,14) = (/&
&8.0671E+01_JPRB,8.0623E+01_JPRB,6.0709E+01_JPRB,4.4790E+01_JPRB,3.8398E+01_JPRB,3.8352E+01_JPRB/)
KBO( :, 2,31,14) = (/&
&8.1282E+01_JPRB,8.1234E+01_JPRB,6.1149E+01_JPRB,4.4230E+01_JPRB,3.6789E+01_JPRB,3.6501E+01_JPRB/)
KBO( :, 3,31,14) = (/&
&8.1574E+01_JPRB,8.1525E+01_JPRB,6.1354E+01_JPRB,4.3641E+01_JPRB,3.5216E+01_JPRB,3.4852E+01_JPRB/)
KBO( :, 4,31,14) = (/&
&8.1529E+01_JPRB,8.1481E+01_JPRB,6.1310E+01_JPRB,4.3014E+01_JPRB,3.3693E+01_JPRB,3.3201E+01_JPRB/)
KBO( :, 5,31,14) = (/&
&8.1189E+01_JPRB,8.1141E+01_JPRB,6.1044E+01_JPRB,4.2350E+01_JPRB,3.2213E+01_JPRB,3.1581E+01_JPRB/)
KBO( :, 1,32,14) = (/&
&8.0273E+01_JPRB,8.0225E+01_JPRB,6.0440E+01_JPRB,4.5305E+01_JPRB,3.9524E+01_JPRB,3.9577E+01_JPRB/)
KBO( :, 2,32,14) = (/&
&8.1061E+01_JPRB,8.1013E+01_JPRB,6.0977E+01_JPRB,4.4682E+01_JPRB,3.7774E+01_JPRB,3.7685E+01_JPRB/)
KBO( :, 3,32,14) = (/&
&8.1507E+01_JPRB,8.1459E+01_JPRB,6.1299E+01_JPRB,4.4057E+01_JPRB,3.6074E+01_JPRB,3.5862E+01_JPRB/)
KBO( :, 4,32,14) = (/&
&8.1572E+01_JPRB,8.1523E+01_JPRB,6.1336E+01_JPRB,4.3367E+01_JPRB,3.4447E+01_JPRB,3.4068E+01_JPRB/)
KBO( :, 5,32,14) = (/&
&8.1328E+01_JPRB,8.1279E+01_JPRB,6.1143E+01_JPRB,4.2670E+01_JPRB,3.2874E+01_JPRB,3.2515E+01_JPRB/)
KBO( :, 1,33,14) = (/&
&7.9947E+01_JPRB,7.9899E+01_JPRB,6.0245E+01_JPRB,4.5734E+01_JPRB,4.0389E+01_JPRB,4.0600E+01_JPRB/)
KBO( :, 2,33,14) = (/&
&8.0885E+01_JPRB,8.0836E+01_JPRB,6.0856E+01_JPRB,4.5062E+01_JPRB,3.8518E+01_JPRB,3.8594E+01_JPRB/)
KBO( :, 3,33,14) = (/&
&8.1444E+01_JPRB,8.1395E+01_JPRB,6.1246E+01_JPRB,4.4394E+01_JPRB,3.6721E+01_JPRB,3.6614E+01_JPRB/)
KBO( :, 4,33,14) = (/&
&8.1576E+01_JPRB,8.1528E+01_JPRB,6.1332E+01_JPRB,4.3653E+01_JPRB,3.5005E+01_JPRB,3.4830E+01_JPRB/)
KBO( :, 5,33,14) = (/&
&8.1383E+01_JPRB,8.1335E+01_JPRB,6.1178E+01_JPRB,4.2909E+01_JPRB,3.3354E+01_JPRB,3.3470E+01_JPRB/)
KBO( :, 1,34,14) = (/&
&7.9662E+01_JPRB,7.9614E+01_JPRB,6.0102E+01_JPRB,4.6098E+01_JPRB,4.1095E+01_JPRB,4.1483E+01_JPRB/)
KBO( :, 2,34,14) = (/&
&8.0738E+01_JPRB,8.0690E+01_JPRB,6.0775E+01_JPRB,4.5387E+01_JPRB,3.9122E+01_JPRB,3.9299E+01_JPRB/)
KBO( :, 3,34,14) = (/&
&8.1366E+01_JPRB,8.1318E+01_JPRB,6.1186E+01_JPRB,4.4659E+01_JPRB,3.7233E+01_JPRB,3.7257E+01_JPRB/)
KBO( :, 4,34,14) = (/&
&8.1568E+01_JPRB,8.1519E+01_JPRB,6.1321E+01_JPRB,4.3886E+01_JPRB,3.5446E+01_JPRB,3.5711E+01_JPRB/)
KBO( :, 5,34,14) = (/&
&8.1413E+01_JPRB,8.1365E+01_JPRB,6.1195E+01_JPRB,4.3093E+01_JPRB,3.3726E+01_JPRB,3.4415E+01_JPRB/)
KBO( :, 1,35,14) = (/&
&7.9337E+01_JPRB,7.9289E+01_JPRB,5.9949E+01_JPRB,4.6449E+01_JPRB,4.1796E+01_JPRB,4.2326E+01_JPRB/)
KBO( :, 2,35,14) = (/&
&8.0544E+01_JPRB,8.0496E+01_JPRB,6.0670E+01_JPRB,4.5697E+01_JPRB,3.9737E+01_JPRB,4.0033E+01_JPRB/)
KBO( :, 3,35,14) = (/&
&8.1258E+01_JPRB,8.1209E+01_JPRB,6.1112E+01_JPRB,4.4918E+01_JPRB,3.7765E+01_JPRB,3.8111E+01_JPRB/)
KBO( :, 4,35,14) = (/&
&8.1537E+01_JPRB,8.1488E+01_JPRB,6.1295E+01_JPRB,4.4118E+01_JPRB,3.5911E+01_JPRB,3.6760E+01_JPRB/)
KBO( :, 5,35,14) = (/&
&8.1445E+01_JPRB,8.1397E+01_JPRB,6.1217E+01_JPRB,4.3296E+01_JPRB,3.4131E+01_JPRB,3.5503E+01_JPRB/)
KBO( :, 1,36,14) = (/&
&7.8929E+01_JPRB,7.8882E+01_JPRB,5.9746E+01_JPRB,4.6822E+01_JPRB,4.2579E+01_JPRB,4.3271E+01_JPRB/)
KBO( :, 2,36,14) = (/&
&8.0271E+01_JPRB,8.0223E+01_JPRB,6.0527E+01_JPRB,4.6026E+01_JPRB,4.0432E+01_JPRB,4.0931E+01_JPRB/)
KBO( :, 3,36,14) = (/&
&8.1107E+01_JPRB,8.1058E+01_JPRB,6.1024E+01_JPRB,4.5215E+01_JPRB,3.8381E+01_JPRB,3.9211E+01_JPRB/)
KBO( :, 4,36,14) = (/&
&8.1508E+01_JPRB,8.1459E+01_JPRB,6.1272E+01_JPRB,4.4394E+01_JPRB,3.6464E+01_JPRB,3.7915E+01_JPRB/)
KBO( :, 5,36,14) = (/&
&8.1479E+01_JPRB,8.1431E+01_JPRB,6.1242E+01_JPRB,4.3542E+01_JPRB,3.4625E+01_JPRB,3.6634E+01_JPRB/)
KBO( :, 1,37,14) = (/&
&7.8277E+01_JPRB,7.8230E+01_JPRB,5.9419E+01_JPRB,4.7267E+01_JPRB,4.3580E+01_JPRB,4.4454E+01_JPRB/)
KBO( :, 2,37,14) = (/&
&7.9839E+01_JPRB,7.9792E+01_JPRB,6.0300E+01_JPRB,4.6427E+01_JPRB,4.1343E+01_JPRB,4.2071E+01_JPRB/)
KBO( :, 3,37,14) = (/&
&8.0875E+01_JPRB,8.0827E+01_JPRB,6.0897E+01_JPRB,4.5598E+01_JPRB,3.9207E+01_JPRB,4.0399E+01_JPRB/)
KBO( :, 4,37,14) = (/&
&8.1407E+01_JPRB,8.1359E+01_JPRB,6.1209E+01_JPRB,4.4745E+01_JPRB,3.7210E+01_JPRB,3.9084E+01_JPRB/)
KBO( :, 5,37,14) = (/&
&8.1511E+01_JPRB,8.1463E+01_JPRB,6.1267E+01_JPRB,4.3885E+01_JPRB,3.5313E+01_JPRB,3.7757E+01_JPRB/)
KBO( :, 1,38,14) = (/&
&7.7604E+01_JPRB,7.7558E+01_JPRB,5.9100E+01_JPRB,4.7673E+01_JPRB,4.4519E+01_JPRB,4.5590E+01_JPRB/)
KBO( :, 2,38,14) = (/&
&7.9387E+01_JPRB,7.9340E+01_JPRB,6.0071E+01_JPRB,4.6807E+01_JPRB,4.2192E+01_JPRB,4.3208E+01_JPRB/)
KBO( :, 3,38,14) = (/&
&8.0600E+01_JPRB,8.0552E+01_JPRB,6.0751E+01_JPRB,4.5947E+01_JPRB,3.9982E+01_JPRB,4.1623E+01_JPRB/)
KBO( :, 4,38,14) = (/&
&8.1297E+01_JPRB,8.1248E+01_JPRB,6.1150E+01_JPRB,4.5081E+01_JPRB,3.7909E+01_JPRB,4.0273E+01_JPRB/)
KBO( :, 5,38,14) = (/&
&8.1523E+01_JPRB,8.1474E+01_JPRB,6.1279E+01_JPRB,4.4207E+01_JPRB,3.5960E+01_JPRB,3.8923E+01_JPRB/)
KBO( :, 1,39,14) = (/&
&7.6924E+01_JPRB,7.6879E+01_JPRB,5.8785E+01_JPRB,4.8037E+01_JPRB,4.5384E+01_JPRB,4.6696E+01_JPRB/)
KBO( :, 2,39,14) = (/&
&7.8919E+01_JPRB,7.8872E+01_JPRB,5.9835E+01_JPRB,4.7151E+01_JPRB,4.2965E+01_JPRB,4.4375E+01_JPRB/)
KBO( :, 3,39,14) = (/&
&8.0301E+01_JPRB,8.0253E+01_JPRB,6.0596E+01_JPRB,4.6264E+01_JPRB,4.0694E+01_JPRB,4.2894E+01_JPRB/)
KBO( :, 4,39,14) = (/&
&8.1135E+01_JPRB,8.1087E+01_JPRB,6.1060E+01_JPRB,4.5380E+01_JPRB,3.8551E+01_JPRB,4.1533E+01_JPRB/)
KBO( :, 5,39,14) = (/&
&8.1498E+01_JPRB,8.1449E+01_JPRB,6.1268E+01_JPRB,4.4494E+01_JPRB,3.6550E+01_JPRB,4.0180E+01_JPRB/)
KBO( :, 1,40,14) = (/&
&7.6003E+01_JPRB,7.5957E+01_JPRB,5.8367E+01_JPRB,4.8484E+01_JPRB,4.6448E+01_JPRB,4.7942E+01_JPRB/)
KBO( :, 2,40,14) = (/&
&7.8250E+01_JPRB,7.8203E+01_JPRB,5.9505E+01_JPRB,4.7557E+01_JPRB,4.3937E+01_JPRB,4.5516E+01_JPRB/)
KBO( :, 3,40,14) = (/&
&7.9849E+01_JPRB,7.9801E+01_JPRB,6.0362E+01_JPRB,4.6641E+01_JPRB,4.1586E+01_JPRB,4.3950E+01_JPRB/)
KBO( :, 4,40,14) = (/&
&8.0899E+01_JPRB,8.0851E+01_JPRB,6.0936E+01_JPRB,4.5752E+01_JPRB,3.9370E+01_JPRB,4.2576E+01_JPRB/)
KBO( :, 5,40,14) = (/&
&8.1420E+01_JPRB,8.1371E+01_JPRB,6.1226E+01_JPRB,4.4847E+01_JPRB,3.7301E+01_JPRB,4.1187E+01_JPRB/)
KBO( :, 1,41,14) = (/&
&7.5005E+01_JPRB,7.4960E+01_JPRB,5.7923E+01_JPRB,4.8919E+01_JPRB,4.7504E+01_JPRB,4.9183E+01_JPRB/)
KBO( :, 2,41,14) = (/&
&7.7512E+01_JPRB,7.7466E+01_JPRB,5.9150E+01_JPRB,4.7955E+01_JPRB,4.4905E+01_JPRB,4.6631E+01_JPRB/)
KBO( :, 3,41,14) = (/&
&7.9348E+01_JPRB,7.9301E+01_JPRB,6.0108E+01_JPRB,4.7025E+01_JPRB,4.2473E+01_JPRB,4.4967E+01_JPRB/)
KBO( :, 4,41,14) = (/&
&8.0591E+01_JPRB,8.0543E+01_JPRB,6.0779E+01_JPRB,4.6109E+01_JPRB,4.0189E+01_JPRB,4.3586E+01_JPRB/)
KBO( :, 5,41,14) = (/&
&8.1296E+01_JPRB,8.1247E+01_JPRB,6.1167E+01_JPRB,4.5201E+01_JPRB,3.8056E+01_JPRB,4.2157E+01_JPRB/)
KBO( :, 1,42,14) = (/&
&7.3966E+01_JPRB,7.3922E+01_JPRB,5.7469E+01_JPRB,4.9337E+01_JPRB,4.8525E+01_JPRB,5.0393E+01_JPRB/)
KBO( :, 2,42,14) = (/&
&7.6721E+01_JPRB,7.6675E+01_JPRB,5.8783E+01_JPRB,4.8336E+01_JPRB,4.5846E+01_JPRB,4.7757E+01_JPRB/)
KBO( :, 3,42,14) = (/&
&7.8788E+01_JPRB,7.8741E+01_JPRB,5.9830E+01_JPRB,4.7390E+01_JPRB,4.3338E+01_JPRB,4.6001E+01_JPRB/)
KBO( :, 4,42,14) = (/&
&8.0252E+01_JPRB,8.0204E+01_JPRB,6.0610E+01_JPRB,4.6463E+01_JPRB,4.0990E+01_JPRB,4.4619E+01_JPRB/)
KBO( :, 5,42,14) = (/&
&8.1117E+01_JPRB,8.1069E+01_JPRB,6.1079E+01_JPRB,4.5535E+01_JPRB,3.8790E+01_JPRB,4.3153E+01_JPRB/)
KBO( :, 1,43,14) = (/&
&7.2705E+01_JPRB,7.2662E+01_JPRB,5.6918E+01_JPRB,4.9800E+01_JPRB,4.9669E+01_JPRB,5.1746E+01_JPRB/)
KBO( :, 2,43,14) = (/&
&7.5730E+01_JPRB,7.5685E+01_JPRB,5.8326E+01_JPRB,4.8759E+01_JPRB,4.6917E+01_JPRB,4.8987E+01_JPRB/)
KBO( :, 3,43,14) = (/&
&7.8083E+01_JPRB,7.8037E+01_JPRB,5.9488E+01_JPRB,4.7800E+01_JPRB,4.4326E+01_JPRB,4.7090E+01_JPRB/)
KBO( :, 4,43,14) = (/&
&7.9761E+01_JPRB,7.9714E+01_JPRB,6.0355E+01_JPRB,4.6841E+01_JPRB,4.1904E+01_JPRB,4.5691E+01_JPRB/)
KBO( :, 5,43,14) = (/&
&8.0847E+01_JPRB,8.0799E+01_JPRB,6.0937E+01_JPRB,4.5910E+01_JPRB,3.9634E+01_JPRB,4.4206E+01_JPRB/)
KBO( :, 1,44,14) = (/&
&7.1287E+01_JPRB,7.1245E+01_JPRB,5.6316E+01_JPRB,5.0292E+01_JPRB,5.0887E+01_JPRB,5.3170E+01_JPRB/)
KBO( :, 2,44,14) = (/&
&7.4599E+01_JPRB,7.4555E+01_JPRB,5.7821E+01_JPRB,4.9215E+01_JPRB,4.8047E+01_JPRB,5.0291E+01_JPRB/)
KBO( :, 3,44,14) = (/&
&7.7237E+01_JPRB,7.7191E+01_JPRB,5.9077E+01_JPRB,4.8209E+01_JPRB,4.5375E+01_JPRB,4.8245E+01_JPRB/)
KBO( :, 4,44,14) = (/&
&7.9186E+01_JPRB,7.9139E+01_JPRB,6.0066E+01_JPRB,4.7254E+01_JPRB,4.2877E+01_JPRB,4.6818E+01_JPRB/)
KBO( :, 5,44,14) = (/&
&8.0509E+01_JPRB,8.0461E+01_JPRB,6.0765E+01_JPRB,4.6310E+01_JPRB,4.0533E+01_JPRB,4.5323E+01_JPRB/)
KBO( :, 1,45,14) = (/&
&6.9761E+01_JPRB,6.9720E+01_JPRB,5.5680E+01_JPRB,5.0779E+01_JPRB,5.2112E+01_JPRB,5.4609E+01_JPRB/)
KBO( :, 2,45,14) = (/&
&7.3387E+01_JPRB,7.3344E+01_JPRB,5.7284E+01_JPRB,4.9658E+01_JPRB,4.9177E+01_JPRB,5.1651E+01_JPRB/)
KBO( :, 3,45,14) = (/&
&7.6302E+01_JPRB,7.6257E+01_JPRB,5.8639E+01_JPRB,4.8623E+01_JPRB,4.6419E+01_JPRB,4.9491E+01_JPRB/)
KBO( :, 4,45,14) = (/&
&7.8515E+01_JPRB,7.8468E+01_JPRB,5.9732E+01_JPRB,4.7651E+01_JPRB,4.3843E+01_JPRB,4.8016E+01_JPRB/)
KBO( :, 5,45,14) = (/&
&8.0070E+01_JPRB,8.0022E+01_JPRB,6.0538E+01_JPRB,4.6688E+01_JPRB,4.1436E+01_JPRB,4.6520E+01_JPRB/)
KBO( :, 1,46,14) = (/&
&6.8043E+01_JPRB,6.8003E+01_JPRB,5.4978E+01_JPRB,5.1296E+01_JPRB,5.3415E+01_JPRB,5.6131E+01_JPRB/)
KBO( :, 2,46,14) = (/&
&7.2020E+01_JPRB,7.1978E+01_JPRB,5.6693E+01_JPRB,5.0128E+01_JPRB,5.0366E+01_JPRB,5.3081E+01_JPRB/)
KBO( :, 3,46,14) = (/&
&7.5220E+01_JPRB,7.5175E+01_JPRB,5.8142E+01_JPRB,4.9054E+01_JPRB,4.7529E+01_JPRB,5.0825E+01_JPRB/)
KBO( :, 4,46,14) = (/&
&7.7714E+01_JPRB,7.7668E+01_JPRB,5.9339E+01_JPRB,4.8058E+01_JPRB,4.4874E+01_JPRB,4.9267E+01_JPRB/)
KBO( :, 5,46,14) = (/&
&7.9534E+01_JPRB,7.9486E+01_JPRB,6.0264E+01_JPRB,4.7084E+01_JPRB,4.2395E+01_JPRB,4.7792E+01_JPRB/)
KBO( :, 1,47,14) = (/&
&6.6054E+01_JPRB,6.6015E+01_JPRB,5.4183E+01_JPRB,5.1903E+01_JPRB,5.4894E+01_JPRB,5.7778E+01_JPRB/)
KBO( :, 2,47,14) = (/&
&7.0378E+01_JPRB,7.0336E+01_JPRB,5.5996E+01_JPRB,5.0654E+01_JPRB,5.1707E+01_JPRB,5.4608E+01_JPRB/)
KBO( :, 3,47,14) = (/&
&7.3908E+01_JPRB,7.3864E+01_JPRB,5.7556E+01_JPRB,4.9537E+01_JPRB,4.8774E+01_JPRB,5.2210E+01_JPRB/)
KBO( :, 4,47,14) = (/&
&7.6726E+01_JPRB,7.6681E+01_JPRB,5.8866E+01_JPRB,4.8503E+01_JPRB,4.6033E+01_JPRB,5.0483E+01_JPRB/)
KBO( :, 5,47,14) = (/&
&7.8817E+01_JPRB,7.8770E+01_JPRB,5.9899E+01_JPRB,4.7521E+01_JPRB,4.3467E+01_JPRB,4.9057E+01_JPRB/)
KBO( :, 1,48,14) = (/&
&6.3955E+01_JPRB,6.3917E+01_JPRB,5.3354E+01_JPRB,5.2548E+01_JPRB,5.6389E+01_JPRB,5.9437E+01_JPRB/)
KBO( :, 2,48,14) = (/&
&6.8594E+01_JPRB,6.8553E+01_JPRB,5.5256E+01_JPRB,5.1194E+01_JPRB,5.3073E+01_JPRB,5.6223E+01_JPRB/)
KBO( :, 3,48,14) = (/&
&7.2478E+01_JPRB,7.2435E+01_JPRB,5.6928E+01_JPRB,5.0025E+01_JPRB,5.0034E+01_JPRB,5.3708E+01_JPRB/)
KBO( :, 4,48,14) = (/&
&7.5613E+01_JPRB,7.5568E+01_JPRB,5.8350E+01_JPRB,4.8962E+01_JPRB,4.7206E+01_JPRB,5.1823E+01_JPRB/)
KBO( :, 5,48,14) = (/&
&7.8004E+01_JPRB,7.7958E+01_JPRB,5.9498E+01_JPRB,4.7959E+01_JPRB,4.4557E+01_JPRB,5.0435E+01_JPRB/)
KBO( :, 1,49,14) = (/&
&6.1733E+01_JPRB,6.1696E+01_JPRB,5.2490E+01_JPRB,5.3233E+01_JPRB,5.7911E+01_JPRB,6.1164E+01_JPRB/)
KBO( :, 2,49,14) = (/&
&6.6686E+01_JPRB,6.6647E+01_JPRB,5.4483E+01_JPRB,5.1761E+01_JPRB,5.4482E+01_JPRB,5.7948E+01_JPRB/)
KBO( :, 3,49,14) = (/&
&7.0933E+01_JPRB,7.0891E+01_JPRB,5.6270E+01_JPRB,5.0531E+01_JPRB,5.1319E+01_JPRB,5.5363E+01_JPRB/)
KBO( :, 4,49,14) = (/&
&7.4366E+01_JPRB,7.4322E+01_JPRB,5.7787E+01_JPRB,4.9421E+01_JPRB,4.8403E+01_JPRB,5.3357E+01_JPRB/)
KBO( :, 5,49,14) = (/&
&7.7078E+01_JPRB,7.7033E+01_JPRB,5.9049E+01_JPRB,4.8386E+01_JPRB,4.5673E+01_JPRB,5.2019E+01_JPRB/)
KBO( :, 1,50,14) = (/&
&5.9556E+01_JPRB,5.9521E+01_JPRB,5.1669E+01_JPRB,5.3919E+01_JPRB,5.9382E+01_JPRB,6.2781E+01_JPRB/)
KBO( :, 2,50,14) = (/&
&6.4814E+01_JPRB,6.4775E+01_JPRB,5.3744E+01_JPRB,5.2339E+01_JPRB,5.5844E+01_JPRB,5.9493E+01_JPRB/)
KBO( :, 3,50,14) = (/&
&6.9336E+01_JPRB,6.9295E+01_JPRB,5.5596E+01_JPRB,5.1013E+01_JPRB,5.2559E+01_JPRB,5.6778E+01_JPRB/)
KBO( :, 4,50,14) = (/&
&7.3091E+01_JPRB,7.3048E+01_JPRB,5.7225E+01_JPRB,4.9862E+01_JPRB,4.9551E+01_JPRB,5.4617E+01_JPRB/)
KBO( :, 5,50,14) = (/&
&7.6098E+01_JPRB,7.6053E+01_JPRB,5.8589E+01_JPRB,4.8799E+01_JPRB,4.6739E+01_JPRB,5.3303E+01_JPRB/)
KBO( :, 1,51,14) = (/&
&5.7367E+01_JPRB,5.7333E+01_JPRB,5.0871E+01_JPRB,5.4612E+01_JPRB,6.0840E+01_JPRB,6.4373E+01_JPRB/)
KBO( :, 2,51,14) = (/&
&6.2885E+01_JPRB,6.2848E+01_JPRB,5.2984E+01_JPRB,5.2932E+01_JPRB,5.7187E+01_JPRB,6.0966E+01_JPRB/)
KBO( :, 3,51,14) = (/&
&6.7687E+01_JPRB,6.7647E+01_JPRB,5.4925E+01_JPRB,5.1505E+01_JPRB,5.3793E+01_JPRB,5.8080E+01_JPRB/)
KBO( :, 4,51,14) = (/&
&7.1761E+01_JPRB,7.1718E+01_JPRB,5.6647E+01_JPRB,5.0300E+01_JPRB,5.0681E+01_JPRB,5.5789E+01_JPRB/)
KBO( :, 5,51,14) = (/&
&7.5046E+01_JPRB,7.5001E+01_JPRB,5.8108E+01_JPRB,4.9204E+01_JPRB,4.7793E+01_JPRB,5.4431E+01_JPRB/)
KBO( :, 1,52,14) = (/&
&5.5098E+01_JPRB,5.5065E+01_JPRB,5.0074E+01_JPRB,5.5358E+01_JPRB,6.2317E+01_JPRB,6.6056E+01_JPRB/)
KBO( :, 2,52,14) = (/&
&6.0852E+01_JPRB,6.0816E+01_JPRB,5.2195E+01_JPRB,5.3549E+01_JPRB,5.8551E+01_JPRB,6.2483E+01_JPRB/)
KBO( :, 3,52,14) = (/&
&6.5953E+01_JPRB,6.5914E+01_JPRB,5.4229E+01_JPRB,5.2028E+01_JPRB,5.5063E+01_JPRB,5.9490E+01_JPRB/)
KBO( :, 4,52,14) = (/&
&7.0320E+01_JPRB,7.0278E+01_JPRB,5.6036E+01_JPRB,5.0747E+01_JPRB,5.1835E+01_JPRB,5.7114E+01_JPRB/)
KBO( :, 5,52,14) = (/&
&7.3892E+01_JPRB,7.3848E+01_JPRB,5.7595E+01_JPRB,4.9618E+01_JPRB,4.8874E+01_JPRB,5.5672E+01_JPRB/)
KBO( :, 1,53,14) = (/&
&5.2721E+01_JPRB,5.2690E+01_JPRB,4.9263E+01_JPRB,5.6120E+01_JPRB,6.3814E+01_JPRB,6.7766E+01_JPRB/)
KBO( :, 2,53,14) = (/&
&5.8756E+01_JPRB,5.8721E+01_JPRB,5.1411E+01_JPRB,5.4211E+01_JPRB,5.9956E+01_JPRB,6.4072E+01_JPRB/)
KBO( :, 3,53,14) = (/&
&6.4126E+01_JPRB,6.4088E+01_JPRB,5.3502E+01_JPRB,5.2588E+01_JPRB,5.6365E+01_JPRB,6.1039E+01_JPRB/)
KBO( :, 4,53,14) = (/&
&6.8738E+01_JPRB,6.8697E+01_JPRB,5.5371E+01_JPRB,5.1205E+01_JPRB,5.3025E+01_JPRB,5.8602E+01_JPRB/)
KBO( :, 5,53,14) = (/&
&7.2636E+01_JPRB,7.2593E+01_JPRB,5.7041E+01_JPRB,5.0037E+01_JPRB,4.9973E+01_JPRB,5.7127E+01_JPRB/)
KBO( :, 1,54,14) = (/&
&5.0488E+01_JPRB,5.0458E+01_JPRB,4.8529E+01_JPRB,5.6862E+01_JPRB,6.5226E+01_JPRB,6.9287E+01_JPRB/)
KBO( :, 2,54,14) = (/&
&5.6752E+01_JPRB,5.6718E+01_JPRB,5.0683E+01_JPRB,5.4841E+01_JPRB,6.1279E+01_JPRB,6.5223E+01_JPRB/)
KBO( :, 3,54,14) = (/&
&6.2359E+01_JPRB,6.2322E+01_JPRB,5.2805E+01_JPRB,5.3124E+01_JPRB,5.7582E+01_JPRB,6.2132E+01_JPRB/)
KBO( :, 4,54,14) = (/&
&6.7239E+01_JPRB,6.7199E+01_JPRB,5.4766E+01_JPRB,5.1664E+01_JPRB,5.4149E+01_JPRB,5.9478E+01_JPRB/)
KBO( :, 5,54,14) = (/&
&7.1401E+01_JPRB,7.1358E+01_JPRB,5.6510E+01_JPRB,5.0433E+01_JPRB,5.0999E+01_JPRB,5.7575E+01_JPRB/)
KBO( :, 1,55,14) = (/&
&4.8301E+01_JPRB,4.8272E+01_JPRB,4.7833E+01_JPRB,5.7595E+01_JPRB,6.6585E+01_JPRB,7.0689E+01_JPRB/)
KBO( :, 2,55,14) = (/&
&5.4769E+01_JPRB,5.4736E+01_JPRB,4.9988E+01_JPRB,5.5495E+01_JPRB,6.2560E+01_JPRB,6.6385E+01_JPRB/)
KBO( :, 3,55,14) = (/&
&6.0573E+01_JPRB,6.0537E+01_JPRB,5.2112E+01_JPRB,5.3664E+01_JPRB,5.8770E+01_JPRB,6.2943E+01_JPRB/)
KBO( :, 4,55,14) = (/&
&6.5713E+01_JPRB,6.5674E+01_JPRB,5.4151E+01_JPRB,5.2119E+01_JPRB,5.5258E+01_JPRB,6.0010E+01_JPRB/)
KBO( :, 5,55,14) = (/&
&7.0126E+01_JPRB,7.0084E+01_JPRB,5.5970E+01_JPRB,5.0826E+01_JPRB,5.2008E+01_JPRB,5.7678E+01_JPRB/)
KBO( :, 1,56,14) = (/&
&4.6079E+01_JPRB,4.6051E+01_JPRB,4.7176E+01_JPRB,5.8356E+01_JPRB,6.7969E+01_JPRB,7.2050E+01_JPRB/)
KBO( :, 2,56,14) = (/&
&5.2701E+01_JPRB,5.2670E+01_JPRB,4.9282E+01_JPRB,5.6152E+01_JPRB,6.3857E+01_JPRB,6.7749E+01_JPRB/)
KBO( :, 3,56,14) = (/&
&5.8754E+01_JPRB,5.8720E+01_JPRB,5.1436E+01_JPRB,5.4239E+01_JPRB,5.9985E+01_JPRB,6.3792E+01_JPRB/)
KBO( :, 4,56,14) = (/&
&6.4130E+01_JPRB,6.4092E+01_JPRB,5.3523E+01_JPRB,5.2605E+01_JPRB,5.6386E+01_JPRB,6.0677E+01_JPRB/)
KBO( :, 5,56,14) = (/&
&6.8768E+01_JPRB,6.8727E+01_JPRB,5.5406E+01_JPRB,5.1229E+01_JPRB,5.3042E+01_JPRB,5.8111E+01_JPRB/)
KBO( :, 1,57,14) = (/&
&4.3796E+01_JPRB,4.3770E+01_JPRB,4.6545E+01_JPRB,5.9133E+01_JPRB,6.9380E+01_JPRB,7.3404E+01_JPRB/)
KBO( :, 2,57,14) = (/&
&5.0589E+01_JPRB,5.0559E+01_JPRB,4.8583E+01_JPRB,5.6850E+01_JPRB,6.5189E+01_JPRB,6.9103E+01_JPRB/)
KBO( :, 3,57,14) = (/&
&5.6860E+01_JPRB,5.6826E+01_JPRB,5.0745E+01_JPRB,5.4829E+01_JPRB,6.1234E+01_JPRB,6.4852E+01_JPRB/)
KBO( :, 4,57,14) = (/&
&6.2462E+01_JPRB,6.2424E+01_JPRB,5.2862E+01_JPRB,5.3112E+01_JPRB,5.7531E+01_JPRB,6.1451E+01_JPRB/)
KBO( :, 5,57,14) = (/&
&6.7340E+01_JPRB,6.7300E+01_JPRB,5.4823E+01_JPRB,5.1656E+01_JPRB,5.4098E+01_JPRB,5.8580E+01_JPRB/)
KBO( :, 1,58,14) = (/&
&4.1597E+01_JPRB,4.1573E+01_JPRB,4.5980E+01_JPRB,5.9890E+01_JPRB,7.0733E+01_JPRB,7.4721E+01_JPRB/)
KBO( :, 2,58,14) = (/&
&4.8541E+01_JPRB,4.8512E+01_JPRB,4.7924E+01_JPRB,5.7530E+01_JPRB,6.6457E+01_JPRB,7.0297E+01_JPRB/)
KBO( :, 3,58,14) = (/&
&5.5001E+01_JPRB,5.4968E+01_JPRB,5.0085E+01_JPRB,5.5434E+01_JPRB,6.2433E+01_JPRB,6.6096E+01_JPRB/)
KBO( :, 4,58,14) = (/&
&6.0796E+01_JPRB,6.0760E+01_JPRB,5.2213E+01_JPRB,5.3615E+01_JPRB,5.8644E+01_JPRB,6.2188E+01_JPRB/)
KBO( :, 5,58,14) = (/&
&6.5915E+01_JPRB,6.5876E+01_JPRB,5.4248E+01_JPRB,5.2078E+01_JPRB,5.5135E+01_JPRB,5.9028E+01_JPRB/)
KBO( :, 1,59,14) = (/&
&4.0694E+01_JPRB,4.0670E+01_JPRB,4.5769E+01_JPRB,6.0220E+01_JPRB,7.1303E+01_JPRB,7.5294E+01_JPRB/)
KBO( :, 2,59,14) = (/&
&4.7704E+01_JPRB,4.7676E+01_JPRB,4.7670E+01_JPRB,5.7820E+01_JPRB,6.6989E+01_JPRB,7.0669E+01_JPRB/)
KBO( :, 3,59,14) = (/&
&5.4223E+01_JPRB,5.4191E+01_JPRB,4.9817E+01_JPRB,5.5687E+01_JPRB,6.2924E+01_JPRB,6.6331E+01_JPRB/)
KBO( :, 4,59,14) = (/&
&6.0110E+01_JPRB,6.0074E+01_JPRB,5.1957E+01_JPRB,5.3831E+01_JPRB,5.9105E+01_JPRB,6.2224E+01_JPRB/)
KBO( :, 5,59,14) = (/&
&6.5318E+01_JPRB,6.5279E+01_JPRB,5.4011E+01_JPRB,5.2258E+01_JPRB,5.5565E+01_JPRB,5.8638E+01_JPRB/)
KBO( :, 1,13,15) = (/&
&3.6131E+01_JPRB,3.6111E+01_JPRB,2.7504E+01_JPRB,1.8893E+01_JPRB,1.0455E+01_JPRB,8.3589E+00_JPRB/)
KBO( :, 2,13,15) = (/&
&3.5587E+01_JPRB,3.5567E+01_JPRB,2.7173E+01_JPRB,1.8796E+01_JPRB,1.0430E+01_JPRB,8.1741E+00_JPRB/)
KBO( :, 3,13,15) = (/&
&3.5232E+01_JPRB,3.5212E+01_JPRB,2.6920E+01_JPRB,1.8645E+01_JPRB,1.0345E+01_JPRB,8.4671E+00_JPRB/)
KBO( :, 4,13,15) = (/&
&3.5001E+01_JPRB,3.4981E+01_JPRB,2.6729E+01_JPRB,1.8467E+01_JPRB,1.0232E+01_JPRB,9.0834E+00_JPRB/)
KBO( :, 5,13,15) = (/&
&3.4785E+01_JPRB,3.4765E+01_JPRB,2.6543E+01_JPRB,1.8302E+01_JPRB,1.0125E+01_JPRB,1.1028E+01_JPRB/)
KBO( :, 1,14,15) = (/&
&4.1079E+01_JPRB,4.1055E+01_JPRB,3.1300E+01_JPRB,2.1582E+01_JPRB,1.1853E+01_JPRB,9.3349E+00_JPRB/)
KBO( :, 2,14,15) = (/&
&4.0876E+01_JPRB,4.0852E+01_JPRB,3.1181E+01_JPRB,2.1527E+01_JPRB,1.1831E+01_JPRB,9.0870E+00_JPRB/)
KBO( :, 3,14,15) = (/&
&4.0794E+01_JPRB,4.0770E+01_JPRB,3.1110E+01_JPRB,2.1447E+01_JPRB,1.1767E+01_JPRB,9.0396E+00_JPRB/)
KBO( :, 4,14,15) = (/&
&4.0674E+01_JPRB,4.0650E+01_JPRB,3.1006E+01_JPRB,2.1331E+01_JPRB,1.1685E+01_JPRB,9.1026E+00_JPRB/)
KBO( :, 5,14,15) = (/&
&4.0556E+01_JPRB,4.0533E+01_JPRB,3.0850E+01_JPRB,2.1168E+01_JPRB,1.1577E+01_JPRB,9.5160E+00_JPRB/)
KBO( :, 1,15,15) = (/&
&4.7326E+01_JPRB,4.7299E+01_JPRB,3.6027E+01_JPRB,2.4785E+01_JPRB,1.3503E+01_JPRB,1.0407E+01_JPRB/)
KBO( :, 2,15,15) = (/&
&4.7413E+01_JPRB,4.7386E+01_JPRB,3.6106E+01_JPRB,2.4831E+01_JPRB,1.3509E+01_JPRB,1.0116E+01_JPRB/)
KBO( :, 3,15,15) = (/&
&4.7425E+01_JPRB,4.7398E+01_JPRB,3.6101E+01_JPRB,2.4790E+01_JPRB,1.3473E+01_JPRB,9.8259E+00_JPRB/)
KBO( :, 4,15,15) = (/&
&4.7432E+01_JPRB,4.7405E+01_JPRB,3.6056E+01_JPRB,2.4680E+01_JPRB,1.3388E+01_JPRB,9.8639E+00_JPRB/)
KBO( :, 5,15,15) = (/&
&4.7370E+01_JPRB,4.7342E+01_JPRB,3.5942E+01_JPRB,2.4552E+01_JPRB,1.3257E+01_JPRB,9.8173E+00_JPRB/)
KBO( :, 1,16,15) = (/&
&5.4875E+01_JPRB,5.4844E+01_JPRB,4.1702E+01_JPRB,2.8578E+01_JPRB,1.5437E+01_JPRB,1.1664E+01_JPRB/)
KBO( :, 2,16,15) = (/&
&5.5032E+01_JPRB,5.5000E+01_JPRB,4.1823E+01_JPRB,2.8656E+01_JPRB,1.5467E+01_JPRB,1.1353E+01_JPRB/)
KBO( :, 3,16,15) = (/&
&5.5199E+01_JPRB,5.5167E+01_JPRB,4.1916E+01_JPRB,2.8637E+01_JPRB,1.5432E+01_JPRB,1.1037E+01_JPRB/)
KBO( :, 4,16,15) = (/&
&5.5276E+01_JPRB,5.5244E+01_JPRB,4.1910E+01_JPRB,2.8561E+01_JPRB,1.5341E+01_JPRB,1.0976E+01_JPRB/)
KBO( :, 5,16,15) = (/&
&5.5278E+01_JPRB,5.5245E+01_JPRB,4.1857E+01_JPRB,2.8461E+01_JPRB,1.5222E+01_JPRB,1.0876E+01_JPRB/)
KBO( :, 1,17,15) = (/&
&6.3573E+01_JPRB,6.3536E+01_JPRB,4.8216E+01_JPRB,3.2905E+01_JPRB,1.7651E+01_JPRB,1.3317E+01_JPRB/)
KBO( :, 2,17,15) = (/&
&6.3845E+01_JPRB,6.3808E+01_JPRB,4.8400E+01_JPRB,3.2984E+01_JPRB,1.7690E+01_JPRB,1.2970E+01_JPRB/)
KBO( :, 3,17,15) = (/&
&6.4023E+01_JPRB,6.3985E+01_JPRB,4.8498E+01_JPRB,3.2989E+01_JPRB,1.7656E+01_JPRB,1.2620E+01_JPRB/)
KBO( :, 4,17,15) = (/&
&6.4166E+01_JPRB,6.4129E+01_JPRB,4.8557E+01_JPRB,3.2962E+01_JPRB,1.7567E+01_JPRB,1.2436E+01_JPRB/)
KBO( :, 5,17,15) = (/&
&6.4111E+01_JPRB,6.4073E+01_JPRB,4.8467E+01_JPRB,3.2855E+01_JPRB,1.7451E+01_JPRB,1.2281E+01_JPRB/)
KBO( :, 1,18,15) = (/&
&7.3440E+01_JPRB,7.3397E+01_JPRB,5.5592E+01_JPRB,3.7776E+01_JPRB,2.0119E+01_JPRB,1.5329E+01_JPRB/)
KBO( :, 2,18,15) = (/&
&7.3743E+01_JPRB,7.3700E+01_JPRB,5.5787E+01_JPRB,3.7865E+01_JPRB,2.0169E+01_JPRB,1.4924E+01_JPRB/)
KBO( :, 3,18,15) = (/&
&7.3962E+01_JPRB,7.3919E+01_JPRB,5.5904E+01_JPRB,3.7908E+01_JPRB,2.0135E+01_JPRB,1.4518E+01_JPRB/)
KBO( :, 4,18,15) = (/&
&7.3953E+01_JPRB,7.3909E+01_JPRB,5.5863E+01_JPRB,3.7855E+01_JPRB,2.0062E+01_JPRB,1.4197E+01_JPRB/)
KBO( :, 5,18,15) = (/&
&7.3825E+01_JPRB,7.3781E+01_JPRB,5.5741E+01_JPRB,3.7729E+01_JPRB,1.9926E+01_JPRB,1.3956E+01_JPRB/)
KBO( :, 1,19,15) = (/&
&8.4462E+01_JPRB,8.4413E+01_JPRB,6.3820E+01_JPRB,4.3253E+01_JPRB,2.2902E+01_JPRB,1.7600E+01_JPRB/)
KBO( :, 2,19,15) = (/&
&8.4860E+01_JPRB,8.4810E+01_JPRB,6.4094E+01_JPRB,4.3382E+01_JPRB,2.2923E+01_JPRB,1.7125E+01_JPRB/)
KBO( :, 3,19,15) = (/&
&8.4963E+01_JPRB,8.4913E+01_JPRB,6.4146E+01_JPRB,4.3401E+01_JPRB,2.2894E+01_JPRB,1.6619E+01_JPRB/)
KBO( :, 4,19,15) = (/&
&8.4919E+01_JPRB,8.4869E+01_JPRB,6.4089E+01_JPRB,4.3332E+01_JPRB,2.2791E+01_JPRB,1.6133E+01_JPRB/)
KBO( :, 5,19,15) = (/&
&8.4612E+01_JPRB,8.4563E+01_JPRB,6.3846E+01_JPRB,4.3142E+01_JPRB,2.2633E+01_JPRB,1.5830E+01_JPRB/)
KBO( :, 1,20,15) = (/&
&9.7043E+01_JPRB,9.6986E+01_JPRB,7.3234E+01_JPRB,4.9485E+01_JPRB,2.5962E+01_JPRB,2.0077E+01_JPRB/)
KBO( :, 2,20,15) = (/&
&9.7332E+01_JPRB,9.7275E+01_JPRB,7.3444E+01_JPRB,4.9611E+01_JPRB,2.5984E+01_JPRB,1.9505E+01_JPRB/)
KBO( :, 3,20,15) = (/&
&9.7370E+01_JPRB,9.7313E+01_JPRB,7.3448E+01_JPRB,4.9583E+01_JPRB,2.5915E+01_JPRB,1.8890E+01_JPRB/)
KBO( :, 4,20,15) = (/&
&9.7125E+01_JPRB,9.7068E+01_JPRB,7.3251E+01_JPRB,4.9424E+01_JPRB,2.5774E+01_JPRB,1.8285E+01_JPRB/)
KBO( :, 5,20,15) = (/&
&9.6643E+01_JPRB,9.6586E+01_JPRB,7.2853E+01_JPRB,4.9111E+01_JPRB,2.5548E+01_JPRB,1.7915E+01_JPRB/)
KBO( :, 1,21,15) = (/&
&1.1092E+02_JPRB,1.1085E+02_JPRB,8.3649E+01_JPRB,5.6418E+01_JPRB,2.9378E+01_JPRB,2.2812E+01_JPRB/)
KBO( :, 2,21,15) = (/&
&1.1109E+02_JPRB,1.1103E+02_JPRB,8.3756E+01_JPRB,5.6460E+01_JPRB,2.9344E+01_JPRB,2.2156E+01_JPRB/)
KBO( :, 3,21,15) = (/&
&1.1096E+02_JPRB,1.1089E+02_JPRB,8.3624E+01_JPRB,5.6337E+01_JPRB,2.9225E+01_JPRB,2.1484E+01_JPRB/)
KBO( :, 4,21,15) = (/&
&1.1048E+02_JPRB,1.1042E+02_JPRB,8.3238E+01_JPRB,5.6034E+01_JPRB,2.9000E+01_JPRB,2.0793E+01_JPRB/)
KBO( :, 5,21,15) = (/&
&1.0971E+02_JPRB,1.0964E+02_JPRB,8.2635E+01_JPRB,5.5599E+01_JPRB,2.8723E+01_JPRB,2.0338E+01_JPRB/)
KBO( :, 1,22,15) = (/&
&1.2596E+02_JPRB,1.2589E+02_JPRB,9.4893E+01_JPRB,6.3871E+01_JPRB,3.3059E+01_JPRB,2.5998E+01_JPRB/)
KBO( :, 2,22,15) = (/&
&1.2587E+02_JPRB,1.2580E+02_JPRB,9.4816E+01_JPRB,6.3793E+01_JPRB,3.2943E+01_JPRB,2.5227E+01_JPRB/)
KBO( :, 3,22,15) = (/&
&1.2541E+02_JPRB,1.2533E+02_JPRB,9.4434E+01_JPRB,6.3497E+01_JPRB,3.2730E+01_JPRB,2.4435E+01_JPRB/)
KBO( :, 4,22,15) = (/&
&1.2461E+02_JPRB,1.2453E+02_JPRB,9.3802E+01_JPRB,6.3040E+01_JPRB,3.2441E+01_JPRB,2.3619E+01_JPRB/)
KBO( :, 5,22,15) = (/&
&1.2345E+02_JPRB,1.2338E+02_JPRB,9.2915E+01_JPRB,6.2412E+01_JPRB,3.2063E+01_JPRB,2.3036E+01_JPRB/)
KBO( :, 1,23,15) = (/&
&1.4197E+02_JPRB,1.4188E+02_JPRB,1.0687E+02_JPRB,7.1809E+01_JPRB,3.7052E+01_JPRB,2.9587E+01_JPRB/)
KBO( :, 2,23,15) = (/&
&1.4145E+02_JPRB,1.4137E+02_JPRB,1.0646E+02_JPRB,7.1497E+01_JPRB,3.6788E+01_JPRB,2.8648E+01_JPRB/)
KBO( :, 3,23,15) = (/&
&1.4055E+02_JPRB,1.4047E+02_JPRB,1.0576E+02_JPRB,7.1003E+01_JPRB,3.6445E+01_JPRB,2.7684E+01_JPRB/)
KBO( :, 4,23,15) = (/&
&1.3924E+02_JPRB,1.3916E+02_JPRB,1.0475E+02_JPRB,7.0305E+01_JPRB,3.6030E+01_JPRB,2.6707E+01_JPRB/)
KBO( :, 5,23,15) = (/&
&1.3763E+02_JPRB,1.3754E+02_JPRB,1.0352E+02_JPRB,6.9448E+01_JPRB,3.5536E+01_JPRB,2.5941E+01_JPRB/)
KBO( :, 1,24,15) = (/&
&1.5875E+02_JPRB,1.5866E+02_JPRB,1.1943E+02_JPRB,8.0138E+01_JPRB,4.1339E+01_JPRB,3.3488E+01_JPRB/)
KBO( :, 2,24,15) = (/&
&1.5772E+02_JPRB,1.5762E+02_JPRB,1.1862E+02_JPRB,7.9566E+01_JPRB,4.0871E+01_JPRB,3.2326E+01_JPRB/)
KBO( :, 3,24,15) = (/&
&1.5618E+02_JPRB,1.5608E+02_JPRB,1.1744E+02_JPRB,7.8741E+01_JPRB,4.0347E+01_JPRB,3.1135E+01_JPRB/)
KBO( :, 4,24,15) = (/&
&1.5432E+02_JPRB,1.5423E+02_JPRB,1.1603E+02_JPRB,7.7772E+01_JPRB,3.9739E+01_JPRB,2.9970E+01_JPRB/)
KBO( :, 5,24,15) = (/&
&1.5201E+02_JPRB,1.5192E+02_JPRB,1.1428E+02_JPRB,7.6577E+01_JPRB,3.9078E+01_JPRB,2.8958E+01_JPRB/)
KBO( :, 1,25,15) = (/&
&1.7605E+02_JPRB,1.7595E+02_JPRB,1.3237E+02_JPRB,8.8710E+01_JPRB,4.5816E+01_JPRB,3.7592E+01_JPRB/)
KBO( :, 2,25,15) = (/&
&1.7422E+02_JPRB,1.7412E+02_JPRB,1.3097E+02_JPRB,8.7758E+01_JPRB,4.5131E+01_JPRB,3.6159E+01_JPRB/)
KBO( :, 3,25,15) = (/&
&1.7201E+02_JPRB,1.7191E+02_JPRB,1.2929E+02_JPRB,8.6602E+01_JPRB,4.4346E+01_JPRB,3.4734E+01_JPRB/)
KBO( :, 4,25,15) = (/&
&1.6938E+02_JPRB,1.6928E+02_JPRB,1.2730E+02_JPRB,8.5245E+01_JPRB,4.3518E+01_JPRB,3.3295E+01_JPRB/)
KBO( :, 5,25,15) = (/&
&1.6630E+02_JPRB,1.6620E+02_JPRB,1.2498E+02_JPRB,8.3665E+01_JPRB,4.2629E+01_JPRB,3.2020E+01_JPRB/)
KBO( :, 1,26,15) = (/&
&1.9312E+02_JPRB,1.9300E+02_JPRB,1.4513E+02_JPRB,9.7167E+01_JPRB,5.0350E+01_JPRB,4.1741E+01_JPRB/)
KBO( :, 2,26,15) = (/&
&1.9055E+02_JPRB,1.9044E+02_JPRB,1.4319E+02_JPRB,9.5848E+01_JPRB,4.9379E+01_JPRB,3.9996E+01_JPRB/)
KBO( :, 3,26,15) = (/&
&1.8750E+02_JPRB,1.8738E+02_JPRB,1.4088E+02_JPRB,9.4283E+01_JPRB,4.8328E+01_JPRB,3.8277E+01_JPRB/)
KBO( :, 4,26,15) = (/&
&1.8390E+02_JPRB,1.8379E+02_JPRB,1.3817E+02_JPRB,9.2456E+01_JPRB,4.7225E+01_JPRB,3.6567E+01_JPRB/)
KBO( :, 5,26,15) = (/&
&1.8004E+02_JPRB,1.7993E+02_JPRB,1.3525E+02_JPRB,9.0479E+01_JPRB,4.6075E+01_JPRB,3.5023E+01_JPRB/)
KBO( :, 1,27,15) = (/&
&2.0962E+02_JPRB,2.0950E+02_JPRB,1.5747E+02_JPRB,1.0535E+02_JPRB,5.4802E+01_JPRB,4.5812E+01_JPRB/)
KBO( :, 2,27,15) = (/&
&2.0617E+02_JPRB,2.0605E+02_JPRB,1.5487E+02_JPRB,1.0359E+02_JPRB,5.3500E+01_JPRB,4.3722E+01_JPRB/)
KBO( :, 3,27,15) = (/&
&2.0210E+02_JPRB,2.0198E+02_JPRB,1.5180E+02_JPRB,1.0153E+02_JPRB,5.2160E+01_JPRB,4.1668E+01_JPRB/)
KBO( :, 4,27,15) = (/&
&1.9765E+02_JPRB,1.9753E+02_JPRB,1.4844E+02_JPRB,9.9264E+01_JPRB,5.0764E+01_JPRB,3.9657E+01_JPRB/)
KBO( :, 5,27,15) = (/&
&1.9285E+02_JPRB,1.9273E+02_JPRB,1.4483E+02_JPRB,9.6837E+01_JPRB,4.9332E+01_JPRB,3.7870E+01_JPRB/)
KBO( :, 1,28,15) = (/&
&2.2504E+02_JPRB,2.2491E+02_JPRB,1.6900E+02_JPRB,1.1299E+02_JPRB,5.9023E+01_JPRB,4.9671E+01_JPRB/)
KBO( :, 2,28,15) = (/&
&2.2060E+02_JPRB,2.2047E+02_JPRB,1.6566E+02_JPRB,1.1075E+02_JPRB,5.7389E+01_JPRB,4.7215E+01_JPRB/)
KBO( :, 3,28,15) = (/&
&2.1560E+02_JPRB,2.1547E+02_JPRB,1.6190E+02_JPRB,1.0822E+02_JPRB,5.5706E+01_JPRB,4.4816E+01_JPRB/)
KBO( :, 4,28,15) = (/&
&2.1015E+02_JPRB,2.1002E+02_JPRB,1.5779E+02_JPRB,1.0547E+02_JPRB,5.4003E+01_JPRB,4.2483E+01_JPRB/)
KBO( :, 5,28,15) = (/&
&2.0436E+02_JPRB,2.0424E+02_JPRB,1.5344E+02_JPRB,1.0255E+02_JPRB,5.2316E+01_JPRB,4.0478E+01_JPRB/)
KBO( :, 1,29,15) = (/&
&2.3909E+02_JPRB,2.3895E+02_JPRB,1.7950E+02_JPRB,1.1994E+02_JPRB,6.2884E+01_JPRB,5.3166E+01_JPRB/)
KBO( :, 2,29,15) = (/&
&2.3356E+02_JPRB,2.3342E+02_JPRB,1.7535E+02_JPRB,1.1717E+02_JPRB,6.0903E+01_JPRB,5.0319E+01_JPRB/)
KBO( :, 3,29,15) = (/&
&2.2760E+02_JPRB,2.2747E+02_JPRB,1.7088E+02_JPRB,1.1417E+02_JPRB,5.8870E+01_JPRB,4.7588E+01_JPRB/)
KBO( :, 4,29,15) = (/&
&2.2117E+02_JPRB,2.2104E+02_JPRB,1.6604E+02_JPRB,1.1094E+02_JPRB,5.6871E+01_JPRB,4.4984E+01_JPRB/)
KBO( :, 5,29,15) = (/&
&2.1449E+02_JPRB,2.1436E+02_JPRB,1.6102E+02_JPRB,1.0757E+02_JPRB,5.4912E+01_JPRB,4.2890E+01_JPRB/)
KBO( :, 1,30,15) = (/&
&2.5146E+02_JPRB,2.5131E+02_JPRB,1.8876E+02_JPRB,1.2608E+02_JPRB,6.6304E+01_JPRB,5.6220E+01_JPRB/)
KBO( :, 2,30,15) = (/&
&2.4482E+02_JPRB,2.4467E+02_JPRB,1.8377E+02_JPRB,1.2275E+02_JPRB,6.3959E+01_JPRB,5.3007E+01_JPRB/)
KBO( :, 3,30,15) = (/&
&2.3792E+02_JPRB,2.3777E+02_JPRB,1.7859E+02_JPRB,1.1929E+02_JPRB,6.1625E+01_JPRB,4.9952E+01_JPRB/)
KBO( :, 4,30,15) = (/&
&2.3061E+02_JPRB,2.3047E+02_JPRB,1.7311E+02_JPRB,1.1562E+02_JPRB,5.9353E+01_JPRB,4.7238E+01_JPRB/)
KBO( :, 5,30,15) = (/&
&2.2308E+02_JPRB,2.2295E+02_JPRB,1.6746E+02_JPRB,1.1184E+02_JPRB,5.7116E+01_JPRB,4.4978E+01_JPRB/)
KBO( :, 1,31,15) = (/&
&2.6202E+02_JPRB,2.6186E+02_JPRB,1.9666E+02_JPRB,1.3132E+02_JPRB,6.9199E+01_JPRB,5.8789E+01_JPRB/)
KBO( :, 2,31,15) = (/&
&2.5437E+02_JPRB,2.5422E+02_JPRB,1.9092E+02_JPRB,1.2749E+02_JPRB,6.6513E+01_JPRB,5.5233E+01_JPRB/)
KBO( :, 3,31,15) = (/&
&2.4648E+02_JPRB,2.4634E+02_JPRB,1.8501E+02_JPRB,1.2354E+02_JPRB,6.3925E+01_JPRB,5.1946E+01_JPRB/)
KBO( :, 4,31,15) = (/&
&2.3838E+02_JPRB,2.3824E+02_JPRB,1.7892E+02_JPRB,1.1948E+02_JPRB,6.1400E+01_JPRB,4.9329E+01_JPRB/)
KBO( :, 5,31,15) = (/&
&2.3010E+02_JPRB,2.2996E+02_JPRB,1.7271E+02_JPRB,1.1532E+02_JPRB,5.8925E+01_JPRB,4.6712E+01_JPRB/)
KBO( :, 1,32,15) = (/&
&2.7074E+02_JPRB,2.7057E+02_JPRB,2.0319E+02_JPRB,1.3565E+02_JPRB,7.1571E+01_JPRB,6.0821E+01_JPRB/)
KBO( :, 2,32,15) = (/&
&2.6218E+02_JPRB,2.6203E+02_JPRB,1.9677E+02_JPRB,1.3137E+02_JPRB,6.8590E+01_JPRB,5.6967E+01_JPRB/)
KBO( :, 3,32,15) = (/&
&2.5343E+02_JPRB,2.5328E+02_JPRB,1.9020E+02_JPRB,1.2698E+02_JPRB,6.5765E+01_JPRB,5.3801E+01_JPRB/)
KBO( :, 4,32,15) = (/&
&2.4457E+02_JPRB,2.4443E+02_JPRB,1.8356E+02_JPRB,1.2255E+02_JPRB,6.3014E+01_JPRB,5.0945E+01_JPRB/)
KBO( :, 5,32,15) = (/&
&2.3559E+02_JPRB,2.3545E+02_JPRB,1.7681E+02_JPRB,1.1805E+02_JPRB,6.0339E+01_JPRB,4.8062E+01_JPRB/)
KBO( :, 1,33,15) = (/&
&2.7764E+02_JPRB,2.7748E+02_JPRB,2.0836E+02_JPRB,1.3907E+02_JPRB,7.3436E+01_JPRB,6.2345E+01_JPRB/)
KBO( :, 2,33,15) = (/&
&2.6829E+02_JPRB,2.6813E+02_JPRB,2.0135E+02_JPRB,1.3440E+02_JPRB,7.0216E+01_JPRB,5.8526E+01_JPRB/)
KBO( :, 3,33,15) = (/&
&2.5890E+02_JPRB,2.5874E+02_JPRB,1.9430E+02_JPRB,1.2970E+02_JPRB,6.7179E+01_JPRB,5.5377E+01_JPRB/)
KBO( :, 4,33,15) = (/&
&2.4933E+02_JPRB,2.4918E+02_JPRB,1.8712E+02_JPRB,1.2490E+02_JPRB,6.4220E+01_JPRB,5.2156E+01_JPRB/)
KBO( :, 5,33,15) = (/&
&2.3975E+02_JPRB,2.3960E+02_JPRB,1.7993E+02_JPRB,1.2011E+02_JPRB,6.1401E+01_JPRB,4.9280E+01_JPRB/)
KBO( :, 1,34,15) = (/&
&2.8330E+02_JPRB,2.8313E+02_JPRB,2.1259E+02_JPRB,1.4188E+02_JPRB,7.4943E+01_JPRB,6.3611E+01_JPRB/)
KBO( :, 2,34,15) = (/&
&2.7328E+02_JPRB,2.7312E+02_JPRB,2.0508E+02_JPRB,1.3687E+02_JPRB,7.1539E+01_JPRB,6.0040E+01_JPRB/)
KBO( :, 3,34,15) = (/&
&2.6322E+02_JPRB,2.6306E+02_JPRB,1.9753E+02_JPRB,1.3184E+02_JPRB,6.8302E+01_JPRB,5.6531E+01_JPRB/)
KBO( :, 4,34,15) = (/&
&2.5315E+02_JPRB,2.5300E+02_JPRB,1.8997E+02_JPRB,1.2680E+02_JPRB,6.5194E+01_JPRB,5.3134E+01_JPRB/)
KBO( :, 5,34,15) = (/&
&2.4305E+02_JPRB,2.4290E+02_JPRB,1.8239E+02_JPRB,1.2174E+02_JPRB,6.2238E+01_JPRB,5.0964E+01_JPRB/)
KBO( :, 1,35,15) = (/&
&2.8856E+02_JPRB,2.8838E+02_JPRB,2.1653E+02_JPRB,1.4450E+02_JPRB,7.6402E+01_JPRB,6.5174E+01_JPRB/)
KBO( :, 2,35,15) = (/&
&2.7804E+02_JPRB,2.7787E+02_JPRB,2.0864E+02_JPRB,1.3924E+02_JPRB,7.2828E+01_JPRB,6.1468E+01_JPRB/)
KBO( :, 3,35,15) = (/&
&2.6749E+02_JPRB,2.6733E+02_JPRB,2.0072E+02_JPRB,1.3396E+02_JPRB,6.9428E+01_JPRB,5.7687E+01_JPRB/)
KBO( :, 4,35,15) = (/&
&2.5691E+02_JPRB,2.5675E+02_JPRB,1.9278E+02_JPRB,1.2866E+02_JPRB,6.6172E+01_JPRB,5.4537E+01_JPRB/)
KBO( :, 5,35,15) = (/&
&2.4636E+02_JPRB,2.4621E+02_JPRB,1.8487E+02_JPRB,1.2339E+02_JPRB,6.3093E+01_JPRB,5.3102E+01_JPRB/)
KBO( :, 1,36,15) = (/&
&2.9394E+02_JPRB,2.9376E+02_JPRB,2.2055E+02_JPRB,1.4717E+02_JPRB,7.7976E+01_JPRB,6.6997E+01_JPRB/)
KBO( :, 2,36,15) = (/&
&2.8294E+02_JPRB,2.8277E+02_JPRB,2.1230E+02_JPRB,1.4167E+02_JPRB,7.4208E+01_JPRB,6.2977E+01_JPRB/)
KBO( :, 3,36,15) = (/&
&2.7194E+02_JPRB,2.7178E+02_JPRB,2.0405E+02_JPRB,1.3617E+02_JPRB,7.0657E+01_JPRB,5.9032E+01_JPRB/)
KBO( :, 4,36,15) = (/&
&2.6092E+02_JPRB,2.6077E+02_JPRB,1.9579E+02_JPRB,1.3066E+02_JPRB,6.7258E+01_JPRB,5.6406E+01_JPRB/)
KBO( :, 5,36,15) = (/&
&2.5003E+02_JPRB,2.4988E+02_JPRB,1.8762E+02_JPRB,1.2521E+02_JPRB,6.4068E+01_JPRB,5.5624E+01_JPRB/)
KBO( :, 1,37,15) = (/&
&3.0017E+02_JPRB,2.9999E+02_JPRB,2.2523E+02_JPRB,1.5028E+02_JPRB,7.9918E+01_JPRB,6.9171E+01_JPRB/)
KBO( :, 2,37,15) = (/&
&2.8870E+02_JPRB,2.8853E+02_JPRB,2.1662E+02_JPRB,1.4454E+02_JPRB,7.5932E+01_JPRB,6.4872E+01_JPRB/)
KBO( :, 3,37,15) = (/&
&2.7736E+02_JPRB,2.7719E+02_JPRB,2.0811E+02_JPRB,1.3887E+02_JPRB,7.2229E+01_JPRB,6.0792E+01_JPRB/)
KBO( :, 4,37,15) = (/&
&2.6599E+02_JPRB,2.6584E+02_JPRB,1.9958E+02_JPRB,1.3319E+02_JPRB,6.8687E+01_JPRB,5.8518E+01_JPRB/)
KBO( :, 5,37,15) = (/&
&2.5476E+02_JPRB,2.5461E+02_JPRB,1.9116E+02_JPRB,1.2757E+02_JPRB,6.5367E+01_JPRB,5.8059E+01_JPRB/)
KBO( :, 1,38,15) = (/&
&3.0587E+02_JPRB,3.0569E+02_JPRB,2.2949E+02_JPRB,1.5312E+02_JPRB,8.1725E+01_JPRB,7.1248E+01_JPRB/)
KBO( :, 2,38,15) = (/&
&2.9408E+02_JPRB,2.9390E+02_JPRB,2.2065E+02_JPRB,1.4722E+02_JPRB,7.7560E+01_JPRB,6.6691E+01_JPRB/)
KBO( :, 3,38,15) = (/&
&2.8234E+02_JPRB,2.8218E+02_JPRB,2.1184E+02_JPRB,1.4135E+02_JPRB,7.3693E+01_JPRB,6.2607E+01_JPRB/)
KBO( :, 4,38,15) = (/&
&2.7064E+02_JPRB,2.7048E+02_JPRB,2.0306E+02_JPRB,1.3550E+02_JPRB,7.0023E+01_JPRB,6.0914E+01_JPRB/)
KBO( :, 5,38,15) = (/&
&2.5911E+02_JPRB,2.5896E+02_JPRB,1.9442E+02_JPRB,1.2974E+02_JPRB,6.6580E+01_JPRB,6.0840E+01_JPRB/)
KBO( :, 1,39,15) = (/&
&3.1101E+02_JPRB,3.1082E+02_JPRB,2.3334E+02_JPRB,1.5567E+02_JPRB,8.3378E+01_JPRB,7.3218E+01_JPRB/)
KBO( :, 2,39,15) = (/&
&2.9887E+02_JPRB,2.9869E+02_JPRB,2.2423E+02_JPRB,1.4960E+02_JPRB,7.9045E+01_JPRB,6.8519E+01_JPRB/)
KBO( :, 3,39,15) = (/&
&2.8683E+02_JPRB,2.8666E+02_JPRB,2.1520E+02_JPRB,1.4359E+02_JPRB,7.5024E+01_JPRB,6.4735E+01_JPRB/)
KBO( :, 4,39,15) = (/&
&2.7487E+02_JPRB,2.7471E+02_JPRB,2.0623E+02_JPRB,1.3761E+02_JPRB,7.1242E+01_JPRB,6.3858E+01_JPRB/)
KBO( :, 5,39,15) = (/&
&2.6303E+02_JPRB,2.6287E+02_JPRB,1.9735E+02_JPRB,1.3169E+02_JPRB,6.7680E+01_JPRB,6.4377E+01_JPRB/)
KBO( :, 1,40,15) = (/&
&3.1694E+02_JPRB,3.1675E+02_JPRB,2.3777E+02_JPRB,1.5862E+02_JPRB,8.5396E+01_JPRB,7.5421E+01_JPRB/)
KBO( :, 2,40,15) = (/&
&3.0448E+02_JPRB,3.0430E+02_JPRB,2.2843E+02_JPRB,1.5240E+02_JPRB,8.0839E+01_JPRB,7.0612E+01_JPRB/)
KBO( :, 3,40,15) = (/&
&2.9221E+02_JPRB,2.9204E+02_JPRB,2.1923E+02_JPRB,1.4627E+02_JPRB,7.6677E+01_JPRB,6.6660E+01_JPRB/)
KBO( :, 4,40,15) = (/&
&2.8000E+02_JPRB,2.7983E+02_JPRB,2.1007E+02_JPRB,1.4017E+02_JPRB,7.2757E+01_JPRB,6.5710E+01_JPRB/)
KBO( :, 5,40,15) = (/&
&2.6789E+02_JPRB,2.6773E+02_JPRB,2.0099E+02_JPRB,1.3412E+02_JPRB,6.9075E+01_JPRB,6.6414E+01_JPRB/)
KBO( :, 1,41,15) = (/&
&3.2263E+02_JPRB,3.2244E+02_JPRB,2.4204E+02_JPRB,1.6146E+02_JPRB,8.7409E+01_JPRB,7.7606E+01_JPRB/)
KBO( :, 2,41,15) = (/&
&3.0995E+02_JPRB,3.0976E+02_JPRB,2.3253E+02_JPRB,1.5513E+02_JPRB,8.2644E+01_JPRB,7.2713E+01_JPRB/)
KBO( :, 3,41,15) = (/&
&2.9738E+02_JPRB,2.9720E+02_JPRB,2.2311E+02_JPRB,1.4885E+02_JPRB,7.8306E+01_JPRB,6.8571E+01_JPRB/)
KBO( :, 4,41,15) = (/&
&2.8499E+02_JPRB,2.8482E+02_JPRB,2.1382E+02_JPRB,1.4266E+02_JPRB,7.4270E+01_JPRB,6.7462E+01_JPRB/)
KBO( :, 5,41,15) = (/&
&2.7266E+02_JPRB,2.7250E+02_JPRB,2.0456E+02_JPRB,1.3649E+02_JPRB,7.0464E+01_JPRB,6.8326E+01_JPRB/)
KBO( :, 1,42,15) = (/&
&3.2806E+02_JPRB,3.2786E+02_JPRB,2.4610E+02_JPRB,1.6416E+02_JPRB,8.9382E+01_JPRB,7.9783E+01_JPRB/)
KBO( :, 2,42,15) = (/&
&3.1513E+02_JPRB,3.1494E+02_JPRB,2.3641E+02_JPRB,1.5771E+02_JPRB,8.4411E+01_JPRB,7.4828E+01_JPRB/)
KBO( :, 3,42,15) = (/&
&3.0236E+02_JPRB,3.0217E+02_JPRB,2.2683E+02_JPRB,1.5133E+02_JPRB,7.9899E+01_JPRB,7.0566E+01_JPRB/)
KBO( :, 4,42,15) = (/&
&2.8974E+02_JPRB,2.8956E+02_JPRB,2.1737E+02_JPRB,1.4502E+02_JPRB,7.5728E+01_JPRB,6.9377E+01_JPRB/)
KBO( :, 5,42,15) = (/&
&2.7725E+02_JPRB,2.7708E+02_JPRB,2.0800E+02_JPRB,1.3878E+02_JPRB,7.1813E+01_JPRB,7.0507E+01_JPRB/)
KBO( :, 1,43,15) = (/&
&3.3393E+02_JPRB,3.3373E+02_JPRB,2.5050E+02_JPRB,1.6709E+02_JPRB,9.1659E+01_JPRB,8.2181E+01_JPRB/)
KBO( :, 2,43,15) = (/&
&3.2087E+02_JPRB,3.2068E+02_JPRB,2.4071E+02_JPRB,1.6058E+02_JPRB,8.6435E+01_JPRB,7.7203E+01_JPRB/)
KBO( :, 3,43,15) = (/&
&3.0784E+02_JPRB,3.0766E+02_JPRB,2.3094E+02_JPRB,1.5407E+02_JPRB,8.1705E+01_JPRB,7.2734E+01_JPRB/)
KBO( :, 4,43,15) = (/&
&2.9498E+02_JPRB,2.9480E+02_JPRB,2.2130E+02_JPRB,1.4764E+02_JPRB,7.7383E+01_JPRB,7.1244E+01_JPRB/)
KBO( :, 5,43,15) = (/&
&2.8236E+02_JPRB,2.8219E+02_JPRB,2.1184E+02_JPRB,1.4134E+02_JPRB,7.3355E+01_JPRB,7.2525E+01_JPRB/)
KBO( :, 1,44,15) = (/&
&3.3993E+02_JPRB,3.3973E+02_JPRB,2.5500E+02_JPRB,1.7009E+02_JPRB,9.4079E+01_JPRB,8.4777E+01_JPRB/)
KBO( :, 2,44,15) = (/&
&3.2668E+02_JPRB,3.2648E+02_JPRB,2.4506E+02_JPRB,1.6347E+02_JPRB,8.8568E+01_JPRB,7.9722E+01_JPRB/)
KBO( :, 3,44,15) = (/&
&3.1350E+02_JPRB,3.1331E+02_JPRB,2.3519E+02_JPRB,1.5690E+02_JPRB,8.3629E+01_JPRB,7.5073E+01_JPRB/)
KBO( :, 4,44,15) = (/&
&3.0048E+02_JPRB,3.0030E+02_JPRB,2.2542E+02_JPRB,1.5039E+02_JPRB,7.9147E+01_JPRB,7.3210E+01_JPRB/)
KBO( :, 5,44,15) = (/&
&2.8768E+02_JPRB,2.8750E+02_JPRB,2.1582E+02_JPRB,1.4399E+02_JPRB,7.4989E+01_JPRB,7.4615E+01_JPRB/)
KBO( :, 1,45,15) = (/&
&3.4570E+02_JPRB,3.4549E+02_JPRB,2.5932E+02_JPRB,1.7296E+02_JPRB,9.6495E+01_JPRB,8.7516E+01_JPRB/)
KBO( :, 2,45,15) = (/&
&3.3235E+02_JPRB,3.3215E+02_JPRB,2.4931E+02_JPRB,1.6630E+02_JPRB,9.0736E+01_JPRB,8.2360E+01_JPRB/)
KBO( :, 3,45,15) = (/&
&3.1903E+02_JPRB,3.1884E+02_JPRB,2.3933E+02_JPRB,1.5965E+02_JPRB,8.5580E+01_JPRB,7.7592E+01_JPRB/)
KBO( :, 4,45,15) = (/&
&3.0583E+02_JPRB,3.0564E+02_JPRB,2.2943E+02_JPRB,1.5306E+02_JPRB,8.0904E+01_JPRB,7.5512E+01_JPRB/)
KBO( :, 5,45,15) = (/&
&2.9285E+02_JPRB,2.9267E+02_JPRB,2.1969E+02_JPRB,1.4657E+02_JPRB,7.6606E+01_JPRB,7.7136E+01_JPRB/)
KBO( :, 1,46,15) = (/&
&3.5162E+02_JPRB,3.5141E+02_JPRB,2.6376E+02_JPRB,1.7592E+02_JPRB,9.9116E+01_JPRB,9.0486E+01_JPRB/)
KBO( :, 2,46,15) = (/&
&3.3821E+02_JPRB,3.3800E+02_JPRB,2.5370E+02_JPRB,1.6922E+02_JPRB,9.3089E+01_JPRB,8.5193E+01_JPRB/)
KBO( :, 3,46,15) = (/&
&3.2475E+02_JPRB,3.2455E+02_JPRB,2.4361E+02_JPRB,1.6250E+02_JPRB,8.7670E+01_JPRB,8.0271E+01_JPRB/)
KBO( :, 4,46,15) = (/&
&3.1144E+02_JPRB,3.1126E+02_JPRB,2.3364E+02_JPRB,1.5586E+02_JPRB,8.2789E+01_JPRB,7.7967E+01_JPRB/)
KBO( :, 5,46,15) = (/&
&2.9826E+02_JPRB,2.9808E+02_JPRB,2.2376E+02_JPRB,1.4928E+02_JPRB,7.8339E+01_JPRB,7.9667E+01_JPRB/)
KBO( :, 1,47,15) = (/&
&3.5795E+02_JPRB,3.5773E+02_JPRB,2.6850E+02_JPRB,1.7907E+02_JPRB,1.0208E+02_JPRB,9.3825E+01_JPRB/)
KBO( :, 2,47,15) = (/&
&3.4453E+02_JPRB,3.4432E+02_JPRB,2.5844E+02_JPRB,1.7237E+02_JPRB,9.5731E+01_JPRB,8.8246E+01_JPRB/)
KBO( :, 3,47,15) = (/&
&3.3096E+02_JPRB,3.3076E+02_JPRB,2.4827E+02_JPRB,1.6560E+02_JPRB,9.0023E+01_JPRB,8.3072E+01_JPRB/)
KBO( :, 4,47,15) = (/&
&3.1751E+02_JPRB,3.1732E+02_JPRB,2.3819E+02_JPRB,1.5889E+02_JPRB,8.4913E+01_JPRB,8.0301E+01_JPRB/)
KBO( :, 5,47,15) = (/&
&3.0419E+02_JPRB,3.0401E+02_JPRB,2.2820E+02_JPRB,1.5224E+02_JPRB,8.0275E+01_JPRB,8.1585E+01_JPRB/)
KBO( :, 1,48,15) = (/&
&3.6405E+02_JPRB,3.6383E+02_JPRB,2.7307E+02_JPRB,1.8212E+02_JPRB,1.0516E+02_JPRB,9.7509E+01_JPRB/)
KBO( :, 2,48,15) = (/&
&3.5068E+02_JPRB,3.5047E+02_JPRB,2.6305E+02_JPRB,1.7544E+02_JPRB,9.8444E+01_JPRB,9.1443E+01_JPRB/)
KBO( :, 3,48,15) = (/&
&3.3709E+02_JPRB,3.3688E+02_JPRB,2.5286E+02_JPRB,1.6866E+02_JPRB,9.2465E+01_JPRB,8.6144E+01_JPRB/)
KBO( :, 4,48,15) = (/&
&3.2352E+02_JPRB,3.2332E+02_JPRB,2.4269E+02_JPRB,1.6188E+02_JPRB,8.7099E+01_JPRB,8.3145E+01_JPRB/)
KBO( :, 5,48,15) = (/&
&3.1006E+02_JPRB,3.0987E+02_JPRB,2.3260E+02_JPRB,1.5516E+02_JPRB,8.2249E+01_JPRB,8.4244E+01_JPRB/)
KBO( :, 1,49,15) = (/&
&3.7003E+02_JPRB,3.6981E+02_JPRB,2.7756E+02_JPRB,1.8510E+02_JPRB,1.0838E+02_JPRB,1.0148E+02_JPRB/)
KBO( :, 2,49,15) = (/&
&3.5675E+02_JPRB,3.5654E+02_JPRB,2.6761E+02_JPRB,1.7847E+02_JPRB,1.0127E+02_JPRB,9.4886E+01_JPRB/)
KBO( :, 3,49,15) = (/&
&3.4318E+02_JPRB,3.4298E+02_JPRB,2.5743E+02_JPRB,1.7170E+02_JPRB,9.5003E+01_JPRB,8.9591E+01_JPRB/)
KBO( :, 4,49,15) = (/&
&3.2947E+02_JPRB,3.2927E+02_JPRB,2.4715E+02_JPRB,1.6485E+02_JPRB,8.9342E+01_JPRB,8.6726E+01_JPRB/)
KBO( :, 5,49,15) = (/&
&3.1591E+02_JPRB,3.1572E+02_JPRB,2.3699E+02_JPRB,1.5809E+02_JPRB,8.4278E+01_JPRB,8.8051E+01_JPRB/)
KBO( :, 1,50,15) = (/&
&3.7556E+02_JPRB,3.7534E+02_JPRB,2.8170E+02_JPRB,1.8786E+02_JPRB,1.1154E+02_JPRB,1.0526E+02_JPRB/)
KBO( :, 2,50,15) = (/&
&3.6235E+02_JPRB,3.6213E+02_JPRB,2.7180E+02_JPRB,1.8127E+02_JPRB,1.0404E+02_JPRB,9.7933E+01_JPRB/)
KBO( :, 3,50,15) = (/&
&3.4884E+02_JPRB,3.4863E+02_JPRB,2.6167E+02_JPRB,1.7452E+02_JPRB,9.7449E+01_JPRB,9.2614E+01_JPRB/)
KBO( :, 4,50,15) = (/&
&3.3508E+02_JPRB,3.3488E+02_JPRB,2.5136E+02_JPRB,1.6766E+02_JPRB,9.1542E+01_JPRB,8.9470E+01_JPRB/)
KBO( :, 5,50,15) = (/&
&3.2141E+02_JPRB,3.2122E+02_JPRB,2.4111E+02_JPRB,1.6083E+02_JPRB,8.6254E+01_JPRB,9.0426E+01_JPRB/)
KBO( :, 1,51,15) = (/&
&3.8078E+02_JPRB,3.8056E+02_JPRB,2.8562E+02_JPRB,1.9055E+02_JPRB,1.1479E+02_JPRB,1.0898E+02_JPRB/)
KBO( :, 2,51,15) = (/&
&3.6766E+02_JPRB,3.6744E+02_JPRB,2.7578E+02_JPRB,1.8392E+02_JPRB,1.0684E+02_JPRB,1.0093E+02_JPRB/)
KBO( :, 3,51,15) = (/&
&3.5420E+02_JPRB,3.5398E+02_JPRB,2.6569E+02_JPRB,1.7719E+02_JPRB,9.9903E+01_JPRB,9.5407E+01_JPRB/)
KBO( :, 4,51,15) = (/&
&3.4048E+02_JPRB,3.4027E+02_JPRB,2.5540E+02_JPRB,1.7035E+02_JPRB,9.3766E+01_JPRB,9.1798E+01_JPRB/)
KBO( :, 5,51,15) = (/&
&3.2673E+02_JPRB,3.2653E+02_JPRB,2.4509E+02_JPRB,1.6348E+02_JPRB,8.8237E+01_JPRB,9.2138E+01_JPRB/)
KBO( :, 1,52,15) = (/&
&3.8584E+02_JPRB,3.8560E+02_JPRB,2.8941E+02_JPRB,1.9322E+02_JPRB,1.1816E+02_JPRB,1.1293E+02_JPRB/)
KBO( :, 2,52,15) = (/&
&3.7294E+02_JPRB,3.7271E+02_JPRB,2.7974E+02_JPRB,1.8654E+02_JPRB,1.0976E+02_JPRB,1.0425E+02_JPRB/)
KBO( :, 3,52,15) = (/&
&3.5951E+02_JPRB,3.5930E+02_JPRB,2.6967E+02_JPRB,1.7985E+02_JPRB,1.0246E+02_JPRB,9.8398E+01_JPRB/)
KBO( :, 4,52,15) = (/&
&3.4582E+02_JPRB,3.4561E+02_JPRB,2.5941E+02_JPRB,1.7301E+02_JPRB,9.6032E+01_JPRB,9.4572E+01_JPRB/)
KBO( :, 5,52,15) = (/&
&3.3204E+02_JPRB,3.3185E+02_JPRB,2.4908E+02_JPRB,1.6614E+02_JPRB,9.0266E+01_JPRB,9.4675E+01_JPRB/)
KBO( :, 1,53,15) = (/&
&3.9087E+02_JPRB,3.9063E+02_JPRB,2.9318E+02_JPRB,1.9599E+02_JPRB,1.2171E+02_JPRB,1.1718E+02_JPRB/)
KBO( :, 2,53,15) = (/&
&3.7802E+02_JPRB,3.7780E+02_JPRB,2.8355E+02_JPRB,1.8910E+02_JPRB,1.1281E+02_JPRB,1.0800E+02_JPRB/)
KBO( :, 3,53,15) = (/&
&3.6473E+02_JPRB,3.6451E+02_JPRB,2.7359E+02_JPRB,1.8245E+02_JPRB,1.0513E+02_JPRB,1.0177E+02_JPRB/)
KBO( :, 4,53,15) = (/&
&3.5112E+02_JPRB,3.5091E+02_JPRB,2.6338E+02_JPRB,1.7566E+02_JPRB,9.8387E+01_JPRB,9.7989E+01_JPRB/)
KBO( :, 5,53,15) = (/&
&3.3733E+02_JPRB,3.3713E+02_JPRB,2.5304E+02_JPRB,1.6878E+02_JPRB,9.2381E+01_JPRB,9.8180E+01_JPRB/)
KBO( :, 1,54,15) = (/&
&3.9531E+02_JPRB,3.9507E+02_JPRB,2.9651E+02_JPRB,1.9853E+02_JPRB,1.2515E+02_JPRB,1.2078E+02_JPRB/)
KBO( :, 2,54,15) = (/&
&3.8263E+02_JPRB,3.8240E+02_JPRB,2.8700E+02_JPRB,1.9150E+02_JPRB,1.1577E+02_JPRB,1.1118E+02_JPRB/)
KBO( :, 3,54,15) = (/&
&3.6948E+02_JPRB,3.6926E+02_JPRB,2.7715E+02_JPRB,1.8482E+02_JPRB,1.0769E+02_JPRB,1.0351E+02_JPRB/)
KBO( :, 4,54,15) = (/&
&3.5596E+02_JPRB,3.5575E+02_JPRB,2.6701E+02_JPRB,1.7807E+02_JPRB,1.0063E+02_JPRB,9.9143E+01_JPRB/)
KBO( :, 5,54,15) = (/&
&3.4214E+02_JPRB,3.4194E+02_JPRB,2.5665E+02_JPRB,1.7118E+02_JPRB,9.4395E+01_JPRB,9.8105E+01_JPRB/)
KBO( :, 1,55,15) = (/&
&3.9946E+02_JPRB,3.9922E+02_JPRB,2.9962E+02_JPRB,2.0102E+02_JPRB,1.2867E+02_JPRB,1.2425E+02_JPRB/)
KBO( :, 2,55,15) = (/&
&3.8700E+02_JPRB,3.8677E+02_JPRB,2.9028E+02_JPRB,1.9382E+02_JPRB,1.1872E+02_JPRB,1.1387E+02_JPRB/)
KBO( :, 3,55,15) = (/&
&3.7399E+02_JPRB,3.7376E+02_JPRB,2.8052E+02_JPRB,1.8707E+02_JPRB,1.1023E+02_JPRB,1.0518E+02_JPRB/)
KBO( :, 4,55,15) = (/&
&3.6056E+02_JPRB,3.6034E+02_JPRB,2.7046E+02_JPRB,1.8037E+02_JPRB,1.0287E+02_JPRB,9.9691E+01_JPRB/)
KBO( :, 5,55,15) = (/&
&3.4681E+02_JPRB,3.4660E+02_JPRB,2.6015E+02_JPRB,1.7350E+02_JPRB,9.6390E+01_JPRB,9.6621E+01_JPRB/)
KBO( :, 1,56,15) = (/&
&4.0345E+02_JPRB,4.0321E+02_JPRB,3.0261E+02_JPRB,2.0354E+02_JPRB,1.3232E+02_JPRB,1.2822E+02_JPRB/)
KBO( :, 2,56,15) = (/&
&3.9129E+02_JPRB,3.9105E+02_JPRB,2.9349E+02_JPRB,1.9619E+02_JPRB,1.2179E+02_JPRB,1.1677E+02_JPRB/)
KBO( :, 3,56,15) = (/&
&3.7839E+02_JPRB,3.7816E+02_JPRB,2.8382E+02_JPRB,1.8928E+02_JPRB,1.1288E+02_JPRB,1.0755E+02_JPRB/)
KBO( :, 4,56,15) = (/&
&3.6503E+02_JPRB,3.6481E+02_JPRB,2.7381E+02_JPRB,1.8260E+02_JPRB,1.0518E+02_JPRB,1.0056E+02_JPRB/)
KBO( :, 5,56,15) = (/&
&3.5139E+02_JPRB,3.5118E+02_JPRB,2.6358E+02_JPRB,1.7579E+02_JPRB,9.8426E+01_JPRB,9.5940E+01_JPRB/)
KBO( :, 1,57,15) = (/&
&4.0732E+02_JPRB,4.0708E+02_JPRB,3.0551E+02_JPRB,2.0612E+02_JPRB,1.3611E+02_JPRB,1.3253E+02_JPRB/)
KBO( :, 2,57,15) = (/&
&3.9551E+02_JPRB,3.9527E+02_JPRB,2.9666E+02_JPRB,1.9860E+02_JPRB,1.2505E+02_JPRB,1.2007E+02_JPRB/)
KBO( :, 3,57,15) = (/&
&3.8272E+02_JPRB,3.8249E+02_JPRB,2.8707E+02_JPRB,1.9154E+02_JPRB,1.1567E+02_JPRB,1.1005E+02_JPRB/)
KBO( :, 4,57,15) = (/&
&3.6944E+02_JPRB,3.6922E+02_JPRB,2.7712E+02_JPRB,1.8480E+02_JPRB,1.0758E+02_JPRB,1.0192E+02_JPRB/)
KBO( :, 5,57,15) = (/&
&3.5592E+02_JPRB,3.5571E+02_JPRB,2.6698E+02_JPRB,1.7805E+02_JPRB,1.0054E+02_JPRB,9.6453E+01_JPRB/)
KBO( :, 1,58,15) = (/&
&4.1059E+02_JPRB,4.1035E+02_JPRB,3.0796E+02_JPRB,2.0852E+02_JPRB,1.3980E+02_JPRB,1.3680E+02_JPRB/)
KBO( :, 2,58,15) = (/&
&3.9929E+02_JPRB,3.9905E+02_JPRB,2.9949E+02_JPRB,2.0087E+02_JPRB,1.2831E+02_JPRB,1.2369E+02_JPRB/)
KBO( :, 3,58,15) = (/&
&3.8677E+02_JPRB,3.8654E+02_JPRB,2.9010E+02_JPRB,1.9368E+02_JPRB,1.1842E+02_JPRB,1.1258E+02_JPRB/)
KBO( :, 4,58,15) = (/&
&3.7367E+02_JPRB,3.7345E+02_JPRB,2.8029E+02_JPRB,1.8691E+02_JPRB,1.0996E+02_JPRB,1.0363E+02_JPRB/)
KBO( :, 5,58,15) = (/&
&3.6017E+02_JPRB,3.5995E+02_JPRB,2.7016E+02_JPRB,1.8017E+02_JPRB,1.0261E+02_JPRB,9.7140E+01_JPRB/)
KBO( :, 1,59,15) = (/&
&4.1203E+02_JPRB,4.1178E+02_JPRB,3.0904E+02_JPRB,2.0958E+02_JPRB,1.4140E+02_JPRB,1.3865E+02_JPRB/)
KBO( :, 2,59,15) = (/&
&4.0086E+02_JPRB,4.0061E+02_JPRB,3.0066E+02_JPRB,2.0184E+02_JPRB,1.2968E+02_JPRB,1.2523E+02_JPRB/)
KBO( :, 3,59,15) = (/&
&3.8845E+02_JPRB,3.8822E+02_JPRB,2.9137E+02_JPRB,1.9459E+02_JPRB,1.1957E+02_JPRB,1.1363E+02_JPRB/)
KBO( :, 4,59,15) = (/&
&3.7538E+02_JPRB,3.7516E+02_JPRB,2.8157E+02_JPRB,1.8776E+02_JPRB,1.1095E+02_JPRB,1.0368E+02_JPRB/)
KBO( :, 5,59,15) = (/&
&3.6194E+02_JPRB,3.6172E+02_JPRB,2.7149E+02_JPRB,1.8106E+02_JPRB,1.0349E+02_JPRB,9.5485E+01_JPRB/)
KBO( :, 1,13,16) = (/&
&3.8689E+01_JPRB,3.8666E+01_JPRB,2.9260E+01_JPRB,2.0209E+01_JPRB,1.1782E+01_JPRB,1.0583E+01_JPRB/)
KBO( :, 2,13,16) = (/&
&3.8299E+01_JPRB,3.8276E+01_JPRB,2.8975E+01_JPRB,1.9748E+01_JPRB,1.1593E+01_JPRB,1.0462E+01_JPRB/)
KBO( :, 3,13,16) = (/&
&3.8145E+01_JPRB,3.8122E+01_JPRB,2.8865E+01_JPRB,1.9633E+01_JPRB,1.1641E+01_JPRB,1.2633E+01_JPRB/)
KBO( :, 4,13,16) = (/&
&3.7920E+01_JPRB,3.7898E+01_JPRB,2.8722E+01_JPRB,1.9787E+01_JPRB,1.1762E+01_JPRB,2.0692E+01_JPRB/)
KBO( :, 5,13,16) = (/&
&3.7770E+01_JPRB,3.7748E+01_JPRB,2.8670E+01_JPRB,1.9920E+01_JPRB,1.1827E+01_JPRB,3.1866E+01_JPRB/)
KBO( :, 1,14,16) = (/&
&4.5054E+01_JPRB,4.5027E+01_JPRB,3.4026E+01_JPRB,2.3071E+01_JPRB,1.3319E+01_JPRB,1.2073E+01_JPRB/)
KBO( :, 2,14,16) = (/&
&4.5133E+01_JPRB,4.5106E+01_JPRB,3.4091E+01_JPRB,2.3057E+01_JPRB,1.3364E+01_JPRB,1.1925E+01_JPRB/)
KBO( :, 3,14,16) = (/&
&4.5119E+01_JPRB,4.5092E+01_JPRB,3.4098E+01_JPRB,2.3216E+01_JPRB,1.3503E+01_JPRB,1.1702E+01_JPRB/)
KBO( :, 4,14,16) = (/&
&4.5115E+01_JPRB,4.5088E+01_JPRB,3.4119E+01_JPRB,2.3467E+01_JPRB,1.3637E+01_JPRB,1.5244E+01_JPRB/)
KBO( :, 5,14,16) = (/&
&4.5059E+01_JPRB,4.5033E+01_JPRB,3.4214E+01_JPRB,2.3627E+01_JPRB,1.3694E+01_JPRB,2.3098E+01_JPRB/)
KBO( :, 1,15,16) = (/&
&5.3422E+01_JPRB,5.3390E+01_JPRB,4.0289E+01_JPRB,2.7161E+01_JPRB,1.5356E+01_JPRB,1.3721E+01_JPRB/)
KBO( :, 2,15,16) = (/&
&5.3696E+01_JPRB,5.3664E+01_JPRB,4.0505E+01_JPRB,2.7340E+01_JPRB,1.5494E+01_JPRB,1.3518E+01_JPRB/)
KBO( :, 3,15,16) = (/&
&5.3925E+01_JPRB,5.3893E+01_JPRB,4.0694E+01_JPRB,2.7658E+01_JPRB,1.5638E+01_JPRB,1.3237E+01_JPRB/)
KBO( :, 4,15,16) = (/&
&5.4035E+01_JPRB,5.4003E+01_JPRB,4.0835E+01_JPRB,2.7959E+01_JPRB,1.5745E+01_JPRB,1.3582E+01_JPRB/)
KBO( :, 5,15,16) = (/&
&5.4075E+01_JPRB,5.4044E+01_JPRB,4.1021E+01_JPRB,2.8130E+01_JPRB,1.5788E+01_JPRB,1.7824E+01_JPRB/)
KBO( :, 1,16,16) = (/&
&6.3798E+01_JPRB,6.3761E+01_JPRB,4.8055E+01_JPRB,3.2321E+01_JPRB,1.7804E+01_JPRB,1.5476E+01_JPRB/)
KBO( :, 2,16,16) = (/&
&6.4371E+01_JPRB,6.4333E+01_JPRB,4.8500E+01_JPRB,3.2671E+01_JPRB,1.7962E+01_JPRB,1.5197E+01_JPRB/)
KBO( :, 3,16,16) = (/&
&6.4762E+01_JPRB,6.4724E+01_JPRB,4.8796E+01_JPRB,3.3069E+01_JPRB,1.8081E+01_JPRB,1.4836E+01_JPRB/)
KBO( :, 4,16,16) = (/&
&6.4916E+01_JPRB,6.4878E+01_JPRB,4.9055E+01_JPRB,3.3403E+01_JPRB,1.8207E+01_JPRB,1.4562E+01_JPRB/)
KBO( :, 5,16,16) = (/&
&6.5062E+01_JPRB,6.5024E+01_JPRB,4.9265E+01_JPRB,3.3568E+01_JPRB,1.8256E+01_JPRB,1.7370E+01_JPRB/)
KBO( :, 1,17,16) = (/&
&7.6610E+01_JPRB,7.6564E+01_JPRB,5.7652E+01_JPRB,3.8697E+01_JPRB,2.0672E+01_JPRB,1.7278E+01_JPRB/)
KBO( :, 2,17,16) = (/&
&7.7427E+01_JPRB,7.7381E+01_JPRB,5.8265E+01_JPRB,3.9185E+01_JPRB,2.0866E+01_JPRB,1.6909E+01_JPRB/)
KBO( :, 3,17,16) = (/&
&7.7882E+01_JPRB,7.7836E+01_JPRB,5.8659E+01_JPRB,3.9624E+01_JPRB,2.1079E+01_JPRB,1.6452E+01_JPRB/)
KBO( :, 4,17,16) = (/&
&7.8153E+01_JPRB,7.8107E+01_JPRB,5.8983E+01_JPRB,3.9939E+01_JPRB,2.1227E+01_JPRB,1.5935E+01_JPRB/)
KBO( :, 5,17,16) = (/&
&7.8285E+01_JPRB,7.8239E+01_JPRB,5.9159E+01_JPRB,4.0098E+01_JPRB,2.1284E+01_JPRB,1.7883E+01_JPRB/)
KBO( :, 1,18,16) = (/&
&9.2189E+01_JPRB,9.2134E+01_JPRB,6.9312E+01_JPRB,4.6439E+01_JPRB,2.4197E+01_JPRB,1.9120E+01_JPRB/)
KBO( :, 2,18,16) = (/&
&9.3127E+01_JPRB,9.3071E+01_JPRB,7.0021E+01_JPRB,4.7049E+01_JPRB,2.4478E+01_JPRB,1.8615E+01_JPRB/)
KBO( :, 3,18,16) = (/&
&9.3687E+01_JPRB,9.3631E+01_JPRB,7.0554E+01_JPRB,4.7512E+01_JPRB,2.4757E+01_JPRB,1.8049E+01_JPRB/)
KBO( :, 4,18,16) = (/&
&9.4033E+01_JPRB,9.3977E+01_JPRB,7.0871E+01_JPRB,4.7767E+01_JPRB,2.4905E+01_JPRB,1.7594E+01_JPRB/)
KBO( :, 5,18,16) = (/&
&9.4115E+01_JPRB,9.4059E+01_JPRB,7.0982E+01_JPRB,4.7909E+01_JPRB,2.4988E+01_JPRB,1.9077E+01_JPRB/)
KBO( :, 1,19,16) = (/&
&1.1088E+02_JPRB,1.1082E+02_JPRB,8.3307E+01_JPRB,5.5744E+01_JPRB,2.8599E+01_JPRB,2.1582E+01_JPRB/)
KBO( :, 2,19,16) = (/&
&1.1182E+02_JPRB,1.1175E+02_JPRB,8.4097E+01_JPRB,5.6442E+01_JPRB,2.8984E+01_JPRB,2.0983E+01_JPRB/)
KBO( :, 3,19,16) = (/&
&1.1254E+02_JPRB,1.1247E+02_JPRB,8.4694E+01_JPRB,5.6884E+01_JPRB,2.9231E+01_JPRB,2.0488E+01_JPRB/)
KBO( :, 4,19,16) = (/&
&1.1281E+02_JPRB,1.1274E+02_JPRB,8.4918E+01_JPRB,5.7062E+01_JPRB,2.9345E+01_JPRB,2.0019E+01_JPRB/)
KBO( :, 5,19,16) = (/&
&1.1284E+02_JPRB,1.1277E+02_JPRB,8.4969E+01_JPRB,5.7133E+01_JPRB,2.9423E+01_JPRB,2.0552E+01_JPRB/)
KBO( :, 1,20,16) = (/&
&1.3304E+02_JPRB,1.3296E+02_JPRB,9.9902E+01_JPRB,6.6832E+01_JPRB,3.3983E+01_JPRB,2.4788E+01_JPRB/)
KBO( :, 2,20,16) = (/&
&1.3397E+02_JPRB,1.3389E+02_JPRB,1.0072E+02_JPRB,6.7494E+01_JPRB,3.4377E+01_JPRB,2.4125E+01_JPRB/)
KBO( :, 3,20,16) = (/&
&1.3463E+02_JPRB,1.3455E+02_JPRB,1.0123E+02_JPRB,6.7864E+01_JPRB,3.4571E+01_JPRB,2.3603E+01_JPRB/)
KBO( :, 4,20,16) = (/&
&1.3476E+02_JPRB,1.3468E+02_JPRB,1.0135E+02_JPRB,6.7962E+01_JPRB,3.4649E+01_JPRB,2.3098E+01_JPRB/)
KBO( :, 5,20,16) = (/&
&1.3461E+02_JPRB,1.3453E+02_JPRB,1.0126E+02_JPRB,6.7912E+01_JPRB,3.4631E+01_JPRB,2.3014E+01_JPRB/)
KBO( :, 1,21,16) = (/&
&1.5902E+02_JPRB,1.5892E+02_JPRB,1.1942E+02_JPRB,7.9855E+01_JPRB,4.0380E+01_JPRB,2.8857E+01_JPRB/)
KBO( :, 2,21,16) = (/&
&1.5986E+02_JPRB,1.5976E+02_JPRB,1.2010E+02_JPRB,8.0360E+01_JPRB,4.0679E+01_JPRB,2.8064E+01_JPRB/)
KBO( :, 3,21,16) = (/&
&1.6009E+02_JPRB,1.5999E+02_JPRB,1.2030E+02_JPRB,8.0530E+01_JPRB,4.0801E+01_JPRB,2.7409E+01_JPRB/)
KBO( :, 4,21,16) = (/&
&1.6003E+02_JPRB,1.5993E+02_JPRB,1.2027E+02_JPRB,8.0522E+01_JPRB,4.0812E+01_JPRB,2.6783E+01_JPRB/)
KBO( :, 5,21,16) = (/&
&1.5940E+02_JPRB,1.5931E+02_JPRB,1.1980E+02_JPRB,8.0213E+01_JPRB,4.0653E+01_JPRB,2.6207E+01_JPRB/)
KBO( :, 1,22,16) = (/&
&1.8914E+02_JPRB,1.8903E+02_JPRB,1.4202E+02_JPRB,9.4911E+01_JPRB,4.7837E+01_JPRB,3.3682E+01_JPRB/)
KBO( :, 2,22,16) = (/&
&1.8942E+02_JPRB,1.8931E+02_JPRB,1.4225E+02_JPRB,9.5082E+01_JPRB,4.7944E+01_JPRB,3.2660E+01_JPRB/)
KBO( :, 3,22,16) = (/&
&1.8906E+02_JPRB,1.8895E+02_JPRB,1.4200E+02_JPRB,9.4945E+01_JPRB,4.7916E+01_JPRB,3.1774E+01_JPRB/)
KBO( :, 4,22,16) = (/&
&1.8832E+02_JPRB,1.8821E+02_JPRB,1.4146E+02_JPRB,9.4597E+01_JPRB,4.7752E+01_JPRB,3.0917E+01_JPRB/)
KBO( :, 5,22,16) = (/&
&1.8683E+02_JPRB,1.8672E+02_JPRB,1.4034E+02_JPRB,9.3850E+01_JPRB,4.7374E+01_JPRB,3.0042E+01_JPRB/)
KBO( :, 1,23,16) = (/&
&2.2303E+02_JPRB,2.2290E+02_JPRB,1.6742E+02_JPRB,1.1182E+02_JPRB,5.6236E+01_JPRB,3.9223E+01_JPRB/)
KBO( :, 2,23,16) = (/&
&2.2245E+02_JPRB,2.2232E+02_JPRB,1.6700E+02_JPRB,1.1156E+02_JPRB,5.6122E+01_JPRB,3.7879E+01_JPRB/)
KBO( :, 3,23,16) = (/&
&2.2122E+02_JPRB,2.2109E+02_JPRB,1.6608E+02_JPRB,1.1095E+02_JPRB,5.5829E+01_JPRB,3.6659E+01_JPRB/)
KBO( :, 4,23,16) = (/&
&2.1922E+02_JPRB,2.1909E+02_JPRB,1.6458E+02_JPRB,1.0995E+02_JPRB,5.5344E+01_JPRB,3.5458E+01_JPRB/)
KBO( :, 5,23,16) = (/&
&2.1646E+02_JPRB,2.1633E+02_JPRB,1.6251E+02_JPRB,1.0858E+02_JPRB,5.4654E+01_JPRB,3.4278E+01_JPRB/)
KBO( :, 1,24,16) = (/&
&2.6009E+02_JPRB,2.5994E+02_JPRB,1.9520E+02_JPRB,1.3031E+02_JPRB,6.5430E+01_JPRB,4.5390E+01_JPRB/)
KBO( :, 2,24,16) = (/&
&2.5840E+02_JPRB,2.5824E+02_JPRB,1.9393E+02_JPRB,1.2948E+02_JPRB,6.5031E+01_JPRB,4.3599E+01_JPRB/)
KBO( :, 3,24,16) = (/&
&2.5582E+02_JPRB,2.5567E+02_JPRB,1.9201E+02_JPRB,1.2820E+02_JPRB,6.4398E+01_JPRB,4.1930E+01_JPRB/)
KBO( :, 4,24,16) = (/&
&2.5214E+02_JPRB,2.5199E+02_JPRB,1.8925E+02_JPRB,1.2636E+02_JPRB,6.3477E+01_JPRB,4.0299E+01_JPRB/)
KBO( :, 5,24,16) = (/&
&2.4775E+02_JPRB,2.4761E+02_JPRB,1.8596E+02_JPRB,1.2416E+02_JPRB,6.2364E+01_JPRB,3.8770E+01_JPRB/)
KBO( :, 1,25,16) = (/&
&2.9961E+02_JPRB,2.9943E+02_JPRB,2.2482E+02_JPRB,1.5004E+02_JPRB,7.5282E+01_JPRB,5.1967E+01_JPRB/)
KBO( :, 2,25,16) = (/&
&2.9633E+02_JPRB,2.9616E+02_JPRB,2.2237E+02_JPRB,1.4840E+02_JPRB,7.4441E+01_JPRB,4.9689E+01_JPRB/)
KBO( :, 3,25,16) = (/&
&2.9175E+02_JPRB,2.9157E+02_JPRB,2.1893E+02_JPRB,1.4611E+02_JPRB,7.3302E+01_JPRB,4.7422E+01_JPRB/)
KBO( :, 4,25,16) = (/&
&2.8609E+02_JPRB,2.8592E+02_JPRB,2.1467E+02_JPRB,1.4326E+02_JPRB,7.1858E+01_JPRB,4.5354E+01_JPRB/)
KBO( :, 5,25,16) = (/&
&2.7979E+02_JPRB,2.7962E+02_JPRB,2.0995E+02_JPRB,1.4011E+02_JPRB,7.0273E+01_JPRB,4.3371E+01_JPRB/)
KBO( :, 1,26,16) = (/&
&3.4064E+02_JPRB,3.4044E+02_JPRB,2.5559E+02_JPRB,1.7054E+02_JPRB,8.5509E+01_JPRB,5.8664E+01_JPRB/)
KBO( :, 2,26,16) = (/&
&3.3479E+02_JPRB,3.3459E+02_JPRB,2.5118E+02_JPRB,1.6758E+02_JPRB,8.3998E+01_JPRB,5.5796E+01_JPRB/)
KBO( :, 3,26,16) = (/&
&3.2781E+02_JPRB,3.2761E+02_JPRB,2.4595E+02_JPRB,1.6410E+02_JPRB,8.2241E+01_JPRB,5.2997E+01_JPRB/)
KBO( :, 4,26,16) = (/&
&3.1991E+02_JPRB,3.1971E+02_JPRB,2.4002E+02_JPRB,1.6013E+02_JPRB,8.0246E+01_JPRB,5.0365E+01_JPRB/)
KBO( :, 5,26,16) = (/&
&3.1125E+02_JPRB,3.1106E+02_JPRB,2.3353E+02_JPRB,1.5580E+02_JPRB,7.8078E+01_JPRB,4.7882E+01_JPRB/)
KBO( :, 1,27,16) = (/&
&3.8151E+02_JPRB,3.8128E+02_JPRB,2.8624E+02_JPRB,1.9097E+02_JPRB,9.5695E+01_JPRB,6.5294E+01_JPRB/)
KBO( :, 2,27,16) = (/&
&3.7246E+02_JPRB,3.7224E+02_JPRB,2.7942E+02_JPRB,1.8640E+02_JPRB,9.3380E+01_JPRB,6.1731E+01_JPRB/)
KBO( :, 3,27,16) = (/&
&3.6293E+02_JPRB,3.6271E+02_JPRB,2.7227E+02_JPRB,1.8161E+02_JPRB,9.0959E+01_JPRB,5.8403E+01_JPRB/)
KBO( :, 4,27,16) = (/&
&3.5247E+02_JPRB,3.5226E+02_JPRB,2.6442E+02_JPRB,1.7637E+02_JPRB,8.8327E+01_JPRB,5.5221E+01_JPRB/)
KBO( :, 5,27,16) = (/&
&3.4112E+02_JPRB,3.4092E+02_JPRB,2.5591E+02_JPRB,1.7070E+02_JPRB,8.5490E+01_JPRB,5.2167E+01_JPRB/)
KBO( :, 1,28,16) = (/&
&4.2083E+02_JPRB,4.2057E+02_JPRB,3.1571E+02_JPRB,2.1058E+02_JPRB,1.0546E+02_JPRB,7.1596E+01_JPRB/)
KBO( :, 2,28,16) = (/&
&4.0846E+02_JPRB,4.0821E+02_JPRB,3.0641E+02_JPRB,2.0435E+02_JPRB,1.0232E+02_JPRB,6.7371E+01_JPRB/)
KBO( :, 3,28,16) = (/&
&3.9603E+02_JPRB,3.9579E+02_JPRB,2.9708E+02_JPRB,1.9813E+02_JPRB,9.9186E+01_JPRB,6.3413E+01_JPRB/)
KBO( :, 4,28,16) = (/&
&3.8255E+02_JPRB,3.8232E+02_JPRB,2.8697E+02_JPRB,1.9139E+02_JPRB,9.5812E+01_JPRB,5.9684E+01_JPRB/)
KBO( :, 5,28,16) = (/&
&3.6876E+02_JPRB,3.6854E+02_JPRB,2.7662E+02_JPRB,1.8449E+02_JPRB,9.2357E+01_JPRB,5.6128E+01_JPRB/)
KBO( :, 1,29,16) = (/&
&4.5696E+02_JPRB,4.5668E+02_JPRB,3.4279E+02_JPRB,2.2863E+02_JPRB,1.1447E+02_JPRB,7.7353E+01_JPRB/)
KBO( :, 2,29,16) = (/&
&4.4141E+02_JPRB,4.4115E+02_JPRB,3.3112E+02_JPRB,2.2083E+02_JPRB,1.1054E+02_JPRB,7.2448E+01_JPRB/)
KBO( :, 3,29,16) = (/&
&4.2589E+02_JPRB,4.2564E+02_JPRB,3.1947E+02_JPRB,2.1304E+02_JPRB,1.0662E+02_JPRB,6.7886E+01_JPRB/)
KBO( :, 4,29,16) = (/&
&4.0969E+02_JPRB,4.0945E+02_JPRB,3.0731E+02_JPRB,2.0494E+02_JPRB,1.0256E+02_JPRB,6.3607E+01_JPRB/)
KBO( :, 5,29,16) = (/&
&3.9310E+02_JPRB,3.9286E+02_JPRB,2.9486E+02_JPRB,1.9663E+02_JPRB,9.8402E+01_JPRB,5.9577E+01_JPRB/)
KBO( :, 1,30,16) = (/&
&4.8959E+02_JPRB,4.8930E+02_JPRB,3.6726E+02_JPRB,2.4492E+02_JPRB,1.2259E+02_JPRB,8.2395E+01_JPRB/)
KBO( :, 2,30,16) = (/&
&4.7092E+02_JPRB,4.7063E+02_JPRB,3.5324E+02_JPRB,2.3556E+02_JPRB,1.1788E+02_JPRB,7.6844E+01_JPRB/)
KBO( :, 3,30,16) = (/&
&4.5203E+02_JPRB,4.5176E+02_JPRB,3.3907E+02_JPRB,2.2611E+02_JPRB,1.1315E+02_JPRB,7.1734E+01_JPRB/)
KBO( :, 4,30,16) = (/&
&4.3310E+02_JPRB,4.3284E+02_JPRB,3.2486E+02_JPRB,2.1662E+02_JPRB,1.0839E+02_JPRB,6.6928E+01_JPRB/)
KBO( :, 5,30,16) = (/&
&4.1412E+02_JPRB,4.1387E+02_JPRB,3.1062E+02_JPRB,2.0713E+02_JPRB,1.0363E+02_JPRB,6.3289E+01_JPRB/)
KBO( :, 1,31,16) = (/&
&5.1786E+02_JPRB,5.1755E+02_JPRB,3.8845E+02_JPRB,2.5903E+02_JPRB,1.2962E+02_JPRB,8.6621E+01_JPRB/)
KBO( :, 2,31,16) = (/&
&4.9597E+02_JPRB,4.9567E+02_JPRB,3.7202E+02_JPRB,2.4806E+02_JPRB,1.2412E+02_JPRB,8.0470E+01_JPRB/)
KBO( :, 3,31,16) = (/&
&4.7405E+02_JPRB,4.7377E+02_JPRB,3.5558E+02_JPRB,2.3710E+02_JPRB,1.1862E+02_JPRB,7.4852E+01_JPRB/)
KBO( :, 4,31,16) = (/&
&4.5255E+02_JPRB,4.5228E+02_JPRB,3.3944E+02_JPRB,2.2633E+02_JPRB,1.1323E+02_JPRB,6.9726E+01_JPRB/)
KBO( :, 5,31,16) = (/&
&4.3142E+02_JPRB,4.3116E+02_JPRB,3.2359E+02_JPRB,2.1576E+02_JPRB,1.0794E+02_JPRB,6.8706E+01_JPRB/)
KBO( :, 1,32,16) = (/&
&5.4131E+02_JPRB,5.4099E+02_JPRB,4.0602E+02_JPRB,2.7073E+02_JPRB,1.3545E+02_JPRB,8.9958E+01_JPRB/)
KBO( :, 2,32,16) = (/&
&5.1653E+02_JPRB,5.1622E+02_JPRB,3.8743E+02_JPRB,2.5834E+02_JPRB,1.2924E+02_JPRB,8.3331E+01_JPRB/)
KBO( :, 3,32,16) = (/&
&4.9189E+02_JPRB,4.9160E+02_JPRB,3.6895E+02_JPRB,2.4600E+02_JPRB,1.2306E+02_JPRB,7.7256E+01_JPRB/)
KBO( :, 4,32,16) = (/&
&4.6812E+02_JPRB,4.6784E+02_JPRB,3.5111E+02_JPRB,2.3411E+02_JPRB,1.1710E+02_JPRB,7.4368E+01_JPRB/)
KBO( :, 5,32,16) = (/&
&4.4507E+02_JPRB,4.4480E+02_JPRB,3.3382E+02_JPRB,2.2258E+02_JPRB,1.1133E+02_JPRB,7.6072E+01_JPRB/)
KBO( :, 1,33,16) = (/&
&5.6013E+02_JPRB,5.5980E+02_JPRB,4.2013E+02_JPRB,2.8013E+02_JPRB,1.4013E+02_JPRB,9.2452E+01_JPRB/)
KBO( :, 2,33,16) = (/&
&5.3265E+02_JPRB,5.3233E+02_JPRB,3.9951E+02_JPRB,2.6638E+02_JPRB,1.3325E+02_JPRB,8.5421E+01_JPRB/)
KBO( :, 3,33,16) = (/&
&5.0565E+02_JPRB,5.0535E+02_JPRB,3.7926E+02_JPRB,2.5287E+02_JPRB,1.2648E+02_JPRB,8.0582E+01_JPRB/)
KBO( :, 4,33,16) = (/&
&4.8012E+02_JPRB,4.7983E+02_JPRB,3.6011E+02_JPRB,2.4010E+02_JPRB,1.2009E+02_JPRB,8.1630E+01_JPRB/)
KBO( :, 5,33,16) = (/&
&4.5545E+02_JPRB,4.5518E+02_JPRB,3.4161E+02_JPRB,2.2776E+02_JPRB,1.1392E+02_JPRB,8.6476E+01_JPRB/)
KBO( :, 1,34,16) = (/&
&5.7564E+02_JPRB,5.7530E+02_JPRB,4.3176E+02_JPRB,2.8787E+02_JPRB,1.4399E+02_JPRB,9.4439E+01_JPRB/)
KBO( :, 2,34,16) = (/&
&5.4576E+02_JPRB,5.4543E+02_JPRB,4.0934E+02_JPRB,2.7293E+02_JPRB,1.3651E+02_JPRB,8.7181E+01_JPRB/)
KBO( :, 3,34,16) = (/&
&5.1688E+02_JPRB,5.1657E+02_JPRB,3.8768E+02_JPRB,2.5848E+02_JPRB,1.2927E+02_JPRB,8.6122E+01_JPRB/)
KBO( :, 4,34,16) = (/&
&4.8984E+02_JPRB,4.8955E+02_JPRB,3.6740E+02_JPRB,2.4495E+02_JPRB,1.2251E+02_JPRB,9.0125E+01_JPRB/)
KBO( :, 5,34,16) = (/&
&4.6368E+02_JPRB,4.6340E+02_JPRB,3.4777E+02_JPRB,2.3187E+02_JPRB,1.1596E+02_JPRB,9.7964E+01_JPRB/)
KBO( :, 1,35,16) = (/&
&5.9022E+02_JPRB,5.8986E+02_JPRB,4.4268E+02_JPRB,2.9515E+02_JPRB,1.4762E+02_JPRB,9.6547E+01_JPRB/)
KBO( :, 2,35,16) = (/&
&5.5830E+02_JPRB,5.5796E+02_JPRB,4.1874E+02_JPRB,2.7919E+02_JPRB,1.3963E+02_JPRB,9.1112E+01_JPRB/)
KBO( :, 3,35,16) = (/&
&5.2772E+02_JPRB,5.2741E+02_JPRB,3.9581E+02_JPRB,2.6389E+02_JPRB,1.3198E+02_JPRB,9.3202E+01_JPRB/)
KBO( :, 4,35,16) = (/&
&4.9925E+02_JPRB,4.9895E+02_JPRB,3.7445E+02_JPRB,2.4965E+02_JPRB,1.2485E+02_JPRB,1.0012E+02_JPRB/)
KBO( :, 5,35,16) = (/&
&4.7190E+02_JPRB,4.7162E+02_JPRB,3.5394E+02_JPRB,2.3598E+02_JPRB,1.1801E+02_JPRB,1.1144E+02_JPRB/)
KBO( :, 1,36,16) = (/&
&6.0541E+02_JPRB,6.0504E+02_JPRB,4.5407E+02_JPRB,3.0274E+02_JPRB,1.5140E+02_JPRB,9.9056E+01_JPRB/)
KBO( :, 2,36,16) = (/&
&5.7172E+02_JPRB,5.7138E+02_JPRB,4.2880E+02_JPRB,2.8589E+02_JPRB,1.4298E+02_JPRB,9.6302E+01_JPRB/)
KBO( :, 3,36,16) = (/&
&5.3964E+02_JPRB,5.3931E+02_JPRB,4.0474E+02_JPRB,2.6984E+02_JPRB,1.3495E+02_JPRB,1.0085E+02_JPRB/)
KBO( :, 4,36,16) = (/&
&5.0967E+02_JPRB,5.0936E+02_JPRB,3.8226E+02_JPRB,2.5485E+02_JPRB,1.2745E+02_JPRB,1.1048E+02_JPRB/)
KBO( :, 5,36,16) = (/&
&4.8120E+02_JPRB,4.8091E+02_JPRB,3.6091E+02_JPRB,2.4062E+02_JPRB,1.2033E+02_JPRB,1.2766E+02_JPRB/)
KBO( :, 1,37,16) = (/&
&6.2365E+02_JPRB,6.2328E+02_JPRB,4.6775E+02_JPRB,3.1185E+02_JPRB,1.5596E+02_JPRB,1.0253E+02_JPRB/)
KBO( :, 2,37,16) = (/&
&5.8812E+02_JPRB,5.8777E+02_JPRB,4.4110E+02_JPRB,2.9409E+02_JPRB,1.4707E+02_JPRB,1.0086E+02_JPRB/)
KBO( :, 3,37,16) = (/&
&5.5432E+02_JPRB,5.5398E+02_JPRB,4.1575E+02_JPRB,2.7718E+02_JPRB,1.3861E+02_JPRB,1.0660E+02_JPRB/)
KBO( :, 4,37,16) = (/&
&5.2295E+02_JPRB,5.2264E+02_JPRB,3.9222E+02_JPRB,2.6149E+02_JPRB,1.3076E+02_JPRB,1.1783E+02_JPRB/)
KBO( :, 5,37,16) = (/&
&4.9325E+02_JPRB,4.9295E+02_JPRB,3.6994E+02_JPRB,2.4664E+02_JPRB,1.2334E+02_JPRB,1.3920E+02_JPRB/)
KBO( :, 1,38,16) = (/&
&6.4066E+02_JPRB,6.4028E+02_JPRB,4.8051E+02_JPRB,3.2036E+02_JPRB,1.6020E+02_JPRB,1.0610E+02_JPRB/)
KBO( :, 2,38,16) = (/&
&6.0334E+02_JPRB,6.0298E+02_JPRB,4.5252E+02_JPRB,3.0169E+02_JPRB,1.5087E+02_JPRB,1.0585E+02_JPRB/)
KBO( :, 3,38,16) = (/&
&5.6803E+02_JPRB,5.6769E+02_JPRB,4.2603E+02_JPRB,2.8403E+02_JPRB,1.4204E+02_JPRB,1.1325E+02_JPRB/)
KBO( :, 4,38,16) = (/&
&5.3536E+02_JPRB,5.3504E+02_JPRB,4.0152E+02_JPRB,2.6769E+02_JPRB,1.3386E+02_JPRB,1.2673E+02_JPRB/)
KBO( :, 5,38,16) = (/&
&5.0450E+02_JPRB,5.0419E+02_JPRB,3.7838E+02_JPRB,2.5226E+02_JPRB,1.2614E+02_JPRB,1.5384E+02_JPRB/)
KBO( :, 1,39,16) = (/&
&6.5607E+02_JPRB,6.5567E+02_JPRB,4.9206E+02_JPRB,3.2805E+02_JPRB,1.6405E+02_JPRB,1.1010E+02_JPRB/)
KBO( :, 2,39,16) = (/&
&6.1741E+02_JPRB,6.1704E+02_JPRB,4.6306E+02_JPRB,3.0872E+02_JPRB,1.5438E+02_JPRB,1.1190E+02_JPRB/)
KBO( :, 3,39,16) = (/&
&5.8064E+02_JPRB,5.8030E+02_JPRB,4.3549E+02_JPRB,2.9034E+02_JPRB,1.4519E+02_JPRB,1.2173E+02_JPRB/)
KBO( :, 4,39,16) = (/&
&5.4667E+02_JPRB,5.4634E+02_JPRB,4.1001E+02_JPRB,2.7335E+02_JPRB,1.3668E+02_JPRB,1.3901E+02_JPRB/)
KBO( :, 5,39,16) = (/&
&5.1480E+02_JPRB,5.1449E+02_JPRB,3.8610E+02_JPRB,2.5741E+02_JPRB,1.2872E+02_JPRB,1.7411E+02_JPRB/)
KBO( :, 1,40,16) = (/&
&6.7476E+02_JPRB,6.7436E+02_JPRB,5.0608E+02_JPRB,3.3740E+02_JPRB,1.6871E+02_JPRB,1.1362E+02_JPRB/)
KBO( :, 2,40,16) = (/&
&6.3434E+02_JPRB,6.3396E+02_JPRB,4.7576E+02_JPRB,3.1718E+02_JPRB,1.5861E+02_JPRB,1.1463E+02_JPRB/)
KBO( :, 3,40,16) = (/&
&5.9602E+02_JPRB,5.9566E+02_JPRB,4.4702E+02_JPRB,2.9802E+02_JPRB,1.4902E+02_JPRB,1.2450E+02_JPRB/)
KBO( :, 4,40,16) = (/&
&5.6052E+02_JPRB,5.6019E+02_JPRB,4.2040E+02_JPRB,2.8027E+02_JPRB,1.4015E+02_JPRB,1.4231E+02_JPRB/)
KBO( :, 5,40,16) = (/&
&5.2757E+02_JPRB,5.2726E+02_JPRB,3.9569E+02_JPRB,2.6380E+02_JPRB,1.3191E+02_JPRB,1.7853E+02_JPRB/)
KBO( :, 1,41,16) = (/&
&6.9313E+02_JPRB,6.9271E+02_JPRB,5.1985E+02_JPRB,3.4658E+02_JPRB,1.7330E+02_JPRB,1.1720E+02_JPRB/)
KBO( :, 2,41,16) = (/&
&6.5096E+02_JPRB,6.5057E+02_JPRB,4.8822E+02_JPRB,3.2549E+02_JPRB,1.6276E+02_JPRB,1.1702E+02_JPRB/)
KBO( :, 3,41,16) = (/&
&6.1137E+02_JPRB,6.1101E+02_JPRB,4.5853E+02_JPRB,3.0570E+02_JPRB,1.5286E+02_JPRB,1.2672E+02_JPRB/)
KBO( :, 4,41,16) = (/&
&5.7432E+02_JPRB,5.7398E+02_JPRB,4.3074E+02_JPRB,2.8717E+02_JPRB,1.4359E+02_JPRB,1.4478E+02_JPRB/)
KBO( :, 5,41,16) = (/&
&5.4017E+02_JPRB,5.3985E+02_JPRB,4.0513E+02_JPRB,2.7009E+02_JPRB,1.3505E+02_JPRB,1.8129E+02_JPRB/)
KBO( :, 1,42,16) = (/&
&7.1087E+02_JPRB,7.1044E+02_JPRB,5.3316E+02_JPRB,3.5544E+02_JPRB,1.7773E+02_JPRB,1.2104E+02_JPRB/)
KBO( :, 2,42,16) = (/&
&6.6722E+02_JPRB,6.6682E+02_JPRB,5.0042E+02_JPRB,3.3362E+02_JPRB,1.6682E+02_JPRB,1.1969E+02_JPRB/)
KBO( :, 3,42,16) = (/&
&6.2628E+02_JPRB,6.2590E+02_JPRB,4.6971E+02_JPRB,3.1315E+02_JPRB,1.5658E+02_JPRB,1.2937E+02_JPRB/)
KBO( :, 4,42,16) = (/&
&5.8799E+02_JPRB,5.8763E+02_JPRB,4.4099E+02_JPRB,2.9400E+02_JPRB,1.4701E+02_JPRB,1.4803E+02_JPRB/)
KBO( :, 5,42,16) = (/&
&5.5259E+02_JPRB,5.5226E+02_JPRB,4.1445E+02_JPRB,2.7630E+02_JPRB,1.3816E+02_JPRB,1.8567E+02_JPRB/)
KBO( :, 1,43,16) = (/&
&7.3062E+02_JPRB,7.3018E+02_JPRB,5.4797E+02_JPRB,3.6532E+02_JPRB,1.8267E+02_JPRB,1.2580E+02_JPRB/)
KBO( :, 2,43,16) = (/&
&6.8544E+02_JPRB,6.8503E+02_JPRB,5.1409E+02_JPRB,3.4273E+02_JPRB,1.7137E+02_JPRB,1.2199E+02_JPRB/)
KBO( :, 3,43,16) = (/&
&6.4317E+02_JPRB,6.4278E+02_JPRB,4.8238E+02_JPRB,3.2159E+02_JPRB,1.6080E+02_JPRB,1.3097E+02_JPRB/)
KBO( :, 4,43,16) = (/&
&6.0333E+02_JPRB,6.0297E+02_JPRB,4.5250E+02_JPRB,3.0167E+02_JPRB,1.5084E+02_JPRB,1.4959E+02_JPRB/)
KBO( :, 5,43,16) = (/&
&5.6660E+02_JPRB,5.6626E+02_JPRB,4.2495E+02_JPRB,2.8331E+02_JPRB,1.4166E+02_JPRB,1.8670E+02_JPRB/)
KBO( :, 1,44,16) = (/&
&7.5137E+02_JPRB,7.5091E+02_JPRB,5.6353E+02_JPRB,3.7569E+02_JPRB,1.8785E+02_JPRB,1.3103E+02_JPRB/)
KBO( :, 2,44,16) = (/&
&7.0468E+02_JPRB,7.0426E+02_JPRB,5.2852E+02_JPRB,3.5235E+02_JPRB,1.7618E+02_JPRB,1.2458E+02_JPRB/)
KBO( :, 3,44,16) = (/&
&6.6086E+02_JPRB,6.6046E+02_JPRB,4.9565E+02_JPRB,3.3044E+02_JPRB,1.6522E+02_JPRB,1.3258E+02_JPRB/)
KBO( :, 4,44,16) = (/&
&6.1971E+02_JPRB,6.1934E+02_JPRB,4.6479E+02_JPRB,3.0986E+02_JPRB,1.5494E+02_JPRB,1.5142E+02_JPRB/)
KBO( :, 5,44,16) = (/&
&5.8152E+02_JPRB,5.8117E+02_JPRB,4.3614E+02_JPRB,2.9077E+02_JPRB,1.4539E+02_JPRB,1.8803E+02_JPRB/)
KBO( :, 1,45,16) = (/&
&7.7242E+02_JPRB,7.7196E+02_JPRB,5.7932E+02_JPRB,3.8622E+02_JPRB,1.9312E+02_JPRB,1.3645E+02_JPRB/)
KBO( :, 2,45,16) = (/&
&7.2383E+02_JPRB,7.2339E+02_JPRB,5.4287E+02_JPRB,3.6192E+02_JPRB,1.8097E+02_JPRB,1.2782E+02_JPRB/)
KBO( :, 3,45,16) = (/&
&6.7845E+02_JPRB,6.7804E+02_JPRB,5.0884E+02_JPRB,3.3923E+02_JPRB,1.6962E+02_JPRB,1.3514E+02_JPRB/)
KBO( :, 4,45,16) = (/&
&6.3619E+02_JPRB,6.3581E+02_JPRB,4.7715E+02_JPRB,3.1810E+02_JPRB,1.5906E+02_JPRB,1.5528E+02_JPRB/)
KBO( :, 5,45,16) = (/&
&5.9654E+02_JPRB,5.9618E+02_JPRB,4.4741E+02_JPRB,2.9827E+02_JPRB,1.4914E+02_JPRB,1.9320E+02_JPRB/)
KBO( :, 1,46,16) = (/&
&7.9501E+02_JPRB,7.9453E+02_JPRB,5.9626E+02_JPRB,3.9751E+02_JPRB,1.9876E+02_JPRB,1.4240E+02_JPRB/)
KBO( :, 2,46,16) = (/&
&7.4406E+02_JPRB,7.4362E+02_JPRB,5.5805E+02_JPRB,3.7204E+02_JPRB,1.8602E+02_JPRB,1.3140E+02_JPRB/)
KBO( :, 3,46,16) = (/&
&6.9726E+02_JPRB,6.9684E+02_JPRB,5.2295E+02_JPRB,3.4863E+02_JPRB,1.7432E+02_JPRB,1.3799E+02_JPRB/)
KBO( :, 4,46,16) = (/&
&6.5358E+02_JPRB,6.5318E+02_JPRB,4.9018E+02_JPRB,3.2679E+02_JPRB,1.6340E+02_JPRB,1.5937E+02_JPRB/)
KBO( :, 5,46,16) = (/&
&6.1254E+02_JPRB,6.1218E+02_JPRB,4.5941E+02_JPRB,3.0628E+02_JPRB,1.5314E+02_JPRB,1.9924E+02_JPRB/)
KBO( :, 1,47,16) = (/&
&8.2010E+02_JPRB,8.1961E+02_JPRB,6.1508E+02_JPRB,4.1005E+02_JPRB,2.0503E+02_JPRB,1.4924E+02_JPRB/)
KBO( :, 2,47,16) = (/&
&7.6659E+02_JPRB,7.6613E+02_JPRB,5.7494E+02_JPRB,3.8330E+02_JPRB,1.9165E+02_JPRB,1.3525E+02_JPRB/)
KBO( :, 3,47,16) = (/&
&7.1831E+02_JPRB,7.1788E+02_JPRB,5.3873E+02_JPRB,3.5916E+02_JPRB,1.7958E+02_JPRB,1.3959E+02_JPRB/)
KBO( :, 4,47,16) = (/&
&6.7281E+02_JPRB,6.7241E+02_JPRB,5.0461E+02_JPRB,3.3641E+02_JPRB,1.6821E+02_JPRB,1.6058E+02_JPRB/)
KBO( :, 5,47,16) = (/&
&6.3054E+02_JPRB,6.3016E+02_JPRB,4.7291E+02_JPRB,3.1527E+02_JPRB,1.5764E+02_JPRB,2.0056E+02_JPRB/)
KBO( :, 1,48,16) = (/&
&8.4633E+02_JPRB,8.4583E+02_JPRB,6.3475E+02_JPRB,4.2317E+02_JPRB,2.1159E+02_JPRB,1.5645E+02_JPRB/)
KBO( :, 2,48,16) = (/&
&7.9016E+02_JPRB,7.8968E+02_JPRB,5.9262E+02_JPRB,3.9508E+02_JPRB,1.9755E+02_JPRB,1.4053E+02_JPRB/)
KBO( :, 3,48,16) = (/&
&7.3934E+02_JPRB,7.3890E+02_JPRB,5.5451E+02_JPRB,3.6967E+02_JPRB,1.8484E+02_JPRB,1.4309E+02_JPRB/)
KBO( :, 4,48,16) = (/&
&6.9255E+02_JPRB,6.9213E+02_JPRB,5.1941E+02_JPRB,3.4628E+02_JPRB,1.7314E+02_JPRB,1.6459E+02_JPRB/)
KBO( :, 5,48,16) = (/&
&6.4886E+02_JPRB,6.4847E+02_JPRB,4.8665E+02_JPRB,3.2443E+02_JPRB,1.6222E+02_JPRB,2.0658E+02_JPRB/)
KBO( :, 1,49,16) = (/&
&8.7303E+02_JPRB,8.7251E+02_JPRB,6.5477E+02_JPRB,4.3652E+02_JPRB,2.1826E+02_JPRB,1.6405E+02_JPRB/)
KBO( :, 2,49,16) = (/&
&8.1423E+02_JPRB,8.1374E+02_JPRB,6.1067E+02_JPRB,4.0712E+02_JPRB,2.0356E+02_JPRB,1.4757E+02_JPRB/)
KBO( :, 3,49,16) = (/&
&7.6096E+02_JPRB,7.6050E+02_JPRB,5.7072E+02_JPRB,3.8048E+02_JPRB,1.9025E+02_JPRB,1.4935E+02_JPRB/)
KBO( :, 4,49,16) = (/&
&7.1274E+02_JPRB,7.1231E+02_JPRB,5.3455E+02_JPRB,3.5637E+02_JPRB,1.7819E+02_JPRB,1.7305E+02_JPRB/)
KBO( :, 5,49,16) = (/&
&6.6745E+02_JPRB,6.6705E+02_JPRB,5.0059E+02_JPRB,3.3373E+02_JPRB,1.6687E+02_JPRB,2.2042E+02_JPRB/)
KBO( :, 1,50,16) = (/&
&8.9886E+02_JPRB,8.9832E+02_JPRB,6.7415E+02_JPRB,4.4943E+02_JPRB,2.2472E+02_JPRB,1.7154E+02_JPRB/)
KBO( :, 2,50,16) = (/&
&8.3744E+02_JPRB,8.3694E+02_JPRB,6.2808E+02_JPRB,4.1872E+02_JPRB,2.0936E+02_JPRB,1.5447E+02_JPRB/)
KBO( :, 3,50,16) = (/&
&7.8206E+02_JPRB,7.8159E+02_JPRB,5.8654E+02_JPRB,3.9103E+02_JPRB,1.9552E+02_JPRB,1.5292E+02_JPRB/)
KBO( :, 4,50,16) = (/&
&7.3184E+02_JPRB,7.3140E+02_JPRB,5.4888E+02_JPRB,3.6592E+02_JPRB,1.8296E+02_JPRB,1.7616E+02_JPRB/)
KBO( :, 5,50,16) = (/&
&6.8529E+02_JPRB,6.8488E+02_JPRB,5.1397E+02_JPRB,3.4265E+02_JPRB,1.7133E+02_JPRB,2.2472E+02_JPRB/)
KBO( :, 1,51,16) = (/&
&9.2454E+02_JPRB,9.2398E+02_JPRB,6.9341E+02_JPRB,4.6227E+02_JPRB,2.3114E+02_JPRB,1.7932E+02_JPRB/)
KBO( :, 2,51,16) = (/&
&8.6100E+02_JPRB,8.6049E+02_JPRB,6.4575E+02_JPRB,4.3050E+02_JPRB,2.1525E+02_JPRB,1.6117E+02_JPRB/)
KBO( :, 3,51,16) = (/&
&8.0315E+02_JPRB,8.0267E+02_JPRB,6.0236E+02_JPRB,4.0158E+02_JPRB,2.0079E+02_JPRB,1.5563E+02_JPRB/)
KBO( :, 4,51,16) = (/&
&7.5078E+02_JPRB,7.5033E+02_JPRB,5.6309E+02_JPRB,3.7539E+02_JPRB,1.8770E+02_JPRB,1.7663E+02_JPRB/)
KBO( :, 5,51,16) = (/&
&7.0300E+02_JPRB,7.0257E+02_JPRB,5.2725E+02_JPRB,3.5150E+02_JPRB,1.7575E+02_JPRB,2.2386E+02_JPRB/)
KBO( :, 1,52,16) = (/&
&9.5090E+02_JPRB,9.5033E+02_JPRB,7.1318E+02_JPRB,4.7545E+02_JPRB,2.3773E+02_JPRB,1.8754E+02_JPRB/)
KBO( :, 2,52,16) = (/&
&8.8502E+02_JPRB,8.8448E+02_JPRB,6.6376E+02_JPRB,4.4251E+02_JPRB,2.2126E+02_JPRB,1.6850E+02_JPRB/)
KBO( :, 3,52,16) = (/&
&8.2471E+02_JPRB,8.2421E+02_JPRB,6.1853E+02_JPRB,4.1235E+02_JPRB,2.0618E+02_JPRB,1.6061E+02_JPRB/)
KBO( :, 4,52,16) = (/&
&7.7013E+02_JPRB,7.6967E+02_JPRB,5.7760E+02_JPRB,3.8507E+02_JPRB,1.9253E+02_JPRB,1.8010E+02_JPRB/)
KBO( :, 5,52,16) = (/&
&7.2097E+02_JPRB,7.2053E+02_JPRB,5.4073E+02_JPRB,3.6048E+02_JPRB,1.8024E+02_JPRB,2.2809E+02_JPRB/)
KBO( :, 1,53,16) = (/&
&9.7788E+02_JPRB,9.7729E+02_JPRB,7.3341E+02_JPRB,4.8894E+02_JPRB,2.4447E+02_JPRB,1.9637E+02_JPRB/)
KBO( :, 2,53,16) = (/&
&9.0961E+02_JPRB,9.0906E+02_JPRB,6.8221E+02_JPRB,4.5481E+02_JPRB,2.2740E+02_JPRB,1.7681E+02_JPRB/)
KBO( :, 3,53,16) = (/&
&8.4702E+02_JPRB,8.4651E+02_JPRB,6.3527E+02_JPRB,4.2351E+02_JPRB,2.1176E+02_JPRB,1.6836E+02_JPRB/)
KBO( :, 4,53,16) = (/&
&7.9046E+02_JPRB,7.8999E+02_JPRB,5.9285E+02_JPRB,3.9523E+02_JPRB,1.9762E+02_JPRB,1.8837E+02_JPRB/)
KBO( :, 5,53,16) = (/&
&7.3936E+02_JPRB,7.3892E+02_JPRB,5.5452E+02_JPRB,3.6968E+02_JPRB,1.8484E+02_JPRB,2.4127E+02_JPRB/)
KBO( :, 1,54,16) = (/&
&1.0035E+03_JPRB,1.0029E+03_JPRB,7.5259E+02_JPRB,5.0173E+02_JPRB,2.5087E+02_JPRB,2.0491E+02_JPRB/)
KBO( :, 2,54,16) = (/&
&9.3285E+02_JPRB,9.3229E+02_JPRB,6.9964E+02_JPRB,4.6643E+02_JPRB,2.3321E+02_JPRB,1.8242E+02_JPRB/)
KBO( :, 3,54,16) = (/&
&8.6846E+02_JPRB,8.6794E+02_JPRB,6.5134E+02_JPRB,4.3423E+02_JPRB,2.1712E+02_JPRB,1.7066E+02_JPRB/)
KBO( :, 4,54,16) = (/&
&8.0960E+02_JPRB,8.0911E+02_JPRB,6.0720E+02_JPRB,4.0480E+02_JPRB,2.0240E+02_JPRB,1.8019E+02_JPRB/)
KBO( :, 5,54,16) = (/&
&7.5654E+02_JPRB,7.5608E+02_JPRB,5.6740E+02_JPRB,3.7827E+02_JPRB,1.8914E+02_JPRB,2.2258E+02_JPRB/)
KBO( :, 1,55,16) = (/&
&1.0290E+03_JPRB,1.0283E+03_JPRB,7.7171E+02_JPRB,5.1448E+02_JPRB,2.5724E+02_JPRB,2.1368E+02_JPRB/)
KBO( :, 2,55,16) = (/&
&9.5574E+02_JPRB,9.5517E+02_JPRB,7.1681E+02_JPRB,4.7787E+02_JPRB,2.3894E+02_JPRB,1.8874E+02_JPRB/)
KBO( :, 3,55,16) = (/&
&8.8926E+02_JPRB,8.8873E+02_JPRB,6.6695E+02_JPRB,4.4463E+02_JPRB,2.2232E+02_JPRB,1.7135E+02_JPRB/)
KBO( :, 4,55,16) = (/&
&8.2830E+02_JPRB,8.2781E+02_JPRB,6.2123E+02_JPRB,4.1415E+02_JPRB,2.0708E+02_JPRB,1.6723E+02_JPRB/)
KBO( :, 5,55,16) = (/&
&7.7332E+02_JPRB,7.7285E+02_JPRB,5.7999E+02_JPRB,3.8666E+02_JPRB,1.9333E+02_JPRB,1.9285E+02_JPRB/)
KBO( :, 1,56,16) = (/&
&1.0544E+03_JPRB,1.0538E+03_JPRB,7.9084E+02_JPRB,5.2722E+02_JPRB,2.6389E+02_JPRB,2.2294E+02_JPRB/)
KBO( :, 2,56,16) = (/&
&9.7928E+02_JPRB,9.7870E+02_JPRB,7.3446E+02_JPRB,4.8964E+02_JPRB,2.4482E+02_JPRB,1.9643E+02_JPRB/)
KBO( :, 3,56,16) = (/&
&9.1058E+02_JPRB,9.1004E+02_JPRB,6.8294E+02_JPRB,4.5529E+02_JPRB,2.2765E+02_JPRB,1.7473E+02_JPRB/)
KBO( :, 4,56,16) = (/&
&8.4774E+02_JPRB,8.4724E+02_JPRB,6.3581E+02_JPRB,4.2387E+02_JPRB,2.1194E+02_JPRB,1.6206E+02_JPRB/)
KBO( :, 5,56,16) = (/&
&7.9097E+02_JPRB,7.9049E+02_JPRB,5.9323E+02_JPRB,3.9548E+02_JPRB,1.9774E+02_JPRB,1.7273E+02_JPRB/)
KBO( :, 1,57,16) = (/&
&1.0813E+03_JPRB,1.0806E+03_JPRB,8.1095E+02_JPRB,5.4063E+02_JPRB,2.7119E+02_JPRB,2.3288E+02_JPRB/)
KBO( :, 2,57,16) = (/&
&1.0033E+03_JPRB,1.0027E+03_JPRB,7.5245E+02_JPRB,5.0163E+02_JPRB,2.5082E+02_JPRB,2.0449E+02_JPRB/)
KBO( :, 3,57,16) = (/&
&9.3233E+02_JPRB,9.3177E+02_JPRB,6.9925E+02_JPRB,4.6617E+02_JPRB,2.3308E+02_JPRB,1.8109E+02_JPRB/)
KBO( :, 4,57,16) = (/&
&8.6794E+02_JPRB,8.6742E+02_JPRB,6.5095E+02_JPRB,4.3397E+02_JPRB,2.1699E+02_JPRB,1.6333E+02_JPRB/)
KBO( :, 5,57,16) = (/&
&8.0892E+02_JPRB,8.0843E+02_JPRB,6.0669E+02_JPRB,4.0446E+02_JPRB,2.0223E+02_JPRB,1.5955E+02_JPRB/)
KBO( :, 1,58,16) = (/&
&1.1081E+03_JPRB,1.1074E+03_JPRB,8.3108E+02_JPRB,5.5405E+02_JPRB,2.7884E+02_JPRB,2.4302E+02_JPRB/)
KBO( :, 2,58,16) = (/&
&1.0267E+03_JPRB,1.0261E+03_JPRB,7.7004E+02_JPRB,5.1336E+02_JPRB,2.5668E+02_JPRB,2.1265E+02_JPRB/)
KBO( :, 3,58,16) = (/&
&9.5368E+02_JPRB,9.5311E+02_JPRB,7.1526E+02_JPRB,4.7684E+02_JPRB,2.3842E+02_JPRB,1.8786E+02_JPRB/)
KBO( :, 4,58,16) = (/&
&8.8727E+02_JPRB,8.8673E+02_JPRB,6.6545E+02_JPRB,4.4363E+02_JPRB,2.2182E+02_JPRB,1.6726E+02_JPRB/)
KBO( :, 5,58,16) = (/&
&8.2643E+02_JPRB,8.2594E+02_JPRB,6.1982E+02_JPRB,4.1322E+02_JPRB,2.0661E+02_JPRB,1.5255E+02_JPRB/)
KBO( :, 1,59,16) = (/&
&1.1197E+03_JPRB,1.1190E+03_JPRB,8.3976E+02_JPRB,5.5984E+02_JPRB,2.8216E+02_JPRB,2.4731E+02_JPRB/)
KBO( :, 2,59,16) = (/&
&1.0365E+03_JPRB,1.0359E+03_JPRB,7.7738E+02_JPRB,5.1826E+02_JPRB,2.5916E+02_JPRB,2.1609E+02_JPRB/)
KBO( :, 3,59,16) = (/&
&9.6265E+02_JPRB,9.6208E+02_JPRB,7.2199E+02_JPRB,4.8133E+02_JPRB,2.4066E+02_JPRB,1.9071E+02_JPRB/)
KBO( :, 4,59,16) = (/&
&8.9534E+02_JPRB,8.9480E+02_JPRB,6.7151E+02_JPRB,4.4767E+02_JPRB,2.2384E+02_JPRB,1.6963E+02_JPRB/)
KBO( :, 5,59,16) = (/&
&8.3369E+02_JPRB,8.3319E+02_JPRB,6.2527E+02_JPRB,4.1685E+02_JPRB,2.0842E+02_JPRB,1.5178E+02_JPRB/)


!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
&2.62628E-01_JPRB, 2.29008E-01_JPRB, 1.99692E-01_JPRB, 1.74129E-01_JPRB, 1.51838E-01_JPRB,&
&1.32400E-01_JPRB, 1.15451E-01_JPRB, 1.00672E-01_JPRB, 8.77845E-02_JPRB, 7.65469E-02_JPRB/)
SELFREFO( :, 2) = (/&
&2.45051E-01_JPRB, 2.12961E-01_JPRB, 1.85073E-01_JPRB, 1.60837E-01_JPRB, 1.39775E-01_JPRB,&
&1.21471E-01_JPRB, 1.05564E-01_JPRB, 9.17397E-02_JPRB, 7.97260E-02_JPRB, 6.92856E-02_JPRB/)
SELFREFO( :, 3) = (/&
&2.42194E-01_JPRB, 2.09976E-01_JPRB, 1.82044E-01_JPRB, 1.57827E-01_JPRB, 1.36832E-01_JPRB,&
&1.18630E-01_JPRB, 1.02849E-01_JPRB, 8.91673E-02_JPRB, 7.73057E-02_JPRB, 6.70221E-02_JPRB/)
SELFREFO( :, 4) = (/&
&2.44485E-01_JPRB, 2.11926E-01_JPRB, 1.83702E-01_JPRB, 1.59237E-01_JPRB, 1.38030E-01_JPRB,&
&1.19648E-01_JPRB, 1.03714E-01_JPRB, 8.99014E-02_JPRB, 7.79286E-02_JPRB, 6.75503E-02_JPRB/)
SELFREFO( :, 5) = (/&
&2.43120E-01_JPRB, 2.10743E-01_JPRB, 1.82679E-01_JPRB, 1.58351E-01_JPRB, 1.37263E-01_JPRB,&
&1.18984E-01_JPRB, 1.03139E-01_JPRB, 8.94038E-02_JPRB, 7.74978E-02_JPRB, 6.71774E-02_JPRB/)
SELFREFO( :, 6) = (/&
&2.40558E-01_JPRB, 2.08922E-01_JPRB, 1.81446E-01_JPRB, 1.57583E-01_JPRB, 1.36859E-01_JPRB,&
&1.18860E-01_JPRB, 1.03229E-01_JPRB, 8.96529E-02_JPRB, 7.78624E-02_JPRB, 6.76225E-02_JPRB/)
SELFREFO( :, 7) = (/&
&2.42496E-01_JPRB, 2.10386E-01_JPRB, 1.82528E-01_JPRB, 1.58359E-01_JPRB, 1.37390E-01_JPRB,&
&1.19198E-01_JPRB, 1.03415E-01_JPRB, 8.97211E-02_JPRB, 7.78409E-02_JPRB, 6.75337E-02_JPRB/)
SELFREFO( :, 8) = (/&
&2.39781E-01_JPRB, 2.08227E-01_JPRB, 1.80825E-01_JPRB, 1.57029E-01_JPRB, 1.36365E-01_JPRB,&
&1.18419E-01_JPRB, 1.02836E-01_JPRB, 8.93030E-02_JPRB, 7.75510E-02_JPRB, 6.73456E-02_JPRB/)
SELFREFO( :, 9) = (/&
&2.38707E-01_JPRB, 2.07058E-01_JPRB, 1.79605E-01_JPRB, 1.55792E-01_JPRB, 1.35136E-01_JPRB,&
&1.17219E-01_JPRB, 1.01677E-01_JPRB, 8.81962E-02_JPRB, 7.65026E-02_JPRB, 6.63594E-02_JPRB/)
SELFREFO( :,10) = (/&
&2.29942E-01_JPRB, 2.00668E-01_JPRB, 1.75121E-01_JPRB, 1.52826E-01_JPRB, 1.33370E-01_JPRB,&
&1.16390E-01_JPRB, 1.01572E-01_JPRB, 8.86410E-02_JPRB, 7.73560E-02_JPRB, 6.75077E-02_JPRB/)
SELFREFO( :,11) = (/&
&2.39870E-01_JPRB, 2.08120E-01_JPRB, 1.80573E-01_JPRB, 1.56671E-01_JPRB, 1.35934E-01_JPRB,&
&1.17941E-01_JPRB, 1.02330E-01_JPRB, 8.87854E-02_JPRB, 7.70335E-02_JPRB, 6.68371E-02_JPRB/)
SELFREFO( :,12) = (/&
&2.40196E-01_JPRB, 2.08400E-01_JPRB, 1.80812E-01_JPRB, 1.56877E-01_JPRB, 1.36110E-01_JPRB,&
&1.18092E-01_JPRB, 1.02460E-01_JPRB, 8.88962E-02_JPRB, 7.71284E-02_JPRB, 6.69184E-02_JPRB/)
SELFREFO( :,13) = (/&
&2.40426E-01_JPRB, 2.08603E-01_JPRB, 1.80991E-01_JPRB, 1.57035E-01_JPRB, 1.36249E-01_JPRB,&
&1.18214E-01_JPRB, 1.02567E-01_JPRB, 8.89909E-02_JPRB, 7.72117E-02_JPRB, 6.69917E-02_JPRB/)
SELFREFO( :,14) = (/&
&2.40590E-01_JPRB, 2.08742E-01_JPRB, 1.81110E-01_JPRB, 1.57135E-01_JPRB, 1.36334E-01_JPRB,&
&1.18287E-01_JPRB, 1.02628E-01_JPRB, 8.90428E-02_JPRB, 7.72556E-02_JPRB, 6.70288E-02_JPRB/)
SELFREFO( :,15) = (/&
&2.40634E-01_JPRB, 2.08779E-01_JPRB, 1.81141E-01_JPRB, 1.57162E-01_JPRB, 1.36357E-01_JPRB,&
&1.18306E-01_JPRB, 1.02645E-01_JPRB, 8.90565E-02_JPRB, 7.72673E-02_JPRB, 6.70387E-02_JPRB/)
SELFREFO( :,16) = (/&
&2.40652E-01_JPRB, 2.08793E-01_JPRB, 1.81151E-01_JPRB, 1.57169E-01_JPRB, 1.36362E-01_JPRB,&
&1.18309E-01_JPRB, 1.02647E-01_JPRB, 8.90576E-02_JPRB, 7.72675E-02_JPRB, 6.70383E-02_JPRB/)

FRACREFAO( :, 1) = (/&
!     From P = 
    &0.15579100_JPRB,0.14918099_JPRB,0.14113800_JPRB,0.13127001_JPRB,&
    &0.11796300_JPRB,0.10174300_JPRB,0.08282370_JPRB,0.06238150_JPRB,&
    &0.04213440_JPRB,0.00458968_JPRB,0.00377949_JPRB,0.00298736_JPRB,&
    &0.00220743_JPRB,0.00140644_JPRB,0.00053024_JPRB,0.00007459_JPRB/)
FRACREFAO( :, 2) = (/&
    &0.15292799_JPRB,0.15004000_JPRB,0.14211500_JPRB,0.13176700_JPRB,&
    &0.11821100_JPRB,0.10186300_JPRB,0.08288040_JPRB,0.06241390_JPRB,&
    &0.04220720_JPRB,0.00459006_JPRB,0.00377919_JPRB,0.00298743_JPRB,&
    &0.00220743_JPRB,0.00140644_JPRB,0.00053024_JPRB,0.00007459_JPRB/)
FRACREFAO( :, 3) = (/&
    &0.14386199_JPRB,0.15125300_JPRB,0.14650001_JPRB,0.13377000_JPRB,&
    &0.11895900_JPRB,0.10229400_JPRB,0.08312110_JPRB,0.06239520_JPRB,&
    &0.04225560_JPRB,0.00459428_JPRB,0.00378865_JPRB,0.00298860_JPRB,&
    &0.00220743_JPRB,0.00140644_JPRB,0.00053024_JPRB,0.00007459_JPRB/)
FRACREFAO( :, 4) = (/&
    &0.14359100_JPRB,0.14561599_JPRB,0.14479300_JPRB,0.13740200_JPRB,&
    &0.12150100_JPRB,0.10315400_JPRB,0.08355480_JPRB,0.06247240_JPRB,&
    &0.04230980_JPRB,0.00459916_JPRB,0.00378373_JPRB,0.00300063_JPRB,&
    &0.00221111_JPRB,0.00140644_JPRB,0.00053024_JPRB,0.00007459_JPRB/)
FRACREFAO( :, 5) = (/&
    &0.14337599_JPRB,0.14451601_JPRB,0.14238000_JPRB,0.13520500_JPRB,&
    &0.12354200_JPRB,0.10581200_JPRB,0.08451810_JPRB,0.06262440_JPRB,&
    &0.04239590_JPRB,0.00460297_JPRB,0.00378701_JPRB,0.00300466_JPRB,&
    &0.00221899_JPRB,0.00141020_JPRB,0.00053024_JPRB,0.00007459_JPRB/)
FRACREFAO( :, 6) = (/&
    &0.14322001_JPRB,0.14397401_JPRB,0.14117201_JPRB,0.13401900_JPRB,&
    &0.12255500_JPRB,0.10774100_JPRB,0.08617650_JPRB,0.06296420_JPRB,&
    &0.04249590_JPRB,0.00463406_JPRB,0.00378241_JPRB,0.00302037_JPRB,&
    &0.00221583_JPRB,0.00141103_JPRB,0.00053814_JPRB,0.00007991_JPRB/)
FRACREFAO( :, 7) = (/&
    &0.14309500_JPRB,0.14364301_JPRB,0.14043900_JPRB,0.13348100_JPRB,&
    &0.12211600_JPRB,0.10684700_JPRB,0.08820590_JPRB,0.06374610_JPRB,&
    &0.04264730_JPRB,0.00464231_JPRB,0.00384022_JPRB,0.00303427_JPRB,&
    &0.00221825_JPRB,0.00140943_JPRB,0.00055564_JPRB,0.00007991_JPRB/)
FRACREFAO( :, 8) = (/&
    &0.15579100_JPRB,0.14918099_JPRB,0.14113800_JPRB,0.13127001_JPRB,&
    &0.11796300_JPRB,0.10174300_JPRB,0.08282370_JPRB,0.06238150_JPRB,&
    &0.04213440_JPRB,0.00458968_JPRB,0.00377949_JPRB,0.00298736_JPRB,&
    &0.00220743_JPRB,0.00140644_JPRB,0.00053024_JPRB,0.00007459_JPRB/)
FRACREFAO( :, 9) = (/&
    &0.15937001_JPRB,0.15159500_JPRB,0.14242800_JPRB,0.13078900_JPRB,&
    &0.11671300_JPRB,0.10035700_JPRB,0.08143450_JPRB,0.06093850_JPRB,&
    &0.04105320_JPRB,0.00446233_JPRB,0.00369844_JPRB,0.00293784_JPRB,&
    &0.00216425_JPRB,0.00143403_JPRB,0.00054571_JPRB,0.00007991_JPRB/)

FRACREFBO( :, 1) = (/&
!     From P = 1.17 mb.
    &0.15558299_JPRB,0.14930600_JPRB,0.14104301_JPRB,0.13124099_JPRB,&
    &0.11792900_JPRB,0.10159200_JPRB,0.08314130_JPRB,0.06240450_JPRB,&
    &0.04217020_JPRB,0.00459313_JPRB,0.00379798_JPRB,0.00299835_JPRB,&
    &0.00218950_JPRB,0.00140615_JPRB,0.00053010_JPRB,0.00007457_JPRB/)
FRACREFBO( :, 2) = (/&
    &0.15592700_JPRB,0.14918999_JPRB,0.14095700_JPRB,0.13115700_JPRB,&
    &0.11788900_JPRB,0.10158000_JPRB,0.08313780_JPRB,0.06240240_JPRB,&
    &0.04217000_JPRB,0.00459313_JPRB,0.00379798_JPRB,0.00299835_JPRB,&
    &0.00218950_JPRB,0.00140615_JPRB,0.00053010_JPRB,0.00007457_JPRB/)
FRACREFBO( :, 3) = (/&
    &0.15949000_JPRB,0.15014900_JPRB,0.14162201_JPRB,0.13080800_JPRB,&
    &0.11713500_JPRB,0.10057100_JPRB,0.08170080_JPRB,0.06128110_JPRB,&
    &0.04165600_JPRB,0.00459202_JPRB,0.00379835_JPRB,0.00299717_JPRB,&
    &0.00218958_JPRB,0.00140616_JPRB,0.00053010_JPRB,0.00007457_JPRB/)
FRACREFBO( :, 4) = (/&
    &0.15967900_JPRB,0.15038200_JPRB,0.14196999_JPRB,0.13074800_JPRB,&
    &0.11701700_JPRB,0.10053000_JPRB,0.08160790_JPRB,0.06122690_JPRB,&
    &0.04128310_JPRB,0.00456598_JPRB,0.00379486_JPRB,0.00299457_JPRB,&
    &0.00219016_JPRB,0.00140619_JPRB,0.00053011_JPRB,0.00007456_JPRB/)
FRACREFBO( :, 5) = (/&
    &0.15989800_JPRB,0.15057300_JPRB,0.14207700_JPRB,0.13068600_JPRB,&
    &0.11682900_JPRB,0.10053900_JPRB,0.08163610_JPRB,0.06121870_JPRB,&
    &0.04121690_JPRB,0.00449061_JPRB,0.00371235_JPRB,0.00294207_JPRB,&
    &0.00217778_JPRB,0.00139877_JPRB,0.00053011_JPRB,0.00007455_JPRB/)
FRACREFBO( :, 6) = (/&
    &0.15950100_JPRB,0.15112500_JPRB,0.14199100_JPRB,0.13071300_JPRB,&
    &0.11680800_JPRB,0.10054600_JPRB,0.08179050_JPRB,0.06120910_JPRB,&
    &0.04126050_JPRB,0.00444324_JPRB,0.00366843_JPRB,0.00289369_JPRB,&
    &0.00211550_JPRB,0.00134746_JPRB,0.00050874_JPRB,0.00007863_JPRB/)

!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB4
