!OCL SCALAR
SUBROUTINE RRTM_KGB3

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 3:  500-630 cm-1 (low - H2O,CO2; high - H2O,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO3 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
           &FRACREFBO  ,FORREFO    ,ABSN2OAO   ,ABSN2OBO
USE YOERRTA3 , ONLY : ABSN2OA ,ABSN2OB  ,ETAREF    ,H2OREF     ,&
           &N2OREF     ,CO2REF     ,STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE
FORREFO( :) = (/&
      &1.76842E-04_JPRB, 1.77913E-04_JPRB, 1.25186E-04_JPRB, 1.07912E-04_JPRB,&
      &1.05217E-04_JPRB, 7.48726E-05_JPRB, 1.11701E-04_JPRB, 7.68921E-05_JPRB,&
      &9.87242E-05_JPRB, 9.85711E-05_JPRB, 6.16557E-05_JPRB,-1.61291E-05_JPRB,&
     &-1.26794E-04_JPRB,-1.19011E-04_JPRB,-2.67814E-04_JPRB, 6.95005E-05_JPRB/)

ABSN2OAO( :) = (/&
     &1.50387E-01_JPRB,2.91407E-01_JPRB,6.28803E-01_JPRB,9.65619E-01_JPRB,&
     &1.15054E-00_JPRB,2.23424E-00_JPRB,1.83392E-00_JPRB,1.39033E-00_JPRB,&
     &4.28457E-01_JPRB,2.73502E-01_JPRB,1.84307E-01_JPRB,1.61325E-01_JPRB,&
     &7.66314E-02_JPRB,1.33862E-01_JPRB,6.71196E-07_JPRB,1.59293E-06_JPRB/)

ABSN2OBO( :) = (/&
     &9.37044E-05_JPRB,1.23318E-03_JPRB,7.91720E-03_JPRB,5.33005E-02_JPRB,&
     &1.72343E-01_JPRB,4.29571E-01_JPRB,1.01288E+00_JPRB,3.83863E+00_JPRB,&
     &1.15312E+01_JPRB,1.08383E+00_JPRB,2.24847E+00_JPRB,1.51268E+00_JPRB,&
     &3.33177E-01_JPRB,7.82102E-01_JPRB,3.44631E-01_JPRB,1.61039E-03_JPRB/)

ETAREF( :) = (/&
     &_ZERO_,0.125_JPRB,0.25_JPRB,0.375_JPRB,_HALF_,0.625_JPRB,0.75_JPRB,0.875_JPRB,0.9875_JPRB,_ONE_/)

H2OREF( :) = (/&
     &1.87599E-02_JPRB,1.22233E-02_JPRB,5.89086E-03_JPRB,2.76753E-03_JPRB,1.40651E-03_JPRB, &
     &7.59698E-04_JPRB,3.88758E-04_JPRB,1.65422E-04_JPRB,3.71895E-05_JPRB,7.47648E-06_JPRB, &
     &4.30818E-06_JPRB,3.33194E-06_JPRB,3.20393E-06_JPRB,3.16186E-06_JPRB,3.25235E-06_JPRB, &
     &3.42258E-06_JPRB,3.62884E-06_JPRB,3.91482E-06_JPRB,4.14875E-06_JPRB,4.30810E-06_JPRB,&
     &4.44204E-06_JPRB,4.57783E-06_JPRB,4.70865E-06_JPRB,4.79432E-06_JPRB,4.86971E-06_JPRB, &
     &4.92603E-06_JPRB,4.96688E-06_JPRB,4.99628E-06_JPRB,5.05266E-06_JPRB,5.12658E-06_JPRB, &
     &5.25028E-06_JPRB,5.35708E-06_JPRB,5.45085E-06_JPRB,5.48304E-06_JPRB,5.50000E-06_JPRB, &
     &5.50000E-06_JPRB,5.45359E-06_JPRB,5.40468E-06_JPRB,5.35576E-06_JPRB,5.25327E-06_JPRB,&
     &5.14362E-06_JPRB,5.03396E-06_JPRB,4.87662E-06_JPRB,4.69787E-06_JPRB,4.51911E-06_JPRB, &
     &4.33600E-06_JPRB,4.14416E-06_JPRB,3.95232E-06_JPRB,3.76048E-06_JPRB,3.57217E-06_JPRB, &
     &3.38549E-06_JPRB,3.19881E-06_JPRB,3.01212E-06_JPRB,2.82621E-06_JPRB,2.64068E-06_JPRB, &
     &2.45515E-06_JPRB,2.26962E-06_JPRB,2.08659E-06_JPRB,1.93029E-06_JPRB/)

N2OREF( :) = (/&
     &3.20000E-07_JPRB,3.20000E-07_JPRB,3.20000E-07_JPRB,3.20000E-07_JPRB,3.20000E-07_JPRB,&
     &3.19652E-07_JPRB,3.15324E-07_JPRB,3.03830E-07_JPRB,2.94221E-07_JPRB,2.84953E-07_JPRB,&
     &2.76714E-07_JPRB,2.64709E-07_JPRB,2.42847E-07_JPRB,2.09547E-07_JPRB,1.71945E-07_JPRB,&
     &1.37491E-07_JPRB,1.13319E-07_JPRB,1.00354E-07_JPRB,9.12812E-08_JPRB,8.54633E-08_JPRB,&
     &8.03631E-08_JPRB,7.33718E-08_JPRB,6.59754E-08_JPRB,5.60386E-08_JPRB,4.70901E-08_JPRB,&
     &3.99774E-08_JPRB,3.29786E-08_JPRB,2.60642E-08_JPRB,2.10663E-08_JPRB,1.65918E-08_JPRB,&
     &1.30167E-08_JPRB,1.00900E-08_JPRB,7.62490E-09_JPRB,6.11592E-09_JPRB,4.66725E-09_JPRB,&
     &3.28574E-09_JPRB,2.84838E-09_JPRB,2.46198E-09_JPRB,2.07557E-09_JPRB,1.85507E-09_JPRB,&
     &1.65675E-09_JPRB,1.45843E-09_JPRB,1.31948E-09_JPRB,1.20716E-09_JPRB,1.09485E-09_JPRB,&
     &9.97803E-10_JPRB,9.31260E-10_JPRB,8.64721E-10_JPRB,7.98181E-10_JPRB,7.51380E-10_JPRB,&
     &7.13670E-10_JPRB,6.75960E-10_JPRB,6.38250E-10_JPRB,6.09811E-10_JPRB,5.85998E-10_JPRB,&
     &5.62185E-10_JPRB,5.38371E-10_JPRB,5.15183E-10_JPRB,4.98660E-10_JPRB/)

CO2REF( :) = (/&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.55000E-04_JPRB,3.55000E-04_JPRB,3.55000E-04_JPRB,&
     &3.5470873E-04_JPRB, 3.5427220E-04_JPRB, 3.5383567E-04_JPRB,&
     &3.5339911E-04_JPRB, 3.5282588E-04_JPRB, 3.5079606E-04_JPRB/) 

STRRAT = 1.19268_JPRB

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different water vapor to CO2 ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = h2o/(h20 + (rat) * co2), where rat is the ratio of the integrated
!     line strength in the band of co2 to that of h2o.  For instance,
!     JS=1 refers to dry air (eta = 0), JS = 10 corresponds to eta = 1.0.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature
!     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 1) = (/&
&1.3905E-05_JPRB,5.5491E-04_JPRB,9.4069E-04_JPRB,1.2683E-03_JPRB,1.5758E-03_JPRB,1.8657E-03_JPRB,&
&2.1271E-03_JPRB,2.3310E-03_JPRB,2.2238E-03_JPRB,1.2098E-03_JPRB/)
KAO( :, 2, 1, 1) = (/&
&1.8718E-05_JPRB,6.2254E-04_JPRB,1.0419E-03_JPRB,1.3944E-03_JPRB,1.7096E-03_JPRB,2.0070E-03_JPRB,&
&2.2783E-03_JPRB,2.4921E-03_JPRB,2.4893E-03_JPRB,1.3329E-03_JPRB/)
KAO( :, 3, 1, 1) = (/&
&2.5277E-05_JPRB,7.0791E-04_JPRB,1.1679E-03_JPRB,1.5540E-03_JPRB,1.8826E-03_JPRB,2.1855E-03_JPRB,&
&2.4637E-03_JPRB,2.6836E-03_JPRB,2.4870E-03_JPRB,1.4683E-03_JPRB/)
KAO( :, 4, 1, 1) = (/&
&3.3974E-05_JPRB,8.1479E-04_JPRB,1.3277E-03_JPRB,1.7495E-03_JPRB,2.1019E-03_JPRB,2.4115E-03_JPRB,&
&2.6955E-03_JPRB,2.9144E-03_JPRB,2.6786E-03_JPRB,1.5835E-03_JPRB/)
KAO( :, 5, 1, 1) = (/&
&4.5018E-05_JPRB,9.4621E-04_JPRB,1.5225E-03_JPRB,1.9888E-03_JPRB,2.3735E-03_JPRB,2.6924E-03_JPRB,&
&2.9767E-03_JPRB,3.1904E-03_JPRB,2.9199E-03_JPRB,1.7196E-03_JPRB/)
KAO( :, 1, 2, 1) = (/&
&1.0592E-05_JPRB,4.4499E-04_JPRB,7.6480E-04_JPRB,1.0361E-03_JPRB,1.2851E-03_JPRB,1.5183E-03_JPRB,&
&1.7260E-03_JPRB,1.8861E-03_JPRB,1.7869E-03_JPRB,9.5189E-04_JPRB/)
KAO( :, 2, 2, 1) = (/&
&1.4233E-05_JPRB,4.9754E-04_JPRB,8.4386E-04_JPRB,1.1364E-03_JPRB,1.3930E-03_JPRB,1.6308E-03_JPRB,&
&1.8450E-03_JPRB,2.0088E-03_JPRB,1.9843E-03_JPRB,1.0406E-03_JPRB/)
KAO( :, 3, 2, 1) = (/&
&1.9306E-05_JPRB,5.6436E-04_JPRB,9.4285E-04_JPRB,1.2611E-03_JPRB,1.5318E-03_JPRB,1.7753E-03_JPRB,&
&1.9931E-03_JPRB,2.1588E-03_JPRB,2.0128E-03_JPRB,1.1498E-03_JPRB/)
KAO( :, 4, 2, 1) = (/&
&2.6119E-05_JPRB,6.4842E-04_JPRB,1.0680E-03_JPRB,1.4147E-03_JPRB,1.7071E-03_JPRB,1.9567E-03_JPRB,&
&2.1789E-03_JPRB,2.3401E-03_JPRB,2.1538E-03_JPRB,1.2358E-03_JPRB/)
KAO( :, 5, 2, 1) = (/&
&3.4871E-05_JPRB,7.5256E-04_JPRB,1.2221E-03_JPRB,1.6045E-03_JPRB,1.9204E-03_JPRB,2.1824E-03_JPRB,&
&2.4047E-03_JPRB,2.5599E-03_JPRB,2.3558E-03_JPRB,1.3458E-03_JPRB/)
KAO( :, 1, 3, 1) = (/&
&7.6650E-06_JPRB,3.4947E-04_JPRB,6.0867E-04_JPRB,8.3119E-04_JPRB,1.0323E-03_JPRB,1.2185E-03_JPRB,&
&1.3830E-03_JPRB,1.5087E-03_JPRB,1.4187E-03_JPRB,7.5325E-04_JPRB/)
KAO( :, 2, 3, 1) = (/&
&1.0208E-05_JPRB,3.8799E-04_JPRB,6.6727E-04_JPRB,9.0569E-04_JPRB,1.1140E-03_JPRB,1.3039E-03_JPRB,&
&1.4728E-03_JPRB,1.5994E-03_JPRB,1.5541E-03_JPRB,8.1826E-04_JPRB/)
KAO( :, 3, 3, 1) = (/&
&1.3852E-05_JPRB,4.3745E-04_JPRB,7.4132E-04_JPRB,9.9801E-04_JPRB,1.2192E-03_JPRB,1.4137E-03_JPRB,&
&1.5849E-03_JPRB,1.7123E-03_JPRB,1.6593E-03_JPRB,8.9528E-04_JPRB/)
KAO( :, 4, 3, 1) = (/&
&1.8873E-05_JPRB,5.0084E-04_JPRB,8.3488E-04_JPRB,1.1136E-03_JPRB,1.3505E-03_JPRB,1.5529E-03_JPRB,&
&1.7249E-03_JPRB,1.8487E-03_JPRB,1.7141E-03_JPRB,9.6472E-04_JPRB/)
KAO( :, 5, 3, 1) = (/&
&2.5412E-05_JPRB,5.7989E-04_JPRB,9.5083E-04_JPRB,1.2577E-03_JPRB,1.5110E-03_JPRB,1.7265E-03_JPRB,&
&1.9001E-03_JPRB,2.0154E-03_JPRB,1.8592E-03_JPRB,1.0514E-03_JPRB/)
KAO( :, 1, 4, 1) = (/&
&5.5327E-06_JPRB,2.7370E-04_JPRB,4.8202E-04_JPRB,6.6293E-04_JPRB,8.2705E-04_JPRB,9.7621E-04_JPRB,&
&1.1071E-03_JPRB,1.2149E-03_JPRB,1.1365E-03_JPRB,6.2235E-04_JPRB/)
KAO( :, 2, 4, 1) = (/&
&7.2381E-06_JPRB,3.0138E-04_JPRB,5.2416E-04_JPRB,7.1697E-04_JPRB,8.8620E-04_JPRB,1.0391E-03_JPRB,&
&1.1730E-03_JPRB,1.2726E-03_JPRB,1.2113E-03_JPRB,6.7320E-04_JPRB/)
KAO( :, 3, 4, 1) = (/&
&9.7698E-06_JPRB,3.3721E-04_JPRB,5.7856E-04_JPRB,7.8512E-04_JPRB,9.6459E-04_JPRB,1.1210E-03_JPRB,&
&1.2565E-03_JPRB,1.3549E-03_JPRB,1.3452E-03_JPRB,7.2416E-04_JPRB/)
KAO( :, 4, 4, 1) = (/&
&1.3344E-05_JPRB,3.8381E-04_JPRB,6.4739E-04_JPRB,8.7038E-04_JPRB,1.0615E-03_JPRB,1.2252E-03_JPRB,&
&1.3612E-03_JPRB,1.4576E-03_JPRB,1.3655E-03_JPRB,7.8325E-04_JPRB/)
KAO( :, 5, 4, 1) = (/&
&1.8090E-05_JPRB,4.4258E-04_JPRB,7.3288E-04_JPRB,9.7754E-04_JPRB,1.1813E-03_JPRB,1.3549E-03_JPRB,&
&1.4926E-03_JPRB,1.5822E-03_JPRB,1.4607E-03_JPRB,8.5221E-04_JPRB/)
KAO( :, 1, 5, 1) = (/&
&4.0810E-06_JPRB,2.1551E-04_JPRB,3.8283E-04_JPRB,5.2940E-04_JPRB,6.6368E-04_JPRB,7.8503E-04_JPRB,&
&8.8897E-04_JPRB,9.7870E-04_JPRB,9.2885E-04_JPRB,5.3112E-04_JPRB/)
KAO( :, 2, 5, 1) = (/&
&5.1916E-06_JPRB,2.3507E-04_JPRB,4.1271E-04_JPRB,5.6826E-04_JPRB,7.0568E-04_JPRB,8.2971E-04_JPRB,&
&9.3695E-04_JPRB,1.0168E-03_JPRB,9.5220E-04_JPRB,5.6840E-04_JPRB/)
KAO( :, 3, 5, 1) = (/&
&6.9159E-06_JPRB,2.6088E-04_JPRB,4.5208E-04_JPRB,6.1797E-04_JPRB,7.6301E-04_JPRB,8.8979E-04_JPRB,&
&9.9853E-04_JPRB,1.0759E-03_JPRB,1.0389E-03_JPRB,6.0777E-04_JPRB/)
KAO( :, 4, 5, 1) = (/&
&9.4196E-06_JPRB,2.9480E-04_JPRB,5.0274E-04_JPRB,6.8088E-04_JPRB,8.3550E-04_JPRB,9.6746E-04_JPRB,&
&1.0764E-03_JPRB,1.1522E-03_JPRB,1.1313E-03_JPRB,6.5577E-04_JPRB/)
KAO( :, 5, 5, 1) = (/&
&1.2823E-05_JPRB,3.3834E-04_JPRB,5.6555E-04_JPRB,7.6000E-04_JPRB,9.2459E-04_JPRB,1.0640E-03_JPRB,&
&1.1745E-03_JPRB,1.2456E-03_JPRB,1.1599E-03_JPRB,7.1205E-04_JPRB/)
KAO( :, 1, 6, 1) = (/&
&3.0745E-06_JPRB,1.7028E-04_JPRB,3.0467E-04_JPRB,4.2351E-04_JPRB,5.3324E-04_JPRB,6.3166E-04_JPRB,&
&7.1362E-04_JPRB,7.7595E-04_JPRB,7.2555E-04_JPRB,4.6766E-04_JPRB/)
KAO( :, 2, 6, 1) = (/&
&3.7467E-06_JPRB,1.8364E-04_JPRB,3.2533E-04_JPRB,4.4992E-04_JPRB,5.6174E-04_JPRB,6.6289E-04_JPRB,&
&7.4918E-04_JPRB,8.1992E-04_JPRB,7.7217E-04_JPRB,4.9540E-04_JPRB/)
KAO( :, 3, 6, 1) = (/&
&4.8844E-06_JPRB,2.0189E-04_JPRB,3.5318E-04_JPRB,4.8611E-04_JPRB,6.0248E-04_JPRB,7.0548E-04_JPRB,&
&7.9343E-04_JPRB,8.5556E-04_JPRB,8.1719E-04_JPRB,5.2871E-04_JPRB/)
KAO( :, 4, 6, 1) = (/&
&6.5875E-06_JPRB,2.2623E-04_JPRB,3.8987E-04_JPRB,5.3174E-04_JPRB,6.5615E-04_JPRB,7.6255E-04_JPRB,&
&8.5105E-04_JPRB,9.1164E-04_JPRB,9.0776E-04_JPRB,5.6738E-04_JPRB/)
KAO( :, 5, 6, 1) = (/&
&8.9782E-06_JPRB,2.5797E-04_JPRB,4.3574E-04_JPRB,5.8945E-04_JPRB,7.2180E-04_JPRB,8.3401E-04_JPRB,&
&9.2288E-04_JPRB,9.8059E-04_JPRB,9.2715E-04_JPRB,6.1340E-04_JPRB/)
KAO( :, 1, 7, 1) = (/&
&2.3852E-06_JPRB,1.3537E-04_JPRB,2.4376E-04_JPRB,3.4046E-04_JPRB,4.2953E-04_JPRB,5.0877E-04_JPRB,&
&5.7353E-04_JPRB,6.1192E-04_JPRB,5.7270E-04_JPRB,4.3319E-04_JPRB/)
KAO( :, 2, 7, 1) = (/&
&2.7620E-06_JPRB,1.4429E-04_JPRB,2.5761E-04_JPRB,3.5752E-04_JPRB,4.4861E-04_JPRB,5.3102E-04_JPRB,&
&5.9966E-04_JPRB,6.5817E-04_JPRB,6.2541E-04_JPRB,4.5750E-04_JPRB/)
KAO( :, 3, 7, 1) = (/&
&3.4880E-06_JPRB,1.5701E-04_JPRB,2.7701E-04_JPRB,3.8344E-04_JPRB,4.7691E-04_JPRB,5.6092E-04_JPRB,&
&6.3220E-04_JPRB,6.8391E-04_JPRB,6.4333E-04_JPRB,4.8664E-04_JPRB/)
KAO( :, 4, 7, 1) = (/&
&4.6192E-06_JPRB,1.7428E-04_JPRB,3.0330E-04_JPRB,4.1640E-04_JPRB,5.1608E-04_JPRB,6.0192E-04_JPRB,&
&6.7387E-04_JPRB,7.2302E-04_JPRB,7.0029E-04_JPRB,5.2115E-04_JPRB/)
KAO( :, 5, 7, 1) = (/&
&6.2659E-06_JPRB,1.9723E-04_JPRB,3.3668E-04_JPRB,4.5828E-04_JPRB,5.6442E-04_JPRB,6.5465E-04_JPRB,&
&7.2699E-04_JPRB,7.7405E-04_JPRB,7.7413E-04_JPRB,5.6002E-04_JPRB/)
KAO( :, 1, 8, 1) = (/&
&1.9015E-06_JPRB,1.0820E-04_JPRB,1.9592E-04_JPRB,2.7484E-04_JPRB,3.4688E-04_JPRB,4.0988E-04_JPRB,&
&4.6037E-04_JPRB,4.8747E-04_JPRB,4.5723E-04_JPRB,4.3074E-04_JPRB/)
KAO( :, 2, 8, 1) = (/&
&2.0897E-06_JPRB,1.1410E-04_JPRB,2.0489E-04_JPRB,2.8543E-04_JPRB,3.5954E-04_JPRB,4.2599E-04_JPRB,&
&4.8075E-04_JPRB,5.2102E-04_JPRB,4.8940E-04_JPRB,4.6091E-04_JPRB/)
KAO( :, 3, 8, 1) = (/&
&2.5320E-06_JPRB,1.2277E-04_JPRB,2.1834E-04_JPRB,3.0321E-04_JPRB,3.7874E-04_JPRB,4.4717E-04_JPRB,&
&5.0489E-04_JPRB,5.5180E-04_JPRB,5.2338E-04_JPRB,4.9080E-04_JPRB/)
KAO( :, 4, 8, 1) = (/&
&3.2727E-06_JPRB,1.3498E-04_JPRB,2.3690E-04_JPRB,3.2720E-04_JPRB,4.0672E-04_JPRB,4.7636E-04_JPRB,&
&5.3491E-04_JPRB,5.7561E-04_JPRB,5.5051E-04_JPRB,5.1978E-04_JPRB/)
KAO( :, 5, 8, 1) = (/&
&4.3856E-06_JPRB,1.5147E-04_JPRB,2.6111E-04_JPRB,3.5765E-04_JPRB,4.4264E-04_JPRB,5.1502E-04_JPRB,&
&5.7382E-04_JPRB,6.1302E-04_JPRB,6.1438E-04_JPRB,5.4976E-04_JPRB/)
KAO( :, 1, 9, 1) = (/&
&1.5482E-06_JPRB,8.7052E-05_JPRB,1.5839E-04_JPRB,2.2300E-04_JPRB,2.8105E-04_JPRB,3.3090E-04_JPRB,&
&3.6936E-04_JPRB,3.8992E-04_JPRB,3.6561E-04_JPRB,5.0307E-04_JPRB/)
KAO( :, 2, 9, 1) = (/&
&1.6233E-06_JPRB,9.0800E-05_JPRB,1.6386E-04_JPRB,2.2916E-04_JPRB,2.8933E-04_JPRB,3.4270E-04_JPRB,&
&3.8603E-04_JPRB,4.1137E-04_JPRB,3.8679E-04_JPRB,5.3034E-04_JPRB/)
KAO( :, 3, 9, 1) = (/&
&1.8727E-06_JPRB,9.6605E-05_JPRB,1.7299E-04_JPRB,2.4068E-04_JPRB,3.0216E-04_JPRB,3.5768E-04_JPRB,&
&4.0386E-04_JPRB,4.4306E-04_JPRB,4.2523E-04_JPRB,5.5823E-04_JPRB/)
KAO( :, 4, 9, 1) = (/&
&2.3460E-06_JPRB,1.0514E-04_JPRB,1.8594E-04_JPRB,2.5798E-04_JPRB,3.2158E-04_JPRB,3.7830E-04_JPRB,&
&4.2604E-04_JPRB,4.6061E-04_JPRB,4.3830E-04_JPRB,5.8904E-04_JPRB/)
KAO( :, 5, 9, 1) = (/&
&3.0835E-06_JPRB,1.1691E-04_JPRB,2.0336E-04_JPRB,2.8015E-04_JPRB,3.4814E-04_JPRB,4.0638E-04_JPRB,&
&4.5421E-04_JPRB,4.8658E-04_JPRB,4.7615E-04_JPRB,6.2435E-04_JPRB/)
KAO( :, 1,10, 1) = (/&
&1.2799E-06_JPRB,7.0646E-05_JPRB,1.2898E-04_JPRB,1.8180E-04_JPRB,2.2870E-04_JPRB,2.6728E-04_JPRB,&
&2.9678E-04_JPRB,3.1565E-04_JPRB,2.9877E-04_JPRB,5.6519E-04_JPRB/)
KAO( :, 2,10, 1) = (/&
&1.2987E-06_JPRB,7.2906E-05_JPRB,1.3215E-04_JPRB,1.8535E-04_JPRB,2.3421E-04_JPRB,2.7695E-04_JPRB,&
&3.1130E-04_JPRB,3.2886E-04_JPRB,3.1021E-04_JPRB,5.8706E-04_JPRB/)
KAO( :, 3,10, 1) = (/&
&1.4353E-06_JPRB,7.6915E-05_JPRB,1.3835E-04_JPRB,1.9290E-04_JPRB,2.4295E-04_JPRB,2.8803E-04_JPRB,&
&3.2514E-04_JPRB,3.5354E-04_JPRB,3.3578E-04_JPRB,6.1412E-04_JPRB/)
KAO( :, 4,10, 1) = (/&
&1.7387E-06_JPRB,8.2894E-05_JPRB,1.4759E-04_JPRB,2.0528E-04_JPRB,2.5663E-04_JPRB,3.0293E-04_JPRB,&
&3.4175E-04_JPRB,3.7216E-04_JPRB,3.5751E-04_JPRB,6.4985E-04_JPRB/)
KAO( :, 5,10, 1) = (/&
&2.2343E-06_JPRB,9.1469E-05_JPRB,1.6022E-04_JPRB,2.2168E-04_JPRB,2.7630E-04_JPRB,3.2346E-04_JPRB,&
&3.6268E-04_JPRB,3.8938E-04_JPRB,3.7492E-04_JPRB,6.9583E-04_JPRB/)
KAO( :, 1,11, 1) = (/&
&1.0543E-06_JPRB,5.7983E-05_JPRB,1.0582E-04_JPRB,1.4919E-04_JPRB,1.8791E-04_JPRB,2.2000E-04_JPRB,&
&2.4433E-04_JPRB,2.5995E-04_JPRB,2.4592E-04_JPRB,5.0307E-04_JPRB/)
KAO( :, 2,11, 1) = (/&
&1.0726E-06_JPRB,5.9907E-05_JPRB,1.0858E-04_JPRB,1.5223E-04_JPRB,1.9244E-04_JPRB,2.2775E-04_JPRB,&
&2.5610E-04_JPRB,2.7046E-04_JPRB,2.5615E-04_JPRB,5.1588E-04_JPRB/)
KAO( :, 3,11, 1) = (/&
&1.1894E-06_JPRB,6.3212E-05_JPRB,1.1383E-04_JPRB,1.5870E-04_JPRB,1.9979E-04_JPRB,2.3693E-04_JPRB,&
&2.6747E-04_JPRB,2.9154E-04_JPRB,2.7919E-04_JPRB,5.3855E-04_JPRB/)
KAO( :, 4,11, 1) = (/&
&1.4390E-06_JPRB,6.8258E-05_JPRB,1.2145E-04_JPRB,1.6906E-04_JPRB,2.1138E-04_JPRB,2.4948E-04_JPRB,&
&2.8136E-04_JPRB,3.0581E-04_JPRB,2.9553E-04_JPRB,5.7296E-04_JPRB/)
KAO( :, 5,11, 1) = (/&
&1.8470E-06_JPRB,7.5489E-05_JPRB,1.3202E-04_JPRB,1.8257E-04_JPRB,2.2782E-04_JPRB,2.6681E-04_JPRB,&
&2.9892E-04_JPRB,3.2058E-04_JPRB,3.1052E-04_JPRB,6.1818E-04_JPRB/)
KAO( :, 1,12, 1) = (/&
&8.6798E-07_JPRB,4.7553E-05_JPRB,8.6730E-05_JPRB,1.2226E-04_JPRB,1.5413E-04_JPRB,1.8085E-04_JPRB,&
&2.0088E-04_JPRB,2.1368E-04_JPRB,2.0252E-04_JPRB,4.1925E-04_JPRB/)
KAO( :, 2,12, 1) = (/&
&8.8495E-07_JPRB,4.9183E-05_JPRB,8.9118E-05_JPRB,1.2490E-04_JPRB,1.5790E-04_JPRB,1.8699E-04_JPRB,&
&2.1049E-04_JPRB,2.2231E-04_JPRB,2.1170E-04_JPRB,4.2911E-04_JPRB/)
KAO( :, 3,12, 1) = (/&
&9.8325E-07_JPRB,5.1925E-05_JPRB,9.3547E-05_JPRB,1.3044E-04_JPRB,1.6413E-04_JPRB,1.9471E-04_JPRB,&
&2.1986E-04_JPRB,2.4001E-04_JPRB,2.3209E-04_JPRB,4.4871E-04_JPRB/)
KAO( :, 4,12, 1) = (/&
&1.1889E-06_JPRB,5.6183E-05_JPRB,9.9863E-05_JPRB,1.3905E-04_JPRB,1.7391E-04_JPRB,2.0522E-04_JPRB,&
&2.3142E-04_JPRB,2.5135E-04_JPRB,2.4267E-04_JPRB,4.7818E-04_JPRB/)
KAO( :, 5,12, 1) = (/&
&1.5235E-06_JPRB,6.2281E-05_JPRB,1.0874E-04_JPRB,1.5023E-04_JPRB,1.8755E-04_JPRB,2.1980E-04_JPRB,&
&2.4617E-04_JPRB,2.6379E-04_JPRB,2.5784E-04_JPRB,5.1708E-04_JPRB/)
KAO( :, 1,13, 1) = (/&
&7.1418E-07_JPRB,3.8921E-05_JPRB,7.0891E-05_JPRB,9.9889E-05_JPRB,1.2597E-04_JPRB,1.4799E-04_JPRB,&
&1.6453E-04_JPRB,1.7513E-04_JPRB,1.6667E-04_JPRB,3.4309E-04_JPRB/)
KAO( :, 2,13, 1) = (/&
&7.2895E-07_JPRB,4.0284E-05_JPRB,7.2945E-05_JPRB,1.0221E-04_JPRB,1.2923E-04_JPRB,1.5309E-04_JPRB,&
&1.7258E-04_JPRB,1.8229E-04_JPRB,1.7386E-04_JPRB,3.5109E-04_JPRB/)
KAO( :, 3,13, 1) = (/&
&8.1079E-07_JPRB,4.2576E-05_JPRB,7.6659E-05_JPRB,1.0692E-04_JPRB,1.3449E-04_JPRB,1.5961E-04_JPRB,&
&1.8026E-04_JPRB,1.9704E-04_JPRB,1.9240E-04_JPRB,3.6700E-04_JPRB/)
KAO( :, 4,13, 1) = (/&
&9.8001E-07_JPRB,4.6149E-05_JPRB,8.1932E-05_JPRB,1.1406E-04_JPRB,1.4271E-04_JPRB,1.6841E-04_JPRB,&
&1.8992E-04_JPRB,2.0617E-04_JPRB,1.9928E-04_JPRB,3.9092E-04_JPRB/)
KAO( :, 5,13, 1) = (/&
&1.2528E-06_JPRB,5.1280E-05_JPRB,8.9359E-05_JPRB,1.2338E-04_JPRB,1.5401E-04_JPRB,1.8056E-04_JPRB,&
&2.0225E-04_JPRB,2.1672E-04_JPRB,2.1360E-04_JPRB,4.2252E-04_JPRB/)
KAO( :, 1, 1, 2) = (/&
&6.1207E-05_JPRB,1.0978E-03_JPRB,1.7611E-03_JPRB,2.3638E-03_JPRB,2.9057E-03_JPRB,3.3651E-03_JPRB,&
&3.7137E-03_JPRB,3.8383E-03_JPRB,3.2297E-03_JPRB,2.4264E-03_JPRB/)
KAO( :, 2, 1, 2) = (/&
&8.5058E-05_JPRB,1.3292E-03_JPRB,2.0750E-03_JPRB,2.7338E-03_JPRB,3.3403E-03_JPRB,3.8629E-03_JPRB,&
&4.2579E-03_JPRB,4.3337E-03_JPRB,3.4101E-03_JPRB,2.6736E-03_JPRB/)
KAO( :, 3, 1, 2) = (/&
&1.1682E-04_JPRB,1.6162E-03_JPRB,2.4689E-03_JPRB,3.1946E-03_JPRB,3.8719E-03_JPRB,4.4552E-03_JPRB,&
&4.9076E-03_JPRB,4.9335E-03_JPRB,3.9022E-03_JPRB,2.9247E-03_JPRB/)
KAO( :, 4, 1, 2) = (/&
&1.5789E-04_JPRB,1.9668E-03_JPRB,2.9480E-03_JPRB,3.7669E-03_JPRB,4.5171E-03_JPRB,5.1682E-03_JPRB,&
&5.6653E-03_JPRB,5.6499E-03_JPRB,4.0652E-03_JPRB,3.1515E-03_JPRB/)
KAO( :, 5, 1, 2) = (/&
&2.0990E-04_JPRB,2.3887E-03_JPRB,3.5299E-03_JPRB,4.4565E-03_JPRB,5.2844E-03_JPRB,6.0076E-03_JPRB,&
&6.5551E-03_JPRB,6.4764E-03_JPRB,4.4385E-03_JPRB,3.4538E-03_JPRB/)
KAO( :, 1, 2, 2) = (/&
&4.6541E-05_JPRB,8.8674E-04_JPRB,1.4099E-03_JPRB,1.8864E-03_JPRB,2.3180E-03_JPRB,2.6798E-03_JPRB,&
&2.9613E-03_JPRB,3.0615E-03_JPRB,2.6597E-03_JPRB,1.8872E-03_JPRB/)
KAO( :, 2, 2, 2) = (/&
&6.5339E-05_JPRB,1.0747E-03_JPRB,1.6670E-03_JPRB,2.1855E-03_JPRB,2.6622E-03_JPRB,3.0710E-03_JPRB,&
&3.3862E-03_JPRB,3.4584E-03_JPRB,2.7852E-03_JPRB,2.0782E-03_JPRB/)
KAO( :, 3, 2, 2) = (/&
&9.0589E-05_JPRB,1.3082E-03_JPRB,1.9947E-03_JPRB,2.5634E-03_JPRB,3.0860E-03_JPRB,3.5379E-03_JPRB,&
&3.8975E-03_JPRB,3.9366E-03_JPRB,3.1668E-03_JPRB,2.2590E-03_JPRB/)
KAO( :, 4, 2, 2) = (/&
&1.2385E-04_JPRB,1.5968E-03_JPRB,2.3941E-03_JPRB,3.0350E-03_JPRB,3.6067E-03_JPRB,4.1057E-03_JPRB,&
&4.4942E-03_JPRB,4.5107E-03_JPRB,3.2782E-03_JPRB,2.4504E-03_JPRB/)
KAO( :, 5, 2, 2) = (/&
&1.6667E-04_JPRB,1.9480E-03_JPRB,2.8786E-03_JPRB,3.6064E-03_JPRB,4.2370E-03_JPRB,4.7805E-03_JPRB,&
&5.2024E-03_JPRB,5.1677E-03_JPRB,3.5425E-03_JPRB,2.6975E-03_JPRB/)
KAO( :, 1, 3, 2) = (/&
&3.2922E-05_JPRB,6.8654E-04_JPRB,1.0970E-03_JPRB,1.4654E-03_JPRB,1.8051E-03_JPRB,2.0847E-03_JPRB,&
&2.3088E-03_JPRB,2.3837E-03_JPRB,2.1265E-03_JPRB,1.4540E-03_JPRB/)
KAO( :, 2, 3, 2) = (/&
&4.6583E-05_JPRB,8.3015E-04_JPRB,1.2948E-03_JPRB,1.6958E-03_JPRB,2.0663E-03_JPRB,2.3792E-03_JPRB,&
&2.6229E-03_JPRB,2.6951E-03_JPRB,2.2518E-03_JPRB,1.5969E-03_JPRB/)
KAO( :, 3, 3, 2) = (/&
&6.5410E-05_JPRB,1.0114E-03_JPRB,1.5518E-03_JPRB,1.9919E-03_JPRB,2.3944E-03_JPRB,2.7366E-03_JPRB,&
&3.0098E-03_JPRB,3.0595E-03_JPRB,2.4530E-03_JPRB,1.7299E-03_JPRB/)
KAO( :, 4, 3, 2) = (/&
&9.0734E-05_JPRB,1.2366E-03_JPRB,1.8688E-03_JPRB,2.3652E-03_JPRB,2.8005E-03_JPRB,3.1725E-03_JPRB,&
&3.4706E-03_JPRB,3.5000E-03_JPRB,2.6641E-03_JPRB,1.8912E-03_JPRB/)
KAO( :, 5, 3, 2) = (/&
&1.2407E-04_JPRB,1.5126E-03_JPRB,2.2510E-03_JPRB,2.8211E-03_JPRB,3.2989E-03_JPRB,3.7001E-03_JPRB,&
&4.0161E-03_JPRB,4.0075E-03_JPRB,2.7798E-03_JPRB,2.0796E-03_JPRB/)
KAO( :, 1, 4, 2) = (/&
&2.2778E-05_JPRB,5.2510E-04_JPRB,8.4888E-04_JPRB,1.1352E-03_JPRB,1.3979E-03_JPRB,1.6168E-03_JPRB,&
&1.7964E-03_JPRB,1.8331E-03_JPRB,1.7837E-03_JPRB,1.1723E-03_JPRB/)
KAO( :, 2, 4, 2) = (/&
&3.2363E-05_JPRB,6.3086E-04_JPRB,9.9709E-04_JPRB,1.3073E-03_JPRB,1.5943E-03_JPRB,1.8366E-03_JPRB,&
&2.0244E-03_JPRB,2.0875E-03_JPRB,1.8124E-03_JPRB,1.2732E-03_JPRB/)
KAO( :, 3, 4, 2) = (/&
&4.5962E-05_JPRB,7.6788E-04_JPRB,1.1912E-03_JPRB,1.5347E-03_JPRB,1.8433E-03_JPRB,2.1077E-03_JPRB,&
&2.3135E-03_JPRB,2.3586E-03_JPRB,1.8966E-03_JPRB,1.3806E-03_JPRB/)
KAO( :, 4, 4, 2) = (/&
&6.4739E-05_JPRB,9.3992E-04_JPRB,1.4352E-03_JPRB,1.8248E-03_JPRB,2.1580E-03_JPRB,2.4403E-03_JPRB,&
&2.6639E-03_JPRB,2.6893E-03_JPRB,2.1413E-03_JPRB,1.4999E-03_JPRB/)
KAO( :, 5, 4, 2) = (/&
&9.0009E-05_JPRB,1.1535E-03_JPRB,1.7330E-03_JPRB,2.1811E-03_JPRB,2.5487E-03_JPRB,2.8464E-03_JPRB,&
&3.0813E-03_JPRB,3.0811E-03_JPRB,2.2013E-03_JPRB,1.6370E-03_JPRB/)
KAO( :, 1, 5, 2) = (/&
&1.5792E-05_JPRB,4.0148E-04_JPRB,6.5831E-04_JPRB,8.8434E-04_JPRB,1.0869E-03_JPRB,1.2568E-03_JPRB,&
&1.4030E-03_JPRB,1.4157E-03_JPRB,1.3790E-03_JPRB,9.9471E-04_JPRB/)
KAO( :, 2, 5, 2) = (/&
&2.2397E-05_JPRB,4.7887E-04_JPRB,7.6705E-04_JPRB,1.0113E-03_JPRB,1.2329E-03_JPRB,1.4202E-03_JPRB,&
&1.5687E-03_JPRB,1.6184E-03_JPRB,1.4582E-03_JPRB,1.0698E-03_JPRB/)
KAO( :, 3, 5, 2) = (/&
&3.2096E-05_JPRB,5.8078E-04_JPRB,9.1183E-04_JPRB,1.1823E-03_JPRB,1.4221E-03_JPRB,1.6260E-03_JPRB,&
&1.7823E-03_JPRB,1.8208E-03_JPRB,1.5493E-03_JPRB,1.1486E-03_JPRB/)
KAO( :, 4, 5, 2) = (/&
&4.5840E-05_JPRB,7.1160E-04_JPRB,1.0969E-03_JPRB,1.4034E-03_JPRB,1.6628E-03_JPRB,1.8804E-03_JPRB,&
&2.0470E-03_JPRB,2.0686E-03_JPRB,1.6540E-03_JPRB,1.2365E-03_JPRB/)
KAO( :, 5, 5, 2) = (/&
&6.4822E-05_JPRB,8.7496E-04_JPRB,1.3269E-03_JPRB,1.6793E-03_JPRB,1.9658E-03_JPRB,2.1946E-03_JPRB,&
&2.3671E-03_JPRB,2.3677E-03_JPRB,1.7812E-03_JPRB,1.3376E-03_JPRB/)
KAO( :, 1, 6, 2) = (/&
&1.0902E-05_JPRB,3.0605E-04_JPRB,5.1028E-04_JPRB,6.8853E-04_JPRB,8.4488E-04_JPRB,9.7840E-04_JPRB,&
&1.0974E-03_JPRB,1.1101E-03_JPRB,1.0645E-03_JPRB,8.6648E-04_JPRB/)
KAO( :, 2, 6, 2) = (/&
&1.5301E-05_JPRB,3.6130E-04_JPRB,5.8719E-04_JPRB,7.8079E-04_JPRB,9.5252E-04_JPRB,1.0959E-03_JPRB,&
&1.2152E-03_JPRB,1.2397E-03_JPRB,1.2046E-03_JPRB,9.1885E-04_JPRB/)
KAO( :, 3, 6, 2) = (/&
&2.2016E-05_JPRB,4.3548E-04_JPRB,6.9267E-04_JPRB,9.0511E-04_JPRB,1.0924E-03_JPRB,1.2498E-03_JPRB,&
&1.3720E-03_JPRB,1.4053E-03_JPRB,1.2319E-03_JPRB,9.7396E-04_JPRB/)
KAO( :, 4, 6, 2) = (/&
&3.1830E-05_JPRB,5.3317E-04_JPRB,8.3063E-04_JPRB,1.0698E-03_JPRB,1.2734E-03_JPRB,1.4418E-03_JPRB,&
&1.5687E-03_JPRB,1.5881E-03_JPRB,1.2775E-03_JPRB,1.0399E-03_JPRB/)
KAO( :, 5, 6, 2) = (/&
&4.5738E-05_JPRB,6.5696E-04_JPRB,1.0039E-03_JPRB,1.2790E-03_JPRB,1.5021E-03_JPRB,1.6812E-03_JPRB,&
&1.8119E-03_JPRB,1.8117E-03_JPRB,1.4274E-03_JPRB,1.1156E-03_JPRB/)
KAO( :, 1, 7, 2) = (/&
&7.6369E-06_JPRB,2.3409E-04_JPRB,3.9662E-04_JPRB,5.3736E-04_JPRB,6.5954E-04_JPRB,7.6628E-04_JPRB,&
&8.6324E-04_JPRB,8.8119E-04_JPRB,8.6194E-04_JPRB,7.9079E-04_JPRB/)
KAO( :, 2, 7, 2) = (/&
&1.0494E-05_JPRB,2.7293E-04_JPRB,4.5033E-04_JPRB,6.0419E-04_JPRB,7.3771E-04_JPRB,8.4846E-04_JPRB,&
&9.4512E-04_JPRB,9.5497E-04_JPRB,9.2999E-04_JPRB,8.2387E-04_JPRB/)
KAO( :, 3, 7, 2) = (/&
&1.5059E-05_JPRB,3.2612E-04_JPRB,5.2570E-04_JPRB,6.9285E-04_JPRB,8.4056E-04_JPRB,9.6214E-04_JPRB,&
&1.0579E-03_JPRB,1.0868E-03_JPRB,9.8600E-04_JPRB,8.6421E-04_JPRB/)
KAO( :, 4, 7, 2) = (/&
&2.1973E-05_JPRB,3.9766E-04_JPRB,6.2716E-04_JPRB,8.1307E-04_JPRB,9.7314E-04_JPRB,1.1062E-03_JPRB,&
&1.2052E-03_JPRB,1.2224E-03_JPRB,1.0473E-03_JPRB,9.1386E-04_JPRB/)
KAO( :, 5, 7, 2) = (/&
&3.2024E-05_JPRB,4.9023E-04_JPRB,7.5693E-04_JPRB,9.6942E-04_JPRB,1.1441E-03_JPRB,1.2861E-03_JPRB,&
&1.3873E-03_JPRB,1.3904E-03_JPRB,1.0995E-03_JPRB,9.7409E-04_JPRB/)
KAO( :, 1, 8, 2) = (/&
&5.4819E-06_JPRB,1.8022E-04_JPRB,3.0951E-04_JPRB,4.2109E-04_JPRB,5.1765E-04_JPRB,6.0434E-04_JPRB,&
&6.7966E-04_JPRB,7.0414E-04_JPRB,7.0729E-04_JPRB,7.6543E-04_JPRB/)
KAO( :, 2, 8, 2) = (/&
&7.2946E-06_JPRB,2.0689E-04_JPRB,3.4673E-04_JPRB,4.6841E-04_JPRB,5.7263E-04_JPRB,6.6046E-04_JPRB,&
&7.3949E-04_JPRB,7.4887E-04_JPRB,7.2137E-04_JPRB,7.8512E-04_JPRB/)
KAO( :, 3, 8, 2) = (/&
&1.0351E-05_JPRB,2.4457E-04_JPRB,3.9988E-04_JPRB,5.3188E-04_JPRB,6.4791E-04_JPRB,7.4247E-04_JPRB,&
&8.1941E-04_JPRB,8.3495E-04_JPRB,8.1545E-04_JPRB,8.2107E-04_JPRB/)
KAO( :, 4, 8, 2) = (/&
&1.5156E-05_JPRB,2.9629E-04_JPRB,4.7365E-04_JPRB,6.1873E-04_JPRB,7.4454E-04_JPRB,8.4958E-04_JPRB,&
&9.2854E-04_JPRB,9.4393E-04_JPRB,8.3940E-04_JPRB,8.7281E-04_JPRB/)
KAO( :, 5, 8, 2) = (/&
&2.2361E-05_JPRB,3.6482E-04_JPRB,5.6983E-04_JPRB,7.3407E-04_JPRB,8.7045E-04_JPRB,9.8366E-04_JPRB,&
&1.0651E-03_JPRB,1.0698E-03_JPRB,8.6698E-04_JPRB,9.3613E-04_JPRB/)
KAO( :, 1, 9, 2) = (/&
&4.0452E-06_JPRB,1.4017E-04_JPRB,2.4329E-04_JPRB,3.3218E-04_JPRB,4.0925E-04_JPRB,4.8103E-04_JPRB,&
&5.3918E-04_JPRB,5.6100E-04_JPRB,5.6501E-04_JPRB,8.0970E-04_JPRB/)
KAO( :, 2, 9, 2) = (/&
&5.1567E-06_JPRB,1.5795E-04_JPRB,2.6863E-04_JPRB,3.6500E-04_JPRB,4.4688E-04_JPRB,5.1756E-04_JPRB,&
&5.8306E-04_JPRB,5.9423E-04_JPRB,5.8894E-04_JPRB,8.6646E-04_JPRB/)
KAO( :, 3, 9, 2) = (/&
&7.1657E-06_JPRB,1.8427E-04_JPRB,3.0563E-04_JPRB,4.1026E-04_JPRB,5.0076E-04_JPRB,5.7510E-04_JPRB,&
&6.3796E-04_JPRB,6.4416E-04_JPRB,6.2814E-04_JPRB,9.4589E-04_JPRB/)
KAO( :, 4, 9, 2) = (/&
&1.0454E-05_JPRB,2.2117E-04_JPRB,3.5855E-04_JPRB,4.7222E-04_JPRB,5.7137E-04_JPRB,6.5350E-04_JPRB,&
&7.1676E-04_JPRB,7.3182E-04_JPRB,6.7180E-04_JPRB,1.0445E-03_JPRB/)
KAO( :, 5, 9, 2) = (/&
&1.5554E-05_JPRB,2.7129E-04_JPRB,4.2902E-04_JPRB,5.5622E-04_JPRB,6.6296E-04_JPRB,7.5220E-04_JPRB,&
&8.1926E-04_JPRB,8.2534E-04_JPRB,7.1317E-04_JPRB,1.1567E-03_JPRB/)
KAO( :, 1,10, 2) = (/&
&3.1057E-06_JPRB,1.1083E-04_JPRB,1.9379E-04_JPRB,2.6511E-04_JPRB,3.2793E-04_JPRB,3.8622E-04_JPRB,&
&4.3071E-04_JPRB,4.4441E-04_JPRB,4.5952E-04_JPRB,8.8174E-04_JPRB/)
KAO( :, 2,10, 2) = (/&
&3.7991E-06_JPRB,1.2283E-04_JPRB,2.1113E-04_JPRB,2.8821E-04_JPRB,3.5348E-04_JPRB,4.1112E-04_JPRB,&
&4.6174E-04_JPRB,4.7717E-04_JPRB,4.8657E-04_JPRB,9.8685E-04_JPRB/)
KAO( :, 3,10, 2) = (/&
&5.1499E-06_JPRB,1.4143E-04_JPRB,2.3734E-04_JPRB,3.2100E-04_JPRB,3.9236E-04_JPRB,4.5145E-04_JPRB,&
&5.0315E-04_JPRB,5.0792E-04_JPRB,4.9406E-04_JPRB,1.1242E-03_JPRB/)
KAO( :, 4,10, 2) = (/&
&7.4528E-06_JPRB,1.6827E-04_JPRB,2.7574E-04_JPRB,3.6613E-04_JPRB,4.4442E-04_JPRB,5.0912E-04_JPRB,&
&5.6026E-04_JPRB,5.7140E-04_JPRB,5.5681E-04_JPRB,1.2935E-03_JPRB/)
KAO( :, 5,10, 2) = (/&
&1.1134E-05_JPRB,2.0532E-04_JPRB,3.2832E-04_JPRB,4.2825E-04_JPRB,5.1275E-04_JPRB,5.8331E-04_JPRB,&
&6.3709E-04_JPRB,6.4447E-04_JPRB,5.7554E-04_JPRB,1.4892E-03_JPRB/)
KAO( :, 1,11, 2) = (/&
&2.5793E-06_JPRB,9.1386E-05_JPRB,1.5991E-04_JPRB,2.1914E-04_JPRB,2.7076E-04_JPRB,3.1821E-04_JPRB,&
&3.5500E-04_JPRB,3.6871E-04_JPRB,3.7899E-04_JPRB,8.3339E-04_JPRB/)
KAO( :, 2,11, 2) = (/&
&3.1932E-06_JPRB,1.0152E-04_JPRB,1.7439E-04_JPRB,2.3840E-04_JPRB,2.9253E-04_JPRB,3.3975E-04_JPRB,&
&3.8122E-04_JPRB,3.9384E-04_JPRB,4.0567E-04_JPRB,9.5074E-04_JPRB/)
KAO( :, 3,11, 2) = (/&
&4.3709E-06_JPRB,1.1728E-04_JPRB,1.9656E-04_JPRB,2.6595E-04_JPRB,3.2495E-04_JPRB,3.7366E-04_JPRB,&
&4.1570E-04_JPRB,4.1965E-04_JPRB,4.1122E-04_JPRB,1.0992E-03_JPRB/)
KAO( :, 4,11, 2) = (/&
&6.3954E-06_JPRB,1.4000E-04_JPRB,2.2922E-04_JPRB,3.0419E-04_JPRB,3.6879E-04_JPRB,4.2168E-04_JPRB,&
&4.6345E-04_JPRB,4.7319E-04_JPRB,4.5954E-04_JPRB,1.2804E-03_JPRB/)
KAO( :, 5,11, 2) = (/&
&9.6174E-06_JPRB,1.7120E-04_JPRB,2.7357E-04_JPRB,3.5711E-04_JPRB,4.2654E-04_JPRB,4.8415E-04_JPRB,&
&5.2775E-04_JPRB,5.3321E-04_JPRB,4.7537E-04_JPRB,1.4946E-03_JPRB/)
KAO( :, 1,12, 2) = (/&
&2.1449E-06_JPRB,7.5185E-05_JPRB,1.3159E-04_JPRB,1.8068E-04_JPRB,2.2335E-04_JPRB,2.6198E-04_JPRB,&
&2.9235E-04_JPRB,3.0350E-04_JPRB,3.1256E-04_JPRB,7.2986E-04_JPRB/)
KAO( :, 2,12, 2) = (/&
&2.6849E-06_JPRB,8.3739E-05_JPRB,1.4370E-04_JPRB,1.9666E-04_JPRB,2.4153E-04_JPRB,2.8046E-04_JPRB,&
&3.1445E-04_JPRB,3.2440E-04_JPRB,3.3814E-04_JPRB,8.3896E-04_JPRB/)
KAO( :, 3,12, 2) = (/&
&3.7120E-06_JPRB,9.7072E-05_JPRB,1.6242E-04_JPRB,2.1974E-04_JPRB,2.6866E-04_JPRB,3.0880E-04_JPRB,&
&3.4296E-04_JPRB,3.4655E-04_JPRB,3.4183E-04_JPRB,9.7914E-04_JPRB/)
KAO( :, 4,12, 2) = (/&
&5.4750E-06_JPRB,1.1621E-04_JPRB,1.9012E-04_JPRB,2.5210E-04_JPRB,3.0547E-04_JPRB,3.4901E-04_JPRB,&
&3.8299E-04_JPRB,3.9098E-04_JPRB,3.8045E-04_JPRB,1.1499E-03_JPRB/)
KAO( :, 5,12, 2) = (/&
&8.2703E-06_JPRB,1.4241E-04_JPRB,2.2731E-04_JPRB,2.9701E-04_JPRB,3.5442E-04_JPRB,4.0147E-04_JPRB,&
&4.3679E-04_JPRB,4.4039E-04_JPRB,3.9154E-04_JPRB,1.3496E-03_JPRB/)
KAO( :, 1,13, 2) = (/&
&1.7830E-06_JPRB,6.1545E-05_JPRB,1.0776E-04_JPRB,1.4816E-04_JPRB,1.8346E-04_JPRB,2.1518E-04_JPRB,&
&2.4003E-04_JPRB,2.4920E-04_JPRB,2.5855E-04_JPRB,6.0483E-04_JPRB/)
KAO( :, 2,13, 2) = (/&
&2.2523E-06_JPRB,6.8708E-05_JPRB,1.1787E-04_JPRB,1.6139E-04_JPRB,1.9846E-04_JPRB,2.3065E-04_JPRB,&
&2.5831E-04_JPRB,2.6663E-04_JPRB,2.8115E-04_JPRB,6.9533E-04_JPRB/)
KAO( :, 3,13, 2) = (/&
&3.1394E-06_JPRB,7.9894E-05_JPRB,1.3357E-04_JPRB,1.8071E-04_JPRB,2.2106E-04_JPRB,2.5423E-04_JPRB,&
&2.8211E-04_JPRB,2.8541E-04_JPRB,2.8437E-04_JPRB,8.1181E-04_JPRB/)
KAO( :, 4,13, 2) = (/&
&4.6431E-06_JPRB,9.5872E-05_JPRB,1.5677E-04_JPRB,2.0791E-04_JPRB,2.5190E-04_JPRB,2.8785E-04_JPRB,&
&3.1567E-04_JPRB,3.2214E-04_JPRB,3.1077E-04_JPRB,9.5374E-04_JPRB/)
KAO( :, 5,13, 2) = (/&
&7.0293E-06_JPRB,1.1782E-04_JPRB,1.8782E-04_JPRB,2.4556E-04_JPRB,2.9310E-04_JPRB,3.3172E-04_JPRB,&
&3.6069E-04_JPRB,3.6276E-04_JPRB,3.2321E-04_JPRB,1.1190E-03_JPRB/)
KAO( :, 1, 1, 3) = (/&
&3.1395E-04_JPRB,2.3358E-03_JPRB,3.6695E-03_JPRB,4.7583E-03_JPRB,5.6300E-03_JPRB,6.3084E-03_JPRB,&
&6.4459E-03_JPRB,5.6476E-03_JPRB,4.3114E-03_JPRB,3.5359E-03_JPRB/)
KAO( :, 2, 1, 3) = (/&
&4.4041E-04_JPRB,2.8550E-03_JPRB,4.4288E-03_JPRB,5.7337E-03_JPRB,6.7703E-03_JPRB,7.4874E-03_JPRB,&
&7.5852E-03_JPRB,6.6048E-03_JPRB,4.4609E-03_JPRB,3.7307E-03_JPRB/)
KAO( :, 3, 1, 3) = (/&
&6.0889E-04_JPRB,3.4990E-03_JPRB,5.3318E-03_JPRB,6.8783E-03_JPRB,8.0899E-03_JPRB,8.8562E-03_JPRB,&
&8.8659E-03_JPRB,7.6998E-03_JPRB,5.0834E-03_JPRB,4.1606E-03_JPRB/)
KAO( :, 4, 1, 3) = (/&
&8.2945E-04_JPRB,4.2967E-03_JPRB,6.4106E-03_JPRB,8.2013E-03_JPRB,9.6038E-03_JPRB,1.0382E-02_JPRB,&
&1.0298E-02_JPRB,8.9419E-03_JPRB,6.1506E-03_JPRB,4.8030E-03_JPRB/)
KAO( :, 5, 1, 3) = (/&
&1.1111E-03_JPRB,5.2640E-03_JPRB,7.6785E-03_JPRB,9.7243E-03_JPRB,1.1313E-02_JPRB,1.2073E-02_JPRB,&
&1.1918E-02_JPRB,1.0340E-02_JPRB,7.2231E-03_JPRB,5.5559E-03_JPRB/)
KAO( :, 1, 2, 3) = (/&
&2.5786E-04_JPRB,1.8689E-03_JPRB,2.9171E-03_JPRB,3.7655E-03_JPRB,4.4557E-03_JPRB,4.9851E-03_JPRB,&
&5.0877E-03_JPRB,4.4987E-03_JPRB,3.5624E-03_JPRB,2.7823E-03_JPRB/)
KAO( :, 2, 2, 3) = (/&
&3.6518E-04_JPRB,2.2982E-03_JPRB,3.5229E-03_JPRB,4.5348E-03_JPRB,5.3627E-03_JPRB,5.9413E-03_JPRB,&
&6.0131E-03_JPRB,5.2796E-03_JPRB,3.6528E-03_JPRB,2.9862E-03_JPRB/)
KAO( :, 3, 2, 3) = (/&
&5.0963E-04_JPRB,2.8326E-03_JPRB,4.2490E-03_JPRB,5.4478E-03_JPRB,6.4291E-03_JPRB,7.0522E-03_JPRB,&
&7.0637E-03_JPRB,6.1794E-03_JPRB,4.0832E-03_JPRB,3.3326E-03_JPRB/)
KAO( :, 4, 2, 3) = (/&
&7.0041E-04_JPRB,3.4946E-03_JPRB,5.1315E-03_JPRB,6.5181E-03_JPRB,7.6574E-03_JPRB,8.3039E-03_JPRB,&
&8.2501E-03_JPRB,7.2013E-03_JPRB,4.9579E-03_JPRB,3.8182E-03_JPRB/)
KAO( :, 5, 2, 3) = (/&
&9.4509E-04_JPRB,4.3042E-03_JPRB,6.1780E-03_JPRB,7.7645E-03_JPRB,9.0552E-03_JPRB,9.6970E-03_JPRB,&
&9.5937E-03_JPRB,8.3644E-03_JPRB,5.8475E-03_JPRB,4.3744E-03_JPRB/)
KAO( :, 1, 3, 3) = (/&
&1.9379E-04_JPRB,1.4316E-03_JPRB,2.2324E-03_JPRB,2.8735E-03_JPRB,3.3970E-03_JPRB,3.8041E-03_JPRB,&
&3.8802E-03_JPRB,3.4669E-03_JPRB,2.9119E-03_JPRB,2.1744E-03_JPRB/)
KAO( :, 2, 3, 3) = (/&
&2.7770E-04_JPRB,1.7674E-03_JPRB,2.7001E-03_JPRB,3.4577E-03_JPRB,4.0882E-03_JPRB,4.5451E-03_JPRB,&
&4.6130E-03_JPRB,4.0692E-03_JPRB,2.9379E-03_JPRB,2.3588E-03_JPRB/)
KAO( :, 3, 3, 3) = (/&
&3.9251E-04_JPRB,2.1938E-03_JPRB,3.2645E-03_JPRB,4.1604E-03_JPRB,4.9099E-03_JPRB,5.4125E-03_JPRB,&
&5.4492E-03_JPRB,4.7846E-03_JPRB,3.2003E-03_JPRB,2.6346E-03_JPRB/)
KAO( :, 4, 3, 3) = (/&
&5.4605E-04_JPRB,2.7278E-03_JPRB,3.9609E-03_JPRB,4.9977E-03_JPRB,5.8740E-03_JPRB,6.4067E-03_JPRB,&
&6.4003E-03_JPRB,5.6054E-03_JPRB,3.7732E-03_JPRB,2.9860E-03_JPRB/)
KAO( :, 5, 3, 3) = (/&
&7.4466E-04_JPRB,3.3848E-03_JPRB,4.8045E-03_JPRB,5.9823E-03_JPRB,6.9787E-03_JPRB,7.5209E-03_JPRB,&
&7.4708E-03_JPRB,6.5433E-03_JPRB,4.5620E-03_JPRB,3.3966E-03_JPRB/)
KAO( :, 1, 4, 3) = (/&
&1.4015E-04_JPRB,1.0813E-03_JPRB,1.6854E-03_JPRB,2.1729E-03_JPRB,2.5709E-03_JPRB,2.8772E-03_JPRB,&
&2.9317E-03_JPRB,2.6451E-03_JPRB,2.2657E-03_JPRB,1.7383E-03_JPRB/)
KAO( :, 2, 4, 3) = (/&
&2.0311E-04_JPRB,1.3407E-03_JPRB,2.0417E-03_JPRB,2.6162E-03_JPRB,3.0900E-03_JPRB,3.4371E-03_JPRB,&
&3.4970E-03_JPRB,3.1030E-03_JPRB,2.4331E-03_JPRB,1.8807E-03_JPRB/)
KAO( :, 3, 4, 3) = (/&
&2.9086E-04_JPRB,1.6740E-03_JPRB,2.4810E-03_JPRB,3.1478E-03_JPRB,3.7091E-03_JPRB,4.1012E-03_JPRB,&
&4.1503E-03_JPRB,3.6669E-03_JPRB,2.5193E-03_JPRB,2.0853E-03_JPRB/)
KAO( :, 4, 4, 3) = (/&
&4.1019E-04_JPRB,2.0975E-03_JPRB,3.0276E-03_JPRB,3.7932E-03_JPRB,4.4503E-03_JPRB,4.8736E-03_JPRB,&
&4.8948E-03_JPRB,4.3129E-03_JPRB,2.8422E-03_JPRB,2.3481E-03_JPRB/)
KAO( :, 5, 4, 3) = (/&
&5.6658E-04_JPRB,2.6213E-03_JPRB,3.6972E-03_JPRB,4.5663E-03_JPRB,5.3124E-03_JPRB,5.7564E-03_JPRB,&
&5.7449E-03_JPRB,5.0602E-03_JPRB,3.4831E-03_JPRB,2.6607E-03_JPRB/)
KAO( :, 1, 5, 3) = (/&
&1.0005E-04_JPRB,8.1751E-04_JPRB,1.2728E-03_JPRB,1.6409E-03_JPRB,1.9492E-03_JPRB,2.1828E-03_JPRB,&
&2.2210E-03_JPRB,2.0236E-03_JPRB,1.7728E-03_JPRB,1.4477E-03_JPRB/)
KAO( :, 2, 5, 3) = (/&
&1.4628E-04_JPRB,1.0154E-03_JPRB,1.5439E-03_JPRB,1.9778E-03_JPRB,2.3404E-03_JPRB,2.6065E-03_JPRB,&
&2.6499E-03_JPRB,2.3648E-03_JPRB,1.9853E-03_JPRB,1.5598E-03_JPRB/)
KAO( :, 3, 5, 3) = (/&
&2.1213E-04_JPRB,1.2737E-03_JPRB,1.8830E-03_JPRB,2.3878E-03_JPRB,2.8089E-03_JPRB,3.1116E-03_JPRB,&
&3.1584E-03_JPRB,2.8055E-03_JPRB,1.9979E-03_JPRB,1.7165E-03_JPRB/)
KAO( :, 4, 5, 3) = (/&
&3.0316E-04_JPRB,1.6037E-03_JPRB,2.3102E-03_JPRB,2.8890E-03_JPRB,3.3732E-03_JPRB,3.7052E-03_JPRB,&
&3.7386E-03_JPRB,3.3128E-03_JPRB,2.1889E-03_JPRB,1.9135E-03_JPRB/)
KAO( :, 5, 5, 3) = (/&
&4.2437E-04_JPRB,2.0170E-03_JPRB,2.8415E-03_JPRB,3.4970E-03_JPRB,4.0448E-03_JPRB,4.3946E-03_JPRB,&
&4.4054E-03_JPRB,3.8956E-03_JPRB,2.6089E-03_JPRB,2.1456E-03_JPRB/)
KAO( :, 1, 6, 3) = (/&
&6.9848E-05_JPRB,6.1344E-04_JPRB,9.5427E-04_JPRB,1.2333E-03_JPRB,1.4696E-03_JPRB,1.6459E-03_JPRB,&
&1.6778E-03_JPRB,1.5491E-03_JPRB,1.4340E-03_JPRB,1.2155E-03_JPRB/)
KAO( :, 2, 6, 3) = (/&
&1.0287E-04_JPRB,7.6231E-04_JPRB,1.1596E-03_JPRB,1.4875E-03_JPRB,1.7602E-03_JPRB,1.9644E-03_JPRB,&
&1.9987E-03_JPRB,1.8015E-03_JPRB,1.5475E-03_JPRB,1.3106E-03_JPRB/)
KAO( :, 3, 6, 3) = (/&
&1.5064E-04_JPRB,9.5897E-04_JPRB,1.4184E-03_JPRB,1.7997E-03_JPRB,2.1174E-03_JPRB,2.3481E-03_JPRB,&
&2.3855E-03_JPRB,2.1239E-03_JPRB,1.6664E-03_JPRB,1.4397E-03_JPRB/)
KAO( :, 4, 6, 3) = (/&
&2.1812E-04_JPRB,1.2102E-03_JPRB,1.7485E-03_JPRB,2.1875E-03_JPRB,2.5486E-03_JPRB,2.8028E-03_JPRB,&
&2.8356E-03_JPRB,2.5206E-03_JPRB,1.7195E-03_JPRB,1.5934E-03_JPRB/)
KAO( :, 5, 6, 3) = (/&
&3.0969E-04_JPRB,1.5273E-03_JPRB,2.1634E-03_JPRB,2.6620E-03_JPRB,3.0695E-03_JPRB,3.3380E-03_JPRB,&
&3.3515E-03_JPRB,2.9746E-03_JPRB,1.9515E-03_JPRB,1.7778E-03_JPRB/)
KAO( :, 1, 7, 3) = (/&
&4.8221E-05_JPRB,4.6010E-04_JPRB,7.1481E-04_JPRB,9.2859E-04_JPRB,1.1100E-03_JPRB,1.2408E-03_JPRB,&
&1.2683E-03_JPRB,1.1941E-03_JPRB,1.1654E-03_JPRB,1.0618E-03_JPRB/)
KAO( :, 2, 7, 3) = (/&
&7.1316E-05_JPRB,5.6993E-04_JPRB,8.6994E-04_JPRB,1.1165E-03_JPRB,1.3220E-03_JPRB,1.4781E-03_JPRB,&
&1.5050E-03_JPRB,1.3757E-03_JPRB,1.2140E-03_JPRB,1.1427E-03_JPRB/)
KAO( :, 3, 7, 3) = (/&
&1.0540E-04_JPRB,7.1740E-04_JPRB,1.0671E-03_JPRB,1.3546E-03_JPRB,1.5921E-03_JPRB,1.7675E-03_JPRB,&
&1.7993E-03_JPRB,1.6085E-03_JPRB,1.3409E-03_JPRB,1.2460E-03_JPRB/)
KAO( :, 4, 7, 3) = (/&
&1.5421E-04_JPRB,9.0675E-04_JPRB,1.3194E-03_JPRB,1.6531E-03_JPRB,1.9239E-03_JPRB,2.1163E-03_JPRB,&
&2.1446E-03_JPRB,1.9118E-03_JPRB,1.3549E-03_JPRB,1.3702E-03_JPRB/)
KAO( :, 5, 7, 3) = (/&
&2.2207E-04_JPRB,1.1485E-03_JPRB,1.6379E-03_JPRB,2.0236E-03_JPRB,2.3292E-03_JPRB,2.5319E-03_JPRB,&
&2.5452E-03_JPRB,2.2618E-03_JPRB,1.4884E-03_JPRB,1.5202E-03_JPRB/)
KAO( :, 1, 8, 3) = (/&
&3.3024E-05_JPRB,3.4530E-04_JPRB,5.3688E-04_JPRB,7.0115E-04_JPRB,8.4229E-04_JPRB,9.3889E-04_JPRB,&
&9.6725E-04_JPRB,9.1694E-04_JPRB,9.1670E-04_JPRB,1.0135E-03_JPRB/)
KAO( :, 2, 8, 3) = (/&
&4.8867E-05_JPRB,4.2560E-04_JPRB,6.5145E-04_JPRB,8.3778E-04_JPRB,9.9544E-04_JPRB,1.1134E-03_JPRB,&
&1.1345E-03_JPRB,1.0538E-03_JPRB,9.7113E-04_JPRB,1.0857E-03_JPRB/)
KAO( :, 3, 8, 3) = (/&
&7.2825E-05_JPRB,5.3471E-04_JPRB,8.0022E-04_JPRB,1.0181E-03_JPRB,1.1967E-03_JPRB,1.3302E-03_JPRB,&
&1.3547E-03_JPRB,1.2266E-03_JPRB,1.0446E-03_JPRB,1.1774E-03_JPRB/)
KAO( :, 4, 8, 3) = (/&
&1.0774E-04_JPRB,6.7652E-04_JPRB,9.9081E-04_JPRB,1.2458E-03_JPRB,1.4508E-03_JPRB,1.5976E-03_JPRB,&
&1.6199E-03_JPRB,1.4510E-03_JPRB,1.1389E-03_JPRB,1.2913E-03_JPRB/)
KAO( :, 5, 8, 3) = (/&
&1.5712E-04_JPRB,8.5893E-04_JPRB,1.2330E-03_JPRB,1.5318E-03_JPRB,1.7648E-03_JPRB,1.9188E-03_JPRB,&
&1.9298E-03_JPRB,1.7197E-03_JPRB,1.1585E-03_JPRB,1.4301E-03_JPRB/)
KAO( :, 1, 9, 3) = (/&
&2.2694E-05_JPRB,2.5964E-04_JPRB,4.0587E-04_JPRB,5.3244E-04_JPRB,6.4307E-04_JPRB,7.1486E-04_JPRB,&
&7.4240E-04_JPRB,7.1164E-04_JPRB,7.2273E-04_JPRB,1.2493E-03_JPRB/)
KAO( :, 2, 9, 3) = (/&
&3.3403E-05_JPRB,3.1851E-04_JPRB,4.8826E-04_JPRB,6.2982E-04_JPRB,7.5282E-04_JPRB,8.4067E-04_JPRB,&
&8.5777E-04_JPRB,8.1055E-04_JPRB,7.8048E-04_JPRB,1.3812E-03_JPRB/)
KAO( :, 3, 9, 3) = (/&
&5.0028E-05_JPRB,3.9826E-04_JPRB,5.9931E-04_JPRB,7.6424E-04_JPRB,9.0031E-04_JPRB,1.0018E-03_JPRB,&
&1.0201E-03_JPRB,9.3771E-04_JPRB,8.2897E-04_JPRB,1.5248E-03_JPRB/)
KAO( :, 4, 9, 3) = (/&
&7.4767E-05_JPRB,5.0392E-04_JPRB,7.4141E-04_JPRB,9.3676E-04_JPRB,1.0930E-03_JPRB,1.2050E-03_JPRB,&
&1.2228E-03_JPRB,1.0983E-03_JPRB,9.0134E-04_JPRB,1.6871E-03_JPRB/)
KAO( :, 5, 9, 3) = (/&
&1.1035E-04_JPRB,6.4097E-04_JPRB,9.2434E-04_JPRB,1.1532E-03_JPRB,1.3334E-03_JPRB,1.4526E-03_JPRB,&
&1.4614E-03_JPRB,1.3054E-03_JPRB,9.1810E-04_JPRB,1.8727E-03_JPRB/)
KAO( :, 1,10, 3) = (/&
&1.6131E-05_JPRB,1.9889E-04_JPRB,3.1275E-04_JPRB,4.1228E-04_JPRB,4.9839E-04_JPRB,5.5623E-04_JPRB,&
&5.8253E-04_JPRB,5.6343E-04_JPRB,5.6050E-04_JPRB,1.5889E-03_JPRB/)
KAO( :, 2,10, 3) = (/&
&2.3548E-05_JPRB,2.4279E-04_JPRB,3.7289E-04_JPRB,4.8222E-04_JPRB,5.7912E-04_JPRB,6.4486E-04_JPRB,&
&6.6265E-04_JPRB,6.3391E-04_JPRB,6.2287E-04_JPRB,1.8970E-03_JPRB/)
KAO( :, 3,10, 3) = (/&
&3.5345E-05_JPRB,3.0213E-04_JPRB,4.5662E-04_JPRB,5.8302E-04_JPRB,6.8872E-04_JPRB,7.6652E-04_JPRB,&
&7.8037E-04_JPRB,7.2531E-04_JPRB,6.6020E-04_JPRB,2.2611E-03_JPRB/)
KAO( :, 4,10, 3) = (/&
&5.3207E-05_JPRB,3.8181E-04_JPRB,5.6403E-04_JPRB,7.1428E-04_JPRB,8.3596E-04_JPRB,9.2165E-04_JPRB,&
&9.3562E-04_JPRB,8.4502E-04_JPRB,7.1249E-04_JPRB,2.6676E-03_JPRB/)
KAO( :, 5,10, 3) = (/&
&7.9349E-05_JPRB,4.8668E-04_JPRB,7.0365E-04_JPRB,8.7954E-04_JPRB,1.0204E-03_JPRB,1.1145E-03_JPRB,&
&1.1232E-03_JPRB,1.0045E-03_JPRB,7.7476E-04_JPRB,3.1110E-03_JPRB/)
KAO( :, 1,11, 3) = (/&
&1.3601E-05_JPRB,1.6644E-04_JPRB,2.6059E-04_JPRB,3.4190E-04_JPRB,4.1323E-04_JPRB,4.6098E-04_JPRB,&
&4.8236E-04_JPRB,4.6602E-04_JPRB,4.6408E-04_JPRB,1.7060E-03_JPRB/)
KAO( :, 2,11, 3) = (/&
&2.0015E-05_JPRB,2.0390E-04_JPRB,3.1274E-04_JPRB,4.0248E-04_JPRB,4.8157E-04_JPRB,5.3553E-04_JPRB,&
&5.5000E-04_JPRB,5.2592E-04_JPRB,5.1327E-04_JPRB,2.0930E-03_JPRB/)
KAO( :, 3,11, 3) = (/&
&3.0229E-05_JPRB,2.5493E-04_JPRB,3.8325E-04_JPRB,4.8838E-04_JPRB,5.7590E-04_JPRB,6.3868E-04_JPRB,&
&6.4952E-04_JPRB,6.0329E-04_JPRB,5.4354E-04_JPRB,2.5341E-03_JPRB/)
KAO( :, 4,11, 3) = (/&
&4.5728E-05_JPRB,3.2357E-04_JPRB,4.7513E-04_JPRB,5.9900E-04_JPRB,7.0032E-04_JPRB,7.7052E-04_JPRB,&
&7.8160E-04_JPRB,7.0364E-04_JPRB,5.8867E-04_JPRB,3.0110E-03_JPRB/)
KAO( :, 5,11, 3) = (/&
&6.8471E-05_JPRB,4.1453E-04_JPRB,5.9518E-04_JPRB,7.3943E-04_JPRB,8.5586E-04_JPRB,9.3243E-04_JPRB,&
&9.3985E-04_JPRB,8.3888E-04_JPRB,6.4004E-04_JPRB,3.5144E-03_JPRB/)
KAO( :, 1,12, 3) = (/&
&1.1390E-05_JPRB,1.3855E-04_JPRB,2.1705E-04_JPRB,2.8356E-04_JPRB,3.4198E-04_JPRB,3.8125E-04_JPRB,&
&3.9897E-04_JPRB,3.8701E-04_JPRB,3.8428E-04_JPRB,1.6202E-03_JPRB/)
KAO( :, 2,12, 3) = (/&
&1.6895E-05_JPRB,1.7033E-04_JPRB,2.6132E-04_JPRB,3.3574E-04_JPRB,4.0033E-04_JPRB,4.4440E-04_JPRB,&
&4.5547E-04_JPRB,4.3453E-04_JPRB,4.1795E-04_JPRB,2.0056E-03_JPRB/)
KAO( :, 3,12, 3) = (/&
&2.5697E-05_JPRB,2.1399E-04_JPRB,3.2079E-04_JPRB,4.0794E-04_JPRB,4.8080E-04_JPRB,5.3172E-04_JPRB,&
&5.4015E-04_JPRB,5.0131E-04_JPRB,4.5062E-04_JPRB,2.4356E-03_JPRB/)
KAO( :, 4,12, 3) = (/&
&3.9098E-05_JPRB,2.7301E-04_JPRB,3.9923E-04_JPRB,5.0137E-04_JPRB,5.8487E-04_JPRB,6.4185E-04_JPRB,&
&6.5190E-04_JPRB,5.8598E-04_JPRB,4.9100E-04_JPRB,2.8992E-03_JPRB/)
KAO( :, 5,12, 3) = (/&
&5.8880E-05_JPRB,3.5135E-04_JPRB,5.0233E-04_JPRB,6.2054E-04_JPRB,7.1596E-04_JPRB,7.7742E-04_JPRB,&
&7.8406E-04_JPRB,7.0089E-04_JPRB,5.2975E-04_JPRB,3.3853E-03_JPRB/)
KAO( :, 1,13, 3) = (/&
&9.3589E-06_JPRB,1.1404E-04_JPRB,1.7929E-04_JPRB,2.3424E-04_JPRB,2.8177E-04_JPRB,3.1382E-04_JPRB,&
&3.2887E-04_JPRB,3.1939E-04_JPRB,3.1782E-04_JPRB,1.3712E-03_JPRB/)
KAO( :, 2,13, 3) = (/&
&1.3997E-05_JPRB,1.4070E-04_JPRB,2.1638E-04_JPRB,2.7822E-04_JPRB,3.3131E-04_JPRB,3.6740E-04_JPRB,&
&3.7618E-04_JPRB,3.5875E-04_JPRB,3.4257E-04_JPRB,1.6948E-03_JPRB/)
KAO( :, 3,13, 3) = (/&
&2.1467E-05_JPRB,1.7760E-04_JPRB,2.6657E-04_JPRB,3.3860E-04_JPRB,3.9863E-04_JPRB,4.4020E-04_JPRB,&
&4.4774E-04_JPRB,4.1503E-04_JPRB,3.7387E-04_JPRB,2.0555E-03_JPRB/)
KAO( :, 4,13, 3) = (/&
&3.2939E-05_JPRB,2.2791E-04_JPRB,3.3320E-04_JPRB,4.1728E-04_JPRB,4.8576E-04_JPRB,5.3169E-04_JPRB,&
&5.4072E-04_JPRB,4.8718E-04_JPRB,4.1358E-04_JPRB,2.4418E-03_JPRB/)
KAO( :, 5,13, 3) = (/&
&5.0038E-05_JPRB,2.9443E-04_JPRB,4.2080E-04_JPRB,5.1807E-04_JPRB,5.9619E-04_JPRB,6.4532E-04_JPRB,&
&6.5035E-04_JPRB,5.8360E-04_JPRB,4.3228E-04_JPRB,2.8426E-03_JPRB/)
KAO( :, 1, 1, 4) = (/&
&1.3959E-03_JPRB,5.9922E-03_JPRB,8.2316E-03_JPRB,9.8059E-03_JPRB,1.0613E-02_JPRB,1.0620E-02_JPRB,&
&1.0007E-02_JPRB,8.7254E-03_JPRB,5.9465E-03_JPRB,5.3438E-03_JPRB/)
KAO( :, 2, 1, 4) = (/&
&1.8497E-03_JPRB,7.5460E-03_JPRB,1.0203E-02_JPRB,1.1955E-02_JPRB,1.2786E-02_JPRB,1.2712E-02_JPRB,&
&1.1856E-02_JPRB,1.0291E-02_JPRB,7.1447E-03_JPRB,6.1713E-03_JPRB/)
KAO( :, 3, 1, 4) = (/&
&2.4455E-03_JPRB,9.3977E-03_JPRB,1.2548E-02_JPRB,1.4434E-02_JPRB,1.5252E-02_JPRB,1.5095E-02_JPRB,&
&1.3989E-02_JPRB,1.2066E-02_JPRB,8.3510E-03_JPRB,7.1167E-03_JPRB/)
KAO( :, 4, 1, 4) = (/&
&3.2093E-03_JPRB,1.1523E-02_JPRB,1.5232E-02_JPRB,1.7235E-02_JPRB,1.8051E-02_JPRB,1.7818E-02_JPRB,&
&1.6407E-02_JPRB,1.4008E-02_JPRB,9.7059E-03_JPRB,8.2637E-03_JPRB/)
KAO( :, 5, 1, 4) = (/&
&4.1640E-03_JPRB,1.3947E-02_JPRB,1.8138E-02_JPRB,2.0353E-02_JPRB,2.1133E-02_JPRB,2.0847E-02_JPRB,&
&1.9064E-02_JPRB,1.6182E-02_JPRB,1.1218E-02_JPRB,9.5219E-03_JPRB/)
KAO( :, 1, 2, 4) = (/&
&1.1784E-03_JPRB,4.8259E-03_JPRB,6.5824E-03_JPRB,7.8076E-03_JPRB,8.3997E-03_JPRB,8.4013E-03_JPRB,&
&7.9589E-03_JPRB,6.9035E-03_JPRB,4.7972E-03_JPRB,4.1536E-03_JPRB/)
KAO( :, 2, 2, 4) = (/&
&1.5660E-03_JPRB,6.0867E-03_JPRB,8.2146E-03_JPRB,9.5892E-03_JPRB,1.0197E-02_JPRB,1.0118E-02_JPRB,&
&9.4816E-03_JPRB,8.1710E-03_JPRB,5.7311E-03_JPRB,4.7856E-03_JPRB/)
KAO( :, 3, 2, 4) = (/&
&2.0771E-03_JPRB,7.6156E-03_JPRB,1.0151E-02_JPRB,1.1655E-02_JPRB,1.2244E-02_JPRB,1.2103E-02_JPRB,&
&1.1249E-02_JPRB,9.6217E-03_JPRB,6.7053E-03_JPRB,5.5268E-03_JPRB/)
KAO( :, 4, 2, 4) = (/&
&2.7371E-03_JPRB,9.3986E-03_JPRB,1.2362E-02_JPRB,1.3996E-02_JPRB,1.4573E-02_JPRB,1.4394E-02_JPRB,&
&1.3273E-02_JPRB,1.1249E-02_JPRB,7.8082E-03_JPRB,6.4145E-03_JPRB/)
KAO( :, 5, 2, 4) = (/&
&3.5707E-03_JPRB,1.1441E-02_JPRB,1.4782E-02_JPRB,1.6569E-02_JPRB,1.7185E-02_JPRB,1.6953E-02_JPRB,&
&1.5517E-02_JPRB,1.3078E-02_JPRB,9.0555E-03_JPRB,7.4094E-03_JPRB/)
KAO( :, 1, 3, 4) = (/&
&9.3612E-04_JPRB,3.7181E-03_JPRB,5.0390E-03_JPRB,5.9502E-03_JPRB,6.3679E-03_JPRB,6.3786E-03_JPRB,&
&6.0698E-03_JPRB,5.2727E-03_JPRB,3.7120E-03_JPRB,3.2201E-03_JPRB/)
KAO( :, 2, 3, 4) = (/&
&1.2490E-03_JPRB,4.6957E-03_JPRB,6.3176E-03_JPRB,7.3745E-03_JPRB,7.7966E-03_JPRB,7.7361E-03_JPRB,&
&7.2751E-03_JPRB,6.2746E-03_JPRB,4.4490E-03_JPRB,3.6844E-03_JPRB/)
KAO( :, 3, 3, 4) = (/&
&1.6672E-03_JPRB,5.9017E-03_JPRB,7.8487E-03_JPRB,9.0223E-03_JPRB,9.4573E-03_JPRB,9.3283E-03_JPRB,&
&8.6995E-03_JPRB,7.4301E-03_JPRB,5.1895E-03_JPRB,4.2405E-03_JPRB/)
KAO( :, 4, 3, 4) = (/&
&2.2134E-03_JPRB,7.3371E-03_JPRB,9.6281E-03_JPRB,1.0911E-02_JPRB,1.1346E-02_JPRB,1.1187E-02_JPRB,&
&1.0343E-02_JPRB,8.7520E-03_JPRB,6.1061E-03_JPRB,4.8883E-03_JPRB/)
KAO( :, 5, 3, 4) = (/&
&2.9080E-03_JPRB,9.0078E-03_JPRB,1.1596E-02_JPRB,1.2990E-02_JPRB,1.3474E-02_JPRB,1.3306E-02_JPRB,&
&1.2200E-02_JPRB,1.0250E-02_JPRB,7.0746E-03_JPRB,5.6394E-03_JPRB/)
KAO( :, 1, 4, 4) = (/&
&7.2899E-04_JPRB,2.8358E-03_JPRB,3.8166E-03_JPRB,4.4649E-03_JPRB,4.7605E-03_JPRB,4.7776E-03_JPRB,&
&4.5645E-03_JPRB,3.9905E-03_JPRB,2.8172E-03_JPRB,2.5259E-03_JPRB/)
KAO( :, 2, 4, 4) = (/&
&9.7562E-04_JPRB,3.5858E-03_JPRB,4.8000E-03_JPRB,5.5643E-03_JPRB,5.8729E-03_JPRB,5.8345E-03_JPRB,&
&5.5106E-03_JPRB,4.7660E-03_JPRB,3.3369E-03_JPRB,2.8747E-03_JPRB/)
KAO( :, 3, 4, 4) = (/&
&1.3110E-03_JPRB,4.5252E-03_JPRB,5.9861E-03_JPRB,6.8654E-03_JPRB,7.1912E-03_JPRB,7.0898E-03_JPRB,&
&6.6257E-03_JPRB,5.6788E-03_JPRB,3.9467E-03_JPRB,3.3017E-03_JPRB/)
KAO( :, 4, 4, 4) = (/&
&1.7535E-03_JPRB,5.6592E-03_JPRB,7.3895E-03_JPRB,8.3600E-03_JPRB,8.7028E-03_JPRB,8.5726E-03_JPRB,&
&7.9544E-03_JPRB,6.7413E-03_JPRB,4.7023E-03_JPRB,3.7920E-03_JPRB/)
KAO( :, 5, 4, 4) = (/&
&2.3234E-03_JPRB,7.0001E-03_JPRB,8.9795E-03_JPRB,1.0033E-02_JPRB,1.0407E-02_JPRB,1.0269E-02_JPRB,&
&9.4690E-03_JPRB,7.9455E-03_JPRB,5.4450E-03_JPRB,4.3729E-03_JPRB/)
KAO( :, 1, 5, 4) = (/&
&5.6650E-04_JPRB,2.1549E-03_JPRB,2.8964E-03_JPRB,3.3619E-03_JPRB,3.5664E-03_JPRB,3.5841E-03_JPRB,&
&3.4323E-03_JPRB,3.0201E-03_JPRB,2.2575E-03_JPRB,2.0547E-03_JPRB/)
KAO( :, 2, 5, 4) = (/&
&7.5923E-04_JPRB,2.7449E-03_JPRB,3.6494E-03_JPRB,4.2010E-03_JPRB,4.4180E-03_JPRB,4.3953E-03_JPRB,&
&4.1675E-03_JPRB,3.6219E-03_JPRB,2.5473E-03_JPRB,2.3046E-03_JPRB/)
KAO( :, 3, 5, 4) = (/&
&1.0253E-03_JPRB,3.4834E-03_JPRB,4.5686E-03_JPRB,5.2069E-03_JPRB,5.4481E-03_JPRB,5.3758E-03_JPRB,&
&5.0408E-03_JPRB,4.3359E-03_JPRB,3.0162E-03_JPRB,2.6195E-03_JPRB/)
KAO( :, 4, 5, 4) = (/&
&1.3801E-03_JPRB,4.3804E-03_JPRB,5.6725E-03_JPRB,6.3841E-03_JPRB,6.6485E-03_JPRB,6.5457E-03_JPRB,&
&6.0914E-03_JPRB,5.1828E-03_JPRB,3.5636E-03_JPRB,2.9971E-03_JPRB/)
KAO( :, 5, 5, 4) = (/&
&1.8434E-03_JPRB,5.4391E-03_JPRB,6.9434E-03_JPRB,7.7307E-03_JPRB,8.0143E-03_JPRB,7.8901E-03_JPRB,&
&7.3072E-03_JPRB,6.1548E-03_JPRB,4.1784E-03_JPRB,3.4508E-03_JPRB/)
KAO( :, 1, 6, 4) = (/&
&4.3479E-04_JPRB,1.6105E-03_JPRB,2.1624E-03_JPRB,2.5048E-03_JPRB,2.6629E-03_JPRB,2.6833E-03_JPRB,&
&2.5738E-03_JPRB,2.2737E-03_JPRB,1.8606E-03_JPRB,1.7234E-03_JPRB/)
KAO( :, 2, 6, 4) = (/&
&5.8233E-04_JPRB,2.0650E-03_JPRB,2.7444E-03_JPRB,3.1464E-03_JPRB,3.3112E-03_JPRB,3.2967E-03_JPRB,&
&3.1292E-03_JPRB,2.7330E-03_JPRB,1.9142E-03_JPRB,1.9183E-03_JPRB/)
KAO( :, 3, 6, 4) = (/&
&7.8843E-04_JPRB,2.6457E-03_JPRB,3.4646E-03_JPRB,3.9221E-03_JPRB,4.0954E-03_JPRB,4.0443E-03_JPRB,&
&3.8065E-03_JPRB,3.2872E-03_JPRB,2.2472E-03_JPRB,2.1603E-03_JPRB/)
KAO( :, 4, 6, 4) = (/&
&1.0676E-03_JPRB,3.3599E-03_JPRB,4.3294E-03_JPRB,4.8406E-03_JPRB,5.0306E-03_JPRB,4.9525E-03_JPRB,&
&4.6235E-03_JPRB,3.9530E-03_JPRB,2.6778E-03_JPRB,2.4636E-03_JPRB/)
KAO( :, 5, 6, 4) = (/&
&1.4360E-03_JPRB,4.2028E-03_JPRB,5.3355E-03_JPRB,5.9075E-03_JPRB,6.1148E-03_JPRB,6.0070E-03_JPRB,&
&5.5779E-03_JPRB,4.7305E-03_JPRB,3.1938E-03_JPRB,2.8201E-03_JPRB/)
KAO( :, 1, 7, 4) = (/&
&3.3066E-04_JPRB,1.1921E-03_JPRB,1.5997E-03_JPRB,1.8508E-03_JPRB,1.9750E-03_JPRB,2.0065E-03_JPRB,&
&1.9362E-03_JPRB,1.7121E-03_JPRB,1.5102E-03_JPRB,1.4755E-03_JPRB/)
KAO( :, 2, 7, 4) = (/&
&4.4251E-04_JPRB,1.5399E-03_JPRB,2.0431E-03_JPRB,2.3386E-03_JPRB,2.4693E-03_JPRB,2.4731E-03_JPRB,&
&2.3559E-03_JPRB,2.0619E-03_JPRB,1.5167E-03_JPRB,1.6278E-03_JPRB/)
KAO( :, 3, 7, 4) = (/&
&5.9954E-04_JPRB,1.9895E-03_JPRB,2.5996E-03_JPRB,2.9389E-03_JPRB,3.0769E-03_JPRB,3.0449E-03_JPRB,&
&2.8696E-03_JPRB,2.4854E-03_JPRB,1.7100E-03_JPRB,1.8261E-03_JPRB/)
KAO( :, 4, 7, 4) = (/&
&8.1539E-04_JPRB,2.5548E-03_JPRB,3.2831E-03_JPRB,3.6604E-03_JPRB,3.8004E-03_JPRB,3.7406E-03_JPRB,&
&3.5004E-03_JPRB,3.0009E-03_JPRB,2.0185E-03_JPRB,2.0723E-03_JPRB/)
KAO( :, 5, 7, 4) = (/&
&1.1035E-03_JPRB,3.2299E-03_JPRB,4.0851E-03_JPRB,4.5054E-03_JPRB,4.6506E-03_JPRB,4.5636E-03_JPRB,&
&4.2458E-03_JPRB,3.6170E-03_JPRB,2.4150E-03_JPRB,2.3689E-03_JPRB/)
KAO( :, 1, 8, 4) = (/&
&2.4824E-04_JPRB,8.7576E-04_JPRB,1.1750E-03_JPRB,1.3620E-03_JPRB,1.4591E-03_JPRB,1.4944E-03_JPRB,&
&1.4530E-03_JPRB,1.3016E-03_JPRB,1.2362E-03_JPRB,1.3815E-03_JPRB/)
KAO( :, 2, 8, 4) = (/&
&3.3230E-04_JPRB,1.1390E-03_JPRB,1.5103E-03_JPRB,1.7306E-03_JPRB,1.8323E-03_JPRB,1.8454E-03_JPRB,&
&1.7715E-03_JPRB,1.5588E-03_JPRB,1.2567E-03_JPRB,1.5241E-03_JPRB/)
KAO( :, 3, 8, 4) = (/&
&4.5036E-04_JPRB,1.4833E-03_JPRB,1.9397E-03_JPRB,2.1911E-03_JPRB,2.2984E-03_JPRB,2.2843E-03_JPRB,&
&2.1644E-03_JPRB,1.8786E-03_JPRB,1.3010E-03_JPRB,1.7047E-03_JPRB/)
KAO( :, 4, 8, 4) = (/&
&6.1425E-04_JPRB,1.9258E-03_JPRB,2.4736E-03_JPRB,2.7526E-03_JPRB,2.8618E-03_JPRB,2.8208E-03_JPRB,&
&2.6474E-03_JPRB,2.2738E-03_JPRB,1.4977E-03_JPRB,1.9231E-03_JPRB/)
KAO( :, 5, 8, 4) = (/&
&8.3579E-04_JPRB,2.4677E-03_JPRB,3.1100E-03_JPRB,3.4209E-03_JPRB,3.5321E-03_JPRB,3.4664E-03_JPRB,&
&3.2302E-03_JPRB,2.7529E-03_JPRB,1.8211E-03_JPRB,2.1802E-03_JPRB/)
KAO( :, 1, 9, 4) = (/&
&1.8648E-04_JPRB,6.4213E-04_JPRB,8.6248E-04_JPRB,1.0018E-03_JPRB,1.0759E-03_JPRB,1.1114E-03_JPRB,&
&1.0893E-03_JPRB,9.9064E-04_JPRB,9.8753E-04_JPRB,1.8775E-03_JPRB/)
KAO( :, 2, 9, 4) = (/&
&2.4931E-04_JPRB,8.3843E-04_JPRB,1.1135E-03_JPRB,1.2777E-03_JPRB,1.3549E-03_JPRB,1.3735E-03_JPRB,&
&1.3267E-03_JPRB,1.1784E-03_JPRB,1.0225E-03_JPRB,2.0725E-03_JPRB/)
KAO( :, 3, 9, 4) = (/&
&3.3739E-04_JPRB,1.0997E-03_JPRB,1.4388E-03_JPRB,1.6275E-03_JPRB,1.7095E-03_JPRB,1.7064E-03_JPRB,&
&1.6276E-03_JPRB,1.4244E-03_JPRB,1.0196E-03_JPRB,2.3196E-03_JPRB/)
KAO( :, 4, 9, 4) = (/&
&4.6000E-04_JPRB,1.4414E-03_JPRB,1.8531E-03_JPRB,2.0634E-03_JPRB,2.1453E-03_JPRB,2.1162E-03_JPRB,&
&1.9970E-03_JPRB,1.7248E-03_JPRB,1.1677E-03_JPRB,2.6078E-03_JPRB/)
KAO( :, 5, 9, 4) = (/&
&6.2819E-04_JPRB,1.8702E-03_JPRB,2.3574E-03_JPRB,2.5903E-03_JPRB,2.6704E-03_JPRB,2.6214E-03_JPRB,&
&2.4477E-03_JPRB,2.0914E-03_JPRB,1.3608E-03_JPRB,2.9294E-03_JPRB/)
KAO( :, 1,10, 4) = (/&
&1.4307E-04_JPRB,4.7989E-04_JPRB,6.4527E-04_JPRB,7.5154E-04_JPRB,8.0960E-04_JPRB,8.4090E-04_JPRB,&
&8.3086E-04_JPRB,7.6874E-04_JPRB,8.2863E-04_JPRB,3.6347E-03_JPRB/)
KAO( :, 2,10, 4) = (/&
&1.9105E-04_JPRB,6.2858E-04_JPRB,8.3500E-04_JPRB,9.5991E-04_JPRB,1.0185E-03_JPRB,1.0393E-03_JPRB,&
&1.0095E-03_JPRB,9.0118E-04_JPRB,8.3114E-04_JPRB,4.2294E-03_JPRB/)
KAO( :, 3,10, 4) = (/&
&2.5819E-04_JPRB,8.2975E-04_JPRB,1.0848E-03_JPRB,1.2290E-03_JPRB,1.2908E-03_JPRB,1.2943E-03_JPRB,&
&1.2407E-03_JPRB,1.0947E-03_JPRB,8.4507E-04_JPRB,4.7942E-03_JPRB/)
KAO( :, 4,10, 4) = (/&
&3.5175E-04_JPRB,1.0966E-03_JPRB,1.4090E-03_JPRB,1.5695E-03_JPRB,1.6301E-03_JPRB,1.6125E-03_JPRB,&
&1.5271E-03_JPRB,1.3244E-03_JPRB,8.9574E-04_JPRB,5.3326E-03_JPRB/)
KAO( :, 5,10, 4) = (/&
&4.8140E-04_JPRB,1.4355E-03_JPRB,1.8096E-03_JPRB,1.9894E-03_JPRB,2.0475E-03_JPRB,2.0080E-03_JPRB,&
&1.8768E-03_JPRB,1.6118E-03_JPRB,1.0323E-03_JPRB,5.8712E-03_JPRB/)
KAO( :, 1,11, 4) = (/&
&1.2480E-04_JPRB,4.0651E-04_JPRB,5.4317E-04_JPRB,6.3057E-04_JPRB,6.7711E-04_JPRB,7.0124E-04_JPRB,&
&6.9230E-04_JPRB,6.3637E-04_JPRB,6.7480E-04_JPRB,4.4748E-03_JPRB/)
KAO( :, 2,11, 4) = (/&
&1.6789E-04_JPRB,5.3657E-04_JPRB,7.0675E-04_JPRB,8.0798E-04_JPRB,8.5575E-04_JPRB,8.7116E-04_JPRB,&
&8.4422E-04_JPRB,7.5306E-04_JPRB,6.8219E-04_JPRB,5.2484E-03_JPRB/)
KAO( :, 3,11, 4) = (/&
&2.2748E-04_JPRB,7.1324E-04_JPRB,9.2430E-04_JPRB,1.0391E-03_JPRB,1.0880E-03_JPRB,1.0885E-03_JPRB,&
&1.0414E-03_JPRB,9.1761E-04_JPRB,6.9310E-04_JPRB,5.9997E-03_JPRB/)
KAO( :, 4,11, 4) = (/&
&3.1100E-04_JPRB,9.4662E-04_JPRB,1.2062E-03_JPRB,1.3345E-03_JPRB,1.3806E-03_JPRB,1.3616E-03_JPRB,&
&1.2842E-03_JPRB,1.1132E-03_JPRB,7.5183E-04_JPRB,6.7275E-03_JPRB/)
KAO( :, 5,11, 4) = (/&
&4.2632E-04_JPRB,1.2375E-03_JPRB,1.5507E-03_JPRB,1.6996E-03_JPRB,1.7428E-03_JPRB,1.7046E-03_JPRB,&
&1.5835E-03_JPRB,1.3580E-03_JPRB,8.6852E-04_JPRB,7.4572E-03_JPRB/)
KAO( :, 1,12, 4) = (/&
&1.0738E-04_JPRB,3.4370E-04_JPRB,4.5561E-04_JPRB,5.2712E-04_JPRB,5.6512E-04_JPRB,5.8418E-04_JPRB,&
&5.7608E-04_JPRB,5.2824E-04_JPRB,5.5584E-04_JPRB,4.5229E-03_JPRB/)
KAO( :, 2,12, 4) = (/&
&1.4509E-04_JPRB,4.5719E-04_JPRB,5.9628E-04_JPRB,6.7809E-04_JPRB,7.1697E-04_JPRB,7.2848E-04_JPRB,&
&7.0565E-04_JPRB,6.2997E-04_JPRB,5.6436E-04_JPRB,5.3156E-03_JPRB/)
KAO( :, 3,12, 4) = (/&
&1.9783E-04_JPRB,6.1167E-04_JPRB,7.8481E-04_JPRB,8.7764E-04_JPRB,9.1476E-04_JPRB,9.1298E-04_JPRB,&
&8.7252E-04_JPRB,7.6652E-04_JPRB,5.7011E-04_JPRB,6.0757E-03_JPRB/)
KAO( :, 4,12, 4) = (/&
&2.7192E-04_JPRB,8.1173E-04_JPRB,1.0265E-03_JPRB,1.1333E-03_JPRB,1.1680E-03_JPRB,1.1490E-03_JPRB,&
&1.0784E-03_JPRB,9.3361E-04_JPRB,6.2718E-04_JPRB,6.8113E-03_JPRB/)
KAO( :, 5,12, 4) = (/&
&3.7397E-04_JPRB,1.0598E-03_JPRB,1.3197E-03_JPRB,1.4449E-03_JPRB,1.4799E-03_JPRB,1.4465E-03_JPRB,&
&1.3362E-03_JPRB,1.1407E-03_JPRB,7.2415E-04_JPRB,7.5425E-03_JPRB/)
KAO( :, 1,13, 4) = (/&
&8.9292E-05_JPRB,2.8719E-04_JPRB,3.7864E-04_JPRB,4.3694E-04_JPRB,4.6878E-04_JPRB,4.8461E-04_JPRB,&
&4.7788E-04_JPRB,4.3842E-04_JPRB,4.5719E-04_JPRB,3.8416E-03_JPRB/)
KAO( :, 2,13, 4) = (/&
&1.2149E-04_JPRB,3.8537E-04_JPRB,4.9918E-04_JPRB,5.6557E-04_JPRB,5.9698E-04_JPRB,6.0549E-04_JPRB,&
&5.8708E-04_JPRB,5.2472E-04_JPRB,4.6787E-04_JPRB,4.4931E-03_JPRB/)
KAO( :, 3,13, 4) = (/&
&1.6719E-04_JPRB,5.1756E-04_JPRB,6.6044E-04_JPRB,7.3666E-04_JPRB,7.6591E-04_JPRB,7.6260E-04_JPRB,&
&7.2753E-04_JPRB,6.3867E-04_JPRB,4.6954E-04_JPRB,5.0961E-03_JPRB/)
KAO( :, 4,13, 4) = (/&
&2.3161E-04_JPRB,6.8759E-04_JPRB,8.6435E-04_JPRB,9.5388E-04_JPRB,9.8295E-04_JPRB,9.6568E-04_JPRB,&
&9.0300E-04_JPRB,7.7979E-04_JPRB,5.2227E-04_JPRB,5.6855E-03_JPRB/)
KAO( :, 5,13, 4) = (/&
&3.2057E-04_JPRB,8.9923E-04_JPRB,1.1130E-03_JPRB,1.2171E-03_JPRB,1.2465E-03_JPRB,1.2193E-03_JPRB,&
&1.1245E-03_JPRB,9.5521E-04_JPRB,6.0646E-04_JPRB,6.2875E-03_JPRB/)
KAO( :, 1, 1, 5) = (/&
&7.8581E-03_JPRB,1.6359E-02_JPRB,1.8747E-02_JPRB,1.9104E-02_JPRB,1.8493E-02_JPRB,1.7453E-02_JPRB,&
&1.6124E-02_JPRB,1.4436E-02_JPRB,9.9634E-03_JPRB,9.0266E-03_JPRB/)
KAO( :, 2, 1, 5) = (/&
&1.0248E-02_JPRB,1.9930E-02_JPRB,2.2543E-02_JPRB,2.2901E-02_JPRB,2.2187E-02_JPRB,2.0954E-02_JPRB,&
&1.9379E-02_JPRB,1.7194E-02_JPRB,1.1961E-02_JPRB,1.0706E-02_JPRB/)
KAO( :, 3, 1, 5) = (/&
&1.3096E-02_JPRB,2.3888E-02_JPRB,2.6739E-02_JPRB,2.7195E-02_JPRB,2.6433E-02_JPRB,2.4936E-02_JPRB,&
&2.3046E-02_JPRB,2.0295E-02_JPRB,1.4106E-02_JPRB,1.2544E-02_JPRB/)
KAO( :, 4, 1, 5) = (/&
&1.6338E-02_JPRB,2.8329E-02_JPRB,3.1500E-02_JPRB,3.2047E-02_JPRB,3.1151E-02_JPRB,2.9395E-02_JPRB,&
&2.7258E-02_JPRB,2.3909E-02_JPRB,1.6479E-02_JPRB,1.4541E-02_JPRB/)
KAO( :, 5, 1, 5) = (/&
&1.9905E-02_JPRB,3.3267E-02_JPRB,3.6925E-02_JPRB,3.7523E-02_JPRB,3.6460E-02_JPRB,3.4480E-02_JPRB,&
&3.1939E-02_JPRB,2.7924E-02_JPRB,1.9096E-02_JPRB,1.6820E-02_JPRB/)
KAO( :, 1, 2, 5) = (/&
&6.5000E-03_JPRB,1.3210E-02_JPRB,1.5017E-02_JPRB,1.5338E-02_JPRB,1.4894E-02_JPRB,1.4046E-02_JPRB,&
&1.2886E-02_JPRB,1.1485E-02_JPRB,7.8396E-03_JPRB,6.9835E-03_JPRB/)
KAO( :, 2, 2, 5) = (/&
&8.5060E-03_JPRB,1.6246E-02_JPRB,1.8196E-02_JPRB,1.8546E-02_JPRB,1.7999E-02_JPRB,1.6962E-02_JPRB,&
&1.5570E-02_JPRB,1.3759E-02_JPRB,9.5004E-03_JPRB,8.2524E-03_JPRB/)
KAO( :, 3, 2, 5) = (/&
&1.0895E-02_JPRB,1.9629E-02_JPRB,2.1801E-02_JPRB,2.2202E-02_JPRB,2.1571E-02_JPRB,2.0287E-02_JPRB,&
&1.8619E-02_JPRB,1.6336E-02_JPRB,1.1311E-02_JPRB,9.6763E-03_JPRB/)
KAO( :, 4, 2, 5) = (/&
&1.3634E-02_JPRB,2.3467E-02_JPRB,2.5938E-02_JPRB,2.6385E-02_JPRB,2.5626E-02_JPRB,2.4039E-02_JPRB,&
&2.2108E-02_JPRB,1.9320E-02_JPRB,1.3277E-02_JPRB,1.1254E-02_JPRB/)
KAO( :, 5, 2, 5) = (/&
&1.6643E-02_JPRB,2.7789E-02_JPRB,3.0666E-02_JPRB,3.1149E-02_JPRB,3.0178E-02_JPRB,2.8317E-02_JPRB,&
&2.6023E-02_JPRB,2.2644E-02_JPRB,1.5438E-02_JPRB,1.3058E-02_JPRB/)
KAO( :, 1, 3, 5) = (/&
&5.1068E-03_JPRB,1.0155E-02_JPRB,1.1485E-02_JPRB,1.1770E-02_JPRB,1.1484E-02_JPRB,1.0823E-02_JPRB,&
&9.8623E-03_JPRB,8.7594E-03_JPRB,5.9958E-03_JPRB,5.2611E-03_JPRB/)
KAO( :, 2, 3, 5) = (/&
&6.6835E-03_JPRB,1.2640E-02_JPRB,1.4084E-02_JPRB,1.4382E-02_JPRB,1.4023E-02_JPRB,1.3192E-02_JPRB,&
&1.2012E-02_JPRB,1.0560E-02_JPRB,7.2917E-03_JPRB,6.1864E-03_JPRB/)
KAO( :, 3, 3, 5) = (/&
&8.6033E-03_JPRB,1.5444E-02_JPRB,1.7069E-02_JPRB,1.7437E-02_JPRB,1.6940E-02_JPRB,1.5900E-02_JPRB,&
&1.4464E-02_JPRB,1.2619E-02_JPRB,8.8116E-03_JPRB,7.2531E-03_JPRB/)
KAO( :, 4, 3, 5) = (/&
&1.0832E-02_JPRB,1.8665E-02_JPRB,2.0521E-02_JPRB,2.0939E-02_JPRB,2.0314E-02_JPRB,1.9000E-02_JPRB,&
&1.7289E-02_JPRB,1.5015E-02_JPRB,1.0355E-02_JPRB,8.4725E-03_JPRB/)
KAO( :, 5, 3, 5) = (/&
&1.3328E-02_JPRB,2.2307E-02_JPRB,2.4508E-02_JPRB,2.4967E-02_JPRB,2.4135E-02_JPRB,2.2494E-02_JPRB,&
&2.0482E-02_JPRB,1.7714E-02_JPRB,1.2161E-02_JPRB,9.8543E-03_JPRB/)
KAO( :, 1, 4, 5) = (/&
&3.9695E-03_JPRB,7.6818E-03_JPRB,8.6331E-03_JPRB,8.8728E-03_JPRB,8.6847E-03_JPRB,8.1743E-03_JPRB,&
&7.4171E-03_JPRB,6.5733E-03_JPRB,4.6756E-03_JPRB,4.0395E-03_JPRB/)
KAO( :, 2, 4, 5) = (/&
&5.1871E-03_JPRB,9.6669E-03_JPRB,1.0730E-02_JPRB,1.0984E-02_JPRB,1.0727E-02_JPRB,1.0079E-02_JPRB,&
&9.1130E-03_JPRB,7.9640E-03_JPRB,5.5230E-03_JPRB,4.7457E-03_JPRB/)
KAO( :, 3, 4, 5) = (/&
&6.6872E-03_JPRB,1.1936E-02_JPRB,1.3150E-02_JPRB,1.3447E-02_JPRB,1.3090E-02_JPRB,1.2266E-02_JPRB,&
&1.1082E-02_JPRB,9.5819E-03_JPRB,6.7239E-03_JPRB,5.5582E-03_JPRB/)
KAO( :, 4, 4, 5) = (/&
&8.4686E-03_JPRB,1.4558E-02_JPRB,1.5982E-02_JPRB,1.6346E-02_JPRB,1.5841E-02_JPRB,1.4783E-02_JPRB,&
&1.3331E-02_JPRB,1.1473E-02_JPRB,7.9455E-03_JPRB,6.5009E-03_JPRB/)
KAO( :, 5, 4, 5) = (/&
&1.0530E-02_JPRB,1.7532E-02_JPRB,1.9245E-02_JPRB,1.9697E-02_JPRB,1.9021E-02_JPRB,1.7663E-02_JPRB,&
&1.5910E-02_JPRB,1.3642E-02_JPRB,9.4173E-03_JPRB,7.5638E-03_JPRB/)
KAO( :, 1, 5, 5) = (/&
&3.1180E-03_JPRB,5.8209E-03_JPRB,6.4854E-03_JPRB,6.6644E-03_JPRB,6.5380E-03_JPRB,6.1410E-03_JPRB,&
&5.5609E-03_JPRB,4.9182E-03_JPRB,3.5969E-03_JPRB,3.1582E-03_JPRB/)
KAO( :, 2, 5, 5) = (/&
&4.0549E-03_JPRB,7.3757E-03_JPRB,8.1520E-03_JPRB,8.3497E-03_JPRB,8.1550E-03_JPRB,7.6434E-03_JPRB,&
&6.8934E-03_JPRB,5.9840E-03_JPRB,4.1290E-03_JPRB,3.6940E-03_JPRB/)
KAO( :, 3, 5, 5) = (/&
&5.2180E-03_JPRB,9.1787E-03_JPRB,1.0116E-02_JPRB,1.0335E-02_JPRB,1.0048E-02_JPRB,9.4058E-03_JPRB,&
&8.4592E-03_JPRB,7.2447E-03_JPRB,5.0478E-03_JPRB,4.3308E-03_JPRB/)
KAO( :, 4, 5, 5) = (/&
&6.6347E-03_JPRB,1.1285E-02_JPRB,1.2392E-02_JPRB,1.2680E-02_JPRB,1.2274E-02_JPRB,1.1447E-02_JPRB,&
&1.0271E-02_JPRB,8.7310E-03_JPRB,6.0849E-03_JPRB,5.0691E-03_JPRB/)
KAO( :, 5, 5, 5) = (/&
&8.3131E-03_JPRB,1.3706E-02_JPRB,1.5023E-02_JPRB,1.5394E-02_JPRB,1.4880E-02_JPRB,1.3810E-02_JPRB,&
&1.2359E-02_JPRB,1.0459E-02_JPRB,7.2538E-03_JPRB,5.9083E-03_JPRB/)
KAO( :, 1, 6, 5) = (/&
&2.4113E-03_JPRB,4.4035E-03_JPRB,4.8584E-03_JPRB,4.9702E-03_JPRB,4.8652E-03_JPRB,4.5631E-03_JPRB,&
&4.1282E-03_JPRB,3.6475E-03_JPRB,2.6495E-03_JPRB,2.6380E-03_JPRB/)
KAO( :, 2, 6, 5) = (/&
&3.1417E-03_JPRB,5.6041E-03_JPRB,6.1552E-03_JPRB,6.2788E-03_JPRB,6.1209E-03_JPRB,5.7279E-03_JPRB,&
&5.1621E-03_JPRB,4.4647E-03_JPRB,3.1333E-03_JPRB,3.0490E-03_JPRB/)
KAO( :, 3, 6, 5) = (/&
&4.0523E-03_JPRB,7.0107E-03_JPRB,7.6974E-03_JPRB,7.8556E-03_JPRB,7.6249E-03_JPRB,7.1228E-03_JPRB,&
&6.3982E-03_JPRB,5.4412E-03_JPRB,3.7354E-03_JPRB,3.5351E-03_JPRB/)
KAO( :, 4, 6, 5) = (/&
&5.1735E-03_JPRB,8.6714E-03_JPRB,9.5046E-03_JPRB,9.7062E-03_JPRB,9.3937E-03_JPRB,8.7514E-03_JPRB,&
&7.8427E-03_JPRB,6.5998E-03_JPRB,4.6231E-03_JPRB,4.0931E-03_JPRB/)
KAO( :, 5, 6, 5) = (/&
&6.5266E-03_JPRB,1.0615E-02_JPRB,1.1603E-02_JPRB,1.1862E-02_JPRB,1.1470E-02_JPRB,1.0665E-02_JPRB,&
&9.5307E-03_JPRB,7.9589E-03_JPRB,5.4908E-03_JPRB,4.7354E-03_JPRB/)
KAO( :, 1, 7, 5) = (/&
&1.8313E-03_JPRB,3.2981E-03_JPRB,3.6334E-03_JPRB,3.7067E-03_JPRB,3.6201E-03_JPRB,3.3912E-03_JPRB,&
&3.0679E-03_JPRB,2.7066E-03_JPRB,2.0241E-03_JPRB,2.2554E-03_JPRB/)
KAO( :, 2, 7, 5) = (/&
&2.3976E-03_JPRB,4.2444E-03_JPRB,4.6442E-03_JPRB,4.7217E-03_JPRB,4.5915E-03_JPRB,4.2847E-03_JPRB,&
&3.8546E-03_JPRB,3.3328E-03_JPRB,2.4081E-03_JPRB,2.5954E-03_JPRB/)
KAO( :, 3, 7, 5) = (/&
&3.1184E-03_JPRB,5.3559E-03_JPRB,5.8460E-03_JPRB,5.9451E-03_JPRB,5.7583E-03_JPRB,5.3717E-03_JPRB,&
&4.8180E-03_JPRB,4.0888E-03_JPRB,2.7879E-03_JPRB,3.0032E-03_JPRB/)
KAO( :, 4, 7, 5) = (/&
&4.0216E-03_JPRB,6.6605E-03_JPRB,7.2700E-03_JPRB,7.4007E-03_JPRB,7.1549E-03_JPRB,6.6561E-03_JPRB,&
&5.9599E-03_JPRB,4.9929E-03_JPRB,3.4384E-03_JPRB,3.4860E-03_JPRB/)
KAO( :, 5, 7, 5) = (/&
&5.1206E-03_JPRB,8.2127E-03_JPRB,8.9364E-03_JPRB,9.0944E-03_JPRB,8.7960E-03_JPRB,8.1717E-03_JPRB,&
&7.3059E-03_JPRB,6.0651E-03_JPRB,4.1362E-03_JPRB,4.0383E-03_JPRB/)
KAO( :, 1, 8, 5) = (/&
&1.3678E-03_JPRB,2.4344E-03_JPRB,2.6771E-03_JPRB,2.7314E-03_JPRB,2.6764E-03_JPRB,2.5199E-03_JPRB,&
&2.2892E-03_JPRB,2.0146E-03_JPRB,1.5158E-03_JPRB,2.0717E-03_JPRB/)
KAO( :, 2, 8, 5) = (/&
&1.7986E-03_JPRB,3.1721E-03_JPRB,3.4698E-03_JPRB,3.5325E-03_JPRB,3.4383E-03_JPRB,3.2125E-03_JPRB,&
&2.8853E-03_JPRB,2.4940E-03_JPRB,1.7790E-03_JPRB,2.3653E-03_JPRB/)
KAO( :, 3, 8, 5) = (/&
&2.3644E-03_JPRB,4.0587E-03_JPRB,4.4194E-03_JPRB,4.4912E-03_JPRB,4.3505E-03_JPRB,4.0574E-03_JPRB,&
&3.6294E-03_JPRB,3.0753E-03_JPRB,2.0908E-03_JPRB,2.7075E-03_JPRB/)
KAO( :, 4, 8, 5) = (/&
&3.0885E-03_JPRB,5.1052E-03_JPRB,5.5511E-03_JPRB,5.6359E-03_JPRB,5.4460E-03_JPRB,5.0617E-03_JPRB,&
&4.5202E-03_JPRB,3.7834E-03_JPRB,2.5293E-03_JPRB,3.1178E-03_JPRB/)
KAO( :, 5, 8, 5) = (/&
&3.9843E-03_JPRB,6.3521E-03_JPRB,6.8780E-03_JPRB,6.9729E-03_JPRB,6.7374E-03_JPRB,6.2484E-03_JPRB,&
&5.5746E-03_JPRB,4.6304E-03_JPRB,3.1216E-03_JPRB,3.5944E-03_JPRB/)
KAO( :, 1, 9, 5) = (/&
&1.0180E-03_JPRB,1.7808E-03_JPRB,1.9513E-03_JPRB,1.9917E-03_JPRB,1.9571E-03_JPRB,1.8568E-03_JPRB,&
&1.7034E-03_JPRB,1.5143E-03_JPRB,1.2324E-03_JPRB,2.9566E-03_JPRB/)
KAO( :, 2, 9, 5) = (/&
&1.3409E-03_JPRB,2.3491E-03_JPRB,2.5644E-03_JPRB,2.6103E-03_JPRB,2.5515E-03_JPRB,2.3969E-03_JPRB,&
&2.1596E-03_JPRB,1.8679E-03_JPRB,1.3632E-03_JPRB,3.3317E-03_JPRB/)
KAO( :, 3, 9, 5) = (/&
&1.7770E-03_JPRB,3.0450E-03_JPRB,3.3094E-03_JPRB,3.3641E-03_JPRB,3.2693E-03_JPRB,3.0590E-03_JPRB,&
&2.7358E-03_JPRB,2.3083E-03_JPRB,1.6204E-03_JPRB,3.7464E-03_JPRB/)
KAO( :, 4, 9, 5) = (/&
&2.3520E-03_JPRB,3.8805E-03_JPRB,4.2090E-03_JPRB,4.2722E-03_JPRB,4.1362E-03_JPRB,3.8521E-03_JPRB,&
&3.4256E-03_JPRB,2.8568E-03_JPRB,1.8732E-03_JPRB,4.2061E-03_JPRB/)
KAO( :, 5, 9, 5) = (/&
&3.0729E-03_JPRB,4.8855E-03_JPRB,5.2770E-03_JPRB,5.3379E-03_JPRB,5.1589E-03_JPRB,4.7790E-03_JPRB,&
&4.2478E-03_JPRB,3.5241E-03_JPRB,2.3400E-03_JPRB,4.7374E-03_JPRB/)
KAO( :, 1,10, 5) = (/&
&7.7253E-04_JPRB,1.3219E-03_JPRB,1.4421E-03_JPRB,1.4740E-03_JPRB,1.4539E-03_JPRB,1.3876E-03_JPRB,&
&1.2853E-03_JPRB,1.1567E-03_JPRB,1.0022E-03_JPRB,6.8847E-03_JPRB/)
KAO( :, 2,10, 5) = (/&
&1.0173E-03_JPRB,1.7625E-03_JPRB,1.9200E-03_JPRB,1.9559E-03_JPRB,1.9175E-03_JPRB,1.8087E-03_JPRB,&
&1.6367E-03_JPRB,1.4242E-03_JPRB,1.0394E-03_JPRB,7.5328E-03_JPRB/)
KAO( :, 3,10, 5) = (/&
&1.3564E-03_JPRB,2.3122E-03_JPRB,2.5093E-03_JPRB,2.5497E-03_JPRB,2.4848E-03_JPRB,2.3312E-03_JPRB,&
&2.0902E-03_JPRB,1.7668E-03_JPRB,1.2230E-03_JPRB,8.3126E-03_JPRB/)
KAO( :, 4,10, 5) = (/&
&1.8134E-03_JPRB,2.9832E-03_JPRB,3.2264E-03_JPRB,3.2755E-03_JPRB,3.1788E-03_JPRB,2.9672E-03_JPRB,&
&2.6373E-03_JPRB,2.1956E-03_JPRB,1.4206E-03_JPRB,9.1949E-03_JPRB/)
KAO( :, 5,10, 5) = (/&
&2.3982E-03_JPRB,3.8024E-03_JPRB,4.0921E-03_JPRB,4.1370E-03_JPRB,4.0025E-03_JPRB,3.7132E-03_JPRB,&
&3.2913E-03_JPRB,2.7187E-03_JPRB,1.7437E-03_JPRB,1.0174E-02_JPRB/)
KAO( :, 1,11, 5) = (/&
&6.6311E-04_JPRB,1.1233E-03_JPRB,1.2219E-03_JPRB,1.2485E-03_JPRB,1.2298E-03_JPRB,1.1731E-03_JPRB,&
&1.0818E-03_JPRB,9.6812E-04_JPRB,8.2277E-04_JPRB,9.1151E-03_JPRB/)
KAO( :, 2,11, 5) = (/&
&8.7961E-04_JPRB,1.5044E-03_JPRB,1.6329E-03_JPRB,1.6631E-03_JPRB,1.6279E-03_JPRB,1.5346E-03_JPRB,&
&1.3878E-03_JPRB,1.1990E-03_JPRB,8.6844E-04_JPRB,9.9636E-03_JPRB/)
KAO( :, 3,11, 5) = (/&
&1.1836E-03_JPRB,1.9811E-03_JPRB,2.1444E-03_JPRB,2.1783E-03_JPRB,2.1211E-03_JPRB,1.9859E-03_JPRB,&
&1.7780E-03_JPRB,1.4952E-03_JPRB,1.0190E-03_JPRB,1.0941E-02_JPRB/)
KAO( :, 4,11, 5) = (/&
&1.5905E-03_JPRB,2.5713E-03_JPRB,2.7694E-03_JPRB,2.8087E-03_JPRB,2.7235E-03_JPRB,2.5357E-03_JPRB,&
&2.2512E-03_JPRB,1.8676E-03_JPRB,1.1718E-03_JPRB,1.2060E-02_JPRB/)
KAO( :, 5,11, 5) = (/&
&2.1118E-03_JPRB,3.3009E-03_JPRB,3.5298E-03_JPRB,3.5548E-03_JPRB,3.4369E-03_JPRB,3.1821E-03_JPRB,&
&2.8194E-03_JPRB,2.3141E-03_JPRB,1.4442E-03_JPRB,1.3285E-02_JPRB/)
KAO( :, 1,12, 5) = (/&
&5.6477E-04_JPRB,9.5054E-04_JPRB,1.0327E-03_JPRB,1.0546E-03_JPRB,1.0374E-03_JPRB,9.8870E-04_JPRB,&
&9.0992E-04_JPRB,8.0701E-04_JPRB,6.7076E-04_JPRB,9.4607E-03_JPRB/)
KAO( :, 2,12, 5) = (/&
&7.5728E-04_JPRB,1.2785E-03_JPRB,1.3875E-03_JPRB,1.4113E-03_JPRB,1.3782E-03_JPRB,1.2986E-03_JPRB,&
&1.1731E-03_JPRB,1.0074E-03_JPRB,7.2589E-04_JPRB,1.0331E-02_JPRB/)
KAO( :, 3,12, 5) = (/&
&1.0261E-03_JPRB,1.6921E-03_JPRB,1.8295E-03_JPRB,1.8570E-03_JPRB,1.8051E-03_JPRB,1.6888E-03_JPRB,&
&1.5086E-03_JPRB,1.2626E-03_JPRB,8.4339E-04_JPRB,1.1368E-02_JPRB/)
KAO( :, 4,12, 5) = (/&
&1.3869E-03_JPRB,2.2095E-03_JPRB,2.3736E-03_JPRB,2.4008E-03_JPRB,2.3247E-03_JPRB,2.1615E-03_JPRB,&
&1.9167E-03_JPRB,1.5821E-03_JPRB,9.6809E-04_JPRB,1.2545E-02_JPRB/)
KAO( :, 5,12, 5) = (/&
&1.8434E-03_JPRB,2.8588E-03_JPRB,3.0424E-03_JPRB,3.0524E-03_JPRB,2.9442E-03_JPRB,2.7194E-03_JPRB,&
&2.4068E-03_JPRB,1.9656E-03_JPRB,1.2057E-03_JPRB,1.3846E-02_JPRB/)
KAO( :, 1,13, 5) = (/&
&4.7278E-04_JPRB,7.9552E-04_JPRB,8.6502E-04_JPRB,8.8337E-04_JPRB,8.6881E-04_JPRB,8.2802E-04_JPRB,&
&7.6164E-04_JPRB,6.7146E-04_JPRB,5.4706E-04_JPRB,7.8912E-03_JPRB/)
KAO( :, 2,13, 5) = (/&
&6.4178E-04_JPRB,1.0759E-03_JPRB,1.1686E-03_JPRB,1.1883E-03_JPRB,1.1601E-03_JPRB,1.0935E-03_JPRB,&
&9.8725E-04_JPRB,8.4294E-04_JPRB,6.0294E-04_JPRB,8.6805E-03_JPRB/)
KAO( :, 3,13, 5) = (/&
&8.7757E-04_JPRB,1.4325E-03_JPRB,1.5486E-03_JPRB,1.5698E-03_JPRB,1.5267E-03_JPRB,1.4283E-03_JPRB,&
&1.2744E-03_JPRB,1.0604E-03_JPRB,6.9497E-04_JPRB,9.6337E-03_JPRB/)
KAO( :, 4,13, 5) = (/&
&1.1912E-03_JPRB,1.8857E-03_JPRB,2.0225E-03_JPRB,2.0388E-03_JPRB,1.9725E-03_JPRB,1.8334E-03_JPRB,&
&1.6247E-03_JPRB,1.3326E-03_JPRB,8.0026E-04_JPRB,1.0694E-02_JPRB/)
KAO( :, 5,13, 5) = (/&
&1.5846E-03_JPRB,2.4545E-03_JPRB,2.6070E-03_JPRB,2.6093E-03_JPRB,2.5111E-03_JPRB,2.3151E-03_JPRB,&
&2.0441E-03_JPRB,1.6606E-03_JPRB,1.0091E-03_JPRB,1.1828E-02_JPRB/)
KAO( :, 1, 1, 6) = (/&
&2.7778E-02_JPRB,3.3405E-02_JPRB,3.5267E-02_JPRB,3.6006E-02_JPRB,3.5898E-02_JPRB,3.4553E-02_JPRB,&
&3.1100E-02_JPRB,2.5014E-02_JPRB,1.8094E-02_JPRB,1.6794E-02_JPRB/)
KAO( :, 2, 1, 6) = (/&
&3.3366E-02_JPRB,4.0235E-02_JPRB,4.2608E-02_JPRB,4.3370E-02_JPRB,4.2914E-02_JPRB,4.1247E-02_JPRB,&
&3.7064E-02_JPRB,2.9946E-02_JPRB,2.1940E-02_JPRB,2.0091E-02_JPRB/)
KAO( :, 3, 1, 6) = (/&
&3.9476E-02_JPRB,4.7919E-02_JPRB,5.0670E-02_JPRB,5.1321E-02_JPRB,5.0664E-02_JPRB,4.8610E-02_JPRB,&
&4.3793E-02_JPRB,3.5486E-02_JPRB,2.6228E-02_JPRB,2.3816E-02_JPRB/)
KAO( :, 4, 1, 6) = (/&
&4.6165E-02_JPRB,5.6406E-02_JPRB,5.9353E-02_JPRB,6.0117E-02_JPRB,5.9468E-02_JPRB,5.6918E-02_JPRB,&
&5.1329E-02_JPRB,4.1643E-02_JPRB,3.1155E-02_JPRB,2.8224E-02_JPRB/)
KAO( :, 5, 1, 6) = (/&
&5.3590E-02_JPRB,6.5676E-02_JPRB,6.8956E-02_JPRB,6.9882E-02_JPRB,6.9299E-02_JPRB,6.6139E-02_JPRB,&
&5.9733E-02_JPRB,4.8638E-02_JPRB,3.6701E-02_JPRB,3.3219E-02_JPRB/)
KAO( :, 1, 2, 6) = (/&
&2.2559E-02_JPRB,2.7654E-02_JPRB,2.9015E-02_JPRB,2.9337E-02_JPRB,2.9078E-02_JPRB,2.7937E-02_JPRB,&
&2.5189E-02_JPRB,2.0404E-02_JPRB,1.4144E-02_JPRB,1.2909E-02_JPRB/)
KAO( :, 2, 2, 6) = (/&
&2.7361E-02_JPRB,3.3523E-02_JPRB,3.5340E-02_JPRB,3.5540E-02_JPRB,3.5037E-02_JPRB,3.3575E-02_JPRB,&
&3.0234E-02_JPRB,2.4558E-02_JPRB,1.7358E-02_JPRB,1.5458E-02_JPRB/)
KAO( :, 3, 2, 6) = (/&
&3.2702E-02_JPRB,4.0222E-02_JPRB,4.2266E-02_JPRB,4.2370E-02_JPRB,4.1690E-02_JPRB,3.9887E-02_JPRB,&
&3.5945E-02_JPRB,2.9242E-02_JPRB,2.0872E-02_JPRB,1.8389E-02_JPRB/)
KAO( :, 4, 2, 6) = (/&
&3.8698E-02_JPRB,4.7703E-02_JPRB,4.9874E-02_JPRB,5.0037E-02_JPRB,4.9234E-02_JPRB,4.7000E-02_JPRB,&
&4.2355E-02_JPRB,3.4462E-02_JPRB,2.4936E-02_JPRB,2.1874E-02_JPRB/)
KAO( :, 5, 2, 6) = (/&
&4.5406E-02_JPRB,5.5864E-02_JPRB,5.8250E-02_JPRB,5.8611E-02_JPRB,5.7701E-02_JPRB,5.4940E-02_JPRB,&
&4.9541E-02_JPRB,4.0425E-02_JPRB,2.9498E-02_JPRB,2.5824E-02_JPRB/)
KAO( :, 1, 3, 6) = (/&
&1.7492E-02_JPRB,2.1787E-02_JPRB,2.2652E-02_JPRB,2.2750E-02_JPRB,2.2453E-02_JPRB,2.1534E-02_JPRB,&
&1.9495E-02_JPRB,1.5819E-02_JPRB,1.0602E-02_JPRB,9.5365E-03_JPRB/)
KAO( :, 2, 3, 6) = (/&
&2.1519E-02_JPRB,2.6731E-02_JPRB,2.7902E-02_JPRB,2.7864E-02_JPRB,2.7355E-02_JPRB,2.6151E-02_JPRB,&
&2.3624E-02_JPRB,1.9184E-02_JPRB,1.3144E-02_JPRB,1.1427E-02_JPRB/)
KAO( :, 3, 3, 6) = (/&
&2.6104E-02_JPRB,3.2391E-02_JPRB,3.3736E-02_JPRB,3.3545E-02_JPRB,3.2846E-02_JPRB,3.1374E-02_JPRB,&
&2.8297E-02_JPRB,2.2996E-02_JPRB,1.5964E-02_JPRB,1.3632E-02_JPRB/)
KAO( :, 4, 3, 6) = (/&
&3.1327E-02_JPRB,3.8767E-02_JPRB,4.0227E-02_JPRB,3.9993E-02_JPRB,3.9114E-02_JPRB,3.7263E-02_JPRB,&
&3.3562E-02_JPRB,2.7293E-02_JPRB,1.9234E-02_JPRB,1.6283E-02_JPRB/)
KAO( :, 5, 3, 6) = (/&
&3.7182E-02_JPRB,4.5791E-02_JPRB,4.7452E-02_JPRB,4.7270E-02_JPRB,4.6211E-02_JPRB,4.3900E-02_JPRB,&
&3.9502E-02_JPRB,3.2188E-02_JPRB,2.2900E-02_JPRB,1.9326E-02_JPRB/)
KAO( :, 1, 4, 6) = (/&
&1.3291E-02_JPRB,1.6678E-02_JPRB,1.7275E-02_JPRB,1.7278E-02_JPRB,1.6993E-02_JPRB,1.6286E-02_JPRB,&
&1.4822E-02_JPRB,1.1990E-02_JPRB,7.7579E-03_JPRB,7.1488E-03_JPRB/)
KAO( :, 2, 4, 6) = (/&
&1.6630E-02_JPRB,2.0815E-02_JPRB,2.1568E-02_JPRB,2.1440E-02_JPRB,2.0973E-02_JPRB,2.0006E-02_JPRB,&
&1.8126E-02_JPRB,1.4654E-02_JPRB,9.8329E-03_JPRB,8.5205E-03_JPRB/)
KAO( :, 3, 4, 6) = (/&
&2.0444E-02_JPRB,2.5553E-02_JPRB,2.6397E-02_JPRB,2.6132E-02_JPRB,2.5471E-02_JPRB,2.4223E-02_JPRB,&
&2.1910E-02_JPRB,1.7722E-02_JPRB,1.2155E-02_JPRB,1.0148E-02_JPRB/)
KAO( :, 4, 4, 6) = (/&
&2.4887E-02_JPRB,3.0959E-02_JPRB,3.1847E-02_JPRB,3.1469E-02_JPRB,3.0641E-02_JPRB,2.9051E-02_JPRB,&
&2.6190E-02_JPRB,2.1212E-02_JPRB,1.4767E-02_JPRB,1.2110E-02_JPRB/)
KAO( :, 5, 4, 6) = (/&
&2.9912E-02_JPRB,3.7010E-02_JPRB,3.8031E-02_JPRB,3.7546E-02_JPRB,3.6509E-02_JPRB,3.4523E-02_JPRB,&
&3.1009E-02_JPRB,2.5164E-02_JPRB,1.7705E-02_JPRB,1.4427E-02_JPRB/)
KAO( :, 1, 5, 6) = (/&
&1.0066E-02_JPRB,1.2668E-02_JPRB,1.3071E-02_JPRB,1.3029E-02_JPRB,1.2765E-02_JPRB,1.2217E-02_JPRB,&
&1.1148E-02_JPRB,9.0021E-03_JPRB,5.7587E-03_JPRB,5.4209E-03_JPRB/)
KAO( :, 2, 5, 6) = (/&
&1.2757E-02_JPRB,1.6015E-02_JPRB,1.6544E-02_JPRB,1.6397E-02_JPRB,1.5990E-02_JPRB,1.5234E-02_JPRB,&
&1.3789E-02_JPRB,1.1105E-02_JPRB,7.3967E-03_JPRB,6.5046E-03_JPRB/)
KAO( :, 3, 5, 6) = (/&
&1.5901E-02_JPRB,1.9963E-02_JPRB,2.0508E-02_JPRB,2.0254E-02_JPRB,1.9682E-02_JPRB,1.8644E-02_JPRB,&
&1.6821E-02_JPRB,1.3552E-02_JPRB,9.2356E-03_JPRB,7.7811E-03_JPRB/)
KAO( :, 4, 5, 6) = (/&
&1.9596E-02_JPRB,2.4499E-02_JPRB,2.5082E-02_JPRB,2.4696E-02_JPRB,2.3936E-02_JPRB,2.2580E-02_JPRB,&
&2.0269E-02_JPRB,1.6344E-02_JPRB,1.1321E-02_JPRB,9.3163E-03_JPRB/)
KAO( :, 5, 5, 6) = (/&
&2.3830E-02_JPRB,2.9650E-02_JPRB,3.0334E-02_JPRB,2.9811E-02_JPRB,2.8792E-02_JPRB,2.7070E-02_JPRB,&
&2.4166E-02_JPRB,1.9536E-02_JPRB,1.3665E-02_JPRB,1.1111E-02_JPRB/)
KAO( :, 1, 6, 6) = (/&
&7.6087E-03_JPRB,9.4951E-03_JPRB,9.7649E-03_JPRB,9.6943E-03_JPRB,9.4691E-03_JPRB,9.0311E-03_JPRB,&
&8.2249E-03_JPRB,6.6528E-03_JPRB,4.3378E-03_JPRB,4.2627E-03_JPRB/)
KAO( :, 2, 6, 6) = (/&
&9.7029E-03_JPRB,1.2146E-02_JPRB,1.2495E-02_JPRB,1.2394E-02_JPRB,1.2047E-02_JPRB,1.1438E-02_JPRB,&
&1.0329E-02_JPRB,8.2946E-03_JPRB,5.4267E-03_JPRB,5.0549E-03_JPRB/)
KAO( :, 3, 6, 6) = (/&
&1.2241E-02_JPRB,1.5353E-02_JPRB,1.5729E-02_JPRB,1.5534E-02_JPRB,1.5039E-02_JPRB,1.4188E-02_JPRB,&
&1.2727E-02_JPRB,1.0218E-02_JPRB,6.8803E-03_JPRB,6.0223E-03_JPRB/)
KAO( :, 4, 6, 6) = (/&
&1.5222E-02_JPRB,1.9088E-02_JPRB,1.9504E-02_JPRB,1.9213E-02_JPRB,1.8550E-02_JPRB,1.7379E-02_JPRB,&
&1.5483E-02_JPRB,1.2434E-02_JPRB,8.5170E-03_JPRB,7.2084E-03_JPRB/)
KAO( :, 5, 6, 6) = (/&
&1.8677E-02_JPRB,2.3384E-02_JPRB,2.3892E-02_JPRB,2.3510E-02_JPRB,2.2581E-02_JPRB,2.1034E-02_JPRB,&
&1.8630E-02_JPRB,1.4980E-02_JPRB,1.0415E-02_JPRB,8.6059E-03_JPRB/)
KAO( :, 1, 7, 6) = (/&
&5.7827E-03_JPRB,7.1313E-03_JPRB,7.2802E-03_JPRB,7.2045E-03_JPRB,6.9954E-03_JPRB,6.6269E-03_JPRB,&
&6.0097E-03_JPRB,4.8731E-03_JPRB,3.1264E-03_JPRB,3.7137E-03_JPRB/)
KAO( :, 2, 7, 6) = (/&
&7.4084E-03_JPRB,9.1887E-03_JPRB,9.4000E-03_JPRB,9.3096E-03_JPRB,9.0304E-03_JPRB,8.5190E-03_JPRB,&
&7.6733E-03_JPRB,6.1525E-03_JPRB,3.9263E-03_JPRB,4.3944E-03_JPRB/)
KAO( :, 3, 7, 6) = (/&
&9.4040E-03_JPRB,1.1717E-02_JPRB,1.1976E-02_JPRB,1.1835E-02_JPRB,1.1434E-02_JPRB,1.0726E-02_JPRB,&
&9.5804E-03_JPRB,7.6627E-03_JPRB,5.0656E-03_JPRB,5.1961E-03_JPRB/)
KAO( :, 4, 7, 6) = (/&
&1.1772E-02_JPRB,1.4730E-02_JPRB,1.5048E-02_JPRB,1.4854E-02_JPRB,1.4302E-02_JPRB,1.3320E-02_JPRB,&
&1.1779E-02_JPRB,9.4074E-03_JPRB,6.3725E-03_JPRB,6.1249E-03_JPRB/)
KAO( :, 5, 7, 6) = (/&
&1.4533E-02_JPRB,1.8234E-02_JPRB,1.8652E-02_JPRB,1.8417E-02_JPRB,1.7654E-02_JPRB,1.6319E-02_JPRB,&
&1.4317E-02_JPRB,1.1422E-02_JPRB,7.8881E-03_JPRB,7.1931E-03_JPRB/)
KAO( :, 1, 8, 6) = (/&
&4.3473E-03_JPRB,5.3530E-03_JPRB,5.4453E-03_JPRB,5.3772E-03_JPRB,5.1866E-03_JPRB,4.8647E-03_JPRB,&
&4.3808E-03_JPRB,3.5559E-03_JPRB,2.4173E-03_JPRB,3.5108E-03_JPRB/)
KAO( :, 2, 8, 6) = (/&
&5.6534E-03_JPRB,6.9608E-03_JPRB,7.0942E-03_JPRB,6.9933E-03_JPRB,6.7489E-03_JPRB,6.3330E-03_JPRB,&
&5.6745E-03_JPRB,4.5520E-03_JPRB,2.9081E-03_JPRB,4.1180E-03_JPRB/)
KAO( :, 3, 8, 6) = (/&
&7.2231E-03_JPRB,8.9492E-03_JPRB,9.1155E-03_JPRB,8.9772E-03_JPRB,8.6519E-03_JPRB,8.0865E-03_JPRB,&
&7.1842E-03_JPRB,5.7298E-03_JPRB,3.7126E-03_JPRB,4.8510E-03_JPRB/)
KAO( :, 4, 8, 6) = (/&
&9.0980E-03_JPRB,1.1325E-02_JPRB,1.1554E-02_JPRB,1.1402E-02_JPRB,1.0960E-02_JPRB,1.0182E-02_JPRB,&
&8.9521E-03_JPRB,7.1103E-03_JPRB,4.7399E-03_JPRB,5.6880E-03_JPRB/)
KAO( :, 5, 8, 6) = (/&
&1.1302E-02_JPRB,1.4121E-02_JPRB,1.4457E-02_JPRB,1.4302E-02_JPRB,1.3709E-02_JPRB,1.2644E-02_JPRB,&
&1.1007E-02_JPRB,8.6993E-03_JPRB,5.9281E-03_JPRB,6.6436E-03_JPRB/)
KAO( :, 1, 9, 6) = (/&
&3.2166E-03_JPRB,3.9635E-03_JPRB,4.0421E-03_JPRB,3.9936E-03_JPRB,3.8441E-03_JPRB,3.5923E-03_JPRB,&
&3.2097E-03_JPRB,2.5886E-03_JPRB,1.7693E-03_JPRB,5.0615E-03_JPRB/)
KAO( :, 2, 9, 6) = (/&
&4.2551E-03_JPRB,5.2496E-03_JPRB,5.3431E-03_JPRB,5.2633E-03_JPRB,5.0543E-03_JPRB,4.7090E-03_JPRB,&
&4.1979E-03_JPRB,3.3556E-03_JPRB,2.0811E-03_JPRB,5.7517E-03_JPRB/)
KAO( :, 3, 9, 6) = (/&
&5.5178E-03_JPRB,6.8310E-03_JPRB,6.9481E-03_JPRB,6.8181E-03_JPRB,6.5340E-03_JPRB,6.0733E-03_JPRB,&
&5.3775E-03_JPRB,4.2779E-03_JPRB,2.6744E-03_JPRB,6.5436E-03_JPRB/)
KAO( :, 4, 9, 6) = (/&
&7.0233E-03_JPRB,8.7120E-03_JPRB,8.8693E-03_JPRB,8.7209E-03_JPRB,8.3514E-03_JPRB,7.7376E-03_JPRB,&
&6.7992E-03_JPRB,5.3653E-03_JPRB,3.4836E-03_JPRB,7.4458E-03_JPRB/)
KAO( :, 5, 9, 6) = (/&
&8.7908E-03_JPRB,1.0935E-02_JPRB,1.1156E-02_JPRB,1.1011E-02_JPRB,1.0551E-02_JPRB,9.7377E-03_JPRB,&
&8.4643E-03_JPRB,6.6157E-03_JPRB,4.4105E-03_JPRB,8.4131E-03_JPRB/)
KAO( :, 1,10, 6) = (/&
&2.4036E-03_JPRB,2.9626E-03_JPRB,3.0270E-03_JPRB,2.9891E-03_JPRB,2.8783E-03_JPRB,2.6966E-03_JPRB,&
&2.4167E-03_JPRB,1.9384E-03_JPRB,1.2950E-03_JPRB,1.2580E-02_JPRB/)
KAO( :, 2,10, 6) = (/&
&3.2304E-03_JPRB,3.9936E-03_JPRB,4.0696E-03_JPRB,4.0063E-03_JPRB,3.8441E-03_JPRB,3.5817E-03_JPRB,&
&3.1841E-03_JPRB,2.5258E-03_JPRB,1.6318E-03_JPRB,1.3867E-02_JPRB/)
KAO( :, 3,10, 6) = (/&
&4.2450E-03_JPRB,5.2713E-03_JPRB,5.3717E-03_JPRB,5.2683E-03_JPRB,5.0339E-03_JPRB,4.6625E-03_JPRB,&
&4.1091E-03_JPRB,3.2509E-03_JPRB,2.0065E-03_JPRB,1.5204E-02_JPRB/)
KAO( :, 4,10, 6) = (/&
&5.4744E-03_JPRB,6.8064E-03_JPRB,6.9238E-03_JPRB,6.7912E-03_JPRB,6.4905E-03_JPRB,5.9838E-03_JPRB,&
&5.2439E-03_JPRB,4.1188E-03_JPRB,2.6002E-03_JPRB,1.6652E-02_JPRB/)
KAO( :, 5,10, 6) = (/&
&6.9353E-03_JPRB,8.6079E-03_JPRB,8.7635E-03_JPRB,8.6181E-03_JPRB,8.2349E-03_JPRB,7.5886E-03_JPRB,&
&6.5994E-03_JPRB,5.1192E-03_JPRB,3.3239E-03_JPRB,1.8251E-02_JPRB/)
KAO( :, 1,11, 6) = (/&
&2.0648E-03_JPRB,2.5481E-03_JPRB,2.6000E-03_JPRB,2.5607E-03_JPRB,2.4630E-03_JPRB,2.3069E-03_JPRB,&
&2.0692E-03_JPRB,1.6562E-03_JPRB,1.0860E-03_JPRB,1.7049E-02_JPRB/)
KAO( :, 2,11, 6) = (/&
&2.7859E-03_JPRB,3.4547E-03_JPRB,3.5237E-03_JPRB,3.4594E-03_JPRB,3.3142E-03_JPRB,3.0841E-03_JPRB,&
&2.7345E-03_JPRB,2.1584E-03_JPRB,1.3341E-03_JPRB,1.8747E-02_JPRB/)
KAO( :, 3,11, 6) = (/&
&3.6773E-03_JPRB,4.5764E-03_JPRB,4.6633E-03_JPRB,4.5751E-03_JPRB,4.3721E-03_JPRB,4.0405E-03_JPRB,&
&3.5419E-03_JPRB,2.7771E-03_JPRB,1.6730E-03_JPRB,2.0460E-02_JPRB/)
KAO( :, 4,11, 6) = (/&
&4.7645E-03_JPRB,5.9262E-03_JPRB,6.0301E-03_JPRB,5.9104E-03_JPRB,5.6462E-03_JPRB,5.2017E-03_JPRB,&
&4.5306E-03_JPRB,3.5163E-03_JPRB,2.1775E-03_JPRB,2.2225E-02_JPRB/)
KAO( :, 5,11, 6) = (/&
&6.0673E-03_JPRB,7.5194E-03_JPRB,7.6592E-03_JPRB,7.5146E-03_JPRB,7.1608E-03_JPRB,6.5750E-03_JPRB,&
&5.6954E-03_JPRB,4.3877E-03_JPRB,2.7878E-03_JPRB,2.4112E-02_JPRB/)
KAO( :, 1,12, 6) = (/&
&1.7649E-03_JPRB,2.1840E-03_JPRB,2.2273E-03_JPRB,2.1894E-03_JPRB,2.1029E-03_JPRB,1.9647E-03_JPRB,&
&1.7570E-03_JPRB,1.4092E-03_JPRB,9.0612E-04_JPRB,1.8116E-02_JPRB/)
KAO( :, 2,12, 6) = (/&
&2.3911E-03_JPRB,2.9721E-03_JPRB,3.0306E-03_JPRB,2.9776E-03_JPRB,2.8514E-03_JPRB,2.6450E-03_JPRB,&
&2.3351E-03_JPRB,1.8424E-03_JPRB,1.0968E-03_JPRB,1.9929E-02_JPRB/)
KAO( :, 3,12, 6) = (/&
&3.1732E-03_JPRB,3.9503E-03_JPRB,4.0215E-03_JPRB,3.9440E-03_JPRB,3.7721E-03_JPRB,3.4863E-03_JPRB,&
&3.0465E-03_JPRB,2.3738E-03_JPRB,1.3931E-03_JPRB,2.1707E-02_JPRB/)
KAO( :, 4,12, 6) = (/&
&4.1329E-03_JPRB,5.1374E-03_JPRB,5.2226E-03_JPRB,5.1161E-03_JPRB,4.8827E-03_JPRB,4.4950E-03_JPRB,&
&3.9019E-03_JPRB,3.0106E-03_JPRB,1.8199E-03_JPRB,2.3542E-02_JPRB/)
KAO( :, 5,12, 6) = (/&
&5.2972E-03_JPRB,6.5406E-03_JPRB,6.6636E-03_JPRB,6.5319E-03_JPRB,6.2060E-03_JPRB,5.6779E-03_JPRB,&
&4.9006E-03_JPRB,3.7653E-03_JPRB,2.3340E-03_JPRB,2.5478E-02_JPRB/)
KAO( :, 1,13, 6) = (/&
&1.4917E-03_JPRB,1.8531E-03_JPRB,1.8920E-03_JPRB,1.8620E-03_JPRB,1.7861E-03_JPRB,1.6617E-03_JPRB,&
&1.4788E-03_JPRB,1.1873E-03_JPRB,7.5550E-04_JPRB,1.5444E-02_JPRB/)
KAO( :, 2,13, 6) = (/&
&2.0333E-03_JPRB,2.5348E-03_JPRB,2.5838E-03_JPRB,2.5408E-03_JPRB,2.4328E-03_JPRB,2.2514E-03_JPRB,&
&1.9783E-03_JPRB,1.5611E-03_JPRB,9.0187E-04_JPRB,1.7015E-02_JPRB/)
KAO( :, 3,13, 6) = (/&
&2.7153E-03_JPRB,3.3873E-03_JPRB,3.4439E-03_JPRB,3.3763E-03_JPRB,3.2264E-03_JPRB,2.9750E-03_JPRB,&
&2.5932E-03_JPRB,2.0239E-03_JPRB,1.1597E-03_JPRB,1.8564E-02_JPRB/)
KAO( :, 4,13, 6) = (/&
&3.5625E-03_JPRB,4.4244E-03_JPRB,4.4971E-03_JPRB,4.4025E-03_JPRB,4.1909E-03_JPRB,3.8436E-03_JPRB,&
&3.3277E-03_JPRB,2.5719E-03_JPRB,1.5159E-03_JPRB,2.0176E-02_JPRB/)
KAO( :, 5,13, 6) = (/&
&4.5915E-03_JPRB,5.6599E-03_JPRB,5.7629E-03_JPRB,5.6406E-03_JPRB,5.3423E-03_JPRB,4.8700E-03_JPRB,&
&4.1907E-03_JPRB,3.2171E-03_JPRB,1.9497E-03_JPRB,2.1913E-02_JPRB/)
KAO( :, 1, 1, 7) = (/&
&6.4013E-02_JPRB,7.3559E-02_JPRB,7.8016E-02_JPRB,7.8110E-02_JPRB,7.4963E-02_JPRB,6.8933E-02_JPRB,&
&6.0750E-02_JPRB,4.8875E-02_JPRB,3.9308E-02_JPRB,3.6560E-02_JPRB/)
KAO( :, 2, 1, 7) = (/&
&7.6363E-02_JPRB,8.7960E-02_JPRB,9.3559E-02_JPRB,9.3979E-02_JPRB,9.0734E-02_JPRB,8.3349E-02_JPRB,&
&7.3192E-02_JPRB,5.8774E-02_JPRB,4.7441E-02_JPRB,4.4036E-02_JPRB/)
KAO( :, 3, 1, 7) = (/&
&8.9758E-02_JPRB,1.0331E-01_JPRB,1.1051E-01_JPRB,1.1169E-01_JPRB,1.0769E-01_JPRB,9.8679E-02_JPRB,&
&8.6726E-02_JPRB,6.9819E-02_JPRB,5.6655E-02_JPRB,5.2675E-02_JPRB/)
KAO( :, 4, 1, 7) = (/&
&1.0433E-01_JPRB,1.2008E-01_JPRB,1.2928E-01_JPRB,1.3105E-01_JPRB,1.2576E-01_JPRB,1.1544E-01_JPRB,&
&1.0166E-01_JPRB,8.2241E-02_JPRB,6.7142E-02_JPRB,6.2520E-02_JPRB/)
KAO( :, 5, 1, 7) = (/&
&1.2001E-01_JPRB,1.3824E-01_JPRB,1.4932E-01_JPRB,1.5158E-01_JPRB,1.4526E-01_JPRB,1.3374E-01_JPRB,&
&1.1804E-01_JPRB,9.5951E-02_JPRB,7.9016E-02_JPRB,7.3734E-02_JPRB/)
KAO( :, 1, 2, 7) = (/&
&5.2968E-02_JPRB,6.2116E-02_JPRB,6.5835E-02_JPRB,6.6044E-02_JPRB,6.3294E-02_JPRB,5.8161E-02_JPRB,&
&5.1176E-02_JPRB,4.1393E-02_JPRB,3.1133E-02_JPRB,2.8255E-02_JPRB/)
KAO( :, 2, 2, 7) = (/&
&6.3728E-02_JPRB,7.4899E-02_JPRB,7.9536E-02_JPRB,8.0057E-02_JPRB,7.7101E-02_JPRB,7.0839E-02_JPRB,&
&6.2175E-02_JPRB,5.0108E-02_JPRB,3.7798E-02_JPRB,3.4182E-02_JPRB/)
KAO( :, 3, 2, 7) = (/&
&7.5532E-02_JPRB,8.8572E-02_JPRB,9.4648E-02_JPRB,9.5700E-02_JPRB,9.1973E-02_JPRB,8.4443E-02_JPRB,&
&7.4085E-02_JPRB,5.9918E-02_JPRB,4.5429E-02_JPRB,4.1069E-02_JPRB/)
KAO( :, 4, 2, 7) = (/&
&8.8404E-02_JPRB,1.0356E-01_JPRB,1.1124E-01_JPRB,1.1259E-01_JPRB,1.0798E-01_JPRB,9.9246E-02_JPRB,&
&8.7373E-02_JPRB,7.0993E-02_JPRB,5.4110E-02_JPRB,4.8926E-02_JPRB/)
KAO( :, 5, 2, 7) = (/&
&1.0235E-01_JPRB,1.2010E-01_JPRB,1.2926E-01_JPRB,1.3064E-01_JPRB,1.2537E-01_JPRB,1.1556E-01_JPRB,&
&1.0208E-01_JPRB,8.3206E-02_JPRB,6.4030E-02_JPRB,5.7947E-02_JPRB/)
KAO( :, 1, 3, 7) = (/&
&4.1735E-02_JPRB,4.9803E-02_JPRB,5.2741E-02_JPRB,5.2657E-02_JPRB,5.0249E-02_JPRB,4.6113E-02_JPRB,&
&4.0588E-02_JPRB,3.2986E-02_JPRB,2.3522E-02_JPRB,2.0886E-02_JPRB/)
KAO( :, 2, 3, 7) = (/&
&5.0841E-02_JPRB,6.0757E-02_JPRB,6.4389E-02_JPRB,6.4564E-02_JPRB,6.1844E-02_JPRB,5.6795E-02_JPRB,&
&4.9854E-02_JPRB,4.0407E-02_JPRB,2.8855E-02_JPRB,2.5442E-02_JPRB/)
KAO( :, 3, 3, 7) = (/&
&6.0889E-02_JPRB,7.2603E-02_JPRB,7.7334E-02_JPRB,7.7876E-02_JPRB,7.4574E-02_JPRB,6.8388E-02_JPRB,&
&6.0037E-02_JPRB,4.8827E-02_JPRB,3.5004E-02_JPRB,3.0751E-02_JPRB/)
KAO( :, 4, 3, 7) = (/&
&7.1992E-02_JPRB,8.5675E-02_JPRB,9.1634E-02_JPRB,9.2233E-02_JPRB,8.8356E-02_JPRB,8.1063E-02_JPRB,&
&7.1397E-02_JPRB,5.8371E-02_JPRB,4.1972E-02_JPRB,3.6821E-02_JPRB/)
KAO( :, 5, 3, 7) = (/&
&8.4144E-02_JPRB,1.0019E-01_JPRB,1.0713E-01_JPRB,1.0774E-01_JPRB,1.0345E-01_JPRB,9.5140E-02_JPRB,&
&8.4076E-02_JPRB,6.8896E-02_JPRB,4.9944E-02_JPRB,4.3832E-02_JPRB/)
KAO( :, 1, 4, 7) = (/&
&3.2154E-02_JPRB,3.8970E-02_JPRB,4.1150E-02_JPRB,4.0802E-02_JPRB,3.8734E-02_JPRB,3.5463E-02_JPRB,&
&3.1189E-02_JPRB,2.5441E-02_JPRB,1.7426E-02_JPRB,1.5348E-02_JPRB/)
KAO( :, 2, 4, 7) = (/&
&3.9739E-02_JPRB,4.8115E-02_JPRB,5.0846E-02_JPRB,5.0567E-02_JPRB,4.8188E-02_JPRB,4.4146E-02_JPRB,&
&3.8765E-02_JPRB,3.1629E-02_JPRB,2.1722E-02_JPRB,1.8824E-02_JPRB/)
KAO( :, 3, 4, 7) = (/&
&4.8232E-02_JPRB,5.8202E-02_JPRB,6.1786E-02_JPRB,6.1691E-02_JPRB,5.8769E-02_JPRB,5.3800E-02_JPRB,&
&4.7237E-02_JPRB,3.8627E-02_JPRB,2.6596E-02_JPRB,2.2906E-02_JPRB/)
KAO( :, 4, 4, 7) = (/&
&5.7693E-02_JPRB,6.9403E-02_JPRB,7.3912E-02_JPRB,7.3801E-02_JPRB,7.0370E-02_JPRB,6.4487E-02_JPRB,&
&5.6733E-02_JPRB,4.6604E-02_JPRB,3.2157E-02_JPRB,2.7582E-02_JPRB/)
KAO( :, 5, 4, 7) = (/&
&6.8162E-02_JPRB,8.1910E-02_JPRB,8.6943E-02_JPRB,8.6947E-02_JPRB,8.3116E-02_JPRB,7.6355E-02_JPRB,&
&6.7389E-02_JPRB,5.5474E-02_JPRB,3.8506E-02_JPRB,3.2984E-02_JPRB/)
KAO( :, 1, 5, 7) = (/&
&2.4543E-02_JPRB,3.0114E-02_JPRB,3.1564E-02_JPRB,3.1114E-02_JPRB,2.9453E-02_JPRB,2.6887E-02_JPRB,&
&2.3575E-02_JPRB,1.9323E-02_JPRB,1.2795E-02_JPRB,1.1691E-02_JPRB/)
KAO( :, 2, 5, 7) = (/&
&3.0843E-02_JPRB,3.7719E-02_JPRB,3.9540E-02_JPRB,3.9065E-02_JPRB,3.7079E-02_JPRB,3.3845E-02_JPRB,&
&2.9679E-02_JPRB,2.4367E-02_JPRB,1.6282E-02_JPRB,1.4283E-02_JPRB/)
KAO( :, 3, 5, 7) = (/&
&3.7989E-02_JPRB,4.6141E-02_JPRB,4.8601E-02_JPRB,4.8164E-02_JPRB,4.5691E-02_JPRB,4.1697E-02_JPRB,&
&3.6599E-02_JPRB,3.0110E-02_JPRB,2.0230E-02_JPRB,1.7316E-02_JPRB/)
KAO( :, 4, 5, 7) = (/&
&4.5997E-02_JPRB,5.5639E-02_JPRB,5.8738E-02_JPRB,5.8217E-02_JPRB,5.5293E-02_JPRB,5.0551E-02_JPRB,&
&4.4474E-02_JPRB,3.6675E-02_JPRB,2.4679E-02_JPRB,2.0824E-02_JPRB/)
KAO( :, 5, 5, 7) = (/&
&5.4980E-02_JPRB,6.6335E-02_JPRB,6.9689E-02_JPRB,6.9220E-02_JPRB,6.5934E-02_JPRB,6.0477E-02_JPRB,&
&5.3356E-02_JPRB,4.4023E-02_JPRB,2.9735E-02_JPRB,2.4925E-02_JPRB/)
KAO( :, 1, 6, 7) = (/&
&1.8426E-02_JPRB,2.2761E-02_JPRB,2.3641E-02_JPRB,2.3226E-02_JPRB,2.1929E-02_JPRB,1.9968E-02_JPRB,&
&1.7467E-02_JPRB,1.4347E-02_JPRB,9.1807E-03_JPRB,8.8441E-03_JPRB/)
KAO( :, 2, 6, 7) = (/&
&2.3578E-02_JPRB,2.9032E-02_JPRB,3.0133E-02_JPRB,2.9606E-02_JPRB,2.7996E-02_JPRB,2.5495E-02_JPRB,&
&2.2298E-02_JPRB,1.8363E-02_JPRB,1.2129E-02_JPRB,1.0950E-02_JPRB/)
KAO( :, 3, 6, 7) = (/&
&2.9507E-02_JPRB,3.6047E-02_JPRB,3.7508E-02_JPRB,3.6913E-02_JPRB,3.4886E-02_JPRB,3.1786E-02_JPRB,&
&2.7844E-02_JPRB,2.2965E-02_JPRB,1.5292E-02_JPRB,1.3409E-02_JPRB/)
KAO( :, 4, 6, 7) = (/&
&3.6266E-02_JPRB,4.4015E-02_JPRB,4.5865E-02_JPRB,4.5103E-02_JPRB,4.2675E-02_JPRB,3.8982E-02_JPRB,&
&3.4261E-02_JPRB,2.8279E-02_JPRB,1.8853E-02_JPRB,1.6214E-02_JPRB/)
KAO( :, 5, 6, 7) = (/&
&4.3984E-02_JPRB,5.3041E-02_JPRB,5.5017E-02_JPRB,5.4129E-02_JPRB,5.1429E-02_JPRB,4.7161E-02_JPRB,&
&4.1564E-02_JPRB,3.4270E-02_JPRB,2.2882E-02_JPRB,1.9446E-02_JPRB/)
KAO( :, 1, 7, 7) = (/&
&1.3764E-02_JPRB,1.6980E-02_JPRB,1.7488E-02_JPRB,1.7108E-02_JPRB,1.6106E-02_JPRB,1.4660E-02_JPRB,&
&1.2811E-02_JPRB,1.0508E-02_JPRB,6.5858E-03_JPRB,7.3979E-03_JPRB/)
KAO( :, 2, 7, 7) = (/&
&1.7905E-02_JPRB,2.2049E-02_JPRB,2.2708E-02_JPRB,2.2213E-02_JPRB,2.0912E-02_JPRB,1.9015E-02_JPRB,&
&1.6594E-02_JPRB,1.3616E-02_JPRB,8.9925E-03_JPRB,8.9127E-03_JPRB/)
KAO( :, 3, 7, 7) = (/&
&2.2781E-02_JPRB,2.7834E-02_JPRB,2.8707E-02_JPRB,2.8089E-02_JPRB,2.6436E-02_JPRB,2.4036E-02_JPRB,&
&2.1001E-02_JPRB,1.7243E-02_JPRB,1.1550E-02_JPRB,1.0727E-02_JPRB/)
KAO( :, 4, 7, 7) = (/&
&2.8466E-02_JPRB,3.4473E-02_JPRB,3.5499E-02_JPRB,3.4681E-02_JPRB,3.2695E-02_JPRB,2.9803E-02_JPRB,&
&2.6138E-02_JPRB,2.1504E-02_JPRB,1.4432E-02_JPRB,1.2888E-02_JPRB/)
KAO( :, 5, 7, 7) = (/&
&3.5087E-02_JPRB,4.2091E-02_JPRB,4.3096E-02_JPRB,4.2057E-02_JPRB,3.9781E-02_JPRB,3.6456E-02_JPRB,&
&3.2089E-02_JPRB,2.6356E-02_JPRB,1.7665E-02_JPRB,1.5419E-02_JPRB/)
KAO( :, 1, 8, 7) = (/&
&1.0353E-02_JPRB,1.2614E-02_JPRB,1.2882E-02_JPRB,1.2507E-02_JPRB,1.1737E-02_JPRB,1.0675E-02_JPRB,&
&9.3093E-03_JPRB,7.6257E-03_JPRB,4.6116E-03_JPRB,7.3615E-03_JPRB/)
KAO( :, 2, 8, 7) = (/&
&1.3587E-02_JPRB,1.6625E-02_JPRB,1.6988E-02_JPRB,1.6539E-02_JPRB,1.5521E-02_JPRB,1.4075E-02_JPRB,&
&1.2252E-02_JPRB,1.0008E-02_JPRB,6.5742E-03_JPRB,8.8183E-03_JPRB/)
KAO( :, 3, 8, 7) = (/&
&1.7551E-02_JPRB,2.1310E-02_JPRB,2.1821E-02_JPRB,2.1262E-02_JPRB,1.9937E-02_JPRB,1.8066E-02_JPRB,&
&1.5721E-02_JPRB,1.2839E-02_JPRB,8.6653E-03_JPRB,1.0458E-02_JPRB/)
KAO( :, 4, 8, 7) = (/&
&2.2265E-02_JPRB,2.6814E-02_JPRB,2.7357E-02_JPRB,2.6600E-02_JPRB,2.4976E-02_JPRB,2.2670E-02_JPRB,&
&1.9796E-02_JPRB,1.6193E-02_JPRB,1.0979E-02_JPRB,1.2332E-02_JPRB/)
KAO( :, 5, 8, 7) = (/&
&2.7862E-02_JPRB,3.3218E-02_JPRB,3.3662E-02_JPRB,3.2634E-02_JPRB,3.0703E-02_JPRB,2.8021E-02_JPRB,&
&2.4581E-02_JPRB,2.0102E-02_JPRB,1.3589E-02_JPRB,1.4413E-02_JPRB/)
KAO( :, 1, 9, 7) = (/&
&7.8781E-03_JPRB,9.4357E-03_JPRB,9.5082E-03_JPRB,9.1567E-03_JPRB,8.5455E-03_JPRB,7.7115E-03_JPRB,&
&6.6987E-03_JPRB,5.4668E-03_JPRB,3.2375E-03_JPRB,1.0690E-02_JPRB/)
KAO( :, 2, 9, 7) = (/&
&1.0378E-02_JPRB,1.2532E-02_JPRB,1.2692E-02_JPRB,1.2260E-02_JPRB,1.1450E-02_JPRB,1.0342E-02_JPRB,&
&8.9582E-03_JPRB,7.2956E-03_JPRB,4.7236E-03_JPRB,1.2330E-02_JPRB/)
KAO( :, 3, 9, 7) = (/&
&1.3495E-02_JPRB,1.6270E-02_JPRB,1.6516E-02_JPRB,1.6000E-02_JPRB,1.4955E-02_JPRB,1.3485E-02_JPRB,&
&1.1675E-02_JPRB,9.4744E-03_JPRB,6.3929E-03_JPRB,1.4160E-02_JPRB/)
KAO( :, 4, 9, 7) = (/&
&1.7315E-02_JPRB,2.0761E-02_JPRB,2.1026E-02_JPRB,2.0326E-02_JPRB,1.9009E-02_JPRB,1.7164E-02_JPRB,&
&1.4884E-02_JPRB,1.2091E-02_JPRB,8.2532E-03_JPRB,1.6229E-02_JPRB/)
KAO( :, 5, 9, 7) = (/&
&2.1950E-02_JPRB,2.6079E-02_JPRB,2.6242E-02_JPRB,2.5301E-02_JPRB,2.3645E-02_JPRB,2.1443E-02_JPRB,&
&1.8684E-02_JPRB,1.5203E-02_JPRB,1.0361E-02_JPRB,1.8623E-02_JPRB/)
KAO( :, 1,10, 7) = (/&
&6.0912E-03_JPRB,7.2618E-03_JPRB,7.2497E-03_JPRB,6.9368E-03_JPRB,6.4251E-03_JPRB,5.7381E-03_JPRB,&
&4.9224E-03_JPRB,3.9870E-03_JPRB,2.3279E-03_JPRB,2.4406E-02_JPRB/)
KAO( :, 2,10, 7) = (/&
&8.1237E-03_JPRB,9.7061E-03_JPRB,9.7375E-03_JPRB,9.3388E-03_JPRB,8.6591E-03_JPRB,7.7505E-03_JPRB,&
&6.6642E-03_JPRB,5.3997E-03_JPRB,3.3513E-03_JPRB,2.6559E-02_JPRB/)
KAO( :, 3,10, 7) = (/&
&1.0643E-02_JPRB,1.2680E-02_JPRB,1.2767E-02_JPRB,1.2292E-02_JPRB,1.1416E-02_JPRB,1.0235E-02_JPRB,&
&8.8042E-03_JPRB,7.1077E-03_JPRB,4.7423E-03_JPRB,2.9166E-02_JPRB/)
KAO( :, 4,10, 7) = (/&
&1.3745E-02_JPRB,1.6327E-02_JPRB,1.6432E-02_JPRB,1.5803E-02_JPRB,1.4680E-02_JPRB,1.3196E-02_JPRB,&
&1.1368E-02_JPRB,9.1591E-03_JPRB,6.2576E-03_JPRB,3.2140E-02_JPRB/)
KAO( :, 5,10, 7) = (/&
&1.7515E-02_JPRB,2.0726E-02_JPRB,2.0778E-02_JPRB,1.9936E-02_JPRB,1.8503E-02_JPRB,1.6679E-02_JPRB,&
&1.4419E-02_JPRB,1.1642E-02_JPRB,7.9656E-03_JPRB,3.5445E-02_JPRB/)
KAO( :, 1,11, 7) = (/&
&5.3549E-03_JPRB,6.3816E-03_JPRB,6.3660E-03_JPRB,6.0840E-03_JPRB,5.6156E-03_JPRB,4.9825E-03_JPRB,&
&4.2303E-03_JPRB,3.3795E-03_JPRB,1.9749E-03_JPRB,3.2367E-02_JPRB/)
KAO( :, 2,11, 7) = (/&
&7.2013E-03_JPRB,8.5604E-03_JPRB,8.5532E-03_JPRB,8.1763E-03_JPRB,7.5421E-03_JPRB,6.6997E-03_JPRB,&
&5.7065E-03_JPRB,4.5729E-03_JPRB,2.8632E-03_JPRB,3.5196E-02_JPRB/)
KAO( :, 3,11, 7) = (/&
&9.5022E-03_JPRB,1.1202E-02_JPRB,1.1204E-02_JPRB,1.0716E-02_JPRB,9.9000E-03_JPRB,8.8230E-03_JPRB,&
&7.5394E-03_JPRB,6.0331E-03_JPRB,4.0236E-03_JPRB,3.8638E-02_JPRB/)
KAO( :, 4,11, 7) = (/&
&1.2288E-02_JPRB,1.4432E-02_JPRB,1.4424E-02_JPRB,1.3791E-02_JPRB,1.2735E-02_JPRB,1.1387E-02_JPRB,&
&9.7608E-03_JPRB,7.8103E-03_JPRB,5.3234E-03_JPRB,4.2507E-02_JPRB/)
KAO( :, 5,11, 7) = (/&
&1.5567E-02_JPRB,1.8295E-02_JPRB,1.8261E-02_JPRB,1.7460E-02_JPRB,1.6145E-02_JPRB,1.4469E-02_JPRB,&
&1.2448E-02_JPRB,9.9477E-03_JPRB,6.7800E-03_JPRB,4.6703E-02_JPRB/)
KAO( :, 1,12, 7) = (/&
&4.6610E-03_JPRB,5.5454E-03_JPRB,5.5315E-03_JPRB,5.2838E-03_JPRB,4.8759E-03_JPRB,4.3254E-03_JPRB,&
&3.6583E-03_JPRB,2.8821E-03_JPRB,1.6681E-03_JPRB,3.4347E-02_JPRB/)
KAO( :, 2,12, 7) = (/&
&6.3285E-03_JPRB,7.4864E-03_JPRB,7.4682E-03_JPRB,7.1266E-03_JPRB,6.5590E-03_JPRB,5.8111E-03_JPRB,&
&4.9232E-03_JPRB,3.8901E-03_JPRB,2.4263E-03_JPRB,3.7723E-02_JPRB/)
KAO( :, 3,12, 7) = (/&
&8.4114E-03_JPRB,9.8725E-03_JPRB,9.8303E-03_JPRB,9.3562E-03_JPRB,8.6044E-03_JPRB,7.6370E-03_JPRB,&
&6.4946E-03_JPRB,5.1447E-03_JPRB,3.4144E-03_JPRB,4.1645E-02_JPRB/)
KAO( :, 4,12, 7) = (/&
&1.0877E-02_JPRB,1.2730E-02_JPRB,1.2662E-02_JPRB,1.2056E-02_JPRB,1.1093E-02_JPRB,9.8741E-03_JPRB,&
&8.4352E-03_JPRB,6.6865E-03_JPRB,4.5146E-03_JPRB,4.5836E-02_JPRB/)
KAO( :, 5,12, 7) = (/&
&1.3747E-02_JPRB,1.6074E-02_JPRB,1.5983E-02_JPRB,1.5257E-02_JPRB,1.4098E-02_JPRB,1.2612E-02_JPRB,&
&1.0799E-02_JPRB,8.5347E-03_JPRB,5.7461E-03_JPRB,5.0295E-02_JPRB/)
KAO( :, 1,13, 7) = (/&
&4.0079E-03_JPRB,4.7560E-03_JPRB,4.7417E-03_JPRB,4.5251E-03_JPRB,4.1763E-03_JPRB,3.7162E-03_JPRB,&
&3.1488E-03_JPRB,2.4610E-03_JPRB,1.3983E-03_JPRB,2.9797E-02_JPRB/)
KAO( :, 2,13, 7) = (/&
&5.4975E-03_JPRB,6.4791E-03_JPRB,6.4467E-03_JPRB,6.1399E-03_JPRB,5.6502E-03_JPRB,5.0140E-03_JPRB,&
&4.2451E-03_JPRB,3.3175E-03_JPRB,2.0465E-03_JPRB,3.3074E-02_JPRB/)
KAO( :, 3,13, 7) = (/&
&7.3173E-03_JPRB,8.5913E-03_JPRB,8.5377E-03_JPRB,8.1192E-03_JPRB,7.4539E-03_JPRB,6.6075E-03_JPRB,&
&5.6063E-03_JPRB,4.3940E-03_JPRB,2.8772E-03_JPRB,3.6709E-02_JPRB/)
KAO( :, 4,13, 7) = (/&
&9.4743E-03_JPRB,1.1090E-02_JPRB,1.1002E-02_JPRB,1.0468E-02_JPRB,9.6356E-03_JPRB,8.5792E-03_JPRB,&
&7.2993E-03_JPRB,5.7314E-03_JPRB,3.8025E-03_JPRB,4.0547E-02_JPRB/)
KAO( :, 5,13, 7) = (/&
&1.2013E-02_JPRB,1.3994E-02_JPRB,1.3879E-02_JPRB,1.3228E-02_JPRB,1.2234E-02_JPRB,1.0964E-02_JPRB,&
&9.3662E-03_JPRB,7.3363E-03_JPRB,4.8412E-03_JPRB,4.4593E-02_JPRB/)
KAO( :, 1, 1, 8) = (/&
&1.6043E-01_JPRB,1.5955E-01_JPRB,1.5744E-01_JPRB,1.5203E-01_JPRB,1.4391E-01_JPRB,1.3266E-01_JPRB,&
&1.1826E-01_JPRB,1.0647E-01_JPRB,1.0371E-01_JPRB,1.0144E-01_JPRB/)
KAO( :, 2, 1, 8) = (/&
&1.9219E-01_JPRB,1.9200E-01_JPRB,1.8944E-01_JPRB,1.8309E-01_JPRB,1.7324E-01_JPRB,1.6054E-01_JPRB,&
&1.4443E-01_JPRB,1.3095E-01_JPRB,1.2672E-01_JPRB,1.2410E-01_JPRB/)
KAO( :, 3, 1, 8) = (/&
&2.2629E-01_JPRB,2.2700E-01_JPRB,2.2424E-01_JPRB,2.1719E-01_JPRB,2.0625E-01_JPRB,1.9280E-01_JPRB,&
&1.7410E-01_JPRB,1.5851E-01_JPRB,1.5238E-01_JPRB,1.4924E-01_JPRB/)
KAO( :, 4, 1, 8) = (/&
&2.6302E-01_JPRB,2.6487E-01_JPRB,2.6214E-01_JPRB,2.5470E-01_JPRB,2.4371E-01_JPRB,2.2882E-01_JPRB,&
&2.0692E-01_JPRB,1.8914E-01_JPRB,1.8098E-01_JPRB,1.7748E-01_JPRB/)
KAO( :, 5, 1, 8) = (/&
&3.0195E-01_JPRB,3.0538E-01_JPRB,3.0299E-01_JPRB,2.9584E-01_JPRB,2.8471E-01_JPRB,2.6793E-01_JPRB,&
&2.4285E-01_JPRB,2.2301E-01_JPRB,2.1336E-01_JPRB,2.0952E-01_JPRB/)
KAO( :, 1, 2, 8) = (/&
&1.3846E-01_JPRB,1.4022E-01_JPRB,1.4003E-01_JPRB,1.3582E-01_JPRB,1.2900E-01_JPRB,1.1965E-01_JPRB,&
&1.0668E-01_JPRB,9.1059E-02_JPRB,8.5585E-02_JPRB,8.1636E-02_JPRB/)
KAO( :, 2, 2, 8) = (/&
&1.6715E-01_JPRB,1.6985E-01_JPRB,1.6971E-01_JPRB,1.6484E-01_JPRB,1.5668E-01_JPRB,1.4564E-01_JPRB,&
&1.3093E-01_JPRB,1.1285E-01_JPRB,1.0555E-01_JPRB,1.0079E-01_JPRB/)
KAO( :, 3, 2, 8) = (/&
&1.9803E-01_JPRB,2.0244E-01_JPRB,2.0211E-01_JPRB,1.9690E-01_JPRB,1.8801E-01_JPRB,1.7558E-01_JPRB,&
&1.5851E-01_JPRB,1.3719E-01_JPRB,1.2761E-01_JPRB,1.2193E-01_JPRB/)
KAO( :, 4, 2, 8) = (/&
&2.3133E-01_JPRB,2.3777E-01_JPRB,2.3782E-01_JPRB,2.3254E-01_JPRB,2.2351E-01_JPRB,2.0946E-01_JPRB,&
&1.8890E-01_JPRB,1.6397E-01_JPRB,1.5196E-01_JPRB,1.4557E-01_JPRB/)
KAO( :, 5, 2, 8) = (/&
&2.6711E-01_JPRB,2.7542E-01_JPRB,2.7668E-01_JPRB,2.7185E-01_JPRB,2.6232E-01_JPRB,2.4621E-01_JPRB,&
&2.2197E-01_JPRB,1.9371E-01_JPRB,1.7953E-01_JPRB,1.7231E-01_JPRB/)
KAO( :, 1, 3, 8) = (/&
&1.1272E-01_JPRB,1.1648E-01_JPRB,1.1742E-01_JPRB,1.1452E-01_JPRB,1.0929E-01_JPRB,1.0158E-01_JPRB,&
&9.0376E-02_JPRB,7.4637E-02_JPRB,6.6429E-02_JPRB,6.1506E-02_JPRB/)
KAO( :, 2, 3, 8) = (/&
&1.3749E-01_JPRB,1.4273E-01_JPRB,1.4386E-01_JPRB,1.4052E-01_JPRB,1.3417E-01_JPRB,1.2510E-01_JPRB,&
&1.1193E-01_JPRB,9.3361E-02_JPRB,8.2893E-02_JPRB,7.6819E-02_JPRB/)
KAO( :, 3, 3, 8) = (/&
&1.6469E-01_JPRB,1.7179E-01_JPRB,1.7314E-01_JPRB,1.6944E-01_JPRB,1.6261E-01_JPRB,1.5216E-01_JPRB,&
&1.3674E-01_JPRB,1.1431E-01_JPRB,1.0110E-01_JPRB,9.3702E-02_JPRB/)
KAO( :, 4, 3, 8) = (/&
&1.9422E-01_JPRB,2.0356E-01_JPRB,2.0555E-01_JPRB,2.0203E-01_JPRB,1.9491E-01_JPRB,1.8285E-01_JPRB,&
&1.6414E-01_JPRB,1.3754E-01_JPRB,1.2151E-01_JPRB,1.1286E-01_JPRB/)
KAO( :, 5, 3, 8) = (/&
&2.2623E-01_JPRB,2.3781E-01_JPRB,2.4116E-01_JPRB,2.3829E-01_JPRB,2.3049E-01_JPRB,2.1610E-01_JPRB,&
&1.9397E-01_JPRB,1.6347E-01_JPRB,1.4442E-01_JPRB,1.3449E-01_JPRB/)
KAO( :, 1, 4, 8) = (/&
&8.9051E-02_JPRB,9.4148E-02_JPRB,9.5376E-02_JPRB,9.3490E-02_JPRB,8.9564E-02_JPRB,8.3123E-02_JPRB,&
&7.3825E-02_JPRB,6.0440E-02_JPRB,5.0018E-02_JPRB,4.5241E-02_JPRB/)
KAO( :, 2, 4, 8) = (/&
&1.0984E-01_JPRB,1.1667E-01_JPRB,1.1837E-01_JPRB,1.1624E-01_JPRB,1.1142E-01_JPRB,1.0383E-01_JPRB,&
&9.2686E-02_JPRB,7.6384E-02_JPRB,6.3307E-02_JPRB,5.7158E-02_JPRB/)
KAO( :, 3, 4, 8) = (/&
&1.3321E-01_JPRB,1.4188E-01_JPRB,1.4403E-01_JPRB,1.4173E-01_JPRB,1.3641E-01_JPRB,1.2779E-01_JPRB,&
&1.1439E-01_JPRB,9.4375E-02_JPRB,7.8066E-02_JPRB,7.0497E-02_JPRB/)
KAO( :, 4, 4, 8) = (/&
&1.5891E-01_JPRB,1.6984E-01_JPRB,1.7265E-01_JPRB,1.7069E-01_JPRB,1.6497E-01_JPRB,1.5505E-01_JPRB,&
&1.3862E-01_JPRB,1.1439E-01_JPRB,9.4690E-02_JPRB,8.5635E-02_JPRB/)
KAO( :, 5, 4, 8) = (/&
&1.8690E-01_JPRB,2.0031E-01_JPRB,2.0459E-01_JPRB,2.0306E-01_JPRB,1.9673E-01_JPRB,1.8463E-01_JPRB,&
&1.6524E-01_JPRB,1.3669E-01_JPRB,1.1330E-01_JPRB,1.0289E-01_JPRB/)
KAO( :, 1, 5, 8) = (/&
&6.9203E-02_JPRB,7.4779E-02_JPRB,7.5983E-02_JPRB,7.4840E-02_JPRB,7.1567E-02_JPRB,6.6398E-02_JPRB,&
&5.8865E-02_JPRB,4.8193E-02_JPRB,3.7188E-02_JPRB,3.3169E-02_JPRB/)
KAO( :, 2, 5, 8) = (/&
&8.6430E-02_JPRB,9.3817E-02_JPRB,9.5587E-02_JPRB,9.4322E-02_JPRB,9.0456E-02_JPRB,8.4124E-02_JPRB,&
&7.5016E-02_JPRB,6.1615E-02_JPRB,4.7744E-02_JPRB,4.2317E-02_JPRB/)
KAO( :, 3, 5, 8) = (/&
&1.0608E-01_JPRB,1.1542E-01_JPRB,1.1772E-01_JPRB,1.1636E-01_JPRB,1.1218E-01_JPRB,1.0479E-01_JPRB,&
&9.3784E-02_JPRB,7.6996E-02_JPRB,5.9545E-02_JPRB,5.2656E-02_JPRB/)
KAO( :, 4, 5, 8) = (/&
&1.2808E-01_JPRB,1.3974E-01_JPRB,1.4262E-01_JPRB,1.4148E-01_JPRB,1.3703E-01_JPRB,1.2845E-01_JPRB,&
&1.1485E-01_JPRB,9.4184E-02_JPRB,7.2838E-02_JPRB,6.4516E-02_JPRB/)
KAO( :, 5, 5, 8) = (/&
&1.5224E-01_JPRB,1.6648E-01_JPRB,1.7081E-01_JPRB,1.6990E-01_JPRB,1.6471E-01_JPRB,1.5442E-01_JPRB,&
&1.3821E-01_JPRB,1.1347E-01_JPRB,8.7956E-02_JPRB,7.8195E-02_JPRB/)
KAO( :, 1, 6, 8) = (/&
&5.2711E-02_JPRB,5.7994E-02_JPRB,5.9096E-02_JPRB,5.8090E-02_JPRB,5.5430E-02_JPRB,5.1354E-02_JPRB,&
&4.5515E-02_JPRB,3.7271E-02_JPRB,2.7030E-02_JPRB,2.5040E-02_JPRB/)
KAO( :, 2, 6, 8) = (/&
&6.6719E-02_JPRB,7.3700E-02_JPRB,7.5367E-02_JPRB,7.4311E-02_JPRB,7.1156E-02_JPRB,6.6068E-02_JPRB,&
&5.8853E-02_JPRB,4.8369E-02_JPRB,3.5301E-02_JPRB,3.1744E-02_JPRB/)
KAO( :, 3, 6, 8) = (/&
&8.2863E-02_JPRB,9.1758E-02_JPRB,9.3947E-02_JPRB,9.2979E-02_JPRB,8.9500E-02_JPRB,8.3468E-02_JPRB,&
&7.4609E-02_JPRB,6.1328E-02_JPRB,4.4683E-02_JPRB,3.9440E-02_JPRB/)
KAO( :, 4, 6, 8) = (/&
&1.0132E-01_JPRB,1.1234E-01_JPRB,1.1520E-01_JPRB,1.1443E-01_JPRB,1.1059E-01_JPRB,1.0353E-01_JPRB,&
&9.2489E-02_JPRB,7.5833E-02_JPRB,5.5318E-02_JPRB,4.8406E-02_JPRB/)
KAO( :, 5, 6, 8) = (/&
&1.2185E-01_JPRB,1.3538E-01_JPRB,1.3945E-01_JPRB,1.3895E-01_JPRB,1.3433E-01_JPRB,1.2572E-01_JPRB,&
&1.1243E-01_JPRB,9.2112E-02_JPRB,6.7492E-02_JPRB,5.8870E-02_JPRB/)
KAO( :, 1, 7, 8) = (/&
&3.9562E-02_JPRB,4.4276E-02_JPRB,4.5109E-02_JPRB,4.4187E-02_JPRB,4.2082E-02_JPRB,3.8859E-02_JPRB,&
&3.4454E-02_JPRB,2.8224E-02_JPRB,1.9384E-02_JPRB,1.9321E-02_JPRB/)
KAO( :, 2, 7, 8) = (/&
&5.0879E-02_JPRB,5.7055E-02_JPRB,5.8399E-02_JPRB,5.7367E-02_JPRB,5.4802E-02_JPRB,5.0789E-02_JPRB,&
&4.5232E-02_JPRB,3.7273E-02_JPRB,2.5806E-02_JPRB,2.4869E-02_JPRB/)
KAO( :, 3, 7, 8) = (/&
&6.4003E-02_JPRB,7.1996E-02_JPRB,7.3764E-02_JPRB,7.2774E-02_JPRB,6.9847E-02_JPRB,6.5078E-02_JPRB,&
&5.8125E-02_JPRB,4.7947E-02_JPRB,3.3205E-02_JPRB,3.1173E-02_JPRB/)
KAO( :, 4, 7, 8) = (/&
&7.9173E-02_JPRB,8.9239E-02_JPRB,9.1617E-02_JPRB,9.0750E-02_JPRB,8.7396E-02_JPRB,8.1720E-02_JPRB,&
&7.3031E-02_JPRB,6.0013E-02_JPRB,4.1674E-02_JPRB,3.8297E-02_JPRB/)
KAO( :, 5, 7, 8) = (/&
&9.6350E-02_JPRB,1.0877E-01_JPRB,1.1214E-01_JPRB,1.1148E-01_JPRB,1.0740E-01_JPRB,1.0030E-01_JPRB,&
&8.9645E-02_JPRB,7.3703E-02_JPRB,5.1413E-02_JPRB,4.6217E-02_JPRB/)
KAO( :, 1, 8, 8) = (/&
&2.9374E-02_JPRB,3.3358E-02_JPRB,3.3910E-02_JPRB,3.3176E-02_JPRB,3.1488E-02_JPRB,2.9002E-02_JPRB,&
&2.5651E-02_JPRB,2.0998E-02_JPRB,1.3790E-02_JPRB,1.7931E-02_JPRB/)
KAO( :, 2, 8, 8) = (/&
&3.8453E-02_JPRB,4.3732E-02_JPRB,4.4619E-02_JPRB,4.3676E-02_JPRB,4.1586E-02_JPRB,3.8491E-02_JPRB,&
&3.4234E-02_JPRB,2.8236E-02_JPRB,1.8826E-02_JPRB,2.1882E-02_JPRB/)
KAO( :, 3, 8, 8) = (/&
&4.9075E-02_JPRB,5.5936E-02_JPRB,5.7139E-02_JPRB,5.6138E-02_JPRB,5.3708E-02_JPRB,4.9953E-02_JPRB,&
&4.4646E-02_JPRB,3.6887E-02_JPRB,2.4662E-02_JPRB,2.6591E-02_JPRB/)
KAO( :, 4, 8, 8) = (/&
&6.1437E-02_JPRB,7.0140E-02_JPRB,7.1902E-02_JPRB,7.0919E-02_JPRB,6.8027E-02_JPRB,6.3508E-02_JPRB,&
&5.6793E-02_JPRB,4.6822E-02_JPRB,3.1405E-02_JPRB,3.2120E-02_JPRB/)
KAO( :, 5, 8, 8) = (/&
&7.5648E-02_JPRB,8.6455E-02_JPRB,8.9059E-02_JPRB,8.8138E-02_JPRB,8.4612E-02_JPRB,7.8826E-02_JPRB,&
&7.0474E-02_JPRB,5.8121E-02_JPRB,3.9203E-02_JPRB,3.8693E-02_JPRB/)
KAO( :, 1, 9, 8) = (/&
&2.1631E-02_JPRB,2.4762E-02_JPRB,2.5091E-02_JPRB,2.4519E-02_JPRB,2.3245E-02_JPRB,2.1343E-02_JPRB,&
&1.8810E-02_JPRB,1.5373E-02_JPRB,9.7641E-03_JPRB,2.9273E-02_JPRB/)
KAO( :, 2, 9, 8) = (/&
&2.8813E-02_JPRB,3.3084E-02_JPRB,3.3621E-02_JPRB,3.2842E-02_JPRB,3.1201E-02_JPRB,2.8769E-02_JPRB,&
&2.5516E-02_JPRB,2.1018E-02_JPRB,1.3707E-02_JPRB,3.3813E-02_JPRB/)
KAO( :, 3, 9, 8) = (/&
&3.7408E-02_JPRB,4.2984E-02_JPRB,4.3696E-02_JPRB,4.2737E-02_JPRB,4.0787E-02_JPRB,3.7847E-02_JPRB,&
&3.3777E-02_JPRB,2.7905E-02_JPRB,1.8311E-02_JPRB,3.9010E-02_JPRB/)
KAO( :, 4, 9, 8) = (/&
&4.7502E-02_JPRB,5.4598E-02_JPRB,5.5650E-02_JPRB,5.4654E-02_JPRB,5.2292E-02_JPRB,4.8701E-02_JPRB,&
&4.3528E-02_JPRB,3.5956E-02_JPRB,2.3660E-02_JPRB,4.4684E-02_JPRB/)
KAO( :, 5, 9, 8) = (/&
&5.9184E-02_JPRB,6.8075E-02_JPRB,6.9737E-02_JPRB,6.8716E-02_JPRB,6.5788E-02_JPRB,6.1148E-02_JPRB,&
&5.4664E-02_JPRB,4.5216E-02_JPRB,2.9878E-02_JPRB,5.0829E-02_JPRB/)
KAO( :, 1,10, 8) = (/&
&1.6420E-02_JPRB,1.8693E-02_JPRB,1.8856E-02_JPRB,1.8334E-02_JPRB,1.7341E-02_JPRB,1.5930E-02_JPRB,&
&1.4013E-02_JPRB,1.1403E-02_JPRB,7.0640E-03_JPRB,7.0532E-02_JPRB/)
KAO( :, 2,10, 8) = (/&
&2.2040E-02_JPRB,2.5317E-02_JPRB,2.5632E-02_JPRB,2.5009E-02_JPRB,2.3702E-02_JPRB,2.1797E-02_JPRB,&
&1.9273E-02_JPRB,1.5810E-02_JPRB,1.0204E-02_JPRB,7.6827E-02_JPRB/)
KAO( :, 3,10, 8) = (/&
&2.8968E-02_JPRB,3.3418E-02_JPRB,3.3805E-02_JPRB,3.2963E-02_JPRB,3.1358E-02_JPRB,2.9007E-02_JPRB,&
&2.5810E-02_JPRB,2.1266E-02_JPRB,1.3886E-02_JPRB,8.3691E-02_JPRB/)
KAO( :, 4,10, 8) = (/&
&3.7285E-02_JPRB,4.3000E-02_JPRB,4.3529E-02_JPRB,4.2562E-02_JPRB,4.0635E-02_JPRB,3.7704E-02_JPRB,&
&3.3617E-02_JPRB,2.7781E-02_JPRB,1.8177E-02_JPRB,9.1457E-02_JPRB/)
KAO( :, 5,10, 8) = (/&
&4.7085E-02_JPRB,5.4248E-02_JPRB,5.5089E-02_JPRB,5.4027E-02_JPRB,5.1573E-02_JPRB,4.7828E-02_JPRB,&
&4.2671E-02_JPRB,3.5326E-02_JPRB,2.3198E-02_JPRB,9.9898E-02_JPRB/)
KAO( :, 1,11, 8) = (/&
&1.4563E-02_JPRB,1.6480E-02_JPRB,1.6520E-02_JPRB,1.5972E-02_JPRB,1.5054E-02_JPRB,1.3800E-02_JPRB,&
&1.2151E-02_JPRB,9.8498E-03_JPRB,6.1529E-03_JPRB,9.3025E-02_JPRB/)
KAO( :, 2,11, 8) = (/&
&1.9422E-02_JPRB,2.2230E-02_JPRB,2.2365E-02_JPRB,2.1742E-02_JPRB,2.0575E-02_JPRB,1.8920E-02_JPRB,&
&1.6702E-02_JPRB,1.3649E-02_JPRB,8.8593E-03_JPRB,9.9753E-02_JPRB/)
KAO( :, 3,11, 8) = (/&
&2.5471E-02_JPRB,2.9351E-02_JPRB,2.9545E-02_JPRB,2.8766E-02_JPRB,2.7276E-02_JPRB,2.5150E-02_JPRB,&
&2.2319E-02_JPRB,1.8330E-02_JPRB,1.2044E-02_JPRB,1.0708E-01_JPRB/)
KAO( :, 4,11, 8) = (/&
&3.2877E-02_JPRB,3.7913E-02_JPRB,3.8172E-02_JPRB,3.7200E-02_JPRB,3.5345E-02_JPRB,3.2640E-02_JPRB,&
&2.9010E-02_JPRB,2.3912E-02_JPRB,1.5750E-02_JPRB,1.1551E-01_JPRB/)
KAO( :, 5,11, 8) = (/&
&4.1783E-02_JPRB,4.8070E-02_JPRB,4.8478E-02_JPRB,4.7211E-02_JPRB,4.4842E-02_JPRB,4.1431E-02_JPRB,&
&3.6822E-02_JPRB,3.0426E-02_JPRB,2.0117E-02_JPRB,1.2493E-01_JPRB/)
KAO( :, 1,12, 8) = (/&
&1.2968E-02_JPRB,1.4613E-02_JPRB,1.4518E-02_JPRB,1.3965E-02_JPRB,1.3108E-02_JPRB,1.1965E-02_JPRB,&
&1.0480E-02_JPRB,8.4661E-03_JPRB,5.3281E-03_JPRB,9.6224E-02_JPRB/)
KAO( :, 2,12, 8) = (/&
&1.7226E-02_JPRB,1.9607E-02_JPRB,1.9589E-02_JPRB,1.8955E-02_JPRB,1.7877E-02_JPRB,1.6390E-02_JPRB,&
&1.4401E-02_JPRB,1.1714E-02_JPRB,7.6423E-03_JPRB,1.0281E-01_JPRB/)
KAO( :, 3,12, 8) = (/&
&2.2561E-02_JPRB,2.5832E-02_JPRB,2.5887E-02_JPRB,2.5130E-02_JPRB,2.3746E-02_JPRB,2.1760E-02_JPRB,&
&1.9184E-02_JPRB,1.5701E-02_JPRB,1.0359E-02_JPRB,1.1042E-01_JPRB/)
KAO( :, 4,12, 8) = (/&
&2.9208E-02_JPRB,3.3517E-02_JPRB,3.3592E-02_JPRB,3.2561E-02_JPRB,3.0751E-02_JPRB,2.8221E-02_JPRB,&
&2.4906E-02_JPRB,2.0465E-02_JPRB,1.3564E-02_JPRB,1.1943E-01_JPRB/)
KAO( :, 5,12, 8) = (/&
&3.7315E-02_JPRB,4.2782E-02_JPRB,4.2863E-02_JPRB,4.1414E-02_JPRB,3.9083E-02_JPRB,3.5863E-02_JPRB,&
&3.1661E-02_JPRB,2.6087E-02_JPRB,1.7348E-02_JPRB,1.2941E-01_JPRB/)
KAO( :, 1,13, 8) = (/&
&1.1431E-02_JPRB,1.2896E-02_JPRB,1.2736E-02_JPRB,1.2199E-02_JPRB,1.1402E-02_JPRB,1.0345E-02_JPRB,&
&9.0003E-03_JPRB,7.2287E-03_JPRB,4.5824E-03_JPRB,8.0519E-02_JPRB/)
KAO( :, 2,13, 8) = (/&
&1.5206E-02_JPRB,1.7258E-02_JPRB,1.7158E-02_JPRB,1.6539E-02_JPRB,1.5531E-02_JPRB,1.4140E-02_JPRB,&
&1.2338E-02_JPRB,9.9830E-03_JPRB,6.5464E-03_JPRB,8.6863E-02_JPRB/)
KAO( :, 3,13, 8) = (/&
&1.9972E-02_JPRB,2.2777E-02_JPRB,2.2713E-02_JPRB,2.1940E-02_JPRB,2.0631E-02_JPRB,1.8770E-02_JPRB,&
&1.6415E-02_JPRB,1.3364E-02_JPRB,8.8693E-03_JPRB,9.4420E-02_JPRB/)
KAO( :, 4,13, 8) = (/&
&2.5947E-02_JPRB,2.9698E-02_JPRB,2.9634E-02_JPRB,2.8542E-02_JPRB,2.6762E-02_JPRB,2.4361E-02_JPRB,&
&2.1338E-02_JPRB,1.7424E-02_JPRB,1.1633E-02_JPRB,1.0329E-01_JPRB/)
KAO( :, 5,13, 8) = (/&
&3.3342E-02_JPRB,3.8082E-02_JPRB,3.7942E-02_JPRB,3.6482E-02_JPRB,3.4168E-02_JPRB,3.1080E-02_JPRB,&
&2.7224E-02_JPRB,2.2266E-02_JPRB,1.4896E-02_JPRB,1.1299E-01_JPRB/)
KAO( :, 1, 1, 9) = (/&
&3.5399E-01_JPRB,3.3121E-01_JPRB,3.2486E-01_JPRB,3.1880E-01_JPRB,3.1822E-01_JPRB,3.2442E-01_JPRB,&
&3.3586E-01_JPRB,3.4269E-01_JPRB,3.3501E-01_JPRB,3.3685E-01_JPRB/)
KAO( :, 2, 1, 9) = (/&
&4.2651E-01_JPRB,4.0055E-01_JPRB,3.9461E-01_JPRB,3.8890E-01_JPRB,3.8920E-01_JPRB,3.9613E-01_JPRB,&
&4.0802E-01_JPRB,4.1445E-01_JPRB,4.0640E-01_JPRB,4.0867E-01_JPRB/)
KAO( :, 3, 1, 9) = (/&
&5.0539E-01_JPRB,4.7639E-01_JPRB,4.7090E-01_JPRB,4.6538E-01_JPRB,4.6724E-01_JPRB,4.7472E-01_JPRB,&
&4.8830E-01_JPRB,4.9479E-01_JPRB,4.8770E-01_JPRB,4.9083E-01_JPRB/)
KAO( :, 4, 1, 9) = (/&
&5.9058E-01_JPRB,5.5850E-01_JPRB,5.5373E-01_JPRB,5.4899E-01_JPRB,5.5264E-01_JPRB,5.6233E-01_JPRB,&
&5.7911E-01_JPRB,5.8486E-01_JPRB,5.8020E-01_JPRB,5.8417E-01_JPRB/)
KAO( :, 5, 1, 9) = (/&
&6.8144E-01_JPRB,6.4618E-01_JPRB,6.4280E-01_JPRB,6.4028E-01_JPRB,6.4693E-01_JPRB,6.6026E-01_JPRB,&
&6.7993E-01_JPRB,6.8608E-01_JPRB,6.8519E-01_JPRB,6.9037E-01_JPRB/)
KAO( :, 1, 2, 9) = (/&
&3.4190E-01_JPRB,3.2327E-01_JPRB,3.1819E-01_JPRB,3.0936E-01_JPRB,3.0384E-01_JPRB,3.0263E-01_JPRB,&
&3.0472E-01_JPRB,3.0754E-01_JPRB,2.9901E-01_JPRB,2.9844E-01_JPRB/)
KAO( :, 2, 2, 9) = (/&
&4.1493E-01_JPRB,3.9389E-01_JPRB,3.8895E-01_JPRB,3.7913E-01_JPRB,3.7292E-01_JPRB,3.7132E-01_JPRB,&
&3.7292E-01_JPRB,3.7436E-01_JPRB,3.6462E-01_JPRB,3.6374E-01_JPRB/)
KAO( :, 3, 2, 9) = (/&
&4.9524E-01_JPRB,4.7144E-01_JPRB,4.6681E-01_JPRB,4.5556E-01_JPRB,4.4901E-01_JPRB,4.4730E-01_JPRB,&
&4.4941E-01_JPRB,4.4980E-01_JPRB,4.3975E-01_JPRB,4.3888E-01_JPRB/)
KAO( :, 4, 2, 9) = (/&
&5.8258E-01_JPRB,5.5620E-01_JPRB,5.5130E-01_JPRB,5.3974E-01_JPRB,5.3286E-01_JPRB,5.3221E-01_JPRB,&
&5.3561E-01_JPRB,5.3530E-01_JPRB,5.2641E-01_JPRB,5.2532E-01_JPRB/)
KAO( :, 5, 2, 9) = (/&
&6.7549E-01_JPRB,6.4700E-01_JPRB,6.4191E-01_JPRB,6.3134E-01_JPRB,6.2562E-01_JPRB,6.2644E-01_JPRB,&
&6.3141E-01_JPRB,6.3148E-01_JPRB,6.2520E-01_JPRB,6.2423E-01_JPRB/)
KAO( :, 1, 3, 9) = (/&
&3.1322E-01_JPRB,2.9905E-01_JPRB,2.9475E-01_JPRB,2.8714E-01_JPRB,2.7777E-01_JPRB,2.7056E-01_JPRB,&
&2.6471E-01_JPRB,2.6169E-01_JPRB,2.5251E-01_JPRB,2.4874E-01_JPRB/)
KAO( :, 2, 3, 9) = (/&
&3.8433E-01_JPRB,3.6852E-01_JPRB,3.6478E-01_JPRB,3.5517E-01_JPRB,3.4410E-01_JPRB,3.3552E-01_JPRB,&
&3.2763E-01_JPRB,3.2198E-01_JPRB,3.1065E-01_JPRB,3.0619E-01_JPRB/)
KAO( :, 3, 3, 9) = (/&
&4.6279E-01_JPRB,4.4538E-01_JPRB,4.4243E-01_JPRB,4.3036E-01_JPRB,4.1731E-01_JPRB,4.0795E-01_JPRB,&
&3.9813E-01_JPRB,3.9008E-01_JPRB,3.7721E-01_JPRB,3.7260E-01_JPRB/)
KAO( :, 4, 3, 9) = (/&
&5.4926E-01_JPRB,5.2996E-01_JPRB,5.2724E-01_JPRB,5.1320E-01_JPRB,4.9840E-01_JPRB,4.8894E-01_JPRB,&
&4.7837E-01_JPRB,4.6780E-01_JPRB,4.5401E-01_JPRB,4.4835E-01_JPRB/)
KAO( :, 5, 3, 9) = (/&
&6.4194E-01_JPRB,6.2152E-01_JPRB,6.1862E-01_JPRB,6.0327E-01_JPRB,5.8767E-01_JPRB,5.7864E-01_JPRB,&
&5.6818E-01_JPRB,5.5487E-01_JPRB,5.4176E-01_JPRB,5.3533E-01_JPRB/)
KAO( :, 1, 4, 9) = (/&
&2.7768E-01_JPRB,2.6760E-01_JPRB,2.6572E-01_JPRB,2.5980E-01_JPRB,2.4896E-01_JPRB,2.3795E-01_JPRB,&
&2.2584E-01_JPRB,2.1553E-01_JPRB,2.0567E-01_JPRB,1.9994E-01_JPRB/)
KAO( :, 2, 4, 9) = (/&
&3.4628E-01_JPRB,3.3518E-01_JPRB,3.3312E-01_JPRB,3.2573E-01_JPRB,3.1238E-01_JPRB,2.9848E-01_JPRB,&
&2.8332E-01_JPRB,2.6934E-01_JPRB,2.5641E-01_JPRB,2.4969E-01_JPRB/)
KAO( :, 3, 4, 9) = (/&
&4.2166E-01_JPRB,4.1018E-01_JPRB,4.0846E-01_JPRB,3.9896E-01_JPRB,3.8288E-01_JPRB,3.6617E-01_JPRB,&
&3.4804E-01_JPRB,3.3049E-01_JPRB,3.1485E-01_JPRB,3.0688E-01_JPRB/)
KAO( :, 4, 4, 9) = (/&
&5.0480E-01_JPRB,4.9294E-01_JPRB,4.9184E-01_JPRB,4.7995E-01_JPRB,4.6126E-01_JPRB,4.4207E-01_JPRB,&
&4.2165E-01_JPRB,4.0000E-01_JPRB,3.8208E-01_JPRB,3.7264E-01_JPRB/)
KAO( :, 5, 4, 9) = (/&
&5.9516E-01_JPRB,5.8326E-01_JPRB,5.8244E-01_JPRB,5.6852E-01_JPRB,5.4774E-01_JPRB,5.2760E-01_JPRB,&
&5.0410E-01_JPRB,4.7792E-01_JPRB,4.5860E-01_JPRB,4.4782E-01_JPRB/)
KAO( :, 1, 5, 9) = (/&
&2.4131E-01_JPRB,2.3501E-01_JPRB,2.3520E-01_JPRB,2.3089E-01_JPRB,2.2183E-01_JPRB,2.0721E-01_JPRB,&
&1.9087E-01_JPRB,1.7544E-01_JPRB,1.6409E-01_JPRB,1.5817E-01_JPRB/)
KAO( :, 2, 5, 9) = (/&
&3.0553E-01_JPRB,2.9936E-01_JPRB,2.9956E-01_JPRB,2.9368E-01_JPRB,2.8148E-01_JPRB,2.6374E-01_JPRB,&
&2.4318E-01_JPRB,2.2281E-01_JPRB,2.0743E-01_JPRB,2.0014E-01_JPRB/)
KAO( :, 3, 5, 9) = (/&
&3.7703E-01_JPRB,3.7157E-01_JPRB,3.7167E-01_JPRB,3.6419E-01_JPRB,3.4859E-01_JPRB,3.2739E-01_JPRB,&
&3.0264E-01_JPRB,2.7688E-01_JPRB,2.5755E-01_JPRB,2.4828E-01_JPRB/)
KAO( :, 4, 5, 9) = (/&
&4.5610E-01_JPRB,4.5131E-01_JPRB,4.5213E-01_JPRB,4.4247E-01_JPRB,4.2387E-01_JPRB,3.9882E-01_JPRB,&
&3.7008E-01_JPRB,3.3849E-01_JPRB,3.1536E-01_JPRB,3.0426E-01_JPRB/)
KAO( :, 5, 5, 9) = (/&
&5.4247E-01_JPRB,5.3886E-01_JPRB,5.4021E-01_JPRB,5.2840E-01_JPRB,5.0753E-01_JPRB,4.7901E-01_JPRB,&
&4.4567E-01_JPRB,4.0809E-01_JPRB,3.8163E-01_JPRB,3.6881E-01_JPRB/)
KAO( :, 1, 6, 9) = (/&
&2.0298E-01_JPRB,2.0025E-01_JPRB,2.0213E-01_JPRB,1.9982E-01_JPRB,1.9212E-01_JPRB,1.7691E-01_JPRB,&
&1.5886E-01_JPRB,1.4069E-01_JPRB,1.2763E-01_JPRB,1.2147E-01_JPRB/)
KAO( :, 2, 6, 9) = (/&
&2.6157E-01_JPRB,2.5976E-01_JPRB,2.6209E-01_JPRB,2.5832E-01_JPRB,2.4798E-01_JPRB,2.2871E-01_JPRB,&
&2.0577E-01_JPRB,1.8197E-01_JPRB,1.6416E-01_JPRB,1.5634E-01_JPRB/)
KAO( :, 3, 6, 9) = (/&
&3.2801E-01_JPRB,3.2761E-01_JPRB,3.3023E-01_JPRB,3.2484E-01_JPRB,3.1114E-01_JPRB,2.8803E-01_JPRB,&
&2.5966E-01_JPRB,2.2885E-01_JPRB,2.0587E-01_JPRB,1.9644E-01_JPRB/)
KAO( :, 4, 6, 9) = (/&
&4.0207E-01_JPRB,4.0351E-01_JPRB,4.0622E-01_JPRB,3.9903E-01_JPRB,3.8234E-01_JPRB,3.5465E-01_JPRB,&
&3.2062E-01_JPRB,2.8289E-01_JPRB,2.5440E-01_JPRB,2.4312E-01_JPRB/)
KAO( :, 5, 6, 9) = (/&
&4.8336E-01_JPRB,4.8697E-01_JPRB,4.9003E-01_JPRB,4.8114E-01_JPRB,4.6185E-01_JPRB,4.2928E-01_JPRB,&
&3.8966E-01_JPRB,3.4463E-01_JPRB,3.1043E-01_JPRB,2.9706E-01_JPRB/)
KAO( :, 1, 7, 9) = (/&
&1.6688E-01_JPRB,1.6702E-01_JPRB,1.7031E-01_JPRB,1.6921E-01_JPRB,1.6199E-01_JPRB,1.4897E-01_JPRB,&
&1.3092E-01_JPRB,1.1133E-01_JPRB,9.6760E-02_JPRB,9.3718E-02_JPRB/)
KAO( :, 2, 7, 9) = (/&
&2.1882E-01_JPRB,2.2087E-01_JPRB,2.2486E-01_JPRB,2.2286E-01_JPRB,2.1335E-01_JPRB,1.9615E-01_JPRB,&
&1.7285E-01_JPRB,1.4695E-01_JPRB,1.2690E-01_JPRB,1.2096E-01_JPRB/)
KAO( :, 3, 7, 9) = (/&
&2.7888E-01_JPRB,2.8306E-01_JPRB,2.8777E-01_JPRB,2.8469E-01_JPRB,2.7204E-01_JPRB,2.5033E-01_JPRB,&
&2.2122E-01_JPRB,1.8786E-01_JPRB,1.6161E-01_JPRB,1.5296E-01_JPRB/)
KAO( :, 4, 7, 9) = (/&
&3.4680E-01_JPRB,3.5385E-01_JPRB,3.5881E-01_JPRB,3.5420E-01_JPRB,3.3854E-01_JPRB,3.1188E-01_JPRB,&
&2.7612E-01_JPRB,2.3528E-01_JPRB,2.0215E-01_JPRB,1.9095E-01_JPRB/)
KAO( :, 5, 7, 9) = (/&
&4.2205E-01_JPRB,4.3215E-01_JPRB,4.3759E-01_JPRB,4.3127E-01_JPRB,4.1273E-01_JPRB,3.8116E-01_JPRB,&
&3.3879E-01_JPRB,2.8948E-01_JPRB,2.4886E-01_JPRB,2.3560E-01_JPRB/)
KAO( :, 1, 8, 9) = (/&
&1.3459E-01_JPRB,1.3692E-01_JPRB,1.4080E-01_JPRB,1.3971E-01_JPRB,1.3347E-01_JPRB,1.2262E-01_JPRB,&
&1.0666E-01_JPRB,8.7305E-02_JPRB,7.1915E-02_JPRB,8.0038E-02_JPRB/)
KAO( :, 2, 8, 9) = (/&
&1.7963E-01_JPRB,1.8442E-01_JPRB,1.8954E-01_JPRB,1.8806E-01_JPRB,1.7951E-01_JPRB,1.6497E-01_JPRB,&
&1.4377E-01_JPRB,1.1758E-01_JPRB,9.6206E-02_JPRB,1.0094E-01_JPRB/)
KAO( :, 3, 8, 9) = (/&
&2.3266E-01_JPRB,2.4033E-01_JPRB,2.4672E-01_JPRB,2.4454E-01_JPRB,2.3290E-01_JPRB,2.1424E-01_JPRB,&
&1.8695E-01_JPRB,1.5303E-01_JPRB,1.2456E-01_JPRB,1.2568E-01_JPRB/)
KAO( :, 4, 8, 9) = (/&
&2.9355E-01_JPRB,3.0495E-01_JPRB,3.1213E-01_JPRB,3.0852E-01_JPRB,2.9407E-01_JPRB,2.7020E-01_JPRB,&
&2.3654E-01_JPRB,1.9451E-01_JPRB,1.5796E-01_JPRB,1.5516E-01_JPRB/)
KAO( :, 5, 8, 9) = (/&
&3.6186E-01_JPRB,3.7725E-01_JPRB,3.8522E-01_JPRB,3.7996E-01_JPRB,3.6242E-01_JPRB,3.3355E-01_JPRB,&
&2.9318E-01_JPRB,2.4229E-01_JPRB,1.9677E-01_JPRB,1.8992E-01_JPRB/)
KAO( :, 1, 9, 9) = (/&
&1.0631E-01_JPRB,1.0993E-01_JPRB,1.1355E-01_JPRB,1.1237E-01_JPRB,1.0701E-01_JPRB,9.8207E-02_JPRB,&
&8.5182E-02_JPRB,6.7755E-02_JPRB,5.2331E-02_JPRB,1.0492E-01_JPRB/)
KAO( :, 2, 9, 9) = (/&
&1.4454E-01_JPRB,1.5090E-01_JPRB,1.5590E-01_JPRB,1.5444E-01_JPRB,1.4727E-01_JPRB,1.3526E-01_JPRB,&
&1.1750E-01_JPRB,9.3259E-02_JPRB,7.1622E-02_JPRB,1.2467E-01_JPRB/)
KAO( :, 3, 9, 9) = (/&
&1.9019E-01_JPRB,2.0011E-01_JPRB,2.0653E-01_JPRB,2.0466E-01_JPRB,1.9486E-01_JPRB,1.7904E-01_JPRB,&
&1.5563E-01_JPRB,1.2364E-01_JPRB,9.4415E-02_JPRB,1.4740E-01_JPRB/)
KAO( :, 4, 9, 9) = (/&
&2.4347E-01_JPRB,2.5775E-01_JPRB,2.6549E-01_JPRB,2.6241E-01_JPRB,2.4987E-01_JPRB,2.2949E-01_JPRB,&
&1.9969E-01_JPRB,1.5939E-01_JPRB,1.2136E-01_JPRB,1.7369E-01_JPRB/)
KAO( :, 5, 9, 9) = (/&
&3.0422E-01_JPRB,3.2317E-01_JPRB,3.3203E-01_JPRB,3.2777E-01_JPRB,3.1197E-01_JPRB,2.8664E-01_JPRB,&
&2.5051E-01_JPRB,2.0084E-01_JPRB,1.5296E-01_JPRB,2.0398E-01_JPRB/)
KAO( :, 1,10, 9) = (/&
&8.4350E-02_JPRB,8.8815E-02_JPRB,9.2007E-02_JPRB,9.0712E-02_JPRB,8.6235E-02_JPRB,7.8834E-02_JPRB,&
&6.8251E-02_JPRB,5.3494E-02_JPRB,3.8569E-02_JPRB,2.8448E-01_JPRB/)
KAO( :, 2,10, 9) = (/&
&1.1655E-01_JPRB,1.2396E-01_JPRB,1.2864E-01_JPRB,1.2700E-01_JPRB,1.2091E-01_JPRB,1.1076E-01_JPRB,&
&9.6175E-02_JPRB,7.5206E-02_JPRB,5.3741E-02_JPRB,3.1183E-01_JPRB/)
KAO( :, 3,10, 9) = (/&
&1.5575E-01_JPRB,1.6688E-01_JPRB,1.7302E-01_JPRB,1.7096E-01_JPRB,1.6280E-01_JPRB,1.4927E-01_JPRB,&
&1.2964E-01_JPRB,1.0128E-01_JPRB,7.1998E-02_JPRB,3.4035E-01_JPRB/)
KAO( :, 4,10, 9) = (/&
&2.0199E-01_JPRB,2.1771E-01_JPRB,2.2539E-01_JPRB,2.2239E-01_JPRB,2.1182E-01_JPRB,1.9426E-01_JPRB,&
&1.6870E-01_JPRB,1.3220E-01_JPRB,9.3820E-02_JPRB,3.7022E-01_JPRB/)
KAO( :, 5,10, 9) = (/&
&2.5543E-01_JPRB,2.7602E-01_JPRB,2.8512E-01_JPRB,2.8125E-01_JPRB,2.6776E-01_JPRB,2.4558E-01_JPRB,&
&2.1379E-01_JPRB,1.6843E-01_JPRB,1.1967E-01_JPRB,4.0133E-01_JPRB/)
KAO( :, 1,11, 9) = (/&
&7.7305E-02_JPRB,8.3512E-02_JPRB,8.6558E-02_JPRB,8.5115E-02_JPRB,8.0759E-02_JPRB,7.3668E-02_JPRB,&
&6.3729E-02_JPRB,4.9798E-02_JPRB,3.3279E-02_JPRB,4.2331E-01_JPRB/)
KAO( :, 2,11, 9) = (/&
&1.0674E-01_JPRB,1.1631E-01_JPRB,1.2074E-01_JPRB,1.1897E-01_JPRB,1.1306E-01_JPRB,1.0338E-01_JPRB,&
&8.9693E-02_JPRB,6.9947E-02_JPRB,4.6392E-02_JPRB,4.5759E-01_JPRB/)
KAO( :, 3,11, 9) = (/&
&1.4252E-01_JPRB,1.5630E-01_JPRB,1.6230E-01_JPRB,1.5989E-01_JPRB,1.5215E-01_JPRB,1.3931E-01_JPRB,&
&1.2082E-01_JPRB,9.4229E-02_JPRB,6.2207E-02_JPRB,4.9301E-01_JPRB/)
KAO( :, 4,11, 9) = (/&
&1.8495E-01_JPRB,2.0344E-01_JPRB,2.1113E-01_JPRB,2.0801E-01_JPRB,1.9807E-01_JPRB,1.8125E-01_JPRB,&
&1.5734E-01_JPRB,1.2303E-01_JPRB,8.1307E-02_JPRB,5.3012E-01_JPRB/)
KAO( :, 5,11, 9) = (/&
&2.3411E-01_JPRB,2.5783E-01_JPRB,2.6690E-01_JPRB,2.6303E-01_JPRB,2.5035E-01_JPRB,2.2944E-01_JPRB,&
&1.9943E-01_JPRB,1.5658E-01_JPRB,1.0397E-01_JPRB,5.6789E-01_JPRB/)
KAO( :, 1,12, 9) = (/&
&7.0108E-02_JPRB,7.7427E-02_JPRB,8.0063E-02_JPRB,7.8695E-02_JPRB,7.4412E-02_JPRB,6.7798E-02_JPRB,&
&5.8710E-02_JPRB,4.5826E-02_JPRB,2.8701E-02_JPRB,4.8793E-01_JPRB/)
KAO( :, 2,12, 9) = (/&
&9.6572E-02_JPRB,1.0765E-01_JPRB,1.1154E-01_JPRB,1.0976E-01_JPRB,1.0403E-01_JPRB,9.5053E-02_JPRB,&
&8.2414E-02_JPRB,6.4355E-02_JPRB,4.0085E-02_JPRB,5.2480E-01_JPRB/)
KAO( :, 3,12, 9) = (/&
&1.2890E-01_JPRB,1.4436E-01_JPRB,1.4960E-01_JPRB,1.4739E-01_JPRB,1.3992E-01_JPRB,1.2801E-01_JPRB,&
&1.1096E-01_JPRB,8.6644E-02_JPRB,5.3975E-02_JPRB,5.6251E-01_JPRB/)
KAO( :, 4,12, 9) = (/&
&1.6737E-01_JPRB,1.8778E-01_JPRB,1.9430E-01_JPRB,1.9165E-01_JPRB,1.8208E-01_JPRB,1.6659E-01_JPRB,&
&1.4450E-01_JPRB,1.1307E-01_JPRB,7.0696E-02_JPRB,6.0183E-01_JPRB/)
KAO( :, 5,12, 9) = (/&
&2.1186E-01_JPRB,2.3792E-01_JPRB,2.4587E-01_JPRB,2.4233E-01_JPRB,2.3021E-01_JPRB,2.1086E-01_JPRB,&
&1.8327E-01_JPRB,1.4386E-01_JPRB,9.0292E-02_JPRB,6.4163E-01_JPRB/)
KAO( :, 1,13, 9) = (/&
&6.2750E-02_JPRB,7.0678E-02_JPRB,7.2850E-02_JPRB,7.1358E-02_JPRB,6.7441E-02_JPRB,6.1433E-02_JPRB,&
&5.3185E-02_JPRB,4.1505E-02_JPRB,2.4806E-02_JPRB,4.4700E-01_JPRB/)
KAO( :, 2,13, 9) = (/&
&8.6316E-02_JPRB,9.8143E-02_JPRB,1.0134E-01_JPRB,9.9447E-02_JPRB,9.4210E-02_JPRB,8.6014E-02_JPRB,&
&7.4526E-02_JPRB,5.8273E-02_JPRB,3.4743E-02_JPRB,4.8103E-01_JPRB/)
KAO( :, 3,13, 9) = (/&
&1.1529E-01_JPRB,1.3156E-01_JPRB,1.3579E-01_JPRB,1.3346E-01_JPRB,1.2666E-01_JPRB,1.1573E-01_JPRB,&
&1.0031E-01_JPRB,7.8511E-02_JPRB,4.6928E-02_JPRB,5.1606E-01_JPRB/)
KAO( :, 4,13, 9) = (/&
&1.4976E-01_JPRB,1.7104E-01_JPRB,1.7643E-01_JPRB,1.7358E-01_JPRB,1.6473E-01_JPRB,1.5058E-01_JPRB,&
&1.3067E-01_JPRB,1.0249E-01_JPRB,6.1551E-02_JPRB,5.5224E-01_JPRB/)
KAO( :, 5,13, 9) = (/&
&1.8964E-01_JPRB,2.1656E-01_JPRB,2.2339E-01_JPRB,2.1970E-01_JPRB,2.0856E-01_JPRB,1.9074E-01_JPRB,&
&1.6575E-01_JPRB,1.3031E-01_JPRB,7.8382E-02_JPRB,5.8913E-01_JPRB/)
KAO( :, 1, 1,10) = (/&
&6.1867E-01_JPRB,5.7630E-01_JPRB,6.0305E-01_JPRB,6.9456E-01_JPRB,7.7261E-01_JPRB,8.1005E-01_JPRB,&
&8.2424E-01_JPRB,7.8487E-01_JPRB,7.9716E-01_JPRB,8.1097E-01_JPRB/)
KAO( :, 2, 1,10) = (/&
&7.5538E-01_JPRB,7.0706E-01_JPRB,7.4825E-01_JPRB,8.6573E-01_JPRB,9.5133E-01_JPRB,9.9496E-01_JPRB,&
&1.0144E+00_JPRB,9.4349E-01_JPRB,9.7510E-01_JPRB,9.8557E-01_JPRB/)
KAO( :, 3, 1,10) = (/&
&9.0753E-01_JPRB,8.5431E-01_JPRB,9.0954E-01_JPRB,1.0504E+00_JPRB,1.1439E+00_JPRB,1.1961E+00_JPRB,&
&1.2138E+00_JPRB,1.1038E+00_JPRB,1.1635E+00_JPRB,1.1729E+00_JPRB/)
KAO( :, 4, 1,10) = (/&
&1.0717E+00_JPRB,1.0134E+00_JPRB,1.0876E+00_JPRB,1.2471E+00_JPRB,1.3505E+00_JPRB,1.4049E+00_JPRB,&
&1.4219E+00_JPRB,1.2915E+00_JPRB,1.3878E+00_JPRB,1.3991E+00_JPRB/)
KAO( :, 5, 1,10) = (/&
&1.2427E+00_JPRB,1.1827E+00_JPRB,1.2833E+00_JPRB,1.4504E+00_JPRB,1.5635E+00_JPRB,1.6298E+00_JPRB,&
&1.6597E+00_JPRB,1.4857E+00_JPRB,1.6414E+00_JPRB,1.6460E+00_JPRB/)
KAO( :, 1, 2,10) = (/&
&6.4321E-01_JPRB,5.8696E-01_JPRB,5.8230E-01_JPRB,6.5619E-01_JPRB,7.1556E-01_JPRB,7.4170E-01_JPRB,&
&7.6071E-01_JPRB,7.3912E-01_JPRB,7.4532E-01_JPRB,7.5850E-01_JPRB/)
KAO( :, 2, 2,10) = (/&
&7.8984E-01_JPRB,7.2453E-01_JPRB,7.3316E-01_JPRB,8.2574E-01_JPRB,8.9339E-01_JPRB,9.2578E-01_JPRB,&
&9.3666E-01_JPRB,8.9172E-01_JPRB,9.0627E-01_JPRB,9.2412E-01_JPRB/)
KAO( :, 3, 2,10) = (/&
&9.4869E-01_JPRB,8.7312E-01_JPRB,8.9992E-01_JPRB,1.0108E+00_JPRB,1.0906E+00_JPRB,1.1228E+00_JPRB,&
&1.1184E+00_JPRB,1.0532E+00_JPRB,1.0816E+00_JPRB,1.1050E+00_JPRB/)
KAO( :, 4, 2,10) = (/&
&1.1182E+00_JPRB,1.0333E+00_JPRB,1.0816E+00_JPRB,1.2099E+00_JPRB,1.2991E+00_JPRB,1.3295E+00_JPRB,&
&1.3183E+00_JPRB,1.2305E+00_JPRB,1.2865E+00_JPRB,1.3109E+00_JPRB/)
KAO( :, 5, 2,10) = (/&
&1.2953E+00_JPRB,1.2046E+00_JPRB,1.2743E+00_JPRB,1.4197E+00_JPRB,1.5179E+00_JPRB,1.5565E+00_JPRB,&
&1.5463E+00_JPRB,1.4061E+00_JPRB,1.5050E+00_JPRB,1.5282E+00_JPRB/)
KAO( :, 1, 3,10) = (/&
&6.2757E-01_JPRB,5.7473E-01_JPRB,5.5914E-01_JPRB,5.8172E-01_JPRB,6.2887E-01_JPRB,6.5014E-01_JPRB,&
&6.7802E-01_JPRB,6.5904E-01_JPRB,6.5934E-01_JPRB,6.7295E-01_JPRB/)
KAO( :, 2, 3,10) = (/&
&7.8418E-01_JPRB,7.1588E-01_JPRB,7.0607E-01_JPRB,7.4238E-01_JPRB,8.0014E-01_JPRB,8.1822E-01_JPRB,&
&8.4016E-01_JPRB,8.0936E-01_JPRB,8.1484E-01_JPRB,8.2805E-01_JPRB/)
KAO( :, 3, 3,10) = (/&
&9.6014E-01_JPRB,8.7612E-01_JPRB,8.6845E-01_JPRB,9.2232E-01_JPRB,9.9214E-01_JPRB,9.9810E-01_JPRB,&
&1.0104E+00_JPRB,9.7306E-01_JPRB,9.8869E-01_JPRB,1.0030E+00_JPRB/)
KAO( :, 4, 3,10) = (/&
&1.1436E+00_JPRB,1.0500E+00_JPRB,1.0473E+00_JPRB,1.1216E+00_JPRB,1.1992E+00_JPRB,1.1909E+00_JPRB,&
&1.1979E+00_JPRB,1.1493E+00_JPRB,1.1843E+00_JPRB,1.2028E+00_JPRB/)
KAO( :, 5, 3,10) = (/&
&1.3363E+00_JPRB,1.2288E+00_JPRB,1.2400E+00_JPRB,1.3328E+00_JPRB,1.4189E+00_JPRB,1.4085E+00_JPRB,&
&1.4054E+00_JPRB,1.3326E+00_JPRB,1.3952E+00_JPRB,1.4190E+00_JPRB/)
KAO( :, 1, 4,10) = (/&
&6.0902E-01_JPRB,5.5865E-01_JPRB,5.2875E-01_JPRB,5.1792E-01_JPRB,5.4518E-01_JPRB,5.6325E-01_JPRB,&
&5.8877E-01_JPRB,5.8387E-01_JPRB,5.8206E-01_JPRB,5.9308E-01_JPRB/)
KAO( :, 2, 4,10) = (/&
&7.6140E-01_JPRB,6.9912E-01_JPRB,6.7757E-01_JPRB,6.6690E-01_JPRB,7.0327E-01_JPRB,7.2305E-01_JPRB,&
&7.4172E-01_JPRB,7.2030E-01_JPRB,7.2068E-01_JPRB,7.3161E-01_JPRB/)
KAO( :, 3, 4,10) = (/&
&9.4002E-01_JPRB,8.6365E-01_JPRB,8.4366E-01_JPRB,8.3795E-01_JPRB,8.8109E-01_JPRB,8.9279E-01_JPRB,&
&9.0652E-01_JPRB,8.7018E-01_JPRB,8.7595E-01_JPRB,8.8773E-01_JPRB/)
KAO( :, 4, 4,10) = (/&
&1.1361E+00_JPRB,1.0471E+00_JPRB,1.0239E+00_JPRB,1.0291E+00_JPRB,1.0729E+00_JPRB,1.0769E+00_JPRB,&
&1.0898E+00_JPRB,1.0370E+00_JPRB,1.0554E+00_JPRB,1.0680E+00_JPRB/)
KAO( :, 5, 4,10) = (/&
&1.3459E+00_JPRB,1.2415E+00_JPRB,1.2200E+00_JPRB,1.2343E+00_JPRB,1.2811E+00_JPRB,1.2812E+00_JPRB,&
&1.2941E+00_JPRB,1.2225E+00_JPRB,1.2598E+00_JPRB,1.2702E+00_JPRB/)
KAO( :, 1, 5,10) = (/&
&5.7515E-01_JPRB,5.3232E-01_JPRB,5.0391E-01_JPRB,4.7978E-01_JPRB,4.6984E-01_JPRB,4.8839E-01_JPRB,&
&5.1587E-01_JPRB,5.0590E-01_JPRB,5.0049E-01_JPRB,4.9518E-01_JPRB/)
KAO( :, 2, 5,10) = (/&
&7.3128E-01_JPRB,6.7406E-01_JPRB,6.4811E-01_JPRB,6.2049E-01_JPRB,6.1868E-01_JPRB,6.3401E-01_JPRB,&
&6.5439E-01_JPRB,6.3488E-01_JPRB,6.3015E-01_JPRB,6.2410E-01_JPRB/)
KAO( :, 3, 5,10) = (/&
&9.0920E-01_JPRB,8.3759E-01_JPRB,8.1835E-01_JPRB,7.8435E-01_JPRB,7.8487E-01_JPRB,7.9695E-01_JPRB,&
&8.0516E-01_JPRB,7.7727E-01_JPRB,7.7504E-01_JPRB,7.7636E-01_JPRB/)
KAO( :, 4, 5,10) = (/&
&1.1099E+00_JPRB,1.0245E+00_JPRB,1.0070E+00_JPRB,9.7052E-01_JPRB,9.6348E-01_JPRB,9.7780E-01_JPRB,&
&9.7649E-01_JPRB,9.3660E-01_JPRB,9.3973E-01_JPRB,9.4451E-01_JPRB/)
KAO( :, 5, 5,10) = (/&
&1.3305E+00_JPRB,1.2272E+00_JPRB,1.2112E+00_JPRB,1.1732E+00_JPRB,1.1594E+00_JPRB,1.1784E+00_JPRB,&
&1.1704E+00_JPRB,1.1112E+00_JPRB,1.1263E+00_JPRB,1.1272E+00_JPRB/)
KAO( :, 1, 6,10) = (/&
&5.3624E-01_JPRB,4.9966E-01_JPRB,4.7124E-01_JPRB,4.4396E-01_JPRB,4.1309E-01_JPRB,4.1799E-01_JPRB,&
&4.3204E-01_JPRB,4.1689E-01_JPRB,4.0796E-01_JPRB,4.0296E-01_JPRB/)
KAO( :, 2, 6,10) = (/&
&6.9086E-01_JPRB,6.4214E-01_JPRB,6.1471E-01_JPRB,5.8168E-01_JPRB,5.4576E-01_JPRB,5.5331E-01_JPRB,&
&5.6106E-01_JPRB,5.3207E-01_JPRB,5.1983E-01_JPRB,5.1381E-01_JPRB/)
KAO( :, 3, 6,10) = (/&
&8.6785E-01_JPRB,8.0700E-01_JPRB,7.8156E-01_JPRB,7.4169E-01_JPRB,7.0281E-01_JPRB,7.0090E-01_JPRB,&
&7.0317E-01_JPRB,6.6880E-01_JPRB,6.5685E-01_JPRB,6.4884E-01_JPRB/)
KAO( :, 4, 6,10) = (/&
&1.0625E+00_JPRB,9.9150E-01_JPRB,9.7284E-01_JPRB,9.2583E-01_JPRB,8.7592E-01_JPRB,8.6864E-01_JPRB,&
&8.6733E-01_JPRB,8.2238E-01_JPRB,8.1245E-01_JPRB,8.0011E-01_JPRB/)
KAO( :, 5, 6,10) = (/&
&1.2823E+00_JPRB,1.1975E+00_JPRB,1.1856E+00_JPRB,1.1255E+00_JPRB,1.0659E+00_JPRB,1.0612E+00_JPRB,&
&1.0498E+00_JPRB,9.8546E-01_JPRB,9.8371E-01_JPRB,9.6751E-01_JPRB/)
KAO( :, 1, 7,10) = (/&
&4.8822E-01_JPRB,4.5431E-01_JPRB,4.2346E-01_JPRB,3.9680E-01_JPRB,3.7415E-01_JPRB,3.5071E-01_JPRB,&
&3.5118E-01_JPRB,3.4152E-01_JPRB,3.3119E-01_JPRB,3.2558E-01_JPRB/)
KAO( :, 2, 7,10) = (/&
&6.4341E-01_JPRB,5.9836E-01_JPRB,5.6565E-01_JPRB,5.3167E-01_JPRB,5.0027E-01_JPRB,4.7116E-01_JPRB,&
&4.6350E-01_JPRB,4.4353E-01_JPRB,4.2884E-01_JPRB,4.2493E-01_JPRB/)
KAO( :, 3, 7,10) = (/&
&8.2158E-01_JPRB,7.6606E-01_JPRB,7.3098E-01_JPRB,6.8632E-01_JPRB,6.4732E-01_JPRB,6.1167E-01_JPRB,&
&5.9535E-01_JPRB,5.6548E-01_JPRB,5.4739E-01_JPRB,5.4288E-01_JPRB/)
KAO( :, 4, 7,10) = (/&
&1.0179E+00_JPRB,9.5156E-01_JPRB,9.1785E-01_JPRB,8.6567E-01_JPRB,8.1404E-01_JPRB,7.7261E-01_JPRB,&
&7.5332E-01_JPRB,7.0277E-01_JPRB,6.8164E-01_JPRB,6.6834E-01_JPRB/)
KAO( :, 5, 7,10) = (/&
&1.2332E+00_JPRB,1.1568E+00_JPRB,1.1270E+00_JPRB,1.0643E+00_JPRB,1.0019E+00_JPRB,9.5490E-01_JPRB,&
&9.2760E-01_JPRB,8.5293E-01_JPRB,8.3234E-01_JPRB,8.1269E-01_JPRB/)
KAO( :, 1, 8,10) = (/&
&4.2698E-01_JPRB,3.9591E-01_JPRB,3.6905E-01_JPRB,3.5247E-01_JPRB,3.3247E-01_JPRB,3.0233E-01_JPRB,&
&2.8539E-01_JPRB,2.7613E-01_JPRB,2.6380E-01_JPRB,2.5566E-01_JPRB/)
KAO( :, 2, 8,10) = (/&
&5.7792E-01_JPRB,5.3599E-01_JPRB,5.0504E-01_JPRB,4.7965E-01_JPRB,4.5454E-01_JPRB,4.1047E-01_JPRB,&
&3.8401E-01_JPRB,3.6795E-01_JPRB,3.5022E-01_JPRB,3.4085E-01_JPRB/)
KAO( :, 3, 8,10) = (/&
&7.5312E-01_JPRB,7.0208E-01_JPRB,6.6433E-01_JPRB,6.2807E-01_JPRB,5.9800E-01_JPRB,5.3750E-01_JPRB,&
&5.0237E-01_JPRB,4.7916E-01_JPRB,4.5629E-01_JPRB,4.4355E-01_JPRB/)
KAO( :, 4, 8,10) = (/&
&9.4927E-01_JPRB,8.8669E-01_JPRB,8.4547E-01_JPRB,8.0194E-01_JPRB,7.5725E-01_JPRB,6.9205E-01_JPRB,&
&6.4511E-01_JPRB,6.0026E-01_JPRB,5.7127E-01_JPRB,5.5530E-01_JPRB/)
KAO( :, 5, 8,10) = (/&
&1.1639E+00_JPRB,1.0911E+00_JPRB,1.0454E+00_JPRB,9.9552E-01_JPRB,9.4083E-01_JPRB,8.6800E-01_JPRB,&
&8.0258E-01_JPRB,7.3309E-01_JPRB,6.9987E-01_JPRB,6.8251E-01_JPRB/)
KAO( :, 1, 9,10) = (/&
&3.5900E-01_JPRB,3.3445E-01_JPRB,3.1730E-01_JPRB,3.0609E-01_JPRB,2.8916E-01_JPRB,2.6120E-01_JPRB,&
&2.3361E-01_JPRB,2.1576E-01_JPRB,2.0240E-01_JPRB,3.1625E-01_JPRB/)
KAO( :, 2, 9,10) = (/&
&4.9875E-01_JPRB,4.6530E-01_JPRB,4.4401E-01_JPRB,4.2786E-01_JPRB,4.0336E-01_JPRB,3.6326E-01_JPRB,&
&3.2063E-01_JPRB,2.9583E-01_JPRB,2.7549E-01_JPRB,3.9596E-01_JPRB/)
KAO( :, 3, 9,10) = (/&
&6.6489E-01_JPRB,6.2199E-01_JPRB,5.9558E-01_JPRB,5.7021E-01_JPRB,5.3875E-01_JPRB,4.8355E-01_JPRB,&
&4.2692E-01_JPRB,3.9415E-01_JPRB,3.6637E-01_JPRB,4.8553E-01_JPRB/)
KAO( :, 4, 9,10) = (/&
&8.5340E-01_JPRB,8.0059E-01_JPRB,7.6830E-01_JPRB,7.3710E-01_JPRB,6.9306E-01_JPRB,6.2454E-01_JPRB,&
&5.5697E-01_JPRB,5.0419E-01_JPRB,4.6742E-01_JPRB,5.7732E-01_JPRB/)
KAO( :, 5, 9,10) = (/&
&1.0646E+00_JPRB,1.0028E+00_JPRB,9.6218E-01_JPRB,9.2180E-01_JPRB,8.7012E-01_JPRB,7.9202E-01_JPRB,&
&6.9796E-01_JPRB,6.2710E-01_JPRB,5.8174E-01_JPRB,6.5582E-01_JPRB/)
KAO( :, 1,10,10) = (/&
&3.0304E-01_JPRB,2.8397E-01_JPRB,2.7440E-01_JPRB,2.6814E-01_JPRB,2.5119E-01_JPRB,2.2864E-01_JPRB,&
&1.9712E-01_JPRB,1.7067E-01_JPRB,1.5439E-01_JPRB,6.7616E-01_JPRB/)
KAO( :, 2,10,10) = (/&
&4.3039E-01_JPRB,4.0463E-01_JPRB,3.9135E-01_JPRB,3.8116E-01_JPRB,3.5873E-01_JPRB,3.2509E-01_JPRB,&
&2.7758E-01_JPRB,2.3881E-01_JPRB,2.1708E-01_JPRB,7.4040E-01_JPRB/)
KAO( :, 3,10,10) = (/&
&5.8308E-01_JPRB,5.5089E-01_JPRB,5.3392E-01_JPRB,5.1881E-01_JPRB,4.8588E-01_JPRB,4.3969E-01_JPRB,&
&3.7659E-01_JPRB,3.2471E-01_JPRB,2.9357E-01_JPRB,8.1103E-01_JPRB/)
KAO( :, 4,10,10) = (/&
&7.6072E-01_JPRB,7.2098E-01_JPRB,6.9990E-01_JPRB,6.8047E-01_JPRB,6.3309E-01_JPRB,5.7383E-01_JPRB,&
&4.9589E-01_JPRB,4.2336E-01_JPRB,3.8001E-01_JPRB,8.9328E-01_JPRB/)
KAO( :, 5,10,10) = (/&
&9.6027E-01_JPRB,9.1775E-01_JPRB,8.8924E-01_JPRB,8.5893E-01_JPRB,8.0372E-01_JPRB,7.2911E-01_JPRB,&
&6.3058E-01_JPRB,5.3610E-01_JPRB,4.7858E-01_JPRB,1.0024E+00_JPRB/)
KAO( :, 1,11,10) = (/&
&2.9953E-01_JPRB,2.8331E-01_JPRB,2.7926E-01_JPRB,2.7321E-01_JPRB,2.5698E-01_JPRB,2.3318E-01_JPRB,&
&1.9872E-01_JPRB,1.5868E-01_JPRB,1.3779E-01_JPRB,1.1107E+00_JPRB/)
KAO( :, 2,11,10) = (/&
&4.2474E-01_JPRB,4.0404E-01_JPRB,3.9781E-01_JPRB,3.8780E-01_JPRB,3.6438E-01_JPRB,3.3087E-01_JPRB,&
&2.8103E-01_JPRB,2.2386E-01_JPRB,1.9434E-01_JPRB,1.2029E+00_JPRB/)
KAO( :, 3,11,10) = (/&
&5.7442E-01_JPRB,5.4924E-01_JPRB,5.3961E-01_JPRB,5.2667E-01_JPRB,4.9259E-01_JPRB,4.4653E-01_JPRB,&
&3.8245E-01_JPRB,3.0341E-01_JPRB,2.6142E-01_JPRB,1.2915E+00_JPRB/)
KAO( :, 4,11,10) = (/&
&7.4813E-01_JPRB,7.2159E-01_JPRB,7.0602E-01_JPRB,6.8759E-01_JPRB,6.4029E-01_JPRB,5.8462E-01_JPRB,&
&4.9983E-01_JPRB,3.9642E-01_JPRB,3.3795E-01_JPRB,1.3704E+00_JPRB/)
KAO( :, 5,11,10) = (/&
&9.4256E-01_JPRB,9.1581E-01_JPRB,8.9684E-01_JPRB,8.6915E-01_JPRB,8.1278E-01_JPRB,7.3805E-01_JPRB,&
&6.3353E-01_JPRB,5.0310E-01_JPRB,4.2644E-01_JPRB,1.4638E+00_JPRB/)
KAO( :, 1,12,10) = (/&
&2.9002E-01_JPRB,2.7890E-01_JPRB,2.8045E-01_JPRB,2.7244E-01_JPRB,2.5769E-01_JPRB,2.3303E-01_JPRB,&
&1.9729E-01_JPRB,1.5119E-01_JPRB,1.2251E-01_JPRB,1.4129E+00_JPRB/)
KAO( :, 2,12,10) = (/&
&4.1026E-01_JPRB,3.9679E-01_JPRB,3.9830E-01_JPRB,3.8652E-01_JPRB,3.6420E-01_JPRB,3.2847E-01_JPRB,&
&2.8036E-01_JPRB,2.1376E-01_JPRB,1.7058E-01_JPRB,1.5197E+00_JPRB/)
KAO( :, 3,12,10) = (/&
&5.5455E-01_JPRB,5.4038E-01_JPRB,5.4011E-01_JPRB,5.2208E-01_JPRB,4.9107E-01_JPRB,4.4447E-01_JPRB,&
&3.8090E-01_JPRB,2.8868E-01_JPRB,2.2751E-01_JPRB,1.6225E+00_JPRB/)
KAO( :, 4,12,10) = (/&
&7.2014E-01_JPRB,7.0695E-01_JPRB,7.0633E-01_JPRB,6.7903E-01_JPRB,6.3973E-01_JPRB,5.8007E-01_JPRB,&
&4.9576E-01_JPRB,3.7656E-01_JPRB,2.9460E-01_JPRB,1.7134E+00_JPRB/)
KAO( :, 5,12,10) = (/&
&9.0944E-01_JPRB,8.9423E-01_JPRB,8.9075E-01_JPRB,8.5941E-01_JPRB,8.0946E-01_JPRB,7.3161E-01_JPRB,&
&6.2652E-01_JPRB,4.7880E-01_JPRB,3.7532E-01_JPRB,1.8224E+00_JPRB/)
KAO( :, 1,13,10) = (/&
&2.7340E-01_JPRB,2.7076E-01_JPRB,2.7526E-01_JPRB,2.6770E-01_JPRB,2.5179E-01_JPRB,2.2675E-01_JPRB,&
&1.9245E-01_JPRB,1.4682E-01_JPRB,1.0619E-01_JPRB,1.4210E+00_JPRB/)
KAO( :, 2,13,10) = (/&
&3.8641E-01_JPRB,3.8425E-01_JPRB,3.8930E-01_JPRB,3.7816E-01_JPRB,3.5501E-01_JPRB,3.1994E-01_JPRB,&
&2.7350E-01_JPRB,2.0671E-01_JPRB,1.4761E-01_JPRB,1.5251E+00_JPRB/)
KAO( :, 3,13,10) = (/&
&5.2089E-01_JPRB,5.2113E-01_JPRB,5.2738E-01_JPRB,5.0973E-01_JPRB,4.7827E-01_JPRB,4.3346E-01_JPRB,&
&3.6991E-01_JPRB,2.7849E-01_JPRB,1.9608E-01_JPRB,1.6238E+00_JPRB/)
KAO( :, 4,13,10) = (/&
&6.7786E-01_JPRB,6.7938E-01_JPRB,6.8608E-01_JPRB,6.6233E-01_JPRB,6.2421E-01_JPRB,5.6410E-01_JPRB,&
&4.8140E-01_JPRB,3.6259E-01_JPRB,2.5473E-01_JPRB,1.7230E+00_JPRB/)
KAO( :, 5,13,10) = (/&
&8.5711E-01_JPRB,8.6068E-01_JPRB,8.6472E-01_JPRB,8.3617E-01_JPRB,7.8602E-01_JPRB,7.1217E-01_JPRB,&
&6.0760E-01_JPRB,4.5966E-01_JPRB,3.2905E-01_JPRB,1.8345E+00_JPRB/)
KAO( :, 1, 1,11) = (/&
&9.4159E-01_JPRB,8.6910E-01_JPRB,9.4939E-01_JPRB,1.0309E+00_JPRB,1.0971E+00_JPRB,1.1597E+00_JPRB,&
&1.1573E+00_JPRB,1.0198E+00_JPRB,1.1259E+00_JPRB,1.1444E+00_JPRB/)
KAO( :, 2, 1,11) = (/&
&1.1816E+00_JPRB,1.0903E+00_JPRB,1.1681E+00_JPRB,1.2491E+00_JPRB,1.3524E+00_JPRB,1.4252E+00_JPRB,&
&1.4017E+00_JPRB,1.2548E+00_JPRB,1.3885E+00_JPRB,1.4161E+00_JPRB/)
KAO( :, 3, 1,11) = (/&
&1.4457E+00_JPRB,1.3338E+00_JPRB,1.4098E+00_JPRB,1.4943E+00_JPRB,1.6257E+00_JPRB,1.6966E+00_JPRB,&
&1.6615E+00_JPRB,1.5145E+00_JPRB,1.6823E+00_JPRB,1.7160E+00_JPRB/)
KAO( :, 4, 1,11) = (/&
&1.7261E+00_JPRB,1.5936E+00_JPRB,1.6676E+00_JPRB,1.7640E+00_JPRB,1.9034E+00_JPRB,1.9816E+00_JPRB,&
&1.9375E+00_JPRB,1.7904E+00_JPRB,1.9915E+00_JPRB,2.0290E+00_JPRB/)
KAO( :, 5, 1,11) = (/&
&2.0222E+00_JPRB,1.8664E+00_JPRB,1.9402E+00_JPRB,2.0588E+00_JPRB,2.1886E+00_JPRB,2.2719E+00_JPRB,&
&2.2171E+00_JPRB,2.1130E+00_JPRB,2.3320E+00_JPRB,2.3861E+00_JPRB/)
KAO( :, 1, 2,11) = (/&
&8.8414E-01_JPRB,8.3470E-01_JPRB,9.0122E-01_JPRB,9.8198E-01_JPRB,1.0450E+00_JPRB,1.0902E+00_JPRB,&
&1.0770E+00_JPRB,9.4855E-01_JPRB,1.0386E+00_JPRB,1.0581E+00_JPRB/)
KAO( :, 2, 2,11) = (/&
&1.1143E+00_JPRB,1.0550E+00_JPRB,1.1151E+00_JPRB,1.2176E+00_JPRB,1.3030E+00_JPRB,1.3437E+00_JPRB,&
&1.3207E+00_JPRB,1.1746E+00_JPRB,1.3022E+00_JPRB,1.3229E+00_JPRB/)
KAO( :, 3, 2,11) = (/&
&1.3705E+00_JPRB,1.3001E+00_JPRB,1.3557E+00_JPRB,1.4797E+00_JPRB,1.5774E+00_JPRB,1.6133E+00_JPRB,&
&1.5892E+00_JPRB,1.4167E+00_JPRB,1.5912E+00_JPRB,1.6096E+00_JPRB/)
KAO( :, 4, 2,11) = (/&
&1.6529E+00_JPRB,1.5667E+00_JPRB,1.6252E+00_JPRB,1.7602E+00_JPRB,1.8638E+00_JPRB,1.8995E+00_JPRB,&
&1.8687E+00_JPRB,1.6782E+00_JPRB,1.8967E+00_JPRB,1.9189E+00_JPRB/)
KAO( :, 5, 2,11) = (/&
&1.9543E+00_JPRB,1.8492E+00_JPRB,1.9198E+00_JPRB,2.0574E+00_JPRB,2.1583E+00_JPRB,2.1944E+00_JPRB,&
&2.1594E+00_JPRB,1.9939E+00_JPRB,2.2472E+00_JPRB,2.2791E+00_JPRB/)
KAO( :, 1, 3,11) = (/&
&8.1869E-01_JPRB,7.7023E-01_JPRB,8.2109E-01_JPRB,8.8336E-01_JPRB,9.2805E-01_JPRB,9.6128E-01_JPRB,&
&9.4856E-01_JPRB,8.5843E-01_JPRB,9.1983E-01_JPRB,9.4743E-01_JPRB/)
KAO( :, 2, 3,11) = (/&
&1.0389E+00_JPRB,9.8615E-01_JPRB,1.0345E+00_JPRB,1.1256E+00_JPRB,1.1752E+00_JPRB,1.2020E+00_JPRB,&
&1.1857E+00_JPRB,1.0608E+00_JPRB,1.1599E+00_JPRB,1.1854E+00_JPRB/)
KAO( :, 3, 3,11) = (/&
&1.2826E+00_JPRB,1.2250E+00_JPRB,1.2747E+00_JPRB,1.3968E+00_JPRB,1.4383E+00_JPRB,1.4671E+00_JPRB,&
&1.4487E+00_JPRB,1.2721E+00_JPRB,1.4175E+00_JPRB,1.4350E+00_JPRB/)
KAO( :, 4, 3,11) = (/&
&1.5564E+00_JPRB,1.4865E+00_JPRB,1.5447E+00_JPRB,1.6881E+00_JPRB,1.7201E+00_JPRB,1.7557E+00_JPRB,&
&1.7225E+00_JPRB,1.5035E+00_JPRB,1.6929E+00_JPRB,1.7100E+00_JPRB/)
KAO( :, 5, 3,11) = (/&
&1.8539E+00_JPRB,1.7704E+00_JPRB,1.8370E+00_JPRB,1.9889E+00_JPRB,2.0183E+00_JPRB,2.0511E+00_JPRB,&
&2.0075E+00_JPRB,1.7816E+00_JPRB,2.0126E+00_JPRB,2.0331E+00_JPRB/)
KAO( :, 1, 4,11) = (/&
&7.6497E-01_JPRB,7.1076E-01_JPRB,7.3295E-01_JPRB,7.7006E-01_JPRB,7.9642E-01_JPRB,8.2481E-01_JPRB,&
&8.2608E-01_JPRB,7.5993E-01_JPRB,8.0777E-01_JPRB,8.2848E-01_JPRB/)
KAO( :, 2, 4,11) = (/&
&9.8352E-01_JPRB,9.1857E-01_JPRB,9.4611E-01_JPRB,1.0073E+00_JPRB,1.0282E+00_JPRB,1.0497E+00_JPRB,&
&1.0467E+00_JPRB,9.5389E-01_JPRB,1.0316E+00_JPRB,1.0517E+00_JPRB/)
KAO( :, 3, 4,11) = (/&
&1.2292E+00_JPRB,1.1512E+00_JPRB,1.1846E+00_JPRB,1.2709E+00_JPRB,1.2824E+00_JPRB,1.3065E+00_JPRB,&
&1.2899E+00_JPRB,1.1574E+00_JPRB,1.2650E+00_JPRB,1.2904E+00_JPRB/)
KAO( :, 4, 4,11) = (/&
&1.5012E+00_JPRB,1.4093E+00_JPRB,1.4510E+00_JPRB,1.5565E+00_JPRB,1.5637E+00_JPRB,1.5870E+00_JPRB,&
&1.5399E+00_JPRB,1.3774E+00_JPRB,1.5183E+00_JPRB,1.5518E+00_JPRB/)
KAO( :, 5, 4,11) = (/&
&1.7934E+00_JPRB,1.6886E+00_JPRB,1.7434E+00_JPRB,1.8620E+00_JPRB,1.8667E+00_JPRB,1.8779E+00_JPRB,&
&1.8058E+00_JPRB,1.6243E+00_JPRB,1.8061E+00_JPRB,1.8476E+00_JPRB/)
KAO( :, 1, 5,11) = (/&
&7.4548E-01_JPRB,6.7814E-01_JPRB,6.5476E-01_JPRB,6.5948E-01_JPRB,6.7934E-01_JPRB,7.0788E-01_JPRB,&
&7.1745E-01_JPRB,6.7353E-01_JPRB,7.0461E-01_JPRB,7.3099E-01_JPRB/)
KAO( :, 2, 5,11) = (/&
&9.5969E-01_JPRB,8.7825E-01_JPRB,8.6017E-01_JPRB,8.8155E-01_JPRB,8.9239E-01_JPRB,9.1670E-01_JPRB,&
&9.2708E-01_JPRB,8.5000E-01_JPRB,9.0728E-01_JPRB,9.3032E-01_JPRB/)
KAO( :, 3, 5,11) = (/&
&1.2058E+00_JPRB,1.1099E+00_JPRB,1.0960E+00_JPRB,1.1330E+00_JPRB,1.1377E+00_JPRB,1.1558E+00_JPRB,&
&1.1565E+00_JPRB,1.0416E+00_JPRB,1.1278E+00_JPRB,1.1476E+00_JPRB/)
KAO( :, 4, 5,11) = (/&
&1.4810E+00_JPRB,1.3671E+00_JPRB,1.3639E+00_JPRB,1.4095E+00_JPRB,1.4162E+00_JPRB,1.4159E+00_JPRB,&
&1.3960E+00_JPRB,1.2531E+00_JPRB,1.3726E+00_JPRB,1.3940E+00_JPRB/)
KAO( :, 5, 5,11) = (/&
&1.7798E+00_JPRB,1.6471E+00_JPRB,1.6584E+00_JPRB,1.7100E+00_JPRB,1.7173E+00_JPRB,1.6890E+00_JPRB,&
&1.6525E+00_JPRB,1.4879E+00_JPRB,1.6471E+00_JPRB,1.6748E+00_JPRB/)
KAO( :, 1, 6,11) = (/&
&7.0565E-01_JPRB,6.4191E-01_JPRB,5.9174E-01_JPRB,5.6344E-01_JPRB,5.7413E-01_JPRB,6.0216E-01_JPRB,&
&6.1735E-01_JPRB,5.8882E-01_JPRB,6.1391E-01_JPRB,6.2532E-01_JPRB/)
KAO( :, 2, 6,11) = (/&
&9.2376E-01_JPRB,8.4064E-01_JPRB,7.8353E-01_JPRB,7.6203E-01_JPRB,7.6995E-01_JPRB,7.9470E-01_JPRB,&
&8.0774E-01_JPRB,7.5710E-01_JPRB,7.9836E-01_JPRB,8.1211E-01_JPRB/)
KAO( :, 3, 6,11) = (/&
&1.1735E+00_JPRB,1.0693E+00_JPRB,1.0163E+00_JPRB,9.9460E-01_JPRB,1.0005E+00_JPRB,1.0222E+00_JPRB,&
&1.0221E+00_JPRB,9.3247E-01_JPRB,9.9633E-01_JPRB,1.0096E+00_JPRB/)
KAO( :, 4, 6,11) = (/&
&1.4611E+00_JPRB,1.3294E+00_JPRB,1.2780E+00_JPRB,1.2558E+00_JPRB,1.2632E+00_JPRB,1.2674E+00_JPRB,&
&1.2528E+00_JPRB,1.1244E+00_JPRB,1.2175E+00_JPRB,1.2339E+00_JPRB/)
KAO( :, 5, 6,11) = (/&
&1.7762E+00_JPRB,1.6171E+00_JPRB,1.5645E+00_JPRB,1.5462E+00_JPRB,1.5483E+00_JPRB,1.5299E+00_JPRB,&
&1.5045E+00_JPRB,1.3389E+00_JPRB,1.4702E+00_JPRB,1.4860E+00_JPRB/)
KAO( :, 1, 7,11) = (/&
&6.4397E-01_JPRB,5.8848E-01_JPRB,5.4164E-01_JPRB,5.0438E-01_JPRB,4.8904E-01_JPRB,5.1205E-01_JPRB,&
&5.2888E-01_JPRB,4.9547E-01_JPRB,5.1219E-01_JPRB,5.1357E-01_JPRB/)
KAO( :, 2, 7,11) = (/&
&8.6014E-01_JPRB,7.8541E-01_JPRB,7.2738E-01_JPRB,6.8109E-01_JPRB,6.6447E-01_JPRB,6.8735E-01_JPRB,&
&7.0610E-01_JPRB,6.4880E-01_JPRB,6.8044E-01_JPRB,6.7457E-01_JPRB/)
KAO( :, 3, 7,11) = (/&
&1.1052E+00_JPRB,1.0089E+00_JPRB,9.5053E-01_JPRB,8.9433E-01_JPRB,8.7834E-01_JPRB,8.9637E-01_JPRB,&
&9.0307E-01_JPRB,8.1519E-01_JPRB,8.6489E-01_JPRB,8.5495E-01_JPRB/)
KAO( :, 4, 7,11) = (/&
&1.3894E+00_JPRB,1.2661E+00_JPRB,1.2117E+00_JPRB,1.1436E+00_JPRB,1.1239E+00_JPRB,1.1302E+00_JPRB,&
&1.1159E+00_JPRB,1.0009E+00_JPRB,1.0705E+00_JPRB,1.0686E+00_JPRB/)
KAO( :, 5, 7,11) = (/&
&1.7112E+00_JPRB,1.5598E+00_JPRB,1.4999E+00_JPRB,1.4251E+00_JPRB,1.3915E+00_JPRB,1.3874E+00_JPRB,&
&1.3517E+00_JPRB,1.2058E+00_JPRB,1.3049E+00_JPRB,1.3059E+00_JPRB/)
KAO( :, 1, 8,11) = (/&
&5.7879E-01_JPRB,5.3274E-01_JPRB,4.8973E-01_JPRB,4.5630E-01_JPRB,4.3269E-01_JPRB,4.3284E-01_JPRB,&
&4.3930E-01_JPRB,4.0946E-01_JPRB,4.1860E-01_JPRB,4.1655E-01_JPRB/)
KAO( :, 2, 8,11) = (/&
&7.8913E-01_JPRB,7.2614E-01_JPRB,6.7155E-01_JPRB,6.2927E-01_JPRB,5.8919E-01_JPRB,5.9377E-01_JPRB,&
&5.9849E-01_JPRB,5.4629E-01_JPRB,5.6116E-01_JPRB,5.5524E-01_JPRB/)
KAO( :, 3, 8,11) = (/&
&1.0315E+00_JPRB,9.4848E-01_JPRB,8.8923E-01_JPRB,8.3184E-01_JPRB,7.8312E-01_JPRB,7.8922E-01_JPRB,&
&7.8217E-01_JPRB,6.9528E-01_JPRB,7.2027E-01_JPRB,7.1126E-01_JPRB/)
KAO( :, 4, 8,11) = (/&
&1.3089E+00_JPRB,1.2030E+00_JPRB,1.1421E+00_JPRB,1.0710E+00_JPRB,1.0184E+00_JPRB,1.0078E+00_JPRB,&
&9.8494E-01_JPRB,8.6981E-01_JPRB,9.1055E-01_JPRB,9.0117E-01_JPRB/)
KAO( :, 5, 8,11) = (/&
&1.6233E+00_JPRB,1.4930E+00_JPRB,1.4334E+00_JPRB,1.3459E+00_JPRB,1.2797E+00_JPRB,1.2512E+00_JPRB,&
&1.2155E+00_JPRB,1.0647E+00_JPRB,1.1303E+00_JPRB,1.1143E+00_JPRB/)
KAO( :, 1, 9,11) = (/&
&5.0872E-01_JPRB,4.7000E-01_JPRB,4.3189E-01_JPRB,4.0703E-01_JPRB,3.8347E-01_JPRB,3.6637E-01_JPRB,&
&3.5722E-01_JPRB,3.3322E-01_JPRB,3.3519E-01_JPRB,4.9629E-01_JPRB/)
KAO( :, 2, 9,11) = (/&
&7.1032E-01_JPRB,6.5670E-01_JPRB,6.0796E-01_JPRB,5.7264E-01_JPRB,5.3661E-01_JPRB,5.0689E-01_JPRB,&
&4.9599E-01_JPRB,4.5581E-01_JPRB,4.5901E-01_JPRB,6.1504E-01_JPRB/)
KAO( :, 3, 9,11) = (/&
&9.4725E-01_JPRB,8.7492E-01_JPRB,8.2052E-01_JPRB,7.7219E-01_JPRB,7.2220E-01_JPRB,6.8379E-01_JPRB,&
&6.5839E-01_JPRB,5.9352E-01_JPRB,5.9853E-01_JPRB,7.1363E-01_JPRB/)
KAO( :, 4, 9,11) = (/&
&1.2212E+00_JPRB,1.1285E+00_JPRB,1.0680E+00_JPRB,1.0029E+00_JPRB,9.4208E-01_JPRB,8.9072E-01_JPRB,&
&8.4577E-01_JPRB,7.5557E-01_JPRB,7.6527E-01_JPRB,8.0522E-01_JPRB/)
KAO( :, 5, 9,11) = (/&
&1.5263E+00_JPRB,1.4126E+00_JPRB,1.3499E+00_JPRB,1.2718E+00_JPRB,1.1921E+00_JPRB,1.1220E+00_JPRB,&
&1.0685E+00_JPRB,9.3213E-01_JPRB,9.5775E-01_JPRB,9.4303E-01_JPRB/)
KAO( :, 1,10,11) = (/&
&4.4834E-01_JPRB,4.1596E-01_JPRB,3.8519E-01_JPRB,3.6738E-01_JPRB,3.4707E-01_JPRB,3.1667E-01_JPRB,&
&2.9935E-01_JPRB,2.7308E-01_JPRB,2.6993E-01_JPRB,8.6202E-01_JPRB/)
KAO( :, 2,10,11) = (/&
&6.4018E-01_JPRB,5.9476E-01_JPRB,5.5452E-01_JPRB,5.2742E-01_JPRB,4.9444E-01_JPRB,4.5039E-01_JPRB,&
&4.1885E-01_JPRB,3.8235E-01_JPRB,3.7606E-01_JPRB,1.0050E+00_JPRB/)
KAO( :, 3,10,11) = (/&
&8.6941E-01_JPRB,8.0719E-01_JPRB,7.6128E-01_JPRB,7.2083E-01_JPRB,6.7778E-01_JPRB,6.1132E-01_JPRB,&
&5.6485E-01_JPRB,5.0977E-01_JPRB,5.0052E-01_JPRB,1.1879E+00_JPRB/)
KAO( :, 4,10,11) = (/&
&1.1374E+00_JPRB,1.0578E+00_JPRB,1.0048E+00_JPRB,9.4669E-01_JPRB,8.9485E-01_JPRB,8.0262E-01_JPRB,&
&7.3730E-01_JPRB,6.6231E-01_JPRB,6.5210E-01_JPRB,1.3926E+00_JPRB/)
KAO( :, 5,10,11) = (/&
&1.4379E+00_JPRB,1.3398E+00_JPRB,1.2800E+00_JPRB,1.2099E+00_JPRB,1.1369E+00_JPRB,1.0290E+00_JPRB,&
&9.4239E-01_JPRB,8.2621E-01_JPRB,8.2033E-01_JPRB,1.5987E+00_JPRB/)
KAO( :, 1,11,11) = (/&
&4.6437E-01_JPRB,4.3195E-01_JPRB,4.0640E-01_JPRB,3.9083E-01_JPRB,3.6759E-01_JPRB,3.3095E-01_JPRB,&
&2.9621E-01_JPRB,2.6059E-01_JPRB,2.4898E-01_JPRB,1.4424E+00_JPRB/)
KAO( :, 2,11,11) = (/&
&6.5995E-01_JPRB,6.1504E-01_JPRB,5.8354E-01_JPRB,5.6109E-01_JPRB,5.2448E-01_JPRB,4.7076E-01_JPRB,&
&4.1510E-01_JPRB,3.6345E-01_JPRB,3.4571E-01_JPRB,1.5679E+00_JPRB/)
KAO( :, 3,11,11) = (/&
&8.9627E-01_JPRB,8.3726E-01_JPRB,7.9810E-01_JPRB,7.6313E-01_JPRB,7.1561E-01_JPRB,6.3926E-01_JPRB,&
&5.5804E-01_JPRB,4.8959E-01_JPRB,4.6565E-01_JPRB,1.7093E+00_JPRB/)
KAO( :, 4,11,11) = (/&
&1.1695E+00_JPRB,1.0949E+00_JPRB,1.0494E+00_JPRB,9.9979E-01_JPRB,9.3792E-01_JPRB,8.3384E-01_JPRB,&
&7.3304E-01_JPRB,6.3611E-01_JPRB,6.0648E-01_JPRB,1.8687E+00_JPRB/)
KAO( :, 5,11,11) = (/&
&1.4756E+00_JPRB,1.3865E+00_JPRB,1.3306E+00_JPRB,1.2700E+00_JPRB,1.1860E+00_JPRB,1.0648E+00_JPRB,&
&9.3310E-01_JPRB,7.9796E-01_JPRB,7.6114E-01_JPRB,2.0433E+00_JPRB/)
KAO( :, 1,12,11) = (/&
&4.6883E-01_JPRB,4.3992E-01_JPRB,4.2363E-01_JPRB,4.0991E-01_JPRB,3.8267E-01_JPRB,3.4548E-01_JPRB,&
&2.9549E-01_JPRB,2.4606E-01_JPRB,2.2406E-01_JPRB,1.9161E+00_JPRB/)
KAO( :, 2,12,11) = (/&
&6.6619E-01_JPRB,6.2643E-01_JPRB,6.0394E-01_JPRB,5.8416E-01_JPRB,5.4621E-01_JPRB,4.9020E-01_JPRB,&
&4.1568E-01_JPRB,3.4416E-01_JPRB,3.1499E-01_JPRB,2.0541E+00_JPRB/)
KAO( :, 3,12,11) = (/&
&9.0247E-01_JPRB,8.5182E-01_JPRB,8.2328E-01_JPRB,7.9362E-01_JPRB,7.4057E-01_JPRB,6.6249E-01_JPRB,&
&5.6167E-01_JPRB,4.6621E-01_JPRB,4.2576E-01_JPRB,2.2005E+00_JPRB/)
KAO( :, 4,12,11) = (/&
&1.1754E+00_JPRB,1.1141E+00_JPRB,1.0763E+00_JPRB,1.0393E+00_JPRB,9.6314E-01_JPRB,8.6349E-01_JPRB,&
&7.3733E-01_JPRB,6.0555E-01_JPRB,5.5108E-01_JPRB,2.3506E+00_JPRB/)
KAO( :, 5,12,11) = (/&
&1.4816E+00_JPRB,1.4118E+00_JPRB,1.3630E+00_JPRB,1.3109E+00_JPRB,1.2174E+00_JPRB,1.0945E+00_JPRB,&
&9.3470E-01_JPRB,7.6327E-01_JPRB,6.9458E-01_JPRB,2.4817E+00_JPRB/)
KAO( :, 1,13,11) = (/&
&4.6581E-01_JPRB,4.3907E-01_JPRB,4.3125E-01_JPRB,4.2012E-01_JPRB,3.9142E-01_JPRB,3.5288E-01_JPRB,&
&2.9764E-01_JPRB,2.3165E-01_JPRB,2.0022E-01_JPRB,2.0038E+00_JPRB/)
KAO( :, 2,13,11) = (/&
&6.6014E-01_JPRB,6.2525E-01_JPRB,6.1363E-01_JPRB,5.9556E-01_JPRB,5.5565E-01_JPRB,4.9958E-01_JPRB,&
&4.1989E-01_JPRB,3.2603E-01_JPRB,2.8204E-01_JPRB,2.1506E+00_JPRB/)
KAO( :, 3,13,11) = (/&
&8.9162E-01_JPRB,8.4866E-01_JPRB,8.3231E-01_JPRB,8.0747E-01_JPRB,7.5010E-01_JPRB,6.7287E-01_JPRB,&
&5.6952E-01_JPRB,4.4032E-01_JPRB,3.7944E-01_JPRB,2.2963E+00_JPRB/)
KAO( :, 4,13,11) = (/&
&1.1582E+00_JPRB,1.1105E+00_JPRB,1.0865E+00_JPRB,1.0526E+00_JPRB,9.7320E-01_JPRB,8.7688E-01_JPRB,&
&7.4169E-01_JPRB,5.7254E-01_JPRB,4.9090E-01_JPRB,2.4264E+00_JPRB/)
KAO( :, 5,13,11) = (/&
&1.4557E+00_JPRB,1.4054E+00_JPRB,1.3756E+00_JPRB,1.3241E+00_JPRB,1.2283E+00_JPRB,1.1037E+00_JPRB,&
&9.3580E-01_JPRB,7.2342E-01_JPRB,6.1924E-01_JPRB,2.5526E+00_JPRB/)
KAO( :, 1, 1,12) = (/&
&1.9899E+00_JPRB,1.7416E+00_JPRB,1.6557E+00_JPRB,1.6626E+00_JPRB,1.6292E+00_JPRB,1.6186E+00_JPRB,&
&1.5516E+00_JPRB,1.5111E+00_JPRB,1.6515E+00_JPRB,1.6999E+00_JPRB/)
KAO( :, 2, 1,12) = (/&
&2.4167E+00_JPRB,2.1150E+00_JPRB,2.0285E+00_JPRB,2.0154E+00_JPRB,1.9446E+00_JPRB,1.9378E+00_JPRB,&
&1.8912E+00_JPRB,1.8727E+00_JPRB,2.0572E+00_JPRB,2.1137E+00_JPRB/)
KAO( :, 3, 1,12) = (/&
&2.8678E+00_JPRB,2.5098E+00_JPRB,2.4251E+00_JPRB,2.3840E+00_JPRB,2.2898E+00_JPRB,2.2925E+00_JPRB,&
&2.2262E+00_JPRB,2.2528E+00_JPRB,2.4748E+00_JPRB,2.5402E+00_JPRB/)
KAO( :, 4, 1,12) = (/&
&3.3334E+00_JPRB,2.9172E+00_JPRB,2.8340E+00_JPRB,2.7633E+00_JPRB,2.6747E+00_JPRB,2.6799E+00_JPRB,&
&2.5511E+00_JPRB,2.6575E+00_JPRB,2.9171E+00_JPRB,2.9951E+00_JPRB/)
KAO( :, 5, 1,12) = (/&
&3.8070E+00_JPRB,3.3317E+00_JPRB,3.2431E+00_JPRB,3.1434E+00_JPRB,3.0844E+00_JPRB,3.0767E+00_JPRB,&
&2.8871E+00_JPRB,3.0851E+00_JPRB,3.3768E+00_JPRB,3.4700E+00_JPRB/)
KAO( :, 1, 2,12) = (/&
&1.8020E+00_JPRB,1.5771E+00_JPRB,1.5658E+00_JPRB,1.5529E+00_JPRB,1.5678E+00_JPRB,1.5609E+00_JPRB,&
&1.5068E+00_JPRB,1.4322E+00_JPRB,1.5794E+00_JPRB,1.6265E+00_JPRB/)
KAO( :, 2, 2,12) = (/&
&2.2244E+00_JPRB,1.9467E+00_JPRB,1.9376E+00_JPRB,1.8878E+00_JPRB,1.8907E+00_JPRB,1.9156E+00_JPRB,&
&1.8451E+00_JPRB,1.7806E+00_JPRB,1.9775E+00_JPRB,2.0248E+00_JPRB/)
KAO( :, 3, 2,12) = (/&
&2.6777E+00_JPRB,2.3433E+00_JPRB,2.3279E+00_JPRB,2.2466E+00_JPRB,2.2434E+00_JPRB,2.3061E+00_JPRB,&
&2.1731E+00_JPRB,2.1601E+00_JPRB,2.3971E+00_JPRB,2.4544E+00_JPRB/)
KAO( :, 4, 2,12) = (/&
&3.1544E+00_JPRB,2.7605E+00_JPRB,2.7326E+00_JPRB,2.6320E+00_JPRB,2.6342E+00_JPRB,2.7059E+00_JPRB,&
&2.5082E+00_JPRB,2.5770E+00_JPRB,2.8498E+00_JPRB,2.9233E+00_JPRB/)
KAO( :, 5, 2,12) = (/&
&3.6408E+00_JPRB,3.1864E+00_JPRB,3.1392E+00_JPRB,3.0321E+00_JPRB,3.0540E+00_JPRB,3.0950E+00_JPRB,&
&2.8509E+00_JPRB,3.0202E+00_JPRB,3.3350E+00_JPRB,3.4273E+00_JPRB/)
KAO( :, 1, 3,12) = (/&
&1.5649E+00_JPRB,1.3732E+00_JPRB,1.3826E+00_JPRB,1.4020E+00_JPRB,1.4318E+00_JPRB,1.4266E+00_JPRB,&
&1.3676E+00_JPRB,1.2621E+00_JPRB,1.4113E+00_JPRB,1.4411E+00_JPRB/)
KAO( :, 2, 3,12) = (/&
&1.9750E+00_JPRB,1.7323E+00_JPRB,1.7348E+00_JPRB,1.7212E+00_JPRB,1.7704E+00_JPRB,1.7925E+00_JPRB,&
&1.6949E+00_JPRB,1.5960E+00_JPRB,1.7832E+00_JPRB,1.8209E+00_JPRB/)
KAO( :, 3, 3,12) = (/&
&2.4222E+00_JPRB,2.1256E+00_JPRB,2.1157E+00_JPRB,2.0688E+00_JPRB,2.1464E+00_JPRB,2.1852E+00_JPRB,&
&2.0239E+00_JPRB,1.9726E+00_JPRB,2.1958E+00_JPRB,2.2498E+00_JPRB/)
KAO( :, 4, 3,12) = (/&
&2.9000E+00_JPRB,2.5481E+00_JPRB,2.5206E+00_JPRB,2.4500E+00_JPRB,2.5548E+00_JPRB,2.5853E+00_JPRB,&
&2.3675E+00_JPRB,2.3891E+00_JPRB,2.6536E+00_JPRB,2.7238E+00_JPRB/)
KAO( :, 5, 3,12) = (/&
&3.3931E+00_JPRB,2.9865E+00_JPRB,2.9396E+00_JPRB,2.8624E+00_JPRB,2.9741E+00_JPRB,2.9949E+00_JPRB,&
&2.7166E+00_JPRB,2.8252E+00_JPRB,3.1477E+00_JPRB,3.2225E+00_JPRB/)
KAO( :, 1, 4,12) = (/&
&1.3280E+00_JPRB,1.1786E+00_JPRB,1.2003E+00_JPRB,1.2384E+00_JPRB,1.2621E+00_JPRB,1.2623E+00_JPRB,&
&1.2074E+00_JPRB,1.0954E+00_JPRB,1.2178E+00_JPRB,1.2519E+00_JPRB/)
KAO( :, 2, 4,12) = (/&
&1.7214E+00_JPRB,1.5303E+00_JPRB,1.5296E+00_JPRB,1.5581E+00_JPRB,1.6045E+00_JPRB,1.6160E+00_JPRB,&
&1.5191E+00_JPRB,1.4004E+00_JPRB,1.5599E+00_JPRB,1.5995E+00_JPRB/)
KAO( :, 3, 4,12) = (/&
&2.1531E+00_JPRB,1.9184E+00_JPRB,1.8960E+00_JPRB,1.9073E+00_JPRB,1.9909E+00_JPRB,1.9956E+00_JPRB,&
&1.8466E+00_JPRB,1.7529E+00_JPRB,1.9597E+00_JPRB,2.0020E+00_JPRB/)
KAO( :, 4, 4,12) = (/&
&2.6259E+00_JPRB,2.3421E+00_JPRB,2.3006E+00_JPRB,2.2911E+00_JPRB,2.4098E+00_JPRB,2.3862E+00_JPRB,&
&2.2059E+00_JPRB,2.1477E+00_JPRB,2.4083E+00_JPRB,2.4533E+00_JPRB/)
KAO( :, 5, 4,12) = (/&
&3.1312E+00_JPRB,2.7951E+00_JPRB,2.7289E+00_JPRB,2.7098E+00_JPRB,2.8440E+00_JPRB,2.7955E+00_JPRB,&
&2.5674E+00_JPRB,2.5718E+00_JPRB,2.8862E+00_JPRB,2.9375E+00_JPRB/)
KAO( :, 1, 5,12) = (/&
&1.1161E+00_JPRB,1.0073E+00_JPRB,1.0475E+00_JPRB,1.0704E+00_JPRB,1.0924E+00_JPRB,1.0965E+00_JPRB,&
&1.0516E+00_JPRB,9.4881E-01_JPRB,1.0568E+00_JPRB,1.0851E+00_JPRB/)
KAO( :, 2, 5,12) = (/&
&1.4852E+00_JPRB,1.3439E+00_JPRB,1.3607E+00_JPRB,1.3892E+00_JPRB,1.4288E+00_JPRB,1.4308E+00_JPRB,&
&1.3421E+00_JPRB,1.2297E+00_JPRB,1.3696E+00_JPRB,1.4061E+00_JPRB/)
KAO( :, 3, 5,12) = (/&
&1.9072E+00_JPRB,1.7266E+00_JPRB,1.7136E+00_JPRB,1.7495E+00_JPRB,1.8113E+00_JPRB,1.7903E+00_JPRB,&
&1.6625E+00_JPRB,1.5561E+00_JPRB,1.7354E+00_JPRB,1.7786E+00_JPRB/)
KAO( :, 4, 5,12) = (/&
&2.3754E+00_JPRB,2.1543E+00_JPRB,2.1024E+00_JPRB,2.1512E+00_JPRB,2.2237E+00_JPRB,2.1735E+00_JPRB,&
&2.0175E+00_JPRB,1.9176E+00_JPRB,2.1504E+00_JPRB,2.1913E+00_JPRB/)
KAO( :, 5, 5,12) = (/&
&2.8766E+00_JPRB,2.6154E+00_JPRB,2.5264E+00_JPRB,2.5896E+00_JPRB,2.6493E+00_JPRB,2.5886E+00_JPRB,&
&2.3776E+00_JPRB,2.3037E+00_JPRB,2.5969E+00_JPRB,2.6316E+00_JPRB/)
KAO( :, 1, 6,12) = (/&
&9.4985E-01_JPRB,8.5933E-01_JPRB,8.8898E-01_JPRB,9.0232E-01_JPRB,9.2354E-01_JPRB,9.3066E-01_JPRB,&
&9.0486E-01_JPRB,8.1739E-01_JPRB,9.0706E-01_JPRB,9.3532E-01_JPRB/)
KAO( :, 2, 6,12) = (/&
&1.2834E+00_JPRB,1.1690E+00_JPRB,1.1908E+00_JPRB,1.2086E+00_JPRB,1.2415E+00_JPRB,1.2368E+00_JPRB,&
&1.1756E+00_JPRB,1.0742E+00_JPRB,1.1928E+00_JPRB,1.2288E+00_JPRB/)
KAO( :, 3, 6,12) = (/&
&1.6799E+00_JPRB,1.5378E+00_JPRB,1.5358E+00_JPRB,1.5673E+00_JPRB,1.6035E+00_JPRB,1.5726E+00_JPRB,&
&1.4795E+00_JPRB,1.3798E+00_JPRB,1.5315E+00_JPRB,1.5776E+00_JPRB/)
KAO( :, 4, 6,12) = (/&
&2.1238E+00_JPRB,1.9529E+00_JPRB,1.9235E+00_JPRB,1.9758E+00_JPRB,1.9970E+00_JPRB,1.9496E+00_JPRB,&
&1.8190E+00_JPRB,1.7092E+00_JPRB,1.9137E+00_JPRB,1.9536E+00_JPRB/)
KAO( :, 5, 6,12) = (/&
&2.6095E+00_JPRB,2.4084E+00_JPRB,2.3509E+00_JPRB,2.4228E+00_JPRB,2.4180E+00_JPRB,2.3618E+00_JPRB,&
&2.1597E+00_JPRB,2.0675E+00_JPRB,2.3214E+00_JPRB,2.3618E+00_JPRB/)
KAO( :, 1, 7,12) = (/&
&8.4812E-01_JPRB,7.6841E-01_JPRB,7.5326E-01_JPRB,7.5035E-01_JPRB,7.7118E-01_JPRB,7.8872E-01_JPRB,&
&7.7183E-01_JPRB,7.0585E-01_JPRB,7.7946E-01_JPRB,8.0795E-01_JPRB/)
KAO( :, 2, 7,12) = (/&
&1.1465E+00_JPRB,1.0445E+00_JPRB,1.0290E+00_JPRB,1.0370E+00_JPRB,1.0598E+00_JPRB,1.0683E+00_JPRB,&
&1.0242E+00_JPRB,9.3963E-01_JPRB,1.0386E+00_JPRB,1.0754E+00_JPRB/)
KAO( :, 3, 7,12) = (/&
&1.5193E+00_JPRB,1.3894E+00_JPRB,1.3649E+00_JPRB,1.3853E+00_JPRB,1.3982E+00_JPRB,1.3813E+00_JPRB,&
&1.3178E+00_JPRB,1.2173E+00_JPRB,1.3509E+00_JPRB,1.3914E+00_JPRB/)
KAO( :, 4, 7,12) = (/&
&1.9518E+00_JPRB,1.7884E+00_JPRB,1.7513E+00_JPRB,1.7865E+00_JPRB,1.7771E+00_JPRB,1.7370E+00_JPRB,&
&1.6446E+00_JPRB,1.5222E+00_JPRB,1.7063E+00_JPRB,1.7391E+00_JPRB/)
KAO( :, 5, 7,12) = (/&
&2.4259E+00_JPRB,2.2279E+00_JPRB,2.1794E+00_JPRB,2.2290E+00_JPRB,2.1962E+00_JPRB,2.1299E+00_JPRB,&
&1.9788E+00_JPRB,1.8585E+00_JPRB,2.0857E+00_JPRB,2.1225E+00_JPRB/)
KAO( :, 1, 8,12) = (/&
&7.7841E-01_JPRB,7.0711E-01_JPRB,6.6522E-01_JPRB,6.3606E-01_JPRB,6.4760E-01_JPRB,6.6713E-01_JPRB,&
&6.6148E-01_JPRB,6.0390E-01_JPRB,6.6973E-01_JPRB,6.8843E-01_JPRB/)
KAO( :, 2, 8,12) = (/&
&1.0658E+00_JPRB,9.6636E-01_JPRB,9.1583E-01_JPRB,8.8699E-01_JPRB,9.0848E-01_JPRB,9.1965E-01_JPRB,&
&8.9372E-01_JPRB,8.1955E-01_JPRB,9.1141E-01_JPRB,9.3497E-01_JPRB/)
KAO( :, 3, 8,12) = (/&
&1.4137E+00_JPRB,1.2836E+00_JPRB,1.2307E+00_JPRB,1.2115E+00_JPRB,1.2232E+00_JPRB,1.2116E+00_JPRB,&
&1.1659E+00_JPRB,1.0732E+00_JPRB,1.1969E+00_JPRB,1.2259E+00_JPRB/)
KAO( :, 4, 8,12) = (/&
&1.8330E+00_JPRB,1.6670E+00_JPRB,1.6047E+00_JPRB,1.5956E+00_JPRB,1.5811E+00_JPRB,1.5515E+00_JPRB,&
&1.4752E+00_JPRB,1.3507E+00_JPRB,1.5186E+00_JPRB,1.5425E+00_JPRB/)
KAO( :, 5, 8,12) = (/&
&2.3049E+00_JPRB,2.1036E+00_JPRB,2.0278E+00_JPRB,2.0220E+00_JPRB,1.9855E+00_JPRB,1.9308E+00_JPRB,&
&1.8019E+00_JPRB,1.6605E+00_JPRB,1.8705E+00_JPRB,1.8963E+00_JPRB/)
KAO( :, 1, 9,12) = (/&
&7.0912E-01_JPRB,6.4469E-01_JPRB,5.9363E-01_JPRB,5.5627E-01_JPRB,5.5384E-01_JPRB,5.6186E-01_JPRB,&
&5.5927E-01_JPRB,5.0354E-01_JPRB,5.6125E-01_JPRB,7.4969E-01_JPRB/)
KAO( :, 2, 9,12) = (/&
&9.9527E-01_JPRB,9.0550E-01_JPRB,8.3442E-01_JPRB,7.8264E-01_JPRB,7.7752E-01_JPRB,7.8969E-01_JPRB,&
&7.7692E-01_JPRB,6.9354E-01_JPRB,7.7793E-01_JPRB,8.7043E-01_JPRB/)
KAO( :, 3, 9,12) = (/&
&1.3412E+00_JPRB,1.2190E+00_JPRB,1.1268E+00_JPRB,1.0743E+00_JPRB,1.0606E+00_JPRB,1.0614E+00_JPRB,&
&1.0350E+00_JPRB,9.2237E-01_JPRB,1.0409E+00_JPRB,1.0573E+00_JPRB/)
KAO( :, 4, 9,12) = (/&
&1.7493E+00_JPRB,1.5874E+00_JPRB,1.4863E+00_JPRB,1.4310E+00_JPRB,1.3986E+00_JPRB,1.3843E+00_JPRB,&
&1.3254E+00_JPRB,1.1771E+00_JPRB,1.3374E+00_JPRB,1.3371E+00_JPRB/)
KAO( :, 5, 9,12) = (/&
&2.2176E+00_JPRB,2.0127E+00_JPRB,1.9126E+00_JPRB,1.8371E+00_JPRB,1.7903E+00_JPRB,1.7504E+00_JPRB,&
&1.6358E+00_JPRB,1.4630E+00_JPRB,1.6600E+00_JPRB,1.6679E+00_JPRB/)
KAO( :, 1,10,12) = (/&
&6.5376E-01_JPRB,5.9649E-01_JPRB,5.4382E-01_JPRB,5.0392E-01_JPRB,4.9222E-01_JPRB,4.9094E-01_JPRB,&
&4.7672E-01_JPRB,4.1966E-01_JPRB,4.6921E-01_JPRB,1.3769E+00_JPRB/)
KAO( :, 2,10,12) = (/&
&9.3800E-01_JPRB,8.5670E-01_JPRB,7.8367E-01_JPRB,7.2595E-01_JPRB,6.9805E-01_JPRB,6.9533E-01_JPRB,&
&6.7619E-01_JPRB,5.9132E-01_JPRB,6.6160E-01_JPRB,1.6706E+00_JPRB/)
KAO( :, 3,10,12) = (/&
&1.2854E+00_JPRB,1.1741E+00_JPRB,1.0774E+00_JPRB,1.0008E+00_JPRB,9.5668E-01_JPRB,9.5165E-01_JPRB,&
&9.1656E-01_JPRB,7.9224E-01_JPRB,8.9510E-01_JPRB,1.9785E+00_JPRB/)
KAO( :, 4,10,12) = (/&
&1.6921E+00_JPRB,1.5448E+00_JPRB,1.4301E+00_JPRB,1.3361E+00_JPRB,1.2735E+00_JPRB,1.2587E+00_JPRB,&
&1.1957E+00_JPRB,1.0181E+00_JPRB,1.1609E+00_JPRB,2.2894E+00_JPRB/)
KAO( :, 5,10,12) = (/&
&2.1576E+00_JPRB,1.9664E+00_JPRB,1.8494E+00_JPRB,1.7300E+00_JPRB,1.6509E+00_JPRB,1.6070E+00_JPRB,&
&1.4973E+00_JPRB,1.2816E+00_JPRB,1.4648E+00_JPRB,2.6067E+00_JPRB/)
KAO( :, 1,11,12) = (/&
&7.0952E-01_JPRB,6.5053E-01_JPRB,5.9316E-01_JPRB,5.5146E-01_JPRB,5.2180E-01_JPRB,5.0652E-01_JPRB,&
&4.7718E-01_JPRB,4.1246E-01_JPRB,4.5783E-01_JPRB,2.0241E+00_JPRB/)
KAO( :, 2,11,12) = (/&
&1.0167E+00_JPRB,9.3262E-01_JPRB,8.5333E-01_JPRB,7.9232E-01_JPRB,7.4499E-01_JPRB,7.1140E-01_JPRB,&
&6.7465E-01_JPRB,5.7859E-01_JPRB,6.4613E-01_JPRB,2.2912E+00_JPRB/)
KAO( :, 3,11,12) = (/&
&1.3886E+00_JPRB,1.2732E+00_JPRB,1.1736E+00_JPRB,1.0906E+00_JPRB,1.0139E+00_JPRB,9.7034E-01_JPRB,&
&9.1240E-01_JPRB,7.7049E-01_JPRB,8.6376E-01_JPRB,2.6463E+00_JPRB/)
KAO( :, 4,11,12) = (/&
&1.8181E+00_JPRB,1.6680E+00_JPRB,1.5549E+00_JPRB,1.4417E+00_JPRB,1.3425E+00_JPRB,1.2830E+00_JPRB,&
&1.1836E+00_JPRB,9.8857E-01_JPRB,1.1129E+00_JPRB,3.0263E+00_JPRB/)
KAO( :, 5,11,12) = (/&
&2.3057E+00_JPRB,2.1146E+00_JPRB,1.9950E+00_JPRB,1.8508E+00_JPRB,1.7289E+00_JPRB,1.6307E+00_JPRB,&
&1.4919E+00_JPRB,1.2455E+00_JPRB,1.4085E+00_JPRB,3.4186E+00_JPRB/)
KAO( :, 1,12,12) = (/&
&7.5886E-01_JPRB,6.9796E-01_JPRB,6.3852E-01_JPRB,5.9929E-01_JPRB,5.5990E-01_JPRB,5.1924E-01_JPRB,&
&4.7840E-01_JPRB,4.0341E-01_JPRB,4.4154E-01_JPRB,2.6087E+00_JPRB/)
KAO( :, 2,12,12) = (/&
&1.0851E+00_JPRB,9.9770E-01_JPRB,9.1673E-01_JPRB,8.5899E-01_JPRB,7.9809E-01_JPRB,7.3287E-01_JPRB,&
&6.7148E-01_JPRB,5.6350E-01_JPRB,6.1612E-01_JPRB,2.8310E+00_JPRB/)
KAO( :, 3,12,12) = (/&
&1.4755E+00_JPRB,1.3573E+00_JPRB,1.2579E+00_JPRB,1.1774E+00_JPRB,1.0886E+00_JPRB,9.9484E-01_JPRB,&
&9.0354E-01_JPRB,7.5007E-01_JPRB,8.2214E-01_JPRB,3.1388E+00_JPRB/)
KAO( :, 4,12,12) = (/&
&1.9253E+00_JPRB,1.7711E+00_JPRB,1.6604E+00_JPRB,1.5471E+00_JPRB,1.4336E+00_JPRB,1.3051E+00_JPRB,&
&1.1698E+00_JPRB,9.7140E-01_JPRB,1.0651E+00_JPRB,3.4850E+00_JPRB/)
KAO( :, 5,12,12) = (/&
&2.4308E+00_JPRB,2.2396E+00_JPRB,2.1167E+00_JPRB,1.9729E+00_JPRB,1.8272E+00_JPRB,1.6585E+00_JPRB,&
&1.4809E+00_JPRB,1.2177E+00_JPRB,1.3448E+00_JPRB,3.8825E+00_JPRB/)
KAO( :, 1,13,12) = (/&
&7.9229E-01_JPRB,7.3221E-01_JPRB,6.7737E-01_JPRB,6.4130E-01_JPRB,5.9847E-01_JPRB,5.3580E-01_JPRB,&
&4.7728E-01_JPRB,3.9003E-01_JPRB,4.1400E-01_JPRB,2.7638E+00_JPRB/)
KAO( :, 2,13,12) = (/&
&1.1297E+00_JPRB,1.0450E+00_JPRB,9.7140E-01_JPRB,9.1618E-01_JPRB,8.5138E-01_JPRB,7.6006E-01_JPRB,&
&6.6619E-01_JPRB,5.4383E-01_JPRB,5.7638E-01_JPRB,2.9703E+00_JPRB/)
KAO( :, 3,13,12) = (/&
&1.5310E+00_JPRB,1.4169E+00_JPRB,1.3280E+00_JPRB,1.2470E+00_JPRB,1.1584E+00_JPRB,1.0272E+00_JPRB,&
&8.9295E-01_JPRB,7.3007E-01_JPRB,7.7208E-01_JPRB,3.2180E+00_JPRB/)
KAO( :, 4,13,12) = (/&
&1.9939E+00_JPRB,1.8457E+00_JPRB,1.7416E+00_JPRB,1.6315E+00_JPRB,1.5169E+00_JPRB,1.3360E+00_JPRB,&
&1.1634E+00_JPRB,9.4900E-01_JPRB,1.0058E+00_JPRB,3.5288E+00_JPRB/)
KAO( :, 5,13,12) = (/&
&2.5079E+00_JPRB,2.3287E+00_JPRB,2.2043E+00_JPRB,2.0691E+00_JPRB,1.9162E+00_JPRB,1.6967E+00_JPRB,&
&1.4732E+00_JPRB,1.1903E+00_JPRB,1.2641E+00_JPRB,3.8603E+00_JPRB/)
KAO( :, 1, 1,13) = (/&
&3.9649E+00_JPRB,3.4696E+00_JPRB,2.9742E+00_JPRB,2.6893E+00_JPRB,2.5814E+00_JPRB,2.2539E+00_JPRB,&
&1.9591E+00_JPRB,2.1953E+00_JPRB,2.3585E+00_JPRB,2.4435E+00_JPRB/)
KAO( :, 2, 1,13) = (/&
&4.6934E+00_JPRB,4.1070E+00_JPRB,3.5206E+00_JPRB,3.2425E+00_JPRB,3.0762E+00_JPRB,2.6670E+00_JPRB,&
&2.3213E+00_JPRB,2.6577E+00_JPRB,2.8281E+00_JPRB,2.9391E+00_JPRB/)
KAO( :, 3, 1,13) = (/&
&5.4309E+00_JPRB,4.7524E+00_JPRB,4.0738E+00_JPRB,3.8211E+00_JPRB,3.5699E+00_JPRB,3.1013E+00_JPRB,&
&2.7446E+00_JPRB,3.1848E+00_JPRB,3.3841E+00_JPRB,3.5205E+00_JPRB/)
KAO( :, 4, 1,13) = (/&
&6.1708E+00_JPRB,5.3997E+00_JPRB,4.6331E+00_JPRB,4.4110E+00_JPRB,4.0650E+00_JPRB,3.5506E+00_JPRB,&
&3.2653E+00_JPRB,3.7939E+00_JPRB,4.0349E+00_JPRB,4.1946E+00_JPRB/)
KAO( :, 5, 1,13) = (/&
&6.8879E+00_JPRB,6.0273E+00_JPRB,5.1873E+00_JPRB,4.9821E+00_JPRB,4.5559E+00_JPRB,4.0078E+00_JPRB,&
&3.8433E+00_JPRB,4.4688E+00_JPRB,4.7724E+00_JPRB,4.9544E+00_JPRB/)
KAO( :, 1, 2,13) = (/&
&3.6698E+00_JPRB,3.2113E+00_JPRB,2.7634E+00_JPRB,2.6220E+00_JPRB,2.4498E+00_JPRB,2.2177E+00_JPRB,&
&1.9317E+00_JPRB,2.1759E+00_JPRB,2.3566E+00_JPRB,2.4539E+00_JPRB/)
KAO( :, 2, 2,13) = (/&
&4.3922E+00_JPRB,3.8433E+00_JPRB,3.3174E+00_JPRB,3.1962E+00_JPRB,2.9402E+00_JPRB,2.6303E+00_JPRB,&
&2.3496E+00_JPRB,2.7064E+00_JPRB,2.8995E+00_JPRB,3.0421E+00_JPRB/)
KAO( :, 3, 2,13) = (/&
&5.1315E+00_JPRB,4.4903E+00_JPRB,3.8960E+00_JPRB,3.7804E+00_JPRB,3.4475E+00_JPRB,3.0575E+00_JPRB,&
&2.8478E+00_JPRB,3.3075E+00_JPRB,3.5154E+00_JPRB,3.7101E+00_JPRB/)
KAO( :, 4, 2,13) = (/&
&5.8800E+00_JPRB,5.1453E+00_JPRB,4.4924E+00_JPRB,4.3646E+00_JPRB,3.9642E+00_JPRB,3.5208E+00_JPRB,&
&3.3891E+00_JPRB,3.9399E+00_JPRB,4.1954E+00_JPRB,4.4214E+00_JPRB/)
KAO( :, 5, 2,13) = (/&
&6.6101E+00_JPRB,5.7841E+00_JPRB,5.0872E+00_JPRB,4.9348E+00_JPRB,4.4777E+00_JPRB,4.0458E+00_JPRB,&
&3.9713E+00_JPRB,4.6160E+00_JPRB,4.9393E+00_JPRB,5.1870E+00_JPRB/)
KAO( :, 1, 3,13) = (/&
&3.2411E+00_JPRB,2.8361E+00_JPRB,2.4831E+00_JPRB,2.4070E+00_JPRB,2.2480E+00_JPRB,2.0870E+00_JPRB,&
&1.8051E+00_JPRB,2.0202E+00_JPRB,2.1994E+00_JPRB,2.3002E+00_JPRB/)
KAO( :, 2, 3,13) = (/&
&3.9470E+00_JPRB,3.4538E+00_JPRB,3.0483E+00_JPRB,2.9667E+00_JPRB,2.7181E+00_JPRB,2.5148E+00_JPRB,&
&2.2501E+00_JPRB,2.5765E+00_JPRB,2.7837E+00_JPRB,2.9313E+00_JPRB/)
KAO( :, 3, 3,13) = (/&
&4.6804E+00_JPRB,4.0955E+00_JPRB,3.6459E+00_JPRB,3.5399E+00_JPRB,3.2163E+00_JPRB,2.9639E+00_JPRB,&
&2.7715E+00_JPRB,3.2088E+00_JPRB,3.4557E+00_JPRB,3.6507E+00_JPRB/)
KAO( :, 4, 3,13) = (/&
&5.4312E+00_JPRB,4.7525E+00_JPRB,4.2675E+00_JPRB,4.1206E+00_JPRB,3.7364E+00_JPRB,3.4562E+00_JPRB,&
&3.3399E+00_JPRB,3.8844E+00_JPRB,4.1920E+00_JPRB,4.4202E+00_JPRB/)
KAO( :, 5, 3,13) = (/&
&6.1796E+00_JPRB,5.4074E+00_JPRB,4.8990E+00_JPRB,4.7013E+00_JPRB,4.2915E+00_JPRB,3.9757E+00_JPRB,&
&3.9407E+00_JPRB,4.5828E+00_JPRB,4.9410E+00_JPRB,5.2123E+00_JPRB/)
KAO( :, 1, 4,13) = (/&
&2.7929E+00_JPRB,2.4439E+00_JPRB,2.1939E+00_JPRB,2.1454E+00_JPRB,2.0515E+00_JPRB,1.8877E+00_JPRB,&
&1.6383E+00_JPRB,1.8045E+00_JPRB,1.9740E+00_JPRB,2.0628E+00_JPRB/)
KAO( :, 2, 4,13) = (/&
&3.4793E+00_JPRB,3.0445E+00_JPRB,2.7598E+00_JPRB,2.6705E+00_JPRB,2.5121E+00_JPRB,2.3266E+00_JPRB,&
&2.0901E+00_JPRB,2.3620E+00_JPRB,2.5689E+00_JPRB,2.6998E+00_JPRB/)
KAO( :, 3, 4,13) = (/&
&4.2010E+00_JPRB,3.6761E+00_JPRB,3.3660E+00_JPRB,3.2278E+00_JPRB,3.0027E+00_JPRB,2.8086E+00_JPRB,&
&2.6028E+00_JPRB,2.9855E+00_JPRB,3.2574E+00_JPRB,3.4124E+00_JPRB/)
KAO( :, 4, 4,13) = (/&
&4.9519E+00_JPRB,4.3331E+00_JPRB,4.0066E+00_JPRB,3.8137E+00_JPRB,3.5269E+00_JPRB,3.3453E+00_JPRB,&
&3.1635E+00_JPRB,3.6670E+00_JPRB,4.0070E+00_JPRB,4.1903E+00_JPRB/)
KAO( :, 5, 4,13) = (/&
&5.7128E+00_JPRB,4.9989E+00_JPRB,4.6672E+00_JPRB,4.4092E+00_JPRB,4.0817E+00_JPRB,3.8791E+00_JPRB,&
&3.7698E+00_JPRB,4.3882E+00_JPRB,4.8065E+00_JPRB,5.0150E+00_JPRB/)
KAO( :, 1, 5,13) = (/&
&2.3832E+00_JPRB,2.0854E+00_JPRB,1.9206E+00_JPRB,1.9102E+00_JPRB,1.8377E+00_JPRB,1.6804E+00_JPRB,&
&1.4581E+00_JPRB,1.5820E+00_JPRB,1.7385E+00_JPRB,1.8104E+00_JPRB/)
KAO( :, 2, 5,13) = (/&
&3.0408E+00_JPRB,2.6608E+00_JPRB,2.4785E+00_JPRB,2.4054E+00_JPRB,2.3025E+00_JPRB,2.1234E+00_JPRB,&
&1.8947E+00_JPRB,2.1142E+00_JPRB,2.3213E+00_JPRB,2.4192E+00_JPRB/)
KAO( :, 3, 5,13) = (/&
&3.7472E+00_JPRB,3.2789E+00_JPRB,3.0888E+00_JPRB,2.9395E+00_JPRB,2.8036E+00_JPRB,2.6282E+00_JPRB,&
&2.3906E+00_JPRB,2.7153E+00_JPRB,2.9926E+00_JPRB,3.1059E+00_JPRB/)
KAO( :, 4, 5,13) = (/&
&4.4915E+00_JPRB,3.9302E+00_JPRB,3.7393E+00_JPRB,3.5090E+00_JPRB,3.3375E+00_JPRB,3.1759E+00_JPRB,&
&2.9354E+00_JPRB,3.3827E+00_JPRB,3.7352E+00_JPRB,3.8690E+00_JPRB/)
KAO( :, 5, 5,13) = (/&
&5.2663E+00_JPRB,4.6081E+00_JPRB,4.4077E+00_JPRB,4.1006E+00_JPRB,3.9180E+00_JPRB,3.7090E+00_JPRB,&
&3.5307E+00_JPRB,4.1076E+00_JPRB,4.5338E+00_JPRB,4.6986E+00_JPRB/)
KAO( :, 1, 6,13) = (/&
&1.9932E+00_JPRB,1.7450E+00_JPRB,1.6663E+00_JPRB,1.6747E+00_JPRB,1.5875E+00_JPRB,1.4577E+00_JPRB,&
&1.2653E+00_JPRB,1.3499E+00_JPRB,1.4817E+00_JPRB,1.5465E+00_JPRB/)
KAO( :, 2, 6,13) = (/&
&2.6126E+00_JPRB,2.2877E+00_JPRB,2.1906E+00_JPRB,2.1465E+00_JPRB,2.0440E+00_JPRB,1.8948E+00_JPRB,&
&1.6751E+00_JPRB,1.8295E+00_JPRB,2.0253E+00_JPRB,2.0939E+00_JPRB/)
KAO( :, 3, 6,13) = (/&
&3.3035E+00_JPRB,2.8922E+00_JPRB,2.7796E+00_JPRB,2.6671E+00_JPRB,2.5564E+00_JPRB,2.3982E+00_JPRB,&
&2.1433E+00_JPRB,2.3876E+00_JPRB,2.6563E+00_JPRB,2.7311E+00_JPRB/)
KAO( :, 4, 6,13) = (/&
&4.0480E+00_JPRB,3.5441E+00_JPRB,3.4094E+00_JPRB,3.2253E+00_JPRB,3.1196E+00_JPRB,2.9346E+00_JPRB,&
&2.6536E+00_JPRB,3.0266E+00_JPRB,3.3710E+00_JPRB,3.4616E+00_JPRB/)
KAO( :, 5, 6,13) = (/&
&4.8342E+00_JPRB,4.2338E+00_JPRB,4.0696E+00_JPRB,3.8230E+00_JPRB,3.7396E+00_JPRB,3.4594E+00_JPRB,&
&3.2309E+00_JPRB,3.7339E+00_JPRB,4.1600E+00_JPRB,4.2696E+00_JPRB/)
KAO( :, 1, 7,13) = (/&
&1.6468E+00_JPRB,1.4469E+00_JPRB,1.4375E+00_JPRB,1.4321E+00_JPRB,1.3474E+00_JPRB,1.2424E+00_JPRB,&
&1.0892E+00_JPRB,1.1510E+00_JPRB,1.2626E+00_JPRB,1.3183E+00_JPRB/)
KAO( :, 2, 7,13) = (/&
&2.2291E+00_JPRB,1.9582E+00_JPRB,1.9270E+00_JPRB,1.8946E+00_JPRB,1.7899E+00_JPRB,1.6613E+00_JPRB,&
&1.4638E+00_JPRB,1.5844E+00_JPRB,1.7486E+00_JPRB,1.8143E+00_JPRB/)
KAO( :, 3, 7,13) = (/&
&2.8937E+00_JPRB,2.5452E+00_JPRB,2.4760E+00_JPRB,2.4095E+00_JPRB,2.2977E+00_JPRB,2.1475E+00_JPRB,&
&1.8921E+00_JPRB,2.0920E+00_JPRB,2.3240E+00_JPRB,2.3941E+00_JPRB/)
KAO( :, 4, 7,13) = (/&
&3.6319E+00_JPRB,3.2018E+00_JPRB,3.0807E+00_JPRB,2.9736E+00_JPRB,2.8721E+00_JPRB,2.6699E+00_JPRB,&
&2.3689E+00_JPRB,2.6767E+00_JPRB,2.9818E+00_JPRB,3.0621E+00_JPRB/)
KAO( :, 5, 7,13) = (/&
&4.4294E+00_JPRB,3.9124E+00_JPRB,3.7363E+00_JPRB,3.5826E+00_JPRB,3.5031E+00_JPRB,3.1936E+00_JPRB,&
&2.9162E+00_JPRB,3.3346E+00_JPRB,3.7295E+00_JPRB,3.8139E+00_JPRB/)
KAO( :, 1, 8,13) = (/&
&1.3645E+00_JPRB,1.2030E+00_JPRB,1.2251E+00_JPRB,1.1980E+00_JPRB,1.1267E+00_JPRB,1.0496E+00_JPRB,&
&9.4007E-01_JPRB,9.8738E-01_JPRB,1.0795E+00_JPRB,1.1321E+00_JPRB/)
KAO( :, 2, 8,13) = (/&
&1.8875E+00_JPRB,1.6716E+00_JPRB,1.6787E+00_JPRB,1.6357E+00_JPRB,1.5491E+00_JPRB,1.4420E+00_JPRB,&
&1.2844E+00_JPRB,1.3709E+00_JPRB,1.5112E+00_JPRB,1.5708E+00_JPRB/)
KAO( :, 3, 8,13) = (/&
&2.5235E+00_JPRB,2.2405E+00_JPRB,2.2018E+00_JPRB,2.1383E+00_JPRB,2.0418E+00_JPRB,1.9034E+00_JPRB,&
&1.6797E+00_JPRB,1.8309E+00_JPRB,2.0369E+00_JPRB,2.0956E+00_JPRB/)
KAO( :, 4, 8,13) = (/&
&3.2460E+00_JPRB,2.8890E+00_JPRB,2.7989E+00_JPRB,2.7089E+00_JPRB,2.6113E+00_JPRB,2.4070E+00_JPRB,&
&2.1243E+00_JPRB,2.3727E+00_JPRB,2.6443E+00_JPRB,2.7141E+00_JPRB/)
KAO( :, 5, 8,13) = (/&
&4.0415E+00_JPRB,3.6015E+00_JPRB,3.4549E+00_JPRB,3.3427E+00_JPRB,3.2300E+00_JPRB,2.9321E+00_JPRB,&
&2.6354E+00_JPRB,2.9888E+00_JPRB,3.3390E+00_JPRB,3.4186E+00_JPRB/)
KAO( :, 1, 9,13) = (/&
&1.1543E+00_JPRB,1.0251E+00_JPRB,1.0349E+00_JPRB,9.8794E-01_JPRB,9.3205E-01_JPRB,8.8440E-01_JPRB,&
&8.0320E-01_JPRB,8.4519E-01_JPRB,9.2711E-01_JPRB,1.0206E+00_JPRB/)
KAO( :, 2, 9,13) = (/&
&1.6108E+00_JPRB,1.4310E+00_JPRB,1.4476E+00_JPRB,1.3885E+00_JPRB,1.3235E+00_JPRB,1.2492E+00_JPRB,&
&1.1169E+00_JPRB,1.1958E+00_JPRB,1.3141E+00_JPRB,1.3705E+00_JPRB/)
KAO( :, 3, 9,13) = (/&
&2.1885E+00_JPRB,1.9532E+00_JPRB,1.9550E+00_JPRB,1.8741E+00_JPRB,1.7932E+00_JPRB,1.6819E+00_JPRB,&
&1.4843E+00_JPRB,1.6106E+00_JPRB,1.7801E+00_JPRB,1.8447E+00_JPRB/)
KAO( :, 4, 9,13) = (/&
&2.8811E+00_JPRB,2.5830E+00_JPRB,2.5357E+00_JPRB,2.4436E+00_JPRB,2.3447E+00_JPRB,2.1613E+00_JPRB,&
&1.9043E+00_JPRB,2.1005E+00_JPRB,2.3339E+00_JPRB,2.4057E+00_JPRB/)
KAO( :, 5, 9,13) = (/&
&3.6764E+00_JPRB,3.3079E+00_JPRB,3.1796E+00_JPRB,3.0911E+00_JPRB,2.9539E+00_JPRB,2.6757E+00_JPRB,&
&2.3874E+00_JPRB,2.6741E+00_JPRB,2.9820E+00_JPRB,3.0611E+00_JPRB/)
KAO( :, 1,10,13) = (/&
&1.0302E+00_JPRB,9.2176E-01_JPRB,9.0574E-01_JPRB,8.4615E-01_JPRB,7.9970E-01_JPRB,7.6976E-01_JPRB,&
&7.0274E-01_JPRB,7.4283E-01_JPRB,8.1565E-01_JPRB,2.7017E+00_JPRB/)
KAO( :, 2,10,13) = (/&
&1.4458E+00_JPRB,1.2918E+00_JPRB,1.2726E+00_JPRB,1.2041E+00_JPRB,1.1546E+00_JPRB,1.1052E+00_JPRB,&
&9.9535E-01_JPRB,1.0584E+00_JPRB,1.1691E+00_JPRB,2.9336E+00_JPRB/)
KAO( :, 3,10,13) = (/&
&1.9856E+00_JPRB,1.7787E+00_JPRB,1.7427E+00_JPRB,1.6691E+00_JPRB,1.6016E+00_JPRB,1.5137E+00_JPRB,&
&1.3407E+00_JPRB,1.4471E+00_JPRB,1.6060E+00_JPRB,3.2154E+00_JPRB/)
KAO( :, 4,10,13) = (/&
&2.6493E+00_JPRB,2.3820E+00_JPRB,2.3103E+00_JPRB,2.2284E+00_JPRB,2.1316E+00_JPRB,1.9769E+00_JPRB,&
&1.7435E+00_JPRB,1.9143E+00_JPRB,2.1248E+00_JPRB,3.4633E+00_JPRB/)
KAO( :, 5,10,13) = (/&
&3.4281E+00_JPRB,3.0946E+00_JPRB,2.9645E+00_JPRB,2.8748E+00_JPRB,2.7245E+00_JPRB,2.4879E+00_JPRB,&
&2.2103E+00_JPRB,2.4551E+00_JPRB,2.7307E+00_JPRB,3.6000E+00_JPRB/)
KAO( :, 1,11,13) = (/&
&1.0987E+00_JPRB,9.8883E-01_JPRB,9.4457E-01_JPRB,8.7599E-01_JPRB,8.3570E-01_JPRB,8.0174E-01_JPRB,&
&7.2908E-01_JPRB,7.6400E-01_JPRB,8.5040E-01_JPRB,4.1644E+00_JPRB/)
KAO( :, 2,11,13) = (/&
&1.5519E+00_JPRB,1.3960E+00_JPRB,1.3272E+00_JPRB,1.2419E+00_JPRB,1.1936E+00_JPRB,1.1475E+00_JPRB,&
&1.0323E+00_JPRB,1.0904E+00_JPRB,1.2118E+00_JPRB,4.4377E+00_JPRB/)
KAO( :, 3,11,13) = (/&
&2.1168E+00_JPRB,1.9062E+00_JPRB,1.8156E+00_JPRB,1.7151E+00_JPRB,1.6554E+00_JPRB,1.5612E+00_JPRB,&
&1.3900E+00_JPRB,1.4823E+00_JPRB,1.6504E+00_JPRB,4.7648E+00_JPRB/)
KAO( :, 4,11,13) = (/&
&2.8109E+00_JPRB,2.5372E+00_JPRB,2.4065E+00_JPRB,2.2977E+00_JPRB,2.1984E+00_JPRB,2.0338E+00_JPRB,&
&1.8057E+00_JPRB,1.9491E+00_JPRB,2.1792E+00_JPRB,5.1367E+00_JPRB/)
KAO( :, 5,11,13) = (/&
&3.6200E+00_JPRB,3.2757E+00_JPRB,3.0973E+00_JPRB,2.9725E+00_JPRB,2.8049E+00_JPRB,2.5726E+00_JPRB,&
&2.2731E+00_JPRB,2.4759E+00_JPRB,2.7857E+00_JPRB,5.3931E+00_JPRB/)
KAO( :, 1,12,13) = (/&
&1.1834E+00_JPRB,1.0718E+00_JPRB,9.9832E-01_JPRB,9.1951E-01_JPRB,8.8066E-01_JPRB,8.3984E-01_JPRB,&
&7.5516E-01_JPRB,7.7629E-01_JPRB,8.6924E-01_JPRB,5.0196E+00_JPRB/)
KAO( :, 2,12,13) = (/&
&1.6817E+00_JPRB,1.5210E+00_JPRB,1.4125E+00_JPRB,1.3041E+00_JPRB,1.2468E+00_JPRB,1.1910E+00_JPRB,&
&1.0644E+00_JPRB,1.0991E+00_JPRB,1.2384E+00_JPRB,5.3253E+00_JPRB/)
KAO( :, 3,12,13) = (/&
&2.2884E+00_JPRB,2.0697E+00_JPRB,1.9237E+00_JPRB,1.7926E+00_JPRB,1.7105E+00_JPRB,1.6141E+00_JPRB,&
&1.4356E+00_JPRB,1.4903E+00_JPRB,1.6827E+00_JPRB,5.6934E+00_JPRB/)
KAO( :, 4,12,13) = (/&
&3.0153E+00_JPRB,2.7275E+00_JPRB,2.5449E+00_JPRB,2.3911E+00_JPRB,2.2578E+00_JPRB,2.1058E+00_JPRB,&
&1.8686E+00_JPRB,1.9453E+00_JPRB,2.2026E+00_JPRB,6.1123E+00_JPRB/)
KAO( :, 5,12,13) = (/&
&3.8521E+00_JPRB,3.4852E+00_JPRB,3.2646E+00_JPRB,3.0814E+00_JPRB,2.8800E+00_JPRB,2.6613E+00_JPRB,&
&2.3377E+00_JPRB,2.4576E+00_JPRB,2.7866E+00_JPRB,6.4282E+00_JPRB/)
KAO( :, 1,13,13) = (/&
&1.2852E+00_JPRB,1.1646E+00_JPRB,1.0642E+00_JPRB,9.7556E-01_JPRB,9.2420E-01_JPRB,8.7620E-01_JPRB,&
&7.7196E-01_JPRB,7.7146E-01_JPRB,8.7630E-01_JPRB,4.8556E+00_JPRB/)
KAO( :, 2,13,13) = (/&
&1.8301E+00_JPRB,1.6589E+00_JPRB,1.5152E+00_JPRB,1.3893E+00_JPRB,1.3055E+00_JPRB,1.2323E+00_JPRB,&
&1.0895E+00_JPRB,1.0875E+00_JPRB,1.2372E+00_JPRB,5.1762E+00_JPRB/)
KAO( :, 3,13,13) = (/&
&2.4889E+00_JPRB,2.2558E+00_JPRB,2.0613E+00_JPRB,1.9034E+00_JPRB,1.7774E+00_JPRB,1.6692E+00_JPRB,&
&1.4717E+00_JPRB,1.4657E+00_JPRB,1.6743E+00_JPRB,5.5984E+00_JPRB/)
KAO( :, 4,13,13) = (/&
&3.2570E+00_JPRB,2.9493E+00_JPRB,2.7127E+00_JPRB,2.5175E+00_JPRB,2.3371E+00_JPRB,2.1800E+00_JPRB,&
&1.9099E+00_JPRB,1.9041E+00_JPRB,2.1795E+00_JPRB,5.9989E+00_JPRB/)
KAO( :, 5,13,13) = (/&
&4.1326E+00_JPRB,3.7382E+00_JPRB,3.4726E+00_JPRB,3.2172E+00_JPRB,2.9811E+00_JPRB,2.7433E+00_JPRB,&
&2.3977E+00_JPRB,2.4060E+00_JPRB,2.7519E+00_JPRB,6.3218E+00_JPRB/)
KAO( :, 1, 1,14) = (/&
&6.3467E+00_JPRB,5.5536E+00_JPRB,4.7605E+00_JPRB,3.9673E+00_JPRB,3.4386E+00_JPRB,3.0089E+00_JPRB,&
&3.2295E+00_JPRB,3.7567E+00_JPRB,4.0531E+00_JPRB,4.1923E+00_JPRB/)
KAO( :, 2, 1,14) = (/&
&7.3964E+00_JPRB,6.4721E+00_JPRB,5.5478E+00_JPRB,4.6234E+00_JPRB,4.0808E+00_JPRB,3.6137E+00_JPRB,&
&3.9782E+00_JPRB,4.6298E+00_JPRB,5.0268E+00_JPRB,5.1845E+00_JPRB/)
KAO( :, 3, 1,14) = (/&
&8.4250E+00_JPRB,7.3721E+00_JPRB,6.3192E+00_JPRB,5.2663E+00_JPRB,4.6836E+00_JPRB,4.2376E+00_JPRB,&
&4.8035E+00_JPRB,5.5919E+00_JPRB,6.0740E+00_JPRB,6.2648E+00_JPRB/)
KAO( :, 4, 1,14) = (/&
&9.4499E+00_JPRB,8.2689E+00_JPRB,7.0879E+00_JPRB,5.9239E+00_JPRB,5.2786E+00_JPRB,4.8999E+00_JPRB,&
&5.6760E+00_JPRB,6.6052E+00_JPRB,7.1802E+00_JPRB,7.4022E+00_JPRB/)
KAO( :, 5, 1,14) = (/&
&1.0423E+01_JPRB,9.1200E+00_JPRB,7.8174E+00_JPRB,6.5882E+00_JPRB,5.8558E+00_JPRB,5.6014E+00_JPRB,&
&6.5884E+00_JPRB,7.6675E+00_JPRB,8.3255E+00_JPRB,8.5803E+00_JPRB/)
KAO( :, 1, 2,14) = (/&
&6.0960E+00_JPRB,5.3341E+00_JPRB,4.5723E+00_JPRB,3.8126E+00_JPRB,3.4069E+00_JPRB,2.9396E+00_JPRB,&
&3.2197E+00_JPRB,3.7455E+00_JPRB,4.0286E+00_JPRB,4.2155E+00_JPRB/)
KAO( :, 2, 2,14) = (/&
&7.1676E+00_JPRB,6.2719E+00_JPRB,5.3761E+00_JPRB,4.4966E+00_JPRB,4.0412E+00_JPRB,3.5493E+00_JPRB,&
&3.9472E+00_JPRB,4.5920E+00_JPRB,4.9699E+00_JPRB,5.1775E+00_JPRB/)
KAO( :, 3, 2,14) = (/&
&8.2275E+00_JPRB,7.1993E+00_JPRB,6.1710E+00_JPRB,5.2089E+00_JPRB,4.6568E+00_JPRB,4.1985E+00_JPRB,&
&4.7440E+00_JPRB,5.5211E+00_JPRB,6.0149E+00_JPRB,6.2370E+00_JPRB/)
KAO( :, 4, 2,14) = (/&
&9.2799E+00_JPRB,8.1202E+00_JPRB,6.9604E+00_JPRB,5.9586E+00_JPRB,5.2716E+00_JPRB,4.8960E+00_JPRB,&
&5.6599E+00_JPRB,6.5872E+00_JPRB,7.1735E+00_JPRB,7.4414E+00_JPRB/)
KAO( :, 5, 2,14) = (/&
&1.0290E+01_JPRB,9.0044E+00_JPRB,7.7181E+00_JPRB,6.7211E+00_JPRB,5.8757E+00_JPRB,5.6245E+00_JPRB,&
&6.6558E+00_JPRB,7.7452E+00_JPRB,8.4069E+00_JPRB,8.7373E+00_JPRB/)
KAO( :, 1, 3,14) = (/&
&5.6039E+00_JPRB,4.9036E+00_JPRB,4.2032E+00_JPRB,3.5445E+00_JPRB,3.1902E+00_JPRB,2.7537E+00_JPRB,&
&3.0813E+00_JPRB,3.5840E+00_JPRB,3.8576E+00_JPRB,4.0764E+00_JPRB/)
KAO( :, 2, 3,14) = (/&
&6.6863E+00_JPRB,5.8506E+00_JPRB,5.0150E+00_JPRB,4.2815E+00_JPRB,3.8270E+00_JPRB,3.3352E+00_JPRB,&
&3.7857E+00_JPRB,4.4048E+00_JPRB,4.7637E+00_JPRB,5.0131E+00_JPRB/)
KAO( :, 3, 3,14) = (/&
&7.7737E+00_JPRB,6.8021E+00_JPRB,5.8305E+00_JPRB,5.0665E+00_JPRB,4.4594E+00_JPRB,3.9827E+00_JPRB,&
&4.5659E+00_JPRB,5.3124E+00_JPRB,5.7659E+00_JPRB,6.0477E+00_JPRB/)
KAO( :, 4, 3,14) = (/&
&8.8508E+00_JPRB,7.7446E+00_JPRB,6.6384E+00_JPRB,5.8813E+00_JPRB,5.0859E+00_JPRB,4.6840E+00_JPRB,&
&5.4591E+00_JPRB,6.3527E+00_JPRB,6.8914E+00_JPRB,7.2291E+00_JPRB/)
KAO( :, 5, 3,14) = (/&
&9.9079E+00_JPRB,8.6696E+00_JPRB,7.4314E+00_JPRB,6.6539E+00_JPRB,5.7107E+00_JPRB,5.4618E+00_JPRB,&
&6.4933E+00_JPRB,7.5556E+00_JPRB,8.1916E+00_JPRB,8.5967E+00_JPRB/)
KAO( :, 1, 4,14) = (/&
&5.0429E+00_JPRB,4.4127E+00_JPRB,3.7824E+00_JPRB,3.2565E+00_JPRB,2.9117E+00_JPRB,2.5898E+00_JPRB,&
&2.8958E+00_JPRB,3.3702E+00_JPRB,3.6408E+00_JPRB,3.8526E+00_JPRB/)
KAO( :, 2, 4,14) = (/&
&6.1165E+00_JPRB,5.3520E+00_JPRB,4.5876E+00_JPRB,4.0300E+00_JPRB,3.5416E+00_JPRB,3.1532E+00_JPRB,&
&3.5780E+00_JPRB,4.1633E+00_JPRB,4.5155E+00_JPRB,4.7595E+00_JPRB/)
KAO( :, 3, 4,14) = (/&
&7.2202E+00_JPRB,6.3178E+00_JPRB,5.4153E+00_JPRB,4.8492E+00_JPRB,4.1829E+00_JPRB,3.7790E+00_JPRB,&
&4.3631E+00_JPRB,5.0766E+00_JPRB,5.4928E+00_JPRB,5.8029E+00_JPRB/)
KAO( :, 4, 4,14) = (/&
&8.3276E+00_JPRB,7.2868E+00_JPRB,6.2460E+00_JPRB,5.6534E+00_JPRB,4.8225E+00_JPRB,4.4640E+00_JPRB,&
&5.2625E+00_JPRB,6.1221E+00_JPRB,6.6156E+00_JPRB,6.9984E+00_JPRB/)
KAO( :, 5, 4,14) = (/&
&9.4148E+00_JPRB,8.2381E+00_JPRB,7.0618E+00_JPRB,6.4221E+00_JPRB,5.4760E+00_JPRB,5.2668E+00_JPRB,&
&6.3012E+00_JPRB,7.3279E+00_JPRB,7.8962E+00_JPRB,8.3774E+00_JPRB/)
KAO( :, 1, 5,14) = (/&
&4.4802E+00_JPRB,3.9202E+00_JPRB,3.3603E+00_JPRB,2.9662E+00_JPRB,2.6611E+00_JPRB,2.4288E+00_JPRB,&
&2.7026E+00_JPRB,3.1455E+00_JPRB,3.4114E+00_JPRB,3.6024E+00_JPRB/)
KAO( :, 2, 5,14) = (/&
&5.5401E+00_JPRB,4.8477E+00_JPRB,4.1552E+00_JPRB,3.7384E+00_JPRB,3.2633E+00_JPRB,2.9928E+00_JPRB,&
&3.3900E+00_JPRB,3.9443E+00_JPRB,4.2636E+00_JPRB,4.5188E+00_JPRB/)
KAO( :, 3, 5,14) = (/&
&6.6438E+00_JPRB,5.8134E+00_JPRB,4.9831E+00_JPRB,4.5446E+00_JPRB,3.8884E+00_JPRB,3.6053E+00_JPRB,&
&4.1835E+00_JPRB,4.8658E+00_JPRB,5.2435E+00_JPRB,5.5754E+00_JPRB/)
KAO( :, 4, 5,14) = (/&
&7.7709E+00_JPRB,6.7996E+00_JPRB,5.8338E+00_JPRB,5.3460E+00_JPRB,4.5461E+00_JPRB,4.3055E+00_JPRB,&
&5.1051E+00_JPRB,5.9359E+00_JPRB,6.3763E+00_JPRB,6.8031E+00_JPRB/)
KAO( :, 5, 5,14) = (/&
&8.8898E+00_JPRB,7.7787E+00_JPRB,6.6983E+00_JPRB,6.1260E+00_JPRB,5.2267E+00_JPRB,5.1517E+00_JPRB,&
&6.1712E+00_JPRB,7.1748E+00_JPRB,7.6888E+00_JPRB,8.2242E+00_JPRB/)
KAO( :, 1, 6,14) = (/&
&3.8956E+00_JPRB,3.4087E+00_JPRB,2.9221E+00_JPRB,2.6281E+00_JPRB,2.4050E+00_JPRB,2.1916E+00_JPRB,&
&2.4174E+00_JPRB,2.8161E+00_JPRB,3.0927E+00_JPRB,3.2244E+00_JPRB/)
KAO( :, 2, 6,14) = (/&
&4.9303E+00_JPRB,4.3141E+00_JPRB,3.7046E+00_JPRB,3.3844E+00_JPRB,3.0105E+00_JPRB,2.7770E+00_JPRB,&
&3.1412E+00_JPRB,3.6575E+00_JPRB,3.9814E+00_JPRB,4.1910E+00_JPRB/)
KAO( :, 3, 6,14) = (/&
&6.0218E+00_JPRB,5.2691E+00_JPRB,4.5387E+00_JPRB,4.1657E+00_JPRB,3.6350E+00_JPRB,3.4172E+00_JPRB,&
&3.9726E+00_JPRB,4.6214E+00_JPRB,4.9897E+00_JPRB,5.2991E+00_JPRB/)
KAO( :, 4, 6,14) = (/&
&7.1568E+00_JPRB,6.2623E+00_JPRB,5.4345E+00_JPRB,4.9658E+00_JPRB,4.2966E+00_JPRB,4.1563E+00_JPRB,&
&4.9351E+00_JPRB,5.7383E+00_JPRB,6.1434E+00_JPRB,6.5857E+00_JPRB/)
KAO( :, 5, 6,14) = (/&
&8.3003E+00_JPRB,7.2628E+00_JPRB,6.3671E+00_JPRB,5.7590E+00_JPRB,4.9644E+00_JPRB,5.0298E+00_JPRB,&
&6.0229E+00_JPRB,7.0046E+00_JPRB,7.4957E+00_JPRB,8.0375E+00_JPRB/)
KAO( :, 1, 7,14) = (/&
&3.3388E+00_JPRB,2.9215E+00_JPRB,2.5187E+00_JPRB,2.3253E+00_JPRB,2.1119E+00_JPRB,1.9164E+00_JPRB,&
&2.0859E+00_JPRB,2.4315E+00_JPRB,2.6982E+00_JPRB,2.7836E+00_JPRB/)
KAO( :, 2, 7,14) = (/&
&4.3359E+00_JPRB,3.7940E+00_JPRB,3.2869E+00_JPRB,3.0293E+00_JPRB,2.7102E+00_JPRB,2.5026E+00_JPRB,&
&2.8032E+00_JPRB,3.2661E+00_JPRB,3.5953E+00_JPRB,3.7400E+00_JPRB/)
KAO( :, 3, 7,14) = (/&
&5.4120E+00_JPRB,4.7356E+00_JPRB,4.1395E+00_JPRB,3.7778E+00_JPRB,3.3513E+00_JPRB,3.1688E+00_JPRB,&
&3.6572E+00_JPRB,4.2574E+00_JPRB,4.6459E+00_JPRB,4.8805E+00_JPRB/)
KAO( :, 4, 7,14) = (/&
&6.5428E+00_JPRB,5.7250E+00_JPRB,5.0639E+00_JPRB,4.5620E+00_JPRB,4.0362E+00_JPRB,3.9521E+00_JPRB,&
&4.6701E+00_JPRB,5.4350E+00_JPRB,5.8814E+00_JPRB,6.2344E+00_JPRB/)
KAO( :, 5, 7,14) = (/&
&7.7011E+00_JPRB,6.7385E+00_JPRB,6.0359E+00_JPRB,5.3689E+00_JPRB,4.7398E+00_JPRB,4.8671E+00_JPRB,&
&5.8104E+00_JPRB,6.7609E+00_JPRB,7.2855E+00_JPRB,7.7564E+00_JPRB/)
KAO( :, 1, 8,14) = (/&
&2.8332E+00_JPRB,2.4790E+00_JPRB,2.1588E+00_JPRB,2.0517E+00_JPRB,1.8212E+00_JPRB,1.6427E+00_JPRB,&
&1.7555E+00_JPRB,2.0463E+00_JPRB,2.2808E+00_JPRB,2.3417E+00_JPRB/)
KAO( :, 2, 8,14) = (/&
&3.7845E+00_JPRB,3.3115E+00_JPRB,2.9062E+00_JPRB,2.7307E+00_JPRB,2.4002E+00_JPRB,2.2076E+00_JPRB,&
&2.4394E+00_JPRB,2.8424E+00_JPRB,3.1489E+00_JPRB,3.2550E+00_JPRB/)
KAO( :, 3, 8,14) = (/&
&4.8341E+00_JPRB,4.2299E+00_JPRB,3.7584E+00_JPRB,3.4582E+00_JPRB,3.0437E+00_JPRB,2.8748E+00_JPRB,&
&3.2834E+00_JPRB,3.8242E+00_JPRB,4.1983E+00_JPRB,4.3823E+00_JPRB/)
KAO( :, 4, 8,14) = (/&
&5.9611E+00_JPRB,5.2160E+00_JPRB,4.6841E+00_JPRB,4.2257E+00_JPRB,3.7381E+00_JPRB,3.6695E+00_JPRB,&
&4.3008E+00_JPRB,5.0080E+00_JPRB,5.4653E+00_JPRB,5.7413E+00_JPRB/)
KAO( :, 5, 8,14) = (/&
&7.1388E+00_JPRB,6.2465E+00_JPRB,5.6516E+00_JPRB,5.0317E+00_JPRB,4.4851E+00_JPRB,4.5966E+00_JPRB,&
&5.4606E+00_JPRB,6.3571E+00_JPRB,6.9303E+00_JPRB,7.2901E+00_JPRB/)
KAO( :, 1, 9,14) = (/&
&2.3712E+00_JPRB,2.0748E+00_JPRB,1.8514E+00_JPRB,1.7610E+00_JPRB,1.5410E+00_JPRB,1.3776E+00_JPRB,&
&1.4602E+00_JPRB,1.7019E+00_JPRB,1.8917E+00_JPRB,1.9491E+00_JPRB/)
KAO( :, 2, 9,14) = (/&
&3.2706E+00_JPRB,2.8618E+00_JPRB,2.5535E+00_JPRB,2.4121E+00_JPRB,2.0953E+00_JPRB,1.9091E+00_JPRB,&
&2.0867E+00_JPRB,2.4315E+00_JPRB,2.6961E+00_JPRB,2.7855E+00_JPRB/)
KAO( :, 3, 9,14) = (/&
&4.2928E+00_JPRB,3.7562E+00_JPRB,3.3707E+00_JPRB,3.1325E+00_JPRB,2.7323E+00_JPRB,2.5568E+00_JPRB,&
&2.8897E+00_JPRB,3.3658E+00_JPRB,3.7112E+00_JPRB,3.8566E+00_JPRB/)
KAO( :, 4, 9,14) = (/&
&5.4084E+00_JPRB,4.7324E+00_JPRB,4.2872E+00_JPRB,3.9074E+00_JPRB,3.4333E+00_JPRB,3.3403E+00_JPRB,&
&3.8759E+00_JPRB,4.5148E+00_JPRB,4.9657E+00_JPRB,5.1730E+00_JPRB/)
KAO( :, 5, 9,14) = (/&
&6.5945E+00_JPRB,5.7702E+00_JPRB,5.2612E+00_JPRB,4.7341E+00_JPRB,4.2027E+00_JPRB,4.2619E+00_JPRB,&
&5.0203E+00_JPRB,5.8475E+00_JPRB,6.4247E+00_JPRB,6.7007E+00_JPRB/)
KAO( :, 1,10,14) = (/&
&2.0238E+00_JPRB,1.7709E+00_JPRB,1.6271E+00_JPRB,1.5213E+00_JPRB,1.3211E+00_JPRB,1.1708E+00_JPRB,&
&1.2470E+00_JPRB,1.4529E+00_JPRB,1.6100E+00_JPRB,4.3675E+00_JPRB/)
KAO( :, 2,10,14) = (/&
&2.8739E+00_JPRB,2.5147E+00_JPRB,2.3020E+00_JPRB,2.1393E+00_JPRB,1.8575E+00_JPRB,1.6735E+00_JPRB,&
&1.8305E+00_JPRB,2.1324E+00_JPRB,2.3565E+00_JPRB,4.3227E+00_JPRB/)
KAO( :, 3,10,14) = (/&
&3.8650E+00_JPRB,3.3819E+00_JPRB,3.1009E+00_JPRB,2.8438E+00_JPRB,2.4832E+00_JPRB,2.3021E+00_JPRB,&
&2.5924E+00_JPRB,3.0194E+00_JPRB,3.3202E+00_JPRB,4.3938E+00_JPRB/)
KAO( :, 4,10,14) = (/&
&4.9777E+00_JPRB,4.3555E+00_JPRB,3.9964E+00_JPRB,3.6309E+00_JPRB,3.1871E+00_JPRB,3.0700E+00_JPRB,&
&3.5258E+00_JPRB,4.1073E+00_JPRB,4.5249E+00_JPRB,4.9612E+00_JPRB/)
KAO( :, 5,10,14) = (/&
&6.1825E+00_JPRB,5.4114E+00_JPRB,4.9528E+00_JPRB,4.4825E+00_JPRB,3.9869E+00_JPRB,3.9806E+00_JPRB,&
&4.6382E+00_JPRB,5.4027E+00_JPRB,5.9521E+00_JPRB,6.1940E+00_JPRB/)
KAO( :, 1,11,14) = (/&
&2.0804E+00_JPRB,1.8204E+00_JPRB,1.7005E+00_JPRB,1.5536E+00_JPRB,1.3500E+00_JPRB,1.2044E+00_JPRB,&
&1.3053E+00_JPRB,1.5201E+00_JPRB,1.6683E+00_JPRB,7.0995E+00_JPRB/)
KAO( :, 2,11,14) = (/&
&2.9372E+00_JPRB,2.5710E+00_JPRB,2.4123E+00_JPRB,2.1876E+00_JPRB,1.9103E+00_JPRB,1.7356E+00_JPRB,&
&1.9131E+00_JPRB,2.2284E+00_JPRB,2.4493E+00_JPRB,7.0950E+00_JPRB/)
KAO( :, 3,11,14) = (/&
&3.9628E+00_JPRB,3.4731E+00_JPRB,3.2411E+00_JPRB,2.9265E+00_JPRB,2.5614E+00_JPRB,2.3947E+00_JPRB,&
&2.6976E+00_JPRB,3.1434E+00_JPRB,3.4700E+00_JPRB,6.9637E+00_JPRB/)
KAO( :, 4,11,14) = (/&
&5.1248E+00_JPRB,4.4937E+00_JPRB,4.1603E+00_JPRB,3.7597E+00_JPRB,3.3177E+00_JPRB,3.2015E+00_JPRB,&
&3.6687E+00_JPRB,4.2746E+00_JPRB,4.7220E+00_JPRB,6.9069E+00_JPRB/)
KAO( :, 5,11,14) = (/&
&6.4048E+00_JPRB,5.6238E+00_JPRB,5.1596E+00_JPRB,4.6653E+00_JPRB,4.1869E+00_JPRB,4.1503E+00_JPRB,&
&4.8291E+00_JPRB,5.6278E+00_JPRB,6.2131E+00_JPRB,7.3735E+00_JPRB/)
KAO( :, 1,12,14) = (/&
&2.1606E+00_JPRB,1.8919E+00_JPRB,1.7776E+00_JPRB,1.5988E+00_JPRB,1.3931E+00_JPRB,1.2607E+00_JPRB,&
&1.3765E+00_JPRB,1.6030E+00_JPRB,1.7584E+00_JPRB,8.8539E+00_JPRB/)
KAO( :, 2,12,14) = (/&
&3.0241E+00_JPRB,2.6538E+00_JPRB,2.5108E+00_JPRB,2.2558E+00_JPRB,1.9760E+00_JPRB,1.8135E+00_JPRB,&
&2.0048E+00_JPRB,2.3354E+00_JPRB,2.5682E+00_JPRB,8.8299E+00_JPRB/)
KAO( :, 3,12,14) = (/&
&4.0854E+00_JPRB,3.5917E+00_JPRB,3.3758E+00_JPRB,3.0347E+00_JPRB,2.6732E+00_JPRB,2.5117E+00_JPRB,&
&2.8106E+00_JPRB,3.2743E+00_JPRB,3.6095E+00_JPRB,8.6670E+00_JPRB/)
KAO( :, 4,12,14) = (/&
&5.3044E+00_JPRB,4.6786E+00_JPRB,4.3443E+00_JPRB,3.9213E+00_JPRB,3.4969E+00_JPRB,3.3585E+00_JPRB,&
&3.8040E+00_JPRB,4.4330E+00_JPRB,4.9075E+00_JPRB,8.5700E+00_JPRB/)
KAO( :, 5,12,14) = (/&
&6.6440E+00_JPRB,5.8812E+00_JPRB,5.4120E+00_JPRB,4.9125E+00_JPRB,4.4282E+00_JPRB,4.3429E+00_JPRB,&
&4.9855E+00_JPRB,5.8102E+00_JPRB,6.4492E+00_JPRB,8.6830E+00_JPRB/)
KAO( :, 1,13,14) = (/&
&2.2525E+00_JPRB,1.9864E+00_JPRB,1.8643E+00_JPRB,1.6602E+00_JPRB,1.4614E+00_JPRB,1.3350E+00_JPRB,&
&1.4569E+00_JPRB,1.6960E+00_JPRB,1.8539E+00_JPRB,8.7601E+00_JPRB/)
KAO( :, 2,13,14) = (/&
&3.1332E+00_JPRB,2.7632E+00_JPRB,2.6018E+00_JPRB,2.3367E+00_JPRB,2.0765E+00_JPRB,1.9171E+00_JPRB,&
&2.1105E+00_JPRB,2.4578E+00_JPRB,2.6945E+00_JPRB,8.6837E+00_JPRB/)
KAO( :, 3,13,14) = (/&
&4.2146E+00_JPRB,3.7269E+00_JPRB,3.4963E+00_JPRB,3.1609E+00_JPRB,2.8326E+00_JPRB,2.6522E+00_JPRB,&
&2.9390E+00_JPRB,3.4234E+00_JPRB,3.7715E+00_JPRB,8.5952E+00_JPRB/)
KAO( :, 4,13,14) = (/&
&5.4718E+00_JPRB,4.8645E+00_JPRB,4.5313E+00_JPRB,4.1221E+00_JPRB,3.7163E+00_JPRB,3.5387E+00_JPRB,&
&3.9442E+00_JPRB,4.5945E+00_JPRB,5.0796E+00_JPRB,8.5494E+00_JPRB/)
KAO( :, 5,13,14) = (/&
&6.8761E+00_JPRB,6.1372E+00_JPRB,5.6718E+00_JPRB,5.2229E+00_JPRB,4.7155E+00_JPRB,4.5637E+00_JPRB,&
&5.1163E+00_JPRB,5.9645E+00_JPRB,6.6388E+00_JPRB,8.7275E+00_JPRB/)
KAO( :, 1, 1,15) = (/&
&7.4038E+00_JPRB,6.4785E+00_JPRB,5.5532E+00_JPRB,4.6280E+00_JPRB,3.7389E+00_JPRB,4.3853E+00_JPRB,&
&5.2514E+00_JPRB,6.0902E+00_JPRB,6.2346E+00_JPRB,6.5981E+00_JPRB/)
KAO( :, 2, 1,15) = (/&
&8.5770E+00_JPRB,7.5051E+00_JPRB,6.4332E+00_JPRB,5.3613E+00_JPRB,4.4922E+00_JPRB,5.5332E+00_JPRB,&
&6.6248E+00_JPRB,7.6856E+00_JPRB,7.8788E+00_JPRB,8.3358E+00_JPRB/)
KAO( :, 3, 1,15) = (/&
&9.7196E+00_JPRB,8.4924E+00_JPRB,7.2901E+00_JPRB,6.0754E+00_JPRB,5.4287E+00_JPRB,6.7758E+00_JPRB,&
&8.1174E+00_JPRB,9.4295E+00_JPRB,9.6454E+00_JPRB,1.0231E+01_JPRB/)
KAO( :, 4, 1,15) = (/&
&1.0823E+01_JPRB,9.4701E+00_JPRB,8.1175E+00_JPRB,6.7650E+00_JPRB,6.4845E+00_JPRB,8.0968E+00_JPRB,&
&9.6971E+00_JPRB,1.1247E+01_JPRB,1.1535E+01_JPRB,1.2232E+01_JPRB/)
KAO( :, 5, 1,15) = (/&
&1.1862E+01_JPRB,1.0380E+01_JPRB,8.8975E+00_JPRB,7.4149E+00_JPRB,7.5987E+00_JPRB,9.4854E+00_JPRB,&
&1.1367E+01_JPRB,1.3183E+01_JPRB,1.3535E+01_JPRB,1.4322E+01_JPRB/)
KAO( :, 1, 2,15) = (/&
&7.2487E+00_JPRB,6.3428E+00_JPRB,5.4369E+00_JPRB,4.5309E+00_JPRB,3.8305E+00_JPRB,4.6866E+00_JPRB,&
&5.6122E+00_JPRB,6.5109E+00_JPRB,6.6944E+00_JPRB,7.2237E+00_JPRB/)
KAO( :, 2, 2,15) = (/&
&8.4632E+00_JPRB,7.4054E+00_JPRB,6.3477E+00_JPRB,5.2900E+00_JPRB,4.7972E+00_JPRB,5.9774E+00_JPRB,&
&7.1612E+00_JPRB,8.3091E+00_JPRB,8.5448E+00_JPRB,9.2203E+00_JPRB/)
KAO( :, 3, 2,15) = (/&
&9.6376E+00_JPRB,8.4331E+00_JPRB,7.2286E+00_JPRB,6.0241E+00_JPRB,5.9277E+00_JPRB,7.4032E+00_JPRB,&
&8.8670E+00_JPRB,1.0288E+01_JPRB,1.0591E+01_JPRB,1.1420E+01_JPRB/)
KAO( :, 4, 2,15) = (/&
&1.0787E+01_JPRB,9.4386E+00_JPRB,8.0905E+00_JPRB,6.7423E+00_JPRB,7.1365E+00_JPRB,8.9120E+00_JPRB,&
&1.0675E+01_JPRB,1.2387E+01_JPRB,1.2766E+01_JPRB,1.3751E+01_JPRB/)
KAO( :, 5, 2,15) = (/&
&1.1876E+01_JPRB,1.0392E+01_JPRB,8.9076E+00_JPRB,7.4263E+00_JPRB,8.4093E+00_JPRB,1.0502E+01_JPRB,&
&1.2577E+01_JPRB,1.4600E+01_JPRB,1.5061E+01_JPRB,1.6216E+01_JPRB/)
KAO( :, 1, 3,15) = (/&
&6.8060E+00_JPRB,5.9554E+00_JPRB,5.1048E+00_JPRB,4.2541E+00_JPRB,3.7945E+00_JPRB,4.6793E+00_JPRB,&
&5.6066E+00_JPRB,6.5069E+00_JPRB,6.7262E+00_JPRB,7.3705E+00_JPRB/)
KAO( :, 2, 3,15) = (/&
&8.0512E+00_JPRB,7.0449E+00_JPRB,6.0387E+00_JPRB,5.0324E+00_JPRB,4.8723E+00_JPRB,6.0807E+00_JPRB,&
&7.2845E+00_JPRB,8.4534E+00_JPRB,8.7471E+00_JPRB,9.5785E+00_JPRB/)
KAO( :, 3, 3,15) = (/&
&9.2771E+00_JPRB,8.1176E+00_JPRB,6.9581E+00_JPRB,5.7986E+00_JPRB,6.1227E+00_JPRB,7.6490E+00_JPRB,&
&9.1620E+00_JPRB,1.0634E+01_JPRB,1.1013E+01_JPRB,1.2049E+01_JPRB/)
KAO( :, 4, 3,15) = (/&
&1.0461E+01_JPRB,9.1535E+00_JPRB,7.8460E+00_JPRB,6.5548E+00_JPRB,7.4810E+00_JPRB,9.3445E+00_JPRB,&
&1.1193E+01_JPRB,1.2995E+01_JPRB,1.3474E+01_JPRB,1.4726E+01_JPRB/)
KAO( :, 5, 3,15) = (/&
&1.1612E+01_JPRB,1.0161E+01_JPRB,8.7094E+00_JPRB,7.3963E+00_JPRB,8.9014E+00_JPRB,1.1119E+01_JPRB,&
&1.3323E+01_JPRB,1.5462E+01_JPRB,1.6055E+01_JPRB,1.7525E+01_JPRB/)
KAO( :, 1, 4,15) = (/&
&6.2727E+00_JPRB,5.4887E+00_JPRB,4.7047E+00_JPRB,3.9207E+00_JPRB,3.6525E+00_JPRB,4.5000E+00_JPRB,&
&5.3898E+00_JPRB,6.2588E+00_JPRB,6.5149E+00_JPRB,7.1567E+00_JPRB/)
KAO( :, 2, 4,15) = (/&
&7.5169E+00_JPRB,6.5774E+00_JPRB,5.6379E+00_JPRB,4.6985E+00_JPRB,4.7911E+00_JPRB,5.9751E+00_JPRB,&
&7.1596E+00_JPRB,8.3141E+00_JPRB,8.6620E+00_JPRB,9.5044E+00_JPRB/)
KAO( :, 3, 4,15) = (/&
&8.7861E+00_JPRB,7.6880E+00_JPRB,6.5898E+00_JPRB,5.5305E+00_JPRB,6.1247E+00_JPRB,7.6488E+00_JPRB,&
&9.1669E+00_JPRB,1.0645E+01_JPRB,1.1106E+01_JPRB,1.2173E+01_JPRB/)
KAO( :, 4, 4,15) = (/&
&1.0026E+01_JPRB,8.7728E+00_JPRB,7.5197E+00_JPRB,6.4473E+00_JPRB,7.6081E+00_JPRB,9.5022E+00_JPRB,&
&1.1386E+01_JPRB,1.3225E+01_JPRB,1.3819E+01_JPRB,1.5121E+01_JPRB/)
KAO( :, 5, 4,15) = (/&
&1.1215E+01_JPRB,9.8132E+00_JPRB,8.4117E+00_JPRB,7.4634E+00_JPRB,9.1763E+00_JPRB,1.1465E+01_JPRB,&
&1.3734E+01_JPRB,1.5956E+01_JPRB,1.6697E+01_JPRB,1.8243E+01_JPRB/)
KAO( :, 1, 5,15) = (/&
&5.7094E+00_JPRB,4.9958E+00_JPRB,4.2822E+00_JPRB,3.5751E+00_JPRB,3.4456E+00_JPRB,4.2408E+00_JPRB,&
&5.0808E+00_JPRB,5.9001E+00_JPRB,6.1640E+00_JPRB,6.7724E+00_JPRB/)
KAO( :, 2, 5,15) = (/&
&6.9610E+00_JPRB,6.0909E+00_JPRB,5.2209E+00_JPRB,4.3950E+00_JPRB,4.6160E+00_JPRB,5.7378E+00_JPRB,&
&6.8746E+00_JPRB,7.9877E+00_JPRB,8.3933E+00_JPRB,9.1641E+00_JPRB/)
KAO( :, 3, 5,15) = (/&
&8.2452E+00_JPRB,7.2146E+00_JPRB,6.1840E+00_JPRB,5.2978E+00_JPRB,5.9973E+00_JPRB,7.4900E+00_JPRB,&
&8.9757E+00_JPRB,1.0429E+01_JPRB,1.0974E+01_JPRB,1.1967E+01_JPRB/)
KAO( :, 4, 5,15) = (/&
&9.5317E+00_JPRB,8.3403E+00_JPRB,7.1489E+00_JPRB,6.3594E+00_JPRB,7.5690E+00_JPRB,9.4570E+00_JPRB,&
&1.1330E+01_JPRB,1.3166E+01_JPRB,1.3879E+01_JPRB,1.5102E+01_JPRB/)
KAO( :, 5, 5,15) = (/&
&1.0774E+01_JPRB,9.4271E+00_JPRB,8.0808E+00_JPRB,7.5165E+00_JPRB,9.2600E+00_JPRB,1.1570E+01_JPRB,&
&1.3864E+01_JPRB,1.6116E+01_JPRB,1.7021E+01_JPRB,1.8481E+01_JPRB/)
KAO( :, 1, 6,15) = (/&
&5.0892E+00_JPRB,4.4531E+00_JPRB,3.8170E+00_JPRB,3.2199E+00_JPRB,3.2113E+00_JPRB,4.0113E+00_JPRB,&
&4.8052E+00_JPRB,5.5784E+00_JPRB,5.7946E+00_JPRB,6.4168E+00_JPRB/)
KAO( :, 2, 6,15) = (/&
&6.3415E+00_JPRB,5.5489E+00_JPRB,4.7563E+00_JPRB,4.0482E+00_JPRB,4.3407E+00_JPRB,5.4212E+00_JPRB,&
&6.4943E+00_JPRB,7.5434E+00_JPRB,7.9031E+00_JPRB,8.6734E+00_JPRB/)
KAO( :, 3, 6,15) = (/&
&7.6230E+00_JPRB,6.6701E+00_JPRB,5.7173E+00_JPRB,5.0372E+00_JPRB,5.7049E+00_JPRB,7.1268E+00_JPRB,&
&8.5427E+00_JPRB,9.9277E+00_JPRB,1.0503E+01_JPRB,1.1401E+01_JPRB/)
KAO( :, 4, 6,15) = (/&
&8.9427E+00_JPRB,7.8250E+00_JPRB,6.7072E+00_JPRB,6.1864E+00_JPRB,7.3054E+00_JPRB,9.1262E+00_JPRB,&
&1.0936E+01_JPRB,1.2717E+01_JPRB,1.3530E+01_JPRB,1.4596E+01_JPRB/)
KAO( :, 5, 6,15) = (/&
&1.0234E+01_JPRB,8.9552E+00_JPRB,7.6757E+00_JPRB,7.4408E+00_JPRB,9.0975E+00_JPRB,1.1364E+01_JPRB,&
&1.3619E+01_JPRB,1.5837E+01_JPRB,1.6857E+01_JPRB,1.8182E+01_JPRB/)
KAO( :, 1, 7,15) = (/&
&4.4701E+00_JPRB,3.9114E+00_JPRB,3.3527E+00_JPRB,2.8491E+00_JPRB,3.0525E+00_JPRB,3.8120E+00_JPRB,&
&4.5671E+00_JPRB,5.3029E+00_JPRB,5.5170E+00_JPRB,6.1054E+00_JPRB/)
KAO( :, 2, 7,15) = (/&
&5.7025E+00_JPRB,4.9897E+00_JPRB,4.2769E+00_JPRB,3.7076E+00_JPRB,4.1441E+00_JPRB,5.1768E+00_JPRB,&
&6.2022E+00_JPRB,7.2045E+00_JPRB,7.5353E+00_JPRB,8.2888E+00_JPRB/)
KAO( :, 3, 7,15) = (/&
&6.9903E+00_JPRB,6.1166E+00_JPRB,5.2429E+00_JPRB,4.7421E+00_JPRB,5.4711E+00_JPRB,6.8345E+00_JPRB,&
&8.1908E+00_JPRB,9.5158E+00_JPRB,1.0021E+01_JPRB,1.0944E+01_JPRB/)
KAO( :, 4, 7,15) = (/&
&8.3116E+00_JPRB,7.2727E+00_JPRB,6.2339E+00_JPRB,5.9347E+00_JPRB,7.0277E+00_JPRB,8.7788E+00_JPRB,&
&1.0523E+01_JPRB,1.2229E+01_JPRB,1.2970E+01_JPRB,1.4056E+01_JPRB/)
KAO( :, 5, 7,15) = (/&
&9.6433E+00_JPRB,8.4379E+00_JPRB,7.2404E+00_JPRB,7.2539E+00_JPRB,8.8191E+00_JPRB,1.1015E+01_JPRB,&
&1.3202E+01_JPRB,1.5351E+01_JPRB,1.6381E+01_JPRB,1.7636E+01_JPRB/)
KAO( :, 1, 8,15) = (/&
&3.8815E+00_JPRB,3.3963E+00_JPRB,2.9112E+00_JPRB,2.5144E+00_JPRB,2.8901E+00_JPRB,3.6107E+00_JPRB,&
&4.3267E+00_JPRB,5.0237E+00_JPRB,5.2562E+00_JPRB,5.7843E+00_JPRB/)
KAO( :, 2, 8,15) = (/&
&5.0803E+00_JPRB,4.4453E+00_JPRB,3.8103E+00_JPRB,3.3588E+00_JPRB,3.9581E+00_JPRB,4.9433E+00_JPRB,&
&5.9245E+00_JPRB,6.8831E+00_JPRB,7.2246E+00_JPRB,7.9205E+00_JPRB/)
KAO( :, 3, 8,15) = (/&
&6.3642E+00_JPRB,5.5687E+00_JPRB,4.7732E+00_JPRB,4.4061E+00_JPRB,5.2635E+00_JPRB,6.5746E+00_JPRB,&
&7.8793E+00_JPRB,9.1591E+00_JPRB,9.6612E+00_JPRB,1.0533E+01_JPRB/)
KAO( :, 4, 8,15) = (/&
&7.6962E+00_JPRB,6.7342E+00_JPRB,5.8016E+00_JPRB,5.6218E+00_JPRB,6.8073E+00_JPRB,8.5035E+00_JPRB,&
&1.0191E+01_JPRB,1.1842E+01_JPRB,1.2564E+01_JPRB,1.3618E+01_JPRB/)
KAO( :, 5, 8,15) = (/&
&9.0600E+00_JPRB,7.9276E+00_JPRB,6.8887E+00_JPRB,6.9782E+00_JPRB,8.5965E+00_JPRB,1.0738E+01_JPRB,&
&1.2872E+01_JPRB,1.4959E+01_JPRB,1.5916E+01_JPRB,1.7201E+01_JPRB/)
KAO( :, 1, 9,15) = (/&
&3.3248E+00_JPRB,2.9093E+00_JPRB,2.4937E+00_JPRB,2.2724E+00_JPRB,2.6961E+00_JPRB,3.3684E+00_JPRB,&
&4.0359E+00_JPRB,4.6900E+00_JPRB,4.9499E+00_JPRB,5.3973E+00_JPRB/)
KAO( :, 2, 9,15) = (/&
&4.4808E+00_JPRB,3.9207E+00_JPRB,3.3615E+00_JPRB,3.0920E+00_JPRB,3.7395E+00_JPRB,4.6706E+00_JPRB,&
&5.5971E+00_JPRB,6.5044E+00_JPRB,6.8727E+00_JPRB,7.4836E+00_JPRB/)
KAO( :, 3, 9,15) = (/&
&5.7505E+00_JPRB,5.0317E+00_JPRB,4.3435E+00_JPRB,4.1016E+00_JPRB,5.0205E+00_JPRB,6.2714E+00_JPRB,&
&7.5160E+00_JPRB,8.7397E+00_JPRB,9.2709E+00_JPRB,1.0047E+01_JPRB/)
KAO( :, 4, 9,15) = (/&
&7.0908E+00_JPRB,6.2044E+00_JPRB,5.3782E+00_JPRB,5.2882E+00_JPRB,6.5597E+00_JPRB,8.1944E+00_JPRB,&
&9.8217E+00_JPRB,1.1416E+01_JPRB,1.2142E+01_JPRB,1.3130E+01_JPRB/)
KAO( :, 5, 9,15) = (/&
&8.4732E+00_JPRB,7.4141E+00_JPRB,6.4913E+00_JPRB,6.6287E+00_JPRB,8.3565E+00_JPRB,1.0438E+01_JPRB,&
&1.2512E+01_JPRB,1.4551E+01_JPRB,1.5514E+01_JPRB,1.6723E+01_JPRB/)
KAO( :, 1,10,15) = (/&
&2.8920E+00_JPRB,2.5306E+00_JPRB,2.1693E+00_JPRB,2.0986E+00_JPRB,2.5124E+00_JPRB,3.1388E+00_JPRB,&
&3.7625E+00_JPRB,4.3752E+00_JPRB,4.6672E+00_JPRB,5.6157E+00_JPRB/)
KAO( :, 2,10,15) = (/&
&4.0040E+00_JPRB,3.5035E+00_JPRB,3.0238E+00_JPRB,2.9376E+00_JPRB,3.5667E+00_JPRB,4.4559E+00_JPRB,&
&5.3416E+00_JPRB,6.2115E+00_JPRB,6.6210E+00_JPRB,7.1691E+00_JPRB/)
KAO( :, 3,10,15) = (/&
&5.2529E+00_JPRB,4.5963E+00_JPRB,3.9804E+00_JPRB,3.9436E+00_JPRB,4.8397E+00_JPRB,6.0465E+00_JPRB,&
&7.2474E+00_JPRB,8.4282E+00_JPRB,9.0023E+00_JPRB,9.6885E+00_JPRB/)
KAO( :, 4,10,15) = (/&
&6.6009E+00_JPRB,5.7758E+00_JPRB,5.0451E+00_JPRB,5.1236E+00_JPRB,6.3901E+00_JPRB,7.9831E+00_JPRB,&
&9.5690E+00_JPRB,1.1128E+01_JPRB,1.1898E+01_JPRB,1.2790E+01_JPRB/)
KAO( :, 5,10,15) = (/&
&8.0358E+00_JPRB,7.0314E+00_JPRB,6.2146E+00_JPRB,6.4650E+00_JPRB,8.1964E+00_JPRB,1.0240E+01_JPRB,&
&1.2274E+01_JPRB,1.4283E+01_JPRB,1.5317E+01_JPRB,1.6405E+01_JPRB/)
KAO( :, 1,11,15) = (/&
&2.9597E+00_JPRB,2.5897E+00_JPRB,2.2655E+00_JPRB,2.2769E+00_JPRB,2.7359E+00_JPRB,3.4131E+00_JPRB,&
&4.0924E+00_JPRB,4.7622E+00_JPRB,5.1369E+00_JPRB,8.7664E+00_JPRB/)
KAO( :, 2,11,15) = (/&
&4.1090E+00_JPRB,3.5954E+00_JPRB,3.1274E+00_JPRB,3.2086E+00_JPRB,3.8891E+00_JPRB,4.8589E+00_JPRB,&
&5.8255E+00_JPRB,6.7761E+00_JPRB,7.2974E+00_JPRB,9.1429E+00_JPRB/)
KAO( :, 3,11,15) = (/&
&5.4257E+00_JPRB,4.7475E+00_JPRB,4.1432E+00_JPRB,4.3071E+00_JPRB,5.2960E+00_JPRB,6.6178E+00_JPRB,&
&7.9327E+00_JPRB,9.2300E+00_JPRB,9.9139E+00_JPRB,1.0877E+01_JPRB/)
KAO( :, 4,11,15) = (/&
&6.8635E+00_JPRB,6.0056E+00_JPRB,5.3031E+00_JPRB,5.5726E+00_JPRB,6.9728E+00_JPRB,8.7117E+00_JPRB,&
&1.0444E+01_JPRB,1.2152E+01_JPRB,1.3068E+01_JPRB,1.3956E+01_JPRB/)
KAO( :, 5,11,15) = (/&
&8.4007E+00_JPRB,7.3506E+00_JPRB,6.6010E+00_JPRB,7.0376E+00_JPRB,8.9249E+00_JPRB,1.1150E+01_JPRB,&
&1.3367E+01_JPRB,1.5547E+01_JPRB,1.6736E+01_JPRB,1.7861E+01_JPRB/)
KAO( :, 1,12,15) = (/&
&3.0706E+00_JPRB,2.6868E+00_JPRB,2.3786E+00_JPRB,2.4650E+00_JPRB,2.9376E+00_JPRB,3.6606E+00_JPRB,&
&4.3900E+00_JPRB,5.1097E+00_JPRB,5.5523E+00_JPRB,1.1122E+01_JPRB/)
KAO( :, 2,12,15) = (/&
&4.2894E+00_JPRB,3.7532E+00_JPRB,3.3135E+00_JPRB,3.4942E+00_JPRB,4.2139E+00_JPRB,5.2646E+00_JPRB,&
&6.3121E+00_JPRB,7.3466E+00_JPRB,7.9376E+00_JPRB,1.1136E+01_JPRB/)
KAO( :, 3,12,15) = (/&
&5.6884E+00_JPRB,4.9773E+00_JPRB,4.4260E+00_JPRB,4.7039E+00_JPRB,5.7519E+00_JPRB,7.1866E+00_JPRB,&
&8.6165E+00_JPRB,1.0029E+01_JPRB,1.0827E+01_JPRB,1.2499E+01_JPRB/)
KAO( :, 4,12,15) = (/&
&7.2505E+00_JPRB,6.3448E+00_JPRB,5.7066E+00_JPRB,6.0941E+00_JPRB,7.5592E+00_JPRB,9.4443E+00_JPRB,&
&1.1323E+01_JPRB,1.3172E+01_JPRB,1.4230E+01_JPRB,1.5157E+01_JPRB/)
KAO( :, 5,12,15) = (/&
&8.9729E+00_JPRB,7.8513E+00_JPRB,7.1677E+00_JPRB,7.7018E+00_JPRB,9.6945E+00_JPRB,1.2112E+01_JPRB,&
&1.4519E+01_JPRB,1.6896E+01_JPRB,1.8235E+01_JPRB,1.9402E+01_JPRB/)
KAO( :, 1,13,15) = (/&
&3.2246E+00_JPRB,2.8216E+00_JPRB,2.5410E+00_JPRB,2.6672E+00_JPRB,3.1335E+00_JPRB,3.8953E+00_JPRB,&
&4.6718E+00_JPRB,5.4398E+00_JPRB,5.9398E+00_JPRB,1.1048E+01_JPRB/)
KAO( :, 2,13,15) = (/&
&4.5396E+00_JPRB,3.9722E+00_JPRB,3.6057E+00_JPRB,3.8124E+00_JPRB,4.5235E+00_JPRB,5.6334E+00_JPRB,&
&6.7551E+00_JPRB,7.8654E+00_JPRB,8.5655E+00_JPRB,1.1523E+01_JPRB/)
KAO( :, 3,13,15) = (/&
&6.0822E+00_JPRB,5.3219E+00_JPRB,4.8716E+00_JPRB,5.1514E+00_JPRB,6.1861E+00_JPRB,7.7214E+00_JPRB,&
&9.2581E+00_JPRB,1.0776E+01_JPRB,1.1699E+01_JPRB,1.3150E+01_JPRB/)
KAO( :, 4,13,15) = (/&
&7.8600E+00_JPRB,6.8777E+00_JPRB,6.3193E+00_JPRB,6.6903E+00_JPRB,8.1367E+00_JPRB,1.0164E+01_JPRB,&
&1.2187E+01_JPRB,1.4188E+01_JPRB,1.5392E+01_JPRB,1.6289E+01_JPRB/)
KAO( :, 5,13,15) = (/&
&9.8483E+00_JPRB,8.6182E+00_JPRB,7.9619E+00_JPRB,8.4555E+00_JPRB,1.0467E+01_JPRB,1.3077E+01_JPRB,&
&1.5680E+01_JPRB,1.8246E+01_JPRB,1.9749E+01_JPRB,2.0946E+01_JPRB/)
KAO( :, 1, 1,16) = (/&
&7.5127E+00_JPRB,6.5737E+00_JPRB,5.6349E+00_JPRB,4.6958E+00_JPRB,3.8779E+00_JPRB,4.8416E+00_JPRB,&
&5.7981E+00_JPRB,6.7189E+00_JPRB,6.8002E+00_JPRB,7.2408E+00_JPRB/)
KAO( :, 2, 1,16) = (/&
&8.6979E+00_JPRB,7.6109E+00_JPRB,6.5239E+00_JPRB,5.4368E+00_JPRB,4.7903E+00_JPRB,5.9807E+00_JPRB,&
&7.1609E+00_JPRB,8.2994E+00_JPRB,8.3109E+00_JPRB,8.9455E+00_JPRB/)
KAO( :, 3, 1,16) = (/&
&9.7317E+00_JPRB,8.6042E+00_JPRB,7.2993E+00_JPRB,6.0830E+00_JPRB,5.8526E+00_JPRB,7.3076E+00_JPRB,&
&8.7490E+00_JPRB,1.0034E+01_JPRB,1.0263E+01_JPRB,1.0816E+01_JPRB/)
KAO( :, 4, 1,16) = (/&
&1.0961E+01_JPRB,9.5913E+00_JPRB,8.2214E+00_JPRB,6.8514E+00_JPRB,7.1532E+00_JPRB,8.9336E+00_JPRB,&
&1.0696E+01_JPRB,1.2395E+01_JPRB,1.2541E+01_JPRB,1.3218E+01_JPRB/)
KAO( :, 5, 1,16) = (/&
&1.2007E+01_JPRB,1.0506E+01_JPRB,9.0063E+00_JPRB,7.5055E+00_JPRB,8.5533E+00_JPRB,1.0682E+01_JPRB,&
&1.2789E+01_JPRB,1.4823E+01_JPRB,1.5003E+01_JPRB,1.5975E+01_JPRB/)
KAO( :, 1, 2,16) = (/&
&7.3731E+00_JPRB,6.4516E+00_JPRB,5.5301E+00_JPRB,4.6086E+00_JPRB,4.2937E+00_JPRB,5.3609E+00_JPRB,&
&6.4198E+00_JPRB,7.4408E+00_JPRB,7.5329E+00_JPRB,8.2124E+00_JPRB/)
KAO( :, 2, 2,16) = (/&
&8.6021E+00_JPRB,7.5271E+00_JPRB,6.4520E+00_JPRB,5.3768E+00_JPRB,5.3675E+00_JPRB,6.7018E+00_JPRB,&
&8.0237E+00_JPRB,9.2997E+00_JPRB,9.4140E+00_JPRB,1.0264E+01_JPRB/)
KAO( :, 3, 2,16) = (/&
&9.7888E+00_JPRB,8.5654E+00_JPRB,7.3420E+00_JPRB,6.1186E+00_JPRB,6.5496E+00_JPRB,8.1782E+00_JPRB,&
&9.7904E+00_JPRB,1.1344E+01_JPRB,1.1474E+01_JPRB,1.2519E+01_JPRB/)
KAO( :, 4, 2,16) = (/&
&1.0945E+01_JPRB,9.5769E+00_JPRB,8.2090E+00_JPRB,6.8412E+00_JPRB,8.0474E+00_JPRB,1.0048E+01_JPRB,&
&1.2030E+01_JPRB,1.3944E+01_JPRB,1.4114E+01_JPRB,1.5388E+01_JPRB/)
KAO( :, 5, 2,16) = (/&
&1.2042E+01_JPRB,1.0537E+01_JPRB,9.0333E+00_JPRB,7.5280E+00_JPRB,9.7062E+00_JPRB,1.2117E+01_JPRB,&
&1.4511E+01_JPRB,1.6819E+01_JPRB,1.7024E+01_JPRB,1.8558E+01_JPRB/)
KAO( :, 1, 3,16) = (/&
&6.9437E+00_JPRB,6.0759E+00_JPRB,5.2080E+00_JPRB,4.3402E+00_JPRB,4.5023E+00_JPRB,5.6214E+00_JPRB,&
&6.7297E+00_JPRB,7.8026E+00_JPRB,7.9012E+00_JPRB,8.8155E+00_JPRB/)
KAO( :, 2, 3,16) = (/&
&8.2070E+00_JPRB,7.1813E+00_JPRB,6.1554E+00_JPRB,5.1298E+00_JPRB,5.7329E+00_JPRB,7.1578E+00_JPRB,&
&8.5699E+00_JPRB,9.9336E+00_JPRB,1.0060E+01_JPRB,1.1228E+01_JPRB/)
KAO( :, 3, 3,16) = (/&
&9.4491E+00_JPRB,8.2681E+00_JPRB,7.0872E+00_JPRB,5.9062E+00_JPRB,7.0707E+00_JPRB,8.8297E+00_JPRB,&
&1.0581E+01_JPRB,1.2262E+01_JPRB,1.2422E+01_JPRB,1.3860E+01_JPRB/)
KAO( :, 4, 3,16) = (/&
&1.0642E+01_JPRB,9.3115E+00_JPRB,7.9815E+00_JPRB,6.6515E+00_JPRB,8.6654E+00_JPRB,1.0819E+01_JPRB,&
&1.2954E+01_JPRB,1.5013E+01_JPRB,1.5194E+01_JPRB,1.6966E+01_JPRB/)
KAO( :, 5, 3,16) = (/&
&1.1807E+01_JPRB,1.0331E+01_JPRB,8.8554E+00_JPRB,7.9416E+00_JPRB,1.0582E+01_JPRB,1.3212E+01_JPRB,&
&1.5820E+01_JPRB,1.8322E+01_JPRB,1.8571E+01_JPRB,2.0721E+01_JPRB/)
KAO( :, 1, 4,16) = (/&
&6.4258E+00_JPRB,5.6226E+00_JPRB,4.8196E+00_JPRB,4.0164E+00_JPRB,4.5983E+00_JPRB,5.7339E+00_JPRB,&
&6.8740E+00_JPRB,7.9661E+00_JPRB,8.0728E+00_JPRB,9.1132E+00_JPRB/)
KAO( :, 2, 4,16) = (/&
&7.6917E+00_JPRB,6.7303E+00_JPRB,5.7690E+00_JPRB,4.8076E+00_JPRB,5.9866E+00_JPRB,7.4749E+00_JPRB,&
&8.9518E+00_JPRB,1.0377E+01_JPRB,1.0515E+01_JPRB,1.1857E+01_JPRB/)
KAO( :, 3, 4,16) = (/&
&8.9813E+00_JPRB,7.8586E+00_JPRB,6.7361E+00_JPRB,5.6678E+00_JPRB,7.5316E+00_JPRB,9.4038E+00_JPRB,&
&1.1247E+01_JPRB,1.3049E+01_JPRB,1.3228E+01_JPRB,1.4925E+01_JPRB/)
KAO( :, 4, 4,16) = (/&
&1.0239E+01_JPRB,8.9593E+00_JPRB,7.6796E+00_JPRB,6.9509E+00_JPRB,9.2615E+00_JPRB,1.1564E+01_JPRB,&
&1.3845E+01_JPRB,1.6028E+01_JPRB,1.6220E+01_JPRB,1.8333E+01_JPRB/)
KAO( :, 5, 4,16) = (/&
&1.1440E+01_JPRB,1.0010E+01_JPRB,8.5838E+00_JPRB,8.5098E+00_JPRB,1.1339E+01_JPRB,1.4159E+01_JPRB,&
&1.6953E+01_JPRB,1.9656E+01_JPRB,1.9906E+01_JPRB,2.2476E+01_JPRB/)
KAO( :, 1, 5,16) = (/&
&5.8770E+00_JPRB,5.1424E+00_JPRB,4.4079E+00_JPRB,3.6733E+00_JPRB,4.6297E+00_JPRB,5.7866E+00_JPRB,&
&6.9277E+00_JPRB,8.0308E+00_JPRB,8.1369E+00_JPRB,9.2272E+00_JPRB/)
KAO( :, 2, 5,16) = (/&
&7.1523E+00_JPRB,6.2582E+00_JPRB,5.3644E+00_JPRB,4.6413E+00_JPRB,6.1841E+00_JPRB,7.7213E+00_JPRB,&
&9.2461E+00_JPRB,1.0718E+01_JPRB,1.0873E+01_JPRB,1.2325E+01_JPRB/)
KAO( :, 3, 5,16) = (/&
&8.4613E+00_JPRB,7.4038E+00_JPRB,6.3462E+00_JPRB,5.9572E+00_JPRB,7.9337E+00_JPRB,9.9057E+00_JPRB,&
&1.1872E+01_JPRB,1.3758E+01_JPRB,1.3965E+01_JPRB,1.5800E+01_JPRB/)
KAO( :, 4, 5,16) = (/&
&9.7676E+00_JPRB,8.5468E+00_JPRB,7.3259E+00_JPRB,7.4238E+00_JPRB,9.8916E+00_JPRB,1.2352E+01_JPRB,&
&1.4791E+01_JPRB,1.7147E+01_JPRB,1.7384E+01_JPRB,1.9719E+01_JPRB/)
KAO( :, 5, 5,16) = (/&
&1.1025E+01_JPRB,9.6472E+00_JPRB,8.2716E+00_JPRB,9.1406E+00_JPRB,1.2179E+01_JPRB,1.5208E+01_JPRB,&
&1.8211E+01_JPRB,2.1097E+01_JPRB,2.1364E+01_JPRB,2.4267E+01_JPRB/)
KAO( :, 1, 6,16) = (/&
&5.2650E+00_JPRB,4.6069E+00_JPRB,3.9488E+00_JPRB,3.4184E+00_JPRB,4.5538E+00_JPRB,5.6834E+00_JPRB,&
&6.8059E+00_JPRB,7.8914E+00_JPRB,8.0145E+00_JPRB,9.0940E+00_JPRB/)
KAO( :, 2, 6,16) = (/&
&6.5470E+00_JPRB,5.7287E+00_JPRB,4.9104E+00_JPRB,4.6912E+00_JPRB,6.2505E+00_JPRB,7.8043E+00_JPRB,&
&9.3463E+00_JPRB,1.0825E+01_JPRB,1.1010E+01_JPRB,1.2479E+01_JPRB/)
KAO( :, 3, 6,16) = (/&
&7.8534E+00_JPRB,6.8718E+00_JPRB,5.8902E+00_JPRB,6.1640E+00_JPRB,8.2139E+00_JPRB,1.0257E+01_JPRB,&
&1.2274E+01_JPRB,1.4245E+01_JPRB,1.4468E+01_JPRB,1.6406E+01_JPRB/)
KAO( :, 4, 6,16) = (/&
&9.2007E+00_JPRB,8.0507E+00_JPRB,6.9007E+00_JPRB,7.8216E+00_JPRB,1.0421E+01_JPRB,1.3014E+01_JPRB,&
&1.5581E+01_JPRB,1.8055E+01_JPRB,1.8344E+01_JPRB,2.0809E+01_JPRB/)
KAO( :, 5, 6,16) = (/&
&1.0512E+01_JPRB,9.1984E+00_JPRB,7.8842E+00_JPRB,9.7429E+00_JPRB,1.2982E+01_JPRB,1.6206E+01_JPRB,&
&1.9407E+01_JPRB,2.2502E+01_JPRB,2.2789E+01_JPRB,2.5928E+01_JPRB/)
KAO( :, 1, 7,16) = (/&
&4.6565E+00_JPRB,4.0745E+00_JPRB,3.4925E+00_JPRB,3.2956E+00_JPRB,4.3911E+00_JPRB,5.4864E+00_JPRB,&
&6.5695E+00_JPRB,7.6115E+00_JPRB,7.7439E+00_JPRB,8.7837E+00_JPRB/)
KAO( :, 2, 7,16) = (/&
&5.9292E+00_JPRB,5.1881E+00_JPRB,4.4470E+00_JPRB,4.6697E+00_JPRB,6.2219E+00_JPRB,7.7686E+00_JPRB,&
&9.3043E+00_JPRB,1.0790E+01_JPRB,1.0982E+01_JPRB,1.2451E+01_JPRB/)
KAO( :, 3, 7,16) = (/&
&7.2576E+00_JPRB,6.3505E+00_JPRB,5.4433E+00_JPRB,6.2922E+00_JPRB,8.3823E+00_JPRB,1.0468E+01_JPRB,&
&1.2543E+01_JPRB,1.4536E+01_JPRB,1.4805E+01_JPRB,1.6765E+01_JPRB/)
KAO( :, 4, 7,16) = (/&
&8.6179E+00_JPRB,7.5406E+00_JPRB,6.4633E+00_JPRB,8.1550E+00_JPRB,1.0866E+01_JPRB,1.3567E+01_JPRB,&
&1.6244E+01_JPRB,1.8842E+01_JPRB,1.9186E+01_JPRB,2.1742E+01_JPRB/)
KAO( :, 5, 7,16) = (/&
&9.9851E+00_JPRB,8.7370E+00_JPRB,7.4898E+00_JPRB,1.0321E+01_JPRB,1.3752E+01_JPRB,1.7171E+01_JPRB,&
&2.0561E+01_JPRB,2.3825E+01_JPRB,2.4177E+01_JPRB,2.7508E+01_JPRB/)
KAO( :, 1, 8,16) = (/&
&4.0754E+00_JPRB,3.5660E+00_JPRB,3.0566E+00_JPRB,3.1333E+00_JPRB,4.1749E+00_JPRB,5.2109E+00_JPRB,&
&6.2379E+00_JPRB,7.2391E+00_JPRB,7.3822E+00_JPRB,8.3583E+00_JPRB/)
KAO( :, 2, 8,16) = (/&
&5.3273E+00_JPRB,4.6614E+00_JPRB,3.9956E+00_JPRB,4.5880E+00_JPRB,6.1132E+00_JPRB,7.6329E+00_JPRB,&
&9.1372E+00_JPRB,1.0600E+01_JPRB,1.0819E+01_JPRB,1.2238E+01_JPRB/)
KAO( :, 3, 8,16) = (/&
&6.6607E+00_JPRB,5.8281E+00_JPRB,4.9956E+00_JPRB,6.3489E+00_JPRB,8.4692E+00_JPRB,1.0575E+01_JPRB,&
&1.2658E+01_JPRB,1.4678E+01_JPRB,1.4991E+01_JPRB,1.6951E+01_JPRB/)
KAO( :, 4, 8,16) = (/&
&8.0394E+00_JPRB,7.0344E+00_JPRB,6.0296E+00_JPRB,8.4237E+00_JPRB,1.1224E+01_JPRB,1.4014E+01_JPRB,&
&1.6789E+01_JPRB,1.9460E+01_JPRB,1.9854E+01_JPRB,2.2470E+01_JPRB/)
KAO( :, 5, 8,16) = (/&
&9.4437E+00_JPRB,8.2633E+00_JPRB,7.2895E+00_JPRB,1.0868E+01_JPRB,1.4480E+01_JPRB,1.8081E+01_JPRB,&
&2.1653E+01_JPRB,2.5111E+01_JPRB,2.5514E+01_JPRB,2.8990E+01_JPRB/)
KAO( :, 1, 9,16) = (/&
&3.5121E+00_JPRB,3.0731E+00_JPRB,2.6341E+00_JPRB,2.9279E+00_JPRB,3.9013E+00_JPRB,4.8754E+00_JPRB,&
&5.8368E+00_JPRB,6.7644E+00_JPRB,6.8920E+00_JPRB,7.8150E+00_JPRB/)
KAO( :, 2, 9,16) = (/&
&4.7223E+00_JPRB,4.1321E+00_JPRB,3.5416E+00_JPRB,4.4240E+00_JPRB,5.8947E+00_JPRB,7.3602E+00_JPRB,&
&8.8237E+00_JPRB,1.0234E+01_JPRB,1.0473E+01_JPRB,1.1818E+01_JPRB/)
KAO( :, 3, 9,16) = (/&
&6.0478E+00_JPRB,5.2918E+00_JPRB,4.5359E+00_JPRB,6.3118E+00_JPRB,8.4105E+00_JPRB,1.0504E+01_JPRB,&
&1.2585E+01_JPRB,1.4594E+01_JPRB,1.4948E+01_JPRB,1.6837E+01_JPRB/)
KAO( :, 4, 9,16) = (/&
&7.4404E+00_JPRB,6.5104E+00_JPRB,5.8282E+00_JPRB,8.5908E+00_JPRB,1.1447E+01_JPRB,1.4294E+01_JPRB,&
&1.7119E+01_JPRB,1.9856E+01_JPRB,2.0299E+01_JPRB,2.2935E+01_JPRB/)
KAO( :, 5, 9,16) = (/&
&8.8732E+00_JPRB,7.7641E+00_JPRB,7.5539E+00_JPRB,1.1327E+01_JPRB,1.5093E+01_JPRB,1.8849E+01_JPRB,&
&2.2573E+01_JPRB,2.6165E+01_JPRB,2.6652E+01_JPRB,3.0230E+01_JPRB/)
KAO( :, 1,10,16) = (/&
&3.0618E+00_JPRB,2.6791E+00_JPRB,2.2964E+00_JPRB,2.9364E+00_JPRB,3.9126E+00_JPRB,4.8847E+00_JPRB,&
&5.8475E+00_JPRB,6.7808E+00_JPRB,6.8756E+00_JPRB,7.8358E+00_JPRB/)
KAO( :, 2,10,16) = (/&
&4.2316E+00_JPRB,3.7027E+00_JPRB,3.1743E+00_JPRB,4.3350E+00_JPRB,5.7762E+00_JPRB,7.2138E+00_JPRB,&
&8.6367E+00_JPRB,1.0019E+01_JPRB,1.0284E+01_JPRB,1.1570E+01_JPRB/)
KAO( :, 3,10,16) = (/&
&5.5457E+00_JPRB,4.8525E+00_JPRB,4.3615E+00_JPRB,6.3373E+00_JPRB,8.4492E+00_JPRB,1.0550E+01_JPRB,&
&1.2638E+01_JPRB,1.4656E+01_JPRB,1.5082E+01_JPRB,1.6923E+01_JPRB/)
KAO( :, 4,10,16) = (/&
&6.9593E+00_JPRB,6.0894E+00_JPRB,5.9134E+00_JPRB,8.8661E+00_JPRB,1.1814E+01_JPRB,1.4751E+01_JPRB,&
&1.7669E+01_JPRB,2.0491E+01_JPRB,2.0978E+01_JPRB,2.3664E+01_JPRB/)
KAO( :, 5,10,16) = (/&
&8.4396E+00_JPRB,7.3847E+00_JPRB,7.9651E+00_JPRB,1.1942E+01_JPRB,1.5915E+01_JPRB,1.9872E+01_JPRB,&
&2.3793E+01_JPRB,2.7593E+01_JPRB,2.8161E+01_JPRB,3.1872E+01_JPRB/)
KAO( :, 1,11,16) = (/&
&3.1579E+00_JPRB,2.7632E+00_JPRB,2.3896E+00_JPRB,3.5545E+00_JPRB,4.7362E+00_JPRB,5.9136E+00_JPRB,&
&7.0823E+00_JPRB,8.2069E+00_JPRB,8.3323E+00_JPRB,9.4873E+00_JPRB/)
KAO( :, 2,11,16) = (/&
&4.3744E+00_JPRB,3.8276E+00_JPRB,3.5100E+00_JPRB,5.1538E+00_JPRB,6.8671E+00_JPRB,8.5743E+00_JPRB,&
&1.0274E+01_JPRB,1.1914E+01_JPRB,1.2209E+01_JPRB,1.3757E+01_JPRB/)
KAO( :, 3,11,16) = (/&
&5.7471E+00_JPRB,5.0288E+00_JPRB,5.0034E+00_JPRB,7.4970E+00_JPRB,9.9888E+00_JPRB,1.2472E+01_JPRB,&
&1.4942E+01_JPRB,1.7333E+01_JPRB,1.7821E+01_JPRB,2.0007E+01_JPRB/)
KAO( :, 4,11,16) = (/&
&7.2629E+00_JPRB,6.3550E+00_JPRB,7.0474E+00_JPRB,1.0566E+01_JPRB,1.4079E+01_JPRB,1.7584E+01_JPRB,&
&2.1057E+01_JPRB,2.4419E+01_JPRB,2.5019E+01_JPRB,2.8211E+01_JPRB/)
KAO( :, 5,11,16) = (/&
&8.9069E+00_JPRB,7.7936E+00_JPRB,9.5284E+00_JPRB,1.4286E+01_JPRB,1.9037E+01_JPRB,2.3771E+01_JPRB,&
&2.8468E+01_JPRB,3.3010E+01_JPRB,3.3751E+01_JPRB,3.8130E+01_JPRB/)
KAO( :, 1,12,16) = (/&
&3.3006E+00_JPRB,2.8881E+00_JPRB,2.8666E+00_JPRB,4.2985E+00_JPRB,5.7274E+00_JPRB,7.1506E+00_JPRB,&
&8.5607E+00_JPRB,9.9299E+00_JPRB,1.0097E+01_JPRB,1.1570E+01_JPRB/)
KAO( :, 2,12,16) = (/&
&4.5952E+00_JPRB,4.0208E+00_JPRB,4.1024E+00_JPRB,6.1511E+00_JPRB,8.1959E+00_JPRB,1.0235E+01_JPRB,&
&1.2254E+01_JPRB,1.4215E+01_JPRB,1.4558E+01_JPRB,1.6415E+01_JPRB/)
KAO( :, 3,12,16) = (/&
&6.1172E+00_JPRB,5.3526E+00_JPRB,5.9205E+00_JPRB,8.8783E+00_JPRB,1.1835E+01_JPRB,1.4781E+01_JPRB,&
&1.7706E+01_JPRB,2.0531E+01_JPRB,2.1114E+01_JPRB,2.3705E+01_JPRB/)
KAO( :, 4,12,16) = (/&
&7.9063E+00_JPRB,6.9180E+00_JPRB,8.3812E+00_JPRB,1.2566E+01_JPRB,1.6747E+01_JPRB,2.0915E+01_JPRB,&
&2.5049E+01_JPRB,2.9064E+01_JPRB,2.9820E+01_JPRB,3.3552E+01_JPRB/)
KAO( :, 5,12,16) = (/&
&9.9405E+00_JPRB,8.6980E+00_JPRB,1.1361E+01_JPRB,1.7034E+01_JPRB,2.2697E+01_JPRB,2.8347E+01_JPRB,&
&3.3936E+01_JPRB,3.9357E+01_JPRB,4.0377E+01_JPRB,4.5471E+01_JPRB/)
KAO( :, 1,13,16) = (/&
&3.5240E+00_JPRB,3.0835E+00_JPRB,3.4502E+00_JPRB,5.1734E+00_JPRB,6.8947E+00_JPRB,8.6091E+00_JPRB,&
&1.0310E+01_JPRB,1.1954E+01_JPRB,1.2187E+01_JPRB,1.3806E+01_JPRB/)
KAO( :, 2,13,16) = (/&
&5.0191E+00_JPRB,4.3917E+00_JPRB,4.8873E+00_JPRB,7.3276E+00_JPRB,9.7654E+00_JPRB,1.2194E+01_JPRB,&
&1.4608E+01_JPRB,1.6943E+01_JPRB,1.7366E+01_JPRB,1.9559E+01_JPRB/)
KAO( :, 3,13,16) = (/&
&6.8612E+00_JPRB,6.0035E+00_JPRB,6.9941E+00_JPRB,1.0486E+01_JPRB,1.3971E+01_JPRB,1.7446E+01_JPRB,&
&2.0896E+01_JPRB,2.4256E+01_JPRB,2.4993E+01_JPRB,2.7979E+01_JPRB/)
KAO( :, 4,13,16) = (/&
&8.9937E+00_JPRB,7.8713E+00_JPRB,9.9172E+00_JPRB,1.4874E+01_JPRB,1.9818E+01_JPRB,2.4754E+01_JPRB,&
&2.9642E+01_JPRB,3.4374E+01_JPRB,3.5407E+01_JPRB,3.9689E+01_JPRB/)
KAO( :, 5,13,16) = (/&
&1.1386E+01_JPRB,9.9632E+00_JPRB,1.3441E+01_JPRB,2.0157E+01_JPRB,2.6861E+01_JPRB,3.3545E+01_JPRB,&
&4.0165E+01_JPRB,4.6616E+01_JPRB,4.7981E+01_JPRB,5.3793E+01_JPRB/)


!     The array KBO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of H2O to CO2.  The first index in the array, JS, runs from 1 to 5, 
!     and corresponds to different H2O to CO2 ratios, as expressed through 
!     the binary species parameter eta, defined as eta = H2O/(H2O+RAT*CO2), 
!     where RAT is the ratio of the integrated line strength in the band 
!     of CO2 to that of H2O.  For instance, JS=1 refers to no H2O, 
!     JS = 2 corresponds to eta = 0.25, etc.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.

KBO( :, 1,13, 1) = (/&
&7.1418E-07_JPRB,7.7683E-05_JPRB,1.6530E-04_JPRB,3.3221E-04_JPRB,3.4375E-04_JPRB/)
KBO( :, 2,13, 1) = (/&
&7.2895E-07_JPRB,7.7891E-05_JPRB,1.5813E-04_JPRB,2.9611E-04_JPRB,3.5156E-04_JPRB/)
KBO( :, 3,13, 1) = (/&
&8.1104E-07_JPRB,8.0313E-05_JPRB,1.5573E-04_JPRB,2.7205E-04_JPRB,3.6744E-04_JPRB/)
KBO( :, 4,13, 1) = (/&
&9.8030E-07_JPRB,8.4645E-05_JPRB,1.5829E-04_JPRB,2.5788E-04_JPRB,3.9124E-04_JPRB/)
KBO( :, 5,13, 1) = (/&
&1.2532E-06_JPRB,9.1367E-05_JPRB,1.6556E-04_JPRB,2.5243E-04_JPRB,4.2278E-04_JPRB/)
KBO( :, 1,14, 1) = (/&
&5.8662E-07_JPRB,6.3217E-05_JPRB,1.3394E-04_JPRB,2.6815E-04_JPRB,2.8024E-04_JPRB/)
KBO( :, 2,14, 1) = (/&
&6.0322E-07_JPRB,6.3644E-05_JPRB,1.2871E-04_JPRB,2.3989E-04_JPRB,2.8697E-04_JPRB/)
KBO( :, 3,14, 1) = (/&
&6.7707E-07_JPRB,6.5857E-05_JPRB,1.2726E-04_JPRB,2.2113E-04_JPRB,3.0014E-04_JPRB/)
KBO( :, 4,14, 1) = (/&
&8.2251E-07_JPRB,6.9663E-05_JPRB,1.2984E-04_JPRB,2.1038E-04_JPRB,3.1976E-04_JPRB/)
KBO( :, 5,14, 1) = (/&
&1.0537E-06_JPRB,7.5477E-05_JPRB,1.3625E-04_JPRB,2.0669E-04_JPRB,3.4553E-04_JPRB/)
KBO( :, 1,15, 1) = (/&
&4.8159E-07_JPRB,5.1327E-05_JPRB,1.0828E-04_JPRB,2.1580E-04_JPRB,2.2716E-04_JPRB/)
KBO( :, 2,15, 1) = (/&
&4.9953E-07_JPRB,5.1898E-05_JPRB,1.0456E-04_JPRB,1.9384E-04_JPRB,2.3282E-04_JPRB/)
KBO( :, 3,15, 1) = (/&
&5.6592E-07_JPRB,5.3937E-05_JPRB,1.0383E-04_JPRB,1.7938E-04_JPRB,2.4342E-04_JPRB/)
KBO( :, 4,15, 1) = (/&
&6.9060E-07_JPRB,5.7276E-05_JPRB,1.0637E-04_JPRB,1.7136E-04_JPRB,2.5925E-04_JPRB/)
KBO( :, 5,15, 1) = (/&
&8.8764E-07_JPRB,6.2300E-05_JPRB,1.1206E-04_JPRB,1.6901E-04_JPRB,2.7978E-04_JPRB/)
KBO( :, 1,16, 1) = (/&
&3.9534E-07_JPRB,4.1658E-05_JPRB,8.7509E-05_JPRB,1.7349E-04_JPRB,1.8327E-04_JPRB/)
KBO( :, 2,16, 1) = (/&
&4.1395E-07_JPRB,4.2305E-05_JPRB,8.4934E-05_JPRB,1.5653E-04_JPRB,1.8794E-04_JPRB/)
KBO( :, 3,16, 1) = (/&
&4.7298E-07_JPRB,4.4176E-05_JPRB,8.4714E-05_JPRB,1.4546E-04_JPRB,1.9627E-04_JPRB/)
KBO( :, 4,16, 1) = (/&
&5.8017E-07_JPRB,4.7094E-05_JPRB,8.7162E-05_JPRB,1.3953E-04_JPRB,2.0862E-04_JPRB/)
KBO( :, 5,16, 1) = (/&
&7.4847E-07_JPRB,5.1410E-05_JPRB,9.2164E-05_JPRB,1.3822E-04_JPRB,2.2492E-04_JPRB/)
KBO( :, 1,17, 1) = (/&
&3.2461E-07_JPRB,3.3900E-05_JPRB,7.0928E-05_JPRB,1.3982E-04_JPRB,1.4790E-04_JPRB/)
KBO( :, 2,17, 1) = (/&
&3.4310E-07_JPRB,3.4570E-05_JPRB,6.9142E-05_JPRB,1.2666E-04_JPRB,1.5175E-04_JPRB/)
KBO( :, 3,17, 1) = (/&
&3.9502E-07_JPRB,3.6243E-05_JPRB,6.9258E-05_JPRB,1.1817E-04_JPRB,1.5840E-04_JPRB/)
KBO( :, 4,17, 1) = (/&
&4.8706E-07_JPRB,3.8770E-05_JPRB,7.1558E-05_JPRB,1.1380E-04_JPRB,1.6811E-04_JPRB/)
KBO( :, 5,17, 1) = (/&
&6.3052E-07_JPRB,4.2462E-05_JPRB,7.5924E-05_JPRB,1.1322E-04_JPRB,1.8097E-04_JPRB/)
KBO( :, 1,18, 1) = (/&
&2.6665E-07_JPRB,2.7690E-05_JPRB,5.7714E-05_JPRB,1.1306E-04_JPRB,1.1974E-04_JPRB/)
KBO( :, 2,18, 1) = (/&
&2.8433E-07_JPRB,2.8352E-05_JPRB,5.6467E-05_JPRB,1.0278E-04_JPRB,1.2295E-04_JPRB/)
KBO( :, 3,18, 1) = (/&
&3.2991E-07_JPRB,2.9820E-05_JPRB,5.6782E-05_JPRB,9.6223E-05_JPRB,1.2833E-04_JPRB/)
KBO( :, 4,18, 1) = (/&
&4.0885E-07_JPRB,3.1990E-05_JPRB,5.8916E-05_JPRB,9.3033E-05_JPRB,1.3601E-04_JPRB/)
KBO( :, 5,18, 1) = (/&
&5.3113E-07_JPRB,3.5147E-05_JPRB,6.2667E-05_JPRB,9.2955E-05_JPRB,1.4604E-04_JPRB/)
KBO( :, 1,19, 1) = (/&
&2.1915E-07_JPRB,2.2650E-05_JPRB,4.7032E-05_JPRB,9.1545E-05_JPRB,9.7174E-05_JPRB/)
KBO( :, 2,19, 1) = (/&
&2.3563E-07_JPRB,2.3282E-05_JPRB,4.6172E-05_JPRB,8.3486E-05_JPRB,9.9869E-05_JPRB/)
KBO( :, 3,19, 1) = (/&
&2.7548E-07_JPRB,2.4553E-05_JPRB,4.6603E-05_JPRB,7.8441E-05_JPRB,1.0422E-04_JPRB/)
KBO( :, 4,19, 1) = (/&
&3.4310E-07_JPRB,2.6414E-05_JPRB,4.8547E-05_JPRB,7.6134E-05_JPRB,1.1036E-04_JPRB/)
KBO( :, 5,19, 1) = (/&
&4.4724E-07_JPRB,2.9096E-05_JPRB,5.1737E-05_JPRB,7.6381E-05_JPRB,1.1839E-04_JPRB/)
KBO( :, 1,20, 1) = (/&
&1.8030E-07_JPRB,1.8558E-05_JPRB,3.8356E-05_JPRB,7.4071E-05_JPRB,7.9169E-05_JPRB/)
KBO( :, 2,20, 1) = (/&
&1.9579E-07_JPRB,1.9155E-05_JPRB,3.7791E-05_JPRB,6.7788E-05_JPRB,8.1446E-05_JPRB/)
KBO( :, 3,20, 1) = (/&
&2.3085E-07_JPRB,2.0254E-05_JPRB,3.8309E-05_JPRB,6.3956E-05_JPRB,8.5047E-05_JPRB/)
KBO( :, 4,20, 1) = (/&
&2.8924E-07_JPRB,2.1859E-05_JPRB,4.0062E-05_JPRB,6.2346E-05_JPRB,9.0082E-05_JPRB/)
KBO( :, 5,20, 1) = (/&
&3.7846E-07_JPRB,2.4137E-05_JPRB,4.2788E-05_JPRB,6.2820E-05_JPRB,9.6650E-05_JPRB/)
KBO( :, 1,21, 1) = (/&
&1.4847E-07_JPRB,1.5215E-05_JPRB,3.1290E-05_JPRB,5.9949E-05_JPRB,6.4552E-05_JPRB/)
KBO( :, 2,21, 1) = (/&
&1.6287E-07_JPRB,1.5766E-05_JPRB,3.0943E-05_JPRB,5.5054E-05_JPRB,6.6478E-05_JPRB/)
KBO( :, 3,21, 1) = (/&
&1.9366E-07_JPRB,1.6713E-05_JPRB,3.1503E-05_JPRB,5.2161E-05_JPRB,6.9475E-05_JPRB/)
KBO( :, 4,21, 1) = (/&
&2.4408E-07_JPRB,1.8092E-05_JPRB,3.3059E-05_JPRB,5.1064E-05_JPRB,7.3632E-05_JPRB/)
KBO( :, 5,21, 1) = (/&
&3.2048E-07_JPRB,2.0022E-05_JPRB,3.5383E-05_JPRB,5.1675E-05_JPRB,7.9025E-05_JPRB/)
KBO( :, 1,22, 1) = (/&
&1.2289E-07_JPRB,1.2484E-05_JPRB,2.5472E-05_JPRB,4.8192E-05_JPRB,5.2603E-05_JPRB/)
KBO( :, 2,22, 1) = (/&
&1.3697E-07_JPRB,1.3009E-05_JPRB,2.5334E-05_JPRB,4.4504E-05_JPRB,5.4267E-05_JPRB/)
KBO( :, 3,22, 1) = (/&
&1.6488E-07_JPRB,1.3843E-05_JPRB,2.5950E-05_JPRB,4.2432E-05_JPRB,5.6803E-05_JPRB/)
KBO( :, 4,22, 1) = (/&
&2.0968E-07_JPRB,1.5052E-05_JPRB,2.7363E-05_JPRB,4.1803E-05_JPRB,6.0274E-05_JPRB/)
KBO( :, 5,22, 1) = (/&
&2.7669E-07_JPRB,1.6715E-05_JPRB,2.9384E-05_JPRB,4.2575E-05_JPRB,6.4715E-05_JPRB/)
KBO( :, 1,23, 1) = (/&
&1.0206E-07_JPRB,1.0252E-05_JPRB,2.0747E-05_JPRB,3.8734E-05_JPRB,4.2840E-05_JPRB/)
KBO( :, 2,23, 1) = (/&
&1.1559E-07_JPRB,1.0742E-05_JPRB,2.0755E-05_JPRB,3.5990E-05_JPRB,4.4274E-05_JPRB/)
KBO( :, 3,23, 1) = (/&
&1.4082E-07_JPRB,1.1473E-05_JPRB,2.1391E-05_JPRB,3.4535E-05_JPRB,4.6409E-05_JPRB/)
KBO( :, 4,23, 1) = (/&
&1.8064E-07_JPRB,1.2528E-05_JPRB,2.2650E-05_JPRB,3.4245E-05_JPRB,4.9289E-05_JPRB/)
KBO( :, 5,23, 1) = (/&
&2.3944E-07_JPRB,1.3961E-05_JPRB,2.4408E-05_JPRB,3.5094E-05_JPRB,5.2908E-05_JPRB/)
KBO( :, 1,24, 1) = (/&
&8.5103E-08_JPRB,8.4147E-06_JPRB,1.6891E-05_JPRB,3.1099E-05_JPRB,3.4780E-05_JPRB/)
KBO( :, 2,24, 1) = (/&
&9.8006E-08_JPRB,8.8655E-06_JPRB,1.6999E-05_JPRB,2.9091E-05_JPRB,3.5996E-05_JPRB/)
KBO( :, 3,24, 1) = (/&
&1.2073E-07_JPRB,9.5086E-06_JPRB,1.7631E-05_JPRB,2.8105E-05_JPRB,3.7773E-05_JPRB/)
KBO( :, 4,24, 1) = (/&
&1.5616E-07_JPRB,1.0427E-05_JPRB,1.8742E-05_JPRB,2.8056E-05_JPRB,4.0114E-05_JPRB/)
KBO( :, 5,24, 1) = (/&
&2.0784E-07_JPRB,1.1663E-05_JPRB,2.0274E-05_JPRB,2.8927E-05_JPRB,4.3028E-05_JPRB/)
KBO( :, 1,25, 1) = (/&
&7.1310E-08_JPRB,6.9185E-06_JPRB,1.3767E-05_JPRB,2.4976E-05_JPRB,2.8241E-05_JPRB/)
KBO( :, 2,25, 1) = (/&
&8.3499E-08_JPRB,7.3246E-06_JPRB,1.3943E-05_JPRB,2.3533E-05_JPRB,2.9273E-05_JPRB/)
KBO( :, 3,25, 1) = (/&
&1.0401E-07_JPRB,7.8935E-06_JPRB,1.4555E-05_JPRB,2.2896E-05_JPRB,3.0735E-05_JPRB/)
KBO( :, 4,25, 1) = (/&
&1.3555E-07_JPRB,8.6941E-06_JPRB,1.5529E-05_JPRB,2.3015E-05_JPRB,3.2639E-05_JPRB/)
KBO( :, 5,25, 1) = (/&
&1.8108E-07_JPRB,9.7609E-06_JPRB,1.6867E-05_JPRB,2.3873E-05_JPRB,3.4993E-05_JPRB/)
KBO( :, 1,26, 1) = (/&
&6.0142E-08_JPRB,5.7047E-06_JPRB,1.1243E-05_JPRB,2.0069E-05_JPRB,2.2978E-05_JPRB/)
KBO( :, 2,26, 1) = (/&
&7.1603E-08_JPRB,6.0681E-06_JPRB,1.1465E-05_JPRB,1.9057E-05_JPRB,2.3854E-05_JPRB/)
KBO( :, 3,26, 1) = (/&
&9.0251E-08_JPRB,6.5738E-06_JPRB,1.2045E-05_JPRB,1.8681E-05_JPRB,2.5076E-05_JPRB/)
KBO( :, 4,26, 1) = (/&
&1.1847E-07_JPRB,7.2745E-06_JPRB,1.2903E-05_JPRB,1.8921E-05_JPRB,2.6626E-05_JPRB/)
KBO( :, 5,26, 1) = (/&
&1.5875E-07_JPRB,8.1996E-06_JPRB,1.4077E-05_JPRB,1.9751E-05_JPRB,2.8555E-05_JPRB/)
KBO( :, 1,27, 1) = (/&
&5.0983E-08_JPRB,4.7088E-06_JPRB,9.1912E-06_JPRB,1.6147E-05_JPRB,1.8668E-05_JPRB/)
KBO( :, 2,27, 1) = (/&
&6.1630E-08_JPRB,5.0315E-06_JPRB,9.4402E-06_JPRB,1.5452E-05_JPRB,1.9405E-05_JPRB/)
KBO( :, 3,27, 1) = (/&
&7.8563E-08_JPRB,5.4806E-06_JPRB,9.9742E-06_JPRB,1.5262E-05_JPRB,2.0403E-05_JPRB/)
KBO( :, 4,27, 1) = (/&
&1.0377E-07_JPRB,6.0931E-06_JPRB,1.0731E-05_JPRB,1.5575E-05_JPRB,2.1672E-05_JPRB/)
KBO( :, 5,27, 1) = (/&
&1.3934E-07_JPRB,6.8942E-06_JPRB,1.1760E-05_JPRB,1.6361E-05_JPRB,2.3196E-05_JPRB/)
KBO( :, 1,28, 1) = (/&
&4.3423E-08_JPRB,3.8906E-06_JPRB,7.5226E-06_JPRB,1.3009E-05_JPRB,1.5127E-05_JPRB/)
KBO( :, 2,28, 1) = (/&
&5.3228E-08_JPRB,4.1755E-06_JPRB,7.7818E-06_JPRB,1.2546E-05_JPRB,1.5736E-05_JPRB/)
KBO( :, 3,28, 1) = (/&
&6.8564E-08_JPRB,4.5731E-06_JPRB,8.2639E-06_JPRB,1.2487E-05_JPRB,1.6536E-05_JPRB/)
KBO( :, 4,28, 1) = (/&
&9.1039E-08_JPRB,5.1074E-06_JPRB,8.9326E-06_JPRB,1.2837E-05_JPRB,1.7505E-05_JPRB/)
KBO( :, 5,28, 1) = (/&
&1.2239E-07_JPRB,5.8016E-06_JPRB,9.8318E-06_JPRB,1.3565E-05_JPRB,1.8670E-05_JPRB/)
KBO( :, 1,29, 1) = (/&
&3.7204E-08_JPRB,3.2238E-06_JPRB,6.1736E-06_JPRB,1.0502E-05_JPRB,1.2279E-05_JPRB/)
KBO( :, 2,29, 1) = (/&
&4.6206E-08_JPRB,3.4759E-06_JPRB,6.4330E-06_JPRB,1.0209E-05_JPRB,1.2764E-05_JPRB/)
KBO( :, 3,29, 1) = (/&
&6.0076E-08_JPRB,3.8273E-06_JPRB,6.8635E-06_JPRB,1.0241E-05_JPRB,1.3368E-05_JPRB/)
KBO( :, 4,29, 1) = (/&
&8.0144E-08_JPRB,4.2936E-06_JPRB,7.4538E-06_JPRB,1.0606E-05_JPRB,1.4121E-05_JPRB/)
KBO( :, 5,29, 1) = (/&
&1.0777E-07_JPRB,4.8966E-06_JPRB,8.2412E-06_JPRB,1.1275E-05_JPRB,1.5046E-05_JPRB/)
KBO( :, 1,30, 1) = (/&
&3.1996E-08_JPRB,2.6737E-06_JPRB,5.0754E-06_JPRB,8.4948E-06_JPRB,9.8822E-06_JPRB/)
KBO( :, 2,30, 1) = (/&
&4.0245E-08_JPRB,2.8984E-06_JPRB,5.3264E-06_JPRB,8.3223E-06_JPRB,1.0256E-05_JPRB/)
KBO( :, 3,30, 1) = (/&
&5.2747E-08_JPRB,3.2079E-06_JPRB,5.7080E-06_JPRB,8.4160E-06_JPRB,1.0727E-05_JPRB/)
KBO( :, 4,30, 1) = (/&
&7.0609E-08_JPRB,3.6138E-06_JPRB,6.2283E-06_JPRB,8.7777E-06_JPRB,1.1320E-05_JPRB/)
KBO( :, 5,30, 1) = (/&
&9.4984E-08_JPRB,4.1398E-06_JPRB,6.9193E-06_JPRB,9.3872E-06_JPRB,1.2062E-05_JPRB/)
KBO( :, 1,31, 1) = (/&
&2.7641E-08_JPRB,2.2221E-06_JPRB,4.1820E-06_JPRB,6.8854E-06_JPRB,7.8857E-06_JPRB/)
KBO( :, 2,31, 1) = (/&
&3.5201E-08_JPRB,2.4225E-06_JPRB,4.4182E-06_JPRB,6.7986E-06_JPRB,8.1875E-06_JPRB/)
KBO( :, 3,31, 1) = (/&
&4.6451E-08_JPRB,2.6943E-06_JPRB,4.7566E-06_JPRB,6.9330E-06_JPRB,8.5704E-06_JPRB/)
KBO( :, 4,31, 1) = (/&
&6.2336E-08_JPRB,3.0481E-06_JPRB,5.2150E-06_JPRB,7.2810E-06_JPRB,9.0473E-06_JPRB/)
KBO( :, 5,31, 1) = (/&
&8.3774E-08_JPRB,3.5048E-06_JPRB,5.8188E-06_JPRB,7.8290E-06_JPRB,9.6365E-06_JPRB/)
KBO( :, 1,32, 1) = (/&
&2.3981E-08_JPRB,1.8500E-06_JPRB,3.4538E-06_JPRB,5.5925E-06_JPRB,6.2708E-06_JPRB/)
KBO( :, 2,32, 1) = (/&
&3.0888E-08_JPRB,2.0288E-06_JPRB,3.6701E-06_JPRB,5.5668E-06_JPRB,6.5148E-06_JPRB/)
KBO( :, 3,32, 1) = (/&
&4.1004E-08_JPRB,2.2672E-06_JPRB,3.9709E-06_JPRB,5.7241E-06_JPRB,6.8232E-06_JPRB/)
KBO( :, 4,32, 1) = (/&
&5.5092E-08_JPRB,2.5754E-06_JPRB,4.3743E-06_JPRB,6.0514E-06_JPRB,7.2153E-06_JPRB/)
KBO( :, 5,32, 1) = (/&
&7.3928E-08_JPRB,2.9722E-06_JPRB,4.9013E-06_JPRB,6.5406E-06_JPRB,7.6884E-06_JPRB/)
KBO( :, 1,33, 1) = (/&
&2.0891E-08_JPRB,1.5432E-06_JPRB,2.8587E-06_JPRB,4.5518E-06_JPRB,4.9648E-06_JPRB/)
KBO( :, 2,33, 1) = (/&
&2.7170E-08_JPRB,1.7018E-06_JPRB,3.0535E-06_JPRB,4.5689E-06_JPRB,5.1628E-06_JPRB/)
KBO( :, 3,33, 1) = (/&
&3.6242E-08_JPRB,1.9105E-06_JPRB,3.3202E-06_JPRB,4.7346E-06_JPRB,5.4226E-06_JPRB/)
KBO( :, 4,33, 1) = (/&
&4.8741E-08_JPRB,2.1800E-06_JPRB,3.6760E-06_JPRB,5.0388E-06_JPRB,5.7379E-06_JPRB/)
KBO( :, 5,33, 1) = (/&
&6.5227E-08_JPRB,2.5234E-06_JPRB,4.1341E-06_JPRB,5.4730E-06_JPRB,6.1189E-06_JPRB/)
KBO( :, 1,34, 1) = (/&
&1.8095E-08_JPRB,1.2866E-06_JPRB,2.3675E-06_JPRB,3.7154E-06_JPRB,3.9669E-06_JPRB/)
KBO( :, 2,34, 1) = (/&
&2.3709E-08_JPRB,1.4253E-06_JPRB,2.5394E-06_JPRB,3.7569E-06_JPRB,4.1359E-06_JPRB/)
KBO( :, 3,34, 1) = (/&
&3.1721E-08_JPRB,1.6060E-06_JPRB,2.7729E-06_JPRB,3.9185E-06_JPRB,4.3498E-06_JPRB/)
KBO( :, 4,34, 1) = (/&
&4.2654E-08_JPRB,1.8394E-06_JPRB,3.0822E-06_JPRB,4.1918E-06_JPRB,4.6083E-06_JPRB/)
KBO( :, 5,34, 1) = (/&
&5.6945E-08_JPRB,2.1348E-06_JPRB,3.4773E-06_JPRB,4.5733E-06_JPRB,4.9229E-06_JPRB/)
KBO( :, 1,35, 1) = (/&
&1.5318E-08_JPRB,1.0637E-06_JPRB,1.9503E-06_JPRB,3.0369E-06_JPRB,3.1425E-06_JPRB/)
KBO( :, 2,35, 1) = (/&
&2.0142E-08_JPRB,1.1814E-06_JPRB,2.0969E-06_JPRB,3.0840E-06_JPRB,3.2804E-06_JPRB/)
KBO( :, 3,35, 1) = (/&
&2.6985E-08_JPRB,1.3339E-06_JPRB,2.2954E-06_JPRB,3.2281E-06_JPRB,3.4506E-06_JPRB/)
KBO( :, 4,35, 1) = (/&
&3.6271E-08_JPRB,1.5312E-06_JPRB,2.5572E-06_JPRB,3.4632E-06_JPRB,3.6600E-06_JPRB/)
KBO( :, 5,35, 1) = (/&
&4.8348E-08_JPRB,1.7796E-06_JPRB,2.8900E-06_JPRB,3.7877E-06_JPRB,3.9119E-06_JPRB/)
KBO( :, 1,36, 1) = (/&
&1.2609E-08_JPRB,8.7019E-07_JPRB,1.5952E-06_JPRB,2.4829E-06_JPRB,2.4549E-06_JPRB/)
KBO( :, 2,36, 1) = (/&
&1.6587E-08_JPRB,9.6711E-07_JPRB,1.7160E-06_JPRB,2.5229E-06_JPRB,2.5656E-06_JPRB/)
KBO( :, 3,36, 1) = (/&
&2.2224E-08_JPRB,1.0924E-06_JPRB,1.8795E-06_JPRB,2.6424E-06_JPRB,2.6986E-06_JPRB/)
KBO( :, 4,36, 1) = (/&
&2.9869E-08_JPRB,1.2544E-06_JPRB,2.0948E-06_JPRB,2.8361E-06_JPRB,2.8620E-06_JPRB/)
KBO( :, 5,36, 1) = (/&
&3.9802E-08_JPRB,1.4584E-06_JPRB,2.3682E-06_JPRB,3.1034E-06_JPRB,3.0593E-06_JPRB/)
KBO( :, 1,37, 1) = (/&
&9.9825E-09_JPRB,7.0298E-07_JPRB,1.2942E-06_JPRB,2.0328E-06_JPRB,1.9580E-06_JPRB/)
KBO( :, 2,37, 1) = (/&
&1.3082E-08_JPRB,7.7949E-07_JPRB,1.3892E-06_JPRB,2.0567E-06_JPRB,2.0455E-06_JPRB/)
KBO( :, 3,37, 1) = (/&
&1.7504E-08_JPRB,8.7873E-07_JPRB,1.5181E-06_JPRB,2.1464E-06_JPRB,2.1505E-06_JPRB/)
KBO( :, 4,37, 1) = (/&
&2.3530E-08_JPRB,1.0069E-06_JPRB,1.6884E-06_JPRB,2.2974E-06_JPRB,2.2783E-06_JPRB/)
KBO( :, 5,37, 1) = (/&
&3.1408E-08_JPRB,1.1691E-06_JPRB,1.9058E-06_JPRB,2.5076E-06_JPRB,2.4325E-06_JPRB/)
KBO( :, 1,38, 1) = (/&
&7.8914E-09_JPRB,5.6770E-07_JPRB,1.0500E-06_JPRB,1.6653E-06_JPRB,1.5591E-06_JPRB/)
KBO( :, 2,38, 1) = (/&
&1.0298E-08_JPRB,6.2785E-07_JPRB,1.1243E-06_JPRB,1.6773E-06_JPRB,1.6284E-06_JPRB/)
KBO( :, 3,38, 1) = (/&
&1.3752E-08_JPRB,7.0630E-07_JPRB,1.2256E-06_JPRB,1.7435E-06_JPRB,1.7113E-06_JPRB/)
KBO( :, 4,38, 1) = (/&
&1.8491E-08_JPRB,8.0748E-07_JPRB,1.3600E-06_JPRB,1.8604E-06_JPRB,1.8119E-06_JPRB/)
KBO( :, 5,38, 1) = (/&
&2.4713E-08_JPRB,9.3623E-07_JPRB,1.5323E-06_JPRB,2.0252E-06_JPRB,1.9325E-06_JPRB/)
KBO( :, 1,39, 1) = (/&
&6.2449E-09_JPRB,4.5862E-07_JPRB,8.5227E-07_JPRB,1.3650E-06_JPRB,1.2362E-06_JPRB/)
KBO( :, 2,39, 1) = (/&
&8.1107E-09_JPRB,5.0588E-07_JPRB,9.1024E-07_JPRB,1.3687E-06_JPRB,1.2913E-06_JPRB/)
KBO( :, 3,39, 1) = (/&
&1.0807E-08_JPRB,5.6790E-07_JPRB,9.8979E-07_JPRB,1.4171E-06_JPRB,1.3567E-06_JPRB/)
KBO( :, 4,39, 1) = (/&
&1.4528E-08_JPRB,6.4780E-07_JPRB,1.0958E-06_JPRB,1.5072E-06_JPRB,1.4361E-06_JPRB/)
KBO( :, 5,39, 1) = (/&
&1.9446E-08_JPRB,7.4988E-07_JPRB,1.2323E-06_JPRB,1.6363E-06_JPRB,1.5306E-06_JPRB/)
KBO( :, 1,40, 1) = (/&
&4.8302E-09_JPRB,3.6764E-07_JPRB,6.8890E-07_JPRB,1.1218E-06_JPRB,9.8696E-07_JPRB/)
KBO( :, 2,40, 1) = (/&
&6.2157E-09_JPRB,4.0354E-07_JPRB,7.3207E-07_JPRB,1.1164E-06_JPRB,1.0304E-06_JPRB/)
KBO( :, 3,40, 1) = (/&
&8.2441E-09_JPRB,4.5131E-07_JPRB,7.9261E-07_JPRB,1.1474E-06_JPRB,1.0817E-06_JPRB/)
KBO( :, 4,40, 1) = (/&
&1.1074E-08_JPRB,5.1282E-07_JPRB,8.7386E-07_JPRB,1.2132E-06_JPRB,1.1434E-06_JPRB/)
KBO( :, 5,40, 1) = (/&
&1.4851E-08_JPRB,5.9180E-07_JPRB,9.7921E-07_JPRB,1.3110E-06_JPRB,1.2171E-06_JPRB/)
KBO( :, 1,41, 1) = (/&
&3.7368E-09_JPRB,2.9476E-07_JPRB,5.5755E-07_JPRB,9.2376E-07_JPRB,7.8720E-07_JPRB/)
KBO( :, 2,41, 1) = (/&
&4.7545E-09_JPRB,3.2182E-07_JPRB,5.8886E-07_JPRB,9.1238E-07_JPRB,8.2191E-07_JPRB/)
KBO( :, 3,41, 1) = (/&
&6.2690E-09_JPRB,3.5842E-07_JPRB,6.3462E-07_JPRB,9.3003E-07_JPRB,8.6237E-07_JPRB/)
KBO( :, 4,41, 1) = (/&
&8.4086E-09_JPRB,4.0567E-07_JPRB,6.9663E-07_JPRB,9.7688E-07_JPRB,9.1026E-07_JPRB/)
KBO( :, 5,41, 1) = (/&
&1.1291E-08_JPRB,4.6640E-07_JPRB,7.7748E-07_JPRB,1.0503E-06_JPRB,9.6752E-07_JPRB/)
KBO( :, 1,42, 1) = (/&
&2.9007E-09_JPRB,2.3650E-07_JPRB,4.5213E-07_JPRB,7.6209E-07_JPRB,6.2575E-07_JPRB/)
KBO( :, 2,42, 1) = (/&
&3.6445E-09_JPRB,2.5698E-07_JPRB,4.7408E-07_JPRB,7.4714E-07_JPRB,6.5397E-07_JPRB/)
KBO( :, 3,42, 1) = (/&
&4.7714E-09_JPRB,2.8488E-07_JPRB,5.0867E-07_JPRB,7.5527E-07_JPRB,6.8601E-07_JPRB/)
KBO( :, 4,42, 1) = (/&
&6.3838E-09_JPRB,3.2120E-07_JPRB,5.5584E-07_JPRB,7.8778E-07_JPRB,7.2350E-07_JPRB/)
KBO( :, 5,42, 1) = (/&
&8.5773E-09_JPRB,3.6777E-07_JPRB,6.1782E-07_JPRB,8.4249E-07_JPRB,7.6794E-07_JPRB/)
KBO( :, 1,43, 1) = (/&
&2.2351E-09_JPRB,1.8911E-07_JPRB,3.6687E-07_JPRB,6.3162E-07_JPRB,4.9805E-07_JPRB/)
KBO( :, 2,43, 1) = (/&
&2.7634E-09_JPRB,2.0451E-07_JPRB,3.8115E-07_JPRB,6.1360E-07_JPRB,5.2107E-07_JPRB/)
KBO( :, 3,43, 1) = (/&
&3.5807E-09_JPRB,2.2534E-07_JPRB,4.0658E-07_JPRB,6.1409E-07_JPRB,5.4635E-07_JPRB/)
KBO( :, 4,43, 1) = (/&
&4.7672E-09_JPRB,2.5284E-07_JPRB,4.4177E-07_JPRB,6.3473E-07_JPRB,5.7553E-07_JPRB/)
KBO( :, 5,43, 1) = (/&
&6.4052E-09_JPRB,2.8805E-07_JPRB,4.8846E-07_JPRB,6.7397E-07_JPRB,6.0977E-07_JPRB/)
KBO( :, 1,44, 1) = (/&
&1.7248E-09_JPRB,1.5121E-07_JPRB,2.9826E-07_JPRB,5.2580E-07_JPRB,3.9624E-07_JPRB/)
KBO( :, 2,44, 1) = (/&
&2.0939E-09_JPRB,1.6277E-07_JPRB,3.0698E-07_JPRB,5.0563E-07_JPRB,4.1515E-07_JPRB/)
KBO( :, 3,44, 1) = (/&
&2.6759E-09_JPRB,1.7808E-07_JPRB,3.2502E-07_JPRB,5.0085E-07_JPRB,4.3507E-07_JPRB/)
KBO( :, 4,44, 1) = (/&
&3.5375E-09_JPRB,1.9875E-07_JPRB,3.5098E-07_JPRB,5.1227E-07_JPRB,4.5779E-07_JPRB/)
KBO( :, 5,44, 1) = (/&
&4.7457E-09_JPRB,2.2523E-07_JPRB,3.8582E-07_JPRB,5.3933E-07_JPRB,4.8421E-07_JPRB/)
KBO( :, 1,45, 1) = (/&
&1.3426E-09_JPRB,1.2131E-07_JPRB,2.4315E-07_JPRB,4.3919E-07_JPRB,3.1429E-07_JPRB/)
KBO( :, 2,45, 1) = (/&
&1.5963E-09_JPRB,1.2978E-07_JPRB,2.4811E-07_JPRB,4.1799E-07_JPRB,3.2982E-07_JPRB/)
KBO( :, 3,45, 1) = (/&
&2.0068E-09_JPRB,1.4107E-07_JPRB,2.6027E-07_JPRB,4.0999E-07_JPRB,3.4585E-07_JPRB/)
KBO( :, 4,45, 1) = (/&
&2.6291E-09_JPRB,1.5649E-07_JPRB,2.7939E-07_JPRB,4.1473E-07_JPRB,3.6360E-07_JPRB/)
KBO( :, 5,45, 1) = (/&
&3.5165E-09_JPRB,1.7643E-07_JPRB,3.0531E-07_JPRB,4.3268E-07_JPRB,3.8407E-07_JPRB/)
KBO( :, 1,46, 1) = (/&
&1.0525E-09_JPRB,9.7607E-08_JPRB,1.9871E-07_JPRB,3.6864E-07_JPRB,2.4954E-07_JPRB/)
KBO( :, 2,46, 1) = (/&
&1.2190E-09_JPRB,1.0342E-07_JPRB,2.0108E-07_JPRB,3.4713E-07_JPRB,2.6150E-07_JPRB/)
KBO( :, 3,46, 1) = (/&
&1.5044E-09_JPRB,1.1181E-07_JPRB,2.0871E-07_JPRB,3.3691E-07_JPRB,2.7474E-07_JPRB/)
KBO( :, 4,46, 1) = (/&
&1.9474E-09_JPRB,1.2315E-07_JPRB,2.2254E-07_JPRB,3.3690E-07_JPRB,2.8869E-07_JPRB/)
KBO( :, 5,46, 1) = (/&
&2.5900E-09_JPRB,1.3809E-07_JPRB,2.4160E-07_JPRB,3.4784E-07_JPRB,3.0446E-07_JPRB/)
KBO( :, 1,47, 1) = (/&
&8.3184E-10_JPRB,7.8730E-08_JPRB,1.6288E-07_JPRB,3.1142E-07_JPRB,1.9926E-07_JPRB/)
KBO( :, 2,47, 1) = (/&
&9.3189E-10_JPRB,8.2400E-08_JPRB,1.6338E-07_JPRB,2.9014E-07_JPRB,2.0781E-07_JPRB/)
KBO( :, 3,47, 1) = (/&
&1.1246E-09_JPRB,8.8566E-08_JPRB,1.6773E-07_JPRB,2.7820E-07_JPRB,2.1850E-07_JPRB/)
KBO( :, 4,47, 1) = (/&
&1.4310E-09_JPRB,9.6726E-08_JPRB,1.7718E-07_JPRB,2.7482E-07_JPRB,2.2960E-07_JPRB/)
KBO( :, 5,47, 1) = (/&
&1.8866E-09_JPRB,1.0777E-07_JPRB,1.9096E-07_JPRB,2.8016E-07_JPRB,2.4174E-07_JPRB/)
KBO( :, 1,48, 1) = (/&
&6.6667E-10_JPRB,6.3743E-08_JPRB,1.3383E-07_JPRB,2.6444E-07_JPRB,1.5919E-07_JPRB/)
KBO( :, 2,48, 1) = (/&
&7.2152E-10_JPRB,6.5980E-08_JPRB,1.3326E-07_JPRB,2.4370E-07_JPRB,1.6500E-07_JPRB/)
KBO( :, 3,48, 1) = (/&
&8.4803E-10_JPRB,7.0305E-08_JPRB,1.3546E-07_JPRB,2.3079E-07_JPRB,1.7325E-07_JPRB/)
KBO( :, 4,48, 1) = (/&
&1.0576E-09_JPRB,7.6239E-08_JPRB,1.4145E-07_JPRB,2.2533E-07_JPRB,1.8229E-07_JPRB/)
KBO( :, 5,48, 1) = (/&
&1.3781E-09_JPRB,8.4292E-08_JPRB,1.5136E-07_JPRB,2.2672E-07_JPRB,1.9179E-07_JPRB/)
KBO( :, 1,49, 1) = (/&
&5.4144E-10_JPRB,5.1801E-08_JPRB,1.1013E-07_JPRB,2.2618E-07_JPRB,1.2711E-07_JPRB/)
KBO( :, 2,49, 1) = (/&
&5.6629E-10_JPRB,5.3107E-08_JPRB,1.0907E-07_JPRB,2.0553E-07_JPRB,1.3089E-07_JPRB/)
KBO( :, 3,49, 1) = (/&
&6.4486E-10_JPRB,5.5918E-08_JPRB,1.0986E-07_JPRB,1.9244E-07_JPRB,1.3676E-07_JPRB/)
KBO( :, 4,49, 1) = (/&
&7.8735E-10_JPRB,6.0291E-08_JPRB,1.1339E-07_JPRB,1.8565E-07_JPRB,1.4422E-07_JPRB/)
KBO( :, 5,49, 1) = (/&
&1.0106E-09_JPRB,6.6110E-08_JPRB,1.2034E-07_JPRB,1.8446E-07_JPRB,1.5185E-07_JPRB/)
KBO( :, 1,50, 1) = (/&
&4.4437E-10_JPRB,4.2232E-08_JPRB,9.0862E-08_JPRB,1.9444E-07_JPRB,1.0220E-07_JPRB/)
KBO( :, 2,50, 1) = (/&
&4.5142E-10_JPRB,4.2954E-08_JPRB,8.9495E-08_JPRB,1.7367E-07_JPRB,1.0478E-07_JPRB/)
KBO( :, 3,50, 1) = (/&
&4.9792E-10_JPRB,4.4724E-08_JPRB,8.9470E-08_JPRB,1.6100E-07_JPRB,1.0886E-07_JPRB/)
KBO( :, 4,50, 1) = (/&
&5.9436E-10_JPRB,4.7919E-08_JPRB,9.1442E-08_JPRB,1.5352E-07_JPRB,1.1464E-07_JPRB/)
KBO( :, 5,50, 1) = (/&
&7.4940E-10_JPRB,5.2145E-08_JPRB,9.6092E-08_JPRB,1.5086E-07_JPRB,1.2088E-07_JPRB/)
KBO( :, 1,51, 1) = (/&
&3.6713E-10_JPRB,3.4474E-08_JPRB,7.5308E-08_JPRB,1.6803E-07_JPRB,8.2415E-08_JPRB/)
KBO( :, 2,51, 1) = (/&
&3.6430E-10_JPRB,3.4862E-08_JPRB,7.3571E-08_JPRB,1.4732E-07_JPRB,8.4283E-08_JPRB/)
KBO( :, 3,51, 1) = (/&
&3.8938E-10_JPRB,3.5958E-08_JPRB,7.3095E-08_JPRB,1.3515E-07_JPRB,8.7129E-08_JPRB/)
KBO( :, 4,51, 1) = (/&
&4.5287E-10_JPRB,3.8169E-08_JPRB,7.4068E-08_JPRB,1.2746E-07_JPRB,9.1359E-08_JPRB/)
KBO( :, 5,51, 1) = (/&
&5.6042E-10_JPRB,4.1297E-08_JPRB,7.7005E-08_JPRB,1.2390E-07_JPRB,9.6467E-08_JPRB/)
KBO( :, 1,52, 1) = (/&
&3.0507E-10_JPRB,2.8135E-08_JPRB,6.2903E-08_JPRB,1.4596E-07_JPRB,6.6326E-08_JPRB/)
KBO( :, 2,52, 1) = (/&
&2.9709E-10_JPRB,2.8385E-08_JPRB,6.0554E-08_JPRB,1.2580E-07_JPRB,6.7717E-08_JPRB/)
KBO( :, 3,52, 1) = (/&
&3.0805E-10_JPRB,2.9029E-08_JPRB,5.9886E-08_JPRB,1.1380E-07_JPRB,6.9709E-08_JPRB/)
KBO( :, 4,52, 1) = (/&
&3.4776E-10_JPRB,3.0470E-08_JPRB,6.0190E-08_JPRB,1.0625E-07_JPRB,7.2725E-08_JPRB/)
KBO( :, 5,52, 1) = (/&
&4.2195E-10_JPRB,3.2800E-08_JPRB,6.1944E-08_JPRB,1.0216E-07_JPRB,7.6745E-08_JPRB/)
KBO( :, 1,53, 1) = (/&
&2.5471E-10_JPRB,2.2998E-08_JPRB,5.2959E-08_JPRB,1.2738E-07_JPRB,5.3131E-08_JPRB/)
KBO( :, 2,53, 1) = (/&
&2.4432E-10_JPRB,2.3152E-08_JPRB,5.0007E-08_JPRB,1.0819E-07_JPRB,5.4179E-08_JPRB/)
KBO( :, 3,53, 1) = (/&
&2.4654E-10_JPRB,2.3508E-08_JPRB,4.9165E-08_JPRB,9.6195E-08_JPRB,5.5658E-08_JPRB/)
KBO( :, 4,53, 1) = (/&
&2.6977E-10_JPRB,2.4417E-08_JPRB,4.9071E-08_JPRB,8.8939E-08_JPRB,5.7790E-08_JPRB/)
KBO( :, 5,53, 1) = (/&
&3.1992E-10_JPRB,2.6104E-08_JPRB,5.0031E-08_JPRB,8.4550E-08_JPRB,6.0803E-08_JPRB/)
KBO( :, 1,54, 1) = (/&
&2.1314E-10_JPRB,1.8852E-08_JPRB,4.4748E-08_JPRB,1.1115E-07_JPRB,4.3302E-08_JPRB/)
KBO( :, 2,54, 1) = (/&
&2.0193E-10_JPRB,1.8904E-08_JPRB,4.1449E-08_JPRB,9.3135E-08_JPRB,4.4067E-08_JPRB/)
KBO( :, 3,54, 1) = (/&
&1.9965E-10_JPRB,1.9105E-08_JPRB,4.0409E-08_JPRB,8.1420E-08_JPRB,4.5177E-08_JPRB/)
KBO( :, 4,54, 1) = (/&
&2.1224E-10_JPRB,1.9678E-08_JPRB,4.0114E-08_JPRB,7.4541E-08_JPRB,4.6704E-08_JPRB/)
KBO( :, 5,54, 1) = (/&
&2.4557E-10_JPRB,2.0847E-08_JPRB,4.0586E-08_JPRB,7.0154E-08_JPRB,4.8932E-08_JPRB/)
KBO( :, 1,55, 1) = (/&
&1.7867E-10_JPRB,1.5555E-08_JPRB,3.7972E-08_JPRB,9.7108E-08_JPRB,3.5728E-08_JPRB/)
KBO( :, 2,55, 1) = (/&
&1.6760E-10_JPRB,1.5433E-08_JPRB,3.4555E-08_JPRB,8.0306E-08_JPRB,3.6271E-08_JPRB/)
KBO( :, 3,55, 1) = (/&
&1.6306E-10_JPRB,1.5570E-08_JPRB,3.3237E-08_JPRB,6.9179E-08_JPRB,3.7075E-08_JPRB/)
KBO( :, 4,55, 1) = (/&
&1.6881E-10_JPRB,1.5918E-08_JPRB,3.2865E-08_JPRB,6.2543E-08_JPRB,3.8181E-08_JPRB/)
KBO( :, 5,55, 1) = (/&
&1.9022E-10_JPRB,1.6697E-08_JPRB,3.3018E-08_JPRB,5.8357E-08_JPRB,3.9829E-08_JPRB/)
KBO( :, 1,56, 1) = (/&
&1.5014E-10_JPRB,1.2915E-08_JPRB,3.2380E-08_JPRB,8.5055E-08_JPRB,2.9526E-08_JPRB/)
KBO( :, 2,56, 1) = (/&
&1.3958E-10_JPRB,1.2616E-08_JPRB,2.8978E-08_JPRB,6.9473E-08_JPRB,2.9904E-08_JPRB/)
KBO( :, 3,56, 1) = (/&
&1.3402E-10_JPRB,1.2704E-08_JPRB,2.7411E-08_JPRB,5.9088E-08_JPRB,3.0485E-08_JPRB/)
KBO( :, 4,56, 1) = (/&
&1.3548E-10_JPRB,1.2908E-08_JPRB,2.6966E-08_JPRB,5.2631E-08_JPRB,3.1281E-08_JPRB/)
KBO( :, 5,56, 1) = (/&
&1.4854E-10_JPRB,1.3416E-08_JPRB,2.6928E-08_JPRB,4.8694E-08_JPRB,3.2487E-08_JPRB/)
KBO( :, 1,57, 1) = (/&
&1.2648E-10_JPRB,1.0778E-08_JPRB,2.7708E-08_JPRB,7.4942E-08_JPRB,2.4443E-08_JPRB/)
KBO( :, 2,57, 1) = (/&
&1.1666E-10_JPRB,1.0334E-08_JPRB,2.4430E-08_JPRB,6.0404E-08_JPRB,2.4707E-08_JPRB/)
KBO( :, 3,57, 1) = (/&
&1.1067E-10_JPRB,1.0374E-08_JPRB,2.2691E-08_JPRB,5.0714E-08_JPRB,2.5111E-08_JPRB/)
KBO( :, 4,57, 1) = (/&
&1.0967E-10_JPRB,1.0490E-08_JPRB,2.2155E-08_JPRB,4.4446E-08_JPRB,2.5686E-08_JPRB/)
KBO( :, 5,57, 1) = (/&
&1.1697E-10_JPRB,1.0815E-08_JPRB,2.2007E-08_JPRB,4.0752E-08_JPRB,2.6560E-08_JPRB/)
KBO( :, 1,58, 1) = (/&
&1.0659E-10_JPRB,9.0293E-09_JPRB,2.3759E-08_JPRB,6.6089E-08_JPRB,2.0347E-08_JPRB/)
KBO( :, 2,58, 1) = (/&
&9.7636E-11_JPRB,8.5135E-09_JPRB,2.0668E-08_JPRB,5.2543E-08_JPRB,2.0525E-08_JPRB/)
KBO( :, 3,58, 1) = (/&
&9.1732E-11_JPRB,8.4689E-09_JPRB,1.8876E-08_JPRB,4.3570E-08_JPRB,2.0785E-08_JPRB/)
KBO( :, 4,58, 1) = (/&
&8.9487E-11_JPRB,8.5483E-09_JPRB,1.8213E-08_JPRB,3.7645E-08_JPRB,2.1195E-08_JPRB/)
KBO( :, 5,58, 1) = (/&
&9.3059E-11_JPRB,8.7505E-09_JPRB,1.8022E-08_JPRB,3.4131E-08_JPRB,2.1827E-08_JPRB/)
KBO( :, 1,59, 1) = (/&
&8.8331E-11_JPRB,7.4630E-09_JPRB,1.9793E-08_JPRB,5.5593E-08_JPRB,1.7482E-08_JPRB/)
KBO( :, 2,59, 1) = (/&
&8.0694E-11_JPRB,6.9932E-09_JPRB,1.7133E-08_JPRB,4.3957E-08_JPRB,1.7486E-08_JPRB/)
KBO( :, 3,59, 1) = (/&
&7.5549E-11_JPRB,6.9233E-09_JPRB,1.5553E-08_JPRB,3.6288E-08_JPRB,1.7620E-08_JPRB/)
KBO( :, 4,59, 1) = (/&
&7.3293E-11_JPRB,6.9863E-09_JPRB,1.4925E-08_JPRB,3.1206E-08_JPRB,1.7870E-08_JPRB/)
KBO( :, 5,59, 1) = (/&
&7.5492E-11_JPRB,7.1328E-09_JPRB,1.4750E-08_JPRB,2.8159E-08_JPRB,1.8369E-08_JPRB/)
KBO( :, 1,13, 2) = (/&
&1.7831E-06_JPRB,1.1485E-04_JPRB,2.2492E-04_JPRB,4.1688E-04_JPRB,6.0547E-04_JPRB/)
KBO( :, 2,13, 2) = (/&
&2.2523E-06_JPRB,1.2306E-04_JPRB,2.2855E-04_JPRB,3.8873E-04_JPRB,6.9580E-04_JPRB/)
KBO( :, 3,13, 2) = (/&
&3.1401E-06_JPRB,1.3738E-04_JPRB,2.4315E-04_JPRB,3.7873E-04_JPRB,8.1218E-04_JPRB/)
KBO( :, 4,13, 2) = (/&
&4.6444E-06_JPRB,1.5956E-04_JPRB,2.6822E-04_JPRB,3.8629E-04_JPRB,9.5399E-04_JPRB/)
KBO( :, 5,13, 2) = (/&
&7.0313E-06_JPRB,1.8987E-04_JPRB,3.0507E-04_JPRB,4.1261E-04_JPRB,1.1192E-03_JPRB/)
KBO( :, 1,14, 2) = (/&
&1.5078E-06_JPRB,9.3955E-05_JPRB,1.8376E-04_JPRB,3.3845E-04_JPRB,5.0372E-04_JPRB/)
KBO( :, 2,14, 2) = (/&
&1.9334E-06_JPRB,1.0121E-04_JPRB,1.8743E-04_JPRB,3.1713E-04_JPRB,5.7910E-04_JPRB/)
KBO( :, 3,14, 2) = (/&
&2.7160E-06_JPRB,1.1368E-04_JPRB,2.0048E-04_JPRB,3.1032E-04_JPRB,6.7658E-04_JPRB/)
KBO( :, 4,14, 2) = (/&
&4.0314E-06_JPRB,1.3266E-04_JPRB,2.2233E-04_JPRB,3.1845E-04_JPRB,7.9423E-04_JPRB/)
KBO( :, 5,14, 2) = (/&
&6.1144E-06_JPRB,1.5848E-04_JPRB,2.5408E-04_JPRB,3.4197E-04_JPRB,9.2922E-04_JPRB/)
KBO( :, 1,15, 2) = (/&
&1.2774E-06_JPRB,7.6659E-05_JPRB,1.4966E-04_JPRB,2.7428E-04_JPRB,4.0806E-04_JPRB/)
KBO( :, 2,15, 2) = (/&
&1.6539E-06_JPRB,8.3075E-05_JPRB,1.5341E-04_JPRB,2.5818E-04_JPRB,4.6824E-04_JPRB/)
KBO( :, 3,15, 2) = (/&
&2.3327E-06_JPRB,9.3823E-05_JPRB,1.6504E-04_JPRB,2.5400E-04_JPRB,5.4554E-04_JPRB/)
KBO( :, 4,15, 2) = (/&
&3.4694E-06_JPRB,1.1007E-04_JPRB,1.8398E-04_JPRB,2.6231E-04_JPRB,6.3780E-04_JPRB/)
KBO( :, 5,15, 2) = (/&
&5.2705E-06_JPRB,1.3207E-04_JPRB,2.1119E-04_JPRB,2.8323E-04_JPRB,7.4509E-04_JPRB/)
KBO( :, 1,16, 2) = (/&
&1.0807E-06_JPRB,6.2530E-05_JPRB,1.2180E-04_JPRB,2.2215E-04_JPRB,3.2808E-04_JPRB/)
KBO( :, 2,16, 2) = (/&
&1.4084E-06_JPRB,6.8196E-05_JPRB,1.2558E-04_JPRB,2.1014E-04_JPRB,3.7445E-04_JPRB/)
KBO( :, 3,16, 2) = (/&
&1.9921E-06_JPRB,7.7409E-05_JPRB,1.3589E-04_JPRB,2.0792E-04_JPRB,4.3322E-04_JPRB/)
KBO( :, 4,16, 2) = (/&
&2.9709E-06_JPRB,9.1317E-05_JPRB,1.5223E-04_JPRB,2.1610E-04_JPRB,5.0329E-04_JPRB/)
KBO( :, 5,16, 2) = (/&
&4.5175E-06_JPRB,1.1013E-04_JPRB,1.7552E-04_JPRB,2.3456E-04_JPRB,5.8394E-04_JPRB/)
KBO( :, 1,17, 2) = (/&
&9.1180E-07_JPRB,5.1179E-05_JPRB,9.9386E-05_JPRB,1.8025E-04_JPRB,2.6437E-04_JPRB/)
KBO( :, 2,17, 2) = (/&
&1.1946E-06_JPRB,5.6143E-05_JPRB,1.0310E-04_JPRB,1.7134E-04_JPRB,2.9996E-04_JPRB/)
KBO( :, 3,17, 2) = (/&
&1.6972E-06_JPRB,6.4077E-05_JPRB,1.1216E-04_JPRB,1.7049E-04_JPRB,3.4494E-04_JPRB/)
KBO( :, 4,17, 2) = (/&
&2.5402E-06_JPRB,7.6034E-05_JPRB,1.2620E-04_JPRB,1.7834E-04_JPRB,3.9850E-04_JPRB/)
KBO( :, 5,17, 2) = (/&
&3.8602E-06_JPRB,9.2137E-05_JPRB,1.4620E-04_JPRB,1.9446E-04_JPRB,4.6053E-04_JPRB/)
KBO( :, 1,18, 2) = (/&
&7.6847E-07_JPRB,4.2128E-05_JPRB,8.1427E-05_JPRB,1.4663E-04_JPRB,2.1428E-04_JPRB/)
KBO( :, 2,18, 2) = (/&
&1.0140E-06_JPRB,4.6467E-05_JPRB,8.5018E-05_JPRB,1.4005E-04_JPRB,2.4221E-04_JPRB/)
KBO( :, 3,18, 2) = (/&
&1.4492E-06_JPRB,5.3358E-05_JPRB,9.2939E-05_JPRB,1.4019E-04_JPRB,2.7739E-04_JPRB/)
KBO( :, 4,18, 2) = (/&
&2.1756E-06_JPRB,6.3671E-05_JPRB,1.0504E-04_JPRB,1.4753E-04_JPRB,3.1937E-04_JPRB/)
KBO( :, 5,18, 2) = (/&
&3.2973E-06_JPRB,7.7469E-05_JPRB,1.2233E-04_JPRB,1.6159E-04_JPRB,3.6805E-04_JPRB/)
KBO( :, 1,19, 2) = (/&
&6.4665E-07_JPRB,3.4756E-05_JPRB,6.6830E-05_JPRB,1.1940E-04_JPRB,1.7455E-04_JPRB/)
KBO( :, 2,19, 2) = (/&
&8.6026E-07_JPRB,3.8528E-05_JPRB,7.0212E-05_JPRB,1.1460E-04_JPRB,1.9694E-04_JPRB/)
KBO( :, 3,19, 2) = (/&
&1.2368E-06_JPRB,4.4528E-05_JPRB,7.7120E-05_JPRB,1.1540E-04_JPRB,2.2498E-04_JPRB/)
KBO( :, 4,19, 2) = (/&
&1.8580E-06_JPRB,5.3404E-05_JPRB,8.7557E-05_JPRB,1.2215E-04_JPRB,2.5850E-04_JPRB/)
KBO( :, 5,19, 2) = (/&
&2.8103E-06_JPRB,6.5162E-05_JPRB,1.0249E-04_JPRB,1.3438E-04_JPRB,2.9679E-04_JPRB/)
KBO( :, 1,20, 2) = (/&
&5.4656E-07_JPRB,2.8770E-05_JPRB,5.4975E-05_JPRB,9.7196E-05_JPRB,1.4326E-04_JPRB/)
KBO( :, 2,20, 2) = (/&
&7.3436E-07_JPRB,3.2085E-05_JPRB,5.8157E-05_JPRB,9.3865E-05_JPRB,1.6155E-04_JPRB/)
KBO( :, 3,20, 2) = (/&
&1.0622E-06_JPRB,3.7358E-05_JPRB,6.4221E-05_JPRB,9.5159E-05_JPRB,1.8436E-04_JPRB/)
KBO( :, 4,20, 2) = (/&
&1.5965E-06_JPRB,4.4974E-05_JPRB,7.3287E-05_JPRB,1.0139E-04_JPRB,2.1149E-04_JPRB/)
KBO( :, 5,20, 2) = (/&
&2.4119E-06_JPRB,5.5033E-05_JPRB,8.6244E-05_JPRB,1.1207E-04_JPRB,2.4172E-04_JPRB/)
KBO( :, 1,21, 2) = (/&
&4.6233E-07_JPRB,2.3834E-05_JPRB,4.5264E-05_JPRB,7.9149E-05_JPRB,1.1774E-04_JPRB/)
KBO( :, 2,21, 2) = (/&
&6.2707E-07_JPRB,2.6751E-05_JPRB,4.8202E-05_JPRB,7.6928E-05_JPRB,1.3273E-04_JPRB/)
KBO( :, 3,21, 2) = (/&
&9.1123E-07_JPRB,3.1358E-05_JPRB,5.3515E-05_JPRB,7.8550E-05_JPRB,1.5133E-04_JPRB/)
KBO( :, 4,21, 2) = (/&
&1.3711E-06_JPRB,3.7856E-05_JPRB,6.1405E-05_JPRB,8.4206E-05_JPRB,1.7321E-04_JPRB/)
KBO( :, 5,21, 2) = (/&
&2.0698E-06_JPRB,4.6466E-05_JPRB,7.2555E-05_JPRB,9.3524E-05_JPRB,1.9698E-04_JPRB/)
KBO( :, 1,22, 2) = (/&
&3.9809E-07_JPRB,1.9861E-05_JPRB,3.7362E-05_JPRB,6.4255E-05_JPRB,9.7130E-05_JPRB/)
KBO( :, 2,22, 2) = (/&
&5.4666E-07_JPRB,2.2487E-05_JPRB,4.0159E-05_JPRB,6.3058E-05_JPRB,1.0946E-04_JPRB/)
KBO( :, 3,22, 2) = (/&
&8.0057E-07_JPRB,2.6577E-05_JPRB,4.4935E-05_JPRB,6.5070E-05_JPRB,1.2456E-04_JPRB/)
KBO( :, 4,22, 2) = (/&
&1.2071E-06_JPRB,3.2211E-05_JPRB,5.1924E-05_JPRB,7.0344E-05_JPRB,1.4182E-04_JPRB/)
KBO( :, 5,22, 2) = (/&
&1.8195E-06_JPRB,3.9674E-05_JPRB,6.1645E-05_JPRB,7.8623E-05_JPRB,1.6040E-04_JPRB/)
KBO( :, 1,23, 2) = (/&
&3.4367E-07_JPRB,1.6568E-05_JPRB,3.0880E-05_JPRB,5.2238E-05_JPRB,8.0021E-05_JPRB/)
KBO( :, 2,23, 2) = (/&
&4.7758E-07_JPRB,1.8928E-05_JPRB,3.3504E-05_JPRB,5.1762E-05_JPRB,9.0054E-05_JPRB/)
KBO( :, 3,23, 2) = (/&
&7.0447E-07_JPRB,2.2529E-05_JPRB,3.7774E-05_JPRB,5.3990E-05_JPRB,1.0211E-04_JPRB/)
KBO( :, 4,23, 2) = (/&
&1.0638E-06_JPRB,2.7414E-05_JPRB,4.3928E-05_JPRB,5.8845E-05_JPRB,1.1542E-04_JPRB/)
KBO( :, 5,23, 2) = (/&
&1.6007E-06_JPRB,3.3849E-05_JPRB,5.2353E-05_JPRB,6.6134E-05_JPRB,1.3002E-04_JPRB/)
KBO( :, 1,24, 2) = (/&
&2.9731E-07_JPRB,1.3817E-05_JPRB,2.5531E-05_JPRB,4.2477E-05_JPRB,6.5483E-05_JPRB/)
KBO( :, 2,24, 2) = (/&
&4.1800E-07_JPRB,1.5925E-05_JPRB,2.7963E-05_JPRB,4.2525E-05_JPRB,7.3450E-05_JPRB/)
KBO( :, 3,24, 2) = (/&
&6.2039E-07_JPRB,1.9083E-05_JPRB,3.1748E-05_JPRB,4.4841E-05_JPRB,8.2603E-05_JPRB/)
KBO( :, 4,24, 2) = (/&
&9.3799E-07_JPRB,2.3303E-05_JPRB,3.7155E-05_JPRB,4.9236E-05_JPRB,9.2771E-05_JPRB/)
KBO( :, 5,24, 2) = (/&
&1.4084E-06_JPRB,2.8824E-05_JPRB,4.4404E-05_JPRB,5.5621E-05_JPRB,1.0401E-04_JPRB/)
KBO( :, 1,25, 2) = (/&
&2.5846E-07_JPRB,1.1557E-05_JPRB,2.1168E-05_JPRB,3.4591E-05_JPRB,5.3402E-05_JPRB/)
KBO( :, 2,25, 2) = (/&
&3.6779E-07_JPRB,1.3446E-05_JPRB,2.3397E-05_JPRB,3.5019E-05_JPRB,5.9504E-05_JPRB/)
KBO( :, 3,25, 2) = (/&
&5.4914E-07_JPRB,1.6203E-05_JPRB,2.6747E-05_JPRB,3.7316E-05_JPRB,6.6453E-05_JPRB/)
KBO( :, 4,25, 2) = (/&
&8.3081E-07_JPRB,1.9848E-05_JPRB,3.1489E-05_JPRB,4.1271E-05_JPRB,7.4204E-05_JPRB/)
KBO( :, 5,25, 2) = (/&
&1.2434E-06_JPRB,2.4586E-05_JPRB,3.7706E-05_JPRB,4.6843E-05_JPRB,8.2964E-05_JPRB/)
KBO( :, 1,26, 2) = (/&
&2.2688E-07_JPRB,9.7182E-06_JPRB,1.7626E-05_JPRB,2.8238E-05_JPRB,4.3458E-05_JPRB/)
KBO( :, 2,26, 2) = (/&
&3.2698E-07_JPRB,1.1421E-05_JPRB,1.9660E-05_JPRB,2.8946E-05_JPRB,4.8104E-05_JPRB/)
KBO( :, 3,26, 2) = (/&
&4.9095E-07_JPRB,1.3827E-05_JPRB,2.2642E-05_JPRB,3.1162E-05_JPRB,5.3458E-05_JPRB/)
KBO( :, 4,26, 2) = (/&
&7.4254E-07_JPRB,1.6991E-05_JPRB,2.6804E-05_JPRB,3.4710E-05_JPRB,5.9616E-05_JPRB/)
KBO( :, 5,26, 2) = (/&
&1.1064E-06_JPRB,2.1073E-05_JPRB,3.2131E-05_JPRB,3.9581E-05_JPRB,6.6564E-05_JPRB/)
KBO( :, 1,27, 2) = (/&
&1.9993E-07_JPRB,8.1890E-06_JPRB,1.4706E-05_JPRB,2.3104E-05_JPRB,3.4885E-05_JPRB/)
KBO( :, 2,27, 2) = (/&
&2.9147E-07_JPRB,9.7120E-06_JPRB,1.6544E-05_JPRB,2.3984E-05_JPRB,3.8444E-05_JPRB/)
KBO( :, 3,27, 2) = (/&
&4.3955E-07_JPRB,1.1803E-05_JPRB,1.9192E-05_JPRB,2.6063E-05_JPRB,4.2658E-05_JPRB/)
KBO( :, 4,27, 2) = (/&
&6.6365E-07_JPRB,1.4549E-05_JPRB,2.2817E-05_JPRB,2.9214E-05_JPRB,4.7548E-05_JPRB/)
KBO( :, 5,27, 2) = (/&
&9.8399E-07_JPRB,1.8060E-05_JPRB,2.7381E-05_JPRB,3.3454E-05_JPRB,5.3034E-05_JPRB/)
KBO( :, 1,28, 2) = (/&
&1.7666E-07_JPRB,6.9106E-06_JPRB,1.2291E-05_JPRB,1.8950E-05_JPRB,2.7614E-05_JPRB/)
KBO( :, 2,28, 2) = (/&
&2.6027E-07_JPRB,8.2613E-06_JPRB,1.3939E-05_JPRB,1.9912E-05_JPRB,3.0347E-05_JPRB/)
KBO( :, 3,28, 2) = (/&
&3.9360E-07_JPRB,1.0076E-05_JPRB,1.6277E-05_JPRB,2.1822E-05_JPRB,3.3665E-05_JPRB/)
KBO( :, 4,28, 2) = (/&
&5.9255E-07_JPRB,1.2455E-05_JPRB,1.9419E-05_JPRB,2.4599E-05_JPRB,3.7521E-05_JPRB/)
KBO( :, 5,28, 2) = (/&
&8.7397E-07_JPRB,1.5474E-05_JPRB,2.3332E-05_JPRB,2.8281E-05_JPRB,4.1809E-05_JPRB/)
KBO( :, 1,29, 2) = (/&
&1.5731E-07_JPRB,5.8606E-06_JPRB,1.0316E-05_JPRB,1.5600E-05_JPRB,2.1902E-05_JPRB/)
KBO( :, 2,29, 2) = (/&
&2.3400E-07_JPRB,7.0543E-06_JPRB,1.1790E-05_JPRB,1.6590E-05_JPRB,2.4089E-05_JPRB/)
KBO( :, 3,29, 2) = (/&
&3.5418E-07_JPRB,8.6343E-06_JPRB,1.3853E-05_JPRB,1.8324E-05_JPRB,2.6737E-05_JPRB/)
KBO( :, 4,29, 2) = (/&
&5.3119E-07_JPRB,1.0700E-05_JPRB,1.6576E-05_JPRB,2.0766E-05_JPRB,2.9758E-05_JPRB/)
KBO( :, 5,29, 2) = (/&
&7.7916E-07_JPRB,1.3299E-05_JPRB,1.9939E-05_JPRB,2.3971E-05_JPRB,3.3117E-05_JPRB/)
KBO( :, 1,30, 2) = (/&
&1.4063E-07_JPRB,4.9824E-06_JPRB,8.6764E-06_JPRB,1.2880E-05_JPRB,1.7310E-05_JPRB/)
KBO( :, 2,30, 2) = (/&
&2.1067E-07_JPRB,6.0303E-06_JPRB,9.9875E-06_JPRB,1.3848E-05_JPRB,1.9047E-05_JPRB/)
KBO( :, 3,30, 2) = (/&
&3.1873E-07_JPRB,7.4093E-06_JPRB,1.1804E-05_JPRB,1.5408E-05_JPRB,2.1112E-05_JPRB/)
KBO( :, 4,30, 2) = (/&
&4.7602E-07_JPRB,9.1990E-06_JPRB,1.4156E-05_JPRB,1.7550E-05_JPRB,2.3467E-05_JPRB/)
KBO( :, 5,30, 2) = (/&
&6.9431E-07_JPRB,1.1442E-05_JPRB,1.7053E-05_JPRB,2.0340E-05_JPRB,2.6091E-05_JPRB/)
KBO( :, 1,31, 2) = (/&
&1.2644E-07_JPRB,4.2516E-06_JPRB,7.3195E-06_JPRB,1.0673E-05_JPRB,1.3682E-05_JPRB/)
KBO( :, 2,31, 2) = (/&
&1.9031E-07_JPRB,5.1693E-06_JPRB,8.4857E-06_JPRB,1.1593E-05_JPRB,1.5034E-05_JPRB/)
KBO( :, 3,31, 2) = (/&
&2.8751E-07_JPRB,6.3745E-06_JPRB,1.0084E-05_JPRB,1.2985E-05_JPRB,1.6635E-05_JPRB/)
KBO( :, 4,31, 2) = (/&
&4.2724E-07_JPRB,7.9260E-06_JPRB,1.2109E-05_JPRB,1.4860E-05_JPRB,1.8446E-05_JPRB/)
KBO( :, 5,31, 2) = (/&
&6.1916E-07_JPRB,9.8570E-06_JPRB,1.4602E-05_JPRB,1.7280E-05_JPRB,2.0481E-05_JPRB/)
KBO( :, 1,32, 2) = (/&
&1.1409E-07_JPRB,3.6379E-06_JPRB,6.1915E-06_JPRB,8.8747E-06_JPRB,1.0783E-05_JPRB/)
KBO( :, 2,32, 2) = (/&
&1.7228E-07_JPRB,4.4412E-06_JPRB,7.2287E-06_JPRB,9.7273E-06_JPRB,1.1842E-05_JPRB/)
KBO( :, 3,32, 2) = (/&
&2.5962E-07_JPRB,5.4949E-06_JPRB,8.6268E-06_JPRB,1.0963E-05_JPRB,1.3078E-05_JPRB/)
KBO( :, 4,32, 2) = (/&
&3.8365E-07_JPRB,6.8377E-06_JPRB,1.0371E-05_JPRB,1.2605E-05_JPRB,1.4477E-05_JPRB/)
KBO( :, 5,32, 2) = (/&
&5.5233E-07_JPRB,8.5032E-06_JPRB,1.2515E-05_JPRB,1.4698E-05_JPRB,1.6068E-05_JPRB/)
KBO( :, 1,33, 2) = (/&
&1.0319E-07_JPRB,3.1180E-06_JPRB,5.2481E-06_JPRB,7.4004E-06_JPRB,8.4500E-06_JPRB/)
KBO( :, 2,33, 2) = (/&
&1.5612E-07_JPRB,3.8215E-06_JPRB,6.1686E-06_JPRB,8.1771E-06_JPRB,9.2833E-06_JPRB/)
KBO( :, 3,33, 2) = (/&
&2.3441E-07_JPRB,4.7418E-06_JPRB,7.3861E-06_JPRB,9.2700E-06_JPRB,1.0235E-05_JPRB/)
KBO( :, 4,33, 2) = (/&
&3.4446E-07_JPRB,5.9060E-06_JPRB,8.8925E-06_JPRB,1.0710E-05_JPRB,1.1335E-05_JPRB/)
KBO( :, 5,33, 2) = (/&
&4.9241E-07_JPRB,7.3371E-06_JPRB,1.0731E-05_JPRB,1.2507E-05_JPRB,1.2576E-05_JPRB/)
KBO( :, 1,34, 2) = (/&
&9.2307E-08_JPRB,2.6619E-06_JPRB,4.4385E-06_JPRB,6.1710E-06_JPRB,6.7086E-06_JPRB/)
KBO( :, 2,34, 2) = (/&
&1.3970E-07_JPRB,3.2731E-06_JPRB,5.2448E-06_JPRB,6.8652E-06_JPRB,7.3666E-06_JPRB/)
KBO( :, 3,34, 2) = (/&
&2.0895E-07_JPRB,4.0690E-06_JPRB,6.2930E-06_JPRB,7.8186E-06_JPRB,8.1274E-06_JPRB/)
KBO( :, 4,34, 2) = (/&
&3.0532E-07_JPRB,5.0681E-06_JPRB,7.5836E-06_JPRB,9.0634E-06_JPRB,9.0071E-06_JPRB/)
KBO( :, 5,34, 2) = (/&
&4.3392E-07_JPRB,6.2912E-06_JPRB,9.1516E-06_JPRB,1.0598E-05_JPRB,1.0001E-05_JPRB/)
KBO( :, 1,35, 2) = (/&
&7.9334E-08_JPRB,2.2294E-06_JPRB,3.6998E-06_JPRB,5.1049E-06_JPRB,5.2466E-06_JPRB/)
KBO( :, 2,35, 2) = (/&
&1.2002E-07_JPRB,2.7467E-06_JPRB,4.3846E-06_JPRB,5.6993E-06_JPRB,5.7554E-06_JPRB/)
KBO( :, 3,35, 2) = (/&
&1.7912E-07_JPRB,3.4176E-06_JPRB,5.2654E-06_JPRB,6.5073E-06_JPRB,6.3538E-06_JPRB/)
KBO( :, 4,35, 2) = (/&
&2.6096E-07_JPRB,4.2572E-06_JPRB,6.3499E-06_JPRB,7.5566E-06_JPRB,7.0484E-06_JPRB/)
KBO( :, 5,35, 2) = (/&
&3.6971E-07_JPRB,5.2820E-06_JPRB,7.6616E-06_JPRB,8.8415E-06_JPRB,7.8403E-06_JPRB/)
KBO( :, 1,36, 2) = (/&
&6.5133E-08_JPRB,1.8258E-06_JPRB,3.0305E-06_JPRB,4.1781E-06_JPRB,4.0391E-06_JPRB/)
KBO( :, 2,36, 2) = (/&
&9.8521E-08_JPRB,2.2504E-06_JPRB,3.5927E-06_JPRB,4.6670E-06_JPRB,4.4257E-06_JPRB/)
KBO( :, 3,36, 2) = (/&
&1.4704E-07_JPRB,2.8014E-06_JPRB,4.3159E-06_JPRB,5.3307E-06_JPRB,4.8851E-06_JPRB/)
KBO( :, 4,36, 2) = (/&
&2.1423E-07_JPRB,3.4905E-06_JPRB,5.2056E-06_JPRB,6.1919E-06_JPRB,5.4221E-06_JPRB/)
KBO( :, 5,36, 2) = (/&
&3.0347E-07_JPRB,4.3311E-06_JPRB,6.2810E-06_JPRB,7.2464E-06_JPRB,6.0400E-06_JPRB/)
KBO( :, 1,37, 2) = (/&
&5.0409E-08_JPRB,1.4546E-06_JPRB,2.4297E-06_JPRB,3.3777E-06_JPRB,3.1888E-06_JPRB/)
KBO( :, 2,37, 2) = (/&
&7.6278E-08_JPRB,1.7897E-06_JPRB,2.8722E-06_JPRB,3.7595E-06_JPRB,3.4883E-06_JPRB/)
KBO( :, 3,37, 2) = (/&
&1.1416E-07_JPRB,2.2265E-06_JPRB,3.4480E-06_JPRB,4.2834E-06_JPRB,3.8454E-06_JPRB/)
KBO( :, 4,37, 2) = (/&
&1.6695E-07_JPRB,2.7752E-06_JPRB,4.1566E-06_JPRB,4.9670E-06_JPRB,4.2653E-06_JPRB/)
KBO( :, 5,37, 2) = (/&
&2.3741E-07_JPRB,3.4464E-06_JPRB,5.0175E-06_JPRB,5.8098E-06_JPRB,4.7509E-06_JPRB/)
KBO( :, 1,38, 2) = (/&
&3.8890E-08_JPRB,1.1572E-06_JPRB,1.9462E-06_JPRB,2.7303E-06_JPRB,2.5173E-06_JPRB/)
KBO( :, 2,38, 2) = (/&
&5.8839E-08_JPRB,1.4211E-06_JPRB,2.2935E-06_JPRB,3.0265E-06_JPRB,2.7490E-06_JPRB/)
KBO( :, 3,38, 2) = (/&
&8.8306E-08_JPRB,1.7664E-06_JPRB,2.7503E-06_JPRB,3.4388E-06_JPRB,3.0259E-06_JPRB/)
KBO( :, 4,38, 2) = (/&
&1.2963E-07_JPRB,2.2023E-06_JPRB,3.3138E-06_JPRB,3.9798E-06_JPRB,3.3533E-06_JPRB/)
KBO( :, 5,38, 2) = (/&
&1.8509E-07_JPRB,2.7372E-06_JPRB,4.0007E-06_JPRB,4.6520E-06_JPRB,3.7342E-06_JPRB/)
KBO( :, 1,39, 2) = (/&
&3.0015E-08_JPRB,9.2084E-07_JPRB,1.5596E-06_JPRB,2.2083E-06_JPRB,1.9828E-06_JPRB/)
KBO( :, 2,39, 2) = (/&
&4.5385E-08_JPRB,1.1288E-06_JPRB,1.8319E-06_JPRB,2.4376E-06_JPRB,2.1608E-06_JPRB/)
KBO( :, 3,39, 2) = (/&
&6.8278E-08_JPRB,1.4014E-06_JPRB,2.1937E-06_JPRB,2.7616E-06_JPRB,2.3751E-06_JPRB/)
KBO( :, 4,39, 2) = (/&
&1.0061E-07_JPRB,1.7477E-06_JPRB,2.6422E-06_JPRB,3.1891E-06_JPRB,2.6290E-06_JPRB/)
KBO( :, 5,39, 2) = (/&
&1.4423E-07_JPRB,2.1734E-06_JPRB,3.1901E-06_JPRB,3.7248E-06_JPRB,2.9256E-06_JPRB/)
KBO( :, 1,40, 2) = (/&
&2.2256E-08_JPRB,7.1912E-07_JPRB,1.2329E-06_JPRB,1.7745E-06_JPRB,1.5697E-06_JPRB/)
KBO( :, 2,40, 2) = (/&
&3.3569E-08_JPRB,8.7851E-07_JPRB,1.4396E-06_JPRB,1.9436E-06_JPRB,1.7055E-06_JPRB/)
KBO( :, 3,40, 2) = (/&
&5.0664E-08_JPRB,1.0879E-06_JPRB,1.7182E-06_JPRB,2.1900E-06_JPRB,1.8705E-06_JPRB/)
KBO( :, 4,40, 2) = (/&
&7.5118E-08_JPRB,1.3564E-06_JPRB,2.0680E-06_JPRB,2.5192E-06_JPRB,2.0668E-06_JPRB/)
KBO( :, 5,40, 2) = (/&
&1.0843E-07_JPRB,1.6886E-06_JPRB,2.4960E-06_JPRB,2.9369E-06_JPRB,2.2973E-06_JPRB/)
KBO( :, 1,41, 2) = (/&
&1.6447E-08_JPRB,5.6080E-07_JPRB,9.7444E-07_JPRB,1.4286E-06_JPRB,1.2435E-06_JPRB/)
KBO( :, 2,41, 2) = (/&
&2.4695E-08_JPRB,6.8242E-07_JPRB,1.1302E-06_JPRB,1.5500E-06_JPRB,1.3469E-06_JPRB/)
KBO( :, 3,41, 2) = (/&
&3.7349E-08_JPRB,8.4229E-07_JPRB,1.3428E-06_JPRB,1.7360E-06_JPRB,1.4732E-06_JPRB/)
KBO( :, 4,41, 2) = (/&
&5.5705E-08_JPRB,1.0497E-06_JPRB,1.6148E-06_JPRB,1.9875E-06_JPRB,1.6246E-06_JPRB/)
KBO( :, 5,41, 2) = (/&
&8.0988E-08_JPRB,1.3075E-06_JPRB,1.9479E-06_JPRB,2.3109E-06_JPRB,1.8030E-06_JPRB/)
KBO( :, 1,42, 2) = (/&
&1.2186E-08_JPRB,4.3819E-07_JPRB,7.7124E-07_JPRB,1.1538E-06_JPRB,9.8460E-07_JPRB/)
KBO( :, 2,42, 2) = (/&
&1.8167E-08_JPRB,5.3040E-07_JPRB,8.8867E-07_JPRB,1.2386E-06_JPRB,1.0631E-06_JPRB/)
KBO( :, 3,42, 2) = (/&
&2.7496E-08_JPRB,6.5240E-07_JPRB,1.0501E-06_JPRB,1.3776E-06_JPRB,1.1592E-06_JPRB/)
KBO( :, 4,42, 2) = (/&
&4.1226E-08_JPRB,8.1205E-07_JPRB,1.2611E-06_JPRB,1.5695E-06_JPRB,1.2755E-06_JPRB/)
KBO( :, 5,42, 2) = (/&
&6.0358E-08_JPRB,1.0122E-06_JPRB,1.5198E-06_JPRB,1.8189E-06_JPRB,1.4129E-06_JPRB/)
KBO( :, 1,43, 2) = (/&
&8.8825E-09_JPRB,3.4025E-07_JPRB,6.0770E-07_JPRB,9.3331E-07_JPRB,7.8085E-07_JPRB/)
KBO( :, 2,43, 2) = (/&
&1.3077E-08_JPRB,4.0821E-07_JPRB,6.9425E-07_JPRB,9.8759E-07_JPRB,8.3977E-07_JPRB/)
KBO( :, 3,43, 2) = (/&
&1.9763E-08_JPRB,4.9996E-07_JPRB,8.1437E-07_JPRB,1.0881E-06_JPRB,9.1252E-07_JPRB/)
KBO( :, 4,43, 2) = (/&
&2.9785E-08_JPRB,6.2062E-07_JPRB,9.7495E-07_JPRB,1.2316E-06_JPRB,1.0010E-06_JPRB/)
KBO( :, 5,43, 2) = (/&
&4.3968E-08_JPRB,7.7371E-07_JPRB,1.1737E-06_JPRB,1.4206E-06_JPRB,1.1059E-06_JPRB/)
KBO( :, 1,44, 2) = (/&
&6.4652E-09_JPRB,2.6432E-07_JPRB,4.7930E-07_JPRB,7.5854E-07_JPRB,6.2018E-07_JPRB/)
KBO( :, 2,44, 2) = (/&
&9.3431E-09_JPRB,3.1321E-07_JPRB,5.4189E-07_JPRB,7.8917E-07_JPRB,6.6342E-07_JPRB/)
KBO( :, 3,44, 2) = (/&
&1.4054E-08_JPRB,3.8170E-07_JPRB,6.3021E-07_JPRB,8.5948E-07_JPRB,7.1866E-07_JPRB/)
KBO( :, 4,44, 2) = (/&
&2.1257E-08_JPRB,4.7192E-07_JPRB,7.5053E-07_JPRB,9.6532E-07_JPRB,7.8542E-07_JPRB/)
KBO( :, 5,44, 2) = (/&
&3.1636E-08_JPRB,5.8814E-07_JPRB,9.0255E-07_JPRB,1.1069E-06_JPRB,8.6508E-07_JPRB/)
KBO( :, 1,45, 2) = (/&
&4.7493E-09_JPRB,2.0618E-07_JPRB,3.7955E-07_JPRB,6.2010E-07_JPRB,4.9320E-07_JPRB/)
KBO( :, 2,45, 2) = (/&
&6.7046E-09_JPRB,2.4103E-07_JPRB,4.2421E-07_JPRB,6.3409E-07_JPRB,5.2372E-07_JPRB/)
KBO( :, 3,45, 2) = (/&
&9.9979E-09_JPRB,2.9183E-07_JPRB,4.8903E-07_JPRB,6.8121E-07_JPRB,5.6534E-07_JPRB/)
KBO( :, 4,45, 2) = (/&
&1.5142E-08_JPRB,3.5915E-07_JPRB,5.7833E-07_JPRB,7.5825E-07_JPRB,6.1575E-07_JPRB/)
KBO( :, 5,45, 2) = (/&
&2.2692E-08_JPRB,4.4695E-07_JPRB,6.9435E-07_JPRB,8.6394E-07_JPRB,6.7584E-07_JPRB/)
KBO( :, 1,46, 2) = (/&
&3.5026E-09_JPRB,1.6095E-07_JPRB,3.0164E-07_JPRB,5.0988E-07_JPRB,3.9266E-07_JPRB/)
KBO( :, 2,46, 2) = (/&
&4.8056E-09_JPRB,1.8571E-07_JPRB,3.3238E-07_JPRB,5.1211E-07_JPRB,4.1411E-07_JPRB/)
KBO( :, 3,46, 2) = (/&
&7.0611E-09_JPRB,2.2256E-07_JPRB,3.7936E-07_JPRB,5.4108E-07_JPRB,4.4422E-07_JPRB/)
KBO( :, 4,46, 2) = (/&
&1.0674E-08_JPRB,2.7254E-07_JPRB,4.4484E-07_JPRB,5.9573E-07_JPRB,4.8213E-07_JPRB/)
KBO( :, 5,46, 2) = (/&
&1.6091E-08_JPRB,3.3807E-07_JPRB,5.3220E-07_JPRB,6.7368E-07_JPRB,5.2739E-07_JPRB/)
KBO( :, 1,47, 2) = (/&
&2.5860E-09_JPRB,1.2558E-07_JPRB,2.4079E-07_JPRB,4.2237E-07_JPRB,3.1326E-07_JPRB/)
KBO( :, 2,47, 2) = (/&
&3.4290E-09_JPRB,1.4300E-07_JPRB,2.6056E-07_JPRB,4.1623E-07_JPRB,3.2857E-07_JPRB/)
KBO( :, 3,47, 2) = (/&
&4.9220E-09_JPRB,1.6878E-07_JPRB,2.9365E-07_JPRB,4.3092E-07_JPRB,3.4960E-07_JPRB/)
KBO( :, 4,47, 2) = (/&
&7.3908E-09_JPRB,2.0541E-07_JPRB,3.4074E-07_JPRB,4.6771E-07_JPRB,3.7790E-07_JPRB/)
KBO( :, 5,47, 2) = (/&
&1.1182E-08_JPRB,2.5354E-07_JPRB,4.0498E-07_JPRB,5.2394E-07_JPRB,4.1187E-07_JPRB/)
KBO( :, 1,48, 2) = (/&
&1.9362E-09_JPRB,9.8548E-08_JPRB,1.9411E-07_JPRB,3.5272E-07_JPRB,2.4937E-07_JPRB/)
KBO( :, 2,48, 2) = (/&
&2.4798E-09_JPRB,1.1072E-07_JPRB,2.0550E-07_JPRB,3.4105E-07_JPRB,2.6090E-07_JPRB/)
KBO( :, 3,48, 2) = (/&
&3.4555E-09_JPRB,1.2865E-07_JPRB,2.2828E-07_JPRB,3.4594E-07_JPRB,2.7560E-07_JPRB/)
KBO( :, 4,48, 2) = (/&
&5.1234E-09_JPRB,1.5515E-07_JPRB,2.6207E-07_JPRB,3.6909E-07_JPRB,2.9595E-07_JPRB/)
KBO( :, 5,48, 2) = (/&
&7.7538E-09_JPRB,1.9045E-07_JPRB,3.0872E-07_JPRB,4.0878E-07_JPRB,3.2128E-07_JPRB/)
KBO( :, 1,49, 2) = (/&
&1.4693E-09_JPRB,7.7790E-08_JPRB,1.5796E-07_JPRB,2.9638E-07_JPRB,1.9770E-07_JPRB/)
KBO( :, 2,49, 2) = (/&
&1.8189E-09_JPRB,8.6134E-08_JPRB,1.6334E-07_JPRB,2.8139E-07_JPRB,2.0674E-07_JPRB/)
KBO( :, 3,49, 2) = (/&
&2.4514E-09_JPRB,9.8737E-08_JPRB,1.7842E-07_JPRB,2.8001E-07_JPRB,2.1740E-07_JPRB/)
KBO( :, 4,49, 2) = (/&
&3.5625E-09_JPRB,1.1749E-07_JPRB,2.0240E-07_JPRB,2.9292E-07_JPRB,2.3150E-07_JPRB/)
KBO( :, 5,49, 2) = (/&
&5.3682E-09_JPRB,1.4339E-07_JPRB,2.3606E-07_JPRB,3.2024E-07_JPRB,2.5000E-07_JPRB/)
KBO( :, 1,50, 2) = (/&
&1.1339E-09_JPRB,6.1945E-08_JPRB,1.2933E-07_JPRB,2.5041E-07_JPRB,1.5748E-07_JPRB/)
KBO( :, 2,50, 2) = (/&
&1.3605E-09_JPRB,6.7603E-08_JPRB,1.3118E-07_JPRB,2.3383E-07_JPRB,1.6480E-07_JPRB/)
KBO( :, 3,50, 2) = (/&
&1.7751E-09_JPRB,7.6527E-08_JPRB,1.4063E-07_JPRB,2.2853E-07_JPRB,1.7288E-07_JPRB/)
KBO( :, 4,50, 2) = (/&
&2.5157E-09_JPRB,8.9697E-08_JPRB,1.5753E-07_JPRB,2.3451E-07_JPRB,1.8295E-07_JPRB/)
KBO( :, 5,50, 2) = (/&
&3.7579E-09_JPRB,1.0875E-07_JPRB,1.8190E-07_JPRB,2.5266E-07_JPRB,1.9633E-07_JPRB/)
KBO( :, 1,51, 2) = (/&
&8.8714E-10_JPRB,4.9745E-08_JPRB,1.0659E-07_JPRB,2.1260E-07_JPRB,1.2561E-07_JPRB/)
KBO( :, 2,51, 2) = (/&
&1.0323E-09_JPRB,5.3369E-08_JPRB,1.0630E-07_JPRB,1.9542E-07_JPRB,1.3171E-07_JPRB/)
KBO( :, 3,51, 2) = (/&
&1.3054E-09_JPRB,5.9668E-08_JPRB,1.1161E-07_JPRB,1.8777E-07_JPRB,1.3801E-07_JPRB/)
KBO( :, 4,51, 2) = (/&
&1.7978E-09_JPRB,6.8999E-08_JPRB,1.2328E-07_JPRB,1.8919E-07_JPRB,1.4548E-07_JPRB/)
KBO( :, 5,51, 2) = (/&
&2.6478E-09_JPRB,8.2837E-08_JPRB,1.4093E-07_JPRB,2.0051E-07_JPRB,1.5510E-07_JPRB/)
KBO( :, 1,52, 2) = (/&
&7.0184E-10_JPRB,4.0190E-08_JPRB,8.8218E-08_JPRB,1.8136E-07_JPRB,9.9731E-08_JPRB/)
KBO( :, 2,52, 2) = (/&
&7.9197E-10_JPRB,4.2349E-08_JPRB,8.6755E-08_JPRB,1.6417E-07_JPRB,1.0496E-07_JPRB/)
KBO( :, 3,52, 2) = (/&
&9.7132E-10_JPRB,4.6717E-08_JPRB,8.9179E-08_JPRB,1.5515E-07_JPRB,1.1000E-07_JPRB/)
KBO( :, 4,52, 2) = (/&
&1.2972E-09_JPRB,5.3380E-08_JPRB,9.6954E-08_JPRB,1.5366E-07_JPRB,1.1563E-07_JPRB/)
KBO( :, 5,52, 2) = (/&
&1.8721E-09_JPRB,6.3248E-08_JPRB,1.0959E-07_JPRB,1.5990E-07_JPRB,1.2254E-07_JPRB/)
KBO( :, 1,53, 2) = (/&
&5.6092E-10_JPRB,3.2648E-08_JPRB,7.3117E-08_JPRB,1.5519E-07_JPRB,7.8979E-08_JPRB/)
KBO( :, 2,53, 2) = (/&
&6.1423E-10_JPRB,3.3821E-08_JPRB,7.1138E-08_JPRB,1.3880E-07_JPRB,8.3275E-08_JPRB/)
KBO( :, 3,53, 2) = (/&
&7.3095E-10_JPRB,3.6763E-08_JPRB,7.1824E-08_JPRB,1.2909E-07_JPRB,8.7408E-08_JPRB/)
KBO( :, 4,53, 2) = (/&
&9.4591E-10_JPRB,4.1492E-08_JPRB,7.6609E-08_JPRB,1.2565E-07_JPRB,9.1725E-08_JPRB/)
KBO( :, 5,53, 2) = (/&
&1.3305E-09_JPRB,4.8452E-08_JPRB,8.5519E-08_JPRB,1.2833E-07_JPRB,9.6780E-08_JPRB/)
KBO( :, 1,54, 2) = (/&
&4.5340E-10_JPRB,2.6715E-08_JPRB,6.0844E-08_JPRB,1.3273E-07_JPRB,6.3768E-08_JPRB/)
KBO( :, 2,54, 2) = (/&
&4.8357E-10_JPRB,2.7241E-08_JPRB,5.8664E-08_JPRB,1.1758E-07_JPRB,6.7028E-08_JPRB/)
KBO( :, 3,54, 2) = (/&
&5.5955E-10_JPRB,2.9137E-08_JPRB,5.8341E-08_JPRB,1.0779E-07_JPRB,7.0461E-08_JPRB/)
KBO( :, 4,54, 2) = (/&
&7.0364E-10_JPRB,3.2508E-08_JPRB,6.1041E-08_JPRB,1.0330E-07_JPRB,7.3905E-08_JPRB/)
KBO( :, 5,54, 2) = (/&
&9.6348E-10_JPRB,3.7510E-08_JPRB,6.7236E-08_JPRB,1.0378E-07_JPRB,7.7793E-08_JPRB/)
KBO( :, 1,55, 2) = (/&
&3.7018E-10_JPRB,2.1877E-08_JPRB,5.0748E-08_JPRB,1.1383E-07_JPRB,5.2143E-08_JPRB/)
KBO( :, 2,55, 2) = (/&
&3.8461E-10_JPRB,2.2059E-08_JPRB,4.8491E-08_JPRB,9.9810E-08_JPRB,5.4531E-08_JPRB/)
KBO( :, 3,55, 2) = (/&
&4.3319E-10_JPRB,2.3219E-08_JPRB,4.7656E-08_JPRB,9.0291E-08_JPRB,5.7357E-08_JPRB/)
KBO( :, 4,55, 2) = (/&
&5.3033E-10_JPRB,2.5603E-08_JPRB,4.8945E-08_JPRB,8.5282E-08_JPRB,6.0114E-08_JPRB/)
KBO( :, 5,55, 2) = (/&
&7.0668E-10_JPRB,2.9236E-08_JPRB,5.3162E-08_JPRB,8.4413E-08_JPRB,6.3151E-08_JPRB/)
KBO( :, 1,56, 2) = (/&
&3.0445E-10_JPRB,1.7931E-08_JPRB,4.2378E-08_JPRB,9.8533E-08_JPRB,4.2768E-08_JPRB/)
KBO( :, 2,56, 2) = (/&
&3.0831E-10_JPRB,1.7934E-08_JPRB,4.0116E-08_JPRB,8.4908E-08_JPRB,4.4445E-08_JPRB/)
KBO( :, 3,56, 2) = (/&
&3.3824E-10_JPRB,1.8600E-08_JPRB,3.9063E-08_JPRB,7.5998E-08_JPRB,4.6738E-08_JPRB/)
KBO( :, 4,56, 2) = (/&
&4.0330E-10_JPRB,2.0246E-08_JPRB,3.9492E-08_JPRB,7.0783E-08_JPRB,4.8957E-08_JPRB/)
KBO( :, 5,56, 2) = (/&
&5.2280E-10_JPRB,2.2872E-08_JPRB,4.2190E-08_JPRB,6.9008E-08_JPRB,5.1331E-08_JPRB/)
KBO( :, 1,57, 2) = (/&
&2.5188E-10_JPRB,1.4754E-08_JPRB,3.5438E-08_JPRB,8.5756E-08_JPRB,3.5193E-08_JPRB/)
KBO( :, 2,57, 2) = (/&
&2.4912E-10_JPRB,1.4670E-08_JPRB,3.3337E-08_JPRB,7.2430E-08_JPRB,3.6276E-08_JPRB/)
KBO( :, 3,57, 2) = (/&
&2.6653E-10_JPRB,1.4983E-08_JPRB,3.2184E-08_JPRB,6.4241E-08_JPRB,3.8128E-08_JPRB/)
KBO( :, 4,57, 2) = (/&
&3.0939E-10_JPRB,1.6062E-08_JPRB,3.2064E-08_JPRB,5.9025E-08_JPRB,3.9920E-08_JPRB/)
KBO( :, 5,57, 2) = (/&
&3.9021E-10_JPRB,1.7948E-08_JPRB,3.3635E-08_JPRB,5.6680E-08_JPRB,4.1787E-08_JPRB/)
KBO( :, 1,58, 2) = (/&
&2.0925E-10_JPRB,1.2170E-08_JPRB,2.9715E-08_JPRB,7.4671E-08_JPRB,2.9109E-08_JPRB/)
KBO( :, 2,58, 2) = (/&
&2.0318E-10_JPRB,1.2015E-08_JPRB,2.7763E-08_JPRB,6.1869E-08_JPRB,2.9789E-08_JPRB/)
KBO( :, 3,58, 2) = (/&
&2.1207E-10_JPRB,1.2135E-08_JPRB,2.6581E-08_JPRB,5.4388E-08_JPRB,3.1254E-08_JPRB/)
KBO( :, 4,58, 2) = (/&
&2.3998E-10_JPRB,1.2810E-08_JPRB,2.6176E-08_JPRB,4.9330E-08_JPRB,3.2703E-08_JPRB/)
KBO( :, 5,58, 2) = (/&
&2.9508E-10_JPRB,1.4156E-08_JPRB,2.6975E-08_JPRB,4.6724E-08_JPRB,3.4169E-08_JPRB/)
KBO( :, 1,59, 2) = (/&
&1.7253E-10_JPRB,9.9906E-09_JPRB,2.4546E-08_JPRB,6.2526E-08_JPRB,2.4559E-08_JPRB/)
KBO( :, 2,59, 2) = (/&
&1.6644E-10_JPRB,9.8313E-09_JPRB,2.2868E-08_JPRB,5.1484E-08_JPRB,2.5300E-08_JPRB/)
KBO( :, 3,59, 2) = (/&
&1.7202E-10_JPRB,9.8966E-09_JPRB,2.1823E-08_JPRB,4.5067E-08_JPRB,2.6453E-08_JPRB/)
KBO( :, 4,59, 2) = (/&
&1.9270E-10_JPRB,1.0388E-08_JPRB,2.1414E-08_JPRB,4.0702E-08_JPRB,2.7518E-08_JPRB/)
KBO( :, 5,59, 2) = (/&
&2.3454E-10_JPRB,1.1431E-08_JPRB,2.1928E-08_JPRB,3.8364E-08_JPRB,2.8657E-08_JPRB/)
KBO( :, 1,13, 3) = (/&
&9.3592E-06_JPRB,1.8635E-04_JPRB,3.2360E-04_JPRB,5.1013E-04_JPRB,1.3719E-03_JPRB/)
KBO( :, 2,13, 3) = (/&
&1.3997E-05_JPRB,2.2150E-04_JPRB,3.6186E-04_JPRB,5.0766E-04_JPRB,1.6952E-03_JPRB/)
KBO( :, 3,13, 3) = (/&
&2.1472E-05_JPRB,2.7029E-04_JPRB,4.2086E-04_JPRB,5.4160E-04_JPRB,2.0559E-03_JPRB/)
KBO( :, 4,13, 3) = (/&
&3.2949E-05_JPRB,3.3595E-04_JPRB,5.0190E-04_JPRB,6.0909E-04_JPRB,2.4422E-03_JPRB/)
KBO( :, 5,13, 3) = (/&
&5.0055E-05_JPRB,4.2283E-04_JPRB,6.0794E-04_JPRB,7.0057E-04_JPRB,2.8431E-03_JPRB/)
KBO( :, 1,14, 3) = (/&
&7.7811E-06_JPRB,1.5443E-04_JPRB,2.6731E-04_JPRB,4.1737E-04_JPRB,1.1937E-03_JPRB/)
KBO( :, 2,14, 3) = (/&
&1.1790E-05_JPRB,1.8454E-04_JPRB,3.0104E-04_JPRB,4.1861E-04_JPRB,1.4661E-03_JPRB/)
KBO( :, 3,14, 3) = (/&
&1.8281E-05_JPRB,2.2651E-04_JPRB,3.5177E-04_JPRB,4.5049E-04_JPRB,1.7659E-03_JPRB/)
KBO( :, 4,14, 3) = (/&
&2.8361E-05_JPRB,2.8319E-04_JPRB,4.2136E-04_JPRB,5.0814E-04_JPRB,2.0759E-03_JPRB/)
KBO( :, 5,14, 3) = (/&
&4.3496E-05_JPRB,3.5806E-04_JPRB,5.1240E-04_JPRB,5.8626E-04_JPRB,2.3955E-03_JPRB/)
KBO( :, 1,15, 3) = (/&
&6.4085E-06_JPRB,1.2732E-04_JPRB,2.2021E-04_JPRB,3.4093E-04_JPRB,1.0104E-03_JPRB/)
KBO( :, 2,15, 3) = (/&
&9.8620E-06_JPRB,1.5303E-04_JPRB,2.4982E-04_JPRB,3.4487E-04_JPRB,1.2327E-03_JPRB/)
KBO( :, 3,15, 3) = (/&
&1.5483E-05_JPRB,1.8913E-04_JPRB,2.9331E-04_JPRB,3.7385E-04_JPRB,1.4660E-03_JPRB/)
KBO( :, 4,15, 3) = (/&
&2.4329E-05_JPRB,2.3772E-04_JPRB,3.5313E-04_JPRB,4.2330E-04_JPRB,1.7021E-03_JPRB/)
KBO( :, 5,15, 3) = (/&
&3.7620E-05_JPRB,3.0181E-04_JPRB,4.3081E-04_JPRB,4.9037E-04_JPRB,1.9309E-03_JPRB/)
KBO( :, 1,16, 3) = (/&
&5.2944E-06_JPRB,1.0489E-04_JPRB,1.8139E-04_JPRB,2.7836E-04_JPRB,8.1553E-04_JPRB/)
KBO( :, 2,16, 3) = (/&
&8.2639E-06_JPRB,1.2685E-04_JPRB,2.0708E-04_JPRB,2.8409E-04_JPRB,9.8078E-04_JPRB/)
KBO( :, 3,16, 3) = (/&
&1.3171E-05_JPRB,1.5775E-04_JPRB,2.4443E-04_JPRB,3.0988E-04_JPRB,1.1503E-03_JPRB/)
KBO( :, 4,16, 3) = (/&
&2.0912E-05_JPRB,1.9929E-04_JPRB,2.9554E-04_JPRB,3.5252E-04_JPRB,1.3131E-03_JPRB/)
KBO( :, 5,16, 3) = (/&
&3.2496E-05_JPRB,2.5409E-04_JPRB,3.6179E-04_JPRB,4.0963E-04_JPRB,1.4760E-03_JPRB/)
KBO( :, 1,17, 3) = (/&
&4.4493E-06_JPRB,8.6770E-05_JPRB,1.4991E-04_JPRB,2.2771E-04_JPRB,6.5245E-04_JPRB/)
KBO( :, 2,17, 3) = (/&
&7.0395E-06_JPRB,1.0559E-04_JPRB,1.7203E-04_JPRB,2.3430E-04_JPRB,7.7262E-04_JPRB/)
KBO( :, 3,17, 3) = (/&
&1.1335E-05_JPRB,1.3208E-04_JPRB,2.0407E-04_JPRB,2.5722E-04_JPRB,8.9028E-04_JPRB/)
KBO( :, 4,17, 3) = (/&
&1.8069E-05_JPRB,1.6765E-04_JPRB,2.4779E-04_JPRB,2.9368E-04_JPRB,1.0063E-03_JPRB/)
KBO( :, 5,17, 3) = (/&
&2.8090E-05_JPRB,2.1455E-04_JPRB,3.0412E-04_JPRB,3.4249E-04_JPRB,1.1248E-03_JPRB/)
KBO( :, 1,18, 3) = (/&
&3.8316E-06_JPRB,7.2347E-05_JPRB,1.2458E-04_JPRB,1.8673E-04_JPRB,5.2122E-04_JPRB/)
KBO( :, 2,18, 3) = (/&
&6.1184E-06_JPRB,8.8580E-05_JPRB,1.4361E-04_JPRB,1.9377E-04_JPRB,6.0767E-04_JPRB/)
KBO( :, 3,18, 3) = (/&
&9.8947E-06_JPRB,1.1135E-04_JPRB,1.7120E-04_JPRB,2.1410E-04_JPRB,6.9194E-04_JPRB/)
KBO( :, 4,18, 3) = (/&
&1.5756E-05_JPRB,1.4190E-04_JPRB,2.0855E-04_JPRB,2.4531E-04_JPRB,7.7868E-04_JPRB/)
KBO( :, 5,18, 3) = (/&
&2.4472E-05_JPRB,1.8227E-04_JPRB,2.5667E-04_JPRB,2.8708E-04_JPRB,8.6975E-04_JPRB/)
KBO( :, 1,19, 3) = (/&
&3.3167E-06_JPRB,6.0472E-05_JPRB,1.0361E-04_JPRB,1.5344E-04_JPRB,4.1912E-04_JPRB/)
KBO( :, 2,19, 3) = (/&
&5.3275E-06_JPRB,7.4485E-05_JPRB,1.2002E-04_JPRB,1.6049E-04_JPRB,4.8167E-04_JPRB/)
KBO( :, 3,19, 3) = (/&
&8.6182E-06_JPRB,9.4048E-05_JPRB,1.4375E-04_JPRB,1.7839E-04_JPRB,5.4498E-04_JPRB/)
KBO( :, 4,19, 3) = (/&
&1.3697E-05_JPRB,1.2034E-04_JPRB,1.7570E-04_JPRB,2.0508E-04_JPRB,6.1244E-04_JPRB/)
KBO( :, 5,19, 3) = (/&
&2.1261E-05_JPRB,1.5516E-04_JPRB,2.1680E-04_JPRB,2.4089E-04_JPRB,6.8509E-04_JPRB/)
KBO( :, 1,20, 3) = (/&
&2.9049E-06_JPRB,5.0863E-05_JPRB,8.6497E-05_JPRB,1.2631E-04_JPRB,3.3898E-04_JPRB/)
KBO( :, 2,20, 3) = (/&
&4.6782E-06_JPRB,6.3037E-05_JPRB,1.0077E-04_JPRB,1.3328E-04_JPRB,3.8658E-04_JPRB/)
KBO( :, 3,20, 3) = (/&
&7.5551E-06_JPRB,7.9949E-05_JPRB,1.2127E-04_JPRB,1.4912E-04_JPRB,4.3608E-04_JPRB/)
KBO( :, 4,20, 3) = (/&
&1.1985E-05_JPRB,1.0272E-04_JPRB,1.4880E-04_JPRB,1.7209E-04_JPRB,4.8968E-04_JPRB/)
KBO( :, 5,20, 3) = (/&
&1.8564E-05_JPRB,1.3289E-04_JPRB,1.8395E-04_JPRB,2.0290E-04_JPRB,5.4862E-04_JPRB/)
KBO( :, 1,21, 3) = (/&
&2.5348E-06_JPRB,4.2827E-05_JPRB,7.2239E-05_JPRB,1.0405E-04_JPRB,2.7347E-04_JPRB/)
KBO( :, 2,21, 3) = (/&
&4.0896E-06_JPRB,5.3392E-05_JPRB,8.4682E-05_JPRB,1.1078E-04_JPRB,3.1033E-04_JPRB/)
KBO( :, 3,21, 3) = (/&
&6.5911E-06_JPRB,6.8002E-05_JPRB,1.0240E-04_JPRB,1.2468E-04_JPRB,3.4945E-04_JPRB/)
KBO( :, 4,21, 3) = (/&
&1.0443E-05_JPRB,8.7777E-05_JPRB,1.2604E-04_JPRB,1.4448E-04_JPRB,3.9270E-04_JPRB/)
KBO( :, 5,21, 3) = (/&
&1.6126E-05_JPRB,1.1384E-04_JPRB,1.5619E-04_JPRB,1.7100E-04_JPRB,4.4032E-04_JPRB/)
KBO( :, 1,22, 3) = (/&
&2.2535E-06_JPRB,3.6484E-05_JPRB,6.0844E-05_JPRB,8.5915E-05_JPRB,2.1861E-04_JPRB/)
KBO( :, 2,22, 3) = (/&
&3.6421E-06_JPRB,4.5838E-05_JPRB,7.1930E-05_JPRB,9.2688E-05_JPRB,2.4695E-04_JPRB/)
KBO( :, 3,22, 3) = (/&
&5.8649E-06_JPRB,5.8716E-05_JPRB,8.7516E-05_JPRB,1.0512E-04_JPRB,2.7805E-04_JPRB/)
KBO( :, 4,22, 3) = (/&
&9.2724E-06_JPRB,7.6158E-05_JPRB,1.0809E-04_JPRB,1.2256E-04_JPRB,3.1283E-04_JPRB/)
KBO( :, 5,22, 3) = (/&
&1.4237E-05_JPRB,9.8834E-05_JPRB,1.3432E-04_JPRB,1.4571E-04_JPRB,3.5095E-04_JPRB/)
KBO( :, 1,23, 3) = (/&
&1.9940E-06_JPRB,3.1133E-05_JPRB,5.1328E-05_JPRB,7.1090E-05_JPRB,1.7327E-04_JPRB/)
KBO( :, 2,23, 3) = (/&
&3.2312E-06_JPRB,3.9399E-05_JPRB,6.1179E-05_JPRB,7.7708E-05_JPRB,1.9531E-04_JPRB/)
KBO( :, 3,23, 3) = (/&
&5.2011E-06_JPRB,5.0768E-05_JPRB,7.4847E-05_JPRB,8.8760E-05_JPRB,2.2017E-04_JPRB/)
KBO( :, 4,23, 3) = (/&
&8.1919E-06_JPRB,6.6023E-05_JPRB,9.2815E-05_JPRB,1.0413E-04_JPRB,2.4809E-04_JPRB/)
KBO( :, 5,23, 3) = (/&
&1.2498E-05_JPRB,8.5676E-05_JPRB,1.1550E-04_JPRB,1.2430E-04_JPRB,2.7861E-04_JPRB/)
KBO( :, 1,24, 3) = (/&
&1.7459E-06_JPRB,2.6558E-05_JPRB,4.3302E-05_JPRB,5.8931E-05_JPRB,1.3456E-04_JPRB/)
KBO( :, 2,24, 3) = (/&
&2.8378E-06_JPRB,3.3840E-05_JPRB,5.2034E-05_JPRB,6.5221E-05_JPRB,1.5184E-04_JPRB/)
KBO( :, 3,24, 3) = (/&
&4.5668E-06_JPRB,4.3812E-05_JPRB,6.4027E-05_JPRB,7.5015E-05_JPRB,1.7156E-04_JPRB/)
KBO( :, 4,24, 3) = (/&
&7.1655E-06_JPRB,5.7056E-05_JPRB,7.9597E-05_JPRB,8.8545E-05_JPRB,1.9368E-04_JPRB/)
KBO( :, 5,24, 3) = (/&
&1.0891E-05_JPRB,7.4041E-05_JPRB,9.9156E-05_JPRB,1.0602E-04_JPRB,2.1759E-04_JPRB/)
KBO( :, 1,25, 3) = (/&
&1.5351E-06_JPRB,2.2739E-05_JPRB,3.6661E-05_JPRB,4.9033E-05_JPRB,1.0464E-04_JPRB/)
KBO( :, 2,25, 3) = (/&
&2.5013E-06_JPRB,2.9156E-05_JPRB,4.4403E-05_JPRB,5.4906E-05_JPRB,1.1839E-04_JPRB/)
KBO( :, 3,25, 3) = (/&
&4.0193E-06_JPRB,3.7867E-05_JPRB,5.4900E-05_JPRB,6.3596E-05_JPRB,1.3405E-04_JPRB/)
KBO( :, 4,25, 3) = (/&
&6.2816E-06_JPRB,4.9369E-05_JPRB,6.8362E-05_JPRB,7.5478E-05_JPRB,1.5142E-04_JPRB/)
KBO( :, 5,25, 3) = (/&
&9.5147E-06_JPRB,6.4006E-05_JPRB,8.5212E-05_JPRB,9.0532E-05_JPRB,1.6998E-04_JPRB/)
KBO( :, 1,26, 3) = (/&
&1.3683E-06_JPRB,1.9609E-05_JPRB,3.1239E-05_JPRB,4.1025E-05_JPRB,8.2529E-05_JPRB/)
KBO( :, 2,26, 3) = (/&
&2.2313E-06_JPRB,2.5269E-05_JPRB,3.8126E-05_JPRB,4.6436E-05_JPRB,9.3600E-05_JPRB/)
KBO( :, 3,26, 3) = (/&
&3.5754E-06_JPRB,3.2913E-05_JPRB,4.7295E-05_JPRB,5.4190E-05_JPRB,1.0611E-04_JPRB/)
KBO( :, 4,26, 3) = (/&
&5.5664E-06_JPRB,4.2915E-05_JPRB,5.8952E-05_JPRB,6.4581E-05_JPRB,1.1966E-04_JPRB/)
KBO( :, 5,26, 3) = (/&
&8.3928E-06_JPRB,5.5540E-05_JPRB,7.3478E-05_JPRB,7.7578E-05_JPRB,1.3407E-04_JPRB/)
KBO( :, 1,27, 3) = (/&
&1.2171E-06_JPRB,1.6923E-05_JPRB,2.6666E-05_JPRB,3.4428E-05_JPRB,6.4836E-05_JPRB/)
KBO( :, 2,27, 3) = (/&
&1.9862E-06_JPRB,2.1896E-05_JPRB,3.2752E-05_JPRB,3.9332E-05_JPRB,7.3650E-05_JPRB/)
KBO( :, 3,27, 3) = (/&
&3.1750E-06_JPRB,2.8593E-05_JPRB,4.0727E-05_JPRB,4.6210E-05_JPRB,8.3366E-05_JPRB/)
KBO( :, 4,27, 3) = (/&
&4.9257E-06_JPRB,3.7245E-05_JPRB,5.0788E-05_JPRB,5.5242E-05_JPRB,9.3744E-05_JPRB/)
KBO( :, 5,27, 3) = (/&
&7.3934E-06_JPRB,4.8090E-05_JPRB,6.3249E-05_JPRB,6.6414E-05_JPRB,1.0490E-04_JPRB/)
KBO( :, 1,28, 3) = (/&
&1.0792E-06_JPRB,1.4600E-05_JPRB,2.2784E-05_JPRB,2.8952E-05_JPRB,5.0485E-05_JPRB/)
KBO( :, 2,28, 3) = (/&
&1.7629E-06_JPRB,1.8972E-05_JPRB,2.8123E-05_JPRB,3.3346E-05_JPRB,5.7277E-05_JPRB/)
KBO( :, 3,28, 3) = (/&
&2.8131E-06_JPRB,2.4805E-05_JPRB,3.5042E-05_JPRB,3.9409E-05_JPRB,6.4622E-05_JPRB/)
KBO( :, 4,28, 3) = (/&
&4.3512E-06_JPRB,3.2251E-05_JPRB,4.3694E-05_JPRB,4.7211E-05_JPRB,7.2602E-05_JPRB/)
KBO( :, 5,28, 3) = (/&
&6.4989E-06_JPRB,4.1559E-05_JPRB,5.4337E-05_JPRB,5.6763E-05_JPRB,8.1333E-05_JPRB/)
KBO( :, 1,29, 3) = (/&
&9.6857E-07_JPRB,1.2666E-05_JPRB,1.9556E-05_JPRB,2.4447E-05_JPRB,3.9529E-05_JPRB/)
KBO( :, 2,29, 3) = (/&
&1.5818E-06_JPRB,1.6515E-05_JPRB,2.4236E-05_JPRB,2.8362E-05_JPRB,4.4697E-05_JPRB/)
KBO( :, 3,29, 3) = (/&
&2.5168E-06_JPRB,2.1586E-05_JPRB,3.0227E-05_JPRB,3.3688E-05_JPRB,5.0413E-05_JPRB/)
KBO( :, 4,29, 3) = (/&
&3.8723E-06_JPRB,2.8010E-05_JPRB,3.7666E-05_JPRB,4.0411E-05_JPRB,5.6688E-05_JPRB/)
KBO( :, 5,29, 3) = (/&
&5.7462E-06_JPRB,3.6016E-05_JPRB,4.6768E-05_JPRB,4.8565E-05_JPRB,6.3553E-05_JPRB/)
KBO( :, 1,30, 3) = (/&
&8.7056E-07_JPRB,1.1001E-05_JPRB,1.6806E-05_JPRB,2.0679E-05_JPRB,3.0642E-05_JPRB/)
KBO( :, 2,30, 3) = (/&
&1.4204E-06_JPRB,1.4373E-05_JPRB,2.0891E-05_JPRB,2.4158E-05_JPRB,3.4644E-05_JPRB/)
KBO( :, 3,30, 3) = (/&
&2.2511E-06_JPRB,1.8769E-05_JPRB,2.6058E-05_JPRB,2.8796E-05_JPRB,3.9114E-05_JPRB/)
KBO( :, 4,30, 3) = (/&
&3.4456E-06_JPRB,2.4312E-05_JPRB,3.2449E-05_JPRB,3.4570E-05_JPRB,4.4025E-05_JPRB/)
KBO( :, 5,30, 3) = (/&
&5.0796E-06_JPRB,3.1203E-05_JPRB,4.0247E-05_JPRB,4.1528E-05_JPRB,4.9430E-05_JPRB/)
KBO( :, 1,31, 3) = (/&
&7.8800E-07_JPRB,9.5841E-06_JPRB,1.4480E-05_JPRB,1.7537E-05_JPRB,2.3703E-05_JPRB/)
KBO( :, 2,31, 3) = (/&
&1.2827E-06_JPRB,1.2532E-05_JPRB,1.8035E-05_JPRB,2.0619E-05_JPRB,2.6829E-05_JPRB/)
KBO( :, 3,31, 3) = (/&
&2.0224E-06_JPRB,1.6343E-05_JPRB,2.2488E-05_JPRB,2.4639E-05_JPRB,3.0300E-05_JPRB/)
KBO( :, 4,31, 3) = (/&
&3.0735E-06_JPRB,2.1137E-05_JPRB,2.7988E-05_JPRB,2.9590E-05_JPRB,3.4174E-05_JPRB/)
KBO( :, 5,31, 3) = (/&
&4.5010E-06_JPRB,2.7051E-05_JPRB,3.4649E-05_JPRB,3.5519E-05_JPRB,3.8449E-05_JPRB/)
KBO( :, 1,32, 3) = (/&
&7.1645E-07_JPRB,8.3621E-06_JPRB,1.2499E-05_JPRB,1.4908E-05_JPRB,1.8443E-05_JPRB/)
KBO( :, 2,32, 3) = (/&
&1.1619E-06_JPRB,1.0942E-05_JPRB,1.5584E-05_JPRB,1.7626E-05_JPRB,2.0886E-05_JPRB/)
KBO( :, 3,32, 3) = (/&
&1.8202E-06_JPRB,1.4246E-05_JPRB,1.9422E-05_JPRB,2.1099E-05_JPRB,2.3648E-05_JPRB/)
KBO( :, 4,32, 3) = (/&
&2.7468E-06_JPRB,1.8389E-05_JPRB,2.4154E-05_JPRB,2.5344E-05_JPRB,2.6722E-05_JPRB/)
KBO( :, 5,32, 3) = (/&
&3.9939E-06_JPRB,2.3459E-05_JPRB,2.9845E-05_JPRB,3.0391E-05_JPRB,3.0128E-05_JPRB/)
KBO( :, 1,33, 3) = (/&
&6.5279E-07_JPRB,7.3021E-06_JPRB,1.0797E-05_JPRB,1.2695E-05_JPRB,1.4402E-05_JPRB/)
KBO( :, 2,33, 3) = (/&
&1.0533E-06_JPRB,9.5550E-06_JPRB,1.3466E-05_JPRB,1.5078E-05_JPRB,1.6322E-05_JPRB/)
KBO( :, 3,33, 3) = (/&
&1.6386E-06_JPRB,1.2420E-05_JPRB,1.6777E-05_JPRB,1.8071E-05_JPRB,1.8509E-05_JPRB/)
KBO( :, 4,33, 3) = (/&
&2.4555E-06_JPRB,1.6002E-05_JPRB,2.0850E-05_JPRB,2.1713E-05_JPRB,2.0967E-05_JPRB/)
KBO( :, 5,33, 3) = (/&
&3.5438E-06_JPRB,2.0331E-05_JPRB,2.5695E-05_JPRB,2.6001E-05_JPRB,2.3644E-05_JPRB/)
KBO( :, 1,34, 3) = (/&
&5.8863E-07_JPRB,6.3339E-06_JPRB,9.2734E-06_JPRB,1.0778E-05_JPRB,1.1469E-05_JPRB/)
KBO( :, 2,34, 3) = (/&
&9.4445E-07_JPRB,8.2845E-06_JPRB,1.1567E-05_JPRB,1.2839E-05_JPRB,1.3017E-05_JPRB/)
KBO( :, 3,34, 3) = (/&
&1.4596E-06_JPRB,1.0750E-05_JPRB,1.4406E-05_JPRB,1.5399E-05_JPRB,1.4774E-05_JPRB/)
KBO( :, 4,34, 3) = (/&
&2.1724E-06_JPRB,1.3818E-05_JPRB,1.7879E-05_JPRB,1.8493E-05_JPRB,1.6729E-05_JPRB/)
KBO( :, 5,34, 3) = (/&
&3.1148E-06_JPRB,1.7498E-05_JPRB,2.1987E-05_JPRB,2.2131E-05_JPRB,1.8824E-05_JPRB/)
KBO( :, 1,35, 3) = (/&
&5.0537E-07_JPRB,5.3493E-06_JPRB,7.7919E-06_JPRB,9.0039E-06_JPRB,8.9781E-06_JPRB/)
KBO( :, 2,35, 3) = (/&
&8.0918E-07_JPRB,6.9937E-06_JPRB,9.7192E-06_JPRB,1.0739E-05_JPRB,1.0213E-05_JPRB/)
KBO( :, 3,35, 3) = (/&
&1.2470E-06_JPRB,9.0680E-06_JPRB,1.2102E-05_JPRB,1.2886E-05_JPRB,1.1596E-05_JPRB/)
KBO( :, 4,35, 3) = (/&
&1.8501E-06_JPRB,1.1641E-05_JPRB,1.5006E-05_JPRB,1.5470E-05_JPRB,1.3118E-05_JPRB/)
KBO( :, 5,35, 3) = (/&
&2.6449E-06_JPRB,1.4713E-05_JPRB,1.8433E-05_JPRB,1.8505E-05_JPRB,1.4740E-05_JPRB/)
KBO( :, 1,36, 3) = (/&
&4.1057E-07_JPRB,4.3814E-06_JPRB,6.3851E-06_JPRB,7.3787E-06_JPRB,6.8704E-06_JPRB/)
KBO( :, 2,36, 3) = (/&
&6.5882E-07_JPRB,5.7295E-06_JPRB,7.9649E-06_JPRB,8.8014E-06_JPRB,7.8310E-06_JPRB/)
KBO( :, 3,36, 3) = (/&
&1.0168E-06_JPRB,7.4305E-06_JPRB,9.9179E-06_JPRB,1.0562E-05_JPRB,8.9079E-06_JPRB/)
KBO( :, 4,36, 3) = (/&
&1.5108E-06_JPRB,9.5390E-06_JPRB,1.2298E-05_JPRB,1.2679E-05_JPRB,1.0083E-05_JPRB/)
KBO( :, 5,36, 3) = (/&
&2.1616E-06_JPRB,1.2056E-05_JPRB,1.5104E-05_JPRB,1.5169E-05_JPRB,1.1345E-05_JPRB/)
KBO( :, 1,37, 3) = (/&
&3.1315E-07_JPRB,3.4610E-06_JPRB,5.0780E-06_JPRB,5.9099E-06_JPRB,5.3692E-06_JPRB/)
KBO( :, 2,37, 3) = (/&
&5.0553E-07_JPRB,4.5300E-06_JPRB,6.3356E-06_JPRB,7.0381E-06_JPRB,6.1160E-06_JPRB/)
KBO( :, 3,37, 3) = (/&
&7.8502E-07_JPRB,5.8822E-06_JPRB,7.8910E-06_JPRB,8.4420E-06_JPRB,6.9587E-06_JPRB/)
KBO( :, 4,37, 3) = (/&
&1.1731E-06_JPRB,7.5654E-06_JPRB,9.7936E-06_JPRB,1.0137E-05_JPRB,7.8860E-06_JPRB/)
KBO( :, 5,37, 3) = (/&
&1.6874E-06_JPRB,9.5810E-06_JPRB,1.2045E-05_JPRB,1.2132E-05_JPRB,8.8810E-06_JPRB/)
KBO( :, 1,38, 3) = (/&
&2.3771E-07_JPRB,2.7274E-06_JPRB,4.0311E-06_JPRB,4.7281E-06_JPRB,4.1877E-06_JPRB/)
KBO( :, 2,38, 3) = (/&
&3.8612E-07_JPRB,3.5727E-06_JPRB,5.0296E-06_JPRB,5.6200E-06_JPRB,4.7630E-06_JPRB/)
KBO( :, 3,38, 3) = (/&
&6.0348E-07_JPRB,4.6457E-06_JPRB,6.2661E-06_JPRB,6.7370E-06_JPRB,5.4196E-06_JPRB/)
KBO( :, 4,38, 3) = (/&
&9.0735E-07_JPRB,5.9856E-06_JPRB,7.7840E-06_JPRB,8.0913E-06_JPRB,6.1484E-06_JPRB/)
KBO( :, 5,38, 3) = (/&
&1.3127E-06_JPRB,7.5975E-06_JPRB,9.5859E-06_JPRB,9.6880E-06_JPRB,6.9288E-06_JPRB/)
KBO( :, 1,39, 3) = (/&
&1.8023E-07_JPRB,2.1491E-06_JPRB,3.2000E-06_JPRB,3.7837E-06_JPRB,3.2502E-06_JPRB/)
KBO( :, 2,39, 3) = (/&
&2.9456E-07_JPRB,2.8164E-06_JPRB,3.9921E-06_JPRB,4.4877E-06_JPRB,3.6914E-06_JPRB/)
KBO( :, 3,39, 3) = (/&
&4.6344E-07_JPRB,3.6676E-06_JPRB,4.9751E-06_JPRB,5.3760E-06_JPRB,4.1983E-06_JPRB/)
KBO( :, 4,39, 3) = (/&
&7.0119E-07_JPRB,4.7335E-06_JPRB,6.1852E-06_JPRB,6.4579E-06_JPRB,4.7648E-06_JPRB/)
KBO( :, 5,39, 3) = (/&
&1.0202E-06_JPRB,6.0220E-06_JPRB,7.6267E-06_JPRB,7.7355E-06_JPRB,5.3712E-06_JPRB/)
KBO( :, 1,40, 3) = (/&
&1.2988E-07_JPRB,1.6490E-06_JPRB,2.4862E-06_JPRB,2.9837E-06_JPRB,2.5331E-06_JPRB/)
KBO( :, 2,40, 3) = (/&
&2.1421E-07_JPRB,2.1615E-06_JPRB,3.1003E-06_JPRB,3.5229E-06_JPRB,2.8723E-06_JPRB/)
KBO( :, 3,40, 3) = (/&
&3.4046E-07_JPRB,2.8213E-06_JPRB,3.8655E-06_JPRB,4.2144E-06_JPRB,3.2646E-06_JPRB/)
KBO( :, 4,40, 3) = (/&
&5.2031E-07_JPRB,3.6506E-06_JPRB,4.8112E-06_JPRB,5.0626E-06_JPRB,3.7075E-06_JPRB/)
KBO( :, 5,40, 3) = (/&
&7.6450E-07_JPRB,4.6621E-06_JPRB,5.9448E-06_JPRB,6.0685E-06_JPRB,4.1839E-06_JPRB/)
KBO( :, 1,41, 3) = (/&
&9.2788E-08_JPRB,1.2611E-06_JPRB,1.9271E-06_JPRB,2.3514E-06_JPRB,1.9748E-06_JPRB/)
KBO( :, 2,41, 3) = (/&
&1.5438E-07_JPRB,1.6527E-06_JPRB,2.4004E-06_JPRB,2.7614E-06_JPRB,2.2337E-06_JPRB/)
KBO( :, 3,41, 3) = (/&
&2.4802E-07_JPRB,2.1617E-06_JPRB,2.9945E-06_JPRB,3.2967E-06_JPRB,2.5364E-06_JPRB/)
KBO( :, 4,41, 3) = (/&
&3.8306E-07_JPRB,2.8040E-06_JPRB,3.7298E-06_JPRB,3.9584E-06_JPRB,2.8813E-06_JPRB/)
KBO( :, 5,41, 3) = (/&
&5.6866E-07_JPRB,3.5943E-06_JPRB,4.6183E-06_JPRB,4.7484E-06_JPRB,3.2555E-06_JPRB/)
KBO( :, 1,42, 3) = (/&
&6.6123E-08_JPRB,9.6442E-07_JPRB,1.4943E-06_JPRB,1.8557E-06_JPRB,1.5379E-06_JPRB/)
KBO( :, 2,42, 3) = (/&
&1.1090E-07_JPRB,1.2629E-06_JPRB,1.8581E-06_JPRB,2.1664E-06_JPRB,1.7336E-06_JPRB/)
KBO( :, 3,42, 3) = (/&
&1.8006E-07_JPRB,1.6546E-06_JPRB,2.3186E-06_JPRB,2.5790E-06_JPRB,1.9660E-06_JPRB/)
KBO( :, 4,42, 3) = (/&
&2.8112E-07_JPRB,2.1513E-06_JPRB,2.8897E-06_JPRB,3.0943E-06_JPRB,2.2331E-06_JPRB/)
KBO( :, 5,42, 3) = (/&
&4.2176E-07_JPRB,2.7676E-06_JPRB,3.5854E-06_JPRB,3.7139E-06_JPRB,2.5247E-06_JPRB/)
KBO( :, 1,43, 3) = (/&
&4.5723E-08_JPRB,7.2721E-07_JPRB,1.1468E-06_JPRB,1.4561E-06_JPRB,1.1970E-06_JPRB/)
KBO( :, 2,43, 3) = (/&
&7.7279E-08_JPRB,9.5086E-07_JPRB,1.4214E-06_JPRB,1.6869E-06_JPRB,1.3436E-06_JPRB/)
KBO( :, 3,43, 3) = (/&
&1.2698E-07_JPRB,1.2469E-06_JPRB,1.7734E-06_JPRB,1.9988E-06_JPRB,1.5201E-06_JPRB/)
KBO( :, 4,43, 3) = (/&
&2.0087E-07_JPRB,1.6261E-06_JPRB,2.2117E-06_JPRB,2.3948E-06_JPRB,1.7257E-06_JPRB/)
KBO( :, 5,43, 3) = (/&
&3.0517E-07_JPRB,2.0997E-06_JPRB,2.7492E-06_JPRB,2.8756E-06_JPRB,1.9526E-06_JPRB/)
KBO( :, 1,44, 3) = (/&
&3.1195E-08_JPRB,5.4529E-07_JPRB,8.7740E-07_JPRB,1.1428E-06_JPRB,9.3212E-07_JPRB/)
KBO( :, 2,44, 3) = (/&
&5.3002E-08_JPRB,7.1132E-07_JPRB,1.0821E-06_JPRB,1.3117E-06_JPRB,1.0411E-06_JPRB/)
KBO( :, 3,44, 3) = (/&
&8.8116E-08_JPRB,9.3281E-07_JPRB,1.3488E-06_JPRB,1.5439E-06_JPRB,1.1733E-06_JPRB/)
KBO( :, 4,44, 3) = (/&
&1.4135E-07_JPRB,1.2201E-06_JPRB,1.6833E-06_JPRB,1.8457E-06_JPRB,1.3305E-06_JPRB/)
KBO( :, 5,44, 3) = (/&
&2.1772E-07_JPRB,1.5809E-06_JPRB,2.0956E-06_JPRB,2.2159E-06_JPRB,1.5063E-06_JPRB/)
KBO( :, 1,45, 3) = (/&
&2.1310E-08_JPRB,4.0944E-07_JPRB,6.7327E-07_JPRB,9.0153E-07_JPRB,7.2497E-07_JPRB/)
KBO( :, 2,45, 3) = (/&
&3.6231E-08_JPRB,5.3235E-07_JPRB,8.2462E-07_JPRB,1.0227E-06_JPRB,8.0606E-07_JPRB/)
KBO( :, 3,45, 3) = (/&
&6.0860E-08_JPRB,6.9752E-07_JPRB,1.0257E-06_JPRB,1.1946E-06_JPRB,9.0421E-07_JPRB/)
KBO( :, 4,45, 3) = (/&
&9.8966E-08_JPRB,9.1442E-07_JPRB,1.2808E-06_JPRB,1.4232E-06_JPRB,1.0228E-06_JPRB/)
KBO( :, 5,45, 3) = (/&
&1.5458E-07_JPRB,1.1885E-06_JPRB,1.5957E-06_JPRB,1.7071E-06_JPRB,1.1581E-06_JPRB/)
KBO( :, 1,46, 3) = (/&
&1.4455E-08_JPRB,3.0647E-07_JPRB,5.1657E-07_JPRB,7.1517E-07_JPRB,5.6309E-07_JPRB/)
KBO( :, 2,46, 3) = (/&
&2.4438E-08_JPRB,3.9644E-07_JPRB,6.2668E-07_JPRB,7.9740E-07_JPRB,6.2357E-07_JPRB/)
KBO( :, 3,46, 3) = (/&
&4.1400E-08_JPRB,5.1850E-07_JPRB,7.7667E-07_JPRB,9.2312E-07_JPRB,6.9619E-07_JPRB/)
KBO( :, 4,46, 3) = (/&
&6.8241E-08_JPRB,6.8045E-07_JPRB,9.6951E-07_JPRB,1.0939E-06_JPRB,7.8455E-07_JPRB/)
KBO( :, 5,46, 3) = (/&
&1.0821E-07_JPRB,8.8739E-07_JPRB,1.2089E-06_JPRB,1.3101E-06_JPRB,8.8794E-07_JPRB/)
KBO( :, 1,47, 3) = (/&
&9.6929E-09_JPRB,2.2797E-07_JPRB,3.9542E-07_JPRB,5.7182E-07_JPRB,4.3847E-07_JPRB/)
KBO( :, 2,47, 3) = (/&
&1.6123E-08_JPRB,2.9242E-07_JPRB,4.7359E-07_JPRB,6.2141E-07_JPRB,4.8271E-07_JPRB/)
KBO( :, 3,47, 3) = (/&
&2.7447E-08_JPRB,3.8129E-07_JPRB,5.8328E-07_JPRB,7.1120E-07_JPRB,5.3692E-07_JPRB/)
KBO( :, 4,47, 3) = (/&
&4.5855E-08_JPRB,5.0030E-07_JPRB,7.2710E-07_JPRB,8.3592E-07_JPRB,6.0206E-07_JPRB/)
KBO( :, 5,47, 3) = (/&
&7.3923E-08_JPRB,6.5467E-07_JPRB,9.0733E-07_JPRB,9.9829E-07_JPRB,6.8031E-07_JPRB/)
KBO( :, 1,48, 3) = (/&
&6.6058E-09_JPRB,1.7063E-07_JPRB,3.0447E-07_JPRB,4.6224E-07_JPRB,3.4217E-07_JPRB/)
KBO( :, 2,48, 3) = (/&
&1.0670E-08_JPRB,2.1618E-07_JPRB,3.5958E-07_JPRB,4.8824E-07_JPRB,3.7325E-07_JPRB/)
KBO( :, 3,48, 3) = (/&
&1.8128E-08_JPRB,2.8060E-07_JPRB,4.3881E-07_JPRB,5.5007E-07_JPRB,4.1348E-07_JPRB/)
KBO( :, 4,48, 3) = (/&
&3.0624E-08_JPRB,3.6766E-07_JPRB,5.4535E-07_JPRB,6.4036E-07_JPRB,4.6137E-07_JPRB/)
KBO( :, 5,48, 3) = (/&
&5.0151E-08_JPRB,4.8217E-07_JPRB,6.8071E-07_JPRB,7.6123E-07_JPRB,5.1955E-07_JPRB/)
KBO( :, 1,49, 3) = (/&
&4.6014E-09_JPRB,1.2872E-07_JPRB,2.3633E-07_JPRB,3.7814E-07_JPRB,2.6748E-07_JPRB/)
KBO( :, 2,49, 3) = (/&
&7.1127E-09_JPRB,1.6040E-07_JPRB,2.7445E-07_JPRB,3.8804E-07_JPRB,2.8841E-07_JPRB/)
KBO( :, 3,49, 3) = (/&
&1.1951E-08_JPRB,2.0675E-07_JPRB,3.3098E-07_JPRB,4.2738E-07_JPRB,3.1734E-07_JPRB/)
KBO( :, 4,49, 3) = (/&
&2.0341E-08_JPRB,2.7019E-07_JPRB,4.0929E-07_JPRB,4.9230E-07_JPRB,3.5284E-07_JPRB/)
KBO( :, 5,49, 3) = (/&
&3.3789E-08_JPRB,3.5457E-07_JPRB,5.1051E-07_JPRB,5.8104E-07_JPRB,3.9543E-07_JPRB/)
KBO( :, 1,50, 3) = (/&
&3.3123E-09_JPRB,9.8389E-08_JPRB,1.8583E-07_JPRB,3.1200E-07_JPRB,2.1151E-07_JPRB/)
KBO( :, 2,50, 3) = (/&
&4.8635E-09_JPRB,1.2034E-07_JPRB,2.1156E-07_JPRB,3.1223E-07_JPRB,2.2606E-07_JPRB/)
KBO( :, 3,50, 3) = (/&
&8.0017E-09_JPRB,1.5366E-07_JPRB,2.5190E-07_JPRB,3.3521E-07_JPRB,2.4676E-07_JPRB/)
KBO( :, 4,50, 3) = (/&
&1.3638E-08_JPRB,2.0012E-07_JPRB,3.0928E-07_JPRB,3.8141E-07_JPRB,2.7336E-07_JPRB/)
KBO( :, 5,50, 3) = (/&
&2.2922E-08_JPRB,2.6241E-07_JPRB,3.8502E-07_JPRB,4.4648E-07_JPRB,3.0528E-07_JPRB/)
KBO( :, 1,51, 3) = (/&
&2.4418E-09_JPRB,7.5933E-08_JPRB,1.4742E-07_JPRB,2.5968E-07_JPRB,1.6891E-07_JPRB/)
KBO( :, 2,51, 3) = (/&
&3.3989E-09_JPRB,9.1095E-08_JPRB,1.6428E-07_JPRB,2.5385E-07_JPRB,1.7889E-07_JPRB/)
KBO( :, 3,51, 3) = (/&
&5.4139E-09_JPRB,1.1482E-07_JPRB,1.9299E-07_JPRB,2.6542E-07_JPRB,1.9344E-07_JPRB/)
KBO( :, 4,51, 3) = (/&
&9.1803E-09_JPRB,1.4881E-07_JPRB,2.3477E-07_JPRB,2.9709E-07_JPRB,2.1318E-07_JPRB/)
KBO( :, 5,51, 3) = (/&
&1.5567E-08_JPRB,1.9481E-07_JPRB,2.9131E-07_JPRB,3.4464E-07_JPRB,2.3734E-07_JPRB/)
KBO( :, 1,52, 3) = (/&
&1.8356E-09_JPRB,5.9138E-08_JPRB,1.1788E-07_JPRB,2.1792E-07_JPRB,1.3551E-07_JPRB/)
KBO( :, 2,52, 3) = (/&
&2.4226E-09_JPRB,6.9427E-08_JPRB,1.2853E-07_JPRB,2.0827E-07_JPRB,1.4167E-07_JPRB/)
KBO( :, 3,52, 3) = (/&
&3.6921E-09_JPRB,8.6117E-08_JPRB,1.4855E-07_JPRB,2.1230E-07_JPRB,1.5195E-07_JPRB/)
KBO( :, 4,52, 3) = (/&
&6.1793E-09_JPRB,1.1080E-07_JPRB,1.7865E-07_JPRB,2.3238E-07_JPRB,1.6623E-07_JPRB/)
KBO( :, 5,52, 3) = (/&
&1.0533E-08_JPRB,1.4468E-07_JPRB,2.2055E-07_JPRB,2.6689E-07_JPRB,1.8440E-07_JPRB/)
KBO( :, 1,53, 3) = (/&
&1.4057E-09_JPRB,4.6460E-08_JPRB,9.5335E-08_JPRB,1.8476E-07_JPRB,1.0859E-07_JPRB/)
KBO( :, 2,53, 3) = (/&
&1.7607E-09_JPRB,5.3285E-08_JPRB,1.0139E-07_JPRB,1.7215E-07_JPRB,1.1242E-07_JPRB/)
KBO( :, 3,53, 3) = (/&
&2.5488E-09_JPRB,6.4871E-08_JPRB,1.1488E-07_JPRB,1.7132E-07_JPRB,1.1951E-07_JPRB/)
KBO( :, 4,53, 3) = (/&
&4.1657E-09_JPRB,8.2629E-08_JPRB,1.3641E-07_JPRB,1.8283E-07_JPRB,1.2965E-07_JPRB/)
KBO( :, 5,53, 3) = (/&
&7.0997E-09_JPRB,1.0750E-07_JPRB,1.6715E-07_JPRB,2.0732E-07_JPRB,1.4296E-07_JPRB/)
KBO( :, 1,54, 3) = (/&
&1.0999E-09_JPRB,3.6846E-08_JPRB,7.7697E-08_JPRB,1.5754E-07_JPRB,8.8206E-08_JPRB/)
KBO( :, 2,54, 3) = (/&
&1.3156E-09_JPRB,4.1399E-08_JPRB,8.0749E-08_JPRB,1.4331E-07_JPRB,9.0854E-08_JPRB/)
KBO( :, 3,54, 3) = (/&
&1.8124E-09_JPRB,4.9493E-08_JPRB,8.9710E-08_JPRB,1.3962E-07_JPRB,9.5712E-08_JPRB/)
KBO( :, 4,54, 3) = (/&
&2.8677E-09_JPRB,6.2264E-08_JPRB,1.0518E-07_JPRB,1.4542E-07_JPRB,1.0312E-07_JPRB/)
KBO( :, 5,54, 3) = (/&
&4.8571E-09_JPRB,8.0602E-08_JPRB,1.2774E-07_JPRB,1.6229E-07_JPRB,1.1315E-07_JPRB/)
KBO( :, 1,55, 3) = (/&
&8.7254E-10_JPRB,2.9511E-08_JPRB,6.3773E-08_JPRB,1.3472E-07_JPRB,7.2224E-08_JPRB/)
KBO( :, 2,55, 3) = (/&
&1.0019E-09_JPRB,3.2470E-08_JPRB,6.4795E-08_JPRB,1.1996E-07_JPRB,7.4131E-08_JPRB/)
KBO( :, 3,55, 3) = (/&
&1.3171E-09_JPRB,3.8081E-08_JPRB,7.0642E-08_JPRB,1.1458E-07_JPRB,7.7438E-08_JPRB/)
KBO( :, 4,55, 3) = (/&
&2.0021E-09_JPRB,4.7221E-08_JPRB,8.1614E-08_JPRB,1.1674E-07_JPRB,8.2998E-08_JPRB/)
KBO( :, 5,55, 3) = (/&
&3.3482E-09_JPRB,6.0727E-08_JPRB,9.8113E-08_JPRB,1.2774E-07_JPRB,9.0672E-08_JPRB/)
KBO( :, 1,56, 3) = (/&
&6.9950E-10_JPRB,2.3838E-08_JPRB,5.2680E-08_JPRB,1.1562E-07_JPRB,5.9234E-08_JPRB/)
KBO( :, 2,56, 3) = (/&
&7.7413E-10_JPRB,2.5644E-08_JPRB,5.2472E-08_JPRB,1.0117E-07_JPRB,6.0572E-08_JPRB/)
KBO( :, 3,56, 3) = (/&
&9.7208E-10_JPRB,2.9465E-08_JPRB,5.5972E-08_JPRB,9.4548E-08_JPRB,6.2834E-08_JPRB/)
KBO( :, 4,56, 3) = (/&
&1.4121E-09_JPRB,3.5940E-08_JPRB,6.3562E-08_JPRB,9.4353E-08_JPRB,6.6970E-08_JPRB/)
KBO( :, 5,56, 3) = (/&
&2.3128E-09_JPRB,4.5822E-08_JPRB,7.5568E-08_JPRB,1.0098E-07_JPRB,7.2808E-08_JPRB/)
KBO( :, 1,57, 3) = (/&
&5.6581E-10_JPRB,1.9346E-08_JPRB,4.3790E-08_JPRB,9.9565E-08_JPRB,4.8602E-08_JPRB/)
KBO( :, 2,57, 3) = (/&
&6.0638E-10_JPRB,2.0352E-08_JPRB,4.2737E-08_JPRB,8.6020E-08_JPRB,4.9598E-08_JPRB/)
KBO( :, 3,57, 3) = (/&
&7.2835E-10_JPRB,2.2928E-08_JPRB,4.4588E-08_JPRB,7.8554E-08_JPRB,5.1156E-08_JPRB/)
KBO( :, 4,57, 3) = (/&
&1.0089E-09_JPRB,2.7487E-08_JPRB,4.9704E-08_JPRB,7.6812E-08_JPRB,5.4188E-08_JPRB/)
KBO( :, 5,57, 3) = (/&
&1.6034E-09_JPRB,3.4641E-08_JPRB,5.8392E-08_JPRB,8.0331E-08_JPRB,5.8574E-08_JPRB/)
KBO( :, 1,58, 3) = (/&
&4.6103E-10_JPRB,1.5793E-08_JPRB,3.6627E-08_JPRB,8.5726E-08_JPRB,3.9978E-08_JPRB/)
KBO( :, 2,58, 3) = (/&
&4.8130E-10_JPRB,1.6286E-08_JPRB,3.5015E-08_JPRB,7.3307E-08_JPRB,4.0789E-08_JPRB/)
KBO( :, 3,58, 3) = (/&
&5.5585E-10_JPRB,1.8004E-08_JPRB,3.5764E-08_JPRB,6.5610E-08_JPRB,4.1884E-08_JPRB/)
KBO( :, 4,58, 3) = (/&
&7.3630E-10_JPRB,2.1198E-08_JPRB,3.9171E-08_JPRB,6.2959E-08_JPRB,4.4100E-08_JPRB/)
KBO( :, 5,58, 3) = (/&
&1.1276E-09_JPRB,2.6366E-08_JPRB,4.5403E-08_JPRB,6.4458E-08_JPRB,4.7431E-08_JPRB/)
KBO( :, 1,59, 3) = (/&
&3.7755E-10_JPRB,1.2932E-08_JPRB,3.0232E-08_JPRB,7.1480E-08_JPRB,3.3647E-08_JPRB/)
KBO( :, 2,59, 3) = (/&
&3.9028E-10_JPRB,1.3252E-08_JPRB,2.8716E-08_JPRB,6.0919E-08_JPRB,3.4209E-08_JPRB/)
KBO( :, 3,59, 3) = (/&
&4.4415E-10_JPRB,1.4531E-08_JPRB,2.9099E-08_JPRB,5.4129E-08_JPRB,3.5197E-08_JPRB/)
KBO( :, 4,59, 3) = (/&
&5.7804E-10_JPRB,1.6979E-08_JPRB,3.1645E-08_JPRB,5.1588E-08_JPRB,3.7203E-08_JPRB/)
KBO( :, 5,59, 3) = (/&
&8.7073E-10_JPRB,2.0997E-08_JPRB,3.6469E-08_JPRB,5.2428E-08_JPRB,4.0115E-08_JPRB/)
KBO( :, 1,13, 4) = (/&
&8.9291E-05_JPRB,3.8524E-04_JPRB,5.0838E-04_JPRB,6.5865E-04_JPRB,3.8422E-03_JPRB/)
KBO( :, 2,13, 4) = (/&
&1.2150E-04_JPRB,5.0395E-04_JPRB,6.2502E-04_JPRB,7.1591E-04_JPRB,4.4934E-03_JPRB/)
KBO( :, 3,13, 4) = (/&
&1.6722E-04_JPRB,6.6391E-04_JPRB,7.8605E-04_JPRB,8.2001E-04_JPRB,5.0967E-03_JPRB/)
KBO( :, 4,13, 4) = (/&
&2.3167E-04_JPRB,8.6690E-04_JPRB,9.9738E-04_JPRB,9.6960E-04_JPRB,5.6862E-03_JPRB/)
KBO( :, 5,13, 4) = (/&
&3.2066E-04_JPRB,1.1149E-03_JPRB,1.2572E-03_JPRB,1.1723E-03_JPRB,6.2886E-03_JPRB/)
KBO( :, 1,14, 4) = (/&
&7.3069E-05_JPRB,3.2443E-04_JPRB,4.2572E-04_JPRB,5.4565E-04_JPRB,3.2324E-03_JPRB/)
KBO( :, 2,14, 4) = (/&
&1.0078E-04_JPRB,4.2788E-04_JPRB,5.2773E-04_JPRB,5.9812E-04_JPRB,3.7083E-03_JPRB/)
KBO( :, 3,14, 4) = (/&
&1.4066E-04_JPRB,5.6564E-04_JPRB,6.6846E-04_JPRB,6.8982E-04_JPRB,4.1601E-03_JPRB/)
KBO( :, 4,14, 4) = (/&
&1.9708E-04_JPRB,7.3974E-04_JPRB,8.5021E-04_JPRB,8.2165E-04_JPRB,4.6256E-03_JPRB/)
KBO( :, 5,14, 4) = (/&
&2.7523E-04_JPRB,9.5281E-04_JPRB,1.0713E-03_JPRB,9.9745E-04_JPRB,5.1177E-03_JPRB/)
KBO( :, 1,15, 4) = (/&
&5.8268E-05_JPRB,2.7203E-04_JPRB,3.5604E-04_JPRB,4.5206E-04_JPRB,2.5355E-03_JPRB/)
KBO( :, 2,15, 4) = (/&
&8.1805E-05_JPRB,3.6098E-04_JPRB,4.4467E-04_JPRB,4.9956E-04_JPRB,2.8581E-03_JPRB/)
KBO( :, 3,15, 4) = (/&
&1.1620E-04_JPRB,4.7910E-04_JPRB,5.6641E-04_JPRB,5.8044E-04_JPRB,3.1903E-03_JPRB/)
KBO( :, 4,15, 4) = (/&
&1.6501E-04_JPRB,6.2810E-04_JPRB,7.2148E-04_JPRB,6.9577E-04_JPRB,3.5501E-03_JPRB/)
KBO( :, 5,15, 4) = (/&
&2.3301E-04_JPRB,8.1144E-04_JPRB,9.1027E-04_JPRB,8.4726E-04_JPRB,3.9463E-03_JPRB/)
KBO( :, 1,16, 4) = (/&
&4.6115E-05_JPRB,2.2742E-04_JPRB,2.9760E-04_JPRB,3.7441E-04_JPRB,1.8635E-03_JPRB/)
KBO( :, 2,16, 4) = (/&
&6.6044E-05_JPRB,3.0388E-04_JPRB,3.7432E-04_JPRB,4.1709E-04_JPRB,2.0896E-03_JPRB/)
KBO( :, 3,16, 4) = (/&
&9.5513E-05_JPRB,4.0494E-04_JPRB,4.7881E-04_JPRB,4.8833E-04_JPRB,2.3373E-03_JPRB/)
KBO( :, 4,16, 4) = (/&
&1.3768E-04_JPRB,5.3229E-04_JPRB,6.1073E-04_JPRB,5.8836E-04_JPRB,2.6201E-03_JPRB/)
KBO( :, 5,16, 4) = (/&
&1.9676E-04_JPRB,6.8916E-04_JPRB,7.7223E-04_JPRB,7.1811E-04_JPRB,2.9128E-03_JPRB/)
KBO( :, 1,17, 4) = (/&
&3.7236E-05_JPRB,1.9117E-04_JPRB,2.4928E-04_JPRB,3.1036E-04_JPRB,1.3781E-03_JPRB/)
KBO( :, 2,17, 4) = (/&
&5.4291E-05_JPRB,2.5693E-04_JPRB,3.1565E-04_JPRB,3.4867E-04_JPRB,1.5505E-03_JPRB/)
KBO( :, 3,17, 4) = (/&
&7.9749E-05_JPRB,3.4332E-04_JPRB,4.0498E-04_JPRB,4.1127E-04_JPRB,1.7502E-03_JPRB/)
KBO( :, 4,17, 4) = (/&
&1.1653E-04_JPRB,4.5210E-04_JPRB,5.1744E-04_JPRB,4.9715E-04_JPRB,1.9654E-03_JPRB/)
KBO( :, 5,17, 4) = (/&
&1.6848E-04_JPRB,5.8567E-04_JPRB,6.5487E-04_JPRB,6.0828E-04_JPRB,2.1867E-03_JPRB/)
KBO( :, 1,18, 4) = (/&
&3.1214E-05_JPRB,1.6265E-04_JPRB,2.1001E-04_JPRB,2.5789E-04_JPRB,1.0508E-03_JPRB/)
KBO( :, 2,18, 4) = (/&
&4.6115E-05_JPRB,2.1928E-04_JPRB,2.6764E-04_JPRB,2.9235E-04_JPRB,1.1925E-03_JPRB/)
KBO( :, 3,18, 4) = (/&
&6.8526E-05_JPRB,2.9311E-04_JPRB,3.4395E-04_JPRB,3.4662E-04_JPRB,1.3522E-03_JPRB/)
KBO( :, 4,18, 4) = (/&
&1.0108E-04_JPRB,3.8595E-04_JPRB,4.3972E-04_JPRB,4.2050E-04_JPRB,1.5200E-03_JPRB/)
KBO( :, 5,18, 4) = (/&
&1.4724E-04_JPRB,4.9979E-04_JPRB,5.5620E-04_JPRB,5.1508E-04_JPRB,1.6884E-03_JPRB/)
KBO( :, 1,19, 4) = (/&
&2.6494E-05_JPRB,1.3877E-04_JPRB,1.7752E-04_JPRB,2.1456E-04_JPRB,8.3267E-04_JPRB/)
KBO( :, 2,19, 4) = (/&
&3.9645E-05_JPRB,1.8735E-04_JPRB,2.2717E-04_JPRB,2.4531E-04_JPRB,9.5168E-04_JPRB/)
KBO( :, 3,19, 4) = (/&
&5.9441E-05_JPRB,2.5031E-04_JPRB,2.9223E-04_JPRB,2.9203E-04_JPRB,1.0814E-03_JPRB/)
KBO( :, 4,19, 4) = (/&
&8.8341E-05_JPRB,3.2954E-04_JPRB,3.7346E-04_JPRB,3.5516E-04_JPRB,1.2143E-03_JPRB/)
KBO( :, 5,19, 4) = (/&
&1.2952E-04_JPRB,4.2674E-04_JPRB,4.7232E-04_JPRB,4.3565E-04_JPRB,1.3453E-03_JPRB/)
KBO( :, 1,20, 4) = (/&
&2.2953E-05_JPRB,1.1923E-04_JPRB,1.5106E-04_JPRB,1.7906E-04_JPRB,6.7531E-04_JPRB/)
KBO( :, 2,20, 4) = (/&
&3.4684E-05_JPRB,1.6096E-04_JPRB,1.9387E-04_JPRB,2.0645E-04_JPRB,7.7360E-04_JPRB/)
KBO( :, 3,20, 4) = (/&
&5.2387E-05_JPRB,2.1493E-04_JPRB,2.4939E-04_JPRB,2.4674E-04_JPRB,8.7927E-04_JPRB/)
KBO( :, 4,20, 4) = (/&
&7.8339E-05_JPRB,2.8287E-04_JPRB,3.1867E-04_JPRB,3.0094E-04_JPRB,9.8457E-04_JPRB/)
KBO( :, 5,20, 4) = (/&
&1.1532E-04_JPRB,3.6655E-04_JPRB,4.0332E-04_JPRB,3.6955E-04_JPRB,1.0890E-03_JPRB/)
KBO( :, 1,21, 4) = (/&
&1.9939E-05_JPRB,1.0230E-04_JPRB,1.2858E-04_JPRB,1.4968E-04_JPRB,5.4869E-04_JPRB/)
KBO( :, 2,21, 4) = (/&
&3.0427E-05_JPRB,1.3816E-04_JPRB,1.6531E-04_JPRB,1.7375E-04_JPRB,6.2932E-04_JPRB/)
KBO( :, 3,21, 4) = (/&
&4.6301E-05_JPRB,1.8453E-04_JPRB,2.1269E-04_JPRB,2.0848E-04_JPRB,7.1424E-04_JPRB/)
KBO( :, 4,21, 4) = (/&
&6.9612E-05_JPRB,2.4288E-04_JPRB,2.7189E-04_JPRB,2.5497E-04_JPRB,7.9799E-04_JPRB/)
KBO( :, 5,21, 4) = (/&
&1.0255E-04_JPRB,3.1496E-04_JPRB,3.4452E-04_JPRB,3.1356E-04_JPRB,8.8178E-04_JPRB/)
KBO( :, 1,22, 4) = (/&
&1.7650E-05_JPRB,8.9099E-05_JPRB,1.1086E-04_JPRB,1.2617E-04_JPRB,4.4136E-04_JPRB/)
KBO( :, 2,22, 4) = (/&
&2.7256E-05_JPRB,1.2040E-04_JPRB,1.4288E-04_JPRB,1.4770E-04_JPRB,5.0625E-04_JPRB/)
KBO( :, 3,22, 4) = (/&
&4.1784E-05_JPRB,1.6082E-04_JPRB,1.8391E-04_JPRB,1.7825E-04_JPRB,5.7259E-04_JPRB/)
KBO( :, 4,22, 4) = (/&
&6.2963E-05_JPRB,2.1168E-04_JPRB,2.3528E-04_JPRB,2.1869E-04_JPRB,6.3831E-04_JPRB/)
KBO( :, 5,22, 4) = (/&
&9.2479E-05_JPRB,2.7473E-04_JPRB,2.9834E-04_JPRB,2.6936E-04_JPRB,7.0511E-04_JPRB/)
KBO( :, 1,23, 4) = (/&
&1.5661E-05_JPRB,7.7570E-05_JPRB,9.5606E-05_JPRB,1.0649E-04_JPRB,3.5282E-04_JPRB/)
KBO( :, 2,23, 4) = (/&
&2.4419E-05_JPRB,1.0492E-04_JPRB,1.2350E-04_JPRB,1.2569E-04_JPRB,4.0389E-04_JPRB/)
KBO( :, 3,23, 4) = (/&
&3.7617E-05_JPRB,1.4021E-04_JPRB,1.5914E-04_JPRB,1.5253E-04_JPRB,4.5535E-04_JPRB/)
KBO( :, 4,23, 4) = (/&
&5.6623E-05_JPRB,1.8459E-04_JPRB,2.0378E-04_JPRB,1.8772E-04_JPRB,5.0734E-04_JPRB/)
KBO( :, 5,23, 4) = (/&
&8.2850E-05_JPRB,2.3955E-04_JPRB,2.5868E-04_JPRB,2.3168E-04_JPRB,5.6073E-04_JPRB/)
KBO( :, 1,24, 4) = (/&
&1.3761E-05_JPRB,6.7313E-05_JPRB,8.2387E-05_JPRB,8.9985E-05_JPRB,2.7657E-04_JPRB/)
KBO( :, 2,24, 4) = (/&
&2.1660E-05_JPRB,9.1214E-05_JPRB,1.0663E-04_JPRB,1.0703E-04_JPRB,3.1564E-04_JPRB/)
KBO( :, 3,24, 4) = (/&
&3.3471E-05_JPRB,1.2198E-04_JPRB,1.3767E-04_JPRB,1.3062E-04_JPRB,3.5536E-04_JPRB/)
KBO( :, 4,24, 4) = (/&
&5.0313E-05_JPRB,1.6066E-04_JPRB,1.7646E-04_JPRB,1.6127E-04_JPRB,3.9633E-04_JPRB/)
KBO( :, 5,24, 4) = (/&
&7.3360E-05_JPRB,2.0829E-04_JPRB,2.2414E-04_JPRB,1.9939E-04_JPRB,4.3964E-04_JPRB/)
KBO( :, 1,25, 4) = (/&
&1.2163E-05_JPRB,5.8632E-05_JPRB,7.1210E-05_JPRB,7.6289E-05_JPRB,2.1557E-04_JPRB/)
KBO( :, 2,25, 4) = (/&
&1.9262E-05_JPRB,7.9563E-05_JPRB,9.2384E-05_JPRB,9.1431E-05_JPRB,2.4548E-04_JPRB/)
KBO( :, 3,25, 4) = (/&
&2.9768E-05_JPRB,1.0645E-04_JPRB,1.1942E-04_JPRB,1.1222E-04_JPRB,2.7636E-04_JPRB/)
KBO( :, 4,25, 4) = (/&
&4.4635E-05_JPRB,1.4006E-04_JPRB,1.5316E-04_JPRB,1.3892E-04_JPRB,3.0913E-04_JPRB/)
KBO( :, 5,25, 4) = (/&
&6.4723E-05_JPRB,1.8122E-04_JPRB,1.9446E-04_JPRB,1.7203E-04_JPRB,3.4459E-04_JPRB/)
KBO( :, 1,26, 4) = (/&
&1.0905E-05_JPRB,5.1509E-05_JPRB,6.1982E-05_JPRB,6.5048E-05_JPRB,1.6912E-04_JPRB/)
KBO( :, 2,26, 4) = (/&
&1.7301E-05_JPRB,6.9938E-05_JPRB,8.0564E-05_JPRB,7.8594E-05_JPRB,1.9235E-04_JPRB/)
KBO( :, 3,26, 4) = (/&
&2.6674E-05_JPRB,9.3478E-05_JPRB,1.0420E-04_JPRB,9.6933E-05_JPRB,2.1692E-04_JPRB/)
KBO( :, 4,26, 4) = (/&
&3.9810E-05_JPRB,1.2260E-04_JPRB,1.3358E-04_JPRB,1.2031E-04_JPRB,2.4372E-04_JPRB/)
KBO( :, 5,26, 4) = (/&
&5.7269E-05_JPRB,1.5819E-04_JPRB,1.6929E-04_JPRB,1.4904E-04_JPRB,2.7283E-04_JPRB/)
KBO( :, 1,27, 4) = (/&
&9.7443E-06_JPRB,4.5256E-05_JPRB,5.3977E-05_JPRB,5.5564E-05_JPRB,1.3079E-04_JPRB/)
KBO( :, 2,27, 4) = (/&
&1.5468E-05_JPRB,6.1434E-05_JPRB,7.0240E-05_JPRB,6.7661E-05_JPRB,1.4885E-04_JPRB/)
KBO( :, 3,27, 4) = (/&
&2.3785E-05_JPRB,8.1876E-05_JPRB,9.0868E-05_JPRB,8.3801E-05_JPRB,1.6857E-04_JPRB/)
KBO( :, 4,27, 4) = (/&
&3.5289E-05_JPRB,1.0705E-04_JPRB,1.1628E-04_JPRB,1.0418E-04_JPRB,1.9038E-04_JPRB/)
KBO( :, 5,27, 4) = (/&
&5.0352E-05_JPRB,1.3763E-04_JPRB,1.4705E-04_JPRB,1.2891E-04_JPRB,2.1399E-04_JPRB/)
KBO( :, 1,28, 4) = (/&
&8.6662E-06_JPRB,3.9710E-05_JPRB,4.6973E-05_JPRB,4.7545E-05_JPRB,9.9573E-05_JPRB/)
KBO( :, 2,28, 4) = (/&
&1.3762E-05_JPRB,5.3808E-05_JPRB,6.1191E-05_JPRB,5.8312E-05_JPRB,1.1378E-04_JPRB/)
KBO( :, 3,28, 4) = (/&
&2.1087E-05_JPRB,7.1458E-05_JPRB,7.9071E-05_JPRB,7.2428E-05_JPRB,1.2969E-04_JPRB/)
KBO( :, 4,28, 4) = (/&
&3.1073E-05_JPRB,9.3127E-05_JPRB,1.0097E-04_JPRB,9.0079E-05_JPRB,1.4713E-04_JPRB/)
KBO( :, 5,28, 4) = (/&
&4.4032E-05_JPRB,1.1919E-04_JPRB,1.2726E-04_JPRB,1.1128E-04_JPRB,1.6603E-04_JPRB/)
KBO( :, 1,29, 4) = (/&
&7.7998E-06_JPRB,3.4996E-05_JPRB,4.1036E-05_JPRB,4.0865E-05_JPRB,7.6462E-05_JPRB/)
KBO( :, 2,29, 4) = (/&
&1.2351E-05_JPRB,4.7253E-05_JPRB,5.3436E-05_JPRB,5.0409E-05_JPRB,8.7836E-05_JPRB/)
KBO( :, 3,29, 4) = (/&
&1.8799E-05_JPRB,6.2498E-05_JPRB,6.8909E-05_JPRB,6.2727E-05_JPRB,1.0047E-04_JPRB/)
KBO( :, 4,29, 4) = (/&
&2.7485E-05_JPRB,8.1095E-05_JPRB,8.7731E-05_JPRB,7.7973E-05_JPRB,1.1434E-04_JPRB/)
KBO( :, 5,29, 4) = (/&
&3.8681E-05_JPRB,1.0324E-04_JPRB,1.1009E-04_JPRB,9.6092E-05_JPRB,1.2937E-04_JPRB/)
KBO( :, 1,30, 4) = (/&
&7.0184E-06_JPRB,3.0793E-05_JPRB,3.5835E-05_JPRB,3.5181E-05_JPRB,5.8539E-05_JPRB/)
KBO( :, 2,30, 4) = (/&
&1.1059E-05_JPRB,4.1419E-05_JPRB,4.6605E-05_JPRB,4.3585E-05_JPRB,6.7504E-05_JPRB/)
KBO( :, 3,30, 4) = (/&
&1.6707E-05_JPRB,5.4550E-05_JPRB,5.9937E-05_JPRB,5.4295E-05_JPRB,7.7471E-05_JPRB/)
KBO( :, 4,30, 4) = (/&
&2.4261E-05_JPRB,7.0416E-05_JPRB,7.6043E-05_JPRB,6.7394E-05_JPRB,8.8468E-05_JPRB/)
KBO( :, 5,30, 4) = (/&
&3.3920E-05_JPRB,8.9259E-05_JPRB,9.5020E-05_JPRB,8.2834E-05_JPRB,1.0026E-04_JPRB/)
KBO( :, 1,31, 4) = (/&
&6.3446E-06_JPRB,2.7130E-05_JPRB,3.1326E-05_JPRB,3.0364E-05_JPRB,4.4778E-05_JPRB/)
KBO( :, 2,31, 4) = (/&
&9.9240E-06_JPRB,3.6330E-05_JPRB,4.0667E-05_JPRB,3.7732E-05_JPRB,5.1776E-05_JPRB/)
KBO( :, 3,31, 4) = (/&
&1.4883E-05_JPRB,4.7593E-05_JPRB,5.2134E-05_JPRB,4.7015E-05_JPRB,5.9603E-05_JPRB/)
KBO( :, 4,31, 4) = (/&
&2.1454E-05_JPRB,6.1120E-05_JPRB,6.5847E-05_JPRB,5.8207E-05_JPRB,6.8104E-05_JPRB/)
KBO( :, 5,31, 4) = (/&
&2.9770E-05_JPRB,7.7114E-05_JPRB,8.1935E-05_JPRB,7.1309E-05_JPRB,7.7163E-05_JPRB/)
KBO( :, 1,32, 4) = (/&
&5.7447E-06_JPRB,2.3909E-05_JPRB,2.7402E-05_JPRB,2.6256E-05_JPRB,3.4475E-05_JPRB/)
KBO( :, 2,32, 4) = (/&
&8.9146E-06_JPRB,3.1849E-05_JPRB,3.5487E-05_JPRB,3.2695E-05_JPRB,3.9934E-05_JPRB/)
KBO( :, 3,32, 4) = (/&
&1.3271E-05_JPRB,4.1481E-05_JPRB,4.5305E-05_JPRB,4.0703E-05_JPRB,4.6002E-05_JPRB/)
KBO( :, 4,32, 4) = (/&
&1.8982E-05_JPRB,5.3015E-05_JPRB,5.6969E-05_JPRB,5.0230E-05_JPRB,5.2546E-05_JPRB/)
KBO( :, 5,32, 4) = (/&
&2.6129E-05_JPRB,6.6634E-05_JPRB,7.0625E-05_JPRB,6.1359E-05_JPRB,5.9507E-05_JPRB/)
KBO( :, 1,33, 4) = (/&
&5.1981E-06_JPRB,2.1048E-05_JPRB,2.3959E-05_JPRB,2.2727E-05_JPRB,2.6591E-05_JPRB/)
KBO( :, 2,33, 4) = (/&
&8.0045E-06_JPRB,2.7863E-05_JPRB,3.0928E-05_JPRB,2.8329E-05_JPRB,3.0795E-05_JPRB/)
KBO( :, 3,33, 4) = (/&
&1.1826E-05_JPRB,3.6107E-05_JPRB,3.9311E-05_JPRB,3.5200E-05_JPRB,3.5437E-05_JPRB/)
KBO( :, 4,33, 4) = (/&
&1.6780E-05_JPRB,4.5955E-05_JPRB,4.9249E-05_JPRB,4.3321E-05_JPRB,4.0422E-05_JPRB/)
KBO( :, 5,33, 4) = (/&
&2.2903E-05_JPRB,5.7519E-05_JPRB,6.0835E-05_JPRB,5.2765E-05_JPRB,4.5739E-05_JPRB/)
KBO( :, 1,34, 4) = (/&
&4.6580E-06_JPRB,1.8365E-05_JPRB,2.0792E-05_JPRB,1.9562E-05_JPRB,2.0973E-05_JPRB/)
KBO( :, 2,34, 4) = (/&
&7.1195E-06_JPRB,2.4178E-05_JPRB,2.6741E-05_JPRB,2.4385E-05_JPRB,2.4253E-05_JPRB/)
KBO( :, 3,34, 4) = (/&
&1.0442E-05_JPRB,3.1196E-05_JPRB,3.3863E-05_JPRB,3.0227E-05_JPRB,2.7827E-05_JPRB/)
KBO( :, 4,34, 4) = (/&
&1.4703E-05_JPRB,3.9556E-05_JPRB,4.2281E-05_JPRB,3.7105E-05_JPRB,3.1694E-05_JPRB/)
KBO( :, 5,34, 4) = (/&
&1.9922E-05_JPRB,4.9351E-05_JPRB,5.2082E-05_JPRB,4.5102E-05_JPRB,3.5824E-05_JPRB/)
KBO( :, 1,35, 4) = (/&
&3.9871E-06_JPRB,1.5551E-05_JPRB,1.7571E-05_JPRB,1.6475E-05_JPRB,1.6236E-05_JPRB/)
KBO( :, 2,35, 4) = (/&
&6.0757E-06_JPRB,2.0414E-05_JPRB,2.2542E-05_JPRB,2.0527E-05_JPRB,1.8741E-05_JPRB/)
KBO( :, 3,35, 4) = (/&
&8.8794E-06_JPRB,2.6281E-05_JPRB,2.8490E-05_JPRB,2.5405E-05_JPRB,2.1473E-05_JPRB/)
KBO( :, 4,35, 4) = (/&
&1.2455E-05_JPRB,3.3253E-05_JPRB,3.5511E-05_JPRB,3.1147E-05_JPRB,2.4458E-05_JPRB/)
KBO( :, 5,35, 4) = (/&
&1.6817E-05_JPRB,4.1417E-05_JPRB,4.3680E-05_JPRB,3.7812E-05_JPRB,2.7668E-05_JPRB/)
KBO( :, 1,36, 4) = (/&
&3.2421E-06_JPRB,1.2741E-05_JPRB,1.4415E-05_JPRB,1.3532E-05_JPRB,1.2305E-05_JPRB/)
KBO( :, 2,36, 4) = (/&
&4.9489E-06_JPRB,1.6721E-05_JPRB,1.8482E-05_JPRB,1.6856E-05_JPRB,1.4197E-05_JPRB/)
KBO( :, 3,36, 4) = (/&
&7.2420E-06_JPRB,2.1525E-05_JPRB,2.3354E-05_JPRB,2.0857E-05_JPRB,1.6279E-05_JPRB/)
KBO( :, 4,36, 4) = (/&
&1.0165E-05_JPRB,2.7235E-05_JPRB,2.9106E-05_JPRB,2.5564E-05_JPRB,1.8568E-05_JPRB/)
KBO( :, 5,36, 4) = (/&
&1.3731E-05_JPRB,3.3924E-05_JPRB,3.5798E-05_JPRB,3.1035E-05_JPRB,2.1028E-05_JPRB/)
KBO( :, 1,37, 4) = (/&
&2.4960E-06_JPRB,1.0060E-05_JPRB,1.1424E-05_JPRB,1.0782E-05_JPRB,9.5086E-06_JPRB/)
KBO( :, 2,37, 4) = (/&
&3.8363E-06_JPRB,1.3236E-05_JPRB,1.4673E-05_JPRB,1.3431E-05_JPRB,1.0977E-05_JPRB/)
KBO( :, 3,37, 4) = (/&
&5.6488E-06_JPRB,1.7076E-05_JPRB,1.8572E-05_JPRB,1.6635E-05_JPRB,1.2594E-05_JPRB/)
KBO( :, 4,37, 4) = (/&
&7.9747E-06_JPRB,2.1652E-05_JPRB,2.3188E-05_JPRB,2.0415E-05_JPRB,1.4374E-05_JPRB/)
KBO( :, 5,37, 4) = (/&
&1.0825E-05_JPRB,2.7021E-05_JPRB,2.8566E-05_JPRB,2.4811E-05_JPRB,1.6291E-05_JPRB/)
KBO( :, 1,38, 4) = (/&
&1.9124E-06_JPRB,7.9183E-06_JPRB,9.0316E-06_JPRB,8.5743E-06_JPRB,7.3236E-06_JPRB/)
KBO( :, 2,38, 4) = (/&
&2.9610E-06_JPRB,1.0450E-05_JPRB,1.1621E-05_JPRB,1.0680E-05_JPRB,8.4614E-06_JPRB/)
KBO( :, 3,38, 4) = (/&
&4.3884E-06_JPRB,1.3515E-05_JPRB,1.4735E-05_JPRB,1.3241E-05_JPRB,9.7136E-06_JPRB/)
KBO( :, 4,38, 4) = (/&
&6.2344E-06_JPRB,1.7177E-05_JPRB,1.8435E-05_JPRB,1.6272E-05_JPRB,1.1094E-05_JPRB/)
KBO( :, 5,38, 4) = (/&
&8.5074E-06_JPRB,2.1480E-05_JPRB,2.2749E-05_JPRB,1.9801E-05_JPRB,1.2587E-05_JPRB/)
KBO( :, 1,39, 4) = (/&
&1.4627E-06_JPRB,6.2280E-06_JPRB,7.1358E-06_JPRB,6.8164E-06_JPRB,5.6091E-06_JPRB/)
KBO( :, 2,39, 4) = (/&
&2.2819E-06_JPRB,8.2437E-06_JPRB,9.1991E-06_JPRB,8.4900E-06_JPRB,6.4837E-06_JPRB/)
KBO( :, 3,39, 4) = (/&
&3.4040E-06_JPRB,1.0689E-05_JPRB,1.1687E-05_JPRB,1.0535E-05_JPRB,7.4507E-06_JPRB/)
KBO( :, 4,39, 4) = (/&
&4.8667E-06_JPRB,1.3619E-05_JPRB,1.4649E-05_JPRB,1.2965E-05_JPRB,8.5144E-06_JPRB/)
KBO( :, 5,39, 4) = (/&
&6.6789E-06_JPRB,1.7065E-05_JPRB,1.8109E-05_JPRB,1.5796E-05_JPRB,9.6724E-06_JPRB/)
KBO( :, 1,40, 4) = (/&
&1.0675E-06_JPRB,4.7580E-06_JPRB,5.4948E-06_JPRB,5.3059E-06_JPRB,4.3235E-06_JPRB/)
KBO( :, 2,40, 4) = (/&
&1.6854E-06_JPRB,6.3316E-06_JPRB,7.1065E-06_JPRB,6.6059E-06_JPRB,5.0037E-06_JPRB/)
KBO( :, 3,40, 4) = (/&
&2.5416E-06_JPRB,8.2475E-06_JPRB,9.0584E-06_JPRB,8.2078E-06_JPRB,5.7598E-06_JPRB/)
KBO( :, 4,40, 4) = (/&
&3.6732E-06_JPRB,1.0552E-05_JPRB,1.1392E-05_JPRB,1.0125E-05_JPRB,6.5921E-06_JPRB/)
KBO( :, 5,40, 4) = (/&
&5.0895E-06_JPRB,1.3270E-05_JPRB,1.4125E-05_JPRB,1.2362E-05_JPRB,7.4983E-06_JPRB/)
KBO( :, 1,41, 4) = (/&
&7.7161E-07_JPRB,3.6153E-06_JPRB,4.2135E-06_JPRB,4.1208E-06_JPRB,3.3291E-06_JPRB/)
KBO( :, 2,41, 4) = (/&
&1.2341E-06_JPRB,4.8398E-06_JPRB,5.4667E-06_JPRB,5.1245E-06_JPRB,3.8572E-06_JPRB/)
KBO( :, 3,41, 4) = (/&
&1.8830E-06_JPRB,6.3358E-06_JPRB,6.9937E-06_JPRB,6.3742E-06_JPRB,4.4475E-06_JPRB/)
KBO( :, 4,41, 4) = (/&
&2.7524E-06_JPRB,8.1422E-06_JPRB,8.8253E-06_JPRB,7.8806E-06_JPRB,5.1001E-06_JPRB/)
KBO( :, 5,41, 4) = (/&
&3.8533E-06_JPRB,1.0280E-05_JPRB,1.0980E-05_JPRB,9.6445E-06_JPRB,5.8088E-06_JPRB/)
KBO( :, 1,42, 4) = (/&
&5.5525E-07_JPRB,2.7416E-06_JPRB,3.2273E-06_JPRB,3.2019E-06_JPRB,2.5561E-06_JPRB/)
KBO( :, 2,42, 4) = (/&
&8.9993E-07_JPRB,3.6924E-06_JPRB,4.1998E-06_JPRB,3.9740E-06_JPRB,2.9638E-06_JPRB/)
KBO( :, 3,42, 4) = (/&
&1.3900E-06_JPRB,4.8597E-06_JPRB,5.3933E-06_JPRB,4.9465E-06_JPRB,3.4230E-06_JPRB/)
KBO( :, 4,42, 4) = (/&
&2.0552E-06_JPRB,6.2735E-06_JPRB,6.8295E-06_JPRB,6.1284E-06_JPRB,3.9326E-06_JPRB/)
KBO( :, 5,42, 4) = (/&
&2.9084E-06_JPRB,7.9541E-06_JPRB,8.5264E-06_JPRB,7.5190E-06_JPRB,4.4871E-06_JPRB/)
KBO( :, 1,43, 4) = (/&
&3.8700E-07_JPRB,2.0403E-06_JPRB,2.4343E-06_JPRB,2.4629E-06_JPRB,1.9559E-06_JPRB/)
KBO( :, 2,43, 4) = (/&
&6.3768E-07_JPRB,2.7683E-06_JPRB,3.1780E-06_JPRB,3.0455E-06_JPRB,2.2677E-06_JPRB/)
KBO( :, 3,43, 4) = (/&
&9.9992E-07_JPRB,3.6688E-06_JPRB,4.0996E-06_JPRB,3.7915E-06_JPRB,2.6241E-06_JPRB/)
KBO( :, 4,43, 4) = (/&
&1.4987E-06_JPRB,4.7637E-06_JPRB,5.2140E-06_JPRB,4.7076E-06_JPRB,3.0207E-06_JPRB/)
KBO( :, 5,43, 4) = (/&
&2.1501E-06_JPRB,6.0714E-06_JPRB,6.5361E-06_JPRB,5.7934E-06_JPRB,3.4541E-06_JPRB/)
KBO( :, 1,44, 4) = (/&
&2.6473E-07_JPRB,1.5026E-06_JPRB,1.8221E-06_JPRB,1.8897E-06_JPRB,1.4930E-06_JPRB/)
KBO( :, 2,44, 4) = (/&
&4.4431E-07_JPRB,2.0561E-06_JPRB,2.3866E-06_JPRB,2.3229E-06_JPRB,1.7300E-06_JPRB/)
KBO( :, 3,44, 4) = (/&
&7.0836E-07_JPRB,2.7457E-06_JPRB,3.0927E-06_JPRB,2.8894E-06_JPRB,2.0046E-06_JPRB/)
KBO( :, 4,44, 4) = (/&
&1.0778E-06_JPRB,3.5888E-06_JPRB,3.9529E-06_JPRB,3.5941E-06_JPRB,2.3122E-06_JPRB/)
KBO( :, 5,44, 4) = (/&
&1.5696E-06_JPRB,4.6015E-06_JPRB,4.9786E-06_JPRB,4.4373E-06_JPRB,2.6499E-06_JPRB/)
KBO( :, 1,45, 4) = (/&
&1.7988E-07_JPRB,1.1038E-06_JPRB,1.3625E-06_JPRB,1.4540E-06_JPRB,1.1371E-06_JPRB/)
KBO( :, 2,45, 4) = (/&
&3.0761E-07_JPRB,1.5225E-06_JPRB,1.7898E-06_JPRB,1.7738E-06_JPRB,1.3160E-06_JPRB/)
KBO( :, 3,45, 4) = (/&
&4.9893E-07_JPRB,2.0494E-06_JPRB,2.3287E-06_JPRB,2.2017E-06_JPRB,1.5258E-06_JPRB/)
KBO( :, 4,45, 4) = (/&
&7.7117E-07_JPRB,2.6974E-06_JPRB,2.9913E-06_JPRB,2.7416E-06_JPRB,1.7632E-06_JPRB/)
KBO( :, 5,45, 4) = (/&
&1.1399E-06_JPRB,3.4797E-06_JPRB,3.7851E-06_JPRB,3.3943E-06_JPRB,2.0252E-06_JPRB/)
KBO( :, 1,46, 4) = (/&
&1.1995E-07_JPRB,8.0292E-07_JPRB,1.0121E-06_JPRB,1.1184E-06_JPRB,8.6488E-07_JPRB/)
KBO( :, 2,46, 4) = (/&
&2.0923E-07_JPRB,1.1166E-06_JPRB,1.3331E-06_JPRB,1.3511E-06_JPRB,9.9849E-07_JPRB/)
KBO( :, 3,46, 4) = (/&
&3.4582E-07_JPRB,1.5161E-06_JPRB,1.7409E-06_JPRB,1.6700E-06_JPRB,1.1579E-06_JPRB/)
KBO( :, 4,46, 4) = (/&
&5.4384E-07_JPRB,2.0114E-06_JPRB,2.2481E-06_JPRB,2.0803E-06_JPRB,1.3401E-06_JPRB/)
KBO( :, 5,46, 4) = (/&
&8.1669E-07_JPRB,2.6123E-06_JPRB,2.8596E-06_JPRB,2.5822E-06_JPRB,1.5424E-06_JPRB/)
KBO( :, 1,47, 4) = (/&
&7.7552E-08_JPRB,5.7430E-07_JPRB,7.4352E-07_JPRB,8.5913E-07_JPRB,6.5834E-07_JPRB/)
KBO( :, 2,47, 4) = (/&
&1.3815E-07_JPRB,8.0547E-07_JPRB,9.8055E-07_JPRB,1.0241E-06_JPRB,7.5785E-07_JPRB/)
KBO( :, 3,47, 4) = (/&
&2.3338E-07_JPRB,1.1046E-06_JPRB,1.2855E-06_JPRB,1.2567E-06_JPRB,8.7753E-07_JPRB/)
KBO( :, 4,47, 4) = (/&
&3.7439E-07_JPRB,1.4793E-06_JPRB,1.6690E-06_JPRB,1.5636E-06_JPRB,1.0168E-06_JPRB/)
KBO( :, 5,47, 4) = (/&
&5.7238E-07_JPRB,1.9364E-06_JPRB,2.1357E-06_JPRB,1.9451E-06_JPRB,1.1726E-06_JPRB/)
KBO( :, 1,48, 4) = (/&
&4.9759E-08_JPRB,4.0982E-07_JPRB,5.4734E-07_JPRB,6.6597E-07_JPRB,5.0055E-07_JPRB/)
KBO( :, 2,48, 4) = (/&
&9.0399E-08_JPRB,5.7899E-07_JPRB,7.2041E-07_JPRB,7.7952E-07_JPRB,5.7407E-07_JPRB/)
KBO( :, 3,48, 4) = (/&
&1.5613E-07_JPRB,8.0155E-07_JPRB,9.4754E-07_JPRB,9.4742E-07_JPRB,6.6288E-07_JPRB/)
KBO( :, 4,48, 4) = (/&
&2.5563E-07_JPRB,1.0837E-06_JPRB,1.2359E-06_JPRB,1.1750E-06_JPRB,7.6860E-07_JPRB/)
KBO( :, 5,48, 4) = (/&
&3.9824E-07_JPRB,1.4310E-06_JPRB,1.5913E-06_JPRB,1.4634E-06_JPRB,8.8756E-07_JPRB/)
KBO( :, 1,49, 4) = (/&
&3.1747E-08_JPRB,2.9202E-07_JPRB,4.0458E-07_JPRB,5.2185E-07_JPRB,3.8074E-07_JPRB/)
KBO( :, 2,49, 4) = (/&
&5.8620E-08_JPRB,4.1476E-07_JPRB,5.2889E-07_JPRB,5.9643E-07_JPRB,4.3322E-07_JPRB/)
KBO( :, 3,49, 4) = (/&
&1.0349E-07_JPRB,5.7925E-07_JPRB,6.9731E-07_JPRB,7.1647E-07_JPRB,4.9889E-07_JPRB/)
KBO( :, 4,49, 4) = (/&
&1.7311E-07_JPRB,7.9083E-07_JPRB,9.1312E-07_JPRB,8.8335E-07_JPRB,5.7760E-07_JPRB/)
KBO( :, 5,49, 4) = (/&
&2.7502E-07_JPRB,1.0539E-06_JPRB,1.1826E-06_JPRB,1.1000E-06_JPRB,6.6799E-07_JPRB/)
KBO( :, 1,50, 4) = (/&
&2.0584E-08_JPRB,2.1008E-07_JPRB,3.0301E-07_JPRB,4.1495E-07_JPRB,2.9497E-07_JPRB/)
KBO( :, 2,50, 4) = (/&
&3.8348E-08_JPRB,2.9905E-07_JPRB,3.9149E-07_JPRB,4.6171E-07_JPRB,3.3200E-07_JPRB/)
KBO( :, 3,50, 4) = (/&
&6.9001E-08_JPRB,4.2073E-07_JPRB,5.1626E-07_JPRB,5.4677E-07_JPRB,3.8063E-07_JPRB/)
KBO( :, 4,50, 4) = (/&
&1.1783E-07_JPRB,5.7965E-07_JPRB,6.7829E-07_JPRB,6.6887E-07_JPRB,4.3991E-07_JPRB/)
KBO( :, 5,50, 4) = (/&
&1.9076E-07_JPRB,7.7947E-07_JPRB,8.8269E-07_JPRB,8.3154E-07_JPRB,5.0913E-07_JPRB/)
KBO( :, 1,51, 4) = (/&
&1.3493E-08_JPRB,1.5211E-07_JPRB,2.2929E-07_JPRB,3.3385E-07_JPRB,2.3077E-07_JPRB/)
KBO( :, 2,51, 4) = (/&
&2.5122E-08_JPRB,2.1611E-07_JPRB,2.9145E-07_JPRB,3.6106E-07_JPRB,2.5676E-07_JPRB/)
KBO( :, 3,51, 4) = (/&
&4.5978E-08_JPRB,3.0596E-07_JPRB,3.8316E-07_JPRB,4.1984E-07_JPRB,2.9257E-07_JPRB/)
KBO( :, 4,51, 4) = (/&
&8.0110E-08_JPRB,4.2511E-07_JPRB,5.0483E-07_JPRB,5.0877E-07_JPRB,3.3737E-07_JPRB/)
KBO( :, 5,51, 4) = (/&
&1.3215E-07_JPRB,5.7668E-07_JPRB,6.5965E-07_JPRB,6.3029E-07_JPRB,3.9043E-07_JPRB/)
KBO( :, 1,52, 4) = (/&
&8.9230E-09_JPRB,1.1071E-07_JPRB,1.7523E-07_JPRB,2.7190E-07_JPRB,1.8118E-07_JPRB/)
KBO( :, 2,52, 4) = (/&
&1.6411E-08_JPRB,1.5606E-07_JPRB,2.1785E-07_JPRB,2.8505E-07_JPRB,1.9923E-07_JPRB/)
KBO( :, 3,52, 4) = (/&
&3.0439E-08_JPRB,2.2195E-07_JPRB,2.8438E-07_JPRB,3.2394E-07_JPRB,2.2485E-07_JPRB/)
KBO( :, 4,52, 4) = (/&
&5.4073E-08_JPRB,3.1080E-07_JPRB,3.7535E-07_JPRB,3.8813E-07_JPRB,2.5827E-07_JPRB/)
KBO( :, 5,52, 4) = (/&
&9.0961E-08_JPRB,4.2534E-07_JPRB,4.9215E-07_JPRB,4.7800E-07_JPRB,2.9864E-07_JPRB/)
KBO( :, 1,53, 4) = (/&
&5.9876E-09_JPRB,8.1201E-08_JPRB,1.3536E-07_JPRB,2.2434E-07_JPRB,1.4306E-07_JPRB/)
KBO( :, 2,53, 4) = (/&
&1.0717E-08_JPRB,1.1272E-07_JPRB,1.6383E-07_JPRB,2.2748E-07_JPRB,1.5495E-07_JPRB/)
KBO( :, 3,53, 4) = (/&
&2.0015E-08_JPRB,1.6060E-07_JPRB,2.1125E-07_JPRB,2.5162E-07_JPRB,1.7284E-07_JPRB/)
KBO( :, 4,53, 4) = (/&
&3.6209E-08_JPRB,2.2643E-07_JPRB,2.7869E-07_JPRB,2.9706E-07_JPRB,1.9723E-07_JPRB/)
KBO( :, 5,53, 4) = (/&
&6.2161E-08_JPRB,3.1263E-07_JPRB,3.6655E-07_JPRB,3.6292E-07_JPRB,2.2770E-07_JPRB/)
KBO( :, 1,54, 4) = (/&
&4.1655E-09_JPRB,6.0699E-08_JPRB,1.0631E-07_JPRB,1.8695E-07_JPRB,1.1504E-07_JPRB/)
KBO( :, 2,54, 4) = (/&
&7.1662E-09_JPRB,8.2506E-08_JPRB,1.2498E-07_JPRB,1.8360E-07_JPRB,1.2311E-07_JPRB/)
KBO( :, 3,54, 4) = (/&
&1.3353E-08_JPRB,1.1732E-07_JPRB,1.5863E-07_JPRB,1.9781E-07_JPRB,1.3609E-07_JPRB/)
KBO( :, 4,54, 4) = (/&
&2.4527E-08_JPRB,1.6632E-07_JPRB,2.0860E-07_JPRB,2.2954E-07_JPRB,1.5431E-07_JPRB/)
KBO( :, 5,54, 4) = (/&
&4.2883E-08_JPRB,2.3139E-07_JPRB,2.7507E-07_JPRB,2.7789E-07_JPRB,1.7766E-07_JPRB/)
KBO( :, 1,55, 4) = (/&
&2.9815E-09_JPRB,4.5994E-08_JPRB,8.4525E-08_JPRB,1.5735E-07_JPRB,9.3462E-08_JPRB/)
KBO( :, 2,55, 4) = (/&
&4.8723E-09_JPRB,6.0940E-08_JPRB,9.6391E-08_JPRB,1.4974E-07_JPRB,9.9006E-08_JPRB/)
KBO( :, 3,55, 4) = (/&
&8.9683E-09_JPRB,8.6061E-08_JPRB,1.1996E-07_JPRB,1.5698E-07_JPRB,1.0869E-07_JPRB/)
KBO( :, 4,55, 4) = (/&
&1.6661E-08_JPRB,1.2249E-07_JPRB,1.5677E-07_JPRB,1.7852E-07_JPRB,1.2250E-07_JPRB/)
KBO( :, 5,55, 4) = (/&
&2.9629E-08_JPRB,1.7161E-07_JPRB,2.0705E-07_JPRB,2.1394E-07_JPRB,1.4060E-07_JPRB/)
KBO( :, 1,56, 4) = (/&
&2.1861E-09_JPRB,3.5243E-08_JPRB,6.7842E-08_JPRB,1.3338E-07_JPRB,7.6071E-08_JPRB/)
KBO( :, 2,56, 4) = (/&
&3.3518E-09_JPRB,4.5292E-08_JPRB,7.4962E-08_JPRB,1.2335E-07_JPRB,7.9965E-08_JPRB/)
KBO( :, 3,56, 4) = (/&
&6.0272E-09_JPRB,6.3165E-08_JPRB,9.1168E-08_JPRB,1.2562E-07_JPRB,8.7021E-08_JPRB/)
KBO( :, 4,56, 4) = (/&
&1.1269E-08_JPRB,9.0068E-08_JPRB,1.1792E-07_JPRB,1.3956E-07_JPRB,9.7479E-08_JPRB/)
KBO( :, 5,56, 4) = (/&
&2.0362E-08_JPRB,1.2698E-07_JPRB,1.5571E-07_JPRB,1.6515E-07_JPRB,1.1148E-07_JPRB/)
KBO( :, 1,57, 4) = (/&
&1.6409E-09_JPRB,2.7386E-08_JPRB,5.4848E-08_JPRB,1.1388E-07_JPRB,6.2033E-08_JPRB/)
KBO( :, 2,57, 4) = (/&
&2.3428E-09_JPRB,3.3930E-08_JPRB,5.8875E-08_JPRB,1.0251E-07_JPRB,6.4870E-08_JPRB/)
KBO( :, 3,57, 4) = (/&
&4.0625E-09_JPRB,4.6423E-08_JPRB,6.9674E-08_JPRB,1.0133E-07_JPRB,6.9866E-08_JPRB/)
KBO( :, 4,57, 4) = (/&
&7.5880E-09_JPRB,6.6138E-08_JPRB,8.8862E-08_JPRB,1.0977E-07_JPRB,7.7746E-08_JPRB/)
KBO( :, 5,57, 4) = (/&
&1.3915E-08_JPRB,9.3738E-08_JPRB,1.1702E-07_JPRB,1.2786E-07_JPRB,8.8586E-08_JPRB/)
KBO( :, 1,58, 4) = (/&
&1.2635E-09_JPRB,2.1604E-08_JPRB,4.4731E-08_JPRB,9.7552E-08_JPRB,5.0828E-08_JPRB/)
KBO( :, 2,58, 4) = (/&
&1.6814E-09_JPRB,2.5762E-08_JPRB,4.6786E-08_JPRB,8.5976E-08_JPRB,5.2911E-08_JPRB/)
KBO( :, 3,58, 4) = (/&
&2.7835E-09_JPRB,3.4427E-08_JPRB,5.3815E-08_JPRB,8.2469E-08_JPRB,5.6515E-08_JPRB/)
KBO( :, 4,58, 4) = (/&
&5.1497E-09_JPRB,4.8806E-08_JPRB,6.7425E-08_JPRB,8.7085E-08_JPRB,6.2504E-08_JPRB/)
KBO( :, 5,58, 4) = (/&
&9.5533E-09_JPRB,6.9446E-08_JPRB,8.8336E-08_JPRB,9.9625E-08_JPRB,7.0988E-08_JPRB/)
KBO( :, 1,59, 4) = (/&
&1.0158E-09_JPRB,1.7490E-08_JPRB,3.6651E-08_JPRB,8.1330E-08_JPRB,4.2750E-08_JPRB/)
KBO( :, 2,59, 4) = (/&
&1.3161E-09_JPRB,2.0543E-08_JPRB,3.7942E-08_JPRB,7.1098E-08_JPRB,4.4506E-08_JPRB/)
KBO( :, 3,59, 4) = (/&
&2.1325E-09_JPRB,2.7191E-08_JPRB,4.3180E-08_JPRB,6.7506E-08_JPRB,4.7664E-08_JPRB/)
KBO( :, 4,59, 4) = (/&
&3.9206E-09_JPRB,3.8435E-08_JPRB,5.3711E-08_JPRB,7.0587E-08_JPRB,5.2961E-08_JPRB/)
KBO( :, 5,59, 4) = (/&
&7.2991E-09_JPRB,5.4760E-08_JPRB,7.0199E-08_JPRB,8.0158E-08_JPRB,6.0356E-08_JPRB/)
KBO( :, 1,13, 5) = (/&
&4.7279E-04_JPRB,8.7098E-04_JPRB,9.0543E-04_JPRB,9.3823E-04_JPRB,7.8919E-03_JPRB/)
KBO( :, 2,13, 5) = (/&
&6.4177E-04_JPRB,1.1728E-03_JPRB,1.1865E-03_JPRB,1.1108E-03_JPRB,8.6809E-03_JPRB/)
KBO( :, 3,13, 5) = (/&
&8.7771E-04_JPRB,1.5520E-03_JPRB,1.5457E-03_JPRB,1.3624E-03_JPRB,9.6358E-03_JPRB/)
KBO( :, 4,13, 5) = (/&
&1.1913E-03_JPRB,2.0247E-03_JPRB,1.9864E-03_JPRB,1.6883E-03_JPRB,1.0697E-02_JPRB/)
KBO( :, 5,13, 5) = (/&
&1.5849E-03_JPRB,2.6087E-03_JPRB,2.5214E-03_JPRB,2.0902E-03_JPRB,1.1832E-02_JPRB/)
KBO( :, 1,14, 5) = (/&
&3.9797E-04_JPRB,7.4264E-04_JPRB,7.7131E-04_JPRB,7.8917E-04_JPRB,6.3875E-03_JPRB/)
KBO( :, 2,14, 5) = (/&
&5.4883E-04_JPRB,1.0041E-03_JPRB,1.0164E-03_JPRB,9.4462E-04_JPRB,7.1228E-03_JPRB/)
KBO( :, 3,14, 5) = (/&
&7.5764E-04_JPRB,1.3360E-03_JPRB,1.3281E-03_JPRB,1.1660E-03_JPRB,7.9451E-03_JPRB/)
KBO( :, 4,14, 5) = (/&
&1.0318E-03_JPRB,1.7525E-03_JPRB,1.7145E-03_JPRB,1.4506E-03_JPRB,8.8337E-03_JPRB/)
KBO( :, 5,14, 5) = (/&
&1.3764E-03_JPRB,2.2658E-03_JPRB,2.1860E-03_JPRB,1.8014E-03_JPRB,9.7391E-03_JPRB/)
KBO( :, 1,15, 5) = (/&
&3.3164E-04_JPRB,6.3085E-04_JPRB,6.5753E-04_JPRB,6.6377E-04_JPRB,4.8736E-03_JPRB/)
KBO( :, 2,15, 5) = (/&
&4.6431E-04_JPRB,8.5791E-04_JPRB,8.7041E-04_JPRB,8.0246E-04_JPRB,5.4864E-03_JPRB/)
KBO( :, 3,15, 5) = (/&
&6.4635E-04_JPRB,1.1477E-03_JPRB,1.1413E-03_JPRB,9.9664E-04_JPRB,6.1519E-03_JPRB/)
KBO( :, 4,15, 5) = (/&
&8.8542E-04_JPRB,1.5118E-03_JPRB,1.4797E-03_JPRB,1.2450E-03_JPRB,6.8384E-03_JPRB/)
KBO( :, 5,15, 5) = (/&
&1.1860E-03_JPRB,1.9607E-03_JPRB,1.8917E-03_JPRB,1.5514E-03_JPRB,7.5330E-03_JPRB/)
KBO( :, 1,16, 5) = (/&
&2.7547E-04_JPRB,5.3540E-04_JPRB,5.5986E-04_JPRB,5.5850E-04_JPRB,3.5571E-03_JPRB/)
KBO( :, 2,16, 5) = (/&
&3.9076E-04_JPRB,7.3210E-04_JPRB,7.4449E-04_JPRB,6.8182E-04_JPRB,4.0376E-03_JPRB/)
KBO( :, 3,16, 5) = (/&
&5.4914E-04_JPRB,9.8388E-04_JPRB,9.7975E-04_JPRB,8.5148E-04_JPRB,4.5400E-03_JPRB/)
KBO( :, 4,16, 5) = (/&
&7.5647E-04_JPRB,1.3013E-03_JPRB,1.2750E-03_JPRB,1.0673E-03_JPRB,5.0491E-03_JPRB/)
KBO( :, 5,16, 5) = (/&
&1.0168E-03_JPRB,1.6894E-03_JPRB,1.6327E-03_JPRB,1.3347E-03_JPRB,5.5864E-03_JPRB/)
KBO( :, 1,17, 5) = (/&
&2.3152E-04_JPRB,4.5640E-04_JPRB,4.7753E-04_JPRB,4.7152E-04_JPRB,2.6479E-03_JPRB/)
KBO( :, 2,17, 5) = (/&
&3.3215E-04_JPRB,6.2600E-04_JPRB,6.3690E-04_JPRB,5.8069E-04_JPRB,3.0163E-03_JPRB/)
KBO( :, 3,17, 5) = (/&
&4.6960E-04_JPRB,8.4466E-04_JPRB,8.4113E-04_JPRB,7.2795E-04_JPRB,3.3924E-03_JPRB/)
KBO( :, 4,17, 5) = (/&
&6.4890E-04_JPRB,1.1190E-03_JPRB,1.0981E-03_JPRB,9.1560E-04_JPRB,3.7876E-03_JPRB/)
KBO( :, 5,17, 5) = (/&
&8.7357E-04_JPRB,1.4542E-03_JPRB,1.4067E-03_JPRB,1.1490E-03_JPRB,4.2015E-03_JPRB/)
KBO( :, 1,18, 5) = (/&
&1.9932E-04_JPRB,3.9153E-04_JPRB,4.0894E-04_JPRB,3.9983E-04_JPRB,2.0392E-03_JPRB/)
KBO( :, 2,18, 5) = (/&
&2.8740E-04_JPRB,5.3802E-04_JPRB,5.4670E-04_JPRB,4.9548E-04_JPRB,2.3218E-03_JPRB/)
KBO( :, 3,18, 5) = (/&
&4.0688E-04_JPRB,7.2769E-04_JPRB,7.2473E-04_JPRB,6.2367E-04_JPRB,2.6171E-03_JPRB/)
KBO( :, 4,18, 5) = (/&
&5.6212E-04_JPRB,9.6442E-04_JPRB,9.4622E-04_JPRB,7.8767E-04_JPRB,2.9286E-03_JPRB/)
KBO( :, 5,18, 5) = (/&
&7.5657E-04_JPRB,1.2523E-03_JPRB,1.2126E-03_JPRB,9.8987E-04_JPRB,3.2584E-03_JPRB/)
KBO( :, 1,19, 5) = (/&
&1.7300E-04_JPRB,3.3615E-04_JPRB,3.5010E-04_JPRB,3.3920E-04_JPRB,1.6249E-03_JPRB/)
KBO( :, 2,19, 5) = (/&
&2.4990E-04_JPRB,4.6314E-04_JPRB,4.6930E-04_JPRB,4.2253E-04_JPRB,1.8509E-03_JPRB/)
KBO( :, 3,19, 5) = (/&
&3.5374E-04_JPRB,6.2681E-04_JPRB,6.2354E-04_JPRB,5.3462E-04_JPRB,2.0903E-03_JPRB/)
KBO( :, 4,19, 5) = (/&
&4.8808E-04_JPRB,8.3000E-04_JPRB,8.1368E-04_JPRB,6.7693E-04_JPRB,2.3442E-03_JPRB/)
KBO( :, 5,19, 5) = (/&
&6.5622E-04_JPRB,1.0763E-03_JPRB,1.0415E-03_JPRB,8.5100E-04_JPRB,2.6149E-03_JPRB/)
KBO( :, 1,20, 5) = (/&
&1.5202E-04_JPRB,2.9089E-04_JPRB,3.0118E-04_JPRB,2.8847E-04_JPRB,1.3195E-03_JPRB/)
KBO( :, 2,20, 5) = (/&
&2.1947E-04_JPRB,4.0137E-04_JPRB,4.0488E-04_JPRB,3.6160E-04_JPRB,1.5051E-03_JPRB/)
KBO( :, 3,20, 5) = (/&
&3.1005E-04_JPRB,5.4229E-04_JPRB,5.3773E-04_JPRB,4.5934E-04_JPRB,1.7011E-03_JPRB/)
KBO( :, 4,20, 5) = (/&
&4.2687E-04_JPRB,7.1641E-04_JPRB,7.0062E-04_JPRB,5.8213E-04_JPRB,1.9126E-03_JPRB/)
KBO( :, 5,20, 5) = (/&
&5.7243E-04_JPRB,9.2825E-04_JPRB,8.9565E-04_JPRB,7.3135E-04_JPRB,2.1352E-03_JPRB/)
KBO( :, 1,21, 5) = (/&
&1.3342E-04_JPRB,2.5207E-04_JPRB,2.5927E-04_JPRB,2.4529E-04_JPRB,1.0741E-03_JPRB/)
KBO( :, 2,21, 5) = (/&
&1.9233E-04_JPRB,3.4753E-04_JPRB,3.4906E-04_JPRB,3.0934E-04_JPRB,1.2262E-03_JPRB/)
KBO( :, 3,21, 5) = (/&
&2.7108E-04_JPRB,4.6836E-04_JPRB,4.6295E-04_JPRB,3.9387E-04_JPRB,1.3885E-03_JPRB/)
KBO( :, 4,21, 5) = (/&
&3.7228E-04_JPRB,6.1777E-04_JPRB,6.0200E-04_JPRB,4.9887E-04_JPRB,1.5626E-03_JPRB/)
KBO( :, 5,21, 5) = (/&
&4.9911E-04_JPRB,7.9951E-04_JPRB,7.6864E-04_JPRB,6.2637E-04_JPRB,1.7443E-03_JPRB/)
KBO( :, 1,22, 5) = (/&
&1.1876E-04_JPRB,2.2232E-04_JPRB,2.2723E-04_JPRB,2.1144E-04_JPRB,8.6475E-04_JPRB/)
KBO( :, 2,22, 5) = (/&
&1.7098E-04_JPRB,3.0547E-04_JPRB,3.0556E-04_JPRB,2.6827E-04_JPRB,9.8817E-04_JPRB/)
KBO( :, 3,22, 5) = (/&
&2.4024E-04_JPRB,4.1043E-04_JPRB,4.0412E-04_JPRB,3.4171E-04_JPRB,1.1213E-03_JPRB/)
KBO( :, 4,22, 5) = (/&
&3.2954E-04_JPRB,5.4028E-04_JPRB,5.2414E-04_JPRB,4.3238E-04_JPRB,1.2619E-03_JPRB/)
KBO( :, 5,22, 5) = (/&
&4.4187E-04_JPRB,6.9761E-04_JPRB,6.6809E-04_JPRB,5.4249E-04_JPRB,1.4080E-03_JPRB/)
KBO( :, 1,23, 5) = (/&
&1.0533E-04_JPRB,1.9573E-04_JPRB,1.9910E-04_JPRB,1.8269E-04_JPRB,6.9257E-04_JPRB/)
KBO( :, 2,23, 5) = (/&
&1.5155E-04_JPRB,2.6816E-04_JPRB,2.6720E-04_JPRB,2.3262E-04_JPRB,7.9308E-04_JPRB/)
KBO( :, 3,23, 5) = (/&
&2.1274E-04_JPRB,3.5921E-04_JPRB,3.5244E-04_JPRB,2.9616E-04_JPRB,9.0068E-04_JPRB/)
KBO( :, 4,23, 5) = (/&
&2.9190E-04_JPRB,4.7191E-04_JPRB,4.5593E-04_JPRB,3.7445E-04_JPRB,1.0136E-03_JPRB/)
KBO( :, 5,23, 5) = (/&
&3.9138E-04_JPRB,6.0878E-04_JPRB,5.8059E-04_JPRB,4.6968E-04_JPRB,1.1306E-03_JPRB/)
KBO( :, 1,24, 5) = (/&
&9.2582E-05_JPRB,1.7167E-04_JPRB,1.7398E-04_JPRB,1.5781E-04_JPRB,5.4677E-04_JPRB/)
KBO( :, 2,24, 5) = (/&
&1.3344E-04_JPRB,2.3456E-04_JPRB,2.3315E-04_JPRB,2.0139E-04_JPRB,6.2782E-04_JPRB/)
KBO( :, 3,24, 5) = (/&
&1.8769E-04_JPRB,3.1365E-04_JPRB,3.0670E-04_JPRB,2.5637E-04_JPRB,7.1420E-04_JPRB/)
KBO( :, 4,24, 5) = (/&
&2.5773E-04_JPRB,4.1174E-04_JPRB,3.9630E-04_JPRB,3.2402E-04_JPRB,8.0431E-04_JPRB/)
KBO( :, 5,24, 5) = (/&
&3.4549E-04_JPRB,5.3124E-04_JPRB,5.0449E-04_JPRB,4.0653E-04_JPRB,8.9759E-04_JPRB/)
KBO( :, 1,25, 5) = (/&
&8.1720E-05_JPRB,1.5080E-04_JPRB,1.5235E-04_JPRB,1.3662E-04_JPRB,4.3240E-04_JPRB/)
KBO( :, 2,25, 5) = (/&
&1.1805E-04_JPRB,2.0558E-04_JPRB,2.0367E-04_JPRB,1.7460E-04_JPRB,4.9748E-04_JPRB/)
KBO( :, 3,25, 5) = (/&
&1.6632E-04_JPRB,2.7459E-04_JPRB,2.6746E-04_JPRB,2.2227E-04_JPRB,5.6662E-04_JPRB/)
KBO( :, 4,25, 5) = (/&
&2.2820E-04_JPRB,3.6032E-04_JPRB,3.4539E-04_JPRB,2.8107E-04_JPRB,6.3853E-04_JPRB/)
KBO( :, 5,25, 5) = (/&
&3.0509E-04_JPRB,4.6497E-04_JPRB,4.3993E-04_JPRB,3.5289E-04_JPRB,7.1328E-04_JPRB/)
KBO( :, 1,26, 5) = (/&
&7.3023E-05_JPRB,1.3337E-04_JPRB,1.3413E-04_JPRB,1.1892E-04_JPRB,3.4584E-04_JPRB/)
KBO( :, 2,26, 5) = (/&
&1.0560E-04_JPRB,1.8141E-04_JPRB,1.7894E-04_JPRB,1.5213E-04_JPRB,3.9839E-04_JPRB/)
KBO( :, 3,26, 5) = (/&
&1.4861E-04_JPRB,2.4208E-04_JPRB,2.3462E-04_JPRB,1.9371E-04_JPRB,4.5384E-04_JPRB/)
KBO( :, 4,26, 5) = (/&
&2.0313E-04_JPRB,3.1741E-04_JPRB,3.0291E-04_JPRB,2.4516E-04_JPRB,5.1150E-04_JPRB/)
KBO( :, 5,26, 5) = (/&
&2.7025E-04_JPRB,4.0891E-04_JPRB,3.8585E-04_JPRB,3.0810E-04_JPRB,5.7158E-04_JPRB/)
KBO( :, 1,27, 5) = (/&
&6.5244E-05_JPRB,1.1779E-04_JPRB,1.1796E-04_JPRB,1.0347E-04_JPRB,2.7274E-04_JPRB/)
KBO( :, 2,27, 5) = (/&
&9.4317E-05_JPRB,1.6003E-04_JPRB,1.5711E-04_JPRB,1.3251E-04_JPRB,3.1462E-04_JPRB/)
KBO( :, 3,27, 5) = (/&
&1.3235E-04_JPRB,2.1338E-04_JPRB,2.0578E-04_JPRB,1.6888E-04_JPRB,3.5874E-04_JPRB/)
KBO( :, 4,27, 5) = (/&
&1.7994E-04_JPRB,2.7923E-04_JPRB,2.6567E-04_JPRB,2.1397E-04_JPRB,4.0423E-04_JPRB/)
KBO( :, 5,27, 5) = (/&
&2.3815E-04_JPRB,3.5878E-04_JPRB,3.3808E-04_JPRB,2.6908E-04_JPRB,4.5194E-04_JPRB/)
KBO( :, 1,28, 5) = (/&
&5.8135E-05_JPRB,1.0393E-04_JPRB,1.0358E-04_JPRB,8.9974E-05_JPRB,2.1186E-04_JPRB/)
KBO( :, 2,28, 5) = (/&
&8.3922E-05_JPRB,1.4106E-04_JPRB,1.3783E-04_JPRB,1.1539E-04_JPRB,2.4486E-04_JPRB/)
KBO( :, 3,28, 5) = (/&
&1.1719E-04_JPRB,1.8771E-04_JPRB,1.8042E-04_JPRB,1.4725E-04_JPRB,2.7921E-04_JPRB/)
KBO( :, 4,28, 5) = (/&
&1.5846E-04_JPRB,2.4498E-04_JPRB,2.3269E-04_JPRB,1.8682E-04_JPRB,3.1493E-04_JPRB/)
KBO( :, 5,28, 5) = (/&
&2.0834E-04_JPRB,3.1383E-04_JPRB,2.9568E-04_JPRB,2.3488E-04_JPRB,3.5235E-04_JPRB/)
KBO( :, 1,29, 5) = (/&
&5.2156E-05_JPRB,9.2110E-05_JPRB,9.1288E-05_JPRB,7.8487E-05_JPRB,1.6379E-04_JPRB/)
KBO( :, 2,29, 5) = (/&
&7.4907E-05_JPRB,1.2474E-04_JPRB,1.2134E-04_JPRB,1.0081E-04_JPRB,1.8924E-04_JPRB/)
KBO( :, 3,29, 5) = (/&
&1.0389E-04_JPRB,1.6543E-04_JPRB,1.5862E-04_JPRB,1.2884E-04_JPRB,2.1564E-04_JPRB/)
KBO( :, 4,29, 5) = (/&
&1.3949E-04_JPRB,2.1507E-04_JPRB,2.0416E-04_JPRB,1.6349E-04_JPRB,2.4336E-04_JPRB/)
KBO( :, 5,29, 5) = (/&
&1.8193E-04_JPRB,2.7457E-04_JPRB,2.5880E-04_JPRB,2.0529E-04_JPRB,2.7230E-04_JPRB/)
KBO( :, 1,30, 5) = (/&
&4.6665E-05_JPRB,8.1578E-05_JPRB,8.0475E-05_JPRB,6.8545E-05_JPRB,1.2523E-04_JPRB/)
KBO( :, 2,30, 5) = (/&
&6.6590E-05_JPRB,1.1011E-04_JPRB,1.0677E-04_JPRB,8.8175E-05_JPRB,1.4448E-04_JPRB/)
KBO( :, 3,30, 5) = (/&
&9.1666E-05_JPRB,1.4544E-04_JPRB,1.3932E-04_JPRB,1.1280E-04_JPRB,1.6467E-04_JPRB/)
KBO( :, 4,30, 5) = (/&
&1.2214E-04_JPRB,1.8830E-04_JPRB,1.7882E-04_JPRB,1.4301E-04_JPRB,1.8584E-04_JPRB/)
KBO( :, 5,30, 5) = (/&
&1.5808E-04_JPRB,2.3937E-04_JPRB,2.2601E-04_JPRB,1.7927E-04_JPRB,2.0804E-04_JPRB/)
KBO( :, 1,31, 5) = (/&
&4.1774E-05_JPRB,7.2293E-05_JPRB,7.1044E-05_JPRB,6.0014E-05_JPRB,9.4404E-05_JPRB/)
KBO( :, 2,31, 5) = (/&
&5.9153E-05_JPRB,9.7142E-05_JPRB,9.4034E-05_JPRB,7.7303E-05_JPRB,1.0876E-04_JPRB/)
KBO( :, 3,31, 5) = (/&
&8.0749E-05_JPRB,1.2773E-04_JPRB,1.2231E-04_JPRB,9.8861E-05_JPRB,1.2383E-04_JPRB/)
KBO( :, 4,31, 5) = (/&
&1.0665E-04_JPRB,1.6459E-04_JPRB,1.5646E-04_JPRB,1.2511E-04_JPRB,1.3969E-04_JPRB/)
KBO( :, 5,31, 5) = (/&
&1.3708E-04_JPRB,2.0815E-04_JPRB,1.9687E-04_JPRB,1.5634E-04_JPRB,1.5670E-04_JPRB/)
KBO( :, 1,32, 5) = (/&
&3.7360E-05_JPRB,6.4042E-05_JPRB,6.2763E-05_JPRB,5.2674E-05_JPRB,7.1295E-05_JPRB/)
KBO( :, 2,32, 5) = (/&
&5.2458E-05_JPRB,8.5627E-05_JPRB,8.2786E-05_JPRB,6.7846E-05_JPRB,8.1990E-05_JPRB/)
KBO( :, 3,32, 5) = (/&
&7.0948E-05_JPRB,1.1205E-04_JPRB,1.0732E-04_JPRB,8.6659E-05_JPRB,9.3329E-05_JPRB/)
KBO( :, 4,32, 5) = (/&
&9.2912E-05_JPRB,1.4361E-04_JPRB,1.3667E-04_JPRB,1.0937E-04_JPRB,1.0550E-04_JPRB/)
KBO( :, 5,32, 5) = (/&
&1.1872E-04_JPRB,1.8058E-04_JPRB,1.7108E-04_JPRB,1.3607E-04_JPRB,1.1861E-04_JPRB/)
KBO( :, 1,33, 5) = (/&
&3.3330E-05_JPRB,5.6651E-05_JPRB,5.5404E-05_JPRB,4.6257E-05_JPRB,5.3603E-05_JPRB/)
KBO( :, 2,33, 5) = (/&
&4.6366E-05_JPRB,7.5365E-05_JPRB,7.2815E-05_JPRB,5.9541E-05_JPRB,6.1709E-05_JPRB/)
KBO( :, 3,33, 5) = (/&
&6.2117E-05_JPRB,9.8064E-05_JPRB,9.4002E-05_JPRB,7.5880E-05_JPRB,7.0404E-05_JPRB/)
KBO( :, 4,33, 5) = (/&
&8.0785E-05_JPRB,1.2503E-04_JPRB,1.1911E-04_JPRB,9.5440E-05_JPRB,7.9842E-05_JPRB/)
KBO( :, 5,33, 5) = (/&
&1.0266E-04_JPRB,1.5642E-04_JPRB,1.4831E-04_JPRB,1.1813E-04_JPRB,8.9956E-05_JPRB/)
KBO( :, 1,34, 5) = (/&
&2.9453E-05_JPRB,4.9674E-05_JPRB,4.8494E-05_JPRB,4.0330E-05_JPRB,4.1449E-05_JPRB/)
KBO( :, 2,34, 5) = (/&
&4.0587E-05_JPRB,6.5763E-05_JPRB,6.3519E-05_JPRB,5.1852E-05_JPRB,4.7772E-05_JPRB/)
KBO( :, 3,34, 5) = (/&
&5.3941E-05_JPRB,8.5109E-05_JPRB,8.1613E-05_JPRB,6.5908E-05_JPRB,5.4645E-05_JPRB/)
KBO( :, 4,34, 5) = (/&
&6.9742E-05_JPRB,1.0800E-04_JPRB,1.0292E-04_JPRB,8.2540E-05_JPRB,6.2110E-05_JPRB/)
KBO( :, 5,34, 5) = (/&
&8.8248E-05_JPRB,1.3461E-04_JPRB,1.2764E-04_JPRB,1.0173E-04_JPRB,7.0115E-05_JPRB/)
KBO( :, 1,35, 5) = (/&
&2.5087E-05_JPRB,4.2259E-05_JPRB,4.1255E-05_JPRB,3.4275E-05_JPRB,3.1533E-05_JPRB/)
KBO( :, 2,35, 5) = (/&
&3.4377E-05_JPRB,5.5779E-05_JPRB,5.3928E-05_JPRB,4.4037E-05_JPRB,3.6467E-05_JPRB/)
KBO( :, 3,35, 5) = (/&
&4.5509E-05_JPRB,7.1962E-05_JPRB,6.9073E-05_JPRB,5.5855E-05_JPRB,4.1858E-05_JPRB/)
KBO( :, 4,35, 5) = (/&
&5.8672E-05_JPRB,9.1085E-05_JPRB,8.6867E-05_JPRB,6.9736E-05_JPRB,4.7718E-05_JPRB/)
KBO( :, 5,35, 5) = (/&
&7.4086E-05_JPRB,1.1331E-04_JPRB,1.0750E-04_JPRB,8.5753E-05_JPRB,5.3964E-05_JPRB/)
KBO( :, 1,36, 5) = (/&
&2.0525E-05_JPRB,3.4767E-05_JPRB,3.4001E-05_JPRB,2.8297E-05_JPRB,2.3548E-05_JPRB/)
KBO( :, 2,36, 5) = (/&
&2.8104E-05_JPRB,4.5872E-05_JPRB,4.4441E-05_JPRB,3.6357E-05_JPRB,2.7355E-05_JPRB/)
KBO( :, 3,36, 5) = (/&
&3.7199E-05_JPRB,5.9142E-05_JPRB,5.6864E-05_JPRB,4.6074E-05_JPRB,3.1516E-05_JPRB/)
KBO( :, 4,36, 5) = (/&
&4.7973E-05_JPRB,7.4842E-05_JPRB,7.1480E-05_JPRB,5.7473E-05_JPRB,3.6056E-05_JPRB/)
KBO( :, 5,36, 5) = (/&
&6.0589E-05_JPRB,9.3078E-05_JPRB,8.8416E-05_JPRB,7.0645E-05_JPRB,4.0905E-05_JPRB/)
KBO( :, 1,37, 5) = (/&
&1.6118E-05_JPRB,2.7523E-05_JPRB,2.6979E-05_JPRB,2.2543E-05_JPRB,1.8010E-05_JPRB/)
KBO( :, 2,37, 5) = (/&
&2.2165E-05_JPRB,3.6407E-05_JPRB,3.5348E-05_JPRB,2.9008E-05_JPRB,2.0983E-05_JPRB/)
KBO( :, 3,37, 5) = (/&
&2.9444E-05_JPRB,4.7055E-05_JPRB,4.5326E-05_JPRB,3.6808E-05_JPRB,2.4249E-05_JPRB/)
KBO( :, 4,37, 5) = (/&
&3.8081E-05_JPRB,5.9681E-05_JPRB,5.7081E-05_JPRB,4.5982E-05_JPRB,2.7813E-05_JPRB/)
KBO( :, 5,37, 5) = (/&
&4.8212E-05_JPRB,7.4374E-05_JPRB,7.0740E-05_JPRB,5.6602E-05_JPRB,3.1635E-05_JPRB/)
KBO( :, 1,38, 5) = (/&
&1.2610E-05_JPRB,2.1718E-05_JPRB,2.1343E-05_JPRB,1.7908E-05_JPRB,1.3720E-05_JPRB/)
KBO( :, 2,38, 5) = (/&
&1.7424E-05_JPRB,2.8812E-05_JPRB,2.8034E-05_JPRB,2.3079E-05_JPRB,1.6034E-05_JPRB/)
KBO( :, 3,38, 5) = (/&
&2.3240E-05_JPRB,3.7339E-05_JPRB,3.6033E-05_JPRB,2.9331E-05_JPRB,1.8589E-05_JPRB/)
KBO( :, 4,38, 5) = (/&
&3.0149E-05_JPRB,4.7476E-05_JPRB,4.5479E-05_JPRB,3.6700E-05_JPRB,2.1382E-05_JPRB/)
KBO( :, 5,38, 5) = (/&
&3.8276E-05_JPRB,5.9294E-05_JPRB,5.6476E-05_JPRB,4.5256E-05_JPRB,2.4387E-05_JPRB/)
KBO( :, 1,39, 5) = (/&
&9.8494E-06_JPRB,1.7119E-05_JPRB,1.6865E-05_JPRB,1.4215E-05_JPRB,1.0374E-05_JPRB/)
KBO( :, 2,39, 5) = (/&
&1.3680E-05_JPRB,2.2781E-05_JPRB,2.2215E-05_JPRB,1.8350E-05_JPRB,1.2167E-05_JPRB/)
KBO( :, 3,39, 5) = (/&
&1.8324E-05_JPRB,2.9603E-05_JPRB,2.8623E-05_JPRB,2.3356E-05_JPRB,1.4153E-05_JPRB/)
KBO( :, 4,39, 5) = (/&
&2.3849E-05_JPRB,3.7739E-05_JPRB,3.6208E-05_JPRB,2.9278E-05_JPRB,1.6336E-05_JPRB/)
KBO( :, 5,39, 5) = (/&
&3.0362E-05_JPRB,4.7240E-05_JPRB,4.5057E-05_JPRB,3.6164E-05_JPRB,1.8690E-05_JPRB/)
KBO( :, 1,40, 5) = (/&
&7.4339E-06_JPRB,1.3096E-05_JPRB,1.2949E-05_JPRB,1.0994E-05_JPRB,7.9222E-06_JPRB/)
KBO( :, 2,40, 5) = (/&
&1.0423E-05_JPRB,1.7529E-05_JPRB,1.7143E-05_JPRB,1.4230E-05_JPRB,9.3215E-06_JPRB/)
KBO( :, 3,40, 5) = (/&
&1.4064E-05_JPRB,2.2897E-05_JPRB,2.2194E-05_JPRB,1.8169E-05_JPRB,1.0878E-05_JPRB/)
KBO( :, 4,40, 5) = (/&
&1.8421E-05_JPRB,2.9319E-05_JPRB,2.8191E-05_JPRB,2.2850E-05_JPRB,1.2595E-05_JPRB/)
KBO( :, 5,40, 5) = (/&
&2.3560E-05_JPRB,3.6849E-05_JPRB,3.5209E-05_JPRB,2.8311E-05_JPRB,1.4456E-05_JPRB/)
KBO( :, 1,41, 5) = (/&
&5.5704E-06_JPRB,9.9619E-06_JPRB,9.8891E-06_JPRB,8.4654E-06_JPRB,6.0394E-06_JPRB/)
KBO( :, 2,41, 5) = (/&
&7.8899E-06_JPRB,1.3424E-05_JPRB,1.3166E-05_JPRB,1.0990E-05_JPRB,7.1317E-06_JPRB/)
KBO( :, 3,41, 5) = (/&
&1.0739E-05_JPRB,1.7632E-05_JPRB,1.7133E-05_JPRB,1.4077E-05_JPRB,8.3487E-06_JPRB/)
KBO( :, 4,41, 5) = (/&
&1.4162E-05_JPRB,2.2683E-05_JPRB,2.1860E-05_JPRB,1.7767E-05_JPRB,9.6986E-06_JPRB/)
KBO( :, 5,41, 5) = (/&
&1.8206E-05_JPRB,2.8635E-05_JPRB,2.7414E-05_JPRB,2.2091E-05_JPRB,1.1170E-05_JPRB/)
KBO( :, 1,42, 5) = (/&
&4.1581E-06_JPRB,7.5591E-06_JPRB,7.5361E-06_JPRB,6.5108E-06_JPRB,4.5852E-06_JPRB/)
KBO( :, 2,42, 5) = (/&
&5.9538E-06_JPRB,1.0259E-05_JPRB,1.0094E-05_JPRB,8.4784E-06_JPRB,5.4324E-06_JPRB/)
KBO( :, 3,42, 5) = (/&
&8.1801E-06_JPRB,1.3552E-05_JPRB,1.3202E-05_JPRB,1.0892E-05_JPRB,6.3816E-06_JPRB/)
KBO( :, 4,42, 5) = (/&
&1.0865E-05_JPRB,1.7520E-05_JPRB,1.6925E-05_JPRB,1.3796E-05_JPRB,7.4382E-06_JPRB/)
KBO( :, 5,42, 5) = (/&
&1.4044E-05_JPRB,2.2222E-05_JPRB,2.1312E-05_JPRB,1.7215E-05_JPRB,8.5974E-06_JPRB/)
KBO( :, 1,43, 5) = (/&
&3.0295E-06_JPRB,5.6227E-06_JPRB,5.6370E-06_JPRB,4.9291E-06_JPRB,3.4644E-06_JPRB/)
KBO( :, 2,43, 5) = (/&
&4.3992E-06_JPRB,7.7006E-06_JPRB,7.6071E-06_JPRB,6.4406E-06_JPRB,4.1177E-06_JPRB/)
KBO( :, 3,43, 5) = (/&
&6.1168E-06_JPRB,1.0248E-05_JPRB,1.0014E-05_JPRB,8.3065E-06_JPRB,4.8541E-06_JPRB/)
KBO( :, 4,43, 5) = (/&
&8.2022E-06_JPRB,1.3332E-05_JPRB,1.2916E-05_JPRB,1.0567E-05_JPRB,5.6783E-06_JPRB/)
KBO( :, 5,43, 5) = (/&
&1.0679E-05_JPRB,1.7006E-05_JPRB,1.6348E-05_JPRB,1.3242E-05_JPRB,6.5871E-06_JPRB/)
KBO( :, 1,44, 5) = (/&
&2.1752E-06_JPRB,4.1354E-06_JPRB,4.1745E-06_JPRB,3.7028E-06_JPRB,2.6072E-06_JPRB/)
KBO( :, 2,44, 5) = (/&
&3.2105E-06_JPRB,5.7219E-06_JPRB,5.6778E-06_JPRB,4.8546E-06_JPRB,3.1066E-06_JPRB/)
KBO( :, 3,44, 5) = (/&
&4.5242E-06_JPRB,7.6797E-06_JPRB,7.5307E-06_JPRB,6.2874E-06_JPRB,3.6742E-06_JPRB/)
KBO( :, 4,44, 5) = (/&
&6.1342E-06_JPRB,1.0065E-05_JPRB,9.7795E-06_JPRB,8.0353E-06_JPRB,4.3146E-06_JPRB/)
KBO( :, 5,44, 5) = (/&
&8.0572E-06_JPRB,1.2919E-05_JPRB,1.2450E-05_JPRB,1.0118E-05_JPRB,5.0246E-06_JPRB/)
KBO( :, 1,45, 5) = (/&
&1.5520E-06_JPRB,3.0304E-06_JPRB,3.0821E-06_JPRB,2.7797E-06_JPRB,1.9539E-06_JPRB/)
KBO( :, 2,45, 5) = (/&
&2.3304E-06_JPRB,4.2364E-06_JPRB,4.2250E-06_JPRB,3.6531E-06_JPRB,2.3326E-06_JPRB/)
KBO( :, 3,45, 5) = (/&
&3.3303E-06_JPRB,5.7394E-06_JPRB,5.6502E-06_JPRB,4.7523E-06_JPRB,2.7664E-06_JPRB/)
KBO( :, 4,45, 5) = (/&
&4.5711E-06_JPRB,7.5789E-06_JPRB,7.3862E-06_JPRB,6.0991E-06_JPRB,3.2606E-06_JPRB/)
KBO( :, 5,45, 5) = (/&
&6.0612E-06_JPRB,9.7914E-06_JPRB,9.4635E-06_JPRB,7.7174E-06_JPRB,3.8129E-06_JPRB/)
KBO( :, 1,46, 5) = (/&
&1.0896E-06_JPRB,2.1957E-06_JPRB,2.2531E-06_JPRB,2.0749E-06_JPRB,1.4595E-06_JPRB/)
KBO( :, 2,46, 5) = (/&
&1.6682E-06_JPRB,3.1035E-06_JPRB,3.1144E-06_JPRB,2.7296E-06_JPRB,1.7441E-06_JPRB/)
KBO( :, 3,46, 5) = (/&
&2.4227E-06_JPRB,4.2500E-06_JPRB,4.2020E-06_JPRB,3.5671E-06_JPRB,2.0729E-06_JPRB/)
KBO( :, 4,46, 5) = (/&
&3.3718E-06_JPRB,5.6598E-06_JPRB,5.5353E-06_JPRB,4.5977E-06_JPRB,2.4518E-06_JPRB/)
KBO( :, 5,46, 5) = (/&
&4.5215E-06_JPRB,7.3662E-06_JPRB,7.1417E-06_JPRB,5.8470E-06_JPRB,2.8782E-06_JPRB/)
KBO( :, 1,47, 5) = (/&
&7.4469E-07_JPRB,1.5605E-06_JPRB,1.6200E-06_JPRB,1.5335E-06_JPRB,1.0893E-06_JPRB/)
KBO( :, 2,47, 5) = (/&
&1.1672E-06_JPRB,2.2327E-06_JPRB,2.2585E-06_JPRB,2.0143E-06_JPRB,1.3019E-06_JPRB/)
KBO( :, 3,47, 5) = (/&
&1.7284E-06_JPRB,3.0966E-06_JPRB,3.0782E-06_JPRB,2.6442E-06_JPRB,1.5506E-06_JPRB/)
KBO( :, 4,47, 5) = (/&
&2.4447E-06_JPRB,4.1671E-06_JPRB,4.0916E-06_JPRB,3.4253E-06_JPRB,1.8389E-06_JPRB/)
KBO( :, 5,47, 5) = (/&
&3.3234E-06_JPRB,5.4710E-06_JPRB,5.3227E-06_JPRB,4.3793E-06_JPRB,2.1666E-06_JPRB/)
KBO( :, 1,48, 5) = (/&
&5.0356E-07_JPRB,1.1031E-06_JPRB,1.1612E-06_JPRB,1.1366E-06_JPRB,8.1111E-07_JPRB/)
KBO( :, 2,48, 5) = (/&
&8.0967E-07_JPRB,1.5982E-06_JPRB,1.6316E-06_JPRB,1.4855E-06_JPRB,9.6803E-07_JPRB/)
KBO( :, 3,48, 5) = (/&
&1.2240E-06_JPRB,2.2449E-06_JPRB,2.2458E-06_JPRB,1.9554E-06_JPRB,1.1545E-06_JPRB/)
KBO( :, 4,48, 5) = (/&
&1.7609E-06_JPRB,3.0561E-06_JPRB,3.0144E-06_JPRB,2.5471E-06_JPRB,1.3716E-06_JPRB/)
KBO( :, 5,48, 5) = (/&
&2.4302E-06_JPRB,4.0500E-06_JPRB,3.9537E-06_JPRB,3.2729E-06_JPRB,1.6214E-06_JPRB/)
KBO( :, 1,49, 5) = (/&
&3.3669E-07_JPRB,7.7562E-07_JPRB,8.3013E-07_JPRB,8.4661E-07_JPRB,6.0239E-07_JPRB/)
KBO( :, 2,49, 5) = (/&
&5.5618E-07_JPRB,1.1378E-06_JPRB,1.1737E-06_JPRB,1.0960E-06_JPRB,7.1701E-07_JPRB/)
KBO( :, 3,49, 5) = (/&
&8.5966E-07_JPRB,1.6189E-06_JPRB,1.6315E-06_JPRB,1.4432E-06_JPRB,8.5489E-07_JPRB/)
KBO( :, 4,49, 5) = (/&
&1.2600E-06_JPRB,2.2310E-06_JPRB,2.2122E-06_JPRB,1.8904E-06_JPRB,1.0169E-06_JPRB/)
KBO( :, 5,49, 5) = (/&
&1.7668E-06_JPRB,2.9864E-06_JPRB,2.9265E-06_JPRB,2.4403E-06_JPRB,1.2053E-06_JPRB/)
KBO( :, 1,50, 5) = (/&
&2.2597E-07_JPRB,5.4865E-07_JPRB,5.9834E-07_JPRB,6.3972E-07_JPRB,4.5578E-07_JPRB/)
KBO( :, 2,50, 5) = (/&
&3.8336E-07_JPRB,8.1421E-07_JPRB,8.4965E-07_JPRB,8.1592E-07_JPRB,5.4000E-07_JPRB/)
KBO( :, 3,50, 5) = (/&
&6.0620E-07_JPRB,1.1725E-06_JPRB,1.1909E-06_JPRB,1.0720E-06_JPRB,6.4348E-07_JPRB/)
KBO( :, 4,50, 5) = (/&
&9.0494E-07_JPRB,1.6354E-06_JPRB,1.6304E-06_JPRB,1.4100E-06_JPRB,7.6597E-07_JPRB/)
KBO( :, 5,50, 5) = (/&
&1.2886E-06_JPRB,2.2119E-06_JPRB,2.1763E-06_JPRB,1.8292E-06_JPRB,9.0912E-07_JPRB/)
KBO( :, 1,51, 5) = (/&
&1.5102E-07_JPRB,3.8839E-07_JPRB,4.3315E-07_JPRB,4.8969E-07_JPRB,3.4866E-07_JPRB/)
KBO( :, 2,51, 5) = (/&
&2.6341E-07_JPRB,5.8277E-07_JPRB,6.1614E-07_JPRB,6.1112E-07_JPRB,4.1018E-07_JPRB/)
KBO( :, 3,51, 5) = (/&
&4.2666E-07_JPRB,8.4914E-07_JPRB,8.6978E-07_JPRB,7.9868E-07_JPRB,4.8807E-07_JPRB/)
KBO( :, 4,51, 5) = (/&
&6.4908E-07_JPRB,1.1984E-06_JPRB,1.2019E-06_JPRB,1.0530E-06_JPRB,5.8123E-07_JPRB/)
KBO( :, 5,51, 5) = (/&
&9.3904E-07_JPRB,1.6385E-06_JPRB,1.6190E-06_JPRB,1.3734E-06_JPRB,6.9028E-07_JPRB/)
KBO( :, 1,52, 5) = (/&
&9.9875E-08_JPRB,2.7392E-07_JPRB,3.1411E-07_JPRB,3.7992E-07_JPRB,2.6732E-07_JPRB/)
KBO( :, 2,52, 5) = (/&
&1.7936E-07_JPRB,4.1537E-07_JPRB,4.4601E-07_JPRB,4.6002E-07_JPRB,3.1160E-07_JPRB/)
KBO( :, 3,52, 5) = (/&
&2.9800E-07_JPRB,6.1230E-07_JPRB,6.3323E-07_JPRB,5.9558E-07_JPRB,3.6937E-07_JPRB/)
KBO( :, 4,52, 5) = (/&
&4.6262E-07_JPRB,8.7457E-07_JPRB,8.8316E-07_JPRB,7.8544E-07_JPRB,4.3987E-07_JPRB/)
KBO( :, 5,52, 5) = (/&
&6.8072E-07_JPRB,1.2094E-06_JPRB,1.2006E-06_JPRB,1.0296E-06_JPRB,5.2264E-07_JPRB/)
KBO( :, 1,53, 5) = (/&
&6.5343E-08_JPRB,1.9251E-07_JPRB,2.2851E-07_JPRB,2.9947E-07_JPRB,2.0556E-07_JPRB/)
KBO( :, 2,53, 5) = (/&
&1.2091E-07_JPRB,2.9469E-07_JPRB,3.2248E-07_JPRB,3.4877E-07_JPRB,2.3686E-07_JPRB/)
KBO( :, 3,53, 5) = (/&
&2.0627E-07_JPRB,4.3946E-07_JPRB,4.5963E-07_JPRB,4.4471E-07_JPRB,2.7889E-07_JPRB/)
KBO( :, 4,53, 5) = (/&
&3.2743E-07_JPRB,6.3522E-07_JPRB,6.4653E-07_JPRB,5.8508E-07_JPRB,3.3168E-07_JPRB/)
KBO( :, 5,53, 5) = (/&
&4.9060E-07_JPRB,8.8881E-07_JPRB,8.8708E-07_JPRB,7.7003E-07_JPRB,3.9409E-07_JPRB/)
KBO( :, 1,54, 5) = (/&
&4.3306E-08_JPRB,1.3699E-07_JPRB,1.6897E-07_JPRB,2.4035E-07_JPRB,1.6171E-07_JPRB/)
KBO( :, 2,54, 5) = (/&
&8.2182E-08_JPRB,2.1109E-07_JPRB,2.3589E-07_JPRB,2.6887E-07_JPRB,1.8465E-07_JPRB/)
KBO( :, 3,54, 5) = (/&
&1.4392E-07_JPRB,3.1803E-07_JPRB,3.3664E-07_JPRB,3.3573E-07_JPRB,2.1605E-07_JPRB/)
KBO( :, 4,54, 5) = (/&
&2.3356E-07_JPRB,4.6489E-07_JPRB,4.7688E-07_JPRB,4.3961E-07_JPRB,2.5649E-07_JPRB/)
KBO( :, 5,54, 5) = (/&
&3.5601E-07_JPRB,6.5756E-07_JPRB,6.5990E-07_JPRB,5.7981E-07_JPRB,3.0495E-07_JPRB/)
KBO( :, 1,55, 5) = (/&
&2.8854E-08_JPRB,9.8072E-08_JPRB,1.2651E-07_JPRB,1.9577E-07_JPRB,1.2893E-07_JPRB/)
KBO( :, 2,55, 5) = (/&
&5.5873E-08_JPRB,1.5168E-07_JPRB,1.7364E-07_JPRB,2.1001E-07_JPRB,1.4600E-07_JPRB/)
KBO( :, 3,55, 5) = (/&
&1.0041E-07_JPRB,2.3068E-07_JPRB,2.4750E-07_JPRB,2.5542E-07_JPRB,1.6992E-07_JPRB/)
KBO( :, 4,55, 5) = (/&
&1.6665E-07_JPRB,3.4087E-07_JPRB,3.5250E-07_JPRB,3.3178E-07_JPRB,2.0129E-07_JPRB/)
KBO( :, 5,55, 5) = (/&
&2.5859E-07_JPRB,4.8718E-07_JPRB,4.9183E-07_JPRB,4.3783E-07_JPRB,2.3951E-07_JPRB/)
KBO( :, 1,56, 5) = (/&
&1.9183E-08_JPRB,7.0296E-08_JPRB,9.5958E-08_JPRB,1.6166E-07_JPRB,1.0324E-07_JPRB/)
KBO( :, 2,56, 5) = (/&
&3.7690E-08_JPRB,1.0873E-07_JPRB,1.2816E-07_JPRB,1.6606E-07_JPRB,1.1573E-07_JPRB/)
KBO( :, 3,56, 5) = (/&
&6.9564E-08_JPRB,1.6681E-07_JPRB,1.8184E-07_JPRB,1.9538E-07_JPRB,1.3395E-07_JPRB/)
KBO( :, 4,56, 5) = (/&
&1.1817E-07_JPRB,2.4912E-07_JPRB,2.5998E-07_JPRB,2.5068E-07_JPRB,1.5820E-07_JPRB/)
KBO( :, 5,56, 5) = (/&
&1.8685E-07_JPRB,3.5979E-07_JPRB,3.6566E-07_JPRB,3.3044E-07_JPRB,1.8828E-07_JPRB/)
KBO( :, 1,57, 5) = (/&
&1.2749E-08_JPRB,5.0514E-08_JPRB,7.4147E-08_JPRB,1.3511E-07_JPRB,8.3045E-08_JPRB/)
KBO( :, 2,57, 5) = (/&
&2.5237E-08_JPRB,7.7785E-08_JPRB,9.5012E-08_JPRB,1.3300E-07_JPRB,9.1992E-08_JPRB/)
KBO( :, 3,57, 5) = (/&
&4.7790E-08_JPRB,1.2024E-07_JPRB,1.3358E-07_JPRB,1.5060E-07_JPRB,1.0586E-07_JPRB/)
KBO( :, 4,57, 5) = (/&
&8.3233E-08_JPRB,1.8139E-07_JPRB,1.9136E-07_JPRB,1.8973E-07_JPRB,1.2456E-07_JPRB/)
KBO( :, 5,57, 5) = (/&
&1.3430E-07_JPRB,2.6480E-07_JPRB,2.7113E-07_JPRB,2.4926E-07_JPRB,1.4817E-07_JPRB/)
KBO( :, 1,58, 5) = (/&
&8.6071E-09_JPRB,3.6748E-08_JPRB,5.8348E-08_JPRB,1.1389E-07_JPRB,6.7280E-08_JPRB/)
KBO( :, 2,58, 5) = (/&
&1.7003E-08_JPRB,5.6012E-08_JPRB,7.1270E-08_JPRB,1.0797E-07_JPRB,7.3801E-08_JPRB/)
KBO( :, 3,58, 5) = (/&
&3.2884E-08_JPRB,8.7017E-08_JPRB,9.8797E-08_JPRB,1.1752E-07_JPRB,8.4329E-08_JPRB/)
KBO( :, 4,58, 5) = (/&
&5.8722E-08_JPRB,1.3250E-07_JPRB,1.4147E-07_JPRB,1.4468E-07_JPRB,9.8923E-08_JPRB/)
KBO( :, 5,58, 5) = (/&
&9.6718E-08_JPRB,1.9549E-07_JPRB,2.0167E-07_JPRB,1.8889E-07_JPRB,1.1761E-07_JPRB/)
KBO( :, 1,59, 5) = (/&
&6.5762E-09_JPRB,2.8839E-08_JPRB,4.7240E-08_JPRB,9.4281E-08_JPRB,5.6347E-08_JPRB/)
KBO( :, 2,59, 5) = (/&
&1.2969E-08_JPRB,4.3747E-08_JPRB,5.6620E-08_JPRB,8.8361E-08_JPRB,6.2071E-08_JPRB/)
KBO( :, 3,59, 5) = (/&
&2.5275E-08_JPRB,6.8112E-08_JPRB,7.8014E-08_JPRB,9.4814E-08_JPRB,7.1293E-08_JPRB/)
KBO( :, 4,59, 5) = (/&
&4.5565E-08_JPRB,1.0415E-07_JPRB,1.1172E-07_JPRB,1.1566E-07_JPRB,8.4152E-08_JPRB/)
KBO( :, 5,59, 5) = (/&
&7.5655E-08_JPRB,1.5435E-07_JPRB,1.5965E-07_JPRB,1.5065E-07_JPRB,1.0042E-07_JPRB/)
KBO( :, 1,13, 6) = (/&
&1.4917E-03_JPRB,1.8975E-03_JPRB,1.8217E-03_JPRB,1.6462E-03_JPRB,1.5445E-02_JPRB/)
KBO( :, 2,13, 6) = (/&
&2.0332E-03_JPRB,2.5878E-03_JPRB,2.4581E-03_JPRB,2.0975E-03_JPRB,1.7016E-02_JPRB/)
KBO( :, 3,13, 6) = (/&
&2.7157E-03_JPRB,3.4479E-03_JPRB,3.2442E-03_JPRB,2.6787E-03_JPRB,1.8566E-02_JPRB/)
KBO( :, 4,13, 6) = (/&
&3.5630E-03_JPRB,4.4992E-03_JPRB,4.2037E-03_JPRB,3.3897E-03_JPRB,2.0183E-02_JPRB/)
KBO( :, 5,13, 6) = (/&
&4.5925E-03_JPRB,5.7651E-03_JPRB,5.3543E-03_JPRB,4.2359E-03_JPRB,2.1919E-02_JPRB/)
KBO( :, 1,14, 6) = (/&
&1.2829E-03_JPRB,1.6450E-03_JPRB,1.5791E-03_JPRB,1.4049E-03_JPRB,1.2669E-02_JPRB/)
KBO( :, 2,14, 6) = (/&
&1.7594E-03_JPRB,2.2519E-03_JPRB,2.1337E-03_JPRB,1.8028E-03_JPRB,1.3983E-02_JPRB/)
KBO( :, 3,14, 6) = (/&
&2.3660E-03_JPRB,3.0125E-03_JPRB,2.8248E-03_JPRB,2.3088E-03_JPRB,1.5340E-02_JPRB/)
KBO( :, 4,14, 6) = (/&
&3.1206E-03_JPRB,3.9492E-03_JPRB,3.6685E-03_JPRB,2.9292E-03_JPRB,1.6758E-02_JPRB/)
KBO( :, 5,14, 6) = (/&
&4.0424E-03_JPRB,5.0714E-03_JPRB,4.6797E-03_JPRB,3.6711E-03_JPRB,1.8318E-02_JPRB/)
KBO( :, 1,15, 6) = (/&
&1.1010E-03_JPRB,1.4255E-03_JPRB,1.3650E-03_JPRB,1.2017E-03_JPRB,9.7184E-03_JPRB/)
KBO( :, 2,15, 6) = (/&
&1.5219E-03_JPRB,1.9593E-03_JPRB,1.8495E-03_JPRB,1.5487E-03_JPRB,1.0782E-02_JPRB/)
KBO( :, 3,15, 6) = (/&
&2.0586E-03_JPRB,2.6324E-03_JPRB,2.4574E-03_JPRB,1.9892E-03_JPRB,1.1885E-02_JPRB/)
KBO( :, 4,15, 6) = (/&
&2.7279E-03_JPRB,3.4587E-03_JPRB,3.1990E-03_JPRB,2.5317E-03_JPRB,1.3076E-02_JPRB/)
KBO( :, 5,15, 6) = (/&
&3.5476E-03_JPRB,4.4511E-03_JPRB,4.0873E-03_JPRB,3.1825E-03_JPRB,1.4381E-02_JPRB/)
KBO( :, 1,16, 6) = (/&
&9.4439E-04_JPRB,1.2342E-03_JPRB,1.1791E-03_JPRB,1.0290E-03_JPRB,7.0974E-03_JPRB/)
KBO( :, 2,16, 6) = (/&
&1.3152E-03_JPRB,1.7038E-03_JPRB,1.6038E-03_JPRB,1.3320E-03_JPRB,7.9219E-03_JPRB/)
KBO( :, 3,16, 6) = (/&
&1.7873E-03_JPRB,2.2957E-03_JPRB,2.1360E-03_JPRB,1.7165E-03_JPRB,8.8130E-03_JPRB/)
KBO( :, 4,16, 6) = (/&
&2.3776E-03_JPRB,3.0227E-03_JPRB,2.7856E-03_JPRB,2.1917E-03_JPRB,9.7773E-03_JPRB/)
KBO( :, 5,16, 6) = (/&
&3.1042E-03_JPRB,3.9007E-03_JPRB,3.5645E-03_JPRB,2.7609E-03_JPRB,1.0823E-02_JPRB/)
KBO( :, 1,17, 6) = (/&
&8.1418E-04_JPRB,1.0727E-03_JPRB,1.0215E-03_JPRB,8.8282E-04_JPRB,5.2836E-03_JPRB/)
KBO( :, 2,17, 6) = (/&
&1.1389E-03_JPRB,1.4851E-03_JPRB,1.3936E-03_JPRB,1.1467E-03_JPRB,5.9459E-03_JPRB/)
KBO( :, 3,17, 6) = (/&
&1.5530E-03_JPRB,2.0047E-03_JPRB,1.8586E-03_JPRB,1.4830E-03_JPRB,6.6722E-03_JPRB/)
KBO( :, 4,17, 6) = (/&
&2.0750E-03_JPRB,2.6425E-03_JPRB,2.4247E-03_JPRB,1.8986E-03_JPRB,7.4589E-03_JPRB/)
KBO( :, 5,17, 6) = (/&
&2.7144E-03_JPRB,3.4191E-03_JPRB,3.1093E-03_JPRB,2.3947E-03_JPRB,8.3055E-03_JPRB/)
KBO( :, 1,18, 6) = (/&
&7.0743E-04_JPRB,9.3753E-04_JPRB,8.9000E-04_JPRB,7.5959E-04_JPRB,4.0718E-03_JPRB/)
KBO( :, 2,18, 6) = (/&
&9.9182E-04_JPRB,1.3005E-03_JPRB,1.2154E-03_JPRB,9.9062E-04_JPRB,4.6245E-03_JPRB/)
KBO( :, 3,18, 6) = (/&
&1.3564E-03_JPRB,1.7551E-03_JPRB,1.6207E-03_JPRB,1.2856E-03_JPRB,5.2287E-03_JPRB/)
KBO( :, 4,18, 6) = (/&
&1.8159E-03_JPRB,2.3174E-03_JPRB,2.1151E-03_JPRB,1.6469E-03_JPRB,5.8797E-03_JPRB/)
KBO( :, 5,18, 6) = (/&
&2.3773E-03_JPRB,3.0052E-03_JPRB,2.7189E-03_JPRB,2.0800E-03_JPRB,6.5746E-03_JPRB/)
KBO( :, 1,19, 6) = (/&
&6.1525E-04_JPRB,8.1970E-04_JPRB,7.7553E-04_JPRB,6.5423E-04_JPRB,3.2676E-03_JPRB/)
KBO( :, 2,19, 6) = (/&
&8.6391E-04_JPRB,1.1368E-03_JPRB,1.0592E-03_JPRB,8.5683E-04_JPRB,3.7402E-03_JPRB/)
KBO( :, 3,19, 6) = (/&
&1.1842E-03_JPRB,1.5349E-03_JPRB,1.4113E-03_JPRB,1.1133E-03_JPRB,4.2531E-03_JPRB/)
KBO( :, 4,19, 6) = (/&
&1.5850E-03_JPRB,2.0314E-03_JPRB,1.8453E-03_JPRB,1.4271E-03_JPRB,4.8022E-03_JPRB/)
KBO( :, 5,19, 6) = (/&
&2.0738E-03_JPRB,2.6347E-03_JPRB,2.3756E-03_JPRB,1.8073E-03_JPRB,5.3894E-03_JPRB/)
KBO( :, 1,20, 6) = (/&
&5.3813E-04_JPRB,7.1852E-04_JPRB,6.7742E-04_JPRB,5.6610E-04_JPRB,2.6837E-03_JPRB/)
KBO( :, 2,20, 6) = (/&
&7.5609E-04_JPRB,9.9539E-04_JPRB,9.2396E-04_JPRB,7.4319E-04_JPRB,3.0864E-03_JPRB/)
KBO( :, 3,20, 6) = (/&
&1.0360E-03_JPRB,1.3460E-03_JPRB,1.2317E-03_JPRB,9.6600E-04_JPRB,3.5220E-03_JPRB/)
KBO( :, 4,20, 6) = (/&
&1.3841E-03_JPRB,1.7811E-03_JPRB,1.6124E-03_JPRB,1.2411E-03_JPRB,3.9882E-03_JPRB/)
KBO( :, 5,20, 6) = (/&
&1.8083E-03_JPRB,2.3047E-03_JPRB,2.0753E-03_JPRB,1.5749E-03_JPRB,4.4863E-03_JPRB/)
KBO( :, 1,21, 6) = (/&
&4.7047E-04_JPRB,6.2774E-04_JPRB,5.8945E-04_JPRB,4.8888E-04_JPRB,2.2094E-03_JPRB/)
KBO( :, 2,21, 6) = (/&
&6.6102E-04_JPRB,8.6924E-04_JPRB,8.0377E-04_JPRB,6.4244E-04_JPRB,2.5494E-03_JPRB/)
KBO( :, 3,21, 6) = (/&
&9.0363E-04_JPRB,1.1757E-03_JPRB,1.0725E-03_JPRB,8.3681E-04_JPRB,2.9166E-03_JPRB/)
KBO( :, 4,21, 6) = (/&
&1.2048E-03_JPRB,1.5526E-03_JPRB,1.4031E-03_JPRB,1.0775E-03_JPRB,3.3103E-03_JPRB/)
KBO( :, 5,21, 6) = (/&
&1.5718E-03_JPRB,2.0028E-03_JPRB,1.8024E-03_JPRB,1.3677E-03_JPRB,3.7308E-03_JPRB/)
KBO( :, 1,22, 6) = (/&
&4.1907E-04_JPRB,5.5771E-04_JPRB,5.2119E-04_JPRB,4.2792E-04_JPRB,1.8003E-03_JPRB/)
KBO( :, 2,22, 6) = (/&
&5.8671E-04_JPRB,7.7133E-04_JPRB,7.0998E-04_JPRB,5.6325E-04_JPRB,2.0828E-03_JPRB/)
KBO( :, 3,22, 6) = (/&
&7.9916E-04_JPRB,1.0396E-03_JPRB,9.4560E-04_JPRB,7.3497E-04_JPRB,2.3875E-03_JPRB/)
KBO( :, 4,22, 6) = (/&
&1.0624E-03_JPRB,1.3663E-03_JPRB,1.2338E-03_JPRB,9.4591E-04_JPRB,2.7147E-03_JPRB/)
KBO( :, 5,22, 6) = (/&
&1.3828E-03_JPRB,1.7569E-03_JPRB,1.5791E-03_JPRB,1.1986E-03_JPRB,3.0625E-03_JPRB/)
KBO( :, 1,23, 6) = (/&
&3.7268E-04_JPRB,4.9540E-04_JPRB,4.6049E-04_JPRB,3.7441E-04_JPRB,1.4599E-03_JPRB/)
KBO( :, 2,23, 6) = (/&
&5.1963E-04_JPRB,6.8295E-04_JPRB,6.2616E-04_JPRB,4.9378E-04_JPRB,1.6928E-03_JPRB/)
KBO( :, 3,23, 6) = (/&
&7.0552E-04_JPRB,9.1627E-04_JPRB,8.3118E-04_JPRB,6.4434E-04_JPRB,1.9439E-03_JPRB/)
KBO( :, 4,23, 6) = (/&
&9.3566E-04_JPRB,1.1987E-03_JPRB,1.0808E-03_JPRB,8.2747E-04_JPRB,2.2129E-03_JPRB/)
KBO( :, 5,23, 6) = (/&
&1.2165E-03_JPRB,1.5386E-03_JPRB,1.3793E-03_JPRB,1.0460E-03_JPRB,2.4958E-03_JPRB/)
KBO( :, 1,24, 6) = (/&
&3.2966E-04_JPRB,4.3876E-04_JPRB,4.0641E-04_JPRB,3.2767E-04_JPRB,1.1682E-03_JPRB/)
KBO( :, 2,24, 6) = (/&
&4.5833E-04_JPRB,6.0226E-04_JPRB,5.5059E-04_JPRB,4.3248E-04_JPRB,1.3581E-03_JPRB/)
KBO( :, 3,24, 6) = (/&
&6.2099E-04_JPRB,8.0461E-04_JPRB,7.2851E-04_JPRB,5.6351E-04_JPRB,1.5621E-03_JPRB/)
KBO( :, 4,24, 6) = (/&
&8.2193E-04_JPRB,1.0497E-03_JPRB,9.4428E-04_JPRB,7.2199E-04_JPRB,1.7793E-03_JPRB/)
KBO( :, 5,24, 6) = (/&
&1.0685E-03_JPRB,1.3449E-03_JPRB,1.2028E-03_JPRB,9.1046E-04_JPRB,2.0052E-03_JPRB/)
KBO( :, 1,25, 6) = (/&
&2.9215E-04_JPRB,3.8885E-04_JPRB,3.5906E-04_JPRB,2.8752E-04_JPRB,9.3498E-04_JPRB/)
KBO( :, 2,25, 6) = (/&
&4.0498E-04_JPRB,5.3121E-04_JPRB,4.8436E-04_JPRB,3.7925E-04_JPRB,1.0888E-03_JPRB/)
KBO( :, 3,25, 6) = (/&
&5.4724E-04_JPRB,7.0707E-04_JPRB,6.3870E-04_JPRB,4.9281E-04_JPRB,1.2539E-03_JPRB/)
KBO( :, 4,25, 6) = (/&
&7.2403E-04_JPRB,9.2061E-04_JPRB,8.2594E-04_JPRB,6.2991E-04_JPRB,1.4275E-03_JPRB/)
KBO( :, 5,25, 6) = (/&
&9.4207E-04_JPRB,1.1779E-03_JPRB,1.0503E-03_JPRB,7.9277E-04_JPRB,1.6058E-03_JPRB/)
KBO( :, 1,26, 6) = (/&
&2.6060E-04_JPRB,3.4625E-04_JPRB,3.1865E-04_JPRB,2.5360E-04_JPRB,7.5595E-04_JPRB/)
KBO( :, 2,26, 6) = (/&
&3.5990E-04_JPRB,4.7096E-04_JPRB,4.2792E-04_JPRB,3.3380E-04_JPRB,8.8083E-04_JPRB/)
KBO( :, 3,26, 6) = (/&
&4.8540E-04_JPRB,6.2457E-04_JPRB,5.6257E-04_JPRB,4.3260E-04_JPRB,1.0137E-03_JPRB/)
KBO( :, 4,26, 6) = (/&
&6.4236E-04_JPRB,8.1177E-04_JPRB,7.2596E-04_JPRB,5.5153E-04_JPRB,1.1519E-03_JPRB/)
KBO( :, 5,26, 6) = (/&
&8.3673E-04_JPRB,1.0378E-03_JPRB,9.2177E-04_JPRB,6.9311E-04_JPRB,1.2938E-03_JPRB/)
KBO( :, 1,27, 6) = (/&
&2.3167E-04_JPRB,3.0750E-04_JPRB,2.8206E-04_JPRB,2.2335E-04_JPRB,6.0157E-04_JPRB/)
KBO( :, 2,27, 6) = (/&
&3.1908E-04_JPRB,4.1650E-04_JPRB,3.7750E-04_JPRB,2.9327E-04_JPRB,7.0083E-04_JPRB/)
KBO( :, 3,27, 6) = (/&
&4.3021E-04_JPRB,5.5097E-04_JPRB,4.9488E-04_JPRB,3.7918E-04_JPRB,8.0532E-04_JPRB/)
KBO( :, 4,27, 6) = (/&
&5.6999E-04_JPRB,7.1551E-04_JPRB,6.3770E-04_JPRB,4.8255E-04_JPRB,9.1424E-04_JPRB/)
KBO( :, 5,27, 6) = (/&
&7.4251E-04_JPRB,9.1481E-04_JPRB,8.0913E-04_JPRB,6.0585E-04_JPRB,1.0264E-03_JPRB/)
KBO( :, 1,28, 6) = (/&
&2.0524E-04_JPRB,2.7221E-04_JPRB,2.4906E-04_JPRB,1.9634E-04_JPRB,4.7063E-04_JPRB/)
KBO( :, 2,28, 6) = (/&
&2.8255E-04_JPRB,3.6755E-04_JPRB,3.3244E-04_JPRB,2.5733E-04_JPRB,5.4784E-04_JPRB/)
KBO( :, 3,28, 6) = (/&
&3.8119E-04_JPRB,4.8546E-04_JPRB,4.3507E-04_JPRB,3.3192E-04_JPRB,6.2929E-04_JPRB/)
KBO( :, 4,28, 6) = (/&
&5.0531E-04_JPRB,6.3052E-04_JPRB,5.6015E-04_JPRB,4.2208E-04_JPRB,7.1426E-04_JPRB/)
KBO( :, 5,28, 6) = (/&
&6.5768E-04_JPRB,8.0589E-04_JPRB,7.1092E-04_JPRB,5.3007E-04_JPRB,8.0182E-04_JPRB/)
KBO( :, 1,29, 6) = (/&
&1.8268E-04_JPRB,2.4155E-04_JPRB,2.2044E-04_JPRB,1.7290E-04_JPRB,3.6473E-04_JPRB/)
KBO( :, 2,29, 6) = (/&
&2.5147E-04_JPRB,3.2531E-04_JPRB,2.9347E-04_JPRB,2.2618E-04_JPRB,4.2431E-04_JPRB/)
KBO( :, 3,29, 6) = (/&
&3.3930E-04_JPRB,4.2940E-04_JPRB,3.8351E-04_JPRB,2.9136E-04_JPRB,4.8729E-04_JPRB/)
KBO( :, 4,29, 6) = (/&
&4.4909E-04_JPRB,5.5754E-04_JPRB,4.9362E-04_JPRB,3.7031E-04_JPRB,5.5277E-04_JPRB/)
KBO( :, 5,29, 6) = (/&
&5.8288E-04_JPRB,7.1165E-04_JPRB,6.2625E-04_JPRB,4.6539E-04_JPRB,6.2094E-04_JPRB/)
KBO( :, 1,30, 6) = (/&
&1.6275E-04_JPRB,2.1427E-04_JPRB,1.9492E-04_JPRB,1.5221E-04_JPRB,2.7882E-04_JPRB/)
KBO( :, 2,30, 6) = (/&
&2.2397E-04_JPRB,2.8807E-04_JPRB,2.5905E-04_JPRB,1.9884E-04_JPRB,3.2464E-04_JPRB/)
KBO( :, 3,30, 6) = (/&
&3.0173E-04_JPRB,3.8020E-04_JPRB,3.3838E-04_JPRB,2.5591E-04_JPRB,3.7279E-04_JPRB/)
KBO( :, 4,30, 6) = (/&
&3.9835E-04_JPRB,4.9290E-04_JPRB,4.3523E-04_JPRB,3.2539E-04_JPRB,4.2318E-04_JPRB/)
KBO( :, 5,30, 6) = (/&
&5.1512E-04_JPRB,6.2814E-04_JPRB,5.5236E-04_JPRB,4.0928E-04_JPRB,4.7644E-04_JPRB/)
KBO( :, 1,31, 6) = (/&
&1.4541E-04_JPRB,1.9050E-04_JPRB,1.7269E-04_JPRB,1.3415E-04_JPRB,2.0988E-04_JPRB/)
KBO( :, 2,31, 6) = (/&
&1.9968E-04_JPRB,2.5579E-04_JPRB,2.2917E-04_JPRB,1.7504E-04_JPRB,2.4454E-04_JPRB/)
KBO( :, 3,31, 6) = (/&
&2.6831E-04_JPRB,3.3713E-04_JPRB,2.9924E-04_JPRB,2.2534E-04_JPRB,2.8116E-04_JPRB/)
KBO( :, 4,31, 6) = (/&
&3.5296E-04_JPRB,4.3603E-04_JPRB,3.8460E-04_JPRB,2.8657E-04_JPRB,3.1971E-04_JPRB/)
KBO( :, 5,31, 6) = (/&
&4.5385E-04_JPRB,5.5422E-04_JPRB,4.8747E-04_JPRB,3.6051E-04_JPRB,3.6033E-04_JPRB/)
KBO( :, 1,32, 6) = (/&
&1.3012E-04_JPRB,1.6979E-04_JPRB,1.5332E-04_JPRB,1.1846E-04_JPRB,1.5858E-04_JPRB/)
KBO( :, 2,32, 6) = (/&
&1.7811E-04_JPRB,2.2758E-04_JPRB,2.0328E-04_JPRB,1.5447E-04_JPRB,1.8500E-04_JPRB/)
KBO( :, 3,32, 6) = (/&
&2.3846E-04_JPRB,2.9920E-04_JPRB,2.6508E-04_JPRB,1.9890E-04_JPRB,2.1289E-04_JPRB/)
KBO( :, 4,32, 6) = (/&
&3.1195E-04_JPRB,3.8579E-04_JPRB,3.4029E-04_JPRB,2.5305E-04_JPRB,2.4226E-04_JPRB/)
KBO( :, 5,32, 6) = (/&
&3.9831E-04_JPRB,4.8846E-04_JPRB,4.3040E-04_JPRB,3.1815E-04_JPRB,2.7351E-04_JPRB/)
KBO( :, 1,33, 6) = (/&
&1.1634E-04_JPRB,1.5147E-04_JPRB,1.3636E-04_JPRB,1.0475E-04_JPRB,1.1978E-04_JPRB/)
KBO( :, 2,33, 6) = (/&
&1.5863E-04_JPRB,2.0248E-04_JPRB,1.8050E-04_JPRB,1.3665E-04_JPRB,1.3973E-04_JPRB/)
KBO( :, 3,33, 6) = (/&
&2.1137E-04_JPRB,2.6530E-04_JPRB,2.3496E-04_JPRB,1.7592E-04_JPRB,1.6087E-04_JPRB/)
KBO( :, 4,33, 6) = (/&
&2.7467E-04_JPRB,3.4079E-04_JPRB,3.0109E-04_JPRB,2.2372E-04_JPRB,1.8344E-04_JPRB/)
KBO( :, 5,33, 6) = (/&
&3.4782E-04_JPRB,4.2919E-04_JPRB,3.7950E-04_JPRB,2.8080E-04_JPRB,2.0757E-04_JPRB/)
KBO( :, 1,34, 6) = (/&
&1.0312E-04_JPRB,1.3408E-04_JPRB,1.2041E-04_JPRB,9.2110E-05_JPRB,9.2903E-05_JPRB/)
KBO( :, 2,34, 6) = (/&
&1.4008E-04_JPRB,1.7871E-04_JPRB,1.5914E-04_JPRB,1.2016E-04_JPRB,1.0831E-04_JPRB/)
KBO( :, 3,34, 6) = (/&
&1.8556E-04_JPRB,2.3329E-04_JPRB,2.0678E-04_JPRB,1.5464E-04_JPRB,1.2476E-04_JPRB/)
KBO( :, 4,34, 6) = (/&
&2.3939E-04_JPRB,2.9833E-04_JPRB,2.6429E-04_JPRB,1.9649E-04_JPRB,1.4248E-04_JPRB/)
KBO( :, 5,34, 6) = (/&
&3.0117E-04_JPRB,3.7373E-04_JPRB,3.3162E-04_JPRB,2.4605E-04_JPRB,1.6152E-04_JPRB/)
KBO( :, 1,35, 6) = (/&
&8.8443E-05_JPRB,1.1512E-04_JPRB,1.0336E-04_JPRB,7.8950E-05_JPRB,7.0684E-05_JPRB/)
KBO( :, 2,35, 6) = (/&
&1.1985E-04_JPRB,1.5327E-04_JPRB,1.3658E-04_JPRB,1.0311E-04_JPRB,8.2504E-05_JPRB/)
KBO( :, 3,35, 6) = (/&
&1.5813E-04_JPRB,1.9962E-04_JPRB,1.7734E-04_JPRB,1.3276E-04_JPRB,9.5244E-05_JPRB/)
KBO( :, 4,35, 6) = (/&
&2.0303E-04_JPRB,2.5445E-04_JPRB,2.2617E-04_JPRB,1.6859E-04_JPRB,1.0907E-04_JPRB/)
KBO( :, 5,35, 6) = (/&
&2.5457E-04_JPRB,3.1764E-04_JPRB,2.8275E-04_JPRB,2.1067E-04_JPRB,1.2401E-04_JPRB/)
KBO( :, 1,36, 6) = (/&
&7.3105E-05_JPRB,9.5553E-05_JPRB,8.5894E-05_JPRB,6.5665E-05_JPRB,5.2586E-05_JPRB/)
KBO( :, 2,36, 6) = (/&
&9.9088E-05_JPRB,1.2731E-04_JPRB,1.1366E-04_JPRB,8.5950E-05_JPRB,6.1603E-05_JPRB/)
KBO( :, 3,36, 6) = (/&
&1.3052E-04_JPRB,1.6575E-04_JPRB,1.4766E-04_JPRB,1.1085E-04_JPRB,7.1395E-05_JPRB/)
KBO( :, 4,36, 6) = (/&
&1.6737E-04_JPRB,2.1100E-04_JPRB,1.8817E-04_JPRB,1.4082E-04_JPRB,8.2060E-05_JPRB/)
KBO( :, 5,36, 6) = (/&
&2.0971E-04_JPRB,2.6328E-04_JPRB,2.3482E-04_JPRB,1.7583E-04_JPRB,9.3616E-05_JPRB/)
KBO( :, 1,37, 6) = (/&
&5.7964E-05_JPRB,7.6160E-05_JPRB,6.8576E-05_JPRB,5.2541E-05_JPRB,4.0073E-05_JPRB/)
KBO( :, 2,37, 6) = (/&
&7.8834E-05_JPRB,1.0183E-04_JPRB,9.1063E-05_JPRB,6.9045E-05_JPRB,4.7111E-05_JPRB/)
KBO( :, 3,37, 6) = (/&
&1.0412E-04_JPRB,1.3294E-04_JPRB,1.1864E-04_JPRB,8.9322E-05_JPRB,5.4770E-05_JPRB/)
KBO( :, 4,37, 6) = (/&
&1.3382E-04_JPRB,1.6952E-04_JPRB,1.5143E-04_JPRB,1.1374E-04_JPRB,6.3134E-05_JPRB/)
KBO( :, 5,37, 6) = (/&
&1.6808E-04_JPRB,2.1196E-04_JPRB,1.8928E-04_JPRB,1.4220E-04_JPRB,7.2225E-05_JPRB/)
KBO( :, 1,38, 6) = (/&
&4.5775E-05_JPRB,6.0479E-05_JPRB,5.4555E-05_JPRB,4.1902E-05_JPRB,3.0397E-05_JPRB/)
KBO( :, 2,38, 6) = (/&
&6.2496E-05_JPRB,8.1164E-05_JPRB,7.2708E-05_JPRB,5.5274E-05_JPRB,3.5878E-05_JPRB/)
KBO( :, 3,38, 6) = (/&
&8.2782E-05_JPRB,1.0626E-04_JPRB,9.5002E-05_JPRB,7.1740E-05_JPRB,4.1841E-05_JPRB/)
KBO( :, 4,38, 6) = (/&
&1.0670E-04_JPRB,1.3583E-04_JPRB,1.2149E-04_JPRB,9.1558E-05_JPRB,4.8377E-05_JPRB/)
KBO( :, 5,38, 6) = (/&
&1.3438E-04_JPRB,1.7021E-04_JPRB,1.5213E-04_JPRB,1.1463E-04_JPRB,5.5512E-05_JPRB/)
KBO( :, 1,39, 6) = (/&
&3.6095E-05_JPRB,4.7960E-05_JPRB,4.3340E-05_JPRB,3.3379E-05_JPRB,2.2882E-05_JPRB/)
KBO( :, 2,39, 6) = (/&
&4.9468E-05_JPRB,6.4614E-05_JPRB,5.7979E-05_JPRB,4.4199E-05_JPRB,2.7110E-05_JPRB/)
KBO( :, 3,39, 6) = (/&
&6.5728E-05_JPRB,8.4830E-05_JPRB,7.5966E-05_JPRB,5.7541E-05_JPRB,3.1729E-05_JPRB/)
KBO( :, 4,39, 6) = (/&
&8.4989E-05_JPRB,1.0871E-04_JPRB,9.7338E-05_JPRB,7.3595E-05_JPRB,3.6816E-05_JPRB/)
KBO( :, 5,39, 6) = (/&
&1.0733E-04_JPRB,1.3655E-04_JPRB,1.2216E-04_JPRB,9.2289E-05_JPRB,4.2380E-05_JPRB/)
KBO( :, 1,40, 6) = (/&
&2.7548E-05_JPRB,3.6866E-05_JPRB,3.3398E-05_JPRB,2.5816E-05_JPRB,1.7406E-05_JPRB/)
KBO( :, 2,40, 6) = (/&
&3.8017E-05_JPRB,4.9978E-05_JPRB,4.4939E-05_JPRB,3.4363E-05_JPRB,2.0717E-05_JPRB/)
KBO( :, 3,40, 6) = (/&
&5.0843E-05_JPRB,6.5998E-05_JPRB,5.9173E-05_JPRB,4.4960E-05_JPRB,2.4340E-05_JPRB/)
KBO( :, 4,40, 6) = (/&
&6.6103E-05_JPRB,8.4982E-05_JPRB,7.6165E-05_JPRB,5.7734E-05_JPRB,2.8334E-05_JPRB/)
KBO( :, 5,40, 6) = (/&
&8.3889E-05_JPRB,1.0718E-04_JPRB,9.5971E-05_JPRB,7.2651E-05_JPRB,3.2716E-05_JPRB/)
KBO( :, 1,41, 6) = (/&
&2.0891E-05_JPRB,2.8160E-05_JPRB,2.5581E-05_JPRB,1.9853E-05_JPRB,1.3219E-05_JPRB/)
KBO( :, 2,41, 6) = (/&
&2.9056E-05_JPRB,3.8448E-05_JPRB,3.4643E-05_JPRB,2.6578E-05_JPRB,1.5803E-05_JPRB/)
KBO( :, 3,41, 6) = (/&
&3.9119E-05_JPRB,5.1086E-05_JPRB,4.5870E-05_JPRB,3.4949E-05_JPRB,1.8643E-05_JPRB/)
KBO( :, 4,41, 6) = (/&
&5.1167E-05_JPRB,6.6144E-05_JPRB,5.9321E-05_JPRB,4.5078E-05_JPRB,2.1781E-05_JPRB/)
KBO( :, 5,41, 6) = (/&
&6.5313E-05_JPRB,8.3807E-05_JPRB,7.5100E-05_JPRB,5.6965E-05_JPRB,2.5228E-05_JPRB/)
KBO( :, 1,42, 6) = (/&
&1.5797E-05_JPRB,2.1452E-05_JPRB,1.9541E-05_JPRB,1.5234E-05_JPRB,9.9864E-06_JPRB/)
KBO( :, 2,42, 6) = (/&
&2.2148E-05_JPRB,2.9506E-05_JPRB,2.6644E-05_JPRB,2.0507E-05_JPRB,1.1995E-05_JPRB/)
KBO( :, 3,42, 6) = (/&
&3.0028E-05_JPRB,3.9456E-05_JPRB,3.5478E-05_JPRB,2.7113E-05_JPRB,1.4215E-05_JPRB/)
KBO( :, 4,42, 6) = (/&
&3.9526E-05_JPRB,5.1380E-05_JPRB,4.6122E-05_JPRB,3.5139E-05_JPRB,1.6670E-05_JPRB/)
KBO( :, 5,42, 6) = (/&
&5.0747E-05_JPRB,6.5409E-05_JPRB,5.8661E-05_JPRB,4.4588E-05_JPRB,1.9369E-05_JPRB/)
KBO( :, 1,43, 6) = (/&
&1.1685E-05_JPRB,1.6001E-05_JPRB,1.4628E-05_JPRB,1.1471E-05_JPRB,7.4936E-06_JPRB/)
KBO( :, 2,43, 6) = (/&
&1.6548E-05_JPRB,2.2213E-05_JPRB,2.0113E-05_JPRB,1.5537E-05_JPRB,9.0536E-06_JPRB/)
KBO( :, 3,43, 6) = (/&
&2.2638E-05_JPRB,2.9954E-05_JPRB,2.6979E-05_JPRB,2.0685E-05_JPRB,1.0779E-05_JPRB/)
KBO( :, 4,43, 6) = (/&
&3.0048E-05_JPRB,3.9293E-05_JPRB,3.5311E-05_JPRB,2.6968E-05_JPRB,1.2697E-05_JPRB/)
KBO( :, 5,43, 6) = (/&
&3.8860E-05_JPRB,5.0338E-05_JPRB,4.5183E-05_JPRB,3.4410E-05_JPRB,1.4806E-05_JPRB/)
KBO( :, 1,44, 6) = (/&
&8.5348E-06_JPRB,1.1792E-05_JPRB,1.0825E-05_JPRB,8.5515E-06_JPRB,5.5871E-06_JPRB/)
KBO( :, 2,44, 6) = (/&
&1.2224E-05_JPRB,1.6542E-05_JPRB,1.5023E-05_JPRB,1.1659E-05_JPRB,6.7947E-06_JPRB/)
KBO( :, 3,44, 6) = (/&
&1.6899E-05_JPRB,2.2521E-05_JPRB,2.0321E-05_JPRB,1.5633E-05_JPRB,8.1320E-06_JPRB/)
KBO( :, 4,44, 6) = (/&
&2.2637E-05_JPRB,2.9783E-05_JPRB,2.6801E-05_JPRB,2.0525E-05_JPRB,9.6227E-06_JPRB/)
KBO( :, 5,44, 6) = (/&
&2.9511E-05_JPRB,3.8437E-05_JPRB,3.4531E-05_JPRB,2.6356E-05_JPRB,1.1265E-05_JPRB/)
KBO( :, 1,45, 6) = (/&
&6.2053E-06_JPRB,8.6498E-06_JPRB,7.9828E-06_JPRB,6.3587E-06_JPRB,4.1355E-06_JPRB/)
KBO( :, 2,45, 6) = (/&
&8.9924E-06_JPRB,1.2274E-05_JPRB,1.1184E-05_JPRB,8.7228E-06_JPRB,5.0646E-06_JPRB/)
KBO( :, 3,45, 6) = (/&
&1.2577E-05_JPRB,1.6878E-05_JPRB,1.5263E-05_JPRB,1.1781E-05_JPRB,6.0980E-06_JPRB/)
KBO( :, 4,45, 6) = (/&
&1.7004E-05_JPRB,2.2510E-05_JPRB,2.0287E-05_JPRB,1.5579E-05_JPRB,7.2495E-06_JPRB/)
KBO( :, 5,45, 6) = (/&
&2.2345E-05_JPRB,2.9273E-05_JPRB,2.6327E-05_JPRB,2.0139E-05_JPRB,8.5241E-06_JPRB/)
KBO( :, 1,46, 6) = (/&
&4.4535E-06_JPRB,6.2663E-06_JPRB,5.8215E-06_JPRB,4.6847E-06_JPRB,3.0403E-06_JPRB/)
KBO( :, 2,46, 6) = (/&
&6.5386E-06_JPRB,9.0087E-06_JPRB,8.2383E-06_JPRB,6.4650E-06_JPRB,3.7495E-06_JPRB/)
KBO( :, 3,46, 6) = (/&
&9.2626E-06_JPRB,1.2523E-05_JPRB,1.1353E-05_JPRB,8.7958E-06_JPRB,4.5455E-06_JPRB/)
KBO( :, 4,46, 6) = (/&
&1.2652E-05_JPRB,1.6866E-05_JPRB,1.5224E-05_JPRB,1.1726E-05_JPRB,5.4324E-06_JPRB/)
KBO( :, 5,46, 6) = (/&
&1.6782E-05_JPRB,2.2115E-05_JPRB,1.9910E-05_JPRB,1.5271E-05_JPRB,6.4154E-06_JPRB/)
KBO( :, 1,47, 6) = (/&
&3.1255E-06_JPRB,4.4445E-06_JPRB,4.1625E-06_JPRB,3.3973E-06_JPRB,2.2248E-06_JPRB/)
KBO( :, 2,47, 6) = (/&
&4.6607E-06_JPRB,6.4871E-06_JPRB,5.9609E-06_JPRB,4.7149E-06_JPRB,2.7633E-06_JPRB/)
KBO( :, 3,47, 6) = (/&
&6.6996E-06_JPRB,9.1349E-06_JPRB,8.3072E-06_JPRB,6.4651E-06_JPRB,3.3751E-06_JPRB/)
KBO( :, 4,47, 6) = (/&
&9.2705E-06_JPRB,1.2449E-05_JPRB,1.1256E-05_JPRB,8.6999E-06_JPRB,4.0582E-06_JPRB/)
KBO( :, 5,47, 6) = (/&
&1.2429E-05_JPRB,1.6480E-05_JPRB,1.4854E-05_JPRB,1.1428E-05_JPRB,4.8166E-06_JPRB/)
KBO( :, 1,48, 6) = (/&
&2.1776E-06_JPRB,3.1287E-06_JPRB,2.9593E-06_JPRB,2.4588E-06_JPRB,1.6162E-06_JPRB/)
KBO( :, 2,48, 6) = (/&
&3.3004E-06_JPRB,4.6424E-06_JPRB,4.2915E-06_JPRB,3.4279E-06_JPRB,2.0216E-06_JPRB/)
KBO( :, 3,48, 6) = (/&
&4.8178E-06_JPRB,6.6317E-06_JPRB,6.0512E-06_JPRB,4.7347E-06_JPRB,2.4869E-06_JPRB/)
KBO( :, 4,48, 6) = (/&
&6.7632E-06_JPRB,9.1507E-06_JPRB,8.2914E-06_JPRB,6.4284E-06_JPRB,3.0099E-06_JPRB/)
KBO( :, 5,48, 6) = (/&
&9.1697E-06_JPRB,1.2234E-05_JPRB,1.1042E-05_JPRB,8.5224E-06_JPRB,3.5919E-06_JPRB/)
KBO( :, 1,49, 6) = (/&
&1.5053E-06_JPRB,2.1858E-06_JPRB,2.0909E-06_JPRB,1.7774E-06_JPRB,1.1638E-06_JPRB/)
KBO( :, 2,49, 6) = (/&
&2.3208E-06_JPRB,3.3001E-06_JPRB,3.0741E-06_JPRB,2.4849E-06_JPRB,1.4655E-06_JPRB/)
KBO( :, 3,49, 6) = (/&
&3.4426E-06_JPRB,4.7874E-06_JPRB,4.3858E-06_JPRB,3.4542E-06_JPRB,1.8145E-06_JPRB/)
KBO( :, 4,49, 6) = (/&
&4.9073E-06_JPRB,6.6937E-06_JPRB,6.0798E-06_JPRB,4.7299E-06_JPRB,2.2116E-06_JPRB/)
KBO( :, 5,49, 6) = (/&
&6.7349E-06_JPRB,9.0453E-06_JPRB,8.1769E-06_JPRB,6.3309E-06_JPRB,2.6545E-06_JPRB/)
KBO( :, 1,50, 6) = (/&
&1.0462E-06_JPRB,1.5340E-06_JPRB,1.4848E-06_JPRB,1.2964E-06_JPRB,8.5273E-07_JPRB/)
KBO( :, 2,50, 6) = (/&
&1.6402E-06_JPRB,2.3557E-06_JPRB,2.2124E-06_JPRB,1.8137E-06_JPRB,1.0799E-06_JPRB/)
KBO( :, 3,50, 6) = (/&
&2.4709E-06_JPRB,3.4712E-06_JPRB,3.1941E-06_JPRB,2.5342E-06_JPRB,1.3448E-06_JPRB/)
KBO( :, 4,50, 6) = (/&
&3.5758E-06_JPRB,4.9168E-06_JPRB,4.4776E-06_JPRB,3.4964E-06_JPRB,1.6496E-06_JPRB/)
KBO( :, 5,50, 6) = (/&
&4.9702E-06_JPRB,6.7202E-06_JPRB,6.0835E-06_JPRB,4.7222E-06_JPRB,1.9912E-06_JPRB/)
KBO( :, 1,51, 6) = (/&
&7.2663E-07_JPRB,1.0750E-06_JPRB,1.0542E-06_JPRB,9.5059E-07_JPRB,6.2987E-07_JPRB/)
KBO( :, 2,51, 6) = (/&
&1.1582E-06_JPRB,1.6789E-06_JPRB,1.5910E-06_JPRB,1.3276E-06_JPRB,8.0106E-07_JPRB/)
KBO( :, 3,51, 6) = (/&
&1.7719E-06_JPRB,2.5144E-06_JPRB,2.3267E-06_JPRB,1.8622E-06_JPRB,1.0033E-06_JPRB/)
KBO( :, 4,51, 6) = (/&
&2.6046E-06_JPRB,3.6115E-06_JPRB,3.2983E-06_JPRB,2.5872E-06_JPRB,1.2381E-06_JPRB/)
KBO( :, 5,51, 6) = (/&
&3.6697E-06_JPRB,4.9945E-06_JPRB,4.5288E-06_JPRB,3.5236E-06_JPRB,1.5031E-06_JPRB/)
KBO( :, 1,52, 6) = (/&
&5.0128E-07_JPRB,7.4829E-07_JPRB,7.4503E-07_JPRB,6.9902E-07_JPRB,4.6417E-07_JPRB/)
KBO( :, 2,52, 6) = (/&
&8.1290E-07_JPRB,1.1889E-06_JPRB,1.1383E-06_JPRB,9.7075E-07_JPRB,5.9124E-07_JPRB/)
KBO( :, 3,52, 6) = (/&
&1.2637E-06_JPRB,1.8111E-06_JPRB,1.6874E-06_JPRB,1.3654E-06_JPRB,7.4485E-07_JPRB/)
KBO( :, 4,52, 6) = (/&
&1.8870E-06_JPRB,2.6414E-06_JPRB,2.4208E-06_JPRB,1.9088E-06_JPRB,9.2398E-07_JPRB/)
KBO( :, 5,52, 6) = (/&
&2.6982E-06_JPRB,3.6981E-06_JPRB,3.3605E-06_JPRB,2.6209E-06_JPRB,1.1284E-06_JPRB/)
KBO( :, 1,53, 6) = (/&
&3.4316E-07_JPRB,5.1730E-07_JPRB,5.2428E-07_JPRB,5.1650E-07_JPRB,3.4163E-07_JPRB/)
KBO( :, 2,53, 6) = (/&
&5.6636E-07_JPRB,8.3600E-07_JPRB,8.0988E-07_JPRB,7.0959E-07_JPRB,4.3402E-07_JPRB/)
KBO( :, 3,53, 6) = (/&
&8.9539E-07_JPRB,1.2957E-06_JPRB,1.2170E-06_JPRB,9.9881E-07_JPRB,5.4917E-07_JPRB/)
KBO( :, 4,53, 6) = (/&
&1.3585E-06_JPRB,1.9213E-06_JPRB,1.7681E-06_JPRB,1.4039E-06_JPRB,6.8487E-07_JPRB/)
KBO( :, 5,53, 6) = (/&
&1.9728E-06_JPRB,2.7267E-06_JPRB,2.4840E-06_JPRB,1.9431E-06_JPRB,8.4127E-07_JPRB/)
KBO( :, 1,54, 6) = (/&
&2.3729E-07_JPRB,3.6141E-07_JPRB,3.7346E-07_JPRB,3.8814E-07_JPRB,2.5965E-07_JPRB/)
KBO( :, 2,54, 6) = (/&
&3.9847E-07_JPRB,5.9281E-07_JPRB,5.8145E-07_JPRB,5.2497E-07_JPRB,3.2865E-07_JPRB/)
KBO( :, 3,54, 6) = (/&
&6.4012E-07_JPRB,9.3418E-07_JPRB,8.8451E-07_JPRB,7.3760E-07_JPRB,4.1726E-07_JPRB/)
KBO( :, 4,54, 6) = (/&
&9.8548E-07_JPRB,1.4072E-06_JPRB,1.3009E-06_JPRB,1.0414E-06_JPRB,5.2304E-07_JPRB/)
KBO( :, 5,54, 6) = (/&
&1.4524E-06_JPRB,2.0243E-06_JPRB,1.8490E-06_JPRB,1.4514E-06_JPRB,6.4582E-07_JPRB/)
KBO( :, 1,55, 6) = (/&
&1.6422E-07_JPRB,2.5313E-07_JPRB,2.6741E-07_JPRB,2.9555E-07_JPRB,2.0083E-07_JPRB/)
KBO( :, 2,55, 6) = (/&
&2.8085E-07_JPRB,4.2089E-07_JPRB,4.1847E-07_JPRB,3.9112E-07_JPRB,2.5331E-07_JPRB/)
KBO( :, 3,55, 6) = (/&
&4.5840E-07_JPRB,6.7405E-07_JPRB,6.4380E-07_JPRB,5.4696E-07_JPRB,3.2245E-07_JPRB/)
KBO( :, 4,55, 6) = (/&
&7.1591E-07_JPRB,1.0314E-06_JPRB,9.5879E-07_JPRB,7.7462E-07_JPRB,4.0636E-07_JPRB/)
KBO( :, 5,55, 6) = (/&
&1.0707E-06_JPRB,1.5050E-06_JPRB,1.3785E-06_JPRB,1.0868E-06_JPRB,5.0407E-07_JPRB/)
KBO( :, 1,56, 6) = (/&
&1.1297E-07_JPRB,1.7654E-07_JPRB,1.9160E-07_JPRB,2.2785E-07_JPRB,1.5600E-07_JPRB/)
KBO( :, 2,56, 6) = (/&
&1.9687E-07_JPRB,2.9736E-07_JPRB,3.0024E-07_JPRB,2.9250E-07_JPRB,1.9557E-07_JPRB/)
KBO( :, 3,56, 6) = (/&
&3.2655E-07_JPRB,4.8379E-07_JPRB,4.6673E-07_JPRB,4.0545E-07_JPRB,2.4926E-07_JPRB/)
KBO( :, 4,56, 6) = (/&
&5.1776E-07_JPRB,7.5239E-07_JPRB,7.0397E-07_JPRB,5.7515E-07_JPRB,3.1570E-07_JPRB/)
KBO( :, 5,56, 6) = (/&
&7.8583E-07_JPRB,1.1146E-06_JPRB,1.0242E-06_JPRB,8.1180E-07_JPRB,3.9355E-07_JPRB/)
KBO( :, 1,57, 6) = (/&
&7.7200E-08_JPRB,1.2264E-07_JPRB,1.3766E-07_JPRB,1.7856E-07_JPRB,1.2187E-07_JPRB/)
KBO( :, 2,57, 6) = (/&
&1.3715E-07_JPRB,2.0905E-07_JPRB,2.1488E-07_JPRB,2.1998E-07_JPRB,1.5127E-07_JPRB/)
KBO( :, 3,57, 6) = (/&
&2.3136E-07_JPRB,3.4526E-07_JPRB,3.3687E-07_JPRB,3.0067E-07_JPRB,1.9276E-07_JPRB/)
KBO( :, 4,57, 6) = (/&
&3.7265E-07_JPRB,5.4598E-07_JPRB,5.1453E-07_JPRB,4.2632E-07_JPRB,2.4529E-07_JPRB/)
KBO( :, 5,57, 6) = (/&
&5.7396E-07_JPRB,8.2172E-07_JPRB,7.5794E-07_JPRB,6.0477E-07_JPRB,3.0747E-07_JPRB/)
KBO( :, 1,58, 6) = (/&
&5.2955E-08_JPRB,8.5764E-08_JPRB,1.0017E-07_JPRB,1.4310E-07_JPRB,9.6433E-08_JPRB/)
KBO( :, 2,58, 6) = (/&
&9.5831E-08_JPRB,1.4757E-07_JPRB,1.5479E-07_JPRB,1.6745E-07_JPRB,1.1819E-07_JPRB/)
KBO( :, 3,58, 6) = (/&
&1.6444E-07_JPRB,2.4707E-07_JPRB,2.4397E-07_JPRB,2.2463E-07_JPRB,1.5059E-07_JPRB/)
KBO( :, 4,58, 6) = (/&
&2.6896E-07_JPRB,3.9698E-07_JPRB,3.7706E-07_JPRB,3.1744E-07_JPRB,1.9236E-07_JPRB/)
KBO( :, 5,58, 6) = (/&
&4.2027E-07_JPRB,6.0686E-07_JPRB,5.6217E-07_JPRB,4.5216E-07_JPRB,2.4243E-07_JPRB/)
KBO( :, 1,59, 6) = (/&
&4.0613E-08_JPRB,6.6330E-08_JPRB,7.8756E-08_JPRB,1.1682E-07_JPRB,8.0763E-08_JPRB/)
KBO( :, 2,59, 6) = (/&
&7.4110E-08_JPRB,1.1464E-07_JPRB,1.2119E-07_JPRB,1.3394E-07_JPRB,1.0024E-07_JPRB/)
KBO( :, 3,59, 6) = (/&
&1.2825E-07_JPRB,1.9327E-07_JPRB,1.9161E-07_JPRB,1.7847E-07_JPRB,1.2887E-07_JPRB/)
KBO( :, 4,59, 6) = (/&
&2.1125E-07_JPRB,3.1279E-07_JPRB,2.9779E-07_JPRB,2.5217E-07_JPRB,1.6539E-07_JPRB/)
KBO( :, 5,59, 6) = (/&
&3.3221E-07_JPRB,4.8128E-07_JPRB,4.4648E-07_JPRB,3.6014E-07_JPRB,2.0916E-07_JPRB/)
KBO( :, 1,13, 7) = (/&
&4.0082E-03_JPRB,4.7471E-03_JPRB,4.2106E-03_JPRB,3.3097E-03_JPRB,2.9797E-02_JPRB/)
KBO( :, 2,13, 7) = (/&
&5.4956E-03_JPRB,6.4503E-03_JPRB,5.6741E-03_JPRB,4.3606E-03_JPRB,3.3076E-02_JPRB/)
KBO( :, 3,13, 7) = (/&
&7.3201E-03_JPRB,8.5434E-03_JPRB,7.4724E-03_JPRB,5.6899E-03_JPRB,3.6718E-02_JPRB/)
KBO( :, 4,13, 7) = (/&
&9.4768E-03_JPRB,1.1006E-02_JPRB,9.6490E-03_JPRB,7.3607E-03_JPRB,4.0562E-02_JPRB/)
KBO( :, 5,13, 7) = (/&
&1.2016E-02_JPRB,1.3883E-02_JPRB,1.2248E-02_JPRB,9.4126E-03_JPRB,4.4607E-02_JPRB/)
KBO( :, 1,14, 7) = (/&
&3.5182E-03_JPRB,4.1440E-03_JPRB,3.6712E-03_JPRB,2.8865E-03_JPRB,2.5106E-02_JPRB/)
KBO( :, 2,14, 7) = (/&
&4.8368E-03_JPRB,5.6585E-03_JPRB,4.9763E-03_JPRB,3.8241E-03_JPRB,2.8178E-02_JPRB/)
KBO( :, 3,14, 7) = (/&
&6.4391E-03_JPRB,7.4926E-03_JPRB,6.5797E-03_JPRB,5.0127E-03_JPRB,3.1499E-02_JPRB/)
KBO( :, 4,14, 7) = (/&
&8.3556E-03_JPRB,9.6590E-03_JPRB,8.4959E-03_JPRB,6.4956E-03_JPRB,3.4983E-02_JPRB/)
KBO( :, 5,14, 7) = (/&
&1.0636E-02_JPRB,1.2197E-02_JPRB,1.0778E-02_JPRB,8.2927E-03_JPRB,3.8677E-02_JPRB/)
KBO( :, 1,15, 7) = (/&
&3.0808E-03_JPRB,3.6180E-03_JPRB,3.2024E-03_JPRB,2.5077E-03_JPRB,2.0133E-02_JPRB/)
KBO( :, 2,15, 7) = (/&
&4.2342E-03_JPRB,4.9408E-03_JPRB,4.3573E-03_JPRB,3.3447E-03_JPRB,2.2811E-02_JPRB/)
KBO( :, 3,15, 7) = (/&
&5.6484E-03_JPRB,6.5425E-03_JPRB,5.7598E-03_JPRB,4.4050E-03_JPRB,2.5648E-02_JPRB/)
KBO( :, 4,15, 7) = (/&
&7.3569E-03_JPRB,8.4459E-03_JPRB,7.4478E-03_JPRB,5.6997E-03_JPRB,2.8633E-02_JPRB/)
KBO( :, 5,15, 7) = (/&
&9.4079E-03_JPRB,1.0695E-02_JPRB,9.4525E-03_JPRB,7.2671E-03_JPRB,3.1750E-02_JPRB/)
KBO( :, 1,16, 7) = (/&
&2.6937E-03_JPRB,3.1581E-03_JPRB,2.7980E-03_JPRB,2.1775E-03_JPRB,1.5394E-02_JPRB/)
KBO( :, 2,16, 7) = (/&
&3.7085E-03_JPRB,4.3109E-03_JPRB,3.8048E-03_JPRB,2.9219E-03_JPRB,1.7507E-02_JPRB/)
KBO( :, 3,16, 7) = (/&
&4.9609E-03_JPRB,5.7164E-03_JPRB,5.0355E-03_JPRB,3.8483E-03_JPRB,1.9730E-02_JPRB/)
KBO( :, 4,16, 7) = (/&
&6.4895E-03_JPRB,7.4002E-03_JPRB,6.5219E-03_JPRB,4.9806E-03_JPRB,2.2084E-02_JPRB/)
KBO( :, 5,16, 7) = (/&
&8.3163E-03_JPRB,9.4051E-03_JPRB,8.2914E-03_JPRB,6.3525E-03_JPRB,2.4551E-02_JPRB/)
KBO( :, 1,17, 7) = (/&
&2.3642E-03_JPRB,2.7668E-03_JPRB,2.4489E-03_JPRB,1.8988E-03_JPRB,1.1868E-02_JPRB/)
KBO( :, 2,17, 7) = (/&
&3.2598E-03_JPRB,3.7811E-03_JPRB,3.3290E-03_JPRB,2.5510E-03_JPRB,1.3559E-02_JPRB/)
KBO( :, 3,17, 7) = (/&
&4.3747E-03_JPRB,5.0202E-03_JPRB,4.4155E-03_JPRB,3.3613E-03_JPRB,1.5340E-02_JPRB/)
KBO( :, 4,17, 7) = (/&
&5.7340E-03_JPRB,6.5189E-03_JPRB,5.7286E-03_JPRB,4.3538E-03_JPRB,1.7220E-02_JPRB/)
KBO( :, 5,17, 7) = (/&
&7.3600E-03_JPRB,8.2990E-03_JPRB,7.2992E-03_JPRB,5.5548E-03_JPRB,1.9205E-02_JPRB/)
KBO( :, 1,18, 7) = (/&
&2.0898E-03_JPRB,2.4405E-03_JPRB,2.1542E-03_JPRB,1.6626E-03_JPRB,9.4417E-03_JPRB/)
KBO( :, 2,18, 7) = (/&
&2.8863E-03_JPRB,3.3353E-03_JPRB,2.9318E-03_JPRB,2.2352E-03_JPRB,1.0813E-02_JPRB/)
KBO( :, 3,18, 7) = (/&
&3.8771E-03_JPRB,4.4358E-03_JPRB,3.8935E-03_JPRB,2.9472E-03_JPRB,1.2260E-02_JPRB/)
KBO( :, 4,18, 7) = (/&
&5.0839E-03_JPRB,5.7663E-03_JPRB,5.0610E-03_JPRB,3.8229E-03_JPRB,1.3797E-02_JPRB/)
KBO( :, 5,18, 7) = (/&
&6.5362E-03_JPRB,7.3472E-03_JPRB,6.4549E-03_JPRB,4.8781E-03_JPRB,1.5427E-02_JPRB/)
KBO( :, 1,19, 7) = (/&
&1.8517E-03_JPRB,2.1548E-03_JPRB,1.8965E-03_JPRB,1.4580E-03_JPRB,7.7773E-03_JPRB/)
KBO( :, 2,19, 7) = (/&
&2.5576E-03_JPRB,2.9471E-03_JPRB,2.5846E-03_JPRB,1.9612E-03_JPRB,8.9176E-03_JPRB/)
KBO( :, 3,19, 7) = (/&
&3.4345E-03_JPRB,3.9244E-03_JPRB,3.4362E-03_JPRB,2.5906E-03_JPRB,1.0132E-02_JPRB/)
KBO( :, 4,19, 7) = (/&
&4.5064E-03_JPRB,5.0994E-03_JPRB,4.4700E-03_JPRB,3.3642E-03_JPRB,1.1431E-02_JPRB/)
KBO( :, 5,19, 7) = (/&
&5.8097E-03_JPRB,6.5083E-03_JPRB,5.7046E-03_JPRB,4.2905E-03_JPRB,1.2808E-02_JPRB/)
KBO( :, 1,20, 7) = (/&
&1.6458E-03_JPRB,1.9103E-03_JPRB,1.6781E-03_JPRB,1.2831E-03_JPRB,6.5141E-03_JPRB/)
KBO( :, 2,20, 7) = (/&
&2.2698E-03_JPRB,2.6130E-03_JPRB,2.2877E-03_JPRB,1.7278E-03_JPRB,7.4849E-03_JPRB/)
KBO( :, 3,20, 7) = (/&
&3.0464E-03_JPRB,3.4772E-03_JPRB,3.0427E-03_JPRB,2.2845E-03_JPRB,8.5198E-03_JPRB/)
KBO( :, 4,20, 7) = (/&
&4.0053E-03_JPRB,4.5205E-03_JPRB,3.9563E-03_JPRB,2.9671E-03_JPRB,9.6230E-03_JPRB/)
KBO( :, 5,20, 7) = (/&
&5.1704E-03_JPRB,5.7875E-03_JPRB,5.0542E-03_JPRB,3.7806E-03_JPRB,1.0800E-02_JPRB/)
KBO( :, 1,21, 7) = (/&
&1.4548E-03_JPRB,1.6903E-03_JPRB,1.4830E-03_JPRB,1.1276E-03_JPRB,5.4461E-03_JPRB/)
KBO( :, 2,21, 7) = (/&
&2.0031E-03_JPRB,2.3102E-03_JPRB,2.0214E-03_JPRB,1.5202E-03_JPRB,6.2763E-03_JPRB/)
KBO( :, 3,21, 7) = (/&
&2.6919E-03_JPRB,3.0723E-03_JPRB,2.6854E-03_JPRB,2.0114E-03_JPRB,7.1636E-03_JPRB/)
KBO( :, 4,21, 7) = (/&
&3.5436E-03_JPRB,4.0040E-03_JPRB,3.4935E-03_JPRB,2.6088E-03_JPRB,8.1098E-03_JPRB/)
KBO( :, 5,21, 7) = (/&
&4.5742E-03_JPRB,5.1416E-03_JPRB,4.4723E-03_JPRB,3.3261E-03_JPRB,9.1112E-03_JPRB/)
KBO( :, 1,22, 7) = (/&
&1.3025E-03_JPRB,1.5176E-03_JPRB,1.3319E-03_JPRB,1.0078E-03_JPRB,4.4970E-03_JPRB/)
KBO( :, 2,22, 7) = (/&
&1.7911E-03_JPRB,2.0676E-03_JPRB,1.8104E-03_JPRB,1.3583E-03_JPRB,5.1953E-03_JPRB/)
KBO( :, 3,22, 7) = (/&
&2.4070E-03_JPRB,2.7511E-03_JPRB,2.4021E-03_JPRB,1.7933E-03_JPRB,5.9455E-03_JPRB/)
KBO( :, 4,22, 7) = (/&
&3.1635E-03_JPRB,3.5916E-03_JPRB,3.1285E-03_JPRB,2.3228E-03_JPRB,6.7435E-03_JPRB/)
KBO( :, 5,22, 7) = (/&
&4.0745E-03_JPRB,4.6107E-03_JPRB,4.0048E-03_JPRB,2.9650E-03_JPRB,7.5904E-03_JPRB/)
KBO( :, 1,23, 7) = (/&
&1.1628E-03_JPRB,1.3564E-03_JPRB,1.1911E-03_JPRB,9.0035E-04_JPRB,3.6865E-03_JPRB/)
KBO( :, 2,23, 7) = (/&
&1.5981E-03_JPRB,1.8458E-03_JPRB,1.6157E-03_JPRB,1.2111E-03_JPRB,4.2718E-03_JPRB/)
KBO( :, 3,23, 7) = (/&
&2.1434E-03_JPRB,2.4578E-03_JPRB,2.1451E-03_JPRB,1.5961E-03_JPRB,4.9004E-03_JPRB/)
KBO( :, 4,23, 7) = (/&
&2.8070E-03_JPRB,3.2089E-03_JPRB,2.7931E-03_JPRB,2.0693E-03_JPRB,5.5690E-03_JPRB/)
KBO( :, 5,23, 7) = (/&
&3.6060E-03_JPRB,4.1114E-03_JPRB,3.5718E-03_JPRB,2.6408E-03_JPRB,6.2767E-03_JPRB/)
KBO( :, 1,24, 7) = (/&
&1.0349E-03_JPRB,1.2079E-03_JPRB,1.0608E-03_JPRB,8.0145E-04_JPRB,2.9772E-03_JPRB/)
KBO( :, 2,24, 7) = (/&
&1.4200E-03_JPRB,1.6442E-03_JPRB,1.4384E-03_JPRB,1.0762E-03_JPRB,3.4619E-03_JPRB/)
KBO( :, 3,24, 7) = (/&
&1.8974E-03_JPRB,2.1881E-03_JPRB,1.9089E-03_JPRB,1.4192E-03_JPRB,3.9815E-03_JPRB/)
KBO( :, 4,24, 7) = (/&
&2.4779E-03_JPRB,2.8499E-03_JPRB,2.4818E-03_JPRB,1.8400E-03_JPRB,4.5322E-03_JPRB/)
KBO( :, 5,24, 7) = (/&
&3.1754E-03_JPRB,3.6385E-03_JPRB,3.1666E-03_JPRB,2.3457E-03_JPRB,5.1151E-03_JPRB/)
KBO( :, 1,25, 7) = (/&
&9.2232E-04_JPRB,1.0772E-03_JPRB,9.4524E-04_JPRB,7.1253E-04_JPRB,2.4032E-03_JPRB/)
KBO( :, 2,25, 7) = (/&
&1.2605E-03_JPRB,1.4648E-03_JPRB,1.2810E-03_JPRB,9.5673E-04_JPRB,2.8023E-03_JPRB/)
KBO( :, 3,25, 7) = (/&
&1.6782E-03_JPRB,1.9434E-03_JPRB,1.6961E-03_JPRB,1.2611E-03_JPRB,3.2283E-03_JPRB/)
KBO( :, 4,25, 7) = (/&
&2.1858E-03_JPRB,2.5220E-03_JPRB,2.1978E-03_JPRB,1.6329E-03_JPRB,3.6803E-03_JPRB/)
KBO( :, 5,25, 7) = (/&
&2.7953E-03_JPRB,3.2125E-03_JPRB,2.7973E-03_JPRB,2.0776E-03_JPRB,4.1586E-03_JPRB/)
KBO( :, 1,26, 7) = (/&
&8.2577E-04_JPRB,9.6602E-04_JPRB,8.4698E-04_JPRB,6.3651E-04_JPRB,1.9589E-03_JPRB/)
KBO( :, 2,26, 7) = (/&
&1.1231E-03_JPRB,1.3082E-03_JPRB,1.1442E-03_JPRB,8.5380E-04_JPRB,2.2874E-03_JPRB/)
KBO( :, 3,26, 7) = (/&
&1.4894E-03_JPRB,1.7283E-03_JPRB,1.5086E-03_JPRB,1.1231E-03_JPRB,2.6381E-03_JPRB/)
KBO( :, 4,26, 7) = (/&
&1.9347E-03_JPRB,2.2358E-03_JPRB,1.9486E-03_JPRB,1.4502E-03_JPRB,3.0100E-03_JPRB/)
KBO( :, 5,26, 7) = (/&
&2.4718E-03_JPRB,2.8431E-03_JPRB,2.4753E-03_JPRB,1.8399E-03_JPRB,3.4018E-03_JPRB/)
KBO( :, 1,27, 7) = (/&
&7.3643E-04_JPRB,8.6319E-04_JPRB,7.5644E-04_JPRB,5.6757E-04_JPRB,1.5698E-03_JPRB/)
KBO( :, 2,27, 7) = (/&
&9.9721E-04_JPRB,1.1634E-03_JPRB,1.0175E-03_JPRB,7.5949E-04_JPRB,1.8348E-03_JPRB/)
KBO( :, 3,27, 7) = (/&
&1.3189E-03_JPRB,1.5314E-03_JPRB,1.3364E-03_JPRB,9.9619E-04_JPRB,2.1183E-03_JPRB/)
KBO( :, 4,27, 7) = (/&
&1.7109E-03_JPRB,1.9771E-03_JPRB,1.7222E-03_JPRB,1.2827E-03_JPRB,2.4187E-03_JPRB/)
KBO( :, 5,27, 7) = (/&
&2.1861E-03_JPRB,2.5131E-03_JPRB,2.1851E-03_JPRB,1.6243E-03_JPRB,2.7339E-03_JPRB/)
KBO( :, 1,28, 7) = (/&
&6.5434E-04_JPRB,7.6837E-04_JPRB,6.7291E-04_JPRB,5.0480E-04_JPRB,1.2349E-03_JPRB/)
KBO( :, 2,28, 7) = (/&
&8.8335E-04_JPRB,1.0312E-03_JPRB,9.0136E-04_JPRB,6.7348E-04_JPRB,1.4454E-03_JPRB/)
KBO( :, 3,28, 7) = (/&
&1.1654E-03_JPRB,1.3544E-03_JPRB,1.1806E-03_JPRB,8.8065E-04_JPRB,1.6701E-03_JPRB/)
KBO( :, 4,28, 7) = (/&
&1.5130E-03_JPRB,1.7468E-03_JPRB,1.5197E-03_JPRB,1.1317E-03_JPRB,1.9084E-03_JPRB/)
KBO( :, 5,28, 7) = (/&
&1.9346E-03_JPRB,2.2214E-03_JPRB,1.9275E-03_JPRB,1.4311E-03_JPRB,2.1590E-03_JPRB/)
KBO( :, 1,29, 7) = (/&
&5.8250E-04_JPRB,6.8415E-04_JPRB,5.9900E-04_JPRB,4.4923E-04_JPRB,9.6138E-04_JPRB/)
KBO( :, 2,29, 7) = (/&
&7.8379E-04_JPRB,9.1559E-04_JPRB,7.9935E-04_JPRB,5.9724E-04_JPRB,1.1264E-03_JPRB/)
KBO( :, 3,29, 7) = (/&
&1.0337E-03_JPRB,1.2006E-03_JPRB,1.0452E-03_JPRB,7.7918E-04_JPRB,1.3027E-03_JPRB/)
KBO( :, 4,29, 7) = (/&
&1.3430E-03_JPRB,1.5485E-03_JPRB,1.3445E-03_JPRB,9.9943E-04_JPRB,1.4903E-03_JPRB/)
KBO( :, 5,29, 7) = (/&
&1.7207E-03_JPRB,1.9712E-03_JPRB,1.7058E-03_JPRB,1.2628E-03_JPRB,1.6874E-03_JPRB/)
KBO( :, 1,30, 7) = (/&
&5.1788E-04_JPRB,6.0851E-04_JPRB,5.3244E-04_JPRB,3.9922E-04_JPRB,7.3807E-04_JPRB/)
KBO( :, 2,30, 7) = (/&
&6.9560E-04_JPRB,8.1280E-04_JPRB,7.0896E-04_JPRB,5.2926E-04_JPRB,8.6555E-04_JPRB/)
KBO( :, 3,30, 7) = (/&
&9.1854E-04_JPRB,1.0653E-03_JPRB,9.2608E-04_JPRB,6.8944E-04_JPRB,1.0029E-03_JPRB/)
KBO( :, 4,30, 7) = (/&
&1.1948E-03_JPRB,1.3752E-03_JPRB,1.1917E-03_JPRB,8.8341E-04_JPRB,1.1491E-03_JPRB/)
KBO( :, 5,30, 7) = (/&
&1.5335E-03_JPRB,1.7547E-03_JPRB,1.5125E-03_JPRB,1.1162E-03_JPRB,1.3024E-03_JPRB/)
KBO( :, 1,31, 7) = (/&
&4.6092E-04_JPRB,5.4211E-04_JPRB,4.7408E-04_JPRB,3.5509E-04_JPRB,5.5682E-04_JPRB/)
KBO( :, 2,31, 7) = (/&
&6.1918E-04_JPRB,7.2321E-04_JPRB,6.3005E-04_JPRB,4.6997E-04_JPRB,6.5454E-04_JPRB/)
KBO( :, 3,31, 7) = (/&
&8.1881E-04_JPRB,9.4822E-04_JPRB,8.2290E-04_JPRB,6.1141E-04_JPRB,7.5997E-04_JPRB/)
KBO( :, 4,31, 7) = (/&
&1.0668E-03_JPRB,1.2267E-03_JPRB,1.0593E-03_JPRB,7.8292E-04_JPRB,8.7195E-04_JPRB/)
KBO( :, 5,31, 7) = (/&
&1.3704E-03_JPRB,1.5681E-03_JPRB,1.3465E-03_JPRB,9.8920E-04_JPRB,9.8973E-04_JPRB/)
KBO( :, 1,32, 7) = (/&
&4.1152E-04_JPRB,4.8409E-04_JPRB,4.2308E-04_JPRB,3.1645E-04_JPRB,4.2168E-04_JPRB/)
KBO( :, 2,32, 7) = (/&
&5.5334E-04_JPRB,6.4575E-04_JPRB,5.6167E-04_JPRB,4.1833E-04_JPRB,4.9677E-04_JPRB/)
KBO( :, 3,32, 7) = (/&
&7.3299E-04_JPRB,8.4766E-04_JPRB,7.3383E-04_JPRB,5.4370E-04_JPRB,5.7774E-04_JPRB/)
KBO( :, 4,32, 7) = (/&
&9.5588E-04_JPRB,1.0987E-03_JPRB,9.4586E-04_JPRB,6.9613E-04_JPRB,6.6384E-04_JPRB/)
KBO( :, 5,32, 7) = (/&
&1.2288E-03_JPRB,1.4065E-03_JPRB,1.2040E-03_JPRB,8.8013E-04_JPRB,7.5486E-04_JPRB/)
KBO( :, 1,33, 7) = (/&
&3.6854E-04_JPRB,4.3316E-04_JPRB,3.7817E-04_JPRB,2.8260E-04_JPRB,3.1899E-04_JPRB/)
KBO( :, 2,33, 7) = (/&
&4.9646E-04_JPRB,5.7816E-04_JPRB,5.0221E-04_JPRB,3.7315E-04_JPRB,3.7656E-04_JPRB/)
KBO( :, 3,33, 7) = (/&
&6.5808E-04_JPRB,7.6063E-04_JPRB,6.5667E-04_JPRB,4.8480E-04_JPRB,4.3876E-04_JPRB/)
KBO( :, 4,33, 7) = (/&
&8.5867E-04_JPRB,9.8782E-04_JPRB,8.4748E-04_JPRB,6.2133E-04_JPRB,5.0517E-04_JPRB/)
KBO( :, 5,33, 7) = (/&
&1.1037E-03_JPRB,1.2658E-03_JPRB,1.0801E-03_JPRB,7.8611E-04_JPRB,5.7532E-04_JPRB/)
KBO( :, 1,34, 7) = (/&
&3.2867E-04_JPRB,3.8572E-04_JPRB,3.3622E-04_JPRB,2.5071E-04_JPRB,2.4855E-04_JPRB/)
KBO( :, 2,34, 7) = (/&
&4.4343E-04_JPRB,5.1569E-04_JPRB,4.4686E-04_JPRB,3.3101E-04_JPRB,2.9381E-04_JPRB/)
KBO( :, 3,34, 7) = (/&
&5.8810E-04_JPRB,6.7990E-04_JPRB,5.8528E-04_JPRB,4.3031E-04_JPRB,3.4255E-04_JPRB/)
KBO( :, 4,34, 7) = (/&
&7.6737E-04_JPRB,8.8428E-04_JPRB,7.5640E-04_JPRB,5.5217E-04_JPRB,3.9478E-04_JPRB/)
KBO( :, 5,34, 7) = (/&
&9.8517E-04_JPRB,1.1342E-03_JPRB,9.6554E-04_JPRB,6.9951E-04_JPRB,4.5002E-04_JPRB/)
KBO( :, 1,35, 7) = (/&
&2.8513E-04_JPRB,3.3438E-04_JPRB,2.9108E-04_JPRB,2.1672E-04_JPRB,1.8974E-04_JPRB/)
KBO( :, 2,35, 7) = (/&
&3.8542E-04_JPRB,4.4857E-04_JPRB,3.8802E-04_JPRB,2.8661E-04_JPRB,2.2492E-04_JPRB/)
KBO( :, 3,35, 7) = (/&
&5.1208E-04_JPRB,5.9329E-04_JPRB,5.0967E-04_JPRB,3.7356E-04_JPRB,2.6284E-04_JPRB/)
KBO( :, 4,35, 7) = (/&
&6.6882E-04_JPRB,7.7366E-04_JPRB,6.6059E-04_JPRB,4.8046E-04_JPRB,3.0352E-04_JPRB/)
KBO( :, 5,35, 7) = (/&
&8.5775E-04_JPRB,9.9358E-04_JPRB,8.4548E-04_JPRB,6.1010E-04_JPRB,3.4691E-04_JPRB/)
KBO( :, 1,36, 7) = (/&
&2.3908E-04_JPRB,2.8086E-04_JPRB,2.4432E-04_JPRB,1.8172E-04_JPRB,1.4131E-04_JPRB/)
KBO( :, 2,36, 7) = (/&
&3.2447E-04_JPRB,3.7866E-04_JPRB,3.2729E-04_JPRB,2.4123E-04_JPRB,1.6828E-04_JPRB/)
KBO( :, 3,36, 7) = (/&
&4.3244E-04_JPRB,5.0306E-04_JPRB,4.3179E-04_JPRB,3.1573E-04_JPRB,1.9752E-04_JPRB/)
KBO( :, 4,36, 7) = (/&
&5.6587E-04_JPRB,6.5843E-04_JPRB,5.6206E-04_JPRB,4.0778E-04_JPRB,2.2899E-04_JPRB/)
KBO( :, 5,36, 7) = (/&
&7.2600E-04_JPRB,8.4746E-04_JPRB,7.2177E-04_JPRB,5.1967E-04_JPRB,2.6262E-04_JPRB/)
KBO( :, 1,37, 7) = (/&
&1.9223E-04_JPRB,2.2635E-04_JPRB,1.9687E-04_JPRB,1.4630E-04_JPRB,1.0794E-04_JPRB/)
KBO( :, 2,37, 7) = (/&
&2.6242E-04_JPRB,3.0724E-04_JPRB,2.6553E-04_JPRB,1.9547E-04_JPRB,1.2910E-04_JPRB/)
KBO( :, 3,37, 7) = (/&
&3.5150E-04_JPRB,4.1071E-04_JPRB,3.5262E-04_JPRB,2.5740E-04_JPRB,1.5213E-04_JPRB/)
KBO( :, 4,37, 7) = (/&
&4.6185E-04_JPRB,5.4051E-04_JPRB,4.6167E-04_JPRB,3.3450E-04_JPRB,1.7700E-04_JPRB/)
KBO( :, 5,37, 7) = (/&
&5.9416E-04_JPRB,6.9865E-04_JPRB,5.9573E-04_JPRB,4.2859E-04_JPRB,2.0366E-04_JPRB/)
KBO( :, 1,38, 7) = (/&
&1.5396E-04_JPRB,1.8186E-04_JPRB,1.5820E-04_JPRB,1.1745E-04_JPRB,8.2026E-05_JPRB/)
KBO( :, 2,38, 7) = (/&
&2.1139E-04_JPRB,2.4853E-04_JPRB,2.1486E-04_JPRB,1.5802E-04_JPRB,9.8555E-05_JPRB/)
KBO( :, 3,38, 7) = (/&
&2.8454E-04_JPRB,3.3433E-04_JPRB,2.8721E-04_JPRB,2.0943E-04_JPRB,1.1661E-04_JPRB/)
KBO( :, 4,38, 7) = (/&
&3.7538E-04_JPRB,4.4233E-04_JPRB,3.7835E-04_JPRB,2.7384E-04_JPRB,1.3622E-04_JPRB/)
KBO( :, 5,38, 7) = (/&
&4.8432E-04_JPRB,5.7425E-04_JPRB,4.9054E-04_JPRB,3.5276E-04_JPRB,1.5730E-04_JPRB/)
KBO( :, 1,39, 7) = (/&
&1.2310E-04_JPRB,1.4596E-04_JPRB,1.2703E-04_JPRB,9.4291E-05_JPRB,6.1783E-05_JPRB/)
KBO( :, 2,39, 7) = (/&
&1.6994E-04_JPRB,2.0085E-04_JPRB,1.7375E-04_JPRB,1.2772E-04_JPRB,7.4607E-05_JPRB/)
KBO( :, 3,39, 7) = (/&
&2.2988E-04_JPRB,2.7190E-04_JPRB,2.3385E-04_JPRB,1.7039E-04_JPRB,8.8689E-05_JPRB/)
KBO( :, 4,39, 7) = (/&
&3.0447E-04_JPRB,3.6157E-04_JPRB,3.0996E-04_JPRB,2.2416E-04_JPRB,1.0404E-04_JPRB/)
KBO( :, 5,39, 7) = (/&
&3.9383E-04_JPRB,4.7143E-04_JPRB,4.0364E-04_JPRB,2.9022E-04_JPRB,1.2062E-04_JPRB/)
KBO( :, 1,40, 7) = (/&
&9.5155E-05_JPRB,1.1332E-04_JPRB,9.8734E-05_JPRB,7.3344E-05_JPRB,4.6985E-05_JPRB/)
KBO( :, 2,40, 7) = (/&
&1.3236E-04_JPRB,1.5726E-04_JPRB,1.3621E-04_JPRB,1.0020E-04_JPRB,5.7054E-05_JPRB/)
KBO( :, 3,40, 7) = (/&
&1.8031E-04_JPRB,2.1454E-04_JPRB,1.8484E-04_JPRB,1.3474E-04_JPRB,6.8162E-05_JPRB/)
KBO( :, 4,40, 7) = (/&
&2.4017E-04_JPRB,2.8725E-04_JPRB,2.4684E-04_JPRB,1.7861E-04_JPRB,8.0321E-05_JPRB/)
KBO( :, 5,40, 7) = (/&
&3.1223E-04_JPRB,3.7700E-04_JPRB,3.2358E-04_JPRB,2.3279E-04_JPRB,9.3499E-05_JPRB/)
KBO( :, 1,41, 7) = (/&
&7.3040E-05_JPRB,8.7365E-05_JPRB,7.6219E-05_JPRB,5.6696E-05_JPRB,3.5628E-05_JPRB/)
KBO( :, 2,41, 7) = (/&
&1.0242E-04_JPRB,1.2231E-04_JPRB,1.0608E-04_JPRB,7.8149E-05_JPRB,4.3528E-05_JPRB/)
KBO( :, 3,41, 7) = (/&
&1.4051E-04_JPRB,1.6819E-04_JPRB,1.4521E-04_JPRB,1.0598E-04_JPRB,5.2277E-05_JPRB/)
KBO( :, 4,41, 7) = (/&
&1.8838E-04_JPRB,2.2688E-04_JPRB,1.9542E-04_JPRB,1.4156E-04_JPRB,6.1894E-05_JPRB/)
KBO( :, 5,41, 7) = (/&
&2.4622E-04_JPRB,2.9976E-04_JPRB,2.5798E-04_JPRB,1.8586E-04_JPRB,7.2357E-05_JPRB/)
KBO( :, 1,42, 7) = (/&
&5.5864E-05_JPRB,6.7119E-05_JPRB,5.8652E-05_JPRB,4.3719E-05_JPRB,2.6853E-05_JPRB/)
KBO( :, 2,42, 7) = (/&
&7.9009E-05_JPRB,9.4831E-05_JPRB,8.2368E-05_JPRB,6.0798E-05_JPRB,3.3017E-05_JPRB/)
KBO( :, 3,42, 7) = (/&
&1.0919E-04_JPRB,1.3143E-04_JPRB,1.1371E-04_JPRB,8.3133E-05_JPRB,3.9881E-05_JPRB/)
KBO( :, 4,42, 7) = (/&
&1.4736E-04_JPRB,1.7866E-04_JPRB,1.5424E-04_JPRB,1.1195E-04_JPRB,4.7449E-05_JPRB/)
KBO( :, 5,42, 7) = (/&
&1.9372E-04_JPRB,2.3766E-04_JPRB,2.0511E-04_JPRB,1.4803E-04_JPRB,5.5730E-05_JPRB/)
KBO( :, 1,43, 7) = (/&
&4.1761E-05_JPRB,5.0398E-05_JPRB,4.4130E-05_JPRB,3.2985E-05_JPRB,2.0073E-05_JPRB/)
KBO( :, 2,43, 7) = (/&
&5.9645E-05_JPRB,7.1916E-05_JPRB,6.2599E-05_JPRB,4.6330E-05_JPRB,2.4864E-05_JPRB/)
KBO( :, 3,43, 7) = (/&
&8.3194E-05_JPRB,1.0064E-04_JPRB,8.7232E-05_JPRB,6.3942E-05_JPRB,3.0235E-05_JPRB/)
KBO( :, 4,43, 7) = (/&
&1.1320E-04_JPRB,1.3803E-04_JPRB,1.1940E-04_JPRB,8.6870E-05_JPRB,3.6178E-05_JPRB/)
KBO( :, 5,43, 7) = (/&
&1.4992E-04_JPRB,1.8511E-04_JPRB,1.6011E-04_JPRB,1.1587E-04_JPRB,4.2707E-05_JPRB/)
KBO( :, 1,44, 7) = (/&
&3.0801E-05_JPRB,3.7349E-05_JPRB,3.2753E-05_JPRB,2.4577E-05_JPRB,1.4891E-05_JPRB/)
KBO( :, 2,44, 7) = (/&
&4.4487E-05_JPRB,5.3871E-05_JPRB,4.6990E-05_JPRB,3.4888E-05_JPRB,1.8592E-05_JPRB/)
KBO( :, 3,44, 7) = (/&
&6.2658E-05_JPRB,7.6156E-05_JPRB,6.6129E-05_JPRB,4.8623E-05_JPRB,2.2773E-05_JPRB/)
KBO( :, 4,44, 7) = (/&
&8.6061E-05_JPRB,1.0547E-04_JPRB,9.1388E-05_JPRB,6.6679E-05_JPRB,2.7431E-05_JPRB/)
KBO( :, 5,44, 7) = (/&
&1.1501E-04_JPRB,1.4274E-04_JPRB,1.2369E-04_JPRB,8.9747E-05_JPRB,3.2565E-05_JPRB/)
KBO( :, 1,45, 7) = (/&
&2.2608E-05_JPRB,2.7541E-05_JPRB,2.4185E-05_JPRB,1.8232E-05_JPRB,1.0958E-05_JPRB/)
KBO( :, 2,45, 7) = (/&
&3.3025E-05_JPRB,4.0159E-05_JPRB,3.5109E-05_JPRB,2.6156E-05_JPRB,1.3799E-05_JPRB/)
KBO( :, 3,45, 7) = (/&
&4.7011E-05_JPRB,5.7379E-05_JPRB,4.9919E-05_JPRB,3.6820E-05_JPRB,1.7031E-05_JPRB/)
KBO( :, 4,45, 7) = (/&
&6.5198E-05_JPRB,8.0265E-05_JPRB,6.9669E-05_JPRB,5.0975E-05_JPRB,2.0660E-05_JPRB/)
KBO( :, 5,45, 7) = (/&
&8.7915E-05_JPRB,1.0965E-04_JPRB,9.5159E-05_JPRB,6.9236E-05_JPRB,2.4675E-05_JPRB/)
KBO( :, 1,46, 7) = (/&
&1.6373E-05_JPRB,2.0043E-05_JPRB,1.7624E-05_JPRB,1.3360E-05_JPRB,7.9926E-06_JPRB/)
KBO( :, 2,46, 7) = (/&
&2.4216E-05_JPRB,2.9567E-05_JPRB,2.5903E-05_JPRB,1.9373E-05_JPRB,1.0160E-05_JPRB/)
KBO( :, 3,46, 7) = (/&
&3.4868E-05_JPRB,4.2722E-05_JPRB,3.7241E-05_JPRB,2.7564E-05_JPRB,1.2643E-05_JPRB/)
KBO( :, 4,46, 7) = (/&
&4.8882E-05_JPRB,6.0410E-05_JPRB,5.2522E-05_JPRB,3.8539E-05_JPRB,1.5455E-05_JPRB/)
KBO( :, 5,46, 7) = (/&
&6.6579E-05_JPRB,8.3392E-05_JPRB,7.2472E-05_JPRB,5.2864E-05_JPRB,1.8586E-05_JPRB/)
KBO( :, 1,47, 7) = (/&
&1.1599E-05_JPRB,1.4268E-05_JPRB,1.2567E-05_JPRB,9.5846E-06_JPRB,5.7865E-06_JPRB/)
KBO( :, 2,47, 7) = (/&
&1.7394E-05_JPRB,2.1321E-05_JPRB,1.8719E-05_JPRB,1.4063E-05_JPRB,7.4320E-06_JPRB/)
KBO( :, 3,47, 7) = (/&
&2.5375E-05_JPRB,3.1189E-05_JPRB,2.7244E-05_JPRB,2.0242E-05_JPRB,9.3345E-06_JPRB/)
KBO( :, 4,47, 7) = (/&
&3.6020E-05_JPRB,4.4624E-05_JPRB,3.8868E-05_JPRB,2.8612E-05_JPRB,1.1506E-05_JPRB/)
KBO( :, 5,47, 7) = (/&
&4.9650E-05_JPRB,6.2358E-05_JPRB,5.4247E-05_JPRB,3.9674E-05_JPRB,1.3945E-05_JPRB/)
KBO( :, 1,48, 7) = (/&
&8.1592E-06_JPRB,1.0088E-05_JPRB,8.9029E-06_JPRB,6.8352E-06_JPRB,4.1486E-06_JPRB/)
KBO( :, 2,48, 7) = (/&
&1.2414E-05_JPRB,1.5281E-05_JPRB,1.3442E-05_JPRB,1.0147E-05_JPRB,5.3865E-06_JPRB/)
KBO( :, 3,48, 7) = (/&
&1.8355E-05_JPRB,2.2636E-05_JPRB,1.9815E-05_JPRB,1.4784E-05_JPRB,6.8320E-06_JPRB/)
KBO( :, 4,48, 7) = (/&
&2.6399E-05_JPRB,3.2787E-05_JPRB,2.8606E-05_JPRB,2.1130E-05_JPRB,8.4972E-06_JPRB/)
KBO( :, 5,48, 7) = (/&
&3.6834E-05_JPRB,4.6374E-05_JPRB,4.0398E-05_JPRB,2.9623E-05_JPRB,1.0383E-05_JPRB/)
KBO( :, 1,49, 7) = (/&
&5.6950E-06_JPRB,7.0854E-06_JPRB,6.2658E-06_JPRB,4.8460E-06_JPRB,2.9411E-06_JPRB/)
KBO( :, 2,49, 7) = (/&
&8.8040E-06_JPRB,1.0880E-05_JPRB,9.5884E-06_JPRB,7.2776E-06_JPRB,3.8607E-06_JPRB/)
KBO( :, 3,49, 7) = (/&
&1.3194E-05_JPRB,1.6321E-05_JPRB,1.4323E-05_JPRB,1.0731E-05_JPRB,4.9471E-06_JPRB/)
KBO( :, 4,49, 7) = (/&
&1.9231E-05_JPRB,2.3945E-05_JPRB,2.0927E-05_JPRB,1.5515E-05_JPRB,6.2112E-06_JPRB/)
KBO( :, 5,49, 7) = (/&
&2.7183E-05_JPRB,3.4291E-05_JPRB,2.9917E-05_JPRB,2.1999E-05_JPRB,7.6566E-06_JPRB/)
KBO( :, 1,50, 7) = (/&
&3.9958E-06_JPRB,5.0015E-06_JPRB,4.4366E-06_JPRB,3.4585E-06_JPRB,2.1227E-06_JPRB/)
KBO( :, 2,50, 7) = (/&
&6.2784E-06_JPRB,7.7901E-06_JPRB,6.8759E-06_JPRB,5.2490E-06_JPRB,2.8123E-06_JPRB/)
KBO( :, 3,50, 7) = (/&
&9.5367E-06_JPRB,1.1828E-05_JPRB,1.0406E-05_JPRB,7.8273E-06_JPRB,3.6384E-06_JPRB/)
KBO( :, 4,50, 7) = (/&
&1.4076E-05_JPRB,1.7574E-05_JPRB,1.5384E-05_JPRB,1.1445E-05_JPRB,4.6069E-06_JPRB/)
KBO( :, 5,50, 7) = (/&
&2.0158E-05_JPRB,2.5470E-05_JPRB,2.2251E-05_JPRB,1.6406E-05_JPRB,5.7245E-06_JPRB/)
KBO( :, 1,51, 7) = (/&
&2.7988E-06_JPRB,3.5266E-06_JPRB,3.1403E-06_JPRB,2.4729E-06_JPRB,1.5428E-06_JPRB/)
KBO( :, 2,51, 7) = (/&
&4.4758E-06_JPRB,5.5781E-06_JPRB,4.9313E-06_JPRB,3.7868E-06_JPRB,2.0615E-06_JPRB/)
KBO( :, 3,51, 7) = (/&
&6.8951E-06_JPRB,8.5722E-06_JPRB,7.5560E-06_JPRB,5.7084E-06_JPRB,2.6915E-06_JPRB/)
KBO( :, 4,51, 7) = (/&
&1.0304E-05_JPRB,1.2894E-05_JPRB,1.1308E-05_JPRB,8.4393E-06_JPRB,3.4363E-06_JPRB/)
KBO( :, 5,51, 7) = (/&
&1.4945E-05_JPRB,1.8920E-05_JPRB,1.6546E-05_JPRB,1.2232E-05_JPRB,4.3031E-06_JPRB/)
KBO( :, 1,52, 7) = (/&
&1.9435E-06_JPRB,2.4685E-06_JPRB,2.2098E-06_JPRB,1.7634E-06_JPRB,1.1143E-06_JPRB/)
KBO( :, 2,52, 7) = (/&
&3.1695E-06_JPRB,3.9713E-06_JPRB,3.5183E-06_JPRB,2.7199E-06_JPRB,1.5011E-06_JPRB/)
KBO( :, 3,52, 7) = (/&
&4.9592E-06_JPRB,6.1828E-06_JPRB,5.4581E-06_JPRB,4.1434E-06_JPRB,1.9775E-06_JPRB/)
KBO( :, 4,52, 7) = (/&
&7.5082E-06_JPRB,9.4119E-06_JPRB,8.2722E-06_JPRB,6.1949E-06_JPRB,2.5467E-06_JPRB/)
KBO( :, 5,52, 7) = (/&
&1.1026E-05_JPRB,1.3984E-05_JPRB,1.2246E-05_JPRB,9.0780E-06_JPRB,3.2145E-06_JPRB/)
KBO( :, 1,53, 7) = (/&
&1.3359E-06_JPRB,1.7128E-06_JPRB,1.5439E-06_JPRB,1.2551E-06_JPRB,7.9874E-07_JPRB/)
KBO( :, 2,53, 7) = (/&
&2.2274E-06_JPRB,2.8086E-06_JPRB,2.4951E-06_JPRB,1.9446E-06_JPRB,1.0843E-06_JPRB/)
KBO( :, 3,53, 7) = (/&
&3.5445E-06_JPRB,4.4342E-06_JPRB,3.9206E-06_JPRB,2.9916E-06_JPRB,1.4407E-06_JPRB/)
KBO( :, 4,53, 7) = (/&
&5.4423E-06_JPRB,6.8307E-06_JPRB,6.0173E-06_JPRB,4.5231E-06_JPRB,1.8721E-06_JPRB/)
KBO( :, 5,53, 7) = (/&
&8.0931E-06_JPRB,1.0281E-05_JPRB,9.0168E-06_JPRB,6.7031E-06_JPRB,2.3821E-06_JPRB/)
KBO( :, 1,54, 7) = (/&
&9.2652E-07_JPRB,1.1988E-06_JPRB,1.0892E-06_JPRB,9.0472E-07_JPRB,5.9185E-07_JPRB/)
KBO( :, 2,54, 7) = (/&
&1.5791E-06_JPRB,2.0042E-06_JPRB,1.7864E-06_JPRB,1.4053E-06_JPRB,8.0903E-07_JPRB/)
KBO( :, 3,54, 7) = (/&
&2.5564E-06_JPRB,3.2106E-06_JPRB,2.8433E-06_JPRB,2.1812E-06_JPRB,1.0829E-06_JPRB/)
KBO( :, 4,54, 7) = (/&
&3.9810E-06_JPRB,5.0042E-06_JPRB,4.4158E-06_JPRB,3.3311E-06_JPRB,1.4179E-06_JPRB/)
KBO( :, 5,54, 7) = (/&
&5.9940E-06_JPRB,7.6213E-06_JPRB,6.6941E-06_JPRB,4.9908E-06_JPRB,1.8162E-06_JPRB/)
KBO( :, 1,55, 7) = (/&
&6.4271E-07_JPRB,8.3986E-07_JPRB,7.6969E-07_JPRB,6.5622E-07_JPRB,4.4680E-07_JPRB/)
KBO( :, 2,55, 7) = (/&
&1.1202E-06_JPRB,1.4315E-06_JPRB,1.2812E-06_JPRB,1.0198E-06_JPRB,6.1469E-07_JPRB/)
KBO( :, 3,55, 7) = (/&
&1.8463E-06_JPRB,2.3303E-06_JPRB,2.0672E-06_JPRB,1.5950E-06_JPRB,8.2848E-07_JPRB/)
KBO( :, 4,55, 7) = (/&
&2.9187E-06_JPRB,3.6752E-06_JPRB,3.2484E-06_JPRB,2.4593E-06_JPRB,1.0923E-06_JPRB/)
KBO( :, 5,55, 7) = (/&
&4.4490E-06_JPRB,5.6623E-06_JPRB,4.9799E-06_JPRB,3.7232E-06_JPRB,1.4079E-06_JPRB/)
KBO( :, 1,56, 7) = (/&
&4.4222E-07_JPRB,5.8443E-07_JPRB,5.4132E-07_JPRB,4.7675E-07_JPRB,3.3738E-07_JPRB/)
KBO( :, 2,56, 7) = (/&
&7.8907E-07_JPRB,1.0157E-06_JPRB,9.1377E-07_JPRB,7.3810E-07_JPRB,4.6671E-07_JPRB/)
KBO( :, 3,56, 7) = (/&
&1.3248E-06_JPRB,1.6819E-06_JPRB,1.4956E-06_JPRB,1.1622E-06_JPRB,6.3354E-07_JPRB/)
KBO( :, 4,56, 7) = (/&
&2.1296E-06_JPRB,2.6885E-06_JPRB,2.3793E-06_JPRB,1.8091E-06_JPRB,8.4125E-07_JPRB/)
KBO( :, 5,56, 7) = (/&
&3.2905E-06_JPRB,4.1906E-06_JPRB,3.6905E-06_JPRB,2.7667E-06_JPRB,1.0917E-06_JPRB/)
KBO( :, 1,57, 7) = (/&
&3.0166E-07_JPRB,4.0366E-07_JPRB,3.7890E-07_JPRB,3.4759E-07_JPRB,2.5495E-07_JPRB/)
KBO( :, 2,57, 7) = (/&
&5.5161E-07_JPRB,7.1542E-07_JPRB,6.4792E-07_JPRB,5.3334E-07_JPRB,3.5433E-07_JPRB/)
KBO( :, 3,57, 7) = (/&
&9.4470E-07_JPRB,1.2069E-06_JPRB,1.0761E-06_JPRB,8.4394E-07_JPRB,4.8446E-07_JPRB/)
KBO( :, 4,57, 7) = (/&
&1.5448E-06_JPRB,1.9571E-06_JPRB,1.7349E-06_JPRB,1.3257E-06_JPRB,6.4791E-07_JPRB/)
KBO( :, 5,57, 7) = (/&
&2.4231E-06_JPRB,3.0885E-06_JPRB,2.7246E-06_JPRB,2.0476E-06_JPRB,8.4650E-07_JPRB/)
KBO( :, 1,58, 7) = (/&
&2.0615E-07_JPRB,2.7966E-07_JPRB,2.6659E-07_JPRB,2.5672E-07_JPRB,1.9490E-07_JPRB/)
KBO( :, 2,58, 7) = (/&
&3.8634E-07_JPRB,5.0506E-07_JPRB,4.6082E-07_JPRB,3.8792E-07_JPRB,2.7193E-07_JPRB/)
KBO( :, 3,58, 7) = (/&
&6.7545E-07_JPRB,8.6794E-07_JPRB,7.7672E-07_JPRB,6.1534E-07_JPRB,3.7439E-07_JPRB/)
KBO( :, 4,58, 7) = (/&
&1.1229E-06_JPRB,1.4289E-06_JPRB,1.2690E-06_JPRB,9.7539E-07_JPRB,5.0417E-07_JPRB/)
KBO( :, 5,58, 7) = (/&
&1.7888E-06_JPRB,2.2841E-06_JPRB,2.0182E-06_JPRB,1.5209E-06_JPRB,6.6299E-07_JPRB/)
KBO( :, 1,59, 7) = (/&
&1.5864E-07_JPRB,2.1618E-07_JPRB,2.0732E-07_JPRB,2.0350E-07_JPRB,1.6565E-07_JPRB/)
KBO( :, 2,59, 7) = (/&
&3.0072E-07_JPRB,3.9451E-07_JPRB,3.6086E-07_JPRB,3.0632E-07_JPRB,2.3297E-07_JPRB/)
KBO( :, 3,59, 7) = (/&
&5.3103E-07_JPRB,6.8463E-07_JPRB,6.1355E-07_JPRB,4.8792E-07_JPRB,3.2258E-07_JPRB/)
KBO( :, 4,59, 7) = (/&
&8.9096E-07_JPRB,1.1377E-06_JPRB,1.0113E-06_JPRB,7.7874E-07_JPRB,4.3608E-07_JPRB/)
KBO( :, 5,59, 7) = (/&
&1.4311E-06_JPRB,1.8344E-06_JPRB,1.6214E-06_JPRB,1.2223E-06_JPRB,5.7456E-07_JPRB/)
KBO( :, 1,13, 8) = (/&
&1.1431E-02_JPRB,1.2741E-02_JPRB,1.1436E-02_JPRB,9.1621E-03_JPRB,8.0519E-02_JPRB/)
KBO( :, 2,13, 8) = (/&
&1.5206E-02_JPRB,1.7160E-02_JPRB,1.5555E-02_JPRB,1.2454E-02_JPRB,8.6864E-02_JPRB/)
KBO( :, 3,13, 8) = (/&
&1.9976E-02_JPRB,2.2722E-02_JPRB,2.0654E-02_JPRB,1.6502E-02_JPRB,9.4446E-02_JPRB/)
KBO( :, 4,13, 8) = (/&
&2.5954E-02_JPRB,2.9643E-02_JPRB,2.6781E-02_JPRB,2.1406E-02_JPRB,1.0333E-01_JPRB/)
KBO( :, 5,13, 8) = (/&
&3.3352E-02_JPRB,3.7953E-02_JPRB,3.4189E-02_JPRB,2.7277E-02_JPRB,1.1304E-01_JPRB/)
KBO( :, 1,14, 8) = (/&
&1.0179E-02_JPRB,1.1389E-02_JPRB,1.0176E-02_JPRB,8.0522E-03_JPRB,6.5504E-02_JPRB/)
KBO( :, 2,14, 8) = (/&
&1.3641E-02_JPRB,1.5355E-02_JPRB,1.3817E-02_JPRB,1.0906E-02_JPRB,7.2230E-02_JPRB/)
KBO( :, 3,14, 8) = (/&
&1.8023E-02_JPRB,2.0418E-02_JPRB,1.8352E-02_JPRB,1.4437E-02_JPRB,8.0150E-02_JPRB/)
KBO( :, 4,14, 8) = (/&
&2.3532E-02_JPRB,2.6705E-02_JPRB,2.3876E-02_JPRB,1.8758E-02_JPRB,8.9038E-02_JPRB/)
KBO( :, 5,14, 8) = (/&
&3.0239E-02_JPRB,3.4282E-02_JPRB,3.0614E-02_JPRB,2.4017E-02_JPRB,9.8577E-02_JPRB/)
KBO( :, 1,15, 8) = (/&
&9.0090E-03_JPRB,1.0120E-02_JPRB,9.0167E-03_JPRB,7.0764E-03_JPRB,5.2591E-02_JPRB/)
KBO( :, 2,15, 8) = (/&
&1.2186E-02_JPRB,1.3734E-02_JPRB,1.2258E-02_JPRB,9.5696E-03_JPRB,5.9402E-02_JPRB/)
KBO( :, 3,15, 8) = (/&
&1.6225E-02_JPRB,1.8333E-02_JPRB,1.6340E-02_JPRB,1.2688E-02_JPRB,6.7127E-02_JPRB/)
KBO( :, 4,15, 8) = (/&
&2.1185E-02_JPRB,2.4042E-02_JPRB,2.1332E-02_JPRB,1.6578E-02_JPRB,7.5512E-02_JPRB/)
KBO( :, 5,15, 8) = (/&
&2.7141E-02_JPRB,3.0928E-02_JPRB,2.7480E-02_JPRB,2.1333E-02_JPRB,8.4521E-02_JPRB/)
KBO( :, 1,16, 8) = (/&
&7.9666E-03_JPRB,8.9862E-03_JPRB,7.9671E-03_JPRB,6.2242E-03_JPRB,4.1294E-02_JPRB/)
KBO( :, 2,16, 8) = (/&
&1.0885E-02_JPRB,1.2270E-02_JPRB,1.0885E-02_JPRB,8.4303E-03_JPRB,4.7519E-02_JPRB/)
KBO( :, 3,16, 8) = (/&
&1.4511E-02_JPRB,1.6442E-02_JPRB,1.4544E-02_JPRB,1.1234E-02_JPRB,5.4415E-02_JPRB/)
KBO( :, 4,16, 8) = (/&
&1.8926E-02_JPRB,2.1554E-02_JPRB,1.9076E-02_JPRB,1.4750E-02_JPRB,6.1801E-02_JPRB/)
KBO( :, 5,16, 8) = (/&
&2.4236E-02_JPRB,2.7687E-02_JPRB,2.4633E-02_JPRB,1.9024E-02_JPRB,6.9624E-02_JPRB/)
KBO( :, 1,17, 8) = (/&
&7.1080E-03_JPRB,8.0147E-03_JPRB,7.0758E-03_JPRB,5.4873E-03_JPRB,3.3297E-02_JPRB/)
KBO( :, 2,17, 8) = (/&
&9.7388E-03_JPRB,1.0991E-02_JPRB,9.6940E-03_JPRB,7.4587E-03_JPRB,3.8754E-02_JPRB/)
KBO( :, 3,17, 8) = (/&
&1.2971E-02_JPRB,1.4712E-02_JPRB,1.2980E-02_JPRB,9.9806E-03_JPRB,4.4673E-02_JPRB/)
KBO( :, 4,17, 8) = (/&
&1.6920E-02_JPRB,1.9221E-02_JPRB,1.7037E-02_JPRB,1.3131E-02_JPRB,5.0878E-02_JPRB/)
KBO( :, 5,17, 8) = (/&
&2.1675E-02_JPRB,2.4688E-02_JPRB,2.1958E-02_JPRB,1.6944E-02_JPRB,5.7392E-02_JPRB/)
KBO( :, 1,18, 8) = (/&
&6.4048E-03_JPRB,7.2149E-03_JPRB,6.3423E-03_JPRB,4.8705E-03_JPRB,2.7610E-02_JPRB/)
KBO( :, 2,18, 8) = (/&
&8.7579E-03_JPRB,9.8929E-03_JPRB,8.6960E-03_JPRB,6.6399E-03_JPRB,3.2241E-02_JPRB/)
KBO( :, 3,18, 8) = (/&
&1.1674E-02_JPRB,1.3178E-02_JPRB,1.1614E-02_JPRB,8.8937E-03_JPRB,3.7151E-02_JPRB/)
KBO( :, 4,18, 8) = (/&
&1.5226E-02_JPRB,1.7183E-02_JPRB,1.5190E-02_JPRB,1.1678E-02_JPRB,4.2321E-02_JPRB/)
KBO( :, 5,18, 8) = (/&
&1.9521E-02_JPRB,2.2065E-02_JPRB,1.9536E-02_JPRB,1.5022E-02_JPRB,4.7759E-02_JPRB/)
KBO( :, 1,19, 8) = (/&
&5.7780E-03_JPRB,6.5097E-03_JPRB,5.7073E-03_JPRB,4.3362E-03_JPRB,2.3517E-02_JPRB/)
KBO( :, 2,19, 8) = (/&
&7.8980E-03_JPRB,8.8943E-03_JPRB,7.8019E-03_JPRB,5.9182E-03_JPRB,2.7464E-02_JPRB/)
KBO( :, 3,19, 8) = (/&
&1.0547E-02_JPRB,1.1813E-02_JPRB,1.0378E-02_JPRB,7.9082E-03_JPRB,3.1653E-02_JPRB/)
KBO( :, 4,19, 8) = (/&
&1.3780E-02_JPRB,1.5395E-02_JPRB,1.3544E-02_JPRB,1.0334E-02_JPRB,3.6068E-02_JPRB/)
KBO( :, 5,19, 8) = (/&
&1.7661E-02_JPRB,1.9769E-02_JPRB,1.7387E-02_JPRB,1.3263E-02_JPRB,4.0672E-02_JPRB/)
KBO( :, 1,20, 8) = (/&
&5.2358E-03_JPRB,5.8943E-03_JPRB,5.1609E-03_JPRB,3.8930E-03_JPRB,2.0265E-02_JPRB/)
KBO( :, 2,20, 8) = (/&
&7.1650E-03_JPRB,8.0337E-03_JPRB,7.0303E-03_JPRB,5.3009E-03_JPRB,2.3642E-02_JPRB/)
KBO( :, 3,20, 8) = (/&
&9.5768E-03_JPRB,1.0673E-02_JPRB,9.3270E-03_JPRB,7.0467E-03_JPRB,2.7210E-02_JPRB/)
KBO( :, 4,20, 8) = (/&
&1.2520E-02_JPRB,1.3910E-02_JPRB,1.2148E-02_JPRB,9.1772E-03_JPRB,3.0955E-02_JPRB/)
KBO( :, 5,20, 8) = (/&
&1.6054E-02_JPRB,1.7830E-02_JPRB,1.5571E-02_JPRB,1.1760E-02_JPRB,3.4856E-02_JPRB/)
KBO( :, 1,21, 8) = (/&
&4.7306E-03_JPRB,5.3228E-03_JPRB,4.6480E-03_JPRB,3.4934E-03_JPRB,1.7415E-02_JPRB/)
KBO( :, 2,21, 8) = (/&
&6.4837E-03_JPRB,7.2505E-03_JPRB,6.3214E-03_JPRB,4.7410E-03_JPRB,2.0248E-02_JPRB/)
KBO( :, 3,21, 8) = (/&
&8.6672E-03_JPRB,9.6479E-03_JPRB,8.3920E-03_JPRB,6.2776E-03_JPRB,2.3246E-02_JPRB/)
KBO( :, 4,21, 8) = (/&
&1.1340E-02_JPRB,1.2581E-02_JPRB,1.0918E-02_JPRB,8.1620E-03_JPRB,2.6397E-02_JPRB/)
KBO( :, 5,21, 8) = (/&
&1.4560E-02_JPRB,1.6102E-02_JPRB,1.3967E-02_JPRB,1.0440E-02_JPRB,2.9697E-02_JPRB/)
KBO( :, 1,22, 8) = (/&
&4.3418E-03_JPRB,4.8765E-03_JPRB,4.2505E-03_JPRB,3.1831E-03_JPRB,1.4725E-02_JPRB/)
KBO( :, 2,22, 8) = (/&
&5.9449E-03_JPRB,6.6380E-03_JPRB,5.7744E-03_JPRB,4.3038E-03_JPRB,1.7073E-02_JPRB/)
KBO( :, 3,22, 8) = (/&
&7.9389E-03_JPRB,8.8321E-03_JPRB,7.6615E-03_JPRB,5.6883E-03_JPRB,1.9560E-02_JPRB/)
KBO( :, 4,22, 8) = (/&
&1.0382E-02_JPRB,1.1507E-02_JPRB,9.9583E-03_JPRB,7.3808E-03_JPRB,2.2180E-02_JPRB/)
KBO( :, 5,22, 8) = (/&
&1.3348E-02_JPRB,1.4718E-02_JPRB,1.2724E-02_JPRB,9.4158E-03_JPRB,2.4942E-02_JPRB/)
KBO( :, 1,23, 8) = (/&
&3.9755E-03_JPRB,4.4601E-03_JPRB,3.8791E-03_JPRB,2.8940E-03_JPRB,1.2317E-02_JPRB/)
KBO( :, 2,23, 8) = (/&
&5.4326E-03_JPRB,6.0675E-03_JPRB,5.2649E-03_JPRB,3.9079E-03_JPRB,1.4261E-02_JPRB/)
KBO( :, 3,23, 8) = (/&
&7.2471E-03_JPRB,8.0652E-03_JPRB,6.9775E-03_JPRB,5.1609E-03_JPRB,1.6319E-02_JPRB/)
KBO( :, 4,23, 8) = (/&
&9.4853E-03_JPRB,1.0499E-02_JPRB,9.0669E-03_JPRB,6.6817E-03_JPRB,1.8494E-02_JPRB/)
KBO( :, 5,23, 8) = (/&
&1.2224E-02_JPRB,1.3433E-02_JPRB,1.1575E-02_JPRB,8.5016E-03_JPRB,2.0803E-02_JPRB/)
KBO( :, 1,24, 8) = (/&
&3.6237E-03_JPRB,4.0664E-03_JPRB,3.5327E-03_JPRB,2.6249E-03_JPRB,1.0111E-02_JPRB/)
KBO( :, 2,24, 8) = (/&
&4.9405E-03_JPRB,5.5284E-03_JPRB,4.7867E-03_JPRB,3.5422E-03_JPRB,1.1712E-02_JPRB/)
KBO( :, 3,24, 8) = (/&
&6.5941E-03_JPRB,7.3367E-03_JPRB,6.3412E-03_JPRB,4.6740E-03_JPRB,1.3407E-02_JPRB/)
KBO( :, 4,24, 8) = (/&
&8.6500E-03_JPRB,9.5582E-03_JPRB,8.2387E-03_JPRB,6.0413E-03_JPRB,1.5203E-02_JPRB/)
KBO( :, 5,24, 8) = (/&
&1.1160E-02_JPRB,1.2258E-02_JPRB,1.0518E-02_JPRB,7.6745E-03_JPRB,1.7120E-02_JPRB/)
KBO( :, 1,25, 8) = (/&
&3.2923E-03_JPRB,3.7097E-03_JPRB,3.2174E-03_JPRB,2.3852E-03_JPRB,8.2743E-03_JPRB/)
KBO( :, 2,25, 8) = (/&
&4.4868E-03_JPRB,5.0333E-03_JPRB,4.3547E-03_JPRB,3.2140E-03_JPRB,9.5864E-03_JPRB/)
KBO( :, 3,25, 8) = (/&
&6.0022E-03_JPRB,6.6817E-03_JPRB,5.7652E-03_JPRB,4.2348E-03_JPRB,1.0982E-02_JPRB/)
KBO( :, 4,25, 8) = (/&
&7.8855E-03_JPRB,8.7187E-03_JPRB,7.4913E-03_JPRB,5.4655E-03_JPRB,1.2469E-02_JPRB/)
KBO( :, 5,25, 8) = (/&
&1.0169E-02_JPRB,1.1196E-02_JPRB,9.5768E-03_JPRB,6.9385E-03_JPRB,1.4057E-02_JPRB/)
KBO( :, 1,26, 8) = (/&
&2.9966E-03_JPRB,3.3936E-03_JPRB,2.9435E-03_JPRB,2.1773E-03_JPRB,6.8226E-03_JPRB/)
KBO( :, 2,26, 8) = (/&
&4.0887E-03_JPRB,4.6003E-03_JPRB,3.9768E-03_JPRB,2.9281E-03_JPRB,7.9056E-03_JPRB/)
KBO( :, 3,26, 8) = (/&
&5.4745E-03_JPRB,6.1149E-03_JPRB,5.2640E-03_JPRB,3.8491E-03_JPRB,9.0607E-03_JPRB/)
KBO( :, 4,26, 8) = (/&
&7.1886E-03_JPRB,7.9856E-03_JPRB,6.8456E-03_JPRB,4.9643E-03_JPRB,1.0300E-02_JPRB/)
KBO( :, 5,26, 8) = (/&
&9.2596E-03_JPRB,1.0248E-02_JPRB,8.7489E-03_JPRB,6.3014E-03_JPRB,1.1624E-02_JPRB/)
KBO( :, 1,27, 8) = (/&
&2.7156E-03_JPRB,3.0876E-03_JPRB,2.6805E-03_JPRB,1.9822E-03_JPRB,5.5158E-03_JPRB/)
KBO( :, 2,27, 8) = (/&
&3.7104E-03_JPRB,4.1900E-03_JPRB,3.6215E-03_JPRB,2.6593E-03_JPRB,6.4001E-03_JPRB/)
KBO( :, 3,27, 8) = (/&
&4.9667E-03_JPRB,5.5771E-03_JPRB,4.8004E-03_JPRB,3.4928E-03_JPRB,7.3466E-03_JPRB/)
KBO( :, 4,27, 8) = (/&
&6.5120E-03_JPRB,7.2813E-03_JPRB,6.2396E-03_JPRB,4.5038E-03_JPRB,8.3626E-03_JPRB/)
KBO( :, 5,27, 8) = (/&
&8.3748E-03_JPRB,9.3312E-03_JPRB,7.9649E-03_JPRB,5.7101E-03_JPRB,9.4540E-03_JPRB/)
KBO( :, 1,28, 8) = (/&
&2.4540E-03_JPRB,2.8015E-03_JPRB,2.4332E-03_JPRB,1.7986E-03_JPRB,4.3717E-03_JPRB/)
KBO( :, 2,28, 8) = (/&
&3.3533E-03_JPRB,3.8065E-03_JPRB,3.2907E-03_JPRB,2.4104E-03_JPRB,5.0844E-03_JPRB/)
KBO( :, 3,28, 8) = (/&
&4.4816E-03_JPRB,5.0648E-03_JPRB,4.3611E-03_JPRB,3.1641E-03_JPRB,5.8491E-03_JPRB/)
KBO( :, 4,28, 8) = (/&
&5.8656E-03_JPRB,6.6059E-03_JPRB,5.6649E-03_JPRB,4.0783E-03_JPRB,6.6719E-03_JPRB/)
KBO( :, 5,28, 8) = (/&
&7.5375E-03_JPRB,8.4524E-03_JPRB,7.2181E-03_JPRB,5.1634E-03_JPRB,7.5534E-03_JPRB/)
KBO( :, 1,29, 8) = (/&
&2.2199E-03_JPRB,2.5468E-03_JPRB,2.2116E-03_JPRB,1.6320E-03_JPRB,3.4313E-03_JPRB/)
KBO( :, 2,29, 8) = (/&
&3.0284E-03_JPRB,3.4576E-03_JPRB,2.9908E-03_JPRB,2.1868E-03_JPRB,4.0007E-03_JPRB/)
KBO( :, 3,29, 8) = (/&
&4.0394E-03_JPRB,4.5959E-03_JPRB,3.9584E-03_JPRB,2.8693E-03_JPRB,4.6141E-03_JPRB/)
KBO( :, 4,29, 8) = (/&
&5.2804E-03_JPRB,5.9851E-03_JPRB,5.1333E-03_JPRB,3.6901E-03_JPRB,5.2723E-03_JPRB/)
KBO( :, 5,29, 8) = (/&
&6.7815E-03_JPRB,7.6482E-03_JPRB,6.5273E-03_JPRB,4.6670E-03_JPRB,5.9784E-03_JPRB/)
KBO( :, 1,30, 8) = (/&
&2.0046E-03_JPRB,2.3130E-03_JPRB,2.0090E-03_JPRB,1.4794E-03_JPRB,2.6543E-03_JPRB/)
KBO( :, 2,30, 8) = (/&
&2.7295E-03_JPRB,3.1369E-03_JPRB,2.7138E-03_JPRB,1.9812E-03_JPRB,3.1043E-03_JPRB/)
KBO( :, 3,30, 8) = (/&
&3.6356E-03_JPRB,4.1607E-03_JPRB,3.5841E-03_JPRB,2.5951E-03_JPRB,3.5892E-03_JPRB/)
KBO( :, 4,30, 8) = (/&
&4.7491E-03_JPRB,5.4103E-03_JPRB,4.6363E-03_JPRB,3.3323E-03_JPRB,4.1088E-03_JPRB/)
KBO( :, 5,30, 8) = (/&
&6.1030E-03_JPRB,6.9063E-03_JPRB,5.8950E-03_JPRB,4.2074E-03_JPRB,4.6673E-03_JPRB/)
KBO( :, 1,31, 8) = (/&
&1.8116E-03_JPRB,2.1021E-03_JPRB,1.8264E-03_JPRB,1.3426E-03_JPRB,2.0192E-03_JPRB/)
KBO( :, 2,31, 8) = (/&
&2.4626E-03_JPRB,2.8445E-03_JPRB,2.4615E-03_JPRB,1.7947E-03_JPRB,2.3682E-03_JPRB/)
KBO( :, 3,31, 8) = (/&
&3.2770E-03_JPRB,3.7680E-03_JPRB,3.2435E-03_JPRB,2.3454E-03_JPRB,2.7454E-03_JPRB/)
KBO( :, 4,31, 8) = (/&
&4.2825E-03_JPRB,4.8933E-03_JPRB,4.1907E-03_JPRB,3.0057E-03_JPRB,3.1516E-03_JPRB/)
KBO( :, 5,31, 8) = (/&
&5.5107E-03_JPRB,6.2496E-03_JPRB,5.3257E-03_JPRB,3.7889E-03_JPRB,3.5873E-03_JPRB/)
KBO( :, 1,32, 8) = (/&
&1.6409E-03_JPRB,1.9128E-03_JPRB,1.6615E-03_JPRB,1.2200E-03_JPRB,1.5399E-03_JPRB/)
KBO( :, 2,32, 8) = (/&
&2.2276E-03_JPRB,2.5834E-03_JPRB,2.2335E-03_JPRB,1.6257E-03_JPRB,1.8108E-03_JPRB/)
KBO( :, 3,32, 8) = (/&
&2.9642E-03_JPRB,3.4164E-03_JPRB,2.9366E-03_JPRB,2.1192E-03_JPRB,2.1049E-03_JPRB/)
KBO( :, 4,32, 8) = (/&
&3.8783E-03_JPRB,4.4382E-03_JPRB,3.7929E-03_JPRB,2.7120E-03_JPRB,2.4216E-03_JPRB/)
KBO( :, 5,32, 8) = (/&
&5.0008E-03_JPRB,5.6727E-03_JPRB,4.8212E-03_JPRB,3.4168E-03_JPRB,2.7630E-03_JPRB/)
KBO( :, 1,33, 8) = (/&
&1.4896E-03_JPRB,1.7425E-03_JPRB,1.5121E-03_JPRB,1.1085E-03_JPRB,1.1708E-03_JPRB/)
KBO( :, 2,33, 8) = (/&
&2.0219E-03_JPRB,2.3499E-03_JPRB,2.0274E-03_JPRB,1.4717E-03_JPRB,1.3798E-03_JPRB/)
KBO( :, 3,33, 8) = (/&
&2.6933E-03_JPRB,3.1059E-03_JPRB,2.6641E-03_JPRB,1.9145E-03_JPRB,1.6078E-03_JPRB/)
KBO( :, 4,33, 8) = (/&
&3.5312E-03_JPRB,4.0360E-03_JPRB,3.4383E-03_JPRB,2.4485E-03_JPRB,1.8549E-03_JPRB/)
KBO( :, 5,33, 8) = (/&
&4.5576E-03_JPRB,5.1702E-03_JPRB,4.3769E-03_JPRB,3.0873E-03_JPRB,2.1221E-03_JPRB/)
KBO( :, 1,34, 8) = (/&
&1.3461E-03_JPRB,1.5773E-03_JPRB,1.3654E-03_JPRB,9.9848E-04_JPRB,9.1828E-04_JPRB/)
KBO( :, 2,34, 8) = (/&
&1.8293E-03_JPRB,2.1264E-03_JPRB,1.8294E-03_JPRB,1.3224E-03_JPRB,1.0850E-03_JPRB/)
KBO( :, 3,34, 8) = (/&
&2.4421E-03_JPRB,2.8129E-03_JPRB,2.4038E-03_JPRB,1.7186E-03_JPRB,1.2670E-03_JPRB/)
KBO( :, 4,34, 8) = (/&
&3.2077E-03_JPRB,3.6631E-03_JPRB,3.1076E-03_JPRB,2.1997E-03_JPRB,1.4654E-03_JPRB/)
KBO( :, 5,34, 8) = (/&
&4.1521E-03_JPRB,4.7027E-03_JPRB,3.9614E-03_JPRB,2.7773E-03_JPRB,1.6801E-03_JPRB/)
KBO( :, 1,35, 8) = (/&
&1.1832E-03_JPRB,1.3882E-03_JPRB,1.1991E-03_JPRB,8.7402E-04_JPRB,7.0393E-04_JPRB/)
KBO( :, 2,35, 8) = (/&
&1.6136E-03_JPRB,1.8765E-03_JPRB,1.6089E-03_JPRB,1.1585E-03_JPRB,8.3445E-04_JPRB/)
KBO( :, 3,35, 8) = (/&
&2.1631E-03_JPRB,2.4899E-03_JPRB,2.1186E-03_JPRB,1.5089E-03_JPRB,9.7770E-04_JPRB/)
KBO( :, 4,35, 8) = (/&
&2.8535E-03_JPRB,3.2542E-03_JPRB,2.7485E-03_JPRB,1.9364E-03_JPRB,1.1343E-03_JPRB/)
KBO( :, 5,35, 8) = (/&
&3.7092E-03_JPRB,4.1965E-03_JPRB,3.5164E-03_JPRB,2.4522E-03_JPRB,1.3039E-03_JPRB/)
KBO( :, 1,36, 8) = (/&
&1.0066E-03_JPRB,1.1833E-03_JPRB,1.0195E-03_JPRB,7.4064E-04_JPRB,5.2366E-04_JPRB/)
KBO( :, 2,36, 8) = (/&
&1.3815E-03_JPRB,1.6071E-03_JPRB,1.3739E-03_JPRB,9.8573E-04_JPRB,6.2344E-04_JPRB/)
KBO( :, 3,36, 8) = (/&
&1.8626E-03_JPRB,2.1449E-03_JPRB,1.8191E-03_JPRB,1.2898E-03_JPRB,7.3360E-04_JPRB/)
KBO( :, 4,36, 8) = (/&
&2.4741E-03_JPRB,2.8182E-03_JPRB,2.3729E-03_JPRB,1.6635E-03_JPRB,8.5436E-04_JPRB/)
KBO( :, 5,36, 8) = (/&
&3.2336E-03_JPRB,3.6568E-03_JPRB,3.0504E-03_JPRB,2.1181E-03_JPRB,9.8625E-04_JPRB/)
KBO( :, 1,37, 8) = (/&
&8.2084E-04_JPRB,9.6709E-04_JPRB,8.3229E-04_JPRB,6.0374E-04_JPRB,4.0420E-04_JPRB/)
KBO( :, 2,37, 8) = (/&
&1.1372E-03_JPRB,1.3254E-03_JPRB,1.1300E-03_JPRB,8.0872E-04_JPRB,4.8417E-04_JPRB/)
KBO( :, 3,37, 8) = (/&
&1.5468E-03_JPRB,1.7826E-03_JPRB,1.5083E-03_JPRB,1.0643E-03_JPRB,5.7283E-04_JPRB/)
KBO( :, 4,37, 8) = (/&
&2.0724E-03_JPRB,2.3603E-03_JPRB,1.9807E-03_JPRB,1.3829E-03_JPRB,6.7031E-04_JPRB/)
KBO( :, 5,37, 8) = (/&
&2.7301E-03_JPRB,3.0852E-03_JPRB,2.5656E-03_JPRB,1.7725E-03_JPRB,7.7693E-04_JPRB/)
KBO( :, 1,38, 8) = (/&
&6.6765E-04_JPRB,7.8856E-04_JPRB,6.7796E-04_JPRB,4.9087E-04_JPRB,3.1034E-04_JPRB/)
KBO( :, 2,38, 8) = (/&
&9.3399E-04_JPRB,1.0908E-03_JPRB,9.2831E-04_JPRB,6.6210E-04_JPRB,3.7420E-04_JPRB/)
KBO( :, 3,38, 8) = (/&
&1.2829E-03_JPRB,1.4801E-03_JPRB,1.2480E-03_JPRB,8.7788E-04_JPRB,4.4529E-04_JPRB/)
KBO( :, 4,38, 8) = (/&
&1.7334E-03_JPRB,1.9765E-03_JPRB,1.6521E-03_JPRB,1.1484E-03_JPRB,5.2389E-04_JPRB/)
KBO( :, 5,38, 8) = (/&
&2.3042E-03_JPRB,2.6028E-03_JPRB,2.1565E-03_JPRB,1.4823E-03_JPRB,6.1008E-04_JPRB/)
KBO( :, 1,39, 8) = (/&
&5.4315E-04_JPRB,6.4310E-04_JPRB,5.5211E-04_JPRB,3.9890E-04_JPRB,2.3583E-04_JPRB/)
KBO( :, 2,39, 8) = (/&
&7.6743E-04_JPRB,8.9797E-04_JPRB,7.6314E-04_JPRB,5.4269E-04_JPRB,2.8632E-04_JPRB/)
KBO( :, 3,39, 8) = (/&
&1.0649E-03_JPRB,1.2299E-03_JPRB,1.0342E-03_JPRB,7.2462E-04_JPRB,3.4293E-04_JPRB/)
KBO( :, 4,39, 8) = (/&
&1.4519E-03_JPRB,1.6575E-03_JPRB,1.3791E-03_JPRB,9.5496E-04_JPRB,4.0575E-04_JPRB/)
KBO( :, 5,39, 8) = (/&
&1.9462E-03_JPRB,2.1987E-03_JPRB,1.8149E-03_JPRB,1.2411E-03_JPRB,4.7487E-04_JPRB/)
KBO( :, 1,40, 8) = (/&
&4.2660E-04_JPRB,5.0722E-04_JPRB,4.3537E-04_JPRB,3.1438E-04_JPRB,1.8128E-04_JPRB/)
KBO( :, 2,40, 8) = (/&
&6.1039E-04_JPRB,7.1647E-04_JPRB,6.0817E-04_JPRB,4.3189E-04_JPRB,2.2187E-04_JPRB/)
KBO( :, 3,40, 8) = (/&
&8.5703E-04_JPRB,9.9240E-04_JPRB,8.3374E-04_JPRB,5.8276E-04_JPRB,2.6760E-04_JPRB/)
KBO( :, 4,40, 8) = (/&
&1.1823E-03_JPRB,1.3510E-03_JPRB,1.1225E-03_JPRB,7.7459E-04_JPRB,3.1857E-04_JPRB/)
KBO( :, 5,40, 8) = (/&
&1.6018E-03_JPRB,1.8123E-03_JPRB,1.4916E-03_JPRB,1.0158E-03_JPRB,3.7479E-04_JPRB/)
KBO( :, 1,41, 8) = (/&
&3.3271E-04_JPRB,3.9736E-04_JPRB,3.4108E-04_JPRB,2.4624E-04_JPRB,1.3885E-04_JPRB/)
KBO( :, 2,41, 8) = (/&
&4.8225E-04_JPRB,5.6846E-04_JPRB,4.8237E-04_JPRB,3.4216E-04_JPRB,1.7137E-04_JPRB/)
KBO( :, 3,41, 8) = (/&
&6.8576E-04_JPRB,7.9688E-04_JPRB,6.6837E-04_JPRB,4.6622E-04_JPRB,2.0821E-04_JPRB/)
KBO( :, 4,41, 8) = (/&
&9.5732E-04_JPRB,1.0976E-03_JPRB,9.0996E-04_JPRB,6.2571E-04_JPRB,2.4955E-04_JPRB/)
KBO( :, 5,41, 8) = (/&
&1.3120E-03_JPRB,1.4870E-03_JPRB,1.2214E-03_JPRB,8.2829E-04_JPRB,2.9516E-04_JPRB/)
KBO( :, 1,42, 8) = (/&
&2.5867E-04_JPRB,3.1042E-04_JPRB,2.6645E-04_JPRB,1.9244E-04_JPRB,1.0554E-04_JPRB/)
KBO( :, 2,42, 8) = (/&
&3.8005E-04_JPRB,4.4981E-04_JPRB,3.8160E-04_JPRB,2.7033E-04_JPRB,1.3138E-04_JPRB/)
KBO( :, 3,42, 8) = (/&
&5.4750E-04_JPRB,6.3852E-04_JPRB,5.3511E-04_JPRB,3.7262E-04_JPRB,1.6089E-04_JPRB/)
KBO( :, 4,42, 8) = (/&
&7.7370E-04_JPRB,8.8989E-04_JPRB,7.3675E-04_JPRB,5.0530E-04_JPRB,1.9414E-04_JPRB/)
KBO( :, 5,42, 8) = (/&
&1.0732E-03_JPRB,1.2192E-03_JPRB,9.9944E-04_JPRB,6.7542E-04_JPRB,2.3100E-04_JPRB/)
KBO( :, 1,43, 8) = (/&
&1.9608E-04_JPRB,2.3654E-04_JPRB,2.0330E-04_JPRB,1.4692E-04_JPRB,7.9640E-05_JPRB/)
KBO( :, 2,43, 8) = (/&
&2.9244E-04_JPRB,3.4786E-04_JPRB,2.9536E-04_JPRB,2.0929E-04_JPRB,1.0013E-04_JPRB/)
KBO( :, 3,43, 8) = (/&
&4.2746E-04_JPRB,5.0109E-04_JPRB,4.1968E-04_JPRB,2.9227E-04_JPRB,1.2370E-04_JPRB/)
KBO( :, 4,43, 8) = (/&
&6.1258E-04_JPRB,7.0737E-04_JPRB,5.8531E-04_JPRB,4.0077E-04_JPRB,1.5047E-04_JPRB/)
KBO( :, 5,43, 8) = (/&
&8.6089E-04_JPRB,9.8132E-04_JPRB,8.0325E-04_JPRB,5.4165E-04_JPRB,1.8030E-04_JPRB/)
KBO( :, 1,44, 8) = (/&
&1.4641E-04_JPRB,1.7759E-04_JPRB,1.5289E-04_JPRB,1.1076E-04_JPRB,5.9627E-05_JPRB/)
KBO( :, 2,44, 8) = (/&
&2.2184E-04_JPRB,2.6534E-04_JPRB,2.2560E-04_JPRB,1.6005E-04_JPRB,7.5777E-05_JPRB/)
KBO( :, 3,44, 8) = (/&
&3.2924E-04_JPRB,3.8780E-04_JPRB,3.2524E-04_JPRB,2.2657E-04_JPRB,9.4517E-05_JPRB/)
KBO( :, 4,44, 8) = (/&
&4.7893E-04_JPRB,5.5571E-04_JPRB,4.5993E-04_JPRB,3.1465E-04_JPRB,1.1599E-04_JPRB/)
KBO( :, 5,44, 8) = (/&
&6.8243E-04_JPRB,7.8130E-04_JPRB,6.3916E-04_JPRB,4.3040E-04_JPRB,1.4006E-04_JPRB/)
KBO( :, 1,45, 8) = (/&
&1.0865E-04_JPRB,1.3251E-04_JPRB,1.1435E-04_JPRB,8.2960E-05_JPRB,4.4212E-05_JPRB/)
KBO( :, 2,45, 8) = (/&
&1.6729E-04_JPRB,2.0128E-04_JPRB,1.7134E-04_JPRB,1.2183E-04_JPRB,5.6830E-05_JPRB/)
KBO( :, 3,45, 8) = (/&
&2.5229E-04_JPRB,2.9908E-04_JPRB,2.5083E-04_JPRB,1.7486E-04_JPRB,7.1604E-05_JPRB/)
KBO( :, 4,45, 8) = (/&
&3.7262E-04_JPRB,4.3452E-04_JPRB,3.5986E-04_JPRB,2.4619E-04_JPRB,8.8632E-05_JPRB/)
KBO( :, 5,45, 8) = (/&
&5.3882E-04_JPRB,6.2004E-04_JPRB,5.0717E-04_JPRB,3.4090E-04_JPRB,1.0793E-04_JPRB/)
KBO( :, 1,46, 8) = (/&
&7.9358E-05_JPRB,9.7327E-05_JPRB,8.4209E-05_JPRB,6.1250E-05_JPRB,3.2459E-05_JPRB/)
KBO( :, 2,46, 8) = (/&
&1.2429E-04_JPRB,1.5045E-04_JPRB,1.2830E-04_JPRB,9.1466E-05_JPRB,4.2241E-05_JPRB/)
KBO( :, 3,46, 8) = (/&
&1.9053E-04_JPRB,2.2736E-04_JPRB,1.9100E-04_JPRB,1.3325E-04_JPRB,5.3783E-05_JPRB/)
KBO( :, 4,46, 8) = (/&
&2.8614E-04_JPRB,3.3570E-04_JPRB,2.7828E-04_JPRB,1.9050E-04_JPRB,6.7218E-05_JPRB/)
KBO( :, 5,46, 8) = (/&
&4.2039E-04_JPRB,4.8635E-04_JPRB,3.9774E-04_JPRB,2.6724E-04_JPRB,8.2582E-05_JPRB/)
KBO( :, 1,47, 8) = (/&
&5.6453E-05_JPRB,6.9628E-05_JPRB,6.0410E-05_JPRB,4.4150E-05_JPRB,2.3634E-05_JPRB/)
KBO( :, 2,47, 8) = (/&
&9.0039E-05_JPRB,1.0971E-04_JPRB,9.3809E-05_JPRB,6.7082E-05_JPRB,3.1174E-05_JPRB/)
KBO( :, 3,47, 8) = (/&
&1.4053E-04_JPRB,1.6882E-04_JPRB,1.4207E-04_JPRB,9.9462E-05_JPRB,4.0177E-05_JPRB/)
KBO( :, 4,47, 8) = (/&
&2.1477E-04_JPRB,2.5374E-04_JPRB,2.1068E-04_JPRB,1.4451E-04_JPRB,5.0742E-05_JPRB/)
KBO( :, 5,47, 8) = (/&
&3.2088E-04_JPRB,3.7357E-04_JPRB,3.0615E-04_JPRB,2.0585E-04_JPRB,6.2901E-05_JPRB/)
KBO( :, 1,48, 8) = (/&
&3.9798E-05_JPRB,4.9340E-05_JPRB,4.2936E-05_JPRB,3.1533E-05_JPRB,1.7003E-05_JPRB/)
KBO( :, 2,48, 8) = (/&
&6.4659E-05_JPRB,7.9275E-05_JPRB,6.7974E-05_JPRB,4.8844E-05_JPRB,2.2754E-05_JPRB/)
KBO( :, 3,48, 8) = (/&
&1.0277E-04_JPRB,1.2433E-04_JPRB,1.0493E-04_JPRB,7.3715E-05_JPRB,2.9706E-05_JPRB/)
KBO( :, 4,48, 8) = (/&
&1.5992E-04_JPRB,1.9034E-04_JPRB,1.5838E-04_JPRB,1.0886E-04_JPRB,3.7936E-05_JPRB/)
KBO( :, 5,48, 8) = (/&
&2.4325E-04_JPRB,2.8513E-04_JPRB,2.3408E-04_JPRB,1.5755E-04_JPRB,4.7492E-05_JPRB/)
KBO( :, 1,49, 8) = (/&
&2.7802E-05_JPRB,3.4616E-05_JPRB,3.0218E-05_JPRB,2.2308E-05_JPRB,1.2061E-05_JPRB/)
KBO( :, 2,49, 8) = (/&
&4.6014E-05_JPRB,5.6761E-05_JPRB,4.8820E-05_JPRB,3.5239E-05_JPRB,1.6386E-05_JPRB/)
KBO( :, 3,49, 8) = (/&
&7.4491E-05_JPRB,9.0741E-05_JPRB,7.6795E-05_JPRB,5.4143E-05_JPRB,2.1687E-05_JPRB/)
KBO( :, 4,49, 8) = (/&
&1.1802E-04_JPRB,1.4153E-04_JPRB,1.1806E-04_JPRB,8.1356E-05_JPRB,2.8022E-05_JPRB/)
KBO( :, 5,49, 8) = (/&
&1.8279E-04_JPRB,2.1583E-04_JPRB,1.7754E-04_JPRB,1.1970E-04_JPRB,3.5456E-05_JPRB/)
KBO( :, 1,50, 8) = (/&
&1.9540E-05_JPRB,2.4400E-05_JPRB,2.1361E-05_JPRB,1.5837E-05_JPRB,8.6997E-06_JPRB/)
KBO( :, 2,50, 8) = (/&
&3.2918E-05_JPRB,4.0822E-05_JPRB,3.5205E-05_JPRB,2.5512E-05_JPRB,1.1990E-05_JPRB/)
KBO( :, 3,50, 8) = (/&
&5.4255E-05_JPRB,6.6526E-05_JPRB,5.6438E-05_JPRB,3.9950E-05_JPRB,1.6073E-05_JPRB/)
KBO( :, 4,50, 8) = (/&
&8.7526E-05_JPRB,1.0571E-04_JPRB,8.8383E-05_JPRB,6.1066E-05_JPRB,2.1006E-05_JPRB/)
KBO( :, 5,50, 8) = (/&
&1.3799E-04_JPRB,1.6415E-04_JPRB,1.3524E-04_JPRB,9.1334E-05_JPRB,2.6847E-05_JPRB/)
KBO( :, 1,51, 8) = (/&
&1.3715E-05_JPRB,1.7170E-05_JPRB,1.5061E-05_JPRB,1.1220E-05_JPRB,6.3066E-06_JPRB/)
KBO( :, 2,51, 8) = (/&
&2.3525E-05_JPRB,2.9290E-05_JPRB,2.5329E-05_JPRB,1.8432E-05_JPRB,8.8176E-06_JPRB/)
KBO( :, 3,51, 8) = (/&
&3.9460E-05_JPRB,4.8672E-05_JPRB,4.1377E-05_JPRB,2.9397E-05_JPRB,1.1971E-05_JPRB/)
KBO( :, 4,51, 8) = (/&
&6.4794E-05_JPRB,7.8837E-05_JPRB,6.6040E-05_JPRB,4.5759E-05_JPRB,1.5830E-05_JPRB/)
KBO( :, 5,51, 8) = (/&
&1.0402E-04_JPRB,1.2470E-04_JPRB,1.0290E-04_JPRB,6.9640E-05_JPRB,2.0433E-05_JPRB/)
KBO( :, 1,52, 8) = (/&
&9.5578E-06_JPRB,1.1986E-05_JPRB,1.0529E-05_JPRB,7.8831E-06_JPRB,4.5278E-06_JPRB/)
KBO( :, 2,52, 8) = (/&
&1.6679E-05_JPRB,2.0856E-05_JPRB,1.8076E-05_JPRB,1.3211E-05_JPRB,6.4244E-06_JPRB/)
KBO( :, 3,52, 8) = (/&
&2.8477E-05_JPRB,3.5320E-05_JPRB,3.0103E-05_JPRB,2.1468E-05_JPRB,8.8391E-06_JPRB/)
KBO( :, 4,52, 8) = (/&
&4.7594E-05_JPRB,5.8357E-05_JPRB,4.8987E-05_JPRB,3.4026E-05_JPRB,1.1833E-05_JPRB/)
KBO( :, 5,52, 8) = (/&
&7.7798E-05_JPRB,9.3982E-05_JPRB,7.7692E-05_JPRB,5.2723E-05_JPRB,1.5437E-05_JPRB/)
KBO( :, 1,53, 8) = (/&
&6.6072E-06_JPRB,8.2930E-06_JPRB,7.2961E-06_JPRB,5.4893E-06_JPRB,3.2145E-06_JPRB/)
KBO( :, 2,53, 8) = (/&
&1.1726E-05_JPRB,1.4716E-05_JPRB,1.2781E-05_JPRB,9.3822E-06_JPRB,4.6284E-06_JPRB/)
KBO( :, 3,53, 8) = (/&
&2.0380E-05_JPRB,2.5407E-05_JPRB,2.1715E-05_JPRB,1.5543E-05_JPRB,6.4582E-06_JPRB/)
KBO( :, 4,53, 8) = (/&
&3.4658E-05_JPRB,4.2781E-05_JPRB,3.5988E-05_JPRB,2.5111E-05_JPRB,8.7586E-06_JPRB/)
KBO( :, 5,53, 8) = (/&
&5.7694E-05_JPRB,7.0240E-05_JPRB,5.8204E-05_JPRB,3.9606E-05_JPRB,1.1558E-05_JPRB/)
KBO( :, 1,54, 8) = (/&
&4.6231E-06_JPRB,5.8094E-06_JPRB,5.1159E-06_JPRB,3.8681E-06_JPRB,2.3617E-06_JPRB/)
KBO( :, 2,54, 8) = (/&
&8.3487E-06_JPRB,1.0507E-05_JPRB,9.1409E-06_JPRB,6.7324E-06_JPRB,3.4457E-06_JPRB/)
KBO( :, 3,54, 8) = (/&
&1.4749E-05_JPRB,1.8473E-05_JPRB,1.5818E-05_JPRB,1.1366E-05_JPRB,4.8678E-06_JPRB/)
KBO( :, 4,54, 8) = (/&
&2.5524E-05_JPRB,3.1693E-05_JPRB,2.6712E-05_JPRB,1.8698E-05_JPRB,6.6754E-06_JPRB/)
KBO( :, 5,54, 8) = (/&
&4.3244E-05_JPRB,5.3058E-05_JPRB,4.4050E-05_JPRB,3.0042E-05_JPRB,8.8957E-06_JPRB/)
KBO( :, 1,55, 8) = (/&
&3.2435E-06_JPRB,4.0809E-06_JPRB,3.5968E-06_JPRB,2.7333E-06_JPRB,1.7666E-06_JPRB/)
KBO( :, 2,55, 8) = (/&
&5.9644E-06_JPRB,7.5172E-06_JPRB,6.5506E-06_JPRB,4.8409E-06_JPRB,2.6116E-06_JPRB/)
KBO( :, 3,55, 8) = (/&
&1.0704E-05_JPRB,1.3462E-05_JPRB,1.1547E-05_JPRB,8.3238E-06_JPRB,3.7328E-06_JPRB/)
KBO( :, 4,55, 8) = (/&
&1.8846E-05_JPRB,2.3522E-05_JPRB,1.9854E-05_JPRB,1.3943E-05_JPRB,5.1720E-06_JPRB/)
KBO( :, 5,55, 8) = (/&
&3.2477E-05_JPRB,4.0113E-05_JPRB,3.3370E-05_JPRB,2.2811E-05_JPRB,6.9569E-06_JPRB/)
KBO( :, 1,56, 8) = (/&
&2.2574E-06_JPRB,2.8460E-06_JPRB,2.5125E-06_JPRB,1.9227E-06_JPRB,1.3179E-06_JPRB/)
KBO( :, 2,56, 8) = (/&
&4.2369E-06_JPRB,5.3474E-06_JPRB,4.6648E-06_JPRB,3.4587E-06_JPRB,1.9756E-06_JPRB/)
KBO( :, 3,56, 8) = (/&
&7.7258E-06_JPRB,9.7496E-06_JPRB,8.3766E-06_JPRB,6.0549E-06_JPRB,2.8571E-06_JPRB/)
KBO( :, 4,56, 8) = (/&
&1.3829E-05_JPRB,1.7347E-05_JPRB,1.4668E-05_JPRB,1.0332E-05_JPRB,4.0014E-06_JPRB/)
KBO( :, 5,56, 8) = (/&
&2.4242E-05_JPRB,3.0140E-05_JPRB,2.5119E-05_JPRB,1.7219E-05_JPRB,5.4349E-06_JPRB/)
KBO( :, 1,57, 8) = (/&
&1.5562E-06_JPRB,1.9665E-06_JPRB,1.7413E-06_JPRB,1.3458E-06_JPRB,9.8093E-07_JPRB/)
KBO( :, 2,57, 8) = (/&
&2.9891E-06_JPRB,3.7795E-06_JPRB,3.2995E-06_JPRB,2.4572E-06_JPRB,1.4913E-06_JPRB/)
KBO( :, 3,57, 8) = (/&
&5.5415E-06_JPRB,7.0117E-06_JPRB,6.0356E-06_JPRB,4.3741E-06_JPRB,2.1827E-06_JPRB/)
KBO( :, 4,57, 8) = (/&
&1.0083E-05_JPRB,1.2702E-05_JPRB,1.0763E-05_JPRB,7.6047E-06_JPRB,3.0916E-06_JPRB/)
KBO( :, 5,57, 8) = (/&
&1.7987E-05_JPRB,2.2497E-05_JPRB,1.8783E-05_JPRB,1.2912E-05_JPRB,4.2413E-06_JPRB/)
KBO( :, 1,58, 8) = (/&
&1.0750E-06_JPRB,1.3607E-06_JPRB,1.2097E-06_JPRB,9.4788E-07_JPRB,7.3838E-07_JPRB/)
KBO( :, 2,58, 8) = (/&
&2.1150E-06_JPRB,2.6811E-06_JPRB,2.3427E-06_JPRB,1.7529E-06_JPRB,1.1369E-06_JPRB/)
KBO( :, 3,58, 8) = (/&
&3.9927E-06_JPRB,5.0636E-06_JPRB,4.3652E-06_JPRB,3.1731E-06_JPRB,1.6853E-06_JPRB/)
KBO( :, 4,58, 8) = (/&
&7.3820E-06_JPRB,9.3320E-06_JPRB,7.9215E-06_JPRB,5.6104E-06_JPRB,2.4126E-06_JPRB/)
KBO( :, 5,58, 8) = (/&
&1.3390E-05_JPRB,1.6843E-05_JPRB,1.4081E-05_JPRB,9.7051E-06_JPRB,3.3415E-06_JPRB/)
KBO( :, 1,59, 8) = (/&
&8.4145E-07_JPRB,1.0679E-06_JPRB,9.4979E-07_JPRB,7.4709E-07_JPRB,6.3499E-07_JPRB/)
KBO( :, 2,59, 8) = (/&
&1.6828E-06_JPRB,2.1406E-06_JPRB,1.8681E-06_JPRB,1.3967E-06_JPRB,9.8499E-07_JPRB/)
KBO( :, 3,59, 8) = (/&
&3.2239E-06_JPRB,4.0954E-06_JPRB,3.5264E-06_JPRB,2.5580E-06_JPRB,1.4693E-06_JPRB/)
KBO( :, 4,59, 8) = (/&
&6.0392E-06_JPRB,7.6569E-06_JPRB,6.4911E-06_JPRB,4.5821E-06_JPRB,2.1121E-06_JPRB/)
KBO( :, 5,59, 8) = (/&
&1.1097E-05_JPRB,1.4009E-05_JPRB,1.1691E-05_JPRB,8.0420E-06_JPRB,2.9314E-06_JPRB/)
KBO( :, 1,13, 9) = (/&
&6.2749E-02_JPRB,7.2855E-02_JPRB,6.7478E-02_JPRB,5.3345E-02_JPRB,4.4699E-01_JPRB/)
KBO( :, 2,13, 9) = (/&
&8.6319E-02_JPRB,1.0135E-01_JPRB,9.4230E-02_JPRB,7.4640E-02_JPRB,4.8102E-01_JPRB/)
KBO( :, 3,13, 9) = (/&
&1.1531E-01_JPRB,1.3583E-01_JPRB,1.2671E-01_JPRB,1.0042E-01_JPRB,5.1621E-01_JPRB/)
KBO( :, 4,13, 9) = (/&
&1.4981E-01_JPRB,1.7650E-01_JPRB,1.6480E-01_JPRB,1.3078E-01_JPRB,5.5243E-01_JPRB/)
KBO( :, 5,13, 9) = (/&
&1.8970E-01_JPRB,2.2347E-01_JPRB,2.0865E-01_JPRB,1.6587E-01_JPRB,5.8937E-01_JPRB/)
KBO( :, 1,14, 9) = (/&
&5.7187E-02_JPRB,6.7301E-02_JPRB,6.2129E-02_JPRB,4.9110E-02_JPRB,3.7769E-01_JPRB/)
KBO( :, 2,14, 9) = (/&
&7.8466E-02_JPRB,9.3270E-02_JPRB,8.6445E-02_JPRB,6.8459E-02_JPRB,4.0753E-01_JPRB/)
KBO( :, 3,14, 9) = (/&
&1.0467E-01_JPRB,1.2476E-01_JPRB,1.1574E-01_JPRB,9.1819E-02_JPRB,4.3868E-01_JPRB/)
KBO( :, 4,14, 9) = (/&
&1.3581E-01_JPRB,1.6192E-01_JPRB,1.5034E-01_JPRB,1.1930E-01_JPRB,4.7064E-01_JPRB/)
KBO( :, 5,14, 9) = (/&
&1.7224E-01_JPRB,2.0464E-01_JPRB,1.9021E-01_JPRB,1.5110E-01_JPRB,5.0408E-01_JPRB/)
KBO( :, 1,15, 9) = (/&
&5.1721E-02_JPRB,6.1566E-02_JPRB,5.6680E-02_JPRB,4.4751E-02_JPRB,2.9568E-01_JPRB/)
KBO( :, 2,15, 9) = (/&
&7.0936E-02_JPRB,8.5115E-02_JPRB,7.8492E-02_JPRB,6.2182E-02_JPRB,3.2213E-01_JPRB/)
KBO( :, 3,15, 9) = (/&
&9.4515E-02_JPRB,1.1370E-01_JPRB,1.0486E-01_JPRB,8.3182E-02_JPRB,3.4986E-01_JPRB/)
KBO( :, 4,15, 9) = (/&
&1.2289E-01_JPRB,1.4728E-01_JPRB,1.3607E-01_JPRB,1.0790E-01_JPRB,3.7853E-01_JPRB/)
KBO( :, 5,15, 9) = (/&
&1.5637E-01_JPRB,1.8627E-01_JPRB,1.7195E-01_JPRB,1.3626E-01_JPRB,4.0894E-01_JPRB/)
KBO( :, 1,16, 9) = (/&
&4.6578E-02_JPRB,5.5911E-02_JPRB,5.1274E-02_JPRB,4.0416E-02_JPRB,2.2673E-01_JPRB/)
KBO( :, 2,16, 9) = (/&
&6.3866E-02_JPRB,7.7158E-02_JPRB,7.0810E-02_JPRB,5.5944E-02_JPRB,2.5071E-01_JPRB/)
KBO( :, 3,16, 9) = (/&
&8.5294E-02_JPRB,1.0285E-01_JPRB,9.4463E-02_JPRB,7.4731E-02_JPRB,2.7559E-01_JPRB/)
KBO( :, 4,16, 9) = (/&
&1.1126E-01_JPRB,1.3331E-01_JPRB,1.2237E-01_JPRB,9.6725E-02_JPRB,3.0207E-01_JPRB/)
KBO( :, 5,16, 9) = (/&
&1.4207E-01_JPRB,1.6889E-01_JPRB,1.5467E-01_JPRB,1.2182E-01_JPRB,3.3015E-01_JPRB/)
KBO( :, 1,17, 9) = (/&
&4.1900E-02_JPRB,5.0464E-02_JPRB,4.6053E-02_JPRB,3.6179E-02_JPRB,1.8226E-01_JPRB/)
KBO( :, 2,17, 9) = (/&
&5.7522E-02_JPRB,6.9444E-02_JPRB,6.3472E-02_JPRB,4.9973E-02_JPRB,2.0447E-01_JPRB/)
KBO( :, 3,17, 9) = (/&
&7.7026E-02_JPRB,9.2538E-02_JPRB,8.4551E-02_JPRB,6.6605E-02_JPRB,2.2810E-01_JPRB/)
KBO( :, 4,17, 9) = (/&
&1.0079E-01_JPRB,1.2017E-01_JPRB,1.0955E-01_JPRB,8.5985E-02_JPRB,2.5342E-01_JPRB/)
KBO( :, 5,17, 9) = (/&
&1.2927E-01_JPRB,1.5258E-01_JPRB,1.3846E-01_JPRB,1.0816E-01_JPRB,2.7946E-01_JPRB/)
KBO( :, 1,18, 9) = (/&
&3.7891E-02_JPRB,4.5454E-02_JPRB,4.1197E-02_JPRB,3.2260E-02_JPRB,1.5403E-01_JPRB/)
KBO( :, 2,18, 9) = (/&
&5.2057E-02_JPRB,6.2358E-02_JPRB,5.6644E-02_JPRB,4.4449E-02_JPRB,1.7502E-01_JPRB/)
KBO( :, 3,18, 9) = (/&
&6.9815E-02_JPRB,8.3160E-02_JPRB,7.5488E-02_JPRB,5.9051E-02_JPRB,1.9748E-01_JPRB/)
KBO( :, 4,18, 9) = (/&
&9.1668E-02_JPRB,1.0819E-01_JPRB,9.7824E-02_JPRB,7.6130E-02_JPRB,2.2105E-01_JPRB/)
KBO( :, 5,18, 9) = (/&
&1.1799E-01_JPRB,1.3770E-01_JPRB,1.2371E-01_JPRB,9.5780E-02_JPRB,2.4525E-01_JPRB/)
KBO( :, 1,19, 9) = (/&
&3.4441E-02_JPRB,4.0854E-02_JPRB,3.6785E-02_JPRB,2.8648E-02_JPRB,1.3592E-01_JPRB/)
KBO( :, 2,19, 9) = (/&
&4.7310E-02_JPRB,5.6014E-02_JPRB,5.0505E-02_JPRB,3.9333E-02_JPRB,1.5599E-01_JPRB/)
KBO( :, 3,19, 9) = (/&
&6.3559E-02_JPRB,7.4763E-02_JPRB,6.7291E-02_JPRB,5.2149E-02_JPRB,1.7738E-01_JPRB/)
KBO( :, 4,19, 9) = (/&
&8.3699E-02_JPRB,9.7466E-02_JPRB,8.7225E-02_JPRB,6.7250E-02_JPRB,1.9960E-01_JPRB/)
KBO( :, 5,19, 9) = (/&
&1.0809E-01_JPRB,1.2436E-01_JPRB,1.1051E-01_JPRB,8.4704E-02_JPRB,2.2240E-01_JPRB/)
KBO( :, 1,20, 9) = (/&
&3.1662E-02_JPRB,3.7011E-02_JPRB,3.3064E-02_JPRB,2.5535E-02_JPRB,1.2166E-01_JPRB/)
KBO( :, 2,20, 9) = (/&
&4.3462E-02_JPRB,5.0683E-02_JPRB,4.5312E-02_JPRB,3.4918E-02_JPRB,1.4050E-01_JPRB/)
KBO( :, 3,20, 9) = (/&
&5.8468E-02_JPRB,6.7693E-02_JPRB,6.0291E-02_JPRB,4.6251E-02_JPRB,1.6041E-01_JPRB/)
KBO( :, 4,20, 9) = (/&
&7.7082E-02_JPRB,8.8368E-02_JPRB,7.8218E-02_JPRB,5.9632E-02_JPRB,1.8092E-01_JPRB/)
KBO( :, 5,20, 9) = (/&
&9.9590E-02_JPRB,1.1296E-01_JPRB,9.9282E-02_JPRB,7.5236E-02_JPRB,2.0180E-01_JPRB/)
KBO( :, 1,21, 9) = (/&
&2.9197E-02_JPRB,3.3644E-02_JPRB,2.9800E-02_JPRB,2.2751E-02_JPRB,1.0840E-01_JPRB/)
KBO( :, 2,21, 9) = (/&
&4.0061E-02_JPRB,4.6022E-02_JPRB,4.0720E-02_JPRB,3.1025E-02_JPRB,1.2575E-01_JPRB/)
KBO( :, 3,21, 9) = (/&
&5.3879E-02_JPRB,6.1513E-02_JPRB,5.4145E-02_JPRB,4.1071E-02_JPRB,1.4377E-01_JPRB/)
KBO( :, 4,21, 9) = (/&
&7.1035E-02_JPRB,8.0368E-02_JPRB,7.0344E-02_JPRB,5.2993E-02_JPRB,1.6228E-01_JPRB/)
KBO( :, 5,21, 9) = (/&
&9.1717E-02_JPRB,1.0275E-01_JPRB,8.9495E-02_JPRB,6.6978E-02_JPRB,1.8109E-01_JPRB/)
KBO( :, 1,22, 9) = (/&
&2.7499E-02_JPRB,3.1251E-02_JPRB,2.7449E-02_JPRB,2.0717E-02_JPRB,9.5123E-02_JPRB/)
KBO( :, 2,22, 9) = (/&
&3.7657E-02_JPRB,4.2715E-02_JPRB,3.7381E-02_JPRB,2.8145E-02_JPRB,1.1043E-01_JPRB/)
KBO( :, 3,22, 9) = (/&
&5.0562E-02_JPRB,5.6977E-02_JPRB,4.9664E-02_JPRB,3.7184E-02_JPRB,1.2615E-01_JPRB/)
KBO( :, 4,22, 9) = (/&
&6.6397E-02_JPRB,7.4321E-02_JPRB,6.4486E-02_JPRB,4.7986E-02_JPRB,1.4210E-01_JPRB/)
KBO( :, 5,22, 9) = (/&
&8.5266E-02_JPRB,9.4958E-02_JPRB,8.2045E-02_JPRB,6.0712E-02_JPRB,1.5827E-01_JPRB/)
KBO( :, 1,23, 9) = (/&
&2.5951E-02_JPRB,2.9125E-02_JPRB,2.5330E-02_JPRB,1.8934E-02_JPRB,8.2353E-02_JPRB/)
KBO( :, 2,23, 9) = (/&
&3.5455E-02_JPRB,3.9694E-02_JPRB,3.4441E-02_JPRB,2.5641E-02_JPRB,9.5317E-02_JPRB/)
KBO( :, 3,23, 9) = (/&
&4.7331E-02_JPRB,5.2838E-02_JPRB,4.5688E-02_JPRB,3.3836E-02_JPRB,1.0857E-01_JPRB/)
KBO( :, 4,23, 9) = (/&
&6.1763E-02_JPRB,6.8758E-02_JPRB,5.9284E-02_JPRB,4.3652E-02_JPRB,1.2209E-01_JPRB/)
KBO( :, 5,23, 9) = (/&
&7.8933E-02_JPRB,8.7537E-02_JPRB,7.5364E-02_JPRB,5.5173E-02_JPRB,1.3590E-01_JPRB/)
KBO( :, 1,24, 9) = (/&
&2.4473E-02_JPRB,2.7169E-02_JPRB,2.3444E-02_JPRB,1.7363E-02_JPRB,6.9430E-02_JPRB/)
KBO( :, 2,24, 9) = (/&
&3.3250E-02_JPRB,3.6936E-02_JPRB,3.1810E-02_JPRB,2.3462E-02_JPRB,8.0157E-02_JPRB/)
KBO( :, 3,24, 9) = (/&
&4.4117E-02_JPRB,4.8975E-02_JPRB,4.2123E-02_JPRB,3.0921E-02_JPRB,9.1223E-02_JPRB/)
KBO( :, 4,24, 9) = (/&
&5.7285E-02_JPRB,6.3439E-02_JPRB,5.4524E-02_JPRB,3.9854E-02_JPRB,1.0266E-01_JPRB/)
KBO( :, 5,24, 9) = (/&
&7.2998E-02_JPRB,8.0524E-02_JPRB,6.9109E-02_JPRB,5.0332E-02_JPRB,1.1441E-01_JPRB/)
KBO( :, 1,25, 9) = (/&
&2.3088E-02_JPRB,2.5438E-02_JPRB,2.1801E-02_JPRB,1.6002E-02_JPRB,5.7837E-02_JPRB/)
KBO( :, 2,25, 9) = (/&
&3.1174E-02_JPRB,3.4396E-02_JPRB,2.9493E-02_JPRB,2.1569E-02_JPRB,6.6784E-02_JPRB/)
KBO( :, 3,25, 9) = (/&
&4.1147E-02_JPRB,4.5360E-02_JPRB,3.8891E-02_JPRB,2.8375E-02_JPRB,7.6101E-02_JPRB/)
KBO( :, 4,25, 9) = (/&
&5.3244E-02_JPRB,5.8521E-02_JPRB,5.0118E-02_JPRB,3.6473E-02_JPRB,8.5758E-02_JPRB/)
KBO( :, 5,25, 9) = (/&
&6.7659E-02_JPRB,7.4121E-02_JPRB,6.3317E-02_JPRB,4.5953E-02_JPRB,9.5693E-02_JPRB/)
KBO( :, 1,26, 9) = (/&
&2.1853E-02_JPRB,2.3928E-02_JPRB,2.0426E-02_JPRB,1.4853E-02_JPRB,4.8392E-02_JPRB/)
KBO( :, 2,26, 9) = (/&
&2.9360E-02_JPRB,3.2138E-02_JPRB,2.7449E-02_JPRB,1.9958E-02_JPRB,5.5916E-02_JPRB/)
KBO( :, 3,26, 9) = (/&
&3.8590E-02_JPRB,4.2170E-02_JPRB,3.5993E-02_JPRB,2.6138E-02_JPRB,6.3792E-02_JPRB/)
KBO( :, 4,26, 9) = (/&
&4.9775E-02_JPRB,5.4242E-02_JPRB,4.6206E-02_JPRB,3.3463E-02_JPRB,7.1975E-02_JPRB/)
KBO( :, 5,26, 9) = (/&
&6.3079E-02_JPRB,6.8549E-02_JPRB,5.8245E-02_JPRB,4.2044E-02_JPRB,8.0448E-02_JPRB/)
KBO( :, 1,27, 9) = (/&
&2.0589E-02_JPRB,2.2432E-02_JPRB,1.9091E-02_JPRB,1.3798E-02_JPRB,3.9711E-02_JPRB/)
KBO( :, 2,27, 9) = (/&
&2.7577E-02_JPRB,2.9992E-02_JPRB,2.5499E-02_JPRB,1.8441E-02_JPRB,4.5946E-02_JPRB/)
KBO( :, 3,27, 9) = (/&
&3.6163E-02_JPRB,3.9222E-02_JPRB,3.3292E-02_JPRB,2.4027E-02_JPRB,5.2514E-02_JPRB/)
KBO( :, 4,27, 9) = (/&
&4.6525E-02_JPRB,5.0331E-02_JPRB,4.2630E-02_JPRB,3.0669E-02_JPRB,5.9354E-02_JPRB/)
KBO( :, 5,27, 9) = (/&
&5.8822E-02_JPRB,6.3502E-02_JPRB,5.3650E-02_JPRB,3.8505E-02_JPRB,6.6468E-02_JPRB/)
KBO( :, 1,28, 9) = (/&
&1.9320E-02_JPRB,2.0975E-02_JPRB,1.7795E-02_JPRB,1.2791E-02_JPRB,3.1912E-02_JPRB/)
KBO( :, 2,28, 9) = (/&
&2.5855E-02_JPRB,2.7959E-02_JPRB,2.3678E-02_JPRB,1.7000E-02_JPRB,3.7011E-02_JPRB/)
KBO( :, 3,28, 9) = (/&
&3.3864E-02_JPRB,3.6500E-02_JPRB,3.0839E-02_JPRB,2.2082E-02_JPRB,4.2382E-02_JPRB/)
KBO( :, 4,28, 9) = (/&
&4.3478E-02_JPRB,4.6764E-02_JPRB,3.9410E-02_JPRB,2.8143E-02_JPRB,4.8009E-02_JPRB/)
KBO( :, 5,28, 9) = (/&
&5.4874E-02_JPRB,5.8907E-02_JPRB,4.9537E-02_JPRB,3.5320E-02_JPRB,5.3947E-02_JPRB/)
KBO( :, 1,29, 9) = (/&
&1.8123E-02_JPRB,1.9628E-02_JPRB,1.6597E-02_JPRB,1.1861E-02_JPRB,2.5423E-02_JPRB/)
KBO( :, 2,29, 9) = (/&
&2.4225E-02_JPRB,2.6121E-02_JPRB,2.2032E-02_JPRB,1.5699E-02_JPRB,2.9542E-02_JPRB/)
KBO( :, 3,29, 9) = (/&
&3.1700E-02_JPRB,3.4031E-02_JPRB,2.8639E-02_JPRB,2.0345E-02_JPRB,3.3911E-02_JPRB/)
KBO( :, 4,29, 9) = (/&
&4.0663E-02_JPRB,4.3529E-02_JPRB,3.6544E-02_JPRB,2.5917E-02_JPRB,3.8545E-02_JPRB/)
KBO( :, 5,29, 9) = (/&
&5.1268E-02_JPRB,5.4769E-02_JPRB,4.5895E-02_JPRB,3.2522E-02_JPRB,4.3488E-02_JPRB/)
KBO( :, 1,30, 9) = (/&
&1.6958E-02_JPRB,1.8364E-02_JPRB,1.5479E-02_JPRB,1.0998E-02_JPRB,1.9951E-02_JPRB/)
KBO( :, 2,30, 9) = (/&
&2.2671E-02_JPRB,2.4409E-02_JPRB,2.0518E-02_JPRB,1.4521E-02_JPRB,2.3241E-02_JPRB/)
KBO( :, 3,30, 9) = (/&
&2.9641E-02_JPRB,3.1772E-02_JPRB,2.6628E-02_JPRB,1.8795E-02_JPRB,2.6766E-02_JPRB/)
KBO( :, 4,30, 9) = (/&
&3.8012E-02_JPRB,4.0581E-02_JPRB,3.3943E-02_JPRB,2.3935E-02_JPRB,3.0561E-02_JPRB/)
KBO( :, 5,30, 9) = (/&
&4.7908E-02_JPRB,5.1031E-02_JPRB,4.2627E-02_JPRB,3.0033E-02_JPRB,3.4653E-02_JPRB/)
KBO( :, 1,31, 9) = (/&
&1.5875E-02_JPRB,1.7181E-02_JPRB,1.4459E-02_JPRB,1.0211E-02_JPRB,1.5400E-02_JPRB/)
KBO( :, 2,31, 9) = (/&
&2.1201E-02_JPRB,2.2826E-02_JPRB,1.9139E-02_JPRB,1.3463E-02_JPRB,1.8009E-02_JPRB/)
KBO( :, 3,31, 9) = (/&
&2.7703E-02_JPRB,2.9694E-02_JPRB,2.4816E-02_JPRB,1.7421E-02_JPRB,2.0837E-02_JPRB/)
KBO( :, 4,31, 9) = (/&
&3.5538E-02_JPRB,3.7926E-02_JPRB,3.1623E-02_JPRB,2.2179E-02_JPRB,2.3914E-02_JPRB/)
KBO( :, 5,31, 9) = (/&
&4.4824E-02_JPRB,4.7692E-02_JPRB,3.9738E-02_JPRB,2.7844E-02_JPRB,2.7277E-02_JPRB/)
KBO( :, 1,32, 9) = (/&
&1.4881E-02_JPRB,1.6116E-02_JPRB,1.3532E-02_JPRB,9.5127E-03_JPRB,1.1925E-02_JPRB/)
KBO( :, 2,32, 9) = (/&
&1.9865E-02_JPRB,2.1395E-02_JPRB,1.7905E-02_JPRB,1.2529E-02_JPRB,1.4004E-02_JPRB/)
KBO( :, 3,32, 9) = (/&
&2.5959E-02_JPRB,2.7823E-02_JPRB,2.3208E-02_JPRB,1.6206E-02_JPRB,1.6285E-02_JPRB/)
KBO( :, 4,32, 9) = (/&
&3.3313E-02_JPRB,3.5564E-02_JPRB,2.9600E-02_JPRB,2.0639E-02_JPRB,1.8807E-02_JPRB/)
KBO( :, 5,32, 9) = (/&
&4.2060E-02_JPRB,4.4782E-02_JPRB,3.7223E-02_JPRB,2.5926E-02_JPRB,2.1578E-02_JPRB/)
KBO( :, 1,33, 9) = (/&
&1.3967E-02_JPRB,1.5144E-02_JPRB,1.2690E-02_JPRB,8.8844E-03_JPRB,9.2074E-03_JPRB/)
KBO( :, 2,33, 9) = (/&
&1.8640E-02_JPRB,2.0097E-02_JPRB,1.6785E-02_JPRB,1.1705E-02_JPRB,1.0873E-02_JPRB/)
KBO( :, 3,33, 9) = (/&
&2.4387E-02_JPRB,2.6153E-02_JPRB,2.1778E-02_JPRB,1.5136E-02_JPRB,1.2726E-02_JPRB/)
KBO( :, 4,33, 9) = (/&
&3.1327E-02_JPRB,3.3471E-02_JPRB,2.7814E-02_JPRB,1.9292E-02_JPRB,1.4787E-02_JPRB/)
KBO( :, 5,33, 9) = (/&
&3.9572E-02_JPRB,4.2221E-02_JPRB,3.5044E-02_JPRB,2.4264E-02_JPRB,1.7080E-02_JPRB/)
KBO( :, 1,34, 9) = (/&
&1.3038E-02_JPRB,1.4154E-02_JPRB,1.1832E-02_JPRB,8.2492E-03_JPRB,7.3647E-03_JPRB/)
KBO( :, 2,34, 9) = (/&
&1.7420E-02_JPRB,1.8798E-02_JPRB,1.5659E-02_JPRB,1.0876E-02_JPRB,8.7412E-03_JPRB/)
KBO( :, 3,34, 9) = (/&
&2.2825E-02_JPRB,2.4500E-02_JPRB,2.0360E-02_JPRB,1.4089E-02_JPRB,1.0289E-02_JPRB/)
KBO( :, 4,34, 9) = (/&
&2.9360E-02_JPRB,3.1418E-02_JPRB,2.6065E-02_JPRB,1.7978E-02_JPRB,1.2027E-02_JPRB/)
KBO( :, 5,34, 9) = (/&
&3.7137E-02_JPRB,3.9713E-02_JPRB,3.2919E-02_JPRB,2.2661E-02_JPRB,1.3976E-02_JPRB/)
KBO( :, 1,35, 9) = (/&
&1.1851E-02_JPRB,1.2890E-02_JPRB,1.0761E-02_JPRB,7.4718E-03_JPRB,5.7550E-03_JPRB/)
KBO( :, 2,35, 9) = (/&
&1.5900E-02_JPRB,1.7182E-02_JPRB,1.4286E-02_JPRB,9.8834E-03_JPRB,6.8791E-03_JPRB/)
KBO( :, 3,35, 9) = (/&
&2.0897E-02_JPRB,2.2486E-02_JPRB,1.8648E-02_JPRB,1.2848E-02_JPRB,8.1522E-03_JPRB/)
KBO( :, 4,35, 9) = (/&
&2.6965E-02_JPRB,2.8940E-02_JPRB,2.3971E-02_JPRB,1.6457E-02_JPRB,9.5922E-03_JPRB/)
KBO( :, 5,35, 9) = (/&
&3.4238E-02_JPRB,3.6722E-02_JPRB,3.0385E-02_JPRB,2.0819E-02_JPRB,1.1216E-02_JPRB/)
KBO( :, 1,36, 9) = (/&
&1.0455E-02_JPRB,1.1397E-02_JPRB,9.5033E-03_JPRB,6.5755E-03_JPRB,4.3571E-03_JPRB/)
KBO( :, 2,36, 9) = (/&
&1.4117E-02_JPRB,1.5290E-02_JPRB,1.2699E-02_JPRB,8.7484E-03_JPRB,5.2508E-03_JPRB/)
KBO( :, 3,36, 9) = (/&
&1.8658E-02_JPRB,2.0138E-02_JPRB,1.6673E-02_JPRB,1.1439E-02_JPRB,6.2734E-03_JPRB/)
KBO( :, 4,36, 9) = (/&
&2.4204E-02_JPRB,2.6071E-02_JPRB,2.1551E-02_JPRB,1.4738E-02_JPRB,7.4336E-03_JPRB/)
KBO( :, 5,36, 9) = (/&
&3.0898E-02_JPRB,3.3263E-02_JPRB,2.7471E-02_JPRB,1.8745E-02_JPRB,8.7508E-03_JPRB/)
KBO( :, 1,37, 9) = (/&
&8.8498E-03_JPRB,9.6657E-03_JPRB,8.0482E-03_JPRB,5.5507E-03_JPRB,3.4394E-03_JPRB/)
KBO( :, 2,37, 9) = (/&
&1.2053E-02_JPRB,1.3088E-02_JPRB,1.0850E-02_JPRB,7.4463E-03_JPRB,4.1756E-03_JPRB/)
KBO( :, 3,37, 9) = (/&
&1.6053E-02_JPRB,1.7380E-02_JPRB,1.4373E-02_JPRB,9.8197E-03_JPRB,5.0255E-03_JPRB/)
KBO( :, 4,37, 9) = (/&
&2.0992E-02_JPRB,2.2697E-02_JPRB,1.8723E-02_JPRB,1.2754E-02_JPRB,5.9977E-03_JPRB/)
KBO( :, 5,37, 9) = (/&
&2.6999E-02_JPRB,2.9182E-02_JPRB,2.4048E-02_JPRB,1.6341E-02_JPRB,7.1081E-03_JPRB/)
KBO( :, 1,38, 9) = (/&
&7.4680E-03_JPRB,8.1793E-03_JPRB,6.8001E-03_JPRB,4.6741E-03_JPRB,2.7036E-03_JPRB/)
KBO( :, 2,38, 9) = (/&
&1.0268E-02_JPRB,1.1184E-02_JPRB,9.2546E-03_JPRB,6.3288E-03_JPRB,3.3094E-03_JPRB/)
KBO( :, 3,38, 9) = (/&
&1.3799E-02_JPRB,1.4987E-02_JPRB,1.2370E-02_JPRB,8.4204E-03_JPRB,4.0136E-03_JPRB/)
KBO( :, 4,38, 9) = (/&
&1.8189E-02_JPRB,1.9741E-02_JPRB,1.6260E-02_JPRB,1.1031E-02_JPRB,4.8267E-03_JPRB/)
KBO( :, 5,38, 9) = (/&
&2.3579E-02_JPRB,2.5605E-02_JPRB,2.1052E-02_JPRB,1.4244E-02_JPRB,5.7626E-03_JPRB/)
KBO( :, 1,39, 9) = (/&
&6.2942E-03_JPRB,6.9249E-03_JPRB,5.7460E-03_JPRB,3.9360E-03_JPRB,2.1044E-03_JPRB/)
KBO( :, 2,39, 9) = (/&
&8.7432E-03_JPRB,9.5663E-03_JPRB,7.9000E-03_JPRB,5.3823E-03_JPRB,2.5994E-03_JPRB/)
KBO( :, 3,39, 9) = (/&
&1.1864E-02_JPRB,1.2937E-02_JPRB,1.0660E-02_JPRB,7.2304E-03_JPRB,3.1792E-03_JPRB/)
KBO( :, 4,39, 9) = (/&
&1.5781E-02_JPRB,1.7197E-02_JPRB,1.4145E-02_JPRB,9.5554E-03_JPRB,3.8556E-03_JPRB/)
KBO( :, 5,39, 9) = (/&
&2.0624E-02_JPRB,2.2512E-02_JPRB,1.8470E-02_JPRB,1.2443E-02_JPRB,4.6381E-03_JPRB/)
KBO( :, 1,40, 9) = (/&
&5.1375E-03_JPRB,5.6803E-03_JPRB,4.7069E-03_JPRB,3.2115E-03_JPRB,1.6578E-03_JPRB/)
KBO( :, 2,40, 9) = (/&
&7.2291E-03_JPRB,7.9459E-03_JPRB,6.5495E-03_JPRB,4.4441E-03_JPRB,2.0666E-03_JPRB/)
KBO( :, 3,40, 9) = (/&
&9.9296E-03_JPRB,1.0871E-02_JPRB,8.9384E-03_JPRB,6.0392E-03_JPRB,2.5498E-03_JPRB/)
KBO( :, 4,40, 9) = (/&
&1.3354E-02_JPRB,1.4603E-02_JPRB,1.1989E-02_JPRB,8.0664E-03_JPRB,3.1172E-03_JPRB/)
KBO( :, 5,40, 9) = (/&
&1.7630E-02_JPRB,1.9320E-02_JPRB,1.5819E-02_JPRB,1.0610E-02_JPRB,3.7783E-03_JPRB/)
KBO( :, 1,41, 9) = (/&
&4.1669E-03_JPRB,4.6307E-03_JPRB,3.8311E-03_JPRB,2.6055E-03_JPRB,1.3022E-03_JPRB/)
KBO( :, 2,41, 9) = (/&
&5.9450E-03_JPRB,6.5654E-03_JPRB,5.4031E-03_JPRB,3.6497E-03_JPRB,1.6387E-03_JPRB/)
KBO( :, 3,41, 9) = (/&
&8.2702E-03_JPRB,9.0939E-03_JPRB,7.4627E-03_JPRB,5.0204E-03_JPRB,2.0406E-03_JPRB/)
KBO( :, 4,41, 9) = (/&
&1.1254E-02_JPRB,1.2358E-02_JPRB,1.0124E-02_JPRB,6.7836E-03_JPRB,2.5160E-03_JPRB/)
KBO( :, 5,41, 9) = (/&
&1.5021E-02_JPRB,1.6526E-02_JPRB,1.3505E-02_JPRB,9.0170E-03_JPRB,3.0745E-03_JPRB/)
KBO( :, 1,42, 9) = (/&
&3.3673E-03_JPRB,3.7618E-03_JPRB,3.1084E-03_JPRB,2.1093E-03_JPRB,1.0159E-03_JPRB/)
KBO( :, 2,42, 9) = (/&
&4.8758E-03_JPRB,5.4116E-03_JPRB,4.4469E-03_JPRB,2.9930E-03_JPRB,1.2910E-03_JPRB/)
KBO( :, 3,42, 9) = (/&
&6.8765E-03_JPRB,7.5957E-03_JPRB,6.2240E-03_JPRB,4.1675E-03_JPRB,1.6231E-03_JPRB/)
KBO( :, 4,42, 9) = (/&
&9.4703E-03_JPRB,1.0449E-02_JPRB,8.5426E-03_JPRB,5.6988E-03_JPRB,2.0195E-03_JPRB/)
KBO( :, 5,42, 9) = (/&
&1.2789E-02_JPRB,1.4133E-02_JPRB,1.1527E-02_JPRB,7.6610E-03_JPRB,2.4891E-03_JPRB/)
KBO( :, 1,43, 9) = (/&
&2.6545E-03_JPRB,2.9817E-03_JPRB,2.4611E-03_JPRB,1.6672E-03_JPRB,7.8914E-04_JPRB/)
KBO( :, 2,43, 9) = (/&
&3.9072E-03_JPRB,4.3601E-03_JPRB,3.5785E-03_JPRB,2.4026E-03_JPRB,1.0130E-03_JPRB/)
KBO( :, 3,43, 9) = (/&
&5.5970E-03_JPRB,6.2146E-03_JPRB,5.0833E-03_JPRB,3.3914E-03_JPRB,1.2871E-03_JPRB/)
KBO( :, 4,43, 9) = (/&
&7.8170E-03_JPRB,8.6680E-03_JPRB,7.0728E-03_JPRB,4.6984E-03_JPRB,1.6175E-03_JPRB/)
KBO( :, 5,43, 9) = (/&
&1.0695E-02_JPRB,1.1876E-02_JPRB,9.6670E-03_JPRB,6.3964E-03_JPRB,2.0136E-03_JPRB/)
KBO( :, 1,44, 9) = (/&
&2.0599E-03_JPRB,2.3264E-03_JPRB,1.9189E-03_JPRB,1.2982E-03_JPRB,6.1043E-04_JPRB/)
KBO( :, 2,44, 9) = (/&
&3.0865E-03_JPRB,3.4632E-03_JPRB,2.8398E-03_JPRB,1.9029E-03_JPRB,7.9160E-04_JPRB/)
KBO( :, 3,44, 9) = (/&
&4.4945E-03_JPRB,5.0200E-03_JPRB,4.1009E-03_JPRB,2.7282E-03_JPRB,1.0166E-03_JPRB/)
KBO( :, 4,44, 9) = (/&
&6.3771E-03_JPRB,7.1092E-03_JPRB,5.7918E-03_JPRB,3.8324E-03_JPRB,1.2916E-03_JPRB/)
KBO( :, 5,44, 9) = (/&
&8.8507E-03_JPRB,9.8816E-03_JPRB,8.0271E-03_JPRB,5.2885E-03_JPRB,1.6254E-03_JPRB/)
KBO( :, 1,45, 9) = (/&
&1.5883E-03_JPRB,1.8029E-03_JPRB,1.4862E-03_JPRB,1.0041E-03_JPRB,4.6915E-04_JPRB/)
KBO( :, 2,45, 9) = (/&
&2.4237E-03_JPRB,2.7348E-03_JPRB,2.2402E-03_JPRB,1.4983E-03_JPRB,6.1463E-04_JPRB/)
KBO( :, 3,45, 9) = (/&
&3.5915E-03_JPRB,4.0353E-03_JPRB,3.2920E-03_JPRB,2.1847E-03_JPRB,7.9813E-04_JPRB/)
KBO( :, 4,45, 9) = (/&
&5.1787E-03_JPRB,5.8074E-03_JPRB,4.7242E-03_JPRB,3.1158E-03_JPRB,1.0255E-03_JPRB/)
KBO( :, 5,45, 9) = (/&
&7.2977E-03_JPRB,8.1949E-03_JPRB,6.6455E-03_JPRB,4.3597E-03_JPRB,1.3052E-03_JPRB/)
KBO( :, 1,46, 9) = (/&
&1.2050E-03_JPRB,1.3752E-03_JPRB,1.1327E-03_JPRB,7.6415E-04_JPRB,3.5825E-04_JPRB/)
KBO( :, 2,46, 9) = (/&
&1.8745E-03_JPRB,2.1271E-03_JPRB,1.7406E-03_JPRB,1.1623E-03_JPRB,4.7455E-04_JPRB/)
KBO( :, 3,46, 9) = (/&
&2.8292E-03_JPRB,3.1990E-03_JPRB,2.6058E-03_JPRB,1.7261E-03_JPRB,6.2280E-04_JPRB/)
KBO( :, 4,46, 9) = (/&
&4.1523E-03_JPRB,4.6867E-03_JPRB,3.8068E-03_JPRB,2.5043E-03_JPRB,8.0997E-04_JPRB/)
KBO( :, 5,46, 9) = (/&
&5.9484E-03_JPRB,6.7211E-03_JPRB,5.4412E-03_JPRB,3.5566E-03_JPRB,1.0425E-03_JPRB/)
KBO( :, 1,47, 9) = (/&
&8.9059E-04_JPRB,1.0221E-03_JPRB,8.4076E-04_JPRB,5.6652E-04_JPRB,2.7270E-04_JPRB/)
KBO( :, 2,47, 9) = (/&
&1.4154E-03_JPRB,1.6142E-03_JPRB,1.3191E-03_JPRB,8.8003E-04_JPRB,3.6578E-04_JPRB/)
KBO( :, 3,47, 9) = (/&
&2.1790E-03_JPRB,2.4785E-03_JPRB,2.0162E-03_JPRB,1.3331E-03_JPRB,4.8487E-04_JPRB/)
KBO( :, 4,47, 9) = (/&
&3.2603E-03_JPRB,3.7035E-03_JPRB,3.0033E-03_JPRB,1.9711E-03_JPRB,6.3790E-04_JPRB/)
KBO( :, 5,47, 9) = (/&
&4.7543E-03_JPRB,5.4065E-03_JPRB,4.3698E-03_JPRB,2.8478E-03_JPRB,8.3079E-04_JPRB/)
KBO( :, 1,48, 9) = (/&
&6.5137E-04_JPRB,7.5160E-04_JPRB,6.1768E-04_JPRB,4.1559E-04_JPRB,2.0605E-04_JPRB/)
KBO( :, 2,48, 9) = (/&
&1.0584E-03_JPRB,1.2128E-03_JPRB,9.8996E-04_JPRB,6.6009E-04_JPRB,2.8014E-04_JPRB/)
KBO( :, 3,48, 9) = (/&
&1.6631E-03_JPRB,1.9026E-03_JPRB,1.5461E-03_JPRB,1.0205E-03_JPRB,3.7581E-04_JPRB/)
KBO( :, 4,48, 9) = (/&
&2.5384E-03_JPRB,2.9025E-03_JPRB,2.3504E-03_JPRB,1.5394E-03_JPRB,4.9967E-04_JPRB/)
KBO( :, 5,48, 9) = (/&
&3.7716E-03_JPRB,4.3191E-03_JPRB,3.4853E-03_JPRB,2.2659E-03_JPRB,6.5826E-04_JPRB/)
KBO( :, 1,49, 9) = (/&
&4.7074E-04_JPRB,5.4614E-04_JPRB,4.4842E-04_JPRB,3.0149E-04_JPRB,1.5387E-04_JPRB/)
KBO( :, 2,49, 9) = (/&
&7.8312E-04_JPRB,9.0147E-04_JPRB,7.3522E-04_JPRB,4.8971E-04_JPRB,2.1293E-04_JPRB/)
KBO( :, 3,49, 9) = (/&
&1.2566E-03_JPRB,1.4457E-03_JPRB,1.1738E-03_JPRB,7.7341E-04_JPRB,2.8949E-04_JPRB/)
KBO( :, 4,49, 9) = (/&
&1.9577E-03_JPRB,2.2532E-03_JPRB,1.8228E-03_JPRB,1.1917E-03_JPRB,3.8929E-04_JPRB/)
KBO( :, 5,49, 9) = (/&
&2.9665E-03_JPRB,3.4229E-03_JPRB,2.7586E-03_JPRB,1.7902E-03_JPRB,5.1846E-04_JPRB/)
KBO( :, 1,50, 9) = (/&
&3.4213E-04_JPRB,3.9935E-04_JPRB,3.2746E-04_JPRB,2.1988E-04_JPRB,1.1674E-04_JPRB/)
KBO( :, 2,50, 9) = (/&
&5.8343E-04_JPRB,6.7437E-04_JPRB,5.4936E-04_JPRB,3.6511E-04_JPRB,1.6480E-04_JPRB/)
KBO( :, 3,50, 9) = (/&
&9.5650E-04_JPRB,1.1046E-03_JPRB,8.9539E-04_JPRB,5.8873E-04_JPRB,2.2733E-04_JPRB/)
KBO( :, 4,50, 9) = (/&
&1.5196E-03_JPRB,1.7582E-03_JPRB,1.4207E-03_JPRB,9.2622E-04_JPRB,3.0916E-04_JPRB/)
KBO( :, 5,50, 9) = (/&
&2.3472E-03_JPRB,2.7261E-03_JPRB,2.1933E-03_JPRB,1.4203E-03_JPRB,4.1592E-04_JPRB/)
KBO( :, 1,51, 9) = (/&
&2.4775E-04_JPRB,2.9121E-04_JPRB,2.3870E-04_JPRB,1.5996E-04_JPRB,8.8877E-05_JPRB/)
KBO( :, 2,51, 9) = (/&
&4.3433E-04_JPRB,5.0395E-04_JPRB,4.0996E-04_JPRB,2.7183E-04_JPRB,1.2827E-04_JPRB/)
KBO( :, 3,51, 9) = (/&
&7.2809E-04_JPRB,8.4314E-04_JPRB,6.8222E-04_JPRB,4.4757E-04_JPRB,1.8017E-04_JPRB/)
KBO( :, 4,51, 9) = (/&
&1.1797E-03_JPRB,1.3708E-03_JPRB,1.1057E-03_JPRB,7.1871E-04_JPRB,2.4785E-04_JPRB/)
KBO( :, 5,51, 9) = (/&
&1.8569E-03_JPRB,2.1693E-03_JPRB,1.7420E-03_JPRB,1.1250E-03_JPRB,3.3679E-04_JPRB/)
KBO( :, 1,52, 9) = (/&
&1.7722E-04_JPRB,2.0977E-04_JPRB,1.7188E-04_JPRB,1.1517E-04_JPRB,6.6934E-05_JPRB/)
KBO( :, 2,52, 9) = (/&
&3.1988E-04_JPRB,3.7329E-04_JPRB,3.0314E-04_JPRB,2.0061E-04_JPRB,9.9021E-05_JPRB/)
KBO( :, 3,52, 9) = (/&
&5.4977E-04_JPRB,6.3853E-04_JPRB,5.1539E-04_JPRB,3.3762E-04_JPRB,1.4208E-04_JPRB/)
KBO( :, 4,52, 9) = (/&
&9.0908E-04_JPRB,1.0602E-03_JPRB,8.5370E-04_JPRB,5.5342E-04_JPRB,1.9834E-04_JPRB/)
KBO( :, 5,52, 9) = (/&
&1.4584E-03_JPRB,1.7130E-03_JPRB,1.3740E-03_JPRB,8.8469E-04_JPRB,2.7257E-04_JPRB/)
KBO( :, 1,53, 9) = (/&
&1.2486E-04_JPRB,1.4876E-04_JPRB,1.2192E-04_JPRB,8.1756E-05_JPRB,4.9810E-05_JPRB/)
KBO( :, 2,53, 9) = (/&
&2.3236E-04_JPRB,2.7326E-04_JPRB,2.2175E-04_JPRB,1.4647E-04_JPRB,7.5549E-05_JPRB/)
KBO( :, 3,53, 9) = (/&
&4.1092E-04_JPRB,4.7878E-04_JPRB,3.8566E-04_JPRB,2.5219E-04_JPRB,1.1108E-04_JPRB/)
KBO( :, 4,53, 9) = (/&
&6.9449E-04_JPRB,8.1233E-04_JPRB,6.5288E-04_JPRB,4.2235E-04_JPRB,1.5818E-04_JPRB/)
KBO( :, 5,53, 9) = (/&
&1.1362E-03_JPRB,1.3415E-03_JPRB,1.0746E-03_JPRB,6.9016E-04_JPRB,2.1993E-04_JPRB/)
KBO( :, 1,54, 9) = (/&
&8.9225E-05_JPRB,1.0698E-04_JPRB,8.7651E-05_JPRB,5.8813E-05_JPRB,3.8030E-05_JPRB/)
KBO( :, 2,54, 9) = (/&
&1.7137E-04_JPRB,2.0293E-04_JPRB,1.6456E-04_JPRB,1.0850E-04_JPRB,5.9001E-05_JPRB/)
KBO( :, 3,54, 9) = (/&
&3.1189E-04_JPRB,3.6460E-04_JPRB,2.9303E-04_JPRB,1.9101E-04_JPRB,8.8833E-05_JPRB/)
KBO( :, 4,54, 9) = (/&
&5.3932E-04_JPRB,6.3180E-04_JPRB,5.0597E-04_JPRB,3.2631E-04_JPRB,1.2913E-04_JPRB/)
KBO( :, 5,54, 9) = (/&
&8.9911E-04_JPRB,1.0637E-03_JPRB,8.5017E-04_JPRB,5.4403E-04_JPRB,1.8204E-04_JPRB/)
KBO( :, 1,55, 9) = (/&
&6.3909E-05_JPRB,7.7058E-05_JPRB,6.3103E-05_JPRB,4.2365E-05_JPRB,2.9408E-05_JPRB/)
KBO( :, 2,55, 9) = (/&
&1.2694E-04_JPRB,1.5118E-04_JPRB,1.2247E-04_JPRB,8.0640E-05_JPRB,4.6546E-05_JPRB/)
KBO( :, 3,55, 9) = (/&
&2.3779E-04_JPRB,2.7922E-04_JPRB,2.2392E-04_JPRB,1.4533E-04_JPRB,7.1755E-05_JPRB/)
KBO( :, 4,55, 9) = (/&
&4.2152E-04_JPRB,4.9417E-04_JPRB,3.9420E-04_JPRB,2.5317E-04_JPRB,1.0664E-04_JPRB/)
KBO( :, 5,55, 9) = (/&
&7.1633E-04_JPRB,8.4754E-04_JPRB,6.7522E-04_JPRB,4.3025E-04_JPRB,1.5287E-04_JPRB/)
KBO( :, 1,56, 9) = (/&
&4.5238E-05_JPRB,5.4873E-05_JPRB,4.4919E-05_JPRB,3.0179E-05_JPRB,2.2620E-05_JPRB/)
KBO( :, 2,56, 9) = (/&
&9.3046E-05_JPRB,1.1152E-04_JPRB,9.0251E-05_JPRB,5.9375E-05_JPRB,3.6523E-05_JPRB/)
KBO( :, 3,56, 9) = (/&
&1.7973E-04_JPRB,2.1224E-04_JPRB,1.6993E-04_JPRB,1.0998E-04_JPRB,5.7678E-05_JPRB/)
KBO( :, 4,56, 9) = (/&
&3.2753E-04_JPRB,3.8449E-04_JPRB,3.0571E-04_JPRB,1.9550E-04_JPRB,8.7776E-05_JPRB/)
KBO( :, 5,56, 9) = (/&
&5.6860E-04_JPRB,6.7252E-04_JPRB,5.3373E-04_JPRB,3.3864E-04_JPRB,1.2833E-04_JPRB/)
KBO( :, 1,57, 9) = (/&
&3.1565E-05_JPRB,3.8561E-05_JPRB,3.1572E-05_JPRB,2.1236E-05_JPRB,1.7319E-05_JPRB/)
KBO( :, 2,57, 9) = (/&
&6.7437E-05_JPRB,8.1368E-05_JPRB,6.5785E-05_JPRB,4.3278E-05_JPRB,2.8513E-05_JPRB/)
KBO( :, 3,57, 9) = (/&
&1.3453E-04_JPRB,1.5983E-04_JPRB,1.2788E-04_JPRB,8.2634E-05_JPRB,4.6105E-05_JPRB/)
KBO( :, 4,57, 9) = (/&
&2.5265E-04_JPRB,2.9731E-04_JPRB,2.3573E-04_JPRB,1.5020E-04_JPRB,7.1946E-05_JPRB/)
KBO( :, 5,57, 9) = (/&
&4.4894E-04_JPRB,5.3119E-04_JPRB,4.1979E-04_JPRB,2.6517E-04_JPRB,1.0766E-04_JPRB/)
KBO( :, 1,58, 9) = (/&
&2.2075E-05_JPRB,2.7134E-05_JPRB,2.2226E-05_JPRB,1.4971E-05_JPRB,1.3364E-05_JPRB/)
KBO( :, 2,58, 9) = (/&
&4.8978E-05_JPRB,5.9454E-05_JPRB,4.8051E-05_JPRB,3.1593E-05_JPRB,2.2406E-05_JPRB/)
KBO( :, 3,58, 9) = (/&
&1.0101E-04_JPRB,1.2083E-04_JPRB,9.6543E-05_JPRB,6.2301E-05_JPRB,3.7078E-05_JPRB/)
KBO( :, 4,58, 9) = (/&
&1.9559E-04_JPRB,2.3110E-04_JPRB,1.8274E-04_JPRB,1.1601E-04_JPRB,5.9357E-05_JPRB/)
KBO( :, 5,58, 9) = (/&
&3.5639E-04_JPRB,4.2210E-04_JPRB,3.3215E-04_JPRB,2.0879E-04_JPRB,9.0999E-05_JPRB/)
KBO( :, 1,59, 9) = (/&
&1.8162E-05_JPRB,2.2362E-05_JPRB,1.8260E-05_JPRB,1.2253E-05_JPRB,1.1708E-05_JPRB/)
KBO( :, 2,59, 9) = (/&
&4.1323E-05_JPRB,5.0285E-05_JPRB,4.0483E-05_JPRB,2.6494E-05_JPRB,1.9897E-05_JPRB/)
KBO( :, 3,59, 9) = (/&
&8.7123E-05_JPRB,1.0455E-04_JPRB,8.3213E-05_JPRB,5.3390E-05_JPRB,3.3400E-05_JPRB/)
KBO( :, 4,59, 9) = (/&
&1.7214E-04_JPRB,2.0391E-04_JPRB,1.6047E-04_JPRB,1.0123E-04_JPRB,5.4263E-05_JPRB/)
KBO( :, 5,59, 9) = (/&
&3.1897E-04_JPRB,3.7825E-04_JPRB,2.9606E-04_JPRB,1.8480E-04_JPRB,8.4393E-05_JPRB/)
KBO( :, 1,13,10) = (/&
&2.7341E-01_JPRB,2.7526E-01_JPRB,2.5183E-01_JPRB,1.9261E-01_JPRB,1.4210E+00_JPRB/)
KBO( :, 2,13,10) = (/&
&3.8641E-01_JPRB,3.8931E-01_JPRB,3.5500E-01_JPRB,2.7363E-01_JPRB,1.5250E+00_JPRB/)
KBO( :, 3,13,10) = (/&
&5.2101E-01_JPRB,5.2751E-01_JPRB,4.7841E-01_JPRB,3.7012E-01_JPRB,1.6242E+00_JPRB/)
KBO( :, 4,13,10) = (/&
&6.7807E-01_JPRB,6.8631E-01_JPRB,6.2447E-01_JPRB,4.8162E-01_JPRB,1.7236E+00_JPRB/)
KBO( :, 5,13,10) = (/&
&8.5732E-01_JPRB,8.6502E-01_JPRB,7.8632E-01_JPRB,6.0788E-01_JPRB,1.8353E+00_JPRB/)
KBO( :, 1,14,10) = (/&
&2.6100E-01_JPRB,2.7217E-01_JPRB,2.4857E-01_JPRB,1.9099E-01_JPRB,1.3096E+00_JPRB/)
KBO( :, 2,14,10) = (/&
&3.6662E-01_JPRB,3.8321E-01_JPRB,3.4838E-01_JPRB,2.6817E-01_JPRB,1.4048E+00_JPRB/)
KBO( :, 3,14,10) = (/&
&4.9302E-01_JPRB,5.1421E-01_JPRB,4.6962E-01_JPRB,3.6021E-01_JPRB,1.4986E+00_JPRB/)
KBO( :, 4,14,10) = (/&
&6.4068E-01_JPRB,6.6503E-01_JPRB,6.0806E-01_JPRB,4.6655E-01_JPRB,1.6008E+00_JPRB/)
KBO( :, 5,14,10) = (/&
&8.0594E-01_JPRB,8.3870E-01_JPRB,7.6286E-01_JPRB,5.8739E-01_JPRB,1.6996E+00_JPRB/)
KBO( :, 1,15,10) = (/&
&2.4538E-01_JPRB,2.6450E-01_JPRB,2.4065E-01_JPRB,1.8544E-01_JPRB,1.0991E+00_JPRB/)
KBO( :, 2,15,10) = (/&
&3.4290E-01_JPRB,3.6880E-01_JPRB,3.3714E-01_JPRB,2.5768E-01_JPRB,1.1807E+00_JPRB/)
KBO( :, 3,15,10) = (/&
&4.6008E-01_JPRB,4.9212E-01_JPRB,4.5111E-01_JPRB,3.4351E-01_JPRB,1.2655E+00_JPRB/)
KBO( :, 4,15,10) = (/&
&5.9510E-01_JPRB,6.3591E-01_JPRB,5.8042E-01_JPRB,4.4347E-01_JPRB,1.3538E+00_JPRB/)
KBO( :, 5,15,10) = (/&
&7.4431E-01_JPRB,7.9818E-01_JPRB,7.2810E-01_JPRB,5.5870E-01_JPRB,1.4415E+00_JPRB/)
KBO( :, 1,16,10) = (/&
&2.2814E-01_JPRB,2.5112E-01_JPRB,2.2894E-01_JPRB,1.7604E-01_JPRB,8.6918E-01_JPRB/)
KBO( :, 2,16,10) = (/&
&3.1740E-01_JPRB,3.4815E-01_JPRB,3.1813E-01_JPRB,2.4321E-01_JPRB,9.3794E-01_JPRB/)
KBO( :, 3,16,10) = (/&
&4.2406E-01_JPRB,4.6410E-01_JPRB,4.2260E-01_JPRB,3.2211E-01_JPRB,1.0122E+00_JPRB/)
KBO( :, 4,16,10) = (/&
&5.4520E-01_JPRB,5.9870E-01_JPRB,5.4328E-01_JPRB,4.1424E-01_JPRB,1.0849E+00_JPRB/)
KBO( :, 5,16,10) = (/&
&6.8053E-01_JPRB,7.4608E-01_JPRB,6.8074E-01_JPRB,5.2205E-01_JPRB,1.1616E+00_JPRB/)
KBO( :, 1,17,10) = (/&
&2.0942E-01_JPRB,2.3428E-01_JPRB,2.1300E-01_JPRB,1.6357E-01_JPRB,6.8856E-01_JPRB/)
KBO( :, 2,17,10) = (/&
&2.9028E-01_JPRB,3.2402E-01_JPRB,2.9334E-01_JPRB,2.2459E-01_JPRB,7.5316E-01_JPRB/)
KBO( :, 3,17,10) = (/&
&3.8521E-01_JPRB,4.3154E-01_JPRB,3.8848E-01_JPRB,2.9660E-01_JPRB,8.1712E-01_JPRB/)
KBO( :, 4,17,10) = (/&
&4.9386E-01_JPRB,5.5280E-01_JPRB,4.9908E-01_JPRB,3.8197E-01_JPRB,8.8331E-01_JPRB/)
KBO( :, 5,17,10) = (/&
&6.1488E-01_JPRB,6.8821E-01_JPRB,6.2452E-01_JPRB,4.7879E-01_JPRB,9.5857E-01_JPRB/)
KBO( :, 1,18,10) = (/&
&1.9063E-01_JPRB,2.1561E-01_JPRB,1.9503E-01_JPRB,1.4897E-01_JPRB,5.8262E-01_JPRB/)
KBO( :, 2,18,10) = (/&
&2.6234E-01_JPRB,2.9815E-01_JPRB,2.6727E-01_JPRB,2.0340E-01_JPRB,6.4437E-01_JPRB/)
KBO( :, 3,18,10) = (/&
&3.4666E-01_JPRB,3.9448E-01_JPRB,3.5278E-01_JPRB,2.6945E-01_JPRB,7.0773E-01_JPRB/)
KBO( :, 4,18,10) = (/&
&4.4310E-01_JPRB,5.0370E-01_JPRB,4.5197E-01_JPRB,3.4624E-01_JPRB,7.7610E-01_JPRB/)
KBO( :, 5,18,10) = (/&
&5.4979E-01_JPRB,6.2640E-01_JPRB,5.6607E-01_JPRB,4.3269E-01_JPRB,8.4498E-01_JPRB/)
KBO( :, 1,19,10) = (/&
&1.7161E-01_JPRB,1.9659E-01_JPRB,1.7592E-01_JPRB,1.3400E-01_JPRB,5.2315E-01_JPRB/)
KBO( :, 2,19,10) = (/&
&2.3489E-01_JPRB,2.7003E-01_JPRB,2.4068E-01_JPRB,1.8320E-01_JPRB,5.8488E-01_JPRB/)
KBO( :, 3,19,10) = (/&
&3.0942E-01_JPRB,3.5576E-01_JPRB,3.1712E-01_JPRB,2.4210E-01_JPRB,6.4789E-01_JPRB/)
KBO( :, 4,19,10) = (/&
&3.9389E-01_JPRB,4.5374E-01_JPRB,4.0629E-01_JPRB,3.0999E-01_JPRB,7.1351E-01_JPRB/)
KBO( :, 5,19,10) = (/&
&4.8891E-01_JPRB,5.6402E-01_JPRB,5.0679E-01_JPRB,3.8613E-01_JPRB,7.7670E-01_JPRB/)
KBO( :, 1,20,10) = (/&
&1.5436E-01_JPRB,1.7849E-01_JPRB,1.5835E-01_JPRB,1.2054E-01_JPRB,4.8122E-01_JPRB/)
KBO( :, 2,20,10) = (/&
&2.1037E-01_JPRB,2.4329E-01_JPRB,2.1594E-01_JPRB,1.6475E-01_JPRB,5.4083E-01_JPRB/)
KBO( :, 3,20,10) = (/&
&2.7588E-01_JPRB,3.1923E-01_JPRB,2.8475E-01_JPRB,2.1683E-01_JPRB,6.0229E-01_JPRB/)
KBO( :, 4,20,10) = (/&
&3.5179E-01_JPRB,4.0673E-01_JPRB,3.6356E-01_JPRB,2.7647E-01_JPRB,6.6389E-01_JPRB/)
KBO( :, 5,20,10) = (/&
&4.3944E-01_JPRB,5.0591E-01_JPRB,4.5161E-01_JPRB,3.4309E-01_JPRB,7.2588E-01_JPRB/)
KBO( :, 1,21,10) = (/&
&1.3931E-01_JPRB,1.6061E-01_JPRB,1.4210E-01_JPRB,1.0800E-01_JPRB,4.4082E-01_JPRB/)
KBO( :, 2,21,10) = (/&
&1.8903E-01_JPRB,2.1792E-01_JPRB,1.9361E-01_JPRB,1.4691E-01_JPRB,4.9685E-01_JPRB/)
KBO( :, 3,21,10) = (/&
&2.4836E-01_JPRB,2.8494E-01_JPRB,2.5423E-01_JPRB,1.9232E-01_JPRB,5.5604E-01_JPRB/)
KBO( :, 4,21,10) = (/&
&3.1855E-01_JPRB,3.6313E-01_JPRB,3.2325E-01_JPRB,2.4463E-01_JPRB,6.1543E-01_JPRB/)
KBO( :, 5,21,10) = (/&
&4.0034E-01_JPRB,4.5346E-01_JPRB,4.0071E-01_JPRB,3.0346E-01_JPRB,6.7562E-01_JPRB/)
KBO( :, 1,22,10) = (/&
&1.2853E-01_JPRB,1.4730E-01_JPRB,1.3012E-01_JPRB,9.8419E-02_JPRB,3.9506E-01_JPRB/)
KBO( :, 2,22,10) = (/&
&1.7432E-01_JPRB,1.9857E-01_JPRB,1.7621E-01_JPRB,1.3274E-01_JPRB,4.4910E-01_JPRB/)
KBO( :, 3,22,10) = (/&
&2.3012E-01_JPRB,2.5984E-01_JPRB,2.2960E-01_JPRB,1.7295E-01_JPRB,5.0505E-01_JPRB/)
KBO( :, 4,22,10) = (/&
&2.9716E-01_JPRB,3.3163E-01_JPRB,2.9126E-01_JPRB,2.1891E-01_JPRB,5.6304E-01_JPRB/)
KBO( :, 5,22,10) = (/&
&3.7733E-01_JPRB,4.1497E-01_JPRB,3.6137E-01_JPRB,2.7093E-01_JPRB,6.2241E-01_JPRB/)
KBO( :, 1,23,10) = (/&
&1.1881E-01_JPRB,1.3545E-01_JPRB,1.1944E-01_JPRB,8.9244E-02_JPRB,3.5223E-01_JPRB/)
KBO( :, 2,23,10) = (/&
&1.6173E-01_JPRB,1.8250E-01_JPRB,1.6019E-01_JPRB,1.1960E-01_JPRB,4.0380E-01_JPRB/)
KBO( :, 3,23,10) = (/&
&2.1531E-01_JPRB,2.3918E-01_JPRB,2.0828E-01_JPRB,1.5508E-01_JPRB,4.5685E-01_JPRB/)
KBO( :, 4,23,10) = (/&
&2.8111E-01_JPRB,3.0634E-01_JPRB,2.6433E-01_JPRB,1.9616E-01_JPRB,5.1050E-01_JPRB/)
KBO( :, 5,23,10) = (/&
&3.5862E-01_JPRB,3.8538E-01_JPRB,3.2913E-01_JPRB,2.4336E-01_JPRB,5.6512E-01_JPRB/)
KBO( :, 1,24,10) = (/&
&1.1051E-01_JPRB,1.2496E-01_JPRB,1.0957E-01_JPRB,8.1032E-02_JPRB,3.1062E-01_JPRB/)
KBO( :, 2,24,10) = (/&
&1.5172E-01_JPRB,1.6880E-01_JPRB,1.4660E-01_JPRB,1.0802E-01_JPRB,3.5601E-01_JPRB/)
KBO( :, 3,24,10) = (/&
&2.0376E-01_JPRB,2.2212E-01_JPRB,1.9093E-01_JPRB,1.3969E-01_JPRB,4.0151E-01_JPRB/)
KBO( :, 4,24,10) = (/&
&2.6595E-01_JPRB,2.8670E-01_JPRB,2.4290E-01_JPRB,1.7693E-01_JPRB,4.4655E-01_JPRB/)
KBO( :, 5,24,10) = (/&
&3.3711E-01_JPRB,3.6154E-01_JPRB,3.0421E-01_JPRB,2.2016E-01_JPRB,4.9307E-01_JPRB/)
KBO( :, 1,25,10) = (/&
&1.0420E-01_JPRB,1.1612E-01_JPRB,1.0071E-01_JPRB,7.3994E-02_JPRB,2.6769E-01_JPRB/)
KBO( :, 2,25,10) = (/&
&1.4379E-01_JPRB,1.5740E-01_JPRB,1.3501E-01_JPRB,9.8353E-02_JPRB,3.0486E-01_JPRB/)
KBO( :, 3,25,10) = (/&
&1.9217E-01_JPRB,2.0868E-01_JPRB,1.7650E-01_JPRB,1.2735E-01_JPRB,3.4236E-01_JPRB/)
KBO( :, 4,25,10) = (/&
&2.4870E-01_JPRB,2.6919E-01_JPRB,2.2634E-01_JPRB,1.6171E-01_JPRB,3.8148E-01_JPRB/)
KBO( :, 5,25,10) = (/&
&3.1377E-01_JPRB,3.3803E-01_JPRB,2.8442E-01_JPRB,2.0146E-01_JPRB,4.2272E-01_JPRB/)
KBO( :, 1,26,10) = (/&
&9.9675E-02_JPRB,1.0913E-01_JPRB,9.3389E-02_JPRB,6.8204E-02_JPRB,2.2702E-01_JPRB/)
KBO( :, 2,26,10) = (/&
&1.3608E-01_JPRB,1.4866E-01_JPRB,1.2587E-01_JPRB,9.0548E-02_JPRB,2.5831E-01_JPRB/)
KBO( :, 3,26,10) = (/&
&1.7987E-01_JPRB,1.9629E-01_JPRB,1.6531E-01_JPRB,1.1761E-01_JPRB,2.9077E-01_JPRB/)
KBO( :, 4,26,10) = (/&
&2.3141E-01_JPRB,2.5133E-01_JPRB,2.1184E-01_JPRB,1.5002E-01_JPRB,3.2521E-01_JPRB/)
KBO( :, 5,26,10) = (/&
&2.9168E-01_JPRB,3.1498E-01_JPRB,2.6568E-01_JPRB,1.8754E-01_JPRB,3.6164E-01_JPRB/)
KBO( :, 1,27,10) = (/&
&9.4961E-02_JPRB,1.0334E-01_JPRB,8.7374E-02_JPRB,6.3126E-02_JPRB,1.8683E-01_JPRB/)
KBO( :, 2,27,10) = (/&
&1.2783E-01_JPRB,1.3969E-01_JPRB,1.1790E-01_JPRB,8.4112E-02_JPRB,2.1332E-01_JPRB/)
KBO( :, 3,27,10) = (/&
&1.6762E-01_JPRB,1.8278E-01_JPRB,1.5442E-01_JPRB,1.0984E-01_JPRB,2.4142E-01_JPRB/)
KBO( :, 4,27,10) = (/&
&2.1518E-01_JPRB,2.3329E-01_JPRB,1.9719E-01_JPRB,1.3996E-01_JPRB,2.7159E-01_JPRB/)
KBO( :, 5,27,10) = (/&
&2.7088E-01_JPRB,2.9228E-01_JPRB,2.4666E-01_JPRB,1.7442E-01_JPRB,3.0352E-01_JPRB/)
KBO( :, 1,28,10) = (/&
&8.9894E-02_JPRB,9.7468E-02_JPRB,8.2177E-02_JPRB,5.8889E-02_JPRB,1.5060E-01_JPRB/)
KBO( :, 2,28,10) = (/&
&1.1988E-01_JPRB,1.3035E-01_JPRB,1.1000E-01_JPRB,7.8738E-02_JPRB,1.7287E-01_JPRB/)
KBO( :, 3,28,10) = (/&
&1.5649E-01_JPRB,1.6957E-01_JPRB,1.4329E-01_JPRB,1.0256E-01_JPRB,1.9707E-01_JPRB/)
KBO( :, 4,28,10) = (/&
&2.0046E-01_JPRB,2.1640E-01_JPRB,1.8266E-01_JPRB,1.3021E-01_JPRB,2.2305E-01_JPRB/)
KBO( :, 5,28,10) = (/&
&2.5209E-01_JPRB,2.7147E-01_JPRB,2.2856E-01_JPRB,1.6182E-01_JPRB,2.5048E-01_JPRB/)
KBO( :, 1,29,10) = (/&
&8.4975E-02_JPRB,9.1564E-02_JPRB,7.7119E-02_JPRB,5.5320E-02_JPRB,1.2031E-01_JPRB/)
KBO( :, 2,29,10) = (/&
&1.1279E-01_JPRB,1.2154E-01_JPRB,1.0248E-01_JPRB,7.3699E-02_JPRB,1.3921E-01_JPRB/)
KBO( :, 3,29,10) = (/&
&1.4673E-01_JPRB,1.5792E-01_JPRB,1.3309E-01_JPRB,9.5449E-02_JPRB,1.5984E-01_JPRB/)
KBO( :, 4,29,10) = (/&
&1.8741E-01_JPRB,2.0158E-01_JPRB,1.6951E-01_JPRB,1.2082E-01_JPRB,1.8203E-01_JPRB/)
KBO( :, 5,29,10) = (/&
&2.3506E-01_JPRB,2.5337E-01_JPRB,2.1224E-01_JPRB,1.5053E-01_JPRB,2.0549E-01_JPRB/)
KBO( :, 1,30,10) = (/&
&8.0540E-02_JPRB,8.5979E-02_JPRB,7.2248E-02_JPRB,5.1838E-02_JPRB,9.5257E-02_JPRB/)
KBO( :, 2,30,10) = (/&
&1.0659E-01_JPRB,1.1363E-01_JPRB,9.5542E-02_JPRB,6.8630E-02_JPRB,1.1116E-01_JPRB/)
KBO( :, 3,30,10) = (/&
&1.3811E-01_JPRB,1.4769E-01_JPRB,1.2398E-01_JPRB,8.8651E-02_JPRB,1.2851E-01_JPRB/)
KBO( :, 4,30,10) = (/&
&1.7576E-01_JPRB,1.8885E-01_JPRB,1.5795E-01_JPRB,1.1230E-01_JPRB,1.4704E-01_JPRB/)
KBO( :, 5,30,10) = (/&
&2.1968E-01_JPRB,2.3750E-01_JPRB,1.9778E-01_JPRB,1.4034E-01_JPRB,1.6746E-01_JPRB/)
KBO( :, 1,31,10) = (/&
&7.6568E-02_JPRB,8.1013E-02_JPRB,6.7877E-02_JPRB,4.8531E-02_JPRB,7.4566E-02_JPRB/)
KBO( :, 2,31,10) = (/&
&1.0109E-01_JPRB,1.0699E-01_JPRB,8.9628E-02_JPRB,6.3973E-02_JPRB,8.7642E-02_JPRB/)
KBO( :, 3,31,10) = (/&
&1.3062E-01_JPRB,1.3896E-01_JPRB,1.1618E-01_JPRB,8.2665E-02_JPRB,1.0209E-01_JPRB/)
KBO( :, 4,31,10) = (/&
&1.6550E-01_JPRB,1.7774E-01_JPRB,1.4814E-01_JPRB,1.0503E-01_JPRB,1.1802E-01_JPRB/)
KBO( :, 5,31,10) = (/&
&2.0675E-01_JPRB,2.2327E-01_JPRB,1.8555E-01_JPRB,1.3151E-01_JPRB,1.3544E-01_JPRB/)
KBO( :, 1,32,10) = (/&
&7.2888E-02_JPRB,7.6838E-02_JPRB,6.4126E-02_JPRB,4.5495E-02_JPRB,5.8817E-02_JPRB/)
KBO( :, 2,32,10) = (/&
&9.6267E-02_JPRB,1.0140E-01_JPRB,8.4579E-02_JPRB,5.9945E-02_JPRB,6.9773E-02_JPRB/)
KBO( :, 3,32,10) = (/&
&1.2398E-01_JPRB,1.3170E-01_JPRB,1.0960E-01_JPRB,7.7555E-02_JPRB,8.1997E-02_JPRB/)
KBO( :, 4,32,10) = (/&
&1.5682E-01_JPRB,1.6810E-01_JPRB,1.3960E-01_JPRB,9.8812E-02_JPRB,9.5528E-02_JPRB/)
KBO( :, 5,32,10) = (/&
&1.9594E-01_JPRB,2.1107E-01_JPRB,1.7505E-01_JPRB,1.2416E-01_JPRB,1.1090E-01_JPRB/)
KBO( :, 1,33,10) = (/&
&6.9635E-02_JPRB,7.3317E-02_JPRB,6.1010E-02_JPRB,4.2865E-02_JPRB,4.6660E-02_JPRB/)
KBO( :, 2,33,10) = (/&
&9.1701E-02_JPRB,9.6759E-02_JPRB,8.0326E-02_JPRB,5.6501E-02_JPRB,5.5833E-02_JPRB/)
KBO( :, 3,33,10) = (/&
&1.1801E-01_JPRB,1.2540E-01_JPRB,1.0406E-01_JPRB,7.3316E-02_JPRB,6.6138E-02_JPRB/)
KBO( :, 4,33,10) = (/&
&1.4953E-01_JPRB,1.5985E-01_JPRB,1.3238E-01_JPRB,9.3601E-02_JPRB,7.7808E-02_JPRB/)
KBO( :, 5,33,10) = (/&
&1.8727E-01_JPRB,2.0108E-01_JPRB,1.6621E-01_JPRB,1.1789E-01_JPRB,9.1029E-02_JPRB/)
KBO( :, 1,34,10) = (/&
&6.6051E-02_JPRB,6.9606E-02_JPRB,5.7793E-02_JPRB,4.0300E-02_JPRB,3.8390E-02_JPRB/)
KBO( :, 2,34,10) = (/&
&8.6850E-02_JPRB,9.2010E-02_JPRB,7.6104E-02_JPRB,5.3129E-02_JPRB,4.6300E-02_JPRB/)
KBO( :, 3,34,10) = (/&
&1.1190E-01_JPRB,1.1902E-01_JPRB,9.8376E-02_JPRB,6.9059E-02_JPRB,5.5243E-02_JPRB/)
KBO( :, 4,34,10) = (/&
&1.4227E-01_JPRB,1.5193E-01_JPRB,1.2534E-01_JPRB,8.8424E-02_JPRB,6.5503E-02_JPRB/)
KBO( :, 5,34,10) = (/&
&1.7893E-01_JPRB,1.9164E-01_JPRB,1.5780E-01_JPRB,1.1159E-01_JPRB,7.7108E-02_JPRB/)
KBO( :, 1,35,10) = (/&
&6.1061E-02_JPRB,6.4589E-02_JPRB,5.3472E-02_JPRB,3.7076E-02_JPRB,3.0936E-02_JPRB/)
KBO( :, 2,35,10) = (/&
&8.0413E-02_JPRB,8.5518E-02_JPRB,7.0631E-02_JPRB,4.9033E-02_JPRB,3.7630E-02_JPRB/)
KBO( :, 3,35,10) = (/&
&1.0418E-01_JPRB,1.1098E-01_JPRB,9.1376E-02_JPRB,6.3892E-02_JPRB,4.5348E-02_JPRB/)
KBO( :, 4,35,10) = (/&
&1.3326E-01_JPRB,1.4218E-01_JPRB,1.1684E-01_JPRB,8.2004E-02_JPRB,5.4177E-02_JPRB/)
KBO( :, 5,35,10) = (/&
&1.6818E-01_JPRB,1.8014E-01_JPRB,1.4791E-01_JPRB,1.0383E-01_JPRB,6.4352E-02_JPRB/)
KBO( :, 1,36,10) = (/&
&5.4859E-02_JPRB,5.8269E-02_JPRB,4.8182E-02_JPRB,3.3253E-02_JPRB,2.4204E-02_JPRB/)
KBO( :, 2,36,10) = (/&
&7.2626E-02_JPRB,7.7491E-02_JPRB,6.3949E-02_JPRB,4.4186E-02_JPRB,2.9747E-02_JPRB/)
KBO( :, 3,36,10) = (/&
&9.4867E-02_JPRB,1.0121E-01_JPRB,8.3126E-02_JPRB,5.7761E-02_JPRB,3.6183E-02_JPRB/)
KBO( :, 4,36,10) = (/&
&1.2215E-01_JPRB,1.3045E-01_JPRB,1.0693E-01_JPRB,7.4445E-02_JPRB,4.3693E-02_JPRB/)
KBO( :, 5,36,10) = (/&
&1.5514E-01_JPRB,1.6646E-01_JPRB,1.3613E-01_JPRB,9.4760E-02_JPRB,5.2444E-02_JPRB/)
KBO( :, 1,37,10) = (/&
&4.7230E-02_JPRB,5.0376E-02_JPRB,4.1606E-02_JPRB,2.8650E-02_JPRB,1.9576E-02_JPRB/)
KBO( :, 2,37,10) = (/&
&6.3162E-02_JPRB,6.7559E-02_JPRB,5.5737E-02_JPRB,3.8366E-02_JPRB,2.4307E-02_JPRB/)
KBO( :, 3,37,10) = (/&
&8.3382E-02_JPRB,8.9100E-02_JPRB,7.3096E-02_JPRB,5.0404E-02_JPRB,2.9845E-02_JPRB/)
KBO( :, 4,37,10) = (/&
&1.0831E-01_JPRB,1.1578E-01_JPRB,9.4747E-02_JPRB,6.5399E-02_JPRB,3.6334E-02_JPRB/)
KBO( :, 5,37,10) = (/&
&1.3872E-01_JPRB,1.4912E-01_JPRB,1.2153E-01_JPRB,8.3890E-02_JPRB,4.3970E-02_JPRB/)
KBO( :, 1,38,10) = (/&
&4.0594E-02_JPRB,4.3482E-02_JPRB,3.5882E-02_JPRB,2.4652E-02_JPRB,1.5796E-02_JPRB/)
KBO( :, 2,38,10) = (/&
&5.4893E-02_JPRB,5.8859E-02_JPRB,4.8535E-02_JPRB,3.3342E-02_JPRB,1.9838E-02_JPRB/)
KBO( :, 3,38,10) = (/&
&7.3270E-02_JPRB,7.8442E-02_JPRB,6.4299E-02_JPRB,4.4057E-02_JPRB,2.4587E-02_JPRB/)
KBO( :, 4,38,10) = (/&
&9.6131E-02_JPRB,1.0297E-01_JPRB,8.4062E-02_JPRB,5.7542E-02_JPRB,3.0194E-02_JPRB/)
KBO( :, 5,38,10) = (/&
&1.2425E-01_JPRB,1.3371E-01_JPRB,1.0871E-01_JPRB,7.4376E-02_JPRB,3.6826E-02_JPRB/)
KBO( :, 1,39,10) = (/&
&3.4960E-02_JPRB,3.7584E-02_JPRB,3.1001E-02_JPRB,2.1253E-02_JPRB,1.2659E-02_JPRB/)
KBO( :, 2,39,10) = (/&
&4.7796E-02_JPRB,5.1412E-02_JPRB,4.2333E-02_JPRB,2.9006E-02_JPRB,1.6073E-02_JPRB/)
KBO( :, 3,39,10) = (/&
&6.4510E-02_JPRB,6.9244E-02_JPRB,5.6690E-02_JPRB,3.8671E-02_JPRB,2.0130E-02_JPRB/)
KBO( :, 4,39,10) = (/&
&8.5561E-02_JPRB,9.1904E-02_JPRB,7.4800E-02_JPRB,5.0873E-02_JPRB,2.4941E-02_JPRB/)
KBO( :, 5,39,10) = (/&
&1.1163E-01_JPRB,1.2022E-01_JPRB,9.7628E-02_JPRB,6.6235E-02_JPRB,3.0668E-02_JPRB/)
KBO( :, 1,40,10) = (/&
&2.9268E-02_JPRB,3.1482E-02_JPRB,2.5935E-02_JPRB,1.7721E-02_JPRB,1.0217E-02_JPRB/)
KBO( :, 2,40,10) = (/&
&4.0459E-02_JPRB,4.3586E-02_JPRB,3.5852E-02_JPRB,2.4486E-02_JPRB,1.3110E-02_JPRB/)
KBO( :, 3,40,10) = (/&
&5.5229E-02_JPRB,5.9449E-02_JPRB,4.8588E-02_JPRB,3.3038E-02_JPRB,1.6586E-02_JPRB/)
KBO( :, 4,40,10) = (/&
&7.4117E-02_JPRB,7.9872E-02_JPRB,6.4885E-02_JPRB,4.3907E-02_JPRB,2.0725E-02_JPRB/)
KBO( :, 5,40,10) = (/&
&9.7865E-02_JPRB,1.0550E-01_JPRB,8.5568E-02_JPRB,5.7643E-02_JPRB,2.5662E-02_JPRB/)
KBO( :, 1,41,10) = (/&
&2.4397E-02_JPRB,2.6231E-02_JPRB,2.1586E-02_JPRB,1.4682E-02_JPRB,8.2353E-03_JPRB/)
KBO( :, 2,41,10) = (/&
&3.4139E-02_JPRB,3.6786E-02_JPRB,3.0230E-02_JPRB,2.0568E-02_JPRB,1.0674E-02_JPRB/)
KBO( :, 3,41,10) = (/&
&4.7106E-02_JPRB,5.0858E-02_JPRB,4.1459E-02_JPRB,2.8115E-02_JPRB,1.3635E-02_JPRB/)
KBO( :, 4,41,10) = (/&
&6.4000E-02_JPRB,6.9180E-02_JPRB,5.6062E-02_JPRB,3.7799E-02_JPRB,1.7204E-02_JPRB/)
KBO( :, 5,41,10) = (/&
&8.5517E-02_JPRB,9.2400E-02_JPRB,7.4782E-02_JPRB,5.0099E-02_JPRB,2.1450E-02_JPRB/)
KBO( :, 1,42,10) = (/&
&2.0268E-02_JPRB,2.1845E-02_JPRB,1.7956E-02_JPRB,1.2140E-02_JPRB,6.5991E-03_JPRB/)
KBO( :, 2,42,10) = (/&
&2.8789E-02_JPRB,3.1021E-02_JPRB,2.5467E-02_JPRB,1.7246E-02_JPRB,8.6477E-03_JPRB/)
KBO( :, 3,42,10) = (/&
&4.0194E-02_JPRB,4.3474E-02_JPRB,3.5363E-02_JPRB,2.3902E-02_JPRB,1.1154E-02_JPRB/)
KBO( :, 4,42,10) = (/&
&5.5258E-02_JPRB,5.9919E-02_JPRB,4.8429E-02_JPRB,3.2536E-02_JPRB,1.4210E-02_JPRB/)
KBO( :, 5,42,10) = (/&
&7.4696E-02_JPRB,8.0962E-02_JPRB,6.5393E-02_JPRB,4.3618E-02_JPRB,1.7849E-02_JPRB/)
KBO( :, 1,43,10) = (/&
&1.6426E-02_JPRB,1.7804E-02_JPRB,1.4613E-02_JPRB,9.8050E-03_JPRB,5.2617E-03_JPRB/)
KBO( :, 2,43,10) = (/&
&2.3747E-02_JPRB,2.5630E-02_JPRB,2.1011E-02_JPRB,1.4160E-02_JPRB,6.9847E-03_JPRB/)
KBO( :, 3,43,10) = (/&
&3.3653E-02_JPRB,3.6412E-02_JPRB,2.9592E-02_JPRB,1.9925E-02_JPRB,9.1040E-03_JPRB/)
KBO( :, 4,43,10) = (/&
&4.6868E-02_JPRB,5.0938E-02_JPRB,4.1108E-02_JPRB,2.7526E-02_JPRB,1.1710E-02_JPRB/)
KBO( :, 5,43,10) = (/&
&6.4129E-02_JPRB,6.9760E-02_JPRB,5.6238E-02_JPRB,3.7383E-02_JPRB,1.4823E-02_JPRB/)
KBO( :, 1,44,10) = (/&
&1.3100E-02_JPRB,1.4316E-02_JPRB,1.1742E-02_JPRB,7.8185E-03_JPRB,4.1731E-03_JPRB/)
KBO( :, 2,44,10) = (/&
&1.9306E-02_JPRB,2.0946E-02_JPRB,1.7130E-02_JPRB,1.1488E-02_JPRB,5.6253E-03_JPRB/)
KBO( :, 3,44,10) = (/&
&2.7839E-02_JPRB,3.0159E-02_JPRB,2.4497E-02_JPRB,1.6420E-02_JPRB,7.4177E-03_JPRB/)
KBO( :, 4,44,10) = (/&
&3.9351E-02_JPRB,4.2845E-02_JPRB,3.4542E-02_JPRB,2.3036E-02_JPRB,9.6323E-03_JPRB/)
KBO( :, 5,44,10) = (/&
&5.4545E-02_JPRB,5.9565E-02_JPRB,4.7916E-02_JPRB,3.1766E-02_JPRB,1.2297E-02_JPRB/)
KBO( :, 1,45,10) = (/&
&1.0365E-02_JPRB,1.1432E-02_JPRB,9.3767E-03_JPRB,6.2117E-03_JPRB,3.2839E-03_JPRB/)
KBO( :, 2,45,10) = (/&
&1.5589E-02_JPRB,1.7063E-02_JPRB,1.3930E-02_JPRB,9.2859E-03_JPRB,4.5005E-03_JPRB/)
KBO( :, 3,45,10) = (/&
&2.2910E-02_JPRB,2.4924E-02_JPRB,2.0227E-02_JPRB,1.3494E-02_JPRB,6.0165E-03_JPRB/)
KBO( :, 4,45,10) = (/&
&3.2938E-02_JPRB,3.5933E-02_JPRB,2.8944E-02_JPRB,1.9215E-02_JPRB,7.8901E-03_JPRB/)
KBO( :, 5,45,10) = (/&
&4.6288E-02_JPRB,5.0739E-02_JPRB,4.0755E-02_JPRB,2.6930E-02_JPRB,1.0163E-02_JPRB/)
KBO( :, 1,46,10) = (/&
&8.0611E-03_JPRB,8.9687E-03_JPRB,7.3616E-03_JPRB,4.8649E-03_JPRB,2.5630E-03_JPRB/)
KBO( :, 2,46,10) = (/&
&1.2384E-02_JPRB,1.3700E-02_JPRB,1.1187E-02_JPRB,7.4141E-03_JPRB,3.5736E-03_JPRB/)
KBO( :, 3,46,10) = (/&
&1.8589E-02_JPRB,2.0376E-02_JPRB,1.6514E-02_JPRB,1.0949E-02_JPRB,4.8546E-03_JPRB/)
KBO( :, 4,46,10) = (/&
&2.7228E-02_JPRB,2.9798E-02_JPRB,2.3986E-02_JPRB,1.5867E-02_JPRB,6.4395E-03_JPRB/)
KBO( :, 5,46,10) = (/&
&3.8907E-02_JPRB,4.2772E-02_JPRB,3.4328E-02_JPRB,2.2598E-02_JPRB,8.3793E-03_JPRB/)
KBO( :, 1,47,10) = (/&
&6.0942E-03_JPRB,6.8373E-03_JPRB,5.6151E-03_JPRB,3.7108E-03_JPRB,1.9874E-03_JPRB/)
KBO( :, 2,47,10) = (/&
&9.5830E-03_JPRB,1.0720E-02_JPRB,8.7687E-03_JPRB,5.7830E-03_JPRB,2.8149E-03_JPRB/)
KBO( :, 3,47,10) = (/&
&1.4719E-02_JPRB,1.6286E-02_JPRB,1.3206E-02_JPRB,8.7082E-03_JPRB,3.8989E-03_JPRB/)
KBO( :, 4,47,10) = (/&
&2.2034E-02_JPRB,2.4248E-02_JPRB,1.9496E-02_JPRB,1.2839E-02_JPRB,5.2464E-03_JPRB/)
KBO( :, 5,47,10) = (/&
&3.2068E-02_JPRB,3.5385E-02_JPRB,2.8366E-02_JPRB,1.8611E-02_JPRB,6.9087E-03_JPRB/)
KBO( :, 1,48,10) = (/&
&4.5510E-03_JPRB,5.1515E-03_JPRB,4.2286E-03_JPRB,2.7938E-03_JPRB,1.5324E-03_JPRB/)
KBO( :, 2,48,10) = (/&
&7.3293E-03_JPRB,8.3022E-03_JPRB,6.7958E-03_JPRB,4.4708E-03_JPRB,2.2018E-03_JPRB/)
KBO( :, 3,48,10) = (/&
&1.1532E-02_JPRB,1.2909E-02_JPRB,1.0485E-02_JPRB,6.8896E-03_JPRB,3.1032E-03_JPRB/)
KBO( :, 4,48,10) = (/&
&1.7669E-02_JPRB,1.9619E-02_JPRB,1.5768E-02_JPRB,1.0334E-02_JPRB,4.2526E-03_JPRB/)
KBO( :, 5,48,10) = (/&
&2.6263E-02_JPRB,2.9134E-02_JPRB,2.3325E-02_JPRB,1.5244E-02_JPRB,5.6768E-03_JPRB/)
KBO( :, 1,49,10) = (/&
&3.3560E-03_JPRB,3.8327E-03_JPRB,3.1391E-03_JPRB,2.0743E-03_JPRB,1.1802E-03_JPRB/)
KBO( :, 2,49,10) = (/&
&5.5342E-03_JPRB,6.3542E-03_JPRB,5.1981E-03_JPRB,3.4211E-03_JPRB,1.7096E-03_JPRB/)
KBO( :, 3,49,10) = (/&
&8.9294E-03_JPRB,1.0143E-02_JPRB,8.2468E-03_JPRB,5.4196E-03_JPRB,2.4470E-03_JPRB/)
KBO( :, 4,49,10) = (/&
&1.4024E-02_JPRB,1.5765E-02_JPRB,1.2684E-02_JPRB,8.2734E-03_JPRB,3.4129E-03_JPRB/)
KBO( :, 5,49,10) = (/&
&2.1352E-02_JPRB,2.3866E-02_JPRB,1.9075E-02_JPRB,1.2411E-02_JPRB,4.6279E-03_JPRB/)
KBO( :, 1,50,10) = (/&
&2.4929E-03_JPRB,2.8632E-03_JPRB,2.3379E-03_JPRB,1.5440E-03_JPRB,9.3225E-04_JPRB/)
KBO( :, 2,50,10) = (/&
&4.2029E-03_JPRB,4.8752E-03_JPRB,3.9805E-03_JPRB,2.6198E-03_JPRB,1.3576E-03_JPRB/)
KBO( :, 3,50,10) = (/&
&6.9325E-03_JPRB,7.9925E-03_JPRB,6.4974E-03_JPRB,4.2674E-03_JPRB,1.9613E-03_JPRB/)
KBO( :, 4,50,10) = (/&
&1.1158E-02_JPRB,1.2709E-02_JPRB,1.0229E-02_JPRB,6.6644E-03_JPRB,2.7832E-03_JPRB/)
KBO( :, 5,50,10) = (/&
&1.7403E-02_JPRB,1.9642E-02_JPRB,1.5691E-02_JPRB,1.0155E-02_JPRB,3.8333E-03_JPRB/)
KBO( :, 1,51,10) = (/&
&1.8532E-03_JPRB,2.1364E-03_JPRB,1.7376E-03_JPRB,1.1454E-03_JPRB,7.4878E-04_JPRB/)
KBO( :, 2,51,10) = (/&
&3.1888E-03_JPRB,3.7291E-03_JPRB,3.0357E-03_JPRB,1.9945E-03_JPRB,1.0922E-03_JPRB/)
KBO( :, 3,51,10) = (/&
&5.3638E-03_JPRB,6.2780E-03_JPRB,5.0968E-03_JPRB,3.3419E-03_JPRB,1.5858E-03_JPRB/)
KBO( :, 4,51,10) = (/&
&8.8501E-03_JPRB,1.0219E-02_JPRB,8.2277E-03_JPRB,5.3639E-03_JPRB,2.2832E-03_JPRB/)
KBO( :, 5,51,10) = (/&
&1.4149E-02_JPRB,1.6146E-02_JPRB,1.2912E-02_JPRB,8.3171E-03_JPRB,3.2000E-03_JPRB/)
KBO( :, 1,52,10) = (/&
&1.3628E-03_JPRB,1.5783E-03_JPRB,1.2808E-03_JPRB,8.4055E-04_JPRB,6.0012E-04_JPRB/)
KBO( :, 2,52,10) = (/&
&2.4017E-03_JPRB,2.8236E-03_JPRB,2.2905E-03_JPRB,1.5011E-03_JPRB,8.8126E-04_JPRB/)
KBO( :, 3,52,10) = (/&
&4.1169E-03_JPRB,4.8815E-03_JPRB,3.9607E-03_JPRB,2.5906E-03_JPRB,1.2847E-03_JPRB/)
KBO( :, 4,52,10) = (/&
&6.9536E-03_JPRB,8.1559E-03_JPRB,6.5664E-03_JPRB,4.2815E-03_JPRB,1.8638E-03_JPRB/)
KBO( :, 5,52,10) = (/&
&1.1409E-02_JPRB,1.3194E-02_JPRB,1.0553E-02_JPRB,6.7875E-03_JPRB,2.6534E-03_JPRB/)
KBO( :, 1,53,10) = (/&
&9.8606E-04_JPRB,1.1540E-03_JPRB,9.3384E-04_JPRB,6.1040E-04_JPRB,4.7709E-04_JPRB/)
KBO( :, 2,53,10) = (/&
&1.7920E-03_JPRB,2.1145E-03_JPRB,1.7063E-03_JPRB,1.1169E-03_JPRB,7.1312E-04_JPRB/)
KBO( :, 3,53,10) = (/&
&3.1294E-03_JPRB,3.7546E-03_JPRB,3.0421E-03_JPRB,1.9861E-03_JPRB,1.0419E-03_JPRB/)
KBO( :, 4,53,10) = (/&
&5.4059E-03_JPRB,6.4522E-03_JPRB,5.1921E-03_JPRB,3.3816E-03_JPRB,1.5130E-03_JPRB/)
KBO( :, 5,53,10) = (/&
&9.1118E-03_JPRB,1.0696E-02_JPRB,8.5534E-03_JPRB,5.5066E-03_JPRB,2.1843E-03_JPRB/)
KBO( :, 1,54,10) = (/&
&7.2513E-04_JPRB,8.5732E-04_JPRB,6.9183E-04_JPRB,4.5039E-04_JPRB,3.8769E-04_JPRB/)
KBO( :, 2,54,10) = (/&
&1.3639E-03_JPRB,1.6067E-03_JPRB,1.2902E-03_JPRB,8.3972E-04_JPRB,5.9341E-04_JPRB/)
KBO( :, 3,54,10) = (/&
&2.4214E-03_JPRB,2.9176E-03_JPRB,2.3545E-03_JPRB,1.5328E-03_JPRB,8.7214E-04_JPRB/)
KBO( :, 4,54,10) = (/&
&4.2490E-03_JPRB,5.1414E-03_JPRB,4.1362E-03_JPRB,2.6851E-03_JPRB,1.2710E-03_JPRB/)
KBO( :, 5,54,10) = (/&
&7.3277E-03_JPRB,8.7352E-03_JPRB,6.9866E-03_JPRB,4.4974E-03_JPRB,1.8463E-03_JPRB/)
KBO( :, 1,55,10) = (/&
&5.3536E-04_JPRB,6.3819E-04_JPRB,5.1429E-04_JPRB,3.3384E-04_JPRB,3.1787E-04_JPRB/)
KBO( :, 2,55,10) = (/&
&1.0434E-03_JPRB,1.2286E-03_JPRB,9.8197E-04_JPRB,6.3464E-04_JPRB,5.0051E-04_JPRB/)
KBO( :, 3,55,10) = (/&
&1.8896E-03_JPRB,2.2759E-03_JPRB,1.8255E-03_JPRB,1.1820E-03_JPRB,7.4689E-04_JPRB/)
KBO( :, 4,55,10) = (/&
&3.3543E-03_JPRB,4.1000E-03_JPRB,3.2922E-03_JPRB,2.1289E-03_JPRB,1.0910E-03_JPRB/)
KBO( :, 5,55,10) = (/&
&5.8957E-03_JPRB,7.1360E-03_JPRB,5.7072E-03_JPRB,3.6721E-03_JPRB,1.5883E-03_JPRB/)
KBO( :, 1,56,10) = (/&
&3.9041E-04_JPRB,4.6983E-04_JPRB,3.7827E-04_JPRB,2.4495E-04_JPRB,2.5822E-04_JPRB/)
KBO( :, 2,56,10) = (/&
&7.9041E-04_JPRB,9.3554E-04_JPRB,7.4444E-04_JPRB,4.7743E-04_JPRB,4.2098E-04_JPRB/)
KBO( :, 3,56,10) = (/&
&1.4711E-03_JPRB,1.7706E-03_JPRB,1.4085E-03_JPRB,9.0462E-04_JPRB,6.4135E-04_JPRB/)
KBO( :, 4,56,10) = (/&
&2.6410E-03_JPRB,3.2487E-03_JPRB,2.5994E-03_JPRB,1.6753E-03_JPRB,9.4189E-04_JPRB/)
KBO( :, 5,56,10) = (/&
&4.7180E-03_JPRB,5.7942E-03_JPRB,4.6339E-03_JPRB,2.9753E-03_JPRB,1.3744E-03_JPRB/)
KBO( :, 1,57,10) = (/&
&2.8112E-04_JPRB,3.4134E-04_JPRB,2.7460E-04_JPRB,1.7739E-04_JPRB,2.0810E-04_JPRB/)
KBO( :, 2,57,10) = (/&
&5.9233E-04_JPRB,7.0612E-04_JPRB,5.6036E-04_JPRB,3.5724E-04_JPRB,3.5218E-04_JPRB/)
KBO( :, 3,57,10) = (/&
&1.1404E-03_JPRB,1.3698E-03_JPRB,1.0818E-03_JPRB,6.8867E-04_JPRB,5.5095E-04_JPRB/)
KBO( :, 4,57,10) = (/&
&2.0756E-03_JPRB,2.5598E-03_JPRB,2.0389E-03_JPRB,1.3071E-03_JPRB,8.1947E-04_JPRB/)
KBO( :, 5,57,10) = (/&
&3.7565E-03_JPRB,4.6715E-03_JPRB,3.7372E-03_JPRB,2.3897E-03_JPRB,1.1970E-03_JPRB/)
KBO( :, 1,58,10) = (/&
&2.0287E-04_JPRB,2.4841E-04_JPRB,1.9950E-04_JPRB,1.2870E-04_JPRB,1.6873E-04_JPRB/)
KBO( :, 2,58,10) = (/&
&4.4472E-04_JPRB,5.3470E-04_JPRB,4.2292E-04_JPRB,2.6899E-04_JPRB,2.9556E-04_JPRB/)
KBO( :, 3,58,10) = (/&
&8.8909E-04_JPRB,1.0668E-03_JPRB,8.3669E-04_JPRB,5.2917E-04_JPRB,4.7698E-04_JPRB/)
KBO( :, 4,58,10) = (/&
&1.6472E-03_JPRB,2.0319E-03_JPRB,1.6079E-03_JPRB,1.0235E-03_JPRB,7.2222E-04_JPRB/)
KBO( :, 5,58,10) = (/&
&3.0142E-03_JPRB,3.7808E-03_JPRB,3.0200E-03_JPRB,1.9230E-03_JPRB,1.0578E-03_JPRB/)
KBO( :, 1,59,10) = (/&
&1.7264E-04_JPRB,2.1252E-04_JPRB,1.6979E-04_JPRB,1.0877E-04_JPRB,1.5535E-04_JPRB/)
KBO( :, 2,59,10) = (/&
&3.8844E-04_JPRB,4.6892E-04_JPRB,3.6892E-04_JPRB,2.3285E-04_JPRB,2.7770E-04_JPRB/)
KBO( :, 3,59,10) = (/&
&7.9313E-04_JPRB,9.5358E-04_JPRB,7.4242E-04_JPRB,4.6490E-04_JPRB,4.5611E-04_JPRB/)
KBO( :, 4,59,10) = (/&
&1.4888E-03_JPRB,1.8362E-03_JPRB,1.4437E-03_JPRB,9.0907E-04_JPRB,6.9878E-04_JPRB/)
KBO( :, 5,59,10) = (/&
&2.7412E-03_JPRB,3.4444E-03_JPRB,2.7403E-03_JPRB,1.7293E-03_JPRB,1.0280E-03_JPRB/)
KBO( :, 1,13,11) = (/&
&4.6582E-01_JPRB,4.3126E-01_JPRB,3.9148E-01_JPRB,2.9782E-01_JPRB,2.0038E+00_JPRB/)
KBO( :, 2,13,11) = (/&
&6.6015E-01_JPRB,6.1362E-01_JPRB,5.5564E-01_JPRB,4.1997E-01_JPRB,2.1506E+00_JPRB/)
KBO( :, 3,13,11) = (/&
&8.9186E-01_JPRB,8.3255E-01_JPRB,7.5032E-01_JPRB,5.6975E-01_JPRB,2.2970E+00_JPRB/)
KBO( :, 4,13,11) = (/&
&1.1586E+00_JPRB,1.0869E+00_JPRB,9.7359E-01_JPRB,7.4196E-01_JPRB,2.4271E+00_JPRB/)
KBO( :, 5,13,11) = (/&
&1.4563E+00_JPRB,1.3761E+00_JPRB,1.2287E+00_JPRB,9.3624E-01_JPRB,2.5537E+00_JPRB/)
KBO( :, 1,14,11) = (/&
&4.6622E-01_JPRB,4.4694E-01_JPRB,4.0621E-01_JPRB,3.0517E-01_JPRB,1.9239E+00_JPRB/)
KBO( :, 2,14,11) = (/&
&6.5626E-01_JPRB,6.3097E-01_JPRB,5.7029E-01_JPRB,4.3017E-01_JPRB,2.0659E+00_JPRB/)
KBO( :, 3,14,11) = (/&
&8.8153E-01_JPRB,8.5029E-01_JPRB,7.6391E-01_JPRB,5.8015E-01_JPRB,2.1968E+00_JPRB/)
KBO( :, 4,14,11) = (/&
&1.1396E+00_JPRB,1.1043E+00_JPRB,9.8836E-01_JPRB,7.5006E-01_JPRB,2.3180E+00_JPRB/)
KBO( :, 5,14,11) = (/&
&1.4290E+00_JPRB,1.3870E+00_JPRB,1.2407E+00_JPRB,9.4051E-01_JPRB,2.4548E+00_JPRB/)
KBO( :, 1,15,11) = (/&
&4.5814E-01_JPRB,4.5398E-01_JPRB,4.1054E-01_JPRB,3.0839E-01_JPRB,1.6835E+00_JPRB/)
KBO( :, 2,15,11) = (/&
&6.4005E-01_JPRB,6.3563E-01_JPRB,5.7202E-01_JPRB,4.3265E-01_JPRB,1.8044E+00_JPRB/)
KBO( :, 3,15,11) = (/&
&8.5481E-01_JPRB,8.5188E-01_JPRB,7.6325E-01_JPRB,5.7776E-01_JPRB,1.9216E+00_JPRB/)
KBO( :, 4,15,11) = (/&
&1.1011E+00_JPRB,1.0984E+00_JPRB,9.8470E-01_JPRB,7.4242E-01_JPRB,2.0480E+00_JPRB/)
KBO( :, 5,15,11) = (/&
&1.3789E+00_JPRB,1.3707E+00_JPRB,1.2263E+00_JPRB,9.2692E-01_JPRB,2.1662E+00_JPRB/)
KBO( :, 1,16,11) = (/&
&4.3936E-01_JPRB,4.5055E-01_JPRB,4.0610E-01_JPRB,3.0607E-01_JPRB,1.3891E+00_JPRB/)
KBO( :, 2,16,11) = (/&
&6.0980E-01_JPRB,6.2580E-01_JPRB,5.6205E-01_JPRB,4.2411E-01_JPRB,1.4937E+00_JPRB/)
KBO( :, 3,16,11) = (/&
&8.1051E-01_JPRB,8.3041E-01_JPRB,7.4762E-01_JPRB,5.6219E-01_JPRB,1.6024E+00_JPRB/)
KBO( :, 4,16,11) = (/&
&1.0423E+00_JPRB,1.0629E+00_JPRB,9.5636E-01_JPRB,7.1926E-01_JPRB,1.7074E+00_JPRB/)
KBO( :, 5,16,11) = (/&
&1.3012E+00_JPRB,1.3270E+00_JPRB,1.1867E+00_JPRB,8.9662E-01_JPRB,1.8065E+00_JPRB/)
KBO( :, 1,17,11) = (/&
&4.1226E-01_JPRB,4.3606E-01_JPRB,3.9203E-01_JPRB,2.9614E-01_JPRB,1.1476E+00_JPRB/)
KBO( :, 2,17,11) = (/&
&5.6889E-01_JPRB,6.0078E-01_JPRB,5.4100E-01_JPRB,4.0607E-01_JPRB,1.2378E+00_JPRB/)
KBO( :, 3,17,11) = (/&
&7.5475E-01_JPRB,7.9223E-01_JPRB,7.1421E-01_JPRB,5.3429E-01_JPRB,1.3294E+00_JPRB/)
KBO( :, 4,17,11) = (/&
&9.6747E-01_JPRB,1.0124E+00_JPRB,9.0807E-01_JPRB,6.8194E-01_JPRB,1.4124E+00_JPRB/)
KBO( :, 5,17,11) = (/&
&1.1994E+00_JPRB,1.2593E+00_JPRB,1.1261E+00_JPRB,8.5185E-01_JPRB,1.4955E+00_JPRB/)
KBO( :, 1,18,11) = (/&
&3.8064E-01_JPRB,4.1279E-01_JPRB,3.7089E-01_JPRB,2.7981E-01_JPRB,9.7150E-01_JPRB/)
KBO( :, 2,18,11) = (/&
&5.2358E-01_JPRB,5.6462E-01_JPRB,5.0829E-01_JPRB,3.8105E-01_JPRB,1.0549E+00_JPRB/)
KBO( :, 3,18,11) = (/&
&6.9263E-01_JPRB,7.4312E-01_JPRB,6.6621E-01_JPRB,4.9871E-01_JPRB,1.1339E+00_JPRB/)
KBO( :, 4,18,11) = (/&
&8.8229E-01_JPRB,9.4872E-01_JPRB,8.4607E-01_JPRB,6.3576E-01_JPRB,1.2109E+00_JPRB/)
KBO( :, 5,18,11) = (/&
&1.0918E+00_JPRB,1.1715E+00_JPRB,1.0485E+00_JPRB,7.9321E-01_JPRB,1.2966E+00_JPRB/)
KBO( :, 1,19,11) = (/&
&3.4707E-01_JPRB,3.8254E-01_JPRB,3.4362E-01_JPRB,2.5858E-01_JPRB,8.6524E-01_JPRB/)
KBO( :, 2,19,11) = (/&
&4.7624E-01_JPRB,5.2177E-01_JPRB,4.6660E-01_JPRB,3.5041E-01_JPRB,9.4567E-01_JPRB/)
KBO( :, 3,19,11) = (/&
&6.2671E-01_JPRB,6.8651E-01_JPRB,6.0965E-01_JPRB,4.5831E-01_JPRB,1.0244E+00_JPRB/)
KBO( :, 4,19,11) = (/&
&7.9653E-01_JPRB,8.7098E-01_JPRB,7.7442E-01_JPRB,5.8401E-01_JPRB,1.1073E+00_JPRB/)
KBO( :, 5,19,11) = (/&
&9.8427E-01_JPRB,1.0726E+00_JPRB,9.5997E-01_JPRB,7.2540E-01_JPRB,1.1966E+00_JPRB/)
KBO( :, 1,20,11) = (/&
&3.1567E-01_JPRB,3.5181E-01_JPRB,3.1444E-01_JPRB,2.3622E-01_JPRB,8.0158E-01_JPRB/)
KBO( :, 2,20,11) = (/&
&4.3131E-01_JPRB,4.7923E-01_JPRB,4.2436E-01_JPRB,3.1880E-01_JPRB,8.8081E-01_JPRB/)
KBO( :, 3,20,11) = (/&
&5.6512E-01_JPRB,6.2700E-01_JPRB,5.5312E-01_JPRB,4.1741E-01_JPRB,9.6113E-01_JPRB/)
KBO( :, 4,20,11) = (/&
&7.1661E-01_JPRB,7.9159E-01_JPRB,7.0178E-01_JPRB,5.3032E-01_JPRB,1.0489E+00_JPRB/)
KBO( :, 5,20,11) = (/&
&8.8236E-01_JPRB,9.7468E-01_JPRB,8.6952E-01_JPRB,6.5743E-01_JPRB,1.1372E+00_JPRB/)
KBO( :, 1,21,11) = (/&
&2.8592E-01_JPRB,3.2074E-01_JPRB,2.8394E-01_JPRB,2.1333E-01_JPRB,7.4290E-01_JPRB/)
KBO( :, 2,21,11) = (/&
&3.8826E-01_JPRB,4.3502E-01_JPRB,3.8223E-01_JPRB,2.8797E-01_JPRB,8.2178E-01_JPRB/)
KBO( :, 3,21,11) = (/&
&5.0741E-01_JPRB,5.6572E-01_JPRB,4.9792E-01_JPRB,3.7590E-01_JPRB,9.0519E-01_JPRB/)
KBO( :, 4,21,11) = (/&
&6.4058E-01_JPRB,7.1340E-01_JPRB,6.3080E-01_JPRB,4.7663E-01_JPRB,9.9225E-01_JPRB/)
KBO( :, 5,21,11) = (/&
&7.8811E-01_JPRB,8.7944E-01_JPRB,7.7953E-01_JPRB,5.8917E-01_JPRB,1.0812E+00_JPRB/)
KBO( :, 1,22,11) = (/&
&2.6349E-01_JPRB,2.9660E-01_JPRB,2.5964E-01_JPRB,1.9557E-01_JPRB,6.7570E-01_JPRB/)
KBO( :, 2,22,11) = (/&
&3.5527E-01_JPRB,3.9835E-01_JPRB,3.4850E-01_JPRB,2.6305E-01_JPRB,7.5224E-01_JPRB/)
KBO( :, 3,22,11) = (/&
&4.6050E-01_JPRB,5.1538E-01_JPRB,4.5315E-01_JPRB,3.4161E-01_JPRB,8.3620E-01_JPRB/)
KBO( :, 4,22,11) = (/&
&5.8034E-01_JPRB,6.4971E-01_JPRB,5.7124E-01_JPRB,4.3148E-01_JPRB,9.2191E-01_JPRB/)
KBO( :, 5,22,11) = (/&
&7.1598E-01_JPRB,7.9992E-01_JPRB,7.0387E-01_JPRB,5.3098E-01_JPRB,1.0108E+00_JPRB/)
KBO( :, 1,23,11) = (/&
&2.4294E-01_JPRB,2.7306E-01_JPRB,2.3732E-01_JPRB,1.7872E-01_JPRB,6.0705E-01_JPRB/)
KBO( :, 2,23,11) = (/&
&3.2497E-01_JPRB,3.6372E-01_JPRB,3.1788E-01_JPRB,2.3869E-01_JPRB,6.8421E-01_JPRB/)
KBO( :, 3,23,11) = (/&
&4.2067E-01_JPRB,4.6941E-01_JPRB,4.1072E-01_JPRB,3.0874E-01_JPRB,7.6600E-01_JPRB/)
KBO( :, 4,23,11) = (/&
&5.3164E-01_JPRB,5.9097E-01_JPRB,5.1614E-01_JPRB,3.8792E-01_JPRB,8.5300E-01_JPRB/)
KBO( :, 5,23,11) = (/&
&6.5861E-01_JPRB,7.2844E-01_JPRB,6.3392E-01_JPRB,4.7757E-01_JPRB,9.4241E-01_JPRB/)
KBO( :, 1,24,11) = (/&
&2.2482E-01_JPRB,2.5108E-01_JPRB,2.1802E-01_JPRB,1.6286E-01_JPRB,5.3854E-01_JPRB/)
KBO( :, 2,24,11) = (/&
&2.9997E-01_JPRB,3.3291E-01_JPRB,2.8985E-01_JPRB,2.1640E-01_JPRB,6.1678E-01_JPRB/)
KBO( :, 3,24,11) = (/&
&3.8949E-01_JPRB,4.2945E-01_JPRB,3.7259E-01_JPRB,2.7841E-01_JPRB,6.9947E-01_JPRB/)
KBO( :, 4,24,11) = (/&
&4.9475E-01_JPRB,5.4040E-01_JPRB,4.6781E-01_JPRB,3.4874E-01_JPRB,7.8678E-01_JPRB/)
KBO( :, 5,24,11) = (/&
&6.1688E-01_JPRB,6.6845E-01_JPRB,5.7526E-01_JPRB,4.2946E-01_JPRB,8.7638E-01_JPRB/)
KBO( :, 1,25,11) = (/&
&2.0867E-01_JPRB,2.3175E-01_JPRB,2.0085E-01_JPRB,1.4849E-01_JPRB,4.8336E-01_JPRB/)
KBO( :, 2,25,11) = (/&
&2.7944E-01_JPRB,3.0729E-01_JPRB,2.6487E-01_JPRB,1.9609E-01_JPRB,5.5823E-01_JPRB/)
KBO( :, 3,25,11) = (/&
&3.6506E-01_JPRB,3.9632E-01_JPRB,3.4020E-01_JPRB,2.5115E-01_JPRB,6.3661E-01_JPRB/)
KBO( :, 4,25,11) = (/&
&4.6727E-01_JPRB,5.0070E-01_JPRB,4.2731E-01_JPRB,3.1512E-01_JPRB,7.1582E-01_JPRB/)
KBO( :, 5,25,11) = (/&
&5.8636E-01_JPRB,6.2209E-01_JPRB,5.2796E-01_JPRB,3.8925E-01_JPRB,7.9834E-01_JPRB/)
KBO( :, 1,26,11) = (/&
&1.9587E-01_JPRB,2.1594E-01_JPRB,1.8576E-01_JPRB,1.3602E-01_JPRB,4.3426E-01_JPRB/)
KBO( :, 2,26,11) = (/&
&2.6382E-01_JPRB,2.8676E-01_JPRB,2.4459E-01_JPRB,1.7873E-01_JPRB,5.0085E-01_JPRB/)
KBO( :, 3,26,11) = (/&
&3.4692E-01_JPRB,3.7120E-01_JPRB,3.1465E-01_JPRB,2.2874E-01_JPRB,5.6934E-01_JPRB/)
KBO( :, 4,26,11) = (/&
&4.4520E-01_JPRB,4.7181E-01_JPRB,3.9637E-01_JPRB,2.8766E-01_JPRB,6.3969E-01_JPRB/)
KBO( :, 5,26,11) = (/&
&5.5605E-01_JPRB,5.8855E-01_JPRB,4.9195E-01_JPRB,3.5675E-01_JPRB,7.1476E-01_JPRB/)
KBO( :, 1,27,11) = (/&
&1.8539E-01_JPRB,2.0232E-01_JPRB,1.7242E-01_JPRB,1.2491E-01_JPRB,3.7468E-01_JPRB/)
KBO( :, 2,27,11) = (/&
&2.5096E-01_JPRB,2.6936E-01_JPRB,2.2766E-01_JPRB,1.6372E-01_JPRB,4.3134E-01_JPRB/)
KBO( :, 3,27,11) = (/&
&3.2985E-01_JPRB,3.5118E-01_JPRB,2.9380E-01_JPRB,2.1018E-01_JPRB,4.9024E-01_JPRB/)
KBO( :, 4,27,11) = (/&
&4.2050E-01_JPRB,4.4779E-01_JPRB,3.7245E-01_JPRB,2.6552E-01_JPRB,5.5373E-01_JPRB/)
KBO( :, 5,27,11) = (/&
&5.2353E-01_JPRB,5.5799E-01_JPRB,4.6451E-01_JPRB,3.2979E-01_JPRB,6.2244E-01_JPRB/)
KBO( :, 1,28,11) = (/&
&1.7670E-01_JPRB,1.9079E-01_JPRB,1.6081E-01_JPRB,1.1550E-01_JPRB,3.1173E-01_JPRB/)
KBO( :, 2,28,11) = (/&
&2.3816E-01_JPRB,2.5545E-01_JPRB,2.1349E-01_JPRB,1.5165E-01_JPRB,3.6015E-01_JPRB/)
KBO( :, 3,28,11) = (/&
&3.1046E-01_JPRB,3.3329E-01_JPRB,2.7692E-01_JPRB,1.9535E-01_JPRB,4.1203E-01_JPRB/)
KBO( :, 4,28,11) = (/&
&3.9421E-01_JPRB,4.2355E-01_JPRB,3.5226E-01_JPRB,2.4753E-01_JPRB,4.6881E-01_JPRB/)
KBO( :, 5,28,11) = (/&
&4.9113E-01_JPRB,5.2757E-01_JPRB,4.3988E-01_JPRB,3.0817E-01_JPRB,5.2989E-01_JPRB/)
KBO( :, 1,29,11) = (/&
&1.6843E-01_JPRB,1.8154E-01_JPRB,1.5154E-01_JPRB,1.0767E-01_JPRB,2.5441E-01_JPRB/)
KBO( :, 2,29,11) = (/&
&2.2466E-01_JPRB,2.4270E-01_JPRB,2.0190E-01_JPRB,1.4201E-01_JPRB,2.9556E-01_JPRB/)
KBO( :, 3,29,11) = (/&
&2.9126E-01_JPRB,3.1537E-01_JPRB,2.6232E-01_JPRB,1.8387E-01_JPRB,3.4113E-01_JPRB/)
KBO( :, 4,29,11) = (/&
&3.6983E-01_JPRB,4.0011E-01_JPRB,3.3340E-01_JPRB,2.3338E-01_JPRB,3.9100E-01_JPRB/)
KBO( :, 5,29,11) = (/&
&4.6101E-01_JPRB,4.9867E-01_JPRB,4.1663E-01_JPRB,2.9053E-01_JPRB,4.4464E-01_JPRB/)
KBO( :, 1,30,11) = (/&
&1.5959E-01_JPRB,1.7262E-01_JPRB,1.4374E-01_JPRB,1.0130E-01_JPRB,2.0471E-01_JPRB/)
KBO( :, 2,30,11) = (/&
&2.1115E-01_JPRB,2.2963E-01_JPRB,1.9116E-01_JPRB,1.3421E-01_JPRB,2.4020E-01_JPRB/)
KBO( :, 3,30,11) = (/&
&2.7360E-01_JPRB,2.9740E-01_JPRB,2.4795E-01_JPRB,1.7403E-01_JPRB,2.7968E-01_JPRB/)
KBO( :, 4,30,11) = (/&
&3.4764E-01_JPRB,3.7756E-01_JPRB,3.1549E-01_JPRB,2.2070E-01_JPRB,3.2281E-01_JPRB/)
KBO( :, 5,30,11) = (/&
&4.3440E-01_JPRB,4.7219E-01_JPRB,3.9465E-01_JPRB,2.7465E-01_JPRB,3.6896E-01_JPRB/)
KBO( :, 1,31,11) = (/&
&1.5091E-01_JPRB,1.6391E-01_JPRB,1.3645E-01_JPRB,9.6278E-02_JPRB,1.6289E-01_JPRB/)
KBO( :, 2,31,11) = (/&
&1.9931E-01_JPRB,2.1721E-01_JPRB,1.8079E-01_JPRB,1.2771E-01_JPRB,1.9309E-01_JPRB/)
KBO( :, 3,31,11) = (/&
&2.5821E-01_JPRB,2.8109E-01_JPRB,2.3449E-01_JPRB,1.6502E-01_JPRB,2.2676E-01_JPRB/)
KBO( :, 4,31,11) = (/&
&3.2875E-01_JPRB,3.5829E-01_JPRB,2.9898E-01_JPRB,2.0919E-01_JPRB,2.6370E-01_JPRB/)
KBO( :, 5,31,11) = (/&
&4.1157E-01_JPRB,4.5002E-01_JPRB,3.7499E-01_JPRB,2.6064E-01_JPRB,3.0365E-01_JPRB/)
KBO( :, 1,32,11) = (/&
&1.4350E-01_JPRB,1.5577E-01_JPRB,1.2948E-01_JPRB,9.1911E-02_JPRB,1.3126E-01_JPRB/)
KBO( :, 2,32,11) = (/&
&1.8927E-01_JPRB,2.0591E-01_JPRB,1.7137E-01_JPRB,1.2148E-01_JPRB,1.5712E-01_JPRB/)
KBO( :, 3,32,11) = (/&
&2.4542E-01_JPRB,2.6745E-01_JPRB,2.2265E-01_JPRB,1.5686E-01_JPRB,1.8606E-01_JPRB/)
KBO( :, 4,32,11) = (/&
&3.1299E-01_JPRB,3.4211E-01_JPRB,2.8464E-01_JPRB,1.9879E-01_JPRB,2.1776E-01_JPRB/)
KBO( :, 5,32,11) = (/&
&3.9189E-01_JPRB,4.3154E-01_JPRB,3.5784E-01_JPRB,2.4869E-01_JPRB,2.5261E-01_JPRB/)
KBO( :, 1,33,11) = (/&
&1.3727E-01_JPRB,1.4838E-01_JPRB,1.2325E-01_JPRB,8.7723E-02_JPRB,1.0656E-01_JPRB/)
KBO( :, 2,33,11) = (/&
&1.8110E-01_JPRB,1.9647E-01_JPRB,1.6322E-01_JPRB,1.1562E-01_JPRB,1.2867E-01_JPRB/)
KBO( :, 3,33,11) = (/&
&2.3493E-01_JPRB,2.5633E-01_JPRB,2.1260E-01_JPRB,1.4945E-01_JPRB,1.5344E-01_JPRB/)
KBO( :, 4,33,11) = (/&
&2.9930E-01_JPRB,3.2911E-01_JPRB,2.7241E-01_JPRB,1.8991E-01_JPRB,1.8112E-01_JPRB/)
KBO( :, 5,33,11) = (/&
&3.7491E-01_JPRB,4.1658E-01_JPRB,3.4340E-01_JPRB,2.3867E-01_JPRB,2.1188E-01_JPRB/)
KBO( :, 1,34,11) = (/&
&1.3092E-01_JPRB,1.4094E-01_JPRB,1.1667E-01_JPRB,8.2911E-02_JPRB,8.9471E-02_JPRB/)
KBO( :, 2,34,11) = (/&
&1.7283E-01_JPRB,1.8720E-01_JPRB,1.5498E-01_JPRB,1.0945E-01_JPRB,1.0879E-01_JPRB/)
KBO( :, 3,34,11) = (/&
&2.2423E-01_JPRB,2.4508E-01_JPRB,2.0247E-01_JPRB,1.4175E-01_JPRB,1.3067E-01_JPRB/)
KBO( :, 4,34,11) = (/&
&2.8568E-01_JPRB,3.1613E-01_JPRB,2.6022E-01_JPRB,1.8119E-01_JPRB,1.5551E-01_JPRB/)
KBO( :, 5,34,11) = (/&
&3.5836E-01_JPRB,4.0157E-01_JPRB,3.2942E-01_JPRB,2.2886E-01_JPRB,1.8335E-01_JPRB/)
KBO( :, 1,35,11) = (/&
&1.2228E-01_JPRB,1.3118E-01_JPRB,1.0815E-01_JPRB,7.6480E-02_JPRB,7.3770E-02_JPRB/)
KBO( :, 2,35,11) = (/&
&1.6172E-01_JPRB,1.7516E-01_JPRB,1.4419E-01_JPRB,1.0138E-01_JPRB,9.0532E-02_JPRB/)
KBO( :, 3,35,11) = (/&
&2.1005E-01_JPRB,2.3024E-01_JPRB,1.8936E-01_JPRB,1.3212E-01_JPRB,1.0977E-01_JPRB/)
KBO( :, 4,35,11) = (/&
&2.6823E-01_JPRB,2.9837E-01_JPRB,2.4450E-01_JPRB,1.7010E-01_JPRB,1.3152E-01_JPRB/)
KBO( :, 5,35,11) = (/&
&3.3803E-01_JPRB,3.8069E-01_JPRB,3.1151E-01_JPRB,2.1623E-01_JPRB,1.5639E-01_JPRB/)
KBO( :, 1,36,11) = (/&
&1.1127E-01_JPRB,1.1902E-01_JPRB,9.7790E-02_JPRB,6.8652E-02_JPRB,5.9294E-02_JPRB/)
KBO( :, 2,36,11) = (/&
&1.4779E-01_JPRB,1.5991E-01_JPRB,1.3100E-01_JPRB,9.1678E-02_JPRB,7.3428E-02_JPRB/)
KBO( :, 3,36,11) = (/&
&1.9248E-01_JPRB,2.1152E-01_JPRB,1.7310E-01_JPRB,1.2044E-01_JPRB,8.9931E-02_JPRB/)
KBO( :, 4,36,11) = (/&
&2.4698E-01_JPRB,2.7546E-01_JPRB,2.2513E-01_JPRB,1.5635E-01_JPRB,1.0865E-01_JPRB/)
KBO( :, 5,36,11) = (/&
&3.1312E-01_JPRB,3.5357E-01_JPRB,2.8900E-01_JPRB,2.0028E-01_JPRB,1.3007E-01_JPRB/)
KBO( :, 1,37,11) = (/&
&9.7171E-02_JPRB,1.0370E-01_JPRB,8.4930E-02_JPRB,5.9132E-02_JPRB,4.8800E-02_JPRB/)
KBO( :, 2,37,11) = (/&
&1.3022E-01_JPRB,1.4042E-01_JPRB,1.1467E-01_JPRB,7.9788E-02_JPRB,6.1101E-02_JPRB/)
KBO( :, 3,37,11) = (/&
&1.7053E-01_JPRB,1.8732E-01_JPRB,1.5267E-01_JPRB,1.0592E-01_JPRB,7.5549E-02_JPRB/)
KBO( :, 4,37,11) = (/&
&2.2021E-01_JPRB,2.4584E-01_JPRB,2.0025E-01_JPRB,1.3887E-01_JPRB,9.2123E-02_JPRB/)
KBO( :, 5,37,11) = (/&
&2.8142E-01_JPRB,3.1806E-01_JPRB,2.5954E-01_JPRB,1.7970E-01_JPRB,1.1114E-01_JPRB/)
KBO( :, 1,38,11) = (/&
&8.4750E-02_JPRB,9.0447E-02_JPRB,7.3862E-02_JPRB,5.1024E-02_JPRB,4.0120E-02_JPRB/)
KBO( :, 2,38,11) = (/&
&1.1472E-01_JPRB,1.2347E-01_JPRB,1.0053E-01_JPRB,6.9437E-02_JPRB,5.0776E-02_JPRB/)
KBO( :, 3,38,11) = (/&
&1.5136E-01_JPRB,1.6607E-01_JPRB,1.3499E-01_JPRB,9.3219E-02_JPRB,6.3385E-02_JPRB/)
KBO( :, 4,38,11) = (/&
&1.9680E-01_JPRB,2.1978E-01_JPRB,1.7847E-01_JPRB,1.2347E-01_JPRB,7.8006E-02_JPRB/)
KBO( :, 5,38,11) = (/&
&2.5341E-01_JPRB,2.8675E-01_JPRB,2.3338E-01_JPRB,1.6145E-01_JPRB,9.4840E-02_JPRB/)
KBO( :, 1,39,11) = (/&
&7.4011E-02_JPRB,7.9191E-02_JPRB,6.4478E-02_JPRB,4.4207E-02_JPRB,3.2805E-02_JPRB/)
KBO( :, 2,39,11) = (/&
&1.0122E-01_JPRB,1.0907E-01_JPRB,8.8541E-02_JPRB,6.0759E-02_JPRB,4.1971E-02_JPRB/)
KBO( :, 3,39,11) = (/&
&1.3478E-01_JPRB,1.4779E-01_JPRB,1.1992E-01_JPRB,8.2325E-02_JPRB,5.2901E-02_JPRB/)
KBO( :, 4,39,11) = (/&
&1.7660E-01_JPRB,1.9727E-01_JPRB,1.5986E-01_JPRB,1.1017E-01_JPRB,6.5730E-02_JPRB/)
KBO( :, 5,39,11) = (/&
&2.2909E-01_JPRB,2.5986E-01_JPRB,2.1074E-01_JPRB,1.4557E-01_JPRB,8.0505E-02_JPRB/)
KBO( :, 1,40,11) = (/&
&6.2473E-02_JPRB,6.7073E-02_JPRB,5.4566E-02_JPRB,3.7187E-02_JPRB,2.6885E-02_JPRB/)
KBO( :, 2,40,11) = (/&
&8.6606E-02_JPRB,9.3644E-02_JPRB,7.5801E-02_JPRB,5.1661E-02_JPRB,3.4836E-02_JPRB/)
KBO( :, 3,40,11) = (/&
&1.1680E-01_JPRB,1.2799E-01_JPRB,1.0372E-01_JPRB,7.0693E-02_JPRB,4.4368E-02_JPRB/)
KBO( :, 4,40,11) = (/&
&1.5470E-01_JPRB,1.7247E-01_JPRB,1.3960E-01_JPRB,9.5679E-02_JPRB,5.5687E-02_JPRB/)
KBO( :, 5,40,11) = (/&
&2.0237E-01_JPRB,2.2977E-01_JPRB,1.8573E-01_JPRB,1.2793E-01_JPRB,6.8850E-02_JPRB/)
KBO( :, 1,41,11) = (/&
&5.2446E-02_JPRB,5.6507E-02_JPRB,4.5959E-02_JPRB,3.1195E-02_JPRB,2.1948E-02_JPRB/)
KBO( :, 2,41,11) = (/&
&7.3701E-02_JPRB,8.0111E-02_JPRB,6.4714E-02_JPRB,4.3819E-02_JPRB,2.8834E-02_JPRB/)
KBO( :, 3,41,11) = (/&
&1.0076E-01_JPRB,1.1070E-01_JPRB,8.9512E-02_JPRB,6.0576E-02_JPRB,3.7158E-02_JPRB/)
KBO( :, 4,41,11) = (/&
&1.3508E-01_JPRB,1.5057E-01_JPRB,1.2175E-01_JPRB,8.2892E-02_JPRB,4.7100E-02_JPRB/)
KBO( :, 5,41,11) = (/&
&1.7854E-01_JPRB,2.0269E-01_JPRB,1.6356E-01_JPRB,1.1214E-01_JPRB,5.8823E-02_JPRB/)
KBO( :, 1,42,11) = (/&
&4.3993E-02_JPRB,4.7543E-02_JPRB,3.8628E-02_JPRB,2.6175E-02_JPRB,1.7822E-02_JPRB/)
KBO( :, 2,42,11) = (/&
&6.2618E-02_JPRB,6.8461E-02_JPRB,5.5301E-02_JPRB,3.7217E-02_JPRB,2.3728E-02_JPRB/)
KBO( :, 3,42,11) = (/&
&8.6814E-02_JPRB,9.5948E-02_JPRB,7.7328E-02_JPRB,5.2009E-02_JPRB,3.0953E-02_JPRB/)
KBO( :, 4,42,11) = (/&
&1.1793E-01_JPRB,1.3165E-01_JPRB,1.0635E-01_JPRB,7.1967E-02_JPRB,3.9679E-02_JPRB/)
KBO( :, 5,42,11) = (/&
&1.5767E-01_JPRB,1.7909E-01_JPRB,1.4430E-01_JPRB,9.8414E-02_JPRB,5.0031E-02_JPRB/)
KBO( :, 1,43,11) = (/&
&3.6051E-02_JPRB,3.9068E-02_JPRB,3.1700E-02_JPRB,2.1500E-02_JPRB,1.4336E-02_JPRB/)
KBO( :, 2,43,11) = (/&
&5.2131E-02_JPRB,5.7262E-02_JPRB,4.6240E-02_JPRB,3.1003E-02_JPRB,1.9367E-02_JPRB/)
KBO( :, 3,43,11) = (/&
&7.3341E-02_JPRB,8.1590E-02_JPRB,6.5706E-02_JPRB,4.3880E-02_JPRB,2.5604E-02_JPRB/)
KBO( :, 4,43,11) = (/&
&1.0113E-01_JPRB,1.1336E-01_JPRB,9.1355E-02_JPRB,6.1391E-02_JPRB,3.3210E-02_JPRB/)
KBO( :, 5,43,11) = (/&
&1.3704E-01_JPRB,1.5566E-01_JPRB,1.2530E-01_JPRB,8.4984E-02_JPRB,4.2357E-02_JPRB/)
KBO( :, 1,44,11) = (/&
&2.9153E-02_JPRB,3.1689E-02_JPRB,2.5651E-02_JPRB,1.7398E-02_JPRB,1.1452E-02_JPRB/)
KBO( :, 2,44,11) = (/&
&4.2894E-02_JPRB,4.7271E-02_JPRB,3.8161E-02_JPRB,2.5559E-02_JPRB,1.5702E-02_JPRB/)
KBO( :, 3,44,11) = (/&
&6.1316E-02_JPRB,6.8606E-02_JPRB,5.5241E-02_JPRB,3.6706E-02_JPRB,2.1051E-02_JPRB/)
KBO( :, 4,44,11) = (/&
&8.5809E-02_JPRB,9.6811E-02_JPRB,7.7867E-02_JPRB,5.1972E-02_JPRB,2.7643E-02_JPRB/)
KBO( :, 5,44,11) = (/&
&1.1804E-01_JPRB,1.3427E-01_JPRB,1.0805E-01_JPRB,7.2832E-02_JPRB,3.5698E-02_JPRB/)
KBO( :, 1,45,11) = (/&
&2.3474E-02_JPRB,2.5620E-02_JPRB,2.0683E-02_JPRB,1.3992E-02_JPRB,9.0872E-03_JPRB/)
KBO( :, 2,45,11) = (/&
&3.5168E-02_JPRB,3.8884E-02_JPRB,3.1357E-02_JPRB,2.0998E-02_JPRB,1.2650E-02_JPRB/)
KBO( :, 3,45,11) = (/&
&5.1125E-02_JPRB,5.7479E-02_JPRB,4.6268E-02_JPRB,3.0685E-02_JPRB,1.7188E-02_JPRB/)
KBO( :, 4,45,11) = (/&
&7.2642E-02_JPRB,8.2540E-02_JPRB,6.6385E-02_JPRB,4.3982E-02_JPRB,2.2878E-02_JPRB/)
KBO( :, 5,45,11) = (/&
&1.0141E-01_JPRB,1.1593E-01_JPRB,9.3129E-02_JPRB,6.2384E-02_JPRB,2.9912E-02_JPRB/)
KBO( :, 1,46,11) = (/&
&1.8622E-02_JPRB,2.0419E-02_JPRB,1.6446E-02_JPRB,1.1089E-02_JPRB,7.1508E-03_JPRB/)
KBO( :, 2,46,11) = (/&
&2.8465E-02_JPRB,3.1591E-02_JPRB,2.5425E-02_JPRB,1.7003E-02_JPRB,1.0100E-02_JPRB/)
KBO( :, 3,46,11) = (/&
&4.2115E-02_JPRB,4.7558E-02_JPRB,3.8296E-02_JPRB,2.5381E-02_JPRB,1.3928E-02_JPRB/)
KBO( :, 4,46,11) = (/&
&6.0884E-02_JPRB,6.9606E-02_JPRB,5.6000E-02_JPRB,3.6888E-02_JPRB,1.8798E-02_JPRB/)
KBO( :, 5,46,11) = (/&
&8.6271E-02_JPRB,9.9295E-02_JPRB,7.9645E-02_JPRB,5.2994E-02_JPRB,2.4873E-02_JPRB/)
KBO( :, 1,47,11) = (/&
&1.4376E-02_JPRB,1.5849E-02_JPRB,1.2756E-02_JPRB,8.5637E-03_JPRB,5.5846E-03_JPRB/)
KBO( :, 2,47,11) = (/&
&2.2523E-02_JPRB,2.5091E-02_JPRB,2.0133E-02_JPRB,1.3433E-02_JPRB,8.0135E-03_JPRB/)
KBO( :, 3,47,11) = (/&
&3.3987E-02_JPRB,3.8521E-02_JPRB,3.0971E-02_JPRB,2.0498E-02_JPRB,1.1217E-02_JPRB/)
KBO( :, 4,47,11) = (/&
&4.9995E-02_JPRB,5.7475E-02_JPRB,4.6271E-02_JPRB,3.0427E-02_JPRB,1.5354E-02_JPRB/)
KBO( :, 5,47,11) = (/&
&7.2095E-02_JPRB,8.3553E-02_JPRB,6.7099E-02_JPRB,4.4249E-02_JPRB,2.0567E-02_JPRB/)
KBO( :, 1,48,11) = (/&
&1.0948E-02_JPRB,1.2187E-02_JPRB,9.8197E-03_JPRB,6.5686E-03_JPRB,4.3309E-03_JPRB/)
KBO( :, 2,48,11) = (/&
&1.7678E-02_JPRB,1.9773E-02_JPRB,1.5847E-02_JPRB,1.0523E-02_JPRB,6.3196E-03_JPRB/)
KBO( :, 3,48,11) = (/&
&2.7272E-02_JPRB,3.1035E-02_JPRB,2.4886E-02_JPRB,1.6427E-02_JPRB,8.9753E-03_JPRB/)
KBO( :, 4,48,11) = (/&
&4.0847E-02_JPRB,4.7231E-02_JPRB,3.7989E-02_JPRB,2.4968E-02_JPRB,1.2435E-02_JPRB/)
KBO( :, 5,48,11) = (/&
&5.9943E-02_JPRB,6.9928E-02_JPRB,5.6261E-02_JPRB,3.6863E-02_JPRB,1.6884E-02_JPRB/)
KBO( :, 1,49,11) = (/&
&8.2227E-03_JPRB,9.2751E-03_JPRB,7.4918E-03_JPRB,4.9857E-03_JPRB,3.3179E-03_JPRB/)
KBO( :, 2,49,11) = (/&
&1.3710E-02_JPRB,1.5461E-02_JPRB,1.2382E-02_JPRB,8.1837E-03_JPRB,4.9416E-03_JPRB/)
KBO( :, 3,49,11) = (/&
&2.1752E-02_JPRB,2.4824E-02_JPRB,1.9870E-02_JPRB,1.3064E-02_JPRB,7.1199E-03_JPRB/)
KBO( :, 4,49,11) = (/&
&3.3202E-02_JPRB,3.8592E-02_JPRB,3.0992E-02_JPRB,2.0326E-02_JPRB,9.9895E-03_JPRB/)
KBO( :, 5,49,11) = (/&
&4.9564E-02_JPRB,5.8206E-02_JPRB,4.6898E-02_JPRB,3.0661E-02_JPRB,1.3734E-02_JPRB/)
KBO( :, 1,50,11) = (/&
&6.1915E-03_JPRB,7.0808E-03_JPRB,5.7341E-03_JPRB,3.7933E-03_JPRB,2.6014E-03_JPRB/)
KBO( :, 2,50,11) = (/&
&1.0634E-02_JPRB,1.2140E-02_JPRB,9.7185E-03_JPRB,6.3965E-03_JPRB,3.9374E-03_JPRB/)
KBO( :, 3,50,11) = (/&
&1.7391E-02_JPRB,1.9945E-02_JPRB,1.5955E-02_JPRB,1.0445E-02_JPRB,5.7678E-03_JPRB/)
KBO( :, 4,50,11) = (/&
&2.7125E-02_JPRB,3.1701E-02_JPRB,2.5413E-02_JPRB,1.6599E-02_JPRB,8.1975E-03_JPRB/)
KBO( :, 5,50,11) = (/&
&4.1193E-02_JPRB,4.8726E-02_JPRB,3.9234E-02_JPRB,2.5636E-02_JPRB,1.1392E-02_JPRB/)
KBO( :, 1,51,11) = (/&
&4.6415E-03_JPRB,5.3779E-03_JPRB,4.3645E-03_JPRB,2.8762E-03_JPRB,2.0670E-03_JPRB/)
KBO( :, 2,51,11) = (/&
&8.1982E-03_JPRB,9.4964E-03_JPRB,7.6128E-03_JPRB,4.9899E-03_JPRB,3.1638E-03_JPRB/)
KBO( :, 3,51,11) = (/&
&1.3839E-02_JPRB,1.6014E-02_JPRB,1.2808E-02_JPRB,8.3362E-03_JPRB,4.7173E-03_JPRB/)
KBO( :, 4,51,11) = (/&
&2.2155E-02_JPRB,2.6015E-02_JPRB,2.0833E-02_JPRB,1.3537E-02_JPRB,6.8071E-03_JPRB/)
KBO( :, 5,51,11) = (/&
&3.4266E-02_JPRB,4.0819E-02_JPRB,3.2809E-02_JPRB,2.1399E-02_JPRB,9.5494E-03_JPRB/)
KBO( :, 1,52,11) = (/&
&3.4450E-03_JPRB,4.0419E-03_JPRB,3.2822E-03_JPRB,2.1593E-03_JPRB,1.6475E-03_JPRB/)
KBO( :, 2,52,11) = (/&
&6.2508E-03_JPRB,7.3537E-03_JPRB,5.9181E-03_JPRB,3.8603E-03_JPRB,2.5371E-03_JPRB/)
KBO( :, 3,52,11) = (/&
&1.0900E-02_JPRB,1.2773E-02_JPRB,1.0216E-02_JPRB,6.6126E-03_JPRB,3.8348E-03_JPRB/)
KBO( :, 4,52,11) = (/&
&1.7975E-02_JPRB,2.1233E-02_JPRB,1.7001E-02_JPRB,1.0994E-02_JPRB,5.6303E-03_JPRB/)
KBO( :, 5,52,11) = (/&
&2.8375E-02_JPRB,3.4038E-02_JPRB,2.7332E-02_JPRB,1.7744E-02_JPRB,7.9843E-03_JPRB/)
KBO( :, 1,53,11) = (/&
&2.5331E-03_JPRB,3.0017E-03_JPRB,2.4368E-03_JPRB,1.5998E-03_JPRB,1.3193E-03_JPRB/)
KBO( :, 2,53,11) = (/&
&4.7088E-03_JPRB,5.6274E-03_JPRB,4.5483E-03_JPRB,2.9549E-03_JPRB,2.0294E-03_JPRB/)
KBO( :, 3,53,11) = (/&
&8.4774E-03_JPRB,1.0097E-02_JPRB,8.0775E-03_JPRB,5.2092E-03_JPRB,3.0959E-03_JPRB/)
KBO( :, 4,53,11) = (/&
&1.4441E-02_JPRB,1.7209E-02_JPRB,1.3780E-02_JPRB,8.8745E-03_JPRB,4.6172E-03_JPRB/)
KBO( :, 5,53,11) = (/&
&2.3385E-02_JPRB,2.8212E-02_JPRB,2.2650E-02_JPRB,1.4615E-02_JPRB,6.6511E-03_JPRB/)
KBO( :, 1,54,11) = (/&
&1.8954E-03_JPRB,2.2607E-03_JPRB,1.8278E-03_JPRB,1.1946E-03_JPRB,1.0985E-03_JPRB/)
KBO( :, 2,54,11) = (/&
&3.5862E-03_JPRB,4.3471E-03_JPRB,3.5189E-03_JPRB,2.2822E-03_JPRB,1.6895E-03_JPRB/)
KBO( :, 3,54,11) = (/&
&6.6312E-03_JPRB,8.0424E-03_JPRB,6.4523E-03_JPRB,4.1406E-03_JPRB,2.5940E-03_JPRB/)
KBO( :, 4,54,11) = (/&
&1.1671E-02_JPRB,1.4089E-02_JPRB,1.1281E-02_JPRB,7.2279E-03_JPRB,3.9122E-03_JPRB/)
KBO( :, 5,54,11) = (/&
&1.9432E-02_JPRB,2.3598E-02_JPRB,1.8940E-02_JPRB,1.2154E-02_JPRB,5.7337E-03_JPRB/)
KBO( :, 1,55,11) = (/&
&1.4290E-03_JPRB,1.7125E-03_JPRB,1.3776E-03_JPRB,8.9347E-04_JPRB,9.3784E-04_JPRB/)
KBO( :, 2,55,11) = (/&
&2.7457E-03_JPRB,3.3623E-03_JPRB,2.7182E-03_JPRB,1.7597E-03_JPRB,1.4453E-03_JPRB/)
KBO( :, 3,55,11) = (/&
&5.1874E-03_JPRB,6.3979E-03_JPRB,5.1511E-03_JPRB,3.2930E-03_JPRB,2.2221E-03_JPRB/)
KBO( :, 4,55,11) = (/&
&9.4226E-03_JPRB,1.1550E-02_JPRB,9.2557E-03_JPRB,5.8990E-03_JPRB,3.3851E-03_JPRB/)
KBO( :, 5,55,11) = (/&
&1.6150E-02_JPRB,1.9777E-02_JPRB,1.5877E-02_JPRB,1.0138E-02_JPRB,5.0396E-03_JPRB/)
KBO( :, 1,56,11) = (/&
&1.0680E-03_JPRB,1.2890E-03_JPRB,1.0316E-03_JPRB,6.6446E-04_JPRB,8.0430E-04_JPRB/)
KBO( :, 2,56,11) = (/&
&2.0978E-03_JPRB,2.5858E-03_JPRB,2.0823E-03_JPRB,1.3442E-03_JPRB,1.2456E-03_JPRB/)
KBO( :, 3,56,11) = (/&
&4.0301E-03_JPRB,5.0435E-03_JPRB,4.0770E-03_JPRB,2.5996E-03_JPRB,1.9142E-03_JPRB/)
KBO( :, 4,56,11) = (/&
&7.5402E-03_JPRB,9.4035E-03_JPRB,7.5479E-03_JPRB,4.7898E-03_JPRB,2.9393E-03_JPRB/)
KBO( :, 5,56,11) = (/&
&1.3330E-02_JPRB,1.6498E-02_JPRB,1.3248E-02_JPRB,8.4281E-03_JPRB,4.4305E-03_JPRB/)
KBO( :, 1,57,11) = (/&
&7.8801E-04_JPRB,9.6289E-04_JPRB,7.6691E-04_JPRB,4.9097E-04_JPRB,6.8859E-04_JPRB/)
KBO( :, 2,57,11) = (/&
&1.5966E-03_JPRB,1.9777E-03_JPRB,1.5840E-03_JPRB,1.0164E-03_JPRB,1.0803E-03_JPRB/)
KBO( :, 3,57,11) = (/&
&3.1118E-03_JPRB,3.9473E-03_JPRB,3.1938E-03_JPRB,2.0343E-03_JPRB,1.6622E-03_JPRB/)
KBO( :, 4,57,11) = (/&
&5.9752E-03_JPRB,7.5907E-03_JPRB,6.1119E-03_JPRB,3.8625E-03_JPRB,2.5583E-03_JPRB/)
KBO( :, 5,57,11) = (/&
&1.0909E-02_JPRB,1.3694E-02_JPRB,1.0990E-02_JPRB,6.9630E-03_JPRB,3.8987E-03_JPRB/)
KBO( :, 1,58,11) = (/&
&5.8173E-04_JPRB,7.2041E-04_JPRB,5.7279E-04_JPRB,3.6474E-04_JPRB,5.9355E-04_JPRB/)
KBO( :, 2,58,11) = (/&
&1.2258E-03_JPRB,1.5249E-03_JPRB,1.2145E-03_JPRB,7.7245E-04_JPRB,9.5456E-04_JPRB/)
KBO( :, 3,58,11) = (/&
&2.4241E-03_JPRB,3.1044E-03_JPRB,2.5087E-03_JPRB,1.5934E-03_JPRB,1.4697E-03_JPRB/)
KBO( :, 4,58,11) = (/&
&4.7512E-03_JPRB,6.1351E-03_JPRB,4.9587E-03_JPRB,3.1245E-03_JPRB,2.2636E-03_JPRB/)
KBO( :, 5,58,11) = (/&
&8.9451E-03_JPRB,1.1404E-02_JPRB,9.1570E-03_JPRB,5.7752E-03_JPRB,3.4844E-03_JPRB/)
KBO( :, 1,59,11) = (/&
&5.0522E-04_JPRB,6.3041E-04_JPRB,4.9923E-04_JPRB,3.1529E-04_JPRB,5.7581E-04_JPRB/)
KBO( :, 2,59,11) = (/&
&1.0885E-03_JPRB,1.3595E-03_JPRB,1.0775E-03_JPRB,6.7742E-04_JPRB,9.3929E-04_JPRB/)
KBO( :, 3,59,11) = (/&
&2.1758E-03_JPRB,2.7928E-03_JPRB,2.2487E-03_JPRB,1.4181E-03_JPRB,1.4518E-03_JPRB/)
KBO( :, 4,59,11) = (/&
&4.2933E-03_JPRB,5.5813E-03_JPRB,4.5166E-03_JPRB,2.8320E-03_JPRB,2.2456E-03_JPRB/)
KBO( :, 5,59,11) = (/&
&8.1802E-03_JPRB,1.0526E-02_JPRB,8.4597E-03_JPRB,5.3170E-03_JPRB,3.4840E-03_JPRB/)
KBO( :, 1,13,12) = (/&
&7.9228E-01_JPRB,6.7739E-01_JPRB,5.9851E-01_JPRB,4.7753E-01_JPRB,2.7637E+00_JPRB/)
KBO( :, 2,13,12) = (/&
&1.1298E+00_JPRB,9.7146E-01_JPRB,8.5148E-01_JPRB,6.6642E-01_JPRB,2.9701E+00_JPRB/)
KBO( :, 3,13,12) = (/&
&1.5315E+00_JPRB,1.3283E+00_JPRB,1.1586E+00_JPRB,8.9312E-01_JPRB,3.2188E+00_JPRB/)
KBO( :, 4,13,12) = (/&
&1.9944E+00_JPRB,1.7422E+00_JPRB,1.5174E+00_JPRB,1.1641E+00_JPRB,3.5302E+00_JPRB/)
KBO( :, 5,13,12) = (/&
&2.5089E+00_JPRB,2.2052E+00_JPRB,1.9170E+00_JPRB,1.4741E+00_JPRB,3.8622E+00_JPRB/)
KBO( :, 1,14,12) = (/&
&8.3949E-01_JPRB,7.3093E-01_JPRB,6.4746E-01_JPRB,4.9215E-01_JPRB,2.7289E+00_JPRB/)
KBO( :, 2,14,12) = (/&
&1.1838E+00_JPRB,1.0392E+00_JPRB,9.1530E-01_JPRB,6.8593E-01_JPRB,2.9374E+00_JPRB/)
KBO( :, 3,14,12) = (/&
&1.5936E+00_JPRB,1.4080E+00_JPRB,1.2362E+00_JPRB,9.1792E-01_JPRB,3.1661E+00_JPRB/)
KBO( :, 4,14,12) = (/&
&2.0618E+00_JPRB,1.8318E+00_JPRB,1.6006E+00_JPRB,1.1951E+00_JPRB,3.4133E+00_JPRB/)
KBO( :, 5,14,12) = (/&
&2.5782E+00_JPRB,2.3016E+00_JPRB,2.0067E+00_JPRB,1.5032E+00_JPRB,3.6330E+00_JPRB/)
KBO( :, 1,15,12) = (/&
&8.6850E-01_JPRB,7.7816E-01_JPRB,6.8988E-01_JPRB,5.1142E-01_JPRB,2.4839E+00_JPRB/)
KBO( :, 2,15,12) = (/&
&1.2152E+00_JPRB,1.0938E+00_JPRB,9.6727E-01_JPRB,7.1145E-01_JPRB,2.6794E+00_JPRB/)
KBO( :, 3,15,12) = (/&
&1.6231E+00_JPRB,1.4682E+00_JPRB,1.2912E+00_JPRB,9.5405E-01_JPRB,2.8636E+00_JPRB/)
KBO( :, 4,15,12) = (/&
&2.0833E+00_JPRB,1.8933E+00_JPRB,1.6562E+00_JPRB,1.2315E+00_JPRB,3.0203E+00_JPRB/)
KBO( :, 5,15,12) = (/&
&2.5907E+00_JPRB,2.3660E+00_JPRB,2.0692E+00_JPRB,1.5407E+00_JPRB,3.1955E+00_JPRB/)
KBO( :, 1,16,12) = (/&
&8.7903E-01_JPRB,8.1154E-01_JPRB,7.2017E-01_JPRB,5.2966E-01_JPRB,2.1487E+00_JPRB/)
KBO( :, 2,16,12) = (/&
&1.2196E+00_JPRB,1.1290E+00_JPRB,9.9867E-01_JPRB,7.3589E-01_JPRB,2.2979E+00_JPRB/)
KBO( :, 3,16,12) = (/&
&1.6158E+00_JPRB,1.5020E+00_JPRB,1.3215E+00_JPRB,9.8028E-01_JPRB,2.4332E+00_JPRB/)
KBO( :, 4,16,12) = (/&
&2.0608E+00_JPRB,1.9258E+00_JPRB,1.6884E+00_JPRB,1.2547E+00_JPRB,2.5777E+00_JPRB/)
KBO( :, 5,16,12) = (/&
&2.5444E+00_JPRB,2.3922E+00_JPRB,2.0979E+00_JPRB,1.5613E+00_JPRB,2.7073E+00_JPRB/)
KBO( :, 1,17,12) = (/&
&8.6797E-01_JPRB,8.2657E-01_JPRB,7.3338E-01_JPRB,5.3823E-01_JPRB,1.8450E+00_JPRB/)
KBO( :, 2,17,12) = (/&
&1.1929E+00_JPRB,1.1407E+00_JPRB,1.0074E+00_JPRB,7.4525E-01_JPRB,1.9691E+00_JPRB/)
KBO( :, 3,17,12) = (/&
&1.5694E+00_JPRB,1.5051E+00_JPRB,1.3270E+00_JPRB,9.8535E-01_JPRB,2.0903E+00_JPRB/)
KBO( :, 4,17,12) = (/&
&1.9886E+00_JPRB,1.9165E+00_JPRB,1.6896E+00_JPRB,1.2533E+00_JPRB,2.2071E+00_JPRB/)
KBO( :, 5,17,12) = (/&
&2.4525E+00_JPRB,2.3619E+00_JPRB,2.0849E+00_JPRB,1.5524E+00_JPRB,2.3229E+00_JPRB/)
KBO( :, 1,18,12) = (/&
&8.3385E-01_JPRB,8.2168E-01_JPRB,7.2749E-01_JPRB,5.3649E-01_JPRB,1.6234E+00_JPRB/)
KBO( :, 2,18,12) = (/&
&1.1389E+00_JPRB,1.1231E+00_JPRB,9.9306E-01_JPRB,7.3634E-01_JPRB,1.7307E+00_JPRB/)
KBO( :, 3,18,12) = (/&
&1.4887E+00_JPRB,1.4739E+00_JPRB,1.3034E+00_JPRB,9.6635E-01_JPRB,1.8435E+00_JPRB/)
KBO( :, 4,18,12) = (/&
&1.8815E+00_JPRB,1.8634E+00_JPRB,1.6522E+00_JPRB,1.2254E+00_JPRB,1.9484E+00_JPRB/)
KBO( :, 5,18,12) = (/&
&2.3106E+00_JPRB,2.2920E+00_JPRB,2.0285E+00_JPRB,1.5162E+00_JPRB,2.0551E+00_JPRB/)
KBO( :, 1,19,12) = (/&
&7.8530E-01_JPRB,7.9679E-01_JPRB,7.0528E-01_JPRB,5.2265E-01_JPRB,1.4533E+00_JPRB/)
KBO( :, 2,19,12) = (/&
&1.0644E+00_JPRB,1.0830E+00_JPRB,9.5920E-01_JPRB,7.1045E-01_JPRB,1.5651E+00_JPRB/)
KBO( :, 3,19,12) = (/&
&1.3856E+00_JPRB,1.4087E+00_JPRB,1.2542E+00_JPRB,9.2677E-01_JPRB,1.6748E+00_JPRB/)
KBO( :, 4,19,12) = (/&
&1.7452E+00_JPRB,1.7745E+00_JPRB,1.5782E+00_JPRB,1.1737E+00_JPRB,1.7839E+00_JPRB/)
KBO( :, 5,19,12) = (/&
&2.1398E+00_JPRB,2.1794E+00_JPRB,1.9373E+00_JPRB,1.4553E+00_JPRB,1.9023E+00_JPRB/)
KBO( :, 1,20,12) = (/&
&7.2778E-01_JPRB,7.6194E-01_JPRB,6.7390E-01_JPRB,5.0077E-01_JPRB,1.3617E+00_JPRB/)
KBO( :, 2,20,12) = (/&
&9.8068E-01_JPRB,1.0262E+00_JPRB,9.1245E-01_JPRB,6.7491E-01_JPRB,1.4807E+00_JPRB/)
KBO( :, 3,20,12) = (/&
&1.2722E+00_JPRB,1.3293E+00_JPRB,1.1831E+00_JPRB,8.7574E-01_JPRB,1.5966E+00_JPRB/)
KBO( :, 4,20,12) = (/&
&1.5991E+00_JPRB,1.6714E+00_JPRB,1.4853E+00_JPRB,1.1090E+00_JPRB,1.7163E+00_JPRB/)
KBO( :, 5,20,12) = (/&
&1.9535E+00_JPRB,2.0500E+00_JPRB,1.8231E+00_JPRB,1.3754E+00_JPRB,1.8494E+00_JPRB/)
KBO( :, 1,21,12) = (/&
&6.6504E-01_JPRB,7.1378E-01_JPRB,6.3305E-01_JPRB,4.7002E-01_JPRB,1.2946E+00_JPRB/)
KBO( :, 2,21,12) = (/&
&8.9278E-01_JPRB,9.5693E-01_JPRB,8.4967E-01_JPRB,6.2960E-01_JPRB,1.4170E+00_JPRB/)
KBO( :, 3,21,12) = (/&
&1.1553E+00_JPRB,1.2382E+00_JPRB,1.0968E+00_JPRB,8.1599E-01_JPRB,1.5400E+00_JPRB/)
KBO( :, 4,21,12) = (/&
&1.4482E+00_JPRB,1.5551E+00_JPRB,1.3761E+00_JPRB,1.0330E+00_JPRB,1.6737E+00_JPRB/)
KBO( :, 5,21,12) = (/&
&1.7635E+00_JPRB,1.8984E+00_JPRB,1.6920E+00_JPRB,1.2782E+00_JPRB,1.8148E+00_JPRB/)
KBO( :, 1,22,12) = (/&
&6.1409E-01_JPRB,6.7210E-01_JPRB,5.9517E-01_JPRB,4.4205E-01_JPRB,1.2140E+00_JPRB/)
KBO( :, 2,22,12) = (/&
&8.2009E-01_JPRB,8.9690E-01_JPRB,7.9134E-01_JPRB,5.8900E-01_JPRB,1.3388E+00_JPRB/)
KBO( :, 3,22,12) = (/&
&1.0573E+00_JPRB,1.1562E+00_JPRB,1.0170E+00_JPRB,7.6239E-01_JPRB,1.4674E+00_JPRB/)
KBO( :, 4,22,12) = (/&
&1.3173E+00_JPRB,1.4441E+00_JPRB,1.2773E+00_JPRB,9.6111E-01_JPRB,1.6103E+00_JPRB/)
KBO( :, 5,22,12) = (/&
&1.6008E+00_JPRB,1.7593E+00_JPRB,1.5714E+00_JPRB,1.1859E+00_JPRB,1.7554E+00_JPRB/)
KBO( :, 1,23,12) = (/&
&5.6489E-01_JPRB,6.2643E-01_JPRB,5.5181E-01_JPRB,4.1055E-01_JPRB,1.1296E+00_JPRB/)
KBO( :, 2,23,12) = (/&
&7.5136E-01_JPRB,8.3205E-01_JPRB,7.2882E-01_JPRB,5.4587E-01_JPRB,1.2556E+00_JPRB/)
KBO( :, 3,23,12) = (/&
&9.6147E-01_JPRB,1.0673E+00_JPRB,9.3622E-01_JPRB,7.0474E-01_JPRB,1.3939E+00_JPRB/)
KBO( :, 4,23,12) = (/&
&1.1945E+00_JPRB,1.3292E+00_JPRB,1.1758E+00_JPRB,8.8540E-01_JPRB,1.5380E+00_JPRB/)
KBO( :, 5,23,12) = (/&
&1.4498E+00_JPRB,1.6203E+00_JPRB,1.4443E+00_JPRB,1.0897E+00_JPRB,1.6879E+00_JPRB/)
KBO( :, 1,24,12) = (/&
&5.2019E-01_JPRB,5.8108E-01_JPRB,5.0714E-01_JPRB,3.7894E-01_JPRB,1.0335E+00_JPRB/)
KBO( :, 2,24,12) = (/&
&6.8678E-01_JPRB,7.6753E-01_JPRB,6.6836E-01_JPRB,5.0261E-01_JPRB,1.1623E+00_JPRB/)
KBO( :, 3,24,12) = (/&
&8.7490E-01_JPRB,9.8000E-01_JPRB,8.5888E-01_JPRB,6.4559E-01_JPRB,1.3047E+00_JPRB/)
KBO( :, 4,24,12) = (/&
&1.0855E+00_JPRB,1.2194E+00_JPRB,1.0757E+00_JPRB,8.1029E-01_JPRB,1.4513E+00_JPRB/)
KBO( :, 5,24,12) = (/&
&1.3195E+00_JPRB,1.4875E+00_JPRB,1.3176E+00_JPRB,9.9617E-01_JPRB,1.6042E+00_JPRB/)
KBO( :, 1,25,12) = (/&
&4.8125E-01_JPRB,5.3776E-01_JPRB,4.6543E-01_JPRB,3.4920E-01_JPRB,9.4296E-01_JPRB/)
KBO( :, 2,25,12) = (/&
&6.3062E-01_JPRB,7.0671E-01_JPRB,6.1374E-01_JPRB,4.6025E-01_JPRB,1.0786E+00_JPRB/)
KBO( :, 3,25,12) = (/&
&8.0138E-01_JPRB,8.9961E-01_JPRB,7.8690E-01_JPRB,5.8999E-01_JPRB,1.2219E+00_JPRB/)
KBO( :, 4,25,12) = (/&
&9.9501E-01_JPRB,1.1200E+00_JPRB,9.8131E-01_JPRB,7.3979E-01_JPRB,1.3746E+00_JPRB/)
KBO( :, 5,25,12) = (/&
&1.2133E+00_JPRB,1.3690E+00_JPRB,1.2002E+00_JPRB,9.0848E-01_JPRB,1.5310E+00_JPRB/)
KBO( :, 1,26,12) = (/&
&4.4718E-01_JPRB,5.0045E-01_JPRB,4.3026E-01_JPRB,3.2190E-01_JPRB,8.7401E-01_JPRB/)
KBO( :, 2,26,12) = (/&
&5.8377E-01_JPRB,6.5329E-01_JPRB,5.6669E-01_JPRB,4.2222E-01_JPRB,1.0132E+00_JPRB/)
KBO( :, 3,26,12) = (/&
&7.4225E-01_JPRB,8.3122E-01_JPRB,7.2142E-01_JPRB,5.4093E-01_JPRB,1.1599E+00_JPRB/)
KBO( :, 4,26,12) = (/&
&9.2576E-01_JPRB,1.0363E+00_JPRB,8.9875E-01_JPRB,6.7651E-01_JPRB,1.3150E+00_JPRB/)
KBO( :, 5,26,12) = (/&
&1.1359E+00_JPRB,1.2689E+00_JPRB,1.1003E+00_JPRB,8.3128E-01_JPRB,1.4725E+00_JPRB/)
KBO( :, 1,27,12) = (/&
&4.1742E-01_JPRB,4.6589E-01_JPRB,4.0014E-01_JPRB,2.9607E-01_JPRB,8.0311E-01_JPRB/)
KBO( :, 2,27,12) = (/&
&5.4534E-01_JPRB,6.0694E-01_JPRB,5.2254E-01_JPRB,3.8814E-01_JPRB,9.3748E-01_JPRB/)
KBO( :, 3,27,12) = (/&
&6.9705E-01_JPRB,7.7317E-01_JPRB,6.6432E-01_JPRB,4.9566E-01_JPRB,1.0808E+00_JPRB/)
KBO( :, 4,27,12) = (/&
&8.7421E-01_JPRB,9.6588E-01_JPRB,8.2816E-01_JPRB,6.1915E-01_JPRB,1.2270E+00_JPRB/)
KBO( :, 5,27,12) = (/&
&1.0783E+00_JPRB,1.1900E+00_JPRB,1.0151E+00_JPRB,7.6356E-01_JPRB,1.3781E+00_JPRB/)
KBO( :, 1,28,12) = (/&
&3.9237E-01_JPRB,4.3515E-01_JPRB,3.7248E-01_JPRB,2.7305E-01_JPRB,7.2280E-01_JPRB/)
KBO( :, 2,28,12) = (/&
&5.1563E-01_JPRB,5.6757E-01_JPRB,4.8403E-01_JPRB,3.5700E-01_JPRB,8.4677E-01_JPRB/)
KBO( :, 3,28,12) = (/&
&6.6308E-01_JPRB,7.2519E-01_JPRB,6.1590E-01_JPRB,4.5472E-01_JPRB,9.7710E-01_JPRB/)
KBO( :, 4,28,12) = (/&
&8.3646E-01_JPRB,9.1152E-01_JPRB,7.6997E-01_JPRB,5.6988E-01_JPRB,1.1096E+00_JPRB/)
KBO( :, 5,28,12) = (/&
&1.0359E+00_JPRB,1.1276E+00_JPRB,9.4962E-01_JPRB,7.0526E-01_JPRB,1.2485E+00_JPRB/)
KBO( :, 1,29,12) = (/&
&3.7279E-01_JPRB,4.1014E-01_JPRB,3.4774E-01_JPRB,2.5341E-01_JPRB,6.3269E-01_JPRB/)
KBO( :, 2,29,12) = (/&
&4.9283E-01_JPRB,5.3769E-01_JPRB,4.5233E-01_JPRB,3.3021E-01_JPRB,7.4294E-01_JPRB/)
KBO( :, 3,29,12) = (/&
&6.3731E-01_JPRB,6.8994E-01_JPRB,5.7780E-01_JPRB,4.2070E-01_JPRB,8.5678E-01_JPRB/)
KBO( :, 4,29,12) = (/&
&8.0637E-01_JPRB,8.7025E-01_JPRB,7.2644E-01_JPRB,5.2908E-01_JPRB,9.7595E-01_JPRB/)
KBO( :, 5,29,12) = (/&
&9.9943E-01_JPRB,1.0813E+00_JPRB,9.0128E-01_JPRB,6.5866E-01_JPRB,1.1019E+00_JPRB/)
KBO( :, 1,30,12) = (/&
&3.5722E-01_JPRB,3.9080E-01_JPRB,3.2710E-01_JPRB,2.3601E-01_JPRB,5.4037E-01_JPRB/)
KBO( :, 2,30,12) = (/&
&4.7448E-01_JPRB,5.1429E-01_JPRB,4.2783E-01_JPRB,3.0716E-01_JPRB,6.3503E-01_JPRB/)
KBO( :, 3,30,12) = (/&
&6.1439E-01_JPRB,6.6308E-01_JPRB,5.4920E-01_JPRB,3.9345E-01_JPRB,7.3381E-01_JPRB/)
KBO( :, 4,30,12) = (/&
&7.7644E-01_JPRB,8.4062E-01_JPRB,6.9350E-01_JPRB,4.9782E-01_JPRB,8.4010E-01_JPRB/)
KBO( :, 5,30,12) = (/&
&9.6226E-01_JPRB,1.0478E+00_JPRB,8.6468E-01_JPRB,6.2256E-01_JPRB,9.5398E-01_JPRB/)
KBO( :, 1,31,12) = (/&
&3.4498E-01_JPRB,3.7545E-01_JPRB,3.1150E-01_JPRB,2.2122E-01_JPRB,4.4905E-01_JPRB/)
KBO( :, 2,31,12) = (/&
&4.5820E-01_JPRB,4.9653E-01_JPRB,4.0983E-01_JPRB,2.8888E-01_JPRB,5.2917E-01_JPRB/)
KBO( :, 3,31,12) = (/&
&5.9170E-01_JPRB,6.4378E-01_JPRB,5.2810E-01_JPRB,3.7284E-01_JPRB,6.1590E-01_JPRB/)
KBO( :, 4,31,12) = (/&
&7.4787E-01_JPRB,8.1835E-01_JPRB,6.7064E-01_JPRB,4.7448E-01_JPRB,7.0953E-01_JPRB/)
KBO( :, 5,31,12) = (/&
&9.2776E-01_JPRB,1.0238E+00_JPRB,8.4020E-01_JPRB,5.9540E-01_JPRB,8.0850E-01_JPRB/)
KBO( :, 1,32,12) = (/&
&3.3387E-01_JPRB,3.6397E-01_JPRB,2.9979E-01_JPRB,2.0962E-01_JPRB,3.7307E-01_JPRB/)
KBO( :, 2,32,12) = (/&
&4.4163E-01_JPRB,4.8363E-01_JPRB,3.9607E-01_JPRB,2.7594E-01_JPRB,4.4216E-01_JPRB/)
KBO( :, 3,32,12) = (/&
&5.7015E-01_JPRB,6.2876E-01_JPRB,5.1363E-01_JPRB,3.5765E-01_JPRB,5.1788E-01_JPRB/)
KBO( :, 4,32,12) = (/&
&7.2141E-01_JPRB,8.0151E-01_JPRB,6.5517E-01_JPRB,4.5717E-01_JPRB,6.0016E-01_JPRB/)
KBO( :, 5,32,12) = (/&
&8.9922E-01_JPRB,1.0062E+00_JPRB,8.2407E-01_JPRB,5.7459E-01_JPRB,6.8536E-01_JPRB/)
KBO( :, 1,33,12) = (/&
&3.2293E-01_JPRB,3.5547E-01_JPRB,2.9093E-01_JPRB,2.0149E-01_JPRB,3.0917E-01_JPRB/)
KBO( :, 2,33,12) = (/&
&4.2627E-01_JPRB,4.7355E-01_JPRB,3.8619E-01_JPRB,2.6640E-01_JPRB,3.6920E-01_JPRB/)
KBO( :, 3,33,12) = (/&
&5.5058E-01_JPRB,6.1665E-01_JPRB,5.0346E-01_JPRB,3.4679E-01_JPRB,4.3505E-01_JPRB/)
KBO( :, 4,33,12) = (/&
&6.9980E-01_JPRB,7.8852E-01_JPRB,6.4475E-01_JPRB,4.4442E-01_JPRB,5.0488E-01_JPRB/)
KBO( :, 5,33,12) = (/&
&8.7592E-01_JPRB,9.9390E-01_JPRB,8.1496E-01_JPRB,5.6029E-01_JPRB,5.7746E-01_JPRB/)
KBO( :, 1,34,12) = (/&
&3.0940E-01_JPRB,3.4528E-01_JPRB,2.8156E-01_JPRB,1.9363E-01_JPRB,2.6611E-01_JPRB/)
KBO( :, 2,34,12) = (/&
&4.0894E-01_JPRB,4.6074E-01_JPRB,3.7565E-01_JPRB,2.5763E-01_JPRB,3.1938E-01_JPRB/)
KBO( :, 3,34,12) = (/&
&5.3041E-01_JPRB,6.0251E-01_JPRB,4.9185E-01_JPRB,3.3679E-01_JPRB,3.7762E-01_JPRB/)
KBO( :, 4,34,12) = (/&
&6.7786E-01_JPRB,7.7350E-01_JPRB,6.3399E-01_JPRB,4.3276E-01_JPRB,4.3880E-01_JPRB/)
KBO( :, 5,34,12) = (/&
&8.5216E-01_JPRB,9.8050E-01_JPRB,8.0443E-01_JPRB,5.4758E-01_JPRB,5.0384E-01_JPRB/)
KBO( :, 1,35,12) = (/&
&2.8939E-01_JPRB,3.2702E-01_JPRB,2.6622E-01_JPRB,1.8249E-01_JPRB,2.2426E-01_JPRB/)
KBO( :, 2,35,12) = (/&
&3.8432E-01_JPRB,4.3860E-01_JPRB,3.5768E-01_JPRB,2.4461E-01_JPRB,2.7044E-01_JPRB/)
KBO( :, 3,35,12) = (/&
&5.0227E-01_JPRB,5.7687E-01_JPRB,4.7133E-01_JPRB,3.2156E-01_JPRB,3.2047E-01_JPRB/)
KBO( :, 4,35,12) = (/&
&6.4522E-01_JPRB,7.4630E-01_JPRB,6.1202E-01_JPRB,4.1516E-01_JPRB,3.7356E-01_JPRB/)
KBO( :, 5,35,12) = (/&
&8.1623E-01_JPRB,9.5325E-01_JPRB,7.8163E-01_JPRB,5.2821E-01_JPRB,4.3272E-01_JPRB/)
KBO( :, 1,36,12) = (/&
&2.6330E-01_JPRB,3.0070E-01_JPRB,2.4442E-01_JPRB,1.6757E-01_JPRB,1.8310E-01_JPRB/)
KBO( :, 2,36,12) = (/&
&3.5255E-01_JPRB,4.0667E-01_JPRB,3.3144E-01_JPRB,2.2644E-01_JPRB,2.2200E-01_JPRB/)
KBO( :, 3,36,12) = (/&
&4.6468E-01_JPRB,5.3948E-01_JPRB,4.4110E-01_JPRB,3.0012E-01_JPRB,2.6412E-01_JPRB/)
KBO( :, 4,36,12) = (/&
&6.0155E-01_JPRB,7.0486E-01_JPRB,5.7783E-01_JPRB,3.9058E-01_JPRB,3.1002E-01_JPRB/)
KBO( :, 5,36,12) = (/&
&7.6703E-01_JPRB,9.0873E-01_JPRB,7.4457E-01_JPRB,5.0060E-01_JPRB,3.6395E-01_JPRB/)
KBO( :, 1,37,12) = (/&
&2.3001E-01_JPRB,2.6442E-01_JPRB,2.1459E-01_JPRB,1.4727E-01_JPRB,1.5536E-01_JPRB/)
KBO( :, 2,37,12) = (/&
&3.1096E-01_JPRB,3.6197E-01_JPRB,2.9461E-01_JPRB,2.0129E-01_JPRB,1.9004E-01_JPRB/)
KBO( :, 3,37,12) = (/&
&4.1431E-01_JPRB,4.8589E-01_JPRB,3.9700E-01_JPRB,2.7000E-01_JPRB,2.2800E-01_JPRB/)
KBO( :, 4,37,12) = (/&
&5.4226E-01_JPRB,6.4266E-01_JPRB,5.2665E-01_JPRB,3.5524E-01_JPRB,2.6910E-01_JPRB/)
KBO( :, 5,37,12) = (/&
&6.9841E-01_JPRB,8.3797E-01_JPRB,6.8663E-01_JPRB,4.5963E-01_JPRB,3.1774E-01_JPRB/)
KBO( :, 1,38,12) = (/&
&2.0134E-01_JPRB,2.3227E-01_JPRB,1.8814E-01_JPRB,1.2935E-01_JPRB,1.3137E-01_JPRB/)
KBO( :, 2,38,12) = (/&
&2.7468E-01_JPRB,3.2208E-01_JPRB,2.6174E-01_JPRB,1.7891E-01_JPRB,1.6217E-01_JPRB/)
KBO( :, 3,38,12) = (/&
&3.6956E-01_JPRB,4.3776E-01_JPRB,3.5733E-01_JPRB,2.4289E-01_JPRB,1.9623E-01_JPRB/)
KBO( :, 4,38,12) = (/&
&4.8896E-01_JPRB,5.8640E-01_JPRB,4.8002E-01_JPRB,3.2349E-01_JPRB,2.3300E-01_JPRB/)
KBO( :, 5,38,12) = (/&
&6.3666E-01_JPRB,7.7346E-01_JPRB,6.3380E-01_JPRB,4.2286E-01_JPRB,2.7663E-01_JPRB/)
KBO( :, 1,39,12) = (/&
&1.7697E-01_JPRB,2.0467E-01_JPRB,1.6540E-01_JPRB,1.1386E-01_JPRB,1.1007E-01_JPRB/)
KBO( :, 2,39,12) = (/&
&2.4368E-01_JPRB,2.8735E-01_JPRB,2.3319E-01_JPRB,1.5947E-01_JPRB,1.3719E-01_JPRB/)
KBO( :, 3,39,12) = (/&
&3.3092E-01_JPRB,3.9580E-01_JPRB,3.2268E-01_JPRB,2.1918E-01_JPRB,1.6720E-01_JPRB/)
KBO( :, 4,39,12) = (/&
&4.4249E-01_JPRB,5.3699E-01_JPRB,4.3914E-01_JPRB,2.9552E-01_JPRB,1.9987E-01_JPRB/)
KBO( :, 5,39,12) = (/&
&5.8226E-01_JPRB,7.1600E-01_JPRB,5.8709E-01_JPRB,3.9058E-01_JPRB,2.3879E-01_JPRB/)
KBO( :, 1,40,12) = (/&
&1.5084E-01_JPRB,1.7449E-01_JPRB,1.4045E-01_JPRB,9.6794E-02_JPRB,9.3392E-02_JPRB/)
KBO( :, 2,40,12) = (/&
&2.1010E-01_JPRB,2.4822E-01_JPRB,2.0097E-01_JPRB,1.3766E-01_JPRB,1.1767E-01_JPRB/)
KBO( :, 3,40,12) = (/&
&2.8835E-01_JPRB,3.4716E-01_JPRB,2.8248E-01_JPRB,1.9197E-01_JPRB,1.4495E-01_JPRB/)
KBO( :, 4,40,12) = (/&
&3.8988E-01_JPRB,4.7789E-01_JPRB,3.9037E-01_JPRB,2.6261E-01_JPRB,1.7468E-01_JPRB/)
KBO( :, 5,40,12) = (/&
&5.1945E-01_JPRB,6.4586E-01_JPRB,5.2903E-01_JPRB,3.5162E-01_JPRB,2.0975E-01_JPRB/)
KBO( :, 1,41,12) = (/&
&1.2817E-01_JPRB,1.4829E-01_JPRB,1.1887E-01_JPRB,8.1840E-02_JPRB,7.9057E-02_JPRB/)
KBO( :, 2,41,12) = (/&
&1.8060E-01_JPRB,2.1362E-01_JPRB,1.7247E-01_JPRB,1.1830E-01_JPRB,1.0081E-01_JPRB/)
KBO( :, 3,41,12) = (/&
&2.5080E-01_JPRB,3.0334E-01_JPRB,2.4634E-01_JPRB,1.6753E-01_JPRB,1.2548E-01_JPRB/)
KBO( :, 4,41,12) = (/&
&3.4280E-01_JPRB,4.2376E-01_JPRB,3.4586E-01_JPRB,2.3251E-01_JPRB,1.5256E-01_JPRB/)
KBO( :, 5,41,12) = (/&
&4.6230E-01_JPRB,5.8070E-01_JPRB,4.7518E-01_JPRB,3.1572E-01_JPRB,1.8431E-01_JPRB/)
KBO( :, 1,42,12) = (/&
&1.0893E-01_JPRB,1.2613E-01_JPRB,1.0083E-01_JPRB,6.9157E-02_JPRB,6.6394E-02_JPRB/)
KBO( :, 2,42,12) = (/&
&1.5547E-01_JPRB,1.8415E-01_JPRB,1.4803E-01_JPRB,1.0161E-01_JPRB,8.5777E-02_JPRB/)
KBO( :, 3,42,12) = (/&
&2.1846E-01_JPRB,2.6502E-01_JPRB,2.1486E-01_JPRB,1.4627E-01_JPRB,1.0794E-01_JPRB/)
KBO( :, 4,42,12) = (/&
&3.0198E-01_JPRB,3.7587E-01_JPRB,3.0638E-01_JPRB,2.0583E-01_JPRB,1.3247E-01_JPRB/)
KBO( :, 5,42,12) = (/&
&4.1199E-01_JPRB,5.2225E-01_JPRB,4.2709E-01_JPRB,2.8351E-01_JPRB,1.6111E-01_JPRB/)
KBO( :, 1,43,12) = (/&
&9.0638E-02_JPRB,1.0503E-01_JPRB,8.3795E-02_JPRB,5.7071E-02_JPRB,5.5354E-02_JPRB/)
KBO( :, 2,43,12) = (/&
&1.3131E-01_JPRB,1.5548E-01_JPRB,1.2458E-01_JPRB,8.5364E-02_JPRB,7.2576E-02_JPRB/)
KBO( :, 3,43,12) = (/&
&1.8681E-01_JPRB,2.2707E-01_JPRB,1.8347E-01_JPRB,1.2501E-01_JPRB,9.2538E-02_JPRB/)
KBO( :, 4,43,12) = (/&
&2.6160E-01_JPRB,3.2672E-01_JPRB,2.6595E-01_JPRB,1.7876E-01_JPRB,1.1500E-01_JPRB/)
KBO( :, 5,43,12) = (/&
&3.6120E-01_JPRB,4.6097E-01_JPRB,3.7669E-01_JPRB,2.4999E-01_JPRB,1.4075E-01_JPRB/)
KBO( :, 1,44,12) = (/&
&7.4518E-02_JPRB,8.6409E-02_JPRB,6.8952E-02_JPRB,4.6577E-02_JPRB,4.5787E-02_JPRB/)
KBO( :, 2,44,12) = (/&
&1.0975E-01_JPRB,1.2994E-01_JPRB,1.0385E-01_JPRB,7.0835E-02_JPRB,6.0976E-02_JPRB/)
KBO( :, 3,44,12) = (/&
&1.5828E-01_JPRB,1.9250E-01_JPRB,1.5506E-01_JPRB,1.0558E-01_JPRB,7.8936E-02_JPRB/)
KBO( :, 4,44,12) = (/&
&2.2471E-01_JPRB,2.8098E-01_JPRB,2.2821E-01_JPRB,1.5365E-01_JPRB,9.9460E-02_JPRB/)
KBO( :, 5,44,12) = (/&
&3.1406E-01_JPRB,4.0269E-01_JPRB,3.2871E-01_JPRB,2.1813E-01_JPRB,1.2276E-01_JPRB/)
KBO( :, 1,45,12) = (/&
&6.0927E-02_JPRB,7.0888E-02_JPRB,5.6604E-02_JPRB,3.8007E-02_JPRB,3.7451E-02_JPRB/)
KBO( :, 2,45,12) = (/&
&9.1562E-02_JPRB,1.0848E-01_JPRB,8.6563E-02_JPRB,5.8638E-02_JPRB,5.0739E-02_JPRB/)
KBO( :, 3,45,12) = (/&
&1.3401E-01_JPRB,1.6305E-01_JPRB,1.3093E-01_JPRB,8.8909E-02_JPRB,6.6645E-02_JPRB/)
KBO( :, 4,45,12) = (/&
&1.9278E-01_JPRB,2.4132E-01_JPRB,1.9538E-01_JPRB,1.3171E-01_JPRB,8.5195E-02_JPRB/)
KBO( :, 5,45,12) = (/&
&2.7301E-01_JPRB,3.5087E-01_JPRB,2.8599E-01_JPRB,1.8994E-01_JPRB,1.0627E-01_JPRB/)
KBO( :, 1,46,12) = (/&
&4.9049E-02_JPRB,5.7390E-02_JPRB,4.5841E-02_JPRB,3.0652E-02_JPRB,3.0244E-02_JPRB/)
KBO( :, 2,46,12) = (/&
&7.5395E-02_JPRB,8.9544E-02_JPRB,7.1479E-02_JPRB,4.8016E-02_JPRB,4.1812E-02_JPRB/)
KBO( :, 3,46,12) = (/&
&1.1243E-01_JPRB,1.3673E-01_JPRB,1.0940E-01_JPRB,7.3992E-02_JPRB,5.5802E-02_JPRB/)
KBO( :, 4,46,12) = (/&
&1.6385E-01_JPRB,2.0515E-01_JPRB,1.6554E-01_JPRB,1.1163E-01_JPRB,7.2384E-02_JPRB/)
KBO( :, 5,46,12) = (/&
&2.3535E-01_JPRB,3.0228E-01_JPRB,2.4596E-01_JPRB,1.6359E-01_JPRB,9.1350E-02_JPRB/)
KBO( :, 1,47,12) = (/&
&3.8455E-02_JPRB,4.5311E-02_JPRB,3.6191E-02_JPRB,2.4099E-02_JPRB,2.4180E-02_JPRB/)
KBO( :, 2,47,12) = (/&
&6.0543E-02_JPRB,7.2219E-02_JPRB,5.7752E-02_JPRB,3.8501E-02_JPRB,3.4153E-02_JPRB/)
KBO( :, 3,47,12) = (/&
&9.2469E-02_JPRB,1.1229E-01_JPRB,8.9649E-02_JPRB,6.0326E-02_JPRB,4.6448E-02_JPRB/)
KBO( :, 4,47,12) = (/&
&1.3689E-01_JPRB,1.7102E-01_JPRB,1.3750E-01_JPRB,9.2547E-02_JPRB,6.1214E-02_JPRB/)
KBO( :, 5,47,12) = (/&
&1.9927E-01_JPRB,2.5535E-01_JPRB,2.0704E-01_JPRB,1.3818E-01_JPRB,7.8425E-02_JPRB/)
KBO( :, 1,48,12) = (/&
&2.9907E-02_JPRB,3.5538E-02_JPRB,2.8349E-02_JPRB,1.8781E-02_JPRB,1.9054E-02_JPRB/)
KBO( :, 2,48,12) = (/&
&4.8228E-02_JPRB,5.7904E-02_JPRB,4.6345E-02_JPRB,3.0764E-02_JPRB,2.7466E-02_JPRB/)
KBO( :, 3,48,12) = (/&
&7.5470E-02_JPRB,9.1806E-02_JPRB,7.3317E-02_JPRB,4.8995E-02_JPRB,3.8151E-02_JPRB/)
KBO( :, 4,48,12) = (/&
&1.1406E-01_JPRB,1.4204E-01_JPRB,1.1383E-01_JPRB,7.6343E-02_JPRB,5.1172E-02_JPRB/)
KBO( :, 5,48,12) = (/&
&1.6822E-01_JPRB,2.1497E-01_JPRB,1.7372E-01_JPRB,1.1607E-01_JPRB,6.6629E-02_JPRB/)
KBO( :, 1,49,12) = (/&
&2.3084E-02_JPRB,2.7602E-02_JPRB,2.2043E-02_JPRB,1.4515E-02_JPRB,1.4700E-02_JPRB/)
KBO( :, 2,49,12) = (/&
&3.8134E-02_JPRB,4.6138E-02_JPRB,3.6932E-02_JPRB,2.4422E-02_JPRB,2.1696E-02_JPRB/)
KBO( :, 3,49,12) = (/&
&6.1053E-02_JPRB,7.4691E-02_JPRB,5.9743E-02_JPRB,3.9618E-02_JPRB,3.0784E-02_JPRB/)
KBO( :, 4,49,12) = (/&
&9.4624E-02_JPRB,1.1747E-01_JPRB,9.3906E-02_JPRB,6.2717E-02_JPRB,4.2057E-02_JPRB/)
KBO( :, 5,49,12) = (/&
&1.4162E-01_JPRB,1.8031E-01_JPRB,1.4520E-01_JPRB,9.6951E-02_JPRB,5.5665E-02_JPRB/)
KBO( :, 1,50,12) = (/&
&1.7880E-02_JPRB,2.1522E-02_JPRB,1.7193E-02_JPRB,1.1281E-02_JPRB,1.1563E-02_JPRB/)
KBO( :, 2,50,12) = (/&
&3.0304E-02_JPRB,3.6988E-02_JPRB,2.9594E-02_JPRB,1.9489E-02_JPRB,1.7511E-02_JPRB/)
KBO( :, 3,50,12) = (/&
&4.9620E-02_JPRB,6.1130E-02_JPRB,4.8990E-02_JPRB,3.2313E-02_JPRB,2.5345E-02_JPRB/)
KBO( :, 4,50,12) = (/&
&7.8794E-02_JPRB,9.7813E-02_JPRB,7.8198E-02_JPRB,5.1943E-02_JPRB,3.5298E-02_JPRB/)
KBO( :, 5,50,12) = (/&
&1.2010E-01_JPRB,1.5227E-01_JPRB,1.2229E-01_JPRB,8.1438E-02_JPRB,4.7462E-02_JPRB/)
KBO( :, 1,51,12) = (/&
&1.3778E-02_JPRB,1.6753E-02_JPRB,1.3366E-02_JPRB,8.7587E-03_JPRB,9.1691E-03_JPRB/)
KBO( :, 2,51,12) = (/&
&2.4068E-02_JPRB,2.9598E-02_JPRB,2.3720E-02_JPRB,1.5531E-02_JPRB,1.4241E-02_JPRB/)
KBO( :, 3,51,12) = (/&
&4.0319E-02_JPRB,5.0023E-02_JPRB,4.0146E-02_JPRB,2.6379E-02_JPRB,2.1041E-02_JPRB/)
KBO( :, 4,51,12) = (/&
&6.5444E-02_JPRB,8.1559E-02_JPRB,6.5274E-02_JPRB,4.3107E-02_JPRB,2.9808E-02_JPRB/)
KBO( :, 5,51,12) = (/&
&1.0193E-01_JPRB,1.2878E-01_JPRB,1.0316E-01_JPRB,6.8485E-02_JPRB,4.0764E-02_JPRB/)
KBO( :, 1,52,12) = (/&
&1.0503E-02_JPRB,1.2908E-02_JPRB,1.0296E-02_JPRB,6.7391E-03_JPRB,7.1632E-03_JPRB/)
KBO( :, 2,52,12) = (/&
&1.8963E-02_JPRB,2.3514E-02_JPRB,1.8863E-02_JPRB,1.2292E-02_JPRB,1.1416E-02_JPRB/)
KBO( :, 3,52,12) = (/&
&3.2574E-02_JPRB,4.0763E-02_JPRB,3.2692E-02_JPRB,2.1413E-02_JPRB,1.7232E-02_JPRB/)
KBO( :, 4,52,12) = (/&
&5.4015E-02_JPRB,6.7725E-02_JPRB,5.4297E-02_JPRB,3.5648E-02_JPRB,2.4880E-02_JPRB/)
KBO( :, 5,52,12) = (/&
&8.6142E-02_JPRB,1.0850E-01_JPRB,8.6783E-02_JPRB,5.7412E-02_JPRB,3.4604E-02_JPRB/)
KBO( :, 1,53,12) = (/&
&7.9034E-03_JPRB,9.8239E-03_JPRB,7.8369E-03_JPRB,5.1248E-03_JPRB,5.4843E-03_JPRB/)
KBO( :, 2,53,12) = (/&
&1.4792E-02_JPRB,1.8526E-02_JPRB,1.4847E-02_JPRB,9.6585E-03_JPRB,8.9798E-03_JPRB/)
KBO( :, 3,53,12) = (/&
&2.6145E-02_JPRB,3.2976E-02_JPRB,2.6454E-02_JPRB,1.7260E-02_JPRB,1.3880E-02_JPRB/)
KBO( :, 4,53,12) = (/&
&4.4324E-02_JPRB,5.5900E-02_JPRB,4.4894E-02_JPRB,2.9345E-02_JPRB,2.0450E-02_JPRB/)
KBO( :, 5,53,12) = (/&
&7.2259E-02_JPRB,9.1031E-02_JPRB,7.2836E-02_JPRB,4.7964E-02_JPRB,2.8899E-02_JPRB/)
KBO( :, 1,54,12) = (/&
&6.0030E-03_JPRB,7.5343E-03_JPRB,6.0206E-03_JPRB,3.9269E-03_JPRB,4.4374E-03_JPRB/)
KBO( :, 2,54,12) = (/&
&1.1626E-02_JPRB,1.4746E-02_JPRB,1.1801E-02_JPRB,7.6733E-03_JPRB,7.4644E-03_JPRB/)
KBO( :, 3,54,12) = (/&
&2.1204E-02_JPRB,2.6932E-02_JPRB,2.1639E-02_JPRB,1.4058E-02_JPRB,1.1820E-02_JPRB/)
KBO( :, 4,54,12) = (/&
&3.6734E-02_JPRB,4.6630E-02_JPRB,3.7473E-02_JPRB,2.4399E-02_JPRB,1.7746E-02_JPRB/)
KBO( :, 5,54,12) = (/&
&6.1048E-02_JPRB,7.7176E-02_JPRB,6.1839E-02_JPRB,4.0517E-02_JPRB,2.5474E-02_JPRB/)
KBO( :, 1,55,12) = (/&
&4.5630E-03_JPRB,5.7681E-03_JPRB,4.6205E-03_JPRB,3.0002E-03_JPRB,3.7045E-03_JPRB/)
KBO( :, 2,55,12) = (/&
&9.1273E-03_JPRB,1.1728E-02_JPRB,9.3956E-03_JPRB,6.0945E-03_JPRB,6.4077E-03_JPRB/)
KBO( :, 3,55,12) = (/&
&1.7191E-02_JPRB,2.2039E-02_JPRB,1.7711E-02_JPRB,1.1469E-02_JPRB,1.0390E-02_JPRB/)
KBO( :, 4,55,12) = (/&
&3.0517E-02_JPRB,3.9009E-02_JPRB,3.1321E-02_JPRB,2.0350E-02_JPRB,1.5909E-02_JPRB/)
KBO( :, 5,55,12) = (/&
&5.1680E-02_JPRB,6.5618E-02_JPRB,5.2649E-02_JPRB,3.4345E-02_JPRB,2.3231E-02_JPRB/)
KBO( :, 1,56,12) = (/&
&3.4429E-03_JPRB,4.3693E-03_JPRB,3.5102E-03_JPRB,2.2664E-03_JPRB,3.0972E-03_JPRB/)
KBO( :, 2,56,12) = (/&
&7.1067E-03_JPRB,9.2412E-03_JPRB,7.4106E-03_JPRB,4.8010E-03_JPRB,5.4938E-03_JPRB/)
KBO( :, 3,56,12) = (/&
&1.3838E-02_JPRB,1.7926E-02_JPRB,1.4393E-02_JPRB,9.3102E-03_JPRB,9.1167E-03_JPRB/)
KBO( :, 4,56,12) = (/&
&2.5226E-02_JPRB,3.2470E-02_JPRB,2.6067E-02_JPRB,1.6890E-02_JPRB,1.4253E-02_JPRB/)
KBO( :, 5,56,12) = (/&
&4.3555E-02_JPRB,5.5559E-02_JPRB,4.4639E-02_JPRB,2.9008E-02_JPRB,2.1194E-02_JPRB/)
KBO( :, 1,57,12) = (/&
&2.5835E-03_JPRB,3.2792E-03_JPRB,2.6340E-03_JPRB,1.6928E-03_JPRB,2.5979E-03_JPRB/)
KBO( :, 2,57,12) = (/&
&5.4818E-03_JPRB,7.2018E-03_JPRB,5.7860E-03_JPRB,3.7399E-03_JPRB,4.6938E-03_JPRB/)
KBO( :, 3,57,12) = (/&
&1.1045E-02_JPRB,1.4477E-02_JPRB,1.1615E-02_JPRB,7.5071E-03_JPRB,7.9880E-03_JPRB/)
KBO( :, 4,57,12) = (/&
&2.0734E-02_JPRB,2.6855E-02_JPRB,2.1584E-02_JPRB,1.3939E-02_JPRB,1.2771E-02_JPRB/)
KBO( :, 5,57,12) = (/&
&3.6531E-02_JPRB,4.6834E-02_JPRB,3.7641E-02_JPRB,2.4391E-02_JPRB,1.9328E-02_JPRB/)
KBO( :, 1,58,12) = (/&
&1.9554E-03_JPRB,2.4805E-03_JPRB,1.9815E-03_JPRB,1.2675E-03_JPRB,2.2311E-03_JPRB/)
KBO( :, 2,58,12) = (/&
&4.2406E-03_JPRB,5.6194E-03_JPRB,4.5251E-03_JPRB,2.9142E-03_JPRB,4.0751E-03_JPRB/)
KBO( :, 3,58,12) = (/&
&8.8253E-03_JPRB,1.1715E-02_JPRB,9.4049E-03_JPRB,6.0687E-03_JPRB,7.1082E-03_JPRB/)
KBO( :, 4,58,12) = (/&
&1.7081E-02_JPRB,2.2294E-02_JPRB,1.7921E-02_JPRB,1.1542E-02_JPRB,1.1601E-02_JPRB/)
KBO( :, 5,58,12) = (/&
&3.0768E-02_JPRB,3.9661E-02_JPRB,3.1853E-02_JPRB,2.0599E-02_JPRB,1.7860E-02_JPRB/)
KBO( :, 1,59,12) = (/&
&1.7311E-03_JPRB,2.1950E-03_JPRB,1.7464E-03_JPRB,1.1095E-03_JPRB,2.2810E-03_JPRB/)
KBO( :, 2,59,12) = (/&
&3.7867E-03_JPRB,5.0375E-03_JPRB,4.0622E-03_JPRB,2.6050E-03_JPRB,4.2229E-03_JPRB/)
KBO( :, 3,59,12) = (/&
&7.9927E-03_JPRB,1.0691E-02_JPRB,8.5872E-03_JPRB,5.5330E-03_JPRB,7.4637E-03_JPRB/)
KBO( :, 4,59,12) = (/&
&1.5706E-02_JPRB,2.0603E-02_JPRB,1.6559E-02_JPRB,1.0653E-02_JPRB,1.2338E-02_JPRB/)
KBO( :, 5,59,12) = (/&
&2.8614E-02_JPRB,3.6995E-02_JPRB,2.9703E-02_JPRB,1.9191E-02_JPRB,1.9178E-02_JPRB/)
KBO( :, 1,13,13) = (/&
&1.2852E+00_JPRB,1.0643E+00_JPRB,9.2423E-01_JPRB,7.7210E-01_JPRB,4.8560E+00_JPRB/)
KBO( :, 2,13,13) = (/&
&1.8300E+00_JPRB,1.5153E+00_JPRB,1.3056E+00_JPRB,1.0896E+00_JPRB,5.1762E+00_JPRB/)
KBO( :, 3,13,13) = (/&
&2.4898E+00_JPRB,2.0619E+00_JPRB,1.7781E+00_JPRB,1.4720E+00_JPRB,5.5995E+00_JPRB/)
KBO( :, 4,13,13) = (/&
&3.2580E+00_JPRB,2.7136E+00_JPRB,2.3379E+00_JPRB,1.9103E+00_JPRB,6.0006E+00_JPRB/)
KBO( :, 5,13,13) = (/&
&4.1344E+00_JPRB,3.4741E+00_JPRB,2.9826E+00_JPRB,2.3986E+00_JPRB,6.3254E+00_JPRB/)
KBO( :, 1,14,13) = (/&
&1.4353E+00_JPRB,1.1813E+00_JPRB,1.0097E+00_JPRB,8.1766E-01_JPRB,4.4364E+00_JPRB/)
KBO( :, 2,14,13) = (/&
&2.0320E+00_JPRB,1.6766E+00_JPRB,1.4217E+00_JPRB,1.1476E+00_JPRB,4.7777E+00_JPRB/)
KBO( :, 3,14,13) = (/&
&2.7397E+00_JPRB,2.2766E+00_JPRB,1.9164E+00_JPRB,1.5404E+00_JPRB,5.1956E+00_JPRB/)
KBO( :, 4,14,13) = (/&
&3.5525E+00_JPRB,2.9774E+00_JPRB,2.5038E+00_JPRB,1.9898E+00_JPRB,5.5579E+00_JPRB/)
KBO( :, 5,14,13) = (/&
&4.4583E+00_JPRB,3.7784E+00_JPRB,3.1767E+00_JPRB,2.5098E+00_JPRB,5.8954E+00_JPRB/)
KBO( :, 1,15,13) = (/&
&1.5785E+00_JPRB,1.3067E+00_JPRB,1.1097E+00_JPRB,8.6674E-01_JPRB,3.8492E+00_JPRB/)
KBO( :, 2,15,13) = (/&
&2.2125E+00_JPRB,1.8434E+00_JPRB,1.5563E+00_JPRB,1.2050E+00_JPRB,4.1968E+00_JPRB/)
KBO( :, 3,15,13) = (/&
&2.9595E+00_JPRB,2.4844E+00_JPRB,2.0889E+00_JPRB,1.6068E+00_JPRB,4.5453E+00_JPRB/)
KBO( :, 4,15,13) = (/&
&3.8045E+00_JPRB,3.2259E+00_JPRB,2.7088E+00_JPRB,2.0757E+00_JPRB,4.8945E+00_JPRB/)
KBO( :, 5,15,13) = (/&
&4.7324E+00_JPRB,4.0530E+00_JPRB,3.4024E+00_JPRB,2.6201E+00_JPRB,5.1308E+00_JPRB/)
KBO( :, 1,16,13) = (/&
&1.6990E+00_JPRB,1.4270E+00_JPRB,1.2197E+00_JPRB,9.1540E-01_JPRB,3.2967E+00_JPRB/)
KBO( :, 2,16,13) = (/&
&2.3632E+00_JPRB,1.9965E+00_JPRB,1.6991E+00_JPRB,1.2635E+00_JPRB,3.5992E+00_JPRB/)
KBO( :, 3,16,13) = (/&
&3.1332E+00_JPRB,2.6737E+00_JPRB,2.2662E+00_JPRB,1.6797E+00_JPRB,3.8825E+00_JPRB/)
KBO( :, 4,16,13) = (/&
&3.9954E+00_JPRB,3.4413E+00_JPRB,2.9150E+00_JPRB,2.1732E+00_JPRB,4.0955E+00_JPRB/)
KBO( :, 5,16,13) = (/&
&4.9441E+00_JPRB,4.2813E+00_JPRB,3.6296E+00_JPRB,2.7347E+00_JPRB,4.3356E+00_JPRB/)
KBO( :, 1,17,13) = (/&
&1.7867E+00_JPRB,1.5291E+00_JPRB,1.3172E+00_JPRB,9.6442E-01_JPRB,2.8946E+00_JPRB/)
KBO( :, 2,17,13) = (/&
&2.4630E+00_JPRB,2.1240E+00_JPRB,1.8197E+00_JPRB,1.3271E+00_JPRB,3.1209E+00_JPRB/)
KBO( :, 3,17,13) = (/&
&3.2412E+00_JPRB,2.8205E+00_JPRB,2.4120E+00_JPRB,1.7621E+00_JPRB,3.3231E+00_JPRB/)
KBO( :, 4,17,13) = (/&
&4.1129E+00_JPRB,3.6026E+00_JPRB,3.0785E+00_JPRB,2.2752E+00_JPRB,3.5467E+00_JPRB/)
KBO( :, 5,17,13) = (/&
&5.0518E+00_JPRB,4.4575E+00_JPRB,3.8174E+00_JPRB,2.8444E+00_JPRB,3.7869E+00_JPRB/)
KBO( :, 1,18,13) = (/&
&1.8395E+00_JPRB,1.6132E+00_JPRB,1.3961E+00_JPRB,1.0121E+00_JPRB,2.6255E+00_JPRB/)
KBO( :, 2,18,13) = (/&
&2.5106E+00_JPRB,2.2211E+00_JPRB,1.9179E+00_JPRB,1.3918E+00_JPRB,2.8074E+00_JPRB/)
KBO( :, 3,18,13) = (/&
&3.2840E+00_JPRB,2.9230E+00_JPRB,2.5216E+00_JPRB,1.8455E+00_JPRB,2.9886E+00_JPRB/)
KBO( :, 4,18,13) = (/&
&4.1398E+00_JPRB,3.7076E+00_JPRB,3.1995E+00_JPRB,2.3655E+00_JPRB,3.2033E+00_JPRB/)
KBO( :, 5,18,13) = (/&
&5.0652E+00_JPRB,4.5681E+00_JPRB,3.9586E+00_JPRB,2.9470E+00_JPRB,3.4431E+00_JPRB/)
KBO( :, 1,19,13) = (/&
&1.8429E+00_JPRB,1.6700E+00_JPRB,1.4536E+00_JPRB,1.0564E+00_JPRB,2.4577E+00_JPRB/)
KBO( :, 2,19,13) = (/&
&2.5022E+00_JPRB,2.2784E+00_JPRB,1.9833E+00_JPRB,1.4492E+00_JPRB,2.6093E+00_JPRB/)
KBO( :, 3,19,13) = (/&
&3.2520E+00_JPRB,2.9805E+00_JPRB,2.5894E+00_JPRB,1.9140E+00_JPRB,2.7860E+00_JPRB/)
KBO( :, 4,19,13) = (/&
&4.0807E+00_JPRB,3.7648E+00_JPRB,3.2792E+00_JPRB,2.4354E+00_JPRB,2.9804E+00_JPRB/)
KBO( :, 5,19,13) = (/&
&4.9680E+00_JPRB,4.6224E+00_JPRB,4.0395E+00_JPRB,3.0224E+00_JPRB,3.2175E+00_JPRB/)
KBO( :, 1,20,13) = (/&
&1.8228E+00_JPRB,1.7025E+00_JPRB,1.4928E+00_JPRB,1.0898E+00_JPRB,2.3654E+00_JPRB/)
KBO( :, 2,20,13) = (/&
&2.4538E+00_JPRB,2.3051E+00_JPRB,2.0204E+00_JPRB,1.4897E+00_JPRB,2.5217E+00_JPRB/)
KBO( :, 3,20,13) = (/&
&3.1699E+00_JPRB,2.9971E+00_JPRB,2.6320E+00_JPRB,1.9524E+00_JPRB,2.6999E+00_JPRB/)
KBO( :, 4,20,13) = (/&
&3.9554E+00_JPRB,3.7710E+00_JPRB,3.3175E+00_JPRB,2.4725E+00_JPRB,2.8911E+00_JPRB/)
KBO( :, 5,20,13) = (/&
&4.8063E+00_JPRB,4.6094E+00_JPRB,4.0741E+00_JPRB,3.0590E+00_JPRB,3.1232E+00_JPRB/)
KBO( :, 1,21,13) = (/&
&1.7623E+00_JPRB,1.7061E+00_JPRB,1.5006E+00_JPRB,1.1051E+00_JPRB,2.2987E+00_JPRB/)
KBO( :, 2,21,13) = (/&
&2.3568E+00_JPRB,2.2938E+00_JPRB,2.0241E+00_JPRB,1.5005E+00_JPRB,2.4810E+00_JPRB/)
KBO( :, 3,21,13) = (/&
&3.0264E+00_JPRB,2.9663E+00_JPRB,2.6252E+00_JPRB,1.9540E+00_JPRB,2.6709E+00_JPRB/)
KBO( :, 4,21,13) = (/&
&3.7661E+00_JPRB,3.7114E+00_JPRB,3.3017E+00_JPRB,2.4660E+00_JPRB,2.8739E+00_JPRB/)
KBO( :, 5,21,13) = (/&
&4.5709E+00_JPRB,4.5292E+00_JPRB,4.0353E+00_JPRB,3.0458E+00_JPRB,3.1122E+00_JPRB/)
KBO( :, 1,22,13) = (/&
&1.7051E+00_JPRB,1.7105E+00_JPRB,1.5137E+00_JPRB,1.1220E+00_JPRB,2.2215E+00_JPRB/)
KBO( :, 2,22,13) = (/&
&2.2594E+00_JPRB,2.2812E+00_JPRB,2.0265E+00_JPRB,1.5078E+00_JPRB,2.4273E+00_JPRB/)
KBO( :, 3,22,13) = (/&
&2.8843E+00_JPRB,2.9298E+00_JPRB,2.6159E+00_JPRB,1.9497E+00_JPRB,2.6344E+00_JPRB/)
KBO( :, 4,22,13) = (/&
&3.5784E+00_JPRB,3.6530E+00_JPRB,3.2699E+00_JPRB,2.4532E+00_JPRB,2.8571E+00_JPRB/)
KBO( :, 5,22,13) = (/&
&4.3282E+00_JPRB,4.4413E+00_JPRB,3.9817E+00_JPRB,3.0263E+00_JPRB,3.1138E+00_JPRB/)
KBO( :, 1,23,13) = (/&
&1.6227E+00_JPRB,1.6865E+00_JPRB,1.4987E+00_JPRB,1.1164E+00_JPRB,2.1516E+00_JPRB/)
KBO( :, 2,23,13) = (/&
&2.1334E+00_JPRB,2.2311E+00_JPRB,1.9947E+00_JPRB,1.4865E+00_JPRB,2.3714E+00_JPRB/)
KBO( :, 3,23,13) = (/&
&2.7130E+00_JPRB,2.8505E+00_JPRB,2.5601E+00_JPRB,1.9131E+00_JPRB,2.5957E+00_JPRB/)
KBO( :, 4,23,13) = (/&
&3.3545E+00_JPRB,3.5417E+00_JPRB,3.1845E+00_JPRB,2.4070E+00_JPRB,2.8423E+00_JPRB/)
KBO( :, 5,23,13) = (/&
&4.0511E+00_JPRB,4.2980E+00_JPRB,3.8824E+00_JPRB,2.9663E+00_JPRB,3.1097E+00_JPRB/)
KBO( :, 1,24,13) = (/&
&1.5221E+00_JPRB,1.6399E+00_JPRB,1.4631E+00_JPRB,1.0922E+00_JPRB,2.0557E+00_JPRB/)
KBO( :, 2,24,13) = (/&
&1.9909E+00_JPRB,2.1551E+00_JPRB,1.9333E+00_JPRB,1.4438E+00_JPRB,2.2893E+00_JPRB/)
KBO( :, 3,24,13) = (/&
&2.5227E+00_JPRB,2.7424E+00_JPRB,2.4670E+00_JPRB,1.8560E+00_JPRB,2.5308E+00_JPRB/)
KBO( :, 4,24,13) = (/&
&3.1132E+00_JPRB,3.3998E+00_JPRB,3.0690E+00_JPRB,2.3315E+00_JPRB,2.7959E+00_JPRB/)
KBO( :, 5,24,13) = (/&
&3.7625E+00_JPRB,4.1275E+00_JPRB,3.7502E+00_JPRB,2.8726E+00_JPRB,3.0711E+00_JPRB/)
KBO( :, 1,25,13) = (/&
&1.4164E+00_JPRB,1.5764E+00_JPRB,1.4120E+00_JPRB,1.0539E+00_JPRB,1.9710E+00_JPRB/)
KBO( :, 2,25,13) = (/&
&1.8451E+00_JPRB,2.0623E+00_JPRB,1.8523E+00_JPRB,1.3889E+00_JPRB,2.2117E+00_JPRB/)
KBO( :, 3,25,13) = (/&
&2.3323E+00_JPRB,2.6170E+00_JPRB,2.3560E+00_JPRB,1.7813E+00_JPRB,2.4702E+00_JPRB/)
KBO( :, 4,25,13) = (/&
&2.8785E+00_JPRB,3.2423E+00_JPRB,2.9353E+00_JPRB,2.2379E+00_JPRB,2.7415E+00_JPRB/)
KBO( :, 5,25,13) = (/&
&3.4748E+00_JPRB,3.9386E+00_JPRB,3.5958E+00_JPRB,2.7566E+00_JPRB,3.0246E+00_JPRB/)
KBO( :, 1,26,13) = (/&
&1.3174E+00_JPRB,1.5065E+00_JPRB,1.3505E+00_JPRB,1.0108E+00_JPRB,1.9092E+00_JPRB/)
KBO( :, 2,26,13) = (/&
&1.7100E+00_JPRB,1.9656E+00_JPRB,1.7614E+00_JPRB,1.3273E+00_JPRB,2.1568E+00_JPRB/)
KBO( :, 3,26,13) = (/&
&2.1599E+00_JPRB,2.4918E+00_JPRB,2.2424E+00_JPRB,1.7022E+00_JPRB,2.4251E+00_JPRB/)
KBO( :, 4,26,13) = (/&
&2.6619E+00_JPRB,3.0863E+00_JPRB,2.8007E+00_JPRB,2.1368E+00_JPRB,2.6974E+00_JPRB/)
KBO( :, 5,26,13) = (/&
&3.2164E+00_JPRB,3.7562E+00_JPRB,3.4382E+00_JPRB,2.6323E+00_JPRB,2.9897E+00_JPRB/)
KBO( :, 1,27,13) = (/&
&1.2227E+00_JPRB,1.4318E+00_JPRB,1.2776E+00_JPRB,9.6234E-01_JPRB,1.8084E+00_JPRB/)
KBO( :, 2,27,13) = (/&
&1.5845E+00_JPRB,1.8650E+00_JPRB,1.6669E+00_JPRB,1.2616E+00_JPRB,2.0606E+00_JPRB/)
KBO( :, 3,27,13) = (/&
&1.9986E+00_JPRB,2.3637E+00_JPRB,2.1255E+00_JPRB,1.6180E+00_JPRB,2.3235E+00_JPRB/)
KBO( :, 4,27,13) = (/&
&2.4670E+00_JPRB,2.9335E+00_JPRB,2.6606E+00_JPRB,2.0306E+00_JPRB,2.5979E+00_JPRB/)
KBO( :, 5,27,13) = (/&
&2.9836E+00_JPRB,3.5812E+00_JPRB,3.2799E+00_JPRB,2.5047E+00_JPRB,2.8940E+00_JPRB/)
KBO( :, 1,28,13) = (/&
&1.1382E+00_JPRB,1.3569E+00_JPRB,1.2047E+00_JPRB,9.1050E-01_JPRB,1.6756E+00_JPRB/)
KBO( :, 2,28,13) = (/&
&1.4731E+00_JPRB,1.7658E+00_JPRB,1.5747E+00_JPRB,1.1959E+00_JPRB,1.9259E+00_JPRB/)
KBO( :, 3,28,13) = (/&
&1.8595E+00_JPRB,2.2417E+00_JPRB,2.0136E+00_JPRB,1.5323E+00_JPRB,2.1797E+00_JPRB/)
KBO( :, 4,28,13) = (/&
&2.2933E+00_JPRB,2.7930E+00_JPRB,2.5304E+00_JPRB,1.9266E+00_JPRB,2.4581E+00_JPRB/)
KBO( :, 5,28,13) = (/&
&2.7792E+00_JPRB,3.4303E+00_JPRB,3.1288E+00_JPRB,2.3846E+00_JPRB,2.7569E+00_JPRB/)
KBO( :, 1,29,13) = (/&
&1.0690E+00_JPRB,1.2881E+00_JPRB,1.1394E+00_JPRB,8.6196E-01_JPRB,1.5316E+00_JPRB/)
KBO( :, 2,29,13) = (/&
&1.3833E+00_JPRB,1.6767E+00_JPRB,1.4909E+00_JPRB,1.1330E+00_JPRB,1.7636E+00_JPRB/)
KBO( :, 3,29,13) = (/&
&1.7418E+00_JPRB,2.1373E+00_JPRB,1.9152E+00_JPRB,1.4529E+00_JPRB,2.0079E+00_JPRB/)
KBO( :, 4,29,13) = (/&
&2.1520E+00_JPRB,2.6796E+00_JPRB,2.4158E+00_JPRB,1.8327E+00_JPRB,2.2752E+00_JPRB/)
KBO( :, 5,29,13) = (/&
&2.6198E+00_JPRB,3.3045E+00_JPRB,3.0000E+00_JPRB,2.2771E+00_JPRB,2.5616E+00_JPRB/)
KBO( :, 1,30,13) = (/&
&1.0127E+00_JPRB,1.2266E+00_JPRB,1.0797E+00_JPRB,8.1863E-01_JPRB,1.3724E+00_JPRB/)
KBO( :, 2,30,13) = (/&
&1.3069E+00_JPRB,1.6015E+00_JPRB,1.4185E+00_JPRB,1.0745E+00_JPRB,1.5829E+00_JPRB/)
KBO( :, 3,30,13) = (/&
&1.6487E+00_JPRB,2.0522E+00_JPRB,1.8302E+00_JPRB,1.3820E+00_JPRB,1.8153E+00_JPRB/)
KBO( :, 4,30,13) = (/&
&2.0473E+00_JPRB,2.5843E+00_JPRB,2.3209E+00_JPRB,1.7515E+00_JPRB,2.0659E+00_JPRB/)
KBO( :, 5,30,13) = (/&
&2.5092E+00_JPRB,3.2023E+00_JPRB,2.8969E+00_JPRB,2.1888E+00_JPRB,2.3374E+00_JPRB/)
KBO( :, 1,31,13) = (/&
&9.6510E-01_JPRB,1.1794E+00_JPRB,1.0308E+00_JPRB,7.7856E-01_JPRB,1.1918E+00_JPRB/)
KBO( :, 2,31,13) = (/&
&1.2477E+00_JPRB,1.5457E+00_JPRB,1.3619E+00_JPRB,1.0252E+00_JPRB,1.3817E+00_JPRB/)
KBO( :, 3,31,13) = (/&
&1.5837E+00_JPRB,1.9885E+00_JPRB,1.7652E+00_JPRB,1.3248E+00_JPRB,1.5914E+00_JPRB/)
KBO( :, 4,31,13) = (/&
&1.9797E+00_JPRB,2.5159E+00_JPRB,2.2496E+00_JPRB,1.6880E+00_JPRB,1.8169E+00_JPRB/)
KBO( :, 5,31,13) = (/&
&2.4397E+00_JPRB,3.1333E+00_JPRB,2.8243E+00_JPRB,2.1253E+00_JPRB,2.0691E+00_JPRB/)
KBO( :, 1,32,13) = (/&
&9.2809E-01_JPRB,1.1462E+00_JPRB,9.9628E-01_JPRB,7.4536E-01_JPRB,1.0320E+00_JPRB/)
KBO( :, 2,32,13) = (/&
&1.2071E+00_JPRB,1.5069E+00_JPRB,1.3205E+00_JPRB,9.8597E-01_JPRB,1.2033E+00_JPRB/)
KBO( :, 3,32,13) = (/&
&1.5432E+00_JPRB,1.9476E+00_JPRB,1.7191E+00_JPRB,1.2835E+00_JPRB,1.3897E+00_JPRB/)
KBO( :, 4,32,13) = (/&
&1.9406E+00_JPRB,2.4766E+00_JPRB,2.2038E+00_JPRB,1.6458E+00_JPRB,1.5971E+00_JPRB/)
KBO( :, 5,32,13) = (/&
&2.3994E+00_JPRB,3.0984E+00_JPRB,2.7844E+00_JPRB,2.0892E+00_JPRB,1.8364E+00_JPRB/)
KBO( :, 1,33,13) = (/&
&9.0452E-01_JPRB,1.1258E+00_JPRB,9.7321E-01_JPRB,7.2002E-01_JPRB,8.8562E-01_JPRB/)
KBO( :, 2,33,13) = (/&
&1.1846E+00_JPRB,1.4864E+00_JPRB,1.2941E+00_JPRB,9.5876E-01_JPRB,1.0371E+00_JPRB/)
KBO( :, 3,33,13) = (/&
&1.5214E+00_JPRB,1.9311E+00_JPRB,1.6937E+00_JPRB,1.2572E+00_JPRB,1.2046E+00_JPRB/)
KBO( :, 4,33,13) = (/&
&1.9196E+00_JPRB,2.4657E+00_JPRB,2.1858E+00_JPRB,1.6239E+00_JPRB,1.3977E+00_JPRB/)
KBO( :, 5,33,13) = (/&
&2.3836E+00_JPRB,3.1007E+00_JPRB,2.7768E+00_JPRB,2.0781E+00_JPRB,1.6273E+00_JPRB/)
KBO( :, 1,34,13) = (/&
&8.8467E-01_JPRB,1.1068E+00_JPRB,9.5054E-01_JPRB,6.9629E-01_JPRB,7.8494E-01_JPRB/)
KBO( :, 2,34,13) = (/&
&1.1642E+00_JPRB,1.4706E+00_JPRB,1.2717E+00_JPRB,9.3470E-01_JPRB,9.2138E-01_JPRB/)
KBO( :, 3,34,13) = (/&
&1.5015E+00_JPRB,1.9181E+00_JPRB,1.6758E+00_JPRB,1.2345E+00_JPRB,1.0773E+00_JPRB/)
KBO( :, 4,34,13) = (/&
&1.9018E+00_JPRB,2.4632E+00_JPRB,2.1759E+00_JPRB,1.6080E+00_JPRB,1.2614E+00_JPRB/)
KBO( :, 5,34,13) = (/&
&2.3740E+00_JPRB,3.1145E+00_JPRB,2.7821E+00_JPRB,2.0712E+00_JPRB,1.4792E+00_JPRB/)
KBO( :, 1,35,13) = (/&
&8.4955E-01_JPRB,1.0688E+00_JPRB,9.1231E-01_JPRB,6.6202E-01_JPRB,6.7824E-01_JPRB/)
KBO( :, 2,35,13) = (/&
&1.1250E+00_JPRB,1.4313E+00_JPRB,1.2303E+00_JPRB,8.9698E-01_JPRB,8.0193E-01_JPRB/)
KBO( :, 3,35,13) = (/&
&1.4599E+00_JPRB,1.8791E+00_JPRB,1.6347E+00_JPRB,1.1945E+00_JPRB,9.4771E-01_JPRB/)
KBO( :, 4,35,13) = (/&
&1.8617E+00_JPRB,2.4289E+00_JPRB,2.1382E+00_JPRB,1.5703E+00_JPRB,1.1239E+00_JPRB/)
KBO( :, 5,35,13) = (/&
&2.3371E+00_JPRB,3.0886E+00_JPRB,2.7503E+00_JPRB,2.0370E+00_JPRB,1.3258E+00_JPRB/)
KBO( :, 1,36,13) = (/&
&7.9554E-01_JPRB,1.0086E+00_JPRB,8.5573E-01_JPRB,6.1485E-01_JPRB,5.7027E-01_JPRB/)
KBO( :, 2,36,13) = (/&
&1.0642E+00_JPRB,1.3634E+00_JPRB,1.1652E+00_JPRB,8.4197E-01_JPRB,6.8378E-01_JPRB/)
KBO( :, 3,36,13) = (/&
&1.3924E+00_JPRB,1.8049E+00_JPRB,1.5634E+00_JPRB,1.1326E+00_JPRB,8.2218E-01_JPRB/)
KBO( :, 4,36,13) = (/&
&1.7900E+00_JPRB,2.3512E+00_JPRB,2.0607E+00_JPRB,1.5026E+00_JPRB,9.8859E-01_JPRB/)
KBO( :, 5,36,13) = (/&
&2.2630E+00_JPRB,3.0065E+00_JPRB,2.6687E+00_JPRB,1.9640E+00_JPRB,1.1762E+00_JPRB/)
KBO( :, 1,37,13) = (/&
&7.1417E-01_JPRB,9.1309E-01_JPRB,7.7089E-01_JPRB,5.4803E-01_JPRB,4.9622E-01_JPRB/)
KBO( :, 2,37,13) = (/&
&9.6913E-01_JPRB,1.2512E+00_JPRB,1.0630E+00_JPRB,7.6043E-01_JPRB,5.9797E-01_JPRB/)
KBO( :, 3,37,13) = (/&
&1.2840E+00_JPRB,1.6746E+00_JPRB,1.4416E+00_JPRB,1.0353E+00_JPRB,7.2233E-01_JPRB/)
KBO( :, 4,37,13) = (/&
&1.6678E+00_JPRB,2.2008E+00_JPRB,1.9187E+00_JPRB,1.3875E+00_JPRB,8.7304E-01_JPRB/)
KBO( :, 5,37,13) = (/&
&2.1271E+00_JPRB,2.8380E+00_JPRB,2.5062E+00_JPRB,1.8314E+00_JPRB,1.0444E+00_JPRB/)
KBO( :, 1,38,13) = (/&
&6.4094E-01_JPRB,8.2768E-01_JPRB,6.9645E-01_JPRB,4.8972E-01_JPRB,4.2782E-01_JPRB/)
KBO( :, 2,38,13) = (/&
&8.8268E-01_JPRB,1.1499E+00_JPRB,9.7252E-01_JPRB,6.8901E-01_JPRB,5.1817E-01_JPRB/)
KBO( :, 3,38,13) = (/&
&1.1854E+00_JPRB,1.5567E+00_JPRB,1.3326E+00_JPRB,9.4875E-01_JPRB,6.2911E-01_JPRB/)
KBO( :, 4,38,13) = (/&
&1.5548E+00_JPRB,2.0633E+00_JPRB,1.7903E+00_JPRB,1.2846E+00_JPRB,7.6404E-01_JPRB/)
KBO( :, 5,38,13) = (/&
&2.0005E+00_JPRB,2.6819E+00_JPRB,2.3577E+00_JPRB,1.7108E+00_JPRB,9.1910E-01_JPRB/)
KBO( :, 1,39,13) = (/&
&5.7700E-01_JPRB,7.5348E-01_JPRB,6.3234E-01_JPRB,4.4039E-01_JPRB,3.6316E-01_JPRB/)
KBO( :, 2,39,13) = (/&
&8.0617E-01_JPRB,1.0607E+00_JPRB,8.9464E-01_JPRB,6.2787E-01_JPRB,4.4256E-01_JPRB/)
KBO( :, 3,39,13) = (/&
&1.0971E+00_JPRB,1.4528E+00_JPRB,1.2371E+00_JPRB,8.7381E-01_JPRB,5.4063E-01_JPRB/)
KBO( :, 4,39,13) = (/&
&1.4539E+00_JPRB,1.9409E+00_JPRB,1.6768E+00_JPRB,1.1946E+00_JPRB,6.6034E-01_JPRB/)
KBO( :, 5,39,13) = (/&
&1.8880E+00_JPRB,2.5419E+00_JPRB,2.2244E+00_JPRB,1.6039E+00_JPRB,7.9890E-01_JPRB/)
KBO( :, 1,40,13) = (/&
&5.0186E-01_JPRB,6.6294E-01_JPRB,5.5500E-01_JPRB,3.8289E-01_JPRB,3.1769E-01_JPRB/)
KBO( :, 2,40,13) = (/&
&7.1323E-01_JPRB,9.4798E-01_JPRB,7.9752E-01_JPRB,5.5384E-01_JPRB,3.8877E-01_JPRB/)
KBO( :, 3,40,13) = (/&
&9.8586E-01_JPRB,1.3164E+00_JPRB,1.1157E+00_JPRB,7.8136E-01_JPRB,4.7618E-01_JPRB/)
KBO( :, 4,40,13) = (/&
&1.3258E+00_JPRB,1.7781E+00_JPRB,1.5269E+00_JPRB,1.0795E+00_JPRB,5.8462E-01_JPRB/)
KBO( :, 5,40,13) = (/&
&1.7397E+00_JPRB,2.3496E+00_JPRB,2.0447E+00_JPRB,1.4640E+00_JPRB,7.1183E-01_JPRB/)
KBO( :, 1,41,13) = (/&
&4.3380E-01_JPRB,5.8097E-01_JPRB,4.8476E-01_JPRB,3.3186E-01_JPRB,2.7762E-01_JPRB/)
KBO( :, 2,41,13) = (/&
&6.2819E-01_JPRB,8.4375E-01_JPRB,7.0798E-01_JPRB,4.8718E-01_JPRB,3.4151E-01_JPRB/)
KBO( :, 3,41,13) = (/&
&8.8231E-01_JPRB,1.1885E+00_JPRB,1.0030E+00_JPRB,6.9676E-01_JPRB,4.1944E-01_JPRB/)
KBO( :, 4,41,13) = (/&
&1.2044E+00_JPRB,1.6239E+00_JPRB,1.3862E+00_JPRB,9.7292E-01_JPRB,5.1737E-01_JPRB/)
KBO( :, 5,41,13) = (/&
&1.5976E+00_JPRB,2.1644E+00_JPRB,1.8733E+00_JPRB,1.3324E+00_JPRB,6.3382E-01_JPRB/)
KBO( :, 1,42,13) = (/&
&3.7449E-01_JPRB,5.0898E-01_JPRB,4.2337E-01_JPRB,2.8788E-01_JPRB,2.4070E-01_JPRB/)
KBO( :, 2,42,13) = (/&
&5.5270E-01_JPRB,7.5038E-01_JPRB,6.2836E-01_JPRB,4.2892E-01_JPRB,2.9753E-01_JPRB/)
KBO( :, 3,42,13) = (/&
&7.8906E-01_JPRB,1.0722E+00_JPRB,9.0203E-01_JPRB,6.2172E-01_JPRB,3.6699E-01_JPRB/)
KBO( :, 4,42,13) = (/&
&1.0928E+00_JPRB,1.4824E+00_JPRB,1.2591E+00_JPRB,8.7750E-01_JPRB,4.5486E-01_JPRB/)
KBO( :, 5,42,13) = (/&
&1.4670E+00_JPRB,1.9931E+00_JPRB,1.7165E+00_JPRB,1.2130E+00_JPRB,5.6051E-01_JPRB/)
KBO( :, 1,43,13) = (/&
&3.1535E-01_JPRB,4.3481E-01_JPRB,3.6057E-01_JPRB,2.4367E-01_JPRB,2.0825E-01_JPRB/)
KBO( :, 2,43,13) = (/&
&4.7503E-01_JPRB,6.5262E-01_JPRB,5.4494E-01_JPRB,3.6943E-01_JPRB,2.5841E-01_JPRB/)
KBO( :, 3,43,13) = (/&
&6.9119E-01_JPRB,9.4733E-01_JPRB,7.9475E-01_JPRB,5.4324E-01_JPRB,3.1952E-01_JPRB/)
KBO( :, 4,43,13) = (/&
&9.7283E-01_JPRB,1.3279E+00_JPRB,1.1223E+00_JPRB,7.7674E-01_JPRB,3.9652E-01_JPRB/)
KBO( :, 5,43,13) = (/&
&1.3243E+00_JPRB,1.8050E+00_JPRB,1.5450E+00_JPRB,1.0849E+00_JPRB,4.9087E-01_JPRB/)
KBO( :, 1,44,13) = (/&
&2.6174E-01_JPRB,3.6590E-01_JPRB,3.0263E-01_JPRB,2.0344E-01_JPRB,1.7938E-01_JPRB/)
KBO( :, 2,44,13) = (/&
&4.0277E-01_JPRB,5.6056E-01_JPRB,4.6662E-01_JPRB,3.1442E-01_JPRB,2.2338E-01_JPRB/)
KBO( :, 3,44,13) = (/&
&5.9777E-01_JPRB,8.2704E-01_JPRB,6.9190E-01_JPRB,4.6961E-01_JPRB,2.7697E-01_JPRB/)
KBO( :, 4,44,13) = (/&
&8.5584E-01_JPRB,1.1770E+00_JPRB,9.9059E-01_JPRB,6.8041E-01_JPRB,3.4323E-01_JPRB/)
KBO( :, 5,44,13) = (/&
&1.1839E+00_JPRB,1.6189E+00_JPRB,1.3779E+00_JPRB,9.6037E-01_JPRB,4.2597E-01_JPRB/)
KBO( :, 1,45,13) = (/&
&2.1651E-01_JPRB,3.0623E-01_JPRB,2.5303E-01_JPRB,1.6909E-01_JPRB,1.5286E-01_JPRB/)
KBO( :, 2,45,13) = (/&
&3.3998E-01_JPRB,4.7944E-01_JPRB,3.9799E-01_JPRB,2.6665E-01_JPRB,1.9138E-01_JPRB/)
KBO( :, 3,45,13) = (/&
&5.1505E-01_JPRB,7.1915E-01_JPRB,6.0047E-01_JPRB,4.0501E-01_JPRB,2.3804E-01_JPRB/)
KBO( :, 4,45,13) = (/&
&7.5069E-01_JPRB,1.0392E+00_JPRB,8.7233E-01_JPRB,5.9477E-01_JPRB,2.9472E-01_JPRB/)
KBO( :, 5,45,13) = (/&
&1.0546E+00_JPRB,1.4482E+00_JPRB,1.2265E+00_JPRB,8.4853E-01_JPRB,3.6589E-01_JPRB/)
KBO( :, 1,46,13) = (/&
&1.7663E-01_JPRB,2.5198E-01_JPRB,2.0821E-01_JPRB,1.3852E-01_JPRB,1.2920E-01_JPRB/)
KBO( :, 2,46,13) = (/&
&2.8312E-01_JPRB,4.0392E-01_JPRB,3.3454E-01_JPRB,2.2297E-01_JPRB,1.6315E-01_JPRB/)
KBO( :, 3,46,13) = (/&
&4.3787E-01_JPRB,6.1746E-01_JPRB,5.1421E-01_JPRB,3.4506E-01_JPRB,2.0329E-01_JPRB/)
KBO( :, 4,46,13) = (/&
&6.5040E-01_JPRB,9.0658E-01_JPRB,7.5889E-01_JPRB,5.1408E-01_JPRB,2.5188E-01_JPRB/)
KBO( :, 5,46,13) = (/&
&9.2878E-01_JPRB,1.2821E+00_JPRB,1.0808E+00_JPRB,7.4274E-01_JPRB,3.1240E-01_JPRB/)
KBO( :, 1,47,13) = (/&
&1.4044E-01_JPRB,2.0128E-01_JPRB,1.6621E-01_JPRB,1.1051E-01_JPRB,1.0897E-01_JPRB/)
KBO( :, 2,47,13) = (/&
&2.3004E-01_JPRB,3.3154E-01_JPRB,2.7419E-01_JPRB,1.8180E-01_JPRB,1.3962E-01_JPRB/)
KBO( :, 3,47,13) = (/&
&3.6325E-01_JPRB,5.1821E-01_JPRB,4.3034E-01_JPRB,2.8728E-01_JPRB,1.7431E-01_JPRB/)
KBO( :, 4,47,13) = (/&
&5.5117E-01_JPRB,7.7483E-01_JPRB,6.4673E-01_JPRB,4.3554E-01_JPRB,2.1654E-01_JPRB/)
KBO( :, 5,47,13) = (/&
&8.0200E-01_JPRB,1.1139E+00_JPRB,9.3561E-01_JPRB,6.3799E-01_JPRB,2.6782E-01_JPRB/)
KBO( :, 1,48,13) = (/&
&1.1101E-01_JPRB,1.5927E-01_JPRB,1.3139E-01_JPRB,8.7527E-02_JPRB,9.0201E-02_JPRB/)
KBO( :, 2,48,13) = (/&
&1.8567E-01_JPRB,2.6968E-01_JPRB,2.2270E-01_JPRB,1.4710E-01_JPRB,1.1764E-01_JPRB/)
KBO( :, 3,48,13) = (/&
&2.9933E-01_JPRB,4.3159E-01_JPRB,3.5753E-01_JPRB,2.3730E-01_JPRB,1.4811E-01_JPRB/)
KBO( :, 4,48,13) = (/&
&4.6369E-01_JPRB,6.5797E-01_JPRB,5.4789E-01_JPRB,3.6706E-01_JPRB,1.8402E-01_JPRB/)
KBO( :, 5,48,13) = (/&
&6.8807E-01_JPRB,9.6214E-01_JPRB,8.0577E-01_JPRB,5.4570E-01_JPRB,2.2761E-01_JPRB/)
KBO( :, 1,49,13) = (/&
&8.6952E-02_JPRB,1.2481E-01_JPRB,1.0270E-01_JPRB,6.8735E-02_JPRB,7.2916E-02_JPRB/)
KBO( :, 2,49,13) = (/&
&1.4886E-01_JPRB,2.1718E-01_JPRB,1.7934E-01_JPRB,1.1829E-01_JPRB,9.6830E-02_JPRB/)
KBO( :, 3,49,13) = (/&
&2.4507E-01_JPRB,3.5657E-01_JPRB,2.9496E-01_JPRB,1.9481E-01_JPRB,1.2384E-01_JPRB/)
KBO( :, 4,49,13) = (/&
&3.8722E-01_JPRB,5.5518E-01_JPRB,4.6109E-01_JPRB,3.0744E-01_JPRB,1.5413E-01_JPRB/)
KBO( :, 5,49,13) = (/&
&5.8631E-01_JPRB,8.2602E-01_JPRB,6.8968E-01_JPRB,4.6440E-01_JPRB,1.9058E-01_JPRB/)
KBO( :, 1,50,13) = (/&
&6.8423E-02_JPRB,9.8362E-02_JPRB,8.0813E-02_JPRB,5.4318E-02_JPRB,6.0640E-02_JPRB/)
KBO( :, 2,50,13) = (/&
&1.2024E-01_JPRB,1.7560E-01_JPRB,1.4487E-01_JPRB,9.5713E-02_JPRB,8.2094E-02_JPRB/)
KBO( :, 3,50,13) = (/&
&2.0188E-01_JPRB,2.9561E-01_JPRB,2.4418E-01_JPRB,1.6072E-01_JPRB,1.0662E-01_JPRB/)
KBO( :, 4,50,13) = (/&
&3.2485E-01_JPRB,4.7020E-01_JPRB,3.8945E-01_JPRB,2.5843E-01_JPRB,1.3377E-01_JPRB/)
KBO( :, 5,50,13) = (/&
&5.0116E-01_JPRB,7.1185E-01_JPRB,5.9284E-01_JPRB,3.9734E-01_JPRB,1.6547E-01_JPRB/)
KBO( :, 1,51,13) = (/&
&5.3728E-02_JPRB,7.7475E-02_JPRB,6.3575E-02_JPRB,4.2812E-02_JPRB,5.0933E-02_JPRB/)
KBO( :, 2,51,13) = (/&
&9.7035E-02_JPRB,1.4176E-01_JPRB,1.1670E-01_JPRB,7.7313E-02_JPRB,7.0361E-02_JPRB/)
KBO( :, 3,51,13) = (/&
&1.6618E-01_JPRB,2.4447E-01_JPRB,2.0180E-01_JPRB,1.3255E-01_JPRB,9.2830E-02_JPRB/)
KBO( :, 4,51,13) = (/&
&2.7241E-01_JPRB,3.9733E-01_JPRB,3.2861E-01_JPRB,2.1702E-01_JPRB,1.1799E-01_JPRB/)
KBO( :, 5,51,13) = (/&
&4.2784E-01_JPRB,6.1277E-01_JPRB,5.0908E-01_JPRB,3.3984E-01_JPRB,1.4641E-01_JPRB/)
KBO( :, 1,52,13) = (/&
&4.1802E-02_JPRB,6.0502E-02_JPRB,4.9697E-02_JPRB,3.3504E-02_JPRB,4.2023E-02_JPRB/)
KBO( :, 2,52,13) = (/&
&7.7722E-02_JPRB,1.1354E-01_JPRB,9.3251E-02_JPRB,6.2061E-02_JPRB,5.9351E-02_JPRB/)
KBO( :, 3,52,13) = (/&
&1.3608E-01_JPRB,2.0057E-01_JPRB,1.6557E-01_JPRB,1.0873E-01_JPRB,7.9645E-02_JPRB/)
KBO( :, 4,52,13) = (/&
&2.2730E-01_JPRB,3.3353E-01_JPRB,2.7571E-01_JPRB,1.8131E-01_JPRB,1.0280E-01_JPRB/)
KBO( :, 5,52,13) = (/&
&3.6299E-01_JPRB,5.2462E-01_JPRB,4.3487E-01_JPRB,2.8905E-01_JPRB,1.2859E-01_JPRB/)
KBO( :, 1,53,13) = (/&
&3.2183E-02_JPRB,4.6680E-02_JPRB,3.8481E-02_JPRB,2.6042E-02_JPRB,3.3756E-02_JPRB/)
KBO( :, 2,53,13) = (/&
&6.1728E-02_JPRB,9.0133E-02_JPRB,7.3973E-02_JPRB,4.9381E-02_JPRB,4.8993E-02_JPRB/)
KBO( :, 3,53,13) = (/&
&1.1077E-01_JPRB,1.6319E-01_JPRB,1.3454E-01_JPRB,8.8555E-02_JPRB,6.7056E-02_JPRB/)
KBO( :, 4,53,13) = (/&
&1.8844E-01_JPRB,2.7785E-01_JPRB,2.2936E-01_JPRB,1.5042E-01_JPRB,8.7934E-02_JPRB/)
KBO( :, 5,53,13) = (/&
&3.0619E-01_JPRB,4.4605E-01_JPRB,3.6897E-01_JPRB,2.4410E-01_JPRB,1.1120E-01_JPRB/)
KBO( :, 1,54,13) = (/&
&2.5047E-02_JPRB,3.6400E-02_JPRB,3.0153E-02_JPRB,2.0502E-02_JPRB,2.9038E-02_JPRB/)
KBO( :, 2,54,13) = (/&
&4.9509E-02_JPRB,7.2463E-02_JPRB,5.9428E-02_JPRB,3.9713E-02_JPRB,4.3296E-02_JPRB/)
KBO( :, 3,54,13) = (/&
&9.1047E-02_JPRB,1.3408E-01_JPRB,1.1032E-01_JPRB,7.2811E-02_JPRB,6.0352E-02_JPRB/)
KBO( :, 4,54,13) = (/&
&1.5773E-01_JPRB,2.3322E-01_JPRB,1.9256E-01_JPRB,1.2610E-01_JPRB,8.0247E-02_JPRB/)
KBO( :, 5,54,13) = (/&
&2.6064E-01_JPRB,3.8195E-01_JPRB,3.1567E-01_JPRB,2.0798E-01_JPRB,1.0268E-01_JPRB/)
KBO( :, 1,55,13) = (/&
&1.9531E-02_JPRB,2.8409E-02_JPRB,2.3654E-02_JPRB,1.6169E-02_JPRB,2.6016E-02_JPRB/)
KBO( :, 2,55,13) = (/&
&3.9731E-02_JPRB,5.8300E-02_JPRB,4.7864E-02_JPRB,3.2046E-02_JPRB,3.9891E-02_JPRB/)
KBO( :, 3,55,13) = (/&
&7.5011E-02_JPRB,1.1035E-01_JPRB,9.0609E-02_JPRB,6.0025E-02_JPRB,5.6691E-02_JPRB/)
KBO( :, 4,55,13) = (/&
&1.3239E-01_JPRB,1.9599E-01_JPRB,1.6178E-01_JPRB,1.0597E-01_JPRB,7.6430E-02_JPRB/)
KBO( :, 5,55,13) = (/&
&2.2232E-01_JPRB,3.2737E-01_JPRB,2.7053E-01_JPRB,1.7756E-01_JPRB,9.9052E-02_JPRB/)
KBO( :, 1,56,13) = (/&
&1.5085E-02_JPRB,2.1991E-02_JPRB,1.8385E-02_JPRB,1.2629E-02_JPRB,2.3210E-02_JPRB/)
KBO( :, 2,56,13) = (/&
&3.1640E-02_JPRB,4.6519E-02_JPRB,3.8293E-02_JPRB,2.5741E-02_JPRB,3.6554E-02_JPRB/)
KBO( :, 3,56,13) = (/&
&6.1401E-02_JPRB,9.0252E-02_JPRB,7.4044E-02_JPRB,4.9175E-02_JPRB,5.3168E-02_JPRB/)
KBO( :, 4,56,13) = (/&
&1.1069E-01_JPRB,1.6371E-01_JPRB,1.3502E-01_JPRB,8.8647E-02_JPRB,7.2863E-02_JPRB/)
KBO( :, 5,56,13) = (/&
&1.8882E-01_JPRB,2.7905E-01_JPRB,2.3042E-01_JPRB,1.5088E-01_JPRB,9.5532E-02_JPRB/)
KBO( :, 1,57,13) = (/&
&1.1497E-02_JPRB,1.6861E-02_JPRB,1.4167E-02_JPRB,9.7433E-03_JPRB,2.0535E-02_JPRB/)
KBO( :, 2,57,13) = (/&
&2.4982E-02_JPRB,3.6767E-02_JPRB,3.0405E-02_JPRB,2.0539E-02_JPRB,3.3381E-02_JPRB/)
KBO( :, 3,57,13) = (/&
&4.9863E-02_JPRB,7.3408E-02_JPRB,6.0172E-02_JPRB,4.0018E-02_JPRB,4.9853E-02_JPRB/)
KBO( :, 4,57,13) = (/&
&9.1973E-02_JPRB,1.3592E-01_JPRB,1.1188E-01_JPRB,7.3644E-02_JPRB,6.9368E-02_JPRB/)
KBO( :, 5,57,13) = (/&
&1.5956E-01_JPRB,2.3633E-01_JPRB,1.9520E-01_JPRB,1.2765E-01_JPRB,9.2143E-02_JPRB/)
KBO( :, 1,58,13) = (/&
&8.7557E-03_JPRB,1.2987E-02_JPRB,1.0957E-02_JPRB,7.5300E-03_JPRB,1.8437E-02_JPRB/)
KBO( :, 2,58,13) = (/&
&1.9822E-02_JPRB,2.9153E-02_JPRB,2.4235E-02_JPRB,1.6460E-02_JPRB,3.1052E-02_JPRB/)
KBO( :, 3,58,13) = (/&
&4.0615E-02_JPRB,5.9904E-02_JPRB,4.9134E-02_JPRB,3.2752E-02_JPRB,4.7553E-02_JPRB/)
KBO( :, 4,58,13) = (/&
&7.6749E-02_JPRB,1.1326E-01_JPRB,9.3033E-02_JPRB,6.1446E-02_JPRB,6.7327E-02_JPRB/)
KBO( :, 5,58,13) = (/&
&1.3538E-01_JPRB,2.0081E-01_JPRB,1.6583E-01_JPRB,1.0846E-01_JPRB,9.0540E-02_JPRB/)
KBO( :, 1,59,13) = (/&
&7.7834E-03_JPRB,1.1635E-02_JPRB,9.8237E-03_JPRB,6.7346E-03_JPRB,2.0567E-02_JPRB/)
KBO( :, 2,59,13) = (/&
&1.7968E-02_JPRB,2.6456E-02_JPRB,2.2028E-02_JPRB,1.4988E-02_JPRB,3.5300E-02_JPRB/)
KBO( :, 3,59,13) = (/&
&3.7275E-02_JPRB,5.5026E-02_JPRB,4.5163E-02_JPRB,3.0132E-02_JPRB,5.4587E-02_JPRB/)
KBO( :, 4,59,13) = (/&
&7.1187E-02_JPRB,1.0502E-01_JPRB,8.6201E-02_JPRB,5.6998E-02_JPRB,7.7965E-02_JPRB/)
KBO( :, 5,59,13) = (/&
&1.2652E-01_JPRB,1.8769E-01_JPRB,1.5496E-01_JPRB,1.0142E-01_JPRB,1.0516E-01_JPRB/)
KBO( :, 1,13,14) = (/&
&2.2524E+00_JPRB,1.8642E+00_JPRB,1.4613E+00_JPRB,1.4569E+00_JPRB,8.7601E+00_JPRB/)
KBO( :, 2,13,14) = (/&
&3.1331E+00_JPRB,2.6017E+00_JPRB,2.0765E+00_JPRB,2.1108E+00_JPRB,8.6837E+00_JPRB/)
KBO( :, 3,13,14) = (/&
&4.2161E+00_JPRB,3.4975E+00_JPRB,2.8332E+00_JPRB,2.9400E+00_JPRB,8.5967E+00_JPRB/)
KBO( :, 4,13,14) = (/&
&5.4742E+00_JPRB,4.5326E+00_JPRB,3.7176E+00_JPRB,3.9461E+00_JPRB,8.5509E+00_JPRB/)
KBO( :, 5,13,14) = (/&
&6.8794E+00_JPRB,5.6742E+00_JPRB,4.7180E+00_JPRB,5.1201E+00_JPRB,8.7332E+00_JPRB/)
KBO( :, 1,14,14) = (/&
&2.4300E+00_JPRB,2.0099E+00_JPRB,1.6039E+00_JPRB,1.5951E+00_JPRB,7.9998E+00_JPRB/)
KBO( :, 2,14,14) = (/&
&3.3671E+00_JPRB,2.7809E+00_JPRB,2.2722E+00_JPRB,2.2861E+00_JPRB,7.9399E+00_JPRB/)
KBO( :, 3,14,14) = (/&
&4.5098E+00_JPRB,3.7249E+00_JPRB,3.1058E+00_JPRB,3.1479E+00_JPRB,7.9396E+00_JPRB/)
KBO( :, 4,14,14) = (/&
&5.8479E+00_JPRB,4.8327E+00_JPRB,4.0848E+00_JPRB,4.1748E+00_JPRB,8.0204E+00_JPRB/)
KBO( :, 5,14,14) = (/&
&7.3485E+00_JPRB,6.0867E+00_JPRB,5.1845E+00_JPRB,5.3505E+00_JPRB,8.4765E+00_JPRB/)
KBO( :, 1,15,14) = (/&
&2.6568E+00_JPRB,2.1796E+00_JPRB,1.7854E+00_JPRB,1.7352E+00_JPRB,6.7060E+00_JPRB/)
KBO( :, 2,15,14) = (/&
&3.6822E+00_JPRB,3.0192E+00_JPRB,2.5118E+00_JPRB,2.4660E+00_JPRB,6.7632E+00_JPRB/)
KBO( :, 3,15,14) = (/&
&4.9145E+00_JPRB,4.0419E+00_JPRB,3.4197E+00_JPRB,3.3625E+00_JPRB,6.9344E+00_JPRB/)
KBO( :, 4,15,14) = (/&
&6.3536E+00_JPRB,5.2540E+00_JPRB,4.4910E+00_JPRB,4.4107E+00_JPRB,7.2734E+00_JPRB/)
KBO( :, 5,15,14) = (/&
&7.9751E+00_JPRB,6.6376E+00_JPRB,5.7127E+00_JPRB,5.6036E+00_JPRB,8.1653E+00_JPRB/)
KBO( :, 1,16,14) = (/&
&2.9427E+00_JPRB,2.4019E+00_JPRB,1.9918E+00_JPRB,1.8807E+00_JPRB,5.4890E+00_JPRB/)
KBO( :, 2,16,14) = (/&
&4.0755E+00_JPRB,3.3334E+00_JPRB,2.7941E+00_JPRB,2.6497E+00_JPRB,5.7267E+00_JPRB/)
KBO( :, 3,16,14) = (/&
&5.4183E+00_JPRB,4.4587E+00_JPRB,3.7848E+00_JPRB,3.5786E+00_JPRB,6.0751E+00_JPRB/)
KBO( :, 4,16,14) = (/&
&6.9849E+00_JPRB,5.7895E+00_JPRB,4.9533E+00_JPRB,4.6688E+00_JPRB,6.8712E+00_JPRB/)
KBO( :, 5,16,14) = (/&
&8.7453E+00_JPRB,7.3192E+00_JPRB,6.3031E+00_JPRB,5.9185E+00_JPRB,8.0451E+00_JPRB/)
KBO( :, 1,17,14) = (/&
&3.2750E+00_JPRB,2.6726E+00_JPRB,2.2378E+00_JPRB,2.0301E+00_JPRB,4.7640E+00_JPRB/)
KBO( :, 2,17,14) = (/&
&4.5330E+00_JPRB,3.7089E+00_JPRB,3.1283E+00_JPRB,2.8374E+00_JPRB,5.1281E+00_JPRB/)
KBO( :, 3,17,14) = (/&
&6.0126E+00_JPRB,4.9507E+00_JPRB,4.2109E+00_JPRB,3.8046E+00_JPRB,5.7513E+00_JPRB/)
KBO( :, 4,17,14) = (/&
&7.7135E+00_JPRB,6.4169E+00_JPRB,5.4921E+00_JPRB,4.9337E+00_JPRB,6.7135E+00_JPRB/)
KBO( :, 5,17,14) = (/&
&9.6338E+00_JPRB,8.1047E+00_JPRB,6.9599E+00_JPRB,6.2366E+00_JPRB,8.0058E+00_JPRB/)
KBO( :, 1,18,14) = (/&
&3.6472E+00_JPRB,2.9807E+00_JPRB,2.5189E+00_JPRB,2.1796E+00_JPRB,4.4334E+00_JPRB/)
KBO( :, 2,18,14) = (/&
&5.0323E+00_JPRB,4.1367E+00_JPRB,3.4979E+00_JPRB,3.0247E+00_JPRB,4.9096E+00_JPRB/)
KBO( :, 3,18,14) = (/&
&6.6454E+00_JPRB,5.5144E+00_JPRB,4.6858E+00_JPRB,4.0381E+00_JPRB,5.6608E+00_JPRB/)
KBO( :, 4,18,14) = (/&
&8.4890E+00_JPRB,7.1264E+00_JPRB,6.0803E+00_JPRB,5.2199E+00_JPRB,6.6925E+00_JPRB/)
KBO( :, 5,18,14) = (/&
&1.0542E+01_JPRB,8.9586E+00_JPRB,7.6601E+00_JPRB,6.5575E+00_JPRB,7.9988E+00_JPRB/)
KBO( :, 1,19,14) = (/&
&4.0274E+00_JPRB,3.3233E+00_JPRB,2.8227E+00_JPRB,2.3261E+00_JPRB,4.2975E+00_JPRB/)
KBO( :, 2,19,14) = (/&
&5.5204E+00_JPRB,4.5992E+00_JPRB,3.8961E+00_JPRB,3.2089E+00_JPRB,4.8408E+00_JPRB/)
KBO( :, 3,19,14) = (/&
&7.2641E+00_JPRB,6.1090E+00_JPRB,5.1847E+00_JPRB,4.2710E+00_JPRB,5.6348E+00_JPRB/)
KBO( :, 4,19,14) = (/&
&9.2241E+00_JPRB,7.8543E+00_JPRB,6.6837E+00_JPRB,5.5155E+00_JPRB,6.6912E+00_JPRB/)
KBO( :, 5,19,14) = (/&
&1.1403E+01_JPRB,9.8034E+00_JPRB,8.3820E+00_JPRB,6.9048E+00_JPRB,7.9670E+00_JPRB/)
KBO( :, 1,20,14) = (/&
&4.4042E+00_JPRB,3.6923E+00_JPRB,3.1564E+00_JPRB,2.5009E+00_JPRB,4.3386E+00_JPRB/)
KBO( :, 2,20,14) = (/&
&6.0056E+00_JPRB,5.0815E+00_JPRB,4.3305E+00_JPRB,3.4328E+00_JPRB,4.8920E+00_JPRB/)
KBO( :, 3,20,14) = (/&
&7.8551E+00_JPRB,6.7164E+00_JPRB,5.7136E+00_JPRB,4.5512E+00_JPRB,5.6658E+00_JPRB/)
KBO( :, 4,20,14) = (/&
&9.9239E+00_JPRB,8.5703E+00_JPRB,7.3215E+00_JPRB,5.8504E+00_JPRB,6.6818E+00_JPRB/)
KBO( :, 5,20,14) = (/&
&1.2197E+01_JPRB,1.0639E+01_JPRB,9.1299E+00_JPRB,7.3134E+00_JPRB,7.9255E+00_JPRB/)
KBO( :, 1,21,14) = (/&
&4.7479E+00_JPRB,4.0508E+00_JPRB,3.4983E+00_JPRB,2.6955E+00_JPRB,4.4010E+00_JPRB/)
KBO( :, 2,21,14) = (/&
&6.4355E+00_JPRB,5.5399E+00_JPRB,4.7678E+00_JPRB,3.6820E+00_JPRB,4.9446E+00_JPRB/)
KBO( :, 3,21,14) = (/&
&8.3663E+00_JPRB,7.2751E+00_JPRB,6.2518E+00_JPRB,4.8572E+00_JPRB,5.6757E+00_JPRB/)
KBO( :, 4,21,14) = (/&
&1.0512E+01_JPRB,9.2314E+00_JPRB,7.9526E+00_JPRB,6.2141E+00_JPRB,6.6288E+00_JPRB/)
KBO( :, 5,21,14) = (/&
&1.2856E+01_JPRB,1.1396E+01_JPRB,9.8659E+00_JPRB,7.7561E+00_JPRB,7.8277E+00_JPRB/)
KBO( :, 1,22,14) = (/&
&5.1420E+00_JPRB,4.4823E+00_JPRB,3.9096E+00_JPRB,2.9527E+00_JPRB,4.4013E+00_JPRB/)
KBO( :, 2,22,14) = (/&
&6.9006E+00_JPRB,6.0705E+00_JPRB,5.2806E+00_JPRB,4.0025E+00_JPRB,4.9528E+00_JPRB/)
KBO( :, 3,22,14) = (/&
&8.8983E+00_JPRB,7.9013E+00_JPRB,6.8678E+00_JPRB,5.2402E+00_JPRB,5.6748E+00_JPRB/)
KBO( :, 4,22,14) = (/&
&1.1116E+01_JPRB,9.9470E+00_JPRB,8.6698E+00_JPRB,6.6674E+00_JPRB,6.5994E+00_JPRB/)
KBO( :, 5,22,14) = (/&
&1.3502E+01_JPRB,1.2202E+01_JPRB,1.0686E+01_JPRB,8.2853E+00_JPRB,7.7517E+00_JPRB/)
KBO( :, 1,23,14) = (/&
&5.4713E+00_JPRB,4.8911E+00_JPRB,4.3072E+00_JPRB,3.2139E+00_JPRB,4.3813E+00_JPRB/)
KBO( :, 2,23,14) = (/&
&7.2751E+00_JPRB,6.5638E+00_JPRB,5.7664E+00_JPRB,4.3250E+00_JPRB,4.9555E+00_JPRB/)
KBO( :, 3,23,14) = (/&
&9.3230E+00_JPRB,8.4735E+00_JPRB,7.4455E+00_JPRB,5.6212E+00_JPRB,5.6783E+00_JPRB/)
KBO( :, 4,23,14) = (/&
&1.1564E+01_JPRB,1.0599E+01_JPRB,9.3428E+00_JPRB,7.1049E+00_JPRB,6.5825E+00_JPRB/)
KBO( :, 5,23,14) = (/&
&1.3974E+01_JPRB,1.2910E+01_JPRB,1.1439E+01_JPRB,8.7857E+00_JPRB,7.6865E+00_JPRB/)
KBO( :, 1,24,14) = (/&
&5.7350E+00_JPRB,5.2712E+00_JPRB,4.6801E+00_JPRB,3.4774E+00_JPRB,4.3078E+00_JPRB/)
KBO( :, 2,24,14) = (/&
&7.5695E+00_JPRB,7.0067E+00_JPRB,6.2189E+00_JPRB,4.6444E+00_JPRB,4.9097E+00_JPRB/)
KBO( :, 3,24,14) = (/&
&9.6279E+00_JPRB,8.9845E+00_JPRB,7.9822E+00_JPRB,5.9954E+00_JPRB,5.6514E+00_JPRB/)
KBO( :, 4,24,14) = (/&
&1.1878E+01_JPRB,1.1160E+01_JPRB,9.9533E+00_JPRB,7.5366E+00_JPRB,6.5532E+00_JPRB/)
KBO( :, 5,24,14) = (/&
&1.4285E+01_JPRB,1.3514E+01_JPRB,1.2126E+01_JPRB,9.2665E+00_JPRB,7.6715E+00_JPRB/)
KBO( :, 1,25,14) = (/&
&5.9267E+00_JPRB,5.6187E+00_JPRB,5.0280E+00_JPRB,3.7387E+00_JPRB,4.2972E+00_JPRB/)
KBO( :, 2,25,14) = (/&
&7.7642E+00_JPRB,7.4077E+00_JPRB,6.6347E+00_JPRB,4.9555E+00_JPRB,4.9309E+00_JPRB/)
KBO( :, 3,25,14) = (/&
&9.8187E+00_JPRB,9.4277E+00_JPRB,8.4720E+00_JPRB,6.3648E+00_JPRB,5.6934E+00_JPRB/)
KBO( :, 4,25,14) = (/&
&1.2059E+01_JPRB,1.1644E+01_JPRB,1.0515E+01_JPRB,7.9525E+00_JPRB,6.6186E+00_JPRB/)
KBO( :, 5,25,14) = (/&
&1.4463E+01_JPRB,1.4040E+01_JPRB,1.2752E+01_JPRB,9.7432E+00_JPRB,7.7714E+00_JPRB/)
KBO( :, 1,26,14) = (/&
&6.0673E+00_JPRB,5.9449E+00_JPRB,5.3655E+00_JPRB,4.0058E+00_JPRB,4.3684E+00_JPRB/)
KBO( :, 2,26,14) = (/&
&7.8884E+00_JPRB,7.7776E+00_JPRB,7.0359E+00_JPRB,5.2751E+00_JPRB,5.0446E+00_JPRB/)
KBO( :, 3,26,14) = (/&
&9.9238E+00_JPRB,9.8293E+00_JPRB,8.9381E+00_JPRB,6.7352E+00_JPRB,5.8349E+00_JPRB/)
KBO( :, 4,26,14) = (/&
&1.2150E+01_JPRB,1.2086E+01_JPRB,1.1047E+01_JPRB,8.3792E+00_JPRB,6.8011E+00_JPRB/)
KBO( :, 5,26,14) = (/&
&1.4535E+01_JPRB,1.4527E+01_JPRB,1.3353E+01_JPRB,1.0236E+01_JPRB,7.9789E+00_JPRB/)
KBO( :, 1,27,14) = (/&
&6.1343E+00_JPRB,6.2302E+00_JPRB,5.6763E+00_JPRB,4.2525E+00_JPRB,4.3799E+00_JPRB/)
KBO( :, 2,27,14) = (/&
&7.9331E+00_JPRB,8.0869E+00_JPRB,7.4032E+00_JPRB,5.5689E+00_JPRB,5.1012E+00_JPRB/)
KBO( :, 3,27,14) = (/&
&9.9492E+00_JPRB,1.0172E+01_JPRB,9.3622E+00_JPRB,7.0779E+00_JPRB,5.9411E+00_JPRB/)
KBO( :, 4,27,14) = (/&
&1.2151E+01_JPRB,1.2467E+01_JPRB,1.1529E+01_JPRB,8.7861E+00_JPRB,6.9495E+00_JPRB/)
KBO( :, 5,27,14) = (/&
&1.4529E+01_JPRB,1.4944E+01_JPRB,1.3914E+01_JPRB,1.0727E+01_JPRB,8.1417E+00_JPRB/)
KBO( :, 1,28,14) = (/&
&6.1453E+00_JPRB,6.4763E+00_JPRB,5.9637E+00_JPRB,4.4841E+00_JPRB,4.3357E+00_JPRB/)
KBO( :, 2,28,14) = (/&
&7.9217E+00_JPRB,8.3599E+00_JPRB,7.7430E+00_JPRB,5.8381E+00_JPRB,5.0957E+00_JPRB/)
KBO( :, 3,28,14) = (/&
&9.9089E+00_JPRB,1.0474E+01_JPRB,9.7521E+00_JPRB,7.4031E+00_JPRB,5.9939E+00_JPRB/)
KBO( :, 4,28,14) = (/&
&1.2103E+01_JPRB,1.2802E+01_JPRB,1.1983E+01_JPRB,9.1765E+00_JPRB,7.0380E+00_JPRB/)
KBO( :, 5,28,14) = (/&
&1.4484E+01_JPRB,1.5315E+01_JPRB,1.4450E+01_JPRB,1.1205E+01_JPRB,8.2560E+00_JPRB/)
KBO( :, 1,29,14) = (/&
&6.1344E+00_JPRB,6.7103E+00_JPRB,6.2468E+00_JPRB,4.7094E+00_JPRB,4.2060E+00_JPRB/)
KBO( :, 2,29,14) = (/&
&7.8873E+00_JPRB,8.6217E+00_JPRB,8.0781E+00_JPRB,6.1108E+00_JPRB,4.9771E+00_JPRB/)
KBO( :, 3,29,14) = (/&
&9.8658E+00_JPRB,1.0771E+01_JPRB,1.0146E+01_JPRB,7.7338E+00_JPRB,5.8851E+00_JPRB/)
KBO( :, 4,29,14) = (/&
&1.2059E+01_JPRB,1.3133E+01_JPRB,1.2445E+01_JPRB,9.5787E+00_JPRB,6.9308E+00_JPRB/)
KBO( :, 5,29,14) = (/&
&1.4440E+01_JPRB,1.5700E+01_JPRB,1.5002E+01_JPRB,1.1702E+01_JPRB,8.1658E+00_JPRB/)
KBO( :, 1,30,14) = (/&
&6.1074E+00_JPRB,6.9340E+00_JPRB,6.5266E+00_JPRB,4.9327E+00_JPRB,4.0096E+00_JPRB/)
KBO( :, 2,30,14) = (/&
&7.8501E+00_JPRB,8.8831E+00_JPRB,8.4088E+00_JPRB,6.3894E+00_JPRB,4.7868E+00_JPRB/)
KBO( :, 3,30,14) = (/&
&9.8321E+00_JPRB,1.1068E+01_JPRB,1.0541E+01_JPRB,8.0663E+00_JPRB,5.6845E+00_JPRB/)
KBO( :, 4,30,14) = (/&
&1.2029E+01_JPRB,1.3476E+01_JPRB,1.2917E+01_JPRB,9.9903E+00_JPRB,6.7312E+00_JPRB/)
KBO( :, 5,30,14) = (/&
&1.4419E+01_JPRB,1.6109E+01_JPRB,1.5573E+01_JPRB,1.2209E+01_JPRB,7.9754E+00_JPRB/)
KBO( :, 1,31,14) = (/&
&6.0986E+00_JPRB,7.1722E+00_JPRB,6.8200E+00_JPRB,5.1755E+00_JPRB,3.7163E+00_JPRB/)
KBO( :, 2,31,14) = (/&
&7.8450E+00_JPRB,9.1619E+00_JPRB,8.7620E+00_JPRB,6.6858E+00_JPRB,4.4619E+00_JPRB/)
KBO( :, 3,31,14) = (/&
&9.8340E+00_JPRB,1.1393E+01_JPRB,1.0969E+01_JPRB,8.4279E+00_JPRB,5.3316E+00_JPRB/)
KBO( :, 4,31,14) = (/&
&1.2043E+01_JPRB,1.3864E+01_JPRB,1.3429E+01_JPRB,1.0440E+01_JPRB,6.3686E+00_JPRB/)
KBO( :, 5,31,14) = (/&
&1.4461E+01_JPRB,1.6571E+01_JPRB,1.6185E+01_JPRB,1.2751E+01_JPRB,7.6315E+00_JPRB/)
KBO( :, 1,32,14) = (/&
&6.1266E+00_JPRB,7.4384E+00_JPRB,7.1350E+00_JPRB,5.4384E+00_JPRB,3.4364E+00_JPRB/)
KBO( :, 2,32,14) = (/&
&7.8843E+00_JPRB,9.4733E+00_JPRB,9.1481E+00_JPRB,7.0065E+00_JPRB,4.1508E+00_JPRB/)
KBO( :, 3,32,14) = (/&
&9.8908E+00_JPRB,1.1765E+01_JPRB,1.1436E+01_JPRB,8.8189E+00_JPRB,5.0057E+00_JPRB/)
KBO( :, 4,32,14) = (/&
&1.2132E+01_JPRB,1.4306E+01_JPRB,1.3989E+01_JPRB,1.0926E+01_JPRB,6.0480E+00_JPRB/)
KBO( :, 5,32,14) = (/&
&1.4591E+01_JPRB,1.7095E+01_JPRB,1.6845E+01_JPRB,1.3332E+01_JPRB,7.3373E+00_JPRB/)
KBO( :, 1,33,14) = (/&
&6.1928E+00_JPRB,7.7310E+00_JPRB,7.4804E+00_JPRB,5.7251E+00_JPRB,3.1571E+00_JPRB/)
KBO( :, 2,33,14) = (/&
&7.9747E+00_JPRB,9.8269E+00_JPRB,9.5731E+00_JPRB,7.3563E+00_JPRB,3.8547E+00_JPRB/)
KBO( :, 3,33,14) = (/&
&1.0016E+01_JPRB,1.2187E+01_JPRB,1.1940E+01_JPRB,9.2481E+00_JPRB,4.7049E+00_JPRB/)
KBO( :, 4,33,14) = (/&
&1.2296E+01_JPRB,1.4804E+01_JPRB,1.4590E+01_JPRB,1.1453E+01_JPRB,5.7736E+00_JPRB/)
KBO( :, 5,33,14) = (/&
&1.4813E+01_JPRB,1.7670E+01_JPRB,1.7552E+01_JPRB,1.3951E+01_JPRB,7.0995E+00_JPRB/)
KBO( :, 1,34,14) = (/&
&6.2424E+00_JPRB,7.9897E+00_JPRB,7.7910E+00_JPRB,5.9836E+00_JPRB,2.9611E+00_JPRB/)
KBO( :, 2,34,14) = (/&
&8.0550E+00_JPRB,1.0143E+01_JPRB,9.9528E+00_JPRB,7.6724E+00_JPRB,3.6568E+00_JPRB/)
KBO( :, 3,34,14) = (/&
&1.0129E+01_JPRB,1.2569E+01_JPRB,1.2399E+01_JPRB,9.6375E+00_JPRB,4.5137E+00_JPRB/)
KBO( :, 4,34,14) = (/&
&1.2455E+01_JPRB,1.5251E+01_JPRB,1.5135E+01_JPRB,1.1928E+01_JPRB,5.6067E+00_JPRB/)
KBO( :, 5,34,14) = (/&
&1.5024E+01_JPRB,1.8190E+01_JPRB,1.8193E+01_JPRB,1.4509E+01_JPRB,6.9726E+00_JPRB/)
KBO( :, 1,35,14) = (/&
&6.1783E+00_JPRB,8.0868E+00_JPRB,7.9354E+00_JPRB,6.1097E+00_JPRB,2.7386E+00_JPRB/)
KBO( :, 2,35,14) = (/&
&8.0021E+00_JPRB,1.0274E+01_JPRB,1.0143E+01_JPRB,7.8342E+00_JPRB,3.4231E+00_JPRB/)
KBO( :, 3,35,14) = (/&
&1.0093E+01_JPRB,1.2741E+01_JPRB,1.2638E+01_JPRB,9.8464E+00_JPRB,4.2817E+00_JPRB/)
KBO( :, 4,35,14) = (/&
&1.2448E+01_JPRB,1.5466E+01_JPRB,1.5430E+01_JPRB,1.2190E+01_JPRB,5.3838E+00_JPRB/)
KBO( :, 5,35,14) = (/&
&1.5050E+01_JPRB,1.8453E+01_JPRB,1.8553E+01_JPRB,1.4830E+01_JPRB,6.7795E+00_JPRB/)
KBO( :, 1,36,14) = (/&
&5.9739E+00_JPRB,7.9879E+00_JPRB,7.8762E+00_JPRB,6.0736E+00_JPRB,2.4966E+00_JPRB/)
KBO( :, 2,36,14) = (/&
&7.7837E+00_JPRB,1.0180E+01_JPRB,1.0097E+01_JPRB,7.8072E+00_JPRB,3.1606E+00_JPRB/)
KBO( :, 3,36,14) = (/&
&9.8723E+00_JPRB,1.2658E+01_JPRB,1.2607E+01_JPRB,9.8330E+00_JPRB,4.0029E+00_JPRB/)
KBO( :, 4,36,14) = (/&
&1.2229E+01_JPRB,1.5396E+01_JPRB,1.5418E+01_JPRB,1.2194E+01_JPRB,5.0917E+00_JPRB/)
KBO( :, 5,36,14) = (/&
&1.4834E+01_JPRB,1.8403E+01_JPRB,1.8570E+01_JPRB,1.4857E+01_JPRB,6.4863E+00_JPRB/)
KBO( :, 1,37,14) = (/&
&5.5612E+00_JPRB,7.6037E+00_JPRB,7.5217E+00_JPRB,5.8049E+00_JPRB,2.2433E+00_JPRB/)
KBO( :, 2,37,14) = (/&
&7.3179E+00_JPRB,9.7571E+00_JPRB,9.7063E+00_JPRB,7.5074E+00_JPRB,2.8646E+00_JPRB/)
KBO( :, 3,37,14) = (/&
&9.3602E+00_JPRB,1.2203E+01_JPRB,1.2188E+01_JPRB,9.5001E+00_JPRB,3.6608E+00_JPRB/)
KBO( :, 4,37,14) = (/&
&1.1681E+01_JPRB,1.4916E+01_JPRB,1.4967E+01_JPRB,1.1825E+01_JPRB,4.7005E+00_JPRB/)
KBO( :, 5,37,14) = (/&
&1.4259E+01_JPRB,1.7897E+01_JPRB,1.8089E+01_JPRB,1.4461E+01_JPRB,6.0475E+00_JPRB/)
KBO( :, 1,38,14) = (/&
&5.1796E+00_JPRB,7.2275E+00_JPRB,7.1681E+00_JPRB,5.5362E+00_JPRB,1.9985E+00_JPRB/)
KBO( :, 2,38,14) = (/&
&6.8825E+00_JPRB,9.3401E+00_JPRB,9.3116E+00_JPRB,7.2050E+00_JPRB,2.5786E+00_JPRB/)
KBO( :, 3,38,14) = (/&
&8.8770E+00_JPRB,1.1748E+01_JPRB,1.1759E+01_JPRB,9.1583E+00_JPRB,3.3304E+00_JPRB/)
KBO( :, 4,38,14) = (/&
&1.1161E+01_JPRB,1.4430E+01_JPRB,1.4508E+01_JPRB,1.1443E+01_JPRB,4.3225E+00_JPRB/)
KBO( :, 5,38,14) = (/&
&1.3706E+01_JPRB,1.7382E+01_JPRB,1.7591E+01_JPRB,1.4049E+01_JPRB,5.6183E+00_JPRB/)
KBO( :, 1,39,14) = (/&
&4.8363E+00_JPRB,6.8762E+00_JPRB,6.8344E+00_JPRB,5.2801E+00_JPRB,1.7623E+00_JPRB/)
KBO( :, 2,39,14) = (/&
&6.4874E+00_JPRB,8.9479E+00_JPRB,8.9339E+00_JPRB,6.9176E+00_JPRB,2.3035E+00_JPRB/)
KBO( :, 3,39,14) = (/&
&8.4367E+00_JPRB,1.1315E+01_JPRB,1.1346E+01_JPRB,8.8331E+00_JPRB,3.0157E+00_JPRB/)
KBO( :, 4,39,14) = (/&
&1.0680E+01_JPRB,1.3965E+01_JPRB,1.4062E+01_JPRB,1.1077E+01_JPRB,3.9619E+00_JPRB/)
KBO( :, 5,39,14) = (/&
&1.3190E+01_JPRB,1.6887E+01_JPRB,1.7105E+01_JPRB,1.3646E+01_JPRB,5.2103E+00_JPRB/)
KBO( :, 1,40,14) = (/&
&4.3793E+00_JPRB,6.3557E+00_JPRB,6.3258E+00_JPRB,4.8864E+00_JPRB,1.5658E+00_JPRB/)
KBO( :, 2,40,14) = (/&
&5.9498E+00_JPRB,8.3535E+00_JPRB,8.3464E+00_JPRB,6.4658E+00_JPRB,2.0604E+00_JPRB/)
KBO( :, 3,40,14) = (/&
&7.8232E+00_JPRB,1.0648E+01_JPRB,1.0689E+01_JPRB,8.3111E+00_JPRB,2.7192E+00_JPRB/)
KBO( :, 4,40,14) = (/&
&9.9941E+00_JPRB,1.3236E+01_JPRB,1.3338E+01_JPRB,1.0477E+01_JPRB,3.5936E+00_JPRB/)
KBO( :, 5,40,14) = (/&
&1.2441E+01_JPRB,1.6098E+01_JPRB,1.6304E+01_JPRB,1.2976E+01_JPRB,4.7608E+00_JPRB/)
KBO( :, 1,41,14) = (/&
&3.9456E+00_JPRB,5.8420E+00_JPRB,5.8231E+00_JPRB,4.4960E+00_JPRB,1.3889E+00_JPRB/)
KBO( :, 2,41,14) = (/&
&5.4322E+00_JPRB,7.7601E+00_JPRB,7.7597E+00_JPRB,6.0124E+00_JPRB,1.8377E+00_JPRB/)
KBO( :, 3,41,14) = (/&
&7.2229E+00_JPRB,9.9804E+00_JPRB,1.0024E+01_JPRB,7.7851E+00_JPRB,2.4432E+00_JPRB/)
KBO( :, 4,41,14) = (/&
&9.3151E+00_JPRB,1.2496E+01_JPRB,1.2598E+01_JPRB,9.8694E+00_JPRB,3.2503E+00_JPRB/)
KBO( :, 5,41,14) = (/&
&1.1696E+01_JPRB,1.5294E+01_JPRB,1.5489E+01_JPRB,1.2290E+01_JPRB,4.3315E+00_JPRB/)
KBO( :, 1,42,14) = (/&
&3.5496E+00_JPRB,5.3598E+00_JPRB,5.3497E+00_JPRB,4.1263E+00_JPRB,1.2230E+00_JPRB/)
KBO( :, 2,42,14) = (/&
&4.9552E+00_JPRB,7.1957E+00_JPRB,7.1981E+00_JPRB,5.5771E+00_JPRB,1.6308E+00_JPRB/)
KBO( :, 3,42,14) = (/&
&6.6624E+00_JPRB,9.3374E+00_JPRB,9.3819E+00_JPRB,7.2830E+00_JPRB,2.1850E+00_JPRB/)
KBO( :, 4,42,14) = (/&
&8.6755E+00_JPRB,1.1781E+01_JPRB,1.1882E+01_JPRB,9.2833E+00_JPRB,2.9295E+00_JPRB/)
KBO( :, 5,42,14) = (/&
&1.0984E+01_JPRB,1.4512E+01_JPRB,1.4694E+01_JPRB,1.1624E+01_JPRB,3.9287E+00_JPRB/)
KBO( :, 1,43,14) = (/&
&3.1237E+00_JPRB,4.8164E+00_JPRB,4.8129E+00_JPRB,3.7055E+00_JPRB,1.0597E+00_JPRB/)
KBO( :, 2,43,14) = (/&
&4.4310E+00_JPRB,6.5524E+00_JPRB,6.5555E+00_JPRB,5.0769E+00_JPRB,1.4220E+00_JPRB/)
KBO( :, 3,43,14) = (/&
&6.0363E+00_JPRB,8.5993E+00_JPRB,8.6369E+00_JPRB,6.7040E+00_JPRB,1.9190E+00_JPRB/)
KBO( :, 4,43,14) = (/&
&7.9515E+00_JPRB,1.0949E+01_JPRB,1.1041E+01_JPRB,8.6082E+00_JPRB,2.5937E+00_JPRB/)
KBO( :, 5,43,14) = (/&
&1.0170E+01_JPRB,1.3594E+01_JPRB,1.3761E+01_JPRB,1.0846E+01_JPRB,3.5024E+00_JPRB/)
KBO( :, 1,44,14) = (/&
&2.7094E+00_JPRB,4.2738E+00_JPRB,4.2715E+00_JPRB,3.2851E+00_JPRB,9.0642E-01_JPRB/)
KBO( :, 2,44,14) = (/&
&3.9148E+00_JPRB,5.9019E+00_JPRB,5.9083E+00_JPRB,4.5708E+00_JPRB,1.2238E+00_JPRB/)
KBO( :, 3,44,14) = (/&
&5.4146E+00_JPRB,7.8441E+00_JPRB,7.8762E+00_JPRB,6.1124E+00_JPRB,1.6632E+00_JPRB/)
KBO( :, 4,44,14) = (/&
&7.2212E+00_JPRB,1.0093E+01_JPRB,1.0172E+01_JPRB,7.9162E+00_JPRB,2.2685E+00_JPRB/)
KBO( :, 5,44,14) = (/&
&9.3383E+00_JPRB,1.2640E+01_JPRB,1.2790E+01_JPRB,1.0039E+01_JPRB,3.0877E+00_JPRB/)
KBO( :, 1,45,14) = (/&
&2.3381E+00_JPRB,3.7708E+00_JPRB,3.7687E+00_JPRB,2.8968E+00_JPRB,7.6661E-01_JPRB/)
KBO( :, 2,45,14) = (/&
&3.4439E+00_JPRB,5.2956E+00_JPRB,5.3039E+00_JPRB,4.0958E+00_JPRB,1.0405E+00_JPRB/)
KBO( :, 3,45,14) = (/&
&4.8375E+00_JPRB,7.1296E+00_JPRB,7.1547E+00_JPRB,5.5510E+00_JPRB,1.4289E+00_JPRB/)
KBO( :, 4,45,14) = (/&
&6.5366E+00_JPRB,9.2742E+00_JPRB,9.3409E+00_JPRB,7.2620E+00_JPRB,1.9684E+00_JPRB/)
KBO( :, 5,45,14) = (/&
&8.5492E+00_JPRB,1.1723E+01_JPRB,1.1855E+01_JPRB,9.2715E+00_JPRB,2.7076E+00_JPRB/)
KBO( :, 1,46,14) = (/&
&1.9868E+00_JPRB,3.2812E+00_JPRB,3.2800E+00_JPRB,2.5190E+00_JPRB,6.4180E-01_JPRB/)
KBO( :, 2,46,14) = (/&
&2.9896E+00_JPRB,4.6959E+00_JPRB,4.7028E+00_JPRB,3.6244E+00_JPRB,8.7338E-01_JPRB/)
KBO( :, 3,46,14) = (/&
&4.2743E+00_JPRB,6.4145E+00_JPRB,6.4351E+00_JPRB,4.9866E+00_JPRB,1.2115E+00_JPRB/)
KBO( :, 4,46,14) = (/&
&5.8592E+00_JPRB,8.4475E+00_JPRB,8.5037E+00_JPRB,6.6059E+00_JPRB,1.6869E+00_JPRB/)
KBO( :, 5,46,14) = (/&
&7.7565E+00_JPRB,1.0789E+01_JPRB,1.0900E+01_JPRB,8.5039E+00_JPRB,2.3466E+00_JPRB/)
KBO( :, 1,47,14) = (/&
&1.6439E+00_JPRB,2.7872E+00_JPRB,2.7853E+00_JPRB,2.1361E+00_JPRB,5.3608E-01_JPRB/)
KBO( :, 2,47,14) = (/&
&2.5332E+00_JPRB,4.0761E+00_JPRB,4.0808E+00_JPRB,3.1417E+00_JPRB,7.2689E-01_JPRB/)
KBO( :, 3,47,14) = (/&
&3.7004E+00_JPRB,5.6682E+00_JPRB,5.6872E+00_JPRB,4.4002E+00_JPRB,1.0142E+00_JPRB/)
KBO( :, 4,47,14) = (/&
&5.1603E+00_JPRB,7.5763E+00_JPRB,7.6194E+00_JPRB,5.9172E+00_JPRB,1.4236E+00_JPRB/)
KBO( :, 5,47,14) = (/&
&6.9294E+00_JPRB,9.7951E+00_JPRB,9.8846E+00_JPRB,7.6954E+00_JPRB,2.0006E+00_JPRB/)
KBO( :, 1,48,14) = (/&
&1.3454E+00_JPRB,2.3441E+00_JPRB,2.3435E+00_JPRB,1.7934E+00_JPRB,4.4332E-01_JPRB/)
KBO( :, 2,48,14) = (/&
&2.1289E+00_JPRB,3.5090E+00_JPRB,3.5130E+00_JPRB,2.7017E+00_JPRB,5.9906E-01_JPRB/)
KBO( :, 3,48,14) = (/&
&3.1810E+00_JPRB,4.9808E+00_JPRB,4.9955E+00_JPRB,3.8562E+00_JPRB,8.3681E-01_JPRB/)
KBO( :, 4,48,14) = (/&
&4.5168E+00_JPRB,6.7583E+00_JPRB,6.7897E+00_JPRB,5.2679E+00_JPRB,1.1898E+00_JPRB/)
KBO( :, 5,48,14) = (/&
&6.1589E+00_JPRB,8.8519E+00_JPRB,8.9240E+00_JPRB,6.9392E+00_JPRB,1.6894E+00_JPRB/)
KBO( :, 1,49,14) = (/&
&1.0880E+00_JPRB,1.9520E+00_JPRB,1.9492E+00_JPRB,1.4892E+00_JPRB,3.6205E-01_JPRB/)
KBO( :, 2,49,14) = (/&
&1.7730E+00_JPRB,2.9965E+00_JPRB,2.9993E+00_JPRB,2.3026E+00_JPRB,4.8696E-01_JPRB/)
KBO( :, 3,49,14) = (/&
&2.7108E+00_JPRB,4.3431E+00_JPRB,4.3550E+00_JPRB,3.3555E+00_JPRB,6.7993E-01_JPRB/)
KBO( :, 4,49,14) = (/&
&3.9297E+00_JPRB,5.9939E+00_JPRB,6.0205E+00_JPRB,4.6638E+00_JPRB,9.7892E-01_JPRB/)
KBO( :, 5,49,14) = (/&
&5.4456E+00_JPRB,7.9623E+00_JPRB,8.0197E+00_JPRB,6.2316E+00_JPRB,1.4097E+00_JPRB/)
KBO( :, 1,50,14) = (/&
&8.8117E-01_JPRB,1.6250E+00_JPRB,1.6221E+00_JPRB,1.2383E+00_JPRB,3.0851E-01_JPRB/)
KBO( :, 2,50,14) = (/&
&1.4792E+00_JPRB,2.5614E+00_JPRB,2.5640E+00_JPRB,1.9649E+00_JPRB,4.1033E-01_JPRB/)
KBO( :, 3,50,14) = (/&
&2.3153E+00_JPRB,3.7911E+00_JPRB,3.7998E+00_JPRB,2.9253E+00_JPRB,5.6911E-01_JPRB/)
KBO( :, 4,50,14) = (/&
&3.4255E+00_JPRB,5.3270E+00_JPRB,5.3498E+00_JPRB,4.1369E+00_JPRB,8.2028E-01_JPRB/)
KBO( :, 5,50,14) = (/&
&4.8249E+00_JPRB,7.1748E+00_JPRB,7.2189E+00_JPRB,5.6068E+00_JPRB,1.1946E+00_JPRB/)
KBO( :, 1,51,14) = (/&
&7.1056E-01_JPRB,1.3442E+00_JPRB,1.3433E+00_JPRB,1.0241E+00_JPRB,2.6969E-01_JPRB/)
KBO( :, 2,51,14) = (/&
&1.2285E+00_JPRB,2.1825E+00_JPRB,2.1836E+00_JPRB,1.6701E+00_JPRB,3.5352E-01_JPRB/)
KBO( :, 3,51,14) = (/&
&1.9719E+00_JPRB,3.3009E+00_JPRB,3.3075E+00_JPRB,2.5431E+00_JPRB,4.8463E-01_JPRB/)
KBO( :, 4,51,14) = (/&
&2.9787E+00_JPRB,4.7254E+00_JPRB,4.7429E+00_JPRB,3.6598E+00_JPRB,6.9430E-01_JPRB/)
KBO( :, 5,51,14) = (/&
&4.2688E+00_JPRB,6.4560E+00_JPRB,6.4905E+00_JPRB,5.0345E+00_JPRB,1.0186E+00_JPRB/)
KBO( :, 1,52,14) = (/&
&5.6673E-01_JPRB,1.0993E+00_JPRB,1.1002E+00_JPRB,8.3639E-01_JPRB,2.3587E-01_JPRB/)
KBO( :, 2,52,14) = (/&
&1.0109E+00_JPRB,1.8431E+00_JPRB,1.8420E+00_JPRB,1.4073E+00_JPRB,3.0435E-01_JPRB/)
KBO( :, 3,52,14) = (/&
&1.6672E+00_JPRB,2.8532E+00_JPRB,2.8589E+00_JPRB,2.1945E+00_JPRB,4.1172E-01_JPRB/)
KBO( :, 4,52,14) = (/&
&2.5718E+00_JPRB,4.1653E+00_JPRB,4.1785E+00_JPRB,3.2201E+00_JPRB,5.8484E-01_JPRB/)
KBO( :, 5,52,14) = (/&
&3.7560E+00_JPRB,5.7814E+00_JPRB,5.8111E+00_JPRB,4.5005E+00_JPRB,8.6103E-01_JPRB/)
KBO( :, 1,53,14) = (/&
&4.4695E-01_JPRB,8.8846E-01_JPRB,8.9001E-01_JPRB,6.7290E-01_JPRB,2.0456E-01_JPRB/)
KBO( :, 2,53,14) = (/&
&8.2293E-01_JPRB,1.5387E+00_JPRB,1.5377E+00_JPRB,1.1737E+00_JPRB,2.6214E-01_JPRB/)
KBO( :, 3,53,14) = (/&
&1.3961E+00_JPRB,2.4467E+00_JPRB,2.4512E+00_JPRB,1.8778E+00_JPRB,3.4832E-01_JPRB/)
KBO( :, 4,53,14) = (/&
&2.2042E+00_JPRB,3.6459E+00_JPRB,3.6556E+00_JPRB,2.8141E+00_JPRB,4.9014E-01_JPRB/)
KBO( :, 5,53,14) = (/&
&3.2850E+00_JPRB,5.1511E+00_JPRB,5.1749E+00_JPRB,4.0006E+00_JPRB,7.2139E-01_JPRB/)
KBO( :, 1,54,14) = (/&
&3.5542E-01_JPRB,7.2243E-01_JPRB,7.2402E-01_JPRB,5.4442E-01_JPRB,1.8822E-01_JPRB/)
KBO( :, 2,54,14) = (/&
&6.7476E-01_JPRB,1.2906E+00_JPRB,1.2914E+00_JPRB,9.8429E-01_JPRB,2.4211E-01_JPRB/)
KBO( :, 3,54,14) = (/&
&1.1767E+00_JPRB,2.1105E+00_JPRB,2.1120E+00_JPRB,1.6159E+00_JPRB,3.1436E-01_JPRB/)
KBO( :, 4,54,14) = (/&
&1.9014E+00_JPRB,3.2074E+00_JPRB,3.2160E+00_JPRB,2.4725E+00_JPRB,4.3384E-01_JPRB/)
KBO( :, 5,54,14) = (/&
&2.8871E+00_JPRB,4.6109E+00_JPRB,4.6302E+00_JPRB,3.5724E+00_JPRB,6.2978E-01_JPRB/)
KBO( :, 1,55,14) = (/&
&2.8206E-01_JPRB,5.8561E-01_JPRB,5.8631E-01_JPRB,4.3881E-01_JPRB,1.7956E-01_JPRB/)
KBO( :, 2,55,14) = (/&
&5.5285E-01_JPRB,1.0805E+00_JPRB,1.0824E+00_JPRB,8.2279E-01_JPRB,2.3170E-01_JPRB/)
KBO( :, 3,55,14) = (/&
&9.9080E-01_JPRB,1.8171E+00_JPRB,1.8174E+00_JPRB,1.3888E+00_JPRB,2.9651E-01_JPRB/)
KBO( :, 4,55,14) = (/&
&1.6397E+00_JPRB,2.8207E+00_JPRB,2.8269E+00_JPRB,2.1700E+00_JPRB,3.9927E-01_JPRB/)
KBO( :, 5,55,14) = (/&
&2.5364E+00_JPRB,4.1246E+00_JPRB,4.1390E+00_JPRB,3.1901E+00_JPRB,5.6676E-01_JPRB/)
KBO( :, 1,56,14) = (/&
&2.2149E-01_JPRB,4.6888E-01_JPRB,4.6793E-01_JPRB,3.4931E-01_JPRB,1.7153E-01_JPRB/)
KBO( :, 2,56,14) = (/&
&4.4941E-01_JPRB,8.9702E-01_JPRB,8.9917E-01_JPRB,6.8030E-01_JPRB,2.2216E-01_JPRB/)
KBO( :, 3,56,14) = (/&
&8.2764E-01_JPRB,1.5520E+00_JPRB,1.5517E+00_JPRB,1.1848E+00_JPRB,2.8403E-01_JPRB/)
KBO( :, 4,56,14) = (/&
&1.4044E+00_JPRB,2.4656E+00_JPRB,2.4713E+00_JPRB,1.8937E+00_JPRB,3.7249E-01_JPRB/)
KBO( :, 5,56,14) = (/&
&2.2168E+00_JPRB,3.6708E+00_JPRB,3.6827E+00_JPRB,2.8356E+00_JPRB,5.1654E-01_JPRB/)
KBO( :, 1,57,14) = (/&
&1.7214E-01_JPRB,3.7079E-01_JPRB,3.6824E-01_JPRB,2.7420E-01_JPRB,1.6338E-01_JPRB/)
KBO( :, 2,57,14) = (/&
&3.6172E-01_JPRB,7.3713E-01_JPRB,7.3924E-01_JPRB,5.5639E-01_JPRB,2.1373E-01_JPRB/)
KBO( :, 3,57,14) = (/&
&6.8570E-01_JPRB,1.3134E+00_JPRB,1.3148E+00_JPRB,1.0025E+00_JPRB,2.7456E-01_JPRB/)
KBO( :, 4,57,14) = (/&
&1.1942E+00_JPRB,2.1424E+00_JPRB,2.1454E+00_JPRB,1.6418E+00_JPRB,3.5310E-01_JPRB/)
KBO( :, 5,57,14) = (/&
&1.9264E+00_JPRB,3.2505E+00_JPRB,3.2602E+00_JPRB,2.5070E+00_JPRB,4.7752E-01_JPRB/)
KBO( :, 1,58,14) = (/&
&1.3445E-01_JPRB,2.9284E-01_JPRB,2.8903E-01_JPRB,2.1482E-01_JPRB,1.5774E-01_JPRB/)
KBO( :, 2,58,14) = (/&
&2.9137E-01_JPRB,6.0563E-01_JPRB,6.0668E-01_JPRB,4.5447E-01_JPRB,2.0929E-01_JPRB/)
KBO( :, 3,58,14) = (/&
&5.6904E-01_JPRB,1.1121E+00_JPRB,1.1143E+00_JPRB,8.4762E-01_JPRB,2.7004E-01_JPRB/)
KBO( :, 4,58,14) = (/&
&1.0164E+00_JPRB,1.8625E+00_JPRB,1.8634E+00_JPRB,1.4242E+00_JPRB,3.4514E-01_JPRB/)
KBO( :, 5,58,14) = (/&
&1.6772E+00_JPRB,2.8815E+00_JPRB,2.8885E+00_JPRB,2.2182E+00_JPRB,4.5564E-01_JPRB/)
KBO( :, 1,59,14) = (/&
&1.2131E-01_JPRB,2.6518E-01_JPRB,2.6089E-01_JPRB,1.9393E-01_JPRB,1.7441E-01_JPRB/)
KBO( :, 2,59,14) = (/&
&2.6626E-01_JPRB,5.5782E-01_JPRB,5.5852E-01_JPRB,4.1787E-01_JPRB,2.3461E-01_JPRB/)
KBO( :, 3,59,14) = (/&
&5.2659E-01_JPRB,1.0377E+00_JPRB,1.0403E+00_JPRB,7.9028E-01_JPRB,3.0633E-01_JPRB/)
KBO( :, 4,59,14) = (/&
&9.5064E-01_JPRB,1.7566E+00_JPRB,1.7573E+00_JPRB,1.3429E+00_JPRB,3.9674E-01_JPRB/)
KBO( :, 5,59,14) = (/&
&1.5830E+00_JPRB,2.7404E+00_JPRB,2.7474E+00_JPRB,2.1087E+00_JPRB,5.2021E-01_JPRB/)
KBO( :, 1,13,15) = (/&
&3.2244E+00_JPRB,2.5409E+00_JPRB,3.1328E+00_JPRB,4.6712E+00_JPRB,1.1048E+01_JPRB/)
KBO( :, 2,13,15) = (/&
&4.5398E+00_JPRB,3.6057E+00_JPRB,4.5237E+00_JPRB,6.7554E+00_JPRB,1.1523E+01_JPRB/)
KBO( :, 3,13,15) = (/&
&6.0837E+00_JPRB,4.8732E+00_JPRB,6.1887E+00_JPRB,9.2622E+00_JPRB,1.3154E+01_JPRB/)
KBO( :, 4,13,15) = (/&
&7.8628E+00_JPRB,6.3217E+00_JPRB,8.1422E+00_JPRB,1.2196E+01_JPRB,1.6296E+01_JPRB/)
KBO( :, 5,13,15) = (/&
&9.8525E+00_JPRB,7.9653E+00_JPRB,1.0472E+01_JPRB,1.5686E+01_JPRB,2.0959E+01_JPRB/)
KBO( :, 1,14,15) = (/&
&3.5755E+00_JPRB,2.8779E+00_JPRB,3.4519E+00_JPRB,5.1028E+00_JPRB,1.0373E+01_JPRB/)
KBO( :, 2,14,15) = (/&
&5.0524E+00_JPRB,4.1250E+00_JPRB,4.9883E+00_JPRB,7.3878E+00_JPRB,1.1513E+01_JPRB/)
KBO( :, 3,14,15) = (/&
&6.8346E+00_JPRB,5.5984E+00_JPRB,6.8212E+00_JPRB,1.0151E+01_JPRB,1.3855E+01_JPRB/)
KBO( :, 4,14,15) = (/&
&8.9000E+00_JPRB,7.2723E+00_JPRB,8.9537E+00_JPRB,1.3379E+01_JPRB,1.7871E+01_JPRB/)
KBO( :, 5,14,15) = (/&
&1.1265E+01_JPRB,9.1701E+00_JPRB,1.1497E+01_JPRB,1.7206E+01_JPRB,2.2981E+01_JPRB/)
KBO( :, 1,15,15) = (/&
&4.0824E+00_JPRB,3.3435E+00_JPRB,3.8164E+00_JPRB,5.5870E+00_JPRB,9.5637E+00_JPRB/)
KBO( :, 2,15,15) = (/&
&5.7577E+00_JPRB,4.7850E+00_JPRB,5.5076E+00_JPRB,8.0842E+00_JPRB,1.1461E+01_JPRB/)
KBO( :, 3,15,15) = (/&
&7.8213E+00_JPRB,6.5007E+00_JPRB,7.5362E+00_JPRB,1.1097E+01_JPRB,1.4826E+01_JPRB/)
KBO( :, 4,15,15) = (/&
&1.0256E+01_JPRB,8.4593E+00_JPRB,9.9114E+00_JPRB,1.4655E+01_JPRB,1.9572E+01_JPRB/)
KBO( :, 5,15,15) = (/&
&1.3032E+01_JPRB,1.0687E+01_JPRB,1.2684E+01_JPRB,1.8793E+01_JPRB,2.5099E+01_JPRB/)
KBO( :, 1,16,15) = (/&
&4.7372E+00_JPRB,3.9270E+00_JPRB,4.2463E+00_JPRB,6.1221E+00_JPRB,9.0976E+00_JPRB/)
KBO( :, 2,16,15) = (/&
&6.6436E+00_JPRB,5.5787E+00_JPRB,6.1045E+00_JPRB,8.8126E+00_JPRB,1.1843E+01_JPRB/)
KBO( :, 3,16,15) = (/&
&9.0517E+00_JPRB,7.5797E+00_JPRB,8.3542E+00_JPRB,1.2092E+01_JPRB,1.6147E+01_JPRB/)
KBO( :, 4,16,15) = (/&
&1.1879E+01_JPRB,9.9008E+00_JPRB,1.1023E+01_JPRB,1.5960E+01_JPRB,2.1309E+01_JPRB/)
KBO( :, 5,16,15) = (/&
&1.5093E+01_JPRB,1.2519E+01_JPRB,1.4078E+01_JPRB,2.0387E+01_JPRB,2.7221E+01_JPRB/)
KBO( :, 1,17,15) = (/&
&5.5197E+00_JPRB,4.6160E+00_JPRB,4.7418E+00_JPRB,6.6773E+00_JPRB,9.2205E+00_JPRB/)
KBO( :, 2,17,15) = (/&
&7.7119E+00_JPRB,6.5019E+00_JPRB,6.7774E+00_JPRB,9.5358E+00_JPRB,1.2727E+01_JPRB/)
KBO( :, 3,17,15) = (/&
&1.0467E+01_JPRB,8.8388E+00_JPRB,9.2742E+00_JPRB,1.3058E+01_JPRB,1.7430E+01_JPRB/)
KBO( :, 4,17,15) = (/&
&1.3720E+01_JPRB,1.1553E+01_JPRB,1.2244E+01_JPRB,1.7227E+01_JPRB,2.2998E+01_JPRB/)
KBO( :, 5,17,15) = (/&
&1.7413E+01_JPRB,1.4594E+01_JPRB,1.5673E+01_JPRB,2.2047E+01_JPRB,2.9433E+01_JPRB/)
KBO( :, 1,18,15) = (/&
&6.4274E+00_JPRB,5.4111E+00_JPRB,5.3034E+00_JPRB,7.2350E+00_JPRB,9.7622E+00_JPRB/)
KBO( :, 2,18,15) = (/&
&8.9573E+00_JPRB,7.5807E+00_JPRB,7.5479E+00_JPRB,1.0273E+01_JPRB,1.3710E+01_JPRB/)
KBO( :, 3,18,15) = (/&
&1.2111E+01_JPRB,1.0258E+01_JPRB,1.0321E+01_JPRB,1.4006E+01_JPRB,1.8696E+01_JPRB/)
KBO( :, 4,18,15) = (/&
&1.5845E+01_JPRB,1.3386E+01_JPRB,1.3622E+01_JPRB,1.8470E+01_JPRB,2.4650E+01_JPRB/)
KBO( :, 5,18,15) = (/&
&2.0084E+01_JPRB,1.6890E+01_JPRB,1.7434E+01_JPRB,2.3673E+01_JPRB,3.1599E+01_JPRB/)
KBO( :, 1,19,15) = (/&
&7.5164E+00_JPRB,6.3134E+00_JPRB,5.9395E+00_JPRB,7.8093E+00_JPRB,1.0475E+01_JPRB/)
KBO( :, 2,19,15) = (/&
&1.0441E+01_JPRB,8.8014E+00_JPRB,8.4278E+00_JPRB,1.1035E+01_JPRB,1.4729E+01_JPRB/)
KBO( :, 3,19,15) = (/&
&1.4043E+01_JPRB,1.1861E+01_JPRB,1.1513E+01_JPRB,1.4988E+01_JPRB,2.0004E+01_JPRB/)
KBO( :, 4,19,15) = (/&
&1.8322E+01_JPRB,1.5433E+01_JPRB,1.5177E+01_JPRB,1.9715E+01_JPRB,2.6318E+01_JPRB/)
KBO( :, 5,19,15) = (/&
&2.3146E+01_JPRB,1.9466E+01_JPRB,1.9384E+01_JPRB,2.5255E+01_JPRB,3.3709E+01_JPRB/)
KBO( :, 1,20,15) = (/&
&8.8455E+00_JPRB,7.4066E+00_JPRB,6.7186E+00_JPRB,8.4558E+00_JPRB,1.1343E+01_JPRB/)
KBO( :, 2,20,15) = (/&
&1.2219E+01_JPRB,1.0275E+01_JPRB,9.4871E+00_JPRB,1.1882E+01_JPRB,1.5858E+01_JPRB/)
KBO( :, 3,20,15) = (/&
&1.6346E+01_JPRB,1.3763E+01_JPRB,1.2931E+01_JPRB,1.6095E+01_JPRB,2.1479E+01_JPRB/)
KBO( :, 4,20,15) = (/&
&2.1206E+01_JPRB,1.7855E+01_JPRB,1.6990E+01_JPRB,2.1127E+01_JPRB,2.8198E+01_JPRB/)
KBO( :, 5,20,15) = (/&
&2.6661E+01_JPRB,2.2435E+01_JPRB,2.1640E+01_JPRB,2.6969E+01_JPRB,3.5995E+01_JPRB/)
KBO( :, 1,21,15) = (/&
&1.0378E+01_JPRB,8.6731E+00_JPRB,7.6340E+00_JPRB,9.1349E+00_JPRB,1.2281E+01_JPRB/)
KBO( :, 2,21,15) = (/&
&1.4246E+01_JPRB,1.1959E+01_JPRB,1.0712E+01_JPRB,1.2780E+01_JPRB,1.7040E+01_JPRB/)
KBO( :, 3,21,15) = (/&
&1.8940E+01_JPRB,1.5929E+01_JPRB,1.4528E+01_JPRB,1.7265E+01_JPRB,2.3018E+01_JPRB/)
KBO( :, 4,21,15) = (/&
&2.4416E+01_JPRB,2.0563E+01_JPRB,1.9019E+01_JPRB,2.2602E+01_JPRB,3.0124E+01_JPRB/)
KBO( :, 5,21,15) = (/&
&3.0523E+01_JPRB,2.5747E+01_JPRB,2.4135E+01_JPRB,2.8712E+01_JPRB,3.8248E+01_JPRB/)
KBO( :, 1,22,15) = (/&
&1.2355E+01_JPRB,1.0324E+01_JPRB,8.9103E+00_JPRB,1.0132E+01_JPRB,1.3532E+01_JPRB/)
KBO( :, 2,22,15) = (/&
&1.6827E+01_JPRB,1.4110E+01_JPRB,1.2397E+01_JPRB,1.4085E+01_JPRB,1.8635E+01_JPRB/)
KBO( :, 3,22,15) = (/&
&2.2180E+01_JPRB,1.8653E+01_JPRB,1.6659E+01_JPRB,1.8921E+01_JPRB,2.5003E+01_JPRB/)
KBO( :, 4,22,15) = (/&
&2.8311E+01_JPRB,2.3905E+01_JPRB,2.1641E+01_JPRB,2.4584E+01_JPRB,3.2472E+01_JPRB/)
KBO( :, 5,22,15) = (/&
&3.5149E+01_JPRB,2.9738E+01_JPRB,2.7250E+01_JPRB,3.1004E+01_JPRB,4.0987E+01_JPRB/)
KBO( :, 1,23,15) = (/&
&1.4605E+01_JPRB,1.2205E+01_JPRB,1.0445E+01_JPRB,1.1291E+01_JPRB,1.4871E+01_JPRB/)
KBO( :, 2,23,15) = (/&
&1.9716E+01_JPRB,1.6539E+01_JPRB,1.4376E+01_JPRB,1.5566E+01_JPRB,2.0310E+01_JPRB/)
KBO( :, 3,23,15) = (/&
&2.5726E+01_JPRB,2.1683E+01_JPRB,1.9115E+01_JPRB,2.0736E+01_JPRB,2.6995E+01_JPRB/)
KBO( :, 4,23,15) = (/&
&3.2572E+01_JPRB,2.7566E+01_JPRB,2.4581E+01_JPRB,2.6716E+01_JPRB,3.4786E+01_JPRB/)
KBO( :, 5,23,15) = (/&
&4.0123E+01_JPRB,3.4080E+01_JPRB,3.0686E+01_JPRB,3.3457E+01_JPRB,4.3686E+01_JPRB/)
KBO( :, 1,24,15) = (/&
&1.7134E+01_JPRB,1.4330E+01_JPRB,1.2237E+01_JPRB,1.2592E+01_JPRB,1.6241E+01_JPRB/)
KBO( :, 2,24,15) = (/&
&2.2882E+01_JPRB,1.9252E+01_JPRB,1.6642E+01_JPRB,1.7193E+01_JPRB,2.2035E+01_JPRB/)
KBO( :, 3,24,15) = (/&
&2.9584E+01_JPRB,2.5005E+01_JPRB,2.1866E+01_JPRB,2.2682E+01_JPRB,2.9023E+01_JPRB/)
KBO( :, 4,24,15) = (/&
&3.7130E+01_JPRB,3.1556E+01_JPRB,2.7836E+01_JPRB,2.8990E+01_JPRB,3.7154E+01_JPRB/)
KBO( :, 5,24,15) = (/&
&4.5388E+01_JPRB,3.8713E+01_JPRB,3.4446E+01_JPRB,3.6104E+01_JPRB,4.6377E+01_JPRB/)
KBO( :, 1,25,15) = (/&
&1.9927E+01_JPRB,1.6707E+01_JPRB,1.4288E+01_JPRB,1.4051E+01_JPRB,1.7699E+01_JPRB/)
KBO( :, 2,25,15) = (/&
&2.6343E+01_JPRB,2.2217E+01_JPRB,1.9188E+01_JPRB,1.8973E+01_JPRB,2.3814E+01_JPRB/)
KBO( :, 3,25,15) = (/&
&3.3724E+01_JPRB,2.8620E+01_JPRB,2.4897E+01_JPRB,2.4764E+01_JPRB,3.1106E+01_JPRB/)
KBO( :, 4,25,15) = (/&
&4.1952E+01_JPRB,3.5794E+01_JPRB,3.1378E+01_JPRB,3.1440E+01_JPRB,3.9572E+01_JPRB/)
KBO( :, 5,25,15) = (/&
&5.0891E+01_JPRB,4.3587E+01_JPRB,3.8479E+01_JPRB,3.8878E+01_JPRB,4.9030E+01_JPRB/)
KBO( :, 1,26,15) = (/&
&2.3026E+01_JPRB,1.9365E+01_JPRB,1.6616E+01_JPRB,1.5692E+01_JPRB,1.9320E+01_JPRB/)
KBO( :, 2,26,15) = (/&
&3.0129E+01_JPRB,2.5491E+01_JPRB,2.2032E+01_JPRB,2.0944E+01_JPRB,2.5726E+01_JPRB/)
KBO( :, 3,26,15) = (/&
&3.8188E+01_JPRB,3.2536E+01_JPRB,2.8266E+01_JPRB,2.7089E+01_JPRB,3.3354E+01_JPRB/)
KBO( :, 4,26,15) = (/&
&4.7076E+01_JPRB,4.0316E+01_JPRB,3.5238E+01_JPRB,3.4113E+01_JPRB,4.2106E+01_JPRB/)
KBO( :, 5,26,15) = (/&
&5.6691E+01_JPRB,4.8702E+01_JPRB,4.2828E+01_JPRB,4.1890E+01_JPRB,5.1865E+01_JPRB/)
KBO( :, 1,27,15) = (/&
&2.6319E+01_JPRB,2.2209E+01_JPRB,1.9103E+01_JPRB,1.7475E+01_JPRB,2.1047E+01_JPRB/)
KBO( :, 2,27,15) = (/&
&3.4077E+01_JPRB,2.8961E+01_JPRB,2.5047E+01_JPRB,2.3066E+01_JPRB,2.7740E+01_JPRB/)
KBO( :, 3,27,15) = (/&
&4.2766E+01_JPRB,3.6599E+01_JPRB,3.1799E+01_JPRB,2.9545E+01_JPRB,3.5624E+01_JPRB/)
KBO( :, 4,27,15) = (/&
&5.2311E+01_JPRB,4.4949E+01_JPRB,3.9254E+01_JPRB,3.6881E+01_JPRB,4.4625E+01_JPRB/)
KBO( :, 5,27,15) = (/&
&6.2535E+01_JPRB,5.3903E+01_JPRB,4.7276E+01_JPRB,4.4959E+01_JPRB,5.4744E+01_JPRB/)
KBO( :, 1,28,15) = (/&
&2.9739E+01_JPRB,2.5212E+01_JPRB,2.1725E+01_JPRB,1.9370E+01_JPRB,2.2823E+01_JPRB/)
KBO( :, 2,28,15) = (/&
&3.8111E+01_JPRB,3.2556E+01_JPRB,2.8178E+01_JPRB,2.5312E+01_JPRB,2.9805E+01_JPRB/)
KBO( :, 3,28,15) = (/&
&4.7442E+01_JPRB,4.0758E+01_JPRB,3.5447E+01_JPRB,3.2130E+01_JPRB,3.7952E+01_JPRB/)
KBO( :, 4,28,15) = (/&
&5.7581E+01_JPRB,4.9637E+01_JPRB,4.3359E+01_JPRB,3.9780E+01_JPRB,4.7241E+01_JPRB/)
KBO( :, 5,28,15) = (/&
&6.8350E+01_JPRB,5.9110E+01_JPRB,5.1790E+01_JPRB,4.8135E+01_JPRB,5.7711E+01_JPRB/)
KBO( :, 1,29,15) = (/&
&3.3289E+01_JPRB,2.8377E+01_JPRB,2.4485E+01_JPRB,2.1425E+01_JPRB,2.4625E+01_JPRB/)
KBO( :, 2,29,15) = (/&
&4.2270E+01_JPRB,3.6277E+01_JPRB,3.1445E+01_JPRB,2.7695E+01_JPRB,3.1898E+01_JPRB/)
KBO( :, 3,29,15) = (/&
&5.2200E+01_JPRB,4.5001E+01_JPRB,3.9165E+01_JPRB,3.4833E+01_JPRB,4.0336E+01_JPRB/)
KBO( :, 4,29,15) = (/&
&6.2884E+01_JPRB,5.4377E+01_JPRB,4.7526E+01_JPRB,4.2792E+01_JPRB,4.9976E+01_JPRB/)
KBO( :, 5,29,15) = (/&
&7.4157E+01_JPRB,6.4312E+01_JPRB,5.6343E+01_JPRB,5.1436E+01_JPRB,6.0842E+01_JPRB/)
KBO( :, 1,30,15) = (/&
&3.6922E+01_JPRB,3.1637E+01_JPRB,2.7336E+01_JPRB,2.3566E+01_JPRB,2.6436E+01_JPRB/)
KBO( :, 2,30,15) = (/&
&4.6484E+01_JPRB,4.0046E+01_JPRB,3.4764E+01_JPRB,3.0148E+01_JPRB,3.4000E+01_JPRB/)
KBO( :, 3,30,15) = (/&
&5.6941E+01_JPRB,4.9235E+01_JPRB,4.2907E+01_JPRB,3.7604E+01_JPRB,4.2767E+01_JPRB/)
KBO( :, 4,30,15) = (/&
&6.8119E+01_JPRB,5.9074E+01_JPRB,5.1660E+01_JPRB,4.5840E+01_JPRB,5.2778E+01_JPRB/)
KBO( :, 5,30,15) = (/&
&7.9816E+01_JPRB,6.9391E+01_JPRB,6.0797E+01_JPRB,5.4746E+01_JPRB,6.4070E+01_JPRB/)
KBO( :, 1,31,15) = (/&
&4.0648E+01_JPRB,3.4989E+01_JPRB,3.0276E+01_JPRB,2.5790E+01_JPRB,2.8253E+01_JPRB/)
KBO( :, 2,31,15) = (/&
&5.0739E+01_JPRB,4.3869E+01_JPRB,3.8136E+01_JPRB,3.2693E+01_JPRB,3.6176E+01_JPRB/)
KBO( :, 3,31,15) = (/&
&6.1698E+01_JPRB,5.3493E+01_JPRB,4.6669E+01_JPRB,4.0453E+01_JPRB,4.5327E+01_JPRB/)
KBO( :, 4,31,15) = (/&
&7.3307E+01_JPRB,6.3725E+01_JPRB,5.5765E+01_JPRB,4.8944E+01_JPRB,5.5745E+01_JPRB/)
KBO( :, 5,31,15) = (/&
&8.5379E+01_JPRB,7.4384E+01_JPRB,6.5189E+01_JPRB,5.8116E+01_JPRB,6.7439E+01_JPRB/)
KBO( :, 1,32,15) = (/&
&4.4430E+01_JPRB,3.8384E+01_JPRB,3.3279E+01_JPRB,2.8093E+01_JPRB,3.0198E+01_JPRB/)
KBO( :, 2,32,15) = (/&
&5.5010E+01_JPRB,4.7713E+01_JPRB,4.1521E+01_JPRB,3.5304E+01_JPRB,3.8486E+01_JPRB/)
KBO( :, 3,32,15) = (/&
&6.6406E+01_JPRB,5.7714E+01_JPRB,5.0403E+01_JPRB,4.3340E+01_JPRB,4.8019E+01_JPRB/)
KBO( :, 4,32,15) = (/&
&7.8394E+01_JPRB,6.8294E+01_JPRB,5.9802E+01_JPRB,5.2093E+01_JPRB,5.8861E+01_JPRB/)
KBO( :, 5,32,15) = (/&
&9.0789E+01_JPRB,7.9248E+01_JPRB,6.9496E+01_JPRB,6.1520E+01_JPRB,7.0971E+01_JPRB/)
KBO( :, 1,33,15) = (/&
&4.8242E+01_JPRB,4.1814E+01_JPRB,3.6311E+01_JPRB,3.0445E+01_JPRB,3.2261E+01_JPRB/)
KBO( :, 2,33,15) = (/&
&5.9259E+01_JPRB,5.1534E+01_JPRB,4.4898E+01_JPRB,3.7953E+01_JPRB,4.0933E+01_JPRB/)
KBO( :, 3,33,15) = (/&
&7.1044E+01_JPRB,6.1877E+01_JPRB,5.4099E+01_JPRB,4.6243E+01_JPRB,5.0861E+01_JPRB/)
KBO( :, 4,33,15) = (/&
&8.3385E+01_JPRB,7.2754E+01_JPRB,6.3738E+01_JPRB,5.5225E+01_JPRB,6.2072E+01_JPRB/)
KBO( :, 5,33,15) = (/&
&9.6014E+01_JPRB,8.3965E+01_JPRB,7.3665E+01_JPRB,6.4932E+01_JPRB,7.4660E+01_JPRB/)
KBO( :, 1,34,15) = (/&
&5.1672E+01_JPRB,4.4907E+01_JPRB,3.9052E+01_JPRB,3.2559E+01_JPRB,3.4150E+01_JPRB/)
KBO( :, 2,34,15) = (/&
&6.3066E+01_JPRB,5.4942E+01_JPRB,4.7932E+01_JPRB,4.0320E+01_JPRB,4.3137E+01_JPRB/)
KBO( :, 3,34,15) = (/&
&7.5181E+01_JPRB,6.5586E+01_JPRB,5.7376E+01_JPRB,4.8848E+01_JPRB,5.3416E+01_JPRB/)
KBO( :, 4,34,15) = (/&
&8.7786E+01_JPRB,7.6718E+01_JPRB,6.7237E+01_JPRB,5.8022E+01_JPRB,6.4986E+01_JPRB/)
KBO( :, 5,34,15) = (/&
&1.0062E+02_JPRB,8.8122E+01_JPRB,7.7322E+01_JPRB,6.7972E+01_JPRB,7.7968E+01_JPRB/)
KBO( :, 1,35,15) = (/&
&5.3974E+01_JPRB,4.7010E+01_JPRB,4.0914E+01_JPRB,3.3953E+01_JPRB,3.5284E+01_JPRB/)
KBO( :, 2,35,15) = (/&
&6.5632E+01_JPRB,5.7261E+01_JPRB,4.9986E+01_JPRB,4.1880E+01_JPRB,4.4477E+01_JPRB/)
KBO( :, 3,35,15) = (/&
&7.7983E+01_JPRB,6.8108E+01_JPRB,5.9607E+01_JPRB,5.0554E+01_JPRB,5.4966E+01_JPRB/)
KBO( :, 4,35,15) = (/&
&9.0774E+01_JPRB,7.9423E+01_JPRB,6.9615E+01_JPRB,5.9856E+01_JPRB,6.6747E+01_JPRB/)
KBO( :, 5,35,15) = (/&
&1.0376E+02_JPRB,9.0958E+01_JPRB,7.9827E+01_JPRB,6.9953E+01_JPRB,7.9975E+01_JPRB/)
KBO( :, 1,36,15) = (/&
&5.4952E+01_JPRB,4.7928E+01_JPRB,4.1728E+01_JPRB,3.4482E+01_JPRB,3.5497E+01_JPRB/)
KBO( :, 2,36,15) = (/&
&6.6748E+01_JPRB,5.8304E+01_JPRB,5.0900E+01_JPRB,4.2469E+01_JPRB,4.4743E+01_JPRB/)
KBO( :, 3,36,15) = (/&
&7.9237E+01_JPRB,6.9268E+01_JPRB,6.0630E+01_JPRB,5.1203E+01_JPRB,5.5299E+01_JPRB/)
KBO( :, 4,36,15) = (/&
&9.2160E+01_JPRB,8.0690E+01_JPRB,7.0740E+01_JPRB,6.0560E+01_JPRB,6.7150E+01_JPRB/)
KBO( :, 5,36,15) = (/&
&1.0527E+02_JPRB,9.2347E+01_JPRB,8.1033E+01_JPRB,7.0691E+01_JPRB,8.0445E+01_JPRB/)
KBO( :, 1,37,15) = (/&
&5.4077E+01_JPRB,4.7203E+01_JPRB,4.1090E+01_JPRB,3.3816E+01_JPRB,3.4402E+01_JPRB/)
KBO( :, 2,37,15) = (/&
&6.5871E+01_JPRB,5.7581E+01_JPRB,5.0256E+01_JPRB,4.1730E+01_JPRB,4.3504E+01_JPRB/)
KBO( :, 3,37,15) = (/&
&7.8394E+01_JPRB,6.8564E+01_JPRB,6.0003E+01_JPRB,5.0406E+01_JPRB,5.3919E+01_JPRB/)
KBO( :, 4,37,15) = (/&
&9.1373E+01_JPRB,8.0024E+01_JPRB,7.0155E+01_JPRB,5.9711E+01_JPRB,6.5630E+01_JPRB/)
KBO( :, 5,37,15) = (/&
&1.0457E+02_JPRB,9.1743E+01_JPRB,8.0502E+01_JPRB,6.9769E+01_JPRB,7.8764E+01_JPRB/)
KBO( :, 1,38,15) = (/&
&5.2998E+01_JPRB,4.6292E+01_JPRB,4.0284E+01_JPRB,3.3047E+01_JPRB,3.3256E+01_JPRB/)
KBO( :, 2,38,15) = (/&
&6.4758E+01_JPRB,5.6646E+01_JPRB,4.9430E+01_JPRB,4.0867E+01_JPRB,4.2193E+01_JPRB/)
KBO( :, 3,38,15) = (/&
&7.7286E+01_JPRB,6.7628E+01_JPRB,5.9170E+01_JPRB,4.9481E+01_JPRB,5.2447E+01_JPRB/)
KBO( :, 4,38,15) = (/&
&9.0295E+01_JPRB,7.9101E+01_JPRB,6.9339E+01_JPRB,5.8727E+01_JPRB,6.4002E+01_JPRB/)
KBO( :, 5,38,15) = (/&
&1.0355E+02_JPRB,9.0878E+01_JPRB,7.9733E+01_JPRB,6.8695E+01_JPRB,7.6964E+01_JPRB/)
KBO( :, 1,39,15) = (/&
&5.1838E+01_JPRB,4.5309E+01_JPRB,3.9414E+01_JPRB,3.2253E+01_JPRB,3.2133E+01_JPRB/)
KBO( :, 2,39,15) = (/&
&6.3550E+01_JPRB,5.5622E+01_JPRB,4.8527E+01_JPRB,3.9972E+01_JPRB,4.0905E+01_JPRB/)
KBO( :, 3,39,15) = (/&
&7.6056E+01_JPRB,6.6591E+01_JPRB,5.8243E+01_JPRB,4.8504E+01_JPRB,5.0987E+01_JPRB/)
KBO( :, 4,39,15) = (/&
&8.9075E+01_JPRB,7.8055E+01_JPRB,6.8422E+01_JPRB,5.7684E+01_JPRB,6.2386E+01_JPRB/)
KBO( :, 5,39,15) = (/&
&1.0239E+02_JPRB,8.9867E+01_JPRB,7.8837E+01_JPRB,6.7576E+01_JPRB,7.5172E+01_JPRB/)
KBO( :, 1,40,15) = (/&
&4.9471E+01_JPRB,4.3246E+01_JPRB,3.7591E+01_JPRB,3.0698E+01_JPRB,3.0218E+01_JPRB/)
KBO( :, 2,40,15) = (/&
&6.1032E+01_JPRB,5.3431E+01_JPRB,4.6594E+01_JPRB,3.8229E+01_JPRB,3.8702E+01_JPRB/)
KBO( :, 3,40,15) = (/&
&7.3417E+01_JPRB,6.4309E+01_JPRB,5.6223E+01_JPRB,4.6591E+01_JPRB,4.8455E+01_JPRB/)
KBO( :, 4,40,15) = (/&
&8.6398E+01_JPRB,7.5721E+01_JPRB,6.6340E+01_JPRB,5.5655E+01_JPRB,5.9567E+01_JPRB/)
KBO( :, 5,40,15) = (/&
&9.9725E+01_JPRB,8.7493E+01_JPRB,7.6754E+01_JPRB,6.5366E+01_JPRB,7.2010E+01_JPRB/)
KBO( :, 1,41,15) = (/&
&4.6940E+01_JPRB,4.1029E+01_JPRB,3.5646E+01_JPRB,2.9054E+01_JPRB,2.8252E+01_JPRB/)
KBO( :, 2,41,15) = (/&
&5.8303E+01_JPRB,5.1061E+01_JPRB,4.4488E+01_JPRB,3.6382E+01_JPRB,3.6429E+01_JPRB/)
KBO( :, 3,41,15) = (/&
&7.0545E+01_JPRB,6.1809E+01_JPRB,5.4014E+01_JPRB,4.4569E+01_JPRB,4.5866E+01_JPRB/)
KBO( :, 4,41,15) = (/&
&8.3446E+01_JPRB,7.3140E+01_JPRB,6.4053E+01_JPRB,5.3489E+01_JPRB,5.6653E+01_JPRB/)
KBO( :, 5,41,15) = (/&
&9.6762E+01_JPRB,8.4890E+01_JPRB,7.4453E+01_JPRB,6.3028E+01_JPRB,6.8762E+01_JPRB/)
KBO( :, 1,42,15) = (/&
&4.4400E+01_JPRB,3.8808E+01_JPRB,3.3695E+01_JPRB,2.7433E+01_JPRB,2.6367E+01_JPRB/)
KBO( :, 2,42,15) = (/&
&5.5548E+01_JPRB,4.8653E+01_JPRB,4.2370E+01_JPRB,3.4558E+01_JPRB,3.4231E+01_JPRB/)
KBO( :, 3,42,15) = (/&
&6.7639E+01_JPRB,5.9264E+01_JPRB,5.1765E+01_JPRB,4.2548E+01_JPRB,4.3345E+01_JPRB/)
KBO( :, 4,42,15) = (/&
&8.0422E+01_JPRB,7.0505E+01_JPRB,6.1708E+01_JPRB,5.1309E+01_JPRB,5.3802E+01_JPRB/)
KBO( :, 5,42,15) = (/&
&9.3690E+01_JPRB,8.2187E+01_JPRB,7.2071E+01_JPRB,6.0692E+01_JPRB,6.5582E+01_JPRB/)
KBO( :, 1,43,15) = (/&
&4.1299E+01_JPRB,3.6086E+01_JPRB,3.1303E+01_JPRB,2.5481E+01_JPRB,2.4168E+01_JPRB/)
KBO( :, 2,43,15) = (/&
&5.2146E+01_JPRB,4.5668E+01_JPRB,3.9733E+01_JPRB,3.2349E+01_JPRB,3.1657E+01_JPRB/)
KBO( :, 3,43,15) = (/&
&6.3997E+01_JPRB,5.6104E+01_JPRB,4.8948E+01_JPRB,4.0078E+01_JPRB,4.0382E+01_JPRB/)
KBO( :, 4,43,15) = (/&
&7.6621E+01_JPRB,6.7188E+01_JPRB,5.8773E+01_JPRB,4.8617E+01_JPRB,5.0407E+01_JPRB/)
KBO( :, 5,43,15) = (/&
&8.9810E+01_JPRB,7.8771E+01_JPRB,6.9043E+01_JPRB,5.7825E+01_JPRB,6.1798E+01_JPRB/)
KBO( :, 1,44,15) = (/&
&3.8013E+01_JPRB,3.3205E+01_JPRB,2.8794E+01_JPRB,2.3425E+01_JPRB,2.1911E+01_JPRB/)
KBO( :, 2,44,15) = (/&
&4.8506E+01_JPRB,4.2466E+01_JPRB,3.6916E+01_JPRB,3.0017E+01_JPRB,2.8999E+01_JPRB/)
KBO( :, 3,44,15) = (/&
&6.0070E+01_JPRB,5.2664E+01_JPRB,4.5908E+01_JPRB,3.7464E+01_JPRB,3.7309E+01_JPRB/)
KBO( :, 4,44,15) = (/&
&7.2479E+01_JPRB,6.3560E+01_JPRB,5.5564E+01_JPRB,4.5749E+01_JPRB,4.6877E+01_JPRB/)
KBO( :, 5,44,15) = (/&
&8.5539E+01_JPRB,7.5028E+01_JPRB,6.5726E+01_JPRB,5.4770E+01_JPRB,5.7838E+01_JPRB/)
KBO( :, 1,45,15) = (/&
&3.4808E+01_JPRB,3.0429E+01_JPRB,2.6372E+01_JPRB,2.1438E+01_JPRB,1.9764E+01_JPRB/)
KBO( :, 2,45,15) = (/&
&4.4949E+01_JPRB,3.9329E+01_JPRB,3.4164E+01_JPRB,2.7759E+01_JPRB,2.6477E+01_JPRB/)
KBO( :, 3,45,15) = (/&
&5.6198E+01_JPRB,4.9271E+01_JPRB,4.2916E+01_JPRB,3.4929E+01_JPRB,3.4365E+01_JPRB/)
KBO( :, 4,45,15) = (/&
&6.8372E+01_JPRB,5.9966E+01_JPRB,5.2371E+01_JPRB,4.2948E+01_JPRB,4.3515E+01_JPRB/)
KBO( :, 5,45,15) = (/&
&8.1258E+01_JPRB,7.1280E+01_JPRB,6.2402E+01_JPRB,5.1752E+01_JPRB,5.3999E+01_JPRB/)
KBO( :, 1,46,15) = (/&
&3.1505E+01_JPRB,2.7578E+01_JPRB,2.3887E+01_JPRB,1.9401E+01_JPRB,1.7612E+01_JPRB/)
KBO( :, 2,46,15) = (/&
&4.1254E+01_JPRB,3.6080E+01_JPRB,3.1312E+01_JPRB,2.5449E+01_JPRB,2.3941E+01_JPRB/)
KBO( :, 3,46,15) = (/&
&5.2137E+01_JPRB,4.5691E+01_JPRB,3.9762E+01_JPRB,3.2315E+01_JPRB,3.1392E+01_JPRB/)
KBO( :, 4,46,15) = (/&
&6.4023E+01_JPRB,5.6167E+01_JPRB,4.8996E+01_JPRB,4.0034E+01_JPRB,4.0089E+01_JPRB/)
KBO( :, 5,46,15) = (/&
&7.6702E+01_JPRB,6.7284E+01_JPRB,5.8863E+01_JPRB,4.8569E+01_JPRB,5.0083E+01_JPRB/)
KBO( :, 1,47,15) = (/&
&2.7961E+01_JPRB,2.4503E+01_JPRB,2.1248E+01_JPRB,1.7233E+01_JPRB,1.5367E+01_JPRB/)
KBO( :, 2,47,15) = (/&
&3.7265E+01_JPRB,3.2586E+01_JPRB,2.8263E+01_JPRB,2.2963E+01_JPRB,2.1269E+01_JPRB/)
KBO( :, 3,47,15) = (/&
&4.7706E+01_JPRB,4.1783E+01_JPRB,3.6327E+01_JPRB,2.9490E+01_JPRB,2.8246E+01_JPRB/)
KBO( :, 4,47,15) = (/&
&5.9232E+01_JPRB,5.1960E+01_JPRB,4.5284E+01_JPRB,3.6873E+01_JPRB,3.6445E+01_JPRB/)
KBO( :, 5,47,15) = (/&
&7.1624E+01_JPRB,6.2836E+01_JPRB,5.4930E+01_JPRB,4.5104E+01_JPRB,4.5902E+01_JPRB/)
KBO( :, 1,48,15) = (/&
&2.4583E+01_JPRB,2.1589E+01_JPRB,1.8762E+01_JPRB,1.5191E+01_JPRB,1.3292E+01_JPRB/)
KBO( :, 2,48,15) = (/&
&3.3426E+01_JPRB,2.9268E+01_JPRB,2.5357E+01_JPRB,2.0590E+01_JPRB,1.8769E+01_JPRB/)
KBO( :, 3,48,15) = (/&
&4.3425E+01_JPRB,3.8016E+01_JPRB,3.3009E+01_JPRB,2.6800E+01_JPRB,2.5307E+01_JPRB/)
KBO( :, 4,48,15) = (/&
&5.4549E+01_JPRB,4.7838E+01_JPRB,4.1652E+01_JPRB,3.3842E+01_JPRB,3.3001E+01_JPRB/)
KBO( :, 5,48,15) = (/&
&6.6636E+01_JPRB,5.8472E+01_JPRB,5.1042E+01_JPRB,4.1740E+01_JPRB,4.1948E+01_JPRB/)
KBO( :, 1,49,15) = (/&
&2.1421E+01_JPRB,1.8843E+01_JPRB,1.6440E+01_JPRB,1.3266E+01_JPRB,1.1366E+01_JPRB/)
KBO( :, 2,49,15) = (/&
&2.9765E+01_JPRB,2.6085E+01_JPRB,2.2608E+01_JPRB,1.8340E+01_JPRB,1.6436E+01_JPRB/)
KBO( :, 3,49,15) = (/&
&3.9312E+01_JPRB,3.4398E+01_JPRB,2.9848E+01_JPRB,2.4239E+01_JPRB,2.2553E+01_JPRB/)
KBO( :, 4,49,15) = (/&
&5.0006E+01_JPRB,4.3828E+01_JPRB,3.8123E+01_JPRB,3.0941E+01_JPRB,2.9764E+01_JPRB/)
KBO( :, 5,49,15) = (/&
&6.1741E+01_JPRB,5.4182E+01_JPRB,4.7244E+01_JPRB,3.8502E+01_JPRB,3.8207E+01_JPRB/)
KBO( :, 1,50,15) = (/&
&1.8647E+01_JPRB,1.6457E+01_JPRB,1.4418E+01_JPRB,1.1591E+01_JPRB,9.7268E+00_JPRB/)
KBO( :, 2,50,15) = (/&
&2.6492E+01_JPRB,2.3254E+01_JPRB,2.0184E+01_JPRB,1.6354E+01_JPRB,1.4411E+01_JPRB/)
KBO( :, 3,50,15) = (/&
&3.5615E+01_JPRB,3.1176E+01_JPRB,2.7033E+01_JPRB,2.1940E+01_JPRB,2.0122E+01_JPRB/)
KBO( :, 4,50,15) = (/&
&4.5887E+01_JPRB,4.0194E+01_JPRB,3.4925E+01_JPRB,2.8335E+01_JPRB,2.6904E+01_JPRB/)
KBO( :, 5,50,15) = (/&
&5.7262E+01_JPRB,5.0235E+01_JPRB,4.3773E+01_JPRB,3.5576E+01_JPRB,3.4879E+01_JPRB/)
KBO( :, 1,51,15) = (/&
&1.6143E+01_JPRB,1.4306E+01_JPRB,1.2586E+01_JPRB,1.0093E+01_JPRB,8.2870E+00_JPRB/)
KBO( :, 2,51,15) = (/&
&2.3475E+01_JPRB,2.0646E+01_JPRB,1.7965E+01_JPRB,1.4527E+01_JPRB,1.2580E+01_JPRB/)
KBO( :, 3,51,15) = (/&
&3.2173E+01_JPRB,2.8191E+01_JPRB,2.4427E+01_JPRB,1.9818E+01_JPRB,1.7912E+01_JPRB/)
KBO( :, 4,51,15) = (/&
&4.2029E+01_JPRB,3.6799E+01_JPRB,3.1946E+01_JPRB,2.5931E+01_JPRB,2.4302E+01_JPRB/)
KBO( :, 5,51,15) = (/&
&5.3021E+01_JPRB,4.6505E+01_JPRB,4.0477E+01_JPRB,3.2858E+01_JPRB,3.1825E+01_JPRB/)
KBO( :, 1,52,15) = (/&
&1.3849E+01_JPRB,1.2323E+01_JPRB,1.0901E+01_JPRB,8.7257E+00_JPRB,7.0030E+00_JPRB/)
KBO( :, 2,52,15) = (/&
&2.0656E+01_JPRB,1.8194E+01_JPRB,1.5897E+01_JPRB,1.2810E+01_JPRB,1.0879E+01_JPRB/)
KBO( :, 3,52,15) = (/&
&2.8881E+01_JPRB,2.5328E+01_JPRB,2.1965E+01_JPRB,1.7806E+01_JPRB,1.5846E+01_JPRB/)
KBO( :, 4,52,15) = (/&
&3.8328E+01_JPRB,3.3546E+01_JPRB,2.9106E+01_JPRB,2.3622E+01_JPRB,2.1850E+01_JPRB/)
KBO( :, 5,52,15) = (/&
&4.8918E+01_JPRB,4.2880E+01_JPRB,3.7289E+01_JPRB,3.0246E+01_JPRB,2.8936E+01_JPRB/)
KBO( :, 1,53,15) = (/&
&1.1740E+01_JPRB,1.0506E+01_JPRB,9.3420E+00_JPRB,7.4730E+00_JPRB,5.8524E+00_JPRB/)
KBO( :, 2,53,15) = (/&
&1.8002E+01_JPRB,1.5914E+01_JPRB,1.3956E+01_JPRB,1.1210E+01_JPRB,9.3278E+00_JPRB/)
KBO( :, 3,53,15) = (/&
&2.5731E+01_JPRB,2.2607E+01_JPRB,1.9634E+01_JPRB,1.5897E+01_JPRB,1.3918E+01_JPRB/)
KBO( :, 4,53,15) = (/&
&3.4758E+01_JPRB,3.0444E+01_JPRB,2.6393E+01_JPRB,2.1412E+01_JPRB,1.9532E+01_JPRB/)
KBO( :, 5,53,15) = (/&
&4.4940E+01_JPRB,3.9367E+01_JPRB,3.4201E+01_JPRB,2.7742E+01_JPRB,2.6213E+01_JPRB/)
KBO( :, 1,54,15) = (/&
&9.9823E+00_JPRB,8.9835E+00_JPRB,8.0433E+00_JPRB,6.4217E+00_JPRB,4.9233E+00_JPRB/)
KBO( :, 2,54,15) = (/&
&1.5743E+01_JPRB,1.3968E+01_JPRB,1.2300E+01_JPRB,9.8589E+00_JPRB,8.0425E+00_JPRB/)
KBO( :, 3,54,15) = (/&
&2.2999E+01_JPRB,2.0231E+01_JPRB,1.7622E+01_JPRB,1.4237E+01_JPRB,1.2265E+01_JPRB/)
KBO( :, 4,54,15) = (/&
&3.1619E+01_JPRB,2.7721E+01_JPRB,2.4021E+01_JPRB,1.9481E+01_JPRB,1.7533E+01_JPRB/)
KBO( :, 5,54,15) = (/&
&4.1422E+01_JPRB,3.6269E+01_JPRB,3.1486E+01_JPRB,2.5548E+01_JPRB,2.3860E+01_JPRB/)
KBO( :, 1,55,15) = (/&
&8.4600E+00_JPRB,7.6587E+00_JPRB,6.9105E+00_JPRB,5.5064E+00_JPRB,4.1393E+00_JPRB/)
KBO( :, 2,55,15) = (/&
&1.3741E+01_JPRB,1.2235E+01_JPRB,1.0828E+01_JPRB,8.6641E+00_JPRB,6.9310E+00_JPRB/)
KBO( :, 3,55,15) = (/&
&2.0525E+01_JPRB,1.8089E+01_JPRB,1.5809E+01_JPRB,1.2733E+01_JPRB,1.0785E+01_JPRB/)
KBO( :, 4,55,15) = (/&
&2.8733E+01_JPRB,2.5211E+01_JPRB,2.1862E+01_JPRB,1.7718E+01_JPRB,1.5733E+01_JPRB/)
KBO( :, 5,55,15) = (/&
&3.8167E+01_JPRB,3.3414E+01_JPRB,2.8994E+01_JPRB,2.3523E+01_JPRB,2.1717E+01_JPRB/)
KBO( :, 1,56,15) = (/&
&7.0942E+00_JPRB,6.4705E+00_JPRB,5.8843E+00_JPRB,4.6820E+00_JPRB,3.4600E+00_JPRB/)
KBO( :, 2,56,15) = (/&
&1.1888E+01_JPRB,1.0638E+01_JPRB,9.4563E+00_JPRB,7.5636E+00_JPRB,5.9306E+00_JPRB/)
KBO( :, 3,56,15) = (/&
&1.8195E+01_JPRB,1.6084E+01_JPRB,1.4104E+01_JPRB,1.1328E+01_JPRB,9.4258E+00_JPRB/)
KBO( :, 4,56,15) = (/&
&2.5965E+01_JPRB,2.2816E+01_JPRB,1.9813E+01_JPRB,1.6042E+01_JPRB,1.4044E+01_JPRB/)
KBO( :, 5,56,15) = (/&
&3.5031E+01_JPRB,3.0686E+01_JPRB,2.6607E+01_JPRB,2.1582E+01_JPRB,1.9682E+01_JPRB/)
KBO( :, 1,57,15) = (/&
&5.8809E+00_JPRB,5.4073E+00_JPRB,4.9520E+00_JPRB,3.9358E+00_JPRB,2.8765E+00_JPRB/)
KBO( :, 2,57,15) = (/&
&1.0188E+01_JPRB,9.1644E+00_JPRB,8.1997E+00_JPRB,6.5476E+00_JPRB,5.0356E+00_JPRB/)
KBO( :, 3,57,15) = (/&
&1.6011E+01_JPRB,1.4204E+01_JPRB,1.2504E+01_JPRB,1.0022E+01_JPRB,8.1887E+00_JPRB/)
KBO( :, 4,57,15) = (/&
&2.3331E+01_JPRB,2.0526E+01_JPRB,1.7871E+01_JPRB,1.4443E+01_JPRB,1.2452E+01_JPRB/)
KBO( :, 5,57,15) = (/&
&3.2013E+01_JPRB,2.8066E+01_JPRB,2.4321E+01_JPRB,1.9722E+01_JPRB,1.7763E+01_JPRB/)
KBO( :, 1,58,15) = (/&
&4.8592E+00_JPRB,4.5120E+00_JPRB,4.1533E+00_JPRB,3.3050E+00_JPRB,2.4069E+00_JPRB/)
KBO( :, 2,58,15) = (/&
&8.7235E+00_JPRB,7.8898E+00_JPRB,7.1098E+00_JPRB,5.6659E+00_JPRB,4.2880E+00_JPRB/)
KBO( :, 3,58,15) = (/&
&1.4093E+01_JPRB,1.2543E+01_JPRB,1.1091E+01_JPRB,8.8788E+00_JPRB,7.1312E+00_JPRB/)
KBO( :, 4,58,15) = (/&
&2.0969E+01_JPRB,1.8473E+01_JPRB,1.6137E+01_JPRB,1.3004E+01_JPRB,1.1037E+01_JPRB/)
KBO( :, 5,58,15) = (/&
&2.9256E+01_JPRB,2.5669E+01_JPRB,2.2254E+01_JPRB,1.8039E+01_JPRB,1.6041E+01_JPRB/)
KBO( :, 1,59,15) = (/&
&4.4860E+00_JPRB,4.1832E+00_JPRB,3.8589E+00_JPRB,3.0732E+00_JPRB,2.2588E+00_JPRB/)
KBO( :, 2,59,15) = (/&
&8.1764E+00_JPRB,7.4157E+00_JPRB,6.7019E+00_JPRB,5.3375E+00_JPRB,4.0381E+00_JPRB/)
KBO( :, 3,59,15) = (/&
&1.3363E+01_JPRB,1.1913E+01_JPRB,1.0553E+01_JPRB,8.4437E+00_JPRB,6.7583E+00_JPRB/)
KBO( :, 4,59,15) = (/&
&2.0059E+01_JPRB,1.7690E+01_JPRB,1.5474E+01_JPRB,1.2453E+01_JPRB,1.0517E+01_JPRB/)
KBO( :, 5,59,15) = (/&
&2.8188E+01_JPRB,2.4740E+01_JPRB,2.1460E+01_JPRB,1.7388E+01_JPRB,1.5382E+01_JPRB/)
KBO( :, 1,13,16) = (/&
&3.5240E+00_JPRB,3.4508E+00_JPRB,6.8957E+00_JPRB,1.0310E+01_JPRB,1.3810E+01_JPRB/)
KBO( :, 2,13,16) = (/&
&5.0188E+00_JPRB,4.8884E+00_JPRB,9.7668E+00_JPRB,1.4606E+01_JPRB,1.9563E+01_JPRB/)
KBO( :, 3,13,16) = (/&
&6.8636E+00_JPRB,6.9963E+00_JPRB,1.3983E+01_JPRB,2.0917E+01_JPRB,2.7996E+01_JPRB/)
KBO( :, 4,13,16) = (/&
&8.9983E+00_JPRB,9.9231E+00_JPRB,1.9821E+01_JPRB,2.9657E+01_JPRB,3.9702E+01_JPRB/)
KBO( :, 5,13,16) = (/&
&1.1391E+01_JPRB,1.3448E+01_JPRB,2.6873E+01_JPRB,4.0197E+01_JPRB,5.3821E+01_JPRB/)
KBO( :, 1,14,16) = (/&
&4.0865E+00_JPRB,4.2627E+00_JPRB,8.5157E+00_JPRB,1.2737E+01_JPRB,1.7061E+01_JPRB/)
KBO( :, 2,14,16) = (/&
&5.9152E+00_JPRB,5.9770E+00_JPRB,1.1941E+01_JPRB,1.7861E+01_JPRB,2.3919E+01_JPRB/)
KBO( :, 3,14,16) = (/&
&8.1116E+00_JPRB,8.4946E+00_JPRB,1.6974E+01_JPRB,2.5393E+01_JPRB,3.3994E+01_JPRB/)
KBO( :, 4,14,16) = (/&
&1.0667E+01_JPRB,1.1982E+01_JPRB,2.3941E+01_JPRB,3.5820E+01_JPRB,4.7947E+01_JPRB/)
KBO( :, 5,14,16) = (/&
&1.3570E+01_JPRB,1.6166E+01_JPRB,3.2293E+01_JPRB,4.8328E+01_JPRB,6.4679E+01_JPRB/)
KBO( :, 1,15,16) = (/&
&4.9205E+00_JPRB,5.2381E+00_JPRB,1.0467E+01_JPRB,1.5657E+01_JPRB,2.0962E+01_JPRB/)
KBO( :, 2,15,16) = (/&
&7.1107E+00_JPRB,7.3251E+00_JPRB,1.4636E+01_JPRB,2.1892E+01_JPRB,2.9314E+01_JPRB/)
KBO( :, 3,15,16) = (/&
&9.7657E+00_JPRB,1.0319E+01_JPRB,2.0625E+01_JPRB,3.0857E+01_JPRB,4.1307E+01_JPRB/)
KBO( :, 4,15,16) = (/&
&1.2863E+01_JPRB,1.4348E+01_JPRB,2.8667E+01_JPRB,4.2902E+01_JPRB,5.7415E+01_JPRB/)
KBO( :, 5,15,16) = (/&
&1.6377E+01_JPRB,1.9245E+01_JPRB,3.8440E+01_JPRB,5.7530E+01_JPRB,7.7014E+01_JPRB/)
KBO( :, 1,16,16) = (/&
&6.0019E+00_JPRB,6.3755E+00_JPRB,1.2742E+01_JPRB,1.9060E+01_JPRB,2.5511E+01_JPRB/)
KBO( :, 2,16,16) = (/&
&8.6719E+00_JPRB,8.9601E+00_JPRB,1.7905E+01_JPRB,2.6782E+01_JPRB,3.5858E+01_JPRB/)
KBO( :, 3,16,16) = (/&
&1.1897E+01_JPRB,1.2494E+01_JPRB,2.4965E+01_JPRB,3.7351E+01_JPRB,5.0005E+01_JPRB/)
KBO( :, 4,16,16) = (/&
&1.5664E+01_JPRB,1.7033E+01_JPRB,3.4039E+01_JPRB,5.0943E+01_JPRB,6.8160E+01_JPRB/)
KBO( :, 5,16,16) = (/&
&1.9931E+01_JPRB,2.2609E+01_JPRB,4.5144E+01_JPRB,6.7604E+01_JPRB,9.0384E+01_JPRB/)
KBO( :, 1,17,16) = (/&
&7.3859E+00_JPRB,7.7004E+00_JPRB,1.5389E+01_JPRB,2.3023E+01_JPRB,3.0816E+01_JPRB/)
KBO( :, 2,17,16) = (/&
&1.0640E+01_JPRB,1.0863E+01_JPRB,2.1706E+01_JPRB,3.2470E+01_JPRB,4.3467E+01_JPRB/)
KBO( :, 3,17,16) = (/&
&1.4563E+01_JPRB,1.4992E+01_JPRB,2.9958E+01_JPRB,4.4824E+01_JPRB,5.9991E+01_JPRB/)
KBO( :, 4,17,16) = (/&
&1.9138E+01_JPRB,2.0152E+01_JPRB,4.0219E+01_JPRB,6.0189E+01_JPRB,8.0517E+01_JPRB/)
KBO( :, 5,17,16) = (/&
&2.4286E+01_JPRB,2.6459E+01_JPRB,5.2448E+01_JPRB,7.8504E+01_JPRB,1.0501E+02_JPRB/)
KBO( :, 1,18,16) = (/&
&9.1226E+00_JPRB,9.2597E+00_JPRB,1.8491E+01_JPRB,2.7668E+01_JPRB,3.7034E+01_JPRB/)
KBO( :, 2,18,16) = (/&
&1.3090E+01_JPRB,1.3038E+01_JPRB,2.6008E+01_JPRB,3.8923E+01_JPRB,5.2083E+01_JPRB/)
KBO( :, 3,18,16) = (/&
&1.7870E+01_JPRB,1.7862E+01_JPRB,3.5545E+01_JPRB,5.3199E+01_JPRB,7.1167E+01_JPRB/)
KBO( :, 4,18,16) = (/&
&2.3384E+01_JPRB,2.3802E+01_JPRB,4.7105E+01_JPRB,7.0494E+01_JPRB,9.4316E+01_JPRB/)
KBO( :, 5,18,16) = (/&
&2.9603E+01_JPRB,3.0959E+01_JPRB,6.0617E+01_JPRB,9.0761E+01_JPRB,1.2137E+02_JPRB/)
KBO( :, 1,19,16) = (/&
&1.1267E+01_JPRB,1.1103E+01_JPRB,2.1975E+01_JPRB,3.2891E+01_JPRB,4.4000E+01_JPRB/)
KBO( :, 2,19,16) = (/&
&1.6108E+01_JPRB,1.5588E+01_JPRB,3.0737E+01_JPRB,4.5998E+01_JPRB,6.1538E+01_JPRB/)
KBO( :, 3,19,16) = (/&
&2.1880E+01_JPRB,2.1226E+01_JPRB,4.1603E+01_JPRB,6.2286E+01_JPRB,8.3284E+01_JPRB/)
KBO( :, 4,19,16) = (/&
&2.8546E+01_JPRB,2.8063E+01_JPRB,5.4555E+01_JPRB,8.1653E+01_JPRB,1.0920E+02_JPRB/)
KBO( :, 5,19,16) = (/&
&3.6015E+01_JPRB,3.6209E+01_JPRB,6.9418E+01_JPRB,1.0398E+02_JPRB,1.3897E+02_JPRB/)
KBO( :, 1,20,16) = (/&
&1.3993E+01_JPRB,1.3379E+01_JPRB,2.5920E+01_JPRB,3.8804E+01_JPRB,5.1896E+01_JPRB/)
KBO( :, 2,20,16) = (/&
&1.9857E+01_JPRB,1.8711E+01_JPRB,3.5970E+01_JPRB,5.3858E+01_JPRB,7.2020E+01_JPRB/)
KBO( :, 3,20,16) = (/&
&2.6849E+01_JPRB,2.5309E+01_JPRB,4.8236E+01_JPRB,7.2221E+01_JPRB,9.6564E+01_JPRB/)
KBO( :, 4,20,16) = (/&
&3.4854E+01_JPRB,3.3204E+01_JPRB,6.2605E+01_JPRB,9.3754E+01_JPRB,1.2532E+02_JPRB/)
KBO( :, 5,20,16) = (/&
&4.3828E+01_JPRB,4.2464E+01_JPRB,7.8932E+01_JPRB,1.1822E+02_JPRB,1.5801E+02_JPRB/)
KBO( :, 1,21,16) = (/&
&1.7315E+01_JPRB,1.6114E+01_JPRB,3.0129E+01_JPRB,4.5115E+01_JPRB,6.0314E+01_JPRB/)
KBO( :, 2,21,16) = (/&
&2.4393E+01_JPRB,2.2395E+01_JPRB,4.1483E+01_JPRB,6.2116E+01_JPRB,8.3040E+01_JPRB/)
KBO( :, 3,21,16) = (/&
&3.2776E+01_JPRB,3.0091E+01_JPRB,5.5119E+01_JPRB,8.2559E+01_JPRB,1.1033E+02_JPRB/)
KBO( :, 4,21,16) = (/&
&4.2294E+01_JPRB,3.9176E+01_JPRB,7.0924E+01_JPRB,1.0622E+02_JPRB,1.4195E+02_JPRB/)
KBO( :, 5,21,16) = (/&
&5.3038E+01_JPRB,4.9692E+01_JPRB,8.8908E+01_JPRB,1.3317E+02_JPRB,1.7794E+02_JPRB/)
KBO( :, 1,22,16) = (/&
&2.1825E+01_JPRB,1.9779E+01_JPRB,3.5248E+01_JPRB,5.2796E+01_JPRB,7.0550E+01_JPRB/)
KBO( :, 2,22,16) = (/&
&3.0396E+01_JPRB,2.7253E+01_JPRB,4.8033E+01_JPRB,7.1948E+01_JPRB,9.6125E+01_JPRB/)
KBO( :, 3,22,16) = (/&
&4.0380E+01_JPRB,3.6230E+01_JPRB,6.3173E+01_JPRB,9.4660E+01_JPRB,1.2648E+02_JPRB/)
KBO( :, 4,22,16) = (/&
&5.1797E+01_JPRB,4.6707E+01_JPRB,8.0766E+01_JPRB,1.2099E+02_JPRB,1.6165E+02_JPRB/)
KBO( :, 5,22,16) = (/&
&6.4540E+01_JPRB,5.8724E+01_JPRB,1.0071E+02_JPRB,1.5084E+02_JPRB,2.0156E+02_JPRB/)
KBO( :, 1,23,16) = (/&
&2.7320E+01_JPRB,2.4188E+01_JPRB,4.0693E+01_JPRB,6.0960E+01_JPRB,8.1453E+01_JPRB/)
KBO( :, 2,23,16) = (/&
&3.7558E+01_JPRB,3.2976E+01_JPRB,5.4970E+01_JPRB,8.2336E+01_JPRB,1.1003E+02_JPRB/)
KBO( :, 3,23,16) = (/&
&4.9408E+01_JPRB,4.3375E+01_JPRB,7.1816E+01_JPRB,1.0759E+02_JPRB,1.4373E+02_JPRB/)
KBO( :, 4,23,16) = (/&
&6.2874E+01_JPRB,5.5353E+01_JPRB,9.1309E+01_JPRB,1.3680E+02_JPRB,1.8276E+02_JPRB/)
KBO( :, 5,23,16) = (/&
&7.7698E+01_JPRB,6.8961E+01_JPRB,1.1333E+02_JPRB,1.6978E+02_JPRB,2.2679E+02_JPRB/)
KBO( :, 1,24,16) = (/&
&3.3869E+01_JPRB,2.9387E+01_JPRB,4.6648E+01_JPRB,6.9904E+01_JPRB,9.3367E+01_JPRB/)
KBO( :, 2,24,16) = (/&
&4.6006E+01_JPRB,3.9622E+01_JPRB,6.2515E+01_JPRB,9.3679E+01_JPRB,1.2511E+02_JPRB/)
KBO( :, 3,24,16) = (/&
&5.9946E+01_JPRB,5.1571E+01_JPRB,8.1209E+01_JPRB,1.2167E+02_JPRB,1.6250E+02_JPRB/)
KBO( :, 4,24,16) = (/&
&7.5539E+01_JPRB,6.5110E+01_JPRB,1.0265E+02_JPRB,1.5380E+02_JPRB,2.0542E+02_JPRB/)
KBO( :, 5,24,16) = (/&
&9.2477E+01_JPRB,8.0448E+01_JPRB,1.2660E+02_JPRB,1.8969E+02_JPRB,2.5333E+02_JPRB/)
KBO( :, 1,25,16) = (/&
&4.1599E+01_JPRB,3.5454E+01_JPRB,5.3146E+01_JPRB,7.9642E+01_JPRB,1.0635E+02_JPRB/)
KBO( :, 2,25,16) = (/&
&5.5782E+01_JPRB,4.7228E+01_JPRB,7.0740E+01_JPRB,1.0597E+02_JPRB,1.4155E+02_JPRB/)
KBO( :, 3,25,16) = (/&
&7.1943E+01_JPRB,6.0744E+01_JPRB,9.1338E+01_JPRB,1.3688E+02_JPRB,1.8276E+02_JPRB/)
KBO( :, 4,25,16) = (/&
&8.9735E+01_JPRB,7.6043E+01_JPRB,1.1460E+02_JPRB,1.7175E+02_JPRB,2.2932E+02_JPRB/)
KBO( :, 5,25,16) = (/&
&1.0881E+02_JPRB,9.3022E+01_JPRB,1.4062E+02_JPRB,2.1079E+02_JPRB,2.8133E+02_JPRB/)
KBO( :, 1,26,16) = (/&
&5.0633E+01_JPRB,4.2540E+01_JPRB,6.0521E+01_JPRB,9.0533E+01_JPRB,1.2089E+02_JPRB/)
KBO( :, 2,26,16) = (/&
&6.7031E+01_JPRB,5.5881E+01_JPRB,7.9837E+01_JPRB,1.1964E+02_JPRB,1.5974E+02_JPRB/)
KBO( :, 3,26,16) = (/&
&8.5449E+01_JPRB,7.1046E+01_JPRB,1.0219E+02_JPRB,1.5314E+02_JPRB,2.0448E+02_JPRB/)
KBO( :, 4,26,16) = (/&
&1.0550E+02_JPRB,8.8104E+01_JPRB,1.2741E+02_JPRB,1.9092E+02_JPRB,2.5490E+02_JPRB/)
KBO( :, 5,26,16) = (/&
&1.2662E+02_JPRB,1.0665E+02_JPRB,1.5535E+02_JPRB,2.3284E+02_JPRB,3.1085E+02_JPRB/)
KBO( :, 1,27,16) = (/&
&6.0760E+01_JPRB,5.0362E+01_JPRB,6.8627E+01_JPRB,1.0214E+02_JPRB,1.3635E+02_JPRB/)
KBO( :, 2,27,16) = (/&
&7.9372E+01_JPRB,6.5351E+01_JPRB,8.9496E+01_JPRB,1.3381E+02_JPRB,1.7862E+02_JPRB/)
KBO( :, 3,27,16) = (/&
&1.0007E+02_JPRB,8.2171E+01_JPRB,1.1350E+02_JPRB,1.7014E+02_JPRB,2.2709E+02_JPRB/)
KBO( :, 4,27,16) = (/&
&1.2219E+02_JPRB,1.0086E+02_JPRB,1.4060E+02_JPRB,2.1077E+02_JPRB,2.8135E+02_JPRB/)
KBO( :, 5,27,16) = (/&
&1.4517E+02_JPRB,1.2078E+02_JPRB,1.7031E+02_JPRB,2.5527E+02_JPRB,3.4078E+02_JPRB/)
KBO( :, 1,28,16) = (/&
&7.1850E+01_JPRB,5.8865E+01_JPRB,7.7249E+01_JPRB,1.1435E+02_JPRB,1.5263E+02_JPRB/)
KBO( :, 2,28,16) = (/&
&9.2653E+01_JPRB,7.5393E+01_JPRB,9.9671E+01_JPRB,1.4851E+02_JPRB,1.9822E+02_JPRB/)
KBO( :, 3,28,16) = (/&
&1.1541E+02_JPRB,9.3821E+01_JPRB,1.2515E+02_JPRB,1.8738E+02_JPRB,2.5009E+02_JPRB/)
KBO( :, 4,28,16) = (/&
&1.3940E+02_JPRB,1.1403E+02_JPRB,1.5381E+02_JPRB,2.3053E+02_JPRB,3.0770E+02_JPRB/)
KBO( :, 5,28,16) = (/&
&1.6406E+02_JPRB,1.3517E+02_JPRB,1.8510E+02_JPRB,2.7748E+02_JPRB,3.7030E+02_JPRB/)
KBO( :, 1,29,16) = (/&
&8.3876E+01_JPRB,6.7955E+01_JPRB,8.6536E+01_JPRB,1.2716E+02_JPRB,1.6971E+02_JPRB/)
KBO( :, 2,29,16) = (/&
&1.0671E+02_JPRB,8.6050E+01_JPRB,1.1035E+02_JPRB,1.6386E+02_JPRB,2.1869E+02_JPRB/)
KBO( :, 3,29,16) = (/&
&1.3128E+02_JPRB,1.0596E+02_JPRB,1.3736E+02_JPRB,2.0522E+02_JPRB,2.7387E+02_JPRB/)
KBO( :, 4,29,16) = (/&
&1.5691E+02_JPRB,1.2750E+02_JPRB,1.6737E+02_JPRB,2.5071E+02_JPRB,3.3454E+02_JPRB/)
KBO( :, 5,29,16) = (/&
&1.8307E+02_JPRB,1.4968E+02_JPRB,1.9986E+02_JPRB,2.9963E+02_JPRB,3.9981E+02_JPRB/)
KBO( :, 1,30,16) = (/&
&9.6402E+01_JPRB,7.7403E+01_JPRB,9.6100E+01_JPRB,1.4042E+02_JPRB,1.8733E+02_JPRB/)
KBO( :, 2,30,16) = (/&
&1.2111E+02_JPRB,9.6917E+01_JPRB,1.2129E+02_JPRB,1.7953E+02_JPRB,2.3957E+02_JPRB/)
KBO( :, 3,30,16) = (/&
&1.4725E+02_JPRB,1.1830E+02_JPRB,1.4967E+02_JPRB,2.2319E+02_JPRB,2.9778E+02_JPRB/)
KBO( :, 4,30,16) = (/&
&1.7435E+02_JPRB,1.4089E+02_JPRB,1.8090E+02_JPRB,2.7076E+02_JPRB,3.6126E+02_JPRB/)
KBO( :, 5,30,16) = (/&
&2.0174E+02_JPRB,1.6391E+02_JPRB,2.1447E+02_JPRB,3.2140E+02_JPRB,4.2881E+02_JPRB/)
KBO( :, 1,31,16) = (/&
&1.0938E+02_JPRB,8.7129E+01_JPRB,1.0605E+02_JPRB,1.5425E+02_JPRB,2.0576E+02_JPRB/)
KBO( :, 2,31,16) = (/&
&1.3571E+02_JPRB,1.0800E+02_JPRB,1.3247E+02_JPRB,1.9550E+02_JPRB,2.6086E+02_JPRB/)
KBO( :, 3,31,16) = (/&
&1.6324E+02_JPRB,1.3063E+02_JPRB,1.6212E+02_JPRB,2.4122E+02_JPRB,3.2182E+02_JPRB/)
KBO( :, 4,31,16) = (/&
&1.9162E+02_JPRB,1.5412E+02_JPRB,1.9447E+02_JPRB,2.9069E+02_JPRB,3.8783E+02_JPRB/)
KBO( :, 5,31,16) = (/&
&2.1989E+02_JPRB,1.7781E+02_JPRB,2.2900E+02_JPRB,3.4301E+02_JPRB,4.5761E+02_JPRB/)
KBO( :, 1,32,16) = (/&
&1.2256E+02_JPRB,9.7067E+01_JPRB,1.1617E+02_JPRB,1.6836E+02_JPRB,2.2461E+02_JPRB/)
KBO( :, 2,32,16) = (/&
&1.5030E+02_JPRB,1.1913E+02_JPRB,1.4393E+02_JPRB,2.1170E+02_JPRB,2.8241E+02_JPRB/)
KBO( :, 3,32,16) = (/&
&1.7905E+02_JPRB,1.4279E+02_JPRB,1.7463E+02_JPRB,2.5936E+02_JPRB,3.4601E+02_JPRB/)
KBO( :, 4,32,16) = (/&
&2.0835E+02_JPRB,1.6700E+02_JPRB,2.0791E+02_JPRB,3.1047E+02_JPRB,4.1404E+02_JPRB/)
KBO( :, 5,32,16) = (/&
&2.3734E+02_JPRB,1.9118E+02_JPRB,2.4327E+02_JPRB,3.6420E+02_JPRB,4.8584E+02_JPRB/)
KBO( :, 1,33,16) = (/&
&1.3570E+02_JPRB,1.0705E+02_JPRB,1.2638E+02_JPRB,1.8277E+02_JPRB,2.4379E+02_JPRB/)
KBO( :, 2,33,16) = (/&
&1.6469E+02_JPRB,1.3015E+02_JPRB,1.5530E+02_JPRB,2.2797E+02_JPRB,3.0408E+02_JPRB/)
KBO( :, 3,33,16) = (/&
&1.9448E+02_JPRB,1.5467E+02_JPRB,1.8707E+02_JPRB,2.7733E+02_JPRB,3.6994E+02_JPRB/)
KBO( :, 4,33,16) = (/&
&2.2436E+02_JPRB,1.7936E+02_JPRB,2.2122E+02_JPRB,3.2976E+02_JPRB,4.3991E+02_JPRB/)
KBO( :, 5,33,16) = (/&
&2.5393E+02_JPRB,2.0390E+02_JPRB,2.5728E+02_JPRB,3.8487E+02_JPRB,5.1330E+02_JPRB/)
KBO( :, 1,34,16) = (/&
&1.4769E+02_JPRB,1.1615E+02_JPRB,1.3561E+02_JPRB,1.9580E+02_JPRB,2.6115E+02_JPRB/)
KBO( :, 2,34,16) = (/&
&1.7765E+02_JPRB,1.4013E+02_JPRB,1.6546E+02_JPRB,2.4255E+02_JPRB,3.2352E+02_JPRB/)
KBO( :, 3,34,16) = (/&
&2.0819E+02_JPRB,1.6522E+02_JPRB,1.9808E+02_JPRB,2.9327E+02_JPRB,3.9114E+02_JPRB/)
KBO( :, 4,34,16) = (/&
&2.3855E+02_JPRB,1.9025E+02_JPRB,2.3293E+02_JPRB,3.4692E+02_JPRB,4.6270E+02_JPRB/)
KBO( :, 5,34,16) = (/&
&2.6850E+02_JPRB,2.1503E+02_JPRB,2.6955E+02_JPRB,4.0292E+02_JPRB,5.3742E+02_JPRB/)
KBO( :, 1,35,16) = (/&
&1.5643E+02_JPRB,1.2270E+02_JPRB,1.4190E+02_JPRB,2.0436E+02_JPRB,2.7254E+02_JPRB/)
KBO( :, 2,35,16) = (/&
&1.8713E+02_JPRB,1.4730E+02_JPRB,1.7243E+02_JPRB,2.5214E+02_JPRB,3.3629E+02_JPRB/)
KBO( :, 3,35,16) = (/&
&2.1819E+02_JPRB,1.7282E+02_JPRB,2.0562E+02_JPRB,3.0372E+02_JPRB,4.0506E+02_JPRB/)
KBO( :, 4,35,16) = (/&
&2.4895E+02_JPRB,1.9814E+02_JPRB,2.4081E+02_JPRB,3.5825E+02_JPRB,4.7775E+02_JPRB/)
KBO( :, 5,35,16) = (/&
&2.7917E+02_JPRB,2.2313E+02_JPRB,2.7780E+02_JPRB,4.1495E+02_JPRB,5.5336E+02_JPRB/)
KBO( :, 1,36,16) = (/&
&1.6128E+02_JPRB,1.2623E+02_JPRB,1.4470E+02_JPRB,2.0760E+02_JPRB,2.7682E+02_JPRB/)
KBO( :, 2,36,16) = (/&
&1.9250E+02_JPRB,1.5118E+02_JPRB,1.7553E+02_JPRB,2.5587E+02_JPRB,3.4124E+02_JPRB/)
KBO( :, 3,36,16) = (/&
&2.2400E+02_JPRB,1.7706E+02_JPRB,2.0894E+02_JPRB,3.0787E+02_JPRB,4.1050E+02_JPRB/)
KBO( :, 4,36,16) = (/&
&2.5511E+02_JPRB,2.0265E+02_JPRB,2.4435E+02_JPRB,3.6281E+02_JPRB,4.8383E+02_JPRB/)
KBO( :, 5,36,16) = (/&
&2.8566E+02_JPRB,2.2781E+02_JPRB,2.8144E+02_JPRB,4.1994E+02_JPRB,5.6005E+02_JPRB/)
KBO( :, 1,37,16) = (/&
&1.6074E+02_JPRB,1.2562E+02_JPRB,1.4270E+02_JPRB,2.0342E+02_JPRB,2.7131E+02_JPRB/)
KBO( :, 2,37,16) = (/&
&1.9235E+02_JPRB,1.5069E+02_JPRB,1.7337E+02_JPRB,2.5150E+02_JPRB,3.3544E+02_JPRB/)
KBO( :, 3,37,16) = (/&
&2.2422E+02_JPRB,1.7676E+02_JPRB,2.0661E+02_JPRB,3.0337E+02_JPRB,4.0456E+02_JPRB/)
KBO( :, 4,37,16) = (/&
&2.5568E+02_JPRB,2.0266E+02_JPRB,2.4193E+02_JPRB,3.5830E+02_JPRB,4.7782E+02_JPRB/)
KBO( :, 5,37,16) = (/&
&2.8661E+02_JPRB,2.2807E+02_JPRB,2.7894E+02_JPRB,4.1548E+02_JPRB,5.5411E+02_JPRB/)
KBO( :, 1,38,16) = (/&
&1.5931E+02_JPRB,1.2434E+02_JPRB,1.4021E+02_JPRB,1.9855E+02_JPRB,2.6480E+02_JPRB/)
KBO( :, 2,38,16) = (/&
&1.9120E+02_JPRB,1.4947E+02_JPRB,1.7064E+02_JPRB,2.4634E+02_JPRB,3.2849E+02_JPRB/)
KBO( :, 3,38,16) = (/&
&2.2336E+02_JPRB,1.7568E+02_JPRB,2.0368E+02_JPRB,2.9797E+02_JPRB,3.9734E+02_JPRB/)
KBO( :, 4,38,16) = (/&
&2.5520E+02_JPRB,2.0184E+02_JPRB,2.3879E+02_JPRB,3.5282E+02_JPRB,4.7045E+02_JPRB/)
KBO( :, 5,38,16) = (/&
&2.8646E+02_JPRB,2.2749E+02_JPRB,2.7570E+02_JPRB,4.0988E+02_JPRB,5.4664E+02_JPRB/)
KBO( :, 1,39,16) = (/&
&1.5737E+02_JPRB,1.2272E+02_JPRB,1.3752E+02_JPRB,1.9347E+02_JPRB,2.5800E+02_JPRB/)
KBO( :, 2,39,16) = (/&
&1.8947E+02_JPRB,1.4785E+02_JPRB,1.6766E+02_JPRB,2.4086E+02_JPRB,3.2118E+02_JPRB/)
KBO( :, 3,39,16) = (/&
&2.2190E+02_JPRB,1.7414E+02_JPRB,2.0048E+02_JPRB,2.9227E+02_JPRB,3.8976E+02_JPRB/)
KBO( :, 4,39,16) = (/&
&2.5401E+02_JPRB,2.0054E+02_JPRB,2.3540E+02_JPRB,3.4685E+02_JPRB,4.6257E+02_JPRB/)
KBO( :, 5,39,16) = (/&
&2.8557E+02_JPRB,2.2640E+02_JPRB,2.7220E+02_JPRB,4.0387E+02_JPRB,5.3853E+02_JPRB/)
KBO( :, 1,40,16) = (/&
&1.5173E+02_JPRB,1.1834E+02_JPRB,1.3170E+02_JPRB,1.8369E+02_JPRB,2.4496E+02_JPRB/)
KBO( :, 2,40,16) = (/&
&1.8387E+02_JPRB,1.4326E+02_JPRB,1.6126E+02_JPRB,2.3014E+02_JPRB,3.0690E+02_JPRB/)
KBO( :, 3,40,16) = (/&
&2.1654E+02_JPRB,1.6951E+02_JPRB,1.9355E+02_JPRB,2.8092E+02_JPRB,3.7460E+02_JPRB/)
KBO( :, 4,40,16) = (/&
&2.4896E+02_JPRB,1.9611E+02_JPRB,2.2806E+02_JPRB,3.3490E+02_JPRB,4.4658E+02_JPRB/)
KBO( :, 5,40,16) = (/&
&2.8081E+02_JPRB,2.2225E+02_JPRB,2.6459E+02_JPRB,3.9162E+02_JPRB,5.2225E+02_JPRB/)
KBO( :, 1,41,16) = (/&
&1.4531E+02_JPRB,1.1344E+02_JPRB,1.2539E+02_JPRB,1.7342E+02_JPRB,2.3126E+02_JPRB/)
KBO( :, 2,41,16) = (/&
&1.7739E+02_JPRB,1.3804E+02_JPRB,1.5439E+02_JPRB,2.1880E+02_JPRB,2.9176E+02_JPRB/)
KBO( :, 3,41,16) = (/&
&2.1022E+02_JPRB,1.6418E+02_JPRB,1.8612E+02_JPRB,2.6873E+02_JPRB,3.5832E+02_JPRB/)
KBO( :, 4,41,16) = (/&
&2.4292E+02_JPRB,1.9086E+02_JPRB,2.2015E+02_JPRB,3.2196E+02_JPRB,4.2934E+02_JPRB/)
KBO( :, 5,41,16) = (/&
&2.7507E+02_JPRB,2.1730E+02_JPRB,2.5630E+02_JPRB,3.7839E+02_JPRB,5.0449E+02_JPRB/)
KBO( :, 1,42,16) = (/&
&1.3859E+02_JPRB,1.0832E+02_JPRB,1.1902E+02_JPRB,1.6325E+02_JPRB,2.1769E+02_JPRB/)
KBO( :, 2,42,16) = (/&
&1.7052E+02_JPRB,1.3266E+02_JPRB,1.4745E+02_JPRB,2.0749E+02_JPRB,2.7665E+02_JPRB/)
KBO( :, 3,42,16) = (/&
&2.0342E+02_JPRB,1.5859E+02_JPRB,1.7863E+02_JPRB,2.5644E+02_JPRB,3.4199E+02_JPRB/)
KBO( :, 4,42,16) = (/&
&2.3635E+02_JPRB,1.8528E+02_JPRB,2.1215E+02_JPRB,3.0913E+02_JPRB,4.1213E+02_JPRB/)
KBO( :, 5,42,16) = (/&
&2.6880E+02_JPRB,2.1197E+02_JPRB,2.4778E+02_JPRB,3.6481E+02_JPRB,4.8644E+02_JPRB/)
KBO( :, 1,43,16) = (/&
&1.3001E+02_JPRB,1.0178E+02_JPRB,1.1123E+02_JPRB,1.5100E+02_JPRB,2.0132E+02_JPRB/)
KBO( :, 2,43,16) = (/&
&1.6156E+02_JPRB,1.2573E+02_JPRB,1.3894E+02_JPRB,1.9371E+02_JPRB,2.5828E+02_JPRB/)
KBO( :, 3,43,16) = (/&
&1.9443E+02_JPRB,1.5128E+02_JPRB,1.6930E+02_JPRB,2.4134E+02_JPRB,3.2182E+02_JPRB/)
KBO( :, 4,43,16) = (/&
&2.2750E+02_JPRB,1.7792E+02_JPRB,2.0213E+02_JPRB,2.9308E+02_JPRB,3.9078E+02_JPRB/)
KBO( :, 5,43,16) = (/&
&2.6025E+02_JPRB,2.0480E+02_JPRB,2.3724E+02_JPRB,3.4798E+02_JPRB,4.6403E+02_JPRB/)
KBO( :, 1,44,16) = (/&
&1.2064E+02_JPRB,9.4696E+01_JPRB,1.0291E+02_JPRB,1.3822E+02_JPRB,1.8432E+02_JPRB/)
KBO( :, 2,44,16) = (/&
&1.5164E+02_JPRB,1.1817E+02_JPRB,1.2980E+02_JPRB,1.7913E+02_JPRB,2.3893E+02_JPRB/)
KBO( :, 3,44,16) = (/&
&1.8428E+02_JPRB,1.4322E+02_JPRB,1.5930E+02_JPRB,2.2526E+02_JPRB,3.0036E+02_JPRB/)
KBO( :, 4,44,16) = (/&
&2.1753E+02_JPRB,1.6972E+02_JPRB,1.9139E+02_JPRB,2.7583E+02_JPRB,3.6782E+02_JPRB/)
KBO( :, 5,44,16) = (/&
&2.5049E+02_JPRB,1.9666E+02_JPRB,2.2579E+02_JPRB,3.2975E+02_JPRB,4.3968E+02_JPRB/)
KBO( :, 1,45,16) = (/&
&1.1151E+02_JPRB,8.7613E+01_JPRB,9.4790E+01_JPRB,1.2608E+02_JPRB,1.6812E+02_JPRB/)
KBO( :, 2,45,16) = (/&
&1.4164E+02_JPRB,1.1057E+02_JPRB,1.2077E+02_JPRB,1.6507E+02_JPRB,2.2006E+02_JPRB/)
KBO( :, 3,45,16) = (/&
&1.7396E+02_JPRB,1.3520E+02_JPRB,1.4945E+02_JPRB,2.0958E+02_JPRB,2.7946E+02_JPRB/)
KBO( :, 4,45,16) = (/&
&2.0722E+02_JPRB,1.6134E+02_JPRB,1.8077E+02_JPRB,2.5885E+02_JPRB,3.4509E+02_JPRB/)
KBO( :, 5,45,16) = (/&
&2.4041E+02_JPRB,1.8823E+02_JPRB,2.1441E+02_JPRB,3.1179E+02_JPRB,4.1569E+02_JPRB/)
KBO( :, 1,46,16) = (/&
&1.0202E+02_JPRB,8.0263E+01_JPRB,8.6456E+01_JPRB,1.1385E+02_JPRB,1.5183E+02_JPRB/)
KBO( :, 2,46,16) = (/&
&1.3102E+02_JPRB,1.0251E+02_JPRB,1.1143E+02_JPRB,1.5058E+02_JPRB,2.0077E+02_JPRB/)
KBO( :, 3,46,16) = (/&
&1.6284E+02_JPRB,1.2664E+02_JPRB,1.3922E+02_JPRB,1.9326E+02_JPRB,2.5769E+02_JPRB/)
KBO( :, 4,46,16) = (/&
&1.9593E+02_JPRB,1.5228E+02_JPRB,1.6961E+02_JPRB,2.4101E+02_JPRB,3.2127E+02_JPRB/)
KBO( :, 5,46,16) = (/&
&2.2932E+02_JPRB,1.7911E+02_JPRB,2.0249E+02_JPRB,2.9283E+02_JPRB,3.9038E+02_JPRB/)
KBO( :, 1,47,16) = (/&
&9.1833E+01_JPRB,7.2521E+01_JPRB,7.7492E+01_JPRB,1.0107E+02_JPRB,1.3478E+02_JPRB/)
KBO( :, 2,47,16) = (/&
&1.1935E+02_JPRB,9.3639E+01_JPRB,1.0124E+02_JPRB,1.3522E+02_JPRB,1.8034E+02_JPRB/)
KBO( :, 3,47,16) = (/&
&1.5031E+02_JPRB,1.1714E+02_JPRB,1.2800E+02_JPRB,1.7568E+02_JPRB,2.3430E+02_JPRB/)
KBO( :, 4,47,16) = (/&
&1.8310E+02_JPRB,1.4216E+02_JPRB,1.5736E+02_JPRB,2.2148E+02_JPRB,2.9535E+02_JPRB/)
KBO( :, 5,47,16) = (/&
&2.1655E+02_JPRB,1.6875E+02_JPRB,1.8931E+02_JPRB,2.7187E+02_JPRB,3.6261E+02_JPRB/)
KBO( :, 1,48,16) = (/&
&8.2434E+01_JPRB,6.5271E+01_JPRB,6.9082E+01_JPRB,8.9310E+01_JPRB,1.1908E+02_JPRB/)
KBO( :, 2,48,16) = (/&
&1.0815E+02_JPRB,8.4940E+01_JPRB,9.1497E+01_JPRB,1.2085E+02_JPRB,1.6117E+02_JPRB/)
KBO( :, 3,48,16) = (/&
&1.3796E+02_JPRB,1.0775E+02_JPRB,1.1715E+02_JPRB,1.5893E+02_JPRB,2.1191E+02_JPRB/)
KBO( :, 4,48,16) = (/&
&1.7024E+02_JPRB,1.3227E+02_JPRB,1.4550E+02_JPRB,2.0275E+02_JPRB,2.7033E+02_JPRB/)
KBO( :, 5,48,16) = (/&
&2.0361E+02_JPRB,1.5829E+02_JPRB,1.7646E+02_JPRB,2.5142E+02_JPRB,3.3526E+02_JPRB/)
KBO( :, 1,49,16) = (/&
&7.3591E+01_JPRB,5.8555E+01_JPRB,6.1217E+01_JPRB,7.8585E+01_JPRB,1.0478E+02_JPRB/)
KBO( :, 2,49,16) = (/&
&9.7468E+01_JPRB,7.6787E+01_JPRB,8.2199E+01_JPRB,1.0753E+02_JPRB,1.4337E+02_JPRB/)
KBO( :, 3,49,16) = (/&
&1.2589E+02_JPRB,9.8595E+01_JPRB,1.0664E+02_JPRB,1.4299E+02_JPRB,1.9063E+02_JPRB/)
KBO( :, 4,49,16) = (/&
&1.5743E+02_JPRB,1.2250E+02_JPRB,1.3397E+02_JPRB,1.8464E+02_JPRB,2.4618E+02_JPRB/)
KBO( :, 5,49,16) = (/&
&1.9052E+02_JPRB,1.4794E+02_JPRB,1.6391E+02_JPRB,2.3149E+02_JPRB,3.0868E+02_JPRB/)
KBO( :, 1,50,16) = (/&
&6.5961E+01_JPRB,5.2638E+01_JPRB,5.4393E+01_JPRB,6.9399E+01_JPRB,9.2534E+01_JPRB/)
KBO( :, 2,50,16) = (/&
&8.8116E+01_JPRB,6.9616E+01_JPRB,7.3948E+01_JPRB,9.5883E+01_JPRB,1.2784E+02_JPRB/)
KBO( :, 3,50,16) = (/&
&1.1495E+02_JPRB,9.0222E+01_JPRB,9.7185E+01_JPRB,1.2898E+02_JPRB,1.7197E+02_JPRB/)
KBO( :, 4,50,16) = (/&
&1.4556E+02_JPRB,1.1350E+02_JPRB,1.2350E+02_JPRB,1.6846E+02_JPRB,2.2453E+02_JPRB/)
KBO( :, 5,50,16) = (/&
&1.7823E+02_JPRB,1.3839E+02_JPRB,1.5245E+02_JPRB,2.1343E+02_JPRB,2.8458E+02_JPRB/)
KBO( :, 1,51,16) = (/&
&5.9119E+01_JPRB,4.7354E+01_JPRB,4.8344E+01_JPRB,6.1204E+01_JPRB,8.1604E+01_JPRB/)
KBO( :, 2,51,16) = (/&
&7.9680E+01_JPRB,6.3168E+01_JPRB,6.6452E+01_JPRB,8.5530E+01_JPRB,1.1410E+02_JPRB/)
KBO( :, 3,51,16) = (/&
&1.0482E+02_JPRB,8.2356E+01_JPRB,8.8430E+01_JPRB,1.1623E+02_JPRB,1.5497E+02_JPRB/)
KBO( :, 4,51,16) = (/&
&1.3427E+02_JPRB,1.0494E+02_JPRB,1.1368E+02_JPRB,1.5339E+02_JPRB,2.0454E+02_JPRB/)
KBO( :, 5,51,16) = (/&
&1.6639E+02_JPRB,1.2932E+02_JPRB,1.4173E+02_JPRB,1.9652E+02_JPRB,2.6202E+02_JPRB/)
KBO( :, 1,52,16) = (/&
&5.2745E+01_JPRB,4.2467E+01_JPRB,4.2754E+01_JPRB,5.3680E+01_JPRB,7.1576E+01_JPRB/)
KBO( :, 2,52,16) = (/&
&7.1747E+01_JPRB,5.7129E+01_JPRB,5.9424E+01_JPRB,7.6073E+01_JPRB,1.0142E+02_JPRB/)
KBO( :, 3,52,16) = (/&
&9.5200E+01_JPRB,7.5047E+01_JPRB,8.0071E+01_JPRB,1.0434E+02_JPRB,1.3911E+02_JPRB/)
KBO( :, 4,52,16) = (/&
&1.2328E+02_JPRB,9.6608E+01_JPRB,1.0420E+02_JPRB,1.3918E+02_JPRB,1.8556E+02_JPRB/)
KBO( :, 5,52,16) = (/&
&1.5465E+02_JPRB,1.2039E+02_JPRB,1.3128E+02_JPRB,1.8026E+02_JPRB,2.4037E+02_JPRB/)
KBO( :, 1,53,16) = (/&
&4.6931E+01_JPRB,3.7942E+01_JPRB,3.7717E+01_JPRB,4.6873E+01_JPRB,6.2479E+01_JPRB/)
KBO( :, 2,53,16) = (/&
&6.4426E+01_JPRB,5.1434E+01_JPRB,5.2934E+01_JPRB,6.7323E+01_JPRB,8.9766E+01_JPRB/)
KBO( :, 3,53,16) = (/&
&8.6242E+01_JPRB,6.8154E+01_JPRB,7.2147E+01_JPRB,9.3266E+01_JPRB,1.2436E+02_JPRB/)
KBO( :, 4,53,16) = (/&
&1.1270E+02_JPRB,8.8425E+01_JPRB,9.5072E+01_JPRB,1.2575E+02_JPRB,1.6767E+02_JPRB/)
KBO( :, 5,53,16) = (/&
&1.4306E+02_JPRB,1.1161E+02_JPRB,1.2116E+02_JPRB,1.6465E+02_JPRB,2.1957E+02_JPRB/)
KBO( :, 1,54,16) = (/&
&4.2077E+01_JPRB,3.4169E+01_JPRB,3.3488E+01_JPRB,4.1262E+01_JPRB,5.4902E+01_JPRB/)
KBO( :, 2,54,16) = (/&
&5.8190E+01_JPRB,4.6634E+01_JPRB,4.7441E+01_JPRB,5.9915E+01_JPRB,7.9878E+01_JPRB/)
KBO( :, 3,54,16) = (/&
&7.8514E+01_JPRB,6.2282E+01_JPRB,6.5328E+01_JPRB,8.3924E+01_JPRB,1.1190E+02_JPRB/)
KBO( :, 4,54,16) = (/&
&1.0342E+02_JPRB,8.1276E+01_JPRB,8.7086E+01_JPRB,1.1420E+02_JPRB,1.5227E+02_JPRB/)
KBO( :, 5,54,16) = (/&
&1.3269E+02_JPRB,1.0372E+02_JPRB,1.1219E+02_JPRB,1.5097E+02_JPRB,2.0130E+02_JPRB/)
KBO( :, 1,55,16) = (/&
&3.7797E+01_JPRB,3.0836E+01_JPRB,2.9805E+01_JPRB,3.6383E+01_JPRB,4.8271E+01_JPRB/)
KBO( :, 2,55,16) = (/&
&5.2583E+01_JPRB,4.2337E+01_JPRB,4.2558E+01_JPRB,5.3364E+01_JPRB,7.1129E+01_JPRB/)
KBO( :, 3,55,16) = (/&
&7.1538E+01_JPRB,5.6971E+01_JPRB,5.9162E+01_JPRB,7.5653E+01_JPRB,1.0088E+02_JPRB/)
KBO( :, 4,55,16) = (/&
&9.4943E+01_JPRB,7.4845E+01_JPRB,7.9765E+01_JPRB,1.0380E+02_JPRB,1.3840E+02_JPRB/)
KBO( :, 5,55,16) = (/&
&1.2300E+02_JPRB,9.6367E+01_JPRB,1.0384E+02_JPRB,1.3854E+02_JPRB,1.8472E+02_JPRB/)
KBO( :, 1,56,16) = (/&
&3.3873E+01_JPRB,2.7740E+01_JPRB,2.6480E+01_JPRB,3.1942E+01_JPRB,4.2208E+01_JPRB/)
KBO( :, 2,56,16) = (/&
&4.7453E+01_JPRB,3.8343E+01_JPRB,3.8125E+01_JPRB,4.7379E+01_JPRB,6.3148E+01_JPRB/)
KBO( :, 3,56,16) = (/&
&6.5091E+01_JPRB,5.1940E+01_JPRB,5.3452E+01_JPRB,6.7966E+01_JPRB,9.0627E+01_JPRB/)
KBO( :, 4,56,16) = (/&
&8.7046E+01_JPRB,6.8764E+01_JPRB,7.2784E+01_JPRB,9.4072E+01_JPRB,1.2543E+02_JPRB/)
KBO( :, 5,56,16) = (/&
&1.1365E+02_JPRB,8.9173E+01_JPRB,9.5823E+01_JPRB,1.2676E+02_JPRB,1.6901E+02_JPRB/)
KBO( :, 1,57,16) = (/&
&3.0269E+01_JPRB,2.4887E+01_JPRB,2.3522E+01_JPRB,2.7966E+01_JPRB,3.6672E+01_JPRB/)
KBO( :, 2,57,16) = (/&
&4.2742E+01_JPRB,3.4680E+01_JPRB,3.4029E+01_JPRB,4.1940E+01_JPRB,5.5826E+01_JPRB/)
KBO( :, 3,57,16) = (/&
&5.9049E+01_JPRB,4.7291E+01_JPRB,4.8146E+01_JPRB,6.0813E+01_JPRB,8.1079E+01_JPRB/)
KBO( :, 4,57,16) = (/&
&7.9588E+01_JPRB,6.3092E+01_JPRB,6.6213E+01_JPRB,8.5068E+01_JPRB,1.1341E+02_JPRB/)
KBO( :, 5,57,16) = (/&
&1.0467E+02_JPRB,8.2241E+01_JPRB,8.8127E+01_JPRB,1.1561E+02_JPRB,1.5417E+02_JPRB/)
KBO( :, 1,58,16) = (/&
&2.7181E+01_JPRB,2.2407E+01_JPRB,2.1043E+01_JPRB,2.4570E+01_JPRB,3.1903E+01_JPRB/)
KBO( :, 2,58,16) = (/&
&3.8607E+01_JPRB,3.1473E+01_JPRB,3.0470E+01_JPRB,3.7255E+01_JPRB,4.9462E+01_JPRB/)
KBO( :, 3,58,16) = (/&
&5.3661E+01_JPRB,4.3166E+01_JPRB,4.3454E+01_JPRB,5.4507E+01_JPRB,7.2688E+01_JPRB/)
KBO( :, 4,58,16) = (/&
&7.2881E+01_JPRB,5.7996E+01_JPRB,6.0310E+01_JPRB,7.7125E+01_JPRB,1.0284E+02_JPRB/)
KBO( :, 5,58,16) = (/&
&9.6586E+01_JPRB,7.6089E+01_JPRB,8.1135E+01_JPRB,1.0566E+02_JPRB,1.4091E+02_JPRB/)
KBO( :, 1,59,16) = (/&
&2.6031E+01_JPRB,2.1482E+01_JPRB,2.0126E+01_JPRB,2.3303E+01_JPRB,3.0129E+01_JPRB/)
KBO( :, 2,59,16) = (/&
&3.7063E+01_JPRB,3.0259E+01_JPRB,2.9150E+01_JPRB,3.5486E+01_JPRB,4.7064E+01_JPRB/)
KBO( :, 3,59,16) = (/&
&5.1630E+01_JPRB,4.1596E+01_JPRB,4.1690E+01_JPRB,5.2144E+01_JPRB,6.9539E+01_JPRB/)
KBO( :, 4,59,16) = (/&
&7.0350E+01_JPRB,5.6032E+01_JPRB,5.8043E+01_JPRB,7.4115E+01_JPRB,9.8842E+01_JPRB/)
KBO( :, 5,59,16) = (/&
&9.3474E+01_JPRB,7.3716E+01_JPRB,7.8416E+01_JPRB,1.0186E+02_JPRB,1.3581E+02_JPRB/)


!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
&5.10286E-01_JPRB, 4.30424E-01_JPRB, 3.63061E-01_JPRB, 3.06241E-01_JPRB, 2.58313E-01_JPRB,&
&2.17886E-01_JPRB, 1.83786E-01_JPRB, 1.55023E-01_JPRB, 1.30761E-01_JPRB, 1.10297E-01_JPRB/)
SELFREFO( :, 2) = (/&
&4.96777E-01_JPRB, 4.30758E-01_JPRB, 3.73512E-01_JPRB, 3.23874E-01_JPRB, 2.80833E-01_JPRB,&
&2.43512E-01_JPRB, 2.11150E-01_JPRB, 1.83089E-01_JPRB, 1.58758E-01_JPRB, 1.37659E-01_JPRB/)
SELFREFO( :, 3) = (/&
&4.65595E-01_JPRB, 4.04778E-01_JPRB, 3.51905E-01_JPRB, 3.05939E-01_JPRB, 2.65976E-01_JPRB,&
&2.31234E-01_JPRB, 2.01030E-01_JPRB, 1.74771E-01_JPRB, 1.51942E-01_JPRB, 1.32095E-01_JPRB/)
SELFREFO( :, 4) = (/&
&4.34629E-01_JPRB, 3.86709E-01_JPRB, 3.44073E-01_JPRB, 3.06137E-01_JPRB, 2.72384E-01_JPRB,&
&2.42353E-01_JPRB, 2.15633E-01_JPRB, 1.91858E-01_JPRB, 1.70705E-01_JPRB, 1.51884E-01_JPRB/)
SELFREFO( :, 5) = (/&
&4.17625E-01_JPRB, 3.75442E-01_JPRB, 3.37519E-01_JPRB, 3.03427E-01_JPRB, 2.72778E-01_JPRB,&
&2.45225E-01_JPRB, 2.20456E-01_JPRB, 1.98188E-01_JPRB, 1.78169E-01_JPRB, 1.60173E-01_JPRB/)
SELFREFO( :, 6) = (/&
&3.97412E-01_JPRB, 3.61249E-01_JPRB, 3.28376E-01_JPRB, 2.98494E-01_JPRB, 2.71332E-01_JPRB,&
&2.46641E-01_JPRB, 2.24198E-01_JPRB, 2.03796E-01_JPRB, 1.85251E-01_JPRB, 1.68394E-01_JPRB/)
SELFREFO( :, 7) = (/&
&3.89795E-01_JPRB, 3.56178E-01_JPRB, 3.25460E-01_JPRB, 2.97391E-01_JPRB, 2.71743E-01_JPRB,&
&2.48307E-01_JPRB, 2.26892E-01_JPRB, 2.07324E-01_JPRB, 1.89444E-01_JPRB, 1.73105E-01_JPRB/)
SELFREFO( :, 8) = (/&
&3.79095E-01_JPRB, 3.46828E-01_JPRB, 3.17308E-01_JPRB, 2.90301E-01_JPRB, 2.65592E-01_JPRB,&
&2.42986E-01_JPRB, 2.22305E-01_JPRB, 2.03384E-01_JPRB, 1.86073E-01_JPRB, 1.70235E-01_JPRB/)
SELFREFO( :, 9) = (/&
&3.87086E-01_JPRB, 3.53988E-01_JPRB, 3.23720E-01_JPRB, 2.96040E-01_JPRB, 2.70727E-01_JPRB,&
&2.47578E-01_JPRB, 2.26409E-01_JPRB, 2.07050E-01_JPRB, 1.89346E-01_JPRB, 1.73156E-01_JPRB/)
SELFREFO( :,10) = (/&
&4.07529E-01_JPRB, 3.71284E-01_JPRB, 3.38263E-01_JPRB, 3.08179E-01_JPRB, 2.80770E-01_JPRB,&
&2.55799E-01_JPRB, 2.33049E-01_JPRB, 2.12322E-01_JPRB, 1.93438E-01_JPRB, 1.76234E-01_JPRB/)
SELFREFO( :,11) = (/&
&4.09315E-01_JPRB, 3.74420E-01_JPRB, 3.42500E-01_JPRB, 3.13302E-01_JPRB, 2.86592E-01_JPRB,&
&2.62160E-01_JPRB, 2.39811E-01_JPRB, 2.19367E-01_JPRB, 2.00665E-01_JPRB, 1.83558E-01_JPRB/)
SELFREFO( :,12) = (/&
&3.73996E-01_JPRB, 3.51462E-01_JPRB, 3.30286E-01_JPRB, 3.10385E-01_JPRB, 2.91684E-01_JPRB,&
&2.74109E-01_JPRB, 2.57593E-01_JPRB, 2.42072E-01_JPRB, 2.27487E-01_JPRB, 2.13780E-01_JPRB/)
SELFREFO( :,13) = (/&
&4.87965E-01_JPRB, 4.44525E-01_JPRB, 4.04952E-01_JPRB, 3.68902E-01_JPRB, 3.36061E-01_JPRB,&
&3.06144E-01_JPRB, 2.78891E-01_JPRB, 2.54063E-01_JPRB, 2.31446E-01_JPRB, 2.10842E-01_JPRB/)
SELFREFO( :,14) = (/&
&5.67999E-01_JPRB, 5.03336E-01_JPRB, 4.46034E-01_JPRB, 3.95256E-01_JPRB, 3.50259E-01_JPRB,&
&3.10384E-01_JPRB, 2.75048E-01_JPRB, 2.43736E-01_JPRB, 2.15988E-01_JPRB, 1.91399E-01_JPRB/)
SELFREFO( :,15) = (/&
&5.92492E-01_JPRB, 5.27072E-01_JPRB, 4.68874E-01_JPRB, 4.17103E-01_JPRB, 3.71048E-01_JPRB,&
&3.30079E-01_JPRB, 2.93633E-01_JPRB, 2.61211E-01_JPRB, 2.32369E-01_JPRB, 2.06712E-01_JPRB/)
SELFREFO( :,16) = (/&
&5.04176E-01_JPRB, 4.64845E-01_JPRB, 4.28582E-01_JPRB, 3.95148E-01_JPRB, 3.64322E-01_JPRB,&
&3.35901E-01_JPRB, 3.09697E-01_JPRB, 2.85538E-01_JPRB, 2.63263E-01_JPRB, 2.42725E-01_JPRB/)

FRACREFAO( :, 1) = (/&
!     From P = 1053.6 mb.
    &0.15116400_JPRB,0.14875700_JPRB,0.14232300_JPRB,0.13234501_JPRB,&
    &0.11881600_JPRB,0.10224100_JPRB,0.08345580_JPRB,0.06267490_JPRB,&
    &0.04250650_JPRB,0.00462650_JPRB,0.00382259_JPRB,0.00302600_JPRB,&
    &0.00222004_JPRB,0.00141397_JPRB,0.00053379_JPRB,0.00007421_JPRB/)
FRACREFAO( :, 2) = (/&
    &0.15266000_JPRB,0.14888400_JPRB,0.14195900_JPRB,0.13179500_JPRB,&
    &0.11842700_JPRB,0.10209000_JPRB,0.08336130_JPRB,0.06264370_JPRB,&
    &0.04247660_JPRB,0.00461946_JPRB,0.00381536_JPRB,0.00302601_JPRB,&
    &0.00222004_JPRB,0.00141397_JPRB,0.00053302_JPRB,0.00007498_JPRB/)
FRACREFAO( :, 3) = (/&
    &0.15282799_JPRB,0.14903000_JPRB,0.14192399_JPRB,0.13174300_JPRB,&
    &0.11835300_JPRB,0.10202700_JPRB,0.08329830_JPRB,0.06264830_JPRB,&
    &0.04246910_JPRB,0.00460242_JPRB,0.00381904_JPRB,0.00301573_JPRB,&
    &0.00222004_JPRB,0.00141397_JPRB,0.00053379_JPRB,0.00007421_JPRB/)
FRACREFAO( :, 4) = (/&
    &0.15298399_JPRB,0.14902800_JPRB,0.14193401_JPRB,0.13173500_JPRB,&
    &0.11833300_JPRB,0.10195800_JPRB,0.08324730_JPRB,0.06264770_JPRB,&
    &0.04246490_JPRB,0.00460489_JPRB,0.00381123_JPRB,0.00301893_JPRB,&
    &0.00221093_JPRB,0.00141397_JPRB,0.00053379_JPRB,0.00007421_JPRB/)
FRACREFAO( :, 5) = (/&
    &0.15307599_JPRB,0.14907201_JPRB,0.14198899_JPRB,0.13169800_JPRB,&
    &0.11827300_JPRB,0.10192300_JPRB,0.08321600_JPRB,0.06263490_JPRB,&
    &0.04245600_JPRB,0.00460846_JPRB,0.00380836_JPRB,0.00301663_JPRB,&
    &0.00221402_JPRB,0.00141167_JPRB,0.00052807_JPRB,0.00007376_JPRB/)
FRACREFAO( :, 6) = (/&
    &0.15311401_JPRB,0.14915401_JPRB,0.14207301_JPRB,0.13167299_JPRB,&
    &0.11819300_JPRB,0.10188900_JPRB,0.08318760_JPRB,0.06261960_JPRB,&
    &0.04243890_JPRB,0.00461584_JPRB,0.00380929_JPRB,0.00300815_JPRB,&
    &0.00221736_JPRB,0.00140588_JPRB,0.00052776_JPRB,0.00007376_JPRB/)
FRACREFAO( :, 7) = (/&
    &0.15316001_JPRB,0.14925499_JPRB,0.14213000_JPRB,0.13170999_JPRB,&
    &0.11807700_JPRB,0.10181400_JPRB,0.08317400_JPRB,0.06260300_JPRB,&
    &0.04242720_JPRB,0.00461520_JPRB,0.00381381_JPRB,0.00301285_JPRB,&
    &0.00220275_JPRB,0.00140371_JPRB,0.00052776_JPRB,0.00007376_JPRB/)
FRACREFAO( :, 8) = (/&
    &0.15321200_JPRB,0.14940999_JPRB,0.14222500_JPRB,0.13164200_JPRB,&
    &0.11798200_JPRB,0.10174500_JPRB,0.08317500_JPRB,0.06253640_JPRB,&
    &0.04243130_JPRB,0.00461724_JPRB,0.00381534_JPRB,0.00300320_JPRB,&
    &0.00220091_JPRB,0.00140364_JPRB,0.00052852_JPRB,0.00007300_JPRB/)
FRACREFAO( :, 9) = (/&
    &0.15312800_JPRB,0.14973100_JPRB,0.14234400_JPRB,0.13168900_JPRB,&
    &0.11795200_JPRB,0.10156100_JPRB,0.08302990_JPRB,0.06252240_JPRB,&
    &0.04240980_JPRB,0.00461035_JPRB,0.00381381_JPRB,0.00300176_JPRB,&
    &0.00220160_JPRB,0.00140284_JPRB,0.00052774_JPRB,0.00007376_JPRB/)
FRACREFAO( :,10) = (/&
    &0.15292500_JPRB,0.14978001_JPRB,0.14242400_JPRB,0.13172600_JPRB,&
    &0.11798800_JPRB,0.10156400_JPRB,0.08303050_JPRB,0.06251670_JPRB,&
    &0.04240970_JPRB,0.00461302_JPRB,0.00381452_JPRB,0.00300250_JPRB,&
    &0.00220126_JPRB,0.00140324_JPRB,0.00052850_JPRB,0.00007300_JPRB/)

FRACREFBO( :, 1) = (/&
!     From P = 64.1 mb.
    &0.16340201_JPRB,0.15607700_JPRB,0.14601400_JPRB,0.13182700_JPRB,&
    &0.11524700_JPRB,0.09666570_JPRB,0.07825360_JPRB,0.05849780_JPRB,&
    &0.03949650_JPRB,0.00427980_JPRB,0.00353719_JPRB,0.00279303_JPRB,&
    &0.00204788_JPRB,0.00130139_JPRB,0.00049055_JPRB,0.00006904_JPRB/)
FRACREFBO( :, 2) = (/&
    &0.15762900_JPRB,0.15494700_JPRB,0.14659800_JPRB,0.13267800_JPRB,&
    &0.11562700_JPRB,0.09838360_JPRB,0.07930420_JPRB,0.05962700_JPRB,&
    &0.04036360_JPRB,0.00438053_JPRB,0.00361463_JPRB,0.00285723_JPRB,&
    &0.00208345_JPRB,0.00132135_JPRB,0.00050528_JPRB,0.00008003_JPRB/)
FRACREFBO( :, 3) = (/&
    &0.15641500_JPRB,0.15394500_JPRB,0.14633600_JPRB,0.13180400_JPRB,&
    &0.11617100_JPRB,0.09924170_JPRB,0.08000510_JPRB,0.06021420_JPRB,&
    &0.04082730_JPRB,0.00441694_JPRB,0.00365364_JPRB,0.00287723_JPRB,&
    &0.00210914_JPRB,0.00135784_JPRB,0.00054651_JPRB,0.00008003_JPRB/)
FRACREFBO( :, 4) = (/&
    &0.15482700_JPRB,0.15286300_JPRB,0.14392500_JPRB,0.13244100_JPRB,&
    &0.11712000_JPRB,0.09994920_JPRB,0.08119200_JPRB,0.06104360_JPRB,&
    &0.04135600_JPRB,0.00446685_JPRB,0.00368377_JPRB,0.00290767_JPRB,&
    &0.00215445_JPRB,0.00142865_JPRB,0.00056142_JPRB,0.00008003_JPRB/)
FRACREFBO( :, 5) = (/&
    &0.15975100_JPRB,0.15653500_JPRB,0.14214399_JPRB,0.12892200_JPRB,&
    &0.11508400_JPRB,0.09906020_JPRB,0.08087940_JPRB,0.06078190_JPRB,&
    &0.04140530_JPRB,0.00452724_JPRB,0.00374558_JPRB,0.00295328_JPRB,&
    &0.00218509_JPRB,0.00138644_JPRB,0.00056018_JPRB,0.00008003_JPRB/)

!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB3
