!OCL SCALAR
SUBROUTINE RRTM_KGB12

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 12:  1800-2080 cm-1 (low - H2O,CO2; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF

!     ------------------------------------------------------------------

#include "tsmbkind.h"

USE YOERRTO12, ONLY : KAO     ,SELFREFO   ,FRACREFAO
USE YOERRTA12, ONLY : STRRAT

!     ------------------------------------------------------------------


IMPLICIT NONE
STRRAT = 0.009736757_JPRB

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 1) = (/&
&1.1071E-04_JPRB,1.7190E-03_JPRB,2.1297E-03_JPRB,2.2974E-03_JPRB,2.3638E-03_JPRB,2.3377E-03_JPRB,&
&2.2182E-03_JPRB,1.9598E-03_JPRB,6.0644E-04_JPRB/)
KAO( :, 2, 1, 1) = (/&
&1.1961E-04_JPRB,1.8523E-03_JPRB,2.3139E-03_JPRB,2.5087E-03_JPRB,2.5832E-03_JPRB,2.5507E-03_JPRB,&
&2.4226E-03_JPRB,2.1400E-03_JPRB,6.6787E-04_JPRB/)
KAO( :, 3, 1, 1) = (/&
&1.2897E-04_JPRB,1.9814E-03_JPRB,2.4904E-03_JPRB,2.7224E-03_JPRB,2.7992E-03_JPRB,2.7616E-03_JPRB,&
&2.6285E-03_JPRB,2.3297E-03_JPRB,7.4226E-04_JPRB/)
KAO( :, 4, 1, 1) = (/&
&1.3900E-04_JPRB,2.1069E-03_JPRB,2.6619E-03_JPRB,2.9256E-03_JPRB,3.0085E-03_JPRB,2.9760E-03_JPRB,&
&2.8383E-03_JPRB,2.5269E-03_JPRB,8.2019E-04_JPRB/)
KAO( :, 5, 1, 1) = (/&
&1.4980E-04_JPRB,2.2307E-03_JPRB,2.8258E-03_JPRB,3.1153E-03_JPRB,3.2140E-03_JPRB,3.1919E-03_JPRB,&
&3.0529E-03_JPRB,2.7312E-03_JPRB,9.0306E-04_JPRB/)
KAO( :, 1, 2, 1) = (/&
&9.5033E-05_JPRB,1.3952E-03_JPRB,1.7345E-03_JPRB,1.8757E-03_JPRB,1.9301E-03_JPRB,1.9088E-03_JPRB,&
&1.8109E-03_JPRB,1.6003E-03_JPRB,4.8147E-04_JPRB/)
KAO( :, 2, 2, 1) = (/&
&1.0264E-04_JPRB,1.5043E-03_JPRB,1.8862E-03_JPRB,2.0524E-03_JPRB,2.1155E-03_JPRB,2.0891E-03_JPRB,&
&1.9828E-03_JPRB,1.7518E-03_JPRB,5.3179E-04_JPRB/)
KAO( :, 3, 2, 1) = (/&
&1.1088E-04_JPRB,1.6110E-03_JPRB,2.0326E-03_JPRB,2.2296E-03_JPRB,2.2969E-03_JPRB,2.2672E-03_JPRB,&
&2.1565E-03_JPRB,1.9107E-03_JPRB,5.9063E-04_JPRB/)
KAO( :, 4, 2, 1) = (/&
&1.1978E-04_JPRB,1.7142E-03_JPRB,2.1747E-03_JPRB,2.4004E-03_JPRB,2.4722E-03_JPRB,2.4486E-03_JPRB,&
&2.3338E-03_JPRB,2.0762E-03_JPRB,6.5252E-04_JPRB/)
KAO( :, 5, 2, 1) = (/&
&1.2917E-04_JPRB,1.8168E-03_JPRB,2.3124E-03_JPRB,2.5589E-03_JPRB,2.6465E-03_JPRB,2.6314E-03_JPRB,&
&2.5162E-03_JPRB,2.2491E-03_JPRB,7.1928E-04_JPRB/)
KAO( :, 1, 3, 1) = (/&
&7.9672E-05_JPRB,1.1113E-03_JPRB,1.3811E-03_JPRB,1.4950E-03_JPRB,1.5396E-03_JPRB,1.5237E-03_JPRB,&
&1.4450E-03_JPRB,1.2772E-03_JPRB,3.7750E-04_JPRB/)
KAO( :, 2, 3, 1) = (/&
&8.5835E-05_JPRB,1.2012E-03_JPRB,1.5072E-03_JPRB,1.6412E-03_JPRB,1.6938E-03_JPRB,1.6765E-03_JPRB,&
&1.5878E-03_JPRB,1.4020E-03_JPRB,4.1693E-04_JPRB/)
KAO( :, 3, 3, 1) = (/&
&9.2724E-05_JPRB,1.2894E-03_JPRB,1.6284E-03_JPRB,1.7887E-03_JPRB,1.8470E-03_JPRB,1.8261E-03_JPRB,&
&1.7328E-03_JPRB,1.5335E-03_JPRB,4.6226E-04_JPRB/)
KAO( :, 4, 3, 1) = (/&
&1.0021E-04_JPRB,1.3753E-03_JPRB,1.7467E-03_JPRB,1.9334E-03_JPRB,1.9945E-03_JPRB,1.9763E-03_JPRB,&
&1.8807E-03_JPRB,1.6701E-03_JPRB,5.1131E-04_JPRB/)
KAO( :, 5, 3, 1) = (/&
&1.0826E-04_JPRB,1.4602E-03_JPRB,1.8628E-03_JPRB,2.0684E-03_JPRB,2.1410E-03_JPRB,2.1291E-03_JPRB,&
&2.0333E-03_JPRB,1.8146E-03_JPRB,5.6359E-04_JPRB/)
KAO( :, 1, 4, 1) = (/&
&6.6541E-05_JPRB,8.7720E-04_JPRB,1.0880E-03_JPRB,1.1789E-03_JPRB,1.2150E-03_JPRB,1.2040E-03_JPRB,&
&1.1429E-03_JPRB,1.0102E-03_JPRB,3.0065E-04_JPRB/)
KAO( :, 2, 4, 1) = (/&
&7.1240E-05_JPRB,9.5116E-04_JPRB,1.1928E-03_JPRB,1.2997E-03_JPRB,1.3427E-03_JPRB,1.3311E-03_JPRB,&
&1.2602E-03_JPRB,1.1118E-03_JPRB,3.3112E-04_JPRB/)
KAO( :, 3, 4, 1) = (/&
&7.6627E-05_JPRB,1.0246E-03_JPRB,1.2929E-03_JPRB,1.4214E-03_JPRB,1.4711E-03_JPRB,1.4559E-03_JPRB,&
&1.3800E-03_JPRB,1.2193E-03_JPRB,3.6623E-04_JPRB/)
KAO( :, 4, 4, 1) = (/&
&8.2697E-05_JPRB,1.0967E-03_JPRB,1.3910E-03_JPRB,1.5434E-03_JPRB,1.5957E-03_JPRB,1.5801E-03_JPRB,&
&1.5019E-03_JPRB,1.3318E-03_JPRB,4.0479E-04_JPRB/)
KAO( :, 5, 4, 1) = (/&
&8.9353E-05_JPRB,1.1675E-03_JPRB,1.4884E-03_JPRB,1.6584E-03_JPRB,1.7180E-03_JPRB,1.7064E-03_JPRB,&
&1.6273E-03_JPRB,1.4511E-03_JPRB,4.4590E-04_JPRB/)
KAO( :, 1, 5, 1) = (/&
&5.5998E-05_JPRB,6.8983E-04_JPRB,8.5274E-04_JPRB,9.2493E-04_JPRB,9.5405E-04_JPRB,9.4771E-04_JPRB,&
&9.0156E-04_JPRB,7.9782E-04_JPRB,2.4473E-04_JPRB/)
KAO( :, 2, 5, 1) = (/&
&5.9569E-05_JPRB,7.5053E-04_JPRB,9.3935E-04_JPRB,1.0247E-03_JPRB,1.0592E-03_JPRB,1.0509E-03_JPRB,&
&9.9609E-04_JPRB,8.7904E-04_JPRB,2.6874E-04_JPRB/)
KAO( :, 3, 5, 1) = (/&
&6.3728E-05_JPRB,8.1164E-04_JPRB,1.0227E-03_JPRB,1.1245E-03_JPRB,1.1656E-03_JPRB,1.1550E-03_JPRB,&
&1.0939E-03_JPRB,9.6668E-04_JPRB,2.9631E-04_JPRB/)
KAO( :, 4, 5, 1) = (/&
&6.8493E-05_JPRB,8.7191E-04_JPRB,1.1043E-03_JPRB,1.2254E-03_JPRB,1.2701E-03_JPRB,1.2575E-03_JPRB,&
&1.1938E-03_JPRB,1.0585E-03_JPRB,3.2693E-04_JPRB/)
KAO( :, 5, 5, 1) = (/&
&7.3804E-05_JPRB,9.3124E-04_JPRB,1.1858E-03_JPRB,1.3231E-03_JPRB,1.3713E-03_JPRB,1.3618E-03_JPRB,&
&1.2967E-03_JPRB,1.1556E-03_JPRB,3.5959E-04_JPRB/)
KAO( :, 1, 6, 1) = (/&
&4.7433E-05_JPRB,5.3952E-04_JPRB,6.6302E-04_JPRB,7.1941E-04_JPRB,7.4278E-04_JPRB,7.3993E-04_JPRB,&
&7.0682E-04_JPRB,6.2737E-04_JPRB,2.0502E-04_JPRB/)
KAO( :, 2, 6, 1) = (/&
&5.0194E-05_JPRB,5.8914E-04_JPRB,7.3430E-04_JPRB,8.0093E-04_JPRB,8.2839E-04_JPRB,8.2234E-04_JPRB,&
&7.8161E-04_JPRB,6.9096E-04_JPRB,2.2413E-04_JPRB/)
KAO( :, 3, 6, 1) = (/&
&5.3412E-05_JPRB,6.3967E-04_JPRB,8.0393E-04_JPRB,8.8246E-04_JPRB,9.1533E-04_JPRB,9.0872E-04_JPRB,&
&8.6111E-04_JPRB,7.6158E-04_JPRB,2.4611E-04_JPRB/)
KAO( :, 4, 6, 1) = (/&
&5.7167E-05_JPRB,6.9003E-04_JPRB,8.7186E-04_JPRB,9.6499E-04_JPRB,1.0025E-03_JPRB,9.9324E-04_JPRB,&
&9.4228E-04_JPRB,8.3524E-04_JPRB,2.7084E-04_JPRB/)
KAO( :, 5, 6, 1) = (/&
&6.1369E-05_JPRB,7.3991E-04_JPRB,9.3979E-04_JPRB,1.0473E-03_JPRB,1.0862E-03_JPRB,1.0788E-03_JPRB,&
&1.0266E-03_JPRB,9.1379E-04_JPRB,2.9720E-04_JPRB/)
KAO( :, 1, 7, 1) = (/&
&4.0204E-05_JPRB,4.2071E-04_JPRB,5.1329E-04_JPRB,5.5704E-04_JPRB,5.7598E-04_JPRB,5.7560E-04_JPRB,&
&5.5294E-04_JPRB,4.9311E-04_JPRB,1.8038E-04_JPRB/)
KAO( :, 2, 7, 1) = (/&
&4.2409E-05_JPRB,4.6139E-04_JPRB,5.7116E-04_JPRB,6.2323E-04_JPRB,6.4451E-04_JPRB,6.4096E-04_JPRB,&
&6.1142E-04_JPRB,5.4196E-04_JPRB,1.9582E-04_JPRB/)
KAO( :, 3, 7, 1) = (/&
&4.4969E-05_JPRB,5.0267E-04_JPRB,6.2911E-04_JPRB,6.8938E-04_JPRB,7.1511E-04_JPRB,7.1073E-04_JPRB,&
&6.7548E-04_JPRB,5.9790E-04_JPRB,2.1379E-04_JPRB/)
KAO( :, 4, 7, 1) = (/&
&4.7926E-05_JPRB,5.4471E-04_JPRB,6.8586E-04_JPRB,7.5653E-04_JPRB,7.8682E-04_JPRB,7.8099E-04_JPRB,&
&7.4115E-04_JPRB,6.5723E-04_JPRB,2.3382E-04_JPRB/)
KAO( :, 5, 7, 1) = (/&
&5.1304E-05_JPRB,5.8645E-04_JPRB,7.4180E-04_JPRB,8.2446E-04_JPRB,8.5674E-04_JPRB,8.5104E-04_JPRB,&
&8.0968E-04_JPRB,7.2033E-04_JPRB,2.5569E-04_JPRB/)
KAO( :, 1, 8, 1) = (/&
&3.4404E-05_JPRB,3.2742E-04_JPRB,3.9628E-04_JPRB,4.3044E-04_JPRB,4.4582E-04_JPRB,4.4750E-04_JPRB,&
&4.3255E-04_JPRB,3.8824E-04_JPRB,1.6140E-04_JPRB/)
KAO( :, 2, 8, 1) = (/&
&3.6102E-05_JPRB,3.6078E-04_JPRB,4.4317E-04_JPRB,4.8349E-04_JPRB,5.0006E-04_JPRB,4.9874E-04_JPRB,&
&4.7786E-04_JPRB,4.2529E-04_JPRB,1.7382E-04_JPRB/)
KAO( :, 3, 8, 1) = (/&
&3.8232E-05_JPRB,3.9477E-04_JPRB,4.9069E-04_JPRB,5.3712E-04_JPRB,5.5703E-04_JPRB,5.5425E-04_JPRB,&
&5.2840E-04_JPRB,4.6878E-04_JPRB,1.8872E-04_JPRB/)
KAO( :, 4, 8, 1) = (/&
&4.0723E-05_JPRB,4.2935E-04_JPRB,5.3782E-04_JPRB,5.9167E-04_JPRB,6.1513E-04_JPRB,6.1219E-04_JPRB,&
&5.8195E-04_JPRB,5.1637E-04_JPRB,2.0568E-04_JPRB/)
KAO( :, 5, 8, 1) = (/&
&4.3533E-05_JPRB,4.6405E-04_JPRB,5.8430E-04_JPRB,6.4724E-04_JPRB,6.7394E-04_JPRB,6.6968E-04_JPRB,&
&6.3735E-04_JPRB,5.6685E-04_JPRB,2.2475E-04_JPRB/)
KAO( :, 1, 9, 1) = (/&
&2.9435E-05_JPRB,2.5407E-04_JPRB,3.0513E-04_JPRB,3.3154E-04_JPRB,3.4450E-04_JPRB,3.4770E-04_JPRB,&
&3.3823E-04_JPRB,3.0612E-04_JPRB,1.4904E-04_JPRB/)
KAO( :, 2, 9, 1) = (/&
&3.0832E-05_JPRB,2.8156E-04_JPRB,3.4307E-04_JPRB,3.7395E-04_JPRB,3.8707E-04_JPRB,3.8740E-04_JPRB,&
&3.7308E-04_JPRB,3.3384E-04_JPRB,1.6021E-04_JPRB/)
KAO( :, 3, 9, 1) = (/&
&3.2541E-05_JPRB,3.0967E-04_JPRB,3.8142E-04_JPRB,4.1751E-04_JPRB,4.3262E-04_JPRB,4.3109E-04_JPRB,&
&4.1241E-04_JPRB,3.6699E-04_JPRB,1.7304E-04_JPRB/)
KAO( :, 4, 9, 1) = (/&
&3.4598E-05_JPRB,3.3815E-04_JPRB,4.2037E-04_JPRB,4.6162E-04_JPRB,4.7971E-04_JPRB,4.7802E-04_JPRB,&
&4.5577E-04_JPRB,4.0458E-04_JPRB,1.8804E-04_JPRB/)
KAO( :, 5, 9, 1) = (/&
&3.7007E-05_JPRB,3.6690E-04_JPRB,4.5921E-04_JPRB,5.0690E-04_JPRB,5.2823E-04_JPRB,5.2576E-04_JPRB,&
&5.0057E-04_JPRB,4.4491E-04_JPRB,2.0554E-04_JPRB/)
KAO( :, 1,10, 1) = (/&
&2.4927E-05_JPRB,1.9806E-04_JPRB,2.3689E-04_JPRB,2.5751E-04_JPRB,2.6867E-04_JPRB,2.7252E-04_JPRB,&
&2.6649E-04_JPRB,2.4340E-04_JPRB,1.3926E-04_JPRB/)
KAO( :, 2,10, 1) = (/&
&2.6291E-05_JPRB,2.2099E-04_JPRB,2.6740E-04_JPRB,2.9137E-04_JPRB,3.0194E-04_JPRB,3.0327E-04_JPRB,&
&2.9342E-04_JPRB,2.6414E-04_JPRB,1.4846E-04_JPRB/)
KAO( :, 3,10, 1) = (/&
&2.7951E-05_JPRB,2.4437E-04_JPRB,2.9848E-04_JPRB,3.2658E-04_JPRB,3.3827E-04_JPRB,3.3778E-04_JPRB,&
&3.2415E-04_JPRB,2.8946E-04_JPRB,1.5998E-04_JPRB/)
KAO( :, 4,10, 1) = (/&
&2.9907E-05_JPRB,2.6821E-04_JPRB,3.3026E-04_JPRB,3.6237E-04_JPRB,3.7643E-04_JPRB,3.7538E-04_JPRB,&
&3.5861E-04_JPRB,3.1891E-04_JPRB,1.7396E-04_JPRB/)
KAO( :, 5,10, 1) = (/&
&3.2074E-05_JPRB,2.9213E-04_JPRB,3.6237E-04_JPRB,3.9914E-04_JPRB,4.1580E-04_JPRB,4.1475E-04_JPRB,&
&3.9509E-04_JPRB,3.5105E-04_JPRB,1.9000E-04_JPRB/)
KAO( :, 1,11, 1) = (/&
&2.1030E-05_JPRB,1.6262E-04_JPRB,1.9497E-04_JPRB,2.1213E-04_JPRB,2.2124E-04_JPRB,2.2434E-04_JPRB,&
&2.1945E-04_JPRB,2.0056E-04_JPRB,1.1989E-04_JPRB/)
KAO( :, 2,11, 1) = (/&
&2.2215E-05_JPRB,1.8182E-04_JPRB,2.1979E-04_JPRB,2.3981E-04_JPRB,2.4860E-04_JPRB,2.4965E-04_JPRB,&
&2.4153E-04_JPRB,2.1771E-04_JPRB,1.2772E-04_JPRB/)
KAO( :, 3,11, 1) = (/&
&2.3854E-05_JPRB,2.0140E-04_JPRB,2.4523E-04_JPRB,2.6860E-04_JPRB,2.7834E-04_JPRB,2.7805E-04_JPRB,&
&2.6683E-04_JPRB,2.3853E-04_JPRB,1.3777E-04_JPRB/)
KAO( :, 4,11, 1) = (/&
&2.5937E-05_JPRB,2.2145E-04_JPRB,2.7132E-04_JPRB,2.9797E-04_JPRB,3.0980E-04_JPRB,3.0914E-04_JPRB,&
&2.9535E-04_JPRB,2.6276E-04_JPRB,1.4975E-04_JPRB/)
KAO( :, 5,11, 1) = (/&
&2.8200E-05_JPRB,2.4157E-04_JPRB,2.9784E-04_JPRB,3.2825E-04_JPRB,3.4224E-04_JPRB,3.4158E-04_JPRB,&
&3.2548E-04_JPRB,2.8921E-04_JPRB,1.6349E-04_JPRB/)
KAO( :, 1,12, 1) = (/&
&1.7436E-05_JPRB,1.3336E-04_JPRB,1.6029E-04_JPRB,1.7464E-04_JPRB,1.8206E-04_JPRB,1.8451E-04_JPRB,&
&1.8046E-04_JPRB,1.6506E-04_JPRB,9.9378E-05_JPRB/)
KAO( :, 2,12, 1) = (/&
&1.8421E-05_JPRB,1.4922E-04_JPRB,1.8056E-04_JPRB,1.9727E-04_JPRB,2.0452E-04_JPRB,2.0534E-04_JPRB,&
&1.9861E-04_JPRB,1.7923E-04_JPRB,1.0594E-04_JPRB/)
KAO( :, 3,12, 1) = (/&
&1.9770E-05_JPRB,1.6546E-04_JPRB,2.0137E-04_JPRB,2.2080E-04_JPRB,2.2895E-04_JPRB,2.2873E-04_JPRB,&
&2.1950E-04_JPRB,1.9634E-04_JPRB,1.1437E-04_JPRB/)
KAO( :, 4,12, 1) = (/&
&2.1532E-05_JPRB,1.8214E-04_JPRB,2.2278E-04_JPRB,2.4485E-04_JPRB,2.5477E-04_JPRB,2.5442E-04_JPRB,&
&2.4312E-04_JPRB,2.1633E-04_JPRB,1.2430E-04_JPRB/)
KAO( :, 5,12, 1) = (/&
&2.3665E-05_JPRB,1.9894E-04_JPRB,2.4466E-04_JPRB,2.6980E-04_JPRB,2.8155E-04_JPRB,2.8120E-04_JPRB,&
&2.6804E-04_JPRB,2.3807E-04_JPRB,1.3565E-04_JPRB/)
KAO( :, 1,13, 1) = (/&
&1.4387E-05_JPRB,1.0908E-04_JPRB,1.3157E-04_JPRB,1.4361E-04_JPRB,1.4965E-04_JPRB,1.5162E-04_JPRB,&
&1.4826E-04_JPRB,1.3570E-04_JPRB,8.1068E-05_JPRB/)
KAO( :, 2,13, 1) = (/&
&1.5222E-05_JPRB,1.2208E-04_JPRB,1.4808E-04_JPRB,1.6206E-04_JPRB,1.6806E-04_JPRB,1.6873E-04_JPRB,&
&1.6320E-04_JPRB,1.4737E-04_JPRB,8.6440E-05_JPRB/)
KAO( :, 3,13, 1) = (/&
&1.6337E-05_JPRB,1.3561E-04_JPRB,1.6504E-04_JPRB,1.8124E-04_JPRB,1.8815E-04_JPRB,1.8808E-04_JPRB,&
&1.8048E-04_JPRB,1.6146E-04_JPRB,9.3311E-05_JPRB/)
KAO( :, 4,13, 1) = (/&
&1.7783E-05_JPRB,1.4947E-04_JPRB,1.8257E-04_JPRB,2.0095E-04_JPRB,2.0933E-04_JPRB,2.0927E-04_JPRB,&
&2.0001E-04_JPRB,1.7792E-04_JPRB,1.0131E-04_JPRB/)
KAO( :, 5,13, 1) = (/&
&1.9570E-05_JPRB,1.6345E-04_JPRB,2.0062E-04_JPRB,2.2151E-04_JPRB,2.3144E-04_JPRB,2.3129E-04_JPRB,&
&2.2049E-04_JPRB,1.9577E-04_JPRB,1.1046E-04_JPRB/)
KAO( :, 1, 1, 2) = (/&
&9.2497E-04_JPRB,4.3144E-03_JPRB,5.6991E-03_JPRB,6.4942E-03_JPRB,6.8938E-03_JPRB,6.9128E-03_JPRB,&
&6.4921E-03_JPRB,5.6369E-03_JPRB,1.8483E-03_JPRB/)
KAO( :, 2, 1, 2) = (/&
&1.0409E-03_JPRB,4.6383E-03_JPRB,6.0633E-03_JPRB,6.9063E-03_JPRB,7.3169E-03_JPRB,7.3608E-03_JPRB,&
&6.9192E-03_JPRB,6.0028E-03_JPRB,2.0300E-03_JPRB/)
KAO( :, 3, 1, 2) = (/&
&1.1556E-03_JPRB,4.9764E-03_JPRB,6.4488E-03_JPRB,7.3288E-03_JPRB,7.7717E-03_JPRB,7.8279E-03_JPRB,&
&7.3748E-03_JPRB,6.3833E-03_JPRB,2.2072E-03_JPRB/)
KAO( :, 4, 1, 2) = (/&
&1.2675E-03_JPRB,5.3121E-03_JPRB,6.8537E-03_JPRB,7.7796E-03_JPRB,8.2492E-03_JPRB,8.3162E-03_JPRB,&
&7.8626E-03_JPRB,6.7865E-03_JPRB,2.3969E-03_JPRB/)
KAO( :, 5, 1, 2) = (/&
&1.3758E-03_JPRB,5.6410E-03_JPRB,7.2804E-03_JPRB,8.2553E-03_JPRB,8.7528E-03_JPRB,8.8226E-03_JPRB,&
&8.3750E-03_JPRB,7.2191E-03_JPRB,2.6089E-03_JPRB/)
KAO( :, 1, 2, 2) = (/&
&7.5186E-04_JPRB,3.6103E-03_JPRB,4.7635E-03_JPRB,5.4240E-03_JPRB,5.7535E-03_JPRB,5.7797E-03_JPRB,&
&5.4198E-03_JPRB,4.6836E-03_JPRB,1.4556E-03_JPRB/)
KAO( :, 2, 2, 2) = (/&
&8.4398E-04_JPRB,3.8877E-03_JPRB,5.0819E-03_JPRB,5.7839E-03_JPRB,6.1171E-03_JPRB,6.1580E-03_JPRB,&
&5.7873E-03_JPRB,4.9984E-03_JPRB,1.6006E-03_JPRB/)
KAO( :, 3, 2, 2) = (/&
&9.3483E-04_JPRB,4.1713E-03_JPRB,5.4170E-03_JPRB,6.1567E-03_JPRB,6.5115E-03_JPRB,6.5572E-03_JPRB,&
&6.1783E-03_JPRB,5.3232E-03_JPRB,1.7489E-03_JPRB/)
KAO( :, 4, 2, 2) = (/&
&1.0238E-03_JPRB,4.4548E-03_JPRB,5.7647E-03_JPRB,6.5444E-03_JPRB,6.9273E-03_JPRB,6.9708E-03_JPRB,&
&6.5984E-03_JPRB,5.6708E-03_JPRB,1.9109E-03_JPRB/)
KAO( :, 5, 2, 2) = (/&
&1.1107E-03_JPRB,4.7357E-03_JPRB,6.1219E-03_JPRB,6.9538E-03_JPRB,7.3658E-03_JPRB,7.4046E-03_JPRB,&
&7.0322E-03_JPRB,6.0412E-03_JPRB,2.0904E-03_JPRB/)
KAO( :, 1, 3, 2) = (/&
&6.0142E-04_JPRB,2.9523E-03_JPRB,3.9104E-03_JPRB,4.4517E-03_JPRB,4.7174E-03_JPRB,4.7372E-03_JPRB,&
&4.4492E-03_JPRB,3.8243E-03_JPRB,1.1263E-03_JPRB/)
KAO( :, 2, 3, 2) = (/&
&6.7406E-04_JPRB,3.1823E-03_JPRB,4.1811E-03_JPRB,4.7592E-03_JPRB,5.0290E-03_JPRB,5.0575E-03_JPRB,&
&4.7588E-03_JPRB,4.0940E-03_JPRB,1.2428E-03_JPRB/)
KAO( :, 3, 3, 2) = (/&
&7.4620E-04_JPRB,3.4210E-03_JPRB,4.4618E-03_JPRB,5.0793E-03_JPRB,5.3629E-03_JPRB,5.3950E-03_JPRB,&
&5.0905E-03_JPRB,4.3739E-03_JPRB,1.3657E-03_JPRB/)
KAO( :, 4, 3, 2) = (/&
&8.1752E-04_JPRB,3.6598E-03_JPRB,4.7515E-03_JPRB,5.4067E-03_JPRB,5.7176E-03_JPRB,5.7460E-03_JPRB,&
&5.4447E-03_JPRB,4.6676E-03_JPRB,1.5007E-03_JPRB/)
KAO( :, 5, 3, 2) = (/&
&8.8750E-04_JPRB,3.8967E-03_JPRB,5.0479E-03_JPRB,5.7482E-03_JPRB,6.0925E-03_JPRB,6.1154E-03_JPRB,&
&5.8092E-03_JPRB,4.9824E-03_JPRB,1.6471E-03_JPRB/)
KAO( :, 1, 4, 2) = (/&
&4.8101E-04_JPRB,2.3906E-03_JPRB,3.1853E-03_JPRB,3.6231E-03_JPRB,3.8360E-03_JPRB,3.8452E-03_JPRB,&
&3.6186E-03_JPRB,3.1019E-03_JPRB,8.7573E-04_JPRB/)
KAO( :, 2, 4, 2) = (/&
&5.3961E-04_JPRB,2.5785E-03_JPRB,3.4085E-03_JPRB,3.8820E-03_JPRB,4.0987E-03_JPRB,4.1183E-03_JPRB,&
&3.8800E-03_JPRB,3.3305E-03_JPRB,9.6932E-04_JPRB/)
KAO( :, 3, 4, 2) = (/&
&5.9799E-04_JPRB,2.7768E-03_JPRB,3.6406E-03_JPRB,4.1517E-03_JPRB,4.3797E-03_JPRB,4.4028E-03_JPRB,&
&4.1601E-03_JPRB,3.5700E-03_JPRB,1.0703E-03_JPRB/)
KAO( :, 4, 4, 2) = (/&
&6.5579E-04_JPRB,2.9752E-03_JPRB,3.8795E-03_JPRB,4.4220E-03_JPRB,4.6790E-03_JPRB,4.7001E-03_JPRB,&
&4.4581E-03_JPRB,3.8199E-03_JPRB,1.1808E-03_JPRB/)
KAO( :, 5, 4, 2) = (/&
&7.1241E-04_JPRB,3.1724E-03_JPRB,4.1257E-03_JPRB,4.7025E-03_JPRB,4.9913E-03_JPRB,5.0113E-03_JPRB,&
&4.7649E-03_JPRB,4.0844E-03_JPRB,1.3011E-03_JPRB/)
KAO( :, 1, 5, 2) = (/&
&3.7985E-04_JPRB,1.9296E-03_JPRB,2.5823E-03_JPRB,2.9367E-03_JPRB,3.1053E-03_JPRB,3.1068E-03_JPRB,&
&2.9256E-03_JPRB,2.5075E-03_JPRB,6.8590E-04_JPRB/)
KAO( :, 2, 5, 2) = (/&
&4.2774E-04_JPRB,2.0822E-03_JPRB,2.7665E-03_JPRB,3.1512E-03_JPRB,3.3261E-03_JPRB,3.3384E-03_JPRB,&
&3.1468E-03_JPRB,2.7004E-03_JPRB,7.6134E-04_JPRB/)
KAO( :, 3, 5, 2) = (/&
&4.7586E-04_JPRB,2.2442E-03_JPRB,2.9575E-03_JPRB,3.3747E-03_JPRB,3.5611E-03_JPRB,3.5804E-03_JPRB,&
&3.3851E-03_JPRB,2.9033E-03_JPRB,8.4414E-04_JPRB/)
KAO( :, 4, 5, 2) = (/&
&5.2378E-04_JPRB,2.4068E-03_JPRB,3.1534E-03_JPRB,3.5994E-03_JPRB,3.8099E-03_JPRB,3.8326E-03_JPRB,&
&3.6365E-03_JPRB,3.1178E-03_JPRB,9.3392E-04_JPRB/)
KAO( :, 5, 5, 2) = (/&
&5.7107E-04_JPRB,2.5676E-03_JPRB,3.3559E-03_JPRB,3.8294E-03_JPRB,4.0688E-03_JPRB,4.0931E-03_JPRB,&
&3.8958E-03_JPRB,3.3418E-03_JPRB,1.0329E-03_JPRB/)
KAO( :, 1, 6, 2) = (/&
&2.9735E-04_JPRB,1.5488E-03_JPRB,2.0781E-03_JPRB,2.3635E-03_JPRB,2.4968E-03_JPRB,2.4931E-03_JPRB,&
&2.3467E-03_JPRB,2.0085E-03_JPRB,5.4223E-04_JPRB/)
KAO( :, 2, 6, 2) = (/&
&3.3587E-04_JPRB,1.6709E-03_JPRB,2.2308E-03_JPRB,2.5409E-03_JPRB,2.6808E-03_JPRB,2.6895E-03_JPRB,&
&2.5340E-03_JPRB,2.1715E-03_JPRB,6.0215E-04_JPRB/)
KAO( :, 3, 6, 2) = (/&
&3.7473E-04_JPRB,1.8004E-03_JPRB,2.3875E-03_JPRB,2.7253E-03_JPRB,2.8757E-03_JPRB,2.8921E-03_JPRB,&
&2.7340E-03_JPRB,2.3415E-03_JPRB,6.6920E-04_JPRB/)
KAO( :, 4, 6, 2) = (/&
&4.1385E-04_JPRB,1.9336E-03_JPRB,2.5474E-03_JPRB,2.9106E-03_JPRB,3.0795E-03_JPRB,3.1041E-03_JPRB,&
&2.9464E-03_JPRB,2.5236E-03_JPRB,7.4227E-04_JPRB/)
KAO( :, 5, 6, 2) = (/&
&4.5282E-04_JPRB,2.0641E-03_JPRB,2.7125E-03_JPRB,3.0998E-03_JPRB,3.2937E-03_JPRB,3.3201E-03_JPRB,&
&3.1630E-03_JPRB,2.7121E-03_JPRB,8.2264E-04_JPRB/)
KAO( :, 1, 7, 2) = (/&
&2.3216E-04_JPRB,1.2362E-03_JPRB,1.6616E-03_JPRB,1.8908E-03_JPRB,1.9971E-03_JPRB,1.9905E-03_JPRB,&
&1.8720E-03_JPRB,1.5991E-03_JPRB,4.4178E-04_JPRB/)
KAO( :, 2, 7, 2) = (/&
&2.6289E-04_JPRB,1.3329E-03_JPRB,1.7891E-03_JPRB,2.0369E-03_JPRB,2.1504E-03_JPRB,2.1555E-03_JPRB,&
&2.0290E-03_JPRB,1.7365E-03_JPRB,4.9123E-04_JPRB/)
KAO( :, 3, 7, 2) = (/&
&2.9417E-04_JPRB,1.4359E-03_JPRB,1.9156E-03_JPRB,2.1896E-03_JPRB,2.3102E-03_JPRB,2.3250E-03_JPRB,&
&2.1958E-03_JPRB,1.8783E-03_JPRB,5.4688E-04_JPRB/)
KAO( :, 4, 7, 2) = (/&
&3.2585E-04_JPRB,1.5437E-03_JPRB,2.0463E-03_JPRB,2.3419E-03_JPRB,2.4777E-03_JPRB,2.4981E-03_JPRB,&
&2.3744E-03_JPRB,2.0299E-03_JPRB,6.0742E-04_JPRB/)
KAO( :, 5, 7, 2) = (/&
&3.5762E-04_JPRB,1.6504E-03_JPRB,2.1798E-03_JPRB,2.4967E-03_JPRB,2.6528E-03_JPRB,2.6762E-03_JPRB,&
&2.5533E-03_JPRB,2.1888E-03_JPRB,6.7380E-04_JPRB/)
KAO( :, 1, 8, 2) = (/&
&1.8254E-04_JPRB,9.8374E-04_JPRB,1.3243E-03_JPRB,1.5057E-03_JPRB,1.5902E-03_JPRB,1.5824E-03_JPRB,&
&1.4869E-03_JPRB,1.2665E-03_JPRB,3.9850E-04_JPRB/)
KAO( :, 2, 8, 2) = (/&
&2.0666E-04_JPRB,1.0603E-03_JPRB,1.4275E-03_JPRB,1.6259E-03_JPRB,1.7181E-03_JPRB,1.7201E-03_JPRB,&
&1.6174E-03_JPRB,1.3826E-03_JPRB,4.4169E-04_JPRB/)
KAO( :, 3, 8, 2) = (/&
&2.3157E-04_JPRB,1.1419E-03_JPRB,1.5319E-03_JPRB,1.7520E-03_JPRB,1.8487E-03_JPRB,1.8612E-03_JPRB,&
&1.7566E-03_JPRB,1.5015E-03_JPRB,4.8905E-04_JPRB/)
KAO( :, 4, 8, 2) = (/&
&2.5700E-04_JPRB,1.2278E-03_JPRB,1.6373E-03_JPRB,1.8765E-03_JPRB,1.9849E-03_JPRB,2.0014E-03_JPRB,&
&1.9031E-03_JPRB,1.6270E-03_JPRB,5.4213E-04_JPRB/)
KAO( :, 5, 8, 2) = (/&
&2.8283E-04_JPRB,1.3158E-03_JPRB,1.7450E-03_JPRB,2.0017E-03_JPRB,2.1255E-03_JPRB,2.1468E-03_JPRB,&
&2.0518E-03_JPRB,1.7597E-03_JPRB,6.0087E-04_JPRB/)
KAO( :, 1, 9, 2) = (/&
&1.4492E-04_JPRB,7.8220E-04_JPRB,1.0529E-03_JPRB,1.1948E-03_JPRB,1.2616E-03_JPRB,1.2532E-03_JPRB,&
&1.1763E-03_JPRB,9.9787E-04_JPRB,3.8271E-04_JPRB/)
KAO( :, 2, 9, 2) = (/&
&1.6385E-04_JPRB,8.4332E-04_JPRB,1.1362E-03_JPRB,1.2935E-03_JPRB,1.3677E-03_JPRB,1.3665E-03_JPRB,&
&1.2847E-03_JPRB,1.0960E-03_JPRB,4.2068E-04_JPRB/)
KAO( :, 3, 9, 2) = (/&
&1.8366E-04_JPRB,9.0787E-04_JPRB,1.2223E-03_JPRB,1.3959E-03_JPRB,1.4750E-03_JPRB,1.4839E-03_JPRB,&
&1.3993E-03_JPRB,1.1955E-03_JPRB,4.6660E-04_JPRB/)
KAO( :, 4, 9, 2) = (/&
&2.0401E-04_JPRB,9.7621E-04_JPRB,1.3079E-03_JPRB,1.4991E-03_JPRB,1.5844E-03_JPRB,1.5989E-03_JPRB,&
&1.5186E-03_JPRB,1.3000E-03_JPRB,5.2016E-04_JPRB/)
KAO( :, 5, 9, 2) = (/&
&2.2477E-04_JPRB,1.0479E-03_JPRB,1.3948E-03_JPRB,1.6006E-03_JPRB,1.6979E-03_JPRB,1.7159E-03_JPRB,&
&1.6415E-03_JPRB,1.4093E-03_JPRB,5.7816E-04_JPRB/)
KAO( :, 1,10, 2) = (/&
&1.1869E-04_JPRB,6.2671E-04_JPRB,8.4082E-04_JPRB,9.5190E-04_JPRB,1.0039E-03_JPRB,9.9693E-04_JPRB,&
&9.3504E-04_JPRB,7.8902E-04_JPRB,3.5140E-04_JPRB/)
KAO( :, 2,10, 2) = (/&
&1.3381E-04_JPRB,6.7599E-04_JPRB,9.0913E-04_JPRB,1.0332E-03_JPRB,1.0921E-03_JPRB,1.0891E-03_JPRB,&
&1.0243E-03_JPRB,8.7218E-04_JPRB,3.8763E-04_JPRB/)
KAO( :, 3,10, 2) = (/&
&1.4959E-04_JPRB,7.2765E-04_JPRB,9.7958E-04_JPRB,1.1159E-03_JPRB,1.1802E-03_JPRB,1.1859E-03_JPRB,&
&1.1183E-03_JPRB,9.5533E-04_JPRB,4.3010E-04_JPRB/)
KAO( :, 4,10, 2) = (/&
&1.6589E-04_JPRB,7.8204E-04_JPRB,1.0498E-03_JPRB,1.2013E-03_JPRB,1.2689E-03_JPRB,1.2810E-03_JPRB,&
&1.2156E-03_JPRB,1.0417E-03_JPRB,4.7716E-04_JPRB/)
KAO( :, 5,10, 2) = (/&
&1.8260E-04_JPRB,8.3938E-04_JPRB,1.1206E-03_JPRB,1.2847E-03_JPRB,1.3612E-03_JPRB,1.3753E-03_JPRB,&
&1.3161E-03_JPRB,1.1315E-03_JPRB,5.2947E-04_JPRB/)
KAO( :, 1,11, 2) = (/&
&1.0311E-04_JPRB,5.2056E-04_JPRB,6.9637E-04_JPRB,7.8750E-04_JPRB,8.3059E-04_JPRB,8.2575E-04_JPRB,&
&7.7490E-04_JPRB,6.5424E-04_JPRB,3.0281E-04_JPRB/)
KAO( :, 2,11, 2) = (/&
&1.1590E-04_JPRB,5.6136E-04_JPRB,7.5296E-04_JPRB,8.5480E-04_JPRB,9.0353E-04_JPRB,9.0216E-04_JPRB,&
&8.4999E-04_JPRB,7.2420E-04_JPRB,3.3507E-04_JPRB/)
KAO( :, 3,11, 2) = (/&
&1.2889E-04_JPRB,6.0382E-04_JPRB,8.1101E-04_JPRB,9.2302E-04_JPRB,9.7570E-04_JPRB,9.8182E-04_JPRB,&
&9.2806E-04_JPRB,7.9438E-04_JPRB,3.7284E-04_JPRB/)
KAO( :, 4,11, 2) = (/&
&1.4211E-04_JPRB,6.4818E-04_JPRB,8.6860E-04_JPRB,9.9311E-04_JPRB,1.0487E-03_JPRB,1.0592E-03_JPRB,&
&1.0081E-03_JPRB,8.6646E-04_JPRB,4.1455E-04_JPRB/)
KAO( :, 5,11, 2) = (/&
&1.5566E-04_JPRB,6.9514E-04_JPRB,9.2716E-04_JPRB,1.0621E-03_JPRB,1.1251E-03_JPRB,1.1363E-03_JPRB,&
&1.0898E-03_JPRB,9.4096E-04_JPRB,4.6093E-04_JPRB/)
KAO( :, 1,12, 2) = (/&
&8.6906E-05_JPRB,4.2943E-04_JPRB,5.7386E-04_JPRB,6.4907E-04_JPRB,6.8516E-04_JPRB,6.8236E-04_JPRB,&
&6.4150E-04_JPRB,5.4221E-04_JPRB,2.5343E-04_JPRB/)
KAO( :, 2,12, 2) = (/&
&9.7363E-05_JPRB,4.6320E-04_JPRB,6.2055E-04_JPRB,7.0430E-04_JPRB,7.4506E-04_JPRB,7.4512E-04_JPRB,&
&7.0369E-04_JPRB,6.0080E-04_JPRB,2.8076E-04_JPRB/)
KAO( :, 3,12, 2) = (/&
&1.0822E-04_JPRB,4.9810E-04_JPRB,6.6816E-04_JPRB,7.6045E-04_JPRB,8.0385E-04_JPRB,8.1033E-04_JPRB,&
&7.6791E-04_JPRB,6.5916E-04_JPRB,3.1267E-04_JPRB/)
KAO( :, 4,12, 2) = (/&
&1.1919E-04_JPRB,5.3431E-04_JPRB,7.1547E-04_JPRB,8.1798E-04_JPRB,8.6412E-04_JPRB,8.7316E-04_JPRB,&
&8.3318E-04_JPRB,7.1884E-04_JPRB,3.4804E-04_JPRB/)
KAO( :, 5,12, 2) = (/&
&1.3020E-04_JPRB,5.7282E-04_JPRB,7.6401E-04_JPRB,8.7493E-04_JPRB,9.2683E-04_JPRB,9.3624E-04_JPRB,&
&8.9962E-04_JPRB,7.8030E-04_JPRB,3.8737E-04_JPRB/)
KAO( :, 1,13, 2) = (/&
&7.2736E-05_JPRB,3.5287E-04_JPRB,4.7103E-04_JPRB,5.3285E-04_JPRB,5.6294E-04_JPRB,5.6189E-04_JPRB,&
&5.2952E-04_JPRB,4.4876E-04_JPRB,2.0844E-04_JPRB/)
KAO( :, 2,13, 2) = (/&
&8.1220E-05_JPRB,3.8092E-04_JPRB,5.0957E-04_JPRB,5.7824E-04_JPRB,6.1199E-04_JPRB,6.1315E-04_JPRB,&
&5.8053E-04_JPRB,4.9725E-04_JPRB,2.3115E-04_JPRB/)
KAO( :, 3,13, 2) = (/&
&9.0164E-05_JPRB,4.0966E-04_JPRB,5.4894E-04_JPRB,6.2460E-04_JPRB,6.6024E-04_JPRB,6.6621E-04_JPRB,&
&6.3308E-04_JPRB,5.4537E-04_JPRB,2.5750E-04_JPRB/)
KAO( :, 4,13, 2) = (/&
&9.9376E-05_JPRB,4.3939E-04_JPRB,5.8810E-04_JPRB,6.7200E-04_JPRB,7.1008E-04_JPRB,7.1773E-04_JPRB,&
&6.8617E-04_JPRB,5.9441E-04_JPRB,2.8680E-04_JPRB/)
KAO( :, 5,13, 2) = (/&
&1.0854E-04_JPRB,4.7117E-04_JPRB,6.2833E-04_JPRB,7.1918E-04_JPRB,7.6187E-04_JPRB,7.6982E-04_JPRB,&
&7.4086E-04_JPRB,6.4493E-04_JPRB,3.1932E-04_JPRB/)
KAO( :, 1, 1, 3) = (/&
&2.8268E-03_JPRB,8.0007E-03_JPRB,1.0129E-02_JPRB,1.1600E-02_JPRB,1.2484E-02_JPRB,1.2903E-02_JPRB,&
&1.2756E-02_JPRB,1.1762E-02_JPRB,4.6746E-03_JPRB/)
KAO( :, 2, 1, 3) = (/&
&3.1283E-03_JPRB,8.6463E-03_JPRB,1.0922E-02_JPRB,1.2433E-02_JPRB,1.3339E-02_JPRB,1.3730E-02_JPRB,&
&1.3558E-02_JPRB,1.2454E-02_JPRB,5.0133E-03_JPRB/)
KAO( :, 3, 1, 3) = (/&
&3.4558E-03_JPRB,9.3189E-03_JPRB,1.1784E-02_JPRB,1.3331E-02_JPRB,1.4258E-02_JPRB,1.4611E-02_JPRB,&
&1.4389E-02_JPRB,1.3149E-02_JPRB,5.3761E-03_JPRB/)
KAO( :, 4, 1, 3) = (/&
&3.8003E-03_JPRB,1.0040E-02_JPRB,1.2672E-02_JPRB,1.4281E-02_JPRB,1.5240E-02_JPRB,1.5546E-02_JPRB,&
&1.5245E-02_JPRB,1.3873E-02_JPRB,5.7489E-03_JPRB/)
KAO( :, 5, 1, 3) = (/&
&4.1364E-03_JPRB,1.0810E-02_JPRB,1.3574E-02_JPRB,1.5264E-02_JPRB,1.6259E-02_JPRB,1.6515E-02_JPRB,&
&1.6129E-02_JPRB,1.4624E-02_JPRB,6.1285E-03_JPRB/)
KAO( :, 1, 2, 3) = (/&
&2.3785E-03_JPRB,6.8111E-03_JPRB,8.5917E-03_JPRB,9.8069E-03_JPRB,1.0520E-02_JPRB,1.0823E-02_JPRB,&
&1.0667E-02_JPRB,9.8152E-03_JPRB,3.7184E-03_JPRB/)
KAO( :, 2, 2, 3) = (/&
&2.6403E-03_JPRB,7.3805E-03_JPRB,9.2734E-03_JPRB,1.0506E-02_JPRB,1.1253E-02_JPRB,1.1531E-02_JPRB,&
&1.1349E-02_JPRB,1.0403E-02_JPRB,4.0032E-03_JPRB/)
KAO( :, 3, 2, 3) = (/&
&2.9257E-03_JPRB,7.9766E-03_JPRB,1.0007E-02_JPRB,1.1267E-02_JPRB,1.2040E-02_JPRB,1.2292E-02_JPRB,&
&1.2064E-02_JPRB,1.1014E-02_JPRB,4.2975E-03_JPRB/)
KAO( :, 4, 2, 3) = (/&
&3.2219E-03_JPRB,8.6148E-03_JPRB,1.0770E-02_JPRB,1.2085E-02_JPRB,1.2878E-02_JPRB,1.3098E-02_JPRB,&
&1.2794E-02_JPRB,1.1649E-02_JPRB,4.6021E-03_JPRB/)
KAO( :, 5, 2, 3) = (/&
&3.5088E-03_JPRB,9.2842E-03_JPRB,1.1557E-02_JPRB,1.2935E-02_JPRB,1.3737E-02_JPRB,1.3940E-02_JPRB,&
&1.3572E-02_JPRB,1.2310E-02_JPRB,4.9140E-03_JPRB/)
KAO( :, 1, 3, 3) = (/&
&1.9386E-03_JPRB,5.6660E-03_JPRB,7.1297E-03_JPRB,8.1429E-03_JPRB,8.7357E-03_JPRB,8.9496E-03_JPRB,&
&8.7747E-03_JPRB,8.0582E-03_JPRB,2.9088E-03_JPRB/)
KAO( :, 2, 3, 3) = (/&
&2.1579E-03_JPRB,6.1637E-03_JPRB,7.7083E-03_JPRB,8.7254E-03_JPRB,9.3435E-03_JPRB,9.5443E-03_JPRB,&
&9.3488E-03_JPRB,8.5545E-03_JPRB,3.1389E-03_JPRB/)
KAO( :, 3, 3, 3) = (/&
&2.3960E-03_JPRB,6.6842E-03_JPRB,8.3410E-03_JPRB,9.3621E-03_JPRB,1.0004E-02_JPRB,1.0182E-02_JPRB,&
&9.9526E-03_JPRB,9.0715E-03_JPRB,3.3810E-03_JPRB/)
KAO( :, 4, 3, 3) = (/&
&2.6451E-03_JPRB,7.2345E-03_JPRB,9.0005E-03_JPRB,1.0055E-02_JPRB,1.0704E-02_JPRB,1.0864E-02_JPRB,&
&1.0573E-02_JPRB,9.6158E-03_JPRB,3.6280E-03_JPRB/)
KAO( :, 5, 3, 3) = (/&
&2.8859E-03_JPRB,7.8078E-03_JPRB,9.6814E-03_JPRB,1.0782E-02_JPRB,1.1421E-02_JPRB,1.1580E-02_JPRB,&
&1.1241E-02_JPRB,1.0187E-02_JPRB,3.8829E-03_JPRB/)
KAO( :, 1, 4, 3) = (/&
&1.5600E-03_JPRB,4.6546E-03_JPRB,5.8495E-03_JPRB,6.6996E-03_JPRB,7.2044E-03_JPRB,7.3765E-03_JPRB,&
&7.1865E-03_JPRB,6.5682E-03_JPRB,2.2826E-03_JPRB/)
KAO( :, 2, 4, 3) = (/&
&1.7367E-03_JPRB,5.0823E-03_JPRB,6.3406E-03_JPRB,7.1867E-03_JPRB,7.7058E-03_JPRB,7.8650E-03_JPRB,&
&7.6617E-03_JPRB,6.9802E-03_JPRB,2.4709E-03_JPRB/)
KAO( :, 3, 4, 3) = (/&
&1.9306E-03_JPRB,5.5299E-03_JPRB,6.8812E-03_JPRB,7.7221E-03_JPRB,8.2549E-03_JPRB,8.3977E-03_JPRB,&
&8.1626E-03_JPRB,7.4067E-03_JPRB,2.6716E-03_JPRB/)
KAO( :, 4, 4, 3) = (/&
&2.1349E-03_JPRB,5.9971E-03_JPRB,7.4507E-03_JPRB,8.3116E-03_JPRB,8.8413E-03_JPRB,8.9674E-03_JPRB,&
&8.6864E-03_JPRB,7.8658E-03_JPRB,2.8745E-03_JPRB/)
KAO( :, 5, 4, 3) = (/&
&2.3336E-03_JPRB,6.4807E-03_JPRB,8.0336E-03_JPRB,8.9354E-03_JPRB,9.4416E-03_JPRB,9.5691E-03_JPRB,&
&9.2483E-03_JPRB,8.3517E-03_JPRB,3.0875E-03_JPRB/)
KAO( :, 1, 5, 3) = (/&
&1.2643E-03_JPRB,3.7992E-03_JPRB,4.7706E-03_JPRB,5.4821E-03_JPRB,5.9156E-03_JPRB,6.0631E-03_JPRB,&
&5.8873E-03_JPRB,5.3374E-03_JPRB,1.7987E-03_JPRB/)
KAO( :, 2, 5, 3) = (/&
&1.4029E-03_JPRB,4.1601E-03_JPRB,5.1876E-03_JPRB,5.8930E-03_JPRB,6.3304E-03_JPRB,6.4641E-03_JPRB,&
&6.2801E-03_JPRB,5.6828E-03_JPRB,1.9541E-03_JPRB/)
KAO( :, 3, 5, 3) = (/&
&1.5562E-03_JPRB,4.5381E-03_JPRB,5.6449E-03_JPRB,6.3470E-03_JPRB,6.7903E-03_JPRB,6.9025E-03_JPRB,&
&6.6934E-03_JPRB,6.0371E-03_JPRB,2.1188E-03_JPRB/)
KAO( :, 4, 5, 3) = (/&
&1.7190E-03_JPRB,4.9285E-03_JPRB,6.1272E-03_JPRB,6.8449E-03_JPRB,7.2797E-03_JPRB,7.3760E-03_JPRB,&
&7.1291E-03_JPRB,6.4167E-03_JPRB,2.2886E-03_JPRB/)
KAO( :, 5, 5, 3) = (/&
&1.8807E-03_JPRB,5.3341E-03_JPRB,6.6172E-03_JPRB,7.3735E-03_JPRB,7.7846E-03_JPRB,7.8779E-03_JPRB,&
&7.5974E-03_JPRB,6.8236E-03_JPRB,2.4671E-03_JPRB/)
KAO( :, 1, 6, 3) = (/&
&1.0213E-03_JPRB,3.0721E-03_JPRB,3.8660E-03_JPRB,4.4559E-03_JPRB,4.8197E-03_JPRB,4.9478E-03_JPRB,&
&4.7982E-03_JPRB,4.3290E-03_JPRB,1.4118E-03_JPRB/)
KAO( :, 2, 6, 3) = (/&
&1.1324E-03_JPRB,3.3728E-03_JPRB,4.2119E-03_JPRB,4.7959E-03_JPRB,5.1628E-03_JPRB,5.2793E-03_JPRB,&
&5.1225E-03_JPRB,4.6162E-03_JPRB,1.5418E-03_JPRB/)
KAO( :, 3, 6, 3) = (/&
&1.2545E-03_JPRB,3.6892E-03_JPRB,4.5936E-03_JPRB,5.1743E-03_JPRB,5.5467E-03_JPRB,5.6393E-03_JPRB,&
&5.4667E-03_JPRB,4.9091E-03_JPRB,1.6767E-03_JPRB/)
KAO( :, 4, 6, 3) = (/&
&1.3844E-03_JPRB,4.0151E-03_JPRB,4.9945E-03_JPRB,5.5888E-03_JPRB,5.9562E-03_JPRB,6.0318E-03_JPRB,&
&5.8253E-03_JPRB,5.2198E-03_JPRB,1.8201E-03_JPRB/)
KAO( :, 5, 6, 3) = (/&
&1.5162E-03_JPRB,4.3530E-03_JPRB,5.4044E-03_JPRB,6.0308E-03_JPRB,6.3808E-03_JPRB,6.4545E-03_JPRB,&
&6.2163E-03_JPRB,5.5575E-03_JPRB,1.9706E-03_JPRB/)
KAO( :, 1, 7, 3) = (/&
&8.1383E-04_JPRB,2.4690E-03_JPRB,3.1190E-03_JPRB,3.6045E-03_JPRB,3.9078E-03_JPRB,4.0152E-03_JPRB,&
&3.8892E-03_JPRB,3.5066E-03_JPRB,1.1162E-03_JPRB/)
KAO( :, 2, 7, 3) = (/&
&9.0133E-04_JPRB,2.7200E-03_JPRB,3.4007E-03_JPRB,3.8875E-03_JPRB,4.1896E-03_JPRB,4.2887E-03_JPRB,&
&4.1574E-03_JPRB,3.7464E-03_JPRB,1.2253E-03_JPRB/)
KAO( :, 3, 7, 3) = (/&
&9.9758E-04_JPRB,2.9822E-03_JPRB,3.7154E-03_JPRB,4.1988E-03_JPRB,4.5072E-03_JPRB,4.5864E-03_JPRB,&
&4.4444E-03_JPRB,3.9910E-03_JPRB,1.3374E-03_JPRB/)
KAO( :, 4, 7, 3) = (/&
&1.1009E-03_JPRB,3.2536E-03_JPRB,4.0499E-03_JPRB,4.5399E-03_JPRB,4.8474E-03_JPRB,4.9140E-03_JPRB,&
&4.7441E-03_JPRB,4.2483E-03_JPRB,1.4572E-03_JPRB/)
KAO( :, 5, 7, 3) = (/&
&1.2079E-03_JPRB,3.5321E-03_JPRB,4.3905E-03_JPRB,4.9045E-03_JPRB,5.2002E-03_JPRB,5.2665E-03_JPRB,&
&5.0703E-03_JPRB,4.5267E-03_JPRB,1.5834E-03_JPRB/)
KAO( :, 1, 8, 3) = (/&
&6.4403E-04_JPRB,1.9711E-03_JPRB,2.5061E-03_JPRB,2.9046E-03_JPRB,3.1552E-03_JPRB,3.2467E-03_JPRB,&
&3.1397E-03_JPRB,2.8272E-03_JPRB,9.2879E-04_JPRB/)
KAO( :, 2, 8, 3) = (/&
&7.1238E-04_JPRB,2.1771E-03_JPRB,2.7335E-03_JPRB,3.1363E-03_JPRB,3.3882E-03_JPRB,3.4702E-03_JPRB,&
&3.3609E-03_JPRB,3.0275E-03_JPRB,1.0282E-03_JPRB/)
KAO( :, 3, 8, 3) = (/&
&7.8775E-04_JPRB,2.3928E-03_JPRB,2.9888E-03_JPRB,3.3912E-03_JPRB,3.6502E-03_JPRB,3.7161E-03_JPRB,&
&3.5992E-03_JPRB,3.2322E-03_JPRB,1.1312E-03_JPRB/)
KAO( :, 4, 8, 3) = (/&
&8.6902E-04_JPRB,2.6176E-03_JPRB,3.2653E-03_JPRB,3.6711E-03_JPRB,3.9303E-03_JPRB,3.9873E-03_JPRB,&
&3.8512E-03_JPRB,3.4474E-03_JPRB,1.2372E-03_JPRB/)
KAO( :, 5, 8, 3) = (/&
&9.5395E-04_JPRB,2.8439E-03_JPRB,3.5472E-03_JPRB,3.9717E-03_JPRB,4.2227E-03_JPRB,4.2804E-03_JPRB,&
&4.1230E-03_JPRB,3.6794E-03_JPRB,1.3472E-03_JPRB/)
KAO( :, 1, 9, 3) = (/&
&5.1007E-04_JPRB,1.5656E-03_JPRB,2.0060E-03_JPRB,2.3330E-03_JPRB,2.5370E-03_JPRB,2.6132E-03_JPRB,&
&2.5254E-03_JPRB,2.2694E-03_JPRB,9.3729E-04_JPRB/)
KAO( :, 2, 9, 3) = (/&
&5.6353E-04_JPRB,1.7326E-03_JPRB,2.1869E-03_JPRB,2.5189E-03_JPRB,2.7285E-03_JPRB,2.7995E-03_JPRB,&
&2.7056E-03_JPRB,2.4351E-03_JPRB,1.0493E-03_JPRB/)
KAO( :, 3, 9, 3) = (/&
&6.2213E-04_JPRB,1.9088E-03_JPRB,2.3915E-03_JPRB,2.7258E-03_JPRB,2.9423E-03_JPRB,2.9995E-03_JPRB,&
&2.9041E-03_JPRB,2.6067E-03_JPRB,1.1607E-03_JPRB/)
KAO( :, 4, 9, 3) = (/&
&6.8571E-04_JPRB,2.0922E-03_JPRB,2.6149E-03_JPRB,2.9528E-03_JPRB,3.1723E-03_JPRB,3.2231E-03_JPRB,&
&3.1163E-03_JPRB,2.7863E-03_JPRB,1.2669E-03_JPRB/)
KAO( :, 5, 9, 3) = (/&
&7.5285E-04_JPRB,2.2758E-03_JPRB,2.8459E-03_JPRB,3.1985E-03_JPRB,3.4132E-03_JPRB,3.4638E-03_JPRB,&
&3.3423E-03_JPRB,2.9799E-03_JPRB,1.3708E-03_JPRB/)
KAO( :, 1,10, 3) = (/&
&4.0986E-04_JPRB,1.2514E-03_JPRB,1.6149E-03_JPRB,1.8827E-03_JPRB,2.0477E-03_JPRB,2.1068E-03_JPRB,&
&2.0342E-03_JPRB,1.8264E-03_JPRB,9.4172E-04_JPRB/)
KAO( :, 2,10, 3) = (/&
&4.5195E-04_JPRB,1.3870E-03_JPRB,1.7594E-03_JPRB,2.0313E-03_JPRB,2.2041E-03_JPRB,2.2637E-03_JPRB,&
&2.1836E-03_JPRB,1.9630E-03_JPRB,1.0592E-03_JPRB/)
KAO( :, 3,10, 3) = (/&
&4.9807E-04_JPRB,1.5305E-03_JPRB,1.9232E-03_JPRB,2.1993E-03_JPRB,2.3783E-03_JPRB,2.4282E-03_JPRB,&
&2.3477E-03_JPRB,2.1050E-03_JPRB,1.1691E-03_JPRB/)
KAO( :, 4,10, 3) = (/&
&5.4808E-04_JPRB,1.6789E-03_JPRB,2.1022E-03_JPRB,2.3829E-03_JPRB,2.5654E-03_JPRB,2.6091E-03_JPRB,&
&2.5255E-03_JPRB,2.2562E-03_JPRB,1.2759E-03_JPRB/)
KAO( :, 5,10, 3) = (/&
&6.0117E-04_JPRB,1.8287E-03_JPRB,2.2888E-03_JPRB,2.5807E-03_JPRB,2.7622E-03_JPRB,2.8066E-03_JPRB,&
&2.7118E-03_JPRB,2.4197E-03_JPRB,1.3798E-03_JPRB/)
KAO( :, 1,11, 3) = (/&
&3.4587E-04_JPRB,1.0486E-03_JPRB,1.3498E-03_JPRB,1.5706E-03_JPRB,1.7067E-03_JPRB,1.7541E-03_JPRB,&
&1.6904E-03_JPRB,1.5189E-03_JPRB,8.4922E-04_JPRB/)
KAO( :, 2,11, 3) = (/&
&3.8030E-04_JPRB,1.1612E-03_JPRB,1.4720E-03_JPRB,1.6962E-03_JPRB,1.8396E-03_JPRB,1.8877E-03_JPRB,&
&1.8189E-03_JPRB,1.6321E-03_JPRB,9.4886E-04_JPRB/)
KAO( :, 3,11, 3) = (/&
&4.1775E-04_JPRB,1.2794E-03_JPRB,1.6083E-03_JPRB,1.8372E-03_JPRB,1.9863E-03_JPRB,2.0269E-03_JPRB,&
&1.9602E-03_JPRB,1.7534E-03_JPRB,1.0435E-03_JPRB/)
KAO( :, 4,11, 3) = (/&
&4.5831E-04_JPRB,1.4012E-03_JPRB,1.7558E-03_JPRB,1.9899E-03_JPRB,2.1423E-03_JPRB,2.1791E-03_JPRB,&
&2.1105E-03_JPRB,1.8847E-03_JPRB,1.1342E-03_JPRB/)
KAO( :, 5,11, 3) = (/&
&5.0160E-04_JPRB,1.5235E-03_JPRB,1.9068E-03_JPRB,2.1518E-03_JPRB,2.3031E-03_JPRB,2.3452E-03_JPRB,&
&2.2691E-03_JPRB,2.0271E-03_JPRB,1.2246E-03_JPRB/)
KAO( :, 1,12, 3) = (/&
&2.8728E-04_JPRB,8.7138E-04_JPRB,1.1212E-03_JPRB,1.3035E-03_JPRB,1.4166E-03_JPRB,1.4556E-03_JPRB,&
&1.4016E-03_JPRB,1.2592E-03_JPRB,7.2447E-04_JPRB/)
KAO( :, 2,12, 3) = (/&
&3.1564E-04_JPRB,9.6434E-04_JPRB,1.2235E-03_JPRB,1.4085E-03_JPRB,1.5279E-03_JPRB,1.5679E-03_JPRB,&
&1.5112E-03_JPRB,1.3542E-03_JPRB,8.0728E-04_JPRB/)
KAO( :, 3,12, 3) = (/&
&3.4588E-04_JPRB,1.0616E-03_JPRB,1.3357E-03_JPRB,1.5255E-03_JPRB,1.6505E-03_JPRB,1.6842E-03_JPRB,&
&1.6309E-03_JPRB,1.4584E-03_JPRB,8.8538E-04_JPRB/)
KAO( :, 4,12, 3) = (/&
&3.7862E-04_JPRB,1.1614E-03_JPRB,1.4559E-03_JPRB,1.6504E-03_JPRB,1.7780E-03_JPRB,1.8118E-03_JPRB,&
&1.7570E-03_JPRB,1.5710E-03_JPRB,9.6174E-04_JPRB/)
KAO( :, 5,12, 3) = (/&
&4.1375E-04_JPRB,1.2608E-03_JPRB,1.5783E-03_JPRB,1.7829E-03_JPRB,1.9097E-03_JPRB,1.9490E-03_JPRB,&
&1.8902E-03_JPRB,1.6924E-03_JPRB,1.0383E-03_JPRB/)
KAO( :, 1,13, 3) = (/&
&2.3648E-04_JPRB,7.2058E-04_JPRB,9.2721E-04_JPRB,1.0773E-03_JPRB,1.1715E-03_JPRB,1.2041E-03_JPRB,&
&1.1590E-03_JPRB,1.0409E-03_JPRB,5.9750E-04_JPRB/)
KAO( :, 2,13, 3) = (/&
&2.5991E-04_JPRB,7.9700E-04_JPRB,1.0119E-03_JPRB,1.1647E-03_JPRB,1.2640E-03_JPRB,1.2977E-03_JPRB,&
&1.2520E-03_JPRB,1.1213E-03_JPRB,6.6442E-04_JPRB/)
KAO( :, 3,13, 3) = (/&
&2.8463E-04_JPRB,8.7643E-04_JPRB,1.1035E-03_JPRB,1.2606E-03_JPRB,1.3651E-03_JPRB,1.3947E-03_JPRB,&
&1.3520E-03_JPRB,1.2099E-03_JPRB,7.2829E-04_JPRB/)
KAO( :, 4,13, 3) = (/&
&3.1116E-04_JPRB,9.5840E-04_JPRB,1.2015E-03_JPRB,1.3629E-03_JPRB,1.4693E-03_JPRB,1.4997E-03_JPRB,&
&1.4571E-03_JPRB,1.3050E-03_JPRB,7.9195E-04_JPRB/)
KAO( :, 5,13, 3) = (/&
&3.3973E-04_JPRB,1.0393E-03_JPRB,1.3011E-03_JPRB,1.4709E-03_JPRB,1.5771E-03_JPRB,1.6125E-03_JPRB,&
&1.5669E-03_JPRB,1.4078E-03_JPRB,8.5580E-04_JPRB/)
KAO( :, 1, 1, 4) = (/&
&6.8556E-03_JPRB,1.5209E-02_JPRB,1.8964E-02_JPRB,2.1311E-02_JPRB,2.2775E-02_JPRB,2.3573E-02_JPRB,&
&2.3412E-02_JPRB,2.1611E-02_JPRB,1.0754E-02_JPRB/)
KAO( :, 2, 1, 4) = (/&
&7.5360E-03_JPRB,1.6539E-02_JPRB,2.0389E-02_JPRB,2.2809E-02_JPRB,2.4368E-02_JPRB,2.5124E-02_JPRB,&
&2.4893E-02_JPRB,2.2807E-02_JPRB,1.1409E-02_JPRB/)
KAO( :, 3, 1, 4) = (/&
&8.2731E-03_JPRB,1.7967E-02_JPRB,2.1859E-02_JPRB,2.4354E-02_JPRB,2.6001E-02_JPRB,2.6738E-02_JPRB,&
&2.6424E-02_JPRB,2.3981E-02_JPRB,1.2028E-02_JPRB/)
KAO( :, 4, 1, 4) = (/&
&9.0669E-03_JPRB,1.9440E-02_JPRB,2.3386E-02_JPRB,2.5951E-02_JPRB,2.7638E-02_JPRB,2.8404E-02_JPRB,&
&2.7993E-02_JPRB,2.5105E-02_JPRB,1.2622E-02_JPRB/)
KAO( :, 5, 1, 4) = (/&
&9.9297E-03_JPRB,2.0867E-02_JPRB,2.4992E-02_JPRB,2.7620E-02_JPRB,2.9333E-02_JPRB,3.0144E-02_JPRB,&
&2.9561E-02_JPRB,2.6196E-02_JPRB,1.3246E-02_JPRB/)
KAO( :, 1, 2, 4) = (/&
&6.0458E-03_JPRB,1.3057E-02_JPRB,1.6177E-02_JPRB,1.8072E-02_JPRB,1.9267E-02_JPRB,1.9866E-02_JPRB,&
&1.9708E-02_JPRB,1.7998E-02_JPRB,8.6186E-03_JPRB/)
KAO( :, 2, 2, 4) = (/&
&6.6625E-03_JPRB,1.4207E-02_JPRB,1.7424E-02_JPRB,1.9390E-02_JPRB,2.0646E-02_JPRB,2.1226E-02_JPRB,&
&2.0989E-02_JPRB,1.9040E-02_JPRB,9.1596E-03_JPRB/)
KAO( :, 3, 2, 4) = (/&
&7.3258E-03_JPRB,1.5446E-02_JPRB,1.8730E-02_JPRB,2.0756E-02_JPRB,2.2068E-02_JPRB,2.2641E-02_JPRB,&
&2.2320E-02_JPRB,2.0040E-02_JPRB,9.6719E-03_JPRB/)
KAO( :, 4, 2, 4) = (/&
&8.0389E-03_JPRB,1.6697E-02_JPRB,2.0086E-02_JPRB,2.2176E-02_JPRB,2.3509E-02_JPRB,2.4128E-02_JPRB,&
&2.3691E-02_JPRB,2.0995E-02_JPRB,1.0163E-02_JPRB/)
KAO( :, 5, 2, 4) = (/&
&8.8116E-03_JPRB,1.7924E-02_JPRB,2.1495E-02_JPRB,2.3659E-02_JPRB,2.5007E-02_JPRB,2.5649E-02_JPRB,&
&2.5070E-02_JPRB,2.1939E-02_JPRB,1.0681E-02_JPRB/)
KAO( :, 1, 3, 4) = (/&
&5.1529E-03_JPRB,1.1010E-02_JPRB,1.3576E-02_JPRB,1.5057E-02_JPRB,1.5941E-02_JPRB,1.6391E-02_JPRB,&
&1.6252E-02_JPRB,1.4825E-02_JPRB,6.7965E-03_JPRB/)
KAO( :, 2, 3, 4) = (/&
&5.7021E-03_JPRB,1.1982E-02_JPRB,1.4643E-02_JPRB,1.6192E-02_JPRB,1.7140E-02_JPRB,1.7565E-02_JPRB,&
&1.7355E-02_JPRB,1.5736E-02_JPRB,7.2498E-03_JPRB/)
KAO( :, 3, 3, 4) = (/&
&6.2951E-03_JPRB,1.3030E-02_JPRB,1.5759E-02_JPRB,1.7371E-02_JPRB,1.8379E-02_JPRB,1.8797E-02_JPRB,&
&1.8506E-02_JPRB,1.6604E-02_JPRB,7.6744E-03_JPRB/)
KAO( :, 4, 3, 4) = (/&
&6.9329E-03_JPRB,1.4099E-02_JPRB,1.6924E-02_JPRB,1.8614E-02_JPRB,1.9640E-02_JPRB,2.0080E-02_JPRB,&
&1.9697E-02_JPRB,1.7427E-02_JPRB,8.0855E-03_JPRB/)
KAO( :, 5, 3, 4) = (/&
&7.6208E-03_JPRB,1.5154E-02_JPRB,1.8132E-02_JPRB,1.9899E-02_JPRB,2.0953E-02_JPRB,2.1403E-02_JPRB,&
&2.0907E-02_JPRB,1.8236E-02_JPRB,8.5123E-03_JPRB/)
KAO( :, 1, 4, 4) = (/&
&4.3117E-03_JPRB,9.2399E-03_JPRB,1.1333E-02_JPRB,1.2460E-02_JPRB,1.3088E-02_JPRB,1.3384E-02_JPRB,&
&1.3264E-02_JPRB,1.2129E-02_JPRB,5.3638E-03_JPRB/)
KAO( :, 2, 4, 4) = (/&
&4.7919E-03_JPRB,1.0057E-02_JPRB,1.2236E-02_JPRB,1.3425E-02_JPRB,1.4108E-02_JPRB,1.4384E-02_JPRB,&
&1.4215E-02_JPRB,1.2919E-02_JPRB,5.7448E-03_JPRB/)
KAO( :, 3, 4, 4) = (/&
&5.3141E-03_JPRB,1.0939E-02_JPRB,1.3172E-02_JPRB,1.4430E-02_JPRB,1.5160E-02_JPRB,1.5438E-02_JPRB,&
&1.5198E-02_JPRB,1.3684E-02_JPRB,6.1060E-03_JPRB/)
KAO( :, 4, 4, 4) = (/&
&5.8726E-03_JPRB,1.1850E-02_JPRB,1.4160E-02_JPRB,1.5498E-02_JPRB,1.6255E-02_JPRB,1.6542E-02_JPRB,&
&1.6226E-02_JPRB,1.4411E-02_JPRB,6.4545E-03_JPRB/)
KAO( :, 5, 4, 4) = (/&
&6.4675E-03_JPRB,1.2764E-02_JPRB,1.5190E-02_JPRB,1.6608E-02_JPRB,1.7400E-02_JPRB,1.7692E-02_JPRB,&
&1.7269E-02_JPRB,1.5120E-02_JPRB,6.8073E-03_JPRB/)
KAO( :, 1, 5, 4) = (/&
&3.5690E-03_JPRB,7.7051E-03_JPRB,9.4368E-03_JPRB,1.0305E-02_JPRB,1.0745E-02_JPRB,1.0912E-02_JPRB,&
&1.0785E-02_JPRB,9.8773E-03_JPRB,4.2532E-03_JPRB/)
KAO( :, 2, 5, 4) = (/&
&3.9820E-03_JPRB,8.3977E-03_JPRB,1.0194E-02_JPRB,1.1112E-02_JPRB,1.1609E-02_JPRB,1.1756E-02_JPRB,&
&1.1595E-02_JPRB,1.0560E-02_JPRB,4.5731E-03_JPRB/)
KAO( :, 3, 5, 4) = (/&
&4.4305E-03_JPRB,9.1511E-03_JPRB,1.0990E-02_JPRB,1.1967E-02_JPRB,1.2498E-02_JPRB,1.2650E-02_JPRB,&
&1.2430E-02_JPRB,1.1229E-02_JPRB,4.8830E-03_JPRB/)
KAO( :, 4, 5, 4) = (/&
&4.9079E-03_JPRB,9.9363E-03_JPRB,1.1832E-02_JPRB,1.2872E-02_JPRB,1.3434E-02_JPRB,1.3592E-02_JPRB,&
&1.3307E-02_JPRB,1.1872E-02_JPRB,5.1810E-03_JPRB/)
KAO( :, 5, 5, 4) = (/&
&5.4148E-03_JPRB,1.0727E-02_JPRB,1.2716E-02_JPRB,1.3820E-02_JPRB,1.4419E-02_JPRB,1.4584E-02_JPRB,&
&1.4197E-02_JPRB,1.2492E-02_JPRB,5.4782E-03_JPRB/)
KAO( :, 1, 6, 4) = (/&
&2.9249E-03_JPRB,6.3510E-03_JPRB,7.7849E-03_JPRB,8.4721E-03_JPRB,8.7941E-03_JPRB,8.8837E-03_JPRB,&
&8.7388E-03_JPRB,7.9841E-03_JPRB,3.3710E-03_JPRB/)
KAO( :, 2, 6, 4) = (/&
&3.2672E-03_JPRB,6.9385E-03_JPRB,8.4203E-03_JPRB,9.1541E-03_JPRB,9.5165E-03_JPRB,9.5904E-03_JPRB,&
&9.4152E-03_JPRB,8.5713E-03_JPRB,3.6377E-03_JPRB/)
KAO( :, 3, 6, 4) = (/&
&3.6418E-03_JPRB,7.5787E-03_JPRB,9.0887E-03_JPRB,9.8765E-03_JPRB,1.0268E-02_JPRB,1.0342E-02_JPRB,&
&1.0116E-02_JPRB,9.1545E-03_JPRB,3.8990E-03_JPRB/)
KAO( :, 4, 6, 4) = (/&
&4.0414E-03_JPRB,8.2510E-03_JPRB,9.8093E-03_JPRB,1.0646E-02_JPRB,1.1060E-02_JPRB,1.1134E-02_JPRB,&
&1.0854E-02_JPRB,9.7190E-03_JPRB,4.1544E-03_JPRB/)
KAO( :, 5, 6, 4) = (/&
&4.4633E-03_JPRB,8.9345E-03_JPRB,1.0570E-02_JPRB,1.1457E-02_JPRB,1.1902E-02_JPRB,1.1976E-02_JPRB,&
&1.1614E-02_JPRB,1.0272E-02_JPRB,4.4061E-03_JPRB/)
KAO( :, 1, 7, 4) = (/&
&2.3975E-03_JPRB,5.1959E-03_JPRB,6.3675E-03_JPRB,6.9242E-03_JPRB,7.1717E-03_JPRB,7.2208E-03_JPRB,&
&7.0819E-03_JPRB,6.4278E-03_JPRB,2.6775E-03_JPRB/)
KAO( :, 2, 7, 4) = (/&
&2.6794E-03_JPRB,5.6899E-03_JPRB,6.9066E-03_JPRB,7.4942E-03_JPRB,7.7787E-03_JPRB,7.8098E-03_JPRB,&
&7.6464E-03_JPRB,6.9290E-03_JPRB,2.9001E-03_JPRB/)
KAO( :, 3, 7, 4) = (/&
&2.9849E-03_JPRB,6.2316E-03_JPRB,7.4741E-03_JPRB,8.1056E-03_JPRB,8.4139E-03_JPRB,8.4374E-03_JPRB,&
&8.2281E-03_JPRB,7.4302E-03_JPRB,3.1195E-03_JPRB/)
KAO( :, 4, 7, 4) = (/&
&3.3129E-03_JPRB,6.7984E-03_JPRB,8.0790E-03_JPRB,8.7600E-03_JPRB,9.0837E-03_JPRB,9.1052E-03_JPRB,&
&8.8458E-03_JPRB,7.9231E-03_JPRB,3.3376E-03_JPRB/)
KAO( :, 5, 7, 4) = (/&
&3.6598E-03_JPRB,7.3757E-03_JPRB,8.7298E-03_JPRB,9.4547E-03_JPRB,9.7958E-03_JPRB,9.8221E-03_JPRB,&
&9.4863E-03_JPRB,8.4060E-03_JPRB,3.5509E-03_JPRB/)
KAO( :, 1, 8, 4) = (/&
&1.9434E-03_JPRB,4.2318E-03_JPRB,5.1740E-03_JPRB,5.6370E-03_JPRB,5.8246E-03_JPRB,5.8488E-03_JPRB,&
&5.7327E-03_JPRB,5.1810E-03_JPRB,2.1537E-03_JPRB/)
KAO( :, 2, 8, 4) = (/&
&2.1750E-03_JPRB,4.6511E-03_JPRB,5.6344E-03_JPRB,6.1150E-03_JPRB,6.3286E-03_JPRB,6.3404E-03_JPRB,&
&6.2037E-03_JPRB,5.6029E-03_JPRB,2.3441E-03_JPRB/)
KAO( :, 3, 8, 4) = (/&
&2.4260E-03_JPRB,5.1070E-03_JPRB,6.1176E-03_JPRB,6.6292E-03_JPRB,6.8641E-03_JPRB,6.8681E-03_JPRB,&
&6.6887E-03_JPRB,6.0329E-03_JPRB,2.5317E-03_JPRB/)
KAO( :, 4, 8, 4) = (/&
&2.6978E-03_JPRB,5.5812E-03_JPRB,6.6317E-03_JPRB,7.1849E-03_JPRB,7.4298E-03_JPRB,7.4337E-03_JPRB,&
&7.2011E-03_JPRB,6.4503E-03_JPRB,2.7201E-03_JPRB/)
KAO( :, 5, 8, 4) = (/&
&2.9851E-03_JPRB,6.0671E-03_JPRB,7.1793E-03_JPRB,7.7747E-03_JPRB,8.0358E-03_JPRB,8.0369E-03_JPRB,&
&7.7421E-03_JPRB,6.8660E-03_JPRB,2.9050E-03_JPRB/)
KAO( :, 1, 9, 4) = (/&
&1.5624E-03_JPRB,3.4224E-03_JPRB,4.1803E-03_JPRB,4.5613E-03_JPRB,4.7117E-03_JPRB,4.7269E-03_JPRB,&
&4.6315E-03_JPRB,4.1802E-03_JPRB,2.0354E-03_JPRB/)
KAO( :, 2, 9, 4) = (/&
&1.7467E-03_JPRB,3.7749E-03_JPRB,4.5748E-03_JPRB,4.9706E-03_JPRB,5.1343E-03_JPRB,5.1344E-03_JPRB,&
&5.0243E-03_JPRB,4.5350E-03_JPRB,2.2250E-03_JPRB/)
KAO( :, 3, 9, 4) = (/&
&1.9492E-03_JPRB,4.1547E-03_JPRB,4.9867E-03_JPRB,5.4054E-03_JPRB,5.5868E-03_JPRB,5.5764E-03_JPRB,&
&5.4288E-03_JPRB,4.8977E-03_JPRB,2.4149E-03_JPRB/)
KAO( :, 4, 9, 4) = (/&
&2.1701E-03_JPRB,4.5508E-03_JPRB,5.4194E-03_JPRB,5.8744E-03_JPRB,6.0659E-03_JPRB,6.0518E-03_JPRB,&
&5.8540E-03_JPRB,5.2537E-03_JPRB,2.5971E-03_JPRB/)
KAO( :, 5, 9, 4) = (/&
&2.4022E-03_JPRB,4.9613E-03_JPRB,5.8787E-03_JPRB,6.3727E-03_JPRB,6.5778E-03_JPRB,6.5618E-03_JPRB,&
&6.3067E-03_JPRB,5.6053E-03_JPRB,2.7830E-03_JPRB/)
KAO( :, 1,10, 4) = (/&
&1.2651E-03_JPRB,2.7744E-03_JPRB,3.3801E-03_JPRB,3.6900E-03_JPRB,3.8178E-03_JPRB,3.8360E-03_JPRB,&
&3.7605E-03_JPRB,3.3907E-03_JPRB,2.1692E-03_JPRB/)
KAO( :, 2,10, 4) = (/&
&1.4111E-03_JPRB,3.0657E-03_JPRB,3.7136E-03_JPRB,4.0421E-03_JPRB,4.1735E-03_JPRB,4.1745E-03_JPRB,&
&4.0861E-03_JPRB,3.6872E-03_JPRB,2.3639E-03_JPRB/)
KAO( :, 3,10, 4) = (/&
&1.5740E-03_JPRB,3.3806E-03_JPRB,4.0618E-03_JPRB,4.4105E-03_JPRB,4.5571E-03_JPRB,4.5460E-03_JPRB,&
&4.4247E-03_JPRB,3.9923E-03_JPRB,2.5630E-03_JPRB/)
KAO( :, 4,10, 4) = (/&
&1.7522E-03_JPRB,3.7084E-03_JPRB,4.4249E-03_JPRB,4.8035E-03_JPRB,4.9639E-03_JPRB,4.9498E-03_JPRB,&
&4.7806E-03_JPRB,4.2956E-03_JPRB,2.7623E-03_JPRB/)
KAO( :, 5,10, 4) = (/&
&1.9383E-03_JPRB,4.0495E-03_JPRB,4.8094E-03_JPRB,5.2222E-03_JPRB,5.3934E-03_JPRB,5.3817E-03_JPRB,&
&5.1614E-03_JPRB,4.5951E-03_JPRB,2.9665E-03_JPRB/)
KAO( :, 1,11, 4) = (/&
&1.0742E-03_JPRB,2.3468E-03_JPRB,2.8469E-03_JPRB,3.1039E-03_JPRB,3.2098E-03_JPRB,3.2233E-03_JPRB,&
&3.1623E-03_JPRB,2.8537E-03_JPRB,1.9822E-03_JPRB/)
KAO( :, 2,11, 4) = (/&
&1.1960E-03_JPRB,2.5965E-03_JPRB,3.1323E-03_JPRB,3.4077E-03_JPRB,3.5194E-03_JPRB,3.5164E-03_JPRB,&
&3.4380E-03_JPRB,3.1056E-03_JPRB,2.1578E-03_JPRB/)
KAO( :, 3,11, 4) = (/&
&1.3316E-03_JPRB,2.8599E-03_JPRB,3.4277E-03_JPRB,3.7260E-03_JPRB,3.8497E-03_JPRB,3.8405E-03_JPRB,&
&3.7265E-03_JPRB,3.3630E-03_JPRB,2.3306E-03_JPRB/)
KAO( :, 4,11, 4) = (/&
&1.4781E-03_JPRB,3.1344E-03_JPRB,3.7357E-03_JPRB,4.0610E-03_JPRB,4.1987E-03_JPRB,4.1913E-03_JPRB,&
&4.0345E-03_JPRB,3.6192E-03_JPRB,2.5097E-03_JPRB/)
KAO( :, 5,11, 4) = (/&
&1.6288E-03_JPRB,3.4177E-03_JPRB,4.0619E-03_JPRB,4.4185E-03_JPRB,4.5672E-03_JPRB,4.5600E-03_JPRB,&
&4.3663E-03_JPRB,3.8756E-03_JPRB,2.6889E-03_JPRB/)
KAO( :, 1,12, 4) = (/&
&8.9874E-04_JPRB,1.9689E-03_JPRB,2.3835E-03_JPRB,2.5973E-03_JPRB,2.6864E-03_JPRB,2.6939E-03_JPRB,&
&2.6425E-03_JPRB,2.3895E-03_JPRB,1.7049E-03_JPRB/)
KAO( :, 2,12, 4) = (/&
&1.0002E-03_JPRB,2.1778E-03_JPRB,2.6233E-03_JPRB,2.8564E-03_JPRB,2.9517E-03_JPRB,2.9476E-03_JPRB,&
&2.8766E-03_JPRB,2.6019E-03_JPRB,1.8543E-03_JPRB/)
KAO( :, 3,12, 4) = (/&
&1.1122E-03_JPRB,2.3973E-03_JPRB,2.8713E-03_JPRB,3.1266E-03_JPRB,3.2310E-03_JPRB,3.2276E-03_JPRB,&
&3.1237E-03_JPRB,2.8177E-03_JPRB,2.0046E-03_JPRB/)
KAO( :, 4,12, 4) = (/&
&1.2310E-03_JPRB,2.6254E-03_JPRB,3.1305E-03_JPRB,3.4112E-03_JPRB,3.5275E-03_JPRB,3.5259E-03_JPRB,&
&3.3898E-03_JPRB,3.0349E-03_JPRB,2.1565E-03_JPRB/)
KAO( :, 5,12, 4) = (/&
&1.3518E-03_JPRB,2.8575E-03_JPRB,3.4006E-03_JPRB,3.7092E-03_JPRB,3.8403E-03_JPRB,3.8370E-03_JPRB,&
&3.6750E-03_JPRB,3.2557E-03_JPRB,2.3061E-03_JPRB/)
KAO( :, 1,13, 4) = (/&
&7.4537E-04_JPRB,1.6409E-03_JPRB,1.9863E-03_JPRB,2.1648E-03_JPRB,2.2399E-03_JPRB,2.2444E-03_JPRB,&
&2.1988E-03_JPRB,1.9916E-03_JPRB,1.4115E-03_JPRB/)
KAO( :, 2,13, 4) = (/&
&8.2943E-04_JPRB,1.8143E-03_JPRB,2.1850E-03_JPRB,2.3828E-03_JPRB,2.4639E-03_JPRB,2.4609E-03_JPRB,&
&2.3970E-03_JPRB,2.1692E-03_JPRB,1.5369E-03_JPRB/)
KAO( :, 3,13, 4) = (/&
&9.2142E-04_JPRB,1.9970E-03_JPRB,2.3927E-03_JPRB,2.6093E-03_JPRB,2.6971E-03_JPRB,2.6969E-03_JPRB,&
&2.6076E-03_JPRB,2.3521E-03_JPRB,1.6626E-03_JPRB/)
KAO( :, 4,13, 4) = (/&
&1.0167E-03_JPRB,2.1837E-03_JPRB,2.6078E-03_JPRB,2.8478E-03_JPRB,2.9467E-03_JPRB,2.9488E-03_JPRB,&
&2.8346E-03_JPRB,2.5383E-03_JPRB,1.7879E-03_JPRB/)
KAO( :, 5,13, 4) = (/&
&1.1138E-03_JPRB,2.3733E-03_JPRB,2.8290E-03_JPRB,3.0924E-03_JPRB,3.2079E-03_JPRB,3.2103E-03_JPRB,&
&3.0778E-03_JPRB,2.7284E-03_JPRB,1.9133E-03_JPRB/)
KAO( :, 1, 1, 5) = (/&
&1.7181E-02_JPRB,3.2302E-02_JPRB,3.8595E-02_JPRB,4.2778E-02_JPRB,4.5051E-02_JPRB,4.5779E-02_JPRB,&
&4.4076E-02_JPRB,3.6499E-02_JPRB,2.1167E-02_JPRB/)
KAO( :, 2, 1, 5) = (/&
&1.8715E-02_JPRB,3.4583E-02_JPRB,4.1400E-02_JPRB,4.5830E-02_JPRB,4.8256E-02_JPRB,4.8951E-02_JPRB,&
&4.6576E-02_JPRB,3.8480E-02_JPRB,2.2565E-02_JPRB/)
KAO( :, 3, 1, 5) = (/&
&2.0319E-02_JPRB,3.6940E-02_JPRB,4.4260E-02_JPRB,4.8908E-02_JPRB,5.1471E-02_JPRB,5.2022E-02_JPRB,&
&4.8965E-02_JPRB,4.0507E-02_JPRB,2.4057E-02_JPRB/)
KAO( :, 4, 1, 5) = (/&
&2.1938E-02_JPRB,3.9364E-02_JPRB,4.7234E-02_JPRB,5.2022E-02_JPRB,5.4697E-02_JPRB,5.4911E-02_JPRB,&
&5.1216E-02_JPRB,4.2565E-02_JPRB,2.5590E-02_JPRB/)
KAO( :, 5, 1, 5) = (/&
&2.3550E-02_JPRB,4.1966E-02_JPRB,5.0230E-02_JPRB,5.5149E-02_JPRB,5.7839E-02_JPRB,5.7598E-02_JPRB,&
&5.3448E-02_JPRB,4.4689E-02_JPRB,2.7100E-02_JPRB/)
KAO( :, 1, 2, 5) = (/&
&1.5052E-02_JPRB,2.7803E-02_JPRB,3.3102E-02_JPRB,3.6670E-02_JPRB,3.8668E-02_JPRB,3.9030E-02_JPRB,&
&3.7189E-02_JPRB,3.0668E-02_JPRB,1.6985E-02_JPRB/)
KAO( :, 2, 2, 5) = (/&
&1.6394E-02_JPRB,2.9857E-02_JPRB,3.5621E-02_JPRB,3.9412E-02_JPRB,4.1539E-02_JPRB,4.1835E-02_JPRB,&
&3.9351E-02_JPRB,3.2356E-02_JPRB,1.8150E-02_JPRB/)
KAO( :, 3, 2, 5) = (/&
&1.7773E-02_JPRB,3.1981E-02_JPRB,3.8209E-02_JPRB,4.2190E-02_JPRB,4.4385E-02_JPRB,4.4554E-02_JPRB,&
&4.1400E-02_JPRB,3.4106E-02_JPRB,1.9354E-02_JPRB/)
KAO( :, 4, 2, 5) = (/&
&1.9186E-02_JPRB,3.4227E-02_JPRB,4.0894E-02_JPRB,4.4998E-02_JPRB,4.7235E-02_JPRB,4.7050E-02_JPRB,&
&4.3366E-02_JPRB,3.5935E-02_JPRB,2.0592E-02_JPRB/)
KAO( :, 5, 2, 5) = (/&
&2.0602E-02_JPRB,3.6657E-02_JPRB,4.3639E-02_JPRB,4.7854E-02_JPRB,5.0031E-02_JPRB,4.9403E-02_JPRB,&
&4.5298E-02_JPRB,3.7775E-02_JPRB,2.1830E-02_JPRB/)
KAO( :, 1, 3, 5) = (/&
&1.3014E-02_JPRB,2.3440E-02_JPRB,2.7739E-02_JPRB,3.0683E-02_JPRB,3.2476E-02_JPRB,3.2815E-02_JPRB,&
&3.1052E-02_JPRB,2.5347E-02_JPRB,1.3409E-02_JPRB/)
KAO( :, 2, 3, 5) = (/&
&1.4134E-02_JPRB,2.5267E-02_JPRB,2.9956E-02_JPRB,3.3121E-02_JPRB,3.5013E-02_JPRB,3.5276E-02_JPRB,&
&3.2969E-02_JPRB,2.6772E-02_JPRB,1.4346E-02_JPRB/)
KAO( :, 3, 3, 5) = (/&
&1.5286E-02_JPRB,2.7161E-02_JPRB,3.2264E-02_JPRB,3.5614E-02_JPRB,3.7525E-02_JPRB,3.7651E-02_JPRB,&
&3.4766E-02_JPRB,2.8284E-02_JPRB,1.5307E-02_JPRB/)
KAO( :, 4, 3, 5) = (/&
&1.6478E-02_JPRB,2.9176E-02_JPRB,3.4663E-02_JPRB,3.8132E-02_JPRB,4.0060E-02_JPRB,3.9857E-02_JPRB,&
&3.6493E-02_JPRB,2.9862E-02_JPRB,1.6309E-02_JPRB/)
KAO( :, 5, 3, 5) = (/&
&1.7703E-02_JPRB,3.1371E-02_JPRB,3.7140E-02_JPRB,4.0703E-02_JPRB,4.2572E-02_JPRB,4.1936E-02_JPRB,&
&3.8184E-02_JPRB,3.1459E-02_JPRB,1.7321E-02_JPRB/)
KAO( :, 1, 4, 5) = (/&
&1.1231E-02_JPRB,1.9592E-02_JPRB,2.3001E-02_JPRB,2.5417E-02_JPRB,2.6918E-02_JPRB,2.7254E-02_JPRB,&
&2.5764E-02_JPRB,2.0867E-02_JPRB,1.0611E-02_JPRB/)
KAO( :, 2, 4, 5) = (/&
&1.2152E-02_JPRB,2.1190E-02_JPRB,2.4941E-02_JPRB,2.7556E-02_JPRB,2.9134E-02_JPRB,2.9416E-02_JPRB,&
&2.7448E-02_JPRB,2.2085E-02_JPRB,1.1371E-02_JPRB/)
KAO( :, 3, 4, 5) = (/&
&1.3112E-02_JPRB,2.2852E-02_JPRB,2.6983E-02_JPRB,2.9739E-02_JPRB,3.1347E-02_JPRB,3.1506E-02_JPRB,&
&2.9043E-02_JPRB,2.3373E-02_JPRB,1.2148E-02_JPRB/)
KAO( :, 4, 4, 5) = (/&
&1.4124E-02_JPRB,2.4635E-02_JPRB,2.9094E-02_JPRB,3.1959E-02_JPRB,3.3566E-02_JPRB,3.3485E-02_JPRB,&
&3.0596E-02_JPRB,2.4717E-02_JPRB,1.2964E-02_JPRB/)
KAO( :, 5, 4, 5) = (/&
&1.5184E-02_JPRB,2.6570E-02_JPRB,3.1299E-02_JPRB,3.4230E-02_JPRB,3.5790E-02_JPRB,3.5353E-02_JPRB,&
&3.2102E-02_JPRB,2.6103E-02_JPRB,1.3794E-02_JPRB/)
KAO( :, 1, 5, 5) = (/&
&9.6625E-03_JPRB,1.6401E-02_JPRB,1.9034E-02_JPRB,2.0952E-02_JPRB,2.2133E-02_JPRB,2.2396E-02_JPRB,&
&2.1200E-02_JPRB,1.7173E-02_JPRB,8.4178E-03_JPRB/)
KAO( :, 2, 5, 5) = (/&
&1.0438E-02_JPRB,1.7777E-02_JPRB,2.0706E-02_JPRB,2.2811E-02_JPRB,2.4067E-02_JPRB,2.4293E-02_JPRB,&
&2.2690E-02_JPRB,1.8230E-02_JPRB,9.0426E-03_JPRB/)
KAO( :, 3, 5, 5) = (/&
&1.1254E-02_JPRB,1.9209E-02_JPRB,2.2469E-02_JPRB,2.4701E-02_JPRB,2.6015E-02_JPRB,2.6148E-02_JPRB,&
&2.4123E-02_JPRB,1.9342E-02_JPRB,9.6801E-03_JPRB/)
KAO( :, 4, 5, 5) = (/&
&1.2133E-02_JPRB,2.0762E-02_JPRB,2.4308E-02_JPRB,2.6645E-02_JPRB,2.7949E-02_JPRB,2.7917E-02_JPRB,&
&2.5517E-02_JPRB,2.0494E-02_JPRB,1.0342E-02_JPRB/)
KAO( :, 5, 5, 5) = (/&
&1.3065E-02_JPRB,2.2455E-02_JPRB,2.6254E-02_JPRB,2.8630E-02_JPRB,2.9901E-02_JPRB,2.9590E-02_JPRB,&
&2.6871E-02_JPRB,2.1687E-02_JPRB,1.1028E-02_JPRB/)
KAO( :, 1, 6, 5) = (/&
&8.2007E-03_JPRB,1.3715E-02_JPRB,1.5729E-02_JPRB,1.7180E-02_JPRB,1.8048E-02_JPRB,1.8207E-02_JPRB,&
&1.7264E-02_JPRB,1.4054E-02_JPRB,6.6647E-03_JPRB/)
KAO( :, 2, 6, 5) = (/&
&8.8577E-03_JPRB,1.4875E-02_JPRB,1.7145E-02_JPRB,1.8767E-02_JPRB,1.9710E-02_JPRB,1.9852E-02_JPRB,&
&1.8586E-02_JPRB,1.4966E-02_JPRB,7.1861E-03_JPRB/)
KAO( :, 3, 6, 5) = (/&
&9.5621E-03_JPRB,1.6088E-02_JPRB,1.8646E-02_JPRB,2.0384E-02_JPRB,2.1390E-02_JPRB,2.1481E-02_JPRB,&
&1.9863E-02_JPRB,1.5925E-02_JPRB,7.7141E-03_JPRB/)
KAO( :, 4, 6, 5) = (/&
&1.0328E-02_JPRB,1.7422E-02_JPRB,2.0223E-02_JPRB,2.2061E-02_JPRB,2.3072E-02_JPRB,2.3059E-02_JPRB,&
&2.1135E-02_JPRB,1.6924E-02_JPRB,8.2553E-03_JPRB/)
KAO( :, 5, 6, 5) = (/&
&1.1150E-02_JPRB,1.8880E-02_JPRB,2.1894E-02_JPRB,2.3787E-02_JPRB,2.4780E-02_JPRB,2.4546E-02_JPRB,&
&2.2361E-02_JPRB,1.7956E-02_JPRB,8.8222E-03_JPRB/)
KAO( :, 1, 7, 5) = (/&
&6.8716E-03_JPRB,1.1438E-02_JPRB,1.2980E-02_JPRB,1.4066E-02_JPRB,1.4694E-02_JPRB,1.4738E-02_JPRB,&
&1.3970E-02_JPRB,1.1459E-02_JPRB,5.2799E-03_JPRB/)
KAO( :, 2, 7, 5) = (/&
&7.4237E-03_JPRB,1.2422E-02_JPRB,1.4174E-02_JPRB,1.5413E-02_JPRB,1.6105E-02_JPRB,1.6152E-02_JPRB,&
&1.5139E-02_JPRB,1.2254E-02_JPRB,5.7135E-03_JPRB/)
KAO( :, 3, 7, 5) = (/&
&8.0288E-03_JPRB,1.3449E-02_JPRB,1.5440E-02_JPRB,1.6795E-02_JPRB,1.7529E-02_JPRB,1.7565E-02_JPRB,&
&1.6277E-02_JPRB,1.3083E-02_JPRB,6.1506E-03_JPRB/)
KAO( :, 4, 7, 5) = (/&
&8.6956E-03_JPRB,1.4582E-02_JPRB,1.6791E-02_JPRB,1.8226E-02_JPRB,1.8968E-02_JPRB,1.8943E-02_JPRB,&
&1.7401E-02_JPRB,1.3948E-02_JPRB,6.5933E-03_JPRB/)
KAO( :, 5, 7, 5) = (/&
&9.4131E-03_JPRB,1.5832E-02_JPRB,1.8226E-02_JPRB,1.9705E-02_JPRB,2.0439E-02_JPRB,2.0248E-02_JPRB,&
&1.8508E-02_JPRB,1.4839E-02_JPRB,7.0585E-03_JPRB/)
KAO( :, 1, 8, 5) = (/&
&5.7435E-03_JPRB,9.4740E-03_JPRB,1.0676E-02_JPRB,1.1493E-02_JPRB,1.1955E-02_JPRB,1.1929E-02_JPRB,&
&1.1279E-02_JPRB,9.3230E-03_JPRB,4.2354E-03_JPRB/)
KAO( :, 2, 8, 5) = (/&
&6.2010E-03_JPRB,1.0304E-02_JPRB,1.1685E-02_JPRB,1.2627E-02_JPRB,1.3147E-02_JPRB,1.3135E-02_JPRB,&
&1.2304E-02_JPRB,1.0014E-02_JPRB,4.5941E-03_JPRB/)
KAO( :, 3, 8, 5) = (/&
&6.7137E-03_JPRB,1.1183E-02_JPRB,1.2753E-02_JPRB,1.3801E-02_JPRB,1.4354E-02_JPRB,1.4340E-02_JPRB,&
&1.3315E-02_JPRB,1.0741E-02_JPRB,4.9555E-03_JPRB/)
KAO( :, 4, 8, 5) = (/&
&7.2796E-03_JPRB,1.2147E-02_JPRB,1.3897E-02_JPRB,1.5019E-02_JPRB,1.5585E-02_JPRB,1.5528E-02_JPRB,&
&1.4315E-02_JPRB,1.1502E-02_JPRB,5.3165E-03_JPRB/)
KAO( :, 5, 8, 5) = (/&
&7.8871E-03_JPRB,1.3218E-02_JPRB,1.5130E-02_JPRB,1.6296E-02_JPRB,1.6839E-02_JPRB,1.6669E-02_JPRB,&
&1.5291E-02_JPRB,1.2282E-02_JPRB,5.6971E-03_JPRB/)
KAO( :, 1, 9, 5) = (/&
&4.7912E-03_JPRB,7.8358E-03_JPRB,8.7667E-03_JPRB,9.3820E-03_JPRB,9.7143E-03_JPRB,9.6500E-03_JPRB,&
&9.0841E-03_JPRB,7.5626E-03_JPRB,3.7702E-03_JPRB/)
KAO( :, 2, 9, 5) = (/&
&5.1805E-03_JPRB,8.5367E-03_JPRB,9.6133E-03_JPRB,1.0334E-02_JPRB,1.0715E-02_JPRB,1.0676E-02_JPRB,&
&9.9859E-03_JPRB,8.1627E-03_JPRB,4.1139E-03_JPRB/)
KAO( :, 3, 9, 5) = (/&
&5.6138E-03_JPRB,9.2835E-03_JPRB,1.0517E-02_JPRB,1.1325E-02_JPRB,1.1739E-02_JPRB,1.1698E-02_JPRB,&
&1.0873E-02_JPRB,8.7929E-03_JPRB,4.4462E-03_JPRB/)
KAO( :, 4, 9, 5) = (/&
&6.0888E-03_JPRB,1.0103E-02_JPRB,1.1488E-02_JPRB,1.2361E-02_JPRB,1.2785E-02_JPRB,1.2718E-02_JPRB,&
&1.1751E-02_JPRB,9.4626E-03_JPRB,4.7957E-03_JPRB/)
KAO( :, 5, 9, 5) = (/&
&6.6048E-03_JPRB,1.1011E-02_JPRB,1.2538E-02_JPRB,1.3462E-02_JPRB,1.3863E-02_JPRB,1.3713E-02_JPRB,&
&1.2615E-02_JPRB,1.0155E-02_JPRB,5.1561E-03_JPRB/)
KAO( :, 1,10, 5) = (/&
&3.9863E-03_JPRB,6.4924E-03_JPRB,7.2470E-03_JPRB,7.7132E-03_JPRB,7.9522E-03_JPRB,7.8682E-03_JPRB,&
&7.3679E-03_JPRB,6.1741E-03_JPRB,4.1464E-03_JPRB/)
KAO( :, 2,10, 5) = (/&
&4.3124E-03_JPRB,7.0973E-03_JPRB,7.9675E-03_JPRB,8.5161E-03_JPRB,8.8014E-03_JPRB,8.7362E-03_JPRB,&
&8.1504E-03_JPRB,6.7002E-03_JPRB,4.5619E-03_JPRB/)
KAO( :, 3,10, 5) = (/&
&4.6741E-03_JPRB,7.7383E-03_JPRB,8.7399E-03_JPRB,9.3597E-03_JPRB,9.6733E-03_JPRB,9.6088E-03_JPRB,&
&8.9286E-03_JPRB,7.2584E-03_JPRB,4.9900E-03_JPRB/)
KAO( :, 4,10, 5) = (/&
&5.0713E-03_JPRB,8.4456E-03_JPRB,9.5735E-03_JPRB,1.0251E-02_JPRB,1.0572E-02_JPRB,1.0481E-02_JPRB,&
&9.6979E-03_JPRB,7.8488E-03_JPRB,5.4214E-03_JPRB/)
KAO( :, 5,10, 5) = (/&
&5.5035E-03_JPRB,9.2235E-03_JPRB,1.0475E-02_JPRB,1.1200E-02_JPRB,1.1508E-02_JPRB,1.1347E-02_JPRB,&
&1.0465E-02_JPRB,8.4573E-03_JPRB,5.8532E-03_JPRB/)
KAO( :, 1,11, 5) = (/&
&3.4140E-03_JPRB,5.5663E-03_JPRB,6.2176E-03_JPRB,6.6132E-03_JPRB,6.8087E-03_JPRB,6.7328E-03_JPRB,&
&6.2855E-03_JPRB,5.2486E-03_JPRB,3.9285E-03_JPRB/)
KAO( :, 2,11, 5) = (/&
&3.6967E-03_JPRB,6.0927E-03_JPRB,6.8505E-03_JPRB,7.3111E-03_JPRB,7.5377E-03_JPRB,7.4746E-03_JPRB,&
&6.9609E-03_JPRB,5.7240E-03_JPRB,4.3138E-03_JPRB/)
KAO( :, 3,11, 5) = (/&
&4.0076E-03_JPRB,6.6620E-03_JPRB,7.5356E-03_JPRB,8.0510E-03_JPRB,8.2975E-03_JPRB,8.2276E-03_JPRB,&
&7.6355E-03_JPRB,6.2275E-03_JPRB,4.7141E-03_JPRB/)
KAO( :, 4,11, 5) = (/&
&4.3451E-03_JPRB,7.2880E-03_JPRB,8.2782E-03_JPRB,8.8424E-03_JPRB,9.0928E-03_JPRB,8.9832E-03_JPRB,&
&8.3078E-03_JPRB,6.7453E-03_JPRB,5.1152E-03_JPRB/)
KAO( :, 5,11, 5) = (/&
&4.7137E-03_JPRB,7.9681E-03_JPRB,9.0805E-03_JPRB,9.6843E-03_JPRB,9.9239E-03_JPRB,9.7470E-03_JPRB,&
&8.9796E-03_JPRB,7.2798E-03_JPRB,5.5223E-03_JPRB/)
KAO( :, 1,12, 5) = (/&
&2.8904E-03_JPRB,4.7236E-03_JPRB,5.2777E-03_JPRB,5.6093E-03_JPRB,5.7722E-03_JPRB,5.7159E-03_JPRB,&
&5.3358E-03_JPRB,4.4458E-03_JPRB,3.4411E-03_JPRB/)
KAO( :, 2,12, 5) = (/&
&3.1305E-03_JPRB,5.1808E-03_JPRB,5.8340E-03_JPRB,6.2167E-03_JPRB,6.4011E-03_JPRB,6.3506E-03_JPRB,&
&5.9136E-03_JPRB,4.8660E-03_JPRB,3.7674E-03_JPRB/)
KAO( :, 3,12, 5) = (/&
&3.3899E-03_JPRB,5.6784E-03_JPRB,6.4390E-03_JPRB,6.8698E-03_JPRB,7.0684E-03_JPRB,6.9989E-03_JPRB,&
&6.4975E-03_JPRB,5.3037E-03_JPRB,4.1043E-03_JPRB/)
KAO( :, 4,12, 5) = (/&
&3.6744E-03_JPRB,6.2189E-03_JPRB,7.0905E-03_JPRB,7.5674E-03_JPRB,7.7704E-03_JPRB,7.6566E-03_JPRB,&
&7.0778E-03_JPRB,5.7507E-03_JPRB,4.4508E-03_JPRB/)
KAO( :, 5,12, 5) = (/&
&3.9835E-03_JPRB,6.8035E-03_JPRB,7.7845E-03_JPRB,8.3062E-03_JPRB,8.4996E-03_JPRB,8.3274E-03_JPRB,&
&7.6592E-03_JPRB,6.2151E-03_JPRB,4.8132E-03_JPRB/)
KAO( :, 1,13, 5) = (/&
&2.4250E-03_JPRB,3.9803E-03_JPRB,4.4491E-03_JPRB,4.7254E-03_JPRB,4.8599E-03_JPRB,4.8181E-03_JPRB,&
&4.5058E-03_JPRB,3.7586E-03_JPRB,2.8856E-03_JPRB/)
KAO( :, 2,13, 5) = (/&
&2.6244E-03_JPRB,4.3727E-03_JPRB,4.9354E-03_JPRB,5.2533E-03_JPRB,5.4054E-03_JPRB,5.3645E-03_JPRB,&
&5.0027E-03_JPRB,4.1245E-03_JPRB,3.1558E-03_JPRB/)
KAO( :, 3,13, 5) = (/&
&2.8394E-03_JPRB,4.7986E-03_JPRB,5.4578E-03_JPRB,5.8227E-03_JPRB,5.9899E-03_JPRB,5.9263E-03_JPRB,&
&5.5030E-03_JPRB,4.4990E-03_JPRB,3.4378E-03_JPRB/)
KAO( :, 4,13, 5) = (/&
&3.0777E-03_JPRB,5.2577E-03_JPRB,6.0171E-03_JPRB,6.4265E-03_JPRB,6.6019E-03_JPRB,6.4996E-03_JPRB,&
&6.0065E-03_JPRB,4.8862E-03_JPRB,3.7311E-03_JPRB/)
KAO( :, 5,13, 5) = (/&
&3.3322E-03_JPRB,5.7564E-03_JPRB,6.6107E-03_JPRB,7.0607E-03_JPRB,7.2295E-03_JPRB,7.0815E-03_JPRB,&
&6.5094E-03_JPRB,5.2886E-03_JPRB,4.0375E-03_JPRB/)
KAO( :, 1, 1, 6) = (/&
&4.8059E-02_JPRB,7.5661E-02_JPRB,8.9697E-02_JPRB,9.6448E-02_JPRB,9.6739E-02_JPRB,9.1321E-02_JPRB,&
&8.0664E-02_JPRB,6.5698E-02_JPRB,4.2723E-02_JPRB/)
KAO( :, 2, 1, 6) = (/&
&5.1263E-02_JPRB,8.1256E-02_JPRB,9.5858E-02_JPRB,1.0217E-01_JPRB,1.0171E-01_JPRB,9.5631E-02_JPRB,&
&8.5046E-02_JPRB,6.9688E-02_JPRB,4.5844E-02_JPRB/)
KAO( :, 3, 1, 6) = (/&
&5.4622E-02_JPRB,8.6828E-02_JPRB,1.0177E-01_JPRB,1.0751E-01_JPRB,1.0632E-01_JPRB,9.9795E-02_JPRB,&
&8.9370E-02_JPRB,7.3806E-02_JPRB,4.9014E-02_JPRB/)
KAO( :, 4, 1, 6) = (/&
&5.8181E-02_JPRB,9.2294E-02_JPRB,1.0720E-01_JPRB,1.1246E-01_JPRB,1.1070E-01_JPRB,1.0392E-01_JPRB,&
&9.3642E-02_JPRB,7.8008E-02_JPRB,5.2233E-02_JPRB/)
KAO( :, 5, 1, 6) = (/&
&6.1920E-02_JPRB,9.7606E-02_JPRB,1.1219E-01_JPRB,1.1714E-01_JPRB,1.1501E-01_JPRB,1.0812E-01_JPRB,&
&9.7841E-02_JPRB,8.2254E-02_JPRB,5.5493E-02_JPRB/)
KAO( :, 1, 2, 6) = (/&
&4.2387E-02_JPRB,6.7507E-02_JPRB,7.8624E-02_JPRB,8.3202E-02_JPRB,8.2483E-02_JPRB,7.7642E-02_JPRB,&
&6.8845E-02_JPRB,5.6151E-02_JPRB,3.4701E-02_JPRB/)
KAO( :, 2, 2, 6) = (/&
&4.5358E-02_JPRB,7.2621E-02_JPRB,8.4105E-02_JPRB,8.8143E-02_JPRB,8.6828E-02_JPRB,8.1423E-02_JPRB,&
&7.2754E-02_JPRB,5.9777E-02_JPRB,3.7226E-02_JPRB/)
KAO( :, 3, 2, 6) = (/&
&4.8530E-02_JPRB,7.7675E-02_JPRB,8.9237E-02_JPRB,9.2816E-02_JPRB,9.0945E-02_JPRB,8.5108E-02_JPRB,&
&7.6583E-02_JPRB,6.3482E-02_JPRB,3.9865E-02_JPRB/)
KAO( :, 4, 2, 6) = (/&
&5.1885E-02_JPRB,8.2602E-02_JPRB,9.3935E-02_JPRB,9.7188E-02_JPRB,9.4884E-02_JPRB,8.8874E-02_JPRB,&
&8.0329E-02_JPRB,6.7178E-02_JPRB,4.2571E-02_JPRB/)
KAO( :, 5, 2, 6) = (/&
&5.5413E-02_JPRB,8.7298E-02_JPRB,9.8304E-02_JPRB,1.0128E-01_JPRB,9.8763E-02_JPRB,9.2748E-02_JPRB,&
&8.4077E-02_JPRB,7.0956E-02_JPRB,4.5317E-02_JPRB/)
KAO( :, 1, 3, 6) = (/&
&3.6455E-02_JPRB,5.8761E-02_JPRB,6.7738E-02_JPRB,7.0855E-02_JPRB,6.9598E-02_JPRB,6.5071E-02_JPRB,&
&5.7664E-02_JPRB,4.7187E-02_JPRB,2.7522E-02_JPRB/)
KAO( :, 2, 3, 6) = (/&
&3.9177E-02_JPRB,6.3373E-02_JPRB,7.2623E-02_JPRB,7.5288E-02_JPRB,7.3424E-02_JPRB,6.8383E-02_JPRB,&
&6.1089E-02_JPRB,5.0369E-02_JPRB,2.9594E-02_JPRB/)
KAO( :, 3, 3, 6) = (/&
&4.2098E-02_JPRB,6.7937E-02_JPRB,7.7177E-02_JPRB,7.9459E-02_JPRB,7.7094E-02_JPRB,7.1679E-02_JPRB,&
&6.4440E-02_JPRB,5.3598E-02_JPRB,3.1800E-02_JPRB/)
KAO( :, 4, 3, 6) = (/&
&4.5184E-02_JPRB,7.2373E-02_JPRB,8.1328E-02_JPRB,8.3304E-02_JPRB,8.0619E-02_JPRB,7.5059E-02_JPRB,&
&6.7785E-02_JPRB,5.6837E-02_JPRB,3.4061E-02_JPRB/)
KAO( :, 5, 3, 6) = (/&
&4.8428E-02_JPRB,7.6612E-02_JPRB,8.5198E-02_JPRB,8.6971E-02_JPRB,8.4087E-02_JPRB,7.8597E-02_JPRB,&
&7.1152E-02_JPRB,6.0069E-02_JPRB,3.6300E-02_JPRB/)
KAO( :, 1, 4, 6) = (/&
&3.0996E-02_JPRB,5.0246E-02_JPRB,5.7596E-02_JPRB,5.9940E-02_JPRB,5.8577E-02_JPRB,5.4443E-02_JPRB,&
&4.7987E-02_JPRB,3.9247E-02_JPRB,2.1796E-02_JPRB/)
KAO( :, 2, 4, 6) = (/&
&3.3466E-02_JPRB,5.4388E-02_JPRB,6.1941E-02_JPRB,6.3890E-02_JPRB,6.2051E-02_JPRB,5.7420E-02_JPRB,&
&5.0954E-02_JPRB,4.2026E-02_JPRB,2.3521E-02_JPRB/)
KAO( :, 3, 4, 6) = (/&
&3.6103E-02_JPRB,5.8512E-02_JPRB,6.5986E-02_JPRB,6.7619E-02_JPRB,6.5381E-02_JPRB,6.0341E-02_JPRB,&
&5.3887E-02_JPRB,4.4806E-02_JPRB,2.5354E-02_JPRB/)
KAO( :, 4, 4, 6) = (/&
&3.8902E-02_JPRB,6.2522E-02_JPRB,6.9761E-02_JPRB,7.1083E-02_JPRB,6.8563E-02_JPRB,6.3337E-02_JPRB,&
&5.6817E-02_JPRB,4.7569E-02_JPRB,2.7230E-02_JPRB/)
KAO( :, 5, 4, 6) = (/&
&4.1856E-02_JPRB,6.6293E-02_JPRB,7.3260E-02_JPRB,7.4402E-02_JPRB,7.1665E-02_JPRB,6.6453E-02_JPRB,&
&5.9783E-02_JPRB,5.0307E-02_JPRB,2.9093E-02_JPRB/)
KAO( :, 1, 5, 6) = (/&
&2.6300E-02_JPRB,4.2494E-02_JPRB,4.8463E-02_JPRB,5.0296E-02_JPRB,4.9139E-02_JPRB,4.5597E-02_JPRB,&
&3.9984E-02_JPRB,3.2427E-02_JPRB,1.7285E-02_JPRB/)
KAO( :, 2, 5, 6) = (/&
&2.8485E-02_JPRB,4.6204E-02_JPRB,5.2338E-02_JPRB,5.3863E-02_JPRB,5.2270E-02_JPRB,4.8312E-02_JPRB,&
&4.2548E-02_JPRB,3.4804E-02_JPRB,1.8719E-02_JPRB/)
KAO( :, 3, 5, 6) = (/&
&3.0827E-02_JPRB,4.9910E-02_JPRB,5.5974E-02_JPRB,5.7207E-02_JPRB,5.5255E-02_JPRB,5.0912E-02_JPRB,&
&4.5100E-02_JPRB,3.7174E-02_JPRB,2.0228E-02_JPRB/)
KAO( :, 4, 5, 6) = (/&
&3.3317E-02_JPRB,5.3494E-02_JPRB,5.9405E-02_JPRB,6.0361E-02_JPRB,5.8140E-02_JPRB,5.3556E-02_JPRB,&
&4.7658E-02_JPRB,3.9537E-02_JPRB,2.1785E-02_JPRB/)
KAO( :, 5, 5, 6) = (/&
&3.5980E-02_JPRB,5.6835E-02_JPRB,6.2631E-02_JPRB,6.3411E-02_JPRB,6.1001E-02_JPRB,5.6317E-02_JPRB,&
&5.0255E-02_JPRB,4.1909E-02_JPRB,2.3351E-02_JPRB/)
KAO( :, 1, 6, 6) = (/&
&2.2346E-02_JPRB,3.5586E-02_JPRB,4.0310E-02_JPRB,4.1785E-02_JPRB,4.0899E-02_JPRB,3.7930E-02_JPRB,&
&3.3177E-02_JPRB,2.6660E-02_JPRB,1.3671E-02_JPRB/)
KAO( :, 2, 6, 6) = (/&
&2.4236E-02_JPRB,3.8875E-02_JPRB,4.3767E-02_JPRB,4.4998E-02_JPRB,4.3719E-02_JPRB,4.0355E-02_JPRB,&
&3.5414E-02_JPRB,2.8669E-02_JPRB,1.4853E-02_JPRB/)
KAO( :, 3, 6, 6) = (/&
&2.6259E-02_JPRB,4.2194E-02_JPRB,4.7065E-02_JPRB,4.8039E-02_JPRB,4.6410E-02_JPRB,4.2692E-02_JPRB,&
&3.7647E-02_JPRB,3.0658E-02_JPRB,1.6097E-02_JPRB/)
KAO( :, 4, 6, 6) = (/&
&2.8435E-02_JPRB,4.5379E-02_JPRB,5.0168E-02_JPRB,5.0950E-02_JPRB,4.9017E-02_JPRB,4.5071E-02_JPRB,&
&3.9870E-02_JPRB,3.2675E-02_JPRB,1.7389E-02_JPRB/)
KAO( :, 5, 6, 6) = (/&
&3.0784E-02_JPRB,4.8355E-02_JPRB,5.3115E-02_JPRB,5.3744E-02_JPRB,5.1611E-02_JPRB,4.7542E-02_JPRB,&
&4.2135E-02_JPRB,3.4713E-02_JPRB,1.8719E-02_JPRB/)
KAO( :, 1, 7, 6) = (/&
&1.9038E-02_JPRB,2.9659E-02_JPRB,3.3335E-02_JPRB,3.4533E-02_JPRB,3.3796E-02_JPRB,3.1353E-02_JPRB,&
&2.7369E-02_JPRB,2.1858E-02_JPRB,1.0821E-02_JPRB/)
KAO( :, 2, 7, 6) = (/&
&2.0661E-02_JPRB,3.2535E-02_JPRB,3.6409E-02_JPRB,3.7416E-02_JPRB,3.6337E-02_JPRB,3.3530E-02_JPRB,&
&2.9317E-02_JPRB,2.3570E-02_JPRB,1.1782E-02_JPRB/)
KAO( :, 3, 7, 6) = (/&
&2.2409E-02_JPRB,3.5475E-02_JPRB,3.9394E-02_JPRB,4.0148E-02_JPRB,3.8791E-02_JPRB,3.5637E-02_JPRB,&
&3.1269E-02_JPRB,2.5254E-02_JPRB,1.2818E-02_JPRB/)
KAO( :, 4, 7, 6) = (/&
&2.4302E-02_JPRB,3.8296E-02_JPRB,4.2195E-02_JPRB,4.2786E-02_JPRB,4.1191E-02_JPRB,3.7785E-02_JPRB,&
&3.3232E-02_JPRB,2.6957E-02_JPRB,1.3893E-02_JPRB/)
KAO( :, 5, 7, 6) = (/&
&2.6331E-02_JPRB,4.0952E-02_JPRB,4.4849E-02_JPRB,4.5357E-02_JPRB,4.3572E-02_JPRB,4.0019E-02_JPRB,&
&3.5226E-02_JPRB,2.8694E-02_JPRB,1.5017E-02_JPRB/)
KAO( :, 1, 8, 6) = (/&
&1.6199E-02_JPRB,2.4730E-02_JPRB,2.7533E-02_JPRB,2.8457E-02_JPRB,2.7828E-02_JPRB,2.5812E-02_JPRB,&
&2.2538E-02_JPRB,1.7879E-02_JPRB,8.5690E-03_JPRB/)
KAO( :, 2, 8, 6) = (/&
&1.7586E-02_JPRB,2.7225E-02_JPRB,3.0249E-02_JPRB,3.1021E-02_JPRB,3.0098E-02_JPRB,2.7767E-02_JPRB,&
&2.4248E-02_JPRB,1.9357E-02_JPRB,9.3582E-03_JPRB/)
KAO( :, 3, 8, 6) = (/&
&1.9094E-02_JPRB,2.9782E-02_JPRB,3.2913E-02_JPRB,3.3499E-02_JPRB,3.2325E-02_JPRB,2.9706E-02_JPRB,&
&2.5968E-02_JPRB,2.0796E-02_JPRB,1.0214E-02_JPRB/)
KAO( :, 4, 8, 6) = (/&
&2.0716E-02_JPRB,3.2253E-02_JPRB,3.5436E-02_JPRB,3.5895E-02_JPRB,3.4530E-02_JPRB,3.1664E-02_JPRB,&
&2.7699E-02_JPRB,2.2256E-02_JPRB,1.1116E-02_JPRB/)
KAO( :, 5, 8, 6) = (/&
&2.2480E-02_JPRB,3.4617E-02_JPRB,3.7818E-02_JPRB,3.8224E-02_JPRB,3.6738E-02_JPRB,3.3713E-02_JPRB,&
&2.9501E-02_JPRB,2.3740E-02_JPRB,1.2059E-02_JPRB/)
KAO( :, 1, 9, 6) = (/&
&1.3777E-02_JPRB,2.0619E-02_JPRB,2.2737E-02_JPRB,2.3415E-02_JPRB,2.2850E-02_JPRB,2.1193E-02_JPRB,&
&1.8507E-02_JPRB,1.4598E-02_JPRB,7.1490E-03_JPRB/)
KAO( :, 2, 9, 6) = (/&
&1.4973E-02_JPRB,2.2774E-02_JPRB,2.5113E-02_JPRB,2.5666E-02_JPRB,2.4873E-02_JPRB,2.2943E-02_JPRB,&
&2.0009E-02_JPRB,1.5897E-02_JPRB,7.8590E-03_JPRB/)
KAO( :, 3, 9, 6) = (/&
&1.6264E-02_JPRB,2.4964E-02_JPRB,2.7466E-02_JPRB,2.7896E-02_JPRB,2.6883E-02_JPRB,2.4711E-02_JPRB,&
&2.1541E-02_JPRB,1.7155E-02_JPRB,8.6415E-03_JPRB/)
KAO( :, 4, 9, 6) = (/&
&1.7663E-02_JPRB,2.7143E-02_JPRB,2.9704E-02_JPRB,3.0059E-02_JPRB,2.8911E-02_JPRB,2.6494E-02_JPRB,&
&2.3105E-02_JPRB,1.8422E-02_JPRB,9.4633E-03_JPRB/)
KAO( :, 5, 9, 6) = (/&
&1.9189E-02_JPRB,2.9225E-02_JPRB,3.1858E-02_JPRB,3.2145E-02_JPRB,3.0918E-02_JPRB,2.8362E-02_JPRB,&
&2.4736E-02_JPRB,1.9714E-02_JPRB,1.0309E-02_JPRB/)
KAO( :, 1,10, 6) = (/&
&1.1829E-02_JPRB,1.7391E-02_JPRB,1.8971E-02_JPRB,1.9425E-02_JPRB,1.8925E-02_JPRB,1.7526E-02_JPRB,&
&1.5318E-02_JPRB,1.2046E-02_JPRB,7.9104E-03_JPRB/)
KAO( :, 2,10, 6) = (/&
&1.2882E-02_JPRB,1.9237E-02_JPRB,2.1011E-02_JPRB,2.1409E-02_JPRB,2.0725E-02_JPRB,1.9099E-02_JPRB,&
&1.6657E-02_JPRB,1.3189E-02_JPRB,8.8513E-03_JPRB/)
KAO( :, 3,10, 6) = (/&
&1.4005E-02_JPRB,2.1109E-02_JPRB,2.3070E-02_JPRB,2.3396E-02_JPRB,2.2541E-02_JPRB,2.0715E-02_JPRB,&
&1.8034E-02_JPRB,1.4319E-02_JPRB,9.8121E-03_JPRB/)
KAO( :, 4,10, 6) = (/&
&1.5220E-02_JPRB,2.2998E-02_JPRB,2.5049E-02_JPRB,2.5317E-02_JPRB,2.4368E-02_JPRB,2.2361E-02_JPRB,&
&1.9453E-02_JPRB,1.5444E-02_JPRB,1.0807E-02_JPRB/)
KAO( :, 5,10, 6) = (/&
&1.6552E-02_JPRB,2.4838E-02_JPRB,2.6967E-02_JPRB,2.7211E-02_JPRB,2.6179E-02_JPRB,2.4058E-02_JPRB,&
&2.0933E-02_JPRB,1.6593E-02_JPRB,1.1823E-02_JPRB/)
KAO( :, 1,11, 6) = (/&
&1.0495E-02_JPRB,1.5432E-02_JPRB,1.6714E-02_JPRB,1.6992E-02_JPRB,1.6455E-02_JPRB,1.5168E-02_JPRB,&
&1.3224E-02_JPRB,1.0391E-02_JPRB,8.1978E-03_JPRB/)
KAO( :, 2,11, 6) = (/&
&1.1451E-02_JPRB,1.7054E-02_JPRB,1.8505E-02_JPRB,1.8735E-02_JPRB,1.8057E-02_JPRB,1.6595E-02_JPRB,&
&1.4441E-02_JPRB,1.1397E-02_JPRB,9.2592E-03_JPRB/)
KAO( :, 3,11, 6) = (/&
&1.2482E-02_JPRB,1.8697E-02_JPRB,2.0258E-02_JPRB,2.0450E-02_JPRB,1.9674E-02_JPRB,1.8068E-02_JPRB,&
&1.5698E-02_JPRB,1.2409E-02_JPRB,1.0347E-02_JPRB/)
KAO( :, 4,11, 6) = (/&
&1.3612E-02_JPRB,2.0341E-02_JPRB,2.1972E-02_JPRB,2.2138E-02_JPRB,2.1292E-02_JPRB,1.9560E-02_JPRB,&
&1.7011E-02_JPRB,1.3437E-02_JPRB,1.1444E-02_JPRB/)
KAO( :, 5,11, 6) = (/&
&1.4838E-02_JPRB,2.1977E-02_JPRB,2.3658E-02_JPRB,2.3819E-02_JPRB,2.2926E-02_JPRB,2.1098E-02_JPRB,&
&1.8364E-02_JPRB,1.4494E-02_JPRB,1.2537E-02_JPRB/)
KAO( :, 1,12, 6) = (/&
&9.1433E-03_JPRB,1.3500E-02_JPRB,1.4586E-02_JPRB,1.4769E-02_JPRB,1.4241E-02_JPRB,1.3083E-02_JPRB,&
&1.1367E-02_JPRB,8.9090E-03_JPRB,7.5780E-03_JPRB/)
KAO( :, 2,12, 6) = (/&
&1.0001E-02_JPRB,1.4910E-02_JPRB,1.6125E-02_JPRB,1.6273E-02_JPRB,1.5652E-02_JPRB,1.4357E-02_JPRB,&
&1.2453E-02_JPRB,9.7929E-03_JPRB,8.5785E-03_JPRB/)
KAO( :, 3,12, 6) = (/&
&1.0949E-02_JPRB,1.6356E-02_JPRB,1.7635E-02_JPRB,1.7750E-02_JPRB,1.7058E-02_JPRB,1.5652E-02_JPRB,&
&1.3578E-02_JPRB,1.0697E-02_JPRB,9.5948E-03_JPRB/)
KAO( :, 4,12, 6) = (/&
&1.1985E-02_JPRB,1.7801E-02_JPRB,1.9128E-02_JPRB,1.9222E-02_JPRB,1.8476E-02_JPRB,1.6972E-02_JPRB,&
&1.4745E-02_JPRB,1.1628E-02_JPRB,1.0600E-02_JPRB/)
KAO( :, 5,12, 6) = (/&
&1.3096E-02_JPRB,1.9267E-02_JPRB,2.0626E-02_JPRB,2.0713E-02_JPRB,1.9923E-02_JPRB,1.8336E-02_JPRB,&
&1.5960E-02_JPRB,1.2572E-02_JPRB,1.1582E-02_JPRB/)
KAO( :, 1,13, 6) = (/&
&7.8612E-03_JPRB,1.1670E-02_JPRB,1.2609E-02_JPRB,1.2723E-02_JPRB,1.2259E-02_JPRB,1.1258E-02_JPRB,&
&9.7650E-03_JPRB,7.6525E-03_JPRB,6.5421E-03_JPRB/)
KAO( :, 2,13, 6) = (/&
&8.6369E-03_JPRB,1.2899E-02_JPRB,1.3916E-02_JPRB,1.4009E-02_JPRB,1.3482E-02_JPRB,1.2381E-02_JPRB,&
&1.0732E-02_JPRB,8.4378E-03_JPRB,7.4103E-03_JPRB/)
KAO( :, 3,13, 6) = (/&
&9.4942E-03_JPRB,1.4163E-02_JPRB,1.5223E-02_JPRB,1.5298E-02_JPRB,1.4708E-02_JPRB,1.3515E-02_JPRB,&
&1.1735E-02_JPRB,9.2523E-03_JPRB,8.2790E-03_JPRB/)
KAO( :, 4,13, 6) = (/&
&1.0421E-02_JPRB,1.5442E-02_JPRB,1.6542E-02_JPRB,1.6603E-02_JPRB,1.5959E-02_JPRB,1.4684E-02_JPRB,&
&1.2779E-02_JPRB,1.0090E-02_JPRB,9.1372E-03_JPRB/)
KAO( :, 5,13, 6) = (/&
&1.1403E-02_JPRB,1.6752E-02_JPRB,1.7882E-02_JPRB,1.7947E-02_JPRB,1.7255E-02_JPRB,1.5898E-02_JPRB,&
&1.3874E-02_JPRB,1.0931E-02_JPRB,9.9832E-03_JPRB/)
KAO( :, 1, 1, 7) = (/&
&1.6154E-01_JPRB,1.9464E-01_JPRB,1.9968E-01_JPRB,1.9566E-01_JPRB,1.8810E-01_JPRB,1.7612E-01_JPRB,&
&1.6037E-01_JPRB,1.3871E-01_JPRB,9.9439E-02_JPRB/)
KAO( :, 2, 1, 7) = (/&
&1.6718E-01_JPRB,2.0083E-01_JPRB,2.0683E-01_JPRB,2.0477E-01_JPRB,1.9764E-01_JPRB,1.8624E-01_JPRB,&
&1.6994E-01_JPRB,1.4688E-01_JPRB,1.0691E-01_JPRB/)
KAO( :, 3, 1, 7) = (/&
&1.7242E-01_JPRB,2.0656E-01_JPRB,2.1371E-01_JPRB,2.1366E-01_JPRB,2.0783E-01_JPRB,1.9677E-01_JPRB,&
&1.7978E-01_JPRB,1.5487E-01_JPRB,1.1430E-01_JPRB/)
KAO( :, 4, 1, 7) = (/&
&1.7742E-01_JPRB,2.1213E-01_JPRB,2.2064E-01_JPRB,2.2231E-01_JPRB,2.1832E-01_JPRB,2.0746E-01_JPRB,&
&1.8983E-01_JPRB,1.6294E-01_JPRB,1.2155E-01_JPRB/)
KAO( :, 5, 1, 7) = (/&
&1.8214E-01_JPRB,2.1767E-01_JPRB,2.2778E-01_JPRB,2.3090E-01_JPRB,2.2852E-01_JPRB,2.1832E-01_JPRB,&
&2.0005E-01_JPRB,1.7084E-01_JPRB,1.2867E-01_JPRB/)
KAO( :, 1, 2, 7) = (/&
&1.4145E-01_JPRB,1.6994E-01_JPRB,1.7429E-01_JPRB,1.7183E-01_JPRB,1.6506E-01_JPRB,1.5419E-01_JPRB,&
&1.3930E-01_JPRB,1.2012E-01_JPRB,8.1602E-02_JPRB/)
KAO( :, 2, 2, 7) = (/&
&1.4643E-01_JPRB,1.7555E-01_JPRB,1.8089E-01_JPRB,1.8028E-01_JPRB,1.7424E-01_JPRB,1.6361E-01_JPRB,&
&1.4828E-01_JPRB,1.2787E-01_JPRB,8.7984E-02_JPRB/)
KAO( :, 3, 2, 7) = (/&
&1.5117E-01_JPRB,1.8085E-01_JPRB,1.8746E-01_JPRB,1.8838E-01_JPRB,1.8361E-01_JPRB,1.7334E-01_JPRB,&
&1.5765E-01_JPRB,1.3543E-01_JPRB,9.4264E-02_JPRB/)
KAO( :, 4, 2, 7) = (/&
&1.5573E-01_JPRB,1.8623E-01_JPRB,1.9419E-01_JPRB,1.9646E-01_JPRB,1.9291E-01_JPRB,1.8328E-01_JPRB,&
&1.6725E-01_JPRB,1.4294E-01_JPRB,1.0040E-01_JPRB/)
KAO( :, 5, 2, 7) = (/&
&1.6013E-01_JPRB,1.9161E-01_JPRB,2.0111E-01_JPRB,2.0451E-01_JPRB,2.0197E-01_JPRB,1.9329E-01_JPRB,&
&1.7696E-01_JPRB,1.5031E-01_JPRB,1.0647E-01_JPRB/)
KAO( :, 1, 3, 7) = (/&
&1.2309E-01_JPRB,1.4704E-01_JPRB,1.5024E-01_JPRB,1.4812E-01_JPRB,1.4219E-01_JPRB,1.3226E-01_JPRB,&
&1.1881E-01_JPRB,1.0141E-01_JPRB,6.5459E-02_JPRB/)
KAO( :, 2, 3, 7) = (/&
&1.2767E-01_JPRB,1.5222E-01_JPRB,1.5637E-01_JPRB,1.5568E-01_JPRB,1.5055E-01_JPRB,1.4090E-01_JPRB,&
&1.2701E-01_JPRB,1.0859E-01_JPRB,7.0881E-02_JPRB/)
KAO( :, 3, 3, 7) = (/&
&1.3203E-01_JPRB,1.5727E-01_JPRB,1.6255E-01_JPRB,1.6317E-01_JPRB,1.5886E-01_JPRB,1.4989E-01_JPRB,&
&1.3559E-01_JPRB,1.1576E-01_JPRB,7.6083E-02_JPRB/)
KAO( :, 4, 3, 7) = (/&
&1.3635E-01_JPRB,1.6234E-01_JPRB,1.6898E-01_JPRB,1.7060E-01_JPRB,1.6716E-01_JPRB,1.5892E-01_JPRB,&
&1.4437E-01_JPRB,1.2295E-01_JPRB,8.1201E-02_JPRB/)
KAO( :, 5, 3, 7) = (/&
&1.4056E-01_JPRB,1.6755E-01_JPRB,1.7569E-01_JPRB,1.7797E-01_JPRB,1.7536E-01_JPRB,1.6774E-01_JPRB,&
&1.5329E-01_JPRB,1.3002E-01_JPRB,8.6370E-02_JPRB/)
KAO( :, 1, 4, 7) = (/&
&1.0694E-01_JPRB,1.2727E-01_JPRB,1.2915E-01_JPRB,1.2666E-01_JPRB,1.2117E-01_JPRB,1.1228E-01_JPRB,&
&1.0026E-01_JPRB,8.4627E-02_JPRB,5.2347E-02_JPRB/)
KAO( :, 2, 4, 7) = (/&
&1.1128E-01_JPRB,1.3208E-01_JPRB,1.3481E-01_JPRB,1.3351E-01_JPRB,1.2855E-01_JPRB,1.2006E-01_JPRB,&
&1.0771E-01_JPRB,9.1021E-02_JPRB,5.6953E-02_JPRB/)
KAO( :, 3, 4, 7) = (/&
&1.1540E-01_JPRB,1.3680E-01_JPRB,1.4057E-01_JPRB,1.4029E-01_JPRB,1.3591E-01_JPRB,1.2809E-01_JPRB,&
&1.1544E-01_JPRB,9.7575E-02_JPRB,6.1322E-02_JPRB/)
KAO( :, 4, 4, 7) = (/&
&1.1945E-01_JPRB,1.4164E-01_JPRB,1.4662E-01_JPRB,1.4706E-01_JPRB,1.4340E-01_JPRB,1.3603E-01_JPRB,&
&1.2336E-01_JPRB,1.0424E-01_JPRB,6.5662E-02_JPRB/)
KAO( :, 5, 4, 7) = (/&
&1.2340E-01_JPRB,1.4675E-01_JPRB,1.5288E-01_JPRB,1.5380E-01_JPRB,1.5079E-01_JPRB,1.4378E-01_JPRB,&
&1.3119E-01_JPRB,1.1079E-01_JPRB,7.0042E-02_JPRB/)
KAO( :, 1, 5, 7) = (/&
&9.2366E-02_JPRB,1.1024E-01_JPRB,1.1122E-01_JPRB,1.0839E-01_JPRB,1.0297E-01_JPRB,9.4813E-02_JPRB,&
&8.4116E-02_JPRB,7.0267E-02_JPRB,4.1776E-02_JPRB/)
KAO( :, 2, 5, 7) = (/&
&9.6355E-02_JPRB,1.1479E-01_JPRB,1.1644E-01_JPRB,1.1449E-01_JPRB,1.0946E-01_JPRB,1.0165E-01_JPRB,&
&9.0750E-02_JPRB,7.5967E-02_JPRB,4.5678E-02_JPRB/)
KAO( :, 3, 5, 7) = (/&
&1.0024E-01_JPRB,1.1923E-01_JPRB,1.2179E-01_JPRB,1.2053E-01_JPRB,1.1597E-01_JPRB,1.0868E-01_JPRB,&
&9.7605E-02_JPRB,8.1879E-02_JPRB,4.9420E-02_JPRB/)
KAO( :, 4, 5, 7) = (/&
&1.0406E-01_JPRB,1.2386E-01_JPRB,1.2729E-01_JPRB,1.2663E-01_JPRB,1.2262E-01_JPRB,1.1560E-01_JPRB,&
&1.0455E-01_JPRB,8.7805E-02_JPRB,5.3104E-02_JPRB/)
KAO( :, 5, 5, 7) = (/&
&1.0784E-01_JPRB,1.2877E-01_JPRB,1.3298E-01_JPRB,1.3282E-01_JPRB,1.2921E-01_JPRB,1.2238E-01_JPRB,&
&1.1132E-01_JPRB,9.3754E-02_JPRB,5.6821E-02_JPRB/)
KAO( :, 1, 6, 7) = (/&
&7.9024E-02_JPRB,9.4822E-02_JPRB,9.5344E-02_JPRB,9.2551E-02_JPRB,8.7276E-02_JPRB,7.9771E-02_JPRB,&
&7.0098E-02_JPRB,5.7834E-02_JPRB,3.3015E-02_JPRB/)
KAO( :, 2, 6, 7) = (/&
&8.2738E-02_JPRB,9.8989E-02_JPRB,1.0012E-01_JPRB,9.7961E-02_JPRB,9.2877E-02_JPRB,8.5652E-02_JPRB,&
&7.5923E-02_JPRB,6.2877E-02_JPRB,3.6314E-02_JPRB/)
KAO( :, 3, 6, 7) = (/&
&8.6408E-02_JPRB,1.0314E-01_JPRB,1.0499E-01_JPRB,1.0331E-01_JPRB,9.8576E-02_JPRB,9.1675E-02_JPRB,&
&8.1907E-02_JPRB,6.8103E-02_JPRB,3.9534E-02_JPRB/)
KAO( :, 4, 6, 7) = (/&
&9.0076E-02_JPRB,1.0755E-01_JPRB,1.1005E-01_JPRB,1.0872E-01_JPRB,1.0446E-01_JPRB,9.7640E-02_JPRB,&
&8.7824E-02_JPRB,7.3333E-02_JPRB,4.2688E-02_JPRB/)
KAO( :, 5, 6, 7) = (/&
&9.3695E-02_JPRB,1.1225E-01_JPRB,1.1524E-01_JPRB,1.1429E-01_JPRB,1.1026E-01_JPRB,1.0360E-01_JPRB,&
&9.3605E-02_JPRB,7.8587E-02_JPRB,4.5859E-02_JPRB/)
KAO( :, 1, 7, 7) = (/&
&6.7188E-02_JPRB,8.0973E-02_JPRB,8.1282E-02_JPRB,7.8604E-02_JPRB,7.3758E-02_JPRB,6.7095E-02_JPRB,&
&5.8393E-02_JPRB,4.7360E-02_JPRB,2.5942E-02_JPRB/)
KAO( :, 2, 7, 7) = (/&
&7.0634E-02_JPRB,8.4835E-02_JPRB,8.5597E-02_JPRB,8.3380E-02_JPRB,7.8711E-02_JPRB,7.2137E-02_JPRB,&
&6.3418E-02_JPRB,5.1732E-02_JPRB,2.8746E-02_JPRB/)
KAO( :, 3, 7, 7) = (/&
&7.4125E-02_JPRB,8.8733E-02_JPRB,9.0006E-02_JPRB,8.8141E-02_JPRB,8.3708E-02_JPRB,7.7276E-02_JPRB,&
&6.8516E-02_JPRB,5.6288E-02_JPRB,3.1491E-02_JPRB/)
KAO( :, 4, 7, 7) = (/&
&7.7619E-02_JPRB,9.2938E-02_JPRB,9.4622E-02_JPRB,9.3008E-02_JPRB,8.8787E-02_JPRB,8.2441E-02_JPRB,&
&7.3541E-02_JPRB,6.0853E-02_JPRB,3.4197E-02_JPRB/)
KAO( :, 5, 7, 7) = (/&
&8.1130E-02_JPRB,9.7412E-02_JPRB,9.9437E-02_JPRB,9.7963E-02_JPRB,9.3908E-02_JPRB,8.7589E-02_JPRB,&
&7.8507E-02_JPRB,6.5406E-02_JPRB,3.6876E-02_JPRB/)
KAO( :, 1, 8, 7) = (/&
&5.7087E-02_JPRB,6.8982E-02_JPRB,6.9219E-02_JPRB,6.6662E-02_JPRB,6.2257E-02_JPRB,5.6449E-02_JPRB,&
&4.8696E-02_JPRB,3.8705E-02_JPRB,2.0368E-02_JPRB/)
KAO( :, 2, 8, 7) = (/&
&6.0267E-02_JPRB,7.2661E-02_JPRB,7.3164E-02_JPRB,7.0903E-02_JPRB,6.6680E-02_JPRB,6.0863E-02_JPRB,&
&5.2991E-02_JPRB,4.2493E-02_JPRB,2.2764E-02_JPRB/)
KAO( :, 3, 8, 7) = (/&
&6.3568E-02_JPRB,7.6402E-02_JPRB,7.7191E-02_JPRB,7.5170E-02_JPRB,7.1124E-02_JPRB,6.5262E-02_JPRB,&
&5.7325E-02_JPRB,4.6424E-02_JPRB,2.5106E-02_JPRB/)
KAO( :, 4, 8, 7) = (/&
&6.6952E-02_JPRB,8.0431E-02_JPRB,8.1433E-02_JPRB,7.9580E-02_JPRB,7.5603E-02_JPRB,6.9713E-02_JPRB,&
&6.1612E-02_JPRB,5.0326E-02_JPRB,2.7428E-02_JPRB/)
KAO( :, 5, 8, 7) = (/&
&7.0374E-02_JPRB,8.4700E-02_JPRB,8.5936E-02_JPRB,8.4079E-02_JPRB,8.0117E-02_JPRB,7.4154E-02_JPRB,&
&6.5876E-02_JPRB,5.4195E-02_JPRB,2.9716E-02_JPRB/)
KAO( :, 1, 9, 7) = (/&
&4.8541E-02_JPRB,5.8698E-02_JPRB,5.8862E-02_JPRB,5.6589E-02_JPRB,5.2616E-02_JPRB,4.7478E-02_JPRB,&
&4.0621E-02_JPRB,3.1660E-02_JPRB,1.6311E-02_JPRB/)
KAO( :, 2, 9, 7) = (/&
&5.1470E-02_JPRB,6.2152E-02_JPRB,6.2537E-02_JPRB,6.0429E-02_JPRB,5.6605E-02_JPRB,5.1332E-02_JPRB,&
&4.4320E-02_JPRB,3.4891E-02_JPRB,1.8357E-02_JPRB/)
KAO( :, 3, 9, 7) = (/&
&5.4592E-02_JPRB,6.5779E-02_JPRB,6.6299E-02_JPRB,6.4328E-02_JPRB,6.0595E-02_JPRB,5.5195E-02_JPRB,&
&4.8026E-02_JPRB,3.8250E-02_JPRB,2.0370E-02_JPRB/)
KAO( :, 4, 9, 7) = (/&
&5.7857E-02_JPRB,6.9626E-02_JPRB,7.0279E-02_JPRB,6.8395E-02_JPRB,6.4585E-02_JPRB,5.9114E-02_JPRB,&
&5.1701E-02_JPRB,4.1583E-02_JPRB,2.2355E-02_JPRB/)
KAO( :, 5, 9, 7) = (/&
&6.1151E-02_JPRB,7.3773E-02_JPRB,7.4523E-02_JPRB,7.2563E-02_JPRB,6.8640E-02_JPRB,6.3021E-02_JPRB,&
&5.5368E-02_JPRB,4.4866E-02_JPRB,2.4319E-02_JPRB/)
KAO( :, 1,10, 7) = (/&
&4.1703E-02_JPRB,5.0397E-02_JPRB,5.0498E-02_JPRB,4.8532E-02_JPRB,4.5038E-02_JPRB,4.0454E-02_JPRB,&
&3.4353E-02_JPRB,2.6239E-02_JPRB,1.6946E-02_JPRB/)
KAO( :, 2,10, 7) = (/&
&4.4435E-02_JPRB,5.3723E-02_JPRB,5.3968E-02_JPRB,5.2070E-02_JPRB,4.8666E-02_JPRB,4.3928E-02_JPRB,&
&3.7574E-02_JPRB,2.9025E-02_JPRB,1.9214E-02_JPRB/)
KAO( :, 3,10, 7) = (/&
&4.7412E-02_JPRB,5.7277E-02_JPRB,5.7540E-02_JPRB,5.5713E-02_JPRB,5.2331E-02_JPRB,4.7382E-02_JPRB,&
&4.0823E-02_JPRB,3.1871E-02_JPRB,2.1538E-02_JPRB/)
KAO( :, 4,10, 7) = (/&
&5.0574E-02_JPRB,6.1042E-02_JPRB,6.1373E-02_JPRB,5.9574E-02_JPRB,5.6031E-02_JPRB,5.0898E-02_JPRB,&
&4.4058E-02_JPRB,3.4717E-02_JPRB,2.3877E-02_JPRB/)
KAO( :, 5,10, 7) = (/&
&5.3746E-02_JPRB,6.5044E-02_JPRB,6.5451E-02_JPRB,6.3520E-02_JPRB,5.9778E-02_JPRB,5.4461E-02_JPRB,&
&4.7278E-02_JPRB,3.7547E-02_JPRB,2.6231E-02_JPRB/)
KAO( :, 1,11, 7) = (/&
&3.7231E-02_JPRB,4.4782E-02_JPRB,4.4834E-02_JPRB,4.3110E-02_JPRB,4.0069E-02_JPRB,3.5931E-02_JPRB,&
&3.0502E-02_JPRB,2.3057E-02_JPRB,1.8284E-02_JPRB/)
KAO( :, 2,11, 7) = (/&
&3.9875E-02_JPRB,4.8062E-02_JPRB,4.8155E-02_JPRB,4.6465E-02_JPRB,4.3416E-02_JPRB,3.9078E-02_JPRB,&
&3.3371E-02_JPRB,2.5491E-02_JPRB,2.0825E-02_JPRB/)
KAO( :, 3,11, 7) = (/&
&4.2772E-02_JPRB,5.1583E-02_JPRB,5.1719E-02_JPRB,5.0024E-02_JPRB,4.6821E-02_JPRB,4.2262E-02_JPRB,&
&3.6260E-02_JPRB,2.7962E-02_JPRB,2.3421E-02_JPRB/)
KAO( :, 4,11, 7) = (/&
&4.5744E-02_JPRB,5.5320E-02_JPRB,5.5524E-02_JPRB,5.3716E-02_JPRB,5.0328E-02_JPRB,4.5568E-02_JPRB,&
&3.9152E-02_JPRB,3.0434E-02_JPRB,2.6081E-02_JPRB/)
KAO( :, 5,11, 7) = (/&
&4.8771E-02_JPRB,5.9196E-02_JPRB,5.9515E-02_JPRB,5.7526E-02_JPRB,5.3932E-02_JPRB,4.8905E-02_JPRB,&
&4.2062E-02_JPRB,3.2920E-02_JPRB,2.8799E-02_JPRB/)
KAO( :, 1,12, 7) = (/&
&3.3165E-02_JPRB,3.9692E-02_JPRB,3.9599E-02_JPRB,3.8024E-02_JPRB,3.5310E-02_JPRB,3.1588E-02_JPRB,&
&2.6724E-02_JPRB,2.0140E-02_JPRB,1.7962E-02_JPRB/)
KAO( :, 2,12, 7) = (/&
&3.5669E-02_JPRB,4.2809E-02_JPRB,4.2746E-02_JPRB,4.1180E-02_JPRB,3.8355E-02_JPRB,3.4405E-02_JPRB,&
&2.9261E-02_JPRB,2.2261E-02_JPRB,2.0601E-02_JPRB/)
KAO( :, 3,12, 7) = (/&
&3.8321E-02_JPRB,4.6119E-02_JPRB,4.6151E-02_JPRB,4.4514E-02_JPRB,4.1510E-02_JPRB,3.7321E-02_JPRB,&
&3.1841E-02_JPRB,2.4389E-02_JPRB,2.3308E-02_JPRB/)
KAO( :, 4,12, 7) = (/&
&4.1022E-02_JPRB,4.9612E-02_JPRB,4.9764E-02_JPRB,4.7979E-02_JPRB,4.4755E-02_JPRB,4.0343E-02_JPRB,&
&3.4469E-02_JPRB,2.6528E-02_JPRB,2.6037E-02_JPRB/)
KAO( :, 5,12, 7) = (/&
&4.3787E-02_JPRB,5.3202E-02_JPRB,5.3413E-02_JPRB,5.1511E-02_JPRB,4.8094E-02_JPRB,4.3379E-02_JPRB,&
&3.7123E-02_JPRB,2.8712E-02_JPRB,2.8765E-02_JPRB/)
KAO( :, 1,13, 7) = (/&
&2.9468E-02_JPRB,3.5299E-02_JPRB,3.5147E-02_JPRB,3.3716E-02_JPRB,3.1258E-02_JPRB,2.7857E-02_JPRB,&
&2.3479E-02_JPRB,1.7565E-02_JPRB,1.6401E-02_JPRB/)
KAO( :, 2,13, 7) = (/&
&3.1822E-02_JPRB,3.8242E-02_JPRB,3.8151E-02_JPRB,3.6698E-02_JPRB,3.4080E-02_JPRB,3.0460E-02_JPRB,&
&2.5743E-02_JPRB,1.9422E-02_JPRB,1.8869E-02_JPRB/)
KAO( :, 3,13, 7) = (/&
&3.4255E-02_JPRB,4.1360E-02_JPRB,4.1371E-02_JPRB,3.9795E-02_JPRB,3.7027E-02_JPRB,3.3168E-02_JPRB,&
&2.8068E-02_JPRB,2.1290E-02_JPRB,2.1356E-02_JPRB/)
KAO( :, 4,13, 7) = (/&
&3.6724E-02_JPRB,4.4593E-02_JPRB,4.4667E-02_JPRB,4.2990E-02_JPRB,4.0057E-02_JPRB,3.5909E-02_JPRB,&
&3.0433E-02_JPRB,2.3190E-02_JPRB,2.3849E-02_JPRB/)
KAO( :, 5,13, 7) = (/&
&3.9283E-02_JPRB,4.7884E-02_JPRB,4.8024E-02_JPRB,4.6223E-02_JPRB,4.3087E-02_JPRB,3.8671E-02_JPRB,&
&3.2860E-02_JPRB,2.5142E-02_JPRB,2.6303E-02_JPRB/)
KAO( :, 1, 1, 8) = (/&
&4.0322E-01_JPRB,4.2884E-01_JPRB,4.4287E-01_JPRB,4.4611E-01_JPRB,4.3402E-01_JPRB,4.1077E-01_JPRB,&
&3.7521E-01_JPRB,3.2697E-01_JPRB,2.6830E-01_JPRB/)
KAO( :, 2, 1, 8) = (/&
&4.1659E-01_JPRB,4.4635E-01_JPRB,4.6251E-01_JPRB,4.6551E-01_JPRB,4.5392E-01_JPRB,4.3080E-01_JPRB,&
&3.9654E-01_JPRB,3.4859E-01_JPRB,2.8992E-01_JPRB/)
KAO( :, 3, 1, 8) = (/&
&4.3066E-01_JPRB,4.6487E-01_JPRB,4.8341E-01_JPRB,4.8533E-01_JPRB,4.7318E-01_JPRB,4.5018E-01_JPRB,&
&4.1684E-01_JPRB,3.6978E-01_JPRB,3.1151E-01_JPRB/)
KAO( :, 4, 1, 8) = (/&
&4.4540E-01_JPRB,4.8420E-01_JPRB,5.0502E-01_JPRB,5.0600E-01_JPRB,4.9161E-01_JPRB,4.6895E-01_JPRB,&
&4.3612E-01_JPRB,3.9090E-01_JPRB,3.3327E-01_JPRB/)
KAO( :, 5, 1, 8) = (/&
&4.6087E-01_JPRB,5.0391E-01_JPRB,5.2680E-01_JPRB,5.2675E-01_JPRB,5.1014E-01_JPRB,4.8707E-01_JPRB,&
&4.5479E-01_JPRB,4.1126E-01_JPRB,3.5494E-01_JPRB/)
KAO( :, 1, 2, 8) = (/&
&3.6116E-01_JPRB,3.9180E-01_JPRB,4.0630E-01_JPRB,4.0741E-01_JPRB,3.9710E-01_JPRB,3.7545E-01_JPRB,&
&3.4074E-01_JPRB,2.9225E-01_JPRB,2.2503E-01_JPRB/)
KAO( :, 2, 2, 8) = (/&
&3.7429E-01_JPRB,4.0933E-01_JPRB,4.2583E-01_JPRB,4.2659E-01_JPRB,4.1646E-01_JPRB,3.9447E-01_JPRB,&
&3.6022E-01_JPRB,3.1183E-01_JPRB,2.4425E-01_JPRB/)
KAO( :, 3, 2, 8) = (/&
&3.8833E-01_JPRB,4.2821E-01_JPRB,4.4642E-01_JPRB,4.4678E-01_JPRB,4.3567E-01_JPRB,4.1270E-01_JPRB,&
&3.7849E-01_JPRB,3.3160E-01_JPRB,2.6352E-01_JPRB/)
KAO( :, 4, 2, 8) = (/&
&4.0301E-01_JPRB,4.4802E-01_JPRB,4.6770E-01_JPRB,4.6760E-01_JPRB,4.5474E-01_JPRB,4.3035E-01_JPRB,&
&3.9631E-01_JPRB,3.5077E-01_JPRB,2.8292E-01_JPRB/)
KAO( :, 5, 2, 8) = (/&
&4.1749E-01_JPRB,4.6796E-01_JPRB,4.8938E-01_JPRB,4.8856E-01_JPRB,4.7348E-01_JPRB,4.4790E-01_JPRB,&
&4.1404E-01_JPRB,3.6908E-01_JPRB,3.0219E-01_JPRB/)
KAO( :, 1, 3, 8) = (/&
&3.1836E-01_JPRB,3.5137E-01_JPRB,3.6460E-01_JPRB,3.6422E-01_JPRB,3.5477E-01_JPRB,3.3593E-01_JPRB,&
&3.0362E-01_JPRB,2.5584E-01_JPRB,1.8328E-01_JPRB/)
KAO( :, 2, 3, 8) = (/&
&3.3096E-01_JPRB,3.6850E-01_JPRB,3.8310E-01_JPRB,3.8300E-01_JPRB,3.7372E-01_JPRB,3.5449E-01_JPRB,&
&3.2124E-01_JPRB,2.7389E-01_JPRB,2.0014E-01_JPRB/)
KAO( :, 3, 3, 8) = (/&
&3.4458E-01_JPRB,3.8711E-01_JPRB,4.0276E-01_JPRB,4.0262E-01_JPRB,3.9285E-01_JPRB,3.7244E-01_JPRB,&
&3.3829E-01_JPRB,2.9150E-01_JPRB,2.1726E-01_JPRB/)
KAO( :, 4, 3, 8) = (/&
&3.5799E-01_JPRB,4.0642E-01_JPRB,4.2324E-01_JPRB,4.2311E-01_JPRB,4.1204E-01_JPRB,3.8967E-01_JPRB,&
&3.5509E-01_JPRB,3.0840E-01_JPRB,2.3441E-01_JPRB/)
KAO( :, 5, 3, 8) = (/&
&3.7101E-01_JPRB,4.2557E-01_JPRB,4.4433E-01_JPRB,4.4402E-01_JPRB,4.3131E-01_JPRB,4.0719E-01_JPRB,&
&3.7164E-01_JPRB,3.2487E-01_JPRB,2.5132E-01_JPRB/)
KAO( :, 1, 4, 8) = (/&
&2.7843E-01_JPRB,3.1174E-01_JPRB,3.2299E-01_JPRB,3.2159E-01_JPRB,3.1254E-01_JPRB,2.9513E-01_JPRB,&
&2.6711E-01_JPRB,2.2161E-01_JPRB,1.4841E-01_JPRB/)
KAO( :, 2, 4, 8) = (/&
&2.9013E-01_JPRB,3.2832E-01_JPRB,3.4033E-01_JPRB,3.3944E-01_JPRB,3.3063E-01_JPRB,3.1287E-01_JPRB,&
&2.8384E-01_JPRB,2.3810E-01_JPRB,1.6312E-01_JPRB/)
KAO( :, 3, 4, 8) = (/&
&3.0268E-01_JPRB,3.4605E-01_JPRB,3.5891E-01_JPRB,3.5819E-01_JPRB,3.4915E-01_JPRB,3.3041E-01_JPRB,&
&2.9986E-01_JPRB,2.5399E-01_JPRB,1.7819E-01_JPRB/)
KAO( :, 4, 4, 8) = (/&
&3.1479E-01_JPRB,3.6429E-01_JPRB,3.7832E-01_JPRB,3.7789E-01_JPRB,3.6791E-01_JPRB,3.4794E-01_JPRB,&
&3.1552E-01_JPRB,2.6914E-01_JPRB,1.9313E-01_JPRB/)
KAO( :, 5, 4, 8) = (/&
&3.2665E-01_JPRB,3.8187E-01_JPRB,3.9828E-01_JPRB,3.9805E-01_JPRB,3.8707E-01_JPRB,3.6554E-01_JPRB,&
&3.3111E-01_JPRB,2.8418E-01_JPRB,2.0797E-01_JPRB/)
KAO( :, 1, 5, 8) = (/&
&2.4307E-01_JPRB,2.7459E-01_JPRB,2.8334E-01_JPRB,2.8148E-01_JPRB,2.7250E-01_JPRB,2.5608E-01_JPRB,&
&2.3119E-01_JPRB,1.9095E-01_JPRB,1.1978E-01_JPRB/)
KAO( :, 2, 5, 8) = (/&
&2.5412E-01_JPRB,2.9006E-01_JPRB,2.9964E-01_JPRB,2.9834E-01_JPRB,2.8946E-01_JPRB,2.7270E-01_JPRB,&
&2.4720E-01_JPRB,2.0586E-01_JPRB,1.3250E-01_JPRB/)
KAO( :, 3, 5, 8) = (/&
&2.6544E-01_JPRB,3.0651E-01_JPRB,3.1718E-01_JPRB,3.1602E-01_JPRB,3.0707E-01_JPRB,2.8950E-01_JPRB,&
&2.6270E-01_JPRB,2.1996E-01_JPRB,1.4559E-01_JPRB/)
KAO( :, 4, 5, 8) = (/&
&2.7620E-01_JPRB,3.2315E-01_JPRB,3.3545E-01_JPRB,3.3465E-01_JPRB,3.2491E-01_JPRB,3.0648E-01_JPRB,&
&2.7754E-01_JPRB,2.3379E-01_JPRB,1.5847E-01_JPRB/)
KAO( :, 5, 5, 8) = (/&
&2.8682E-01_JPRB,3.3927E-01_JPRB,3.5367E-01_JPRB,3.5367E-01_JPRB,3.4331E-01_JPRB,3.2364E-01_JPRB,&
&2.9241E-01_JPRB,2.4747E-01_JPRB,1.7133E-01_JPRB/)
KAO( :, 1, 6, 8) = (/&
&2.1177E-01_JPRB,2.4018E-01_JPRB,2.4637E-01_JPRB,2.4351E-01_JPRB,2.3439E-01_JPRB,2.1931E-01_JPRB,&
&1.9713E-01_JPRB,1.6297E-01_JPRB,9.5914E-02_JPRB/)
KAO( :, 2, 6, 8) = (/&
&2.2169E-01_JPRB,2.5443E-01_JPRB,2.6139E-01_JPRB,2.5908E-01_JPRB,2.5022E-01_JPRB,2.3482E-01_JPRB,&
&2.1183E-01_JPRB,1.7638E-01_JPRB,1.0688E-01_JPRB/)
KAO( :, 3, 6, 8) = (/&
&2.3172E-01_JPRB,2.6938E-01_JPRB,2.7763E-01_JPRB,2.7552E-01_JPRB,2.6672E-01_JPRB,2.5051E-01_JPRB,&
&2.2626E-01_JPRB,1.8899E-01_JPRB,1.1795E-01_JPRB/)
KAO( :, 4, 6, 8) = (/&
&2.4156E-01_JPRB,2.8413E-01_JPRB,2.9429E-01_JPRB,2.9295E-01_JPRB,2.8356E-01_JPRB,2.6650E-01_JPRB,&
&2.4057E-01_JPRB,2.0157E-01_JPRB,1.2896E-01_JPRB/)
KAO( :, 5, 6, 8) = (/&
&2.5124E-01_JPRB,2.9850E-01_JPRB,3.1067E-01_JPRB,3.1041E-01_JPRB,3.0075E-01_JPRB,2.8246E-01_JPRB,&
&2.5505E-01_JPRB,2.1388E-01_JPRB,1.3998E-01_JPRB/)
KAO( :, 1, 7, 8) = (/&
&1.8473E-01_JPRB,2.0924E-01_JPRB,2.1335E-01_JPRB,2.0936E-01_JPRB,1.9988E-01_JPRB,1.8587E-01_JPRB,&
&1.6639E-01_JPRB,1.3717E-01_JPRB,7.6364E-02_JPRB/)
KAO( :, 2, 7, 8) = (/&
&1.9350E-01_JPRB,2.2219E-01_JPRB,2.2721E-01_JPRB,2.2345E-01_JPRB,2.1426E-01_JPRB,2.0011E-01_JPRB,&
&1.7972E-01_JPRB,1.4932E-01_JPRB,8.5682E-02_JPRB/)
KAO( :, 3, 7, 8) = (/&
&2.0222E-01_JPRB,2.3570E-01_JPRB,2.4195E-01_JPRB,2.3854E-01_JPRB,2.2951E-01_JPRB,2.1468E-01_JPRB,&
&1.9301E-01_JPRB,1.6077E-01_JPRB,9.5001E-02_JPRB/)
KAO( :, 4, 7, 8) = (/&
&2.1095E-01_JPRB,2.4886E-01_JPRB,2.5670E-01_JPRB,2.5432E-01_JPRB,2.4507E-01_JPRB,2.2935E-01_JPRB,&
&2.0620E-01_JPRB,1.7210E-01_JPRB,1.0440E-01_JPRB/)
KAO( :, 5, 7, 8) = (/&
&2.1973E-01_JPRB,2.6165E-01_JPRB,2.7115E-01_JPRB,2.6994E-01_JPRB,2.6086E-01_JPRB,2.4410E-01_JPRB,&
&2.1974E-01_JPRB,1.8329E-01_JPRB,1.1378E-01_JPRB/)
KAO( :, 1, 8, 8) = (/&
&1.6185E-01_JPRB,1.8253E-01_JPRB,1.8444E-01_JPRB,1.7949E-01_JPRB,1.7015E-01_JPRB,1.5690E-01_JPRB,&
&1.3935E-01_JPRB,1.1432E-01_JPRB,6.0540E-02_JPRB/)
KAO( :, 2, 8, 8) = (/&
&1.6964E-01_JPRB,1.9418E-01_JPRB,1.9717E-01_JPRB,1.9247E-01_JPRB,1.8312E-01_JPRB,1.6970E-01_JPRB,&
&1.5135E-01_JPRB,1.2506E-01_JPRB,6.8356E-02_JPRB/)
KAO( :, 3, 8, 8) = (/&
&1.7743E-01_JPRB,2.0616E-01_JPRB,2.1045E-01_JPRB,2.0623E-01_JPRB,1.9689E-01_JPRB,1.8297E-01_JPRB,&
&1.6334E-01_JPRB,1.3545E-01_JPRB,7.6236E-02_JPRB/)
KAO( :, 4, 8, 8) = (/&
&1.8525E-01_JPRB,2.1798E-01_JPRB,2.2355E-01_JPRB,2.2023E-01_JPRB,2.1094E-01_JPRB,1.9625E-01_JPRB,&
&1.7545E-01_JPRB,1.4584E-01_JPRB,8.4195E-02_JPRB/)
KAO( :, 5, 8, 8) = (/&
&1.9322E-01_JPRB,2.2966E-01_JPRB,2.3631E-01_JPRB,2.3389E-01_JPRB,2.2488E-01_JPRB,2.0966E-01_JPRB,&
&1.8787E-01_JPRB,1.5609E-01_JPRB,9.2157E-02_JPRB/)
KAO( :, 1, 9, 8) = (/&
&1.4213E-01_JPRB,1.5963E-01_JPRB,1.5968E-01_JPRB,1.5380E-01_JPRB,1.4472E-01_JPRB,1.3224E-01_JPRB,&
&1.1621E-01_JPRB,9.4456E-02_JPRB,4.8155E-02_JPRB/)
KAO( :, 2, 9, 8) = (/&
&1.4924E-01_JPRB,1.7020E-01_JPRB,1.7123E-01_JPRB,1.6570E-01_JPRB,1.5648E-01_JPRB,1.4372E-01_JPRB,&
&1.2686E-01_JPRB,1.0389E-01_JPRB,5.4797E-02_JPRB/)
KAO( :, 3, 9, 8) = (/&
&1.5626E-01_JPRB,1.8093E-01_JPRB,1.8312E-01_JPRB,1.7819E-01_JPRB,1.6892E-01_JPRB,1.5552E-01_JPRB,&
&1.3756E-01_JPRB,1.1314E-01_JPRB,6.1551E-02_JPRB/)
KAO( :, 4, 9, 8) = (/&
&1.6335E-01_JPRB,1.9168E-01_JPRB,1.9486E-01_JPRB,1.9059E-01_JPRB,1.8138E-01_JPRB,1.6740E-01_JPRB,&
&1.4849E-01_JPRB,1.2245E-01_JPRB,6.8420E-02_JPRB/)
KAO( :, 5, 9, 8) = (/&
&1.7076E-01_JPRB,2.0225E-01_JPRB,2.0643E-01_JPRB,2.0268E-01_JPRB,1.9350E-01_JPRB,1.7935E-01_JPRB,&
&1.5962E-01_JPRB,1.3184E-01_JPRB,7.5344E-02_JPRB/)
KAO( :, 1,10, 8) = (/&
&1.2689E-01_JPRB,1.4153E-01_JPRB,1.4002E-01_JPRB,1.3364E-01_JPRB,1.2448E-01_JPRB,1.1260E-01_JPRB,&
&9.7712E-02_JPRB,7.8252E-02_JPRB,4.4638E-02_JPRB/)
KAO( :, 2,10, 8) = (/&
&1.3357E-01_JPRB,1.5129E-01_JPRB,1.5077E-01_JPRB,1.4472E-01_JPRB,1.3525E-01_JPRB,1.2292E-01_JPRB,&
&1.0714E-01_JPRB,8.6493E-02_JPRB,5.1139E-02_JPRB/)
KAO( :, 3,10, 8) = (/&
&1.4033E-01_JPRB,1.6116E-01_JPRB,1.6169E-01_JPRB,1.5606E-01_JPRB,1.4653E-01_JPRB,1.3358E-01_JPRB,&
&1.1667E-01_JPRB,9.4648E-02_JPRB,5.7687E-02_JPRB/)
KAO( :, 4,10, 8) = (/&
&1.4713E-01_JPRB,1.7114E-01_JPRB,1.7244E-01_JPRB,1.6723E-01_JPRB,1.5766E-01_JPRB,1.4412E-01_JPRB,&
&1.2643E-01_JPRB,1.0289E-01_JPRB,6.4268E-02_JPRB/)
KAO( :, 5,10, 8) = (/&
&1.5435E-01_JPRB,1.8097E-01_JPRB,1.8303E-01_JPRB,1.7815E-01_JPRB,1.6844E-01_JPRB,1.5450E-01_JPRB,&
&1.3627E-01_JPRB,1.1126E-01_JPRB,7.0752E-02_JPRB/)
KAO( :, 1,11, 8) = (/&
&1.1735E-01_JPRB,1.3093E-01_JPRB,1.2881E-01_JPRB,1.2210E-01_JPRB,1.1270E-01_JPRB,1.0103E-01_JPRB,&
&8.6539E-02_JPRB,6.8130E-02_JPRB,4.9846E-02_JPRB/)
KAO( :, 2,11, 8) = (/&
&1.2384E-01_JPRB,1.4024E-01_JPRB,1.3893E-01_JPRB,1.3259E-01_JPRB,1.2292E-01_JPRB,1.1061E-01_JPRB,&
&9.5115E-02_JPRB,7.5252E-02_JPRB,5.6964E-02_JPRB/)
KAO( :, 3,11, 8) = (/&
&1.3035E-01_JPRB,1.4957E-01_JPRB,1.4914E-01_JPRB,1.4306E-01_JPRB,1.3321E-01_JPRB,1.2022E-01_JPRB,&
&1.0374E-01_JPRB,8.2465E-02_JPRB,6.4200E-02_JPRB/)
KAO( :, 4,11, 8) = (/&
&1.3725E-01_JPRB,1.5898E-01_JPRB,1.5927E-01_JPRB,1.5334E-01_JPRB,1.4326E-01_JPRB,1.2961E-01_JPRB,&
&1.1238E-01_JPRB,8.9805E-02_JPRB,7.1457E-02_JPRB/)
KAO( :, 5,11, 8) = (/&
&1.4463E-01_JPRB,1.6851E-01_JPRB,1.6933E-01_JPRB,1.6346E-01_JPRB,1.5308E-01_JPRB,1.3883E-01_JPRB,&
&1.2096E-01_JPRB,9.7193E-02_JPRB,7.8536E-02_JPRB/)
KAO( :, 1,12, 8) = (/&
&1.0640E-01_JPRB,1.1932E-01_JPRB,1.1727E-01_JPRB,1.1093E-01_JPRB,1.0195E-01_JPRB,9.0676E-02_JPRB,&
&7.6870E-02_JPRB,5.9379E-02_JPRB,5.1106E-02_JPRB/)
KAO( :, 2,12, 8) = (/&
&1.1251E-01_JPRB,1.2789E-01_JPRB,1.2658E-01_JPRB,1.2048E-01_JPRB,1.1127E-01_JPRB,9.9404E-02_JPRB,&
&8.4625E-02_JPRB,6.5652E-02_JPRB,5.8364E-02_JPRB/)
KAO( :, 3,12, 8) = (/&
&1.1894E-01_JPRB,1.3655E-01_JPRB,1.3586E-01_JPRB,1.2993E-01_JPRB,1.2048E-01_JPRB,1.0801E-01_JPRB,&
&9.2363E-02_JPRB,7.2052E-02_JPRB,6.5735E-02_JPRB/)
KAO( :, 4,12, 8) = (/&
&1.2590E-01_JPRB,1.4545E-01_JPRB,1.4519E-01_JPRB,1.3926E-01_JPRB,1.2958E-01_JPRB,1.1647E-01_JPRB,&
&9.9973E-02_JPRB,7.8534E-02_JPRB,7.3095E-02_JPRB/)
KAO( :, 5,12, 8) = (/&
&1.3337E-01_JPRB,1.5470E-01_JPRB,1.5466E-01_JPRB,1.4861E-01_JPRB,1.3857E-01_JPRB,1.2488E-01_JPRB,&
&1.0746E-01_JPRB,8.4929E-02_JPRB,8.0418E-02_JPRB/)
KAO( :, 1,13, 8) = (/&
&9.6972E-02_JPRB,1.0868E-01_JPRB,1.0670E-01_JPRB,1.0090E-01_JPRB,9.2463E-02_JPRB,8.1893E-02_JPRB,&
&6.8722E-02_JPRB,5.2187E-02_JPRB,4.8936E-02_JPRB/)
KAO( :, 2,13, 8) = (/&
&1.0286E-01_JPRB,1.1675E-01_JPRB,1.1538E-01_JPRB,1.0956E-01_JPRB,1.0086E-01_JPRB,8.9655E-02_JPRB,&
&7.5733E-02_JPRB,5.7797E-02_JPRB,5.5923E-02_JPRB/)
KAO( :, 3,13, 8) = (/&
&1.0928E-01_JPRB,1.2507E-01_JPRB,1.2410E-01_JPRB,1.1821E-01_JPRB,1.0914E-01_JPRB,9.7343E-02_JPRB,&
&8.2660E-02_JPRB,6.3457E-02_JPRB,6.3021E-02_JPRB/)
KAO( :, 4,13, 8) = (/&
&1.1629E-01_JPRB,1.3382E-01_JPRB,1.3304E-01_JPRB,1.2689E-01_JPRB,1.1743E-01_JPRB,1.0500E-01_JPRB,&
&8.9516E-02_JPRB,6.9087E-02_JPRB,7.0154E-02_JPRB/)
KAO( :, 5,13, 8) = (/&
&1.2379E-01_JPRB,1.4288E-01_JPRB,1.4218E-01_JPRB,1.3575E-01_JPRB,1.2584E-01_JPRB,1.1273E-01_JPRB,&
&9.6241E-02_JPRB,7.4622E-02_JPRB,7.7264E-02_JPRB/)
KAO( :, 1, 1, 9) = (/&
&1.3428E+00_JPRB,1.2969E+00_JPRB,1.3205E+00_JPRB,1.3175E+00_JPRB,1.2990E+00_JPRB,1.2468E+00_JPRB,&
&1.1628E+00_JPRB,1.0614E+00_JPRB,1.0372E+00_JPRB/)
KAO( :, 2, 1, 9) = (/&
&1.3746E+00_JPRB,1.3335E+00_JPRB,1.3668E+00_JPRB,1.3722E+00_JPRB,1.3567E+00_JPRB,1.3085E+00_JPRB,&
&1.2270E+00_JPRB,1.1261E+00_JPRB,1.1147E+00_JPRB/)
KAO( :, 3, 1, 9) = (/&
&1.4073E+00_JPRB,1.3698E+00_JPRB,1.4124E+00_JPRB,1.4260E+00_JPRB,1.4123E+00_JPRB,1.3693E+00_JPRB,&
&1.2904E+00_JPRB,1.1888E+00_JPRB,1.1913E+00_JPRB/)
KAO( :, 4, 1, 9) = (/&
&1.4400E+00_JPRB,1.4058E+00_JPRB,1.4573E+00_JPRB,1.4759E+00_JPRB,1.4676E+00_JPRB,1.4301E+00_JPRB,&
&1.3531E+00_JPRB,1.2469E+00_JPRB,1.2654E+00_JPRB/)
KAO( :, 5, 1, 9) = (/&
&1.4734E+00_JPRB,1.4423E+00_JPRB,1.5023E+00_JPRB,1.5245E+00_JPRB,1.5225E+00_JPRB,1.4892E+00_JPRB,&
&1.4132E+00_JPRB,1.3011E+00_JPRB,1.3376E+00_JPRB/)
KAO( :, 1, 2, 9) = (/&
&1.2829E+00_JPRB,1.2633E+00_JPRB,1.2907E+00_JPRB,1.2907E+00_JPRB,1.2660E+00_JPRB,1.2110E+00_JPRB,&
&1.1297E+00_JPRB,1.0058E+00_JPRB,9.3684E-01_JPRB/)
KAO( :, 2, 2, 9) = (/&
&1.3149E+00_JPRB,1.3008E+00_JPRB,1.3384E+00_JPRB,1.3472E+00_JPRB,1.3248E+00_JPRB,1.2742E+00_JPRB,&
&1.1952E+00_JPRB,1.0698E+00_JPRB,1.0113E+00_JPRB/)
KAO( :, 3, 2, 9) = (/&
&1.3475E+00_JPRB,1.3378E+00_JPRB,1.3854E+00_JPRB,1.4016E+00_JPRB,1.3821E+00_JPRB,1.3377E+00_JPRB,&
&1.2602E+00_JPRB,1.1308E+00_JPRB,1.0840E+00_JPRB/)
KAO( :, 4, 2, 9) = (/&
&1.3810E+00_JPRB,1.3744E+00_JPRB,1.4322E+00_JPRB,1.4528E+00_JPRB,1.4388E+00_JPRB,1.4001E+00_JPRB,&
&1.3236E+00_JPRB,1.1887E+00_JPRB,1.1546E+00_JPRB/)
KAO( :, 5, 2, 9) = (/&
&1.4157E+00_JPRB,1.4118E+00_JPRB,1.4780E+00_JPRB,1.5023E+00_JPRB,1.4957E+00_JPRB,1.4603E+00_JPRB,&
&1.3839E+00_JPRB,1.2445E+00_JPRB,1.2243E+00_JPRB/)
KAO( :, 1, 3, 9) = (/&
&1.2127E+00_JPRB,1.2149E+00_JPRB,1.2414E+00_JPRB,1.2413E+00_JPRB,1.2096E+00_JPRB,1.1509E+00_JPRB,&
&1.0693E+00_JPRB,9.3505E-01_JPRB,8.1904E-01_JPRB/)
KAO( :, 2, 3, 9) = (/&
&1.2443E+00_JPRB,1.2526E+00_JPRB,1.2906E+00_JPRB,1.2980E+00_JPRB,1.2698E+00_JPRB,1.2150E+00_JPRB,&
&1.1356E+00_JPRB,9.9732E-01_JPRB,8.8821E-01_JPRB/)
KAO( :, 3, 3, 9) = (/&
&1.2769E+00_JPRB,1.2896E+00_JPRB,1.3389E+00_JPRB,1.3532E+00_JPRB,1.3282E+00_JPRB,1.2784E+00_JPRB,&
&1.2012E+00_JPRB,1.0574E+00_JPRB,9.5592E-01_JPRB/)
KAO( :, 4, 3, 9) = (/&
&1.3109E+00_JPRB,1.3271E+00_JPRB,1.3868E+00_JPRB,1.4049E+00_JPRB,1.3857E+00_JPRB,1.3410E+00_JPRB,&
&1.2646E+00_JPRB,1.1151E+00_JPRB,1.0226E+00_JPRB/)
KAO( :, 5, 3, 9) = (/&
&1.3463E+00_JPRB,1.3657E+00_JPRB,1.4329E+00_JPRB,1.4555E+00_JPRB,1.4430E+00_JPRB,1.4020E+00_JPRB,&
&1.3252E+00_JPRB,1.1714E+00_JPRB,1.0884E+00_JPRB/)
KAO( :, 1, 4, 9) = (/&
&1.1396E+00_JPRB,1.1562E+00_JPRB,1.1826E+00_JPRB,1.1757E+00_JPRB,1.1396E+00_JPRB,1.0800E+00_JPRB,&
&9.9549E-01_JPRB,8.6118E-01_JPRB,7.0458E-01_JPRB/)
KAO( :, 2, 4, 9) = (/&
&1.1708E+00_JPRB,1.1941E+00_JPRB,1.2324E+00_JPRB,1.2326E+00_JPRB,1.2012E+00_JPRB,1.1447E+00_JPRB,&
&1.0603E+00_JPRB,9.2111E-01_JPRB,7.6931E-01_JPRB/)
KAO( :, 3, 4, 9) = (/&
&1.2031E+00_JPRB,1.2324E+00_JPRB,1.2815E+00_JPRB,1.2882E+00_JPRB,1.2607E+00_JPRB,1.2072E+00_JPRB,&
&1.1246E+00_JPRB,9.8015E-01_JPRB,8.3245E-01_JPRB/)
KAO( :, 4, 4, 9) = (/&
&1.2376E+00_JPRB,1.2714E+00_JPRB,1.3295E+00_JPRB,1.3421E+00_JPRB,1.3190E+00_JPRB,1.2690E+00_JPRB,&
&1.1874E+00_JPRB,1.0376E+00_JPRB,8.9457E-01_JPRB/)
KAO( :, 5, 4, 9) = (/&
&1.2740E+00_JPRB,1.3119E+00_JPRB,1.3762E+00_JPRB,1.3940E+00_JPRB,1.3758E+00_JPRB,1.3293E+00_JPRB,&
&1.2473E+00_JPRB,1.0924E+00_JPRB,9.5512E-01_JPRB/)
KAO( :, 1, 5, 9) = (/&
&1.0676E+00_JPRB,1.0934E+00_JPRB,1.1164E+00_JPRB,1.1017E+00_JPRB,1.0618E+00_JPRB,1.0031E+00_JPRB,&
&9.1670E-01_JPRB,7.8582E-01_JPRB,6.0004E-01_JPRB/)
KAO( :, 2, 5, 9) = (/&
&1.0980E+00_JPRB,1.1317E+00_JPRB,1.1657E+00_JPRB,1.1576E+00_JPRB,1.1232E+00_JPRB,1.0675E+00_JPRB,&
&9.7913E-01_JPRB,8.4460E-01_JPRB,6.6026E-01_JPRB/)
KAO( :, 3, 5, 9) = (/&
&1.1299E+00_JPRB,1.1708E+00_JPRB,1.2140E+00_JPRB,1.2133E+00_JPRB,1.1840E+00_JPRB,1.1288E+00_JPRB,&
&1.0409E+00_JPRB,9.0310E-01_JPRB,7.1874E-01_JPRB/)
KAO( :, 4, 5, 9) = (/&
&1.1642E+00_JPRB,1.2107E+00_JPRB,1.2614E+00_JPRB,1.2677E+00_JPRB,1.2424E+00_JPRB,1.1890E+00_JPRB,&
&1.1017E+00_JPRB,9.5891E-01_JPRB,7.7564E-01_JPRB/)
KAO( :, 5, 5, 9) = (/&
&1.2000E+00_JPRB,1.2526E+00_JPRB,1.3091E+00_JPRB,1.3207E+00_JPRB,1.2994E+00_JPRB,1.2483E+00_JPRB,&
&1.1609E+00_JPRB,1.0119E+00_JPRB,8.3130E-01_JPRB/)
KAO( :, 1, 6, 9) = (/&
&9.9003E-01_JPRB,1.0258E+00_JPRB,1.0412E+00_JPRB,1.0201E+00_JPRB,9.7779E-01_JPRB,9.1873E-01_JPRB,&
&8.3216E-01_JPRB,7.0459E-01_JPRB,5.0433E-01_JPRB/)
KAO( :, 2, 6, 9) = (/&
&1.0190E+00_JPRB,1.0642E+00_JPRB,1.0886E+00_JPRB,1.0744E+00_JPRB,1.0384E+00_JPRB,9.8045E-01_JPRB,&
&8.9228E-01_JPRB,7.6180E-01_JPRB,5.5916E-01_JPRB/)
KAO( :, 3, 6, 9) = (/&
&1.0499E+00_JPRB,1.1031E+00_JPRB,1.1353E+00_JPRB,1.1293E+00_JPRB,1.0979E+00_JPRB,1.0403E+00_JPRB,&
&9.5155E-01_JPRB,8.1856E-01_JPRB,6.1244E-01_JPRB/)
KAO( :, 4, 6, 9) = (/&
&1.0828E+00_JPRB,1.1437E+00_JPRB,1.1824E+00_JPRB,1.1833E+00_JPRB,1.1555E+00_JPRB,1.0993E+00_JPRB,&
&1.0102E+00_JPRB,8.7279E-01_JPRB,6.6433E-01_JPRB/)
KAO( :, 5, 6, 9) = (/&
&1.1175E+00_JPRB,1.1857E+00_JPRB,1.2305E+00_JPRB,1.2360E+00_JPRB,1.2119E+00_JPRB,1.1569E+00_JPRB,&
&1.0670E+00_JPRB,9.2416E-01_JPRB,7.1591E-01_JPRB/)
KAO( :, 1, 7, 9) = (/&
&9.0622E-01_JPRB,9.5046E-01_JPRB,9.6089E-01_JPRB,9.3711E-01_JPRB,8.9284E-01_JPRB,8.3176E-01_JPRB,&
&7.4643E-01_JPRB,6.2447E-01_JPRB,4.1858E-01_JPRB/)
KAO( :, 2, 7, 9) = (/&
&9.3396E-01_JPRB,9.8759E-01_JPRB,1.0065E+00_JPRB,9.8973E-01_JPRB,9.5076E-01_JPRB,8.9008E-01_JPRB,&
&8.0412E-01_JPRB,6.7884E-01_JPRB,4.6801E-01_JPRB/)
KAO( :, 3, 7, 9) = (/&
&9.6319E-01_JPRB,1.0255E+00_JPRB,1.0520E+00_JPRB,1.0425E+00_JPRB,1.0071E+00_JPRB,9.4738E-01_JPRB,&
&8.6097E-01_JPRB,7.3289E-01_JPRB,5.1587E-01_JPRB/)
KAO( :, 4, 7, 9) = (/&
&9.9431E-01_JPRB,1.0653E+00_JPRB,1.0986E+00_JPRB,1.0946E+00_JPRB,1.0623E+00_JPRB,1.0043E+00_JPRB,&
&9.1723E-01_JPRB,7.8478E-01_JPRB,5.6306E-01_JPRB/)
KAO( :, 5, 7, 9) = (/&
&1.0274E+00_JPRB,1.1069E+00_JPRB,1.1469E+00_JPRB,1.1464E+00_JPRB,1.1172E+00_JPRB,1.0599E+00_JPRB,&
&9.7098E-01_JPRB,8.3391E-01_JPRB,6.1058E-01_JPRB/)
KAO( :, 1, 8, 9) = (/&
&8.1868E-01_JPRB,8.7029E-01_JPRB,8.7676E-01_JPRB,8.5425E-01_JPRB,8.0979E-01_JPRB,7.4690E-01_JPRB,&
&6.6276E-01_JPRB,5.4807E-01_JPRB,3.4321E-01_JPRB/)
KAO( :, 2, 8, 9) = (/&
&8.4618E-01_JPRB,9.0631E-01_JPRB,9.1992E-01_JPRB,9.0408E-01_JPRB,8.6387E-01_JPRB,8.0135E-01_JPRB,&
&7.1759E-01_JPRB,5.9903E-01_JPRB,3.8705E-01_JPRB/)
KAO( :, 3, 8, 9) = (/&
&8.7480E-01_JPRB,9.4290E-01_JPRB,9.6372E-01_JPRB,9.5463E-01_JPRB,9.1665E-01_JPRB,8.5535E-01_JPRB,&
&7.7165E-01_JPRB,6.4994E-01_JPRB,4.2964E-01_JPRB/)
KAO( :, 4, 8, 9) = (/&
&9.0487E-01_JPRB,9.8122E-01_JPRB,1.0094E+00_JPRB,1.0045E+00_JPRB,9.6889E-01_JPRB,9.0941E-01_JPRB,&
&8.2521E-01_JPRB,6.9828E-01_JPRB,4.7251E-01_JPRB/)
KAO( :, 5, 8, 9) = (/&
&9.3640E-01_JPRB,1.0212E+00_JPRB,1.0569E+00_JPRB,1.0548E+00_JPRB,1.0212E+00_JPRB,9.6279E-01_JPRB,&
&8.7575E-01_JPRB,7.4474E-01_JPRB,5.1556E-01_JPRB/)
KAO( :, 1, 9, 9) = (/&
&7.3248E-01_JPRB,7.8661E-01_JPRB,7.9076E-01_JPRB,7.6949E-01_JPRB,7.2749E-01_JPRB,6.6515E-01_JPRB,&
&5.8393E-01_JPRB,4.7588E-01_JPRB,2.7793E-01_JPRB/)
KAO( :, 2, 9, 9) = (/&
&7.5864E-01_JPRB,8.2147E-01_JPRB,8.3210E-01_JPRB,8.1596E-01_JPRB,7.7766E-01_JPRB,7.1604E-01_JPRB,&
&6.3458E-01_JPRB,5.2262E-01_JPRB,3.1673E-01_JPRB/)
KAO( :, 3, 9, 9) = (/&
&7.8652E-01_JPRB,8.5723E-01_JPRB,8.7381E-01_JPRB,8.6296E-01_JPRB,8.2677E-01_JPRB,7.6708E-01_JPRB,&
&6.8470E-01_JPRB,5.6962E-01_JPRB,3.5494E-01_JPRB/)
KAO( :, 4, 9, 9) = (/&
&8.1572E-01_JPRB,8.9416E-01_JPRB,9.1752E-01_JPRB,9.1007E-01_JPRB,8.7613E-01_JPRB,8.1762E-01_JPRB,&
&7.3487E-01_JPRB,6.1457E-01_JPRB,3.9372E-01_JPRB/)
KAO( :, 5, 9, 9) = (/&
&8.4624E-01_JPRB,9.3262E-01_JPRB,9.6268E-01_JPRB,9.5791E-01_JPRB,9.2621E-01_JPRB,8.6785E-01_JPRB,&
&7.8234E-01_JPRB,6.5797E-01_JPRB,4.3237E-01_JPRB/)
KAO( :, 1,10, 9) = (/&
&6.5285E-01_JPRB,7.0556E-01_JPRB,7.0877E-01_JPRB,6.8957E-01_JPRB,6.5004E-01_JPRB,5.9094E-01_JPRB,&
&5.1435E-01_JPRB,4.1208E-01_JPRB,2.3031E-01_JPRB/)
KAO( :, 2,10, 9) = (/&
&6.7792E-01_JPRB,7.3916E-01_JPRB,7.4857E-01_JPRB,7.3319E-01_JPRB,6.9544E-01_JPRB,6.3833E-01_JPRB,&
&5.6078E-01_JPRB,4.5470E-01_JPRB,2.6518E-01_JPRB/)
KAO( :, 3,10, 9) = (/&
&7.0469E-01_JPRB,7.7387E-01_JPRB,7.8906E-01_JPRB,7.7634E-01_JPRB,7.4114E-01_JPRB,6.8557E-01_JPRB,&
&6.0667E-01_JPRB,4.9747E-01_JPRB,3.0039E-01_JPRB/)
KAO( :, 4,10, 9) = (/&
&7.3310E-01_JPRB,8.1001E-01_JPRB,8.3104E-01_JPRB,8.2017E-01_JPRB,7.8729E-01_JPRB,7.3297E-01_JPRB,&
&6.5240E-01_JPRB,5.3892E-01_JPRB,3.3590E-01_JPRB/)
KAO( :, 5,10, 9) = (/&
&7.6290E-01_JPRB,8.4760E-01_JPRB,8.7394E-01_JPRB,8.6505E-01_JPRB,8.3426E-01_JPRB,7.8012E-01_JPRB,&
&6.9636E-01_JPRB,5.7926E-01_JPRB,3.7143E-01_JPRB/)
KAO( :, 1,11, 9) = (/&
&5.9090E-01_JPRB,6.4305E-01_JPRB,6.4751E-01_JPRB,6.3053E-01_JPRB,5.9455E-01_JPRB,5.4070E-01_JPRB,&
&4.6893E-01_JPRB,3.7172E-01_JPRB,2.1405E-01_JPRB/)
KAO( :, 2,11, 9) = (/&
&6.1610E-01_JPRB,6.7624E-01_JPRB,6.8614E-01_JPRB,6.7105E-01_JPRB,6.3688E-01_JPRB,5.8397E-01_JPRB,&
&5.1072E-01_JPRB,4.1032E-01_JPRB,2.4686E-01_JPRB/)
KAO( :, 3,11, 9) = (/&
&6.4345E-01_JPRB,7.1119E-01_JPRB,7.2537E-01_JPRB,7.1231E-01_JPRB,6.7967E-01_JPRB,6.2716E-01_JPRB,&
&5.5288E-01_JPRB,4.4844E-01_JPRB,2.7991E-01_JPRB/)
KAO( :, 4,11, 9) = (/&
&6.7245E-01_JPRB,7.4763E-01_JPRB,7.6564E-01_JPRB,7.5469E-01_JPRB,7.2271E-01_JPRB,6.7051E-01_JPRB,&
&5.9423E-01_JPRB,4.8613E-01_JPRB,3.1288E-01_JPRB/)
KAO( :, 5,11, 9) = (/&
&7.0307E-01_JPRB,7.8557E-01_JPRB,8.0692E-01_JPRB,7.9786E-01_JPRB,7.6651E-01_JPRB,7.1310E-01_JPRB,&
&6.3521E-01_JPRB,5.2316E-01_JPRB,3.4596E-01_JPRB/)
KAO( :, 1,12, 9) = (/&
&5.3439E-01_JPRB,5.8391E-01_JPRB,5.8774E-01_JPRB,5.7122E-01_JPRB,5.3863E-01_JPRB,4.9053E-01_JPRB,&
&4.2331E-01_JPRB,3.3386E-01_JPRB,2.0991E-01_JPRB/)
KAO( :, 2,12, 9) = (/&
&5.5981E-01_JPRB,6.1691E-01_JPRB,6.2491E-01_JPRB,6.0974E-01_JPRB,5.7829E-01_JPRB,5.2963E-01_JPRB,&
&4.6106E-01_JPRB,3.6833E-01_JPRB,2.4202E-01_JPRB/)
KAO( :, 3,12, 9) = (/&
&5.8729E-01_JPRB,6.5190E-01_JPRB,6.6281E-01_JPRB,6.4965E-01_JPRB,6.1814E-01_JPRB,5.6902E-01_JPRB,&
&4.9887E-01_JPRB,4.0268E-01_JPRB,2.7433E-01_JPRB/)
KAO( :, 4,12, 9) = (/&
&6.1659E-01_JPRB,6.8828E-01_JPRB,7.0203E-01_JPRB,6.9007E-01_JPRB,6.5880E-01_JPRB,6.0818E-01_JPRB,&
&5.3678E-01_JPRB,4.3667E-01_JPRB,3.0656E-01_JPRB/)
KAO( :, 5,12, 9) = (/&
&6.4762E-01_JPRB,7.2645E-01_JPRB,7.4237E-01_JPRB,7.3145E-01_JPRB,6.9915E-01_JPRB,6.4741E-01_JPRB,&
&5.7484E-01_JPRB,4.6985E-01_JPRB,3.3881E-01_JPRB/)
KAO( :, 1,13, 9) = (/&
&4.8753E-01_JPRB,5.3273E-01_JPRB,5.3419E-01_JPRB,5.1662E-01_JPRB,4.8575E-01_JPRB,4.4090E-01_JPRB,&
&3.7978E-01_JPRB,2.9794E-01_JPRB,2.0545E-01_JPRB/)
KAO( :, 2,13, 9) = (/&
&5.1376E-01_JPRB,5.6597E-01_JPRB,5.6993E-01_JPRB,5.5397E-01_JPRB,5.2292E-01_JPRB,4.7698E-01_JPRB,&
&4.1398E-01_JPRB,3.2894E-01_JPRB,2.3666E-01_JPRB/)
KAO( :, 3,13, 9) = (/&
&5.4228E-01_JPRB,6.0098E-01_JPRB,6.0712E-01_JPRB,5.9219E-01_JPRB,5.6068E-01_JPRB,5.1331E-01_JPRB,&
&4.4847E-01_JPRB,3.5992E-01_JPRB,2.6838E-01_JPRB/)
KAO( :, 4,13, 9) = (/&
&5.7239E-01_JPRB,6.3765E-01_JPRB,6.4572E-01_JPRB,6.3133E-01_JPRB,5.9865E-01_JPRB,5.5003E-01_JPRB,&
&4.8326E-01_JPRB,3.9056E-01_JPRB,3.0014E-01_JPRB/)
KAO( :, 5,13, 9) = (/&
&6.0266E-01_JPRB,6.7556E-01_JPRB,6.8531E-01_JPRB,6.7067E-01_JPRB,6.3710E-01_JPRB,5.8691E-01_JPRB,&
&5.1750E-01_JPRB,4.2055E-01_JPRB,3.3173E-01_JPRB/)
KAO( :, 1, 1,10) = (/&
&3.6294E+00_JPRB,3.2562E+00_JPRB,3.2368E+00_JPRB,3.0996E+00_JPRB,2.9830E+00_JPRB,2.8753E+00_JPRB,&
&2.7749E+00_JPRB,2.5993E+00_JPRB,2.8111E+00_JPRB/)
KAO( :, 2, 1,10) = (/&
&3.7112E+00_JPRB,3.3258E+00_JPRB,3.3100E+00_JPRB,3.2079E+00_JPRB,3.1384E+00_JPRB,3.0034E+00_JPRB,&
&2.8949E+00_JPRB,2.7070E+00_JPRB,3.0039E+00_JPRB/)
KAO( :, 3, 1,10) = (/&
&3.7891E+00_JPRB,3.3949E+00_JPRB,3.3824E+00_JPRB,3.3195E+00_JPRB,3.2833E+00_JPRB,3.1133E+00_JPRB,&
&3.0142E+00_JPRB,2.8340E+00_JPRB,3.1933E+00_JPRB/)
KAO( :, 4, 1,10) = (/&
&3.8594E+00_JPRB,3.4595E+00_JPRB,3.4534E+00_JPRB,3.4596E+00_JPRB,3.3989E+00_JPRB,3.2137E+00_JPRB,&
&3.1290E+00_JPRB,2.9765E+00_JPRB,3.3923E+00_JPRB/)
KAO( :, 5, 1,10) = (/&
&3.9199E+00_JPRB,3.5165E+00_JPRB,3.5128E+00_JPRB,3.5924E+00_JPRB,3.4985E+00_JPRB,3.3169E+00_JPRB,&
&3.2426E+00_JPRB,3.1423E+00_JPRB,3.5829E+00_JPRB/)
KAO( :, 1, 2,10) = (/&
&3.6408E+00_JPRB,3.2851E+00_JPRB,3.3076E+00_JPRB,3.2113E+00_JPRB,3.1456E+00_JPRB,3.0206E+00_JPRB,&
&2.7332E+00_JPRB,2.5617E+00_JPRB,2.6956E+00_JPRB/)
KAO( :, 2, 2,10) = (/&
&3.7247E+00_JPRB,3.3643E+00_JPRB,3.3883E+00_JPRB,3.3308E+00_JPRB,3.3119E+00_JPRB,3.1672E+00_JPRB,&
&2.8664E+00_JPRB,2.6839E+00_JPRB,2.9052E+00_JPRB/)
KAO( :, 3, 2,10) = (/&
&3.8049E+00_JPRB,3.4403E+00_JPRB,3.4728E+00_JPRB,3.4603E+00_JPRB,3.4644E+00_JPRB,3.2894E+00_JPRB,&
&2.9956E+00_JPRB,2.7983E+00_JPRB,3.1071E+00_JPRB/)
KAO( :, 4, 2,10) = (/&
&3.8732E+00_JPRB,3.5109E+00_JPRB,3.5452E+00_JPRB,3.6076E+00_JPRB,3.5864E+00_JPRB,3.4101E+00_JPRB,&
&3.1230E+00_JPRB,2.9350E+00_JPRB,3.3150E+00_JPRB/)
KAO( :, 5, 2,10) = (/&
&3.9409E+00_JPRB,3.5762E+00_JPRB,3.6198E+00_JPRB,3.7407E+00_JPRB,3.6919E+00_JPRB,3.5308E+00_JPRB,&
&3.2386E+00_JPRB,3.0801E+00_JPRB,3.5151E+00_JPRB/)
KAO( :, 1, 3,10) = (/&
&3.5736E+00_JPRB,3.2584E+00_JPRB,3.3139E+00_JPRB,3.2719E+00_JPRB,3.2271E+00_JPRB,3.0778E+00_JPRB,&
&2.7397E+00_JPRB,2.4788E+00_JPRB,2.5395E+00_JPRB/)
KAO( :, 2, 3,10) = (/&
&3.6594E+00_JPRB,3.3492E+00_JPRB,3.4059E+00_JPRB,3.4088E+00_JPRB,3.3945E+00_JPRB,3.2416E+00_JPRB,&
&2.8874E+00_JPRB,2.6220E+00_JPRB,2.7498E+00_JPRB/)
KAO( :, 3, 3,10) = (/&
&3.7370E+00_JPRB,3.4383E+00_JPRB,3.4999E+00_JPRB,3.5416E+00_JPRB,3.5599E+00_JPRB,3.3810E+00_JPRB,&
&3.0257E+00_JPRB,2.7502E+00_JPRB,2.9649E+00_JPRB/)
KAO( :, 4, 3,10) = (/&
&3.8104E+00_JPRB,3.5143E+00_JPRB,3.5877E+00_JPRB,3.6896E+00_JPRB,3.6976E+00_JPRB,3.5128E+00_JPRB,&
&3.1541E+00_JPRB,2.8734E+00_JPRB,3.1792E+00_JPRB/)
KAO( :, 5, 3,10) = (/&
&3.8817E+00_JPRB,3.5850E+00_JPRB,3.6770E+00_JPRB,3.8155E+00_JPRB,3.8142E+00_JPRB,3.6439E+00_JPRB,&
&3.2832E+00_JPRB,2.9977E+00_JPRB,3.3829E+00_JPRB/)
KAO( :, 1, 4,10) = (/&
&3.4322E+00_JPRB,3.2007E+00_JPRB,3.2659E+00_JPRB,3.2997E+00_JPRB,3.2447E+00_JPRB,3.0584E+00_JPRB,&
&2.7371E+00_JPRB,2.3518E+00_JPRB,2.3300E+00_JPRB/)
KAO( :, 2, 4,10) = (/&
&3.5196E+00_JPRB,3.3050E+00_JPRB,3.3731E+00_JPRB,3.4388E+00_JPRB,3.4095E+00_JPRB,3.2370E+00_JPRB,&
&2.9126E+00_JPRB,2.5092E+00_JPRB,2.5309E+00_JPRB/)
KAO( :, 3, 4,10) = (/&
&3.5985E+00_JPRB,3.3943E+00_JPRB,3.4756E+00_JPRB,3.5772E+00_JPRB,3.5742E+00_JPRB,3.4032E+00_JPRB,&
&3.0669E+00_JPRB,2.6516E+00_JPRB,2.7458E+00_JPRB/)
KAO( :, 4, 4,10) = (/&
&3.6770E+00_JPRB,3.4750E+00_JPRB,3.5775E+00_JPRB,3.7106E+00_JPRB,3.7325E+00_JPRB,3.5499E+00_JPRB,&
&3.2119E+00_JPRB,2.7759E+00_JPRB,2.9618E+00_JPRB/)
KAO( :, 5, 4,10) = (/&
&3.7553E+00_JPRB,3.5545E+00_JPRB,3.6854E+00_JPRB,3.8420E+00_JPRB,3.8679E+00_JPRB,3.6893E+00_JPRB,&
&3.3628E+00_JPRB,2.8870E+00_JPRB,3.1717E+00_JPRB/)
KAO( :, 1, 5,10) = (/&
&3.2373E+00_JPRB,3.1117E+00_JPRB,3.1778E+00_JPRB,3.2611E+00_JPRB,3.1950E+00_JPRB,2.9886E+00_JPRB,&
&2.6929E+00_JPRB,2.2194E+00_JPRB,2.0888E+00_JPRB/)
KAO( :, 2, 5,10) = (/&
&3.3227E+00_JPRB,3.2184E+00_JPRB,3.2899E+00_JPRB,3.4098E+00_JPRB,3.3633E+00_JPRB,3.1652E+00_JPRB,&
&2.8940E+00_JPRB,2.3720E+00_JPRB,2.2795E+00_JPRB/)
KAO( :, 3, 5,10) = (/&
&3.4108E+00_JPRB,3.3097E+00_JPRB,3.4099E+00_JPRB,3.5509E+00_JPRB,3.5204E+00_JPRB,3.3546E+00_JPRB,&
&3.0628E+00_JPRB,2.5129E+00_JPRB,2.4816E+00_JPRB/)
KAO( :, 4, 5,10) = (/&
&3.5003E+00_JPRB,3.3952E+00_JPRB,3.5314E+00_JPRB,3.6804E+00_JPRB,3.6822E+00_JPRB,3.5261E+00_JPRB,&
&3.2230E+00_JPRB,2.6514E+00_JPRB,2.6958E+00_JPRB/)
KAO( :, 5, 5,10) = (/&
&3.5863E+00_JPRB,3.4801E+00_JPRB,3.6493E+00_JPRB,3.8038E+00_JPRB,3.8198E+00_JPRB,3.6739E+00_JPRB,&
&3.3792E+00_JPRB,2.7781E+00_JPRB,2.9109E+00_JPRB/)
KAO( :, 1, 6,10) = (/&
&3.0445E+00_JPRB,2.9620E+00_JPRB,3.0571E+00_JPRB,3.1457E+00_JPRB,3.0759E+00_JPRB,2.8664E+00_JPRB,&
&2.5916E+00_JPRB,2.1266E+00_JPRB,1.8296E+00_JPRB/)
KAO( :, 2, 6,10) = (/&
&3.1336E+00_JPRB,3.0624E+00_JPRB,3.1925E+00_JPRB,3.2966E+00_JPRB,3.2392E+00_JPRB,3.0536E+00_JPRB,&
&2.7999E+00_JPRB,2.2755E+00_JPRB,2.0164E+00_JPRB/)
KAO( :, 3, 6,10) = (/&
&3.2251E+00_JPRB,3.1623E+00_JPRB,3.3255E+00_JPRB,3.4339E+00_JPRB,3.3902E+00_JPRB,3.2529E+00_JPRB,&
&2.9818E+00_JPRB,2.4175E+00_JPRB,2.2137E+00_JPRB/)
KAO( :, 4, 6,10) = (/&
&3.3171E+00_JPRB,3.2585E+00_JPRB,3.4579E+00_JPRB,3.5597E+00_JPRB,3.5496E+00_JPRB,3.4294E+00_JPRB,&
&3.1517E+00_JPRB,2.5627E+00_JPRB,2.4250E+00_JPRB/)
KAO( :, 5, 6,10) = (/&
&3.4116E+00_JPRB,3.3553E+00_JPRB,3.5847E+00_JPRB,3.6942E+00_JPRB,3.6982E+00_JPRB,3.5971E+00_JPRB,&
&3.3128E+00_JPRB,2.7040E+00_JPRB,2.6238E+00_JPRB/)
KAO( :, 1, 7,10) = (/&
&2.9086E+00_JPRB,2.8374E+00_JPRB,2.9280E+00_JPRB,2.9562E+00_JPRB,2.8965E+00_JPRB,2.7121E+00_JPRB,&
&2.4469E+00_JPRB,2.0175E+00_JPRB,1.5788E+00_JPRB/)
KAO( :, 2, 7,10) = (/&
&2.9988E+00_JPRB,2.9438E+00_JPRB,3.0639E+00_JPRB,3.1077E+00_JPRB,3.0554E+00_JPRB,2.9073E+00_JPRB,&
&2.6439E+00_JPRB,2.1750E+00_JPRB,1.7618E+00_JPRB/)
KAO( :, 3, 7,10) = (/&
&3.0933E+00_JPRB,3.0485E+00_JPRB,3.1991E+00_JPRB,3.2496E+00_JPRB,3.2138E+00_JPRB,3.1110E+00_JPRB,&
&2.8275E+00_JPRB,2.3269E+00_JPRB,1.9611E+00_JPRB/)
KAO( :, 4, 7,10) = (/&
&3.1882E+00_JPRB,3.1521E+00_JPRB,3.3306E+00_JPRB,3.3838E+00_JPRB,3.3832E+00_JPRB,3.2822E+00_JPRB,&
&2.9996E+00_JPRB,2.4824E+00_JPRB,2.1592E+00_JPRB/)
KAO( :, 5, 7,10) = (/&
&3.2780E+00_JPRB,3.2584E+00_JPRB,3.4493E+00_JPRB,3.5229E+00_JPRB,3.5250E+00_JPRB,3.4373E+00_JPRB,&
&3.1721E+00_JPRB,2.6319E+00_JPRB,2.3379E+00_JPRB/)
KAO( :, 1, 8,10) = (/&
&2.8154E+00_JPRB,2.7401E+00_JPRB,2.8041E+00_JPRB,2.7499E+00_JPRB,2.6697E+00_JPRB,2.5266E+00_JPRB,&
&2.2797E+00_JPRB,1.8696E+00_JPRB,1.3559E+00_JPRB/)
KAO( :, 2, 8,10) = (/&
&2.8912E+00_JPRB,2.8557E+00_JPRB,2.9355E+00_JPRB,2.8974E+00_JPRB,2.8365E+00_JPRB,2.7206E+00_JPRB,&
&2.4626E+00_JPRB,2.0339E+00_JPRB,1.5286E+00_JPRB/)
KAO( :, 3, 8,10) = (/&
&2.9739E+00_JPRB,2.9692E+00_JPRB,3.0667E+00_JPRB,3.0335E+00_JPRB,3.0033E+00_JPRB,2.9063E+00_JPRB,&
&2.6365E+00_JPRB,2.1906E+00_JPRB,1.7207E+00_JPRB/)
KAO( :, 4, 8,10) = (/&
&3.0589E+00_JPRB,3.0798E+00_JPRB,3.1911E+00_JPRB,3.1726E+00_JPRB,3.1737E+00_JPRB,3.0654E+00_JPRB,&
&2.8021E+00_JPRB,2.3587E+00_JPRB,1.9007E+00_JPRB/)
KAO( :, 5, 8,10) = (/&
&3.1452E+00_JPRB,3.1888E+00_JPRB,3.3008E+00_JPRB,3.3242E+00_JPRB,3.3225E+00_JPRB,3.2145E+00_JPRB,&
&2.9803E+00_JPRB,2.5138E+00_JPRB,2.0640E+00_JPRB/)
KAO( :, 1, 9,10) = (/&
&2.7071E+00_JPRB,2.6491E+00_JPRB,2.6723E+00_JPRB,2.5686E+00_JPRB,2.4536E+00_JPRB,2.3106E+00_JPRB,&
&2.0811E+00_JPRB,1.6991E+00_JPRB,1.1509E+00_JPRB/)
KAO( :, 2, 9,10) = (/&
&2.7701E+00_JPRB,2.7593E+00_JPRB,2.7975E+00_JPRB,2.7179E+00_JPRB,2.6123E+00_JPRB,2.4920E+00_JPRB,&
&2.2565E+00_JPRB,1.8667E+00_JPRB,1.3080E+00_JPRB/)
KAO( :, 3, 9,10) = (/&
&2.8376E+00_JPRB,2.8669E+00_JPRB,2.9292E+00_JPRB,2.8584E+00_JPRB,2.7770E+00_JPRB,2.6567E+00_JPRB,&
&2.4289E+00_JPRB,2.0233E+00_JPRB,1.4827E+00_JPRB/)
KAO( :, 4, 9,10) = (/&
&2.9092E+00_JPRB,2.9736E+00_JPRB,3.0528E+00_JPRB,3.0034E+00_JPRB,2.9332E+00_JPRB,2.8084E+00_JPRB,&
&2.5864E+00_JPRB,2.1897E+00_JPRB,1.6436E+00_JPRB/)
KAO( :, 5, 9,10) = (/&
&2.9831E+00_JPRB,3.0790E+00_JPRB,3.1648E+00_JPRB,3.1509E+00_JPRB,3.0739E+00_JPRB,2.9530E+00_JPRB,&
&2.7530E+00_JPRB,2.3477E+00_JPRB,1.7965E+00_JPRB/)
KAO( :, 1,10,10) = (/&
&2.5846E+00_JPRB,2.5566E+00_JPRB,2.5335E+00_JPRB,2.4083E+00_JPRB,2.2712E+00_JPRB,2.1147E+00_JPRB,&
&1.8770E+00_JPRB,1.5356E+00_JPRB,9.6607E-01_JPRB/)
KAO( :, 2,10,10) = (/&
&2.6440E+00_JPRB,2.6579E+00_JPRB,2.6475E+00_JPRB,2.5522E+00_JPRB,2.4355E+00_JPRB,2.2753E+00_JPRB,&
&2.0432E+00_JPRB,1.6979E+00_JPRB,1.1107E+00_JPRB/)
KAO( :, 3,10,10) = (/&
&2.7001E+00_JPRB,2.7579E+00_JPRB,2.7665E+00_JPRB,2.7021E+00_JPRB,2.5868E+00_JPRB,2.4222E+00_JPRB,&
&2.2111E+00_JPRB,1.8498E+00_JPRB,1.2644E+00_JPRB/)
KAO( :, 4,10,10) = (/&
&2.7579E+00_JPRB,2.8520E+00_JPRB,2.8806E+00_JPRB,2.8506E+00_JPRB,2.7323E+00_JPRB,2.5633E+00_JPRB,&
&2.3644E+00_JPRB,2.0104E+00_JPRB,1.4137E+00_JPRB/)
KAO( :, 5,10,10) = (/&
&2.8173E+00_JPRB,2.9491E+00_JPRB,2.9936E+00_JPRB,2.9898E+00_JPRB,2.8664E+00_JPRB,2.7018E+00_JPRB,&
&2.5230E+00_JPRB,2.1562E+00_JPRB,1.5648E+00_JPRB/)
KAO( :, 1,11,10) = (/&
&2.4512E+00_JPRB,2.4863E+00_JPRB,2.4335E+00_JPRB,2.3107E+00_JPRB,2.1733E+00_JPRB,1.9977E+00_JPRB,&
&1.7582E+00_JPRB,1.4416E+00_JPRB,8.5970E-01_JPRB/)
KAO( :, 2,11,10) = (/&
&2.5092E+00_JPRB,2.5823E+00_JPRB,2.5374E+00_JPRB,2.4481E+00_JPRB,2.3213E+00_JPRB,2.1404E+00_JPRB,&
&1.9153E+00_JPRB,1.5898E+00_JPRB,9.9211E-01_JPRB/)
KAO( :, 3,11,10) = (/&
&2.5638E+00_JPRB,2.6670E+00_JPRB,2.6481E+00_JPRB,2.5840E+00_JPRB,2.4592E+00_JPRB,2.2850E+00_JPRB,&
&2.0595E+00_JPRB,1.7358E+00_JPRB,1.1287E+00_JPRB/)
KAO( :, 4,11,10) = (/&
&2.6180E+00_JPRB,2.7488E+00_JPRB,2.7545E+00_JPRB,2.7101E+00_JPRB,2.5960E+00_JPRB,2.4226E+00_JPRB,&
&2.2050E+00_JPRB,1.8751E+00_JPRB,1.2713E+00_JPRB/)
KAO( :, 5,11,10) = (/&
&2.6708E+00_JPRB,2.8308E+00_JPRB,2.8655E+00_JPRB,2.8311E+00_JPRB,2.7233E+00_JPRB,2.5640E+00_JPRB,&
&2.3410E+00_JPRB,2.0028E+00_JPRB,1.4162E+00_JPRB/)
KAO( :, 1,12,10) = (/&
&2.2798E+00_JPRB,2.3643E+00_JPRB,2.3131E+00_JPRB,2.2090E+00_JPRB,2.0595E+00_JPRB,1.8678E+00_JPRB,&
&1.6491E+00_JPRB,1.3284E+00_JPRB,7.5824E-01_JPRB/)
KAO( :, 2,12,10) = (/&
&2.3366E+00_JPRB,2.4475E+00_JPRB,2.4167E+00_JPRB,2.3329E+00_JPRB,2.1840E+00_JPRB,2.0081E+00_JPRB,&
&1.7907E+00_JPRB,1.4613E+00_JPRB,8.7475E-01_JPRB/)
KAO( :, 3,12,10) = (/&
&2.3890E+00_JPRB,2.5244E+00_JPRB,2.5206E+00_JPRB,2.4421E+00_JPRB,2.3136E+00_JPRB,2.1465E+00_JPRB,&
&1.9227E+00_JPRB,1.5932E+00_JPRB,9.9953E-01_JPRB/)
KAO( :, 4,12,10) = (/&
&2.4374E+00_JPRB,2.6016E+00_JPRB,2.6217E+00_JPRB,2.5543E+00_JPRB,2.4367E+00_JPRB,2.2813E+00_JPRB,&
&2.0490E+00_JPRB,1.7139E+00_JPRB,1.1310E+00_JPRB/)
KAO( :, 5,12,10) = (/&
&2.4838E+00_JPRB,2.6702E+00_JPRB,2.7195E+00_JPRB,2.6584E+00_JPRB,2.5615E+00_JPRB,2.4117E+00_JPRB,&
&2.1613E+00_JPRB,1.8334E+00_JPRB,1.2595E+00_JPRB/)
KAO( :, 1,13,10) = (/&
&2.0791E+00_JPRB,2.1960E+00_JPRB,2.1642E+00_JPRB,2.0798E+00_JPRB,1.9340E+00_JPRB,1.7492E+00_JPRB,&
&1.5316E+00_JPRB,1.2117E+00_JPRB,6.7239E-01_JPRB/)
KAO( :, 2,13,10) = (/&
&2.1335E+00_JPRB,2.2729E+00_JPRB,2.2653E+00_JPRB,2.1865E+00_JPRB,2.0515E+00_JPRB,1.8780E+00_JPRB,&
&1.6557E+00_JPRB,1.3290E+00_JPRB,7.8385E-01_JPRB/)
KAO( :, 3,13,10) = (/&
&2.1832E+00_JPRB,2.3472E+00_JPRB,2.3626E+00_JPRB,2.2909E+00_JPRB,2.1703E+00_JPRB,1.9998E+00_JPRB,&
&1.7751E+00_JPRB,1.4395E+00_JPRB,8.9988E-01_JPRB/)
KAO( :, 4,13,10) = (/&
&2.2317E+00_JPRB,2.4190E+00_JPRB,2.4536E+00_JPRB,2.3945E+00_JPRB,2.2843E+00_JPRB,2.1191E+00_JPRB,&
&1.8849E+00_JPRB,1.5486E+00_JPRB,1.0181E+00_JPRB/)
KAO( :, 5,13,10) = (/&
&2.2928E+00_JPRB,2.4912E+00_JPRB,2.5411E+00_JPRB,2.4970E+00_JPRB,2.3950E+00_JPRB,2.2262E+00_JPRB,&
&1.9945E+00_JPRB,1.6570E+00_JPRB,1.1340E+00_JPRB/)
KAO( :, 1, 1,11) = (/&
&5.1188E+00_JPRB,4.4962E+00_JPRB,4.1898E+00_JPRB,4.1232E+00_JPRB,3.8282E+00_JPRB,3.7520E+00_JPRB,&
&3.8632E+00_JPRB,3.7314E+00_JPRB,4.2299E+00_JPRB/)
KAO( :, 2, 1,11) = (/&
&5.2357E+00_JPRB,4.6021E+00_JPRB,4.3195E+00_JPRB,4.2578E+00_JPRB,3.9916E+00_JPRB,3.9872E+00_JPRB,&
&4.0538E+00_JPRB,3.9583E+00_JPRB,4.4896E+00_JPRB/)
KAO( :, 3, 1,11) = (/&
&5.3431E+00_JPRB,4.6995E+00_JPRB,4.4290E+00_JPRB,4.3921E+00_JPRB,4.1757E+00_JPRB,4.2052E+00_JPRB,&
&4.1799E+00_JPRB,4.1518E+00_JPRB,4.7182E+00_JPRB/)
KAO( :, 4, 1,11) = (/&
&5.4410E+00_JPRB,4.7855E+00_JPRB,4.5302E+00_JPRB,4.5043E+00_JPRB,4.3792E+00_JPRB,4.3589E+00_JPRB,&
&4.2659E+00_JPRB,4.3498E+00_JPRB,4.9265E+00_JPRB/)
KAO( :, 5, 1,11) = (/&
&5.5309E+00_JPRB,4.8636E+00_JPRB,4.6308E+00_JPRB,4.6226E+00_JPRB,4.5553E+00_JPRB,4.4731E+00_JPRB,&
&4.3313E+00_JPRB,4.5563E+00_JPRB,5.1476E+00_JPRB/)
KAO( :, 1, 2,11) = (/&
&5.3830E+00_JPRB,4.7598E+00_JPRB,4.5038E+00_JPRB,4.4124E+00_JPRB,4.1256E+00_JPRB,3.9352E+00_JPRB,&
&3.9288E+00_JPRB,3.6529E+00_JPRB,4.1533E+00_JPRB/)
KAO( :, 2, 2,11) = (/&
&5.5093E+00_JPRB,4.8746E+00_JPRB,4.6320E+00_JPRB,4.5446E+00_JPRB,4.3075E+00_JPRB,4.1643E+00_JPRB,&
&4.1158E+00_JPRB,3.8793E+00_JPRB,4.4270E+00_JPRB/)
KAO( :, 3, 2,11) = (/&
&5.6175E+00_JPRB,4.9740E+00_JPRB,4.7438E+00_JPRB,4.6765E+00_JPRB,4.5041E+00_JPRB,4.3624E+00_JPRB,&
&4.2461E+00_JPRB,4.1118E+00_JPRB,4.6851E+00_JPRB/)
KAO( :, 4, 2,11) = (/&
&5.7157E+00_JPRB,5.0593E+00_JPRB,4.8530E+00_JPRB,4.7924E+00_JPRB,4.7291E+00_JPRB,4.5102E+00_JPRB,&
&4.3461E+00_JPRB,4.3454E+00_JPRB,4.9401E+00_JPRB/)
KAO( :, 5, 2,11) = (/&
&5.8004E+00_JPRB,5.1349E+00_JPRB,4.9550E+00_JPRB,4.9255E+00_JPRB,4.9201E+00_JPRB,4.6238E+00_JPRB,&
&4.4516E+00_JPRB,4.5890E+00_JPRB,5.2057E+00_JPRB/)
KAO( :, 1, 3,11) = (/&
&5.5164E+00_JPRB,4.9212E+00_JPRB,4.7297E+00_JPRB,4.6037E+00_JPRB,4.3740E+00_JPRB,4.1348E+00_JPRB,&
&3.8407E+00_JPRB,3.5074E+00_JPRB,3.9068E+00_JPRB/)
KAO( :, 2, 3,11) = (/&
&5.6457E+00_JPRB,5.0403E+00_JPRB,4.8708E+00_JPRB,4.7481E+00_JPRB,4.5713E+00_JPRB,4.3408E+00_JPRB,&
&4.0590E+00_JPRB,3.7279E+00_JPRB,4.2270E+00_JPRB/)
KAO( :, 3, 3,11) = (/&
&5.7648E+00_JPRB,5.1472E+00_JPRB,4.9917E+00_JPRB,4.8917E+00_JPRB,4.7668E+00_JPRB,4.5432E+00_JPRB,&
&4.2248E+00_JPRB,3.9671E+00_JPRB,4.5272E+00_JPRB/)
KAO( :, 4, 3,11) = (/&
&5.8726E+00_JPRB,5.2450E+00_JPRB,5.1073E+00_JPRB,5.0262E+00_JPRB,4.9765E+00_JPRB,4.7078E+00_JPRB,&
&4.3673E+00_JPRB,4.2265E+00_JPRB,4.8206E+00_JPRB/)
KAO( :, 5, 3,11) = (/&
&5.9741E+00_JPRB,5.3354E+00_JPRB,5.2185E+00_JPRB,5.1809E+00_JPRB,5.1510E+00_JPRB,4.8375E+00_JPRB,&
&4.4951E+00_JPRB,4.4978E+00_JPRB,5.1274E+00_JPRB/)
KAO( :, 1, 4,11) = (/&
&5.5586E+00_JPRB,4.9938E+00_JPRB,4.8775E+00_JPRB,4.7228E+00_JPRB,4.5678E+00_JPRB,4.2888E+00_JPRB,&
&3.7572E+00_JPRB,3.3686E+00_JPRB,3.6371E+00_JPRB/)
KAO( :, 2, 4,11) = (/&
&5.7048E+00_JPRB,5.1254E+00_JPRB,5.0246E+00_JPRB,4.8865E+00_JPRB,4.7638E+00_JPRB,4.4945E+00_JPRB,&
&3.9733E+00_JPRB,3.5886E+00_JPRB,3.9962E+00_JPRB/)
KAO( :, 3, 4,11) = (/&
&5.8381E+00_JPRB,5.2468E+00_JPRB,5.1587E+00_JPRB,5.0517E+00_JPRB,4.9564E+00_JPRB,4.6974E+00_JPRB,&
&4.1859E+00_JPRB,3.8140E+00_JPRB,4.3209E+00_JPRB/)
KAO( :, 4, 4,11) = (/&
&5.9605E+00_JPRB,5.3609E+00_JPRB,5.2847E+00_JPRB,5.2114E+00_JPRB,5.1284E+00_JPRB,4.8993E+00_JPRB,&
&4.3580E+00_JPRB,4.0704E+00_JPRB,4.6439E+00_JPRB/)
KAO( :, 5, 4,11) = (/&
&6.0637E+00_JPRB,5.4599E+00_JPRB,5.4065E+00_JPRB,5.3711E+00_JPRB,5.2958E+00_JPRB,5.0595E+00_JPRB,&
&4.5112E+00_JPRB,4.3517E+00_JPRB,4.9660E+00_JPRB/)
KAO( :, 1, 5,11) = (/&
&5.5140E+00_JPRB,4.9813E+00_JPRB,4.9335E+00_JPRB,4.7913E+00_JPRB,4.6774E+00_JPRB,4.3710E+00_JPRB,&
&3.7530E+00_JPRB,3.2477E+00_JPRB,3.3634E+00_JPRB/)
KAO( :, 2, 5,11) = (/&
&5.6664E+00_JPRB,5.1255E+00_JPRB,5.1035E+00_JPRB,4.9717E+00_JPRB,4.8774E+00_JPRB,4.5859E+00_JPRB,&
&3.9668E+00_JPRB,3.4677E+00_JPRB,3.7405E+00_JPRB/)
KAO( :, 3, 5,11) = (/&
&5.8011E+00_JPRB,5.2612E+00_JPRB,5.2545E+00_JPRB,5.1514E+00_JPRB,5.0632E+00_JPRB,4.7735E+00_JPRB,&
&4.2022E+00_JPRB,3.6795E+00_JPRB,4.0879E+00_JPRB/)
KAO( :, 4, 5,11) = (/&
&5.9195E+00_JPRB,5.3879E+00_JPRB,5.3990E+00_JPRB,5.3253E+00_JPRB,5.2340E+00_JPRB,4.9702E+00_JPRB,&
&4.4129E+00_JPRB,3.9016E+00_JPRB,4.4176E+00_JPRB/)
KAO( :, 5, 5,11) = (/&
&6.0324E+00_JPRB,5.5030E+00_JPRB,5.5351E+00_JPRB,5.4951E+00_JPRB,5.4012E+00_JPRB,5.1456E+00_JPRB,&
&4.5860E+00_JPRB,4.1610E+00_JPRB,4.7497E+00_JPRB/)
KAO( :, 1, 6,11) = (/&
&5.3460E+00_JPRB,4.8907E+00_JPRB,4.9037E+00_JPRB,4.7959E+00_JPRB,4.6720E+00_JPRB,4.3428E+00_JPRB,&
&3.7532E+00_JPRB,3.0728E+00_JPRB,3.0483E+00_JPRB/)
KAO( :, 2, 6,11) = (/&
&5.5016E+00_JPRB,5.0576E+00_JPRB,5.0845E+00_JPRB,4.9968E+00_JPRB,4.8768E+00_JPRB,4.5629E+00_JPRB,&
&3.9805E+00_JPRB,3.3257E+00_JPRB,3.4138E+00_JPRB/)
KAO( :, 3, 6,11) = (/&
&5.6458E+00_JPRB,5.2128E+00_JPRB,5.2471E+00_JPRB,5.1892E+00_JPRB,5.0839E+00_JPRB,4.7513E+00_JPRB,&
&4.2341E+00_JPRB,3.5158E+00_JPRB,3.7567E+00_JPRB/)
KAO( :, 4, 6,11) = (/&
&5.7776E+00_JPRB,5.3547E+00_JPRB,5.4002E+00_JPRB,5.3806E+00_JPRB,5.2566E+00_JPRB,4.9480E+00_JPRB,&
&4.4656E+00_JPRB,3.7111E+00_JPRB,4.0913E+00_JPRB/)
KAO( :, 5, 6,11) = (/&
&5.8886E+00_JPRB,5.4776E+00_JPRB,5.5415E+00_JPRB,5.5583E+00_JPRB,5.4285E+00_JPRB,5.1330E+00_JPRB,&
&4.6590E+00_JPRB,3.9360E+00_JPRB,4.4349E+00_JPRB/)
KAO( :, 1, 7,11) = (/&
&5.0900E+00_JPRB,4.7460E+00_JPRB,4.7704E+00_JPRB,4.7424E+00_JPRB,4.5661E+00_JPRB,4.2208E+00_JPRB,&
&3.7025E+00_JPRB,2.9233E+00_JPRB,2.7128E+00_JPRB/)
KAO( :, 2, 7,11) = (/&
&5.2495E+00_JPRB,4.9306E+00_JPRB,4.9678E+00_JPRB,4.9514E+00_JPRB,4.7835E+00_JPRB,4.4516E+00_JPRB,&
&3.9503E+00_JPRB,3.1699E+00_JPRB,3.0368E+00_JPRB/)
KAO( :, 3, 7,11) = (/&
&5.3908E+00_JPRB,5.0938E+00_JPRB,5.1429E+00_JPRB,5.1559E+00_JPRB,4.9966E+00_JPRB,4.6413E+00_JPRB,&
&4.2020E+00_JPRB,3.3718E+00_JPRB,3.3561E+00_JPRB/)
KAO( :, 4, 7,11) = (/&
&5.5155E+00_JPRB,5.2363E+00_JPRB,5.3032E+00_JPRB,5.3596E+00_JPRB,5.1777E+00_JPRB,4.8555E+00_JPRB,&
&4.4333E+00_JPRB,3.5353E+00_JPRB,3.6838E+00_JPRB/)
KAO( :, 5, 7,11) = (/&
&5.6325E+00_JPRB,5.3617E+00_JPRB,5.4630E+00_JPRB,5.5298E+00_JPRB,5.3705E+00_JPRB,5.0766E+00_JPRB,&
&4.6290E+00_JPRB,3.7252E+00_JPRB,4.0295E+00_JPRB/)
KAO( :, 1, 8,11) = (/&
&4.7924E+00_JPRB,4.5440E+00_JPRB,4.5871E+00_JPRB,4.5972E+00_JPRB,4.3821E+00_JPRB,4.0282E+00_JPRB,&
&3.5782E+00_JPRB,2.8267E+00_JPRB,2.3643E+00_JPRB/)
KAO( :, 2, 8,11) = (/&
&4.9458E+00_JPRB,4.7238E+00_JPRB,4.7983E+00_JPRB,4.8145E+00_JPRB,4.6002E+00_JPRB,4.2694E+00_JPRB,&
&3.8266E+00_JPRB,3.0607E+00_JPRB,2.6625E+00_JPRB/)
KAO( :, 3, 8,11) = (/&
&5.0872E+00_JPRB,4.8848E+00_JPRB,4.9881E+00_JPRB,5.0206E+00_JPRB,4.8258E+00_JPRB,4.4891E+00_JPRB,&
&4.0830E+00_JPRB,3.2647E+00_JPRB,2.9566E+00_JPRB/)
KAO( :, 4, 8,11) = (/&
&5.2177E+00_JPRB,5.0262E+00_JPRB,5.1648E+00_JPRB,5.2193E+00_JPRB,5.0190E+00_JPRB,4.7309E+00_JPRB,&
&4.3124E+00_JPRB,3.4443E+00_JPRB,3.2673E+00_JPRB/)
KAO( :, 5, 8,11) = (/&
&5.3303E+00_JPRB,5.1466E+00_JPRB,5.3381E+00_JPRB,5.3870E+00_JPRB,5.2200E+00_JPRB,4.9620E+00_JPRB,&
&4.5031E+00_JPRB,3.6204E+00_JPRB,3.6052E+00_JPRB/)
KAO( :, 1, 9,11) = (/&
&4.5347E+00_JPRB,4.3328E+00_JPRB,4.3689E+00_JPRB,4.3513E+00_JPRB,4.1174E+00_JPRB,3.7868E+00_JPRB,&
&3.3737E+00_JPRB,2.7015E+00_JPRB,2.0218E+00_JPRB/)
KAO( :, 2, 9,11) = (/&
&4.6866E+00_JPRB,4.5049E+00_JPRB,4.5898E+00_JPRB,4.5628E+00_JPRB,4.3507E+00_JPRB,4.0425E+00_JPRB,&
&3.6252E+00_JPRB,2.9347E+00_JPRB,2.3048E+00_JPRB/)
KAO( :, 3, 9,11) = (/&
&4.8251E+00_JPRB,4.6663E+00_JPRB,4.7848E+00_JPRB,4.7704E+00_JPRB,4.5826E+00_JPRB,4.2849E+00_JPRB,&
&3.8759E+00_JPRB,3.1451E+00_JPRB,2.5879E+00_JPRB/)
KAO( :, 4, 9,11) = (/&
&4.9503E+00_JPRB,4.8087E+00_JPRB,4.9642E+00_JPRB,4.9727E+00_JPRB,4.7915E+00_JPRB,4.5387E+00_JPRB,&
&4.1015E+00_JPRB,3.3321E+00_JPRB,2.8859E+00_JPRB/)
KAO( :, 5, 9,11) = (/&
&5.0642E+00_JPRB,4.9400E+00_JPRB,5.1410E+00_JPRB,5.1452E+00_JPRB,5.0116E+00_JPRB,4.7755E+00_JPRB,&
&4.3020E+00_JPRB,3.5123E+00_JPRB,3.1955E+00_JPRB/)
KAO( :, 1,10,11) = (/&
&4.3141E+00_JPRB,4.1481E+00_JPRB,4.1872E+00_JPRB,4.0732E+00_JPRB,3.8258E+00_JPRB,3.5260E+00_JPRB,&
&3.1443E+00_JPRB,2.5485E+00_JPRB,1.7391E+00_JPRB/)
KAO( :, 2,10,11) = (/&
&4.4657E+00_JPRB,4.3291E+00_JPRB,4.4068E+00_JPRB,4.2778E+00_JPRB,4.0645E+00_JPRB,3.7865E+00_JPRB,&
&3.3989E+00_JPRB,2.7666E+00_JPRB,2.0042E+00_JPRB/)
KAO( :, 3,10,11) = (/&
&4.6073E+00_JPRB,4.4901E+00_JPRB,4.5937E+00_JPRB,4.4815E+00_JPRB,4.3022E+00_JPRB,4.0396E+00_JPRB,&
&3.6341E+00_JPRB,2.9783E+00_JPRB,2.2696E+00_JPRB/)
KAO( :, 4,10,11) = (/&
&4.7332E+00_JPRB,4.6441E+00_JPRB,4.7670E+00_JPRB,4.6811E+00_JPRB,4.5263E+00_JPRB,4.2880E+00_JPRB,&
&3.8564E+00_JPRB,3.1687E+00_JPRB,2.5448E+00_JPRB/)
KAO( :, 5,10,11) = (/&
&4.8482E+00_JPRB,4.7816E+00_JPRB,4.9366E+00_JPRB,4.8606E+00_JPRB,4.7563E+00_JPRB,4.5121E+00_JPRB,&
&4.0582E+00_JPRB,3.3600E+00_JPRB,2.8205E+00_JPRB/)
KAO( :, 1,11,11) = (/&
&4.1814E+00_JPRB,4.0541E+00_JPRB,4.0844E+00_JPRB,3.9070E+00_JPRB,3.6510E+00_JPRB,3.3593E+00_JPRB,&
&3.0020E+00_JPRB,2.4435E+00_JPRB,1.5974E+00_JPRB/)
KAO( :, 2,11,11) = (/&
&4.3118E+00_JPRB,4.2274E+00_JPRB,4.2869E+00_JPRB,4.1141E+00_JPRB,3.8852E+00_JPRB,3.6134E+00_JPRB,&
&3.2400E+00_JPRB,2.6533E+00_JPRB,1.8419E+00_JPRB/)
KAO( :, 3,11,11) = (/&
&4.4319E+00_JPRB,4.3935E+00_JPRB,4.4651E+00_JPRB,4.3182E+00_JPRB,4.1137E+00_JPRB,3.8517E+00_JPRB,&
&3.4603E+00_JPRB,2.8608E+00_JPRB,2.0902E+00_JPRB/)
KAO( :, 4,11,11) = (/&
&4.5390E+00_JPRB,4.5400E+00_JPRB,4.6448E+00_JPRB,4.5087E+00_JPRB,4.3372E+00_JPRB,4.0750E+00_JPRB,&
&3.6707E+00_JPRB,3.0507E+00_JPRB,2.3393E+00_JPRB/)
KAO( :, 5,11,11) = (/&
&4.6299E+00_JPRB,4.6729E+00_JPRB,4.7998E+00_JPRB,4.6995E+00_JPRB,4.5508E+00_JPRB,4.2784E+00_JPRB,&
&3.8764E+00_JPRB,3.2454E+00_JPRB,2.5677E+00_JPRB/)
KAO( :, 1,12,11) = (/&
&4.0099E+00_JPRB,3.9422E+00_JPRB,3.9403E+00_JPRB,3.7407E+00_JPRB,3.4918E+00_JPRB,3.1976E+00_JPRB,&
&2.8203E+00_JPRB,2.3020E+00_JPRB,1.4455E+00_JPRB/)
KAO( :, 2,12,11) = (/&
&4.1176E+00_JPRB,4.1055E+00_JPRB,4.1224E+00_JPRB,3.9486E+00_JPRB,3.7245E+00_JPRB,3.4270E+00_JPRB,&
&3.0337E+00_JPRB,2.5124E+00_JPRB,1.6679E+00_JPRB/)
KAO( :, 3,12,11) = (/&
&4.2129E+00_JPRB,4.2545E+00_JPRB,4.2966E+00_JPRB,4.1603E+00_JPRB,3.9419E+00_JPRB,3.6332E+00_JPRB,&
&3.2538E+00_JPRB,2.7031E+00_JPRB,1.8904E+00_JPRB/)
KAO( :, 4,12,11) = (/&
&4.2979E+00_JPRB,4.3881E+00_JPRB,4.4616E+00_JPRB,4.3568E+00_JPRB,4.1443E+00_JPRB,3.8364E+00_JPRB,&
&3.4615E+00_JPRB,2.8971E+00_JPRB,2.1003E+00_JPRB/)
KAO( :, 5,12,11) = (/&
&4.3757E+00_JPRB,4.5140E+00_JPRB,4.6083E+00_JPRB,4.5481E+00_JPRB,4.3321E+00_JPRB,4.0278E+00_JPRB,&
&3.6672E+00_JPRB,3.0746E+00_JPRB,2.3111E+00_JPRB/)
KAO( :, 1,13,11) = (/&
&3.8115E+00_JPRB,3.8123E+00_JPRB,3.7564E+00_JPRB,3.5672E+00_JPRB,3.3321E+00_JPRB,3.0260E+00_JPRB,&
&2.6276E+00_JPRB,2.1465E+00_JPRB,1.2822E+00_JPRB/)
KAO( :, 2,13,11) = (/&
&3.9006E+00_JPRB,3.9563E+00_JPRB,3.9216E+00_JPRB,3.7726E+00_JPRB,3.5504E+00_JPRB,3.2297E+00_JPRB,&
&2.8365E+00_JPRB,2.3385E+00_JPRB,1.4776E+00_JPRB/)
KAO( :, 3,13,11) = (/&
&3.9788E+00_JPRB,4.0838E+00_JPRB,4.0868E+00_JPRB,3.9664E+00_JPRB,3.7467E+00_JPRB,3.4326E+00_JPRB,&
&3.0397E+00_JPRB,2.5221E+00_JPRB,1.6670E+00_JPRB/)
KAO( :, 4,13,11) = (/&
&4.0518E+00_JPRB,4.2003E+00_JPRB,4.2397E+00_JPRB,4.1476E+00_JPRB,3.9371E+00_JPRB,3.6284E+00_JPRB,&
&3.2340E+00_JPRB,2.6989E+00_JPRB,1.8578E+00_JPRB/)
KAO( :, 5,13,11) = (/&
&4.1173E+00_JPRB,4.3105E+00_JPRB,4.3846E+00_JPRB,4.3176E+00_JPRB,4.1129E+00_JPRB,3.8156E+00_JPRB,&
&3.4246E+00_JPRB,2.8636E+00_JPRB,2.0525E+00_JPRB/)
KAO( :, 1, 1,12) = (/&
&7.0750E+00_JPRB,6.1912E+00_JPRB,5.5399E+00_JPRB,5.3350E+00_JPRB,5.4706E+00_JPRB,5.3762E+00_JPRB,&
&5.1145E+00_JPRB,5.3782E+00_JPRB,6.0148E+00_JPRB/)
KAO( :, 2, 1,12) = (/&
&7.2687E+00_JPRB,6.3607E+00_JPRB,5.6891E+00_JPRB,5.4701E+00_JPRB,5.6126E+00_JPRB,5.5473E+00_JPRB,&
&5.2734E+00_JPRB,5.8115E+00_JPRB,6.4886E+00_JPRB/)
KAO( :, 3, 1,12) = (/&
&7.4429E+00_JPRB,6.5131E+00_JPRB,5.8367E+00_JPRB,5.5928E+00_JPRB,5.7515E+00_JPRB,5.7097E+00_JPRB,&
&5.5260E+00_JPRB,6.2806E+00_JPRB,6.9951E+00_JPRB/)
KAO( :, 4, 1,12) = (/&
&7.6028E+00_JPRB,6.6530E+00_JPRB,5.9756E+00_JPRB,5.7243E+00_JPRB,5.8730E+00_JPRB,5.9264E+00_JPRB,&
&5.8242E+00_JPRB,6.7348E+00_JPRB,7.5240E+00_JPRB/)
KAO( :, 5, 1,12) = (/&
&7.7448E+00_JPRB,6.7771E+00_JPRB,6.1045E+00_JPRB,5.8318E+00_JPRB,6.0223E+00_JPRB,6.1431E+00_JPRB,&
&6.1145E+00_JPRB,7.1272E+00_JPRB,7.9899E+00_JPRB/)
KAO( :, 1, 2,12) = (/&
&7.7545E+00_JPRB,6.7857E+00_JPRB,6.1014E+00_JPRB,5.8641E+00_JPRB,5.6627E+00_JPRB,5.4924E+00_JPRB,&
&5.3064E+00_JPRB,5.5478E+00_JPRB,6.2448E+00_JPRB/)
KAO( :, 2, 2,12) = (/&
&7.9626E+00_JPRB,6.9679E+00_JPRB,6.2884E+00_JPRB,6.0331E+00_JPRB,5.8184E+00_JPRB,5.6805E+00_JPRB,&
&5.5037E+00_JPRB,5.9946E+00_JPRB,6.7468E+00_JPRB/)
KAO( :, 3, 2,12) = (/&
&8.1571E+00_JPRB,7.1382E+00_JPRB,6.4613E+00_JPRB,6.1841E+00_JPRB,5.9708E+00_JPRB,5.8941E+00_JPRB,&
&5.7532E+00_JPRB,6.4635E+00_JPRB,7.2816E+00_JPRB/)
KAO( :, 4, 2,12) = (/&
&8.3326E+00_JPRB,7.2918E+00_JPRB,6.6225E+00_JPRB,6.3365E+00_JPRB,6.0835E+00_JPRB,6.1383E+00_JPRB,&
&6.0067E+00_JPRB,6.8804E+00_JPRB,7.7820E+00_JPRB/)
KAO( :, 5, 2,12) = (/&
&8.4888E+00_JPRB,7.4285E+00_JPRB,6.7684E+00_JPRB,6.4625E+00_JPRB,6.2260E+00_JPRB,6.3461E+00_JPRB,&
&6.2452E+00_JPRB,7.2451E+00_JPRB,8.2111E+00_JPRB/)
KAO( :, 1, 3,12) = (/&
&8.3602E+00_JPRB,7.3163E+00_JPRB,6.6388E+00_JPRB,6.3825E+00_JPRB,5.9192E+00_JPRB,5.5791E+00_JPRB,&
&5.5047E+00_JPRB,5.5786E+00_JPRB,6.3479E+00_JPRB/)
KAO( :, 2, 3,12) = (/&
&8.5890E+00_JPRB,7.5183E+00_JPRB,6.8453E+00_JPRB,6.5628E+00_JPRB,6.0922E+00_JPRB,5.8078E+00_JPRB,&
&5.7041E+00_JPRB,6.0248E+00_JPRB,6.8536E+00_JPRB/)
KAO( :, 3, 3,12) = (/&
&8.7942E+00_JPRB,7.6989E+00_JPRB,7.0385E+00_JPRB,6.7230E+00_JPRB,6.2576E+00_JPRB,6.0242E+00_JPRB,&
&5.9018E+00_JPRB,6.4818E+00_JPRB,7.3747E+00_JPRB/)
KAO( :, 4, 3,12) = (/&
&8.9740E+00_JPRB,7.8579E+00_JPRB,7.2067E+00_JPRB,6.8812E+00_JPRB,6.4038E+00_JPRB,6.2630E+00_JPRB,&
&6.1272E+00_JPRB,6.9158E+00_JPRB,7.8669E+00_JPRB/)
KAO( :, 5, 3,12) = (/&
&9.1236E+00_JPRB,7.9895E+00_JPRB,7.3566E+00_JPRB,7.0154E+00_JPRB,6.5927E+00_JPRB,6.4547E+00_JPRB,&
&6.3294E+00_JPRB,7.2767E+00_JPRB,8.2820E+00_JPRB/)
KAO( :, 1, 4,12) = (/&
&8.8847E+00_JPRB,7.7960E+00_JPRB,7.1075E+00_JPRB,6.8009E+00_JPRB,6.2444E+00_JPRB,5.7477E+00_JPRB,&
&5.6301E+00_JPRB,5.4141E+00_JPRB,6.1834E+00_JPRB/)
KAO( :, 2, 4,12) = (/&
&9.1116E+00_JPRB,7.9999E+00_JPRB,7.3356E+00_JPRB,7.0007E+00_JPRB,6.4482E+00_JPRB,5.9737E+00_JPRB,&
&5.8408E+00_JPRB,5.8678E+00_JPRB,6.6961E+00_JPRB/)
KAO( :, 3, 4,12) = (/&
&9.3094E+00_JPRB,8.1759E+00_JPRB,7.5373E+00_JPRB,7.1726E+00_JPRB,6.6509E+00_JPRB,6.2012E+00_JPRB,&
&5.9911E+00_JPRB,6.3277E+00_JPRB,7.2196E+00_JPRB/)
KAO( :, 4, 4,12) = (/&
&9.4683E+00_JPRB,8.3188E+00_JPRB,7.7174E+00_JPRB,7.3409E+00_JPRB,6.8481E+00_JPRB,6.3961E+00_JPRB,&
&6.1664E+00_JPRB,6.7597E+00_JPRB,7.7146E+00_JPRB/)
KAO( :, 5, 4,12) = (/&
&9.6042E+00_JPRB,8.4435E+00_JPRB,7.8581E+00_JPRB,7.4916E+00_JPRB,7.0560E+00_JPRB,6.5810E+00_JPRB,&
&6.3225E+00_JPRB,7.1406E+00_JPRB,8.1513E+00_JPRB/)
KAO( :, 1, 5,12) = (/&
&9.2292E+00_JPRB,8.1377E+00_JPRB,7.4945E+00_JPRB,7.1495E+00_JPRB,6.5484E+00_JPRB,5.9913E+00_JPRB,&
&5.6165E+00_JPRB,5.1149E+00_JPRB,5.8309E+00_JPRB/)
KAO( :, 2, 5,12) = (/&
&9.4577E+00_JPRB,8.3475E+00_JPRB,7.7472E+00_JPRB,7.3686E+00_JPRB,6.7878E+00_JPRB,6.2469E+00_JPRB,&
&5.8285E+00_JPRB,5.5605E+00_JPRB,6.3475E+00_JPRB/)
KAO( :, 3, 5,12) = (/&
&9.6601E+00_JPRB,8.5348E+00_JPRB,7.9661E+00_JPRB,7.5611E+00_JPRB,7.0335E+00_JPRB,6.4923E+00_JPRB,&
&5.9827E+00_JPRB,5.9978E+00_JPRB,6.8470E+00_JPRB/)
KAO( :, 4, 5,12) = (/&
&9.8370E+00_JPRB,8.6956E+00_JPRB,8.1396E+00_JPRB,7.7502E+00_JPRB,7.2566E+00_JPRB,6.6903E+00_JPRB,&
&6.1155E+00_JPRB,6.4492E+00_JPRB,7.3614E+00_JPRB/)
KAO( :, 5, 5,12) = (/&
&9.9720E+00_JPRB,8.8165E+00_JPRB,8.2799E+00_JPRB,7.9327E+00_JPRB,7.4895E+00_JPRB,6.8872E+00_JPRB,&
&6.2655E+00_JPRB,6.8604E+00_JPRB,7.8326E+00_JPRB/)
KAO( :, 1, 6,12) = (/&
&9.4228E+00_JPRB,8.3583E+00_JPRB,7.7791E+00_JPRB,7.3895E+00_JPRB,6.8260E+00_JPRB,6.2621E+00_JPRB,&
&5.5219E+00_JPRB,4.8043E+00_JPRB,5.3717E+00_JPRB/)
KAO( :, 2, 6,12) = (/&
&9.6680E+00_JPRB,8.5862E+00_JPRB,8.0441E+00_JPRB,7.6459E+00_JPRB,7.1022E+00_JPRB,6.5301E+00_JPRB,&
&5.7540E+00_JPRB,5.1597E+00_JPRB,5.8750E+00_JPRB/)
KAO( :, 3, 6,12) = (/&
&9.8647E+00_JPRB,8.7696E+00_JPRB,8.2709E+00_JPRB,7.8751E+00_JPRB,7.3582E+00_JPRB,6.7963E+00_JPRB,&
&5.9278E+00_JPRB,5.6000E+00_JPRB,6.3870E+00_JPRB/)
KAO( :, 4, 6,12) = (/&
&1.0026E+01_JPRB,8.9182E+00_JPRB,8.4588E+00_JPRB,8.0791E+00_JPRB,7.6205E+00_JPRB,7.0216E+00_JPRB,&
&6.0965E+00_JPRB,6.0596E+00_JPRB,6.9174E+00_JPRB/)
KAO( :, 5, 6,12) = (/&
&1.0167E+01_JPRB,9.0497E+00_JPRB,8.6148E+00_JPRB,8.2660E+00_JPRB,7.8544E+00_JPRB,7.2260E+00_JPRB,&
&6.2428E+00_JPRB,6.4815E+00_JPRB,7.4016E+00_JPRB/)
KAO( :, 1, 7,12) = (/&
&9.4277E+00_JPRB,8.4150E+00_JPRB,7.9357E+00_JPRB,7.5305E+00_JPRB,7.0405E+00_JPRB,6.4321E+00_JPRB,&
&5.4684E+00_JPRB,4.5169E+00_JPRB,4.8723E+00_JPRB/)
KAO( :, 2, 7,12) = (/&
&9.6610E+00_JPRB,8.6378E+00_JPRB,8.2182E+00_JPRB,7.8169E+00_JPRB,7.3595E+00_JPRB,6.7122E+00_JPRB,&
&5.7318E+00_JPRB,4.8302E+00_JPRB,5.4033E+00_JPRB/)
KAO( :, 3, 7,12) = (/&
&9.8776E+00_JPRB,8.8386E+00_JPRB,8.4643E+00_JPRB,8.0697E+00_JPRB,7.6404E+00_JPRB,7.0024E+00_JPRB,&
&5.9545E+00_JPRB,5.2084E+00_JPRB,5.9332E+00_JPRB/)
KAO( :, 4, 7,12) = (/&
&1.0065E+01_JPRB,9.0111E+00_JPRB,8.6669E+00_JPRB,8.2878E+00_JPRB,7.9176E+00_JPRB,7.2460E+00_JPRB,&
&6.1780E+00_JPRB,5.6640E+00_JPRB,6.4647E+00_JPRB/)
KAO( :, 5, 7,12) = (/&
&1.0201E+01_JPRB,9.1389E+00_JPRB,8.8345E+00_JPRB,8.5103E+00_JPRB,8.1626E+00_JPRB,7.4581E+00_JPRB,&
&6.4020E+00_JPRB,6.0910E+00_JPRB,6.9537E+00_JPRB/)
KAO( :, 1, 8,12) = (/&
&9.2811E+00_JPRB,8.3345E+00_JPRB,7.9563E+00_JPRB,7.5592E+00_JPRB,7.1819E+00_JPRB,6.4953E+00_JPRB,&
&5.4582E+00_JPRB,4.2950E+00_JPRB,4.3920E+00_JPRB/)
KAO( :, 2, 8,12) = (/&
&9.5392E+00_JPRB,8.5773E+00_JPRB,8.2536E+00_JPRB,7.8937E+00_JPRB,7.5195E+00_JPRB,6.7954E+00_JPRB,&
&5.7637E+00_JPRB,4.5610E+00_JPRB,4.9202E+00_JPRB/)
KAO( :, 3, 8,12) = (/&
&9.7485E+00_JPRB,8.7863E+00_JPRB,8.5113E+00_JPRB,8.1791E+00_JPRB,7.8003E+00_JPRB,7.1017E+00_JPRB,&
&6.0337E+00_JPRB,4.8844E+00_JPRB,5.4469E+00_JPRB/)
KAO( :, 4, 8,12) = (/&
&9.9204E+00_JPRB,8.9649E+00_JPRB,8.7333E+00_JPRB,8.4326E+00_JPRB,8.0879E+00_JPRB,7.3644E+00_JPRB,&
&6.2970E+00_JPRB,5.2617E+00_JPRB,5.9740E+00_JPRB/)
KAO( :, 5, 8,12) = (/&
&1.0071E+01_JPRB,9.1243E+00_JPRB,8.9157E+00_JPRB,8.6785E+00_JPRB,8.3414E+00_JPRB,7.5947E+00_JPRB,&
&6.5710E+00_JPRB,5.6445E+00_JPRB,6.4414E+00_JPRB/)
KAO( :, 1, 9,12) = (/&
&8.9609E+00_JPRB,8.1123E+00_JPRB,7.8302E+00_JPRB,7.5091E+00_JPRB,7.1654E+00_JPRB,6.4417E+00_JPRB,&
&5.3958E+00_JPRB,4.1476E+00_JPRB,3.9139E+00_JPRB/)
KAO( :, 2, 9,12) = (/&
&9.2116E+00_JPRB,8.3782E+00_JPRB,8.1493E+00_JPRB,7.8784E+00_JPRB,7.5112E+00_JPRB,6.7501E+00_JPRB,&
&5.7326E+00_JPRB,4.3938E+00_JPRB,4.4110E+00_JPRB/)
KAO( :, 3, 9,12) = (/&
&9.4264E+00_JPRB,8.6064E+00_JPRB,8.4239E+00_JPRB,8.1936E+00_JPRB,7.8020E+00_JPRB,7.0726E+00_JPRB,&
&6.0450E+00_JPRB,4.6670E+00_JPRB,4.9111E+00_JPRB/)
KAO( :, 4, 9,12) = (/&
&9.6121E+00_JPRB,8.8121E+00_JPRB,8.6565E+00_JPRB,8.4692E+00_JPRB,8.1000E+00_JPRB,7.3553E+00_JPRB,&
&6.3481E+00_JPRB,4.9681E+00_JPRB,5.3926E+00_JPRB/)
KAO( :, 5, 9,12) = (/&
&9.7546E+00_JPRB,8.9755E+00_JPRB,8.8628E+00_JPRB,8.7297E+00_JPRB,8.3623E+00_JPRB,7.6149E+00_JPRB,&
&6.6558E+00_JPRB,5.2826E+00_JPRB,5.8453E+00_JPRB/)
KAO( :, 1,10,12) = (/&
&8.5361E+00_JPRB,7.8147E+00_JPRB,7.5979E+00_JPRB,7.3794E+00_JPRB,7.0310E+00_JPRB,6.2793E+00_JPRB,&
&5.2791E+00_JPRB,4.0318E+00_JPRB,3.4661E+00_JPRB/)
KAO( :, 2,10,12) = (/&
&8.7722E+00_JPRB,8.0890E+00_JPRB,7.9244E+00_JPRB,7.7654E+00_JPRB,7.3651E+00_JPRB,6.6087E+00_JPRB,&
&5.6393E+00_JPRB,4.3325E+00_JPRB,3.9297E+00_JPRB/)
KAO( :, 3,10,12) = (/&
&8.9854E+00_JPRB,8.3416E+00_JPRB,8.2149E+00_JPRB,8.1092E+00_JPRB,7.6681E+00_JPRB,6.9412E+00_JPRB,&
&5.9891E+00_JPRB,4.5941E+00_JPRB,4.3794E+00_JPRB/)
KAO( :, 4,10,12) = (/&
&9.1549E+00_JPRB,8.5424E+00_JPRB,8.4801E+00_JPRB,8.3931E+00_JPRB,7.9670E+00_JPRB,7.2576E+00_JPRB,&
&6.3219E+00_JPRB,4.8394E+00_JPRB,4.8247E+00_JPRB/)
KAO( :, 5,10,12) = (/&
&9.2930E+00_JPRB,8.7150E+00_JPRB,8.6983E+00_JPRB,8.6747E+00_JPRB,8.2356E+00_JPRB,7.5515E+00_JPRB,&
&6.6530E+00_JPRB,5.0978E+00_JPRB,5.2580E+00_JPRB/)
KAO( :, 1,11,12) = (/&
&8.1665E+00_JPRB,7.5900E+00_JPRB,7.4402E+00_JPRB,7.3130E+00_JPRB,6.8936E+00_JPRB,6.1750E+00_JPRB,&
&5.2487E+00_JPRB,4.0527E+00_JPRB,3.2183E+00_JPRB/)
KAO( :, 2,11,12) = (/&
&8.3894E+00_JPRB,7.8591E+00_JPRB,7.7685E+00_JPRB,7.6781E+00_JPRB,7.2197E+00_JPRB,6.5157E+00_JPRB,&
&5.6333E+00_JPRB,4.3626E+00_JPRB,3.6379E+00_JPRB/)
KAO( :, 3,11,12) = (/&
&8.5776E+00_JPRB,8.0897E+00_JPRB,8.0638E+00_JPRB,7.9845E+00_JPRB,7.5334E+00_JPRB,6.8745E+00_JPRB,&
&5.9959E+00_JPRB,4.6206E+00_JPRB,4.0541E+00_JPRB/)
KAO( :, 4,11,12) = (/&
&8.7343E+00_JPRB,8.2889E+00_JPRB,8.3048E+00_JPRB,8.2761E+00_JPRB,7.8416E+00_JPRB,7.2002E+00_JPRB,&
&6.3426E+00_JPRB,4.8817E+00_JPRB,4.4717E+00_JPRB/)
KAO( :, 5,11,12) = (/&
&8.8713E+00_JPRB,8.4483E+00_JPRB,8.5341E+00_JPRB,8.5312E+00_JPRB,8.1167E+00_JPRB,7.5296E+00_JPRB,&
&6.6477E+00_JPRB,5.1325E+00_JPRB,4.9081E+00_JPRB/)
KAO( :, 1,12,12) = (/&
&7.8094E+00_JPRB,7.3653E+00_JPRB,7.2542E+00_JPRB,7.0902E+00_JPRB,6.6433E+00_JPRB,5.9686E+00_JPRB,&
&5.1635E+00_JPRB,4.0194E+00_JPRB,2.9475E+00_JPRB/)
KAO( :, 2,12,12) = (/&
&8.0117E+00_JPRB,7.6155E+00_JPRB,7.5651E+00_JPRB,7.4151E+00_JPRB,6.9696E+00_JPRB,6.3450E+00_JPRB,&
&5.5476E+00_JPRB,4.3129E+00_JPRB,3.3366E+00_JPRB/)
KAO( :, 3,12,12) = (/&
&8.1910E+00_JPRB,7.8328E+00_JPRB,7.8418E+00_JPRB,7.7049E+00_JPRB,7.2969E+00_JPRB,6.7155E+00_JPRB,&
&5.8961E+00_JPRB,4.5906E+00_JPRB,3.7405E+00_JPRB/)
KAO( :, 4,12,12) = (/&
&8.3426E+00_JPRB,8.0165E+00_JPRB,8.0839E+00_JPRB,7.9767E+00_JPRB,7.6138E+00_JPRB,7.0590E+00_JPRB,&
&6.2190E+00_JPRB,4.8660E+00_JPRB,4.1525E+00_JPRB/)
KAO( :, 5,12,12) = (/&
&8.4617E+00_JPRB,8.1705E+00_JPRB,8.3144E+00_JPRB,8.2344E+00_JPRB,7.9033E+00_JPRB,7.3931E+00_JPRB,&
&6.5112E+00_JPRB,5.1463E+00_JPRB,4.5704E+00_JPRB/)
KAO( :, 1,13,12) = (/&
&7.4570E+00_JPRB,7.1219E+00_JPRB,7.0631E+00_JPRB,6.7931E+00_JPRB,6.3176E+00_JPRB,5.7305E+00_JPRB,&
&4.9924E+00_JPRB,3.9078E+00_JPRB,2.6864E+00_JPRB/)
KAO( :, 2,13,12) = (/&
&7.6593E+00_JPRB,7.3680E+00_JPRB,7.3595E+00_JPRB,7.0913E+00_JPRB,6.6544E+00_JPRB,6.1127E+00_JPRB,&
&5.3577E+00_JPRB,4.1969E+00_JPRB,3.0587E+00_JPRB/)
KAO( :, 3,13,12) = (/&
&7.8270E+00_JPRB,7.5824E+00_JPRB,7.6095E+00_JPRB,7.3732E+00_JPRB,7.0009E+00_JPRB,6.4671E+00_JPRB,&
&5.6889E+00_JPRB,4.4965E+00_JPRB,3.4369E+00_JPRB/)
KAO( :, 4,13,12) = (/&
&7.9650E+00_JPRB,7.7709E+00_JPRB,7.8397E+00_JPRB,7.6582E+00_JPRB,7.3100E+00_JPRB,6.7945E+00_JPRB,&
&6.0051E+00_JPRB,4.7890E+00_JPRB,3.8174E+00_JPRB/)
KAO( :, 5,13,12) = (/&
&8.0792E+00_JPRB,7.9275E+00_JPRB,8.0591E+00_JPRB,7.9074E+00_JPRB,7.6140E+00_JPRB,7.1099E+00_JPRB,&
&6.2973E+00_JPRB,5.0841E+00_JPRB,4.2048E+00_JPRB/)
KAO( :, 1, 1,13) = (/&
&1.0577E+01_JPRB,9.2549E+00_JPRB,8.1600E+00_JPRB,7.7278E+00_JPRB,7.7653E+00_JPRB,7.7716E+00_JPRB,&
&7.5669E+00_JPRB,8.8236E+00_JPRB,9.8756E+00_JPRB/)
KAO( :, 2, 1,13) = (/&
&1.0671E+01_JPRB,9.3375E+00_JPRB,8.2378E+00_JPRB,7.8122E+00_JPRB,7.8593E+00_JPRB,7.7059E+00_JPRB,&
&7.9393E+00_JPRB,9.2604E+00_JPRB,1.0358E+01_JPRB/)
KAO( :, 3, 1,13) = (/&
&1.0744E+01_JPRB,9.4010E+00_JPRB,8.2968E+00_JPRB,7.8823E+00_JPRB,7.9000E+00_JPRB,7.7087E+00_JPRB,&
&8.3139E+00_JPRB,9.6974E+00_JPRB,1.0851E+01_JPRB/)
KAO( :, 4, 1,13) = (/&
&1.0801E+01_JPRB,9.4514E+00_JPRB,8.3377E+00_JPRB,7.9397E+00_JPRB,7.9429E+00_JPRB,7.7123E+00_JPRB,&
&8.6663E+00_JPRB,1.0108E+01_JPRB,1.1303E+01_JPRB/)
KAO( :, 5, 1,13) = (/&
&1.0828E+01_JPRB,9.4745E+00_JPRB,8.3567E+00_JPRB,8.0119E+00_JPRB,7.9284E+00_JPRB,7.7671E+00_JPRB,&
&9.0671E+00_JPRB,1.0577E+01_JPRB,1.1784E+01_JPRB/)
KAO( :, 1, 2,13) = (/&
&1.1163E+01_JPRB,9.7674E+00_JPRB,8.6478E+00_JPRB,8.0225E+00_JPRB,8.2244E+00_JPRB,8.0837E+00_JPRB,&
&7.7758E+00_JPRB,9.0278E+00_JPRB,1.0229E+01_JPRB/)
KAO( :, 2, 2,13) = (/&
&1.1323E+01_JPRB,9.9081E+00_JPRB,8.7792E+00_JPRB,8.1586E+00_JPRB,8.2869E+00_JPRB,8.0551E+00_JPRB,&
&8.1451E+00_JPRB,9.5005E+00_JPRB,1.0748E+01_JPRB/)
KAO( :, 3, 2,13) = (/&
&1.1461E+01_JPRB,1.0028E+01_JPRB,8.8854E+00_JPRB,8.2743E+00_JPRB,8.3048E+00_JPRB,8.0402E+00_JPRB,&
&8.5556E+00_JPRB,9.9796E+00_JPRB,1.1282E+01_JPRB/)
KAO( :, 4, 2,13) = (/&
&1.1566E+01_JPRB,1.0120E+01_JPRB,8.9543E+00_JPRB,8.3710E+00_JPRB,8.3468E+00_JPRB,8.0313E+00_JPRB,&
&8.9856E+00_JPRB,1.0481E+01_JPRB,1.1824E+01_JPRB/)
KAO( :, 5, 2,13) = (/&
&1.1629E+01_JPRB,1.0176E+01_JPRB,8.9870E+00_JPRB,8.4547E+00_JPRB,8.3497E+00_JPRB,8.1172E+00_JPRB,&
&9.4516E+00_JPRB,1.1026E+01_JPRB,1.2419E+01_JPRB/)
KAO( :, 1, 3,13) = (/&
&1.1962E+01_JPRB,1.0467E+01_JPRB,9.2709E+00_JPRB,8.4291E+00_JPRB,8.5436E+00_JPRB,8.3200E+00_JPRB,&
&7.8658E+00_JPRB,9.0562E+00_JPRB,1.0308E+01_JPRB/)
KAO( :, 2, 3,13) = (/&
&1.2205E+01_JPRB,1.0680E+01_JPRB,9.4411E+00_JPRB,8.6517E+00_JPRB,8.6197E+00_JPRB,8.3368E+00_JPRB,&
&8.2049E+00_JPRB,9.5685E+00_JPRB,1.0891E+01_JPRB/)
KAO( :, 3, 3,13) = (/&
&1.2410E+01_JPRB,1.0859E+01_JPRB,9.5853E+00_JPRB,8.8479E+00_JPRB,8.6747E+00_JPRB,8.3471E+00_JPRB,&
&8.6431E+00_JPRB,1.0082E+01_JPRB,1.1474E+01_JPRB/)
KAO( :, 4, 3,13) = (/&
&1.2574E+01_JPRB,1.1002E+01_JPRB,9.6989E+00_JPRB,8.9698E+00_JPRB,8.7471E+00_JPRB,8.3398E+00_JPRB,&
&9.0831E+00_JPRB,1.0595E+01_JPRB,1.2056E+01_JPRB/)
KAO( :, 5, 3,13) = (/&
&1.2712E+01_JPRB,1.1123E+01_JPRB,9.7902E+00_JPRB,9.0790E+00_JPRB,8.7667E+00_JPRB,8.4500E+00_JPRB,&
&9.6002E+00_JPRB,1.1199E+01_JPRB,1.2724E+01_JPRB/)
KAO( :, 1, 4,13) = (/&
&1.2978E+01_JPRB,1.1356E+01_JPRB,1.0016E+01_JPRB,9.0951E+00_JPRB,8.8183E+00_JPRB,8.5105E+00_JPRB,&
&7.9105E+00_JPRB,9.0384E+00_JPRB,1.0315E+01_JPRB/)
KAO( :, 2, 4,13) = (/&
&1.3298E+01_JPRB,1.1636E+01_JPRB,1.0263E+01_JPRB,9.3919E+00_JPRB,8.9613E+00_JPRB,8.5969E+00_JPRB,&
&8.2211E+00_JPRB,9.5613E+00_JPRB,1.0907E+01_JPRB/)
KAO( :, 3, 4,13) = (/&
&1.3575E+01_JPRB,1.1878E+01_JPRB,1.0487E+01_JPRB,9.6114E+00_JPRB,9.0632E+00_JPRB,8.6395E+00_JPRB,&
&8.6771E+00_JPRB,1.0122E+01_JPRB,1.1544E+01_JPRB/)
KAO( :, 4, 4,13) = (/&
&1.3811E+01_JPRB,1.2085E+01_JPRB,1.0662E+01_JPRB,9.7774E+00_JPRB,9.1650E+00_JPRB,8.6661E+00_JPRB,&
&9.1672E+00_JPRB,1.0693E+01_JPRB,1.2193E+01_JPRB/)
KAO( :, 5, 4,13) = (/&
&1.3981E+01_JPRB,1.2233E+01_JPRB,1.0802E+01_JPRB,9.9141E+00_JPRB,9.2432E+00_JPRB,8.7675E+00_JPRB,&
&9.7195E+00_JPRB,1.1338E+01_JPRB,1.2921E+01_JPRB/)
KAO( :, 1, 5,13) = (/&
&1.4114E+01_JPRB,1.2350E+01_JPRB,1.0930E+01_JPRB,9.8909E+00_JPRB,9.2442E+00_JPRB,8.6849E+00_JPRB,&
&8.0205E+00_JPRB,9.0018E+00_JPRB,1.0281E+01_JPRB/)
KAO( :, 2, 5,13) = (/&
&1.4481E+01_JPRB,1.2671E+01_JPRB,1.1207E+01_JPRB,1.0236E+01_JPRB,9.4445E+00_JPRB,8.8064E+00_JPRB,&
&8.3341E+00_JPRB,9.5712E+00_JPRB,1.0927E+01_JPRB/)
KAO( :, 3, 5,13) = (/&
&1.4780E+01_JPRB,1.2933E+01_JPRB,1.1441E+01_JPRB,1.0504E+01_JPRB,9.5949E+00_JPRB,8.9267E+00_JPRB,&
&8.7559E+00_JPRB,1.0193E+01_JPRB,1.1635E+01_JPRB/)
KAO( :, 4, 5,13) = (/&
&1.5014E+01_JPRB,1.3137E+01_JPRB,1.1651E+01_JPRB,1.0704E+01_JPRB,9.7669E+00_JPRB,9.0159E+00_JPRB,&
&9.2560E+00_JPRB,1.0797E+01_JPRB,1.2325E+01_JPRB/)
KAO( :, 5, 5,13) = (/&
&1.5187E+01_JPRB,1.3289E+01_JPRB,1.1815E+01_JPRB,1.0866E+01_JPRB,9.8919E+00_JPRB,9.1157E+00_JPRB,&
&9.8156E+00_JPRB,1.1450E+01_JPRB,1.3070E+01_JPRB/)
KAO( :, 1, 6,13) = (/&
&1.5160E+01_JPRB,1.3265E+01_JPRB,1.1763E+01_JPRB,1.0744E+01_JPRB,9.7606E+00_JPRB,8.8908E+00_JPRB,&
&8.2258E+00_JPRB,8.8849E+00_JPRB,1.0152E+01_JPRB/)
KAO( :, 2, 6,13) = (/&
&1.5549E+01_JPRB,1.3605E+01_JPRB,1.2084E+01_JPRB,1.1112E+01_JPRB,1.0034E+01_JPRB,9.1009E+00_JPRB,&
&8.4931E+00_JPRB,9.5055E+00_JPRB,1.0858E+01_JPRB/)
KAO( :, 3, 6,13) = (/&
&1.5873E+01_JPRB,1.3889E+01_JPRB,1.2356E+01_JPRB,1.1403E+01_JPRB,1.0281E+01_JPRB,9.2837E+00_JPRB,&
&8.8721E+00_JPRB,1.0170E+01_JPRB,1.1619E+01_JPRB/)
KAO( :, 4, 6,13) = (/&
&1.6112E+01_JPRB,1.4098E+01_JPRB,1.2586E+01_JPRB,1.1634E+01_JPRB,1.0494E+01_JPRB,9.4499E+00_JPRB,&
&9.3030E+00_JPRB,1.0807E+01_JPRB,1.2339E+01_JPRB/)
KAO( :, 5, 6,13) = (/&
&1.6286E+01_JPRB,1.4252E+01_JPRB,1.2775E+01_JPRB,1.1818E+01_JPRB,1.0693E+01_JPRB,9.5647E+00_JPRB,&
&9.8402E+00_JPRB,1.1469E+01_JPRB,1.3094E+01_JPRB/)
KAO( :, 1, 7,13) = (/&
&1.6122E+01_JPRB,1.4109E+01_JPRB,1.2562E+01_JPRB,1.1505E+01_JPRB,1.0368E+01_JPRB,9.2585E+00_JPRB,&
&8.3696E+00_JPRB,8.5768E+00_JPRB,9.8029E+00_JPRB/)
KAO( :, 2, 7,13) = (/&
&1.6526E+01_JPRB,1.4471E+01_JPRB,1.2919E+01_JPRB,1.1924E+01_JPRB,1.0722E+01_JPRB,9.5715E+00_JPRB,&
&8.6023E+00_JPRB,9.2393E+00_JPRB,1.0560E+01_JPRB/)
KAO( :, 3, 7,13) = (/&
&1.6858E+01_JPRB,1.4770E+01_JPRB,1.3234E+01_JPRB,1.2238E+01_JPRB,1.1035E+01_JPRB,9.8187E+00_JPRB,&
&8.9328E+00_JPRB,9.9387E+00_JPRB,1.1350E+01_JPRB/)
KAO( :, 4, 7,13) = (/&
&1.7093E+01_JPRB,1.4987E+01_JPRB,1.3501E+01_JPRB,1.2504E+01_JPRB,1.1279E+01_JPRB,1.0055E+01_JPRB,&
&9.3088E+00_JPRB,1.0608E+01_JPRB,1.2111E+01_JPRB/)
KAO( :, 5, 7,13) = (/&
&1.7259E+01_JPRB,1.5142E+01_JPRB,1.3707E+01_JPRB,1.2711E+01_JPRB,1.1518E+01_JPRB,1.0206E+01_JPRB,&
&9.7355E+00_JPRB,1.1291E+01_JPRB,1.2889E+01_JPRB/)
KAO( :, 1, 8,13) = (/&
&1.6916E+01_JPRB,1.4832E+01_JPRB,1.3277E+01_JPRB,1.2204E+01_JPRB,1.0940E+01_JPRB,9.7472E+00_JPRB,&
&8.4449E+00_JPRB,8.0133E+00_JPRB,9.1571E+00_JPRB/)
KAO( :, 2, 8,13) = (/&
&1.7329E+01_JPRB,1.5217E+01_JPRB,1.3686E+01_JPRB,1.2639E+01_JPRB,1.1376E+01_JPRB,1.0148E+01_JPRB,&
&8.6472E+00_JPRB,8.7212E+00_JPRB,9.9586E+00_JPRB/)
KAO( :, 3, 8,13) = (/&
&1.7658E+01_JPRB,1.5525E+01_JPRB,1.4035E+01_JPRB,1.3005E+01_JPRB,1.1745E+01_JPRB,1.0456E+01_JPRB,&
&8.9277E+00_JPRB,9.4462E+00_JPRB,1.0783E+01_JPRB/)
KAO( :, 4, 8,13) = (/&
&1.7910E+01_JPRB,1.5764E+01_JPRB,1.4326E+01_JPRB,1.3292E+01_JPRB,1.2039E+01_JPRB,1.0730E+01_JPRB,&
&9.2875E+00_JPRB,1.0174E+01_JPRB,1.1613E+01_JPRB/)
KAO( :, 5, 8,13) = (/&
&1.8061E+01_JPRB,1.5911E+01_JPRB,1.4552E+01_JPRB,1.3522E+01_JPRB,1.2313E+01_JPRB,1.0922E+01_JPRB,&
&9.6669E+00_JPRB,1.0913E+01_JPRB,1.2458E+01_JPRB/)
KAO( :, 1, 9,13) = (/&
&1.7489E+01_JPRB,1.5390E+01_JPRB,1.3855E+01_JPRB,1.2753E+01_JPRB,1.1443E+01_JPRB,1.0269E+01_JPRB,&
&8.6020E+00_JPRB,7.3519E+00_JPRB,8.3472E+00_JPRB/)
KAO( :, 2, 9,13) = (/&
&1.7914E+01_JPRB,1.5791E+01_JPRB,1.4307E+01_JPRB,1.3235E+01_JPRB,1.1959E+01_JPRB,1.0725E+01_JPRB,&
&8.8103E+00_JPRB,8.0533E+00_JPRB,9.1895E+00_JPRB/)
KAO( :, 3, 9,13) = (/&
&1.8257E+01_JPRB,1.6119E+01_JPRB,1.4693E+01_JPRB,1.3625E+01_JPRB,1.2389E+01_JPRB,1.1058E+01_JPRB,&
&9.0504E+00_JPRB,8.8002E+00_JPRB,1.0042E+01_JPRB/)
KAO( :, 4, 9,13) = (/&
&1.8479E+01_JPRB,1.6338E+01_JPRB,1.5015E+01_JPRB,1.3939E+01_JPRB,1.2757E+01_JPRB,1.1337E+01_JPRB,&
&9.3866E+00_JPRB,9.5953E+00_JPRB,1.0949E+01_JPRB/)
KAO( :, 5, 9,13) = (/&
&1.8635E+01_JPRB,1.6495E+01_JPRB,1.5249E+01_JPRB,1.4201E+01_JPRB,1.3054E+01_JPRB,1.1574E+01_JPRB,&
&9.7301E+00_JPRB,1.0376E+01_JPRB,1.1842E+01_JPRB/)
KAO( :, 1,10,13) = (/&
&1.7834E+01_JPRB,1.5755E+01_JPRB,1.4296E+01_JPRB,1.3173E+01_JPRB,1.1876E+01_JPRB,1.0672E+01_JPRB,&
&8.8079E+00_JPRB,6.8283E+00_JPRB,7.5346E+00_JPRB/)
KAO( :, 2,10,13) = (/&
&1.8252E+01_JPRB,1.6162E+01_JPRB,1.4783E+01_JPRB,1.3694E+01_JPRB,1.2464E+01_JPRB,1.1197E+01_JPRB,&
&9.0829E+00_JPRB,7.4323E+00_JPRB,8.3917E+00_JPRB/)
KAO( :, 3,10,13) = (/&
&1.8558E+01_JPRB,1.6468E+01_JPRB,1.5228E+01_JPRB,1.4086E+01_JPRB,1.2957E+01_JPRB,1.1559E+01_JPRB,&
&9.3588E+00_JPRB,8.1767E+00_JPRB,9.3163E+00_JPRB/)
KAO( :, 4,10,13) = (/&
&1.8778E+01_JPRB,1.6694E+01_JPRB,1.5535E+01_JPRB,1.4435E+01_JPRB,1.3366E+01_JPRB,1.1847E+01_JPRB,&
&9.6760E+00_JPRB,9.0005E+00_JPRB,1.0268E+01_JPRB/)
KAO( :, 5,10,13) = (/&
&1.8909E+01_JPRB,1.6834E+01_JPRB,1.5762E+01_JPRB,1.4717E+01_JPRB,1.3710E+01_JPRB,1.2145E+01_JPRB,&
&1.0011E+01_JPRB,9.8258E+00_JPRB,1.1210E+01_JPRB/)
KAO( :, 1,11,13) = (/&
&1.8087E+01_JPRB,1.6075E+01_JPRB,1.4790E+01_JPRB,1.3655E+01_JPRB,1.2497E+01_JPRB,1.1191E+01_JPRB,&
&9.1399E+00_JPRB,6.6933E+00_JPRB,7.1162E+00_JPRB/)
KAO( :, 2,11,13) = (/&
&1.8432E+01_JPRB,1.6428E+01_JPRB,1.5277E+01_JPRB,1.4152E+01_JPRB,1.3089E+01_JPRB,1.1695E+01_JPRB,&
&9.4501E+00_JPRB,7.3057E+00_JPRB,8.0369E+00_JPRB/)
KAO( :, 3,11,13) = (/&
&1.8659E+01_JPRB,1.6669E+01_JPRB,1.5627E+01_JPRB,1.4589E+01_JPRB,1.3582E+01_JPRB,1.2037E+01_JPRB,&
&9.8265E+00_JPRB,8.0558E+00_JPRB,9.0157E+00_JPRB/)
KAO( :, 4,11,13) = (/&
&1.8822E+01_JPRB,1.6850E+01_JPRB,1.5905E+01_JPRB,1.4936E+01_JPRB,1.3964E+01_JPRB,1.2377E+01_JPRB,&
&1.0203E+01_JPRB,8.8302E+00_JPRB,9.9768E+00_JPRB/)
KAO( :, 5,11,13) = (/&
&1.8912E+01_JPRB,1.6973E+01_JPRB,1.6104E+01_JPRB,1.5218E+01_JPRB,1.4312E+01_JPRB,1.2701E+01_JPRB,&
&1.0619E+01_JPRB,9.6452E+00_JPRB,1.0951E+01_JPRB/)
KAO( :, 1,12,13) = (/&
&1.7920E+01_JPRB,1.6053E+01_JPRB,1.5019E+01_JPRB,1.3982E+01_JPRB,1.2926E+01_JPRB,1.1508E+01_JPRB,&
&9.3716E+00_JPRB,6.7503E+00_JPRB,6.7740E+00_JPRB/)
KAO( :, 2,12,13) = (/&
&1.8186E+01_JPRB,1.6353E+01_JPRB,1.5440E+01_JPRB,1.4490E+01_JPRB,1.3495E+01_JPRB,1.1962E+01_JPRB,&
&9.7745E+00_JPRB,7.3828E+00_JPRB,7.7336E+00_JPRB/)
KAO( :, 3,12,13) = (/&
&1.8384E+01_JPRB,1.6588E+01_JPRB,1.5763E+01_JPRB,1.4906E+01_JPRB,1.3939E+01_JPRB,1.2345E+01_JPRB,&
&1.0238E+01_JPRB,8.0656E+00_JPRB,8.6667E+00_JPRB/)
KAO( :, 4,12,13) = (/&
&1.8509E+01_JPRB,1.6759E+01_JPRB,1.6033E+01_JPRB,1.5245E+01_JPRB,1.4313E+01_JPRB,1.2752E+01_JPRB,&
&1.0707E+01_JPRB,8.7818E+00_JPRB,9.6176E+00_JPRB/)
KAO( :, 5,12,13) = (/&
&1.8577E+01_JPRB,1.6881E+01_JPRB,1.6239E+01_JPRB,1.5529E+01_JPRB,1.4670E+01_JPRB,1.3127E+01_JPRB,&
&1.1210E+01_JPRB,9.5549E+00_JPRB,1.0594E+01_JPRB/)
KAO( :, 1,13,13) = (/&
&1.7404E+01_JPRB,1.5741E+01_JPRB,1.4917E+01_JPRB,1.4087E+01_JPRB,1.3107E+01_JPRB,1.1569E+01_JPRB,&
&9.5101E+00_JPRB,6.9448E+00_JPRB,6.4373E+00_JPRB/)
KAO( :, 2,13,13) = (/&
&1.7616E+01_JPRB,1.6021E+01_JPRB,1.5315E+01_JPRB,1.4593E+01_JPRB,1.3608E+01_JPRB,1.2031E+01_JPRB,&
&1.0008E+01_JPRB,7.5382E+00_JPRB,7.3336E+00_JPRB/)
KAO( :, 3,13,13) = (/&
&1.7758E+01_JPRB,1.6239E+01_JPRB,1.5665E+01_JPRB,1.5009E+01_JPRB,1.4000E+01_JPRB,1.2479E+01_JPRB,&
&1.0559E+01_JPRB,8.1609E+00_JPRB,8.2503E+00_JPRB/)
KAO( :, 4,13,13) = (/&
&1.7857E+01_JPRB,1.6408E+01_JPRB,1.5937E+01_JPRB,1.5347E+01_JPRB,1.4396E+01_JPRB,1.2961E+01_JPRB,&
&1.1094E+01_JPRB,8.8199E+00_JPRB,9.1733E+00_JPRB/)
KAO( :, 5,13,13) = (/&
&1.7901E+01_JPRB,1.6530E+01_JPRB,1.6155E+01_JPRB,1.5663E+01_JPRB,1.4778E+01_JPRB,1.3417E+01_JPRB,&
&1.1660E+01_JPRB,9.5134E+00_JPRB,1.0096E+01_JPRB/)
KAO( :, 1, 1,14) = (/&
&1.8068E+01_JPRB,1.5810E+01_JPRB,1.3551E+01_JPRB,1.1831E+01_JPRB,1.0304E+01_JPRB,9.7990E+00_JPRB,&
&1.1739E+01_JPRB,1.3692E+01_JPRB,1.5004E+01_JPRB/)
KAO( :, 2, 1,14) = (/&
&1.7600E+01_JPRB,1.5400E+01_JPRB,1.3200E+01_JPRB,1.1647E+01_JPRB,1.0167E+01_JPRB,1.0174E+01_JPRB,&
&1.2204E+01_JPRB,1.4235E+01_JPRB,1.5608E+01_JPRB/)
KAO( :, 3, 1,14) = (/&
&1.7123E+01_JPRB,1.4983E+01_JPRB,1.2843E+01_JPRB,1.1396E+01_JPRB,1.0063E+01_JPRB,1.0510E+01_JPRB,&
&1.2607E+01_JPRB,1.4704E+01_JPRB,1.6115E+01_JPRB/)
KAO( :, 4, 1,14) = (/&
&1.6641E+01_JPRB,1.4561E+01_JPRB,1.2481E+01_JPRB,1.1106E+01_JPRB,9.9075E+00_JPRB,1.0883E+01_JPRB,&
&1.3055E+01_JPRB,1.5227E+01_JPRB,1.6651E+01_JPRB/)
KAO( :, 5, 1,14) = (/&
&1.6173E+01_JPRB,1.4152E+01_JPRB,1.2130E+01_JPRB,1.0803E+01_JPRB,9.8573E+00_JPRB,1.1271E+01_JPRB,&
&1.3520E+01_JPRB,1.5769E+01_JPRB,1.7251E+01_JPRB/)
KAO( :, 1, 2,14) = (/&
&1.8801E+01_JPRB,1.6451E+01_JPRB,1.4101E+01_JPRB,1.2604E+01_JPRB,1.1011E+01_JPRB,1.0737E+01_JPRB,&
&1.2792E+01_JPRB,1.4921E+01_JPRB,1.6625E+01_JPRB/)
KAO( :, 2, 2,14) = (/&
&1.8304E+01_JPRB,1.6016E+01_JPRB,1.3728E+01_JPRB,1.2330E+01_JPRB,1.0982E+01_JPRB,1.1096E+01_JPRB,&
&1.3301E+01_JPRB,1.5514E+01_JPRB,1.7306E+01_JPRB/)
KAO( :, 3, 2,14) = (/&
&1.7801E+01_JPRB,1.5576E+01_JPRB,1.3356E+01_JPRB,1.2016E+01_JPRB,1.0871E+01_JPRB,1.1458E+01_JPRB,&
&1.3745E+01_JPRB,1.6031E+01_JPRB,1.7874E+01_JPRB/)
KAO( :, 4, 2,14) = (/&
&1.7309E+01_JPRB,1.5145E+01_JPRB,1.3007E+01_JPRB,1.1693E+01_JPRB,1.0730E+01_JPRB,1.1860E+01_JPRB,&
&1.4227E+01_JPRB,1.6594E+01_JPRB,1.8476E+01_JPRB/)
KAO( :, 5, 2,14) = (/&
&1.6850E+01_JPRB,1.4744E+01_JPRB,1.2687E+01_JPRB,1.1410E+01_JPRB,1.0694E+01_JPRB,1.2279E+01_JPRB,&
&1.4731E+01_JPRB,1.7182E+01_JPRB,1.9118E+01_JPRB/)
KAO( :, 1, 3,14) = (/&
&1.9584E+01_JPRB,1.7136E+01_JPRB,1.4732E+01_JPRB,1.3313E+01_JPRB,1.1884E+01_JPRB,1.1593E+01_JPRB,&
&1.3636E+01_JPRB,1.5905E+01_JPRB,1.7983E+01_JPRB/)
KAO( :, 2, 3,14) = (/&
&1.9076E+01_JPRB,1.6691E+01_JPRB,1.4400E+01_JPRB,1.2989E+01_JPRB,1.1901E+01_JPRB,1.1927E+01_JPRB,&
&1.4231E+01_JPRB,1.6600E+01_JPRB,1.8761E+01_JPRB/)
KAO( :, 3, 3,14) = (/&
&1.8574E+01_JPRB,1.6253E+01_JPRB,1.4065E+01_JPRB,1.2664E+01_JPRB,1.1748E+01_JPRB,1.2312E+01_JPRB,&
&1.4771E+01_JPRB,1.7229E+01_JPRB,1.9465E+01_JPRB/)
KAO( :, 4, 3,14) = (/&
&1.8102E+01_JPRB,1.5839E+01_JPRB,1.3744E+01_JPRB,1.2408E+01_JPRB,1.1592E+01_JPRB,1.2780E+01_JPRB,&
&1.5332E+01_JPRB,1.7885E+01_JPRB,2.0196E+01_JPRB/)
KAO( :, 5, 3,14) = (/&
&1.7642E+01_JPRB,1.5437E+01_JPRB,1.3436E+01_JPRB,1.2180E+01_JPRB,1.1540E+01_JPRB,1.3243E+01_JPRB,&
&1.5887E+01_JPRB,1.8532E+01_JPRB,2.0924E+01_JPRB/)
KAO( :, 1, 4,14) = (/&
&2.0389E+01_JPRB,1.7840E+01_JPRB,1.5486E+01_JPRB,1.3966E+01_JPRB,1.2815E+01_JPRB,1.2346E+01_JPRB,&
&1.4297E+01_JPRB,1.6677E+01_JPRB,1.8970E+01_JPRB/)
KAO( :, 2, 4,14) = (/&
&1.9917E+01_JPRB,1.7427E+01_JPRB,1.5179E+01_JPRB,1.3667E+01_JPRB,1.2793E+01_JPRB,1.2684E+01_JPRB,&
&1.5037E+01_JPRB,1.7540E+01_JPRB,1.9955E+01_JPRB/)
KAO( :, 3, 4,14) = (/&
&1.9473E+01_JPRB,1.7039E+01_JPRB,1.4867E+01_JPRB,1.3426E+01_JPRB,1.2614E+01_JPRB,1.3089E+01_JPRB,&
&1.5675E+01_JPRB,1.8284E+01_JPRB,2.0800E+01_JPRB/)
KAO( :, 4, 4,14) = (/&
&1.9059E+01_JPRB,1.6676E+01_JPRB,1.4584E+01_JPRB,1.3222E+01_JPRB,1.2465E+01_JPRB,1.3596E+01_JPRB,&
&1.6312E+01_JPRB,1.9027E+01_JPRB,2.1639E+01_JPRB/)
KAO( :, 5, 4,14) = (/&
&1.8705E+01_JPRB,1.6367E+01_JPRB,1.4344E+01_JPRB,1.3059E+01_JPRB,1.2388E+01_JPRB,1.4128E+01_JPRB,&
&1.6951E+01_JPRB,1.9772E+01_JPRB,2.2482E+01_JPRB/)
KAO( :, 1, 5,14) = (/&
&2.1405E+01_JPRB,1.8730E+01_JPRB,1.6310E+01_JPRB,1.4662E+01_JPRB,1.3708E+01_JPRB,1.2986E+01_JPRB,&
&1.4754E+01_JPRB,1.7211E+01_JPRB,1.9632E+01_JPRB/)
KAO( :, 2, 5,14) = (/&
&2.1056E+01_JPRB,1.8424E+01_JPRB,1.6104E+01_JPRB,1.4452E+01_JPRB,1.3630E+01_JPRB,1.3357E+01_JPRB,&
&1.5611E+01_JPRB,1.8209E+01_JPRB,2.0772E+01_JPRB/)
KAO( :, 3, 5,14) = (/&
&2.0747E+01_JPRB,1.8154E+01_JPRB,1.5912E+01_JPRB,1.4296E+01_JPRB,1.3454E+01_JPRB,1.3757E+01_JPRB,&
&1.6382E+01_JPRB,1.9110E+01_JPRB,2.1795E+01_JPRB/)
KAO( :, 4, 5,14) = (/&
&2.0481E+01_JPRB,1.7921E+01_JPRB,1.5733E+01_JPRB,1.4190E+01_JPRB,1.3288E+01_JPRB,1.4283E+01_JPRB,&
&1.7134E+01_JPRB,1.9987E+01_JPRB,2.2797E+01_JPRB/)
KAO( :, 5, 5,14) = (/&
&2.0280E+01_JPRB,1.7745E+01_JPRB,1.5569E+01_JPRB,1.4068E+01_JPRB,1.3222E+01_JPRB,1.4895E+01_JPRB,&
&1.7870E+01_JPRB,2.0845E+01_JPRB,2.3770E+01_JPRB/)
KAO( :, 1, 6,14) = (/&
&2.2830E+01_JPRB,1.9976E+01_JPRB,1.7445E+01_JPRB,1.5500E+01_JPRB,1.4530E+01_JPRB,1.3547E+01_JPRB,&
&1.4948E+01_JPRB,1.7437E+01_JPRB,1.9911E+01_JPRB/)
KAO( :, 2, 6,14) = (/&
&2.2630E+01_JPRB,1.9801E+01_JPRB,1.7366E+01_JPRB,1.5418E+01_JPRB,1.4459E+01_JPRB,1.3928E+01_JPRB,&
&1.5968E+01_JPRB,1.8628E+01_JPRB,2.1268E+01_JPRB/)
KAO( :, 3, 6,14) = (/&
&2.2482E+01_JPRB,1.9672E+01_JPRB,1.7308E+01_JPRB,1.5393E+01_JPRB,1.4260E+01_JPRB,1.4337E+01_JPRB,&
&1.6867E+01_JPRB,1.9676E+01_JPRB,2.2466E+01_JPRB/)
KAO( :, 4, 6,14) = (/&
&2.2407E+01_JPRB,1.9606E+01_JPRB,1.7216E+01_JPRB,1.5390E+01_JPRB,1.4119E+01_JPRB,1.4843E+01_JPRB,&
&1.7739E+01_JPRB,2.0693E+01_JPRB,2.3625E+01_JPRB/)
KAO( :, 5, 6,14) = (/&
&2.2367E+01_JPRB,1.9571E+01_JPRB,1.7137E+01_JPRB,1.5329E+01_JPRB,1.4055E+01_JPRB,1.5517E+01_JPRB,&
&1.8617E+01_JPRB,2.1718E+01_JPRB,2.4792E+01_JPRB/)
KAO( :, 1, 7,14) = (/&
&2.4592E+01_JPRB,2.1518E+01_JPRB,1.8856E+01_JPRB,1.6609E+01_JPRB,1.5320E+01_JPRB,1.4052E+01_JPRB,&
&1.5041E+01_JPRB,1.7546E+01_JPRB,2.0045E+01_JPRB/)
KAO( :, 2, 7,14) = (/&
&2.4606E+01_JPRB,2.1531E+01_JPRB,1.8929E+01_JPRB,1.6667E+01_JPRB,1.5279E+01_JPRB,1.4417E+01_JPRB,&
&1.6211E+01_JPRB,1.8911E+01_JPRB,2.1602E+01_JPRB/)
KAO( :, 3, 7,14) = (/&
&2.4628E+01_JPRB,2.1549E+01_JPRB,1.8928E+01_JPRB,1.6801E+01_JPRB,1.5124E+01_JPRB,1.4851E+01_JPRB,&
&1.7257E+01_JPRB,2.0131E+01_JPRB,2.2994E+01_JPRB/)
KAO( :, 4, 7,14) = (/&
&2.4701E+01_JPRB,2.1614E+01_JPRB,1.8944E+01_JPRB,1.6872E+01_JPRB,1.5057E+01_JPRB,1.5367E+01_JPRB,&
&1.8273E+01_JPRB,2.1316E+01_JPRB,2.4350E+01_JPRB/)
KAO( :, 5, 7,14) = (/&
&2.4745E+01_JPRB,2.1652E+01_JPRB,1.8953E+01_JPRB,1.6836E+01_JPRB,1.5058E+01_JPRB,1.6097E+01_JPRB,&
&1.9310E+01_JPRB,2.2526E+01_JPRB,2.5728E+01_JPRB/)
KAO( :, 1, 8,14) = (/&
&2.6722E+01_JPRB,2.3382E+01_JPRB,2.0515E+01_JPRB,1.7956E+01_JPRB,1.6236E+01_JPRB,1.4458E+01_JPRB,&
&1.5041E+01_JPRB,1.7547E+01_JPRB,2.0050E+01_JPRB/)
KAO( :, 2, 8,14) = (/&
&2.6899E+01_JPRB,2.3537E+01_JPRB,2.0679E+01_JPRB,1.8189E+01_JPRB,1.6278E+01_JPRB,1.4827E+01_JPRB,&
&1.6369E+01_JPRB,1.9095E+01_JPRB,2.1820E+01_JPRB/)
KAO( :, 3, 8,14) = (/&
&2.7094E+01_JPRB,2.3707E+01_JPRB,2.0816E+01_JPRB,1.8418E+01_JPRB,1.6222E+01_JPRB,1.5309E+01_JPRB,&
&1.7578E+01_JPRB,2.0506E+01_JPRB,2.3432E+01_JPRB/)
KAO( :, 4, 8,14) = (/&
&2.7179E+01_JPRB,2.3782E+01_JPRB,2.0862E+01_JPRB,1.8540E+01_JPRB,1.6231E+01_JPRB,1.5886E+01_JPRB,&
&1.8721E+01_JPRB,2.1839E+01_JPRB,2.4952E+01_JPRB/)
KAO( :, 5, 8,14) = (/&
&2.7158E+01_JPRB,2.3764E+01_JPRB,2.0818E+01_JPRB,1.8502E+01_JPRB,1.6332E+01_JPRB,1.6675E+01_JPRB,&
&1.9896E+01_JPRB,2.3208E+01_JPRB,2.6519E+01_JPRB/)
KAO( :, 1, 9,14) = (/&
&2.9121E+01_JPRB,2.5481E+01_JPRB,2.2378E+01_JPRB,1.9520E+01_JPRB,1.7350E+01_JPRB,1.4884E+01_JPRB,&
&1.4926E+01_JPRB,1.7361E+01_JPRB,1.9841E+01_JPRB/)
KAO( :, 2, 9,14) = (/&
&2.9461E+01_JPRB,2.5779E+01_JPRB,2.2643E+01_JPRB,1.9924E+01_JPRB,1.7494E+01_JPRB,1.5326E+01_JPRB,&
&1.6362E+01_JPRB,1.9088E+01_JPRB,2.1811E+01_JPRB/)
KAO( :, 3, 9,14) = (/&
&2.9610E+01_JPRB,2.5909E+01_JPRB,2.2771E+01_JPRB,2.0181E+01_JPRB,1.7582E+01_JPRB,1.5909E+01_JPRB,&
&1.7732E+01_JPRB,2.0686E+01_JPRB,2.3639E+01_JPRB/)
KAO( :, 4, 9,14) = (/&
&2.9659E+01_JPRB,2.5951E+01_JPRB,2.2782E+01_JPRB,2.0281E+01_JPRB,1.7675E+01_JPRB,1.6616E+01_JPRB,&
&1.9018E+01_JPRB,2.2187E+01_JPRB,2.5355E+01_JPRB/)
KAO( :, 5, 9,14) = (/&
&2.9568E+01_JPRB,2.5872E+01_JPRB,2.2719E+01_JPRB,2.0302E+01_JPRB,1.7861E+01_JPRB,1.7429E+01_JPRB,&
&2.0313E+01_JPRB,2.3697E+01_JPRB,2.7083E+01_JPRB/)
KAO( :, 1,10,14) = (/&
&3.1663E+01_JPRB,2.7706E+01_JPRB,2.4344E+01_JPRB,2.1280E+01_JPRB,1.8643E+01_JPRB,1.5678E+01_JPRB,&
&1.4935E+01_JPRB,1.7101E+01_JPRB,1.9544E+01_JPRB/)
KAO( :, 2,10,14) = (/&
&3.1965E+01_JPRB,2.7969E+01_JPRB,2.4607E+01_JPRB,2.1722E+01_JPRB,1.8925E+01_JPRB,1.6156E+01_JPRB,&
&1.6364E+01_JPRB,1.9004E+01_JPRB,2.1720E+01_JPRB/)
KAO( :, 3,10,14) = (/&
&3.2079E+01_JPRB,2.8070E+01_JPRB,2.4675E+01_JPRB,2.1979E+01_JPRB,1.9142E+01_JPRB,1.6843E+01_JPRB,&
&1.7782E+01_JPRB,2.0734E+01_JPRB,2.3694E+01_JPRB/)
KAO( :, 4,10,14) = (/&
&3.2076E+01_JPRB,2.8066E+01_JPRB,2.4720E+01_JPRB,2.2134E+01_JPRB,1.9355E+01_JPRB,1.7612E+01_JPRB,&
&1.9151E+01_JPRB,2.2342E+01_JPRB,2.5534E+01_JPRB/)
KAO( :, 5,10,14) = (/&
&3.2013E+01_JPRB,2.8013E+01_JPRB,2.4760E+01_JPRB,2.2247E+01_JPRB,1.9618E+01_JPRB,1.8439E+01_JPRB,&
&2.0533E+01_JPRB,2.3954E+01_JPRB,2.7375E+01_JPRB/)
KAO( :, 1,11,14) = (/&
&3.4213E+01_JPRB,2.9936E+01_JPRB,2.6354E+01_JPRB,2.3259E+01_JPRB,2.0227E+01_JPRB,1.7029E+01_JPRB,&
&1.5715E+01_JPRB,1.7610E+01_JPRB,2.0126E+01_JPRB/)
KAO( :, 2,11,14) = (/&
&3.4370E+01_JPRB,3.0074E+01_JPRB,2.6508E+01_JPRB,2.3642E+01_JPRB,2.0586E+01_JPRB,1.7628E+01_JPRB,&
&1.7120E+01_JPRB,1.9500E+01_JPRB,2.2284E+01_JPRB/)
KAO( :, 3,11,14) = (/&
&3.4467E+01_JPRB,3.0174E+01_JPRB,2.6677E+01_JPRB,2.3905E+01_JPRB,2.0930E+01_JPRB,1.8395E+01_JPRB,&
&1.8472E+01_JPRB,2.1240E+01_JPRB,2.4275E+01_JPRB/)
KAO( :, 4,11,14) = (/&
&3.4474E+01_JPRB,3.0204E+01_JPRB,2.6823E+01_JPRB,2.4177E+01_JPRB,2.1309E+01_JPRB,1.9245E+01_JPRB,&
&1.9858E+01_JPRB,2.2983E+01_JPRB,2.6259E+01_JPRB/)
KAO( :, 5,11,14) = (/&
&3.4438E+01_JPRB,3.0209E+01_JPRB,2.6964E+01_JPRB,2.4440E+01_JPRB,2.1741E+01_JPRB,2.0132E+01_JPRB,&
&2.1286E+01_JPRB,2.4694E+01_JPRB,2.8209E+01_JPRB/)
KAO( :, 1,12,14) = (/&
&3.6462E+01_JPRB,3.1921E+01_JPRB,2.8185E+01_JPRB,2.5122E+01_JPRB,2.1872E+01_JPRB,1.8703E+01_JPRB,&
&1.6650E+01_JPRB,1.7829E+01_JPRB,2.0376E+01_JPRB/)
KAO( :, 2,12,14) = (/&
&3.6640E+01_JPRB,3.2114E+01_JPRB,2.8470E+01_JPRB,2.5545E+01_JPRB,2.2388E+01_JPRB,1.9455E+01_JPRB,&
&1.8025E+01_JPRB,1.9728E+01_JPRB,2.2541E+01_JPRB/)
KAO( :, 3,12,14) = (/&
&3.6727E+01_JPRB,3.2238E+01_JPRB,2.8745E+01_JPRB,2.5954E+01_JPRB,2.2942E+01_JPRB,2.0299E+01_JPRB,&
&1.9338E+01_JPRB,2.1588E+01_JPRB,2.4664E+01_JPRB/)
KAO( :, 4,12,14) = (/&
&3.6769E+01_JPRB,3.2319E+01_JPRB,2.8973E+01_JPRB,2.6373E+01_JPRB,2.3500E+01_JPRB,2.1128E+01_JPRB,&
&2.0696E+01_JPRB,2.3398E+01_JPRB,2.6730E+01_JPRB/)
KAO( :, 5,12,14) = (/&
&3.6803E+01_JPRB,3.2384E+01_JPRB,2.9220E+01_JPRB,2.6759E+01_JPRB,2.4088E+01_JPRB,2.2049E+01_JPRB,&
&2.2111E+01_JPRB,2.5193E+01_JPRB,2.8777E+01_JPRB/)
KAO( :, 1,13,14) = (/&
&3.8467E+01_JPRB,3.3764E+01_JPRB,3.0006E+01_JPRB,2.6925E+01_JPRB,2.3614E+01_JPRB,2.0501E+01_JPRB,&
&1.7640E+01_JPRB,1.7695E+01_JPRB,2.0215E+01_JPRB/)
KAO( :, 2,13,14) = (/&
&3.8636E+01_JPRB,3.3983E+01_JPRB,3.0407E+01_JPRB,2.7476E+01_JPRB,2.4350E+01_JPRB,2.1406E+01_JPRB,&
&1.8958E+01_JPRB,1.9690E+01_JPRB,2.2491E+01_JPRB/)
KAO( :, 3,13,14) = (/&
&3.8793E+01_JPRB,3.4176E+01_JPRB,3.0759E+01_JPRB,2.8040E+01_JPRB,2.5106E+01_JPRB,2.2301E+01_JPRB,&
&2.0233E+01_JPRB,2.1614E+01_JPRB,2.4689E+01_JPRB/)
KAO( :, 4,13,14) = (/&
&3.8901E+01_JPRB,3.4320E+01_JPRB,3.1137E+01_JPRB,2.8555E+01_JPRB,2.5821E+01_JPRB,2.3168E+01_JPRB,&
&2.1608E+01_JPRB,2.3543E+01_JPRB,2.6893E+01_JPRB/)
KAO( :, 5,13,14) = (/&
&3.8995E+01_JPRB,3.4448E+01_JPRB,3.1494E+01_JPRB,2.9062E+01_JPRB,2.6523E+01_JPRB,2.4144E+01_JPRB,&
&2.3025E+01_JPRB,2.5501E+01_JPRB,2.9129E+01_JPRB/)
KAO( :, 1, 1,15) = (/&
&2.2665E+01_JPRB,1.9832E+01_JPRB,1.6999E+01_JPRB,1.4166E+01_JPRB,1.3383E+01_JPRB,1.5987E+01_JPRB,&
&1.9182E+01_JPRB,2.2378E+01_JPRB,2.4474E+01_JPRB/)
KAO( :, 2, 1,15) = (/&
&2.1844E+01_JPRB,1.9113E+01_JPRB,1.6383E+01_JPRB,1.3666E+01_JPRB,1.3442E+01_JPRB,1.6440E+01_JPRB,&
&1.9723E+01_JPRB,2.3008E+01_JPRB,2.5060E+01_JPRB/)
KAO( :, 3, 1,15) = (/&
&2.1030E+01_JPRB,1.8401E+01_JPRB,1.5773E+01_JPRB,1.3277E+01_JPRB,1.3532E+01_JPRB,1.6873E+01_JPRB,&
&2.0241E+01_JPRB,2.3609E+01_JPRB,2.5652E+01_JPRB/)
KAO( :, 4, 1,15) = (/&
&2.0230E+01_JPRB,1.7702E+01_JPRB,1.5173E+01_JPRB,1.2884E+01_JPRB,1.3829E+01_JPRB,1.7277E+01_JPRB,&
&2.0725E+01_JPRB,2.4172E+01_JPRB,2.6214E+01_JPRB/)
KAO( :, 5, 1,15) = (/&
&1.9446E+01_JPRB,1.7016E+01_JPRB,1.4585E+01_JPRB,1.2542E+01_JPRB,1.4133E+01_JPRB,1.7655E+01_JPRB,&
&2.1178E+01_JPRB,2.4699E+01_JPRB,2.6742E+01_JPRB/)
KAO( :, 1, 2,15) = (/&
&2.4301E+01_JPRB,2.1263E+01_JPRB,1.8226E+01_JPRB,1.5270E+01_JPRB,1.4740E+01_JPRB,1.7631E+01_JPRB,&
&2.1154E+01_JPRB,2.4675E+01_JPRB,2.7320E+01_JPRB/)
KAO( :, 2, 2,15) = (/&
&2.3371E+01_JPRB,2.0449E+01_JPRB,1.7528E+01_JPRB,1.4826E+01_JPRB,1.4773E+01_JPRB,1.8276E+01_JPRB,&
&2.1927E+01_JPRB,2.5577E+01_JPRB,2.8254E+01_JPRB/)
KAO( :, 3, 2,15) = (/&
&2.2456E+01_JPRB,1.9650E+01_JPRB,1.6843E+01_JPRB,1.4407E+01_JPRB,1.5106E+01_JPRB,1.8875E+01_JPRB,&
&2.2644E+01_JPRB,2.6416E+01_JPRB,2.9163E+01_JPRB/)
KAO( :, 4, 2,15) = (/&
&2.1563E+01_JPRB,1.8868E+01_JPRB,1.6173E+01_JPRB,1.4036E+01_JPRB,1.5558E+01_JPRB,1.9438E+01_JPRB,&
&2.3319E+01_JPRB,2.7202E+01_JPRB,2.9991E+01_JPRB/)
KAO( :, 5, 2,15) = (/&
&2.0691E+01_JPRB,1.8105E+01_JPRB,1.5519E+01_JPRB,1.3694E+01_JPRB,1.5968E+01_JPRB,1.9949E+01_JPRB,&
&2.3930E+01_JPRB,2.7910E+01_JPRB,3.0755E+01_JPRB/)
KAO( :, 1, 3,15) = (/&
&2.6150E+01_JPRB,2.2881E+01_JPRB,1.9612E+01_JPRB,1.6625E+01_JPRB,1.6080E+01_JPRB,1.9323E+01_JPRB,&
&2.3184E+01_JPRB,2.7047E+01_JPRB,3.0423E+01_JPRB/)
KAO( :, 2, 3,15) = (/&
&2.5095E+01_JPRB,2.1958E+01_JPRB,1.8821E+01_JPRB,1.6149E+01_JPRB,1.6204E+01_JPRB,2.0181E+01_JPRB,&
&2.4213E+01_JPRB,2.8246E+01_JPRB,3.1757E+01_JPRB/)
KAO( :, 3, 3,15) = (/&
&2.4070E+01_JPRB,2.1061E+01_JPRB,1.8052E+01_JPRB,1.5726E+01_JPRB,1.6789E+01_JPRB,2.0979E+01_JPRB,&
&2.5169E+01_JPRB,2.9357E+01_JPRB,3.2991E+01_JPRB/)
KAO( :, 4, 3,15) = (/&
&2.3070E+01_JPRB,2.0187E+01_JPRB,1.7303E+01_JPRB,1.5335E+01_JPRB,1.7368E+01_JPRB,2.1701E+01_JPRB,&
&2.6034E+01_JPRB,3.0366E+01_JPRB,3.4124E+01_JPRB/)
KAO( :, 5, 3,15) = (/&
&2.2104E+01_JPRB,1.9341E+01_JPRB,1.6579E+01_JPRB,1.4961E+01_JPRB,1.7892E+01_JPRB,2.2355E+01_JPRB,&
&2.6817E+01_JPRB,3.1278E+01_JPRB,3.5133E+01_JPRB/)
KAO( :, 1, 4,15) = (/&
&2.8084E+01_JPRB,2.4574E+01_JPRB,2.1063E+01_JPRB,1.8074E+01_JPRB,1.7393E+01_JPRB,2.1136E+01_JPRB,&
&2.5360E+01_JPRB,2.9584E+01_JPRB,3.3561E+01_JPRB/)
KAO( :, 2, 4,15) = (/&
&2.6902E+01_JPRB,2.3539E+01_JPRB,2.0176E+01_JPRB,1.7575E+01_JPRB,1.7767E+01_JPRB,2.2202E+01_JPRB,&
&2.6641E+01_JPRB,3.1076E+01_JPRB,3.5240E+01_JPRB/)
KAO( :, 3, 4,15) = (/&
&2.5761E+01_JPRB,2.2541E+01_JPRB,1.9321E+01_JPRB,1.7116E+01_JPRB,1.8559E+01_JPRB,2.3193E+01_JPRB,&
&2.7826E+01_JPRB,3.2458E+01_JPRB,3.6803E+01_JPRB/)
KAO( :, 4, 4,15) = (/&
&2.4660E+01_JPRB,2.1578E+01_JPRB,1.8496E+01_JPRB,1.6679E+01_JPRB,1.9285E+01_JPRB,2.4099E+01_JPRB,&
&2.8913E+01_JPRB,3.3725E+01_JPRB,3.8229E+01_JPRB/)
KAO( :, 5, 4,15) = (/&
&2.3603E+01_JPRB,2.0653E+01_JPRB,1.7702E+01_JPRB,1.6251E+01_JPRB,1.9930E+01_JPRB,2.4904E+01_JPRB,&
&2.9878E+01_JPRB,3.4850E+01_JPRB,3.9510E+01_JPRB/)
KAO( :, 1, 5,15) = (/&
&3.0121E+01_JPRB,2.6356E+01_JPRB,2.2591E+01_JPRB,1.9572E+01_JPRB,1.8803E+01_JPRB,2.3068E+01_JPRB,&
&2.7679E+01_JPRB,3.2291E+01_JPRB,3.6764E+01_JPRB/)
KAO( :, 2, 5,15) = (/&
&2.8817E+01_JPRB,2.5215E+01_JPRB,2.1613E+01_JPRB,1.9016E+01_JPRB,1.9519E+01_JPRB,2.4395E+01_JPRB,&
&2.9271E+01_JPRB,3.4145E+01_JPRB,3.8882E+01_JPRB/)
KAO( :, 3, 5,15) = (/&
&2.7566E+01_JPRB,2.4120E+01_JPRB,2.0674E+01_JPRB,1.8500E+01_JPRB,2.0501E+01_JPRB,2.5621E+01_JPRB,&
&3.0741E+01_JPRB,3.5860E+01_JPRB,4.0822E+01_JPRB/)
KAO( :, 4, 5,15) = (/&
&2.6363E+01_JPRB,2.3068E+01_JPRB,1.9789E+01_JPRB,1.8007E+01_JPRB,2.1387E+01_JPRB,2.6727E+01_JPRB,&
&3.2067E+01_JPRB,3.7405E+01_JPRB,4.2586E+01_JPRB/)
KAO( :, 5, 5,15) = (/&
&2.5212E+01_JPRB,2.2061E+01_JPRB,1.9051E+01_JPRB,1.7643E+01_JPRB,2.2182E+01_JPRB,2.7719E+01_JPRB,&
&3.3256E+01_JPRB,3.8795E+01_JPRB,4.4162E+01_JPRB/)
KAO( :, 1, 6,15) = (/&
&3.2321E+01_JPRB,2.8281E+01_JPRB,2.4241E+01_JPRB,2.1098E+01_JPRB,2.0339E+01_JPRB,2.4932E+01_JPRB,&
&2.9917E+01_JPRB,3.4901E+01_JPRB,3.9811E+01_JPRB/)
KAO( :, 2, 6,15) = (/&
&3.0886E+01_JPRB,2.7025E+01_JPRB,2.3164E+01_JPRB,2.0488E+01_JPRB,2.1264E+01_JPRB,2.6574E+01_JPRB,&
&3.1885E+01_JPRB,3.7195E+01_JPRB,4.2430E+01_JPRB/)
KAO( :, 3, 6,15) = (/&
&2.9511E+01_JPRB,2.5822E+01_JPRB,2.2177E+01_JPRB,1.9914E+01_JPRB,2.2458E+01_JPRB,2.8068E+01_JPRB,&
&3.3678E+01_JPRB,3.9285E+01_JPRB,4.4801E+01_JPRB/)
KAO( :, 4, 6,15) = (/&
&2.8199E+01_JPRB,2.4674E+01_JPRB,2.1349E+01_JPRB,1.9431E+01_JPRB,2.3532E+01_JPRB,2.9409E+01_JPRB,&
&3.5286E+01_JPRB,4.1160E+01_JPRB,4.6949E+01_JPRB/)
KAO( :, 5, 6,15) = (/&
&2.6942E+01_JPRB,2.3574E+01_JPRB,2.0489E+01_JPRB,1.9227E+01_JPRB,2.4487E+01_JPRB,3.0601E+01_JPRB,&
&3.6715E+01_JPRB,4.2828E+01_JPRB,4.8844E+01_JPRB/)
KAO( :, 1, 7,15) = (/&
&3.4610E+01_JPRB,3.0284E+01_JPRB,2.5957E+01_JPRB,2.2686E+01_JPRB,2.1900E+01_JPRB,2.6660E+01_JPRB,&
&3.1990E+01_JPRB,3.7320E+01_JPRB,4.2613E+01_JPRB/)
KAO( :, 2, 7,15) = (/&
&3.3032E+01_JPRB,2.8903E+01_JPRB,2.4823E+01_JPRB,2.1999E+01_JPRB,2.2959E+01_JPRB,2.8635E+01_JPRB,&
&3.4359E+01_JPRB,4.0081E+01_JPRB,4.5761E+01_JPRB/)
KAO( :, 3, 7,15) = (/&
&3.1543E+01_JPRB,2.7600E+01_JPRB,2.3940E+01_JPRB,2.1366E+01_JPRB,2.4341E+01_JPRB,3.0423E+01_JPRB,&
&3.6504E+01_JPRB,4.2582E+01_JPRB,4.8628E+01_JPRB/)
KAO( :, 4, 7,15) = (/&
&3.0190E+01_JPRB,2.6416E+01_JPRB,2.3001E+01_JPRB,2.1013E+01_JPRB,2.5623E+01_JPRB,3.2024E+01_JPRB,&
&3.8424E+01_JPRB,4.4822E+01_JPRB,5.1169E+01_JPRB/)
KAO( :, 5, 7,15) = (/&
&2.9167E+01_JPRB,2.5521E+01_JPRB,2.2165E+01_JPRB,2.1088E+01_JPRB,2.6745E+01_JPRB,3.3425E+01_JPRB,&
&4.0104E+01_JPRB,4.6781E+01_JPRB,5.3415E+01_JPRB/)
KAO( :, 1, 8,15) = (/&
&3.7034E+01_JPRB,3.2405E+01_JPRB,2.7803E+01_JPRB,2.4330E+01_JPRB,2.3433E+01_JPRB,2.8325E+01_JPRB,&
&3.3988E+01_JPRB,3.9652E+01_JPRB,4.5298E+01_JPRB/)
KAO( :, 2, 8,15) = (/&
&3.5387E+01_JPRB,3.0964E+01_JPRB,2.6815E+01_JPRB,2.3568E+01_JPRB,2.4642E+01_JPRB,3.0668E+01_JPRB,&
&3.6800E+01_JPRB,4.2932E+01_JPRB,4.9043E+01_JPRB/)
KAO( :, 3, 8,15) = (/&
&3.3957E+01_JPRB,2.9713E+01_JPRB,2.5844E+01_JPRB,2.3027E+01_JPRB,2.6228E+01_JPRB,3.2782E+01_JPRB,&
&3.9335E+01_JPRB,4.5888E+01_JPRB,5.2425E+01_JPRB/)
KAO( :, 4, 8,15) = (/&
&3.2996E+01_JPRB,2.8872E+01_JPRB,2.5090E+01_JPRB,2.2964E+01_JPRB,2.7731E+01_JPRB,3.4659E+01_JPRB,&
&4.1586E+01_JPRB,4.8516E+01_JPRB,5.5417E+01_JPRB/)
KAO( :, 5, 8,15) = (/&
&3.2468E+01_JPRB,2.8410E+01_JPRB,2.4743E+01_JPRB,2.3402E+01_JPRB,2.9047E+01_JPRB,3.6303E+01_JPRB,&
&4.3558E+01_JPRB,5.0811E+01_JPRB,5.8046E+01_JPRB/)
KAO( :, 1, 9,15) = (/&
&3.9783E+01_JPRB,3.4811E+01_JPRB,2.9994E+01_JPRB,2.6093E+01_JPRB,2.4971E+01_JPRB,2.9758E+01_JPRB,&
&3.5708E+01_JPRB,4.1658E+01_JPRB,4.7610E+01_JPRB/)
KAO( :, 2, 9,15) = (/&
&3.8247E+01_JPRB,3.3466E+01_JPRB,2.9067E+01_JPRB,2.5305E+01_JPRB,2.6362E+01_JPRB,3.2520E+01_JPRB,&
&3.9021E+01_JPRB,4.5520E+01_JPRB,5.2017E+01_JPRB/)
KAO( :, 3, 9,15) = (/&
&3.7366E+01_JPRB,3.2696E+01_JPRB,2.8422E+01_JPRB,2.5157E+01_JPRB,2.8053E+01_JPRB,3.4990E+01_JPRB,&
&4.1984E+01_JPRB,4.8979E+01_JPRB,5.5970E+01_JPRB/)
KAO( :, 4, 9,15) = (/&
&3.6951E+01_JPRB,3.2332E+01_JPRB,2.8166E+01_JPRB,2.5574E+01_JPRB,2.9746E+01_JPRB,3.7179E+01_JPRB,&
&4.4610E+01_JPRB,5.2042E+01_JPRB,5.9480E+01_JPRB/)
KAO( :, 5, 9,15) = (/&
&3.6807E+01_JPRB,3.2206E+01_JPRB,2.8238E+01_JPRB,2.6320E+01_JPRB,3.1345E+01_JPRB,3.9177E+01_JPRB,&
&4.7007E+01_JPRB,5.4838E+01_JPRB,6.2666E+01_JPRB/)
KAO( :, 1,10,15) = (/&
&4.3060E+01_JPRB,3.7677E+01_JPRB,3.2562E+01_JPRB,2.8079E+01_JPRB,2.6750E+01_JPRB,3.1106E+01_JPRB,&
&3.7325E+01_JPRB,4.3543E+01_JPRB,4.9762E+01_JPRB/)
KAO( :, 2,10,15) = (/&
&4.2169E+01_JPRB,3.6897E+01_JPRB,3.2071E+01_JPRB,2.7706E+01_JPRB,2.8300E+01_JPRB,3.4266E+01_JPRB,&
&4.1118E+01_JPRB,4.7968E+01_JPRB,5.4829E+01_JPRB/)
KAO( :, 3,10,15) = (/&
&4.1907E+01_JPRB,3.6669E+01_JPRB,3.1957E+01_JPRB,2.8123E+01_JPRB,3.0151E+01_JPRB,3.7151E+01_JPRB,&
&4.4578E+01_JPRB,5.2003E+01_JPRB,5.9438E+01_JPRB/)
KAO( :, 4,10,15) = (/&
&4.1908E+01_JPRB,3.6670E+01_JPRB,3.2098E+01_JPRB,2.8899E+01_JPRB,3.2061E+01_JPRB,3.9810E+01_JPRB,&
&4.7769E+01_JPRB,5.5728E+01_JPRB,6.3685E+01_JPRB/)
KAO( :, 5,10,15) = (/&
&4.2172E+01_JPRB,3.6900E+01_JPRB,3.2471E+01_JPRB,2.9889E+01_JPRB,3.3921E+01_JPRB,4.2203E+01_JPRB,&
&5.0640E+01_JPRB,5.9081E+01_JPRB,6.7523E+01_JPRB/)
KAO( :, 1,11,15) = (/&
&4.7323E+01_JPRB,4.1408E+01_JPRB,3.5997E+01_JPRB,3.0832E+01_JPRB,2.9578E+01_JPRB,3.3795E+01_JPRB,&
&4.0553E+01_JPRB,4.7310E+01_JPRB,5.4070E+01_JPRB/)
KAO( :, 2,11,15) = (/&
&4.7418E+01_JPRB,4.1491E+01_JPRB,3.6200E+01_JPRB,3.1353E+01_JPRB,3.1571E+01_JPRB,3.7371E+01_JPRB,&
&4.4844E+01_JPRB,5.2315E+01_JPRB,5.9798E+01_JPRB/)
KAO( :, 3,11,15) = (/&
&4.7687E+01_JPRB,4.1726E+01_JPRB,3.6545E+01_JPRB,3.2311E+01_JPRB,3.3701E+01_JPRB,4.0657E+01_JPRB,&
&4.8786E+01_JPRB,5.6913E+01_JPRB,6.5046E+01_JPRB/)
KAO( :, 4,11,15) = (/&
&4.8161E+01_JPRB,4.2141E+01_JPRB,3.7083E+01_JPRB,3.3405E+01_JPRB,3.5837E+01_JPRB,4.3612E+01_JPRB,&
&5.2330E+01_JPRB,6.1049E+01_JPRB,6.9766E+01_JPRB/)
KAO( :, 5,11,15) = (/&
&4.8813E+01_JPRB,4.2712E+01_JPRB,3.7729E+01_JPRB,3.4639E+01_JPRB,3.7893E+01_JPRB,4.6304E+01_JPRB,&
&5.5561E+01_JPRB,6.4817E+01_JPRB,7.4079E+01_JPRB/)
KAO( :, 1,12,15) = (/&
&5.3537E+01_JPRB,4.6845E+01_JPRB,4.0868E+01_JPRB,3.5074E+01_JPRB,3.3315E+01_JPRB,3.6716E+01_JPRB,&
&4.3952E+01_JPRB,5.1273E+01_JPRB,5.8607E+01_JPRB/)
KAO( :, 2,12,15) = (/&
&5.4108E+01_JPRB,4.7344E+01_JPRB,4.1453E+01_JPRB,3.6183E+01_JPRB,3.5626E+01_JPRB,4.0597E+01_JPRB,&
&4.8705E+01_JPRB,5.6822E+01_JPRB,6.4945E+01_JPRB/)
KAO( :, 3,12,15) = (/&
&5.4788E+01_JPRB,4.7940E+01_JPRB,4.2158E+01_JPRB,3.7480E+01_JPRB,3.7956E+01_JPRB,4.4233E+01_JPRB,&
&5.3076E+01_JPRB,6.1921E+01_JPRB,7.0769E+01_JPRB/)
KAO( :, 4,12,15) = (/&
&5.5656E+01_JPRB,4.8699E+01_JPRB,4.2978E+01_JPRB,3.8824E+01_JPRB,4.0296E+01_JPRB,4.7573E+01_JPRB,&
&5.7085E+01_JPRB,6.6598E+01_JPRB,7.6119E+01_JPRB/)
KAO( :, 5,12,15) = (/&
&5.6545E+01_JPRB,4.9477E+01_JPRB,4.3802E+01_JPRB,4.0209E+01_JPRB,4.2495E+01_JPRB,5.0548E+01_JPRB,&
&6.0654E+01_JPRB,7.0757E+01_JPRB,8.0864E+01_JPRB/)
KAO( :, 1,13,15) = (/&
&6.1085E+01_JPRB,5.3449E+01_JPRB,4.6803E+01_JPRB,4.0529E+01_JPRB,3.7896E+01_JPRB,4.0194E+01_JPRB,&
&4.7752E+01_JPRB,5.5708E+01_JPRB,6.3666E+01_JPRB/)
KAO( :, 2,13,15) = (/&
&6.2117E+01_JPRB,5.4352E+01_JPRB,4.7746E+01_JPRB,4.2003E+01_JPRB,4.0420E+01_JPRB,4.4278E+01_JPRB,&
&5.2905E+01_JPRB,6.1722E+01_JPRB,7.0545E+01_JPRB/)
KAO( :, 3,13,15) = (/&
&6.3149E+01_JPRB,5.5256E+01_JPRB,4.8730E+01_JPRB,4.3496E+01_JPRB,4.2927E+01_JPRB,4.8152E+01_JPRB,&
&5.7673E+01_JPRB,6.7281E+01_JPRB,7.6896E+01_JPRB/)
KAO( :, 4,13,15) = (/&
&6.4233E+01_JPRB,5.6204E+01_JPRB,4.9701E+01_JPRB,4.5014E+01_JPRB,4.5352E+01_JPRB,5.1670E+01_JPRB,&
&6.1941E+01_JPRB,7.2260E+01_JPRB,8.2578E+01_JPRB/)
KAO( :, 5,13,15) = (/&
&6.5315E+01_JPRB,5.7151E+01_JPRB,5.0642E+01_JPRB,4.6520E+01_JPRB,4.7583E+01_JPRB,5.4805E+01_JPRB,&
&6.5738E+01_JPRB,7.6689E+01_JPRB,8.7640E+01_JPRB/)
KAO( :, 1, 1,16) = (/&
&2.3217E+01_JPRB,2.0315E+01_JPRB,1.7413E+01_JPRB,1.4511E+01_JPRB,1.7128E+01_JPRB,2.1409E+01_JPRB,&
&2.5690E+01_JPRB,2.9970E+01_JPRB,3.1682E+01_JPRB/)
KAO( :, 2, 1,16) = (/&
&2.2360E+01_JPRB,1.9565E+01_JPRB,1.6770E+01_JPRB,1.3975E+01_JPRB,1.7727E+01_JPRB,2.2158E+01_JPRB,&
&2.6589E+01_JPRB,3.1019E+01_JPRB,3.2781E+01_JPRB/)
KAO( :, 3, 1,16) = (/&
&2.1511E+01_JPRB,1.8822E+01_JPRB,1.6134E+01_JPRB,1.3677E+01_JPRB,1.8236E+01_JPRB,2.2795E+01_JPRB,&
&2.7353E+01_JPRB,3.1910E+01_JPRB,3.3717E+01_JPRB/)
KAO( :, 4, 1,16) = (/&
&2.0675E+01_JPRB,1.8091E+01_JPRB,1.5507E+01_JPRB,1.4001E+01_JPRB,1.8668E+01_JPRB,2.3334E+01_JPRB,&
&2.8002E+01_JPRB,3.2666E+01_JPRB,3.4515E+01_JPRB/)
KAO( :, 5, 1,16) = (/&
&1.9862E+01_JPRB,1.7379E+01_JPRB,1.4897E+01_JPRB,1.4274E+01_JPRB,1.9032E+01_JPRB,2.3789E+01_JPRB,&
&2.8546E+01_JPRB,3.3301E+01_JPRB,3.5180E+01_JPRB/)
KAO( :, 1, 2,16) = (/&
&2.4993E+01_JPRB,2.1869E+01_JPRB,1.8745E+01_JPRB,1.5621E+01_JPRB,2.0288E+01_JPRB,2.5360E+01_JPRB,&
&3.0431E+01_JPRB,3.5501E+01_JPRB,3.8500E+01_JPRB/)
KAO( :, 2, 2,16) = (/&
&2.4003E+01_JPRB,2.1003E+01_JPRB,1.8003E+01_JPRB,1.5799E+01_JPRB,2.1064E+01_JPRB,2.6330E+01_JPRB,&
&3.1595E+01_JPRB,3.6859E+01_JPRB,3.9965E+01_JPRB/)
KAO( :, 3, 2,16) = (/&
&2.3031E+01_JPRB,2.0153E+01_JPRB,1.7274E+01_JPRB,1.6296E+01_JPRB,2.1728E+01_JPRB,2.7159E+01_JPRB,&
&3.2591E+01_JPRB,3.8020E+01_JPRB,4.1220E+01_JPRB/)
KAO( :, 4, 2,16) = (/&
&2.2084E+01_JPRB,1.9324E+01_JPRB,1.6564E+01_JPRB,1.6718E+01_JPRB,2.2290E+01_JPRB,2.7862E+01_JPRB,&
&3.3433E+01_JPRB,3.9003E+01_JPRB,4.2289E+01_JPRB/)
KAO( :, 5, 2,16) = (/&
&2.1176E+01_JPRB,1.8529E+01_JPRB,1.5883E+01_JPRB,1.7075E+01_JPRB,2.2766E+01_JPRB,2.8457E+01_JPRB,&
&3.4148E+01_JPRB,3.9837E+01_JPRB,4.3190E+01_JPRB/)
KAO( :, 1, 3,16) = (/&
&2.7048E+01_JPRB,2.3667E+01_JPRB,2.0286E+01_JPRB,1.7873E+01_JPRB,2.3831E+01_JPRB,2.9788E+01_JPRB,&
&3.5745E+01_JPRB,4.1700E+01_JPRB,4.6434E+01_JPRB/)
KAO( :, 2, 3,16) = (/&
&2.5923E+01_JPRB,2.2683E+01_JPRB,1.9443E+01_JPRB,1.8645E+01_JPRB,2.4860E+01_JPRB,3.1075E+01_JPRB,&
&3.7289E+01_JPRB,4.3501E+01_JPRB,4.8433E+01_JPRB/)
KAO( :, 3, 3,16) = (/&
&2.4829E+01_JPRB,2.1725E+01_JPRB,1.8622E+01_JPRB,1.9301E+01_JPRB,2.5734E+01_JPRB,3.2168E+01_JPRB,&
&3.8600E+01_JPRB,4.5030E+01_JPRB,5.0155E+01_JPRB/)
KAO( :, 4, 3,16) = (/&
&2.3775E+01_JPRB,2.0804E+01_JPRB,1.7832E+01_JPRB,1.9866E+01_JPRB,2.6487E+01_JPRB,3.3108E+01_JPRB,&
&3.9729E+01_JPRB,4.6348E+01_JPRB,5.1627E+01_JPRB/)
KAO( :, 5, 3,16) = (/&
&2.2759E+01_JPRB,1.9914E+01_JPRB,1.7070E+01_JPRB,2.0344E+01_JPRB,2.7124E+01_JPRB,3.3905E+01_JPRB,&
&4.0685E+01_JPRB,4.7463E+01_JPRB,5.2855E+01_JPRB/)
KAO( :, 1, 4,16) = (/&
&2.9281E+01_JPRB,2.5621E+01_JPRB,2.1961E+01_JPRB,2.0878E+01_JPRB,2.7836E+01_JPRB,3.4801E+01_JPRB,&
&4.1761E+01_JPRB,4.8718E+01_JPRB,5.5008E+01_JPRB/)
KAO( :, 2, 4,16) = (/&
&2.8016E+01_JPRB,2.4514E+01_JPRB,2.1012E+01_JPRB,2.1904E+01_JPRB,2.9205E+01_JPRB,3.6506E+01_JPRB,&
&4.3806E+01_JPRB,5.1103E+01_JPRB,5.7673E+01_JPRB/)
KAO( :, 3, 4,16) = (/&
&2.6800E+01_JPRB,2.3450E+01_JPRB,2.0100E+01_JPRB,2.2779E+01_JPRB,3.0372E+01_JPRB,3.7964E+01_JPRB,&
&4.5556E+01_JPRB,5.3145E+01_JPRB,6.0000E+01_JPRB/)
KAO( :, 4, 4,16) = (/&
&2.5622E+01_JPRB,2.2420E+01_JPRB,1.9217E+01_JPRB,2.3531E+01_JPRB,3.1375E+01_JPRB,3.9218E+01_JPRB,&
&4.7060E+01_JPRB,5.4900E+01_JPRB,6.1967E+01_JPRB/)
KAO( :, 5, 4,16) = (/&
&2.4489E+01_JPRB,2.1428E+01_JPRB,1.8368E+01_JPRB,2.4165E+01_JPRB,3.2219E+01_JPRB,4.0274E+01_JPRB,&
&4.8327E+01_JPRB,5.6378E+01_JPRB,6.3637E+01_JPRB/)
KAO( :, 1, 5,16) = (/&
&3.1572E+01_JPRB,2.7626E+01_JPRB,2.3679E+01_JPRB,2.4302E+01_JPRB,3.2402E+01_JPRB,4.0502E+01_JPRB,&
&4.8601E+01_JPRB,5.6697E+01_JPRB,6.4411E+01_JPRB/)
KAO( :, 2, 5,16) = (/&
&3.0155E+01_JPRB,2.6386E+01_JPRB,2.2616E+01_JPRB,2.5641E+01_JPRB,3.4188E+01_JPRB,4.2734E+01_JPRB,&
&5.1280E+01_JPRB,5.9822E+01_JPRB,6.7939E+01_JPRB/)
KAO( :, 3, 5,16) = (/&
&2.8800E+01_JPRB,2.5200E+01_JPRB,2.1600E+01_JPRB,2.6788E+01_JPRB,3.5717E+01_JPRB,4.4645E+01_JPRB,&
&5.3573E+01_JPRB,6.2498E+01_JPRB,7.0987E+01_JPRB/)
KAO( :, 4, 5,16) = (/&
&2.7508E+01_JPRB,2.4070E+01_JPRB,2.0631E+01_JPRB,2.7770E+01_JPRB,3.7026E+01_JPRB,4.6282E+01_JPRB,&
&5.5538E+01_JPRB,6.4790E+01_JPRB,7.3602E+01_JPRB/)
KAO( :, 5, 5,16) = (/&
&2.6277E+01_JPRB,2.2993E+01_JPRB,1.9723E+01_JPRB,2.8602E+01_JPRB,3.8136E+01_JPRB,4.7669E+01_JPRB,&
&5.7201E+01_JPRB,6.6735E+01_JPRB,7.5802E+01_JPRB/)
KAO( :, 1, 6,16) = (/&
&3.4063E+01_JPRB,2.9805E+01_JPRB,2.5548E+01_JPRB,2.8070E+01_JPRB,3.7426E+01_JPRB,4.6782E+01_JPRB,&
&5.6138E+01_JPRB,6.5490E+01_JPRB,7.4618E+01_JPRB/)
KAO( :, 2, 6,16) = (/&
&3.2500E+01_JPRB,2.8438E+01_JPRB,2.4375E+01_JPRB,2.9810E+01_JPRB,3.9747E+01_JPRB,4.9683E+01_JPRB,&
&5.9618E+01_JPRB,6.9550E+01_JPRB,7.9236E+01_JPRB/)
KAO( :, 3, 6,16) = (/&
&3.1024E+01_JPRB,2.7146E+01_JPRB,2.3268E+01_JPRB,3.1309E+01_JPRB,4.1745E+01_JPRB,5.2181E+01_JPRB,&
&6.2616E+01_JPRB,7.3047E+01_JPRB,8.3222E+01_JPRB/)
KAO( :, 4, 6,16) = (/&
&2.9629E+01_JPRB,2.5925E+01_JPRB,2.2365E+01_JPRB,3.2588E+01_JPRB,4.3451E+01_JPRB,5.4313E+01_JPRB,&
&6.5174E+01_JPRB,7.6032E+01_JPRB,8.6614E+01_JPRB/)
KAO( :, 5, 6,16) = (/&
&2.8309E+01_JPRB,2.4770E+01_JPRB,2.2515E+01_JPRB,3.3663E+01_JPRB,4.4883E+01_JPRB,5.6104E+01_JPRB,&
&6.7323E+01_JPRB,7.8538E+01_JPRB,8.9494E+01_JPRB/)
KAO( :, 1, 7,16) = (/&
&3.6910E+01_JPRB,3.2297E+01_JPRB,2.7683E+01_JPRB,3.2196E+01_JPRB,4.2928E+01_JPRB,5.3659E+01_JPRB,&
&6.4389E+01_JPRB,7.5116E+01_JPRB,8.5705E+01_JPRB/)
KAO( :, 2, 7,16) = (/&
&3.5197E+01_JPRB,3.0797E+01_JPRB,2.6398E+01_JPRB,3.4425E+01_JPRB,4.5900E+01_JPRB,5.7374E+01_JPRB,&
&6.8848E+01_JPRB,8.0317E+01_JPRB,9.1670E+01_JPRB/)
KAO( :, 3, 7,16) = (/&
&3.3605E+01_JPRB,2.9404E+01_JPRB,2.5310E+01_JPRB,3.6355E+01_JPRB,4.8473E+01_JPRB,6.0591E+01_JPRB,&
&7.2708E+01_JPRB,8.4820E+01_JPRB,9.6786E+01_JPRB/)
KAO( :, 4, 7,16) = (/&
&3.2106E+01_JPRB,2.8093E+01_JPRB,2.5533E+01_JPRB,3.7999E+01_JPRB,5.0665E+01_JPRB,6.3330E+01_JPRB,&
&7.5995E+01_JPRB,8.8655E+01_JPRB,1.0117E+02_JPRB/)
KAO( :, 5, 7,16) = (/&
&3.0744E+01_JPRB,2.6901E+01_JPRB,2.6250E+01_JPRB,3.9375E+01_JPRB,5.2499E+01_JPRB,6.5623E+01_JPRB,&
&7.8746E+01_JPRB,9.1865E+01_JPRB,1.0485E+02_JPRB/)
KAO( :, 1, 8,16) = (/&
&4.0073E+01_JPRB,3.5064E+01_JPRB,3.0055E+01_JPRB,3.6634E+01_JPRB,4.8845E+01_JPRB,6.1056E+01_JPRB,&
&7.3265E+01_JPRB,8.5470E+01_JPRB,9.7620E+01_JPRB/)
KAO( :, 2, 8,16) = (/&
&3.8256E+01_JPRB,3.3474E+01_JPRB,2.8692E+01_JPRB,3.9468E+01_JPRB,5.2623E+01_JPRB,6.5778E+01_JPRB,&
&7.8932E+01_JPRB,9.2081E+01_JPRB,1.0517E+02_JPRB/)
KAO( :, 3, 8,16) = (/&
&3.6587E+01_JPRB,3.2013E+01_JPRB,2.8588E+01_JPRB,4.1890E+01_JPRB,5.5854E+01_JPRB,6.9816E+01_JPRB,&
&8.3778E+01_JPRB,9.7751E+01_JPRB,1.1165E+02_JPRB/)
KAO( :, 4, 8,16) = (/&
&3.5145E+01_JPRB,3.0752E+01_JPRB,2.9433E+01_JPRB,4.3973E+01_JPRB,5.8630E+01_JPRB,7.3286E+01_JPRB,&
&8.7942E+01_JPRB,1.0259E+02_JPRB,1.1716E+02_JPRB/)
KAO( :, 5, 8,16) = (/&
&3.4615E+01_JPRB,3.0288E+01_JPRB,3.0495E+01_JPRB,4.5712E+01_JPRB,6.0949E+01_JPRB,7.6185E+01_JPRB,&
&9.1420E+01_JPRB,1.0665E+02_JPRB,1.2183E+02_JPRB/)
KAO( :, 1, 9,16) = (/&
&4.3755E+01_JPRB,3.8286E+01_JPRB,3.2816E+01_JPRB,4.1247E+01_JPRB,5.4995E+01_JPRB,6.8743E+01_JPRB,&
&8.2490E+01_JPRB,9.6233E+01_JPRB,1.0997E+02_JPRB/)
KAO( :, 2, 9,16) = (/&
&4.1945E+01_JPRB,3.6702E+01_JPRB,3.1862E+01_JPRB,4.4780E+01_JPRB,5.9706E+01_JPRB,7.4631E+01_JPRB,&
&8.9556E+01_JPRB,1.0447E+02_JPRB,1.1940E+02_JPRB/)
KAO( :, 3, 9,16) = (/&
&4.0428E+01_JPRB,3.5374E+01_JPRB,3.2607E+01_JPRB,4.7818E+01_JPRB,6.3757E+01_JPRB,7.9695E+01_JPRB,&
&9.5632E+01_JPRB,1.1156E+02_JPRB,1.2752E+02_JPRB/)
KAO( :, 4, 9,16) = (/&
&3.9770E+01_JPRB,3.4798E+01_JPRB,3.3900E+01_JPRB,5.0397E+01_JPRB,6.7196E+01_JPRB,8.3994E+01_JPRB,&
&1.0079E+02_JPRB,1.1758E+02_JPRB,1.3434E+02_JPRB/)
KAO( :, 5, 9,16) = (/&
&4.1051E+01_JPRB,3.5919E+01_JPRB,3.5387E+01_JPRB,5.2540E+01_JPRB,7.0054E+01_JPRB,8.7567E+01_JPRB,&
&1.0508E+02_JPRB,1.2258E+02_JPRB,1.4009E+02_JPRB/)
KAO( :, 1,10,16) = (/&
&4.8191E+01_JPRB,4.2167E+01_JPRB,3.6143E+01_JPRB,4.6233E+01_JPRB,6.1643E+01_JPRB,7.7053E+01_JPRB,&
&9.2462E+01_JPRB,1.0788E+02_JPRB,1.2329E+02_JPRB/)
KAO( :, 2,10,16) = (/&
&4.6632E+01_JPRB,4.0803E+01_JPRB,3.6096E+01_JPRB,5.0540E+01_JPRB,6.7392E+01_JPRB,8.4239E+01_JPRB,&
&1.0109E+02_JPRB,1.1792E+02_JPRB,1.3475E+02_JPRB/)
KAO( :, 3,10,16) = (/&
&4.5798E+01_JPRB,4.0073E+01_JPRB,3.7372E+01_JPRB,5.4219E+01_JPRB,7.2291E+01_JPRB,9.0363E+01_JPRB,&
&1.0843E+02_JPRB,1.2650E+02_JPRB,1.4462E+02_JPRB/)
KAO( :, 4,10,16) = (/&
&4.7009E+01_JPRB,4.1133E+01_JPRB,3.9401E+01_JPRB,5.7318E+01_JPRB,7.6424E+01_JPRB,9.5528E+01_JPRB,&
&1.1463E+02_JPRB,1.3373E+02_JPRB,1.5287E+02_JPRB/)
KAO( :, 5,10,16) = (/&
&4.8862E+01_JPRB,4.2754E+01_JPRB,4.1265E+01_JPRB,5.9899E+01_JPRB,7.9865E+01_JPRB,9.9835E+01_JPRB,&
&1.1980E+02_JPRB,1.3976E+02_JPRB,1.5971E+02_JPRB/)
KAO( :, 1,11,16) = (/&
&5.3373E+01_JPRB,4.6702E+01_JPRB,4.0606E+01_JPRB,5.3674E+01_JPRB,7.1565E+01_JPRB,8.9455E+01_JPRB,&
&1.0734E+02_JPRB,1.2523E+02_JPRB,1.4312E+02_JPRB/)
KAO( :, 2,11,16) = (/&
&5.3017E+01_JPRB,4.6390E+01_JPRB,4.2053E+01_JPRB,5.8474E+01_JPRB,7.7965E+01_JPRB,9.7455E+01_JPRB,&
&1.1694E+02_JPRB,1.3643E+02_JPRB,1.5595E+02_JPRB/)
KAO( :, 3,11,16) = (/&
&5.4550E+01_JPRB,4.7731E+01_JPRB,4.4590E+01_JPRB,6.2526E+01_JPRB,8.3367E+01_JPRB,1.0421E+02_JPRB,&
&1.2505E+02_JPRB,1.4588E+02_JPRB,1.6674E+02_JPRB/)
KAO( :, 4,11,16) = (/&
&5.6780E+01_JPRB,4.9683E+01_JPRB,4.6971E+01_JPRB,6.5903E+01_JPRB,8.7870E+01_JPRB,1.0984E+02_JPRB,&
&1.3180E+02_JPRB,1.5376E+02_JPRB,1.7563E+02_JPRB/)
KAO( :, 5,11,16) = (/&
&5.9041E+01_JPRB,5.1661E+01_JPRB,4.9066E+01_JPRB,6.8642E+01_JPRB,9.1523E+01_JPRB,1.1440E+02_JPRB,&
&1.3728E+02_JPRB,1.6015E+02_JPRB,1.8306E+02_JPRB/)
KAO( :, 1,12,16) = (/&
&6.1525E+01_JPRB,5.3834E+01_JPRB,4.7398E+01_JPRB,6.1480E+01_JPRB,8.1973E+01_JPRB,1.0246E+02_JPRB,&
&1.2296E+02_JPRB,1.4346E+02_JPRB,1.6393E+02_JPRB/)
KAO( :, 2,12,16) = (/&
&6.3155E+01_JPRB,5.5261E+01_JPRB,5.0248E+01_JPRB,6.6709E+01_JPRB,8.8945E+01_JPRB,1.1118E+02_JPRB,&
&1.3341E+02_JPRB,1.5564E+02_JPRB,1.7789E+02_JPRB/)
KAO( :, 3,12,16) = (/&
&6.5829E+01_JPRB,5.7600E+01_JPRB,5.3241E+01_JPRB,7.1073E+01_JPRB,9.4764E+01_JPRB,1.1845E+02_JPRB,&
&1.4214E+02_JPRB,1.6583E+02_JPRB,1.8954E+02_JPRB/)
KAO( :, 4,12,16) = (/&
&6.8453E+01_JPRB,5.9896E+01_JPRB,5.5974E+01_JPRB,7.4756E+01_JPRB,9.9674E+01_JPRB,1.2459E+02_JPRB,&
&1.4950E+02_JPRB,1.7441E+02_JPRB,1.9932E+02_JPRB/)
KAO( :, 5,12,16) = (/&
&7.1079E+01_JPRB,6.2194E+01_JPRB,5.8308E+01_JPRB,7.7950E+01_JPRB,1.0393E+02_JPRB,1.2991E+02_JPRB,&
&1.5589E+02_JPRB,1.8186E+02_JPRB,2.0786E+02_JPRB/)
KAO( :, 1,13,16) = (/&
&7.3106E+01_JPRB,6.3968E+01_JPRB,5.6524E+01_JPRB,6.9787E+01_JPRB,9.2588E+01_JPRB,1.1573E+02_JPRB,&
&1.3888E+02_JPRB,1.6201E+02_JPRB,1.8517E+02_JPRB/)
KAO( :, 2,13,16) = (/&
&7.5846E+01_JPRB,6.6365E+01_JPRB,6.0094E+01_JPRB,7.5398E+01_JPRB,1.0038E+02_JPRB,1.2548E+02_JPRB,&
&1.5057E+02_JPRB,1.7566E+02_JPRB,2.0075E+02_JPRB/)
KAO( :, 3,13,16) = (/&
&7.9121E+01_JPRB,6.9231E+01_JPRB,6.3478E+01_JPRB,8.0291E+01_JPRB,1.0705E+02_JPRB,1.3382E+02_JPRB,&
&1.6058E+02_JPRB,1.8733E+02_JPRB,2.1409E+02_JPRB/)
KAO( :, 4,13,16) = (/&
&8.2254E+01_JPRB,7.1972E+01_JPRB,6.6518E+01_JPRB,8.4693E+01_JPRB,1.1292E+02_JPRB,1.4115E+02_JPRB,&
&1.6938E+02_JPRB,1.9759E+02_JPRB,2.2586E+02_JPRB/)
KAO( :, 5,13,16) = (/&
&8.5142E+01_JPRB,7.4499E+01_JPRB,6.9191E+01_JPRB,8.8493E+01_JPRB,1.1799E+02_JPRB,1.4748E+02_JPRB,&
&1.7697E+02_JPRB,2.0646E+02_JPRB,2.3600E+02_JPRB/)


!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
&2.34973E-02_JPRB, 2.07877E-02_JPRB, 1.83905E-02_JPRB, 1.62698E-02_JPRB, 1.43936E-02_JPRB,&
&1.27338E-02_JPRB, 1.12654E-02_JPRB, 9.96632E-03_JPRB, 8.81704E-03_JPRB, 7.80030E-03_JPRB/)
SELFREFO( :, 2) = (/&
&3.10090E-02_JPRB, 2.82626E-02_JPRB, 2.57594E-02_JPRB, 2.34779E-02_JPRB, 2.13985E-02_JPRB,&
&1.95033E-02_JPRB, 1.77759E-02_JPRB, 1.62015E-02_JPRB, 1.47665E-02_JPRB, 1.34587E-02_JPRB/)
SELFREFO( :, 3) = (/&
&5.36676E-02_JPRB, 4.95621E-02_JPRB, 4.57706E-02_JPRB, 4.22692E-02_JPRB, 3.90356E-02_JPRB,&
&3.60494E-02_JPRB, 3.32917E-02_JPRB, 3.07449E-02_JPRB, 2.83929E-02_JPRB, 2.62209E-02_JPRB/)
SELFREFO( :, 4) = (/&
&9.05844E-02_JPRB, 8.33349E-02_JPRB, 7.66656E-02_JPRB, 7.05300E-02_JPRB, 6.48855E-02_JPRB,&
&5.96927E-02_JPRB, 5.49155E-02_JPRB, 5.05206E-02_JPRB, 4.64774E-02_JPRB, 4.27578E-02_JPRB/)
SELFREFO( :, 5) = (/&
&1.10531E-01_JPRB, 1.03430E-01_JPRB, 9.67851E-02_JPRB, 9.05670E-02_JPRB, 8.47484E-02_JPRB,&
&7.93037E-02_JPRB, 7.42087E-02_JPRB, 6.94411E-02_JPRB, 6.49797E-02_JPRB, 6.08050E-02_JPRB/)
SELFREFO( :, 6) = (/&
&1.24308E-01_JPRB, 1.16014E-01_JPRB, 1.08274E-01_JPRB, 1.01050E-01_JPRB, 9.43078E-02_JPRB,&
&8.80155E-02_JPRB, 8.21431E-02_JPRB, 7.66624E-02_JPRB, 7.15475E-02_JPRB, 6.67738E-02_JPRB/)
SELFREFO( :, 7) = (/&
&1.34594E-01_JPRB, 1.25054E-01_JPRB, 1.16190E-01_JPRB, 1.07954E-01_JPRB, 1.00302E-01_JPRB,&
&9.31920E-02_JPRB, 8.65863E-02_JPRB, 8.04488E-02_JPRB, 7.47464E-02_JPRB, 6.94481E-02_JPRB/)
SELFREFO( :, 8) = (/&
&1.26966E-01_JPRB, 1.18270E-01_JPRB, 1.10169E-01_JPRB, 1.02624E-01_JPRB, 9.55948E-02_JPRB,&
&8.90474E-02_JPRB, 8.29484E-02_JPRB, 7.72672E-02_JPRB, 7.19750E-02_JPRB, 6.70453E-02_JPRB/)
SELFREFO( :, 9) = (/&
&1.29806E-01_JPRB, 1.21296E-01_JPRB, 1.13344E-01_JPRB, 1.05913E-01_JPRB, 9.89690E-02_JPRB,&
&9.24805E-02_JPRB, 8.64175E-02_JPRB, 8.07519E-02_JPRB, 7.54578E-02_JPRB, 7.05108E-02_JPRB/)
SELFREFO( :,10) = (/&
&1.37781E-01_JPRB, 1.26830E-01_JPRB, 1.16751E-01_JPRB, 1.07472E-01_JPRB, 9.89303E-02_JPRB,&
&9.10678E-02_JPRB, 8.38301E-02_JPRB, 7.71677E-02_JPRB, 7.10347E-02_JPRB, 6.53892E-02_JPRB/)
SELFREFO( :,11) = (/&
&1.30675E-01_JPRB, 1.24254E-01_JPRB, 1.18149E-01_JPRB, 1.12344E-01_JPRB, 1.06824E-01_JPRB,&
&1.01575E-01_JPRB, 9.65839E-02_JPRB, 9.18383E-02_JPRB, 8.73258E-02_JPRB, 8.30351E-02_JPRB/)
SELFREFO( :,12) = (/&
&1.55998E-01_JPRB, 1.45155E-01_JPRB, 1.35067E-01_JPRB, 1.25679E-01_JPRB, 1.16944E-01_JPRB,&
&1.08816E-01_JPRB, 1.01253E-01_JPRB, 9.42160E-02_JPRB, 8.76677E-02_JPRB, 8.15746E-02_JPRB/)
SELFREFO( :,13) = (/&
&1.56508E-01_JPRB, 1.46390E-01_JPRB, 1.36925E-01_JPRB, 1.28072E-01_JPRB, 1.19792E-01_JPRB,&
&1.12047E-01_JPRB, 1.04803E-01_JPRB, 9.80266E-02_JPRB, 9.16888E-02_JPRB, 8.57608E-02_JPRB/)
SELFREFO( :,14) = (/&
&1.55206E-01_JPRB, 1.43469E-01_JPRB, 1.32620E-01_JPRB, 1.22591E-01_JPRB, 1.13321E-01_JPRB,&
&1.04752E-01_JPRB, 9.68305E-02_JPRB, 8.95082E-02_JPRB, 8.27396E-02_JPRB, 7.64829E-02_JPRB/)
SELFREFO( :,15) = (/&
&1.46694E-01_JPRB, 1.35458E-01_JPRB, 1.25082E-01_JPRB, 1.15501E-01_JPRB, 1.06654E-01_JPRB,&
&9.84840E-02_JPRB, 9.09403E-02_JPRB, 8.39744E-02_JPRB, 7.75420E-02_JPRB, 7.16024E-02_JPRB/)
SELFREFO( :,16) = (/&
&1.65126E-01_JPRB, 1.53281E-01_JPRB, 1.42287E-01_JPRB, 1.32081E-01_JPRB, 1.22607E-01_JPRB,&
&1.13812E-01_JPRB, 1.05649E-01_JPRB, 9.80707E-02_JPRB, 9.10362E-02_JPRB, 8.45063E-02_JPRB/)

FRACREFAO( : ,1) = (/&
!     From P = 706.3 mb.
    &0.21245100_JPRB,0.15164700_JPRB,0.14486700_JPRB,0.13075501_JPRB,&
    &0.11629600_JPRB,0.09266050_JPRB,0.06579930_JPRB,0.04524000_JPRB,&
    &0.03072870_JPRB,0.00284297_JPRB,0.00234660_JPRB,0.00185208_JPRB,&
    &0.00133978_JPRB,0.00082214_JPRB,0.00031016_JPRB,0.00004363_JPRB/)
FRACREFAO( : ,2) = (/&
    &0.14703900_JPRB,0.16937999_JPRB,0.15605700_JPRB,0.14159000_JPRB,&
    &0.12088500_JPRB,0.10058500_JPRB,0.06809110_JPRB,0.05131470_JPRB,&
    &0.03487040_JPRB,0.00327281_JPRB,0.00250183_JPRB,0.00190024_JPRB,&
    &0.00133978_JPRB,0.00082214_JPRB,0.00031016_JPRB,0.00004363_JPRB/)
FRACREFAO( : ,3) = (/&
    &0.13689300_JPRB,0.16610400_JPRB,0.15723500_JPRB,0.14299500_JPRB,&
    &0.12399400_JPRB,0.09907820_JPRB,0.07169690_JPRB,0.05367370_JPRB,&
    &0.03671630_JPRB,0.00378148_JPRB,0.00290510_JPRB,0.00221076_JPRB,&
    &0.00142810_JPRB,0.00093527_JPRB,0.00031016_JPRB,0.00004363_JPRB/)
FRACREFAO( : ,4) = (/&
    &0.13054299_JPRB,0.16273800_JPRB,0.15874299_JPRB,0.14279599_JPRB,&
    &0.12674300_JPRB,0.09664900_JPRB,0.07462200_JPRB,0.05620080_JPRB,&
    &0.03789090_JPRB,0.00411690_JPRB,0.00322920_JPRB,0.00245036_JPRB,&
    &0.00178303_JPRB,0.00098595_JPRB,0.00040802_JPRB,0.00010150_JPRB/)
FRACREFAO( : ,5) = (/&
    &0.12828299_JPRB,0.15824600_JPRB,0.15688400_JPRB,0.14449100_JPRB,&
    &0.12787800_JPRB,0.09517830_JPRB,0.07679350_JPRB,0.05890820_JPRB,&
    &0.03883570_JPRB,0.00442304_JPRB,0.00346796_JPRB,0.00255333_JPRB,&
    &0.00212519_JPRB,0.00116168_JPRB,0.00067065_JPRB,0.00010150_JPRB/)
FRACREFAO( : ,6) = (/&
    &0.12649800_JPRB,0.15195100_JPRB,0.15646499_JPRB,0.14569700_JPRB,&
    &0.12669300_JPRB,0.09653520_JPRB,0.07887920_JPRB,0.06106920_JPRB,&
    &0.04043910_JPRB,0.00430390_JPRB,0.00364453_JPRB,0.00314360_JPRB,&
    &0.00203206_JPRB,0.00187787_JPRB,0.00067075_JPRB,0.00010150_JPRB/)
FRACREFAO( : ,7) = (/&
    &0.12500300_JPRB,0.14460599_JPRB,0.15672199_JPRB,0.14724600_JPRB,&
    &0.11978900_JPRB,0.10190200_JPRB,0.08196710_JPRB,0.06315770_JPRB,&
    &0.04240100_JPRB,0.00433645_JPRB,0.00404097_JPRB,0.00329466_JPRB,&
    &0.00288491_JPRB,0.00187803_JPRB,0.00067093_JPRB,0.00010150_JPRB/)
FRACREFAO( : ,8) = (/&
    &0.12317200_JPRB,0.14118700_JPRB,0.15242000_JPRB,0.13794300_JPRB,&
    &0.12119200_JPRB,0.10655400_JPRB,0.08808350_JPRB,0.06521370_JPRB,&
    &0.04505680_JPRB,0.00485949_JPRB,0.00477105_JPRB,0.00401468_JPRB,&
    &0.00288491_JPRB,0.00187786_JPRB,0.00067110_JPRB,0.00010150_JPRB/)
FRACREFAO( : ,9) = (/&
    &0.10193600_JPRB,0.11693000_JPRB,0.13236099_JPRB,0.14053200_JPRB,&
    &0.13749801_JPRB,0.12193100_JPRB,0.10221000_JPRB,0.07448910_JPRB,&
    &0.05205320_JPRB,0.00572312_JPRB,0.00476882_JPRB,0.00403380_JPRB,&
    &0.00288871_JPRB,0.00187396_JPRB,0.00067218_JPRB,0.00010150_JPRB/)

!     -----------------------------------------------------------------
RETURN
END SUBROUTINE RRTM_KGB12
