#include "MAR_pp.def"
subroutine PHYrad_top(Dis_ST)
    ! +------------------------------------------------------------------------+
    ! | MAR PHYSICS (INSOL)                                    15-11-2007  MAR |
    ! |   subroutine PHYrad_top computes                                       |
    ! |      Time Insolation at the Top of the Atmosphere                      |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   REFER.:   Ch.  Tricot, personal communication                        |
    ! |   ^^^^^^^   M.F. Loutre, personal communication and thesis (1993)      |
    ! |                                                                        |
    ! |   INPUT :   mmarGE, jdarGE: Month and Day of the Year                  |
    ! |   ^^^^^^^   jhurGE, minuGE, jsecGE: Hour, Minute, and Second           |
    ! |             GElat0, GElon0: Latitude, Longitude                        |
    ! |             GElatr(mx,my) : Latitude                         (radians) |
    ! |             GElonh(mx,my) : Longitude                          (hours) |
    ! |             itizGE(mx,my) : Time Zone                                  |
    ! |                                                                        |
    ! |   OUTPUT:   rsunGE        : Insolation normal to Atmosphere Top (W/m2) |
    ! |   ^^^^^^^   czenGE(mx,my) : Cosinus of the Zenithal Distance           |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+

    use marctr
    use marphy
    use mardim
    use margrd
    use mar_ge
    use marsnd
    use mar_wk
    use mar_io

    implicit none

    ! +--Global Variables
    ! +  ================

    real Dis_ST

    ! +--LOCAL VARIABLES
    ! +  ===============

    integer i, j, k, m
    real pirr, xl, so
    real xllp, xee, xse
    real xlam, dlamm, anm, ranm, ranv, anv, tls
    real Tyear, step, rlam, sd, cd, deltar, delta

    real ddt, arg, et, argc, ahc
    real c1, c2, c3, s1, s2, s3
    real timdl, timh, ahor, ahorr, RadLat, chor, zenitr
    integer nj, lhc

    real omesun
#ifdef AZ
    real slopx, slopy, omenor
    real comes, somes, omeswr, anormr, omenwr
    integer momask
#endif

#ifdef MM
    real dxdx, azim_0, azim_1, azimdd, azimut, r_azim
    real azimxx, azimxa, azimxs, azimyy, azimya, azimys
    real ddxx_2, ddyy_2, ddxy_2, ddzz, tmnt_2, cmnt
    integer k_azim, nax, nal, na, na2, ka
    integer i_azim, j_azim, j_azmn, j_azmx, i_azmn, i_azmx, nocoun
    integer knazim, ni1, ni2, nj1, nj2
    integer i1, i2, j1, j2, ni
#endif

    real om, ecc, perh, xob

    ! +--DATA
    ! +  ====

    data om/0.0172142d0/

    ! +--Present Day Insolation
    ! +  ----------------------
    ! Eccentricity
    data ecc/0.01673/
    ! Longitude of the Perihelion (degrees)
    data perh/102.4/
    ! Obliquity (degrees)
    data xob/23.445/

#ifdef k6
    ! +--6 kBP Insolation
    ! +  ----------------
    ! Eccentricity
    data ecc/0.018682/
    ! Longitude of the Perihelion (degrees)
    data perh/0.87/
    ! Obliquity (degrees)
    data xob/24.105/
#endif

#ifdef k10
    ! +--10 kBPInsolation
    ! +  ----------------
    ! Eccentricity
    data ecc/0.019419/
    ! Longitude of the Perihelion (degrees)
    data perh/294.81/
    ! Obliquity (degrees)
    data xob/24.226/
#endif

    ! +--Insolation at the Top of the Atmosphere (TIME       PARAMETERS)
    ! +  ===============================================================

    ! +--Solar declination : delta
    ! +  -------------------------

    nj = jdarGE + njyrGE(mmarGE)
    Tyear = 365.25d0
    step = 360.0d0 / Tyear

    pirr = degrad / 3600.0
    xl = perh + 180.0
    so = sin(xob * degrad)
    ! +...so    : sinus of obliquity

    xllp = xl * degrad
    xee = ecc * ecc
    xse = sqrt(1.0d0 - xee)
    xlam = (ecc / 2.0 + ecc * xee / 8.0d0) * (1.0 + xse) * sin(xllp) - xee / 4.0 * &
           (0.5 + xse) * sin(2.0 * xllp) + ecc * xee / 8.0 * (1.0 / 3.0 + xse) * &
           sin(3.0 * xllp)
    xlam = 2.0d0 * xlam / degrad
    dlamm = xlam + (nj - 80) * step
    ! +...xlam  : true long. sun for mean long. = 0
    ! +...dlamm : mean long. sun for ma-ja
    anm = dlamm - xl
    ranm = anm * degrad
    xee = xee * ecc
    ranv = ranm + (2.0 * ecc - xee / 4.0) * sin(ranm) + 5.0 / 4.0 * ecc * ecc * &
           sin(2.0 * ranm) + 13.0 / 12.0 * xee * sin(3.0 * ranm)
    anv = ranv / degrad
    tls = anv + xl
    rlam = tls * degrad
    ! +...tls   : longitude vraie   (degrees)
    ! +...rlam  : longitude vraie   (radian)
    ! +...anv   : anomalie vraie    (degrees)
    ! +...ranv  : anomalie vraie    (radian)

    sd = so * sin(rlam)
    cd = sqrt(1.0d0 - sd * sd)
    ! +...sd and cd: cosinus and sinus of solar declination angle (delta)
    ! +...sinus delta = sin (obl)*sin(lambda) with lambda = real longitude
    ! +...(Phd. thesis of Marie-France Loutre, ASTR-UCL, Belgium, 1993)

    deltar = atan(sd / cd)
    delta = deltar / degrad
    ! +...delta: Solar Declination (degrees, angle sun at equator)

    ! +--Eccentricity Effect
    ! +  -------------------

    Dis_ST = (1.0 - ecc * ecc) / (1.0 + ecc * cos(ranv))
    ddt = 1.0 / Dis_ST
    ! +...ddt  :    1   /  normalized earth's sun distance

    ! +--Insolation normal to the atmosphere (W/m2)
    ! +  ------------------------------------------

    !XF
    rsunGE = ddt * ddt * 1360.8d0

    ! +--Time Equation (Should maybe be modified in case other than present
    ! +  -------------  conditions are used, minor impact)

    arg = om * nj
    c1 = cos(arg)
    c2 = cos(2.d0 * arg)
    c3 = cos(3.d0 * arg)
    s1 = sin(arg)
    s2 = sin(2.d0 * arg)
    s3 = sin(3.d0 * arg)

    et = 0.0072d0 * c1 - 0.0528d0 * c2 - 0.0012d0 * c3 &
         - 0.1229d0 * s1 - 0.1565d0 * s2 - 0.0041d0 * s3
    ! +...et (hour)
    ! +     = difference between true solar and mean solar hour angles.
    ! +      (connected to the earth orbital rotation speed)

    ! +--Insolation at the Top of the Troposphere (Auxiliary Variables)
    ! +  ==============================================================

    ! +--Day Length, Time Sunrise and Sunset at Sounding Grid Point (iSND, jSND)
    ! +  -----------------------------------------------------------------------

    i = iSND
    j = jSND

    argc = -tan(GElatr(i, j)) * tan(deltar)
    if(abs(argc) > 1.d0) then
        ahc = 0.d0
        if(argc > 1.d0) then
            lhc = -1
            timdl = 00.d0
            ! +...   Polar  Night
        else
            lhc = 1
            timdl = 24.d0
            ! +...   Midnight Sun
        endif
        tlsrGE = 00.d0
        tlssGE = 00.d0
    else
        ahc = acos(argc)
        lhc = 0

        if(ahc < 0.d0) ahc = -ahc
        ahc = ahc / hourad
        timdl = ahc * 2.d0
        tlsrGE = 12.d0 - ahc + itizGE(i, j) - et - GElonh(i, j)
        tlssGE = tlsrGE + timdl
    endif

    tl__GE = jhurGE + minuGE / 60.d0 - itizGE(i, j)

    ! +--Time Angle
    ! +  ----------

    do j = 1, my
        do i = 1, mx
            timh = jhurGE + minuGE / 60.d0
            ahor = timh + GElonh(i, j) - 12.d0 - et
            ! +...   ahor  : time angle (hours)

            ahorr = ahor * hourad
            ! +...   ahorr : time angle (radians)

            chor = cos(ahorr)

            ! +--Solar Zenithal Distance zenitr (radians) and
            ! +  Insolation (W/m2) at the Atmosphere Top  ===
            ! +  =======================================

            czenGE(i, j) = slatGE(i, j) * sd &
                           + clatGE(i, j) * cd * chor
            czenGE(i, j) = max(czenGE(i, j), zero)

            cverGE(i, j) = czenGE(i, j)

            ! +--Slope Impact
            ! +  ------------

#ifdef AZ
            zenitr = acos(czenGE(i, j))
            WKxy3(i, j) = sin(zenitr)
            WKxy4(i, j) = sin(ahorr)
#endif
        enddo
    enddo

#ifdef AZ
    ! +--Slope Azimuth
    ! +  ~~~~~~~~~~~~~
    if(iterun <= 1) then
        do j = 1, my
            do i = 1, mx
                slopx = (sh(ip1(i), j) - sh(im1(i), j)) * dxinv3(i, j)
                slopy = (sh(i, jp1(j)) - sh(i, jm1(j))) * dyinv3(i, j)
                ! slopGE ...... Cosine of Fall Line Angle
                slopGE(i, j) = sqrt(slopx * slopx + slopy * slopy)
                slopGE(i, j) = cos(atan(slopGE(i, j)))
                ! omenor      :      Fall Line Azimuth   (Upslope Direction)
                if(abs(slopx) > zero) then
                    omenor = atan(slopy / slopx)
                    if(slopx < zero) &
                        omenor = omenor + pi
                    if(omenor > pi) &
                        omenor = -2.0d0 * pi + omenor
                    if(omenor < -pi) &
                        omenor = 2.0d0 * pi + omenor
                else
                    if(slopy > zero) then
                        omenor = 0.5d0 * pi
                    else
                        omenor = 1.5d0 * pi
                    endif
                endif
                ! omenGE(i,j) : Fall Line Azimuth (Downslope Direction)
                !                              (in MAR Reference Frame)
                !                           (positive counterclockwise)
                omenGE(i, j) = omenor - pi
            enddo
        enddo
        ! +--Mountains Mask
        ! +  ~~~~~~~~~~~~~~
        momask = 1
#endif
#ifdef MM
        if(momask /= 1) stop'++++++++ Preprocessing Error: #AZ not removed ++++++++++++++'
        dxdx = dx * dx
        daziGE = 2.0d0 * pi / n_azim
        do k_azim = 1, n_azim
            azim_0 = (k_azim - 1) * daziGE
            azim_1 = k_azim * daziGE
            do j = 1, mmy
                do i = 1, mmx
                    cmntGE(i, j, k_azim) = 0.0d00
                enddo
            enddo
            if(abs(cos(azim_0)) > abs(sin(azim_0))) then
                nax = mx1 / 2
            else
                nax = my1 / 2
            endif
            nal = 30
            nax = min(nax, nal)
            do na = 1, nax
                na2 = na / 2
                na2 = max(na2, 1)
                azimdd = daziGE / na
                do j = 1, mmy
                    do i = 1, mmx
                        WKxy1(i, j) = 0.0d00
                        WKxy2(i, j) = 0.0d00
                    enddo
                enddo
                do ka = 1, na
                    azimut = azim_0 + azimdd * (ka - 0.5d0)
                    azimxx = (na + demi) * cos(azimut)
                    i_azim = azimxx
                    azimxa = abs(azimxx)
                    azimxs = sign(unun, azimxx)
                    azimyy = (na + demi) * sin(azimut)
                    j_azim = azimyy
                    azimya = abs(azimyy)
                    azimys = sign(unun, azimyy)
                    if(i_azim == 0 .and. j_azim == 0) then
                        if(azimxa > azimya) then
                            i_azim = azimxs
                        else
                            j_azim = azimys
                        endif
                    endif
                    do j = 2, my1
                        j_azmn = 1 - j
                        j_azmx = my - j
                        do i = 2, mx1
                            i_azmn = 1 - i
                            i_azmx = mx - i
                            nocoun = 0
                            if(j_azim > j_azmx .or. j_azim < j_azmn) nocoun = 1
                            if(i_azim > i_azmx .or. i_azim < i_azmn) nocoun = 1
                            if(nocoun == 1) go to 150
                            ddxx_2 = i_azim * i_azim * dxdx
                            ddyy_2 = j_azim * j_azim * dxdx
                            ddxy_2 = ddxx_2 + ddyy_2
                            ! Correction for Earth Curvature
                            ddzz = sh(i + i_azim, j + j_azim) - sh(i, j) &
                                   - sqrt(earthr * earthr + ddxy_2) + earthr
                            ddzz = max(ddzz, zero)
                            tmnt_2 = ddzz * ddzz / ddxy_2
                            cmnt = sqrt(tmnt_2 / (unun + tmnt_2))
                            WKxy1(i, j) = WKxy1(i, j) + cmnt
                            WKxy2(i, j) = WKxy2(i, j) + unun
150                         continue
                        enddo
                    enddo
                enddo
                do j = 2, my1
                    do i = 2, mx1
                        if(WKxy2(i, j) > 0.d0) then
                            WKxy1(i, j) = WKxy1(i, j) / WKxy2(i, j)
                            cmntGE(i, j, k_azim) = max(WKxy1(i, j), cmntGE(i, j, k_azim))
                        endif
                    enddo
                enddo
            enddo
        enddo
#endif
#ifdef AZ
    endif

    ! +--Sun   Azimuth
    ! +  ~~~~~~~~~~~~~
    do j = 1, my
        do i = 1, mx
            WKxy3(i, j) = max(epsi, WKxy3(i, j))
            ! comes: Cosine of Sun Azimuth
            comes = (sd - slatGE(i, j) * czenGE(i, j)) &
                    / (clatGE(i, j) * WKxy3(i, j))
            ! somes:   Sine of Sun Azimuth
            somes = (cd * WKxy4(i, j)) / WKxy3(i, j)
            if(abs(comes) > zero) then
                omesun = atan(somes / comes)
                if(comes < zero) omesun = omesun + pi
                if(omesun > pi) omesun = -2.0d0 * pi + omesun
                if(omesun < -pi) omesun = 2.0d0 * pi + omesun
            else
                if(somes > zero) then
                    omesun = 0.5d0 * pi
                else
                    omesun = 1.5d0 * pi
                endif
            endif

            if(i == iSND .and. j == jSND) omeswr = omesun / degrad
            ! omesun :  Sun Azimuth (in MAR Reference Frame)
            !                       (positive counterclockwise)
            omesun = -2.0d0 * pi + omesun + GEddxx * degrad
            ! +--Minimum Zenithal Distance
            ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~
            czmnGE(i, j) = 0.0d00
#endif
#ifdef MM
            r_azim = omesun / daziGE
            k_azim = r_azim
            if(k_azim <= 0) then
                r_azim = r_azim + n_azim
                k_azim = k_azim + n_azim
            endif
            knazim = k_azim + 1
            if(knazim > n_azim) knazim = knazim - n_azim
            czmnGE(i, j) = cmntGE(i, j, k_azim) + (r_azim - k_azim) &
                           * (cmntGE(i, j, knazim) - cmntGE(i, j, k_azim))
#endif
#ifdef AZ
            ! +--Cosine of Solar Normal Angle
            ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            cverGE(i, j) = slopGE(i, j) * czenGE(i, j) &
                           + WKxy3(i, j) * slopGE(i, j) * sqrt(unun - slopGE(i, j)) &
                           * cos(omesun - omenGE(i, j))
            cverGE(i, j) = max(zero, cverGE(i, j))
            if(czenGE(i, j) <= czmnGE(i, j)) cverGE(i, j) = 0.0d00
        enddo
    enddo
    ! +--Output
    ! +  ======
#endif
#ifdef MM
    if(iterun == 0) then
        ni1 = imez / 20 + 1
        ni2 = imez / 20 + 1
        nj1 = jmez / 20 + 1
        nj2 = jmez / 20 + 1
        do nj = nj2, nj1, -1
            j1 = (nj - 1) * 20 + 1
            j2 = nj * 20
            do ni = ni1, ni2
                i1 = (ni - 1) * 20 + 1
                i2 = ni * 20
                write(4, 60)(i, i=i1, i2), &
                    (j,(1.d-3 * sh(i, j), i=i1, i2), j=j2, j1, -1)
60              format(///, 'TOPOGRAPHY', &
                        /, '==========', /, 4x, 20i4, /,(i4, 20f4.1))

                do k_azim = 1, n_azim
                    azimut = (k_azim - 0.5d0) * daziGE / degrad
                    write(4, 61) azimut, &
                        (i, i=i1, i2), &
                        (j,(cmntGE(i, j, k_azim), i=i1, i2), j=j2, j1, -1)
61                  format(///, 'AZIMUTH   ', f6.1, &
                            /, '================', /, 4x, 20i4, /,(i4, 20f4.2))
                enddo
            enddo
        enddo
    endif
#endif

    if((jmmMAR == 0 .and. jssMAR == 0 .and. &
        ((IO_loc >= 2 .and. jhurGE == 0) .or. &
         (IO_loc >= 2 .and. mod(jhurGE, 3) == 0) .or. &
         (IO_loc >= 3))) .or. &
       IO_loc >= 7) then

        ahor = timh + GElonh(iSND, jSND) - 12.d0 - et
        zenitr = acos(czenGE(iSND, jSND)) / degrad
#ifdef AZ
        anormr = acos(cverGE(iSND, jSND)) / degrad
        omenwr = GEddxx - omenGE(iSND, jSND) / degrad
        if(omenwr < 0.) omenwr = omenwr + 360.d0
        if(omenwr > 360.) omenwr = omenwr - 360.d0
        omeswr = 360.d0 - omeswr
        if(omeswr < 0.) omeswr = omeswr + 360.d0
        if(omeswr > 360.) omeswr = omeswr - 360.d0
#endif

        write(4, 1) GElat0, GElon0, jdarGE, mmarGE, jhurGE, minuGE, jsecGE
1       format(/, ' lat.=', f6.1, 3x, 'long.=', f7.1, 4x, 'date :', i3, '-', i2, &
                ' / ', i2, ' h.UT', i3, ' min.', i3, ' sec.')
        write(4, 2) iSND, jSND, GElatr(iSND, jSND) / degrad, GElonh(iSND, jSND)
2       format(' Sounding at (', i3, i3, ') / (', f6.2, 'dg,', f6.2, 'ho)')
        write(4, 3) rsunGE * cverGE(iSND, jSND), ahor, zenitr &
            , delta
3       format(' Insolation [W/m2]  = ', f7.2, '   Hor.Angle = ', f7.2, &
               '   Zenith.Angle = ', f7.2 &
               , /, ' Solar Declination  = ', f7.2)

        if(lhc == -1) &
            write(4, 4) tlsrGE, timdl, tlssGE
4       format(' Sun Rise Time [h]  = ', f7.2, '   Day Leng. = ', f7.2, &
               '   Sun Set Time = ', f7.2, '  -- POLAR  NIGHT --')
        if(lhc == 0) &
            write(4, 5) tlsrGE, timdl, tlssGE
5       format(' Sun Rise Time [h]  = ', f7.2, '   Day Leng. = ', f7.2, &
               '   Sun Set Time = ', f7.2, '  -- SOLAR  TIME  --')
        if(lhc == 1) &
            write(4, 6) tlsrGE, timdl, tlssGE
6       format(' Sun Rise Time [h]  = ', f7.2, '   Day Leng. = ', f7.2, &
               '   Sun Set Time = ', f7.2, '  -- MIDNIGHT SUN --')
    endif

    ! +--Work Arrays Reset
    ! +  =================
#ifdef AZ
    do j = 1, my
        do i = 1, mx
#endif
#ifdef MM
            WKxy1(i, j) = 0.d0
            WKxy2(i, j) = 0.d0
#endif
#ifdef AZ
            WKxy3(i, j) = 0.d0
            WKxy4(i, j) = 0.d0
        enddo
    enddo
#endif
    return
end
