#include "MAR_pp.def"
subroutine phymar
    ! +------------------------------------------------------------------------+
    ! | MAR phymar                                             20-02-2025  MAR |
    ! |   subroutine phymar is used to define physical constants used in   MAR |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    use mardim
    use marphy
    use mar_ge
#ifdef RE
    use mar_ecrad
#endif
#ifdef RM
    use radcep
#endif
    implicit none

    ! +--LMDZ Time Constants
    ! +  ===================
    logical YR_360, YR_365 ! y_360
    character(len=10) CALENDAR
    integer n
    integer ioopen, ioread

    ! njyr30: Nb of Days since Begin of the Year, before Current Month
    integer, parameter :: njyr30(0:12) = &
                          (/0, 0, 30, 60, 90, 120, 150, 180, 210, 240, 270, 300, 330/)
    ! njyb30: Leap Year Correction to njyrGE
    integer, parameter :: njyb30(0:12) = &
                          (/0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0/)
    ! njmo30: Nb of Days in each Month of the Year
    integer, parameter :: njmo30(0:12) = &
                          (/0, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30/)
    ! njmb30: Leap Year Correction to njmo30
    integer, parameter :: njmb30(0:12) = &
                          (/0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0/)

    ! njyrGE : Number of Days since Begin of the Year before Current Month
    njyrGE = (/0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334/)
    ! njybGE : Leap Year Correction to current Day of the Year
    njybGE = (/0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1/)
    ! njmoGE : Number of Days in each Month of the Year
    njmoGE = (/0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31/)
    ! njmbGE : Leap Year Correction to njmoGE
    njmbGE = (/0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0/)

    YR_360 = .false.
    YR_365 = .false.


#ifdef RE
    CMIP_scenario = "CMIP6_SSP370_47r1" ! RCP26,RCP45,...,ssp126,ssp245,...
#endif
#ifdef RM
    CMIP_scenario = "ssp370" ! RCP26,RCP45,...,ssp126,ssp245,...
#endif

    open(unit=10, file="MARscenario.ctr", status="old", iostat=ioopen)
    if(ioopen == 0) then
        read(10, *, iostat=ioread) CMIP_scenario
        if(ioread == 0) then
            print *, "phymar CMIP scenario="//trim(CMIP_scenario)

#ifdef RE
            
            if(TRIM(CMIP_scenario) == "SSP126") CMIP_scenario = "CMIP6_SSP126_47r1"
            if(TRIM(CMIP_scenario) == "SSP245") CMIP_scenario = "CMIP6_SSP245_47r1"
            if(TRIM(CMIP_scenario) == "SSP370") CMIP_scenario = "CMIP6_SSP370_47r1"
            if(TRIM(CMIP_scenario) == "SSP585") CMIP_scenario = "CMIP6_SSP585_47r1"

            if(TRIM(CMIP_scenario) == "SSP26")  CMIP_scenario = "CMIP6_SSP126_47r1"
            if(TRIM(CMIP_scenario) == "SSP45")  CMIP_scenario = "CMIP6_SSP245_47r1"
            if(TRIM(CMIP_scenario) == "SSP70")  CMIP_scenario = "CMIP6_SSP370_47r1"
            if(TRIM(CMIP_scenario) == "SSP85")  CMIP_scenario = "CMIP6_SSP585_47r1"

            if(TRIM(CMIP_scenario) == "ssp126")  CMIP_scenario = "CMIP6_SSP126_47r1"
            if(TRIM(CMIP_scenario) == "ssp245")  CMIP_scenario = "CMIP6_SSP245_47r1"
            if(TRIM(CMIP_scenario) == "ssp370")  CMIP_scenario = "CMIP6_SSP370_47r1"
            if(TRIM(CMIP_scenario) == "ssp585")  CMIP_scenario = "CMIP6_SSP585_47r1"
            ! Additional lines to also take account of RCP scenarios
            if(TRIM(CMIP_scenario) == "RCP45")  CMIP_scenario = "CMIP5_RCP45_46r1"
            if(TRIM(CMIP_scenario) == "RCP85")  CMIP_scenario = "CMIP5_RCP85_46r1"
#endif

#ifdef RM
            if(TRIM(CMIP_scenario) == "SSP126") CMIP_scenario = "ssp126"
            if(TRIM(CMIP_scenario) == "SSP245") CMIP_scenario = "ssp245"
            if(TRIM(CMIP_scenario) == "SSP370") CMIP_scenario = "ssp370"
            if(TRIM(CMIP_scenario) == "SSP585") CMIP_scenario = "ssp585"
            if(TRIM(CMIP_scenario) == "SSP26")  CMIP_scenario = "ssp126"
            if(TRIM(CMIP_scenario) == "SSP45")  CMIP_scenario = "ssp245"
            if(TRIM(CMIP_scenario) == "SSP70")  CMIP_scenario = "ssp370"
            if(TRIM(CMIP_scenario) == "SSP85")  CMIP_scenario = "ssp585"
#endif

            
            print *, "CMIP time series NetCDF file from ECMWF suffixed with "//trim(CMIP_scenario)
        endif
        read(10, *, iostat=ioread) CALENDAR
        if(ioread == 0) then
            if(TRIM(CALENDAR) == "YR_360")  YR_360 = .true.
            if(TRIM(CALENDAR) == "yr_360")  YR_360 = .true.
            if(TRIM(CALENDAR) == "day_360") YR_360 = .true.
            if(TRIM(CALENDAR) == "DAY_360") YR_360 = .true.
            if(TRIM(CALENDAR) == "YR_365")  YR_365 = .true.
            if(TRIM(CALENDAR) == "yr_365")  YR_365 = .true.
            if(TRIM(CALENDAR) == "day_365") YR_365 = .true.
            if(TRIM(CALENDAR) == "DAY_365") YR_365 = .true.

        endif
    else
        print *, "phymar ERROR: MARscenario.ctr no found!!!"
    endif
    close(10)

    calGE="gregorian"
    if(YR_360) then
        print *, "phymar YR_360=.true."
        njmoGE = njmo30
        njmbGE = njmb30
        njyrGE = njyr30
        njybGE = njyb30
        calGE="360_day"
    endif

    if(YR_365) then
        print *, "phymar YR_365=.true."
        do n = 0, 12
            njmbGE(n) = 0
            njybGE(n) = 0
        enddo
        calGE="365_day"
    endif

    ! +--Time Constant
    ! +  -------------
    ! nhyrGE : Number of Hours in one Year
    nhyrGE = (njyrGE(12) + njmoGE(12)) * 24

    return
endsubroutine phymar
