#include "MAR_pp.def"
subroutine outsav
    ! +------------------------------------------------------------------------+
    ! | MAR OUTPUT                                        Mon 23-May-2011  MAR |
    ! |   subroutine outsav is used to save the main Model Variables           |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    use marctr
    use marphy
    use mardim
    use margrd
    use mar_ge
    use mar_dy
    use mar_lb
    use mar_ub
    use marsib
    use mar_te
    use mar_tu
    use mar_ra
    use mar_hy
    use mar_ca
    use mar_pb
    use mar_sl
    use mar_sv
    use mar_bs
    use mar_io
#ifdef NH
    use mar_nh
#endif
#ifdef TC
    use mar_tc
#endif
#ifdef PO
    use mar_po
#endif
#ifdef iso
    use mariso, only: qvDY_iso, qvapSL_iso, &
                      dqv_CA_iso, dqw_CA_iso, dqi_CA_iso, &
                      drr_CA_iso, dss_CA_iso, dsn_CA_iso, &
                      rainCA_iso, snowCA_iso, &
                      qiHY_iso, qsHY_iso, qwHY_iso, &
                      qrHY_iso, rainHY_iso, rai0HY_iso, &
                      snowHY_iso, sno0HY_iso, sfa0HY_iso, crysHY_iso, &
                      SLuqs_iso, SLuqsl_iso
#endif

    implicit none

    ! +--    Hydrostatic Dynamics
    ! +  ========================
    open(unit=11, status='unknown', form='unformatted', file='MARdyn.DAT')
    rewind 11
    ! Time    Parameters
    write(11) itexpe, jdh_LB
    write(11) iyrrGE, mmarGE, jdarGE, jhurGE
    ! Spatial Parameters
    write(11) imez, jmez
    write(11) GElat0, GElon0
    ! Discretisation
    write(11) sigma, ptopDY, dx, dy
    ! Dynamics
    write(11) uairDY
    write(11) vairDY
    write(11) pktaDY
    write(11) pstDY
    write(11) qvDY
    write(11) sh
    write(11) pstDY1
    ! Lateral Boundary Conditions
    write(11) iyr_LB, mma_LB, jda_LB, jhu_LB, jdh_LB
    write(11) vaxgLB, vaxdLB, vayiLB, vaysLB
    write(11) sst_LB
    ! Upper   Sponge   Reference State
    write(11) uairUB, vairUB, pktaUB
    write(11) pstDYn
    write(11) RAd_ir
    write(11) IRsoil
    write(11) virDY
    write(11) tim1LB, v1xgLB, v1xdLB, v1yiLB, v1ysLB
    write(11) tim2LB, v2xgLB, v2xdLB, v2yiLB, v2ysLB
    write(11) sst1LB, sst2LB
    write(11) ua1_UB, ua2_UB
    write(11) va1_UB, va2_UB
    write(11) pkt1UB, pkt2UB
    ! +
    if(my == 1) then
        write(11) ugeoDY
        write(11) vgeoDY
    endif
    ! +
    close(unit=11)
#ifdef iso
    ! write isotopic composition of dynamical variables
    open(unit=11, status='unknown', form='unformatted', file='MARdyn_iso.DAT')
    rewind 11
    write(11) qvDY_iso
    close(unit=11)
#endif
#ifdef NH
    ! +--Non-Hydrostatic Dynamics
    ! +  ========================
    open(unit=11, status='unknown', form='unformatted', file='MARonh.DAT')
    rewind 11
    write(11) itexpe
    ! Time Parameters
    write(11) iyrrGE, mmarGE, jdarGE, jhurGE
    ! Dynamics
    write(11) ua0_NH
    write(11) va0_NH
    write(11) wa0_NH
    write(11) wairNH
    write(11) pairNH
    close(unit=11)
#endif

    ! +--Mass Flux convective Scheme
    ! +  ===========================
    if(convec) then
        open(unit=11, status='unknown', form='unformatted', file='MARcva.DAT')
        rewind 11
        write(11) itexpe
        ! Time Parameters
        write(11) iyrrGE, mmarGE, jdarGE, jhurGE
        write(11) adj_CA
        write(11) int_CA
        write(11) dpktCA
        write(11) dqv_CA
        write(11) dqw_CA
        write(11) dqi_CA
        write(11) drr_CA
        write(11) dss_CA
        write(11) dsn_CA
        write(11) rainCA
        write(11) snowCA
        write(11) tau_CA
        write(11) Kstep1
        write(11) K_CbT1
        write(11) K_CbB1
        write(11) P_CH_0
        write(11) PdCH_1
        write(11) PdTa_1
        write(11) PdQa_1
        write(11) PdQw_1
        write(11) PdQi_1
        write(11) Pdrr_1
        write(11) Pdss_1
        write(11) PuMF_1
        write(11) PdMF_1
        write(11) Pfrr_1
        write(11) Pfss_1
        write(11) Pcape1
        close(unit=11)
#ifdef iso
        ! write isotopic composition of convective variables
        open(unit=11, status='unknown', form='unformatted', file='MARcva_iso.DAT')
        rewind 11
        write(11) dqv_CA_iso
        write(11) dqw_CA_iso
        write(11) dqi_CA_iso
        write(11) drr_CA_iso
        write(11) dss_CA_iso
        write(11) dsn_CA_iso
        write(11) rainCA_iso
        write(11) snowCA_iso
        close(unit=11)
#endif
    endif

    ! +--Microphysics
    ! +  ============
    if(micphy) then
        open(unit=11, status='unknown', form='unformatted', file='MARcld.DAT')
        rewind 11
        write(11) itexpe
        write(11) iyrrGE, mmarGE, jdarGE, jhurGE
        write(11) turnHY
        write(11) ccniHY
        write(11) qiHY
        write(11) qsHY
#ifdef qg
        write(11) qgHY
#endif
        write(11) qwHY
        write(11) qrHY
        write(11) rainHY, rai0HY
        write(11) snowHY, sno0HY, sfa0HY
        write(11) crysHY
        write(11) rainCA
#ifdef BS
        write(11) uss_HY
#endif
        close(unit=11)
#ifdef iso
        ! write isotopic composition of microphysics water
        open(unit=11, status='unknown', form='unformatted', file='MARcld_iso.DAT')
        rewind 11
        write(11) qiHY_iso
        write(11) qsHY_iso
        write(11) qwHY_iso
        write(11) qrHY_iso
        write(11) rainHY_iso, rai0HY_iso
        write(11) snowHY_iso, sno0HY_iso, sfa0HY_iso
        write(11) crysHY_iso
        ! rainCA_iso already in 'MARcva_iso.DAT'
        ! write(11) rainCA_iso
        close(unit=11)
#endif
    endif
#ifdef TC
    ! +--Atmospheric Tracers
    ! +  ===================
    open(unit=11, status='unknown', form='unformatted', file='MARtca.DAT')
    rewind 11
    write(11) itexpe
    write(11) iyrrGE, mmarGE, jdarGE, jhurGE
    write(11) dt_ODE, dt2ODE, nt_ODE, jt_ODE
    write(11) qxTC
    write(11) qsTC
    write(11) uqTC
    close(unit=11)
#endif
#ifdef PO
    ! +--Polynya Model
    ! +  =============
    if(polmod) then
        open(unit=11, status='unknown', form='unformatted', file='MARpol.DAT')
        rewind 11
        write(11) itexpe
        write(11) iyrrGE, mmarGE, jdarGE, jhurGE
        write(11) isolSL
        write(11) iPO1, iPO2, jPO1, jPO2, iPO3, iPO4, jPO3, jPO4
        write(11) hfraPO, vgriPO, uocnPO, vocnPO, swsaPO, focnPO
        write(11) silfPO, hicePO, aicePO, uicePO, vicePO, dtPO
        close(unit=11)
    endif
#endif
    ! +--Soil Model
    ! +  ==========
    open(unit=11, status='unknown', form='unformatted', file='MARsol.DAT')
    rewind 11
    write(11) itexpe
    write(11) iyrrGE, mmarGE, jdarGE, jhurGE
    write(11) nSLsrf
    write(11) SLsrfl
    write(11) TairSL
    write(11) tsrfSL
    write(11) alb0SL, eps0SL
    write(11) SaltSL
    write(11) ro_SL0
    write(11) ro_SL
    write(11) d1_SL
    write(11) t2_SL
    write(11) w2_SL, wg_SL
    write(11) roseSL
    write(11) qvapSL
    write(11) hsnoSL
    write(11) hmelSL
    write(11) SLuusl, SL_z0
    write(11) SLutsl, SL_r0
    write(11) pktaSL
    write(11) sicsIB
    write(11) sic1sI, sic2sI
    write(11) albeSL
    write(11) SLuus, SLuts
    write(11) SLuqs, SLuqsl
    write(11) duusSL
    write(11) dutsSL
    write(11) cdmSL, cdhSL
    write(11) V_0aSL
    write(11) dT0aSL
#ifdef AM
    write(11) u_0aSL
#endif
#ifdef AT
    write(11) uT0aSL
#endif
#ifdef AS
    write(11) us0aSL
#endif
#ifdef VX
    write(11) WV__SL
#endif
    write(11) SLlmo, SLlmol
#ifdef BV
    write(11) virSL
#endif
    close(unit=11)
#ifdef iso
    ! write isotopic composition of surface air water
    open(unit=11, status='unknown', form='unformatted', file='MARsol_iso.DAT')
    rewind 11
    write(11) qvapSL_iso
    write(11) SLuqs_iso
    write(11) SLuqsl_iso
    close(unit=11)
#endif
    ! +--SVAT Model
    ! +  ==========
    if(vegmod) then
        ! +       ***********
        call svasav('writ')
        ! +       ***********
    endif
    ! +--Turbulence
    ! +  ==========
    open(unit=11, status='unknown', form='unformatted', file='MARtur.DAT')
    rewind 11
    write(11) itexpe
    write(11) iyrrGE, mmarGE, jdarGE, jhurGE
    ! TURBULENT KINETIC ENERGY (TKE) and DISSIPATION (e)
    write(11) ect_TE
    write(11) eps_TE
    write(11) tranTE
    ! TURBULENT DIFFUSION COEFFICIENT
    write(11) TUkvm
    write(11) TUkvh
    close(unit=11)
    return
end
