subroutine OASIS_2_MAR

    ! +--------------------------------------------------------------------------+
    ! |                                                                20-20-2020|
    ! |   subroutine OASIS_2_MAR transfers OASIS variables to MAR                |
    ! |                                                                          |
    ! |                                                                          |
    ! |      A chaque pas de temps, fromcpl est appele ;                         |
    ! |      si il_time_secs est egal a un multiple de la periode de couplage    |
    ! |      alors son action est effective        (via oasis_get),              |
    ! |         et MAR recupere les champs de NEMO  via getfld (oasis)           |
    ! |                                                                          |
    ! |     C. Kittel + P-V. Huot + N. Jourdain                                  |
    ! |      cf mar_module.f90                                                   |
    ! |      cf OASIS-3 user guide (december 2004)                               |
    ! +--------------------------------------------------------------------------+

    use mod_oasis
    use mar_module
    use marctr
    use marphy
    use mardim
    use margrd
    use mar_ge
    use mar_ra
    use mar_lb
    use mar_dy
    use mar_hy
    use mar_te
    use mar_tu
    use mar_sv
    use mardsv
    use mar0sv
    use mar_sl
    use mar_ao
    use mar_tv
    use mar_bs
    use marssn
    use mar_io
    use marsib
    use mar_po
    use mar_wk

    implicit none

    ! +--MAR    Variables
    ! +  ----------------

    integer i, j, k, m, n, isl

    ! AO_CK 20/02/2020

    ! +--cpl : GET FIELDS FROM OASIS
    ! +  ===========================
    ! write(6, *)  "get fields?", tocken_AO
    if(tocken_AO == 1) then
        ! fromcpl a deja ete appele pour ce pas de temps
        tocken_AO = 0
    else
        ! il_time_secs : temps du run en sec. au pas de temps precedant
        il_time_secs = iterun * idt
        ! write(*,*) '     call fromcpl, itexpe =', itexpe

        ! +             *******
        call fromcpl(il_time_secs, srftAO(:, :, 1), aoss, &
                     sicsAO, aogla, albAO(:, :, 2), aoalb, srftAO(:, :, 2), aotic, &
                     hicAO, aohic, hsnoAO, aohsn, UoceAO, ao_uo, VoceAO, ao_vo, &
                     UiceAO, ao_ui, ViceAO, ao_vi)
        ! +             *******

        ! cpl----those oceanic fields from oasis are used along the code--

        ! +--open water albedo (same parametrisation as in NEMO,
        ! +  -----------------  but  with a real zenith angle)

        ! see Briegleb & Ramanathan, JAM, 1982
        ! print *, aoss, il_time_secs,iterun !for debug
        do i = 1, mx
            do j = 1, my

                ! Albedo from the ocean as computed in NEMO
                ! czenGE=cos(zenith angle),cld_SL=cloud cover
                albAO(i, j, 1) = (0.05 / (1.1 * czenGE(i, j)**1.4 + 0.15)) * cld_SL(i, j) &
                                 + 0.06 * (1.-cld_SL(i, j))

                ! you should avoid coupling sst and sic on different time steps
                ! even if it's possible in the code with different aoss and aogla
                if(aoss > 0 .and. weightao_sst(i, j) /= 1) then

                    ! avoid interpolation error in oasis
                    !WARNING WARNING WARNING
                    srftAO(i, j, 1) = min(max(srftAO(i, j, 1) / (1 - sicsAO(i, j)), 271.01), 300.15)

                    sst_LB(i, j) = (1.-weightao_sst(i, j)) * srftAO(i, j, 1) &
                                   + (weightAO_sst(i, j) * sst_LB(i, j))
                endif

                !+update of new snow layers in phy_sisvat_mp.f
                if(aotic > 0 .and. weightao_st(i, j) /= 1) then
                    !avoid interpolation error in oasis (non interecative mask)
                    !WARNING WARNING WARNING
                    srftAO(i, j, 2) = min(max(srftAO(i, j, 2) / sicsAO(i, j), 250.001), 273.15)

                    if(sicsAO(i, j) > 0) then
                        do isl = 1, nsno
                            if(maskSL(i, j) == 1 .and. nssSNo(i, j, 2) >= 1) then
                                ! if there  was snow/sea ice at dt-1 on sea(maskSL=1)
                                tisSNo(i, j, 2, isl) = (1.-weightao_st(i, j)) * srftAO(i, j, 2) &
                                                       + weightAO_st(i, j) * tisSNo(i, j, 2, isl)
                            endif
                        enddo
                    endif

                endif

                if(aogla > 0 .and. weightAO_sic(i, j) /= 1) then
                    sicsIB(i, j) = (1.-weightao_sic(i, j)) * sicsAO(i, j) &
                                   + (weightAO_sic(i, j) * sicsIB(i, j))
                endif

                if(aoalb > 0) then
                    albAO(i, j, 2) = max(min(albAO(i, j, 2) / sicsAO(i, j), 1.0), 0.0)
                    ! weighting directly in snoptp.f (phy_sisvat => (sisvat) => snoptp)
                endif

            enddo
        enddo

        ! hicAO et hsnoAO => only in full NEMO domain (update in physisvat_mp)

    endif

    return
end
