subroutine matinv(wk1, wk2, l_min, l_max)
    ! +
    ! +------------------------------------------------------------------------+
    ! | MAR DYNAMICS LBC                                       27-09-2001  MAR |
    ! |   subroutine matinv performs a Matrix Inversion using a Companion      |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT  : wk1 : Matrix to be inverted                                 |
    ! |   ^^^^^^^^       Dimension : (lmin:lmax) -> jdim=lmax-lmin+1           |
    ! |                  This Matrix is Loss after the Matrix Inversion        |
    ! |                                                                        |
    ! |   OUTPUT : wk2 : Inverted Matrix                                       |
    ! |   ^^^^^^^^                                                             |
    ! +------------------------------------------------------------------------+

    implicit none

    ! +--Input Output Variables
    ! +  ======================
    integer, intent(in) :: l_min
    integer, intent(in) :: l_max
    real, intent(inout) :: wk1(l_min:l_max, l_min:l_max)
    real, intent(out) :: wk2(l_min:l_max, l_min:l_max)

    ! +--Local  Variables
    ! +  ================
    ! +
    integer l, k, ll, llp1, llx1, llm1
    real xx, yy

    ! +--wk2 = Compagnion Matrix = Unity Matrix
    ! +  --------------------------------------
    ! +
    do l = l_min, l_max
        do k = l_min, l_max
            wk2(l, k) = 0.d0
        enddo
        wk2(l, l) = 1.d0
    enddo
    ! +
    ! +...Combinaisons lineaires de lignes de la matrice wk1 de facon a y faire
    ! +   apparaitre des 0 dans le triangle inferieur et des 1 sur la diagonale.
    ! +   Memes operations effectuees systematiquement sur la matrice compagnon.
    ! +
    ll = l_min
50  llp1 = ll + 1
    xx = wk1(ll, ll)
    ! +
    ! +...Si l'element diagonal est nul,la ligne le contenant est interchangee
    ! +   avec une des suivantes...jusqu'a ce qu'on obtienne un element non nul.
    ! +   Dans le cas contraire la matrice est singuliere.
    ! +
    if(xx == 0.0d0) then
        llx1 = ll + 1
90      if(wk1(llx1, llx1) == 0.0d0) then
            llx1 = llx1 + 1
            if(llx1 > l_max) write(21, *) 'Matrice non inversible'
            go to 90
        endif
        do k = l_min, l_max
            yy = wk1(ll, k)
            wk1(ll, k) = wk1(llx1, k)
            wk1(llp1, k) = yy
            yy = wk2(ll, k)
            wk2(ll, k) = wk2(llx1, k)
            wk2(llp1, k) = yy
        enddo
        xx = wk1(ll, ll)
    endif
    ! +
    ! +...Division pour obtenir 1 sur la diagonale
    ! +
    do k = l_min, l_max
        wk1(ll, k) = wk1(ll, k) / xx
        wk2(ll, k) = wk2(ll, k) / xx
    enddo
    ! +
    ! +...Soustraction pour obtenir 0 dans le triangle inferieur
    ! +
    do l = llp1, l_max
        xx = wk1(l, ll)
        do k = l_min, l_max
            wk1(l, k) = wk1(l, k) - xx * wk1(ll, k)
            wk2(l, k) = wk2(l, k) - xx * wk2(ll, k)
        enddo
    enddo
    ! +
    ! +...Passage a la ligne suivante
    ! +
    if(ll < l_max) then
        ll = ll + 1
        go to 50
    endif
    ! +
    ! +...Combinaisons lineaires effectuees sur la matrice wk1
    ! +   pour y faire apparaitre des 0 dans le triangle superieur.
    ! +   Memes operations effectuees sur la matrice compagnon
    ! +
    ll = l_max
60  llm1 = ll - 1
    do l = llm1, l_min, -1
        xx = wk1(l, ll)
        do k = l_min, l_max
            wk1(l, k) = wk1(l, k) - xx * wk1(ll, k)
            wk2(l, k) = wk2(l, k) - xx * wk2(ll, k)
        enddo
    enddo
    if(ll > l_min) then
        ll = ll - 1
        go to 60
    endif
    ! +
    return
end
