module marysv
    use mardim
    use mar_sv
    implicit none
    ! NLaysv : New Snow Layer Switch
    integer :: NLaysv(klonv)
    ! i_thin : Index of the thinest Layer
    integer :: i_thin(klonv)
    ! LIndsv : Contiguous Layer relative Index
    integer :: LIndsv(klonv)
    ! albisv : Integrated Surface Albedo
    real :: albisv(klonv)
    ! albssv : Soil Albedo [-]
    real :: albssv(klonv)
    ! SeaalbAOsisv : Ice/Snow Albedo from NEMO !AO_CK 20/02/2020
    real :: albAOsisv(klonv)
    ! SoCasv : Canopy Absorbed Solar Radiat.
    real :: SoCasv(klonv)
    ! SoSosv : Surface Absorbed Solar Radiat.
    real :: SoSosv(klonv)
    ! IRv_sv : Vegetation IR Flux [W/m2]
    real :: IRv_sv(klonv)
    ! Evg_sv : Emissivity of Vegetation+Snow
    real :: Evg_sv(klonv)
    ! Eso_sv : Emissivity of Soil+Snow
    real :: Eso_sv(klonv)
    ! tau_sv : Transmited Radiation Fraction
    real :: tau_sv(klonv)
    ! rrMxsv : Canopy Maximum Intercepted Rain
    real :: rrMxsv(klonv)
    ! LAIesv : effective LAI for transpirati.
    real :: LAIesv(klonv)
    ! LAI_sv : corrected LAI in case of snow
    real :: LAI_sv(klonv)
    ! glf_sv : Green Leaf Fraction
    real :: glf_sv(klonv)
    ! Sigmsv : Canopy Ventilation Factor
    real :: Sigmsv(klonv)
    ! HSv_sv : Sensible Heat Flux [W/m2]
    real :: HSv_sv(klonv)
    ! HLv_sv : Latent Heat Flux [W/m2]
    real :: HLv_sv(klonv)
    ! HSs_sv : Sensible Heat Flux (t)
    real :: HSs_sv(klonv)
    ! HLs_sv : Latent Heat Flux (t)
    real :: HLs_sv(klonv)
    ! sqrCm0 : in Neutral Drag Coef.Moment.
    real :: sqrCm0(klonv)
    ! sqrCh0 : in Neutral Drag Coef.Heat
    real :: sqrCh0(klonv)
    ! Lx_H2O : Latent Heat of Vaporiz./Sublim.
    real :: Lx_H2O(klonv)
    ! ram_sv : Aerodyn.Resistance (Moment.)
    real :: ram_sv(klonv)
    ! rah_sv : Aerodyn.Resistance (Heat)
    real :: rah_sv(klonv)
    ! Fh__sv : Stability Function
    real :: Fh__sv(klonv)
    ! dFh_sv : Stability Function (Deriv.)
    real :: dFh_sv(klonv)
    ! Evp_sv : Evaporation [kg/m2]
    real :: Evp_sv(klonv)
    ! EvT_sv : Evapotranspiration [kg/m2]
    real :: EvT_sv(klonv)
    ! LSdzsv : Land/Sea Vert. Discretiz. Fact.
    real :: LSdzsv(klonv)
    ! Tsrfsv : Surface Temperature
    real :: Tsrfsv(klonv)
    ! sEX_sv : Verticaly Integr.Extinct.Coef.
    real :: sEX_sv(klonv, -nsol:nsno + 1)
    ! zzsnsv : Snow Pack Thickness [m]
    real :: zzsnsv(klonv, 0:nsno)
    ! psi_sv : Soil Water Potential
    real :: psi_sv(klonv, -nsol:0)
    ! Khydsv : Soil Hydraulic Conductiv.
    real :: Khydsv(klonv, -nsol:0)
    ! Rootsv : Root Water Pump [kg/m2/s]
    real :: Rootsv(klonv, -nsol:0)
    ! EExcsv : Energy in Excess, current
    real :: EExcsv(klonv)
    common / ySISVAT_I / NLaysv, i_thin, LIndsv
    common / ySISVAT_R / albisv, albssv, albaosisv, SoCasv, &
        SoSosv, IRv_sv, Evg_sv, Eso_sv, tau_sv, &
        rrMxsv, LAIesv, LAI_sv, glf_sv, &
        Sigmsv, HSv_sv, HLv_sv, HSs_sv, HLs_sv, &
        sqrCm0, sqrCh0, Lx_H2O, ram_sv, rah_sv, Evp_sv, EvT_sv, &
        LSdzsv, Tsrfsv, sEX_sv, zzsnsv, &
        psi_sv, Khydsv, Rootsv, EExcsv
    save
    !$OMP threadprivate(/ySISVAT_I/,/ySISVAT_R/)
endmodule marysv
