! marxsv : SISVAT INPUT Variables
! ===============================
module marxsv
    use mardim
    use mar_sv
    implicit none
    ! LSmask : Land-Sea Mask
    integer :: LSmask(klonv)
    ! isotSV : Soil Type
    integer :: isotSV(klonv)
    ! iWaFSV : Soil Drainage:(1,0)=(y,n)
    integer :: iWaFSV(klonv)
    ! ivgtSV : Vegetation Type
    integer :: ivgtSV(klonv)
    ! AOmask : Weight-coupling Mask (1: MAR; 0 = Oasis) !AO_CK 20/02/2020
    real :: AOmask(klonv)
    ! coszSV : Cosine of Sun zenithal Angle
    real :: coszSV(klonv)
    ! sol_SV : Downward Solar Radiation
    real :: sol_SV(klonv)
    ! IRd_SV : Downward Longwave Radiation
    real :: IRd_SV(klonv)
    ! drr_SV : Rain Intensity [kg/m2/s]
    real :: drr_SV(klonv)
    ! dsn_SV : Snow Intensity [kg/m2/s]
    real :: dsn_SV(klonv)
    ! dsnbSV : Idem, fraction, from Drift [-]
    real :: dsnbSV(klonv)
    ! esnbSV : Idem, fraction, from Drift [-]
    real :: esnbSV(klonv)
    ! dbs_SV : Drift Amount [kg/m2]
    real :: dbs_SV(klonv)
    ! BrosSV : Buffer Snow Layer Density
    real :: BrosSV(klonv)
    ! BG1sSV : Buffer Snow Layer Dendr/Sphe[-]
    real :: BG1sSV(klonv)
    ! BG2sSV : Buffer Snow Layer Spher/Size[-] [0.0001 m]
    real :: BG2sSV(klonv)
    ! dz0_SV : dz0(Sastrugi dh) [m]
    real :: dz0_SV(klonv)
    ! dbs_Er : BS Erosion [kg/m2]
    real :: dbs_Er(klonv)
    ! dbs_Ac : BS Accumulation [kg/m2]
    real :: dbs_Ac(klonv)
    ! cld_SV : Cloudiness (seen from SBL)
    real :: cld_SV(klonv)
    ! za__SV : SBL Height
    real :: za__SV(klonv)
    !(VV__SV : SBL Top) Wind Velocity
    real :: VV__SV(klonv)
    ! VV10SV : 10-m Wind Velocity
    real :: VV10SV(klonv)
    !(VVs_SV : Sastr,V) Relevance
    real :: VVs_SV(klonv)
    !(RRs_SV : Sastr,V) Counter
    real :: RRs_SV(klonv)
    !(DDs_SV : Sastr,V) Angle
    real :: DDs_SV(klonv)
    ! TaT_SV : SBL Top Temperature
    real :: TaT_SV(klonv)
    ! ExnrSV : Exner Potential
    real :: ExnrSV(klonv)
    ! dSdTSV : Sensible Heat Flux T Derivat.
    real :: dSdTSV(klonv)
    ! dLdTSV : Latent Heat Flux T Derivat.
    real :: dLdTSV(klonv)
    ! rhT_SV : SBL Top Air Density
    real :: rhT_SV(klonv)
    ! QaT_SV : SBL Top Specific Humidity
    real :: QaT_SV(klonv)
    ! dQa_SV : SBL Flux Limitation of Qa
    real :: dQa_SV(klonv)
    ! qsnoSV : SBL Mean Snow Content
    real :: qsnoSV(klonv)
    ! tsrf_SV : surface temperature(K)
    real :: tsrf_SV(klonv)
    ! pst_SV : surface pressure (kPa)
    real :: pst_SV(klonv)
    ! LAI0SV : Nominal Leaf Area Index
    real :: LAI0SV(klonv)
    ! glf0SV : Green Leaf Fraction
    real :: glf0SV(klonv)
    ! alb0SV : Soil Albedo
    real :: alb0SV(klonv)
    ! slopSV : Snow/Ice/Soil-Water Surf. Slope
    real :: slopSV(klonv)
    ! ptopSV : Pressure at Model Top (kPa)
    real :: ptopSV
    ! zSBLSV : SBL Height (Initial Value)
    real :: zSBLSV
    ! dt__SV : Time Step
    real :: dt__SV
    ! daHost : Date Host Model
    character(len=18), save :: daHost
    ! +--SISVAT INPUT/OUTPUT Variables
    ! + -----------------------------
    ! isnoSV : Nb of Ice/Snow Layers
    integer :: isnoSV(klonv)
    ! ispiSV : Uppermost superimposed ice
    integer :: ispiSV(klonv)
    ! iiceSV : Nb of Ice Layers
    integer :: iiceSV(klonv)
    ! istoSV : Snow Layer History
    integer :: istoSV(klonv, 0:nsno)
    ! alb_SV : Surface-Canopy Albedo
    real :: alb_SV(klonv)
    ! aiceSV : presribed bare ice albedo
    real :: aiceSV(klonv)
    ! alb1SV : Snow Albedo
    real :: alb1SV(klonv)
    ! alb2SV : Snow Albedo
    real :: alb2SV(klonv)
    ! alb3SV : Snow Albedo
    real :: alb3SV(klonv)
    ! emi_SV : Surface-Canopy Emissivity
    real :: emi_SV(klonv)
    ! IRs_SV : Soil IR Flux
    real :: IRs_SV(klonv)
    ! LMO_SV : Monin-Obukhov Scale
    real :: LMO_SV(klonv)
    ! us__SV : Friction Velocity
    real :: us__SV(klonv)
    ! uts_SV : Temperature Turbulent Scale
    real :: uts_SV(klonv)
    ! cutsSV : Temperature Turbulent Scale C.
    real :: cutsSV(klonv)
    ! uqs_SV : Spec.Humid. Turbulent Scale
    real :: uqs_SV(klonv)
    ! uss_SV : Blow.Snow Turbulent Scale
    real :: uss_SV(klonv)
    ! usthSV : Blowing Snow Erosion Thresh.
    real :: usthSV(klonv)
    ! rCDmSV : Square Root Contribut. Drag_m
    real :: rCDmSV(klonv)
    ! rCDhSV : Square Root Contribut. Drag_h
    real :: rCDhSV(klonv)
    ! Z0m_SV : Momentum Roughness Length
    real :: Z0m_SV(klonv)
    ! Z0mmSV : z0(Momentum, Time Mean) [m]
    real :: Z0mmSV(klonv)
    ! Z0mnSV : z0(Momentum, instanta.) [m]
    real :: Z0mnSV(klonv)
    ! Z0roSV : Subgrid Topo Roughness Length
    real :: Z0roSV(klonv)
    ! Z0SaSV : z0(Sastrugi h) [m]
    real :: Z0SaSV(klonv)
    ! Z0e_SV : z0(Snow eroded) [m]
    real :: Z0e_SV(klonv)
    ! Z0emSV : z0(Snow eroded, Time Mean) [m]
    real :: Z0emSV(klonv)
    ! Z0enSV : z0(Snow eroded, instanta.) [m]
    real :: Z0enSV(klonv)
    ! Z0h_SV : Heat Roughness Length
    real :: Z0h_SV(klonv)
    ! Z0hmSV : z0(Heat, Time Mean) [m]
    real :: Z0hmSV(klonv)
    ! Z0hnSV : z0(Heat, instanta.) [m]
    real :: Z0hnSV(klonv)
    ! snCaSV : Canopy Snow Thickness
    real :: snCaSV(klonv)
    ! rrCaSV : Canopy Water Content
    real :: rrCaSV(klonv)
    ! psivSV : Leaf Water Potential
    real :: psivSV(klonv)
    ! TvegSV : Vegetation Temperature
    real :: TvegSV(klonv)
    ! TsisSV : Snow/Ice/Soil-Water Temperature
    real :: TsisSV(klonv, -nsol:nsno)
    ! ro__SV : Snow/Ice/Soil-Water VolumicMass
    real :: ro__SV(klonv, -nsol:nsno)
    ! eta_SV : Snow/Ice/Soil Water Content
    real :: eta_SV(klonv, -nsol:nsno)
    ! G1snSV : Snow Dendricity/Sphericity
    real :: G1snSV(klonv, 0:nsno)
    ! G2snSV : Snow Sphericity/Size
    real :: G2snSV(klonv, 0:nsno)
    ! dzsnSV : Snow Layer Thickness
    real :: dzsnSV(klonv, 0:nsno)
    ! agsnSV : Snow Age
    real :: agsnSV(klonv, 0:nsno)
    ! BufsSV : Snow Buffer Layer
    real :: BufsSV(klonv)
    ! rusnSV : Surficial Water
    real :: rusnSV(klonv)
    ! SWf_SV : Normalized Decay
    real :: SWf_SV(klonv)
    ! SWS_SV : Surficial Water Status
    real :: SWS_SV(klonv)
    ! HFraSV : Frazil Thickness
    real :: HFraSV(klonv)
    ! zWE_SV : Current Snow Thickness [mmWE]
    real :: zWE_SV(klonv)
    ! zWEcSV : Compacted Snow Thickness [mmWE]
    real :: zWEcSV(klonv)
    ! wem_SV : Only Melting [mmWE]
    real :: wem_SV(klonv)
    ! wer_SV : Refreezing [mmWE]
    real :: wer_SV(klonv)
    ! wee_SV : Evapo/Sublimation [mmWE]
    real :: wee_SV(klonv, 4)
    ! zn4_SV : snowheight change [mm]
    real :: zn4_SV(klonv)
    ! zn5_SV : snowheight change [mm]
    real :: zn5_SV(klonv)
    ! +--SISVAT OUTPUT Variables
    ! + -----------------------------
    ! no__SV : OUTPUT file Unit Number
    integer :: no__SV(nb_wri)
    ! i___SV : OUTPUT point i Coordinate
    integer :: i___SV(nb_wri)
    ! j___SV : OUTPUT point j Coordinate
    integer :: j___SV(nb_wri)
    ! n___SV : OUTPUT point n Coordinate
    integer :: n___SV(nb_wri)
    ! lwriSV : OUTPUT point vec Index
    integer :: lwriSV(klonv)
    ! ii__SV : WORK point i Coordinate
    integer :: ii__SV(klonv), iwr_SV
    ! jj__SV : WORK point j Coordinate
    integer :: jj__SV(klonv), jwr_SV
    ! nn__SV : WORK point n Coordinate
    integer :: nn__SV(klonv), nwr_SV
    ! IRu_SV : UPward IR Flux (effective)
    real :: IRu_SV(klonv)
    ! hSalSV : Saltating Layer Height
    real :: hSalSV(klonv)
    ! qSalSV : Saltating Snow Concentration
    real :: qSalSV(klonv)
    ! RnofSV : RunOFF Intensity
    real :: RnofSV(klonv)
    ! RuofSV : RunOFF Intensity
    real :: RuofSV(klonv, 6)
    common / xSISVAT_I / LSmask, ivgtSV, isotSV, iWaFSV &
        , isnoSV, ispiSV, iiceSV, istoSV &
        , no__SV, i___SV, j___SV, n___SV, lwriSV &
        , ii__SV, jj__SV, nn__SV &
        , iwr_SV, jwr_SV, nwr_SV
    common / xSISVAT_R / AOmask, coszSV, sol_SV, IRd_SV &
        , drr_SV, dsn_SV, dsnbSV, esnbSV, dbs_SV &
        , BrosSV, BG1sSV, BG2sSV, dz0_SV &
        , cld_SV, za__SV, VV__SV, VV10SV, TaT_SV, ExnrSV &
        , VVs_SV, RRs_SV, DDs_SV &
        , dSdTSV, dLdTSV, rhT_SV, QaT_SV, qsnoSV, tsrf_SV, pst_SV &
        , LAI0SV, glf0SV, alb0SV, slopSV, zSBLSV, dt__SV &
        , alb_SV, emi_SV, IRs_SV,aiceSV &
        , LMO_SV, us__SV, uts_SV, cutsSV, uqs_SV, uss_SV, usthSV &
        , rCDmSV, rCDhSV, ptopSV &
        , Z0m_SV, Z0mnSV, Z0mmSV, Z0roSV, Z0SaSV &
        , Z0e_SV, Z0enSV, Z0emSV, zn4_SV, zn5_SV &
        , Z0h_SV, Z0hnSV, Z0hmSV, snCaSV, rrCaSV &
        , psivSV, TvegSV, TsisSV, ro__SV, eta_SV &
        , G1snSV, G2snSV, dzsnSV, agsnSV, BufsSV, rusnSV, SWf_SV &
        , SWS_SV, HFraSV, IRu_SV, hSalSV, qSalSV, RnofSV, RuofSV &
        , zWE_SV, zWEcSV, wem_SV, wer_SV, wee_SV &
        , alb1SV, alb2SV, alb3SV, dbs_Er, dbs_Ac
    save
    !$OMP threadprivate(/xSISVAT_I/,/xSISVAT_R/)
endmodule marxsv
