! marssn : snowpack
! ==================
module marssn
    use mardim
    use mar_sv
    implicit none
    integer, parameter :: nsx = mw
    ! *CL* interpolation of boundary layer variables
    real, save, allocatable :: sh_int(:, :, :)
    real, save, allocatable :: tairDY_int(:, :, :)
    real, save, allocatable :: gradTM(:, :)
    real, save, allocatable :: qvDY_int(:, :, :)
    real, save, allocatable :: gradQM(:, :)
    ! mskSNo: Snow/Ice Type Index
    real, save :: mskSNo(mx, my, nsx)
    ! nssSNo: Number of Snow Layers
    integer, save :: nssSNo(mx, my, nsx)
    ! nisSNo: Number of Ice Layers
    integer, save :: nisSNo(mx, my, nsx)
    ! issSNo: Number of superimposed Ice Layers
    integer, save :: issSNo(mx, my, nsx)
    ! nhsSNo: Layer historics: previous occurrence of water or faceted crystal
    integer, save, allocatable :: nhsSNo(:, :, :, :)
    ! tisSNo: Soil temperature (=> in the snow cover ) [K]
    real, save, allocatable :: tisSNo(:, :, :, :)
    ! wasSNo: Soil humidity content (=> in the snow cover ) [kg/kg]
    real, save, allocatable :: wasSNo(:, :, :, :)
    ! rosSNo: Snow density [kg/m3]
    real, save, allocatable :: rosSNo(:, :, :, :)
    ! dzsSNo: Depth of each layer of the snow cover [m]
    real, save, allocatable :: dzsSNo(:, :, :, :)
    ! g1sSNo: Grain Type: -99< g1 < 0 (Dendricity) 0< g1 <99 [Sphericity]
    real, save, allocatable :: g1sSNo(:, :, :, :)
    ! g2sSNo: Grain Type: 0< g2 <99 (Sphericity) .3mm < g2 [Size]
    real, save, allocatable :: g2sSNo(:, :, :, :)
    ! agsSNo: Snow Age [day]
    real, save, allocatable :: agsSNo(:, :, :, :)
    ! SWaSNo: Surficial Water Mass [mmWE or kg/m2]
    real, save, allocatable :: SWaSNo(:, :, :)
    ! SWSSNo: Surficial Water Status (0,1 = no freezing,freezing)
    real, save, allocatable :: SWSSNo(:, :, :)
    ! SWfSNo: Surficial Water Hydrological Model [-]
    real, save, allocatable :: SWfSNo(:, :)
    ! snohSN: Snow Buffer Layer Thickness [mmWE]
    real, save, allocatable :: snohSN(:, :, :)
    ! BrosSN: Snow Buffer Layer Density [kg/m3]
    real, save, allocatable :: BrosSN(:, :, :)
    ! BG1sSN: Snow Buffer Layer Dendricity / Sphericity [-]
    real, save, allocatable :: BG1sSN(:, :, :)
    ! BG2sSN: Snow Buffer Layer Sphericity / Size [-] [0.1 mm]
    real, save, allocatable :: BG2sSN(:, :, :)
    ! blowSN: Blown snow Buffer Layer Thickness [mWE]
    real, save, allocatable :: blowSN(:, :, :)
    ! SaltSN: Friction Velocity Saltation Threshold [m/s]
    real, save, allocatable :: SaltSN(:, :, :)
    ! hSalSN: Saltating Snow Thickness [mWE]
    real, save, allocatable :: hSalSN(:, :, :)
    ! zWE0SN: Initial Snow Thickness [mmWE]
    real, save, allocatable :: zWE0SN(:, :, :)
    ! zWE_SN: Current Snow Thickness [mmWE]
    real, save, allocatable :: zWE_SN(:, :, :)
    ! zWEcSN: Non-erodible Snow Thickness [mmWE]
    real, save, allocatable :: zWEcSN(:, :, :)
    ! smbsSN : Surface Mass Balance [mWE]
    real, save, allocatable :: smbsSN(:, :, :)
    ! sihsSN : Superimposed Ice Height [m]
    real, save, allocatable :: sihsSN(:, :, :)
    ! sshsSN : Slush Height [m]
    real, save, allocatable :: sshsSN(:, :, :)
    ! ravsSN : Averaged Density [kg/m2]
    real, save, allocatable :: ravsSN(:, :, :)
    ! wavsSN : Averaged Water Content [kg/kg]
    real, save, allocatable :: wavsSN(:, :, :)
    ! WEq_SN : Added Snow Mass [mmWE]
    real, save, allocatable :: WEq_SN(:, :, :)

contains
    
    subroutine marssn_init()
        
        use mardim, only : mx, my
        implicit none
        
        allocate(nhsSNo(mx, my, nsx, nsno))
        allocate(sh_int(mx, my, nsx))
        allocate(tairDY_int(mx, my, nsx))
        allocate(gradTM(mx, my))
        allocate(qvDY_int(mx, my, nsx))
        allocate(gradQM(mx, my))
        allocate(tisSNo(mx, my, nsx, nsno))
        allocate(wasSNo(mx, my, nsx, nsno))
        allocate(rosSNo(mx, my, nsx, nsno))
        allocate(dzsSNo(mx, my, nsx, nsno))
        allocate(g1sSNo(mx, my, nsx, nsno))
        allocate(g2sSNo(mx, my, nsx, nsno))
        allocate(agsSNo(mx, my, nsx, nsno))
        allocate(SWaSNo(mx, my, nsx))
        allocate(SWSSNo(mx, my, nsx))
        allocate(SWfSNo(mx, my))
        allocate(snohSN(mx, my, nsx))
        allocate(BrosSN(mx, my, nsx))
        allocate(BG1sSN(mx, my, nsx))
        allocate(BG2sSN(mx, my, nsx))
        allocate(blowSN(mx, my, nsx))
        allocate(SaltSN(mx, my, nsx))
        allocate(hSalSN(mx, my, nsx))
        allocate(zWE0SN(mx, my, nsx))
        allocate(zWE_SN(mx, my, nsx))
        allocate(zWEcSN(mx, my, nsx))
        allocate(smbsSN(mx, my, nsx))
        allocate(sihsSN(mx, my, nsx))
        allocate(sshsSN(mx, my, nsx))
        allocate(ravsSN(mx, my, nsx))
        allocate(wavsSN(mx, my, nsx))
        allocate(WEq_SN(mx, my, nsx))
    
    endsubroutine marssn_init

endmodule marssn
