module marsnd
    implicit none
    real, save :: tiSND1, tiSND2
    ! ===============================================
    ! Standard Atmosphere (Winter / Middle Latitudes)
    ! ===============================================
    ! iSND, jSND are the (x,y) coordinates of the sounding grid point
    integer, save :: iSND
    integer, save :: jSND
    ! pstSND: initial model depth (kPa)
    real, save :: pstSND
    ! iyrSND, mmaSND, jdaSND, jhuSND
    ! Year    Month   Day     HourUT  of  the  Sounding
    integer, save :: iyrSND, mmaSND, jdaSND, jhuSND
    ! nSND: Sounding No
    integer, save :: nSND
    ! loSND: 1 -> This is NOT the last Sounding
    integer, save :: loSND
    ! xSND : sounding characteristics
    ! x = (tp->potential temperature
    !      t->temperature, q->specific humidity,
    !      z->Altitude, p->pressure, ff, dd-> large scale wind components)
    !      ze->relative vorticity
    !      uu,vv->Large Scale Wind Vector in MAR horiz. coord. (iSND,jSND)
    real, save :: zSND(0:40, 2)
    real, save :: tSND(0:40, 2)
    real, save :: qSND(0:40, 2)
    real, save :: pSND(0:40, 2)
    real, save :: tpSND(0:40, 2)
    real, save :: fSND(0:40, 2)
    real, save :: dSND(0:40, 2)
    real, save :: zeSND(2)
    real, save :: uuSND(0:40)
    real, save :: vvSND(0:40)
endmodule marsnd
