#include "MAR_pp.def"
module marphy
    implicit none
    ! labnum: Alphanumeric Character
    character(len=1), parameter :: labnum(0:10) = (/ &
                                   '0', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'/)
    ! =================
    ! Numeric Constants
    ! =================
    ! izr = 0
    integer, parameter :: izr = 0
    ! iun = 1
    integer, parameter :: iun = 1
    ! zero = 0.0
    real, parameter :: zero = 0.
    ! demi = 0.5
    real, parameter :: demi = 0.5
    ! unun = 1.0
    real, parameter :: unun = 1.
    ! epsi = 1.0e-6
    real, parameter :: epsi = 0.000001
    ! eps9 = 1.0e-9
    real, parameter :: eps9 = 0.000000001
    ! eps12 = 1.0e-12
    real, parameter :: eps12 = 0.000000000001
    ! third = 1/3
    real, parameter :: third = 1./3.
    ! thous = 1.e3
    real, parameter :: thous = 1000.
    ! argmin: Function exp(x) Minimum Argument
    real, save :: argmin
    ! argmax: Function exp(x) Maximum Argument (Min/Max are Machine Dependant)
    real, save :: argmax
    ! ===================
    ! Geometric Constants
    ! ===================
    ! pi = 3.141592653589793238462643e0 !CAa-to-be-changed
    real, parameter :: pi = acos(-1.)
    ! degrad = pi / 180.
    real, parameter :: degrad = pi / 180.
    ! hourad = pi / 12.
    real, parameter :: hourad = pi / 12.
    ! ===============
    ! Earth Constants
    ! ===============
    ! earthr: Earth Radius = 6371.d+3 m
    real, parameter :: earthr = 6378.1370e+3
    ! earthv: Earth Angular Velocity = 7.29d-5  s-1 !CAa-verify-10-5-or-10-7
    real, parameter :: earthv = 729.217e-7
    ! gravit: Earth Gravity Acceleration = 9.81 m/s2
    real, parameter :: gravit = 9.81
    ! gravi2: gravit ** 2
    real, parameter :: gravi2 = gravit**2.
    ! grvinv: 1 / gravit
    real, parameter :: grvinv = 1 / gravit
    ! ===================
    ! Dynamical Constants
    ! ===================
    ! akmol : Air Viscosity = 1.35d-5 m2/s
    real, parameter :: akmol = 1.35e-5
    ! vonkar: von Karman constant = 0.4
    real, parameter :: vonkar = 0.4
    ! A_Turb: Stability Coefficient Moment = 5.8
    !         Stability Coefficient in the SBL Universal Stable Function
    !         for Momentum (Cheng et al., 2005, 2004JD004923, p.3, eq.9: 5.8)
    real, parameter :: A_Turb = 5.8
    ! AhTurb: Stability Coefficient Heat = 5.4
    !         Stability Coefficient in the SBL Universal Stable Function
    !         for Heat (Cheng et al., 2005, 2004JD004923, p.3, eq.9: 5.4)
    real, parameter :: AhTurb = 5.4
    ! AsTurb: Stability Coefficient BLOW * = 4.0
    !         Stability Coefficient in the SBL Universal Stable Function
    !         for BLOW*(Bintanja, 2000, BLM 95, p.390 4.0)
    real, parameter :: AsTurb = 4.
    ! r_Turb: Turbulent Diffusivities Ratio K*/Km
    !         (Bintanja, 2000, BLM 95, p. 384 3.0)
    real, parameter :: r_Turb = 3.
    ! ======================================
    ! Thermodynamical Constants (Atmosphere)
    ! ======================================
    ! RDryAi: perfect gas law constant for dry air (287 J/kg/K)
    real, parameter :: RDryAi = 287.05967
    ! Ra    : perfect gas law constant for dry air (287 J/kg/K)
    real, parameter :: Ra = 287.05967
    ! Cp    : dry air specific heat at constant p (1004 J/kg/K)
    real, parameter :: Cp = 1004.708845
    ! CvDryA: dry air specific heat at constant V ( 717 J/kg/K)
    real, parameter :: CvDryA = Cp - RDryAi
    ! racv  = Ra / Cv = Ra /(Cp-Ra)
    real, parameter :: racv = RDryAi / CvDryA
    ! cap   = ra / cp
    real, parameter :: cap = RDryAi / Cp
    ! pcap = 100 ** (R / Cp) = 100.[kPa]**cap
    real, parameter :: pcap = 3.7301
    ! RVapor: perfect gas law constant Water Vapor (461 J/kg/K)
    real, parameter :: RVapor = 461.
    ! epsq  : Minimum Water Vapor Content = 3.00d-6 kg/kg
    real, parameter :: epsq = 3.e-6
    ! Lv_H2O: Latent Heat Vaporisation / Water = 2500.00d+3 J/kg
#ifdef EU
    real, parameter :: Lv_H2O = 2.2608e6
#else
    real, parameter :: Lv_H2O = 2.5008e6
#endif
    ! Ls_H2O: Latent Heat Sublimation / Ice = 2833.60d+3 J/kg
    real, parameter :: Ls_H2O = 2.8345e6
    ! r_LvCp [Lv=2500000J/kg]/[Cp=1004J/kg/K]= 2490.04    K/[kg/kg]
    real, parameter :: r_LvCp = Lv_H2O / Cp
    ! r_LcCp [Lc= 333600J/kg]/[Cp=1004J/kg/K]=  332.27    K/[kg/kg]
    real, parameter :: r_LcCp = (Ls_H2O - Lv_H2O) / Cp
    ! r_LsCp [Ls=2833600J/kg]/[Cp=1004J/kg/K]= 2822.31    K/[kg/kg]
    real, parameter :: r_LsCp = Ls_H2O / Cp
    ! stefan: Stefan Constant = 5.67d-8 W/m2/K4
    real, parameter :: stefan = 5.67e-8
    ! qv_MIN: Minimum Specific Humidity = 3.00d-6 kg/kg
    !         (Christian Tricot, pers.com.)
    real, parameter :: qv_MIN = 3.e-6
    ! ===============================
    ! Thermodynamical Constants (Sea)
    ! ===============================
    ! ------------------------------------------------------------------
    ! cpl : constants usefull for coupled configuration (see MAR_AO.inc)
    ! !AO_CK 20/02/2020
    ! ------------------------------------------------------------------
    ! cpv: water vapor specific heat (J/kg/K)
    real, parameter :: cpv = 1846.1
    ! cpvir: [cpv/cp - 1] (usefull value for qsat) (-)
    real, parameter :: cpvir = 0.83746
    ! R_Rv: [gas cste dry air=287.0] / [gas cste moist air=461.5]
    real, parameter :: R_Rv = 0.622
    ! EmiSnoao : Snow Emissivity
    real, parameter :: EmiSnoao = 0.95
    ! EmiWatao : Water Emissivity
    real, parameter :: EmiWatao = 1.
    ! other
    ! -----
    ! tfrwat: Sea-Water freezing Temperature = 271.20d+0 K
    real, parameter :: tfrwat = 271.2
    ! siclf : Sea-Ice Heat of Fusion = 302.00d+6 J/m3
    real, parameter :: siclf = 302.e6
    ! cdsice: Sea-Ice Thermal Conductivity = 2.04d+0 W/mK
    real, parameter :: cdsice = 2.04
    ! hic0  : Sea-Ice Initial Thickness = 2.00d+0 m
    real, save :: hic0 = 1.
    ! ro_Wat: Density of Water = 1000.00d+0 kg/m3
    real, parameter :: ro_Wat = 1000.
    ! C__Wat: Heat Capacity of Water = 4186.00d+0 J/kg/K
    real, parameter :: C__Wat = 4186.
    ! fracoh : 1. - 0.25
    ! Hibler (1984): 25% of cooling => Oceanic Heat Flux (ANTARCTIC Ocean)
    real, parameter :: fracoh = 0.75
    ! ro_Ice: Density of Pure Ice = 920.00 kg/m3
    real, parameter :: ro_Ice = 920.
    ! cdice : Conductivity of Pure Ice = 2.51 W/m/K
    real, parameter :: cdice = 2.1
    ! TfSnow: Snow melting Temperature = 273.15 K
    real, parameter :: TfSnow = 273.15
    !  csnow: Heat Capacity of Snow = 2105. J/kg/K (Loth et al. 1993, JGR 98 D6, 2.2.2 2e para p.10453)
    real, parameter :: csnow = 2105.
    ! r0sno : Fresh  Snow Density (kg/m3)
    real, parameter :: r0sno = 30.
    ! frsno : Fresh blowed Snow Density (kg/m3)
    ! frsno : Fresh Snow Density (kg/m3) / calibration
    real, parameter :: frsno = 300.
    ! Lf_H2O: Latent Heat of Fusion of Snow  (J/kg)
    real, parameter :: Lf_H2O = 3.337e5
    ! ===============================================
    ! Standard Atmosphere (Winter / Middle Latitudes)
    ! ===============================================
endmodule marphy
