! marmagic : The famous ROCHEFORT_10 parameters  ;-)
! ==================================================

! 1. To have more precipitation, humidty and LWD:
!     - cnos,cnos2 (#ur,#up, ...) in hydmic.f impact the ratio inland/margin precip
!       and the amount of precipitation
!     - uncomment the 2 lines BUGBUG in DYNadv_LFB_2p

! 2. In cvagen_mnh, if OsetA0=T,
!     - higher PTdcv0 is, lower precip is
!     - lower PTscv0 is, lower precip is
!     - lower pdtCV0 is, higher precip is

! 3. In PHYrad_CEP_mp.f, the cloud amount can be artificially increased
! e.g.  qw_CEP(ikl,lkl) = qw_CEP(ikl,lkl) * 1.1

! 4. if MAR is too warm, you can increase the temperature filtering FIslot in grdmar.f
module marmagic
    implicit none
    ! humidity_magic : [ 0 - 25 ]
    ! ===========================
    !   This parameter (formerly FacFIk) impacts the dissipation of humidity
    !   higher this parameter is, higher the humdity is but warmer MAR is
    !   About precipitation, it is dependant of the resolution.
    ! Belgium  : humidity_magic = 20.
    ! Black Sea: humidity_magic = 15.
    ! Greenland: humidity_magic = 20.
    real, parameter :: humidity_magic = 20.
    ! cloud_magic : [ 0 - 1 ]
    ! =======================
    !   This paremeter converts x % part of QS/QR (precip) into QI/QW (clouds).
    !   higher this parameter is, higher the cloudiness is, lower precip inland is there.
    !   A value of 0.1 means +10%
    ! Belgium: cloud_magic = 0.1
    ! Black Sea: cloud_magic = 0.15
    ! Greenland: cloud_magic = 0.0
    real, parameter :: cloud_magic = 0.
    ! correction_humidity_boundary : [ -0.3 - +0.3 ]
    ! ==============================================
    !   At high resolution, you need to increase the humidity at the MAR lateral boundaries.
    !   Normally, this correction is done in NESTOR (see subroutine NSTint.f)
    !   But here you have the possibility, to change add an additionnal correction.
    !   A value of 0.1 means +10%
    ! Black Sea: correction_humidity_boundary = +0.05
    real, parameter :: correction_humidity_boundary = 0.0
    ! rain_snow_limit : [271.15 - 272.15] deg K
    ! ==========================================
    ! for temperature = rain_snow_limit + 2 => rainfall
    ! for temperature = rain_snow_limit     => snowfall
    real, parameter :: rain_snow_limit = 271.15 ! polar climate
    ! Europe        :: rain_snow_limit = 272.15 or 273.15

    !grep "mode Greenland over temperate climate" in the MAR code: rain_snow_limit > 272.15 

endmodule marmagic

