import numpy as np
import matplotlib.pyplot as plt

coeffl = {'iso_wat': {'0': 0., '1': 0., '2': 0.},
          'iso_O18': {'0': -2.0667e-3, '1': -0.4156, '2': 1137.},
          'iso_HDO': {'0': 52.612e-3, '1': -76.248, '2': 24844.},
          'iso_O17': {'0': -2.0667e-3, '1': -0.4156, '2': 1137.},
          'iso_HTO': {'0': 0., '1': -103.87, '2': 46480.}}

coeffi = {'iso_wat': {'0': 0., '1': 0., '2': 0.},
          'iso_O18': {'0': -0.028244, '1': 11.839, '2': 0.},
          'iso_HDO': {'0': -0.0934, '1': 0., '2': 16288.},
          'iso_O17': {'0': -0.028244, '1': 11.839, '2': 0.},
          'iso_HTO': {'0': 0., '1': -103.87, '2': 46480.}}

ttm = np.linspace(273.15-40, 273.15, 100)
ttp = np.linspace(273.15, 273.15+100, 100)

alphai_m, alphal_p  = {}, {}
for wiso in list(coeffl):
    alphai_m[wiso] = np.exp(coeffi[wiso]['2'] / (ttm**2) + coeffi[wiso]['1'] / ttm + coeffi[wiso]['0'])
    alphal_p[wiso] = np.exp(coeffl[wiso]['2'] / (ttp**2) + coeffl[wiso]['1'] / ttp + coeffl[wiso]['0'])

plt.clf()
wiso = 'iso_O18'
for wiso in ['iso_O18', 'iso_HDO']:
    plt.figure()
    plt.plot(ttm, alphai_m[wiso])
    plt.plot(ttp, alphal_p[wiso])
    plt.title(wiso)

plt.close('all')
for wiso in list(coeffl):
    plt.figure()
    plt.plot(ttm, alphai_m[wiso])
    plt.plot(ttp, alphal_p[wiso])
    plt.title(wiso)
