subroutine mariso_create_file
    ! create a netcdf and fill it will isotopic variables
    use mardim, only: mx, my, mz
    use margrd, only: xxkm, yykm, sigma
    use mariso, only: niso, lab_iso
    use libUN_mod
    implicit none

    ! local
    character * 100 fileout
    logical file_exists
    ! ndim : number of defined dimensions (without time)
    integer, parameter :: ndim = 3
    ! dim_lenght : length of each dimension
    integer dim_lenght(0:ndim)
    ! dim_lmax : maximum length for all dims: recorded Time Steps
    ! and also maximum of spatial grid points for each direction.
    integer, parameter :: dim_lmax = 2000
    ! Llnam, Lnam, Luni : Length of char strings
    integer, parameter :: Lnam = 13
    integer, parameter :: Luni = 30
    integer, parameter :: Llnam = 50
    ! dim_name : name of each dimension
    character*(Lnam) :: dim_name(0:ndim)
    ! dim_units : units of each dimension
    character*(Luni) :: dim_units(0:ndim)
    ! dim_values : values of dimension vectors
    real :: dim_values(dim_lmax, 0:ndim)
    ! nvar_max : Maximum Number of Variables
    integer, parameter :: nvar_max = 36
    ! nvar : total number of variables writen in the NetCDF file
    integer :: nvar
    ! var_name : variable name
    character*(Lnam) :: var_name(nvar_max)
    ! var_dimnames : dimension names of the variable
    character*(Lnam) :: var_dimnames(4, nvar_max)
    ! var_units : variable unit
    character*(Luni) :: var_units(nvar_max)
    ! var_longname : variable long name
    character*(Llnam) :: var_longname(nvar_max)
    ! NattNC_ice : number of real attributes given to all variables
    integer, parameter :: NattNC_ice = 1
    ! att_name : name of attribute
    character*12, parameter :: att_name(1) = (/'actual_range'/)
    ! att_ndim : "actual_range" is (min, max) of all data for each variable
    integer, parameter :: att_ndim(1) = (/2/)

    integer i, j, k, wiso, file_id

    fileout = 'ISO_check.nc'

    ! initialisation
    ! ==============
    file_id = -1 ! NetCDF File is not open

    ! define dimensions
    ! =================
    ! time
    dim_lenght(0) = 0
    dim_name(0) = 'time'
    dim_units(0) = 'number of increment since start of run'
    ! x dimension
    dim_lenght(1) = mx
    dim_name(1) = 'x'
    dim_units(1) = 'km'
    do i = 1, mx
        dim_values(i, 1) = xxkm(i)
    enddo
    ! y dimension
    dim_lenght(2) = my
    dim_name(2) = 'y'
    dim_units(2) = 'km'
    do j = 1, my
        dim_values(j, 2) = yykm(j)
    enddo
    ! z dimension
    dim_lenght(3) = mz
    dim_name(3) = 'sigma'
    dim_units(3) = '-'
    do k = 1, mz
        dim_values(k, 3) = sigma(k)
    enddo

    ! define variables
    ! ================
    nvar = 0
    ! qvDY
    nvar = nvar + 1
    var_name(nvar) = 'qvDY'
    var_longname(nvar) = 'specific humidity'
    var_dimnames(:, nvar) = [character(len=nvar_max) :: 'x', 'y', 'sigma', 'time']
    var_units(nvar) = 'kg kg-1'
    do wiso = 1, niso
        nvar = nvar + 1
        var_name(nvar) = 'qvDY_'//lab_iso(wiso)
        var_longname(nvar) = lab_iso(wiso)//' specific humidity'
        var_dimnames(:, nvar) = [character(len=nvar_max) :: 'x', 'y', 'sigma', 'time']
        var_units(nvar) = 'kg kg-1'
    enddo
    ! qiHY
    nvar = nvar + 1
    var_name(nvar) = 'qiHY'
    var_longname(nvar) = 'cloud ice'
    var_dimnames(:, nvar) = [character(len=nvar_max) :: 'x', 'y', 'sigma', 'time']
    var_units(nvar) = 'kg kg-1'
    do wiso = 1, niso
        nvar = nvar + 1
        var_name(nvar) = 'qiHY_'//lab_iso(wiso)
        var_longname(nvar) = lab_iso(wiso)//' cloud ice'
        var_dimnames(:, nvar) = [character(len=nvar_max) :: 'x', 'y', 'sigma', 'time']
        var_units(nvar) = 'kg kg-1'
    enddo
    ! qsHY
    nvar = nvar + 1
    var_name(nvar) = 'qsHY'
    var_longname(nvar) = 'precipitation ice'
    var_dimnames(:, nvar) = [character(len=nvar_max) :: 'x', 'y', 'sigma', 'time']
    var_units(nvar) = 'kg kg-1'
    do wiso = 1, niso
        nvar = nvar + 1
        var_name(nvar) = 'qsHY_'//lab_iso(wiso)
        var_longname(nvar) = lab_iso(wiso)//' precipitation ice'
        var_dimnames(:, nvar) = [character(len=nvar_max) :: 'x', 'y', 'sigma', 'time']
        var_units(nvar) = 'kg kg-1'
    enddo
    ! qwHY
    nvar = nvar + 1
    var_name(nvar) = 'qwHY'
    var_longname(nvar) = 'cloud liquid'
    var_dimnames(:, nvar) = [character(len=nvar_max) :: 'x', 'y', 'sigma', 'time']
    var_units(nvar) = 'kg kg-1'
    do wiso = 1, niso
        nvar = nvar + 1
        var_name(nvar) = 'qwHY_'//lab_iso(wiso)
        var_longname(nvar) = lab_iso(wiso)//' cloud liquid'
        var_dimnames(:, nvar) = [character(len=nvar_max) :: 'x', 'y', 'sigma', 'time']
        var_units(nvar) = 'kg kg-1'
    enddo
    ! qrHY
    nvar = nvar + 1
    var_name(nvar) = 'qrHY'
    var_longname(nvar) = 'precipitation liquid'
    var_dimnames(:, nvar) = [character(len=nvar_max) :: 'x', 'y', 'sigma', 'time']
    var_units(nvar) = 'kg kg-1'
    do wiso = 1, niso
        nvar = nvar + 1
        var_name(nvar) = 'qrHY_'//lab_iso(wiso)
        var_longname(nvar) = lab_iso(wiso)//' precipitation liquid'
        var_dimnames(:, nvar) = [character(len=nvar_max) :: 'x', 'y', 'sigma', 'time']
        var_units(nvar) = 'kg kg-1'
    enddo
    ! qvapSL
    nvar = nvar + 1
    var_name(nvar) = 'qvapSL'
    var_longname(nvar) = 'surface specific humidity'
    var_dimnames(:, nvar) = [character(len=nvar_max) :: 'x', 'y', '-', 'time']
    var_units(nvar) = 'kg kg-1'
    do wiso = 1, niso
        nvar = nvar + 1
        var_name(nvar) = 'qvapSL_'//lab_iso(wiso)
        var_longname(nvar) = lab_iso(wiso)//' surface specific humidity'
        var_dimnames(:, nvar) = [character(len=nvar_max) :: 'x', 'y', '-', 'time']
        var_units(nvar) = 'kg kg-1'
    enddo
    ! tmp1 var
    do wiso = 1, niso
        nvar = nvar + 1
        var_name(nvar) = 'tmp1_'//lab_iso(wiso)
        var_longname(nvar) = lab_iso(wiso)//' tmp1'
        var_dimnames(:, nvar) = [character(len=nvar_max) :: 'x', 'y', 'sigma', 'time']
        var_units(nvar) = '-'
    enddo
    ! tmp2 var
    do wiso = 1, niso
        nvar = nvar + 1
        var_name(nvar) = 'tmp2_'//lab_iso(wiso)
        var_longname(nvar) = lab_iso(wiso)//' tmp2'
        var_dimnames(:, nvar) = [character(len=nvar_max) :: 'x', 'y', 'sigma', 'time']
        var_units(nvar) = '-'
    enddo

    call UNscreate(fileout, 'output file to check water isotopes', &
                   ndim, dim_lenght, dim_lmax, dim_name, dim_units, dim_values, &
                   nvar_max, nvar, var_name, var_dimnames, var_units, var_longname, &
                   1, att_name, att_ndim, file_id)

    call UNclose(file_id)

endsubroutine mariso_create_file

subroutine mariso_write_file(iso_time, iso_label)
    use mardim, only: mx, my, mz
    use mar_dy, only: qvDY
    use mar_hy, only: qiHY, qsHY, qwHY, qrHY
    use mar_sl, only: qvapSL
    use mariso, only: niso, lab_iso, qvDY_iso, qvapSL_iso, qiHY_iso, qsHY_iso, qwHY_iso, qrHY_iso
    use libUN_mod
    implicit none
    ! iso_label : label of the increment
    character*10, intent(in) :: iso_label
    ! iso_time : number of the increment
    integer, intent(in) :: iso_time
    ! local
    integer file_id, wiso

    ! open file
    call UNwopen('ISO_check.nc', file_id)
    ! write time increment
    call UNwrite(file_id, 'time', iso_time, 1, 1, 1, iso_time)
    ! write isotopic variables
    ! qvDY
    call UNwrite(file_id, 'qvDY', iso_time, mx, my, mz, qvDY)
    do wiso = 1, niso
        call UNwrite(file_id, 'qvDY_'//lab_iso(wiso), iso_time, mx, my, mz, qvDY_iso(wiso, :, :, :))
    enddo
    ! qiHY
    call UNwrite(file_id, 'qiHY', iso_time, mx, my, mz, qiHY)
    do wiso = 1, niso
        call UNwrite(file_id, 'qiHY_'//lab_iso(wiso), iso_time, mx, my, mz, qiHY_iso(wiso, :, :, :))
    enddo
    ! qsHY
    call UNwrite(file_id, 'qsHY', iso_time, mx, my, mz, qsHY)
    do wiso = 1, niso
        call UNwrite(file_id, 'qsHY_'//lab_iso(wiso), iso_time, mx, my, mz, qsHY_iso(wiso, :, :, :))
    enddo
    ! qwHY
    call UNwrite(file_id, 'qwHY', iso_time, mx, my, mz, qwHY)
    do wiso = 1, niso
        call UNwrite(file_id, 'qwHY_'//lab_iso(wiso), iso_time, mx, my, mz, qwHY_iso(wiso, :, :, :))
    enddo
    ! qrHY
    call UNwrite(file_id, 'qrHY', iso_time, mx, my, mz, qrHY)
    do wiso = 1, niso
        call UNwrite(file_id, 'qrHY_'//lab_iso(wiso), iso_time, mx, my, mz, qrHY_iso(wiso, :, :, :))
    enddo
    ! qvapSL
    call UNwrite(file_id, 'qvapSL', iso_time, mx, my, 1, qvapSL)
    do wiso = 1, niso
        call UNwrite(file_id, 'qvapSL_'//lab_iso(wiso), iso_time, mx, my, 1, qvapSL_iso(wiso, :, :))
    enddo
    ! close file
    call UNclose(file_id)

    ! write increment and label
    open(unit=222, file='iso_label.txt', action='write', position='append')
    write(222, '(i10, A4, A10)') iso_time, ' :: ', iso_label
    close(unit=222)

endsubroutine mariso_write_file

subroutine mariso_write_var3d(var3d_iso, var_name, iso_time)
    use mardim, only: mx, my, mz
    use mar_dy, only: qvDY
    use mar_hy, only: qiHY, qsHY, qwHY, qrHY
    use mar_sl, only: qvapSL
    use mariso, only: niso, lab_iso
    use libUN_mod
    implicit none
    ! var3d : 3d variable to be writen
    real, intent(in) :: var3d_iso(niso, mx, my, mz)
    ! var_name : variable name
    character*4, intent(in) :: var_name
    ! iso_time : number of the increment
    integer, intent(in) :: iso_time
    ! local
    integer wiso, file_id

    ! open file
    call UNwopen('ISO_check.nc', file_id)
    ! write time increment
    call UNwrite(file_id, 'time', iso_time, 1, 1, 1, iso_time)
    ! write 3d variables
    do wiso = 1, niso
        call UNwrite(file_id, var_name//'_'//lab_iso(wiso), iso_time, mx, my, mz, var3d_iso(wiso, :, :, :))
    enddo
    ! close file
    call UNclose(file_id)
endsubroutine mariso_write_var3d
