! Created by Cécile Agosta on 04/03/2021.
! initialization routines for mariso

subroutine mariso_init_sno(iso_init_type, rosSNo, wasSNo, SWaSNo, rosSNo_iso, wasSNo_iso, SWaSNo_iso)
    ! isotopic initialization of sivat snowpack
    ! iso_init_type = 0 : R = Rdefault
    ! iso_init_type = 1 : R from observed delta
    use mardim, only: mx, my, mz
    use marssn, only: nsx
    use mar_sv, only: nsno
    use mariso, only: niso, Rdefault
    implicit none
    ! inputs
    integer, intent(in) :: iso_init_type
    real, intent(in) :: rosSNo(mx, my, nsx, nsno)
    real, intent(in) :: wasSNo(mx, my, nsx, nsno)
    real, intent(in) :: SWaSNo(mx, my, nsx)
    ! outputs
    real, intent(out) :: rosSNo_iso(niso, mx, my, nsx, nsno)
    real, intent(out) :: wasSNo_iso(niso, mx, my, nsx, nsno)
    real, intent(out) :: SWaSNo_iso(niso, mx, my, nsx)
    ! local
    integer wiso, i, j, k, n

    ! isotopic initialization of sivat snowpack
    if(iso_init_type == 0) then
        ! iso_init_type = 0 : R = Rdefault
        ! ================================
        do n = 1, nsno
            do k = 1, nsx
                do j = 1, my
                    do i = 1, mx
                        do wiso = 1, niso
                            rosSNo_iso(wiso, i, j, k, n) = Rdefault(wiso) * rosSNo(i, j, k, n)
                            wasSNo_iso(wiso, i, j, k, n) = Rdefault(wiso) * wasSNo(i, j, k, n)
                        enddo
                    enddo
                enddo
            enddo
        enddo
        do k = 1, nsx
            do j = 1, my
                do i = 1, mx
                    do wiso = 1, niso
                        SWaSNo_iso(wiso, i, j, k) = Rdefault(wiso) * SWaSNo(i, j, k)
                    enddo
                enddo
            enddo
        enddo

    else if(iso_init_type == 1) then
        ! TODO : add realistic initialization
        ! iso_init_type = 1 : R from observed delta
        ! =========================================
        ! rosSNo_iso : Snow Volumic Mass kg/m3][
        ! delta in per mil as a function of temperature
        ! for Antarctica : Masson-Delmotte et al. 2008 https://dx.doi.org/10.1175/2007jcli2139.1 (Fig. 6)
        ! delta_iso(iso18) =
        ! delta_iso(isoD) =
        ! R_iso(iso) = delta_iso(iso)
        ! rosSNo_iso(i, j, n, k, iso) = R_iso(iso) * rosSNo(i, j, n, k)
    else
        write(6, *) "mariso ERROR: iso_init_type must be 0 or 1"
        stop
    endif

endsubroutine mariso_init_sno

subroutine mariso_init_tv(iso_init_type, eta_TV, eta_TV_iso)
    ! isotopic initialization of sivat soil
    ! iso_init_type = 0 : R = Rdefault
    ! iso_init_type = 1 : R from observed delta
    use mar_tv, only: imx, jmx, nvx, llx
    use mariso, only: niso, Rdefault
    implicit none
    ! inputs
    integer, intent(in) :: iso_init_type
    real, intent(in) :: eta_TV(imx, jmx, nvx, llx)
    ! outputs
    real, intent(out) :: eta_TV_iso(niso, imx, jmx, nvx, llx)
    ! local
    integer wiso, i, j, k, n

    ! isotopic initialization of sivat snowpack
    if(iso_init_type == 0) then
        ! iso_init_type = 0 : R = Rdefault
        ! ================================
        do n = 1, llx
            do k = 1, nvx
                do j = 1, jmx
                    do i = 1, imx
                        do wiso = 1, niso
                            eta_TV_iso(wiso, i, j, k, n) = Rdefault(wiso) * eta_TV(i, j, k, n)
                        enddo
                    enddo
                enddo
            enddo
        enddo
    else if(iso_init_type == 1) then
        ! TODO : add realistic initialization
        ! iso_init_type = 1 : R from observed delta
        ! =========================================
        ! rosSNo_iso : Snow Volumic Mass kg/m3][
        ! delta in per mil as a function of temperature
        ! for Antarctica : Masson-Delmotte et al. 2008 https://dx.doi.org/10.1175/2007jcli2139.1 (Fig. 6)
        ! delta_iso(iso18) =
        ! delta_iso(isoD) =
        ! R_iso(iso) = delta_iso(iso)
        ! rosSNo_iso(i, j, n, k, iso) = R_iso(iso) * rosSNo(i, j, n, k)
    else
        write(6, *) "mariso ERROR: iso_init_type must be 0 or 1"
        stop
    endif

endsubroutine mariso_init_tv

subroutine mariso_init_sl(iso_init_type, qvapSL, qvapSL_iso)
    ! isotopic initialization of sivat soil
    ! iso_init_type = 0 : R = Rdefault
    ! iso_init_type = 1 : R from observed delta
    use mardim, only: mx, my
    use mariso, only: niso, Rdefault
    implicit none
    ! inputs
    integer, intent(in) :: iso_init_type
    real, intent(in) :: qvapSL(mx, my)
    ! outputs
    real, intent(out) :: qvapSL_iso(niso, mx, my)
    ! local
    integer wiso, i, j

    ! isotopic initialization of sivat snowpack
    if(iso_init_type == 0) then
        ! iso_init_type = 0 : R = Rdefault
        ! ================================
        do j = 1, my
            do i = 1, mx
                do wiso = 1, niso
                    qvapSL_iso(wiso, i, j) = Rdefault(wiso) * qvapSL(i, j)
                enddo
            enddo
        enddo
    else if(iso_init_type == 1) then
        ! TODO : add realistic initialization
        ! iso_init_type = 1 : R from observed delta
        ! =========================================
        ! rosSNo_iso : Snow Volumic Mass kg/m3][
        ! delta in per mil as a function of temperature
        ! for Antarctica : Masson-Delmotte et al. 2008 https://dx.doi.org/10.1175/2007jcli2139.1 (Fig. 6)
        ! delta_iso(iso18) =
        ! delta_iso(isoD) =
        ! R_iso(iso) = delta_iso(iso)
        ! rosSNo_iso(i, j, n, k, iso) = R_iso(iso) * rosSNo(i, j, n, k)
    else
        write(6, *) "mariso ERROR: iso_init_type must be 0 or 1"
        stop
    endif

endsubroutine mariso_init_sl

subroutine mariso_init_dy(iso_init_type, qvDY, qvDY_iso)
    ! isotopic initialization of sivat soil
    ! iso_init_type = 0 : R = Rdefault
    ! iso_init_type = 1 : R from observed delta
    use mardim, only: mx, my, mz
    use mariso, only: niso, Rdefault
    implicit none
    ! inputs
    integer, intent(in) :: iso_init_type
    real, intent(in) :: qvDY(mx, my, mz)
    ! outputs
    real, intent(out) :: qvDY_iso(niso, mx, my, mz)
    ! local
    integer wiso, i, j, k

    ! isotopic initialization of sivat snowpack
    if(iso_init_type == 0) then
        ! iso_init_type = 0 : R = Rdefault
        ! ================================
        do k = 1, mz
            do j = 1, my
                do i = 1, mx
                    do wiso = 1, niso
                        qvDY_iso(wiso, i, j, k) = Rdefault(wiso) * qvDY(i, j, k)
                    enddo
                enddo
            enddo
        enddo
    else if(iso_init_type == 1) then
        ! TODO : add realistic initialization
        ! iso_init_type = 1 : R from observed delta
        ! =========================================
        ! rosSNo_iso : Snow Volumic Mass kg/m3][
        ! delta in per mil as a function of temperature
        ! for Antarctica : Masson-Delmotte et al. 2008 https://dx.doi.org/10.1175/2007jcli2139.1 (Fig. 6)
        ! delta_iso(iso18) =
        ! delta_iso(isoD) =
        ! R_iso(iso) = delta_iso(iso)
        ! rosSNo_iso(i, j, n, k, iso) = R_iso(iso) * rosSNo(i, j, n, k)
    else
        write(6, *) "mariso ERROR: iso_init_type must be 0 or 1"
        stop
    endif

endsubroutine mariso_init_dy
