subroutine MARgz_1mx1my(k1, k2, jj, var3d_1, var3d_2, var3d_3, var3d_4, var3d_out)
    ! +------------------------------------------------------------------------+
    ! | MAR DYNAMICS                                           08-09-2017  MAR |
    ! |   subroutine MARgz_1mx1my performs Gaussian Elimination along s-Dir.   |
    ! |    (e.g. Pielke (1984), pp.302--303)                                   |
    ! |    (needed to solve the implicit scheme developped for filtering)      |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT: k1,k2: k Loops Limits                                         |
    ! |   ^^^^^                                                                |
    ! +------------------------------------------------------------------------+
    use marphy
    use mardim
    use margrd
    use mar_wk
    implicit none
    ! input
    integer, intent(in) :: k1, k2, jj
    real, intent(in) :: var3d_1(mx, my, mz)
    real, intent(in) :: var3d_2(mx, my, mz)
    real, intent(in) :: var3d_3(mx, my, mz)
    real, intent(in) :: var3d_4(mx, my, mz)
    ! output
    real, intent(out) :: var3d_out(mx, my, mz)
    ! local
    real :: var2d_tmp1(mx, mz)
    real :: var2d_tmp2(mx, mz)
    integer ii, kk

    ! +--Forward  Sweep
    ! +  ==============

    ! do j=1,my
    do ii = 1, mx
        var2d_tmp1(ii, k1) = var3d_2(ii, jj, k1)
        var2d_tmp2(ii, k1) = -var3d_1(ii, jj, k1) / var2d_tmp1(ii, k1)
    enddo
    ! end do
    do kk = kp1(k1), k2
        ! do j=1,my
        do ii = 1, mx
            var2d_tmp1(ii, kk) = var3d_3(ii, jj, kk) * var2d_tmp2(ii, kk - 1) &
                                 + var3d_2(ii, jj, kk)
            var2d_tmp2(ii, kk) = -var3d_1(ii, jj, kk) / var2d_tmp1(ii, kk)
        enddo
        ! end do
    enddo
    ! do j=1,my
    do ii = 1, mx
        var3d_out(ii, jj, k1) = var3d_4(ii, jj, k1) / var2d_tmp1(ii, k1)
    enddo
    ! end do
    do kk = kp1(k1), k2
        ! do j=1,my
        do ii = 1, mx
            var3d_out(ii, jj, kk) = (var3d_4(ii, jj, kk) - var3d_3(ii, jj, kk) &
                                     * var3d_out(ii, jj, kk - 1)) / var2d_tmp1(ii, kk)
        enddo
        ! end do
    enddo

    ! +--Backward Sweep
    ! +  ==============

    do kk = km1(k2), k1, -1
        ! do j=1,my
        do ii = 1, mx
            var3d_out(ii, jj, kk) = var2d_tmp2(ii, kk) * var3d_out(ii, jj, kk + 1) &
                                    + var3d_out(ii, jj, kk)
        enddo
        ! end do
    enddo

    return
endsubroutine MARgz_1mx1my

subroutine MARgz_2mx1y1_mp(kk1, kk2, jj, var3d_1, var3d_2, var3d_3, var3d_4, var3d_out)
    ! +------------------------------------------------------------------------+
    ! | MAR DYNAMICS                                           03-07-2004  MAR |
    ! |   subroutine MARgz_2mx1y1 performs Gaussian Elimination along s-Dir.   |
    ! |    (e.g. Pielke (1984), pp.302--303)                                   |
    ! |    (needed to solve the implicit scheme developped for filtering)      |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT:                      k1,k2: k Loops Limits                    |
    ! |   ^^^^^                                                                |
    ! +------------------------------------------------------------------------+
    use marphy
    use mardim
    use margrd
    implicit none
    ! inputs
    integer, intent(in) :: kk1, kk2, jj
    real, intent(in) :: var3d_1(mx, my, mz)
    real, intent(in) :: var3d_2(mx, my, mz)
    real, intent(in) :: var3d_3(mx, my, mz)
    real, intent(in) :: var3d_4(mx, my, mz)
    ! outputs
    real, intent(out) :: var3d_out(mx, my, mz)
    ! local
    real :: var2d_tmp1(mx, mz)
    real :: var2d_tmp2(mx, mz)
    integer :: ii, kk

    ! +--Forward  Sweep
    ! +  ==============

    ! do jj=jjp11,my1
    do ii = ip11, mx1
        var2d_tmp1(ii, kk1) = var3d_2(ii, jj, kk1)
        var2d_tmp2(ii, kk1) = -var3d_1(ii, jj, kk1) / var2d_tmp1(ii, kk1)
    enddo
    ! end do
    do kk = kp1(kk1), kk2
        ! do jj=jjp11,my1
        do ii = ip11, mx1
            var2d_tmp1(ii, kk) = var3d_3(ii, jj, kk) * var2d_tmp2(ii, kk - 1) + var3d_2(ii, jj, kk)
            var2d_tmp2(ii, kk) = -var3d_1(ii, jj, kk) / var2d_tmp1(ii, kk)
        enddo
        ! end do
    enddo
    ! do jj=jjp11,my1
    do ii = ip11, mx1
        var3d_out(ii, jj, kk1) = var3d_4(ii, jj, kk1) / var2d_tmp1(ii, kk1)
    enddo
    ! end do
    do kk = kp1(kk1), kk2
        ! do jj=jjp11,my1
        do ii = ip11, mx1
            var3d_out(ii, jj, kk) = (var3d_4(ii, jj, kk) - &
                                     var3d_3(ii, jj, kk) * var3d_out(ii, jj, kk - 1)) / var2d_tmp1(ii, kk)
        enddo
        ! end do
    enddo

    ! +--Backward Sweep
    ! +  ==============
    do kk = km1(kk2), kk1, -1
        ! do jj=jjp11,my1
        do ii = ip11, mx1
            var3d_out(ii, jj, kk) = var2d_tmp2(ii, kk) * var3d_out(ii, jj, kk + 1) + var3d_out(ii, jj, kk)
        enddo
    enddo
    ! end do

    return
endsubroutine MARgz_2mx1y1_mp
