! margrd: mar grid
! ================
module margrd
    use mardim
    implicit none
    ! dt    : Time Step for Slow Dynamics (s)
    real, save :: dt
    ! dt_Loc: Time Step (dummy) (s)
    real, save :: dt_Loc
    ! dtquil: Time Step for 1-D Initialisation (s)
    real, save :: dtquil
    ! tequil: Time Span for 1-D Initialisation (s)
    real, save :: tequil
    ! dtfast: Time Step for Fast Dynamics (s)
    real, save :: dtfast
    ! dtAdvH: Time Step for Tracer  Advection (s)
    real, save :: dtAdvH
    ! dtDiff: Time Step for Subgrid Scale Processes (s)
    real, save :: dtDiff
    real, save :: dtPhys
    real, save :: dtRadi
    real, save :: dthyd
    ! idt   : Time Step for Slow Dynamics (s)
    integer, save :: idt
    integer, save :: jdt
    ! ntFast: Nb Fast Dyn.Tim.Steps for one Mix  Dyn.Tim.Step
    integer, save :: ntFast
    ! nt_Mix: Nb Mix  Dyn.Tim.Steps for one Slow Dyn.Tim.Step
    integer, save :: nt_Mix
    ! ntAdvH: Nb Trac.Adv.Tim.Steps for one Slow Dyn.Tim.Step
    integer, save :: ntAdvH
    ! ntDiff: Nb Turbul.  Tim.Steps for one Slow Dyn.Tim.Step
    integer, save :: ntDiff
    ! ntPhys: Nb Srf.Phys.Tim.Steps for one Slow Dyn.Tim.Step
    integer, save :: ntPhys
    ! ntRadi: Nb Rad.Phys.Tim.Steps for one Slow Dyn.Tim.Step
    integer, save :: ntRadi
    integer, save :: nthyd
    ! itFast: No Fast Dyn.Tim.Step
    integer, save :: itFast
    ! it_Mix: No Mix  Dyn.Tim.Step
    integer, save :: it_Mix
    ! jtAdvH: Nb Slow Dyn.Tim.Steps for one Trac.Adv.Tim.Step
    integer, save :: jtAdvH
    ! jtDiff: Nb Slow Dyn.Tim.Steps for one Turbul.  Tim.Step
    integer, save :: jtDiff
    ! jtPhys: Nb Slow Dyn.Tim.Steps for one Srf.Phys.Tim.Step
    integer, save :: jtPhys
    ! jtRadi: Nb Slow Dyn.Tim.Steps for one Rad.Phys.Tim.Step
    integer, save :: jtRadi
    integer, save :: jtRadi2
    ! kssMAR: Nb of simul. %  Second
    integer, save :: kssMAR
    ! jdplus: Day   Offset
    integer, save :: jdplus
    ! mmplus: Month Offset
    integer, save :: mmplus
    ! jdaMAR: Nb of simulated Days
    integer(kind=8), save :: jdaMAR
    ! jhaMAR: Nb of simulated Hours   in Day    jdaMAR+1
    integer(kind=8), save :: jhaMAR
    ! jmmMAR: Nb of simulated Minutes in Hour   jhaMAR+1
    integer(kind=8), save :: jmmMAR
    ! jssMAR: Nb of simulated Seconds in Minute jmmMAR+1
    integer(kind=8), save :: jssMAR
    integer(kind=8), save :: jhaRUN
    integer(kind=8), save :: dt_new
    integer(kind=8), save :: dt_old
    ! center: Pressure Spatial Scheme centered or not
    logical, save :: center
    ! tsplit: Advection Time Scheme splitted or not
    logical, save :: tsplit
    ! staggr: Vertical Grid staggered or not
    logical, save :: staggr
    ! nordps: Pressure Spatial Scheme Precision (-1 or 4)
    integer, save :: nordps
    ! norhyd: Advection H2O  Spatial Scheme Precision (-1 or 4)
    integer, save :: norhyd
    ! nortra: Advection Trac.Spatial Scheme Precision (-1 or 4)
    integer, save :: nortra
    ! fac43 =  4.d0 / 3.d0 (used in 4th order horizontal difference scheme)
    real, save :: fac43
    ! rxy =  1.d-3/(mx*my)
    real, save :: rxy
    ! dx : horizontal grid size (x direction)
    real, save :: dx
    ! dx2 = 2 dx
    real, save :: dx2
    ! dtx = dt / dx
    real, save :: dtx
    ! dxinv = 1 / dx
    real, save :: dxinv
    ! dxinv2 = 1 / (2 dx)
    real, save :: dxinv2
    ! dx3 dy3 : distance between lon / lat
    real, save :: dx3(mx, my), dy3(mx, my)
    ! dxy3 = (dx3 + dy3) / 2.
    real, save :: dxy3(mx, my)
    ! dxinv3 = 1. / (2 dx3)
    ! dyinv3 = 1. / (2 dy3)
    real, save :: dxinv3(mx, my), dyinv3(mx, my)
    ! mez   : origin grid point number (x direction)
    integer, save :: imez
    integer, save :: m1, m2, m3, m4
    ! im1,2 : max(i-1, 1), max(i-2, 1), etc...
    ! ip1,2 : min(i+1,mx), min(i+2,mx), etc...
    integer, save :: im1(mx), ip1(mx), im2(mx), ip2(mx)
    integer, save :: im3(mx), ip3(mx), im4(mx), ip4(mx)
    integer, save :: mmx, mmx1, mmx2, mmx3, mmx4, mmx5, mmx6
    integer, save :: m0x1, m0x2, m0x3, m0x4, m0x5, m0x6
    ! dy : horizontal grid size (y direction)
    real, save :: dy
    ! dy2 = 2 dy
    real, save :: dy2
    ! dty = dt / dy
    real, save :: dty
    ! dyinv = 1  / dy
    real, save :: dyinv
    ! dyinv2 = 2  / dy
    real, save :: dyinv2
    ! jmez  : origin grid point number (y direction)
    integer, save :: jmez
    integer, save :: mn, mn1, mn2, mn3, mn4
    ! jm1,2 : max(j-1, 1), max(j-2, 1), etc...
    ! jp1,2 : min(j+1,my), min(j+2,my), etc...
    integer, save :: jm1(my), jp1(my), jm2(my), jp2(my)
    integer, save :: jm3(my), jp3(my), jm4(my), jp4(my)
    integer, save :: mmy, mmy1, mmy2, mmy3, mmy4, mmy5, mmy6
    integer, save :: m0y1, m0y2, m0y3, m0y4, m0y5, m0y6
    integer, save :: mmz, mmz1, mmz2
    integer, save :: km1(mz), kp1(mz), km2(mz)
    ! THE VERTICAL DISCRETIZATION IS DEFINED in subroutine iniver and auxgri
    ! sigma : independant variable sigma on sigma levels (k)
    real, save :: sigma(mz)
    ! dsig_1 :      difference ds(k+1/2)
    real, save :: dsig_1(0:mzz)
    ! qsig_1 : 1 / [difference ds(k+1/2) X 2]
    real, save :: qsig_1(0:mzz)
    ! dsig_2 :      difference ds(k+1/2) X 2
    real, save :: dsig_2(mzz)
    ! sigmid : independant variable sigma between  levels (k-1/2)
    real, save :: sigmid(mzz)
    ! dsigm1 : difference ds(k)
    real, save :: dsigm1(mz)
    ! qsigm1 : 1 / [difference ds(k)]
    real, save :: qsigm1(mz)
    ! dsigm2 : difference ds(k) X 2
    real, save :: dsigm2(mz)
    ! qsigm2 : 1 / [difference ds(k) X 2]
    real, save :: qsigm2(mz)
    ! zsigma : height of sigma levels
    real, save :: zsigma(mz)
    real, save :: z__SBL
    ! xxkm : distance to the x axis origin (km)
    !        this is generally taken as the coast
    !        when studying land-sea interactions
    real, save :: xxkm(mx)
    ! yykm : distance to the y axis origin (km)
    real, save :: yykm(my)
    real, save :: xxkm2(mx), yykm2(my)
    ! area : area of each grid cell
    real, save :: area(mx, my)
    ! sh : surface height (m)
    real, save :: sh(mx, my)
endmodule margrd
