subroutine MARgau_x(i1, i2, j1, j2, k1, k2)

    ! +------------------------------------------------------------------------+
    ! | MAR DYNAMICS                                           17-12-2000  MAR |
    ! |   subroutine MARgau_x performs Gaussian Elimination Algorithm along x  |
    ! |    (e.g. Pielke (1984), pp.302--303)                                   |
    ! |    (needed to solve the implicit scheme developped for filtering)      |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT:              i1,i2,j1,j2,k1,k2: i,j,k Loops Limits            |
    ! |   ^^^^^                                                                |
    ! +------------------------------------------------------------------------+

    use marphy
    use mardim
    use margrd
    use mar_wk

    implicit none

    integer i, j, k, m
    integer i1, i2, j1, j2, k1, k2, ix

    data ix/0/

    ! +--Forward  Sweep
    ! +  ==============

    if(ix /= 1) then
        do k = k1, k2
            do j = j1, j2
                WKxyz5(i1, j, k) = WKxyz2(i1, j, k)
                WKxyz6(i1, j, k) = -WKxyz1(i1, j, k) / WKxyz5(i1, j, k)
            enddo
        enddo
        do i = ip1(i1), i2
            do k = k1, k2
                do j = j1, j2
                    WKxyz5(i, j, k) = WKxyz3(i, j, k) * WKxyz6(i - 1, j, k) + WKxyz2(i, j, k)
                    WKxyz6(i, j, k) = -WKxyz1(i, j, k) / WKxyz5(i, j, k)
                enddo
            enddo
        enddo
    endif

    do k = k1, k2
        do j = j1, j2
            WKxyz7(i1, j, k) = WKxyz4(i1, j, k) / WKxyz5(i1, j, k)
        enddo
    enddo

    do i = ip1(i1), i2
        do k = k1, k2
            do j = j1, j2
                WKxyz7(i, j, k) = (WKxyz4(i, j, k) - WKxyz3(i, j, k) * WKxyz7(i - 1, j, k)) &
                                  / WKxyz5(i, j, k)
            enddo
        enddo
    enddo

    ! +--Backward Sweep
    ! +  ==============

    do i = im1(i2), i1, -1
        do k = k1, k2
            do j = j1, j2
                WKxyz7(i, j, k) = WKxyz6(i, j, k) * WKxyz7(i + 1, j, k) + WKxyz7(i, j, k)
            enddo
        enddo
    enddo

    return
endsubroutine MARgau_x

subroutine MARgau_y(i1, i2, j1, j2, k1, k2)

    ! +------------------------------------------------------------------------+
    ! | MAR DYNAMICS                                           17-12-2000  MAR |
    ! |   subroutine MARgau_y performs Gaussian Elimination Algorithm along y  |
    ! |    (e.g. Pielke (1984), pp.302--303)                                   |
    ! |    (needed to solve the implicit scheme developped for filtering)      |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT:              i1,i2,j1,j2,k1,k2: i,j,k Loops Limits            |
    ! |   ^^^^^                                                                |
    ! +------------------------------------------------------------------------+

    use marphy
    use mardim
    use margrd
    use mar_wk

    implicit none

    integer i, j, k, m
    integer i1, i2, j1, j2, k1, k2, ix

    data ix/0/

    ! +--Forward  Sweep
    ! +  ==============

    if(ix /= 1) then
        do k = k1, k2
            do i = i1, i2
                WKxyz5(i, j1, k) = WKxyz2(i, j1, k)
                WKxyz6(i, j1, k) = -WKxyz1(i, j1, k) / WKxyz5(i, j1, k)
            enddo
        enddo
        do j = jp1(j1), j2
            do k = k1, k2
                do i = i1, i2
                    WKxyz5(i, j, k) = WKxyz3(i, j, k) * WKxyz6(i, j - 1, k) + WKxyz2(i, j, k)
                    WKxyz6(i, j, k) = -WKxyz1(i, j, k) / WKxyz5(i, j, k)
                enddo
            enddo
        enddo
    endif

    do k = k1, k2
        do i = i1, i2
            WKxyz7(i, j1, k) = WKxyz4(i, j1, k) / WKxyz5(i, j1, k)
        enddo
    enddo

    do j = jp1(j1), j2
        do k = k1, k2
            do i = i1, i2
                WKxyz7(i, j, k) = (WKxyz4(i, j, k) - WKxyz3(i, j, k) * WKxyz7(i, j - 1, k)) &
                                  / WKxyz5(i, j, k)
            enddo
        enddo
    enddo

    ! +--Backward Sweep
    ! +  ==============

    do j = jm1(j2), j1, -1
        do k = k1, k2
            do i = i1, i2
                WKxyz7(i, j, k) = WKxyz6(i, j, k) * WKxyz7(i, j + 1, k) + WKxyz7(i, j, k)
            enddo
        enddo
    enddo

    return
endsubroutine MARgau_y
