module mardim
    implicit none
    integer, parameter :: mx = 176
    integer, parameter :: my = 148
    integer, parameter :: ip11 = 2
    integer, parameter :: jp11 = 2
    integer, parameter :: mz = 24
    ! mzir1 may be chosen much larger than mz,
    ! if the model vertical domain covers a small part of the air column
    integer, parameter :: mzir1 = mz + 1
    integer, parameter :: mzir = mz + 2
    integer, parameter :: mx1 = 175
    integer, parameter :: mx2 = 174
    integer, parameter :: my1 = 147
    integer, parameter :: my2 = 146
    integer, parameter :: myd2 = 1 + my / 2
    integer, parameter :: mz1 = mz - 1
    integer, parameter :: mzz = mz + 1
    integer, parameter :: i_2 = mx - mx1 + 1
    integer, parameter :: j_2 = my - my1 + 1
    integer, parameter :: mzabso = 9
    integer, parameter :: mzhyd = 4
    ! if #NV removed (NO vectorization) then klon = 1
    integer, parameter :: klon = 1
    integer, parameter :: klev = mz
    integer, parameter :: kdlon = klon
    integer, parameter :: kflev = klev
    ! n6 et n7 determine a relaxation zone towards lateral boundaries
    ! (large scale values of the variables).
    ! This zone extends over n6-1 points.
    ! Davies (1976) propose 5 points (i.e. n6=6 and n7=7)
    integer, parameter :: n6 = 6
    integer, parameter :: n7 = 7
    ! mw is the total number of mosaics
    integer, parameter :: mw = 2
endmodule mardim
