#include "MAR_pp.def"
! marcdp : Col de Porte specific Constants
! ========================================
module marcdp
    implicit none
    ! +--Col de Porte specific Constants
    ! +  ===============================
    ! ColPrt : Col de Porte Switch
#ifdef CP
    logical, parameter :: ColPrt = .true.
#else
    logical, parameter :: ColPrt = .false.
#endif
    ! +--Fractions of total solar irradiances in 3 spectral intervals
    ! +  ------------------------------------------------------------
    !  0.3--0.8micr.m   0.8--1.5micr.m   1.5--2.8micr.m
    ! (see Eric Martin Sept. 1996, CROCUS, subroutine METEO)
    ! Dr_1SN, Dr_2SN, Dr_3SN : Direct  Radiation
    real, parameter :: Dr_1SN = 0.59
    real, parameter :: Dr_2SN = 0.31
    real, parameter :: Dr_3SN = 0.10
    ! Df_1SN, Df_2SN, Df_3SN : Diffuse Radiation, Clear  Sky
    real, parameter :: Df_1SN = 0.95
    real, parameter :: Df_2SN = 0.05
    real, parameter :: Df_3SN = 0.00
    ! Dfc1SN, Dfc2SN, Dfc3SN : Diffuse Radiation, Cloudy Sky
    real, parameter :: Dfc1SN = 0.66
    real, parameter :: Dfc2SN = 0.27
    real, parameter :: Dfc3SN = 0.07
    real, save :: DirSol
    real, save :: DifSol
    real, save :: TotSol
    real, save :: Clouds
endmodule marcdp
