! mar_wk : work variables
! =======================
! wkXXX variables define a work area in order to minimize memory requirements
module mar_wk
    use mardim
    implicit none
    real, save :: WKxyz1(mx, my, mz), WKxyz2(mx, my, mz), &
            WKxyz3(mx, my, mz), WKxyz4(mx, my, mz), &
            WKxyz5(mx, my, mzz), WKxyz6(mx, my, mzz), &
            WKxyz7(mx, my, mzz), WKxyz8(mx, my, mzz)
    real, save :: WRKxys(mx, my, mw)
    real, save :: WKxy1(mx, my), WKxy2(mx, my), WKxy3(mx, my), &
            WKxy4(mx, my), WKxy5(mx, my), WKxy6(mx, my), &
            WKxy7(mx, my), WKxy8(mx, my), WKxy9(mx, my), &
            WKxy0(mx, my)
    real :: WTxy1(mx, my), WTxy2(mx, my), WTxy3(mx, my), &
            WTxy4(mx, my), WTxy5(mx, my), WTxy6(mx, my), &
            WTxy7(mx, my), WTxy8(mx, my), WTxy9(mx, my), &
            WTxy0(mx, my)
    real, save :: WKxza(mx, mz), WKxzb(mx, mz), WKxzc(mx, mz), &
            WKxzd(mx, mz), WKxzx(mx, mz), &
            WKxzp(mx, mz), WKxzq(mx, mz)
    
    real, allocatable :: WPxyz1(:, :, :)
    real, allocatable :: WPxyz2(:, :, :)
    real, allocatable :: WPxyz3(:, :, :)
    real, allocatable :: WPxyz4(:, :, :)
    real, allocatable :: WPxyz5(:, :, :)
    real, allocatable :: WPxyz6(:, :, :)
    real, allocatable :: WPxyz7(:, :, :)
    real, allocatable :: WPxyz8(:, :, :)
    
    real, allocatable :: WTxyz1(:, :, :), WTxyz2(:, :, :), &
            WTxyz3(:, :, :), WTxyz4(:, :, :), &
            WTxyz5(:, :, :), WTxyz6(:, :, :), &
            WTxyz7(:, :, :), WTxyz8(:, :, :)

contains
    
    subroutine mar_wk_init()
        
        use mardim, only : mx, my, mz, mzz
        implicit none
        
        allocate(WPxyz1(mx, my, mz))
        allocate(WPxyz2(mx, my, mz))
        allocate(WPxyz3(mx, my, mz))
        allocate(WPxyz4(mx, my, mz))
        allocate(WPxyz5(mx, my, mzz))
        allocate(WPxyz6(mx, my, mzz))
        allocate(WPxyz7(mx, my, mzz))
        allocate(WPxyz8(mx, my, mzz))
        allocate(WTxyz1(mx, my, mz))
        allocate(WTxyz2(mx, my, mz))
        allocate(WTxyz3(mx, my, mz))
        allocate(WTxyz4(mx, my, mz))
        allocate(WTxyz5(mx, my, mzz))
        allocate(WTxyz6(mx, my, mzz))
        allocate(WTxyz7(mx, my, mzz))
        allocate(WTxyz8(mx, my, mzz))
    
    endsubroutine mar_wk_init

endmodule mar_wk
