! mar_ub : include upper sponge [2-03-2004]
! mar_ub save variables are used to follow Reference State in MAR upper sponge
! Reference: ARPS 4.0 User's Guide, para 6.4.3 p.152
! ==================================================
module mar_ub
    use mardim
    implicit none
    real, save :: Ray_UB(mzabso)
    real, save, allocatable :: uairUB(:, :, :)
    real, save, allocatable :: vairUB(:, :, :)
    real, save, allocatable :: pktaUB(:, :, :)
    real, save, allocatable :: ua1_UB(:, :, :)
    real, save, allocatable :: va1_UB(:, :, :)
    real, save, allocatable :: pkt1UB(:, :, :)
    real, save, allocatable :: ua2_UB(:, :, :)
    real, save, allocatable :: va2_UB(:, :, :)
    real, save, allocatable :: pkt2UB(:, :, :)
    integer, save :: iyr_UB
    integer, save :: mma_UB
    integer, save :: jda_UB
    integer, save :: jhu_UB
    integer, save :: jdh_UB
    integer(kind = 8), save :: tim1UB
    integer(kind = 8), save :: tim2UB

contains
    
    subroutine mar_ub_init()
        
        use mardim, only : mx, my, mzabso
        implicit none
        
        allocate(uairUB(mx, my, mzabso))
        allocate(vairUB(mx, my, mzabso))
        allocate(pktaUB(mx, my, mzabso))
        allocate(ua1_UB(mx, my, mzabso))
        allocate(va1_UB(mx, my, mzabso))
        allocate(pkt1UB(mx, my, mzabso))
        allocate(ua2_UB(mx, my, mzabso))
        allocate(va2_UB(mx, my, mzabso))
        allocate(pkt2UB(mx, my, mzabso))
    
    endsubroutine mar_ub_init

endmodule mar_ub
