! mar_tv : vegetation
! ===================
module mar_tv
    use mardim
    use mar_sv
    implicit none
    integer, parameter :: nvx = mw
    integer, parameter :: llx = nsol + 1
    integer, parameter :: iptx = 5
    integer, parameter :: imx = mx
    integer, parameter :: jmx = my
    ! deptTV: Soil Level Depth
    real, save :: deptTV(0:llx)
    ! dep2TV: Soil Layer Depth
    real, save :: dep2TV(0:llx)
    ! slopTV: Surface Slope
    real, save :: slopTV(mx, my)
    ! AlbSTV: Dry Soil Albedo
    real, save :: AlbSTV(mx, my)
    ! alaiTV: Leaf Area Index
    real, save, allocatable :: alaiTV(:, :, :)
    ! glf_TV: Green Leaf Fraction
    real, save, allocatable :: glf_TV(:, :, :)
    ! CaWaTV: Canopy Intercepted Water Content
    real, save, allocatable :: CaWaTV(:, :, :)
    ! CaSnTV: Canopy Intercepted Snow Content
    real, save, allocatable :: CaSnTV(:, :, :)
    ! TvegTV: Skin Vegetation Temperature
    real, save, allocatable :: TvegTV(:, :, :)
    ! TgrdTV: Skin Soil Temperature
    real, save, allocatable :: TgrdTV(:, :, :)
    ! TsolTV: Layer Soil Temperature
    real, save, allocatable :: TsolTV(:, :, :, :)
    ! eta_TV: Soil Moisture Content
    real, save, allocatable :: eta_TV(:, :, :, :)
    ! psigTV: Soil Hydraulic Potential
    real, save, allocatable :: psigTV(:, :, :)
    ! psivTV: Vegetation Hydraulic Potential
    real, save, allocatable :: psivTV(:, :, :)
    ! evapTV: Time Integrated Evapotranspiration [mm w.e.]
    real, save :: evapTV(imx, jmx)
    ! runoTV: Time Integrated (Sub)surface Flow
    real, save :: runoTV(imx, jmx)
    ! draiTV: Time Integrated Drainage Flow
    real, save :: draiTV(imx, jmx)
    ! iWaFTV=0 ==> no Water Flux; iWaFTV=1 ==> free drainage
    integer, save :: iWaFTV(imx, jmx)
    ! ivegTV: Vegetation Type Index
    integer, save :: ivegTV(imx, jmx, nvx)
    ! isolTV: Soil Type Index
    integer, save :: isolTV(imx, jmx)
    ! ifraTV: Vegetation Class Coverage (3 Class, Last One is Open Water)
    real, save :: ifraTV(imx, jmx, nvx)
    ! IO Grid Indices
    integer, save :: IOi_TV(iptx), IOj_TV(iptx)
    integer, save :: itx, ivg

contains
    
    subroutine mar_tv_init()
        implicit none
        
        allocate(alaiTV(imx, jmx, nvx))
        allocate(glf_TV(imx, jmx, nvx))
        allocate(CaWaTV(imx, jmx, nvx))
        allocate(CaSnTV(imx, jmx, nvx))
        allocate(TvegTV(imx, jmx, nvx))
        allocate(TgrdTV(imx, jmx, nvx))
        allocate(TsolTV(imx, jmx, nvx, llx))
        allocate(eta_TV(imx, jmx, nvx, llx))
        allocate(psigTV(imx, jmx, nvx))
        allocate(psivTV(imx, jmx, nvx))
    
    endsubroutine mar_tv_init

endmodule mar_tv

