! mar_tu :
! =========
module mar_tu
    use mardim
    implicit none
    ! TUkvm : Vertical Diffusion Coefficient (Momentum) [m2/s]
    real, save, allocatable :: TUkvm(:, :, :)
    ! TUkvh : Vertical Diffusion Coefficient (Heat) [m2/s]
    real, save, allocatable :: TUkvh(:, :, :)
    ! TUmin : Vertical Diffusion Coefficient (Minimum) [m2/s]
    real, save :: TUmin(mz)
    ! TU_Pra : Prandtl Number (TUkvm/TUkvh) [-]
    real, save, allocatable :: TU_Pra(:, :, :)
    ! TUkhx : Horizont.Diffusion Coefficient (x-direct.) [m2/s]
    real, save, allocatable :: TUkhx(:, :, :)
    real, save :: TUkhff
    real, save :: TUkhmx
    ! TUkhy : Horizont.Diffusion Coefficient (y-direct.) [m2/s]
    real, save, allocatable :: TUkhy(:, :, :)
    ! TUspon: Horizont.Diffusion Coefficient (Top Sponge)[m2/s]
    real, save :: TUspon(mzabso)

contains
    
    subroutine mar_tu_init()
        
        use mardim, only : mx, my, mz
        implicit none
        
        allocate(TUkvm(mx, my, mz))
        allocate(TUkvh(mx, my, mz))
        allocate(TU_Pra(mx, my, mz))
        allocate(TUkhx(mx, my, mz))
        allocate(TUkhy(mx, my, mz))
    
    endsubroutine mar_tu_init

endmodule mar_tu
