! mar_te : mar turbulent kinetic energy
! =====================================
module mar_te
    use mardim
    implicit none
    logical, save :: ini_KA_TE
    ! ect_TE(i,j,k): turbulent kinetic energy (i,j,k+1/2) (m2/s2)
    real, save, allocatable :: ect_TE(:, :, :)
    ! zi__TE(i,j) : Inversion Height (i,j) (m)
    real, save, allocatable :: zi__TE(:, :)
    ! eps_TE(i,j,k) : dissipation of T.K.E. (i,j,k+1/2) (m2/s3)
    real, save, allocatable :: eps_TE(:, :, :)
    ! edt_TE(i,j)   : minimum dissipation time (i,j) (s)
    real, save, allocatable :: edt_TE(:, :)
    ! tranTE(i,j,k) : transport of T.K.E. (i,j,k+1/2) (m2/s3)
    real, save, allocatable :: tranTE(:, :, :)

contains
    
    subroutine mar_te_init()
        
        use mardim, only : mx, my, mz
        implicit none
        
        allocate(ect_TE(mx, my, mz))
        allocate(zi__TE(mx, my))
        allocate(eps_TE(mx, my, mz))
        allocate(edt_TE(mx, my))
        allocate(tranTE(mx, my, mz))
    
    endsubroutine mar_te_init

endmodule mar_te
