! mar_sl : mar surface air layers
! ===============================
module mar_sl
    use mardim
    implicit none
    ! Ta2mSL : interpolated 2 meter air temperature
    real, save, allocatable :: Ta2mSL(:, :, :)
    ! TminSL : minimum 2 meter air temperature
    real, save, allocatable :: TminSL(:, :, :)
    ! TmaxSL : maximum 2 meter air temperature
    real, save, allocatable :: TmaxSL(:, :, :)
    ! Ta3mSL : interpolated 3 meter air temperature
    real, save, allocatable :: Ta3mSL(:, :, :)
    ! V03mSL : interpolated 3 meter wind speed
    real, save, allocatable :: V03mSL(:, :, :)
    ! V10mSL : interpolated 10 meter wind speed
    real, save, allocatable :: V10mSL(:, :, :)
    ! tairSL : extrapolation of the sounding tempature to the surface.    (K)
    real, save :: tairSL(mx, my)
    ! dtagSL : Air-Surface Temperature Difference (K)
    real, save :: dtagSL
    ! tsrfSL : Surface Temperature (K)
    real, save :: tsrfSL(mx, my, mw)
    ! qvapSL : specific humidity close to the surface (kg/kg)
    real, save :: qvapSL(mx, my)
    ! isolSL : Surface Type : 1 -> open ocean
    !                         2 -> glacier + ice sheet + snow
    !                         3 -> sea ice            (+ snow)
    !                         4 -> soil               (+ snow)
    !                         5 -> soil + vegetation
    integer, save :: isolSL(mx, my)
    ! maskSL : Land--Sea Mask 0 -> Continent 1 -> Ocean
    integer, save :: maskSL(mx, my)
    ! sol_SL : Absorbed Solar Heat Flux (W/m2)
    real, save :: sol_SL(mx, my)
    ! firdSL : Downward IR Heat Flux (W/m2)
    real, save :: firdSL(mx, my)
    ! firmSL : Upward IR Heat Flux (W/m2)
    real, save :: firmSL(mx, my)
    ! hsenSL : Downward Sensible Heat Flux (W/m2)
    real, save :: hsenSL(mx, my)
    ! hlatSL : Evapora. Latent Heat Flux (W/m2)
    real, save :: hlatSL(mx, my)
    ! fmelSL : Melting Latent Heat Flux (W/m2)
    real, save :: fmelSL(mx, my)
    ! freeSL : Freezing Latent Heat Flux (W/m2)
    real, save :: freeSL(mx, my)
    ! hbalSL : Total Surface Heat Loss (W/m2)
    real, save :: hbalSL(mx, my)
    ! cld_SL: Total Cloudiness above the Surface
    real, save :: cld_SL(mx, my)
    real, save :: clduSL(mx, my)
    real, save :: cldmSL(mx, my)
    real, save :: clddSL(mx, my)
    ! CldFRA: Cloud Fraction [-]
    real, save, allocatable :: CldFRA(:, :, :)
    ! alb0SL  : Background Surface Albedo
    real, save :: alb0SL(mx, my)
    ! albeSL  : Grid Mesh  Surface Albedo
    real, save :: albeSL(mx, my)
    ! albsSL : Underlaying Soil Albedo
    real, save :: albsSL(mx, my)
    ! albxSL : Mosaic Surface Albedo
    real, save, allocatable :: albxSL(:, :, :)
    ! alb0SL_1: Background Surface Albedo for first  spectral band [0.3-0.8um]
    real, save, allocatable :: alb0SL_1(:, :)
    ! alb0SL_2: Background Surface Albedo for second spectral band [0.8-1.5um]
    real, save, allocatable :: alb0SL_2(:, :)
    ! alb0SL_3: Background Surface Albedo for third  spectral band [1.5-2.8um]
    real, save, allocatable :: alb0SL_3(:, :)
    ! tgirSL : Effective Surface Radiative Temperature
    real, save, allocatable :: tgirSL(:, :)
    ! eps0SL : Surface IR Emissivity
    real, save, allocatable :: eps0SL(:, :)
    ! nSLsrf : Number of  Sectors in a Grid Box (m/s)
    integer, save :: nSLsrf(mx, my)
    integer, parameter :: ntavSL = 20
    ! SLsrfl : Normalized Sector Area (m/s)
    real, save :: SLsrfl(mx, my, mw)
    ! SLzoro : Roughness Length for Momentum (Orography) (m/s)
    real, save, allocatable :: SLzoro(:, :, :)
    ! SL_z0 : Roughness Length for Momentum (m/s)
    real, save, allocatable :: SL_z0(:, :, :)
    real, save, allocatable :: SLn_z0(:, :, :, :)
    ! SL_r0 : Roughness Length for Heat (m/s)
    real, save, allocatable :: SL_r0(:, :, :)
    real, save, allocatable :: SLn_b0(:, :, :, :)
    real, save, allocatable :: SLn_r0(:, :, :, :)
    ! SLlmo : Monin-Obukhov Length (Average) (m/s)
    real, save, allocatable :: SLlmo(:, :)
    ! SLlmol : Monin-Obukhov Length (m/s)
    real, save, allocatable :: SLlmol(:, :, :)
    ! SLuus : Friction Velocity (Average) (m/s)
    real, save, allocatable :: SLuus(:, :)
    ! SLuusl : Friction Velocity (m/s)
    real, save, allocatable :: SLuusl(:, :, :)
    ! duusSL : Correct. Friction Velocity (Average) (m2/s2)
    real, save, allocatable :: duusSL(:, :)
    ! SLuts : Surface  Potential Temperature Turbulent Flux (Average) (K.m/s)
    real, save, allocatable :: SLuts(:, :)
    ! SLutsl : Surface  Potential Temperature Turbulent Flux (K.m/s)
    real, save, allocatable :: SLutsl(:, :, :)
    ! SLdSdT : Sensible Turbulent Heat Flux T-Derivative (W/m2/K)
    real, save, allocatable :: SLdSdT(:, :, :)
    ! dutsSL : Correct. Potential Temperature Turbulent Flux (Average) (K.m/s)
    real, save, allocatable :: dutsSL(:, :)
    ! cutsSL : Correct. Potential Temperature Turbulent Flux (K.m/s)
    real, save, allocatable :: cutsSL(:, :, :)
    ! SLuqs : Surface Specific Humidity Turbulent Flux (Av.) (kg/kg.m/s)
    real, save, allocatable :: SLuqs(:, :)
    ! SLuqsl : Surface Specific Humidity Turbulent Flux (kg/kg.m/s)
    real, save, allocatable :: SLuqsl(:, :, :)
    ! SLdLdT : Latent Turbulent Heat Flux T-Derivative (W/m2/K)
    real, save, allocatable :: SLdLdT(:, :, :)
    ! SaltSL : Friction Velocity Saltation Threshold (m/s)
    real, save, allocatable :: SaltSL(:, :)
    ! SLussl : Surface  Blowing Snow Turbulent Flux (kg/kg.m/s)
    real, save, allocatable :: SLussl(:, :, :)
    ! SLubsl : Surface Blowing Dust Turbulent Flux (kg/kg.m/s)
    real, save, allocatable :: SLubsl(:, :, :)
    ! virSL : Air Loading for SBL Parameterization
    real, save, allocatable :: virSL(:, :)
    ! fracSL : Fractional Time used in Blowing Snow Surface Flux Computation
    real, save :: fracSL
    ! u*, u*T*, u*s* Time Moving Averages
    integer, parameter :: ntaver = 4 ! 9 in the old MAR version
    real, save, allocatable :: u_0aSL(:, :, :, :)
    real, save, allocatable :: uT0aSL(:, :, :, :)
    real, save, allocatable :: us0aSL(:, :, :, :)
    ! V,  dT(a-s) Time Moving Averages
    real, save, allocatable :: V_0aSL(:, :, :)
    real, save, allocatable :: dT0aSL(:, :, :, :)
    ! cdnSL  : Square  Root of Momentum Neutral Drag Coefficient (-)
    real, save, allocatable :: cdnSL(:, :, :)
    ! cdmSL  : Contribution of Momentum to Drag Coefficient (-)
    real, save, allocatable :: cdmSL(:, :, :)
    ! cdhSL  : Contribution of Heat to Drag Coefficient (-)
    real, save, allocatable :: cdhSL(:, :, :)
    ! zs_SL  : Typical Sea  Roughness Length (m)
    real, save :: zs_SL
    ! zn_SL  : Typical Snow Roughness Length (m)
    real, save :: zn_SL
    ! zl_SL  : Typical Land Roughness Length (m)
    real, save :: zl_SL
    ! u*, u*T*, u*s* Time Moving Averages
    ! aeCdSL : Aerodynamic Conductance
    real, save, allocatable :: aeCdSL(:, :)
    ! Kv__SL : Equivalent  Turbulent Diffusivity
    real, save, allocatable :: Kv__SL(:, :)
    ! pktaSL : SBCTurbulence Pot. Temp.
    real, save, allocatable :: pktaSL(:, :)
    ! ssvSL:  Wind Speed Norm (m/s)
    real, save, allocatable :: ssvSL(:, :, :)
    ! ch0SL : Bulk  Aerodynamic Coefficient Air/Surface Humidity Flux
    real, save, allocatable :: ch0SL(:, :)
    ! roseSL : Depletion of water vapor in the surface layer (kg/kg)
    !          due to deposition of dew or rime on ground
    real, save, allocatable :: roseSL(:, :)
    ! raerSL :`Bulk' Stomatal Resistance (Thom & Oliver, 1977, p. 347)
    real, save, allocatable :: raerSL(:, :)
    ! rsurSL : Aerodynamic Resistance
    real, save, allocatable :: rsurSL(:, :)
    ! precSL : Rain
    real, save, allocatable :: precSL(:, :)
    integer, parameter :: nLimit = 10
    ! WV__SL : Water Vapor Flux Limitor
    real, save, allocatable :: WV__SL(:, :, :)
    ! bsnoSL : cumulative snow  erosion height (m)
    real, save, allocatable :: bsnoSL(:, :)
    ! snobSL : snow erosion height (m)
    real, save, allocatable :: snobSL(:, :)
    ! hsnoSL : cumulative snow  accumulation height (m)
    real, save, allocatable :: hsnoSL(:, :)
    ! snohSL : snow precipitation height (m)
    real, save, allocatable :: snohSL(:, :)
    ! hmelSL : cumulative snowmelt height (m water equivalent)
    real, save, allocatable :: hmelSL(:, :)
    ! ro_SL0 : rhos (Initial Surface Density) (kg/m3)
    real, save, allocatable :: ro_SL0(:, :)
    ! ro_SL  : rhos (Surface Density) (kg/m3)
    real, save, allocatable :: ro_SL(:, :)
    ! d1_SL  : rhos * cs *(Depth diurnal Wave) (J/m2/K)
    real, save, allocatable :: d1_SL(:, :)
    ! cs2SL  : Soil Temperature Variation Time Scale (s)
    !          (usually 86400 s, i.e. diurnal cycle)
    real, save :: cs2SL
    ! t2SLtn, t2SLtd: time constants for t2_SL time integration
    real, save :: t2SLtn
    real, save :: t2SLtd
    ! t2_SL  : Soil Deep Layers Temperature (K)
    real, save, allocatable :: t2_SL(:, :)
    ! dtgSL  : Soil Temperature Variation during time interval dt (K)
    !          is renewed every 6 minutes
    real, save, allocatable :: dtgSL(:, :, :)
    logical, save :: qsolSL
    ! hwatSL Rain Accumulation (m)
    real, save, allocatable :: hwatSL(:, :)
    real, save :: w20SL
    ! wg_SL and w2_SL Adimensional Numbers measuring Soil Water Content
    ! w2_SL Rain Accumulation over a large Soil Thickness
    real, save, allocatable :: w2_SL(:, :)
    ! wg_SL Rain Accumulation near the Surface
    real, save, allocatable :: wg_SL(:, :)
    real, save :: wg0SL
    real, save :: wk0SL
    real, save, allocatable :: wk_SL(:, :)
    real, save :: wx0SL
    real, save, allocatable :: wx_SL(:, :)
    ! sst_SL : Sea Surface Temperature
    real, save :: sst_SL
    ! SL_wge : wind gust estimate
    real, save, allocatable :: SL_wge(:, :)
    ! SLlwge : lower bound of the bounding interval around the estimate
    real, save, allocatable :: SLlwge(:, :)
    ! SLuwge : upper bound of the bounding interval around the estimate
    real, save, allocatable :: SLuwge(:, :)
    ! aiceSL : presribed bare ice albedo
    real, save :: aiceSL(mx,my)
contains

    subroutine mar_sl_init()

        use mardim, only: mx, my, mw
        implicit none

        allocate(Ta2mSL(mx, my, mw))
        allocate(TminSL(mx, my, mw))
        allocate(TmaxSL(mx, my, mw))
        allocate(Ta3mSL(mx, my, mw))
        allocate(V03mSL(mx, my, mw))
        allocate(V10mSL(mx, my, mw))
        allocate(CldFRA(mx, my, mz))
        allocate(albxSL(mx, my, mw))
        allocate(alb0SL_1(mx, my))
        allocate(alb0SL_2(mx, my))
        allocate(alb0SL_3(mx, my))
        allocate(tgirSL(mx, my))
        allocate(eps0SL(mx, my))
        allocate(SLzoro(mx, my, mw))
        allocate(SL_z0(mx, my, mw))
        allocate(SLn_z0(mx, my, mw, ntavSL))
        allocate(SL_r0(mx, my, mw))
        allocate(SLn_b0(mx, my, mw, ntavSL))
        allocate(SLn_r0(mx, my, mw, ntavSL))
        allocate(SLlmo(mx, my))
        allocate(SLlmol(mx, my, mw))
        allocate(SLuus(mx, my))
        allocate(SLuusl(mx, my, mw))
        allocate(duusSL(mx, my))
        allocate(SLuts(mx, my))
        allocate(SLutsl(mx, my, mw))
        allocate(SLdSdT(mx, my, mw))
        allocate(dutsSL(mx, my))
        allocate(cutsSL(mx, my, mw))
        allocate(SLuqs(mx, my))
        allocate(SLuqsl(mx, my, mw))
        allocate(SLdLdT(mx, my, mw))
        allocate(SaltSL(mx, my))
        allocate(SLussl(mx, my, mw))
        allocate(SLubsl(mx, my, mw))
        allocate(virSL(mx, my))
        allocate(u_0aSL(mx, my, mw, ntaver))
        allocate(uT0aSL(mx, my, mw, ntaver))
        allocate(us0aSL(mx, my, mw, ntaver))
        allocate(V_0aSL(mx, my, ntaver))
        allocate(dT0aSL(mx, my, mw, ntaver))
        allocate(cdnSL(mx, my, mw))
        allocate(cdmSL(mx, my, mw))
        allocate(cdhSL(mx, my, mw))
        allocate(aeCdSL(mx, my))
        allocate(Kv__SL(mx, my))
        allocate(pktaSL(mx, my))
        allocate(ssvSL(mx, my, mz))
        allocate(ch0SL(mx, my))
        allocate(roseSL(mx, my))
        allocate(raerSL(mx, my))
        allocate(rsurSL(mx, my))
        allocate(precSL(mx, my))
        allocate(WV__SL(mx, my, nLimit))
        allocate(bsnoSL(mx, my))
        allocate(snobSL(mx, my))
        allocate(hsnoSL(mx, my))
        allocate(snohSL(mx, my))
        allocate(hmelSL(mx, my))
        allocate(ro_SL0(mx, my))
        allocate(ro_SL(mx, my))
        allocate(d1_SL(mx, my))
        allocate(t2_SL(mx, my))
        allocate(dtgSL(mx, my, mw))
        allocate(hwatSL(mx, my))
        allocate(w2_SL(mx, my))
        allocate(wg_SL(mx, my))
        allocate(wk_SL(mx, my))
        allocate(wx_SL(mx, my))
        allocate(SL_wge(mx, my))
        allocate(SLlwge(mx, my))
        allocate(SLuwge(mx, my))

    endsubroutine mar_sl_init

endmodule mar_sl
