! mar_ra : mar radiative scheme
! =============================
module mar_ra
    use mardim
    implicit none
    ! pktRAd: Radiation Divergence ==> Diabatic Heating
    real, save :: pktRAd(mx, my, mz)
    ! RAdsol: Surface Downward  Solar Heat Flux
    real, save :: RAdsol(mx, my)
    real, save :: RAdsolc(mx, my) ! clear-sky
    real, save :: RAdsold(mx, my) ! direct
    ! RAd_ir: Surface Downward IR Heat Flux
    real, save :: RAd_ir(mx, my)
    ! RAdOLR: Outgoing Longwave Radiation
    real, save :: RAdOLR(mx, my)
    ! RAdOSR: Outgoing Shortwave Radiation
    real, save :: RadOSR(mx, my)
    ! RAfnSO: Net Shortwave Radiation
    real, save, allocatable :: RAfnSO(:, :, :)
    ! RAfnIR: Net Longwave Radiation
    real, save, allocatable :: RAfnIR(:, :, :)
    ! RAfncSO: Clearsky Net Shortwave Radiation
    real, save, allocatable :: RAfncSO(:, :, :)
    ! RAfncIR: Clearsky Net Longwave Radiation
    real, save, allocatable :: RAfncIR(:, :, :)
    ! tviRA: Radiating Surface Temperature
    real, save :: tviRA(mx, my)
    ! IRsoil: Soil upward IR
    real, save, allocatable :: IRsoil(:, :, :)
    ! RAcd_O, RAcdtO: Cloud Optical Depth [-]
    real, save, allocatable :: RAcd_O(:, :, :)
    real, save :: RAcdtO(mx, my)
    ! RAer_O, RAertO: Aeros.Optical Depth [-]
    real, save, allocatable :: RAer_O(:, :, :)
    real, save :: RAertO(mx, my)
    ! pmb_RA: Pressure (hPa)
    real, save :: pmb_RA(mzir)
    ! tairRA: Temperature (K)
    real, save :: tairRA(mzir)
    ! qvapRA: Specific Humidity (kg/kg)
    real, save :: qvapRA(mzir)
    ! cld_RA: Cloudiness at level k
    real, save :: cld_RA(mzir)
    ! qlwpRA: Cloud Liquid Water Path (level k)
    real, save :: qlwpRA(mzir)
    ! toptRA: Cloud Optical Depth (level k)
    real, save :: toptRA(mzir)
    ! wo3_RA: Ozone Content (cm STP)
    real, save :: wo3_RA(mzir)
    ! dwo3RA: Ozone Content (Divergence)
    real, save :: dwo3RA(mzir)
    ! htngRA: Radiative Heating (K/s)
    real, save :: htngRA(mzir)

contains
    
    subroutine mar_ra_init()
        
        use mardim, only : mx, my, mz, mzz
        implicit none
        
        allocate(RAfnSO(mx, my, mz))
        allocate(RAfnIR(mx, my, mzz))
        allocate(RAfncSO(mx, my, mz))
        allocate(RAfncIR(mx, my, mzz))
        allocate(IRsoil(mx, my, mw))
        allocate(RAcd_O(mx, my, mz))
        allocate(RAer_O(mx, my, mz))
    
    endsubroutine mar_ra_init

endmodule mar_ra
