! mar_po : mar polynya model
! ==========================
module mar_po
    use mardim
    implicit none
    ! dtPO : Polynya Model Time Step
    real, save :: dtPO
    ! silfPO : Sea Ice Solidification: Latent Heat
    real, save :: silfPO
    ! sw00PO, si00PO: water, sea-ice salinities (TN Bay)
    !          (Bromwich and Kurtz,   1984, JGR, p.3568;
    !           Cavalieri and Martin, 1985,      p. 248)
    real, save :: sw00PO
    real, save :: si00PO
    ! aPOlyn : Initial (observed) Lead Fraction
    real, save :: aPOlyn(mx, my)
    ! iPO1,iPO2,iPO3,iPO4 define output area (x-axis)
    ! jPO1,jPO2,jPO3,jPO4 define output area (y-axis)
    integer, save :: iPO1, iPO2, jPO1, jPO2, iPO3, iPO4, jPO3, jPO4
    ! uocnPO: Oceanic Current (prescribed, x-direction)
    real, save :: uocnPO(mx, my)
    ! vocnPO: Oceanic Current (prescribed, y-direction)
    real, save :: vocnPO(mx, my)
    ! focnPO: Oceanic Heat Flux (in the oceanic mixed layer)
    real, save :: focnPO(mx, my)
    ! albwPO: Open Water Surface Albedo
    real, save :: albwPO(mx, my)
    ! hatmPO: Heat Losses from Open Water Area
    real, save :: hatmPO(mx, my)
    ! swsaPO: Oceanic Salinity  (in the oceanic mixed layer)
    real, save :: swsaPO(mx, my)
    ! tsswPO: Sea Water Freezing Temperature
    real, save :: tsswPO(mx, my)
    ! cwswPO: Sea Water Heat Capacity
    real, save :: cwswPO(mx, my)
    ! awmxPO: Max Fraction of Open Water
    real, save :: awmxPO(mx, my)
    ! uicePO : Sea-Ice Velocity
    real, save :: uicePO(mx, my)
    ! vicePO : Sea-Ice Velocity
    real, save :: vicePO(mx, my)
    ! ufraPO : Fraizil Velocity
    real, save :: ufraPO(mx, my)
    ! vfraPO : Fraizil Velocity
    real, save :: vfraPO(mx, my)
    ! hfraPO : Fraizil Thickness
    real, save :: hfraPO(mx, my)
    ! hicePO : Sea-Ice Thickness (Old   Ice)
    real, save :: hicePO(mx, my)
    ! aicePO : Sea-Ice Fraction  (Old   Ice)
    real, save :: aicePO(mx, my)
    ! hiavPO : Sea-Ice Thickness (Average)
    real, save :: hiavPO(mx, my)
    ! vgriPO : Grease Ice Volume (New   Ice)
    real, save :: vgriPO(mx, my)
endmodule mar_po
