module mar_pb
    use mardim
    implicit none
    ! Kstep1 : convective counter
    integer, save :: Kstep1(klon)
    ! K_CbT1 : cloud top  level
    integer, save :: K_CbT1(klon)
    ! K_CbB1 : cloud base level
    integer, save :: K_CbB1(klon)
    integer, parameter :: KTCCH0 = 1
    real, save :: P_CH_0(klon, klev, KTCCH0)
    real, save :: PdCH_1(klon, klev, KTCCH0)
    real, save :: PdTa_1(klon, klev)
    real, save :: PdQa_1(klon, klev)
    real, save :: PdQw_1(klon, klev)
    real, save :: PdQi_1(klon, klev)
    real, save :: Pdrr_1(klon)
    real, save :: Pdss_1(klon)
    ! PuMF_1 : Upward Mass Flux
    real, save :: PuMF_1(klon, klev)
    ! PdMF_1 : Downward Mass Flux
    real, save :: PdMF_1(klon, klev)
    ! Pfrr_1 : Liquid Precipitation Flux
    real, save :: Pfrr_1(klon, klev)
    ! Pfss_1 : Solid Precipitation Flux
    real, save :: Pfss_1(klon, klev)
    ! Pcape1 : CAPE [J/kg]
    real, save :: Pcape1(klon)
endmodule mar_pb
