! mar_nh : mar non-hydrostatic
! ============================
module mar_nh
    use mardim
    implicit none
    ! ua0_NH : Horizontal (x-Direction) Wind Speed (m/s) / Previous Time Step
    real, save :: ua0_NH(mx, my, mz)
    ! va0_NH : Horizontal (y-Direction) Wind Speed (m/s) / Previous Time Step
    real, save :: va0_NH(mx, my, mz)
    ! wa0_NH : Vertical   (z-Direction) Wind Speed (m/s) / Previous Time Step
    real, save :: wa0_NH(mx, my, mz)
    ! wairNH : Vertical Non-Hydrostatic Wind Speed (m/s)
    real, save :: wairNH(mx, my, mz)
    ! pairNH : Non-Hydrostatic Pressure (kPa)
    real, save :: pairNH(mx, my, mz)
    ! dt_ONH : Non-Hydrostatic Time Step (s)
    real, save :: dt_ONH
    ! dtxONH = dt_ONH / dx (s/m)
    real, save :: dtxONH
    ! dtyONH = dt_ONH / dy (s/m)
    real, save :: dtyONH
    ! gamaNH : Cp / Cv
    real, save :: gamaNH
    ! c2NH : Prescribed Squared Sound Speed (m2/s2)
    real, save :: c2NH
    ! taNH : Reference  Surface Air Temperature (K)
    real, save :: taNH
endmodule mar_nh
