module mar_module
    use mardim
    use mar_ge
    use marphy
    use mar_ao
    implicit none
    private
    public :: inicma, fromcpl, intocpl, atm2geo, atm2geo2
    integer, parameter, public :: im = mx, jm = my
    integer, parameter, public :: ntot = mx * my
    integer, parameter, public :: nout = 6
    ! i_timemax : Nombre de pas de temps dans les fichiers Netcdf de forcage
    integer, parameter, public :: i_timemax = 30
    ! i_ReadFieldNb : Nombre de champs du fichier Netcdf de forcage
    integer, parameter, public :: i_ReadFieldNb = 11
    ! i_WriteFieldNb : Nombre de champs du fichier Netcdf de sorties oceaniques
    integer, parameter, public :: i_WriteFieldNb = 5
    ! jpflda2o1 : Number of fields exchanged from atmosphere to ocean via flx.F
    integer, parameter, public :: jpflda2o1 = 9 !9 if coupsnow // 8 if not
    ! jpflda2o2 : Number of fields exchanged from atmosphere to ocean via tau.F
    integer, parameter, public :: jpflda2o2 = 8 !!COTAU...
    ! jpfldo2a : Number of fields exchanged from ocean to atmosphere
    integer, parameter, public :: jpfldo2a = 10
    ! Define symbolic name for fields exchanged from atmos to coupler,
    !   must be the same as (1) of the field  definition in namcouple:
    !  real, dimension(im,jm), save :: uuao,vvao
    !  character(len=8), parameter, dimension(16), public :: cl_writ=(/ 'COSHFICE', &
    !     & 'COSHFOCE', 'CONSFICE', 'CONSFOCE', 'CODFLXDT', 'COEVAPWA', 'COLIQPRE', &
    !     & 'COSOLPRE', 'COTAUXUW', 'COTAUXUI', 'COTAUYUW', &
    !     & 'COTAUYUI', 'COTAUXVW', 'COTAUXVI', 'COTAUYVW', 'COTAUYVI' /)
    !avec coupsnow
    character(len=8), parameter, dimension(17), public :: cl_writ = (/ &
                                                          'COSHFICE', 'COSHFOCE', 'CONSFICE', 'CONSFOCE', 'CODFLXDT', &
                                                          'COEVATOT', 'COLIQPRE', 'COSOLPRE', 'COEVAICE', 'COTAUXUW', &
                                                          'COTAUXUI', 'COTAUYUW', 'COTAUYUI', 'COTAUXVW', 'COTAUXVI', &
                                                          'COTAUYVW', 'COTAUYVI'/)
    ! COSHFICE = COupled Solar Heat Flux on ICE (SWD on ice)
    ! COSHFOCE = COupled Solar Heat Flux on OCEan (SWD on ice)
    ! CONSFICE = COupled Non Solar Flux on ICE (LWD on ice)
    ! CONSFOCE = Coupled Non Solar Flux on OCEan (LWD on ocean)
    ! CODFLXDT = COupled down Latent x(?) DerivaTive
    ! COEVAPWA = COupled EVAPoration on WAter
    ! COLIQPRE = COupled LIQuid PREcipitation
    ! COSOLPRE = COupled SOLid PREcipitation
    ! COUPSNOW = COupled UPward Snow !BS
    ! COTAUXUW = COupled downward TAUx X-axis X-axis stress on U-grid on Water
    ! COTAUXUI = COupled downward TAUx X-axis X-axis stress on U-grid on Ice
    ! COTAUYUW = COupled downward TAUx X-axis Y-axis stress on U-grid on Water
    ! COTAUYUI = COupled downward TAUx X-axis Y-axis stress on U-grid on Ice
    ! COTAUXVW = COupled downward TAUx X-axis X-axis stress on V-grid on Water
    ! COTAUXVI = COupled downward TAUx X-axis X-axis stress on V-grid on Ice
    ! COTAUYVW = COupled downward TAUx X-axis Y-axis stress on U-grid on Water
    ! COTAUYVI = COupled downward TAUx X-axis Y-axis stress on V-grid on Ice
    !
    ! Define symbolic name for fields exchanged from coupler to atmosphere,
    !     must be the same as (2) of the field  definition in namcouple:
    character(len=8), parameter, dimension(10), public :: cl_read = (/ &
                                                          'SISUTESW', 'SIICECOV', 'SIICEALW', 'SIICTEMW', 'SIHEIGHT', &
                                                          'SISNOWHT', 'OCECURTU', 'OCECURTV', 'ICECURTU', 'ICECURTV'/)
    integer, dimension(jpfldo2a), save :: ig_var_id_in
    integer, dimension(jpflda2o1 + jpflda2o2), save :: ig_var_id_out

contains
    subroutine inicma
        use mod_oasis
        implicit none
        ! comp_id : component identification
        integer :: comp_id
        character(len=6) :: comp_name = 'mara'
        integer :: ierror
        ! localComm : local MPI communicator and Initialized
        integer :: localComm
        ! Global grid parameters :
        ! nlon, nlat : dimensions in the 2 directions of space
        ! integer :: nlon, nlat
        ! MAR Antarctic since first MAR-NEMO coupling over the AIS.
        ! NB character(len=4) used for historical oasis reasons userguidep16
        character(len=4) :: cgrid = 'mara'
        ! ntot : total dimension (=mx*my) defined above
        ! integer :: ntot
        integer :: il_paral_size
        ! nc : number of corners
        ! integer :: nc
        ! integer :: indi_beg, indi_end, indj_beg, indj_end

        ! if OASIS has to define grids.nc, masks.nc and areas.nc (do not use it)
        ! real :: deglon2D(mx,my),deglat2D(mx,my)
        ! real :: globalgrid_clo(mx,my), globalgrid_cla(mx,my), globalgrid_srf(mx,my),indice_mask(mx,my)

        ! il_paral : Decomposition for each proc !cf uiserguide p12
        integer, dimension(:), ALLOCATABLE :: il_paral

        ! Grid parameters definition
        ! il_part_id : use to connect the partition to the variables
        integer :: il_part_id

        ! some messy paramaters still not classified
        ! il_flag : Flag for grid writing by proc 0
        integer :: il_flag
        integer il_var_nodims(2), il_var_shape(4)
        integer jf, info

        !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

        !*    1. Initializations
        !        ---------------

        write(nout, *) ' '
        write(nout, *) ' '
        write(nout, *) ' ROUTINE INICMA'
        write(nout, *) ' **************'
        write(nout, *) ' '
        write(nout, *) ' '

        call oasis_init_comp(comp_id, comp_name, ierror) ! model name = MAR

        if(ierror /= 0) then
            write(6, *) 'oasis_init_comp abort by ', comp_name, ' compid ', comp_id
            call oasis_abort(comp_id, comp_name, 'Problem init in oasis_init_comp')
        else
            write(6, *) 'inicma: init oasis ok'
        endif

        !*    1.1 Oasis get localcomm
        !        ---------------
        ! Attribution by Oasis of a local communicator for each component
        !WARNING WARNING!
        call oasis_get_localcomm(localComm, ierror)
        if(ierror /= 0) then
            write(6, *) 'oasis_get_localcomm abort by', comp_name, ' compid ', comp_id
            call oasis_abort(comp_id, comp_name, 'Problem ')
        endif

        !Probably not Needed (at least it works without...)
        !  call MPI_Comm_Size ( localComm, npes, ierror )
        !  if (ierror /= 0) then
        !      write(w_unit,*) 'MPI_comm_size abort by model1 compid ',comp_id
        !      call oasis_abort(comp_id,comp_name,'Problem at line 131')
        !  end if
        !  !
        !  call MPI_Comm_Rank ( localComm, mype, ierror )
        !  if (ierror /= 0) then
        !      write (w_unit,*) 'MPI_Comm_Rank abort by model1 compid ',comp_id
        !      call oasis_abort(comp_id,comp_name,'Problem at line 137')
        !  end if

        !*    1.2 Grid partition
        !        ---------------
        ! Definition of the partition of the grid (serial, apple, box and orange)
        ! CHECK for OPEN-MP/ MPI compatibility !!!! CK 20/02/2020
        ! Firsly coded to use a serial partition (= no partition) = one box
        ! works but only with one CPU (probably link to oasis get localcomm?)

        ! ntot = mx * my ! mx and my from mardim_mod.f90

        ! il_paral_size = 3 ! for apple
        ! il_paral_size = 5 ! for box
        ! il_paral_size = ! N segments for orange
        ! il_paral_size = ! N points for points
        il_paral_size = 3 !no partition Serial userguide p12
        ALLOCATE(il_paral(il_paral_size))

        !WARNING!!! if Serial
        if(il_paral_size == 3) then
            il_paral(1) = 0
            il_paral(2) = 0
            il_paral(3) = ntot
        endif

        call oasis_def_partition(il_part_id, il_paral, ierror)

        DEALLOCATE(il_paral)

        !* 1.3 Grid definition
        !        ---------------
        ! Definition of grids (grids.nc, masks.nc and areas.nc) if not previously defined by users
        ! => do IT AND do NOT LET OASIS TO do IT

        !    deglon2D = GElonh * 15.     !Gelonh(mx,my) = longitude in hours
        !    deglat2D = GElatr / degrad  !Gelatr(mx,my) = lat in radian
        ! should be corrected as OASIS needs lon and lat corner not lon and lat from the center of the pixel !CK6/12/18

        !      call oasis_start_grids_writing(il_flag)
        !      call oasis_write_grid(cgrid, mx, my, deglon2D, deglat2D)
        !      call oasis_write_corner(cgrid, mx, my, 4, globalgrid_clo, globalgrid_cla)
        !      call oasis_write_area(cgrid, mx, my, globalgrid_srf)
        !      call oasis_write_mask(cgrid, mx, my, indice_mask(:,:))
        !      call oasis_terminate_grids_writing()

        !* 1.4 Coupling field declaration
        !        ---------------
        il_var_nodims(1) = 1
        il_var_nodims(2) = 1

        il_var_shape(1) = 1
        il_var_shape(2) = mx
        il_var_shape(3) = 1
        il_var_shape(4) = my

        ! 1.4.1 Declare each field received by atm

        do jf = 1, jpfldo2a
            call oasis_def_var(ig_var_id_in(jf), cl_read(jf), il_part_id, il_var_nodims, &
                               OASIS_In, il_var_shape, OASIS_real, ierror)
            !var_id, name= nom namcouple, partition ID, varnodims always 1,
            ! OASIS_in defined in parameters.f90 (see userguide p18),dimension,type du field,
            if(ierror /= 0) then
                write(6, *) ' inicma : pb o define O to A ' &
                        &, cl_read(jf), ' for jf = ', jf
                write(6, *) ' error code is = ', ierror
                write(6, *) ' STOP in inicma'
                call FLUSH(6)
                call abort
            else
                write(6, *) 'inicma : oasis define O to A OK ', jf, ' : ' &
                        &, cl_read(jf)
            endif
        enddo

        !     1.4.2 Declare each field sent by atm

        do jf = 1, jpflda2o1 + jpflda2o2
            call oasis_def_var(ig_var_id_out(jf), cl_writ(jf), il_part_id, il_var_nodims, &
                               OASIS_Out, il_var_shape, OASIS_real, ierror)

            if(ierror /= 0) then
                write(6, *) ' inicma : pb oasis def var A to O ' &
                        &, cl_writ(jf), ' for jf = ', jf
                write(6, *) ' error code is = ', ierror
                write(6, *) ' STOP in inicma'
                call FLUSH(6)
                call abort
            else
                write(6, *) 'inicma : oasis define OK A to O ', jf, ' : ' &
                        &, cl_writ(jf)
            endif
        enddo
        write(6, *) 'inicma : oasis_def_var ok '

        !* 1.5 end of declaration phase
        !    ---------------

        call oasis_enddef(ierror)

        if(ierror /= 0) then
            write(6, *) 'inicma : pb oasis_enddef '
            write(6, *) ' error code is = ', ierror
            write(6, *) ' STOP in inicma'
            coupling_ao = .false.
            call FLUSH(6)
            call abort
        else
            write(6, *) 'inicma : start ierror ok '
            coupling_ao = .true.
        endif

    endsubroutine inicma

    !==========================================================================
    !
    subroutine fromcpl(kt, sst, iss, gla, igla, albedo, ialb, tice, itic, hice, ihic, &
                       hsnow, ihsn, u_oce, i_uo, v_oce, i_vo, u_ice, i_ui, v_ice, i_vi)

        use mod_oasis

        implicit none

        integer kt               ! in seconds
        real(kind=8) sst(im, jm)          ! -sea-surface-temperature
        real(kind=8) gla(im, jm)          ! -sea-ice fraction
        real(kind=8) tice(im, jm)         ! -ice surf temperature
        real(kind=8) albedo(im, jm)       ! -albedo over sea ice
        real(kind=8) hice(im, jm)         ! -sea ice height
        real(kind=8) hsnow(im, jm)        ! -surface snow thickness over sea ice
        real(kind=8) u_oce(im, jm)        ! -surface ocean velocity along X
        real(kind=8) v_oce(im, jm)        ! -surface ocean velocity along Y
        real(kind=8) u_ice(im, jm)        ! -surface ice velocity along X
        real(kind=8) v_ice(im, jm)        ! -surface ice velocity along Y

        integer info, jf
        ! flag used in MAR so that MAR can know if there was a coupling
        ! for that variable at its timestep
        integer iss, igl, igla, ialb, itic, ihic, ihsn, i_uo, i_vo, i_ui, i_vi

        call flush(6)

        !  Get interpolated oceanic fields from Oasis
        ! (only if kt=coupling time, cf oasis_get_proto)

        do jf = 1, jpfldo2a
            if(jf == 1) then
                call oasis_get(ig_var_id_in(1), kt, sst, iss)
                info = iss
            endif
            if(jf == 2) then
                call oasis_get(ig_var_id_in(2), kt, gla, igla)
                info = igla
            endif
            if(jf == 3) then
                call oasis_get(ig_var_id_in(3), kt, albedo, ialb)
                info = ialb
            endif
            if(jf == 4) then
                call oasis_get(ig_var_id_in(4), kt, tice, itic)
                info = itic
            endif
            if(jf == 5) then
                call oasis_get(ig_var_id_in(5), kt, hice, ihic)
                info = ihic
            endif
            if(jf == 6) then
                call oasis_get(ig_var_id_in(6), kt, hsnow, ihsn)
                info = ihsn
            endif
            if(jf == 7) then
                call oasis_get(ig_var_id_in(7), kt, u_oce, i_uo)
                info = i_uo
            endif
            if(jf == 8) then
                call oasis_get(ig_var_id_in(8), kt, v_oce, i_vo)
                info = i_vo
            endif

            if(jf == 9) then
                call oasis_get(ig_var_id_in(9), kt, u_ice, i_ui)
                info = i_ui
            endif

            if(jf == 10) then
                call oasis_get(ig_var_id_in(10), kt, v_ice, i_vi)
                info = i_vi
            endif

            if(info /= OASIS_Ok .and. info /= OASIS_Recvd &
                    &          .and. info /= OASIS_FromRest .and. info /= OASIS_Input &
                    &          .and. info /= OASIS_RecvOut .and. &
                    &          info /= OASIS_FromRestOut) then
                write(nout, *) 'Pb in reading ', cl_read(jf), jf
                write(nout, *) 'Couplage kt is = ', kt
                write(nout, *) 'PSMILe error code is = ', info
                write(nout, *) ' STOP in fromcpl'
                call FLUSH(nout)
                call abort
            endif
        enddo

    endsubroutine fromcpl
    !
    !==========================================================================
    !
    !  subroutine intocpl(kt, fsolice, fsolwat, fnsolice, fnsolwat, &
    !         &    fnsicedt, evwat, lpre, spre,  &
    !         &    taux_u_oce, taux_u_ice, tauy_u_oce, tauy_u_ice, &
    !         &    taux_v_oce, taux_v_ice, tauy_v_oce, tauy_v_ice)

    ! with upsnpw(coupsnow)

    subroutine intocpl(kt, fsolice, fsolwat, fnsolice, fnsolwat, &
            &    fnsicedt, evtot, lpre, spre, ievp, &
            &    taux_u_oce, taux_u_ice, tauy_u_oce, tauy_u_ice, &
            &    taux_v_oce, taux_v_ice, tauy_v_oce, tauy_v_ice)

        use mod_oasis

        implicit none

        ! time in seconds
        integer, intent(in) :: kt
        ! solar heat flux on sea ice
        real(kind=8), dimension(im, jm), intent(in) :: fsolice
        ! solar heat flux on water
        real(kind=8), dimension(im, jm), intent(in) :: fsolwat
        ! total non-solar heat flux on sea ice
        real(kind=8), dimension(im, jm), intent(in) :: fnsolice
        ! total non-solar heat flux on water
        real(kind=8), dimension(im, jm), intent(in) :: fnsolwat
        ! non solar heat flux derivative
        real(kind=8), dimension(im, jm), intent(in) :: fnsicedt
        ! evaporation over ocean and sea ice
        real(kind=8), dimension(im, jm), intent(in) :: evtot
        ! liquid precip
        real(kind=8), dimension(im, jm), intent(in) :: lpre
        ! snow fall
        real(kind=8), dimension(im, jm), intent(in) :: spre
        ! sea ice sublimation
        real(kind=8), dimension(im, jm), intent(in) :: ievp
        ! weighted surface downward X-axis stress on U-grid
        real(kind=8), dimension(im, jm), intent(in) :: taux_u_oce
        ! weighted surface downward X-axis stress over ice on U-grid
        real(kind=8), dimension(im, jm), intent(in) :: taux_u_ice
        ! weighted surface downward Y-axis stress on U-grid
        real(kind=8), dimension(im, jm), intent(in) :: tauy_u_oce
        ! weighted surface downward Y-axis stress over ice on U-grid
        real(kind=8), dimension(im, jm), intent(in) :: tauy_u_ice
        ! weighted surface downward X-axis stress on V-grid
        real(kind=8), dimension(im, jm), intent(in) :: taux_v_oce
        ! weighted surface downward X-axis stress over ice on V-grid
        real(kind=8), dimension(im, jm), intent(in) :: taux_v_ice
        ! weighted surface downward Y-axis stress on V-grid
        real(kind=8), dimension(im, jm), intent(in) :: tauy_v_oce
        ! weighted surface downward Y-axis stress over ice on V-grid
        real(kind=8), dimension(im, jm), intent(in) :: tauy_v_ice

        integer :: icstep, info, jn
        !
        icstep = kt
        !

        !
        !     -Give atmospheric fields to Oasis
        !  (only if kt+idt=coupling time, cf prism_put_proto)
        !  (else, prism_put_prot usefull for averages in oasis)

        do jn = 1, jpflda2o1 + jpflda2o2
            if(jn == 1) call oasis_put(ig_var_id_out(jn), &
                    &        kt, fsolice, info)
            if(jn == 2) call oasis_put(ig_var_id_out(jn), kt, &
                    &        fsolwat, info)
            if(jn == 3) call oasis_put(ig_var_id_out(jn), kt, &
                    &        fnsolice, info)
            if(jn == 4) call oasis_put(ig_var_id_out(jn), kt, &
                    &        fnsolwat, info)
            if(jn == 5) call oasis_put(ig_var_id_out(jn), kt, &
                    &        fnsicedt, info)
            if(jn == 6) call oasis_put(ig_var_id_out(jn), kt, &
                    &        evtot, info)
            if(jn == 7) call oasis_put(ig_var_id_out(jn), kt, &
                    &        lpre, info)
            if(jn == 8) call oasis_put(ig_var_id_out(jn), kt, &
                    &        spre, info)
            if(jn == 9) call oasis_put(ig_var_id_out(jn), kt, &
                    &        ievp, info) !WARNING NOT useD ANYMORE 03/05 (CK? maybe still used actually)
            if(jn == 10) call oasis_put(ig_var_id_out(jn), kt, &
                    &        taux_u_oce, info)
            if(jn == 11) call oasis_put(ig_var_id_out(jn), kt, &
                    &        taux_u_ice, info)
            if(jn == 12) call oasis_put(ig_var_id_out(jn), kt, &
                    &        tauy_u_oce, info)
            if(jn == 13) call oasis_put(ig_var_id_out(jn), kt, &
                    &        tauy_u_ice, info)
            if(jn == 14) call oasis_put(ig_var_id_out(jn), kt, &
                    &        taux_v_oce, info)
            if(jn == 15) call oasis_put(ig_var_id_out(jn), kt, &
                    &        taux_v_ice, info)
            if(jn == 16) call oasis_put(ig_var_id_out(jn), kt, &
                    &        tauy_v_oce, info)
            if(jn == 17) call oasis_put(ig_var_id_out(jn), kt, &
                    &        tauy_v_ice, info)

            if(info /= OASIS_Ok .and. info /= OASIS_Sent &
               .and. info /= OASIS_ToRest .and. info /= OASIS_LocTrans &
               .and. info /= OASIS_Output .and. info /= OASIS_SentOut &
               .and. info /= OASIS_ToRestOut) then
                write(nout, *) 'STEP : Pb giving ', cl_writ(jn), ':', jn
                write(nout, *) ' at timestep = ', icstep, 'kt = ', kt
                write(nout, *) 'OASIS error code is = ', info
                write(nout, *) ' STOP in intocpl'
                call FLUSH(nout)
                call abort
            endif
        enddo
    endsubroutine intocpl
    !
    !==========================================================================
    !
    subroutine atm2geo(pte, ptn, plon, plat, pxx, pyy, pzz)
        !
        !! Change wind local atmospheric coordinates to geocentric
        !!
        !
        real, dimension(im, jm), intent(in) :: pte, ptn
        real, dimension(im, jm), intent(in) :: plon, plat
        real, dimension(im, jm), intent(out) :: pxx, pyy, pzz
        !
        real, parameter :: rpi = 3.141592653E0
        real, parameter :: rad = rpi / 180.0E0
        !
        real, dimension(im, jm), save :: zsinlon, zcoslon
        real, dimension(im, jm), save :: zsinlat, zcoslat
        !
        logical, save :: linit = .false.
        !
        if(.not. linit) then
            zsinlon = SIN(rad * plon)
            zcoslon = COS(rad * plon)
            zsinlat = SIN(rad * plat)
            zcoslat = COS(rad * plat)
            linit = .true.
        endif
        !
        pxx = -zsinlon * pte - zsinlat * zcoslon * ptn
        pyy = zcoslon * pte - zsinlat * zsinlon * ptn
        pzz = zcoslat * ptn
        !
        ! Value at North Pole
        pxx(:, 1) = -ptn(1, 1)
        pyy(:, 1) = -pte(1, 1)
        pzz(:, 1) = 0.0
        ! Value at South Pole
        pxx(:, jm) = +ptn(1, jm)
        pyy(:, jm) = +pte(1, jm)
        pzz(:, jm) = 0.0
        !
    endsubroutine atm2geo

    subroutine atm2geo2(ua, va, lon, uo, vo)
        ! Reproj wind vectors from MAR grid to NEMO grid ... need to be improved ! PV
        ! MAR uses wind_rot.f90 now

        real, dimension(im, jm), intent(in) :: ua, va
        real, dimension(im, jm), intent(in) :: lon
        real, dimension(im, jm), intent(out) :: uo, vo
        real, parameter :: rpi = 3.141592653E0
        real, parameter :: rad = rpi / 180.0E0
        real, dimension(im, jm), save :: cosphi, sinphi, phi
        real, parameter :: lon0 = 140.0E0
        real, parameter :: deltaphi = 90 - lon0

        phi = -1 * (lon + deltaphi) * rad
        cosphi = COS(phi)
        sinphi = SIN(phi)

        uo = sinphi * va + cosphi * ua
        vo = cosphi * va - sinphi * ua
    endsubroutine atm2geo2
endmodule mar_module
