! mar_lb : mar lateral boundaries
module mar_lb
    use mardim
    implicit none
    ! n6 et n7 determine a relaxation zone towards lateral boundaries
    ! (large scale values of the variables).
    ! This zone extends over n6-1 points.
    ! Davies (1976) propose 5 points (i.e. n6=6 and n7=7)
    ! iyr_LB: Year
    integer, save :: iyr_LB
    ! mma_LB: Month
    integer, save :: mma_LB
    ! jda_LB: Day
    integer, save :: jda_LB
    ! jhu_LB: Hour  (UT)
    integer, save :: jhu_LB
    ! jdh_LB: Time Interval before next GCM/NWP LBC (hour)
    ! jdh_LB=0 ==> NO further GCM/NWP LBC available
    integer, save :: jdh_LB
    ! tim1LB: Time of the previous LBC (second)
    integer(kind = 8), save :: tim1LB
    ! tim2LB: Time of the next LBC (second)
    integer(kind = 8), save :: tim2LB
    ! n6mxLB, n6myLB, ...  define the effective length of the lateral sponge
    integer, save :: n40xLB, n50xLB, n5mxLB, n6mxLB, n7mxLB, &
            n40yLB, n50yLB, n5myLB, n6myLB, n7myLB
    ! vaXX : large scale values of relevant dependant variables
    !   ^X=(x->x axis border, y->y axis border)
    !    ^X=(g->x small, d->x large, b->y small, h->y large)
    real, save, allocatable :: vaxgLB(:, :, :, :)
    real, save, allocatable :: vaxdLB(:, :, :, :)
    real, save, allocatable :: v1xgLB(:, :, :, :)
    real, save, allocatable :: v1xdLB(:, :, :, :)
    real, save, allocatable :: v2xgLB(:, :, :, :)
    real, save, allocatable :: v2xdLB(:, :, :, :)
    real, save, allocatable :: tixgLB(:, :, :)
    real, save, allocatable :: tixdLB(:, :, :)
    real, save, allocatable :: vayiLB(:, :, :, :)
    real, save, allocatable :: vaysLB(:, :, :, :)
    real, save, allocatable :: v1yiLB(:, :, :, :)
    real, save, allocatable :: v1ysLB(:, :, :, :)
    real, save, allocatable :: v2yiLB(:, :, :, :)
    real, save, allocatable :: v2ysLB(:, :, :, :)
    ! tiXXLB : independant term of semi-implicit numerical scheme
    real, save, allocatable :: tiyiLB(:, :, :)
    real, save, allocatable :: tiysLB(:, :, :)
    ! wiXXLB : coefficient used in semi-implicit numerical scheme
    real, save, allocatable :: wixgLB(:, :)
    real, save, allocatable :: wixdLB(:, :)
    real, save, allocatable :: wiyiLB(:, :)
    real, save, allocatable :: wiysLB(:, :)
    ! rXLB : nudging coefficients of the relaxation zone
    real, save :: rxLB(mx)
    real, save :: ryLB(my)
    ! sst_LB : external SST
    real, save :: sst_LB(mx, my)
    real, save :: sst1LB(mx, my)
    real, save :: sst2LB(mx, my)
    ! Tfr_LB : Freezing Temperature
    !         (corrected when using Reynolds data set)
    real, save :: Tfr_LB

contains
    
    subroutine mar_lb_init()
        
        use mardim, only : mx, my, mz, n7, n6
        implicit none
        
        allocate(vaxgLB(1:n7, my, mz, 5))
        allocate(vaxdLB(mx - n6:mx, my, mz, 5))
        allocate(v1xgLB(1:n7, my, mz, 5))
        allocate(v1xdLB(mx - n6:mx, my, mz, 5))
        allocate(v2xgLB(1:n7, my, mz, 5))
        allocate(v2xdLB(mx - n6:mx, my, mz, 5))
        allocate(tixgLB(2:n7, my, mz))
        allocate(tixdLB(mx - n6:mx1, my, mz))
        allocate(vayiLB(mx, 1:n7, mz, 5))
        allocate(vaysLB(mx, my - n6:my, mz, 5))
        allocate(v1yiLB(mx, 1:n7, mz, 5))
        allocate(v1ysLB(mx, my - n6:my, mz, 5))
        allocate(v2yiLB(mx, 1:n7, mz, 5))
        allocate(v2ysLB(mx, my - n6:my, mz, 5))
        allocate(tiyiLB(mx, 2:n7, mz))
        allocate(tiysLB(mx, my - n6:my1, mz))
        allocate(wixgLB(2:n7, 2:n7))
        allocate(wixdLB(mx - n6:mx1, mx - n6:mx1))
        allocate(wiyiLB(2:n7, 2:n7))
        allocate(wiysLB(my - n6:my1, my - n6:my1))
    
    endsubroutine mar_lb_init

endmodule mar_lb
