! mar_ib : mar integrated outputs
! ===============================
module mar_ib
    use mardim
    use marssn
    implicit none
    integer, save :: nbr_call_outice
    integer, save :: itrdIB
    ! OutdyIB : Number of Outputs by Day
    integer, parameter :: OutdyIB = 1
    ! ml : Number of *sigma* levels for atm. var.
    integer, parameter :: ml = 1
    ! mlhh : Number of outputs by Day for the X-hourly output: 8 => every 3h, 24 => every hour
    integer, parameter :: mlhh = 8
    ! mlb : Number of sigma *surface* levels for atm. var. (boundary layer)
    integer, parameter :: mlb = min(3, ml)
    ! mp : Number of *pressure* levels for atm. var.
    integer, parameter :: mp = 5
    ! OutPLevIB : Pressure levels (in hPa)
    real, parameter :: OutPLevIB(mp) = (/850., 700., 600., 500., 200./)
    ! mztq : Number of *height* levels for temperature and humidity
    integer, parameter :: mztq = 2
    ! OutZTQLevIB : Height levels (in m above surface)
    real, parameter :: OutZTQLevIB(mztq) = (/2., 10./)
    ! mzuv : Number of *height* levels for wind
    integer, parameter :: mzuv = 3
    ! OutZUVLevIB : Height levels (in m above surface)
    real, parameter :: OutZUVLevIB(mzuv) = (/2., 10., 100./)
    ! mi : Nbr snow height levels. Initial value: mi = 12
    integer, parameter :: mi = 12 ! 18
    ! OutshIB : Snow height levels (in m)
    !real, parameter :: OutshIB(mi) = (/0.00, 0.0, 0.10, 0.20, 0.30, 0.40, 0.50, &
    !                                  0.65, 0.80, 1.00, 1.50, 2.00, 3.00, 5.00, 7.5, 10.0, 15.0, 20.0/)
     real, parameter :: OutshIB(mi) = (/0.0,0.1,0.2,0.4,0.6,0.8,1.0,2.0,3.0,5.0,10.,15./)
    ! Vertical axis
    ! -------------
    ! dsigmaIB : sigma layer thickness
    real, save :: dsigmaIB(ml)
    ! Surface Mass Balance
    ! --------------------
    ! SIm_IB : Current Snow/Ice Mass (mmWE)
    real, save, allocatable :: SIm_IB(:, :, :)
    ! S_m_IB : Current Snow Mass (mmWE)
    real, save, allocatable :: S_m_IB(:, :, :)
    ! SIh_IB : Current Snow/Ice Height (m)
    real, save, allocatable :: SIh_IB(:, :, :)
    ! S_h_IB : Current Snow Height (m)
    real, save, allocatable :: S_h_IB(:, :, :)
    ! SSh_IB : Current Non-Superimposed H (m)
    real, save, allocatable :: SSh_IB(:, :, :)
    ! wet_IB : Total (mmWE)
    real, save, allocatable :: wet_IB(:, :, :), wet0IB(:, :, :)
    ! wee_IB : water flux (mmWE)
    real, save, allocatable :: wee_IB(:, :, :, :), wee0IB(:, :, :, :)
    ! wem_IB : Melting (mmWE)
    real, save, allocatable :: wem_IB(:, :, :), wem0IB(:, :, :)
    ! wer_IB : Refreezing (mmWE)
    real, save, allocatable :: wer_IB(:, :, :), wer0IB(:, :, :)
    ! weu_IB : Run-off (mmWE)
    real, save, allocatable :: weu_IB(:, :, :), weu0IB(:, :, :)
    ! weo_IB : Run-off (mmWE)
    real, save, allocatable :: weo_IB(:, :, :, :), weo0IB(:, :, :, :)
    ! wec0IB, wel0IB : Canopy/soil water
    real, save, allocatable :: wec0IB(:, :, :), wel0IB(:, :, :)
    ! snf_IB : Atmospheric snowfall (mmWE)
    real, save, allocatable :: snf_IB(:, :, :), snf0IB(:, :, :)
    ! sbl_IB : Atmospheric sublimation (mmWE)
    real, save, allocatable :: sbl_IB(:, :, :), sbl0IB(:, :, :)
    ! qssbl_IB : Atmospheric sublimation ratio (kg/kg)
    real, save, allocatable :: qssbl_IB(:, :, :), qssbl0IB(:, :, :)
    ! dep_IB : Atmospheric condensation (mmWE)
    real, save, allocatable :: dep_IB(:, :, :), dep0IB(:, :, :)
    ! rnf_IB : Atmospheric rainfall (mmWE)
    real, save, allocatable :: rnf_IB(:, :, :), rnf0IB(:, :, :)
    ! evp_IB : Atmospheric evaporation (mmWE)
    real, save, allocatable :: evp_IB(:, :, :), evp0IB(:, :, :)
    ! werr0IB : Rain (mmWE)
    real, save, allocatable :: werr0IB(:, :)
    ! wesf0IB : Snow (mmWE)
    real, save, allocatable :: wesf0IB(:, :)
    ! wecp0IB : Convective precip (mmWE)
    real, save, allocatable :: wecp0IB(:, :)
    ! wero0IB : RunOff (mmWE)
    real, save, allocatable :: wero0IB(:, :)
    ! wecr0IB : Ice crystals (mmWE)
    real, save, allocatable :: wecr0IB(:, :)
    ! wesw0IB : Surface Water (mmWE)
    real, save, allocatable :: wesw0IB(:, :, :)
    ! wei0IB : Bottom Ice Added (mmWE)
    real, save, allocatable :: wei0IB(:, :, :)
    ! weacIB : #BS accu.
    real, save, allocatable :: weacIB(:, :, :), weac0IB(:, :, :)
    ! weerIB : #BS erosion
    real, save, allocatable :: weerIB(:, :, :), weer0IB(:, :, :)
    ! Atmospheric Variables averaged
    ! ------------------------------
    ! mintIB : Min. Temp. (C)
    real, save, allocatable :: mintIB(:, :, :)
    ! maxtIB : Max. Temp. (C)
    real, save, allocatable :: maxtIB(:, :, :)
    ! maxwIB : Max. wind. speed (m/s)
    real, save, allocatable :: maxwIB(:, :, :)
    ! ttIB : Temperature (C)
    real, save, allocatable :: ttIB(:, :, :)
    ! tdIB : Dew Temperature (C)
    real, save, allocatable :: tdIB(:, :, :)
    ! uuIB : x-Wind Speed component (m/s)
    real, save, allocatable :: uuIB(:, :, :)
    ! vvIB : y-Wind Speed component (m/s)
    real, save, allocatable :: vvIB(:, :, :)
    ! uvIB : Horizontal Wind Speed (m/s)
    real, save, allocatable :: uvIB(:, :, :)
    ! wwIB : w-Wind Speed component (cm/s)
    real, save, allocatable :: wwIB(:, :, :)
    ! psigIB : SP x w-Wind Speed (SP Ds/Dt) (kPa/s)
    real, save, allocatable :: psigIB(:, :, :)
    ! wsigIB : w-Wind Speed Dsigma / Dt (1/s)
    real, save, allocatable :: wsigIB(:, :, :)
    ! ruuIB : x-Wind Speed component on regular grid (m/s)
    real, save, allocatable :: ruuIB(:, :, :)
    ! rotuuIB : instantaneous rotated wind on a regular grid (m/s)
    real, save, allocatable :: rotuuIB(:, :, :)
    ! rotvvIB : instantaneous rotated wind on a regular grid (m/s)
    real, save, allocatable :: rotvvIB(:, :, :)
    ! rvvIB : y-Wind Speed component on regular grid (m/s)
    real, save, allocatable :: rvvIB(:, :, :)
    ! ruvIB : Horizontal Wind Speed on regular grid (m/s)
    real, save, allocatable :: ruvIB(:, :, :)
    ! qqIB : Specific Humidity (g/kg)
    real, save, allocatable :: qqIB(:, :, :)
    ! rolvIB : Air specific mass (kg/m3)
    real, save, allocatable :: rolvIB(:, :, :)
    ! rhIB : Specific Humidity (%)
    real, save, allocatable :: rhIB(:, :, :)
    ! zzIB : Model Levels Height (m)
    real, save, allocatable :: zzIB(:, :, :)
    ! smt_IB : Integrated snow mass transport (kg/m)
    real, save, allocatable :: smt_IB(:, :, :)
    real, save, allocatable :: smt0IB(:, :, :)
    ! pddIB : PDD quantity (C)
    real, save, allocatable :: pddIB(:, :)
    ! spIB : Surface Pressure (hPa)
    real, save, allocatable :: spIB(:, :)
    ! slpIB : Sea Surface Pressure (hPa)
    real, save, allocatable :: slpIB(:, :)
    ! ccIB : Cloud cover (-)
    real, save, allocatable :: ccIB(:, :)
    ! cuIB : Cloud cover Up (-)
    real, save, allocatable :: cuIB(:, :)
    ! cmIB : Cloud cover Middle (-)
    real, save, allocatable :: cmIB(:, :)
    ! cdIB : Cloud cover Low (-)
    real, save, allocatable :: cdIB(:, :)
    ! codIB : Cloud Optical Depth (-)
    real, save, allocatable :: codIB(:, :)
    ! qwIB : Cl Dropplets Concent. (kg/kg)
    real, save, allocatable :: qwIB(:, :)
    ! qiIB : Cl Ice Crystals Concent.(kg/kg)
    real, save, allocatable :: qiIB(:, :)
    ! qsIB : Snow Flakes Concent. (kg/kg)
    real, save, allocatable :: qsIB(:, :)
    ! qrIB : Rain Concentration (kg/kg)
    real, save, allocatable :: qrIB(:, :)
    ! water path: old computation [CAa 02/08/2022]
    ! ===========================================
    ! wvpIB : Water Vapour Path (kg/m2) / Old computation [CAa 02/08/2022]
    real, save, allocatable :: wvpIB(:, :)
    ! cwpIB : Condensed Water Path (kg/m2) / Old computation [CAa 02/08/2022]
    real, save, allocatable :: cwpIB(:, :)
    ! iwpIB : Ice Water Path (kg/m2) / Old computation [CAa 02/08/2022]
    real, save, allocatable :: iwpIB(:, :)
    ! water path: standard computation [CAa 02/08/2022]
    ! =================================================
    ! rhodzIB : air density x delta_z
    ! rhodz : rho dz = dp / g = dsigma * SP / g (kg m-2)
    ! rhodz : for staggered grid (usual MAR setting), dsigma = dsigm1
    real, save, allocatable :: rhodzIB(:, :, :)
    ! cloud_liquid_total_content tccl
    ! cloud_ice_total_content tcci
    ! precipitation_liquid_total_content tcpl
    ! precipitation_ice_total_content tcpi
    ! tcwvIB : total content water vapor = Integrated Water Vapor (IWV) or Precipitable Water (prw) (kg/m2) / Standard computation [CAa 02/08/2022]
    real, save, allocatable :: tcwvIB(:, :)
    ! tclcIB : total content of liquid cloud (kg/m2) cloud_liquid_total_content / Standard computation [CAa 02/08/2022]
    real, save, allocatable :: tclcIB(:, :)
    ! tcicIB : total content of ice cloud (kg/m2) cloud_ice_total_content / Standard computation [CAa 02/08/2022]
    real, save, allocatable :: tcicIB(:, :)
    ! tclpIB : total content of liquid precipitation (kg/m2) precipitation_liquid_total_content / Standard computation [CAa 02/08/2022]
    real, save, allocatable :: tclpIB(:, :)
    ! tcipIB : total content of ice precipitation (kg/m2) precipitation_ice_total_content / Standard computation [CAa 02/08/2022]
    real, save, allocatable :: tcipIB(:, :)
    ! =================================================
    ! iwfe : eastward vertically integrated water vapor flux (water vapor * zonal wind)
    ! iwfn : northward vertically integrated water vapor flux (water vapor * meridional wind)
    ! ihfe : eastward vertically integrated heat flux (temperature * zonal wind)
    ! ihfn : northward vertically integrated heat flux (temperature * meridional wind)
    ! pblIB : height of the Primary and Secondary Seeing Layer (m)
    real, save, allocatable :: pblIB(:, :, :)
    ! lccIB : Cloud cover. per vertical level (kg/kg)
    real, save, allocatable :: lccIB(:, :, :)
    ! lqsIB : Snow Part. Concent. per vertical level (kg/kg)
    real, save, allocatable :: lqsIB(:, :, :)
    ! lqiIB : Ice Part. Concent. per vertical level (kg/kg)
    real, save, allocatable :: lqiIB(:, :, :)
    ! lqrIB : Rain Part. Concent. per vertical level (kg/kg)
    real, save, allocatable :: lqrIB(:, :, :)
    ! lqwIB : Water Part. Concent. per vertical level (kg/kg)
    real, save, allocatable :: lqwIB(:, :, :)
    ! qsbIB : Sublimation of Snow Part. per vertical level (kg/kg)
    real, save, allocatable :: qsbIB(:, :, :)
    ! lsbIB : Vert. Integrated Sublimation of Qs (m w.e.)
    real, save, allocatable :: lsbIB(:, :, :)
    ! tkeIB : TKE (m2/s2)
    real, save, allocatable :: tkeIB(:, :, :)
    ! qbrIB : Snow ratio between kb level (~100m) and 0
    real, save, allocatable :: qbrIB(:, :)
    ! swn3DIB : Net SW Rad. per vertical level (W/m2)
    real, save, allocatable :: swn3DIB(:, :, :)
    ! lwn3DIB : Net LW Rad. per vertical level (W/m2)
    real, save, allocatable :: lwn3DIB(:, :, :)
    ! swnc3DIB : Clear-sky Net SW Rad. per vertical level (W/m2)
    real, save, allocatable :: swnc3DIB(:, :, :)
    ! lwnc3DIB : Clear-sky Net LW Rad. per vertical level (W/m2)
    real, save, allocatable :: lwnc3DIB(:, :, :)
    ! cod3DIB : Could Optical Depth per vertical level (-)
    real, save, allocatable :: cod3DIB(:, :, :)
    ! cc3DIB : Could Cover per vertical level (-)
    real, save, allocatable :: cc3DIB(:, :, :)
    ! Atmospheric Variables on surface levels (boundary layer)
    ! -----------------------------------------------
    ! ttbIB : Temperature (C)---------
    real, save, allocatable :: ttbIB(:, :, :)
    ! txbIB : Temperature (C)
    real, save, allocatable :: txbIB(:, :, :)
    ! tnbIB : Temperature (C)
    real, save, allocatable :: tnbIB(:, :, :)
    ! qqbIB : Specific Humidity (g/kg)
    real, save, allocatable :: qqbIB(:, :, :)
    ! uubIB : x-Wind Speed component (m/s)
    real, save, allocatable :: uubIB(:, :, :)
    ! vvbIB : y-Wind Speed component (m/s)
    real, save, allocatable :: vvbIB(:, :, :)
    ! uvbIB : Horizontal Wind Speed (m/s)
    real, save, allocatable :: uvbIB(:, :, :)
    ! zzbIB : Model Levels Height (m)
    real, save, allocatable :: zzbIB(:, :, :)
    ! timehIB : Time
    real, save              :: timehIB(mlhh)
    ! tnh : Minimum temperature         (C)
    real, save, allocatable :: tnh(:, :, :)
    ! txh : Maximum temperature         (C)
    real, save, allocatable :: txh(:, :, :)
    ! tdh : Dewpoint temperature         (C)
    real, save, allocatable :: tdh(:, :, :)
    ! uuh : X-Wind speed component         (m/s)
    real, save, allocatable :: uuh(:, :, :)
    ! vvh : Y-Wind speed component         (m/s)
    real, save, allocatable :: vvh(:, :, :)
    ! slth : Soil temperature         (C)
    real, save, allocatable :: slth(:, :, :)
    ! slqch : Total soil moisture content (g/kg)
    real, save, allocatable :: slqch(:, :, :)
    ! wvph : Water vapor path         (kg/m�)
    real, save, allocatable :: wvph(:, :, :)
    ! cphIB : Convective precipitation (mmWE)
    real, save, allocatable :: cphIB(:, :, :)
    ! cph0IB : Convective precipitation (mmWE)
    real, save, allocatable :: cph0IB(:, :)
    ! wehIB : Evapotranspiration (mmWE)
    real, save, allocatable :: wehIB(:, :, :)
    ! weh0IB : Evapotranspiration (mmWE)
    real, save, allocatable :: weh0IB(:, :, :)
    ! ztdh : Zenithal Tropospheric Delay (m)
    real, save, allocatable :: ztdh(:, :, :)
    ! zhdh : Zenithal Hydrostatic Delay (m)
    real, save, allocatable :: zhdh(:, :, :)
    ! zwdh : Zenithal Wet Delay (m)
    real, save, allocatable :: zwdh(:, :, :)
    ! tmh : Weighted Mean Temperature (C)
    real, save, allocatable :: tmh(:, :, :)
    ! capeh : Convective Av. Pot. Energy (J/kg)
    real, save, allocatable :: capeh(:, :, :)
    ! ssth : Sea Surface Temperature ( )
    real, save, allocatable :: ssth(:, :, :)
    ! sphIB : Surface pressure (hPa)
    real, save, allocatable :: sphIB(:, :, :)
    ! sthIB : Surface temperature (C)
    real, save, allocatable :: sthIB(:, :, :)
    ! tthIB : Temperature (C)
    real, save, allocatable :: tthIB(:, :, :)
    ! txhIB : Temperature (C)
    real, save, allocatable :: txhIB(:, :, :)
    ! txhIB0 : Temperature (C)
    real, save, allocatable :: txhIB0(:, :)
    ! tnhIB : Temperature (C)
    real, save, allocatable :: tnhIB(:, :, :)
    ! tnhIB0 : Temperature (C)
    real, save, allocatable :: tnhIB0(:, :)
    ! qqhIB : Specific Humidity (g/kg)
    real, save, allocatable :: qqhIB(:, :, :)
    ! rhhIB : Relative Humidity (%)
    real, save, allocatable :: rhhIB(:, :, :)    
    ! uuhIB : x-Wind Speed component (m/s)
    real, save, allocatable :: uuhIB(:, :, :)
    ! vvhIB : y-Wind Speed component (m/s)
    real, save, allocatable :: vvhIB(:, :, :)
    ! swdhIB : Shortwave inc. Rad. (W/m2)
    real, save, allocatable :: swdhIB(:, :, :)
    real, save, allocatable :: swuhIB(:, :, :)
    ! lwdhIB : Longwave inc. Rad. (W/m2)
    real, save, allocatable :: lwdhIB(:, :, :)
    ! lwuhIB : Longwave out. Rad. (W/m2)
    real, save, allocatable :: lwuhIB(:, :, :)
    ! shfhIB : Sensible Heat (W/m2)
    real, save, allocatable :: shfhIB(:, :, :)
    ! lhfhIB : Latent Heat (W/m2)
    real, save, allocatable :: lhfhIB(:, :, :)
    ! alhIB : Albedo (temporal mean) (-)
    real, save, allocatable :: alhIB(:, :, :)
    ! prhIB : Precipitation (mmWE)
    real, save, allocatable :: prhIB(:, :, :)
    ! rfhIB : Rainfall (mmWE)
    real, save, allocatable :: rfhIB(:, :, :)
    ! prh0IB : Precipitation (mmWE)
    real, save, allocatable :: prh0IB(:, :)
    ! snfhIB : Snowfall (mmWE)
    real, save, allocatable :: snfhIB(:, :, :)
    ! snfh0IB : Snowfall (mmWE)
    real, save, allocatable :: snfh0IB(:, :)
    ! clhIB : Cloud Fraction (-)
    real, save, allocatable :: clhIB(:, :, :)
    ! mehIB : Surface Melt (mmWE)
    real, save, allocatable :: mehIB(:, :, :)
    ! meh0IB : Surface Melt (mmWE)
    real, save, allocatable :: meh0IB(:, :)
    ! suhIB : Sublimation (mmWE)
    real, save, allocatable :: suhIB(:, :, :)
    ! suh0IB : Sublimation (mmWE)
    real, save, allocatable :: suh0IB(:, :)
    ! ruhIB : Run-off (mmWE)
    real, save, allocatable :: ruhIB(:, :, :)
    ! ruh0IB : Run-off (mmWE)
    real, save, allocatable :: ruh0IB(:, :)
    ! smbhIB : SMB (mmWE)
    real, save, allocatable :: smbhIB(:, :, :)
    ! smbh0IB : SMB (mmWE)
    real, save, allocatable :: smbh0IB(:, :)
    ! swhIB : Surface water (mmWE)
    real, save, allocatable :: swhIB(:, :, :)
    ! swh0IB : Surface water (mmWE)
    real, save, allocatable :: swh0IB(:, :)
    ! lwc1mhIB : Total Liquid Water Content to 1m (kg/m2)
    real, save, allocatable :: lwc1mhIB(:, :, :)
    ! lwc2mhIB : Total Liquid Water Content to 2m (kg/m2)
    real, save, allocatable :: lwc2mhIB(:, :, :)
    ! t5hIB : Temperature at 50m (C)
    real, save, allocatable :: t5hIB(:, :, :)
    ! u5hIB : Wind at 50m (m/s)
    real, save, allocatable :: u5hIB(:, :, :)
    ! v5hIB : Wind at 50m (m/s)
    real, save, allocatable :: v5hIB(:, :, :)
    ! q5hIB : Specific Humidity at 50m (g/kg)
    real, save, allocatable :: q5hIB(:, :, :)
    ! p5hIB : Pressure at 50m (hPa)
    real, save, allocatable :: p5hIB(:, :, :)
    ! Atmospheric Variables averaged on pressure levels
    ! -------------------------------------------------
    ! nbpIB : Count number of valid data on pressure levels
    real, save, allocatable :: nbpIB(:, :, :)
    ! ttpIB : Temperature on pressure levels (C)
    real, save, allocatable :: ttpIB(:, :, :)
    ! qqpIB : Specific Humidity on pressure levels (g/kg)
    real, save, allocatable :: qqpIB(:, :, :)
    ! zzpIB : Model Levels Height on pressure levels (m)
    real, save, allocatable :: zzpIB(:, :, :)
    ! uupIB : x-Wind Speed component on pressure levels (m/s)
    real, save, allocatable :: uupIB(:, :, :)
    ! vvpIB : y-Wind Speed component on pressure levels (m/s)
    real, save, allocatable :: vvpIB(:, :, :)
    ! wwpIB : w-Wind Speed component on pressure levels (m/s)
    real, save, allocatable :: wwpIB(:, :, :)
    ! uvpIB : Horizontal Wind Speed on pressure levels (m/s)
    real, save, allocatable :: uvpIB(:, :, :)
    ! tairDYp : temperature on pressure levels (K)
    real, allocatable :: tairDYp(:, :, :)
    ! gplvDYp : Geopotential on pressure levels (= g z)
    real, allocatable :: gplvDYp(:, :, :)
    ! qvDYp : Specific Humidity on pressure levels (kg/kg)
    real, allocatable :: qvDYp(:, :, :)
    ! uairDYp : x-Wind Speed component on pressure levels (m/s)
    real, allocatable :: uairDYp(:, :, :)
    ! vairDYp : y-Wind Speed component on pressure levels (m/s)
    real, allocatable :: vairDYp(:, :, :)
    ! wairDYp : w-Wind Speed component on pressure levels (m/s)
    real, allocatable :: wairDYp(:, :, :)
    ! Atmospheric Variables averaged on height levels
    ! -----------------------------------------------
    ! ttzIB : Temperature on height levels (C)
    real, save, allocatable :: ttzIB(:, :, :)
    ! qqzIB : Specific Humidity on height levels (g/kg)
    real, save, allocatable :: qqzIB(:, :, :)
    real, save, allocatable :: rhzIB(:, :, :)
    ! uuzIB : x-Wind Speed component on height levels (m/s)
    real, save, allocatable :: uuzIB(:, :, :)
    ! vvzIB : y-Wind Speed component on height levels (m/s)
    real, save, allocatable :: vvzIB(:, :, :)
    ! uvzIB : Horizontal Wind Speed on height levels (m/s)
    real, save, allocatable :: uvzIB(:, :, :)
    ! u2zIB : x-Wind Speed component on height levels (m/s)
    real, save, allocatable :: u2zIB(:, :, :)
    ! v2zIB : y-Wind Speed component on height levels (m/s)
    real, save, allocatable :: v2zIB(:, :, :)
    ! rozIB : Air density on height levels (Ton/m3)
    real, save, allocatable :: rozIB(:, :, :)
    ! ttzIB_0 : Temperature on height levels (C)
    real, allocatable :: ttzIB_0(:, :, :)
    ! qqzIB_0 : Specific Humidity on height levels (g/kg)
    real, allocatable :: qqzIB_0(:, :, :)
    real, allocatable :: rhzIB_0(:, :, :)
    ! uuzIB_0 : x-Wind Speed component on height levels (m/s)
    real, allocatable :: uuzIB_0(:, :, :)
    ! vvzIB_0 : y-Wind Speed component on height levels (m/s)
    real, allocatable :: vvzIB_0(:, :, :)
    ! uvzIB_0 : Horizontal Wind Speed on height levels (m/s)
    real, allocatable :: uvzIB_0(:, :, :)
    ! u2zIB_0 : x-Wind Speed component on height levels (m/s)
    real, allocatable :: u2zIB_0(:, :, :)
    ! v2zIB_0 : y-Wind Speed component on height levels (m/s)
    real, allocatable :: v2zIB_0(:, :, :)
    ! ppzIB_0 : Pressure on height levels (m/s)
    real, allocatable :: ppzIB_0(:, :, :)
    ! rozIB_0 : Air density on height levels (Ton/m3)
    real, allocatable :: rozIB_0(:, :, :)
    ! Surface Variables averaged
    ! --------------------------
    ! swdIB : Shortwave inc. Rad. (W/m2)
    real, save, allocatable :: swdIB(:, :)  ! total
    real, save, allocatable :: swdcIB(:, :) ! clear sky
    real, save, allocatable :: swddIB(:, :) ! direct
    ! swuIB : Shortwave out. Rad. (W/m2)
    real, save, allocatable :: swuIB(:, :)
    ! lwdIB : Longwave inc. Rad. (W/m2)
    real, save, allocatable :: lwdIB(:, :)
    ! lwuIB : Longwave out. Rad. (W/m2)
    real, save, allocatable :: lwuIB(:, :)
    ! sunIB : Sunshine (SWD>120) (s)
    real, save, allocatable :: sunIB(:, :)
    ! swdtIB : TOA Shortwave inc. Rad. (W/m2)
    real, save, allocatable :: swdtIB(:, :)
    ! swutIB : TOA Shortwave out. Rad. (W/m2)
    real, save, allocatable :: swutIB(:, :)
    ! lwutIB : TOA Longwave out. Rad. (W/m2)
    real, save, allocatable :: lwutIB(:, :)
    ! shfIB : Sensible Heat (W/m2)
    real, save, allocatable :: shfIB(:, :)
    ! lhfIB : Latent Heat (W/m2)
    real, save, allocatable :: lhfIB(:, :)
    ! alIB : Albedo (temporal mean) (-)
    real, save, allocatable :: alIB(:, :)
    ! al1IB : Albedo (SW out/SW in) (-)
    real, save, allocatable :: al1IB(:, :, :)
    ! al2IB : Albedo (temporal mean) (-)
    real, save, allocatable :: al2IB(:, :, :)
    ! frvIB : ifraTV (temporal mean) (-)
    real, save, allocatable :: frvIB(:, :, :)
    ! stIB : Surface Temperature (C)
    real, save, allocatable :: stIB(:, :)
    ! st2IB : Surface Temperature (C)
    real, save, allocatable :: st2IB(:, :, :)
    ! z0IB : Roughness length for Moment.(m)
    real, save, allocatable :: z0IB(:, :, :)
    ! r0IB : Roughness length for Heat (m)
    real, save, allocatable :: r0IB(:, :, :)
    ! uusIB : Friction Velocity (m/s)
    real, save, allocatable :: uusIB(:, :, :)
    ! utsIB : Sfc Pot. Tp. Turb. Flux (K.m/s)
    real, save, allocatable :: utsIB(:, :, :)
    ! uqsIB : Water Vapor Flux (kg/kg.m/s)
    real, save, allocatable :: uqsIB(:, :, :)
    ! ussIB : Blowing Snow Flux (kg/kg.m/s)
    real, save, allocatable :: ussIB(:, :, :)
    ! uusthIB : Threshold friction velocity (m/s)
    real, save, allocatable :: uusthIB(:, :, :)
    ! molIB: Moment.Roughn.L.
    real, save, allocatable :: molIB(:, :, :)
    ! sltIB : Soil Temperature (C)
    real, save, allocatable :: sltIB(:, :, :, :)
    ! slqIB : Soil Humidity Content (g/kg)
    real, save, allocatable :: slqIB(:, :, :, :)
    ! slqcIB : Total Soil Humidity Content (g/kg)
    real, save, allocatable :: slqcIB(:, :, :)
    ! slqmIB : Max Soil Humidity Content (g/kg)
    real, save, allocatable :: slqmIB(:, :, :)
    ! sicIB : SIC (-)
    real, save, allocatable :: sicIB(:, :)
    real, save, allocatable :: alb1IB(:, :)
    real, save, allocatable :: as1_IB(:, :)
    real, save, allocatable :: alb2IB(:, :)
    real, save, allocatable :: as2_IB(:, :)
    real, save, allocatable :: alb3IB(:, :)
    real, save, allocatable :: as3_IB(:, :)
    ! *CL*
    real, save, allocatable ::  gradTIB(:, :)
    real, save, allocatable :: maxgrTIB(:, :)
    real, save, allocatable :: mingrTIB(:, :)
    real, save, allocatable ::  gradQIB(:, :)
    real, save, allocatable :: maxgrQIB(:, :)
    real, save, allocatable :: mingrQIB(:, :)
    real, save, allocatable :: tt_intIB(:, :, :)
    real, save, allocatable :: qq_intIB(:, :, :)
    ! Snow pack Variables averaged
    ! ----------------------------
    real, save, allocatable :: agIB(:, :, :, :) ! ag (-)
    real, save, allocatable :: g1IB(:, :, :, :) ! g1 (-)
    real, save, allocatable :: g2IB(:, :, :, :) ! g2 (-)
    real, save, allocatable :: roIB(:, :, :, :) ! Density (kg/m3)
    real, save, allocatable :: tiIB(:, :, :, :) ! Temperature (C)
    real, save, allocatable :: waIB(:, :, :, :) ! Water Content (%)
    real, save, allocatable :: zn0IB(:, :, :), zn1IB(:, :, :) ! Snow Height (m)
    real, save, allocatable :: zn2IB(:, :, :), zn3IB(:, :, :)
    real, save, allocatable :: zn4IB(:, :, :), zn5IB(:, :, :)
    real, save, allocatable :: zn6IB(:, :, :)
    ! mb0IB : Mass Balance (mmWE)
    real, save, allocatable :: mb0IB(:, :, :), mbIB(:, :, :)

    ! Variables averaged from OASIS
    ! -----------------------------
    real, save, allocatable :: st2aoIB(:, :, :)
    real, save, allocatable :: sicaoIB(:, :)
    real, save, allocatable :: albaoIB(:, :, :)
    real, save, allocatable :: sitaoIB(:, :)
    real, save, allocatable :: sntaoIB(:, :)

contains

    subroutine mar_ib_init()

        use mardim, only: mx, my, mz, mzz
        implicit none

        integer i,j,k,m

        allocate(SIm_IB(mx, my, nsx))
        allocate(S_m_IB(mx, my, nsx))
        allocate(SIh_IB(mx, my, nsx))
        allocate(S_h_IB(mx, my, nsx))
        allocate(SSh_IB(mx, my, nsx))
        allocate(wet_IB(mx, my, nsx))
        allocate(wet0IB(mx, my, nsx))
        allocate(wee_IB(mx, my, nsx, 4))
        allocate(wee0IB(mx, my, nsx, 4))
        allocate(wem_IB(mx, my, nsx))
        allocate(wem0IB(mx, my, nsx))
        allocate(wer_IB(mx, my, nsx))
        allocate(wer0IB(mx, my, nsx))
        allocate(weu_IB(mx, my, nsx))
        allocate(weu0IB(mx, my, nsx))
        allocate(weo_IB(mx, my, nsx, 6))
        allocate(weo0IB(mx, my, nsx, 6))
        allocate(wec0IB(mx, my, nsx))
        allocate(wel0IB(mx, my, nsx))
        allocate(snf_IB(mx, my, ml))
        allocate(snf0IB(mx, my, ml))
        allocate(sbl_IB(mx, my, ml))
        allocate(sbl0IB(mx, my, ml))
        allocate(qssbl_IB(mx, my, ml))
        allocate(qssbl0IB(mx, my, ml))
        allocate(dep_IB(mx, my, ml))
        allocate(dep0IB(mx, my, ml))
        allocate(rnf_IB(mx, my, ml))
        allocate(rnf0IB(mx, my, ml))
        allocate(evp_IB(mx, my, ml))
        allocate(evp0IB(mx, my, ml))
        allocate(werr0IB(mx, my))
        allocate(wesf0IB(mx, my))
        allocate(wecp0IB(mx, my))
        allocate(wero0IB(mx, my))
        allocate(wecr0IB(mx, my))
        allocate(wesw0IB(mx, my, nsx))
        allocate(wei0IB(mx, my, nsx))
        allocate(weacIB(mx, my, nsx))
        allocate(weac0IB(mx, my, nsx))
        allocate(weerIB(mx, my, nsx))
        allocate(weer0IB(mx, my, nsx))
        allocate(mintIB(mx, my, ml))
        allocate(maxtIB(mx, my, ml))
        allocate(maxwIB(mx, my, ml))
        allocate(ttIB(mx, my, ml))
        allocate(tdIB(mx, my, ml))
        allocate(uuIB(mx, my, ml))
        allocate(vvIB(mx, my, ml))
        allocate(uvIB(mx, my, ml))
        allocate(wwIB(mx, my, ml))
        allocate(psigIB(mx, my, ml))
        allocate(wsigIB(mx, my, ml))
        allocate(ruuIB(mx, my, ml))
        allocate(rotuuIB(mx, my, mz))
        allocate(rotvvIB(mx, my, mz))
        allocate(rvvIB(mx, my, ml))
        allocate(ruvIB(mx, my, ml))
        allocate(qqIB(mx, my, ml))
        allocate(rolvIB(mx, my, ml))
        allocate(rhIB(mx, my, ml))
        allocate(zzIB(mx, my, ml))
        allocate(smt_IB(mx, my, ml))
        allocate(smt0IB(mx, my, ml))
        allocate(pddIB(mx, my))
        allocate(spIB(mx, my))
        allocate(slpIB(mx, my))
        allocate(ccIB(mx, my))
        allocate(cuIB(mx, my))
        allocate(cmIB(mx, my))
        allocate(cdIB(mx, my))
        allocate(codIB(mx, my))
        allocate(qwIB(mx, my))
        allocate(qiIB(mx, my))
        allocate(qsIB(mx, my))
        allocate(qrIB(mx, my))
        allocate(wvpIB(mx, my))
        allocate(cwpIB(mx, my))
        allocate(iwpIB(mx, my))
        allocate(rhodzIB(mx, my, ml))
        allocate(tcwvIB(mx, my))
        allocate(tclcIB(mx, my))
        allocate(tcicIB(mx, my))
        allocate(tclpIB(mx, my))
        allocate(tcipIB(mx, my))
        allocate(pblIB(mx, my, 3))
        allocate(lccIB(mx, my, ml))
        allocate(lqsIB(mx, my, ml))
        allocate(lqiIB(mx, my, ml))
        allocate(lqrIB(mx, my, ml))
        allocate(lqwIB(mx, my, ml))
        allocate(qsbIB(mx, my, ml))
        allocate(lsbIB(mx, my, ml))
        allocate(tkeIB(mx, my, ml))
        allocate(qbrIB(mx, my))
        allocate(swn3DIB(mx, my, ml))
        allocate(lwn3DIB(mx, my, ml))
        allocate(swnc3DIB(mx, my, ml))
        allocate(lwnc3DIB(mx, my, ml))
        allocate(cod3DIB(mx, my, ml))
        allocate(cc3DIB(mx, my, ml))
        allocate(ttbIB(mx, my, mlb))
        allocate(txbIB(mx, my, mlb))
        allocate(tnbIB(mx, my, mlb))
        allocate(qqbIB(mx, my, mlb))
        allocate(uubIB(mx, my, mlb))
        allocate(vvbIB(mx, my, mlb))
        allocate(uvbIB(mx, my, mlb))
        allocate(zzbIB(mx, my, mlb))
        allocate(tnh(mx, my, mlhh))
        allocate(txh(mx, my, mlhh))
        allocate(tdh(mx, my, mlhh))
        allocate(uuh(mx, my, mlhh))
        allocate(vvh(mx, my, mlhh))
        allocate(slth(mx, my, mlhh))
        allocate(slqch(mx, my, mlhh))
        allocate(wvph(mx, my, mlhh))
        allocate(cphIB(mx, my, mlhh))
        allocate(cph0IB(mx, my))
        allocate(wehIB(mx, my, mlhh))
        allocate(weh0IB(mx, my, nsx))
        allocate(ztdh(mx, my, mlhh))
        allocate(zhdh(mx, my, mlhh))
        allocate(zwdh(mx, my, mlhh))
        allocate(tmh(mx, my, mlhh))
        allocate(capeh(mx, my, mlhh))
        allocate(ssth(mx, my, mlhh))
        allocate(sphIB(mx, my, mlhh))
        allocate(sthIB(mx, my, mlhh))
        allocate(tthIB(mx, my, mlhh))
        allocate(txhIB(mx, my, mlhh))
        allocate(txhIB0(mx, my))
        allocate(tnhIB(mx, my, mlhh))
        allocate(tnhIB0(mx, my))
        allocate(qqhIB(mx, my, mlhh))
        allocate(rhhIB(mx, my, mlhh))
        allocate(uuhIB(mx, my, mlhh))
        allocate(vvhIB(mx, my, mlhh))
        allocate(swdhIB(mx, my, mlhh))
        allocate(swuhIB(mx, my, mlhh))
        allocate(lwdhIB(mx, my, mlhh))
        allocate(lwuhIB(mx, my, mlhh))
        allocate(shfhIB(mx, my, mlhh))
        allocate(lhfhIB(mx, my, mlhh))
        allocate(alhIB(mx, my, mlhh))
        allocate(prhIB(mx, my, mlhh))
        allocate(rfhIB(mx, my, mlhh))
        allocate(prh0IB(mx, my))
        allocate(snfhIB(mx, my, mlhh))
        allocate(snfh0IB(mx, my))
        allocate(clhIB(mx, my, mlhh))
        allocate(mehIB(mx, my, mlhh))
        allocate(meh0IB(mx, my))
        allocate(suhIB(mx, my, mlhh))
        allocate(suh0IB(mx, my))
        allocate(ruhIB(mx, my, mlhh))
        allocate(ruh0IB(mx, my))
        allocate(smbhIB(mx, my, mlhh))
        allocate(smbh0IB(mx, my))
        allocate(swhIB(mx, my, mlhh))
        allocate(swh0IB(mx, my))
        allocate(lwc1mhIB(mx, my, mlhh))
        allocate(lwc2mhIB(mx, my, mlhh))
        allocate(t5hIB(mx, my, mlhh))
        allocate(u5hIB(mx, my, mlhh))
        allocate(v5hIB(mx, my, mlhh))
        allocate(q5hIB(mx, my, mlhh))
        allocate(p5hIB(mx, my, mlhh))
        allocate(nbpIB(mx, my, mp))
        allocate(ttpIB(mx, my, mp))
        allocate(qqpIB(mx, my, mp))
        allocate(zzpIB(mx, my, mp))
        allocate(uupIB(mx, my, mp))
        allocate(vvpIB(mx, my, mp))
        allocate(wwpIB(mx, my, mp))
        allocate(uvpIB(mx, my, mp))
        allocate(tairDYp(mx, my, mp))
        allocate(gplvDYp(mx, my, mp))
        allocate(qvDYp(mx, my, mp))
        allocate(uairDYp(mx, my, mp))
        allocate(vairDYp(mx, my, mp))
        allocate(wairDYp(mx, my, mp))
        allocate(ttzIB(mx, my, mztq))
        allocate(qqzIB(mx, my, mztq))
        allocate(rhzIB(mx, my, mztq))
        allocate(uuzIB(mx, my, mzuv))
        allocate(vvzIB(mx, my, mzuv))
        allocate(uvzIB(mx, my, mzuv))
        allocate(u2zIB(mx, my, mzuv))
        allocate(v2zIB(mx, my, mzuv))
        allocate(rozIB(mx, my, mzuv))
        allocate(ttzIB_0(mx, my, mztq))
        allocate(qqzIB_0(mx, my, mztq))
        allocate(rhzIB_0(mx, my, mztq))
        allocate(uuzIB_0(mx, my, mzuv))
        allocate(vvzIB_0(mx, my, mzuv))
        allocate(uvzIB_0(mx, my, mzuv))
        allocate(u2zIB_0(mx, my, mzuv))
        allocate(v2zIB_0(mx, my, mzuv))
        allocate(ppzIB_0(mx, my, mztq))
        allocate(rozIB_0(mx, my, mzuv))
        allocate(swdIB(mx, my))
        allocate(swdcIB(mx, my))
        allocate(swddIB(mx, my))
        allocate(swdtIB(mx, my))
        allocate(swuIB(mx, my))
        allocate(lwdIB(mx, my))
        allocate(lwuIB(mx, my))
        allocate(sunIB(mx, my))
        allocate(swutIB(mx, my))
        allocate(lwutIB(mx, my))
        allocate(shfIB(mx, my))
        allocate(lhfIB(mx, my))
        allocate(alIB(mx, my))
        allocate(al1IB(mx, my, nsx))
        allocate(al2IB(mx, my, nsx))
        allocate(frvIB(mx, my, nsx))
        allocate(stIB(mx, my))
        allocate(st2IB(mx, my, nsx))
        allocate(z0IB(mx, my, nsx))
        allocate(r0IB(mx, my, nsx))
        allocate(uusIB(mx, my, nsx))
        allocate(utsIB(mx, my, nsx))
        allocate(uqsIB(mx, my, nsx))
        allocate(ussIB(mx, my, nsx))
        allocate(uusthIB(mx, my, nsx))
        allocate(molIB(mx, my, nsx))
        allocate(sltIB(mx, my, nsx, nsol + 1))
        allocate(slqIB(mx, my, nsx, nsol + 1))
        allocate(slqcIB(mx, my, nsx))
        allocate(slqmIB(mx, my, nsx))
        allocate(sicIB(mx, my))
        allocate(alb1IB(mx, my))
        allocate(as1_IB(mx, my))
        allocate(alb2IB(mx, my))
        allocate(as2_IB(mx, my))
        allocate(alb3IB(mx, my))
        allocate(as3_IB(mx, my))
        allocate(gradTIB(mx, my))
        allocate(maxgrTIB(mx, my))
        allocate(mingrTIB(mx, my))
        allocate(gradQIB(mx, my))
        allocate(maxgrQIB(mx, my))
        allocate(mingrQIB(mx, my))
        allocate(tt_intIB(mx, my, mw))
        allocate(qq_intIB(mx, my, mw))
        allocate(agIB(mx, my, nsx, mi))
        allocate(g1IB(mx, my, nsx, mi))
        allocate(g2IB(mx, my, nsx, mi))
        allocate(roIB(mx, my, nsx, mi))
        allocate(tiIB(mx, my, nsx, mi))
        allocate(waIB(mx, my, nsx, mi))
        allocate(zn0IB(mx, my, nsx))
        allocate(zn1IB(mx, my, nsx))
        allocate(zn2IB(mx, my, nsx))
        allocate(zn3IB(mx, my, nsx))
        allocate(zn4IB(mx, my, nsx))
        allocate(zn5IB(mx, my, nsx))
        allocate(zn6IB(mx, my, nsx))
        allocate(mb0IB(mx, my, nsx))
        allocate(mbIB(mx, my, nsx))
        allocate(st2aoIB(mx, my, nsx))
        allocate(sicaoIB(mx, my))
        allocate(albaoIB(mx, my, nsx))
        allocate(sitaoIB(mx, my))
        allocate(sntaoIB(mx, my))

    endsubroutine mar_ib_init

endmodule mar_ib
